// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114524){
var state_val_114525 = (state_114524[(1)]);
if((state_val_114525 === (1))){
var state_114524__$1 = state_114524;
var statearr_114526_114533 = state_114524__$1;
(statearr_114526_114533[(2)] = null);

(statearr_114526_114533[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114525 === (2))){
var inst_114522 = (state_114524[(2)]);
var state_114524__$1 = state_114524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114524__$1,inst_114522);
} else {
if((state_val_114525 === (3))){
var inst_114512 = (state_114524[(2)]);
var state_114524__$1 = state_114524;
var statearr_114527_114534 = state_114524__$1;
(statearr_114527_114534[(2)] = inst_114512);


cljs.core.async.impl.ioc_helpers.process_exception(state_114524__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114525 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114524,(3),Error,null,(2));
var inst_114516 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_114524__$1 = state_114524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114524__$1,(5),inst_114516);
} else {
if((state_val_114525 === (5))){
var inst_114518 = (state_114524[(2)]);
var inst_114519 = fluree.db.util.async.throw_err(inst_114518);
var inst_114520 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_114519);
var state_114524__$1 = state_114524;
var statearr_114528_114535 = state_114524__$1;
(statearr_114528_114535[(2)] = inst_114520);


cljs.core.async.impl.ioc_helpers.process_exception(state_114524__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____0 = (function (){
var statearr_114529 = [null,null,null,null,null,null,null];
(statearr_114529[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__);

(statearr_114529[(1)] = (1));

return statearr_114529;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____1 = (function (state_114524){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114524);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114530){if((e114530 instanceof Object)){
var ex__109974__auto__ = e114530;
var statearr_114531_114536 = state_114524;
(statearr_114531_114536[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114524);

return cljs.core.cst$kw$recur;
} else {
throw e114530;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114537 = state_114524;
state_114524 = G__114537;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__ = function(state_114524){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____1.call(this,state_114524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114532 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114532[(6)] = c__110077__auto__);

return statearr_114532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114566){
var state_val_114567 = (state_114566[(1)]);
if((state_val_114567 === (7))){
var inst_114551 = (state_114566[(7)]);
var state_114566__$1 = state_114566;
var statearr_114568_114585 = state_114566__$1;
(statearr_114568_114585[(2)] = inst_114551);

(statearr_114568_114585[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (1))){
var state_114566__$1 = state_114566;
var statearr_114569_114586 = state_114566__$1;
(statearr_114569_114586[(2)] = null);

(statearr_114569_114586[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114566,(3),Error,null,(2));
var inst_114543 = (function (){return ((function (_,state_val_114567,c__110077__auto__){
return (function (p1__114538_SHARP_){
return p1__114538_SHARP_.o;
});
;})(_,state_val_114567,c__110077__auto__))
})();
var inst_114544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114545 = [pred_id];
var inst_114546 = (new cljs.core.PersistentVector(null,1,(5),inst_114544,inst_114545,null));
var inst_114547 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_114546);
var state_114566__$1 = (function (){var statearr_114570 = state_114566;
(statearr_114570[(8)] = inst_114543);

return statearr_114570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114566__$1,(5),inst_114547);
} else {
if((state_val_114567 === (6))){
var inst_114551 = (state_114566[(7)]);
var inst_114553 = cljs.core.empty_QMARK_(inst_114551);
var inst_114554 = (!(inst_114553));
var state_114566__$1 = state_114566;
var statearr_114571_114587 = state_114566__$1;
(statearr_114571_114587[(2)] = inst_114554);

(statearr_114571_114587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (3))){
var inst_114539 = (state_114566[(2)]);
var state_114566__$1 = state_114566;
var statearr_114572_114588 = state_114566__$1;
(statearr_114572_114588[(2)] = inst_114539);


cljs.core.async.impl.ioc_helpers.process_exception(state_114566__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (2))){
var inst_114564 = (state_114566[(2)]);
var state_114566__$1 = state_114566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114566__$1,inst_114564);
} else {
if((state_val_114567 === (11))){
var inst_114562 = (state_114566[(2)]);
var state_114566__$1 = state_114566;
var statearr_114573_114589 = state_114566__$1;
(statearr_114573_114589[(2)] = inst_114562);


cljs.core.async.impl.ioc_helpers.process_exception(state_114566__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (9))){
var inst_114551 = (state_114566[(7)]);
var inst_114559 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_114551);
var state_114566__$1 = state_114566;
var statearr_114574_114590 = state_114566__$1;
(statearr_114574_114590[(2)] = inst_114559);

(statearr_114574_114590[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (5))){
var inst_114551 = (state_114566[(7)]);
var inst_114543 = (state_114566[(8)]);
var inst_114549 = (state_114566[(2)]);
var inst_114550 = fluree.db.util.async.throw_err(inst_114549);
var inst_114551__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_114543,inst_114550);
var state_114566__$1 = (function (){var statearr_114575 = state_114566;
(statearr_114575[(7)] = inst_114551__$1);

return statearr_114575;
})();
if(cljs.core.truth_(inst_114551__$1)){
var statearr_114576_114591 = state_114566__$1;
(statearr_114576_114591[(1)] = (6));

} else {
var statearr_114577_114592 = state_114566__$1;
(statearr_114577_114592[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (10))){
var state_114566__$1 = state_114566;
var statearr_114578_114593 = state_114566__$1;
(statearr_114578_114593[(2)] = true);

(statearr_114578_114593[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114567 === (8))){
var inst_114557 = (state_114566[(2)]);
var state_114566__$1 = state_114566;
if(cljs.core.truth_(inst_114557)){
var statearr_114579_114594 = state_114566__$1;
(statearr_114579_114594[(1)] = (9));

} else {
var statearr_114580_114595 = state_114566__$1;
(statearr_114580_114595[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_114581 = [null,null,null,null,null,null,null,null,null];
(statearr_114581[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__);

(statearr_114581[(1)] = (1));

return statearr_114581;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____1 = (function (state_114566){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114566);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114582){if((e114582 instanceof Object)){
var ex__109974__auto__ = e114582;
var statearr_114583_114596 = state_114566;
(statearr_114583_114596[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114566);

return cljs.core.cst$kw$recur;
} else {
throw e114582;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114597 = state_114566;
state_114566 = G__114597;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__ = function(state_114566){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____1.call(this,state_114566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114584 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114584[(6)] = c__110077__auto__);

return statearr_114584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114671){
var state_val_114672 = (state_114671[(1)]);
if((state_val_114672 === (7))){
var inst_114622 = (state_114671[(7)]);
var state_114671__$1 = state_114671;
var statearr_114673_114700 = state_114671__$1;
(statearr_114673_114700[(2)] = inst_114622);

(statearr_114673_114700[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (1))){
var state_114671__$1 = state_114671;
var statearr_114674_114701 = state_114671__$1;
(statearr_114674_114701[(2)] = null);

(statearr_114674_114701[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114671,(3),Error,null,(2));
var inst_114604 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_114605 = cljs.core.PersistentHashSet.EMPTY;
var inst_114606 = cljs.core.vals(tempids);
var inst_114607 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114605,inst_114606);
var inst_114608 = (function (){var pred_flakes = inst_114604;
var is_new_QMARK_ = inst_114607;
return ((function (pred_flakes,is_new_QMARK_,_,inst_114604,inst_114605,inst_114606,inst_114607,state_val_114672,c__110077__auto__){
return (function (p1__114598_SHARP_,p2__114599_SHARP_){
return cljs.core.assoc_in(p1__114598_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__114599_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__114675 = p2__114599_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__114675) : is_new_QMARK_.call(null,G__114675));
})()));
});
;})(pred_flakes,is_new_QMARK_,_,inst_114604,inst_114605,inst_114606,inst_114607,state_val_114672,c__110077__auto__))
})();
var inst_114609 = cljs.core.PersistentHashMap.EMPTY;
var inst_114610 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_114608,inst_114609,inst_114604);
var inst_114618 = cljs.core.seq(inst_114604);
var inst_114619 = cljs.core.first(inst_114618);
var inst_114620 = cljs.core.next(inst_114618);
var inst_114621 = inst_114604;
var inst_114622 = inst_114610;
var state_114671__$1 = (function (){var statearr_114676 = state_114671;
(statearr_114676[(8)] = inst_114620);

(statearr_114676[(9)] = inst_114621);

(statearr_114676[(10)] = inst_114619);

(statearr_114676[(7)] = inst_114622);

return statearr_114676;
})();
var statearr_114677_114702 = state_114671__$1;
(statearr_114677_114702[(2)] = null);

(statearr_114677_114702[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (15))){
var inst_114648 = (state_114671[(11)]);
var inst_114635 = (state_114671[(12)]);
var inst_114628 = (state_114671[(13)]);
var inst_114622 = (state_114671[(7)]);
var inst_114656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114657 = inst_114628.s;
var inst_114658 = [inst_114657,inst_114635,cljs.core.cst$kw$new];
var inst_114659 = (new cljs.core.PersistentVector(null,3,(5),inst_114656,inst_114658,null));
var inst_114660 = cljs.core.assoc_in(inst_114622,inst_114659,inst_114648);
var state_114671__$1 = state_114671;
var statearr_114678_114703 = state_114671__$1;
(statearr_114678_114703[(2)] = inst_114660);

(statearr_114678_114703[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (13))){
var inst_114643 = (state_114671[(2)]);
var inst_114644 = fluree.db.util.async.throw_err(inst_114643);
var state_114671__$1 = state_114671;
var statearr_114679_114704 = state_114671__$1;
(statearr_114679_114704[(2)] = inst_114644);

(statearr_114679_114704[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (6))){
var inst_114667 = (state_114671[(2)]);
var state_114671__$1 = state_114671;
var statearr_114680_114705 = state_114671__$1;
(statearr_114680_114705[(2)] = inst_114667);


cljs.core.async.impl.ioc_helpers.process_exception(state_114671__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (3))){
var inst_114600 = (state_114671[(2)]);
var state_114671__$1 = state_114671;
var statearr_114681_114706 = state_114671__$1;
(statearr_114681_114706[(2)] = inst_114600);


cljs.core.async.impl.ioc_helpers.process_exception(state_114671__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (12))){
var inst_114637 = (state_114671[(14)]);
var inst_114648 = (state_114671[(2)]);
var state_114671__$1 = (function (){var statearr_114682 = state_114671;
(statearr_114682[(11)] = inst_114648);

return statearr_114682;
})();
if(cljs.core.truth_(inst_114637)){
var statearr_114683_114707 = state_114671__$1;
(statearr_114683_114707[(1)] = (14));

} else {
var statearr_114684_114708 = state_114671__$1;
(statearr_114684_114708[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (2))){
var inst_114669 = (state_114671[(2)]);
var state_114671__$1 = state_114671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114671__$1,inst_114669);
} else {
if((state_val_114672 === (11))){
var inst_114628 = (state_114671[(13)]);
var inst_114646 = inst_114628.o;
var state_114671__$1 = state_114671;
var statearr_114685_114709 = state_114671__$1;
(statearr_114685_114709[(2)] = inst_114646);

(statearr_114685_114709[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (9))){
var inst_114665 = (state_114671[(2)]);
var state_114671__$1 = state_114671;
var statearr_114686_114710 = state_114671__$1;
(statearr_114686_114710[(2)] = inst_114665);

(statearr_114686_114710[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (5))){
var inst_114621 = (state_114671[(9)]);
var inst_114628 = (state_114671[(13)]);
var inst_114627 = cljs.core.seq(inst_114621);
var inst_114628__$1 = cljs.core.first(inst_114627);
var inst_114629 = cljs.core.next(inst_114627);
var inst_114630 = cljs.core.not(inst_114628__$1);
var state_114671__$1 = (function (){var statearr_114687 = state_114671;
(statearr_114687[(13)] = inst_114628__$1);

(statearr_114687[(15)] = inst_114629);

return statearr_114687;
})();
if(inst_114630){
var statearr_114688_114711 = state_114671__$1;
(statearr_114688_114711[(1)] = (7));

} else {
var statearr_114689_114712 = state_114671__$1;
(statearr_114689_114712[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (14))){
var inst_114648 = (state_114671[(11)]);
var inst_114635 = (state_114671[(12)]);
var inst_114628 = (state_114671[(13)]);
var inst_114622 = (state_114671[(7)]);
var inst_114650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114651 = inst_114628.s;
var inst_114652 = [inst_114651,inst_114635,cljs.core.cst$kw$old];
var inst_114653 = (new cljs.core.PersistentVector(null,3,(5),inst_114650,inst_114652,null));
var inst_114654 = cljs.core.assoc_in(inst_114622,inst_114653,inst_114648);
var state_114671__$1 = state_114671;
var statearr_114690_114713 = state_114671__$1;
(statearr_114690_114713[(2)] = inst_114654);

(statearr_114690_114713[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (16))){
var inst_114629 = (state_114671[(15)]);
var inst_114662 = (state_114671[(2)]);
var inst_114621 = inst_114629;
var inst_114622 = inst_114662;
var state_114671__$1 = (function (){var statearr_114691 = state_114671;
(statearr_114691[(9)] = inst_114621);

(statearr_114691[(7)] = inst_114622);

return statearr_114691;
})();
var statearr_114692_114714 = state_114671__$1;
(statearr_114692_114714[(2)] = null);

(statearr_114692_114714[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114672 === (10))){
var inst_114628 = (state_114671[(13)]);
var inst_114640 = inst_114628.o;
var inst_114641 = fluree.db.query.schema.convert_type_to_kw(inst_114640,db);
var state_114671__$1 = state_114671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114671__$1,(13),inst_114641);
} else {
if((state_val_114672 === (8))){
var inst_114635 = (state_114671[(12)]);
var inst_114628 = (state_114671[(13)]);
var inst_114633 = inst_114628.p;
var inst_114634 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_114633);
var inst_114635__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_114634);
var inst_114636 = inst_114628.op;
var inst_114637 = inst_114636 === false;
var inst_114638 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_114635__$1);
var state_114671__$1 = (function (){var statearr_114693 = state_114671;
(statearr_114693[(12)] = inst_114635__$1);

(statearr_114693[(14)] = inst_114637);

return statearr_114693;
})();
if(inst_114638){
var statearr_114694_114715 = state_114671__$1;
(statearr_114694_114715[(1)] = (10));

} else {
var statearr_114695_114716 = state_114671__$1;
(statearr_114695_114716[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____0 = (function (){
var statearr_114696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114696[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__);

(statearr_114696[(1)] = (1));

return statearr_114696;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____1 = (function (state_114671){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114671);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114697){if((e114697 instanceof Object)){
var ex__109974__auto__ = e114697;
var statearr_114698_114717 = state_114671;
(statearr_114698_114717[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114671);

return cljs.core.cst$kw$recur;
} else {
throw e114697;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114718 = state_114671;
state_114671 = G__114718;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__ = function(state_114671){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____1.call(this,state_114671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114699 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114699[(6)] = c__110077__auto__);

return statearr_114699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__114720 = arguments.length;
switch (G__114720) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
});

fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
});

fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4;

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__114723 = arguments.length;
switch (G__114723) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
});

fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115027){
var state_val_115028 = (state_115027[(1)]);
if((state_val_115028 === (65))){
var inst_114891 = (state_115027[(7)]);
var state_115027__$1 = state_115027;
var G__115029_115194 = inst_114891;
var G__115029_115195__$1 = (((G__115029_115194 instanceof cljs.core.Keyword))?G__115029_115194.fqn:null);
switch (G__115029_115195__$1) {
case "long":
var statearr_115030_115197 = state_115027__$1;
(statearr_115030_115197[(1)] = (69));


break;
case "bigint":
var statearr_115031_115198 = state_115027__$1;
(statearr_115031_115198[(1)] = (73));


break;
case "double":
var statearr_115032_115199 = state_115027__$1;
(statearr_115032_115199[(1)] = (77));


break;
case "float":
var statearr_115033_115200 = state_115027__$1;
(statearr_115033_115200[(1)] = (81));


break;
case "bigdec":
var statearr_115034_115201 = state_115027__$1;
(statearr_115034_115201[(1)] = (85));


break;
case "string":
var statearr_115035_115202 = state_115027__$1;
(statearr_115035_115202[(1)] = (89));


break;
case "instant":
var statearr_115036_115203 = state_115027__$1;
(statearr_115036_115203[(1)] = (93));


break;
default:
var statearr_115037_115204 = state_115027__$1;
(statearr_115037_115204[(1)] = (97));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (70))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115038_115205 = state_115027__$1;
(statearr_115038_115205[(2)] = inst_114858);

(statearr_115038_115205[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (62))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114900 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115039_115206 = state_115027__$1;
(statearr_115039_115206[(2)] = inst_114900);

(statearr_115039_115206[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (74))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115040_115207 = state_115027__$1;
(statearr_115040_115207[(2)] = inst_114858);

(statearr_115040_115207[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (7))){
var inst_114747 = (state_115027[(10)]);
var state_115027__$1 = state_115027;
var statearr_115041_115208 = state_115027__$1;
(statearr_115041_115208[(2)] = inst_114747);

(statearr_115041_115208[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (59))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115042_115209 = state_115027__$1;
(statearr_115042_115209[(2)] = inst_114858);

(statearr_115042_115209[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (86))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115043_115210 = state_115027__$1;
(statearr_115043_115210[(2)] = inst_114858);

(statearr_115043_115210[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (20))){
var inst_114782 = (state_115027[(11)]);
var state_115027__$1 = state_115027;
var statearr_115044_115211 = state_115027__$1;
(statearr_115044_115211[(2)] = inst_114782);

(statearr_115044_115211[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (72))){
var inst_114911 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115045_115212 = state_115027__$1;
(statearr_115045_115212[(2)] = inst_114911);

(statearr_115045_115212[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (58))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114889 = (state_115027[(2)]);
var inst_114890__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_114889,cljs.core.cst$kw$old);
var inst_114891__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_114889,cljs.core.cst$kw$new);
var inst_114892 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_114891__$1,inst_114890__$1);
var state_115027__$1 = (function (){var statearr_115046 = state_115027;
(statearr_115046[(9)] = inst_114890__$1);

(statearr_115046[(7)] = inst_114891__$1);

return statearr_115046;
})();
if(inst_114892){
var statearr_115047_115213 = state_115027__$1;
(statearr_115047_115213[(1)] = (59));

} else {
var statearr_115048_115214 = state_115027__$1;
(statearr_115048_115214[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (60))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114895 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_114896 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_114895,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,3,inst_114895,null));
var inst_114897 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114896,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114896,null));
var inst_114898 = (inst_114897.cljs$core$IFn$_invoke$arity$1 ? inst_114897.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114897.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114898)){
var statearr_115049_115215 = state_115027__$1;
(statearr_115049_115215[(1)] = (62));

} else {
var statearr_115050_115216 = state_115027__$1;
(statearr_115050_115216[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (27))){
var inst_114808 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115051_115217 = state_115027__$1;
(statearr_115051_115217[(2)] = inst_114808);

(statearr_115051_115217[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (1))){
var state_115027__$1 = state_115027;
var statearr_115052_115218 = state_115027__$1;
(statearr_115052_115218[(2)] = null);

(statearr_115052_115218[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (69))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114903 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_114904 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_114903,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,2,inst_114903,null));
var inst_114905 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114904,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114904,null));
var inst_114906 = (inst_114905.cljs$core$IFn$_invoke$arity$1 ? inst_114905.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114905.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114906)){
var statearr_115053_115219 = state_115027__$1;
(statearr_115053_115219[(1)] = (70));

} else {
var statearr_115054_115220 = state_115027__$1;
(statearr_115054_115220[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (101))){
var inst_114759 = (state_115027[(12)]);
var inst_114992 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114993 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114992);
var inst_114994 = inst_114993 === true;
var inst_114995 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114996 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114995);
var inst_114997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_114996);
var inst_114998 = (!(inst_114997));
var inst_114999 = ((inst_114994) && (inst_114998));
var state_115027__$1 = state_115027;
var statearr_115055_115221 = state_115027__$1;
(statearr_115055_115221[(2)] = inst_114999);

(statearr_115055_115221[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (24))){
var inst_114812 = (state_115027[(13)]);
var inst_114759 = (state_115027[(12)]);
var inst_114811 = (state_115027[(2)]);
var inst_114812__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115056 = state_115027;
(statearr_115056[(14)] = inst_114811);

(statearr_115056[(13)] = inst_114812__$1);

return statearr_115056;
})();
if(cljs.core.truth_(inst_114812__$1)){
var statearr_115057_115222 = state_115027__$1;
(statearr_115057_115222[(1)] = (28));

} else {
var statearr_115058_115223 = state_115027__$1;
(statearr_115058_115223[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (102))){
var inst_114990 = (state_115027[(15)]);
var state_115027__$1 = state_115027;
var statearr_115059_115224 = state_115027__$1;
(statearr_115059_115224[(2)] = inst_114990);

(statearr_115059_115224[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (55))){
var inst_114881 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115060_115225 = state_115027__$1;
(statearr_115060_115225[(2)] = inst_114881);

(statearr_115060_115225[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (85))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114943 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_114944 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_114943,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,5,inst_114943,null));
var inst_114945 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114944,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114944,null));
var inst_114946 = (inst_114945.cljs$core$IFn$_invoke$arity$1 ? inst_114945.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114945.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114946)){
var statearr_115061_115226 = state_115027__$1;
(statearr_115061_115226[(1)] = (86));

} else {
var statearr_115062_115227 = state_115027__$1;
(statearr_115062_115227[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (39))){
var inst_114827 = (state_115027[(16)]);
var state_115027__$1 = state_115027;
var statearr_115063_115228 = state_115027__$1;
(statearr_115063_115228[(2)] = inst_114827);

(statearr_115063_115228[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (88))){
var inst_114951 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115064_115229 = state_115027__$1;
(statearr_115064_115229[(2)] = inst_114951);

(statearr_115064_115229[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (46))){
var inst_114865 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114865)){
var statearr_115065_115230 = state_115027__$1;
(statearr_115065_115230[(1)] = (47));

} else {
var statearr_115066_115231 = state_115027__$1;
(statearr_115066_115231[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115027,(3),Error,null,(2));
var inst_114741 = cljs.core.seq(pred_changes);
var inst_114742 = cljs.core.first(inst_114741);
var inst_114743 = cljs.core.next(inst_114741);
var inst_114744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114742,(0),null);
var inst_114745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114742,(1),null);
var inst_114746 = pred_changes;
var inst_114747 = db;
var state_115027__$1 = (function (){var statearr_115067 = state_115027;
(statearr_115067[(17)] = inst_114743);

(statearr_115067[(18)] = inst_114745);

(statearr_115067[(19)] = inst_114744);

(statearr_115067[(10)] = inst_114747);

(statearr_115067[(20)] = inst_114746);

return statearr_115067;
})();
var statearr_115068_115232 = state_115027__$1;
(statearr_115068_115232[(2)] = null);

(statearr_115068_115232[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (77))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114923 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_114924 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_114923,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,3,inst_114923,null));
var inst_114925 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114924,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114924,null));
var inst_114926 = (inst_114925.cljs$core$IFn$_invoke$arity$1 ? inst_114925.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114925.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114926)){
var statearr_115069_115233 = state_115027__$1;
(statearr_115069_115233[(1)] = (78));

} else {
var statearr_115070_115234 = state_115027__$1;
(statearr_115070_115234[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (106))){
var inst_114757 = (state_115027[(21)]);
var inst_115018 = (state_115027[(2)]);
var inst_114746 = inst_114757;
var inst_114747 = inst_115018;
var state_115027__$1 = (function (){var statearr_115071 = state_115027;
(statearr_115071[(10)] = inst_114747);

(statearr_115071[(20)] = inst_114746);

return statearr_115071;
})();
var statearr_115072_115235 = state_115027__$1;
(statearr_115072_115235[(2)] = null);

(statearr_115072_115235[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (95))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114969 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115073_115236 = state_115027__$1;
(statearr_115073_115236[(2)] = inst_114969);

(statearr_115073_115236[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (54))){
var state_115027__$1 = state_115027;
var statearr_115074_115237 = state_115027__$1;
(statearr_115074_115237[(2)] = false);

(statearr_115074_115237[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (92))){
var inst_114961 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115075_115238 = state_115027__$1;
(statearr_115075_115238[(2)] = inst_114961);

(statearr_115075_115238[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (104))){
var state_115027__$1 = state_115027;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_115076_115239 = state_115027__$1;
(statearr_115076_115239[(1)] = (107));

} else {
var statearr_115077_115240 = state_115027__$1;
(statearr_115077_115240[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (15))){
var inst_114780 = (state_115027[(22)]);
var inst_114759 = (state_115027[(12)]);
var inst_114779 = (state_115027[(2)]);
var inst_114780__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115078 = state_115027;
(statearr_115078[(23)] = inst_114779);

(statearr_115078[(22)] = inst_114780__$1);

return statearr_115078;
})();
if(cljs.core.truth_(inst_114780__$1)){
var statearr_115079_115241 = state_115027__$1;
(statearr_115079_115241[(1)] = (16));

} else {
var statearr_115080_115242 = state_115027__$1;
(statearr_115080_115242[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (48))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115081_115243 = state_115027__$1;
(statearr_115081_115243[(2)] = inst_114858);

(statearr_115081_115243[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (50))){
var inst_114868 = (state_115027[(24)]);
var inst_114873 = inst_114868.cljs$lang$protocol_mask$partition0$;
var inst_114874 = (inst_114873 & (64));
var inst_114875 = inst_114868.cljs$core$ISeq$;
var inst_114876 = (cljs.core.PROTOCOL_SENTINEL === inst_114875);
var inst_114877 = ((inst_114874) || (inst_114876));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114877)){
var statearr_115082_115244 = state_115027__$1;
(statearr_115082_115244[(1)] = (53));

} else {
var statearr_115083_115245 = state_115027__$1;
(statearr_115083_115245[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (75))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114919 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115084_115246 = state_115027__$1;
(statearr_115084_115246[(2)] = inst_114919);

(statearr_115084_115246[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (99))){
var inst_114988 = (state_115027[(25)]);
var state_115027__$1 = state_115027;
var statearr_115085_115247 = state_115027__$1;
(statearr_115085_115247[(2)] = inst_114988);

(statearr_115085_115247[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (21))){
var inst_114795 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115086_115248 = state_115027__$1;
(statearr_115086_115248[(2)] = inst_114795);

(statearr_115086_115248[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (31))){
var inst_114811 = (state_115027[(14)]);
var inst_114824 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_114811,"a component","a non-component",throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115087_115249 = state_115027__$1;
(statearr_115087_115249[(2)] = inst_114824);

(statearr_115087_115249[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (32))){
var inst_114811 = (state_115027[(14)]);
var state_115027__$1 = state_115027;
var statearr_115088_115250 = state_115027__$1;
(statearr_115088_115250[(2)] = inst_114811);

(statearr_115088_115250[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (40))){
var inst_114859 = (state_115027[(26)]);
var inst_114759 = (state_115027[(12)]);
var inst_114858 = (state_115027[(2)]);
var inst_114859__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115089 = state_115027;
(statearr_115089[(26)] = inst_114859__$1);

(statearr_115089[(8)] = inst_114858);

return statearr_115089;
})();
if(cljs.core.truth_(inst_114859__$1)){
var statearr_115090_115251 = state_115027__$1;
(statearr_115090_115251[(1)] = (44));

} else {
var statearr_115091_115252 = state_115027__$1;
(statearr_115091_115252[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (91))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114959 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115092_115253 = state_115027__$1;
(statearr_115092_115253[(2)] = inst_114959);

(statearr_115092_115253[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (108))){
var inst_114986 = (state_115027[(27)]);
var state_115027__$1 = state_115027;
var statearr_115093_115254 = state_115027__$1;
(statearr_115093_115254[(2)] = inst_114986);

(statearr_115093_115254[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (56))){
var inst_114868 = (state_115027[(24)]);
var inst_114886 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_114868);
var state_115027__$1 = state_115027;
var statearr_115094_115255 = state_115027__$1;
(statearr_115094_115255[(2)] = inst_114886);

(statearr_115094_115255[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (33))){
var inst_114828 = (state_115027[(28)]);
var inst_114759 = (state_115027[(12)]);
var inst_114827 = (state_115027[(2)]);
var inst_114828__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115095 = state_115027;
(statearr_115095[(16)] = inst_114827);

(statearr_115095[(28)] = inst_114828__$1);

return statearr_115095;
})();
if(cljs.core.truth_(inst_114828__$1)){
var statearr_115096_115256 = state_115027__$1;
(statearr_115096_115256[(1)] = (34));

} else {
var statearr_115097_115257 = state_115027__$1;
(statearr_115097_115257[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (13))){
var inst_114747 = (state_115027[(10)]);
var inst_114776 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_114747,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115098_115258 = state_115027__$1;
(statearr_115098_115258[(2)] = inst_114776);

(statearr_115098_115258[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (22))){
var state_115027__$1 = state_115027;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_115099_115259 = state_115027__$1;
(statearr_115099_115259[(1)] = (25));

} else {
var statearr_115100_115260 = state_115027__$1;
(statearr_115100_115260[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (90))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115101_115261 = state_115027__$1;
(statearr_115101_115261[(2)] = inst_114858);

(statearr_115101_115261[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (109))){
var inst_115015 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115102_115262 = state_115027__$1;
(statearr_115102_115262[(2)] = inst_115015);

(statearr_115102_115262[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (36))){
var inst_114843 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114843)){
var statearr_115103_115263 = state_115027__$1;
(statearr_115103_115263[(1)] = (38));

} else {
var statearr_115104_115264 = state_115027__$1;
(statearr_115104_115264[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (41))){
var inst_114758 = (state_115027[(29)]);
var inst_114747 = (state_115027[(10)]);
var inst_114846 = fluree.db.dbproto._p_prop(inst_114747,cljs.core.cst$kw$name,inst_114758);
var inst_114847 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_114846)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_114848 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_114849 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_114850 = cljs.core.PersistentHashMap.fromArrays(inst_114848,inst_114849);
var inst_114851 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_114847,inst_114850);
var inst_114852 = (function(){throw inst_114851})();
var state_115027__$1 = state_115027;
var statearr_115105_115265 = state_115027__$1;
(statearr_115105_115265[(2)] = inst_114852);

(statearr_115105_115265[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (89))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114953 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_114954 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_114953,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,5,inst_114953,null));
var inst_114955 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114954,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114954,null));
var inst_114956 = (inst_114955.cljs$core$IFn$_invoke$arity$1 ? inst_114955.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114955.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114956)){
var statearr_115106_115266 = state_115027__$1;
(statearr_115106_115266[(1)] = (90));

} else {
var statearr_115107_115267 = state_115027__$1;
(statearr_115107_115267[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (100))){
var inst_115005 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_115005)){
var statearr_115108_115268 = state_115027__$1;
(statearr_115108_115268[(1)] = (104));

} else {
var statearr_115109_115269 = state_115027__$1;
(statearr_115109_115269[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (43))){
var inst_114855 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115110_115270 = state_115027__$1;
(statearr_115110_115270[(2)] = inst_114855);

(statearr_115110_115270[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (61))){
var inst_114983 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115111_115271 = state_115027__$1;
(statearr_115111_115271[(2)] = inst_114983);

(statearr_115111_115271[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (29))){
var inst_114812 = (state_115027[(13)]);
var state_115027__$1 = state_115027;
var statearr_115112_115272 = state_115027__$1;
(statearr_115112_115272[(2)] = inst_114812);

(statearr_115112_115272[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (44))){
var inst_114759 = (state_115027[(12)]);
var inst_114861 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114862 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_114861);
var state_115027__$1 = state_115027;
var statearr_115113_115273 = state_115027__$1;
(statearr_115113_115273[(2)] = inst_114862);

(statearr_115113_115273[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (93))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114963 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_114964 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_114963,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,2,inst_114963,null));
var inst_114965 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114964,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114964,null));
var inst_114966 = (inst_114965.cljs$core$IFn$_invoke$arity$1 ? inst_114965.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114965.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114966)){
var statearr_115114_115274 = state_115027__$1;
(statearr_115114_115274[(1)] = (94));

} else {
var statearr_115115_115275 = state_115027__$1;
(statearr_115115_115275[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (6))){
var inst_115023 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115116_115276 = state_115027__$1;
(statearr_115116_115276[(2)] = inst_115023);


cljs.core.async.impl.ioc_helpers.process_exception(state_115027__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (28))){
var inst_114759 = (state_115027[(12)]);
var inst_114814 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114815 = cljs.core.not(inst_114814);
var inst_114816 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114817 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114816);
var inst_114818 = inst_114817 === true;
var inst_114819 = ((inst_114815) && (inst_114818));
var state_115027__$1 = state_115027;
var statearr_115117_115277 = state_115027__$1;
(statearr_115117_115277[(2)] = inst_114819);

(statearr_115117_115277[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (64))){
var inst_114981 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115118_115278 = state_115027__$1;
(statearr_115118_115278[(2)] = inst_114981);

(statearr_115118_115278[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (103))){
var inst_115002 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115119_115279 = state_115027__$1;
(statearr_115119_115279[(2)] = inst_115002);

(statearr_115119_115279[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (51))){
var state_115027__$1 = state_115027;
var statearr_115120_115280 = state_115027__$1;
(statearr_115120_115280[(2)] = false);

(statearr_115120_115280[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (25))){
var inst_114801 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_114802 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_114803 = cljs.core.PersistentHashMap.fromArrays(inst_114801,inst_114802);
var inst_114804 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_114803);
var inst_114805 = (function(){throw inst_114804})();
var state_115027__$1 = state_115027;
var statearr_115121_115281 = state_115027__$1;
(statearr_115121_115281[(2)] = inst_114805);

(statearr_115121_115281[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (34))){
var inst_114758 = (state_115027[(29)]);
var inst_114747 = (state_115027[(10)]);
var inst_114759 = (state_115027[(12)]);
var inst_114830 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114831 = cljs.core.not(inst_114830);
var inst_114832 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114833 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114832);
var inst_114834 = inst_114833 === true;
var inst_114835 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_114747,inst_114758);
var state_115027__$1 = (function (){var statearr_115122 = state_115027;
(statearr_115122[(30)] = inst_114831);

(statearr_115122[(31)] = inst_114834);

return statearr_115122;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115027__$1,(37),inst_114835);
} else {
if((state_val_115028 === (17))){
var inst_114780 = (state_115027[(22)]);
var state_115027__$1 = state_115027;
var statearr_115123_115282 = state_115027__$1;
(statearr_115123_115282[(2)] = inst_114780);

(statearr_115123_115282[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (3))){
var inst_114724 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115124_115283 = state_115027__$1;
(statearr_115124_115283[(2)] = inst_114724);


cljs.core.async.impl.ioc_helpers.process_exception(state_115027__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (12))){
var inst_114774 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114774)){
var statearr_115125_115284 = state_115027__$1;
(statearr_115125_115284[(1)] = (13));

} else {
var statearr_115126_115285 = state_115027__$1;
(statearr_115126_115285[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (2))){
var inst_115025 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115027__$1,inst_115025);
} else {
if((state_val_115028 === (66))){
var state_115027__$1 = state_115027;
var statearr_115127_115286 = state_115027__$1;
(statearr_115127_115286[(2)] = null);

(statearr_115127_115286[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (107))){
var inst_115008 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_115009 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_115010 = cljs.core.PersistentHashMap.fromArrays(inst_115008,inst_115009);
var inst_115011 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_115010);
var inst_115012 = (function(){throw inst_115011})();
var state_115027__$1 = state_115027;
var statearr_115128_115287 = state_115027__$1;
(statearr_115128_115287[(2)] = inst_115012);

(statearr_115128_115287[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (23))){
var inst_114779 = (state_115027[(23)]);
var state_115027__$1 = state_115027;
var statearr_115129_115288 = state_115027__$1;
(statearr_115129_115288[(2)] = inst_114779);

(statearr_115129_115288[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (47))){
var inst_114868 = (state_115027[(24)]);
var inst_114759 = (state_115027[(12)]);
var inst_114868__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114870 = (inst_114868__$1 == null);
var inst_114871 = cljs.core.not(inst_114870);
var state_115027__$1 = (function (){var statearr_115130 = state_115027;
(statearr_115130[(24)] = inst_114868__$1);

return statearr_115130;
})();
if(inst_114871){
var statearr_115131_115289 = state_115027__$1;
(statearr_115131_115289[(1)] = (50));

} else {
var statearr_115132_115290 = state_115027__$1;
(statearr_115132_115290[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (35))){
var inst_114828 = (state_115027[(28)]);
var state_115027__$1 = state_115027;
var statearr_115133_115291 = state_115027__$1;
(statearr_115133_115291[(2)] = inst_114828);

(statearr_115133_115291[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (82))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115134_115292 = state_115027__$1;
(statearr_115134_115292[(2)] = inst_114858);

(statearr_115134_115292[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (76))){
var inst_114921 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115135_115293 = state_115027__$1;
(statearr_115135_115293[(2)] = inst_114921);

(statearr_115135_115293[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (97))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114973 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115136_115294 = state_115027__$1;
(statearr_115136_115294[(2)] = inst_114973);

(statearr_115136_115294[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (19))){
var inst_114759 = (state_115027[(12)]);
var inst_114784 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114785 = inst_114784 === true;
var inst_114786 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114787 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114786);
var inst_114788 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_114787);
var inst_114789 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114790 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114789);
var inst_114791 = inst_114790 === true;
var inst_114792 = ((inst_114785) && (inst_114788) && (inst_114791));
var state_115027__$1 = state_115027;
var statearr_115137_115295 = state_115027__$1;
(statearr_115137_115295[(2)] = inst_114792);

(statearr_115137_115295[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (57))){
var inst_114868 = (state_115027[(24)]);
var state_115027__$1 = state_115027;
var statearr_115138_115296 = state_115027__$1;
(statearr_115138_115296[(2)] = inst_114868);

(statearr_115138_115296[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (68))){
var inst_114976 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115139_115297 = state_115027__$1;
(statearr_115139_115297[(2)] = inst_114976);

(statearr_115139_115297[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (11))){
var inst_114763 = (state_115027[(32)]);
var state_115027__$1 = state_115027;
var statearr_115140_115298 = state_115027__$1;
(statearr_115140_115298[(2)] = inst_114763);

(statearr_115140_115298[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (9))){
var inst_115021 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115141_115299 = state_115027__$1;
(statearr_115141_115299[(2)] = inst_115021);

(statearr_115141_115299[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (5))){
var inst_114758 = (state_115027[(29)]);
var inst_114746 = (state_115027[(20)]);
var inst_114755 = cljs.core.seq(inst_114746);
var inst_114756 = cljs.core.first(inst_114755);
var inst_114757 = cljs.core.next(inst_114755);
var inst_114758__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114756,(0),null);
var inst_114759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114756,(1),null);
var inst_114760 = cljs.core.not(inst_114758__$1);
var state_115027__$1 = (function (){var statearr_115142 = state_115027;
(statearr_115142[(21)] = inst_114757);

(statearr_115142[(29)] = inst_114758__$1);

(statearr_115142[(12)] = inst_114759);

return statearr_115142;
})();
if(inst_114760){
var statearr_115143_115300 = state_115027__$1;
(statearr_115143_115300[(1)] = (7));

} else {
var statearr_115144_115301 = state_115027__$1;
(statearr_115144_115301[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (83))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114939 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115145_115302 = state_115027__$1;
(statearr_115145_115302[(2)] = inst_114939);

(statearr_115145_115302[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (14))){
var inst_114747 = (state_115027[(10)]);
var state_115027__$1 = state_115027;
var statearr_115146_115303 = state_115027__$1;
(statearr_115146_115303[(2)] = inst_114747);

(statearr_115146_115303[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (45))){
var inst_114859 = (state_115027[(26)]);
var state_115027__$1 = state_115027;
var statearr_115147_115304 = state_115027__$1;
(statearr_115147_115304[(2)] = inst_114859);

(statearr_115147_115304[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (53))){
var state_115027__$1 = state_115027;
var statearr_115148_115305 = state_115027__$1;
(statearr_115148_115305[(2)] = true);

(statearr_115148_115305[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (78))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115149_115306 = state_115027__$1;
(statearr_115149_115306[(2)] = inst_114858);

(statearr_115149_115306[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (26))){
var inst_114779 = (state_115027[(23)]);
var state_115027__$1 = state_115027;
var statearr_115150_115307 = state_115027__$1;
(statearr_115150_115307[(2)] = inst_114779);

(statearr_115150_115307[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (16))){
var inst_114782 = (state_115027[(11)]);
var inst_114759 = (state_115027[(12)]);
var inst_114782__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115151 = state_115027;
(statearr_115151[(11)] = inst_114782__$1);

return statearr_115151;
})();
if(cljs.core.truth_(inst_114782__$1)){
var statearr_115152_115308 = state_115027__$1;
(statearr_115152_115308[(1)] = (19));

} else {
var statearr_115153_115309 = state_115027__$1;
(statearr_115153_115309[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (81))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114933 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_114934 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_114933,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,3,inst_114933,null));
var inst_114935 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114934,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114934,null));
var inst_114936 = (inst_114935.cljs$core$IFn$_invoke$arity$1 ? inst_114935.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114935.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114936)){
var statearr_115154_115310 = state_115027__$1;
(statearr_115154_115310[(1)] = (82));

} else {
var statearr_115155_115311 = state_115027__$1;
(statearr_115155_115311[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (79))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114929 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115156_115312 = state_115027__$1;
(statearr_115156_115312[(2)] = inst_114929);

(statearr_115156_115312[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (38))){
var state_115027__$1 = state_115027;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_115157_115313 = state_115027__$1;
(statearr_115157_115313[(1)] = (41));

} else {
var statearr_115158_115314 = state_115027__$1;
(statearr_115158_115314[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (98))){
var inst_114990 = (state_115027[(15)]);
var inst_114759 = (state_115027[(12)]);
var inst_114990__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115159 = state_115027;
(statearr_115159[(15)] = inst_114990__$1);

return statearr_115159;
})();
if(cljs.core.truth_(inst_114990__$1)){
var statearr_115160_115315 = state_115027__$1;
(statearr_115160_115315[(1)] = (101));

} else {
var statearr_115161_115316 = state_115027__$1;
(statearr_115161_115316[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (87))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114949 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115162_115317 = state_115027__$1;
(statearr_115162_115317[(2)] = inst_114949);

(statearr_115162_115317[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (30))){
var inst_114822 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114822)){
var statearr_115163_115318 = state_115027__$1;
(statearr_115163_115318[(1)] = (31));

} else {
var statearr_115164_115319 = state_115027__$1;
(statearr_115164_115319[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (73))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114913 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_114914 = (inst_114891.cljs$core$IFn$_invoke$arity$5 ? inst_114891.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_114913,null) : inst_114891.call(null,cljs.core.PersistentArrayMap,null,3,inst_114913,null));
var inst_114915 = (inst_114891.cljs$core$IFn$_invoke$arity$4 ? inst_114891.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_114914,null) : inst_114891.call(null,cljs.core.PersistentHashSet,null,inst_114914,null));
var inst_114916 = (inst_114915.cljs$core$IFn$_invoke$arity$1 ? inst_114915.cljs$core$IFn$_invoke$arity$1(inst_114890) : inst_114915.call(null,inst_114890));
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114916)){
var statearr_115165_115320 = state_115027__$1;
(statearr_115165_115320[(1)] = (74));

} else {
var statearr_115166_115321 = state_115027__$1;
(statearr_115166_115321[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (96))){
var inst_114971 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115167_115322 = state_115027__$1;
(statearr_115167_115322[(2)] = inst_114971);

(statearr_115167_115322[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (10))){
var inst_114759 = (state_115027[(12)]);
var inst_114765 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114766 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_114765);
var inst_114767 = inst_114766 === false;
var inst_114768 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114769 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_114768);
var inst_114770 = inst_114769 === true;
var inst_114771 = ((inst_114767) && (inst_114770));
var state_115027__$1 = state_115027;
var statearr_115168_115323 = state_115027__$1;
(statearr_115168_115323[(2)] = inst_114771);

(statearr_115168_115323[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (18))){
var inst_114798 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114798)){
var statearr_115169_115324 = state_115027__$1;
(statearr_115169_115324[(1)] = (22));

} else {
var statearr_115170_115325 = state_115027__$1;
(statearr_115170_115325[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (105))){
var inst_114986 = (state_115027[(27)]);
var state_115027__$1 = state_115027;
var statearr_115171_115326 = state_115027__$1;
(statearr_115171_115326[(2)] = inst_114986);

(statearr_115171_115326[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (52))){
var inst_114884 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
if(cljs.core.truth_(inst_114884)){
var statearr_115172_115327 = state_115027__$1;
(statearr_115172_115327[(1)] = (56));

} else {
var statearr_115173_115328 = state_115027__$1;
(statearr_115173_115328[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (67))){
var inst_114979 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115174_115329 = state_115027__$1;
(statearr_115174_115329[(2)] = inst_114979);

(statearr_115174_115329[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (71))){
var inst_114890 = (state_115027[(9)]);
var inst_114891 = (state_115027[(7)]);
var inst_114909 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_114890,inst_114891,throw_QMARK_);
var state_115027__$1 = state_115027;
var statearr_115175_115330 = state_115027__$1;
(statearr_115175_115330[(2)] = inst_114909);

(statearr_115175_115330[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (42))){
var inst_114827 = (state_115027[(16)]);
var state_115027__$1 = state_115027;
var statearr_115176_115331 = state_115027__$1;
(statearr_115176_115331[(2)] = inst_114827);

(statearr_115176_115331[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (80))){
var inst_114931 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115177_115332 = state_115027__$1;
(statearr_115177_115332[(2)] = inst_114931);

(statearr_115177_115332[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (37))){
var inst_114831 = (state_115027[(30)]);
var inst_114834 = (state_115027[(31)]);
var inst_114837 = (state_115027[(2)]);
var inst_114838 = fluree.db.util.async.throw_err(inst_114837);
var inst_114839 = cljs.core.not(inst_114838);
var inst_114840 = ((inst_114831) && (inst_114834) && (inst_114839));
var state_115027__$1 = state_115027;
var statearr_115178_115333 = state_115027__$1;
(statearr_115178_115333[(2)] = inst_114840);

(statearr_115178_115333[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (63))){
var state_115027__$1 = state_115027;
var statearr_115179_115334 = state_115027__$1;
(statearr_115179_115334[(1)] = (65));



return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (94))){
var inst_114858 = (state_115027[(8)]);
var state_115027__$1 = state_115027;
var statearr_115181_115335 = state_115027__$1;
(statearr_115181_115335[(2)] = inst_114858);

(statearr_115181_115335[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (8))){
var inst_114763 = (state_115027[(32)]);
var inst_114759 = (state_115027[(12)]);
var inst_114763__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_114759);
var state_115027__$1 = (function (){var statearr_115182 = state_115027;
(statearr_115182[(32)] = inst_114763__$1);

return statearr_115182;
})();
if(cljs.core.truth_(inst_114763__$1)){
var statearr_115183_115336 = state_115027__$1;
(statearr_115183_115336[(1)] = (10));

} else {
var statearr_115184_115337 = state_115027__$1;
(statearr_115184_115337[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (49))){
var inst_114759 = (state_115027[(12)]);
var inst_114988 = (state_115027[(25)]);
var inst_114986 = (state_115027[(2)]);
var inst_114987 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_114759);
var inst_114988__$1 = inst_114987 === true;
var state_115027__$1 = (function (){var statearr_115185 = state_115027;
(statearr_115185[(27)] = inst_114986);

(statearr_115185[(25)] = inst_114988__$1);

return statearr_115185;
})();
if(cljs.core.truth_(inst_114988__$1)){
var statearr_115186_115338 = state_115027__$1;
(statearr_115186_115338[(1)] = (98));

} else {
var statearr_115187_115339 = state_115027__$1;
(statearr_115187_115339[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115028 === (84))){
var inst_114941 = (state_115027[(2)]);
var state_115027__$1 = state_115027;
var statearr_115188_115340 = state_115027__$1;
(statearr_115188_115340[(2)] = inst_114941);

(statearr_115188_115340[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$state_machine__109971__auto__ = null;
var fluree$db$query$schema$state_machine__109971__auto____0 = (function (){
var statearr_115189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115189[(0)] = fluree$db$query$schema$state_machine__109971__auto__);

(statearr_115189[(1)] = (1));

return statearr_115189;
});
var fluree$db$query$schema$state_machine__109971__auto____1 = (function (state_115027){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115027);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115190){if((e115190 instanceof Object)){
var ex__109974__auto__ = e115190;
var statearr_115191_115341 = state_115027;
(statearr_115191_115341[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115027);

return cljs.core.cst$kw$recur;
} else {
throw e115190;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115342 = state_115027;
state_115027 = G__115342;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__109971__auto__ = function(state_115027){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__109971__auto____1.call(this,state_115027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__109971__auto____0;
fluree$db$query$schema$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__109971__auto____1;
return fluree$db$query$schema$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115192 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115192[(6)] = c__110077__auto__);

return statearr_115192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3;

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115363){
var state_val_115364 = (state_115363[(1)]);
if((state_val_115364 === (7))){
var inst_115350 = (state_115363[(7)]);
var inst_115354 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_115350,db,true);
var state_115363__$1 = state_115363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115363__$1,(9),inst_115354);
} else {
if((state_val_115364 === (1))){
var state_115363__$1 = state_115363;
var statearr_115365_115377 = state_115363__$1;
(statearr_115365_115377[(2)] = null);

(statearr_115365_115377[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115364 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115363,(3),Error,null,(2));
var inst_115347 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_115363__$1 = state_115363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115363__$1,(5),inst_115347);
} else {
if((state_val_115364 === (6))){
var state_115363__$1 = state_115363;
var statearr_115366_115378 = state_115363__$1;
(statearr_115366_115378[(2)] = db);

(statearr_115366_115378[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115364 === (3))){
var inst_115343 = (state_115363[(2)]);
var state_115363__$1 = state_115363;
var statearr_115367_115379 = state_115363__$1;
(statearr_115367_115379[(2)] = inst_115343);


cljs.core.async.impl.ioc_helpers.process_exception(state_115363__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115364 === (2))){
var inst_115361 = (state_115363[(2)]);
var state_115363__$1 = state_115363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115363__$1,inst_115361);
} else {
if((state_val_115364 === (9))){
var inst_115356 = (state_115363[(2)]);
var inst_115357 = fluree.db.util.async.throw_err(inst_115356);
var state_115363__$1 = state_115363;
var statearr_115368_115380 = state_115363__$1;
(statearr_115368_115380[(2)] = inst_115357);

(statearr_115368_115380[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115364 === (5))){
var inst_115350 = (state_115363[(7)]);
var inst_115349 = (state_115363[(2)]);
var inst_115350__$1 = fluree.db.util.async.throw_err(inst_115349);
var inst_115351 = cljs.core.empty_QMARK_(inst_115350__$1);
var state_115363__$1 = (function (){var statearr_115369 = state_115363;
(statearr_115369[(7)] = inst_115350__$1);

return statearr_115369;
})();
if(inst_115351){
var statearr_115370_115381 = state_115363__$1;
(statearr_115370_115381[(1)] = (6));

} else {
var statearr_115371_115382 = state_115363__$1;
(statearr_115371_115382[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115364 === (8))){
var inst_115359 = (state_115363[(2)]);
var state_115363__$1 = state_115363;
var statearr_115372_115383 = state_115363__$1;
(statearr_115372_115383[(2)] = inst_115359);


cljs.core.async.impl.ioc_helpers.process_exception(state_115363__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____0 = (function (){
var statearr_115373 = [null,null,null,null,null,null,null,null];
(statearr_115373[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__);

(statearr_115373[(1)] = (1));

return statearr_115373;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____1 = (function (state_115363){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115363);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115374){if((e115374 instanceof Object)){
var ex__109974__auto__ = e115374;
var statearr_115375_115384 = state_115363;
(statearr_115375_115384[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115363);

return cljs.core.cst$kw$recur;
} else {
throw e115374;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115385 = state_115363;
state_115363 = G__115385;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__ = function(state_115363){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____1.call(this,state_115363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115376 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115376[(6)] = c__110077__auto__);

return statearr_115376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__115387 = arguments.length;
switch (G__115387) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
});

fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2;

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__115389 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115389,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115389,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115389,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4120__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,((function (p,o,existing_QMARK_){
return (function (p1__115392_SHARP_,p2__115393_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__115392_SHARP_,p2__115393_SHARP_], null));
});})(p,o,existing_QMARK_))
,o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115456){
var state_val_115457 = (state_115456[(1)]);
if((state_val_115457 === (1))){
var state_115456__$1 = state_115456;
var statearr_115458_115469 = state_115456__$1;
(statearr_115458_115469[(2)] = null);

(statearr_115458_115469[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115457 === (2))){
var inst_115454 = (state_115456[(2)]);
var state_115456__$1 = state_115456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115456__$1,inst_115454);
} else {
if((state_val_115457 === (3))){
var inst_115399 = (state_115456[(2)]);
var state_115456__$1 = state_115456;
var statearr_115459_115470 = state_115456__$1;
(statearr_115459_115470[(2)] = inst_115399);


cljs.core.async.impl.ioc_helpers.process_exception(state_115456__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115457 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115456,(3),Error,null,(2));
var inst_115409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115410 = fluree.db.flake.max_subject_id((1));
var inst_115411 = [inst_115410];
var inst_115412 = (new cljs.core.PersistentVector(null,1,(5),inst_115409,inst_115411,null));
var inst_115413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115414 = [(0)];
var inst_115415 = (new cljs.core.PersistentVector(null,1,(5),inst_115413,inst_115414,null));
var inst_115416 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_115412,cljs.core._LT__EQ_,inst_115415);
var state_115456__$1 = state_115456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115456__$1,(5),inst_115416);
} else {
if((state_val_115457 === (5))){
var inst_115418 = (state_115456[(2)]);
var inst_115419 = fluree.db.util.async.throw_err(inst_115418);
var inst_115420 = (function (){var schema_flakes = inst_115419;
return ((function (schema_flakes,inst_115418,inst_115419,state_val_115457,c__110077__auto__){
return (function (p1__115394_SHARP_){
return (p1__115394_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
;})(schema_flakes,inst_115418,inst_115419,state_val_115457,c__110077__auto__))
})();
var inst_115421 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_115420,inst_115419);
var inst_115422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115421,(0),null);
var inst_115423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115421,(1),null);
var inst_115424 = (function (){var schema_flakes = inst_115419;
var vec__115403 = inst_115421;
var collection_flakes = inst_115422;
var predicate_flakes = inst_115423;
return ((function (schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,state_val_115457,c__110077__auto__){
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sid,id,schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,state_val_115457,c__110077__auto__){
return (function (p1__115396_SHARP_,p2__115397_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__115396_SHARP_,p2__115397_SHARP_.p,p2__115397_SHARP_.o);
});})(sid,id,schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,state_val_115457,c__110077__auto__))
,cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
;})(schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,state_val_115457,c__110077__auto__))
})();
var inst_115425 = [(-1),"_tx"];
var inst_115426 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_115427 = ["_tx",(-1),(-1)];
var inst_115428 = cljs.core.PersistentHashMap.fromArrays(inst_115426,inst_115427);
var inst_115429 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_115430 = ["_tx",(-1),(-1)];
var inst_115431 = cljs.core.PersistentHashMap.fromArrays(inst_115429,inst_115430);
var inst_115432 = [inst_115428,inst_115431];
var inst_115433 = cljs.core.PersistentHashMap.fromArrays(inst_115425,inst_115432);
var inst_115434 = (function (){var schema_flakes = inst_115419;
var vec__115403 = inst_115421;
var collection_flakes = inst_115422;
var predicate_flakes = inst_115423;
return ((function (schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,state_val_115457,c__110077__auto__){
return (function (p1__115395_SHARP_){
return p1__115395_SHARP_.s;
});
;})(schema_flakes,vec__115403,collection_flakes,predicate_flakes,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,state_val_115457,c__110077__auto__))
})();
var inst_115435 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_115434,inst_115422);
var inst_115436 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_115424,inst_115433,inst_115435);
var inst_115438 = (function (){var schema_flakes = inst_115419;
var vec__115403 = inst_115421;
var collection_flakes = inst_115422;
var predicate_flakes = inst_115423;
var coll = inst_115436;
return ((function (schema_flakes,vec__115403,collection_flakes,predicate_flakes,coll,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,inst_115434,inst_115435,inst_115436,state_val_115457,c__110077__auto__){
return (function (p__115437,pred_flakes){
var vec__115460 = p__115437;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115460,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115460,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__115463 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__115463.cljs$core$IFn$_invoke$arity$1 ? fexpr__115463.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__115463.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4131__auto__ = ref_QMARK_;
if(or__4131__auto__){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
;})(schema_flakes,vec__115403,collection_flakes,predicate_flakes,coll,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,inst_115434,inst_115435,inst_115436,state_val_115457,c__110077__auto__))
})();
var inst_115439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115440 = cljs.core.PersistentHashMap.EMPTY;
var inst_115441 = cljs.core.PersistentHashSet.EMPTY;
var inst_115442 = [inst_115440,inst_115441];
var inst_115443 = (new cljs.core.PersistentVector(null,2,(5),inst_115439,inst_115442,null));
var inst_115444 = (function (){var schema_flakes = inst_115419;
var vec__115403 = inst_115421;
var collection_flakes = inst_115422;
var predicate_flakes = inst_115423;
var coll = inst_115436;
return ((function (schema_flakes,vec__115403,collection_flakes,predicate_flakes,coll,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,inst_115434,inst_115435,inst_115436,inst_115438,inst_115439,inst_115440,inst_115441,inst_115442,inst_115443,state_val_115457,c__110077__auto__){
return (function (p1__115398_SHARP_){
return p1__115398_SHARP_.s;
});
;})(schema_flakes,vec__115403,collection_flakes,predicate_flakes,coll,inst_115418,inst_115419,inst_115420,inst_115421,inst_115422,inst_115423,inst_115424,inst_115425,inst_115426,inst_115427,inst_115428,inst_115429,inst_115430,inst_115431,inst_115432,inst_115433,inst_115434,inst_115435,inst_115436,inst_115438,inst_115439,inst_115440,inst_115441,inst_115442,inst_115443,state_val_115457,c__110077__auto__))
})();
var inst_115445 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_115444,inst_115423);
var inst_115446 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_115438,inst_115443,inst_115445);
var inst_115447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115446,(0),null);
var inst_115448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115446,(1),null);
var inst_115449 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_115450 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_115451 = [inst_115450,inst_115436,inst_115447,inst_115448];
var inst_115452 = cljs.core.PersistentHashMap.fromArrays(inst_115449,inst_115451);
var state_115456__$1 = state_115456;
var statearr_115464_115471 = state_115456__$1;
(statearr_115464_115471[(2)] = inst_115452);


cljs.core.async.impl.ioc_helpers.process_exception(state_115456__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__109971__auto____0 = (function (){
var statearr_115465 = [null,null,null,null,null,null,null];
(statearr_115465[(0)] = fluree$db$query$schema$schema_map_$_state_machine__109971__auto__);

(statearr_115465[(1)] = (1));

return statearr_115465;
});
var fluree$db$query$schema$schema_map_$_state_machine__109971__auto____1 = (function (state_115456){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115456);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115466){if((e115466 instanceof Object)){
var ex__109974__auto__ = e115466;
var statearr_115467_115472 = state_115456;
(statearr_115467_115472[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115456);

return cljs.core.cst$kw$recur;
} else {
throw e115466;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115473 = state_115456;
state_115456 = G__115473;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__109971__auto__ = function(state_115456){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__109971__auto____1.call(this,state_115456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__109971__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__109971__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115468 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115468[(6)] = c__110077__auto__);

return statearr_115468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115509){
var state_val_115510 = (state_115509[(1)]);
if((state_val_115510 === (1))){
var state_115509__$1 = state_115509;
var statearr_115511_115522 = state_115509__$1;
(statearr_115511_115522[(2)] = null);

(statearr_115511_115522[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115510 === (2))){
var inst_115507 = (state_115509[(2)]);
var state_115509__$1 = state_115509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115509__$1,inst_115507);
} else {
if((state_val_115510 === (3))){
var inst_115474 = (state_115509[(2)]);
var state_115509__$1 = state_115509;
var statearr_115512_115523 = state_115509__$1;
(statearr_115512_115523[(2)] = inst_115474);


cljs.core.async.impl.ioc_helpers.process_exception(state_115509__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115510 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115509,(3),Error,null,(2));
var state_115509__$1 = state_115509;
var statearr_115513_115524 = state_115509__$1;
(statearr_115513_115524[(2)] = null);

(statearr_115513_115524[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115510 === (5))){
var inst_115493 = (state_115509[(2)]);
var inst_115494 = fluree.db.query.schema.flake__GT_pred_map(inst_115493);
var inst_115495 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_115496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(114));
var inst_115497 = cljs.core.boolean$(inst_115496);
var inst_115498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(110));
var inst_115499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(117));
var inst_115500 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_115499);
var inst_115501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(111));
var inst_115502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(115));
var inst_115503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_115494,(112));
var inst_115504 = [inst_115497,inst_115498,inst_115500,inst_115501,inst_115502,inst_115503];
var inst_115505 = cljs.core.PersistentHashMap.fromArrays(inst_115495,inst_115504);
var state_115509__$1 = state_115509;
var statearr_115514_115525 = state_115509__$1;
(statearr_115514_115525[(2)] = inst_115505);


cljs.core.async.impl.ioc_helpers.process_exception(state_115509__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115510 === (6))){
var inst_115478 = (state_115509[(2)]);
var state_115509__$1 = (function (){var statearr_115515 = state_115509;
(statearr_115515[(7)] = inst_115478);

return statearr_115515;
})();
var statearr_115516_115526 = state_115509__$1;
(statearr_115516_115526[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_115509__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115510 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115509,(6),java.lang.Exception,null,(5));
var inst_115482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115484 = ["_setting/id","root"];
var inst_115485 = (new cljs.core.PersistentVector(null,2,(5),inst_115483,inst_115484,null));
var inst_115486 = [inst_115485];
var inst_115487 = (new cljs.core.PersistentVector(null,1,(5),inst_115482,inst_115486,null));
var inst_115488 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_115487);
var state_115509__$1 = state_115509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115509__$1,(8),inst_115488);
} else {
if((state_val_115510 === (8))){
var inst_115490 = (state_115509[(2)]);
var inst_115491 = fluree.db.util.async.throw_err(inst_115490);
var state_115509__$1 = state_115509;
var statearr_115517_115527 = state_115509__$1;
(statearr_115517_115527[(2)] = inst_115491);


cljs.core.async.impl.ioc_helpers.process_exception(state_115509__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__109971__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__109971__auto____0 = (function (){
var statearr_115518 = [null,null,null,null,null,null,null,null];
(statearr_115518[(0)] = fluree$db$query$schema$setting_map_$_state_machine__109971__auto__);

(statearr_115518[(1)] = (1));

return statearr_115518;
});
var fluree$db$query$schema$setting_map_$_state_machine__109971__auto____1 = (function (state_115509){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115509);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115519){if((e115519 instanceof Object)){
var ex__109974__auto__ = e115519;
var statearr_115520_115528 = state_115509;
(statearr_115520_115528[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115509);

return cljs.core.cst$kw$recur;
} else {
throw e115519;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115529 = state_115509;
state_115509 = G__115529;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__109971__auto__ = function(state_115509){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__109971__auto____1.call(this,state_115509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__109971__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__109971__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115521 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115521[(6)] = c__110077__auto__);

return statearr_115521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
