// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__112502 = arguments.length;
switch (G__112502) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
});

fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__112503 = options;
var map__112503__$1 = (((((!((map__112503 == null))))?(((((map__112503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__112503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__112503):map__112503);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__112503__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = ((function (map__112503,map__112503__$1,keyword_fn){
return (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});})(map__112503,map__112503__$1,keyword_fn))
;
var thisfn = ((function (map__112503,map__112503__$1,keyword_fn){
return (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__112543_112576 = cljs.core.seq(x__$1);
var chunk__112544_112577 = null;
var count__112545_112578 = (0);
var i__112546_112579 = (0);
while(true){
if((i__112546_112579 < count__112545_112578)){
var vec__112559_112580 = chunk__112544_112577.cljs$core$IIndexed$_nth$arity$2(null,i__112546_112579);
var k_112581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112559_112580,(0),null);
var v_112582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112559_112580,(1),null);
var G__112562_112583 = m;
var G__112563_112584 = keyfn(k_112581);
var G__112564_112585 = fluree$db$util$json$thisfn(v_112582);
goog.object.set(G__112562_112583,G__112563_112584,G__112564_112585);


var G__112586 = seq__112543_112576;
var G__112587 = chunk__112544_112577;
var G__112588 = count__112545_112578;
var G__112589 = (i__112546_112579 + (1));
seq__112543_112576 = G__112586;
chunk__112544_112577 = G__112587;
count__112545_112578 = G__112588;
i__112546_112579 = G__112589;
continue;
} else {
var temp__5735__auto___112590 = cljs.core.seq(seq__112543_112576);
if(temp__5735__auto___112590){
var seq__112543_112591__$1 = temp__5735__auto___112590;
if(cljs.core.chunked_seq_QMARK_(seq__112543_112591__$1)){
var c__4550__auto___112592 = cljs.core.chunk_first(seq__112543_112591__$1);
var G__112593 = cljs.core.chunk_rest(seq__112543_112591__$1);
var G__112594 = c__4550__auto___112592;
var G__112595 = cljs.core.count(c__4550__auto___112592);
var G__112596 = (0);
seq__112543_112576 = G__112593;
chunk__112544_112577 = G__112594;
count__112545_112578 = G__112595;
i__112546_112579 = G__112596;
continue;
} else {
var vec__112565_112597 = cljs.core.first(seq__112543_112591__$1);
var k_112598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112565_112597,(0),null);
var v_112599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112565_112597,(1),null);
var G__112568_112600 = m;
var G__112569_112601 = keyfn(k_112598);
var G__112570_112602 = fluree$db$util$json$thisfn(v_112599);
goog.object.set(G__112568_112600,G__112569_112601,G__112570_112602);


var G__112603 = cljs.core.next(seq__112543_112591__$1);
var G__112604 = null;
var G__112605 = (0);
var G__112606 = (0);
seq__112543_112576 = G__112603;
chunk__112544_112577 = G__112604;
count__112545_112578 = G__112605;
i__112546_112579 = G__112606;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__112571_112607 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__112572_112608 = null;
var count__112573_112609 = (0);
var i__112574_112610 = (0);
while(true){
if((i__112574_112610 < count__112573_112609)){
var x_112611__$2 = chunk__112572_112608.cljs$core$IIndexed$_nth$arity$2(null,i__112574_112610);
arr.push(x_112611__$2);


var G__112612 = seq__112571_112607;
var G__112613 = chunk__112572_112608;
var G__112614 = count__112573_112609;
var G__112615 = (i__112574_112610 + (1));
seq__112571_112607 = G__112612;
chunk__112572_112608 = G__112613;
count__112573_112609 = G__112614;
i__112574_112610 = G__112615;
continue;
} else {
var temp__5735__auto___112616 = cljs.core.seq(seq__112571_112607);
if(temp__5735__auto___112616){
var seq__112571_112617__$1 = temp__5735__auto___112616;
if(cljs.core.chunked_seq_QMARK_(seq__112571_112617__$1)){
var c__4550__auto___112618 = cljs.core.chunk_first(seq__112571_112617__$1);
var G__112619 = cljs.core.chunk_rest(seq__112571_112617__$1);
var G__112620 = c__4550__auto___112618;
var G__112621 = cljs.core.count(c__4550__auto___112618);
var G__112622 = (0);
seq__112571_112607 = G__112619;
chunk__112572_112608 = G__112620;
count__112573_112609 = G__112621;
i__112574_112610 = G__112622;
continue;
} else {
var x_112623__$2 = cljs.core.first(seq__112571_112617__$1);
arr.push(x_112623__$2);


var G__112624 = cljs.core.next(seq__112571_112617__$1);
var G__112625 = null;
var G__112626 = (0);
var G__112627 = (0);
seq__112571_112607 = G__112624;
chunk__112572_112608 = G__112625;
count__112573_112609 = G__112626;
i__112574_112610 = G__112627;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});})(map__112503,map__112503__$1,keyword_fn))
;
return thisfn(x);
});

fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2;

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__112628_SHARP_){
var G__112631 = (depth - (1));
var G__112632 = p1__112628_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__112631,G__112632) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__112631,G__112632));
}),coordinates))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__112633 = cljs.core.get_global_hierarchy;
return (fexpr__112633.cljs$core$IFn$_invoke$arity$0 ? fexpr__112633.cljs$core$IFn$_invoke$arity$0() : fexpr__112633.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4120__auto__ = (function (){var or__4131__auto__ = (function (){var G__112637 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__112637) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__112637));
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4120__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__112638_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__112638_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
