// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('goog.object');
goog.require('fluree.db.connection_js');
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__138302 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138302__$1 = (((((!((map__138302 == null))))?(((((map__138302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138302.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138302):map__138302);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138302__$1,cljs.core.cst$kw$conn);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138302__$1,cljs.core.cst$kw$ledger);
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$block,time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = goog.object.get(obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__138304 = cljs.core.get_global_hierarchy;
return (fexpr__138304.cljs$core$IFn$_invoke$arity$0 ? fexpr__138304.cljs$core$IFn$_invoke$arity$0() : fexpr__138304.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function() { 
var G__138305__delegate = function (conn_id,event,_){
return event;
};
var G__138305 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__138306__i = 0, G__138306__a = new Array(arguments.length -  2);
while (G__138306__i < G__138306__a.length) {G__138306__a[G__138306__i] = arguments[G__138306__i + 2]; ++G__138306__i;}
  _ = new cljs.core.IndexedSeq(G__138306__a,0,null);
} 
return G__138305__delegate.call(this,conn_id,event,_);};
G__138305.cljs$lang$maxFixedArity = 2;
G__138305.cljs$lang$applyTo = (function (arglist__138307){
var conn_id = cljs.core.first(arglist__138307);
arglist__138307 = cljs.core.next(arglist__138307);
var event = cljs.core.first(arglist__138307);
var _ = cljs.core.rest(arglist__138307);
return G__138305__delegate(conn_id,event,_);
});
G__138305.cljs$core$IFn$_invoke$arity$variadic = G__138305__delegate;
return G__138305;
})()
;})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$setState,(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"setState",cljs.core.cst$kw$ref,id,cljs.core.cst$kw$data,cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$connStatus,(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"connStatus",cljs.core.cst$kw$ref,id,cljs.core.cst$kw$data,cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$login,(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"login",cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$pwGenerate,(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"pwGenerate",cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$connClosed,(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"connClosed",cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$connReset,(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"connReset",cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$setTransact,(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,"setTransact",cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$connInit,(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$conn,(0),cljs.core.cst$kw$event,"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$message,(function (){var or__4131__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Unknown Error.";
}
})(),cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,e_map,cljs.core.cst$kw$status,"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$queries,id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$jwt], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),cljs.core.cst$kw$jwt,jwt);
if(cljs.core.truth_(flureeql)){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_){
return (function (state_138325){
var state_val_138326 = (state_138325[(1)]);
if((state_val_138326 === (1))){
var inst_138308 = cljs.core.cst$kw$forceTime.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_138309 = flureeworker.conn_id__GT_db(conn_id,inst_138308);
var inst_138310 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,cljs.core.cst$kw$opts,opts_SINGLEQUOTE_);
var inst_138311 = fluree.db.api.query.query(inst_138309,inst_138310);
var state_138325__$1 = state_138325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138325__$1,(2),inst_138311);
} else {
if((state_val_138326 === (2))){
var inst_138313 = (state_138325[(7)]);
var inst_138313__$1 = (state_138325[(2)]);
var inst_138314 = fluree.db.util.core.exception_QMARK_(inst_138313__$1);
var state_138325__$1 = (function (){var statearr_138327 = state_138325;
(statearr_138327[(7)] = inst_138313__$1);

return statearr_138327;
})();
if(inst_138314){
var statearr_138328_138340 = state_138325__$1;
(statearr_138328_138340[(1)] = (3));

} else {
var statearr_138329_138341 = state_138325__$1;
(statearr_138329_138341[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_138326 === (3))){
var inst_138313 = (state_138325[(7)]);
var inst_138316 = flureeworker.error_return_map(inst_138313);
var state_138325__$1 = state_138325;
var statearr_138330_138342 = state_138325__$1;
(statearr_138330_138342[(2)] = inst_138316);

(statearr_138330_138342[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138326 === (4))){
var inst_138313 = (state_138325[(7)]);
var inst_138318 = [cljs.core.cst$kw$result,cljs.core.cst$kw$status];
var inst_138319 = [inst_138313,"loaded"];
var inst_138320 = cljs.core.PersistentHashMap.fromArrays(inst_138318,inst_138319);
var state_138325__$1 = state_138325;
var statearr_138331_138343 = state_138325__$1;
(statearr_138331_138343[(2)] = inst_138320);

(statearr_138331_138343[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138326 === (5))){
var inst_138322 = (state_138325[(2)]);
var inst_138323 = (function (){var G__138332 = conn_id;
var G__138333 = cljs.core.cst$kw$setState;
var G__138334 = id;
var G__138335 = inst_138322;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138332,G__138333,G__138334,G__138335) : flureeworker.worker_action.call(null,G__138332,G__138333,G__138334,G__138335));
})();
var state_138325__$1 = state_138325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138325__$1,inst_138323);
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_))
;
return ((function (switch__109970__auto__,c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_){
return (function() {
var flureeworker$process_query_$_state_machine__109971__auto__ = null;
var flureeworker$process_query_$_state_machine__109971__auto____0 = (function (){
var statearr_138336 = [null,null,null,null,null,null,null,null];
(statearr_138336[(0)] = flureeworker$process_query_$_state_machine__109971__auto__);

(statearr_138336[(1)] = (1));

return statearr_138336;
});
var flureeworker$process_query_$_state_machine__109971__auto____1 = (function (state_138325){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138325);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138337){if((e138337 instanceof Object)){
var ex__109974__auto__ = e138337;
var statearr_138338_138344 = state_138325;
(statearr_138338_138344[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138325);

return cljs.core.cst$kw$recur;
} else {
throw e138337;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138345 = state_138325;
state_138325 = G__138345;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__109971__auto__ = function(state_138325){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__109971__auto____1.call(this,state_138325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__109971__auto____0;
flureeworker$process_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__109971__auto____1;
return flureeworker$process_query_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_))
})();
var state__110079__auto__ = (function (){var statearr_138339 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138339[(6)] = c__110077__auto__);

return statearr_138339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,flureeql,jwt,opts_SINGLEQUOTE_))
);

return c__110077__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__138346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138346__$1 = (((((!((map__138346 == null))))?(((((map__138346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138346):map__138346);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138346__$1,cljs.core.cst$kw$queries);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138346__$1,cljs.core.cst$kw$opts);
var query_ids = cljs.core.keys(queries);
var seq__138348 = cljs.core.seq(query_ids);
var chunk__138349 = null;
var count__138350 = (0);
var i__138351 = (0);
while(true){
if((i__138351 < count__138350)){
var id = chunk__138349.cljs$core$IIndexed$_nth$arity$2(null,i__138351);
flureeworker.process_query(conn_id,id,opts);


var G__138352 = seq__138348;
var G__138353 = chunk__138349;
var G__138354 = count__138350;
var G__138355 = (i__138351 + (1));
seq__138348 = G__138352;
chunk__138349 = G__138353;
count__138350 = G__138354;
i__138351 = G__138355;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__138348);
if(temp__5735__auto__){
var seq__138348__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__138348__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__138348__$1);
var G__138356 = cljs.core.chunk_rest(seq__138348__$1);
var G__138357 = c__4550__auto__;
var G__138358 = cljs.core.count(c__4550__auto__);
var G__138359 = (0);
seq__138348 = G__138356;
chunk__138349 = G__138357;
count__138350 = G__138358;
i__138351 = G__138359;
continue;
} else {
var id = cljs.core.first(seq__138348__$1);
flureeworker.process_query(conn_id,id,opts);


var G__138360 = cljs.core.next(seq__138348__$1);
var G__138361 = null;
var G__138362 = (0);
var G__138363 = (0);
seq__138348 = G__138360;
chunk__138349 = G__138361;
count__138350 = G__138362;
i__138351 = G__138363;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__138364 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138364,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138364,(1),null);
var cb = ((function (vec__138364,network,ledger_id){
return (function (header,data){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,vec__138364,network,ledger_id){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,vec__138364,network,ledger_id){
return (function (state_138372){
var state_val_138373 = (state_138372[(1)]);
if((state_val_138373 === (1))){
var inst_138367 = cljs.core.async.timeout((100));
var state_138372__$1 = state_138372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138372__$1,(2),inst_138367);
} else {
if((state_val_138373 === (2))){
var inst_138369 = (state_138372[(2)]);
var inst_138370 = flureeworker.process_all_queries(conn_id);
var state_138372__$1 = (function (){var statearr_138374 = state_138372;
(statearr_138374[(7)] = inst_138369);

return statearr_138374;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_138372__$1,inst_138370);
} else {
return null;
}
}
});})(c__110077__auto__,vec__138364,network,ledger_id))
;
return ((function (switch__109970__auto__,c__110077__auto__,vec__138364,network,ledger_id){
return (function() {
var flureeworker$ledger_listener_$_state_machine__109971__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__109971__auto____0 = (function (){
var statearr_138375 = [null,null,null,null,null,null,null,null];
(statearr_138375[(0)] = flureeworker$ledger_listener_$_state_machine__109971__auto__);

(statearr_138375[(1)] = (1));

return statearr_138375;
});
var flureeworker$ledger_listener_$_state_machine__109971__auto____1 = (function (state_138372){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138372);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138376){if((e138376 instanceof Object)){
var ex__109974__auto__ = e138376;
var statearr_138377_138379 = state_138372;
(statearr_138377_138379[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138372);

return cljs.core.cst$kw$recur;
} else {
throw e138376;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138380 = state_138372;
state_138372 = G__138380;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__109971__auto__ = function(state_138372){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__109971__auto____1.call(this,state_138372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__109971__auto____0;
flureeworker$ledger_listener_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__109971__auto____1;
return flureeworker$ledger_listener_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,vec__138364,network,ledger_id))
})();
var state__110079__auto__ = (function (){var statearr_138378 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138378[(6)] = c__110077__auto__);

return statearr_138378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,vec__138364,network,ledger_id))
);

return c__110077__auto__;
});})(vec__138364,network,ledger_id))
;
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__138381 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138381,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138381,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__138384 = config;
var map__138384__$1 = (((((!((map__138384 == null))))?(((((map__138384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138384):map__138384);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$servers);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$ledger);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$id);
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$log);
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$compact);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138384__$1,cljs.core.cst$kw$private);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$closed,cljs.core.cst$kw$ledger,cljs.core.cst$kw$private,cljs.core.cst$kw$config,cljs.core.cst$kw$opts,cljs.core.cst$kw$servers,cljs.core.cst$kw$queries,cljs.core.cst$kw$log,cljs.core.cst$kw$conn],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$compact,compact], null),servers,(function (){var or__4131__auto__ = queries;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138386 = conn_data;
var map__138386__$1 = (((((!((map__138386 == null))))?(((((map__138386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138386):map__138386);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138386__$1,cljs.core.cst$kw$config);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138386__$1,cljs.core.cst$kw$queries);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138386__$1,cljs.core.cst$kw$jwt);
var map__138387 = config;
var map__138387__$1 = (((((!((map__138387 == null))))?(((((map__138387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138387):map__138387);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138387__$1,cljs.core.cst$kw$servers);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138387__$1,cljs.core.cst$kw$ledger);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138387__$1,cljs.core.cst$kw$id);
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138387__$1,cljs.core.cst$kw$keepAlive);
var cb = (cljs.core.truth_(keepAlive)?((function (conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive){
return (function (){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive){
return (function (state_138395){
var state_val_138396 = (state_138395[(1)]);
if((state_val_138396 === (1))){
var inst_138390 = cljs.core.async.timeout((100));
var state_138395__$1 = state_138395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138395__$1,(2),inst_138390);
} else {
if((state_val_138396 === (2))){
var inst_138392 = (state_138395[(2)]);
var inst_138393 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_138395__$1 = (function (){var statearr_138397 = state_138395;
(statearr_138397[(7)] = inst_138392);

return statearr_138397;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_138395__$1,inst_138393);
} else {
return null;
}
}
});})(c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive))
;
return ((function (switch__109970__auto__,c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive){
return (function() {
var flureeworker$connect_STAR__$_state_machine__109971__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__109971__auto____0 = (function (){
var statearr_138398 = [null,null,null,null,null,null,null,null];
(statearr_138398[(0)] = flureeworker$connect_STAR__$_state_machine__109971__auto__);

(statearr_138398[(1)] = (1));

return statearr_138398;
});
var flureeworker$connect_STAR__$_state_machine__109971__auto____1 = (function (state_138395){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138395);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138399){if((e138399 instanceof Object)){
var ex__109974__auto__ = e138399;
var statearr_138400_138410 = state_138395;
(statearr_138400_138410[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138395);

return cljs.core.cst$kw$recur;
} else {
throw e138399;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138411 = state_138395;
state_138395 = G__138411;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__109971__auto__ = function(state_138395){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__109971__auto____1.call(this,state_138395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__109971__auto____0;
flureeworker$connect_STAR__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__109971__auto____1;
return flureeworker$connect_STAR__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive))
})();
var state__110079__auto__ = (function (){var statearr_138401 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138401[(6)] = c__110077__auto__);

return statearr_138401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive))
);

return c__110077__auto__;
});})(conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive))
:null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keep_DASH_alive_DASH_fn], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then(((function (conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive,cb,opts){
return (function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$jwt,jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__138402_138412 = conn_id;
var G__138403_138413 = cljs.core.cst$kw$connReset;
var G__138404_138414 = ref;
var G__138405_138415 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$message,"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138402_138412,G__138403_138413,G__138404_138414,G__138405_138415) : flureeworker.worker_action.call(null,G__138402_138412,G__138403_138413,G__138404_138414,G__138405_138415));

return flureeworker.process_all_queries(conn_id);
});})(conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive,cb,opts))
).catch(((function (conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive,cb,opts){
return (function (error){
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(function (){var or__4131__auto__ = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (500);
}
})(),cljs.core.cst$kw$message,cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$message,["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__138406 = conn_id;
var G__138407 = cljs.core.cst$kw$connReset;
var G__138408 = ref;
var G__138409 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138406,G__138407,G__138408,G__138409) : flureeworker.worker_action.call(null,G__138406,G__138407,G__138408,G__138409));
});})(conn_data,map__138386,map__138386__$1,config,queries,jwt,map__138387,map__138387__$1,servers,ledger,id,keepAlive,cb,opts))
);
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__138417 = arguments.length;
switch (G__138417) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
});

flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138418 = conn_data;
var map__138418__$1 = (((((!((map__138418 == null))))?(((((map__138418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138418):map__138418);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138418__$1,cljs.core.cst$kw$conn);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138418__$1,cljs.core.cst$kw$ledger);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138418__$1,cljs.core.cst$kw$config);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138418__$1,cljs.core.cst$kw$jwt);
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$closed,true,cljs.core.cst$kw$config,config,cljs.core.cst$kw$jwt,jwt], null):new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$closed,true], null));
if((((conn_data == null)) || (cljs.core.cst$kw$closed.cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$message,"Connection closed."], null);
}
});

flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2;

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__138426 = conn_id;
var G__138427 = cljs.core.cst$kw$connClosed;
var G__138428 = ref;
var G__138429 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138426,G__138427,G__138428,G__138429) : flureeworker.worker_action.call(null,G__138426,G__138427,G__138428,G__138429));
}catch (e138421){var e = e138421;
var msg = (function (){var or__4131__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4131__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null);
}
})();
var G__138422 = conn_id;
var G__138423 = cljs.core.cst$kw$connClosed;
var G__138424 = ref;
var G__138425 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$message,msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138422,G__138423,G__138424,G__138425) : flureeworker.worker_action.call(null,G__138422,G__138423,G__138424,G__138425));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e138430){var e = e138430;
var msg = (function (){var or__4131__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4131__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null);
}
})();
var G__138431 = conn_id;
var G__138432 = cljs.core.cst$kw$connReset;
var G__138433 = ref;
var G__138434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$message,msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138431,G__138432,G__138433,G__138434) : flureeworker.worker_action.call(null,G__138431,G__138432,G__138433,G__138434));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var map__138435 = config_STAR_;
var map__138435__$1 = (((((!((map__138435 == null))))?(((((map__138435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138435):map__138435);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138435__$1,cljs.core.cst$kw$servers);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138435__$1,cljs.core.cst$kw$ledger);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138435__$1,cljs.core.cst$kw$id);
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138435__$1,cljs.core.cst$kw$keepAlive);
var _ = (cljs.core.truth_(cljs.core.cst$kw$log.cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(cljs.core.cst$kw$finest):null);
var cb = (cljs.core.truth_(keepAlive)?((function (config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_){
return (function (){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_){
return (function (state_138442){
var state_val_138443 = (state_138442[(1)]);
if((state_val_138443 === (1))){
var inst_138437 = cljs.core.async.timeout((100));
var state_138442__$1 = state_138442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_138442__$1,(2),inst_138437);
} else {
if((state_val_138443 === (2))){
var inst_138439 = (state_138442[(2)]);
var inst_138440 = flureeworker.connect_STAR_(id,ref);
var state_138442__$1 = (function (){var statearr_138444 = state_138442;
(statearr_138444[(7)] = inst_138439);

return statearr_138444;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_138442__$1,inst_138440);
} else {
return null;
}
}
});})(c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_))
;
return ((function (switch__109970__auto__,c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_){
return (function() {
var flureeworker$connect_p_$_state_machine__109971__auto__ = null;
var flureeworker$connect_p_$_state_machine__109971__auto____0 = (function (){
var statearr_138445 = [null,null,null,null,null,null,null,null];
(statearr_138445[(0)] = flureeworker$connect_p_$_state_machine__109971__auto__);

(statearr_138445[(1)] = (1));

return statearr_138445;
});
var flureeworker$connect_p_$_state_machine__109971__auto____1 = (function (state_138442){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138442);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138446){if((e138446 instanceof Object)){
var ex__109974__auto__ = e138446;
var statearr_138447_138457 = state_138442;
(statearr_138447_138457[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138442);

return cljs.core.cst$kw$recur;
} else {
throw e138446;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138458 = state_138442;
state_138442 = G__138458;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__109971__auto__ = function(state_138442){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__109971__auto____1.call(this,state_138442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__109971__auto____0;
flureeworker$connect_p_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__109971__auto____1;
return flureeworker$connect_p_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_))
})();
var state__110079__auto__ = (function (){var statearr_138448 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138448[(6)] = c__110077__auto__);

return statearr_138448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_))
);

return c__110077__auto__;
});})(config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_))
:null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keep_DASH_alive_DASH_fn], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then(((function (config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_,cb,opts){
return (function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__138449 = id;
var G__138450 = cljs.core.cst$kw$connStatus;
var G__138451 = ref;
var G__138452 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$message,"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138449,G__138450,G__138451,G__138452) : flureeworker.worker_action.call(null,G__138449,G__138450,G__138451,G__138452));
});})(config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_,cb,opts))
).catch(((function (config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_,cb,opts){
return (function (error){
var G__138453 = id;
var G__138454 = cljs.core.cst$kw$connStatus;
var G__138455 = ref;
var G__138456 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$message,cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138453,G__138454,G__138455,G__138456) : flureeworker.worker_action.call(null,G__138453,G__138454,G__138455,G__138456));
});})(config_STAR_,map__138435,map__138435__$1,servers,ledger,id,keepAlive,_,cb,opts))
);
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$closed], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4736__auto__ = [];
var len__4730__auto___138517 = arguments.length;
var i__4731__auto___138518 = (0);
while(true){
if((i__4731__auto___138518 < len__4730__auto___138517)){
args__4736__auto__.push((arguments[i__4731__auto___138518]));

var G__138519 = (i__4731__auto___138518 + (1));
i__4731__auto___138518 = G__138519;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__138464){
var vec__138465 = p__138464;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__138465,(0),null);
var map__138468 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138468__$1 = (((((!((map__138468 == null))))?(((((map__138468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138468.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138468):map__138468);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138468__$1,cljs.core.cst$kw$conn);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138468__$1,cljs.core.cst$kw$ledger);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138468__$1,cljs.core.cst$kw$jwt);
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__138470 = conn_id;
var G__138471 = cljs.core.cst$kw$login;
var G__138472 = ref;
var G__138473 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$message,"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138470,G__138471,G__138472,G__138473) : flureeworker.worker_action.call(null,G__138470,G__138471,G__138472,G__138473));
})());
var auth = null;
var c__110077__auto___138520 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire){
return (function (state_138491){
var state_val_138492 = (state_138491[(1)]);
if((state_val_138492 === (1))){
var state_138491__$1 = state_138491;
var statearr_138493_138521 = state_138491__$1;
(statearr_138493_138521[(2)] = null);

(statearr_138493_138521[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138492 === (2))){
var inst_138489 = (state_138491[(2)]);
var state_138491__$1 = state_138491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138491__$1,inst_138489);
} else {
if((state_val_138492 === (3))){
var inst_138474 = (state_138491[(2)]);
var inst_138475 = [cljs.core.cst$kw$status,cljs.core.cst$kw$message];
var inst_138476 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_138474);
var inst_138477 = [(400),inst_138476];
var inst_138478 = cljs.core.PersistentHashMap.fromArrays(inst_138475,inst_138477);
var inst_138479 = (function (){var G__138494 = conn_id;
var G__138495 = cljs.core.cst$kw$login;
var G__138496 = ref;
var G__138497 = inst_138478;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138494,G__138495,G__138496,G__138497) : flureeworker.worker_action.call(null,G__138494,G__138495,G__138496,G__138497));
})();
var state_138491__$1 = state_138491;
var statearr_138498_138522 = state_138491__$1;
(statearr_138498_138522[(2)] = inst_138479);


cljs.core.async.impl.ioc_helpers.process_exception(state_138491__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138492 === (4))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138491,(3),cljs.core.cst$kw$default,null,(2));
var inst_138483 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_138484 = (function (){return ((function (___$1,inst_138483,state_val_138492,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire){
return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$jwt], null),token);

var G__138499 = conn_id;
var G__138500 = cljs.core.cst$kw$login;
var G__138501 = ref;
var G__138502 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$result,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$token,token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138499,G__138500,G__138501,G__138502) : flureeworker.worker_action.call(null,G__138499,G__138500,G__138501,G__138502));
});
;})(___$1,inst_138483,state_val_138492,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire))
})();
var inst_138485 = inst_138483.then(inst_138484);
var inst_138486 = (function (){return ((function (___$1,inst_138483,inst_138484,inst_138485,state_val_138492,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire){
return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
}catch (e138503){var ___$2 = e138503;
return null;
}})();
var status = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4131__auto__ = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4131__auto__ = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$db_SLASH_invalid_DASH_request;
}
})();
var G__138504 = conn_id;
var G__138505 = cljs.core.cst$kw$login;
var G__138506 = ref;
var G__138507 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$message,message,cljs.core.cst$kw$error,error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138504,G__138505,G__138506,G__138507) : flureeworker.worker_action.call(null,G__138504,G__138505,G__138506,G__138507));
} else {
var G__138508 = conn_id;
var G__138509 = cljs.core.cst$kw$login;
var G__138510 = ref;
var G__138511 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$message,["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138508,G__138509,G__138510,G__138511) : flureeworker.worker_action.call(null,G__138508,G__138509,G__138510,G__138511));

}
});
;})(___$1,inst_138483,inst_138484,inst_138485,state_val_138492,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire))
})();
var inst_138487 = inst_138485.catch(inst_138486);
var state_138491__$1 = state_138491;
var statearr_138512_138523 = state_138491__$1;
(statearr_138512_138523[(2)] = inst_138487);


cljs.core.async.impl.ioc_helpers.process_exception(state_138491__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire))
;
return ((function (switch__109970__auto__,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire){
return (function() {
var flureeworker$state_machine__109971__auto__ = null;
var flureeworker$state_machine__109971__auto____0 = (function (){
var statearr_138513 = [null,null,null,null,null,null,null];
(statearr_138513[(0)] = flureeworker$state_machine__109971__auto__);

(statearr_138513[(1)] = (1));

return statearr_138513;
});
var flureeworker$state_machine__109971__auto____1 = (function (state_138491){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138491);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138514){if((e138514 instanceof Object)){
var ex__109974__auto__ = e138514;
var statearr_138515_138524 = state_138491;
(statearr_138515_138524[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138491);

return cljs.core.cst$kw$recur;
} else {
throw e138514;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138525 = state_138491;
state_138491 = G__138525;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$state_machine__109971__auto__ = function(state_138491){
switch(arguments.length){
case 0:
return flureeworker$state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$state_machine__109971__auto____1.call(this,state_138491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__109971__auto____0;
flureeworker$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__109971__auto____1;
return flureeworker$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire))
})();
var state__110079__auto__ = (function (){var statearr_138516 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138516[(6)] = c__110077__auto___138520);

return statearr_138516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___138520,map__138468,map__138468__$1,conn,ledger,jwt,_,auth,vec__138465,expire))
);


return true;
});

flureeworker.login.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
flureeworker.login.cljs$lang$applyTo = (function (seq138459){
var G__138460 = cljs.core.first(seq138459);
var seq138459__$1 = cljs.core.next(seq138459);
var G__138461 = cljs.core.first(seq138459__$1);
var seq138459__$2 = cljs.core.next(seq138459__$1);
var G__138462 = cljs.core.first(seq138459__$2);
var seq138459__$3 = cljs.core.next(seq138459__$2);
var G__138463 = cljs.core.first(seq138459__$3);
var seq138459__$4 = cljs.core.next(seq138459__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__138460,G__138461,G__138462,G__138463,seq138459__$4);
});

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__138526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__138526__$1 = (((((!((map__138526 == null))))?(((((map__138526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138526.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138526):map__138526);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138526__$1,cljs.core.cst$kw$conn);
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138526__$1,cljs.core.cst$kw$ledger);
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__138529 = conn_id;
var G__138530 = cljs.core.cst$kw$login;
var G__138531 = ref;
var G__138532 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$message,"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138529,G__138530,G__138531,G__138532) : flureeworker.worker_action.call(null,G__138529,G__138530,G__138531,G__138532));
})());
var map__138527 = map_data;
var map__138527__$1 = (((((!((map__138527 == null))))?(((((map__138527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__138527.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__138527):map__138527);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138527__$1,cljs.core.cst$kw$username);
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138527__$1,cljs.core.cst$kw$password);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__138527__$1,cljs.core.cst$kw$options);
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),cljs.core.cst$kw$user,username);
var c__110077__auto___138577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts){
return (function (state_138551){
var state_val_138552 = (state_138551[(1)]);
if((state_val_138552 === (1))){
var state_138551__$1 = state_138551;
var statearr_138553_138578 = state_138551__$1;
(statearr_138553_138578[(2)] = null);

(statearr_138553_138578[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_138552 === (2))){
var inst_138549 = (state_138551[(2)]);
var state_138551__$1 = state_138551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_138551__$1,inst_138549);
} else {
if((state_val_138552 === (3))){
var inst_138534 = (state_138551[(2)]);
var inst_138535 = [cljs.core.cst$kw$status,cljs.core.cst$kw$message];
var inst_138536 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_138534);
var inst_138537 = [(400),inst_138536];
var inst_138538 = cljs.core.PersistentHashMap.fromArrays(inst_138535,inst_138537);
var inst_138539 = (function (){var G__138554 = conn_id;
var G__138555 = cljs.core.cst$kw$pwGenerate;
var G__138556 = ref;
var G__138557 = inst_138538;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138554,G__138555,G__138556,G__138557) : flureeworker.worker_action.call(null,G__138554,G__138555,G__138556,G__138557));
})();
var state_138551__$1 = state_138551;
var statearr_138558_138579 = state_138551__$1;
(statearr_138558_138579[(2)] = inst_138539);


cljs.core.async.impl.ioc_helpers.process_exception(state_138551__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_138552 === (4))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_138551,(3),cljs.core.cst$kw$default,null,(2));
var inst_138543 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_138544 = (function (){return ((function (___$1,inst_138543,state_val_138552,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts){
return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$jwt], null),token);

var G__138559 = conn_id;
var G__138560 = cljs.core.cst$kw$pwGenerate;
var G__138561 = ref;
var G__138562 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$result,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$token,token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138559,G__138560,G__138561,G__138562) : flureeworker.worker_action.call(null,G__138559,G__138560,G__138561,G__138562));
});
;})(___$1,inst_138543,state_val_138552,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts))
})();
var inst_138545 = inst_138543.then(inst_138544);
var inst_138546 = (function (){return ((function (___$1,inst_138543,inst_138544,inst_138545,state_val_138552,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts){
return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
}catch (e138563){var ___$2 = e138563;
return null;
}})();
var status = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4131__auto__ = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4131__auto__ = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$db_SLASH_invalid_DASH_request;
}
})();
var G__138564 = conn_id;
var G__138565 = cljs.core.cst$kw$pwGenerate;
var G__138566 = ref;
var G__138567 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$message,message,cljs.core.cst$kw$error,error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138564,G__138565,G__138566,G__138567) : flureeworker.worker_action.call(null,G__138564,G__138565,G__138566,G__138567));
} else {
var G__138568 = conn_id;
var G__138569 = cljs.core.cst$kw$pwGenerate;
var G__138570 = ref;
var G__138571 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$message,["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__138568,G__138569,G__138570,G__138571) : flureeworker.worker_action.call(null,G__138568,G__138569,G__138570,G__138571));

}
});
;})(___$1,inst_138543,inst_138544,inst_138545,state_val_138552,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts))
})();
var inst_138547 = inst_138545.catch(inst_138546);
var state_138551__$1 = state_138551;
var statearr_138572_138580 = state_138551__$1;
(statearr_138572_138580[(2)] = inst_138547);


cljs.core.async.impl.ioc_helpers.process_exception(state_138551__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts))
;
return ((function (switch__109970__auto__,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts){
return (function() {
var flureeworker$pw_generate_$_state_machine__109971__auto__ = null;
var flureeworker$pw_generate_$_state_machine__109971__auto____0 = (function (){
var statearr_138573 = [null,null,null,null,null,null,null];
(statearr_138573[(0)] = flureeworker$pw_generate_$_state_machine__109971__auto__);

(statearr_138573[(1)] = (1));

return statearr_138573;
});
var flureeworker$pw_generate_$_state_machine__109971__auto____1 = (function (state_138551){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_138551);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e138574){if((e138574 instanceof Object)){
var ex__109974__auto__ = e138574;
var statearr_138575_138581 = state_138551;
(statearr_138575_138581[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_138551);

return cljs.core.cst$kw$recur;
} else {
throw e138574;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__138582 = state_138551;
state_138551 = G__138582;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__109971__auto__ = function(state_138551){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__109971__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__109971__auto____1.call(this,state_138551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__109971__auto____0;
flureeworker$pw_generate_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__109971__auto____1;
return flureeworker$pw_generate_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts))
})();
var state__110079__auto__ = (function (){var statearr_138576 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_138576[(6)] = c__110077__auto___138577);

return statearr_138576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___138577,map__138526,map__138526__$1,conn,ledger,_,map__138527,map__138527__$1,username,password,options,opts))
);


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$queries], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$queries,ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$queries], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$opts], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return null;
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__138583_SHARP_){
return (js_array[p1__138583_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,conn_id,cljs.core.cst$kw$event,action_str,cljs.core.cst$kw$ref,ref,cljs.core.cst$kw$data,({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$status,(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e138584){var e = e138584;
var data = (event["data"]);
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(function (){var or__4131__auto__ = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (500);
}
})(),cljs.core.cst$kw$message,cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$message,["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$conn,(data["conn"]),cljs.core.cst$kw$event,(data["action"]),cljs.core.cst$kw$ref,(data["ref"]),cljs.core.cst$kw$data,error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5735__auto___138585 = cljs.core.not(self.document);
if(temp__5735__auto___138585){
var worker_QMARK__138586 = temp__5735__auto___138585;
self.onerror = flureeworker.log_error;

self.onmessage = flureeworker.decode_message;
} else {
}
var G__138587_138589 = null;
var G__138588_138590 = cljs.core.cst$kw$connInit;
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__138587_138589,G__138588_138590) : flureeworker.worker_action.call(null,G__138587_138589,G__138588_138590));
