// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.crypto.sha2');
goog.require('cljs.core');
goog.require('fluree.crypto.util');
goog.require('alphabase.core');
goog.require('goog.crypt.Sha256');
goog.require('goog.crypt.Sha512');
goog.require('goog.crypt.Sha2');
fluree.crypto.sha2.hash = (function fluree$crypto$sha2$hash(ba,hash_size){
if(cljs.core.truth_((function (){var fexpr__62180 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(512),null,(256),null], null), null);
return (fexpr__62180.cljs$core$IFn$_invoke$arity$1 ? fexpr__62180.cljs$core$IFn$_invoke$arity$1(hash_size) : fexpr__62180.call(null,hash_size));
})())){
} else {
throw (new Error("Assert failed: (#{512 256} hash-size)"));
}

var digest = (function (){var G__62181 = hash_size;
switch (G__62181) {
case (256):
var G__62182 = (new goog.crypt.Sha256());
G__62182.update(ba);

return G__62182;

break;
case (512):
var G__62183 = (new goog.crypt.Sha512());
G__62183.update(ba);

return G__62183;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62181)].join('')));

}
})();
return digest.digest();
});
/**
 * Create a sha2 hash (in byte array format) from byte-array.
 */
fluree.crypto.sha2.sha2_256_byte_array = (function fluree$crypto$sha2$sha2_256_byte_array(ba){
return fluree.crypto.sha2.hash(ba,(256));
});
fluree.crypto.sha2.sha2_256 = (function fluree$crypto$sha2$sha2_256(var_args){
var G__62186 = arguments.length;
switch (G__62186) {
case 1:
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.util.coerce_input_format(x));
}));

(fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_256_byte_array(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2.sha2_256.cljs$lang$maxFixedArity = 3);

/**
 * sha2-256 hash of provided string after normalizing string.
 */
fluree.crypto.sha2.sha2_256_normalize = (function fluree$crypto$sha2$sha2_256_normalize(var_args){
var G__62189 = arguments.length;
switch (G__62189) {
case 1:
return fluree.crypto.sha2.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.sha2.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2.sha2_256.cljs$core$IFn$_invoke$arity$3(fluree.crypto.util.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha2.sha2_256_normalize.cljs$lang$maxFixedArity = 2);

/**
 * Create a sha2 hash (in byte array format) from byte-array.
 */
fluree.crypto.sha2.sha2_512_byte_array = (function fluree$crypto$sha2$sha2_512_byte_array(ba){
return fluree.crypto.sha2.hash(ba,(512));
});
fluree.crypto.sha2.sha2_512 = (function fluree$crypto$sha2$sha2_512(var_args){
var G__62192 = arguments.length;
switch (G__62192) {
case 1:
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.util.coerce_input_format(x));
}));

(fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_512_byte_array(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2.sha2_512.cljs$lang$maxFixedArity = 3);

/**
 * sha2-512 hash of provided string after normalizing string.
 */
fluree.crypto.sha2.sha2_512_normalize = (function fluree$crypto$sha2$sha2_512_normalize(var_args){
var G__62195 = arguments.length;
switch (G__62195) {
case 1:
return fluree.crypto.sha2.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.crypto.sha2.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2.sha2_512.cljs$core$IFn$_invoke$arity$3(fluree.crypto.util.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha2.sha2_512_normalize.cljs$lang$maxFixedArity = 2);

