// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__66115 = arguments.length;
switch (G__66115) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___66154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66136){
var state_val_66137 = (state_66136[(1)]);
if((state_val_66137 === (1))){
var state_66136__$1 = state_66136;
var statearr_66138_66155 = state_66136__$1;
(statearr_66138_66155[(2)] = null);

(statearr_66138_66155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66137 === (2))){
var _ = (function (){var statearr_66139 = state_66136;
(statearr_66139[(4)] = cljs.core.cons((5),(state_66136[(4)])));

return statearr_66139;
})();
var inst_66122 = fluree.db.session.db(conn,ledger,null);
var state_66136__$1 = state_66136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66136__$1,(7),inst_66122);
} else {
if((state_val_66137 === (3))){
var inst_66132 = (state_66136[(2)]);
var inst_66133 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66132);
var inst_66134 = cljs.core.async.close_BANG_(pc);
var state_66136__$1 = (function (){var statearr_66141 = state_66136;
(statearr_66141[(7)] = inst_66133);

return statearr_66141;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_66136__$1,inst_66134);
} else {
if((state_val_66137 === (4))){
var inst_66116 = (state_66136[(2)]);
var state_66136__$1 = state_66136;
var statearr_66142_66156 = state_66136__$1;
(statearr_66142_66156[(2)] = inst_66116);

(statearr_66142_66156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66137 === (5))){
var _ = (function (){var statearr_66143 = state_66136;
(statearr_66143[(4)] = cljs.core.rest((state_66136[(4)])));

return statearr_66143;
})();
var state_66136__$1 = state_66136;
var ex66140 = (state_66136__$1[(2)]);
var statearr_66144_66157 = state_66136__$1;
(statearr_66144_66157[(5)] = ex66140);


var statearr_66145_66158 = state_66136__$1;
(statearr_66145_66158[(1)] = (4));

(statearr_66145_66158[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66137 === (6))){
var inst_66128 = (state_66136[(2)]);
var inst_66129 = fluree.db.util.async.throw_err(inst_66128);
var _ = (function (){var statearr_66146 = state_66136;
(statearr_66146[(4)] = cljs.core.rest((state_66136[(4)])));

return statearr_66146;
})();
var state_66136__$1 = state_66136;
var statearr_66147_66159 = state_66136__$1;
(statearr_66147_66159[(2)] = inst_66129);

(statearr_66147_66159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66137 === (7))){
var inst_66124 = (state_66136[(2)]);
var inst_66125 = fluree.db.util.async.throw_err(inst_66124);
var inst_66126 = fluree.db.time_travel.as_of_block(inst_66125,block);
var state_66136__$1 = state_66136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66136__$1,(6),inst_66126);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2414__auto__ = null;
var fluree$db$api$ledger$state_machine__2414__auto____0 = (function (){
var statearr_66148 = [null,null,null,null,null,null,null,null];
(statearr_66148[(0)] = fluree$db$api$ledger$state_machine__2414__auto__);

(statearr_66148[(1)] = (1));

return statearr_66148;
});
var fluree$db$api$ledger$state_machine__2414__auto____1 = (function (state_66136){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66136);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66149){var ex__2417__auto__ = e66149;
var statearr_66150_66160 = state_66136;
(statearr_66150_66160[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66136[(4)]))){
var statearr_66151_66161 = state_66136;
(statearr_66151_66161[(1)] = cljs.core.first((state_66136[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66162 = state_66136;
state_66136 = G__66162;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2414__auto__ = function(state_66136){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2414__auto____1.call(this,state_66136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2414__auto____0;
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2414__auto____1;
return fluree$db$api$ledger$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66152 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66152[(6)] = c__2436__auto___66154);

return statearr_66152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66203){
var state_val_66204 = (state_66203[(1)]);
if((state_val_66204 === (7))){
var inst_66172 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66203__$1 = state_66203;
if(inst_66172){
var statearr_66205_66236 = state_66203__$1;
(statearr_66205_66236[(1)] = (9));

} else {
var statearr_66206_66237 = state_66203__$1;
(statearr_66206_66237[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (1))){
var state_66203__$1 = state_66203;
var statearr_66207_66238 = state_66203__$1;
(statearr_66207_66238[(2)] = null);

(statearr_66207_66238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (4))){
var inst_66163 = (state_66203[(2)]);
var state_66203__$1 = state_66203;
var statearr_66208_66239 = state_66203__$1;
(statearr_66208_66239[(2)] = inst_66163);

(statearr_66208_66239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (15))){
var inst_66180 = (state_66203[(7)]);
var inst_66179 = (state_66203[(2)]);
var inst_66180__$1 = fluree.db.util.async.throw_err(inst_66179);
var state_66203__$1 = (function (){var statearr_66209 = state_66203;
(statearr_66209[(7)] = inst_66180__$1);

return statearr_66209;
})();
if(cljs.core.truth_(inst_66180__$1)){
var statearr_66210_66240 = state_66203__$1;
(statearr_66210_66240[(1)] = (16));

} else {
var statearr_66211_66241 = state_66203__$1;
(statearr_66211_66241[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (13))){
var state_66203__$1 = state_66203;
var statearr_66212_66242 = state_66203__$1;
(statearr_66212_66242[(2)] = null);

(statearr_66212_66242[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (6))){
var state_66203__$1 = state_66203;
var statearr_66213_66243 = state_66203__$1;
(statearr_66213_66243[(2)] = db);

(statearr_66213_66243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (17))){
var inst_66184 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66185 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66186 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66187 = cljs.core.PersistentHashMap.fromArrays(inst_66185,inst_66186);
var inst_66188 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66184,inst_66187);
var inst_66189 = (function(){throw inst_66188})();
var state_66203__$1 = state_66203;
var statearr_66214_66244 = state_66203__$1;
(statearr_66214_66244[(2)] = inst_66189);

(statearr_66214_66244[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (3))){
var inst_66201 = (state_66203[(2)]);
var state_66203__$1 = state_66203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66203__$1,inst_66201);
} else {
if((state_val_66204 === (12))){
var inst_66177 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66203__$1 = state_66203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66203__$1,(15),inst_66177);
} else {
if((state_val_66204 === (2))){
var _ = (function (){var statearr_66215 = state_66203;
(statearr_66215[(4)] = cljs.core.cons((5),(state_66203[(4)])));

return statearr_66215;
})();
var inst_66169 = cljs.core.not(auth);
var state_66203__$1 = state_66203;
if(inst_66169){
var statearr_66216_66245 = state_66203__$1;
(statearr_66216_66245[(1)] = (6));

} else {
var statearr_66217_66246 = state_66203__$1;
(statearr_66217_66246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (11))){
var inst_66196 = (state_66203[(2)]);
var state_66203__$1 = state_66203;
var statearr_66219_66247 = state_66203__$1;
(statearr_66219_66247[(2)] = inst_66196);

(statearr_66219_66247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (9))){
var inst_66174 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_66203__$1 = state_66203;
var statearr_66220_66248 = state_66203__$1;
(statearr_66220_66248[(2)] = inst_66174);

(statearr_66220_66248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (5))){
var _ = (function (){var statearr_66221 = state_66203;
(statearr_66221[(4)] = cljs.core.rest((state_66203[(4)])));

return statearr_66221;
})();
var state_66203__$1 = state_66203;
var ex66218 = (state_66203__$1[(2)]);
var statearr_66222_66249 = state_66203__$1;
(statearr_66222_66249[(5)] = ex66218);


if((ex66218 instanceof Error)){
var statearr_66223_66250 = state_66203__$1;
(statearr_66223_66250[(1)] = (4));

(statearr_66223_66250[(5)] = null);

} else {
throw ex66218;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (14))){
var inst_66194 = (state_66203[(2)]);
var state_66203__$1 = state_66203;
var statearr_66224_66251 = state_66203__$1;
(statearr_66224_66251[(2)] = inst_66194);

(statearr_66224_66251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (16))){
var inst_66180 = (state_66203[(7)]);
var inst_66182 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66180);
var state_66203__$1 = state_66203;
var statearr_66225_66252 = state_66203__$1;
(statearr_66225_66252[(2)] = inst_66182);

(statearr_66225_66252[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (10))){
var state_66203__$1 = state_66203;
var statearr_66226_66253 = state_66203__$1;
(statearr_66226_66253[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (18))){
var inst_66191 = (state_66203[(2)]);
var state_66203__$1 = state_66203;
var statearr_66228_66254 = state_66203__$1;
(statearr_66228_66254[(2)] = inst_66191);

(statearr_66228_66254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66204 === (8))){
var inst_66198 = (state_66203[(2)]);
var _ = (function (){var statearr_66229 = state_66203;
(statearr_66229[(4)] = cljs.core.rest((state_66203[(4)])));

return statearr_66229;
})();
var state_66203__$1 = state_66203;
var statearr_66230_66255 = state_66203__$1;
(statearr_66230_66255[(2)] = inst_66198);

(statearr_66230_66255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0 = (function (){
var statearr_66231 = [null,null,null,null,null,null,null,null];
(statearr_66231[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__);

(statearr_66231[(1)] = (1));

return statearr_66231;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1 = (function (state_66203){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66203);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66232){var ex__2417__auto__ = e66232;
var statearr_66233_66256 = state_66203;
(statearr_66233_66256[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66203[(4)]))){
var statearr_66234_66257 = state_66203;
(statearr_66234_66257[(1)] = cljs.core.first((state_66203[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66258 = state_66203;
state_66203 = G__66258;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__ = function(state_66203){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1.call(this,state_66203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66235 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66235[(6)] = c__2436__auto__);

return statearr_66235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66322){
var state_val_66323 = (state_66322[(1)]);
if((state_val_66323 === (7))){
var inst_66268 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66322__$1 = state_66322;
if(inst_66268){
var statearr_66324_66373 = state_66322__$1;
(statearr_66324_66373[(1)] = (9));

} else {
var statearr_66325_66374 = state_66322__$1;
(statearr_66325_66374[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (20))){
var inst_66292 = (state_66322[(7)]);
var state_66322__$1 = state_66322;
if(cljs.core.truth_(inst_66292)){
var statearr_66326_66375 = state_66322__$1;
(statearr_66326_66375[(1)] = (22));

} else {
var statearr_66327_66376 = state_66322__$1;
(statearr_66327_66376[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (27))){
var state_66322__$1 = state_66322;
var statearr_66328_66377 = state_66322__$1;
(statearr_66328_66377[(2)] = null);

(statearr_66328_66377[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (1))){
var state_66322__$1 = state_66322;
var statearr_66329_66378 = state_66322__$1;
(statearr_66329_66378[(2)] = null);

(statearr_66329_66378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (24))){
var inst_66306 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66330_66379 = state_66322__$1;
(statearr_66330_66379[(2)] = inst_66306);

(statearr_66330_66379[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (4))){
var inst_66259 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66331_66380 = state_66322__$1;
(statearr_66331_66380[(2)] = inst_66259);

(statearr_66331_66380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (15))){
var inst_66275 = (state_66322[(8)]);
var inst_66274 = (state_66322[(2)]);
var inst_66275__$1 = fluree.db.util.async.throw_err(inst_66274);
var state_66322__$1 = (function (){var statearr_66332 = state_66322;
(statearr_66332[(8)] = inst_66275__$1);

return statearr_66332;
})();
if(cljs.core.truth_(inst_66275__$1)){
var statearr_66333_66381 = state_66322__$1;
(statearr_66333_66381[(1)] = (16));

} else {
var statearr_66334_66382 = state_66322__$1;
(statearr_66334_66382[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (21))){
var inst_66308 = (state_66322[(9)]);
var inst_66308__$1 = (state_66322[(2)]);
var state_66322__$1 = (function (){var statearr_66335 = state_66322;
(statearr_66335[(9)] = inst_66308__$1);

return statearr_66335;
})();
if(cljs.core.truth_(inst_66308__$1)){
var statearr_66336_66383 = state_66322__$1;
(statearr_66336_66383[(1)] = (29));

} else {
var statearr_66337_66384 = state_66322__$1;
(statearr_66337_66384[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (31))){
var inst_66292 = (state_66322[(7)]);
var inst_66308 = (state_66322[(9)]);
var inst_66316 = (state_66322[(2)]);
var inst_66317 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66292,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_66308,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66316], 0));
var _ = (function (){var statearr_66338 = state_66322;
(statearr_66338[(4)] = cljs.core.rest((state_66322[(4)])));

return statearr_66338;
})();
var state_66322__$1 = state_66322;
var statearr_66339_66385 = state_66322__$1;
(statearr_66339_66385[(2)] = inst_66317);

(statearr_66339_66385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (32))){
var inst_66312 = (state_66322[(2)]);
var inst_66313 = fluree.db.util.async.throw_err(inst_66312);
var state_66322__$1 = state_66322;
var statearr_66340_66386 = state_66322__$1;
(statearr_66340_66386[(2)] = inst_66313);

(statearr_66340_66386[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (13))){
var state_66322__$1 = state_66322;
var statearr_66341_66387 = state_66322__$1;
(statearr_66341_66387[(2)] = null);

(statearr_66341_66387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (22))){
var inst_66292 = (state_66322[(7)]);
var inst_66296 = fluree.db.auth.roles(db,inst_66292);
var state_66322__$1 = state_66322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66322__$1,(25),inst_66296);
} else {
if((state_val_66323 === (29))){
var inst_66308 = (state_66322[(9)]);
var inst_66310 = fluree.db.permissions.permission_map(db,inst_66308,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66322__$1 = state_66322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66322__$1,(32),inst_66310);
} else {
if((state_val_66323 === (6))){
var state_66322__$1 = state_66322;
var statearr_66342_66388 = state_66322__$1;
(statearr_66342_66388[(2)] = null);

(statearr_66342_66388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (28))){
var inst_66304 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66343_66389 = state_66322__$1;
(statearr_66343_66389[(2)] = inst_66304);

(statearr_66343_66389[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (25))){
var inst_66298 = (state_66322[(2)]);
var inst_66299 = fluree.db.util.async.throw_err(inst_66298);
var state_66322__$1 = state_66322;
var statearr_66344_66390 = state_66322__$1;
(statearr_66344_66390[(2)] = inst_66299);

(statearr_66344_66390[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (17))){
var inst_66278 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66279 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66280 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66281 = cljs.core.PersistentHashMap.fromArrays(inst_66279,inst_66280);
var inst_66282 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66278,inst_66281);
var inst_66283 = (function(){throw inst_66282})();
var state_66322__$1 = state_66322;
var statearr_66345_66391 = state_66322__$1;
(statearr_66345_66391[(2)] = inst_66283);

(statearr_66345_66391[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (3))){
var inst_66320 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66322__$1,inst_66320);
} else {
if((state_val_66323 === (12))){
var inst_66272 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66322__$1 = state_66322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66322__$1,(15),inst_66272);
} else {
if((state_val_66323 === (2))){
var _ = (function (){var statearr_66346 = state_66322;
(statearr_66346[(4)] = cljs.core.cons((5),(state_66322[(4)])));

return statearr_66346;
})();
var inst_66265 = (auth == null);
var state_66322__$1 = state_66322;
if(cljs.core.truth_(inst_66265)){
var statearr_66347_66392 = state_66322__$1;
(statearr_66347_66392[(1)] = (6));

} else {
var statearr_66348_66393 = state_66322__$1;
(statearr_66348_66393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (23))){
var state_66322__$1 = state_66322;
var statearr_66349_66394 = state_66322__$1;
(statearr_66349_66394[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (19))){
var state_66322__$1 = state_66322;
var statearr_66351_66395 = state_66322__$1;
(statearr_66351_66395[(2)] = roles);

(statearr_66351_66395[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (11))){
var inst_66290 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66353_66396 = state_66322__$1;
(statearr_66353_66396[(2)] = inst_66290);

(statearr_66353_66396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (9))){
var state_66322__$1 = state_66322;
var statearr_66354_66397 = state_66322__$1;
(statearr_66354_66397[(2)] = (0));

(statearr_66354_66397[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (5))){
var _ = (function (){var statearr_66355 = state_66322;
(statearr_66355[(4)] = cljs.core.rest((state_66322[(4)])));

return statearr_66355;
})();
var state_66322__$1 = state_66322;
var ex66352 = (state_66322__$1[(2)]);
var statearr_66356_66398 = state_66322__$1;
(statearr_66356_66398[(5)] = ex66352);


if((ex66352 instanceof Error)){
var statearr_66357_66399 = state_66322__$1;
(statearr_66357_66399[(1)] = (4));

(statearr_66357_66399[(5)] = null);

} else {
throw ex66352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (14))){
var inst_66288 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66358_66400 = state_66322__$1;
(statearr_66358_66400[(2)] = inst_66288);

(statearr_66358_66400[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (26))){
var state_66322__$1 = state_66322;
var statearr_66359_66401 = state_66322__$1;
(statearr_66359_66401[(2)] = null);

(statearr_66359_66401[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (16))){
var inst_66275 = (state_66322[(8)]);
var state_66322__$1 = state_66322;
var statearr_66360_66402 = state_66322__$1;
(statearr_66360_66402[(2)] = inst_66275);

(statearr_66360_66402[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (30))){
var state_66322__$1 = state_66322;
var statearr_66361_66403 = state_66322__$1;
(statearr_66361_66403[(2)] = null);

(statearr_66361_66403[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (10))){
var state_66322__$1 = state_66322;
if(cljs.core.truth_(auth)){
var statearr_66362_66404 = state_66322__$1;
(statearr_66362_66404[(1)] = (12));

} else {
var statearr_66363_66405 = state_66322__$1;
(statearr_66363_66405[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (18))){
var inst_66285 = (state_66322[(2)]);
var state_66322__$1 = state_66322;
var statearr_66364_66406 = state_66322__$1;
(statearr_66364_66406[(2)] = inst_66285);

(statearr_66364_66406[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66323 === (8))){
var inst_66292 = (state_66322[(2)]);
var state_66322__$1 = (function (){var statearr_66365 = state_66322;
(statearr_66365[(7)] = inst_66292);

return statearr_66365;
})();
if(cljs.core.truth_(roles)){
var statearr_66366_66407 = state_66322__$1;
(statearr_66366_66407[(1)] = (19));

} else {
var statearr_66367_66408 = state_66322__$1;
(statearr_66367_66408[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0 = (function (){
var statearr_66368 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66368[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__);

(statearr_66368[(1)] = (1));

return statearr_66368;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1 = (function (state_66322){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66322);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66369){var ex__2417__auto__ = e66369;
var statearr_66370_66409 = state_66322;
(statearr_66370_66409[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66322[(4)]))){
var statearr_66371_66410 = state_66322;
(statearr_66371_66410[(1)] = cljs.core.first((state_66322[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66411 = state_66322;
state_66322 = G__66411;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__ = function(state_66322){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1.call(this,state_66322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66372 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66372[(6)] = c__2436__auto__);

return statearr_66372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__66412 = db;
var map__66412__$1 = (((((!((map__66412 == null))))?(((((map__66412.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66412.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66412):map__66412);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66412__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66412__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66412__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66420){
var state_val_66421 = (state_66420[(1)]);
if((state_val_66421 === (1))){
var inst_66414 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66415 = fluree.db.session.db(conn,inst_66414,null);
var state_66420__$1 = state_66420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66420__$1,(2),inst_66415);
} else {
if((state_val_66421 === (2))){
var inst_66417 = (state_66420[(2)]);
var inst_66418 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66417);
var state_66420__$1 = state_66420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66420__$1,inst_66418);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0 = (function (){
var statearr_66422 = [null,null,null,null,null,null,null];
(statearr_66422[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__);

(statearr_66422[(1)] = (1));

return statearr_66422;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1 = (function (state_66420){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66420);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66423){var ex__2417__auto__ = e66423;
var statearr_66424_66451 = state_66420;
(statearr_66424_66451[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66420[(4)]))){
var statearr_66425_66452 = state_66420;
(statearr_66425_66452[(1)] = cljs.core.first((state_66420[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66453 = state_66420;
state_66420 = G__66453;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = function(state_66420){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1.call(this,state_66420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66426 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66426[(6)] = c__2436__auto__);

return statearr_66426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66439){
var state_val_66440 = (state_66439[(1)]);
if((state_val_66440 === (1))){
var inst_66427 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_66428 = fluree.db.session.db(conn,inst_66427,null);
var state_66439__$1 = state_66439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66439__$1,(2),inst_66428);
} else {
if((state_val_66440 === (2))){
var inst_66430 = (state_66439[(7)]);
var inst_66430__$1 = (state_66439[(2)]);
var inst_66431 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66430__$1);
var inst_66432 = newer_block_QMARK_(inst_66431);
var state_66439__$1 = (function (){var statearr_66441 = state_66439;
(statearr_66441[(7)] = inst_66430__$1);

return statearr_66441;
})();
if(inst_66432){
var statearr_66442_66454 = state_66439__$1;
(statearr_66442_66454[(1)] = (3));

} else {
var statearr_66443_66455 = state_66439__$1;
(statearr_66443_66455[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66440 === (3))){
var inst_66430 = (state_66439[(7)]);
var inst_66434 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_66430);
var state_66439__$1 = state_66439;
var statearr_66444_66456 = state_66439__$1;
(statearr_66444_66456[(2)] = inst_66434);

(statearr_66444_66456[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66440 === (4))){
var state_66439__$1 = state_66439;
var statearr_66445_66457 = state_66439__$1;
(statearr_66445_66457[(2)] = null);

(statearr_66445_66457[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66440 === (5))){
var inst_66437 = (state_66439[(2)]);
var state_66439__$1 = state_66439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66439__$1,inst_66437);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0 = (function (){
var statearr_66446 = [null,null,null,null,null,null,null,null];
(statearr_66446[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__);

(statearr_66446[(1)] = (1));

return statearr_66446;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1 = (function (state_66439){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66439);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66447){var ex__2417__auto__ = e66447;
var statearr_66448_66458 = state_66439;
(statearr_66448_66458[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66439[(4)]))){
var statearr_66449_66459 = state_66439;
(statearr_66449_66459[(1)] = cljs.core.first((state_66439[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66460 = state_66439;
state_66439 = G__66460;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__ = function(state_66439){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1.call(this,state_66439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66450 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66450[(6)] = c__2436__auto__);

return statearr_66450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__66461 = db;
var map__66461__$1 = (((((!((map__66461 == null))))?(((((map__66461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66461.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66461):map__66461);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66461__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66461__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66461__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2436__auto___66538 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66512){
var state_val_66513 = (state_66512[(1)]);
if((state_val_66513 === (7))){
var inst_66478 = (state_66512[(7)]);
var inst_66489 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66478,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_66512__$1 = state_66512;
if(inst_66489){
var statearr_66514_66539 = state_66512__$1;
(statearr_66514_66539[(1)] = (9));

} else {
var statearr_66515_66540 = state_66512__$1;
(statearr_66515_66540[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (1))){
var inst_66463 = (state_66512[(8)]);
var inst_66471 = (state_66512[(9)]);
var inst_66463__$1 = cljs.core.async.timeout(timeout);
var inst_66471__$1 = res_port;
var inst_66472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66473 = [inst_66463__$1,inst_66471__$1];
var inst_66474 = (new cljs.core.PersistentVector(null,2,(5),inst_66472,inst_66473,null));
var state_66512__$1 = (function (){var statearr_66516 = state_66512;
(statearr_66516[(8)] = inst_66463__$1);

(statearr_66516[(9)] = inst_66471__$1);

return statearr_66516;
})();
return cljs.core.async.ioc_alts_BANG_(state_66512__$1,(2),inst_66474);
} else {
if((state_val_66513 === (4))){
var inst_66478 = (state_66512[(7)]);
var inst_66471 = (state_66512[(9)]);
var inst_66482 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66478,inst_66471);
var state_66512__$1 = state_66512;
if(inst_66482){
var statearr_66517_66541 = state_66512__$1;
(statearr_66517_66541[(1)] = (6));

} else {
var statearr_66518_66542 = state_66512__$1;
(statearr_66518_66542[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (13))){
var inst_66497 = (state_66512[(10)]);
var inst_66508 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66497);
var state_66512__$1 = state_66512;
var statearr_66519_66543 = state_66512__$1;
(statearr_66519_66543[(2)] = inst_66508);

(statearr_66519_66543[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (6))){
var inst_66476 = (state_66512[(11)]);
var inst_66487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66476,(0),null);
var state_66512__$1 = state_66512;
var statearr_66520_66544 = state_66512__$1;
(statearr_66520_66544[(2)] = inst_66487);

(statearr_66520_66544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (3))){
var state_66512__$1 = state_66512;
var statearr_66521_66545 = state_66512__$1;
(statearr_66521_66545[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_66521_66545[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (12))){
var inst_66501 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_66502 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66503 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_66504 = cljs.core.PersistentHashMap.fromArrays(inst_66502,inst_66503);
var inst_66505 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66501,inst_66504);
var inst_66506 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66505);
var state_66512__$1 = state_66512;
var statearr_66522_66546 = state_66512__$1;
(statearr_66522_66546[(2)] = inst_66506);

(statearr_66522_66546[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (2))){
var inst_66463 = (state_66512[(8)]);
var inst_66476 = (state_66512[(11)]);
var inst_66478 = (state_66512[(7)]);
var inst_66476__$1 = (state_66512[(2)]);
var inst_66477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66476__$1,(0),null);
var inst_66478__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66476__$1,(1),null);
var inst_66479 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66478__$1,inst_66463);
var state_66512__$1 = (function (){var statearr_66523 = state_66512;
(statearr_66523[(11)] = inst_66476__$1);

(statearr_66523[(12)] = inst_66477);

(statearr_66523[(7)] = inst_66478__$1);

return statearr_66523;
})();
if(inst_66479){
var statearr_66524_66547 = state_66512__$1;
(statearr_66524_66547[(1)] = (3));

} else {
var statearr_66525_66548 = state_66512__$1;
(statearr_66525_66548[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (11))){
var inst_66493 = (state_66512[(2)]);
var state_66512__$1 = state_66512;
var statearr_66526_66549 = state_66512__$1;
(statearr_66526_66549[(2)] = inst_66493);

(statearr_66526_66549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (9))){
var inst_66477 = (state_66512[(12)]);
var state_66512__$1 = state_66512;
var statearr_66527_66550 = state_66512__$1;
(statearr_66527_66550[(2)] = inst_66477);

(statearr_66527_66550[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (5))){
var inst_66497 = (state_66512[(10)]);
var inst_66497__$1 = (state_66512[(2)]);
var inst_66498 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_66499 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_66497__$1);
var state_66512__$1 = (function (){var statearr_66528 = state_66512;
(statearr_66528[(10)] = inst_66497__$1);

(statearr_66528[(13)] = inst_66498);

return statearr_66528;
})();
if(inst_66499){
var statearr_66529_66551 = state_66512__$1;
(statearr_66529_66551[(1)] = (12));

} else {
var statearr_66530_66552 = state_66512__$1;
(statearr_66530_66552[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (14))){
var inst_66510 = (state_66512[(2)]);
var state_66512__$1 = state_66512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66512__$1,inst_66510);
} else {
if((state_val_66513 === (10))){
var state_66512__$1 = state_66512;
var statearr_66531_66553 = state_66512__$1;
(statearr_66531_66553[(2)] = null);

(statearr_66531_66553[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66513 === (8))){
var inst_66495 = (state_66512[(2)]);
var state_66512__$1 = state_66512;
var statearr_66532_66554 = state_66512__$1;
(statearr_66532_66554[(2)] = inst_66495);

(statearr_66532_66554[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0 = (function (){
var statearr_66533 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66533[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__);

(statearr_66533[(1)] = (1));

return statearr_66533;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1 = (function (state_66512){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66512);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66534){var ex__2417__auto__ = e66534;
var statearr_66535_66555 = state_66512;
(statearr_66535_66555[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66512[(4)]))){
var statearr_66536_66556 = state_66512;
(statearr_66536_66556[(1)] = cljs.core.first((state_66512[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66557 = state_66512;
state_66512 = G__66557;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__ = function(state_66512){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1.call(this,state_66512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66537 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66537[(6)] = c__2436__auto___66538);

return statearr_66537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__66559 = arguments.length;
switch (G__66559) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__66560){
var map__66561 = p__66560;
var map__66561__$1 = (((((!((map__66561 == null))))?(((((map__66561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66561.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66561):map__66561);
var opts = map__66561__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66561__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66561__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66561__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66561__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66561__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___66651 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66613){
var state_val_66614 = (state_66613[(1)]);
if((state_val_66614 === (7))){
var inst_66575 = (state_66613[(7)]);
var inst_66577 = fluree.db.api.ledger.syncTo_db(inst_66575,syncTo,syncTimeout);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66613__$1,(10),inst_66577);
} else {
if((state_val_66614 === (20))){
var inst_66599 = (state_66613[(8)]);
var state_66613__$1 = state_66613;
var statearr_66615_66652 = state_66613__$1;
(statearr_66615_66652[(2)] = inst_66599);

(statearr_66615_66652[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (1))){
var state_66613__$1 = state_66613;
var statearr_66616_66653 = state_66613__$1;
(statearr_66616_66653[(2)] = null);

(statearr_66616_66653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (4))){
var inst_66563 = (state_66613[(2)]);
var inst_66564 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66563);
var inst_66565 = cljs.core.async.close_BANG_(pc);
var state_66613__$1 = (function (){var statearr_66617 = state_66613;
(statearr_66617[(9)] = inst_66564);

return statearr_66617;
})();
var statearr_66618_66654 = state_66613__$1;
(statearr_66618_66654[(2)] = inst_66565);

(statearr_66618_66654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (15))){
var inst_66591 = (state_66613[(10)]);
var inst_66593 = fluree.db.api.ledger.add_db_permissions(inst_66591,auth,roles);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66613__$1,(18),inst_66593);
} else {
if((state_val_66614 === (21))){
var inst_66607 = (state_66613[(2)]);
var inst_66608 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66607);
var _ = (function (){var statearr_66619 = state_66613;
(statearr_66619[(4)] = cljs.core.rest((state_66613[(4)])));

return statearr_66619;
})();
var state_66613__$1 = state_66613;
var statearr_66620_66655 = state_66613__$1;
(statearr_66620_66655[(2)] = inst_66608);

(statearr_66620_66655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (13))){
var inst_66591 = (state_66613[(2)]);
var state_66613__$1 = (function (){var statearr_66621 = state_66613;
(statearr_66621[(10)] = inst_66591);

return statearr_66621;
})();
if(cljs.core.truth_(roles)){
var statearr_66622_66656 = state_66613__$1;
(statearr_66622_66656[(1)] = (15));

} else {
var statearr_66623_66657 = state_66613__$1;
(statearr_66623_66657[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (22))){
var inst_66603 = (state_66613[(2)]);
var inst_66604 = fluree.db.util.async.throw_err(inst_66603);
var state_66613__$1 = state_66613;
var statearr_66624_66658 = state_66613__$1;
(statearr_66624_66658[(2)] = inst_66604);

(statearr_66624_66658[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (6))){
var inst_66574 = (state_66613[(2)]);
var inst_66575 = fluree.db.util.async.throw_err(inst_66574);
var state_66613__$1 = (function (){var statearr_66625 = state_66613;
(statearr_66625[(7)] = inst_66575);

return statearr_66625;
})();
if(cljs.core.truth_(syncTo)){
var statearr_66626_66659 = state_66613__$1;
(statearr_66626_66659[(1)] = (7));

} else {
var statearr_66627_66660 = state_66613__$1;
(statearr_66627_66660[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (17))){
var inst_66599 = (state_66613[(2)]);
var state_66613__$1 = (function (){var statearr_66628 = state_66613;
(statearr_66628[(8)] = inst_66599);

return statearr_66628;
})();
if(cljs.core.truth_(auth)){
var statearr_66629_66661 = state_66613__$1;
(statearr_66629_66661[(1)] = (19));

} else {
var statearr_66630_66662 = state_66613__$1;
(statearr_66630_66662[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (3))){
var inst_66611 = (state_66613[(2)]);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66613__$1,inst_66611);
} else {
if((state_val_66614 === (12))){
var inst_66583 = (state_66613[(11)]);
var state_66613__$1 = state_66613;
var statearr_66631_66663 = state_66613__$1;
(statearr_66631_66663[(2)] = inst_66583);

(statearr_66631_66663[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (2))){
var _ = (function (){var statearr_66632 = state_66613;
(statearr_66632[(4)] = cljs.core.cons((5),(state_66613[(4)])));

return statearr_66632;
})();
var inst_66572 = fluree.db.session.db(conn,ledger,null);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66613__$1,(6),inst_66572);
} else {
if((state_val_66614 === (19))){
var inst_66599 = (state_66613[(8)]);
var inst_66601 = fluree.db.api.ledger.add_db_permissions(inst_66599,auth,roles);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66613__$1,(22),inst_66601);
} else {
if((state_val_66614 === (11))){
var inst_66583 = (state_66613[(11)]);
var inst_66585 = fluree.db.time_travel.as_of_block(inst_66583,block);
var state_66613__$1 = state_66613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66613__$1,(14),inst_66585);
} else {
if((state_val_66614 === (9))){
var inst_66583 = (state_66613[(2)]);
var state_66613__$1 = (function (){var statearr_66634 = state_66613;
(statearr_66634[(11)] = inst_66583);

return statearr_66634;
})();
if(cljs.core.truth_(block)){
var statearr_66635_66664 = state_66613__$1;
(statearr_66635_66664[(1)] = (11));

} else {
var statearr_66636_66665 = state_66613__$1;
(statearr_66636_66665[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (5))){
var _ = (function (){var statearr_66637 = state_66613;
(statearr_66637[(4)] = cljs.core.rest((state_66613[(4)])));

return statearr_66637;
})();
var state_66613__$1 = state_66613;
var ex66633 = (state_66613__$1[(2)]);
var statearr_66638_66666 = state_66613__$1;
(statearr_66638_66666[(5)] = ex66633);


if((ex66633 instanceof fluree.db.api.ledger.Exception)){
var statearr_66639_66667 = state_66613__$1;
(statearr_66639_66667[(1)] = (4));

(statearr_66639_66667[(5)] = null);

} else {
throw ex66633;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (14))){
var inst_66587 = (state_66613[(2)]);
var inst_66588 = fluree.db.util.async.throw_err(inst_66587);
var state_66613__$1 = state_66613;
var statearr_66640_66668 = state_66613__$1;
(statearr_66640_66668[(2)] = inst_66588);

(statearr_66640_66668[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (16))){
var inst_66591 = (state_66613[(10)]);
var state_66613__$1 = state_66613;
var statearr_66641_66669 = state_66613__$1;
(statearr_66641_66669[(2)] = inst_66591);

(statearr_66641_66669[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (10))){
var inst_66579 = (state_66613[(2)]);
var inst_66580 = fluree.db.util.async.throw_err(inst_66579);
var state_66613__$1 = state_66613;
var statearr_66642_66670 = state_66613__$1;
(statearr_66642_66670[(2)] = inst_66580);

(statearr_66642_66670[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (18))){
var inst_66595 = (state_66613[(2)]);
var inst_66596 = fluree.db.util.async.throw_err(inst_66595);
var state_66613__$1 = state_66613;
var statearr_66643_66671 = state_66613__$1;
(statearr_66643_66671[(2)] = inst_66596);

(statearr_66643_66671[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66614 === (8))){
var inst_66575 = (state_66613[(7)]);
var state_66613__$1 = state_66613;
var statearr_66644_66672 = state_66613__$1;
(statearr_66644_66672[(2)] = inst_66575);

(statearr_66644_66672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2414__auto__ = null;
var fluree$db$api$ledger$state_machine__2414__auto____0 = (function (){
var statearr_66645 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66645[(0)] = fluree$db$api$ledger$state_machine__2414__auto__);

(statearr_66645[(1)] = (1));

return statearr_66645;
});
var fluree$db$api$ledger$state_machine__2414__auto____1 = (function (state_66613){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66613);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66646){var ex__2417__auto__ = e66646;
var statearr_66647_66673 = state_66613;
(statearr_66647_66673[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66613[(4)]))){
var statearr_66648_66674 = state_66613;
(statearr_66648_66674[(1)] = cljs.core.first((state_66613[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66675 = state_66613;
state_66613 = G__66675;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2414__auto__ = function(state_66613){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2414__auto____1.call(this,state_66613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2414__auto____0;
fluree$db$api$ledger$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2414__auto____1;
return fluree$db$api$ledger$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66649 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66649[(6)] = c__2436__auto___66651);

return statearr_66649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

