// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59869 = arguments.length;
switch (G__59869) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___60050 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_59976){
var state_val_59977 = (state_59976[(1)]);
if((state_val_59977 === (7))){
var inst_59883 = (state_59976[(7)]);
var inst_59888 = inst_59883.cljs$lang$protocol_mask$partition0$;
var inst_59889 = (inst_59888 & (64));
var inst_59890 = inst_59883.cljs$core$ISeq$;
var inst_59891 = (cljs.core.PROTOCOL_SENTINEL === inst_59890);
var inst_59892 = ((inst_59889) || (inst_59891));
var state_59976__$1 = state_59976;
if(cljs.core.truth_(inst_59892)){
var statearr_59978_60051 = state_59976__$1;
(statearr_59978_60051[(1)] = (10));

} else {
var statearr_59979_60052 = state_59976__$1;
(statearr_59979_60052[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (20))){
var state_59976__$1 = state_59976;
var statearr_59980_60053 = state_59976__$1;
(statearr_59980_60053[(2)] = null);

(statearr_59980_60053[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (27))){
var inst_59931 = (state_59976[(8)]);
var state_59976__$1 = state_59976;
if(cljs.core.truth_(inst_59931)){
var statearr_59981_60054 = state_59976__$1;
(statearr_59981_60054[(1)] = (29));

} else {
var statearr_59982_60055 = state_59976__$1;
(statearr_59982_60055[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (1))){
var state_59976__$1 = state_59976;
var statearr_59983_60056 = state_59976__$1;
(statearr_59983_60056[(2)] = null);

(statearr_59983_60056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (24))){
var inst_59907 = (state_59976[(9)]);
var inst_59921 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59907)," unknown."].join('');
var inst_59922 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59923 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59924 = cljs.core.PersistentHashMap.fromArrays(inst_59922,inst_59923);
var inst_59925 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59921,inst_59924);
var inst_59926 = (function(){throw inst_59925})();
var state_59976__$1 = state_59976;
var statearr_59984_60057 = state_59976__$1;
(statearr_59984_60057[(2)] = inst_59926);

(statearr_59984_60057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (39))){
var inst_59953 = (state_59976[(2)]);
var inst_59954 = fluree.db.util.async.throw_err(inst_59953);
var state_59976__$1 = state_59976;
var statearr_59985_60058 = state_59976__$1;
(statearr_59985_60058[(2)] = inst_59954);

(statearr_59985_60058[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (46))){
var inst_59962 = (state_59976[(10)]);
var inst_59965 = (state_59976[(2)]);
var inst_59966 = fluree.db.util.async.throw_err(inst_59965);
var inst_59967 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59962,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59966);
var state_59976__$1 = state_59976;
var statearr_59986_60059 = state_59976__$1;
(statearr_59986_60059[(2)] = inst_59967);

(statearr_59986_60059[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (4))){
var inst_59870 = (state_59976[(2)]);
var inst_59871 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59870);
var inst_59872 = cljs.core.async.close_BANG_(pc);
var state_59976__$1 = (function (){var statearr_59987 = state_59976;
(statearr_59987[(11)] = inst_59871);

return statearr_59987;
})();
var statearr_59988_60060 = state_59976__$1;
(statearr_59988_60060[(2)] = inst_59872);

(statearr_59988_60060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (15))){
var inst_59907 = (state_59976[(9)]);
var inst_59904 = (state_59976[(2)]);
var inst_59905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59904,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59906 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59904,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59907__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59904,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59908 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59904,new cljs.core.Keyword(null,"block","block",664686210));
var state_59976__$1 = (function (){var statearr_59989 = state_59976;
(statearr_59989[(12)] = inst_59908);

(statearr_59989[(13)] = inst_59905);

(statearr_59989[(9)] = inst_59907__$1);

(statearr_59989[(14)] = inst_59906);

return statearr_59989;
})();
if(cljs.core.truth_(inst_59907__$1)){
var statearr_59990_60061 = state_59976__$1;
(statearr_59990_60061[(1)] = (16));

} else {
var statearr_59991_60062 = state_59976__$1;
(statearr_59991_60062[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (21))){
var inst_59905 = (state_59976[(13)]);
var inst_59931 = (state_59976[(2)]);
var state_59976__$1 = (function (){var statearr_59992 = state_59976;
(statearr_59992[(8)] = inst_59931);

return statearr_59992;
})();
if(cljs.core.truth_(inst_59905)){
var statearr_59993_60063 = state_59976__$1;
(statearr_59993_60063[(1)] = (26));

} else {
var statearr_59994_60064 = state_59976__$1;
(statearr_59994_60064[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (31))){
var inst_59941 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
var statearr_59995_60065 = state_59976__$1;
(statearr_59995_60065[(2)] = inst_59941);

(statearr_59995_60065[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (32))){
var inst_59937 = (state_59976[(2)]);
var inst_59938 = fluree.db.util.async.throw_err(inst_59937);
var state_59976__$1 = state_59976;
var statearr_59996_60066 = state_59976__$1;
(statearr_59996_60066[(2)] = inst_59938);

(statearr_59996_60066[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (40))){
var inst_59907 = (state_59976[(9)]);
var inst_59957 = (state_59976[(15)]);
var inst_59959 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59957,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59907);
var state_59976__$1 = state_59976;
var statearr_59997_60067 = state_59976__$1;
(statearr_59997_60067[(2)] = inst_59959);

(statearr_59997_60067[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (33))){
var inst_59882 = (state_59976[(16)]);
var inst_59943 = (state_59976[(17)]);
var inst_59945 = fluree.db.permissions.permission_map(inst_59882,inst_59943,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59976__$1 = state_59976;
var statearr_59998_60068 = state_59976__$1;
(statearr_59998_60068[(2)] = inst_59945);

(statearr_59998_60068[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (13))){
var inst_59883 = (state_59976[(7)]);
var inst_59901 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_59883);
var state_59976__$1 = state_59976;
var statearr_59999_60069 = state_59976__$1;
(statearr_59999_60069[(2)] = inst_59901);

(statearr_59999_60069[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (22))){
var inst_59918 = (state_59976[(18)]);
var inst_59917 = (state_59976[(2)]);
var inst_59918__$1 = fluree.db.util.async.throw_err(inst_59917);
var state_59976__$1 = (function (){var statearr_60000 = state_59976;
(statearr_60000[(18)] = inst_59918__$1);

return statearr_60000;
})();
if(cljs.core.truth_(inst_59918__$1)){
var statearr_60001_60070 = state_59976__$1;
(statearr_60001_60070[(1)] = (23));

} else {
var statearr_60002_60071 = state_59976__$1;
(statearr_60002_60071[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (36))){
var inst_59882 = (state_59976[(16)]);
var inst_59950 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59951 = fluree.db.time_travel.as_of_block(inst_59882,inst_59950);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59976__$1,(39),inst_59951);
} else {
if((state_val_59977 === (41))){
var inst_59957 = (state_59976[(15)]);
var state_59976__$1 = state_59976;
var statearr_60003_60072 = state_59976__$1;
(statearr_60003_60072[(2)] = inst_59957);

(statearr_60003_60072[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (43))){
var inst_59948 = (state_59976[(19)]);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59976__$1,(46),inst_59948);
} else {
if((state_val_59977 === (29))){
var inst_59882 = (state_59976[(16)]);
var inst_59931 = (state_59976[(8)]);
var inst_59935 = fluree.db.auth.roles(inst_59882,inst_59931);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59976__$1,(32),inst_59935);
} else {
if((state_val_59977 === (44))){
var inst_59962 = (state_59976[(10)]);
var state_59976__$1 = state_59976;
var statearr_60004_60073 = state_59976__$1;
(statearr_60004_60073[(2)] = inst_59962);

(statearr_60004_60073[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (6))){
var inst_59883 = (state_59976[(7)]);
var inst_59881 = (state_59976[(2)]);
var inst_59882 = fluree.db.util.async.throw_err(inst_59881);
var inst_59883__$1 = opts;
var inst_59885 = (inst_59883__$1 == null);
var inst_59886 = cljs.core.not(inst_59885);
var state_59976__$1 = (function (){var statearr_60005 = state_59976;
(statearr_60005[(16)] = inst_59882);

(statearr_60005[(7)] = inst_59883__$1);

return statearr_60005;
})();
if(inst_59886){
var statearr_60006_60074 = state_59976__$1;
(statearr_60006_60074[(1)] = (7));

} else {
var statearr_60007_60075 = state_59976__$1;
(statearr_60007_60075[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (28))){
var inst_59943 = (state_59976[(17)]);
var inst_59943__$1 = (state_59976[(2)]);
var state_59976__$1 = (function (){var statearr_60008 = state_59976;
(statearr_60008[(17)] = inst_59943__$1);

return statearr_60008;
})();
if(cljs.core.truth_(inst_59943__$1)){
var statearr_60009_60076 = state_59976__$1;
(statearr_60009_60076[(1)] = (33));

} else {
var statearr_60010_60077 = state_59976__$1;
(statearr_60010_60077[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (25))){
var inst_59928 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
var statearr_60011_60078 = state_59976__$1;
(statearr_60011_60078[(2)] = inst_59928);

(statearr_60011_60078[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (34))){
var state_59976__$1 = state_59976;
var statearr_60012_60079 = state_59976__$1;
(statearr_60012_60079[(2)] = null);

(statearr_60012_60079[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (17))){
var inst_59907 = (state_59976[(9)]);
var state_59976__$1 = state_59976;
var statearr_60013_60080 = state_59976__$1;
(statearr_60013_60080[(2)] = inst_59907);

(statearr_60013_60080[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (3))){
var inst_59974 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59976__$1,inst_59974);
} else {
if((state_val_59977 === (12))){
var inst_59896 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
var statearr_60014_60081 = state_59976__$1;
(statearr_60014_60081[(2)] = inst_59896);

(statearr_60014_60081[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (2))){
var _ = (function (){var statearr_60015 = state_59976;
(statearr_60015[(4)] = cljs.core.cons((5),(state_59976[(4)])));

return statearr_60015;
})();
var inst_59879 = fluree.db.session.db(conn,ledger,null);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59976__$1,(6),inst_59879);
} else {
if((state_val_59977 === (23))){
var inst_59918 = (state_59976[(18)]);
var state_59976__$1 = state_59976;
var statearr_60016_60082 = state_59976__$1;
(statearr_60016_60082[(2)] = inst_59918);

(statearr_60016_60082[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (35))){
var inst_59908 = (state_59976[(12)]);
var inst_59948 = (state_59976[(2)]);
var state_59976__$1 = (function (){var statearr_60017 = state_59976;
(statearr_60017[(19)] = inst_59948);

return statearr_60017;
})();
if(cljs.core.truth_(inst_59908)){
var statearr_60018_60083 = state_59976__$1;
(statearr_60018_60083[(1)] = (36));

} else {
var statearr_60019_60084 = state_59976__$1;
(statearr_60019_60084[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (19))){
var inst_59882 = (state_59976[(16)]);
var inst_59907 = (state_59976[(9)]);
var inst_59915 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_59882,inst_59907);
var state_59976__$1 = state_59976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59976__$1,(22),inst_59915);
} else {
if((state_val_59977 === (11))){
var state_59976__$1 = state_59976;
var statearr_60021_60085 = state_59976__$1;
(statearr_60021_60085[(2)] = false);

(statearr_60021_60085[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (9))){
var inst_59899 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
if(cljs.core.truth_(inst_59899)){
var statearr_60022_60086 = state_59976__$1;
(statearr_60022_60086[(1)] = (13));

} else {
var statearr_60023_60087 = state_59976__$1;
(statearr_60023_60087[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (5))){
var _ = (function (){var statearr_60024 = state_59976;
(statearr_60024[(4)] = cljs.core.rest((state_59976[(4)])));

return statearr_60024;
})();
var state_59976__$1 = state_59976;
var ex60020 = (state_59976__$1[(2)]);
var statearr_60025_60088 = state_59976__$1;
(statearr_60025_60088[(5)] = ex60020);


var statearr_60026_60089 = state_59976__$1;
(statearr_60026_60089[(1)] = (4));

(statearr_60026_60089[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (14))){
var inst_59883 = (state_59976[(7)]);
var state_59976__$1 = state_59976;
var statearr_60027_60090 = state_59976__$1;
(statearr_60027_60090[(2)] = inst_59883);

(statearr_60027_60090[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (45))){
var inst_59970 = (state_59976[(2)]);
var inst_59971 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59970);
var _ = (function (){var statearr_60028 = state_59976;
(statearr_60028[(4)] = cljs.core.rest((state_59976[(4)])));

return statearr_60028;
})();
var state_59976__$1 = state_59976;
var statearr_60029_60091 = state_59976__$1;
(statearr_60029_60091[(2)] = inst_59971);

(statearr_60029_60091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (26))){
var inst_59905 = (state_59976[(13)]);
var state_59976__$1 = state_59976;
var statearr_60030_60092 = state_59976__$1;
(statearr_60030_60092[(2)] = inst_59905);

(statearr_60030_60092[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (16))){
var inst_59907 = (state_59976[(9)]);
var inst_59910 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_59907);
var state_59976__$1 = state_59976;
var statearr_60031_60093 = state_59976__$1;
(statearr_60031_60093[(2)] = inst_59910);

(statearr_60031_60093[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (38))){
var inst_59907 = (state_59976[(9)]);
var inst_59957 = (state_59976[(2)]);
var state_59976__$1 = (function (){var statearr_60032 = state_59976;
(statearr_60032[(15)] = inst_59957);

return statearr_60032;
})();
if(cljs.core.truth_(inst_59907)){
var statearr_60033_60094 = state_59976__$1;
(statearr_60033_60094[(1)] = (40));

} else {
var statearr_60034_60095 = state_59976__$1;
(statearr_60034_60095[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (30))){
var state_59976__$1 = state_59976;
var statearr_60035_60096 = state_59976__$1;
(statearr_60035_60096[(2)] = null);

(statearr_60035_60096[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (10))){
var state_59976__$1 = state_59976;
var statearr_60036_60097 = state_59976__$1;
(statearr_60036_60097[(2)] = true);

(statearr_60036_60097[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (18))){
var inst_59913 = (state_59976[(2)]);
var state_59976__$1 = state_59976;
if(cljs.core.truth_(inst_59913)){
var statearr_60037_60098 = state_59976__$1;
(statearr_60037_60098[(1)] = (19));

} else {
var statearr_60038_60099 = state_59976__$1;
(statearr_60038_60099[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (42))){
var inst_59943 = (state_59976[(17)]);
var inst_59962 = (state_59976[(2)]);
var state_59976__$1 = (function (){var statearr_60039 = state_59976;
(statearr_60039[(10)] = inst_59962);

return statearr_60039;
})();
if(cljs.core.truth_(inst_59943)){
var statearr_60040_60100 = state_59976__$1;
(statearr_60040_60100[(1)] = (43));

} else {
var statearr_60041_60101 = state_59976__$1;
(statearr_60041_60101[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (37))){
var inst_59882 = (state_59976[(16)]);
var state_59976__$1 = state_59976;
var statearr_60042_60102 = state_59976__$1;
(statearr_60042_60102[(2)] = inst_59882);

(statearr_60042_60102[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59977 === (8))){
var state_59976__$1 = state_59976;
var statearr_60043_60103 = state_59976__$1;
(statearr_60043_60103[(2)] = false);

(statearr_60043_60103[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2414__auto__ = null;
var fluree$db$api$query$state_machine__2414__auto____0 = (function (){
var statearr_60044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60044[(0)] = fluree$db$api$query$state_machine__2414__auto__);

(statearr_60044[(1)] = (1));

return statearr_60044;
});
var fluree$db$api$query$state_machine__2414__auto____1 = (function (state_59976){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_59976);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60045){var ex__2417__auto__ = e60045;
var statearr_60046_60104 = state_59976;
(statearr_60046_60104[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_59976[(4)]))){
var statearr_60047_60105 = state_59976;
(statearr_60047_60105[(1)] = cljs.core.first((state_59976[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60106 = state_59976;
state_59976 = G__60106;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2414__auto__ = function(state_59976){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2414__auto____1.call(this,state_59976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2414__auto____0;
fluree$db$api$query$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2414__auto____1;
return fluree$db$api$query$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60048 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60048[(6)] = c__2436__auto___60050);

return statearr_60048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60244){
var state_val_60245 = (state_60244[(1)]);
if((state_val_60245 === (7))){
var inst_60127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60128 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60129 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60130 = [inst_60128,inst_60129];
var inst_60131 = (new cljs.core.PersistentVector(null,2,(5),inst_60127,inst_60130,null));
var state_60244__$1 = state_60244;
var statearr_60246_60312 = state_60244__$1;
(statearr_60246_60312[(2)] = inst_60131);

(statearr_60246_60312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (20))){
var inst_60157 = (state_60244[(7)]);
var state_60244__$1 = state_60244;
var statearr_60247_60313 = state_60244__$1;
(statearr_60247_60313[(2)] = inst_60157);

(statearr_60247_60313[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (27))){
var state_60244__$1 = state_60244;
var statearr_60248_60314 = state_60244__$1;
(statearr_60248_60314[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (1))){
var state_60244__$1 = state_60244;
var statearr_60250_60315 = state_60244__$1;
(statearr_60250_60315[(2)] = null);

(statearr_60250_60315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (24))){
var inst_60156 = (state_60244[(8)]);
var state_60244__$1 = state_60244;
if(cljs.core.truth_(inst_60156)){
var statearr_60251_60316 = state_60244__$1;
(statearr_60251_60316[(1)] = (26));

} else {
var statearr_60252_60317 = state_60244__$1;
(statearr_60252_60317[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (39))){
var inst_60231 = (state_60244[(9)]);
var state_60244__$1 = state_60244;
var statearr_60253_60318 = state_60244__$1;
(statearr_60253_60318[(2)] = inst_60231);

(statearr_60253_60318[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (4))){
var inst_60107 = (state_60244[(2)]);
var state_60244__$1 = state_60244;
var statearr_60254_60319 = state_60244__$1;
(statearr_60254_60319[(2)] = inst_60107);

(statearr_60254_60319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (15))){
var inst_60136 = (state_60244[(10)]);
var inst_60141 = (state_60244[(11)]);
var inst_60150 = (state_60244[(2)]);
var inst_60151 = [inst_60141,inst_60150];
var inst_60152 = (new cljs.core.PersistentVector(null,2,(5),inst_60136,inst_60151,null));
var state_60244__$1 = state_60244;
var statearr_60255_60320 = state_60244__$1;
(statearr_60255_60320[(2)] = inst_60152);

(statearr_60255_60320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (21))){
var inst_60156 = (state_60244[(8)]);
var state_60244__$1 = state_60244;
var statearr_60256_60321 = state_60244__$1;
(statearr_60256_60321[(2)] = inst_60156);

(statearr_60256_60321[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (31))){
var inst_60197 = (state_60244[(2)]);
var state_60244__$1 = state_60244;
var statearr_60257_60322 = state_60244__$1;
(statearr_60257_60322[(2)] = inst_60197);

(statearr_60257_60322[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (32))){
var inst_60133 = (state_60244[(12)]);
var inst_60209 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60133], 0));
var inst_60210 = ["Invalid block range provided: ",inst_60209].join('');
var inst_60211 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60212 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60213 = cljs.core.PersistentHashMap.fromArrays(inst_60211,inst_60212);
var inst_60214 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60210,inst_60213);
var inst_60215 = (function(){throw inst_60214})();
var state_60244__$1 = state_60244;
var statearr_60258_60323 = state_60244__$1;
(statearr_60258_60323[(2)] = inst_60215);

(statearr_60258_60323[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (40))){
var inst_60230 = (state_60244[(13)]);
var inst_60236 = (state_60244[(2)]);
var inst_60237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60238 = [inst_60230,inst_60236];
var inst_60239 = (new cljs.core.PersistentVector(null,2,(5),inst_60237,inst_60238,null));
var _ = (function (){var statearr_60259 = state_60244;
(statearr_60259[(4)] = cljs.core.rest((state_60244[(4)])));

return statearr_60259;
})();
var state_60244__$1 = state_60244;
var statearr_60260_60324 = state_60244__$1;
(statearr_60260_60324[(2)] = inst_60239);

(statearr_60260_60324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (33))){
var state_60244__$1 = state_60244;
var statearr_60261_60325 = state_60244__$1;
(statearr_60261_60325[(2)] = null);

(statearr_60261_60325[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (13))){
var inst_60142 = (state_60244[(14)]);
var inst_60144 = fluree.db.time_travel.block_to_int_format(db,inst_60142);
var state_60244__$1 = state_60244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60244__$1,(16),inst_60144);
} else {
if((state_val_60245 === (22))){
var inst_60175 = (state_60244[(2)]);
var state_60244__$1 = state_60244;
if(cljs.core.truth_(inst_60175)){
var statearr_60262_60326 = state_60244__$1;
(statearr_60262_60326[(1)] = (23));

} else {
var statearr_60263_60327 = state_60244__$1;
(statearr_60263_60327[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (36))){
var inst_60202 = (state_60244[(15)]);
var inst_60203 = (state_60244[(16)]);
var inst_60225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60226 = [inst_60202,inst_60203];
var inst_60227 = (new cljs.core.PersistentVector(null,2,(5),inst_60225,inst_60226,null));
var state_60244__$1 = state_60244;
var statearr_60264_60328 = state_60244__$1;
(statearr_60264_60328[(2)] = inst_60227);

(statearr_60264_60328[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (29))){
var inst_60133 = (state_60244[(12)]);
var inst_60188 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60133], 0));
var inst_60189 = ["Invalid block range provided: ",inst_60188].join('');
var inst_60190 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60191 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60192 = cljs.core.PersistentHashMap.fromArrays(inst_60190,inst_60191);
var inst_60193 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60189,inst_60192);
var inst_60194 = (function(){throw inst_60193})();
var state_60244__$1 = state_60244;
var statearr_60265_60329 = state_60244__$1;
(statearr_60265_60329[(2)] = inst_60194);

(statearr_60265_60329[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (6))){
var inst_60125 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60244__$1 = state_60244;
var statearr_60266_60330 = state_60244__$1;
(statearr_60266_60330[(2)] = inst_60125);

(statearr_60266_60330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (28))){
var inst_60199 = (state_60244[(2)]);
var state_60244__$1 = state_60244;
var statearr_60267_60331 = state_60244__$1;
(statearr_60267_60331[(2)] = inst_60199);

(statearr_60267_60331[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (25))){
var inst_60202 = (state_60244[(15)]);
var inst_60203 = (state_60244[(16)]);
var inst_60201 = (state_60244[(2)]);
var inst_60202__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60201,(0),null);
var inst_60203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60201,(1),null);
var inst_60204 = cljs.core.pos_int_QMARK_(inst_60202__$1);
var inst_60205 = cljs.core.pos_int_QMARK_(inst_60203__$1);
var inst_60206 = ((inst_60204) && (inst_60205));
var inst_60207 = cljs.core.not(inst_60206);
var state_60244__$1 = (function (){var statearr_60268 = state_60244;
(statearr_60268[(15)] = inst_60202__$1);

(statearr_60268[(16)] = inst_60203__$1);

return statearr_60268;
})();
if(inst_60207){
var statearr_60269_60332 = state_60244__$1;
(statearr_60269_60332[(1)] = (32));

} else {
var statearr_60270_60333 = state_60244__$1;
(statearr_60270_60333[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (34))){
var inst_60202 = (state_60244[(15)]);
var inst_60203 = (state_60244[(16)]);
var inst_60218 = (state_60244[(2)]);
var inst_60219 = (inst_60203 < inst_60202);
var state_60244__$1 = (function (){var statearr_60271 = state_60244;
(statearr_60271[(17)] = inst_60218);

return statearr_60271;
})();
if(cljs.core.truth_(inst_60219)){
var statearr_60272_60334 = state_60244__$1;
(statearr_60272_60334[(1)] = (35));

} else {
var statearr_60273_60335 = state_60244__$1;
(statearr_60273_60335[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (17))){
var inst_60156 = (state_60244[(8)]);
var inst_60158 = (state_60244[(18)]);
var inst_60161 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60156], 0));
var inst_60162 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60158], 0));
var inst_60163 = ["Start block is out of range for this ledger. Start block provided: ",inst_60161,". Database block: ",inst_60162].join('');
var inst_60164 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60165 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60166 = cljs.core.PersistentHashMap.fromArrays(inst_60164,inst_60165);
var inst_60167 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60163,inst_60166);
var inst_60168 = (function(){throw inst_60167})();
var state_60244__$1 = state_60244;
var statearr_60274_60336 = state_60244__$1;
(statearr_60274_60336[(2)] = inst_60168);

(statearr_60274_60336[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (3))){
var inst_60242 = (state_60244[(2)]);
var state_60244__$1 = state_60244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60244__$1,inst_60242);
} else {
if((state_val_60245 === (12))){
var inst_60133 = (state_60244[(12)]);
var inst_60142 = (state_60244[(14)]);
var inst_60140 = (state_60244[(2)]);
var inst_60141 = fluree.db.util.async.throw_err(inst_60140);
var inst_60142__$1 = cljs.core.second(inst_60133);
var state_60244__$1 = (function (){var statearr_60275 = state_60244;
(statearr_60275[(11)] = inst_60141);

(statearr_60275[(14)] = inst_60142__$1);

return statearr_60275;
})();
if(cljs.core.truth_(inst_60142__$1)){
var statearr_60276_60337 = state_60244__$1;
(statearr_60276_60337[(1)] = (13));

} else {
var statearr_60277_60338 = state_60244__$1;
(statearr_60277_60338[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (2))){
var _ = (function (){var statearr_60278 = state_60244;
(statearr_60278[(4)] = cljs.core.cons((5),(state_60244[(4)])));

return statearr_60278;
})();
var inst_60122 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60123 = cljs.core.sequential_QMARK_(inst_60122);
var state_60244__$1 = state_60244;
if(inst_60123){
var statearr_60279_60339 = state_60244__$1;
(statearr_60279_60339[(1)] = (6));

} else {
var statearr_60280_60340 = state_60244__$1;
(statearr_60280_60340[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (23))){
var inst_60156 = (state_60244[(8)]);
var inst_60157 = (state_60244[(7)]);
var inst_60177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60178 = [inst_60156,inst_60157];
var inst_60179 = (new cljs.core.PersistentVector(null,2,(5),inst_60177,inst_60178,null));
var state_60244__$1 = state_60244;
var statearr_60281_60341 = state_60244__$1;
(statearr_60281_60341[(2)] = inst_60179);

(statearr_60281_60341[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (35))){
var inst_60202 = (state_60244[(15)]);
var inst_60203 = (state_60244[(16)]);
var inst_60221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60222 = [inst_60203,inst_60202];
var inst_60223 = (new cljs.core.PersistentVector(null,2,(5),inst_60221,inst_60222,null));
var state_60244__$1 = state_60244;
var statearr_60282_60342 = state_60244__$1;
(statearr_60282_60342[(2)] = inst_60223);

(statearr_60282_60342[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (19))){
var inst_60156 = (state_60244[(8)]);
var inst_60171 = (state_60244[(2)]);
var state_60244__$1 = (function (){var statearr_60283 = state_60244;
(statearr_60283[(19)] = inst_60171);

return statearr_60283;
})();
if(cljs.core.truth_(inst_60156)){
var statearr_60284_60343 = state_60244__$1;
(statearr_60284_60343[(1)] = (20));

} else {
var statearr_60285_60344 = state_60244__$1;
(statearr_60285_60344[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (11))){
var inst_60156 = (state_60244[(8)]);
var inst_60158 = (state_60244[(18)]);
var inst_60155 = (state_60244[(2)]);
var inst_60156__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60155,(0),null);
var inst_60157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60155,(1),null);
var inst_60158__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60159 = (inst_60156__$1 > inst_60158__$1);
var state_60244__$1 = (function (){var statearr_60287 = state_60244;
(statearr_60287[(8)] = inst_60156__$1);

(statearr_60287[(7)] = inst_60157);

(statearr_60287[(18)] = inst_60158__$1);

return statearr_60287;
})();
if(cljs.core.truth_(inst_60159)){
var statearr_60288_60345 = state_60244__$1;
(statearr_60288_60345[(1)] = (17));

} else {
var statearr_60289_60346 = state_60244__$1;
(statearr_60289_60346[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (9))){
var inst_60133 = (state_60244[(12)]);
var inst_60136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60137 = cljs.core.first(inst_60133);
var inst_60138 = fluree.db.time_travel.block_to_int_format(db,inst_60137);
var state_60244__$1 = (function (){var statearr_60290 = state_60244;
(statearr_60290[(10)] = inst_60136);

return statearr_60290;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60244__$1,(12),inst_60138);
} else {
if((state_val_60245 === (5))){
var _ = (function (){var statearr_60291 = state_60244;
(statearr_60291[(4)] = cljs.core.rest((state_60244[(4)])));

return statearr_60291;
})();
var state_60244__$1 = state_60244;
var ex60286 = (state_60244__$1[(2)]);
var statearr_60292_60347 = state_60244__$1;
(statearr_60292_60347[(5)] = ex60286);


if((ex60286 instanceof Error)){
var statearr_60293_60348 = state_60244__$1;
(statearr_60293_60348[(1)] = (4));

(statearr_60293_60348[(5)] = null);

} else {
throw ex60286;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (14))){
var state_60244__$1 = state_60244;
var statearr_60294_60349 = state_60244__$1;
(statearr_60294_60349[(2)] = null);

(statearr_60294_60349[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (26))){
var inst_60156 = (state_60244[(8)]);
var inst_60182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60183 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60184 = [inst_60156,inst_60183];
var inst_60185 = (new cljs.core.PersistentVector(null,2,(5),inst_60182,inst_60184,null));
var state_60244__$1 = state_60244;
var statearr_60295_60350 = state_60244__$1;
(statearr_60295_60350[(2)] = inst_60185);

(statearr_60295_60350[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (16))){
var inst_60146 = (state_60244[(2)]);
var inst_60147 = fluree.db.util.async.throw_err(inst_60146);
var state_60244__$1 = state_60244;
var statearr_60296_60351 = state_60244__$1;
(statearr_60296_60351[(2)] = inst_60147);

(statearr_60296_60351[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (38))){
var inst_60158 = (state_60244[(18)]);
var state_60244__$1 = state_60244;
var statearr_60297_60352 = state_60244__$1;
(statearr_60297_60352[(2)] = inst_60158);

(statearr_60297_60352[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (30))){
var state_60244__$1 = state_60244;
var statearr_60298_60353 = state_60244__$1;
(statearr_60298_60353[(2)] = null);

(statearr_60298_60353[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (10))){
var inst_60133 = (state_60244[(12)]);
var state_60244__$1 = state_60244;
var statearr_60299_60354 = state_60244__$1;
(statearr_60299_60354[(2)] = inst_60133);

(statearr_60299_60354[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (18))){
var state_60244__$1 = state_60244;
var statearr_60300_60355 = state_60244__$1;
(statearr_60300_60355[(2)] = null);

(statearr_60300_60355[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (37))){
var inst_60231 = (state_60244[(9)]);
var inst_60158 = (state_60244[(18)]);
var inst_60229 = (state_60244[(2)]);
var inst_60230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60229,(0),null);
var inst_60231__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60229,(1),null);
var inst_60232 = (inst_60231__$1 > inst_60158);
var state_60244__$1 = (function (){var statearr_60301 = state_60244;
(statearr_60301[(9)] = inst_60231__$1);

(statearr_60301[(13)] = inst_60230);

return statearr_60301;
})();
if(cljs.core.truth_(inst_60232)){
var statearr_60302_60356 = state_60244__$1;
(statearr_60302_60356[(1)] = (38));

} else {
var statearr_60303_60357 = state_60244__$1;
(statearr_60303_60357[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60245 === (8))){
var inst_60133 = (state_60244[(12)]);
var inst_60133__$1 = (state_60244[(2)]);
var inst_60134 = cljs.core.some(cljs.core.string_QMARK_,inst_60133__$1);
var state_60244__$1 = (function (){var statearr_60304 = state_60244;
(statearr_60304[(12)] = inst_60133__$1);

return statearr_60304;
})();
if(cljs.core.truth_(inst_60134)){
var statearr_60305_60358 = state_60244__$1;
(statearr_60305_60358[(1)] = (9));

} else {
var statearr_60306_60359 = state_60244__$1;
(statearr_60306_60359[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0 = (function (){
var statearr_60307 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60307[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__);

(statearr_60307[(1)] = (1));

return statearr_60307;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1 = (function (state_60244){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60244);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60308){var ex__2417__auto__ = e60308;
var statearr_60309_60360 = state_60244;
(statearr_60309_60360[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60244[(4)]))){
var statearr_60310_60361 = state_60244;
(statearr_60310_60361[(1)] = cljs.core.first((state_60244[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60362 = state_60244;
state_60244 = G__60362;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__ = function(state_60244){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1.call(this,state_60244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60311 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60311[(6)] = c__2436__auto__);

return statearr_60311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60512){
var state_val_60513 = (state_60512[(1)]);
if((state_val_60513 === (7))){
var inst_60424 = (state_60512[(2)]);
var inst_60425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60424,(0),null);
var inst_60426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60424,(1),null);
var inst_60434 = cljs.core.vals(inst_60426);
var inst_60435 = cljs.core.seq(inst_60434);
var inst_60436 = cljs.core.first(inst_60435);
var inst_60437 = cljs.core.next(inst_60435);
var inst_60438 = cljs.core.PersistentVector.EMPTY;
var inst_60439 = inst_60434;
var inst_60440 = inst_60438;
var state_60512__$1 = (function (){var statearr_60514 = state_60512;
(statearr_60514[(7)] = inst_60436);

(statearr_60514[(8)] = inst_60437);

(statearr_60514[(9)] = inst_60425);

(statearr_60514[(10)] = inst_60439);

(statearr_60514[(11)] = inst_60440);

return statearr_60514;
})();
var statearr_60515_60568 = state_60512__$1;
(statearr_60515_60568[(2)] = null);

(statearr_60515_60568[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (20))){
var inst_60446 = (state_60512[(12)]);
var inst_60451 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60452 = cljs.core.PersistentHashMap.EMPTY;
var inst_60453 = [true,inst_60452];
var inst_60454 = cljs.core.PersistentHashMap.fromArrays(inst_60451,inst_60453);
var inst_60455 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60454,inst_60446);
var state_60512__$1 = state_60512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60512__$1,(22),inst_60455);
} else {
if((state_val_60513 === (27))){
var inst_60500 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
var statearr_60516_60569 = state_60512__$1;
(statearr_60516_60569[(2)] = inst_60500);

(statearr_60516_60569[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (1))){
var state_60512__$1 = state_60512;
var statearr_60517_60570 = state_60512__$1;
(statearr_60517_60570[(2)] = null);

(statearr_60517_60570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (24))){
var inst_60464 = (state_60512[(13)]);
var inst_60502 = (state_60512[(2)]);
var inst_60503 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60504 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60505 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60506 = [inst_60504,inst_60505,inst_60464,inst_60502];
var inst_60507 = cljs.core.PersistentHashMap.fromArrays(inst_60503,inst_60506);
var _ = (function (){var statearr_60519 = state_60512;
(statearr_60519[(4)] = cljs.core.rest((state_60512[(4)])));

return statearr_60519;
})();
var state_60512__$1 = state_60512;
var statearr_60520_60571 = state_60512__$1;
(statearr_60520_60571[(2)] = inst_60507);

(statearr_60520_60571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (4))){
var inst_60365 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
var statearr_60521_60572 = state_60512__$1;
(statearr_60521_60572[(2)] = inst_60365);

(statearr_60521_60572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (15))){
var inst_60403 = (state_60512[(14)]);
var inst_60405 = (state_60512[(15)]);
var inst_60395 = (state_60512[(16)]);
var inst_60410 = (state_60512[(17)]);
var inst_60396 = (state_60512[(18)]);
var inst_60387 = (state_60512[(19)]);
var inst_60389 = (state_60512[(20)]);
var inst_60381 = (state_60512[(21)]);
var inst_60384 = (state_60512[(22)]);
var inst_60383 = (state_60512[(23)]);
var inst_60388 = (state_60512[(24)]);
var inst_60416 = (function (){var vec__60378 = inst_60381;
var subject = inst_60403;
var flake = inst_60395;
var G__60377 = inst_60387;
var seq__60392 = inst_60396;
var r = inst_60396;
var asserted_subjects = inst_60388;
var seq__60379 = inst_60384;
var flake_SINGLEQUOTE_ = inst_60410;
var retracted_subjects = inst_60389;
var vec__60391 = inst_60387;
var first__60380 = inst_60383;
var asserted_QMARK_ = inst_60405;
var first__60393 = inst_60395;
return (function (p1__60364_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60364_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60417 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60389,inst_60403,inst_60416);
var tmp60518 = inst_60388;
var inst_60387__$1 = inst_60396;
var inst_60388__$1 = tmp60518;
var inst_60389__$1 = inst_60417;
var state_60512__$1 = (function (){var statearr_60522 = state_60512;
(statearr_60522[(19)] = inst_60387__$1);

(statearr_60522[(20)] = inst_60389__$1);

(statearr_60522[(24)] = inst_60388__$1);

return statearr_60522;
})();
var statearr_60523_60573 = state_60512__$1;
(statearr_60523_60573[(2)] = null);

(statearr_60523_60573[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (21))){
var inst_60462 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
var statearr_60524_60574 = state_60512__$1;
(statearr_60524_60574[(2)] = inst_60462);

(statearr_60524_60574[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (13))){
var inst_60405 = (state_60512[(15)]);
var inst_60410 = (state_60512[(2)]);
var state_60512__$1 = (function (){var statearr_60525 = state_60512;
(statearr_60525[(17)] = inst_60410);

return statearr_60525;
})();
if(cljs.core.truth_(inst_60405)){
var statearr_60526_60575 = state_60512__$1;
(statearr_60526_60575[(1)] = (14));

} else {
var statearr_60527_60576 = state_60512__$1;
(statearr_60527_60576[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (22))){
var inst_60447 = (state_60512[(25)]);
var inst_60440 = (state_60512[(11)]);
var inst_60457 = (state_60512[(2)]);
var inst_60458 = fluree.db.util.async.throw_err(inst_60457);
var inst_60459 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60440,inst_60458);
var inst_60439 = inst_60447;
var inst_60440__$1 = inst_60459;
var state_60512__$1 = (function (){var statearr_60528 = state_60512;
(statearr_60528[(10)] = inst_60439);

(statearr_60528[(11)] = inst_60440__$1);

return statearr_60528;
})();
var statearr_60529_60577 = state_60512__$1;
(statearr_60529_60577[(2)] = null);

(statearr_60529_60577[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (6))){
var inst_60395 = (state_60512[(16)]);
var inst_60387 = (state_60512[(19)]);
var inst_60394 = cljs.core.seq(inst_60387);
var inst_60395__$1 = cljs.core.first(inst_60394);
var inst_60396 = cljs.core.next(inst_60394);
var inst_60397 = cljs.core.not(inst_60395__$1);
var state_60512__$1 = (function (){var statearr_60530 = state_60512;
(statearr_60530[(16)] = inst_60395__$1);

(statearr_60530[(18)] = inst_60396);

return statearr_60530;
})();
if(inst_60397){
var statearr_60531_60578 = state_60512__$1;
(statearr_60531_60578[(1)] = (8));

} else {
var statearr_60532_60579 = state_60512__$1;
(statearr_60532_60579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (28))){
var inst_60485 = (state_60512[(26)]);
var inst_60478 = (state_60512[(27)]);
var inst_60495 = (state_60512[(2)]);
var inst_60496 = fluree.db.util.async.throw_err(inst_60495);
var inst_60497 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_60478,inst_60496);
var inst_60477 = inst_60485;
var inst_60478__$1 = inst_60497;
var state_60512__$1 = (function (){var statearr_60533 = state_60512;
(statearr_60533[(28)] = inst_60477);

(statearr_60533[(27)] = inst_60478__$1);

return statearr_60533;
})();
var statearr_60534_60580 = state_60512__$1;
(statearr_60534_60580[(2)] = null);

(statearr_60534_60580[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (25))){
var inst_60478 = (state_60512[(27)]);
var state_60512__$1 = state_60512;
var statearr_60535_60581 = state_60512__$1;
(statearr_60535_60581[(2)] = inst_60478);

(statearr_60535_60581[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (17))){
var inst_60446 = (state_60512[(12)]);
var inst_60439 = (state_60512[(10)]);
var inst_60445 = cljs.core.seq(inst_60439);
var inst_60446__$1 = cljs.core.first(inst_60445);
var inst_60447 = cljs.core.next(inst_60445);
var inst_60448 = cljs.core.not(inst_60446__$1);
var state_60512__$1 = (function (){var statearr_60536 = state_60512;
(statearr_60536[(25)] = inst_60447);

(statearr_60536[(12)] = inst_60446__$1);

return statearr_60536;
})();
if(inst_60448){
var statearr_60537_60582 = state_60512__$1;
(statearr_60537_60582[(1)] = (19));

} else {
var statearr_60538_60583 = state_60512__$1;
(statearr_60538_60583[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (3))){
var inst_60510 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60512__$1,inst_60510);
} else {
if((state_val_60513 === (12))){
var inst_60395 = (state_60512[(16)]);
var inst_60408 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_60395);
var state_60512__$1 = state_60512;
var statearr_60539_60584 = state_60512__$1;
(statearr_60539_60584[(2)] = inst_60408);

(statearr_60539_60584[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (2))){
var inst_60381 = (state_60512[(21)]);
var _ = (function (){var statearr_60540 = state_60512;
(statearr_60540[(4)] = cljs.core.cons((5),(state_60512[(4)])));

return statearr_60540;
})();
var inst_60381__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60382 = cljs.core.seq(inst_60381__$1);
var inst_60383 = cljs.core.first(inst_60382);
var inst_60384 = cljs.core.next(inst_60382);
var inst_60385 = cljs.core.PersistentHashMap.EMPTY;
var inst_60386 = cljs.core.PersistentHashMap.EMPTY;
var inst_60387 = inst_60381__$1;
var inst_60388 = inst_60385;
var inst_60389 = inst_60386;
var state_60512__$1 = (function (){var statearr_60541 = state_60512;
(statearr_60541[(19)] = inst_60387);

(statearr_60541[(20)] = inst_60389);

(statearr_60541[(21)] = inst_60381__$1);

(statearr_60541[(22)] = inst_60384);

(statearr_60541[(23)] = inst_60383);

(statearr_60541[(24)] = inst_60388);

return statearr_60541;
})();
var statearr_60542_60585 = state_60512__$1;
(statearr_60542_60585[(2)] = null);

(statearr_60542_60585[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (23))){
var inst_60477 = (state_60512[(28)]);
var inst_60484 = (state_60512[(29)]);
var inst_60483 = cljs.core.seq(inst_60477);
var inst_60484__$1 = cljs.core.first(inst_60483);
var inst_60485 = cljs.core.next(inst_60483);
var inst_60486 = cljs.core.not(inst_60484__$1);
var state_60512__$1 = (function (){var statearr_60543 = state_60512;
(statearr_60543[(26)] = inst_60485);

(statearr_60543[(29)] = inst_60484__$1);

return statearr_60543;
})();
if(inst_60486){
var statearr_60544_60586 = state_60512__$1;
(statearr_60544_60586[(1)] = (25));

} else {
var statearr_60545_60587 = state_60512__$1;
(statearr_60545_60587[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (19))){
var inst_60440 = (state_60512[(11)]);
var state_60512__$1 = state_60512;
var statearr_60546_60588 = state_60512__$1;
(statearr_60546_60588[(2)] = inst_60440);

(statearr_60546_60588[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (11))){
var inst_60395 = (state_60512[(16)]);
var state_60512__$1 = state_60512;
var statearr_60548_60589 = state_60512__$1;
(statearr_60548_60589[(2)] = inst_60395);

(statearr_60548_60589[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (9))){
var inst_60405 = (state_60512[(15)]);
var inst_60395 = (state_60512[(16)]);
var inst_60403 = inst_60395.s;
var inst_60404 = inst_60395.op;
var inst_60405__$1 = inst_60404 === true;
var state_60512__$1 = (function (){var statearr_60550 = state_60512;
(statearr_60550[(14)] = inst_60403);

(statearr_60550[(15)] = inst_60405__$1);

return statearr_60550;
})();
if(cljs.core.truth_(inst_60405__$1)){
var statearr_60551_60590 = state_60512__$1;
(statearr_60551_60590[(1)] = (11));

} else {
var statearr_60552_60591 = state_60512__$1;
(statearr_60552_60591[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (5))){
var _ = (function (){var statearr_60553 = state_60512;
(statearr_60553[(4)] = cljs.core.rest((state_60512[(4)])));

return statearr_60553;
})();
var state_60512__$1 = state_60512;
var ex60547 = (state_60512__$1[(2)]);
var statearr_60554_60592 = state_60512__$1;
(statearr_60554_60592[(5)] = ex60547);


if((ex60547 instanceof Error)){
var statearr_60555_60593 = state_60512__$1;
(statearr_60555_60593[(1)] = (4));

(statearr_60555_60593[(5)] = null);

} else {
throw ex60547;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (14))){
var inst_60403 = (state_60512[(14)]);
var inst_60405 = (state_60512[(15)]);
var inst_60395 = (state_60512[(16)]);
var inst_60410 = (state_60512[(17)]);
var inst_60396 = (state_60512[(18)]);
var inst_60387 = (state_60512[(19)]);
var inst_60389 = (state_60512[(20)]);
var inst_60381 = (state_60512[(21)]);
var inst_60384 = (state_60512[(22)]);
var inst_60383 = (state_60512[(23)]);
var inst_60388 = (state_60512[(24)]);
var inst_60412 = (function (){var vec__60378 = inst_60381;
var subject = inst_60403;
var flake = inst_60395;
var G__60377 = inst_60387;
var seq__60392 = inst_60396;
var r = inst_60396;
var asserted_subjects = inst_60388;
var seq__60379 = inst_60384;
var flake_SINGLEQUOTE_ = inst_60410;
var retracted_subjects = inst_60389;
var vec__60391 = inst_60387;
var first__60380 = inst_60383;
var asserted_QMARK_ = inst_60405;
var first__60393 = inst_60395;
return (function (p1__60363_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__60363_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60413 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_60388,inst_60403,inst_60412);
var tmp60549 = inst_60389;
var inst_60387__$1 = inst_60396;
var inst_60388__$1 = inst_60413;
var inst_60389__$1 = tmp60549;
var state_60512__$1 = (function (){var statearr_60556 = state_60512;
(statearr_60556[(19)] = inst_60387__$1);

(statearr_60556[(20)] = inst_60389__$1);

(statearr_60556[(24)] = inst_60388__$1);

return statearr_60556;
})();
var statearr_60557_60594 = state_60512__$1;
(statearr_60557_60594[(2)] = null);

(statearr_60557_60594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (26))){
var inst_60484 = (state_60512[(29)]);
var inst_60489 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60490 = cljs.core.PersistentHashMap.EMPTY;
var inst_60491 = [true,inst_60490];
var inst_60492 = cljs.core.PersistentHashMap.fromArrays(inst_60489,inst_60491);
var inst_60493 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_60492,inst_60484);
var state_60512__$1 = state_60512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60512__$1,(28),inst_60493);
} else {
if((state_val_60513 === (16))){
var inst_60420 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
var statearr_60558_60595 = state_60512__$1;
(statearr_60558_60595[(2)] = inst_60420);

(statearr_60558_60595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (10))){
var inst_60422 = (state_60512[(2)]);
var state_60512__$1 = state_60512;
var statearr_60559_60596 = state_60512__$1;
(statearr_60559_60596[(2)] = inst_60422);

(statearr_60559_60596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (18))){
var inst_60425 = (state_60512[(9)]);
var inst_60464 = (state_60512[(2)]);
var inst_60472 = cljs.core.vals(inst_60425);
var inst_60473 = cljs.core.seq(inst_60472);
var inst_60474 = cljs.core.first(inst_60473);
var inst_60475 = cljs.core.next(inst_60473);
var inst_60476 = cljs.core.PersistentVector.EMPTY;
var inst_60477 = inst_60472;
var inst_60478 = inst_60476;
var state_60512__$1 = (function (){var statearr_60560 = state_60512;
(statearr_60560[(30)] = inst_60475);

(statearr_60560[(28)] = inst_60477);

(statearr_60560[(27)] = inst_60478);

(statearr_60560[(13)] = inst_60464);

(statearr_60560[(31)] = inst_60474);

return statearr_60560;
})();
var statearr_60561_60597 = state_60512__$1;
(statearr_60561_60597[(2)] = null);

(statearr_60561_60597[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60513 === (8))){
var inst_60389 = (state_60512[(20)]);
var inst_60388 = (state_60512[(24)]);
var inst_60399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60400 = [inst_60388,inst_60389];
var inst_60401 = (new cljs.core.PersistentVector(null,2,(5),inst_60399,inst_60400,null));
var state_60512__$1 = state_60512;
var statearr_60562_60598 = state_60512__$1;
(statearr_60562_60598[(2)] = inst_60401);

(statearr_60562_60598[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_60563 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60563[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__);

(statearr_60563[(1)] = (1));

return statearr_60563;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1 = (function (state_60512){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60512);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60564){var ex__2417__auto__ = e60564;
var statearr_60565_60599 = state_60512;
(statearr_60565_60599[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60512[(4)]))){
var statearr_60566_60600 = state_60512;
(statearr_60566_60600[(1)] = cljs.core.first((state_60512[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60601 = state_60512;
state_60512 = G__60601;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__ = function(state_60512){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1.call(this,state_60512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60567 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60567[(6)] = c__2436__auto__);

return statearr_60567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60633){
var state_val_60634 = (state_60633[(1)]);
if((state_val_60634 === (1))){
var inst_60602 = cljs.core.volatile_BANG_((0));
var inst_60603 = cljs.core.PersistentHashMap.EMPTY;
var inst_60604 = cljs.core.volatile_BANG_(inst_60603);
var inst_60605 = cljs.core.first(resp);
var inst_60606 = cljs.core.rest(resp);
var inst_60607 = cljs.core.PersistentVector.EMPTY;
var inst_60608 = inst_60602;
var inst_60609 = inst_60604;
var inst_60610 = inst_60605;
var inst_60611 = inst_60606;
var inst_60612 = inst_60607;
var state_60633__$1 = (function (){var statearr_60635 = state_60633;
(statearr_60635[(7)] = inst_60610);

(statearr_60635[(8)] = inst_60609);

(statearr_60635[(9)] = inst_60612);

(statearr_60635[(10)] = inst_60611);

(statearr_60635[(11)] = inst_60608);

return statearr_60635;
})();
var statearr_60636_60651 = state_60633__$1;
(statearr_60636_60651[(2)] = null);

(statearr_60636_60651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60634 === (2))){
var inst_60610 = (state_60633[(7)]);
var inst_60609 = (state_60633[(8)]);
var inst_60608 = (state_60633[(11)]);
var inst_60614 = fluree.db.api.query.format_block_resp_pretty(db,inst_60610,inst_60609,inst_60608);
var state_60633__$1 = state_60633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60633__$1,(4),inst_60614);
} else {
if((state_val_60634 === (3))){
var inst_60631 = (state_60633[(2)]);
var state_60633__$1 = state_60633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60633__$1,inst_60631);
} else {
if((state_val_60634 === (4))){
var inst_60612 = (state_60633[(9)]);
var inst_60611 = (state_60633[(10)]);
var inst_60616 = (state_60633[(2)]);
var inst_60617 = fluree.db.util.async.throw_err(inst_60616);
var inst_60618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60619 = [inst_60617];
var inst_60620 = (new cljs.core.PersistentVector(null,1,(5),inst_60618,inst_60619,null));
var inst_60621 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60612,inst_60620);
var inst_60622 = cljs.core.first(inst_60611);
var state_60633__$1 = (function (){var statearr_60639 = state_60633;
(statearr_60639[(12)] = inst_60621);

return statearr_60639;
})();
if(cljs.core.truth_(inst_60622)){
var statearr_60640_60652 = state_60633__$1;
(statearr_60640_60652[(1)] = (5));

} else {
var statearr_60641_60653 = state_60633__$1;
(statearr_60641_60653[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60634 === (5))){
var inst_60609 = (state_60633[(8)]);
var inst_60621 = (state_60633[(12)]);
var inst_60611 = (state_60633[(10)]);
var inst_60608 = (state_60633[(11)]);
var inst_60624 = cljs.core.first(inst_60611);
var inst_60625 = cljs.core.rest(inst_60611);
var tmp60637 = inst_60609;
var tmp60638 = inst_60608;
var inst_60608__$1 = tmp60638;
var inst_60609__$1 = tmp60637;
var inst_60610 = inst_60624;
var inst_60611__$1 = inst_60625;
var inst_60612 = inst_60621;
var state_60633__$1 = (function (){var statearr_60642 = state_60633;
(statearr_60642[(7)] = inst_60610);

(statearr_60642[(8)] = inst_60609__$1);

(statearr_60642[(9)] = inst_60612);

(statearr_60642[(10)] = inst_60611__$1);

(statearr_60642[(11)] = inst_60608__$1);

return statearr_60642;
})();
var statearr_60643_60654 = state_60633__$1;
(statearr_60643_60654[(2)] = null);

(statearr_60643_60654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60634 === (6))){
var inst_60621 = (state_60633[(12)]);
var state_60633__$1 = state_60633;
var statearr_60644_60655 = state_60633__$1;
(statearr_60644_60655[(2)] = inst_60621);

(statearr_60644_60655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60634 === (7))){
var inst_60629 = (state_60633[(2)]);
var state_60633__$1 = state_60633;
var statearr_60645_60656 = state_60633__$1;
(statearr_60645_60656[(2)] = inst_60629);

(statearr_60645_60656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_60646 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60646[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__);

(statearr_60646[(1)] = (1));

return statearr_60646;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1 = (function (state_60633){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60633);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60647){var ex__2417__auto__ = e60647;
var statearr_60648_60657 = state_60633;
(statearr_60648_60657[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60633[(4)]))){
var statearr_60649_60658 = state_60633;
(statearr_60649_60658[(1)] = cljs.core.first((state_60633[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60659 = state_60633;
state_60633 = G__60659;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__ = function(state_60633){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1.call(this,state_60633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60650 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60650[(6)] = c__2436__auto__);

return statearr_60650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60662 = arguments.length;
switch (G__60662) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60664){
var map__60665 = p__60664;
var map__60665__$1 = (((((!((map__60665 == null))))?(((((map__60665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__60665.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60665):map__60665);
var query = map__60665__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60665__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60751){
var state_val_60752 = (state_60751[(1)]);
if((state_val_60752 === (7))){
var inst_60677 = (state_60751[(7)]);
var inst_60681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60682 = ["_auth/id",inst_60677];
var inst_60683 = (new cljs.core.PersistentVector(null,2,(5),inst_60681,inst_60682,null));
var state_60751__$1 = state_60751;
var statearr_60753_60797 = state_60751__$1;
(statearr_60753_60797[(2)] = inst_60683);

(statearr_60753_60797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (20))){
var inst_60731 = (state_60751[(2)]);
var inst_60732 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60751__$1 = (function (){var statearr_60754 = state_60751;
(statearr_60754[(8)] = inst_60731);

return statearr_60754;
})();
if(cljs.core.truth_(inst_60732)){
var statearr_60755_60798 = state_60751__$1;
(statearr_60755_60798[(1)] = (22));

} else {
var statearr_60756_60799 = state_60751__$1;
(statearr_60756_60799[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (27))){
var inst_60678 = (state_60751[(9)]);
var inst_60734 = (state_60751[(10)]);
var inst_60740 = (state_60751[(2)]);
var inst_60741 = fluree.db.api.query.response_time_formatted(inst_60678);
var inst_60742 = [(200),inst_60740,(100),inst_60741];
var inst_60743 = cljs.core.PersistentHashMap.fromArrays(inst_60734,inst_60742);
var state_60751__$1 = state_60751;
var statearr_60757_60800 = state_60751__$1;
(statearr_60757_60800[(2)] = inst_60743);

(statearr_60757_60800[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (1))){
var state_60751__$1 = state_60751;
var statearr_60758_60801 = state_60751__$1;
(statearr_60758_60801[(2)] = null);

(statearr_60758_60801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (24))){
var inst_60746 = (state_60751[(2)]);
var _ = (function (){var statearr_60759 = state_60751;
(statearr_60759[(4)] = cljs.core.rest((state_60751[(4)])));

return statearr_60759;
})();
var state_60751__$1 = state_60751;
var statearr_60760_60802 = state_60751__$1;
(statearr_60760_60802[(2)] = inst_60746);

(statearr_60760_60802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (4))){
var inst_60667 = (state_60751[(2)]);
var state_60751__$1 = state_60751;
var statearr_60761_60803 = state_60751__$1;
(statearr_60761_60803[(2)] = inst_60667);

(statearr_60761_60803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (15))){
var inst_60718 = (state_60751[(11)]);
var state_60751__$1 = state_60751;
var statearr_60762_60804 = state_60751__$1;
(statearr_60762_60804[(2)] = inst_60718);

(statearr_60762_60804[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (21))){
var inst_60727 = (state_60751[(2)]);
var inst_60728 = fluree.db.util.async.throw_err(inst_60727);
var state_60751__$1 = state_60751;
var statearr_60763_60805 = state_60751__$1;
(statearr_60763_60805[(2)] = inst_60728);

(statearr_60763_60805[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (13))){
var inst_60676 = (state_60751[(12)]);
var inst_60718 = (state_60751[(11)]);
var inst_60717 = (state_60751[(2)]);
var inst_60718__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60676);
var state_60751__$1 = (function (){var statearr_60764 = state_60751;
(statearr_60764[(13)] = inst_60717);

(statearr_60764[(11)] = inst_60718__$1);

return statearr_60764;
})();
if(cljs.core.truth_(inst_60718__$1)){
var statearr_60765_60806 = state_60751__$1;
(statearr_60765_60806[(1)] = (15));

} else {
var statearr_60766_60807 = state_60751__$1;
(statearr_60766_60807[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (22))){
var inst_60731 = (state_60751[(8)]);
var inst_60734 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60735 = cljs.core.sequential_QMARK_(inst_60731);
var state_60751__$1 = (function (){var statearr_60767 = state_60751;
(statearr_60767[(10)] = inst_60734);

return statearr_60767;
})();
if(inst_60735){
var statearr_60768_60808 = state_60751__$1;
(statearr_60768_60808[(1)] = (25));

} else {
var statearr_60769_60809 = state_60751__$1;
(statearr_60769_60809[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (6))){
var inst_60692 = (state_60751[(14)]);
var inst_60676 = (state_60751[(12)]);
var inst_60691 = (state_60751[(2)]);
var inst_60692__$1 = fluree.db.util.async.throw_err(inst_60691);
var inst_60693 = fluree.db.api.query.resolve_block_range(inst_60692__$1,inst_60676);
var state_60751__$1 = (function (){var statearr_60770 = state_60751;
(statearr_60770[(14)] = inst_60692__$1);

return statearr_60770;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60751__$1,(10),inst_60693);
} else {
if((state_val_60752 === (25))){
var inst_60731 = (state_60751[(8)]);
var inst_60737 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60731);
var state_60751__$1 = state_60751;
var statearr_60771_60810 = state_60751__$1;
(statearr_60771_60810[(2)] = inst_60737);

(statearr_60771_60810[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (17))){
var inst_60723 = (state_60751[(2)]);
var state_60751__$1 = state_60751;
if(cljs.core.truth_(inst_60723)){
var statearr_60772_60811 = state_60751__$1;
(statearr_60772_60811[(1)] = (18));

} else {
var statearr_60773_60812 = state_60751__$1;
(statearr_60773_60812[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (3))){
var inst_60749 = (state_60751[(2)]);
var state_60751__$1 = state_60751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60751__$1,inst_60749);
} else {
if((state_val_60752 === (12))){
var inst_60676 = (state_60751[(12)]);
var inst_60709 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60676], 0));
var inst_60710 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60709].join('');
var inst_60711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60712 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60713 = cljs.core.PersistentHashMap.fromArrays(inst_60711,inst_60712);
var inst_60714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60710,inst_60713);
var inst_60715 = (function(){throw inst_60714})();
var state_60751__$1 = state_60751;
var statearr_60774_60813 = state_60751__$1;
(statearr_60774_60813[(2)] = inst_60715);

(statearr_60774_60813[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (2))){
var inst_60677 = (state_60751[(7)]);
var _ = (function (){var statearr_60775 = state_60751;
(statearr_60775[(4)] = cljs.core.cons((5),(state_60751[(4)])));

return statearr_60775;
})();
var inst_60676 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60677__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60678 = fluree.db.util.core.current_time_millis();
var inst_60679 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60751__$1 = (function (){var statearr_60776 = state_60751;
(statearr_60776[(15)] = inst_60679);

(statearr_60776[(9)] = inst_60678);

(statearr_60776[(12)] = inst_60676);

(statearr_60776[(7)] = inst_60677__$1);

return statearr_60776;
})();
if(cljs.core.truth_(inst_60677__$1)){
var statearr_60777_60814 = state_60751__$1;
(statearr_60777_60814[(1)] = (7));

} else {
var statearr_60778_60815 = state_60751__$1;
(statearr_60778_60815[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (23))){
var inst_60731 = (state_60751[(8)]);
var state_60751__$1 = state_60751;
var statearr_60779_60816 = state_60751__$1;
(statearr_60779_60816[(2)] = inst_60731);

(statearr_60779_60816[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (19))){
var inst_60717 = (state_60751[(13)]);
var state_60751__$1 = state_60751;
var statearr_60780_60817 = state_60751__$1;
(statearr_60780_60817[(2)] = inst_60717);

(statearr_60780_60817[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (11))){
var inst_60692 = (state_60751[(14)]);
var inst_60698 = (state_60751[(16)]);
var inst_60697 = (state_60751[(17)]);
var inst_60704 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60692,inst_60697,inst_60698,opts);
var state_60751__$1 = state_60751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60751__$1,(14),inst_60704);
} else {
if((state_val_60752 === (9))){
var inst_60679 = (state_60751[(15)]);
var inst_60686 = (state_60751[(2)]);
var inst_60687 = [inst_60686];
var inst_60688 = cljs.core.PersistentHashMap.fromArrays(inst_60679,inst_60687);
var inst_60689 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60688);
var state_60751__$1 = state_60751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60751__$1,(6),inst_60689);
} else {
if((state_val_60752 === (5))){
var _ = (function (){var statearr_60782 = state_60751;
(statearr_60782[(4)] = cljs.core.rest((state_60751[(4)])));

return statearr_60782;
})();
var state_60751__$1 = state_60751;
var ex60781 = (state_60751__$1[(2)]);
var statearr_60783_60818 = state_60751__$1;
(statearr_60783_60818[(5)] = ex60781);


if((ex60781 instanceof Error)){
var statearr_60784_60819 = state_60751__$1;
(statearr_60784_60819[(1)] = (4));

(statearr_60784_60819[(5)] = null);

} else {
throw ex60781;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (14))){
var inst_60706 = (state_60751[(2)]);
var inst_60707 = fluree.db.util.async.throw_err(inst_60706);
var state_60751__$1 = state_60751;
var statearr_60785_60820 = state_60751__$1;
(statearr_60785_60820[(2)] = inst_60707);

(statearr_60785_60820[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (26))){
var inst_60731 = (state_60751[(8)]);
var state_60751__$1 = state_60751;
var statearr_60786_60821 = state_60751__$1;
(statearr_60786_60821[(2)] = inst_60731);

(statearr_60786_60821[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (16))){
var inst_60676 = (state_60751[(12)]);
var inst_60721 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60676);
var state_60751__$1 = state_60751;
var statearr_60787_60822 = state_60751__$1;
(statearr_60787_60822[(2)] = inst_60721);

(statearr_60787_60822[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (10))){
var inst_60676 = (state_60751[(12)]);
var inst_60695 = (state_60751[(2)]);
var inst_60696 = fluree.db.util.async.throw_err(inst_60695);
var inst_60697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60696,(0),null);
var inst_60698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60696,(1),null);
var inst_60699 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60700 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60676,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60701 = cljs.core.keys(inst_60700);
var inst_60702 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60699,inst_60701);
var state_60751__$1 = (function (){var statearr_60788 = state_60751;
(statearr_60788[(16)] = inst_60698);

(statearr_60788[(17)] = inst_60697);

return statearr_60788;
})();
if(inst_60702){
var statearr_60789_60823 = state_60751__$1;
(statearr_60789_60823[(1)] = (11));

} else {
var statearr_60790_60824 = state_60751__$1;
(statearr_60790_60824[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60752 === (18))){
var inst_60692 = (state_60751[(14)]);
var inst_60717 = (state_60751[(13)]);
var inst_60725 = fluree.db.api.query.format_blocks_resp_pretty(inst_60692,inst_60717);
var state_60751__$1 = state_60751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60751__$1,(21),inst_60725);
} else {
if((state_val_60752 === (8))){
var state_60751__$1 = state_60751;
var statearr_60791_60825 = state_60751__$1;
(statearr_60791_60825[(2)] = null);

(statearr_60791_60825[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_60792 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60792[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2414__auto__);

(statearr_60792[(1)] = (1));

return statearr_60792;
});
var fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1 = (function (state_60751){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60751);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e60793){var ex__2417__auto__ = e60793;
var statearr_60794_60826 = state_60751;
(statearr_60794_60826[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60751[(4)]))){
var statearr_60795_60827 = state_60751;
(statearr_60795_60827[(1)] = cljs.core.first((state_60751[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60828 = state_60751;
state_60751 = G__60828;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__ = function(state_60751){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1.call(this,state_60751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_60796 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_60796[(6)] = c__2436__auto__);

return statearr_60796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60829 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60829,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60829,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60829,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60829,(3),null);
var vec__60832 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60832,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60832,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60835 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60835,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60835,(1),null);
var or__4126__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60839 = arguments.length;
var i__4737__auto___60840 = (0);
while(true){
if((i__4737__auto___60840 < len__4736__auto___60839)){
args__4742__auto__.push((arguments[i__4737__auto___60840]));

var G__60841 = (i__4737__auto___60840 + (1));
i__4737__auto___60840 = G__60841;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60838){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq60838));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61057){
var state_val_61058 = (state_61057[(1)]);
if((state_val_61058 === (7))){
var inst_60964 = (state_61057[(7)]);
var inst_60957 = (state_61057[(8)]);
var inst_60963 = cljs.core.seq(inst_60957);
var inst_60964__$1 = cljs.core.first(inst_60963);
var inst_60965 = cljs.core.next(inst_60963);
var state_61057__$1 = (function (){var statearr_61059 = state_61057;
(statearr_61059[(7)] = inst_60964__$1);

(statearr_61059[(9)] = inst_60965);

return statearr_61059;
})();
if(cljs.core.truth_(inst_60964__$1)){
var statearr_61060_61173 = state_61057__$1;
(statearr_61060_61173[(1)] = (9));

} else {
var statearr_61061_61174 = state_61057__$1;
(statearr_61061_61174[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (20))){
var inst_61047 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61062_61175 = state_61057__$1;
(statearr_61062_61175[(2)] = inst_61047);

(statearr_61062_61175[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (27))){
var inst_60983 = (state_61057[(10)]);
var inst_61001 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_60983);
var state_61057__$1 = state_61057;
var statearr_61063_61176 = state_61057__$1;
(statearr_61063_61176[(2)] = inst_61001);

(statearr_61063_61176[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (1))){
var state_61057__$1 = state_61057;
var statearr_61064_61177 = state_61057__$1;
(statearr_61064_61177[(2)] = null);

(statearr_61064_61177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (24))){
var state_61057__$1 = state_61057;
var statearr_61065_61178 = state_61057__$1;
(statearr_61065_61178[(2)] = true);

(statearr_61065_61178[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (39))){
var inst_61005 = (state_61057[(11)]);
var inst_61031 = (state_61057[(12)]);
var inst_61006 = (state_61057[(13)]);
var inst_61033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61034 = [inst_61005,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61035 = (new cljs.core.PersistentVector(null,2,(5),inst_61033,inst_61034,null));
var inst_61036 = cljs.core.assoc_in(inst_61031,inst_61035,inst_61006);
var state_61057__$1 = state_61057;
var statearr_61067_61179 = state_61057__$1;
(statearr_61067_61179[(2)] = inst_61036);

(statearr_61067_61179[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (4))){
var inst_60843 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61068_61180 = state_61057__$1;
(statearr_61068_61180[(2)] = inst_60843);

(statearr_61068_61180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (15))){
var inst_60958 = (state_61057[(14)]);
var inst_60965 = (state_61057[(9)]);
var tmp61066 = inst_60958;
var inst_60957 = inst_60965;
var inst_60958__$1 = tmp61066;
var state_61057__$1 = (function (){var statearr_61069 = state_61057;
(statearr_61069[(14)] = inst_60958__$1);

(statearr_61069[(8)] = inst_60957);

return statearr_61069;
})();
var statearr_61070_61181 = state_61057__$1;
(statearr_61070_61181[(2)] = null);

(statearr_61070_61181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (21))){
var inst_60983 = (state_61057[(10)]);
var inst_60988 = inst_60983.cljs$lang$protocol_mask$partition0$;
var inst_60989 = (inst_60988 & (64));
var inst_60990 = inst_60983.cljs$core$ISeq$;
var inst_60991 = (cljs.core.PROTOCOL_SENTINEL === inst_60990);
var inst_60992 = ((inst_60989) || (inst_60991));
var state_61057__$1 = state_61057;
if(cljs.core.truth_(inst_60992)){
var statearr_61071_61182 = state_61057__$1;
(statearr_61071_61182[(1)] = (24));

} else {
var statearr_61072_61183 = state_61057__$1;
(statearr_61072_61183[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (31))){
var inst_60958 = (state_61057[(14)]);
var state_61057__$1 = state_61057;
var statearr_61073_61184 = state_61057__$1;
(statearr_61073_61184[(2)] = inst_60958);

(statearr_61073_61184[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (32))){
var inst_61015 = (state_61057[(2)]);
var state_61057__$1 = (function (){var statearr_61074 = state_61057;
(statearr_61074[(15)] = inst_61015);

return statearr_61074;
})();
var statearr_61075_61185 = state_61057__$1;
(statearr_61075_61185[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (40))){
var inst_61031 = (state_61057[(12)]);
var state_61057__$1 = state_61057;
var statearr_61077_61186 = state_61057__$1;
(statearr_61077_61186[(2)] = inst_61031);

(statearr_61077_61186[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (33))){
var inst_60964 = (state_61057[(7)]);
var inst_61015 = (state_61057[(15)]);
var inst_61005 = (state_61057[(11)]);
var inst_61017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61018 = [inst_61005,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61019 = (new cljs.core.PersistentVector(null,2,(5),inst_61017,inst_61018,null));
var inst_61020 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61015,inst_61019,cljs.core.conj,inst_60964);
var state_61057__$1 = state_61057;
var statearr_61078_61187 = state_61057__$1;
(statearr_61078_61187[(2)] = inst_61020);

(statearr_61078_61187[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (13))){
var inst_60967 = (state_61057[(16)]);
var state_61057__$1 = state_61057;
var statearr_61079_61188 = state_61057__$1;
(statearr_61079_61188[(2)] = inst_60967);

(statearr_61079_61188[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (22))){
var state_61057__$1 = state_61057;
var statearr_61080_61189 = state_61057__$1;
(statearr_61080_61189[(2)] = false);

(statearr_61080_61189[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (36))){
var inst_60982 = (state_61057[(17)]);
var inst_61005 = (state_61057[(11)]);
var inst_61023 = (state_61057[(18)]);
var inst_61025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61026 = [inst_61005,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61027 = (new cljs.core.PersistentVector(null,2,(5),inst_61025,inst_61026,null));
var inst_61028 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61023,inst_61027,fluree.db.api.query.min_safe,inst_60982);
var state_61057__$1 = state_61057;
var statearr_61081_61190 = state_61057__$1;
(statearr_61081_61190[(2)] = inst_61028);

(statearr_61081_61190[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (41))){
var inst_60965 = (state_61057[(9)]);
var inst_61039 = (state_61057[(2)]);
var inst_60957 = inst_60965;
var inst_60958 = inst_61039;
var state_61057__$1 = (function (){var statearr_61082 = state_61057;
(statearr_61082[(14)] = inst_60958);

(statearr_61082[(8)] = inst_60957);

return statearr_61082;
})();
var statearr_61083_61191 = state_61057__$1;
(statearr_61083_61191[(2)] = null);

(statearr_61083_61191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (43))){
var state_61057__$1 = state_61057;
var statearr_61084_61192 = state_61057__$1;
(statearr_61084_61192[(2)] = null);

(statearr_61084_61192[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (29))){
var inst_61004 = (state_61057[(2)]);
var inst_61005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61004,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61004,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61057__$1 = (function (){var statearr_61085 = state_61057;
(statearr_61085[(11)] = inst_61005);

(statearr_61085[(13)] = inst_61006);

return statearr_61085;
})();
var statearr_61086_61193 = state_61057__$1;
(statearr_61086_61193[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (44))){
var inst_61045 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61088_61194 = state_61057__$1;
(statearr_61088_61194[(2)] = inst_61045);

(statearr_61088_61194[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (6))){
var inst_60943 = (state_61057[(2)]);
var inst_60944 = fluree.db.util.async.throw_err(inst_60943);
var inst_60952 = resp;
var inst_60953 = cljs.core.seq(inst_60952);
var inst_60954 = cljs.core.first(inst_60953);
var inst_60955 = cljs.core.next(inst_60953);
var inst_60956 = cljs.core.PersistentHashMap.EMPTY;
var inst_60957 = inst_60952;
var inst_60958 = inst_60956;
var state_61057__$1 = (function (){var statearr_61089 = state_61057;
(statearr_61089[(19)] = inst_60955);

(statearr_61089[(14)] = inst_60958);

(statearr_61089[(20)] = inst_60944);

(statearr_61089[(21)] = inst_60954);

(statearr_61089[(8)] = inst_60957);

return statearr_61089;
})();
var statearr_61090_61195 = state_61057__$1;
(statearr_61090_61195[(2)] = null);

(statearr_61090_61195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (28))){
var inst_60983 = (state_61057[(10)]);
var state_61057__$1 = state_61057;
var statearr_61091_61196 = state_61057__$1;
(statearr_61091_61196[(2)] = inst_60983);

(statearr_61091_61196[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (25))){
var state_61057__$1 = state_61057;
var statearr_61092_61197 = state_61057__$1;
(statearr_61092_61197[(2)] = false);

(statearr_61092_61197[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (34))){
var inst_61015 = (state_61057[(15)]);
var state_61057__$1 = state_61057;
var statearr_61093_61198 = state_61057__$1;
(statearr_61093_61198[(2)] = inst_61015);

(statearr_61093_61198[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (17))){
var inst_61049 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61094_61199 = state_61057__$1;
(statearr_61094_61199[(2)] = inst_61049);

(statearr_61094_61199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (3))){
var inst_61055 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61057__$1,inst_61055);
} else {
if((state_val_61058 === (12))){
var inst_60964 = (state_61057[(7)]);
var inst_60944 = (state_61057[(20)]);
var inst_60969 = fluree.db.api.query.auth_match(auth,inst_60944,inst_60964);
var inst_60970 = cljs.core.not(inst_60969);
var state_61057__$1 = state_61057;
var statearr_61095_61200 = state_61057__$1;
(statearr_61095_61200[(2)] = inst_60970);

(statearr_61095_61200[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (2))){
var _ = (function (){var statearr_61096 = state_61057;
(statearr_61096[(4)] = cljs.core.cons((5),(state_61057[(4)])));

return statearr_61096;
})();
var inst_60849 = (function (){return (function (p1__60842_SHARP_){
return p1__60842_SHARP_.t;
});
})();
var inst_60850 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60849,resp);
var inst_60851 = cljs.core.set(inst_60850);
var inst_60939 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60940 = (function (){var ts = inst_60851;
var c__2436__auto____$1 = inst_60939;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60937){
var state_val_60938 = (state_60937[(1)]);
if((state_val_60938 === (7))){
var inst_60877 = (state_60937[(7)]);
var inst_60871 = (state_60937[(8)]);
var inst_60883 = (state_60937[(9)]);
var inst_60865 = (state_60937[(10)]);
var inst_60876 = (state_60937[(2)]);
var inst_60877__$1 = fluree.db.util.async.throw_err(inst_60876);
var inst_60879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60880 = [inst_60871,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60881 = (new cljs.core.PersistentVector(null,2,(5),inst_60879,inst_60880,null));
var inst_60882 = cljs.core.assoc_in(inst_60865,inst_60881,inst_60877__$1);
var inst_60883__$1 = auth;
var state_60937__$1 = (function (){var statearr_61097 = state_60937;
(statearr_61097[(11)] = inst_60882);

(statearr_61097[(7)] = inst_60877__$1);

(statearr_61097[(9)] = inst_60883__$1);

return statearr_61097;
})();
if(cljs.core.truth_(inst_60883__$1)){
var statearr_61098_61201 = state_60937__$1;
(statearr_61098_61201[(1)] = (8));

} else {
var statearr_61099_61202 = state_60937__$1;
(statearr_61099_61202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (1))){
var inst_60859 = (state_60937[(12)]);
var inst_60859__$1 = ts;
var inst_60860 = cljs.core.seq(inst_60859__$1);
var inst_60861 = cljs.core.first(inst_60860);
var inst_60862 = cljs.core.next(inst_60860);
var inst_60863 = cljs.core.PersistentHashMap.EMPTY;
var inst_60864 = inst_60859__$1;
var inst_60865 = inst_60863;
var state_60937__$1 = (function (){var statearr_61100 = state_60937;
(statearr_61100[(13)] = inst_60864);

(statearr_61100[(12)] = inst_60859__$1);

(statearr_61100[(14)] = inst_60862);

(statearr_61100[(15)] = inst_60861);

(statearr_61100[(10)] = inst_60865);

return statearr_61100;
})();
var statearr_61101_61203 = state_60937__$1;
(statearr_61101_61203[(2)] = null);

(statearr_61101_61203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (4))){
var inst_60871 = (state_60937[(8)]);
var inst_60874 = fluree.db.time_travel.non_border_t_to_block(db,inst_60871);
var state_60937__$1 = state_60937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60937__$1,(7),inst_60874);
} else {
if((state_val_60938 === (13))){
var inst_60872 = (state_60937[(16)]);
var inst_60929 = (state_60937[(2)]);
var inst_60864 = inst_60872;
var inst_60865 = inst_60929;
var state_60937__$1 = (function (){var statearr_61102 = state_60937;
(statearr_61102[(13)] = inst_60864);

(statearr_61102[(10)] = inst_60865);

return statearr_61102;
})();
var statearr_61103_61204 = state_60937__$1;
(statearr_61103_61204[(2)] = null);

(statearr_61103_61204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (6))){
var inst_60933 = (state_60937[(2)]);
var state_60937__$1 = state_60937;
var statearr_61104_61205 = state_60937__$1;
(statearr_61104_61205[(2)] = inst_60933);

(statearr_61104_61205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (3))){
var inst_60935 = (state_60937[(2)]);
var state_60937__$1 = state_60937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60937__$1,inst_60935);
} else {
if((state_val_60938 === (12))){
var inst_60882 = (state_60937[(11)]);
var state_60937__$1 = state_60937;
var statearr_61105_61206 = state_60937__$1;
(statearr_61105_61206[(2)] = inst_60882);

(statearr_61105_61206[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (2))){
var inst_60864 = (state_60937[(13)]);
var inst_60871 = (state_60937[(8)]);
var inst_60870 = cljs.core.seq(inst_60864);
var inst_60871__$1 = cljs.core.first(inst_60870);
var inst_60872 = cljs.core.next(inst_60870);
var state_60937__$1 = (function (){var statearr_61106 = state_60937;
(statearr_61106[(16)] = inst_60872);

(statearr_61106[(8)] = inst_60871__$1);

return statearr_61106;
})();
if(cljs.core.truth_(inst_60871__$1)){
var statearr_61107_61207 = state_60937__$1;
(statearr_61107_61207[(1)] = (4));

} else {
var statearr_61108_61208 = state_60937__$1;
(statearr_61108_61208[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (11))){
var inst_60872 = (state_60937[(16)]);
var inst_60864 = (state_60937[(13)]);
var inst_60882 = (state_60937[(11)]);
var inst_60859 = (state_60937[(12)]);
var inst_60862 = (state_60937[(14)]);
var inst_60861 = (state_60937[(15)]);
var inst_60877 = (state_60937[(7)]);
var inst_60871 = (state_60937[(8)]);
var inst_60865 = (state_60937[(10)]);
var inst_60889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60890 = [inst_60871,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60891 = (new cljs.core.PersistentVector(null,2,(5),inst_60889,inst_60890,null));
var inst_60904 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60905 = (function (){var t = inst_60871;
var c__2436__auto____$2 = inst_60904;
var G__60878 = inst_60882;
var vec__60856 = inst_60859;
var vec__60867 = inst_60864;
var block = inst_60877;
var r = inst_60872;
var seq__60868 = inst_60872;
var first__60869 = inst_60871;
var G__60855 = inst_60864;
var acc = inst_60865;
var first__60858 = inst_60861;
var seq__60857 = inst_60862;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_60902){
var state_val_60903 = (state_60902[(1)]);
if((state_val_60903 === (1))){
var state_60902__$1 = state_60902;
var statearr_61109_61209 = state_60902__$1;
(statearr_61109_61209[(2)] = null);

(statearr_61109_61209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60903 === (2))){
var ___$1 = (function (){var statearr_61110 = state_60902;
(statearr_61110[(4)] = cljs.core.cons((5),(state_60902[(4)])));

return statearr_61110;
})();
var ___$2 = (function (){var statearr_61111 = state_60902;
(statearr_61111[(4)] = cljs.core.rest((state_60902[(4)])));

return statearr_61111;
})();
var state_60902__$1 = state_60902;
var statearr_61112_61210 = state_60902__$1;
(statearr_61112_61210[(2)] = db);

(statearr_61112_61210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60903 === (3))){
var inst_60900 = (state_60902[(2)]);
var state_60902__$1 = state_60902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60902__$1,inst_60900);
} else {
if((state_val_60903 === (4))){
var inst_60892 = (state_60902[(2)]);
var state_60902__$1 = state_60902;
var statearr_61114_61211 = state_60902__$1;
(statearr_61114_61211[(2)] = inst_60892);

(statearr_61114_61211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60903 === (5))){
var ___$1 = (function (){var statearr_61115 = state_60902;
(statearr_61115[(4)] = cljs.core.rest((state_60902[(4)])));

return statearr_61115;
})();
var state_60902__$1 = state_60902;
var ex61113 = (state_60902__$1[(2)]);
var statearr_61116_61212 = state_60902__$1;
(statearr_61116_61212[(5)] = ex61113);


if((ex61113 instanceof Error)){
var statearr_61117_61213 = state_60902__$1;
(statearr_61117_61213[(1)] = (4));

(statearr_61117_61213[(5)] = null);

} else {
throw ex61113;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_61118 = [null,null,null,null,null,null,null];
(statearr_61118[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_61118[(1)] = (1));

return statearr_61118;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_60902){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60902);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61119){var ex__2417__auto__ = e61119;
var statearr_61120_61214 = state_60902;
(statearr_61120_61214[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60902[(4)]))){
var statearr_61121_61215 = state_60902;
(statearr_61121_61215[(1)] = cljs.core.first((state_60902[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61216 = state_60902;
state_60902 = G__61216;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_60902){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_60902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61122 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61122[(6)] = c__2436__auto____$2);

return statearr_61122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_60906 = cljs.core.async.impl.dispatch.run(inst_60905);
var inst_60907 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60909 = ["?auth","?id"];
var inst_60910 = (new cljs.core.PersistentVector(null,2,(5),inst_60908,inst_60909,null));
var inst_60911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60913 = [inst_60871,"_tx/auth","?auth"];
var inst_60914 = (new cljs.core.PersistentVector(null,3,(5),inst_60912,inst_60913,null));
var inst_60915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60916 = ["?auth","_auth/id","?id"];
var inst_60917 = (new cljs.core.PersistentVector(null,3,(5),inst_60915,inst_60916,null));
var inst_60918 = [inst_60914,inst_60917];
var inst_60919 = (new cljs.core.PersistentVector(null,2,(5),inst_60911,inst_60918,null));
var inst_60920 = [inst_60910,inst_60919];
var inst_60921 = cljs.core.PersistentHashMap.fromArrays(inst_60907,inst_60920);
var inst_60922 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_60904,inst_60921) : fluree.db.api.query.query_async.call(null,inst_60904,inst_60921));
var state_60937__$1 = (function (){var statearr_61123 = state_60937;
(statearr_61123[(17)] = inst_60891);

(statearr_61123[(18)] = inst_60906);

return statearr_61123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60937__$1,(14),inst_60922);
} else {
if((state_val_60938 === (9))){
var state_60937__$1 = state_60937;
var statearr_61124_61217 = state_60937__$1;
(statearr_61124_61217[(2)] = show_auth);

(statearr_61124_61217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (5))){
var inst_60865 = (state_60937[(10)]);
var state_60937__$1 = state_60937;
var statearr_61125_61218 = state_60937__$1;
(statearr_61125_61218[(2)] = inst_60865);

(statearr_61125_61218[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (14))){
var inst_60882 = (state_60937[(11)]);
var inst_60891 = (state_60937[(17)]);
var inst_60924 = (state_60937[(2)]);
var inst_60925 = fluree.db.util.async.throw_err(inst_60924);
var inst_60926 = cljs.core.assoc_in(inst_60882,inst_60891,inst_60925);
var state_60937__$1 = state_60937;
var statearr_61126_61219 = state_60937__$1;
(statearr_61126_61219[(2)] = inst_60926);

(statearr_61126_61219[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (10))){
var inst_60887 = (state_60937[(2)]);
var state_60937__$1 = state_60937;
if(cljs.core.truth_(inst_60887)){
var statearr_61127_61220 = state_60937__$1;
(statearr_61127_61220[(1)] = (11));

} else {
var statearr_61128_61221 = state_60937__$1;
(statearr_61128_61221[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60938 === (8))){
var inst_60883 = (state_60937[(9)]);
var state_60937__$1 = state_60937;
var statearr_61129_61222 = state_60937__$1;
(statearr_61129_61222[(2)] = inst_60883);

(statearr_61129_61222[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_61130 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61130[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_61130[(1)] = (1));

return statearr_61130;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_60937){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_60937);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61131){var ex__2417__auto__ = e61131;
var statearr_61132_61223 = state_60937;
(statearr_61132_61223[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_60937[(4)]))){
var statearr_61133_61224 = state_60937;
(statearr_61133_61224[(1)] = cljs.core.first((state_60937[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61225 = state_60937;
state_60937 = G__61225;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_60937){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_60937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61134 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61134[(6)] = c__2436__auto____$1);

return statearr_61134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_60941 = cljs.core.async.impl.dispatch.run(inst_60940);
var state_61057__$1 = (function (){var statearr_61135 = state_61057;
(statearr_61135[(22)] = inst_60941);

return statearr_61135;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61057__$1,(6),inst_60939);
} else {
if((state_val_61058 === (23))){
var inst_60999 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
if(cljs.core.truth_(inst_60999)){
var statearr_61136_61226 = state_61057__$1;
(statearr_61136_61226[(1)] = (27));

} else {
var statearr_61137_61227 = state_61057__$1;
(statearr_61137_61227[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (35))){
var inst_61023 = (state_61057[(2)]);
var state_61057__$1 = (function (){var statearr_61138 = state_61057;
(statearr_61138[(18)] = inst_61023);

return statearr_61138;
})();
var statearr_61139_61228 = state_61057__$1;
(statearr_61139_61228[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (19))){
var state_61057__$1 = state_61057;
var statearr_61141_61229 = state_61057__$1;
(statearr_61141_61229[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (11))){
var inst_60976 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
if(cljs.core.truth_(inst_60976)){
var statearr_61144_61230 = state_61057__$1;
(statearr_61144_61230[(1)] = (15));

} else {
var statearr_61145_61231 = state_61057__$1;
(statearr_61145_61231[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (9))){
var inst_60967 = (state_61057[(16)]);
var inst_60967__$1 = auth;
var state_61057__$1 = (function (){var statearr_61146 = state_61057;
(statearr_61146[(16)] = inst_60967__$1);

return statearr_61146;
})();
if(cljs.core.truth_(inst_60967__$1)){
var statearr_61147_61232 = state_61057__$1;
(statearr_61147_61232[(1)] = (12));

} else {
var statearr_61148_61233 = state_61057__$1;
(statearr_61148_61233[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (5))){
var _ = (function (){var statearr_61149 = state_61057;
(statearr_61149[(4)] = cljs.core.rest((state_61057[(4)])));

return statearr_61149;
})();
var state_61057__$1 = state_61057;
var ex61143 = (state_61057__$1[(2)]);
var statearr_61150_61234 = state_61057__$1;
(statearr_61150_61234[(5)] = ex61143);


if((ex61143 instanceof Error)){
var statearr_61151_61235 = state_61057__$1;
(statearr_61151_61235[(1)] = (4));

(statearr_61151_61235[(5)] = null);

} else {
throw ex61143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (14))){
var inst_60973 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61152_61236 = state_61057__$1;
(statearr_61152_61236[(2)] = inst_60973);

(statearr_61152_61236[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (26))){
var inst_60996 = (state_61057[(2)]);
var state_61057__$1 = state_61057;
var statearr_61153_61237 = state_61057__$1;
(statearr_61153_61237[(2)] = inst_60996);

(statearr_61153_61237[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (16))){
var inst_60964 = (state_61057[(7)]);
var state_61057__$1 = state_61057;
if(cljs.core.truth_(inst_60964)){
var statearr_61154_61238 = state_61057__$1;
(statearr_61154_61238[(1)] = (18));

} else {
var statearr_61155_61239 = state_61057__$1;
(statearr_61155_61239[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (38))){
var inst_61031 = (state_61057[(2)]);
var state_61057__$1 = (function (){var statearr_61156 = state_61057;
(statearr_61156[(12)] = inst_61031);

return statearr_61156;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61157_61240 = state_61057__$1;
(statearr_61157_61240[(1)] = (39));

} else {
var statearr_61158_61241 = state_61057__$1;
(statearr_61158_61241[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (30))){
var inst_60958 = (state_61057[(14)]);
var inst_61005 = (state_61057[(11)]);
var inst_61009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61010 = [inst_61005,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61011 = (new cljs.core.PersistentVector(null,2,(5),inst_61009,inst_61010,null));
var inst_61012 = cljs.core.assoc_in(inst_60958,inst_61011,inst_61005);
var state_61057__$1 = state_61057;
var statearr_61159_61242 = state_61057__$1;
(statearr_61159_61242[(2)] = inst_61012);

(statearr_61159_61242[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (10))){
var inst_60964 = (state_61057[(7)]);
var state_61057__$1 = state_61057;
var statearr_61160_61243 = state_61057__$1;
(statearr_61160_61243[(2)] = inst_60964);

(statearr_61160_61243[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (18))){
var inst_60982 = (state_61057[(17)]);
var inst_60964 = (state_61057[(7)]);
var inst_60983 = (state_61057[(10)]);
var inst_60944 = (state_61057[(20)]);
var inst_60982__$1 = inst_60964.t;
var inst_60983__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60944,inst_60982__$1);
var inst_60985 = (inst_60983__$1 == null);
var inst_60986 = cljs.core.not(inst_60985);
var state_61057__$1 = (function (){var statearr_61161 = state_61057;
(statearr_61161[(17)] = inst_60982__$1);

(statearr_61161[(10)] = inst_60983__$1);

return statearr_61161;
})();
if(inst_60986){
var statearr_61162_61244 = state_61057__$1;
(statearr_61162_61244[(1)] = (21));

} else {
var statearr_61163_61245 = state_61057__$1;
(statearr_61163_61245[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (42))){
var inst_60958 = (state_61057[(14)]);
var state_61057__$1 = state_61057;
var statearr_61164_61246 = state_61057__$1;
(statearr_61164_61246[(2)] = inst_60958);

(statearr_61164_61246[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (37))){
var inst_61023 = (state_61057[(18)]);
var state_61057__$1 = state_61057;
var statearr_61165_61247 = state_61057__$1;
(statearr_61165_61247[(2)] = inst_61023);

(statearr_61165_61247[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61058 === (8))){
var inst_61051 = (state_61057[(2)]);
var inst_61052 = cljs.core.vals(inst_61051);
var _ = (function (){var statearr_61166 = state_61057;
(statearr_61166[(4)] = cljs.core.rest((state_61057[(4)])));

return statearr_61166;
})();
var state_61057__$1 = state_61057;
var statearr_61167_61248 = state_61057__$1;
(statearr_61167_61248[(2)] = inst_61052);

(statearr_61167_61248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_61168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61168[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__);

(statearr_61168[(1)] = (1));

return statearr_61168;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1 = (function (state_61057){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61057);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61169){var ex__2417__auto__ = e61169;
var statearr_61170_61249 = state_61057;
(statearr_61170_61249[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61057[(4)]))){
var statearr_61171_61250 = state_61057;
(statearr_61171_61250[(1)] = cljs.core.first((state_61057[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61251 = state_61057;
state_61057 = G__61251;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__ = function(state_61057){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1.call(this,state_61057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61172 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61172[(6)] = c__2436__auto__);

return statearr_61172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61397){
var state_val_61398 = (state_61397[(1)]);
if((state_val_61398 === (7))){
var state_61397__$1 = state_61397;
var statearr_61399_61475 = state_61397__$1;
(statearr_61399_61475[(2)] = false);

(statearr_61399_61475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (20))){
var inst_61291 = (state_61397[(7)]);
var inst_61303 = (state_61397[(8)]);
var inst_61313 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61291);
var state_61397__$1 = (function (){var statearr_61400 = state_61397;
(statearr_61400[(9)] = inst_61313);

return statearr_61400;
})();
if(cljs.core.truth_(inst_61303)){
var statearr_61401_61476 = state_61397__$1;
(statearr_61401_61476[(1)] = (23));

} else {
var statearr_61402_61477 = state_61397__$1;
(statearr_61402_61477[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (27))){
var state_61397__$1 = state_61397;
var statearr_61403_61478 = state_61397__$1;
(statearr_61403_61478[(2)] = (-1));

(statearr_61403_61478[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (1))){
var state_61397__$1 = state_61397;
var statearr_61404_61479 = state_61397__$1;
(statearr_61404_61479[(2)] = null);

(statearr_61404_61479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (24))){
var inst_61303 = (state_61397[(8)]);
var state_61397__$1 = state_61397;
var statearr_61405_61480 = state_61397__$1;
(statearr_61405_61480[(2)] = inst_61303);

(statearr_61405_61480[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (39))){
var inst_61289 = (state_61397[(10)]);
var state_61397__$1 = state_61397;
var statearr_61406_61481 = state_61397__$1;
(statearr_61406_61481[(2)] = inst_61289);

(statearr_61406_61481[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (46))){
var inst_61362 = (state_61397[(11)]);
var state_61397__$1 = state_61397;
var statearr_61407_61482 = state_61397__$1;
(statearr_61407_61482[(2)] = inst_61362);

(statearr_61407_61482[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (4))){
var inst_61252 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
var statearr_61408_61483 = state_61397__$1;
(statearr_61408_61483[(2)] = inst_61252);

(statearr_61408_61483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (15))){
var inst_61284 = (state_61397[(12)]);
var inst_61293 = (state_61397[(2)]);
var inst_61294 = fluree.db.util.async.throw_err(inst_61293);
var state_61397__$1 = (function (){var statearr_61409 = state_61397;
(statearr_61409[(13)] = inst_61294);

return statearr_61409;
})();
if(cljs.core.truth_(inst_61284)){
var statearr_61410_61484 = state_61397__$1;
(statearr_61410_61484[(1)] = (16));

} else {
var statearr_61411_61485 = state_61397__$1;
(statearr_61411_61485[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (48))){
var inst_61370 = (state_61397[(2)]);
var inst_61371 = fluree.db.util.async.throw_err(inst_61370);
var state_61397__$1 = state_61397;
var statearr_61412_61486 = state_61397__$1;
(statearr_61412_61486[(2)] = inst_61371);

(statearr_61412_61486[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (50))){
var inst_61374 = (state_61397[(14)]);
var state_61397__$1 = state_61397;
var statearr_61413_61487 = state_61397__$1;
(statearr_61413_61487[(2)] = inst_61374);

(statearr_61413_61487[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (21))){
var inst_61384 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_61385 = ["History query not properly formatted. Provided ",inst_61384].join('');
var inst_61386 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61387 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61388 = cljs.core.PersistentHashMap.fromArrays(inst_61386,inst_61387);
var inst_61389 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61385,inst_61388);
var inst_61390 = (function(){throw inst_61389})();
var state_61397__$1 = state_61397;
var statearr_61414_61488 = state_61397__$1;
(statearr_61414_61488[(2)] = inst_61390);

(statearr_61414_61488[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (31))){
var inst_61294 = (state_61397[(13)]);
var inst_61337 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61294);
var state_61397__$1 = state_61397;
var statearr_61415_61489 = state_61397__$1;
(statearr_61415_61489[(2)] = inst_61337);

(statearr_61415_61489[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (32))){
var inst_61329 = (state_61397[(15)]);
var inst_61294 = (state_61397[(13)]);
var inst_61285 = (state_61397[(16)]);
var inst_61339 = (state_61397[(2)]);
var inst_61340 = fluree.db.api.query.get_history_pattern(inst_61285);
var inst_61341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61340,(0),null);
var inst_61342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61340,(1),null);
var inst_61343 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61344 = [inst_61329,inst_61339];
var inst_61345 = cljs.core.PersistentHashMap.fromArrays(inst_61343,inst_61344);
var inst_61346 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_61294,inst_61342,cljs.core._EQ_,inst_61341,inst_61345);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(34),inst_61346);
} else {
if((state_val_61398 === (40))){
var inst_61288 = (state_61397[(17)]);
var state_61397__$1 = state_61397;
var statearr_61416_61490 = state_61397__$1;
(statearr_61416_61490[(2)] = inst_61288);

(statearr_61416_61490[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (33))){
var inst_61333 = (state_61397[(2)]);
var inst_61334 = fluree.db.util.async.throw_err(inst_61333);
var inst_61335 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61334);
var state_61397__$1 = state_61397;
var statearr_61417_61491 = state_61397__$1;
(statearr_61417_61491[(2)] = inst_61335);

(statearr_61417_61491[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (13))){
var inst_61262 = (state_61397[(18)]);
var state_61397__$1 = state_61397;
var statearr_61418_61492 = state_61397__$1;
(statearr_61418_61492[(2)] = inst_61262);

(statearr_61418_61492[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (22))){
var inst_61392 = (state_61397[(2)]);
var _ = (function (){var statearr_61419 = state_61397;
(statearr_61419[(4)] = cljs.core.rest((state_61397[(4)])));

return statearr_61419;
})();
var state_61397__$1 = state_61397;
var statearr_61420_61493 = state_61397__$1;
(statearr_61420_61493[(2)] = inst_61392);

(statearr_61420_61493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (36))){
var state_61397__$1 = state_61397;
var statearr_61421_61494 = state_61397__$1;
(statearr_61421_61494[(2)] = null);

(statearr_61421_61494[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (41))){
var inst_61349 = (state_61397[(19)]);
var inst_61294 = (state_61397[(13)]);
var inst_61354 = (state_61397[(20)]);
var inst_61358 = (state_61397[(2)]);
var inst_61359 = fluree.db.api.query.format_history_resp(inst_61294,inst_61349,inst_61354,inst_61358);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(38),inst_61359);
} else {
if((state_val_61398 === (43))){
var inst_61286 = (state_61397[(21)]);
var state_61397__$1 = state_61397;
var statearr_61422_61495 = state_61397__$1;
(statearr_61422_61495[(2)] = inst_61286);

(statearr_61422_61495[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (29))){
var inst_61323 = (state_61397[(2)]);
var inst_61324 = fluree.db.util.async.throw_err(inst_61323);
var inst_61325 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61324);
var inst_61326 = (inst_61325 - (1));
var state_61397__$1 = state_61397;
var statearr_61423_61496 = state_61397__$1;
(statearr_61423_61496[(2)] = inst_61326);

(statearr_61423_61496[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (44))){
var inst_61366 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
if(cljs.core.truth_(inst_61366)){
var statearr_61424_61497 = state_61397__$1;
(statearr_61424_61497[(1)] = (45));

} else {
var statearr_61425_61498 = state_61397__$1;
(statearr_61425_61498[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (6))){
var inst_61262 = (state_61397[(18)]);
var inst_61267 = inst_61262.cljs$lang$protocol_mask$partition0$;
var inst_61268 = (inst_61267 & (64));
var inst_61269 = inst_61262.cljs$core$ISeq$;
var inst_61270 = (cljs.core.PROTOCOL_SENTINEL === inst_61269);
var inst_61271 = ((inst_61268) || (inst_61270));
var state_61397__$1 = state_61397;
if(cljs.core.truth_(inst_61271)){
var statearr_61426_61499 = state_61397__$1;
(statearr_61426_61499[(1)] = (9));

} else {
var statearr_61427_61500 = state_61397__$1;
(statearr_61427_61500[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (28))){
var inst_61304 = (state_61397[(22)]);
var inst_61329 = (state_61397[(2)]);
var state_61397__$1 = (function (){var statearr_61428 = state_61397;
(statearr_61428[(15)] = inst_61329);

return statearr_61428;
})();
if(cljs.core.truth_(inst_61304)){
var statearr_61429_61501 = state_61397__$1;
(statearr_61429_61501[(1)] = (30));

} else {
var statearr_61430_61502 = state_61397__$1;
(statearr_61430_61502[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (51))){
var inst_61382 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
var statearr_61431_61503 = state_61397__$1;
(statearr_61431_61503[(2)] = inst_61382);

(statearr_61431_61503[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (25))){
var inst_61318 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
if(cljs.core.truth_(inst_61318)){
var statearr_61432_61504 = state_61397__$1;
(statearr_61432_61504[(1)] = (26));

} else {
var statearr_61433_61505 = state_61397__$1;
(statearr_61433_61505[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (34))){
var inst_61290 = (state_61397[(23)]);
var inst_61348 = (state_61397[(2)]);
var inst_61349 = fluree.db.util.async.throw_err(inst_61348);
var state_61397__$1 = (function (){var statearr_61434 = state_61397;
(statearr_61434[(19)] = inst_61349);

return statearr_61434;
})();
if(cljs.core.truth_(inst_61290)){
var statearr_61435_61506 = state_61397__$1;
(statearr_61435_61506[(1)] = (35));

} else {
var statearr_61436_61507 = state_61397__$1;
(statearr_61436_61507[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (17))){
var state_61397__$1 = state_61397;
var statearr_61437_61508 = state_61397__$1;
(statearr_61437_61508[(2)] = null);

(statearr_61437_61508[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (3))){
var inst_61395 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61397__$1,inst_61395);
} else {
if((state_val_61398 === (12))){
var inst_61262 = (state_61397[(18)]);
var inst_61280 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61262);
var state_61397__$1 = state_61397;
var statearr_61438_61509 = state_61397__$1;
(statearr_61438_61509[(2)] = inst_61280);

(statearr_61438_61509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (2))){
var inst_61262 = (state_61397[(18)]);
var _ = (function (){var statearr_61439 = state_61397;
(statearr_61439[(4)] = cljs.core.cons((5),(state_61397[(4)])));

return statearr_61439;
})();
var inst_61262__$1 = query_map;
var inst_61264 = (inst_61262__$1 == null);
var inst_61265 = cljs.core.not(inst_61264);
var state_61397__$1 = (function (){var statearr_61440 = state_61397;
(statearr_61440[(18)] = inst_61262__$1);

return statearr_61440;
})();
if(inst_61265){
var statearr_61441_61510 = state_61397__$1;
(statearr_61441_61510[(1)] = (6));

} else {
var statearr_61442_61511 = state_61397__$1;
(statearr_61442_61511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (23))){
var inst_61303 = (state_61397[(8)]);
var inst_61315 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_61303);
var state_61397__$1 = state_61397;
var statearr_61443_61512 = state_61397__$1;
(statearr_61443_61512[(2)] = inst_61315);

(statearr_61443_61512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (47))){
var inst_61313 = (state_61397[(9)]);
var inst_61374 = (state_61397[(2)]);
var state_61397__$1 = (function (){var statearr_61444 = state_61397;
(statearr_61444[(14)] = inst_61374);

return statearr_61444;
})();
if(cljs.core.truth_(inst_61313)){
var statearr_61445_61513 = state_61397__$1;
(statearr_61445_61513[(1)] = (49));

} else {
var statearr_61446_61514 = state_61397__$1;
(statearr_61446_61514[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (35))){
var inst_61290 = (state_61397[(23)]);
var inst_61351 = cljs.core.set(inst_61290);
var state_61397__$1 = state_61397;
var statearr_61447_61515 = state_61397__$1;
(statearr_61447_61515[(2)] = inst_61351);

(statearr_61447_61515[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (19))){
var inst_61298 = (state_61397[(2)]);
var inst_61299 = fluree.db.util.async.throw_err(inst_61298);
var state_61397__$1 = state_61397;
var statearr_61448_61516 = state_61397__$1;
(statearr_61448_61516[(2)] = inst_61299);

(statearr_61448_61516[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (11))){
var inst_61275 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
var statearr_61450_61517 = state_61397__$1;
(statearr_61450_61517[(2)] = inst_61275);

(statearr_61450_61517[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (9))){
var state_61397__$1 = state_61397;
var statearr_61451_61518 = state_61397__$1;
(statearr_61451_61518[(2)] = true);

(statearr_61451_61518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (5))){
var _ = (function (){var statearr_61452 = state_61397;
(statearr_61452[(4)] = cljs.core.rest((state_61397[(4)])));

return statearr_61452;
})();
var state_61397__$1 = state_61397;
var ex61449 = (state_61397__$1[(2)]);
var statearr_61453_61519 = state_61397__$1;
(statearr_61453_61519[(5)] = ex61449);


if((ex61449 instanceof Error)){
var statearr_61454_61520 = state_61397__$1;
(statearr_61454_61520[(1)] = (4));

(statearr_61454_61520[(5)] = null);

} else {
throw ex61449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (14))){
var inst_61283 = (state_61397[(2)]);
var inst_61284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61285 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61283,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61397__$1 = (function (){var statearr_61455 = state_61397;
(statearr_61455[(12)] = inst_61284);

(statearr_61455[(23)] = inst_61290);

(statearr_61455[(24)] = inst_61287);

(statearr_61455[(7)] = inst_61291);

(statearr_61455[(21)] = inst_61286);

(statearr_61455[(10)] = inst_61289);

(statearr_61455[(17)] = inst_61288);

(statearr_61455[(16)] = inst_61285);

return statearr_61455;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(15),sources);
} else {
if((state_val_61398 === (45))){
var inst_61362 = (state_61397[(11)]);
var inst_61294 = (state_61397[(13)]);
var inst_61368 = fluree.db.api.query.format_blocks_resp_pretty(inst_61294,inst_61362);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(48),inst_61368);
} else {
if((state_val_61398 === (26))){
var inst_61294 = (state_61397[(13)]);
var inst_61303 = (state_61397[(8)]);
var inst_61320 = (inst_61303 - (1));
var inst_61321 = fluree.db.time_travel.as_of_block(inst_61294,inst_61320);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(29),inst_61321);
} else {
if((state_val_61398 === (16))){
var inst_61294 = (state_61397[(13)]);
var inst_61296 = fluree.db.api.query.resolve_block_range(inst_61294,query_map);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(19),inst_61296);
} else {
if((state_val_61398 === (38))){
var inst_61287 = (state_61397[(24)]);
var inst_61361 = (state_61397[(2)]);
var inst_61362 = fluree.db.util.async.throw_err(inst_61361);
var state_61397__$1 = (function (){var statearr_61456 = state_61397;
(statearr_61456[(11)] = inst_61362);

return statearr_61456;
})();
if(cljs.core.truth_(inst_61287)){
var statearr_61457_61521 = state_61397__$1;
(statearr_61457_61521[(1)] = (42));

} else {
var statearr_61458_61522 = state_61397__$1;
(statearr_61458_61522[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (30))){
var inst_61304 = (state_61397[(22)]);
var inst_61294 = (state_61397[(13)]);
var inst_61331 = fluree.db.time_travel.as_of_block(inst_61294,inst_61304);
var state_61397__$1 = state_61397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61397__$1,(33),inst_61331);
} else {
if((state_val_61398 === (10))){
var state_61397__$1 = state_61397;
var statearr_61459_61523 = state_61397__$1;
(statearr_61459_61523[(2)] = false);

(statearr_61459_61523[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (18))){
var inst_61302 = (state_61397[(2)]);
var inst_61303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61302,(0),null);
var inst_61304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61302,(1),null);
var inst_61305 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61306 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_61307 = cljs.core.keys(inst_61306);
var inst_61308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61305,inst_61307);
var state_61397__$1 = (function (){var statearr_61460 = state_61397;
(statearr_61460[(22)] = inst_61304);

(statearr_61460[(8)] = inst_61303);

return statearr_61460;
})();
if(inst_61308){
var statearr_61461_61524 = state_61397__$1;
(statearr_61461_61524[(1)] = (20));

} else {
var statearr_61462_61525 = state_61397__$1;
(statearr_61462_61525[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (42))){
var inst_61287 = (state_61397[(24)]);
var state_61397__$1 = state_61397;
var statearr_61463_61526 = state_61397__$1;
(statearr_61463_61526[(2)] = inst_61287);

(statearr_61463_61526[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (37))){
var inst_61289 = (state_61397[(10)]);
var inst_61354 = (state_61397[(2)]);
var state_61397__$1 = (function (){var statearr_61464 = state_61397;
(statearr_61464[(20)] = inst_61354);

return statearr_61464;
})();
if(cljs.core.truth_(inst_61289)){
var statearr_61465_61527 = state_61397__$1;
(statearr_61465_61527[(1)] = (39));

} else {
var statearr_61466_61528 = state_61397__$1;
(statearr_61466_61528[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (8))){
var inst_61278 = (state_61397[(2)]);
var state_61397__$1 = state_61397;
if(cljs.core.truth_(inst_61278)){
var statearr_61467_61529 = state_61397__$1;
(statearr_61467_61529[(1)] = (12));

} else {
var statearr_61468_61530 = state_61397__$1;
(statearr_61468_61530[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61398 === (49))){
var inst_61349 = (state_61397[(19)]);
var inst_61374 = (state_61397[(14)]);
var inst_61376 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61377 = cljs.core.count(inst_61349);
var inst_61378 = [inst_61374,inst_61377,(200)];
var inst_61379 = cljs.core.PersistentHashMap.fromArrays(inst_61376,inst_61378);
var state_61397__$1 = state_61397;
var statearr_61469_61531 = state_61397__$1;
(statearr_61469_61531[(2)] = inst_61379);

(statearr_61469_61531[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_61470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61470[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2414__auto__);

(statearr_61470[(1)] = (1));

return statearr_61470;
});
var fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1 = (function (state_61397){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61397);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61471){var ex__2417__auto__ = e61471;
var statearr_61472_61532 = state_61397;
(statearr_61472_61532[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61397[(4)]))){
var statearr_61473_61533 = state_61397;
(statearr_61473_61533[(1)] = cljs.core.first((state_61397[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61534 = state_61397;
state_61397 = G__61534;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__ = function(state_61397){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1.call(this,state_61397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61474 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61474[(6)] = c__2436__auto__);

return statearr_61474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_61687){
var state_val_61688 = (state_61687[(1)]);
if((state_val_61688 === (7))){
var state_61687__$1 = state_61687;
var statearr_61689_61781 = state_61687__$1;
(statearr_61689_61781[(2)] = false);

(statearr_61689_61781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (59))){
var inst_61672 = (state_61687[(7)]);
var state_61687__$1 = state_61687;
var statearr_61690_61782 = state_61687__$1;
(statearr_61690_61782[(2)] = inst_61672);

(statearr_61690_61782[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (20))){
var inst_61569 = (state_61687[(8)]);
var inst_61607 = (state_61687[(2)]);
var state_61687__$1 = (function (){var statearr_61691 = state_61687;
(statearr_61691[(9)] = inst_61607);

return statearr_61691;
})();
if(cljs.core.truth_(inst_61569)){
var statearr_61692_61783 = state_61687__$1;
(statearr_61692_61783[(1)] = (24));

} else {
var statearr_61693_61784 = state_61687__$1;
(statearr_61693_61784[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (58))){
var inst_61667 = (state_61687[(10)]);
var inst_61607 = (state_61687[(9)]);
var inst_61672 = (state_61687[(7)]);
var inst_61627 = (state_61687[(11)]);
var inst_61674 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61675 = cljs.core.deref(inst_61627);
var inst_61676 = fluree.db.api.query.response_time_formatted(inst_61667);
var inst_61677 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61607);
var inst_61678 = [(200),inst_61672,inst_61675,inst_61676,inst_61677];
var inst_61679 = cljs.core.PersistentHashMap.fromArrays(inst_61674,inst_61678);
var state_61687__$1 = state_61687;
var statearr_61694_61785 = state_61687__$1;
(statearr_61694_61785[(2)] = inst_61679);

(statearr_61694_61785[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (60))){
var inst_61682 = (state_61687[(2)]);
var _ = (function (){var statearr_61695 = state_61687;
(statearr_61695[(4)] = cljs.core.rest((state_61687[(4)])));

return statearr_61695;
})();
var state_61687__$1 = state_61687;
var statearr_61696_61786 = state_61687__$1;
(statearr_61696_61786[(2)] = inst_61682);

(statearr_61696_61786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (27))){
var inst_61618 = (state_61687[(12)]);
var state_61687__$1 = state_61687;
var statearr_61697_61787 = state_61687__$1;
(statearr_61697_61787[(2)] = inst_61618);

(statearr_61697_61787[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (1))){
var state_61687__$1 = state_61687;
var statearr_61698_61788 = state_61687__$1;
(statearr_61698_61788[(2)] = null);

(statearr_61698_61788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (24))){
var inst_61607 = (state_61687[(9)]);
var inst_61569 = (state_61687[(8)]);
var inst_61609 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61607);
var inst_61610 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61607);
var inst_61611 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61607);
var inst_61612 = fluree.db.api.query.get_sources(inst_61609,inst_61610,inst_61611,inst_61569);
var state_61687__$1 = state_61687;
var statearr_61699_61789 = state_61687__$1;
(statearr_61699_61789[(2)] = inst_61612);

(statearr_61699_61789[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (55))){
var inst_61660 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61661 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61662 = cljs.core.PersistentHashMap.fromArrays(inst_61660,inst_61661);
var inst_61663 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61662);
var inst_61664 = (function(){throw inst_61663})();
var state_61687__$1 = state_61687;
var statearr_61700_61790 = state_61687__$1;
(statearr_61700_61790[(2)] = inst_61664);

(statearr_61700_61790[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (39))){
var inst_61571 = (state_61687[(13)]);
var state_61687__$1 = state_61687;
var statearr_61701_61791 = state_61687__$1;
(statearr_61701_61791[(2)] = inst_61571);

(statearr_61701_61791[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (46))){
var inst_61565 = (state_61687[(14)]);
var state_61687__$1 = state_61687;
var statearr_61702_61792 = state_61687__$1;
(statearr_61702_61792[(2)] = inst_61565);

(statearr_61702_61792[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (4))){
var inst_61536 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61703_61793 = state_61687__$1;
(statearr_61703_61793[(2)] = inst_61536);

(statearr_61703_61793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (54))){
var state_61687__$1 = state_61687;
var statearr_61704_61794 = state_61687__$1;
(statearr_61704_61794[(2)] = null);

(statearr_61704_61794[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (15))){
var state_61687__$1 = state_61687;
var statearr_61705_61795 = state_61687__$1;
(statearr_61705_61795[(2)] = null);

(statearr_61705_61795[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (48))){
var inst_61572 = (state_61687[(15)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61572)){
var statearr_61706_61796 = state_61687__$1;
(statearr_61706_61796[(1)] = (51));

} else {
var statearr_61707_61797 = state_61687__$1;
(statearr_61707_61797[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (50))){
var inst_61657 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61657)){
var statearr_61708_61798 = state_61687__$1;
(statearr_61708_61798[(1)] = (54));

} else {
var statearr_61709_61799 = state_61687__$1;
(statearr_61709_61799[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (21))){
var inst_61600 = (state_61687[(2)]);
var inst_61601 = fluree.db.util.async.throw_err(inst_61600);
var state_61687__$1 = state_61687;
var statearr_61710_61800 = state_61687__$1;
(statearr_61710_61800[(2)] = inst_61601);

(statearr_61710_61800[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (31))){
var state_61687__$1 = state_61687;
var statearr_61711_61801 = state_61687__$1;
(statearr_61711_61801[(2)] = null);

(statearr_61711_61801[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (32))){
var inst_61573 = (state_61687[(16)]);
var inst_61628 = (state_61687[(17)]);
var inst_61627 = (state_61687[(2)]);
var inst_61628__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61573);
var state_61687__$1 = (function (){var statearr_61712 = state_61687;
(statearr_61712[(11)] = inst_61627);

(statearr_61712[(17)] = inst_61628__$1);

return statearr_61712;
})();
if(cljs.core.truth_(inst_61628__$1)){
var statearr_61713_61802 = state_61687__$1;
(statearr_61713_61802[(1)] = (33));

} else {
var statearr_61714_61803 = state_61687__$1;
(statearr_61714_61803[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (40))){
var inst_61570 = (state_61687[(18)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61570)){
var statearr_61715_61804 = state_61687__$1;
(statearr_61715_61804[(1)] = (42));

} else {
var statearr_61716_61805 = state_61687__$1;
(statearr_61716_61805[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (56))){
var inst_61633 = (state_61687[(19)]);
var inst_61607 = (state_61687[(9)]);
var inst_61666 = (state_61687[(2)]);
var inst_61667 = fluree.db.util.core.current_time_millis();
var inst_61668 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61633);
var inst_61669 = fluree.db.query.fql.query(inst_61607,inst_61668);
var state_61687__$1 = (function (){var statearr_61717 = state_61687;
(statearr_61717[(20)] = inst_61666);

(statearr_61717[(10)] = inst_61667);

return statearr_61717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61687__$1,(57),inst_61669);
} else {
if((state_val_61688 === (33))){
var inst_61628 = (state_61687[(17)]);
var state_61687__$1 = state_61687;
var statearr_61718_61806 = state_61687__$1;
(statearr_61718_61806[(2)] = inst_61628);

(statearr_61718_61806[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (13))){
var inst_61543 = (state_61687[(21)]);
var state_61687__$1 = state_61687;
var statearr_61719_61807 = state_61687__$1;
(statearr_61719_61807[(2)] = inst_61543);

(statearr_61719_61807[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (22))){
var inst_61567 = (state_61687[(22)]);
var inst_61596 = (state_61687[(2)]);
var inst_61597 = fluree.db.util.async.throw_err(inst_61596);
var inst_61598 = fluree.db.time_travel.as_of_block(inst_61597,inst_61567);
var state_61687__$1 = state_61687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61687__$1,(21),inst_61598);
} else {
if((state_val_61688 === (36))){
var inst_61566 = (state_61687[(23)]);
var state_61687__$1 = state_61687;
var statearr_61720_61808 = state_61687__$1;
(statearr_61720_61808[(2)] = inst_61566);

(statearr_61720_61808[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (41))){
var inst_61647 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61721_61809 = state_61687__$1;
(statearr_61721_61809[(2)] = inst_61647);

(statearr_61721_61809[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (43))){
var inst_61574 = (state_61687[(24)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61574)){
var statearr_61722_61810 = state_61687__$1;
(statearr_61722_61810[(1)] = (45));

} else {
var statearr_61723_61811 = state_61687__$1;
(statearr_61723_61811[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (29))){
var inst_61622 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61622)){
var statearr_61724_61812 = state_61687__$1;
(statearr_61724_61812[(1)] = (30));

} else {
var statearr_61725_61813 = state_61687__$1;
(statearr_61725_61813[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (44))){
var inst_61645 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61726_61814 = state_61687__$1;
(statearr_61726_61814[(2)] = inst_61645);

(statearr_61726_61814[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (6))){
var inst_61543 = (state_61687[(21)]);
var inst_61548 = inst_61543.cljs$lang$protocol_mask$partition0$;
var inst_61549 = (inst_61548 & (64));
var inst_61550 = inst_61543.cljs$core$ISeq$;
var inst_61551 = (cljs.core.PROTOCOL_SENTINEL === inst_61550);
var inst_61552 = ((inst_61549) || (inst_61551));
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61552)){
var statearr_61727_61815 = state_61687__$1;
(statearr_61727_61815[(1)] = (9));

} else {
var statearr_61728_61816 = state_61687__$1;
(statearr_61728_61816[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (28))){
var inst_61617 = (state_61687[(25)]);
var state_61687__$1 = state_61687;
var statearr_61729_61817 = state_61687__$1;
(statearr_61729_61817[(2)] = inst_61617);

(statearr_61729_61817[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (51))){
var inst_61572 = (state_61687[(15)]);
var state_61687__$1 = state_61687;
var statearr_61730_61818 = state_61687__$1;
(statearr_61730_61818[(2)] = inst_61572);

(statearr_61730_61818[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (25))){
var inst_61614 = cljs.core.PersistentHashMap.EMPTY;
var state_61687__$1 = state_61687;
var statearr_61731_61819 = state_61687__$1;
(statearr_61731_61819[(2)] = inst_61614);

(statearr_61731_61819[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (34))){
var state_61687__$1 = state_61687;
var statearr_61732_61820 = state_61687__$1;
(statearr_61732_61820[(2)] = (1000000));

(statearr_61732_61820[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (17))){
var inst_61567 = (state_61687[(22)]);
var inst_61592 = (state_61687[(2)]);
var inst_61593 = sources;
var state_61687__$1 = (function (){var statearr_61733 = state_61687;
(statearr_61733[(26)] = inst_61593);

(statearr_61733[(27)] = inst_61592);

return statearr_61733;
})();
if(cljs.core.truth_(inst_61567)){
var statearr_61734_61821 = state_61687__$1;
(statearr_61734_61821[(1)] = (18));

} else {
var statearr_61735_61822 = state_61687__$1;
(statearr_61735_61822[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (3))){
var inst_61685 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61687__$1,inst_61685);
} else {
if((state_val_61688 === (12))){
var inst_61543 = (state_61687[(21)]);
var inst_61561 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61543);
var state_61687__$1 = state_61687;
var statearr_61736_61823 = state_61687__$1;
(statearr_61736_61823[(2)] = inst_61561);

(statearr_61736_61823[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (2))){
var inst_61543 = (state_61687[(21)]);
var _ = (function (){var statearr_61737 = state_61687;
(statearr_61737[(4)] = cljs.core.cons((5),(state_61687[(4)])));

return statearr_61737;
})();
var inst_61543__$1 = flureeQL;
var inst_61545 = (inst_61543__$1 == null);
var inst_61546 = cljs.core.not(inst_61545);
var state_61687__$1 = (function (){var statearr_61738 = state_61687;
(statearr_61738[(21)] = inst_61543__$1);

return statearr_61738;
})();
if(inst_61546){
var statearr_61739_61824 = state_61687__$1;
(statearr_61739_61824[(1)] = (6));

} else {
var statearr_61740_61825 = state_61687__$1;
(statearr_61740_61825[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (23))){
var inst_61604 = (state_61687[(2)]);
var inst_61605 = fluree.db.util.async.throw_err(inst_61604);
var state_61687__$1 = state_61687;
var statearr_61741_61826 = state_61687__$1;
(statearr_61741_61826[(2)] = inst_61605);

(statearr_61741_61826[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (47))){
var inst_61643 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61742_61827 = state_61687__$1;
(statearr_61742_61827[(2)] = inst_61643);

(statearr_61742_61827[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (35))){
var inst_61573 = (state_61687[(16)]);
var inst_61566 = (state_61687[(23)]);
var inst_61616 = (state_61687[(28)]);
var inst_61627 = (state_61687[(11)]);
var inst_61632 = (state_61687[(2)]);
var inst_61633 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_61573,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61616,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61632,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61627], 0));
var state_61687__$1 = (function (){var statearr_61743 = state_61687;
(statearr_61743[(19)] = inst_61633);

return statearr_61743;
})();
if(cljs.core.truth_(inst_61566)){
var statearr_61744_61828 = state_61687__$1;
(statearr_61744_61828[(1)] = (36));

} else {
var statearr_61745_61829 = state_61687__$1;
(statearr_61745_61829[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (19))){
var inst_61593 = (state_61687[(26)]);
var state_61687__$1 = state_61687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61687__$1,(23),inst_61593);
} else {
if((state_val_61688 === (57))){
var inst_61617 = (state_61687[(25)]);
var inst_61671 = (state_61687[(2)]);
var inst_61672 = fluree.db.util.async.throw_err(inst_61671);
var state_61687__$1 = (function (){var statearr_61746 = state_61687;
(statearr_61746[(7)] = inst_61672);

return statearr_61746;
})();
if(cljs.core.truth_(inst_61617)){
var statearr_61747_61830 = state_61687__$1;
(statearr_61747_61830[(1)] = (58));

} else {
var statearr_61748_61831 = state_61687__$1;
(statearr_61748_61831[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (11))){
var inst_61556 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61750_61832 = state_61687__$1;
(statearr_61750_61832[(2)] = inst_61556);

(statearr_61750_61832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (9))){
var state_61687__$1 = state_61687;
var statearr_61751_61833 = state_61687__$1;
(statearr_61751_61833[(2)] = true);

(statearr_61751_61833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (5))){
var _ = (function (){var statearr_61752 = state_61687;
(statearr_61752[(4)] = cljs.core.rest((state_61687[(4)])));

return statearr_61752;
})();
var state_61687__$1 = state_61687;
var ex61749 = (state_61687__$1[(2)]);
var statearr_61753_61834 = state_61687__$1;
(statearr_61753_61834[(5)] = ex61749);


if((ex61749 instanceof Error)){
var statearr_61754_61835 = state_61687__$1;
(statearr_61754_61835[(1)] = (4));

(statearr_61754_61835[(5)] = null);

} else {
throw ex61749;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (14))){
var inst_61573 = (state_61687[(16)]);
var inst_61568 = (state_61687[(29)]);
var inst_61570 = (state_61687[(18)]);
var inst_61571 = (state_61687[(13)]);
var inst_61567 = (state_61687[(22)]);
var inst_61574 = (state_61687[(24)]);
var inst_61566 = (state_61687[(23)]);
var inst_61572 = (state_61687[(15)]);
var inst_61565 = (state_61687[(14)]);
var inst_61569 = (state_61687[(8)]);
var inst_61564 = (state_61687[(2)]);
var inst_61565__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61566__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61567__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61568__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61569__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61570__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61571__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61572__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61573__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61574__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61564,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61575 = (function (){var construct = inst_61565__$1;
var select = inst_61566__$1;
var block = inst_61567__$1;
var where = inst_61568__$1;
var prefixes = inst_61569__$1;
var map__61542 = inst_61564;
var selectDistinct = inst_61570__$1;
var selectOne = inst_61571__$1;
var from = inst_61572__$1;
var opts = inst_61573__$1;
var selectReduced = inst_61574__$1;
return (function (p1__61535_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__61535_SHARP_);
});
})();
var inst_61576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61577 = [inst_61566__$1,inst_61571__$1,inst_61570__$1,inst_61574__$1];
var inst_61578 = (new cljs.core.PersistentVector(null,4,(5),inst_61576,inst_61577,null));
var inst_61579 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_61578);
var inst_61580 = cljs.core.count(inst_61579);
var inst_61581 = (inst_61575.cljs$core$IFn$_invoke$arity$1 ? inst_61575.cljs$core$IFn$_invoke$arity$1(inst_61580) : inst_61575.call(null,inst_61580));
var state_61687__$1 = (function (){var statearr_61755 = state_61687;
(statearr_61755[(16)] = inst_61573__$1);

(statearr_61755[(29)] = inst_61568__$1);

(statearr_61755[(18)] = inst_61570__$1);

(statearr_61755[(13)] = inst_61571__$1);

(statearr_61755[(22)] = inst_61567__$1);

(statearr_61755[(24)] = inst_61574__$1);

(statearr_61755[(23)] = inst_61566__$1);

(statearr_61755[(15)] = inst_61572__$1);

(statearr_61755[(14)] = inst_61565__$1);

(statearr_61755[(8)] = inst_61569__$1);

return statearr_61755;
})();
if(cljs.core.truth_(inst_61581)){
var statearr_61756_61836 = state_61687__$1;
(statearr_61756_61836[(1)] = (15));

} else {
var statearr_61757_61837 = state_61687__$1;
(statearr_61757_61837[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (45))){
var inst_61574 = (state_61687[(24)]);
var state_61687__$1 = state_61687;
var statearr_61758_61838 = state_61687__$1;
(statearr_61758_61838[(2)] = inst_61574);

(statearr_61758_61838[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (53))){
var inst_61654 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
var statearr_61759_61839 = state_61687__$1;
(statearr_61759_61839[(2)] = inst_61654);

(statearr_61759_61839[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (26))){
var inst_61573 = (state_61687[(16)]);
var inst_61618 = (state_61687[(12)]);
var inst_61616 = (state_61687[(2)]);
var inst_61617 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61573);
var inst_61618__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61573);
var state_61687__$1 = (function (){var statearr_61760 = state_61687;
(statearr_61760[(12)] = inst_61618__$1);

(statearr_61760[(25)] = inst_61617);

(statearr_61760[(28)] = inst_61616);

return statearr_61760;
})();
if(cljs.core.truth_(inst_61618__$1)){
var statearr_61761_61840 = state_61687__$1;
(statearr_61761_61840[(1)] = (27));

} else {
var statearr_61762_61841 = state_61687__$1;
(statearr_61762_61841[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (16))){
var inst_61584 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_61585 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61584].join('');
var inst_61586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61587 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61588 = cljs.core.PersistentHashMap.fromArrays(inst_61586,inst_61587);
var inst_61589 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61585,inst_61588);
var inst_61590 = (function(){throw inst_61589})();
var state_61687__$1 = state_61687;
var statearr_61763_61842 = state_61687__$1;
(statearr_61763_61842[(2)] = inst_61590);

(statearr_61763_61842[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (38))){
var inst_61649 = (state_61687[(30)]);
var inst_61649__$1 = (state_61687[(2)]);
var state_61687__$1 = (function (){var statearr_61764 = state_61687;
(statearr_61764[(30)] = inst_61649__$1);

return statearr_61764;
})();
if(cljs.core.truth_(inst_61649__$1)){
var statearr_61765_61843 = state_61687__$1;
(statearr_61765_61843[(1)] = (48));

} else {
var statearr_61766_61844 = state_61687__$1;
(statearr_61766_61844[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (30))){
var inst_61624 = cljs.core.volatile_BANG_((0));
var state_61687__$1 = state_61687;
var statearr_61767_61845 = state_61687__$1;
(statearr_61767_61845[(2)] = inst_61624);

(statearr_61767_61845[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (10))){
var state_61687__$1 = state_61687;
var statearr_61768_61846 = state_61687__$1;
(statearr_61768_61846[(2)] = false);

(statearr_61768_61846[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (18))){
var inst_61593 = (state_61687[(26)]);
var state_61687__$1 = state_61687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61687__$1,(22),inst_61593);
} else {
if((state_val_61688 === (52))){
var inst_61568 = (state_61687[(29)]);
var state_61687__$1 = state_61687;
var statearr_61769_61847 = state_61687__$1;
(statearr_61769_61847[(2)] = inst_61568);

(statearr_61769_61847[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (42))){
var inst_61570 = (state_61687[(18)]);
var state_61687__$1 = state_61687;
var statearr_61770_61848 = state_61687__$1;
(statearr_61770_61848[(2)] = inst_61570);

(statearr_61770_61848[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (37))){
var inst_61571 = (state_61687[(13)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61571)){
var statearr_61771_61849 = state_61687__$1;
(statearr_61771_61849[(1)] = (39));

} else {
var statearr_61772_61850 = state_61687__$1;
(statearr_61772_61850[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (8))){
var inst_61559 = (state_61687[(2)]);
var state_61687__$1 = state_61687;
if(cljs.core.truth_(inst_61559)){
var statearr_61773_61851 = state_61687__$1;
(statearr_61773_61851[(1)] = (12));

} else {
var statearr_61774_61852 = state_61687__$1;
(statearr_61774_61852[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61688 === (49))){
var inst_61649 = (state_61687[(30)]);
var state_61687__$1 = state_61687;
var statearr_61775_61853 = state_61687__$1;
(statearr_61775_61853[(2)] = inst_61649);

(statearr_61775_61853[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_61776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61776[(0)] = fluree$db$api$query$query_async_$_state_machine__2414__auto__);

(statearr_61776[(1)] = (1));

return statearr_61776;
});
var fluree$db$api$query$query_async_$_state_machine__2414__auto____1 = (function (state_61687){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_61687);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e61777){var ex__2417__auto__ = e61777;
var statearr_61778_61854 = state_61687;
(statearr_61778_61854[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_61687[(4)]))){
var statearr_61779_61855 = state_61687;
(statearr_61779_61855[(1)] = cljs.core.first((state_61687[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61856 = state_61687;
state_61687 = G__61856;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2414__auto__ = function(state_61687){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2414__auto____1.call(this,state_61687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_61780 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_61780[(6)] = c__2436__auto__);

return statearr_61780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62010){
var state_val_62011 = (state_62010[(1)]);
if((state_val_62011 === (7))){
var inst_62005 = (state_62010[(2)]);
var _ = (function (){var statearr_62012 = state_62010;
(statearr_62012[(4)] = cljs.core.rest((state_62010[(4)])));

return statearr_62012;
})();
var state_62010__$1 = state_62010;
var statearr_62013_62092 = state_62010__$1;
(statearr_62013_62092[(2)] = inst_62005);

(statearr_62013_62092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (20))){
var inst_61926 = (state_62010[(7)]);
var inst_61944 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61926);
var state_62010__$1 = state_62010;
var statearr_62014_62093 = state_62010__$1;
(statearr_62014_62093[(2)] = inst_61944);

(statearr_62014_62093[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (27))){
var inst_61954 = (state_62010[(8)]);
var state_62010__$1 = state_62010;
var statearr_62015_62094 = state_62010__$1;
(statearr_62015_62094[(2)] = inst_61954);

(statearr_62015_62094[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (1))){
var state_62010__$1 = state_62010;
var statearr_62016_62095 = state_62010__$1;
(statearr_62016_62095[(2)] = null);

(statearr_62016_62095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (24))){
var inst_61896 = (state_62010[(9)]);
var inst_61951 = (state_62010[(10)]);
var inst_61954 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61951);
var inst_61955 = (inst_61896 == null);
var state_62010__$1 = (function (){var statearr_62017 = state_62010;
(statearr_62017[(8)] = inst_61954);

return statearr_62017;
})();
if(cljs.core.truth_(inst_61955)){
var statearr_62018_62096 = state_62010__$1;
(statearr_62018_62096[(1)] = (27));

} else {
var statearr_62019_62097 = state_62010__$1;
(statearr_62019_62097[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (39))){
var inst_61897 = (state_62010[(11)]);
var inst_61951 = (state_62010[(10)]);
var inst_61982 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61951,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61983 = (inst_61897 + inst_61982);
var state_62010__$1 = state_62010;
var statearr_62020_62098 = state_62010__$1;
(statearr_62020_62098[(2)] = inst_61983);

(statearr_62020_62098[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (46))){
var inst_61951 = (state_62010[(10)]);
var state_62010__$1 = state_62010;
var statearr_62021_62099 = state_62010__$1;
(statearr_62021_62099[(2)] = inst_61951);

(statearr_62021_62099[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (4))){
var inst_61857 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62022_62100 = state_62010__$1;
(statearr_62022_62100[(2)] = inst_61857);

(statearr_62022_62100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (15))){
var state_62010__$1 = state_62010;
var statearr_62023_62101 = state_62010__$1;
(statearr_62023_62101[(2)] = false);

(statearr_62023_62101[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (21))){
var inst_61926 = (state_62010[(7)]);
var state_62010__$1 = state_62010;
var statearr_62024_62102 = state_62010__$1;
(statearr_62024_62102[(2)] = inst_61926);

(statearr_62024_62102[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (31))){
var inst_61896 = (state_62010[(9)]);
var inst_61954 = (state_62010[(8)]);
var inst_61961 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61954);
var inst_61962 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61896);
var inst_61963 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_61896);
var inst_61964 = ((inst_61961) || (inst_61962) || (inst_61963));
var state_62010__$1 = state_62010;
if(cljs.core.truth_(inst_61964)){
var statearr_62025_62103 = state_62010__$1;
(statearr_62025_62103[(1)] = (33));

} else {
var statearr_62026_62104 = state_62010__$1;
(statearr_62026_62104[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (32))){
var inst_61975 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62027_62105 = state_62010__$1;
(statearr_62027_62105[(2)] = inst_61975);

(statearr_62027_62105[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (40))){
var state_62010__$1 = state_62010;
var statearr_62028_62106 = state_62010__$1;
(statearr_62028_62106[(2)] = null);

(statearr_62028_62106[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (33))){
var state_62010__$1 = state_62010;
var statearr_62029_62107 = state_62010__$1;
(statearr_62029_62107[(2)] = (207));

(statearr_62029_62107[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (13))){
var inst_61920 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62030_62108 = state_62010__$1;
(statearr_62030_62108[(2)] = inst_61920);

(statearr_62030_62108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (22))){
var inst_61910 = (state_62010[(12)]);
var inst_61947 = (state_62010[(2)]);
var inst_61948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61947,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61947,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62010__$1 = (function (){var statearr_62031 = state_62010;
(statearr_62031[(13)] = inst_61948);

(statearr_62031[(14)] = inst_61949);

return statearr_62031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62010__$1,(23),inst_61910);
} else {
if((state_val_62011 === (36))){
var inst_61896 = (state_62010[(9)]);
var inst_61954 = (state_62010[(8)]);
var inst_61968 = ((inst_61954 > inst_61896) ? inst_61954 : inst_61896);
var state_62010__$1 = state_62010;
var statearr_62032_62109 = state_62010__$1;
(statearr_62032_62109[(2)] = inst_61968);

(statearr_62032_62109[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (41))){
var inst_61952 = (state_62010[(15)]);
var inst_61986 = (state_62010[(2)]);
var state_62010__$1 = (function (){var statearr_62033 = state_62010;
(statearr_62033[(16)] = inst_61986);

return statearr_62033;
})();
if(cljs.core.truth_(inst_61952)){
var statearr_62034_62110 = state_62010__$1;
(statearr_62034_62110[(1)] = (42));

} else {
var statearr_62035_62111 = state_62010__$1;
(statearr_62035_62111[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (43))){
var inst_61949 = (state_62010[(14)]);
var state_62010__$1 = state_62010;
if(cljs.core.truth_(inst_61949)){
var statearr_62036_62112 = state_62010__$1;
(statearr_62036_62112[(1)] = (45));

} else {
var statearr_62037_62113 = state_62010__$1;
(statearr_62037_62113[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (29))){
var inst_61977 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62038_62114 = state_62010__$1;
(statearr_62038_62114[(2)] = inst_61977);

(statearr_62038_62114[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (44))){
var inst_61908 = (state_62010[(17)]);
var inst_61986 = (state_62010[(16)]);
var inst_61980 = (state_62010[(18)]);
var inst_62000 = (state_62010[(2)]);
var inst_61895 = inst_61908;
var inst_61896 = inst_61980;
var inst_61897 = inst_61986;
var inst_61898 = inst_62000;
var state_62010__$1 = (function (){var statearr_62039 = state_62010;
(statearr_62039[(9)] = inst_61896);

(statearr_62039[(11)] = inst_61897);

(statearr_62039[(19)] = inst_61895);

(statearr_62039[(20)] = inst_61898);

return statearr_62039;
})();
var statearr_62040_62115 = state_62010__$1;
(statearr_62040_62115[(2)] = null);

(statearr_62040_62115[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (6))){
var inst_61910 = (state_62010[(12)]);
var inst_61895 = (state_62010[(19)]);
var inst_61906 = cljs.core.seq(inst_61895);
var inst_61907 = cljs.core.first(inst_61906);
var inst_61908 = cljs.core.next(inst_61906);
var inst_61909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61907,(0),null);
var inst_61910__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61907,(1),null);
var inst_61911 = (inst_61910__$1 == null);
var state_62010__$1 = (function (){var statearr_62041 = state_62010;
(statearr_62041[(12)] = inst_61910__$1);

(statearr_62041[(17)] = inst_61908);

(statearr_62041[(21)] = inst_61909);

return statearr_62041;
})();
if(cljs.core.truth_(inst_61911)){
var statearr_62042_62116 = state_62010__$1;
(statearr_62042_62116[(1)] = (8));

} else {
var statearr_62043_62117 = state_62010__$1;
(statearr_62043_62117[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (28))){
var inst_61896 = (state_62010[(9)]);
var inst_61954 = (state_62010[(8)]);
var inst_61958 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61896,inst_61954);
var state_62010__$1 = state_62010;
if(inst_61958){
var statearr_62044_62118 = state_62010__$1;
(statearr_62044_62118[(1)] = (30));

} else {
var statearr_62045_62119 = state_62010__$1;
(statearr_62045_62119[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (25))){
var state_62010__$1 = state_62010;
var statearr_62046_62120 = state_62010__$1;
(statearr_62046_62120[(2)] = null);

(statearr_62046_62120[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (34))){
var state_62010__$1 = state_62010;
var statearr_62047_62121 = state_62010__$1;
(statearr_62047_62121[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (17))){
var state_62010__$1 = state_62010;
var statearr_62049_62122 = state_62010__$1;
(statearr_62049_62122[(2)] = true);

(statearr_62049_62122[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (3))){
var inst_62008 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62010__$1,inst_62008);
} else {
if((state_val_62011 === (12))){
var inst_61898 = (state_62010[(20)]);
var state_62010__$1 = state_62010;
var statearr_62050_62123 = state_62010__$1;
(statearr_62050_62123[(2)] = inst_61898);

(statearr_62050_62123[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (2))){
var inst_61871 = (state_62010[(22)]);
var inst_61872 = (state_62010[(23)]);
var inst_61867 = (state_62010[(24)]);
var _ = (function (){var statearr_62051 = state_62010;
(statearr_62051[(4)] = cljs.core.cons((5),(state_62010[(4)])));

return statearr_62051;
})();
var inst_61863 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61865 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61866 = (new cljs.core.PersistentVector(null,2,(5),inst_61864,inst_61865,null));
var inst_61867__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61866);
var inst_61868 = (function (){var global_block = inst_61863;
var global_meta_QMARK_ = inst_61867__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61869 = cljs.core.PersistentHashMap.EMPTY;
var inst_61870 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61871__$1 = cljs.core.reduce_kv(inst_61868,inst_61869,inst_61870);
var inst_61872__$1 = fluree.db.util.core.current_time_millis();
var inst_61874 = (function (){var global_block = inst_61863;
var global_meta_QMARK_ = inst_61867__$1;
var queries = inst_61871__$1;
var start_time = inst_61872__$1;
return (function (p__61873){
var vec__62052 = p__61873;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62052,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62052,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_61875 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61874,inst_61871__$1);
var inst_61889 = cljs.core.seq(inst_61875);
var inst_61890 = cljs.core.first(inst_61889);
var inst_61891 = cljs.core.next(inst_61889);
var inst_61892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61890,(0),null);
var inst_61893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61890,(1),null);
var inst_61894 = cljs.core.PersistentHashMap.EMPTY;
var inst_61895 = inst_61875;
var inst_61896 = null;
var inst_61897 = (0);
var inst_61898 = inst_61894;
var state_62010__$1 = (function (){var statearr_62055 = state_62010;
(statearr_62055[(22)] = inst_61871__$1);

(statearr_62055[(9)] = inst_61896);

(statearr_62055[(25)] = inst_61891);

(statearr_62055[(23)] = inst_61872__$1);

(statearr_62055[(11)] = inst_61897);

(statearr_62055[(19)] = inst_61895);

(statearr_62055[(26)] = inst_61893);

(statearr_62055[(27)] = inst_61892);

(statearr_62055[(24)] = inst_61867__$1);

(statearr_62055[(20)] = inst_61898);

return statearr_62055;
})();
var statearr_62056_62124 = state_62010__$1;
(statearr_62056_62124[(2)] = null);

(statearr_62056_62124[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (23))){
var inst_61948 = (state_62010[(13)]);
var inst_61951 = (state_62010[(10)]);
var inst_61951__$1 = (state_62010[(2)]);
var inst_61952 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61951__$1);
var state_62010__$1 = (function (){var statearr_62057 = state_62010;
(statearr_62057[(15)] = inst_61952);

(statearr_62057[(10)] = inst_61951__$1);

return statearr_62057;
})();
if(cljs.core.truth_(inst_61948)){
var statearr_62058_62125 = state_62010__$1;
(statearr_62058_62125[(1)] = (24));

} else {
var statearr_62059_62126 = state_62010__$1;
(statearr_62059_62126[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (47))){
var inst_61909 = (state_62010[(21)]);
var inst_61898 = (state_62010[(20)]);
var inst_61997 = (state_62010[(2)]);
var inst_61998 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_61898,inst_61909,inst_61997);
var state_62010__$1 = state_62010;
var statearr_62060_62127 = state_62010__$1;
(statearr_62060_62127[(2)] = inst_61998);

(statearr_62060_62127[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (35))){
var inst_61973 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62061_62128 = state_62010__$1;
(statearr_62061_62128[(2)] = inst_61973);

(statearr_62061_62128[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (19))){
var inst_61939 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62062_62129 = state_62010__$1;
(statearr_62062_62129[(2)] = inst_61939);

(statearr_62062_62129[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (11))){
var inst_61896 = (state_62010[(9)]);
var inst_61872 = (state_62010[(23)]);
var inst_61897 = (state_62010[(11)]);
var inst_61898 = (state_62010[(20)]);
var inst_61914 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61915 = fluree.db.api.query.response_time_formatted(inst_61872);
var inst_61916 = [inst_61898,inst_61897,inst_61896,inst_61915];
var inst_61917 = cljs.core.PersistentHashMap.fromArrays(inst_61914,inst_61916);
var state_62010__$1 = state_62010;
var statearr_62064_62130 = state_62010__$1;
(statearr_62064_62130[(2)] = inst_61917);

(statearr_62064_62130[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (9))){
var inst_61871 = (state_62010[(22)]);
var inst_61909 = (state_62010[(21)]);
var inst_61926 = (state_62010[(7)]);
var inst_61923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61924 = [inst_61909,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61925 = (new cljs.core.PersistentVector(null,2,(5),inst_61923,inst_61924,null));
var inst_61926__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61871,inst_61925);
var inst_61928 = (inst_61926__$1 == null);
var inst_61929 = cljs.core.not(inst_61928);
var state_62010__$1 = (function (){var statearr_62065 = state_62010;
(statearr_62065[(7)] = inst_61926__$1);

return statearr_62065;
})();
if(inst_61929){
var statearr_62066_62131 = state_62010__$1;
(statearr_62066_62131[(1)] = (14));

} else {
var statearr_62067_62132 = state_62010__$1;
(statearr_62067_62132[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (5))){
var _ = (function (){var statearr_62068 = state_62010;
(statearr_62068[(4)] = cljs.core.rest((state_62010[(4)])));

return statearr_62068;
})();
var state_62010__$1 = state_62010;
var ex62063 = (state_62010__$1[(2)]);
var statearr_62069_62133 = state_62010__$1;
(statearr_62069_62133[(5)] = ex62063);


var statearr_62070_62134 = state_62010__$1;
(statearr_62070_62134[(1)] = (4));

(statearr_62070_62134[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (14))){
var inst_61926 = (state_62010[(7)]);
var inst_61931 = inst_61926.cljs$lang$protocol_mask$partition0$;
var inst_61932 = (inst_61931 & (64));
var inst_61933 = inst_61926.cljs$core$ISeq$;
var inst_61934 = (cljs.core.PROTOCOL_SENTINEL === inst_61933);
var inst_61935 = ((inst_61932) || (inst_61934));
var state_62010__$1 = state_62010;
if(cljs.core.truth_(inst_61935)){
var statearr_62071_62135 = state_62010__$1;
(statearr_62071_62135[(1)] = (17));

} else {
var statearr_62072_62136 = state_62010__$1;
(statearr_62072_62136[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (45))){
var inst_61951 = (state_62010[(10)]);
var inst_61994 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61951);
var state_62010__$1 = state_62010;
var statearr_62073_62137 = state_62010__$1;
(statearr_62073_62137[(2)] = inst_61994);

(statearr_62073_62137[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (26))){
var inst_61948 = (state_62010[(13)]);
var inst_61980 = (state_62010[(2)]);
var state_62010__$1 = (function (){var statearr_62074 = state_62010;
(statearr_62074[(18)] = inst_61980);

return statearr_62074;
})();
if(cljs.core.truth_(inst_61948)){
var statearr_62075_62138 = state_62010__$1;
(statearr_62075_62138[(1)] = (39));

} else {
var statearr_62076_62139 = state_62010__$1;
(statearr_62076_62139[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (16))){
var inst_61942 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
if(cljs.core.truth_(inst_61942)){
var statearr_62077_62140 = state_62010__$1;
(statearr_62077_62140[(1)] = (20));

} else {
var statearr_62078_62141 = state_62010__$1;
(statearr_62078_62141[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (38))){
var inst_61971 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62079_62142 = state_62010__$1;
(statearr_62079_62142[(2)] = inst_61971);

(statearr_62079_62142[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (30))){
var inst_61954 = (state_62010[(8)]);
var state_62010__$1 = state_62010;
var statearr_62080_62143 = state_62010__$1;
(statearr_62080_62143[(2)] = inst_61954);

(statearr_62080_62143[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (10))){
var inst_62003 = (state_62010[(2)]);
var state_62010__$1 = state_62010;
var statearr_62081_62144 = state_62010__$1;
(statearr_62081_62144[(2)] = inst_62003);

(statearr_62081_62144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (18))){
var state_62010__$1 = state_62010;
var statearr_62082_62145 = state_62010__$1;
(statearr_62082_62145[(2)] = false);

(statearr_62082_62145[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (42))){
var inst_61909 = (state_62010[(21)]);
var inst_61951 = (state_62010[(10)]);
var inst_61898 = (state_62010[(20)]);
var inst_61988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61989 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61909];
var inst_61990 = (new cljs.core.PersistentVector(null,2,(5),inst_61988,inst_61989,null));
var inst_61991 = cljs.core.assoc_in(inst_61898,inst_61990,inst_61951);
var state_62010__$1 = state_62010;
var statearr_62083_62146 = state_62010__$1;
(statearr_62083_62146[(2)] = inst_61991);

(statearr_62083_62146[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (37))){
var state_62010__$1 = state_62010;
var statearr_62084_62147 = state_62010__$1;
(statearr_62084_62147[(2)] = null);

(statearr_62084_62147[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62011 === (8))){
var inst_61867 = (state_62010[(24)]);
var state_62010__$1 = state_62010;
if(cljs.core.truth_(inst_61867)){
var statearr_62085_62148 = state_62010__$1;
(statearr_62085_62148[(1)] = (11));

} else {
var statearr_62086_62149 = state_62010__$1;
(statearr_62086_62149[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0 = (function (){
var statearr_62087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62087[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__);

(statearr_62087[(1)] = (1));

return statearr_62087;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1 = (function (state_62010){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62010);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62088){var ex__2417__auto__ = e62088;
var statearr_62089_62150 = state_62010;
(statearr_62089_62150[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62010[(4)]))){
var statearr_62090_62151 = state_62010;
(statearr_62090_62151[(1)] = cljs.core.first((state_62010[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62152 = state_62010;
state_62010 = G__62152;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__ = function(state_62010){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1.call(this,state_62010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2414__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62091 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62091[(6)] = c__2436__auto__);

return statearr_62091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62153 = query_type;
var G__62153__$1 = (((G__62153 instanceof cljs.core.Keyword))?G__62153.fqn:null);
switch (G__62153__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62153__$1)].join('')));

}
});
