// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto.secp256k1');
goog.require('fluree.crypto.sha3');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.account_id');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64093 = arguments.length;
var i__4737__auto___64094 = (0);
while(true){
if((i__4737__auto___64094 < len__4736__auto___64093)){
args__4742__auto__.push((arguments[i__4737__auto___64094]));

var G__64095 = (i__4737__auto___64094 + (1));
i__4737__auto___64094 = G__64095;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63992){
var vec__63993 = p__63992;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63993,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___64096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64057){
var state_val_64058 = (state_64057[(1)]);
if((state_val_64058 === (7))){
var state_64057__$1 = state_64057;
var statearr_64059_64097 = state_64057__$1;
(statearr_64059_64097[(2)] = false);

(statearr_64059_64097[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (1))){
var state_64057__$1 = state_64057;
var statearr_64060_64098 = state_64057__$1;
(statearr_64060_64098[(2)] = null);

(statearr_64060_64098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (4))){
var inst_63996 = (state_64057[(2)]);
var inst_63997 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63996], 0));
var inst_63998 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63996);
var inst_63999 = cljs.core.async.close_BANG_(pc);
var state_64057__$1 = (function (){var statearr_64061 = state_64057;
(statearr_64061[(7)] = inst_63998);

(statearr_64061[(8)] = inst_63997);

return statearr_64061;
})();
var statearr_64062_64099 = state_64057__$1;
(statearr_64062_64099[(2)] = inst_63999);

(statearr_64062_64099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (15))){
var inst_64037 = (state_64057[(9)]);
var inst_64038 = (state_64057[(10)]);
var inst_64034 = (state_64057[(11)]);
var inst_64041 = (state_64057[(2)]);
var inst_64042 = fluree.db.util.async.throw_err(inst_64041);
var inst_64043 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64042,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_64037,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_64038], 0));
var state_64057__$1 = (function (){var statearr_64063 = state_64057;
(statearr_64063[(12)] = inst_64043);

return statearr_64063;
})();
if(cljs.core.truth_(inst_64034)){
var statearr_64064_64100 = state_64057__$1;
(statearr_64064_64100[(1)] = (16));

} else {
var statearr_64065_64101 = state_64057__$1;
(statearr_64065_64101[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (13))){
var inst_64009 = (state_64057[(13)]);
var state_64057__$1 = state_64057;
var statearr_64066_64102 = state_64057__$1;
(statearr_64066_64102[(2)] = inst_64009);

(statearr_64066_64102[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (6))){
var inst_64009 = (state_64057[(13)]);
var inst_64014 = inst_64009.cljs$lang$protocol_mask$partition0$;
var inst_64015 = (inst_64014 & (64));
var inst_64016 = inst_64009.cljs$core$ISeq$;
var inst_64017 = (cljs.core.PROTOCOL_SENTINEL === inst_64016);
var inst_64018 = ((inst_64015) || (inst_64017));
var state_64057__$1 = state_64057;
if(cljs.core.truth_(inst_64018)){
var statearr_64067_64103 = state_64057__$1;
(statearr_64067_64103[(1)] = (9));

} else {
var statearr_64068_64104 = state_64057__$1;
(statearr_64068_64104[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (17))){
var inst_64043 = (state_64057[(12)]);
var state_64057__$1 = state_64057;
var statearr_64069_64105 = state_64057__$1;
(statearr_64069_64105[(2)] = inst_64043);

(statearr_64069_64105[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (3))){
var inst_64055 = (state_64057[(2)]);
var state_64057__$1 = state_64057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64057__$1,inst_64055);
} else {
if((state_val_64058 === (12))){
var inst_64009 = (state_64057[(13)]);
var inst_64027 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_64009);
var state_64057__$1 = state_64057;
var statearr_64070_64106 = state_64057__$1;
(statearr_64070_64106[(2)] = inst_64027);

(statearr_64070_64106[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (2))){
var inst_64009 = (state_64057[(13)]);
var _ = (function (){var statearr_64071 = state_64057;
(statearr_64071[(4)] = cljs.core.cons((5),(state_64057[(4)])));

return statearr_64071;
})();
var inst_64009__$1 = opts;
var inst_64011 = (inst_64009__$1 == null);
var inst_64012 = cljs.core.not(inst_64011);
var state_64057__$1 = (function (){var statearr_64072 = state_64057;
(statearr_64072[(13)] = inst_64009__$1);

return statearr_64072;
})();
if(inst_64012){
var statearr_64073_64107 = state_64057__$1;
(statearr_64073_64107[(1)] = (6));

} else {
var statearr_64074_64108 = state_64057__$1;
(statearr_64074_64108[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (19))){
var inst_64047 = (state_64057[(2)]);
var inst_64048 = fluree.db.util.async.throw_err(inst_64047);
var state_64057__$1 = state_64057;
var statearr_64075_64109 = state_64057__$1;
(statearr_64075_64109[(2)] = inst_64048);

(statearr_64075_64109[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (11))){
var inst_64022 = (state_64057[(2)]);
var state_64057__$1 = state_64057;
var statearr_64077_64110 = state_64057__$1;
(statearr_64077_64110[(2)] = inst_64022);

(statearr_64077_64110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (9))){
var state_64057__$1 = state_64057;
var statearr_64078_64111 = state_64057__$1;
(statearr_64078_64111[(2)] = true);

(statearr_64078_64111[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (5))){
var _ = (function (){var statearr_64079 = state_64057;
(statearr_64079[(4)] = cljs.core.rest((state_64057[(4)])));

return statearr_64079;
})();
var state_64057__$1 = state_64057;
var ex64076 = (state_64057__$1[(2)]);
var statearr_64080_64112 = state_64057__$1;
(statearr_64080_64112[(5)] = ex64076);


var statearr_64081_64113 = state_64057__$1;
(statearr_64081_64113[(1)] = (4));

(statearr_64081_64113[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (14))){
var inst_64030 = (state_64057[(2)]);
var inst_64031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64030,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_64032 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64030,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_64033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64030,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64030,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64035 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_64036 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_64037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64036,(0),null);
var inst_64038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64036,(1),null);
var inst_64039 = fluree.db.session.db(conn,ledger,opts);
var state_64057__$1 = (function (){var statearr_64082 = state_64057;
(statearr_64082[(14)] = inst_64035);

(statearr_64082[(15)] = inst_64033);

(statearr_64082[(9)] = inst_64037);

(statearr_64082[(16)] = inst_64032);

(statearr_64082[(10)] = inst_64038);

(statearr_64082[(17)] = inst_64031);

(statearr_64082[(11)] = inst_64034);

return statearr_64082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64057__$1,(15),inst_64039);
} else {
if((state_val_64058 === (16))){
var inst_64043 = (state_64057[(12)]);
var inst_64034 = (state_64057[(11)]);
var inst_64045 = fluree.db.time_travel.as_of_block(inst_64043,inst_64034);
var state_64057__$1 = state_64057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64057__$1,(19),inst_64045);
} else {
if((state_val_64058 === (10))){
var state_64057__$1 = state_64057;
var statearr_64083_64114 = state_64057__$1;
(statearr_64083_64114[(2)] = false);

(statearr_64083_64114[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (18))){
var inst_64051 = (state_64057[(2)]);
var inst_64052 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64051);
var _ = (function (){var statearr_64084 = state_64057;
(statearr_64084[(4)] = cljs.core.rest((state_64057[(4)])));

return statearr_64084;
})();
var state_64057__$1 = state_64057;
var statearr_64085_64115 = state_64057__$1;
(statearr_64085_64115[(2)] = inst_64052);

(statearr_64085_64115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64058 === (8))){
var inst_64025 = (state_64057[(2)]);
var state_64057__$1 = state_64057;
if(cljs.core.truth_(inst_64025)){
var statearr_64086_64116 = state_64057__$1;
(statearr_64086_64116[(1)] = (12));

} else {
var statearr_64087_64117 = state_64057__$1;
(statearr_64087_64117[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_64088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64088[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_64088[(1)] = (1));

return statearr_64088;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_64057){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64057);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64089){var ex__2417__auto__ = e64089;
var statearr_64090_64118 = state_64057;
(statearr_64090_64118[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64057[(4)]))){
var statearr_64091_64119 = state_64057;
(statearr_64091_64119[(1)] = cljs.core.first((state_64057[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64120 = state_64057;
state_64057 = G__64120;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_64057){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_64057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64092 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64092[(6)] = c__2436__auto___64096);

return statearr_64092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63989){
var G__63990 = cljs.core.first(seq63989);
var seq63989__$1 = cljs.core.next(seq63989);
var G__63991 = cljs.core.first(seq63989__$1);
var seq63989__$2 = cljs.core.next(seq63989__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63990,G__63991,seq63989__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?open_api:false))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64123 = arguments.length;
switch (G__64123) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64273){
var state_val_64274 = (state_64273[(1)]);
if((state_val_64274 === (7))){
var state_64273__$1 = state_64273;
var statearr_64275_64371 = state_64273__$1;
(statearr_64275_64371[(2)] = false);

(statearr_64275_64371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (59))){
var inst_64262 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64276_64372 = state_64273__$1;
(statearr_64276_64372[(2)] = inst_64262);

(statearr_64276_64372[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (20))){
var inst_64161 = (state_64273[(7)]);
var inst_64178 = (state_64273[(8)]);
var inst_64177 = (state_64273[(9)]);
var inst_64180 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64177);
var inst_64181 = fluree.db.connection_js.open_api_QMARK_(inst_64178);
var inst_64182 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64177);
var inst_64183 = fluree.db.api_js.get_sources(inst_64178,inst_64180,inst_64181,inst_64182,inst_64161,db_fn);
var state_64273__$1 = state_64273;
var statearr_64277_64373 = state_64273__$1;
(statearr_64277_64373[(2)] = inst_64183);

(statearr_64277_64373[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (58))){
var state_64273__$1 = state_64273;
var statearr_64278_64374 = state_64273__$1;
(statearr_64278_64374[(2)] = null);

(statearr_64278_64374[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (27))){
var inst_64163 = (state_64273[(10)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64163)){
var statearr_64279_64375 = state_64273__$1;
(statearr_64279_64375[(1)] = (29));

} else {
var statearr_64280_64376 = state_64273__$1;
(statearr_64280_64376[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (1))){
var state_64273__$1 = state_64273;
var statearr_64281_64377 = state_64273__$1;
(statearr_64281_64377[(2)] = null);

(statearr_64281_64377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (24))){
var state_64273__$1 = state_64273;
var statearr_64282_64378 = state_64273__$1;
(statearr_64282_64378[(2)] = (1000000));

(statearr_64282_64378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (55))){
var inst_64231 = (state_64273[(11)]);
var state_64273__$1 = state_64273;
var statearr_64283_64379 = state_64273__$1;
(statearr_64283_64379[(2)] = inst_64231);

(statearr_64283_64379[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (39))){
var inst_64212 = (state_64273[(12)]);
var state_64273__$1 = state_64273;
var statearr_64284_64380 = state_64273__$1;
(statearr_64284_64380[(2)] = inst_64212);

(statearr_64284_64380[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (46))){
var inst_64268 = (state_64273[(2)]);
var _ = (function (){var statearr_64285 = state_64273;
(statearr_64285[(4)] = cljs.core.rest((state_64273[(4)])));

return statearr_64285;
})();
var state_64273__$1 = state_64273;
var statearr_64286_64381 = state_64273__$1;
(statearr_64286_64381[(2)] = inst_64268);

(statearr_64286_64381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (4))){
var inst_64124 = (state_64273[(2)]);
var inst_64125 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64124], 0));
var inst_64126 = cljs.core.ex_data(inst_64124);
var inst_64127 = cljs.core.ex_message(inst_64124);
var inst_64128 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64126,new cljs.core.Keyword(null,"message","message",-406056002),inst_64127);
var state_64273__$1 = (function (){var statearr_64287 = state_64273;
(statearr_64287[(13)] = inst_64125);

return statearr_64287;
})();
var statearr_64288_64382 = state_64273__$1;
(statearr_64288_64382[(2)] = inst_64128);

(statearr_64288_64382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (54))){
var inst_64231 = (state_64273[(11)]);
var inst_64245 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64231);
var state_64273__$1 = state_64273;
var statearr_64289_64383 = state_64273__$1;
(statearr_64289_64383[(2)] = inst_64245);

(statearr_64289_64383[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (15))){
var inst_64159 = (state_64273[(14)]);
var inst_64168 = (state_64273[(2)]);
var inst_64169 = fluree.db.util.async.throw_err(inst_64168);
var state_64273__$1 = (function (){var statearr_64290 = state_64273;
(statearr_64290[(15)] = inst_64169);

return statearr_64290;
})();
if(cljs.core.truth_(inst_64159)){
var statearr_64291_64384 = state_64273__$1;
(statearr_64291_64384[(1)] = (16));

} else {
var statearr_64292_64385 = state_64273__$1;
(statearr_64292_64385[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (48))){
var inst_64231 = (state_64273[(11)]);
var inst_64234 = cljs.core.ex_data(inst_64231);
var inst_64235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64236 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64234);
var inst_64237 = cljs.core.ex_message(inst_64231);
var inst_64238 = [inst_64236,inst_64237,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64239 = cljs.core.PersistentHashMap.fromArrays(inst_64235,inst_64238);
var state_64273__$1 = state_64273;
var statearr_64293_64386 = state_64273__$1;
(statearr_64293_64386[(2)] = inst_64239);

(statearr_64293_64386[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (50))){
var inst_64266 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64294_64387 = state_64273__$1;
(statearr_64294_64387[(2)] = inst_64266);

(statearr_64294_64387[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (21))){
var inst_64185 = cljs.core.PersistentHashMap.EMPTY;
var state_64273__$1 = state_64273;
var statearr_64295_64388 = state_64273__$1;
(statearr_64295_64388[(2)] = inst_64185);

(statearr_64295_64388[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (31))){
var inst_64210 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64296_64389 = state_64273__$1;
(statearr_64296_64389[(2)] = inst_64210);

(statearr_64296_64389[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (32))){
var inst_64162 = (state_64273[(16)]);
var state_64273__$1 = state_64273;
var statearr_64297_64390 = state_64273__$1;
(statearr_64297_64390[(2)] = inst_64162);

(statearr_64297_64390[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (40))){
var inst_64220 = (state_64273[(17)]);
var inst_64220__$1 = (state_64273[(2)]);
var inst_64221 = cljs.core.not(inst_64220__$1);
var state_64273__$1 = (function (){var statearr_64298 = state_64273;
(statearr_64298[(17)] = inst_64220__$1);

return statearr_64298;
})();
if(inst_64221){
var statearr_64299_64391 = state_64273__$1;
(statearr_64299_64391[(1)] = (44));

} else {
var statearr_64300_64392 = state_64273__$1;
(statearr_64300_64392[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (56))){
var inst_64160 = (state_64273[(18)]);
var inst_64161 = (state_64273[(7)]);
var inst_64195 = (state_64273[(19)]);
var inst_64158 = (state_64273[(20)]);
var inst_64169 = (state_64273[(15)]);
var inst_64187 = (state_64273[(21)]);
var inst_64178 = (state_64273[(8)]);
var inst_64188 = (state_64273[(22)]);
var inst_64231 = (state_64273[(11)]);
var inst_64242 = (state_64273[(23)]);
var inst_64177 = (state_64273[(9)]);
var inst_64166 = (state_64273[(24)]);
var inst_64157 = (state_64273[(25)]);
var inst_64159 = (state_64273[(14)]);
var inst_64194 = (state_64273[(26)]);
var inst_64220 = (state_64273[(17)]);
var inst_64163 = (state_64273[(10)]);
var inst_64193 = (state_64273[(27)]);
var inst_64196 = (state_64273[(28)]);
var inst_64232 = (state_64273[(29)]);
var inst_64156 = (state_64273[(30)]);
var inst_64162 = (state_64273[(16)]);
var inst_64164 = (state_64273[(31)]);
var inst_64248 = (state_64273[(2)]);
var inst_64249 = cljs.core.deref(inst_64188);
var inst_64250 = (function (){var error_QMARK_ = inst_64232;
var map__64134 = inst_64156;
var construct = inst_64157;
var valid_query_QMARK_ = inst_64220;
var conn = inst_64178;
var select = inst_64158;
var block = inst_64159;
var where = inst_64160;
var prefixes = inst_64161;
var db = inst_64169;
var meta_QMARK_ = inst_64194;
var source_opts = inst_64187;
var fuel = inst_64188;
var db_STAR_ = inst_64177;
var selectDistinct = inst_64162;
var result = inst_64231;
var start_ms = inst_64195;
var selectOne = inst_64163;
var from = inst_64164;
var max_fuel = inst_64193;
var opts = inst_64196;
var selectReduced = inst_64166;
return (function (p1__64121_SHARP_){
var G__64301 = "%.2fms";
var G__64302 = p1__64121_SHARP_;
return goog.string.format(G__64301,G__64302);
});
})();
var inst_64251 = fluree.db.util.core.current_time_millis();
var inst_64252 = (inst_64251 - inst_64195);
var inst_64253 = (inst_64252 / (1000000));
var inst_64254 = (inst_64250.cljs$core$IFn$_invoke$arity$1 ? inst_64250.cljs$core$IFn$_invoke$arity$1(inst_64253) : inst_64250.call(null,inst_64253));
var inst_64255 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64177);
var inst_64256 = [(200),inst_64248,inst_64249,inst_64254,inst_64255];
var inst_64257 = cljs.core.PersistentHashMap.fromArrays(inst_64242,inst_64256);
var state_64273__$1 = state_64273;
var statearr_64303_64393 = state_64273__$1;
(statearr_64303_64393[(2)] = inst_64257);

(statearr_64303_64393[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (33))){
var inst_64166 = (state_64273[(24)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64166)){
var statearr_64304_64394 = state_64273__$1;
(statearr_64304_64394[(1)] = (35));

} else {
var statearr_64305_64395 = state_64273__$1;
(statearr_64305_64395[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (13))){
var inst_64135 = (state_64273[(32)]);
var state_64273__$1 = state_64273;
var statearr_64306_64396 = state_64273__$1;
(statearr_64306_64396[(2)] = inst_64135);

(statearr_64306_64396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (22))){
var inst_64165 = (state_64273[(33)]);
var inst_64189 = (state_64273[(34)]);
var inst_64187 = (state_64273[(2)]);
var inst_64188 = cljs.core.volatile_BANG_((0));
var inst_64189__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64165);
var state_64273__$1 = (function (){var statearr_64307 = state_64273;
(statearr_64307[(21)] = inst_64187);

(statearr_64307[(34)] = inst_64189__$1);

(statearr_64307[(22)] = inst_64188);

return statearr_64307;
})();
if(cljs.core.truth_(inst_64189__$1)){
var statearr_64308_64397 = state_64273__$1;
(statearr_64308_64397[(1)] = (23));

} else {
var statearr_64309_64398 = state_64273__$1;
(statearr_64309_64398[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (36))){
var inst_64157 = (state_64273[(25)]);
var state_64273__$1 = state_64273;
var statearr_64310_64399 = state_64273__$1;
(statearr_64310_64399[(2)] = inst_64157);

(statearr_64310_64399[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (41))){
var inst_64164 = (state_64273[(31)]);
var state_64273__$1 = state_64273;
var statearr_64311_64400 = state_64273__$1;
(statearr_64311_64400[(2)] = inst_64164);

(statearr_64311_64400[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (43))){
var inst_64217 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64312_64401 = state_64273__$1;
(statearr_64312_64401[(2)] = inst_64217);

(statearr_64312_64401[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (29))){
var inst_64163 = (state_64273[(10)]);
var state_64273__$1 = state_64273;
var statearr_64313_64402 = state_64273__$1;
(statearr_64313_64402[(2)] = inst_64163);

(statearr_64313_64402[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (44))){
var inst_64223 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64224 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64225 = cljs.core.PersistentHashMap.fromArrays(inst_64223,inst_64224);
var state_64273__$1 = state_64273;
var statearr_64314_64403 = state_64273__$1;
(statearr_64314_64403[(2)] = inst_64225);

(statearr_64314_64403[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (6))){
var inst_64135 = (state_64273[(32)]);
var inst_64140 = inst_64135.cljs$lang$protocol_mask$partition0$;
var inst_64141 = (inst_64140 & (64));
var inst_64142 = inst_64135.cljs$core$ISeq$;
var inst_64143 = (cljs.core.PROTOCOL_SENTINEL === inst_64142);
var inst_64144 = ((inst_64141) || (inst_64143));
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64144)){
var statearr_64315_64404 = state_64273__$1;
(statearr_64315_64404[(1)] = (9));

} else {
var statearr_64316_64405 = state_64273__$1;
(statearr_64316_64405[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (28))){
var inst_64212 = (state_64273[(12)]);
var inst_64212__$1 = (state_64273[(2)]);
var state_64273__$1 = (function (){var statearr_64317 = state_64273;
(statearr_64317[(12)] = inst_64212__$1);

return statearr_64317;
})();
if(cljs.core.truth_(inst_64212__$1)){
var statearr_64318_64406 = state_64273__$1;
(statearr_64318_64406[(1)] = (38));

} else {
var statearr_64319_64407 = state_64273__$1;
(statearr_64319_64407[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (51))){
var inst_64231 = (state_64273[(11)]);
var inst_64242 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64243 = cljs.core.sequential_QMARK_(inst_64231);
var state_64273__$1 = (function (){var statearr_64320 = state_64273;
(statearr_64320[(23)] = inst_64242);

return statearr_64320;
})();
if(inst_64243){
var statearr_64321_64408 = state_64273__$1;
(statearr_64321_64408[(1)] = (54));

} else {
var statearr_64322_64409 = state_64273__$1;
(statearr_64322_64409[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (25))){
var inst_64165 = (state_64273[(33)]);
var inst_64158 = (state_64273[(20)]);
var inst_64187 = (state_64273[(21)]);
var inst_64188 = (state_64273[(22)]);
var inst_64193 = (state_64273[(27)]);
var inst_64193__$1 = (state_64273[(2)]);
var inst_64194 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64165);
var inst_64195 = fluree.db.util.core.current_time_millis();
var inst_64196 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64165,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64187,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64193__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64188], 0));
var state_64273__$1 = (function (){var statearr_64323 = state_64273;
(statearr_64323[(19)] = inst_64195);

(statearr_64323[(26)] = inst_64194);

(statearr_64323[(27)] = inst_64193__$1);

(statearr_64323[(28)] = inst_64196);

return statearr_64323;
})();
if(cljs.core.truth_(inst_64158)){
var statearr_64324_64410 = state_64273__$1;
(statearr_64324_64410[(1)] = (26));

} else {
var statearr_64325_64411 = state_64273__$1;
(statearr_64325_64411[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (34))){
var inst_64208 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64326_64412 = state_64273__$1;
(statearr_64326_64412[(2)] = inst_64208);

(statearr_64326_64412[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (17))){
var inst_64169 = (state_64273[(15)]);
var state_64273__$1 = state_64273;
var statearr_64327_64413 = state_64273__$1;
(statearr_64327_64413[(2)] = inst_64169);

(statearr_64327_64413[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (3))){
var inst_64271 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64273__$1,inst_64271);
} else {
if((state_val_64274 === (12))){
var inst_64135 = (state_64273[(32)]);
var inst_64153 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_64135);
var state_64273__$1 = state_64273;
var statearr_64328_64414 = state_64273__$1;
(statearr_64328_64414[(2)] = inst_64153);

(statearr_64328_64414[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (2))){
var inst_64135 = (state_64273[(32)]);
var _ = (function (){var statearr_64329 = state_64273;
(statearr_64329[(4)] = cljs.core.cons((5),(state_64273[(4)])));

return statearr_64329;
})();
var inst_64135__$1 = query_map;
var inst_64137 = (inst_64135__$1 == null);
var inst_64138 = cljs.core.not(inst_64137);
var state_64273__$1 = (function (){var statearr_64330 = state_64273;
(statearr_64330[(32)] = inst_64135__$1);

return statearr_64330;
})();
if(inst_64138){
var statearr_64331_64415 = state_64273__$1;
(statearr_64331_64415[(1)] = (6));

} else {
var statearr_64332_64416 = state_64273__$1;
(statearr_64332_64416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (23))){
var inst_64189 = (state_64273[(34)]);
var state_64273__$1 = state_64273;
var statearr_64333_64417 = state_64273__$1;
(statearr_64333_64417[(2)] = inst_64189);

(statearr_64333_64417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (47))){
var inst_64231 = (state_64273[(11)]);
var inst_64232 = (state_64273[(29)]);
var inst_64230 = (state_64273[(2)]);
var inst_64231__$1 = fluree.db.util.async.throw_err(inst_64230);
var inst_64232__$1 = (inst_64231__$1 instanceof cljs.core.ExceptionInfo);
var state_64273__$1 = (function (){var statearr_64334 = state_64273;
(statearr_64334[(11)] = inst_64231__$1);

(statearr_64334[(29)] = inst_64232__$1);

return statearr_64334;
})();
if(cljs.core.truth_(inst_64232__$1)){
var statearr_64335_64418 = state_64273__$1;
(statearr_64335_64418[(1)] = (48));

} else {
var statearr_64336_64419 = state_64273__$1;
(statearr_64336_64419[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (35))){
var inst_64166 = (state_64273[(24)]);
var state_64273__$1 = state_64273;
var statearr_64337_64420 = state_64273__$1;
(statearr_64337_64420[(2)] = inst_64166);

(statearr_64337_64420[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (19))){
var inst_64173 = (state_64273[(2)]);
var inst_64174 = fluree.db.util.async.throw_err(inst_64173);
var state_64273__$1 = state_64273;
var statearr_64338_64421 = state_64273__$1;
(statearr_64338_64421[(2)] = inst_64174);

(statearr_64338_64421[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (57))){
var inst_64231 = (state_64273[(11)]);
var state_64273__$1 = state_64273;
var statearr_64339_64422 = state_64273__$1;
(statearr_64339_64422[(2)] = inst_64231);

(statearr_64339_64422[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (11))){
var inst_64148 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64341_64423 = state_64273__$1;
(statearr_64341_64423[(2)] = inst_64148);

(statearr_64341_64423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (9))){
var state_64273__$1 = state_64273;
var statearr_64342_64424 = state_64273__$1;
(statearr_64342_64424[(2)] = true);

(statearr_64342_64424[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (5))){
var _ = (function (){var statearr_64343 = state_64273;
(statearr_64343[(4)] = cljs.core.rest((state_64273[(4)])));

return statearr_64343;
})();
var state_64273__$1 = state_64273;
var ex64340 = (state_64273__$1[(2)]);
var statearr_64344_64425 = state_64273__$1;
(statearr_64344_64425[(5)] = ex64340);


var statearr_64345_64426 = state_64273__$1;
(statearr_64345_64426[(1)] = (4));

(statearr_64345_64426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (14))){
var inst_64156 = (state_64273[(30)]);
var inst_64156__$1 = (state_64273[(2)]);
var inst_64157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64159 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64160 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64156__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64273__$1 = (function (){var statearr_64346 = state_64273;
(statearr_64346[(18)] = inst_64160);

(statearr_64346[(7)] = inst_64161);

(statearr_64346[(33)] = inst_64165);

(statearr_64346[(20)] = inst_64158);

(statearr_64346[(24)] = inst_64166);

(statearr_64346[(25)] = inst_64157);

(statearr_64346[(14)] = inst_64159);

(statearr_64346[(10)] = inst_64163);

(statearr_64346[(30)] = inst_64156__$1);

(statearr_64346[(16)] = inst_64162);

(statearr_64346[(31)] = inst_64164);

return statearr_64346;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64273__$1,(15),sources);
} else {
if((state_val_64274 === (45))){
var inst_64177 = (state_64273[(9)]);
var inst_64196 = (state_64273[(28)]);
var inst_64227 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64196);
var inst_64228 = fluree.db.query.fql.query(inst_64177,inst_64227);
var state_64273__$1 = state_64273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64273__$1,(47),inst_64228);
} else {
if((state_val_64274 === (53))){
var inst_64264 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64347_64427 = state_64273__$1;
(statearr_64347_64427[(2)] = inst_64264);

(statearr_64347_64427[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (26))){
var inst_64158 = (state_64273[(20)]);
var state_64273__$1 = state_64273;
var statearr_64348_64428 = state_64273__$1;
(statearr_64348_64428[(2)] = inst_64158);

(statearr_64348_64428[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (16))){
var inst_64169 = (state_64273[(15)]);
var inst_64159 = (state_64273[(14)]);
var inst_64171 = fluree.db.time_travel.as_of_block(inst_64169,inst_64159);
var state_64273__$1 = state_64273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64273__$1,(19),inst_64171);
} else {
if((state_val_64274 === (38))){
var inst_64164 = (state_64273[(31)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64164)){
var statearr_64349_64429 = state_64273__$1;
(statearr_64349_64429[(1)] = (41));

} else {
var statearr_64350_64430 = state_64273__$1;
(statearr_64350_64430[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (30))){
var inst_64162 = (state_64273[(16)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64162)){
var statearr_64351_64431 = state_64273__$1;
(statearr_64351_64431[(1)] = (32));

} else {
var statearr_64352_64432 = state_64273__$1;
(statearr_64352_64432[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (10))){
var state_64273__$1 = state_64273;
var statearr_64353_64433 = state_64273__$1;
(statearr_64353_64433[(2)] = false);

(statearr_64353_64433[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (18))){
var inst_64161 = (state_64273[(7)]);
var inst_64177 = (state_64273[(9)]);
var inst_64177__$1 = (state_64273[(2)]);
var inst_64178 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64177__$1);
var state_64273__$1 = (function (){var statearr_64354 = state_64273;
(statearr_64354[(8)] = inst_64178);

(statearr_64354[(9)] = inst_64177__$1);

return statearr_64354;
})();
if(cljs.core.truth_(inst_64161)){
var statearr_64355_64434 = state_64273__$1;
(statearr_64355_64434[(1)] = (20));

} else {
var statearr_64356_64435 = state_64273__$1;
(statearr_64356_64435[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (52))){
var state_64273__$1 = state_64273;
var statearr_64357_64436 = state_64273__$1;
(statearr_64357_64436[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (42))){
var inst_64160 = (state_64273[(18)]);
var state_64273__$1 = state_64273;
var statearr_64359_64437 = state_64273__$1;
(statearr_64359_64437[(2)] = inst_64160);

(statearr_64359_64437[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (37))){
var inst_64206 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
var statearr_64360_64438 = state_64273__$1;
(statearr_64360_64438[(2)] = inst_64206);

(statearr_64360_64438[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (8))){
var inst_64151 = (state_64273[(2)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64151)){
var statearr_64361_64439 = state_64273__$1;
(statearr_64361_64439[(1)] = (12));

} else {
var statearr_64362_64440 = state_64273__$1;
(statearr_64362_64440[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64274 === (49))){
var inst_64194 = (state_64273[(26)]);
var state_64273__$1 = state_64273;
if(cljs.core.truth_(inst_64194)){
var statearr_64363_64441 = state_64273__$1;
(statearr_64363_64441[(1)] = (51));

} else {
var statearr_64364_64442 = state_64273__$1;
(statearr_64364_64442[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_64365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64365[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_64365[(1)] = (1));

return statearr_64365;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_64273){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64273);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64366){var ex__2417__auto__ = e64366;
var statearr_64367_64443 = state_64273;
(statearr_64367_64443[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64273[(4)]))){
var statearr_64368_64444 = state_64273;
(statearr_64368_64444[(1)] = cljs.core.first((state_64273[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64445 = state_64273;
state_64273 = G__64445;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_64273){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_64273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64369 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64369[(6)] = c__2436__auto__);

return statearr_64369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__64446_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__64446_SHARP_);
}));

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64468){
var state_val_64469 = (state_64468[(1)]);
if((state_val_64469 === (1))){
var inst_64450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64451 = [resp_chan,timeout_chan];
var inst_64452 = (new cljs.core.PersistentVector(null,2,(5),inst_64450,inst_64451,null));
var state_64468__$1 = state_64468;
return cljs.core.async.ioc_alts_BANG_(state_64468__$1,(2),inst_64452);
} else {
if((state_val_64469 === (2))){
var inst_64454 = (state_64468[(2)]);
var inst_64455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64454,(0),null);
var inst_64456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64454,(1),null);
var inst_64457 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_64456);
var state_64468__$1 = (function (){var statearr_64470 = state_64468;
(statearr_64470[(7)] = inst_64455);

return statearr_64470;
})();
if(inst_64457){
var statearr_64471_64481 = state_64468__$1;
(statearr_64471_64481[(1)] = (3));

} else {
var statearr_64472_64482 = state_64468__$1;
(statearr_64472_64482[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (3))){
var inst_64459 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_64460 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64461 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_64462 = [tid,(408),inst_64461];
var inst_64463 = cljs.core.PersistentHashMap.fromArrays(inst_64460,inst_64462);
var state_64468__$1 = (function (){var statearr_64473 = state_64468;
(statearr_64473[(8)] = inst_64459);

return statearr_64473;
})();
var statearr_64474_64483 = state_64468__$1;
(statearr_64474_64483[(2)] = inst_64463);

(statearr_64474_64483[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (4))){
var inst_64455 = (state_64468[(7)]);
var state_64468__$1 = state_64468;
var statearr_64475_64484 = state_64468__$1;
(statearr_64475_64484[(2)] = inst_64455);

(statearr_64475_64484[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (5))){
var inst_64466 = (state_64468[(2)]);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64468__$1,inst_64466);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____0 = (function (){
var statearr_64476 = [null,null,null,null,null,null,null,null,null];
(statearr_64476[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__);

(statearr_64476[(1)] = (1));

return statearr_64476;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____1 = (function (state_64468){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64468);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64477){var ex__2417__auto__ = e64477;
var statearr_64478_64485 = state_64468;
(statearr_64478_64485[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64468[(4)]))){
var statearr_64479_64486 = state_64468;
(statearr_64479_64486[(1)] = cljs.core.first((state_64468[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64487 = state_64468;
state_64468 = G__64487;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__ = function(state_64468){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____1.call(this,state_64468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2414__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64480 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64480[(6)] = c__2436__auto__);

return statearr_64480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__64489 = arguments.length;
switch (G__64489) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64490 = opts;
var map__64490__$1 = (((((!((map__64490 == null))))?(((((map__64490.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64490.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64490):map__64490);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64490__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64490__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64490__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64490__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.db.util.account_id.from_private_key.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.account_id.from_private_key.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.db.util.account_id.from_private_key.call(null,private_key));
var vec__64491 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64491,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64491,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e64495){var e = e64495;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.secp256k1.sign_message(cmd,private_key);
var id = fluree.crypto.sha3.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__64498 = arguments.length;
switch (G__64498) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64584){
var state_val_64585 = (state_64584[(1)]);
if((state_val_64585 === (7))){
var state_64584__$1 = state_64584;
var statearr_64586_64635 = state_64584__$1;
(statearr_64586_64635[(2)] = false);

(statearr_64586_64635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (20))){
var inst_64551 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
var statearr_64587_64636 = state_64584__$1;
(statearr_64587_64636[(2)] = inst_64551);

(statearr_64587_64636[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (27))){
var inst_64564 = (state_64584[(7)]);
var inst_64567 = cljs.core.ex_data(inst_64564);
var inst_64568 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64569 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64567);
var inst_64570 = cljs.core.ex_message(inst_64564);
var inst_64571 = [inst_64569,inst_64570,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_64572 = cljs.core.PersistentHashMap.fromArrays(inst_64568,inst_64571);
var state_64584__$1 = state_64584;
var statearr_64588_64637 = state_64584__$1;
(statearr_64588_64637[(2)] = inst_64572);

(statearr_64588_64637[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (1))){
var state_64584__$1 = state_64584;
var statearr_64589_64638 = state_64584__$1;
(statearr_64589_64638[(2)] = null);

(statearr_64589_64638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (24))){
var inst_64559 = (state_64584[(8)]);
var inst_64534 = (state_64584[(9)]);
var inst_64562 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64559,inst_64534);
var state_64584__$1 = state_64584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64584__$1,(26),inst_64562);
} else {
if((state_val_64585 === (4))){
var inst_64499 = (state_64584[(2)]);
var inst_64500 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64499], 0));
var inst_64501 = cljs.core.ex_data(inst_64499);
var inst_64502 = cljs.core.ex_message(inst_64499);
var inst_64503 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64501,new cljs.core.Keyword(null,"message","message",-406056002),inst_64502);
var state_64584__$1 = (function (){var statearr_64590 = state_64584;
(statearr_64590[(10)] = inst_64500);

return statearr_64590;
})();
var statearr_64591_64639 = state_64584__$1;
(statearr_64591_64639[(2)] = inst_64503);

(statearr_64591_64639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (15))){
var inst_64532 = (state_64584[(11)]);
var inst_64533 = (state_64584[(12)]);
var inst_64542 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_64532,opts);
var inst_64543 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_64542);
var inst_64544 = fluree.db.operations.command_async(conn,inst_64542);
var state_64584__$1 = (function (){var statearr_64592 = state_64584;
(statearr_64592[(13)] = inst_64544);

(statearr_64592[(14)] = inst_64543);

return statearr_64592;
})();
if(cljs.core.truth_(inst_64533)){
var statearr_64593_64640 = state_64584__$1;
(statearr_64593_64640[(1)] = (18));

} else {
var statearr_64594_64641 = state_64584__$1;
(statearr_64594_64641[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (21))){
var inst_64549 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
var statearr_64595_64642 = state_64584__$1;
(statearr_64595_64642[(2)] = inst_64549);

(statearr_64595_64642[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (13))){
var inst_64510 = (state_64584[(15)]);
var state_64584__$1 = state_64584;
var statearr_64596_64643 = state_64584__$1;
(statearr_64596_64643[(2)] = inst_64510);

(statearr_64596_64643[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (22))){
var inst_64533 = (state_64584[(12)]);
var inst_64559 = (state_64584[(2)]);
var state_64584__$1 = (function (){var statearr_64597 = state_64584;
(statearr_64597[(8)] = inst_64559);

return statearr_64597;
})();
if(cljs.core.truth_(inst_64533)){
var statearr_64598_64644 = state_64584__$1;
(statearr_64598_64644[(1)] = (23));

} else {
var statearr_64599_64645 = state_64584__$1;
(statearr_64599_64645[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (29))){
var inst_64575 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
var statearr_64600_64646 = state_64584__$1;
(statearr_64600_64646[(2)] = inst_64575);

(statearr_64600_64646[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (6))){
var inst_64510 = (state_64584[(15)]);
var inst_64515 = inst_64510.cljs$lang$protocol_mask$partition0$;
var inst_64516 = (inst_64515 & (64));
var inst_64517 = inst_64510.cljs$core$ISeq$;
var inst_64518 = (cljs.core.PROTOCOL_SENTINEL === inst_64517);
var inst_64519 = ((inst_64516) || (inst_64518));
var state_64584__$1 = state_64584;
if(cljs.core.truth_(inst_64519)){
var statearr_64601_64647 = state_64584__$1;
(statearr_64601_64647[(1)] = (9));

} else {
var statearr_64602_64648 = state_64584__$1;
(statearr_64602_64648[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (28))){
var inst_64564 = (state_64584[(7)]);
var state_64584__$1 = state_64584;
var statearr_64603_64649 = state_64584__$1;
(statearr_64603_64649[(2)] = inst_64564);

(statearr_64603_64649[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (25))){
var inst_64577 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
var statearr_64604_64650 = state_64584__$1;
(statearr_64604_64650[(2)] = inst_64577);

(statearr_64604_64650[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (17))){
var inst_64579 = (state_64584[(2)]);
var _ = (function (){var statearr_64605 = state_64584;
(statearr_64605[(4)] = cljs.core.rest((state_64584[(4)])));

return statearr_64605;
})();
var state_64584__$1 = state_64584;
var statearr_64606_64651 = state_64584__$1;
(statearr_64606_64651[(2)] = inst_64579);

(statearr_64606_64651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (3))){
var inst_64582 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64584__$1,inst_64582);
} else {
if((state_val_64585 === (12))){
var inst_64510 = (state_64584[(15)]);
var inst_64528 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_64510);
var state_64584__$1 = state_64584;
var statearr_64607_64652 = state_64584__$1;
(statearr_64607_64652[(2)] = inst_64528);

(statearr_64607_64652[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (2))){
var inst_64510 = (state_64584[(15)]);
var _ = (function (){var statearr_64608 = state_64584;
(statearr_64608[(4)] = cljs.core.cons((5),(state_64584[(4)])));

return statearr_64608;
})();
var inst_64510__$1 = opts;
var inst_64512 = (inst_64510__$1 == null);
var inst_64513 = cljs.core.not(inst_64512);
var state_64584__$1 = (function (){var statearr_64609 = state_64584;
(statearr_64609[(15)] = inst_64510__$1);

return statearr_64609;
})();
if(inst_64513){
var statearr_64610_64653 = state_64584__$1;
(statearr_64610_64653[(1)] = (6));

} else {
var statearr_64611_64654 = state_64584__$1;
(statearr_64611_64654[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (23))){
var inst_64559 = (state_64584[(8)]);
var state_64584__$1 = state_64584;
var statearr_64612_64655 = state_64584__$1;
(statearr_64612_64655[(2)] = inst_64559);

(statearr_64612_64655[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (19))){
var inst_64534 = (state_64584[(9)]);
var inst_64543 = (state_64584[(14)]);
var inst_64547 = fluree.db.api_js.monitor_tx(conn,ledger,inst_64543,inst_64534);
var state_64584__$1 = state_64584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64584__$1,(21),inst_64547);
} else {
if((state_val_64585 === (11))){
var inst_64523 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
var statearr_64614_64656 = state_64584__$1;
(statearr_64614_64656[(2)] = inst_64523);

(statearr_64614_64656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (9))){
var state_64584__$1 = state_64584;
var statearr_64615_64657 = state_64584__$1;
(statearr_64615_64657[(2)] = true);

(statearr_64615_64657[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (5))){
var _ = (function (){var statearr_64616 = state_64584;
(statearr_64616[(4)] = cljs.core.rest((state_64584[(4)])));

return statearr_64616;
})();
var state_64584__$1 = state_64584;
var ex64613 = (state_64584__$1[(2)]);
var statearr_64617_64658 = state_64584__$1;
(statearr_64617_64658[(5)] = ex64613);


var statearr_64618_64659 = state_64584__$1;
(statearr_64618_64659[(1)] = (4));

(statearr_64618_64659[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (14))){
var inst_64532 = (state_64584[(11)]);
var inst_64531 = (state_64584[(2)]);
var inst_64532__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_64533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_64534 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64531,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_64535 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64536 = fluree.db.util.core.current_time_millis();
var inst_64537 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64531,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_64536);
var inst_64538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_64539 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_64540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64531,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_64584__$1 = (function (){var statearr_64619 = state_64584;
(statearr_64619[(16)] = inst_64540);

(statearr_64619[(9)] = inst_64534);

(statearr_64619[(17)] = inst_64538);

(statearr_64619[(11)] = inst_64532__$1);

(statearr_64619[(18)] = inst_64539);

(statearr_64619[(19)] = inst_64535);

(statearr_64619[(20)] = inst_64537);

(statearr_64619[(12)] = inst_64533);

return statearr_64619;
})();
if(cljs.core.truth_(inst_64532__$1)){
var statearr_64620_64660 = state_64584__$1;
(statearr_64620_64660[(1)] = (15));

} else {
var statearr_64621_64661 = state_64584__$1;
(statearr_64621_64661[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (26))){
var inst_64564 = (state_64584[(7)]);
var inst_64564__$1 = (state_64584[(2)]);
var inst_64565 = (inst_64564__$1 instanceof cljs.core.ExceptionInfo);
var state_64584__$1 = (function (){var statearr_64622 = state_64584;
(statearr_64622[(7)] = inst_64564__$1);

return statearr_64622;
})();
if(cljs.core.truth_(inst_64565)){
var statearr_64623_64662 = state_64584__$1;
(statearr_64623_64662[(1)] = (27));

} else {
var statearr_64624_64663 = state_64584__$1;
(statearr_64624_64663[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (16))){
var inst_64540 = (state_64584[(16)]);
var inst_64538 = (state_64584[(17)]);
var inst_64539 = (state_64584[(18)]);
var inst_64535 = (state_64584[(19)]);
var inst_64537 = (state_64584[(20)]);
var inst_64553 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_64554 = [ledger,txn,inst_64535,inst_64537,inst_64538,inst_64539,inst_64540];
var inst_64555 = cljs.core.PersistentHashMap.fromArrays(inst_64553,inst_64554);
var inst_64556 = fluree.db.util.core.without_nils(inst_64555);
var inst_64557 = fluree.db.operations.transact_async(conn,inst_64556);
var state_64584__$1 = state_64584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64584__$1,(22),inst_64557);
} else {
if((state_val_64585 === (10))){
var state_64584__$1 = state_64584;
var statearr_64625_64664 = state_64584__$1;
(statearr_64625_64664[(2)] = false);

(statearr_64625_64664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (18))){
var inst_64544 = (state_64584[(13)]);
var state_64584__$1 = state_64584;
var statearr_64626_64665 = state_64584__$1;
(statearr_64626_64665[(2)] = inst_64544);

(statearr_64626_64665[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64585 === (8))){
var inst_64526 = (state_64584[(2)]);
var state_64584__$1 = state_64584;
if(cljs.core.truth_(inst_64526)){
var statearr_64627_64666 = state_64584__$1;
(statearr_64627_64666[(1)] = (12));

} else {
var statearr_64628_64667 = state_64584__$1;
(statearr_64628_64667[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_64629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64629[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_64629[(1)] = (1));

return statearr_64629;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_64584){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64584);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64630){var ex__2417__auto__ = e64630;
var statearr_64631_64668 = state_64584;
(statearr_64631_64668[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64584[(4)]))){
var statearr_64632_64669 = state_64584;
(statearr_64632_64669[(1)] = cljs.core.first((state_64584[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64670 = state_64584;
state_64584 = G__64670;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_64584){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_64584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64633 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64633[(6)] = c__2436__auto__);

return statearr_64633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64672 = arguments.length;
var i__4737__auto___64673 = (0);
while(true){
if((i__4737__auto___64673 < len__4736__auto___64672)){
args__4742__auto__.push((arguments[i__4737__auto___64673]));

var G__64674 = (i__4737__auto___64673 + (1));
i__4737__auto___64673 = G__64674;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq64671){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq64671));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64705){
var state_val_64706 = (state_64705[(1)]);
if((state_val_64706 === (1))){
var inst_64675 = cljs.core.first(flakes);
var inst_64676 = cljs.core.rest(flakes);
var inst_64677 = cljs.core.PersistentVector.EMPTY;
var inst_64678 = inst_64675;
var inst_64679 = inst_64676;
var inst_64680 = inst_64677;
var state_64705__$1 = (function (){var statearr_64707 = state_64705;
(statearr_64707[(7)] = inst_64679);

(statearr_64707[(8)] = inst_64680);

(statearr_64707[(9)] = inst_64678);

return statearr_64707;
})();
var statearr_64708_64721 = state_64705__$1;
(statearr_64708_64721[(2)] = null);

(statearr_64708_64721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64706 === (2))){
var inst_64678 = (state_64705[(9)]);
var inst_64682 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_64683 = cljs.core.PersistentHashMap.EMPTY;
var inst_64684 = [true,inst_64683];
var inst_64685 = cljs.core.PersistentHashMap.fromArrays(inst_64682,inst_64684);
var inst_64686 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_64685,inst_64678);
var state_64705__$1 = state_64705;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64705__$1,(4),inst_64686);
} else {
if((state_val_64706 === (3))){
var inst_64703 = (state_64705[(2)]);
var state_64705__$1 = state_64705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64705__$1,inst_64703);
} else {
if((state_val_64706 === (4))){
var inst_64679 = (state_64705[(7)]);
var inst_64680 = (state_64705[(8)]);
var inst_64688 = (state_64705[(2)]);
var inst_64689 = fluree.db.util.async.throw_err(inst_64688);
var inst_64690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64691 = [inst_64689];
var inst_64692 = (new cljs.core.PersistentVector(null,1,(5),inst_64690,inst_64691,null));
var inst_64693 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64680,inst_64692);
var inst_64694 = cljs.core.first(inst_64679);
var state_64705__$1 = (function (){var statearr_64709 = state_64705;
(statearr_64709[(10)] = inst_64693);

return statearr_64709;
})();
if(cljs.core.truth_(inst_64694)){
var statearr_64710_64722 = state_64705__$1;
(statearr_64710_64722[(1)] = (5));

} else {
var statearr_64711_64723 = state_64705__$1;
(statearr_64711_64723[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64706 === (5))){
var inst_64679 = (state_64705[(7)]);
var inst_64693 = (state_64705[(10)]);
var inst_64696 = cljs.core.first(inst_64679);
var inst_64697 = cljs.core.rest(inst_64679);
var inst_64678 = inst_64696;
var inst_64679__$1 = inst_64697;
var inst_64680 = inst_64693;
var state_64705__$1 = (function (){var statearr_64712 = state_64705;
(statearr_64712[(7)] = inst_64679__$1);

(statearr_64712[(8)] = inst_64680);

(statearr_64712[(9)] = inst_64678);

return statearr_64712;
})();
var statearr_64713_64724 = state_64705__$1;
(statearr_64713_64724[(2)] = null);

(statearr_64713_64724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64706 === (6))){
var inst_64693 = (state_64705[(10)]);
var state_64705__$1 = state_64705;
var statearr_64714_64725 = state_64705__$1;
(statearr_64714_64725[(2)] = inst_64693);

(statearr_64714_64725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64706 === (7))){
var inst_64701 = (state_64705[(2)]);
var state_64705__$1 = state_64705;
var statearr_64715_64726 = state_64705__$1;
(statearr_64715_64726[(2)] = inst_64701);

(statearr_64715_64726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_64716 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64716[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__);

(statearr_64716[(1)] = (1));

return statearr_64716;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____1 = (function (state_64705){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64705);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64717){var ex__2417__auto__ = e64717;
var statearr_64718_64727 = state_64705;
(statearr_64718_64727[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64705[(4)]))){
var statearr_64719_64728 = state_64705;
(statearr_64719_64728[(1)] = cljs.core.first((state_64705[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64729 = state_64705;
state_64705 = G__64729;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__ = function(state_64705){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____1.call(this,state_64705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64720 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64720[(6)] = c__2436__auto__);

return statearr_64720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64797){
var state_val_64798 = (state_64797[(1)]);
if((state_val_64798 === (7))){
var inst_64757 = (state_64797[(2)]);
var inst_64758 = fluree.db.util.async.throw_err(inst_64757);
var state_64797__$1 = state_64797;
var statearr_64799_64825 = state_64797__$1;
(statearr_64799_64825[(2)] = inst_64758);

(statearr_64799_64825[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (1))){
var inst_64734 = cljs.core.volatile_BANG_((0));
var inst_64735 = cljs.core.PersistentHashMap.EMPTY;
var inst_64736 = cljs.core.volatile_BANG_(inst_64735);
var inst_64737 = cljs.core.first(resp);
var inst_64738 = cljs.core.rest(resp);
var inst_64739 = cljs.core.PersistentVector.EMPTY;
var inst_64740 = inst_64734;
var inst_64741 = inst_64736;
var inst_64742 = inst_64737;
var inst_64743 = inst_64738;
var inst_64744 = inst_64739;
var state_64797__$1 = (function (){var statearr_64800 = state_64797;
(statearr_64800[(7)] = inst_64742);

(statearr_64800[(8)] = inst_64743);

(statearr_64800[(9)] = inst_64740);

(statearr_64800[(10)] = inst_64741);

(statearr_64800[(11)] = inst_64744);

return statearr_64800;
})();
var statearr_64801_64826 = state_64797__$1;
(statearr_64801_64826[(2)] = null);

(statearr_64801_64826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (4))){
var inst_64742 = (state_64797[(7)]);
var inst_64743 = (state_64797[(8)]);
var inst_64740 = (state_64797[(9)]);
var inst_64748 = (state_64797[(12)]);
var inst_64746 = (state_64797[(13)]);
var inst_64741 = (state_64797[(10)]);
var inst_64744 = (state_64797[(11)]);
var inst_64752 = (function (){var fuel = inst_64740;
var cache = inst_64741;
var curr_block = inst_64742;
var rest_blocks = inst_64743;
var acc = inst_64744;
var flakes = inst_64746;
var asserted = inst_64748;
return (function (p1__64731_SHARP_){
return p1__64731_SHARP_.s;
});
})();
var inst_64753 = cljs.core.group_by(inst_64752,inst_64748);
var inst_64754 = cljs.core.vals(inst_64753);
var inst_64755 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64741,inst_64740,inst_64754);
var state_64797__$1 = state_64797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64797__$1,(7),inst_64755);
} else {
if((state_val_64798 === (13))){
var inst_64785 = (state_64797[(14)]);
var state_64797__$1 = state_64797;
var statearr_64802_64827 = state_64797__$1;
(statearr_64802_64827[(2)] = inst_64785);

(statearr_64802_64827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (6))){
var inst_64761 = (state_64797[(15)]);
var inst_64742 = (state_64797[(7)]);
var inst_64743 = (state_64797[(8)]);
var inst_64763 = (state_64797[(16)]);
var inst_64740 = (state_64797[(9)]);
var inst_64748 = (state_64797[(12)]);
var inst_64746 = (state_64797[(13)]);
var inst_64741 = (state_64797[(10)]);
var inst_64744 = (state_64797[(11)]);
var inst_64761__$1 = (state_64797[(2)]);
var inst_64762 = (function (){var fuel = inst_64740;
var cache = inst_64741;
var curr_block = inst_64742;
var rest_blocks = inst_64743;
var acc = inst_64744;
var flakes = inst_64746;
var asserted = inst_64748;
var asserted_SINGLEQUOTE_ = inst_64761__$1;
return (function (p1__64732_SHARP_){
return p1__64732_SHARP_.op === false;
});
})();
var inst_64763__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64762,inst_64746);
var inst_64764 = cljs.core.empty_QMARK_(inst_64763__$1);
var inst_64765 = (!(inst_64764));
var state_64797__$1 = (function (){var statearr_64805 = state_64797;
(statearr_64805[(15)] = inst_64761__$1);

(statearr_64805[(16)] = inst_64763__$1);

return statearr_64805;
})();
if(inst_64765){
var statearr_64806_64828 = state_64797__$1;
(statearr_64806_64828[(1)] = (8));

} else {
var statearr_64807_64829 = state_64797__$1;
(statearr_64807_64829[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (3))){
var inst_64795 = (state_64797[(2)]);
var state_64797__$1 = state_64797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64797__$1,inst_64795);
} else {
if((state_val_64798 === (12))){
var inst_64743 = (state_64797[(8)]);
var inst_64740 = (state_64797[(9)]);
var inst_64785 = (state_64797[(14)]);
var inst_64741 = (state_64797[(10)]);
var inst_64788 = cljs.core.first(inst_64743);
var inst_64789 = cljs.core.rest(inst_64743);
var tmp64803 = inst_64740;
var tmp64804 = inst_64741;
var inst_64740__$1 = tmp64803;
var inst_64741__$1 = tmp64804;
var inst_64742 = inst_64788;
var inst_64743__$1 = inst_64789;
var inst_64744 = inst_64785;
var state_64797__$1 = (function (){var statearr_64808 = state_64797;
(statearr_64808[(7)] = inst_64742);

(statearr_64808[(8)] = inst_64743__$1);

(statearr_64808[(9)] = inst_64740__$1);

(statearr_64808[(10)] = inst_64741__$1);

(statearr_64808[(11)] = inst_64744);

return statearr_64808;
})();
var statearr_64809_64830 = state_64797__$1;
(statearr_64809_64830[(2)] = null);

(statearr_64809_64830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (2))){
var inst_64742 = (state_64797[(7)]);
var inst_64743 = (state_64797[(8)]);
var inst_64740 = (state_64797[(9)]);
var inst_64748 = (state_64797[(12)]);
var inst_64746 = (state_64797[(13)]);
var inst_64741 = (state_64797[(10)]);
var inst_64744 = (state_64797[(11)]);
var inst_64746__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_64742);
var inst_64747 = (function (){var fuel = inst_64740;
var cache = inst_64741;
var curr_block = inst_64742;
var rest_blocks = inst_64743;
var acc = inst_64744;
var flakes = inst_64746__$1;
return (function (p1__64730_SHARP_){
return p1__64730_SHARP_.op;
});
})();
var inst_64748__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64747,inst_64746__$1);
var inst_64749 = cljs.core.empty_QMARK_(inst_64748__$1);
var inst_64750 = (!(inst_64749));
var state_64797__$1 = (function (){var statearr_64810 = state_64797;
(statearr_64810[(12)] = inst_64748__$1);

(statearr_64810[(13)] = inst_64746__$1);

return statearr_64810;
})();
if(inst_64750){
var statearr_64811_64831 = state_64797__$1;
(statearr_64811_64831[(1)] = (4));

} else {
var statearr_64812_64832 = state_64797__$1;
(statearr_64812_64832[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (11))){
var inst_64773 = (state_64797[(2)]);
var inst_64774 = fluree.db.util.async.throw_err(inst_64773);
var state_64797__$1 = state_64797;
var statearr_64813_64833 = state_64797__$1;
(statearr_64813_64833[(2)] = inst_64774);

(statearr_64813_64833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (9))){
var state_64797__$1 = state_64797;
var statearr_64814_64834 = state_64797__$1;
(statearr_64814_64834[(2)] = null);

(statearr_64814_64834[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (5))){
var state_64797__$1 = state_64797;
var statearr_64815_64835 = state_64797__$1;
(statearr_64815_64835[(2)] = null);

(statearr_64815_64835[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (14))){
var inst_64793 = (state_64797[(2)]);
var state_64797__$1 = state_64797;
var statearr_64816_64836 = state_64797__$1;
(statearr_64816_64836[(2)] = inst_64793);

(statearr_64816_64836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (10))){
var inst_64761 = (state_64797[(15)]);
var inst_64742 = (state_64797[(7)]);
var inst_64743 = (state_64797[(8)]);
var inst_64744 = (state_64797[(11)]);
var inst_64777 = (state_64797[(2)]);
var inst_64778 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_64779 = [inst_64761,inst_64777];
var inst_64780 = cljs.core.PersistentHashMap.fromArrays(inst_64778,inst_64779);
var inst_64781 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64742,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_64780);
var inst_64782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64783 = [inst_64781];
var inst_64784 = (new cljs.core.PersistentVector(null,1,(5),inst_64782,inst_64783,null));
var inst_64785 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_64744,inst_64784);
var inst_64786 = cljs.core.first(inst_64743);
var state_64797__$1 = (function (){var statearr_64817 = state_64797;
(statearr_64817[(14)] = inst_64785);

return statearr_64817;
})();
if(cljs.core.truth_(inst_64786)){
var statearr_64818_64837 = state_64797__$1;
(statearr_64818_64837[(1)] = (12));

} else {
var statearr_64819_64838 = state_64797__$1;
(statearr_64819_64838[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64798 === (8))){
var inst_64761 = (state_64797[(15)]);
var inst_64742 = (state_64797[(7)]);
var inst_64743 = (state_64797[(8)]);
var inst_64763 = (state_64797[(16)]);
var inst_64740 = (state_64797[(9)]);
var inst_64748 = (state_64797[(12)]);
var inst_64746 = (state_64797[(13)]);
var inst_64741 = (state_64797[(10)]);
var inst_64744 = (state_64797[(11)]);
var inst_64767 = (function (){var flakes = inst_64746;
var rest_blocks = inst_64743;
var curr_block = inst_64742;
var asserted_SINGLEQUOTE_ = inst_64761;
var acc = inst_64744;
var fuel = inst_64740;
var cache = inst_64741;
var retracted = inst_64763;
var asserted = inst_64748;
return (function (p1__64733_SHARP_){
return p1__64733_SHARP_.s;
});
})();
var inst_64768 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_64763);
var inst_64769 = cljs.core.group_by(inst_64767,inst_64768);
var inst_64770 = cljs.core.vals(inst_64769);
var inst_64771 = fluree.db.api_js.format_flake_groups_pretty(db,inst_64741,inst_64740,inst_64770);
var state_64797__$1 = state_64797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64797__$1,(11),inst_64771);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____0 = (function (){
var statearr_64820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64820[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__);

(statearr_64820[(1)] = (1));

return statearr_64820;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____1 = (function (state_64797){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64797);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64821){var ex__2417__auto__ = e64821;
var statearr_64822_64839 = state_64797;
(statearr_64822_64839[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64797[(4)]))){
var statearr_64823_64840 = state_64797;
(statearr_64823_64840[(1)] = cljs.core.first((state_64797[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64841 = state_64797;
state_64797 = G__64841;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__ = function(state_64797){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____1.call(this,state_64797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64824 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64824[(6)] = c__2436__auto__);

return statearr_64824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64941){
var state_val_64942 = (state_64941[(1)]);
if((state_val_64942 === (7))){
var inst_64913 = (state_64941[(7)]);
var inst_64906 = (state_64941[(8)]);
var inst_64912 = cljs.core.seq(inst_64906);
var inst_64913__$1 = cljs.core.first(inst_64912);
var inst_64914 = cljs.core.next(inst_64912);
var state_64941__$1 = (function (){var statearr_64943 = state_64941;
(statearr_64943[(7)] = inst_64913__$1);

(statearr_64943[(9)] = inst_64914);

return statearr_64943;
})();
if(cljs.core.truth_(inst_64913__$1)){
var statearr_64944_64981 = state_64941__$1;
(statearr_64944_64981[(1)] = (9));

} else {
var statearr_64945_64982 = state_64941__$1;
(statearr_64945_64982[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (1))){
var state_64941__$1 = state_64941;
var statearr_64946_64983 = state_64941__$1;
(statearr_64946_64983[(2)] = null);

(statearr_64946_64983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (4))){
var inst_64843 = (state_64941[(2)]);
var state_64941__$1 = state_64941;
var statearr_64947_64984 = state_64941__$1;
(statearr_64947_64984[(2)] = inst_64843);

(statearr_64947_64984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (6))){
var inst_64892 = (state_64941[(2)]);
var inst_64893 = fluree.db.util.async.throw_err(inst_64892);
var inst_64901 = resp;
var inst_64902 = cljs.core.seq(inst_64901);
var inst_64903 = cljs.core.first(inst_64902);
var inst_64904 = cljs.core.next(inst_64902);
var inst_64905 = cljs.core.PersistentHashMap.EMPTY;
var inst_64906 = inst_64901;
var inst_64907 = inst_64905;
var state_64941__$1 = (function (){var statearr_64948 = state_64941;
(statearr_64948[(8)] = inst_64906);

(statearr_64948[(10)] = inst_64907);

(statearr_64948[(11)] = inst_64903);

(statearr_64948[(12)] = inst_64893);

(statearr_64948[(13)] = inst_64904);

return statearr_64948;
})();
var statearr_64949_64985 = state_64941__$1;
(statearr_64949_64985[(2)] = null);

(statearr_64949_64985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (3))){
var inst_64939 = (state_64941[(2)]);
var state_64941__$1 = state_64941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64941__$1,inst_64939);
} else {
if((state_val_64942 === (2))){
var _ = (function (){var statearr_64950 = state_64941;
(statearr_64950[(4)] = cljs.core.cons((5),(state_64941[(4)])));

return statearr_64950;
})();
var inst_64849 = (function (){return (function (p1__64842_SHARP_){
return p1__64842_SHARP_.t;
});
})();
var inst_64850 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64849,resp);
var inst_64851 = cljs.core.set(inst_64850);
var inst_64888 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64889 = (function (){var ts = inst_64851;
var c__2436__auto____$1 = inst_64888;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64886){
var state_val_64887 = (state_64886[(1)]);
if((state_val_64887 === (1))){
var inst_64859 = ts;
var inst_64860 = cljs.core.seq(inst_64859);
var inst_64861 = cljs.core.first(inst_64860);
var inst_64862 = cljs.core.next(inst_64860);
var inst_64863 = cljs.core.PersistentHashMap.EMPTY;
var inst_64864 = inst_64859;
var inst_64865 = inst_64863;
var state_64886__$1 = (function (){var statearr_64951 = state_64886;
(statearr_64951[(7)] = inst_64862);

(statearr_64951[(8)] = inst_64861);

(statearr_64951[(9)] = inst_64865);

(statearr_64951[(10)] = inst_64864);

return statearr_64951;
})();
var statearr_64952_64986 = state_64886__$1;
(statearr_64952_64986[(2)] = null);

(statearr_64952_64986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64887 === (2))){
var inst_64871 = (state_64886[(11)]);
var inst_64864 = (state_64886[(10)]);
var inst_64870 = cljs.core.seq(inst_64864);
var inst_64871__$1 = cljs.core.first(inst_64870);
var inst_64872 = cljs.core.next(inst_64870);
var state_64886__$1 = (function (){var statearr_64953 = state_64886;
(statearr_64953[(12)] = inst_64872);

(statearr_64953[(11)] = inst_64871__$1);

return statearr_64953;
})();
if(cljs.core.truth_(inst_64871__$1)){
var statearr_64954_64987 = state_64886__$1;
(statearr_64954_64987[(1)] = (4));

} else {
var statearr_64955_64988 = state_64886__$1;
(statearr_64955_64988[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64887 === (3))){
var inst_64884 = (state_64886[(2)]);
var state_64886__$1 = state_64886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64886__$1,inst_64884);
} else {
if((state_val_64887 === (4))){
var inst_64871 = (state_64886[(11)]);
var inst_64874 = fluree.db.time_travel.non_border_t_to_block(db,inst_64871);
var state_64886__$1 = state_64886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64886__$1,(7),inst_64874);
} else {
if((state_val_64887 === (5))){
var inst_64865 = (state_64886[(9)]);
var state_64886__$1 = state_64886;
var statearr_64956_64989 = state_64886__$1;
(statearr_64956_64989[(2)] = inst_64865);

(statearr_64956_64989[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64887 === (6))){
var inst_64882 = (state_64886[(2)]);
var state_64886__$1 = state_64886;
var statearr_64957_64990 = state_64886__$1;
(statearr_64957_64990[(2)] = inst_64882);

(statearr_64957_64990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64887 === (7))){
var inst_64872 = (state_64886[(12)]);
var inst_64865 = (state_64886[(9)]);
var inst_64871 = (state_64886[(11)]);
var inst_64876 = (state_64886[(2)]);
var inst_64877 = fluree.db.util.async.throw_err(inst_64876);
var inst_64878 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64865,inst_64871,inst_64877);
var inst_64864 = inst_64872;
var inst_64865__$1 = inst_64878;
var state_64886__$1 = (function (){var statearr_64958 = state_64886;
(statearr_64958[(9)] = inst_64865__$1);

(statearr_64958[(10)] = inst_64864);

return statearr_64958;
})();
var statearr_64959_64991 = state_64886__$1;
(statearr_64959_64991[(2)] = null);

(statearr_64959_64991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_64960 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64960[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__);

(statearr_64960[(1)] = (1));

return statearr_64960;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1 = (function (state_64886){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64886);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64961){var ex__2417__auto__ = e64961;
var statearr_64962_64992 = state_64886;
(statearr_64962_64992[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64886[(4)]))){
var statearr_64963_64993 = state_64886;
(statearr_64963_64993[(1)] = cljs.core.first((state_64886[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64994 = state_64886;
state_64886 = G__64994;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__ = function(state_64886){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1.call(this,state_64886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64964 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64964[(6)] = c__2436__auto____$1);

return statearr_64964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_64890 = cljs.core.async.impl.dispatch.run(inst_64889);
var state_64941__$1 = (function (){var statearr_64965 = state_64941;
(statearr_64965[(14)] = inst_64890);

return statearr_64965;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64941__$1,(6),inst_64888);
} else {
if((state_val_64942 === (11))){
var inst_64933 = (state_64941[(2)]);
var state_64941__$1 = state_64941;
var statearr_64967_64995 = state_64941__$1;
(statearr_64967_64995[(2)] = inst_64933);

(statearr_64967_64995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (9))){
var inst_64913 = (state_64941[(7)]);
var inst_64907 = (state_64941[(10)]);
var inst_64914 = (state_64941[(9)]);
var inst_64893 = (state_64941[(12)]);
var inst_64916 = inst_64913.t;
var inst_64917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64893,inst_64916);
var inst_64918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64919 = [inst_64917,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64920 = (new cljs.core.PersistentVector(null,2,(5),inst_64918,inst_64919,null));
var inst_64921 = cljs.core.assoc_in(inst_64907,inst_64920,inst_64917);
var inst_64922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64923 = [inst_64917,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64924 = (new cljs.core.PersistentVector(null,2,(5),inst_64922,inst_64923,null));
var inst_64925 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64921,inst_64924,cljs.core.conj,inst_64913);
var inst_64926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64927 = [inst_64917,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64928 = (new cljs.core.PersistentVector(null,2,(5),inst_64926,inst_64927,null));
var inst_64929 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64925,inst_64928,fluree.db.api_js.min_safe,inst_64916);
var inst_64906 = inst_64914;
var inst_64907__$1 = inst_64929;
var state_64941__$1 = (function (){var statearr_64968 = state_64941;
(statearr_64968[(8)] = inst_64906);

(statearr_64968[(10)] = inst_64907__$1);

return statearr_64968;
})();
var statearr_64969_64996 = state_64941__$1;
(statearr_64969_64996[(2)] = null);

(statearr_64969_64996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (5))){
var _ = (function (){var statearr_64970 = state_64941;
(statearr_64970[(4)] = cljs.core.rest((state_64941[(4)])));

return statearr_64970;
})();
var state_64941__$1 = state_64941;
var ex64966 = (state_64941__$1[(2)]);
var statearr_64971_64997 = state_64941__$1;
(statearr_64971_64997[(5)] = ex64966);


if((ex64966 instanceof Error)){
var statearr_64972_64998 = state_64941__$1;
(statearr_64972_64998[(1)] = (4));

(statearr_64972_64998[(5)] = null);

} else {
throw ex64966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (10))){
var inst_64907 = (state_64941[(10)]);
var state_64941__$1 = state_64941;
var statearr_64973_64999 = state_64941__$1;
(statearr_64973_64999[(2)] = inst_64907);

(statearr_64973_64999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64942 === (8))){
var inst_64935 = (state_64941[(2)]);
var inst_64936 = cljs.core.vals(inst_64935);
var _ = (function (){var statearr_64974 = state_64941;
(statearr_64974[(4)] = cljs.core.rest((state_64941[(4)])));

return statearr_64974;
})();
var state_64941__$1 = state_64941;
var statearr_64975_65000 = state_64941__$1;
(statearr_64975_65000[(2)] = inst_64936);

(statearr_64975_65000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0 = (function (){
var statearr_64976 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64976[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__);

(statearr_64976[(1)] = (1));

return statearr_64976;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1 = (function (state_64941){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64941);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64977){var ex__2417__auto__ = e64977;
var statearr_64978_65001 = state_64941;
(statearr_64978_65001[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64941[(4)]))){
var statearr_64979_65002 = state_64941;
(statearr_64979_65002[(1)] = cljs.core.first((state_64941[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65003 = state_64941;
state_64941 = G__65003;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__ = function(state_64941){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1.call(this,state_64941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2414__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64980 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64980[(6)] = c__2436__auto__);

return statearr_64980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_65145){
var state_val_65146 = (state_65145[(1)]);
if((state_val_65146 === (7))){
var inst_65028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65029 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65030 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65031 = [inst_65029,inst_65030];
var inst_65032 = (new cljs.core.PersistentVector(null,2,(5),inst_65028,inst_65031,null));
var state_65145__$1 = state_65145;
var statearr_65147_65214 = state_65145__$1;
(statearr_65147_65214[(2)] = inst_65032);

(statearr_65147_65214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (20))){
var inst_65058 = (state_65145[(7)]);
var state_65145__$1 = state_65145;
var statearr_65148_65215 = state_65145__$1;
(statearr_65148_65215[(2)] = inst_65058);

(statearr_65148_65215[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (27))){
var state_65145__$1 = state_65145;
var statearr_65149_65216 = state_65145__$1;
(statearr_65149_65216[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (1))){
var state_65145__$1 = state_65145;
var statearr_65151_65217 = state_65145__$1;
(statearr_65151_65217[(2)] = null);

(statearr_65151_65217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (24))){
var inst_65057 = (state_65145[(8)]);
var state_65145__$1 = state_65145;
if(cljs.core.truth_(inst_65057)){
var statearr_65152_65218 = state_65145__$1;
(statearr_65152_65218[(1)] = (26));

} else {
var statearr_65153_65219 = state_65145__$1;
(statearr_65153_65219[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (39))){
var inst_65132 = (state_65145[(9)]);
var state_65145__$1 = state_65145;
var statearr_65154_65220 = state_65145__$1;
(statearr_65154_65220[(2)] = inst_65132);

(statearr_65154_65220[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (4))){
var inst_65004 = (state_65145[(2)]);
var inst_65005 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65004], 0));
var inst_65006 = cljs.core.ex_data(inst_65004);
var inst_65007 = cljs.core.ex_message(inst_65004);
var inst_65008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65006,new cljs.core.Keyword(null,"message","message",-406056002),inst_65007);
var state_65145__$1 = (function (){var statearr_65155 = state_65145;
(statearr_65155[(10)] = inst_65005);

return statearr_65155;
})();
var statearr_65156_65221 = state_65145__$1;
(statearr_65156_65221[(2)] = inst_65008);

(statearr_65156_65221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (15))){
var inst_65037 = (state_65145[(11)]);
var inst_65042 = (state_65145[(12)]);
var inst_65051 = (state_65145[(2)]);
var inst_65052 = [inst_65042,inst_65051];
var inst_65053 = (new cljs.core.PersistentVector(null,2,(5),inst_65037,inst_65052,null));
var state_65145__$1 = state_65145;
var statearr_65157_65222 = state_65145__$1;
(statearr_65157_65222[(2)] = inst_65053);

(statearr_65157_65222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (21))){
var inst_65057 = (state_65145[(8)]);
var state_65145__$1 = state_65145;
var statearr_65158_65223 = state_65145__$1;
(statearr_65158_65223[(2)] = inst_65057);

(statearr_65158_65223[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (31))){
var inst_65098 = (state_65145[(2)]);
var state_65145__$1 = state_65145;
var statearr_65159_65224 = state_65145__$1;
(statearr_65159_65224[(2)] = inst_65098);

(statearr_65159_65224[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (32))){
var inst_65034 = (state_65145[(13)]);
var inst_65110 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65034], 0));
var inst_65111 = ["Invalid block range provided: ",inst_65110].join('');
var inst_65112 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65113 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65114 = cljs.core.PersistentHashMap.fromArrays(inst_65112,inst_65113);
var inst_65115 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65111,inst_65114);
var inst_65116 = (function(){throw inst_65115})();
var state_65145__$1 = state_65145;
var statearr_65160_65225 = state_65145__$1;
(statearr_65160_65225[(2)] = inst_65116);

(statearr_65160_65225[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (40))){
var inst_65131 = (state_65145[(14)]);
var inst_65137 = (state_65145[(2)]);
var inst_65138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65139 = [inst_65131,inst_65137];
var inst_65140 = (new cljs.core.PersistentVector(null,2,(5),inst_65138,inst_65139,null));
var _ = (function (){var statearr_65161 = state_65145;
(statearr_65161[(4)] = cljs.core.rest((state_65145[(4)])));

return statearr_65161;
})();
var state_65145__$1 = state_65145;
var statearr_65162_65226 = state_65145__$1;
(statearr_65162_65226[(2)] = inst_65140);

(statearr_65162_65226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (33))){
var state_65145__$1 = state_65145;
var statearr_65163_65227 = state_65145__$1;
(statearr_65163_65227[(2)] = null);

(statearr_65163_65227[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (13))){
var inst_65043 = (state_65145[(15)]);
var inst_65045 = fluree.db.time_travel.block_to_int_format(db,inst_65043);
var state_65145__$1 = state_65145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65145__$1,(16),inst_65045);
} else {
if((state_val_65146 === (22))){
var inst_65076 = (state_65145[(2)]);
var state_65145__$1 = state_65145;
if(cljs.core.truth_(inst_65076)){
var statearr_65164_65228 = state_65145__$1;
(statearr_65164_65228[(1)] = (23));

} else {
var statearr_65165_65229 = state_65145__$1;
(statearr_65165_65229[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (36))){
var inst_65103 = (state_65145[(16)]);
var inst_65104 = (state_65145[(17)]);
var inst_65126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65127 = [inst_65103,inst_65104];
var inst_65128 = (new cljs.core.PersistentVector(null,2,(5),inst_65126,inst_65127,null));
var state_65145__$1 = state_65145;
var statearr_65166_65230 = state_65145__$1;
(statearr_65166_65230[(2)] = inst_65128);

(statearr_65166_65230[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (29))){
var inst_65034 = (state_65145[(13)]);
var inst_65089 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65034], 0));
var inst_65090 = ["Invalid block range provided: ",inst_65089].join('');
var inst_65091 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65092 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65093 = cljs.core.PersistentHashMap.fromArrays(inst_65091,inst_65092);
var inst_65094 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65090,inst_65093);
var inst_65095 = (function(){throw inst_65094})();
var state_65145__$1 = state_65145;
var statearr_65167_65231 = state_65145__$1;
(statearr_65167_65231[(2)] = inst_65095);

(statearr_65167_65231[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (6))){
var inst_65026 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65145__$1 = state_65145;
var statearr_65168_65232 = state_65145__$1;
(statearr_65168_65232[(2)] = inst_65026);

(statearr_65168_65232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (28))){
var inst_65100 = (state_65145[(2)]);
var state_65145__$1 = state_65145;
var statearr_65169_65233 = state_65145__$1;
(statearr_65169_65233[(2)] = inst_65100);

(statearr_65169_65233[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (25))){
var inst_65103 = (state_65145[(16)]);
var inst_65104 = (state_65145[(17)]);
var inst_65102 = (state_65145[(2)]);
var inst_65103__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65102,(0),null);
var inst_65104__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65102,(1),null);
var inst_65105 = cljs.core.pos_int_QMARK_(inst_65103__$1);
var inst_65106 = cljs.core.pos_int_QMARK_(inst_65104__$1);
var inst_65107 = ((inst_65105) && (inst_65106));
var inst_65108 = cljs.core.not(inst_65107);
var state_65145__$1 = (function (){var statearr_65170 = state_65145;
(statearr_65170[(16)] = inst_65103__$1);

(statearr_65170[(17)] = inst_65104__$1);

return statearr_65170;
})();
if(inst_65108){
var statearr_65171_65234 = state_65145__$1;
(statearr_65171_65234[(1)] = (32));

} else {
var statearr_65172_65235 = state_65145__$1;
(statearr_65172_65235[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (34))){
var inst_65103 = (state_65145[(16)]);
var inst_65104 = (state_65145[(17)]);
var inst_65119 = (state_65145[(2)]);
var inst_65120 = (inst_65104 < inst_65103);
var state_65145__$1 = (function (){var statearr_65173 = state_65145;
(statearr_65173[(18)] = inst_65119);

return statearr_65173;
})();
if(cljs.core.truth_(inst_65120)){
var statearr_65174_65236 = state_65145__$1;
(statearr_65174_65236[(1)] = (35));

} else {
var statearr_65175_65237 = state_65145__$1;
(statearr_65175_65237[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (17))){
var inst_65057 = (state_65145[(8)]);
var inst_65059 = (state_65145[(19)]);
var inst_65062 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65057], 0));
var inst_65063 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65059], 0));
var inst_65064 = ["Start block is out of range for this ledger. Start block provided: ",inst_65062,". Database block: ",inst_65063].join('');
var inst_65065 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65066 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65067 = cljs.core.PersistentHashMap.fromArrays(inst_65065,inst_65066);
var inst_65068 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65064,inst_65067);
var inst_65069 = (function(){throw inst_65068})();
var state_65145__$1 = state_65145;
var statearr_65176_65238 = state_65145__$1;
(statearr_65176_65238[(2)] = inst_65069);

(statearr_65176_65238[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (3))){
var inst_65143 = (state_65145[(2)]);
var state_65145__$1 = state_65145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65145__$1,inst_65143);
} else {
if((state_val_65146 === (12))){
var inst_65043 = (state_65145[(15)]);
var inst_65034 = (state_65145[(13)]);
var inst_65041 = (state_65145[(2)]);
var inst_65042 = fluree.db.util.async.throw_err(inst_65041);
var inst_65043__$1 = cljs.core.second(inst_65034);
var state_65145__$1 = (function (){var statearr_65177 = state_65145;
(statearr_65177[(15)] = inst_65043__$1);

(statearr_65177[(12)] = inst_65042);

return statearr_65177;
})();
if(cljs.core.truth_(inst_65043__$1)){
var statearr_65178_65239 = state_65145__$1;
(statearr_65178_65239[(1)] = (13));

} else {
var statearr_65179_65240 = state_65145__$1;
(statearr_65179_65240[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (2))){
var _ = (function (){var statearr_65180 = state_65145;
(statearr_65180[(4)] = cljs.core.cons((5),(state_65145[(4)])));

return statearr_65180;
})();
var inst_65023 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65024 = cljs.core.sequential_QMARK_(inst_65023);
var state_65145__$1 = state_65145;
if(inst_65024){
var statearr_65181_65241 = state_65145__$1;
(statearr_65181_65241[(1)] = (6));

} else {
var statearr_65182_65242 = state_65145__$1;
(statearr_65182_65242[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (23))){
var inst_65058 = (state_65145[(7)]);
var inst_65057 = (state_65145[(8)]);
var inst_65078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65079 = [inst_65057,inst_65058];
var inst_65080 = (new cljs.core.PersistentVector(null,2,(5),inst_65078,inst_65079,null));
var state_65145__$1 = state_65145;
var statearr_65183_65243 = state_65145__$1;
(statearr_65183_65243[(2)] = inst_65080);

(statearr_65183_65243[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (35))){
var inst_65103 = (state_65145[(16)]);
var inst_65104 = (state_65145[(17)]);
var inst_65122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65123 = [inst_65104,inst_65103];
var inst_65124 = (new cljs.core.PersistentVector(null,2,(5),inst_65122,inst_65123,null));
var state_65145__$1 = state_65145;
var statearr_65184_65244 = state_65145__$1;
(statearr_65184_65244[(2)] = inst_65124);

(statearr_65184_65244[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (19))){
var inst_65057 = (state_65145[(8)]);
var inst_65072 = (state_65145[(2)]);
var state_65145__$1 = (function (){var statearr_65185 = state_65145;
(statearr_65185[(20)] = inst_65072);

return statearr_65185;
})();
if(cljs.core.truth_(inst_65057)){
var statearr_65186_65245 = state_65145__$1;
(statearr_65186_65245[(1)] = (20));

} else {
var statearr_65187_65246 = state_65145__$1;
(statearr_65187_65246[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (11))){
var inst_65057 = (state_65145[(8)]);
var inst_65059 = (state_65145[(19)]);
var inst_65056 = (state_65145[(2)]);
var inst_65057__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65056,(0),null);
var inst_65058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65056,(1),null);
var inst_65059__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65060 = (inst_65057__$1 > inst_65059__$1);
var state_65145__$1 = (function (){var statearr_65189 = state_65145;
(statearr_65189[(7)] = inst_65058);

(statearr_65189[(8)] = inst_65057__$1);

(statearr_65189[(19)] = inst_65059__$1);

return statearr_65189;
})();
if(cljs.core.truth_(inst_65060)){
var statearr_65190_65247 = state_65145__$1;
(statearr_65190_65247[(1)] = (17));

} else {
var statearr_65191_65248 = state_65145__$1;
(statearr_65191_65248[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (9))){
var inst_65034 = (state_65145[(13)]);
var inst_65037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65038 = cljs.core.first(inst_65034);
var inst_65039 = fluree.db.time_travel.block_to_int_format(db,inst_65038);
var state_65145__$1 = (function (){var statearr_65192 = state_65145;
(statearr_65192[(11)] = inst_65037);

return statearr_65192;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65145__$1,(12),inst_65039);
} else {
if((state_val_65146 === (5))){
var _ = (function (){var statearr_65193 = state_65145;
(statearr_65193[(4)] = cljs.core.rest((state_65145[(4)])));

return statearr_65193;
})();
var state_65145__$1 = state_65145;
var ex65188 = (state_65145__$1[(2)]);
var statearr_65194_65249 = state_65145__$1;
(statearr_65194_65249[(5)] = ex65188);


var statearr_65195_65250 = state_65145__$1;
(statearr_65195_65250[(1)] = (4));

(statearr_65195_65250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (14))){
var state_65145__$1 = state_65145;
var statearr_65196_65251 = state_65145__$1;
(statearr_65196_65251[(2)] = null);

(statearr_65196_65251[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (26))){
var inst_65057 = (state_65145[(8)]);
var inst_65083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65084 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65085 = [inst_65057,inst_65084];
var inst_65086 = (new cljs.core.PersistentVector(null,2,(5),inst_65083,inst_65085,null));
var state_65145__$1 = state_65145;
var statearr_65197_65252 = state_65145__$1;
(statearr_65197_65252[(2)] = inst_65086);

(statearr_65197_65252[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (16))){
var inst_65047 = (state_65145[(2)]);
var inst_65048 = fluree.db.util.async.throw_err(inst_65047);
var state_65145__$1 = state_65145;
var statearr_65198_65253 = state_65145__$1;
(statearr_65198_65253[(2)] = inst_65048);

(statearr_65198_65253[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (38))){
var inst_65059 = (state_65145[(19)]);
var state_65145__$1 = state_65145;
var statearr_65199_65254 = state_65145__$1;
(statearr_65199_65254[(2)] = inst_65059);

(statearr_65199_65254[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (30))){
var state_65145__$1 = state_65145;
var statearr_65200_65255 = state_65145__$1;
(statearr_65200_65255[(2)] = null);

(statearr_65200_65255[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (10))){
var inst_65034 = (state_65145[(13)]);
var state_65145__$1 = state_65145;
var statearr_65201_65256 = state_65145__$1;
(statearr_65201_65256[(2)] = inst_65034);

(statearr_65201_65256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (18))){
var state_65145__$1 = state_65145;
var statearr_65202_65257 = state_65145__$1;
(statearr_65202_65257[(2)] = null);

(statearr_65202_65257[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (37))){
var inst_65132 = (state_65145[(9)]);
var inst_65059 = (state_65145[(19)]);
var inst_65130 = (state_65145[(2)]);
var inst_65131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65130,(0),null);
var inst_65132__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65130,(1),null);
var inst_65133 = (inst_65132__$1 > inst_65059);
var state_65145__$1 = (function (){var statearr_65203 = state_65145;
(statearr_65203[(9)] = inst_65132__$1);

(statearr_65203[(14)] = inst_65131);

return statearr_65203;
})();
if(cljs.core.truth_(inst_65133)){
var statearr_65204_65258 = state_65145__$1;
(statearr_65204_65258[(1)] = (38));

} else {
var statearr_65205_65259 = state_65145__$1;
(statearr_65205_65259[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65146 === (8))){
var inst_65034 = (state_65145[(13)]);
var inst_65034__$1 = (state_65145[(2)]);
var inst_65035 = cljs.core.some(cljs.core.string_QMARK_,inst_65034__$1);
var state_65145__$1 = (function (){var statearr_65206 = state_65145;
(statearr_65206[(13)] = inst_65034__$1);

return statearr_65206;
})();
if(cljs.core.truth_(inst_65035)){
var statearr_65207_65260 = state_65145__$1;
(statearr_65207_65260[(1)] = (9));

} else {
var statearr_65208_65261 = state_65145__$1;
(statearr_65208_65261[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____0 = (function (){
var statearr_65209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65209[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__);

(statearr_65209[(1)] = (1));

return statearr_65209;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____1 = (function (state_65145){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_65145);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e65210){var ex__2417__auto__ = e65210;
var statearr_65211_65262 = state_65145;
(statearr_65211_65262[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_65145[(4)]))){
var statearr_65212_65263 = state_65145;
(statearr_65212_65263[(1)] = cljs.core.first((state_65145[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65264 = state_65145;
state_65145 = G__65264;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__ = function(state_65145){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____1.call(this,state_65145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_65213 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_65213[(6)] = c__2436__auto__);

return statearr_65213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65267 = arguments.length;
switch (G__65267) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_65382){
var state_val_65383 = (state_65382[(1)]);
if((state_val_65383 === (7))){
var state_65382__$1 = state_65382;
var statearr_65384_65450 = state_65382__$1;
(statearr_65384_65450[(2)] = false);

(statearr_65384_65450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (20))){
var state_65382__$1 = state_65382;
var statearr_65385_65451 = state_65382__$1;
(statearr_65385_65451[(2)] = null);

(statearr_65385_65451[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (27))){
var inst_65349 = (state_65382[(2)]);
var inst_65350 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65382__$1 = (function (){var statearr_65386 = state_65382;
(statearr_65386[(7)] = inst_65349);

return statearr_65386;
})();
if(cljs.core.truth_(inst_65350)){
var statearr_65387_65452 = state_65382__$1;
(statearr_65387_65452[(1)] = (29));

} else {
var statearr_65388_65453 = state_65382__$1;
(statearr_65388_65453[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (1))){
var state_65382__$1 = state_65382;
var statearr_65389_65454 = state_65382__$1;
(statearr_65389_65454[(2)] = null);

(statearr_65389_65454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (24))){
var inst_65310 = (state_65382[(8)]);
var inst_65323 = (state_65382[(2)]);
var inst_65324 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65323,inst_65310);
var inst_65325 = (function(){throw inst_65324})();
var state_65382__$1 = state_65382;
var statearr_65390_65455 = state_65382__$1;
(statearr_65390_65455[(2)] = inst_65325);

(statearr_65390_65455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (4))){
var inst_65268 = (state_65382[(2)]);
var inst_65269 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65268], 0));
var inst_65270 = cljs.core.ex_data(inst_65268);
var inst_65271 = cljs.core.ex_message(inst_65268);
var inst_65272 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65270,new cljs.core.Keyword(null,"message","message",-406056002),inst_65271);
var state_65382__$1 = (function (){var statearr_65391 = state_65382;
(statearr_65391[(9)] = inst_65269);

return statearr_65391;
})();
var statearr_65392_65456 = state_65382__$1;
(statearr_65392_65456[(2)] = inst_65272);

(statearr_65392_65456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (15))){
var inst_65310 = (state_65382[(8)]);
var inst_65309 = (state_65382[(2)]);
var inst_65310__$1 = fluree.db.util.async.throw_err(inst_65309);
var inst_65311 = cljs.core.map_QMARK_(inst_65310__$1);
var state_65382__$1 = (function (){var statearr_65393 = state_65382;
(statearr_65393[(8)] = inst_65310__$1);

return statearr_65393;
})();
if(inst_65311){
var statearr_65394_65457 = state_65382__$1;
(statearr_65394_65457[(1)] = (16));

} else {
var statearr_65395_65458 = state_65382__$1;
(statearr_65395_65458[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (21))){
var inst_65310 = (state_65382[(8)]);
var inst_65328 = (state_65382[(2)]);
var inst_65329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65310,(0),null);
var inst_65330 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65310,(1),null);
var inst_65331 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65332 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65333 = cljs.core.keys(inst_65332);
var inst_65334 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65331,inst_65333);
var state_65382__$1 = (function (){var statearr_65396 = state_65382;
(statearr_65396[(10)] = inst_65329);

(statearr_65396[(11)] = inst_65328);

(statearr_65396[(12)] = inst_65330);

return statearr_65396;
})();
if(inst_65334){
var statearr_65397_65459 = state_65382__$1;
(statearr_65397_65459[(1)] = (25));

} else {
var statearr_65398_65460 = state_65382__$1;
(statearr_65398_65460[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (31))){
var inst_65358 = (state_65382[(2)]);
var inst_65359 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65382__$1 = (function (){var statearr_65399 = state_65382;
(statearr_65399[(13)] = inst_65358);

return statearr_65399;
})();
if(cljs.core.truth_(inst_65359)){
var statearr_65400_65461 = state_65382__$1;
(statearr_65400_65461[(1)] = (33));

} else {
var statearr_65401_65462 = state_65382__$1;
(statearr_65401_65462[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (32))){
var inst_65354 = (state_65382[(2)]);
var inst_65355 = fluree.db.util.async.throw_err(inst_65354);
var state_65382__$1 = state_65382;
var statearr_65402_65463 = state_65382__$1;
(statearr_65402_65463[(2)] = inst_65355);

(statearr_65402_65463[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (33))){
var inst_65358 = (state_65382[(13)]);
var inst_65361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65362 = cljs.core.sequential_QMARK_(inst_65358);
var state_65382__$1 = (function (){var statearr_65403 = state_65382;
(statearr_65403[(14)] = inst_65361);

return statearr_65403;
})();
if(inst_65362){
var statearr_65404_65464 = state_65382__$1;
(statearr_65404_65464[(1)] = (36));

} else {
var statearr_65405_65465 = state_65382__$1;
(statearr_65405_65465[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (13))){
var inst_65283 = (state_65382[(15)]);
var state_65382__$1 = state_65382;
var statearr_65406_65466 = state_65382__$1;
(statearr_65406_65466[(2)] = inst_65283);

(statearr_65406_65466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (22))){
var inst_65318 = (state_65382[(16)]);
var state_65382__$1 = state_65382;
var statearr_65407_65467 = state_65382__$1;
(statearr_65407_65467[(2)] = inst_65318);

(statearr_65407_65467[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (36))){
var inst_65358 = (state_65382[(13)]);
var inst_65364 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65358);
var state_65382__$1 = state_65382;
var statearr_65408_65468 = state_65382__$1;
(statearr_65408_65468[(2)] = inst_65364);

(statearr_65408_65468[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (29))){
var inst_65349 = (state_65382[(7)]);
var inst_65352 = fluree.db.api_js.format_block_resp_pretty(db,inst_65349);
var state_65382__$1 = state_65382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65382__$1,(32),inst_65352);
} else {
if((state_val_65383 === (6))){
var inst_65283 = (state_65382[(15)]);
var inst_65288 = inst_65283.cljs$lang$protocol_mask$partition0$;
var inst_65289 = (inst_65288 & (64));
var inst_65290 = inst_65283.cljs$core$ISeq$;
var inst_65291 = (cljs.core.PROTOCOL_SENTINEL === inst_65290);
var inst_65292 = ((inst_65289) || (inst_65291));
var state_65382__$1 = state_65382;
if(cljs.core.truth_(inst_65292)){
var statearr_65409_65469 = state_65382__$1;
(statearr_65409_65469[(1)] = (9));

} else {
var statearr_65410_65470 = state_65382__$1;
(statearr_65410_65470[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (28))){
var inst_65338 = (state_65382[(2)]);
var inst_65339 = fluree.db.util.async.throw_err(inst_65338);
var state_65382__$1 = state_65382;
var statearr_65411_65471 = state_65382__$1;
(statearr_65411_65471[(2)] = inst_65339);

(statearr_65411_65471[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (25))){
var inst_65329 = (state_65382[(10)]);
var inst_65330 = (state_65382[(12)]);
var inst_65336 = fluree.db.query.block.block_range(db,inst_65329,inst_65330,opts);
var state_65382__$1 = state_65382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65382__$1,(28),inst_65336);
} else {
if((state_val_65383 === (34))){
var inst_65358 = (state_65382[(13)]);
var state_65382__$1 = state_65382;
var statearr_65412_65472 = state_65382__$1;
(statearr_65412_65472[(2)] = inst_65358);

(statearr_65412_65472[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (17))){
var state_65382__$1 = state_65382;
var statearr_65413_65473 = state_65382__$1;
(statearr_65413_65473[(2)] = false);

(statearr_65413_65473[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (3))){
var inst_65380 = (state_65382[(2)]);
var state_65382__$1 = state_65382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65382__$1,inst_65380);
} else {
if((state_val_65383 === (12))){
var inst_65283 = (state_65382[(15)]);
var inst_65301 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_65283);
var state_65382__$1 = state_65382;
var statearr_65414_65474 = state_65382__$1;
(statearr_65414_65474[(2)] = inst_65301);

(statearr_65414_65474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (2))){
var inst_65283 = (state_65382[(15)]);
var _ = (function (){var statearr_65415 = state_65382;
(statearr_65415[(4)] = cljs.core.cons((5),(state_65382[(4)])));

return statearr_65415;
})();
var inst_65282 = fluree.db.util.core.current_time_millis();
var inst_65283__$1 = db;
var inst_65285 = (inst_65283__$1 == null);
var inst_65286 = cljs.core.not(inst_65285);
var state_65382__$1 = (function (){var statearr_65416 = state_65382;
(statearr_65416[(17)] = inst_65282);

(statearr_65416[(15)] = inst_65283__$1);

return statearr_65416;
})();
if(inst_65286){
var statearr_65417_65475 = state_65382__$1;
(statearr_65417_65475[(1)] = (6));

} else {
var statearr_65418_65476 = state_65382__$1;
(statearr_65418_65476[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (23))){
var inst_65305 = (state_65382[(18)]);
var inst_65306 = (state_65382[(19)]);
var inst_65321 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65305),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65306)].join('');
var state_65382__$1 = state_65382;
var statearr_65419_65477 = state_65382__$1;
(statearr_65419_65477[(2)] = inst_65321);

(statearr_65419_65477[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (35))){
var inst_65377 = (state_65382[(2)]);
var _ = (function (){var statearr_65420 = state_65382;
(statearr_65420[(4)] = cljs.core.rest((state_65382[(4)])));

return statearr_65420;
})();
var state_65382__$1 = state_65382;
var statearr_65421_65478 = state_65382__$1;
(statearr_65421_65478[(2)] = inst_65377);

(statearr_65421_65478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (19))){
var inst_65310 = (state_65382[(8)]);
var inst_65318 = (state_65382[(16)]);
var inst_65318__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65310);
var state_65382__$1 = (function (){var statearr_65422 = state_65382;
(statearr_65422[(16)] = inst_65318__$1);

return statearr_65422;
})();
if(cljs.core.truth_(inst_65318__$1)){
var statearr_65423_65479 = state_65382__$1;
(statearr_65423_65479[(1)] = (22));

} else {
var statearr_65424_65480 = state_65382__$1;
(statearr_65424_65480[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (11))){
var inst_65296 = (state_65382[(2)]);
var state_65382__$1 = state_65382;
var statearr_65426_65481 = state_65382__$1;
(statearr_65426_65481[(2)] = inst_65296);

(statearr_65426_65481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (9))){
var state_65382__$1 = state_65382;
var statearr_65427_65482 = state_65382__$1;
(statearr_65427_65482[(2)] = true);

(statearr_65427_65482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (5))){
var _ = (function (){var statearr_65428 = state_65382;
(statearr_65428[(4)] = cljs.core.rest((state_65382[(4)])));

return statearr_65428;
})();
var state_65382__$1 = state_65382;
var ex65425 = (state_65382__$1[(2)]);
var statearr_65429_65483 = state_65382__$1;
(statearr_65429_65483[(5)] = ex65425);


var statearr_65430_65484 = state_65382__$1;
(statearr_65430_65484[(1)] = (4));

(statearr_65430_65484[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (14))){
var inst_65304 = (state_65382[(20)]);
var inst_65304__$1 = (state_65382[(2)]);
var inst_65305 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65304__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65306 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65304__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65307 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_65382__$1 = (function (){var statearr_65431 = state_65382;
(statearr_65431[(20)] = inst_65304__$1);

(statearr_65431[(18)] = inst_65305);

(statearr_65431[(19)] = inst_65306);

return statearr_65431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65382__$1,(15),inst_65307);
} else {
if((state_val_65383 === (26))){
var inst_65341 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_65342 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65341].join('');
var inst_65343 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65344 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65345 = cljs.core.PersistentHashMap.fromArrays(inst_65343,inst_65344);
var inst_65346 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65342,inst_65345);
var inst_65347 = (function(){throw inst_65346})();
var state_65382__$1 = state_65382;
var statearr_65432_65485 = state_65382__$1;
(statearr_65432_65485[(2)] = inst_65347);

(statearr_65432_65485[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (16))){
var inst_65310 = (state_65382[(8)]);
var inst_65313 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65310);
var state_65382__$1 = state_65382;
var statearr_65433_65486 = state_65382__$1;
(statearr_65433_65486[(2)] = inst_65313);

(statearr_65433_65486[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (38))){
var inst_65329 = (state_65382[(10)]);
var inst_65328 = (state_65382[(11)]);
var inst_65310 = (state_65382[(8)]);
var inst_65358 = (state_65382[(13)]);
var inst_65304 = (state_65382[(20)]);
var inst_65305 = (state_65382[(18)]);
var inst_65282 = (state_65382[(17)]);
var inst_65349 = (state_65382[(7)]);
var inst_65306 = (state_65382[(19)]);
var inst_65361 = (state_65382[(14)]);
var inst_65330 = (state_65382[(12)]);
var inst_65367 = (state_65382[(2)]);
var inst_65368 = (function (){var network = inst_65305;
var block_start = inst_65329;
var block_end = inst_65330;
var range = inst_65310;
var db_id = inst_65306;
var _ = inst_65328;
var start = inst_65282;
var result_SINGLEQUOTE_ = inst_65358;
var map__65278 = inst_65304;
var result = inst_65349;
var vec__65279 = inst_65310;
return (function (p1__65265_SHARP_){
var G__65434 = "%.2fms";
var G__65435 = p1__65265_SHARP_;
return goog.string.format(G__65434,G__65435);
});
})();
var inst_65369 = fluree.db.util.core.current_time_millis();
var inst_65370 = (inst_65369 - inst_65282);
var inst_65371 = (inst_65370 / (1000000));
var inst_65372 = (inst_65368.cljs$core$IFn$_invoke$arity$1 ? inst_65368.cljs$core$IFn$_invoke$arity$1(inst_65371) : inst_65368.call(null,inst_65371));
var inst_65373 = [(200),inst_65367,(100),inst_65372];
var inst_65374 = cljs.core.PersistentHashMap.fromArrays(inst_65361,inst_65373);
var state_65382__$1 = state_65382;
var statearr_65436_65487 = state_65382__$1;
(statearr_65436_65487[(2)] = inst_65374);

(statearr_65436_65487[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (30))){
var inst_65349 = (state_65382[(7)]);
var state_65382__$1 = state_65382;
var statearr_65437_65488 = state_65382__$1;
(statearr_65437_65488[(2)] = inst_65349);

(statearr_65437_65488[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (10))){
var state_65382__$1 = state_65382;
var statearr_65438_65489 = state_65382__$1;
(statearr_65438_65489[(2)] = false);

(statearr_65438_65489[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (18))){
var inst_65316 = (state_65382[(2)]);
var state_65382__$1 = state_65382;
if(cljs.core.truth_(inst_65316)){
var statearr_65439_65490 = state_65382__$1;
(statearr_65439_65490[(1)] = (19));

} else {
var statearr_65440_65491 = state_65382__$1;
(statearr_65440_65491[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (37))){
var inst_65358 = (state_65382[(13)]);
var state_65382__$1 = state_65382;
var statearr_65441_65492 = state_65382__$1;
(statearr_65441_65492[(2)] = inst_65358);

(statearr_65441_65492[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65383 === (8))){
var inst_65299 = (state_65382[(2)]);
var state_65382__$1 = state_65382;
if(cljs.core.truth_(inst_65299)){
var statearr_65442_65493 = state_65382__$1;
(statearr_65442_65493[(1)] = (12));

} else {
var statearr_65443_65494 = state_65382__$1;
(statearr_65443_65494[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_65444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65444[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_65444[(1)] = (1));

return statearr_65444;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_65382){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_65382);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e65445){var ex__2417__auto__ = e65445;
var statearr_65446_65495 = state_65382;
(statearr_65446_65495[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_65382[(4)]))){
var statearr_65447_65496 = state_65382;
(statearr_65447_65496[(1)] = cljs.core.first((state_65382[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65497 = state_65382;
state_65382 = G__65497;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_65382){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_65382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_65448 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_65448[(6)] = c__2436__auto__);

return statearr_65448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__65499 = arguments.length;
switch (G__65499) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_65700){
var state_val_65701 = (state_65700[(1)]);
if((state_val_65701 === (7))){
var inst_65517 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65702_65786 = state_65700__$1;
(statearr_65702_65786[(2)] = inst_65517);

(statearr_65702_65786[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (59))){
var inst_65698 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65700__$1,inst_65698);
} else {
if((state_val_65701 === (20))){
var state_65700__$1 = state_65700;
var statearr_65703_65787 = state_65700__$1;
(statearr_65703_65787[(2)] = (-1));

(statearr_65703_65787[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (58))){
var inst_65690 = (state_65700[(7)]);
var state_65700__$1 = state_65700;
var statearr_65704_65788 = state_65700__$1;
(statearr_65704_65788[(2)] = inst_65690);

(statearr_65704_65788[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (27))){
var inst_65527 = (state_65700[(8)]);
var inst_65577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65578 = [inst_65527];
var inst_65579 = (new cljs.core.PersistentVector(null,1,(5),inst_65577,inst_65578,null));
var state_65700__$1 = state_65700;
var statearr_65705_65789 = state_65700__$1;
(statearr_65705_65789[(2)] = inst_65579);

(statearr_65705_65789[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (1))){
var inst_65504 = (state_65700[(9)]);
var inst_65504__$1 = query_map;
var inst_65506 = (inst_65504__$1 == null);
var inst_65507 = cljs.core.not(inst_65506);
var state_65700__$1 = (function (){var statearr_65706 = state_65700;
(statearr_65706[(9)] = inst_65504__$1);

return statearr_65706;
})();
if(inst_65507){
var statearr_65707_65790 = state_65700__$1;
(statearr_65707_65790[(1)] = (2));

} else {
var statearr_65708_65791 = state_65700__$1;
(statearr_65708_65791[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (24))){
var inst_65531 = (state_65700[(10)]);
var inst_65572 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65531);
var state_65700__$1 = state_65700;
var statearr_65709_65792 = state_65700__$1;
(statearr_65709_65792[(2)] = inst_65572);

(statearr_65709_65792[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (55))){
var inst_65548 = (state_65700[(11)]);
var inst_65690 = (state_65700[(2)]);
var state_65700__$1 = (function (){var statearr_65710 = state_65700;
(statearr_65710[(7)] = inst_65690);

return statearr_65710;
})();
if(cljs.core.truth_(inst_65548)){
var statearr_65711_65793 = state_65700__$1;
(statearr_65711_65793[(1)] = (57));

} else {
var statearr_65712_65794 = state_65700__$1;
(statearr_65712_65794[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (39))){
var inst_65608 = (state_65700[(12)]);
var inst_65623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65624 = [inst_65608,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_65625 = (new cljs.core.PersistentVector(null,2,(5),inst_65623,inst_65624,null));
var state_65700__$1 = state_65700;
var statearr_65713_65795 = state_65700__$1;
(statearr_65713_65795[(2)] = inst_65625);

(statearr_65713_65795[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (46))){
var state_65700__$1 = state_65700;
var statearr_65714_65796 = state_65700__$1;
(statearr_65714_65796[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (4))){
var inst_65520 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
if(cljs.core.truth_(inst_65520)){
var statearr_65716_65797 = state_65700__$1;
(statearr_65716_65797[(1)] = (8));

} else {
var statearr_65717_65798 = state_65700__$1;
(statearr_65717_65798[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (54))){
var inst_65682 = (state_65700[(13)]);
var state_65700__$1 = state_65700;
var statearr_65718_65799 = state_65700__$1;
(statearr_65718_65799[(2)] = inst_65682);

(statearr_65718_65799[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (15))){
var inst_65535 = (state_65700[(2)]);
var inst_65536 = fluree.db.util.async.throw_err(inst_65535);
var state_65700__$1 = state_65700;
var statearr_65719_65800 = state_65700__$1;
(statearr_65719_65800[(2)] = inst_65536);

(statearr_65719_65800[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (48))){
var inst_65527 = (state_65700[(8)]);
var inst_65655 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65527)].join('');
var inst_65656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65657 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65658 = cljs.core.PersistentHashMap.fromArrays(inst_65656,inst_65657);
var inst_65659 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65655,inst_65658);
var inst_65660 = (function(){throw inst_65659})();
var state_65700__$1 = state_65700;
var statearr_65720_65801 = state_65700__$1;
(statearr_65720_65801[(2)] = inst_65660);

(statearr_65720_65801[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (50))){
var inst_65663 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65721_65802 = state_65700__$1;
(statearr_65721_65802[(2)] = inst_65663);

(statearr_65721_65802[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (21))){
var inst_65541 = (state_65700[(14)]);
var inst_65564 = (state_65700[(2)]);
var state_65700__$1 = (function (){var statearr_65722 = state_65700;
(statearr_65722[(15)] = inst_65564);

return statearr_65722;
})();
if(cljs.core.truth_(inst_65541)){
var statearr_65723_65803 = state_65700__$1;
(statearr_65723_65803[(1)] = (23));

} else {
var statearr_65724_65804 = state_65700__$1;
(statearr_65724_65804[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (31))){
var state_65700__$1 = state_65700;
var statearr_65725_65805 = state_65700__$1;
(statearr_65725_65805[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (32))){
var inst_65606 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65727_65806 = state_65700__$1;
(statearr_65727_65806[(2)] = inst_65606);

(statearr_65727_65806[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (40))){
var inst_65616 = (state_65700[(16)]);
var inst_65617 = (state_65700[(17)]);
var inst_65618 = (state_65700[(18)]);
var inst_65627 = (inst_65616 == null);
var inst_65628 = (inst_65617 == null);
var inst_65629 = cljs.core.not(inst_65628);
var inst_65630 = (inst_65618 == null);
var inst_65631 = ((inst_65627) && (inst_65629) && (inst_65630));
var state_65700__$1 = state_65700;
if(cljs.core.truth_(inst_65631)){
var statearr_65728_65807 = state_65700__$1;
(statearr_65728_65807[(1)] = (42));

} else {
var statearr_65729_65808 = state_65700__$1;
(statearr_65729_65808[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (56))){
var inst_65686 = (state_65700[(2)]);
var inst_65687 = fluree.db.util.async.throw_err(inst_65686);
var state_65700__$1 = state_65700;
var statearr_65730_65809 = state_65700__$1;
(statearr_65730_65809[(2)] = inst_65687);

(statearr_65730_65809[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (33))){
var inst_65527 = (state_65700[(8)]);
var inst_65585 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65527)].join('');
var inst_65586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65587 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65588 = cljs.core.PersistentHashMap.fromArrays(inst_65586,inst_65587);
var inst_65589 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65585,inst_65588);
var inst_65590 = (function(){throw inst_65589})();
var state_65700__$1 = state_65700;
var statearr_65731_65810 = state_65700__$1;
(statearr_65731_65810[(2)] = inst_65590);

(statearr_65731_65810[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (13))){
var state_65700__$1 = state_65700;
var statearr_65732_65811 = state_65700__$1;
(statearr_65732_65811[(2)] = null);

(statearr_65732_65811[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (22))){
var inst_65558 = (state_65700[(2)]);
var inst_65559 = fluree.db.util.async.throw_err(inst_65558);
var inst_65560 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65559);
var inst_65561 = (inst_65560 - (1));
var state_65700__$1 = state_65700;
var statearr_65733_65812 = state_65700__$1;
(statearr_65733_65812[(2)] = inst_65561);

(statearr_65733_65812[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (36))){
var inst_65527 = (state_65700[(8)]);
var inst_65596 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65527)].join('');
var inst_65597 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65598 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65599 = cljs.core.PersistentHashMap.fromArrays(inst_65597,inst_65598);
var inst_65600 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65596,inst_65599);
var inst_65601 = (function(){throw inst_65600})();
var state_65700__$1 = state_65700;
var statearr_65734_65813 = state_65700__$1;
(statearr_65734_65813[(2)] = inst_65601);

(statearr_65734_65813[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (41))){
var inst_65531 = (state_65700[(10)]);
var inst_65564 = (state_65700[(15)]);
var inst_65574 = (state_65700[(19)]);
var inst_65669 = (state_65700[(2)]);
var inst_65670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65669,(0),null);
var inst_65671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65669,(1),null);
var inst_65672 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_65673 = [inst_65564,inst_65574];
var inst_65674 = cljs.core.PersistentHashMap.fromArrays(inst_65672,inst_65673);
var inst_65675 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_65531,inst_65671,cljs.core._EQ_,inst_65670,inst_65674);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(51),inst_65675);
} else {
if((state_val_65701 === (43))){
var inst_65616 = (state_65700[(16)]);
var inst_65617 = (state_65700[(17)]);
var inst_65618 = (state_65700[(18)]);
var inst_65640 = (inst_65616 == null);
var inst_65641 = (inst_65617 == null);
var inst_65642 = cljs.core.not(inst_65641);
var inst_65643 = (inst_65618 == null);
var inst_65644 = cljs.core.not(inst_65643);
var inst_65645 = ((inst_65640) && (inst_65642) && (inst_65644));
var state_65700__$1 = state_65700;
if(cljs.core.truth_(inst_65645)){
var statearr_65735_65814 = state_65700__$1;
(statearr_65735_65814[(1)] = (45));

} else {
var statearr_65736_65815 = state_65700__$1;
(statearr_65736_65815[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (29))){
var inst_65616 = (state_65700[(16)]);
var inst_65608 = (state_65700[(12)]);
var inst_65608__$1 = (state_65700[(2)]);
var inst_65609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65608__$1,(0));
var inst_65611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65608__$1,(1));
var inst_65612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65608__$1,(2));
var inst_65613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65608__$1,(3));
var inst_65614 = [inst_65610,inst_65611,inst_65612,inst_65613];
var inst_65615 = (new cljs.core.PersistentVector(null,4,(5),inst_65609,inst_65614,null));
var inst_65616__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65615,(0),null);
var inst_65617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65615,(1),null);
var inst_65618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65615,(2),null);
var inst_65619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65615,(3),null);
var inst_65620 = (inst_65616__$1 == null);
var inst_65621 = cljs.core.not(inst_65620);
var state_65700__$1 = (function (){var statearr_65737 = state_65700;
(statearr_65737[(20)] = inst_65619);

(statearr_65737[(16)] = inst_65616__$1);

(statearr_65737[(12)] = inst_65608__$1);

(statearr_65737[(17)] = inst_65617);

(statearr_65737[(18)] = inst_65618);

return statearr_65737;
})();
if(inst_65621){
var statearr_65738_65816 = state_65700__$1;
(statearr_65738_65816[(1)] = (39));

} else {
var statearr_65739_65817 = state_65700__$1;
(statearr_65739_65817[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (44))){
var inst_65667 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65740_65818 = state_65700__$1;
(statearr_65740_65818[(2)] = inst_65667);

(statearr_65740_65818[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (6))){
var state_65700__$1 = state_65700;
var statearr_65741_65819 = state_65700__$1;
(statearr_65741_65819[(2)] = false);

(statearr_65741_65819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (28))){
var inst_65527 = (state_65700[(8)]);
var inst_65581 = cljs.core.sequential_QMARK_(inst_65527);
var state_65700__$1 = state_65700;
if(inst_65581){
var statearr_65742_65820 = state_65700__$1;
(statearr_65742_65820[(1)] = (30));

} else {
var statearr_65743_65821 = state_65700__$1;
(statearr_65743_65821[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (51))){
var inst_65531 = (state_65700[(10)]);
var inst_65678 = (state_65700[(21)]);
var inst_65677 = (state_65700[(2)]);
var inst_65678__$1 = fluree.db.util.async.throw_err(inst_65677);
var inst_65679 = fluree.db.api_js.format_history_resp(inst_65531,inst_65678__$1);
var state_65700__$1 = (function (){var statearr_65744 = state_65700;
(statearr_65744[(21)] = inst_65678__$1);

return statearr_65744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(52),inst_65679);
} else {
if((state_val_65701 === (25))){
var inst_65527 = (state_65700[(8)]);
var inst_65574 = (state_65700[(2)]);
var inst_65575 = fluree.db.util.core.subj_ident_QMARK_(inst_65527);
var state_65700__$1 = (function (){var statearr_65745 = state_65700;
(statearr_65745[(19)] = inst_65574);

return statearr_65745;
})();
if(inst_65575){
var statearr_65746_65822 = state_65700__$1;
(statearr_65746_65822[(1)] = (27));

} else {
var statearr_65747_65823 = state_65700__$1;
(statearr_65747_65823[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (34))){
var inst_65527 = (state_65700[(8)]);
var state_65700__$1 = state_65700;
var statearr_65748_65824 = state_65700__$1;
(statearr_65748_65824[(2)] = inst_65527);

(statearr_65748_65824[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (17))){
var inst_65540 = (state_65700[(22)]);
var state_65700__$1 = state_65700;
var statearr_65749_65825 = state_65700__$1;
(statearr_65749_65825[(2)] = inst_65540);

(statearr_65749_65825[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (3))){
var state_65700__$1 = state_65700;
var statearr_65750_65826 = state_65700__$1;
(statearr_65750_65826[(2)] = false);

(statearr_65750_65826[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (12))){
var inst_65531 = (state_65700[(10)]);
var inst_65533 = fluree.db.api_js.resolve_block_range(inst_65531,query_map);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(15),inst_65533);
} else {
if((state_val_65701 === (2))){
var inst_65504 = (state_65700[(9)]);
var inst_65509 = inst_65504.cljs$lang$protocol_mask$partition0$;
var inst_65510 = (inst_65509 & (64));
var inst_65511 = inst_65504.cljs$core$ISeq$;
var inst_65512 = (cljs.core.PROTOCOL_SENTINEL === inst_65511);
var inst_65513 = ((inst_65510) || (inst_65512));
var state_65700__$1 = state_65700;
if(cljs.core.truth_(inst_65513)){
var statearr_65751_65827 = state_65700__$1;
(statearr_65751_65827[(1)] = (5));

} else {
var statearr_65752_65828 = state_65700__$1;
(statearr_65752_65828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (23))){
var inst_65531 = (state_65700[(10)]);
var inst_65541 = (state_65700[(14)]);
var inst_65566 = fluree.db.time_travel.as_of_block(inst_65531,inst_65541);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(26),inst_65566);
} else {
if((state_val_65701 === (47))){
var inst_65665 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65753_65829 = state_65700__$1;
(statearr_65753_65829[(2)] = inst_65665);

(statearr_65753_65829[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (35))){
var inst_65593 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65754_65830 = state_65700__$1;
(statearr_65754_65830[(2)] = inst_65593);

(statearr_65754_65830[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (19))){
var inst_65531 = (state_65700[(10)]);
var inst_65540 = (state_65700[(22)]);
var inst_65555 = (inst_65540 - (1));
var inst_65556 = fluree.db.time_travel.as_of_block(inst_65531,inst_65555);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(22),inst_65556);
} else {
if((state_val_65701 === (57))){
var inst_65690 = (state_65700[(7)]);
var inst_65678 = (state_65700[(21)]);
var inst_65692 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_65693 = cljs.core.count(inst_65678);
var inst_65694 = [inst_65690,inst_65693,(200)];
var inst_65695 = cljs.core.PersistentHashMap.fromArrays(inst_65692,inst_65694);
var state_65700__$1 = state_65700;
var statearr_65755_65831 = state_65700__$1;
(statearr_65755_65831[(2)] = inst_65695);

(statearr_65755_65831[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (11))){
var inst_65526 = (state_65700[(23)]);
var inst_65530 = (state_65700[(2)]);
var inst_65531 = fluree.db.util.async.throw_err(inst_65530);
var state_65700__$1 = (function (){var statearr_65756 = state_65700;
(statearr_65756[(10)] = inst_65531);

return statearr_65756;
})();
if(cljs.core.truth_(inst_65526)){
var statearr_65757_65832 = state_65700__$1;
(statearr_65757_65832[(1)] = (12));

} else {
var statearr_65758_65833 = state_65700__$1;
(statearr_65758_65833[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (9))){
var inst_65504 = (state_65700[(9)]);
var state_65700__$1 = state_65700;
var statearr_65759_65834 = state_65700__$1;
(statearr_65759_65834[(2)] = inst_65504);

(statearr_65759_65834[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (5))){
var state_65700__$1 = state_65700;
var statearr_65760_65835 = state_65700__$1;
(statearr_65760_65835[(2)] = true);

(statearr_65760_65835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (14))){
var inst_65540 = (state_65700[(22)]);
var inst_65539 = (state_65700[(2)]);
var inst_65540__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65539,(0),null);
var inst_65541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65539,(1),null);
var inst_65548 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65700__$1 = (function (){var statearr_65761 = state_65700;
(statearr_65761[(11)] = inst_65548);

(statearr_65761[(22)] = inst_65540__$1);

(statearr_65761[(14)] = inst_65541);

return statearr_65761;
})();
if(cljs.core.truth_(inst_65540__$1)){
var statearr_65762_65836 = state_65700__$1;
(statearr_65762_65836[(1)] = (16));

} else {
var statearr_65763_65837 = state_65700__$1;
(statearr_65763_65837[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (45))){
var inst_65619 = (state_65700[(20)]);
var inst_65616 = (state_65700[(16)]);
var inst_65617 = (state_65700[(17)]);
var inst_65618 = (state_65700[(18)]);
var inst_65647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65649 = [inst_65617,inst_65618,inst_65616,inst_65619];
var inst_65650 = (new cljs.core.PersistentVector(null,4,(5),inst_65648,inst_65649,null));
var inst_65651 = [inst_65650,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_65652 = (new cljs.core.PersistentVector(null,2,(5),inst_65647,inst_65651,null));
var state_65700__$1 = state_65700;
var statearr_65764_65838 = state_65700__$1;
(statearr_65764_65838[(2)] = inst_65652);

(statearr_65764_65838[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (53))){
var inst_65682 = (state_65700[(13)]);
var inst_65531 = (state_65700[(10)]);
var inst_65684 = fluree.db.api_js.format_block_resp_pretty(inst_65531,inst_65682);
var state_65700__$1 = state_65700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(56),inst_65684);
} else {
if((state_val_65701 === (26))){
var inst_65568 = (state_65700[(2)]);
var inst_65569 = fluree.db.util.async.throw_err(inst_65568);
var inst_65570 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_65569);
var state_65700__$1 = state_65700;
var statearr_65765_65839 = state_65700__$1;
(statearr_65765_65839[(2)] = inst_65570);

(statearr_65765_65839[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (16))){
var inst_65540 = (state_65700[(22)]);
var inst_65550 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65540);
var state_65700__$1 = state_65700;
var statearr_65766_65840 = state_65700__$1;
(statearr_65766_65840[(2)] = inst_65550);

(statearr_65766_65840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (38))){
var inst_65604 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
var statearr_65767_65841 = state_65700__$1;
(statearr_65767_65841[(2)] = inst_65604);

(statearr_65767_65841[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (30))){
var inst_65527 = (state_65700[(8)]);
var inst_65583 = cljs.core.empty_QMARK_(inst_65527);
var state_65700__$1 = state_65700;
if(inst_65583){
var statearr_65768_65842 = state_65700__$1;
(statearr_65768_65842[(1)] = (33));

} else {
var statearr_65769_65843 = state_65700__$1;
(statearr_65769_65843[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (10))){
var inst_65525 = (state_65700[(2)]);
var inst_65526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65525,new cljs.core.Keyword(null,"block","block",664686210));
var inst_65527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65525,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_65528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65525,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_65700__$1 = (function (){var statearr_65770 = state_65700;
(statearr_65770[(23)] = inst_65526);

(statearr_65770[(8)] = inst_65527);

(statearr_65770[(24)] = inst_65528);

return statearr_65770;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65700__$1,(11),sources);
} else {
if((state_val_65701 === (18))){
var inst_65553 = (state_65700[(2)]);
var state_65700__$1 = state_65700;
if(cljs.core.truth_(inst_65553)){
var statearr_65771_65844 = state_65700__$1;
(statearr_65771_65844[(1)] = (19));

} else {
var statearr_65772_65845 = state_65700__$1;
(statearr_65772_65845[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (52))){
var inst_65528 = (state_65700[(24)]);
var inst_65681 = (state_65700[(2)]);
var inst_65682 = fluree.db.util.async.throw_err(inst_65681);
var state_65700__$1 = (function (){var statearr_65773 = state_65700;
(statearr_65773[(13)] = inst_65682);

return statearr_65773;
})();
if(cljs.core.truth_(inst_65528)){
var statearr_65774_65846 = state_65700__$1;
(statearr_65774_65846[(1)] = (53));

} else {
var statearr_65775_65847 = state_65700__$1;
(statearr_65775_65847[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (42))){
var inst_65619 = (state_65700[(20)]);
var inst_65616 = (state_65700[(16)]);
var inst_65617 = (state_65700[(17)]);
var inst_65618 = (state_65700[(18)]);
var inst_65633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65635 = [inst_65617,inst_65616,inst_65618,inst_65619];
var inst_65636 = (new cljs.core.PersistentVector(null,4,(5),inst_65634,inst_65635,null));
var inst_65637 = [inst_65636,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_65638 = (new cljs.core.PersistentVector(null,2,(5),inst_65633,inst_65637,null));
var state_65700__$1 = state_65700;
var statearr_65776_65848 = state_65700__$1;
(statearr_65776_65848[(2)] = inst_65638);

(statearr_65776_65848[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (37))){
var state_65700__$1 = state_65700;
var statearr_65777_65849 = state_65700__$1;
(statearr_65777_65849[(2)] = null);

(statearr_65777_65849[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (8))){
var inst_65504 = (state_65700[(9)]);
var inst_65522 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_65504);
var state_65700__$1 = state_65700;
var statearr_65778_65850 = state_65700__$1;
(statearr_65778_65850[(2)] = inst_65522);

(statearr_65778_65850[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65701 === (49))){
var state_65700__$1 = state_65700;
var statearr_65779_65851 = state_65700__$1;
(statearr_65779_65851[(2)] = null);

(statearr_65779_65851[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_65780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65780[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_65780[(1)] = (1));

return statearr_65780;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_65700){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_65700);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e65781){var ex__2417__auto__ = e65781;
var statearr_65782_65852 = state_65700;
(statearr_65782_65852[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_65700[(4)]))){
var statearr_65783_65853 = state_65700;
(statearr_65783_65853[(1)] = cljs.core.first((state_65700[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65854 = state_65700;
state_65700 = G__65854;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_65700){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_65700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_65784 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_65784[(6)] = c__2436__auto__);

return statearr_65784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__65862 = arguments.length;
switch (G__65862) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__65855_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__65855_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_65951){
var state_val_65952 = (state_65951[(1)]);
if((state_val_65952 === (7))){
var inst_65908 = (state_65951[(7)]);
var inst_65905 = (state_65951[(8)]);
var inst_65902 = (state_65951[(9)]);
var inst_65912 = (state_65951[(10)]);
var inst_65918 = (function (){var responses = inst_65902;
var responses_STAR_ = inst_65905;
var statuses = inst_65908;
var fuel = inst_65912;
return (function (p1__65858_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__65858_SHARP_);
});
})();
var inst_65919 = cljs.core.some(inst_65918,inst_65908);
var state_65951__$1 = state_65951;
if(cljs.core.truth_(inst_65919)){
var statearr_65953_66001 = state_65951__$1;
(statearr_65953_66001[(1)] = (9));

} else {
var statearr_65954_66002 = state_65951__$1;
(statearr_65954_66002[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (20))){
var inst_65946 = (state_65951[(2)]);
var state_65951__$1 = state_65951;
var statearr_65955_66003 = state_65951__$1;
(statearr_65955_66003[(2)] = inst_65946);

(statearr_65955_66003[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (1))){
var inst_65897 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_65898 = (function (){var c__2436__auto____$1 = inst_65897;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_65895){
var state_val_65896 = (state_65895[(1)]);
if((state_val_65896 === (1))){
var inst_65863 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_65864 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_65865 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65864,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_65866 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_65867 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_65868 = cljs.core.PersistentHashMap.EMPTY;
var inst_65869 = inst_65863;
var inst_65870 = inst_65865;
var inst_65871 = inst_65866;
var inst_65872 = inst_65867;
var inst_65873 = inst_65868;
var state_65895__$1 = (function (){var statearr_65956 = state_65895;
(statearr_65956[(7)] = inst_65872);

(statearr_65956[(8)] = inst_65870);

(statearr_65956[(9)] = inst_65873);

(statearr_65956[(10)] = inst_65871);

(statearr_65956[(11)] = inst_65869);

return statearr_65956;
})();
var statearr_65957_66004 = state_65895__$1;
(statearr_65957_66004[(2)] = null);

(statearr_65957_66004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65896 === (2))){
var inst_65870 = (state_65895[(8)]);
var inst_65875 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_65870);
var inst_65876 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_65875], 0));
var inst_65877 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65870,new cljs.core.Keyword(null,"opts","opts",155075701),inst_65876);
var inst_65878 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_65877,db_fn);
var state_65895__$1 = state_65895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65895__$1,(4),inst_65878);
} else {
if((state_val_65896 === (3))){
var inst_65893 = (state_65895[(2)]);
var state_65895__$1 = state_65895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65895__$1,inst_65893);
} else {
if((state_val_65896 === (4))){
var inst_65873 = (state_65895[(9)]);
var inst_65871 = (state_65895[(10)]);
var inst_65869 = (state_65895[(11)]);
var inst_65880 = (state_65895[(2)]);
var inst_65881 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65873,inst_65869,inst_65880);
var inst_65882 = cljs.core.first(inst_65871);
var state_65895__$1 = (function (){var statearr_65958 = state_65895;
(statearr_65958[(12)] = inst_65881);

return statearr_65958;
})();
if(cljs.core.truth_(inst_65882)){
var statearr_65959_66005 = state_65895__$1;
(statearr_65959_66005[(1)] = (5));

} else {
var statearr_65960_66006 = state_65895__$1;
(statearr_65960_66006[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65896 === (5))){
var inst_65872 = (state_65895[(7)]);
var inst_65881 = (state_65895[(12)]);
var inst_65871 = (state_65895[(10)]);
var inst_65884 = cljs.core.first(inst_65871);
var inst_65885 = cljs.core.first(inst_65872);
var inst_65886 = cljs.core.rest(inst_65871);
var inst_65887 = cljs.core.rest(inst_65872);
var inst_65869 = inst_65884;
var inst_65870 = inst_65885;
var inst_65871__$1 = inst_65886;
var inst_65872__$1 = inst_65887;
var inst_65873 = inst_65881;
var state_65895__$1 = (function (){var statearr_65961 = state_65895;
(statearr_65961[(7)] = inst_65872__$1);

(statearr_65961[(8)] = inst_65870);

(statearr_65961[(9)] = inst_65873);

(statearr_65961[(10)] = inst_65871__$1);

(statearr_65961[(11)] = inst_65869);

return statearr_65961;
})();
var statearr_65962_66007 = state_65895__$1;
(statearr_65962_66007[(2)] = null);

(statearr_65962_66007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65896 === (6))){
var inst_65881 = (state_65895[(12)]);
var state_65895__$1 = state_65895;
var statearr_65963_66008 = state_65895__$1;
(statearr_65963_66008[(2)] = inst_65881);

(statearr_65963_66008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65896 === (7))){
var inst_65891 = (state_65895[(2)]);
var state_65895__$1 = state_65895;
var statearr_65964_66009 = state_65895__$1;
(statearr_65964_66009[(2)] = inst_65891);

(statearr_65964_66009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_65965 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65965[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_65965[(1)] = (1));

return statearr_65965;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_65895){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_65895);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e65966){var ex__2417__auto__ = e65966;
var statearr_65967_66010 = state_65895;
(statearr_65967_66010[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_65895[(4)]))){
var statearr_65968_66011 = state_65895;
(statearr_65968_66011[(1)] = cljs.core.first((state_65895[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66012 = state_65895;
state_65895 = G__66012;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_65895){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_65895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_65969 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_65969[(6)] = c__2436__auto____$1);

return statearr_65969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_65899 = cljs.core.async.impl.dispatch.run(inst_65898);
var state_65951__$1 = (function (){var statearr_65970 = state_65951;
(statearr_65970[(11)] = inst_65899);

return statearr_65970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65951__$1,(2),inst_65897);
} else {
if((state_val_65952 === (4))){
var inst_65902 = (state_65951[(9)]);
var state_65951__$1 = state_65951;
var statearr_65971_66013 = state_65951__$1;
(statearr_65971_66013[(2)] = inst_65902);

(statearr_65971_66013[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (15))){
var state_65951__$1 = state_65951;
var statearr_65972_66014 = state_65951__$1;
(statearr_65972_66014[(2)] = (400));

(statearr_65972_66014[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (13))){
var state_65951__$1 = state_65951;
var statearr_65973_66015 = state_65951__$1;
(statearr_65973_66015[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (6))){
var inst_65908 = (state_65951[(7)]);
var inst_65916 = cljs.core.first(inst_65908);
var state_65951__$1 = state_65951;
var statearr_65975_66016 = state_65951__$1;
(statearr_65975_66016[(2)] = inst_65916);

(statearr_65975_66016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (17))){
var inst_65929 = (state_65951[(2)]);
var state_65951__$1 = state_65951;
var statearr_65976_66017 = state_65951__$1;
(statearr_65976_66017[(2)] = inst_65929);

(statearr_65976_66017[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (3))){
var inst_65908 = (state_65951[(7)]);
var inst_65905 = (state_65951[(8)]);
var inst_65902 = (state_65951[(9)]);
var inst_65912 = (state_65951[(10)]);
var inst_65907 = cljs.core.vals(inst_65902);
var inst_65908__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_65907);
var inst_65909 = (function (){var responses = inst_65902;
var responses_STAR_ = inst_65905;
var statuses = inst_65908__$1;
return (function (p1__65856_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__65856_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_65910 = cljs.core.vals(inst_65902);
var inst_65911 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65909,inst_65910);
var inst_65912__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_65911);
var inst_65913 = (function (){var responses = inst_65902;
var responses_STAR_ = inst_65905;
var statuses = inst_65908__$1;
var fuel = inst_65912__$1;
return (function (p1__65857_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__65857_SHARP_);
});
})();
var inst_65914 = cljs.core.every_QMARK_(inst_65913,inst_65908__$1);
var state_65951__$1 = (function (){var statearr_65977 = state_65951;
(statearr_65977[(7)] = inst_65908__$1);

(statearr_65977[(10)] = inst_65912__$1);

return statearr_65977;
})();
if(inst_65914){
var statearr_65978_66018 = state_65951__$1;
(statearr_65978_66018[(1)] = (6));

} else {
var statearr_65979_66019 = state_65951__$1;
(statearr_65979_66019[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (12))){
var state_65951__$1 = state_65951;
var statearr_65980_66020 = state_65951__$1;
(statearr_65980_66020[(2)] = (500));

(statearr_65980_66020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (2))){
var inst_65902 = (state_65951[(9)]);
var inst_65901 = (state_65951[(2)]);
var inst_65902__$1 = fluree.db.util.async.throw_err(inst_65901);
var inst_65903 = (function (){var responses = inst_65902__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_65904 = cljs.core.PersistentHashMap.EMPTY;
var inst_65905 = cljs.core.reduce_kv(inst_65903,inst_65904,inst_65902__$1);
var state_65951__$1 = (function (){var statearr_65981 = state_65951;
(statearr_65981[(8)] = inst_65905);

(statearr_65981[(9)] = inst_65902__$1);

return statearr_65981;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65982_66021 = state_65951__$1;
(statearr_65982_66021[(1)] = (3));

} else {
var statearr_65983_66022 = state_65951__$1;
(statearr_65983_66022[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (19))){
var inst_65905 = (state_65951[(8)]);
var inst_65912 = (state_65951[(10)]);
var inst_65935 = (state_65951[(12)]);
var inst_65944 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65905,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65935,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65912], 0));
var state_65951__$1 = state_65951;
var statearr_65984_66023 = state_65951__$1;
(statearr_65984_66023[(2)] = inst_65944);

(statearr_65984_66023[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (11))){
var inst_65933 = (state_65951[(2)]);
var state_65951__$1 = state_65951;
var statearr_65985_66024 = state_65951__$1;
(statearr_65985_66024[(2)] = inst_65933);

(statearr_65985_66024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (9))){
var state_65951__$1 = state_65951;
var statearr_65986_66025 = state_65951__$1;
(statearr_65986_66025[(2)] = (207));

(statearr_65986_66025[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (5))){
var inst_65949 = (state_65951[(2)]);
var state_65951__$1 = state_65951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65951__$1,inst_65949);
} else {
if((state_val_65952 === (14))){
var inst_65931 = (state_65951[(2)]);
var state_65951__$1 = state_65951;
var statearr_65987_66026 = state_65951__$1;
(statearr_65987_66026[(2)] = inst_65931);

(statearr_65987_66026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (16))){
var state_65951__$1 = state_65951;
var statearr_65988_66027 = state_65951__$1;
(statearr_65988_66027[(2)] = null);

(statearr_65988_66027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (10))){
var inst_65908 = (state_65951[(7)]);
var inst_65905 = (state_65951[(8)]);
var inst_65902 = (state_65951[(9)]);
var inst_65912 = (state_65951[(10)]);
var inst_65922 = (function (){var responses = inst_65902;
var responses_STAR_ = inst_65905;
var statuses = inst_65908;
var fuel = inst_65912;
return (function (p1__65859_SHARP_){
return ((499) < p1__65859_SHARP_);
});
})();
var inst_65923 = cljs.core.some(inst_65922,inst_65908);
var state_65951__$1 = state_65951;
if(cljs.core.truth_(inst_65923)){
var statearr_65989_66028 = state_65951__$1;
(statearr_65989_66028[(1)] = (12));

} else {
var statearr_65990_66029 = state_65951__$1;
(statearr_65990_66029[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (18))){
var inst_65905 = (state_65951[(8)]);
var inst_65912 = (state_65951[(10)]);
var inst_65935 = (state_65951[(12)]);
var inst_65940 = (state_65951[(13)]);
var inst_65942 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_65905,new cljs.core.Keyword(null,"status","status",-1997798413),inst_65935,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_65912,new cljs.core.Keyword(null,"block","block",664686210),inst_65940], 0));
var state_65951__$1 = state_65951;
var statearr_65991_66030 = state_65951__$1;
(statearr_65991_66030[(2)] = inst_65942);

(statearr_65991_66030[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65952 === (8))){
var inst_65908 = (state_65951[(7)]);
var inst_65905 = (state_65951[(8)]);
var inst_65902 = (state_65951[(9)]);
var inst_65912 = (state_65951[(10)]);
var inst_65935 = (state_65951[(12)]);
var inst_65940 = (state_65951[(13)]);
var inst_65935__$1 = (state_65951[(2)]);
var inst_65936 = (function (){var responses = inst_65902;
var responses_STAR_ = inst_65905;
var statuses = inst_65908;
var fuel = inst_65912;
var status = inst_65935__$1;
return (function (p1__65860_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__65860_SHARP_));
});
})();
var inst_65937 = cljs.core.vals(inst_65902);
var inst_65938 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65936,inst_65937);
var inst_65939 = cljs.core.first(inst_65938);
var inst_65940__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65939);
var state_65951__$1 = (function (){var statearr_65992 = state_65951;
(statearr_65992[(12)] = inst_65935__$1);

(statearr_65992[(13)] = inst_65940__$1);

return statearr_65992;
})();
if(cljs.core.truth_(inst_65940__$1)){
var statearr_65993_66031 = state_65951__$1;
(statearr_65993_66031[(1)] = (18));

} else {
var statearr_65994_66032 = state_65951__$1;
(statearr_65994_66032[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_65995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65995[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_65995[(1)] = (1));

return statearr_65995;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_65951){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_65951);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e65996){var ex__2417__auto__ = e65996;
var statearr_65997_66033 = state_65951;
(statearr_65997_66033[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_65951[(4)]))){
var statearr_65998_66034 = state_65951;
(statearr_65998_66034[(1)] = cljs.core.first((state_65951[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66035 = state_65951;
state_65951 = G__66035;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_65951){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_65951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_65999 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_65999[(6)] = c__2436__auto__);

return statearr_65999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__66037 = arguments.length;
switch (G__66037) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__66038 = opts;
var map__66038__$1 = (((((!((map__66038 == null))))?(((((map__66038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66038):map__66038);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66038__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66038__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66038__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66038__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.db.util.account_id.from_private_key.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.account_id.from_private_key.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.db.util.account_id.from_private_key.call(null,private_key));
var vec__66039 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66039,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66039,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e66043){var e = e66043;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.secp256k1.sign_message(cmd,private_key);
var id = fluree.crypto.sha3.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__66046 = arguments.length;
switch (G__66046) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66077){
var state_val_66078 = (state_66077[(1)]);
if((state_val_66078 === (7))){
var state_66077__$1 = state_66077;
var statearr_66079_66100 = state_66077__$1;
(statearr_66079_66100[(2)] = opts);

(statearr_66079_66100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (1))){
var state_66077__$1 = state_66077;
var statearr_66080_66101 = state_66077__$1;
(statearr_66080_66101[(2)] = null);

(statearr_66080_66101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (4))){
var inst_66047 = (state_66077[(2)]);
var inst_66048 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66047], 0));
var inst_66049 = cljs.core.ex_data(inst_66047);
var inst_66050 = cljs.core.ex_message(inst_66047);
var inst_66051 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66049,new cljs.core.Keyword(null,"message","message",-406056002),inst_66050);
var state_66077__$1 = (function (){var statearr_66081 = state_66077;
(statearr_66081[(7)] = inst_66048);

return statearr_66081;
})();
var statearr_66082_66102 = state_66077__$1;
(statearr_66082_66102[(2)] = inst_66051);

(statearr_66082_66102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (6))){
var inst_66061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66062 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66063 = (new cljs.core.PersistentVector(null,1,(5),inst_66061,inst_66062,null));
var inst_66064 = cljs.core.assoc_in(opts,inst_66063,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66077__$1 = state_66077;
var statearr_66083_66103 = state_66077__$1;
(statearr_66083_66103[(2)] = inst_66064);

(statearr_66083_66103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (3))){
var inst_66075 = (state_66077[(2)]);
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66077__$1,inst_66075);
} else {
if((state_val_66078 === (2))){
var _ = (function (){var statearr_66085 = state_66077;
(statearr_66085[(4)] = cljs.core.cons((5),(state_66077[(4)])));

return statearr_66085;
})();
var inst_66057 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66058 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66059 = (inst_66058 == null);
var state_66077__$1 = (function (){var statearr_66086 = state_66077;
(statearr_66086[(8)] = inst_66057);

return statearr_66086;
})();
if(cljs.core.truth_(inst_66059)){
var statearr_66087_66104 = state_66077__$1;
(statearr_66087_66104[(1)] = (6));

} else {
var statearr_66088_66105 = state_66077__$1;
(statearr_66088_66105[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (9))){
var inst_66071 = (state_66077[(2)]);
var inst_66072 = fluree.db.util.async.throw_err(inst_66071);
var _ = (function (){var statearr_66089 = state_66077;
(statearr_66089[(4)] = cljs.core.rest((state_66077[(4)])));

return statearr_66089;
})();
var state_66077__$1 = state_66077;
var statearr_66090_66106 = state_66077__$1;
(statearr_66090_66106[(2)] = inst_66072);

(statearr_66090_66106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (5))){
var _ = (function (){var statearr_66091 = state_66077;
(statearr_66091[(4)] = cljs.core.rest((state_66077[(4)])));

return statearr_66091;
})();
var state_66077__$1 = state_66077;
var ex66084 = (state_66077__$1[(2)]);
var statearr_66092_66107 = state_66077__$1;
(statearr_66092_66107[(5)] = ex66084);


var statearr_66093_66108 = state_66077__$1;
(statearr_66093_66108[(1)] = (4));

(statearr_66093_66108[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66078 === (8))){
var inst_66057 = (state_66077[(8)]);
var inst_66067 = (state_66077[(2)]);
var inst_66068 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_66057,inst_66067);
var inst_66069 = fluree.db.operations.command_async(conn,inst_66068);
var state_66077__$1 = state_66077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66077__$1,(9),inst_66069);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2414__auto__ = null;
var fluree$db$api_js$state_machine__2414__auto____0 = (function (){
var statearr_66094 = [null,null,null,null,null,null,null,null,null];
(statearr_66094[(0)] = fluree$db$api_js$state_machine__2414__auto__);

(statearr_66094[(1)] = (1));

return statearr_66094;
});
var fluree$db$api_js$state_machine__2414__auto____1 = (function (state_66077){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66077);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66095){var ex__2417__auto__ = e66095;
var statearr_66096_66109 = state_66077;
(statearr_66096_66109[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66077[(4)]))){
var statearr_66097_66110 = state_66077;
(statearr_66097_66110[(1)] = cljs.core.first((state_66077[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66111 = state_66077;
state_66077 = G__66111;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2414__auto__ = function(state_66077){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2414__auto____1.call(this,state_66077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2414__auto____0;
fluree$db$api_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2414__auto____1;
return fluree$db$api_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66098 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66098[(6)] = c__2436__auto__);

return statearr_66098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

