// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62324_62493 = cljs.core.seq(servers);
var chunk__62325_62494 = null;
var count__62326_62495 = (0);
var i__62327_62496 = (0);
while(true){
if((i__62327_62496 < count__62326_62495)){
var server_62497 = chunk__62325_62494.cljs$core$IIndexed$_nth$arity$2(null,i__62327_62496);
var healthcheck_uri_62498 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62497),"/fdb/health"].join('');
var resp_chan_62499 = fluree.db.util.xhttp.post_json(healthcheck_uri_62498,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2436__auto___62500 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497){
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = ((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497){
return (function (state_62388){
var state_val_62389 = (state_62388[(1)]);
if((state_val_62389 === (1))){
var state_62388__$1 = state_62388;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62388__$1,(2),resp_chan_62499);
} else {
if((state_val_62389 === (2))){
var inst_62377 = (state_62388[(7)]);
var inst_62377__$1 = (state_62388[(2)]);
var inst_62378 = fluree.db.util.core.exception_QMARK_(inst_62377__$1);
var state_62388__$1 = (function (){var statearr_62390 = state_62388;
(statearr_62390[(7)] = inst_62377__$1);

return statearr_62390;
})();
if(inst_62378){
var statearr_62391_62501 = state_62388__$1;
(statearr_62391_62501[(1)] = (3));

} else {
var statearr_62392_62502 = state_62388__$1;
(statearr_62392_62502[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62389 === (3))){
var inst_62377 = (state_62388[(7)]);
var inst_62380 = cljs.core.ex_message(inst_62377);
var inst_62381 = cljs.core.ex_data(inst_62377);
var inst_62382 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62380,inst_62381], 0));
var state_62388__$1 = state_62388;
var statearr_62393_62503 = state_62388__$1;
(statearr_62393_62503[(2)] = inst_62382);

(statearr_62393_62503[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62389 === (4))){
var inst_62384 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62497);
var state_62388__$1 = state_62388;
var statearr_62394_62504 = state_62388__$1;
(statearr_62394_62504[(2)] = inst_62384);

(statearr_62394_62504[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62389 === (5))){
var inst_62386 = (state_62388[(2)]);
var state_62388__$1 = state_62388;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62388__$1,inst_62386);
} else {
return null;
}
}
}
}
}
});})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497))
;
return ((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,switch__2413__auto__,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_62395 = [null,null,null,null,null,null,null,null];
(statearr_62395[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_62395[(1)] = (1));

return statearr_62395;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_62388){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62388);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62396){var ex__2417__auto__ = e62396;
var statearr_62397_62505 = state_62388;
(statearr_62397_62505[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62388[(4)]))){
var statearr_62398_62506 = state_62388;
(statearr_62398_62506[(1)] = cljs.core.first((state_62388[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62507 = state_62388;
state_62388 = G__62507;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_62388){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_62388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
;})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,switch__2413__auto__,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497))
})();
var state__2438__auto__ = (function (){var statearr_62399 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62399[(6)] = c__2436__auto___62500);

return statearr_62399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62500,healthcheck_uri_62498,resp_chan_62499,server_62497))
);



var G__62508 = seq__62324_62493;
var G__62509 = chunk__62325_62494;
var G__62510 = count__62326_62495;
var G__62511 = (i__62327_62496 + (1));
seq__62324_62493 = G__62508;
chunk__62325_62494 = G__62509;
count__62326_62495 = G__62510;
i__62327_62496 = G__62511;
continue;
} else {
var temp__5735__auto___62512 = cljs.core.seq(seq__62324_62493);
if(temp__5735__auto___62512){
var seq__62324_62513__$1 = temp__5735__auto___62512;
if(cljs.core.chunked_seq_QMARK_(seq__62324_62513__$1)){
var c__4556__auto___62514 = cljs.core.chunk_first(seq__62324_62513__$1);
var G__62515 = cljs.core.chunk_rest(seq__62324_62513__$1);
var G__62516 = c__4556__auto___62514;
var G__62517 = cljs.core.count(c__4556__auto___62514);
var G__62518 = (0);
seq__62324_62493 = G__62515;
chunk__62325_62494 = G__62516;
count__62326_62495 = G__62517;
i__62327_62496 = G__62518;
continue;
} else {
var server_62519 = cljs.core.first(seq__62324_62513__$1);
var healthcheck_uri_62520 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62519),"/fdb/health"].join('');
var resp_chan_62521 = fluree.db.util.xhttp.post_json(healthcheck_uri_62520,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2436__auto___62522 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512){
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = ((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512){
return (function (state_62412){
var state_val_62413 = (state_62412[(1)]);
if((state_val_62413 === (1))){
var state_62412__$1 = state_62412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62412__$1,(2),resp_chan_62521);
} else {
if((state_val_62413 === (2))){
var inst_62401 = (state_62412[(7)]);
var inst_62401__$1 = (state_62412[(2)]);
var inst_62402 = fluree.db.util.core.exception_QMARK_(inst_62401__$1);
var state_62412__$1 = (function (){var statearr_62414 = state_62412;
(statearr_62414[(7)] = inst_62401__$1);

return statearr_62414;
})();
if(inst_62402){
var statearr_62415_62523 = state_62412__$1;
(statearr_62415_62523[(1)] = (3));

} else {
var statearr_62416_62524 = state_62412__$1;
(statearr_62416_62524[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (3))){
var inst_62401 = (state_62412[(7)]);
var inst_62404 = cljs.core.ex_message(inst_62401);
var inst_62405 = cljs.core.ex_data(inst_62401);
var inst_62406 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_62404,inst_62405], 0));
var state_62412__$1 = state_62412;
var statearr_62417_62525 = state_62412__$1;
(statearr_62417_62525[(2)] = inst_62406);

(statearr_62417_62525[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (4))){
var inst_62408 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_62519);
var state_62412__$1 = state_62412;
var statearr_62418_62526 = state_62412__$1;
(statearr_62418_62526[(2)] = inst_62408);

(statearr_62418_62526[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62413 === (5))){
var inst_62410 = (state_62412[(2)]);
var state_62412__$1 = state_62412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62412__$1,inst_62410);
} else {
return null;
}
}
}
}
}
});})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512))
;
return ((function (seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,switch__2413__auto__,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_62419 = [null,null,null,null,null,null,null,null];
(statearr_62419[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_62419[(1)] = (1));

return statearr_62419;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_62412){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62412);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62420){var ex__2417__auto__ = e62420;
var statearr_62421_62527 = state_62412;
(statearr_62421_62527[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62412[(4)]))){
var statearr_62422_62528 = state_62412;
(statearr_62422_62528[(1)] = cljs.core.first((state_62412[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62529 = state_62412;
state_62412 = G__62529;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_62412){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_62412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
;})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,switch__2413__auto__,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512))
})();
var state__2438__auto__ = (function (){var statearr_62423 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62423[(6)] = c__2436__auto___62522);

return statearr_62423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});})(seq__62324_62493,chunk__62325_62494,count__62326_62495,i__62327_62496,c__2436__auto___62522,healthcheck_uri_62520,resp_chan_62521,server_62519,seq__62324_62513__$1,temp__5735__auto___62512))
);



var G__62530 = cljs.core.next(seq__62324_62513__$1);
var G__62531 = null;
var G__62532 = (0);
var G__62533 = (0);
seq__62324_62493 = G__62530;
chunk__62325_62494 = G__62531;
count__62326_62495 = G__62532;
i__62327_62496 = G__62533;
continue;
}
} else {
}
}
break;
}

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62467){
var state_val_62468 = (state_62467[(1)]);
if((state_val_62468 === (7))){
var inst_62439 = (state_62467[(7)]);
var inst_62446 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62439,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62467__$1 = state_62467;
if(inst_62446){
var statearr_62469_62534 = state_62467__$1;
(statearr_62469_62534[(1)] = (9));

} else {
var statearr_62470_62535 = state_62467__$1;
(statearr_62470_62535[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (1))){
var inst_62431 = (state_62467[(8)]);
var inst_62432 = (state_62467[(9)]);
var inst_62431__$1 = promise_chan;
var inst_62432__$1 = cljs.core.async.timeout((60000));
var inst_62433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62434 = [inst_62431__$1,inst_62432__$1];
var inst_62435 = (new cljs.core.PersistentVector(null,2,(5),inst_62433,inst_62434,null));
var state_62467__$1 = (function (){var statearr_62471 = state_62467;
(statearr_62471[(8)] = inst_62431__$1);

(statearr_62471[(9)] = inst_62432__$1);

return statearr_62471;
})();
return cljs.core.async.ioc_alts_BANG_(state_62467__$1,(2),inst_62435);
} else {
if((state_val_62468 === (4))){
var inst_62439 = (state_62467[(7)]);
var inst_62432 = (state_62467[(9)]);
var inst_62443 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62439,inst_62432);
var state_62467__$1 = state_62467;
if(inst_62443){
var statearr_62472_62536 = state_62467__$1;
(statearr_62472_62536[(1)] = (6));

} else {
var statearr_62473_62537 = state_62467__$1;
(statearr_62473_62537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (13))){
var state_62467__$1 = state_62467;
var statearr_62474_62538 = state_62467__$1;
(statearr_62474_62538[(2)] = null);

(statearr_62474_62538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (6))){
var state_62467__$1 = state_62467;
var statearr_62475_62539 = state_62467__$1;
(statearr_62475_62539[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62475_62539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (3))){
var state_62467__$1 = state_62467;
var statearr_62476_62540 = state_62467__$1;
(statearr_62476_62540[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62476_62540[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (12))){
var inst_62457 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_62458 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62459 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62460 = cljs.core.PersistentHashMap.fromArrays(inst_62458,inst_62459);
var inst_62461 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_62460);
var inst_62462 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_62461);
var state_62467__$1 = (function (){var statearr_62477 = state_62467;
(statearr_62477[(10)] = inst_62457);

return statearr_62477;
})();
var statearr_62478_62541 = state_62467__$1;
(statearr_62478_62541[(2)] = inst_62462);

(statearr_62478_62541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (2))){
var inst_62439 = (state_62467[(7)]);
var inst_62431 = (state_62467[(8)]);
var inst_62437 = (state_62467[(2)]);
var inst_62438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62437,(0),null);
var inst_62439__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62437,(1),null);
var inst_62440 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62439__$1,inst_62431);
var state_62467__$1 = (function (){var statearr_62479 = state_62467;
(statearr_62479[(7)] = inst_62439__$1);

(statearr_62479[(11)] = inst_62438);

return statearr_62479;
})();
if(inst_62440){
var statearr_62480_62542 = state_62467__$1;
(statearr_62480_62542[(1)] = (3));

} else {
var statearr_62481_62543 = state_62467__$1;
(statearr_62481_62543[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (11))){
var inst_62450 = (state_62467[(2)]);
var state_62467__$1 = state_62467;
var statearr_62482_62544 = state_62467__$1;
(statearr_62482_62544[(2)] = inst_62450);

(statearr_62482_62544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (9))){
var inst_62438 = (state_62467[(11)]);
var state_62467__$1 = state_62467;
var statearr_62483_62545 = state_62467__$1;
(statearr_62483_62545[(2)] = inst_62438);

(statearr_62483_62545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (5))){
var inst_62454 = (state_62467[(2)]);
var inst_62455 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62454);
var state_62467__$1 = state_62467;
if(inst_62455){
var statearr_62484_62546 = state_62467__$1;
(statearr_62484_62546[(1)] = (12));

} else {
var statearr_62485_62547 = state_62467__$1;
(statearr_62485_62547[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (14))){
var inst_62465 = (state_62467[(2)]);
var state_62467__$1 = state_62467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62467__$1,inst_62465);
} else {
if((state_val_62468 === (10))){
var state_62467__$1 = state_62467;
var statearr_62486_62548 = state_62467__$1;
(statearr_62486_62548[(2)] = null);

(statearr_62486_62548[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62468 === (8))){
var inst_62452 = (state_62467[(2)]);
var state_62467__$1 = state_62467;
var statearr_62487_62549 = state_62467__$1;
(statearr_62487_62549[(2)] = inst_62452);

(statearr_62487_62549[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0 = (function (){
var statearr_62488 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62488[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__);

(statearr_62488[(1)] = (1));

return statearr_62488;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1 = (function (state_62467){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62467);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62489){var ex__2417__auto__ = e62489;
var statearr_62490_62550 = state_62467;
(statearr_62490_62550[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62467[(4)]))){
var statearr_62491_62551 = state_62467;
(statearr_62491_62551[(1)] = cljs.core.first((state_62467[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62552 = state_62467;
state_62467 = G__62552;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__ = function(state_62467){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1.call(this,state_62467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62492 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62492[(6)] = c__2436__auto__);

return statearr_62492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62596){
var state_val_62597 = (state_62596[(1)]);
if((state_val_62597 === (7))){
var state_62596__$1 = state_62596;
var statearr_62598_62624 = state_62596__$1;
(statearr_62598_62624[(2)] = null);

(statearr_62598_62624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (1))){
var state_62596__$1 = state_62596;
var statearr_62599_62625 = state_62596__$1;
(statearr_62599_62625[(2)] = null);

(statearr_62599_62625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (4))){
var inst_62553 = (state_62596[(2)]);
var state_62596__$1 = state_62596;
var statearr_62600_62626 = state_62596__$1;
(statearr_62600_62626[(2)] = inst_62553);

(statearr_62600_62626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (6))){
var inst_62575 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_62596__$1 = state_62596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62596__$1,(9),inst_62575);
} else {
if((state_val_62597 === (3))){
var inst_62594 = (state_62596[(2)]);
var state_62596__$1 = state_62596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62596__$1,inst_62594);
} else {
if((state_val_62597 === (12))){
var inst_62588 = (state_62596[(2)]);
var state_62596__$1 = state_62596;
var statearr_62601_62627 = state_62596__$1;
(statearr_62601_62627[(2)] = inst_62588);

(statearr_62601_62627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (2))){
var inst_62564 = (state_62596[(7)]);
var inst_62569 = (state_62596[(8)]);
var inst_62559 = (state_62596[(9)]);
var _ = (function (){var statearr_62602 = state_62596;
(statearr_62602[(4)] = cljs.core.cons((5),(state_62596[(4)])));

return statearr_62602;
})();
var inst_62559__$1 = fluree.db.util.core.random_uuid();
var inst_62560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62561 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62562 = (new cljs.core.PersistentVector(null,2,(5),inst_62560,inst_62561,null));
var inst_62563 = (function (){var lock_id = inst_62559__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_62564__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62562,inst_62563);
var inst_62565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62566 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62567 = (new cljs.core.PersistentVector(null,3,(5),inst_62565,inst_62566,null));
var inst_62568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62564__$1,inst_62567);
var inst_62569__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62559__$1,inst_62568);
var inst_62570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62571 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62572 = (new cljs.core.PersistentVector(null,3,(5),inst_62570,inst_62571,null));
var inst_62573 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62564__$1,inst_62572);
var state_62596__$1 = (function (){var statearr_62603 = state_62596;
(statearr_62603[(7)] = inst_62564__$1);

(statearr_62603[(8)] = inst_62569__$1);

(statearr_62603[(9)] = inst_62559__$1);

(statearr_62603[(10)] = inst_62573);

return statearr_62603;
})();
if(inst_62569__$1){
var statearr_62604_62628 = state_62596__$1;
(statearr_62604_62628[(1)] = (6));

} else {
var statearr_62605_62629 = state_62596__$1;
(statearr_62605_62629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (11))){
var inst_62579 = (state_62596[(11)]);
var inst_62573 = (state_62596[(10)]);
var inst_62580 = (state_62596[(12)]);
var inst_62586 = fluree.db.util.xhttp.try_socket(inst_62579,sub_chan,pub_chan,inst_62573,(60000),inst_62580);
var state_62596__$1 = state_62596;
var statearr_62607_62630 = state_62596__$1;
(statearr_62607_62630[(2)] = inst_62586);

(statearr_62607_62630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (9))){
var inst_62579 = (state_62596[(11)]);
var inst_62577 = (state_62596[(13)]);
var inst_62564 = (state_62596[(7)]);
var inst_62569 = (state_62596[(8)]);
var inst_62559 = (state_62596[(9)]);
var inst_62573 = (state_62596[(10)]);
var inst_62577__$1 = (state_62596[(2)]);
var inst_62578 = clojure.string.replace(inst_62577__$1,"http","ws");
var inst_62579__$1 = [inst_62578,"/fdb/ws"].join('');
var inst_62580 = (function (){var lock_id = inst_62559;
var state = inst_62564;
var have_lock_QMARK_ = inst_62569;
var resp_chan = inst_62573;
var healthy_server = inst_62577__$1;
var ws_url = inst_62579__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_62581 = fluree.db.util.core.exception_QMARK_(inst_62577__$1);
var state_62596__$1 = (function (){var statearr_62608 = state_62596;
(statearr_62608[(11)] = inst_62579__$1);

(statearr_62608[(13)] = inst_62577__$1);

(statearr_62608[(12)] = inst_62580);

return statearr_62608;
})();
if(inst_62581){
var statearr_62609_62631 = state_62596__$1;
(statearr_62609_62631[(1)] = (10));

} else {
var statearr_62610_62632 = state_62596__$1;
(statearr_62610_62632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (5))){
var _ = (function (){var statearr_62611 = state_62596;
(statearr_62611[(4)] = cljs.core.rest((state_62596[(4)])));

return statearr_62611;
})();
var state_62596__$1 = state_62596;
var ex62606 = (state_62596__$1[(2)]);
var statearr_62612_62633 = state_62596__$1;
(statearr_62612_62633[(5)] = ex62606);


if((ex62606 instanceof Error)){
var statearr_62613_62634 = state_62596__$1;
(statearr_62613_62634[(1)] = (4));

(statearr_62613_62634[(5)] = null);

} else {
throw ex62606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (10))){
var inst_62577 = (state_62596[(13)]);
var inst_62573 = (state_62596[(10)]);
var inst_62583 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_62584 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62573,inst_62577);
var state_62596__$1 = (function (){var statearr_62614 = state_62596;
(statearr_62614[(14)] = inst_62583);

return statearr_62614;
})();
var statearr_62615_62635 = state_62596__$1;
(statearr_62615_62635[(2)] = inst_62584);

(statearr_62615_62635[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62597 === (8))){
var inst_62573 = (state_62596[(10)]);
var inst_62591 = (state_62596[(2)]);
var _ = (function (){var statearr_62616 = state_62596;
(statearr_62616[(4)] = cljs.core.rest((state_62596[(4)])));

return statearr_62616;
})();
var state_62596__$1 = (function (){var statearr_62617 = state_62596;
(statearr_62617[(15)] = inst_62591);

return statearr_62617;
})();
var statearr_62618_62636 = state_62596__$1;
(statearr_62618_62636[(2)] = inst_62573);

(statearr_62618_62636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2414__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_62619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62619[(0)] = fluree$db$connection$establish_socket_$_state_machine__2414__auto__);

(statearr_62619[(1)] = (1));

return statearr_62619;
});
var fluree$db$connection$establish_socket_$_state_machine__2414__auto____1 = (function (state_62596){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62596);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62620){var ex__2417__auto__ = e62620;
var statearr_62621_62637 = state_62596;
(statearr_62621_62637[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62596[(4)]))){
var statearr_62622_62638 = state_62596;
(statearr_62622_62638[(1)] = cljs.core.first((state_62596[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62639 = state_62596;
state_62596 = G__62639;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2414__auto__ = function(state_62596){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2414__auto____1.call(this,state_62596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2414__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2414__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62623 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62623[(6)] = c__2436__auto__);

return statearr_62623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k62641,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__62645 = k62641;
var G__62645__$1 = (((G__62645 instanceof cljs.core.Keyword))?G__62645.fqn:null);
switch (G__62645__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k62641,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__62646){
var vec__62647 = p__62646;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62647,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62647,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62640){
var self__ = this;
var G__62640__$1 = this;
return (new cljs.core.RecordIter((0),G__62640__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__62650 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__62650(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62642,other62643){
var self__ = this;
var this62642__$1 = this;
return (((!((other62643 == null)))) && ((this62642__$1.constructor === other62643.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.id,other62643.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.servers,other62643.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.state,other62643.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.req_chan,other62643.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.sub_chan,other62643.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.pub_chan,other62643.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.storage_read,other62643.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.storage_write,other62643.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.object_cache,other62643.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.parallelism,other62643.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.serializer,other62643.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.default_network,other62643.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.transactor_QMARK_,other62643.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.publish,other62643.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.transact_handler,other62643.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.tx_private_key,other62643.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.tx_key_id,other62643.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.meta,other62643.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.add_listener,other62643.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.remove_listener,other62643.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.close,other62643.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this62642__$1.__extmap,other62643.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__62640){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__62651 = cljs.core.keyword_identical_QMARK_;
var expr__62652 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__62654 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__62655 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62654,G__62655) : pred__62651.call(null,G__62654,G__62655));
})())){
return (new fluree.db.connection.Connection(G__62640,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62656 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__62657 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62656,G__62657) : pred__62651.call(null,G__62656,G__62657));
})())){
return (new fluree.db.connection.Connection(self__.id,G__62640,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62658 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__62659 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62658,G__62659) : pred__62651.call(null,G__62658,G__62659));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62640,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62660 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__62661 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62660,G__62661) : pred__62651.call(null,G__62660,G__62661));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62640,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62662 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__62663 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62662,G__62663) : pred__62651.call(null,G__62662,G__62663));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62640,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62664 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__62665 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62664,G__62665) : pred__62651.call(null,G__62664,G__62665));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62640,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62666 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__62667 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62666,G__62667) : pred__62651.call(null,G__62666,G__62667));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62640,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62668 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__62669 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62668,G__62669) : pred__62651.call(null,G__62668,G__62669));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__62640,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62670 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__62671 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62670,G__62671) : pred__62651.call(null,G__62670,G__62671));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__62640,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62672 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__62673 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62672,G__62673) : pred__62651.call(null,G__62672,G__62673));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__62640,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62674 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__62675 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62674,G__62675) : pred__62651.call(null,G__62674,G__62675));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62640,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62676 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__62677 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62676,G__62677) : pred__62651.call(null,G__62676,G__62677));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62640,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62678 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__62679 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62678,G__62679) : pred__62651.call(null,G__62678,G__62679));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62640,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62680 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__62681 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62680,G__62681) : pred__62651.call(null,G__62680,G__62681));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62640,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62682 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__62683 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62682,G__62683) : pred__62651.call(null,G__62682,G__62683));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62640,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62684 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__62685 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62684,G__62685) : pred__62651.call(null,G__62684,G__62685));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62640,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62686 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__62687 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62686,G__62687) : pred__62651.call(null,G__62686,G__62687));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62640,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62688 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__62689 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62688,G__62689) : pred__62651.call(null,G__62688,G__62689));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62640,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62690 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__62691 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62690,G__62691) : pred__62651.call(null,G__62690,G__62691));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62640,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62692 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__62693 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62692,G__62693) : pred__62651.call(null,G__62692,G__62693));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62640,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__62694 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__62695 = expr__62652;
return (pred__62651.cljs$core$IFn$_invoke$arity$2 ? pred__62651.cljs$core$IFn$_invoke$arity$2(G__62694,G__62695) : pred__62651.call(null,G__62694,G__62695));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62640,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__62640),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__62640){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62640,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62644){
var extmap__4419__auto__ = (function (){var G__62696 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__62644,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__62644)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__62696);
} else {
return G__62696;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62644),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62644),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__62701 = servers_STAR_;
var vec__62702 = G__62701;
var seq__62703 = cljs.core.seq(vec__62702);
var first__62704 = cljs.core.first(seq__62703);
var seq__62703__$1 = cljs.core.next(seq__62703);
var server = first__62704;
var r = seq__62703__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62701__$1 = G__62701;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62708 = G__62701__$1;
var seq__62709 = cljs.core.seq(vec__62708);
var first__62710 = cljs.core.first(seq__62709);
var seq__62709__$1 = cljs.core.next(seq__62709);
var server__$1 = first__62710;
var r__$1 = seq__62709__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__62711 = r__$1;
var G__62712 = is_https_QMARK_;
var G__62713 = result_STAR_;
G__62701__$1 = G__62711;
https_QMARK___$1 = G__62712;
result__$1 = G__62713;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62714 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62714 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__62714);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62743){
var state_val_62744 = (state_62743[(1)]);
if((state_val_62744 === (7))){
var inst_62729 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62730 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62731 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62732 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62733 = fluree.db.connection.establish_socket(inst_62729,inst_62730,inst_62731,inst_62732);
var state_62743__$1 = state_62743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62743__$1,(9),inst_62733);
} else {
if((state_val_62744 === (1))){
var state_62743__$1 = state_62743;
var statearr_62745_62764 = state_62743__$1;
(statearr_62745_62764[(2)] = null);

(statearr_62745_62764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (4))){
var inst_62715 = (state_62743[(2)]);
var state_62743__$1 = state_62743;
var statearr_62746_62765 = state_62743__$1;
(statearr_62746_62765[(2)] = inst_62715);

(statearr_62746_62765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (6))){
var inst_62726 = (state_62743[(7)]);
var state_62743__$1 = state_62743;
var statearr_62747_62766 = state_62743__$1;
(statearr_62747_62766[(2)] = inst_62726);

(statearr_62747_62766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (3))){
var inst_62741 = (state_62743[(2)]);
var state_62743__$1 = state_62743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62743__$1,inst_62741);
} else {
if((state_val_62744 === (2))){
var inst_62726 = (state_62743[(7)]);
var _ = (function (){var statearr_62749 = state_62743;
(statearr_62749[(4)] = cljs.core.cons((5),(state_62743[(4)])));

return statearr_62749;
})();
var inst_62721 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62723 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62724 = [inst_62723,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62725 = (new cljs.core.PersistentVector(null,3,(5),inst_62722,inst_62724,null));
var inst_62726__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62721,inst_62725);
var state_62743__$1 = (function (){var statearr_62750 = state_62743;
(statearr_62750[(7)] = inst_62726__$1);

return statearr_62750;
})();
if(cljs.core.truth_(inst_62726__$1)){
var statearr_62751_62767 = state_62743__$1;
(statearr_62751_62767[(1)] = (6));

} else {
var statearr_62752_62768 = state_62743__$1;
(statearr_62752_62768[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (9))){
var inst_62735 = (state_62743[(2)]);
var inst_62736 = fluree.db.util.async.throw_err(inst_62735);
var state_62743__$1 = state_62743;
var statearr_62753_62769 = state_62743__$1;
(statearr_62753_62769[(2)] = inst_62736);

(statearr_62753_62769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (5))){
var _ = (function (){var statearr_62754 = state_62743;
(statearr_62754[(4)] = cljs.core.rest((state_62743[(4)])));

return statearr_62754;
})();
var state_62743__$1 = state_62743;
var ex62748 = (state_62743__$1[(2)]);
var statearr_62755_62770 = state_62743__$1;
(statearr_62755_62770[(5)] = ex62748);


if((ex62748 instanceof Error)){
var statearr_62756_62771 = state_62743__$1;
(statearr_62756_62771[(1)] = (4));

(statearr_62756_62771[(5)] = null);

} else {
throw ex62748;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62744 === (8))){
var inst_62738 = (state_62743[(2)]);
var _ = (function (){var statearr_62757 = state_62743;
(statearr_62757[(4)] = cljs.core.rest((state_62743[(4)])));

return statearr_62757;
})();
var state_62743__$1 = state_62743;
var statearr_62758_62772 = state_62743__$1;
(statearr_62758_62772[(2)] = inst_62738);

(statearr_62758_62772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2414__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_62759 = [null,null,null,null,null,null,null,null];
(statearr_62759[(0)] = fluree$db$connection$get_socket_$_state_machine__2414__auto__);

(statearr_62759[(1)] = (1));

return statearr_62759;
});
var fluree$db$connection$get_socket_$_state_machine__2414__auto____1 = (function (state_62743){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62743);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62760){var ex__2417__auto__ = e62760;
var statearr_62761_62773 = state_62743;
(statearr_62761_62773[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62743[(4)]))){
var statearr_62762_62774 = state_62743;
(statearr_62762_62774[(1)] = cljs.core.first((state_62743[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62775 = state_62743;
state_62743 = G__62775;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2414__auto__ = function(state_62743){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2414__auto____1.call(this,state_62743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2414__auto____0;
fluree$db$connection$get_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2414__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62763 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62763[(6)] = c__2436__auto__);

return statearr_62763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e62776){var e = e62776;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62923){
var state_val_62924 = (state_62923[(1)]);
if((state_val_62924 === (7))){
var inst_62919 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62926_63009 = state_62923__$1;
(statearr_62926_63009[(2)] = inst_62919);

(statearr_62926_63009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (20))){
var _ = (function (){var statearr_62927 = state_62923;
(statearr_62927[(4)] = cljs.core.rest((state_62923[(4)])));

return statearr_62927;
})();
var state_62923__$1 = state_62923;
var ex62925 = (state_62923__$1[(2)]);
var statearr_62928_63010 = state_62923__$1;
(statearr_62928_63010[(5)] = ex62925);


var statearr_62929_63011 = state_62923__$1;
(statearr_62929_63011[(1)] = (10));

(statearr_62929_63011[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (27))){
var inst_62821 = (state_62923[(7)]);
var inst_62839 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_62821);
var state_62923__$1 = state_62923;
var statearr_62930_63012 = state_62923__$1;
(statearr_62930_63012[(2)] = inst_62839);

(statearr_62930_63012[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (1))){
var inst_62778 = (0);
var state_62923__$1 = (function (){var statearr_62931 = state_62923;
(statearr_62931[(8)] = inst_62778);

return statearr_62931;
})();
var statearr_62932_63013 = state_62923__$1;
(statearr_62932_63013[(2)] = null);

(statearr_62932_63013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (24))){
var state_62923__$1 = state_62923;
var statearr_62933_63014 = state_62923__$1;
(statearr_62933_63014[(2)] = true);

(statearr_62933_63014[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (39))){
var inst_62909 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62934_63015 = state_62923__$1;
(statearr_62934_63015[(2)] = inst_62909);

(statearr_62934_63015[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (4))){
var inst_62781 = (state_62923[(9)]);
var inst_62781__$1 = (state_62923[(2)]);
var state_62923__$1 = (function (){var statearr_62935 = state_62923;
(statearr_62935[(9)] = inst_62781__$1);

return statearr_62935;
})();
if(cljs.core.truth_(inst_62781__$1)){
var statearr_62936_63016 = state_62923__$1;
(statearr_62936_63016[(1)] = (5));

} else {
var statearr_62937_63017 = state_62923__$1;
(statearr_62937_63017[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (15))){
var inst_62794 = (state_62923[(10)]);
var state_62923__$1 = state_62923;
var statearr_62938_63018 = state_62923__$1;
(statearr_62938_63018[(2)] = inst_62794);

(statearr_62938_63018[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (21))){
var inst_62821 = (state_62923[(7)]);
var inst_62826 = inst_62821.cljs$lang$protocol_mask$partition0$;
var inst_62827 = (inst_62826 & (64));
var inst_62828 = inst_62821.cljs$core$ISeq$;
var inst_62829 = (cljs.core.PROTOCOL_SENTINEL === inst_62828);
var inst_62830 = ((inst_62827) || (inst_62829));
var state_62923__$1 = state_62923;
if(cljs.core.truth_(inst_62830)){
var statearr_62939_63019 = state_62923__$1;
(statearr_62939_63019[(1)] = (24));

} else {
var statearr_62940_63020 = state_62923__$1;
(statearr_62940_63020[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (31))){
var state_62923__$1 = state_62923;
var statearr_62941_63021 = state_62923__$1;
(statearr_62941_63021[(2)] = null);

(statearr_62941_63021[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (32))){
var inst_62819 = (state_62923[(11)]);
var inst_62818 = (state_62923[(12)]);
var inst_62845 = (state_62923[(13)]);
var inst_62883 = (state_62923[(2)]);
var inst_62884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62885 = [inst_62818,inst_62845,inst_62819];
var inst_62886 = (new cljs.core.PersistentVector(null,3,(5),inst_62884,inst_62885,null));
var inst_62887 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_62886) : publish_fn.call(null,conn,inst_62886));
var state_62923__$1 = (function (){var statearr_62942 = state_62923;
(statearr_62942[(14)] = inst_62883);

return statearr_62942;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62923__$1,(33),inst_62887);
} else {
if((state_val_62924 === (40))){
var inst_62899 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62923__$1 = state_62923;
var statearr_62943_63022 = state_62923__$1;
(statearr_62943_63022[(2)] = inst_62899);

(statearr_62943_63022[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (33))){
var inst_62889 = (state_62923[(15)]);
var inst_62889__$1 = (state_62923[(2)]);
var inst_62890 = inst_62889__$1 === true;
var state_62923__$1 = (function (){var statearr_62944 = state_62923;
(statearr_62944[(15)] = inst_62889__$1);

return statearr_62944;
})();
if(cljs.core.truth_(inst_62890)){
var statearr_62945_63023 = state_62923__$1;
(statearr_62945_63023[(1)] = (34));

} else {
var statearr_62946_63024 = state_62923__$1;
(statearr_62946_63024[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (13))){
var inst_62794 = (state_62923[(10)]);
var inst_62791 = (state_62923[(2)]);
var inst_62792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62791,(0),null);
var inst_62793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62791,(1),null);
var inst_62794__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62791,(2),null);
var state_62923__$1 = (function (){var statearr_62947 = state_62923;
(statearr_62947[(16)] = inst_62793);

(statearr_62947[(17)] = inst_62792);

(statearr_62947[(10)] = inst_62794__$1);

return statearr_62947;
})();
if(cljs.core.truth_(inst_62794__$1)){
var statearr_62948_63025 = state_62923__$1;
(statearr_62948_63025[(1)] = (14));

} else {
var statearr_62949_63026 = state_62923__$1;
(statearr_62949_63026[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (22))){
var state_62923__$1 = state_62923;
var statearr_62950_63027 = state_62923__$1;
(statearr_62950_63027[(2)] = false);

(statearr_62950_63027[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (36))){
var inst_62911 = (state_62923[(2)]);
var _ = (function (){var statearr_62951 = state_62923;
(statearr_62951[(4)] = cljs.core.rest((state_62923[(4)])));

return statearr_62951;
})();
var state_62923__$1 = state_62923;
var statearr_62952_63028 = state_62923__$1;
(statearr_62952_63028[(2)] = inst_62911);

(statearr_62952_63028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (41))){
var state_62923__$1 = state_62923;
var statearr_62953_63029 = state_62923__$1;
(statearr_62953_63029[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (43))){
var inst_62889 = (state_62923[(15)]);
var inst_62902 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_62889], 0));
var state_62923__$1 = state_62923;
var statearr_62955_63030 = state_62923__$1;
(statearr_62955_63030[(2)] = inst_62902);

(statearr_62955_63030[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (29))){
var inst_62842 = (state_62923[(18)]);
var inst_62820 = (state_62923[(19)]);
var inst_62842__$1 = (state_62923[(2)]);
var inst_62843 = fluree.db.util.core.random_uuid();
var inst_62844 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62843);
var inst_62845 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62842__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62844);
var inst_62846 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62842__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62923__$1 = (function (){var statearr_62956 = state_62923;
(statearr_62956[(20)] = inst_62846);

(statearr_62956[(18)] = inst_62842__$1);

(statearr_62956[(13)] = inst_62845);

return statearr_62956;
})();
if(cljs.core.truth_(inst_62820)){
var statearr_62957_63031 = state_62923__$1;
(statearr_62957_63031[(1)] = (30));

} else {
var statearr_62958_63032 = state_62923__$1;
(statearr_62958_63032[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (44))){
var state_62923__$1 = state_62923;
var statearr_62959_63033 = state_62923__$1;
(statearr_62959_63033[(2)] = null);

(statearr_62959_63033[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (6))){
var state_62923__$1 = state_62923;
var statearr_62960_63034 = state_62923__$1;
(statearr_62960_63034[(2)] = null);

(statearr_62960_63034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (28))){
var inst_62821 = (state_62923[(7)]);
var state_62923__$1 = state_62923;
var statearr_62961_63035 = state_62923__$1;
(statearr_62961_63035[(2)] = inst_62821);

(statearr_62961_63035[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (25))){
var state_62923__$1 = state_62923;
var statearr_62962_63036 = state_62923__$1;
(statearr_62962_63036[(2)] = false);

(statearr_62962_63036[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (34))){
var state_62923__$1 = state_62923;
var statearr_62963_63037 = state_62923__$1;
(statearr_62963_63037[(2)] = null);

(statearr_62963_63037[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (17))){
var inst_62783 = (state_62923[(21)]);
var inst_62794 = (state_62923[(10)]);
var inst_62801 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62794,inst_62783);
var state_62923__$1 = state_62923;
var statearr_62964_63038 = state_62923__$1;
(statearr_62964_63038[(2)] = inst_62801);

(statearr_62964_63038[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (3))){
var inst_62921 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62923__$1,inst_62921);
} else {
if((state_val_62924 === (12))){
var state_62923__$1 = state_62923;
var statearr_62965_63039 = state_62923__$1;
(statearr_62965_63039[(2)] = null);

(statearr_62965_63039[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (2))){
var state_62923__$1 = state_62923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62923__$1,(4),req_chan);
} else {
if((state_val_62924 === (23))){
var inst_62837 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
if(cljs.core.truth_(inst_62837)){
var statearr_62966_63040 = state_62923__$1;
(statearr_62966_63040[(1)] = (27));

} else {
var statearr_62967_63041 = state_62923__$1;
(statearr_62967_63041[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (35))){
var inst_62889 = (state_62923[(15)]);
var inst_62893 = fluree.db.util.core.exception_QMARK_(inst_62889);
var state_62923__$1 = state_62923;
if(inst_62893){
var statearr_62968_63042 = state_62923__$1;
(statearr_62968_63042[(1)] = (37));

} else {
var statearr_62969_63043 = state_62923__$1;
(statearr_62969_63043[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (19))){
var inst_62807 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62970_63044 = state_62923__$1;
(statearr_62970_63044[(2)] = inst_62807);

(statearr_62970_63044[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (11))){
var inst_62781 = (state_62923[(9)]);
var state_62923__$1 = state_62923;
var statearr_62971_63045 = state_62923__$1;
(statearr_62971_63045[(2)] = inst_62781);

(statearr_62971_63045[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (9))){
var inst_62778 = (state_62923[(8)]);
var inst_62914 = (state_62923[(2)]);
var inst_62915 = (inst_62778 + (1));
var inst_62778__$1 = inst_62915;
var state_62923__$1 = (function (){var statearr_62972 = state_62923;
(statearr_62972[(22)] = inst_62914);

(statearr_62972[(8)] = inst_62778__$1);

return statearr_62972;
})();
var statearr_62973_63046 = state_62923__$1;
(statearr_62973_63046[(2)] = null);

(statearr_62973_63046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (5))){
var state_62923__$1 = state_62923;
var statearr_62974_63047 = state_62923__$1;
(statearr_62974_63047[(2)] = null);

(statearr_62974_63047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (14))){
var inst_62794 = (state_62923[(10)]);
var inst_62796 = fluree.db.util.async.channel_QMARK_(inst_62794);
var state_62923__$1 = state_62923;
var statearr_62975_63048 = state_62923__$1;
(statearr_62975_63048[(2)] = inst_62796);

(statearr_62975_63048[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (45))){
var inst_62905 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62976_63049 = state_62923__$1;
(statearr_62976_63049[(2)] = inst_62905);

(statearr_62976_63049[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (26))){
var inst_62834 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62977_63050 = state_62923__$1;
(statearr_62977_63050[(2)] = inst_62834);

(statearr_62977_63050[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (16))){
var inst_62799 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
if(cljs.core.truth_(inst_62799)){
var statearr_62978_63051 = state_62923__$1;
(statearr_62978_63051[(1)] = (17));

} else {
var statearr_62979_63052 = state_62923__$1;
(statearr_62979_63052[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (38))){
var inst_62889 = (state_62923[(15)]);
var inst_62897 = (inst_62889 == null);
var state_62923__$1 = state_62923;
if(cljs.core.truth_(inst_62897)){
var statearr_62980_63053 = state_62923__$1;
(statearr_62980_63053[(1)] = (40));

} else {
var statearr_62981_63054 = state_62923__$1;
(statearr_62981_63054[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (30))){
var inst_62819 = (state_62923[(11)]);
var inst_62821 = (state_62923[(7)]);
var inst_62778 = (state_62923[(8)]);
var inst_62846 = (state_62923[(20)]);
var inst_62842 = (state_62923[(18)]);
var inst_62817 = (state_62923[(23)]);
var inst_62818 = (state_62923[(12)]);
var inst_62845 = (state_62923[(13)]);
var inst_62781 = (state_62923[(9)]);
var inst_62820 = (state_62923[(19)]);
var inst_62848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62849 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62845];
var inst_62850 = (new cljs.core.PersistentVector(null,2,(5),inst_62848,inst_62849,null));
var inst_62851 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_62850,inst_62820);
var inst_62878 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_62879 = (function (){var resp_chan = inst_62820;
var vec__62813 = inst_62781;
var timeout = inst_62846;
var c__2436__auto____$1 = inst_62878;
var map__62816 = inst_62842;
var i = inst_62778;
var data = inst_62819;
var _ = inst_62817;
var req_id = inst_62845;
var operation = inst_62818;
var msg = inst_62781;
var opts = inst_62821;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62876){
var state_val_62877 = (state_62876[(1)]);
if((state_val_62877 === (1))){
var inst_62855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62856 = cljs.core.async.timeout(timeout);
var inst_62857 = [resp_chan,inst_62856];
var inst_62858 = (new cljs.core.PersistentVector(null,2,(5),inst_62855,inst_62857,null));
var state_62876__$1 = state_62876;
return cljs.core.async.ioc_alts_BANG_(state_62876__$1,(2),inst_62858);
} else {
if((state_val_62877 === (2))){
var inst_62861 = (state_62876[(7)]);
var inst_62860 = (state_62876[(2)]);
var inst_62861__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62860,(0),null);
var inst_62862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62860,(1),null);
var inst_62863 = (function (){var vec__62852 = inst_62860;
var resp = inst_62861__$1;
var c = inst_62862;
return (function (p1__62777_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__62777_SHARP_,req_id);
});
})();
var inst_62864 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62863);
var inst_62865 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62862,resp_chan);
var state_62876__$1 = (function (){var statearr_62982 = state_62876;
(statearr_62982[(8)] = inst_62864);

(statearr_62982[(7)] = inst_62861__$1);

return statearr_62982;
})();
if(inst_62865){
var statearr_62983_63055 = state_62876__$1;
(statearr_62983_63055[(1)] = (3));

} else {
var statearr_62984_63056 = state_62876__$1;
(statearr_62984_63056[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62877 === (3))){
var inst_62861 = (state_62876[(7)]);
var state_62876__$1 = state_62876;
var statearr_62985_63057 = state_62876__$1;
(statearr_62985_63057[(2)] = inst_62861);

(statearr_62985_63057[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62877 === (4))){
var inst_62868 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62869 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62870 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62871 = cljs.core.PersistentHashMap.fromArrays(inst_62869,inst_62870);
var inst_62872 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62868,inst_62871);
var state_62876__$1 = state_62876;
var statearr_62986_63058 = state_62876__$1;
(statearr_62986_63058[(2)] = inst_62872);

(statearr_62986_63058[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62877 === (5))){
var inst_62874 = (state_62876[(2)]);
var state_62876__$1 = state_62876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62876__$1,inst_62874);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____0 = (function (){
var statearr_62987 = [null,null,null,null,null,null,null,null,null];
(statearr_62987[(0)] = fluree$db$connection$msg_producer_$_state_machine__2414__auto__);

(statearr_62987[(1)] = (1));

return statearr_62987;
});
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____1 = (function (state_62876){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62876);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e62988){var ex__2417__auto__ = e62988;
var statearr_62989_63059 = state_62876;
(statearr_62989_63059[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62876[(4)]))){
var statearr_62990_63060 = state_62876;
(statearr_62990_63060[(1)] = cljs.core.first((state_62876[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63061 = state_62876;
state_62876 = G__63061;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = function(state_62876){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____1.call(this,state_62876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_62991 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_62991[(6)] = c__2436__auto____$1);

return statearr_62991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_62880 = cljs.core.async.impl.dispatch.run(inst_62879);
var state_62923__$1 = (function (){var statearr_62992 = state_62923;
(statearr_62992[(24)] = inst_62880);

(statearr_62992[(25)] = inst_62851);

return statearr_62992;
})();
var statearr_62993_63062 = state_62923__$1;
(statearr_62993_63062[(2)] = inst_62878);

(statearr_62993_63062[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (10))){
var inst_62781 = (state_62923[(9)]);
var inst_62783 = (state_62923[(2)]);
var inst_62787 = cljs.core.sequential_QMARK_(inst_62781);
var state_62923__$1 = (function (){var statearr_62994 = state_62923;
(statearr_62994[(21)] = inst_62783);

return statearr_62994;
})();
if(inst_62787){
var statearr_62995_63063 = state_62923__$1;
(statearr_62995_63063[(1)] = (11));

} else {
var statearr_62996_63064 = state_62923__$1;
(statearr_62996_63064[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (18))){
var inst_62783 = (state_62923[(21)]);
var inst_62781 = (state_62923[(9)]);
var inst_62803 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62781], 0));
var inst_62804 = ["Error processing ledger request, no valid return channel: ",inst_62803].join('');
var inst_62805 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62783,inst_62804], 0));
var state_62923__$1 = state_62923;
var statearr_62997_63065 = state_62923__$1;
(statearr_62997_63065[(2)] = inst_62805);

(statearr_62997_63065[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (42))){
var inst_62907 = (state_62923[(2)]);
var state_62923__$1 = state_62923;
var statearr_62998_63066 = state_62923__$1;
(statearr_62998_63066[(2)] = inst_62907);

(statearr_62998_63066[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (37))){
var inst_62889 = (state_62923[(15)]);
var inst_62895 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62889,"Error processing message in producer."], 0));
var state_62923__$1 = state_62923;
var statearr_62999_63067 = state_62923__$1;
(statearr_62999_63067[(2)] = inst_62895);

(statearr_62999_63067[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62924 === (8))){
var inst_62821 = (state_62923[(7)]);
var inst_62781 = (state_62923[(9)]);
var _ = (function (){var statearr_63000 = state_62923;
(statearr_63000[(4)] = cljs.core.cons((20),(state_62923[(4)])));

return statearr_63000;
})();
var inst_62817 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_62781], 0));
var inst_62818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62781,(0),null);
var inst_62819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62781,(1),null);
var inst_62820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62781,(2),null);
var inst_62821__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62781,(3),null);
var inst_62823 = (inst_62821__$1 == null);
var inst_62824 = cljs.core.not(inst_62823);
var state_62923__$1 = (function (){var statearr_63001 = state_62923;
(statearr_63001[(11)] = inst_62819);

(statearr_63001[(7)] = inst_62821__$1);

(statearr_63001[(23)] = inst_62817);

(statearr_63001[(12)] = inst_62818);

(statearr_63001[(19)] = inst_62820);

return statearr_63001;
})();
if(inst_62824){
var statearr_63002_63068 = state_62923__$1;
(statearr_63002_63068[(1)] = (21));

} else {
var statearr_63003_63069 = state_62923__$1;
(statearr_63003_63069[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____0 = (function (){
var statearr_63004 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63004[(0)] = fluree$db$connection$msg_producer_$_state_machine__2414__auto__);

(statearr_63004[(1)] = (1));

return statearr_63004;
});
var fluree$db$connection$msg_producer_$_state_machine__2414__auto____1 = (function (state_62923){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62923);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63005){var ex__2417__auto__ = e63005;
var statearr_63006_63070 = state_62923;
(statearr_63006_63070[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62923[(4)]))){
var statearr_63007_63071 = state_62923;
(statearr_63007_63071[(1)] = cljs.core.first((state_62923[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63072 = state_62923;
state_62923 = G__63072;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2414__auto__ = function(state_62923){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2414__auto____1.call(this,state_62923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63008 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63008[(6)] = c__2436__auto__);

return statearr_63008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__63073 = conn;
var map__63073__$1 = (((((!((map__63073 == null))))?(((((map__63073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63073):map__63073);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63073__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63156){
var state_val_63157 = (state_63156[(1)]);
if((state_val_63157 === (7))){
var inst_63152 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63158_63209 = state_63156__$1;
(statearr_63158_63209[(2)] = inst_63152);

(statearr_63158_63209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (20))){
var inst_63093 = (state_63156[(7)]);
var inst_63107 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_63108 = [inst_63093];
var inst_63109 = cljs.core.PersistentHashMap.fromArrays(inst_63107,inst_63108);
var inst_63110 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_63109], 0));
var state_63156__$1 = state_63156;
var statearr_63159_63210 = state_63156__$1;
(statearr_63159_63210[(2)] = inst_63110);

(statearr_63159_63210[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (27))){
var state_63156__$1 = state_63156;
var statearr_63160_63211 = state_63156__$1;
(statearr_63160_63211[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (1))){
var inst_63075 = (0);
var state_63156__$1 = (function (){var statearr_63162 = state_63156;
(statearr_63162[(8)] = inst_63075);

return statearr_63162;
})();
var statearr_63163_63212 = state_63156__$1;
(statearr_63163_63212[(2)] = null);

(statearr_63163_63212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (24))){
var inst_63086 = (state_63156[(9)]);
var inst_63135 = fluree.db.util.core.exception_QMARK_(inst_63086);
var state_63156__$1 = state_63156;
if(inst_63135){
var statearr_63164_63213 = state_63156__$1;
(statearr_63164_63213[(1)] = (26));

} else {
var statearr_63165_63214 = state_63156__$1;
(statearr_63165_63214[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (4))){
var inst_63080 = (state_63156[(10)]);
var inst_63085 = (state_63156[(2)]);
var inst_63086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63085,(0),null);
var inst_63087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63085,(1),null);
var inst_63088 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63087,inst_63080);
var state_63156__$1 = (function (){var statearr_63166 = state_63156;
(statearr_63166[(9)] = inst_63086);

return statearr_63166;
})();
if(inst_63088){
var statearr_63167_63215 = state_63156__$1;
(statearr_63167_63215[(1)] = (5));

} else {
var statearr_63168_63216 = state_63156__$1;
(statearr_63168_63216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (15))){
var inst_63093 = (state_63156[(7)]);
var inst_63102 = typeof inst_63093 === 'string';
var state_63156__$1 = state_63156;
if(cljs.core.truth_(inst_63102)){
var statearr_63169_63217 = state_63156__$1;
(statearr_63169_63217[(1)] = (17));

} else {
var statearr_63170_63218 = state_63156__$1;
(statearr_63170_63218[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (21))){
var state_63156__$1 = state_63156;
var statearr_63171_63219 = state_63156__$1;
(statearr_63171_63219[(2)] = null);

(statearr_63171_63219[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (31))){
var inst_63146 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63172_63220 = state_63156__$1;
(statearr_63172_63220[(2)] = inst_63146);

(statearr_63172_63220[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (13))){
var inst_63119 = (state_63156[(2)]);
var inst_63120 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63121 = fluree.db.connection.close_websocket(inst_63120);
var inst_63122 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63123 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_63122);
var state_63156__$1 = (function (){var statearr_63173 = state_63156;
(statearr_63173[(11)] = inst_63119);

(statearr_63173[(12)] = inst_63121);

return statearr_63173;
})();
var statearr_63174_63221 = state_63156__$1;
(statearr_63174_63221[(2)] = inst_63123);

(statearr_63174_63221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (22))){
var inst_63113 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63175_63222 = state_63156__$1;
(statearr_63175_63222[(2)] = inst_63113);

(statearr_63175_63222[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (29))){
var inst_63086 = (state_63156[(9)]);
var inst_63141 = fluree.db.util.json.parse(inst_63086);
var inst_63142 = fluree.db.conn_events.process_events(conn,inst_63141);
var inst_63075 = (0);
var state_63156__$1 = (function (){var statearr_63176 = state_63156;
(statearr_63176[(8)] = inst_63075);

(statearr_63176[(13)] = inst_63142);

return statearr_63176;
})();
var statearr_63177_63223 = state_63156__$1;
(statearr_63177_63223[(2)] = null);

(statearr_63177_63223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (6))){
var inst_63086 = (state_63156[(9)]);
var inst_63131 = (inst_63086 == null);
var state_63156__$1 = state_63156;
if(cljs.core.truth_(inst_63131)){
var statearr_63178_63224 = state_63156__$1;
(statearr_63178_63224[(1)] = (23));

} else {
var statearr_63179_63225 = state_63156__$1;
(statearr_63179_63225[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (28))){
var inst_63148 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63180_63226 = state_63156__$1;
(statearr_63180_63226[(2)] = inst_63148);

(statearr_63180_63226[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (25))){
var inst_63150 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63181_63227 = state_63156__$1;
(statearr_63181_63227[(2)] = inst_63150);

(statearr_63181_63227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (17))){
var inst_63093 = (state_63156[(7)]);
var inst_63104 = cljs.core.eval(inst_63093);
var state_63156__$1 = state_63156;
var statearr_63182_63228 = state_63156__$1;
(statearr_63182_63228[(2)] = inst_63104);

(statearr_63182_63228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (3))){
var inst_63154 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63156__$1,inst_63154);
} else {
if((state_val_63157 === (12))){
var inst_63093 = (state_63156[(7)]);
var inst_63098 = cljs.core.fn_QMARK_(inst_63093);
var state_63156__$1 = state_63156;
if(inst_63098){
var statearr_63183_63229 = state_63156__$1;
(statearr_63183_63229[(1)] = (14));

} else {
var statearr_63184_63230 = state_63156__$1;
(statearr_63184_63230[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (2))){
var inst_63080 = (state_63156[(10)]);
var inst_63080__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_63081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63082 = [sub_chan,inst_63080__$1];
var inst_63083 = (new cljs.core.PersistentVector(null,2,(5),inst_63081,inst_63082,null));
var state_63156__$1 = (function (){var statearr_63185 = state_63156;
(statearr_63185[(10)] = inst_63080__$1);

return statearr_63185;
})();
return cljs.core.async.ioc_alts_BANG_(state_63156__$1,(4),inst_63083);
} else {
if((state_val_63157 === (23))){
var inst_63133 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_63156__$1 = state_63156;
var statearr_63186_63231 = state_63156__$1;
(statearr_63186_63231[(2)] = inst_63133);

(statearr_63186_63231[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (19))){
var inst_63115 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63187_63232 = state_63156__$1;
(statearr_63187_63232[(2)] = inst_63115);

(statearr_63187_63232[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (11))){
var inst_63096 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_63156__$1 = state_63156;
var statearr_63188_63233 = state_63156__$1;
(statearr_63188_63233[(2)] = inst_63096);

(statearr_63188_63233[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (9))){
var inst_63075 = (state_63156[(8)]);
var inst_63125 = fluree.db.connection.ping_transactor(conn);
var inst_63126 = (inst_63075 + (1));
var inst_63075__$1 = inst_63126;
var state_63156__$1 = (function (){var statearr_63189 = state_63156;
(statearr_63189[(14)] = inst_63125);

(statearr_63189[(8)] = inst_63075__$1);

return statearr_63189;
})();
var statearr_63190_63234 = state_63156__$1;
(statearr_63190_63234[(2)] = null);

(statearr_63190_63234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (5))){
var inst_63075 = (state_63156[(8)]);
var inst_63090 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_63075);
var state_63156__$1 = state_63156;
if(inst_63090){
var statearr_63191_63235 = state_63156__$1;
(statearr_63191_63235[(1)] = (8));

} else {
var statearr_63192_63236 = state_63156__$1;
(statearr_63192_63236[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (14))){
var inst_63093 = (state_63156[(7)]);
var inst_63100 = (inst_63093.cljs$core$IFn$_invoke$arity$0 ? inst_63093.cljs$core$IFn$_invoke$arity$0() : inst_63093.call(null));
var state_63156__$1 = state_63156;
var statearr_63193_63237 = state_63156__$1;
(statearr_63193_63237[(2)] = inst_63100);

(statearr_63193_63237[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (26))){
var inst_63086 = (state_63156[(9)]);
var inst_63137 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63086], 0));
var inst_63075 = (0);
var state_63156__$1 = (function (){var statearr_63194 = state_63156;
(statearr_63194[(15)] = inst_63137);

(statearr_63194[(8)] = inst_63075);

return statearr_63194;
})();
var statearr_63195_63238 = state_63156__$1;
(statearr_63195_63238[(2)] = null);

(statearr_63195_63238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (16))){
var inst_63117 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63196_63239 = state_63156__$1;
(statearr_63196_63239[(2)] = inst_63117);

(statearr_63196_63239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (30))){
var state_63156__$1 = state_63156;
var statearr_63197_63240 = state_63156__$1;
(statearr_63197_63240[(2)] = null);

(statearr_63197_63240[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (10))){
var inst_63129 = (state_63156[(2)]);
var state_63156__$1 = state_63156;
var statearr_63198_63241 = state_63156__$1;
(statearr_63198_63241[(2)] = inst_63129);

(statearr_63198_63241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (18))){
var state_63156__$1 = state_63156;
var statearr_63199_63242 = state_63156__$1;
(statearr_63199_63242[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63157 === (8))){
var inst_63093 = (state_63156[(7)]);
var inst_63092 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_63093__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63094 = (inst_63093__$1 == null);
var state_63156__$1 = (function (){var statearr_63201 = state_63156;
(statearr_63201[(16)] = inst_63092);

(statearr_63201[(7)] = inst_63093__$1);

return statearr_63201;
})();
if(cljs.core.truth_(inst_63094)){
var statearr_63202_63243 = state_63156__$1;
(statearr_63202_63243[(1)] = (11));

} else {
var statearr_63203_63244 = state_63156__$1;
(statearr_63203_63244[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0 = (function (){
var statearr_63204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63204[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2414__auto__);

(statearr_63204[(1)] = (1));

return statearr_63204;
});
var fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1 = (function (state_63156){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63156);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63205){var ex__2417__auto__ = e63205;
var statearr_63206_63245 = state_63156;
(statearr_63206_63245[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63156[(4)]))){
var statearr_63207_63246 = state_63156;
(statearr_63207_63246[(1)] = cljs.core.first((state_63156[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63247 = state_63156;
state_63156 = G__63247;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__ = function(state_63156){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1.call(this,state_63156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2414__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2414__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63208 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63208[(6)] = c__2436__auto__);

return statearr_63208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__63249 = arguments.length;
switch (G__63249) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__63250 = opts;
var map__63250__$1 = (((((!((map__63250 == null))))?(((((map__63250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63250):map__63250);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63250__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63250__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63313){
var state_val_63314 = (state_63313[(1)]);
if((state_val_63314 === (7))){
var inst_63261 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_63262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63263 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63264 = (new cljs.core.PersistentVector(null,2,(5),inst_63262,inst_63263,null));
var inst_63265 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_63261,inst_63264);
var state_63313__$1 = state_63313;
var statearr_63315_63356 = state_63313__$1;
(statearr_63315_63356[(2)] = inst_63265);

(statearr_63315_63356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (20))){
var inst_63292 = (state_63313[(7)]);
var state_63313__$1 = state_63313;
var statearr_63316_63357 = state_63313__$1;
(statearr_63316_63357[(2)] = inst_63292);

(statearr_63316_63357[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (1))){
var state_63313__$1 = state_63313;
var statearr_63317_63358 = state_63313__$1;
(statearr_63317_63358[(2)] = null);

(statearr_63317_63358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (4))){
var inst_63252 = (state_63313[(2)]);
var state_63313__$1 = state_63313;
var statearr_63318_63359 = state_63313__$1;
(statearr_63318_63359[(2)] = inst_63252);

(statearr_63318_63359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (15))){
var inst_63267 = (state_63313[(8)]);
var inst_63286 = (state_63313[(2)]);
var state_63313__$1 = (function (){var statearr_63319 = state_63313;
(statearr_63319[(9)] = inst_63286);

return statearr_63319;
})();
if(cljs.core.truth_(inst_63267)){
var statearr_63320_63360 = state_63313__$1;
(statearr_63320_63360[(1)] = (16));

} else {
var statearr_63321_63361 = state_63313__$1;
(statearr_63321_63361[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (21))){
var inst_63272 = (state_63313[(10)]);
var inst_63301 = (state_63313[(2)]);
var inst_63302 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_63303 = [(5000),inst_63301,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_63304 = cljs.core.PersistentHashMap.fromArrays(inst_63302,inst_63303);
var inst_63305 = fluree.db.util.xhttp.get(inst_63272,inst_63304);
var state_63313__$1 = state_63313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63313__$1,(22),inst_63305);
} else {
if((state_val_63314 === (13))){
var inst_63281 = (state_63313[(11)]);
var inst_63267 = (state_63313[(8)]);
var inst_63283 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63281,"X-fdb-jwt",inst_63267);
var state_63313__$1 = state_63313;
var statearr_63322_63362 = state_63313__$1;
(statearr_63322_63362[(2)] = inst_63283);

(statearr_63322_63362[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (22))){
var inst_63307 = (state_63313[(2)]);
var inst_63308 = fluree.db.util.async.throw_err(inst_63307);
var _ = (function (){var statearr_63323 = state_63313;
(statearr_63323[(4)] = cljs.core.rest((state_63313[(4)])));

return statearr_63323;
})();
var state_63313__$1 = state_63313;
var statearr_63324_63363 = state_63313__$1;
(statearr_63324_63363[(2)] = inst_63308);

(statearr_63324_63363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (6))){
var inst_63258 = (state_63313[(12)]);
var state_63313__$1 = state_63313;
var statearr_63325_63364 = state_63313__$1;
(statearr_63325_63364[(2)] = inst_63258);

(statearr_63325_63364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (17))){
var inst_63286 = (state_63313[(9)]);
var state_63313__$1 = state_63313;
var statearr_63326_63365 = state_63313__$1;
(statearr_63326_63365[(2)] = inst_63286);

(statearr_63326_63365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (3))){
var inst_63311 = (state_63313[(2)]);
var state_63313__$1 = state_63313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63313__$1,inst_63311);
} else {
if((state_val_63314 === (12))){
var inst_63267 = (state_63313[(8)]);
var inst_63281 = (state_63313[(2)]);
var state_63313__$1 = (function (){var statearr_63327 = state_63313;
(statearr_63327[(11)] = inst_63281);

return statearr_63327;
})();
if(cljs.core.truth_(inst_63267)){
var statearr_63328_63366 = state_63313__$1;
(statearr_63328_63366[(1)] = (13));

} else {
var statearr_63329_63367 = state_63313__$1;
(statearr_63329_63367[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (2))){
var inst_63258 = (state_63313[(12)]);
var _ = (function (){var statearr_63330 = state_63313;
(statearr_63330[(4)] = cljs.core.cons((5),(state_63313[(4)])));

return statearr_63330;
})();
var inst_63258__$1 = jwt;
var state_63313__$1 = (function (){var statearr_63331 = state_63313;
(statearr_63331[(12)] = inst_63258__$1);

return statearr_63331;
})();
if(cljs.core.truth_(inst_63258__$1)){
var statearr_63332_63368 = state_63313__$1;
(statearr_63332_63368[(1)] = (6));

} else {
var statearr_63333_63369 = state_63313__$1;
(statearr_63333_63369[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (19))){
var inst_63292 = (state_63313[(7)]);
var inst_63272 = (state_63313[(10)]);
var inst_63294 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_63295 = [inst_63292];
var inst_63296 = cljs.core.PersistentHashMap.fromArrays(inst_63294,inst_63295);
var inst_63297 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_63272,inst_63296,private$);
var inst_63298 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_63297);
var state_63313__$1 = state_63313;
var statearr_63334_63370 = state_63313__$1;
(statearr_63334_63370[(2)] = inst_63298);

(statearr_63334_63370[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (11))){
var inst_63276 = (state_63313[(13)]);
var state_63313__$1 = state_63313;
var statearr_63336_63371 = state_63313__$1;
(statearr_63336_63371[(2)] = inst_63276);

(statearr_63336_63371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (9))){
var inst_63268 = (state_63313[(14)]);
var inst_63271 = (state_63313[(2)]);
var inst_63272 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63271),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63268)].join('');
var inst_63274 = ["Accept"];
var inst_63275 = ["application/json"];
var inst_63276 = cljs.core.PersistentHashMap.fromArrays(inst_63274,inst_63275);
var state_63313__$1 = (function (){var statearr_63337 = state_63313;
(statearr_63337[(13)] = inst_63276);

(statearr_63337[(10)] = inst_63272);

return statearr_63337;
})();
if(cljs.core.truth_(private$)){
var statearr_63338_63372 = state_63313__$1;
(statearr_63338_63372[(1)] = (10));

} else {
var statearr_63339_63373 = state_63313__$1;
(statearr_63339_63373[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (5))){
var _ = (function (){var statearr_63340 = state_63313;
(statearr_63340[(4)] = cljs.core.rest((state_63313[(4)])));

return statearr_63340;
})();
var state_63313__$1 = state_63313;
var ex63335 = (state_63313__$1[(2)]);
var statearr_63341_63374 = state_63313__$1;
(statearr_63341_63374[(5)] = ex63335);


if((ex63335 instanceof Error)){
var statearr_63342_63375 = state_63313__$1;
(statearr_63342_63375[(1)] = (4));

(statearr_63342_63375[(5)] = null);

} else {
throw ex63335;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (14))){
var inst_63281 = (state_63313[(11)]);
var state_63313__$1 = state_63313;
var statearr_63343_63376 = state_63313__$1;
(statearr_63343_63376[(2)] = inst_63281);

(statearr_63343_63376[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (16))){
var inst_63286 = (state_63313[(9)]);
var inst_63267 = (state_63313[(8)]);
var inst_63288 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63267)].join('');
var inst_63289 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63286,"Authorization",inst_63288);
var state_63313__$1 = state_63313;
var statearr_63344_63377 = state_63313__$1;
(statearr_63344_63377[(2)] = inst_63289);

(statearr_63344_63377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (10))){
var inst_63276 = (state_63313[(13)]);
var inst_63278 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63276,"X-fdb-pri",private$);
var state_63313__$1 = state_63313;
var statearr_63345_63378 = state_63313__$1;
(statearr_63345_63378[(2)] = inst_63278);

(statearr_63345_63378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (18))){
var inst_63292 = (state_63313[(2)]);
var state_63313__$1 = (function (){var statearr_63346 = state_63313;
(statearr_63346[(7)] = inst_63292);

return statearr_63346;
})();
if(cljs.core.truth_(private$)){
var statearr_63347_63379 = state_63313__$1;
(statearr_63347_63379[(1)] = (19));

} else {
var statearr_63348_63380 = state_63313__$1;
(statearr_63348_63380[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63314 === (8))){
var inst_63267 = (state_63313[(2)]);
var inst_63268 = clojure.string.replace(k,"_","/");
var inst_63269 = fluree.db.connection.get_server(conn_id,servers);
var state_63313__$1 = (function (){var statearr_63349 = state_63313;
(statearr_63349[(14)] = inst_63268);

(statearr_63349[(8)] = inst_63267);

return statearr_63349;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63313__$1,(9),inst_63269);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2414__auto__ = null;
var fluree$db$connection$state_machine__2414__auto____0 = (function (){
var statearr_63350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63350[(0)] = fluree$db$connection$state_machine__2414__auto__);

(statearr_63350[(1)] = (1));

return statearr_63350;
});
var fluree$db$connection$state_machine__2414__auto____1 = (function (state_63313){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63313);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63351){var ex__2417__auto__ = e63351;
var statearr_63352_63381 = state_63313;
(statearr_63352_63381[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63313[(4)]))){
var statearr_63353_63382 = state_63313;
(statearr_63353_63382[(1)] = cljs.core.first((state_63313[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63383 = state_63313;
state_63313 = G__63383;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2414__auto__ = function(state_63313){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2414__auto____1.call(this,state_63313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2414__auto____0;
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2414__auto____1;
return fluree$db$connection$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63354 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63354[(6)] = c__2436__auto__);

return statearr_63354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63384_SHARP_){
if(cljs.core.truth_(p1__63384_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63385 = opts;
var map__63385__$1 = (((((!((map__63385 == null))))?(((((map__63385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__63385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__63385):map__63385);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63385__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63385__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e63387){var _ = e63387;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__63388_63389 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__63388_63389.cljs$core$IFn$_invoke$arity$0 ? fexpr__63388_63389.cljs$core$IFn$_invoke$arity$0() : fexpr__63388_63389.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___63422 = arguments.length;
var i__4737__auto___63423 = (0);
while(true){
if((i__4737__auto___63423 < len__4736__auto___63422)){
args__4742__auto__.push((arguments[i__4737__auto___63423]));

var G__63424 = (i__4737__auto___63423 + (1));
i__4737__auto___63423 = G__63424;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63392){
var vec__63393 = p__63392;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63393,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2436__auto___63425 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63410){
var state_val_63411 = (state_63410[(1)]);
if((state_val_63411 === (1))){
var inst_63396 = fluree.db.connection.get_socket(conn);
var state_63410__$1 = state_63410;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63410__$1,(2),inst_63396);
} else {
if((state_val_63411 === (2))){
var inst_63398 = (state_63410[(2)]);
var inst_63399 = (inst_63398 == null);
var inst_63400 = fluree.db.util.core.exception_QMARK_(inst_63398);
var inst_63401 = ((inst_63399) || (inst_63400));
var state_63410__$1 = state_63410;
if(cljs.core.truth_(inst_63401)){
var statearr_63412_63426 = state_63410__$1;
(statearr_63412_63426[(1)] = (3));

} else {
var statearr_63413_63427 = state_63410__$1;
(statearr_63413_63427[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (3))){
var inst_63403 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_63404 = cljs.core.async.close_BANG_(conn);
var state_63410__$1 = (function (){var statearr_63414 = state_63410;
(statearr_63414[(7)] = inst_63403);

return statearr_63414;
})();
var statearr_63415_63428 = state_63410__$1;
(statearr_63415_63428[(2)] = inst_63404);

(statearr_63415_63428[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (4))){
var inst_63406 = fluree.db.connection.msg_consumer(conn);
var state_63410__$1 = state_63410;
var statearr_63416_63429 = state_63410__$1;
(statearr_63416_63429[(2)] = inst_63406);

(statearr_63416_63429[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63411 === (5))){
var inst_63408 = (state_63410[(2)]);
var state_63410__$1 = state_63410;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63410__$1,inst_63408);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2414__auto__ = null;
var fluree$db$connection$state_machine__2414__auto____0 = (function (){
var statearr_63417 = [null,null,null,null,null,null,null,null];
(statearr_63417[(0)] = fluree$db$connection$state_machine__2414__auto__);

(statearr_63417[(1)] = (1));

return statearr_63417;
});
var fluree$db$connection$state_machine__2414__auto____1 = (function (state_63410){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63410);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63418){var ex__2417__auto__ = e63418;
var statearr_63419_63430 = state_63410;
(statearr_63419_63430[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63410[(4)]))){
var statearr_63420_63431 = state_63410;
(statearr_63420_63431[(1)] = cljs.core.first((state_63410[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63432 = state_63410;
state_63410 = G__63432;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2414__auto__ = function(state_63410){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2414__auto____1.call(this,state_63410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2414__auto____0;
fluree$db$connection$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2414__auto____1;
return fluree$db$connection$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63421 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63421[(6)] = c__2436__auto___63425);

return statearr_63421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63390){
var G__63391 = cljs.core.first(seq63390);
var seq63390__$1 = cljs.core.next(seq63390);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63391,seq63390__$1);
}));

