// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 * 
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
if(fluree.db.connection_js.dbaas_QMARK_(conn)){
return true;
} else {
return fluree.db.token_auth.verify_jwt(secret,jwt);
}
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63443 = arguments.length;
switch (G__63443) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63485){
var state_val_63486 = (state_63485[(1)]);
if((state_val_63486 === (7))){
var inst_63455 = typeof user === 'string';
var state_63485__$1 = state_63485;
if(cljs.core.truth_(inst_63455)){
var statearr_63487_63516 = state_63485__$1;
(statearr_63487_63516[(1)] = (9));

} else {
var statearr_63488_63517 = state_63485__$1;
(statearr_63488_63517[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (1))){
var state_63485__$1 = state_63485;
var statearr_63489_63518 = state_63485__$1;
(statearr_63489_63518[(2)] = null);

(statearr_63489_63518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (4))){
var inst_63444 = (state_63485[(2)]);
var inst_63445 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63444], 0));
var inst_63446 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63444) : reject.call(null,inst_63444));
var state_63485__$1 = (function (){var statearr_63490 = state_63485;
(statearr_63490[(7)] = inst_63445);

return statearr_63490;
})();
var statearr_63491_63519 = state_63485__$1;
(statearr_63491_63519[(2)] = inst_63446);

(statearr_63491_63519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (15))){
var inst_63474 = (state_63485[(2)]);
var inst_63475 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63474);
var inst_63476 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63477 = cljs.core.constantly(inst_63475);
var inst_63478 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63476,inst_63477);
var inst_63479 = fluree.db.connection.add_token(conn,inst_63475);
var inst_63480 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_63474) : resolve.call(null,inst_63474));
var _ = (function (){var statearr_63492 = state_63485;
(statearr_63492[(4)] = cljs.core.rest((state_63485[(4)])));

return statearr_63492;
})();
var state_63485__$1 = (function (){var statearr_63493 = state_63485;
(statearr_63493[(8)] = inst_63478);

(statearr_63493[(9)] = inst_63479);

return statearr_63493;
})();
var statearr_63494_63520 = state_63485__$1;
(statearr_63494_63520[(2)] = inst_63480);

(statearr_63494_63520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (13))){
var state_63485__$1 = state_63485;
var statearr_63495_63521 = state_63485__$1;
(statearr_63495_63521[(2)] = null);

(statearr_63495_63521[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (6))){
var state_63485__$1 = state_63485;
var statearr_63496_63522 = state_63485__$1;
(statearr_63496_63522[(2)] = user);

(statearr_63496_63522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (3))){
var inst_63483 = (state_63485[(2)]);
var state_63485__$1 = state_63485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63485__$1,inst_63483);
} else {
if((state_val_63486 === (12))){
var state_63485__$1 = state_63485;
var statearr_63497_63523 = state_63485__$1;
(statearr_63497_63523[(2)] = user);

(statearr_63497_63523[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (2))){
var _ = (function (){var statearr_63498 = state_63485;
(statearr_63498[(4)] = cljs.core.cons((5),(state_63485[(4)])));

return statearr_63498;
})();
var inst_63452 = typeof user === 'number';
var state_63485__$1 = state_63485;
if(cljs.core.truth_(inst_63452)){
var statearr_63499_63524 = state_63485__$1;
(statearr_63499_63524[(1)] = (6));

} else {
var statearr_63500_63525 = state_63485__$1;
(statearr_63500_63525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (11))){
var inst_63466 = (state_63485[(2)]);
var state_63485__$1 = state_63485;
var statearr_63502_63526 = state_63485__$1;
(statearr_63502_63526[(2)] = inst_63466);

(statearr_63502_63526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (9))){
var inst_63457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63458 = ["_user/username",user];
var inst_63459 = (new cljs.core.PersistentVector(null,2,(5),inst_63457,inst_63458,null));
var state_63485__$1 = state_63485;
var statearr_63503_63527 = state_63485__$1;
(statearr_63503_63527[(2)] = inst_63459);

(statearr_63503_63527[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (5))){
var _ = (function (){var statearr_63504 = state_63485;
(statearr_63504[(4)] = cljs.core.rest((state_63485[(4)])));

return statearr_63504;
})();
var state_63485__$1 = state_63485;
var ex63501 = (state_63485__$1[(2)]);
var statearr_63505_63528 = state_63485__$1;
(statearr_63505_63528[(5)] = ex63501);


var statearr_63506_63529 = state_63485__$1;
(statearr_63506_63529[(1)] = (4));

(statearr_63506_63529[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (14))){
var inst_63464 = (state_63485[(2)]);
var state_63485__$1 = state_63485;
var statearr_63507_63530 = state_63485__$1;
(statearr_63507_63530[(2)] = inst_63464);

(statearr_63507_63530[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (10))){
var state_63485__$1 = state_63485;
var statearr_63508_63531 = state_63485__$1;
(statearr_63508_63531[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63486 === (8))){
var inst_63468 = (state_63485[(2)]);
var inst_63469 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63470 = [account,inst_63468,password,expireSeconds,syncTo];
var inst_63471 = cljs.core.PersistentHashMap.fromArrays(inst_63469,inst_63470);
var inst_63472 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63471);
var state_63485__$1 = state_63485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63485__$1,(15),inst_63472);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63510 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63510[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63510[(1)] = (1));

return statearr_63510;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63485){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63485);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63511){var ex__2417__auto__ = e63511;
var statearr_63512_63532 = state_63485;
(statearr_63512_63532[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63485[(4)]))){
var statearr_63513_63533 = state_63485;
(statearr_63513_63533[(1)] = cljs.core.first((state_63485[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63534 = state_63485;
state_63485 = G__63534;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63485){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63514 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63514[(6)] = c__2436__auto__);

return statearr_63514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63536 = arguments.length;
switch (G__63536) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63545){
var state_val_63546 = (state_63545[(1)]);
if((state_val_63546 === (1))){
var inst_63537 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63539 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63540 = (new cljs.core.PersistentVector(null,4,(5),inst_63538,inst_63539,null));
var inst_63541 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63537,inst_63540);
var inst_63542 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63547 = cljs.core.seq(cljs.core.keys(x));
var chunk__63548 = null;
var count__63549 = (0);
var i__63550 = (0);
while(true){
if((i__63550 < count__63549)){
var k = chunk__63548.cljs$core$IIndexed$_nth$arity$2(null,i__63550);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63558 = seq__63547;
var G__63559 = chunk__63548;
var G__63560 = count__63549;
var G__63561 = (i__63550 + (1));
seq__63547 = G__63558;
chunk__63548 = G__63559;
count__63549 = G__63560;
i__63550 = G__63561;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63547);
if(temp__5735__auto__){
var seq__63547__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63547__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__63547__$1);
var G__63562 = cljs.core.chunk_rest(seq__63547__$1);
var G__63563 = c__4556__auto__;
var G__63564 = cljs.core.count(c__4556__auto__);
var G__63565 = (0);
seq__63547 = G__63562;
chunk__63548 = G__63563;
count__63549 = G__63564;
i__63550 = G__63565;
continue;
} else {
var k = cljs.core.first(seq__63547__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63566 = cljs.core.next(seq__63547__$1);
var G__63567 = null;
var G__63568 = (0);
var G__63569 = (0);
seq__63547 = G__63566;
chunk__63548 = G__63567;
count__63549 = G__63568;
i__63550 = G__63569;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63543 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63542);
var state_63545__$1 = (function (){var statearr_63551 = state_63545;
(statearr_63551[(7)] = inst_63541);

return statearr_63551;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63545__$1,inst_63543);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63552 = [null,null,null,null,null,null,null,null];
(statearr_63552[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63552[(1)] = (1));

return statearr_63552;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63545){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63545);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63553){var ex__2417__auto__ = e63553;
var statearr_63554_63570 = state_63545;
(statearr_63554_63570[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63545[(4)]))){
var statearr_63555_63571 = state_63545;
(statearr_63555_63571[(1)] = cljs.core.first((state_63545[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63572 = state_63545;
state_63545 = G__63572;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63545){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63556 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63556[(6)] = c__2436__auto__);

return statearr_63556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63574 = arguments.length;
switch (G__63574) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63608){
var state_val_63609 = (state_63608[(1)]);
if((state_val_63609 === (1))){
var state_63608__$1 = state_63608;
var statearr_63610_63631 = state_63608__$1;
(statearr_63610_63631[(2)] = null);

(statearr_63610_63631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63609 === (2))){
var _ = (function (){var statearr_63611 = state_63608;
(statearr_63611[(4)] = cljs.core.cons((5),(state_63608[(4)])));

return statearr_63611;
})();
var inst_63583 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63585 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63586 = (new cljs.core.PersistentVector(null,1,(5),inst_63584,inst_63585,null));
var inst_63587 = cljs.core.PersistentHashMap.EMPTY;
var inst_63588 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63587);
var inst_63589 = cljs.core.assoc_in(inst_63583,inst_63586,inst_63588);
var inst_63590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63591 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63592 = (new cljs.core.PersistentVector(null,1,(5),inst_63590,inst_63591,null));
var inst_63593 = cljs.core.PersistentHashMap.EMPTY;
var inst_63594 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63593);
var inst_63595 = cljs.core.assoc_in(inst_63589,inst_63592,inst_63594);
var inst_63596 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63597 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63595);
var inst_63598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63599 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63596,null];
var inst_63600 = (new cljs.core.PersistentVector(null,4,(5),inst_63598,inst_63599,null));
var inst_63601 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63597,inst_63600);
var inst_63602 = (function (){var conn = inst_63595;
var pc = inst_63596;
return (function (x){
if((x == null)){
} else {
var seq__63612_63632 = cljs.core.seq(cljs.core.keys(x));
var chunk__63613_63633 = null;
var count__63614_63634 = (0);
var i__63615_63635 = (0);
while(true){
if((i__63615_63635 < count__63614_63634)){
var k_63636 = chunk__63613_63633.cljs$core$IIndexed$_nth$arity$2(null,i__63615_63635);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63636], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63636,null));


var G__63637 = seq__63612_63632;
var G__63638 = chunk__63613_63633;
var G__63639 = count__63614_63634;
var G__63640 = (i__63615_63635 + (1));
seq__63612_63632 = G__63637;
chunk__63613_63633 = G__63638;
count__63614_63634 = G__63639;
i__63615_63635 = G__63640;
continue;
} else {
var temp__5735__auto___63641 = cljs.core.seq(seq__63612_63632);
if(temp__5735__auto___63641){
var seq__63612_63642__$1 = temp__5735__auto___63641;
if(cljs.core.chunked_seq_QMARK_(seq__63612_63642__$1)){
var c__4556__auto___63643 = cljs.core.chunk_first(seq__63612_63642__$1);
var G__63644 = cljs.core.chunk_rest(seq__63612_63642__$1);
var G__63645 = c__4556__auto___63643;
var G__63646 = cljs.core.count(c__4556__auto___63643);
var G__63647 = (0);
seq__63612_63632 = G__63644;
chunk__63613_63633 = G__63645;
count__63614_63634 = G__63646;
i__63615_63635 = G__63647;
continue;
} else {
var k_63648 = cljs.core.first(seq__63612_63642__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63648], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63648,null));


var G__63649 = cljs.core.next(seq__63612_63642__$1);
var G__63650 = null;
var G__63651 = (0);
var G__63652 = (0);
seq__63612_63632 = G__63649;
chunk__63613_63633 = G__63650;
count__63614_63634 = G__63651;
i__63615_63635 = G__63652;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63603 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63596,inst_63602);
var ___$1 = (function (){var statearr_63616 = state_63608;
(statearr_63616[(4)] = cljs.core.rest((state_63608[(4)])));

return statearr_63616;
})();
var state_63608__$1 = (function (){var statearr_63617 = state_63608;
(statearr_63617[(7)] = inst_63601);

return statearr_63617;
})();
var statearr_63618_63653 = state_63608__$1;
(statearr_63618_63653[(2)] = inst_63603);

(statearr_63618_63653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63609 === (3))){
var inst_63606 = (state_63608[(2)]);
var state_63608__$1 = state_63608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63608__$1,inst_63606);
} else {
if((state_val_63609 === (4))){
var inst_63575 = (state_63608[(2)]);
var inst_63576 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63575], 0));
var inst_63577 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63575) : reject.call(null,inst_63575));
var state_63608__$1 = (function (){var statearr_63620 = state_63608;
(statearr_63620[(8)] = inst_63576);

return statearr_63620;
})();
var statearr_63621_63654 = state_63608__$1;
(statearr_63621_63654[(2)] = inst_63577);

(statearr_63621_63654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63609 === (5))){
var _ = (function (){var statearr_63622 = state_63608;
(statearr_63622[(4)] = cljs.core.rest((state_63608[(4)])));

return statearr_63622;
})();
var state_63608__$1 = state_63608;
var ex63619 = (state_63608__$1[(2)]);
var statearr_63623_63655 = state_63608__$1;
(statearr_63623_63655[(5)] = ex63619);


var statearr_63624_63656 = state_63608__$1;
(statearr_63624_63656[(1)] = (4));

(statearr_63624_63656[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63625 = [null,null,null,null,null,null,null,null,null];
(statearr_63625[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63625[(1)] = (1));

return statearr_63625;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63608){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63608);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63626){var ex__2417__auto__ = e63626;
var statearr_63627_63657 = state_63608;
(statearr_63627_63657[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63608[(4)]))){
var statearr_63628_63658 = state_63608;
(statearr_63628_63658[(1)] = cljs.core.first((state_63608[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63659 = state_63608;
state_63608 = G__63659;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63608){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63629 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63629[(6)] = c__2436__auto__);

return statearr_63629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63661 = arguments.length;
switch (G__63661) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63663 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63663,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63663,(1),null);
var cb_STAR_ = (function (header,data){
var G__63666 = cljs.core.clj__GT_js(header);
var G__63667 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63666,G__63667) : callback.call(null,G__63666,G__63667));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63668 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63668,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63668,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63721){
var state_val_63722 = (state_63721[(1)]);
if((state_val_63722 === (7))){
var inst_63682 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63683 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63684 = cljs.core.PersistentHashMap.fromArrays(inst_63682,inst_63683);
var inst_63685 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63684);
var inst_63686 = (function(){throw inst_63685})();
var state_63721__$1 = state_63721;
var statearr_63723_63755 = state_63721__$1;
(statearr_63723_63755[(2)] = inst_63686);

(statearr_63723_63755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (1))){
var state_63721__$1 = state_63721;
var statearr_63724_63756 = state_63721__$1;
(statearr_63724_63756[(2)] = null);

(statearr_63724_63756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (4))){
var inst_63671 = (state_63721[(2)]);
var inst_63672 = cljs.core.clj__GT_js(inst_63671);
var inst_63673 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63672) : reject.call(null,inst_63672));
var state_63721__$1 = state_63721;
var statearr_63725_63757 = state_63721__$1;
(statearr_63725_63757[(2)] = inst_63673);

(statearr_63725_63757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (13))){
var inst_63700 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63701 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63702 = cljs.core.PersistentHashMap.fromArrays(inst_63700,inst_63701);
var inst_63703 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63702);
var inst_63704 = (function(){throw inst_63703})();
var state_63721__$1 = state_63721;
var statearr_63726_63758 = state_63721__$1;
(statearr_63726_63758[(2)] = inst_63704);

(statearr_63726_63758[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (6))){
var state_63721__$1 = state_63721;
var statearr_63727_63759 = state_63721__$1;
(statearr_63727_63759[(2)] = null);

(statearr_63727_63759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (3))){
var inst_63719 = (state_63721[(2)]);
var state_63721__$1 = state_63721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63721__$1,inst_63719);
} else {
if((state_val_63722 === (12))){
var state_63721__$1 = state_63721;
var statearr_63728_63760 = state_63721__$1;
(statearr_63728_63760[(2)] = null);

(statearr_63728_63760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (2))){
var _ = (function (){var statearr_63729 = state_63721;
(statearr_63729[(4)] = cljs.core.cons((5),(state_63721[(4)])));

return statearr_63729;
})();
var inst_63679 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63721__$1 = state_63721;
if(cljs.core.truth_(inst_63679)){
var statearr_63730_63761 = state_63721__$1;
(statearr_63730_63761[(1)] = (6));

} else {
var statearr_63731_63762 = state_63721__$1;
(statearr_63731_63762[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (11))){
var inst_63697 = (state_63721[(2)]);
var state_63721__$1 = (function (){var statearr_63733 = state_63721;
(statearr_63733[(7)] = inst_63697);

return statearr_63733;
})();
if(cljs.core.truth_(password)){
var statearr_63734_63763 = state_63721__$1;
(statearr_63734_63763[(1)] = (12));

} else {
var statearr_63735_63764 = state_63721__$1;
(statearr_63735_63764[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (9))){
var state_63721__$1 = state_63721;
var statearr_63736_63765 = state_63721__$1;
(statearr_63736_63765[(2)] = null);

(statearr_63736_63765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (5))){
var _ = (function (){var statearr_63737 = state_63721;
(statearr_63737[(4)] = cljs.core.rest((state_63721[(4)])));

return statearr_63737;
})();
var state_63721__$1 = state_63721;
var ex63732 = (state_63721__$1[(2)]);
var statearr_63738_63766 = state_63721__$1;
(statearr_63738_63766[(5)] = ex63732);


var statearr_63739_63767 = state_63721__$1;
(statearr_63739_63767[(1)] = (4));

(statearr_63739_63767[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (14))){
var inst_63706 = (state_63721[(2)]);
var inst_63707 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63708 = fluree.db.util.core.without_nils(inst_63707);
var inst_63709 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63710 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63712 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63708,inst_63709,null];
var inst_63713 = (new cljs.core.PersistentVector(null,4,(5),inst_63711,inst_63712,null));
var inst_63714 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63710,inst_63713);
var inst_63715 = (function (){var _ = inst_63706;
var data = inst_63708;
var pc = inst_63709;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63740 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63740) : reject.call(null,G__63740));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63741 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63741) : reject.call(null,G__63741));
} else {
var G__63742 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63742) : resolve.call(null,G__63742));

}
}
});
})();
var inst_63716 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63709,inst_63715);
var _ = (function (){var statearr_63743 = state_63721;
(statearr_63743[(4)] = cljs.core.rest((state_63721[(4)])));

return statearr_63743;
})();
var state_63721__$1 = (function (){var statearr_63744 = state_63721;
(statearr_63744[(8)] = inst_63714);

return statearr_63744;
})();
var statearr_63745_63768 = state_63721__$1;
(statearr_63745_63768[(2)] = inst_63716);

(statearr_63745_63768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (10))){
var inst_63691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63692 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63693 = cljs.core.PersistentHashMap.fromArrays(inst_63691,inst_63692);
var inst_63694 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63693);
var inst_63695 = (function(){throw inst_63694})();
var state_63721__$1 = state_63721;
var statearr_63746_63769 = state_63721__$1;
(statearr_63746_63769[(2)] = inst_63695);

(statearr_63746_63769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63722 === (8))){
var inst_63688 = (state_63721[(2)]);
var state_63721__$1 = (function (){var statearr_63747 = state_63721;
(statearr_63747[(9)] = inst_63688);

return statearr_63747;
})();
if(cljs.core.truth_(ledger)){
var statearr_63748_63770 = state_63721__$1;
(statearr_63748_63770[(1)] = (9));

} else {
var statearr_63749_63771 = state_63721__$1;
(statearr_63749_63771[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0 = (function (){
var statearr_63750 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63750[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2414__auto__);

(statearr_63750[(1)] = (1));

return statearr_63750;
});
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1 = (function (state_63721){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63721);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63751){var ex__2417__auto__ = e63751;
var statearr_63752_63772 = state_63721;
(statearr_63752_63772[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63721[(4)]))){
var statearr_63753_63773 = state_63721;
(statearr_63753_63773[(1)] = cljs.core.first((state_63721[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63774 = state_63721;
state_63721 = G__63774;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__ = function(state_63721){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1.call(this,state_63721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63754 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63754[(6)] = c__2436__auto__);

return statearr_63754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63776 = arguments.length;
switch (G__63776) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63843){
var state_val_63844 = (state_63843[(1)]);
if((state_val_63844 === (7))){
var inst_63788 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63789 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63790 = cljs.core.PersistentHashMap.fromArrays(inst_63788,inst_63789);
var inst_63791 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63790);
var inst_63792 = (function(){throw inst_63791})();
var state_63843__$1 = state_63843;
var statearr_63845_63887 = state_63843__$1;
(statearr_63845_63887[(2)] = inst_63792);

(statearr_63845_63887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (20))){
var inst_63826 = (state_63843[(2)]);
var inst_63827 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63828 = [ledger,password,user,auth,expire];
var inst_63829 = cljs.core.PersistentHashMap.fromArrays(inst_63827,inst_63828);
var inst_63830 = fluree.db.util.core.without_nils(inst_63829);
var inst_63831 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63832 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63834 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63830,inst_63831,null];
var inst_63835 = (new cljs.core.PersistentVector(null,4,(5),inst_63833,inst_63834,null));
var inst_63836 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63832,inst_63835);
var inst_63837 = (function (){var _ = inst_63826;
var data = inst_63830;
var pc = inst_63831;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63846 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63846) : reject.call(null,G__63846));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63847 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63847) : reject.call(null,G__63847));
} else {
var G__63848 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63848) : resolve.call(null,G__63848));

}
}
});
})();
var inst_63838 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63831,inst_63837);
var _ = (function (){var statearr_63849 = state_63843;
(statearr_63849[(4)] = cljs.core.rest((state_63843[(4)])));

return statearr_63849;
})();
var state_63843__$1 = (function (){var statearr_63850 = state_63843;
(statearr_63850[(7)] = inst_63836);

return statearr_63850;
})();
var statearr_63851_63888 = state_63843__$1;
(statearr_63851_63888[(2)] = inst_63838);

(statearr_63851_63888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (1))){
var state_63843__$1 = state_63843;
var statearr_63852_63889 = state_63843__$1;
(statearr_63852_63889[(2)] = null);

(statearr_63852_63889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (4))){
var inst_63777 = (state_63843[(2)]);
var inst_63778 = cljs.core.clj__GT_js(inst_63777);
var inst_63779 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63778) : reject.call(null,inst_63778));
var state_63843__$1 = state_63843;
var statearr_63853_63890 = state_63843__$1;
(statearr_63853_63890[(2)] = inst_63779);

(statearr_63853_63890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (15))){
var inst_63813 = (state_63843[(8)]);
var state_63843__$1 = state_63843;
var statearr_63854_63891 = state_63843__$1;
(statearr_63854_63891[(2)] = inst_63813);

(statearr_63854_63891[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (13))){
var inst_63806 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63807 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63808 = cljs.core.PersistentHashMap.fromArrays(inst_63806,inst_63807);
var inst_63809 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63808);
var inst_63810 = (function(){throw inst_63809})();
var state_63843__$1 = state_63843;
var statearr_63855_63892 = state_63843__$1;
(statearr_63855_63892[(2)] = inst_63810);

(statearr_63855_63892[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (6))){
var state_63843__$1 = state_63843;
var statearr_63856_63893 = state_63843__$1;
(statearr_63856_63893[(2)] = null);

(statearr_63856_63893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (17))){
var inst_63817 = (state_63843[(2)]);
var state_63843__$1 = state_63843;
if(cljs.core.truth_(inst_63817)){
var statearr_63857_63894 = state_63843__$1;
(statearr_63857_63894[(1)] = (18));

} else {
var statearr_63858_63895 = state_63843__$1;
(statearr_63858_63895[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (3))){
var inst_63841 = (state_63843[(2)]);
var state_63843__$1 = state_63843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63843__$1,inst_63841);
} else {
if((state_val_63844 === (12))){
var state_63843__$1 = state_63843;
var statearr_63859_63896 = state_63843__$1;
(statearr_63859_63896[(2)] = null);

(statearr_63859_63896[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (2))){
var _ = (function (){var statearr_63860 = state_63843;
(statearr_63860[(4)] = cljs.core.cons((5),(state_63843[(4)])));

return statearr_63860;
})();
var inst_63785 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63843__$1 = state_63843;
if(cljs.core.truth_(inst_63785)){
var statearr_63861_63897 = state_63843__$1;
(statearr_63861_63897[(1)] = (6));

} else {
var statearr_63862_63898 = state_63843__$1;
(statearr_63862_63898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (19))){
var inst_63820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63821 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63822 = cljs.core.PersistentHashMap.fromArrays(inst_63820,inst_63821);
var inst_63823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63822);
var inst_63824 = (function(){throw inst_63823})();
var state_63843__$1 = state_63843;
var statearr_63863_63899 = state_63843__$1;
(statearr_63863_63899[(2)] = inst_63824);

(statearr_63863_63899[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (11))){
var inst_63803 = (state_63843[(2)]);
var state_63843__$1 = (function (){var statearr_63865 = state_63843;
(statearr_63865[(9)] = inst_63803);

return statearr_63865;
})();
if(cljs.core.truth_(password)){
var statearr_63866_63900 = state_63843__$1;
(statearr_63866_63900[(1)] = (12));

} else {
var statearr_63867_63901 = state_63843__$1;
(statearr_63867_63901[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (9))){
var state_63843__$1 = state_63843;
var statearr_63868_63902 = state_63843__$1;
(statearr_63868_63902[(2)] = null);

(statearr_63868_63902[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (5))){
var _ = (function (){var statearr_63869 = state_63843;
(statearr_63869[(4)] = cljs.core.rest((state_63843[(4)])));

return statearr_63869;
})();
var state_63843__$1 = state_63843;
var ex63864 = (state_63843__$1[(2)]);
var statearr_63870_63903 = state_63843__$1;
(statearr_63870_63903[(5)] = ex63864);


var statearr_63871_63904 = state_63843__$1;
(statearr_63871_63904[(1)] = (4));

(statearr_63871_63904[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (14))){
var inst_63813 = (state_63843[(8)]);
var inst_63812 = (state_63843[(2)]);
var inst_63813__$1 = user;
var state_63843__$1 = (function (){var statearr_63872 = state_63843;
(statearr_63872[(10)] = inst_63812);

(statearr_63872[(8)] = inst_63813__$1);

return statearr_63872;
})();
if(cljs.core.truth_(inst_63813__$1)){
var statearr_63873_63905 = state_63843__$1;
(statearr_63873_63905[(1)] = (15));

} else {
var statearr_63874_63906 = state_63843__$1;
(statearr_63874_63906[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (16))){
var state_63843__$1 = state_63843;
var statearr_63875_63907 = state_63843__$1;
(statearr_63875_63907[(2)] = auth);

(statearr_63875_63907[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (10))){
var inst_63797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63798 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63799 = cljs.core.PersistentHashMap.fromArrays(inst_63797,inst_63798);
var inst_63800 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63799);
var inst_63801 = (function(){throw inst_63800})();
var state_63843__$1 = state_63843;
var statearr_63876_63908 = state_63843__$1;
(statearr_63876_63908[(2)] = inst_63801);

(statearr_63876_63908[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (18))){
var state_63843__$1 = state_63843;
var statearr_63877_63909 = state_63843__$1;
(statearr_63877_63909[(2)] = null);

(statearr_63877_63909[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63844 === (8))){
var inst_63794 = (state_63843[(2)]);
var state_63843__$1 = (function (){var statearr_63878 = state_63843;
(statearr_63878[(11)] = inst_63794);

return statearr_63878;
})();
if(cljs.core.truth_(ledger)){
var statearr_63879_63910 = state_63843__$1;
(statearr_63879_63910[(1)] = (9));

} else {
var statearr_63880_63911 = state_63843__$1;
(statearr_63880_63911[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63881 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63881[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63881[(1)] = (1));

return statearr_63881;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63843){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63843);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63882){var ex__2417__auto__ = e63882;
var statearr_63883_63912 = state_63843;
(statearr_63883_63912[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63843[(4)]))){
var statearr_63884_63913 = state_63843;
(statearr_63884_63913[(1)] = cljs.core.first((state_63843[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63914 = state_63843;
state_63843 = G__63914;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63843){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63885 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63885[(6)] = c__2436__auto__);

return statearr_63885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63916 = arguments.length;
switch (G__63916) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63951){
var state_val_63952 = (state_63951[(1)]);
if((state_val_63952 === (1))){
var state_63951__$1 = state_63951;
var statearr_63953_63975 = state_63951__$1;
(statearr_63953_63975[(2)] = null);

(statearr_63953_63975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (2))){
var _ = (function (){var statearr_63954 = state_63951;
(statearr_63954[(4)] = cljs.core.cons((5),(state_63951[(4)])));

return statearr_63954;
})();
var inst_63925 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63951__$1 = state_63951;
if(cljs.core.truth_(inst_63925)){
var statearr_63955_63976 = state_63951__$1;
(statearr_63955_63976[(1)] = (6));

} else {
var statearr_63956_63977 = state_63951__$1;
(statearr_63956_63977[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (3))){
var inst_63949 = (state_63951[(2)]);
var state_63951__$1 = state_63951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63951__$1,inst_63949);
} else {
if((state_val_63952 === (4))){
var inst_63917 = (state_63951[(2)]);
var inst_63918 = cljs.core.clj__GT_js(inst_63917);
var inst_63919 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63918) : reject.call(null,inst_63918));
var state_63951__$1 = state_63951;
var statearr_63958_63978 = state_63951__$1;
(statearr_63958_63978[(2)] = inst_63919);

(statearr_63958_63978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (5))){
var _ = (function (){var statearr_63959 = state_63951;
(statearr_63959[(4)] = cljs.core.rest((state_63951[(4)])));

return statearr_63959;
})();
var state_63951__$1 = state_63951;
var ex63957 = (state_63951__$1[(2)]);
var statearr_63960_63979 = state_63951__$1;
(statearr_63960_63979[(5)] = ex63957);


var statearr_63961_63980 = state_63951__$1;
(statearr_63961_63980[(1)] = (4));

(statearr_63961_63980[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (6))){
var state_63951__$1 = state_63951;
var statearr_63962_63981 = state_63951__$1;
(statearr_63962_63981[(2)] = null);

(statearr_63962_63981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (7))){
var inst_63928 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63929 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63930 = cljs.core.PersistentHashMap.fromArrays(inst_63928,inst_63929);
var inst_63931 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63930);
var inst_63932 = (function(){throw inst_63931})();
var state_63951__$1 = state_63951;
var statearr_63963_63982 = state_63951__$1;
(statearr_63963_63982[(2)] = inst_63932);

(statearr_63963_63982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63952 === (8))){
var inst_63934 = (state_63951[(2)]);
var inst_63935 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63936 = [jwt,expire];
var inst_63937 = cljs.core.PersistentHashMap.fromArrays(inst_63935,inst_63936);
var inst_63938 = fluree.db.util.core.without_nils(inst_63937);
var inst_63939 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63940 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63942 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63938,inst_63939,null];
var inst_63943 = (new cljs.core.PersistentVector(null,4,(5),inst_63941,inst_63942,null));
var inst_63944 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63940,inst_63943);
var inst_63945 = (function (){var _ = inst_63934;
var data = inst_63938;
var pc = inst_63939;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63964 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63964) : reject.call(null,G__63964));
} else {
return null;
}
} else {
var G__63965 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63965) : resolve.call(null,G__63965));

}
});
})();
var inst_63946 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63939,inst_63945);
var _ = (function (){var statearr_63966 = state_63951;
(statearr_63966[(4)] = cljs.core.rest((state_63951[(4)])));

return statearr_63966;
})();
var state_63951__$1 = (function (){var statearr_63967 = state_63951;
(statearr_63967[(7)] = inst_63944);

return statearr_63967;
})();
var statearr_63968_63983 = state_63951__$1;
(statearr_63968_63983[(2)] = inst_63946);

(statearr_63968_63983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63969 = [null,null,null,null,null,null,null,null];
(statearr_63969[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63969[(1)] = (1));

return statearr_63969;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63951){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63951);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63970){var ex__2417__auto__ = e63970;
var statearr_63971_63984 = state_63951;
(statearr_63971_63984[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63951[(4)]))){
var statearr_63972_63985 = state_63951;
(statearr_63972_63985[(1)] = cljs.core.first((state_63951[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63986 = state_63951;
state_63951 = G__63986;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63951){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63973 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63973[(6)] = c__2436__auto__);

return statearr_63973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

