// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28566 = arguments.length;
var i__4737__auto___28567 = (0);
while(true){
if((i__4737__auto___28567 < len__4736__auto___28566)){
args__4742__auto__.push((arguments[i__4737__auto___28567]));

var G__28568 = (i__4737__auto___28567 + (1));
i__4737__auto___28567 = G__28568;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28563){
var G__28564 = cljs.core.first(seq28563);
var seq28563__$1 = cljs.core.next(seq28563);
var G__28565 = cljs.core.first(seq28563__$1);
var seq28563__$2 = cljs.core.next(seq28563__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28564,G__28565,seq28563__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28569){var e = e28569;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28570){var e = e28570;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28571){var e = e28571;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28572){var e = e28572;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28573){var e = e28573;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28576 = arguments.length;
var i__4737__auto___28577 = (0);
while(true){
if((i__4737__auto___28577 < len__4736__auto___28576)){
args__4742__auto__.push((arguments[i__4737__auto___28577]));

var G__28578 = (i__4737__auto___28577 + (1));
i__4737__auto___28577 = G__28578;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28575){var e = e28575;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28574){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28574));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28581 = arguments.length;
var i__4737__auto___28582 = (0);
while(true){
if((i__4737__auto___28582 < len__4736__auto___28581)){
args__4742__auto__.push((arguments[i__4737__auto___28582]));

var G__28583 = (i__4737__auto___28582 + (1));
i__4737__auto___28582 = G__28583;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28580){var e = e28580;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28579){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28579));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28584){var e = e28584;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28587 = arguments.length;
var i__4737__auto___28588 = (0);
while(true){
if((i__4737__auto___28588 < len__4736__auto___28587)){
args__4742__auto__.push((arguments[i__4737__auto___28588]));

var G__28589 = (i__4737__auto___28588 + (1));
i__4737__auto___28588 = G__28589;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28586){var e = e28586;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28585){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28585));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28590){var e = e28590;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28591){var e = e28591;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28594 = arguments.length;
var i__4737__auto___28595 = (0);
while(true){
if((i__4737__auto___28595 < len__4736__auto___28594)){
args__4742__auto__.push((arguments[i__4737__auto___28595]));

var G__28596 = (i__4737__auto___28595 + (1));
i__4737__auto___28595 = G__28596;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28593){var e = e28593;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28592){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28592));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28599 = arguments.length;
var i__4737__auto___28600 = (0);
while(true){
if((i__4737__auto___28600 < len__4736__auto___28599)){
args__4742__auto__.push((arguments[i__4737__auto___28600]));

var G__28601 = (i__4737__auto___28600 + (1));
i__4737__auto___28600 = G__28601;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28598){var e = e28598;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28597){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28597));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28604 = arguments.length;
var i__4737__auto___28605 = (0);
while(true){
if((i__4737__auto___28605 < len__4736__auto___28604)){
args__4742__auto__.push((arguments[i__4737__auto___28605]));

var G__28606 = (i__4737__auto___28605 + (1));
i__4737__auto___28605 = G__28606;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28603){var e = e28603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28602){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28602));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28609 = arguments.length;
var i__4737__auto___28610 = (0);
while(true){
if((i__4737__auto___28610 < len__4736__auto___28609)){
args__4742__auto__.push((arguments[i__4737__auto___28610]));

var G__28611 = (i__4737__auto___28610 + (1));
i__4737__auto___28610 = G__28611;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28608){var e = e28608;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28607){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28607));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28614 = arguments.length;
var i__4737__auto___28615 = (0);
while(true){
if((i__4737__auto___28615 < len__4736__auto___28614)){
args__4742__auto__.push((arguments[i__4737__auto___28615]));

var G__28616 = (i__4737__auto___28615 + (1));
i__4737__auto___28615 = G__28616;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28613){var e = e28613;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28612){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28612));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28619 = arguments.length;
var i__4737__auto___28620 = (0);
while(true){
if((i__4737__auto___28620 < len__4736__auto___28619)){
args__4742__auto__.push((arguments[i__4737__auto___28620]));

var G__28621 = (i__4737__auto___28620 + (1));
i__4737__auto___28620 = G__28621;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28618){var e = e28618;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28617){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28617));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28623 = arguments.length;
switch (G__28623) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28651){
var state_val_28652 = (state_28651[(1)]);
if((state_val_28652 === (7))){
var inst_28636 = (state_28651[(7)]);
var inst_28639 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28636,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28651__$1 = state_28651;
var statearr_28653_28739 = state_28651__$1;
(statearr_28653_28739[(2)] = inst_28639);

(statearr_28653_28739[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (1))){
var state_28651__$1 = state_28651;
var statearr_28654_28740 = state_28651__$1;
(statearr_28654_28740[(2)] = null);

(statearr_28654_28740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (4))){
var inst_28624 = (state_28651[(2)]);
var state_28651__$1 = state_28651;
var statearr_28655_28741 = state_28651__$1;
(statearr_28655_28741[(2)] = inst_28624);

(statearr_28655_28741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (6))){
var inst_28636 = (state_28651[(7)]);
var inst_28636__$1 = (state_28651[(2)]);
var inst_28637 = fluree.db.util.core.exception_QMARK_(inst_28636__$1);
var state_28651__$1 = (function (){var statearr_28656 = state_28651;
(statearr_28656[(7)] = inst_28636__$1);

return statearr_28656;
})();
if(inst_28637){
var statearr_28657_28742 = state_28651__$1;
(statearr_28657_28742[(1)] = (7));

} else {
var statearr_28658_28743 = state_28651__$1;
(statearr_28658_28743[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (3))){
var inst_28649 = (state_28651[(2)]);
var state_28651__$1 = state_28651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28651__$1,inst_28649);
} else {
if((state_val_28652 === (2))){
var inst_28630 = (state_28651[(8)]);
var _ = (function (){var statearr_28660 = state_28651;
(statearr_28660[(4)] = cljs.core.cons((5),(state_28651[(4)])));

return statearr_28660;
})();
var inst_28630__$1 = cljs.core.volatile_BANG_((0));
var inst_28631 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28632 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28631,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28630__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28633 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28632);
var inst_28634 = fluree.db.query.fql.query(db,inst_28633);
var state_28651__$1 = (function (){var statearr_28661 = state_28651;
(statearr_28661[(8)] = inst_28630__$1);

return statearr_28661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28651__$1,(6),inst_28634);
} else {
if((state_val_28652 === (9))){
var inst_28646 = (state_28651[(2)]);
var _ = (function (){var statearr_28662 = state_28651;
(statearr_28662[(4)] = cljs.core.rest((state_28651[(4)])));

return statearr_28662;
})();
var state_28651__$1 = state_28651;
var statearr_28663_28744 = state_28651__$1;
(statearr_28663_28744[(2)] = inst_28646);

(statearr_28663_28744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (5))){
var _ = (function (){var statearr_28664 = state_28651;
(statearr_28664[(4)] = cljs.core.rest((state_28651[(4)])));

return statearr_28664;
})();
var state_28651__$1 = state_28651;
var ex28659 = (state_28651__$1[(2)]);
var statearr_28665_28745 = state_28651__$1;
(statearr_28665_28745[(5)] = ex28659);


if((ex28659 instanceof Error)){
var statearr_28666_28746 = state_28651__$1;
(statearr_28666_28746[(1)] = (4));

(statearr_28666_28746[(5)] = null);

} else {
throw ex28659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28652 === (8))){
var inst_28636 = (state_28651[(7)]);
var inst_28630 = (state_28651[(8)]);
var inst_28641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28642 = cljs.core.deref(inst_28630);
var inst_28643 = [inst_28636,inst_28642];
var inst_28644 = (new cljs.core.PersistentVector(null,2,(5),inst_28641,inst_28643,null));
var state_28651__$1 = state_28651;
var statearr_28667_28747 = state_28651__$1;
(statearr_28667_28747[(2)] = inst_28644);

(statearr_28667_28747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28668 = [null,null,null,null,null,null,null,null,null];
(statearr_28668[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28668[(1)] = (1));

return statearr_28668;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28651){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28651);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28669){var ex__2417__auto__ = e28669;
var statearr_28670_28748 = state_28651;
(statearr_28670_28748[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28651[(4)]))){
var statearr_28671_28749 = state_28651;
(statearr_28671_28749[(1)] = cljs.core.first((state_28651[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28750 = state_28651;
state_28651 = G__28750;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28651){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28672 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28672[(6)] = c__2436__auto__);

return statearr_28672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28717){
var state_val_28718 = (state_28717[(1)]);
if((state_val_28718 === (7))){
var inst_28703 = (state_28717[(2)]);
var inst_28704 = fluree.db.query.fql.query(db,inst_28703);
var state_28717__$1 = state_28717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28717__$1,(8),inst_28704);
} else {
if((state_val_28718 === (1))){
var inst_28673 = typeof select === 'string';
var state_28717__$1 = state_28717;
if(cljs.core.truth_(inst_28673)){
var statearr_28719_28751 = state_28717__$1;
(statearr_28719_28751[(1)] = (2));

} else {
var statearr_28720_28752 = state_28717__$1;
(statearr_28720_28752[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (4))){
var inst_28679 = (state_28717[(7)]);
var inst_28686 = (state_28717[(8)]);
var inst_28678 = (state_28717[(2)]);
var inst_28679__$1 = cljs.core.volatile_BANG_((0));
var inst_28680 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28681 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28682 = [inst_28679__$1,(100000)];
var inst_28683 = cljs.core.PersistentHashMap.fromArrays(inst_28681,inst_28682);
var inst_28684 = [inst_28678,from,where,block,limit,inst_28683];
var inst_28685 = cljs.core.PersistentHashMap.fromArrays(inst_28680,inst_28684);
var inst_28686__$1 = fluree.db.util.core.without_nils(inst_28685);
var inst_28687 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28686__$1);
var inst_28688 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28686__$1);
var inst_28689 = cljs.core.first(inst_28688);
var inst_28690 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28689], 0));
var inst_28691 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28690);
var inst_28692 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28686__$1);
var inst_28693 = cljs.core.last(inst_28692);
var inst_28694 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28693], 0));
var inst_28695 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28694);
var inst_28696 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28687,inst_28691,inst_28695], 0));
var state_28717__$1 = (function (){var statearr_28721 = state_28717;
(statearr_28721[(7)] = inst_28679__$1);

(statearr_28721[(8)] = inst_28686__$1);

return statearr_28721;
})();
if(cljs.core.truth_(inst_28696)){
var statearr_28722_28753 = state_28717__$1;
(statearr_28722_28753[(1)] = (5));

} else {
var statearr_28723_28754 = state_28717__$1;
(statearr_28723_28754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (6))){
var inst_28686 = (state_28717[(8)]);
var state_28717__$1 = state_28717;
var statearr_28724_28755 = state_28717__$1;
(statearr_28724_28755[(2)] = inst_28686);

(statearr_28724_28755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (3))){
var state_28717__$1 = state_28717;
var statearr_28725_28756 = state_28717__$1;
(statearr_28725_28756[(2)] = select);

(statearr_28725_28756[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (2))){
var inst_28675 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28717__$1 = state_28717;
var statearr_28726_28757 = state_28717__$1;
(statearr_28726_28757[(2)] = inst_28675);

(statearr_28726_28757[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (11))){
var inst_28715 = (state_28717[(2)]);
var state_28717__$1 = state_28717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28717__$1,inst_28715);
} else {
if((state_val_28718 === (9))){
var inst_28706 = (state_28717[(9)]);
var state_28717__$1 = state_28717;
var statearr_28727_28758 = state_28717__$1;
(statearr_28727_28758[(2)] = inst_28706);

(statearr_28727_28758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (5))){
var inst_28686 = (state_28717[(8)]);
var inst_28698 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28686);
var inst_28699 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28698);
var inst_28700 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28686,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28699);
var state_28717__$1 = state_28717;
var statearr_28728_28759 = state_28717__$1;
(statearr_28728_28759[(2)] = inst_28700);

(statearr_28728_28759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (10))){
var inst_28679 = (state_28717[(7)]);
var inst_28706 = (state_28717[(9)]);
var inst_28710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28711 = cljs.core.deref(inst_28679);
var inst_28712 = [inst_28706,inst_28711];
var inst_28713 = (new cljs.core.PersistentVector(null,2,(5),inst_28710,inst_28712,null));
var state_28717__$1 = state_28717;
var statearr_28729_28760 = state_28717__$1;
(statearr_28729_28760[(2)] = inst_28713);

(statearr_28729_28760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28718 === (8))){
var inst_28706 = (state_28717[(9)]);
var inst_28706__$1 = (state_28717[(2)]);
var inst_28707 = fluree.db.util.core.exception_QMARK_(inst_28706__$1);
var state_28717__$1 = (function (){var statearr_28730 = state_28717;
(statearr_28730[(9)] = inst_28706__$1);

return statearr_28730;
})();
if(inst_28707){
var statearr_28731_28761 = state_28717__$1;
(statearr_28731_28761[(1)] = (9));

} else {
var statearr_28732_28762 = state_28717__$1;
(statearr_28732_28762[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28733 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28733[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28733[(1)] = (1));

return statearr_28733;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28717){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28717);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28734){var ex__2417__auto__ = e28734;
var statearr_28735_28763 = state_28717;
(statearr_28735_28763[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28717[(4)]))){
var statearr_28736_28764 = state_28717;
(statearr_28736_28764[(1)] = cljs.core.first((state_28717[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28765 = state_28717;
state_28717 = G__28765;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28717){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28737 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28737[(6)] = c__2436__auto__);

return statearr_28737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__28766 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(var$,/\//);
var coll = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28766,(0),null);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28766,(1),null);
var pred__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(pred,(1));
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,"/",pred__$1], 0));
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28772 = path;
var vec__28773 = G__28772;
var seq__28774 = cljs.core.seq(vec__28773);
var first__28775 = cljs.core.first(seq__28774);
var seq__28774__$1 = cljs.core.next(seq__28774);
var var$ = first__28775;
var r = seq__28774__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28772__$1 = G__28772;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28779 = G__28772__$1;
var seq__28780 = cljs.core.seq(vec__28779);
var first__28781 = cljs.core.first(seq__28780);
var seq__28780__$1 = cljs.core.next(seq__28780);
var var$__$1 = first__28781;
var r__$1 = seq__28780__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28782 = r__$1;
var G__28783 = n__$2;
var G__28784 = next_clauses;
G__28772__$1 = G__28782;
n__$1 = G__28783;
where_clauses__$1 = G__28784;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28785 = r__$1;
var G__28786 = next_n;
var G__28787 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28772__$1 = G__28785;
n__$1 = G__28786;
where_clauses__$1 = G__28787;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28824){
var state_val_28825 = (state_28824[(1)]);
if((state_val_28825 === (7))){
var inst_28797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28798 = [path];
var inst_28799 = (new cljs.core.PersistentVector(null,1,(5),inst_28797,inst_28798,null));
var state_28824__$1 = state_28824;
var statearr_28826_28854 = state_28824__$1;
(statearr_28826_28854[(2)] = inst_28799);

(statearr_28826_28854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (1))){
var state_28824__$1 = state_28824;
var statearr_28827_28855 = state_28824__$1;
(statearr_28827_28855[(2)] = null);

(statearr_28827_28855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (4))){
var inst_28788 = (state_28824[(2)]);
var state_28824__$1 = state_28824;
var statearr_28828_28856 = state_28824__$1;
(statearr_28828_28856[(2)] = inst_28788);

(statearr_28828_28856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (13))){
var inst_28815 = (state_28824[(2)]);
var inst_28816 = fluree.db.util.async.throw_err(inst_28815);
var _ = (function (){var statearr_28829 = state_28824;
(statearr_28829[(4)] = cljs.core.rest((state_28824[(4)])));

return statearr_28829;
})();
var state_28824__$1 = state_28824;
var statearr_28830_28857 = state_28824__$1;
(statearr_28830_28857[(2)] = inst_28816);

(statearr_28830_28857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (6))){
var state_28824__$1 = state_28824;
var statearr_28832_28858 = state_28824__$1;
(statearr_28832_28858[(2)] = path);

(statearr_28832_28858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (3))){
var inst_28822 = (state_28824[(2)]);
var state_28824__$1 = state_28824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28824__$1,inst_28822);
} else {
if((state_val_28825 === (12))){
var _ = (function (){var statearr_28833 = state_28824;
(statearr_28833[(4)] = cljs.core.rest((state_28824[(4)])));

return statearr_28833;
})();
var state_28824__$1 = state_28824;
var ex28831 = (state_28824__$1[(2)]);
var statearr_28834_28859 = state_28824__$1;
(statearr_28834_28859[(5)] = ex28831);


var statearr_28835_28860 = state_28824__$1;
(statearr_28835_28860[(1)] = (11));

(statearr_28835_28860[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (2))){
var _ = (function (){var statearr_28836 = state_28824;
(statearr_28836[(4)] = cljs.core.cons((5),(state_28824[(4)])));

return statearr_28836;
})();
var inst_28794 = cljs.core.vector_QMARK_(path);
var state_28824__$1 = state_28824;
if(inst_28794){
var statearr_28837_28861 = state_28824__$1;
(statearr_28837_28861[(1)] = (6));

} else {
var statearr_28838_28862 = state_28824__$1;
(statearr_28838_28862[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (11))){
var inst_28801 = (state_28824[(7)]);
var inst_28806 = (state_28824[(2)]);
var inst_28807 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28806,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28801,endSubject], 0));
var state_28824__$1 = state_28824;
var statearr_28840_28863 = state_28824__$1;
(statearr_28840_28863[(2)] = inst_28807);

(statearr_28840_28863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (9))){
var inst_28805 = (state_28824[(8)]);
var _ = (function (){var statearr_28841 = state_28824;
(statearr_28841[(4)] = cljs.core.cons((12),(state_28824[(4)])));

return statearr_28841;
})();
var inst_28813 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28805);
var state_28824__$1 = state_28824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28824__$1,(13),inst_28813);
} else {
if((state_val_28825 === (5))){
var _ = (function (){var statearr_28842 = state_28824;
(statearr_28842[(4)] = cljs.core.rest((state_28824[(4)])));

return statearr_28842;
})();
var state_28824__$1 = state_28824;
var ex28839 = (state_28824__$1[(2)]);
var statearr_28843_28864 = state_28824__$1;
(statearr_28843_28864[(5)] = ex28839);


if((ex28839 instanceof Error)){
var statearr_28844_28865 = state_28824__$1;
(statearr_28844_28865[(1)] = (4));

(statearr_28844_28865[(5)] = null);

} else {
throw ex28839;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (10))){
var inst_28819 = (state_28824[(2)]);
var _ = (function (){var statearr_28845 = state_28824;
(statearr_28845[(4)] = cljs.core.rest((state_28824[(4)])));

return statearr_28845;
})();
var state_28824__$1 = state_28824;
var statearr_28846_28866 = state_28824__$1;
(statearr_28846_28866[(2)] = inst_28819);

(statearr_28846_28866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28825 === (8))){
var inst_28801 = (state_28824[(7)]);
var inst_28801__$1 = (state_28824[(2)]);
var inst_28802 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28801__$1,endSubject);
var inst_28803 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28804 = ["?var1",inst_28802];
var inst_28805 = cljs.core.PersistentHashMap.fromArrays(inst_28803,inst_28804);
var state_28824__$1 = (function (){var statearr_28847 = state_28824;
(statearr_28847[(7)] = inst_28801__$1);

(statearr_28847[(8)] = inst_28805);

return statearr_28847;
})();
var statearr_28848_28867 = state_28824__$1;
(statearr_28848_28867[(2)] = null);

(statearr_28848_28867[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_28849 = [null,null,null,null,null,null,null,null,null];
(statearr_28849[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__);

(statearr_28849[(1)] = (1));

return statearr_28849;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1 = (function (state_28824){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28824);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28850){var ex__2417__auto__ = e28850;
var statearr_28851_28868 = state_28824;
(statearr_28851_28868[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28824[(4)]))){
var statearr_28852_28869 = state_28824;
(statearr_28852_28869[(1)] = cljs.core.first((state_28824[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28870 = state_28824;
state_28824 = G__28870;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__ = function(state_28824){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1.call(this,state_28824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28853 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28853[(6)] = c__2436__auto__);

return statearr_28853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28871){var e = e28871;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28872){var e = e28872;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28873){var e = e28873;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28874){var e = e28874;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28877 = arguments.length;
var i__4737__auto___28878 = (0);
while(true){
if((i__4737__auto___28878 < len__4736__auto___28877)){
args__4742__auto__.push((arguments[i__4737__auto___28878]));

var G__28879 = (i__4737__auto___28878 + (1));
i__4737__auto___28878 = G__28879;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28876){var e = e28876;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28875){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28875));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28882 = arguments.length;
var i__4737__auto___28883 = (0);
while(true){
if((i__4737__auto___28883 < len__4736__auto___28882)){
args__4742__auto__.push((arguments[i__4737__auto___28883]));

var G__28884 = (i__4737__auto___28883 + (1));
i__4737__auto___28883 = G__28884;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28881){var e = e28881;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28880){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28880));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28887 = arguments.length;
var i__4737__auto___28888 = (0);
while(true){
if((i__4737__auto___28888 < len__4736__auto___28887)){
args__4742__auto__.push((arguments[i__4737__auto___28888]));

var G__28889 = (i__4737__auto___28888 + (1));
i__4737__auto___28888 = G__28889;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28886){var e = e28886;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28885){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28885));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28892 = arguments.length;
var i__4737__auto___28893 = (0);
while(true){
if((i__4737__auto___28893 < len__4736__auto___28892)){
args__4742__auto__.push((arguments[i__4737__auto___28893]));

var G__28894 = (i__4737__auto___28893 + (1));
i__4737__auto___28893 = G__28894;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28891){var e = e28891;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28890){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28890));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28895){var e = e28895;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28896){var e = e28896;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28897){var e = e28897;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28898){var e = e28898;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28899){var e = e28899;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28905 = path;
var vec__28906 = G__28905;
var seq__28907 = cljs.core.seq(vec__28906);
var first__28908 = cljs.core.first(seq__28907);
var seq__28907__$1 = cljs.core.next(seq__28907);
var pred = first__28908;
var r = seq__28907__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28905__$1 = G__28905;
var subjects__$1 = subjects;
while(true){
var vec__28912 = G__28905__$1;
var seq__28913 = cljs.core.seq(vec__28912);
var first__28914 = cljs.core.first(seq__28913);
var seq__28913__$1 = cljs.core.next(seq__28913);
var pred__$1 = first__28914;
var r__$1 = seq__28913__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28905__$1,subjects__$1,vec__28912,seq__28913,first__28914,seq__28913__$1,pred__$1,r__$1,subjects__$2,G__28905,vec__28906,seq__28907,first__28908,seq__28907__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28905__$1,subjects__$1,vec__28912,seq__28913,first__28914,seq__28913__$1,pred__$1,r__$1,subjects__$2,G__28905,vec__28906,seq__28907,first__28908,seq__28907__$1,pred,r,subjects){
return (function (p1__28900_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28900_SHARP_,pred__$1);
});})(G__28905__$1,subjects__$1,vec__28912,seq__28913,first__28914,seq__28913__$1,pred__$1,r__$1,subjects__$2,G__28905,vec__28906,seq__28907,first__28908,seq__28907__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28905__$1,subjects__$1,vec__28912,seq__28913,first__28914,seq__28913__$1,pred__$1,r__$1,subjects__$2,G__28905,vec__28906,seq__28907,first__28908,seq__28907__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__28915 = r__$1;
var G__28916 = next_subjects;
G__28905__$1 = G__28915;
subjects__$1 = G__28916;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28901){var e = e28901;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28917){var e = e28917;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e28918){var e = e28918;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28921 = arguments.length;
var i__4737__auto___28922 = (0);
while(true){
if((i__4737__auto___28922 < len__4736__auto___28921)){
args__4742__auto__.push((arguments[i__4737__auto___28922]));

var G__28923 = (i__4737__auto___28922 + (1));
i__4737__auto___28922 = G__28923;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28920){var e = e28920;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28919){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28919));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28924){var e = e28924;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28927 = arguments.length;
var i__4737__auto___28928 = (0);
while(true){
if((i__4737__auto___28928 < len__4736__auto___28927)){
args__4742__auto__.push((arguments[i__4737__auto___28928]));

var G__28929 = (i__4737__auto___28928 + (1));
i__4737__auto___28928 = G__28929;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28926){var e = e28926;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28925){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28925));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28930){var e = e28930;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28985){
var state_val_28986 = (state_28985[(1)]);
if((state_val_28986 === (7))){
var inst_28932 = (state_28985[(2)]);
var state_28985__$1 = state_28985;
var statearr_28987_29020 = state_28985__$1;
(statearr_28987_29020[(2)] = inst_28932);

(statearr_28987_29020[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (1))){
var state_28985__$1 = state_28985;
var statearr_28988_29021 = state_28985__$1;
(statearr_28988_29021[(2)] = null);

(statearr_28988_29021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (4))){
var inst_28931 = (state_28985[(2)]);
var state_28985__$1 = (function (){var statearr_28989 = state_28985;
(statearr_28989[(7)] = inst_28931);

return statearr_28989;
})();
var statearr_28990_29022 = state_28985__$1;
(statearr_28990_29022[(2)] = null);

(statearr_28990_29022[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (15))){
var inst_28969 = (state_28985[(8)]);
var inst_28973 = inst_28969.o;
var state_28985__$1 = state_28985;
var statearr_28991_29023 = state_28985__$1;
(statearr_28991_29023[(2)] = inst_28973);

(statearr_28991_29023[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (13))){
var inst_28969 = (state_28985[(8)]);
var inst_28965 = (state_28985[(2)]);
var inst_28966 = fluree.db.util.async.throw_err(inst_28965);
var inst_28967 = fluree.db.dbfunctions.internal.count(inst_28966);
var inst_28969__$1 = cljs.core.first(inst_28966);
var inst_28970 = (inst_28969__$1 == null);
var state_28985__$1 = (function (){var statearr_28992 = state_28985;
(statearr_28992[(9)] = inst_28967);

(statearr_28992[(8)] = inst_28969__$1);

return statearr_28992;
})();
if(cljs.core.truth_(inst_28970)){
var statearr_28993_29024 = state_28985__$1;
(statearr_28993_29024[(1)] = (14));

} else {
var statearr_28994_29025 = state_28985__$1;
(statearr_28994_29025[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (6))){
var inst_28941 = (state_28985[(2)]);
var state_28985__$1 = state_28985;
var statearr_28995_29026 = state_28985__$1;
(statearr_28995_29026[(2)] = inst_28941);

(statearr_28995_29026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (3))){
var inst_28983 = (state_28985[(2)]);
var state_28985__$1 = state_28985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28985__$1,inst_28983);
} else {
if((state_val_28986 === (12))){
var inst_28980 = (state_28985[(2)]);
var _ = (function (){var statearr_28996 = state_28985;
(statearr_28996[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_28996;
})();
var state_28985__$1 = state_28985;
var statearr_28997_29027 = state_28985__$1;
(statearr_28997_29027[(2)] = inst_28980);

(statearr_28997_29027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (2))){
var _ = (function (){var statearr_28999 = state_28985;
(statearr_28999[(4)] = cljs.core.cons((9),(state_28985[(4)])));

return statearr_28999;
})();
var inst_28947 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28948 = typeof inst_28947 === 'string';
var state_28985__$1 = state_28985;
if(cljs.core.truth_(inst_28948)){
var statearr_29000_29028 = state_28985__$1;
(statearr_29000_29028[(1)] = (10));

} else {
var statearr_29001_29029 = state_28985__$1;
(statearr_29001_29029[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (11))){
var inst_28954 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28955 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28954);
var inst_28956 = fluree.db.dbfunctions.internal.inc(inst_28955);
var inst_28957 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28954,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28956);
var inst_28958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28959 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28960 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28961 = [inst_28959,inst_28960];
var inst_28962 = (new cljs.core.PersistentVector(null,2,(5),inst_28958,inst_28961,null));
var inst_28963 = fluree.db.dbproto._search(inst_28957,inst_28962);
var state_28985__$1 = state_28985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28985__$1,(13),inst_28963);
} else {
if((state_val_28986 === (9))){
var _ = (function (){var statearr_29002 = state_28985;
(statearr_29002[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_29002;
})();
var state_28985__$1 = state_28985;
var ex28998 = (state_28985__$1[(2)]);
var statearr_29003_29030 = state_28985__$1;
(statearr_29003_29030[(5)] = ex28998);


var statearr_29004_29031 = state_28985__$1;
(statearr_29004_29031[(1)] = (4));

(statearr_29004_29031[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (5))){
var inst_28931 = (state_28985[(7)]);
var _ = (function (){var statearr_29005 = state_28985;
(statearr_29005[(4)] = cljs.core.cons((8),(state_28985[(4)])));

return statearr_29005;
})();
var inst_28938 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28931,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_29006 = state_28985;
(statearr_29006[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_29006;
})();
var state_28985__$1 = state_28985;
var statearr_29007_29032 = state_28985__$1;
(statearr_29007_29032[(2)] = inst_28938);

(statearr_29007_29032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (14))){
var state_28985__$1 = state_28985;
var statearr_29008_29033 = state_28985__$1;
(statearr_29008_29033[(2)] = null);

(statearr_29008_29033[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (16))){
var inst_28967 = (state_28985[(9)]);
var inst_28975 = (state_28985[(2)]);
var inst_28976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28977 = [inst_28975,inst_28967];
var inst_28978 = (new cljs.core.PersistentVector(null,2,(5),inst_28976,inst_28977,null));
var state_28985__$1 = state_28985;
var statearr_29010_29034 = state_28985__$1;
(statearr_29010_29034[(2)] = inst_28978);

(statearr_29010_29034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (10))){
var inst_28950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28951 = [null,(0)];
var inst_28952 = (new cljs.core.PersistentVector(null,2,(5),inst_28950,inst_28951,null));
var state_28985__$1 = state_28985;
var statearr_29011_29035 = state_28985__$1;
(statearr_29011_29035[(2)] = inst_28952);

(statearr_29011_29035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28986 === (8))){
var _ = (function (){var statearr_29012 = state_28985;
(statearr_29012[(4)] = cljs.core.rest((state_28985[(4)])));

return statearr_29012;
})();
var state_28985__$1 = state_28985;
var ex29009 = (state_28985__$1[(2)]);
var statearr_29013_29036 = state_28985__$1;
(statearr_29013_29036[(5)] = ex29009);


var statearr_29014_29037 = state_28985__$1;
(statearr_29014_29037[(1)] = (7));

(statearr_29014_29037[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0 = (function (){
var statearr_29015 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29015[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__);

(statearr_29015[(1)] = (1));

return statearr_29015;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1 = (function (state_28985){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28985);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29016){var ex__2417__auto__ = e29016;
var statearr_29017_29038 = state_28985;
(statearr_29017_29038[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28985[(4)]))){
var statearr_29018_29039 = state_28985;
(statearr_29018_29039[(1)] = cljs.core.first((state_28985[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29040 = state_28985;
state_28985 = G__29040;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__ = function(state_28985){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1.call(this,state_28985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29019 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29019[(6)] = c__2436__auto__);

return statearr_29019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_29092){
var state_val_29093 = (state_29092[(1)]);
if((state_val_29093 === (7))){
var inst_29042 = (state_29092[(2)]);
var state_29092__$1 = state_29092;
var statearr_29094_29123 = state_29092__$1;
(statearr_29094_29123[(2)] = inst_29042);

(statearr_29094_29123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (1))){
var state_29092__$1 = state_29092;
var statearr_29095_29124 = state_29092__$1;
(statearr_29095_29124[(2)] = null);

(statearr_29095_29124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (4))){
var inst_29041 = (state_29092[(2)]);
var state_29092__$1 = (function (){var statearr_29096 = state_29092;
(statearr_29096[(7)] = inst_29041);

return statearr_29096;
})();
var statearr_29097_29125 = state_29092__$1;
(statearr_29097_29125[(2)] = null);

(statearr_29097_29125[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (13))){
var inst_29087 = (state_29092[(2)]);
var _ = (function (){var statearr_29098 = state_29092;
(statearr_29098[(4)] = cljs.core.rest((state_29092[(4)])));

return statearr_29098;
})();
var state_29092__$1 = state_29092;
var statearr_29099_29126 = state_29092__$1;
(statearr_29099_29126[(2)] = inst_29087);

(statearr_29099_29126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (6))){
var inst_29051 = (state_29092[(2)]);
var state_29092__$1 = state_29092;
var statearr_29100_29127 = state_29092__$1;
(statearr_29100_29127[(2)] = inst_29051);

(statearr_29100_29127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (3))){
var inst_29090 = (state_29092[(2)]);
var state_29092__$1 = state_29092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29092__$1,inst_29090);
} else {
if((state_val_29093 === (12))){
var inst_29074 = (state_29092[(8)]);
var inst_29083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29084 = [null,inst_29074];
var inst_29085 = (new cljs.core.PersistentVector(null,2,(5),inst_29083,inst_29084,null));
var state_29092__$1 = state_29092;
var statearr_29101_29128 = state_29092__$1;
(statearr_29101_29128[(2)] = inst_29085);

(statearr_29101_29128[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (2))){
var _ = (function (){var statearr_29103 = state_29092;
(statearr_29103[(4)] = cljs.core.cons((9),(state_29092[(4)])));

return statearr_29103;
})();
var inst_29060 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29063 = [null,pred_name,"?o"];
var inst_29064 = (new cljs.core.PersistentVector(null,3,(5),inst_29062,inst_29063,null));
var inst_29065 = [inst_29064];
var inst_29066 = (new cljs.core.PersistentVector(null,1,(5),inst_29061,inst_29065,null));
var inst_29067 = ["?o",inst_29066,opts];
var inst_29068 = cljs.core.PersistentHashMap.fromArrays(inst_29060,inst_29067);
var inst_29069 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29068);
var state_29092__$1 = state_29092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29092__$1,(10),inst_29069);
} else {
if((state_val_29093 === (11))){
var inst_29074 = (state_29092[(8)]);
var inst_29073 = (state_29092[(9)]);
var inst_29078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29079 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29073);
var inst_29080 = [inst_29079,inst_29074];
var inst_29081 = (new cljs.core.PersistentVector(null,2,(5),inst_29078,inst_29080,null));
var state_29092__$1 = state_29092;
var statearr_29104_29129 = state_29092__$1;
(statearr_29104_29129[(2)] = inst_29081);

(statearr_29104_29129[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (9))){
var _ = (function (){var statearr_29105 = state_29092;
(statearr_29105[(4)] = cljs.core.rest((state_29092[(4)])));

return statearr_29105;
})();
var state_29092__$1 = state_29092;
var ex29102 = (state_29092__$1[(2)]);
var statearr_29106_29130 = state_29092__$1;
(statearr_29106_29130[(5)] = ex29102);


var statearr_29107_29131 = state_29092__$1;
(statearr_29107_29131[(1)] = (4));

(statearr_29107_29131[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (5))){
var inst_29041 = (state_29092[(7)]);
var _ = (function (){var statearr_29109 = state_29092;
(statearr_29109[(4)] = cljs.core.cons((8),(state_29092[(4)])));

return statearr_29109;
})();
var inst_29048 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29041,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29110 = state_29092;
(statearr_29110[(4)] = cljs.core.rest((state_29092[(4)])));

return statearr_29110;
})();
var state_29092__$1 = state_29092;
var statearr_29111_29132 = state_29092__$1;
(statearr_29111_29132[(2)] = inst_29048);

(statearr_29111_29132[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (10))){
var inst_29073 = (state_29092[(9)]);
var inst_29071 = (state_29092[(2)]);
var inst_29072 = fluree.db.util.async.throw_err(inst_29071);
var inst_29073__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29072,(0),null);
var inst_29074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29072,(1),null);
var inst_29075 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29073__$1);
var inst_29076 = cljs.core.not(inst_29075);
var state_29092__$1 = (function (){var statearr_29112 = state_29092;
(statearr_29112[(8)] = inst_29074);

(statearr_29112[(9)] = inst_29073__$1);

return statearr_29112;
})();
if(inst_29076){
var statearr_29113_29133 = state_29092__$1;
(statearr_29113_29133[(1)] = (11));

} else {
var statearr_29114_29134 = state_29092__$1;
(statearr_29114_29134[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29093 === (8))){
var _ = (function (){var statearr_29115 = state_29092;
(statearr_29115[(4)] = cljs.core.rest((state_29092[(4)])));

return statearr_29115;
})();
var state_29092__$1 = state_29092;
var ex29108 = (state_29092__$1[(2)]);
var statearr_29116_29135 = state_29092__$1;
(statearr_29116_29135[(5)] = ex29108);


var statearr_29117_29136 = state_29092__$1;
(statearr_29117_29136[(1)] = (7));

(statearr_29117_29136[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0 = (function (){
var statearr_29118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29118[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__);

(statearr_29118[(1)] = (1));

return statearr_29118;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1 = (function (state_29092){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_29092);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29119){var ex__2417__auto__ = e29119;
var statearr_29120_29137 = state_29092;
(statearr_29120_29137[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_29092[(4)]))){
var statearr_29121_29138 = state_29092;
(statearr_29121_29138[(1)] = cljs.core.first((state_29092[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29139 = state_29092;
state_29092 = G__29139;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__ = function(state_29092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1.call(this,state_29092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29122 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29122[(6)] = c__2436__auto__);

return statearr_29122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e29140){var e = e29140;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29142 = arguments.length;
switch (G__29142) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_29212){
var state_val_29213 = (state_29212[(1)]);
if((state_val_29213 === (7))){
var inst_29144 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29214_29258 = state_29212__$1;
(statearr_29214_29258[(2)] = inst_29144);

(statearr_29214_29258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (20))){
var inst_29188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29189 = ["*"];
var inst_29190 = (new cljs.core.PersistentVector(null,1,(5),inst_29188,inst_29189,null));
var state_29212__$1 = state_29212;
var statearr_29215_29259 = state_29212__$1;
(statearr_29215_29259[(2)] = inst_29190);

(statearr_29215_29259[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (1))){
var state_29212__$1 = state_29212;
var statearr_29216_29260 = state_29212__$1;
(statearr_29216_29260[(2)] = null);

(statearr_29216_29260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (4))){
var inst_29143 = (state_29212[(2)]);
var state_29212__$1 = (function (){var statearr_29217 = state_29212;
(statearr_29217[(7)] = inst_29143);

return statearr_29217;
})();
var statearr_29218_29261 = state_29212__$1;
(statearr_29218_29261[(2)] = null);

(statearr_29218_29261[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (15))){
var inst_29207 = (state_29212[(2)]);
var _ = (function (){var statearr_29219 = state_29212;
(statearr_29219[(4)] = cljs.core.rest((state_29212[(4)])));

return statearr_29219;
})();
var state_29212__$1 = state_29212;
var statearr_29220_29262 = state_29212__$1;
(statearr_29220_29262[(2)] = inst_29207);

(statearr_29220_29262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (21))){
var inst_29178 = (state_29212[(8)]);
var inst_29171 = (state_29212[(9)]);
var inst_29192 = (state_29212[(2)]);
var inst_29193 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29194 = cljs.core.PersistentHashMap.EMPTY;
var inst_29195 = [inst_29192,inst_29178,inst_29194];
var inst_29196 = cljs.core.PersistentHashMap.fromArrays(inst_29193,inst_29195);
var inst_29197 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29171,inst_29196);
var state_29212__$1 = state_29212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29212__$1,(22),inst_29197);
} else {
if((state_val_29213 === (13))){
var inst_29166 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29212__$1 = state_29212;
var statearr_29221_29263 = state_29212__$1;
(statearr_29221_29263[(2)] = inst_29166);

(statearr_29221_29263[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (22))){
var inst_29199 = (state_29212[(2)]);
var inst_29200 = fluree.db.util.async.throw_err(inst_29199);
var inst_29201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29200,(0),null);
var inst_29202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29200,(1),null);
var inst_29203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29204 = [inst_29201,inst_29202];
var inst_29205 = (new cljs.core.PersistentVector(null,2,(5),inst_29203,inst_29204,null));
var state_29212__$1 = state_29212;
var statearr_29222_29264 = state_29212__$1;
(statearr_29222_29264[(2)] = inst_29205);

(statearr_29222_29264[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (6))){
var inst_29153 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
var statearr_29223_29265 = state_29212__$1;
(statearr_29223_29265[(2)] = inst_29153);

(statearr_29223_29265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (17))){
var inst_29175 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29176 = fluree.db.dbfunctions.internal.get(inst_29175,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29212__$1 = state_29212;
var statearr_29224_29266 = state_29212__$1;
(statearr_29224_29266[(2)] = inst_29176);

(statearr_29224_29266[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (3))){
var inst_29210 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29212__$1,inst_29210);
} else {
if((state_val_29213 === (12))){
var inst_29164 = (state_29212[(2)]);
var state_29212__$1 = state_29212;
if(cljs.core.truth_(inst_29164)){
var statearr_29225_29267 = state_29212__$1;
(statearr_29225_29267[(1)] = (13));

} else {
var statearr_29226_29268 = state_29212__$1;
(statearr_29226_29268[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (2))){
var inst_29159 = (state_29212[(10)]);
var _ = (function (){var statearr_29227 = state_29212;
(statearr_29227[(4)] = cljs.core.cons((9),(state_29212[(4)])));

return statearr_29227;
})();
var inst_29159__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29212__$1 = (function (){var statearr_29228 = state_29212;
(statearr_29228[(10)] = inst_29159__$1);

return statearr_29228;
})();
if(cljs.core.truth_(inst_29159__$1)){
var statearr_29229_29269 = state_29212__$1;
(statearr_29229_29269[(1)] = (10));

} else {
var statearr_29230_29270 = state_29212__$1;
(statearr_29230_29270[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (19))){
var inst_29180 = cljs.core.PersistentVector.EMPTY;
var inst_29181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29182 = ["*"];
var inst_29183 = (new cljs.core.PersistentVector(null,1,(5),inst_29181,inst_29182,null));
var inst_29184 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29185 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29183,inst_29184);
var inst_29186 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29180,inst_29185);
var state_29212__$1 = state_29212;
var statearr_29232_29271 = state_29212__$1;
(statearr_29232_29271[(2)] = inst_29186);

(statearr_29232_29271[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (11))){
var inst_29159 = (state_29212[(10)]);
var state_29212__$1 = state_29212;
var statearr_29233_29272 = state_29212__$1;
(statearr_29233_29272[(2)] = inst_29159);

(statearr_29233_29272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (9))){
var _ = (function (){var statearr_29234 = state_29212;
(statearr_29234[(4)] = cljs.core.rest((state_29212[(4)])));

return statearr_29234;
})();
var state_29212__$1 = state_29212;
var ex29231 = (state_29212__$1[(2)]);
var statearr_29235_29273 = state_29212__$1;
(statearr_29235_29273[(5)] = ex29231);


var statearr_29236_29274 = state_29212__$1;
(statearr_29236_29274[(1)] = (4));

(statearr_29236_29274[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (5))){
var inst_29143 = (state_29212[(7)]);
var _ = (function (){var statearr_29237 = state_29212;
(statearr_29237[(4)] = cljs.core.cons((8),(state_29212[(4)])));

return statearr_29237;
})();
var inst_29150 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29143,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29238 = state_29212;
(statearr_29238[(4)] = cljs.core.rest((state_29212[(4)])));

return statearr_29238;
})();
var state_29212__$1 = state_29212;
var statearr_29239_29275 = state_29212__$1;
(statearr_29239_29275[(2)] = inst_29150);

(statearr_29239_29275[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (14))){
var inst_29172 = (state_29212[(11)]);
var inst_29171 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29172__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29212__$1 = (function (){var statearr_29240 = state_29212;
(statearr_29240[(9)] = inst_29171);

(statearr_29240[(11)] = inst_29172__$1);

return statearr_29240;
})();
if(cljs.core.truth_(inst_29172__$1)){
var statearr_29241_29276 = state_29212__$1;
(statearr_29241_29276[(1)] = (16));

} else {
var statearr_29242_29277 = state_29212__$1;
(statearr_29242_29277[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (16))){
var inst_29172 = (state_29212[(11)]);
var state_29212__$1 = state_29212;
var statearr_29243_29278 = state_29212__$1;
(statearr_29243_29278[(2)] = inst_29172);

(statearr_29243_29278[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (10))){
var inst_29161 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29212__$1 = state_29212;
var statearr_29245_29279 = state_29212__$1;
(statearr_29245_29279[(2)] = inst_29161);

(statearr_29245_29279[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (18))){
var inst_29178 = (state_29212[(2)]);
var state_29212__$1 = (function (){var statearr_29246 = state_29212;
(statearr_29246[(8)] = inst_29178);

return statearr_29246;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29247_29280 = state_29212__$1;
(statearr_29247_29280[(1)] = (19));

} else {
var statearr_29248_29281 = state_29212__$1;
(statearr_29248_29281[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29213 === (8))){
var _ = (function (){var statearr_29249 = state_29212;
(statearr_29249[(4)] = cljs.core.rest((state_29212[(4)])));

return statearr_29249;
})();
var state_29212__$1 = state_29212;
var ex29244 = (state_29212__$1[(2)]);
var statearr_29250_29282 = state_29212__$1;
(statearr_29250_29282[(5)] = ex29244);


var statearr_29251_29283 = state_29212__$1;
(statearr_29251_29283[(1)] = (7));

(statearr_29251_29283[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_29252 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29252[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_29252[(1)] = (1));

return statearr_29252;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_29212){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_29212);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29253){var ex__2417__auto__ = e29253;
var statearr_29254_29284 = state_29212;
(statearr_29254_29284[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_29212[(4)]))){
var statearr_29255_29285 = state_29212;
(statearr_29255_29285[(1)] = cljs.core.first((state_29212[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29286 = state_29212;
state_29212 = G__29286;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_29212){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_29212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29256 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29256[(6)] = c__2436__auto__);

return statearr_29256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29288 = arguments.length;
switch (G__29288) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_29332){
var state_val_29333 = (state_29332[(1)]);
if((state_val_29333 === (7))){
var inst_29310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29311 = ["*"];
var inst_29312 = (new cljs.core.PersistentVector(null,1,(5),inst_29310,inst_29311,null));
var state_29332__$1 = state_29332;
var statearr_29334_29354 = state_29332__$1;
(statearr_29334_29354[(2)] = inst_29312);

(statearr_29334_29354[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (1))){
var state_29332__$1 = state_29332;
var statearr_29335_29355 = state_29332__$1;
(statearr_29335_29355[(2)] = null);

(statearr_29335_29355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (4))){
var inst_29289 = (state_29332[(2)]);
var inst_29290 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29289,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29332__$1 = state_29332;
var statearr_29336_29356 = state_29332__$1;
(statearr_29336_29356[(2)] = inst_29290);

(statearr_29336_29356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (6))){
var inst_29302 = cljs.core.PersistentVector.EMPTY;
var inst_29303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29304 = ["*"];
var inst_29305 = (new cljs.core.PersistentVector(null,1,(5),inst_29303,inst_29304,null));
var inst_29306 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29307 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29305,inst_29306);
var inst_29308 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29302,inst_29307);
var state_29332__$1 = state_29332;
var statearr_29337_29357 = state_29332__$1;
(statearr_29337_29357[(2)] = inst_29308);

(statearr_29337_29357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (3))){
var inst_29330 = (state_29332[(2)]);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29332__$1,inst_29330);
} else {
if((state_val_29333 === (2))){
var _ = (function (){var statearr_29339 = state_29332;
(statearr_29339[(4)] = cljs.core.cons((5),(state_29332[(4)])));

return statearr_29339;
})();
var inst_29299 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29300 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29332__$1 = (function (){var statearr_29340 = state_29332;
(statearr_29340[(7)] = inst_29299);

(statearr_29340[(8)] = inst_29300);

return statearr_29340;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29341_29358 = state_29332__$1;
(statearr_29341_29358[(1)] = (6));

} else {
var statearr_29342_29359 = state_29332__$1;
(statearr_29342_29359[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (9))){
var inst_29321 = (state_29332[(2)]);
var inst_29322 = fluree.db.util.async.throw_err(inst_29321);
var inst_29323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29322,(0),null);
var inst_29324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29322,(1),null);
var inst_29325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29326 = [inst_29323,inst_29324];
var inst_29327 = (new cljs.core.PersistentVector(null,2,(5),inst_29325,inst_29326,null));
var _ = (function (){var statearr_29343 = state_29332;
(statearr_29343[(4)] = cljs.core.rest((state_29332[(4)])));

return statearr_29343;
})();
var state_29332__$1 = state_29332;
var statearr_29344_29360 = state_29332__$1;
(statearr_29344_29360[(2)] = inst_29327);

(statearr_29344_29360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (5))){
var _ = (function (){var statearr_29345 = state_29332;
(statearr_29345[(4)] = cljs.core.rest((state_29332[(4)])));

return statearr_29345;
})();
var state_29332__$1 = state_29332;
var ex29338 = (state_29332__$1[(2)]);
var statearr_29346_29361 = state_29332__$1;
(statearr_29346_29361[(5)] = ex29338);


var statearr_29347_29362 = state_29332__$1;
(statearr_29347_29362[(1)] = (4));

(statearr_29347_29362[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29333 === (8))){
var inst_29299 = (state_29332[(7)]);
var inst_29300 = (state_29332[(8)]);
var inst_29314 = (state_29332[(2)]);
var inst_29315 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29316 = cljs.core.PersistentHashMap.EMPTY;
var inst_29317 = [inst_29314,inst_29300,inst_29316];
var inst_29318 = cljs.core.PersistentHashMap.fromArrays(inst_29315,inst_29317);
var inst_29319 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29299,inst_29318);
var state_29332__$1 = state_29332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29332__$1,(9),inst_29319);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_29348 = [null,null,null,null,null,null,null,null,null];
(statearr_29348[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_29348[(1)] = (1));

return statearr_29348;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_29332){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_29332);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29349){var ex__2417__auto__ = e29349;
var statearr_29350_29363 = state_29332;
(statearr_29350_29363[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_29332[(4)]))){
var statearr_29351_29364 = state_29332;
(statearr_29351_29364[(1)] = cljs.core.first((state_29332[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29365 = state_29332;
state_29332 = G__29365;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_29332){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_29332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29352 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29352[(6)] = c__2436__auto__);

return statearr_29352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_29409){
var state_val_29410 = (state_29409[(1)]);
if((state_val_29410 === (1))){
var state_29409__$1 = state_29409;
var statearr_29411_29425 = state_29409__$1;
(statearr_29411_29425[(2)] = null);

(statearr_29411_29425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29410 === (2))){
var _ = (function (){var statearr_29412 = state_29409;
(statearr_29412[(4)] = cljs.core.cons((5),(state_29409[(4)])));

return statearr_29412;
})();
var inst_29376 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29378 = ["_user/_auth"];
var inst_29379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29380 = ["*"];
var inst_29381 = (new cljs.core.PersistentVector(null,1,(5),inst_29379,inst_29380,null));
var inst_29382 = [inst_29381];
var inst_29383 = cljs.core.PersistentHashMap.fromArrays(inst_29378,inst_29382);
var inst_29384 = [inst_29383];
var inst_29385 = (new cljs.core.PersistentVector(null,1,(5),inst_29377,inst_29384,null));
var inst_29386 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29387 = cljs.core.PersistentHashMap.EMPTY;
var inst_29388 = [inst_29385,inst_29386,inst_29387];
var inst_29389 = cljs.core.PersistentHashMap.fromArrays(inst_29376,inst_29388);
var inst_29390 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29391 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29390,inst_29389);
var state_29409__$1 = state_29409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29409__$1,(6),inst_29391);
} else {
if((state_val_29410 === (3))){
var inst_29407 = (state_29409[(2)]);
var state_29409__$1 = state_29409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29409__$1,inst_29407);
} else {
if((state_val_29410 === (4))){
var inst_29366 = (state_29409[(2)]);
var inst_29367 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29366,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29409__$1 = state_29409;
var statearr_29414_29426 = state_29409__$1;
(statearr_29414_29426[(2)] = inst_29367);

(statearr_29414_29426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29410 === (5))){
var _ = (function (){var statearr_29415 = state_29409;
(statearr_29415[(4)] = cljs.core.rest((state_29409[(4)])));

return statearr_29415;
})();
var state_29409__$1 = state_29409;
var ex29413 = (state_29409__$1[(2)]);
var statearr_29416_29427 = state_29409__$1;
(statearr_29416_29427[(5)] = ex29413);


var statearr_29417_29428 = state_29409__$1;
(statearr_29417_29428[(1)] = (4));

(statearr_29417_29428[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29410 === (6))){
var inst_29393 = (state_29409[(2)]);
var inst_29394 = fluree.db.util.async.throw_err(inst_29393);
var inst_29395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29394,(0),null);
var inst_29396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29394,(1),null);
var inst_29397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29398 = ["_user/_auth","_id"];
var inst_29399 = (new cljs.core.PersistentVector(null,2,(5),inst_29397,inst_29398,null));
var inst_29400 = fluree.db.dbfunctions.internal.get_in(inst_29395,inst_29399);
var inst_29401 = cljs.core.first(inst_29400);
var inst_29402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29403 = [inst_29401,inst_29396];
var inst_29404 = (new cljs.core.PersistentVector(null,2,(5),inst_29402,inst_29403,null));
var _ = (function (){var statearr_29418 = state_29409;
(statearr_29418[(4)] = cljs.core.rest((state_29409[(4)])));

return statearr_29418;
})();
var state_29409__$1 = state_29409;
var statearr_29419_29429 = state_29409__$1;
(statearr_29419_29429[(2)] = inst_29404);

(statearr_29419_29429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0 = (function (){
var statearr_29420 = [null,null,null,null,null,null,null];
(statearr_29420[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__);

(statearr_29420[(1)] = (1));

return statearr_29420;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1 = (function (state_29409){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_29409);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29421){var ex__2417__auto__ = e29421;
var statearr_29422_29430 = state_29409;
(statearr_29422_29430[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_29409[(4)]))){
var statearr_29423_29431 = state_29409;
(statearr_29423_29431[(1)] = cljs.core.first((state_29409[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29432 = state_29409;
state_29409 = G__29432;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__ = function(state_29409){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1.call(this,state_29409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29424 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29424[(6)] = c__2436__auto__);

return statearr_29424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_29449){
var state_val_29450 = (state_29449[(1)]);
if((state_val_29450 === (1))){
var state_29449__$1 = state_29449;
var statearr_29451_29465 = state_29449__$1;
(statearr_29451_29465[(2)] = null);

(statearr_29451_29465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29450 === (2))){
var _ = (function (){var statearr_29452 = state_29449;
(statearr_29452[(4)] = cljs.core.cons((5),(state_29449[(4)])));

return statearr_29452;
})();
var inst_29439 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29440 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29441 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29440,inst_29439);
var state_29449__$1 = state_29449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29449__$1,(6),inst_29441);
} else {
if((state_val_29450 === (3))){
var inst_29447 = (state_29449[(2)]);
var state_29449__$1 = state_29449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29449__$1,inst_29447);
} else {
if((state_val_29450 === (4))){
var inst_29433 = (state_29449[(2)]);
var state_29449__$1 = state_29449;
var statearr_29454_29466 = state_29449__$1;
(statearr_29454_29466[(2)] = inst_29433);

(statearr_29454_29466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29450 === (5))){
var _ = (function (){var statearr_29455 = state_29449;
(statearr_29455[(4)] = cljs.core.rest((state_29449[(4)])));

return statearr_29455;
})();
var state_29449__$1 = state_29449;
var ex29453 = (state_29449__$1[(2)]);
var statearr_29456_29467 = state_29449__$1;
(statearr_29456_29467[(5)] = ex29453);


if((ex29453 instanceof Error)){
var statearr_29457_29468 = state_29449__$1;
(statearr_29457_29468[(1)] = (4));

(statearr_29457_29468[(5)] = null);

} else {
throw ex29453;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29450 === (6))){
var inst_29443 = (state_29449[(2)]);
var inst_29444 = fluree.db.util.async.throw_err(inst_29443);
var _ = (function (){var statearr_29458 = state_29449;
(statearr_29458[(4)] = cljs.core.rest((state_29449[(4)])));

return statearr_29458;
})();
var state_29449__$1 = state_29449;
var statearr_29459_29469 = state_29449__$1;
(statearr_29459_29469[(2)] = inst_29444);

(statearr_29459_29469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0 = (function (){
var statearr_29460 = [null,null,null,null,null,null,null];
(statearr_29460[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__);

(statearr_29460[(1)] = (1));

return statearr_29460;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1 = (function (state_29449){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_29449);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e29461){var ex__2417__auto__ = e29461;
var statearr_29462_29470 = state_29449;
(statearr_29462_29470[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_29449[(4)]))){
var statearr_29463_29471 = state_29449;
(statearr_29463_29471[(1)] = cljs.core.first((state_29449[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29472 = state_29449;
state_29449 = G__29472;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__ = function(state_29449){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1.call(this,state_29449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_29464 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_29464[(6)] = c__2436__auto__);

return statearr_29464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29473_SHARP_){
return p1__29473_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29474_SHARP_){
return p1__29474_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29475){var e = e29475;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29476_SHARP_){
return p1__29476_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29477_SHARP_){
return p1__29477_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29478){var e = e29478;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29480 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29480);
})() | (0));
return num;
}catch (e29479){var e = e29479;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
