// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26274 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26274,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26274,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26274,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26371){
var state_val_26372 = (state_26371[(1)]);
if((state_val_26372 === (7))){
var inst_26292 = (state_26371[(7)]);
var inst_26297 = inst_26292.cljs$lang$protocol_mask$partition0$;
var inst_26298 = (inst_26297 & (64));
var inst_26299 = inst_26292.cljs$core$ISeq$;
var inst_26300 = (cljs.core.PROTOCOL_SENTINEL === inst_26299);
var inst_26301 = ((inst_26298) || (inst_26300));
var state_26371__$1 = state_26371;
if(cljs.core.truth_(inst_26301)){
var statearr_26373_26419 = state_26371__$1;
(statearr_26373_26419[(1)] = (10));

} else {
var statearr_26374_26420 = state_26371__$1;
(statearr_26374_26420[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (20))){
var state_26371__$1 = state_26371;
var statearr_26375_26421 = state_26371__$1;
(statearr_26375_26421[(2)] = false);

(statearr_26375_26421[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (27))){
var inst_26314 = (state_26371[(8)]);
var inst_26317 = (state_26371[(9)]);
var inst_26291 = (state_26371[(10)]);
var inst_26355 = (state_26371[(2)]);
var inst_26356 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26314,inst_26291);
var inst_26357 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26358 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26357,cljs.core.empty);
var inst_26359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26360 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26361 = (new cljs.core.PersistentVector(null,2,(5),inst_26359,inst_26360,null));
var inst_26362 = cljs.core.assoc_in(db,inst_26361,inst_26356);
var inst_26363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26364 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26365 = (new cljs.core.PersistentVector(null,2,(5),inst_26363,inst_26364,null));
var inst_26366 = cljs.core.assoc_in(inst_26362,inst_26365,inst_26317);
var _ = (function (){var statearr_26376 = state_26371;
(statearr_26376[(4)] = cljs.core.rest((state_26371[(4)])));

return statearr_26376;
})();
var state_26371__$1 = (function (){var statearr_26377 = state_26371;
(statearr_26377[(11)] = inst_26358);

(statearr_26377[(12)] = inst_26355);

return statearr_26377;
})();
var statearr_26378_26422 = state_26371__$1;
(statearr_26378_26422[(2)] = inst_26366);

(statearr_26378_26422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (1))){
var state_26371__$1 = state_26371;
var statearr_26379_26423 = state_26371__$1;
(statearr_26379_26423[(2)] = null);

(statearr_26379_26423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (24))){
var inst_26317 = (state_26371[(9)]);
var inst_26342 = (state_26371[(2)]);
var inst_26343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26342,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26342,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26345 = (inst_26317 > inst_26344);
var state_26371__$1 = (function (){var statearr_26380 = state_26371;
(statearr_26380[(13)] = inst_26343);

return statearr_26380;
})();
if(cljs.core.truth_(inst_26345)){
var statearr_26381_26424 = state_26371__$1;
(statearr_26381_26424[(1)] = (25));

} else {
var statearr_26382_26425 = state_26371__$1;
(statearr_26382_26425[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (4))){
var inst_26277 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
var statearr_26383_26426 = state_26371__$1;
(statearr_26383_26426[(2)] = inst_26277);

(statearr_26383_26426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (15))){
var inst_26291 = (state_26371[(10)]);
var inst_26321 = (state_26371[(14)]);
var inst_26313 = (state_26371[(2)]);
var inst_26314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26313,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26313,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26316 = fluree.db.flake.size_bytes(inst_26291);
var inst_26317 = (inst_26315 + inst_26316);
var inst_26318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26319 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26320 = (new cljs.core.PersistentVector(null,2,(5),inst_26318,inst_26319,null));
var inst_26321__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26320);
var inst_26323 = (inst_26321__$1 == null);
var inst_26324 = cljs.core.not(inst_26323);
var state_26371__$1 = (function (){var statearr_26384 = state_26371;
(statearr_26384[(8)] = inst_26314);

(statearr_26384[(9)] = inst_26317);

(statearr_26384[(14)] = inst_26321__$1);

return statearr_26384;
})();
if(inst_26324){
var statearr_26385_26427 = state_26371__$1;
(statearr_26385_26427[(1)] = (16));

} else {
var statearr_26386_26428 = state_26371__$1;
(statearr_26386_26428[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (21))){
var inst_26334 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
var statearr_26387_26429 = state_26371__$1;
(statearr_26387_26429[(2)] = inst_26334);

(statearr_26387_26429[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (13))){
var inst_26292 = (state_26371[(7)]);
var inst_26310 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26292);
var state_26371__$1 = state_26371;
var statearr_26388_26430 = state_26371__$1;
(statearr_26388_26430[(2)] = inst_26310);

(statearr_26388_26430[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (22))){
var inst_26321 = (state_26371[(14)]);
var inst_26339 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_26321);
var state_26371__$1 = state_26371;
var statearr_26389_26431 = state_26371__$1;
(statearr_26389_26431[(2)] = inst_26339);

(statearr_26389_26431[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (6))){
var inst_26292 = (state_26371[(7)]);
var inst_26290 = (state_26371[(2)]);
var inst_26291 = fluree.db.util.async.throw_err(inst_26290);
var inst_26292__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26294 = (inst_26292__$1 == null);
var inst_26295 = cljs.core.not(inst_26294);
var state_26371__$1 = (function (){var statearr_26390 = state_26371;
(statearr_26390[(7)] = inst_26292__$1);

(statearr_26390[(10)] = inst_26291);

return statearr_26390;
})();
if(inst_26295){
var statearr_26391_26432 = state_26371__$1;
(statearr_26391_26432[(1)] = (7));

} else {
var statearr_26392_26433 = state_26371__$1;
(statearr_26392_26433[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (25))){
var inst_26347 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26348 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26349 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26350 = cljs.core.PersistentHashMap.fromArrays(inst_26348,inst_26349);
var inst_26351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26347,inst_26350);
var inst_26352 = (function(){throw inst_26351})();
var state_26371__$1 = state_26371;
var statearr_26393_26434 = state_26371__$1;
(statearr_26393_26434[(2)] = inst_26352);

(statearr_26393_26434[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (17))){
var state_26371__$1 = state_26371;
var statearr_26394_26435 = state_26371__$1;
(statearr_26394_26435[(2)] = false);

(statearr_26394_26435[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (3))){
var inst_26369 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26371__$1,inst_26369);
} else {
if((state_val_26372 === (12))){
var inst_26305 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
var statearr_26395_26436 = state_26371__$1;
(statearr_26395_26436[(2)] = inst_26305);

(statearr_26395_26436[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (2))){
var _ = (function (){var statearr_26396 = state_26371;
(statearr_26396[(4)] = cljs.core.cons((5),(state_26371[(4)])));

return statearr_26396;
})();
var inst_26285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26286 = [pred_id];
var inst_26287 = (new cljs.core.PersistentVector(null,1,(5),inst_26285,inst_26286,null));
var inst_26288 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26287);
var state_26371__$1 = state_26371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26371__$1,(6),inst_26288);
} else {
if((state_val_26372 === (23))){
var inst_26321 = (state_26371[(14)]);
var state_26371__$1 = state_26371;
var statearr_26397_26437 = state_26371__$1;
(statearr_26397_26437[(2)] = inst_26321);

(statearr_26397_26437[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (19))){
var state_26371__$1 = state_26371;
var statearr_26398_26438 = state_26371__$1;
(statearr_26398_26438[(2)] = true);

(statearr_26398_26438[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (11))){
var state_26371__$1 = state_26371;
var statearr_26400_26439 = state_26371__$1;
(statearr_26400_26439[(2)] = false);

(statearr_26400_26439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (9))){
var inst_26308 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
if(cljs.core.truth_(inst_26308)){
var statearr_26401_26440 = state_26371__$1;
(statearr_26401_26440[(1)] = (13));

} else {
var statearr_26402_26441 = state_26371__$1;
(statearr_26402_26441[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (5))){
var _ = (function (){var statearr_26403 = state_26371;
(statearr_26403[(4)] = cljs.core.rest((state_26371[(4)])));

return statearr_26403;
})();
var state_26371__$1 = state_26371;
var ex26399 = (state_26371__$1[(2)]);
var statearr_26404_26442 = state_26371__$1;
(statearr_26404_26442[(5)] = ex26399);


if((ex26399 instanceof Error)){
var statearr_26405_26443 = state_26371__$1;
(statearr_26405_26443[(1)] = (4));

(statearr_26405_26443[(5)] = null);

} else {
throw ex26399;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (14))){
var inst_26292 = (state_26371[(7)]);
var state_26371__$1 = state_26371;
var statearr_26406_26444 = state_26371__$1;
(statearr_26406_26444[(2)] = inst_26292);

(statearr_26406_26444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (26))){
var state_26371__$1 = state_26371;
var statearr_26407_26445 = state_26371__$1;
(statearr_26407_26445[(2)] = null);

(statearr_26407_26445[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (16))){
var inst_26321 = (state_26371[(14)]);
var inst_26326 = inst_26321.cljs$lang$protocol_mask$partition0$;
var inst_26327 = (inst_26326 & (64));
var inst_26328 = inst_26321.cljs$core$ISeq$;
var inst_26329 = (cljs.core.PROTOCOL_SENTINEL === inst_26328);
var inst_26330 = ((inst_26327) || (inst_26329));
var state_26371__$1 = state_26371;
if(cljs.core.truth_(inst_26330)){
var statearr_26408_26446 = state_26371__$1;
(statearr_26408_26446[(1)] = (19));

} else {
var statearr_26409_26447 = state_26371__$1;
(statearr_26409_26447[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (10))){
var state_26371__$1 = state_26371;
var statearr_26410_26448 = state_26371__$1;
(statearr_26410_26448[(2)] = true);

(statearr_26410_26448[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (18))){
var inst_26337 = (state_26371[(2)]);
var state_26371__$1 = state_26371;
if(cljs.core.truth_(inst_26337)){
var statearr_26411_26449 = state_26371__$1;
(statearr_26411_26449[(1)] = (22));

} else {
var statearr_26412_26450 = state_26371__$1;
(statearr_26412_26450[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26372 === (8))){
var state_26371__$1 = state_26371;
var statearr_26413_26451 = state_26371__$1;
(statearr_26413_26451[(2)] = false);

(statearr_26413_26451[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0 = (function (){
var statearr_26414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26414[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__);

(statearr_26414[(1)] = (1));

return statearr_26414;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1 = (function (state_26371){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26371);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26415){var ex__2417__auto__ = e26415;
var statearr_26416_26452 = state_26371;
(statearr_26416_26452[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26371[(4)]))){
var statearr_26417_26453 = state_26371;
(statearr_26417_26453[(1)] = cljs.core.first((state_26371[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26454 = state_26371;
state_26371 = G__26454;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__ = function(state_26371){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1.call(this,state_26371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26418 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26418[(6)] = c__2436__auto__);

return statearr_26418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26653){
var state_val_26654 = (state_26653[(1)]);
if((state_val_26654 === (7))){
var state_26653__$1 = state_26653;
var statearr_26655_26722 = state_26653__$1;
(statearr_26655_26722[(2)] = null);

(statearr_26655_26722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (20))){
var inst_26496 = (state_26653[(7)]);
var inst_26576 = (state_26653[(8)]);
var inst_26495 = (state_26653[(9)]);
var inst_26575 = (state_26653[(10)]);
var inst_26577 = (state_26653[(11)]);
var inst_26579 = (state_26653[(12)]);
var inst_26578 = (state_26653[(13)]);
var inst_26546 = (state_26653[(14)]);
var inst_26589 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26591 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26592 = (new cljs.core.PersistentVector(null,2,(5),inst_26590,inst_26591,null));
var inst_26593 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26546,inst_26592);
var inst_26594 = (inst_26495 + inst_26593);
var inst_26595 = [inst_26575,inst_26576,inst_26577,inst_26578,inst_26594];
var inst_26596 = cljs.core.PersistentHashMap.fromArrays(inst_26589,inst_26595);
var inst_26597 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26546,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26579,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26596], 0));
var state_26653__$1 = (function (){var statearr_26656 = state_26653;
(statearr_26656[(15)] = inst_26597);

return statearr_26656;
})();
if(cljs.core.truth_(inst_26496)){
var statearr_26657_26723 = state_26653__$1;
(statearr_26657_26723[(1)] = (23));

} else {
var statearr_26658_26724 = state_26653__$1;
(statearr_26658_26724[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (27))){
var inst_26597 = (state_26653[(15)]);
var state_26653__$1 = state_26653;
var statearr_26659_26725 = state_26653__$1;
(statearr_26659_26725[(2)] = inst_26597);

(statearr_26659_26725[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (1))){
var state_26653__$1 = state_26653;
var statearr_26660_26726 = state_26653__$1;
(statearr_26660_26726[(2)] = null);

(statearr_26660_26726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (24))){
var inst_26597 = (state_26653[(15)]);
var inst_26600 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26597);
var inst_26601 = (inst_26600 == null);
var state_26653__$1 = state_26653;
var statearr_26661_26727 = state_26653__$1;
(statearr_26661_26727[(2)] = inst_26601);

(statearr_26661_26727[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (39))){
var inst_26586 = (state_26653[(16)]);
var inst_26628 = (state_26653[(17)]);
var inst_26629 = (state_26653[(18)]);
var inst_26636 = (state_26653[(19)]);
var inst_26627 = (state_26653[(20)]);
var inst_26643 = (state_26653[(2)]);
var inst_26574 = inst_26586;
var inst_26575 = inst_26628;
var inst_26576 = inst_26629;
var inst_26577 = inst_26636;
var inst_26578 = inst_26643;
var inst_26579 = inst_26627;
var state_26653__$1 = (function (){var statearr_26662 = state_26653;
(statearr_26662[(8)] = inst_26576);

(statearr_26662[(10)] = inst_26575);

(statearr_26662[(11)] = inst_26577);

(statearr_26662[(21)] = inst_26574);

(statearr_26662[(12)] = inst_26579);

(statearr_26662[(13)] = inst_26578);

return statearr_26662;
})();
var statearr_26663_26728 = state_26653__$1;
(statearr_26663_26728[(2)] = null);

(statearr_26663_26728[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (4))){
var inst_26458 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
var statearr_26664_26729 = state_26653__$1;
(statearr_26664_26729[(2)] = inst_26458);

(statearr_26664_26729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (15))){
var inst_26518 = (state_26653[(22)]);
var state_26653__$1 = state_26653;
var statearr_26665_26730 = state_26653__$1;
(statearr_26665_26730[(2)] = inst_26518);

(statearr_26665_26730[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (21))){
var inst_26496 = (state_26653[(7)]);
var inst_26499 = (state_26653[(23)]);
var inst_26576 = (state_26653[(8)]);
var inst_26495 = (state_26653[(9)]);
var inst_26586 = (state_26653[(16)]);
var inst_26556 = (state_26653[(24)]);
var inst_26497 = (state_26653[(25)]);
var inst_26505 = (state_26653[(26)]);
var inst_26490 = (state_26653[(27)]);
var inst_26575 = (state_26653[(10)]);
var inst_26577 = (state_26653[(11)]);
var inst_26480 = (state_26653[(28)]);
var inst_26585 = (state_26653[(29)]);
var inst_26482 = (state_26653[(30)]);
var inst_26574 = (state_26653[(21)]);
var inst_26555 = (state_26653[(31)]);
var inst_26579 = (state_26653[(12)]);
var inst_26578 = (state_26653[(13)]);
var inst_26494 = (state_26653[(32)]);
var inst_26486 = (state_26653[(33)]);
var inst_26465 = (state_26653[(34)]);
var inst_26546 = (state_26653[(14)]);
var inst_26624 = inst_26585.s;
var inst_26625 = fluree.db.flake.sid__GT_cid(inst_26624);
var inst_26626 = (function (){var flakes_bytes = inst_26495;
var t = inst_26465;
var spot = inst_26575;
var add_flakes = inst_26482;
var first__26553 = inst_26555;
var root_setting_change_QMARK_ = inst_26497;
var ref_QMARK__map = inst_26494;
var r = inst_26586;
var psot = inst_26576;
var G__26550 = inst_26574;
var add_pred_to_idx_QMARK_ = inst_26505;
var seq__26582 = inst_26586;
var _ = inst_26480;
var cid = inst_26625;
var ecount = inst_26579;
var vec__26551 = inst_26482;
var pred_ecount = inst_26499;
var db_STAR_ = inst_26546;
var schema_change_QMARK_ = inst_26496;
var add_preds = inst_26486;
var opst = inst_26578;
var vec__26581 = inst_26574;
var idx_QMARK__map = inst_26490;
var seq__26552 = inst_26556;
var post = inst_26577;
var first__26583 = inst_26585;
var f = inst_26585;
return (function (p1__26457_SHARP_){
if(cljs.core.truth_(p1__26457_SHARP_)){
var x__4214__auto__ = p1__26457_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_26627 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26579,inst_26625,inst_26626);
var inst_26628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26575,inst_26585);
var inst_26629 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26576,inst_26585);
var inst_26630 = inst_26585.p;
var inst_26631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26490,inst_26630);
var state_26653__$1 = (function (){var statearr_26666 = state_26653;
(statearr_26666[(17)] = inst_26628);

(statearr_26666[(18)] = inst_26629);

(statearr_26666[(20)] = inst_26627);

return statearr_26666;
})();
if(cljs.core.truth_(inst_26631)){
var statearr_26667_26731 = state_26653__$1;
(statearr_26667_26731[(1)] = (34));

} else {
var statearr_26668_26732 = state_26653__$1;
(statearr_26668_26732[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (31))){
var inst_26612 = (state_26653[(35)]);
var state_26653__$1 = state_26653;
var statearr_26669_26733 = state_26653__$1;
(statearr_26669_26733[(2)] = inst_26612);

(statearr_26669_26733[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (32))){
var inst_26622 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
var statearr_26670_26734 = state_26653__$1;
(statearr_26670_26734[(2)] = inst_26622);

(statearr_26670_26734[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (33))){
var inst_26612 = (state_26653[(35)]);
var inst_26617 = (state_26653[(2)]);
var inst_26618 = fluree.db.util.async.throw_err(inst_26617);
var inst_26619 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26612,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26618);
var state_26653__$1 = state_26653;
var statearr_26671_26735 = state_26653__$1;
(statearr_26671_26735[(2)] = inst_26619);

(statearr_26671_26735[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (13))){
var inst_26495 = (state_26653[(9)]);
var inst_26482 = (state_26653[(30)]);
var inst_26465 = (state_26653[(34)]);
var inst_26546 = (state_26653[(14)]);
var inst_26536 = (state_26653[(2)]);
var inst_26537 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26536,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26465);
var inst_26538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26539 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26540 = (new cljs.core.PersistentVector(null,2,(5),inst_26538,inst_26539,null));
var inst_26541 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26537,inst_26540,cljs.core._PLUS_,inst_26495);
var inst_26542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26543 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26544 = (new cljs.core.PersistentVector(null,2,(5),inst_26542,inst_26543,null));
var inst_26545 = cljs.core.count(inst_26482);
var inst_26546__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26541,inst_26544,cljs.core._PLUS_,inst_26545);
var inst_26554 = cljs.core.seq(inst_26482);
var inst_26555 = cljs.core.first(inst_26554);
var inst_26556 = cljs.core.next(inst_26554);
var inst_26557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26558 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26559 = (new cljs.core.PersistentVector(null,2,(5),inst_26557,inst_26558,null));
var inst_26560 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26546__$1,inst_26559);
var inst_26561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26562 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26563 = (new cljs.core.PersistentVector(null,2,(5),inst_26561,inst_26562,null));
var inst_26564 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26546__$1,inst_26563);
var inst_26565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26566 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26567 = (new cljs.core.PersistentVector(null,2,(5),inst_26565,inst_26566,null));
var inst_26568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26546__$1,inst_26567);
var inst_26569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26570 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26571 = (new cljs.core.PersistentVector(null,2,(5),inst_26569,inst_26570,null));
var inst_26572 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26546__$1,inst_26571);
var inst_26573 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26574 = inst_26482;
var inst_26575 = inst_26560;
var inst_26576 = inst_26564;
var inst_26577 = inst_26568;
var inst_26578 = inst_26572;
var inst_26579 = inst_26573;
var state_26653__$1 = (function (){var statearr_26672 = state_26653;
(statearr_26672[(8)] = inst_26576);

(statearr_26672[(24)] = inst_26556);

(statearr_26672[(10)] = inst_26575);

(statearr_26672[(11)] = inst_26577);

(statearr_26672[(21)] = inst_26574);

(statearr_26672[(31)] = inst_26555);

(statearr_26672[(12)] = inst_26579);

(statearr_26672[(13)] = inst_26578);

(statearr_26672[(14)] = inst_26546__$1);

return statearr_26672;
})();
var statearr_26673_26736 = state_26653__$1;
(statearr_26673_26736[(2)] = null);

(statearr_26673_26736[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (22))){
var inst_26646 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
var statearr_26674_26737 = state_26653__$1;
(statearr_26674_26737[(2)] = inst_26646);

(statearr_26674_26737[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (36))){
var inst_26585 = (state_26653[(29)]);
var inst_26494 = (state_26653[(32)]);
var inst_26636 = (state_26653[(2)]);
var inst_26637 = inst_26585.p;
var inst_26638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26494,inst_26637);
var state_26653__$1 = (function (){var statearr_26675 = state_26653;
(statearr_26675[(19)] = inst_26636);

return statearr_26675;
})();
if(cljs.core.truth_(inst_26638)){
var statearr_26676_26738 = state_26653__$1;
(statearr_26676_26738[(1)] = (37));

} else {
var statearr_26677_26739 = state_26653__$1;
(statearr_26677_26739[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (29))){
var inst_26597 = (state_26653[(15)]);
var inst_26607 = (state_26653[(2)]);
var inst_26608 = fluree.db.util.async.throw_err(inst_26607);
var inst_26609 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26597,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26608);
var state_26653__$1 = state_26653;
var statearr_26678_26740 = state_26653__$1;
(statearr_26678_26740[(2)] = inst_26609);

(statearr_26678_26740[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (6))){
var inst_26465 = (state_26653[(34)]);
var inst_26470 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26471 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26472 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26470)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26471)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26465),"."].join('');
var inst_26473 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26474 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26475 = cljs.core.PersistentHashMap.fromArrays(inst_26473,inst_26474);
var inst_26476 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26472,inst_26475);
var inst_26477 = (function(){throw inst_26476})();
var state_26653__$1 = state_26653;
var statearr_26679_26741 = state_26653__$1;
(statearr_26679_26741[(2)] = inst_26477);

(statearr_26679_26741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (28))){
var inst_26497 = (state_26653[(25)]);
var inst_26612 = (state_26653[(2)]);
var state_26653__$1 = (function (){var statearr_26680 = state_26653;
(statearr_26680[(35)] = inst_26612);

return statearr_26680;
})();
if(cljs.core.truth_(inst_26497)){
var statearr_26681_26742 = state_26653__$1;
(statearr_26681_26742[(1)] = (30));

} else {
var statearr_26682_26743 = state_26653__$1;
(statearr_26682_26743[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (25))){
var inst_26603 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
if(cljs.core.truth_(inst_26603)){
var statearr_26683_26744 = state_26653__$1;
(statearr_26683_26744[(1)] = (26));

} else {
var statearr_26684_26745 = state_26653__$1;
(statearr_26684_26745[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (34))){
var inst_26577 = (state_26653[(11)]);
var inst_26585 = (state_26653[(29)]);
var inst_26633 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26577,inst_26585);
var state_26653__$1 = state_26653;
var statearr_26685_26746 = state_26653__$1;
(statearr_26685_26746[(2)] = inst_26633);

(statearr_26685_26746[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (17))){
var inst_26525 = (state_26653[(36)]);
var inst_26529 = (state_26653[(2)]);
var inst_26530 = fluree.db.util.async.throw_err(inst_26529);
var inst_26517 = inst_26525;
var inst_26518 = inst_26530;
var state_26653__$1 = (function (){var statearr_26686 = state_26653;
(statearr_26686[(37)] = inst_26517);

(statearr_26686[(22)] = inst_26518);

return statearr_26686;
})();
var statearr_26687_26747 = state_26653__$1;
(statearr_26687_26747[(2)] = null);

(statearr_26687_26747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (3))){
var inst_26651 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26653__$1,inst_26651);
} else {
if((state_val_26654 === (12))){
var inst_26517 = (state_26653[(37)]);
var inst_26524 = (state_26653[(38)]);
var inst_26523 = cljs.core.seq(inst_26517);
var inst_26524__$1 = cljs.core.first(inst_26523);
var inst_26525 = cljs.core.next(inst_26523);
var state_26653__$1 = (function (){var statearr_26688 = state_26653;
(statearr_26688[(36)] = inst_26525);

(statearr_26688[(38)] = inst_26524__$1);

return statearr_26688;
})();
if(cljs.core.truth_(inst_26524__$1)){
var statearr_26689_26748 = state_26653__$1;
(statearr_26689_26748[(1)] = (14));

} else {
var statearr_26690_26749 = state_26653__$1;
(statearr_26690_26749[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (2))){
var inst_26465 = (state_26653[(34)]);
var _ = (function (){var statearr_26691 = state_26653;
(statearr_26691[(4)] = cljs.core.cons((5),(state_26653[(4)])));

return statearr_26691;
})();
var inst_26464 = cljs.core.first(flakes);
var inst_26465__$1 = inst_26464.t;
var inst_26466 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26467 = (inst_26466 - (1));
var inst_26468 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26465__$1,inst_26467);
var state_26653__$1 = (function (){var statearr_26692 = state_26653;
(statearr_26692[(34)] = inst_26465__$1);

return statearr_26692;
})();
if(inst_26468){
var statearr_26693_26750 = state_26653__$1;
(statearr_26693_26750[(1)] = (6));

} else {
var statearr_26694_26751 = state_26653__$1;
(statearr_26694_26751[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (23))){
var inst_26496 = (state_26653[(7)]);
var state_26653__$1 = state_26653;
var statearr_26695_26752 = state_26653__$1;
(statearr_26695_26752[(2)] = inst_26496);

(statearr_26695_26752[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (35))){
var inst_26577 = (state_26653[(11)]);
var state_26653__$1 = state_26653;
var statearr_26696_26753 = state_26653__$1;
(statearr_26696_26753[(2)] = inst_26577);

(statearr_26696_26753[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (19))){
var inst_26648 = (state_26653[(2)]);
var _ = (function (){var statearr_26697 = state_26653;
(statearr_26697[(4)] = cljs.core.rest((state_26653[(4)])));

return statearr_26697;
})();
var state_26653__$1 = state_26653;
var statearr_26698_26754 = state_26653__$1;
(statearr_26698_26754[(2)] = inst_26648);

(statearr_26698_26754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (11))){
var inst_26505 = (state_26653[(26)]);
var inst_26505__$1 = (state_26653[(2)]);
var inst_26513 = cljs.core.seq(inst_26505__$1);
var inst_26514 = cljs.core.first(inst_26513);
var inst_26515 = cljs.core.next(inst_26513);
var inst_26516 = db;
var inst_26517 = inst_26505__$1;
var inst_26518 = inst_26516;
var state_26653__$1 = (function (){var statearr_26700 = state_26653;
(statearr_26700[(39)] = inst_26515);

(statearr_26700[(40)] = inst_26514);

(statearr_26700[(37)] = inst_26517);

(statearr_26700[(26)] = inst_26505__$1);

(statearr_26700[(22)] = inst_26518);

return statearr_26700;
})();
var statearr_26701_26755 = state_26653__$1;
(statearr_26701_26755[(2)] = null);

(statearr_26701_26755[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (9))){
var inst_26499 = (state_26653[(23)]);
var inst_26482 = (state_26653[(30)]);
var inst_26501 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26482,inst_26499);
var state_26653__$1 = state_26653;
var statearr_26702_26756 = state_26653__$1;
(statearr_26702_26756[(2)] = inst_26501);

(statearr_26702_26756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (5))){
var _ = (function (){var statearr_26703 = state_26653;
(statearr_26703[(4)] = cljs.core.rest((state_26653[(4)])));

return statearr_26703;
})();
var state_26653__$1 = state_26653;
var ex26699 = (state_26653__$1[(2)]);
var statearr_26704_26757 = state_26653__$1;
(statearr_26704_26757[(5)] = ex26699);


if((ex26699 instanceof Error)){
var statearr_26705_26758 = state_26653__$1;
(statearr_26705_26758[(1)] = (4));

(statearr_26705_26758[(5)] = null);

} else {
throw ex26699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (14))){
var inst_26524 = (state_26653[(38)]);
var inst_26518 = (state_26653[(22)]);
var inst_26527 = fluree.db.graphdb.add_predicate_to_idx(inst_26518,inst_26524);
var state_26653__$1 = state_26653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26653__$1,(17),inst_26527);
} else {
if((state_val_26654 === (26))){
var inst_26597 = (state_26653[(15)]);
var inst_26605 = fluree.db.query.schema.schema_map(inst_26597);
var state_26653__$1 = state_26653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26653__$1,(29),inst_26605);
} else {
if((state_val_26654 === (16))){
var inst_26534 = (state_26653[(2)]);
var state_26653__$1 = state_26653;
var statearr_26706_26759 = state_26653__$1;
(statearr_26706_26759[(2)] = inst_26534);

(statearr_26706_26759[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (38))){
var inst_26578 = (state_26653[(13)]);
var state_26653__$1 = state_26653;
var statearr_26707_26760 = state_26653__$1;
(statearr_26707_26760[(2)] = inst_26578);

(statearr_26707_26760[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (30))){
var inst_26612 = (state_26653[(35)]);
var inst_26615 = fluree.db.query.schema.setting_map(inst_26612);
var state_26653__$1 = state_26653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26653__$1,(33),inst_26615);
} else {
if((state_val_26654 === (10))){
var inst_26503 = cljs.core.PersistentVector.EMPTY;
var state_26653__$1 = state_26653;
var statearr_26708_26761 = state_26653__$1;
(statearr_26708_26761[(2)] = inst_26503);

(statearr_26708_26761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (18))){
var inst_26585 = (state_26653[(29)]);
var inst_26574 = (state_26653[(21)]);
var inst_26584 = cljs.core.seq(inst_26574);
var inst_26585__$1 = cljs.core.first(inst_26584);
var inst_26586 = cljs.core.next(inst_26584);
var inst_26587 = cljs.core.not(inst_26585__$1);
var state_26653__$1 = (function (){var statearr_26709 = state_26653;
(statearr_26709[(16)] = inst_26586);

(statearr_26709[(29)] = inst_26585__$1);

return statearr_26709;
})();
if(inst_26587){
var statearr_26710_26762 = state_26653__$1;
(statearr_26710_26762[(1)] = (20));

} else {
var statearr_26711_26763 = state_26653__$1;
(statearr_26711_26763[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (37))){
var inst_26585 = (state_26653[(29)]);
var inst_26578 = (state_26653[(13)]);
var inst_26640 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26578,inst_26585);
var state_26653__$1 = state_26653;
var statearr_26712_26764 = state_26653__$1;
(statearr_26712_26764[(2)] = inst_26640);

(statearr_26712_26764[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26654 === (8))){
var inst_26496 = (state_26653[(7)]);
var inst_26490 = (state_26653[(27)]);
var inst_26480 = (state_26653[(28)]);
var inst_26482 = (state_26653[(30)]);
var inst_26486 = (state_26653[(33)]);
var inst_26465 = (state_26653[(34)]);
var inst_26480__$1 = (state_26653[(2)]);
var inst_26481 = (function (){var t = inst_26465;
var _ = inst_26480__$1;
return (function (p1__26455_SHARP_){
return cljs.core.not((function (){var G__26713 = p1__26455_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26713) : fluree.db.graphdb.exclude_predicates.call(null,G__26713));
})());
});
})();
var inst_26482__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26481,flakes);
var inst_26483 = cljs.core.PersistentHashSet.EMPTY;
var inst_26484 = (function (){var t = inst_26465;
var _ = inst_26480__$1;
var add_flakes = inst_26482__$1;
return (function (p1__26456_SHARP_){
return p1__26456_SHARP_.p;
});
})();
var inst_26485 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26484,inst_26482__$1);
var inst_26486__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26483,inst_26485);
var inst_26487 = cljs.core.PersistentHashMap.EMPTY;
var inst_26488 = (function (){var t = inst_26465;
var _ = inst_26480__$1;
var add_flakes = inst_26482__$1;
var add_preds = inst_26486__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26489 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26488,inst_26486__$1);
var inst_26490__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26487,inst_26489);
var inst_26491 = cljs.core.PersistentHashMap.EMPTY;
var inst_26492 = (function (){var t = inst_26465;
var _ = inst_26480__$1;
var add_flakes = inst_26482__$1;
var add_preds = inst_26486__$1;
var idx_QMARK__map = inst_26490__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26493 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26492,inst_26486__$1);
var inst_26494 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26491,inst_26493);
var inst_26495 = fluree.db.flake.size_bytes(inst_26482__$1);
var inst_26496__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26482__$1);
var inst_26497 = fluree.db.util.schema.setting_change_QMARK_(inst_26482__$1);
var inst_26498 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26499 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26498,(0));
var state_26653__$1 = (function (){var statearr_26714 = state_26653;
(statearr_26714[(7)] = inst_26496__$1);

(statearr_26714[(23)] = inst_26499);

(statearr_26714[(9)] = inst_26495);

(statearr_26714[(25)] = inst_26497);

(statearr_26714[(27)] = inst_26490__$1);

(statearr_26714[(28)] = inst_26480__$1);

(statearr_26714[(30)] = inst_26482__$1);

(statearr_26714[(32)] = inst_26494);

(statearr_26714[(33)] = inst_26486__$1);

return statearr_26714;
})();
if(cljs.core.truth_(inst_26496__$1)){
var statearr_26715_26765 = state_26653__$1;
(statearr_26715_26765[(1)] = (9));

} else {
var statearr_26716_26766 = state_26653__$1;
(statearr_26716_26766[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2414__auto____0 = (function (){
var statearr_26717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26717[(0)] = fluree$db$graphdb$with_t_$_state_machine__2414__auto__);

(statearr_26717[(1)] = (1));

return statearr_26717;
});
var fluree$db$graphdb$with_t_$_state_machine__2414__auto____1 = (function (state_26653){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26653);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26718){var ex__2417__auto__ = e26718;
var statearr_26719_26767 = state_26653;
(statearr_26719_26767[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26653[(4)]))){
var statearr_26720_26768 = state_26653;
(statearr_26720_26768[(1)] = cljs.core.first((state_26653[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26769 = state_26653;
state_26653 = G__26769;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2414__auto__ = function(state_26653){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2414__auto____1.call(this,state_26653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2414__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2414__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26721 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26721[(6)] = c__2436__auto__);

return statearr_26721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___26915 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_26865){
var state_val_26866 = (state_26865[(1)]);
if((state_val_26866 === (7))){
var state_26865__$1 = state_26865;
var statearr_26867_26916 = state_26865__$1;
(statearr_26867_26916[(2)] = null);

(statearr_26867_26916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (20))){
var inst_26814 = (state_26865[(7)]);
var inst_26815 = (state_26865[(8)]);
var inst_26813 = (state_26865[(9)]);
var inst_26834 = (inst_26813 + (1));
var inst_26835 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26815,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26834);
var inst_26836 = fluree.db.graphdb.with_t(inst_26835,inst_26814);
var state_26865__$1 = state_26865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26865__$1,(23),inst_26836);
} else {
if((state_val_26866 === (1))){
var state_26865__$1 = state_26865;
var statearr_26868_26917 = state_26865__$1;
(statearr_26868_26917[(2)] = null);

(statearr_26868_26917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (24))){
var inst_26839 = (state_26865[(10)]);
var inst_26842 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26839,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26865__$1 = state_26865;
var statearr_26869_26918 = state_26865__$1;
(statearr_26869_26918[(2)] = inst_26842);

(statearr_26869_26918[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (4))){
var inst_26770 = (state_26865[(2)]);
var inst_26771 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26770);
var state_26865__$1 = state_26865;
var statearr_26870_26919 = state_26865__$1;
(statearr_26870_26919[(2)] = inst_26771);

(statearr_26870_26919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (15))){
var inst_26821 = (state_26865[(11)]);
var state_26865__$1 = state_26865;
var statearr_26871_26920 = state_26865__$1;
(statearr_26871_26920[(2)] = inst_26821);

(statearr_26871_26920[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (21))){
var state_26865__$1 = state_26865;
var statearr_26872_26921 = state_26865__$1;
(statearr_26872_26921[(2)] = null);

(statearr_26872_26921[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (13))){
var inst_26857 = (state_26865[(2)]);
var inst_26858 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26857);
var state_26865__$1 = state_26865;
var statearr_26873_26922 = state_26865__$1;
(statearr_26873_26922[(2)] = inst_26858);

(statearr_26873_26922[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (22))){
var inst_26853 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26874_26923 = state_26865__$1;
(statearr_26874_26923[(2)] = inst_26853);

(statearr_26874_26923[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (6))){
var inst_26781 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26782 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26783 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26781)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26782)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26784 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26785 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26786 = cljs.core.PersistentHashMap.fromArrays(inst_26784,inst_26785);
var inst_26787 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26783,inst_26786);
var inst_26788 = (function(){throw inst_26787})();
var state_26865__$1 = state_26865;
var statearr_26877_26924 = state_26865__$1;
(statearr_26877_26924[(2)] = inst_26788);

(statearr_26877_26924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (25))){
var inst_26821 = (state_26865[(11)]);
var inst_26822 = (state_26865[(12)]);
var inst_26839 = (state_26865[(10)]);
var inst_26844 = inst_26821.t;
var inst_26845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26846 = [inst_26821];
var inst_26847 = (new cljs.core.PersistentVector(null,1,(5),inst_26845,inst_26846,null));
var inst_26812 = inst_26822;
var inst_26813 = inst_26844;
var inst_26814 = inst_26847;
var inst_26815 = inst_26839;
var state_26865__$1 = (function (){var statearr_26878 = state_26865;
(statearr_26878[(7)] = inst_26814);

(statearr_26878[(8)] = inst_26815);

(statearr_26878[(13)] = inst_26812);

(statearr_26878[(9)] = inst_26813);

return statearr_26878;
})();
var statearr_26879_26925 = state_26865__$1;
(statearr_26879_26925[(2)] = null);

(statearr_26879_26925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (17))){
var inst_26814 = (state_26865[(7)]);
var inst_26815 = (state_26865[(8)]);
var inst_26821 = (state_26865[(11)]);
var inst_26822 = (state_26865[(12)]);
var inst_26813 = (state_26865[(9)]);
var inst_26830 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26814,inst_26821);
var tmp26875 = inst_26815;
var tmp26876 = inst_26813;
var inst_26812 = inst_26822;
var inst_26813__$1 = tmp26876;
var inst_26814__$1 = inst_26830;
var inst_26815__$1 = tmp26875;
var state_26865__$1 = (function (){var statearr_26880 = state_26865;
(statearr_26880[(7)] = inst_26814__$1);

(statearr_26880[(8)] = inst_26815__$1);

(statearr_26880[(13)] = inst_26812);

(statearr_26880[(9)] = inst_26813__$1);

return statearr_26880;
})();
var statearr_26881_26926 = state_26865__$1;
(statearr_26881_26926[(2)] = null);

(statearr_26881_26926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (3))){
var inst_26863 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26865__$1,inst_26863);
} else {
if((state_val_26866 === (12))){
var inst_26821 = (state_26865[(11)]);
var inst_26812 = (state_26865[(13)]);
var inst_26820 = cljs.core.seq(inst_26812);
var inst_26821__$1 = cljs.core.first(inst_26820);
var inst_26822 = cljs.core.next(inst_26820);
var state_26865__$1 = (function (){var statearr_26882 = state_26865;
(statearr_26882[(11)] = inst_26821__$1);

(statearr_26882[(12)] = inst_26822);

return statearr_26882;
})();
if(cljs.core.truth_(inst_26821__$1)){
var statearr_26883_26927 = state_26865__$1;
(statearr_26883_26927[(1)] = (14));

} else {
var statearr_26884_26928 = state_26865__$1;
(statearr_26884_26928[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (2))){
var _ = (function (){var statearr_26885 = state_26865;
(statearr_26885[(4)] = cljs.core.cons((5),(state_26865[(4)])));

return statearr_26885;
})();
var inst_26777 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26778 = (inst_26777 + (1));
var inst_26779 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26778);
var state_26865__$1 = state_26865;
if(inst_26779){
var statearr_26886_26929 = state_26865__$1;
(statearr_26886_26929[(1)] = (6));

} else {
var statearr_26887_26930 = state_26865__$1;
(statearr_26887_26930[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (23))){
var inst_26821 = (state_26865[(11)]);
var inst_26838 = (state_26865[(2)]);
var inst_26839 = fluree.db.util.async.throw_err(inst_26838);
var inst_26840 = (inst_26821 == null);
var state_26865__$1 = (function (){var statearr_26888 = state_26865;
(statearr_26888[(10)] = inst_26839);

return statearr_26888;
})();
if(cljs.core.truth_(inst_26840)){
var statearr_26889_26931 = state_26865__$1;
(statearr_26889_26931[(1)] = (24));

} else {
var statearr_26890_26932 = state_26865__$1;
(statearr_26890_26932[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (19))){
var inst_26855 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26891_26933 = state_26865__$1;
(statearr_26891_26933[(2)] = inst_26855);

(statearr_26891_26933[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (11))){
var inst_26860 = (state_26865[(2)]);
var _ = (function (){var statearr_26893 = state_26865;
(statearr_26893[(4)] = cljs.core.rest((state_26865[(4)])));

return statearr_26893;
})();
var state_26865__$1 = state_26865;
var statearr_26894_26934 = state_26865__$1;
(statearr_26894_26934[(2)] = inst_26860);

(statearr_26894_26934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (9))){
var inst_26794 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26795 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26794);
var state_26865__$1 = state_26865;
var statearr_26895_26935 = state_26865__$1;
(statearr_26895_26935[(2)] = inst_26795);

(statearr_26895_26935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (5))){
var _ = (function (){var statearr_26896 = state_26865;
(statearr_26896[(4)] = cljs.core.rest((state_26865[(4)])));

return statearr_26896;
})();
var state_26865__$1 = state_26865;
var ex26892 = (state_26865__$1[(2)]);
var statearr_26897_26936 = state_26865__$1;
(statearr_26897_26936[(5)] = ex26892);


var statearr_26898_26937 = state_26865__$1;
(statearr_26898_26937[(1)] = (4));

(statearr_26898_26937[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (14))){
var inst_26821 = (state_26865[(11)]);
var inst_26813 = (state_26865[(9)]);
var inst_26824 = inst_26821.t;
var inst_26825 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26813,inst_26824);
var state_26865__$1 = state_26865;
var statearr_26899_26938 = state_26865__$1;
(statearr_26899_26938[(2)] = inst_26825);

(statearr_26899_26938[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (26))){
var inst_26850 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
var statearr_26900_26939 = state_26865__$1;
(statearr_26900_26939[(2)] = inst_26850);

(statearr_26900_26939[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (16))){
var inst_26828 = (state_26865[(2)]);
var state_26865__$1 = state_26865;
if(cljs.core.truth_(inst_26828)){
var statearr_26901_26940 = state_26865__$1;
(statearr_26901_26940[(1)] = (17));

} else {
var statearr_26902_26941 = state_26865__$1;
(statearr_26902_26941[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (10))){
var inst_26797 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26805 = cljs.core.seq(inst_26797);
var inst_26806 = cljs.core.first(inst_26805);
var inst_26807 = cljs.core.next(inst_26805);
var inst_26808 = cljs.core.first(inst_26797);
var inst_26809 = inst_26808.t;
var inst_26810 = cljs.core.PersistentVector.EMPTY;
var inst_26811 = db;
var inst_26812 = inst_26797;
var inst_26813 = inst_26809;
var inst_26814 = inst_26810;
var inst_26815 = inst_26811;
var state_26865__$1 = (function (){var statearr_26903 = state_26865;
(statearr_26903[(14)] = inst_26807);

(statearr_26903[(7)] = inst_26814);

(statearr_26903[(8)] = inst_26815);

(statearr_26903[(13)] = inst_26812);

(statearr_26903[(9)] = inst_26813);

(statearr_26903[(15)] = inst_26806);

return statearr_26903;
})();
var statearr_26904_26942 = state_26865__$1;
(statearr_26904_26942[(2)] = null);

(statearr_26904_26942[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (18))){
var state_26865__$1 = state_26865;
var statearr_26905_26943 = state_26865__$1;
(statearr_26905_26943[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26866 === (8))){
var inst_26791 = (state_26865[(2)]);
var inst_26792 = cljs.core.empty_QMARK_(flakes);
var state_26865__$1 = (function (){var statearr_26907 = state_26865;
(statearr_26907[(16)] = inst_26791);

return statearr_26907;
})();
if(inst_26792){
var statearr_26908_26944 = state_26865__$1;
(statearr_26908_26944[(1)] = (9));

} else {
var statearr_26909_26945 = state_26865__$1;
(statearr_26909_26945[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2414__auto____0 = (function (){
var statearr_26910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26910[(0)] = fluree$db$graphdb$with_$_state_machine__2414__auto__);

(statearr_26910[(1)] = (1));

return statearr_26910;
});
var fluree$db$graphdb$with_$_state_machine__2414__auto____1 = (function (state_26865){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_26865);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e26911){var ex__2417__auto__ = e26911;
var statearr_26912_26946 = state_26865;
(statearr_26912_26946[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_26865[(4)]))){
var statearr_26913_26947 = state_26865;
(statearr_26913_26947[(1)] = cljs.core.first((state_26865[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26948 = state_26865;
state_26865 = G__26948;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2414__auto__ = function(state_26865){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2414__auto____1.call(this,state_26865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2414__auto____0;
fluree$db$graphdb$with_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2414__auto____1;
return fluree$db$graphdb$with_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_26914 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_26914[(6)] = c__2436__auto___26915);

return statearr_26914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27004){
var state_val_27005 = (state_27004[(1)]);
if((state_val_27005 === (7))){
var state_27004__$1 = state_27004;
var statearr_27006_27033 = state_27004__$1;
(statearr_27006_27033[(2)] = tt_id);

(statearr_27006_27033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (1))){
var state_27004__$1 = state_27004;
var statearr_27007_27034 = state_27004__$1;
(statearr_27007_27034[(2)] = null);

(statearr_27007_27034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (4))){
var inst_26949 = (state_27004[(2)]);
var state_27004__$1 = state_27004;
var statearr_27008_27035 = state_27004__$1;
(statearr_27008_27035[(2)] = inst_26949);

(statearr_27008_27035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (13))){
var inst_26997 = (state_27004[(2)]);
var state_27004__$1 = state_27004;
var statearr_27009_27036 = state_27004__$1;
(statearr_27009_27036[(2)] = inst_26997);

(statearr_27009_27036[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (6))){
var inst_26957 = fluree.db.util.core.random_uuid();
var state_27004__$1 = state_27004;
var statearr_27010_27037 = state_27004__$1;
(statearr_27010_27037[(2)] = inst_26957);

(statearr_27010_27037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (3))){
var inst_27002 = (state_27004[(2)]);
var state_27004__$1 = state_27004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27004__$1,inst_27002);
} else {
if((state_val_27005 === (12))){
var inst_26980 = (state_27004[(7)]);
var state_27004__$1 = state_27004;
var statearr_27011_27038 = state_27004__$1;
(statearr_27011_27038[(2)] = inst_26980);

(statearr_27011_27038[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (2))){
var _ = (function (){var statearr_27012 = state_27004;
(statearr_27012[(4)] = cljs.core.cons((5),(state_27004[(4)])));

return statearr_27012;
})();
var inst_26955 = (tt_id == null);
var state_27004__$1 = state_27004;
if(cljs.core.truth_(inst_26955)){
var statearr_27013_27039 = state_27004__$1;
(statearr_27013_27039[(1)] = (6));

} else {
var statearr_27014_27040 = state_27004__$1;
(statearr_27014_27040[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (11))){
var inst_26987 = (state_27004[(8)]);
var inst_26980 = (state_27004[(7)]);
var inst_26990 = fluree.db.graphdb.with_t(inst_26980,inst_26987);
var state_27004__$1 = state_27004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27004__$1,(14),inst_26990);
} else {
if((state_val_27005 === (9))){
var inst_26987 = (state_27004[(8)]);
var inst_26981 = (state_27004[(9)]);
var inst_26986 = cljs.core.seq(inst_26981);
var inst_26987__$1 = cljs.core.first(inst_26986);
var inst_26988 = cljs.core.next(inst_26986);
var state_27004__$1 = (function (){var statearr_27016 = state_27004;
(statearr_27016[(8)] = inst_26987__$1);

(statearr_27016[(10)] = inst_26988);

return statearr_27016;
})();
if(cljs.core.truth_(inst_26987__$1)){
var statearr_27017_27041 = state_27004__$1;
(statearr_27017_27041[(1)] = (11));

} else {
var statearr_27018_27042 = state_27004__$1;
(statearr_27018_27042[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (5))){
var _ = (function (){var statearr_27019 = state_27004;
(statearr_27019[(4)] = cljs.core.rest((state_27004[(4)])));

return statearr_27019;
})();
var state_27004__$1 = state_27004;
var ex27015 = (state_27004__$1[(2)]);
var statearr_27020_27043 = state_27004__$1;
(statearr_27020_27043[(5)] = ex27015);


if((ex27015 instanceof Error)){
var statearr_27021_27044 = state_27004__$1;
(statearr_27021_27044[(1)] = (4));

(statearr_27021_27044[(5)] = null);

} else {
throw ex27015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (14))){
var inst_26988 = (state_27004[(10)]);
var inst_26992 = (state_27004[(2)]);
var inst_26993 = fluree.db.util.async.throw_err(inst_26992);
var inst_26980 = inst_26993;
var inst_26981 = inst_26988;
var state_27004__$1 = (function (){var statearr_27022 = state_27004;
(statearr_27022[(9)] = inst_26981);

(statearr_27022[(7)] = inst_26980);

return statearr_27022;
})();
var statearr_27023_27045 = state_27004__$1;
(statearr_27023_27045[(2)] = null);

(statearr_27023_27045[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (10))){
var inst_26999 = (state_27004[(2)]);
var _ = (function (){var statearr_27024 = state_27004;
(statearr_27024[(4)] = cljs.core.rest((state_27004[(4)])));

return statearr_27024;
})();
var state_27004__$1 = state_27004;
var statearr_27025_27046 = state_27004__$1;
(statearr_27025_27046[(2)] = inst_26999);

(statearr_27025_27046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27005 === (8))){
var inst_26960 = (state_27004[(2)]);
var inst_26961 = (function (){var tt_id_SINGLEQUOTE_ = inst_26960;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26962 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26960);
var inst_26963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26964 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26965 = (new cljs.core.PersistentVector(null,4,(5),inst_26963,inst_26964,null));
var inst_26966 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26961,inst_26962,inst_26965);
var inst_26967 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26968 = cljs.core.reverse(inst_26967);
var inst_26969 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26968);
var inst_26977 = cljs.core.seq(inst_26969);
var inst_26978 = cljs.core.first(inst_26977);
var inst_26979 = cljs.core.next(inst_26977);
var inst_26980 = inst_26966;
var inst_26981 = inst_26969;
var state_27004__$1 = (function (){var statearr_27026 = state_27004;
(statearr_27026[(11)] = inst_26979);

(statearr_27026[(9)] = inst_26981);

(statearr_27026[(12)] = inst_26978);

(statearr_27026[(7)] = inst_26980);

return statearr_27026;
})();
var statearr_27027_27047 = state_27004__$1;
(statearr_27027_27047[(2)] = null);

(statearr_27027_27047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0 = (function (){
var statearr_27028 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27028[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__);

(statearr_27028[(1)] = (1));

return statearr_27028;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1 = (function (state_27004){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27004);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27029){var ex__2417__auto__ = e27029;
var statearr_27030_27048 = state_27004;
(statearr_27030_27048[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27004[(4)]))){
var statearr_27031_27049 = state_27004;
(statearr_27031_27049[(1)] = cljs.core.first((state_27004[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27050 = state_27004;
state_27004 = G__27050;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__ = function(state_27004){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1.call(this,state_27004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27032 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27032[(6)] = c__2436__auto__);

return statearr_27032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___27228 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27165){
var state_val_27166 = (state_27165[(1)]);
if((state_val_27166 === (7))){
var inst_27078 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_27079 = cljs.core.first(ident);
var inst_27080 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27079);
var inst_27081 = (inst_27080 == null);
var inst_27082 = ((inst_27078) && (inst_27081));
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27082)){
var statearr_27167_27229 = state_27165__$1;
(statearr_27167_27229[(1)] = (13));

} else {
var statearr_27168_27230 = state_27165__$1;
(statearr_27168_27230[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (20))){
var state_27165__$1 = state_27165;
var statearr_27169_27231 = state_27165__$1;
(statearr_27169_27231[(2)] = null);

(statearr_27169_27231[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (27))){
var state_27165__$1 = state_27165;
var statearr_27170_27232 = state_27165__$1;
(statearr_27170_27232[(2)] = null);

(statearr_27170_27232[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (1))){
var state_27165__$1 = state_27165;
var statearr_27171_27233 = state_27165__$1;
(statearr_27171_27233[(2)] = null);

(statearr_27171_27233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (24))){
var inst_27111 = (state_27165[(7)]);
var inst_27115 = inst_27111.s;
var state_27165__$1 = state_27165;
var statearr_27172_27234 = state_27165__$1;
(statearr_27172_27234[(2)] = inst_27115);

(statearr_27172_27234[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (39))){
var state_27165__$1 = state_27165;
var statearr_27173_27235 = state_27165__$1;
(statearr_27173_27235[(2)] = null);

(statearr_27173_27235[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (4))){
var inst_27051 = (state_27165[(2)]);
var inst_27052 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27053 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27054 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27055 = cljs.core.PersistentHashMap.fromArrays(inst_27053,inst_27054);
var inst_27056 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27052,inst_27055,inst_27051);
var inst_27057 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27056);
var state_27165__$1 = state_27165;
var statearr_27174_27236 = state_27165__$1;
(statearr_27174_27236[(2)] = inst_27057);

(statearr_27174_27236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (15))){
var inst_27133 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27175_27237 = state_27165__$1;
(statearr_27175_27237[(2)] = inst_27133);

(statearr_27175_27237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (21))){
var inst_27105 = (state_27165[(8)]);
var inst_27109 = cljs.core.first(inst_27105);
var state_27165__$1 = state_27165;
var statearr_27176_27238 = state_27165__$1;
(statearr_27176_27238[(2)] = inst_27109);

(statearr_27176_27238[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (31))){
var inst_27160 = (state_27165[(2)]);
var _ = (function (){var statearr_27177 = state_27165;
(statearr_27177[(4)] = cljs.core.rest((state_27165[(4)])));

return statearr_27177;
})();
var state_27165__$1 = state_27165;
var statearr_27178_27239 = state_27165__$1;
(statearr_27178_27239[(2)] = inst_27160);

(statearr_27178_27239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (32))){
var state_27165__$1 = state_27165;
var statearr_27179_27240 = state_27165__$1;
(statearr_27179_27240[(2)] = strict_QMARK_);

(statearr_27179_27240[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (40))){
var inst_27156 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27180_27241 = state_27165__$1;
(statearr_27180_27241[(2)] = inst_27156);

(statearr_27180_27241[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (33))){
var state_27165__$1 = state_27165;
var statearr_27181_27242 = state_27165__$1;
(statearr_27181_27242[(2)] = false);

(statearr_27181_27242[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (13))){
var inst_27084 = cljs.core.first(ident);
var inst_27085 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27084], 0));
var inst_27086 = ["Subject ID lookup failed. The predicate ",inst_27085," does not exist."].join('');
var inst_27087 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27088 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27089 = cljs.core.PersistentHashMap.fromArrays(inst_27087,inst_27088);
var inst_27090 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27086,inst_27089);
var inst_27091 = (function(){throw inst_27090})();
var state_27165__$1 = state_27165;
var statearr_27182_27243 = state_27165__$1;
(statearr_27182_27243[(2)] = inst_27091);

(statearr_27182_27243[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (22))){
var inst_27111 = (state_27165[(7)]);
var inst_27111__$1 = (state_27165[(2)]);
var inst_27112 = (inst_27111__$1 == null);
var state_27165__$1 = (function (){var statearr_27183 = state_27165;
(statearr_27183[(7)] = inst_27111__$1);

return statearr_27183;
})();
if(cljs.core.truth_(inst_27112)){
var statearr_27184_27244 = state_27165__$1;
(statearr_27184_27244[(1)] = (23));

} else {
var statearr_27185_27245 = state_27165__$1;
(statearr_27185_27245[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (36))){
var state_27165__$1 = state_27165;
var statearr_27186_27246 = state_27165__$1;
(statearr_27186_27246[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (29))){
var inst_27135 = (state_27165[(9)]);
var inst_27137 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27135);
var state_27165__$1 = state_27165;
var statearr_27188_27247 = state_27165__$1;
(statearr_27188_27247[(2)] = inst_27137);

(statearr_27188_27247[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (6))){
var inst_27065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27066 = [ident];
var inst_27067 = (new cljs.core.PersistentVector(null,1,(5),inst_27065,inst_27066,null));
var inst_27068 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27067);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27165__$1,(9),inst_27068);
} else {
if((state_val_27166 === (28))){
var inst_27129 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27189_27248 = state_27165__$1;
(statearr_27189_27248[(2)] = inst_27129);

(statearr_27189_27248[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (25))){
var inst_27117 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27190_27249 = state_27165__$1;
(statearr_27190_27249[(2)] = inst_27117);

(statearr_27190_27249[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (34))){
var inst_27143 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27143)){
var statearr_27191_27250 = state_27165__$1;
(statearr_27191_27250[(1)] = (35));

} else {
var statearr_27192_27251 = state_27165__$1;
(statearr_27192_27251[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (17))){
var state_27165__$1 = state_27165;
var statearr_27193_27252 = state_27165__$1;
(statearr_27193_27252[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (3))){
var inst_27163 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27165__$1,inst_27163);
} else {
if((state_val_27166 === (12))){
var inst_27076 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27195_27253 = state_27165__$1;
(statearr_27195_27253[(2)] = inst_27076);

(statearr_27195_27253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (2))){
var _ = (function (){var statearr_27196 = state_27165;
(statearr_27196[(4)] = cljs.core.cons((5),(state_27165[(4)])));

return statearr_27196;
})();
var inst_27063 = typeof ident === 'number';
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27063)){
var statearr_27197_27254 = state_27165__$1;
(statearr_27197_27254[(1)] = (6));

} else {
var statearr_27198_27255 = state_27165__$1;
(statearr_27198_27255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (23))){
var state_27165__$1 = state_27165;
var statearr_27199_27256 = state_27165__$1;
(statearr_27199_27256[(2)] = null);

(statearr_27199_27256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (35))){
var inst_27145 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27146 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27147 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27148 = cljs.core.PersistentHashMap.fromArrays(inst_27146,inst_27147);
var inst_27149 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27145,inst_27148);
var inst_27150 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27149);
var state_27165__$1 = state_27165;
var statearr_27200_27257 = state_27165__$1;
(statearr_27200_27257[(2)] = inst_27150);

(statearr_27200_27257[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (19))){
var inst_27105 = (state_27165[(8)]);
var inst_27104 = (state_27165[(2)]);
var inst_27105__$1 = fluree.db.util.async.throw_err(inst_27104);
var inst_27106 = (inst_27105__$1 == null);
var state_27165__$1 = (function (){var statearr_27201 = state_27165;
(statearr_27201[(8)] = inst_27105__$1);

return statearr_27201;
})();
if(cljs.core.truth_(inst_27106)){
var statearr_27202_27258 = state_27165__$1;
(statearr_27202_27258[(1)] = (20));

} else {
var statearr_27203_27259 = state_27165__$1;
(statearr_27203_27259[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (11))){
var state_27165__$1 = state_27165;
var statearr_27205_27260 = state_27165__$1;
(statearr_27205_27260[(2)] = null);

(statearr_27205_27260[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (9))){
var inst_27070 = (state_27165[(2)]);
var inst_27071 = fluree.db.util.async.throw_err(inst_27070);
var inst_27072 = cljs.core.not_empty(inst_27071);
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27072)){
var statearr_27206_27261 = state_27165__$1;
(statearr_27206_27261[(1)] = (10));

} else {
var statearr_27207_27262 = state_27165__$1;
(statearr_27207_27262[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (5))){
var _ = (function (){var statearr_27208 = state_27165;
(statearr_27208[(4)] = cljs.core.rest((state_27165[(4)])));

return statearr_27208;
})();
var state_27165__$1 = state_27165;
var ex27204 = (state_27165__$1[(2)]);
var statearr_27209_27263 = state_27165__$1;
(statearr_27209_27263[(5)] = ex27204);


var statearr_27210_27264 = state_27165__$1;
(statearr_27210_27264[(1)] = (4));

(statearr_27210_27264[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (14))){
var inst_27093 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27165__$1 = state_27165;
if(inst_27093){
var statearr_27211_27265 = state_27165__$1;
(statearr_27211_27265[(1)] = (16));

} else {
var statearr_27212_27266 = state_27165__$1;
(statearr_27212_27266[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (26))){
var inst_27120 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27121 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27120].join('');
var inst_27122 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27123 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27124 = cljs.core.PersistentHashMap.fromArrays(inst_27122,inst_27123);
var inst_27125 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27121,inst_27124);
var inst_27126 = (function(){throw inst_27125})();
var state_27165__$1 = state_27165;
var statearr_27213_27267 = state_27165__$1;
(statearr_27213_27267[(2)] = inst_27126);

(statearr_27213_27267[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (16))){
var inst_27096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27097 = cljs.core.first(ident);
var inst_27098 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27097);
var inst_27099 = cljs.core.second(ident);
var inst_27100 = [inst_27098,inst_27099];
var inst_27101 = (new cljs.core.PersistentVector(null,2,(5),inst_27096,inst_27100,null));
var inst_27102 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27101);
var state_27165__$1 = state_27165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27165__$1,(19),inst_27102);
} else {
if((state_val_27166 === (38))){
var inst_27153 = cljs.core.async.close_BANG_(return_chan);
var state_27165__$1 = state_27165;
var statearr_27214_27268 = state_27165__$1;
(statearr_27214_27268[(2)] = inst_27153);

(statearr_27214_27268[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (30))){
var inst_27135 = (state_27165[(9)]);
var inst_27139 = (inst_27135 == null);
var state_27165__$1 = state_27165;
if(cljs.core.truth_(inst_27139)){
var statearr_27215_27269 = state_27165__$1;
(statearr_27215_27269[(1)] = (32));

} else {
var statearr_27216_27270 = state_27165__$1;
(statearr_27216_27270[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (10))){
var state_27165__$1 = state_27165;
var statearr_27217_27271 = state_27165__$1;
(statearr_27217_27271[(2)] = ident);

(statearr_27217_27271[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (18))){
var inst_27131 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27218_27272 = state_27165__$1;
(statearr_27218_27272[(2)] = inst_27131);

(statearr_27218_27272[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (37))){
var inst_27158 = (state_27165[(2)]);
var state_27165__$1 = state_27165;
var statearr_27219_27273 = state_27165__$1;
(statearr_27219_27273[(2)] = inst_27158);

(statearr_27219_27273[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27166 === (8))){
var inst_27135 = (state_27165[(9)]);
var inst_27135__$1 = (state_27165[(2)]);
var state_27165__$1 = (function (){var statearr_27220 = state_27165;
(statearr_27220[(9)] = inst_27135__$1);

return statearr_27220;
})();
if(cljs.core.truth_(inst_27135__$1)){
var statearr_27221_27274 = state_27165__$1;
(statearr_27221_27274[(1)] = (29));

} else {
var statearr_27222_27275 = state_27165__$1;
(statearr_27222_27275[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2414__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2414__auto____0 = (function (){
var statearr_27223 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27223[(0)] = fluree$db$graphdb$subid_$_state_machine__2414__auto__);

(statearr_27223[(1)] = (1));

return statearr_27223;
});
var fluree$db$graphdb$subid_$_state_machine__2414__auto____1 = (function (state_27165){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27165);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27224){var ex__2417__auto__ = e27224;
var statearr_27225_27276 = state_27165;
(statearr_27225_27276[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27165[(4)]))){
var statearr_27226_27277 = state_27165;
(statearr_27226_27277[(1)] = cljs.core.first((state_27165[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27278 = state_27165;
state_27165 = G__27278;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2414__auto__ = function(state_27165){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2414__auto____1.call(this,state_27165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2414__auto____0;
fluree$db$graphdb$subid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2414__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27227 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27227[(6)] = c__2436__auto___27228);

return statearr_27227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27280,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27284 = k27280;
var G__27284__$1 = (((G__27284 instanceof cljs.core.Keyword))?G__27284.fqn:null);
switch (G__27284__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27280,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27285){
var vec__27286 = p__27285;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27286,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27286,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27279){
var self__ = this;
var G__27279__$1 = this;
return (new cljs.core.RecordIter((0),G__27279__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__27289 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__27289(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27281,other27282){
var self__ = this;
var this27281__$1 = this;
return (((!((other27282 == null)))) && ((this27281__$1.constructor === other27282.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.conn,other27282.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.network,other27282.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.dbid,other27282.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.block,other27282.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.t,other27282.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.tt_id,other27282.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.stats,other27282.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.spot,other27282.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.psot,other27282.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.post,other27282.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.opst,other27282.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.schema,other27282.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.settings,other27282.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.index_configs,other27282.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.schema_cache,other27282.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.novelty,other27282.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.permissions,other27282.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.fork,other27282.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.fork_block,other27282.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.current_db_fn,other27282.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27281__$1.__extmap,other27282.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27279){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27290 = cljs.core.keyword_identical_QMARK_;
var expr__27291 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__27293 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27294 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27293,G__27294) : pred__27290.call(null,G__27293,G__27294));
})())){
return (new fluree.db.graphdb.GraphDb(G__27279,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27295 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27296 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27295,G__27296) : pred__27290.call(null,G__27295,G__27296));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27279,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27297 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27298 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27297,G__27298) : pred__27290.call(null,G__27297,G__27298));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27279,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27299 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27300 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27299,G__27300) : pred__27290.call(null,G__27299,G__27300));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27279,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27301 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27302 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27301,G__27302) : pred__27290.call(null,G__27301,G__27302));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27279,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27303 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27304 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27303,G__27304) : pred__27290.call(null,G__27303,G__27304));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27279,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27305 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27306 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27305,G__27306) : pred__27290.call(null,G__27305,G__27306));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27279,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27307 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27308 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27307,G__27308) : pred__27290.call(null,G__27307,G__27308));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27279,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27309 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27310 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27309,G__27310) : pred__27290.call(null,G__27309,G__27310));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27279,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27311 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27312 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27311,G__27312) : pred__27290.call(null,G__27311,G__27312));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27279,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27313 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27314 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27313,G__27314) : pred__27290.call(null,G__27313,G__27314));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27279,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27315 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27316 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27315,G__27316) : pred__27290.call(null,G__27315,G__27316));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27279,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27317 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27318 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27317,G__27318) : pred__27290.call(null,G__27317,G__27318));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27279,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27319 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27320 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27319,G__27320) : pred__27290.call(null,G__27319,G__27320));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27279,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27321 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27322 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27321,G__27322) : pred__27290.call(null,G__27321,G__27322));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27279,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27323 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27324 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27323,G__27324) : pred__27290.call(null,G__27323,G__27324));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27279,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27325 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27326 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27325,G__27326) : pred__27290.call(null,G__27325,G__27326));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27279,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27327 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27328 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27327,G__27328) : pred__27290.call(null,G__27327,G__27328));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27279,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27329 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27330 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27329,G__27330) : pred__27290.call(null,G__27329,G__27330));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27279,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27331 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27332 = expr__27291;
return (pred__27290.cljs$core$IFn$_invoke$arity$2 ? pred__27290.cljs$core$IFn$_invoke$arity$2(G__27331,G__27332) : pred__27290.call(null,G__27331,G__27332));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27279,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27279),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27279){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27279,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27348){
var state_val_27349 = (state_27348[(1)]);
if((state_val_27349 === (1))){
var state_27348__$1 = state_27348;
var statearr_27350_27615 = state_27348__$1;
(statearr_27350_27615[(2)] = null);

(statearr_27350_27615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27349 === (2))){
var _ = (function (){var statearr_27351 = state_27348;
(statearr_27351[(4)] = cljs.core.cons((5),(state_27348[(4)])));

return statearr_27351;
})();
var inst_27339 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_27348__$1 = state_27348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27348__$1,(6),inst_27339);
} else {
if((state_val_27349 === (3))){
var inst_27346 = (state_27348[(2)]);
var state_27348__$1 = state_27348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27348__$1,inst_27346);
} else {
if((state_val_27349 === (4))){
var inst_27333 = (state_27348[(2)]);
var state_27348__$1 = state_27348;
var statearr_27353_27616 = state_27348__$1;
(statearr_27353_27616[(2)] = inst_27333);

(statearr_27353_27616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27349 === (5))){
var _ = (function (){var statearr_27354 = state_27348;
(statearr_27354[(4)] = cljs.core.rest((state_27348[(4)])));

return statearr_27354;
})();
var state_27348__$1 = state_27348;
var ex27352 = (state_27348__$1[(2)]);
var statearr_27355_27617 = state_27348__$1;
(statearr_27355_27617[(5)] = ex27352);


if((ex27352 instanceof Error)){
var statearr_27356_27618 = state_27348__$1;
(statearr_27356_27618[(1)] = (4));

(statearr_27356_27618[(5)] = null);

} else {
throw ex27352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27349 === (6))){
var inst_27341 = (state_27348[(2)]);
var inst_27342 = fluree.db.util.async.throw_err(inst_27341);
var inst_27343 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27342,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27357 = state_27348;
(statearr_27357[(4)] = cljs.core.rest((state_27348[(4)])));

return statearr_27357;
})();
var state_27348__$1 = state_27348;
var statearr_27358_27619 = state_27348__$1;
(statearr_27358_27619[(2)] = inst_27343);

(statearr_27358_27619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_27359 = [null,null,null,null,null,null,null];
(statearr_27359[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_27359[(1)] = (1));

return statearr_27359;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_27348){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27348);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27360){var ex__2417__auto__ = e27360;
var statearr_27361_27620 = state_27348;
(statearr_27361_27620[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27348[(4)]))){
var statearr_27362_27621 = state_27348;
(statearr_27362_27621[(1)] = cljs.core.first((state_27348[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27622 = state_27348;
state_27348 = G__27622;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_27348){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_27348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27363 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27363[(6)] = c__2436__auto__);

return statearr_27363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27364 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27364.cljs$core$IFn$_invoke$arity$1 ? fexpr__27364.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27364.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27365 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27365.cljs$core$IFn$_invoke$arity$1 ? fexpr__27365.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27365.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__27366 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__27366);
} else {
return G__27366;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$(this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t(this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27398){
var state_val_27399 = (state_27398[(1)]);
if((state_val_27399 === (7))){
var state_27398__$1 = state_27398;
var statearr_27400_27623 = state_27398__$1;
(statearr_27400_27623[(2)] = null);

(statearr_27400_27623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (1))){
var state_27398__$1 = state_27398;
var statearr_27401_27624 = state_27398__$1;
(statearr_27401_27624[(2)] = null);

(statearr_27401_27624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (4))){
var inst_27367 = (state_27398[(2)]);
var state_27398__$1 = state_27398;
var statearr_27402_27625 = state_27398__$1;
(statearr_27402_27625[(2)] = inst_27367);

(statearr_27402_27625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (6))){
var inst_27381 = (state_27398[(7)]);
var inst_27380 = (state_27398[(2)]);
var inst_27381__$1 = fluree.db.util.async.throw_err(inst_27380);
var inst_27382 = (inst_27381__$1 == null);
var state_27398__$1 = (function (){var statearr_27403 = state_27398;
(statearr_27403[(7)] = inst_27381__$1);

return statearr_27403;
})();
if(cljs.core.truth_(inst_27382)){
var statearr_27404_27626 = state_27398__$1;
(statearr_27404_27626[(1)] = (7));

} else {
var statearr_27405_27627 = state_27398__$1;
(statearr_27405_27627[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (3))){
var inst_27396 = (state_27398[(2)]);
var state_27398__$1 = state_27398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27398__$1,inst_27396);
} else {
if((state_val_27399 === (12))){
var inst_27393 = (state_27398[(2)]);
var _ = (function (){var statearr_27406 = state_27398;
(statearr_27406[(4)] = cljs.core.rest((state_27398[(4)])));

return statearr_27406;
})();
var state_27398__$1 = state_27398;
var statearr_27407_27628 = state_27398__$1;
(statearr_27407_27628[(2)] = inst_27393);

(statearr_27407_27628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (2))){
var _ = (function (){var statearr_27408 = state_27398;
(statearr_27408[(4)] = cljs.core.cons((5),(state_27398[(4)])));

return statearr_27408;
})();
var inst_27374 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27376 = [tag_id,(30)];
var inst_27377 = (new cljs.core.PersistentVector(null,2,(5),inst_27375,inst_27376,null));
var inst_27378 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27374,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27377);
var state_27398__$1 = state_27398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27398__$1,(6),inst_27378);
} else {
if((state_val_27399 === (11))){
var inst_27387 = (state_27398[(8)]);
var inst_27391 = inst_27387.o;
var state_27398__$1 = state_27398;
var statearr_27410_27629 = state_27398__$1;
(statearr_27410_27629[(2)] = inst_27391);

(statearr_27410_27629[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (9))){
var inst_27387 = (state_27398[(8)]);
var inst_27387__$1 = (state_27398[(2)]);
var inst_27388 = (inst_27387__$1 == null);
var state_27398__$1 = (function (){var statearr_27411 = state_27398;
(statearr_27411[(8)] = inst_27387__$1);

return statearr_27411;
})();
if(cljs.core.truth_(inst_27388)){
var statearr_27412_27630 = state_27398__$1;
(statearr_27412_27630[(1)] = (10));

} else {
var statearr_27413_27631 = state_27398__$1;
(statearr_27413_27631[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (5))){
var _ = (function (){var statearr_27414 = state_27398;
(statearr_27414[(4)] = cljs.core.rest((state_27398[(4)])));

return statearr_27414;
})();
var state_27398__$1 = state_27398;
var ex27409 = (state_27398__$1[(2)]);
var statearr_27415_27632 = state_27398__$1;
(statearr_27415_27632[(5)] = ex27409);


if((ex27409 instanceof Error)){
var statearr_27416_27633 = state_27398__$1;
(statearr_27416_27633[(1)] = (4));

(statearr_27416_27633[(5)] = null);

} else {
throw ex27409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (10))){
var state_27398__$1 = state_27398;
var statearr_27417_27634 = state_27398__$1;
(statearr_27417_27634[(2)] = null);

(statearr_27417_27634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27399 === (8))){
var inst_27381 = (state_27398[(7)]);
var inst_27385 = cljs.core.first(inst_27381);
var state_27398__$1 = state_27398;
var statearr_27418_27635 = state_27398__$1;
(statearr_27418_27635[(2)] = inst_27385);

(statearr_27418_27635[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_27419 = [null,null,null,null,null,null,null,null,null];
(statearr_27419[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_27419[(1)] = (1));

return statearr_27419;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_27398){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27398);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27420){var ex__2417__auto__ = e27420;
var statearr_27421_27636 = state_27398;
(statearr_27421_27636[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27398[(4)]))){
var statearr_27422_27637 = state_27398;
(statearr_27422_27637[(1)] = cljs.core.first((state_27398[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27638 = state_27398;
state_27398 = G__27638;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_27398){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_27398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27423 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27423[(6)] = c__2436__auto__);

return statearr_27423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27459){
var state_val_27460 = (state_27459[(1)]);
if((state_val_27460 === (7))){
var inst_27433 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27459__$1 = state_27459;
var statearr_27461_27639 = state_27459__$1;
(statearr_27461_27639[(2)] = inst_27433);

(statearr_27461_27639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (1))){
var state_27459__$1 = state_27459;
var statearr_27462_27640 = state_27459__$1;
(statearr_27462_27640[(2)] = null);

(statearr_27462_27640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (4))){
var inst_27424 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27463_27641 = state_27459__$1;
(statearr_27463_27641[(2)] = inst_27424);

(statearr_27463_27641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (15))){
var inst_27454 = (state_27459[(2)]);
var _ = (function (){var statearr_27464 = state_27459;
(statearr_27464[(4)] = cljs.core.rest((state_27459[(4)])));

return statearr_27464;
})();
var state_27459__$1 = state_27459;
var statearr_27465_27642 = state_27459__$1;
(statearr_27465_27642[(2)] = inst_27454);

(statearr_27465_27642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (13))){
var inst_27439 = (state_27459[(7)]);
var inst_27445 = clojure.string.includes_QMARK_(inst_27439,":");
var state_27459__$1 = state_27459;
if(inst_27445){
var statearr_27466_27643 = state_27459__$1;
(statearr_27466_27643[(1)] = (16));

} else {
var statearr_27467_27644 = state_27459__$1;
(statearr_27467_27644[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (6))){
var state_27459__$1 = state_27459;
var statearr_27468_27645 = state_27459__$1;
(statearr_27468_27645[(2)] = pred);

(statearr_27468_27645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (17))){
var inst_27439 = (state_27459[(7)]);
var state_27459__$1 = state_27459;
var statearr_27469_27646 = state_27459__$1;
(statearr_27469_27646[(2)] = inst_27439);

(statearr_27469_27646[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (3))){
var inst_27457 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27459__$1,inst_27457);
} else {
if((state_val_27460 === (12))){
var inst_27443 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
if(cljs.core.truth_(inst_27443)){
var statearr_27470_27647 = state_27459__$1;
(statearr_27470_27647[(1)] = (13));

} else {
var statearr_27471_27648 = state_27459__$1;
(statearr_27471_27648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (2))){
var _ = (function (){var statearr_27472 = state_27459;
(statearr_27472[(4)] = cljs.core.cons((5),(state_27459[(4)])));

return statearr_27472;
})();
var inst_27430 = typeof pred === 'string';
var state_27459__$1 = state_27459;
if(cljs.core.truth_(inst_27430)){
var statearr_27473_27649 = state_27459__$1;
(statearr_27473_27649[(1)] = (6));

} else {
var statearr_27474_27650 = state_27459__$1;
(statearr_27474_27650[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (11))){
var inst_27435 = (state_27459[(8)]);
var state_27459__$1 = state_27459;
var statearr_27476_27651 = state_27459__$1;
(statearr_27476_27651[(2)] = inst_27435);

(statearr_27476_27651[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (9))){
var inst_27435 = (state_27459[(8)]);
var inst_27438 = (state_27459[(2)]);
var inst_27439 = fluree.db.util.async.throw_err(inst_27438);
var state_27459__$1 = (function (){var statearr_27477 = state_27459;
(statearr_27477[(7)] = inst_27439);

return statearr_27477;
})();
if(cljs.core.truth_(inst_27435)){
var statearr_27478_27652 = state_27459__$1;
(statearr_27478_27652[(1)] = (10));

} else {
var statearr_27479_27653 = state_27459__$1;
(statearr_27479_27653[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (5))){
var _ = (function (){var statearr_27480 = state_27459;
(statearr_27480[(4)] = cljs.core.rest((state_27459[(4)])));

return statearr_27480;
})();
var state_27459__$1 = state_27459;
var ex27475 = (state_27459__$1[(2)]);
var statearr_27481_27654 = state_27459__$1;
(statearr_27481_27654[(5)] = ex27475);


if((ex27475 instanceof Error)){
var statearr_27482_27655 = state_27459__$1;
(statearr_27482_27655[(1)] = (4));

(statearr_27482_27655[(5)] = null);

} else {
throw ex27475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (14))){
var state_27459__$1 = state_27459;
var statearr_27483_27656 = state_27459__$1;
(statearr_27483_27656[(2)] = null);

(statearr_27483_27656[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (16))){
var inst_27439 = (state_27459[(7)]);
var inst_27447 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27439,/:/);
var inst_27448 = cljs.core.second(inst_27447);
var state_27459__$1 = state_27459;
var statearr_27484_27657 = state_27459__$1;
(statearr_27484_27657[(2)] = inst_27448);

(statearr_27484_27657[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (10))){
var inst_27439 = (state_27459[(7)]);
var state_27459__$1 = state_27459;
var statearr_27485_27658 = state_27459__$1;
(statearr_27485_27658[(2)] = inst_27439);

(statearr_27485_27658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (18))){
var inst_27451 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27486_27659 = state_27459__$1;
(statearr_27486_27659[(2)] = inst_27451);

(statearr_27486_27659[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27460 === (8))){
var inst_27435 = (state_27459[(2)]);
var inst_27436 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_27459__$1 = (function (){var statearr_27487 = state_27459;
(statearr_27487[(8)] = inst_27435);

return statearr_27487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27459__$1,(9),inst_27436);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_27488 = [null,null,null,null,null,null,null,null,null];
(statearr_27488[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_27488[(1)] = (1));

return statearr_27488;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_27459){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27459);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27489){var ex__2417__auto__ = e27489;
var statearr_27490_27660 = state_27459;
(statearr_27490_27660[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27459[(4)]))){
var statearr_27491_27661 = state_27459;
(statearr_27491_27661[(1)] = cljs.core.first((state_27459[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27662 = state_27459;
state_27459 = G__27662;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_27459){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_27459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27492 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27492[(6)] = c__2436__auto__);

return statearr_27492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27524){
var state_val_27525 = (state_27524[(1)]);
if((state_val_27525 === (7))){
var state_27524__$1 = state_27524;
var statearr_27526_27663 = state_27524__$1;
(statearr_27526_27663[(2)] = null);

(statearr_27526_27663[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (1))){
var state_27524__$1 = state_27524;
var statearr_27527_27664 = state_27524__$1;
(statearr_27527_27664[(2)] = null);

(statearr_27527_27664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (4))){
var inst_27493 = (state_27524[(2)]);
var state_27524__$1 = state_27524;
var statearr_27528_27665 = state_27524__$1;
(statearr_27528_27665[(2)] = inst_27493);

(statearr_27528_27665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (6))){
var inst_27507 = (state_27524[(7)]);
var inst_27506 = (state_27524[(2)]);
var inst_27507__$1 = fluree.db.util.async.throw_err(inst_27506);
var inst_27508 = (inst_27507__$1 == null);
var state_27524__$1 = (function (){var statearr_27529 = state_27524;
(statearr_27529[(7)] = inst_27507__$1);

return statearr_27529;
})();
if(cljs.core.truth_(inst_27508)){
var statearr_27530_27666 = state_27524__$1;
(statearr_27530_27666[(1)] = (7));

} else {
var statearr_27531_27667 = state_27524__$1;
(statearr_27531_27667[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (3))){
var inst_27522 = (state_27524[(2)]);
var state_27524__$1 = state_27524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27524__$1,inst_27522);
} else {
if((state_val_27525 === (12))){
var inst_27519 = (state_27524[(2)]);
var _ = (function (){var statearr_27532 = state_27524;
(statearr_27532[(4)] = cljs.core.rest((state_27524[(4)])));

return statearr_27532;
})();
var state_27524__$1 = state_27524;
var statearr_27533_27668 = state_27524__$1;
(statearr_27533_27668[(2)] = inst_27519);

(statearr_27533_27668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (2))){
var _ = (function (){var statearr_27534 = state_27524;
(statearr_27534[(4)] = cljs.core.cons((5),(state_27524[(4)])));

return statearr_27534;
})();
var inst_27500 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27502 = [(30),tag_name];
var inst_27503 = (new cljs.core.PersistentVector(null,2,(5),inst_27501,inst_27502,null));
var inst_27504 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27500,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27503);
var state_27524__$1 = state_27524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27524__$1,(6),inst_27504);
} else {
if((state_val_27525 === (11))){
var inst_27513 = (state_27524[(8)]);
var inst_27517 = inst_27513.s;
var state_27524__$1 = state_27524;
var statearr_27536_27669 = state_27524__$1;
(statearr_27536_27669[(2)] = inst_27517);

(statearr_27536_27669[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (9))){
var inst_27513 = (state_27524[(8)]);
var inst_27513__$1 = (state_27524[(2)]);
var inst_27514 = (inst_27513__$1 == null);
var state_27524__$1 = (function (){var statearr_27537 = state_27524;
(statearr_27537[(8)] = inst_27513__$1);

return statearr_27537;
})();
if(cljs.core.truth_(inst_27514)){
var statearr_27538_27670 = state_27524__$1;
(statearr_27538_27670[(1)] = (10));

} else {
var statearr_27539_27671 = state_27524__$1;
(statearr_27539_27671[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (5))){
var _ = (function (){var statearr_27540 = state_27524;
(statearr_27540[(4)] = cljs.core.rest((state_27524[(4)])));

return statearr_27540;
})();
var state_27524__$1 = state_27524;
var ex27535 = (state_27524__$1[(2)]);
var statearr_27541_27672 = state_27524__$1;
(statearr_27541_27672[(5)] = ex27535);


if((ex27535 instanceof Error)){
var statearr_27542_27673 = state_27524__$1;
(statearr_27542_27673[(1)] = (4));

(statearr_27542_27673[(5)] = null);

} else {
throw ex27535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (10))){
var state_27524__$1 = state_27524;
var statearr_27543_27674 = state_27524__$1;
(statearr_27543_27674[(2)] = null);

(statearr_27543_27674[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27525 === (8))){
var inst_27507 = (state_27524[(7)]);
var inst_27511 = cljs.core.first(inst_27507);
var state_27524__$1 = state_27524;
var statearr_27544_27675 = state_27524__$1;
(statearr_27544_27675[(2)] = inst_27511);

(statearr_27544_27675[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_27545 = [null,null,null,null,null,null,null,null,null];
(statearr_27545[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_27545[(1)] = (1));

return statearr_27545;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_27524){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27524);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27546){var ex__2417__auto__ = e27546;
var statearr_27547_27676 = state_27524;
(statearr_27547_27676[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27524[(4)]))){
var statearr_27548_27677 = state_27524;
(statearr_27548_27677[(1)] = cljs.core.first((state_27524[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27678 = state_27524;
state_27524 = G__27678;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_27524){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_27524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27549 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27549[(6)] = c__2436__auto__);

return statearr_27549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27584){
var state_val_27585 = (state_27584[(1)]);
if((state_val_27585 === (7))){
var inst_27563 = typeof pred === 'string';
var state_27584__$1 = state_27584;
if(cljs.core.truth_(inst_27563)){
var statearr_27586_27679 = state_27584__$1;
(statearr_27586_27679[(1)] = (10));

} else {
var statearr_27587_27680 = state_27584__$1;
(statearr_27587_27680[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (1))){
var state_27584__$1 = state_27584;
var statearr_27588_27681 = state_27584__$1;
(statearr_27588_27681[(2)] = null);

(statearr_27588_27681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (4))){
var inst_27550 = (state_27584[(2)]);
var state_27584__$1 = state_27584;
var statearr_27589_27682 = state_27584__$1;
(statearr_27589_27682[(2)] = inst_27550);

(statearr_27589_27682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (15))){
var inst_27577 = (state_27584[(2)]);
var state_27584__$1 = state_27584;
var statearr_27590_27683 = state_27584__$1;
(statearr_27590_27683[(2)] = inst_27577);

(statearr_27590_27683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (13))){
var inst_27568 = (state_27584[(7)]);
var inst_27570 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27568),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27571 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_27570);
var state_27584__$1 = state_27584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27584__$1,(16),inst_27571);
} else {
if((state_val_27585 === (6))){
var inst_27558 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_27584__$1 = state_27584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27584__$1,(9),inst_27558);
} else {
if((state_val_27585 === (3))){
var inst_27582 = (state_27584[(2)]);
var state_27584__$1 = state_27584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27584__$1,inst_27582);
} else {
if((state_val_27585 === (12))){
var inst_27568 = (state_27584[(7)]);
var inst_27568__$1 = (state_27584[(2)]);
var state_27584__$1 = (function (){var statearr_27591 = state_27584;
(statearr_27591[(7)] = inst_27568__$1);

return statearr_27591;
})();
if(cljs.core.truth_(inst_27568__$1)){
var statearr_27592_27684 = state_27584__$1;
(statearr_27592_27684[(1)] = (13));

} else {
var statearr_27593_27685 = state_27584__$1;
(statearr_27593_27685[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (2))){
var _ = (function (){var statearr_27594 = state_27584;
(statearr_27594[(4)] = cljs.core.cons((5),(state_27584[(4)])));

return statearr_27594;
})();
var inst_27556 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27584__$1 = state_27584;
if(inst_27556){
var statearr_27595_27686 = state_27584__$1;
(statearr_27595_27686[(1)] = (6));

} else {
var statearr_27596_27687 = state_27584__$1;
(statearr_27596_27687[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (11))){
var inst_27566 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27584__$1 = state_27584;
var statearr_27598_27688 = state_27584__$1;
(statearr_27598_27688[(2)] = inst_27566);

(statearr_27598_27688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (9))){
var inst_27560 = (state_27584[(2)]);
var inst_27561 = fluree.db.util.async.throw_err(inst_27560);
var state_27584__$1 = state_27584;
var statearr_27599_27689 = state_27584__$1;
(statearr_27599_27689[(2)] = inst_27561);

(statearr_27599_27689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (5))){
var _ = (function (){var statearr_27600 = state_27584;
(statearr_27600[(4)] = cljs.core.rest((state_27584[(4)])));

return statearr_27600;
})();
var state_27584__$1 = state_27584;
var ex27597 = (state_27584__$1[(2)]);
var statearr_27601_27690 = state_27584__$1;
(statearr_27601_27690[(5)] = ex27597);


if((ex27597 instanceof Error)){
var statearr_27602_27691 = state_27584__$1;
(statearr_27602_27691[(1)] = (4));

(statearr_27602_27691[(5)] = null);

} else {
throw ex27597;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (14))){
var state_27584__$1 = state_27584;
var statearr_27603_27692 = state_27584__$1;
(statearr_27603_27692[(2)] = null);

(statearr_27603_27692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (16))){
var inst_27573 = (state_27584[(2)]);
var inst_27574 = fluree.db.util.async.throw_err(inst_27573);
var state_27584__$1 = state_27584;
var statearr_27604_27693 = state_27584__$1;
(statearr_27604_27693[(2)] = inst_27574);

(statearr_27604_27693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (10))){
var state_27584__$1 = state_27584;
var statearr_27605_27694 = state_27584__$1;
(statearr_27605_27694[(2)] = pred);

(statearr_27605_27694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27585 === (8))){
var inst_27579 = (state_27584[(2)]);
var _ = (function (){var statearr_27606 = state_27584;
(statearr_27606[(4)] = cljs.core.rest((state_27584[(4)])));

return statearr_27606;
})();
var state_27584__$1 = state_27584;
var statearr_27607_27695 = state_27584__$1;
(statearr_27607_27695[(2)] = inst_27579);

(statearr_27607_27695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2414__auto__ = null;
var fluree$db$graphdb$state_machine__2414__auto____0 = (function (){
var statearr_27608 = [null,null,null,null,null,null,null,null];
(statearr_27608[(0)] = fluree$db$graphdb$state_machine__2414__auto__);

(statearr_27608[(1)] = (1));

return statearr_27608;
});
var fluree$db$graphdb$state_machine__2414__auto____1 = (function (state_27584){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27584);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27609){var ex__2417__auto__ = e27609;
var statearr_27610_27696 = state_27584;
(statearr_27610_27696[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27584[(4)]))){
var statearr_27611_27697 = state_27584;
(statearr_27611_27697[(1)] = cljs.core.first((state_27584[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27698 = state_27584;
state_27584 = G__27698;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2414__auto__ = function(state_27584){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2414__auto____1.call(this,state_27584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2414__auto____0;
fluree$db$graphdb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2414__auto____1;
return fluree$db$graphdb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27612 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27612[(6)] = c__2436__auto__);

return statearr_27612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27283){
var extmap__4419__auto__ = (function (){var G__27613 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27283,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27283)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27613);
} else {
return G__27613;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27283),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27283),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
