// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e19665){var e = e19665;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__19666_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__19666_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__19666_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__19666_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__19666_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19667_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19667_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19668_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19668_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__19673 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19673,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19673,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19669_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19669_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__19676 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19676,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19676,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19670_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19670_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19671_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19671_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__19672_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19672_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19679_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__19679_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__19680 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__19680) : intersecting_vars.call(null,G__19680));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__19683,optional_QMARK_,fuel,max_fuel){
var map__19684 = p__19683;
var map__19684__$1 = (((((!((map__19684 == null))))?(((((map__19684.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19684.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19684):map__19684);
var res = map__19684__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19684__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19751){
var state_val_19752 = (state_19751[(1)]);
if((state_val_19752 === (7))){
var inst_19740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19741 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_19742 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_19741,clause);
var inst_19743 = [null,inst_19742];
var inst_19744 = (new cljs.core.PersistentVector(null,2,(5),inst_19740,inst_19743,null));
var state_19751__$1 = state_19751;
var statearr_19753_19781 = state_19751__$1;
(statearr_19753_19781[(2)] = inst_19744);

(statearr_19753_19781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (1))){
var state_19751__$1 = state_19751;
var statearr_19754_19782 = state_19751__$1;
(statearr_19754_19782[(2)] = null);

(statearr_19754_19782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (4))){
var inst_19686 = (state_19751[(2)]);
var state_19751__$1 = state_19751;
var statearr_19755_19783 = state_19751__$1;
(statearr_19755_19783[(2)] = inst_19686);

(statearr_19755_19783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (15))){
var inst_19729 = (state_19751[(2)]);
var inst_19730 = fluree.db.util.async.throw_err(inst_19729);
var inst_19731 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_19730);
var inst_19732 = cljs.core.count(inst_19731);
var inst_19733 = fluree.db.query.analytical.add_fuel(inst_19732,fuel,max_fuel);
var inst_19734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19735 = [inst_19730,r];
var inst_19736 = (new cljs.core.PersistentVector(null,2,(5),inst_19734,inst_19735,null));
var state_19751__$1 = (function (){var statearr_19756 = state_19751;
(statearr_19756[(7)] = inst_19733);

return statearr_19756;
})();
var statearr_19757_19784 = state_19751__$1;
(statearr_19757_19784[(2)] = inst_19736);

(statearr_19757_19784[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (13))){
var inst_19695 = (state_19751[(8)]);
var inst_19708 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19709 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_19708);
var inst_19710 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_19695);
var inst_19711 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19710);
var inst_19712 = cljs.core.set(inst_19711);
var inst_19713 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_19709);
var inst_19714 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19713);
var inst_19715 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19712,inst_19714);
var inst_19716 = (function (){var all_wd = inst_19695;
var optional = inst_19709;
var all_wd_vars = inst_19712;
var all_vars = inst_19715;
return (function (p1__19681_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__19681_SHARP_) : all_vars.call(null,p1__19681_SHARP_));
});
})();
var inst_19717 = cljs.core.keys(vars);
var inst_19718 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19716,inst_19717);
var inst_19719 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_19718);
var inst_19720 = cljs.core.set(inst_19719);
var inst_19721 = (function (){var all_wd = inst_19695;
var optional = inst_19709;
var all_wd_vars = inst_19712;
var all_vars = inst_19715;
var intersecting_vars = inst_19720;
return (function (p1__19682_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__19682_SHARP_);
});
})();
var inst_19722 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_19721,inst_19695);
var inst_19723 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_19722);
var inst_19724 = fluree.db.query.analytical.select_from_tuples(inst_19723,res);
var inst_19725 = fluree.db.query.analytical.replace_vars_wikidata(inst_19695,inst_19720,vars);
var inst_19726 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_19720,inst_19715);
var inst_19727 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_19725,inst_19723,inst_19724,inst_19726,inst_19709);
var state_19751__$1 = state_19751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19751__$1,(15),inst_19727);
} else {
if((state_val_19752 === (6))){
var inst_19696 = (state_19751[(9)]);
var inst_19694 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_19695 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_19694);
var inst_19696__$1 = optional_QMARK_;
var state_19751__$1 = (function (){var statearr_19758 = state_19751;
(statearr_19758[(8)] = inst_19695);

(statearr_19758[(9)] = inst_19696__$1);

return statearr_19758;
})();
if(cljs.core.truth_(inst_19696__$1)){
var statearr_19759_19785 = state_19751__$1;
(statearr_19759_19785[(1)] = (9));

} else {
var statearr_19760_19786 = state_19751__$1;
(statearr_19760_19786[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (3))){
var inst_19749 = (state_19751[(2)]);
var state_19751__$1 = state_19751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19751__$1,inst_19749);
} else {
if((state_val_19752 === (12))){
var inst_19704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19705 = [null,r];
var inst_19706 = (new cljs.core.PersistentVector(null,2,(5),inst_19704,inst_19705,null));
var state_19751__$1 = state_19751;
var statearr_19761_19787 = state_19751__$1;
(statearr_19761_19787[(2)] = inst_19706);

(statearr_19761_19787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (2))){
var _ = (function (){var statearr_19762 = state_19751;
(statearr_19762[(4)] = cljs.core.cons((5),(state_19751[(4)])));

return statearr_19762;
})();
var inst_19692 = (r == null);
var state_19751__$1 = state_19751;
if(cljs.core.truth_(inst_19692)){
var statearr_19763_19788 = state_19751__$1;
(statearr_19763_19788[(1)] = (6));

} else {
var statearr_19764_19789 = state_19751__$1;
(statearr_19764_19789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (11))){
var inst_19702 = (state_19751[(2)]);
var state_19751__$1 = state_19751;
if(cljs.core.truth_(inst_19702)){
var statearr_19766_19790 = state_19751__$1;
(statearr_19766_19790[(1)] = (12));

} else {
var statearr_19767_19791 = state_19751__$1;
(statearr_19767_19791[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (9))){
var inst_19695 = (state_19751[(8)]);
var inst_19698 = cljs.core.empty_QMARK_(inst_19695);
var inst_19699 = (!(inst_19698));
var state_19751__$1 = state_19751;
var statearr_19768_19792 = state_19751__$1;
(statearr_19768_19792[(2)] = inst_19699);

(statearr_19768_19792[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (5))){
var _ = (function (){var statearr_19769 = state_19751;
(statearr_19769[(4)] = cljs.core.rest((state_19751[(4)])));

return statearr_19769;
})();
var state_19751__$1 = state_19751;
var ex19765 = (state_19751__$1[(2)]);
var statearr_19770_19793 = state_19751__$1;
(statearr_19770_19793[(5)] = ex19765);


if((ex19765 instanceof Error)){
var statearr_19771_19794 = state_19751__$1;
(statearr_19771_19794[(1)] = (4));

(statearr_19771_19794[(5)] = null);

} else {
throw ex19765;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (14))){
var inst_19738 = (state_19751[(2)]);
var state_19751__$1 = state_19751;
var statearr_19772_19795 = state_19751__$1;
(statearr_19772_19795[(2)] = inst_19738);

(statearr_19772_19795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (10))){
var inst_19696 = (state_19751[(9)]);
var state_19751__$1 = state_19751;
var statearr_19773_19796 = state_19751__$1;
(statearr_19773_19796[(2)] = inst_19696);

(statearr_19773_19796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19752 === (8))){
var inst_19746 = (state_19751[(2)]);
var _ = (function (){var statearr_19774 = state_19751;
(statearr_19774[(4)] = cljs.core.rest((state_19751[(4)])));

return statearr_19774;
})();
var state_19751__$1 = state_19751;
var statearr_19775_19797 = state_19751__$1;
(statearr_19775_19797[(2)] = inst_19746);

(statearr_19775_19797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_19776 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19776[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__);

(statearr_19776[(1)] = (1));

return statearr_19776;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1 = (function (state_19751){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19751);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19777){var ex__2417__auto__ = e19777;
var statearr_19778_19798 = state_19751;
(statearr_19778_19798[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19751[(4)]))){
var statearr_19779_19799 = state_19751;
(statearr_19779_19799[(1)] = cljs.core.first((state_19751[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19800 = state_19751;
state_19751 = G__19800;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__ = function(state_19751){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1.call(this,state_19751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19780 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19780[(6)] = c__2436__auto__);

return statearr_19780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__19802 = arguments.length;
switch (G__19802) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19896){
var state_val_19897 = (state_19896[(1)]);
if((state_val_19897 === (7))){
var inst_19809 = (state_19896[(7)]);
var inst_19819 = clojure.string.starts_with_QMARK_(inst_19809,"$fdb");
var state_19896__$1 = state_19896;
if(inst_19819){
var statearr_19898_19947 = state_19896__$1;
(statearr_19898_19947[(1)] = (9));

} else {
var statearr_19899_19948 = state_19896__$1;
(statearr_19899_19948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (20))){
var state_19896__$1 = state_19896;
var statearr_19900_19949 = state_19896__$1;
(statearr_19900_19949[(2)] = null);

(statearr_19900_19949[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (27))){
var inst_19859 = (state_19896[(8)]);
var state_19896__$1 = state_19896;
var statearr_19901_19950 = state_19896__$1;
(statearr_19901_19950[(2)] = inst_19859);

(statearr_19901_19950[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (1))){
var state_19896__$1 = state_19896;
var statearr_19902_19951 = state_19896__$1;
(statearr_19902_19951[(2)] = null);

(statearr_19902_19951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (24))){
var inst_19882 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19903_19952 = state_19896__$1;
(statearr_19903_19952[(2)] = inst_19882);

(statearr_19903_19952[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (4))){
var inst_19803 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19904_19953 = state_19896__$1;
(statearr_19904_19953[(2)] = inst_19803);

(statearr_19904_19953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (15))){
var inst_19826 = (state_19896[(9)]);
var inst_19832 = (state_19896[(2)]);
var inst_19833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19834 = cljs.core.PersistentVector.EMPTY;
var inst_19835 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19836 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19834,inst_19835);
var inst_19837 = [inst_19826,inst_19836];
var inst_19838 = (new cljs.core.PersistentVector(null,2,(5),inst_19833,inst_19837,null));
var state_19896__$1 = (function (){var statearr_19905 = state_19896;
(statearr_19905[(10)] = inst_19832);

return statearr_19905;
})();
var statearr_19906_19954 = state_19896__$1;
(statearr_19906_19954[(2)] = inst_19838);

(statearr_19906_19954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (21))){
var inst_19885 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19907_19955 = state_19896__$1;
(statearr_19907_19955[(2)] = inst_19885);

(statearr_19907_19955[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (13))){
var inst_19826 = (state_19896[(9)]);
var inst_19829 = (function(){throw inst_19826})();
var state_19896__$1 = state_19896;
var statearr_19908_19956 = state_19896__$1;
(statearr_19908_19956[(2)] = inst_19829);

(statearr_19908_19956[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (22))){
var inst_19848 = (state_19896[(11)]);
var inst_19850 = (state_19896[(12)]);
var inst_19852 = fluree.db.query.analytical.parse_block_from_source(inst_19848);
var inst_19853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19854 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_19850];
var inst_19855 = (new cljs.core.PersistentVector(null,2,(5),inst_19853,inst_19854,null));
var inst_19856 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_19855);
var state_19896__$1 = (function (){var statearr_19909 = state_19896;
(statearr_19909[(13)] = inst_19852);

return statearr_19909;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19896__$1,(25),inst_19856);
} else {
if((state_val_19897 === (29))){
var inst_19863 = (state_19896[(2)]);
var inst_19864 = fluree.db.util.async.throw_err(inst_19863);
var state_19896__$1 = state_19896;
var statearr_19910_19957 = state_19896__$1;
(statearr_19910_19957[(2)] = inst_19864);

(statearr_19910_19957[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (6))){
var inst_19812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19813 = cljs.core.PersistentVector.EMPTY;
var inst_19814 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19815 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19813,inst_19814);
var inst_19816 = [db,inst_19815];
var inst_19817 = (new cljs.core.PersistentVector(null,2,(5),inst_19812,inst_19816,null));
var state_19896__$1 = state_19896;
var statearr_19911_19958 = state_19896__$1;
(statearr_19911_19958[(2)] = inst_19817);

(statearr_19911_19958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (28))){
var inst_19867 = (state_19896[(2)]);
var inst_19868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19869 = cljs.core.PersistentVector.EMPTY;
var inst_19870 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_19871 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_19869,inst_19870);
var inst_19872 = [inst_19867,inst_19871];
var inst_19873 = (new cljs.core.PersistentVector(null,2,(5),inst_19868,inst_19872,null));
var state_19896__$1 = state_19896;
var statearr_19912_19959 = state_19896__$1;
(statearr_19912_19959[(2)] = inst_19873);

(statearr_19912_19959[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (25))){
var inst_19852 = (state_19896[(13)]);
var inst_19858 = (state_19896[(2)]);
var inst_19859 = fluree.db.util.async.throw_err(inst_19858);
var state_19896__$1 = (function (){var statearr_19913 = state_19896;
(statearr_19913[(8)] = inst_19859);

return statearr_19913;
})();
if(cljs.core.truth_(inst_19852)){
var statearr_19914_19960 = state_19896__$1;
(statearr_19914_19960[(1)] = (26));

} else {
var statearr_19915_19961 = state_19896__$1;
(statearr_19915_19961[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (17))){
var state_19896__$1 = state_19896;
var statearr_19916_19962 = state_19896__$1;
(statearr_19916_19962[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (3))){
var inst_19894 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19896__$1,inst_19894);
} else {
if((state_val_19897 === (12))){
var inst_19826 = (state_19896[(9)]);
var inst_19825 = (state_19896[(2)]);
var inst_19826__$1 = fluree.db.util.async.throw_err(inst_19825);
var inst_19827 = fluree.db.util.core.exception_QMARK_(inst_19826__$1);
var state_19896__$1 = (function (){var statearr_19918 = state_19896;
(statearr_19918[(9)] = inst_19826__$1);

return statearr_19918;
})();
if(inst_19827){
var statearr_19919_19963 = state_19896__$1;
(statearr_19919_19963[(1)] = (13));

} else {
var statearr_19920_19964 = state_19896__$1;
(statearr_19920_19964[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (2))){
var inst_19809 = (state_19896[(7)]);
var _ = (function (){var statearr_19921 = state_19896;
(statearr_19921[(4)] = cljs.core.cons((5),(state_19896[(4)])));

return statearr_19921;
})();
var inst_19809__$1 = cljs.core.first(clause);
var inst_19810 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_19809__$1);
var state_19896__$1 = (function (){var statearr_19922 = state_19896;
(statearr_19922[(7)] = inst_19809__$1);

return statearr_19922;
})();
if(inst_19810){
var statearr_19923_19965 = state_19896__$1;
(statearr_19923_19965[(1)] = (6));

} else {
var statearr_19924_19966 = state_19896__$1;
(statearr_19924_19966[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (23))){
var inst_19809 = (state_19896[(7)]);
var inst_19875 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19809)," is not supported in Fluree"].join('');
var inst_19876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19877 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19878 = cljs.core.PersistentHashMap.fromArrays(inst_19876,inst_19877);
var inst_19879 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19875,inst_19878);
var inst_19880 = (function(){throw inst_19879})();
var state_19896__$1 = state_19896;
var statearr_19925_19967 = state_19896__$1;
(statearr_19925_19967[(2)] = inst_19880);

(statearr_19925_19967[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (19))){
var inst_19850 = (state_19896[(12)]);
var inst_19809 = (state_19896[(7)]);
var inst_19847 = fluree.db.query.analytical.isolate_source_name(inst_19809);
var inst_19848 = fluree.db.query.analytical.isolate_source_block(inst_19809);
var inst_19849 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_19847);
var inst_19850__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_19849);
var state_19896__$1 = (function (){var statearr_19926 = state_19896;
(statearr_19926[(11)] = inst_19848);

(statearr_19926[(12)] = inst_19850__$1);

return statearr_19926;
})();
if(cljs.core.truth_(inst_19850__$1)){
var statearr_19927_19968 = state_19896__$1;
(statearr_19927_19968[(1)] = (22));

} else {
var statearr_19928_19969 = state_19896__$1;
(statearr_19928_19969[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (11))){
var inst_19889 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19930_19970 = state_19896__$1;
(statearr_19930_19970[(2)] = inst_19889);

(statearr_19930_19970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (9))){
var inst_19809 = (state_19896[(7)]);
var inst_19821 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_19809,(4));
var inst_19822 = fluree.db.query.analytical.parse_block_from_source(inst_19821);
var inst_19823 = fluree.db.time_travel.as_of_block(db,inst_19822);
var state_19896__$1 = state_19896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19896__$1,(12),inst_19823);
} else {
if((state_val_19897 === (5))){
var _ = (function (){var statearr_19931 = state_19896;
(statearr_19931[(4)] = cljs.core.rest((state_19896[(4)])));

return statearr_19931;
})();
var state_19896__$1 = state_19896;
var ex19929 = (state_19896__$1[(2)]);
var statearr_19932_19971 = state_19896__$1;
(statearr_19932_19971[(5)] = ex19929);


if((ex19929 instanceof Error)){
var statearr_19933_19972 = state_19896__$1;
(statearr_19933_19972[(1)] = (4));

(statearr_19933_19972[(5)] = null);

} else {
throw ex19929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (14))){
var state_19896__$1 = state_19896;
var statearr_19934_19973 = state_19896__$1;
(statearr_19934_19973[(2)] = null);

(statearr_19934_19973[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (26))){
var inst_19859 = (state_19896[(8)]);
var inst_19852 = (state_19896[(13)]);
var inst_19861 = fluree.db.time_travel.as_of_block(inst_19859,inst_19852);
var state_19896__$1 = state_19896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19896__$1,(29),inst_19861);
} else {
if((state_val_19897 === (16))){
var inst_19842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19843 = ["$wd",clause];
var inst_19844 = (new cljs.core.PersistentVector(null,2,(5),inst_19842,inst_19843,null));
var state_19896__$1 = state_19896;
var statearr_19935_19974 = state_19896__$1;
(statearr_19935_19974[(2)] = inst_19844);

(statearr_19935_19974[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (10))){
var inst_19809 = (state_19896[(7)]);
var inst_19840 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_19809);
var state_19896__$1 = state_19896;
if(inst_19840){
var statearr_19936_19975 = state_19896__$1;
(statearr_19936_19975[(1)] = (16));

} else {
var statearr_19937_19976 = state_19896__$1;
(statearr_19937_19976[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (18))){
var inst_19887 = (state_19896[(2)]);
var state_19896__$1 = state_19896;
var statearr_19938_19977 = state_19896__$1;
(statearr_19938_19977[(2)] = inst_19887);

(statearr_19938_19977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19897 === (8))){
var inst_19891 = (state_19896[(2)]);
var _ = (function (){var statearr_19939 = state_19896;
(statearr_19939[(4)] = cljs.core.rest((state_19896[(4)])));

return statearr_19939;
})();
var state_19896__$1 = state_19896;
var statearr_19940_19978 = state_19896__$1;
(statearr_19940_19978[(2)] = inst_19891);

(statearr_19940_19978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2414__auto__ = null;
var fluree$db$query$analytical$state_machine__2414__auto____0 = (function (){
var statearr_19941 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19941[(0)] = fluree$db$query$analytical$state_machine__2414__auto__);

(statearr_19941[(1)] = (1));

return statearr_19941;
});
var fluree$db$query$analytical$state_machine__2414__auto____1 = (function (state_19896){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19896);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19942){var ex__2417__auto__ = e19942;
var statearr_19943_19979 = state_19896;
(statearr_19943_19979[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19896[(4)]))){
var statearr_19944_19980 = state_19896;
(statearr_19944_19980[(1)] = cljs.core.first((state_19896[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19981 = state_19896;
state_19896 = G__19981;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2414__auto__ = function(state_19896){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2414__auto____1.call(this,state_19896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2414__auto____0;
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2414__auto____1;
return fluree$db$query$analytical$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19945 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19945[(6)] = c__2436__auto__);

return statearr_19945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__19982){
var vec__19983 = p__19982;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19983,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19983,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19986_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__19986_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__19990 = subjects;
var vec__19991 = G__19990;
var seq__19992 = cljs.core.seq(vec__19991);
var first__19993 = cljs.core.first(seq__19992);
var seq__19992__$1 = cljs.core.next(seq__19992);
var subject = first__19993;
var r = seq__19992__$1;
var acc = expanded_map;
var G__19990__$1 = G__19990;
var acc__$1 = acc;
while(true){
var vec__19997 = G__19990__$1;
var seq__19998 = cljs.core.seq(vec__19997);
var first__19999 = cljs.core.first(seq__19998);
var seq__19998__$1 = cljs.core.next(seq__19998);
var subject__$1 = first__19999;
var r__$1 = seq__19998__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20000 = r__$1;
var G__20001 = acc__$2;
G__19990__$1 = G__20000;
acc__$1 = G__20001;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__19990__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__19990__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__19990__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__19990__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__19990__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__19990__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__19997,seq__19998,first__19999,seq__19998__$1,subject__$1,r__$1,acc__$2,G__19990,vec__19991,seq__19992,first__19993,seq__19992__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20002 = r__$1;
var G__20003 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__19990__$1 = G__20002;
acc__$1 = G__20003;
continue;
} else {
var G__20004 = subjects;
var G__20005 = acc_STAR_;
G__19990__$1 = G__20004;
acc__$1 = G__20005;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20006_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20006_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20097){
var state_val_20098 = (state_20097[(1)]);
if((state_val_20098 === (7))){
var state_20097__$1 = state_20097;
var statearr_20099_20145 = state_20097__$1;
(statearr_20099_20145[(2)] = (100));

(statearr_20099_20145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (20))){
var inst_20046 = (state_20097[(7)]);
var state_20097__$1 = state_20097;
var statearr_20100_20146 = state_20097__$1;
(statearr_20100_20146[(2)] = inst_20046);

(statearr_20100_20146[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (1))){
var state_20097__$1 = state_20097;
var statearr_20101_20147 = state_20097__$1;
(statearr_20101_20147[(2)] = null);

(statearr_20101_20147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (24))){
var inst_20083 = (state_20097[(8)]);
var inst_20018 = (state_20097[(9)]);
var inst_20085 = (state_20097[(10)]);
var inst_20084 = (state_20097[(11)]);
var inst_20088 = (function (){var max_depth = inst_20018;
var recur_map__$1 = inst_20084;
var subjects = inst_20083;
var tuples = inst_20085;
return (function (p1__20007_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20007_SHARP_)],null));
});
})();
var inst_20089 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20088,inst_20085);
var inst_20090 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20089);
var state_20097__$1 = state_20097;
var statearr_20102_20148 = state_20097__$1;
(statearr_20102_20148[(2)] = inst_20090);

(statearr_20102_20148[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (4))){
var inst_20008 = (state_20097[(2)]);
var state_20097__$1 = state_20097;
var statearr_20103_20149 = state_20097__$1;
(statearr_20103_20149[(2)] = inst_20008);

(statearr_20103_20149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (15))){
var inst_20031 = (state_20097[(12)]);
var inst_20042 = cljs.core.PersistentVector.EMPTY;
var inst_20043 = cljs.core.seq(inst_20031);
var inst_20044 = cljs.core.first(inst_20043);
var inst_20045 = cljs.core.next(inst_20043);
var inst_20046 = inst_20042;
var inst_20047 = inst_20031;
var state_20097__$1 = (function (){var statearr_20104 = state_20097;
(statearr_20104[(13)] = inst_20044);

(statearr_20104[(14)] = inst_20047);

(statearr_20104[(7)] = inst_20046);

(statearr_20104[(15)] = inst_20045);

return statearr_20104;
})();
var statearr_20105_20150 = state_20097__$1;
(statearr_20105_20150[(2)] = null);

(statearr_20105_20150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (21))){
var inst_20067 = (state_20097[(2)]);
var state_20097__$1 = state_20097;
var statearr_20106_20151 = state_20097__$1;
(statearr_20106_20151[(2)] = inst_20067);

(statearr_20106_20151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (13))){
var inst_20080 = (state_20097[(2)]);
var state_20097__$1 = state_20097;
var statearr_20107_20152 = state_20097__$1;
(statearr_20107_20152[(2)] = inst_20080);

(statearr_20107_20152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (22))){
var inst_20054 = (state_20097[(16)]);
var inst_20046 = (state_20097[(7)]);
var inst_20061 = (state_20097[(2)]);
var inst_20062 = fluree.db.util.async.throw_err(inst_20061);
var inst_20063 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20046,inst_20062);
var inst_20046__$1 = inst_20063;
var inst_20047 = inst_20054;
var state_20097__$1 = (function (){var statearr_20108 = state_20097;
(statearr_20108[(14)] = inst_20047);

(statearr_20108[(7)] = inst_20046__$1);

return statearr_20108;
})();
var statearr_20109_20153 = state_20097__$1;
(statearr_20109_20153[(2)] = null);

(statearr_20109_20153[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (6))){
var inst_20014 = (state_20097[(17)]);
var state_20097__$1 = state_20097;
var statearr_20110_20154 = state_20097__$1;
(statearr_20110_20154[(2)] = inst_20014);

(statearr_20110_20154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (25))){
var inst_20092 = (state_20097[(2)]);
var _ = (function (){var statearr_20111 = state_20097;
(statearr_20111[(4)] = cljs.core.rest((state_20097[(4)])));

return statearr_20111;
})();
var state_20097__$1 = state_20097;
var statearr_20112_20155 = state_20097__$1;
(statearr_20112_20155[(2)] = inst_20092);

(statearr_20112_20155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (17))){
var inst_20053 = (state_20097[(18)]);
var inst_20047 = (state_20097[(14)]);
var inst_20052 = cljs.core.seq(inst_20047);
var inst_20053__$1 = cljs.core.first(inst_20052);
var inst_20054 = cljs.core.next(inst_20052);
var state_20097__$1 = (function (){var statearr_20113 = state_20097;
(statearr_20113[(18)] = inst_20053__$1);

(statearr_20113[(16)] = inst_20054);

return statearr_20113;
})();
if(cljs.core.truth_(inst_20053__$1)){
var statearr_20114_20156 = state_20097__$1;
(statearr_20114_20156[(1)] = (19));

} else {
var statearr_20115_20157 = state_20097__$1;
(statearr_20115_20157[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (3))){
var inst_20095 = (state_20097[(2)]);
var state_20097__$1 = state_20097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20097__$1,inst_20095);
} else {
if((state_val_20098 === (12))){
var inst_20031 = (state_20097[(12)]);
var inst_20020 = (state_20097[(19)]);
var inst_20026 = cljs.core.vals(inst_20020);
var inst_20027 = cljs.core.flatten(inst_20026);
var inst_20028 = cljs.core.set(inst_20027);
var inst_20029 = cljs.core.keys(inst_20020);
var inst_20030 = cljs.core.set(inst_20029);
var inst_20031__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20028,inst_20030);
var inst_20032 = cljs.core.empty_QMARK_(inst_20031__$1);
var state_20097__$1 = (function (){var statearr_20116 = state_20097;
(statearr_20116[(12)] = inst_20031__$1);

return statearr_20116;
})();
if(inst_20032){
var statearr_20117_20158 = state_20097__$1;
(statearr_20117_20158[(1)] = (14));

} else {
var statearr_20118_20159 = state_20097__$1;
(statearr_20118_20159[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (2))){
var inst_20014 = (state_20097[(17)]);
var _ = (function (){var statearr_20119 = state_20097;
(statearr_20119[(4)] = cljs.core.cons((5),(state_20097[(4)])));

return statearr_20119;
})();
var inst_20014__$1 = depth;
var state_20097__$1 = (function (){var statearr_20120 = state_20097;
(statearr_20120[(17)] = inst_20014__$1);

return statearr_20120;
})();
if(cljs.core.truth_(inst_20014__$1)){
var statearr_20121_20160 = state_20097__$1;
(statearr_20121_20160[(1)] = (6));

} else {
var statearr_20122_20161 = state_20097__$1;
(statearr_20122_20161[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (23))){
var inst_20085 = (state_20097[(10)]);
var state_20097__$1 = state_20097;
var statearr_20123_20162 = state_20097__$1;
(statearr_20123_20162[(2)] = inst_20085);

(statearr_20123_20162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (19))){
var inst_20053 = (state_20097[(18)]);
var inst_20056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20057 = [inst_20053,predicate];
var inst_20058 = (new cljs.core.PersistentVector(null,2,(5),inst_20056,inst_20057,null));
var inst_20059 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20058);
var state_20097__$1 = state_20097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20097__$1,(22),inst_20059);
} else {
if((state_val_20098 === (11))){
var inst_20020 = (state_20097[(19)]);
var state_20097__$1 = state_20097;
var statearr_20125_20163 = state_20097__$1;
(statearr_20125_20163[(2)] = inst_20020);

(statearr_20125_20163[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (9))){
var inst_20018 = (state_20097[(9)]);
var inst_20021 = (state_20097[(20)]);
var inst_20023 = (inst_20021 >= inst_20018);
var state_20097__$1 = state_20097;
if(cljs.core.truth_(inst_20023)){
var statearr_20126_20164 = state_20097__$1;
(statearr_20126_20164[(1)] = (11));

} else {
var statearr_20127_20165 = state_20097__$1;
(statearr_20127_20165[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (5))){
var _ = (function (){var statearr_20128 = state_20097;
(statearr_20128[(4)] = cljs.core.rest((state_20097[(4)])));

return statearr_20128;
})();
var state_20097__$1 = state_20097;
var ex20124 = (state_20097__$1[(2)]);
var statearr_20129_20166 = state_20097__$1;
(statearr_20129_20166[(5)] = ex20124);


if((ex20124 instanceof Error)){
var statearr_20130_20167 = state_20097__$1;
(statearr_20130_20167[(1)] = (4));

(statearr_20130_20167[(5)] = null);

} else {
throw ex20124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (14))){
var inst_20020 = (state_20097[(19)]);
var state_20097__$1 = state_20097;
var statearr_20131_20168 = state_20097__$1;
(statearr_20131_20168[(2)] = inst_20020);

(statearr_20131_20168[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (16))){
var inst_20078 = (state_20097[(2)]);
var state_20097__$1 = state_20097;
var statearr_20132_20169 = state_20097__$1;
(statearr_20132_20169[(2)] = inst_20078);

(statearr_20132_20169[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (10))){
var inst_20083 = (state_20097[(8)]);
var inst_20084 = (state_20097[(11)]);
var inst_20082 = (state_20097[(2)]);
var inst_20083__$1 = cljs.core.keys(inst_20082);
var inst_20084__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20083__$1,inst_20082);
var inst_20085 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20083__$1,inst_20084__$1);
var state_20097__$1 = (function (){var statearr_20133 = state_20097;
(statearr_20133[(8)] = inst_20083__$1);

(statearr_20133[(10)] = inst_20085);

(statearr_20133[(11)] = inst_20084__$1);

return statearr_20133;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20134_20170 = state_20097__$1;
(statearr_20134_20170[(1)] = (23));

} else {
var statearr_20135_20171 = state_20097__$1;
(statearr_20135_20171[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (18))){
var inst_20021 = (state_20097[(20)]);
var inst_20020 = (state_20097[(19)]);
var inst_20069 = (state_20097[(2)]);
var inst_20070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20071 = [(0),(2)];
var inst_20072 = (new cljs.core.PersistentVector(null,2,(5),inst_20070,inst_20071,null));
var inst_20073 = fluree.db.query.analytical.get_ns_arrays(inst_20072,inst_20069);
var inst_20074 = fluree.db.query.analytical.tuples__GT_map(inst_20020,inst_20073);
var inst_20075 = (inst_20021 + (1));
var inst_20020__$1 = inst_20074;
var inst_20021__$1 = inst_20075;
var state_20097__$1 = (function (){var statearr_20136 = state_20097;
(statearr_20136[(20)] = inst_20021__$1);

(statearr_20136[(19)] = inst_20020__$1);

return statearr_20136;
})();
var statearr_20137_20172 = state_20097__$1;
(statearr_20137_20172[(2)] = null);

(statearr_20137_20172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20098 === (8))){
var inst_20018 = (state_20097[(2)]);
var inst_20019 = recur_map;
var inst_20020 = inst_20019;
var inst_20021 = (1);
var state_20097__$1 = (function (){var statearr_20138 = state_20097;
(statearr_20138[(9)] = inst_20018);

(statearr_20138[(20)] = inst_20021);

(statearr_20138[(19)] = inst_20020);

return statearr_20138;
})();
var statearr_20139_20173 = state_20097__$1;
(statearr_20139_20173[(2)] = null);

(statearr_20139_20173[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0 = (function (){
var statearr_20140 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20140[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__);

(statearr_20140[(1)] = (1));

return statearr_20140;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1 = (function (state_20097){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20097);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20141){var ex__2417__auto__ = e20141;
var statearr_20142_20174 = state_20097;
(statearr_20142_20174[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20097[(4)]))){
var statearr_20143_20175 = state_20097;
(statearr_20143_20175[(1)] = cljs.core.first((state_20097[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20176 = state_20097;
state_20097 = G__20176;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__ = function(state_20097){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1.call(this,state_20097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20144 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20144[(6)] = c__2436__auto__);

return statearr_20144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20177,clause,fuel,max_fuel){
var map__20178 = p__20177;
var map__20178__$1 = (((((!((map__20178 == null))))?(((((map__20178.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20178.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20178):map__20178);
var res = map__20178__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20178__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20178__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20178__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20310){
var state_val_20311 = (state_20310[(1)]);
if((state_val_20311 === (7))){
var state_20310__$1 = state_20310;
var statearr_20312_20378 = state_20310__$1;
(statearr_20312_20378[(2)] = false);

(statearr_20312_20378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (20))){
var inst_20242 = (state_20310[(7)]);
var state_20310__$1 = state_20310;
var statearr_20313_20379 = state_20310__$1;
(statearr_20313_20379[(2)] = inst_20242);

(statearr_20313_20379[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (27))){
var inst_20246 = (state_20310[(8)]);
var inst_20270 = (state_20310[(2)]);
var state_20310__$1 = (function (){var statearr_20314 = state_20310;
(statearr_20314[(9)] = inst_20270);

return statearr_20314;
})();
if(cljs.core.truth_(inst_20246)){
var statearr_20315_20380 = state_20310__$1;
(statearr_20315_20380[(1)] = (28));

} else {
var statearr_20316_20381 = state_20310__$1;
(statearr_20316_20381[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (1))){
var state_20310__$1 = state_20310;
var statearr_20317_20382 = state_20310__$1;
(statearr_20317_20382[(2)] = null);

(statearr_20317_20382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (24))){
var inst_20258 = (state_20310[(2)]);
var inst_20259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20260 = fluree.db.query.analytical.variable_QMARK_(inst_20259);
var state_20310__$1 = (function (){var statearr_20318 = state_20310;
(statearr_20318[(10)] = inst_20258);

return statearr_20318;
})();
if(cljs.core.truth_(inst_20260)){
var statearr_20319_20383 = state_20310__$1;
(statearr_20319_20383[(1)] = (25));

} else {
var statearr_20320_20384 = state_20310__$1;
(statearr_20320_20384[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (4))){
var inst_20180 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20321_20385 = state_20310__$1;
(statearr_20321_20385[(2)] = inst_20180);

(statearr_20321_20385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (15))){
var inst_20228 = (state_20310[(11)]);
var state_20310__$1 = state_20310;
var statearr_20322_20386 = state_20310__$1;
(statearr_20322_20386[(2)] = inst_20228);

(statearr_20322_20386[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (21))){
var inst_20213 = (state_20310[(12)]);
var inst_20301 = (state_20310[(2)]);
var inst_20302 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20303 = cljs.core.keys(inst_20213);
var inst_20304 = [inst_20303,vars,inst_20301];
var inst_20305 = cljs.core.PersistentHashMap.fromArrays(inst_20302,inst_20304);
var _ = (function (){var statearr_20323 = state_20310;
(statearr_20323[(4)] = cljs.core.rest((state_20310[(4)])));

return statearr_20323;
})();
var state_20310__$1 = state_20310;
var statearr_20324_20387 = state_20310__$1;
(statearr_20324_20387[(2)] = inst_20305);

(statearr_20324_20387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (31))){
var inst_20244 = (state_20310[(13)]);
var inst_20242 = (state_20310[(7)]);
var inst_20277 = cljs.core.PersistentHashMap.EMPTY;
var inst_20278 = cljs.core.flatten(inst_20242);
var inst_20279 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20277,inst_20244,inst_20278);
var state_20310__$1 = state_20310;
var statearr_20325_20388 = state_20310__$1;
(statearr_20325_20388[(2)] = inst_20279);

(statearr_20325_20388[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (32))){
var inst_20244 = (state_20310[(13)]);
var inst_20281 = cljs.core.coll_QMARK_(inst_20244);
var state_20310__$1 = state_20310;
if(inst_20281){
var statearr_20326_20389 = state_20310__$1;
(statearr_20326_20389[(1)] = (34));

} else {
var statearr_20327_20390 = state_20310__$1;
(statearr_20327_20390[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (33))){
var inst_20292 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20328_20391 = state_20310__$1;
(statearr_20328_20391[(2)] = inst_20292);

(statearr_20328_20391[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (13))){
var inst_20190 = (state_20310[(14)]);
var state_20310__$1 = state_20310;
var statearr_20329_20392 = state_20310__$1;
(statearr_20329_20392[(2)] = inst_20190);

(statearr_20329_20392[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (22))){
var inst_20226 = (state_20310[(15)]);
var inst_20250 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20226)].join('');
var inst_20251 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20252 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20253 = cljs.core.PersistentHashMap.fromArrays(inst_20251,inst_20252);
var inst_20254 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20250,inst_20253);
var inst_20255 = (function(){throw inst_20254})();
var state_20310__$1 = state_20310;
var statearr_20330_20393 = state_20310__$1;
(statearr_20330_20393[(2)] = inst_20255);

(statearr_20330_20393[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (36))){
var inst_20290 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20331_20394 = state_20310__$1;
(statearr_20331_20394[(2)] = inst_20290);

(statearr_20331_20394[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (29))){
var inst_20244 = (state_20310[(13)]);
var inst_20275 = typeof inst_20244 === 'number';
var state_20310__$1 = state_20310;
if(cljs.core.truth_(inst_20275)){
var statearr_20332_20395 = state_20310__$1;
(statearr_20332_20395[(1)] = (31));

} else {
var statearr_20333_20396 = state_20310__$1;
(statearr_20333_20396[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (6))){
var inst_20190 = (state_20310[(14)]);
var inst_20195 = inst_20190.cljs$lang$protocol_mask$partition0$;
var inst_20196 = (inst_20195 & (64));
var inst_20197 = inst_20190.cljs$core$ISeq$;
var inst_20198 = (cljs.core.PROTOCOL_SENTINEL === inst_20197);
var inst_20199 = ((inst_20196) || (inst_20198));
var state_20310__$1 = state_20310;
if(cljs.core.truth_(inst_20199)){
var statearr_20334_20397 = state_20310__$1;
(statearr_20334_20397[(1)] = (9));

} else {
var statearr_20335_20398 = state_20310__$1;
(statearr_20335_20398[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (28))){
var inst_20242 = (state_20310[(7)]);
var inst_20272 = cljs.core.PersistentHashMap.EMPTY;
var inst_20273 = fluree.db.query.analytical.tuples__GT_map(inst_20272,inst_20242);
var state_20310__$1 = state_20310;
var statearr_20336_20399 = state_20310__$1;
(statearr_20336_20399[(2)] = inst_20273);

(statearr_20336_20399[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (25))){
var state_20310__$1 = state_20310;
var statearr_20337_20400 = state_20310__$1;
(statearr_20337_20400[(2)] = null);

(statearr_20337_20400[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (34))){
var inst_20242 = (state_20310[(7)]);
var inst_20238 = (state_20310[(16)]);
var inst_20283 = cljs.core.PersistentHashMap.EMPTY;
var inst_20284 = cljs.core.first(inst_20238);
var inst_20285 = cljs.core.first(inst_20284);
var inst_20286 = cljs.core.flatten(inst_20242);
var inst_20287 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20283,inst_20285,inst_20286);
var state_20310__$1 = state_20310;
var statearr_20338_20401 = state_20310__$1;
(statearr_20338_20401[(2)] = inst_20287);

(statearr_20338_20401[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (17))){
var inst_20227 = (state_20310[(17)]);
var inst_20226 = (state_20310[(15)]);
var inst_20232 = (state_20310[(2)]);
var inst_20233 = [inst_20232];
var inst_20234 = cljs.core.PersistentHashMap.fromArrays(inst_20227,inst_20233);
var inst_20235 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20226,inst_20234);
var state_20310__$1 = state_20310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20310__$1,(18),inst_20235);
} else {
if((state_val_20311 === (3))){
var inst_20308 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20310__$1,inst_20308);
} else {
if((state_val_20311 === (12))){
var inst_20190 = (state_20310[(14)]);
var inst_20208 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20190);
var state_20310__$1 = state_20310;
var statearr_20339_20402 = state_20310__$1;
(statearr_20339_20402[(2)] = inst_20208);

(statearr_20339_20402[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (2))){
var inst_20190 = (state_20310[(14)]);
var _ = (function (){var statearr_20340 = state_20310;
(statearr_20340[(4)] = cljs.core.cons((5),(state_20310[(4)])));

return statearr_20340;
})();
var inst_20190__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20192 = (inst_20190__$1 == null);
var inst_20193 = cljs.core.not(inst_20192);
var state_20310__$1 = (function (){var statearr_20341 = state_20310;
(statearr_20341[(14)] = inst_20190__$1);

return statearr_20341;
})();
if(inst_20193){
var statearr_20342_20403 = state_20310__$1;
(statearr_20342_20403[(1)] = (6));

} else {
var statearr_20343_20404 = state_20310__$1;
(statearr_20343_20404[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (23))){
var state_20310__$1 = state_20310;
var statearr_20344_20405 = state_20310__$1;
(statearr_20344_20405[(2)] = null);

(statearr_20344_20405[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (35))){
var state_20310__$1 = state_20310;
var statearr_20345_20406 = state_20310__$1;
(statearr_20345_20406[(2)] = null);

(statearr_20345_20406[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (19))){
var inst_20247 = (state_20310[(18)]);
var inst_20226 = (state_20310[(15)]);
var inst_20244 = cljs.core.first(inst_20226);
var inst_20245 = cljs.core.first(clause);
var inst_20246 = fluree.db.query.analytical.variable_QMARK_(inst_20245);
var inst_20247__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20226,(1));
var inst_20248 = fluree.db.query.analytical.variable_QMARK_(inst_20247__$1);
var state_20310__$1 = (function (){var statearr_20346 = state_20310;
(statearr_20346[(8)] = inst_20246);

(statearr_20346[(13)] = inst_20244);

(statearr_20346[(18)] = inst_20247__$1);

return statearr_20346;
})();
if(cljs.core.truth_(inst_20248)){
var statearr_20347_20407 = state_20310__$1;
(statearr_20347_20407[(1)] = (22));

} else {
var statearr_20348_20408 = state_20310__$1;
(statearr_20348_20408[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (11))){
var inst_20203 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20350_20409 = state_20310__$1;
(statearr_20350_20409[(2)] = inst_20203);

(statearr_20350_20409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (9))){
var state_20310__$1 = state_20310;
var statearr_20351_20410 = state_20310__$1;
(statearr_20351_20410[(2)] = true);

(statearr_20351_20410[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (5))){
var _ = (function (){var statearr_20352 = state_20310;
(statearr_20352[(4)] = cljs.core.rest((state_20310[(4)])));

return statearr_20352;
})();
var state_20310__$1 = state_20310;
var ex20349 = (state_20310__$1[(2)]);
var statearr_20353_20411 = state_20310__$1;
(statearr_20353_20411[(5)] = ex20349);


if((ex20349 instanceof Error)){
var statearr_20354_20412 = state_20310__$1;
(statearr_20354_20412[(1)] = (4));

(statearr_20354_20412[(5)] = null);

} else {
throw ex20349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (14))){
var inst_20216 = (state_20310[(19)]);
var inst_20228 = (state_20310[(11)]);
var inst_20213 = (state_20310[(12)]);
var inst_20217 = (state_20310[(20)]);
var inst_20211 = (state_20310[(2)]);
var inst_20212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20211,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20213__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20211,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20214 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20211,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20215 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20216__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20214);
var inst_20217__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20214);
var inst_20219 = (function (){var map__20186 = inst_20211;
var search = inst_20212;
var rel = inst_20213__$1;
var opts = inst_20214;
var common_keys = inst_20215;
var object_fn = inst_20216__$1;
var recur_depth = inst_20217__$1;
return (function (p__20218,common_key){
var vec__20355 = p__20218;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20355,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20355,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20358 = cljs.core._EQ_;
var expr__20359 = idx_of;
if(cljs.core.truth_((pred__20358.cljs$core$IFn$_invoke$arity$2 ? pred__20358.cljs$core$IFn$_invoke$arity$2((0),expr__20359) : pred__20358.call(null,(0),expr__20359)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20358.cljs$core$IFn$_invoke$arity$2 ? pred__20358.cljs$core$IFn$_invoke$arity$2((1),expr__20359) : pred__20358.call(null,(1),expr__20359)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20358.cljs$core$IFn$_invoke$arity$2 ? pred__20358.cljs$core$IFn$_invoke$arity$2((2),expr__20359) : pred__20358.call(null,(2),expr__20359)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20359)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20221 = cljs.core.PersistentHashMap.EMPTY;
var inst_20222 = [inst_20221,inst_20212];
var inst_20223 = (new cljs.core.PersistentVector(null,2,(5),inst_20220,inst_20222,null));
var inst_20224 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20219,inst_20223,inst_20215);
var inst_20225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20224,(0),null);
var inst_20226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20224,(1),null);
var inst_20227 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20228__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20225);
var state_20310__$1 = (function (){var statearr_20361 = state_20310;
(statearr_20361[(19)] = inst_20216__$1);

(statearr_20361[(11)] = inst_20228__$1);

(statearr_20361[(12)] = inst_20213__$1);

(statearr_20361[(17)] = inst_20227);

(statearr_20361[(20)] = inst_20217__$1);

(statearr_20361[(15)] = inst_20226);

return statearr_20361;
})();
if(cljs.core.truth_(inst_20228__$1)){
var statearr_20362_20413 = state_20310__$1;
(statearr_20362_20413[(1)] = (15));

} else {
var statearr_20363_20414 = state_20310__$1;
(statearr_20363_20414[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (26))){
var inst_20226 = (state_20310[(15)]);
var inst_20263 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20226)].join('');
var inst_20264 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20265 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20266 = cljs.core.PersistentHashMap.fromArrays(inst_20264,inst_20265);
var inst_20267 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20263,inst_20266);
var inst_20268 = (function(){throw inst_20267})();
var state_20310__$1 = state_20310;
var statearr_20364_20415 = state_20310__$1;
(statearr_20364_20415[(2)] = inst_20268);

(statearr_20364_20415[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (16))){
var inst_20216 = (state_20310[(19)]);
var state_20310__$1 = state_20310;
var statearr_20365_20416 = state_20310__$1;
(statearr_20365_20416[(2)] = inst_20216);

(statearr_20365_20416[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (30))){
var inst_20246 = (state_20310[(8)]);
var inst_20247 = (state_20310[(18)]);
var inst_20217 = (state_20310[(20)]);
var inst_20294 = (state_20310[(2)]);
var inst_20295 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20247,inst_20294,inst_20217,inst_20246);
var state_20310__$1 = state_20310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20310__$1,(37),inst_20295);
} else {
if((state_val_20311 === (10))){
var state_20310__$1 = state_20310;
var statearr_20366_20417 = state_20310__$1;
(statearr_20366_20417[(2)] = false);

(statearr_20366_20417[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (18))){
var inst_20238 = (state_20310[(16)]);
var inst_20213 = (state_20310[(12)]);
var inst_20217 = (state_20310[(20)]);
var inst_20237 = (state_20310[(2)]);
var inst_20238__$1 = fluree.db.util.async.throw_err(inst_20237);
var inst_20239 = cljs.core.count(inst_20238__$1);
var inst_20240 = fluree.db.query.analytical.add_fuel(inst_20239,fuel,max_fuel);
var inst_20241 = cljs.core.vals(inst_20213);
var inst_20242 = fluree.db.query.analytical.get_ns_arrays(inst_20241,inst_20238__$1);
var state_20310__$1 = (function (){var statearr_20367 = state_20310;
(statearr_20367[(7)] = inst_20242);

(statearr_20367[(16)] = inst_20238__$1);

(statearr_20367[(21)] = inst_20240);

return statearr_20367;
})();
if(cljs.core.truth_(inst_20217)){
var statearr_20368_20418 = state_20310__$1;
(statearr_20368_20418[(1)] = (19));

} else {
var statearr_20369_20419 = state_20310__$1;
(statearr_20369_20419[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (37))){
var inst_20297 = (state_20310[(2)]);
var inst_20298 = fluree.db.util.async.throw_err(inst_20297);
var state_20310__$1 = state_20310;
var statearr_20370_20420 = state_20310__$1;
(statearr_20370_20420[(2)] = inst_20298);

(statearr_20370_20420[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (8))){
var inst_20206 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
if(cljs.core.truth_(inst_20206)){
var statearr_20371_20421 = state_20310__$1;
(statearr_20371_20421[(1)] = (12));

} else {
var statearr_20372_20422 = state_20310__$1;
(statearr_20372_20422[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_20373 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20373[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__);

(statearr_20373[(1)] = (1));

return statearr_20373;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1 = (function (state_20310){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20310);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20374){var ex__2417__auto__ = e20374;
var statearr_20375_20423 = state_20310;
(statearr_20375_20423[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20310[(4)]))){
var statearr_20376_20424 = state_20310;
(statearr_20376_20424[(1)] = cljs.core.first((state_20310[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20425 = state_20310;
state_20310 = G__20425;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__ = function(state_20310){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1.call(this,state_20310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20377 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20377[(6)] = c__2436__auto__);

return statearr_20377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20524){
var state_val_20525 = (state_20524[(1)]);
if((state_val_20525 === (7))){
var inst_20435 = (state_20524[(7)]);
var state_20524__$1 = state_20524;
var statearr_20526_20566 = state_20524__$1;
(statearr_20526_20566[(2)] = inst_20435);

(statearr_20526_20566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (20))){
var inst_20515 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
var statearr_20527_20567 = state_20524__$1;
(statearr_20527_20567[(2)] = inst_20515);

(statearr_20527_20567[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (1))){
var state_20524__$1 = state_20524;
var statearr_20528_20568 = state_20524__$1;
(statearr_20528_20568[(2)] = null);

(statearr_20528_20568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (24))){
var inst_20494 = (state_20524[(2)]);
var inst_20495 = fluree.db.util.async.throw_err(inst_20494);
var state_20524__$1 = state_20524;
var statearr_20529_20569 = state_20524__$1;
(statearr_20529_20569[(2)] = inst_20495);

(statearr_20529_20569[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (4))){
var inst_20428 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
var statearr_20530_20570 = state_20524__$1;
(statearr_20530_20570[(2)] = inst_20428);

(statearr_20530_20570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (15))){
var inst_20435 = (state_20524[(7)]);
var inst_20437 = (state_20524[(8)]);
var inst_20456 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20457 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20459 = [inst_20435];
var inst_20460 = (new cljs.core.PersistentVector(null,1,(5),inst_20458,inst_20459,null));
var inst_20461 = (function (){var subject_var = inst_20435;
var object_var = inst_20437;
var min_sid = inst_20456;
var max_sid = (0);
return (function (p1__20426_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20426_SHARP_);
});
})();
var inst_20462 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20456,(0));
var inst_20463 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20461,inst_20462);
var inst_20464 = cljs.core.PersistentHashMap.EMPTY;
var inst_20465 = [inst_20460,inst_20463,inst_20464];
var inst_20466 = cljs.core.PersistentHashMap.fromArrays(inst_20457,inst_20465);
var state_20524__$1 = state_20524;
var statearr_20531_20571 = state_20524__$1;
(statearr_20531_20571[(2)] = inst_20466);

(statearr_20531_20571[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (21))){
var inst_20488 = (state_20524[(9)]);
var state_20524__$1 = state_20524;
var statearr_20532_20572 = state_20524__$1;
(statearr_20532_20572[(2)] = inst_20488);

(statearr_20532_20572[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (13))){
var inst_20437 = (state_20524[(8)]);
var state_20524__$1 = state_20524;
if(cljs.core.truth_(inst_20437)){
var statearr_20533_20573 = state_20524__$1;
(statearr_20533_20573[(1)] = (18));

} else {
var statearr_20534_20574 = state_20524__$1;
(statearr_20534_20574[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (22))){
var inst_20488 = (state_20524[(9)]);
var inst_20492 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20488);
var state_20524__$1 = state_20524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20524__$1,(24),inst_20492);
} else {
if((state_val_20525 === (6))){
var inst_20437 = (state_20524[(8)]);
var state_20524__$1 = state_20524;
var statearr_20535_20575 = state_20524__$1;
(statearr_20535_20575[(2)] = inst_20437);

(statearr_20535_20575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (17))){
var inst_20485 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
var statearr_20536_20576 = state_20524__$1;
(statearr_20536_20576[(2)] = inst_20485);

(statearr_20536_20576[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (3))){
var inst_20522 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20524__$1,inst_20522);
} else {
if((state_val_20525 === (12))){
var inst_20450 = ["_tx",null,"_block",null];
var inst_20451 = (new cljs.core.PersistentArrayMap(null,2,inst_20450,null));
var inst_20452 = (new cljs.core.PersistentHashSet(null,inst_20451,null));
var inst_20453 = cljs.core.last(clause);
var inst_20454 = (inst_20452.cljs$core$IFn$_invoke$arity$1 ? inst_20452.cljs$core$IFn$_invoke$arity$1(inst_20453) : inst_20452.call(null,inst_20453));
var state_20524__$1 = state_20524;
if(cljs.core.truth_(inst_20454)){
var statearr_20537_20577 = state_20524__$1;
(statearr_20537_20577[(1)] = (15));

} else {
var statearr_20538_20578 = state_20524__$1;
(statearr_20538_20578[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (2))){
var inst_20435 = (state_20524[(7)]);
var _ = (function (){var statearr_20539 = state_20524;
(statearr_20539[(4)] = cljs.core.cons((5),(state_20524[(4)])));

return statearr_20539;
})();
var inst_20434 = cljs.core.first(clause);
var inst_20435__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20434);
var inst_20436 = cljs.core.last(clause);
var inst_20437 = fluree.db.query.analytical.variable_QMARK_(inst_20436);
var state_20524__$1 = (function (){var statearr_20540 = state_20524;
(statearr_20540[(7)] = inst_20435__$1);

(statearr_20540[(8)] = inst_20437);

return statearr_20540;
})();
if(cljs.core.truth_(inst_20435__$1)){
var statearr_20541_20579 = state_20524__$1;
(statearr_20541_20579[(1)] = (6));

} else {
var statearr_20542_20580 = state_20524__$1;
(statearr_20542_20580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (23))){
var inst_20437 = (state_20524[(8)]);
var inst_20497 = (state_20524[(2)]);
var inst_20498 = fluree.db.flake.sid__GT_cid(inst_20497);
var inst_20499 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20498);
var inst_20500 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20502 = [inst_20437];
var inst_20503 = (new cljs.core.PersistentVector(null,1,(5),inst_20501,inst_20502,null));
var inst_20504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20506 = [inst_20499];
var inst_20507 = (new cljs.core.PersistentVector(null,1,(5),inst_20505,inst_20506,null));
var inst_20508 = [inst_20507];
var inst_20509 = (new cljs.core.PersistentVector(null,1,(5),inst_20504,inst_20508,null));
var inst_20510 = cljs.core.PersistentHashMap.EMPTY;
var inst_20511 = [inst_20503,inst_20509,inst_20510];
var inst_20512 = cljs.core.PersistentHashMap.fromArrays(inst_20500,inst_20511);
var state_20524__$1 = state_20524;
var statearr_20543_20581 = state_20524__$1;
(statearr_20543_20581[(2)] = inst_20512);

(statearr_20543_20581[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (19))){
var state_20524__$1 = state_20524;
var statearr_20544_20582 = state_20524__$1;
(statearr_20544_20582[(2)] = null);

(statearr_20544_20582[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (11))){
var inst_20519 = (state_20524[(2)]);
var _ = (function (){var statearr_20546 = state_20524;
(statearr_20546[(4)] = cljs.core.rest((state_20524[(4)])));

return statearr_20546;
})();
var state_20524__$1 = state_20524;
var statearr_20547_20583 = state_20524__$1;
(statearr_20547_20583[(2)] = inst_20519);

(statearr_20547_20583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (9))){
var inst_20443 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20444 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20445 = cljs.core.PersistentHashMap.fromArrays(inst_20443,inst_20444);
var inst_20446 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20445);
var inst_20447 = (function(){throw inst_20446})();
var state_20524__$1 = state_20524;
var statearr_20548_20584 = state_20524__$1;
(statearr_20548_20584[(2)] = inst_20447);

(statearr_20548_20584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (5))){
var _ = (function (){var statearr_20549 = state_20524;
(statearr_20549[(4)] = cljs.core.rest((state_20524[(4)])));

return statearr_20549;
})();
var state_20524__$1 = state_20524;
var ex20545 = (state_20524__$1[(2)]);
var statearr_20550_20585 = state_20524__$1;
(statearr_20550_20585[(5)] = ex20545);


if((ex20545 instanceof Error)){
var statearr_20551_20586 = state_20524__$1;
(statearr_20551_20586[(1)] = (4));

(statearr_20551_20586[(5)] = null);

} else {
throw ex20545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (14))){
var inst_20517 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
var statearr_20552_20587 = state_20524__$1;
(statearr_20552_20587[(2)] = inst_20517);

(statearr_20552_20587[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (16))){
var inst_20435 = (state_20524[(7)]);
var inst_20437 = (state_20524[(8)]);
var inst_20468 = cljs.core.last(clause);
var inst_20469 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_20468);
var inst_20470 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20471 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20470,inst_20469);
var inst_20472 = fluree.db.flake.min_subject_id(inst_20469);
var inst_20473 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20475 = [inst_20435];
var inst_20476 = (new cljs.core.PersistentVector(null,1,(5),inst_20474,inst_20475,null));
var inst_20477 = (function (){var subject_var = inst_20435;
var object_var = inst_20437;
var cid = inst_20469;
var max_sid = inst_20471;
var min_sid = inst_20472;
return (function (p1__20427_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20427_SHARP_);
});
})();
var inst_20478 = (inst_20471 + (1));
var inst_20479 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20472,inst_20478);
var inst_20480 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20477,inst_20479);
var inst_20481 = cljs.core.PersistentHashMap.EMPTY;
var inst_20482 = [inst_20476,inst_20480,inst_20481];
var inst_20483 = cljs.core.PersistentHashMap.fromArrays(inst_20473,inst_20482);
var state_20524__$1 = state_20524;
var statearr_20553_20588 = state_20524__$1;
(statearr_20553_20588[(2)] = inst_20483);

(statearr_20553_20588[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (10))){
var inst_20435 = (state_20524[(7)]);
var state_20524__$1 = state_20524;
if(cljs.core.truth_(inst_20435)){
var statearr_20554_20589 = state_20524__$1;
(statearr_20554_20589[(1)] = (12));

} else {
var statearr_20555_20590 = state_20524__$1;
(statearr_20555_20590[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (18))){
var inst_20488 = (state_20524[(9)]);
var inst_20488__$1 = cljs.core.first(clause);
var inst_20489 = typeof inst_20488__$1 === 'number';
var state_20524__$1 = (function (){var statearr_20556 = state_20524;
(statearr_20556[(9)] = inst_20488__$1);

return statearr_20556;
})();
if(cljs.core.truth_(inst_20489)){
var statearr_20557_20591 = state_20524__$1;
(statearr_20557_20591[(1)] = (21));

} else {
var statearr_20558_20592 = state_20524__$1;
(statearr_20558_20592[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20525 === (8))){
var inst_20441 = (state_20524[(2)]);
var state_20524__$1 = state_20524;
if(cljs.core.truth_(inst_20441)){
var statearr_20559_20593 = state_20524__$1;
(statearr_20559_20593[(1)] = (9));

} else {
var statearr_20560_20594 = state_20524__$1;
(statearr_20560_20594[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_20561 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20561[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__);

(statearr_20561[(1)] = (1));

return statearr_20561;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1 = (function (state_20524){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20524);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20562){var ex__2417__auto__ = e20562;
var statearr_20563_20595 = state_20524;
(statearr_20563_20595[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20524[(4)]))){
var statearr_20564_20596 = state_20524;
(statearr_20564_20596[(1)] = cljs.core.first((state_20524[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20597 = state_20524;
state_20524 = G__20597;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__ = function(state_20524){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1.call(this,state_20524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20565 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20565[(6)] = c__2436__auto__);

return statearr_20565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__20604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__20604 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__20604;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__20605(s__20606){
return (new cljs.core.LazySeq(null,(function (){
var s__20606__$1 = s__20606;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__20606__$1);
if(temp__5735__auto__){
var s__20606__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__20606__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__20606__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__20608 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__20607 = (0);
while(true){
if((i__20607 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__20607);
var delta = (x - mean);
cljs.core.chunk_append(b__20608,(delta * delta));

var G__20610 = (i__20607 + (1));
i__20607 = G__20610;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__20608),fluree$db$query$analytical$variance_$_iter__20605(cljs.core.chunk_rest(s__20606__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__20608),null);
}
} else {
var x = cljs.core.first(s__20606__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__20605(cljs.core.rest(s__20606__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__20609 = variance(coll);
return Math.sqrt(G__20609);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__20611 = null;
var G__20611__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__20611__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20611 = function(n,coll){
switch(arguments.length){
case 1:
return G__20611__1.call(this,n);
case 2:
return G__20611__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20611.cljs$core$IFn$_invoke$arity$1 = G__20611__1;
G__20611.cljs$core$IFn$_invoke$arity$2 = G__20611__2;
return G__20611;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20612 = null;
var G__20612__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__20612__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20612 = function(n,coll){
switch(arguments.length){
case 1:
return G__20612__1.call(this,n);
case 2:
return G__20612__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20612.cljs$core$IFn$_invoke$arity$1 = G__20612__1;
G__20612.cljs$core$IFn$_invoke$arity$2 = G__20612__2;
return G__20612;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20613 = null;
var G__20613__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__20613__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__20613 = function(n,coll){
switch(arguments.length){
case 1:
return G__20613__1.call(this,n);
case 2:
return G__20613__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20613.cljs$core$IFn$_invoke$arity$1 = G__20613__1;
G__20613.cljs$core$IFn$_invoke$arity$2 = G__20613__2;
return G__20613;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__20614 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20614,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20614,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20614,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20617 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__20620 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__20620) : agg_fn.call(null,G__20620));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20617,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20617,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__20621 = agg;
var map__20621__$1 = (((((!((map__20621 == null))))?(((((map__20621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20621):map__20621);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20621__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20621__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20621__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__20624 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20624,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20624,(1),null);
var map__20627 = res__$1;
var map__20627__$1 = (((((!((map__20627 == null))))?(((((map__20627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20627):map__20627);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20627__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20627__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20623_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__20623_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20629_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__20629_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20630_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20630_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20631_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20631_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20632_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__20632_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__20635,row,b_tuple){
var vec__20636 = p__20635;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20636,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20636,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20633_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20633_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20634_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__20634_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20639_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20639_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20640_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20640_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__20645 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__20647 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__20646 = (function (p1__20641_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__20641_SHARP_);
});
return fexpr__20646(G__20647);
})()),cljs.core.set(b_idxs));
var fexpr__20644 = (function (p1__20642_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__20642_SHARP_);
});
return fexpr__20644(G__20645);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20643_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20643_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20648_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20648_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20649_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20649_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__20654 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__20656 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__20655 = (function (p1__20650_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__20650_SHARP_);
});
return fexpr__20655(G__20656);
})()),cljs.core.set(b_idxs));
var fexpr__20653 = (function (p1__20651_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__20651_SHARP_);
});
return fexpr__20653(G__20654);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20652_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20652_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20657_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20657_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20658_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20658_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__20667 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__20669 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__20668 = (function (p1__20659_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__20659_SHARP_);
});
return fexpr__20668(G__20669);
})()),cljs.core.set(b_idxs));
var fexpr__20666 = (function (p1__20660_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__20660_SHARP_);
});
return fexpr__20666(G__20667);
})();
var vec__20663 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__20670,a_tuple){
var vec__20671 = p__20670;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20671,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20671,(1),null);
var vec__20674 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20674,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20674,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20663,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20663,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20661_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20661_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20662_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20662_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__20678 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20678,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20678,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20677_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__20677_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__20683 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20683,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20683,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20681_SHARP_){
return fluree.db.util.core.index_of(headers,p1__20681_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__20682_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__20682_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20686,filters,optional_QMARK_){
var map__20687 = p__20686;
var map__20687__$1 = (((((!((map__20687 == null))))?(((((map__20687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20687.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20687):map__20687);
var tuple_map = map__20687__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20687__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20687__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20687__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20689 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20689,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20689,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20692 = res;
var map__20692__$1 = (((((!((map__20692 == null))))?(((((map__20692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20692.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20692):map__20692);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20692__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20692__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_20749){
var state_val_20750 = (state_20749[(1)]);
if((state_val_20750 === (7))){
var inst_20723 = (state_20749[(7)]);
var inst_20721 = (state_20749[(2)]);
var inst_20722 = fluree.db.util.async.throw_err(inst_20721);
var inst_20723__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20722,(0),null);
var inst_20724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20722,(1),null);
var inst_20725 = (inst_20723__$1 == null);
var state_20749__$1 = (function (){var statearr_20751 = state_20749;
(statearr_20751[(7)] = inst_20723__$1);

(statearr_20751[(8)] = inst_20724);

return statearr_20751;
})();
if(cljs.core.truth_(inst_20725)){
var statearr_20752_20781 = state_20749__$1;
(statearr_20752_20781[(1)] = (8));

} else {
var statearr_20753_20782 = state_20749__$1;
(statearr_20753_20782[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (1))){
var inst_20701 = optional_clauses;
var inst_20702 = cljs.core.seq(inst_20701);
var inst_20703 = cljs.core.first(inst_20702);
var inst_20704 = cljs.core.next(inst_20702);
var inst_20705 = where_tuples;
var inst_20706 = inst_20701;
var inst_20707 = inst_20705;
var state_20749__$1 = (function (){var statearr_20754 = state_20749;
(statearr_20754[(9)] = inst_20707);

(statearr_20754[(10)] = inst_20704);

(statearr_20754[(11)] = inst_20703);

(statearr_20754[(12)] = inst_20706);

return statearr_20754;
})();
var statearr_20755_20783 = state_20749__$1;
(statearr_20755_20783[(2)] = null);

(statearr_20755_20783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (4))){
var inst_20713 = (state_20749[(13)]);
var inst_20707 = (state_20749[(9)]);
var inst_20714 = (state_20749[(14)]);
var inst_20719 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_20707,inst_20713,inst_20714,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_20707,inst_20713,inst_20714,true,fuel,max_fuel,opts));
var state_20749__$1 = state_20749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20749__$1,(7),inst_20719);
} else {
if((state_val_20750 === (15))){
var state_20749__$1 = state_20749;
var statearr_20756_20784 = state_20749__$1;
(statearr_20756_20784[(2)] = null);

(statearr_20756_20784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (13))){
var inst_20740 = (state_20749[(2)]);
var state_20749__$1 = state_20749;
var statearr_20757_20785 = state_20749__$1;
(statearr_20757_20785[(2)] = inst_20740);

(statearr_20757_20785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (6))){
var inst_20745 = (state_20749[(2)]);
var state_20749__$1 = state_20749;
var statearr_20758_20786 = state_20749__$1;
(statearr_20758_20786[(2)] = inst_20745);

(statearr_20758_20786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (3))){
var inst_20747 = (state_20749[(2)]);
var state_20749__$1 = state_20749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20749__$1,inst_20747);
} else {
if((state_val_20750 === (12))){
var state_20749__$1 = state_20749;
var statearr_20759_20787 = state_20749__$1;
(statearr_20759_20787[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (2))){
var inst_20713 = (state_20749[(13)]);
var inst_20706 = (state_20749[(12)]);
var inst_20712 = cljs.core.seq(inst_20706);
var inst_20713__$1 = cljs.core.first(inst_20712);
var inst_20714 = cljs.core.next(inst_20712);
var state_20749__$1 = (function (){var statearr_20761 = state_20749;
(statearr_20761[(13)] = inst_20713__$1);

(statearr_20761[(14)] = inst_20714);

return statearr_20761;
})();
if(cljs.core.truth_(inst_20713__$1)){
var statearr_20762_20788 = state_20749__$1;
(statearr_20762_20788[(1)] = (4));

} else {
var statearr_20763_20789 = state_20749__$1;
(statearr_20763_20789[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (11))){
var inst_20723 = (state_20749[(7)]);
var inst_20724 = (state_20749[(8)]);
var inst_20706 = inst_20724;
var inst_20707 = inst_20723;
var state_20749__$1 = (function (){var statearr_20764 = state_20749;
(statearr_20764[(9)] = inst_20707);

(statearr_20764[(12)] = inst_20706);

return statearr_20764;
})();
var statearr_20765_20790 = state_20749__$1;
(statearr_20765_20790[(2)] = null);

(statearr_20765_20790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (9))){
var inst_20713 = (state_20749[(13)]);
var inst_20729 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_20713);
var state_20749__$1 = state_20749;
if(cljs.core.truth_(inst_20729)){
var statearr_20766_20791 = state_20749__$1;
(statearr_20766_20791[(1)] = (11));

} else {
var statearr_20767_20792 = state_20749__$1;
(statearr_20767_20792[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (5))){
var inst_20707 = (state_20749[(9)]);
var state_20749__$1 = state_20749;
var statearr_20768_20793 = state_20749__$1;
(statearr_20768_20793[(2)] = inst_20707);

(statearr_20768_20793[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (14))){
var inst_20707 = (state_20749[(9)]);
var inst_20723 = (state_20749[(7)]);
var inst_20724 = (state_20749[(8)]);
var inst_20734 = fluree.db.query.analytical.left_outer_join(inst_20707,inst_20723);
var inst_20706 = inst_20724;
var inst_20707__$1 = inst_20734;
var state_20749__$1 = (function (){var statearr_20769 = state_20749;
(statearr_20769[(9)] = inst_20707__$1);

(statearr_20769[(12)] = inst_20706);

return statearr_20769;
})();
var statearr_20770_20794 = state_20749__$1;
(statearr_20770_20794[(2)] = null);

(statearr_20770_20794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (16))){
var inst_20738 = (state_20749[(2)]);
var state_20749__$1 = state_20749;
var statearr_20772_20795 = state_20749__$1;
(statearr_20772_20795[(2)] = inst_20738);

(statearr_20772_20795[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (10))){
var inst_20742 = (state_20749[(2)]);
var state_20749__$1 = state_20749;
var statearr_20773_20796 = state_20749__$1;
(statearr_20773_20796[(2)] = inst_20742);

(statearr_20773_20796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20750 === (8))){
var inst_20707 = (state_20749[(9)]);
var inst_20724 = (state_20749[(8)]);
var tmp20771 = inst_20707;
var inst_20706 = inst_20724;
var inst_20707__$1 = tmp20771;
var state_20749__$1 = (function (){var statearr_20774 = state_20749;
(statearr_20774[(9)] = inst_20707__$1);

(statearr_20774[(12)] = inst_20706);

return statearr_20774;
})();
var statearr_20775_20797 = state_20749__$1;
(statearr_20775_20797[(2)] = null);

(statearr_20775_20797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0 = (function (){
var statearr_20776 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20776[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__);

(statearr_20776[(1)] = (1));

return statearr_20776;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1 = (function (state_20749){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_20749);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e20777){var ex__2417__auto__ = e20777;
var statearr_20778_20798 = state_20749;
(statearr_20778_20798[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_20749[(4)]))){
var statearr_20779_20799 = state_20749;
(statearr_20779_20799[(1)] = cljs.core.first((state_20749[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20800 = state_20749;
state_20749 = G__20800;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__ = function(state_20749){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1.call(this,state_20749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_20780 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_20780[(6)] = c__2436__auto__);

return statearr_20780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20802){
var vec__20803 = p__20802;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20803,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20803,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20801_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20801_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__20807,p__20808,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__20809 = p__20807;
var map__20809__$1 = (((((!((map__20809 == null))))?(((((map__20809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20809):map__20809);
var q_map = map__20809__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20809__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__20810 = p__20808;
var map__20810__$1 = (((((!((map__20810 == null))))?(((((map__20810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20810.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20810):map__20810);
var res = map__20810__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20810__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21019){
var state_val_21020 = (state_21019[(1)]);
if((state_val_21020 === (7))){
var inst_20917 = cljs.core.count(clause);
var inst_20918 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20917);
var inst_20919 = cljs.core.second(clause);
var inst_20920 = clojure.string.starts_with_QMARK_(inst_20919,"fullText:");
var inst_20921 = ((inst_20918) && (inst_20920));
var state_21019__$1 = state_21019;
if(cljs.core.truth_(inst_20921)){
var statearr_21021_21116 = state_21019__$1;
(statearr_21021_21116[(1)] = (31));

} else {
var statearr_21022_21117 = state_21019__$1;
(statearr_21022_21117[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (59))){
var inst_20988 = (state_21019[(7)]);
var inst_20991 = (state_21019[(2)]);
var inst_20992 = fluree.db.util.async.throw_err(inst_20991);
var inst_20993 = [inst_20992,r];
var inst_20994 = (new cljs.core.PersistentVector(null,2,(5),inst_20988,inst_20993,null));
var state_21019__$1 = state_21019;
var statearr_21023_21118 = state_21019__$1;
(statearr_21023_21118[(2)] = inst_20994);

(statearr_21023_21118[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (20))){
var inst_20881 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21024_21119 = state_21019__$1;
(statearr_21024_21119[(2)] = inst_20881);

(statearr_21024_21119[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (58))){
var inst_20997 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21025_21120 = state_21019__$1;
(statearr_21025_21120[(2)] = inst_20997);

(statearr_21025_21120[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (27))){
var inst_20911 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21026_21121 = state_21019__$1;
(statearr_21026_21121[(2)] = inst_20911);

(statearr_21026_21121[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (1))){
var state_21019__$1 = state_21019;
var statearr_21027_21122 = state_21019__$1;
(statearr_21027_21122[(2)] = null);

(statearr_21027_21122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (24))){
var inst_20875 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21028_21123 = state_21019__$1;
(statearr_21028_21123[(2)] = inst_20875);

(statearr_21028_21123[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (55))){
var inst_20999 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21029_21124 = state_21019__$1;
(statearr_21029_21124[(2)] = inst_20999);

(statearr_21029_21124[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (39))){
var inst_20953 = cljs.core.count(clause);
var inst_20954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_20953);
var state_21019__$1 = state_21019;
if(inst_20954){
var statearr_21030_21125 = state_21019__$1;
(statearr_21030_21125[(1)] = (42));

} else {
var statearr_21031_21126 = state_21019__$1;
(statearr_21031_21126[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (46))){
var state_21019__$1 = state_21019;
var statearr_21032_21127 = state_21019__$1;
(statearr_21032_21127[(2)] = null);

(statearr_21032_21127[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (4))){
var inst_20813 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21033_21128 = state_21019__$1;
(statearr_21033_21128[(2)] = inst_20813);

(statearr_21033_21128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (54))){
var state_21019__$1 = state_21019;
var statearr_21034_21129 = state_21019__$1;
(statearr_21034_21129[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (15))){
var inst_20913 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21036_21130 = state_21019__$1;
(statearr_21036_21130[(2)] = inst_20913);

(statearr_21036_21130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (48))){
var inst_20970 = (state_21019[(8)]);
var inst_20968 = (state_21019[(2)]);
var inst_20969 = fluree.db.util.async.throw_err(inst_20968);
var inst_20970__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20969,(0),null);
var inst_20971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20969,(1),null);
var inst_20972 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20970__$1);
var state_21019__$1 = (function (){var statearr_21037 = state_21019;
(statearr_21037[(9)] = inst_20971);

(statearr_21037[(8)] = inst_20970__$1);

return statearr_21037;
})();
if(inst_20972){
var statearr_21038_21131 = state_21019__$1;
(statearr_21038_21131[(1)] = (49));

} else {
var statearr_21039_21132 = state_21019__$1;
(statearr_21039_21132[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (50))){
var inst_20971 = (state_21019[(9)]);
var inst_20979 = cljs.core.second(inst_20971);
var inst_20980 = clojure.string.starts_with_QMARK_(inst_20979,"fullText:");
var state_21019__$1 = state_21019;
if(inst_20980){
var statearr_21040_21133 = state_21019__$1;
(statearr_21040_21133[(1)] = (53));

} else {
var statearr_21041_21134 = state_21019__$1;
(statearr_21041_21134[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (21))){
var inst_20858 = (state_21019[(10)]);
var inst_20822 = (state_21019[(11)]);
var inst_20859 = (state_21019[(12)]);
var inst_20851 = (state_21019[(13)]);
var inst_20847 = (state_21019[(14)]);
var inst_20826 = (state_21019[(15)]);
var inst_20852 = (state_21019[(16)]);
var inst_20850 = (state_21019[(17)]);
var inst_20849 = (state_21019[(18)]);
var inst_20863 = (state_21019[(2)]);
var inst_20864 = fluree.db.util.async.throw_err(inst_20863);
var inst_20865 = (function (){var new_res = inst_20864;
var pred__20823 = inst_20826;
var rest = inst_20859;
var tuples = inst_20852;
var vec__20844 = inst_20847;
var first__20856 = inst_20858;
var first__20846 = inst_20849;
var vec__20854 = inst_20851;
var seq__20845 = inst_20850;
var seq__20855 = inst_20859;
var segment_type = inst_20822;
var expr__20824 = inst_20822;
var G__20843 = inst_20851;
var clause_group = inst_20858;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_20866 = cljs.core.keys(vars);
var inst_20867 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20865,inst_20864,inst_20866);
var inst_20868 = fluree.db.query.analytical.res_absorb_vars(inst_20867);
var state_21019__$1 = (function (){var statearr_21042 = state_21019;
(statearr_21042[(19)] = inst_20868);

return statearr_21042;
})();
if(cljs.core.truth_(inst_20852)){
var statearr_21043_21135 = state_21019__$1;
(statearr_21043_21135[(1)] = (22));

} else {
var statearr_21044_21136 = state_21019__$1;
(statearr_21044_21136[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (31))){
var inst_20923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20924 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_20925 = [inst_20924,r];
var inst_20926 = (new cljs.core.PersistentVector(null,2,(5),inst_20923,inst_20925,null));
var state_21019__$1 = state_21019;
var statearr_21045_21137 = state_21019__$1;
(statearr_21045_21137[(2)] = inst_20926);

(statearr_21045_21137[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (32))){
var inst_20928 = cljs.core.count(clause);
var inst_20929 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20928);
var inst_20930 = cljs.core.second(clause);
var inst_20931 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20930,"rdf:type");
var inst_20932 = ((inst_20929) && (inst_20931));
var state_21019__$1 = state_21019;
if(cljs.core.truth_(inst_20932)){
var statearr_21046_21138 = state_21019__$1;
(statearr_21046_21138[(1)] = (34));

} else {
var statearr_21047_21139 = state_21019__$1;
(statearr_21047_21139[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (40))){
var inst_21008 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21048_21140 = state_21019__$1;
(statearr_21048_21140[(2)] = inst_21008);

(statearr_21048_21140[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (56))){
var inst_20971 = (state_21019[(9)]);
var inst_20970 = (state_21019[(8)]);
var inst_20988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20989 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_20970,res,inst_20971,fuel,max_fuel);
var state_21019__$1 = (function (){var statearr_21049 = state_21019;
(statearr_21049[(7)] = inst_20988);

return statearr_21049;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(59),inst_20989);
} else {
if((state_val_21020 === (33))){
var inst_21012 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21050_21141 = state_21019__$1;
(statearr_21050_21141[(2)] = inst_21012);

(statearr_21050_21141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (13))){
var inst_20847 = (state_21019[(14)]);
var inst_20847__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20848 = cljs.core.seq(inst_20847__$1);
var inst_20849 = cljs.core.first(inst_20848);
var inst_20850 = cljs.core.next(inst_20848);
var inst_20851 = inst_20847__$1;
var inst_20852 = null;
var state_21019__$1 = (function (){var statearr_21051 = state_21019;
(statearr_21051[(13)] = inst_20851);

(statearr_21051[(14)] = inst_20847__$1);

(statearr_21051[(16)] = inst_20852);

(statearr_21051[(17)] = inst_20850);

(statearr_21051[(18)] = inst_20849);

return statearr_21051;
})();
var statearr_21052_21142 = state_21019__$1;
(statearr_21052_21142[(2)] = null);

(statearr_21052_21142[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (22))){
var inst_20859 = (state_21019[(12)]);
var inst_20868 = (state_21019[(19)]);
var inst_20852 = (state_21019[(16)]);
var inst_20870 = fluree.db.query.analytical.outer_union(inst_20852,inst_20868);
var inst_20851 = inst_20859;
var inst_20852__$1 = inst_20870;
var state_21019__$1 = (function (){var statearr_21053 = state_21019;
(statearr_21053[(13)] = inst_20851);

(statearr_21053[(16)] = inst_20852__$1);

return statearr_21053;
})();
var statearr_21054_21143 = state_21019__$1;
(statearr_21054_21143[(2)] = null);

(statearr_21054_21143[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (36))){
var inst_21010 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21055_21144 = state_21019__$1;
(statearr_21055_21144[(2)] = inst_21010);

(statearr_21055_21144[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (41))){
var inst_20945 = (state_21019[(20)]);
var inst_20948 = (state_21019[(2)]);
var inst_20949 = fluree.db.util.async.throw_err(inst_20948);
var inst_20950 = [inst_20949,r];
var inst_20951 = (new cljs.core.PersistentVector(null,2,(5),inst_20945,inst_20950,null));
var state_21019__$1 = state_21019;
var statearr_21056_21145 = state_21019__$1;
(statearr_21056_21145[(2)] = inst_20951);

(statearr_21056_21145[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (43))){
var state_21019__$1 = state_21019;
var statearr_21057_21146 = state_21019__$1;
(statearr_21057_21146[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (29))){
var inst_20822 = (state_21019[(11)]);
var inst_20905 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20822)].join('');
var inst_20906 = (new Error(inst_20905));
var inst_20907 = (function(){throw inst_20906})();
var state_21019__$1 = state_21019;
var statearr_21059_21147 = state_21019__$1;
(statearr_21059_21147[(2)] = inst_20907);

(statearr_21059_21147[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (44))){
var inst_21006 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21060_21148 = state_21019__$1;
(statearr_21060_21148[(2)] = inst_21006);

(statearr_21060_21148[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (6))){
var inst_20822 = (state_21019[(11)]);
var inst_20826 = (state_21019[(15)]);
var inst_20821 = cljs.core.keys(clause);
var inst_20822__$1 = cljs.core.first(inst_20821);
var inst_20826__$1 = cljs.core._EQ_;
var inst_20827 = (function (){var G__21061 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21062 = inst_20822__$1;
return (inst_20826__$1.cljs$core$IFn$_invoke$arity$2 ? inst_20826__$1.cljs$core$IFn$_invoke$arity$2(G__21061,G__21062) : inst_20826__$1.call(null,G__21061,G__21062));
})();
var state_21019__$1 = (function (){var statearr_21063 = state_21019;
(statearr_21063[(11)] = inst_20822__$1);

(statearr_21063[(15)] = inst_20826__$1);

return statearr_21063;
})();
if(cljs.core.truth_(inst_20827)){
var statearr_21064_21149 = state_21019__$1;
(statearr_21064_21149[(1)] = (9));

} else {
var statearr_21065_21150 = state_21019__$1;
(statearr_21065_21150[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (28))){
var inst_20899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20900 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20901 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_20900,optional_QMARK_);
var inst_20902 = [inst_20901,r];
var inst_20903 = (new cljs.core.PersistentVector(null,2,(5),inst_20899,inst_20902,null));
var state_21019__$1 = state_21019;
var statearr_21066_21151 = state_21019__$1;
(statearr_21066_21151[(2)] = inst_20903);

(statearr_21066_21151[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (51))){
var inst_21001 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21067_21152 = state_21019__$1;
(statearr_21067_21152[(2)] = inst_21001);

(statearr_21067_21152[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (25))){
var inst_20822 = (state_21019[(11)]);
var inst_20826 = (state_21019[(15)]);
var inst_20887 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20888 = (function (){var segment_type = inst_20822;
var pred__20823 = inst_20826;
var expr__20824 = inst_20822;
var bindings = inst_20887;
return (function (p1__20806_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__20806_SHARP_);
});
})();
var inst_20889 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20888,inst_20887);
var inst_20890 = cljs.core.PersistentHashMap.EMPTY;
var inst_20891 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20890,inst_20889);
var inst_20892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20893 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20891);
var inst_20894 = [inst_20893,r];
var inst_20895 = (new cljs.core.PersistentVector(null,2,(5),inst_20892,inst_20894,null));
var state_21019__$1 = state_21019;
var statearr_21068_21153 = state_21019__$1;
(statearr_21068_21153[(2)] = inst_20895);

(statearr_21068_21153[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (34))){
var inst_20934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20935 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21019__$1 = (function (){var statearr_21069 = state_21019;
(statearr_21069[(21)] = inst_20934);

return statearr_21069;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(37),inst_20935);
} else {
if((state_val_21020 === (17))){
var inst_20883 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21070_21154 = state_21019__$1;
(statearr_21070_21154[(2)] = inst_20883);

(statearr_21070_21154[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (3))){
var inst_21017 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21019__$1,inst_21017);
} else {
if((state_val_21020 === (12))){
var inst_20829 = (state_21019[(22)]);
var inst_20833 = (state_21019[(2)]);
var inst_20834 = fluree.db.util.async.throw_err(inst_20833);
var inst_20835 = [inst_20834,r];
var inst_20836 = (new cljs.core.PersistentVector(null,2,(5),inst_20829,inst_20835,null));
var state_21019__$1 = state_21019;
var statearr_21071_21155 = state_21019__$1;
(statearr_21071_21155[(2)] = inst_20836);

(statearr_21071_21155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (2))){
var _ = (function (){var statearr_21072 = state_21019;
(statearr_21072[(4)] = cljs.core.cons((5),(state_21019[(4)])));

return statearr_21072;
})();
var inst_20819 = cljs.core.map_QMARK_(clause);
var state_21019__$1 = state_21019;
if(inst_20819){
var statearr_21073_21156 = state_21019__$1;
(statearr_21073_21156[(1)] = (6));

} else {
var statearr_21074_21157 = state_21019__$1;
(statearr_21074_21157[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (23))){
var inst_20859 = (state_21019[(12)]);
var inst_20868 = (state_21019[(19)]);
var inst_20851 = inst_20859;
var inst_20852 = inst_20868;
var state_21019__$1 = (function (){var statearr_21075 = state_21019;
(statearr_21075[(13)] = inst_20851);

(statearr_21075[(16)] = inst_20852);

return statearr_21075;
})();
var statearr_21076_21158 = state_21019__$1;
(statearr_21076_21158[(2)] = null);

(statearr_21076_21158[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (47))){
var inst_21004 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21077_21159 = state_21019__$1;
(statearr_21077_21159[(2)] = inst_21004);

(statearr_21077_21159[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (35))){
var inst_20942 = cljs.core.count(clause);
var inst_20943 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_20942);
var state_21019__$1 = state_21019;
if(inst_20943){
var statearr_21078_21160 = state_21019__$1;
(statearr_21078_21160[(1)] = (38));

} else {
var statearr_21079_21161 = state_21019__$1;
(statearr_21079_21161[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (19))){
var inst_20852 = (state_21019[(16)]);
var inst_20877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20878 = [inst_20852,r];
var inst_20879 = (new cljs.core.PersistentVector(null,2,(5),inst_20877,inst_20878,null));
var state_21019__$1 = state_21019;
var statearr_21080_21162 = state_21019__$1;
(statearr_21080_21162[(2)] = inst_20879);

(statearr_21080_21162[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (57))){
var state_21019__$1 = state_21019;
var statearr_21081_21163 = state_21019__$1;
(statearr_21081_21163[(2)] = null);

(statearr_21081_21163[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (11))){
var inst_20915 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21083_21164 = state_21019__$1;
(statearr_21083_21164[(2)] = inst_20915);

(statearr_21083_21164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (9))){
var inst_20829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20830 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_20831 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_20830,res,fuel,max_fuel,opts);
var state_21019__$1 = (function (){var statearr_21084 = state_21019;
(statearr_21084[(22)] = inst_20829);

return statearr_21084;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(12),inst_20831);
} else {
if((state_val_21020 === (5))){
var _ = (function (){var statearr_21085 = state_21019;
(statearr_21085[(4)] = cljs.core.rest((state_21019[(4)])));

return statearr_21085;
})();
var state_21019__$1 = state_21019;
var ex21082 = (state_21019__$1[(2)]);
var statearr_21086_21165 = state_21019__$1;
(statearr_21086_21165[(5)] = ex21082);


if((ex21082 instanceof Error)){
var statearr_21087_21166 = state_21019__$1;
(statearr_21087_21166[(1)] = (4));

(statearr_21087_21166[(5)] = null);

} else {
throw ex21082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (14))){
var inst_20822 = (state_21019[(11)]);
var inst_20826 = (state_21019[(15)]);
var inst_20885 = (function (){var G__21088 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21089 = inst_20822;
return (inst_20826.cljs$core$IFn$_invoke$arity$2 ? inst_20826.cljs$core$IFn$_invoke$arity$2(G__21088,G__21089) : inst_20826.call(null,G__21088,G__21089));
})();
var state_21019__$1 = state_21019;
if(cljs.core.truth_(inst_20885)){
var statearr_21090_21167 = state_21019__$1;
(statearr_21090_21167[(1)] = (25));

} else {
var statearr_21091_21168 = state_21019__$1;
(statearr_21091_21168[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (45))){
var inst_20966 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(48),inst_20966);
} else {
if((state_val_21020 === (53))){
var inst_20971 = (state_21019[(9)]);
var inst_20970 = (state_21019[(8)]);
var inst_20982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20983 = fluree.db.query.analytical.full_text__GT_tuples(inst_20970,res,inst_20971);
var inst_20984 = [inst_20983,r];
var inst_20985 = (new cljs.core.PersistentVector(null,2,(5),inst_20982,inst_20984,null));
var state_21019__$1 = state_21019;
var statearr_21092_21169 = state_21019__$1;
(statearr_21092_21169[(2)] = inst_20985);

(statearr_21092_21169[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (26))){
var inst_20822 = (state_21019[(11)]);
var inst_20826 = (state_21019[(15)]);
var inst_20897 = (function (){var G__21093 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21094 = inst_20822;
return (inst_20826.cljs$core$IFn$_invoke$arity$2 ? inst_20826.cljs$core$IFn$_invoke$arity$2(G__21093,G__21094) : inst_20826.call(null,G__21093,G__21094));
})();
var state_21019__$1 = state_21019;
if(cljs.core.truth_(inst_20897)){
var statearr_21095_21170 = state_21019__$1;
(statearr_21095_21170[(1)] = (28));

} else {
var statearr_21096_21171 = state_21019__$1;
(statearr_21096_21171[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (16))){
var inst_20858 = (state_21019[(10)]);
var inst_20851 = (state_21019[(13)]);
var inst_20857 = cljs.core.seq(inst_20851);
var inst_20858__$1 = cljs.core.first(inst_20857);
var inst_20859 = cljs.core.next(inst_20857);
var state_21019__$1 = (function (){var statearr_21097 = state_21019;
(statearr_21097[(10)] = inst_20858__$1);

(statearr_21097[(12)] = inst_20859);

return statearr_21097;
})();
if(cljs.core.truth_(inst_20858__$1)){
var statearr_21098_21172 = state_21019__$1;
(statearr_21098_21172[(1)] = (18));

} else {
var statearr_21099_21173 = state_21019__$1;
(statearr_21099_21173[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (38))){
var inst_20945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20946 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21019__$1 = (function (){var statearr_21100 = state_21019;
(statearr_21100[(20)] = inst_20945);

return statearr_21100;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(41),inst_20946);
} else {
if((state_val_21020 === (30))){
var inst_20909 = (state_21019[(2)]);
var state_21019__$1 = state_21019;
var statearr_21101_21174 = state_21019__$1;
(statearr_21101_21174[(2)] = inst_20909);

(statearr_21101_21174[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (10))){
var inst_20822 = (state_21019[(11)]);
var inst_20826 = (state_21019[(15)]);
var inst_20838 = (function (){var G__21102 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21103 = inst_20822;
return (inst_20826.cljs$core$IFn$_invoke$arity$2 ? inst_20826.cljs$core$IFn$_invoke$arity$2(G__21102,G__21103) : inst_20826.call(null,G__21102,G__21103));
})();
var state_21019__$1 = state_21019;
if(cljs.core.truth_(inst_20838)){
var statearr_21104_21175 = state_21019__$1;
(statearr_21104_21175[(1)] = (13));

} else {
var statearr_21105_21176 = state_21019__$1;
(statearr_21105_21176[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (18))){
var inst_20858 = (state_21019[(10)]);
var inst_20861 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_20858,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_20858,q_map,vars,fuel,max_fuel,opts));
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(21),inst_20861);
} else {
if((state_val_21020 === (52))){
var inst_20976 = (state_21019[(2)]);
var inst_20977 = fluree.db.util.async.throw_err(inst_20976);
var state_21019__$1 = state_21019;
var statearr_21106_21177 = state_21019__$1;
(statearr_21106_21177[(2)] = inst_20977);

(statearr_21106_21177[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (42))){
var inst_20956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20957 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_20958 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_20957);
var inst_20959 = [inst_20958,r];
var inst_20960 = (new cljs.core.PersistentVector(null,2,(5),inst_20956,inst_20959,null));
var state_21019__$1 = state_21019;
var statearr_21107_21178 = state_21019__$1;
(statearr_21107_21178[(2)] = inst_20960);

(statearr_21107_21178[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (37))){
var inst_20934 = (state_21019[(21)]);
var inst_20937 = (state_21019[(2)]);
var inst_20938 = fluree.db.util.async.throw_err(inst_20937);
var inst_20939 = [inst_20938,r];
var inst_20940 = (new cljs.core.PersistentVector(null,2,(5),inst_20934,inst_20939,null));
var state_21019__$1 = state_21019;
var statearr_21108_21179 = state_21019__$1;
(statearr_21108_21179[(2)] = inst_20940);

(statearr_21108_21179[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (8))){
var inst_21014 = (state_21019[(2)]);
var _ = (function (){var statearr_21109 = state_21019;
(statearr_21109[(4)] = cljs.core.rest((state_21019[(4)])));

return statearr_21109;
})();
var state_21019__$1 = state_21019;
var statearr_21110_21180 = state_21019__$1;
(statearr_21110_21180[(2)] = inst_21014);

(statearr_21110_21180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21020 === (49))){
var inst_20971 = (state_21019[(9)]);
var inst_20974 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_20971,r,res,optional_QMARK_,fuel,max_fuel);
var state_21019__$1 = state_21019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21019__$1,(52),inst_20974);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_21111 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21111[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__);

(statearr_21111[(1)] = (1));

return statearr_21111;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1 = (function (state_21019){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21019);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21112){var ex__2417__auto__ = e21112;
var statearr_21113_21181 = state_21019;
(statearr_21113_21181[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21019[(4)]))){
var statearr_21114_21182 = state_21019;
(statearr_21114_21182[(1)] = cljs.core.first((state_21019[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21183 = state_21019;
state_21019 = G__21183;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__ = function(state_21019){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1.call(this,state_21019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21115 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21115[(6)] = c__2436__auto__);

return statearr_21115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21185 = arguments.length;
switch (G__21185) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21265){
var state_val_21266 = (state_21265[(1)]);
if((state_val_21266 === (7))){
var inst_21260 = (state_21265[(2)]);
var _ = (function (){var statearr_21267 = state_21265;
(statearr_21267[(4)] = cljs.core.rest((state_21265[(4)])));

return statearr_21267;
})();
var state_21265__$1 = state_21265;
var statearr_21268_21316 = state_21265__$1;
(statearr_21268_21316[(2)] = inst_21260);

(statearr_21268_21316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (20))){
var inst_21225 = (state_21265[(7)]);
var inst_21237 = (state_21265[(2)]);
var inst_21207 = inst_21225;
var inst_21208 = inst_21237;
var state_21265__$1 = (function (){var statearr_21269 = state_21265;
(statearr_21269[(8)] = inst_21207);

(statearr_21269[(9)] = inst_21208);

return statearr_21269;
})();
var statearr_21270_21317 = state_21265__$1;
(statearr_21270_21317[(2)] = null);

(statearr_21270_21317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (1))){
var state_21265__$1 = state_21265;
var statearr_21271_21318 = state_21265__$1;
(statearr_21271_21318[(2)] = null);

(statearr_21271_21318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (24))){
var inst_21225 = (state_21265[(7)]);
var inst_21208 = (state_21265[(9)]);
var inst_21224 = (state_21265[(10)]);
var inst_21245 = fluree.db.query.analytical.inner_join(inst_21208,inst_21224);
var inst_21207 = inst_21225;
var inst_21208__$1 = inst_21245;
var state_21265__$1 = (function (){var statearr_21272 = state_21265;
(statearr_21272[(8)] = inst_21207);

(statearr_21272[(9)] = inst_21208__$1);

return statearr_21272;
})();
var statearr_21273_21319 = state_21265__$1;
(statearr_21273_21319[(2)] = null);

(statearr_21273_21319[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (4))){
var inst_21186 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21275_21320 = state_21265__$1;
(statearr_21275_21320[(2)] = inst_21186);

(statearr_21275_21320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (15))){
var inst_21224 = (state_21265[(10)]);
var state_21265__$1 = state_21265;
if(cljs.core.truth_(inst_21224)){
var statearr_21276_21321 = state_21265__$1;
(statearr_21276_21321[(1)] = (18));

} else {
var statearr_21277_21322 = state_21265__$1;
(statearr_21277_21322[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (21))){
var inst_21225 = (state_21265[(7)]);
var inst_21208 = (state_21265[(9)]);
var tmp21274 = inst_21208;
var inst_21207 = inst_21225;
var inst_21208__$1 = tmp21274;
var state_21265__$1 = (function (){var statearr_21278 = state_21265;
(statearr_21278[(8)] = inst_21207);

(statearr_21278[(9)] = inst_21208__$1);

return statearr_21278;
})();
var statearr_21279_21323 = state_21265__$1;
(statearr_21279_21323[(2)] = null);

(statearr_21279_21323[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (13))){
var inst_21208 = (state_21265[(9)]);
var inst_21231 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21208,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21232 = cljs.core.empty_QMARK_(inst_21231);
var state_21265__$1 = state_21265;
if(inst_21232){
var statearr_21280_21324 = state_21265__$1;
(statearr_21280_21324[(1)] = (15));

} else {
var statearr_21281_21325 = state_21265__$1;
(statearr_21281_21325[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (22))){
var state_21265__$1 = state_21265;
var statearr_21282_21326 = state_21265__$1;
(statearr_21282_21326[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (6))){
var inst_21214 = (state_21265[(11)]);
var inst_21207 = (state_21265[(8)]);
var inst_21213 = cljs.core.seq(inst_21207);
var inst_21214__$1 = cljs.core.first(inst_21213);
var inst_21215 = cljs.core.next(inst_21213);
var state_21265__$1 = (function (){var statearr_21284 = state_21265;
(statearr_21284[(11)] = inst_21214__$1);

(statearr_21284[(12)] = inst_21215);

return statearr_21284;
})();
if(cljs.core.truth_(inst_21214__$1)){
var statearr_21285_21327 = state_21265__$1;
(statearr_21285_21327[(1)] = (8));

} else {
var statearr_21286_21328 = state_21265__$1;
(statearr_21286_21328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (25))){
var state_21265__$1 = state_21265;
var statearr_21287_21329 = state_21265__$1;
(statearr_21287_21329[(2)] = null);

(statearr_21287_21329[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (17))){
var inst_21253 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21288_21330 = state_21265__$1;
(statearr_21288_21330[(2)] = inst_21253);

(statearr_21288_21330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (3))){
var inst_21263 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21265__$1,inst_21263);
} else {
if((state_val_21266 === (12))){
var inst_21225 = (state_21265[(7)]);
var inst_21224 = (state_21265[(10)]);
var inst_21207 = inst_21225;
var inst_21208 = inst_21224;
var state_21265__$1 = (function (){var statearr_21289 = state_21265;
(statearr_21289[(8)] = inst_21207);

(statearr_21289[(9)] = inst_21208);

return statearr_21289;
})();
var statearr_21290_21331 = state_21265__$1;
(statearr_21290_21331[(2)] = null);

(statearr_21290_21331[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (2))){
var _ = (function (){var statearr_21291 = state_21265;
(statearr_21291[(4)] = cljs.core.cons((5),(state_21265[(4)])));

return statearr_21291;
})();
var inst_21199 = where;
var inst_21200 = cljs.core.seq(inst_21199);
var inst_21201 = cljs.core.first(inst_21200);
var inst_21202 = cljs.core.next(inst_21200);
var inst_21203 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21204 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21205 = [inst_21204];
var inst_21206 = cljs.core.PersistentHashMap.fromArrays(inst_21203,inst_21205);
var inst_21207 = inst_21199;
var inst_21208 = inst_21206;
var state_21265__$1 = (function (){var statearr_21292 = state_21265;
(statearr_21292[(13)] = inst_21201);

(statearr_21292[(8)] = inst_21207);

(statearr_21292[(9)] = inst_21208);

(statearr_21292[(14)] = inst_21202);

return statearr_21292;
})();
var statearr_21293_21332 = state_21265__$1;
(statearr_21293_21332[(2)] = null);

(statearr_21293_21332[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (23))){
var inst_21251 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21294_21333 = state_21265__$1;
(statearr_21294_21333[(2)] = inst_21251);

(statearr_21294_21333[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (19))){
var inst_21208 = (state_21265[(9)]);
var state_21265__$1 = state_21265;
var statearr_21295_21334 = state_21265__$1;
(statearr_21295_21334[(2)] = inst_21208);

(statearr_21295_21334[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (11))){
var inst_21214 = (state_21265[(11)]);
var inst_21222 = (state_21265[(2)]);
var inst_21223 = fluree.db.util.async.throw_err(inst_21222);
var inst_21224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21223,(0),null);
var inst_21225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21223,(1),null);
var inst_21226 = cljs.core.count(inst_21214);
var inst_21227 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21226);
var state_21265__$1 = (function (){var statearr_21297 = state_21265;
(statearr_21297[(7)] = inst_21225);

(statearr_21297[(10)] = inst_21224);

return statearr_21297;
})();
if(inst_21227){
var statearr_21298_21335 = state_21265__$1;
(statearr_21298_21335[(1)] = (12));

} else {
var statearr_21299_21336 = state_21265__$1;
(statearr_21299_21336[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (9))){
var inst_21208 = (state_21265[(9)]);
var state_21265__$1 = state_21265;
var statearr_21300_21337 = state_21265__$1;
(statearr_21300_21337[(2)] = inst_21208);

(statearr_21300_21337[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (5))){
var _ = (function (){var statearr_21301 = state_21265;
(statearr_21301[(4)] = cljs.core.rest((state_21265[(4)])));

return statearr_21301;
})();
var state_21265__$1 = state_21265;
var ex21296 = (state_21265__$1[(2)]);
var statearr_21302_21338 = state_21265__$1;
(statearr_21302_21338[(5)] = ex21296);


if((ex21296 instanceof Error)){
var statearr_21303_21339 = state_21265__$1;
(statearr_21303_21339[(1)] = (4));

(statearr_21303_21339[(5)] = null);

} else {
throw ex21296;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (14))){
var inst_21255 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21304_21340 = state_21265__$1;
(statearr_21304_21340[(2)] = inst_21255);

(statearr_21304_21340[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (26))){
var inst_21249 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21305_21341 = state_21265__$1;
(statearr_21305_21341[(2)] = inst_21249);

(statearr_21305_21341[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (16))){
var inst_21224 = (state_21265[(10)]);
var inst_21240 = (inst_21224 == null);
var state_21265__$1 = state_21265;
if(cljs.core.truth_(inst_21240)){
var statearr_21306_21342 = state_21265__$1;
(statearr_21306_21342[(1)] = (21));

} else {
var statearr_21307_21343 = state_21265__$1;
(statearr_21307_21343[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (10))){
var inst_21258 = (state_21265[(2)]);
var state_21265__$1 = state_21265;
var statearr_21308_21344 = state_21265__$1;
(statearr_21308_21344[(2)] = inst_21258);

(statearr_21308_21344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (18))){
var inst_21224 = (state_21265[(10)]);
var state_21265__$1 = state_21265;
var statearr_21309_21345 = state_21265__$1;
(statearr_21309_21345[(2)] = inst_21224);

(statearr_21309_21345[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21266 === (8))){
var inst_21214 = (state_21265[(11)]);
var inst_21208 = (state_21265[(9)]);
var inst_21215 = (state_21265[(12)]);
var inst_21220 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21208,inst_21214,inst_21215,false,fuel,max_fuel,opts);
var state_21265__$1 = state_21265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21265__$1,(11),inst_21220);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2414__auto__ = null;
var fluree$db$query$analytical$state_machine__2414__auto____0 = (function (){
var statearr_21310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21310[(0)] = fluree$db$query$analytical$state_machine__2414__auto__);

(statearr_21310[(1)] = (1));

return statearr_21310;
});
var fluree$db$query$analytical$state_machine__2414__auto____1 = (function (state_21265){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21265);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21311){var ex__2417__auto__ = e21311;
var statearr_21312_21346 = state_21265;
(statearr_21312_21346[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21265[(4)]))){
var statearr_21313_21347 = state_21265;
(statearr_21313_21347[(1)] = cljs.core.first((state_21265[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21348 = state_21265;
state_21265 = G__21348;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2414__auto__ = function(state_21265){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2414__auto____1.call(this,state_21265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2414__auto____0;
fluree$db$query$analytical$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2414__auto____1;
return fluree$db$query$analytical$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21314 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21314[(6)] = c__2436__auto__);

return statearr_21314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21403){
var state_val_21404 = (state_21403[(1)]);
if((state_val_21404 === (7))){
var state_21403__$1 = state_21403;
var statearr_21405_21443 = state_21403__$1;
(statearr_21405_21443[(2)] = false);

(statearr_21405_21443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (20))){
var inst_21381 = (state_21403[(7)]);
var inst_21393 = (state_21403[(8)]);
var inst_21395 = fluree.db.query.analytical.tuples__GT_filtered(inst_21393,inst_21381,null);
var state_21403__$1 = state_21403;
var statearr_21406_21444 = state_21403__$1;
(statearr_21406_21444[(2)] = inst_21395);

(statearr_21406_21444[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (1))){
var state_21403__$1 = state_21403;
var statearr_21407_21445 = state_21403__$1;
(statearr_21407_21445[(2)] = null);

(statearr_21407_21445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (4))){
var inst_21349 = (state_21403[(2)]);
var state_21403__$1 = state_21403;
var statearr_21408_21446 = state_21403__$1;
(statearr_21408_21446[(2)] = inst_21349);

(statearr_21408_21446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (15))){
var inst_21380 = (state_21403[(9)]);
var inst_21384 = (state_21403[(2)]);
var inst_21385 = fluree.db.util.async.throw_err(inst_21384);
var state_21403__$1 = (function (){var statearr_21409 = state_21403;
(statearr_21409[(10)] = inst_21385);

return statearr_21409;
})();
if(cljs.core.truth_(inst_21380)){
var statearr_21410_21447 = state_21403__$1;
(statearr_21410_21447[(1)] = (16));

} else {
var statearr_21411_21448 = state_21403__$1;
(statearr_21411_21448[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (21))){
var inst_21393 = (state_21403[(8)]);
var state_21403__$1 = state_21403;
var statearr_21412_21449 = state_21403__$1;
(statearr_21412_21449[(2)] = inst_21393);

(statearr_21412_21449[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (13))){
var inst_21356 = (state_21403[(11)]);
var state_21403__$1 = state_21403;
var statearr_21413_21450 = state_21403__$1;
(statearr_21413_21450[(2)] = inst_21356);

(statearr_21413_21450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (22))){
var inst_21398 = (state_21403[(2)]);
var _ = (function (){var statearr_21414 = state_21403;
(statearr_21414[(4)] = cljs.core.rest((state_21403[(4)])));

return statearr_21414;
})();
var state_21403__$1 = state_21403;
var statearr_21415_21451 = state_21403__$1;
(statearr_21415_21451[(2)] = inst_21398);

(statearr_21415_21451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (6))){
var inst_21356 = (state_21403[(11)]);
var inst_21361 = inst_21356.cljs$lang$protocol_mask$partition0$;
var inst_21362 = (inst_21361 & (64));
var inst_21363 = inst_21356.cljs$core$ISeq$;
var inst_21364 = (cljs.core.PROTOCOL_SENTINEL === inst_21363);
var inst_21365 = ((inst_21362) || (inst_21364));
var state_21403__$1 = state_21403;
if(cljs.core.truth_(inst_21365)){
var statearr_21416_21452 = state_21403__$1;
(statearr_21416_21452[(1)] = (9));

} else {
var statearr_21417_21453 = state_21403__$1;
(statearr_21417_21453[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (17))){
var inst_21385 = (state_21403[(10)]);
var state_21403__$1 = state_21403;
var statearr_21418_21454 = state_21403__$1;
(statearr_21418_21454[(2)] = inst_21385);

(statearr_21418_21454[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (3))){
var inst_21401 = (state_21403[(2)]);
var state_21403__$1 = state_21403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21403__$1,inst_21401);
} else {
if((state_val_21404 === (12))){
var inst_21356 = (state_21403[(11)]);
var inst_21374 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21356);
var state_21403__$1 = state_21403;
var statearr_21419_21455 = state_21403__$1;
(statearr_21419_21455[(2)] = inst_21374);

(statearr_21419_21455[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (2))){
var inst_21356 = (state_21403[(11)]);
var _ = (function (){var statearr_21420 = state_21403;
(statearr_21420[(4)] = cljs.core.cons((5),(state_21403[(4)])));

return statearr_21420;
})();
var inst_21356__$1 = q_map;
var inst_21358 = (inst_21356__$1 == null);
var inst_21359 = cljs.core.not(inst_21358);
var state_21403__$1 = (function (){var statearr_21421 = state_21403;
(statearr_21421[(11)] = inst_21356__$1);

return statearr_21421;
})();
if(inst_21359){
var statearr_21422_21456 = state_21403__$1;
(statearr_21422_21456[(1)] = (6));

} else {
var statearr_21423_21457 = state_21403__$1;
(statearr_21423_21457[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (19))){
var inst_21389 = (state_21403[(2)]);
var inst_21390 = fluree.db.util.async.throw_err(inst_21389);
var state_21403__$1 = state_21403;
var statearr_21424_21458 = state_21403__$1;
(statearr_21424_21458[(2)] = inst_21390);

(statearr_21424_21458[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (11))){
var inst_21369 = (state_21403[(2)]);
var state_21403__$1 = state_21403;
var statearr_21426_21459 = state_21403__$1;
(statearr_21426_21459[(2)] = inst_21369);

(statearr_21426_21459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (9))){
var state_21403__$1 = state_21403;
var statearr_21427_21460 = state_21403__$1;
(statearr_21427_21460[(2)] = true);

(statearr_21427_21460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (5))){
var _ = (function (){var statearr_21428 = state_21403;
(statearr_21428[(4)] = cljs.core.rest((state_21403[(4)])));

return statearr_21428;
})();
var state_21403__$1 = state_21403;
var ex21425 = (state_21403__$1[(2)]);
var statearr_21429_21461 = state_21403__$1;
(statearr_21429_21461[(5)] = ex21425);


if((ex21425 instanceof Error)){
var statearr_21430_21462 = state_21403__$1;
(statearr_21430_21462[(1)] = (4));

(statearr_21430_21462[(5)] = null);

} else {
throw ex21425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (14))){
var inst_21377 = (state_21403[(2)]);
var inst_21378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21377,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21377,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21377,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21377,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21382 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21379,q_map,inst_21378,fuel,max_fuel,opts);
var state_21403__$1 = (function (){var statearr_21431 = state_21403;
(statearr_21431[(9)] = inst_21380);

(statearr_21431[(7)] = inst_21381);

return statearr_21431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21403__$1,(15),inst_21382);
} else {
if((state_val_21404 === (16))){
var inst_21380 = (state_21403[(9)]);
var inst_21385 = (state_21403[(10)]);
var inst_21387 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21380,inst_21385,fuel,max_fuel,opts);
var state_21403__$1 = state_21403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21403__$1,(19),inst_21387);
} else {
if((state_val_21404 === (10))){
var state_21403__$1 = state_21403;
var statearr_21432_21463 = state_21403__$1;
(statearr_21432_21463[(2)] = false);

(statearr_21432_21463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (18))){
var inst_21381 = (state_21403[(7)]);
var inst_21393 = (state_21403[(2)]);
var state_21403__$1 = (function (){var statearr_21433 = state_21403;
(statearr_21433[(8)] = inst_21393);

return statearr_21433;
})();
if(cljs.core.truth_(inst_21381)){
var statearr_21434_21464 = state_21403__$1;
(statearr_21434_21464[(1)] = (20));

} else {
var statearr_21435_21465 = state_21403__$1;
(statearr_21435_21465[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21404 === (8))){
var inst_21372 = (state_21403[(2)]);
var state_21403__$1 = state_21403;
if(cljs.core.truth_(inst_21372)){
var statearr_21436_21466 = state_21403__$1;
(statearr_21436_21466[(1)] = (12));

} else {
var statearr_21437_21467 = state_21403__$1;
(statearr_21437_21467[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2414__auto____0 = (function (){
var statearr_21438 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21438[(0)] = fluree$db$query$analytical$q_$_state_machine__2414__auto__);

(statearr_21438[(1)] = (1));

return statearr_21438;
});
var fluree$db$query$analytical$q_$_state_machine__2414__auto____1 = (function (state_21403){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21403);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21439){var ex__2417__auto__ = e21439;
var statearr_21440_21468 = state_21403;
(statearr_21440_21468[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21403[(4)]))){
var statearr_21441_21469 = state_21403;
(statearr_21441_21469[(1)] = cljs.core.first((state_21403[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21470 = state_21403;
state_21403 = G__21470;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2414__auto__ = function(state_21403){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2414__auto____1.call(this,state_21403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2414__auto____0;
fluree$db$query$analytical$q_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2414__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21442 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21442[(6)] = c__2436__auto__);

return statearr_21442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
