// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19406_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19406_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19410 = coll;
var vec__19411 = G__19410;
var seq__19412 = cljs.core.seq(vec__19411);
var first__19413 = cljs.core.first(seq__19412);
var seq__19412__$1 = cljs.core.next(seq__19412);
var clause = first__19413;
var r = seq__19412__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19410__$1 = G__19410;
var res__$1 = res;
while(true){
var vec__19417 = G__19410__$1;
var seq__19418 = cljs.core.seq(vec__19417);
var first__19419 = cljs.core.first(seq__19418);
var seq__19418__$1 = cljs.core.next(seq__19418);
var clause__$1 = first__19419;
var r__$1 = seq__19418__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19420 = r__$1;
var G__19421 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19410__$1 = G__19420;
res__$1 = G__19421;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19425 = coll;
var vec__19426 = G__19425;
var seq__19427 = cljs.core.seq(vec__19426);
var first__19428 = cljs.core.first(seq__19427);
var seq__19427__$1 = cljs.core.next(seq__19427);
var clause = first__19428;
var r = seq__19427__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19425__$1 = G__19425;
var res__$1 = res;
while(true){
var vec__19432 = G__19425__$1;
var seq__19433 = cljs.core.seq(vec__19432);
var first__19434 = cljs.core.first(seq__19433);
var seq__19433__$1 = cljs.core.next(seq__19433);
var clause__$1 = first__19434;
var r__$1 = seq__19433__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19435 = r__$1;
var G__19436 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19425__$1 = G__19435;
res__$1 = G__19436;
continue;
} else {
var G__19437 = r__$1;
var G__19438 = res__$2;
G__19425__$1 = G__19437;
res__$1 = G__19438;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19442 = coll;
var vec__19443 = G__19442;
var seq__19444 = cljs.core.seq(vec__19443);
var first__19445 = cljs.core.first(seq__19444);
var seq__19444__$1 = cljs.core.next(seq__19444);
var clause = first__19445;
var r = seq__19444__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19442__$1 = G__19442;
var res__$1 = res;
while(true){
var vec__19449 = G__19442__$1;
var seq__19450 = cljs.core.seq(vec__19449);
var first__19451 = cljs.core.first(seq__19450);
var seq__19450__$1 = cljs.core.next(seq__19450);
var clause__$1 = first__19451;
var r__$1 = seq__19450__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19452 = r__$1;
var G__19453 = res__$2;
G__19442__$1 = G__19452;
res__$1 = G__19453;
continue;
} else {
var G__19454 = r__$1;
var G__19455 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19442__$1 = G__19454;
res__$1 = G__19455;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__19459 = opts;
var map__19459__$1 = (((((!((map__19459 == null))))?(((((map__19459.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19459.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19459):map__19459);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19459__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19459__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19459__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19459__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19459__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19456_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19456_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19457_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19457_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19458_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19458_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19474){
var state_val_19475 = (state_19474[(1)]);
if((state_val_19475 === (1))){
var inst_19461 = fluree.db.util.core.url_encode(query);
var inst_19462 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19461)].join('');
var inst_19463 = ["User-Agent","Accept"];
var inst_19464 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19465 = cljs.core.PersistentHashMap.fromArrays(inst_19463,inst_19464);
var inst_19466 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19467 = [inst_19465,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19468 = cljs.core.PersistentHashMap.fromArrays(inst_19466,inst_19467);
var inst_19469 = fluree.db.util.xhttp.get(inst_19462,inst_19468);
var state_19474__$1 = state_19474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19474__$1,(2),inst_19469);
} else {
if((state_val_19475 === (2))){
var inst_19471 = (state_19474[(2)]);
var inst_19472 = fluree.db.util.async.throw_err(inst_19471);
var state_19474__$1 = state_19474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19474__$1,inst_19472);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0 = (function (){
var statearr_19476 = [null,null,null,null,null,null,null];
(statearr_19476[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__);

(statearr_19476[(1)] = (1));

return statearr_19476;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1 = (function (state_19474){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19474);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19477){var ex__2417__auto__ = e19477;
var statearr_19478_19481 = state_19474;
(statearr_19478_19481[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19474[(4)]))){
var statearr_19479_19482 = state_19474;
(statearr_19479_19482[(1)] = cljs.core.first((state_19474[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19483 = state_19474;
state_19474 = G__19483;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__ = function(state_19474){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1.call(this,state_19474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19480 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19480[(6)] = c__2436__auto__);

return statearr_19480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19501){
var state_val_19502 = (state_19501[(1)]);
if((state_val_19502 === (1))){
var inst_19484 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_19501__$1 = state_19501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19501__$1,(2),inst_19484);
} else {
if((state_val_19502 === (2))){
var inst_19487 = (state_19501[(7)]);
var inst_19486 = (state_19501[(2)]);
var inst_19487__$1 = fluree.db.util.async.throw_err(inst_19486);
var inst_19488 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19487__$1);
var inst_19489 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_19488);
var state_19501__$1 = (function (){var statearr_19503 = state_19501;
(statearr_19503[(7)] = inst_19487__$1);

return statearr_19503;
})();
if(inst_19489){
var statearr_19504_19513 = state_19501__$1;
(statearr_19504_19513[(1)] = (3));

} else {
var statearr_19505_19514 = state_19501__$1;
(statearr_19505_19514[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19502 === (3))){
var inst_19487 = (state_19501[(7)]);
var state_19501__$1 = state_19501;
var statearr_19506_19515 = state_19501__$1;
(statearr_19506_19515[(2)] = inst_19487);

(statearr_19506_19515[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19502 === (4))){
var inst_19487 = (state_19501[(7)]);
var inst_19492 = (function (){var body = inst_19487;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19493 = cljs.core.second(inst_19487);
var inst_19494 = cljs.core.second(inst_19493);
var inst_19495 = cljs.core.first(inst_19494);
var inst_19496 = cljs.core.second(inst_19495);
var inst_19497 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_19492,inst_19496);
var state_19501__$1 = state_19501;
var statearr_19507_19516 = state_19501__$1;
(statearr_19507_19516[(2)] = inst_19497);

(statearr_19507_19516[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19502 === (5))){
var inst_19499 = (state_19501[(2)]);
var state_19501__$1 = state_19501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19501__$1,inst_19499);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0 = (function (){
var statearr_19508 = [null,null,null,null,null,null,null,null];
(statearr_19508[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__);

(statearr_19508[(1)] = (1));

return statearr_19508;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1 = (function (state_19501){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19501);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19509){var ex__2417__auto__ = e19509;
var statearr_19510_19517 = state_19501;
(statearr_19510_19517[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19501[(4)]))){
var statearr_19511_19518 = state_19501;
(statearr_19511_19518[(1)] = cljs.core.first((state_19501[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19519 = state_19501;
state_19501 = G__19519;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__ = function(state_19501){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1.call(this,state_19501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19512 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19512[(6)] = c__2436__auto__);

return statearr_19512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19520_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19520_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19521_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19521_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19522_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__19522_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19522_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__19522_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19588){
var state_val_19589 = (state_19588[(1)]);
if((state_val_19589 === (7))){
var inst_19533 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_19588__$1 = state_19588;
var statearr_19590_19631 = state_19588__$1;
(statearr_19590_19631[(2)] = inst_19533);

(statearr_19590_19631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (20))){
var inst_19561 = (state_19588[(7)]);
var inst_19581 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_19561,all_vars);
var state_19588__$1 = state_19588;
var statearr_19591_19632 = state_19588__$1;
(statearr_19591_19632[(2)] = inst_19581);

(statearr_19591_19632[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (1))){
var state_19588__$1 = state_19588;
var statearr_19592_19633 = state_19588__$1;
(statearr_19592_19633[(2)] = null);

(statearr_19592_19633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (24))){
var inst_19561 = (state_19588[(7)]);
var inst_19567 = (state_19588[(8)]);
var inst_19562 = (state_19588[(9)]);
var inst_19572 = (state_19588[(2)]);
var inst_19573 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_19567,(0),inst_19572);
var inst_19574 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19575 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19561);
var inst_19576 = [inst_19562,inst_19575];
var inst_19577 = cljs.core.PersistentHashMap.fromArrays(inst_19574,inst_19576);
var inst_19578 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19573,inst_19577);
var inst_19579 = (function(){throw inst_19578})();
var state_19588__$1 = state_19588;
var statearr_19593_19634 = state_19588__$1;
(statearr_19593_19634[(2)] = inst_19579);

(statearr_19593_19634[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (4))){
var inst_19523 = (state_19588[(2)]);
var state_19588__$1 = state_19588;
var statearr_19594_19635 = state_19588__$1;
(statearr_19594_19635[(2)] = inst_19523);

(statearr_19594_19635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (15))){
var inst_19553 = (state_19588[(2)]);
var state_19588__$1 = state_19588;
var statearr_19595_19636 = state_19588__$1;
(statearr_19595_19636[(2)] = inst_19553);

(statearr_19595_19636[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (21))){
var inst_19583 = (state_19588[(2)]);
var _ = (function (){var statearr_19596 = state_19588;
(statearr_19596[(4)] = cljs.core.rest((state_19588[(4)])));

return statearr_19596;
})();
var state_19588__$1 = state_19588;
var statearr_19597_19637 = state_19588__$1;
(statearr_19597_19637[(2)] = inst_19583);

(statearr_19597_19637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (13))){
var state_19588__$1 = state_19588;
var statearr_19598_19638 = state_19588__$1;
(statearr_19598_19638[(2)] = true);

(statearr_19598_19638[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (22))){
var inst_19566 = (state_19588[(10)]);
var state_19588__$1 = state_19588;
var statearr_19599_19639 = state_19588__$1;
(statearr_19599_19639[(2)] = inst_19566);

(statearr_19599_19639[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (6))){
var state_19588__$1 = state_19588;
var statearr_19600_19640 = state_19588__$1;
(statearr_19600_19640[(2)] = null);

(statearr_19600_19640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (17))){
var inst_19540 = (state_19588[(11)]);
var state_19588__$1 = state_19588;
var statearr_19601_19641 = state_19588__$1;
(statearr_19601_19641[(2)] = inst_19540);

(statearr_19601_19641[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (3))){
var inst_19586 = (state_19588[(2)]);
var state_19588__$1 = state_19588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19588__$1,inst_19586);
} else {
if((state_val_19589 === (12))){
var inst_19556 = (state_19588[(2)]);
var state_19588__$1 = state_19588;
if(cljs.core.truth_(inst_19556)){
var statearr_19602_19642 = state_19588__$1;
(statearr_19602_19642[(1)] = (16));

} else {
var statearr_19603_19643 = state_19588__$1;
(statearr_19603_19643[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (2))){
var _ = (function (){var statearr_19604 = state_19588;
(statearr_19604[(4)] = cljs.core.cons((5),(state_19588[(4)])));

return statearr_19604;
})();
var inst_19530 = cljs.core.empty_QMARK_(matching_vars);
var state_19588__$1 = state_19588;
if(inst_19530){
var statearr_19605_19644 = state_19588__$1;
(statearr_19605_19644[(1)] = (6));

} else {
var statearr_19606_19645 = state_19588__$1;
(statearr_19606_19645[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (23))){
var state_19588__$1 = state_19588;
var statearr_19607_19646 = state_19588__$1;
(statearr_19607_19646[(2)] = (1000));

(statearr_19607_19646[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (19))){
var inst_19561 = (state_19588[(7)]);
var inst_19566 = (state_19588[(10)]);
var inst_19563 = (state_19588[(12)]);
var inst_19566__$1 = cljs.core.count(inst_19563);
var inst_19567 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19561);
var inst_19568 = (inst_19566__$1 < (1000));
var state_19588__$1 = (function (){var statearr_19608 = state_19588;
(statearr_19608[(10)] = inst_19566__$1);

(statearr_19608[(8)] = inst_19567);

return statearr_19608;
})();
if(cljs.core.truth_(inst_19568)){
var statearr_19609_19647 = state_19588__$1;
(statearr_19609_19647[(1)] = (22));

} else {
var statearr_19610_19648 = state_19588__$1;
(statearr_19610_19648[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (11))){
var state_19588__$1 = state_19588;
var statearr_19612_19649 = state_19588__$1;
(statearr_19612_19649[(2)] = false);

(statearr_19612_19649[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (9))){
var inst_19540 = (state_19588[(11)]);
var inst_19539 = (state_19588[(2)]);
var inst_19540__$1 = fluree.db.util.async.throw_err(inst_19539);
var inst_19542 = (inst_19540__$1 == null);
var inst_19543 = cljs.core.not(inst_19542);
var state_19588__$1 = (function (){var statearr_19613 = state_19588;
(statearr_19613[(11)] = inst_19540__$1);

return statearr_19613;
})();
if(inst_19543){
var statearr_19614_19650 = state_19588__$1;
(statearr_19614_19650[(1)] = (10));

} else {
var statearr_19615_19651 = state_19588__$1;
(statearr_19615_19651[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (5))){
var _ = (function (){var statearr_19616 = state_19588;
(statearr_19616[(4)] = cljs.core.rest((state_19588[(4)])));

return statearr_19616;
})();
var state_19588__$1 = state_19588;
var ex19611 = (state_19588__$1[(2)]);
var statearr_19617_19652 = state_19588__$1;
(statearr_19617_19652[(5)] = ex19611);


if((ex19611 instanceof Error)){
var statearr_19618_19653 = state_19588__$1;
(statearr_19618_19653[(1)] = (4));

(statearr_19618_19653[(5)] = null);

} else {
throw ex19611;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (14))){
var state_19588__$1 = state_19588;
var statearr_19619_19654 = state_19588__$1;
(statearr_19619_19654[(2)] = false);

(statearr_19619_19654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (16))){
var inst_19540 = (state_19588[(11)]);
var inst_19558 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19540);
var state_19588__$1 = state_19588;
var statearr_19620_19655 = state_19588__$1;
(statearr_19620_19655[(2)] = inst_19558);

(statearr_19620_19655[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (10))){
var inst_19540 = (state_19588[(11)]);
var inst_19545 = inst_19540.cljs$lang$protocol_mask$partition0$;
var inst_19546 = (inst_19545 & (64));
var inst_19547 = inst_19540.cljs$core$ISeq$;
var inst_19548 = (cljs.core.PROTOCOL_SENTINEL === inst_19547);
var inst_19549 = ((inst_19546) || (inst_19548));
var state_19588__$1 = state_19588;
if(cljs.core.truth_(inst_19549)){
var statearr_19621_19656 = state_19588__$1;
(statearr_19621_19656[(1)] = (13));

} else {
var statearr_19622_19657 = state_19588__$1;
(statearr_19622_19657[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (18))){
var inst_19561 = (state_19588[(7)]);
var inst_19562 = (state_19588[(9)]);
var inst_19561__$1 = (state_19588[(2)]);
var inst_19562__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19561__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19561__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19564 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_19562__$1);
var state_19588__$1 = (function (){var statearr_19623 = state_19588;
(statearr_19623[(7)] = inst_19561__$1);

(statearr_19623[(12)] = inst_19563);

(statearr_19623[(9)] = inst_19562__$1);

return statearr_19623;
})();
if(inst_19564){
var statearr_19624_19658 = state_19588__$1;
(statearr_19624_19658[(1)] = (19));

} else {
var statearr_19625_19659 = state_19588__$1;
(statearr_19625_19659[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19589 === (8))){
var inst_19535 = (state_19588[(2)]);
var inst_19536 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_19535,optional_clauses);
var inst_19537 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_19536);
var state_19588__$1 = state_19588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19588__$1,(9),inst_19537);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_19626 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19626[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__);

(statearr_19626[(1)] = (1));

return statearr_19626;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1 = (function (state_19588){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19588);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19627){var ex__2417__auto__ = e19627;
var statearr_19628_19660 = state_19588;
(statearr_19628_19660[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19588[(4)]))){
var statearr_19629_19661 = state_19588;
(statearr_19629_19661[(1)] = cljs.core.first((state_19588[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19662 = state_19588;
state_19588 = G__19662;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__ = function(state_19588){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1.call(this,state_19588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19630 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19630[(6)] = c__2436__auto__);

return statearr_19630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
