// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13139 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13139,(5),null);
var G__13142 = idx;
var G__13142__$1 = (((G__13142 instanceof cljs.core.Keyword))?G__13142.fqn:null);
switch (G__13142__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13142__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13144 = idx;
var G__13144__$1 = (((G__13144 instanceof cljs.core.Keyword))?G__13144.fqn:null);
switch (G__13144__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13144__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13146 = idx;
var G__13146__$1 = (((G__13146 instanceof cljs.core.Keyword))?G__13146.fqn:null);
switch (G__13146__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13146__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13149 = arguments.length;
switch (G__13149) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13150 = (function (){var pred__13153 = cljs.core.identical_QMARK_;
var expr__13154 = test;
if(cljs.core.truth_((pred__13153.cljs$core$IFn$_invoke$arity$2 ? pred__13153.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13154) : pred__13153.call(null,cljs.core._EQ_,expr__13154)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13153.cljs$core$IFn$_invoke$arity$2 ? pred__13153.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13154) : pred__13153.call(null,cljs.core._LT_,expr__13154)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13153.cljs$core$IFn$_invoke$arity$2 ? pred__13153.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13154) : pred__13153.call(null,cljs.core._LT__EQ_,expr__13154)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13153.cljs$core$IFn$_invoke$arity$2 ? pred__13153.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13154) : pred__13153.call(null,cljs.core._GT_,expr__13154)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13153.cljs$core$IFn$_invoke$arity$2 ? pred__13153.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13154) : pred__13153.call(null,cljs.core._GT__EQ_,expr__13154)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13154)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13150,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13150,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13150,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13150,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13367){
var state_val_13368 = (state_13367[(1)]);
if((state_val_13368 === (65))){
var inst_13320 = (state_13367[(7)]);
var inst_13288 = (state_13367[(8)]);
var inst_13332 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13320,inst_13288);
var state_13367__$1 = state_13367;
var statearr_13369_13485 = state_13367__$1;
(statearr_13369_13485[(2)] = inst_13332);

(statearr_13369_13485[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (70))){
var inst_13350 = (state_13367[(2)]);
var inst_13351 = cljs.core.not(inst_13350);
var state_13367__$1 = state_13367;
if(inst_13351){
var statearr_13370_13486 = state_13367__$1;
(statearr_13370_13486[(1)] = (71));

} else {
var statearr_13371_13487 = state_13367__$1;
(statearr_13371_13487[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (62))){
var inst_13341 = (state_13367[(9)]);
var inst_13302 = (state_13367[(10)]);
var inst_13341__$1 = (state_13367[(2)]);
var inst_13342 = cljs.core.count(inst_13341__$1);
var state_13367__$1 = (function (){var statearr_13372 = state_13367;
(statearr_13372[(11)] = inst_13342);

(statearr_13372[(9)] = inst_13341__$1);

return statearr_13372;
})();
if(cljs.core.truth_(inst_13302)){
var statearr_13373_13488 = state_13367__$1;
(statearr_13373_13488[(1)] = (68));

} else {
var statearr_13374_13489 = state_13367__$1;
(statearr_13374_13489[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (74))){
var inst_13342 = (state_13367[(11)]);
var inst_13341 = (state_13367[(9)]);
var inst_13356 = (state_13367[(2)]);
var inst_13357 = fluree.db.util.async.throw_err(inst_13356);
var inst_13286 = inst_13357;
var inst_13287 = inst_13342;
var inst_13288 = inst_13341;
var state_13367__$1 = (function (){var statearr_13375 = state_13367;
(statearr_13375[(12)] = inst_13286);

(statearr_13375[(13)] = inst_13287);

(statearr_13375[(8)] = inst_13288);

return statearr_13375;
})();
var statearr_13376_13490 = state_13367__$1;
(statearr_13376_13490[(2)] = null);

(statearr_13376_13490[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (7))){
var inst_13169 = (state_13367[(14)]);
var state_13367__$1 = state_13367;
var statearr_13377_13491 = state_13367__$1;
(statearr_13377_13491[(2)] = inst_13169);

(statearr_13377_13491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (59))){
var inst_13286 = (state_13367[(12)]);
var inst_13301 = (state_13367[(2)]);
var inst_13302 = fluree.db.dbproto._rhs(inst_13286);
var state_13367__$1 = (function (){var statearr_13378 = state_13367;
(statearr_13378[(15)] = inst_13301);

(statearr_13378[(10)] = inst_13302);

return statearr_13378;
})();
var statearr_13379_13492 = state_13367__$1;
(statearr_13379_13492[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (20))){
var inst_13170 = (state_13367[(16)]);
var inst_13217 = (state_13367[(2)]);
var inst_13218 = (inst_13170 == null);
var state_13367__$1 = (function (){var statearr_13381 = state_13367;
(statearr_13381[(17)] = inst_13217);

return statearr_13381;
})();
if(cljs.core.truth_(inst_13218)){
var statearr_13382_13493 = state_13367__$1;
(statearr_13382_13493[(1)] = (22));

} else {
var statearr_13383_13494 = state_13367__$1;
(statearr_13383_13494[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (72))){
var inst_13281 = (state_13367[(18)]);
var inst_13302 = (state_13367[(10)]);
var inst_13354 = fluree.db.dbproto._lookup_leaf(inst_13281,inst_13302);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(74),inst_13354);
} else {
if((state_val_13368 === (58))){
var inst_13294 = (state_13367[(19)]);
var state_13367__$1 = state_13367;
var statearr_13384_13495 = state_13367__$1;
(statearr_13384_13495[(2)] = inst_13294);

(statearr_13384_13495[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (60))){
var inst_13301 = (state_13367[(15)]);
var inst_13287 = (state_13367[(13)]);
var inst_13288 = (state_13367[(8)]);
var inst_13260 = (state_13367[(20)]);
var inst_13304 = (inst_13260 - inst_13287);
var inst_13305 = fluree.db.flake.take(inst_13304,inst_13301);
var inst_13306 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13305,inst_13288);
var state_13367__$1 = state_13367;
var statearr_13385_13496 = state_13367__$1;
(statearr_13385_13496[(2)] = inst_13306);

(statearr_13385_13496[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (27))){
var inst_13177 = (state_13367[(21)]);
var inst_13226 = (state_13367[(2)]);
var inst_13227 = (inst_13177 == null);
var state_13367__$1 = (function (){var statearr_13386 = state_13367;
(statearr_13386[(22)] = inst_13226);

return statearr_13386;
})();
if(cljs.core.truth_(inst_13227)){
var statearr_13387_13497 = state_13367__$1;
(statearr_13387_13497[(1)] = (28));

} else {
var statearr_13388_13498 = state_13367__$1;
(statearr_13388_13498[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (1))){
var state_13367__$1 = state_13367;
var statearr_13389_13499 = state_13367__$1;
(statearr_13389_13499[(2)] = null);

(statearr_13389_13499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (69))){
var inst_13302 = (state_13367[(10)]);
var state_13367__$1 = state_13367;
var statearr_13390_13500 = state_13367__$1;
(statearr_13390_13500[(2)] = inst_13302);

(statearr_13390_13500[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (24))){
var inst_13222 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
if(cljs.core.truth_(inst_13222)){
var statearr_13391_13501 = state_13367__$1;
(statearr_13391_13501[(1)] = (25));

} else {
var statearr_13392_13502 = state_13367__$1;
(statearr_13392_13502[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (55))){
var inst_13362 = (state_13367[(2)]);
var _ = (function (){var statearr_13393 = state_13367;
(statearr_13393[(4)] = cljs.core.rest((state_13367[(4)])));

return statearr_13393;
})();
var state_13367__$1 = state_13367;
var statearr_13394_13503 = state_13367__$1;
(statearr_13394_13503[(2)] = inst_13362);

(statearr_13394_13503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (39))){
var inst_13242 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13395_13504 = state_13367__$1;
(statearr_13395_13504[(2)] = inst_13242);

(statearr_13395_13504[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (46))){
var inst_13256 = (state_13367[(23)]);
var state_13367__$1 = state_13367;
var statearr_13396_13505 = state_13367__$1;
(statearr_13396_13505[(2)] = inst_13256);

(statearr_13396_13505[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (4))){
var inst_13156 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13397_13506 = state_13367__$1;
(statearr_13397_13506[(2)] = inst_13156);

(statearr_13397_13506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (54))){
var inst_13276 = (state_13367[(24)]);
var inst_13286 = (state_13367[(12)]);
var inst_13271 = (state_13367[(25)]);
var inst_13272 = (state_13367[(26)]);
var inst_13290 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13286,inst_13271,inst_13272,inst_13276);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(56),inst_13290);
} else {
if((state_val_13368 === (15))){
var inst_13171 = (state_13367[(27)]);
var state_13367__$1 = state_13367;
var statearr_13398_13507 = state_13367__$1;
(statearr_13398_13507[(2)] = inst_13171);

(statearr_13398_13507[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (48))){
var inst_13266 = (state_13367[(28)]);
var inst_13260 = (state_13367[(2)]);
var inst_13261 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13263 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13264 = (new cljs.core.PersistentVector(null,3,(5),inst_13262,inst_13263,null));
var inst_13265 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13264);
var inst_13266__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13367__$1 = (function (){var statearr_13399 = state_13367;
(statearr_13399[(29)] = inst_13261);

(statearr_13399[(30)] = inst_13265);

(statearr_13399[(28)] = inst_13266__$1);

(statearr_13399[(20)] = inst_13260);

return statearr_13399;
})();
if(cljs.core.truth_(inst_13266__$1)){
var statearr_13400_13508 = state_13367__$1;
(statearr_13400_13508[(1)] = (49));

} else {
var statearr_13401_13509 = state_13367__$1;
(statearr_13401_13509[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (50))){
var inst_13269 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13367__$1 = state_13367;
var statearr_13402_13510 = state_13367__$1;
(statearr_13402_13510[(2)] = inst_13269);

(statearr_13402_13510[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (21))){
var inst_13213 = (state_13367[(2)]);
var inst_13214 = fluree.db.util.async.throw_err(inst_13213);
var state_13367__$1 = state_13367;
var statearr_13403_13511 = state_13367__$1;
(statearr_13403_13511[(2)] = inst_13214);

(statearr_13403_13511[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (31))){
var state_13367__$1 = state_13367;
var statearr_13404_13512 = state_13367__$1;
(statearr_13404_13512[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13404_13512[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (32))){
var inst_13177 = (state_13367[(21)]);
var state_13367__$1 = state_13367;
var statearr_13405_13513 = state_13367__$1;
(statearr_13405_13513[(2)] = inst_13177);

(statearr_13405_13513[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (40))){
var inst_13181 = (state_13367[(31)]);
var state_13367__$1 = state_13367;
var statearr_13406_13514 = state_13367__$1;
(statearr_13406_13514[(2)] = inst_13181);

(statearr_13406_13514[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (56))){
var inst_13293 = (state_13367[(32)]);
var inst_13255 = (state_13367[(33)]);
var inst_13254 = (state_13367[(34)]);
var inst_13292 = (state_13367[(2)]);
var inst_13293__$1 = fluree.db.util.async.throw_err(inst_13292);
var inst_13294 = fluree.db.flake.subrange(inst_13293__$1,start_test,inst_13254,end_test,inst_13255);
var inst_13295 = fluree.db.query.range.value_with_nil_pred(idx,inst_13254,inst_13255);
var state_13367__$1 = (function (){var statearr_13407 = state_13367;
(statearr_13407[(32)] = inst_13293__$1);

(statearr_13407[(19)] = inst_13294);

return statearr_13407;
})();
if(inst_13295){
var statearr_13408_13515 = state_13367__$1;
(statearr_13408_13515[(1)] = (57));

} else {
var statearr_13409_13516 = state_13367__$1;
(statearr_13409_13516[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (33))){
var inst_13174 = (state_13367[(35)]);
var inst_13235 = (state_13367[(2)]);
var state_13367__$1 = (function (){var statearr_13410 = state_13367;
(statearr_13410[(36)] = inst_13235);

return statearr_13410;
})();
if(cljs.core.truth_(inst_13174)){
var statearr_13411_13517 = state_13367__$1;
(statearr_13411_13517[(1)] = (34));

} else {
var statearr_13412_13518 = state_13367__$1;
(statearr_13412_13518[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (13))){
var inst_13195 = (state_13367[(2)]);
var inst_13196 = fluree.db.util.async.throw_err(inst_13195);
var state_13367__$1 = state_13367;
var statearr_13413_13519 = state_13367__$1;
(statearr_13413_13519[(2)] = inst_13196);

(statearr_13413_13519[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (22))){
var inst_13208 = (state_13367[(37)]);
var state_13367__$1 = state_13367;
var statearr_13414_13520 = state_13367__$1;
(statearr_13414_13520[(2)] = inst_13208);

(statearr_13414_13520[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (36))){
var inst_13181 = (state_13367[(31)]);
var inst_13244 = (state_13367[(2)]);
var state_13367__$1 = (function (){var statearr_13415 = state_13367;
(statearr_13415[(38)] = inst_13244);

return statearr_13415;
})();
if(cljs.core.truth_(inst_13181)){
var statearr_13416_13521 = state_13367__$1;
(statearr_13416_13521[(1)] = (40));

} else {
var statearr_13417_13522 = state_13367__$1;
(statearr_13417_13522[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (41))){
var inst_13247 = (cljs.core._LT__EQ_ === end_test);
var state_13367__$1 = state_13367;
if(cljs.core.truth_(inst_13247)){
var statearr_13418_13523 = state_13367__$1;
(statearr_13418_13523[(1)] = (43));

} else {
var statearr_13419_13524 = state_13367__$1;
(statearr_13419_13524[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (43))){
var state_13367__$1 = state_13367;
var statearr_13420_13525 = state_13367__$1;
(statearr_13420_13525[(2)] = (2147483647));

(statearr_13420_13525[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (61))){
var inst_13301 = (state_13367[(15)]);
var inst_13287 = (state_13367[(13)]);
var inst_13315 = cljs.core.seq(inst_13301);
var inst_13316 = cljs.core.first(inst_13315);
var inst_13317 = cljs.core.next(inst_13315);
var inst_13318 = inst_13301;
var inst_13319 = inst_13287;
var inst_13320 = inst_13301;
var state_13367__$1 = (function (){var statearr_13421 = state_13367;
(statearr_13421[(39)] = inst_13318);

(statearr_13421[(7)] = inst_13320);

(statearr_13421[(40)] = inst_13317);

(statearr_13421[(41)] = inst_13319);

(statearr_13421[(42)] = inst_13316);

return statearr_13421;
})();
var statearr_13422_13526 = state_13367__$1;
(statearr_13422_13526[(2)] = null);

(statearr_13422_13526[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (29))){
var state_13367__$1 = state_13367;
var statearr_13423_13527 = state_13367__$1;
(statearr_13423_13527[(2)] = false);

(statearr_13423_13527[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (44))){
var state_13367__$1 = state_13367;
var statearr_13424_13528 = state_13367__$1;
(statearr_13424_13528[(2)] = fluree.db.util.core.min_integer);

(statearr_13424_13528[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (6))){
var inst_13169 = (state_13367[(14)]);
var inst_13184 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13169);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(9),inst_13184);
} else {
if((state_val_13368 === (28))){
var inst_13217 = (state_13367[(17)]);
var state_13367__$1 = state_13367;
var statearr_13425_13529 = state_13367__$1;
(statearr_13425_13529[(2)] = inst_13217);

(statearr_13425_13529[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (64))){
var inst_13339 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13426_13530 = state_13367__$1;
(statearr_13426_13530[(2)] = inst_13339);

(statearr_13426_13530[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (51))){
var inst_13271 = (state_13367[(2)]);
var inst_13272 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13274 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13275 = (new cljs.core.PersistentVector(null,2,(5),inst_13273,inst_13274,null));
var inst_13276 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13275);
var inst_13277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13278 = fluree.db.dbproto._resolve(inst_13277);
var state_13367__$1 = (function (){var statearr_13427 = state_13367;
(statearr_13427[(24)] = inst_13276);

(statearr_13427[(25)] = inst_13271);

(statearr_13427[(26)] = inst_13272);

return statearr_13427;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(52),inst_13278);
} else {
if((state_val_13368 === (25))){
var state_13367__$1 = state_13367;
var statearr_13428_13531 = state_13367__$1;
(statearr_13428_13531[(2)] = (-1));

(statearr_13428_13531[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (34))){
var inst_13174 = (state_13367[(35)]);
var state_13367__$1 = state_13367;
var statearr_13429_13532 = state_13367__$1;
(statearr_13429_13532[(2)] = inst_13174);

(statearr_13429_13532[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (17))){
var inst_13204 = (state_13367[(2)]);
var inst_13205 = fluree.db.util.async.throw_err(inst_13204);
var state_13367__$1 = state_13367;
var statearr_13430_13533 = state_13367__$1;
(statearr_13430_13533[(2)] = inst_13205);

(statearr_13430_13533[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (3))){
var inst_13365 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13367__$1,inst_13365);
} else {
if((state_val_13368 === (12))){
var inst_13171 = (state_13367[(27)]);
var inst_13199 = (state_13367[(2)]);
var inst_13200 = fluree.db.util.core.pred_ident_QMARK_(inst_13171);
var state_13367__$1 = (function (){var statearr_13432 = state_13367;
(statearr_13432[(43)] = inst_13199);

return statearr_13432;
})();
if(inst_13200){
var statearr_13433_13534 = state_13367__$1;
(statearr_13433_13534[(1)] = (14));

} else {
var statearr_13434_13535 = state_13367__$1;
(statearr_13434_13535[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (2))){
var inst_13169 = (state_13367[(14)]);
var inst_13175 = (state_13367[(44)]);
var inst_13168 = (state_13367[(45)]);
var _ = (function (){var statearr_13435 = state_13367;
(statearr_13435[(4)] = cljs.core.cons((5),(state_13367[(4)])));

return statearr_13435;
})();
var inst_13168__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13169__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(0),null);
var inst_13170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(1),null);
var inst_13171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(2),null);
var inst_13172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(3),null);
var inst_13173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(4),null);
var inst_13174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13168__$1,(5),null);
var inst_13175__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(0),null);
var inst_13177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(1),null);
var inst_13178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(2),null);
var inst_13179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(3),null);
var inst_13180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(4),null);
var inst_13181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13175__$1,(5),null);
var inst_13182 = fluree.db.util.core.pred_ident_QMARK_(inst_13169__$1);
var state_13367__$1 = (function (){var statearr_13436 = state_13367;
(statearr_13436[(46)] = inst_13176);

(statearr_13436[(47)] = inst_13179);

(statearr_13436[(48)] = inst_13180);

(statearr_13436[(31)] = inst_13181);

(statearr_13436[(35)] = inst_13174);

(statearr_13436[(49)] = inst_13173);

(statearr_13436[(50)] = inst_13172);

(statearr_13436[(14)] = inst_13169__$1);

(statearr_13436[(44)] = inst_13175__$1);

(statearr_13436[(16)] = inst_13170);

(statearr_13436[(45)] = inst_13168__$1);

(statearr_13436[(51)] = inst_13178);

(statearr_13436[(21)] = inst_13177);

(statearr_13436[(27)] = inst_13171);

return statearr_13436;
})();
if(inst_13182){
var statearr_13437_13536 = state_13367__$1;
(statearr_13437_13536[(1)] = (6));

} else {
var statearr_13438_13537 = state_13367__$1;
(statearr_13438_13537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (66))){
var inst_13320 = (state_13367[(7)]);
var inst_13319 = (state_13367[(41)]);
var inst_13327 = (state_13367[(52)]);
var inst_13334 = (inst_13319 + (1));
var tmp13431 = inst_13320;
var inst_13318 = inst_13327;
var inst_13319__$1 = inst_13334;
var inst_13320__$1 = tmp13431;
var state_13367__$1 = (function (){var statearr_13439 = state_13367;
(statearr_13439[(39)] = inst_13318);

(statearr_13439[(7)] = inst_13320__$1);

(statearr_13439[(41)] = inst_13319__$1);

return statearr_13439;
})();
var statearr_13440_13538 = state_13367__$1;
(statearr_13440_13538[(2)] = null);

(statearr_13440_13538[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (23))){
var state_13367__$1 = state_13367;
var statearr_13441_13539 = state_13367__$1;
(statearr_13441_13539[(2)] = false);

(statearr_13441_13539[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (47))){
var state_13367__$1 = state_13367;
var statearr_13442_13540 = state_13367__$1;
(statearr_13442_13540[(2)] = fluree.db.util.core.max_long);

(statearr_13442_13540[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (35))){
var inst_13238 = (cljs.core._GT__EQ_ === start_test);
var state_13367__$1 = state_13367;
if(cljs.core.truth_(inst_13238)){
var statearr_13443_13541 = state_13367__$1;
(statearr_13443_13541[(1)] = (37));

} else {
var statearr_13444_13542 = state_13367__$1;
(statearr_13444_13542[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (19))){
var inst_13178 = (state_13367[(51)]);
var state_13367__$1 = state_13367;
var statearr_13445_13543 = state_13367__$1;
(statearr_13445_13543[(2)] = inst_13178);

(statearr_13445_13543[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (57))){
var inst_13293 = (state_13367[(32)]);
var inst_13276 = (state_13367[(24)]);
var inst_13261 = (state_13367[(29)]);
var inst_13208 = (state_13367[(37)]);
var inst_13179 = (state_13367[(47)]);
var inst_13190 = (state_13367[(53)]);
var inst_13180 = (state_13367[(48)]);
var inst_13265 = (state_13367[(30)]);
var inst_13286 = (state_13367[(12)]);
var inst_13244 = (state_13367[(38)]);
var inst_13173 = (state_13367[(49)]);
var inst_13281 = (state_13367[(18)]);
var inst_13287 = (state_13367[(13)]);
var inst_13271 = (state_13367[(25)]);
var inst_13253 = (state_13367[(54)]);
var inst_13172 = (state_13367[(50)]);
var inst_13272 = (state_13367[(26)]);
var inst_13255 = (state_13367[(33)]);
var inst_13288 = (state_13367[(8)]);
var inst_13199 = (state_13367[(43)]);
var inst_13175 = (state_13367[(44)]);
var inst_13260 = (state_13367[(20)]);
var inst_13217 = (state_13367[(17)]);
var inst_13254 = (state_13367[(34)]);
var inst_13294 = (state_13367[(19)]);
var inst_13226 = (state_13367[(22)]);
var inst_13235 = (state_13367[(36)]);
var inst_13168 = (state_13367[(45)]);
var inst_13297 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13286;
var flakes = inst_13293;
var s1 = inst_13190;
var o2 = inst_13217;
var t1 = inst_13172;
var i = inst_13287;
var m1 = inst_13244;
var root_node = inst_13281;
var to_t = inst_13272;
var s2 = inst_13199;
var p2 = inst_13235;
var permissions = inst_13261;
var limit = inst_13260;
var start_flake = inst_13254;
var vec__13165 = inst_13175;
var acc = inst_13288;
var t2 = inst_13179;
var vec__13162 = inst_13168;
var op1 = inst_13173;
var o1 = inst_13208;
var end_flake = inst_13255;
var base_result = inst_13294;
var p1 = inst_13226;
var idx_compare = inst_13265;
var op2 = inst_13180;
var from_t = inst_13271;
var m2 = inst_13253;
var novelty = inst_13276;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13298 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13297,inst_13294,inst_13294);
var state_13367__$1 = state_13367;
var statearr_13446_13544 = state_13367__$1;
(statearr_13446_13544[(2)] = inst_13298);

(statearr_13446_13544[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (68))){
var inst_13342 = (state_13367[(11)]);
var inst_13265 = (state_13367[(30)]);
var inst_13302 = (state_13367[(10)]);
var inst_13255 = (state_13367[(33)]);
var inst_13260 = (state_13367[(20)]);
var inst_13344 = (inst_13265.cljs$core$IFn$_invoke$arity$2 ? inst_13265.cljs$core$IFn$_invoke$arity$2(inst_13302,inst_13255) : inst_13265.call(null,inst_13302,inst_13255));
var inst_13345 = (inst_13344 < (0));
var inst_13346 = (inst_13342 < inst_13260);
var inst_13347 = ((inst_13345) && (inst_13346));
var state_13367__$1 = state_13367;
var statearr_13447_13545 = state_13367__$1;
(statearr_13447_13545[(2)] = inst_13347);

(statearr_13447_13545[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (11))){
var inst_13176 = (state_13367[(46)]);
var state_13367__$1 = state_13367;
var statearr_13449_13546 = state_13367__$1;
(statearr_13449_13546[(2)] = inst_13176);

(statearr_13449_13546[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (9))){
var inst_13186 = (state_13367[(2)]);
var inst_13187 = fluree.db.util.async.throw_err(inst_13186);
var state_13367__$1 = state_13367;
var statearr_13450_13547 = state_13367__$1;
(statearr_13450_13547[(2)] = inst_13187);

(statearr_13450_13547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (5))){
var _ = (function (){var statearr_13451 = state_13367;
(statearr_13451[(4)] = cljs.core.rest((state_13367[(4)])));

return statearr_13451;
})();
var state_13367__$1 = state_13367;
var ex13448 = (state_13367__$1[(2)]);
var statearr_13452_13548 = state_13367__$1;
(statearr_13452_13548[(5)] = ex13448);


if((ex13448 instanceof Error)){
var statearr_13453_13549 = state_13367__$1;
(statearr_13453_13549[(1)] = (4));

(statearr_13453_13549[(5)] = null);

} else {
throw ex13448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (14))){
var inst_13171 = (state_13367[(27)]);
var inst_13202 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13171);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(17),inst_13202);
} else {
if((state_val_13368 === (45))){
var inst_13251 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13454_13550 = state_13367__$1;
(statearr_13454_13550[(2)] = inst_13251);

(statearr_13454_13550[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (53))){
var inst_13284 = (state_13367[(2)]);
var inst_13285 = fluree.db.util.async.throw_err(inst_13284);
var inst_13286 = inst_13285;
var inst_13287 = (0);
var inst_13288 = null;
var state_13367__$1 = (function (){var statearr_13455 = state_13367;
(statearr_13455[(12)] = inst_13286);

(statearr_13455[(13)] = inst_13287);

(statearr_13455[(8)] = inst_13288);

return statearr_13455;
})();
var statearr_13456_13551 = state_13367__$1;
(statearr_13456_13551[(2)] = null);

(statearr_13456_13551[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (26))){
var inst_13170 = (state_13367[(16)]);
var state_13367__$1 = state_13367;
var statearr_13457_13552 = state_13367__$1;
(statearr_13457_13552[(2)] = inst_13170);

(statearr_13457_13552[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (16))){
var inst_13178 = (state_13367[(51)]);
var inst_13208 = (state_13367[(2)]);
var inst_13209 = fluree.db.util.core.pred_ident_QMARK_(inst_13178);
var state_13367__$1 = (function (){var statearr_13458 = state_13367;
(statearr_13458[(37)] = inst_13208);

return statearr_13458;
})();
if(inst_13209){
var statearr_13459_13553 = state_13367__$1;
(statearr_13459_13553[(1)] = (18));

} else {
var statearr_13460_13554 = state_13367__$1;
(statearr_13460_13554[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (38))){
var state_13367__$1 = state_13367;
var statearr_13461_13555 = state_13367__$1;
(statearr_13461_13555[(2)] = (2147483647));

(statearr_13461_13555[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (30))){
var inst_13231 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
if(cljs.core.truth_(inst_13231)){
var statearr_13462_13556 = state_13367__$1;
(statearr_13462_13556[(1)] = (31));

} else {
var statearr_13463_13557 = state_13367__$1;
(statearr_13463_13557[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (73))){
var inst_13360 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13464_13558 = state_13367__$1;
(statearr_13464_13558[(2)] = inst_13360);

(statearr_13464_13558[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (10))){
var inst_13176 = (state_13367[(46)]);
var inst_13193 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13176);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(13),inst_13193);
} else {
if((state_val_13368 === (18))){
var inst_13178 = (state_13367[(51)]);
var inst_13211 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13178);
var state_13367__$1 = state_13367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(21),inst_13211);
} else {
if((state_val_13368 === (52))){
var inst_13281 = (state_13367[(18)]);
var inst_13254 = (state_13367[(34)]);
var inst_13280 = (state_13367[(2)]);
var inst_13281__$1 = fluree.db.util.async.throw_err(inst_13280);
var inst_13282 = fluree.db.dbproto._lookup_leaf(inst_13281__$1,inst_13254);
var state_13367__$1 = (function (){var statearr_13465 = state_13367;
(statearr_13465[(18)] = inst_13281__$1);

return statearr_13465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13367__$1,(53),inst_13282);
} else {
if((state_val_13368 === (67))){
var inst_13337 = (state_13367[(2)]);
var state_13367__$1 = state_13367;
var statearr_13466_13559 = state_13367__$1;
(statearr_13466_13559[(2)] = inst_13337);

(statearr_13466_13559[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (71))){
var inst_13341 = (state_13367[(9)]);
var state_13367__$1 = state_13367;
var statearr_13467_13560 = state_13367__$1;
(statearr_13467_13560[(2)] = inst_13341);

(statearr_13467_13560[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (42))){
var inst_13256 = (state_13367[(23)]);
var inst_13208 = (state_13367[(37)]);
var inst_13179 = (state_13367[(47)]);
var inst_13190 = (state_13367[(53)]);
var inst_13180 = (state_13367[(48)]);
var inst_13244 = (state_13367[(38)]);
var inst_13173 = (state_13367[(49)]);
var inst_13253 = (state_13367[(54)]);
var inst_13172 = (state_13367[(50)]);
var inst_13199 = (state_13367[(43)]);
var inst_13217 = (state_13367[(17)]);
var inst_13226 = (state_13367[(22)]);
var inst_13235 = (state_13367[(36)]);
var inst_13253__$1 = (state_13367[(2)]);
var inst_13254 = fluree.db.flake.__GT_Flake(inst_13190,inst_13226,inst_13208,inst_13172,inst_13173,inst_13244);
var inst_13255 = fluree.db.flake.__GT_Flake(inst_13199,inst_13235,inst_13217,inst_13179,inst_13180,inst_13253__$1);
var inst_13256__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13367__$1 = (function (){var statearr_13468 = state_13367;
(statearr_13468[(23)] = inst_13256__$1);

(statearr_13468[(54)] = inst_13253__$1);

(statearr_13468[(33)] = inst_13255);

(statearr_13468[(34)] = inst_13254);

return statearr_13468;
})();
if(cljs.core.truth_(inst_13256__$1)){
var statearr_13469_13561 = state_13367__$1;
(statearr_13469_13561[(1)] = (46));

} else {
var statearr_13470_13562 = state_13367__$1;
(statearr_13470_13562[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (37))){
var state_13367__$1 = state_13367;
var statearr_13471_13563 = state_13367__$1;
(statearr_13471_13563[(2)] = fluree.db.util.core.min_integer);

(statearr_13471_13563[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (63))){
var inst_13318 = (state_13367[(39)]);
var inst_13319 = (state_13367[(41)]);
var inst_13260 = (state_13367[(20)]);
var inst_13325 = cljs.core.seq(inst_13318);
var inst_13326 = cljs.core.first(inst_13325);
var inst_13327 = cljs.core.next(inst_13325);
var inst_13328 = (inst_13326 == null);
var inst_13329 = (inst_13319 > inst_13260);
var inst_13330 = ((inst_13328) || (inst_13329));
var state_13367__$1 = (function (){var statearr_13472 = state_13367;
(statearr_13472[(52)] = inst_13327);

return statearr_13472;
})();
if(cljs.core.truth_(inst_13330)){
var statearr_13473_13564 = state_13367__$1;
(statearr_13473_13564[(1)] = (65));

} else {
var statearr_13474_13565 = state_13367__$1;
(statearr_13474_13565[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (8))){
var inst_13176 = (state_13367[(46)]);
var inst_13190 = (state_13367[(2)]);
var inst_13191 = fluree.db.util.core.pred_ident_QMARK_(inst_13176);
var state_13367__$1 = (function (){var statearr_13475 = state_13367;
(statearr_13475[(53)] = inst_13190);

return statearr_13475;
})();
if(inst_13191){
var statearr_13476_13566 = state_13367__$1;
(statearr_13476_13566[(1)] = (10));

} else {
var statearr_13477_13567 = state_13367__$1;
(statearr_13477_13567[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13368 === (49))){
var inst_13266 = (state_13367[(28)]);
var state_13367__$1 = state_13367;
var statearr_13478_13568 = state_13367__$1;
(statearr_13478_13568[(2)] = inst_13266);

(statearr_13478_13568[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_13479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13479[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_13479[(1)] = (1));

return statearr_13479;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_13367){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13367);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13480){var ex__2417__auto__ = e13480;
var statearr_13481_13569 = state_13367;
(statearr_13481_13569[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13367[(4)]))){
var statearr_13482_13570 = state_13367;
(statearr_13482_13570[(1)] = cljs.core.first((state_13367[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13571 = state_13367;
state_13367 = G__13571;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_13367){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_13367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13483 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13483[(6)] = c__2436__auto__);

return statearr_13483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13621){
var state_val_13622 = (state_13621[(1)]);
if((state_val_13622 === (7))){
var state_13621__$1 = state_13621;
var statearr_13623_13642 = state_13621__$1;
(statearr_13623_13642[(2)] = (0));

(statearr_13623_13642[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (1))){
var inst_13579 = subject_groups;
var inst_13580 = cljs.core.seq(inst_13579);
var inst_13581 = cljs.core.first(inst_13580);
var inst_13582 = cljs.core.next(inst_13580);
var inst_13583 = flake_start;
var inst_13584 = subject_start;
var inst_13585 = cljs.core.PersistentVector.EMPTY;
var inst_13586 = inst_13579;
var inst_13587 = inst_13583;
var inst_13588 = inst_13584;
var inst_13589 = inst_13585;
var state_13621__$1 = (function (){var statearr_13624 = state_13621;
(statearr_13624[(7)] = inst_13582);

(statearr_13624[(8)] = inst_13589);

(statearr_13624[(9)] = inst_13586);

(statearr_13624[(10)] = inst_13581);

(statearr_13624[(11)] = inst_13588);

(statearr_13624[(12)] = inst_13587);

return statearr_13624;
})();
var statearr_13625_13643 = state_13621__$1;
(statearr_13625_13643[(2)] = null);

(statearr_13625_13643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (4))){
var inst_13589 = (state_13621[(8)]);
var inst_13588 = (state_13621[(11)]);
var inst_13587 = (state_13621[(12)]);
var inst_13602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13603 = [inst_13587,inst_13588,inst_13589];
var inst_13604 = (new cljs.core.PersistentVector(null,3,(5),inst_13602,inst_13603,null));
var state_13621__$1 = state_13621;
var statearr_13626_13644 = state_13621__$1;
(statearr_13626_13644[(2)] = inst_13604);

(statearr_13626_13644[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (6))){
var inst_13617 = (state_13621[(2)]);
var state_13621__$1 = state_13621;
var statearr_13627_13645 = state_13621__$1;
(statearr_13627_13645[(2)] = inst_13617);

(statearr_13627_13645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (3))){
var inst_13619 = (state_13621[(2)]);
var state_13621__$1 = state_13621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13621__$1,inst_13619);
} else {
if((state_val_13622 === (2))){
var inst_13595 = (state_13621[(13)]);
var inst_13586 = (state_13621[(9)]);
var inst_13588 = (state_13621[(11)]);
var inst_13587 = (state_13621[(12)]);
var inst_13594 = cljs.core.seq(inst_13586);
var inst_13595__$1 = cljs.core.first(inst_13594);
var inst_13596 = cljs.core.next(inst_13594);
var inst_13597 = (inst_13595__$1 == null);
var inst_13598 = (inst_13587 >= flake_limit);
var inst_13599 = (inst_13588 >= subject_limit);
var inst_13600 = ((inst_13597) || (inst_13598) || (inst_13599));
var state_13621__$1 = (function (){var statearr_13628 = state_13621;
(statearr_13628[(13)] = inst_13595__$1);

(statearr_13628[(14)] = inst_13596);

return statearr_13628;
})();
if(cljs.core.truth_(inst_13600)){
var statearr_13629_13646 = state_13621__$1;
(statearr_13629_13646[(1)] = (4));

} else {
var statearr_13630_13647 = state_13621__$1;
(statearr_13630_13647[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (9))){
var inst_13606 = (state_13621[(15)]);
var inst_13589 = (state_13621[(8)]);
var inst_13595 = (state_13621[(13)]);
var inst_13588 = (state_13621[(11)]);
var inst_13596 = (state_13621[(14)]);
var inst_13587 = (state_13621[(12)]);
var inst_13611 = (state_13621[(2)]);
var inst_13612 = (inst_13587 + inst_13606);
var inst_13613 = (inst_13588 + inst_13611);
var inst_13614 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13589,inst_13595);
var inst_13586 = inst_13596;
var inst_13587__$1 = inst_13612;
var inst_13588__$1 = inst_13613;
var inst_13589__$1 = inst_13614;
var state_13621__$1 = (function (){var statearr_13631 = state_13621;
(statearr_13631[(8)] = inst_13589__$1);

(statearr_13631[(9)] = inst_13586);

(statearr_13631[(11)] = inst_13588__$1);

(statearr_13631[(12)] = inst_13587__$1);

return statearr_13631;
})();
var statearr_13632_13648 = state_13621__$1;
(statearr_13632_13648[(2)] = null);

(statearr_13632_13648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (5))){
var inst_13606 = (state_13621[(15)]);
var inst_13595 = (state_13621[(13)]);
var inst_13606__$1 = cljs.core.count(inst_13595);
var inst_13607 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_13606__$1);
var state_13621__$1 = (function (){var statearr_13633 = state_13621;
(statearr_13633[(15)] = inst_13606__$1);

return statearr_13633;
})();
if(inst_13607){
var statearr_13634_13649 = state_13621__$1;
(statearr_13634_13649[(1)] = (7));

} else {
var statearr_13635_13650 = state_13621__$1;
(statearr_13635_13650[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13622 === (8))){
var state_13621__$1 = state_13621;
var statearr_13636_13651 = state_13621__$1;
(statearr_13636_13651[(2)] = (1));

(statearr_13636_13651[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0 = (function (){
var statearr_13637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13637[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__);

(statearr_13637[(1)] = (1));

return statearr_13637;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1 = (function (state_13621){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13621);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13638){var ex__2417__auto__ = e13638;
var statearr_13639_13652 = state_13621;
(statearr_13639_13652[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13621[(4)]))){
var statearr_13640_13653 = state_13621;
(statearr_13640_13653[(1)] = cljs.core.first((state_13621[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13654 = state_13621;
state_13621 = G__13654;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__ = function(state_13621){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1.call(this,state_13621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13641 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13641[(6)] = c__2436__auto__);

return statearr_13641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13700){
var state_val_13701 = (state_13700[(1)]);
if((state_val_13701 === (7))){
var state_13700__$1 = state_13700;
var statearr_13702_13740 = state_13700__$1;
(statearr_13702_13740[(2)] = null);

(statearr_13702_13740[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (20))){
var inst_13686 = (state_13700[(2)]);
var inst_13687 = fluree.db.util.async.throw_err(inst_13686);
var inst_13665 = inst_13687;
var state_13700__$1 = (function (){var statearr_13703 = state_13700;
(statearr_13703[(7)] = inst_13665);

return statearr_13703;
})();
var statearr_13704_13741 = state_13700__$1;
(statearr_13704_13741[(2)] = null);

(statearr_13704_13741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (1))){
var state_13700__$1 = state_13700;
var statearr_13705_13742 = state_13700__$1;
(statearr_13705_13742[(2)] = null);

(statearr_13705_13742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (4))){
var inst_13655 = (state_13700[(2)]);
var state_13700__$1 = state_13700;
var statearr_13706_13743 = state_13700__$1;
(statearr_13706_13743[(2)] = inst_13655);

(statearr_13706_13743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (15))){
var inst_13665 = (state_13700[(7)]);
var inst_13682 = (state_13700[(8)]);
var inst_13682__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_13665);
var state_13700__$1 = (function (){var statearr_13707 = state_13700;
(statearr_13707[(8)] = inst_13682__$1);

return statearr_13707;
})();
if(cljs.core.truth_(inst_13682__$1)){
var statearr_13708_13744 = state_13700__$1;
(statearr_13708_13744[(1)] = (17));

} else {
var statearr_13709_13745 = state_13700__$1;
(statearr_13709_13745[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (13))){
var inst_13675 = (state_13700[(2)]);
var inst_13676 = fluree.db.util.async.throw_err(inst_13675);
var _ = (function (){var statearr_13710 = state_13700;
(statearr_13710[(4)] = cljs.core.rest((state_13700[(4)])));

return statearr_13710;
})();
var state_13700__$1 = state_13700;
var statearr_13711_13746 = state_13700__$1;
(statearr_13711_13746[(2)] = inst_13676);

(statearr_13711_13746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (6))){
var inst_13663 = (state_13700[(2)]);
var inst_13664 = fluree.db.util.async.throw_err(inst_13663);
var inst_13665 = inst_13664;
var state_13700__$1 = (function (){var statearr_13712 = state_13700;
(statearr_13712[(7)] = inst_13665);

return statearr_13712;
})();
var statearr_13713_13747 = state_13700__$1;
(statearr_13713_13747[(2)] = null);

(statearr_13713_13747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (17))){
var inst_13682 = (state_13700[(8)]);
var inst_13684 = fluree.db.dbproto._lookup_leaf(root_node,inst_13682);
var state_13700__$1 = state_13700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13700__$1,(20),inst_13684);
} else {
if((state_val_13701 === (3))){
var inst_13698 = (state_13700[(2)]);
var state_13700__$1 = state_13700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13700__$1,inst_13698);
} else {
if((state_val_13701 === (12))){
var _ = (function (){var statearr_13715 = state_13700;
(statearr_13715[(4)] = cljs.core.rest((state_13700[(4)])));

return statearr_13715;
})();
var state_13700__$1 = state_13700;
var ex13714 = (state_13700__$1[(2)]);
var statearr_13716_13748 = state_13700__$1;
(statearr_13716_13748[(5)] = ex13714);


var statearr_13717_13749 = state_13700__$1;
(statearr_13717_13749[(1)] = (11));

(statearr_13717_13749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (2))){
var _ = (function (){var statearr_13718 = state_13700;
(statearr_13718[(4)] = cljs.core.cons((5),(state_13700[(4)])));

return statearr_13718;
})();
var inst_13661 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_13700__$1 = state_13700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13700__$1,(6),inst_13661);
} else {
if((state_val_13701 === (19))){
var inst_13691 = (state_13700[(2)]);
var state_13700__$1 = state_13700;
var statearr_13719_13750 = state_13700__$1;
(statearr_13719_13750[(2)] = inst_13691);

(statearr_13719_13750[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (11))){
var inst_13667 = (state_13700[(2)]);
var state_13700__$1 = (function (){var statearr_13721 = state_13700;
(statearr_13721[(9)] = inst_13667);

return statearr_13721;
})();
var statearr_13722_13751 = state_13700__$1;
(statearr_13722_13751[(2)] = null);

(statearr_13722_13751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (9))){
var inst_13665 = (state_13700[(7)]);
var _ = (function (){var statearr_13723 = state_13700;
(statearr_13723[(4)] = cljs.core.cons((12),(state_13700[(4)])));

return statearr_13723;
})();
var inst_13673 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_13665,t,novelty,fast_forward_db_QMARK_);
var state_13700__$1 = state_13700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13700__$1,(13),inst_13673);
} else {
if((state_val_13701 === (5))){
var _ = (function (){var statearr_13724 = state_13700;
(statearr_13724[(4)] = cljs.core.rest((state_13700[(4)])));

return statearr_13724;
})();
var state_13700__$1 = state_13700;
var ex13720 = (state_13700__$1[(2)]);
var statearr_13725_13752 = state_13700__$1;
(statearr_13725_13752[(5)] = ex13720);


if((ex13720 instanceof Error)){
var statearr_13726_13753 = state_13700__$1;
(statearr_13726_13753[(1)] = (4));

(statearr_13726_13753[(5)] = null);

} else {
throw ex13720;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (14))){
var inst_13679 = (state_13700[(10)]);
var state_13700__$1 = state_13700;
var statearr_13727_13754 = state_13700__$1;
(statearr_13727_13754[(2)] = inst_13679);

(statearr_13727_13754[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (16))){
var inst_13693 = (state_13700[(2)]);
var state_13700__$1 = state_13700;
var statearr_13728_13755 = state_13700__$1;
(statearr_13728_13755[(2)] = inst_13693);

(statearr_13728_13755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (10))){
var inst_13679 = (state_13700[(10)]);
var inst_13679__$1 = (state_13700[(2)]);
var state_13700__$1 = (function (){var statearr_13729 = state_13700;
(statearr_13729[(10)] = inst_13679__$1);

return statearr_13729;
})();
if(cljs.core.truth_(inst_13679__$1)){
var statearr_13730_13756 = state_13700__$1;
(statearr_13730_13756[(1)] = (14));

} else {
var statearr_13731_13757 = state_13700__$1;
(statearr_13731_13757[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (18))){
var state_13700__$1 = state_13700;
var statearr_13732_13758 = state_13700__$1;
(statearr_13732_13758[(2)] = null);

(statearr_13732_13758[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13701 === (8))){
var inst_13695 = (state_13700[(2)]);
var _ = (function (){var statearr_13733 = state_13700;
(statearr_13733[(4)] = cljs.core.rest((state_13700[(4)])));

return statearr_13733;
})();
var state_13700__$1 = state_13700;
var statearr_13734_13759 = state_13700__$1;
(statearr_13734_13759[(2)] = inst_13695);

(statearr_13734_13759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0 = (function (){
var statearr_13735 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13735[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__);

(statearr_13735[(1)] = (1));

return statearr_13735;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1 = (function (state_13700){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13700);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13736){var ex__2417__auto__ = e13736;
var statearr_13737_13760 = state_13700;
(statearr_13737_13760[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13700[(4)]))){
var statearr_13738_13761 = state_13700;
(statearr_13738_13761[(1)] = cljs.core.first((state_13700[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13762 = state_13700;
state_13700 = G__13762;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__ = function(state_13700){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1.call(this,state_13700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13739 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13739[(6)] = c__2436__auto__);

return statearr_13739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__13769 = arguments.length;
switch (G__13769) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13770 = (function (){var pred__13773 = cljs.core.identical_QMARK_;
var expr__13774 = test;
if(cljs.core.truth_((pred__13773.cljs$core$IFn$_invoke$arity$2 ? pred__13773.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13774) : pred__13773.call(null,cljs.core._EQ_,expr__13774)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13773.cljs$core$IFn$_invoke$arity$2 ? pred__13773.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13774) : pred__13773.call(null,cljs.core._LT_,expr__13774)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13773.cljs$core$IFn$_invoke$arity$2 ? pred__13773.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13774) : pred__13773.call(null,cljs.core._LT__EQ_,expr__13774)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13773.cljs$core$IFn$_invoke$arity$2 ? pred__13773.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13774) : pred__13773.call(null,cljs.core._GT_,expr__13774)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13773.cljs$core$IFn$_invoke$arity$2 ? pred__13773.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13774) : pred__13773.call(null,cljs.core._GT__EQ_,expr__13774)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13774)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13770,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14172){
var state_val_14173 = (state_14172[(1)]);
if((state_val_14173 === (121))){
var inst_14033 = (state_14172[(7)]);
var state_14172__$1 = state_14172;
var statearr_14174_14380 = state_14172__$1;
(statearr_14174_14380[(2)] = inst_14033);

(statearr_14174_14380[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (65))){
var state_14172__$1 = state_14172;
var statearr_14175_14381 = state_14172__$1;
(statearr_14175_14381[(2)] = fluree.db.util.core.min_integer);

(statearr_14175_14381[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (70))){
var state_14172__$1 = state_14172;
var statearr_14176_14382 = state_14172__$1;
(statearr_14176_14382[(2)] = true);

(statearr_14176_14382[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (62))){
var inst_13935 = (cljs.core._LT__EQ_ === end_test);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13935)){
var statearr_14177_14383 = state_14172__$1;
(statearr_14177_14383[(1)] = (64));

} else {
var statearr_14178_14384 = state_14172__$1;
(statearr_14178_14384[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (74))){
var inst_13944 = (state_14172[(8)]);
var state_14172__$1 = state_14172;
var statearr_14179_14385 = state_14172__$1;
(statearr_14179_14385[(2)] = inst_13944);

(statearr_14179_14385[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (110))){
var inst_14075 = (state_14172[(9)]);
var inst_14066 = (state_14172[(10)]);
var inst_14076 = (state_14172[(11)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_14074 = (state_14172[(14)]);
var inst_14074__$1 = cljs.core.count(inst_14066);
var inst_14075__$1 = (inst_13999 + inst_14074__$1);
var inst_14076__$1 = (inst_14075__$1 - inst_13972);
var inst_14077 = cljs.core.pos_int_QMARK_(inst_14076__$1);
var state_14172__$1 = (function (){var statearr_14180 = state_14172;
(statearr_14180[(9)] = inst_14075__$1);

(statearr_14180[(11)] = inst_14076__$1);

(statearr_14180[(14)] = inst_14074__$1);

return statearr_14180;
})();
if(inst_14077){
var statearr_14181_14386 = state_14172__$1;
(statearr_14181_14386[(1)] = (113));

} else {
var statearr_14182_14387 = state_14172__$1;
(statearr_14182_14387[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (130))){
var inst_14135 = (state_14172[(15)]);
var state_14172__$1 = state_14172;
var statearr_14183_14388 = state_14172__$1;
(statearr_14183_14388[(2)] = inst_14135);

(statearr_14183_14388[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (128))){
var inst_14144 = (state_14172[(16)]);
var state_14172__$1 = state_14172;
var statearr_14184_14389 = state_14172__$1;
(statearr_14184_14389[(2)] = inst_14144);

(statearr_14184_14389[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (7))){
var state_14172__$1 = state_14172;
var statearr_14185_14390 = state_14172__$1;
(statearr_14185_14390[(2)] = false);

(statearr_14185_14390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (59))){
var state_14172__$1 = state_14172;
var statearr_14186_14391 = state_14172__$1;
(statearr_14186_14391[(2)] = (2147483647));

(statearr_14186_14391[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (86))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13883 = (state_14172[(19)]);
var inst_13966 = (state_14172[(20)]);
var inst_13833 = (state_14172[(21)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13965 = (state_14172[(24)]);
var inst_13973 = (state_14172[(25)]);
var inst_13832 = (state_14172[(26)]);
var inst_14006 = (state_14172[(27)]);
var inst_13887 = (state_14172[(28)]);
var inst_14000 = (state_14172[(29)]);
var inst_13941 = (state_14172[(30)]);
var inst_13803 = (state_14172[(31)]);
var inst_13974 = (state_14172[(32)]);
var inst_13800 = (state_14172[(33)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_13978 = (state_14172[(35)]);
var inst_13989 = (state_14172[(36)]);
var inst_13884 = (state_14172[(37)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_13896 = (state_14172[(40)]);
var inst_13914 = (state_14172[(41)]);
var inst_13997 = (state_14172[(42)]);
var inst_13942 = (state_14172[(43)]);
var inst_13993 = (state_14172[(44)]);
var inst_13808 = (state_14172[(45)]);
var inst_13996 = (state_14172[(46)]);
var inst_13796 = (state_14172[(47)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13807 = (state_14172[(51)]);
var inst_13943 = (state_14172[(52)]);
var inst_13843 = (state_14172[(53)]);
var inst_14010 = (function (){var no_filter_QMARK_ = true;
var t = inst_13979;
var max_limit_QMARK_ = inst_13973;
var next_node = inst_13996;
var fast_forward_db_QMARK_ = inst_13984;
var s1 = inst_13843;
var o2 = inst_13905;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var i = inst_13998;
var m1 = inst_13932;
var root_node = inst_13989;
var vec__13789 = inst_13883;
var s2 = inst_13852;
var p2 = inst_13923;
var permissions = inst_13974;
var limit = inst_13972;
var start_flake = inst_13942;
var flake_limit = inst_13966;
var offset = inst_13997;
var acc = inst_14000;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var vec__13792 = inst_13884;
var op1 = inst_13801;
var o1 = inst_13896;
var end_flake = inst_13943;
var vec__13782 = inst_13796;
var base_result = inst_14006;
var s = inst_13999;
var node_start = inst_13993;
var p1 = inst_13914;
var subject_fn = inst_13832;
var object_fn = inst_13887;
var G__14007 = inst_14006;
var map__13795 = inst_13965;
var idx_compare = inst_13978;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13941;
var novelty = inst_13983;
return (function (p1__13763_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__13763_SHARP_.o,start_flake.o);
});
})();
var inst_14011 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14010,inst_14006);
var state_14172__$1 = state_14172;
var statearr_14187_14392 = state_14172__$1;
(statearr_14187_14392[(2)] = inst_14011);

(statearr_14187_14392[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (20))){
var inst_13804 = (state_14172[(54)]);
var state_14172__$1 = state_14172;
var statearr_14188_14393 = state_14172__$1;
(statearr_14188_14393[(2)] = inst_13804);

(statearr_14188_14393[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (72))){
var inst_13957 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14189_14394 = state_14172__$1;
(statearr_14189_14394[(2)] = inst_13957);

(statearr_14189_14394[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (58))){
var state_14172__$1 = state_14172;
var statearr_14190_14395 = state_14172__$1;
(statearr_14190_14395[(2)] = fluree.db.util.core.min_integer);

(statearr_14190_14395[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (60))){
var inst_13930 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14191_14396 = state_14172__$1;
(statearr_14191_14396[(2)] = inst_13930);

(statearr_14191_14396[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (27))){
var state_14172__$1 = state_14172;
var statearr_14192_14397 = state_14172__$1;
(statearr_14192_14397[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (1))){
var state_14172__$1 = state_14172;
var statearr_14194_14398 = state_14172__$1;
(statearr_14194_14398[(2)] = null);

(statearr_14194_14398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (69))){
var inst_13960 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13960)){
var statearr_14195_14399 = state_14172__$1;
(statearr_14195_14399[(1)] = (73));

} else {
var statearr_14196_14400 = state_14172__$1;
(statearr_14196_14400[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (101))){
var state_14172__$1 = state_14172;
var statearr_14197_14401 = state_14172__$1;
(statearr_14197_14401[(2)] = true);

(statearr_14197_14401[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (24))){
var inst_13806 = (state_14172[(55)]);
var inst_13856 = cljs.core.boolean_QMARK_(inst_13806);
var state_14172__$1 = state_14172;
if(inst_13856){
var statearr_14198_14402 = state_14172__$1;
(statearr_14198_14402[(1)] = (26));

} else {
var statearr_14199_14403 = state_14172__$1;
(statearr_14199_14403[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (102))){
var state_14172__$1 = state_14172;
var statearr_14200_14404 = state_14172__$1;
(statearr_14200_14404[(2)] = false);

(statearr_14200_14404[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (55))){
var inst_13802 = (state_14172[(56)]);
var state_14172__$1 = state_14172;
var statearr_14201_14405 = state_14172__$1;
(statearr_14201_14405[(2)] = inst_13802);

(statearr_14201_14405[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (85))){
var inst_14164 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14202_14406 = state_14172__$1;
(statearr_14202_14406[(2)] = inst_14164);

(statearr_14202_14406[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (39))){
var inst_13886 = (state_14172[(57)]);
var inst_13899 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13886);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(42),inst_13899);
} else {
if((state_val_14173 === (88))){
var inst_13832 = (state_14172[(26)]);
var inst_14014 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14203 = state_14172;
(statearr_14203[(58)] = inst_14014);

return statearr_14203;
})();
if(cljs.core.truth_(inst_13832)){
var statearr_14204_14407 = state_14172__$1;
(statearr_14204_14407[(1)] = (89));

} else {
var statearr_14205_14408 = state_14172__$1;
(statearr_14205_14408[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (46))){
var state_14172__$1 = state_14172;
var statearr_14206_14409 = state_14172__$1;
(statearr_14206_14409[(2)] = (-1));

(statearr_14206_14409[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (4))){
var inst_13776 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14207_14410 = state_14172__$1;
(statearr_14207_14410[(2)] = inst_13776);

(statearr_14207_14410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (77))){
var state_14172__$1 = state_14172;
var statearr_14208_14411 = state_14172__$1;
(statearr_14208_14411[(2)] = fluree.db.util.core.max_long);

(statearr_14208_14411[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (106))){
var inst_14033 = (state_14172[(7)]);
var inst_14131 = (state_14172[(2)]);
var inst_14132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14131,(0),null);
var inst_14133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14131,(1),null);
var inst_14134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14131,(2),null);
var inst_14135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14131,(3),null);
var state_14172__$1 = (function (){var statearr_14209 = state_14172;
(statearr_14209[(59)] = inst_14134);

(statearr_14209[(60)] = inst_14133);

(statearr_14209[(15)] = inst_14135);

(statearr_14209[(61)] = inst_14132);

return statearr_14209;
})();
if(cljs.core.truth_(inst_14033)){
var statearr_14210_14412 = state_14172__$1;
(statearr_14210_14412[(1)] = (120));

} else {
var statearr_14211_14413 = state_14172__$1;
(statearr_14211_14413[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (119))){
var inst_14117 = (state_14172[(2)]);
var inst_14118 = fluree.db.util.async.throw_err(inst_14117);
var state_14172__$1 = state_14172;
var statearr_14212_14414 = state_14172__$1;
(statearr_14212_14414[(2)] = inst_14118);

(statearr_14212_14414[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (95))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13883 = (state_14172[(19)]);
var inst_13966 = (state_14172[(20)]);
var inst_13833 = (state_14172[(21)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13965 = (state_14172[(24)]);
var inst_13973 = (state_14172[(25)]);
var inst_13832 = (state_14172[(26)]);
var inst_14006 = (state_14172[(27)]);
var inst_13887 = (state_14172[(28)]);
var inst_14000 = (state_14172[(29)]);
var inst_13941 = (state_14172[(30)]);
var inst_13803 = (state_14172[(31)]);
var inst_13974 = (state_14172[(32)]);
var inst_14026 = (state_14172[(62)]);
var inst_13800 = (state_14172[(33)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_13978 = (state_14172[(35)]);
var inst_13989 = (state_14172[(36)]);
var inst_13884 = (state_14172[(37)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_13896 = (state_14172[(40)]);
var inst_13914 = (state_14172[(41)]);
var inst_13997 = (state_14172[(42)]);
var inst_13942 = (state_14172[(43)]);
var inst_13993 = (state_14172[(44)]);
var inst_13808 = (state_14172[(45)]);
var inst_13996 = (state_14172[(46)]);
var inst_13796 = (state_14172[(47)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13807 = (state_14172[(51)]);
var inst_13943 = (state_14172[(52)]);
var inst_13843 = (state_14172[(53)]);
var inst_14028 = (function (){var no_filter_QMARK_ = true;
var t = inst_13979;
var max_limit_QMARK_ = inst_13973;
var next_node = inst_13996;
var fast_forward_db_QMARK_ = inst_13984;
var s1 = inst_13843;
var o2 = inst_13905;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var i = inst_13998;
var m1 = inst_13932;
var root_node = inst_13989;
var vec__13789 = inst_13883;
var s2 = inst_13852;
var p2 = inst_13923;
var permissions = inst_13974;
var limit = inst_13972;
var start_flake = inst_13942;
var flake_limit = inst_13966;
var offset = inst_13997;
var acc = inst_14000;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var vec__13792 = inst_13884;
var op1 = inst_13801;
var o1 = inst_13896;
var end_flake = inst_13943;
var vec__13782 = inst_13796;
var base_result = inst_14006;
var s = inst_13999;
var node_start = inst_13993;
var p1 = inst_13914;
var subject_fn = inst_13832;
var object_fn = inst_13887;
var G__14007 = inst_14026;
var map__13795 = inst_13965;
var idx_compare = inst_13978;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13941;
var novelty = inst_13983;
return (function (p1__13766_SHARP_){
var G__14213 = p1__13766_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__14213) : object_fn.call(null,G__14213));
});
})();
var inst_14029 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14028,inst_14026);
var state_14172__$1 = state_14172;
var statearr_14214_14415 = state_14172__$1;
(statearr_14214_14415[(2)] = inst_14029);

(statearr_14214_14415[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (54))){
var inst_13802 = (state_14172[(56)]);
var inst_13923 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14215 = state_14172;
(statearr_14215[(23)] = inst_13923);

return statearr_14215;
})();
if(cljs.core.truth_(inst_13802)){
var statearr_14216_14416 = state_14172__$1;
(statearr_14216_14416[(1)] = (55));

} else {
var statearr_14217_14417 = state_14172__$1;
(statearr_14217_14417[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (92))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13883 = (state_14172[(19)]);
var inst_13966 = (state_14172[(20)]);
var inst_13833 = (state_14172[(21)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13965 = (state_14172[(24)]);
var inst_13973 = (state_14172[(25)]);
var inst_13832 = (state_14172[(26)]);
var inst_14006 = (state_14172[(27)]);
var inst_13887 = (state_14172[(28)]);
var inst_14000 = (state_14172[(29)]);
var inst_13941 = (state_14172[(30)]);
var inst_13803 = (state_14172[(31)]);
var inst_13974 = (state_14172[(32)]);
var inst_13800 = (state_14172[(33)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_13978 = (state_14172[(35)]);
var inst_13989 = (state_14172[(36)]);
var inst_13884 = (state_14172[(37)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_13896 = (state_14172[(40)]);
var inst_13914 = (state_14172[(41)]);
var inst_13997 = (state_14172[(42)]);
var inst_14020 = (state_14172[(63)]);
var inst_13942 = (state_14172[(43)]);
var inst_13993 = (state_14172[(44)]);
var inst_13808 = (state_14172[(45)]);
var inst_13996 = (state_14172[(46)]);
var inst_13796 = (state_14172[(47)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13807 = (state_14172[(51)]);
var inst_13943 = (state_14172[(52)]);
var inst_13843 = (state_14172[(53)]);
var inst_14022 = (function (){var no_filter_QMARK_ = true;
var t = inst_13979;
var max_limit_QMARK_ = inst_13973;
var next_node = inst_13996;
var fast_forward_db_QMARK_ = inst_13984;
var s1 = inst_13843;
var o2 = inst_13905;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var i = inst_13998;
var m1 = inst_13932;
var root_node = inst_13989;
var vec__13789 = inst_13883;
var s2 = inst_13852;
var p2 = inst_13923;
var permissions = inst_13974;
var limit = inst_13972;
var start_flake = inst_13942;
var flake_limit = inst_13966;
var offset = inst_13997;
var acc = inst_14000;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var vec__13792 = inst_13884;
var op1 = inst_13801;
var o1 = inst_13896;
var end_flake = inst_13943;
var vec__13782 = inst_13796;
var base_result = inst_14006;
var s = inst_13999;
var node_start = inst_13993;
var p1 = inst_13914;
var subject_fn = inst_13832;
var object_fn = inst_13887;
var G__14007 = inst_14020;
var map__13795 = inst_13965;
var idx_compare = inst_13978;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13941;
var novelty = inst_13983;
return (function (p1__13765_SHARP_){
var G__14218 = p1__13765_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14218) : predicate_fn.call(null,G__14218));
});
})();
var inst_14023 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14022,inst_14020);
var state_14172__$1 = state_14172;
var statearr_14219_14418 = state_14172__$1;
(statearr_14219_14418[(2)] = inst_14023);

(statearr_14219_14418[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (104))){
var inst_13966 = (state_14172[(20)]);
var inst_14000 = (state_14172[(29)]);
var inst_13998 = (state_14172[(34)]);
var inst_13999 = (state_14172[(13)]);
var inst_14032 = (state_14172[(64)]);
var inst_14044 = cljs.core.count(inst_14032);
var inst_14045 = (inst_13966 - inst_13998);
var inst_14046 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14045,inst_14032);
var inst_14047 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14000,inst_14046);
var inst_14048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14049 = (inst_13998 + inst_14044);
var inst_14050 = [(0),inst_14049,inst_13999,inst_14047];
var inst_14051 = (new cljs.core.PersistentVector(null,4,(5),inst_14048,inst_14050,null));
var state_14172__$1 = state_14172;
var statearr_14220_14419 = state_14172__$1;
(statearr_14220_14419[(2)] = inst_14051);

(statearr_14220_14419[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (15))){
var inst_13797 = (state_14172[(65)]);
var inst_13837 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13797);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(18),inst_13837);
} else {
if((state_val_14173 === (48))){
var inst_13805 = (state_14172[(66)]);
var inst_13914 = (state_14172[(2)]);
var inst_13915 = (inst_13805 == null);
var state_14172__$1 = (function (){var statearr_14221 = state_14172;
(statearr_14221[(41)] = inst_13914);

return statearr_14221;
})();
if(cljs.core.truth_(inst_13915)){
var statearr_14222_14420 = state_14172__$1;
(statearr_14222_14420[(1)] = (49));

} else {
var statearr_14223_14421 = state_14172__$1;
(statearr_14223_14421[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (50))){
var state_14172__$1 = state_14172;
var statearr_14224_14422 = state_14172__$1;
(statearr_14224_14422[(2)] = false);

(statearr_14224_14422[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (116))){
var inst_13966 = (state_14172[(20)]);
var inst_14093 = (state_14172[(67)]);
var inst_14092 = (state_14172[(68)]);
var inst_14094 = (state_14172[(69)]);
var inst_14097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14098 = (inst_14094 - inst_13966);
var inst_14099 = (inst_14093 - inst_14098);
var inst_14100 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14099,inst_14092);
var inst_14101 = [inst_13966,inst_14100];
var inst_14102 = (new cljs.core.PersistentVector(null,2,(5),inst_14097,inst_14101,null));
var state_14172__$1 = state_14172;
var statearr_14225_14423 = state_14172__$1;
(statearr_14225_14423[(2)] = inst_14102);

(statearr_14225_14423[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (75))){
var inst_13965 = (state_14172[(24)]);
var inst_13967 = (state_14172[(70)]);
var inst_13965__$1 = (state_14172[(2)]);
var inst_13966 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_13965__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_13967__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13965__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_13968 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_13965__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14172__$1 = (function (){var statearr_14226 = state_14172;
(statearr_14226[(20)] = inst_13966);

(statearr_14226[(24)] = inst_13965__$1);

(statearr_14226[(70)] = inst_13967__$1);

(statearr_14226[(71)] = inst_13968);

return statearr_14226;
})();
if(cljs.core.truth_(inst_13967__$1)){
var statearr_14227_14424 = state_14172__$1;
(statearr_14227_14424[(1)] = (76));

} else {
var statearr_14228_14425 = state_14172__$1;
(statearr_14228_14425[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (99))){
var inst_13973 = (state_14172[(25)]);
var state_14172__$1 = state_14172;
var statearr_14229_14426 = state_14172__$1;
(statearr_14229_14426[(2)] = inst_13973);

(statearr_14229_14426[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (21))){
var inst_13799 = (state_14172[(72)]);
var inst_13852 = (state_14172[(2)]);
var inst_13853 = cljs.core.boolean_QMARK_(inst_13799);
var state_14172__$1 = (function (){var statearr_14230 = state_14172;
(statearr_14230[(39)] = inst_13852);

return statearr_14230;
})();
if(inst_13853){
var statearr_14231_14427 = state_14172__$1;
(statearr_14231_14427[(1)] = (23));

} else {
var statearr_14232_14428 = state_14172__$1;
(statearr_14232_14428[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (31))){
var inst_13862 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14233_14429 = state_14172__$1;
(statearr_14233_14429[(2)] = inst_13862);

(statearr_14233_14429[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (113))){
var inst_14076 = (state_14172[(11)]);
var inst_13972 = (state_14172[(12)]);
var inst_14074 = (state_14172[(14)]);
var inst_14079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14080 = (inst_14074 - inst_14076);
var inst_14081 = [inst_13972,inst_14080];
var inst_14082 = (new cljs.core.PersistentVector(null,2,(5),inst_14079,inst_14081,null));
var state_14172__$1 = state_14172;
var statearr_14234_14430 = state_14172__$1;
(statearr_14234_14430[(2)] = inst_14082);

(statearr_14234_14430[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (32))){
var inst_13805 = (state_14172[(66)]);
var inst_13801 = (state_14172[(18)]);
var inst_13802 = (state_14172[(56)]);
var inst_13866 = (state_14172[(73)]);
var inst_13833 = (state_14172[(21)]);
var inst_13809 = (state_14172[(74)]);
var inst_13832 = (state_14172[(26)]);
var inst_13834 = (state_14172[(75)]);
var inst_13798 = (state_14172[(76)]);
var inst_13799 = (state_14172[(72)]);
var inst_13803 = (state_14172[(31)]);
var inst_13800 = (state_14172[(33)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_13808 = (state_14172[(45)]);
var inst_13796 = (state_14172[(47)]);
var inst_13807 = (state_14172[(51)]);
var inst_13806 = (state_14172[(55)]);
var inst_13843 = (state_14172[(53)]);
var inst_13868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13870 = [null,null];
var inst_13871 = (new cljs.core.PersistentVector(null,2,(5),inst_13869,inst_13870,null));
var inst_13872 = (function (){var bool = inst_13866;
var temp__5733__auto__ = inst_13866;
var s1 = inst_13843;
var o2 = inst_13806;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var m1 = inst_13802;
var s2 = inst_13852;
var p2 = inst_13805;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var op1 = inst_13801;
var o1 = inst_13799;
var vec__13782 = inst_13796;
var p1 = inst_13798;
var subject_fn = inst_13832;
var object_fn = inst_13834;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13809;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_13873 = [inst_13871,inst_13872];
var inst_13874 = (new cljs.core.PersistentVector(null,2,(5),inst_13868,inst_13873,null));
var state_14172__$1 = state_14172;
var statearr_14235_14431 = state_14172__$1;
(statearr_14235_14431[(2)] = inst_13874);

(statearr_14235_14431[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (40))){
var inst_13886 = (state_14172[(57)]);
var state_14172__$1 = state_14172;
var statearr_14236_14432 = state_14172__$1;
(statearr_14236_14432[(2)] = inst_13886);

(statearr_14236_14432[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (129))){
var inst_14156 = (state_14172[(2)]);
var inst_14157 = cljs.core.not(inst_14156);
var state_14172__$1 = state_14172;
if(inst_14157){
var statearr_14237_14433 = state_14172__$1;
(statearr_14237_14433[(1)] = (130));

} else {
var statearr_14238_14434 = state_14172__$1;
(statearr_14238_14434[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (91))){
var inst_13833 = (state_14172[(21)]);
var inst_14020 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14239 = state_14172;
(statearr_14239[(63)] = inst_14020);

return statearr_14239;
})();
if(cljs.core.truth_(inst_13833)){
var statearr_14240_14435 = state_14172__$1;
(statearr_14240_14435[(1)] = (92));

} else {
var statearr_14241_14436 = state_14172__$1;
(statearr_14241_14436[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (117))){
var inst_14092 = (state_14172[(68)]);
var inst_14094 = (state_14172[(69)]);
var inst_14104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14105 = [inst_14094,inst_14092];
var inst_14106 = (new cljs.core.PersistentVector(null,2,(5),inst_14104,inst_14105,null));
var state_14172__$1 = state_14172;
var statearr_14242_14437 = state_14172__$1;
(statearr_14242_14437[(2)] = inst_14106);

(statearr_14242_14437[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (108))){
var inst_14054 = (state_14172[(77)]);
var inst_13997 = (state_14172[(42)]);
var inst_14066 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_13997,inst_14054);
var state_14172__$1 = (function (){var statearr_14243 = state_14172;
(statearr_14243[(10)] = inst_14066);

return statearr_14243;
})();
var statearr_14244_14438 = state_14172__$1;
(statearr_14244_14438[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (56))){
var inst_13926 = (cljs.core._GT__EQ_ === start_test);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13926)){
var statearr_14246_14439 = state_14172__$1;
(statearr_14246_14439[(1)] = (58));

} else {
var statearr_14247_14440 = state_14172__$1;
(statearr_14247_14440[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (33))){
var inst_13834 = (state_14172[(75)]);
var inst_13799 = (state_14172[(72)]);
var inst_13806 = (state_14172[(55)]);
var inst_13876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13878 = [inst_13799,inst_13806];
var inst_13879 = (new cljs.core.PersistentVector(null,2,(5),inst_13877,inst_13878,null));
var inst_13880 = [inst_13879,inst_13834];
var inst_13881 = (new cljs.core.PersistentVector(null,2,(5),inst_13876,inst_13880,null));
var state_14172__$1 = state_14172;
var statearr_14248_14441 = state_14172__$1;
(statearr_14248_14441[(2)] = inst_13881);

(statearr_14248_14441[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (13))){
var inst_13810 = (state_14172[(78)]);
var state_14172__$1 = state_14172;
var statearr_14249_14442 = state_14172__$1;
(statearr_14249_14442[(2)] = inst_13810);

(statearr_14249_14442[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (22))){
var inst_13848 = (state_14172[(2)]);
var inst_13849 = fluree.db.util.async.throw_err(inst_13848);
var state_14172__$1 = state_14172;
var statearr_14250_14443 = state_14172__$1;
(statearr_14250_14443[(2)] = inst_13849);

(statearr_14250_14443[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (90))){
var inst_14014 = (state_14172[(58)]);
var state_14172__$1 = state_14172;
var statearr_14251_14444 = state_14172__$1;
(statearr_14251_14444[(2)] = inst_14014);

(statearr_14251_14444[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (109))){
var inst_14129 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14252_14445 = state_14172__$1;
(statearr_14252_14445[(2)] = inst_14129);

(statearr_14252_14445[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (36))){
var inst_13885 = (state_14172[(79)]);
var state_14172__$1 = state_14172;
var statearr_14253_14446 = state_14172__$1;
(statearr_14253_14446[(2)] = inst_13885);

(statearr_14253_14446[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (41))){
var inst_13798 = (state_14172[(76)]);
var inst_13905 = (state_14172[(2)]);
var inst_13906 = (inst_13798 == null);
var state_14172__$1 = (function (){var statearr_14254 = state_14172;
(statearr_14254[(22)] = inst_13905);

return statearr_14254;
})();
if(cljs.core.truth_(inst_13906)){
var statearr_14255_14447 = state_14172__$1;
(statearr_14255_14447[(1)] = (43));

} else {
var statearr_14256_14448 = state_14172__$1;
(statearr_14256_14448[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (118))){
var inst_14089 = (state_14172[(80)]);
var inst_14108 = (state_14172[(2)]);
var inst_14109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14108,(0),null);
var inst_14110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14108,(1),null);
var inst_14111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14112 = [inst_14109,inst_14089,inst_14110];
var inst_14113 = (new cljs.core.PersistentVector(null,3,(5),inst_14111,inst_14112,null));
var state_14172__$1 = state_14172;
var statearr_14257_14449 = state_14172__$1;
(statearr_14257_14449[(2)] = inst_14113);

(statearr_14257_14449[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (89))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13883 = (state_14172[(19)]);
var inst_13966 = (state_14172[(20)]);
var inst_13833 = (state_14172[(21)]);
var inst_14014 = (state_14172[(58)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13965 = (state_14172[(24)]);
var inst_13973 = (state_14172[(25)]);
var inst_13832 = (state_14172[(26)]);
var inst_14006 = (state_14172[(27)]);
var inst_13887 = (state_14172[(28)]);
var inst_14000 = (state_14172[(29)]);
var inst_13941 = (state_14172[(30)]);
var inst_13803 = (state_14172[(31)]);
var inst_13974 = (state_14172[(32)]);
var inst_13800 = (state_14172[(33)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_13978 = (state_14172[(35)]);
var inst_13989 = (state_14172[(36)]);
var inst_13884 = (state_14172[(37)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_13896 = (state_14172[(40)]);
var inst_13914 = (state_14172[(41)]);
var inst_13997 = (state_14172[(42)]);
var inst_13942 = (state_14172[(43)]);
var inst_13993 = (state_14172[(44)]);
var inst_13808 = (state_14172[(45)]);
var inst_13996 = (state_14172[(46)]);
var inst_13796 = (state_14172[(47)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13807 = (state_14172[(51)]);
var inst_13943 = (state_14172[(52)]);
var inst_13843 = (state_14172[(53)]);
var inst_14016 = (function (){var no_filter_QMARK_ = true;
var t = inst_13979;
var max_limit_QMARK_ = inst_13973;
var next_node = inst_13996;
var fast_forward_db_QMARK_ = inst_13984;
var s1 = inst_13843;
var o2 = inst_13905;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var i = inst_13998;
var m1 = inst_13932;
var root_node = inst_13989;
var vec__13789 = inst_13883;
var s2 = inst_13852;
var p2 = inst_13923;
var permissions = inst_13974;
var limit = inst_13972;
var start_flake = inst_13942;
var flake_limit = inst_13966;
var offset = inst_13997;
var acc = inst_14000;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var vec__13792 = inst_13884;
var op1 = inst_13801;
var o1 = inst_13896;
var end_flake = inst_13943;
var vec__13782 = inst_13796;
var base_result = inst_14006;
var s = inst_13999;
var node_start = inst_13993;
var p1 = inst_13914;
var subject_fn = inst_13832;
var object_fn = inst_13887;
var G__14007 = inst_14014;
var map__13795 = inst_13965;
var idx_compare = inst_13978;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13941;
var novelty = inst_13983;
return (function (p1__13764_SHARP_){
var G__14258 = p1__13764_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14258) : subject_fn.call(null,G__14258));
});
})();
var inst_14017 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14016,inst_14014);
var state_14172__$1 = state_14172;
var statearr_14259_14450 = state_14172__$1;
(statearr_14259_14450[(2)] = inst_14017);

(statearr_14259_14450[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (100))){
var inst_14042 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_14042)){
var statearr_14260_14451 = state_14172__$1;
(statearr_14260_14451[(1)] = (104));

} else {
var statearr_14261_14452 = state_14172__$1;
(statearr_14261_14452[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (131))){
var inst_14134 = (state_14172[(59)]);
var inst_14133 = (state_14172[(60)]);
var inst_14152 = (state_14172[(81)]);
var inst_14135 = (state_14172[(15)]);
var inst_14132 = (state_14172[(61)]);
var inst_13996 = inst_14152;
var inst_13997 = inst_14132;
var inst_13998 = inst_14133;
var inst_13999 = inst_14134;
var inst_14000 = inst_14135;
var state_14172__$1 = (function (){var statearr_14262 = state_14172;
(statearr_14262[(29)] = inst_14000);

(statearr_14262[(34)] = inst_13998);

(statearr_14262[(13)] = inst_13999);

(statearr_14262[(42)] = inst_13997);

(statearr_14262[(46)] = inst_13996);

return statearr_14262;
})();
var statearr_14263_14453 = state_14172__$1;
(statearr_14263_14453[(2)] = null);

(statearr_14263_14453[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (122))){
var inst_14144 = (state_14172[(16)]);
var inst_14144__$1 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14264 = state_14172;
(statearr_14264[(16)] = inst_14144__$1);

return statearr_14264;
})();
if(cljs.core.truth_(inst_14144__$1)){
var statearr_14265_14454 = state_14172__$1;
(statearr_14265_14454[(1)] = (123));

} else {
var statearr_14266_14455 = state_14172__$1;
(statearr_14266_14455[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (43))){
var inst_13896 = (state_14172[(40)]);
var state_14172__$1 = state_14172;
var statearr_14267_14456 = state_14172__$1;
(statearr_14267_14456[(2)] = inst_13896);

(statearr_14267_14456[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (61))){
var inst_13809 = (state_14172[(74)]);
var state_14172__$1 = state_14172;
var statearr_14268_14457 = state_14172__$1;
(statearr_14268_14457[(2)] = inst_13809);

(statearr_14268_14457[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (29))){
var state_14172__$1 = state_14172;
var statearr_14269_14458 = state_14172__$1;
(statearr_14269_14458[(2)] = null);

(statearr_14269_14458[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (44))){
var state_14172__$1 = state_14172;
var statearr_14270_14459 = state_14172__$1;
(statearr_14270_14459[(2)] = false);

(statearr_14270_14459[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (93))){
var inst_14020 = (state_14172[(63)]);
var state_14172__$1 = state_14172;
var statearr_14271_14460 = state_14172__$1;
(statearr_14271_14460[(2)] = inst_14020);

(statearr_14271_14460[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (6))){
var inst_13810 = (state_14172[(78)]);
var inst_13815 = inst_13810.cljs$lang$protocol_mask$partition0$;
var inst_13816 = (inst_13815 & (64));
var inst_13817 = inst_13810.cljs$core$ISeq$;
var inst_13818 = (cljs.core.PROTOCOL_SENTINEL === inst_13817);
var inst_13819 = ((inst_13816) || (inst_13818));
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13819)){
var statearr_14272_14461 = state_14172__$1;
(statearr_14272_14461[(1)] = (9));

} else {
var statearr_14273_14462 = state_14172__$1;
(statearr_14273_14462[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (111))){
var inst_13966 = (state_14172[(20)]);
var inst_14066 = (state_14172[(10)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_14115 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14066,inst_13998,inst_13999,inst_13966,inst_13972);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(119),inst_14115);
} else {
if((state_val_14173 === (28))){
var inst_13864 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14274_14463 = state_14172__$1;
(statearr_14274_14463[(2)] = inst_13864);

(statearr_14274_14463[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (64))){
var state_14172__$1 = state_14172;
var statearr_14275_14464 = state_14172__$1;
(statearr_14275_14464[(2)] = (2147483647));

(statearr_14275_14464[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (103))){
var inst_14039 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14276_14465 = state_14172__$1;
(statearr_14276_14465[(2)] = inst_14039);

(statearr_14276_14465[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (51))){
var inst_13919 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13919)){
var statearr_14277_14466 = state_14172__$1;
(statearr_14277_14466[(1)] = (52));

} else {
var statearr_14278_14467 = state_14172__$1;
(statearr_14278_14467[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (25))){
var inst_13866 = (state_14172[(73)]);
var inst_13866__$1 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14279 = state_14172;
(statearr_14279[(73)] = inst_13866__$1);

return statearr_14279;
})();
if(cljs.core.truth_(inst_13866__$1)){
var statearr_14280_14468 = state_14172__$1;
(statearr_14280_14468[(1)] = (32));

} else {
var statearr_14281_14469 = state_14172__$1;
(statearr_14281_14469[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (34))){
var inst_13883 = (state_14172[(19)]);
var inst_13885 = (state_14172[(79)]);
var inst_13884 = (state_14172[(37)]);
var inst_13883__$1 = (state_14172[(2)]);
var inst_13884__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13883__$1,(0),null);
var inst_13885__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13884__$1,(0),null);
var inst_13886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13884__$1,(1),null);
var inst_13887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13883__$1,(1),null);
var inst_13888 = fluree.db.util.core.pred_ident_QMARK_(inst_13885__$1);
var state_14172__$1 = (function (){var statearr_14282 = state_14172;
(statearr_14282[(19)] = inst_13883__$1);

(statearr_14282[(79)] = inst_13885__$1);

(statearr_14282[(28)] = inst_13887);

(statearr_14282[(57)] = inst_13886);

(statearr_14282[(37)] = inst_13884__$1);

return statearr_14282;
})();
if(inst_13888){
var statearr_14283_14470 = state_14172__$1;
(statearr_14283_14470[(1)] = (35));

} else {
var statearr_14284_14471 = state_14172__$1;
(statearr_14284_14471[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (125))){
var inst_14144 = (state_14172[(16)]);
var inst_14152 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14285 = state_14172;
(statearr_14285[(81)] = inst_14152);

return statearr_14285;
})();
if(cljs.core.truth_(inst_14144)){
var statearr_14286_14472 = state_14172__$1;
(statearr_14286_14472[(1)] = (127));

} else {
var statearr_14287_14473 = state_14172__$1;
(statearr_14287_14473[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (17))){
var inst_13804 = (state_14172[(54)]);
var inst_13843 = (state_14172[(2)]);
var inst_13844 = fluree.db.util.core.pred_ident_QMARK_(inst_13804);
var state_14172__$1 = (function (){var statearr_14288 = state_14172;
(statearr_14288[(53)] = inst_13843);

return statearr_14288;
})();
if(inst_13844){
var statearr_14289_14474 = state_14172__$1;
(statearr_14289_14474[(1)] = (19));

} else {
var statearr_14290_14475 = state_14172__$1;
(statearr_14290_14475[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (3))){
var inst_14170 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14172__$1,inst_14170);
} else {
if((state_val_14173 === (12))){
var inst_13810 = (state_14172[(78)]);
var inst_13828 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_13810);
var state_14172__$1 = state_14172;
var statearr_14291_14476 = state_14172__$1;
(statearr_14291_14476[(2)] = inst_13828);

(statearr_14291_14476[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (2))){
var inst_13803 = (state_14172[(31)]);
var inst_13810 = (state_14172[(78)]);
var inst_13796 = (state_14172[(47)]);
var _ = (function (){var statearr_14292 = state_14172;
(statearr_14292[(4)] = cljs.core.cons((5),(state_14172[(4)])));

return statearr_14292;
})();
var inst_13796__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(0),null);
var inst_13798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(1),null);
var inst_13799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(2),null);
var inst_13800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(3),null);
var inst_13801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(4),null);
var inst_13802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13796__$1,(5),null);
var inst_13803__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(0),null);
var inst_13805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(1),null);
var inst_13806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(2),null);
var inst_13807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(3),null);
var inst_13808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(4),null);
var inst_13809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13803__$1,(5),null);
var inst_13810__$1 = opts;
var inst_13812 = (inst_13810__$1 == null);
var inst_13813 = cljs.core.not(inst_13812);
var state_14172__$1 = (function (){var statearr_14293 = state_14172;
(statearr_14293[(66)] = inst_13805);

(statearr_14293[(18)] = inst_13801);

(statearr_14293[(65)] = inst_13797);

(statearr_14293[(56)] = inst_13802);

(statearr_14293[(74)] = inst_13809);

(statearr_14293[(76)] = inst_13798);

(statearr_14293[(72)] = inst_13799);

(statearr_14293[(31)] = inst_13803__$1);

(statearr_14293[(33)] = inst_13800);

(statearr_14293[(54)] = inst_13804);

(statearr_14293[(78)] = inst_13810__$1);

(statearr_14293[(45)] = inst_13808);

(statearr_14293[(47)] = inst_13796__$1);

(statearr_14293[(51)] = inst_13807);

(statearr_14293[(55)] = inst_13806);

return statearr_14293;
})();
if(inst_13813){
var statearr_14294_14477 = state_14172__$1;
(statearr_14294_14477[(1)] = (6));

} else {
var statearr_14295_14478 = state_14172__$1;
(statearr_14295_14478[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (66))){
var inst_13939 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14296_14479 = state_14172__$1;
(statearr_14296_14479[(2)] = inst_13939);

(statearr_14296_14479[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (107))){
var inst_14000 = (state_14172[(29)]);
var inst_13998 = (state_14172[(34)]);
var inst_13999 = (state_14172[(13)]);
var inst_14055 = (state_14172[(82)]);
var inst_13997 = (state_14172[(42)]);
var inst_14058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14059 = (inst_13997 - inst_14055);
var inst_14060 = [inst_14059,inst_13998,inst_13999,inst_14000];
var inst_14061 = (new cljs.core.PersistentVector(null,4,(5),inst_14058,inst_14060,null));
var state_14172__$1 = state_14172;
var statearr_14297_14480 = state_14172__$1;
(statearr_14297_14480[(2)] = inst_14061);

(statearr_14297_14480[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (23))){
var inst_13799 = (state_14172[(72)]);
var state_14172__$1 = state_14172;
var statearr_14298_14481 = state_14172__$1;
(statearr_14298_14481[(2)] = inst_13799);

(statearr_14298_14481[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (47))){
var inst_13798 = (state_14172[(76)]);
var state_14172__$1 = state_14172;
var statearr_14299_14482 = state_14172__$1;
(statearr_14299_14482[(2)] = inst_13798);

(statearr_14299_14482[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (35))){
var inst_13885 = (state_14172[(79)]);
var inst_13890 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13885);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(38),inst_13890);
} else {
if((state_val_14173 === (127))){
var inst_14152 = (state_14172[(81)]);
var state_14172__$1 = state_14172;
var statearr_14300_14483 = state_14172__$1;
(statearr_14300_14483[(2)] = inst_14152);

(statearr_14300_14483[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (82))){
var state_14172__$1 = state_14172;
var statearr_14301_14484 = state_14172__$1;
(statearr_14301_14484[(2)] = null);

(statearr_14301_14484[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (76))){
var inst_13967 = (state_14172[(70)]);
var state_14172__$1 = state_14172;
var statearr_14302_14485 = state_14172__$1;
(statearr_14302_14485[(2)] = inst_13967);

(statearr_14302_14485[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (97))){
var inst_13973 = (state_14172[(25)]);
var inst_13996 = (state_14172[(46)]);
var inst_14032 = (state_14172[(2)]);
var inst_14033 = fluree.db.dbproto._rhs(inst_13996);
var state_14172__$1 = (function (){var statearr_14303 = state_14172;
(statearr_14303[(64)] = inst_14032);

(statearr_14303[(7)] = inst_14033);

return statearr_14303;
})();
if(cljs.core.truth_(inst_13973)){
var statearr_14304_14486 = state_14172__$1;
(statearr_14304_14486[(1)] = (98));

} else {
var statearr_14305_14487 = state_14172__$1;
(statearr_14305_14487[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (19))){
var inst_13804 = (state_14172[(54)]);
var inst_13846 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13804);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(22),inst_13846);
} else {
if((state_val_14173 === (57))){
var inst_13809 = (state_14172[(74)]);
var inst_13932 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14306 = state_14172;
(statearr_14306[(17)] = inst_13932);

return statearr_14306;
})();
if(cljs.core.truth_(inst_13809)){
var statearr_14307_14488 = state_14172__$1;
(statearr_14307_14488[(1)] = (61));

} else {
var statearr_14308_14489 = state_14172__$1;
(statearr_14308_14489[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (68))){
var state_14172__$1 = state_14172;
var statearr_14309_14490 = state_14172__$1;
(statearr_14309_14490[(2)] = false);

(statearr_14309_14490[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (11))){
var inst_13823 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14310_14491 = state_14172__$1;
(statearr_14310_14491[(2)] = inst_13823);

(statearr_14310_14491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (115))){
var inst_13966 = (state_14172[(20)]);
var inst_14093 = (state_14172[(67)]);
var inst_14066 = (state_14172[(10)]);
var inst_13998 = (state_14172[(34)]);
var inst_14092 = (state_14172[(68)]);
var inst_14094 = (state_14172[(69)]);
var inst_14088 = (state_14172[(2)]);
var inst_14089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14088,(0),null);
var inst_14090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14088,(1),null);
var inst_14091 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14090,inst_14066);
var inst_14092__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14091);
var inst_14093__$1 = cljs.core.count(inst_14092__$1);
var inst_14094__$1 = (inst_13998 + inst_14093__$1);
var inst_14095 = (inst_14094__$1 > inst_13966);
var state_14172__$1 = (function (){var statearr_14312 = state_14172;
(statearr_14312[(67)] = inst_14093__$1);

(statearr_14312[(80)] = inst_14089);

(statearr_14312[(68)] = inst_14092__$1);

(statearr_14312[(69)] = inst_14094__$1);

return statearr_14312;
})();
if(cljs.core.truth_(inst_14095)){
var statearr_14313_14492 = state_14172__$1;
(statearr_14313_14492[(1)] = (116));

} else {
var statearr_14314_14493 = state_14172__$1;
(statearr_14314_14493[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (9))){
var state_14172__$1 = state_14172;
var statearr_14315_14494 = state_14172__$1;
(statearr_14315_14494[(2)] = true);

(statearr_14315_14494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (5))){
var _ = (function (){var statearr_14316 = state_14172;
(statearr_14316[(4)] = cljs.core.rest((state_14172[(4)])));

return statearr_14316;
})();
var state_14172__$1 = state_14172;
var ex14311 = (state_14172__$1[(2)]);
var statearr_14317_14495 = state_14172__$1;
(statearr_14317_14495[(5)] = ex14311);


if((ex14311 instanceof Error)){
var statearr_14318_14496 = state_14172__$1;
(statearr_14318_14496[(1)] = (4));

(statearr_14318_14496[(5)] = null);

} else {
throw ex14311;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (112))){
var inst_14000 = (state_14172[(29)]);
var inst_14120 = (state_14172[(2)]);
var inst_14121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14120,(0),null);
var inst_14122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14120,(1),null);
var inst_14123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14120,(2),null);
var inst_14124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14125 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14000,inst_14123);
var inst_14126 = [(0),inst_14121,inst_14122,inst_14125];
var inst_14127 = (new cljs.core.PersistentVector(null,4,(5),inst_14124,inst_14126,null));
var state_14172__$1 = state_14172;
var statearr_14319_14497 = state_14172__$1;
(statearr_14319_14497[(2)] = inst_14127);

(statearr_14319_14497[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (83))){
var inst_14167 = (state_14172[(2)]);
var _ = (function (){var statearr_14320 = state_14172;
(statearr_14320[(4)] = cljs.core.rest((state_14172[(4)])));

return statearr_14320;
})();
var state_14172__$1 = state_14172;
var statearr_14321_14498 = state_14172__$1;
(statearr_14321_14498[(2)] = inst_14167);

(statearr_14321_14498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (14))){
var inst_13797 = (state_14172[(65)]);
var inst_13831 = (state_14172[(38)]);
var inst_13831__$1 = (state_14172[(2)]);
var inst_13832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13831__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_13833 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13831__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_13834 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13831__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_13835 = fluree.db.util.core.pred_ident_QMARK_(inst_13797);
var state_14172__$1 = (function (){var statearr_14322 = state_14172;
(statearr_14322[(21)] = inst_13833);

(statearr_14322[(26)] = inst_13832);

(statearr_14322[(75)] = inst_13834);

(statearr_14322[(38)] = inst_13831__$1);

return statearr_14322;
})();
if(inst_13835){
var statearr_14323_14499 = state_14172__$1;
(statearr_14323_14499[(1)] = (15));

} else {
var statearr_14324_14500 = state_14172__$1;
(statearr_14324_14500[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (45))){
var inst_13910 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13910)){
var statearr_14325_14501 = state_14172__$1;
(statearr_14325_14501[(1)] = (46));

} else {
var statearr_14326_14502 = state_14172__$1;
(statearr_14326_14502[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (53))){
var inst_13805 = (state_14172[(66)]);
var state_14172__$1 = state_14172;
var statearr_14327_14503 = state_14172__$1;
(statearr_14327_14503[(2)] = inst_13805);

(statearr_14327_14503[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (78))){
var inst_13972 = (state_14172[(12)]);
var inst_13972__$1 = (state_14172[(2)]);
var inst_13973 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13972__$1,fluree.db.util.core.max_long);
var inst_13974 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13976 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13977 = (new cljs.core.PersistentVector(null,3,(5),inst_13975,inst_13976,null));
var inst_13978 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13977);
var inst_13979 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_13980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13981 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13982 = (new cljs.core.PersistentVector(null,2,(5),inst_13980,inst_13981,null));
var inst_13983 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13982);
var inst_13984 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_13985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13986 = fluree.db.dbproto._resolve(inst_13985);
var state_14172__$1 = (function (){var statearr_14328 = state_14172;
(statearr_14328[(25)] = inst_13973);

(statearr_14328[(32)] = inst_13974);

(statearr_14328[(12)] = inst_13972__$1);

(statearr_14328[(35)] = inst_13978);

(statearr_14328[(48)] = inst_13979);

(statearr_14328[(49)] = inst_13983);

(statearr_14328[(50)] = inst_13984);

return statearr_14328;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(79),inst_13986);
} else {
if((state_val_14173 === (132))){
var inst_14162 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
var statearr_14329_14504 = state_14172__$1;
(statearr_14329_14504[(2)] = inst_14162);

(statearr_14329_14504[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (26))){
var inst_13806 = (state_14172[(55)]);
var state_14172__$1 = state_14172;
var statearr_14330_14505 = state_14172__$1;
(statearr_14330_14505[(2)] = inst_13806);

(statearr_14330_14505[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (123))){
var inst_13989 = (state_14172[(36)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_14033 = (state_14172[(7)]);
var inst_14146 = fluree.db.query.range.find_next_valid_node(inst_13989,inst_14033,inst_13979,inst_13983,inst_13984);
var state_14172__$1 = state_14172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(126),inst_14146);
} else {
if((state_val_14173 === (16))){
var inst_13797 = (state_14172[(65)]);
var state_14172__$1 = state_14172;
var statearr_14331_14506 = state_14172__$1;
(statearr_14331_14506[(2)] = inst_13797);

(statearr_14331_14506[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (81))){
var inst_13993 = (state_14172[(44)]);
var inst_13968 = (state_14172[(71)]);
var inst_13995 = cljs.core.PersistentVector.EMPTY;
var inst_13996 = inst_13993;
var inst_13997 = inst_13968;
var inst_13998 = (0);
var inst_13999 = (0);
var inst_14000 = inst_13995;
var state_14172__$1 = (function (){var statearr_14332 = state_14172;
(statearr_14332[(29)] = inst_14000);

(statearr_14332[(34)] = inst_13998);

(statearr_14332[(13)] = inst_13999);

(statearr_14332[(42)] = inst_13997);

(statearr_14332[(46)] = inst_13996);

return statearr_14332;
})();
var statearr_14333_14507 = state_14172__$1;
(statearr_14333_14507[(2)] = null);

(statearr_14333_14507[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (120))){
var inst_13966 = (state_14172[(20)]);
var inst_14134 = (state_14172[(59)]);
var inst_14133 = (state_14172[(60)]);
var inst_13972 = (state_14172[(12)]);
var inst_13978 = (state_14172[(35)]);
var inst_13943 = (state_14172[(52)]);
var inst_14033 = (state_14172[(7)]);
var inst_14137 = (inst_13978.cljs$core$IFn$_invoke$arity$2 ? inst_13978.cljs$core$IFn$_invoke$arity$2(inst_14033,inst_13943) : inst_13978.call(null,inst_14033,inst_13943));
var inst_14138 = (inst_14137 < (0));
var inst_14139 = (inst_14133 < inst_13966);
var inst_14140 = (inst_14134 < inst_13972);
var inst_14141 = ((inst_14138) && (inst_14139) && (inst_14140));
var state_14172__$1 = state_14172;
var statearr_14334_14508 = state_14172__$1;
(statearr_14334_14508[(2)] = inst_14141);

(statearr_14334_14508[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (79))){
var inst_13989 = (state_14172[(36)]);
var inst_13942 = (state_14172[(43)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13988 = (state_14172[(2)]);
var inst_13989__$1 = fluree.db.util.async.throw_err(inst_13988);
var inst_13990 = fluree.db.query.range.find_next_valid_node(inst_13989__$1,inst_13942,inst_13979,inst_13983,inst_13984);
var state_14172__$1 = (function (){var statearr_14335 = state_14172;
(statearr_14335[(36)] = inst_13989__$1);

return statearr_14335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14172__$1,(80),inst_13990);
} else {
if((state_val_14173 === (38))){
var inst_13892 = (state_14172[(2)]);
var inst_13893 = fluree.db.util.async.throw_err(inst_13892);
var state_14172__$1 = state_14172;
var statearr_14336_14509 = state_14172__$1;
(statearr_14336_14509[(2)] = inst_13893);

(statearr_14336_14509[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (126))){
var inst_14148 = (state_14172[(2)]);
var inst_14149 = fluree.db.util.async.throw_err(inst_14148);
var state_14172__$1 = state_14172;
var statearr_14337_14510 = state_14172__$1;
(statearr_14337_14510[(2)] = inst_14149);

(statearr_14337_14510[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (98))){
var inst_13997 = (state_14172[(42)]);
var inst_14035 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_13997);
var state_14172__$1 = state_14172;
if(inst_14035){
var statearr_14338_14511 = state_14172__$1;
(statearr_14338_14511[(1)] = (101));

} else {
var statearr_14339_14512 = state_14172__$1;
(statearr_14339_14512[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (124))){
var state_14172__$1 = state_14172;
var statearr_14340_14513 = state_14172__$1;
(statearr_14340_14513[(2)] = null);

(statearr_14340_14513[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (87))){
var inst_14006 = (state_14172[(27)]);
var state_14172__$1 = state_14172;
var statearr_14341_14514 = state_14172__$1;
(statearr_14341_14514[(2)] = inst_14006);

(statearr_14341_14514[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (30))){
var state_14172__$1 = state_14172;
var statearr_14342_14515 = state_14172__$1;
(statearr_14342_14515[(2)] = null);

(statearr_14342_14515[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (73))){
var inst_13944 = (state_14172[(8)]);
var inst_13962 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_13944);
var state_14172__$1 = state_14172;
var statearr_14343_14516 = state_14172__$1;
(statearr_14343_14516[(2)] = inst_13962);

(statearr_14343_14516[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (96))){
var inst_14026 = (state_14172[(62)]);
var state_14172__$1 = state_14172;
var statearr_14344_14517 = state_14172__$1;
(statearr_14344_14517[(2)] = inst_14026);

(statearr_14344_14517[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (10))){
var state_14172__$1 = state_14172;
var statearr_14345_14518 = state_14172__$1;
(statearr_14345_14518[(2)] = false);

(statearr_14345_14518[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (18))){
var inst_13839 = (state_14172[(2)]);
var inst_13840 = fluree.db.util.async.throw_err(inst_13839);
var state_14172__$1 = state_14172;
var statearr_14346_14519 = state_14172__$1;
(statearr_14346_14519[(2)] = inst_13840);

(statearr_14346_14519[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (105))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13883 = (state_14172[(19)]);
var inst_13966 = (state_14172[(20)]);
var inst_13833 = (state_14172[(21)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13965 = (state_14172[(24)]);
var inst_13973 = (state_14172[(25)]);
var inst_13832 = (state_14172[(26)]);
var inst_14006 = (state_14172[(27)]);
var inst_13887 = (state_14172[(28)]);
var inst_14000 = (state_14172[(29)]);
var inst_13941 = (state_14172[(30)]);
var inst_13803 = (state_14172[(31)]);
var inst_13974 = (state_14172[(32)]);
var inst_14054 = (state_14172[(77)]);
var inst_13800 = (state_14172[(33)]);
var inst_13998 = (state_14172[(34)]);
var inst_13972 = (state_14172[(12)]);
var inst_13999 = (state_14172[(13)]);
var inst_13978 = (state_14172[(35)]);
var inst_13989 = (state_14172[(36)]);
var inst_13884 = (state_14172[(37)]);
var inst_13831 = (state_14172[(38)]);
var inst_13852 = (state_14172[(39)]);
var inst_14032 = (state_14172[(64)]);
var inst_13896 = (state_14172[(40)]);
var inst_14055 = (state_14172[(82)]);
var inst_13914 = (state_14172[(41)]);
var inst_13997 = (state_14172[(42)]);
var inst_13942 = (state_14172[(43)]);
var inst_13993 = (state_14172[(44)]);
var inst_13808 = (state_14172[(45)]);
var inst_13996 = (state_14172[(46)]);
var inst_13796 = (state_14172[(47)]);
var inst_13979 = (state_14172[(48)]);
var inst_13983 = (state_14172[(49)]);
var inst_13984 = (state_14172[(50)]);
var inst_13807 = (state_14172[(51)]);
var inst_13943 = (state_14172[(52)]);
var inst_13843 = (state_14172[(53)]);
var inst_14033 = (state_14172[(7)]);
var inst_14053 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_14032;
var t = inst_13979;
var max_limit_QMARK_ = inst_13973;
var next_node = inst_13996;
var fast_forward_db_QMARK_ = inst_13984;
var s1 = inst_13843;
var o2 = inst_13905;
var t1 = inst_13800;
var predicate_fn = inst_13833;
var i = inst_13998;
var rhs = inst_14033;
var m1 = inst_13932;
var root_node = inst_13989;
var vec__13789 = inst_13883;
var s2 = inst_13852;
var p2 = inst_13923;
var permissions = inst_13974;
var limit = inst_13972;
var start_flake = inst_13942;
var flake_limit = inst_13966;
var offset = inst_13997;
var acc = inst_14000;
var vec__13785 = inst_13803;
var t2 = inst_13807;
var vec__13792 = inst_13884;
var op1 = inst_13801;
var o1 = inst_13896;
var end_flake = inst_13943;
var vec__13782 = inst_13796;
var base_result = inst_14006;
var s = inst_13999;
var node_start = inst_13993;
var p1 = inst_13914;
var subject_fn = inst_13832;
var object_fn = inst_13887;
var map__13795 = inst_13965;
var idx_compare = inst_13978;
var map__13788 = inst_13831;
var op2 = inst_13808;
var m2 = inst_13941;
var novelty = inst_13983;
return (function (p1__13767_SHARP_){
return p1__13767_SHARP_.s;
});
})();
var inst_14054__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14053,inst_14032);
var inst_14055__$1 = cljs.core.count(inst_14054__$1);
var inst_14056 = (inst_13997 > inst_14055__$1);
var state_14172__$1 = (function (){var statearr_14347 = state_14172;
(statearr_14347[(77)] = inst_14054__$1);

(statearr_14347[(82)] = inst_14055__$1);

return statearr_14347;
})();
if(cljs.core.truth_(inst_14056)){
var statearr_14348_14520 = state_14172__$1;
(statearr_14348_14520[(1)] = (107));

} else {
var statearr_14349_14521 = state_14172__$1;
(statearr_14349_14521[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (52))){
var state_14172__$1 = state_14172;
var statearr_14350_14522 = state_14172__$1;
(statearr_14350_14522[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14350_14522[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (114))){
var inst_14075 = (state_14172[(9)]);
var inst_14084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14085 = [inst_14075,inst_14075];
var inst_14086 = (new cljs.core.PersistentVector(null,2,(5),inst_14084,inst_14085,null));
var state_14172__$1 = state_14172;
var statearr_14351_14523 = state_14172__$1;
(statearr_14351_14523[(2)] = inst_14086);

(statearr_14351_14523[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (67))){
var inst_13944 = (state_14172[(8)]);
var inst_13949 = inst_13944.cljs$lang$protocol_mask$partition0$;
var inst_13950 = (inst_13949 & (64));
var inst_13951 = inst_13944.cljs$core$ISeq$;
var inst_13952 = (cljs.core.PROTOCOL_SENTINEL === inst_13951);
var inst_13953 = ((inst_13950) || (inst_13952));
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13953)){
var statearr_14352_14524 = state_14172__$1;
(statearr_14352_14524[(1)] = (70));

} else {
var statearr_14353_14525 = state_14172__$1;
(statearr_14353_14525[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (71))){
var state_14172__$1 = state_14172;
var statearr_14354_14526 = state_14172__$1;
(statearr_14354_14526[(2)] = false);

(statearr_14354_14526[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (42))){
var inst_13901 = (state_14172[(2)]);
var inst_13902 = fluree.db.util.async.throw_err(inst_13901);
var state_14172__$1 = state_14172;
var statearr_14355_14527 = state_14172__$1;
(statearr_14355_14527[(2)] = inst_13902);

(statearr_14355_14527[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (80))){
var inst_13993 = (state_14172[(44)]);
var inst_13992 = (state_14172[(2)]);
var inst_13993__$1 = fluree.db.util.async.throw_err(inst_13992);
var state_14172__$1 = (function (){var statearr_14356 = state_14172;
(statearr_14356[(44)] = inst_13993__$1);

return statearr_14356;
})();
if(cljs.core.truth_(inst_13993__$1)){
var statearr_14357_14528 = state_14172__$1;
(statearr_14357_14528[(1)] = (81));

} else {
var statearr_14358_14529 = state_14172__$1;
(statearr_14358_14529[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (37))){
var inst_13886 = (state_14172[(57)]);
var inst_13896 = (state_14172[(2)]);
var inst_13897 = fluree.db.util.core.pred_ident_QMARK_(inst_13886);
var state_14172__$1 = (function (){var statearr_14359 = state_14172;
(statearr_14359[(40)] = inst_13896);

return statearr_14359;
})();
if(inst_13897){
var statearr_14360_14530 = state_14172__$1;
(statearr_14360_14530[(1)] = (39));

} else {
var statearr_14361_14531 = state_14172__$1;
(statearr_14361_14531[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (63))){
var inst_13932 = (state_14172[(17)]);
var inst_13801 = (state_14172[(18)]);
var inst_13905 = (state_14172[(22)]);
var inst_13923 = (state_14172[(23)]);
var inst_13941 = (state_14172[(30)]);
var inst_13944 = (state_14172[(8)]);
var inst_13800 = (state_14172[(33)]);
var inst_13852 = (state_14172[(39)]);
var inst_13896 = (state_14172[(40)]);
var inst_13914 = (state_14172[(41)]);
var inst_13808 = (state_14172[(45)]);
var inst_13807 = (state_14172[(51)]);
var inst_13843 = (state_14172[(53)]);
var inst_13941__$1 = (state_14172[(2)]);
var inst_13942 = fluree.db.flake.__GT_Flake(inst_13843,inst_13914,inst_13896,inst_13800,inst_13801,inst_13932);
var inst_13943 = fluree.db.flake.__GT_Flake(inst_13852,inst_13923,inst_13905,inst_13807,inst_13808,inst_13941__$1);
var inst_13944__$1 = opts;
var inst_13946 = (inst_13944__$1 == null);
var inst_13947 = cljs.core.not(inst_13946);
var state_14172__$1 = (function (){var statearr_14362 = state_14172;
(statearr_14362[(30)] = inst_13941__$1);

(statearr_14362[(8)] = inst_13944__$1);

(statearr_14362[(43)] = inst_13942);

(statearr_14362[(52)] = inst_13943);

return statearr_14362;
})();
if(inst_13947){
var statearr_14363_14532 = state_14172__$1;
(statearr_14363_14532[(1)] = (67));

} else {
var statearr_14364_14533 = state_14172__$1;
(statearr_14364_14533[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (94))){
var inst_13887 = (state_14172[(28)]);
var inst_14026 = (state_14172[(2)]);
var state_14172__$1 = (function (){var statearr_14365 = state_14172;
(statearr_14365[(62)] = inst_14026);

return statearr_14365;
})();
if(cljs.core.truth_(inst_13887)){
var statearr_14366_14534 = state_14172__$1;
(statearr_14366_14534[(1)] = (95));

} else {
var statearr_14367_14535 = state_14172__$1;
(statearr_14367_14535[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (8))){
var inst_13826 = (state_14172[(2)]);
var state_14172__$1 = state_14172;
if(cljs.core.truth_(inst_13826)){
var statearr_14368_14536 = state_14172__$1;
(statearr_14368_14536[(1)] = (12));

} else {
var statearr_14369_14537 = state_14172__$1;
(statearr_14369_14537[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (49))){
var inst_13905 = (state_14172[(22)]);
var state_14172__$1 = state_14172;
var statearr_14370_14538 = state_14172__$1;
(statearr_14370_14538[(2)] = inst_13905);

(statearr_14370_14538[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14173 === (84))){
var inst_13942 = (state_14172[(43)]);
var inst_13996 = (state_14172[(46)]);
var inst_13943 = (state_14172[(52)]);
var inst_14005 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_13996);
var inst_14006 = fluree.db.flake.subrange(inst_14005,start_test,inst_13942,end_test,inst_13943);
var inst_14008 = fluree.db.query.range.value_with_nil_pred(idx,inst_13942,inst_13943);
var state_14172__$1 = (function (){var statearr_14371 = state_14172;
(statearr_14371[(27)] = inst_14006);

return statearr_14371;
})();
if(inst_14008){
var statearr_14372_14539 = state_14172__$1;
(statearr_14372_14539[(1)] = (86));

} else {
var statearr_14373_14540 = state_14172__$1;
(statearr_14373_14540[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_14374 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14374[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_14374[(1)] = (1));

return statearr_14374;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_14172){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14172);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14375){var ex__2417__auto__ = e14375;
var statearr_14376_14541 = state_14172;
(statearr_14376_14541[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14172[(4)]))){
var statearr_14377_14542 = state_14172;
(statearr_14377_14542[(1)] = cljs.core.first((state_14172[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14543 = state_14172;
state_14172 = G__14543;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_14172){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_14172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14378 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14378[(6)] = c__2436__auto__);

return statearr_14378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14599){
var state_val_14600 = (state_14599[(1)]);
if((state_val_14600 === (7))){
var inst_14563 = (state_14599[(7)]);
var inst_14573 = (state_14599[(8)]);
var inst_14571 = fluree.db.flake.Flake__GT_parts(inst_14563);
var inst_14572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(0),null);
var inst_14573__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(1),null);
var inst_14574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(2),null);
var inst_14575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(3),null);
var inst_14576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(4),null);
var inst_14577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14571,(5),null);
var inst_14578 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_14574,inst_14573__$1);
var state_14599__$1 = (function (){var statearr_14601 = state_14599;
(statearr_14601[(9)] = inst_14575);

(statearr_14601[(10)] = inst_14577);

(statearr_14601[(11)] = inst_14572);

(statearr_14601[(12)] = inst_14576);

(statearr_14601[(8)] = inst_14573__$1);

return statearr_14601;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14599__$1,(10),inst_14578);
} else {
if((state_val_14600 === (1))){
var inst_14551 = flakes;
var inst_14552 = cljs.core.seq(inst_14551);
var inst_14553 = cljs.core.first(inst_14552);
var inst_14554 = cljs.core.next(inst_14552);
var inst_14555 = cljs.core.PersistentVector.EMPTY;
var inst_14556 = inst_14551;
var inst_14557 = inst_14555;
var state_14599__$1 = (function (){var statearr_14602 = state_14599;
(statearr_14602[(13)] = inst_14557);

(statearr_14602[(14)] = inst_14553);

(statearr_14602[(15)] = inst_14554);

(statearr_14602[(16)] = inst_14556);

return statearr_14602;
})();
var statearr_14603_14621 = state_14599__$1;
(statearr_14603_14621[(2)] = null);

(statearr_14603_14621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (4))){
var inst_14563 = (state_14599[(7)]);
var inst_14566 = fluree.db.query.range.is_tag_flake_QMARK_(inst_14563);
var state_14599__$1 = state_14599;
if(inst_14566){
var statearr_14604_14622 = state_14599__$1;
(statearr_14604_14622[(1)] = (7));

} else {
var statearr_14605_14623 = state_14599__$1;
(statearr_14605_14623[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (6))){
var inst_14595 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14606_14624 = state_14599__$1;
(statearr_14606_14624[(2)] = inst_14595);

(statearr_14606_14624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (3))){
var inst_14597 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14599__$1,inst_14597);
} else {
if((state_val_14600 === (2))){
var inst_14563 = (state_14599[(7)]);
var inst_14556 = (state_14599[(16)]);
var inst_14562 = cljs.core.seq(inst_14556);
var inst_14563__$1 = cljs.core.first(inst_14562);
var inst_14564 = cljs.core.next(inst_14562);
var state_14599__$1 = (function (){var statearr_14607 = state_14599;
(statearr_14607[(17)] = inst_14564);

(statearr_14607[(7)] = inst_14563__$1);

return statearr_14607;
})();
if(cljs.core.truth_(inst_14563__$1)){
var statearr_14608_14625 = state_14599__$1;
(statearr_14608_14625[(1)] = (4));

} else {
var statearr_14609_14626 = state_14599__$1;
(statearr_14609_14626[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (9))){
var inst_14592 = (state_14599[(2)]);
var state_14599__$1 = state_14599;
var statearr_14610_14627 = state_14599__$1;
(statearr_14610_14627[(2)] = inst_14592);

(statearr_14610_14627[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (5))){
var inst_14557 = (state_14599[(13)]);
var state_14599__$1 = state_14599;
var statearr_14611_14628 = state_14599__$1;
(statearr_14611_14628[(2)] = inst_14557);

(statearr_14611_14628[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (10))){
var inst_14557 = (state_14599[(13)]);
var inst_14575 = (state_14599[(9)]);
var inst_14564 = (state_14599[(17)]);
var inst_14577 = (state_14599[(10)]);
var inst_14572 = (state_14599[(11)]);
var inst_14576 = (state_14599[(12)]);
var inst_14573 = (state_14599[(8)]);
var inst_14580 = (state_14599[(2)]);
var inst_14581 = fluree.db.util.async.throw_err(inst_14580);
var inst_14582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14583 = [inst_14572,inst_14573,inst_14581,inst_14575,inst_14576,inst_14577];
var inst_14584 = (new cljs.core.PersistentVector(null,6,(5),inst_14582,inst_14583,null));
var inst_14585 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_14584);
var inst_14586 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14557,inst_14585);
var inst_14556 = inst_14564;
var inst_14557__$1 = inst_14586;
var state_14599__$1 = (function (){var statearr_14612 = state_14599;
(statearr_14612[(13)] = inst_14557__$1);

(statearr_14612[(16)] = inst_14556);

return statearr_14612;
})();
var statearr_14613_14629 = state_14599__$1;
(statearr_14613_14629[(2)] = null);

(statearr_14613_14629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14600 === (8))){
var inst_14557 = (state_14599[(13)]);
var inst_14564 = (state_14599[(17)]);
var inst_14563 = (state_14599[(7)]);
var inst_14589 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14557,inst_14563);
var inst_14556 = inst_14564;
var inst_14557__$1 = inst_14589;
var state_14599__$1 = (function (){var statearr_14614 = state_14599;
(statearr_14614[(13)] = inst_14557__$1);

(statearr_14614[(16)] = inst_14556);

return statearr_14614;
})();
var statearr_14615_14630 = state_14599__$1;
(statearr_14615_14630[(2)] = null);

(statearr_14615_14630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0 = (function (){
var statearr_14616 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14616[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__);

(statearr_14616[(1)] = (1));

return statearr_14616;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1 = (function (state_14599){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14599);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14617){var ex__2417__auto__ = e14617;
var statearr_14618_14631 = state_14599;
(statearr_14618_14631[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14599[(4)]))){
var statearr_14619_14632 = state_14599;
(statearr_14619_14632[(1)] = cljs.core.first((state_14599[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14633 = state_14599;
state_14599 = G__14633;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__ = function(state_14599){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1.call(this,state_14599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14620 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14620[(6)] = c__2436__auto__);

return statearr_14620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14635 = arguments.length;
switch (G__14635) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14786){
var state_val_14787 = (state_14786[(1)]);
if((state_val_14787 === (62))){
var inst_14773 = (state_14786[(7)]);
var state_14786__$1 = state_14786;
var statearr_14788_14877 = state_14786__$1;
(statearr_14788_14877[(2)] = inst_14773);

(statearr_14788_14877[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (7))){
var state_14786__$1 = state_14786;
var statearr_14789_14878 = state_14786__$1;
(statearr_14789_14878[(2)] = false);

(statearr_14789_14878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (59))){
var inst_14765 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14790_14879 = state_14786__$1;
(statearr_14790_14879[(2)] = inst_14765);

(statearr_14790_14879[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (20))){
var state_14786__$1 = state_14786;
var statearr_14791_14880 = state_14786__$1;
(statearr_14791_14880[(2)] = null);

(statearr_14791_14880[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (58))){
var state_14786__$1 = state_14786;
var statearr_14792_14881 = state_14786__$1;
(statearr_14792_14881[(2)] = null);

(statearr_14792_14881[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (60))){
var inst_14761 = (state_14786[(2)]);
var inst_14762 = fluree.db.util.async.throw_err(inst_14761);
var state_14786__$1 = state_14786;
var statearr_14793_14882 = state_14786__$1;
(statearr_14793_14882[(2)] = inst_14762);

(statearr_14793_14882[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (27))){
var inst_14686 = (state_14786[(8)]);
var inst_14697 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_14686);
var state_14786__$1 = state_14786;
if(inst_14697){
var statearr_14794_14883 = state_14786__$1;
(statearr_14794_14883[(1)] = (30));

} else {
var statearr_14795_14884 = state_14786__$1;
(statearr_14795_14884[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (1))){
var state_14786__$1 = state_14786;
var statearr_14796_14885 = state_14786__$1;
(statearr_14796_14885[(2)] = null);

(statearr_14796_14885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (24))){
var inst_14647 = (state_14786[(9)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14647)){
var statearr_14797_14886 = state_14786__$1;
(statearr_14797_14886[(1)] = (27));

} else {
var statearr_14798_14887 = state_14786__$1;
(statearr_14798_14887[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (55))){
var inst_14767 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14799_14888 = state_14786__$1;
(statearr_14799_14888[(2)] = inst_14767);

(statearr_14799_14888[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (39))){
var inst_14717 = (state_14786[(2)]);
var inst_14718 = fluree.db.util.async.throw_err(inst_14717);
var state_14786__$1 = state_14786;
var statearr_14800_14889 = state_14786__$1;
(statearr_14800_14889[(2)] = inst_14718);

(statearr_14800_14889[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (46))){
var inst_14730 = (state_14786[(10)]);
var inst_14730__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14786__$1 = (function (){var statearr_14801 = state_14786;
(statearr_14801[(10)] = inst_14730__$1);

return statearr_14801;
})();
if(cljs.core.truth_(inst_14730__$1)){
var statearr_14802_14890 = state_14786__$1;
(statearr_14802_14890[(1)] = (49));

} else {
var statearr_14803_14891 = state_14786__$1;
(statearr_14803_14891[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (4))){
var inst_14636 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14804_14892 = state_14786__$1;
(statearr_14804_14892[(2)] = inst_14636);

(statearr_14804_14892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (54))){
var inst_14686 = (state_14786[(8)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14686)){
var statearr_14805_14893 = state_14786__$1;
(statearr_14805_14893[(1)] = (57));

} else {
var statearr_14806_14894 = state_14786__$1;
(statearr_14806_14894[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (15))){
var inst_14648 = (state_14786[(11)]);
var inst_14667 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14648);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(18),inst_14667);
} else {
if((state_val_14787 === (48))){
var inst_14769 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14807_14895 = state_14786__$1;
(statearr_14807_14895[(2)] = inst_14769);

(statearr_14807_14895[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (50))){
var inst_14661 = (state_14786[(12)]);
var inst_14650 = (state_14786[(13)]);
var inst_14730 = (state_14786[(10)]);
var inst_14656 = (state_14786[(14)]);
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14645 = (state_14786[(16)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14734 = (function (){var t = inst_14649;
var temp__5733__auto__ = inst_14730;
var p = inst_14647;
var idx_predicate_QMARK_ = inst_14650;
var o = inst_14686;
var vec__14642 = inst_14645;
var tag_predicate_QMARK_ = inst_14656;
var s = inst_14646;
var o_coerce_QMARK_ = inst_14661;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_14786__$1 = state_14786;
var statearr_14808_14896 = state_14786__$1;
(statearr_14808_14896[(2)] = inst_14734);

(statearr_14808_14896[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (21))){
var inst_14682 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14809_14897 = state_14786__$1;
(statearr_14809_14897[(2)] = inst_14682);

(statearr_14809_14897[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (31))){
var state_14786__$1 = state_14786;
var statearr_14810_14898 = state_14786__$1;
(statearr_14810_14898[(2)] = false);

(statearr_14810_14898[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (32))){
var inst_14707 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14811_14899 = state_14786__$1;
(statearr_14811_14899[(2)] = inst_14707);

(statearr_14811_14899[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (40))){
var inst_14650 = (state_14786[(13)]);
var inst_14721 = cljs.core.not(inst_14650);
var state_14786__$1 = state_14786;
if(inst_14721){
var statearr_14812_14900 = state_14786__$1;
(statearr_14812_14900[(1)] = (43));

} else {
var statearr_14813_14901 = state_14786__$1;
(statearr_14813_14901[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (56))){
var inst_14752 = (state_14786[(2)]);
var inst_14753 = fluree.db.util.async.throw_err(inst_14752);
var state_14786__$1 = state_14786;
var statearr_14814_14902 = state_14786__$1;
(statearr_14814_14902[(2)] = inst_14753);

(statearr_14814_14902[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (33))){
var inst_14686 = (state_14786[(8)]);
var inst_14700 = cljs.core.fn_QMARK_(inst_14686);
var inst_14701 = (!(inst_14700));
var state_14786__$1 = state_14786;
var statearr_14815_14903 = state_14786__$1;
(statearr_14815_14903[(2)] = inst_14701);

(statearr_14815_14903[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (13))){
var inst_14648 = (state_14786[(11)]);
var inst_14665 = fluree.db.query.range.tag_string_QMARK_(inst_14648);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14665)){
var statearr_14816_14904 = state_14786__$1;
(statearr_14816_14904[(1)] = (15));

} else {
var statearr_14817_14905 = state_14786__$1;
(statearr_14817_14905[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (22))){
var inst_14678 = (state_14786[(2)]);
var inst_14679 = fluree.db.util.async.throw_err(inst_14678);
var state_14786__$1 = state_14786;
var statearr_14818_14906 = state_14786__$1;
(statearr_14818_14906[(2)] = inst_14679);

(statearr_14818_14906[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (36))){
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14713 = [inst_14647,inst_14686,inst_14646,inst_14649];
var inst_14714 = (new cljs.core.PersistentVector(null,4,(5),inst_14712,inst_14713,null));
var inst_14715 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14714,opts);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(39),inst_14715);
} else {
if((state_val_14787 === (41))){
var inst_14647 = (state_14786[(9)]);
var state_14786__$1 = state_14786;
var statearr_14819_14907 = state_14786__$1;
(statearr_14819_14907[(2)] = inst_14647);

(statearr_14819_14907[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (43))){
var inst_14686 = (state_14786[(8)]);
var state_14786__$1 = state_14786;
var statearr_14820_14908 = state_14786__$1;
(statearr_14820_14908[(2)] = inst_14686);

(statearr_14820_14908[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (61))){
var inst_14773 = (state_14786[(7)]);
var inst_14775 = fluree.db.query.range.coerce_tag_flakes(db,inst_14773);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(64),inst_14775);
} else {
if((state_val_14787 === (29))){
var inst_14710 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14710)){
var statearr_14821_14909 = state_14786__$1;
(statearr_14821_14909[(1)] = (36));

} else {
var statearr_14822_14910 = state_14786__$1;
(statearr_14822_14910[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (44))){
var state_14786__$1 = state_14786;
var statearr_14823_14911 = state_14786__$1;
(statearr_14823_14911[(2)] = false);

(statearr_14823_14911[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (6))){
var inst_14647 = (state_14786[(9)]);
var inst_14652 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14647);
var inst_14653 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14652);
var state_14786__$1 = state_14786;
var statearr_14824_14912 = state_14786__$1;
(statearr_14824_14912[(2)] = inst_14653);

(statearr_14824_14912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (28))){
var inst_14647 = (state_14786[(9)]);
var state_14786__$1 = state_14786;
var statearr_14825_14913 = state_14786__$1;
(statearr_14825_14913[(2)] = inst_14647);

(statearr_14825_14913[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (64))){
var inst_14777 = (state_14786[(2)]);
var inst_14778 = fluree.db.util.async.throw_err(inst_14777);
var state_14786__$1 = state_14786;
var statearr_14826_14914 = state_14786__$1;
(statearr_14826_14914[(2)] = inst_14778);

(statearr_14826_14914[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (51))){
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14649 = (state_14786[(17)]);
var inst_14736 = (state_14786[(2)]);
var inst_14737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14738 = [inst_14647,inst_14646,null,inst_14649];
var inst_14739 = (new cljs.core.PersistentVector(null,4,(5),inst_14737,inst_14738,null));
var inst_14740 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14736);
var inst_14741 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14739,inst_14740);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(52),inst_14741);
} else {
if((state_val_14787 === (25))){
var inst_14656 = (state_14786[(14)]);
var inst_14773 = (state_14786[(2)]);
var state_14786__$1 = (function (){var statearr_14827 = state_14786;
(statearr_14827[(7)] = inst_14773);

return statearr_14827;
})();
if(cljs.core.truth_(inst_14656)){
var statearr_14828_14915 = state_14786__$1;
(statearr_14828_14915[(1)] = (61));

} else {
var statearr_14829_14916 = state_14786__$1;
(statearr_14829_14916[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (34))){
var inst_14650 = (state_14786[(13)]);
var state_14786__$1 = state_14786;
var statearr_14830_14917 = state_14786__$1;
(statearr_14830_14917[(2)] = inst_14650);

(statearr_14830_14917[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (17))){
var inst_14684 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14831_14918 = state_14786__$1;
(statearr_14831_14918[(2)] = inst_14684);

(statearr_14831_14918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (3))){
var inst_14784 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14786__$1,inst_14784);
} else {
if((state_val_14787 === (12))){
var inst_14648 = (state_14786[(11)]);
var state_14786__$1 = state_14786;
var statearr_14832_14919 = state_14786__$1;
(statearr_14832_14919[(2)] = inst_14648);

(statearr_14832_14919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (2))){
var inst_14647 = (state_14786[(9)]);
var inst_14645 = (state_14786[(16)]);
var _ = (function (){var statearr_14833 = state_14786;
(statearr_14833[(4)] = cljs.core.cons((5),(state_14786[(4)])));

return statearr_14833;
})();
var inst_14645__$1 = fparts;
var inst_14646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14645__$1,(0),null);
var inst_14647__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14645__$1,(1),null);
var inst_14648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14645__$1,(2),null);
var inst_14649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14645__$1,(3),null);
var inst_14650 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14647__$1);
var state_14786__$1 = (function (){var statearr_14834 = state_14786;
(statearr_14834[(13)] = inst_14650);

(statearr_14834[(15)] = inst_14646);

(statearr_14834[(9)] = inst_14647__$1);

(statearr_14834[(16)] = inst_14645__$1);

(statearr_14834[(17)] = inst_14649);

(statearr_14834[(11)] = inst_14648);

return statearr_14834;
})();
if(cljs.core.truth_(inst_14647__$1)){
var statearr_14835_14920 = state_14786__$1;
(statearr_14835_14920[(1)] = (6));

} else {
var statearr_14836_14921 = state_14786__$1;
(statearr_14836_14921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (23))){
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14689 = [inst_14646,inst_14647,inst_14686,inst_14649];
var inst_14690 = (new cljs.core.PersistentVector(null,4,(5),inst_14688,inst_14689,null));
var inst_14691 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14690,opts);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(26),inst_14691);
} else {
if((state_val_14787 === (47))){
var inst_14647 = (state_14786[(9)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14647)){
var statearr_14837_14922 = state_14786__$1;
(statearr_14837_14922[(1)] = (53));

} else {
var statearr_14838_14923 = state_14786__$1;
(statearr_14838_14923[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (35))){
var inst_14704 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14839_14924 = state_14786__$1;
(statearr_14839_14924[(2)] = inst_14704);

(statearr_14839_14924[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (19))){
var inst_14647 = (state_14786[(9)]);
var inst_14648 = (state_14786[(11)]);
var inst_14674 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14647);
var inst_14675 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14674),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14648)].join('');
var inst_14676 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14675);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(22),inst_14676);
} else {
if((state_val_14787 === (57))){
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14757 = [inst_14686,inst_14647,inst_14646,inst_14649];
var inst_14758 = (new cljs.core.PersistentVector(null,4,(5),inst_14756,inst_14757,null));
var inst_14759 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14758,opts);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(60),inst_14759);
} else {
if((state_val_14787 === (11))){
var inst_14661 = (state_14786[(12)]);
var inst_14661__$1 = (state_14786[(2)]);
var inst_14662 = cljs.core.not(inst_14661__$1);
var state_14786__$1 = (function (){var statearr_14841 = state_14786;
(statearr_14841[(12)] = inst_14661__$1);

return statearr_14841;
})();
if(inst_14662){
var statearr_14842_14925 = state_14786__$1;
(statearr_14842_14925[(1)] = (12));

} else {
var statearr_14843_14926 = state_14786__$1;
(statearr_14843_14926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (9))){
var inst_14648 = (state_14786[(11)]);
var inst_14658 = typeof inst_14648 === 'string';
var state_14786__$1 = state_14786;
var statearr_14844_14927 = state_14786__$1;
(statearr_14844_14927[(2)] = inst_14658);

(statearr_14844_14927[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (5))){
var _ = (function (){var statearr_14845 = state_14786;
(statearr_14845[(4)] = cljs.core.rest((state_14786[(4)])));

return statearr_14845;
})();
var state_14786__$1 = state_14786;
var ex14840 = (state_14786__$1[(2)]);
var statearr_14846_14928 = state_14786__$1;
(statearr_14846_14928[(5)] = ex14840);


if((ex14840 instanceof Error)){
var statearr_14847_14929 = state_14786__$1;
(statearr_14847_14929[(1)] = (4));

(statearr_14847_14929[(5)] = null);

} else {
throw ex14840;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (14))){
var inst_14646 = (state_14786[(15)]);
var inst_14686 = (state_14786[(2)]);
var state_14786__$1 = (function (){var statearr_14848 = state_14786;
(statearr_14848[(8)] = inst_14686);

return statearr_14848;
})();
if(cljs.core.truth_(inst_14646)){
var statearr_14849_14930 = state_14786__$1;
(statearr_14849_14930[(1)] = (23));

} else {
var statearr_14850_14931 = state_14786__$1;
(statearr_14850_14931[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (45))){
var inst_14725 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14851_14932 = state_14786__$1;
(statearr_14851_14932[(2)] = inst_14725);

(statearr_14851_14932[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (53))){
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14748 = [inst_14647,inst_14646,inst_14686,inst_14649];
var inst_14749 = (new cljs.core.PersistentVector(null,4,(5),inst_14747,inst_14748,null));
var inst_14750 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14749,opts);
var state_14786__$1 = state_14786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14786__$1,(56),inst_14750);
} else {
if((state_val_14787 === (26))){
var inst_14693 = (state_14786[(2)]);
var inst_14694 = fluree.db.util.async.throw_err(inst_14693);
var state_14786__$1 = state_14786;
var statearr_14852_14933 = state_14786__$1;
(statearr_14852_14933[(2)] = inst_14694);

(statearr_14852_14933[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (16))){
var inst_14648 = (state_14786[(11)]);
var inst_14672 = typeof inst_14648 === 'string';
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14672)){
var statearr_14853_14934 = state_14786__$1;
(statearr_14853_14934[(1)] = (19));

} else {
var statearr_14854_14935 = state_14786__$1;
(statearr_14854_14935[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (38))){
var inst_14771 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
var statearr_14855_14936 = state_14786__$1;
(statearr_14855_14936[(2)] = inst_14771);

(statearr_14855_14936[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (30))){
var inst_14650 = (state_14786[(13)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14650)){
var statearr_14856_14937 = state_14786__$1;
(statearr_14856_14937[(1)] = (33));

} else {
var statearr_14857_14938 = state_14786__$1;
(statearr_14857_14938[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (10))){
var inst_14656 = (state_14786[(14)]);
var state_14786__$1 = state_14786;
var statearr_14858_14939 = state_14786__$1;
(statearr_14858_14939[(2)] = inst_14656);

(statearr_14858_14939[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (18))){
var inst_14669 = (state_14786[(2)]);
var inst_14670 = fluree.db.util.async.throw_err(inst_14669);
var state_14786__$1 = state_14786;
var statearr_14859_14940 = state_14786__$1;
(statearr_14859_14940[(2)] = inst_14670);

(statearr_14859_14940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (52))){
var inst_14743 = (state_14786[(2)]);
var inst_14744 = fluree.db.util.async.throw_err(inst_14743);
var state_14786__$1 = state_14786;
var statearr_14860_14941 = state_14786__$1;
(statearr_14860_14941[(2)] = inst_14744);

(statearr_14860_14941[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (42))){
var inst_14728 = (state_14786[(2)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14728)){
var statearr_14861_14942 = state_14786__$1;
(statearr_14861_14942[(1)] = (46));

} else {
var statearr_14862_14943 = state_14786__$1;
(statearr_14862_14943[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (37))){
var inst_14647 = (state_14786[(9)]);
var state_14786__$1 = state_14786;
if(cljs.core.truth_(inst_14647)){
var statearr_14863_14944 = state_14786__$1;
(statearr_14863_14944[(1)] = (40));

} else {
var statearr_14864_14945 = state_14786__$1;
(statearr_14864_14945[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (63))){
var inst_14781 = (state_14786[(2)]);
var _ = (function (){var statearr_14865 = state_14786;
(statearr_14865[(4)] = cljs.core.rest((state_14786[(4)])));

return statearr_14865;
})();
var state_14786__$1 = state_14786;
var statearr_14866_14946 = state_14786__$1;
(statearr_14866_14946[(2)] = inst_14781);

(statearr_14866_14946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (8))){
var inst_14656 = (state_14786[(14)]);
var inst_14656__$1 = (state_14786[(2)]);
var state_14786__$1 = (function (){var statearr_14867 = state_14786;
(statearr_14867[(14)] = inst_14656__$1);

return statearr_14867;
})();
if(cljs.core.truth_(inst_14656__$1)){
var statearr_14868_14947 = state_14786__$1;
(statearr_14868_14947[(1)] = (9));

} else {
var statearr_14869_14948 = state_14786__$1;
(statearr_14869_14948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14787 === (49))){
var inst_14661 = (state_14786[(12)]);
var inst_14650 = (state_14786[(13)]);
var inst_14730 = (state_14786[(10)]);
var inst_14656 = (state_14786[(14)]);
var inst_14646 = (state_14786[(15)]);
var inst_14647 = (state_14786[(9)]);
var inst_14645 = (state_14786[(16)]);
var inst_14649 = (state_14786[(17)]);
var inst_14686 = (state_14786[(8)]);
var inst_14732 = (function (){var obj_fn = inst_14730;
var t = inst_14649;
var temp__5733__auto__ = inst_14730;
var p = inst_14647;
var idx_predicate_QMARK_ = inst_14650;
var o = inst_14686;
var vec__14642 = inst_14645;
var tag_predicate_QMARK_ = inst_14656;
var s = inst_14646;
var o_coerce_QMARK_ = inst_14661;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_14786__$1 = state_14786;
var statearr_14870_14949 = state_14786__$1;
(statearr_14870_14949[(2)] = inst_14732);

(statearr_14870_14949[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_14871 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14871[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_14871[(1)] = (1));

return statearr_14871;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_14786){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14786);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14872){var ex__2417__auto__ = e14872;
var statearr_14873_14950 = state_14786;
(statearr_14873_14950[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14786[(4)]))){
var statearr_14874_14951 = state_14786;
(statearr_14874_14951[(1)] = cljs.core.first((state_14786[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14952 = state_14786;
state_14786 = G__14952;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_14786){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_14786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14875 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14875[(6)] = c__2436__auto__);

return statearr_14875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__14954 = arguments.length;
switch (G__14954) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14989){
var state_val_14990 = (state_14989[(1)]);
if((state_val_14990 === (7))){
var inst_14976 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_14977 = ["Invalid collection name: ",inst_14976].join('');
var inst_14978 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_14979 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_14980 = cljs.core.PersistentHashMap.fromArrays(inst_14978,inst_14979);
var inst_14981 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_14977,inst_14980);
var inst_14982 = (function(){throw inst_14981})();
var state_14989__$1 = state_14989;
var statearr_14991_15011 = state_14989__$1;
(statearr_14991_15011[(2)] = inst_14982);

(statearr_14991_15011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (1))){
var state_14989__$1 = state_14989;
var statearr_14992_15012 = state_14989__$1;
(statearr_14992_15012[(2)] = null);

(statearr_14992_15012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (4))){
var inst_14955 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
var statearr_14993_15013 = state_14989__$1;
(statearr_14993_15013[(2)] = inst_14955);

(statearr_14993_15013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (6))){
var inst_14961 = (state_14989[(7)]);
var inst_14963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14964 = fluree.db.flake.max_subject_id(inst_14961);
var inst_14965 = [inst_14964];
var inst_14966 = (new cljs.core.PersistentVector(null,1,(5),inst_14963,inst_14965,null));
var inst_14967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14968 = fluree.db.flake.min_subject_id(inst_14961);
var inst_14969 = [inst_14968];
var inst_14970 = (new cljs.core.PersistentVector(null,1,(5),inst_14967,inst_14969,null));
var inst_14971 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_14966,cljs.core._LT__EQ_,inst_14970,opts);
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14989__$1,(9),inst_14971);
} else {
if((state_val_14990 === (3))){
var inst_14987 = (state_14989[(2)]);
var state_14989__$1 = state_14989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14989__$1,inst_14987);
} else {
if((state_val_14990 === (2))){
var inst_14961 = (state_14989[(7)]);
var _ = (function (){var statearr_14995 = state_14989;
(statearr_14995[(4)] = cljs.core.cons((5),(state_14989[(4)])));

return statearr_14995;
})();
var inst_14961__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_14989__$1 = (function (){var statearr_14996 = state_14989;
(statearr_14996[(7)] = inst_14961__$1);

return statearr_14996;
})();
if(cljs.core.truth_(inst_14961__$1)){
var statearr_14997_15014 = state_14989__$1;
(statearr_14997_15014[(1)] = (6));

} else {
var statearr_14998_15015 = state_14989__$1;
(statearr_14998_15015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (9))){
var inst_14973 = (state_14989[(2)]);
var inst_14974 = fluree.db.util.async.throw_err(inst_14973);
var state_14989__$1 = state_14989;
var statearr_14999_15016 = state_14989__$1;
(statearr_14999_15016[(2)] = inst_14974);

(statearr_14999_15016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (5))){
var _ = (function (){var statearr_15000 = state_14989;
(statearr_15000[(4)] = cljs.core.rest((state_14989[(4)])));

return statearr_15000;
})();
var state_14989__$1 = state_14989;
var ex14994 = (state_14989__$1[(2)]);
var statearr_15001_15017 = state_14989__$1;
(statearr_15001_15017[(5)] = ex14994);


var statearr_15002_15018 = state_14989__$1;
(statearr_15002_15018[(1)] = (4));

(statearr_15002_15018[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14990 === (8))){
var inst_14984 = (state_14989[(2)]);
var _ = (function (){var statearr_15003 = state_14989;
(statearr_15003[(4)] = cljs.core.rest((state_14989[(4)])));

return statearr_15003;
})();
var state_14989__$1 = state_14989;
var statearr_15004_15019 = state_14989__$1;
(statearr_15004_15019[(2)] = inst_14984);

(statearr_15004_15019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_15005 = [null,null,null,null,null,null,null,null];
(statearr_15005[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_15005[(1)] = (1));

return statearr_15005;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_14989){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14989);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15006){var ex__2417__auto__ = e15006;
var statearr_15007_15020 = state_14989;
(statearr_15007_15020[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14989[(4)]))){
var statearr_15008_15021 = state_14989;
(statearr_15008_15021[(1)] = cljs.core.first((state_14989[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15022 = state_14989;
state_14989 = G__15022;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_14989){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_14989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15009 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15009[(6)] = c__2436__auto__);

return statearr_15009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15026 = flakes;
var vec__15027 = G__15026;
var seq__15028 = cljs.core.seq(vec__15027);
var first__15029 = cljs.core.first(seq__15028);
var seq__15028__$1 = cljs.core.next(seq__15028);
var flake_SINGLEQUOTE_ = first__15029;
var r = seq__15028__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15026__$1 = G__15026;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15036 = G__15026__$1;
var seq__15037 = cljs.core.seq(vec__15036);
var first__15038 = cljs.core.first(seq__15037);
var seq__15037__$1 = cljs.core.next(seq__15037);
var flake_SINGLEQUOTE___$1 = first__15038;
var r__$1 = seq__15037__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15040){var e = e15040;
return null;
}})();
var map__15039 = cmd_map;
var map__15039__$1 = (((((!((map__15039 == null))))?(((((map__15039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15039):map__15039);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15039__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15042 = r__$1;
var G__15043 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15026__$1 = G__15042;
result_STAR___$1 = G__15043;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15052 = blocks;
var vec__15053 = G__15052;
var seq__15054 = cljs.core.seq(vec__15053);
var first__15055 = cljs.core.first(seq__15054);
var seq__15054__$1 = cljs.core.next(seq__15054);
var block_SINGLEQUOTE_ = first__15055;
var r = seq__15054__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15052__$1 = G__15052;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15061 = G__15052__$1;
var seq__15062 = cljs.core.seq(vec__15061);
var first__15063 = cljs.core.first(seq__15062);
var seq__15062__$1 = cljs.core.next(seq__15062);
var block_SINGLEQUOTE___$1 = first__15063;
var r__$1 = seq__15062__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15064 = block_SINGLEQUOTE___$1;
var map__15064__$1 = (((((!((map__15064 == null))))?(((((map__15064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15064):map__15064);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15044_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15044_SHARP_.p,(2))){
return p1__15044_SHARP_.o;
} else {
return null;
}
});})(G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15045_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15045_SHARP_.p,(1))){
return p1__15045_SHARP_.o;
} else {
return null;
}
});})(G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15046_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15046_SHARP_.p,(5))){
return p1__15046_SHARP_.o;
} else {
return null;
}
});})(G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,instant,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15047_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15047_SHARP_.p,(7))){
return p1__15047_SHARP_.o;
} else {
return null;
}
});})(G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,instant,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15048_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15048_SHARP_.p,(106));
});})(G__15052__$1,result_STAR___$1,map__15064,map__15064__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15061,seq__15062,first__15063,seq__15062__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15052,vec__15053,seq__15054,first__15055,seq__15054__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15066 = r__$1;
var G__15067 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15052__$1 = G__15066;
result_STAR___$1 = G__15067;
continue;
}
break;
}
});
