// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15085){
var state_val_15086 = (state_15085[(1)]);
if((state_val_15086 === (1))){
var state_15085__$1 = state_15085;
var statearr_15087_15101 = state_15085__$1;
(statearr_15087_15101[(2)] = null);

(statearr_15087_15101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15086 === (2))){
var _ = (function (){var statearr_15088 = state_15085;
(statearr_15088[(4)] = cljs.core.cons((5),(state_15085[(4)])));

return statearr_15088;
})();
var inst_15076 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_15085__$1 = state_15085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15085__$1,(6),inst_15076);
} else {
if((state_val_15086 === (3))){
var inst_15083 = (state_15085[(2)]);
var state_15085__$1 = state_15085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15085__$1,inst_15083);
} else {
if((state_val_15086 === (4))){
var inst_15070 = (state_15085[(2)]);
var state_15085__$1 = state_15085;
var statearr_15090_15102 = state_15085__$1;
(statearr_15090_15102[(2)] = inst_15070);

(statearr_15090_15102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15086 === (5))){
var _ = (function (){var statearr_15091 = state_15085;
(statearr_15091[(4)] = cljs.core.rest((state_15085[(4)])));

return statearr_15091;
})();
var state_15085__$1 = state_15085;
var ex15089 = (state_15085__$1[(2)]);
var statearr_15092_15103 = state_15085__$1;
(statearr_15092_15103[(5)] = ex15089);


if((ex15089 instanceof Error)){
var statearr_15093_15104 = state_15085__$1;
(statearr_15093_15104[(1)] = (4));

(statearr_15093_15104[(5)] = null);

} else {
throw ex15089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15086 === (6))){
var inst_15078 = (state_15085[(2)]);
var inst_15079 = fluree.db.util.async.throw_err(inst_15078);
var inst_15080 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_15079);
var _ = (function (){var statearr_15094 = state_15085;
(statearr_15094[(4)] = cljs.core.rest((state_15085[(4)])));

return statearr_15094;
})();
var state_15085__$1 = state_15085;
var statearr_15095_15105 = state_15085__$1;
(statearr_15095_15105[(2)] = inst_15080);

(statearr_15095_15105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0 = (function (){
var statearr_15096 = [null,null,null,null,null,null,null];
(statearr_15096[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__);

(statearr_15096[(1)] = (1));

return statearr_15096;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1 = (function (state_15085){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15085);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15097){var ex__2417__auto__ = e15097;
var statearr_15098_15106 = state_15085;
(statearr_15098_15106[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15085[(4)]))){
var statearr_15099_15107 = state_15085;
(statearr_15099_15107[(1)] = cljs.core.first((state_15085[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15108 = state_15085;
state_15085 = G__15108;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__ = function(state_15085){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1.call(this,state_15085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15100 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15100[(6)] = c__2436__auto__);

return statearr_15100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15140){
var state_val_15141 = (state_15140[(1)]);
if((state_val_15141 === (7))){
var inst_15124 = (state_15140[(7)]);
var inst_15126 = cljs.core.empty_QMARK_(inst_15124);
var inst_15127 = (!(inst_15126));
var state_15140__$1 = state_15140;
var statearr_15142_15166 = state_15140__$1;
(statearr_15142_15166[(2)] = inst_15127);

(statearr_15142_15166[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (1))){
var state_15140__$1 = state_15140;
var statearr_15143_15167 = state_15140__$1;
(statearr_15143_15167[(2)] = null);

(statearr_15143_15167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (4))){
var inst_15110 = (state_15140[(2)]);
var state_15140__$1 = state_15140;
var statearr_15144_15168 = state_15140__$1;
(statearr_15144_15168[(2)] = inst_15110);

(statearr_15144_15168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (6))){
var inst_15124 = (state_15140[(7)]);
var inst_15116 = (state_15140[(8)]);
var inst_15122 = (state_15140[(2)]);
var inst_15123 = fluree.db.util.async.throw_err(inst_15122);
var inst_15124__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_15116,inst_15123);
var state_15140__$1 = (function (){var statearr_15145 = state_15140;
(statearr_15145[(7)] = inst_15124__$1);

return statearr_15145;
})();
if(cljs.core.truth_(inst_15124__$1)){
var statearr_15146_15169 = state_15140__$1;
(statearr_15146_15169[(1)] = (7));

} else {
var statearr_15147_15170 = state_15140__$1;
(statearr_15147_15170[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (3))){
var inst_15138 = (state_15140[(2)]);
var state_15140__$1 = state_15140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15140__$1,inst_15138);
} else {
if((state_val_15141 === (12))){
var inst_15135 = (state_15140[(2)]);
var _ = (function (){var statearr_15148 = state_15140;
(statearr_15148[(4)] = cljs.core.rest((state_15140[(4)])));

return statearr_15148;
})();
var state_15140__$1 = state_15140;
var statearr_15149_15171 = state_15140__$1;
(statearr_15149_15171[(2)] = inst_15135);

(statearr_15149_15171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (2))){
var _ = (function (){var statearr_15150 = state_15140;
(statearr_15150[(4)] = cljs.core.cons((5),(state_15140[(4)])));

return statearr_15150;
})();
var inst_15116 = (function (){return (function (p1__15109_SHARP_){
return p1__15109_SHARP_.o;
});
})();
var inst_15117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15118 = [pred_id];
var inst_15119 = (new cljs.core.PersistentVector(null,1,(5),inst_15117,inst_15118,null));
var inst_15120 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15119);
var state_15140__$1 = (function (){var statearr_15151 = state_15140;
(statearr_15151[(8)] = inst_15116);

return statearr_15151;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15140__$1,(6),inst_15120);
} else {
if((state_val_15141 === (11))){
var state_15140__$1 = state_15140;
var statearr_15153_15172 = state_15140__$1;
(statearr_15153_15172[(2)] = true);

(statearr_15153_15172[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (9))){
var inst_15130 = (state_15140[(2)]);
var state_15140__$1 = state_15140;
if(cljs.core.truth_(inst_15130)){
var statearr_15154_15173 = state_15140__$1;
(statearr_15154_15173[(1)] = (10));

} else {
var statearr_15155_15174 = state_15140__$1;
(statearr_15155_15174[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (5))){
var _ = (function (){var statearr_15156 = state_15140;
(statearr_15156[(4)] = cljs.core.rest((state_15140[(4)])));

return statearr_15156;
})();
var state_15140__$1 = state_15140;
var ex15152 = (state_15140__$1[(2)]);
var statearr_15157_15175 = state_15140__$1;
(statearr_15157_15175[(5)] = ex15152);


if((ex15152 instanceof Error)){
var statearr_15158_15176 = state_15140__$1;
(statearr_15158_15176[(1)] = (4));

(statearr_15158_15176[(5)] = null);

} else {
throw ex15152;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (10))){
var inst_15124 = (state_15140[(7)]);
var inst_15132 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_15124);
var state_15140__$1 = state_15140;
var statearr_15159_15177 = state_15140__$1;
(statearr_15159_15177[(2)] = inst_15132);

(statearr_15159_15177[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15141 === (8))){
var inst_15124 = (state_15140[(7)]);
var state_15140__$1 = state_15140;
var statearr_15160_15178 = state_15140__$1;
(statearr_15160_15178[(2)] = inst_15124);

(statearr_15160_15178[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_15161 = [null,null,null,null,null,null,null,null,null];
(statearr_15161[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__);

(statearr_15161[(1)] = (1));

return statearr_15161;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1 = (function (state_15140){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15140);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15162){var ex__2417__auto__ = e15162;
var statearr_15163_15179 = state_15140;
(statearr_15163_15179[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15140[(4)]))){
var statearr_15164_15180 = state_15140;
(statearr_15164_15180[(1)] = cljs.core.first((state_15140[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15181 = state_15140;
state_15140 = G__15181;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__ = function(state_15140){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1.call(this,state_15140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15165 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15165[(6)] = c__2436__auto__);

return statearr_15165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15258){
var state_val_15259 = (state_15258[(1)]);
if((state_val_15259 === (7))){
var inst_15253 = (state_15258[(2)]);
var _ = (function (){var statearr_15260 = state_15258;
(statearr_15260[(4)] = cljs.core.rest((state_15258[(4)])));

return statearr_15260;
})();
var state_15258__$1 = state_15258;
var statearr_15261_15294 = state_15258__$1;
(statearr_15261_15294[(2)] = inst_15253);

(statearr_15261_15294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (1))){
var state_15258__$1 = state_15258;
var statearr_15262_15295 = state_15258__$1;
(statearr_15262_15295[(2)] = null);

(statearr_15262_15295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (4))){
var inst_15184 = (state_15258[(2)]);
var state_15258__$1 = state_15258;
var statearr_15263_15296 = state_15258__$1;
(statearr_15263_15296[(2)] = inst_15184);

(statearr_15263_15296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (15))){
var inst_15208 = (state_15258[(7)]);
var inst_15214 = (state_15258[(8)]);
var inst_15234 = (state_15258[(9)]);
var inst_15221 = (state_15258[(10)]);
var inst_15236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15237 = inst_15214.s;
var inst_15238 = [inst_15237,inst_15221,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15239 = (new cljs.core.PersistentVector(null,3,(5),inst_15236,inst_15238,null));
var inst_15240 = cljs.core.assoc_in(inst_15208,inst_15239,inst_15234);
var state_15258__$1 = state_15258;
var statearr_15264_15297 = state_15258__$1;
(statearr_15264_15297[(2)] = inst_15240);

(statearr_15264_15297[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (13))){
var inst_15223 = (state_15258[(11)]);
var inst_15234 = (state_15258[(2)]);
var state_15258__$1 = (function (){var statearr_15265 = state_15258;
(statearr_15265[(9)] = inst_15234);

return statearr_15265;
})();
if(cljs.core.truth_(inst_15223)){
var statearr_15266_15298 = state_15258__$1;
(statearr_15266_15298[(1)] = (15));

} else {
var statearr_15267_15299 = state_15258__$1;
(statearr_15267_15299[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (6))){
var inst_15207 = (state_15258[(12)]);
var inst_15214 = (state_15258[(8)]);
var inst_15213 = cljs.core.seq(inst_15207);
var inst_15214__$1 = cljs.core.first(inst_15213);
var inst_15215 = cljs.core.next(inst_15213);
var inst_15216 = cljs.core.not(inst_15214__$1);
var state_15258__$1 = (function (){var statearr_15268 = state_15258;
(statearr_15268[(13)] = inst_15215);

(statearr_15268[(8)] = inst_15214__$1);

return statearr_15268;
})();
if(inst_15216){
var statearr_15269_15300 = state_15258__$1;
(statearr_15269_15300[(1)] = (8));

} else {
var statearr_15270_15301 = state_15258__$1;
(statearr_15270_15301[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (17))){
var inst_15215 = (state_15258[(13)]);
var inst_15248 = (state_15258[(2)]);
var inst_15207 = inst_15215;
var inst_15208 = inst_15248;
var state_15258__$1 = (function (){var statearr_15271 = state_15258;
(statearr_15271[(7)] = inst_15208);

(statearr_15271[(12)] = inst_15207);

return statearr_15271;
})();
var statearr_15272_15302 = state_15258__$1;
(statearr_15272_15302[(2)] = null);

(statearr_15272_15302[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (3))){
var inst_15256 = (state_15258[(2)]);
var state_15258__$1 = state_15258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15258__$1,inst_15256);
} else {
if((state_val_15259 === (12))){
var inst_15214 = (state_15258[(8)]);
var inst_15232 = inst_15214.o;
var state_15258__$1 = state_15258;
var statearr_15273_15303 = state_15258__$1;
(statearr_15273_15303[(2)] = inst_15232);

(statearr_15273_15303[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (2))){
var _ = (function (){var statearr_15274 = state_15258;
(statearr_15274[(4)] = cljs.core.cons((5),(state_15258[(4)])));

return statearr_15274;
})();
var inst_15190 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_15191 = cljs.core.PersistentHashSet.EMPTY;
var inst_15192 = cljs.core.vals(tempids);
var inst_15193 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_15191,inst_15192);
var inst_15194 = (function (){var pred_flakes = inst_15190;
var is_new_QMARK_ = inst_15193;
return (function (p1__15182_SHARP_,p2__15183_SHARP_){
return cljs.core.assoc_in(p1__15182_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__15183_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__15275 = p2__15183_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__15275) : is_new_QMARK_.call(null,G__15275));
})()));
});
})();
var inst_15195 = cljs.core.PersistentHashMap.EMPTY;
var inst_15196 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_15194,inst_15195,inst_15190);
var inst_15204 = cljs.core.seq(inst_15190);
var inst_15205 = cljs.core.first(inst_15204);
var inst_15206 = cljs.core.next(inst_15204);
var inst_15207 = inst_15190;
var inst_15208 = inst_15196;
var state_15258__$1 = (function (){var statearr_15276 = state_15258;
(statearr_15276[(14)] = inst_15205);

(statearr_15276[(7)] = inst_15208);

(statearr_15276[(12)] = inst_15207);

(statearr_15276[(15)] = inst_15206);

return statearr_15276;
})();
var statearr_15277_15304 = state_15258__$1;
(statearr_15277_15304[(2)] = null);

(statearr_15277_15304[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (11))){
var inst_15214 = (state_15258[(8)]);
var inst_15226 = inst_15214.o;
var inst_15227 = fluree.db.query.schema.convert_type_to_kw(inst_15226,db);
var state_15258__$1 = state_15258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15258__$1,(14),inst_15227);
} else {
if((state_val_15259 === (9))){
var inst_15214 = (state_15258[(8)]);
var inst_15221 = (state_15258[(10)]);
var inst_15219 = inst_15214.p;
var inst_15220 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15219);
var inst_15221__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_15220);
var inst_15222 = inst_15214.op;
var inst_15223 = inst_15222 === false;
var inst_15224 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_15221__$1);
var state_15258__$1 = (function (){var statearr_15279 = state_15258;
(statearr_15279[(11)] = inst_15223);

(statearr_15279[(10)] = inst_15221__$1);

return statearr_15279;
})();
if(inst_15224){
var statearr_15280_15305 = state_15258__$1;
(statearr_15280_15305[(1)] = (11));

} else {
var statearr_15281_15306 = state_15258__$1;
(statearr_15281_15306[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (5))){
var _ = (function (){var statearr_15282 = state_15258;
(statearr_15282[(4)] = cljs.core.rest((state_15258[(4)])));

return statearr_15282;
})();
var state_15258__$1 = state_15258;
var ex15278 = (state_15258__$1[(2)]);
var statearr_15283_15307 = state_15258__$1;
(statearr_15283_15307[(5)] = ex15278);


if((ex15278 instanceof Error)){
var statearr_15284_15308 = state_15258__$1;
(statearr_15284_15308[(1)] = (4));

(statearr_15284_15308[(5)] = null);

} else {
throw ex15278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (14))){
var inst_15229 = (state_15258[(2)]);
var inst_15230 = fluree.db.util.async.throw_err(inst_15229);
var state_15258__$1 = state_15258;
var statearr_15285_15309 = state_15258__$1;
(statearr_15285_15309[(2)] = inst_15230);

(statearr_15285_15309[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (16))){
var inst_15208 = (state_15258[(7)]);
var inst_15214 = (state_15258[(8)]);
var inst_15234 = (state_15258[(9)]);
var inst_15221 = (state_15258[(10)]);
var inst_15242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15243 = inst_15214.s;
var inst_15244 = [inst_15243,inst_15221,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15245 = (new cljs.core.PersistentVector(null,3,(5),inst_15242,inst_15244,null));
var inst_15246 = cljs.core.assoc_in(inst_15208,inst_15245,inst_15234);
var state_15258__$1 = state_15258;
var statearr_15286_15310 = state_15258__$1;
(statearr_15286_15310[(2)] = inst_15246);

(statearr_15286_15310[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (10))){
var inst_15251 = (state_15258[(2)]);
var state_15258__$1 = state_15258;
var statearr_15287_15311 = state_15258__$1;
(statearr_15287_15311[(2)] = inst_15251);

(statearr_15287_15311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15259 === (8))){
var inst_15208 = (state_15258[(7)]);
var state_15258__$1 = state_15258;
var statearr_15288_15312 = state_15258__$1;
(statearr_15288_15312[(2)] = inst_15208);

(statearr_15288_15312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0 = (function (){
var statearr_15289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15289[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__);

(statearr_15289[(1)] = (1));

return statearr_15289;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1 = (function (state_15258){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15258);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15290){var ex__2417__auto__ = e15290;
var statearr_15291_15313 = state_15258;
(statearr_15291_15313[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15258[(4)]))){
var statearr_15292_15314 = state_15258;
(statearr_15292_15314[(1)] = cljs.core.first((state_15258[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15315 = state_15258;
state_15258 = G__15315;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__ = function(state_15258){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1.call(this,state_15258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15293 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15293[(6)] = c__2436__auto__);

return statearr_15293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15317 = arguments.length;
switch (G__15317) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15320 = arguments.length;
switch (G__15320) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15629){
var state_val_15630 = (state_15629[(1)]);
if((state_val_15630 === (65))){
var inst_15582 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15631_15803 = state_15629__$1;
(statearr_15631_15803[(2)] = inst_15582);

(statearr_15631_15803[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (70))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15504 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15505 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15504,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,2,inst_15504,null));
var inst_15506 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15505,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15505,null));
var inst_15507 = (inst_15506.cljs$core$IFn$_invoke$arity$1 ? inst_15506.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15506.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15507)){
var statearr_15632_15804 = state_15629__$1;
(statearr_15632_15804[(1)] = (71));

} else {
var statearr_15633_15805 = state_15629__$1;
(statearr_15633_15805[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (62))){
var inst_15584 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15634_15806 = state_15629__$1;
(statearr_15634_15806[(2)] = inst_15584);

(statearr_15634_15806[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (74))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15514 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15515 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15514,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,3,inst_15514,null));
var inst_15516 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15515,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15515,null));
var inst_15517 = (inst_15516.cljs$core$IFn$_invoke$arity$1 ? inst_15516.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15516.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15517)){
var statearr_15635_15807 = state_15629__$1;
(statearr_15635_15807[(1)] = (75));

} else {
var statearr_15636_15808 = state_15629__$1;
(statearr_15636_15808[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (110))){
var inst_15616 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15637_15809 = state_15629__$1;
(statearr_15637_15809[(2)] = inst_15616);

(statearr_15637_15809[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (7))){
var inst_15624 = (state_15629[(2)]);
var _ = (function (){var statearr_15638 = state_15629;
(statearr_15638[(4)] = cljs.core.rest((state_15629[(4)])));

return statearr_15638;
})();
var state_15629__$1 = state_15629;
var statearr_15639_15810 = state_15629__$1;
(statearr_15639_15810[(2)] = inst_15624);

(statearr_15639_15810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (59))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15490 = (state_15629[(2)]);
var inst_15491__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15490,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15492__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15490,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15493 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15492__$1,inst_15491__$1);
var state_15629__$1 = (function (){var statearr_15640 = state_15629;
(statearr_15640[(7)] = inst_15491__$1);

(statearr_15640[(8)] = inst_15492__$1);

return statearr_15640;
})();
if(inst_15493){
var statearr_15641_15811 = state_15629__$1;
(statearr_15641_15811[(1)] = (60));

} else {
var statearr_15642_15812 = state_15629__$1;
(statearr_15642_15812[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (86))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15544 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15545 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15544,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,5,inst_15544,null));
var inst_15546 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15545,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15545,null));
var inst_15547 = (inst_15546.cljs$core$IFn$_invoke$arity$1 ? inst_15546.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15546.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15547)){
var statearr_15643_15813 = state_15629__$1;
(statearr_15643_15813[(1)] = (87));

} else {
var statearr_15644_15814 = state_15629__$1;
(statearr_15644_15814[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (20))){
var inst_15360 = (state_15629[(9)]);
var inst_15385 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15386 = inst_15385 === true;
var inst_15387 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15388 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15387);
var inst_15389 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15388);
var inst_15390 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15391 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15390);
var inst_15392 = inst_15391 === true;
var inst_15393 = ((inst_15386) && (inst_15389) && (inst_15392));
var state_15629__$1 = state_15629;
var statearr_15645_15815 = state_15629__$1;
(statearr_15645_15815[(2)] = inst_15393);

(statearr_15645_15815[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (72))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15510 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15646_15816 = state_15629__$1;
(statearr_15646_15816[(2)] = inst_15510);

(statearr_15646_15816[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (58))){
var inst_15469 = (state_15629[(10)]);
var state_15629__$1 = state_15629;
var statearr_15647_15817 = state_15629__$1;
(statearr_15647_15817[(2)] = inst_15469);

(statearr_15647_15817[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (60))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15648_15818 = state_15629__$1;
(statearr_15648_15818[(2)] = inst_15459);

(statearr_15648_15818[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (27))){
var inst_15380 = (state_15629[(12)]);
var state_15629__$1 = state_15629;
var statearr_15649_15819 = state_15629__$1;
(statearr_15649_15819[(2)] = inst_15380);

(statearr_15649_15819[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (1))){
var state_15629__$1 = state_15629;
var statearr_15650_15820 = state_15629__$1;
(statearr_15650_15820[(2)] = null);

(statearr_15650_15820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (69))){
var inst_15577 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15651_15821 = state_15629__$1;
(statearr_15651_15821[(2)] = inst_15577);

(statearr_15651_15821[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (101))){
var inst_15606 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15606)){
var statearr_15652_15822 = state_15629__$1;
(statearr_15652_15822[(1)] = (105));

} else {
var statearr_15653_15823 = state_15629__$1;
(statearr_15653_15823[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (24))){
var inst_15380 = (state_15629[(12)]);
var state_15629__$1 = state_15629;
var statearr_15654_15824 = state_15629__$1;
(statearr_15654_15824[(2)] = inst_15380);

(statearr_15654_15824[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (102))){
var inst_15360 = (state_15629[(9)]);
var inst_15593 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15594 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15593);
var inst_15595 = inst_15594 === true;
var inst_15596 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15597 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15596);
var inst_15598 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15597);
var inst_15599 = (!(inst_15598));
var inst_15600 = ((inst_15595) && (inst_15599));
var state_15629__$1 = state_15629;
var statearr_15655_15825 = state_15629__$1;
(statearr_15655_15825[(2)] = inst_15600);

(statearr_15655_15825[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (55))){
var state_15629__$1 = state_15629;
var statearr_15656_15826 = state_15629__$1;
(statearr_15656_15826[(2)] = false);

(statearr_15656_15826[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (85))){
var inst_15542 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15657_15827 = state_15629__$1;
(statearr_15657_15827[(2)] = inst_15542);

(statearr_15657_15827[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (39))){
var state_15629__$1 = state_15629;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15658_15828 = state_15629__$1;
(statearr_15658_15828[(1)] = (42));

} else {
var statearr_15659_15829 = state_15629__$1;
(statearr_15659_15829[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (88))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15550 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15660_15830 = state_15629__$1;
(statearr_15660_15830[(2)] = inst_15550);

(statearr_15660_15830[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (46))){
var inst_15460 = (state_15629[(13)]);
var state_15629__$1 = state_15629;
var statearr_15661_15831 = state_15629__$1;
(statearr_15661_15831[(2)] = inst_15460);

(statearr_15661_15831[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (4))){
var inst_15321 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15662_15832 = state_15629__$1;
(statearr_15662_15832[(2)] = inst_15321);

(statearr_15662_15832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (77))){
var inst_15522 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15663_15833 = state_15629__$1;
(statearr_15663_15833[(2)] = inst_15522);

(statearr_15663_15833[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (106))){
var inst_15587 = (state_15629[(14)]);
var state_15629__$1 = state_15629;
var statearr_15664_15834 = state_15629__$1;
(statearr_15664_15834[(2)] = inst_15587);

(statearr_15664_15834[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (95))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15665_15835 = state_15629__$1;
(statearr_15665_15835[(2)] = inst_15459);

(statearr_15665_15835[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (54))){
var state_15629__$1 = state_15629;
var statearr_15666_15836 = state_15629__$1;
(statearr_15666_15836[(2)] = true);

(statearr_15666_15836[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (92))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15560 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15667_15837 = state_15629__$1;
(statearr_15667_15837[(2)] = inst_15560);

(statearr_15667_15837[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (104))){
var inst_15603 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15668_15838 = state_15629__$1;
(statearr_15668_15838[(2)] = inst_15603);

(statearr_15668_15838[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (15))){
var inst_15348 = (state_15629[(15)]);
var state_15629__$1 = state_15629;
var statearr_15669_15839 = state_15629__$1;
(statearr_15669_15839[(2)] = inst_15348);

(statearr_15669_15839[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (48))){
var inst_15360 = (state_15629[(9)]);
var inst_15469 = (state_15629[(10)]);
var inst_15469__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15471 = (inst_15469__$1 == null);
var inst_15472 = cljs.core.not(inst_15471);
var state_15629__$1 = (function (){var statearr_15670 = state_15629;
(statearr_15670[(10)] = inst_15469__$1);

return statearr_15670;
})();
if(inst_15472){
var statearr_15671_15840 = state_15629__$1;
(statearr_15671_15840[(1)] = (51));

} else {
var statearr_15672_15841 = state_15629__$1;
(statearr_15672_15841[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (50))){
var inst_15360 = (state_15629[(9)]);
var inst_15587 = (state_15629[(2)]);
var inst_15588 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15589 = inst_15588 === true;
var state_15629__$1 = (function (){var statearr_15673 = state_15629;
(statearr_15673[(14)] = inst_15587);

return statearr_15673;
})();
if(cljs.core.truth_(inst_15589)){
var statearr_15674_15842 = state_15629__$1;
(statearr_15674_15842[(1)] = (99));

} else {
var statearr_15675_15843 = state_15629__$1;
(statearr_15675_15843[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (75))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15676_15844 = state_15629__$1;
(statearr_15676_15844[(2)] = inst_15459);

(statearr_15676_15844[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (99))){
var inst_15591 = (state_15629[(16)]);
var inst_15360 = (state_15629[(9)]);
var inst_15591__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15677 = state_15629;
(statearr_15677[(16)] = inst_15591__$1);

return statearr_15677;
})();
if(cljs.core.truth_(inst_15591__$1)){
var statearr_15678_15845 = state_15629__$1;
(statearr_15678_15845[(1)] = (102));

} else {
var statearr_15679_15846 = state_15629__$1;
(statearr_15679_15846[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (21))){
var inst_15383 = (state_15629[(17)]);
var state_15629__$1 = state_15629;
var statearr_15680_15847 = state_15629__$1;
(statearr_15680_15847[(2)] = inst_15383);

(statearr_15680_15847[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (31))){
var inst_15423 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15423)){
var statearr_15681_15848 = state_15629__$1;
(statearr_15681_15848[(1)] = (32));

} else {
var statearr_15682_15849 = state_15629__$1;
(statearr_15682_15849[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (32))){
var inst_15412 = (state_15629[(18)]);
var inst_15425 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15412,"a component","a non-component",throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15683_15850 = state_15629__$1;
(statearr_15683_15850[(2)] = inst_15425);

(statearr_15683_15850[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (40))){
var inst_15428 = (state_15629[(19)]);
var state_15629__$1 = state_15629;
var statearr_15684_15851 = state_15629__$1;
(statearr_15684_15851[(2)] = inst_15428);

(statearr_15684_15851[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (91))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15685_15852 = state_15629__$1;
(statearr_15685_15852[(2)] = inst_15459);

(statearr_15685_15852[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (108))){
var inst_15609 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15610 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15611 = cljs.core.PersistentHashMap.fromArrays(inst_15609,inst_15610);
var inst_15612 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_15611);
var inst_15613 = (function(){throw inst_15612})();
var state_15629__$1 = state_15629;
var statearr_15686_15853 = state_15629__$1;
(statearr_15686_15853[(2)] = inst_15613);

(statearr_15686_15853[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (56))){
var inst_15482 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15687_15854 = state_15629__$1;
(statearr_15687_15854[(2)] = inst_15482);

(statearr_15687_15854[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (33))){
var inst_15412 = (state_15629[(18)]);
var state_15629__$1 = state_15629;
var statearr_15688_15855 = state_15629__$1;
(statearr_15688_15855[(2)] = inst_15412);

(statearr_15688_15855[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (13))){
var inst_15375 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15375)){
var statearr_15689_15856 = state_15629__$1;
(statearr_15689_15856[(1)] = (14));

} else {
var statearr_15690_15857 = state_15629__$1;
(statearr_15690_15857[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (22))){
var inst_15396 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15691_15858 = state_15629__$1;
(statearr_15691_15858[(2)] = inst_15396);

(statearr_15691_15858[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (90))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15554 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15555 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_15554,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,5,inst_15554,null));
var inst_15556 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15555,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15555,null));
var inst_15557 = (inst_15556.cljs$core$IFn$_invoke$arity$1 ? inst_15556.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15556.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15557)){
var statearr_15692_15859 = state_15629__$1;
(statearr_15692_15859[(1)] = (91));

} else {
var statearr_15693_15860 = state_15629__$1;
(statearr_15693_15860[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (109))){
var inst_15587 = (state_15629[(14)]);
var state_15629__$1 = state_15629;
var statearr_15694_15861 = state_15629__$1;
(statearr_15694_15861[(2)] = inst_15587);

(statearr_15694_15861[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (36))){
var inst_15429 = (state_15629[(20)]);
var state_15629__$1 = state_15629;
var statearr_15695_15862 = state_15629__$1;
(statearr_15695_15862[(2)] = inst_15429);

(statearr_15695_15862[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (41))){
var inst_15360 = (state_15629[(9)]);
var inst_15460 = (state_15629[(13)]);
var inst_15459 = (state_15629[(2)]);
var inst_15460__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15696 = state_15629;
(statearr_15696[(13)] = inst_15460__$1);

(statearr_15696[(11)] = inst_15459);

return statearr_15696;
})();
if(cljs.core.truth_(inst_15460__$1)){
var statearr_15697_15863 = state_15629__$1;
(statearr_15697_15863[(1)] = (45));

} else {
var statearr_15698_15864 = state_15629__$1;
(statearr_15698_15864[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (89))){
var inst_15552 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15699_15865 = state_15629__$1;
(statearr_15699_15865[(2)] = inst_15552);

(statearr_15699_15865[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (100))){
var state_15629__$1 = state_15629;
var statearr_15700_15866 = state_15629__$1;
(statearr_15700_15866[(2)] = false);

(statearr_15700_15866[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (43))){
var inst_15428 = (state_15629[(19)]);
var state_15629__$1 = state_15629;
var statearr_15701_15867 = state_15629__$1;
(statearr_15701_15867[(2)] = inst_15428);

(statearr_15701_15867[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (61))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15496 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15497 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15496,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,3,inst_15496,null));
var inst_15498 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15497,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15497,null));
var inst_15499 = (inst_15498.cljs$core$IFn$_invoke$arity$1 ? inst_15498.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15498.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15499)){
var statearr_15702_15868 = state_15629__$1;
(statearr_15702_15868[(1)] = (63));

} else {
var statearr_15703_15869 = state_15629__$1;
(statearr_15703_15869[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (29))){
var inst_15360 = (state_15629[(9)]);
var inst_15415 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15416 = cljs.core.not(inst_15415);
var inst_15417 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15418 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15417);
var inst_15419 = inst_15418 === true;
var inst_15420 = ((inst_15416) && (inst_15419));
var state_15629__$1 = state_15629;
var statearr_15704_15870 = state_15629__$1;
(statearr_15704_15870[(2)] = inst_15420);

(statearr_15704_15870[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (44))){
var inst_15456 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15705_15871 = state_15629__$1;
(statearr_15705_15871[(2)] = inst_15456);

(statearr_15705_15871[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (93))){
var inst_15562 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15706_15872 = state_15629__$1;
(statearr_15706_15872[(2)] = inst_15562);

(statearr_15706_15872[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (6))){
var inst_15347 = (state_15629[(21)]);
var inst_15359 = (state_15629[(22)]);
var inst_15356 = cljs.core.seq(inst_15347);
var inst_15357 = cljs.core.first(inst_15356);
var inst_15358 = cljs.core.next(inst_15356);
var inst_15359__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357,(0),null);
var inst_15360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357,(1),null);
var inst_15361 = cljs.core.not(inst_15359__$1);
var state_15629__$1 = (function (){var statearr_15707 = state_15629;
(statearr_15707[(23)] = inst_15358);

(statearr_15707[(9)] = inst_15360);

(statearr_15707[(22)] = inst_15359__$1);

return statearr_15707;
})();
if(inst_15361){
var statearr_15708_15873 = state_15629__$1;
(statearr_15708_15873[(1)] = (8));

} else {
var statearr_15709_15874 = state_15629__$1;
(statearr_15709_15874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (28))){
var inst_15409 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15710_15875 = state_15629__$1;
(statearr_15710_15875[(2)] = inst_15409);

(statearr_15710_15875[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (64))){
var state_15629__$1 = state_15629;
var statearr_15711_15876 = state_15629__$1;
(statearr_15711_15876[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (103))){
var inst_15591 = (state_15629[(16)]);
var state_15629__$1 = state_15629;
var statearr_15713_15877 = state_15629__$1;
(statearr_15713_15877[(2)] = inst_15591);

(statearr_15713_15877[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (51))){
var inst_15469 = (state_15629[(10)]);
var inst_15474 = inst_15469.cljs$lang$protocol_mask$partition0$;
var inst_15475 = (inst_15474 & (64));
var inst_15476 = inst_15469.cljs$core$ISeq$;
var inst_15477 = (cljs.core.PROTOCOL_SENTINEL === inst_15476);
var inst_15478 = ((inst_15475) || (inst_15477));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15478)){
var statearr_15714_15878 = state_15629__$1;
(statearr_15714_15878[(1)] = (54));

} else {
var statearr_15715_15879 = state_15629__$1;
(statearr_15715_15879[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (25))){
var inst_15413 = (state_15629[(24)]);
var inst_15360 = (state_15629[(9)]);
var inst_15412 = (state_15629[(2)]);
var inst_15413__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15716 = state_15629;
(statearr_15716[(24)] = inst_15413__$1);

(statearr_15716[(18)] = inst_15412);

return statearr_15716;
})();
if(cljs.core.truth_(inst_15413__$1)){
var statearr_15717_15880 = state_15629__$1;
(statearr_15717_15880[(1)] = (29));

} else {
var statearr_15718_15881 = state_15629__$1;
(statearr_15718_15881[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (34))){
var inst_15429 = (state_15629[(20)]);
var inst_15360 = (state_15629[(9)]);
var inst_15428 = (state_15629[(2)]);
var inst_15429__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15719 = state_15629;
(statearr_15719[(20)] = inst_15429__$1);

(statearr_15719[(19)] = inst_15428);

return statearr_15719;
})();
if(cljs.core.truth_(inst_15429__$1)){
var statearr_15720_15882 = state_15629__$1;
(statearr_15720_15882[(1)] = (35));

} else {
var statearr_15721_15883 = state_15629__$1;
(statearr_15721_15883[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (17))){
var inst_15383 = (state_15629[(17)]);
var inst_15360 = (state_15629[(9)]);
var inst_15383__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15722 = state_15629;
(statearr_15722[(17)] = inst_15383__$1);

return statearr_15722;
})();
if(cljs.core.truth_(inst_15383__$1)){
var statearr_15723_15884 = state_15629__$1;
(statearr_15723_15884[(1)] = (20));

} else {
var statearr_15724_15885 = state_15629__$1;
(statearr_15724_15885[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (3))){
var inst_15627 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15629__$1,inst_15627);
} else {
if((state_val_15630 === (12))){
var inst_15364 = (state_15629[(25)]);
var state_15629__$1 = state_15629;
var statearr_15725_15886 = state_15629__$1;
(statearr_15725_15886[(2)] = inst_15364);

(statearr_15725_15886[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (2))){
var _ = (function (){var statearr_15726 = state_15629;
(statearr_15726[(4)] = cljs.core.cons((5),(state_15629[(4)])));

return statearr_15726;
})();
var inst_15340 = pred_changes;
var inst_15341 = cljs.core.seq(inst_15340);
var inst_15342 = cljs.core.first(inst_15341);
var inst_15343 = cljs.core.next(inst_15341);
var inst_15344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15342,(0),null);
var inst_15345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15342,(1),null);
var inst_15346 = db;
var inst_15347 = inst_15340;
var inst_15348 = inst_15346;
var state_15629__$1 = (function (){var statearr_15727 = state_15629;
(statearr_15727[(15)] = inst_15348);

(statearr_15727[(26)] = inst_15343);

(statearr_15727[(27)] = inst_15345);

(statearr_15727[(28)] = inst_15344);

(statearr_15727[(21)] = inst_15347);

return statearr_15727;
})();
var statearr_15728_15887 = state_15629__$1;
(statearr_15728_15887[(2)] = null);

(statearr_15728_15887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (66))){
var inst_15492 = (state_15629[(8)]);
var state_15629__$1 = state_15629;
var G__15729_15888 = inst_15492;
var G__15729_15889__$1 = (((G__15729_15888 instanceof cljs.core.Keyword))?G__15729_15888.fqn:null);
switch (G__15729_15889__$1) {
case "long":
var statearr_15730_15891 = state_15629__$1;
(statearr_15730_15891[(1)] = (70));


break;
case "bigint":
var statearr_15731_15892 = state_15629__$1;
(statearr_15731_15892[(1)] = (74));


break;
case "double":
var statearr_15732_15893 = state_15629__$1;
(statearr_15732_15893[(1)] = (78));


break;
case "float":
var statearr_15733_15894 = state_15629__$1;
(statearr_15733_15894[(1)] = (82));


break;
case "bigdec":
var statearr_15734_15895 = state_15629__$1;
(statearr_15734_15895[(1)] = (86));


break;
case "string":
var statearr_15735_15896 = state_15629__$1;
(statearr_15735_15896[(1)] = (90));


break;
case "instant":
var statearr_15736_15897 = state_15629__$1;
(statearr_15736_15897[(1)] = (94));


break;
default:
var statearr_15737_15898 = state_15629__$1;
(statearr_15737_15898[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (107))){
var inst_15358 = (state_15629[(23)]);
var inst_15619 = (state_15629[(2)]);
var inst_15347 = inst_15358;
var inst_15348 = inst_15619;
var state_15629__$1 = (function (){var statearr_15738 = state_15629;
(statearr_15738[(15)] = inst_15348);

(statearr_15738[(21)] = inst_15347);

return statearr_15738;
})();
var statearr_15739_15899 = state_15629__$1;
(statearr_15739_15899[(2)] = null);

(statearr_15739_15899[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (23))){
var state_15629__$1 = state_15629;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15740_15900 = state_15629__$1;
(statearr_15740_15900[(1)] = (26));

} else {
var statearr_15741_15901 = state_15629__$1;
(statearr_15741_15901[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (47))){
var inst_15466 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15466)){
var statearr_15742_15902 = state_15629__$1;
(statearr_15742_15902[(1)] = (48));

} else {
var statearr_15743_15903 = state_15629__$1;
(statearr_15743_15903[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (35))){
var inst_15348 = (state_15629[(15)]);
var inst_15360 = (state_15629[(9)]);
var inst_15359 = (state_15629[(22)]);
var inst_15431 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15432 = cljs.core.not(inst_15431);
var inst_15433 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15434 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15433);
var inst_15435 = inst_15434 === true;
var inst_15436 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_15348,inst_15359);
var state_15629__$1 = (function (){var statearr_15744 = state_15629;
(statearr_15744[(29)] = inst_15432);

(statearr_15744[(30)] = inst_15435);

return statearr_15744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15629__$1,(38),inst_15436);
} else {
if((state_val_15630 === (82))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15534 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15535 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15534,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,3,inst_15534,null));
var inst_15536 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15535,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15535,null));
var inst_15537 = (inst_15536.cljs$core$IFn$_invoke$arity$1 ? inst_15536.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15536.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15537)){
var statearr_15745_15904 = state_15629__$1;
(statearr_15745_15904[(1)] = (83));

} else {
var statearr_15746_15905 = state_15629__$1;
(statearr_15746_15905[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (76))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15520 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15747_15906 = state_15629__$1;
(statearr_15747_15906[(2)] = inst_15520);

(statearr_15747_15906[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (97))){
var inst_15572 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15748_15907 = state_15629__$1;
(statearr_15748_15907[(2)] = inst_15572);

(statearr_15748_15907[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (19))){
var inst_15399 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15399)){
var statearr_15749_15908 = state_15629__$1;
(statearr_15749_15908[(1)] = (23));

} else {
var statearr_15750_15909 = state_15629__$1;
(statearr_15750_15909[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (57))){
var inst_15469 = (state_15629[(10)]);
var inst_15487 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15469);
var state_15629__$1 = state_15629;
var statearr_15751_15910 = state_15629__$1;
(statearr_15751_15910[(2)] = inst_15487);

(statearr_15751_15910[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (68))){
var inst_15580 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15752_15911 = state_15629__$1;
(statearr_15752_15911[(2)] = inst_15580);

(statearr_15752_15911[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (11))){
var inst_15360 = (state_15629[(9)]);
var inst_15366 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15367 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15366);
var inst_15368 = inst_15367 === false;
var inst_15369 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15370 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15369);
var inst_15371 = inst_15370 === true;
var inst_15372 = ((inst_15368) && (inst_15371));
var state_15629__$1 = state_15629;
var statearr_15754_15912 = state_15629__$1;
(statearr_15754_15912[(2)] = inst_15372);

(statearr_15754_15912[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (9))){
var inst_15360 = (state_15629[(9)]);
var inst_15364 = (state_15629[(25)]);
var inst_15364__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15755 = state_15629;
(statearr_15755[(25)] = inst_15364__$1);

return statearr_15755;
})();
if(cljs.core.truth_(inst_15364__$1)){
var statearr_15756_15913 = state_15629__$1;
(statearr_15756_15913[(1)] = (11));

} else {
var statearr_15757_15914 = state_15629__$1;
(statearr_15757_15914[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (5))){
var _ = (function (){var statearr_15758 = state_15629;
(statearr_15758[(4)] = cljs.core.rest((state_15629[(4)])));

return statearr_15758;
})();
var state_15629__$1 = state_15629;
var ex15753 = (state_15629__$1[(2)]);
var statearr_15759_15915 = state_15629__$1;
(statearr_15759_15915[(5)] = ex15753);


if((ex15753 instanceof Error)){
var statearr_15760_15916 = state_15629__$1;
(statearr_15760_15916[(1)] = (4));

(statearr_15760_15916[(5)] = null);

} else {
throw ex15753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (83))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15761_15917 = state_15629__$1;
(statearr_15761_15917[(2)] = inst_15459);

(statearr_15761_15917[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (14))){
var inst_15348 = (state_15629[(15)]);
var inst_15377 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_15348,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15762_15918 = state_15629__$1;
(statearr_15762_15918[(2)] = inst_15377);

(statearr_15762_15918[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (45))){
var inst_15360 = (state_15629[(9)]);
var inst_15462 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15360);
var inst_15463 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15462);
var state_15629__$1 = state_15629;
var statearr_15763_15919 = state_15629__$1;
(statearr_15763_15919[(2)] = inst_15463);

(statearr_15763_15919[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (53))){
var inst_15485 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15485)){
var statearr_15764_15920 = state_15629__$1;
(statearr_15764_15920[(1)] = (57));

} else {
var statearr_15765_15921 = state_15629__$1;
(statearr_15765_15921[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (78))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15524 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15525 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_15524,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,3,inst_15524,null));
var inst_15526 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15525,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15525,null));
var inst_15527 = (inst_15526.cljs$core$IFn$_invoke$arity$1 ? inst_15526.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15526.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15527)){
var statearr_15766_15922 = state_15629__$1;
(statearr_15766_15922[(1)] = (79));

} else {
var statearr_15767_15923 = state_15629__$1;
(statearr_15767_15923[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (26))){
var inst_15402 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15403 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15404 = cljs.core.PersistentHashMap.fromArrays(inst_15402,inst_15403);
var inst_15405 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_15404);
var inst_15406 = (function(){throw inst_15405})();
var state_15629__$1 = state_15629;
var statearr_15768_15924 = state_15629__$1;
(statearr_15768_15924[(2)] = inst_15406);

(statearr_15768_15924[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (16))){
var inst_15381 = (state_15629[(31)]);
var inst_15360 = (state_15629[(9)]);
var inst_15380 = (state_15629[(2)]);
var inst_15381__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15360);
var state_15629__$1 = (function (){var statearr_15769 = state_15629;
(statearr_15769[(12)] = inst_15380);

(statearr_15769[(31)] = inst_15381__$1);

return statearr_15769;
})();
if(cljs.core.truth_(inst_15381__$1)){
var statearr_15770_15925 = state_15629__$1;
(statearr_15770_15925[(1)] = (17));

} else {
var statearr_15771_15926 = state_15629__$1;
(statearr_15771_15926[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (81))){
var inst_15532 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15772_15927 = state_15629__$1;
(statearr_15772_15927[(2)] = inst_15532);

(statearr_15772_15927[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (79))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15773_15928 = state_15629__$1;
(statearr_15773_15928[(2)] = inst_15459);

(statearr_15773_15928[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (38))){
var inst_15432 = (state_15629[(29)]);
var inst_15435 = (state_15629[(30)]);
var inst_15438 = (state_15629[(2)]);
var inst_15439 = fluree.db.util.async.throw_err(inst_15438);
var inst_15440 = cljs.core.not(inst_15439);
var inst_15441 = ((inst_15432) && (inst_15435) && (inst_15440));
var state_15629__$1 = state_15629;
var statearr_15774_15929 = state_15629__$1;
(statearr_15774_15929[(2)] = inst_15441);

(statearr_15774_15929[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (98))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15574 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15775_15930 = state_15629__$1;
(statearr_15775_15930[(2)] = inst_15574);

(statearr_15775_15930[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (87))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15776_15931 = state_15629__$1;
(statearr_15776_15931[(2)] = inst_15459);

(statearr_15776_15931[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (30))){
var inst_15413 = (state_15629[(24)]);
var state_15629__$1 = state_15629;
var statearr_15777_15932 = state_15629__$1;
(statearr_15777_15932[(2)] = inst_15413);

(statearr_15777_15932[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (73))){
var inst_15512 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15778_15933 = state_15629__$1;
(statearr_15778_15933[(2)] = inst_15512);

(statearr_15778_15933[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (96))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15570 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15779_15934 = state_15629__$1;
(statearr_15779_15934[(2)] = inst_15570);

(statearr_15779_15934[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (10))){
var inst_15622 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
var statearr_15780_15935 = state_15629__$1;
(statearr_15780_15935[(2)] = inst_15622);

(statearr_15780_15935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (18))){
var inst_15381 = (state_15629[(31)]);
var state_15629__$1 = state_15629;
var statearr_15781_15936 = state_15629__$1;
(statearr_15781_15936[(2)] = inst_15381);

(statearr_15781_15936[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (105))){
var state_15629__$1 = state_15629;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15782_15937 = state_15629__$1;
(statearr_15782_15937[(1)] = (108));

} else {
var statearr_15783_15938 = state_15629__$1;
(statearr_15783_15938[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (52))){
var state_15629__$1 = state_15629;
var statearr_15784_15939 = state_15629__$1;
(statearr_15784_15939[(2)] = false);

(statearr_15784_15939[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (67))){
var state_15629__$1 = state_15629;
var statearr_15785_15940 = state_15629__$1;
(statearr_15785_15940[(2)] = null);

(statearr_15785_15940[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (71))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15786_15941 = state_15629__$1;
(statearr_15786_15941[(2)] = inst_15459);

(statearr_15786_15941[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (42))){
var inst_15348 = (state_15629[(15)]);
var inst_15359 = (state_15629[(22)]);
var inst_15447 = fluree.db.dbproto._p_prop(inst_15348,new cljs.core.Keyword(null,"name","name",1843675177),inst_15359);
var inst_15448 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15447)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15450 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15451 = cljs.core.PersistentHashMap.fromArrays(inst_15449,inst_15450);
var inst_15452 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15448,inst_15451);
var inst_15453 = (function(){throw inst_15452})();
var state_15629__$1 = state_15629;
var statearr_15787_15942 = state_15629__$1;
(statearr_15787_15942[(2)] = inst_15453);

(statearr_15787_15942[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (80))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15530 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15788_15943 = state_15629__$1;
(statearr_15788_15943[(2)] = inst_15530);

(statearr_15788_15943[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (37))){
var inst_15444 = (state_15629[(2)]);
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15444)){
var statearr_15789_15944 = state_15629__$1;
(statearr_15789_15944[(1)] = (39));

} else {
var statearr_15790_15945 = state_15629__$1;
(statearr_15790_15945[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (63))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15501 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15791_15946 = state_15629__$1;
(statearr_15791_15946[(2)] = inst_15501);

(statearr_15791_15946[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (94))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15564 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15565 = (inst_15492.cljs$core$IFn$_invoke$arity$5 ? inst_15492.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_15564,null) : inst_15492.call(null,cljs.core.PersistentArrayMap,null,2,inst_15564,null));
var inst_15566 = (inst_15492.cljs$core$IFn$_invoke$arity$4 ? inst_15492.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_15565,null) : inst_15492.call(null,cljs.core.PersistentHashSet,null,inst_15565,null));
var inst_15567 = (inst_15566.cljs$core$IFn$_invoke$arity$1 ? inst_15566.cljs$core$IFn$_invoke$arity$1(inst_15491) : inst_15566.call(null,inst_15491));
var state_15629__$1 = state_15629;
if(cljs.core.truth_(inst_15567)){
var statearr_15792_15947 = state_15629__$1;
(statearr_15792_15947[(1)] = (95));

} else {
var statearr_15793_15948 = state_15629__$1;
(statearr_15793_15948[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (8))){
var inst_15348 = (state_15629[(15)]);
var state_15629__$1 = state_15629;
var statearr_15794_15949 = state_15629__$1;
(statearr_15794_15949[(2)] = inst_15348);

(statearr_15794_15949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (49))){
var inst_15459 = (state_15629[(11)]);
var state_15629__$1 = state_15629;
var statearr_15795_15950 = state_15629__$1;
(statearr_15795_15950[(2)] = inst_15459);

(statearr_15795_15950[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15630 === (84))){
var inst_15491 = (state_15629[(7)]);
var inst_15492 = (state_15629[(8)]);
var inst_15540 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_15491,inst_15492,throw_QMARK_);
var state_15629__$1 = state_15629;
var statearr_15796_15951 = state_15629__$1;
(statearr_15796_15951[(2)] = inst_15540);

(statearr_15796_15951[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2414__auto__ = null;
var fluree$db$query$schema$state_machine__2414__auto____0 = (function (){
var statearr_15797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15797[(0)] = fluree$db$query$schema$state_machine__2414__auto__);

(statearr_15797[(1)] = (1));

return statearr_15797;
});
var fluree$db$query$schema$state_machine__2414__auto____1 = (function (state_15629){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15629);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15798){var ex__2417__auto__ = e15798;
var statearr_15799_15952 = state_15629;
(statearr_15799_15952[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15629[(4)]))){
var statearr_15800_15953 = state_15629;
(statearr_15800_15953[(1)] = cljs.core.first((state_15629[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15954 = state_15629;
state_15629 = G__15954;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2414__auto__ = function(state_15629){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2414__auto____1.call(this,state_15629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2414__auto____0;
fluree$db$query$schema$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2414__auto____1;
return fluree$db$query$schema$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15801 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15801[(6)] = c__2436__auto__);

return statearr_15801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15978){
var state_val_15979 = (state_15978[(1)]);
if((state_val_15979 === (7))){
var state_15978__$1 = state_15978;
var statearr_15980_15999 = state_15978__$1;
(statearr_15980_15999[(2)] = db);

(statearr_15980_15999[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (1))){
var state_15978__$1 = state_15978;
var statearr_15981_16000 = state_15978__$1;
(statearr_15981_16000[(2)] = null);

(statearr_15981_16000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (4))){
var inst_15955 = (state_15978[(2)]);
var state_15978__$1 = state_15978;
var statearr_15982_16001 = state_15978__$1;
(statearr_15982_16001[(2)] = inst_15955);

(statearr_15982_16001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (6))){
var inst_15964 = (state_15978[(7)]);
var inst_15963 = (state_15978[(2)]);
var inst_15964__$1 = fluree.db.util.async.throw_err(inst_15963);
var inst_15965 = cljs.core.empty_QMARK_(inst_15964__$1);
var state_15978__$1 = (function (){var statearr_15983 = state_15978;
(statearr_15983[(7)] = inst_15964__$1);

return statearr_15983;
})();
if(inst_15965){
var statearr_15984_16002 = state_15978__$1;
(statearr_15984_16002[(1)] = (7));

} else {
var statearr_15985_16003 = state_15978__$1;
(statearr_15985_16003[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (3))){
var inst_15976 = (state_15978[(2)]);
var state_15978__$1 = state_15978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15978__$1,inst_15976);
} else {
if((state_val_15979 === (2))){
var _ = (function (){var statearr_15987 = state_15978;
(statearr_15987[(4)] = cljs.core.cons((5),(state_15978[(4)])));

return statearr_15987;
})();
var inst_15961 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_15978__$1 = state_15978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15978__$1,(6),inst_15961);
} else {
if((state_val_15979 === (9))){
var inst_15973 = (state_15978[(2)]);
var _ = (function (){var statearr_15988 = state_15978;
(statearr_15988[(4)] = cljs.core.rest((state_15978[(4)])));

return statearr_15988;
})();
var state_15978__$1 = state_15978;
var statearr_15989_16004 = state_15978__$1;
(statearr_15989_16004[(2)] = inst_15973);

(statearr_15989_16004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (5))){
var _ = (function (){var statearr_15990 = state_15978;
(statearr_15990[(4)] = cljs.core.rest((state_15978[(4)])));

return statearr_15990;
})();
var state_15978__$1 = state_15978;
var ex15986 = (state_15978__$1[(2)]);
var statearr_15991_16005 = state_15978__$1;
(statearr_15991_16005[(5)] = ex15986);


if((ex15986 instanceof Error)){
var statearr_15992_16006 = state_15978__$1;
(statearr_15992_16006[(1)] = (4));

(statearr_15992_16006[(5)] = null);

} else {
throw ex15986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (10))){
var inst_15970 = (state_15978[(2)]);
var inst_15971 = fluree.db.util.async.throw_err(inst_15970);
var state_15978__$1 = state_15978;
var statearr_15993_16007 = state_15978__$1;
(statearr_15993_16007[(2)] = inst_15971);

(statearr_15993_16007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15979 === (8))){
var inst_15964 = (state_15978[(7)]);
var inst_15968 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_15964,db,true);
var state_15978__$1 = state_15978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15978__$1,(10),inst_15968);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0 = (function (){
var statearr_15994 = [null,null,null,null,null,null,null,null];
(statearr_15994[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__);

(statearr_15994[(1)] = (1));

return statearr_15994;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1 = (function (state_15978){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15978);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15995){var ex__2417__auto__ = e15995;
var statearr_15996_16008 = state_15978;
(statearr_15996_16008[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15978[(4)]))){
var statearr_15997_16009 = state_15978;
(statearr_15997_16009[(1)] = cljs.core.first((state_15978[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16010 = state_15978;
state_15978 = G__16010;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__ = function(state_15978){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1.call(this,state_15978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15998 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15998[(6)] = c__2436__auto__);

return statearr_15998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16012 = arguments.length;
switch (G__16012) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16014 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16014,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16014,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16014,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16017_SHARP_,p2__16018_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16017_SHARP_,p2__16018_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16084){
var state_val_16085 = (state_16084[(1)]);
if((state_val_16085 === (1))){
var state_16084__$1 = state_16084;
var statearr_16086_16104 = state_16084__$1;
(statearr_16086_16104[(2)] = null);

(statearr_16086_16104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16085 === (2))){
var _ = (function (){var statearr_16087 = state_16084;
(statearr_16087[(4)] = cljs.core.cons((5),(state_16084[(4)])));

return statearr_16087;
})();
var inst_16036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16037 = fluree.db.flake.max_subject_id((1));
var inst_16038 = [inst_16037];
var inst_16039 = (new cljs.core.PersistentVector(null,1,(5),inst_16036,inst_16038,null));
var inst_16040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16041 = [(0)];
var inst_16042 = (new cljs.core.PersistentVector(null,1,(5),inst_16040,inst_16041,null));
var inst_16043 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16039,cljs.core._LT__EQ_,inst_16042);
var state_16084__$1 = state_16084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16084__$1,(6),inst_16043);
} else {
if((state_val_16085 === (3))){
var inst_16082 = (state_16084[(2)]);
var state_16084__$1 = state_16084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16084__$1,inst_16082);
} else {
if((state_val_16085 === (4))){
var inst_16024 = (state_16084[(2)]);
var state_16084__$1 = state_16084;
var statearr_16089_16105 = state_16084__$1;
(statearr_16089_16105[(2)] = inst_16024);

(statearr_16089_16105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16085 === (5))){
var _ = (function (){var statearr_16090 = state_16084;
(statearr_16090[(4)] = cljs.core.rest((state_16084[(4)])));

return statearr_16090;
})();
var state_16084__$1 = state_16084;
var ex16088 = (state_16084__$1[(2)]);
var statearr_16091_16106 = state_16084__$1;
(statearr_16091_16106[(5)] = ex16088);


if((ex16088 instanceof Error)){
var statearr_16092_16107 = state_16084__$1;
(statearr_16092_16107[(1)] = (4));

(statearr_16092_16107[(5)] = null);

} else {
throw ex16088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16085 === (6))){
var inst_16045 = (state_16084[(2)]);
var inst_16046 = fluree.db.util.async.throw_err(inst_16045);
var inst_16047 = (function (){var schema_flakes = inst_16046;
return (function (p1__16019_SHARP_){
return (p1__16019_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16048 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16047,inst_16046);
var inst_16049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16048,(0),null);
var inst_16050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16048,(1),null);
var inst_16051 = (function (){var schema_flakes = inst_16046;
var vec__16030 = inst_16048;
var collection_flakes = inst_16049;
var predicate_flakes = inst_16050;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16021_SHARP_,p2__16022_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16021_SHARP_,p2__16022_SHARP_.p,p2__16022_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_16052 = [(-1),"_tx"];
var inst_16053 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_16054 = ["_tx",(-1),(-1)];
var inst_16055 = cljs.core.PersistentHashMap.fromArrays(inst_16053,inst_16054);
var inst_16056 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_16057 = ["_tx",(-1),(-1)];
var inst_16058 = cljs.core.PersistentHashMap.fromArrays(inst_16056,inst_16057);
var inst_16059 = [inst_16055,inst_16058];
var inst_16060 = cljs.core.PersistentHashMap.fromArrays(inst_16052,inst_16059);
var inst_16061 = (function (){var schema_flakes = inst_16046;
var vec__16030 = inst_16048;
var collection_flakes = inst_16049;
var predicate_flakes = inst_16050;
return (function (p1__16020_SHARP_){
return p1__16020_SHARP_.s;
});
})();
var inst_16062 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16061,inst_16049);
var inst_16063 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16051,inst_16060,inst_16062);
var inst_16065 = (function (){var schema_flakes = inst_16046;
var vec__16030 = inst_16048;
var collection_flakes = inst_16049;
var predicate_flakes = inst_16050;
var coll = inst_16063;
return (function (p__16064,pred_flakes){
var vec__16093 = p__16064;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16093,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16093,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__16096 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__16096.cljs$core$IFn$_invoke$arity$1 ? fexpr__16096.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__16096.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_16066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16067 = cljs.core.PersistentHashMap.EMPTY;
var inst_16068 = cljs.core.PersistentHashSet.EMPTY;
var inst_16069 = [inst_16067,inst_16068];
var inst_16070 = (new cljs.core.PersistentVector(null,2,(5),inst_16066,inst_16069,null));
var inst_16071 = (function (){var schema_flakes = inst_16046;
var vec__16030 = inst_16048;
var collection_flakes = inst_16049;
var predicate_flakes = inst_16050;
var coll = inst_16063;
return (function (p1__16023_SHARP_){
return p1__16023_SHARP_.s;
});
})();
var inst_16072 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_16071,inst_16050);
var inst_16073 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16065,inst_16070,inst_16072);
var inst_16074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16073,(0),null);
var inst_16075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16073,(1),null);
var inst_16076 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16077 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16078 = [inst_16077,inst_16063,inst_16074,inst_16075];
var inst_16079 = cljs.core.PersistentHashMap.fromArrays(inst_16076,inst_16078);
var _ = (function (){var statearr_16097 = state_16084;
(statearr_16097[(4)] = cljs.core.rest((state_16084[(4)])));

return statearr_16097;
})();
var state_16084__$1 = state_16084;
var statearr_16098_16108 = state_16084__$1;
(statearr_16098_16108[(2)] = inst_16079);

(statearr_16098_16108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0 = (function (){
var statearr_16099 = [null,null,null,null,null,null,null];
(statearr_16099[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2414__auto__);

(statearr_16099[(1)] = (1));

return statearr_16099;
});
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1 = (function (state_16084){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16084);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16100){var ex__2417__auto__ = e16100;
var statearr_16101_16109 = state_16084;
(statearr_16101_16109[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16084[(4)]))){
var statearr_16102_16110 = state_16084;
(statearr_16102_16110[(1)] = cljs.core.first((state_16084[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16111 = state_16084;
state_16084 = G__16111;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__ = function(state_16084){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1.call(this,state_16084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16103 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16103[(6)] = c__2436__auto__);

return statearr_16103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16153){
var state_val_16154 = (state_16153[(1)]);
if((state_val_16154 === (7))){
var inst_16136 = (state_16153[(2)]);
var inst_16137 = fluree.db.query.schema.flake__GT_pred_map(inst_16136);
var inst_16138 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(114));
var inst_16140 = cljs.core.boolean$(inst_16139);
var inst_16141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(110));
var inst_16142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(117));
var inst_16143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_16142);
var inst_16144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(111));
var inst_16145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(115));
var inst_16146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16137,(112));
var inst_16147 = [inst_16140,inst_16141,inst_16143,inst_16144,inst_16145,inst_16146];
var inst_16148 = cljs.core.PersistentHashMap.fromArrays(inst_16138,inst_16147);
var _ = (function (){var statearr_16155 = state_16153;
(statearr_16155[(4)] = cljs.core.rest((state_16153[(4)])));

return statearr_16155;
})();
var state_16153__$1 = state_16153;
var statearr_16156_16179 = state_16153__$1;
(statearr_16156_16179[(2)] = inst_16148);

(statearr_16156_16179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (1))){
var state_16153__$1 = state_16153;
var statearr_16157_16180 = state_16153__$1;
(statearr_16157_16180[(2)] = null);

(statearr_16157_16180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (4))){
var inst_16112 = (state_16153[(2)]);
var state_16153__$1 = state_16153;
var statearr_16158_16181 = state_16153__$1;
(statearr_16158_16181[(2)] = inst_16112);

(statearr_16158_16181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (6))){
var _ = (function (){var statearr_16159 = state_16153;
(statearr_16159[(4)] = cljs.core.cons((9),(state_16153[(4)])));

return statearr_16159;
})();
var inst_16124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16126 = ["_setting/id","root"];
var inst_16127 = (new cljs.core.PersistentVector(null,2,(5),inst_16125,inst_16126,null));
var inst_16128 = [inst_16127];
var inst_16129 = (new cljs.core.PersistentVector(null,1,(5),inst_16124,inst_16128,null));
var inst_16130 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16129);
var state_16153__$1 = state_16153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16153__$1,(10),inst_16130);
} else {
if((state_val_16154 === (3))){
var inst_16151 = (state_16153[(2)]);
var state_16153__$1 = state_16153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16153__$1,inst_16151);
} else {
if((state_val_16154 === (2))){
var _ = (function (){var statearr_16162 = state_16153;
(statearr_16162[(4)] = cljs.core.cons((5),(state_16153[(4)])));

return statearr_16162;
})();
var state_16153__$1 = state_16153;
var statearr_16163_16182 = state_16153__$1;
(statearr_16163_16182[(2)] = null);

(statearr_16163_16182[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (9))){
var _ = (function (){var statearr_16164 = state_16153;
(statearr_16164[(4)] = cljs.core.rest((state_16153[(4)])));

return statearr_16164;
})();
var state_16153__$1 = state_16153;
var ex16160 = (state_16153__$1[(2)]);
var statearr_16165_16183 = state_16153__$1;
(statearr_16165_16183[(5)] = ex16160);


var statearr_16166_16184 = state_16153__$1;
(statearr_16166_16184[(1)] = (8));

(statearr_16166_16184[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (5))){
var _ = (function (){var statearr_16167 = state_16153;
(statearr_16167[(4)] = cljs.core.rest((state_16153[(4)])));

return statearr_16167;
})();
var state_16153__$1 = state_16153;
var ex16161 = (state_16153__$1[(2)]);
var statearr_16168_16185 = state_16153__$1;
(statearr_16168_16185[(5)] = ex16161);


if((ex16161 instanceof Error)){
var statearr_16169_16186 = state_16153__$1;
(statearr_16169_16186[(1)] = (4));

(statearr_16169_16186[(5)] = null);

} else {
throw ex16161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (10))){
var inst_16132 = (state_16153[(2)]);
var inst_16133 = fluree.db.util.async.throw_err(inst_16132);
var _ = (function (){var statearr_16170 = state_16153;
(statearr_16170[(4)] = cljs.core.rest((state_16153[(4)])));

return statearr_16170;
})();
var state_16153__$1 = state_16153;
var statearr_16171_16187 = state_16153__$1;
(statearr_16171_16187[(2)] = inst_16133);

(statearr_16171_16187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16154 === (8))){
var inst_16118 = (state_16153[(2)]);
var state_16153__$1 = (function (){var statearr_16172 = state_16153;
(statearr_16172[(7)] = inst_16118);

return statearr_16172;
})();
var statearr_16173_16188 = state_16153__$1;
(statearr_16173_16188[(2)] = null);

(statearr_16173_16188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0 = (function (){
var statearr_16174 = [null,null,null,null,null,null,null,null];
(statearr_16174[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2414__auto__);

(statearr_16174[(1)] = (1));

return statearr_16174;
});
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1 = (function (state_16153){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16153);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16175){var ex__2417__auto__ = e16175;
var statearr_16176_16189 = state_16153;
(statearr_16176_16189[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16153[(4)]))){
var statearr_16177_16190 = state_16153;
(statearr_16177_16190[(1)] = cljs.core.first((state_16153[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16191 = state_16153;
state_16153 = G__16191;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__ = function(state_16153){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1.call(this,state_16153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16178 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16178[(6)] = c__2436__auto__);

return statearr_16178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
