// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27728,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27732 = k27728;
var G__27732__$1 = (((G__27732 instanceof cljs.core.Keyword))?G__27732.fqn:null);
switch (G__27732__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27728,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__27733){
var vec__27734 = p__27733;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27734,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27734,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27727){
var self__ = this;
var G__27727__$1 = this;
return (new cljs.core.RecordIter((0),G__27727__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (){var fexpr__27737 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
});
return fexpr__27737(this__4376__auto____$1);
})();
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27729,other27730){
var self__ = this;
var this27729__$1 = this;
return (((!((other27730 == null)))) && ((this27729__$1.constructor === other27730.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.conn,other27730.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.network,other27730.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.dbid,other27730.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.db_name,other27730.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.update_chan,other27730.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.transact_chan,other27730.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.state,other27730.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.schema_cache,other27730.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.blank_db,other27730.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.close,other27730.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.id,other27730.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27729__$1.__extmap,other27730.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27727){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27738 = cljs.core.keyword_identical_QMARK_;
var expr__27739 = k__4388__auto__;
if(cljs.core.truth_((function (){var G__27741 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27742 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27741,G__27742) : pred__27738.call(null,G__27741,G__27742));
})())){
return (new fluree.db.session.DbSession(G__27727,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27743 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27744 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27743,G__27744) : pred__27738.call(null,G__27743,G__27744));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27727,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27745 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27746 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27745,G__27746) : pred__27738.call(null,G__27745,G__27746));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27727,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27747 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27748 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27747,G__27748) : pred__27738.call(null,G__27747,G__27748));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27727,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27749 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27750 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27749,G__27750) : pred__27738.call(null,G__27749,G__27750));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27727,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27751 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27752 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27751,G__27752) : pred__27738.call(null,G__27751,G__27752));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27727,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27753 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27754 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27753,G__27754) : pred__27738.call(null,G__27753,G__27754));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27727,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27755 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27756 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27755,G__27756) : pred__27738.call(null,G__27755,G__27756));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27727,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27757 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27758 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27757,G__27758) : pred__27738.call(null,G__27757,G__27758));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27727,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27759 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27760 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27759,G__27760) : pred__27738.call(null,G__27759,G__27760));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27727,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27761 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27762 = expr__27739;
return (pred__27738.cljs$core$IFn$_invoke$arity$2 ? pred__27738.cljs$core$IFn$_invoke$arity$2(G__27761,G__27762) : pred__27738.call(null,G__27761,G__27762));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27727,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__27727),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27727){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27727,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27731){
var extmap__4419__auto__ = (function (){var G__27763 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27731,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27731)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27763);
} else {
return G__27763;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27731),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27731),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27765 = session;
var map__27765__$1 = (((((!((map__27765 == null))))?(((((map__27765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27765.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27765):map__27765);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27765__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27765__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___27983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_27910){
var state_val_27911 = (state_27910[(1)]);
if((state_val_27911 === (7))){
var state_27910__$1 = state_27910;
var statearr_27912_27984 = state_27910__$1;
(statearr_27912_27984[(2)] = false);

(statearr_27912_27984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (20))){
var inst_27800 = (state_27910[(7)]);
var inst_27807 = (state_27910[(8)]);
var inst_27799 = (state_27910[(9)]);
var inst_27816 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27807);
var inst_27817 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27799),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27800)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27816),"."].join('');
var state_27910__$1 = state_27910;
var statearr_27913_27985 = state_27910__$1;
(statearr_27913_27985[(2)] = inst_27817);

(statearr_27913_27985[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (27))){
var inst_27891 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27914_27986 = state_27910__$1;
(statearr_27914_27986[(2)] = inst_27891);

(statearr_27914_27986[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (1))){
var state_27910__$1 = state_27910;
var statearr_27915_27987 = state_27910__$1;
(statearr_27915_27987[(2)] = null);

(statearr_27915_27987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (24))){
var state_27910__$1 = state_27910;
var statearr_27916_27988 = state_27910__$1;
(statearr_27916_27988[(2)] = null);

(statearr_27916_27988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (39))){
var state_27910__$1 = state_27910;
var statearr_27917_27989 = state_27910__$1;
(statearr_27917_27989[(2)] = false);

(statearr_27917_27989[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (46))){
var inst_27899 = (state_27910[(10)]);
var inst_27902 = (state_27910[(2)]);
var inst_27903 = fluree.db.util.async.throw_err(inst_27902);
var inst_27904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27899,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27903);
var inst_27905 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27904);
var _ = (function (){var statearr_27918 = state_27910;
(statearr_27918[(4)] = cljs.core.rest((state_27910[(4)])));

return statearr_27918;
})();
var state_27910__$1 = state_27910;
var statearr_27919_27990 = state_27910__$1;
(statearr_27919_27990[(2)] = inst_27905);

(statearr_27919_27990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (4))){
var inst_27767 = (state_27910[(2)]);
var inst_27768 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_27767);
var state_27910__$1 = state_27910;
var statearr_27920_27991 = state_27910__$1;
(statearr_27920_27991[(2)] = inst_27768);

(statearr_27920_27991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (15))){
var inst_27807 = (state_27910[(8)]);
var inst_27806 = (state_27910[(2)]);
var inst_27807__$1 = fluree.db.util.async.throw_err(inst_27806);
var inst_27808 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27807__$1);
var inst_27809 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27808);
var inst_27810 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27809);
var state_27910__$1 = (function (){var statearr_27921 = state_27910;
(statearr_27921[(8)] = inst_27807__$1);

return statearr_27921;
})();
if(inst_27810){
var statearr_27922_27992 = state_27910__$1;
(statearr_27922_27992[(1)] = (16));

} else {
var statearr_27923_27993 = state_27910__$1;
(statearr_27923_27993[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (21))){
var inst_27819 = (state_27910[(2)]);
var inst_27820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27821 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27822 = cljs.core.PersistentHashMap.fromArrays(inst_27820,inst_27821);
var inst_27823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27819,inst_27822);
var inst_27824 = (function(){throw inst_27823})();
var state_27910__$1 = state_27910;
var statearr_27924_27994 = state_27910__$1;
(statearr_27924_27994[(2)] = inst_27824);

(statearr_27924_27994[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (31))){
var inst_27846 = (state_27910[(11)]);
var inst_27845 = (state_27910[(2)]);
var inst_27846__$1 = fluree.db.util.async.throw_err(inst_27845);
var state_27910__$1 = (function (){var statearr_27925 = state_27910;
(statearr_27925[(11)] = inst_27846__$1);

return statearr_27925;
})();
if(cljs.core.truth_(inst_27846__$1)){
var statearr_27926_27995 = state_27910__$1;
(statearr_27926_27995[(1)] = (32));

} else {
var statearr_27927_27996 = state_27910__$1;
(statearr_27927_27996[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (32))){
var inst_27846 = (state_27910[(11)]);
var inst_27850 = (inst_27846 == null);
var inst_27851 = cljs.core.not(inst_27850);
var state_27910__$1 = state_27910;
if(inst_27851){
var statearr_27928_27997 = state_27910__$1;
(statearr_27928_27997[(1)] = (35));

} else {
var statearr_27929_27998 = state_27910__$1;
(statearr_27929_27998[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (40))){
var inst_27861 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27930_27999 = state_27910__$1;
(statearr_27930_27999[(2)] = inst_27861);

(statearr_27930_27999[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (33))){
var inst_27838 = (state_27910[(12)]);
var inst_27800 = (state_27910[(7)]);
var inst_27799 = (state_27910[(9)]);
var inst_27880 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27838)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27799),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27800),"."].join('');
var inst_27881 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27882 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27883 = cljs.core.PersistentHashMap.fromArrays(inst_27881,inst_27882);
var inst_27884 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27880,inst_27883);
var inst_27885 = (function(){throw inst_27884})();
var state_27910__$1 = state_27910;
var statearr_27931_28000 = state_27910__$1;
(statearr_27931_28000[(2)] = inst_27885);

(statearr_27931_28000[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (13))){
var inst_27776 = (state_27910[(13)]);
var state_27910__$1 = state_27910;
var statearr_27932_28001 = state_27910__$1;
(statearr_27932_28001[(2)] = inst_27776);

(statearr_27932_28001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (22))){
var inst_27832 = (state_27910[(14)]);
var inst_27807 = (state_27910[(8)]);
var inst_27831 = (state_27910[(2)]);
var inst_27832__$1 = fluree.db.util.async.throw_err(inst_27831);
var inst_27833 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27807);
var state_27910__$1 = (function (){var statearr_27933 = state_27910;
(statearr_27933[(14)] = inst_27832__$1);

(statearr_27933[(15)] = inst_27833);

return statearr_27933;
})();
if(cljs.core.truth_(inst_27832__$1)){
var statearr_27934_28002 = state_27910__$1;
(statearr_27934_28002[(1)] = (23));

} else {
var statearr_27935_28003 = state_27910__$1;
(statearr_27935_28003[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (36))){
var state_27910__$1 = state_27910;
var statearr_27936_28004 = state_27910__$1;
(statearr_27936_28004[(2)] = false);

(statearr_27936_28004[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (41))){
var inst_27846 = (state_27910[(11)]);
var inst_27866 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27846);
var state_27910__$1 = state_27910;
var statearr_27937_28005 = state_27910__$1;
(statearr_27937_28005[(2)] = inst_27866);

(statearr_27937_28005[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (43))){
var inst_27837 = (state_27910[(16)]);
var inst_27869 = (state_27910[(2)]);
var inst_27870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27869,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27869,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27869,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27873 = fluree.db.dbproto._with(inst_27837,inst_27871,inst_27870);
var state_27910__$1 = (function (){var statearr_27938 = state_27910;
(statearr_27938[(17)] = inst_27872);

return statearr_27938;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(44),inst_27873);
} else {
if((state_val_27911 === (29))){
var inst_27838 = (state_27910[(12)]);
var inst_27800 = (state_27910[(7)]);
var inst_27798 = (state_27910[(18)]);
var inst_27799 = (state_27910[(9)]);
var inst_27843 = fluree.db.storage.core.read_block(inst_27798,inst_27799,inst_27800,inst_27838);
var state_27910__$1 = state_27910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(31),inst_27843);
} else {
if((state_val_27911 === (44))){
var inst_27838 = (state_27910[(12)]);
var inst_27875 = (state_27910[(2)]);
var inst_27876 = fluree.db.util.async.throw_err(inst_27875);
var inst_27877 = (inst_27838 + (1));
var inst_27837 = inst_27876;
var inst_27838__$1 = inst_27877;
var state_27910__$1 = (function (){var statearr_27939 = state_27910;
(statearr_27939[(12)] = inst_27838__$1);

(statearr_27939[(16)] = inst_27837);

return statearr_27939;
})();
var statearr_27940_28006 = state_27910__$1;
(statearr_27940_28006[(2)] = null);

(statearr_27940_28006[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (6))){
var inst_27776 = (state_27910[(13)]);
var inst_27781 = inst_27776.cljs$lang$protocol_mask$partition0$;
var inst_27782 = (inst_27781 & (64));
var inst_27783 = inst_27776.cljs$core$ISeq$;
var inst_27784 = (cljs.core.PROTOCOL_SENTINEL === inst_27783);
var inst_27785 = ((inst_27782) || (inst_27784));
var state_27910__$1 = state_27910;
if(cljs.core.truth_(inst_27785)){
var statearr_27941_28007 = state_27910__$1;
(statearr_27941_28007[(1)] = (9));

} else {
var statearr_27942_28008 = state_27910__$1;
(statearr_27942_28008[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (28))){
var inst_27837 = (state_27910[(16)]);
var state_27910__$1 = state_27910;
var statearr_27943_28009 = state_27910__$1;
(statearr_27943_28009[(2)] = inst_27837);

(statearr_27943_28009[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (25))){
var inst_27894 = (state_27910[(19)]);
var inst_27894__$1 = (state_27910[(2)]);
var inst_27895 = fluree.db.query.schema.schema_map(inst_27894__$1);
var state_27910__$1 = (function (){var statearr_27944 = state_27910;
(statearr_27944[(19)] = inst_27894__$1);

return statearr_27944;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(45),inst_27895);
} else {
if((state_val_27911 === (34))){
var inst_27887 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27945_28010 = state_27910__$1;
(statearr_27945_28010[(2)] = inst_27887);

(statearr_27945_28010[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (17))){
var state_27910__$1 = state_27910;
var statearr_27946_28011 = state_27910__$1;
(statearr_27946_28011[(2)] = null);

(statearr_27946_28011[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (3))){
var inst_27908 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27910__$1,inst_27908);
} else {
if((state_val_27911 === (12))){
var inst_27776 = (state_27910[(13)]);
var inst_27794 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27776);
var state_27910__$1 = state_27910;
var statearr_27947_28012 = state_27910__$1;
(statearr_27947_28012[(2)] = inst_27794);

(statearr_27947_28012[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (2))){
var inst_27776 = (state_27910[(13)]);
var _ = (function (){var statearr_27948 = state_27910;
(statearr_27948[(4)] = cljs.core.cons((5),(state_27910[(4)])));

return statearr_27948;
})();
var inst_27775 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27776__$1 = session;
var inst_27778 = (inst_27776__$1 == null);
var inst_27779 = cljs.core.not(inst_27778);
var state_27910__$1 = (function (){var statearr_27949 = state_27910;
(statearr_27949[(20)] = inst_27775);

(statearr_27949[(13)] = inst_27776__$1);

return statearr_27949;
})();
if(inst_27779){
var statearr_27950_28013 = state_27910__$1;
(statearr_27950_28013[(1)] = (6));

} else {
var statearr_27951_28014 = state_27910__$1;
(statearr_27951_28014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (23))){
var inst_27832 = (state_27910[(14)]);
var inst_27835 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27832);
var inst_27836 = (inst_27835 + (1));
var inst_27837 = inst_27832;
var inst_27838 = inst_27836;
var state_27910__$1 = (function (){var statearr_27952 = state_27910;
(statearr_27952[(12)] = inst_27838);

(statearr_27952[(16)] = inst_27837);

return statearr_27952;
})();
var statearr_27953_28015 = state_27910__$1;
(statearr_27953_28015[(2)] = null);

(statearr_27953_28015[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (35))){
var inst_27846 = (state_27910[(11)]);
var inst_27853 = inst_27846.cljs$lang$protocol_mask$partition0$;
var inst_27854 = (inst_27853 & (64));
var inst_27855 = inst_27846.cljs$core$ISeq$;
var inst_27856 = (cljs.core.PROTOCOL_SENTINEL === inst_27855);
var inst_27857 = ((inst_27854) || (inst_27856));
var state_27910__$1 = state_27910;
if(cljs.core.truth_(inst_27857)){
var statearr_27954_28016 = state_27910__$1;
(statearr_27954_28016[(1)] = (38));

} else {
var statearr_27955_28017 = state_27910__$1;
(statearr_27955_28017[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (19))){
var inst_27800 = (state_27910[(7)]);
var inst_27799 = (state_27910[(9)]);
var inst_27814 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27799),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27800)," is not found on this ledger group."].join('');
var state_27910__$1 = state_27910;
var statearr_27956_28018 = state_27910__$1;
(statearr_27956_28018[(2)] = inst_27814);

(statearr_27956_28018[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (11))){
var inst_27789 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27958_28019 = state_27910__$1;
(statearr_27958_28019[(2)] = inst_27789);

(statearr_27958_28019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (9))){
var state_27910__$1 = state_27910;
var statearr_27959_28020 = state_27910__$1;
(statearr_27959_28020[(2)] = true);

(statearr_27959_28020[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (5))){
var _ = (function (){var statearr_27960 = state_27910;
(statearr_27960[(4)] = cljs.core.rest((state_27910[(4)])));

return statearr_27960;
})();
var state_27910__$1 = state_27910;
var ex27957 = (state_27910__$1[(2)]);
var statearr_27961_28021 = state_27910__$1;
(statearr_27961_28021[(5)] = ex27957);


var statearr_27962_28022 = state_27910__$1;
(statearr_27962_28022[(1)] = (4));

(statearr_27962_28022[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (14))){
var inst_27800 = (state_27910[(7)]);
var inst_27798 = (state_27910[(18)]);
var inst_27799 = (state_27910[(9)]);
var inst_27797 = (state_27910[(2)]);
var inst_27798__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27797,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27799__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27797,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27800__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27797,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27802 = [inst_27799__$1,inst_27800__$1];
var inst_27803 = (new cljs.core.PersistentVector(null,2,(5),inst_27801,inst_27802,null));
var inst_27804 = fluree.db.operations.ledger_info_async(inst_27798__$1,inst_27803);
var state_27910__$1 = (function (){var statearr_27963 = state_27910;
(statearr_27963[(7)] = inst_27800__$1);

(statearr_27963[(18)] = inst_27798__$1);

(statearr_27963[(9)] = inst_27799__$1);

return statearr_27963;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(15),inst_27804);
} else {
if((state_val_27911 === (45))){
var inst_27899 = (state_27910[(10)]);
var inst_27894 = (state_27910[(19)]);
var inst_27897 = (state_27910[(2)]);
var inst_27898 = fluree.db.util.async.throw_err(inst_27897);
var inst_27899__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27894,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27898);
var inst_27900 = fluree.db.query.schema.setting_map(inst_27899__$1);
var state_27910__$1 = (function (){var statearr_27964 = state_27910;
(statearr_27964[(10)] = inst_27899__$1);

return statearr_27964;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(46),inst_27900);
} else {
if((state_val_27911 === (26))){
var inst_27838 = (state_27910[(12)]);
var inst_27833 = (state_27910[(15)]);
var inst_27840 = (inst_27838 > inst_27833);
var state_27910__$1 = state_27910;
if(cljs.core.truth_(inst_27840)){
var statearr_27965_28023 = state_27910__$1;
(statearr_27965_28023[(1)] = (28));

} else {
var statearr_27966_28024 = state_27910__$1;
(statearr_27966_28024[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (16))){
var inst_27807 = (state_27910[(8)]);
var inst_27812 = cljs.core.empty_QMARK_(inst_27807);
var state_27910__$1 = state_27910;
if(inst_27812){
var statearr_27967_28025 = state_27910__$1;
(statearr_27967_28025[(1)] = (19));

} else {
var statearr_27968_28026 = state_27910__$1;
(statearr_27968_28026[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (38))){
var state_27910__$1 = state_27910;
var statearr_27969_28027 = state_27910__$1;
(statearr_27969_28027[(2)] = true);

(statearr_27969_28027[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (30))){
var inst_27889 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
var statearr_27970_28028 = state_27910__$1;
(statearr_27970_28028[(2)] = inst_27889);

(statearr_27970_28028[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (10))){
var state_27910__$1 = state_27910;
var statearr_27971_28029 = state_27910__$1;
(statearr_27971_28029[(2)] = false);

(statearr_27971_28029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (18))){
var inst_27800 = (state_27910[(7)]);
var inst_27775 = (state_27910[(20)]);
var inst_27807 = (state_27910[(8)]);
var inst_27798 = (state_27910[(18)]);
var inst_27799 = (state_27910[(9)]);
var inst_27827 = (state_27910[(2)]);
var inst_27828 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27807);
var inst_27829 = fluree.db.storage.core.reify_db(inst_27798,inst_27799,inst_27800,inst_27775,inst_27828);
var state_27910__$1 = (function (){var statearr_27972 = state_27910;
(statearr_27972[(21)] = inst_27827);

return statearr_27972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27910__$1,(22),inst_27829);
} else {
if((state_val_27911 === (42))){
var inst_27846 = (state_27910[(11)]);
var state_27910__$1 = state_27910;
var statearr_27973_28030 = state_27910__$1;
(statearr_27973_28030[(2)] = inst_27846);

(statearr_27973_28030[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (37))){
var inst_27864 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
if(cljs.core.truth_(inst_27864)){
var statearr_27974_28031 = state_27910__$1;
(statearr_27974_28031[(1)] = (41));

} else {
var statearr_27975_28032 = state_27910__$1;
(statearr_27975_28032[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27911 === (8))){
var inst_27792 = (state_27910[(2)]);
var state_27910__$1 = state_27910;
if(cljs.core.truth_(inst_27792)){
var statearr_27976_28033 = state_27910__$1;
(statearr_27976_28033[(1)] = (12));

} else {
var statearr_27977_28034 = state_27910__$1;
(statearr_27977_28034[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0 = (function (){
var statearr_27978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27978[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__);

(statearr_27978[(1)] = (1));

return statearr_27978;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1 = (function (state_27910){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_27910);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e27979){var ex__2417__auto__ = e27979;
var statearr_27980_28035 = state_27910;
(statearr_27980_28035[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_27910[(4)]))){
var statearr_27981_28036 = state_27910;
(statearr_27981_28036[(1)] = cljs.core.first((state_27910[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28037 = state_27910;
state_27910 = G__28037;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__ = function(state_27910){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1.call(this,state_27910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2414__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_27982 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_27982[(6)] = c__2436__auto___27983);

return statearr_27982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__28038 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28038,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__28038;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__28039 = cljs.core.get_global_hierarchy;
return (fexpr__28039.cljs$core$IFn$_invoke$arity$0 ? fexpr__28039.cljs$core$IFn$_invoke$arity$0() : fexpr__28039.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28041){
var state_val_28042 = (state_28041[(1)]);
if((state_val_28042 === (1))){
var state_28041__$1 = state_28041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28041__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_28043 = [null,null,null,null,null,null,null];
(statearr_28043[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_28043[(1)] = (1));

return statearr_28043;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_28041){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28041);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28044){var ex__2417__auto__ = e28044;
var statearr_28045_28048 = state_28041;
(statearr_28045_28048[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28041[(4)]))){
var statearr_28046_28049 = state_28041;
(statearr_28046_28049[(1)] = cljs.core.first((state_28041[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28050 = state_28041;
state_28041 = G__28050;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_28041){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_28041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28047 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28047[(6)] = c__2436__auto__);

return statearr_28047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28052){
var map__28053 = p__28052;
var map__28053__$1 = (((((!((map__28053 == null))))?(((((map__28053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28053.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28053):map__28053);
var data = map__28053__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28053__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28053__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28053__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28113){
var state_val_28114 = (state_28113[(1)]);
if((state_val_28114 === (7))){
var inst_28068 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28069 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28070 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28068),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28069),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_28071 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28070], 0));
var state_28113__$1 = state_28113;
var statearr_28115_28153 = state_28113__$1;
(statearr_28115_28153[(2)] = inst_28071);

(statearr_28115_28153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (1))){
var state_28113__$1 = state_28113;
var statearr_28116_28154 = state_28113__$1;
(statearr_28116_28154[(2)] = null);

(statearr_28116_28154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (4))){
var inst_28055 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
var statearr_28117_28155 = state_28113__$1;
(statearr_28117_28155[(2)] = inst_28055);

(statearr_28117_28155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (15))){
var inst_28094 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
var statearr_28118_28156 = state_28113__$1;
(statearr_28118_28156[(2)] = inst_28094);

(statearr_28118_28156[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (13))){
var inst_28085 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28087 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28088 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28089 = [inst_28087,inst_28088];
var inst_28090 = (new cljs.core.PersistentVector(null,2,(5),inst_28086,inst_28089,null));
var inst_28091 = (function (){var G__28119 = inst_28085;
var G__28120 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28121 = inst_28090;
var G__28122 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28119,G__28120,G__28121,G__28122) : fluree.db.conn_events.process_event.call(null,G__28119,G__28120,G__28121,G__28122));
})();
var state_28113__$1 = state_28113;
var statearr_28123_28157 = state_28113__$1;
(statearr_28123_28157[(2)] = inst_28091);

(statearr_28123_28157[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (6))){
var inst_28065 = (state_28113[(7)]);
var inst_28064 = (state_28113[(8)]);
var inst_28063 = (state_28113[(2)]);
var inst_28064__$1 = fluree.db.util.async.throw_err(inst_28063);
var inst_28065__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28064__$1);
var inst_28066 = (block <= inst_28065__$1);
var state_28113__$1 = (function (){var statearr_28124 = state_28113;
(statearr_28124[(7)] = inst_28065__$1);

(statearr_28124[(8)] = inst_28064__$1);

return statearr_28124;
})();
if(cljs.core.truth_(inst_28066)){
var statearr_28125_28158 = state_28113__$1;
(statearr_28125_28158[(1)] = (7));

} else {
var statearr_28126_28159 = state_28113__$1;
(statearr_28126_28159[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (17))){
var state_28113__$1 = state_28113;
var statearr_28127_28160 = state_28113__$1;
(statearr_28127_28160[(2)] = null);

(statearr_28127_28160[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (3))){
var inst_28111 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28113__$1,inst_28111);
} else {
if((state_val_28114 === (12))){
var inst_28106 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
var statearr_28128_28161 = state_28113__$1;
(statearr_28128_28161[(2)] = inst_28106);

(statearr_28128_28161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (2))){
var inst_28061 = (state_28113[(9)]);
var _ = (function (){var statearr_28129 = state_28113;
(statearr_28129[(4)] = cljs.core.cons((5),(state_28113[(4)])));

return statearr_28129;
})();
var inst_28061__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28113__$1 = (function (){var statearr_28130 = state_28113;
(statearr_28130[(9)] = inst_28061__$1);

return statearr_28130;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28113__$1,(6),inst_28061__$1);
} else {
if((state_val_28114 === (11))){
var state_28113__$1 = state_28113;
var statearr_28132_28162 = state_28113__$1;
(statearr_28132_28162[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (9))){
var inst_28108 = (state_28113[(2)]);
var _ = (function (){var statearr_28134 = state_28113;
(statearr_28134[(4)] = cljs.core.rest((state_28113[(4)])));

return statearr_28134;
})();
var state_28113__$1 = state_28113;
var statearr_28135_28163 = state_28113__$1;
(statearr_28135_28163[(2)] = inst_28108);

(statearr_28135_28163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (5))){
var _ = (function (){var statearr_28136 = state_28113;
(statearr_28136[(4)] = cljs.core.rest((state_28113[(4)])));

return statearr_28136;
})();
var state_28113__$1 = state_28113;
var ex28131 = (state_28113__$1[(2)]);
var statearr_28137_28164 = state_28113__$1;
(statearr_28137_28164[(5)] = ex28131);


if((ex28131 instanceof Error)){
var statearr_28138_28165 = state_28113__$1;
(statearr_28138_28165[(1)] = (4));

(statearr_28138_28165[(5)] = null);

} else {
throw ex28131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (14))){
var state_28113__$1 = state_28113;
var statearr_28139_28166 = state_28113__$1;
(statearr_28139_28166[(2)] = null);

(statearr_28139_28166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (16))){
var inst_28065 = (state_28113[(7)]);
var inst_28097 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28098 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28099 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28097),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28098),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28065),". Forcing a db reload."].join('');
var inst_28100 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28099], 0));
var inst_28101 = fluree.db.session.reload_db_BANG_(session);
var state_28113__$1 = (function (){var statearr_28140 = state_28113;
(statearr_28140[(10)] = inst_28100);

return statearr_28140;
})();
var statearr_28141_28167 = state_28113__$1;
(statearr_28141_28167[(2)] = inst_28101);

(statearr_28141_28167[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (10))){
var inst_28065 = (state_28113[(7)]);
var inst_28061 = (state_28113[(9)]);
var inst_28064 = (state_28113[(8)]);
var inst_28076 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28077 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28078 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28077),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28079 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28078], 0));
var inst_28080 = (function (){var current_db_ch = inst_28061;
var current_db = inst_28064;
var current_block = inst_28065;
return (function (p1__28051_SHARP_){
if((p1__28051_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28051_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__28051_SHARP_);
}
});
})();
var inst_28081 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_28080,flakes);
var inst_28082 = fluree.db.dbproto._with(inst_28064,block,inst_28081);
var inst_28083 = fluree.db.session.cas_db_BANG_(session,inst_28061,inst_28082);
var state_28113__$1 = (function (){var statearr_28142 = state_28113;
(statearr_28142[(11)] = inst_28079);

return statearr_28142;
})();
if(inst_28083){
var statearr_28143_28168 = state_28113__$1;
(statearr_28143_28168[(1)] = (13));

} else {
var statearr_28144_28169 = state_28113__$1;
(statearr_28144_28169[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (18))){
var inst_28104 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
var statearr_28145_28170 = state_28113__$1;
(statearr_28145_28170[(2)] = inst_28104);

(statearr_28145_28170[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (8))){
var inst_28065 = (state_28113[(7)]);
var inst_28073 = ((1) + inst_28065);
var inst_28074 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_28073);
var state_28113__$1 = state_28113;
if(inst_28074){
var statearr_28146_28171 = state_28113__$1;
(statearr_28146_28171[(1)] = (10));

} else {
var statearr_28147_28172 = state_28113__$1;
(statearr_28147_28172[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_28148 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28148[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_28148[(1)] = (1));

return statearr_28148;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_28113){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28113);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28149){var ex__2417__auto__ = e28149;
var statearr_28150_28173 = state_28113;
(statearr_28150_28173[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28113[(4)]))){
var statearr_28151_28174 = state_28113;
(statearr_28151_28174[(1)] = cljs.core.first((state_28113[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28175 = state_28113;
state_28113 = G__28175;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_28113){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_28113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28152 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28152[(6)] = c__2436__auto__);

return statearr_28152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28182){
var state_val_28183 = (state_28182[(1)]);
if((state_val_28183 === (1))){
var inst_28176 = fluree.db.session.clear_db_BANG_(session);
var inst_28177 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28178 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28179 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28177),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28178)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28180 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28179], 0));
var state_28182__$1 = (function (){var statearr_28184 = state_28182;
(statearr_28184[(7)] = inst_28176);

(statearr_28184[(8)] = inst_28180);

return statearr_28184;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28182__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_28185 = [null,null,null,null,null,null,null,null,null];
(statearr_28185[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_28185[(1)] = (1));

return statearr_28185;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_28182){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28182);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28186){var ex__2417__auto__ = e28186;
var statearr_28187_28190 = state_28182;
(statearr_28187_28190[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28182[(4)]))){
var statearr_28188_28191 = state_28182;
(statearr_28188_28191[(1)] = cljs.core.first((state_28182[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28192 = state_28182;
state_28182 = G__28192;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_28182){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_28182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28189 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28189[(6)] = c__2436__auto__);

return statearr_28189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28194 = arguments.length;
switch (G__28194) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__28195 = session;
var map__28195__$1 = (((((!((map__28195 == null))))?(((((map__28195.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28195.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28195):map__28195);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28195__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28197_28200 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28197_28200.cljs$core$IFn$_invoke$arity$3 ? fexpr__28197_28200.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28197_28200.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28198_28201 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28198_28201.cljs$core$IFn$_invoke$arity$0 ? fexpr__28198_28201.cljs$core$IFn$_invoke$arity$0() : fexpr__28198_28201.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28254){
var state_val_28255 = (state_28254[(1)]);
if((state_val_28255 === (7))){
var inst_28250 = (state_28254[(2)]);
var state_28254__$1 = state_28254;
var statearr_28256_28287 = state_28254__$1;
(statearr_28256_28287[(2)] = inst_28250);

(statearr_28256_28287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (1))){
var state_28254__$1 = state_28254;
var statearr_28257_28288 = state_28254__$1;
(statearr_28257_28288[(2)] = null);

(statearr_28257_28288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (4))){
var inst_28205 = (state_28254[(7)]);
var inst_28204 = (state_28254[(2)]);
var inst_28205__$1 = fluree.db.util.async.throw_err(inst_28204);
var inst_28206 = fluree.db.session.from_cache(network,ledger_id);
var inst_28207 = (inst_28205__$1 == null);
var state_28254__$1 = (function (){var statearr_28258 = state_28254;
(statearr_28258[(8)] = inst_28206);

(statearr_28258[(7)] = inst_28205__$1);

return statearr_28258;
})();
if(cljs.core.truth_(inst_28207)){
var statearr_28259_28289 = state_28254__$1;
(statearr_28259_28289[(1)] = (5));

} else {
var statearr_28260_28290 = state_28254__$1;
(statearr_28260_28290[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (15))){
var inst_28242 = (state_28254[(2)]);
var state_28254__$1 = (function (){var statearr_28261 = state_28254;
(statearr_28261[(9)] = inst_28242);

return statearr_28261;
})();
var statearr_28262_28291 = state_28254__$1;
(statearr_28262_28291[(2)] = null);

(statearr_28262_28291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (13))){
var inst_28246 = (state_28254[(2)]);
var state_28254__$1 = state_28254;
var statearr_28264_28292 = state_28254__$1;
(statearr_28264_28292[(2)] = inst_28246);

(statearr_28264_28292[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (6))){
var inst_28206 = (state_28254[(8)]);
var inst_28212 = (inst_28206 == null);
var state_28254__$1 = state_28254;
if(cljs.core.truth_(inst_28212)){
var statearr_28265_28293 = state_28254__$1;
(statearr_28265_28293[(1)] = (8));

} else {
var statearr_28266_28294 = state_28254__$1;
(statearr_28266_28294[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (17))){
var _ = (function (){var statearr_28267 = state_28254;
(statearr_28267[(4)] = cljs.core.rest((state_28254[(4)])));

return statearr_28267;
})();
var state_28254__$1 = state_28254;
var ex28263 = (state_28254__$1[(2)]);
var statearr_28268_28295 = state_28254__$1;
(statearr_28268_28295[(5)] = ex28263);


var statearr_28269_28296 = state_28254__$1;
(statearr_28269_28296[(1)] = (16));

(statearr_28269_28296[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (3))){
var inst_28252 = (state_28254[(2)]);
var state_28254__$1 = state_28254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28254__$1,inst_28252);
} else {
if((state_val_28255 === (12))){
var state_28254__$1 = state_28254;
var statearr_28270_28297 = state_28254__$1;
(statearr_28270_28297[(2)] = null);

(statearr_28270_28297[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (2))){
var state_28254__$1 = state_28254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28254__$1,(4),update_chan);
} else {
if((state_val_28255 === (11))){
var state_28254__$1 = state_28254;
var statearr_28271_28298 = state_28254__$1;
(statearr_28271_28298[(2)] = null);

(statearr_28271_28298[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (9))){
var state_28254__$1 = state_28254;
var statearr_28272_28299 = state_28254__$1;
(statearr_28272_28299[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (5))){
var inst_28209 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28210 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28209], 0));
var state_28254__$1 = state_28254;
var statearr_28274_28300 = state_28254__$1;
(statearr_28274_28300[(2)] = inst_28210);

(statearr_28274_28300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (14))){
var inst_28206 = (state_28254[(8)]);
var inst_28205 = (state_28254[(7)]);
var _ = (function (){var statearr_28275 = state_28254;
(statearr_28275[(4)] = cljs.core.cons((17),(state_28254[(4)])));

return statearr_28275;
})();
var inst_28230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28205,(0),null);
var inst_28231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28205,(1),null);
var inst_28232 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28233 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28205], 0));
var inst_28234 = fluree.db.util.core.trunc(inst_28233,(200));
var inst_28235 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28232,inst_28234], 0));
var inst_28236 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28206,inst_28230,inst_28231) : fluree.db.session.process_ledger_update.call(null,inst_28206,inst_28230,inst_28231));
var state_28254__$1 = (function (){var statearr_28276 = state_28254;
(statearr_28276[(10)] = inst_28235);

return statearr_28276;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28254__$1,(18),inst_28236);
} else {
if((state_val_28255 === (16))){
var inst_28205 = (state_28254[(7)]);
var inst_28220 = (state_28254[(2)]);
var inst_28221 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28220,"Exception processing ledger updates for message: ",inst_28205], 0));
var state_28254__$1 = state_28254;
var statearr_28277_28301 = state_28254__$1;
(statearr_28277_28301[(2)] = inst_28221);

(statearr_28277_28301[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (10))){
var inst_28248 = (state_28254[(2)]);
var state_28254__$1 = state_28254;
var statearr_28278_28302 = state_28254__$1;
(statearr_28278_28302[(2)] = inst_28248);

(statearr_28278_28302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (18))){
var inst_28238 = (state_28254[(2)]);
var inst_28239 = fluree.db.util.async.throw_err(inst_28238);
var _ = (function (){var statearr_28279 = state_28254;
(statearr_28279[(4)] = cljs.core.rest((state_28254[(4)])));

return statearr_28279;
})();
var state_28254__$1 = state_28254;
var statearr_28280_28303 = state_28254__$1;
(statearr_28280_28303[(2)] = inst_28239);

(statearr_28280_28303[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28255 === (8))){
var inst_28205 = (state_28254[(7)]);
var inst_28214 = cljs.core.first(inst_28205);
var inst_28215 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28214], 0));
var inst_28216 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28215].join('');
var inst_28217 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28216], 0));
var state_28254__$1 = state_28254;
var statearr_28281_28304 = state_28254__$1;
(statearr_28281_28304[(2)] = inst_28217);

(statearr_28281_28304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0 = (function (){
var statearr_28282 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28282[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__);

(statearr_28282[(1)] = (1));

return statearr_28282;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1 = (function (state_28254){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28254);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28283){var ex__2417__auto__ = e28283;
var statearr_28284_28305 = state_28254;
(statearr_28284_28305[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28254[(4)]))){
var statearr_28285_28306 = state_28254;
(statearr_28285_28306[(1)] = cljs.core.first((state_28254[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28307 = state_28254;
state_28254 = G__28307;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__ = function(state_28254){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1.call(this,state_28254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2414__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28286 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28286[(6)] = c__2436__auto__);

return statearr_28286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28308){
var map__28309 = p__28308;
var map__28309__$1 = (((((!((map__28309 == null))))?(((((map__28309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28309):map__28309);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28309__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28314 = block_result;
var map__28314__$1 = (((((!((map__28314 == null))))?(((((map__28314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28314.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28314):map__28314);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28314__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28314__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28314__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28314__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28314__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28315 = tx_result;
var map__28315__$1 = (((((!((map__28315 == null))))?(((((map__28315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28315.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28315):map__28315);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28315__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28315__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28311_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28311_SHARP_.t);
}):(function (p1__28312_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28312_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28313_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28313_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28313_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28318 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28318,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28318,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28318,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28318,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28322 = arguments.length;
switch (G__28322) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28323){
var map__28324 = p__28323;
var map__28324__$1 = (((((!((map__28324 == null))))?(((((map__28324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28324.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28324):map__28324);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28324__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28324__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28324__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28324__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28326 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28326,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28326,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28326,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28330_28450 = network;
var G__28331_28451 = ledger_id;
var G__28332_28452 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28333_28453 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28334 = cljs.core.seq(tids);
var chunk__28335 = null;
var count__28336 = (0);
var i__28337 = (0);
while(true){
if((i__28337 < count__28336)){
var tid = chunk__28335.cljs$core$IIndexed$_nth$arity$2(null,i__28337);
var temp__5735__auto___28455__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___28455__$1)){
var keyed_callbacks_28456 = temp__5735__auto___28455__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28457 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28378_28458 = cljs.core.seq(keyed_callbacks_28456);
var chunk__28379_28459 = null;
var count__28380_28460 = (0);
var i__28381_28461 = (0);
while(true){
if((i__28381_28461 < count__28380_28460)){
var vec__28390_28462 = chunk__28379_28459.cljs$core$IIndexed$_nth$arity$2(null,i__28381_28461);
var k_28463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28390_28462,(0),null);
var f_28464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28390_28462,(1),null);
try{(f_28464.cljs$core$IFn$_invoke$arity$1 ? f_28464.cljs$core$IFn$_invoke$arity$1(tx_response_28457) : f_28464.call(null,tx_response_28457));
}catch (e28393){var e_28465 = e28393;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28465,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28466 = seq__28378_28458;
var G__28467 = chunk__28379_28459;
var G__28468 = count__28380_28460;
var G__28469 = (i__28381_28461 + (1));
seq__28378_28458 = G__28466;
chunk__28379_28459 = G__28467;
count__28380_28460 = G__28468;
i__28381_28461 = G__28469;
continue;
} else {
var temp__5735__auto___28470__$2 = cljs.core.seq(seq__28378_28458);
if(temp__5735__auto___28470__$2){
var seq__28378_28471__$1 = temp__5735__auto___28470__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28378_28471__$1)){
var c__4556__auto___28472 = cljs.core.chunk_first(seq__28378_28471__$1);
var G__28473 = cljs.core.chunk_rest(seq__28378_28471__$1);
var G__28474 = c__4556__auto___28472;
var G__28475 = cljs.core.count(c__4556__auto___28472);
var G__28476 = (0);
seq__28378_28458 = G__28473;
chunk__28379_28459 = G__28474;
count__28380_28460 = G__28475;
i__28381_28461 = G__28476;
continue;
} else {
var vec__28394_28477 = cljs.core.first(seq__28378_28471__$1);
var k_28478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28394_28477,(0),null);
var f_28479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28394_28477,(1),null);
try{(f_28479.cljs$core$IFn$_invoke$arity$1 ? f_28479.cljs$core$IFn$_invoke$arity$1(tx_response_28457) : f_28479.call(null,tx_response_28457));
}catch (e28397){var e_28480 = e28397;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28480,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28481 = cljs.core.next(seq__28378_28471__$1);
var G__28482 = null;
var G__28483 = (0);
var G__28484 = (0);
seq__28378_28458 = G__28481;
chunk__28379_28459 = G__28482;
count__28380_28460 = G__28483;
i__28381_28461 = G__28484;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28485 = seq__28334;
var G__28486 = chunk__28335;
var G__28487 = count__28336;
var G__28488 = (i__28337 + (1));
seq__28334 = G__28485;
chunk__28335 = G__28486;
count__28336 = G__28487;
i__28337 = G__28488;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__28334);
if(temp__5735__auto____$1){
var seq__28334__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28334__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28334__$1);
var G__28489 = cljs.core.chunk_rest(seq__28334__$1);
var G__28490 = c__4556__auto__;
var G__28491 = cljs.core.count(c__4556__auto__);
var G__28492 = (0);
seq__28334 = G__28489;
chunk__28335 = G__28490;
count__28336 = G__28491;
i__28337 = G__28492;
continue;
} else {
var tid = cljs.core.first(seq__28334__$1);
var temp__5735__auto___28493__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___28493__$2)){
var keyed_callbacks_28494 = temp__5735__auto___28493__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28495 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28398_28496 = cljs.core.seq(keyed_callbacks_28494);
var chunk__28399_28497 = null;
var count__28400_28498 = (0);
var i__28401_28499 = (0);
while(true){
if((i__28401_28499 < count__28400_28498)){
var vec__28410_28500 = chunk__28399_28497.cljs$core$IIndexed$_nth$arity$2(null,i__28401_28499);
var k_28501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28410_28500,(0),null);
var f_28502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28410_28500,(1),null);
try{(f_28502.cljs$core$IFn$_invoke$arity$1 ? f_28502.cljs$core$IFn$_invoke$arity$1(tx_response_28495) : f_28502.call(null,tx_response_28495));
}catch (e28413){var e_28503 = e28413;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28503,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28504 = seq__28398_28496;
var G__28505 = chunk__28399_28497;
var G__28506 = count__28400_28498;
var G__28507 = (i__28401_28499 + (1));
seq__28398_28496 = G__28504;
chunk__28399_28497 = G__28505;
count__28400_28498 = G__28506;
i__28401_28499 = G__28507;
continue;
} else {
var temp__5735__auto___28508__$3 = cljs.core.seq(seq__28398_28496);
if(temp__5735__auto___28508__$3){
var seq__28398_28509__$1 = temp__5735__auto___28508__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28398_28509__$1)){
var c__4556__auto___28510 = cljs.core.chunk_first(seq__28398_28509__$1);
var G__28511 = cljs.core.chunk_rest(seq__28398_28509__$1);
var G__28512 = c__4556__auto___28510;
var G__28513 = cljs.core.count(c__4556__auto___28510);
var G__28514 = (0);
seq__28398_28496 = G__28511;
chunk__28399_28497 = G__28512;
count__28400_28498 = G__28513;
i__28401_28499 = G__28514;
continue;
} else {
var vec__28414_28515 = cljs.core.first(seq__28398_28509__$1);
var k_28516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28414_28515,(0),null);
var f_28517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28414_28515,(1),null);
try{(f_28517.cljs$core$IFn$_invoke$arity$1 ? f_28517.cljs$core$IFn$_invoke$arity$1(tx_response_28495) : f_28517.call(null,tx_response_28495));
}catch (e28417){var e_28518 = e28417;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28518,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28519 = cljs.core.next(seq__28398_28509__$1);
var G__28520 = null;
var G__28521 = (0);
var G__28522 = (0);
seq__28398_28496 = G__28519;
chunk__28399_28497 = G__28520;
count__28400_28498 = G__28521;
i__28401_28499 = G__28522;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28523 = cljs.core.next(seq__28334__$1);
var G__28524 = null;
var G__28525 = (0);
var G__28526 = (0);
seq__28334 = G__28523;
chunk__28335 = G__28524;
count__28336 = G__28525;
i__28337 = G__28526;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28329_28454 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28329_28454.cljs$core$IFn$_invoke$arity$4 ? fexpr__28329_28454.cljs$core$IFn$_invoke$arity$4(G__28330_28450,G__28331_28451,G__28332_28452,G__28333_28453) : fexpr__28329_28454.call(null,G__28330_28450,G__28331_28451,G__28332_28452,G__28333_28453));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28527 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2436__auto___28528 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28434){
var state_val_28435 = (state_28434[(1)]);
if((state_val_28435 === (1))){
var state_28434__$1 = state_28434;
var statearr_28436_28529 = state_28434__$1;
(statearr_28436_28529[(2)] = null);

(statearr_28436_28529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28435 === (2))){
var inst_28419 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28434__$1 = state_28434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28434__$1,(4),inst_28419);
} else {
if((state_val_28435 === (3))){
var inst_28432 = (state_28434[(2)]);
var state_28434__$1 = state_28434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28434__$1,inst_28432);
} else {
if((state_val_28435 === (4))){
var inst_28421 = (state_28434[(7)]);
var inst_28421__$1 = (state_28434[(2)]);
var inst_28422 = (inst_28421__$1 == null);
var state_28434__$1 = (function (){var statearr_28437 = state_28434;
(statearr_28437[(7)] = inst_28421__$1);

return statearr_28437;
})();
if(cljs.core.truth_(inst_28422)){
var statearr_28438_28530 = state_28434__$1;
(statearr_28438_28530[(1)] = (5));

} else {
var statearr_28439_28531 = state_28434__$1;
(statearr_28439_28531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28435 === (5))){
var inst_28424 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28425 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28424], 0));
var state_28434__$1 = state_28434;
var statearr_28440_28532 = state_28434__$1;
(statearr_28440_28532[(2)] = inst_28425);

(statearr_28440_28532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28435 === (6))){
var inst_28421 = (state_28434[(7)]);
var inst_28427 = (transact_handler_28527.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28527.cljs$core$IFn$_invoke$arity$2(conn,inst_28421) : transact_handler_28527.call(null,conn,inst_28421));
var state_28434__$1 = (function (){var statearr_28441 = state_28434;
(statearr_28441[(8)] = inst_28427);

return statearr_28441;
})();
var statearr_28442_28533 = state_28434__$1;
(statearr_28442_28533[(2)] = null);

(statearr_28442_28533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28435 === (7))){
var inst_28430 = (state_28434[(2)]);
var state_28434__$1 = state_28434;
var statearr_28443_28534 = state_28434__$1;
(statearr_28443_28534[(2)] = inst_28430);

(statearr_28443_28534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2414__auto__ = null;
var fluree$db$session$state_machine__2414__auto____0 = (function (){
var statearr_28444 = [null,null,null,null,null,null,null,null,null];
(statearr_28444[(0)] = fluree$db$session$state_machine__2414__auto__);

(statearr_28444[(1)] = (1));

return statearr_28444;
});
var fluree$db$session$state_machine__2414__auto____1 = (function (state_28434){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28434);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28445){var ex__2417__auto__ = e28445;
var statearr_28446_28535 = state_28434;
(statearr_28446_28535[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28434[(4)]))){
var statearr_28447_28536 = state_28434;
(statearr_28447_28536[(1)] = cljs.core.first((state_28434[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28537 = state_28434;
state_28434 = G__28537;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$session$state_machine__2414__auto__ = function(state_28434){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2414__auto____1.call(this,state_28434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2414__auto____0;
fluree$db$session$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2414__auto____1;
return fluree$db$session$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28448 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28448[(6)] = c__2436__auto___28528);

return statearr_28448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28538_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28538_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28538_SHARP_) + (1))], 0));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28539_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28539_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28542 = arguments.length;
switch (G__28542) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28543 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28540_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28540_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28543);
} else {
return G__28543;
}
})();
var seq__28544 = cljs.core.seq(sessions);
var chunk__28545 = null;
var count__28546 = (0);
var i__28547 = (0);
while(true){
if((i__28547 < count__28546)){
var session = chunk__28545.cljs$core$IIndexed$_nth$arity$2(null,i__28547);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28549 = seq__28544;
var G__28550 = chunk__28545;
var G__28551 = count__28546;
var G__28552 = (i__28547 + (1));
seq__28544 = G__28549;
chunk__28545 = G__28550;
count__28546 = G__28551;
i__28547 = G__28552;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__28544);
if(temp__5735__auto__){
var seq__28544__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28544__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__28544__$1);
var G__28553 = cljs.core.chunk_rest(seq__28544__$1);
var G__28554 = c__4556__auto__;
var G__28555 = cljs.core.count(c__4556__auto__);
var G__28556 = (0);
seq__28544 = G__28553;
chunk__28545 = G__28554;
count__28546 = G__28555;
i__28547 = G__28556;
continue;
} else {
var session = cljs.core.first(seq__28544__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28557 = cljs.core.next(seq__28544__$1);
var G__28558 = null;
var G__28559 = (0);
var G__28560 = (0);
seq__28544 = G__28557;
chunk__28545 = G__28558;
count__28546 = G__28559;
i__28547 = G__28560;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
