// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__19244 = cljs.core._EQ_;
var expr__19245 = e.getLastErrorCode();
if(cljs.core.truth_((pred__19244.cljs$core$IFn$_invoke$arity$2 ? pred__19244.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__19245) : pred__19244.call(null,goog.net.ErrorCode.NO_ERROR,expr__19245)))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_((pred__19244.cljs$core$IFn$_invoke$arity$2 ? pred__19244.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__19245) : pred__19244.call(null,goog.net.ErrorCode.EXCEPTION,expr__19245)))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_((pred__19244.cljs$core$IFn$_invoke$arity$2 ? pred__19244.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__19245) : pred__19244.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__19245)))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_((pred__19244.cljs$core$IFn$_invoke$arity$2 ? pred__19244.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__19245) : pred__19244.call(null,goog.net.ErrorCode.ABORT,expr__19245)))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_((pred__19244.cljs$core$IFn$_invoke$arity$2 ? pred__19244.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__19245) : pred__19244.call(null,goog.net.ErrorCode.TIMEOUT,expr__19245)))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19247 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19247,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19247;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19248 = opts;
var map__19248__$1 = (((((!((map__19248 == null))))?(((((map__19248.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19248.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19248):map__19248);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19248__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19248__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19248__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19250 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19250__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19250,headers], 0)):G__19250);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19250__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19250__$1;
}
})();
try{var G__19252_19258 = url;
var G__19253_19259 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__19254_19260 = "POST";
var G__19255_19261 = fluree.db.util.json.stringify(message);
var G__19256_19262 = cljs.core.clj__GT_js(headers__$1);
var G__19257_19263 = request_timeout;
goog.net.XhrIo.send(G__19252_19258,G__19253_19259,G__19254_19260,G__19255_19261,G__19256_19262,G__19257_19263);
}catch (e19251){var e_19264 = e19251;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_19264);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19265 = opts;
var map__19265__$1 = (((((!((map__19265 == null))))?(((((map__19265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19265):map__19265);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19265__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19265__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19265__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19265__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19265__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19267 = cljs.core.PersistentArrayMap.EMPTY;
var G__19267__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19267,headers], 0)):G__19267);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19267__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19267__$1;
}
})();
try{var G__19269_19276 = url;
var G__19270_19277 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19275 = output_format;
var G__19275__$1 = (((G__19275 instanceof cljs.core.Keyword))?G__19275.fqn:null);
switch (G__19275__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__19271_19278 = "GET";
var G__19272_19279 = body;
var G__19273_19280 = cljs.core.clj__GT_js(headers__$1);
var G__19274_19281 = request_timeout;
goog.net.XhrIo.send(G__19269_19276,G__19270_19277,G__19271_19278,G__19272_19279,G__19273_19280,G__19274_19281);
}catch (e19268){var e_19283 = e19268;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_19283);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19284 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19284,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19284;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19317){
var state_val_19318 = (state_19317[(1)]);
if((state_val_19318 === (7))){
var inst_19313 = (state_19317[(2)]);
var state_19317__$1 = state_19317;
var statearr_19319_19344 = state_19317__$1;
(statearr_19319_19344[(2)] = inst_19313);

(statearr_19319_19344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (1))){
var state_19317__$1 = state_19317;
var statearr_19320_19345 = state_19317__$1;
(statearr_19320_19345[(2)] = null);

(statearr_19320_19345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (4))){
var inst_19288 = (state_19317[(7)]);
var inst_19288__$1 = (state_19317[(2)]);
var inst_19289 = (inst_19288__$1 == null);
var state_19317__$1 = (function (){var statearr_19321 = state_19317;
(statearr_19321[(7)] = inst_19288__$1);

return statearr_19321;
})();
if(cljs.core.truth_(inst_19289)){
var statearr_19322_19346 = state_19317__$1;
(statearr_19322_19346[(1)] = (5));

} else {
var statearr_19323_19347 = state_19317__$1;
(statearr_19323_19347[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (6))){
var inst_19288 = (state_19317[(7)]);
var inst_19296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19288,(0),null);
var inst_19297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19288,(1),null);
var state_19317__$1 = (function (){var statearr_19324 = state_19317;
(statearr_19324[(8)] = inst_19296);

(statearr_19324[(9)] = inst_19297);

return statearr_19324;
})();
var statearr_19325_19348 = state_19317__$1;
(statearr_19325_19348[(2)] = null);

(statearr_19325_19348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (3))){
var inst_19315 = (state_19317[(2)]);
var state_19317__$1 = state_19317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19317__$1,inst_19315);
} else {
if((state_val_19318 === (2))){
var state_19317__$1 = state_19317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19317__$1,(4),pub_chan);
} else {
if((state_val_19318 === (11))){
var _ = (function (){var statearr_19327 = state_19317;
(statearr_19327[(4)] = cljs.core.rest((state_19317[(4)])));

return statearr_19327;
})();
var state_19317__$1 = state_19317;
var ex19326 = (state_19317__$1[(2)]);
var statearr_19328_19349 = state_19317__$1;
(statearr_19328_19349[(5)] = ex19326);


if((ex19326 instanceof Error)){
var statearr_19329_19350 = state_19317__$1;
(statearr_19329_19350[(1)] = (10));

(statearr_19329_19350[(5)] = null);

} else {
throw ex19326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (9))){
var inst_19310 = (state_19317[(2)]);
var state_19317__$1 = (function (){var statearr_19330 = state_19317;
(statearr_19330[(10)] = inst_19310);

return statearr_19330;
})();
var statearr_19331_19351 = state_19317__$1;
(statearr_19331_19351[(2)] = null);

(statearr_19331_19351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (5))){
var inst_19291 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_19317__$1 = state_19317;
var statearr_19332_19352 = state_19317__$1;
(statearr_19332_19352[(2)] = inst_19291);

(statearr_19332_19352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (10))){
var inst_19297 = (state_19317[(9)]);
var inst_19298 = (state_19317[(2)]);
var inst_19299 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_19298,"Websocket send message error:",inst_19298], 0));
var inst_19300 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19297,false);
var state_19317__$1 = (function (){var statearr_19333 = state_19317;
(statearr_19333[(11)] = inst_19299);

return statearr_19333;
})();
var statearr_19334_19353 = state_19317__$1;
(statearr_19334_19353[(2)] = inst_19300);

(statearr_19334_19353[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19318 === (8))){
var inst_19296 = (state_19317[(8)]);
var inst_19297 = (state_19317[(9)]);
var _ = (function (){var statearr_19335 = state_19317;
(statearr_19335[(4)] = cljs.core.cons((11),(state_19317[(4)])));

return statearr_19335;
})();
var inst_19306 = ws.send(inst_19296);
var inst_19307 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19297,true);
var ___$1 = (function (){var statearr_19336 = state_19317;
(statearr_19336[(4)] = cljs.core.rest((state_19317[(4)])));

return statearr_19336;
})();
var state_19317__$1 = (function (){var statearr_19337 = state_19317;
(statearr_19337[(12)] = inst_19306);

return statearr_19337;
})();
var statearr_19338_19354 = state_19317__$1;
(statearr_19338_19354[(2)] = inst_19307);

(statearr_19338_19354[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0 = (function (){
var statearr_19339 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19339[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__);

(statearr_19339[(1)] = (1));

return statearr_19339;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1 = (function (state_19317){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19317);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19340){var ex__2417__auto__ = e19340;
var statearr_19341_19355 = state_19317;
(statearr_19341_19355[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19317[(4)]))){
var statearr_19342_19356 = state_19317;
(statearr_19342_19356[(1)] = cljs.core.first((state_19317[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19357 = state_19317;
state_19317 = G__19357;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__ = function(state_19317){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1.call(this,state_19317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19343 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19343[(6)] = c__2436__auto__);

return statearr_19343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2436__auto___19396 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19383){
var state_val_19384 = (state_19383[(1)]);
if((state_val_19384 === (1))){
var inst_19362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19363 = [open_QMARK_,timeout_chan];
var inst_19364 = (new cljs.core.PersistentVector(null,2,(5),inst_19362,inst_19363,null));
var state_19383__$1 = state_19383;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19383__$1,(2),inst_19364,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19384 === (2))){
var inst_19366 = (state_19383[(2)]);
var inst_19367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19366,(0),null);
var inst_19368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19366,(1),null);
var inst_19369 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19368,timeout_chan);
var state_19383__$1 = (function (){var statearr_19385 = state_19383;
(statearr_19385[(7)] = inst_19367);

return statearr_19385;
})();
if(inst_19369){
var statearr_19386_19397 = state_19383__$1;
(statearr_19386_19397[(1)] = (3));

} else {
var statearr_19387_19398 = state_19383__$1;
(statearr_19387_19398[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19384 === (3))){
var inst_19371 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19372 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19373 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19374 = cljs.core.PersistentHashMap.fromArrays(inst_19372,inst_19373);
var inst_19375 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19371,inst_19374);
var inst_19376 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19375);
var inst_19377 = fluree.db.util.xhttp.close_websocket(ws);
var state_19383__$1 = (function (){var statearr_19388 = state_19383;
(statearr_19388[(8)] = inst_19376);

return statearr_19388;
})();
var statearr_19389_19399 = state_19383__$1;
(statearr_19389_19399[(2)] = inst_19377);

(statearr_19389_19399[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19384 === (4))){
var inst_19379 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19383__$1 = state_19383;
var statearr_19390_19400 = state_19383__$1;
(statearr_19390_19400[(2)] = inst_19379);

(statearr_19390_19400[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19384 === (5))){
var inst_19381 = (state_19383[(2)]);
var state_19383__$1 = state_19383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19383__$1,inst_19381);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_19391 = [null,null,null,null,null,null,null,null,null];
(statearr_19391[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__);

(statearr_19391[(1)] = (1));

return statearr_19391;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1 = (function (state_19383){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19383);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19392){var ex__2417__auto__ = e19392;
var statearr_19393_19401 = state_19383;
(statearr_19393_19401[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19383[(4)]))){
var statearr_19394_19402 = state_19383;
(statearr_19394_19402[(1)] = cljs.core.first((state_19383[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19403 = state_19383;
state_19383 = G__19403;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__ = function(state_19383){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1.call(this,state_19383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19395 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19395[(6)] = c__2436__auto___19396);

return statearr_19395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
