// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto.secp256k1');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('goog.string.format');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__66678 = opts_SINGLEQUOTE_;
var map__66678__$1 = (((((!((map__66678 == null))))?(((((map__66678.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66678.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66678):map__66678);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66678__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__66681 = arguments.length;
switch (G__66681) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__66684 = arguments.length;
switch (G__66684) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__66687 = arguments.length;
switch (G__66687) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__66690 = arguments.length;
switch (G__66690) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__66693 = arguments.length;
switch (G__66693) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__66696 = arguments.length;
switch (G__66696) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66705 = arguments.length;
var i__4737__auto___66706 = (0);
while(true){
if((i__4737__auto___66706 < len__4736__auto___66705)){
args__4742__auto__.push((arguments[i__4737__auto___66706]));

var G__66707 = (i__4737__auto___66706 + (1));
i__4737__auto___66706 = G__66707;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__66701){
var vec__66702 = p__66701;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66702,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq66698){
var G__66699 = cljs.core.first(seq66698);
var seq66698__$1 = cljs.core.next(seq66698);
var G__66700 = cljs.core.first(seq66698__$1);
var seq66698__$2 = cljs.core.next(seq66698__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66699,G__66700,seq66698__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66726){
var state_val_66727 = (state_66726[(1)]);
if((state_val_66727 === (1))){
var state_66726__$1 = state_66726;
var statearr_66728_66743 = state_66726__$1;
(statearr_66728_66743[(2)] = null);

(statearr_66728_66743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66727 === (2))){
var _ = (function (){var statearr_66729 = state_66726;
(statearr_66729[(4)] = cljs.core.cons((5),(state_66726[(4)])));

return statearr_66729;
})();
var state_66726__$1 = state_66726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66726__$1,(6),db);
} else {
if((state_val_66727 === (3))){
var inst_66724 = (state_66726[(2)]);
var state_66726__$1 = state_66726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66726__$1,inst_66724);
} else {
if((state_val_66727 === (4))){
var inst_66708 = (state_66726[(2)]);
var inst_66709 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66708], 0));
var inst_66710 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66708) : reject.call(null,inst_66708));
var state_66726__$1 = (function (){var statearr_66731 = state_66726;
(statearr_66731[(7)] = inst_66709);

return statearr_66731;
})();
var statearr_66732_66744 = state_66726__$1;
(statearr_66732_66744[(2)] = inst_66710);

(statearr_66732_66744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66727 === (5))){
var _ = (function (){var statearr_66733 = state_66726;
(statearr_66733[(4)] = cljs.core.rest((state_66726[(4)])));

return statearr_66733;
})();
var state_66726__$1 = state_66726;
var ex66730 = (state_66726__$1[(2)]);
var statearr_66734_66745 = state_66726__$1;
(statearr_66734_66745[(5)] = ex66730);


var statearr_66735_66746 = state_66726__$1;
(statearr_66735_66746[(1)] = (4));

(statearr_66735_66746[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66727 === (6))){
var inst_66717 = (state_66726[(2)]);
var inst_66718 = fluree.db.util.async.throw_err(inst_66717);
var inst_66719 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_66718);
var inst_66720 = cljs.core.clj__GT_js(inst_66719);
var inst_66721 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66720) : resolve.call(null,inst_66720));
var _ = (function (){var statearr_66736 = state_66726;
(statearr_66736[(4)] = cljs.core.rest((state_66726[(4)])));

return statearr_66736;
})();
var state_66726__$1 = state_66726;
var statearr_66737_66747 = state_66726__$1;
(statearr_66737_66747[(2)] = inst_66721);

(statearr_66737_66747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2414__auto__ = null;
var flureedb$db_schema_$_state_machine__2414__auto____0 = (function (){
var statearr_66738 = [null,null,null,null,null,null,null,null];
(statearr_66738[(0)] = flureedb$db_schema_$_state_machine__2414__auto__);

(statearr_66738[(1)] = (1));

return statearr_66738;
});
var flureedb$db_schema_$_state_machine__2414__auto____1 = (function (state_66726){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66726);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66739){var ex__2417__auto__ = e66739;
var statearr_66740_66748 = state_66726;
(statearr_66740_66748[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66726[(4)]))){
var statearr_66741_66749 = state_66726;
(statearr_66741_66749[(1)] = cljs.core.first((state_66726[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66750 = state_66726;
state_66726 = G__66750;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2414__auto__ = function(state_66726){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2414__auto____1.call(this,state_66726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2414__auto____0;
flureedb$db_schema_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2414__auto____1;
return flureedb$db_schema_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66742 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66742[(6)] = c__2436__auto__);

return statearr_66742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__66752 = arguments.length;
switch (G__66752) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66842){
var state_val_66843 = (state_66842[(1)]);
if((state_val_66843 === (7))){
var inst_66765 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66842__$1 = state_66842;
var statearr_66844_66902 = state_66842__$1;
(statearr_66844_66902[(2)] = inst_66765);

(statearr_66844_66902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (20))){
var inst_66791 = (state_66842[(7)]);
var inst_66798 = (state_66842[(2)]);
var state_66842__$1 = (function (){var statearr_66845 = state_66842;
(statearr_66845[(8)] = inst_66798);

return statearr_66845;
})();
if(cljs.core.truth_(inst_66791)){
var statearr_66846_66903 = state_66842__$1;
(statearr_66846_66903[(1)] = (21));

} else {
var statearr_66847_66904 = state_66842__$1;
(statearr_66847_66904[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (27))){
var inst_66793 = (state_66842[(9)]);
var inst_66812 = (state_66842[(10)]);
var inst_66814 = fluree.crypto.secp256k1.sign_message(inst_66812,inst_66793);
var state_66842__$1 = state_66842;
var statearr_66848_66905 = state_66842__$1;
(statearr_66848_66905[(2)] = inst_66814);

(statearr_66848_66905[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (1))){
var state_66842__$1 = state_66842;
var statearr_66849_66906 = state_66842__$1;
(statearr_66849_66906[(2)] = null);

(statearr_66849_66906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (24))){
var inst_66806 = (state_66842[(11)]);
var inst_66808 = fluree.db.util.core.without_nils(inst_66806);
var inst_66809 = fluree.db.util.json.stringify(inst_66808);
var state_66842__$1 = state_66842;
var statearr_66850_66907 = state_66842__$1;
(statearr_66850_66907[(2)] = inst_66809);

(statearr_66850_66907[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (4))){
var inst_66753 = (state_66842[(2)]);
var inst_66754 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66753], 0));
var inst_66755 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66753) : reject.call(null,inst_66753));
var state_66842__$1 = (function (){var statearr_66851 = state_66842;
(statearr_66851[(12)] = inst_66754);

return statearr_66851;
})();
var statearr_66852_66908 = state_66842__$1;
(statearr_66852_66908[(2)] = inst_66755);

(statearr_66852_66908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (15))){
var inst_66767 = (state_66842[(13)]);
var inst_66786 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_66767);
var state_66842__$1 = state_66842;
var statearr_66853_66909 = state_66842__$1;
(statearr_66853_66909[(2)] = inst_66786);

(statearr_66853_66909[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (21))){
var inst_66791 = (state_66842[(7)]);
var state_66842__$1 = state_66842;
var statearr_66854_66910 = state_66842__$1;
(statearr_66854_66910[(2)] = inst_66791);

(statearr_66854_66910[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (31))){
var inst_66806 = (state_66842[(11)]);
var inst_66827 = fluree.db.operations.unsigned_command_async(conn,inst_66806);
var state_66842__$1 = state_66842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66842__$1,(34),inst_66827);
} else {
if((state_val_66843 === (32))){
var inst_66832 = (state_66842[(2)]);
var inst_66833 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66834 = [(200),inst_66832];
var inst_66835 = cljs.core.PersistentHashMap.fromArrays(inst_66833,inst_66834);
var inst_66836 = cljs.core.clj__GT_js(inst_66835);
var inst_66837 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66836) : resolve.call(null,inst_66836));
var _ = (function (){var statearr_66855 = state_66842;
(statearr_66855[(4)] = cljs.core.rest((state_66842[(4)])));

return statearr_66855;
})();
var state_66842__$1 = state_66842;
var statearr_66856_66911 = state_66842__$1;
(statearr_66856_66911[(2)] = inst_66837);

(statearr_66856_66911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (33))){
var inst_66824 = (state_66842[(2)]);
var inst_66825 = fluree.db.util.async.throw_err(inst_66824);
var state_66842__$1 = state_66842;
var statearr_66857_66912 = state_66842__$1;
(statearr_66857_66912[(2)] = inst_66825);

(statearr_66857_66912[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (13))){
var state_66842__$1 = state_66842;
var statearr_66858_66913 = state_66842__$1;
(statearr_66858_66913[(2)] = false);

(statearr_66858_66913[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (22))){
var inst_66794 = (state_66842[(14)]);
var inst_66801 = (inst_66794 + (30000));
var state_66842__$1 = state_66842;
var statearr_66859_66914 = state_66842__$1;
(statearr_66859_66914[(2)] = inst_66801);

(statearr_66859_66914[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (29))){
var inst_66793 = (state_66842[(9)]);
var inst_66817 = (state_66842[(2)]);
var state_66842__$1 = (function (){var statearr_66860 = state_66842;
(statearr_66860[(15)] = inst_66817);

return statearr_66860;
})();
if(cljs.core.truth_(inst_66793)){
var statearr_66861_66915 = state_66842__$1;
(statearr_66861_66915[(1)] = (30));

} else {
var statearr_66862_66916 = state_66842__$1;
(statearr_66862_66916[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (6))){
var state_66842__$1 = state_66842;
var statearr_66863_66917 = state_66842__$1;
(statearr_66863_66917[(2)] = null);

(statearr_66863_66917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (28))){
var state_66842__$1 = state_66842;
var statearr_66864_66918 = state_66842__$1;
(statearr_66864_66918[(2)] = null);

(statearr_66864_66918[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (25))){
var state_66842__$1 = state_66842;
var statearr_66865_66919 = state_66842__$1;
(statearr_66865_66919[(2)] = null);

(statearr_66865_66919[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (34))){
var inst_66829 = (state_66842[(2)]);
var inst_66830 = fluree.db.util.async.throw_err(inst_66829);
var state_66842__$1 = state_66842;
var statearr_66866_66920 = state_66842__$1;
(statearr_66866_66920[(2)] = inst_66830);

(statearr_66866_66920[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (17))){
var inst_66790 = (state_66842[(16)]);
var inst_66789 = (state_66842[(2)]);
var inst_66790__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66789,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66789,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66792 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66789,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66789,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66794 = fluree.db.util.core.current_time_millis();
var state_66842__$1 = (function (){var statearr_66867 = state_66842;
(statearr_66867[(14)] = inst_66794);

(statearr_66867[(17)] = inst_66792);

(statearr_66867[(16)] = inst_66790__$1);

(statearr_66867[(9)] = inst_66793);

(statearr_66867[(7)] = inst_66791);

return statearr_66867;
})();
if(cljs.core.truth_(inst_66790__$1)){
var statearr_66868_66921 = state_66842__$1;
(statearr_66868_66921[(1)] = (18));

} else {
var statearr_66869_66922 = state_66842__$1;
(statearr_66869_66922[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (3))){
var inst_66840 = (state_66842[(2)]);
var state_66842__$1 = state_66842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66842__$1,inst_66840);
} else {
if((state_val_66843 === (12))){
var state_66842__$1 = state_66842;
var statearr_66870_66923 = state_66842__$1;
(statearr_66870_66923[(2)] = true);

(statearr_66870_66923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (2))){
var _ = (function (){var statearr_66871 = state_66842;
(statearr_66871[(4)] = cljs.core.cons((5),(state_66842[(4)])));

return statearr_66871;
})();
var inst_66762 = (opts == null);
var state_66842__$1 = state_66842;
if(cljs.core.truth_(inst_66762)){
var statearr_66872_66924 = state_66842__$1;
(statearr_66872_66924[(1)] = (6));

} else {
var statearr_66873_66925 = state_66842__$1;
(statearr_66873_66925[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (23))){
var inst_66793 = (state_66842[(9)]);
var inst_66798 = (state_66842[(8)]);
var inst_66803 = (state_66842[(2)]);
var inst_66804 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_66805 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_66798,inst_66803];
var inst_66806 = cljs.core.PersistentHashMap.fromArrays(inst_66804,inst_66805);
var state_66842__$1 = (function (){var statearr_66874 = state_66842;
(statearr_66874[(11)] = inst_66806);

return statearr_66874;
})();
if(cljs.core.truth_(inst_66793)){
var statearr_66875_66926 = state_66842__$1;
(statearr_66875_66926[(1)] = (24));

} else {
var statearr_66876_66927 = state_66842__$1;
(statearr_66876_66927[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (19))){
var inst_66794 = (state_66842[(14)]);
var state_66842__$1 = state_66842;
var statearr_66877_66928 = state_66842__$1;
(statearr_66877_66928[(2)] = inst_66794);

(statearr_66877_66928[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (11))){
var inst_66784 = (state_66842[(2)]);
var state_66842__$1 = state_66842;
if(cljs.core.truth_(inst_66784)){
var statearr_66879_66929 = state_66842__$1;
(statearr_66879_66929[(1)] = (15));

} else {
var statearr_66880_66930 = state_66842__$1;
(statearr_66880_66930[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (9))){
var inst_66767 = (state_66842[(13)]);
var inst_66773 = inst_66767.cljs$lang$protocol_mask$partition0$;
var inst_66774 = (inst_66773 & (64));
var inst_66775 = inst_66767.cljs$core$ISeq$;
var inst_66776 = (cljs.core.PROTOCOL_SENTINEL === inst_66775);
var inst_66777 = ((inst_66774) || (inst_66776));
var state_66842__$1 = state_66842;
if(cljs.core.truth_(inst_66777)){
var statearr_66881_66931 = state_66842__$1;
(statearr_66881_66931[(1)] = (12));

} else {
var statearr_66882_66932 = state_66842__$1;
(statearr_66882_66932[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (5))){
var _ = (function (){var statearr_66883 = state_66842;
(statearr_66883[(4)] = cljs.core.rest((state_66842[(4)])));

return statearr_66883;
})();
var state_66842__$1 = state_66842;
var ex66878 = (state_66842__$1[(2)]);
var statearr_66884_66933 = state_66842__$1;
(statearr_66884_66933[(5)] = ex66878);


var statearr_66885_66934 = state_66842__$1;
(statearr_66885_66934[(1)] = (4));

(statearr_66885_66934[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (14))){
var inst_66781 = (state_66842[(2)]);
var state_66842__$1 = state_66842;
var statearr_66886_66935 = state_66842__$1;
(statearr_66886_66935[(2)] = inst_66781);

(statearr_66886_66935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (26))){
var inst_66793 = (state_66842[(9)]);
var inst_66812 = (state_66842[(2)]);
var state_66842__$1 = (function (){var statearr_66887 = state_66842;
(statearr_66887[(10)] = inst_66812);

return statearr_66887;
})();
if(cljs.core.truth_(inst_66793)){
var statearr_66888_66936 = state_66842__$1;
(statearr_66888_66936[(1)] = (27));

} else {
var statearr_66889_66937 = state_66842__$1;
(statearr_66889_66937[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (16))){
var inst_66767 = (state_66842[(13)]);
var state_66842__$1 = state_66842;
var statearr_66890_66938 = state_66842__$1;
(statearr_66890_66938[(2)] = inst_66767);

(statearr_66890_66938[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (30))){
var inst_66812 = (state_66842[(10)]);
var inst_66817 = (state_66842[(15)]);
var inst_66819 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66820 = [inst_66812,inst_66817];
var inst_66821 = cljs.core.PersistentHashMap.fromArrays(inst_66819,inst_66820);
var inst_66822 = fluree.db.operations.command_async(conn,inst_66821);
var state_66842__$1 = state_66842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66842__$1,(33),inst_66822);
} else {
if((state_val_66843 === (10))){
var state_66842__$1 = state_66842;
var statearr_66891_66939 = state_66842__$1;
(statearr_66891_66939[(2)] = false);

(statearr_66891_66939[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (18))){
var inst_66790 = (state_66842[(16)]);
var state_66842__$1 = state_66842;
var statearr_66892_66940 = state_66842__$1;
(statearr_66892_66940[(2)] = inst_66790);

(statearr_66892_66940[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66843 === (8))){
var inst_66767 = (state_66842[(13)]);
var inst_66767__$1 = (state_66842[(2)]);
var inst_66768 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66767__$1);
var inst_66770 = (inst_66767__$1 == null);
var inst_66771 = cljs.core.not(inst_66770);
var state_66842__$1 = (function (){var statearr_66893 = state_66842;
(statearr_66893[(18)] = inst_66768);

(statearr_66893[(13)] = inst_66767__$1);

return statearr_66893;
})();
if(inst_66771){
var statearr_66894_66941 = state_66842__$1;
(statearr_66894_66941[(1)] = (9));

} else {
var statearr_66895_66942 = state_66842__$1;
(statearr_66895_66942[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_66896 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66896[(0)] = flureedb$state_machine__2414__auto__);

(statearr_66896[(1)] = (1));

return statearr_66896;
});
var flureedb$state_machine__2414__auto____1 = (function (state_66842){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66842);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66897){var ex__2417__auto__ = e66897;
var statearr_66898_66943 = state_66842;
(statearr_66898_66943[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66842[(4)]))){
var statearr_66899_66944 = state_66842;
(statearr_66899_66944[(1)] = cljs.core.first((state_66842[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66945 = state_66842;
state_66842 = G__66945;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_66842){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_66842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66900 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66900[(6)] = c__2436__auto__);

return statearr_66900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_66964){
var state_val_66965 = (state_66964[(1)]);
if((state_val_66965 === (1))){
var state_66964__$1 = state_66964;
var statearr_66966_66981 = state_66964__$1;
(statearr_66966_66981[(2)] = null);

(statearr_66966_66981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66965 === (2))){
var _ = (function (){var statearr_66967 = state_66964;
(statearr_66967[(4)] = cljs.core.cons((5),(state_66964[(4)])));

return statearr_66967;
})();
var inst_66954 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_66964__$1 = state_66964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66964__$1,(6),inst_66954);
} else {
if((state_val_66965 === (3))){
var inst_66962 = (state_66964[(2)]);
var state_66964__$1 = state_66964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66964__$1,inst_66962);
} else {
if((state_val_66965 === (4))){
var inst_66946 = (state_66964[(2)]);
var inst_66947 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66946], 0));
var inst_66948 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66946) : reject.call(null,inst_66946));
var state_66964__$1 = (function (){var statearr_66969 = state_66964;
(statearr_66969[(7)] = inst_66947);

return statearr_66969;
})();
var statearr_66970_66982 = state_66964__$1;
(statearr_66970_66982[(2)] = inst_66948);

(statearr_66970_66982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66965 === (5))){
var _ = (function (){var statearr_66971 = state_66964;
(statearr_66971[(4)] = cljs.core.rest((state_66964[(4)])));

return statearr_66971;
})();
var state_66964__$1 = state_66964;
var ex66968 = (state_66964__$1[(2)]);
var statearr_66972_66983 = state_66964__$1;
(statearr_66972_66983[(5)] = ex66968);


var statearr_66973_66984 = state_66964__$1;
(statearr_66973_66984[(1)] = (4));

(statearr_66973_66984[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66965 === (6))){
var inst_66956 = (state_66964[(2)]);
var inst_66957 = fluree.db.util.async.throw_err(inst_66956);
var inst_66958 = cljs.core.clj__GT_js(inst_66957);
var inst_66959 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66958) : resolve.call(null,inst_66958));
var _ = (function (){var statearr_66974 = state_66964;
(statearr_66974[(4)] = cljs.core.rest((state_66964[(4)])));

return statearr_66974;
})();
var state_66964__$1 = state_66964;
var statearr_66975_66985 = state_66964__$1;
(statearr_66975_66985[(2)] = inst_66959);

(statearr_66975_66985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2414__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2414__auto____0 = (function (){
var statearr_66976 = [null,null,null,null,null,null,null,null];
(statearr_66976[(0)] = flureedb$ledger_stats_$_state_machine__2414__auto__);

(statearr_66976[(1)] = (1));

return statearr_66976;
});
var flureedb$ledger_stats_$_state_machine__2414__auto____1 = (function (state_66964){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_66964);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e66977){var ex__2417__auto__ = e66977;
var statearr_66978_66986 = state_66964;
(statearr_66978_66986[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_66964[(4)]))){
var statearr_66979_66987 = state_66964;
(statearr_66979_66987[(1)] = cljs.core.first((state_66964[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66988 = state_66964;
state_66964 = G__66988;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2414__auto__ = function(state_66964){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2414__auto____1.call(this,state_66964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2414__auto____0;
flureedb$ledger_stats_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2414__auto____1;
return flureedb$ledger_stats_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_66980 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_66980[(6)] = c__2436__auto__);

return statearr_66980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__66990 = arguments.length;
switch (G__66990) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67134){
var state_val_67135 = (state_67134[(1)]);
if((state_val_67135 === (7))){
var inst_67013 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67134__$1 = state_67134;
var statearr_67136_67219 = state_67134__$1;
(statearr_67136_67219[(2)] = inst_67013);

(statearr_67136_67219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (20))){
var inst_67060 = (state_67134[(7)]);
var inst_67053 = (state_67134[(8)]);
var inst_67050 = (state_67134[(9)]);
var inst_67060__$1 = (state_67134[(2)]);
var inst_67061 = fluree.db.graphdb.validate_ledger_name(inst_67060__$1,"ledger");
var inst_67062 = fluree.db.graphdb.validate_ledger_name(inst_67053,"network");
var state_67134__$1 = (function (){var statearr_67137 = state_67134;
(statearr_67137[(7)] = inst_67060__$1);

(statearr_67137[(10)] = inst_67062);

(statearr_67137[(11)] = inst_67061);

return statearr_67137;
})();
if(cljs.core.truth_(inst_67050)){
var statearr_67138_67220 = state_67134__$1;
(statearr_67138_67220[(1)] = (21));

} else {
var statearr_67139_67221 = state_67134__$1;
(statearr_67139_67221[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (27))){
var inst_67069 = (state_67134[(12)]);
var inst_67068 = (state_67134[(13)]);
var inst_67076 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67068),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67069)].join('');
var state_67134__$1 = state_67134;
var statearr_67140_67222 = state_67134__$1;
(statearr_67140_67222[(2)] = inst_67076);

(statearr_67140_67222[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (1))){
var state_67134__$1 = state_67134;
var statearr_67141_67223 = state_67134__$1;
(statearr_67141_67223[(2)] = null);

(statearr_67141_67223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (24))){
var inst_67069 = (state_67134[(12)]);
var inst_67071 = fluree.db.graphdb.validate_ledger_name(inst_67069,"alias");
var state_67134__$1 = state_67134;
var statearr_67142_67224 = state_67134__$1;
(statearr_67142_67224[(2)] = inst_67071);

(statearr_67142_67224[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (39))){
var inst_67098 = (state_67134[(14)]);
var inst_67100 = fluree.db.util.core.without_nils(inst_67098);
var inst_67101 = fluree.db.util.json.stringify(inst_67100);
var state_67134__$1 = state_67134;
var statearr_67143_67225 = state_67134__$1;
(statearr_67143_67225[(2)] = inst_67101);

(statearr_67143_67225[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (46))){
var inst_67098 = (state_67134[(14)]);
var inst_67119 = fluree.db.operations.unsigned_command_async(conn,inst_67098);
var state_67134__$1 = state_67134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67134__$1,(49),inst_67119);
} else {
if((state_val_67135 === (4))){
var inst_66991 = (state_67134[(2)]);
var inst_66992 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66991], 0));
var inst_66993 = cljs.core.ex_data(inst_66991);
var inst_66994 = cljs.core.ex_message(inst_66991);
var inst_66995 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66993,new cljs.core.Keyword(null,"message","message",-406056002),inst_66994);
var inst_66996 = cljs.core.clj__GT_js(inst_66995);
var inst_66997 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66996) : reject.call(null,inst_66996));
var state_67134__$1 = (function (){var statearr_67144 = state_67134;
(statearr_67144[(15)] = inst_66992);

return statearr_67144;
})();
var statearr_67145_67226 = state_67134__$1;
(statearr_67145_67226[(2)] = inst_66997);

(statearr_67145_67226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (15))){
var inst_67015 = (state_67134[(16)]);
var inst_67034 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67015);
var state_67134__$1 = state_67134;
var statearr_67146_67227 = state_67134__$1;
(statearr_67146_67227[(2)] = inst_67034);

(statearr_67146_67227[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (48))){
var inst_67116 = (state_67134[(2)]);
var inst_67117 = fluree.db.util.async.throw_err(inst_67116);
var state_67134__$1 = state_67134;
var statearr_67147_67228 = state_67134__$1;
(statearr_67147_67228[(2)] = inst_67117);

(statearr_67147_67228[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (21))){
var inst_67064 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_67134__$1 = state_67134;
var statearr_67148_67229 = state_67134__$1;
(statearr_67148_67229[(2)] = inst_67064);

(statearr_67148_67229[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (31))){
var inst_67080 = (state_67134[(17)]);
var state_67134__$1 = state_67134;
var statearr_67149_67230 = state_67134__$1;
(statearr_67149_67230[(2)] = inst_67080);

(statearr_67149_67230[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (32))){
var inst_67046 = (state_67134[(18)]);
var inst_67084 = (state_67134[(2)]);
var state_67134__$1 = (function (){var statearr_67150 = state_67134;
(statearr_67150[(19)] = inst_67084);

return statearr_67150;
})();
if(cljs.core.truth_(inst_67046)){
var statearr_67151_67231 = state_67134__$1;
(statearr_67151_67231[(1)] = (33));

} else {
var statearr_67152_67232 = state_67134__$1;
(statearr_67152_67232[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (40))){
var state_67134__$1 = state_67134;
var statearr_67153_67233 = state_67134__$1;
(statearr_67153_67233[(2)] = null);

(statearr_67153_67233[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (33))){
var inst_67046 = (state_67134[(18)]);
var state_67134__$1 = state_67134;
var statearr_67154_67234 = state_67134__$1;
(statearr_67154_67234[(2)] = inst_67046);

(statearr_67154_67234[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (13))){
var state_67134__$1 = state_67134;
var statearr_67155_67235 = state_67134__$1;
(statearr_67155_67235[(2)] = false);

(statearr_67155_67235[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (22))){
var state_67134__$1 = state_67134;
var statearr_67156_67236 = state_67134__$1;
(statearr_67156_67236[(2)] = null);

(statearr_67156_67236[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (36))){
var inst_67048 = (state_67134[(20)]);
var inst_67093 = (state_67134[(21)]);
var inst_67095 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_67093,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_67048);
var state_67134__$1 = state_67134;
var statearr_67157_67237 = state_67134__$1;
(statearr_67157_67237[(2)] = inst_67095);

(statearr_67157_67237[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (41))){
var inst_67042 = (state_67134[(22)]);
var inst_67104 = (state_67134[(2)]);
var state_67134__$1 = (function (){var statearr_67158 = state_67134;
(statearr_67158[(23)] = inst_67104);

return statearr_67158;
})();
if(cljs.core.truth_(inst_67042)){
var statearr_67159_67238 = state_67134__$1;
(statearr_67159_67238[(1)] = (42));

} else {
var statearr_67160_67239 = state_67134__$1;
(statearr_67160_67239[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (43))){
var state_67134__$1 = state_67134;
var statearr_67161_67240 = state_67134__$1;
(statearr_67161_67240[(2)] = null);

(statearr_67161_67240[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (29))){
var inst_67040 = (state_67134[(24)]);
var inst_67079 = (state_67134[(2)]);
var inst_67080 = fluree.db.util.core.current_time_millis();
var state_67134__$1 = (function (){var statearr_67162 = state_67134;
(statearr_67162[(17)] = inst_67080);

(statearr_67162[(25)] = inst_67079);

return statearr_67162;
})();
if(cljs.core.truth_(inst_67040)){
var statearr_67163_67241 = state_67134__$1;
(statearr_67163_67241[(1)] = (30));

} else {
var statearr_67164_67242 = state_67134__$1;
(statearr_67164_67242[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (44))){
var inst_67042 = (state_67134[(22)]);
var inst_67109 = (state_67134[(2)]);
var state_67134__$1 = (function (){var statearr_67165 = state_67134;
(statearr_67165[(26)] = inst_67109);

return statearr_67165;
})();
if(cljs.core.truth_(inst_67042)){
var statearr_67166_67243 = state_67134__$1;
(statearr_67166_67243[(1)] = (45));

} else {
var statearr_67167_67244 = state_67134__$1;
(statearr_67167_67244[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (6))){
var state_67134__$1 = state_67134;
var statearr_67168_67245 = state_67134__$1;
(statearr_67168_67245[(2)] = null);

(statearr_67168_67245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (28))){
var state_67134__$1 = state_67134;
var statearr_67169_67246 = state_67134__$1;
(statearr_67169_67246[(2)] = null);

(statearr_67169_67246[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (25))){
var state_67134__$1 = state_67134;
var statearr_67170_67247 = state_67134__$1;
(statearr_67170_67247[(2)] = null);

(statearr_67170_67247[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (34))){
var inst_67080 = (state_67134[(17)]);
var inst_67087 = (inst_67080 + (30000));
var state_67134__$1 = state_67134;
var statearr_67171_67248 = state_67134__$1;
(statearr_67171_67248[(2)] = inst_67087);

(statearr_67171_67248[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (17))){
var inst_67054 = (state_67134[(27)]);
var inst_67037 = (state_67134[(2)]);
var inst_67038 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67037,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_67039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_67040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_67041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_67042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_67043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_67044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_67045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_67046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_67047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_67049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_67050 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_67051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67037,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_67052 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_67053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67052,(0),null);
var inst_67054__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67052,(1),null);
var inst_67055 = clojure.string.starts_with_QMARK_(inst_67054__$1,"$");
var state_67134__$1 = (function (){var statearr_67172 = state_67134;
(statearr_67172[(28)] = inst_67049);

(statearr_67172[(20)] = inst_67048);

(statearr_67172[(29)] = inst_67041);

(statearr_67172[(8)] = inst_67053);

(statearr_67172[(24)] = inst_67040);

(statearr_67172[(30)] = inst_67051);

(statearr_67172[(27)] = inst_67054__$1);

(statearr_67172[(31)] = inst_67045);

(statearr_67172[(32)] = inst_67044);

(statearr_67172[(33)] = inst_67038);

(statearr_67172[(22)] = inst_67042);

(statearr_67172[(34)] = inst_67047);

(statearr_67172[(35)] = inst_67039);

(statearr_67172[(36)] = inst_67043);

(statearr_67172[(18)] = inst_67046);

(statearr_67172[(9)] = inst_67050);

return statearr_67172;
})();
if(inst_67055){
var statearr_67173_67249 = state_67134__$1;
(statearr_67173_67249[(1)] = (18));

} else {
var statearr_67174_67250 = state_67134__$1;
(statearr_67174_67250[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (3))){
var inst_67132 = (state_67134[(2)]);
var state_67134__$1 = state_67134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67134__$1,inst_67132);
} else {
if((state_val_67135 === (12))){
var state_67134__$1 = state_67134;
var statearr_67175_67251 = state_67134__$1;
(statearr_67175_67251[(2)] = true);

(statearr_67175_67251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (2))){
var _ = (function (){var statearr_67176 = state_67134;
(statearr_67176[(4)] = cljs.core.cons((5),(state_67134[(4)])));

return statearr_67176;
})();
var inst_67010 = (opts == null);
var state_67134__$1 = state_67134;
if(cljs.core.truth_(inst_67010)){
var statearr_67177_67252 = state_67134__$1;
(statearr_67177_67252[(1)] = (6));

} else {
var statearr_67178_67253 = state_67134__$1;
(statearr_67178_67253[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (23))){
var inst_67050 = (state_67134[(9)]);
var inst_67067 = (state_67134[(2)]);
var inst_67068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67067,(0),null);
var inst_67069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67067,(1),null);
var state_67134__$1 = (function (){var statearr_67179 = state_67134;
(statearr_67179[(12)] = inst_67069);

(statearr_67179[(13)] = inst_67068);

return statearr_67179;
})();
if(cljs.core.truth_(inst_67050)){
var statearr_67180_67254 = state_67134__$1;
(statearr_67180_67254[(1)] = (24));

} else {
var statearr_67181_67255 = state_67134__$1;
(statearr_67181_67255[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (47))){
var inst_67124 = (state_67134[(2)]);
var inst_67125 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67126 = [(200),inst_67124];
var inst_67127 = cljs.core.PersistentHashMap.fromArrays(inst_67125,inst_67126);
var inst_67128 = cljs.core.clj__GT_js(inst_67127);
var inst_67129 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67128) : resolve.call(null,inst_67128));
var _ = (function (){var statearr_67182 = state_67134;
(statearr_67182[(4)] = cljs.core.rest((state_67134[(4)])));

return statearr_67182;
})();
var state_67134__$1 = state_67134;
var statearr_67183_67256 = state_67134__$1;
(statearr_67183_67256[(2)] = inst_67129);

(statearr_67183_67256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (35))){
var inst_67060 = (state_67134[(7)]);
var inst_67049 = (state_67134[(28)]);
var inst_67048 = (state_67134[(20)]);
var inst_67041 = (state_67134[(29)]);
var inst_67053 = (state_67134[(8)]);
var inst_67084 = (state_67134[(19)]);
var inst_67051 = (state_67134[(30)]);
var inst_67045 = (state_67134[(31)]);
var inst_67044 = (state_67134[(32)]);
var inst_67079 = (state_67134[(25)]);
var inst_67047 = (state_67134[(34)]);
var inst_67039 = (state_67134[(35)]);
var inst_67043 = (state_67134[(36)]);
var inst_67089 = (state_67134[(2)]);
var inst_67090 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_67091 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67053),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67060)].join('');
var inst_67092 = [inst_67044,inst_67045,inst_67091,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_67089,inst_67047,inst_67079,inst_67051,inst_67049,inst_67039,inst_67084,inst_67041,inst_67043];
var inst_67093 = cljs.core.PersistentHashMap.fromArrays(inst_67090,inst_67092);
var state_67134__$1 = (function (){var statearr_67184 = state_67134;
(statearr_67184[(21)] = inst_67093);

return statearr_67184;
})();
if(cljs.core.truth_(inst_67048)){
var statearr_67185_67257 = state_67134__$1;
(statearr_67185_67257[(1)] = (36));

} else {
var statearr_67186_67258 = state_67134__$1;
(statearr_67186_67258[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (19))){
var inst_67054 = (state_67134[(27)]);
var state_67134__$1 = state_67134;
var statearr_67187_67259 = state_67134__$1;
(statearr_67187_67259[(2)] = inst_67054);

(statearr_67187_67259[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (11))){
var inst_67032 = (state_67134[(2)]);
var state_67134__$1 = state_67134;
if(cljs.core.truth_(inst_67032)){
var statearr_67189_67260 = state_67134__$1;
(statearr_67189_67260[(1)] = (15));

} else {
var statearr_67190_67261 = state_67134__$1;
(statearr_67190_67261[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (9))){
var inst_67015 = (state_67134[(16)]);
var inst_67021 = inst_67015.cljs$lang$protocol_mask$partition0$;
var inst_67022 = (inst_67021 & (64));
var inst_67023 = inst_67015.cljs$core$ISeq$;
var inst_67024 = (cljs.core.PROTOCOL_SENTINEL === inst_67023);
var inst_67025 = ((inst_67022) || (inst_67024));
var state_67134__$1 = state_67134;
if(cljs.core.truth_(inst_67025)){
var statearr_67191_67262 = state_67134__$1;
(statearr_67191_67262[(1)] = (12));

} else {
var statearr_67192_67263 = state_67134__$1;
(statearr_67192_67263[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (5))){
var _ = (function (){var statearr_67193 = state_67134;
(statearr_67193[(4)] = cljs.core.rest((state_67134[(4)])));

return statearr_67193;
})();
var state_67134__$1 = state_67134;
var ex67188 = (state_67134__$1[(2)]);
var statearr_67194_67264 = state_67134__$1;
(statearr_67194_67264[(5)] = ex67188);


var statearr_67195_67265 = state_67134__$1;
(statearr_67195_67265[(1)] = (4));

(statearr_67195_67265[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (14))){
var inst_67029 = (state_67134[(2)]);
var state_67134__$1 = state_67134;
var statearr_67196_67266 = state_67134__$1;
(statearr_67196_67266[(2)] = inst_67029);

(statearr_67196_67266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (45))){
var inst_67109 = (state_67134[(26)]);
var inst_67104 = (state_67134[(23)]);
var inst_67111 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_67112 = [inst_67104,inst_67109];
var inst_67113 = cljs.core.PersistentHashMap.fromArrays(inst_67111,inst_67112);
var inst_67114 = fluree.db.operations.command_async(conn,inst_67113);
var state_67134__$1 = state_67134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67134__$1,(48),inst_67114);
} else {
if((state_val_67135 === (26))){
var inst_67050 = (state_67134[(9)]);
var inst_67074 = (state_67134[(2)]);
var state_67134__$1 = (function (){var statearr_67197 = state_67134;
(statearr_67197[(37)] = inst_67074);

return statearr_67197;
})();
if(cljs.core.truth_(inst_67050)){
var statearr_67198_67267 = state_67134__$1;
(statearr_67198_67267[(1)] = (27));

} else {
var statearr_67199_67268 = state_67134__$1;
(statearr_67199_67268[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (16))){
var inst_67015 = (state_67134[(16)]);
var state_67134__$1 = state_67134;
var statearr_67200_67269 = state_67134__$1;
(statearr_67200_67269[(2)] = inst_67015);

(statearr_67200_67269[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (38))){
var inst_67042 = (state_67134[(22)]);
var inst_67098 = (state_67134[(2)]);
var state_67134__$1 = (function (){var statearr_67201 = state_67134;
(statearr_67201[(14)] = inst_67098);

return statearr_67201;
})();
if(cljs.core.truth_(inst_67042)){
var statearr_67202_67270 = state_67134__$1;
(statearr_67202_67270[(1)] = (39));

} else {
var statearr_67203_67271 = state_67134__$1;
(statearr_67203_67271[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (30))){
var inst_67040 = (state_67134[(24)]);
var state_67134__$1 = state_67134;
var statearr_67204_67272 = state_67134__$1;
(statearr_67204_67272[(2)] = inst_67040);

(statearr_67204_67272[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (10))){
var state_67134__$1 = state_67134;
var statearr_67205_67273 = state_67134__$1;
(statearr_67205_67273[(2)] = false);

(statearr_67205_67273[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (18))){
var inst_67054 = (state_67134[(27)]);
var inst_67057 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_67054,(1));
var state_67134__$1 = state_67134;
var statearr_67206_67274 = state_67134__$1;
(statearr_67206_67274[(2)] = inst_67057);

(statearr_67206_67274[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (42))){
var inst_67104 = (state_67134[(23)]);
var inst_67042 = (state_67134[(22)]);
var inst_67106 = fluree.crypto.secp256k1.sign_message(inst_67104,inst_67042);
var state_67134__$1 = state_67134;
var statearr_67207_67275 = state_67134__$1;
(statearr_67207_67275[(2)] = inst_67106);

(statearr_67207_67275[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (37))){
var inst_67093 = (state_67134[(21)]);
var state_67134__$1 = state_67134;
var statearr_67208_67276 = state_67134__$1;
(statearr_67208_67276[(2)] = inst_67093);

(statearr_67208_67276[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (8))){
var inst_67015 = (state_67134[(16)]);
var inst_67015__$1 = (state_67134[(2)]);
var inst_67016 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67015__$1);
var inst_67018 = (inst_67015__$1 == null);
var inst_67019 = cljs.core.not(inst_67018);
var state_67134__$1 = (function (){var statearr_67209 = state_67134;
(statearr_67209[(38)] = inst_67016);

(statearr_67209[(16)] = inst_67015__$1);

return statearr_67209;
})();
if(inst_67019){
var statearr_67210_67277 = state_67134__$1;
(statearr_67210_67277[(1)] = (9));

} else {
var statearr_67211_67278 = state_67134__$1;
(statearr_67211_67278[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67135 === (49))){
var inst_67121 = (state_67134[(2)]);
var inst_67122 = fluree.db.util.async.throw_err(inst_67121);
var state_67134__$1 = state_67134;
var statearr_67212_67279 = state_67134__$1;
(statearr_67212_67279[(2)] = inst_67122);

(statearr_67212_67279[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67213 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67213[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67213[(1)] = (1));

return statearr_67213;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67134){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67134);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67214){var ex__2417__auto__ = e67214;
var statearr_67215_67280 = state_67134;
(statearr_67215_67280[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67134[(4)]))){
var statearr_67216_67281 = state_67134;
(statearr_67216_67281[(1)] = cljs.core.first((state_67134[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67282 = state_67134;
state_67134 = G__67282;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67134){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67217 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67217[(6)] = c__2436__auto__);

return statearr_67217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67302){
var state_val_67303 = (state_67302[(1)]);
if((state_val_67303 === (1))){
var state_67302__$1 = state_67302;
var statearr_67304_67320 = state_67302__$1;
(statearr_67304_67320[(2)] = null);

(statearr_67304_67320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67303 === (2))){
var _ = (function (){var statearr_67305 = state_67302;
(statearr_67305[(4)] = cljs.core.cons((5),(state_67302[(4)])));

return statearr_67305;
})();
var inst_67292 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_67293 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_67302__$1 = (function (){var statearr_67306 = state_67302;
(statearr_67306[(7)] = inst_67292);

return statearr_67306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67302__$1,(6),inst_67293);
} else {
if((state_val_67303 === (3))){
var inst_67300 = (state_67302[(2)]);
var state_67302__$1 = state_67302;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67302__$1,inst_67300);
} else {
if((state_val_67303 === (4))){
var inst_67283 = (state_67302[(2)]);
var inst_67284 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67283], 0));
var inst_67285 = cljs.core.clj__GT_js(inst_67283);
var inst_67286 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67285) : reject.call(null,inst_67285));
var state_67302__$1 = (function (){var statearr_67308 = state_67302;
(statearr_67308[(8)] = inst_67284);

return statearr_67308;
})();
var statearr_67309_67321 = state_67302__$1;
(statearr_67309_67321[(2)] = inst_67286);

(statearr_67309_67321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67303 === (5))){
var _ = (function (){var statearr_67310 = state_67302;
(statearr_67310[(4)] = cljs.core.rest((state_67302[(4)])));

return statearr_67310;
})();
var state_67302__$1 = state_67302;
var ex67307 = (state_67302__$1[(2)]);
var statearr_67311_67322 = state_67302__$1;
(statearr_67311_67322[(5)] = ex67307);


var statearr_67312_67323 = state_67302__$1;
(statearr_67312_67323[(1)] = (4));

(statearr_67312_67323[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67303 === (6))){
var inst_67295 = (state_67302[(2)]);
var inst_67296 = cljs.core.clj__GT_js(inst_67295);
var inst_67297 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67296) : resolve.call(null,inst_67296));
var _ = (function (){var statearr_67313 = state_67302;
(statearr_67313[(4)] = cljs.core.rest((state_67302[(4)])));

return statearr_67313;
})();
var state_67302__$1 = state_67302;
var statearr_67314_67324 = state_67302__$1;
(statearr_67314_67324[(2)] = inst_67297);

(statearr_67314_67324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2414__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2414__auto____0 = (function (){
var statearr_67315 = [null,null,null,null,null,null,null,null,null];
(statearr_67315[(0)] = flureedb$monitor_tx_$_state_machine__2414__auto__);

(statearr_67315[(1)] = (1));

return statearr_67315;
});
var flureedb$monitor_tx_$_state_machine__2414__auto____1 = (function (state_67302){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67302);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67316){var ex__2417__auto__ = e67316;
var statearr_67317_67325 = state_67302;
(statearr_67317_67325[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67302[(4)]))){
var statearr_67318_67326 = state_67302;
(statearr_67318_67326[(1)] = cljs.core.first((state_67302[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67327 = state_67302;
state_67302 = G__67327;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2414__auto__ = function(state_67302){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2414__auto____1.call(this,state_67302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2414__auto____0;
flureedb$monitor_tx_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2414__auto____1;
return flureedb$monitor_tx_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67319 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67319[(6)] = c__2436__auto__);

return statearr_67319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__67329 = arguments.length;
switch (G__67329) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67355){
var state_val_67356 = (state_67355[(1)]);
if((state_val_67356 === (7))){
var inst_67341 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67355__$1 = state_67355;
var statearr_67357_67378 = state_67355__$1;
(statearr_67357_67378[(2)] = inst_67341);

(statearr_67357_67378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (1))){
var state_67355__$1 = state_67355;
var statearr_67358_67379 = state_67355__$1;
(statearr_67358_67379[(2)] = null);

(statearr_67358_67379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (4))){
var inst_67330 = (state_67355[(2)]);
var inst_67331 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67330], 0));
var inst_67332 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67330) : reject.call(null,inst_67330));
var state_67355__$1 = (function (){var statearr_67359 = state_67355;
(statearr_67359[(7)] = inst_67331);

return statearr_67359;
})();
var statearr_67360_67380 = state_67355__$1;
(statearr_67360_67380[(2)] = inst_67332);

(statearr_67360_67380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (6))){
var state_67355__$1 = state_67355;
var statearr_67361_67381 = state_67355__$1;
(statearr_67361_67381[(2)] = null);

(statearr_67361_67381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (3))){
var inst_67353 = (state_67355[(2)]);
var state_67355__$1 = state_67355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67355__$1,inst_67353);
} else {
if((state_val_67356 === (2))){
var _ = (function (){var statearr_67363 = state_67355;
(statearr_67363[(4)] = cljs.core.cons((5),(state_67355[(4)])));

return statearr_67363;
})();
var inst_67338 = (opts == null);
var state_67355__$1 = state_67355;
if(cljs.core.truth_(inst_67338)){
var statearr_67364_67382 = state_67355__$1;
(statearr_67364_67382[(1)] = (6));

} else {
var statearr_67365_67383 = state_67355__$1;
(statearr_67365_67383[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (9))){
var inst_67348 = (state_67355[(2)]);
var inst_67349 = cljs.core.clj__GT_js(inst_67348);
var inst_67350 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67349) : resolve.call(null,inst_67349));
var _ = (function (){var statearr_67366 = state_67355;
(statearr_67366[(4)] = cljs.core.rest((state_67355[(4)])));

return statearr_67366;
})();
var state_67355__$1 = state_67355;
var statearr_67367_67384 = state_67355__$1;
(statearr_67367_67384[(2)] = inst_67350);

(statearr_67367_67384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (5))){
var _ = (function (){var statearr_67368 = state_67355;
(statearr_67368[(4)] = cljs.core.rest((state_67355[(4)])));

return statearr_67368;
})();
var state_67355__$1 = state_67355;
var ex67362 = (state_67355__$1[(2)]);
var statearr_67369_67385 = state_67355__$1;
(statearr_67369_67385[(5)] = ex67362);


var statearr_67370_67386 = state_67355__$1;
(statearr_67370_67386[(1)] = (4));

(statearr_67370_67386[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67356 === (8))){
var inst_67343 = (state_67355[(2)]);
var inst_67344 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67343);
var inst_67345 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67346 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67345,inst_67343);
var state_67355__$1 = (function (){var statearr_67371 = state_67355;
(statearr_67371[(8)] = inst_67344);

return statearr_67371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67355__$1,(9),inst_67346);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67372 = [null,null,null,null,null,null,null,null,null];
(statearr_67372[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67372[(1)] = (1));

return statearr_67372;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67355){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67355);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67373){var ex__2417__auto__ = e67373;
var statearr_67374_67387 = state_67355;
(statearr_67374_67387[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67355[(4)]))){
var statearr_67375_67388 = state_67355;
(statearr_67375_67388[(1)] = cljs.core.first((state_67355[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67389 = state_67355;
state_67355 = G__67389;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67355){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67376 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67376[(6)] = c__2436__auto__);

return statearr_67376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__67391 = arguments.length;
switch (G__67391) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67420){
var state_val_67421 = (state_67420[(1)]);
if((state_val_67421 === (7))){
var inst_67403 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67420__$1 = state_67420;
var statearr_67422_67443 = state_67420__$1;
(statearr_67422_67443[(2)] = inst_67403);

(statearr_67422_67443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (1))){
var state_67420__$1 = state_67420;
var statearr_67423_67444 = state_67420__$1;
(statearr_67423_67444[(2)] = null);

(statearr_67423_67444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (4))){
var inst_67392 = (state_67420[(2)]);
var inst_67393 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67392], 0));
var inst_67394 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67392) : reject.call(null,inst_67392));
var state_67420__$1 = (function (){var statearr_67424 = state_67420;
(statearr_67424[(7)] = inst_67393);

return statearr_67424;
})();
var statearr_67425_67445 = state_67420__$1;
(statearr_67425_67445[(2)] = inst_67394);

(statearr_67425_67445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (6))){
var state_67420__$1 = state_67420;
var statearr_67426_67446 = state_67420__$1;
(statearr_67426_67446[(2)] = null);

(statearr_67426_67446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (3))){
var inst_67418 = (state_67420[(2)]);
var state_67420__$1 = state_67420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67420__$1,inst_67418);
} else {
if((state_val_67421 === (2))){
var _ = (function (){var statearr_67428 = state_67420;
(statearr_67428[(4)] = cljs.core.cons((5),(state_67420[(4)])));

return statearr_67428;
})();
var inst_67400 = (opts == null);
var state_67420__$1 = state_67420;
if(cljs.core.truth_(inst_67400)){
var statearr_67429_67447 = state_67420__$1;
(statearr_67429_67447[(1)] = (6));

} else {
var statearr_67430_67448 = state_67420__$1;
(statearr_67430_67448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (9))){
var inst_67405 = (state_67420[(8)]);
var inst_67408 = (state_67420[(2)]);
var inst_67409 = fluree.db.util.async.throw_err(inst_67408);
var inst_67410 = fluree.db.query.block.block_range(inst_67409,start,end,inst_67405);
var state_67420__$1 = state_67420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67420__$1,(10),inst_67410);
} else {
if((state_val_67421 === (5))){
var _ = (function (){var statearr_67431 = state_67420;
(statearr_67431[(4)] = cljs.core.rest((state_67420[(4)])));

return statearr_67431;
})();
var state_67420__$1 = state_67420;
var ex67427 = (state_67420__$1[(2)]);
var statearr_67432_67449 = state_67420__$1;
(statearr_67432_67449[(5)] = ex67427);


var statearr_67433_67450 = state_67420__$1;
(statearr_67433_67450[(1)] = (4));

(statearr_67433_67450[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (10))){
var inst_67412 = (state_67420[(2)]);
var inst_67413 = fluree.db.util.async.throw_err(inst_67412);
var inst_67414 = cljs.core.clj__GT_js(inst_67413);
var inst_67415 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67414) : resolve.call(null,inst_67414));
var _ = (function (){var statearr_67434 = state_67420;
(statearr_67434[(4)] = cljs.core.rest((state_67420[(4)])));

return statearr_67434;
})();
var state_67420__$1 = state_67420;
var statearr_67435_67451 = state_67420__$1;
(statearr_67435_67451[(2)] = inst_67415);

(statearr_67435_67451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67421 === (8))){
var inst_67405 = (state_67420[(8)]);
var inst_67405__$1 = (state_67420[(2)]);
var inst_67406 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67405__$1], 0));
var state_67420__$1 = (function (){var statearr_67436 = state_67420;
(statearr_67436[(8)] = inst_67405__$1);

return statearr_67436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67420__$1,(9),inst_67406);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67437 = [null,null,null,null,null,null,null,null,null];
(statearr_67437[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67437[(1)] = (1));

return statearr_67437;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67420){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67420);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67438){var ex__2417__auto__ = e67438;
var statearr_67439_67452 = state_67420;
(statearr_67439_67452[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67420[(4)]))){
var statearr_67440_67453 = state_67420;
(statearr_67440_67453[(1)] = cljs.core.first((state_67420[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67454 = state_67420;
state_67420 = G__67454;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67420){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67441 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67441[(6)] = c__2436__auto__);

return statearr_67441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__67456 = arguments.length;
switch (G__67456) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67511){
var state_val_67512 = (state_67511[(1)]);
if((state_val_67512 === (7))){
var inst_67469 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67511__$1 = state_67511;
var statearr_67513_67547 = state_67511__$1;
(statearr_67513_67547[(2)] = inst_67469);

(statearr_67513_67547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (1))){
var state_67511__$1 = state_67511;
var statearr_67514_67548 = state_67511__$1;
(statearr_67514_67548[(2)] = null);

(statearr_67514_67548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (4))){
var inst_67457 = (state_67511[(2)]);
var inst_67458 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67457], 0));
var inst_67459 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67457) : reject.call(null,inst_67457));
var state_67511__$1 = (function (){var statearr_67515 = state_67511;
(statearr_67515[(7)] = inst_67458);

return statearr_67515;
})();
var statearr_67516_67549 = state_67511__$1;
(statearr_67516_67549[(2)] = inst_67459);

(statearr_67516_67549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (15))){
var inst_67472 = (state_67511[(8)]);
var inst_67490 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67472);
var state_67511__$1 = state_67511;
var statearr_67517_67550 = state_67511__$1;
(statearr_67517_67550[(2)] = inst_67490);

(statearr_67517_67550[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (13))){
var state_67511__$1 = state_67511;
var statearr_67518_67551 = state_67511__$1;
(statearr_67518_67551[(2)] = false);

(statearr_67518_67551[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (6))){
var state_67511__$1 = state_67511;
var statearr_67519_67552 = state_67511__$1;
(statearr_67519_67552[(2)] = null);

(statearr_67519_67552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (17))){
var inst_67471 = (state_67511[(9)]);
var inst_67493 = (state_67511[(2)]);
var inst_67494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67493,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_67495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67493,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_67496 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67471], 0));
var state_67511__$1 = (function (){var statearr_67520 = state_67511;
(statearr_67520[(10)] = inst_67495);

(statearr_67520[(11)] = inst_67494);

return statearr_67520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67511__$1,(18),inst_67496);
} else {
if((state_val_67512 === (3))){
var inst_67509 = (state_67511[(2)]);
var state_67511__$1 = state_67511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67511__$1,inst_67509);
} else {
if((state_val_67512 === (12))){
var state_67511__$1 = state_67511;
var statearr_67521_67553 = state_67511__$1;
(statearr_67521_67553[(2)] = true);

(statearr_67521_67553[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (2))){
var _ = (function (){var statearr_67522 = state_67511;
(statearr_67522[(4)] = cljs.core.cons((5),(state_67511[(4)])));

return statearr_67522;
})();
var inst_67466 = (opts == null);
var state_67511__$1 = state_67511;
if(cljs.core.truth_(inst_67466)){
var statearr_67523_67554 = state_67511__$1;
(statearr_67523_67554[(1)] = (6));

} else {
var statearr_67524_67555 = state_67511__$1;
(statearr_67524_67555[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (19))){
var inst_67502 = (state_67511[(2)]);
var inst_67503 = fluree.db.util.async.throw_err(inst_67502);
var inst_67504 = fluree.db.query.range.block_with_tx_data(inst_67503);
var inst_67505 = cljs.core.clj__GT_js(inst_67504);
var inst_67506 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67505) : resolve.call(null,inst_67505));
var _ = (function (){var statearr_67525 = state_67511;
(statearr_67525[(4)] = cljs.core.rest((state_67511[(4)])));

return statearr_67525;
})();
var state_67511__$1 = state_67511;
var statearr_67526_67556 = state_67511__$1;
(statearr_67526_67556[(2)] = inst_67506);

(statearr_67526_67556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (11))){
var inst_67488 = (state_67511[(2)]);
var state_67511__$1 = state_67511;
if(cljs.core.truth_(inst_67488)){
var statearr_67528_67557 = state_67511__$1;
(statearr_67528_67557[(1)] = (15));

} else {
var statearr_67529_67558 = state_67511__$1;
(statearr_67529_67558[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (9))){
var inst_67472 = (state_67511[(8)]);
var inst_67477 = inst_67472.cljs$lang$protocol_mask$partition0$;
var inst_67478 = (inst_67477 & (64));
var inst_67479 = inst_67472.cljs$core$ISeq$;
var inst_67480 = (cljs.core.PROTOCOL_SENTINEL === inst_67479);
var inst_67481 = ((inst_67478) || (inst_67480));
var state_67511__$1 = state_67511;
if(cljs.core.truth_(inst_67481)){
var statearr_67530_67559 = state_67511__$1;
(statearr_67530_67559[(1)] = (12));

} else {
var statearr_67531_67560 = state_67511__$1;
(statearr_67531_67560[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (5))){
var _ = (function (){var statearr_67532 = state_67511;
(statearr_67532[(4)] = cljs.core.rest((state_67511[(4)])));

return statearr_67532;
})();
var state_67511__$1 = state_67511;
var ex67527 = (state_67511__$1[(2)]);
var statearr_67533_67561 = state_67511__$1;
(statearr_67533_67561[(5)] = ex67527);


var statearr_67534_67562 = state_67511__$1;
(statearr_67534_67562[(1)] = (4));

(statearr_67534_67562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (14))){
var inst_67485 = (state_67511[(2)]);
var state_67511__$1 = state_67511;
var statearr_67535_67563 = state_67511__$1;
(statearr_67535_67563[(2)] = inst_67485);

(statearr_67535_67563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (16))){
var inst_67472 = (state_67511[(8)]);
var state_67511__$1 = state_67511;
var statearr_67536_67564 = state_67511__$1;
(statearr_67536_67564[(2)] = inst_67472);

(statearr_67536_67564[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (10))){
var state_67511__$1 = state_67511;
var statearr_67537_67565 = state_67511__$1;
(statearr_67537_67565[(2)] = false);

(statearr_67537_67565[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67512 === (18))){
var inst_67495 = (state_67511[(10)]);
var inst_67471 = (state_67511[(9)]);
var inst_67494 = (state_67511[(11)]);
var inst_67498 = (state_67511[(2)]);
var inst_67499 = fluree.db.util.async.throw_err(inst_67498);
var inst_67500 = fluree.db.query.block.block_range(inst_67499,inst_67494,inst_67495,inst_67471);
var state_67511__$1 = state_67511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67511__$1,(19),inst_67500);
} else {
if((state_val_67512 === (8))){
var inst_67472 = (state_67511[(8)]);
var inst_67471 = (state_67511[(2)]);
var inst_67472__$1 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67474 = (inst_67472__$1 == null);
var inst_67475 = cljs.core.not(inst_67474);
var state_67511__$1 = (function (){var statearr_67538 = state_67511;
(statearr_67538[(9)] = inst_67471);

(statearr_67538[(8)] = inst_67472__$1);

return statearr_67538;
})();
if(inst_67475){
var statearr_67539_67566 = state_67511__$1;
(statearr_67539_67566[(1)] = (9));

} else {
var statearr_67540_67567 = state_67511__$1;
(statearr_67540_67567[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67541 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67541[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67541[(1)] = (1));

return statearr_67541;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67511){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67511);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67542){var ex__2417__auto__ = e67542;
var statearr_67543_67568 = state_67511;
(statearr_67543_67568[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67511[(4)]))){
var statearr_67544_67569 = state_67511;
(statearr_67544_67569[(1)] = cljs.core.first((state_67511[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67570 = state_67511;
state_67511 = G__67570;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67511){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67545 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67545[(6)] = c__2436__auto__);

return statearr_67545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__67572 = arguments.length;
switch (G__67572) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67639){
var state_val_67640 = (state_67639[(1)]);
if((state_val_67640 === (7))){
var inst_67585 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67639__$1 = state_67639;
var statearr_67641_67682 = state_67639__$1;
(statearr_67641_67682[(2)] = inst_67585);

(statearr_67641_67682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (20))){
var inst_67587 = (state_67639[(7)]);
var inst_67581 = (state_67639[(8)]);
var inst_67623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67624 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_67625 = (new cljs.core.PersistentVector(null,1,(5),inst_67623,inst_67624,null));
var inst_67626 = cljs.core.assoc_in(inst_67587,inst_67625,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67627 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67581,inst_67626);
var state_67639__$1 = state_67639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67639__$1,(23),inst_67627);
} else {
if((state_val_67640 === (1))){
var state_67639__$1 = state_67639;
var statearr_67642_67683 = state_67639__$1;
(statearr_67642_67683[(2)] = null);

(statearr_67642_67683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (4))){
var inst_67573 = (state_67639[(2)]);
var inst_67574 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67573], 0));
var inst_67575 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67573) : reject.call(null,inst_67573));
var state_67639__$1 = (function (){var statearr_67643 = state_67639;
(statearr_67643[(9)] = inst_67574);

return statearr_67643;
})();
var statearr_67644_67684 = state_67639__$1;
(statearr_67644_67684[(2)] = inst_67575);

(statearr_67644_67684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (15))){
var inst_67611 = (state_67639[(2)]);
var inst_67612 = fluree.db.util.async.throw_err(inst_67611);
var state_67639__$1 = state_67639;
var statearr_67645_67685 = state_67639__$1;
(statearr_67645_67685[(2)] = inst_67612);

(statearr_67645_67685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (21))){
var inst_67632 = (state_67639[(2)]);
var inst_67633 = cljs.core.clj__GT_js(inst_67632);
var inst_67634 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67633) : resolve.call(null,inst_67633));
var _ = (function (){var statearr_67646 = state_67639;
(statearr_67646[(4)] = cljs.core.rest((state_67639[(4)])));

return statearr_67646;
})();
var state_67639__$1 = state_67639;
var statearr_67647_67686 = state_67639__$1;
(statearr_67647_67686[(2)] = inst_67634);

(statearr_67647_67686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (13))){
var state_67639__$1 = state_67639;
var statearr_67648_67687 = state_67639__$1;
(statearr_67648_67687[(2)] = null);

(statearr_67648_67687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (22))){
var inst_67620 = (state_67639[(2)]);
var inst_67621 = fluree.db.util.async.throw_err(inst_67620);
var state_67639__$1 = state_67639;
var statearr_67649_67688 = state_67639__$1;
(statearr_67649_67688[(2)] = inst_67621);

(statearr_67649_67688[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (6))){
var state_67639__$1 = state_67639;
var statearr_67650_67689 = state_67639__$1;
(statearr_67650_67689[(2)] = null);

(statearr_67650_67689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (17))){
var state_67639__$1 = state_67639;
var statearr_67651_67690 = state_67639__$1;
(statearr_67651_67690[(2)] = null);

(statearr_67651_67690[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (3))){
var inst_67637 = (state_67639[(2)]);
var state_67639__$1 = state_67639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67639__$1,inst_67637);
} else {
if((state_val_67640 === (12))){
var inst_67595 = (state_67639[(10)]);
var inst_67599 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_67639__$1 = (function (){var statearr_67652 = state_67639;
(statearr_67652[(11)] = inst_67599);

return statearr_67652;
})();
if(cljs.core.truth_(inst_67595)){
var statearr_67653_67691 = state_67639__$1;
(statearr_67653_67691[(1)] = (16));

} else {
var statearr_67654_67692 = state_67639__$1;
(statearr_67654_67692[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (2))){
var _ = (function (){var statearr_67655 = state_67639;
(statearr_67655[(4)] = cljs.core.cons((5),(state_67639[(4)])));

return statearr_67655;
})();
var inst_67581 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67582 = (opts == null);
var state_67639__$1 = (function (){var statearr_67656 = state_67639;
(statearr_67656[(8)] = inst_67581);

return statearr_67656;
})();
if(cljs.core.truth_(inst_67582)){
var statearr_67657_67693 = state_67639__$1;
(statearr_67657_67693[(1)] = (6));

} else {
var statearr_67658_67694 = state_67639__$1;
(statearr_67658_67694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (23))){
var inst_67629 = (state_67639[(2)]);
var inst_67630 = fluree.db.util.async.throw_err(inst_67629);
var state_67639__$1 = state_67639;
var statearr_67659_67695 = state_67639__$1;
(statearr_67659_67695[(2)] = inst_67630);

(statearr_67659_67695[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (19))){
var inst_67587 = (state_67639[(7)]);
var inst_67615 = (state_67639[(12)]);
var inst_67581 = (state_67639[(8)]);
var inst_67618 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_67615,inst_67581,inst_67587);
var state_67639__$1 = state_67639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67639__$1,(22),inst_67618);
} else {
if((state_val_67640 === (11))){
var inst_67587 = (state_67639[(7)]);
var inst_67589 = (state_67639[(13)]);
var inst_67595 = (state_67639[(2)]);
var inst_67596 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_67587);
var inst_67597 = (inst_67589 == null);
var state_67639__$1 = (function (){var statearr_67661 = state_67639;
(statearr_67661[(14)] = inst_67596);

(statearr_67661[(10)] = inst_67595);

return statearr_67661;
})();
if(cljs.core.truth_(inst_67597)){
var statearr_67662_67696 = state_67639__$1;
(statearr_67662_67696[(1)] = (12));

} else {
var statearr_67663_67697 = state_67639__$1;
(statearr_67663_67697[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (9))){
var inst_67590 = (state_67639[(15)]);
var state_67639__$1 = state_67639;
var statearr_67664_67698 = state_67639__$1;
(statearr_67664_67698[(2)] = inst_67590);

(statearr_67664_67698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (5))){
var _ = (function (){var statearr_67665 = state_67639;
(statearr_67665[(4)] = cljs.core.rest((state_67639[(4)])));

return statearr_67665;
})();
var state_67639__$1 = state_67639;
var ex67660 = (state_67639__$1[(2)]);
var statearr_67666_67699 = state_67639__$1;
(statearr_67666_67699[(5)] = ex67660);


var statearr_67667_67700 = state_67639__$1;
(statearr_67667_67700[(1)] = (4));

(statearr_67667_67700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (14))){
var inst_67589 = (state_67639[(13)]);
var inst_67615 = (state_67639[(2)]);
var inst_67616 = (inst_67589 == null);
var state_67639__$1 = (function (){var statearr_67668 = state_67639;
(statearr_67668[(12)] = inst_67615);

return statearr_67668;
})();
if(cljs.core.truth_(inst_67616)){
var statearr_67669_67701 = state_67639__$1;
(statearr_67669_67701[(1)] = (19));

} else {
var statearr_67670_67702 = state_67639__$1;
(statearr_67670_67702[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (16))){
var inst_67595 = (state_67639[(10)]);
var inst_67601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67602 = ["_auth/id",inst_67595];
var inst_67603 = (new cljs.core.PersistentVector(null,2,(5),inst_67601,inst_67602,null));
var state_67639__$1 = state_67639;
var statearr_67671_67703 = state_67639__$1;
(statearr_67671_67703[(2)] = inst_67603);

(statearr_67671_67703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (10))){
var inst_67587 = (state_67639[(7)]);
var inst_67593 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67587);
var state_67639__$1 = state_67639;
var statearr_67672_67704 = state_67639__$1;
(statearr_67672_67704[(2)] = inst_67593);

(statearr_67672_67704[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67640 === (18))){
var inst_67596 = (state_67639[(14)]);
var inst_67599 = (state_67639[(11)]);
var inst_67606 = (state_67639[(2)]);
var inst_67607 = [inst_67606,inst_67596];
var inst_67608 = cljs.core.PersistentHashMap.fromArrays(inst_67599,inst_67607);
var inst_67609 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67608], 0));
var state_67639__$1 = state_67639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67639__$1,(15),inst_67609);
} else {
if((state_val_67640 === (8))){
var inst_67587 = (state_67639[(7)]);
var inst_67590 = (state_67639[(15)]);
var inst_67587__$1 = (state_67639[(2)]);
var inst_67588 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_67587__$1);
var inst_67589 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_67587__$1);
var inst_67590__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_67587__$1);
var state_67639__$1 = (function (){var statearr_67673 = state_67639;
(statearr_67673[(7)] = inst_67587__$1);

(statearr_67673[(16)] = inst_67588);

(statearr_67673[(15)] = inst_67590__$1);

(statearr_67673[(13)] = inst_67589);

return statearr_67673;
})();
if(cljs.core.truth_(inst_67590__$1)){
var statearr_67674_67705 = state_67639__$1;
(statearr_67674_67705[(1)] = (9));

} else {
var statearr_67675_67706 = state_67639__$1;
(statearr_67675_67706[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67676 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67676[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67676[(1)] = (1));

return statearr_67676;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67639){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67639);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67677){var ex__2417__auto__ = e67677;
var statearr_67678_67707 = state_67639;
(statearr_67678_67707[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67639[(4)]))){
var statearr_67679_67708 = state_67639;
(statearr_67679_67708[(1)] = cljs.core.first((state_67639[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67709 = state_67639;
state_67639 = G__67709;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67639){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67680 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67680[(6)] = c__2436__auto__);

return statearr_67680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67729){
var state_val_67730 = (state_67729[(1)]);
if((state_val_67730 === (1))){
var state_67729__$1 = state_67729;
var statearr_67731_67746 = state_67729__$1;
(statearr_67731_67746[(2)] = null);

(statearr_67731_67746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (2))){
var _ = (function (){var statearr_67732 = state_67729;
(statearr_67732[(4)] = cljs.core.cons((5),(state_67729[(4)])));

return statearr_67732;
})();
var inst_67718 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67719 = fluree.db.api.query.history_query_async(sources,inst_67718);
var state_67729__$1 = state_67729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67729__$1,(6),inst_67719);
} else {
if((state_val_67730 === (3))){
var inst_67727 = (state_67729[(2)]);
var state_67729__$1 = state_67729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67729__$1,inst_67727);
} else {
if((state_val_67730 === (4))){
var inst_67710 = (state_67729[(2)]);
var inst_67711 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67710], 0));
var inst_67712 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67710) : reject.call(null,inst_67710));
var state_67729__$1 = (function (){var statearr_67734 = state_67729;
(statearr_67734[(7)] = inst_67711);

return statearr_67734;
})();
var statearr_67735_67747 = state_67729__$1;
(statearr_67735_67747[(2)] = inst_67712);

(statearr_67735_67747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (5))){
var _ = (function (){var statearr_67736 = state_67729;
(statearr_67736[(4)] = cljs.core.rest((state_67729[(4)])));

return statearr_67736;
})();
var state_67729__$1 = state_67729;
var ex67733 = (state_67729__$1[(2)]);
var statearr_67737_67748 = state_67729__$1;
(statearr_67737_67748[(5)] = ex67733);


var statearr_67738_67749 = state_67729__$1;
(statearr_67738_67749[(1)] = (4));

(statearr_67738_67749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67730 === (6))){
var inst_67721 = (state_67729[(2)]);
var inst_67722 = fluree.db.util.async.throw_err(inst_67721);
var inst_67723 = cljs.core.clj__GT_js(inst_67722);
var inst_67724 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67723) : resolve.call(null,inst_67723));
var _ = (function (){var statearr_67739 = state_67729;
(statearr_67739[(4)] = cljs.core.rest((state_67729[(4)])));

return statearr_67739;
})();
var state_67729__$1 = state_67729;
var statearr_67740_67750 = state_67729__$1;
(statearr_67740_67750[(2)] = inst_67724);

(statearr_67740_67750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2414__auto__ = null;
var flureedb$history_query_$_state_machine__2414__auto____0 = (function (){
var statearr_67741 = [null,null,null,null,null,null,null,null];
(statearr_67741[(0)] = flureedb$history_query_$_state_machine__2414__auto__);

(statearr_67741[(1)] = (1));

return statearr_67741;
});
var flureedb$history_query_$_state_machine__2414__auto____1 = (function (state_67729){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67729);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67742){var ex__2417__auto__ = e67742;
var statearr_67743_67751 = state_67729;
(statearr_67743_67751[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67729[(4)]))){
var statearr_67744_67752 = state_67729;
(statearr_67744_67752[(1)] = cljs.core.first((state_67729[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67753 = state_67729;
state_67729 = G__67753;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2414__auto__ = function(state_67729){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2414__auto____1.call(this,state_67729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2414__auto____0;
flureedb$history_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2414__auto____1;
return flureedb$history_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67745 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67745[(6)] = c__2436__auto__);

return statearr_67745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67773){
var state_val_67774 = (state_67773[(1)]);
if((state_val_67774 === (1))){
var state_67773__$1 = state_67773;
var statearr_67775_67790 = state_67773__$1;
(statearr_67775_67790[(2)] = null);

(statearr_67775_67790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67774 === (2))){
var _ = (function (){var statearr_67776 = state_67773;
(statearr_67776[(4)] = cljs.core.cons((5),(state_67773[(4)])));

return statearr_67776;
})();
var inst_67762 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67763 = fluree.db.api.query.multi_query_async(sources,inst_67762);
var state_67773__$1 = state_67773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67773__$1,(6),inst_67763);
} else {
if((state_val_67774 === (3))){
var inst_67771 = (state_67773[(2)]);
var state_67773__$1 = state_67773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67773__$1,inst_67771);
} else {
if((state_val_67774 === (4))){
var inst_67754 = (state_67773[(2)]);
var inst_67755 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67754], 0));
var inst_67756 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67754) : reject.call(null,inst_67754));
var state_67773__$1 = (function (){var statearr_67778 = state_67773;
(statearr_67778[(7)] = inst_67755);

return statearr_67778;
})();
var statearr_67779_67791 = state_67773__$1;
(statearr_67779_67791[(2)] = inst_67756);

(statearr_67779_67791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67774 === (5))){
var _ = (function (){var statearr_67780 = state_67773;
(statearr_67780[(4)] = cljs.core.rest((state_67773[(4)])));

return statearr_67780;
})();
var state_67773__$1 = state_67773;
var ex67777 = (state_67773__$1[(2)]);
var statearr_67781_67792 = state_67773__$1;
(statearr_67781_67792[(5)] = ex67777);


var statearr_67782_67793 = state_67773__$1;
(statearr_67782_67793[(1)] = (4));

(statearr_67782_67793[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67774 === (6))){
var inst_67765 = (state_67773[(2)]);
var inst_67766 = fluree.db.util.async.throw_err(inst_67765);
var inst_67767 = cljs.core.clj__GT_js(inst_67766);
var inst_67768 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67767) : resolve.call(null,inst_67767));
var _ = (function (){var statearr_67783 = state_67773;
(statearr_67783[(4)] = cljs.core.rest((state_67773[(4)])));

return statearr_67783;
})();
var state_67773__$1 = state_67773;
var statearr_67784_67794 = state_67773__$1;
(statearr_67784_67794[(2)] = inst_67768);

(statearr_67784_67794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2414__auto__ = null;
var flureedb$multi_query_$_state_machine__2414__auto____0 = (function (){
var statearr_67785 = [null,null,null,null,null,null,null,null];
(statearr_67785[(0)] = flureedb$multi_query_$_state_machine__2414__auto__);

(statearr_67785[(1)] = (1));

return statearr_67785;
});
var flureedb$multi_query_$_state_machine__2414__auto____1 = (function (state_67773){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67773);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67786){var ex__2417__auto__ = e67786;
var statearr_67787_67795 = state_67773;
(statearr_67787_67795[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67773[(4)]))){
var statearr_67788_67796 = state_67773;
(statearr_67788_67796[(1)] = cljs.core.first((state_67773[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67797 = state_67773;
state_67773 = G__67797;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2414__auto__ = function(state_67773){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2414__auto____1.call(this,state_67773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2414__auto____0;
flureedb$multi_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2414__auto____1;
return flureedb$multi_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67789 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67789[(6)] = c__2436__auto__);

return statearr_67789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67817){
var state_val_67818 = (state_67817[(1)]);
if((state_val_67818 === (1))){
var state_67817__$1 = state_67817;
var statearr_67819_67834 = state_67817__$1;
(statearr_67819_67834[(2)] = null);

(statearr_67819_67834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67818 === (2))){
var _ = (function (){var statearr_67820 = state_67817;
(statearr_67820[(4)] = cljs.core.cons((5),(state_67817[(4)])));

return statearr_67820;
})();
var inst_67807 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67808 = fluree.db.api.query.query_async(sources,inst_67807);
var state_67817__$1 = state_67817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67817__$1,(6),inst_67808);
} else {
if((state_val_67818 === (3))){
var inst_67815 = (state_67817[(2)]);
var state_67817__$1 = state_67817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67817__$1,inst_67815);
} else {
if((state_val_67818 === (4))){
var inst_67798 = (state_67817[(2)]);
var inst_67799 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67798], 0));
var inst_67800 = cljs.core.clj__GT_js(inst_67798);
var inst_67801 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67800) : reject.call(null,inst_67800));
var state_67817__$1 = (function (){var statearr_67822 = state_67817;
(statearr_67822[(7)] = inst_67799);

return statearr_67822;
})();
var statearr_67823_67835 = state_67817__$1;
(statearr_67823_67835[(2)] = inst_67801);

(statearr_67823_67835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67818 === (5))){
var _ = (function (){var statearr_67824 = state_67817;
(statearr_67824[(4)] = cljs.core.rest((state_67817[(4)])));

return statearr_67824;
})();
var state_67817__$1 = state_67817;
var ex67821 = (state_67817__$1[(2)]);
var statearr_67825_67836 = state_67817__$1;
(statearr_67825_67836[(5)] = ex67821);


var statearr_67826_67837 = state_67817__$1;
(statearr_67826_67837[(1)] = (4));

(statearr_67826_67837[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67818 === (6))){
var inst_67810 = (state_67817[(2)]);
var inst_67811 = cljs.core.clj__GT_js(inst_67810);
var inst_67812 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67811) : resolve.call(null,inst_67811));
var _ = (function (){var statearr_67827 = state_67817;
(statearr_67827[(4)] = cljs.core.rest((state_67817[(4)])));

return statearr_67827;
})();
var state_67817__$1 = state_67817;
var statearr_67828_67838 = state_67817__$1;
(statearr_67828_67838[(2)] = inst_67812);

(statearr_67828_67838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2414__auto__ = null;
var flureedb$query_$_state_machine__2414__auto____0 = (function (){
var statearr_67829 = [null,null,null,null,null,null,null,null];
(statearr_67829[(0)] = flureedb$query_$_state_machine__2414__auto__);

(statearr_67829[(1)] = (1));

return statearr_67829;
});
var flureedb$query_$_state_machine__2414__auto____1 = (function (state_67817){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67817);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67830){var ex__2417__auto__ = e67830;
var statearr_67831_67839 = state_67817;
(statearr_67831_67839[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67817[(4)]))){
var statearr_67832_67840 = state_67817;
(statearr_67832_67840[(1)] = cljs.core.first((state_67817[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67841 = state_67817;
state_67817 = G__67841;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2414__auto__ = function(state_67817){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2414__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2414__auto____1.call(this,state_67817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2414__auto____0;
flureedb$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2414__auto____1;
return flureedb$query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67833 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67833[(6)] = c__2436__auto__);

return statearr_67833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__67843 = arguments.length;
switch (G__67843) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_67870){
var state_val_67871 = (state_67870[(1)]);
if((state_val_67871 === (7))){
var inst_67857 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_67870__$1 = state_67870;
var statearr_67872_67893 = state_67870__$1;
(statearr_67872_67893[(2)] = inst_67857);

(statearr_67872_67893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (1))){
var state_67870__$1 = state_67870;
var statearr_67873_67894 = state_67870__$1;
(statearr_67873_67894[(2)] = null);

(statearr_67873_67894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (4))){
var inst_67844 = (state_67870[(2)]);
var inst_67845 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67844], 0));
var inst_67846 = cljs.core.clj__GT_js(inst_67844);
var inst_67847 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_67846) : reject.call(null,inst_67846));
var state_67870__$1 = (function (){var statearr_67874 = state_67870;
(statearr_67874[(7)] = inst_67845);

return statearr_67874;
})();
var statearr_67875_67895 = state_67870__$1;
(statearr_67875_67895[(2)] = inst_67847);

(statearr_67875_67895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (6))){
var state_67870__$1 = state_67870;
var statearr_67876_67896 = state_67870__$1;
(statearr_67876_67896[(2)] = null);

(statearr_67876_67896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (3))){
var inst_67868 = (state_67870[(2)]);
var state_67870__$1 = state_67870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67870__$1,inst_67868);
} else {
if((state_val_67871 === (2))){
var _ = (function (){var statearr_67878 = state_67870;
(statearr_67878[(4)] = cljs.core.cons((5),(state_67870[(4)])));

return statearr_67878;
})();
var inst_67853 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_67854 = (opts == null);
var state_67870__$1 = (function (){var statearr_67879 = state_67870;
(statearr_67879[(8)] = inst_67853);

return statearr_67879;
})();
if(cljs.core.truth_(inst_67854)){
var statearr_67880_67897 = state_67870__$1;
(statearr_67880_67897[(1)] = (6));

} else {
var statearr_67881_67898 = state_67870__$1;
(statearr_67881_67898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (9))){
var inst_67862 = (state_67870[(2)]);
var inst_67863 = fluree.db.util.async.throw_err(inst_67862);
var inst_67864 = cljs.core.clj__GT_js(inst_67863);
var inst_67865 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_67864) : resolve.call(null,inst_67864));
var _ = (function (){var statearr_67882 = state_67870;
(statearr_67882[(4)] = cljs.core.rest((state_67870[(4)])));

return statearr_67882;
})();
var state_67870__$1 = state_67870;
var statearr_67883_67899 = state_67870__$1;
(statearr_67883_67899[(2)] = inst_67865);

(statearr_67883_67899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (5))){
var _ = (function (){var statearr_67884 = state_67870;
(statearr_67884[(4)] = cljs.core.rest((state_67870[(4)])));

return statearr_67884;
})();
var state_67870__$1 = state_67870;
var ex67877 = (state_67870__$1[(2)]);
var statearr_67885_67900 = state_67870__$1;
(statearr_67885_67900[(5)] = ex67877);


var statearr_67886_67901 = state_67870__$1;
(statearr_67886_67901[(1)] = (4));

(statearr_67886_67901[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67871 === (8))){
var inst_67853 = (state_67870[(8)]);
var inst_67859 = (state_67870[(2)]);
var inst_67860 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_67853,inst_67859);
var state_67870__$1 = state_67870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67870__$1,(9),inst_67860);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2414__auto__ = null;
var flureedb$state_machine__2414__auto____0 = (function (){
var statearr_67887 = [null,null,null,null,null,null,null,null,null];
(statearr_67887[(0)] = flureedb$state_machine__2414__auto__);

(statearr_67887[(1)] = (1));

return statearr_67887;
});
var flureedb$state_machine__2414__auto____1 = (function (state_67870){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_67870);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e67888){var ex__2417__auto__ = e67888;
var statearr_67889_67902 = state_67870;
(statearr_67889_67902[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_67870[(4)]))){
var statearr_67890_67903 = state_67870;
(statearr_67890_67903[(1)] = cljs.core.first((state_67870[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67904 = state_67870;
state_67870 = G__67904;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureedb$state_machine__2414__auto__ = function(state_67870){
switch(arguments.length){
case 0:
return flureedb$state_machine__2414__auto____0.call(this);
case 1:
return flureedb$state_machine__2414__auto____1.call(this,state_67870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2414__auto____0;
flureedb$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2414__auto____1;
return flureedb$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_67891 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_67891[(6)] = c__2436__auto__);

return statearr_67891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
