// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__9562 = s;
var map__9562__$1 = (((((!((map__9562 == null))))?(((((map__9562.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9562.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9562):map__9562);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9562__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9562__$1,cljs.core.cst$kw$info);
var d = (0);
var G__9565 = info;
var map__9566 = G__9565;
var map__9566__$1 = (((((!((map__9566 == null))))?(((((map__9566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9566.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9566):map__9566);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9566__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__9565__$1 = G__9565;
while(true){
var d__$2 = d__$1;
var map__9570 = G__9565__$1;
var map__9570__$1 = (((((!((map__9570 == null))))?(((((map__9570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9570.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9570):map__9570);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9570__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__9572 = (d__$2 + (1));
var G__9573 = shadow__$1;
d__$1 = G__9572;
G__9565__$1 = G__9573;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__9574){
var map__9575 = p__9574;
var map__9575__$1 = (((((!((map__9575 == null))))?(((((map__9575.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9575.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9575):map__9575);
var name_var = map__9575__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9575__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9575__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__9577 = info;
var map__9577__$1 = (((((!((map__9577 == null))))?(((((map__9577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9577):map__9577);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9577__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9577__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__9579 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__9579) : cljs.compiler.munge.call(null,G__9579));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__9581 = arguments.length;
switch (G__9581) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__9582 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11501,11501,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__9582.cljs$core$IFn$_invoke$arity$1 ? fexpr__9582.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__9582.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__9584 = cp;
switch (G__9584) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__9586_9590 = cljs.core.seq(s);
var chunk__9587_9591 = null;
var count__9588_9592 = (0);
var i__9589_9593 = (0);
while(true){
if((i__9589_9593 < count__9588_9592)){
var c_9594 = chunk__9587_9591.cljs$core$IIndexed$_nth$arity$2(null,i__9589_9593);
sb.append(cljs.compiler.escape_char(c_9594));


var G__9595 = seq__9586_9590;
var G__9596 = chunk__9587_9591;
var G__9597 = count__9588_9592;
var G__9598 = (i__9589_9593 + (1));
seq__9586_9590 = G__9595;
chunk__9587_9591 = G__9596;
count__9588_9592 = G__9597;
i__9589_9593 = G__9598;
continue;
} else {
var temp__5754__auto___9599 = cljs.core.seq(seq__9586_9590);
if(temp__5754__auto___9599){
var seq__9586_9600__$1 = temp__5754__auto___9599;
if(cljs.core.chunked_seq_QMARK_(seq__9586_9600__$1)){
var c__4556__auto___9601 = cljs.core.chunk_first(seq__9586_9600__$1);
var G__9602 = cljs.core.chunk_rest(seq__9586_9600__$1);
var G__9603 = c__4556__auto___9601;
var G__9604 = cljs.core.count(c__4556__auto___9601);
var G__9605 = (0);
seq__9586_9590 = G__9602;
chunk__9587_9591 = G__9603;
count__9588_9592 = G__9604;
i__9589_9593 = G__9605;
continue;
} else {
var c_9606 = cljs.core.first(seq__9586_9600__$1);
sb.append(cljs.compiler.escape_char(c_9606));


var G__9607 = cljs.core.next(seq__9586_9600__$1);
var G__9608 = null;
var G__9609 = (0);
var G__9610 = (0);
seq__9586_9590 = G__9607;
chunk__9587_9591 = G__9608;
count__9588_9592 = G__9609;
i__9589_9593 = G__9610;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9611 = cljs.core.get_global_hierarchy;
return (fexpr__9611.cljs$core$IFn$_invoke$arity$0 ? fexpr__9611.cljs$core$IFn$_invoke$arity$0() : fexpr__9611.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__9612_9619 = ast;
var map__9612_9620__$1 = (((((!((map__9612_9619 == null))))?(((((map__9612_9619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9612_9619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9612_9619):map__9612_9619);
var env_9621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9612_9620__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_9621))){
var map__9614_9622 = env_9621;
var map__9614_9623__$1 = (((((!((map__9614_9622 == null))))?(((((map__9614_9622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9614_9622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9614_9622):map__9614_9622);
var line_9624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9614_9623__$1,cljs.core.cst$kw$line);
var column_9625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9614_9623__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__9616 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__9618 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__9617 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__9617.cljs$core$IFn$_invoke$arity$1 ? fexpr__9617.cljs$core$IFn$_invoke$arity$1(G__9618) : fexpr__9617.call(null,G__9618));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__9616,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__9616;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_9624 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_9625)?(column_9625 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__9634 = arguments.length;
switch (G__9634) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___9641 = arguments.length;
var i__4737__auto___9642 = (0);
while(true){
if((i__4737__auto___9642 < len__4736__auto___9641)){
args_arr__4757__auto__.push((arguments[i__4737__auto___9642]));

var G__9643 = (i__4737__auto___9642 + (1));
i__4737__auto___9642 = G__9643;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_9644 = (function (){var G__9635 = a;
if((!(typeof a === 'string'))){
return G__9635.toString();
} else {
return G__9635;
}
})();
var temp__5758__auto___9645 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5758__auto___9645 == null)){
} else {
var sm_data_9646 = temp__5758__auto___9645;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_9646,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__9626_SHARP_){
return (p1__9626_SHARP_ + s_9644.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_9644], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9636 = cljs.core.seq(xs);
var chunk__9637 = null;
var count__9638 = (0);
var i__9639 = (0);
while(true){
if((i__9639 < count__9638)){
var x = chunk__9637.cljs$core$IIndexed$_nth$arity$2(null,i__9639);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9647 = seq__9636;
var G__9648 = chunk__9637;
var G__9649 = count__9638;
var G__9650 = (i__9639 + (1));
seq__9636 = G__9647;
chunk__9637 = G__9648;
count__9638 = G__9649;
i__9639 = G__9650;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__9636);
if(temp__5754__auto__){
var seq__9636__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9636__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__9636__$1);
var G__9651 = cljs.core.chunk_rest(seq__9636__$1);
var G__9652 = c__4556__auto__;
var G__9653 = cljs.core.count(c__4556__auto__);
var G__9654 = (0);
seq__9636 = G__9651;
chunk__9637 = G__9652;
count__9638 = G__9653;
i__9639 = G__9654;
continue;
} else {
var x = cljs.core.first(seq__9636__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9655 = cljs.core.next(seq__9636__$1);
var G__9656 = null;
var G__9657 = (0);
var G__9658 = (0);
seq__9636 = G__9655;
chunk__9637 = G__9656;
count__9638 = G__9657;
i__9639 = G__9658;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq9628){
var G__9629 = cljs.core.first(seq9628);
var seq9628__$1 = cljs.core.next(seq9628);
var G__9630 = cljs.core.first(seq9628__$1);
var seq9628__$2 = cljs.core.next(seq9628__$1);
var G__9631 = cljs.core.first(seq9628__$2);
var seq9628__$3 = cljs.core.next(seq9628__$2);
var G__9632 = cljs.core.first(seq9628__$3);
var seq9628__$4 = cljs.core.next(seq9628__$3);
var G__9633 = cljs.core.first(seq9628__$4);
var seq9628__$5 = cljs.core.next(seq9628__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9629,G__9630,G__9631,G__9632,G__9633,seq9628__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__9659){
var map__9660 = p__9659;
var map__9660__$1 = (((((!((map__9660 == null))))?(((((map__9660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9660.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9660):map__9660);
var m = map__9660__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9660__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__9669 = arguments.length;
switch (G__9669) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___9675 = arguments.length;
var i__4737__auto___9676 = (0);
while(true){
if((i__4737__auto___9676 < len__4736__auto___9675)){
args_arr__4757__auto__.push((arguments[i__4737__auto___9676]));

var G__9677 = (i__4737__auto___9676 + (1));
i__4737__auto___9676 = G__9677;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9670_9678 = cljs.core.seq(xs);
var chunk__9671_9679 = null;
var count__9672_9680 = (0);
var i__9673_9681 = (0);
while(true){
if((i__9673_9681 < count__9672_9680)){
var x_9682 = chunk__9671_9679.cljs$core$IIndexed$_nth$arity$2(null,i__9673_9681);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9682);


var G__9683 = seq__9670_9678;
var G__9684 = chunk__9671_9679;
var G__9685 = count__9672_9680;
var G__9686 = (i__9673_9681 + (1));
seq__9670_9678 = G__9683;
chunk__9671_9679 = G__9684;
count__9672_9680 = G__9685;
i__9673_9681 = G__9686;
continue;
} else {
var temp__5754__auto___9687 = cljs.core.seq(seq__9670_9678);
if(temp__5754__auto___9687){
var seq__9670_9688__$1 = temp__5754__auto___9687;
if(cljs.core.chunked_seq_QMARK_(seq__9670_9688__$1)){
var c__4556__auto___9689 = cljs.core.chunk_first(seq__9670_9688__$1);
var G__9690 = cljs.core.chunk_rest(seq__9670_9688__$1);
var G__9691 = c__4556__auto___9689;
var G__9692 = cljs.core.count(c__4556__auto___9689);
var G__9693 = (0);
seq__9670_9678 = G__9690;
chunk__9671_9679 = G__9691;
count__9672_9680 = G__9692;
i__9673_9681 = G__9693;
continue;
} else {
var x_9694 = cljs.core.first(seq__9670_9688__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_9694);


var G__9695 = cljs.core.next(seq__9670_9688__$1);
var G__9696 = null;
var G__9697 = (0);
var G__9698 = (0);
seq__9670_9678 = G__9695;
chunk__9671_9679 = G__9696;
count__9672_9680 = G__9697;
i__9673_9681 = G__9698;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq9663){
var G__9664 = cljs.core.first(seq9663);
var seq9663__$1 = cljs.core.next(seq9663);
var G__9665 = cljs.core.first(seq9663__$1);
var seq9663__$2 = cljs.core.next(seq9663__$1);
var G__9666 = cljs.core.first(seq9663__$2);
var seq9663__$3 = cljs.core.next(seq9663__$2);
var G__9667 = cljs.core.first(seq9663__$3);
var seq9663__$4 = cljs.core.next(seq9663__$3);
var G__9668 = cljs.core.first(seq9663__$4);
var seq9663__$5 = cljs.core.next(seq9663__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9664,G__9665,G__9666,G__9667,G__9668,seq9663__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__9699_9703 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__9700_9704 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__9701_9705 = true;
var _STAR_print_fn_STAR__temp_val__9702_9706 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__9701_9705);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__9702_9706);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__9700_9704);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__9699_9703);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9707 = cljs.core.get_global_hierarchy;
return (fexpr__9707.cljs$core$IFn$_invoke$arity$0 ? fexpr__9707.cljs$core$IFn$_invoke$arity$0() : fexpr__9707.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__9708 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9708,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9708,(1),null);
var G__9711 = ns;
var G__9712 = name;
var G__9713 = (function (){
var G__9714 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__9714) : cljs.compiler.emit_constant.call(null,G__9714));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__9711,G__9712,G__9713) : cljs.compiler.emit_record_value.call(null,G__9711,G__9712,G__9713));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__9715 = cljs.core.keys(x);
var G__9716 = cljs.core.vals(x);
var G__9717 = cljs.compiler.emit_constants_comma_sep;
var G__9718 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__9715,G__9716,G__9717,G__9718) : cljs.compiler.emit_map.call(null,G__9715,G__9716,G__9717,G__9718));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__9719 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__9720 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__9719,G__9720) : cljs.compiler.emit_with_meta.call(null,G__9719,G__9720));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__9721 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9721,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9721,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9721,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5752__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__9724 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9724) : x.call(null,G__9724));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5752__auto__)){
var value = temp__5752__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5752__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__9725 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__9725) : x.call(null,G__9725));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5752__auto__)){
var value = temp__5752__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__9727 = items;
var G__9728 = (function (p1__9726_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__9726_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__9727,G__9728) : cljs.compiler.emit_js_object.call(null,G__9727,G__9728));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__9730){
var map__9731 = p__9730;
var map__9731__$1 = (((((!((map__9731 == null))))?(((((map__9731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9731.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9731):map__9731);
var ast = map__9731__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9731__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9731__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9731__$1,cljs.core.cst$kw$form);
var temp__5752__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5752__auto__)){
var const_expr = temp__5752__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__9733 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__9733__$1 = (((((!((map__9733 == null))))?(((((map__9733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9733.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9733):map__9733);
var cenv = map__9733__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9733__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__9735 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = (function (){var G__9738 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__9738) : cljs.compiler.es5_GT__EQ_.call(null,G__9738));
})();
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__9735,cljs.analyzer.es5_allowed);
} else {
return G__9735;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4126__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__9739 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__9739,reserved);
} else {
return G__9739;
}
})();
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__9740_9741 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__9740_9742__$1 = (((G__9740_9741 instanceof cljs.core.Keyword))?G__9740_9741.fqn:null);
switch (G__9740_9742__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__9744){
var map__9745 = p__9744;
var map__9745__$1 = (((((!((map__9745 == null))))?(((((map__9745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9745.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9745):map__9745);
var arg = map__9745__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9745__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9745__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9745__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9745__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__9747 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__9747__$1 = (((((!((map__9747 == null))))?(((((map__9747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9747.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9747):map__9747);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9747__$1,cljs.core.cst$kw$name);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__9749){
var map__9750 = p__9749;
var map__9750__$1 = (((((!((map__9750 == null))))?(((((map__9750.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9750.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9750):map__9750);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9750__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9750__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9750__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__9752_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9752_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__9753 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9753) : comma_sep.call(null,G__9753));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__9754 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9754) : comma_sep.call(null,G__9754));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__9755){
var map__9756 = p__9755;
var map__9756__$1 = (((((!((map__9756 == null))))?(((((map__9756.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9756.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9756):map__9756);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9756__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9756__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9756__$1,cljs.core.cst$kw$vals);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__9758){
var map__9759 = p__9758;
var map__9759__$1 = (((((!((map__9759 == null))))?(((((map__9759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9759):map__9759);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9759__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9759__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__9761_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__9761_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__9762 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__9762) : comma_sep.call(null,G__9762));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__9763){
var map__9764 = p__9763;
var map__9764__$1 = (((((!((map__9764 == null))))?(((((map__9764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9764):map__9764);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9764__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9764__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5754__auto___9788 = cljs.core.seq(items);
if(temp__5754__auto___9788){
var items_9789__$1 = temp__5754__auto___9788;
var vec__9766_9790 = items_9789__$1;
var seq__9767_9791 = cljs.core.seq(vec__9766_9790);
var first__9768_9792 = cljs.core.first(seq__9767_9791);
var seq__9767_9793__$1 = cljs.core.next(seq__9767_9791);
var vec__9769_9794 = first__9768_9792;
var k_9795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9769_9794,(0),null);
var v_9796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9769_9794,(1),null);
var r_9797 = seq__9767_9793__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_9795),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9796) : emit_js_object_val.call(null,v_9796)));

var seq__9772_9798 = cljs.core.seq(r_9797);
var chunk__9773_9799 = null;
var count__9774_9800 = (0);
var i__9775_9801 = (0);
while(true){
if((i__9775_9801 < count__9774_9800)){
var vec__9782_9802 = chunk__9773_9799.cljs$core$IIndexed$_nth$arity$2(null,i__9775_9801);
var k_9803__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9782_9802,(0),null);
var v_9804__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9782_9802,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9803__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9804__$1) : emit_js_object_val.call(null,v_9804__$1)));


var G__9805 = seq__9772_9798;
var G__9806 = chunk__9773_9799;
var G__9807 = count__9774_9800;
var G__9808 = (i__9775_9801 + (1));
seq__9772_9798 = G__9805;
chunk__9773_9799 = G__9806;
count__9774_9800 = G__9807;
i__9775_9801 = G__9808;
continue;
} else {
var temp__5754__auto___9809__$1 = cljs.core.seq(seq__9772_9798);
if(temp__5754__auto___9809__$1){
var seq__9772_9810__$1 = temp__5754__auto___9809__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9772_9810__$1)){
var c__4556__auto___9811 = cljs.core.chunk_first(seq__9772_9810__$1);
var G__9812 = cljs.core.chunk_rest(seq__9772_9810__$1);
var G__9813 = c__4556__auto___9811;
var G__9814 = cljs.core.count(c__4556__auto___9811);
var G__9815 = (0);
seq__9772_9798 = G__9812;
chunk__9773_9799 = G__9813;
count__9774_9800 = G__9814;
i__9775_9801 = G__9815;
continue;
} else {
var vec__9785_9816 = cljs.core.first(seq__9772_9810__$1);
var k_9817__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9785_9816,(0),null);
var v_9818__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9785_9816,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_9817__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_9818__$1) : emit_js_object_val.call(null,v_9818__$1)));


var G__9819 = cljs.core.next(seq__9772_9810__$1);
var G__9820 = null;
var G__9821 = (0);
var G__9822 = (0);
seq__9772_9798 = G__9819;
chunk__9773_9799 = G__9820;
count__9774_9800 = G__9821;
i__9775_9801 = G__9822;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__9823){
var map__9824 = p__9823;
var map__9824__$1 = (((((!((map__9824 == null))))?(((((map__9824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9824):map__9824);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9824__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9824__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9824__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__9826){
var map__9827 = p__9826;
var map__9827__$1 = (((((!((map__9827 == null))))?(((((map__9827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9827):map__9827);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9827__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9827__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__9829){
var map__9830 = p__9829;
var map__9830__$1 = (((((!((map__9830 == null))))?(((((map__9830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9830):map__9830);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9830__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__9832){
var map__9833 = p__9832;
var map__9833__$1 = (((((!((map__9833 == null))))?(((((map__9833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9833):map__9833);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9833__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9833__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__9835 = cljs.analyzer.unwrap_quote(expr);
var map__9835__$1 = (((((!((map__9835 == null))))?(((((map__9835.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9835.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9835):map__9835);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9835__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9835__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9835__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__9837 = cljs.analyzer.unwrap_quote(expr);
var map__9837__$1 = (((((!((map__9837 == null))))?(((((map__9837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9837):map__9837);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9837__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9837__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9837__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4126__auto__ = (function (){var fexpr__9840 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__9840.cljs$core$IFn$_invoke$arity$1 ? fexpr__9840.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__9840.call(null,tag));
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__9841){
var map__9842 = p__9841;
var map__9842__$1 = (((((!((map__9842 == null))))?(((((map__9842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9842.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9842):map__9842);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9842__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9842__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9842__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9842__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9842__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__9844){
var map__9845 = p__9844;
var map__9845__$1 = (((((!((map__9845 == null))))?(((((map__9845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9845.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9845):map__9845);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9845__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9845__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9845__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9845__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__9847_9883 = cljs.core.seq(nodes);
var chunk__9848_9884 = null;
var count__9849_9885 = (0);
var i__9850_9886 = (0);
while(true){
if((i__9850_9886 < count__9849_9885)){
var map__9867_9887 = chunk__9848_9884.cljs$core$IIndexed$_nth$arity$2(null,i__9850_9886);
var map__9867_9888__$1 = (((((!((map__9867_9887 == null))))?(((((map__9867_9887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9867_9887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9867_9887):map__9867_9887);
var ts_9889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9867_9888__$1,cljs.core.cst$kw$tests);
var map__9868_9890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9867_9888__$1,cljs.core.cst$kw$then);
var map__9868_9891__$1 = (((((!((map__9868_9890 == null))))?(((((map__9868_9890.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9868_9890.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9868_9890):map__9868_9890);
var then_9892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9868_9891__$1,cljs.core.cst$kw$then);
var seq__9871_9893 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9889));
var chunk__9872_9894 = null;
var count__9873_9895 = (0);
var i__9874_9896 = (0);
while(true){
if((i__9874_9896 < count__9873_9895)){
var test_9897 = chunk__9872_9894.cljs$core$IIndexed$_nth$arity$2(null,i__9874_9896);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9897,":");


var G__9898 = seq__9871_9893;
var G__9899 = chunk__9872_9894;
var G__9900 = count__9873_9895;
var G__9901 = (i__9874_9896 + (1));
seq__9871_9893 = G__9898;
chunk__9872_9894 = G__9899;
count__9873_9895 = G__9900;
i__9874_9896 = G__9901;
continue;
} else {
var temp__5754__auto___9902 = cljs.core.seq(seq__9871_9893);
if(temp__5754__auto___9902){
var seq__9871_9903__$1 = temp__5754__auto___9902;
if(cljs.core.chunked_seq_QMARK_(seq__9871_9903__$1)){
var c__4556__auto___9904 = cljs.core.chunk_first(seq__9871_9903__$1);
var G__9905 = cljs.core.chunk_rest(seq__9871_9903__$1);
var G__9906 = c__4556__auto___9904;
var G__9907 = cljs.core.count(c__4556__auto___9904);
var G__9908 = (0);
seq__9871_9893 = G__9905;
chunk__9872_9894 = G__9906;
count__9873_9895 = G__9907;
i__9874_9896 = G__9908;
continue;
} else {
var test_9909 = cljs.core.first(seq__9871_9903__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9909,":");


var G__9910 = cljs.core.next(seq__9871_9903__$1);
var G__9911 = null;
var G__9912 = (0);
var G__9913 = (0);
seq__9871_9893 = G__9910;
chunk__9872_9894 = G__9911;
count__9873_9895 = G__9912;
i__9874_9896 = G__9913;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9892);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9892);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9914 = seq__9847_9883;
var G__9915 = chunk__9848_9884;
var G__9916 = count__9849_9885;
var G__9917 = (i__9850_9886 + (1));
seq__9847_9883 = G__9914;
chunk__9848_9884 = G__9915;
count__9849_9885 = G__9916;
i__9850_9886 = G__9917;
continue;
} else {
var temp__5754__auto___9918 = cljs.core.seq(seq__9847_9883);
if(temp__5754__auto___9918){
var seq__9847_9919__$1 = temp__5754__auto___9918;
if(cljs.core.chunked_seq_QMARK_(seq__9847_9919__$1)){
var c__4556__auto___9920 = cljs.core.chunk_first(seq__9847_9919__$1);
var G__9921 = cljs.core.chunk_rest(seq__9847_9919__$1);
var G__9922 = c__4556__auto___9920;
var G__9923 = cljs.core.count(c__4556__auto___9920);
var G__9924 = (0);
seq__9847_9883 = G__9921;
chunk__9848_9884 = G__9922;
count__9849_9885 = G__9923;
i__9850_9886 = G__9924;
continue;
} else {
var map__9875_9925 = cljs.core.first(seq__9847_9919__$1);
var map__9875_9926__$1 = (((((!((map__9875_9925 == null))))?(((((map__9875_9925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9875_9925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9875_9925):map__9875_9925);
var ts_9927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9875_9926__$1,cljs.core.cst$kw$tests);
var map__9876_9928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9875_9926__$1,cljs.core.cst$kw$then);
var map__9876_9929__$1 = (((((!((map__9876_9928 == null))))?(((((map__9876_9928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9876_9928.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9876_9928):map__9876_9928);
var then_9930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9876_9929__$1,cljs.core.cst$kw$then);
var seq__9879_9931 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_9927));
var chunk__9880_9932 = null;
var count__9881_9933 = (0);
var i__9882_9934 = (0);
while(true){
if((i__9882_9934 < count__9881_9933)){
var test_9935 = chunk__9880_9932.cljs$core$IIndexed$_nth$arity$2(null,i__9882_9934);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9935,":");


var G__9936 = seq__9879_9931;
var G__9937 = chunk__9880_9932;
var G__9938 = count__9881_9933;
var G__9939 = (i__9882_9934 + (1));
seq__9879_9931 = G__9936;
chunk__9880_9932 = G__9937;
count__9881_9933 = G__9938;
i__9882_9934 = G__9939;
continue;
} else {
var temp__5754__auto___9940__$1 = cljs.core.seq(seq__9879_9931);
if(temp__5754__auto___9940__$1){
var seq__9879_9941__$1 = temp__5754__auto___9940__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9879_9941__$1)){
var c__4556__auto___9942 = cljs.core.chunk_first(seq__9879_9941__$1);
var G__9943 = cljs.core.chunk_rest(seq__9879_9941__$1);
var G__9944 = c__4556__auto___9942;
var G__9945 = cljs.core.count(c__4556__auto___9942);
var G__9946 = (0);
seq__9879_9931 = G__9943;
chunk__9880_9932 = G__9944;
count__9881_9933 = G__9945;
i__9882_9934 = G__9946;
continue;
} else {
var test_9947 = cljs.core.first(seq__9879_9941__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_9947,":");


var G__9948 = cljs.core.next(seq__9879_9941__$1);
var G__9949 = null;
var G__9950 = (0);
var G__9951 = (0);
seq__9879_9931 = G__9948;
chunk__9880_9932 = G__9949;
count__9881_9933 = G__9950;
i__9882_9934 = G__9951;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_9930);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_9930);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__9952 = cljs.core.next(seq__9847_9919__$1);
var G__9953 = null;
var G__9954 = (0);
var G__9955 = (0);
seq__9847_9883 = G__9952;
chunk__9848_9884 = G__9953;
count__9849_9885 = G__9954;
i__9850_9886 = G__9955;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__9956){
var map__9957 = p__9956;
var map__9957__$1 = (((((!((map__9957 == null))))?(((((map__9957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9957):map__9957);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9957__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9957__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9962 = env;
var G__9963 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9962,G__9963) : cljs.compiler.resolve_type.call(null,G__9962,G__9963));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__9964 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9964,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9964,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__9959_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__9959_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__9959_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__9967 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__9967,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__9967;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__9970 = env;
var G__9971 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__9970,G__9971) : cljs.compiler.resolve_type.call(null,G__9970,G__9971));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9972_SHARP_){
return cljs.compiler.resolve_type(env,p1__9972_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__9973 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9974 = cljs.core.seq(vec__9973);
var first__9975 = cljs.core.first(seq__9974);
var seq__9974__$1 = cljs.core.next(seq__9974);
var p = first__9975;
var first__9975__$1 = cljs.core.first(seq__9974__$1);
var seq__9974__$2 = cljs.core.next(seq__9974__$1);
var ts = first__9975__$1;
var first__9975__$2 = cljs.core.first(seq__9974__$2);
var seq__9974__$3 = cljs.core.next(seq__9974__$2);
var n = first__9975__$2;
var xs = seq__9974__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__9976 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__9977 = cljs.core.seq(vec__9976);
var first__9978 = cljs.core.first(seq__9977);
var seq__9977__$1 = cljs.core.next(seq__9977);
var p = first__9978;
var first__9978__$1 = cljs.core.first(seq__9977__$1);
var seq__9977__$2 = cljs.core.next(seq__9977__$1);
var ts = first__9978__$1;
var xs = seq__9977__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__9980 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__9979 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__9979.cljs$core$IFn$_invoke$arity$1 ? fexpr__9979.cljs$core$IFn$_invoke$arity$1(G__9980) : fexpr__9979.call(null,G__9980));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__9983 = arguments.length;
switch (G__9983) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__9991 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9981_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__9981_SHARP_);
} else {
return p1__9981_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__9992 = cljs.core.seq(vec__9991);
var first__9993 = cljs.core.first(seq__9992);
var seq__9992__$1 = cljs.core.next(seq__9992);
var x = first__9993;
var ys = seq__9992__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__9994 = cljs.core.seq(ys);
var chunk__9995 = null;
var count__9996 = (0);
var i__9997 = (0);
while(true){
if((i__9997 < count__9996)){
var next_line = chunk__9995.cljs$core$IIndexed$_nth$arity$2(null,i__9997);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10003 = seq__9994;
var G__10004 = chunk__9995;
var G__10005 = count__9996;
var G__10006 = (i__9997 + (1));
seq__9994 = G__10003;
chunk__9995 = G__10004;
count__9996 = G__10005;
i__9997 = G__10006;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__9994);
if(temp__5754__auto__){
var seq__9994__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9994__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__9994__$1);
var G__10007 = cljs.core.chunk_rest(seq__9994__$1);
var G__10008 = c__4556__auto__;
var G__10009 = cljs.core.count(c__4556__auto__);
var G__10010 = (0);
seq__9994 = G__10007;
chunk__9995 = G__10008;
count__9996 = G__10009;
i__9997 = G__10010;
continue;
} else {
var next_line = cljs.core.first(seq__9994__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10011 = cljs.core.next(seq__9994__$1);
var G__10012 = null;
var G__10013 = (0);
var G__10014 = (0);
seq__9994 = G__10011;
chunk__9995 = G__10012;
count__9996 = G__10013;
i__9997 = G__10014;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__9998_10015 = cljs.core.seq(docs__$2);
var chunk__9999_10016 = null;
var count__10000_10017 = (0);
var i__10001_10018 = (0);
while(true){
if((i__10001_10018 < count__10000_10017)){
var e_10019 = chunk__9999_10016.cljs$core$IIndexed$_nth$arity$2(null,i__10001_10018);
if(cljs.core.truth_(e_10019)){
print_comment_lines(e_10019);
} else {
}


var G__10020 = seq__9998_10015;
var G__10021 = chunk__9999_10016;
var G__10022 = count__10000_10017;
var G__10023 = (i__10001_10018 + (1));
seq__9998_10015 = G__10020;
chunk__9999_10016 = G__10021;
count__10000_10017 = G__10022;
i__10001_10018 = G__10023;
continue;
} else {
var temp__5754__auto___10024 = cljs.core.seq(seq__9998_10015);
if(temp__5754__auto___10024){
var seq__9998_10025__$1 = temp__5754__auto___10024;
if(cljs.core.chunked_seq_QMARK_(seq__9998_10025__$1)){
var c__4556__auto___10026 = cljs.core.chunk_first(seq__9998_10025__$1);
var G__10027 = cljs.core.chunk_rest(seq__9998_10025__$1);
var G__10028 = c__4556__auto___10026;
var G__10029 = cljs.core.count(c__4556__auto___10026);
var G__10030 = (0);
seq__9998_10015 = G__10027;
chunk__9999_10016 = G__10028;
count__10000_10017 = G__10029;
i__10001_10018 = G__10030;
continue;
} else {
var e_10031 = cljs.core.first(seq__9998_10025__$1);
if(cljs.core.truth_(e_10031)){
print_comment_lines(e_10031);
} else {
}


var G__10032 = cljs.core.next(seq__9998_10025__$1);
var G__10033 = null;
var G__10034 = (0);
var G__10035 = (0);
seq__9998_10015 = G__10032;
chunk__9999_10016 = G__10033;
count__10000_10017 = G__10034;
i__10001_10018 = G__10035;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4115__auto__ = cljs.core.some((function (p1__10037_SHARP_){
return goog.string.startsWith(p1__10037_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none)){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__10038){
var map__10039 = p__10038;
var map__10039__$1 = (((((!((map__10039 == null))))?(((((map__10039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10039):map__10039);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10039__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5752__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5752__auto__)){
var define = temp__5752__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__10041){
var map__10042 = p__10041;
var map__10042__$1 = (((((!((map__10042 == null))))?(((((map__10042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10042.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10042):map__10042);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10042__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10042__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10042__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__10044_10068 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__10045_10069 = null;
var count__10046_10070 = (0);
var i__10047_10071 = (0);
while(true){
if((i__10047_10071 < count__10046_10070)){
var vec__10054_10072 = chunk__10045_10069.cljs$core$IIndexed$_nth$arity$2(null,i__10047_10071);
var i_10073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10054_10072,(0),null);
var param_10074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10054_10072,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10074);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10075 = seq__10044_10068;
var G__10076 = chunk__10045_10069;
var G__10077 = count__10046_10070;
var G__10078 = (i__10047_10071 + (1));
seq__10044_10068 = G__10075;
chunk__10045_10069 = G__10076;
count__10046_10070 = G__10077;
i__10047_10071 = G__10078;
continue;
} else {
var temp__5754__auto___10079 = cljs.core.seq(seq__10044_10068);
if(temp__5754__auto___10079){
var seq__10044_10080__$1 = temp__5754__auto___10079;
if(cljs.core.chunked_seq_QMARK_(seq__10044_10080__$1)){
var c__4556__auto___10081 = cljs.core.chunk_first(seq__10044_10080__$1);
var G__10082 = cljs.core.chunk_rest(seq__10044_10080__$1);
var G__10083 = c__4556__auto___10081;
var G__10084 = cljs.core.count(c__4556__auto___10081);
var G__10085 = (0);
seq__10044_10068 = G__10082;
chunk__10045_10069 = G__10083;
count__10046_10070 = G__10084;
i__10047_10071 = G__10085;
continue;
} else {
var vec__10057_10086 = cljs.core.first(seq__10044_10080__$1);
var i_10087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10057_10086,(0),null);
var param_10088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10057_10086,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10088);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10089 = cljs.core.next(seq__10044_10080__$1);
var G__10090 = null;
var G__10091 = (0);
var G__10092 = (0);
seq__10044_10068 = G__10089;
chunk__10045_10069 = G__10090;
count__10046_10070 = G__10091;
i__10047_10071 = G__10092;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10060_10093 = cljs.core.seq(params);
var chunk__10061_10094 = null;
var count__10062_10095 = (0);
var i__10063_10096 = (0);
while(true){
if((i__10063_10096 < count__10062_10095)){
var param_10097 = chunk__10061_10094.cljs$core$IIndexed$_nth$arity$2(null,i__10063_10096);
cljs.compiler.emit(param_10097);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10097,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10098 = seq__10060_10093;
var G__10099 = chunk__10061_10094;
var G__10100 = count__10062_10095;
var G__10101 = (i__10063_10096 + (1));
seq__10060_10093 = G__10098;
chunk__10061_10094 = G__10099;
count__10062_10095 = G__10100;
i__10063_10096 = G__10101;
continue;
} else {
var temp__5754__auto___10102 = cljs.core.seq(seq__10060_10093);
if(temp__5754__auto___10102){
var seq__10060_10103__$1 = temp__5754__auto___10102;
if(cljs.core.chunked_seq_QMARK_(seq__10060_10103__$1)){
var c__4556__auto___10104 = cljs.core.chunk_first(seq__10060_10103__$1);
var G__10105 = cljs.core.chunk_rest(seq__10060_10103__$1);
var G__10106 = c__4556__auto___10104;
var G__10107 = cljs.core.count(c__4556__auto___10104);
var G__10108 = (0);
seq__10060_10093 = G__10105;
chunk__10061_10094 = G__10106;
count__10062_10095 = G__10107;
i__10063_10096 = G__10108;
continue;
} else {
var param_10109 = cljs.core.first(seq__10060_10103__$1);
cljs.compiler.emit(param_10109);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10109,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10110 = cljs.core.next(seq__10060_10103__$1);
var G__10111 = null;
var G__10112 = (0);
var G__10113 = (0);
seq__10060_10093 = G__10110;
chunk__10061_10094 = G__10111;
count__10062_10095 = G__10112;
i__10063_10096 = G__10113;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10064_10114 = cljs.core.seq(params);
var chunk__10065_10115 = null;
var count__10066_10116 = (0);
var i__10067_10117 = (0);
while(true){
if((i__10067_10117 < count__10066_10116)){
var param_10118 = chunk__10065_10115.cljs$core$IIndexed$_nth$arity$2(null,i__10067_10117);
cljs.compiler.emit(param_10118);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10118,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10119 = seq__10064_10114;
var G__10120 = chunk__10065_10115;
var G__10121 = count__10066_10116;
var G__10122 = (i__10067_10117 + (1));
seq__10064_10114 = G__10119;
chunk__10065_10115 = G__10120;
count__10066_10116 = G__10121;
i__10067_10117 = G__10122;
continue;
} else {
var temp__5754__auto___10123 = cljs.core.seq(seq__10064_10114);
if(temp__5754__auto___10123){
var seq__10064_10124__$1 = temp__5754__auto___10123;
if(cljs.core.chunked_seq_QMARK_(seq__10064_10124__$1)){
var c__4556__auto___10125 = cljs.core.chunk_first(seq__10064_10124__$1);
var G__10126 = cljs.core.chunk_rest(seq__10064_10124__$1);
var G__10127 = c__4556__auto___10125;
var G__10128 = cljs.core.count(c__4556__auto___10125);
var G__10129 = (0);
seq__10064_10114 = G__10126;
chunk__10065_10115 = G__10127;
count__10066_10116 = G__10128;
i__10067_10117 = G__10129;
continue;
} else {
var param_10130 = cljs.core.first(seq__10064_10124__$1);
cljs.compiler.emit(param_10130);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10130,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10131 = cljs.core.next(seq__10064_10124__$1);
var G__10132 = null;
var G__10133 = (0);
var G__10134 = (0);
seq__10064_10114 = G__10131;
chunk__10065_10115 = G__10132;
count__10066_10116 = G__10133;
i__10067_10117 = G__10134;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__10135 = cljs.core.seq(params);
var chunk__10136 = null;
var count__10137 = (0);
var i__10138 = (0);
while(true){
if((i__10138 < count__10137)){
var param = chunk__10136.cljs$core$IIndexed$_nth$arity$2(null,i__10138);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10139 = seq__10135;
var G__10140 = chunk__10136;
var G__10141 = count__10137;
var G__10142 = (i__10138 + (1));
seq__10135 = G__10139;
chunk__10136 = G__10140;
count__10137 = G__10141;
i__10138 = G__10142;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__10135);
if(temp__5754__auto__){
var seq__10135__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10135__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__10135__$1);
var G__10143 = cljs.core.chunk_rest(seq__10135__$1);
var G__10144 = c__4556__auto__;
var G__10145 = cljs.core.count(c__4556__auto__);
var G__10146 = (0);
seq__10135 = G__10143;
chunk__10136 = G__10144;
count__10137 = G__10145;
i__10138 = G__10146;
continue;
} else {
var param = cljs.core.first(seq__10135__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10147 = cljs.core.next(seq__10135__$1);
var G__10148 = null;
var G__10149 = (0);
var G__10150 = (0);
seq__10135 = G__10147;
chunk__10136 = G__10148;
count__10137 = G__10149;
i__10138 = G__10150;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__10151){
var map__10152 = p__10151;
var map__10152__$1 = (((((!((map__10152 == null))))?(((((map__10152.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10152.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10152):map__10152);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10152__$1,cljs.core.cst$kw$recurs);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__10154){
var map__10155 = p__10154;
var map__10155__$1 = (((((!((map__10155 == null))))?(((((map__10155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10155.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10155):map__10155);
var f = map__10155__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10155__$1,cljs.core.cst$kw$recurs);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_10165__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10166 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10165__$1);
var delegate_name_10167 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10166),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_10167," = function (");

var seq__10157_10168 = cljs.core.seq(params);
var chunk__10158_10169 = null;
var count__10159_10170 = (0);
var i__10160_10171 = (0);
while(true){
if((i__10160_10171 < count__10159_10170)){
var param_10172 = chunk__10158_10169.cljs$core$IIndexed$_nth$arity$2(null,i__10160_10171);
cljs.compiler.emit(param_10172);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10172,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10173 = seq__10157_10168;
var G__10174 = chunk__10158_10169;
var G__10175 = count__10159_10170;
var G__10176 = (i__10160_10171 + (1));
seq__10157_10168 = G__10173;
chunk__10158_10169 = G__10174;
count__10159_10170 = G__10175;
i__10160_10171 = G__10176;
continue;
} else {
var temp__5754__auto___10177 = cljs.core.seq(seq__10157_10168);
if(temp__5754__auto___10177){
var seq__10157_10178__$1 = temp__5754__auto___10177;
if(cljs.core.chunked_seq_QMARK_(seq__10157_10178__$1)){
var c__4556__auto___10179 = cljs.core.chunk_first(seq__10157_10178__$1);
var G__10180 = cljs.core.chunk_rest(seq__10157_10178__$1);
var G__10181 = c__4556__auto___10179;
var G__10182 = cljs.core.count(c__4556__auto___10179);
var G__10183 = (0);
seq__10157_10168 = G__10180;
chunk__10158_10169 = G__10181;
count__10159_10170 = G__10182;
i__10160_10171 = G__10183;
continue;
} else {
var param_10184 = cljs.core.first(seq__10157_10178__$1);
cljs.compiler.emit(param_10184);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10184,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10185 = cljs.core.next(seq__10157_10178__$1);
var G__10186 = null;
var G__10187 = (0);
var G__10188 = (0);
seq__10157_10168 = G__10185;
chunk__10158_10169 = G__10186;
count__10159_10170 = G__10187;
i__10160_10171 = G__10188;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_10166," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_10189 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_10189,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_10167,".call(this,");

var seq__10161_10190 = cljs.core.seq(params);
var chunk__10162_10191 = null;
var count__10163_10192 = (0);
var i__10164_10193 = (0);
while(true){
if((i__10164_10193 < count__10163_10192)){
var param_10194 = chunk__10162_10191.cljs$core$IIndexed$_nth$arity$2(null,i__10164_10193);
cljs.compiler.emit(param_10194);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10194,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10195 = seq__10161_10190;
var G__10196 = chunk__10162_10191;
var G__10197 = count__10163_10192;
var G__10198 = (i__10164_10193 + (1));
seq__10161_10190 = G__10195;
chunk__10162_10191 = G__10196;
count__10163_10192 = G__10197;
i__10164_10193 = G__10198;
continue;
} else {
var temp__5754__auto___10199 = cljs.core.seq(seq__10161_10190);
if(temp__5754__auto___10199){
var seq__10161_10200__$1 = temp__5754__auto___10199;
if(cljs.core.chunked_seq_QMARK_(seq__10161_10200__$1)){
var c__4556__auto___10201 = cljs.core.chunk_first(seq__10161_10200__$1);
var G__10202 = cljs.core.chunk_rest(seq__10161_10200__$1);
var G__10203 = c__4556__auto___10201;
var G__10204 = cljs.core.count(c__4556__auto___10201);
var G__10205 = (0);
seq__10161_10190 = G__10202;
chunk__10162_10191 = G__10203;
count__10163_10192 = G__10204;
i__10164_10193 = G__10205;
continue;
} else {
var param_10206 = cljs.core.first(seq__10161_10200__$1);
cljs.compiler.emit(param_10206);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10206,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10207 = cljs.core.next(seq__10161_10200__$1);
var G__10208 = null;
var G__10209 = (0);
var G__10210 = (0);
seq__10161_10190 = G__10207;
chunk__10162_10191 = G__10208;
count__10163_10192 = G__10209;
i__10164_10193 = G__10210;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10166,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_10166,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_10165__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10166,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_10167,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10166,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__10214){
var map__10215 = p__10214;
var map__10215__$1 = (((((!((map__10215 == null))))?(((((map__10215.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10215.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10215):map__10215);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10215__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10211_SHARP_){
var and__4115__auto__ = p1__10211_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__10211_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_10268__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10269 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10268__$1);
var maxparams_10270 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_10271 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10269),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_10272 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__10212_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__10212_SHARP_)));
}),cljs.core.seq(mmap_10271));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_10269," = null;");

var seq__10217_10273 = cljs.core.seq(ms_10272);
var chunk__10218_10274 = null;
var count__10219_10275 = (0);
var i__10220_10276 = (0);
while(true){
if((i__10220_10276 < count__10219_10275)){
var vec__10227_10277 = chunk__10218_10274.cljs$core$IIndexed$_nth$arity$2(null,i__10220_10276);
var n_10278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10227_10277,(0),null);
var meth_10279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10227_10277,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10278," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10279))){
cljs.compiler.emit_variadic_fn_method(meth_10279);
} else {
cljs.compiler.emit_fn_method(meth_10279);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10280 = seq__10217_10273;
var G__10281 = chunk__10218_10274;
var G__10282 = count__10219_10275;
var G__10283 = (i__10220_10276 + (1));
seq__10217_10273 = G__10280;
chunk__10218_10274 = G__10281;
count__10219_10275 = G__10282;
i__10220_10276 = G__10283;
continue;
} else {
var temp__5754__auto___10284 = cljs.core.seq(seq__10217_10273);
if(temp__5754__auto___10284){
var seq__10217_10285__$1 = temp__5754__auto___10284;
if(cljs.core.chunked_seq_QMARK_(seq__10217_10285__$1)){
var c__4556__auto___10286 = cljs.core.chunk_first(seq__10217_10285__$1);
var G__10287 = cljs.core.chunk_rest(seq__10217_10285__$1);
var G__10288 = c__4556__auto___10286;
var G__10289 = cljs.core.count(c__4556__auto___10286);
var G__10290 = (0);
seq__10217_10273 = G__10287;
chunk__10218_10274 = G__10288;
count__10219_10275 = G__10289;
i__10220_10276 = G__10290;
continue;
} else {
var vec__10230_10291 = cljs.core.first(seq__10217_10285__$1);
var n_10292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10230_10291,(0),null);
var meth_10293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10230_10291,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10292," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10293))){
cljs.compiler.emit_variadic_fn_method(meth_10293);
} else {
cljs.compiler.emit_fn_method(meth_10293);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10294 = cljs.core.next(seq__10217_10285__$1);
var G__10295 = null;
var G__10296 = (0);
var G__10297 = (0);
seq__10217_10273 = G__10294;
chunk__10218_10274 = G__10295;
count__10219_10275 = G__10296;
i__10220_10276 = G__10297;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10269," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_10270),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_10270)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_10270));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__10233_10298 = cljs.core.seq(ms_10272);
var chunk__10234_10299 = null;
var count__10235_10300 = (0);
var i__10236_10301 = (0);
while(true){
if((i__10236_10301 < count__10235_10300)){
var vec__10243_10302 = chunk__10234_10299.cljs$core$IIndexed$_nth$arity$2(null,i__10236_10301);
var n_10303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10243_10302,(0),null);
var meth_10304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10243_10302,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10304))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10305 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10305," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10306 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10305," = new cljs.core.IndexedSeq(",a_10306,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10303,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10270)),(((cljs.core.count(maxparams_10270) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10305,");"], 0));
} else {
var pcnt_10307 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10304));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10307,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10303,".call(this",(((pcnt_10307 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10307,maxparams_10270)),null,(1),null)),(2),null))),");");
}


var G__10308 = seq__10233_10298;
var G__10309 = chunk__10234_10299;
var G__10310 = count__10235_10300;
var G__10311 = (i__10236_10301 + (1));
seq__10233_10298 = G__10308;
chunk__10234_10299 = G__10309;
count__10235_10300 = G__10310;
i__10236_10301 = G__10311;
continue;
} else {
var temp__5754__auto___10312 = cljs.core.seq(seq__10233_10298);
if(temp__5754__auto___10312){
var seq__10233_10313__$1 = temp__5754__auto___10312;
if(cljs.core.chunked_seq_QMARK_(seq__10233_10313__$1)){
var c__4556__auto___10314 = cljs.core.chunk_first(seq__10233_10313__$1);
var G__10315 = cljs.core.chunk_rest(seq__10233_10313__$1);
var G__10316 = c__4556__auto___10314;
var G__10317 = cljs.core.count(c__4556__auto___10314);
var G__10318 = (0);
seq__10233_10298 = G__10315;
chunk__10234_10299 = G__10316;
count__10235_10300 = G__10317;
i__10236_10301 = G__10318;
continue;
} else {
var vec__10246_10319 = cljs.core.first(seq__10233_10313__$1);
var n_10320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246_10319,(0),null);
var meth_10321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10246_10319,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10321))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10322 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10322," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10323 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10322," = new cljs.core.IndexedSeq(",a_10323,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10320,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10270)),(((cljs.core.count(maxparams_10270) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10322,");"], 0));
} else {
var pcnt_10324 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10321));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10324,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10320,".call(this",(((pcnt_10324 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10324,maxparams_10270)),null,(1),null)),(2),null))),");");
}


var G__10325 = cljs.core.next(seq__10233_10313__$1);
var G__10326 = null;
var G__10327 = (0);
var G__10328 = (0);
seq__10233_10298 = G__10325;
chunk__10234_10299 = G__10326;
count__10235_10300 = G__10327;
i__10236_10301 = G__10328;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_10329 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_10272)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_10329,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10269,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10269,".cljs$lang$applyTo = ",cljs.core.some((function (p1__10213_SHARP_){
var vec__10249 = p1__10213_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10249,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10249,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_10272),".cljs$lang$applyTo;");
} else {
}

var seq__10252_10330 = cljs.core.seq(ms_10272);
var chunk__10253_10331 = null;
var count__10254_10332 = (0);
var i__10255_10333 = (0);
while(true){
if((i__10255_10333 < count__10254_10332)){
var vec__10262_10334 = chunk__10253_10331.cljs$core$IIndexed$_nth$arity$2(null,i__10255_10333);
var n_10335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10262_10334,(0),null);
var meth_10336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10262_10334,(1),null);
var c_10337 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10336));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10336))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10269,".cljs$core$IFn$_invoke$arity$variadic = ",n_10335,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10269,".cljs$core$IFn$_invoke$arity$",c_10337," = ",n_10335,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10338 = seq__10252_10330;
var G__10339 = chunk__10253_10331;
var G__10340 = count__10254_10332;
var G__10341 = (i__10255_10333 + (1));
seq__10252_10330 = G__10338;
chunk__10253_10331 = G__10339;
count__10254_10332 = G__10340;
i__10255_10333 = G__10341;
continue;
} else {
var temp__5754__auto___10342 = cljs.core.seq(seq__10252_10330);
if(temp__5754__auto___10342){
var seq__10252_10343__$1 = temp__5754__auto___10342;
if(cljs.core.chunked_seq_QMARK_(seq__10252_10343__$1)){
var c__4556__auto___10344 = cljs.core.chunk_first(seq__10252_10343__$1);
var G__10345 = cljs.core.chunk_rest(seq__10252_10343__$1);
var G__10346 = c__4556__auto___10344;
var G__10347 = cljs.core.count(c__4556__auto___10344);
var G__10348 = (0);
seq__10252_10330 = G__10345;
chunk__10253_10331 = G__10346;
count__10254_10332 = G__10347;
i__10255_10333 = G__10348;
continue;
} else {
var vec__10265_10349 = cljs.core.first(seq__10252_10343__$1);
var n_10350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10265_10349,(0),null);
var meth_10351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10265_10349,(1),null);
var c_10352 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10351));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10351))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10269,".cljs$core$IFn$_invoke$arity$variadic = ",n_10350,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10269,".cljs$core$IFn$_invoke$arity$",c_10352," = ",n_10350,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10353 = cljs.core.next(seq__10252_10343__$1);
var G__10354 = null;
var G__10355 = (0);
var G__10356 = (0);
seq__10252_10330 = G__10353;
chunk__10253_10331 = G__10354;
count__10254_10332 = G__10355;
i__10255_10333 = G__10356;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10269,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__10357){
var map__10358 = p__10357;
var map__10358__$1 = (((((!((map__10358 == null))))?(((((map__10358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10358.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10358):map__10358);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10358__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10358__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10358__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10360_10364 = cljs.core.seq(statements);
var chunk__10361_10365 = null;
var count__10362_10366 = (0);
var i__10363_10367 = (0);
while(true){
if((i__10363_10367 < count__10362_10366)){
var s_10368 = chunk__10361_10365.cljs$core$IIndexed$_nth$arity$2(null,i__10363_10367);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10368);


var G__10369 = seq__10360_10364;
var G__10370 = chunk__10361_10365;
var G__10371 = count__10362_10366;
var G__10372 = (i__10363_10367 + (1));
seq__10360_10364 = G__10369;
chunk__10361_10365 = G__10370;
count__10362_10366 = G__10371;
i__10363_10367 = G__10372;
continue;
} else {
var temp__5754__auto___10373 = cljs.core.seq(seq__10360_10364);
if(temp__5754__auto___10373){
var seq__10360_10374__$1 = temp__5754__auto___10373;
if(cljs.core.chunked_seq_QMARK_(seq__10360_10374__$1)){
var c__4556__auto___10375 = cljs.core.chunk_first(seq__10360_10374__$1);
var G__10376 = cljs.core.chunk_rest(seq__10360_10374__$1);
var G__10377 = c__4556__auto___10375;
var G__10378 = cljs.core.count(c__4556__auto___10375);
var G__10379 = (0);
seq__10360_10364 = G__10376;
chunk__10361_10365 = G__10377;
count__10362_10366 = G__10378;
i__10363_10367 = G__10379;
continue;
} else {
var s_10380 = cljs.core.first(seq__10360_10374__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10380);


var G__10381 = cljs.core.next(seq__10360_10374__$1);
var G__10382 = null;
var G__10383 = (0);
var G__10384 = (0);
seq__10360_10364 = G__10381;
chunk__10361_10365 = G__10382;
count__10362_10366 = G__10383;
i__10363_10367 = G__10384;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__10385){
var map__10386 = p__10385;
var map__10386__$1 = (((((!((map__10386 == null))))?(((((map__10386.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10386.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10386):map__10386);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10386__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10386__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10386__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10386__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10386__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__10388,is_loop){
var map__10389 = p__10388;
var map__10389__$1 = (((((!((map__10389 == null))))?(((((map__10389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10389):map__10389);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10389__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10389__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10389__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__10391_10405 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__10392_10406 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__10392_10406);

try{var seq__10393_10407 = cljs.core.seq(bindings);
var chunk__10394_10408 = null;
var count__10395_10409 = (0);
var i__10396_10410 = (0);
while(true){
if((i__10396_10410 < count__10395_10409)){
var map__10401_10411 = chunk__10394_10408.cljs$core$IIndexed$_nth$arity$2(null,i__10396_10410);
var map__10401_10412__$1 = (((((!((map__10401_10411 == null))))?(((((map__10401_10411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10401_10411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10401_10411):map__10401_10411);
var binding_10413 = map__10401_10412__$1;
var init_10414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10401_10412__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10413);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10414,";");


var G__10415 = seq__10393_10407;
var G__10416 = chunk__10394_10408;
var G__10417 = count__10395_10409;
var G__10418 = (i__10396_10410 + (1));
seq__10393_10407 = G__10415;
chunk__10394_10408 = G__10416;
count__10395_10409 = G__10417;
i__10396_10410 = G__10418;
continue;
} else {
var temp__5754__auto___10419 = cljs.core.seq(seq__10393_10407);
if(temp__5754__auto___10419){
var seq__10393_10420__$1 = temp__5754__auto___10419;
if(cljs.core.chunked_seq_QMARK_(seq__10393_10420__$1)){
var c__4556__auto___10421 = cljs.core.chunk_first(seq__10393_10420__$1);
var G__10422 = cljs.core.chunk_rest(seq__10393_10420__$1);
var G__10423 = c__4556__auto___10421;
var G__10424 = cljs.core.count(c__4556__auto___10421);
var G__10425 = (0);
seq__10393_10407 = G__10422;
chunk__10394_10408 = G__10423;
count__10395_10409 = G__10424;
i__10396_10410 = G__10425;
continue;
} else {
var map__10403_10426 = cljs.core.first(seq__10393_10420__$1);
var map__10403_10427__$1 = (((((!((map__10403_10426 == null))))?(((((map__10403_10426.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10403_10426.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10403_10426):map__10403_10426);
var binding_10428 = map__10403_10427__$1;
var init_10429 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10403_10427__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10428);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10429,";");


var G__10430 = cljs.core.next(seq__10393_10420__$1);
var G__10431 = null;
var G__10432 = (0);
var G__10433 = (0);
seq__10393_10407 = G__10430;
chunk__10394_10408 = G__10431;
count__10395_10409 = G__10432;
i__10396_10410 = G__10433;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__10391_10405);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__10434){
var map__10435 = p__10434;
var map__10435__$1 = (((((!((map__10435 == null))))?(((((map__10435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10435):map__10435);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10435__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10435__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10435__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___10437 = cljs.core.count(exprs);
var i_10438 = (0);
while(true){
if((i_10438 < n__4613__auto___10437)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10438) : temps.call(null,i_10438))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_10438) : exprs.call(null,i_10438)),";");

var G__10439 = (i_10438 + (1));
i_10438 = G__10439;
continue;
} else {
}
break;
}

var n__4613__auto___10440 = cljs.core.count(exprs);
var i_10441 = (0);
while(true){
if((i_10441 < n__4613__auto___10440)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_10441) : params.call(null,i_10441)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10441) : temps.call(null,i_10441)),";");

var G__10442 = (i_10441 + (1));
i_10441 = G__10442;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__10443){
var map__10444 = p__10443;
var map__10444__$1 = (((((!((map__10444 == null))))?(((((map__10444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10444):map__10444);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10444__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10444__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10444__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10446_10458 = cljs.core.seq(bindings);
var chunk__10447_10459 = null;
var count__10448_10460 = (0);
var i__10449_10461 = (0);
while(true){
if((i__10449_10461 < count__10448_10460)){
var map__10454_10462 = chunk__10447_10459.cljs$core$IIndexed$_nth$arity$2(null,i__10449_10461);
var map__10454_10463__$1 = (((((!((map__10454_10462 == null))))?(((((map__10454_10462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10454_10462.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10454_10462):map__10454_10462);
var binding_10464 = map__10454_10463__$1;
var init_10465 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10454_10463__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10464)," = ",init_10465,";");


var G__10466 = seq__10446_10458;
var G__10467 = chunk__10447_10459;
var G__10468 = count__10448_10460;
var G__10469 = (i__10449_10461 + (1));
seq__10446_10458 = G__10466;
chunk__10447_10459 = G__10467;
count__10448_10460 = G__10468;
i__10449_10461 = G__10469;
continue;
} else {
var temp__5754__auto___10470 = cljs.core.seq(seq__10446_10458);
if(temp__5754__auto___10470){
var seq__10446_10471__$1 = temp__5754__auto___10470;
if(cljs.core.chunked_seq_QMARK_(seq__10446_10471__$1)){
var c__4556__auto___10472 = cljs.core.chunk_first(seq__10446_10471__$1);
var G__10473 = cljs.core.chunk_rest(seq__10446_10471__$1);
var G__10474 = c__4556__auto___10472;
var G__10475 = cljs.core.count(c__4556__auto___10472);
var G__10476 = (0);
seq__10446_10458 = G__10473;
chunk__10447_10459 = G__10474;
count__10448_10460 = G__10475;
i__10449_10461 = G__10476;
continue;
} else {
var map__10456_10477 = cljs.core.first(seq__10446_10471__$1);
var map__10456_10478__$1 = (((((!((map__10456_10477 == null))))?(((((map__10456_10477.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10456_10477.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10456_10477):map__10456_10477);
var binding_10479 = map__10456_10478__$1;
var init_10480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10456_10478__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10479)," = ",init_10480,";");


var G__10481 = cljs.core.next(seq__10446_10471__$1);
var G__10482 = null;
var G__10483 = (0);
var G__10484 = (0);
seq__10446_10458 = G__10481;
chunk__10447_10459 = G__10482;
count__10448_10460 = G__10483;
i__10449_10461 = G__10484;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__10487){
var map__10488 = p__10487;
var map__10488__$1 = (((((!((map__10488 == null))))?(((((map__10488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10488.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10488):map__10488);
var expr = map__10488__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10488__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10488__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10488__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info))){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__10500 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__10500.cljs$core$IFn$_invoke$arity$1 ? fexpr__10500.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10500.call(null,tag));
})())){
var temp__5754__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5754__auto__)){
var ps = temp__5754__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__10502 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__10502.cljs$core$IFn$_invoke$arity$1 ? fexpr__10502.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__10502.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5754__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5754__auto__)){
var ns_str = temp__5754__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__10490 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10485_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10485_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10486_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10486_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490,(1),null);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_10505 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_10505,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_10506 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_10506,args)),(((mfa_10506 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_10506,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
var G__10504 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__10503 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__10503.cljs$core$IFn$_invoke$arity$1 ? fexpr__10503.cljs$core$IFn$_invoke$arity$1(G__10504) : fexpr__10503.call(null,G__10504));
} else {
return and__4115__auto__;
}
})())){
var fprop_10507 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10507," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10507,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10507," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10507,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__10508){
var map__10509 = p__10508;
var map__10509__$1 = (((((!((map__10509 == null))))?(((((map__10509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10509):map__10509);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10509__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10509__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10509__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__10511){
var map__10512 = p__10511;
var map__10512__$1 = (((((!((map__10512 == null))))?(((((map__10512.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10512.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10512):map__10512);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10512__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__10514 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10514__$1 = (((((!((map__10514 == null))))?(((((map__10514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10514):map__10514);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10514__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10514__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__10515 = options;
var map__10515__$1 = (((((!((map__10515 == null))))?(((((map__10515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10515.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10515):map__10515);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10515__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10515__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10515__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__10516 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__10521 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__10521__$1 = (((((!((map__10521 == null))))?(((((map__10521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10521):map__10521);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10521__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10521__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10516,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10516,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__10523_10543 = cljs.core.seq(libs_to_load);
var chunk__10524_10544 = null;
var count__10525_10545 = (0);
var i__10526_10546 = (0);
while(true){
if((i__10526_10546 < count__10525_10545)){
var lib_10547 = chunk__10524_10544.cljs$core$IIndexed$_nth$arity$2(null,i__10526_10546);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10547)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10547),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10547),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10547),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10547),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10547,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10547),"');");
}

}
}
}


var G__10548 = seq__10523_10543;
var G__10549 = chunk__10524_10544;
var G__10550 = count__10525_10545;
var G__10551 = (i__10526_10546 + (1));
seq__10523_10543 = G__10548;
chunk__10524_10544 = G__10549;
count__10525_10545 = G__10550;
i__10526_10546 = G__10551;
continue;
} else {
var temp__5754__auto___10552 = cljs.core.seq(seq__10523_10543);
if(temp__5754__auto___10552){
var seq__10523_10553__$1 = temp__5754__auto___10552;
if(cljs.core.chunked_seq_QMARK_(seq__10523_10553__$1)){
var c__4556__auto___10554 = cljs.core.chunk_first(seq__10523_10553__$1);
var G__10555 = cljs.core.chunk_rest(seq__10523_10553__$1);
var G__10556 = c__4556__auto___10554;
var G__10557 = cljs.core.count(c__4556__auto___10554);
var G__10558 = (0);
seq__10523_10543 = G__10555;
chunk__10524_10544 = G__10556;
count__10525_10545 = G__10557;
i__10526_10546 = G__10558;
continue;
} else {
var lib_10559 = cljs.core.first(seq__10523_10553__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10559)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10559),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10559),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10559),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10559),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10559,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10559),"');");
}

}
}
}


var G__10560 = cljs.core.next(seq__10523_10553__$1);
var G__10561 = null;
var G__10562 = (0);
var G__10563 = (0);
seq__10523_10543 = G__10560;
chunk__10524_10544 = G__10561;
count__10525_10545 = G__10562;
i__10526_10546 = G__10563;
continue;
}
} else {
}
}
break;
}

var seq__10527_10564 = cljs.core.seq(node_libs);
var chunk__10528_10565 = null;
var count__10529_10566 = (0);
var i__10530_10567 = (0);
while(true){
if((i__10530_10567 < count__10529_10566)){
var lib_10568 = chunk__10528_10565.cljs$core$IIndexed$_nth$arity$2(null,i__10530_10567);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10568)," = require('",lib_10568,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__10569 = seq__10527_10564;
var G__10570 = chunk__10528_10565;
var G__10571 = count__10529_10566;
var G__10572 = (i__10530_10567 + (1));
seq__10527_10564 = G__10569;
chunk__10528_10565 = G__10570;
count__10529_10566 = G__10571;
i__10530_10567 = G__10572;
continue;
} else {
var temp__5754__auto___10573 = cljs.core.seq(seq__10527_10564);
if(temp__5754__auto___10573){
var seq__10527_10574__$1 = temp__5754__auto___10573;
if(cljs.core.chunked_seq_QMARK_(seq__10527_10574__$1)){
var c__4556__auto___10575 = cljs.core.chunk_first(seq__10527_10574__$1);
var G__10576 = cljs.core.chunk_rest(seq__10527_10574__$1);
var G__10577 = c__4556__auto___10575;
var G__10578 = cljs.core.count(c__4556__auto___10575);
var G__10579 = (0);
seq__10527_10564 = G__10576;
chunk__10528_10565 = G__10577;
count__10529_10566 = G__10578;
i__10530_10567 = G__10579;
continue;
} else {
var lib_10580 = cljs.core.first(seq__10527_10574__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10580)," = require('",lib_10580,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__10581 = cljs.core.next(seq__10527_10574__$1);
var G__10582 = null;
var G__10583 = (0);
var G__10584 = (0);
seq__10527_10564 = G__10581;
chunk__10528_10565 = G__10582;
count__10529_10566 = G__10583;
i__10530_10567 = G__10584;
continue;
}
} else {
}
}
break;
}

var seq__10531_10585 = cljs.core.seq(global_exports_libs);
var chunk__10532_10586 = null;
var count__10533_10587 = (0);
var i__10534_10588 = (0);
while(true){
if((i__10534_10588 < count__10533_10587)){
var lib_10589 = chunk__10532_10586.cljs$core$IIndexed$_nth$arity$2(null,i__10534_10588);
var map__10539_10590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_10589));
var map__10539_10591__$1 = (((((!((map__10539_10590 == null))))?(((((map__10539_10590.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10539_10590.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10539_10590):map__10539_10590);
var global_exports_10592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10539_10591__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10592,lib_10589);


var G__10593 = seq__10531_10585;
var G__10594 = chunk__10532_10586;
var G__10595 = count__10533_10587;
var G__10596 = (i__10534_10588 + (1));
seq__10531_10585 = G__10593;
chunk__10532_10586 = G__10594;
count__10533_10587 = G__10595;
i__10534_10588 = G__10596;
continue;
} else {
var temp__5754__auto___10597 = cljs.core.seq(seq__10531_10585);
if(temp__5754__auto___10597){
var seq__10531_10598__$1 = temp__5754__auto___10597;
if(cljs.core.chunked_seq_QMARK_(seq__10531_10598__$1)){
var c__4556__auto___10599 = cljs.core.chunk_first(seq__10531_10598__$1);
var G__10600 = cljs.core.chunk_rest(seq__10531_10598__$1);
var G__10601 = c__4556__auto___10599;
var G__10602 = cljs.core.count(c__4556__auto___10599);
var G__10603 = (0);
seq__10531_10585 = G__10600;
chunk__10532_10586 = G__10601;
count__10533_10587 = G__10602;
i__10534_10588 = G__10603;
continue;
} else {
var lib_10604 = cljs.core.first(seq__10531_10598__$1);
var map__10541_10605 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_10604));
var map__10541_10606__$1 = (((((!((map__10541_10605 == null))))?(((((map__10541_10605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10541_10605.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10541_10605):map__10541_10605);
var global_exports_10607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10541_10606__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10607,lib_10604);


var G__10608 = cljs.core.next(seq__10531_10598__$1);
var G__10609 = null;
var G__10610 = (0);
var G__10611 = (0);
seq__10531_10585 = G__10608;
chunk__10532_10586 = G__10609;
count__10533_10587 = G__10610;
i__10534_10588 = G__10611;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__10612){
var map__10613 = p__10612;
var map__10613__$1 = (((((!((map__10613 == null))))?(((((map__10613.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10613.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10613):map__10613);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10613__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__10615){
var map__10616 = p__10615;
var map__10616__$1 = (((((!((map__10616 == null))))?(((((map__10616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10616.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10616):map__10616);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10616__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__10618){
var map__10619 = p__10618;
var map__10619__$1 = (((((!((map__10619 == null))))?(((((map__10619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10619):map__10619);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10619__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10619__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10619__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10619__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10619__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10621_10645 = cljs.core.seq(protocols);
var chunk__10622_10646 = null;
var count__10623_10647 = (0);
var i__10624_10648 = (0);
while(true){
if((i__10624_10648 < count__10623_10647)){
var protocol_10649 = chunk__10622_10646.cljs$core$IIndexed$_nth$arity$2(null,i__10624_10648);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10649)),"}");


var G__10650 = seq__10621_10645;
var G__10651 = chunk__10622_10646;
var G__10652 = count__10623_10647;
var G__10653 = (i__10624_10648 + (1));
seq__10621_10645 = G__10650;
chunk__10622_10646 = G__10651;
count__10623_10647 = G__10652;
i__10624_10648 = G__10653;
continue;
} else {
var temp__5754__auto___10654 = cljs.core.seq(seq__10621_10645);
if(temp__5754__auto___10654){
var seq__10621_10655__$1 = temp__5754__auto___10654;
if(cljs.core.chunked_seq_QMARK_(seq__10621_10655__$1)){
var c__4556__auto___10656 = cljs.core.chunk_first(seq__10621_10655__$1);
var G__10657 = cljs.core.chunk_rest(seq__10621_10655__$1);
var G__10658 = c__4556__auto___10656;
var G__10659 = cljs.core.count(c__4556__auto___10656);
var G__10660 = (0);
seq__10621_10645 = G__10657;
chunk__10622_10646 = G__10658;
count__10623_10647 = G__10659;
i__10624_10648 = G__10660;
continue;
} else {
var protocol_10661 = cljs.core.first(seq__10621_10655__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10661)),"}");


var G__10662 = cljs.core.next(seq__10621_10655__$1);
var G__10663 = null;
var G__10664 = (0);
var G__10665 = (0);
seq__10621_10645 = G__10662;
chunk__10622_10646 = G__10663;
count__10623_10647 = G__10664;
i__10624_10648 = G__10665;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10625_10666 = cljs.core.seq(fields__$1);
var chunk__10626_10667 = null;
var count__10627_10668 = (0);
var i__10628_10669 = (0);
while(true){
if((i__10628_10669 < count__10627_10668)){
var fld_10670 = chunk__10626_10667.cljs$core$IIndexed$_nth$arity$2(null,i__10628_10669);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10670," = ",fld_10670,";");


var G__10671 = seq__10625_10666;
var G__10672 = chunk__10626_10667;
var G__10673 = count__10627_10668;
var G__10674 = (i__10628_10669 + (1));
seq__10625_10666 = G__10671;
chunk__10626_10667 = G__10672;
count__10627_10668 = G__10673;
i__10628_10669 = G__10674;
continue;
} else {
var temp__5754__auto___10675 = cljs.core.seq(seq__10625_10666);
if(temp__5754__auto___10675){
var seq__10625_10676__$1 = temp__5754__auto___10675;
if(cljs.core.chunked_seq_QMARK_(seq__10625_10676__$1)){
var c__4556__auto___10677 = cljs.core.chunk_first(seq__10625_10676__$1);
var G__10678 = cljs.core.chunk_rest(seq__10625_10676__$1);
var G__10679 = c__4556__auto___10677;
var G__10680 = cljs.core.count(c__4556__auto___10677);
var G__10681 = (0);
seq__10625_10666 = G__10678;
chunk__10626_10667 = G__10679;
count__10627_10668 = G__10680;
i__10628_10669 = G__10681;
continue;
} else {
var fld_10682 = cljs.core.first(seq__10625_10676__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10682," = ",fld_10682,";");


var G__10683 = cljs.core.next(seq__10625_10676__$1);
var G__10684 = null;
var G__10685 = (0);
var G__10686 = (0);
seq__10625_10666 = G__10683;
chunk__10626_10667 = G__10684;
count__10627_10668 = G__10685;
i__10628_10669 = G__10686;
continue;
}
} else {
}
}
break;
}

var seq__10629_10687 = cljs.core.seq(pmasks);
var chunk__10630_10688 = null;
var count__10631_10689 = (0);
var i__10632_10690 = (0);
while(true){
if((i__10632_10690 < count__10631_10689)){
var vec__10639_10691 = chunk__10630_10688.cljs$core$IIndexed$_nth$arity$2(null,i__10632_10690);
var pno_10692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10639_10691,(0),null);
var pmask_10693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10639_10691,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10692,"$ = ",pmask_10693,";");


var G__10694 = seq__10629_10687;
var G__10695 = chunk__10630_10688;
var G__10696 = count__10631_10689;
var G__10697 = (i__10632_10690 + (1));
seq__10629_10687 = G__10694;
chunk__10630_10688 = G__10695;
count__10631_10689 = G__10696;
i__10632_10690 = G__10697;
continue;
} else {
var temp__5754__auto___10698 = cljs.core.seq(seq__10629_10687);
if(temp__5754__auto___10698){
var seq__10629_10699__$1 = temp__5754__auto___10698;
if(cljs.core.chunked_seq_QMARK_(seq__10629_10699__$1)){
var c__4556__auto___10700 = cljs.core.chunk_first(seq__10629_10699__$1);
var G__10701 = cljs.core.chunk_rest(seq__10629_10699__$1);
var G__10702 = c__4556__auto___10700;
var G__10703 = cljs.core.count(c__4556__auto___10700);
var G__10704 = (0);
seq__10629_10687 = G__10701;
chunk__10630_10688 = G__10702;
count__10631_10689 = G__10703;
i__10632_10690 = G__10704;
continue;
} else {
var vec__10642_10705 = cljs.core.first(seq__10629_10699__$1);
var pno_10706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10642_10705,(0),null);
var pmask_10707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10642_10705,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10706,"$ = ",pmask_10707,";");


var G__10708 = cljs.core.next(seq__10629_10699__$1);
var G__10709 = null;
var G__10710 = (0);
var G__10711 = (0);
seq__10629_10687 = G__10708;
chunk__10630_10688 = G__10709;
count__10631_10689 = G__10710;
i__10632_10690 = G__10711;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__10712){
var map__10713 = p__10712;
var map__10713__$1 = (((((!((map__10713 == null))))?(((((map__10713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10713):map__10713);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10713__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10713__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10713__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10713__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10713__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10715_10739 = cljs.core.seq(protocols);
var chunk__10716_10740 = null;
var count__10717_10741 = (0);
var i__10718_10742 = (0);
while(true){
if((i__10718_10742 < count__10717_10741)){
var protocol_10743 = chunk__10716_10740.cljs$core$IIndexed$_nth$arity$2(null,i__10718_10742);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10743)),"}");


var G__10744 = seq__10715_10739;
var G__10745 = chunk__10716_10740;
var G__10746 = count__10717_10741;
var G__10747 = (i__10718_10742 + (1));
seq__10715_10739 = G__10744;
chunk__10716_10740 = G__10745;
count__10717_10741 = G__10746;
i__10718_10742 = G__10747;
continue;
} else {
var temp__5754__auto___10748 = cljs.core.seq(seq__10715_10739);
if(temp__5754__auto___10748){
var seq__10715_10749__$1 = temp__5754__auto___10748;
if(cljs.core.chunked_seq_QMARK_(seq__10715_10749__$1)){
var c__4556__auto___10750 = cljs.core.chunk_first(seq__10715_10749__$1);
var G__10751 = cljs.core.chunk_rest(seq__10715_10749__$1);
var G__10752 = c__4556__auto___10750;
var G__10753 = cljs.core.count(c__4556__auto___10750);
var G__10754 = (0);
seq__10715_10739 = G__10751;
chunk__10716_10740 = G__10752;
count__10717_10741 = G__10753;
i__10718_10742 = G__10754;
continue;
} else {
var protocol_10755 = cljs.core.first(seq__10715_10749__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10755)),"}");


var G__10756 = cljs.core.next(seq__10715_10749__$1);
var G__10757 = null;
var G__10758 = (0);
var G__10759 = (0);
seq__10715_10739 = G__10756;
chunk__10716_10740 = G__10757;
count__10717_10741 = G__10758;
i__10718_10742 = G__10759;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10719_10760 = cljs.core.seq(fields__$1);
var chunk__10720_10761 = null;
var count__10721_10762 = (0);
var i__10722_10763 = (0);
while(true){
if((i__10722_10763 < count__10721_10762)){
var fld_10764 = chunk__10720_10761.cljs$core$IIndexed$_nth$arity$2(null,i__10722_10763);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10764," = ",fld_10764,";");


var G__10765 = seq__10719_10760;
var G__10766 = chunk__10720_10761;
var G__10767 = count__10721_10762;
var G__10768 = (i__10722_10763 + (1));
seq__10719_10760 = G__10765;
chunk__10720_10761 = G__10766;
count__10721_10762 = G__10767;
i__10722_10763 = G__10768;
continue;
} else {
var temp__5754__auto___10769 = cljs.core.seq(seq__10719_10760);
if(temp__5754__auto___10769){
var seq__10719_10770__$1 = temp__5754__auto___10769;
if(cljs.core.chunked_seq_QMARK_(seq__10719_10770__$1)){
var c__4556__auto___10771 = cljs.core.chunk_first(seq__10719_10770__$1);
var G__10772 = cljs.core.chunk_rest(seq__10719_10770__$1);
var G__10773 = c__4556__auto___10771;
var G__10774 = cljs.core.count(c__4556__auto___10771);
var G__10775 = (0);
seq__10719_10760 = G__10772;
chunk__10720_10761 = G__10773;
count__10721_10762 = G__10774;
i__10722_10763 = G__10775;
continue;
} else {
var fld_10776 = cljs.core.first(seq__10719_10770__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10776," = ",fld_10776,";");


var G__10777 = cljs.core.next(seq__10719_10770__$1);
var G__10778 = null;
var G__10779 = (0);
var G__10780 = (0);
seq__10719_10760 = G__10777;
chunk__10720_10761 = G__10778;
count__10721_10762 = G__10779;
i__10722_10763 = G__10780;
continue;
}
} else {
}
}
break;
}

var seq__10723_10781 = cljs.core.seq(pmasks);
var chunk__10724_10782 = null;
var count__10725_10783 = (0);
var i__10726_10784 = (0);
while(true){
if((i__10726_10784 < count__10725_10783)){
var vec__10733_10785 = chunk__10724_10782.cljs$core$IIndexed$_nth$arity$2(null,i__10726_10784);
var pno_10786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10733_10785,(0),null);
var pmask_10787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10733_10785,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10786,"$ = ",pmask_10787,";");


var G__10788 = seq__10723_10781;
var G__10789 = chunk__10724_10782;
var G__10790 = count__10725_10783;
var G__10791 = (i__10726_10784 + (1));
seq__10723_10781 = G__10788;
chunk__10724_10782 = G__10789;
count__10725_10783 = G__10790;
i__10726_10784 = G__10791;
continue;
} else {
var temp__5754__auto___10792 = cljs.core.seq(seq__10723_10781);
if(temp__5754__auto___10792){
var seq__10723_10793__$1 = temp__5754__auto___10792;
if(cljs.core.chunked_seq_QMARK_(seq__10723_10793__$1)){
var c__4556__auto___10794 = cljs.core.chunk_first(seq__10723_10793__$1);
var G__10795 = cljs.core.chunk_rest(seq__10723_10793__$1);
var G__10796 = c__4556__auto___10794;
var G__10797 = cljs.core.count(c__4556__auto___10794);
var G__10798 = (0);
seq__10723_10781 = G__10795;
chunk__10724_10782 = G__10796;
count__10725_10783 = G__10797;
i__10726_10784 = G__10798;
continue;
} else {
var vec__10736_10799 = cljs.core.first(seq__10723_10793__$1);
var pno_10800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10736_10799,(0),null);
var pmask_10801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10736_10799,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10800,"$ = ",pmask_10801,";");


var G__10802 = cljs.core.next(seq__10723_10793__$1);
var G__10803 = null;
var G__10804 = (0);
var G__10805 = (0);
seq__10723_10781 = G__10802;
chunk__10724_10782 = G__10803;
count__10725_10783 = G__10804;
i__10726_10784 = G__10805;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__10806){
var map__10807 = p__10806;
var map__10807__$1 = (((((!((map__10807 == null))))?(((((map__10807.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10807.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10807):map__10807);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10807__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10807__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10807__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10807__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10807__$1,cljs.core.cst$kw$env);
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__10809){
var map__10810 = p__10809;
var map__10810__$1 = (((((!((map__10810 == null))))?(((((map__10810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10810.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10810):map__10810);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10810__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10810__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10810__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10810__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10810__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9554__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9554__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__10816 = cljs.core.seq(table);
var chunk__10817 = null;
var count__10818 = (0);
var i__10819 = (0);
while(true){
if((i__10819 < count__10818)){
var vec__10826 = chunk__10817.cljs$core$IIndexed$_nth$arity$2(null,i__10819);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10826,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10826,(1),null);
var ns_10832 = cljs.core.namespace(sym);
var name_10833 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10834 = seq__10816;
var G__10835 = chunk__10817;
var G__10836 = count__10818;
var G__10837 = (i__10819 + (1));
seq__10816 = G__10834;
chunk__10817 = G__10835;
count__10818 = G__10836;
i__10819 = G__10837;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__10816);
if(temp__5754__auto__){
var seq__10816__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10816__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__10816__$1);
var G__10838 = cljs.core.chunk_rest(seq__10816__$1);
var G__10839 = c__4556__auto__;
var G__10840 = cljs.core.count(c__4556__auto__);
var G__10841 = (0);
seq__10816 = G__10838;
chunk__10817 = G__10839;
count__10818 = G__10840;
i__10819 = G__10841;
continue;
} else {
var vec__10829 = cljs.core.first(seq__10816__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10829,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10829,(1),null);
var ns_10842 = cljs.core.namespace(sym);
var name_10843 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__10844 = cljs.core.next(seq__10816__$1);
var G__10845 = null;
var G__10846 = (0);
var G__10847 = (0);
seq__10816 = G__10844;
chunk__10817 = G__10845;
count__10818 = G__10846;
i__10819 = G__10847;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__10849 = arguments.length;
switch (G__10849) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_10854 = cljs.core.first(ks);
var vec__10850_10855 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_10854);
var top_10856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10850_10855,(0),null);
var prefix_SINGLEQUOTE__10857 = vec__10850_10855;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_10854)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__10857) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_10856)) || (cljs.core.contains_QMARK_(known_externs,top_10856)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10857)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_10856);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__10857)),";");
}
} else {
}

var m_10858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_10854);
if(cljs.core.empty_QMARK_(m_10858)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__10857,m_10858,top_level,known_externs);
}

var G__10859 = cljs.core.next(ks);
ks = G__10859;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

