// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__17267 = arguments.length;
switch (G__17267) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17268 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17268 = (function (f,blockable,meta17269){
this.f = f;
this.blockable = blockable;
this.meta17269 = meta17269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17270,meta17269__$1){
var self__ = this;
var _17270__$1 = this;
return (new cljs.core.async.t_cljs$core$async17268(self__.f,self__.blockable,meta17269__$1));
}));

(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17270){
var self__ = this;
var _17270__$1 = this;
return self__.meta17269;
}));

(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async17268.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async17268.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17269], null);
}));

(cljs.core.async.t_cljs$core$async17268.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17268");

(cljs.core.async.t_cljs$core$async17268.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17268");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17268.
 */
cljs.core.async.__GT_t_cljs$core$async17268 = (function cljs$core$async$__GT_t_cljs$core$async17268(f__$1,blockable__$1,meta17269){
return (new cljs.core.async.t_cljs$core$async17268(f__$1,blockable__$1,meta17269));
});

}

return (new cljs.core.async.t_cljs$core$async17268(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17274 = arguments.length;
switch (G__17274) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17277 = arguments.length;
switch (G__17277) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17280 = arguments.length;
switch (G__17280) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17282 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17282) : fn1.call(null,val_17282));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17282) : fn1.call(null,val_17282));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17284 = arguments.length;
switch (G__17284) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5752__auto__)){
var ret = temp__5752__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5752__auto__)){
var retb = temp__5752__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___17286 = n;
var x_17287 = (0);
while(true){
if((x_17287 < n__4613__auto___17286)){
(a[x_17287] = x_17287);

var G__17288 = (x_17287 + (1));
x_17287 = G__17288;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17289 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17289 = (function (flag,meta17290){
this.flag = flag;
this.meta17290 = meta17290;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17291,meta17290__$1){
var self__ = this;
var _17291__$1 = this;
return (new cljs.core.async.t_cljs$core$async17289(self__.flag,meta17290__$1));
}));

(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17291){
var self__ = this;
var _17291__$1 = this;
return self__.meta17290;
}));

(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17289.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async17289.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta17290], null);
}));

(cljs.core.async.t_cljs$core$async17289.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17289.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17289");

(cljs.core.async.t_cljs$core$async17289.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17289");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17289.
 */
cljs.core.async.__GT_t_cljs$core$async17289 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17289(flag__$1,meta17290){
return (new cljs.core.async.t_cljs$core$async17289(flag__$1,meta17290));
});

}

return (new cljs.core.async.t_cljs$core$async17289(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17292 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17292 = (function (flag,cb,meta17293){
this.flag = flag;
this.cb = cb;
this.meta17293 = meta17293;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17294,meta17293__$1){
var self__ = this;
var _17294__$1 = this;
return (new cljs.core.async.t_cljs$core$async17292(self__.flag,self__.cb,meta17293__$1));
}));

(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17294){
var self__ = this;
var _17294__$1 = this;
return self__.meta17293;
}));

(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17292.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async17292.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta17293], null);
}));

(cljs.core.async.t_cljs$core$async17292.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17292.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17292");

(cljs.core.async.t_cljs$core$async17292.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17292");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17292.
 */
cljs.core.async.__GT_t_cljs$core$async17292 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17292(flag__$1,cb__$1,meta17293){
return (new cljs.core.async.t_cljs$core$async17292(flag__$1,cb__$1,meta17293));
});

}

return (new cljs.core.async.t_cljs$core$async17292(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17295_SHARP_){
var G__17297 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17295_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17297) : fret.call(null,G__17297));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17296_SHARP_){
var G__17298 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17296_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17298) : fret.call(null,G__17298));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17299 = (i + (1));
i = G__17299;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5754__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5754__auto__)){
var got = temp__5754__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___17305 = arguments.length;
var i__4737__auto___17306 = (0);
while(true){
if((i__4737__auto___17306 < len__4736__auto___17305)){
args__4742__auto__.push((arguments[i__4737__auto___17306]));

var G__17307 = (i__4737__auto___17306 + (1));
i__4737__auto___17306 = G__17307;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17302){
var map__17303 = p__17302;
var map__17303__$1 = (((((!((map__17303 == null))))?(((((map__17303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17303):map__17303);
var opts = map__17303__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17300){
var G__17301 = cljs.core.first(seq17300);
var seq17300__$1 = cljs.core.next(seq17300);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17301,seq17300__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17309 = arguments.length;
switch (G__17309) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17207__auto___17356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17333){
var state_val_17334 = (state_17333[(1)]);
if((state_val_17334 === (7))){
var inst_17329 = (state_17333[(2)]);
var state_17333__$1 = state_17333;
var statearr_17335_17357 = state_17333__$1;
(statearr_17335_17357[(2)] = inst_17329);

(statearr_17335_17357[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (1))){
var state_17333__$1 = state_17333;
var statearr_17336_17358 = state_17333__$1;
(statearr_17336_17358[(2)] = null);

(statearr_17336_17358[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (4))){
var inst_17312 = (state_17333[(7)]);
var inst_17312__$1 = (state_17333[(2)]);
var inst_17313 = (inst_17312__$1 == null);
var state_17333__$1 = (function (){var statearr_17337 = state_17333;
(statearr_17337[(7)] = inst_17312__$1);

return statearr_17337;
})();
if(cljs.core.truth_(inst_17313)){
var statearr_17338_17359 = state_17333__$1;
(statearr_17338_17359[(1)] = (5));

} else {
var statearr_17339_17360 = state_17333__$1;
(statearr_17339_17360[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (13))){
var state_17333__$1 = state_17333;
var statearr_17340_17361 = state_17333__$1;
(statearr_17340_17361[(2)] = null);

(statearr_17340_17361[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (6))){
var inst_17312 = (state_17333[(7)]);
var state_17333__$1 = state_17333;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17333__$1,(11),to,inst_17312);
} else {
if((state_val_17334 === (3))){
var inst_17331 = (state_17333[(2)]);
var state_17333__$1 = state_17333;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17333__$1,inst_17331);
} else {
if((state_val_17334 === (12))){
var state_17333__$1 = state_17333;
var statearr_17341_17362 = state_17333__$1;
(statearr_17341_17362[(2)] = null);

(statearr_17341_17362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (2))){
var state_17333__$1 = state_17333;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17333__$1,(4),from);
} else {
if((state_val_17334 === (11))){
var inst_17322 = (state_17333[(2)]);
var state_17333__$1 = state_17333;
if(cljs.core.truth_(inst_17322)){
var statearr_17342_17363 = state_17333__$1;
(statearr_17342_17363[(1)] = (12));

} else {
var statearr_17343_17364 = state_17333__$1;
(statearr_17343_17364[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (9))){
var state_17333__$1 = state_17333;
var statearr_17344_17365 = state_17333__$1;
(statearr_17344_17365[(2)] = null);

(statearr_17344_17365[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (5))){
var state_17333__$1 = state_17333;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17345_17366 = state_17333__$1;
(statearr_17345_17366[(1)] = (8));

} else {
var statearr_17346_17367 = state_17333__$1;
(statearr_17346_17367[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (14))){
var inst_17327 = (state_17333[(2)]);
var state_17333__$1 = state_17333;
var statearr_17347_17368 = state_17333__$1;
(statearr_17347_17368[(2)] = inst_17327);

(statearr_17347_17368[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (10))){
var inst_17319 = (state_17333[(2)]);
var state_17333__$1 = state_17333;
var statearr_17348_17369 = state_17333__$1;
(statearr_17348_17369[(2)] = inst_17319);

(statearr_17348_17369[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17334 === (8))){
var inst_17316 = cljs.core.async.close_BANG_(to);
var state_17333__$1 = state_17333;
var statearr_17349_17370 = state_17333__$1;
(statearr_17349_17370[(2)] = inst_17316);

(statearr_17349_17370[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_17350 = [null,null,null,null,null,null,null,null];
(statearr_17350[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_17350[(1)] = (1));

return statearr_17350;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_17333){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17333);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17351){var ex__17136__auto__ = e17351;
var statearr_17352_17371 = state_17333;
(statearr_17352_17371[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17333[(4)]))){
var statearr_17353_17372 = state_17333;
(statearr_17353_17372[(1)] = cljs.core.first((state_17333[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17373 = state_17333;
state_17333 = G__17373;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_17333){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_17333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17354 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17354[(6)] = c__17207__auto___17356);

return statearr_17354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__17374){
var vec__17375 = p__17374;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17375,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17375,(1),null);
var job = vec__17375;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17207__auto___17551 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17382){
var state_val_17383 = (state_17382[(1)]);
if((state_val_17383 === (1))){
var state_17382__$1 = state_17382;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17382__$1,(2),res,v);
} else {
if((state_val_17383 === (2))){
var inst_17379 = (state_17382[(2)]);
var inst_17380 = cljs.core.async.close_BANG_(res);
var state_17382__$1 = (function (){var statearr_17384 = state_17382;
(statearr_17384[(7)] = inst_17379);

return statearr_17384;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17382__$1,inst_17380);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_17385 = [null,null,null,null,null,null,null,null];
(statearr_17385[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__);

(statearr_17385[(1)] = (1));

return statearr_17385;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1 = (function (state_17382){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17382);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17386){var ex__17136__auto__ = e17386;
var statearr_17387_17552 = state_17382;
(statearr_17387_17552[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17382[(4)]))){
var statearr_17388_17553 = state_17382;
(statearr_17388_17553[(1)] = cljs.core.first((state_17382[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17554 = state_17382;
state_17382 = G__17554;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = function(state_17382){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1.call(this,state_17382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17389 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17389[(6)] = c__17207__auto___17551);

return statearr_17389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__17390){
var vec__17391 = p__17390;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17391,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17391,(1),null);
var job = vec__17391;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___17555 = n;
var __17556 = (0);
while(true){
if((__17556 < n__4613__auto___17555)){
var G__17394_17557 = type;
var G__17394_17558__$1 = (((G__17394_17557 instanceof cljs.core.Keyword))?G__17394_17557.fqn:null);
switch (G__17394_17558__$1) {
case "compute":
var c__17207__auto___17560 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17556,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = ((function (__17556,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function (state_17407){
var state_val_17408 = (state_17407[(1)]);
if((state_val_17408 === (1))){
var state_17407__$1 = state_17407;
var statearr_17409_17561 = state_17407__$1;
(statearr_17409_17561[(2)] = null);

(statearr_17409_17561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17408 === (2))){
var state_17407__$1 = state_17407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17407__$1,(4),jobs);
} else {
if((state_val_17408 === (3))){
var inst_17405 = (state_17407[(2)]);
var state_17407__$1 = state_17407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17407__$1,inst_17405);
} else {
if((state_val_17408 === (4))){
var inst_17397 = (state_17407[(2)]);
var inst_17398 = process(inst_17397);
var state_17407__$1 = state_17407;
if(cljs.core.truth_(inst_17398)){
var statearr_17410_17562 = state_17407__$1;
(statearr_17410_17562[(1)] = (5));

} else {
var statearr_17411_17563 = state_17407__$1;
(statearr_17411_17563[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17408 === (5))){
var state_17407__$1 = state_17407;
var statearr_17412_17564 = state_17407__$1;
(statearr_17412_17564[(2)] = null);

(statearr_17412_17564[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17408 === (6))){
var state_17407__$1 = state_17407;
var statearr_17413_17565 = state_17407__$1;
(statearr_17413_17565[(2)] = null);

(statearr_17413_17565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17408 === (7))){
var inst_17403 = (state_17407[(2)]);
var state_17407__$1 = state_17407;
var statearr_17414_17566 = state_17407__$1;
(statearr_17414_17566[(2)] = inst_17403);

(statearr_17414_17566[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17556,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
;
return ((function (__17556,switch__17132__auto__,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_17415 = [null,null,null,null,null,null,null];
(statearr_17415[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__);

(statearr_17415[(1)] = (1));

return statearr_17415;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1 = (function (state_17407){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17407);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17416){var ex__17136__auto__ = e17416;
var statearr_17417_17567 = state_17407;
(statearr_17417_17567[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17407[(4)]))){
var statearr_17418_17568 = state_17407;
(statearr_17418_17568[(1)] = cljs.core.first((state_17407[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17569 = state_17407;
state_17407 = G__17569;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = function(state_17407){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1.call(this,state_17407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__;
})()
;})(__17556,switch__17132__auto__,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
})();
var state__17209__auto__ = (function (){var statearr_17419 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17419[(6)] = c__17207__auto___17560);

return statearr_17419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
});})(__17556,c__17207__auto___17560,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
);


break;
case "async":
var c__17207__auto___17570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17556,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = ((function (__17556,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function (state_17432){
var state_val_17433 = (state_17432[(1)]);
if((state_val_17433 === (1))){
var state_17432__$1 = state_17432;
var statearr_17434_17571 = state_17432__$1;
(statearr_17434_17571[(2)] = null);

(statearr_17434_17571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17433 === (2))){
var state_17432__$1 = state_17432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17432__$1,(4),jobs);
} else {
if((state_val_17433 === (3))){
var inst_17430 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17432__$1,inst_17430);
} else {
if((state_val_17433 === (4))){
var inst_17422 = (state_17432[(2)]);
var inst_17423 = async(inst_17422);
var state_17432__$1 = state_17432;
if(cljs.core.truth_(inst_17423)){
var statearr_17435_17572 = state_17432__$1;
(statearr_17435_17572[(1)] = (5));

} else {
var statearr_17436_17573 = state_17432__$1;
(statearr_17436_17573[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17433 === (5))){
var state_17432__$1 = state_17432;
var statearr_17437_17574 = state_17432__$1;
(statearr_17437_17574[(2)] = null);

(statearr_17437_17574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17433 === (6))){
var state_17432__$1 = state_17432;
var statearr_17438_17575 = state_17432__$1;
(statearr_17438_17575[(2)] = null);

(statearr_17438_17575[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17433 === (7))){
var inst_17428 = (state_17432[(2)]);
var state_17432__$1 = state_17432;
var statearr_17439_17576 = state_17432__$1;
(statearr_17439_17576[(2)] = inst_17428);

(statearr_17439_17576[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17556,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
;
return ((function (__17556,switch__17132__auto__,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_17440 = [null,null,null,null,null,null,null];
(statearr_17440[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__);

(statearr_17440[(1)] = (1));

return statearr_17440;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1 = (function (state_17432){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17432);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17441){var ex__17136__auto__ = e17441;
var statearr_17442_17577 = state_17432;
(statearr_17442_17577[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17432[(4)]))){
var statearr_17443_17578 = state_17432;
(statearr_17443_17578[(1)] = cljs.core.first((state_17432[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17579 = state_17432;
state_17432 = G__17579;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = function(state_17432){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1.call(this,state_17432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__;
})()
;})(__17556,switch__17132__auto__,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
})();
var state__17209__auto__ = (function (){var statearr_17444 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17444[(6)] = c__17207__auto___17570);

return statearr_17444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
});})(__17556,c__17207__auto___17570,G__17394_17557,G__17394_17558__$1,n__4613__auto___17555,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17394_17558__$1)].join('')));

}

var G__17580 = (__17556 + (1));
__17556 = G__17580;
continue;
} else {
}
break;
}

var c__17207__auto___17581 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17466){
var state_val_17467 = (state_17466[(1)]);
if((state_val_17467 === (7))){
var inst_17462 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
var statearr_17468_17582 = state_17466__$1;
(statearr_17468_17582[(2)] = inst_17462);

(statearr_17468_17582[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17467 === (1))){
var state_17466__$1 = state_17466;
var statearr_17469_17583 = state_17466__$1;
(statearr_17469_17583[(2)] = null);

(statearr_17469_17583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17467 === (4))){
var inst_17447 = (state_17466[(7)]);
var inst_17447__$1 = (state_17466[(2)]);
var inst_17448 = (inst_17447__$1 == null);
var state_17466__$1 = (function (){var statearr_17470 = state_17466;
(statearr_17470[(7)] = inst_17447__$1);

return statearr_17470;
})();
if(cljs.core.truth_(inst_17448)){
var statearr_17471_17584 = state_17466__$1;
(statearr_17471_17584[(1)] = (5));

} else {
var statearr_17472_17585 = state_17466__$1;
(statearr_17472_17585[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17467 === (6))){
var inst_17447 = (state_17466[(7)]);
var inst_17452 = (state_17466[(8)]);
var inst_17452__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17454 = [inst_17447,inst_17452__$1];
var inst_17455 = (new cljs.core.PersistentVector(null,2,(5),inst_17453,inst_17454,null));
var state_17466__$1 = (function (){var statearr_17473 = state_17466;
(statearr_17473[(8)] = inst_17452__$1);

return statearr_17473;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17466__$1,(8),jobs,inst_17455);
} else {
if((state_val_17467 === (3))){
var inst_17464 = (state_17466[(2)]);
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17466__$1,inst_17464);
} else {
if((state_val_17467 === (2))){
var state_17466__$1 = state_17466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17466__$1,(4),from);
} else {
if((state_val_17467 === (9))){
var inst_17459 = (state_17466[(2)]);
var state_17466__$1 = (function (){var statearr_17474 = state_17466;
(statearr_17474[(9)] = inst_17459);

return statearr_17474;
})();
var statearr_17475_17586 = state_17466__$1;
(statearr_17475_17586[(2)] = null);

(statearr_17475_17586[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17467 === (5))){
var inst_17450 = cljs.core.async.close_BANG_(jobs);
var state_17466__$1 = state_17466;
var statearr_17476_17587 = state_17466__$1;
(statearr_17476_17587[(2)] = inst_17450);

(statearr_17476_17587[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17467 === (8))){
var inst_17452 = (state_17466[(8)]);
var inst_17457 = (state_17466[(2)]);
var state_17466__$1 = (function (){var statearr_17477 = state_17466;
(statearr_17477[(10)] = inst_17457);

return statearr_17477;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17466__$1,(9),results,inst_17452);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_17478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17478[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__);

(statearr_17478[(1)] = (1));

return statearr_17478;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1 = (function (state_17466){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17466);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17479){var ex__17136__auto__ = e17479;
var statearr_17480_17588 = state_17466;
(statearr_17480_17588[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17466[(4)]))){
var statearr_17481_17589 = state_17466;
(statearr_17481_17589[(1)] = cljs.core.first((state_17466[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17590 = state_17466;
state_17466 = G__17590;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = function(state_17466){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1.call(this,state_17466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17482 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17482[(6)] = c__17207__auto___17581);

return statearr_17482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17520){
var state_val_17521 = (state_17520[(1)]);
if((state_val_17521 === (7))){
var inst_17516 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
var statearr_17522_17591 = state_17520__$1;
(statearr_17522_17591[(2)] = inst_17516);

(statearr_17522_17591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (20))){
var state_17520__$1 = state_17520;
var statearr_17523_17592 = state_17520__$1;
(statearr_17523_17592[(2)] = null);

(statearr_17523_17592[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (1))){
var state_17520__$1 = state_17520;
var statearr_17524_17593 = state_17520__$1;
(statearr_17524_17593[(2)] = null);

(statearr_17524_17593[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (4))){
var inst_17485 = (state_17520[(7)]);
var inst_17485__$1 = (state_17520[(2)]);
var inst_17486 = (inst_17485__$1 == null);
var state_17520__$1 = (function (){var statearr_17525 = state_17520;
(statearr_17525[(7)] = inst_17485__$1);

return statearr_17525;
})();
if(cljs.core.truth_(inst_17486)){
var statearr_17526_17594 = state_17520__$1;
(statearr_17526_17594[(1)] = (5));

} else {
var statearr_17527_17595 = state_17520__$1;
(statearr_17527_17595[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (15))){
var inst_17498 = (state_17520[(8)]);
var state_17520__$1 = state_17520;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17520__$1,(18),to,inst_17498);
} else {
if((state_val_17521 === (21))){
var inst_17511 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
var statearr_17528_17596 = state_17520__$1;
(statearr_17528_17596[(2)] = inst_17511);

(statearr_17528_17596[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (13))){
var inst_17513 = (state_17520[(2)]);
var state_17520__$1 = (function (){var statearr_17529 = state_17520;
(statearr_17529[(9)] = inst_17513);

return statearr_17529;
})();
var statearr_17530_17597 = state_17520__$1;
(statearr_17530_17597[(2)] = null);

(statearr_17530_17597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (6))){
var inst_17485 = (state_17520[(7)]);
var state_17520__$1 = state_17520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17520__$1,(11),inst_17485);
} else {
if((state_val_17521 === (17))){
var inst_17506 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
if(cljs.core.truth_(inst_17506)){
var statearr_17531_17598 = state_17520__$1;
(statearr_17531_17598[(1)] = (19));

} else {
var statearr_17532_17599 = state_17520__$1;
(statearr_17532_17599[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (3))){
var inst_17518 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17520__$1,inst_17518);
} else {
if((state_val_17521 === (12))){
var inst_17495 = (state_17520[(10)]);
var state_17520__$1 = state_17520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17520__$1,(14),inst_17495);
} else {
if((state_val_17521 === (2))){
var state_17520__$1 = state_17520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17520__$1,(4),results);
} else {
if((state_val_17521 === (19))){
var state_17520__$1 = state_17520;
var statearr_17533_17600 = state_17520__$1;
(statearr_17533_17600[(2)] = null);

(statearr_17533_17600[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (11))){
var inst_17495 = (state_17520[(2)]);
var state_17520__$1 = (function (){var statearr_17534 = state_17520;
(statearr_17534[(10)] = inst_17495);

return statearr_17534;
})();
var statearr_17535_17601 = state_17520__$1;
(statearr_17535_17601[(2)] = null);

(statearr_17535_17601[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (9))){
var state_17520__$1 = state_17520;
var statearr_17536_17602 = state_17520__$1;
(statearr_17536_17602[(2)] = null);

(statearr_17536_17602[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (5))){
var state_17520__$1 = state_17520;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17537_17603 = state_17520__$1;
(statearr_17537_17603[(1)] = (8));

} else {
var statearr_17538_17604 = state_17520__$1;
(statearr_17538_17604[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (14))){
var inst_17498 = (state_17520[(8)]);
var inst_17498__$1 = (state_17520[(2)]);
var inst_17499 = (inst_17498__$1 == null);
var inst_17500 = cljs.core.not(inst_17499);
var state_17520__$1 = (function (){var statearr_17539 = state_17520;
(statearr_17539[(8)] = inst_17498__$1);

return statearr_17539;
})();
if(inst_17500){
var statearr_17540_17605 = state_17520__$1;
(statearr_17540_17605[(1)] = (15));

} else {
var statearr_17541_17606 = state_17520__$1;
(statearr_17541_17606[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (16))){
var state_17520__$1 = state_17520;
var statearr_17542_17607 = state_17520__$1;
(statearr_17542_17607[(2)] = false);

(statearr_17542_17607[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (10))){
var inst_17492 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
var statearr_17543_17608 = state_17520__$1;
(statearr_17543_17608[(2)] = inst_17492);

(statearr_17543_17608[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (18))){
var inst_17503 = (state_17520[(2)]);
var state_17520__$1 = state_17520;
var statearr_17544_17609 = state_17520__$1;
(statearr_17544_17609[(2)] = inst_17503);

(statearr_17544_17609[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17521 === (8))){
var inst_17489 = cljs.core.async.close_BANG_(to);
var state_17520__$1 = state_17520;
var statearr_17545_17610 = state_17520__$1;
(statearr_17545_17610[(2)] = inst_17489);

(statearr_17545_17610[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_17546 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17546[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__);

(statearr_17546[(1)] = (1));

return statearr_17546;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1 = (function (state_17520){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17520);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17547){var ex__17136__auto__ = e17547;
var statearr_17548_17611 = state_17520;
(statearr_17548_17611[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17520[(4)]))){
var statearr_17549_17612 = state_17520;
(statearr_17549_17612[(1)] = cljs.core.first((state_17520[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17613 = state_17520;
state_17520 = G__17613;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__ = function(state_17520){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1.call(this,state_17520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17550 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17550[(6)] = c__17207__auto__);

return statearr_17550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17615 = arguments.length;
switch (G__17615) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17618 = arguments.length;
switch (G__17618) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17621 = arguments.length;
switch (G__17621) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17207__auto___17671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17647){
var state_val_17648 = (state_17647[(1)]);
if((state_val_17648 === (7))){
var inst_17643 = (state_17647[(2)]);
var state_17647__$1 = state_17647;
var statearr_17649_17672 = state_17647__$1;
(statearr_17649_17672[(2)] = inst_17643);

(statearr_17649_17672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (1))){
var state_17647__$1 = state_17647;
var statearr_17650_17673 = state_17647__$1;
(statearr_17650_17673[(2)] = null);

(statearr_17650_17673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (4))){
var inst_17624 = (state_17647[(7)]);
var inst_17624__$1 = (state_17647[(2)]);
var inst_17625 = (inst_17624__$1 == null);
var state_17647__$1 = (function (){var statearr_17651 = state_17647;
(statearr_17651[(7)] = inst_17624__$1);

return statearr_17651;
})();
if(cljs.core.truth_(inst_17625)){
var statearr_17652_17674 = state_17647__$1;
(statearr_17652_17674[(1)] = (5));

} else {
var statearr_17653_17675 = state_17647__$1;
(statearr_17653_17675[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (13))){
var state_17647__$1 = state_17647;
var statearr_17654_17676 = state_17647__$1;
(statearr_17654_17676[(2)] = null);

(statearr_17654_17676[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (6))){
var inst_17624 = (state_17647[(7)]);
var inst_17630 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17624) : p.call(null,inst_17624));
var state_17647__$1 = state_17647;
if(cljs.core.truth_(inst_17630)){
var statearr_17655_17677 = state_17647__$1;
(statearr_17655_17677[(1)] = (9));

} else {
var statearr_17656_17678 = state_17647__$1;
(statearr_17656_17678[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (3))){
var inst_17645 = (state_17647[(2)]);
var state_17647__$1 = state_17647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17647__$1,inst_17645);
} else {
if((state_val_17648 === (12))){
var state_17647__$1 = state_17647;
var statearr_17657_17679 = state_17647__$1;
(statearr_17657_17679[(2)] = null);

(statearr_17657_17679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (2))){
var state_17647__$1 = state_17647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17647__$1,(4),ch);
} else {
if((state_val_17648 === (11))){
var inst_17624 = (state_17647[(7)]);
var inst_17634 = (state_17647[(2)]);
var state_17647__$1 = state_17647;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17647__$1,(8),inst_17634,inst_17624);
} else {
if((state_val_17648 === (9))){
var state_17647__$1 = state_17647;
var statearr_17658_17680 = state_17647__$1;
(statearr_17658_17680[(2)] = tc);

(statearr_17658_17680[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (5))){
var inst_17627 = cljs.core.async.close_BANG_(tc);
var inst_17628 = cljs.core.async.close_BANG_(fc);
var state_17647__$1 = (function (){var statearr_17659 = state_17647;
(statearr_17659[(8)] = inst_17627);

return statearr_17659;
})();
var statearr_17660_17681 = state_17647__$1;
(statearr_17660_17681[(2)] = inst_17628);

(statearr_17660_17681[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (14))){
var inst_17641 = (state_17647[(2)]);
var state_17647__$1 = state_17647;
var statearr_17661_17682 = state_17647__$1;
(statearr_17661_17682[(2)] = inst_17641);

(statearr_17661_17682[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (10))){
var state_17647__$1 = state_17647;
var statearr_17662_17683 = state_17647__$1;
(statearr_17662_17683[(2)] = fc);

(statearr_17662_17683[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17648 === (8))){
var inst_17636 = (state_17647[(2)]);
var state_17647__$1 = state_17647;
if(cljs.core.truth_(inst_17636)){
var statearr_17663_17684 = state_17647__$1;
(statearr_17663_17684[(1)] = (12));

} else {
var statearr_17664_17685 = state_17647__$1;
(statearr_17664_17685[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_17665 = [null,null,null,null,null,null,null,null,null];
(statearr_17665[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_17665[(1)] = (1));

return statearr_17665;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_17647){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17647);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17666){var ex__17136__auto__ = e17666;
var statearr_17667_17686 = state_17647;
(statearr_17667_17686[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17647[(4)]))){
var statearr_17668_17687 = state_17647;
(statearr_17668_17687[(1)] = cljs.core.first((state_17647[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17688 = state_17647;
state_17647 = G__17688;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_17647){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_17647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17669 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17669[(6)] = c__17207__auto___17671);

return statearr_17669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17710){
var state_val_17711 = (state_17710[(1)]);
if((state_val_17711 === (7))){
var inst_17706 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17712_17731 = state_17710__$1;
(statearr_17712_17731[(2)] = inst_17706);

(statearr_17712_17731[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (1))){
var inst_17689 = init;
var inst_17690 = inst_17689;
var state_17710__$1 = (function (){var statearr_17713 = state_17710;
(statearr_17713[(7)] = inst_17690);

return statearr_17713;
})();
var statearr_17714_17732 = state_17710__$1;
(statearr_17714_17732[(2)] = null);

(statearr_17714_17732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (4))){
var inst_17693 = (state_17710[(8)]);
var inst_17693__$1 = (state_17710[(2)]);
var inst_17694 = (inst_17693__$1 == null);
var state_17710__$1 = (function (){var statearr_17715 = state_17710;
(statearr_17715[(8)] = inst_17693__$1);

return statearr_17715;
})();
if(cljs.core.truth_(inst_17694)){
var statearr_17716_17733 = state_17710__$1;
(statearr_17716_17733[(1)] = (5));

} else {
var statearr_17717_17734 = state_17710__$1;
(statearr_17717_17734[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (6))){
var inst_17690 = (state_17710[(7)]);
var inst_17697 = (state_17710[(9)]);
var inst_17693 = (state_17710[(8)]);
var inst_17697__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17690,inst_17693) : f.call(null,inst_17690,inst_17693));
var inst_17698 = cljs.core.reduced_QMARK_(inst_17697__$1);
var state_17710__$1 = (function (){var statearr_17718 = state_17710;
(statearr_17718[(9)] = inst_17697__$1);

return statearr_17718;
})();
if(inst_17698){
var statearr_17719_17735 = state_17710__$1;
(statearr_17719_17735[(1)] = (8));

} else {
var statearr_17720_17736 = state_17710__$1;
(statearr_17720_17736[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (3))){
var inst_17708 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17710__$1,inst_17708);
} else {
if((state_val_17711 === (2))){
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17710__$1,(4),ch);
} else {
if((state_val_17711 === (9))){
var inst_17697 = (state_17710[(9)]);
var inst_17690 = inst_17697;
var state_17710__$1 = (function (){var statearr_17721 = state_17710;
(statearr_17721[(7)] = inst_17690);

return statearr_17721;
})();
var statearr_17722_17737 = state_17710__$1;
(statearr_17722_17737[(2)] = null);

(statearr_17722_17737[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (5))){
var inst_17690 = (state_17710[(7)]);
var state_17710__$1 = state_17710;
var statearr_17723_17738 = state_17710__$1;
(statearr_17723_17738[(2)] = inst_17690);

(statearr_17723_17738[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (10))){
var inst_17704 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17724_17739 = state_17710__$1;
(statearr_17724_17739[(2)] = inst_17704);

(statearr_17724_17739[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (8))){
var inst_17697 = (state_17710[(9)]);
var inst_17700 = cljs.core.deref(inst_17697);
var state_17710__$1 = state_17710;
var statearr_17725_17740 = state_17710__$1;
(statearr_17725_17740[(2)] = inst_17700);

(statearr_17725_17740[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__17133__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17133__auto____0 = (function (){
var statearr_17726 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17726[(0)] = cljs$core$async$reduce_$_state_machine__17133__auto__);

(statearr_17726[(1)] = (1));

return statearr_17726;
});
var cljs$core$async$reduce_$_state_machine__17133__auto____1 = (function (state_17710){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17710);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17727){var ex__17136__auto__ = e17727;
var statearr_17728_17741 = state_17710;
(statearr_17728_17741[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17710[(4)]))){
var statearr_17729_17742 = state_17710;
(statearr_17729_17742[(1)] = cljs.core.first((state_17710[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17743 = state_17710;
state_17710 = G__17743;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17133__auto__ = function(state_17710){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17133__auto____1.call(this,state_17710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17133__auto____0;
cljs$core$async$reduce_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17133__auto____1;
return cljs$core$async$reduce_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17730 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17730[(6)] = c__17207__auto__);

return statearr_17730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17749){
var state_val_17750 = (state_17749[(1)]);
if((state_val_17750 === (1))){
var inst_17744 = cljs.core.async.reduce(f__$1,init,ch);
var state_17749__$1 = state_17749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17749__$1,(2),inst_17744);
} else {
if((state_val_17750 === (2))){
var inst_17746 = (state_17749[(2)]);
var inst_17747 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17746) : f__$1.call(null,inst_17746));
var state_17749__$1 = state_17749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17749__$1,inst_17747);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__17133__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17133__auto____0 = (function (){
var statearr_17751 = [null,null,null,null,null,null,null];
(statearr_17751[(0)] = cljs$core$async$transduce_$_state_machine__17133__auto__);

(statearr_17751[(1)] = (1));

return statearr_17751;
});
var cljs$core$async$transduce_$_state_machine__17133__auto____1 = (function (state_17749){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17749);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17752){var ex__17136__auto__ = e17752;
var statearr_17753_17756 = state_17749;
(statearr_17753_17756[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17749[(4)]))){
var statearr_17754_17757 = state_17749;
(statearr_17754_17757[(1)] = cljs.core.first((state_17749[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17758 = state_17749;
state_17749 = G__17758;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17133__auto__ = function(state_17749){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17133__auto____1.call(this,state_17749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17133__auto____0;
cljs$core$async$transduce_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17133__auto____1;
return cljs$core$async$transduce_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17755 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17755[(6)] = c__17207__auto__);

return statearr_17755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__17760 = arguments.length;
switch (G__17760) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17785){
var state_val_17786 = (state_17785[(1)]);
if((state_val_17786 === (7))){
var inst_17767 = (state_17785[(2)]);
var state_17785__$1 = state_17785;
var statearr_17787_17809 = state_17785__$1;
(statearr_17787_17809[(2)] = inst_17767);

(statearr_17787_17809[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (1))){
var inst_17761 = cljs.core.seq(coll);
var inst_17762 = inst_17761;
var state_17785__$1 = (function (){var statearr_17788 = state_17785;
(statearr_17788[(7)] = inst_17762);

return statearr_17788;
})();
var statearr_17789_17810 = state_17785__$1;
(statearr_17789_17810[(2)] = null);

(statearr_17789_17810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (4))){
var inst_17762 = (state_17785[(7)]);
var inst_17765 = cljs.core.first(inst_17762);
var state_17785__$1 = state_17785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17785__$1,(7),ch,inst_17765);
} else {
if((state_val_17786 === (13))){
var inst_17779 = (state_17785[(2)]);
var state_17785__$1 = state_17785;
var statearr_17790_17811 = state_17785__$1;
(statearr_17790_17811[(2)] = inst_17779);

(statearr_17790_17811[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (6))){
var inst_17770 = (state_17785[(2)]);
var state_17785__$1 = state_17785;
if(cljs.core.truth_(inst_17770)){
var statearr_17791_17812 = state_17785__$1;
(statearr_17791_17812[(1)] = (8));

} else {
var statearr_17792_17813 = state_17785__$1;
(statearr_17792_17813[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (3))){
var inst_17783 = (state_17785[(2)]);
var state_17785__$1 = state_17785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17785__$1,inst_17783);
} else {
if((state_val_17786 === (12))){
var state_17785__$1 = state_17785;
var statearr_17793_17814 = state_17785__$1;
(statearr_17793_17814[(2)] = null);

(statearr_17793_17814[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (2))){
var inst_17762 = (state_17785[(7)]);
var state_17785__$1 = state_17785;
if(cljs.core.truth_(inst_17762)){
var statearr_17794_17815 = state_17785__$1;
(statearr_17794_17815[(1)] = (4));

} else {
var statearr_17795_17816 = state_17785__$1;
(statearr_17795_17816[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (11))){
var inst_17776 = cljs.core.async.close_BANG_(ch);
var state_17785__$1 = state_17785;
var statearr_17796_17817 = state_17785__$1;
(statearr_17796_17817[(2)] = inst_17776);

(statearr_17796_17817[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (9))){
var state_17785__$1 = state_17785;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17797_17818 = state_17785__$1;
(statearr_17797_17818[(1)] = (11));

} else {
var statearr_17798_17819 = state_17785__$1;
(statearr_17798_17819[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (5))){
var inst_17762 = (state_17785[(7)]);
var state_17785__$1 = state_17785;
var statearr_17799_17820 = state_17785__$1;
(statearr_17799_17820[(2)] = inst_17762);

(statearr_17799_17820[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (10))){
var inst_17781 = (state_17785[(2)]);
var state_17785__$1 = state_17785;
var statearr_17800_17821 = state_17785__$1;
(statearr_17800_17821[(2)] = inst_17781);

(statearr_17800_17821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17786 === (8))){
var inst_17762 = (state_17785[(7)]);
var inst_17772 = cljs.core.next(inst_17762);
var inst_17762__$1 = inst_17772;
var state_17785__$1 = (function (){var statearr_17801 = state_17785;
(statearr_17801[(7)] = inst_17762__$1);

return statearr_17801;
})();
var statearr_17802_17822 = state_17785__$1;
(statearr_17802_17822[(2)] = null);

(statearr_17802_17822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_17803 = [null,null,null,null,null,null,null,null];
(statearr_17803[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_17803[(1)] = (1));

return statearr_17803;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_17785){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17785);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e17804){var ex__17136__auto__ = e17804;
var statearr_17805_17823 = state_17785;
(statearr_17805_17823[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17785[(4)]))){
var statearr_17806_17824 = state_17785;
(statearr_17806_17824[(1)] = cljs.core.first((state_17785[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__17825 = state_17785;
state_17785 = G__17825;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_17785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_17785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_17807 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_17807[(6)] = c__17207__auto__);

return statearr_17807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17827 = arguments.length;
switch (G__17827) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17829 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17829(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17830 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17830(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17831 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17831(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17832 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17832(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17833 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17833 = (function (ch,cs,meta17834){
this.ch = ch;
this.cs = cs;
this.meta17834 = meta17834;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17835,meta17834__$1){
var self__ = this;
var _17835__$1 = this;
return (new cljs.core.async.t_cljs$core$async17833(self__.ch,self__.cs,meta17834__$1));
}));

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17835){
var self__ = this;
var _17835__$1 = this;
return self__.meta17834;
}));

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async17833.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async17833.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17834], null);
}));

(cljs.core.async.t_cljs$core$async17833.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17833.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17833");

(cljs.core.async.t_cljs$core$async17833.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17833");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17833.
 */
cljs.core.async.__GT_t_cljs$core$async17833 = (function cljs$core$async$mult_$___GT_t_cljs$core$async17833(ch__$1,cs__$1,meta17834){
return (new cljs.core.async.t_cljs$core$async17833(ch__$1,cs__$1,meta17834));
});

}

return (new cljs.core.async.t_cljs$core$async17833(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__17207__auto___18052 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_17968){
var state_val_17969 = (state_17968[(1)]);
if((state_val_17969 === (7))){
var inst_17964 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_17970_18053 = state_17968__$1;
(statearr_17970_18053[(2)] = inst_17964);

(statearr_17970_18053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (20))){
var inst_17869 = (state_17968[(7)]);
var inst_17881 = cljs.core.first(inst_17869);
var inst_17882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17881,(0),null);
var inst_17883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17881,(1),null);
var state_17968__$1 = (function (){var statearr_17971 = state_17968;
(statearr_17971[(8)] = inst_17882);

return statearr_17971;
})();
if(cljs.core.truth_(inst_17883)){
var statearr_17972_18054 = state_17968__$1;
(statearr_17972_18054[(1)] = (22));

} else {
var statearr_17973_18055 = state_17968__$1;
(statearr_17973_18055[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (27))){
var inst_17911 = (state_17968[(9)]);
var inst_17913 = (state_17968[(10)]);
var inst_17918 = (state_17968[(11)]);
var inst_17838 = (state_17968[(12)]);
var inst_17918__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17911,inst_17913);
var inst_17919 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17918__$1,inst_17838,done);
var state_17968__$1 = (function (){var statearr_17974 = state_17968;
(statearr_17974[(11)] = inst_17918__$1);

return statearr_17974;
})();
if(cljs.core.truth_(inst_17919)){
var statearr_17975_18056 = state_17968__$1;
(statearr_17975_18056[(1)] = (30));

} else {
var statearr_17976_18057 = state_17968__$1;
(statearr_17976_18057[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (1))){
var state_17968__$1 = state_17968;
var statearr_17977_18058 = state_17968__$1;
(statearr_17977_18058[(2)] = null);

(statearr_17977_18058[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (24))){
var inst_17869 = (state_17968[(7)]);
var inst_17888 = (state_17968[(2)]);
var inst_17889 = cljs.core.next(inst_17869);
var inst_17847 = inst_17889;
var inst_17848 = null;
var inst_17849 = (0);
var inst_17850 = (0);
var state_17968__$1 = (function (){var statearr_17978 = state_17968;
(statearr_17978[(13)] = inst_17847);

(statearr_17978[(14)] = inst_17849);

(statearr_17978[(15)] = inst_17848);

(statearr_17978[(16)] = inst_17888);

(statearr_17978[(17)] = inst_17850);

return statearr_17978;
})();
var statearr_17979_18059 = state_17968__$1;
(statearr_17979_18059[(2)] = null);

(statearr_17979_18059[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (39))){
var state_17968__$1 = state_17968;
var statearr_17983_18060 = state_17968__$1;
(statearr_17983_18060[(2)] = null);

(statearr_17983_18060[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (4))){
var inst_17838 = (state_17968[(12)]);
var inst_17838__$1 = (state_17968[(2)]);
var inst_17839 = (inst_17838__$1 == null);
var state_17968__$1 = (function (){var statearr_17984 = state_17968;
(statearr_17984[(12)] = inst_17838__$1);

return statearr_17984;
})();
if(cljs.core.truth_(inst_17839)){
var statearr_17985_18061 = state_17968__$1;
(statearr_17985_18061[(1)] = (5));

} else {
var statearr_17986_18062 = state_17968__$1;
(statearr_17986_18062[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (15))){
var inst_17847 = (state_17968[(13)]);
var inst_17849 = (state_17968[(14)]);
var inst_17848 = (state_17968[(15)]);
var inst_17850 = (state_17968[(17)]);
var inst_17865 = (state_17968[(2)]);
var inst_17866 = (inst_17850 + (1));
var tmp17980 = inst_17847;
var tmp17981 = inst_17849;
var tmp17982 = inst_17848;
var inst_17847__$1 = tmp17980;
var inst_17848__$1 = tmp17982;
var inst_17849__$1 = tmp17981;
var inst_17850__$1 = inst_17866;
var state_17968__$1 = (function (){var statearr_17987 = state_17968;
(statearr_17987[(13)] = inst_17847__$1);

(statearr_17987[(14)] = inst_17849__$1);

(statearr_17987[(15)] = inst_17848__$1);

(statearr_17987[(18)] = inst_17865);

(statearr_17987[(17)] = inst_17850__$1);

return statearr_17987;
})();
var statearr_17988_18063 = state_17968__$1;
(statearr_17988_18063[(2)] = null);

(statearr_17988_18063[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (21))){
var inst_17892 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_17992_18064 = state_17968__$1;
(statearr_17992_18064[(2)] = inst_17892);

(statearr_17992_18064[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (31))){
var inst_17918 = (state_17968[(11)]);
var inst_17922 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17918);
var state_17968__$1 = state_17968;
var statearr_17993_18065 = state_17968__$1;
(statearr_17993_18065[(2)] = inst_17922);

(statearr_17993_18065[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (32))){
var inst_17911 = (state_17968[(9)]);
var inst_17912 = (state_17968[(19)]);
var inst_17910 = (state_17968[(20)]);
var inst_17913 = (state_17968[(10)]);
var inst_17924 = (state_17968[(2)]);
var inst_17925 = (inst_17913 + (1));
var tmp17989 = inst_17911;
var tmp17990 = inst_17912;
var tmp17991 = inst_17910;
var inst_17910__$1 = tmp17991;
var inst_17911__$1 = tmp17989;
var inst_17912__$1 = tmp17990;
var inst_17913__$1 = inst_17925;
var state_17968__$1 = (function (){var statearr_17994 = state_17968;
(statearr_17994[(9)] = inst_17911__$1);

(statearr_17994[(19)] = inst_17912__$1);

(statearr_17994[(20)] = inst_17910__$1);

(statearr_17994[(21)] = inst_17924);

(statearr_17994[(10)] = inst_17913__$1);

return statearr_17994;
})();
var statearr_17995_18066 = state_17968__$1;
(statearr_17995_18066[(2)] = null);

(statearr_17995_18066[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (40))){
var inst_17937 = (state_17968[(22)]);
var inst_17941 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17937);
var state_17968__$1 = state_17968;
var statearr_17996_18067 = state_17968__$1;
(statearr_17996_18067[(2)] = inst_17941);

(statearr_17996_18067[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (33))){
var inst_17928 = (state_17968[(23)]);
var inst_17930 = cljs.core.chunked_seq_QMARK_(inst_17928);
var state_17968__$1 = state_17968;
if(inst_17930){
var statearr_17997_18068 = state_17968__$1;
(statearr_17997_18068[(1)] = (36));

} else {
var statearr_17998_18069 = state_17968__$1;
(statearr_17998_18069[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (13))){
var inst_17859 = (state_17968[(24)]);
var inst_17862 = cljs.core.async.close_BANG_(inst_17859);
var state_17968__$1 = state_17968;
var statearr_17999_18070 = state_17968__$1;
(statearr_17999_18070[(2)] = inst_17862);

(statearr_17999_18070[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (22))){
var inst_17882 = (state_17968[(8)]);
var inst_17885 = cljs.core.async.close_BANG_(inst_17882);
var state_17968__$1 = state_17968;
var statearr_18000_18071 = state_17968__$1;
(statearr_18000_18071[(2)] = inst_17885);

(statearr_18000_18071[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (36))){
var inst_17928 = (state_17968[(23)]);
var inst_17932 = cljs.core.chunk_first(inst_17928);
var inst_17933 = cljs.core.chunk_rest(inst_17928);
var inst_17934 = cljs.core.count(inst_17932);
var inst_17910 = inst_17933;
var inst_17911 = inst_17932;
var inst_17912 = inst_17934;
var inst_17913 = (0);
var state_17968__$1 = (function (){var statearr_18001 = state_17968;
(statearr_18001[(9)] = inst_17911);

(statearr_18001[(19)] = inst_17912);

(statearr_18001[(20)] = inst_17910);

(statearr_18001[(10)] = inst_17913);

return statearr_18001;
})();
var statearr_18002_18072 = state_17968__$1;
(statearr_18002_18072[(2)] = null);

(statearr_18002_18072[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (41))){
var inst_17928 = (state_17968[(23)]);
var inst_17943 = (state_17968[(2)]);
var inst_17944 = cljs.core.next(inst_17928);
var inst_17910 = inst_17944;
var inst_17911 = null;
var inst_17912 = (0);
var inst_17913 = (0);
var state_17968__$1 = (function (){var statearr_18003 = state_17968;
(statearr_18003[(9)] = inst_17911);

(statearr_18003[(19)] = inst_17912);

(statearr_18003[(20)] = inst_17910);

(statearr_18003[(25)] = inst_17943);

(statearr_18003[(10)] = inst_17913);

return statearr_18003;
})();
var statearr_18004_18073 = state_17968__$1;
(statearr_18004_18073[(2)] = null);

(statearr_18004_18073[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (43))){
var state_17968__$1 = state_17968;
var statearr_18005_18074 = state_17968__$1;
(statearr_18005_18074[(2)] = null);

(statearr_18005_18074[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (29))){
var inst_17952 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18006_18075 = state_17968__$1;
(statearr_18006_18075[(2)] = inst_17952);

(statearr_18006_18075[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (44))){
var inst_17961 = (state_17968[(2)]);
var state_17968__$1 = (function (){var statearr_18007 = state_17968;
(statearr_18007[(26)] = inst_17961);

return statearr_18007;
})();
var statearr_18008_18076 = state_17968__$1;
(statearr_18008_18076[(2)] = null);

(statearr_18008_18076[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (6))){
var inst_17902 = (state_17968[(27)]);
var inst_17901 = cljs.core.deref(cs);
var inst_17902__$1 = cljs.core.keys(inst_17901);
var inst_17903 = cljs.core.count(inst_17902__$1);
var inst_17904 = cljs.core.reset_BANG_(dctr,inst_17903);
var inst_17909 = cljs.core.seq(inst_17902__$1);
var inst_17910 = inst_17909;
var inst_17911 = null;
var inst_17912 = (0);
var inst_17913 = (0);
var state_17968__$1 = (function (){var statearr_18009 = state_17968;
(statearr_18009[(9)] = inst_17911);

(statearr_18009[(19)] = inst_17912);

(statearr_18009[(27)] = inst_17902__$1);

(statearr_18009[(20)] = inst_17910);

(statearr_18009[(10)] = inst_17913);

(statearr_18009[(28)] = inst_17904);

return statearr_18009;
})();
var statearr_18010_18077 = state_17968__$1;
(statearr_18010_18077[(2)] = null);

(statearr_18010_18077[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (28))){
var inst_17910 = (state_17968[(20)]);
var inst_17928 = (state_17968[(23)]);
var inst_17928__$1 = cljs.core.seq(inst_17910);
var state_17968__$1 = (function (){var statearr_18011 = state_17968;
(statearr_18011[(23)] = inst_17928__$1);

return statearr_18011;
})();
if(inst_17928__$1){
var statearr_18012_18078 = state_17968__$1;
(statearr_18012_18078[(1)] = (33));

} else {
var statearr_18013_18079 = state_17968__$1;
(statearr_18013_18079[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (25))){
var inst_17912 = (state_17968[(19)]);
var inst_17913 = (state_17968[(10)]);
var inst_17915 = (inst_17913 < inst_17912);
var inst_17916 = inst_17915;
var state_17968__$1 = state_17968;
if(cljs.core.truth_(inst_17916)){
var statearr_18014_18080 = state_17968__$1;
(statearr_18014_18080[(1)] = (27));

} else {
var statearr_18015_18081 = state_17968__$1;
(statearr_18015_18081[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (34))){
var state_17968__$1 = state_17968;
var statearr_18016_18082 = state_17968__$1;
(statearr_18016_18082[(2)] = null);

(statearr_18016_18082[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (17))){
var state_17968__$1 = state_17968;
var statearr_18017_18083 = state_17968__$1;
(statearr_18017_18083[(2)] = null);

(statearr_18017_18083[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (3))){
var inst_17966 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17968__$1,inst_17966);
} else {
if((state_val_17969 === (12))){
var inst_17897 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18018_18084 = state_17968__$1;
(statearr_18018_18084[(2)] = inst_17897);

(statearr_18018_18084[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (2))){
var state_17968__$1 = state_17968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17968__$1,(4),ch);
} else {
if((state_val_17969 === (23))){
var state_17968__$1 = state_17968;
var statearr_18019_18085 = state_17968__$1;
(statearr_18019_18085[(2)] = null);

(statearr_18019_18085[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (35))){
var inst_17950 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18020_18086 = state_17968__$1;
(statearr_18020_18086[(2)] = inst_17950);

(statearr_18020_18086[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (19))){
var inst_17869 = (state_17968[(7)]);
var inst_17873 = cljs.core.chunk_first(inst_17869);
var inst_17874 = cljs.core.chunk_rest(inst_17869);
var inst_17875 = cljs.core.count(inst_17873);
var inst_17847 = inst_17874;
var inst_17848 = inst_17873;
var inst_17849 = inst_17875;
var inst_17850 = (0);
var state_17968__$1 = (function (){var statearr_18021 = state_17968;
(statearr_18021[(13)] = inst_17847);

(statearr_18021[(14)] = inst_17849);

(statearr_18021[(15)] = inst_17848);

(statearr_18021[(17)] = inst_17850);

return statearr_18021;
})();
var statearr_18022_18087 = state_17968__$1;
(statearr_18022_18087[(2)] = null);

(statearr_18022_18087[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (11))){
var inst_17847 = (state_17968[(13)]);
var inst_17869 = (state_17968[(7)]);
var inst_17869__$1 = cljs.core.seq(inst_17847);
var state_17968__$1 = (function (){var statearr_18023 = state_17968;
(statearr_18023[(7)] = inst_17869__$1);

return statearr_18023;
})();
if(inst_17869__$1){
var statearr_18024_18088 = state_17968__$1;
(statearr_18024_18088[(1)] = (16));

} else {
var statearr_18025_18089 = state_17968__$1;
(statearr_18025_18089[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (9))){
var inst_17899 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18026_18090 = state_17968__$1;
(statearr_18026_18090[(2)] = inst_17899);

(statearr_18026_18090[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (5))){
var inst_17845 = cljs.core.deref(cs);
var inst_17846 = cljs.core.seq(inst_17845);
var inst_17847 = inst_17846;
var inst_17848 = null;
var inst_17849 = (0);
var inst_17850 = (0);
var state_17968__$1 = (function (){var statearr_18027 = state_17968;
(statearr_18027[(13)] = inst_17847);

(statearr_18027[(14)] = inst_17849);

(statearr_18027[(15)] = inst_17848);

(statearr_18027[(17)] = inst_17850);

return statearr_18027;
})();
var statearr_18028_18091 = state_17968__$1;
(statearr_18028_18091[(2)] = null);

(statearr_18028_18091[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (14))){
var state_17968__$1 = state_17968;
var statearr_18029_18092 = state_17968__$1;
(statearr_18029_18092[(2)] = null);

(statearr_18029_18092[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (45))){
var inst_17958 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18030_18093 = state_17968__$1;
(statearr_18030_18093[(2)] = inst_17958);

(statearr_18030_18093[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (26))){
var inst_17902 = (state_17968[(27)]);
var inst_17954 = (state_17968[(2)]);
var inst_17955 = cljs.core.seq(inst_17902);
var state_17968__$1 = (function (){var statearr_18031 = state_17968;
(statearr_18031[(29)] = inst_17954);

return statearr_18031;
})();
if(inst_17955){
var statearr_18032_18094 = state_17968__$1;
(statearr_18032_18094[(1)] = (42));

} else {
var statearr_18033_18095 = state_17968__$1;
(statearr_18033_18095[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (16))){
var inst_17869 = (state_17968[(7)]);
var inst_17871 = cljs.core.chunked_seq_QMARK_(inst_17869);
var state_17968__$1 = state_17968;
if(inst_17871){
var statearr_18034_18096 = state_17968__$1;
(statearr_18034_18096[(1)] = (19));

} else {
var statearr_18035_18097 = state_17968__$1;
(statearr_18035_18097[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (38))){
var inst_17947 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18036_18098 = state_17968__$1;
(statearr_18036_18098[(2)] = inst_17947);

(statearr_18036_18098[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (30))){
var state_17968__$1 = state_17968;
var statearr_18037_18099 = state_17968__$1;
(statearr_18037_18099[(2)] = null);

(statearr_18037_18099[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (10))){
var inst_17848 = (state_17968[(15)]);
var inst_17850 = (state_17968[(17)]);
var inst_17858 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17848,inst_17850);
var inst_17859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17858,(0),null);
var inst_17860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17858,(1),null);
var state_17968__$1 = (function (){var statearr_18038 = state_17968;
(statearr_18038[(24)] = inst_17859);

return statearr_18038;
})();
if(cljs.core.truth_(inst_17860)){
var statearr_18039_18100 = state_17968__$1;
(statearr_18039_18100[(1)] = (13));

} else {
var statearr_18040_18101 = state_17968__$1;
(statearr_18040_18101[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (18))){
var inst_17895 = (state_17968[(2)]);
var state_17968__$1 = state_17968;
var statearr_18041_18102 = state_17968__$1;
(statearr_18041_18102[(2)] = inst_17895);

(statearr_18041_18102[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (42))){
var state_17968__$1 = state_17968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17968__$1,(45),dchan);
} else {
if((state_val_17969 === (37))){
var inst_17937 = (state_17968[(22)]);
var inst_17928 = (state_17968[(23)]);
var inst_17838 = (state_17968[(12)]);
var inst_17937__$1 = cljs.core.first(inst_17928);
var inst_17938 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17937__$1,inst_17838,done);
var state_17968__$1 = (function (){var statearr_18042 = state_17968;
(statearr_18042[(22)] = inst_17937__$1);

return statearr_18042;
})();
if(cljs.core.truth_(inst_17938)){
var statearr_18043_18103 = state_17968__$1;
(statearr_18043_18103[(1)] = (39));

} else {
var statearr_18044_18104 = state_17968__$1;
(statearr_18044_18104[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17969 === (8))){
var inst_17849 = (state_17968[(14)]);
var inst_17850 = (state_17968[(17)]);
var inst_17852 = (inst_17850 < inst_17849);
var inst_17853 = inst_17852;
var state_17968__$1 = state_17968;
if(cljs.core.truth_(inst_17853)){
var statearr_18045_18105 = state_17968__$1;
(statearr_18045_18105[(1)] = (10));

} else {
var statearr_18046_18106 = state_17968__$1;
(statearr_18046_18106[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__17133__auto__ = null;
var cljs$core$async$mult_$_state_machine__17133__auto____0 = (function (){
var statearr_18047 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18047[(0)] = cljs$core$async$mult_$_state_machine__17133__auto__);

(statearr_18047[(1)] = (1));

return statearr_18047;
});
var cljs$core$async$mult_$_state_machine__17133__auto____1 = (function (state_17968){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_17968);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18048){var ex__17136__auto__ = e18048;
var statearr_18049_18107 = state_17968;
(statearr_18049_18107[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_17968[(4)]))){
var statearr_18050_18108 = state_17968;
(statearr_18050_18108[(1)] = cljs.core.first((state_17968[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18109 = state_17968;
state_17968 = G__18109;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17133__auto__ = function(state_17968){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17133__auto____1.call(this,state_17968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17133__auto____0;
cljs$core$async$mult_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17133__auto____1;
return cljs$core$async$mult_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18051 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18051[(6)] = c__17207__auto___18052);

return statearr_18051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__18111 = arguments.length;
switch (G__18111) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_18113 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_18113(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_18114 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_18114(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_18115 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_18115(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_18116 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_18116(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_18117 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_18117(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___18128 = arguments.length;
var i__4737__auto___18129 = (0);
while(true){
if((i__4737__auto___18129 < len__4736__auto___18128)){
args__4742__auto__.push((arguments[i__4737__auto___18129]));

var G__18130 = (i__4737__auto___18129 + (1));
i__4737__auto___18129 = G__18130;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18122){
var map__18123 = p__18122;
var map__18123__$1 = (((((!((map__18123 == null))))?(((((map__18123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18123.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18123):map__18123);
var opts = map__18123__$1;
var statearr_18125_18131 = state;
(statearr_18125_18131[(1)] = cont_block);


var temp__5754__auto__ = cljs.core.async.do_alts((function (val){
var statearr_18126_18132 = state;
(statearr_18126_18132[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5754__auto__)){
var cb = temp__5754__auto__;
var statearr_18127_18133 = state;
(statearr_18127_18133[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18118){
var G__18119 = cljs.core.first(seq18118);
var seq18118__$1 = cljs.core.next(seq18118);
var G__18120 = cljs.core.first(seq18118__$1);
var seq18118__$2 = cljs.core.next(seq18118__$1);
var G__18121 = cljs.core.first(seq18118__$2);
var seq18118__$3 = cljs.core.next(seq18118__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18119,G__18120,G__18121,seq18118__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18134 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18134 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18135){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18135 = meta18135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18136,meta18135__$1){
var self__ = this;
var _18136__$1 = this;
return (new cljs.core.async.t_cljs$core$async18134(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18135__$1));
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18136){
var self__ = this;
var _18136__$1 = this;
return self__.meta18135;
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18134.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta18135], null);
}));

(cljs.core.async.t_cljs$core$async18134.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18134");

(cljs.core.async.t_cljs$core$async18134.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18134");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18134.
 */
cljs.core.async.__GT_t_cljs$core$async18134 = (function cljs$core$async$mix_$___GT_t_cljs$core$async18134(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18135){
return (new cljs.core.async.t_cljs$core$async18134(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18135));
});

}

return (new cljs.core.async.t_cljs$core$async18134(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17207__auto___18299 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18238){
var state_val_18239 = (state_18238[(1)]);
if((state_val_18239 === (7))){
var inst_18153 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
var statearr_18240_18300 = state_18238__$1;
(statearr_18240_18300[(2)] = inst_18153);

(statearr_18240_18300[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (20))){
var inst_18165 = (state_18238[(7)]);
var state_18238__$1 = state_18238;
var statearr_18241_18301 = state_18238__$1;
(statearr_18241_18301[(2)] = inst_18165);

(statearr_18241_18301[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (27))){
var state_18238__$1 = state_18238;
var statearr_18242_18302 = state_18238__$1;
(statearr_18242_18302[(2)] = null);

(statearr_18242_18302[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (1))){
var inst_18140 = (state_18238[(8)]);
var inst_18140__$1 = calc_state();
var inst_18142 = (inst_18140__$1 == null);
var inst_18143 = cljs.core.not(inst_18142);
var state_18238__$1 = (function (){var statearr_18243 = state_18238;
(statearr_18243[(8)] = inst_18140__$1);

return statearr_18243;
})();
if(inst_18143){
var statearr_18244_18303 = state_18238__$1;
(statearr_18244_18303[(1)] = (2));

} else {
var statearr_18245_18304 = state_18238__$1;
(statearr_18245_18304[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (24))){
var inst_18212 = (state_18238[(9)]);
var inst_18198 = (state_18238[(10)]);
var inst_18189 = (state_18238[(11)]);
var inst_18212__$1 = (inst_18189.cljs$core$IFn$_invoke$arity$1 ? inst_18189.cljs$core$IFn$_invoke$arity$1(inst_18198) : inst_18189.call(null,inst_18198));
var state_18238__$1 = (function (){var statearr_18246 = state_18238;
(statearr_18246[(9)] = inst_18212__$1);

return statearr_18246;
})();
if(cljs.core.truth_(inst_18212__$1)){
var statearr_18247_18305 = state_18238__$1;
(statearr_18247_18305[(1)] = (29));

} else {
var statearr_18248_18306 = state_18238__$1;
(statearr_18248_18306[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (4))){
var inst_18156 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18156)){
var statearr_18249_18307 = state_18238__$1;
(statearr_18249_18307[(1)] = (8));

} else {
var statearr_18250_18308 = state_18238__$1;
(statearr_18250_18308[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (15))){
var inst_18183 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18183)){
var statearr_18251_18309 = state_18238__$1;
(statearr_18251_18309[(1)] = (19));

} else {
var statearr_18252_18310 = state_18238__$1;
(statearr_18252_18310[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (21))){
var inst_18188 = (state_18238[(12)]);
var inst_18188__$1 = (state_18238[(2)]);
var inst_18189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18188__$1,cljs.core.cst$kw$solos);
var inst_18190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18188__$1,cljs.core.cst$kw$mutes);
var inst_18191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18188__$1,cljs.core.cst$kw$reads);
var state_18238__$1 = (function (){var statearr_18253 = state_18238;
(statearr_18253[(11)] = inst_18189);

(statearr_18253[(13)] = inst_18190);

(statearr_18253[(12)] = inst_18188__$1);

return statearr_18253;
})();
return cljs.core.async.ioc_alts_BANG_(state_18238__$1,(22),inst_18191);
} else {
if((state_val_18239 === (31))){
var inst_18220 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18220)){
var statearr_18254_18311 = state_18238__$1;
(statearr_18254_18311[(1)] = (32));

} else {
var statearr_18255_18312 = state_18238__$1;
(statearr_18255_18312[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (32))){
var inst_18197 = (state_18238[(14)]);
var state_18238__$1 = state_18238;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18238__$1,(35),out,inst_18197);
} else {
if((state_val_18239 === (33))){
var inst_18188 = (state_18238[(12)]);
var inst_18165 = inst_18188;
var state_18238__$1 = (function (){var statearr_18256 = state_18238;
(statearr_18256[(7)] = inst_18165);

return statearr_18256;
})();
var statearr_18257_18313 = state_18238__$1;
(statearr_18257_18313[(2)] = null);

(statearr_18257_18313[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (13))){
var inst_18165 = (state_18238[(7)]);
var inst_18172 = inst_18165.cljs$lang$protocol_mask$partition0$;
var inst_18173 = (inst_18172 & (64));
var inst_18174 = inst_18165.cljs$core$ISeq$;
var inst_18175 = (cljs.core.PROTOCOL_SENTINEL === inst_18174);
var inst_18176 = ((inst_18173) || (inst_18175));
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18176)){
var statearr_18258_18314 = state_18238__$1;
(statearr_18258_18314[(1)] = (16));

} else {
var statearr_18259_18315 = state_18238__$1;
(statearr_18259_18315[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (22))){
var inst_18197 = (state_18238[(14)]);
var inst_18198 = (state_18238[(10)]);
var inst_18196 = (state_18238[(2)]);
var inst_18197__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18196,(0),null);
var inst_18198__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18196,(1),null);
var inst_18199 = (inst_18197__$1 == null);
var inst_18200 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18198__$1,change);
var inst_18201 = ((inst_18199) || (inst_18200));
var state_18238__$1 = (function (){var statearr_18260 = state_18238;
(statearr_18260[(14)] = inst_18197__$1);

(statearr_18260[(10)] = inst_18198__$1);

return statearr_18260;
})();
if(cljs.core.truth_(inst_18201)){
var statearr_18261_18316 = state_18238__$1;
(statearr_18261_18316[(1)] = (23));

} else {
var statearr_18262_18317 = state_18238__$1;
(statearr_18262_18317[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (36))){
var inst_18188 = (state_18238[(12)]);
var inst_18165 = inst_18188;
var state_18238__$1 = (function (){var statearr_18263 = state_18238;
(statearr_18263[(7)] = inst_18165);

return statearr_18263;
})();
var statearr_18264_18318 = state_18238__$1;
(statearr_18264_18318[(2)] = null);

(statearr_18264_18318[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (29))){
var inst_18212 = (state_18238[(9)]);
var state_18238__$1 = state_18238;
var statearr_18265_18319 = state_18238__$1;
(statearr_18265_18319[(2)] = inst_18212);

(statearr_18265_18319[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (6))){
var state_18238__$1 = state_18238;
var statearr_18266_18320 = state_18238__$1;
(statearr_18266_18320[(2)] = false);

(statearr_18266_18320[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (28))){
var inst_18208 = (state_18238[(2)]);
var inst_18209 = calc_state();
var inst_18165 = inst_18209;
var state_18238__$1 = (function (){var statearr_18267 = state_18238;
(statearr_18267[(15)] = inst_18208);

(statearr_18267[(7)] = inst_18165);

return statearr_18267;
})();
var statearr_18268_18321 = state_18238__$1;
(statearr_18268_18321[(2)] = null);

(statearr_18268_18321[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (25))){
var inst_18234 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
var statearr_18269_18322 = state_18238__$1;
(statearr_18269_18322[(2)] = inst_18234);

(statearr_18269_18322[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (34))){
var inst_18232 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
var statearr_18270_18323 = state_18238__$1;
(statearr_18270_18323[(2)] = inst_18232);

(statearr_18270_18323[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (17))){
var state_18238__$1 = state_18238;
var statearr_18271_18324 = state_18238__$1;
(statearr_18271_18324[(2)] = false);

(statearr_18271_18324[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (3))){
var state_18238__$1 = state_18238;
var statearr_18272_18325 = state_18238__$1;
(statearr_18272_18325[(2)] = false);

(statearr_18272_18325[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (12))){
var inst_18236 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18238__$1,inst_18236);
} else {
if((state_val_18239 === (2))){
var inst_18140 = (state_18238[(8)]);
var inst_18145 = inst_18140.cljs$lang$protocol_mask$partition0$;
var inst_18146 = (inst_18145 & (64));
var inst_18147 = inst_18140.cljs$core$ISeq$;
var inst_18148 = (cljs.core.PROTOCOL_SENTINEL === inst_18147);
var inst_18149 = ((inst_18146) || (inst_18148));
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18149)){
var statearr_18273_18326 = state_18238__$1;
(statearr_18273_18326[(1)] = (5));

} else {
var statearr_18274_18327 = state_18238__$1;
(statearr_18274_18327[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (23))){
var inst_18197 = (state_18238[(14)]);
var inst_18203 = (inst_18197 == null);
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18203)){
var statearr_18275_18328 = state_18238__$1;
(statearr_18275_18328[(1)] = (26));

} else {
var statearr_18276_18329 = state_18238__$1;
(statearr_18276_18329[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (35))){
var inst_18223 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
if(cljs.core.truth_(inst_18223)){
var statearr_18277_18330 = state_18238__$1;
(statearr_18277_18330[(1)] = (36));

} else {
var statearr_18278_18331 = state_18238__$1;
(statearr_18278_18331[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (19))){
var inst_18165 = (state_18238[(7)]);
var inst_18185 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18165);
var state_18238__$1 = state_18238;
var statearr_18279_18332 = state_18238__$1;
(statearr_18279_18332[(2)] = inst_18185);

(statearr_18279_18332[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (11))){
var inst_18165 = (state_18238[(7)]);
var inst_18169 = (inst_18165 == null);
var inst_18170 = cljs.core.not(inst_18169);
var state_18238__$1 = state_18238;
if(inst_18170){
var statearr_18280_18333 = state_18238__$1;
(statearr_18280_18333[(1)] = (13));

} else {
var statearr_18281_18334 = state_18238__$1;
(statearr_18281_18334[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (9))){
var inst_18140 = (state_18238[(8)]);
var state_18238__$1 = state_18238;
var statearr_18282_18335 = state_18238__$1;
(statearr_18282_18335[(2)] = inst_18140);

(statearr_18282_18335[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (5))){
var state_18238__$1 = state_18238;
var statearr_18283_18336 = state_18238__$1;
(statearr_18283_18336[(2)] = true);

(statearr_18283_18336[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (14))){
var state_18238__$1 = state_18238;
var statearr_18284_18337 = state_18238__$1;
(statearr_18284_18337[(2)] = false);

(statearr_18284_18337[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (26))){
var inst_18198 = (state_18238[(10)]);
var inst_18205 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_18198);
var state_18238__$1 = state_18238;
var statearr_18285_18338 = state_18238__$1;
(statearr_18285_18338[(2)] = inst_18205);

(statearr_18285_18338[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (16))){
var state_18238__$1 = state_18238;
var statearr_18286_18339 = state_18238__$1;
(statearr_18286_18339[(2)] = true);

(statearr_18286_18339[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (38))){
var inst_18228 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
var statearr_18287_18340 = state_18238__$1;
(statearr_18287_18340[(2)] = inst_18228);

(statearr_18287_18340[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (30))){
var inst_18198 = (state_18238[(10)]);
var inst_18189 = (state_18238[(11)]);
var inst_18190 = (state_18238[(13)]);
var inst_18215 = cljs.core.empty_QMARK_(inst_18189);
var inst_18216 = (inst_18190.cljs$core$IFn$_invoke$arity$1 ? inst_18190.cljs$core$IFn$_invoke$arity$1(inst_18198) : inst_18190.call(null,inst_18198));
var inst_18217 = cljs.core.not(inst_18216);
var inst_18218 = ((inst_18215) && (inst_18217));
var state_18238__$1 = state_18238;
var statearr_18288_18341 = state_18238__$1;
(statearr_18288_18341[(2)] = inst_18218);

(statearr_18288_18341[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (10))){
var inst_18140 = (state_18238[(8)]);
var inst_18161 = (state_18238[(2)]);
var inst_18162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18161,cljs.core.cst$kw$solos);
var inst_18163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18161,cljs.core.cst$kw$mutes);
var inst_18164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18161,cljs.core.cst$kw$reads);
var inst_18165 = inst_18140;
var state_18238__$1 = (function (){var statearr_18289 = state_18238;
(statearr_18289[(7)] = inst_18165);

(statearr_18289[(16)] = inst_18164);

(statearr_18289[(17)] = inst_18162);

(statearr_18289[(18)] = inst_18163);

return statearr_18289;
})();
var statearr_18290_18342 = state_18238__$1;
(statearr_18290_18342[(2)] = null);

(statearr_18290_18342[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (18))){
var inst_18180 = (state_18238[(2)]);
var state_18238__$1 = state_18238;
var statearr_18291_18343 = state_18238__$1;
(statearr_18291_18343[(2)] = inst_18180);

(statearr_18291_18343[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (37))){
var state_18238__$1 = state_18238;
var statearr_18292_18344 = state_18238__$1;
(statearr_18292_18344[(2)] = null);

(statearr_18292_18344[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18239 === (8))){
var inst_18140 = (state_18238[(8)]);
var inst_18158 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18140);
var state_18238__$1 = state_18238;
var statearr_18293_18345 = state_18238__$1;
(statearr_18293_18345[(2)] = inst_18158);

(statearr_18293_18345[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__17133__auto__ = null;
var cljs$core$async$mix_$_state_machine__17133__auto____0 = (function (){
var statearr_18294 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18294[(0)] = cljs$core$async$mix_$_state_machine__17133__auto__);

(statearr_18294[(1)] = (1));

return statearr_18294;
});
var cljs$core$async$mix_$_state_machine__17133__auto____1 = (function (state_18238){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18238);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18295){var ex__17136__auto__ = e18295;
var statearr_18296_18346 = state_18238;
(statearr_18296_18346[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18238[(4)]))){
var statearr_18297_18347 = state_18238;
(statearr_18297_18347[(1)] = cljs.core.first((state_18238[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18348 = state_18238;
state_18238 = G__18348;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17133__auto__ = function(state_18238){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17133__auto____1.call(this,state_18238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17133__auto____0;
cljs$core$async$mix_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17133__auto____1;
return cljs$core$async$mix_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18298 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18298[(6)] = c__17207__auto___18299);

return statearr_18298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_18351 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_18351(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_18352 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_18352(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_18353 = (function() {
var G__18354 = null;
var G__18354__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__18354__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__18354 = function(p,v){
switch(arguments.length){
case 1:
return G__18354__1.call(this,p);
case 2:
return G__18354__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18354.cljs$core$IFn$_invoke$arity$1 = G__18354__1;
G__18354.cljs$core$IFn$_invoke$arity$2 = G__18354__2;
return G__18354;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18350 = arguments.length;
switch (G__18350) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18353.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18353.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18358 = arguments.length;
switch (G__18358) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__18356_SHARP_){
if(cljs.core.truth_((p1__18356_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18356_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18356_SHARP_.call(null,topic)))){
return p1__18356_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18356_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18359 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18359 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18360){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18360 = meta18360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18361,meta18360__$1){
var self__ = this;
var _18361__$1 = this;
return (new cljs.core.async.t_cljs$core$async18359(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18360__$1));
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18361){
var self__ = this;
var _18361__$1 = this;
return self__.meta18360;
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5754__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5754__auto__)){
var m = temp__5754__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async18359.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async18359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18360], null);
}));

(cljs.core.async.t_cljs$core$async18359.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18359");

(cljs.core.async.t_cljs$core$async18359.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18359");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18359.
 */
cljs.core.async.__GT_t_cljs$core$async18359 = (function cljs$core$async$__GT_t_cljs$core$async18359(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18360){
return (new cljs.core.async.t_cljs$core$async18359(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18360));
});

}

return (new cljs.core.async.t_cljs$core$async18359(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17207__auto___18480 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18433){
var state_val_18434 = (state_18433[(1)]);
if((state_val_18434 === (7))){
var inst_18429 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18435_18481 = state_18433__$1;
(statearr_18435_18481[(2)] = inst_18429);

(statearr_18435_18481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (20))){
var state_18433__$1 = state_18433;
var statearr_18436_18482 = state_18433__$1;
(statearr_18436_18482[(2)] = null);

(statearr_18436_18482[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (1))){
var state_18433__$1 = state_18433;
var statearr_18437_18483 = state_18433__$1;
(statearr_18437_18483[(2)] = null);

(statearr_18437_18483[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (24))){
var inst_18412 = (state_18433[(7)]);
var inst_18421 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18412);
var state_18433__$1 = state_18433;
var statearr_18438_18484 = state_18433__$1;
(statearr_18438_18484[(2)] = inst_18421);

(statearr_18438_18484[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (4))){
var inst_18364 = (state_18433[(8)]);
var inst_18364__$1 = (state_18433[(2)]);
var inst_18365 = (inst_18364__$1 == null);
var state_18433__$1 = (function (){var statearr_18439 = state_18433;
(statearr_18439[(8)] = inst_18364__$1);

return statearr_18439;
})();
if(cljs.core.truth_(inst_18365)){
var statearr_18440_18485 = state_18433__$1;
(statearr_18440_18485[(1)] = (5));

} else {
var statearr_18441_18486 = state_18433__$1;
(statearr_18441_18486[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (15))){
var inst_18406 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18442_18487 = state_18433__$1;
(statearr_18442_18487[(2)] = inst_18406);

(statearr_18442_18487[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (21))){
var inst_18426 = (state_18433[(2)]);
var state_18433__$1 = (function (){var statearr_18443 = state_18433;
(statearr_18443[(9)] = inst_18426);

return statearr_18443;
})();
var statearr_18444_18488 = state_18433__$1;
(statearr_18444_18488[(2)] = null);

(statearr_18444_18488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (13))){
var inst_18388 = (state_18433[(10)]);
var inst_18390 = cljs.core.chunked_seq_QMARK_(inst_18388);
var state_18433__$1 = state_18433;
if(inst_18390){
var statearr_18445_18489 = state_18433__$1;
(statearr_18445_18489[(1)] = (16));

} else {
var statearr_18446_18490 = state_18433__$1;
(statearr_18446_18490[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (22))){
var inst_18418 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
if(cljs.core.truth_(inst_18418)){
var statearr_18447_18491 = state_18433__$1;
(statearr_18447_18491[(1)] = (23));

} else {
var statearr_18448_18492 = state_18433__$1;
(statearr_18448_18492[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (6))){
var inst_18364 = (state_18433[(8)]);
var inst_18414 = (state_18433[(11)]);
var inst_18412 = (state_18433[(7)]);
var inst_18412__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18364) : topic_fn.call(null,inst_18364));
var inst_18413 = cljs.core.deref(mults);
var inst_18414__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18413,inst_18412__$1);
var state_18433__$1 = (function (){var statearr_18449 = state_18433;
(statearr_18449[(11)] = inst_18414__$1);

(statearr_18449[(7)] = inst_18412__$1);

return statearr_18449;
})();
if(cljs.core.truth_(inst_18414__$1)){
var statearr_18450_18493 = state_18433__$1;
(statearr_18450_18493[(1)] = (19));

} else {
var statearr_18451_18494 = state_18433__$1;
(statearr_18451_18494[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (25))){
var inst_18423 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18452_18495 = state_18433__$1;
(statearr_18452_18495[(2)] = inst_18423);

(statearr_18452_18495[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (17))){
var inst_18388 = (state_18433[(10)]);
var inst_18397 = cljs.core.first(inst_18388);
var inst_18398 = cljs.core.async.muxch_STAR_(inst_18397);
var inst_18399 = cljs.core.async.close_BANG_(inst_18398);
var inst_18400 = cljs.core.next(inst_18388);
var inst_18374 = inst_18400;
var inst_18375 = null;
var inst_18376 = (0);
var inst_18377 = (0);
var state_18433__$1 = (function (){var statearr_18453 = state_18433;
(statearr_18453[(12)] = inst_18377);

(statearr_18453[(13)] = inst_18376);

(statearr_18453[(14)] = inst_18375);

(statearr_18453[(15)] = inst_18374);

(statearr_18453[(16)] = inst_18399);

return statearr_18453;
})();
var statearr_18454_18496 = state_18433__$1;
(statearr_18454_18496[(2)] = null);

(statearr_18454_18496[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (3))){
var inst_18431 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18433__$1,inst_18431);
} else {
if((state_val_18434 === (12))){
var inst_18408 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18455_18497 = state_18433__$1;
(statearr_18455_18497[(2)] = inst_18408);

(statearr_18455_18497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (2))){
var state_18433__$1 = state_18433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18433__$1,(4),ch);
} else {
if((state_val_18434 === (23))){
var state_18433__$1 = state_18433;
var statearr_18456_18498 = state_18433__$1;
(statearr_18456_18498[(2)] = null);

(statearr_18456_18498[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (19))){
var inst_18364 = (state_18433[(8)]);
var inst_18414 = (state_18433[(11)]);
var inst_18416 = cljs.core.async.muxch_STAR_(inst_18414);
var state_18433__$1 = state_18433;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18433__$1,(22),inst_18416,inst_18364);
} else {
if((state_val_18434 === (11))){
var inst_18388 = (state_18433[(10)]);
var inst_18374 = (state_18433[(15)]);
var inst_18388__$1 = cljs.core.seq(inst_18374);
var state_18433__$1 = (function (){var statearr_18457 = state_18433;
(statearr_18457[(10)] = inst_18388__$1);

return statearr_18457;
})();
if(inst_18388__$1){
var statearr_18458_18499 = state_18433__$1;
(statearr_18458_18499[(1)] = (13));

} else {
var statearr_18459_18500 = state_18433__$1;
(statearr_18459_18500[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (9))){
var inst_18410 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18460_18501 = state_18433__$1;
(statearr_18460_18501[(2)] = inst_18410);

(statearr_18460_18501[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (5))){
var inst_18371 = cljs.core.deref(mults);
var inst_18372 = cljs.core.vals(inst_18371);
var inst_18373 = cljs.core.seq(inst_18372);
var inst_18374 = inst_18373;
var inst_18375 = null;
var inst_18376 = (0);
var inst_18377 = (0);
var state_18433__$1 = (function (){var statearr_18461 = state_18433;
(statearr_18461[(12)] = inst_18377);

(statearr_18461[(13)] = inst_18376);

(statearr_18461[(14)] = inst_18375);

(statearr_18461[(15)] = inst_18374);

return statearr_18461;
})();
var statearr_18462_18502 = state_18433__$1;
(statearr_18462_18502[(2)] = null);

(statearr_18462_18502[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (14))){
var state_18433__$1 = state_18433;
var statearr_18466_18503 = state_18433__$1;
(statearr_18466_18503[(2)] = null);

(statearr_18466_18503[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (16))){
var inst_18388 = (state_18433[(10)]);
var inst_18392 = cljs.core.chunk_first(inst_18388);
var inst_18393 = cljs.core.chunk_rest(inst_18388);
var inst_18394 = cljs.core.count(inst_18392);
var inst_18374 = inst_18393;
var inst_18375 = inst_18392;
var inst_18376 = inst_18394;
var inst_18377 = (0);
var state_18433__$1 = (function (){var statearr_18467 = state_18433;
(statearr_18467[(12)] = inst_18377);

(statearr_18467[(13)] = inst_18376);

(statearr_18467[(14)] = inst_18375);

(statearr_18467[(15)] = inst_18374);

return statearr_18467;
})();
var statearr_18468_18504 = state_18433__$1;
(statearr_18468_18504[(2)] = null);

(statearr_18468_18504[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (10))){
var inst_18377 = (state_18433[(12)]);
var inst_18376 = (state_18433[(13)]);
var inst_18375 = (state_18433[(14)]);
var inst_18374 = (state_18433[(15)]);
var inst_18382 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18375,inst_18377);
var inst_18383 = cljs.core.async.muxch_STAR_(inst_18382);
var inst_18384 = cljs.core.async.close_BANG_(inst_18383);
var inst_18385 = (inst_18377 + (1));
var tmp18463 = inst_18376;
var tmp18464 = inst_18375;
var tmp18465 = inst_18374;
var inst_18374__$1 = tmp18465;
var inst_18375__$1 = tmp18464;
var inst_18376__$1 = tmp18463;
var inst_18377__$1 = inst_18385;
var state_18433__$1 = (function (){var statearr_18469 = state_18433;
(statearr_18469[(12)] = inst_18377__$1);

(statearr_18469[(13)] = inst_18376__$1);

(statearr_18469[(14)] = inst_18375__$1);

(statearr_18469[(15)] = inst_18374__$1);

(statearr_18469[(17)] = inst_18384);

return statearr_18469;
})();
var statearr_18470_18505 = state_18433__$1;
(statearr_18470_18505[(2)] = null);

(statearr_18470_18505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (18))){
var inst_18403 = (state_18433[(2)]);
var state_18433__$1 = state_18433;
var statearr_18471_18506 = state_18433__$1;
(statearr_18471_18506[(2)] = inst_18403);

(statearr_18471_18506[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18434 === (8))){
var inst_18377 = (state_18433[(12)]);
var inst_18376 = (state_18433[(13)]);
var inst_18379 = (inst_18377 < inst_18376);
var inst_18380 = inst_18379;
var state_18433__$1 = state_18433;
if(cljs.core.truth_(inst_18380)){
var statearr_18472_18507 = state_18433__$1;
(statearr_18472_18507[(1)] = (10));

} else {
var statearr_18473_18508 = state_18433__$1;
(statearr_18473_18508[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_18474 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18474[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_18474[(1)] = (1));

return statearr_18474;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18433){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18433);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18475){var ex__17136__auto__ = e18475;
var statearr_18476_18509 = state_18433;
(statearr_18476_18509[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18433[(4)]))){
var statearr_18477_18510 = state_18433;
(statearr_18477_18510[(1)] = cljs.core.first((state_18433[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18511 = state_18433;
state_18433 = G__18511;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18433){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18478 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18478[(6)] = c__17207__auto___18480);

return statearr_18478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18513 = arguments.length;
switch (G__18513) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18516 = arguments.length;
switch (G__18516) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18519 = arguments.length;
switch (G__18519) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17207__auto___18597 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18562){
var state_val_18563 = (state_18562[(1)]);
if((state_val_18563 === (7))){
var state_18562__$1 = state_18562;
var statearr_18564_18598 = state_18562__$1;
(statearr_18564_18598[(2)] = null);

(statearr_18564_18598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (1))){
var state_18562__$1 = state_18562;
var statearr_18565_18599 = state_18562__$1;
(statearr_18565_18599[(2)] = null);

(statearr_18565_18599[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (4))){
var inst_18523 = (state_18562[(7)]);
var inst_18522 = (state_18562[(8)]);
var inst_18525 = (inst_18523 < inst_18522);
var state_18562__$1 = state_18562;
if(cljs.core.truth_(inst_18525)){
var statearr_18566_18600 = state_18562__$1;
(statearr_18566_18600[(1)] = (6));

} else {
var statearr_18567_18601 = state_18562__$1;
(statearr_18567_18601[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (15))){
var inst_18548 = (state_18562[(9)]);
var inst_18553 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18548);
var state_18562__$1 = state_18562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18562__$1,(17),out,inst_18553);
} else {
if((state_val_18563 === (13))){
var inst_18548 = (state_18562[(9)]);
var inst_18548__$1 = (state_18562[(2)]);
var inst_18549 = cljs.core.some(cljs.core.nil_QMARK_,inst_18548__$1);
var state_18562__$1 = (function (){var statearr_18568 = state_18562;
(statearr_18568[(9)] = inst_18548__$1);

return statearr_18568;
})();
if(cljs.core.truth_(inst_18549)){
var statearr_18569_18602 = state_18562__$1;
(statearr_18569_18602[(1)] = (14));

} else {
var statearr_18570_18603 = state_18562__$1;
(statearr_18570_18603[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (6))){
var state_18562__$1 = state_18562;
var statearr_18571_18604 = state_18562__$1;
(statearr_18571_18604[(2)] = null);

(statearr_18571_18604[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (17))){
var inst_18555 = (state_18562[(2)]);
var state_18562__$1 = (function (){var statearr_18573 = state_18562;
(statearr_18573[(10)] = inst_18555);

return statearr_18573;
})();
var statearr_18574_18605 = state_18562__$1;
(statearr_18574_18605[(2)] = null);

(statearr_18574_18605[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (3))){
var inst_18560 = (state_18562[(2)]);
var state_18562__$1 = state_18562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18562__$1,inst_18560);
} else {
if((state_val_18563 === (12))){
var _ = (function (){var statearr_18575 = state_18562;
(statearr_18575[(4)] = cljs.core.rest((state_18562[(4)])));

return statearr_18575;
})();
var state_18562__$1 = state_18562;
var ex18572 = (state_18562__$1[(2)]);
var statearr_18576_18606 = state_18562__$1;
(statearr_18576_18606[(5)] = ex18572);


if((ex18572 instanceof Object)){
var statearr_18577_18607 = state_18562__$1;
(statearr_18577_18607[(1)] = (11));

(statearr_18577_18607[(5)] = null);

} else {
throw ex18572;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (2))){
var inst_18521 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18522 = cnt;
var inst_18523 = (0);
var state_18562__$1 = (function (){var statearr_18578 = state_18562;
(statearr_18578[(11)] = inst_18521);

(statearr_18578[(7)] = inst_18523);

(statearr_18578[(8)] = inst_18522);

return statearr_18578;
})();
var statearr_18579_18608 = state_18562__$1;
(statearr_18579_18608[(2)] = null);

(statearr_18579_18608[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (11))){
var inst_18527 = (state_18562[(2)]);
var inst_18528 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18562__$1 = (function (){var statearr_18580 = state_18562;
(statearr_18580[(12)] = inst_18527);

return statearr_18580;
})();
var statearr_18581_18609 = state_18562__$1;
(statearr_18581_18609[(2)] = inst_18528);

(statearr_18581_18609[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (9))){
var inst_18523 = (state_18562[(7)]);
var _ = (function (){var statearr_18582 = state_18562;
(statearr_18582[(4)] = cljs.core.cons((12),(state_18562[(4)])));

return statearr_18582;
})();
var inst_18534 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18523) : chs__$1.call(null,inst_18523));
var inst_18535 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18523) : done.call(null,inst_18523));
var inst_18536 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18534,inst_18535);
var ___$1 = (function (){var statearr_18583 = state_18562;
(statearr_18583[(4)] = cljs.core.rest((state_18562[(4)])));

return statearr_18583;
})();
var state_18562__$1 = state_18562;
var statearr_18584_18610 = state_18562__$1;
(statearr_18584_18610[(2)] = inst_18536);

(statearr_18584_18610[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (5))){
var inst_18546 = (state_18562[(2)]);
var state_18562__$1 = (function (){var statearr_18585 = state_18562;
(statearr_18585[(13)] = inst_18546);

return statearr_18585;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18562__$1,(13),dchan);
} else {
if((state_val_18563 === (14))){
var inst_18551 = cljs.core.async.close_BANG_(out);
var state_18562__$1 = state_18562;
var statearr_18586_18611 = state_18562__$1;
(statearr_18586_18611[(2)] = inst_18551);

(statearr_18586_18611[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (16))){
var inst_18558 = (state_18562[(2)]);
var state_18562__$1 = state_18562;
var statearr_18587_18612 = state_18562__$1;
(statearr_18587_18612[(2)] = inst_18558);

(statearr_18587_18612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (10))){
var inst_18523 = (state_18562[(7)]);
var inst_18539 = (state_18562[(2)]);
var inst_18540 = (inst_18523 + (1));
var inst_18523__$1 = inst_18540;
var state_18562__$1 = (function (){var statearr_18588 = state_18562;
(statearr_18588[(14)] = inst_18539);

(statearr_18588[(7)] = inst_18523__$1);

return statearr_18588;
})();
var statearr_18589_18613 = state_18562__$1;
(statearr_18589_18613[(2)] = null);

(statearr_18589_18613[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18563 === (8))){
var inst_18544 = (state_18562[(2)]);
var state_18562__$1 = state_18562;
var statearr_18590_18614 = state_18562__$1;
(statearr_18590_18614[(2)] = inst_18544);

(statearr_18590_18614[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_18591 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18591[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_18591[(1)] = (1));

return statearr_18591;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18562){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18562);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18592){var ex__17136__auto__ = e18592;
var statearr_18593_18615 = state_18562;
(statearr_18593_18615[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18562[(4)]))){
var statearr_18594_18616 = state_18562;
(statearr_18594_18616[(1)] = cljs.core.first((state_18562[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18617 = state_18562;
state_18562 = G__18617;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18562){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18595 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18595[(6)] = c__17207__auto___18597);

return statearr_18595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18620 = arguments.length;
switch (G__18620) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___18675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18652){
var state_val_18653 = (state_18652[(1)]);
if((state_val_18653 === (7))){
var inst_18631 = (state_18652[(7)]);
var inst_18632 = (state_18652[(8)]);
var inst_18631__$1 = (state_18652[(2)]);
var inst_18632__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18631__$1,(0),null);
var inst_18633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18631__$1,(1),null);
var inst_18634 = (inst_18632__$1 == null);
var state_18652__$1 = (function (){var statearr_18654 = state_18652;
(statearr_18654[(9)] = inst_18633);

(statearr_18654[(7)] = inst_18631__$1);

(statearr_18654[(8)] = inst_18632__$1);

return statearr_18654;
})();
if(cljs.core.truth_(inst_18634)){
var statearr_18655_18676 = state_18652__$1;
(statearr_18655_18676[(1)] = (8));

} else {
var statearr_18656_18677 = state_18652__$1;
(statearr_18656_18677[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (1))){
var inst_18621 = cljs.core.vec(chs);
var inst_18622 = inst_18621;
var state_18652__$1 = (function (){var statearr_18657 = state_18652;
(statearr_18657[(10)] = inst_18622);

return statearr_18657;
})();
var statearr_18658_18678 = state_18652__$1;
(statearr_18658_18678[(2)] = null);

(statearr_18658_18678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (4))){
var inst_18622 = (state_18652[(10)]);
var state_18652__$1 = state_18652;
return cljs.core.async.ioc_alts_BANG_(state_18652__$1,(7),inst_18622);
} else {
if((state_val_18653 === (6))){
var inst_18648 = (state_18652[(2)]);
var state_18652__$1 = state_18652;
var statearr_18659_18679 = state_18652__$1;
(statearr_18659_18679[(2)] = inst_18648);

(statearr_18659_18679[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (3))){
var inst_18650 = (state_18652[(2)]);
var state_18652__$1 = state_18652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18652__$1,inst_18650);
} else {
if((state_val_18653 === (2))){
var inst_18622 = (state_18652[(10)]);
var inst_18624 = cljs.core.count(inst_18622);
var inst_18625 = (inst_18624 > (0));
var state_18652__$1 = state_18652;
if(cljs.core.truth_(inst_18625)){
var statearr_18661_18680 = state_18652__$1;
(statearr_18661_18680[(1)] = (4));

} else {
var statearr_18662_18681 = state_18652__$1;
(statearr_18662_18681[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (11))){
var inst_18622 = (state_18652[(10)]);
var inst_18641 = (state_18652[(2)]);
var tmp18660 = inst_18622;
var inst_18622__$1 = tmp18660;
var state_18652__$1 = (function (){var statearr_18663 = state_18652;
(statearr_18663[(11)] = inst_18641);

(statearr_18663[(10)] = inst_18622__$1);

return statearr_18663;
})();
var statearr_18664_18682 = state_18652__$1;
(statearr_18664_18682[(2)] = null);

(statearr_18664_18682[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (9))){
var inst_18632 = (state_18652[(8)]);
var state_18652__$1 = state_18652;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18652__$1,(11),out,inst_18632);
} else {
if((state_val_18653 === (5))){
var inst_18646 = cljs.core.async.close_BANG_(out);
var state_18652__$1 = state_18652;
var statearr_18665_18683 = state_18652__$1;
(statearr_18665_18683[(2)] = inst_18646);

(statearr_18665_18683[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (10))){
var inst_18644 = (state_18652[(2)]);
var state_18652__$1 = state_18652;
var statearr_18666_18684 = state_18652__$1;
(statearr_18666_18684[(2)] = inst_18644);

(statearr_18666_18684[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18653 === (8))){
var inst_18633 = (state_18652[(9)]);
var inst_18622 = (state_18652[(10)]);
var inst_18631 = (state_18652[(7)]);
var inst_18632 = (state_18652[(8)]);
var inst_18636 = (function (){var cs = inst_18622;
var vec__18627 = inst_18631;
var v = inst_18632;
var c = inst_18633;
return (function (p1__18618_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18618_SHARP_);
});
})();
var inst_18637 = cljs.core.filterv(inst_18636,inst_18622);
var inst_18622__$1 = inst_18637;
var state_18652__$1 = (function (){var statearr_18667 = state_18652;
(statearr_18667[(10)] = inst_18622__$1);

return statearr_18667;
})();
var statearr_18668_18685 = state_18652__$1;
(statearr_18668_18685[(2)] = null);

(statearr_18668_18685[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_18669 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18669[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_18669[(1)] = (1));

return statearr_18669;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18652){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18652);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18670){var ex__17136__auto__ = e18670;
var statearr_18671_18686 = state_18652;
(statearr_18671_18686[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18652[(4)]))){
var statearr_18672_18687 = state_18652;
(statearr_18672_18687[(1)] = cljs.core.first((state_18652[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18688 = state_18652;
state_18652 = G__18688;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18652){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18673 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18673[(6)] = c__17207__auto___18675);

return statearr_18673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18690 = arguments.length;
switch (G__18690) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___18736 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18714){
var state_val_18715 = (state_18714[(1)]);
if((state_val_18715 === (7))){
var inst_18696 = (state_18714[(7)]);
var inst_18696__$1 = (state_18714[(2)]);
var inst_18697 = (inst_18696__$1 == null);
var inst_18698 = cljs.core.not(inst_18697);
var state_18714__$1 = (function (){var statearr_18716 = state_18714;
(statearr_18716[(7)] = inst_18696__$1);

return statearr_18716;
})();
if(inst_18698){
var statearr_18717_18737 = state_18714__$1;
(statearr_18717_18737[(1)] = (8));

} else {
var statearr_18718_18738 = state_18714__$1;
(statearr_18718_18738[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (1))){
var inst_18691 = (0);
var state_18714__$1 = (function (){var statearr_18719 = state_18714;
(statearr_18719[(8)] = inst_18691);

return statearr_18719;
})();
var statearr_18720_18739 = state_18714__$1;
(statearr_18720_18739[(2)] = null);

(statearr_18720_18739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (4))){
var state_18714__$1 = state_18714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18714__$1,(7),ch);
} else {
if((state_val_18715 === (6))){
var inst_18709 = (state_18714[(2)]);
var state_18714__$1 = state_18714;
var statearr_18721_18740 = state_18714__$1;
(statearr_18721_18740[(2)] = inst_18709);

(statearr_18721_18740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (3))){
var inst_18711 = (state_18714[(2)]);
var inst_18712 = cljs.core.async.close_BANG_(out);
var state_18714__$1 = (function (){var statearr_18722 = state_18714;
(statearr_18722[(9)] = inst_18711);

return statearr_18722;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18714__$1,inst_18712);
} else {
if((state_val_18715 === (2))){
var inst_18691 = (state_18714[(8)]);
var inst_18693 = (inst_18691 < n);
var state_18714__$1 = state_18714;
if(cljs.core.truth_(inst_18693)){
var statearr_18723_18741 = state_18714__$1;
(statearr_18723_18741[(1)] = (4));

} else {
var statearr_18724_18742 = state_18714__$1;
(statearr_18724_18742[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (11))){
var inst_18691 = (state_18714[(8)]);
var inst_18701 = (state_18714[(2)]);
var inst_18702 = (inst_18691 + (1));
var inst_18691__$1 = inst_18702;
var state_18714__$1 = (function (){var statearr_18725 = state_18714;
(statearr_18725[(10)] = inst_18701);

(statearr_18725[(8)] = inst_18691__$1);

return statearr_18725;
})();
var statearr_18726_18743 = state_18714__$1;
(statearr_18726_18743[(2)] = null);

(statearr_18726_18743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (9))){
var state_18714__$1 = state_18714;
var statearr_18727_18744 = state_18714__$1;
(statearr_18727_18744[(2)] = null);

(statearr_18727_18744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (5))){
var state_18714__$1 = state_18714;
var statearr_18728_18745 = state_18714__$1;
(statearr_18728_18745[(2)] = null);

(statearr_18728_18745[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (10))){
var inst_18706 = (state_18714[(2)]);
var state_18714__$1 = state_18714;
var statearr_18729_18746 = state_18714__$1;
(statearr_18729_18746[(2)] = inst_18706);

(statearr_18729_18746[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18715 === (8))){
var inst_18696 = (state_18714[(7)]);
var state_18714__$1 = state_18714;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18714__$1,(11),out,inst_18696);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_18730 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18730[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_18730[(1)] = (1));

return statearr_18730;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18714){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18714);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18731){var ex__17136__auto__ = e18731;
var statearr_18732_18747 = state_18714;
(statearr_18732_18747[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18714[(4)]))){
var statearr_18733_18748 = state_18714;
(statearr_18733_18748[(1)] = cljs.core.first((state_18714[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18749 = state_18714;
state_18714 = G__18749;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18714){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18734 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18734[(6)] = c__17207__auto___18736);

return statearr_18734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18751 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18751 = (function (f,ch,meta18752){
this.f = f;
this.ch = ch;
this.meta18752 = meta18752;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18753,meta18752__$1){
var self__ = this;
var _18753__$1 = this;
return (new cljs.core.async.t_cljs$core$async18751(self__.f,self__.ch,meta18752__$1));
}));

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18753){
var self__ = this;
var _18753__$1 = this;
return self__.meta18752;
}));

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18754 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18754 = (function (f,ch,meta18752,_,fn1,meta18755){
this.f = f;
this.ch = ch;
this.meta18752 = meta18752;
this._ = _;
this.fn1 = fn1;
this.meta18755 = meta18755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18756,meta18755__$1){
var self__ = this;
var _18756__$1 = this;
return (new cljs.core.async.t_cljs$core$async18754(self__.f,self__.ch,self__.meta18752,self__._,self__.fn1,meta18755__$1));
}));

(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18756){
var self__ = this;
var _18756__$1 = this;
return self__.meta18755;
}));

(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async18754.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__18750_SHARP_){
var G__18757 = (((p1__18750_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18750_SHARP_) : self__.f.call(null,p1__18750_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18757) : f1.call(null,G__18757));
});
}));

(cljs.core.async.t_cljs$core$async18754.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18752,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18751], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18755], null);
}));

(cljs.core.async.t_cljs$core$async18754.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18754.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18754");

(cljs.core.async.t_cljs$core$async18754.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18754");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18754.
 */
cljs.core.async.__GT_t_cljs$core$async18754 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18754(f__$1,ch__$1,meta18752__$1,___$2,fn1__$1,meta18755){
return (new cljs.core.async.t_cljs$core$async18754(f__$1,ch__$1,meta18752__$1,___$2,fn1__$1,meta18755));
});

}

return (new cljs.core.async.t_cljs$core$async18754(self__.f,self__.ch,self__.meta18752,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18758 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18758) : self__.f.call(null,G__18758));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18751.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async18751.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18752], null);
}));

(cljs.core.async.t_cljs$core$async18751.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18751.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18751");

(cljs.core.async.t_cljs$core$async18751.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18751");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18751.
 */
cljs.core.async.__GT_t_cljs$core$async18751 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18751(f__$1,ch__$1,meta18752){
return (new cljs.core.async.t_cljs$core$async18751(f__$1,ch__$1,meta18752));
});

}

return (new cljs.core.async.t_cljs$core$async18751(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18759 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18759 = (function (f,ch,meta18760){
this.f = f;
this.ch = ch;
this.meta18760 = meta18760;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18761,meta18760__$1){
var self__ = this;
var _18761__$1 = this;
return (new cljs.core.async.t_cljs$core$async18759(self__.f,self__.ch,meta18760__$1));
}));

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18761){
var self__ = this;
var _18761__$1 = this;
return self__.meta18760;
}));

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18759.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async18759.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18760], null);
}));

(cljs.core.async.t_cljs$core$async18759.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18759.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18759");

(cljs.core.async.t_cljs$core$async18759.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18759");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18759.
 */
cljs.core.async.__GT_t_cljs$core$async18759 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18759(f__$1,ch__$1,meta18760){
return (new cljs.core.async.t_cljs$core$async18759(f__$1,ch__$1,meta18760));
});

}

return (new cljs.core.async.t_cljs$core$async18759(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18762 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18762 = (function (p,ch,meta18763){
this.p = p;
this.ch = ch;
this.meta18763 = meta18763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18764,meta18763__$1){
var self__ = this;
var _18764__$1 = this;
return (new cljs.core.async.t_cljs$core$async18762(self__.p,self__.ch,meta18763__$1));
}));

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18764){
var self__ = this;
var _18764__$1 = this;
return self__.meta18763;
}));

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18762.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async18762.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18763], null);
}));

(cljs.core.async.t_cljs$core$async18762.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18762.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18762");

(cljs.core.async.t_cljs$core$async18762.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async18762");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18762.
 */
cljs.core.async.__GT_t_cljs$core$async18762 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18762(p__$1,ch__$1,meta18763){
return (new cljs.core.async.t_cljs$core$async18762(p__$1,ch__$1,meta18763));
});

}

return (new cljs.core.async.t_cljs$core$async18762(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18766 = arguments.length;
switch (G__18766) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___18807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18787){
var state_val_18788 = (state_18787[(1)]);
if((state_val_18788 === (7))){
var inst_18783 = (state_18787[(2)]);
var state_18787__$1 = state_18787;
var statearr_18789_18808 = state_18787__$1;
(statearr_18789_18808[(2)] = inst_18783);

(statearr_18789_18808[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (1))){
var state_18787__$1 = state_18787;
var statearr_18790_18809 = state_18787__$1;
(statearr_18790_18809[(2)] = null);

(statearr_18790_18809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (4))){
var inst_18769 = (state_18787[(7)]);
var inst_18769__$1 = (state_18787[(2)]);
var inst_18770 = (inst_18769__$1 == null);
var state_18787__$1 = (function (){var statearr_18791 = state_18787;
(statearr_18791[(7)] = inst_18769__$1);

return statearr_18791;
})();
if(cljs.core.truth_(inst_18770)){
var statearr_18792_18810 = state_18787__$1;
(statearr_18792_18810[(1)] = (5));

} else {
var statearr_18793_18811 = state_18787__$1;
(statearr_18793_18811[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (6))){
var inst_18769 = (state_18787[(7)]);
var inst_18774 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18769) : p.call(null,inst_18769));
var state_18787__$1 = state_18787;
if(cljs.core.truth_(inst_18774)){
var statearr_18794_18812 = state_18787__$1;
(statearr_18794_18812[(1)] = (8));

} else {
var statearr_18795_18813 = state_18787__$1;
(statearr_18795_18813[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (3))){
var inst_18785 = (state_18787[(2)]);
var state_18787__$1 = state_18787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18787__$1,inst_18785);
} else {
if((state_val_18788 === (2))){
var state_18787__$1 = state_18787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18787__$1,(4),ch);
} else {
if((state_val_18788 === (11))){
var inst_18777 = (state_18787[(2)]);
var state_18787__$1 = state_18787;
var statearr_18796_18814 = state_18787__$1;
(statearr_18796_18814[(2)] = inst_18777);

(statearr_18796_18814[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (9))){
var state_18787__$1 = state_18787;
var statearr_18797_18815 = state_18787__$1;
(statearr_18797_18815[(2)] = null);

(statearr_18797_18815[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (5))){
var inst_18772 = cljs.core.async.close_BANG_(out);
var state_18787__$1 = state_18787;
var statearr_18798_18816 = state_18787__$1;
(statearr_18798_18816[(2)] = inst_18772);

(statearr_18798_18816[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (10))){
var inst_18780 = (state_18787[(2)]);
var state_18787__$1 = (function (){var statearr_18799 = state_18787;
(statearr_18799[(8)] = inst_18780);

return statearr_18799;
})();
var statearr_18800_18817 = state_18787__$1;
(statearr_18800_18817[(2)] = null);

(statearr_18800_18817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18788 === (8))){
var inst_18769 = (state_18787[(7)]);
var state_18787__$1 = state_18787;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18787__$1,(11),out,inst_18769);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_18801 = [null,null,null,null,null,null,null,null,null];
(statearr_18801[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_18801[(1)] = (1));

return statearr_18801;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18787){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18787);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18802){var ex__17136__auto__ = e18802;
var statearr_18803_18818 = state_18787;
(statearr_18803_18818[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18787[(4)]))){
var statearr_18804_18819 = state_18787;
(statearr_18804_18819[(1)] = cljs.core.first((state_18787[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18820 = state_18787;
state_18787 = G__18820;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18787){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18805 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18805[(6)] = c__17207__auto___18807);

return statearr_18805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18822 = arguments.length;
switch (G__18822) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18885){
var state_val_18886 = (state_18885[(1)]);
if((state_val_18886 === (7))){
var inst_18881 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18887_18926 = state_18885__$1;
(statearr_18887_18926[(2)] = inst_18881);

(statearr_18887_18926[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (20))){
var inst_18851 = (state_18885[(7)]);
var inst_18862 = (state_18885[(2)]);
var inst_18863 = cljs.core.next(inst_18851);
var inst_18837 = inst_18863;
var inst_18838 = null;
var inst_18839 = (0);
var inst_18840 = (0);
var state_18885__$1 = (function (){var statearr_18888 = state_18885;
(statearr_18888[(8)] = inst_18839);

(statearr_18888[(9)] = inst_18838);

(statearr_18888[(10)] = inst_18837);

(statearr_18888[(11)] = inst_18840);

(statearr_18888[(12)] = inst_18862);

return statearr_18888;
})();
var statearr_18889_18927 = state_18885__$1;
(statearr_18889_18927[(2)] = null);

(statearr_18889_18927[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (1))){
var state_18885__$1 = state_18885;
var statearr_18890_18928 = state_18885__$1;
(statearr_18890_18928[(2)] = null);

(statearr_18890_18928[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (4))){
var inst_18826 = (state_18885[(13)]);
var inst_18826__$1 = (state_18885[(2)]);
var inst_18827 = (inst_18826__$1 == null);
var state_18885__$1 = (function (){var statearr_18891 = state_18885;
(statearr_18891[(13)] = inst_18826__$1);

return statearr_18891;
})();
if(cljs.core.truth_(inst_18827)){
var statearr_18892_18929 = state_18885__$1;
(statearr_18892_18929[(1)] = (5));

} else {
var statearr_18893_18930 = state_18885__$1;
(statearr_18893_18930[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (15))){
var state_18885__$1 = state_18885;
var statearr_18897_18931 = state_18885__$1;
(statearr_18897_18931[(2)] = null);

(statearr_18897_18931[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (21))){
var state_18885__$1 = state_18885;
var statearr_18898_18932 = state_18885__$1;
(statearr_18898_18932[(2)] = null);

(statearr_18898_18932[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (13))){
var inst_18839 = (state_18885[(8)]);
var inst_18838 = (state_18885[(9)]);
var inst_18837 = (state_18885[(10)]);
var inst_18840 = (state_18885[(11)]);
var inst_18847 = (state_18885[(2)]);
var inst_18848 = (inst_18840 + (1));
var tmp18894 = inst_18839;
var tmp18895 = inst_18838;
var tmp18896 = inst_18837;
var inst_18837__$1 = tmp18896;
var inst_18838__$1 = tmp18895;
var inst_18839__$1 = tmp18894;
var inst_18840__$1 = inst_18848;
var state_18885__$1 = (function (){var statearr_18899 = state_18885;
(statearr_18899[(8)] = inst_18839__$1);

(statearr_18899[(9)] = inst_18838__$1);

(statearr_18899[(10)] = inst_18837__$1);

(statearr_18899[(11)] = inst_18840__$1);

(statearr_18899[(14)] = inst_18847);

return statearr_18899;
})();
var statearr_18900_18933 = state_18885__$1;
(statearr_18900_18933[(2)] = null);

(statearr_18900_18933[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (22))){
var state_18885__$1 = state_18885;
var statearr_18901_18934 = state_18885__$1;
(statearr_18901_18934[(2)] = null);

(statearr_18901_18934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (6))){
var inst_18826 = (state_18885[(13)]);
var inst_18835 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18826) : f.call(null,inst_18826));
var inst_18836 = cljs.core.seq(inst_18835);
var inst_18837 = inst_18836;
var inst_18838 = null;
var inst_18839 = (0);
var inst_18840 = (0);
var state_18885__$1 = (function (){var statearr_18902 = state_18885;
(statearr_18902[(8)] = inst_18839);

(statearr_18902[(9)] = inst_18838);

(statearr_18902[(10)] = inst_18837);

(statearr_18902[(11)] = inst_18840);

return statearr_18902;
})();
var statearr_18903_18935 = state_18885__$1;
(statearr_18903_18935[(2)] = null);

(statearr_18903_18935[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (17))){
var inst_18851 = (state_18885[(7)]);
var inst_18855 = cljs.core.chunk_first(inst_18851);
var inst_18856 = cljs.core.chunk_rest(inst_18851);
var inst_18857 = cljs.core.count(inst_18855);
var inst_18837 = inst_18856;
var inst_18838 = inst_18855;
var inst_18839 = inst_18857;
var inst_18840 = (0);
var state_18885__$1 = (function (){var statearr_18904 = state_18885;
(statearr_18904[(8)] = inst_18839);

(statearr_18904[(9)] = inst_18838);

(statearr_18904[(10)] = inst_18837);

(statearr_18904[(11)] = inst_18840);

return statearr_18904;
})();
var statearr_18905_18936 = state_18885__$1;
(statearr_18905_18936[(2)] = null);

(statearr_18905_18936[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (3))){
var inst_18883 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18885__$1,inst_18883);
} else {
if((state_val_18886 === (12))){
var inst_18871 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18906_18937 = state_18885__$1;
(statearr_18906_18937[(2)] = inst_18871);

(statearr_18906_18937[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (2))){
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18885__$1,(4),in$);
} else {
if((state_val_18886 === (23))){
var inst_18879 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18907_18938 = state_18885__$1;
(statearr_18907_18938[(2)] = inst_18879);

(statearr_18907_18938[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (19))){
var inst_18866 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18908_18939 = state_18885__$1;
(statearr_18908_18939[(2)] = inst_18866);

(statearr_18908_18939[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (11))){
var inst_18851 = (state_18885[(7)]);
var inst_18837 = (state_18885[(10)]);
var inst_18851__$1 = cljs.core.seq(inst_18837);
var state_18885__$1 = (function (){var statearr_18909 = state_18885;
(statearr_18909[(7)] = inst_18851__$1);

return statearr_18909;
})();
if(inst_18851__$1){
var statearr_18910_18940 = state_18885__$1;
(statearr_18910_18940[(1)] = (14));

} else {
var statearr_18911_18941 = state_18885__$1;
(statearr_18911_18941[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (9))){
var inst_18873 = (state_18885[(2)]);
var inst_18874 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18885__$1 = (function (){var statearr_18912 = state_18885;
(statearr_18912[(15)] = inst_18873);

return statearr_18912;
})();
if(cljs.core.truth_(inst_18874)){
var statearr_18913_18942 = state_18885__$1;
(statearr_18913_18942[(1)] = (21));

} else {
var statearr_18914_18943 = state_18885__$1;
(statearr_18914_18943[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (5))){
var inst_18829 = cljs.core.async.close_BANG_(out);
var state_18885__$1 = state_18885;
var statearr_18915_18944 = state_18885__$1;
(statearr_18915_18944[(2)] = inst_18829);

(statearr_18915_18944[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (14))){
var inst_18851 = (state_18885[(7)]);
var inst_18853 = cljs.core.chunked_seq_QMARK_(inst_18851);
var state_18885__$1 = state_18885;
if(inst_18853){
var statearr_18916_18945 = state_18885__$1;
(statearr_18916_18945[(1)] = (17));

} else {
var statearr_18917_18946 = state_18885__$1;
(statearr_18917_18946[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (16))){
var inst_18869 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18918_18947 = state_18885__$1;
(statearr_18918_18947[(2)] = inst_18869);

(statearr_18918_18947[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18886 === (10))){
var inst_18838 = (state_18885[(9)]);
var inst_18840 = (state_18885[(11)]);
var inst_18845 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18838,inst_18840);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18885__$1,(13),out,inst_18845);
} else {
if((state_val_18886 === (18))){
var inst_18851 = (state_18885[(7)]);
var inst_18860 = cljs.core.first(inst_18851);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18885__$1,(20),out,inst_18860);
} else {
if((state_val_18886 === (8))){
var inst_18839 = (state_18885[(8)]);
var inst_18840 = (state_18885[(11)]);
var inst_18842 = (inst_18840 < inst_18839);
var inst_18843 = inst_18842;
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18843)){
var statearr_18919_18948 = state_18885__$1;
(statearr_18919_18948[(1)] = (10));

} else {
var statearr_18920_18949 = state_18885__$1;
(statearr_18920_18949[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____0 = (function (){
var statearr_18921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18921[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__);

(statearr_18921[(1)] = (1));

return statearr_18921;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____1 = (function (state_18885){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18885);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e18922){var ex__17136__auto__ = e18922;
var statearr_18923_18950 = state_18885;
(statearr_18923_18950[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18885[(4)]))){
var statearr_18924_18951 = state_18885;
(statearr_18924_18951[(1)] = cljs.core.first((state_18885[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__18952 = state_18885;
state_18885 = G__18952;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__ = function(state_18885){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____1.call(this,state_18885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17133__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_18925 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_18925[(6)] = c__17207__auto__);

return statearr_18925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18954 = arguments.length;
switch (G__18954) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18957 = arguments.length;
switch (G__18957) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18960 = arguments.length;
switch (G__18960) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___19008 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_18984){
var state_val_18985 = (state_18984[(1)]);
if((state_val_18985 === (7))){
var inst_18979 = (state_18984[(2)]);
var state_18984__$1 = state_18984;
var statearr_18986_19009 = state_18984__$1;
(statearr_18986_19009[(2)] = inst_18979);

(statearr_18986_19009[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (1))){
var inst_18961 = null;
var state_18984__$1 = (function (){var statearr_18987 = state_18984;
(statearr_18987[(7)] = inst_18961);

return statearr_18987;
})();
var statearr_18988_19010 = state_18984__$1;
(statearr_18988_19010[(2)] = null);

(statearr_18988_19010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (4))){
var inst_18964 = (state_18984[(8)]);
var inst_18964__$1 = (state_18984[(2)]);
var inst_18965 = (inst_18964__$1 == null);
var inst_18966 = cljs.core.not(inst_18965);
var state_18984__$1 = (function (){var statearr_18989 = state_18984;
(statearr_18989[(8)] = inst_18964__$1);

return statearr_18989;
})();
if(inst_18966){
var statearr_18990_19011 = state_18984__$1;
(statearr_18990_19011[(1)] = (5));

} else {
var statearr_18991_19012 = state_18984__$1;
(statearr_18991_19012[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (6))){
var state_18984__$1 = state_18984;
var statearr_18992_19013 = state_18984__$1;
(statearr_18992_19013[(2)] = null);

(statearr_18992_19013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (3))){
var inst_18981 = (state_18984[(2)]);
var inst_18982 = cljs.core.async.close_BANG_(out);
var state_18984__$1 = (function (){var statearr_18993 = state_18984;
(statearr_18993[(9)] = inst_18981);

return statearr_18993;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18984__$1,inst_18982);
} else {
if((state_val_18985 === (2))){
var state_18984__$1 = state_18984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18984__$1,(4),ch);
} else {
if((state_val_18985 === (11))){
var inst_18964 = (state_18984[(8)]);
var inst_18973 = (state_18984[(2)]);
var inst_18961 = inst_18964;
var state_18984__$1 = (function (){var statearr_18994 = state_18984;
(statearr_18994[(7)] = inst_18961);

(statearr_18994[(10)] = inst_18973);

return statearr_18994;
})();
var statearr_18995_19014 = state_18984__$1;
(statearr_18995_19014[(2)] = null);

(statearr_18995_19014[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (9))){
var inst_18964 = (state_18984[(8)]);
var state_18984__$1 = state_18984;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18984__$1,(11),out,inst_18964);
} else {
if((state_val_18985 === (5))){
var inst_18964 = (state_18984[(8)]);
var inst_18961 = (state_18984[(7)]);
var inst_18968 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18964,inst_18961);
var state_18984__$1 = state_18984;
if(inst_18968){
var statearr_18997_19015 = state_18984__$1;
(statearr_18997_19015[(1)] = (8));

} else {
var statearr_18998_19016 = state_18984__$1;
(statearr_18998_19016[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (10))){
var inst_18976 = (state_18984[(2)]);
var state_18984__$1 = state_18984;
var statearr_18999_19017 = state_18984__$1;
(statearr_18999_19017[(2)] = inst_18976);

(statearr_18999_19017[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18985 === (8))){
var inst_18961 = (state_18984[(7)]);
var tmp18996 = inst_18961;
var inst_18961__$1 = tmp18996;
var state_18984__$1 = (function (){var statearr_19000 = state_18984;
(statearr_19000[(7)] = inst_18961__$1);

return statearr_19000;
})();
var statearr_19001_19018 = state_18984__$1;
(statearr_19001_19018[(2)] = null);

(statearr_19001_19018[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_19002 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19002[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_19002[(1)] = (1));

return statearr_19002;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_18984){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_18984);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e19003){var ex__17136__auto__ = e19003;
var statearr_19004_19019 = state_18984;
(statearr_19004_19019[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_18984[(4)]))){
var statearr_19005_19020 = state_18984;
(statearr_19005_19020[(1)] = cljs.core.first((state_18984[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__19021 = state_18984;
state_18984 = G__19021;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_18984){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_18984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_19006 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_19006[(6)] = c__17207__auto___19008);

return statearr_19006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__19023 = arguments.length;
switch (G__19023) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___19090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_19061){
var state_val_19062 = (state_19061[(1)]);
if((state_val_19062 === (7))){
var inst_19057 = (state_19061[(2)]);
var state_19061__$1 = state_19061;
var statearr_19063_19091 = state_19061__$1;
(statearr_19063_19091[(2)] = inst_19057);

(statearr_19063_19091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (1))){
var inst_19024 = (new Array(n));
var inst_19025 = inst_19024;
var inst_19026 = (0);
var state_19061__$1 = (function (){var statearr_19064 = state_19061;
(statearr_19064[(7)] = inst_19026);

(statearr_19064[(8)] = inst_19025);

return statearr_19064;
})();
var statearr_19065_19092 = state_19061__$1;
(statearr_19065_19092[(2)] = null);

(statearr_19065_19092[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (4))){
var inst_19029 = (state_19061[(9)]);
var inst_19029__$1 = (state_19061[(2)]);
var inst_19030 = (inst_19029__$1 == null);
var inst_19031 = cljs.core.not(inst_19030);
var state_19061__$1 = (function (){var statearr_19066 = state_19061;
(statearr_19066[(9)] = inst_19029__$1);

return statearr_19066;
})();
if(inst_19031){
var statearr_19067_19093 = state_19061__$1;
(statearr_19067_19093[(1)] = (5));

} else {
var statearr_19068_19094 = state_19061__$1;
(statearr_19068_19094[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (15))){
var inst_19051 = (state_19061[(2)]);
var state_19061__$1 = state_19061;
var statearr_19069_19095 = state_19061__$1;
(statearr_19069_19095[(2)] = inst_19051);

(statearr_19069_19095[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (13))){
var state_19061__$1 = state_19061;
var statearr_19070_19096 = state_19061__$1;
(statearr_19070_19096[(2)] = null);

(statearr_19070_19096[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (6))){
var inst_19026 = (state_19061[(7)]);
var inst_19047 = (inst_19026 > (0));
var state_19061__$1 = state_19061;
if(cljs.core.truth_(inst_19047)){
var statearr_19071_19097 = state_19061__$1;
(statearr_19071_19097[(1)] = (12));

} else {
var statearr_19072_19098 = state_19061__$1;
(statearr_19072_19098[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (3))){
var inst_19059 = (state_19061[(2)]);
var state_19061__$1 = state_19061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19061__$1,inst_19059);
} else {
if((state_val_19062 === (12))){
var inst_19025 = (state_19061[(8)]);
var inst_19049 = cljs.core.vec(inst_19025);
var state_19061__$1 = state_19061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19061__$1,(15),out,inst_19049);
} else {
if((state_val_19062 === (2))){
var state_19061__$1 = state_19061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19061__$1,(4),ch);
} else {
if((state_val_19062 === (11))){
var inst_19041 = (state_19061[(2)]);
var inst_19042 = (new Array(n));
var inst_19025 = inst_19042;
var inst_19026 = (0);
var state_19061__$1 = (function (){var statearr_19073 = state_19061;
(statearr_19073[(10)] = inst_19041);

(statearr_19073[(7)] = inst_19026);

(statearr_19073[(8)] = inst_19025);

return statearr_19073;
})();
var statearr_19074_19099 = state_19061__$1;
(statearr_19074_19099[(2)] = null);

(statearr_19074_19099[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (9))){
var inst_19025 = (state_19061[(8)]);
var inst_19039 = cljs.core.vec(inst_19025);
var state_19061__$1 = state_19061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19061__$1,(11),out,inst_19039);
} else {
if((state_val_19062 === (5))){
var inst_19034 = (state_19061[(11)]);
var inst_19029 = (state_19061[(9)]);
var inst_19026 = (state_19061[(7)]);
var inst_19025 = (state_19061[(8)]);
var inst_19033 = (inst_19025[inst_19026] = inst_19029);
var inst_19034__$1 = (inst_19026 + (1));
var inst_19035 = (inst_19034__$1 < n);
var state_19061__$1 = (function (){var statearr_19075 = state_19061;
(statearr_19075[(11)] = inst_19034__$1);

(statearr_19075[(12)] = inst_19033);

return statearr_19075;
})();
if(cljs.core.truth_(inst_19035)){
var statearr_19076_19100 = state_19061__$1;
(statearr_19076_19100[(1)] = (8));

} else {
var statearr_19077_19101 = state_19061__$1;
(statearr_19077_19101[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (14))){
var inst_19054 = (state_19061[(2)]);
var inst_19055 = cljs.core.async.close_BANG_(out);
var state_19061__$1 = (function (){var statearr_19079 = state_19061;
(statearr_19079[(13)] = inst_19054);

return statearr_19079;
})();
var statearr_19080_19102 = state_19061__$1;
(statearr_19080_19102[(2)] = inst_19055);

(statearr_19080_19102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (10))){
var inst_19045 = (state_19061[(2)]);
var state_19061__$1 = state_19061;
var statearr_19081_19103 = state_19061__$1;
(statearr_19081_19103[(2)] = inst_19045);

(statearr_19081_19103[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19062 === (8))){
var inst_19034 = (state_19061[(11)]);
var inst_19025 = (state_19061[(8)]);
var tmp19078 = inst_19025;
var inst_19025__$1 = tmp19078;
var inst_19026 = inst_19034;
var state_19061__$1 = (function (){var statearr_19082 = state_19061;
(statearr_19082[(7)] = inst_19026);

(statearr_19082[(8)] = inst_19025__$1);

return statearr_19082;
})();
var statearr_19083_19104 = state_19061__$1;
(statearr_19083_19104[(2)] = null);

(statearr_19083_19104[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_19084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19084[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_19084[(1)] = (1));

return statearr_19084;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_19061){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_19061);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e19085){var ex__17136__auto__ = e19085;
var statearr_19086_19105 = state_19061;
(statearr_19086_19105[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_19061[(4)]))){
var statearr_19087_19106 = state_19061;
(statearr_19087_19106[(1)] = cljs.core.first((state_19061[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__19107 = state_19061;
state_19061 = G__19107;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_19061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_19061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_19088 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_19088[(6)] = c__17207__auto___19090);

return statearr_19088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__19109 = arguments.length;
switch (G__19109) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17207__auto___19180 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_19151){
var state_val_19152 = (state_19151[(1)]);
if((state_val_19152 === (7))){
var inst_19147 = (state_19151[(2)]);
var state_19151__$1 = state_19151;
var statearr_19153_19181 = state_19151__$1;
(statearr_19153_19181[(2)] = inst_19147);

(statearr_19153_19181[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (1))){
var inst_19110 = [];
var inst_19111 = inst_19110;
var inst_19112 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_19151__$1 = (function (){var statearr_19154 = state_19151;
(statearr_19154[(7)] = inst_19111);

(statearr_19154[(8)] = inst_19112);

return statearr_19154;
})();
var statearr_19155_19182 = state_19151__$1;
(statearr_19155_19182[(2)] = null);

(statearr_19155_19182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (4))){
var inst_19115 = (state_19151[(9)]);
var inst_19115__$1 = (state_19151[(2)]);
var inst_19116 = (inst_19115__$1 == null);
var inst_19117 = cljs.core.not(inst_19116);
var state_19151__$1 = (function (){var statearr_19156 = state_19151;
(statearr_19156[(9)] = inst_19115__$1);

return statearr_19156;
})();
if(inst_19117){
var statearr_19157_19183 = state_19151__$1;
(statearr_19157_19183[(1)] = (5));

} else {
var statearr_19158_19184 = state_19151__$1;
(statearr_19158_19184[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (15))){
var inst_19141 = (state_19151[(2)]);
var state_19151__$1 = state_19151;
var statearr_19159_19185 = state_19151__$1;
(statearr_19159_19185[(2)] = inst_19141);

(statearr_19159_19185[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (13))){
var state_19151__$1 = state_19151;
var statearr_19160_19186 = state_19151__$1;
(statearr_19160_19186[(2)] = null);

(statearr_19160_19186[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (6))){
var inst_19111 = (state_19151[(7)]);
var inst_19136 = inst_19111.length;
var inst_19137 = (inst_19136 > (0));
var state_19151__$1 = state_19151;
if(cljs.core.truth_(inst_19137)){
var statearr_19161_19187 = state_19151__$1;
(statearr_19161_19187[(1)] = (12));

} else {
var statearr_19162_19188 = state_19151__$1;
(statearr_19162_19188[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (3))){
var inst_19149 = (state_19151[(2)]);
var state_19151__$1 = state_19151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19151__$1,inst_19149);
} else {
if((state_val_19152 === (12))){
var inst_19111 = (state_19151[(7)]);
var inst_19139 = cljs.core.vec(inst_19111);
var state_19151__$1 = state_19151;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19151__$1,(15),out,inst_19139);
} else {
if((state_val_19152 === (2))){
var state_19151__$1 = state_19151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19151__$1,(4),ch);
} else {
if((state_val_19152 === (11))){
var inst_19119 = (state_19151[(10)]);
var inst_19115 = (state_19151[(9)]);
var inst_19129 = (state_19151[(2)]);
var inst_19130 = [];
var inst_19131 = inst_19130.push(inst_19115);
var inst_19111 = inst_19130;
var inst_19112 = inst_19119;
var state_19151__$1 = (function (){var statearr_19163 = state_19151;
(statearr_19163[(11)] = inst_19129);

(statearr_19163[(7)] = inst_19111);

(statearr_19163[(8)] = inst_19112);

(statearr_19163[(12)] = inst_19131);

return statearr_19163;
})();
var statearr_19164_19189 = state_19151__$1;
(statearr_19164_19189[(2)] = null);

(statearr_19164_19189[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (9))){
var inst_19111 = (state_19151[(7)]);
var inst_19127 = cljs.core.vec(inst_19111);
var state_19151__$1 = state_19151;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19151__$1,(11),out,inst_19127);
} else {
if((state_val_19152 === (5))){
var inst_19112 = (state_19151[(8)]);
var inst_19119 = (state_19151[(10)]);
var inst_19115 = (state_19151[(9)]);
var inst_19119__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19115) : f.call(null,inst_19115));
var inst_19120 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19119__$1,inst_19112);
var inst_19121 = cljs.core.keyword_identical_QMARK_(inst_19112,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_19122 = ((inst_19120) || (inst_19121));
var state_19151__$1 = (function (){var statearr_19165 = state_19151;
(statearr_19165[(10)] = inst_19119__$1);

return statearr_19165;
})();
if(cljs.core.truth_(inst_19122)){
var statearr_19166_19190 = state_19151__$1;
(statearr_19166_19190[(1)] = (8));

} else {
var statearr_19167_19191 = state_19151__$1;
(statearr_19167_19191[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (14))){
var inst_19144 = (state_19151[(2)]);
var inst_19145 = cljs.core.async.close_BANG_(out);
var state_19151__$1 = (function (){var statearr_19169 = state_19151;
(statearr_19169[(13)] = inst_19144);

return statearr_19169;
})();
var statearr_19170_19192 = state_19151__$1;
(statearr_19170_19192[(2)] = inst_19145);

(statearr_19170_19192[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (10))){
var inst_19134 = (state_19151[(2)]);
var state_19151__$1 = state_19151;
var statearr_19171_19193 = state_19151__$1;
(statearr_19171_19193[(2)] = inst_19134);

(statearr_19171_19193[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19152 === (8))){
var inst_19111 = (state_19151[(7)]);
var inst_19119 = (state_19151[(10)]);
var inst_19115 = (state_19151[(9)]);
var inst_19124 = inst_19111.push(inst_19115);
var tmp19168 = inst_19111;
var inst_19111__$1 = tmp19168;
var inst_19112 = inst_19119;
var state_19151__$1 = (function (){var statearr_19172 = state_19151;
(statearr_19172[(14)] = inst_19124);

(statearr_19172[(7)] = inst_19111__$1);

(statearr_19172[(8)] = inst_19112);

return statearr_19172;
})();
var statearr_19173_19194 = state_19151__$1;
(statearr_19173_19194[(2)] = null);

(statearr_19173_19194[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17133__auto__ = null;
var cljs$core$async$state_machine__17133__auto____0 = (function (){
var statearr_19174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19174[(0)] = cljs$core$async$state_machine__17133__auto__);

(statearr_19174[(1)] = (1));

return statearr_19174;
});
var cljs$core$async$state_machine__17133__auto____1 = (function (state_19151){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_19151);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e19175){var ex__17136__auto__ = e19175;
var statearr_19176_19195 = state_19151;
(statearr_19176_19195[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_19151[(4)]))){
var statearr_19177_19196 = state_19151;
(statearr_19177_19196[(1)] = cljs.core.first((state_19151[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__19197 = state_19151;
state_19151 = G__19197;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
cljs$core$async$state_machine__17133__auto__ = function(state_19151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17133__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17133__auto____1.call(this,state_19151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17133__auto____0;
cljs$core$async$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17133__auto____1;
return cljs$core$async$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_19178 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_19178[(6)] = c__17207__auto___19180);

return statearr_19178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

