// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__8452){
var vec__8453 = p__8452;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8453,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8453,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__8456 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8456,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8456,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8456,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8456,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8456,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5754__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5754__auto__)){
var name__$1 = temp__5754__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__8459 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8459,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8459,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8459,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8459,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8459,(4),null);
var vec__8462 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8462,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8462,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8462,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8462,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8462,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__8465 = segmap;
var map__8465__$1 = (((((!((map__8465 == null))))?(((((map__8465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8465):map__8465);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8465__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8465__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8465__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8465__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8465__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__8468 = arguments.length;
switch (G__8468) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8472 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8476 = cljs.core.next(segs__$1);
var G__8477 = nrelseg;
var G__8478 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8476;
relseg__$1 = G__8477;
result__$1 = G__8478;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8472,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8472,(1),null);
var G__8479 = (gline + (1));
var G__8480 = cljs.core.next(lines__$1);
var G__8481 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8482 = result__$1;
gline = G__8479;
lines__$1 = G__8480;
relseg = G__8481;
result = G__8482;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__8484 = segmap;
var map__8484__$1 = (((((!((map__8484 == null))))?(((((map__8484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8484):map__8484);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__8483_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__8483_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__8487 = arguments.length;
switch (G__8487) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__8491 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__8495 = cljs.core.next(segs__$1);
var G__8496 = nrelseg;
var G__8497 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__8495;
relseg__$1 = G__8496;
result__$1 = G__8497;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8491,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8491,(1),null);
var G__8498 = (gline + (1));
var G__8499 = cljs.core.next(lines__$1);
var G__8500 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__8501 = result__$1;
gline = G__8498;
lines__$1 = G__8499;
relseg = G__8500;
result = G__8501;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8502){
var vec__8503 = p__8502;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8503,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8503,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8503,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8503,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8503,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__8506){
var vec__8507 = p__8506;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8507,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8507,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8507,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8507,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8507,(4),null);
var seg = vec__8507;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__8510){
var vec__8511 = p__8510;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8511,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8511,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8511,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8511,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8511,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5752__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5752__auto__)){
var name = temp__5752__auto__;
var idx = (function (){var temp__5752__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5752__auto____$1)){
var idx = temp__5752__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__8517 = cljs.core.seq(infos);
var chunk__8518 = null;
var count__8519 = (0);
var i__8520 = (0);
while(true){
if((i__8520 < count__8519)){
var info = chunk__8518.cljs$core$IIndexed$_nth$arity$2(null,i__8520);
var segv_8871 = info__GT_segv(info,source_idx,line,col);
var gline_8872 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_8873 = cljs.core.count(cljs.core.deref(lines));
if((gline_8872 > (lc_8873 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8517,chunk__8518,count__8519,i__8520,segv_8871,gline_8872,lc_8873,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8872 - (lc_8873 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8871], null));
});})(seq__8517,chunk__8518,count__8519,i__8520,segv_8871,gline_8872,lc_8873,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8517,chunk__8518,count__8519,i__8520,segv_8871,gline_8872,lc_8873,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8872], null),cljs.core.conj,segv_8871);
});})(seq__8517,chunk__8518,count__8519,i__8520,segv_8871,gline_8872,lc_8873,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8874 = seq__8517;
var G__8875 = chunk__8518;
var G__8876 = count__8519;
var G__8877 = (i__8520 + (1));
seq__8517 = G__8874;
chunk__8518 = G__8875;
count__8519 = G__8876;
i__8520 = G__8877;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__8517);
if(temp__5754__auto__){
var seq__8517__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8517__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__8517__$1);
var G__8878 = cljs.core.chunk_rest(seq__8517__$1);
var G__8879 = c__4556__auto__;
var G__8880 = cljs.core.count(c__4556__auto__);
var G__8881 = (0);
seq__8517 = G__8878;
chunk__8518 = G__8879;
count__8519 = G__8880;
i__8520 = G__8881;
continue;
} else {
var info = cljs.core.first(seq__8517__$1);
var segv_8882 = info__GT_segv(info,source_idx,line,col);
var gline_8883 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_8884 = cljs.core.count(cljs.core.deref(lines));
if((gline_8883 > (lc_8884 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8517,chunk__8518,count__8519,i__8520,segv_8882,gline_8883,lc_8884,info,seq__8517__$1,temp__5754__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8883 - (lc_8884 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8882], null));
});})(seq__8517,chunk__8518,count__8519,i__8520,segv_8882,gline_8883,lc_8884,info,seq__8517__$1,temp__5754__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__8517,chunk__8518,count__8519,i__8520,segv_8882,gline_8883,lc_8884,info,seq__8517__$1,temp__5754__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8883], null),cljs.core.conj,segv_8882);
});})(seq__8517,chunk__8518,count__8519,i__8520,segv_8882,gline_8883,lc_8884,info,seq__8517__$1,temp__5754__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8885 = cljs.core.next(seq__8517__$1);
var G__8886 = null;
var G__8887 = (0);
var G__8888 = (0);
seq__8517 = G__8885;
chunk__8518 = G__8886;
count__8519 = G__8887;
i__8520 = G__8888;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__8521_8889 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__8522_8890 = null;
var count__8523_8891 = (0);
var i__8524_8892 = (0);
while(true){
if((i__8524_8892 < count__8523_8891)){
var vec__8697_8893 = chunk__8522_8890.cljs$core$IIndexed$_nth$arity$2(null,i__8524_8892);
var source_idx_8894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8697_8893,(0),null);
var vec__8700_8895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8697_8893,(1),null);
var __8896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8700_8895,(0),null);
var lines_8897__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8700_8895,(1),null);
var seq__8703_8898 = cljs.core.seq(lines_8897__$1);
var chunk__8704_8899 = null;
var count__8705_8900 = (0);
var i__8706_8901 = (0);
while(true){
if((i__8706_8901 < count__8705_8900)){
var vec__8745_8902 = chunk__8704_8899.cljs$core$IIndexed$_nth$arity$2(null,i__8706_8901);
var line_8903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745_8902,(0),null);
var cols_8904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745_8902,(1),null);
var seq__8748_8905 = cljs.core.seq(cols_8904);
var chunk__8749_8906 = null;
var count__8750_8907 = (0);
var i__8751_8908 = (0);
while(true){
if((i__8751_8908 < count__8750_8907)){
var vec__8758_8909 = chunk__8749_8906.cljs$core$IIndexed$_nth$arity$2(null,i__8751_8908);
var col_8910 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8758_8909,(0),null);
var infos_8911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8758_8909,(1),null);
encode_cols(infos_8911,source_idx_8894,line_8903,col_8910);


var G__8912 = seq__8748_8905;
var G__8913 = chunk__8749_8906;
var G__8914 = count__8750_8907;
var G__8915 = (i__8751_8908 + (1));
seq__8748_8905 = G__8912;
chunk__8749_8906 = G__8913;
count__8750_8907 = G__8914;
i__8751_8908 = G__8915;
continue;
} else {
var temp__5754__auto___8916 = cljs.core.seq(seq__8748_8905);
if(temp__5754__auto___8916){
var seq__8748_8917__$1 = temp__5754__auto___8916;
if(cljs.core.chunked_seq_QMARK_(seq__8748_8917__$1)){
var c__4556__auto___8918 = cljs.core.chunk_first(seq__8748_8917__$1);
var G__8919 = cljs.core.chunk_rest(seq__8748_8917__$1);
var G__8920 = c__4556__auto___8918;
var G__8921 = cljs.core.count(c__4556__auto___8918);
var G__8922 = (0);
seq__8748_8905 = G__8919;
chunk__8749_8906 = G__8920;
count__8750_8907 = G__8921;
i__8751_8908 = G__8922;
continue;
} else {
var vec__8761_8923 = cljs.core.first(seq__8748_8917__$1);
var col_8924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8761_8923,(0),null);
var infos_8925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8761_8923,(1),null);
encode_cols(infos_8925,source_idx_8894,line_8903,col_8924);


var G__8926 = cljs.core.next(seq__8748_8917__$1);
var G__8927 = null;
var G__8928 = (0);
var G__8929 = (0);
seq__8748_8905 = G__8926;
chunk__8749_8906 = G__8927;
count__8750_8907 = G__8928;
i__8751_8908 = G__8929;
continue;
}
} else {
}
}
break;
}


var G__8930 = seq__8703_8898;
var G__8931 = chunk__8704_8899;
var G__8932 = count__8705_8900;
var G__8933 = (i__8706_8901 + (1));
seq__8703_8898 = G__8930;
chunk__8704_8899 = G__8931;
count__8705_8900 = G__8932;
i__8706_8901 = G__8933;
continue;
} else {
var temp__5754__auto___8934 = cljs.core.seq(seq__8703_8898);
if(temp__5754__auto___8934){
var seq__8703_8935__$1 = temp__5754__auto___8934;
if(cljs.core.chunked_seq_QMARK_(seq__8703_8935__$1)){
var c__4556__auto___8936 = cljs.core.chunk_first(seq__8703_8935__$1);
var G__8937 = cljs.core.chunk_rest(seq__8703_8935__$1);
var G__8938 = c__4556__auto___8936;
var G__8939 = cljs.core.count(c__4556__auto___8936);
var G__8940 = (0);
seq__8703_8898 = G__8937;
chunk__8704_8899 = G__8938;
count__8705_8900 = G__8939;
i__8706_8901 = G__8940;
continue;
} else {
var vec__8764_8941 = cljs.core.first(seq__8703_8935__$1);
var line_8942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8764_8941,(0),null);
var cols_8943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8764_8941,(1),null);
var seq__8767_8944 = cljs.core.seq(cols_8943);
var chunk__8768_8945 = null;
var count__8769_8946 = (0);
var i__8770_8947 = (0);
while(true){
if((i__8770_8947 < count__8769_8946)){
var vec__8777_8948 = chunk__8768_8945.cljs$core$IIndexed$_nth$arity$2(null,i__8770_8947);
var col_8949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8777_8948,(0),null);
var infos_8950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8777_8948,(1),null);
encode_cols(infos_8950,source_idx_8894,line_8942,col_8949);


var G__8951 = seq__8767_8944;
var G__8952 = chunk__8768_8945;
var G__8953 = count__8769_8946;
var G__8954 = (i__8770_8947 + (1));
seq__8767_8944 = G__8951;
chunk__8768_8945 = G__8952;
count__8769_8946 = G__8953;
i__8770_8947 = G__8954;
continue;
} else {
var temp__5754__auto___8955__$1 = cljs.core.seq(seq__8767_8944);
if(temp__5754__auto___8955__$1){
var seq__8767_8956__$1 = temp__5754__auto___8955__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8767_8956__$1)){
var c__4556__auto___8957 = cljs.core.chunk_first(seq__8767_8956__$1);
var G__8958 = cljs.core.chunk_rest(seq__8767_8956__$1);
var G__8959 = c__4556__auto___8957;
var G__8960 = cljs.core.count(c__4556__auto___8957);
var G__8961 = (0);
seq__8767_8944 = G__8958;
chunk__8768_8945 = G__8959;
count__8769_8946 = G__8960;
i__8770_8947 = G__8961;
continue;
} else {
var vec__8780_8962 = cljs.core.first(seq__8767_8956__$1);
var col_8963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8780_8962,(0),null);
var infos_8964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8780_8962,(1),null);
encode_cols(infos_8964,source_idx_8894,line_8942,col_8963);


var G__8965 = cljs.core.next(seq__8767_8956__$1);
var G__8966 = null;
var G__8967 = (0);
var G__8968 = (0);
seq__8767_8944 = G__8965;
chunk__8768_8945 = G__8966;
count__8769_8946 = G__8967;
i__8770_8947 = G__8968;
continue;
}
} else {
}
}
break;
}


var G__8969 = cljs.core.next(seq__8703_8935__$1);
var G__8970 = null;
var G__8971 = (0);
var G__8972 = (0);
seq__8703_8898 = G__8969;
chunk__8704_8899 = G__8970;
count__8705_8900 = G__8971;
i__8706_8901 = G__8972;
continue;
}
} else {
}
}
break;
}


var G__8973 = seq__8521_8889;
var G__8974 = chunk__8522_8890;
var G__8975 = count__8523_8891;
var G__8976 = (i__8524_8892 + (1));
seq__8521_8889 = G__8973;
chunk__8522_8890 = G__8974;
count__8523_8891 = G__8975;
i__8524_8892 = G__8976;
continue;
} else {
var temp__5754__auto___8977 = cljs.core.seq(seq__8521_8889);
if(temp__5754__auto___8977){
var seq__8521_8978__$1 = temp__5754__auto___8977;
if(cljs.core.chunked_seq_QMARK_(seq__8521_8978__$1)){
var c__4556__auto___8979 = cljs.core.chunk_first(seq__8521_8978__$1);
var G__8980 = cljs.core.chunk_rest(seq__8521_8978__$1);
var G__8981 = c__4556__auto___8979;
var G__8982 = cljs.core.count(c__4556__auto___8979);
var G__8983 = (0);
seq__8521_8889 = G__8980;
chunk__8522_8890 = G__8981;
count__8523_8891 = G__8982;
i__8524_8892 = G__8983;
continue;
} else {
var vec__8783_8984 = cljs.core.first(seq__8521_8978__$1);
var source_idx_8985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8783_8984,(0),null);
var vec__8786_8986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8783_8984,(1),null);
var __8987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8786_8986,(0),null);
var lines_8988__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8786_8986,(1),null);
var seq__8789_8989 = cljs.core.seq(lines_8988__$1);
var chunk__8790_8990 = null;
var count__8791_8991 = (0);
var i__8792_8992 = (0);
while(true){
if((i__8792_8992 < count__8791_8991)){
var vec__8831_8993 = chunk__8790_8990.cljs$core$IIndexed$_nth$arity$2(null,i__8792_8992);
var line_8994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8831_8993,(0),null);
var cols_8995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8831_8993,(1),null);
var seq__8834_8996 = cljs.core.seq(cols_8995);
var chunk__8835_8997 = null;
var count__8836_8998 = (0);
var i__8837_8999 = (0);
while(true){
if((i__8837_8999 < count__8836_8998)){
var vec__8844_9000 = chunk__8835_8997.cljs$core$IIndexed$_nth$arity$2(null,i__8837_8999);
var col_9001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8844_9000,(0),null);
var infos_9002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8844_9000,(1),null);
encode_cols(infos_9002,source_idx_8985,line_8994,col_9001);


var G__9003 = seq__8834_8996;
var G__9004 = chunk__8835_8997;
var G__9005 = count__8836_8998;
var G__9006 = (i__8837_8999 + (1));
seq__8834_8996 = G__9003;
chunk__8835_8997 = G__9004;
count__8836_8998 = G__9005;
i__8837_8999 = G__9006;
continue;
} else {
var temp__5754__auto___9007__$1 = cljs.core.seq(seq__8834_8996);
if(temp__5754__auto___9007__$1){
var seq__8834_9008__$1 = temp__5754__auto___9007__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8834_9008__$1)){
var c__4556__auto___9009 = cljs.core.chunk_first(seq__8834_9008__$1);
var G__9010 = cljs.core.chunk_rest(seq__8834_9008__$1);
var G__9011 = c__4556__auto___9009;
var G__9012 = cljs.core.count(c__4556__auto___9009);
var G__9013 = (0);
seq__8834_8996 = G__9010;
chunk__8835_8997 = G__9011;
count__8836_8998 = G__9012;
i__8837_8999 = G__9013;
continue;
} else {
var vec__8847_9014 = cljs.core.first(seq__8834_9008__$1);
var col_9015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8847_9014,(0),null);
var infos_9016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8847_9014,(1),null);
encode_cols(infos_9016,source_idx_8985,line_8994,col_9015);


var G__9017 = cljs.core.next(seq__8834_9008__$1);
var G__9018 = null;
var G__9019 = (0);
var G__9020 = (0);
seq__8834_8996 = G__9017;
chunk__8835_8997 = G__9018;
count__8836_8998 = G__9019;
i__8837_8999 = G__9020;
continue;
}
} else {
}
}
break;
}


var G__9021 = seq__8789_8989;
var G__9022 = chunk__8790_8990;
var G__9023 = count__8791_8991;
var G__9024 = (i__8792_8992 + (1));
seq__8789_8989 = G__9021;
chunk__8790_8990 = G__9022;
count__8791_8991 = G__9023;
i__8792_8992 = G__9024;
continue;
} else {
var temp__5754__auto___9025__$1 = cljs.core.seq(seq__8789_8989);
if(temp__5754__auto___9025__$1){
var seq__8789_9026__$1 = temp__5754__auto___9025__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8789_9026__$1)){
var c__4556__auto___9027 = cljs.core.chunk_first(seq__8789_9026__$1);
var G__9028 = cljs.core.chunk_rest(seq__8789_9026__$1);
var G__9029 = c__4556__auto___9027;
var G__9030 = cljs.core.count(c__4556__auto___9027);
var G__9031 = (0);
seq__8789_8989 = G__9028;
chunk__8790_8990 = G__9029;
count__8791_8991 = G__9030;
i__8792_8992 = G__9031;
continue;
} else {
var vec__8850_9032 = cljs.core.first(seq__8789_9026__$1);
var line_9033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8850_9032,(0),null);
var cols_9034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8850_9032,(1),null);
var seq__8853_9035 = cljs.core.seq(cols_9034);
var chunk__8854_9036 = null;
var count__8855_9037 = (0);
var i__8856_9038 = (0);
while(true){
if((i__8856_9038 < count__8855_9037)){
var vec__8863_9039 = chunk__8854_9036.cljs$core$IIndexed$_nth$arity$2(null,i__8856_9038);
var col_9040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8863_9039,(0),null);
var infos_9041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8863_9039,(1),null);
encode_cols(infos_9041,source_idx_8985,line_9033,col_9040);


var G__9042 = seq__8853_9035;
var G__9043 = chunk__8854_9036;
var G__9044 = count__8855_9037;
var G__9045 = (i__8856_9038 + (1));
seq__8853_9035 = G__9042;
chunk__8854_9036 = G__9043;
count__8855_9037 = G__9044;
i__8856_9038 = G__9045;
continue;
} else {
var temp__5754__auto___9046__$2 = cljs.core.seq(seq__8853_9035);
if(temp__5754__auto___9046__$2){
var seq__8853_9047__$1 = temp__5754__auto___9046__$2;
if(cljs.core.chunked_seq_QMARK_(seq__8853_9047__$1)){
var c__4556__auto___9048 = cljs.core.chunk_first(seq__8853_9047__$1);
var G__9049 = cljs.core.chunk_rest(seq__8853_9047__$1);
var G__9050 = c__4556__auto___9048;
var G__9051 = cljs.core.count(c__4556__auto___9048);
var G__9052 = (0);
seq__8853_9035 = G__9049;
chunk__8854_9036 = G__9050;
count__8855_9037 = G__9051;
i__8856_9038 = G__9052;
continue;
} else {
var vec__8866_9053 = cljs.core.first(seq__8853_9047__$1);
var col_9054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8866_9053,(0),null);
var infos_9055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8866_9053,(1),null);
encode_cols(infos_9055,source_idx_8985,line_9033,col_9054);


var G__9056 = cljs.core.next(seq__8853_9047__$1);
var G__9057 = null;
var G__9058 = (0);
var G__9059 = (0);
seq__8853_9035 = G__9056;
chunk__8854_9036 = G__9057;
count__8855_9037 = G__9058;
i__8856_9038 = G__9059;
continue;
}
} else {
}
}
break;
}


var G__9060 = cljs.core.next(seq__8789_9026__$1);
var G__9061 = null;
var G__9062 = (0);
var G__9063 = (0);
seq__8789_8989 = G__9060;
chunk__8790_8990 = G__9061;
count__8791_8991 = G__9062;
i__8792_8992 = G__9063;
continue;
}
} else {
}
}
break;
}


var G__9064 = cljs.core.next(seq__8521_8978__$1);
var G__9065 = null;
var G__9066 = (0);
var G__9067 = (0);
seq__8521_8889 = G__9064;
chunk__8522_8890 = G__9065;
count__8523_8891 = G__9066;
i__8524_8892 = G__9067;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__8869 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__8514_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__8514_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__8515_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__8515_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__8516_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__8516_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__8870 = G__8869;
goog.object.set(G__8870,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__8870;
} else {
return G__8869;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__9068 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9068,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9068,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__9071 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9071,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9071,(1),null);
var G__9077 = cljs.core.next(col_map_seq);
var G__9078 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__9071,col,infos,vec__9068,line,col_map){
return (function (v,p__9074){
var map__9075 = p__9074;
var map__9075__$1 = (((((!((map__9075 == null))))?(((((map__9075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9075):map__9075);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9075__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9075__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__9071,col,infos,vec__9068,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__9077;
new_cols = G__9078;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__9079 = cljs.core.next(line_map_seq);
var G__9080 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__9079;
new_lines = G__9080;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__9081_9353 = cljs.core.seq(reverse_map);
var chunk__9082_9354 = null;
var count__9083_9355 = (0);
var i__9084_9356 = (0);
while(true){
if((i__9084_9356 < count__9083_9355)){
var vec__9219_9357 = chunk__9082_9354.cljs$core$IIndexed$_nth$arity$2(null,i__9084_9356);
var line_9358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9219_9357,(0),null);
var columns_9359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9219_9357,(1),null);
var seq__9222_9360 = cljs.core.seq(columns_9359);
var chunk__9223_9361 = null;
var count__9224_9362 = (0);
var i__9225_9363 = (0);
while(true){
if((i__9225_9363 < count__9224_9362)){
var vec__9256_9364 = chunk__9223_9361.cljs$core$IIndexed$_nth$arity$2(null,i__9225_9363);
var column_9365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256_9364,(0),null);
var column_info_9366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256_9364,(1),null);
var seq__9259_9367 = cljs.core.seq(column_info_9366);
var chunk__9260_9368 = null;
var count__9261_9369 = (0);
var i__9262_9370 = (0);
while(true){
if((i__9262_9370 < count__9261_9369)){
var map__9267_9371 = chunk__9260_9368.cljs$core$IIndexed$_nth$arity$2(null,i__9262_9370);
var map__9267_9372__$1 = (((((!((map__9267_9371 == null))))?(((((map__9267_9371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9267_9371.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9267_9371):map__9267_9371);
var gline_9373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9267_9372__$1,cljs.core.cst$kw$gline);
var gcol_9374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9267_9372__$1,cljs.core.cst$kw$gcol);
var name_9375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9267_9372__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9373], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9259_9367,chunk__9260_9368,count__9261_9369,i__9262_9370,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9267_9371,map__9267_9372__$1,gline_9373,gcol_9374,name_9375,vec__9256_9364,column_9365,column_info_9366,vec__9219_9357,line_9358,columns_9359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9374], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9358,cljs.core.cst$kw$col,column_9365,cljs.core.cst$kw$name,name_9375], null));
});})(seq__9259_9367,chunk__9260_9368,count__9261_9369,i__9262_9370,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9267_9371,map__9267_9372__$1,gline_9373,gcol_9374,name_9375,vec__9256_9364,column_9365,column_info_9366,vec__9219_9357,line_9358,columns_9359,inverted))
,cljs.core.sorted_map()));


var G__9376 = seq__9259_9367;
var G__9377 = chunk__9260_9368;
var G__9378 = count__9261_9369;
var G__9379 = (i__9262_9370 + (1));
seq__9259_9367 = G__9376;
chunk__9260_9368 = G__9377;
count__9261_9369 = G__9378;
i__9262_9370 = G__9379;
continue;
} else {
var temp__5754__auto___9380 = cljs.core.seq(seq__9259_9367);
if(temp__5754__auto___9380){
var seq__9259_9381__$1 = temp__5754__auto___9380;
if(cljs.core.chunked_seq_QMARK_(seq__9259_9381__$1)){
var c__4556__auto___9382 = cljs.core.chunk_first(seq__9259_9381__$1);
var G__9383 = cljs.core.chunk_rest(seq__9259_9381__$1);
var G__9384 = c__4556__auto___9382;
var G__9385 = cljs.core.count(c__4556__auto___9382);
var G__9386 = (0);
seq__9259_9367 = G__9383;
chunk__9260_9368 = G__9384;
count__9261_9369 = G__9385;
i__9262_9370 = G__9386;
continue;
} else {
var map__9269_9387 = cljs.core.first(seq__9259_9381__$1);
var map__9269_9388__$1 = (((((!((map__9269_9387 == null))))?(((((map__9269_9387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9269_9387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9269_9387):map__9269_9387);
var gline_9389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9269_9388__$1,cljs.core.cst$kw$gline);
var gcol_9390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9269_9388__$1,cljs.core.cst$kw$gcol);
var name_9391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9269_9388__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9389], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9259_9367,chunk__9260_9368,count__9261_9369,i__9262_9370,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9269_9387,map__9269_9388__$1,gline_9389,gcol_9390,name_9391,seq__9259_9381__$1,temp__5754__auto___9380,vec__9256_9364,column_9365,column_info_9366,vec__9219_9357,line_9358,columns_9359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9390], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9358,cljs.core.cst$kw$col,column_9365,cljs.core.cst$kw$name,name_9391], null));
});})(seq__9259_9367,chunk__9260_9368,count__9261_9369,i__9262_9370,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9269_9387,map__9269_9388__$1,gline_9389,gcol_9390,name_9391,seq__9259_9381__$1,temp__5754__auto___9380,vec__9256_9364,column_9365,column_info_9366,vec__9219_9357,line_9358,columns_9359,inverted))
,cljs.core.sorted_map()));


var G__9392 = cljs.core.next(seq__9259_9381__$1);
var G__9393 = null;
var G__9394 = (0);
var G__9395 = (0);
seq__9259_9367 = G__9392;
chunk__9260_9368 = G__9393;
count__9261_9369 = G__9394;
i__9262_9370 = G__9395;
continue;
}
} else {
}
}
break;
}


var G__9396 = seq__9222_9360;
var G__9397 = chunk__9223_9361;
var G__9398 = count__9224_9362;
var G__9399 = (i__9225_9363 + (1));
seq__9222_9360 = G__9396;
chunk__9223_9361 = G__9397;
count__9224_9362 = G__9398;
i__9225_9363 = G__9399;
continue;
} else {
var temp__5754__auto___9400 = cljs.core.seq(seq__9222_9360);
if(temp__5754__auto___9400){
var seq__9222_9401__$1 = temp__5754__auto___9400;
if(cljs.core.chunked_seq_QMARK_(seq__9222_9401__$1)){
var c__4556__auto___9402 = cljs.core.chunk_first(seq__9222_9401__$1);
var G__9403 = cljs.core.chunk_rest(seq__9222_9401__$1);
var G__9404 = c__4556__auto___9402;
var G__9405 = cljs.core.count(c__4556__auto___9402);
var G__9406 = (0);
seq__9222_9360 = G__9403;
chunk__9223_9361 = G__9404;
count__9224_9362 = G__9405;
i__9225_9363 = G__9406;
continue;
} else {
var vec__9271_9407 = cljs.core.first(seq__9222_9401__$1);
var column_9408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9271_9407,(0),null);
var column_info_9409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9271_9407,(1),null);
var seq__9274_9410 = cljs.core.seq(column_info_9409);
var chunk__9275_9411 = null;
var count__9276_9412 = (0);
var i__9277_9413 = (0);
while(true){
if((i__9277_9413 < count__9276_9412)){
var map__9282_9414 = chunk__9275_9411.cljs$core$IIndexed$_nth$arity$2(null,i__9277_9413);
var map__9282_9415__$1 = (((((!((map__9282_9414 == null))))?(((((map__9282_9414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9282_9414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9282_9414):map__9282_9414);
var gline_9416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9282_9415__$1,cljs.core.cst$kw$gline);
var gcol_9417 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9282_9415__$1,cljs.core.cst$kw$gcol);
var name_9418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9282_9415__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9416], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9274_9410,chunk__9275_9411,count__9276_9412,i__9277_9413,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9282_9414,map__9282_9415__$1,gline_9416,gcol_9417,name_9418,vec__9271_9407,column_9408,column_info_9409,seq__9222_9401__$1,temp__5754__auto___9400,vec__9219_9357,line_9358,columns_9359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9417], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9358,cljs.core.cst$kw$col,column_9408,cljs.core.cst$kw$name,name_9418], null));
});})(seq__9274_9410,chunk__9275_9411,count__9276_9412,i__9277_9413,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9282_9414,map__9282_9415__$1,gline_9416,gcol_9417,name_9418,vec__9271_9407,column_9408,column_info_9409,seq__9222_9401__$1,temp__5754__auto___9400,vec__9219_9357,line_9358,columns_9359,inverted))
,cljs.core.sorted_map()));


var G__9419 = seq__9274_9410;
var G__9420 = chunk__9275_9411;
var G__9421 = count__9276_9412;
var G__9422 = (i__9277_9413 + (1));
seq__9274_9410 = G__9419;
chunk__9275_9411 = G__9420;
count__9276_9412 = G__9421;
i__9277_9413 = G__9422;
continue;
} else {
var temp__5754__auto___9423__$1 = cljs.core.seq(seq__9274_9410);
if(temp__5754__auto___9423__$1){
var seq__9274_9424__$1 = temp__5754__auto___9423__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9274_9424__$1)){
var c__4556__auto___9425 = cljs.core.chunk_first(seq__9274_9424__$1);
var G__9426 = cljs.core.chunk_rest(seq__9274_9424__$1);
var G__9427 = c__4556__auto___9425;
var G__9428 = cljs.core.count(c__4556__auto___9425);
var G__9429 = (0);
seq__9274_9410 = G__9426;
chunk__9275_9411 = G__9427;
count__9276_9412 = G__9428;
i__9277_9413 = G__9429;
continue;
} else {
var map__9284_9430 = cljs.core.first(seq__9274_9424__$1);
var map__9284_9431__$1 = (((((!((map__9284_9430 == null))))?(((((map__9284_9430.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9284_9430.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9284_9430):map__9284_9430);
var gline_9432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9284_9431__$1,cljs.core.cst$kw$gline);
var gcol_9433 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9284_9431__$1,cljs.core.cst$kw$gcol);
var name_9434 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9284_9431__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9432], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9274_9410,chunk__9275_9411,count__9276_9412,i__9277_9413,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9284_9430,map__9284_9431__$1,gline_9432,gcol_9433,name_9434,seq__9274_9424__$1,temp__5754__auto___9423__$1,vec__9271_9407,column_9408,column_info_9409,seq__9222_9401__$1,temp__5754__auto___9400,vec__9219_9357,line_9358,columns_9359,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9433], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9358,cljs.core.cst$kw$col,column_9408,cljs.core.cst$kw$name,name_9434], null));
});})(seq__9274_9410,chunk__9275_9411,count__9276_9412,i__9277_9413,seq__9222_9360,chunk__9223_9361,count__9224_9362,i__9225_9363,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9284_9430,map__9284_9431__$1,gline_9432,gcol_9433,name_9434,seq__9274_9424__$1,temp__5754__auto___9423__$1,vec__9271_9407,column_9408,column_info_9409,seq__9222_9401__$1,temp__5754__auto___9400,vec__9219_9357,line_9358,columns_9359,inverted))
,cljs.core.sorted_map()));


var G__9435 = cljs.core.next(seq__9274_9424__$1);
var G__9436 = null;
var G__9437 = (0);
var G__9438 = (0);
seq__9274_9410 = G__9435;
chunk__9275_9411 = G__9436;
count__9276_9412 = G__9437;
i__9277_9413 = G__9438;
continue;
}
} else {
}
}
break;
}


var G__9439 = cljs.core.next(seq__9222_9401__$1);
var G__9440 = null;
var G__9441 = (0);
var G__9442 = (0);
seq__9222_9360 = G__9439;
chunk__9223_9361 = G__9440;
count__9224_9362 = G__9441;
i__9225_9363 = G__9442;
continue;
}
} else {
}
}
break;
}


var G__9443 = seq__9081_9353;
var G__9444 = chunk__9082_9354;
var G__9445 = count__9083_9355;
var G__9446 = (i__9084_9356 + (1));
seq__9081_9353 = G__9443;
chunk__9082_9354 = G__9444;
count__9083_9355 = G__9445;
i__9084_9356 = G__9446;
continue;
} else {
var temp__5754__auto___9447 = cljs.core.seq(seq__9081_9353);
if(temp__5754__auto___9447){
var seq__9081_9448__$1 = temp__5754__auto___9447;
if(cljs.core.chunked_seq_QMARK_(seq__9081_9448__$1)){
var c__4556__auto___9449 = cljs.core.chunk_first(seq__9081_9448__$1);
var G__9450 = cljs.core.chunk_rest(seq__9081_9448__$1);
var G__9451 = c__4556__auto___9449;
var G__9452 = cljs.core.count(c__4556__auto___9449);
var G__9453 = (0);
seq__9081_9353 = G__9450;
chunk__9082_9354 = G__9451;
count__9083_9355 = G__9452;
i__9084_9356 = G__9453;
continue;
} else {
var vec__9286_9454 = cljs.core.first(seq__9081_9448__$1);
var line_9455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9286_9454,(0),null);
var columns_9456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9286_9454,(1),null);
var seq__9289_9457 = cljs.core.seq(columns_9456);
var chunk__9290_9458 = null;
var count__9291_9459 = (0);
var i__9292_9460 = (0);
while(true){
if((i__9292_9460 < count__9291_9459)){
var vec__9323_9461 = chunk__9290_9458.cljs$core$IIndexed$_nth$arity$2(null,i__9292_9460);
var column_9462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9323_9461,(0),null);
var column_info_9463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9323_9461,(1),null);
var seq__9326_9464 = cljs.core.seq(column_info_9463);
var chunk__9327_9465 = null;
var count__9328_9466 = (0);
var i__9329_9467 = (0);
while(true){
if((i__9329_9467 < count__9328_9466)){
var map__9334_9468 = chunk__9327_9465.cljs$core$IIndexed$_nth$arity$2(null,i__9329_9467);
var map__9334_9469__$1 = (((((!((map__9334_9468 == null))))?(((((map__9334_9468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9334_9468.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9334_9468):map__9334_9468);
var gline_9470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9334_9469__$1,cljs.core.cst$kw$gline);
var gcol_9471 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9334_9469__$1,cljs.core.cst$kw$gcol);
var name_9472 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9334_9469__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9470], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9326_9464,chunk__9327_9465,count__9328_9466,i__9329_9467,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9334_9468,map__9334_9469__$1,gline_9470,gcol_9471,name_9472,vec__9323_9461,column_9462,column_info_9463,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9471], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9455,cljs.core.cst$kw$col,column_9462,cljs.core.cst$kw$name,name_9472], null));
});})(seq__9326_9464,chunk__9327_9465,count__9328_9466,i__9329_9467,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9334_9468,map__9334_9469__$1,gline_9470,gcol_9471,name_9472,vec__9323_9461,column_9462,column_info_9463,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted))
,cljs.core.sorted_map()));


var G__9473 = seq__9326_9464;
var G__9474 = chunk__9327_9465;
var G__9475 = count__9328_9466;
var G__9476 = (i__9329_9467 + (1));
seq__9326_9464 = G__9473;
chunk__9327_9465 = G__9474;
count__9328_9466 = G__9475;
i__9329_9467 = G__9476;
continue;
} else {
var temp__5754__auto___9477__$1 = cljs.core.seq(seq__9326_9464);
if(temp__5754__auto___9477__$1){
var seq__9326_9478__$1 = temp__5754__auto___9477__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9326_9478__$1)){
var c__4556__auto___9479 = cljs.core.chunk_first(seq__9326_9478__$1);
var G__9480 = cljs.core.chunk_rest(seq__9326_9478__$1);
var G__9481 = c__4556__auto___9479;
var G__9482 = cljs.core.count(c__4556__auto___9479);
var G__9483 = (0);
seq__9326_9464 = G__9480;
chunk__9327_9465 = G__9481;
count__9328_9466 = G__9482;
i__9329_9467 = G__9483;
continue;
} else {
var map__9336_9484 = cljs.core.first(seq__9326_9478__$1);
var map__9336_9485__$1 = (((((!((map__9336_9484 == null))))?(((((map__9336_9484.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9336_9484.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9336_9484):map__9336_9484);
var gline_9486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9336_9485__$1,cljs.core.cst$kw$gline);
var gcol_9487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9336_9485__$1,cljs.core.cst$kw$gcol);
var name_9488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9336_9485__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9486], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9326_9464,chunk__9327_9465,count__9328_9466,i__9329_9467,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9336_9484,map__9336_9485__$1,gline_9486,gcol_9487,name_9488,seq__9326_9478__$1,temp__5754__auto___9477__$1,vec__9323_9461,column_9462,column_info_9463,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9487], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9455,cljs.core.cst$kw$col,column_9462,cljs.core.cst$kw$name,name_9488], null));
});})(seq__9326_9464,chunk__9327_9465,count__9328_9466,i__9329_9467,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9336_9484,map__9336_9485__$1,gline_9486,gcol_9487,name_9488,seq__9326_9478__$1,temp__5754__auto___9477__$1,vec__9323_9461,column_9462,column_info_9463,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted))
,cljs.core.sorted_map()));


var G__9489 = cljs.core.next(seq__9326_9478__$1);
var G__9490 = null;
var G__9491 = (0);
var G__9492 = (0);
seq__9326_9464 = G__9489;
chunk__9327_9465 = G__9490;
count__9328_9466 = G__9491;
i__9329_9467 = G__9492;
continue;
}
} else {
}
}
break;
}


var G__9493 = seq__9289_9457;
var G__9494 = chunk__9290_9458;
var G__9495 = count__9291_9459;
var G__9496 = (i__9292_9460 + (1));
seq__9289_9457 = G__9493;
chunk__9290_9458 = G__9494;
count__9291_9459 = G__9495;
i__9292_9460 = G__9496;
continue;
} else {
var temp__5754__auto___9497__$1 = cljs.core.seq(seq__9289_9457);
if(temp__5754__auto___9497__$1){
var seq__9289_9498__$1 = temp__5754__auto___9497__$1;
if(cljs.core.chunked_seq_QMARK_(seq__9289_9498__$1)){
var c__4556__auto___9499 = cljs.core.chunk_first(seq__9289_9498__$1);
var G__9500 = cljs.core.chunk_rest(seq__9289_9498__$1);
var G__9501 = c__4556__auto___9499;
var G__9502 = cljs.core.count(c__4556__auto___9499);
var G__9503 = (0);
seq__9289_9457 = G__9500;
chunk__9290_9458 = G__9501;
count__9291_9459 = G__9502;
i__9292_9460 = G__9503;
continue;
} else {
var vec__9338_9504 = cljs.core.first(seq__9289_9498__$1);
var column_9505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9338_9504,(0),null);
var column_info_9506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9338_9504,(1),null);
var seq__9341_9507 = cljs.core.seq(column_info_9506);
var chunk__9342_9508 = null;
var count__9343_9509 = (0);
var i__9344_9510 = (0);
while(true){
if((i__9344_9510 < count__9343_9509)){
var map__9349_9511 = chunk__9342_9508.cljs$core$IIndexed$_nth$arity$2(null,i__9344_9510);
var map__9349_9512__$1 = (((((!((map__9349_9511 == null))))?(((((map__9349_9511.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9349_9511.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9349_9511):map__9349_9511);
var gline_9513 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9349_9512__$1,cljs.core.cst$kw$gline);
var gcol_9514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9349_9512__$1,cljs.core.cst$kw$gcol);
var name_9515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9349_9512__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9513], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9341_9507,chunk__9342_9508,count__9343_9509,i__9344_9510,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9349_9511,map__9349_9512__$1,gline_9513,gcol_9514,name_9515,vec__9338_9504,column_9505,column_info_9506,seq__9289_9498__$1,temp__5754__auto___9497__$1,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9514], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9455,cljs.core.cst$kw$col,column_9505,cljs.core.cst$kw$name,name_9515], null));
});})(seq__9341_9507,chunk__9342_9508,count__9343_9509,i__9344_9510,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9349_9511,map__9349_9512__$1,gline_9513,gcol_9514,name_9515,vec__9338_9504,column_9505,column_info_9506,seq__9289_9498__$1,temp__5754__auto___9497__$1,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted))
,cljs.core.sorted_map()));


var G__9516 = seq__9341_9507;
var G__9517 = chunk__9342_9508;
var G__9518 = count__9343_9509;
var G__9519 = (i__9344_9510 + (1));
seq__9341_9507 = G__9516;
chunk__9342_9508 = G__9517;
count__9343_9509 = G__9518;
i__9344_9510 = G__9519;
continue;
} else {
var temp__5754__auto___9520__$2 = cljs.core.seq(seq__9341_9507);
if(temp__5754__auto___9520__$2){
var seq__9341_9521__$1 = temp__5754__auto___9520__$2;
if(cljs.core.chunked_seq_QMARK_(seq__9341_9521__$1)){
var c__4556__auto___9522 = cljs.core.chunk_first(seq__9341_9521__$1);
var G__9523 = cljs.core.chunk_rest(seq__9341_9521__$1);
var G__9524 = c__4556__auto___9522;
var G__9525 = cljs.core.count(c__4556__auto___9522);
var G__9526 = (0);
seq__9341_9507 = G__9523;
chunk__9342_9508 = G__9524;
count__9343_9509 = G__9525;
i__9344_9510 = G__9526;
continue;
} else {
var map__9351_9527 = cljs.core.first(seq__9341_9521__$1);
var map__9351_9528__$1 = (((((!((map__9351_9527 == null))))?(((((map__9351_9527.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9351_9527.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9351_9527):map__9351_9527);
var gline_9529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9351_9528__$1,cljs.core.cst$kw$gline);
var gcol_9530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9351_9528__$1,cljs.core.cst$kw$gcol);
var name_9531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9351_9528__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_9529], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__9341_9507,chunk__9342_9508,count__9343_9509,i__9344_9510,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9351_9527,map__9351_9528__$1,gline_9529,gcol_9530,name_9531,seq__9341_9521__$1,temp__5754__auto___9520__$2,vec__9338_9504,column_9505,column_info_9506,seq__9289_9498__$1,temp__5754__auto___9497__$1,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_9530], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_9455,cljs.core.cst$kw$col,column_9505,cljs.core.cst$kw$name,name_9531], null));
});})(seq__9341_9507,chunk__9342_9508,count__9343_9509,i__9344_9510,seq__9289_9457,chunk__9290_9458,count__9291_9459,i__9292_9460,seq__9081_9353,chunk__9082_9354,count__9083_9355,i__9084_9356,map__9351_9527,map__9351_9528__$1,gline_9529,gcol_9530,name_9531,seq__9341_9521__$1,temp__5754__auto___9520__$2,vec__9338_9504,column_9505,column_info_9506,seq__9289_9498__$1,temp__5754__auto___9497__$1,vec__9286_9454,line_9455,columns_9456,seq__9081_9448__$1,temp__5754__auto___9447,inverted))
,cljs.core.sorted_map()));


var G__9532 = cljs.core.next(seq__9341_9521__$1);
var G__9533 = null;
var G__9534 = (0);
var G__9535 = (0);
seq__9341_9507 = G__9532;
chunk__9342_9508 = G__9533;
count__9343_9509 = G__9534;
i__9344_9510 = G__9535;
continue;
}
} else {
}
}
break;
}


var G__9536 = cljs.core.next(seq__9289_9498__$1);
var G__9537 = null;
var G__9538 = (0);
var G__9539 = (0);
seq__9289_9457 = G__9536;
chunk__9290_9458 = G__9537;
count__9291_9459 = G__9538;
i__9292_9460 = G__9539;
continue;
}
} else {
}
}
break;
}


var G__9540 = cljs.core.next(seq__9081_9448__$1);
var G__9541 = null;
var G__9542 = (0);
var G__9543 = (0);
seq__9081_9353 = G__9540;
chunk__9082_9354 = G__9541;
count__9083_9355 = G__9542;
i__9084_9356 = G__9543;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
