// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fipp.engine');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fipp.deque');
if((typeof fipp !== 'undefined') && (typeof fipp.engine !== 'undefined') && (typeof fipp.engine.serialize_node !== 'undefined')){
} else {
fipp.engine.serialize_node = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__13156 = cljs.core.get_global_hierarchy;
return (fexpr__13156.cljs$core$IFn$_invoke$arity$0 ? fexpr__13156.cljs$core$IFn$_invoke$arity$0() : fexpr__13156.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fipp.engine","serialize-node"),cljs.core.first,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fipp.engine.serialize = (function fipp$engine$serialize(doc){
if((doc == null)){
return null;
} else {
if(cljs.core.seq_QMARK_(doc)){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fipp.engine.serialize,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([doc], 0));
} else {
if(typeof doc === 'string'){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$text,cljs.core.cst$kw$text,doc], null)], null);
} else {
if((doc instanceof cljs.core.Keyword)){
var G__13157 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null);
return (fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1 ? fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1(G__13157) : fipp.engine.serialize_node.call(null,G__13157));
} else {
if(cljs.core.vector_QMARK_(doc)){
return (fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1 ? fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1(doc) : fipp.engine.serialize_node.call(null,doc));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected class for doc node",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$node,doc], null));

}
}
}
}
}
});
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$text,(function (p__13158){
var vec__13159 = p__13158;
var seq__13160 = cljs.core.seq(vec__13159);
var first__13161 = cljs.core.first(seq__13160);
var seq__13160__$1 = cljs.core.next(seq__13160);
var _ = first__13161;
var text = seq__13160__$1;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$text,cljs.core.cst$kw$text,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,text)], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$pass,(function (p__13162){
var vec__13163 = p__13162;
var seq__13164 = cljs.core.seq(vec__13163);
var first__13165 = cljs.core.first(seq__13164);
var seq__13164__$1 = cljs.core.next(seq__13164);
var _ = first__13165;
var text = seq__13164__$1;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$pass,cljs.core.cst$kw$text,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,text)], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$escaped,(function (p__13166){
var vec__13167 = p__13166;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167,(0),null);
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13167,(1),null);
if(typeof text === 'string'){
} else {
throw (new Error("Assert failed: (string? text)"));
}

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$escaped,cljs.core.cst$kw$text,text], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$span,(function (p__13170){
var vec__13171 = p__13170;
var seq__13172 = cljs.core.seq(vec__13171);
var first__13173 = cljs.core.first(seq__13172);
var seq__13172__$1 = cljs.core.next(seq__13172);
var _ = first__13173;
var children = seq__13172__$1;
return fipp.engine.serialize(children);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$line,(function (p__13174){
var vec__13175 = p__13174;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13175,(0),null);
var inline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13175,(1),null);
var terminate = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13175,(2),null);
var inline__$1 = (function (){var or__4126__auto__ = inline;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return " ";
}
})();
var terminate__$1 = (function (){var or__4126__auto__ = terminate;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "";
}
})();
if(typeof inline__$1 === 'string'){
} else {
throw (new Error("Assert failed: (string? inline)"));
}

if(typeof terminate__$1 === 'string'){
} else {
throw (new Error("Assert failed: (string? terminate)"));
}

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$op,cljs.core.cst$kw$line,cljs.core.cst$kw$inline,inline__$1,cljs.core.cst$kw$terminate,terminate__$1], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$break,(function() { 
var G__13178__delegate = function (_){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$break], null)], null);
};
var G__13178 = function (var_args){
var _ = null;
if (arguments.length > 0) {
var G__13179__i = 0, G__13179__a = new Array(arguments.length -  0);
while (G__13179__i < G__13179__a.length) {G__13179__a[G__13179__i] = arguments[G__13179__i + 0]; ++G__13179__i;}
  _ = new cljs.core.IndexedSeq(G__13179__a,0,null);
} 
return G__13178__delegate.call(this,_);};
G__13178.cljs$lang$maxFixedArity = 0;
G__13178.cljs$lang$applyTo = (function (arglist__13180){
var _ = cljs.core.seq(arglist__13180);
return G__13178__delegate(_);
});
G__13178.cljs$core$IFn$_invoke$arity$variadic = G__13178__delegate;
return G__13178;
})()
);
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$group,(function (p__13181){
var vec__13182 = p__13181;
var seq__13183 = cljs.core.seq(vec__13182);
var first__13184 = cljs.core.first(seq__13183);
var seq__13183__$1 = cljs.core.next(seq__13183);
var _ = first__13184;
var children = seq__13183__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$end], null)], null)], 0));
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$nest,(function (p__13185){
var vec__13186 = p__13185;
var seq__13187 = cljs.core.seq(vec__13186);
var first__13188 = cljs.core.first(seq__13187);
var seq__13187__$1 = cljs.core.next(seq__13187);
var _ = first__13188;
var args = seq__13187__$1;
var vec__13189 = ((typeof cljs.core.first(args) === 'number')?args:cljs.core.cons((2),args));
var seq__13190 = cljs.core.seq(vec__13189);
var first__13191 = cljs.core.first(seq__13190);
var seq__13190__$1 = cljs.core.next(seq__13190);
var offset = first__13191;
var children = seq__13190__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$nest,cljs.core.cst$kw$offset,offset], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$outdent], null)], null)], 0));
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$align,(function (p__13192){
var vec__13193 = p__13192;
var seq__13194 = cljs.core.seq(vec__13193);
var first__13195 = cljs.core.first(seq__13194);
var seq__13194__$1 = cljs.core.next(seq__13194);
var _ = first__13195;
var args = seq__13194__$1;
var vec__13196 = ((typeof cljs.core.first(args) === 'number')?args:cljs.core.cons((0),args));
var seq__13197 = cljs.core.seq(vec__13196);
var first__13198 = cljs.core.first(seq__13197);
var seq__13197__$1 = cljs.core.next(seq__13197);
var offset = first__13198;
var children = seq__13197__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$align,cljs.core.cst$kw$offset,offset], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$outdent], null)], null)], 0));
}));
/**
 * A transducer which annotates the right-side of nodes assuming a
 *   hypothetical single-line formatting of the document. Groups and indentation
 *   directives are temporarily assumed to be zero-width. These values are used
 *   by subsequent passes to produce the final layout.
 */
fipp.engine.annotate_rights = (function fipp$engine$annotate_rights(rf){
var pos = cljs.core.volatile_BANG_((0));
return (function() {
var G__13202 = null;
var G__13202__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__13202__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__13202__2 = (function (res,node){
var delta = (function (){var G__13199 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(node);
var G__13199__$1 = (((G__13199 instanceof cljs.core.Keyword))?G__13199.fqn:null);
switch (G__13199__$1) {
case "text":
return cljs.core.count(cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node));

break;
case "line":
return cljs.core.count(cljs.core.cst$kw$inline.cljs$core$IFn$_invoke$arity$1(node));

break;
case "escaped":
return (1);

break;
default:
return (0);

}
})();
var p = pos.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(pos.cljs$core$IDeref$_deref$arity$1(null) + delta));
var G__13200 = res;
var G__13201 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,cljs.core.cst$kw$right,p);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__13200,G__13201) : rf.call(null,G__13200,G__13201));
});
G__13202 = function(res,node){
switch(arguments.length){
case 0:
return G__13202__0.call(this);
case 1:
return G__13202__1.call(this,res);
case 2:
return G__13202__2.call(this,res,node);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13202.cljs$core$IFn$_invoke$arity$0 = G__13202__0;
G__13202.cljs$core$IFn$_invoke$arity$1 = G__13202__1;
G__13202.cljs$core$IFn$_invoke$arity$2 = G__13202__2;
return G__13202;
})()
});
fipp.engine.update_right = (function fipp$engine$update_right(var_args){
var args__4742__auto__ = [];
var len__4736__auto___13209 = arguments.length;
var i__4737__auto___13210 = (0);
while(true){
if((i__4737__auto___13210 < len__4736__auto___13209)){
args__4742__auto__.push((arguments[i__4737__auto___13210]));

var G__13211 = (i__4737__auto___13210 + (1));
i__4737__auto___13210 = G__13211;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic = (function (deque,f,args){
var G__13207 = cljs.core.pop(deque);
var G__13208 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.peek(deque),args);
return (fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2 ? fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2(G__13207,G__13208) : fipp.deque.conjr.call(null,G__13207,G__13208));
}));

(fipp.engine.update_right.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fipp.engine.update_right.cljs$lang$applyTo = (function (seq13204){
var G__13205 = cljs.core.first(seq13204);
var seq13204__$1 = cljs.core.next(seq13204);
var G__13206 = cljs.core.first(seq13204__$1);
var seq13204__$2 = cljs.core.next(seq13204__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13205,G__13206,seq13204__$2);
}));

/**
 * Given printing options, returns a transducer which annotate the right-side
 *   of groups on their :begin nodes.  This includes the pruning algorithm which
 *   will annotate some :begin nodes as being :too-far to the right without
 *   calculating their exact sizes.
 */
fipp.engine.annotate_begins = (function fipp$engine$annotate_begins(p__13212){
var map__13213 = p__13212;
var map__13213__$1 = (((((!((map__13213 == null))))?(((((map__13213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13213.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13213):map__13213);
var options = map__13213__$1;
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13213__$1,cljs.core.cst$kw$width);
return (function (rf){
var pos = cljs.core.volatile_BANG_((0));
var bufs = cljs.core.volatile_BANG_(fipp.deque.empty);
return (function() {
var G__13220 = null;
var G__13220__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__13220__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__13220__2 = (function (res,p__13215){
var map__13216 = p__13215;
var map__13216__$1 = (((((!((map__13216 == null))))?(((((map__13216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13216.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13216):map__13216);
var node = map__13216__$1;
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13216__$1,cljs.core.cst$kw$op);
var right = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13216__$1,cljs.core.cst$kw$right);
var buffers = cljs.core.deref(bufs);
if(cljs.core.empty_QMARK_(buffers)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$begin)){
var position_STAR_ = (right + width);
var buffer = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$position,position_STAR_,cljs.core.cst$kw$nodes,fipp.deque.empty], null);
cljs.core.vreset_BANG_(pos,position_STAR_);

cljs.core.vreset_BANG_(bufs,(fipp.deque.create.cljs$core$IFn$_invoke$arity$1 ? fipp.deque.create.cljs$core$IFn$_invoke$arity$1(buffer) : fipp.deque.create.call(null,buffer)));

return res;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,node) : rf.call(null,res,node));
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$end)){
var buffer = cljs.core.peek(buffers);
var buffers_STAR_ = cljs.core.pop(buffers);
var begin = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin,cljs.core.cst$kw$right,right], null);
var nodes = fipp.deque.conjlr(begin,cljs.core.cst$kw$nodes.cljs$core$IFn$_invoke$arity$1(buffer),node);
if(cljs.core.empty_QMARK_(buffers_STAR_)){
cljs.core.vreset_BANG_(pos,(0));

cljs.core.vreset_BANG_(bufs,fipp.deque.empty);

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,res,nodes);
} else {
if(cljs.core.vector_QMARK_(buffers_STAR_)){
} else {
throw (new Error("Assert failed: (vector? buffers*)"));
}

if(cljs.core.vector_QMARK_(nodes)){
} else {
throw (new Error("Assert failed: (vector? nodes)"));
}

cljs.core.vreset_BANG_(bufs,fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic(buffers_STAR_,cljs.core.update_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nodes], null),fipp.deque.concat,nodes], 0)));

return res;
}
} else {
var buffers_STAR_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$begin))?(function (){var G__13218 = buffers;
var G__13219 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$position,(right + width),cljs.core.cst$kw$nodes,fipp.deque.empty], null);
return (fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2 ? fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2(G__13218,G__13219) : fipp.deque.conjr.call(null,G__13218,G__13219));
})():fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic(buffers,cljs.core.update_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nodes], null),fipp.deque.conjr,node], 0)));
var res__$1 = res;
while(true){
if((((right <= cljs.core.deref(pos))) && ((cljs.core.count(buffers_STAR_) <= width)))){
cljs.core.vreset_BANG_(bufs,buffers_STAR_);

return res__$1;
} else {
var buffer = cljs.core.first(buffers_STAR_);
var buffers_STAR__STAR_ = fipp.deque.popl(buffers_STAR_);
var begin = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin,cljs.core.cst$kw$right,cljs.core.cst$kw$too_DASH_far], null);
var res_STAR_ = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res__$1,begin) : rf.call(null,res__$1,begin));
var res_STAR___$1 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,res_STAR_,cljs.core.cst$kw$nodes.cljs$core$IFn$_invoke$arity$1(buffer));
if(cljs.core.empty_QMARK_(buffers_STAR__STAR_)){
cljs.core.vreset_BANG_(pos,(0));

cljs.core.vreset_BANG_(bufs,fipp.deque.empty);

return res_STAR___$1;
} else {
cljs.core.vreset_BANG_(pos,cljs.core.cst$kw$position.cljs$core$IFn$_invoke$arity$1(cljs.core.first(buffers_STAR__STAR_)));

var G__13221 = buffers_STAR__STAR_;
var G__13222 = res_STAR___$1;
buffers_STAR_ = G__13221;
res__$1 = G__13222;
continue;
}
}
break;
}
}
}
});
G__13220 = function(res,p__13215){
switch(arguments.length){
case 0:
return G__13220__0.call(this);
case 1:
return G__13220__1.call(this,res);
case 2:
return G__13220__2.call(this,res,p__13215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13220.cljs$core$IFn$_invoke$arity$0 = G__13220__0;
G__13220.cljs$core$IFn$_invoke$arity$1 = G__13220__1;
G__13220.cljs$core$IFn$_invoke$arity$2 = G__13220__2;
return G__13220;
})()
});
});
/**
 * Given printing options, returns a transducer which produces the fully
 *   laid-out strings.
 */
fipp.engine.format_nodes = (function fipp$engine$format_nodes(p__13223){
var map__13224 = p__13223;
var map__13224__$1 = (((((!((map__13224 == null))))?(((((map__13224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13224.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13224):map__13224);
var options = map__13224__$1;
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13224__$1,cljs.core.cst$kw$width);
return (function (rf){
var fits = cljs.core.volatile_BANG_((0));
var length = cljs.core.volatile_BANG_(width);
var tab_stops = cljs.core.volatile_BANG_(cljs.core.list((0)));
var column = cljs.core.volatile_BANG_((0));
return (function() {
var G__13238 = null;
var G__13238__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__13238__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__13238__2 = (function (res,p__13226){
var map__13227 = p__13226;
var map__13227__$1 = (((((!((map__13227 == null))))?(((((map__13227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13227.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13227):map__13227);
var node = map__13227__$1;
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13227__$1,cljs.core.cst$kw$op);
var right = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13227__$1,cljs.core.cst$kw$right);
var indent = cljs.core.peek(cljs.core.deref(tab_stops));
var G__13229 = op;
var G__13229__$1 = (((G__13229 instanceof cljs.core.Keyword))?G__13229.fqn:null);
switch (G__13229__$1) {
case "text":
var text = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
var res_STAR_ = (((cljs.core.deref(column) === (0)))?(function (){
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + indent));

var G__13230 = res;
var G__13231 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indent," "));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__13230,G__13231) : rf.call(null,G__13230,G__13231));
})()
:res);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + cljs.core.count(text)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res_STAR_,text) : rf.call(null,res_STAR_,text));

break;
case "escaped":
var text = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
var res_STAR_ = (((cljs.core.deref(column) === (0)))?(function (){
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + indent));

var G__13232 = res;
var G__13233 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indent," "));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__13232,G__13233) : rf.call(null,G__13232,G__13233));
})()
:res);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + (1)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res_STAR_,text) : rf.call(null,res_STAR_,text));

break;
case "pass":
var G__13234 = res;
var G__13235 = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__13234,G__13235) : rf.call(null,G__13234,G__13235));

break;
case "line":
if((cljs.core.deref(fits) === (0))){
cljs.core.vreset_BANG_(length,((right + width) - indent));

cljs.core.vreset_BANG_(column,(0));

var G__13236 = res;
var G__13237 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$terminate.cljs$core$IFn$_invoke$arity$1(node)),"\n"].join('');
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__13236,G__13237) : rf.call(null,G__13236,G__13237));
} else {
var inline = cljs.core.cst$kw$inline.cljs$core$IFn$_invoke$arity$1(node);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + cljs.core.count(inline)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,inline) : rf.call(null,res,inline));
}

break;
case "break":
cljs.core.vreset_BANG_(length,((right + width) - indent));

cljs.core.vreset_BANG_(column,(0));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,"\n") : rf.call(null,res,"\n"));

break;
case "nest":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tab_stops.cljs$core$IDeref$_deref$arity$1(null),(indent + cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(node))));

return res;

break;
case "align":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tab_stops.cljs$core$IDeref$_deref$arity$1(null),(cljs.core.deref(column) + cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(node))));

return res;

break;
case "outdent":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.pop(tab_stops.cljs$core$IDeref$_deref$arity$1(null)));

return res;

break;
case "begin":
cljs.core.vreset_BANG_(fits,(((cljs.core.deref(fits) > (0)))?(cljs.core.deref(fits) + (1)):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(right,cljs.core.cst$kw$too_DASH_far))?(0):(((right <= cljs.core.deref(length)))?(1):(0)
))));

return res;

break;
case "end":
cljs.core.vreset_BANG_(fits,(function (){var x__4214__auto__ = (0);
var y__4215__auto__ = (cljs.core.deref(fits) - (1));
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})());

return res;

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected node op",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$node,node], null));

}
});
G__13238 = function(res,p__13226){
switch(arguments.length){
case 0:
return G__13238__0.call(this);
case 1:
return G__13238__1.call(this,res);
case 2:
return G__13238__2.call(this,res,p__13226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13238.cljs$core$IFn$_invoke$arity$0 = G__13238__0;
G__13238.cljs$core$IFn$_invoke$arity$1 = G__13238__1;
G__13238.cljs$core$IFn$_invoke$arity$2 = G__13238__2;
return G__13238;
})()
});
});
fipp.engine.pprint_document = (function fipp$engine$pprint_document(document,options){
var options_13240__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,(70)], null),options], 0));
cljs.core.run_BANG_(cljs.core.print,cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fipp.engine.annotate_rights,fipp.engine.annotate_begins(options_13240__$1),fipp.engine.format_nodes(options_13240__$1),fipp.engine.serialize(document)], 0)));

return cljs.core.println();
});
