// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40931 = arguments.length;
var i__4737__auto___40932 = (0);
while(true){
if((i__4737__auto___40932 < len__4736__auto___40931)){
args__4742__auto__.push((arguments[i__4737__auto___40932]));

var G__40933 = (i__4737__auto___40932 + (1));
i__4737__auto___40932 = G__40933;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq40928){
var G__40929 = cljs.core.first(seq40928);
var seq40928__$1 = cljs.core.next(seq40928);
var G__40930 = cljs.core.first(seq40928__$1);
var seq40928__$2 = cljs.core.next(seq40928__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40929,G__40930,seq40928__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e40934){var e = e40934;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e40935){var e = e40935;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e40936){var e = e40936;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e40937){var e = e40937;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e40938){var e = e40938;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40941 = arguments.length;
var i__4737__auto___40942 = (0);
while(true){
if((i__4737__auto___40942 < len__4736__auto___40941)){
args__4742__auto__.push((arguments[i__4737__auto___40942]));

var G__40943 = (i__4737__auto___40942 + (1));
i__4737__auto___40942 = G__40943;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40940){var e = e40940;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq40939){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40939));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40946 = arguments.length;
var i__4737__auto___40947 = (0);
while(true){
if((i__4737__auto___40947 < len__4736__auto___40946)){
args__4742__auto__.push((arguments[i__4737__auto___40947]));

var G__40948 = (i__4737__auto___40947 + (1));
i__4737__auto___40947 = G__40948;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40945){var e = e40945;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq40944){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40944));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e40949){var e = e40949;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40952 = arguments.length;
var i__4737__auto___40953 = (0);
while(true){
if((i__4737__auto___40953 < len__4736__auto___40952)){
args__4742__auto__.push((arguments[i__4737__auto___40953]));

var G__40954 = (i__4737__auto___40953 + (1));
i__4737__auto___40953 = G__40954;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e40951){var e = e40951;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq40950){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40950));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40957 = arguments.length;
var i__4737__auto___40958 = (0);
while(true){
if((i__4737__auto___40958 < len__4736__auto___40957)){
args__4742__auto__.push((arguments[i__4737__auto___40958]));

var G__40959 = (i__4737__auto___40958 + (1));
i__4737__auto___40958 = G__40959;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e40956){var e = e40956;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq40955){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40955));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e40960){var e = e40960;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e40961){var e = e40961;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40964 = arguments.length;
var i__4737__auto___40965 = (0);
while(true){
if((i__4737__auto___40965 < len__4736__auto___40964)){
args__4742__auto__.push((arguments[i__4737__auto___40965]));

var G__40966 = (i__4737__auto___40965 + (1));
i__4737__auto___40965 = G__40966;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40963){var e = e40963;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq40962){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40962));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40969 = arguments.length;
var i__4737__auto___40970 = (0);
while(true){
if((i__4737__auto___40970 < len__4736__auto___40969)){
args__4742__auto__.push((arguments[i__4737__auto___40970]));

var G__40971 = (i__4737__auto___40970 + (1));
i__4737__auto___40970 = G__40971;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40968){var e = e40968;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq40967){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40967));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40974 = arguments.length;
var i__4737__auto___40975 = (0);
while(true){
if((i__4737__auto___40975 < len__4736__auto___40974)){
args__4742__auto__.push((arguments[i__4737__auto___40975]));

var G__40976 = (i__4737__auto___40975 + (1));
i__4737__auto___40975 = G__40976;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e40973){var e = e40973;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq40972){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40972));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40979 = arguments.length;
var i__4737__auto___40980 = (0);
while(true){
if((i__4737__auto___40980 < len__4736__auto___40979)){
args__4742__auto__.push((arguments[i__4737__auto___40980]));

var G__40981 = (i__4737__auto___40980 + (1));
i__4737__auto___40980 = G__40981;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e40978){var e = e40978;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq40977){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40977));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40984 = arguments.length;
var i__4737__auto___40985 = (0);
while(true){
if((i__4737__auto___40985 < len__4736__auto___40984)){
args__4742__auto__.push((arguments[i__4737__auto___40985]));

var G__40986 = (i__4737__auto___40985 + (1));
i__4737__auto___40985 = G__40986;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e40983){var e = e40983;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq40982){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40982));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40989 = arguments.length;
var i__4737__auto___40990 = (0);
while(true){
if((i__4737__auto___40990 < len__4736__auto___40989)){
args__4742__auto__.push((arguments[i__4737__auto___40990]));

var G__40991 = (i__4737__auto___40990 + (1));
i__4737__auto___40990 = G__40991;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e40988){var e = e40988;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq40987){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40987));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40994 = arguments.length;
var i__4737__auto___40995 = (0);
while(true){
if((i__4737__auto___40995 < len__4736__auto___40994)){
args__4742__auto__.push((arguments[i__4737__auto___40995]));

var G__40996 = (i__4737__auto___40995 + (1));
i__4737__auto___40995 = G__40996;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e40993){var e = e40993;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq40992){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40992));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__40998 = arguments.length;
switch (G__40998) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41026){
var state_val_41027 = (state_41026[(1)]);
if((state_val_41027 === (7))){
var inst_41011 = (state_41026[(7)]);
var inst_41014 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41011,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_41026__$1 = state_41026;
var statearr_41028_41114 = state_41026__$1;
(statearr_41028_41114[(2)] = inst_41014);

(statearr_41028_41114[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (1))){
var state_41026__$1 = state_41026;
var statearr_41029_41115 = state_41026__$1;
(statearr_41029_41115[(2)] = null);

(statearr_41029_41115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (4))){
var inst_40999 = (state_41026[(2)]);
var state_41026__$1 = state_41026;
var statearr_41030_41116 = state_41026__$1;
(statearr_41030_41116[(2)] = inst_40999);

(statearr_41030_41116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (6))){
var inst_41011 = (state_41026[(7)]);
var inst_41011__$1 = (state_41026[(2)]);
var inst_41012 = fluree.db.util.core.exception_QMARK_(inst_41011__$1);
var state_41026__$1 = (function (){var statearr_41031 = state_41026;
(statearr_41031[(7)] = inst_41011__$1);

return statearr_41031;
})();
if(inst_41012){
var statearr_41032_41117 = state_41026__$1;
(statearr_41032_41117[(1)] = (7));

} else {
var statearr_41033_41118 = state_41026__$1;
(statearr_41033_41118[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (3))){
var inst_41024 = (state_41026[(2)]);
var state_41026__$1 = state_41026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41026__$1,inst_41024);
} else {
if((state_val_41027 === (2))){
var inst_41005 = (state_41026[(8)]);
var _ = (function (){var statearr_41035 = state_41026;
(statearr_41035[(4)] = cljs.core.cons((5),(state_41026[(4)])));

return statearr_41035;
})();
var inst_41005__$1 = cljs.core.volatile_BANG_((0));
var inst_41006 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_41007 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_41006,cljs.core.cst$kw$fuel,inst_41005__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_41008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_41007);
var inst_41009 = fluree.db.query.fql.query(db,inst_41008);
var state_41026__$1 = (function (){var statearr_41036 = state_41026;
(statearr_41036[(8)] = inst_41005__$1);

return statearr_41036;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41026__$1,(6),inst_41009);
} else {
if((state_val_41027 === (9))){
var inst_41021 = (state_41026[(2)]);
var _ = (function (){var statearr_41037 = state_41026;
(statearr_41037[(4)] = cljs.core.rest((state_41026[(4)])));

return statearr_41037;
})();
var state_41026__$1 = state_41026;
var statearr_41038_41119 = state_41026__$1;
(statearr_41038_41119[(2)] = inst_41021);

(statearr_41038_41119[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (5))){
var _ = (function (){var statearr_41039 = state_41026;
(statearr_41039[(4)] = cljs.core.rest((state_41026[(4)])));

return statearr_41039;
})();
var state_41026__$1 = state_41026;
var ex41034 = (state_41026__$1[(2)]);
var statearr_41040_41120 = state_41026__$1;
(statearr_41040_41120[(5)] = ex41034);


if((ex41034 instanceof Error)){
var statearr_41041_41121 = state_41026__$1;
(statearr_41041_41121[(1)] = (4));

(statearr_41041_41121[(5)] = null);

} else {
throw ex41034;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41027 === (8))){
var inst_41005 = (state_41026[(8)]);
var inst_41011 = (state_41026[(7)]);
var inst_41016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41017 = cljs.core.deref(inst_41005);
var inst_41018 = [inst_41011,inst_41017];
var inst_41019 = (new cljs.core.PersistentVector(null,2,(5),inst_41016,inst_41018,null));
var state_41026__$1 = state_41026;
var statearr_41042_41122 = state_41026__$1;
(statearr_41042_41122[(2)] = inst_41019);

(statearr_41042_41122[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17133__auto____0 = (function (){
var statearr_41043 = [null,null,null,null,null,null,null,null,null];
(statearr_41043[(0)] = fluree$db$dbfunctions$internal$state_machine__17133__auto__);

(statearr_41043[(1)] = (1));

return statearr_41043;
});
var fluree$db$dbfunctions$internal$state_machine__17133__auto____1 = (function (state_41026){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41026);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41044){var ex__17136__auto__ = e41044;
var statearr_41045_41123 = state_41026;
(statearr_41045_41123[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41026[(4)]))){
var statearr_41046_41124 = state_41026;
(statearr_41046_41124[(1)] = cljs.core.first((state_41026[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41125 = state_41026;
state_41026 = G__41125;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17133__auto__ = function(state_41026){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____1.call(this,state_41026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41047 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41047[(6)] = c__17207__auto__);

return statearr_41047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41092){
var state_val_41093 = (state_41092[(1)]);
if((state_val_41093 === (7))){
var inst_41078 = (state_41092[(2)]);
var inst_41079 = fluree.db.query.fql.query(db,inst_41078);
var state_41092__$1 = state_41092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41092__$1,(8),inst_41079);
} else {
if((state_val_41093 === (1))){
var inst_41048 = typeof select === 'string';
var state_41092__$1 = state_41092;
if(cljs.core.truth_(inst_41048)){
var statearr_41094_41126 = state_41092__$1;
(statearr_41094_41126[(1)] = (2));

} else {
var statearr_41095_41127 = state_41092__$1;
(statearr_41095_41127[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (4))){
var inst_41061 = (state_41092[(7)]);
var inst_41054 = (state_41092[(8)]);
var inst_41053 = (state_41092[(2)]);
var inst_41054__$1 = cljs.core.volatile_BANG_((0));
var inst_41055 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_41056 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_41057 = [inst_41054__$1,(100000)];
var inst_41058 = cljs.core.PersistentHashMap.fromArrays(inst_41056,inst_41057);
var inst_41059 = [inst_41053,from,where,block,limit,inst_41058];
var inst_41060 = cljs.core.PersistentHashMap.fromArrays(inst_41055,inst_41059);
var inst_41061__$1 = fluree.db.util.core.without_nils(inst_41060);
var inst_41062 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41061__$1);
var inst_41063 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41061__$1);
var inst_41064 = cljs.core.first(inst_41063);
var inst_41065 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41064], 0));
var inst_41066 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_41065);
var inst_41067 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41061__$1);
var inst_41068 = cljs.core.last(inst_41067);
var inst_41069 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41068], 0));
var inst_41070 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_41069);
var inst_41071 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41062,inst_41066,inst_41070], 0));
var state_41092__$1 = (function (){var statearr_41096 = state_41092;
(statearr_41096[(7)] = inst_41061__$1);

(statearr_41096[(8)] = inst_41054__$1);

return statearr_41096;
})();
if(cljs.core.truth_(inst_41071)){
var statearr_41097_41128 = state_41092__$1;
(statearr_41097_41128[(1)] = (5));

} else {
var statearr_41098_41129 = state_41092__$1;
(statearr_41098_41129[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (6))){
var inst_41061 = (state_41092[(7)]);
var state_41092__$1 = state_41092;
var statearr_41099_41130 = state_41092__$1;
(statearr_41099_41130[(2)] = inst_41061);

(statearr_41099_41130[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (3))){
var state_41092__$1 = state_41092;
var statearr_41100_41131 = state_41092__$1;
(statearr_41100_41131[(2)] = select);

(statearr_41100_41131[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (2))){
var inst_41050 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_41092__$1 = state_41092;
var statearr_41101_41132 = state_41092__$1;
(statearr_41101_41132[(2)] = inst_41050);

(statearr_41101_41132[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (11))){
var inst_41090 = (state_41092[(2)]);
var state_41092__$1 = state_41092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41092__$1,inst_41090);
} else {
if((state_val_41093 === (9))){
var inst_41081 = (state_41092[(9)]);
var state_41092__$1 = state_41092;
var statearr_41102_41133 = state_41092__$1;
(statearr_41102_41133[(2)] = inst_41081);

(statearr_41102_41133[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (5))){
var inst_41061 = (state_41092[(7)]);
var inst_41073 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41061);
var inst_41074 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_41073);
var inst_41075 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41061,cljs.core.cst$kw$where,inst_41074);
var state_41092__$1 = state_41092;
var statearr_41103_41134 = state_41092__$1;
(statearr_41103_41134[(2)] = inst_41075);

(statearr_41103_41134[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (10))){
var inst_41081 = (state_41092[(9)]);
var inst_41054 = (state_41092[(8)]);
var inst_41085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41086 = cljs.core.deref(inst_41054);
var inst_41087 = [inst_41081,inst_41086];
var inst_41088 = (new cljs.core.PersistentVector(null,2,(5),inst_41085,inst_41087,null));
var state_41092__$1 = state_41092;
var statearr_41104_41135 = state_41092__$1;
(statearr_41104_41135[(2)] = inst_41088);

(statearr_41104_41135[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41093 === (8))){
var inst_41081 = (state_41092[(9)]);
var inst_41081__$1 = (state_41092[(2)]);
var inst_41082 = fluree.db.util.core.exception_QMARK_(inst_41081__$1);
var state_41092__$1 = (function (){var statearr_41105 = state_41092;
(statearr_41105[(9)] = inst_41081__$1);

return statearr_41105;
})();
if(inst_41082){
var statearr_41106_41136 = state_41092__$1;
(statearr_41106_41136[(1)] = (9));

} else {
var statearr_41107_41137 = state_41092__$1;
(statearr_41107_41137[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17133__auto____0 = (function (){
var statearr_41108 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41108[(0)] = fluree$db$dbfunctions$internal$state_machine__17133__auto__);

(statearr_41108[(1)] = (1));

return statearr_41108;
});
var fluree$db$dbfunctions$internal$state_machine__17133__auto____1 = (function (state_41092){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41092);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41109){var ex__17136__auto__ = e41109;
var statearr_41110_41138 = state_41092;
(statearr_41110_41138[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41092[(4)]))){
var statearr_41111_41139 = state_41092;
(statearr_41111_41139[(1)] = cljs.core.first((state_41092[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41140 = state_41092;
state_41092 = G__41140;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17133__auto__ = function(state_41092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____1.call(this,state_41092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41112 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41112[(6)] = c__17207__auto__);

return statearr_41112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__41144 = path;
var vec__41145 = G__41144;
var seq__41146 = cljs.core.seq(vec__41145);
var first__41147 = cljs.core.first(seq__41146);
var seq__41146__$1 = cljs.core.next(seq__41146);
var var$ = first__41147;
var r = seq__41146__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__41144__$1 = G__41144;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__41151 = G__41144__$1;
var seq__41152 = cljs.core.seq(vec__41151);
var first__41153 = cljs.core.first(seq__41152);
var seq__41152__$1 = cljs.core.next(seq__41152);
var var$__$1 = first__41153;
var r__$1 = seq__41152__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__41154 = r__$1;
var G__41155 = n__$2;
var G__41156 = next_clauses;
G__41144__$1 = G__41154;
n__$1 = G__41155;
where_clauses__$1 = G__41156;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__41157 = r__$1;
var G__41158 = next_n;
var G__41159 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__41144__$1 = G__41157;
n__$1 = G__41158;
where_clauses__$1 = G__41159;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41196){
var state_val_41197 = (state_41196[(1)]);
if((state_val_41197 === (7))){
var inst_41169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41170 = [path];
var inst_41171 = (new cljs.core.PersistentVector(null,1,(5),inst_41169,inst_41170,null));
var state_41196__$1 = state_41196;
var statearr_41198_41226 = state_41196__$1;
(statearr_41198_41226[(2)] = inst_41171);

(statearr_41198_41226[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (1))){
var state_41196__$1 = state_41196;
var statearr_41199_41227 = state_41196__$1;
(statearr_41199_41227[(2)] = null);

(statearr_41199_41227[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (4))){
var inst_41160 = (state_41196[(2)]);
var state_41196__$1 = state_41196;
var statearr_41200_41228 = state_41196__$1;
(statearr_41200_41228[(2)] = inst_41160);

(statearr_41200_41228[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (13))){
var inst_41187 = (state_41196[(2)]);
var inst_41188 = fluree.db.util.async.throw_err(inst_41187);
var _ = (function (){var statearr_41201 = state_41196;
(statearr_41201[(4)] = cljs.core.rest((state_41196[(4)])));

return statearr_41201;
})();
var state_41196__$1 = state_41196;
var statearr_41202_41229 = state_41196__$1;
(statearr_41202_41229[(2)] = inst_41188);

(statearr_41202_41229[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (6))){
var state_41196__$1 = state_41196;
var statearr_41204_41230 = state_41196__$1;
(statearr_41204_41230[(2)] = path);

(statearr_41204_41230[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (3))){
var inst_41194 = (state_41196[(2)]);
var state_41196__$1 = state_41196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41196__$1,inst_41194);
} else {
if((state_val_41197 === (12))){
var _ = (function (){var statearr_41205 = state_41196;
(statearr_41205[(4)] = cljs.core.rest((state_41196[(4)])));

return statearr_41205;
})();
var state_41196__$1 = state_41196;
var ex41203 = (state_41196__$1[(2)]);
var statearr_41206_41231 = state_41196__$1;
(statearr_41206_41231[(5)] = ex41203);


var statearr_41207_41232 = state_41196__$1;
(statearr_41207_41232[(1)] = (11));

(statearr_41207_41232[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (2))){
var _ = (function (){var statearr_41208 = state_41196;
(statearr_41208[(4)] = cljs.core.cons((5),(state_41196[(4)])));

return statearr_41208;
})();
var inst_41166 = cljs.core.vector_QMARK_(path);
var state_41196__$1 = state_41196;
if(inst_41166){
var statearr_41209_41233 = state_41196__$1;
(statearr_41209_41233[(1)] = (6));

} else {
var statearr_41210_41234 = state_41196__$1;
(statearr_41210_41234[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (11))){
var inst_41173 = (state_41196[(7)]);
var inst_41178 = (state_41196[(2)]);
var inst_41179 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41178,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_41173,endSubject], 0));
var state_41196__$1 = state_41196;
var statearr_41212_41235 = state_41196__$1;
(statearr_41212_41235[(2)] = inst_41179);

(statearr_41212_41235[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (9))){
var inst_41177 = (state_41196[(8)]);
var _ = (function (){var statearr_41213 = state_41196;
(statearr_41213[(4)] = cljs.core.cons((12),(state_41196[(4)])));

return statearr_41213;
})();
var inst_41185 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41177);
var state_41196__$1 = state_41196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41196__$1,(13),inst_41185);
} else {
if((state_val_41197 === (5))){
var _ = (function (){var statearr_41214 = state_41196;
(statearr_41214[(4)] = cljs.core.rest((state_41196[(4)])));

return statearr_41214;
})();
var state_41196__$1 = state_41196;
var ex41211 = (state_41196__$1[(2)]);
var statearr_41215_41236 = state_41196__$1;
(statearr_41215_41236[(5)] = ex41211);


if((ex41211 instanceof Error)){
var statearr_41216_41237 = state_41196__$1;
(statearr_41216_41237[(1)] = (4));

(statearr_41216_41237[(5)] = null);

} else {
throw ex41211;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (10))){
var inst_41191 = (state_41196[(2)]);
var _ = (function (){var statearr_41217 = state_41196;
(statearr_41217[(4)] = cljs.core.rest((state_41196[(4)])));

return statearr_41217;
})();
var state_41196__$1 = state_41196;
var statearr_41218_41238 = state_41196__$1;
(statearr_41218_41238[(2)] = inst_41191);

(statearr_41218_41238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41197 === (8))){
var inst_41173 = (state_41196[(7)]);
var inst_41173__$1 = (state_41196[(2)]);
var inst_41174 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_41173__$1,endSubject);
var inst_41175 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_41176 = ["?var1",inst_41174];
var inst_41177 = cljs.core.PersistentHashMap.fromArrays(inst_41175,inst_41176);
var state_41196__$1 = (function (){var statearr_41219 = state_41196;
(statearr_41219[(7)] = inst_41173__$1);

(statearr_41219[(8)] = inst_41177);

return statearr_41219;
})();
var statearr_41220_41239 = state_41196__$1;
(statearr_41220_41239[(2)] = null);

(statearr_41220_41239[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____0 = (function (){
var statearr_41221 = [null,null,null,null,null,null,null,null,null];
(statearr_41221[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__);

(statearr_41221[(1)] = (1));

return statearr_41221;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____1 = (function (state_41196){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41196);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41222){var ex__17136__auto__ = e41222;
var statearr_41223_41240 = state_41196;
(statearr_41223_41240[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41196[(4)]))){
var statearr_41224_41241 = state_41196;
(statearr_41224_41241[(1)] = cljs.core.first((state_41196[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41242 = state_41196;
state_41196 = G__41242;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__ = function(state_41196){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____1.call(this,state_41196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41225 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41225[(6)] = c__17207__auto__);

return statearr_41225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e41243){var e = e41243;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e41244){var e = e41244;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e41245){var e = e41245;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e41246){var e = e41246;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41249 = arguments.length;
var i__4737__auto___41250 = (0);
while(true){
if((i__4737__auto___41250 < len__4736__auto___41249)){
args__4742__auto__.push((arguments[i__4737__auto___41250]));

var G__41251 = (i__4737__auto___41250 + (1));
i__4737__auto___41250 = G__41251;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e41248){var e = e41248;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq41247){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41247));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41254 = arguments.length;
var i__4737__auto___41255 = (0);
while(true){
if((i__4737__auto___41255 < len__4736__auto___41254)){
args__4742__auto__.push((arguments[i__4737__auto___41255]));

var G__41256 = (i__4737__auto___41255 + (1));
i__4737__auto___41255 = G__41256;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e41253){var e = e41253;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq41252){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41252));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41259 = arguments.length;
var i__4737__auto___41260 = (0);
while(true){
if((i__4737__auto___41260 < len__4736__auto___41259)){
args__4742__auto__.push((arguments[i__4737__auto___41260]));

var G__41261 = (i__4737__auto___41260 + (1));
i__4737__auto___41260 = G__41261;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e41258){var e = e41258;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq41257){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41257));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41264 = arguments.length;
var i__4737__auto___41265 = (0);
while(true){
if((i__4737__auto___41265 < len__4736__auto___41264)){
args__4742__auto__.push((arguments[i__4737__auto___41265]));

var G__41266 = (i__4737__auto___41265 + (1));
i__4737__auto___41265 = G__41266;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e41263){var e = e41263;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq41262){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41262));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e41267){var e = e41267;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e41268){var e = e41268;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e41269){var e = e41269;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e41270){var e = e41270;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e41271){var e = e41271;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__41277 = path;
var vec__41278 = G__41277;
var seq__41279 = cljs.core.seq(vec__41278);
var first__41280 = cljs.core.first(seq__41279);
var seq__41279__$1 = cljs.core.next(seq__41279);
var pred = first__41280;
var r = seq__41279__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__41277__$1 = G__41277;
var subjects__$1 = subjects;
while(true){
var vec__41284 = G__41277__$1;
var seq__41285 = cljs.core.seq(vec__41284);
var first__41286 = cljs.core.first(seq__41285);
var seq__41285__$1 = cljs.core.next(seq__41285);
var pred__$1 = first__41286;
var r__$1 = seq__41285__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41277__$1,subjects__$1,vec__41284,seq__41285,first__41286,seq__41285__$1,pred__$1,r__$1,subjects__$2,G__41277,vec__41278,seq__41279,first__41280,seq__41279__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__41277__$1,subjects__$1,vec__41284,seq__41285,first__41286,seq__41285__$1,pred__$1,r__$1,subjects__$2,G__41277,vec__41278,seq__41279,first__41280,seq__41279__$1,pred,r,subjects){
return (function (p1__41272_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__41272_SHARP_,pred__$1);
});})(G__41277__$1,subjects__$1,vec__41284,seq__41285,first__41286,seq__41285__$1,pred__$1,r__$1,subjects__$2,G__41277,vec__41278,seq__41279,first__41280,seq__41279__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__41277__$1,subjects__$1,vec__41284,seq__41285,first__41286,seq__41285__$1,pred__$1,r__$1,subjects__$2,G__41277,vec__41278,seq__41279,first__41280,seq__41279__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__41287 = r__$1;
var G__41288 = next_subjects;
G__41277__$1 = G__41287;
subjects__$1 = G__41288;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e41273){var e = e41273;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e41289){var e = e41289;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e41290){var e = e41290;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41293 = arguments.length;
var i__4737__auto___41294 = (0);
while(true){
if((i__4737__auto___41294 < len__4736__auto___41293)){
args__4742__auto__.push((arguments[i__4737__auto___41294]));

var G__41295 = (i__4737__auto___41294 + (1));
i__4737__auto___41294 = G__41295;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e41292){var e = e41292;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq41291){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41291));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e41296){var e = e41296;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41299 = arguments.length;
var i__4737__auto___41300 = (0);
while(true){
if((i__4737__auto___41300 < len__4736__auto___41299)){
args__4742__auto__.push((arguments[i__4737__auto___41300]));

var G__41301 = (i__4737__auto___41300 + (1));
i__4737__auto___41300 = G__41301;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e41298){var e = e41298;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq41297){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41297));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e41302){var e = e41302;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41357){
var state_val_41358 = (state_41357[(1)]);
if((state_val_41358 === (7))){
var inst_41304 = (state_41357[(2)]);
var state_41357__$1 = state_41357;
var statearr_41359_41392 = state_41357__$1;
(statearr_41359_41392[(2)] = inst_41304);

(statearr_41359_41392[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (1))){
var state_41357__$1 = state_41357;
var statearr_41360_41393 = state_41357__$1;
(statearr_41360_41393[(2)] = null);

(statearr_41360_41393[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (4))){
var inst_41303 = (state_41357[(2)]);
var state_41357__$1 = (function (){var statearr_41361 = state_41357;
(statearr_41361[(7)] = inst_41303);

return statearr_41361;
})();
var statearr_41362_41394 = state_41357__$1;
(statearr_41362_41394[(2)] = null);

(statearr_41362_41394[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (15))){
var inst_41341 = (state_41357[(8)]);
var inst_41345 = inst_41341.o;
var state_41357__$1 = state_41357;
var statearr_41363_41395 = state_41357__$1;
(statearr_41363_41395[(2)] = inst_41345);

(statearr_41363_41395[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (13))){
var inst_41341 = (state_41357[(8)]);
var inst_41337 = (state_41357[(2)]);
var inst_41338 = fluree.db.util.async.throw_err(inst_41337);
var inst_41339 = fluree.db.dbfunctions.internal.count(inst_41338);
var inst_41341__$1 = cljs.core.first(inst_41338);
var inst_41342 = (inst_41341__$1 == null);
var state_41357__$1 = (function (){var statearr_41364 = state_41357;
(statearr_41364[(8)] = inst_41341__$1);

(statearr_41364[(9)] = inst_41339);

return statearr_41364;
})();
if(cljs.core.truth_(inst_41342)){
var statearr_41365_41396 = state_41357__$1;
(statearr_41365_41396[(1)] = (14));

} else {
var statearr_41366_41397 = state_41357__$1;
(statearr_41366_41397[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (6))){
var inst_41313 = (state_41357[(2)]);
var state_41357__$1 = state_41357;
var statearr_41367_41398 = state_41357__$1;
(statearr_41367_41398[(2)] = inst_41313);

(statearr_41367_41398[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (3))){
var inst_41355 = (state_41357[(2)]);
var state_41357__$1 = state_41357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41357__$1,inst_41355);
} else {
if((state_val_41358 === (12))){
var inst_41352 = (state_41357[(2)]);
var _ = (function (){var statearr_41368 = state_41357;
(statearr_41368[(4)] = cljs.core.rest((state_41357[(4)])));

return statearr_41368;
})();
var state_41357__$1 = state_41357;
var statearr_41369_41399 = state_41357__$1;
(statearr_41369_41399[(2)] = inst_41352);

(statearr_41369_41399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (2))){
var _ = (function (){var statearr_41371 = state_41357;
(statearr_41371[(4)] = cljs.core.cons((9),(state_41357[(4)])));

return statearr_41371;
})();
var inst_41319 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41320 = typeof inst_41319 === 'string';
var state_41357__$1 = state_41357;
if(cljs.core.truth_(inst_41320)){
var statearr_41372_41400 = state_41357__$1;
(statearr_41372_41400[(1)] = (10));

} else {
var statearr_41373_41401 = state_41357__$1;
(statearr_41373_41401[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (11))){
var inst_41326 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41327 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_41326);
var inst_41328 = fluree.db.dbfunctions.internal.inc(inst_41327);
var inst_41329 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41326,cljs.core.cst$kw$t,inst_41328);
var inst_41330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41331 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41332 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41333 = [inst_41331,inst_41332];
var inst_41334 = (new cljs.core.PersistentVector(null,2,(5),inst_41330,inst_41333,null));
var inst_41335 = fluree.db.dbproto._search(inst_41329,inst_41334);
var state_41357__$1 = state_41357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41357__$1,(13),inst_41335);
} else {
if((state_val_41358 === (9))){
var _ = (function (){var statearr_41374 = state_41357;
(statearr_41374[(4)] = cljs.core.rest((state_41357[(4)])));

return statearr_41374;
})();
var state_41357__$1 = state_41357;
var ex41370 = (state_41357__$1[(2)]);
var statearr_41375_41402 = state_41357__$1;
(statearr_41375_41402[(5)] = ex41370);


var statearr_41376_41403 = state_41357__$1;
(statearr_41376_41403[(1)] = (4));

(statearr_41376_41403[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (5))){
var inst_41303 = (state_41357[(7)]);
var _ = (function (){var statearr_41377 = state_41357;
(statearr_41377[(4)] = cljs.core.cons((8),(state_41357[(4)])));

return statearr_41377;
})();
var inst_41310 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41303,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_41378 = state_41357;
(statearr_41378[(4)] = cljs.core.rest((state_41357[(4)])));

return statearr_41378;
})();
var state_41357__$1 = state_41357;
var statearr_41379_41404 = state_41357__$1;
(statearr_41379_41404[(2)] = inst_41310);

(statearr_41379_41404[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (14))){
var state_41357__$1 = state_41357;
var statearr_41380_41405 = state_41357__$1;
(statearr_41380_41405[(2)] = null);

(statearr_41380_41405[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (16))){
var inst_41339 = (state_41357[(9)]);
var inst_41347 = (state_41357[(2)]);
var inst_41348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41349 = [inst_41347,inst_41339];
var inst_41350 = (new cljs.core.PersistentVector(null,2,(5),inst_41348,inst_41349,null));
var state_41357__$1 = state_41357;
var statearr_41382_41406 = state_41357__$1;
(statearr_41382_41406[(2)] = inst_41350);

(statearr_41382_41406[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (10))){
var inst_41322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41323 = [null,(0)];
var inst_41324 = (new cljs.core.PersistentVector(null,2,(5),inst_41322,inst_41323,null));
var state_41357__$1 = state_41357;
var statearr_41383_41407 = state_41357__$1;
(statearr_41383_41407[(2)] = inst_41324);

(statearr_41383_41407[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41358 === (8))){
var _ = (function (){var statearr_41384 = state_41357;
(statearr_41384[(4)] = cljs.core.rest((state_41357[(4)])));

return statearr_41384;
})();
var state_41357__$1 = state_41357;
var ex41381 = (state_41357__$1[(2)]);
var statearr_41385_41408 = state_41357__$1;
(statearr_41385_41408[(5)] = ex41381);


var statearr_41386_41409 = state_41357__$1;
(statearr_41386_41409[(1)] = (7));

(statearr_41386_41409[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____0 = (function (){
var statearr_41387 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41387[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__);

(statearr_41387[(1)] = (1));

return statearr_41387;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____1 = (function (state_41357){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41357);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41388){var ex__17136__auto__ = e41388;
var statearr_41389_41410 = state_41357;
(statearr_41389_41410[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41357[(4)]))){
var statearr_41390_41411 = state_41357;
(statearr_41390_41411[(1)] = cljs.core.first((state_41357[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41412 = state_41357;
state_41357 = G__41412;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__ = function(state_41357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____1.call(this,state_41357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41391 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41391[(6)] = c__17207__auto__);

return statearr_41391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41464){
var state_val_41465 = (state_41464[(1)]);
if((state_val_41465 === (7))){
var inst_41414 = (state_41464[(2)]);
var state_41464__$1 = state_41464;
var statearr_41466_41495 = state_41464__$1;
(statearr_41466_41495[(2)] = inst_41414);

(statearr_41466_41495[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (1))){
var state_41464__$1 = state_41464;
var statearr_41467_41496 = state_41464__$1;
(statearr_41467_41496[(2)] = null);

(statearr_41467_41496[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (4))){
var inst_41413 = (state_41464[(2)]);
var state_41464__$1 = (function (){var statearr_41468 = state_41464;
(statearr_41468[(7)] = inst_41413);

return statearr_41468;
})();
var statearr_41469_41497 = state_41464__$1;
(statearr_41469_41497[(2)] = null);

(statearr_41469_41497[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (13))){
var inst_41459 = (state_41464[(2)]);
var _ = (function (){var statearr_41470 = state_41464;
(statearr_41470[(4)] = cljs.core.rest((state_41464[(4)])));

return statearr_41470;
})();
var state_41464__$1 = state_41464;
var statearr_41471_41498 = state_41464__$1;
(statearr_41471_41498[(2)] = inst_41459);

(statearr_41471_41498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (6))){
var inst_41423 = (state_41464[(2)]);
var state_41464__$1 = state_41464;
var statearr_41472_41499 = state_41464__$1;
(statearr_41472_41499[(2)] = inst_41423);

(statearr_41472_41499[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (3))){
var inst_41462 = (state_41464[(2)]);
var state_41464__$1 = state_41464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41464__$1,inst_41462);
} else {
if((state_val_41465 === (12))){
var inst_41446 = (state_41464[(8)]);
var inst_41455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41456 = [null,inst_41446];
var inst_41457 = (new cljs.core.PersistentVector(null,2,(5),inst_41455,inst_41456,null));
var state_41464__$1 = state_41464;
var statearr_41473_41500 = state_41464__$1;
(statearr_41473_41500[(2)] = inst_41457);

(statearr_41473_41500[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (2))){
var _ = (function (){var statearr_41475 = state_41464;
(statearr_41475[(4)] = cljs.core.cons((9),(state_41464[(4)])));

return statearr_41475;
})();
var inst_41432 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41435 = [null,pred_name,"?o"];
var inst_41436 = (new cljs.core.PersistentVector(null,3,(5),inst_41434,inst_41435,null));
var inst_41437 = [inst_41436];
var inst_41438 = (new cljs.core.PersistentVector(null,1,(5),inst_41433,inst_41437,null));
var inst_41439 = ["?o",inst_41438,opts];
var inst_41440 = cljs.core.PersistentHashMap.fromArrays(inst_41432,inst_41439);
var inst_41441 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41440);
var state_41464__$1 = state_41464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41464__$1,(10),inst_41441);
} else {
if((state_val_41465 === (11))){
var inst_41445 = (state_41464[(9)]);
var inst_41446 = (state_41464[(8)]);
var inst_41450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41451 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_41445);
var inst_41452 = [inst_41451,inst_41446];
var inst_41453 = (new cljs.core.PersistentVector(null,2,(5),inst_41450,inst_41452,null));
var state_41464__$1 = state_41464;
var statearr_41476_41501 = state_41464__$1;
(statearr_41476_41501[(2)] = inst_41453);

(statearr_41476_41501[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (9))){
var _ = (function (){var statearr_41477 = state_41464;
(statearr_41477[(4)] = cljs.core.rest((state_41464[(4)])));

return statearr_41477;
})();
var state_41464__$1 = state_41464;
var ex41474 = (state_41464__$1[(2)]);
var statearr_41478_41502 = state_41464__$1;
(statearr_41478_41502[(5)] = ex41474);


var statearr_41479_41503 = state_41464__$1;
(statearr_41479_41503[(1)] = (4));

(statearr_41479_41503[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (5))){
var inst_41413 = (state_41464[(7)]);
var _ = (function (){var statearr_41481 = state_41464;
(statearr_41481[(4)] = cljs.core.cons((8),(state_41464[(4)])));

return statearr_41481;
})();
var inst_41420 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41413,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_41482 = state_41464;
(statearr_41482[(4)] = cljs.core.rest((state_41464[(4)])));

return statearr_41482;
})();
var state_41464__$1 = state_41464;
var statearr_41483_41504 = state_41464__$1;
(statearr_41483_41504[(2)] = inst_41420);

(statearr_41483_41504[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (10))){
var inst_41445 = (state_41464[(9)]);
var inst_41443 = (state_41464[(2)]);
var inst_41444 = fluree.db.util.async.throw_err(inst_41443);
var inst_41445__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41444,(0),null);
var inst_41446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41444,(1),null);
var inst_41447 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_41445__$1);
var inst_41448 = cljs.core.not(inst_41447);
var state_41464__$1 = (function (){var statearr_41484 = state_41464;
(statearr_41484[(9)] = inst_41445__$1);

(statearr_41484[(8)] = inst_41446);

return statearr_41484;
})();
if(inst_41448){
var statearr_41485_41505 = state_41464__$1;
(statearr_41485_41505[(1)] = (11));

} else {
var statearr_41486_41506 = state_41464__$1;
(statearr_41486_41506[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41465 === (8))){
var _ = (function (){var statearr_41487 = state_41464;
(statearr_41487[(4)] = cljs.core.rest((state_41464[(4)])));

return statearr_41487;
})();
var state_41464__$1 = state_41464;
var ex41480 = (state_41464__$1[(2)]);
var statearr_41488_41507 = state_41464__$1;
(statearr_41488_41507[(5)] = ex41480);


var statearr_41489_41508 = state_41464__$1;
(statearr_41489_41508[(1)] = (7));

(statearr_41489_41508[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____0 = (function (){
var statearr_41490 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41490[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__);

(statearr_41490[(1)] = (1));

return statearr_41490;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____1 = (function (state_41464){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41464);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41491){var ex__17136__auto__ = e41491;
var statearr_41492_41509 = state_41464;
(statearr_41492_41509[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41464[(4)]))){
var statearr_41493_41510 = state_41464;
(statearr_41493_41510[(1)] = cljs.core.first((state_41464[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41511 = state_41464;
state_41464 = G__41511;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__ = function(state_41464){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____1.call(this,state_41464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41494 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41494[(6)] = c__17207__auto__);

return statearr_41494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e41512){var e = e41512;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41514 = arguments.length;
switch (G__41514) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41584){
var state_val_41585 = (state_41584[(1)]);
if((state_val_41585 === (7))){
var inst_41516 = (state_41584[(2)]);
var state_41584__$1 = state_41584;
var statearr_41586_41630 = state_41584__$1;
(statearr_41586_41630[(2)] = inst_41516);

(statearr_41586_41630[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (20))){
var inst_41560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41561 = ["*"];
var inst_41562 = (new cljs.core.PersistentVector(null,1,(5),inst_41560,inst_41561,null));
var state_41584__$1 = state_41584;
var statearr_41587_41631 = state_41584__$1;
(statearr_41587_41631[(2)] = inst_41562);

(statearr_41587_41631[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (1))){
var state_41584__$1 = state_41584;
var statearr_41588_41632 = state_41584__$1;
(statearr_41588_41632[(2)] = null);

(statearr_41588_41632[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (4))){
var inst_41515 = (state_41584[(2)]);
var state_41584__$1 = (function (){var statearr_41589 = state_41584;
(statearr_41589[(7)] = inst_41515);

return statearr_41589;
})();
var statearr_41590_41633 = state_41584__$1;
(statearr_41590_41633[(2)] = null);

(statearr_41590_41633[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (15))){
var inst_41579 = (state_41584[(2)]);
var _ = (function (){var statearr_41591 = state_41584;
(statearr_41591[(4)] = cljs.core.rest((state_41584[(4)])));

return statearr_41591;
})();
var state_41584__$1 = state_41584;
var statearr_41592_41634 = state_41584__$1;
(statearr_41592_41634[(2)] = inst_41579);

(statearr_41592_41634[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (21))){
var inst_41543 = (state_41584[(8)]);
var inst_41550 = (state_41584[(9)]);
var inst_41564 = (state_41584[(2)]);
var inst_41565 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41566 = cljs.core.PersistentHashMap.EMPTY;
var inst_41567 = [inst_41564,inst_41550,inst_41566];
var inst_41568 = cljs.core.PersistentHashMap.fromArrays(inst_41565,inst_41567);
var inst_41569 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41543,inst_41568);
var state_41584__$1 = state_41584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41584__$1,(22),inst_41569);
} else {
if((state_val_41585 === (13))){
var inst_41538 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41584__$1 = state_41584;
var statearr_41593_41635 = state_41584__$1;
(statearr_41593_41635[(2)] = inst_41538);

(statearr_41593_41635[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (22))){
var inst_41571 = (state_41584[(2)]);
var inst_41572 = fluree.db.util.async.throw_err(inst_41571);
var inst_41573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41572,(0),null);
var inst_41574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41572,(1),null);
var inst_41575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41576 = [inst_41573,inst_41574];
var inst_41577 = (new cljs.core.PersistentVector(null,2,(5),inst_41575,inst_41576,null));
var state_41584__$1 = state_41584;
var statearr_41594_41636 = state_41584__$1;
(statearr_41594_41636[(2)] = inst_41577);

(statearr_41594_41636[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (6))){
var inst_41525 = (state_41584[(2)]);
var state_41584__$1 = state_41584;
var statearr_41595_41637 = state_41584__$1;
(statearr_41595_41637[(2)] = inst_41525);

(statearr_41595_41637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (17))){
var inst_41547 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41548 = fluree.db.dbfunctions.internal.get(inst_41547,cljs.core.cst$kw$_id);
var state_41584__$1 = state_41584;
var statearr_41596_41638 = state_41584__$1;
(statearr_41596_41638[(2)] = inst_41548);

(statearr_41596_41638[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (3))){
var inst_41582 = (state_41584[(2)]);
var state_41584__$1 = state_41584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41584__$1,inst_41582);
} else {
if((state_val_41585 === (12))){
var inst_41536 = (state_41584[(2)]);
var state_41584__$1 = state_41584;
if(cljs.core.truth_(inst_41536)){
var statearr_41597_41639 = state_41584__$1;
(statearr_41597_41639[(1)] = (13));

} else {
var statearr_41598_41640 = state_41584__$1;
(statearr_41598_41640[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (2))){
var inst_41531 = (state_41584[(10)]);
var _ = (function (){var statearr_41599 = state_41584;
(statearr_41599[(4)] = cljs.core.cons((9),(state_41584[(4)])));

return statearr_41599;
})();
var inst_41531__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41584__$1 = (function (){var statearr_41600 = state_41584;
(statearr_41600[(10)] = inst_41531__$1);

return statearr_41600;
})();
if(cljs.core.truth_(inst_41531__$1)){
var statearr_41601_41641 = state_41584__$1;
(statearr_41601_41641[(1)] = (10));

} else {
var statearr_41602_41642 = state_41584__$1;
(statearr_41602_41642[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (19))){
var inst_41552 = cljs.core.PersistentVector.EMPTY;
var inst_41553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41554 = ["*"];
var inst_41555 = (new cljs.core.PersistentVector(null,1,(5),inst_41553,inst_41554,null));
var inst_41556 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41557 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41555,inst_41556);
var inst_41558 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41552,inst_41557);
var state_41584__$1 = state_41584;
var statearr_41604_41643 = state_41584__$1;
(statearr_41604_41643[(2)] = inst_41558);

(statearr_41604_41643[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (11))){
var inst_41531 = (state_41584[(10)]);
var state_41584__$1 = state_41584;
var statearr_41605_41644 = state_41584__$1;
(statearr_41605_41644[(2)] = inst_41531);

(statearr_41605_41644[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (9))){
var _ = (function (){var statearr_41606 = state_41584;
(statearr_41606[(4)] = cljs.core.rest((state_41584[(4)])));

return statearr_41606;
})();
var state_41584__$1 = state_41584;
var ex41603 = (state_41584__$1[(2)]);
var statearr_41607_41645 = state_41584__$1;
(statearr_41607_41645[(5)] = ex41603);


var statearr_41608_41646 = state_41584__$1;
(statearr_41608_41646[(1)] = (4));

(statearr_41608_41646[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (5))){
var inst_41515 = (state_41584[(7)]);
var _ = (function (){var statearr_41609 = state_41584;
(statearr_41609[(4)] = cljs.core.cons((8),(state_41584[(4)])));

return statearr_41609;
})();
var inst_41522 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41515,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_41610 = state_41584;
(statearr_41610[(4)] = cljs.core.rest((state_41584[(4)])));

return statearr_41610;
})();
var state_41584__$1 = state_41584;
var statearr_41611_41647 = state_41584__$1;
(statearr_41611_41647[(2)] = inst_41522);

(statearr_41611_41647[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (14))){
var inst_41544 = (state_41584[(11)]);
var inst_41543 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41544__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41584__$1 = (function (){var statearr_41612 = state_41584;
(statearr_41612[(8)] = inst_41543);

(statearr_41612[(11)] = inst_41544__$1);

return statearr_41612;
})();
if(cljs.core.truth_(inst_41544__$1)){
var statearr_41613_41648 = state_41584__$1;
(statearr_41613_41648[(1)] = (16));

} else {
var statearr_41614_41649 = state_41584__$1;
(statearr_41614_41649[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (16))){
var inst_41544 = (state_41584[(11)]);
var state_41584__$1 = state_41584;
var statearr_41615_41650 = state_41584__$1;
(statearr_41615_41650[(2)] = inst_41544);

(statearr_41615_41650[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (10))){
var inst_41533 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_41584__$1 = state_41584;
var statearr_41617_41651 = state_41584__$1;
(statearr_41617_41651[(2)] = inst_41533);

(statearr_41617_41651[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (18))){
var inst_41550 = (state_41584[(2)]);
var state_41584__$1 = (function (){var statearr_41618 = state_41584;
(statearr_41618[(9)] = inst_41550);

return statearr_41618;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41619_41652 = state_41584__$1;
(statearr_41619_41652[(1)] = (19));

} else {
var statearr_41620_41653 = state_41584__$1;
(statearr_41620_41653[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41585 === (8))){
var _ = (function (){var statearr_41621 = state_41584;
(statearr_41621[(4)] = cljs.core.rest((state_41584[(4)])));

return statearr_41621;
})();
var state_41584__$1 = state_41584;
var ex41616 = (state_41584__$1[(2)]);
var statearr_41622_41654 = state_41584__$1;
(statearr_41622_41654[(5)] = ex41616);


var statearr_41623_41655 = state_41584__$1;
(statearr_41623_41655[(1)] = (7));

(statearr_41623_41655[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17133__auto____0 = (function (){
var statearr_41624 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41624[(0)] = fluree$db$dbfunctions$internal$state_machine__17133__auto__);

(statearr_41624[(1)] = (1));

return statearr_41624;
});
var fluree$db$dbfunctions$internal$state_machine__17133__auto____1 = (function (state_41584){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41584);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41625){var ex__17136__auto__ = e41625;
var statearr_41626_41656 = state_41584;
(statearr_41626_41656[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41584[(4)]))){
var statearr_41627_41657 = state_41584;
(statearr_41627_41657[(1)] = cljs.core.first((state_41584[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41658 = state_41584;
state_41584 = G__41658;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17133__auto__ = function(state_41584){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____1.call(this,state_41584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41628 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41628[(6)] = c__17207__auto__);

return statearr_41628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__41660 = arguments.length;
switch (G__41660) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41704){
var state_val_41705 = (state_41704[(1)]);
if((state_val_41705 === (7))){
var inst_41682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41683 = ["*"];
var inst_41684 = (new cljs.core.PersistentVector(null,1,(5),inst_41682,inst_41683,null));
var state_41704__$1 = state_41704;
var statearr_41706_41726 = state_41704__$1;
(statearr_41706_41726[(2)] = inst_41684);

(statearr_41706_41726[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (1))){
var state_41704__$1 = state_41704;
var statearr_41707_41727 = state_41704__$1;
(statearr_41707_41727[(2)] = null);

(statearr_41707_41727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (4))){
var inst_41661 = (state_41704[(2)]);
var inst_41662 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41661,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_41704__$1 = state_41704;
var statearr_41708_41728 = state_41704__$1;
(statearr_41708_41728[(2)] = inst_41662);

(statearr_41708_41728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (6))){
var inst_41674 = cljs.core.PersistentVector.EMPTY;
var inst_41675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41676 = ["*"];
var inst_41677 = (new cljs.core.PersistentVector(null,1,(5),inst_41675,inst_41676,null));
var inst_41678 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41679 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41677,inst_41678);
var inst_41680 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41674,inst_41679);
var state_41704__$1 = state_41704;
var statearr_41709_41729 = state_41704__$1;
(statearr_41709_41729[(2)] = inst_41680);

(statearr_41709_41729[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (3))){
var inst_41702 = (state_41704[(2)]);
var state_41704__$1 = state_41704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41704__$1,inst_41702);
} else {
if((state_val_41705 === (2))){
var _ = (function (){var statearr_41711 = state_41704;
(statearr_41711[(4)] = cljs.core.cons((5),(state_41704[(4)])));

return statearr_41711;
})();
var inst_41671 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41672 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41704__$1 = (function (){var statearr_41712 = state_41704;
(statearr_41712[(7)] = inst_41672);

(statearr_41712[(8)] = inst_41671);

return statearr_41712;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41713_41730 = state_41704__$1;
(statearr_41713_41730[(1)] = (6));

} else {
var statearr_41714_41731 = state_41704__$1;
(statearr_41714_41731[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (9))){
var inst_41693 = (state_41704[(2)]);
var inst_41694 = fluree.db.util.async.throw_err(inst_41693);
var inst_41695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41694,(0),null);
var inst_41696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41694,(1),null);
var inst_41697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41698 = [inst_41695,inst_41696];
var inst_41699 = (new cljs.core.PersistentVector(null,2,(5),inst_41697,inst_41698,null));
var _ = (function (){var statearr_41715 = state_41704;
(statearr_41715[(4)] = cljs.core.rest((state_41704[(4)])));

return statearr_41715;
})();
var state_41704__$1 = state_41704;
var statearr_41716_41732 = state_41704__$1;
(statearr_41716_41732[(2)] = inst_41699);

(statearr_41716_41732[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (5))){
var _ = (function (){var statearr_41717 = state_41704;
(statearr_41717[(4)] = cljs.core.rest((state_41704[(4)])));

return statearr_41717;
})();
var state_41704__$1 = state_41704;
var ex41710 = (state_41704__$1[(2)]);
var statearr_41718_41733 = state_41704__$1;
(statearr_41718_41733[(5)] = ex41710);


var statearr_41719_41734 = state_41704__$1;
(statearr_41719_41734[(1)] = (4));

(statearr_41719_41734[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41705 === (8))){
var inst_41672 = (state_41704[(7)]);
var inst_41671 = (state_41704[(8)]);
var inst_41686 = (state_41704[(2)]);
var inst_41687 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41688 = cljs.core.PersistentHashMap.EMPTY;
var inst_41689 = [inst_41686,inst_41672,inst_41688];
var inst_41690 = cljs.core.PersistentHashMap.fromArrays(inst_41687,inst_41689);
var inst_41691 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41671,inst_41690);
var state_41704__$1 = state_41704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41704__$1,(9),inst_41691);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__17133__auto____0 = (function (){
var statearr_41720 = [null,null,null,null,null,null,null,null,null];
(statearr_41720[(0)] = fluree$db$dbfunctions$internal$state_machine__17133__auto__);

(statearr_41720[(1)] = (1));

return statearr_41720;
});
var fluree$db$dbfunctions$internal$state_machine__17133__auto____1 = (function (state_41704){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41704);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41721){var ex__17136__auto__ = e41721;
var statearr_41722_41735 = state_41704;
(statearr_41722_41735[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41704[(4)]))){
var statearr_41723_41736 = state_41704;
(statearr_41723_41736[(1)] = cljs.core.first((state_41704[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41737 = state_41704;
state_41704 = G__41737;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__17133__auto__ = function(state_41704){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__17133__auto____1.call(this,state_41704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41724 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41724[(6)] = c__17207__auto__);

return statearr_41724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41781){
var state_val_41782 = (state_41781[(1)]);
if((state_val_41782 === (1))){
var state_41781__$1 = state_41781;
var statearr_41783_41797 = state_41781__$1;
(statearr_41783_41797[(2)] = null);

(statearr_41783_41797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41782 === (2))){
var _ = (function (){var statearr_41784 = state_41781;
(statearr_41784[(4)] = cljs.core.cons((5),(state_41781[(4)])));

return statearr_41784;
})();
var inst_41748 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41750 = ["_user/_auth"];
var inst_41751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41752 = ["*"];
var inst_41753 = (new cljs.core.PersistentVector(null,1,(5),inst_41751,inst_41752,null));
var inst_41754 = [inst_41753];
var inst_41755 = cljs.core.PersistentHashMap.fromArrays(inst_41750,inst_41754);
var inst_41756 = [inst_41755];
var inst_41757 = (new cljs.core.PersistentVector(null,1,(5),inst_41749,inst_41756,null));
var inst_41758 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41759 = cljs.core.PersistentHashMap.EMPTY;
var inst_41760 = [inst_41757,inst_41758,inst_41759];
var inst_41761 = cljs.core.PersistentHashMap.fromArrays(inst_41748,inst_41760);
var inst_41762 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41763 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41762,inst_41761);
var state_41781__$1 = state_41781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41781__$1,(6),inst_41763);
} else {
if((state_val_41782 === (3))){
var inst_41779 = (state_41781[(2)]);
var state_41781__$1 = state_41781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41781__$1,inst_41779);
} else {
if((state_val_41782 === (4))){
var inst_41738 = (state_41781[(2)]);
var inst_41739 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41738,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_41781__$1 = state_41781;
var statearr_41786_41798 = state_41781__$1;
(statearr_41786_41798[(2)] = inst_41739);

(statearr_41786_41798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41782 === (5))){
var _ = (function (){var statearr_41787 = state_41781;
(statearr_41787[(4)] = cljs.core.rest((state_41781[(4)])));

return statearr_41787;
})();
var state_41781__$1 = state_41781;
var ex41785 = (state_41781__$1[(2)]);
var statearr_41788_41799 = state_41781__$1;
(statearr_41788_41799[(5)] = ex41785);


var statearr_41789_41800 = state_41781__$1;
(statearr_41789_41800[(1)] = (4));

(statearr_41789_41800[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41782 === (6))){
var inst_41765 = (state_41781[(2)]);
var inst_41766 = fluree.db.util.async.throw_err(inst_41765);
var inst_41767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41766,(0),null);
var inst_41768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41766,(1),null);
var inst_41769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41770 = ["_user/_auth","_id"];
var inst_41771 = (new cljs.core.PersistentVector(null,2,(5),inst_41769,inst_41770,null));
var inst_41772 = fluree.db.dbfunctions.internal.get_in(inst_41767,inst_41771);
var inst_41773 = cljs.core.first(inst_41772);
var inst_41774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41775 = [inst_41773,inst_41768];
var inst_41776 = (new cljs.core.PersistentVector(null,2,(5),inst_41774,inst_41775,null));
var _ = (function (){var statearr_41790 = state_41781;
(statearr_41790[(4)] = cljs.core.rest((state_41781[(4)])));

return statearr_41790;
})();
var state_41781__$1 = state_41781;
var statearr_41791_41801 = state_41781__$1;
(statearr_41791_41801[(2)] = inst_41776);

(statearr_41791_41801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____0 = (function (){
var statearr_41792 = [null,null,null,null,null,null,null];
(statearr_41792[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__);

(statearr_41792[(1)] = (1));

return statearr_41792;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____1 = (function (state_41781){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41781);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41793){var ex__17136__auto__ = e41793;
var statearr_41794_41802 = state_41781;
(statearr_41794_41802[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41781[(4)]))){
var statearr_41795_41803 = state_41781;
(statearr_41795_41803[(1)] = cljs.core.first((state_41781[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41804 = state_41781;
state_41781 = G__41804;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__ = function(state_41781){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____1.call(this,state_41781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41796 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41796[(6)] = c__17207__auto__);

return statearr_41796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41821){
var state_val_41822 = (state_41821[(1)]);
if((state_val_41822 === (1))){
var state_41821__$1 = state_41821;
var statearr_41823_41837 = state_41821__$1;
(statearr_41823_41837[(2)] = null);

(statearr_41823_41837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41822 === (2))){
var _ = (function (){var statearr_41824 = state_41821;
(statearr_41824[(4)] = cljs.core.cons((5),(state_41821[(4)])));

return statearr_41824;
})();
var inst_41811 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41812 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41813 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_41812,inst_41811);
var state_41821__$1 = state_41821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41821__$1,(6),inst_41813);
} else {
if((state_val_41822 === (3))){
var inst_41819 = (state_41821[(2)]);
var state_41821__$1 = state_41821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41821__$1,inst_41819);
} else {
if((state_val_41822 === (4))){
var inst_41805 = (state_41821[(2)]);
var state_41821__$1 = state_41821;
var statearr_41826_41838 = state_41821__$1;
(statearr_41826_41838[(2)] = inst_41805);

(statearr_41826_41838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41822 === (5))){
var _ = (function (){var statearr_41827 = state_41821;
(statearr_41827[(4)] = cljs.core.rest((state_41821[(4)])));

return statearr_41827;
})();
var state_41821__$1 = state_41821;
var ex41825 = (state_41821__$1[(2)]);
var statearr_41828_41839 = state_41821__$1;
(statearr_41828_41839[(5)] = ex41825);


if((ex41825 instanceof Error)){
var statearr_41829_41840 = state_41821__$1;
(statearr_41829_41840[(1)] = (4));

(statearr_41829_41840[(5)] = null);

} else {
throw ex41825;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41822 === (6))){
var inst_41815 = (state_41821[(2)]);
var inst_41816 = fluree.db.util.async.throw_err(inst_41815);
var _ = (function (){var statearr_41830 = state_41821;
(statearr_41830[(4)] = cljs.core.rest((state_41821[(4)])));

return statearr_41830;
})();
var state_41821__$1 = state_41821;
var statearr_41831_41841 = state_41821__$1;
(statearr_41831_41841[(2)] = inst_41816);

(statearr_41831_41841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____0 = (function (){
var statearr_41832 = [null,null,null,null,null,null,null];
(statearr_41832[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__);

(statearr_41832[(1)] = (1));

return statearr_41832;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____1 = (function (state_41821){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41821);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41833){var ex__17136__auto__ = e41833;
var statearr_41834_41842 = state_41821;
(statearr_41834_41842[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41821[(4)]))){
var statearr_41835_41843 = state_41821;
(statearr_41835_41843[(1)] = cljs.core.first((state_41821[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__41844 = state_41821;
state_41821 = G__41844;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__ = function(state_41821){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____1.call(this,state_41821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_41836 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_41836[(6)] = c__17207__auto__);

return statearr_41836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__41845_SHARP_){
return p1__41845_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41846_SHARP_){
return p1__41846_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41847){var e = e41847;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__41848_SHARP_){
return p1__41848_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41849_SHARP_){
return p1__41849_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41850){var e = e41850;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__41852 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__41852);
})() | (0));
return num;
}catch (e41851){var e = e41851;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_41952){
var state_val_41953 = (state_41952[(1)]);
if((state_val_41953 === (7))){
var state_41952__$1 = state_41952;
var statearr_41954_42002 = state_41952__$1;
(statearr_41954_42002[(2)] = false);

(statearr_41954_42002[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (20))){
var inst_41887 = (state_41952[(7)]);
var inst_41886 = (state_41952[(8)]);
var inst_41908 = (state_41952[(2)]);
var inst_41909 = fluree.db.dbproto._p_prop(inst_41887,cljs.core.cst$kw$multi,inst_41886);
var state_41952__$1 = (function (){var statearr_41955 = state_41952;
(statearr_41955[(9)] = inst_41908);

return statearr_41955;
})();
if(cljs.core.truth_(inst_41909)){
var statearr_41956_42003 = state_41952__$1;
(statearr_41956_42003[(1)] = (21));

} else {
var statearr_41957_42004 = state_41952__$1;
(statearr_41957_42004[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (27))){
var inst_41947 = (state_41952[(2)]);
var _ = (function (){var statearr_41958 = state_41952;
(statearr_41958[(4)] = cljs.core.rest((state_41952[(4)])));

return statearr_41958;
})();
var state_41952__$1 = state_41952;
var statearr_41959_42005 = state_41952__$1;
(statearr_41959_42005[(2)] = inst_41947);

(statearr_41959_42005[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (1))){
var state_41952__$1 = state_41952;
var statearr_41960_42006 = state_41952__$1;
(statearr_41960_42006[(2)] = null);

(statearr_41960_42006[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (24))){
var inst_41936 = (state_41952[(10)]);
var inst_41932 = (state_41952[(2)]);
var inst_41933 = fluree.db.util.async.throw_err(inst_41932);
var inst_41934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41933,(0),null);
var inst_41935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41933,(1),null);
var inst_41936__$1 = cljs.core.first(inst_41934);
var inst_41937 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41936__$1,compare_val);
var state_41952__$1 = (function (){var statearr_41961 = state_41952;
(statearr_41961[(11)] = inst_41935);

(statearr_41961[(10)] = inst_41936__$1);

return statearr_41961;
})();
if(inst_41937){
var statearr_41962_42007 = state_41952__$1;
(statearr_41962_42007[(1)] = (25));

} else {
var statearr_41963_42008 = state_41952__$1;
(statearr_41963_42008[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (4))){
var inst_41853 = (state_41952[(2)]);
var state_41952__$1 = state_41952;
var statearr_41964_42009 = state_41952__$1;
(statearr_41964_42009[(2)] = inst_41853);

(statearr_41964_42009[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (15))){
var state_41952__$1 = state_41952;
var statearr_41965_42010 = state_41952__$1;
(statearr_41965_42010[(2)] = null);

(statearr_41965_42010[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (21))){
var inst_41888 = (state_41952[(12)]);
var inst_41911 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_41888], 0));
var inst_41912 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41913 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41914 = cljs.core.PersistentHashMap.fromArrays(inst_41912,inst_41913);
var inst_41915 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41911,inst_41914);
var inst_41916 = (function(){throw inst_41915})();
var state_41952__$1 = state_41952;
var statearr_41966_42011 = state_41952__$1;
(statearr_41966_42011[(2)] = inst_41916);

(statearr_41966_42011[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (13))){
var inst_41863 = (state_41952[(13)]);
var state_41952__$1 = state_41952;
var statearr_41967_42012 = state_41952__$1;
(statearr_41967_42012[(2)] = inst_41863);

(statearr_41967_42012[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (22))){
var state_41952__$1 = state_41952;
var statearr_41968_42013 = state_41952__$1;
(statearr_41968_42013[(2)] = null);

(statearr_41968_42013[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (6))){
var inst_41863 = (state_41952[(13)]);
var inst_41868 = inst_41863.cljs$lang$protocol_mask$partition0$;
var inst_41869 = (inst_41868 & (64));
var inst_41870 = inst_41863.cljs$core$ISeq$;
var inst_41871 = (cljs.core.PROTOCOL_SENTINEL === inst_41870);
var inst_41872 = ((inst_41869) || (inst_41871));
var state_41952__$1 = state_41952;
if(cljs.core.truth_(inst_41872)){
var statearr_41969_42014 = state_41952__$1;
(statearr_41969_42014[(1)] = (9));

} else {
var statearr_41970_42015 = state_41952__$1;
(statearr_41970_42015[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (25))){
var state_41952__$1 = state_41952;
var statearr_41971_42016 = state_41952__$1;
(statearr_41971_42016[(2)] = new_val);

(statearr_41971_42016[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (17))){
var inst_41888 = (state_41952[(12)]);
var inst_41898 = (state_41952[(2)]);
var state_41952__$1 = (function (){var statearr_41972 = state_41952;
(statearr_41972[(14)] = inst_41898);

return statearr_41972;
})();
if(cljs.core.truth_(inst_41888)){
var statearr_41973_42017 = state_41952__$1;
(statearr_41973_42017[(1)] = (18));

} else {
var statearr_41974_42018 = state_41952__$1;
(statearr_41974_42018[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (3))){
var inst_41950 = (state_41952[(2)]);
var state_41952__$1 = state_41952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41952__$1,inst_41950);
} else {
if((state_val_41953 === (12))){
var inst_41863 = (state_41952[(13)]);
var inst_41881 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_41863);
var state_41952__$1 = state_41952;
var statearr_41975_42019 = state_41952__$1;
(statearr_41975_42019[(2)] = inst_41881);

(statearr_41975_42019[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (2))){
var inst_41863 = (state_41952[(13)]);
var _ = (function (){var statearr_41976 = state_41952;
(statearr_41976[(4)] = cljs.core.cons((5),(state_41952[(4)])));

return statearr_41976;
})();
var inst_41863__$1 = _QMARK_ctx;
var inst_41865 = (inst_41863__$1 == null);
var inst_41866 = cljs.core.not(inst_41865);
var state_41952__$1 = (function (){var statearr_41977 = state_41952;
(statearr_41977[(13)] = inst_41863__$1);

return statearr_41977;
})();
if(inst_41866){
var statearr_41978_42020 = state_41952__$1;
(statearr_41978_42020[(1)] = (6));

} else {
var statearr_41979_42021 = state_41952__$1;
(statearr_41979_42021[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (23))){
var inst_41887 = (state_41952[(7)]);
var inst_41885 = (state_41952[(15)]);
var inst_41888 = (state_41952[(12)]);
var inst_41919 = (state_41952[(2)]);
var inst_41920 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41923 = [inst_41885,inst_41888,"?current-val"];
var inst_41924 = (new cljs.core.PersistentVector(null,3,(5),inst_41922,inst_41923,null));
var inst_41925 = [inst_41924];
var inst_41926 = (new cljs.core.PersistentVector(null,1,(5),inst_41921,inst_41925,null));
var inst_41927 = cljs.core.PersistentHashMap.EMPTY;
var inst_41928 = ["?current-val",inst_41926,inst_41927];
var inst_41929 = cljs.core.PersistentHashMap.fromArrays(inst_41920,inst_41928);
var inst_41930 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41887,inst_41929);
var state_41952__$1 = (function (){var statearr_41980 = state_41952;
(statearr_41980[(16)] = inst_41919);

return statearr_41980;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41952__$1,(24),inst_41930);
} else {
if((state_val_41953 === (19))){
var inst_41901 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41902 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41903 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41904 = cljs.core.PersistentHashMap.fromArrays(inst_41902,inst_41903);
var inst_41905 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41901,inst_41904);
var inst_41906 = (function(){throw inst_41905})();
var state_41952__$1 = state_41952;
var statearr_41981_42022 = state_41952__$1;
(statearr_41981_42022[(2)] = inst_41906);

(statearr_41981_42022[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (11))){
var inst_41876 = (state_41952[(2)]);
var state_41952__$1 = state_41952;
var statearr_41983_42023 = state_41952__$1;
(statearr_41983_42023[(2)] = inst_41876);

(statearr_41983_42023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (9))){
var state_41952__$1 = state_41952;
var statearr_41984_42024 = state_41952__$1;
(statearr_41984_42024[(2)] = true);

(statearr_41984_42024[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (5))){
var _ = (function (){var statearr_41985 = state_41952;
(statearr_41985[(4)] = cljs.core.rest((state_41952[(4)])));

return statearr_41985;
})();
var state_41952__$1 = state_41952;
var ex41982 = (state_41952__$1[(2)]);
var statearr_41986_42025 = state_41952__$1;
(statearr_41986_42025[(5)] = ex41982);


if((ex41982 instanceof Error)){
var statearr_41987_42026 = state_41952__$1;
(statearr_41987_42026[(1)] = (4));

(statearr_41987_42026[(5)] = null);

} else {
throw ex41982;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (14))){
var inst_41887 = (state_41952[(7)]);
var inst_41885 = (state_41952[(15)]);
var inst_41886 = (state_41952[(8)]);
var inst_41884 = (state_41952[(2)]);
var inst_41885__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41884,cljs.core.cst$kw$sid);
var inst_41886__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41884,cljs.core.cst$kw$pid);
var inst_41887__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41884,cljs.core.cst$kw$db);
var inst_41888 = fluree.db.dbproto._p_prop(inst_41887__$1,cljs.core.cst$kw$name,inst_41886__$1);
var state_41952__$1 = (function (){var statearr_41988 = state_41952;
(statearr_41988[(7)] = inst_41887__$1);

(statearr_41988[(15)] = inst_41885__$1);

(statearr_41988[(12)] = inst_41888);

(statearr_41988[(8)] = inst_41886__$1);

return statearr_41988;
})();
if(cljs.core.truth_(inst_41885__$1)){
var statearr_41989_42027 = state_41952__$1;
(statearr_41989_42027[(1)] = (15));

} else {
var statearr_41990_42028 = state_41952__$1;
(statearr_41990_42028[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (26))){
var inst_41936 = (state_41952[(10)]);
var inst_41940 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41936)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_41941 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41942 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41943 = cljs.core.PersistentHashMap.fromArrays(inst_41941,inst_41942);
var inst_41944 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41940,inst_41943);
var inst_41945 = (function(){throw inst_41944})();
var state_41952__$1 = state_41952;
var statearr_41991_42029 = state_41952__$1;
(statearr_41991_42029[(2)] = inst_41945);

(statearr_41991_42029[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (16))){
var inst_41891 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41892 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41893 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41894 = cljs.core.PersistentHashMap.fromArrays(inst_41892,inst_41893);
var inst_41895 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41891,inst_41894);
var inst_41896 = (function(){throw inst_41895})();
var state_41952__$1 = state_41952;
var statearr_41992_42030 = state_41952__$1;
(statearr_41992_42030[(2)] = inst_41896);

(statearr_41992_42030[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (10))){
var state_41952__$1 = state_41952;
var statearr_41993_42031 = state_41952__$1;
(statearr_41993_42031[(2)] = false);

(statearr_41993_42031[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (18))){
var state_41952__$1 = state_41952;
var statearr_41994_42032 = state_41952__$1;
(statearr_41994_42032[(2)] = null);

(statearr_41994_42032[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41953 === (8))){
var inst_41879 = (state_41952[(2)]);
var state_41952__$1 = state_41952;
if(cljs.core.truth_(inst_41879)){
var statearr_41995_42033 = state_41952__$1;
(statearr_41995_42033[(1)] = (12));

} else {
var statearr_41996_42034 = state_41952__$1;
(statearr_41996_42034[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____0 = (function (){
var statearr_41997 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41997[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__);

(statearr_41997[(1)] = (1));

return statearr_41997;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____1 = (function (state_41952){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_41952);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e41998){var ex__17136__auto__ = e41998;
var statearr_41999_42035 = state_41952;
(statearr_41999_42035[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_41952[(4)]))){
var statearr_42000_42036 = state_41952;
(statearr_42000_42036[(1)] = cljs.core.first((state_41952[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__42037 = state_41952;
state_41952 = G__42037;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__ = function(state_41952){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____1.call(this,state_41952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_42001 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_42001[(6)] = c__17207__auto__);

return statearr_42001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
