// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e33857){var e = e33857;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__33858_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__33858_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__33858_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__33858_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__33858_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33859_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33859_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33860_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33860_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__33865 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33865,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33865,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33861_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33861_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__33868 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33868,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33868,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33862_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33862_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33863_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33863_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__33864_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33864_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33871_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__33871_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5752__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5752__auto__)){
var var$__$1 = temp__5752__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5752__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5752__auto__)){
var var$ = temp__5752__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5752__auto__ = (function (){var G__33872 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__33872) : intersecting_vars.call(null,G__33872));
})();
if(cljs.core.truth_(temp__5752__auto__)){
var key_replace = temp__5752__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__33875,optional_QMARK_,fuel,max_fuel){
var map__33876 = p__33875;
var map__33876__$1 = (((((!((map__33876 == null))))?(((((map__33876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33876):map__33876);
var res = map__33876__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33876__$1,cljs.core.cst$kw$vars);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33943){
var state_val_33944 = (state_33943[(1)]);
if((state_val_33944 === (7))){
var inst_33932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33933 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_33934 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33933,clause);
var inst_33935 = [null,inst_33934];
var inst_33936 = (new cljs.core.PersistentVector(null,2,(5),inst_33932,inst_33935,null));
var state_33943__$1 = state_33943;
var statearr_33945_33973 = state_33943__$1;
(statearr_33945_33973[(2)] = inst_33936);

(statearr_33945_33973[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (1))){
var state_33943__$1 = state_33943;
var statearr_33946_33974 = state_33943__$1;
(statearr_33946_33974[(2)] = null);

(statearr_33946_33974[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (4))){
var inst_33878 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
var statearr_33947_33975 = state_33943__$1;
(statearr_33947_33975[(2)] = inst_33878);

(statearr_33947_33975[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (15))){
var inst_33921 = (state_33943[(2)]);
var inst_33922 = fluree.db.util.async.throw_err(inst_33921);
var inst_33923 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_33922);
var inst_33924 = cljs.core.count(inst_33923);
var inst_33925 = fluree.db.query.analytical.add_fuel(inst_33924,fuel,max_fuel);
var inst_33926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33927 = [inst_33922,r];
var inst_33928 = (new cljs.core.PersistentVector(null,2,(5),inst_33926,inst_33927,null));
var state_33943__$1 = (function (){var statearr_33948 = state_33943;
(statearr_33948[(7)] = inst_33925);

return statearr_33948;
})();
var statearr_33949_33976 = state_33943__$1;
(statearr_33949_33976[(2)] = inst_33928);

(statearr_33949_33976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (13))){
var inst_33887 = (state_33943[(8)]);
var inst_33900 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33901 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_33900);
var inst_33902 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33887);
var inst_33903 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33902);
var inst_33904 = cljs.core.set(inst_33903);
var inst_33905 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_33901);
var inst_33906 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33905);
var inst_33907 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33904,inst_33906);
var inst_33908 = (function (){var all_wd = inst_33887;
var optional = inst_33901;
var all_wd_vars = inst_33904;
var all_vars = inst_33907;
return (function (p1__33873_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__33873_SHARP_) : all_vars.call(null,p1__33873_SHARP_));
});
})();
var inst_33909 = cljs.core.keys(vars);
var inst_33910 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33908,inst_33909);
var inst_33911 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_33910);
var inst_33912 = cljs.core.set(inst_33911);
var inst_33913 = (function (){var all_wd = inst_33887;
var optional = inst_33901;
var all_wd_vars = inst_33904;
var all_vars = inst_33907;
var intersecting_vars = inst_33912;
return (function (p1__33874_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__33874_SHARP_);
});
})();
var inst_33914 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33913,inst_33887);
var inst_33915 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_33914);
var inst_33916 = fluree.db.query.analytical.select_from_tuples(inst_33915,res);
var inst_33917 = fluree.db.query.analytical.replace_vars_wikidata(inst_33887,inst_33912,vars);
var inst_33918 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_33912,inst_33907);
var inst_33919 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_33917,inst_33915,inst_33916,inst_33918,inst_33901);
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33943__$1,(15),inst_33919);
} else {
if((state_val_33944 === (6))){
var inst_33888 = (state_33943[(9)]);
var inst_33886 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_33887 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_33886);
var inst_33888__$1 = optional_QMARK_;
var state_33943__$1 = (function (){var statearr_33950 = state_33943;
(statearr_33950[(8)] = inst_33887);

(statearr_33950[(9)] = inst_33888__$1);

return statearr_33950;
})();
if(cljs.core.truth_(inst_33888__$1)){
var statearr_33951_33977 = state_33943__$1;
(statearr_33951_33977[(1)] = (9));

} else {
var statearr_33952_33978 = state_33943__$1;
(statearr_33952_33978[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (3))){
var inst_33941 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33943__$1,inst_33941);
} else {
if((state_val_33944 === (12))){
var inst_33896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33897 = [null,r];
var inst_33898 = (new cljs.core.PersistentVector(null,2,(5),inst_33896,inst_33897,null));
var state_33943__$1 = state_33943;
var statearr_33953_33979 = state_33943__$1;
(statearr_33953_33979[(2)] = inst_33898);

(statearr_33953_33979[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (2))){
var _ = (function (){var statearr_33954 = state_33943;
(statearr_33954[(4)] = cljs.core.cons((5),(state_33943[(4)])));

return statearr_33954;
})();
var inst_33884 = (r == null);
var state_33943__$1 = state_33943;
if(cljs.core.truth_(inst_33884)){
var statearr_33955_33980 = state_33943__$1;
(statearr_33955_33980[(1)] = (6));

} else {
var statearr_33956_33981 = state_33943__$1;
(statearr_33956_33981[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (11))){
var inst_33894 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
if(cljs.core.truth_(inst_33894)){
var statearr_33958_33982 = state_33943__$1;
(statearr_33958_33982[(1)] = (12));

} else {
var statearr_33959_33983 = state_33943__$1;
(statearr_33959_33983[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (9))){
var inst_33887 = (state_33943[(8)]);
var inst_33890 = cljs.core.empty_QMARK_(inst_33887);
var inst_33891 = (!(inst_33890));
var state_33943__$1 = state_33943;
var statearr_33960_33984 = state_33943__$1;
(statearr_33960_33984[(2)] = inst_33891);

(statearr_33960_33984[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (5))){
var _ = (function (){var statearr_33961 = state_33943;
(statearr_33961[(4)] = cljs.core.rest((state_33943[(4)])));

return statearr_33961;
})();
var state_33943__$1 = state_33943;
var ex33957 = (state_33943__$1[(2)]);
var statearr_33962_33985 = state_33943__$1;
(statearr_33962_33985[(5)] = ex33957);


if((ex33957 instanceof Error)){
var statearr_33963_33986 = state_33943__$1;
(statearr_33963_33986[(1)] = (4));

(statearr_33963_33986[(5)] = null);

} else {
throw ex33957;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (14))){
var inst_33930 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
var statearr_33964_33987 = state_33943__$1;
(statearr_33964_33987[(2)] = inst_33930);

(statearr_33964_33987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (10))){
var inst_33888 = (state_33943[(9)]);
var state_33943__$1 = state_33943;
var statearr_33965_33988 = state_33943__$1;
(statearr_33965_33988[(2)] = inst_33888);

(statearr_33965_33988[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (8))){
var inst_33938 = (state_33943[(2)]);
var _ = (function (){var statearr_33966 = state_33943;
(statearr_33966[(4)] = cljs.core.rest((state_33943[(4)])));

return statearr_33966;
})();
var state_33943__$1 = state_33943;
var statearr_33967_33989 = state_33943__$1;
(statearr_33967_33989[(2)] = inst_33938);

(statearr_33967_33989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_33968 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33968[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__);

(statearr_33968[(1)] = (1));

return statearr_33968;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____1 = (function (state_33943){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33943);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33969){var ex__17136__auto__ = e33969;
var statearr_33970_33990 = state_33943;
(statearr_33970_33990[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33943[(4)]))){
var statearr_33971_33991 = state_33943;
(statearr_33971_33991[(1)] = cljs.core.first((state_33943[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33992 = state_33943;
state_33943 = G__33992;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__ = function(state_33943){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____1.call(this,state_33943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33972 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33972[(6)] = c__17207__auto__);

return statearr_33972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__33994 = arguments.length;
switch (G__33994) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_34088){
var state_val_34089 = (state_34088[(1)]);
if((state_val_34089 === (7))){
var inst_34001 = (state_34088[(7)]);
var inst_34011 = clojure.string.starts_with_QMARK_(inst_34001,"$fdb");
var state_34088__$1 = state_34088;
if(inst_34011){
var statearr_34090_34139 = state_34088__$1;
(statearr_34090_34139[(1)] = (9));

} else {
var statearr_34091_34140 = state_34088__$1;
(statearr_34091_34140[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (20))){
var state_34088__$1 = state_34088;
var statearr_34092_34141 = state_34088__$1;
(statearr_34092_34141[(2)] = null);

(statearr_34092_34141[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (27))){
var inst_34051 = (state_34088[(8)]);
var state_34088__$1 = state_34088;
var statearr_34093_34142 = state_34088__$1;
(statearr_34093_34142[(2)] = inst_34051);

(statearr_34093_34142[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (1))){
var state_34088__$1 = state_34088;
var statearr_34094_34143 = state_34088__$1;
(statearr_34094_34143[(2)] = null);

(statearr_34094_34143[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (24))){
var inst_34074 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
var statearr_34095_34144 = state_34088__$1;
(statearr_34095_34144[(2)] = inst_34074);

(statearr_34095_34144[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (4))){
var inst_33995 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
var statearr_34096_34145 = state_34088__$1;
(statearr_34096_34145[(2)] = inst_33995);

(statearr_34096_34145[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (15))){
var inst_34018 = (state_34088[(9)]);
var inst_34024 = (state_34088[(2)]);
var inst_34025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34026 = cljs.core.PersistentVector.EMPTY;
var inst_34027 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34028 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34026,inst_34027);
var inst_34029 = [inst_34018,inst_34028];
var inst_34030 = (new cljs.core.PersistentVector(null,2,(5),inst_34025,inst_34029,null));
var state_34088__$1 = (function (){var statearr_34097 = state_34088;
(statearr_34097[(10)] = inst_34024);

return statearr_34097;
})();
var statearr_34098_34146 = state_34088__$1;
(statearr_34098_34146[(2)] = inst_34030);

(statearr_34098_34146[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (21))){
var inst_34077 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
var statearr_34099_34147 = state_34088__$1;
(statearr_34099_34147[(2)] = inst_34077);

(statearr_34099_34147[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (13))){
var inst_34018 = (state_34088[(9)]);
var inst_34021 = (function(){throw inst_34018})();
var state_34088__$1 = state_34088;
var statearr_34100_34148 = state_34088__$1;
(statearr_34100_34148[(2)] = inst_34021);

(statearr_34100_34148[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (22))){
var inst_34042 = (state_34088[(11)]);
var inst_34040 = (state_34088[(12)]);
var inst_34044 = fluree.db.query.analytical.parse_block_from_source(inst_34040);
var inst_34045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34046 = [cljs.core.cst$kw$sources,inst_34042];
var inst_34047 = (new cljs.core.PersistentVector(null,2,(5),inst_34045,inst_34046,null));
var inst_34048 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_34047);
var state_34088__$1 = (function (){var statearr_34101 = state_34088;
(statearr_34101[(13)] = inst_34044);

return statearr_34101;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34088__$1,(25),inst_34048);
} else {
if((state_val_34089 === (29))){
var inst_34055 = (state_34088[(2)]);
var inst_34056 = fluree.db.util.async.throw_err(inst_34055);
var state_34088__$1 = state_34088;
var statearr_34102_34149 = state_34088__$1;
(statearr_34102_34149[(2)] = inst_34056);

(statearr_34102_34149[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (6))){
var inst_34004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34005 = cljs.core.PersistentVector.EMPTY;
var inst_34006 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34005,inst_34006);
var inst_34008 = [db,inst_34007];
var inst_34009 = (new cljs.core.PersistentVector(null,2,(5),inst_34004,inst_34008,null));
var state_34088__$1 = state_34088;
var statearr_34103_34150 = state_34088__$1;
(statearr_34103_34150[(2)] = inst_34009);

(statearr_34103_34150[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (28))){
var inst_34059 = (state_34088[(2)]);
var inst_34060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34061 = cljs.core.PersistentVector.EMPTY;
var inst_34062 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34063 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34061,inst_34062);
var inst_34064 = [inst_34059,inst_34063];
var inst_34065 = (new cljs.core.PersistentVector(null,2,(5),inst_34060,inst_34064,null));
var state_34088__$1 = state_34088;
var statearr_34104_34151 = state_34088__$1;
(statearr_34104_34151[(2)] = inst_34065);

(statearr_34104_34151[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (25))){
var inst_34044 = (state_34088[(13)]);
var inst_34050 = (state_34088[(2)]);
var inst_34051 = fluree.db.util.async.throw_err(inst_34050);
var state_34088__$1 = (function (){var statearr_34105 = state_34088;
(statearr_34105[(8)] = inst_34051);

return statearr_34105;
})();
if(cljs.core.truth_(inst_34044)){
var statearr_34106_34152 = state_34088__$1;
(statearr_34106_34152[(1)] = (26));

} else {
var statearr_34107_34153 = state_34088__$1;
(statearr_34107_34153[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (17))){
var state_34088__$1 = state_34088;
var statearr_34108_34154 = state_34088__$1;
(statearr_34108_34154[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (3))){
var inst_34086 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34088__$1,inst_34086);
} else {
if((state_val_34089 === (12))){
var inst_34018 = (state_34088[(9)]);
var inst_34017 = (state_34088[(2)]);
var inst_34018__$1 = fluree.db.util.async.throw_err(inst_34017);
var inst_34019 = fluree.db.util.core.exception_QMARK_(inst_34018__$1);
var state_34088__$1 = (function (){var statearr_34110 = state_34088;
(statearr_34110[(9)] = inst_34018__$1);

return statearr_34110;
})();
if(inst_34019){
var statearr_34111_34155 = state_34088__$1;
(statearr_34111_34155[(1)] = (13));

} else {
var statearr_34112_34156 = state_34088__$1;
(statearr_34112_34156[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (2))){
var inst_34001 = (state_34088[(7)]);
var _ = (function (){var statearr_34113 = state_34088;
(statearr_34113[(4)] = cljs.core.cons((5),(state_34088[(4)])));

return statearr_34113;
})();
var inst_34001__$1 = cljs.core.first(clause);
var inst_34002 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_34001__$1);
var state_34088__$1 = (function (){var statearr_34114 = state_34088;
(statearr_34114[(7)] = inst_34001__$1);

return statearr_34114;
})();
if(inst_34002){
var statearr_34115_34157 = state_34088__$1;
(statearr_34115_34157[(1)] = (6));

} else {
var statearr_34116_34158 = state_34088__$1;
(statearr_34116_34158[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (23))){
var inst_34001 = (state_34088[(7)]);
var inst_34067 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34001)," is not supported in Fluree"].join('');
var inst_34068 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34069 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34070 = cljs.core.PersistentHashMap.fromArrays(inst_34068,inst_34069);
var inst_34071 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34067,inst_34070);
var inst_34072 = (function(){throw inst_34071})();
var state_34088__$1 = state_34088;
var statearr_34117_34159 = state_34088__$1;
(statearr_34117_34159[(2)] = inst_34072);

(statearr_34117_34159[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (19))){
var inst_34001 = (state_34088[(7)]);
var inst_34042 = (state_34088[(11)]);
var inst_34039 = fluree.db.query.analytical.isolate_source_name(inst_34001);
var inst_34040 = fluree.db.query.analytical.isolate_source_block(inst_34001);
var inst_34041 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34039);
var inst_34042__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_34041);
var state_34088__$1 = (function (){var statearr_34118 = state_34088;
(statearr_34118[(11)] = inst_34042__$1);

(statearr_34118[(12)] = inst_34040);

return statearr_34118;
})();
if(cljs.core.truth_(inst_34042__$1)){
var statearr_34119_34160 = state_34088__$1;
(statearr_34119_34160[(1)] = (22));

} else {
var statearr_34120_34161 = state_34088__$1;
(statearr_34120_34161[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (11))){
var inst_34081 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
var statearr_34122_34162 = state_34088__$1;
(statearr_34122_34162[(2)] = inst_34081);

(statearr_34122_34162[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (9))){
var inst_34001 = (state_34088[(7)]);
var inst_34013 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_34001,(4));
var inst_34014 = fluree.db.query.analytical.parse_block_from_source(inst_34013);
var inst_34015 = fluree.db.time_travel.as_of_block(db,inst_34014);
var state_34088__$1 = state_34088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34088__$1,(12),inst_34015);
} else {
if((state_val_34089 === (5))){
var _ = (function (){var statearr_34123 = state_34088;
(statearr_34123[(4)] = cljs.core.rest((state_34088[(4)])));

return statearr_34123;
})();
var state_34088__$1 = state_34088;
var ex34121 = (state_34088__$1[(2)]);
var statearr_34124_34163 = state_34088__$1;
(statearr_34124_34163[(5)] = ex34121);


if((ex34121 instanceof Error)){
var statearr_34125_34164 = state_34088__$1;
(statearr_34125_34164[(1)] = (4));

(statearr_34125_34164[(5)] = null);

} else {
throw ex34121;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (14))){
var state_34088__$1 = state_34088;
var statearr_34126_34165 = state_34088__$1;
(statearr_34126_34165[(2)] = null);

(statearr_34126_34165[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (26))){
var inst_34051 = (state_34088[(8)]);
var inst_34044 = (state_34088[(13)]);
var inst_34053 = fluree.db.time_travel.as_of_block(inst_34051,inst_34044);
var state_34088__$1 = state_34088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34088__$1,(29),inst_34053);
} else {
if((state_val_34089 === (16))){
var inst_34034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34035 = ["$wd",clause];
var inst_34036 = (new cljs.core.PersistentVector(null,2,(5),inst_34034,inst_34035,null));
var state_34088__$1 = state_34088;
var statearr_34127_34166 = state_34088__$1;
(statearr_34127_34166[(2)] = inst_34036);

(statearr_34127_34166[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (10))){
var inst_34001 = (state_34088[(7)]);
var inst_34032 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34001);
var state_34088__$1 = state_34088;
if(inst_34032){
var statearr_34128_34167 = state_34088__$1;
(statearr_34128_34167[(1)] = (16));

} else {
var statearr_34129_34168 = state_34088__$1;
(statearr_34129_34168[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (18))){
var inst_34079 = (state_34088[(2)]);
var state_34088__$1 = state_34088;
var statearr_34130_34169 = state_34088__$1;
(statearr_34130_34169[(2)] = inst_34079);

(statearr_34130_34169[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34089 === (8))){
var inst_34083 = (state_34088[(2)]);
var _ = (function (){var statearr_34131 = state_34088;
(statearr_34131[(4)] = cljs.core.rest((state_34088[(4)])));

return statearr_34131;
})();
var state_34088__$1 = state_34088;
var statearr_34132_34170 = state_34088__$1;
(statearr_34132_34170[(2)] = inst_34083);

(statearr_34132_34170[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__17133__auto__ = null;
var fluree$db$query$analytical$state_machine__17133__auto____0 = (function (){
var statearr_34133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34133[(0)] = fluree$db$query$analytical$state_machine__17133__auto__);

(statearr_34133[(1)] = (1));

return statearr_34133;
});
var fluree$db$query$analytical$state_machine__17133__auto____1 = (function (state_34088){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_34088);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e34134){var ex__17136__auto__ = e34134;
var statearr_34135_34171 = state_34088;
(statearr_34135_34171[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_34088[(4)]))){
var statearr_34136_34172 = state_34088;
(statearr_34136_34172[(1)] = cljs.core.first((state_34088[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__34173 = state_34088;
state_34088 = G__34173;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__17133__auto__ = function(state_34088){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__17133__auto____1.call(this,state_34088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__17133__auto____0;
fluree$db$query$analytical$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__17133__auto____1;
return fluree$db$query$analytical$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_34137 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_34137[(6)] = c__17207__auto__);

return statearr_34137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34174){
var vec__34175 = p__34174;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34175,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34175,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34178_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__34178_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__34182 = subjects;
var vec__34183 = G__34182;
var seq__34184 = cljs.core.seq(vec__34183);
var first__34185 = cljs.core.first(seq__34184);
var seq__34184__$1 = cljs.core.next(seq__34184);
var subject = first__34185;
var r = seq__34184__$1;
var acc = expanded_map;
var G__34182__$1 = G__34182;
var acc__$1 = acc;
while(true){
var vec__34189 = G__34182__$1;
var seq__34190 = cljs.core.seq(vec__34189);
var first__34191 = cljs.core.first(seq__34190);
var seq__34190__$1 = cljs.core.next(seq__34190);
var subject__$1 = first__34191;
var r__$1 = seq__34190__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__34192 = r__$1;
var G__34193 = acc__$2;
G__34182__$1 = G__34192;
acc__$1 = G__34193;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__34182__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__34182__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34182__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__34182__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34182__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__34182__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34189,seq__34190,first__34191,seq__34190__$1,subject__$1,r__$1,acc__$2,G__34182,vec__34183,seq__34184,first__34185,seq__34184__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__34194 = r__$1;
var G__34195 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__34182__$1 = G__34194;
acc__$1 = G__34195;
continue;
} else {
var G__34196 = subjects;
var G__34197 = acc_STAR_;
G__34182__$1 = G__34196;
acc__$1 = G__34197;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34198_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__34198_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_34289){
var state_val_34290 = (state_34289[(1)]);
if((state_val_34290 === (7))){
var state_34289__$1 = state_34289;
var statearr_34291_34337 = state_34289__$1;
(statearr_34291_34337[(2)] = (100));

(statearr_34291_34337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (20))){
var inst_34238 = (state_34289[(7)]);
var state_34289__$1 = state_34289;
var statearr_34292_34338 = state_34289__$1;
(statearr_34292_34338[(2)] = inst_34238);

(statearr_34292_34338[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (1))){
var state_34289__$1 = state_34289;
var statearr_34293_34339 = state_34289__$1;
(statearr_34293_34339[(2)] = null);

(statearr_34293_34339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (24))){
var inst_34275 = (state_34289[(8)]);
var inst_34210 = (state_34289[(9)]);
var inst_34277 = (state_34289[(10)]);
var inst_34276 = (state_34289[(11)]);
var inst_34280 = (function (){var max_depth = inst_34210;
var recur_map__$1 = inst_34276;
var subjects = inst_34275;
var tuples = inst_34277;
return (function (p1__34199_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__34199_SHARP_)],null));
});
})();
var inst_34281 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34280,inst_34277);
var inst_34282 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_34281);
var state_34289__$1 = state_34289;
var statearr_34294_34340 = state_34289__$1;
(statearr_34294_34340[(2)] = inst_34282);

(statearr_34294_34340[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (4))){
var inst_34200 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
var statearr_34295_34341 = state_34289__$1;
(statearr_34295_34341[(2)] = inst_34200);

(statearr_34295_34341[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (15))){
var inst_34223 = (state_34289[(12)]);
var inst_34234 = cljs.core.PersistentVector.EMPTY;
var inst_34235 = cljs.core.seq(inst_34223);
var inst_34236 = cljs.core.first(inst_34235);
var inst_34237 = cljs.core.next(inst_34235);
var inst_34238 = inst_34234;
var inst_34239 = inst_34223;
var state_34289__$1 = (function (){var statearr_34296 = state_34289;
(statearr_34296[(7)] = inst_34238);

(statearr_34296[(13)] = inst_34236);

(statearr_34296[(14)] = inst_34239);

(statearr_34296[(15)] = inst_34237);

return statearr_34296;
})();
var statearr_34297_34342 = state_34289__$1;
(statearr_34297_34342[(2)] = null);

(statearr_34297_34342[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (21))){
var inst_34259 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
var statearr_34298_34343 = state_34289__$1;
(statearr_34298_34343[(2)] = inst_34259);

(statearr_34298_34343[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (13))){
var inst_34272 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
var statearr_34299_34344 = state_34289__$1;
(statearr_34299_34344[(2)] = inst_34272);

(statearr_34299_34344[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (22))){
var inst_34238 = (state_34289[(7)]);
var inst_34246 = (state_34289[(16)]);
var inst_34253 = (state_34289[(2)]);
var inst_34254 = fluree.db.util.async.throw_err(inst_34253);
var inst_34255 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34238,inst_34254);
var inst_34238__$1 = inst_34255;
var inst_34239 = inst_34246;
var state_34289__$1 = (function (){var statearr_34300 = state_34289;
(statearr_34300[(7)] = inst_34238__$1);

(statearr_34300[(14)] = inst_34239);

return statearr_34300;
})();
var statearr_34301_34345 = state_34289__$1;
(statearr_34301_34345[(2)] = null);

(statearr_34301_34345[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (6))){
var inst_34206 = (state_34289[(17)]);
var state_34289__$1 = state_34289;
var statearr_34302_34346 = state_34289__$1;
(statearr_34302_34346[(2)] = inst_34206);

(statearr_34302_34346[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (25))){
var inst_34284 = (state_34289[(2)]);
var _ = (function (){var statearr_34303 = state_34289;
(statearr_34303[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34303;
})();
var state_34289__$1 = state_34289;
var statearr_34304_34347 = state_34289__$1;
(statearr_34304_34347[(2)] = inst_34284);

(statearr_34304_34347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (17))){
var inst_34245 = (state_34289[(18)]);
var inst_34239 = (state_34289[(14)]);
var inst_34244 = cljs.core.seq(inst_34239);
var inst_34245__$1 = cljs.core.first(inst_34244);
var inst_34246 = cljs.core.next(inst_34244);
var state_34289__$1 = (function (){var statearr_34305 = state_34289;
(statearr_34305[(18)] = inst_34245__$1);

(statearr_34305[(16)] = inst_34246);

return statearr_34305;
})();
if(cljs.core.truth_(inst_34245__$1)){
var statearr_34306_34348 = state_34289__$1;
(statearr_34306_34348[(1)] = (19));

} else {
var statearr_34307_34349 = state_34289__$1;
(statearr_34307_34349[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (3))){
var inst_34287 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34289__$1,inst_34287);
} else {
if((state_val_34290 === (12))){
var inst_34223 = (state_34289[(12)]);
var inst_34212 = (state_34289[(19)]);
var inst_34218 = cljs.core.vals(inst_34212);
var inst_34219 = cljs.core.flatten(inst_34218);
var inst_34220 = cljs.core.set(inst_34219);
var inst_34221 = cljs.core.keys(inst_34212);
var inst_34222 = cljs.core.set(inst_34221);
var inst_34223__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_34220,inst_34222);
var inst_34224 = cljs.core.empty_QMARK_(inst_34223__$1);
var state_34289__$1 = (function (){var statearr_34308 = state_34289;
(statearr_34308[(12)] = inst_34223__$1);

return statearr_34308;
})();
if(inst_34224){
var statearr_34309_34350 = state_34289__$1;
(statearr_34309_34350[(1)] = (14));

} else {
var statearr_34310_34351 = state_34289__$1;
(statearr_34310_34351[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (2))){
var inst_34206 = (state_34289[(17)]);
var _ = (function (){var statearr_34311 = state_34289;
(statearr_34311[(4)] = cljs.core.cons((5),(state_34289[(4)])));

return statearr_34311;
})();
var inst_34206__$1 = depth;
var state_34289__$1 = (function (){var statearr_34312 = state_34289;
(statearr_34312[(17)] = inst_34206__$1);

return statearr_34312;
})();
if(cljs.core.truth_(inst_34206__$1)){
var statearr_34313_34352 = state_34289__$1;
(statearr_34313_34352[(1)] = (6));

} else {
var statearr_34314_34353 = state_34289__$1;
(statearr_34314_34353[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (23))){
var inst_34277 = (state_34289[(10)]);
var state_34289__$1 = state_34289;
var statearr_34315_34354 = state_34289__$1;
(statearr_34315_34354[(2)] = inst_34277);

(statearr_34315_34354[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (19))){
var inst_34245 = (state_34289[(18)]);
var inst_34248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34249 = [inst_34245,predicate];
var inst_34250 = (new cljs.core.PersistentVector(null,2,(5),inst_34248,inst_34249,null));
var inst_34251 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34250);
var state_34289__$1 = state_34289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34289__$1,(22),inst_34251);
} else {
if((state_val_34290 === (11))){
var inst_34212 = (state_34289[(19)]);
var state_34289__$1 = state_34289;
var statearr_34317_34355 = state_34289__$1;
(statearr_34317_34355[(2)] = inst_34212);

(statearr_34317_34355[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (9))){
var inst_34210 = (state_34289[(9)]);
var inst_34213 = (state_34289[(20)]);
var inst_34215 = (inst_34213 >= inst_34210);
var state_34289__$1 = state_34289;
if(cljs.core.truth_(inst_34215)){
var statearr_34318_34356 = state_34289__$1;
(statearr_34318_34356[(1)] = (11));

} else {
var statearr_34319_34357 = state_34289__$1;
(statearr_34319_34357[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (5))){
var _ = (function (){var statearr_34320 = state_34289;
(statearr_34320[(4)] = cljs.core.rest((state_34289[(4)])));

return statearr_34320;
})();
var state_34289__$1 = state_34289;
var ex34316 = (state_34289__$1[(2)]);
var statearr_34321_34358 = state_34289__$1;
(statearr_34321_34358[(5)] = ex34316);


if((ex34316 instanceof Error)){
var statearr_34322_34359 = state_34289__$1;
(statearr_34322_34359[(1)] = (4));

(statearr_34322_34359[(5)] = null);

} else {
throw ex34316;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (14))){
var inst_34212 = (state_34289[(19)]);
var state_34289__$1 = state_34289;
var statearr_34323_34360 = state_34289__$1;
(statearr_34323_34360[(2)] = inst_34212);

(statearr_34323_34360[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (16))){
var inst_34270 = (state_34289[(2)]);
var state_34289__$1 = state_34289;
var statearr_34324_34361 = state_34289__$1;
(statearr_34324_34361[(2)] = inst_34270);

(statearr_34324_34361[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (10))){
var inst_34275 = (state_34289[(8)]);
var inst_34276 = (state_34289[(11)]);
var inst_34274 = (state_34289[(2)]);
var inst_34275__$1 = cljs.core.keys(inst_34274);
var inst_34276__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_34275__$1,inst_34274);
var inst_34277 = fluree.db.query.analytical.recur_map__GT_tuples(inst_34275__$1,inst_34276__$1);
var state_34289__$1 = (function (){var statearr_34325 = state_34289;
(statearr_34325[(8)] = inst_34275__$1);

(statearr_34325[(10)] = inst_34277);

(statearr_34325[(11)] = inst_34276__$1);

return statearr_34325;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_34326_34362 = state_34289__$1;
(statearr_34326_34362[(1)] = (23));

} else {
var statearr_34327_34363 = state_34289__$1;
(statearr_34327_34363[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (18))){
var inst_34213 = (state_34289[(20)]);
var inst_34212 = (state_34289[(19)]);
var inst_34261 = (state_34289[(2)]);
var inst_34262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34263 = [(0),(2)];
var inst_34264 = (new cljs.core.PersistentVector(null,2,(5),inst_34262,inst_34263,null));
var inst_34265 = fluree.db.query.analytical.get_ns_arrays(inst_34264,inst_34261);
var inst_34266 = fluree.db.query.analytical.tuples__GT_map(inst_34212,inst_34265);
var inst_34267 = (inst_34213 + (1));
var inst_34212__$1 = inst_34266;
var inst_34213__$1 = inst_34267;
var state_34289__$1 = (function (){var statearr_34328 = state_34289;
(statearr_34328[(20)] = inst_34213__$1);

(statearr_34328[(19)] = inst_34212__$1);

return statearr_34328;
})();
var statearr_34329_34364 = state_34289__$1;
(statearr_34329_34364[(2)] = null);

(statearr_34329_34364[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34290 === (8))){
var inst_34210 = (state_34289[(2)]);
var inst_34211 = recur_map;
var inst_34212 = inst_34211;
var inst_34213 = (1);
var state_34289__$1 = (function (){var statearr_34330 = state_34289;
(statearr_34330[(9)] = inst_34210);

(statearr_34330[(20)] = inst_34213);

(statearr_34330[(19)] = inst_34212);

return statearr_34330;
})();
var statearr_34331_34365 = state_34289__$1;
(statearr_34331_34365[(2)] = null);

(statearr_34331_34365[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____0 = (function (){
var statearr_34332 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34332[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__);

(statearr_34332[(1)] = (1));

return statearr_34332;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____1 = (function (state_34289){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_34289);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e34333){var ex__17136__auto__ = e34333;
var statearr_34334_34366 = state_34289;
(statearr_34334_34366[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_34289[(4)]))){
var statearr_34335_34367 = state_34289;
(statearr_34335_34367[(1)] = cljs.core.first((state_34289[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__34368 = state_34289;
state_34289 = G__34368;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__ = function(state_34289){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____1.call(this,state_34289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_34336 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_34336[(6)] = c__17207__auto__);

return statearr_34336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__34369,clause,fuel,max_fuel){
var map__34370 = p__34369;
var map__34370__$1 = (((((!((map__34370 == null))))?(((((map__34370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34370.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34370):map__34370);
var res = map__34370__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34370__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34370__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34370__$1,cljs.core.cst$kw$vars);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_34502){
var state_val_34503 = (state_34502[(1)]);
if((state_val_34503 === (7))){
var state_34502__$1 = state_34502;
var statearr_34504_34570 = state_34502__$1;
(statearr_34504_34570[(2)] = false);

(statearr_34504_34570[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (20))){
var inst_34434 = (state_34502[(7)]);
var state_34502__$1 = state_34502;
var statearr_34505_34571 = state_34502__$1;
(statearr_34505_34571[(2)] = inst_34434);

(statearr_34505_34571[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (27))){
var inst_34438 = (state_34502[(8)]);
var inst_34462 = (state_34502[(2)]);
var state_34502__$1 = (function (){var statearr_34506 = state_34502;
(statearr_34506[(9)] = inst_34462);

return statearr_34506;
})();
if(cljs.core.truth_(inst_34438)){
var statearr_34507_34572 = state_34502__$1;
(statearr_34507_34572[(1)] = (28));

} else {
var statearr_34508_34573 = state_34502__$1;
(statearr_34508_34573[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (1))){
var state_34502__$1 = state_34502;
var statearr_34509_34574 = state_34502__$1;
(statearr_34509_34574[(2)] = null);

(statearr_34509_34574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (24))){
var inst_34450 = (state_34502[(2)]);
var inst_34451 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_34452 = fluree.db.query.analytical.variable_QMARK_(inst_34451);
var state_34502__$1 = (function (){var statearr_34510 = state_34502;
(statearr_34510[(10)] = inst_34450);

return statearr_34510;
})();
if(cljs.core.truth_(inst_34452)){
var statearr_34511_34575 = state_34502__$1;
(statearr_34511_34575[(1)] = (25));

} else {
var statearr_34512_34576 = state_34502__$1;
(statearr_34512_34576[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (4))){
var inst_34372 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
var statearr_34513_34577 = state_34502__$1;
(statearr_34513_34577[(2)] = inst_34372);

(statearr_34513_34577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (15))){
var inst_34420 = (state_34502[(11)]);
var state_34502__$1 = state_34502;
var statearr_34514_34578 = state_34502__$1;
(statearr_34514_34578[(2)] = inst_34420);

(statearr_34514_34578[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (21))){
var inst_34405 = (state_34502[(12)]);
var inst_34493 = (state_34502[(2)]);
var inst_34494 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_34495 = cljs.core.keys(inst_34405);
var inst_34496 = [inst_34495,vars,inst_34493];
var inst_34497 = cljs.core.PersistentHashMap.fromArrays(inst_34494,inst_34496);
var _ = (function (){var statearr_34515 = state_34502;
(statearr_34515[(4)] = cljs.core.rest((state_34502[(4)])));

return statearr_34515;
})();
var state_34502__$1 = state_34502;
var statearr_34516_34579 = state_34502__$1;
(statearr_34516_34579[(2)] = inst_34497);

(statearr_34516_34579[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (31))){
var inst_34434 = (state_34502[(7)]);
var inst_34436 = (state_34502[(13)]);
var inst_34469 = cljs.core.PersistentHashMap.EMPTY;
var inst_34470 = cljs.core.flatten(inst_34434);
var inst_34471 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34469,inst_34436,inst_34470);
var state_34502__$1 = state_34502;
var statearr_34517_34580 = state_34502__$1;
(statearr_34517_34580[(2)] = inst_34471);

(statearr_34517_34580[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (32))){
var inst_34436 = (state_34502[(13)]);
var inst_34473 = cljs.core.coll_QMARK_(inst_34436);
var state_34502__$1 = state_34502;
if(inst_34473){
var statearr_34518_34581 = state_34502__$1;
(statearr_34518_34581[(1)] = (34));

} else {
var statearr_34519_34582 = state_34502__$1;
(statearr_34519_34582[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (33))){
var inst_34484 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
var statearr_34520_34583 = state_34502__$1;
(statearr_34520_34583[(2)] = inst_34484);

(statearr_34520_34583[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (13))){
var inst_34382 = (state_34502[(14)]);
var state_34502__$1 = state_34502;
var statearr_34521_34584 = state_34502__$1;
(statearr_34521_34584[(2)] = inst_34382);

(statearr_34521_34584[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (22))){
var inst_34418 = (state_34502[(15)]);
var inst_34442 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34418)].join('');
var inst_34443 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34444 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34445 = cljs.core.PersistentHashMap.fromArrays(inst_34443,inst_34444);
var inst_34446 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34442,inst_34445);
var inst_34447 = (function(){throw inst_34446})();
var state_34502__$1 = state_34502;
var statearr_34522_34585 = state_34502__$1;
(statearr_34522_34585[(2)] = inst_34447);

(statearr_34522_34585[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (36))){
var inst_34482 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
var statearr_34523_34586 = state_34502__$1;
(statearr_34523_34586[(2)] = inst_34482);

(statearr_34523_34586[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (29))){
var inst_34436 = (state_34502[(13)]);
var inst_34467 = typeof inst_34436 === 'number';
var state_34502__$1 = state_34502;
if(cljs.core.truth_(inst_34467)){
var statearr_34524_34587 = state_34502__$1;
(statearr_34524_34587[(1)] = (31));

} else {
var statearr_34525_34588 = state_34502__$1;
(statearr_34525_34588[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (6))){
var inst_34382 = (state_34502[(14)]);
var inst_34387 = inst_34382.cljs$lang$protocol_mask$partition0$;
var inst_34388 = (inst_34387 & (64));
var inst_34389 = inst_34382.cljs$core$ISeq$;
var inst_34390 = (cljs.core.PROTOCOL_SENTINEL === inst_34389);
var inst_34391 = ((inst_34388) || (inst_34390));
var state_34502__$1 = state_34502;
if(cljs.core.truth_(inst_34391)){
var statearr_34526_34589 = state_34502__$1;
(statearr_34526_34589[(1)] = (9));

} else {
var statearr_34527_34590 = state_34502__$1;
(statearr_34527_34590[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (28))){
var inst_34434 = (state_34502[(7)]);
var inst_34464 = cljs.core.PersistentHashMap.EMPTY;
var inst_34465 = fluree.db.query.analytical.tuples__GT_map(inst_34464,inst_34434);
var state_34502__$1 = state_34502;
var statearr_34528_34591 = state_34502__$1;
(statearr_34528_34591[(2)] = inst_34465);

(statearr_34528_34591[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (25))){
var state_34502__$1 = state_34502;
var statearr_34529_34592 = state_34502__$1;
(statearr_34529_34592[(2)] = null);

(statearr_34529_34592[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (34))){
var inst_34430 = (state_34502[(16)]);
var inst_34434 = (state_34502[(7)]);
var inst_34475 = cljs.core.PersistentHashMap.EMPTY;
var inst_34476 = cljs.core.first(inst_34430);
var inst_34477 = cljs.core.first(inst_34476);
var inst_34478 = cljs.core.flatten(inst_34434);
var inst_34479 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34475,inst_34477,inst_34478);
var state_34502__$1 = state_34502;
var statearr_34530_34593 = state_34502__$1;
(statearr_34530_34593[(2)] = inst_34479);

(statearr_34530_34593[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (17))){
var inst_34418 = (state_34502[(15)]);
var inst_34419 = (state_34502[(17)]);
var inst_34424 = (state_34502[(2)]);
var inst_34425 = [inst_34424];
var inst_34426 = cljs.core.PersistentHashMap.fromArrays(inst_34419,inst_34425);
var inst_34427 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_34418,inst_34426);
var state_34502__$1 = state_34502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34502__$1,(18),inst_34427);
} else {
if((state_val_34503 === (3))){
var inst_34500 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34502__$1,inst_34500);
} else {
if((state_val_34503 === (12))){
var inst_34382 = (state_34502[(14)]);
var inst_34400 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34382);
var state_34502__$1 = state_34502;
var statearr_34531_34594 = state_34502__$1;
(statearr_34531_34594[(2)] = inst_34400);

(statearr_34531_34594[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (2))){
var inst_34382 = (state_34502[(14)]);
var _ = (function (){var statearr_34532 = state_34502;
(statearr_34532[(4)] = cljs.core.cons((5),(state_34502[(4)])));

return statearr_34532;
})();
var inst_34382__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_34384 = (inst_34382__$1 == null);
var inst_34385 = cljs.core.not(inst_34384);
var state_34502__$1 = (function (){var statearr_34533 = state_34502;
(statearr_34533[(14)] = inst_34382__$1);

return statearr_34533;
})();
if(inst_34385){
var statearr_34534_34595 = state_34502__$1;
(statearr_34534_34595[(1)] = (6));

} else {
var statearr_34535_34596 = state_34502__$1;
(statearr_34535_34596[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (23))){
var state_34502__$1 = state_34502;
var statearr_34536_34597 = state_34502__$1;
(statearr_34536_34597[(2)] = null);

(statearr_34536_34597[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (35))){
var state_34502__$1 = state_34502;
var statearr_34537_34598 = state_34502__$1;
(statearr_34537_34598[(2)] = null);

(statearr_34537_34598[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (19))){
var inst_34439 = (state_34502[(18)]);
var inst_34418 = (state_34502[(15)]);
var inst_34436 = cljs.core.first(inst_34418);
var inst_34437 = cljs.core.first(clause);
var inst_34438 = fluree.db.query.analytical.variable_QMARK_(inst_34437);
var inst_34439__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_34418,(1));
var inst_34440 = fluree.db.query.analytical.variable_QMARK_(inst_34439__$1);
var state_34502__$1 = (function (){var statearr_34538 = state_34502;
(statearr_34538[(18)] = inst_34439__$1);

(statearr_34538[(8)] = inst_34438);

(statearr_34538[(13)] = inst_34436);

return statearr_34538;
})();
if(cljs.core.truth_(inst_34440)){
var statearr_34539_34599 = state_34502__$1;
(statearr_34539_34599[(1)] = (22));

} else {
var statearr_34540_34600 = state_34502__$1;
(statearr_34540_34600[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (11))){
var inst_34395 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
var statearr_34542_34601 = state_34502__$1;
(statearr_34542_34601[(2)] = inst_34395);

(statearr_34542_34601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (9))){
var state_34502__$1 = state_34502;
var statearr_34543_34602 = state_34502__$1;
(statearr_34543_34602[(2)] = true);

(statearr_34543_34602[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (5))){
var _ = (function (){var statearr_34544 = state_34502;
(statearr_34544[(4)] = cljs.core.rest((state_34502[(4)])));

return statearr_34544;
})();
var state_34502__$1 = state_34502;
var ex34541 = (state_34502__$1[(2)]);
var statearr_34545_34603 = state_34502__$1;
(statearr_34545_34603[(5)] = ex34541);


if((ex34541 instanceof Error)){
var statearr_34546_34604 = state_34502__$1;
(statearr_34546_34604[(1)] = (4));

(statearr_34546_34604[(5)] = null);

} else {
throw ex34541;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (14))){
var inst_34409 = (state_34502[(19)]);
var inst_34408 = (state_34502[(20)]);
var inst_34405 = (state_34502[(12)]);
var inst_34420 = (state_34502[(11)]);
var inst_34403 = (state_34502[(2)]);
var inst_34404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34403,cljs.core.cst$kw$search);
var inst_34405__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34403,cljs.core.cst$kw$rel);
var inst_34406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34403,cljs.core.cst$kw$opts);
var inst_34407 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_34408__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34406);
var inst_34409__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_34406);
var inst_34411 = (function (){var map__34378 = inst_34403;
var search = inst_34404;
var rel = inst_34405__$1;
var opts = inst_34406;
var common_keys = inst_34407;
var object_fn = inst_34408__$1;
var recur_depth = inst_34409__$1;
return (function (p__34410,common_key){
var vec__34547 = p__34410;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34547,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34547,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__34550 = cljs.core._EQ_;
var expr__34551 = idx_of;
if(cljs.core.truth_((pred__34550.cljs$core$IFn$_invoke$arity$2 ? pred__34550.cljs$core$IFn$_invoke$arity$2((0),expr__34551) : pred__34550.call(null,(0),expr__34551)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__34550.cljs$core$IFn$_invoke$arity$2 ? pred__34550.cljs$core$IFn$_invoke$arity$2((1),expr__34551) : pred__34550.call(null,(1),expr__34551)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__34550.cljs$core$IFn$_invoke$arity$2 ? pred__34550.cljs$core$IFn$_invoke$arity$2((2),expr__34551) : pred__34550.call(null,(2),expr__34551)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__34551)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_34412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34413 = cljs.core.PersistentHashMap.EMPTY;
var inst_34414 = [inst_34413,inst_34404];
var inst_34415 = (new cljs.core.PersistentVector(null,2,(5),inst_34412,inst_34414,null));
var inst_34416 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34411,inst_34415,inst_34407);
var inst_34417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34416,(0),null);
var inst_34418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34416,(1),null);
var inst_34419 = [cljs.core.cst$kw$object_DASH_fn];
var inst_34420__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34417);
var state_34502__$1 = (function (){var statearr_34553 = state_34502;
(statearr_34553[(19)] = inst_34409__$1);

(statearr_34553[(20)] = inst_34408__$1);

(statearr_34553[(12)] = inst_34405__$1);

(statearr_34553[(11)] = inst_34420__$1);

(statearr_34553[(15)] = inst_34418);

(statearr_34553[(17)] = inst_34419);

return statearr_34553;
})();
if(cljs.core.truth_(inst_34420__$1)){
var statearr_34554_34605 = state_34502__$1;
(statearr_34554_34605[(1)] = (15));

} else {
var statearr_34555_34606 = state_34502__$1;
(statearr_34555_34606[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (26))){
var inst_34418 = (state_34502[(15)]);
var inst_34455 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34418)].join('');
var inst_34456 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34457 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34458 = cljs.core.PersistentHashMap.fromArrays(inst_34456,inst_34457);
var inst_34459 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34455,inst_34458);
var inst_34460 = (function(){throw inst_34459})();
var state_34502__$1 = state_34502;
var statearr_34556_34607 = state_34502__$1;
(statearr_34556_34607[(2)] = inst_34460);

(statearr_34556_34607[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (16))){
var inst_34408 = (state_34502[(20)]);
var state_34502__$1 = state_34502;
var statearr_34557_34608 = state_34502__$1;
(statearr_34557_34608[(2)] = inst_34408);

(statearr_34557_34608[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (30))){
var inst_34409 = (state_34502[(19)]);
var inst_34439 = (state_34502[(18)]);
var inst_34438 = (state_34502[(8)]);
var inst_34486 = (state_34502[(2)]);
var inst_34487 = fluree.db.query.analytical.tuples__GT_recur(db,inst_34439,inst_34486,inst_34409,inst_34438);
var state_34502__$1 = state_34502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34502__$1,(37),inst_34487);
} else {
if((state_val_34503 === (10))){
var state_34502__$1 = state_34502;
var statearr_34558_34609 = state_34502__$1;
(statearr_34558_34609[(2)] = false);

(statearr_34558_34609[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (18))){
var inst_34430 = (state_34502[(16)]);
var inst_34409 = (state_34502[(19)]);
var inst_34405 = (state_34502[(12)]);
var inst_34429 = (state_34502[(2)]);
var inst_34430__$1 = fluree.db.util.async.throw_err(inst_34429);
var inst_34431 = cljs.core.count(inst_34430__$1);
var inst_34432 = fluree.db.query.analytical.add_fuel(inst_34431,fuel,max_fuel);
var inst_34433 = cljs.core.vals(inst_34405);
var inst_34434 = fluree.db.query.analytical.get_ns_arrays(inst_34433,inst_34430__$1);
var state_34502__$1 = (function (){var statearr_34559 = state_34502;
(statearr_34559[(16)] = inst_34430__$1);

(statearr_34559[(7)] = inst_34434);

(statearr_34559[(21)] = inst_34432);

return statearr_34559;
})();
if(cljs.core.truth_(inst_34409)){
var statearr_34560_34610 = state_34502__$1;
(statearr_34560_34610[(1)] = (19));

} else {
var statearr_34561_34611 = state_34502__$1;
(statearr_34561_34611[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (37))){
var inst_34489 = (state_34502[(2)]);
var inst_34490 = fluree.db.util.async.throw_err(inst_34489);
var state_34502__$1 = state_34502;
var statearr_34562_34612 = state_34502__$1;
(statearr_34562_34612[(2)] = inst_34490);

(statearr_34562_34612[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34503 === (8))){
var inst_34398 = (state_34502[(2)]);
var state_34502__$1 = state_34502;
if(cljs.core.truth_(inst_34398)){
var statearr_34563_34613 = state_34502__$1;
(statearr_34563_34613[(1)] = (12));

} else {
var statearr_34564_34614 = state_34502__$1;
(statearr_34564_34614[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_34565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34565[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__);

(statearr_34565[(1)] = (1));

return statearr_34565;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____1 = (function (state_34502){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_34502);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e34566){var ex__17136__auto__ = e34566;
var statearr_34567_34615 = state_34502;
(statearr_34567_34615[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_34502[(4)]))){
var statearr_34568_34616 = state_34502;
(statearr_34568_34616[(1)] = cljs.core.first((state_34502[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__34617 = state_34502;
state_34502 = G__34617;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__ = function(state_34502){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____1.call(this,state_34502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_34569 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_34569[(6)] = c__17207__auto__);

return statearr_34569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__34618,res,clause){
var map__34619 = p__34618;
var map__34619__$1 = (((((!((map__34619 == null))))?(((((map__34619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34619):map__34619);
var db = map__34619__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34619__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34619__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34619__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_34719){
var state_val_34720 = (state_34719[(1)]);
if((state_val_34720 === (7))){
var inst_34630 = (state_34719[(7)]);
var state_34719__$1 = state_34719;
var statearr_34721_34761 = state_34719__$1;
(statearr_34721_34761[(2)] = inst_34630);

(statearr_34721_34761[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (20))){
var inst_34710 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
var statearr_34722_34762 = state_34719__$1;
(statearr_34722_34762[(2)] = inst_34710);

(statearr_34722_34762[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (1))){
var state_34719__$1 = state_34719;
var statearr_34723_34763 = state_34719__$1;
(statearr_34723_34763[(2)] = null);

(statearr_34723_34763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (24))){
var inst_34689 = (state_34719[(2)]);
var inst_34690 = fluree.db.util.async.throw_err(inst_34689);
var state_34719__$1 = state_34719;
var statearr_34724_34764 = state_34719__$1;
(statearr_34724_34764[(2)] = inst_34690);

(statearr_34724_34764[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (4))){
var inst_34623 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
var statearr_34725_34765 = state_34719__$1;
(statearr_34725_34765[(2)] = inst_34623);

(statearr_34725_34765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (15))){
var inst_34632 = (state_34719[(8)]);
var inst_34630 = (state_34719[(7)]);
var inst_34651 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_34652 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34654 = [inst_34630];
var inst_34655 = (new cljs.core.PersistentVector(null,1,(5),inst_34653,inst_34654,null));
var inst_34656 = (function (){var subject_var = inst_34630;
var object_var = inst_34632;
var min_sid = inst_34651;
var max_sid = (0);
return (function (p1__34621_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34621_SHARP_);
});
})();
var inst_34657 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34651,(0));
var inst_34658 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34656,inst_34657);
var inst_34659 = cljs.core.PersistentHashMap.EMPTY;
var inst_34660 = [inst_34655,inst_34658,inst_34659];
var inst_34661 = cljs.core.PersistentHashMap.fromArrays(inst_34652,inst_34660);
var state_34719__$1 = state_34719;
var statearr_34726_34766 = state_34719__$1;
(statearr_34726_34766[(2)] = inst_34661);

(statearr_34726_34766[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (21))){
var inst_34683 = (state_34719[(9)]);
var state_34719__$1 = state_34719;
var statearr_34727_34767 = state_34719__$1;
(statearr_34727_34767[(2)] = inst_34683);

(statearr_34727_34767[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (13))){
var inst_34632 = (state_34719[(8)]);
var state_34719__$1 = state_34719;
if(cljs.core.truth_(inst_34632)){
var statearr_34728_34768 = state_34719__$1;
(statearr_34728_34768[(1)] = (18));

} else {
var statearr_34729_34769 = state_34719__$1;
(statearr_34729_34769[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (22))){
var inst_34683 = (state_34719[(9)]);
var inst_34687 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_34683);
var state_34719__$1 = state_34719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34719__$1,(24),inst_34687);
} else {
if((state_val_34720 === (6))){
var inst_34632 = (state_34719[(8)]);
var state_34719__$1 = state_34719;
var statearr_34730_34770 = state_34719__$1;
(statearr_34730_34770[(2)] = inst_34632);

(statearr_34730_34770[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (17))){
var inst_34680 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
var statearr_34731_34771 = state_34719__$1;
(statearr_34731_34771[(2)] = inst_34680);

(statearr_34731_34771[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (3))){
var inst_34717 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34719__$1,inst_34717);
} else {
if((state_val_34720 === (12))){
var inst_34645 = ["_tx",null,"_block",null];
var inst_34646 = (new cljs.core.PersistentArrayMap(null,2,inst_34645,null));
var inst_34647 = (new cljs.core.PersistentHashSet(null,inst_34646,null));
var inst_34648 = cljs.core.last(clause);
var inst_34649 = (inst_34647.cljs$core$IFn$_invoke$arity$1 ? inst_34647.cljs$core$IFn$_invoke$arity$1(inst_34648) : inst_34647.call(null,inst_34648));
var state_34719__$1 = state_34719;
if(cljs.core.truth_(inst_34649)){
var statearr_34732_34772 = state_34719__$1;
(statearr_34732_34772[(1)] = (15));

} else {
var statearr_34733_34773 = state_34719__$1;
(statearr_34733_34773[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (2))){
var inst_34630 = (state_34719[(7)]);
var _ = (function (){var statearr_34734 = state_34719;
(statearr_34734[(4)] = cljs.core.cons((5),(state_34719[(4)])));

return statearr_34734;
})();
var inst_34629 = cljs.core.first(clause);
var inst_34630__$1 = fluree.db.query.analytical.variable_QMARK_(inst_34629);
var inst_34631 = cljs.core.last(clause);
var inst_34632 = fluree.db.query.analytical.variable_QMARK_(inst_34631);
var state_34719__$1 = (function (){var statearr_34735 = state_34719;
(statearr_34735[(8)] = inst_34632);

(statearr_34735[(7)] = inst_34630__$1);

return statearr_34735;
})();
if(cljs.core.truth_(inst_34630__$1)){
var statearr_34736_34774 = state_34719__$1;
(statearr_34736_34774[(1)] = (6));

} else {
var statearr_34737_34775 = state_34719__$1;
(statearr_34737_34775[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (23))){
var inst_34632 = (state_34719[(8)]);
var inst_34692 = (state_34719[(2)]);
var inst_34693 = fluree.db.flake.sid__GT_cid(inst_34692);
var inst_34694 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_34693);
var inst_34695 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34697 = [inst_34632];
var inst_34698 = (new cljs.core.PersistentVector(null,1,(5),inst_34696,inst_34697,null));
var inst_34699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34701 = [inst_34694];
var inst_34702 = (new cljs.core.PersistentVector(null,1,(5),inst_34700,inst_34701,null));
var inst_34703 = [inst_34702];
var inst_34704 = (new cljs.core.PersistentVector(null,1,(5),inst_34699,inst_34703,null));
var inst_34705 = cljs.core.PersistentHashMap.EMPTY;
var inst_34706 = [inst_34698,inst_34704,inst_34705];
var inst_34707 = cljs.core.PersistentHashMap.fromArrays(inst_34695,inst_34706);
var state_34719__$1 = state_34719;
var statearr_34738_34776 = state_34719__$1;
(statearr_34738_34776[(2)] = inst_34707);

(statearr_34738_34776[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (19))){
var state_34719__$1 = state_34719;
var statearr_34739_34777 = state_34719__$1;
(statearr_34739_34777[(2)] = null);

(statearr_34739_34777[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (11))){
var inst_34714 = (state_34719[(2)]);
var _ = (function (){var statearr_34741 = state_34719;
(statearr_34741[(4)] = cljs.core.rest((state_34719[(4)])));

return statearr_34741;
})();
var state_34719__$1 = state_34719;
var statearr_34742_34778 = state_34719__$1;
(statearr_34742_34778[(2)] = inst_34714);

(statearr_34742_34778[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (9))){
var inst_34638 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34639 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34640 = cljs.core.PersistentHashMap.fromArrays(inst_34638,inst_34639);
var inst_34641 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_34640);
var inst_34642 = (function(){throw inst_34641})();
var state_34719__$1 = state_34719;
var statearr_34743_34779 = state_34719__$1;
(statearr_34743_34779[(2)] = inst_34642);

(statearr_34743_34779[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (5))){
var _ = (function (){var statearr_34744 = state_34719;
(statearr_34744[(4)] = cljs.core.rest((state_34719[(4)])));

return statearr_34744;
})();
var state_34719__$1 = state_34719;
var ex34740 = (state_34719__$1[(2)]);
var statearr_34745_34780 = state_34719__$1;
(statearr_34745_34780[(5)] = ex34740);


if((ex34740 instanceof Error)){
var statearr_34746_34781 = state_34719__$1;
(statearr_34746_34781[(1)] = (4));

(statearr_34746_34781[(5)] = null);

} else {
throw ex34740;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (14))){
var inst_34712 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
var statearr_34747_34782 = state_34719__$1;
(statearr_34747_34782[(2)] = inst_34712);

(statearr_34747_34782[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (16))){
var inst_34632 = (state_34719[(8)]);
var inst_34630 = (state_34719[(7)]);
var inst_34663 = cljs.core.last(clause);
var inst_34664 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_34663);
var inst_34665 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_34666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34665,inst_34664);
var inst_34667 = fluree.db.flake.min_subject_id(inst_34664);
var inst_34668 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34670 = [inst_34630];
var inst_34671 = (new cljs.core.PersistentVector(null,1,(5),inst_34669,inst_34670,null));
var inst_34672 = (function (){var subject_var = inst_34630;
var object_var = inst_34632;
var cid = inst_34664;
var max_sid = inst_34666;
var min_sid = inst_34667;
return (function (p1__34622_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34622_SHARP_);
});
})();
var inst_34673 = (inst_34666 + (1));
var inst_34674 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34667,inst_34673);
var inst_34675 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34672,inst_34674);
var inst_34676 = cljs.core.PersistentHashMap.EMPTY;
var inst_34677 = [inst_34671,inst_34675,inst_34676];
var inst_34678 = cljs.core.PersistentHashMap.fromArrays(inst_34668,inst_34677);
var state_34719__$1 = state_34719;
var statearr_34748_34783 = state_34719__$1;
(statearr_34748_34783[(2)] = inst_34678);

(statearr_34748_34783[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (10))){
var inst_34630 = (state_34719[(7)]);
var state_34719__$1 = state_34719;
if(cljs.core.truth_(inst_34630)){
var statearr_34749_34784 = state_34719__$1;
(statearr_34749_34784[(1)] = (12));

} else {
var statearr_34750_34785 = state_34719__$1;
(statearr_34750_34785[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (18))){
var inst_34683 = (state_34719[(9)]);
var inst_34683__$1 = cljs.core.first(clause);
var inst_34684 = typeof inst_34683__$1 === 'number';
var state_34719__$1 = (function (){var statearr_34751 = state_34719;
(statearr_34751[(9)] = inst_34683__$1);

return statearr_34751;
})();
if(cljs.core.truth_(inst_34684)){
var statearr_34752_34786 = state_34719__$1;
(statearr_34752_34786[(1)] = (21));

} else {
var statearr_34753_34787 = state_34719__$1;
(statearr_34753_34787[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34720 === (8))){
var inst_34636 = (state_34719[(2)]);
var state_34719__$1 = state_34719;
if(cljs.core.truth_(inst_34636)){
var statearr_34754_34788 = state_34719__$1;
(statearr_34754_34788[(1)] = (9));

} else {
var statearr_34755_34789 = state_34719__$1;
(statearr_34755_34789[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_34756 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34756[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__);

(statearr_34756[(1)] = (1));

return statearr_34756;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____1 = (function (state_34719){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_34719);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e34757){var ex__17136__auto__ = e34757;
var statearr_34758_34790 = state_34719;
(statearr_34758_34790[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_34719[(4)]))){
var statearr_34759_34791 = state_34719;
(statearr_34759_34791[(1)] = cljs.core.first((state_34719[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__34792 = state_34719;
state_34719 = G__34792;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__ = function(state_34719){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____1.call(this,state_34719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_34760 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_34760[(6)] = c__17207__auto__);

return statearr_34760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__34799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__34799 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__34799;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__34800(s__34801){
return (new cljs.core.LazySeq(null,(function (){
var s__34801__$1 = s__34801;
while(true){
var temp__5754__auto__ = cljs.core.seq(s__34801__$1);
if(temp__5754__auto__){
var s__34801__$2 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34801__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34801__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34803 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34802 = (0);
while(true){
if((i__34802 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__34802);
var delta = (x - mean);
cljs.core.chunk_append(b__34803,(delta * delta));

var G__34805 = (i__34802 + (1));
i__34802 = G__34805;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34803),fluree$db$query$analytical$variance_$_iter__34800(cljs.core.chunk_rest(s__34801__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34803),null);
}
} else {
var x = cljs.core.first(s__34801__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__34800(cljs.core.rest(s__34801__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__34804 = variance(coll);
return Math.sqrt(G__34804);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__34806 = null;
var G__34806__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34806__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34806 = function(n,coll){
switch(arguments.length){
case 1:
return G__34806__1.call(this,n);
case 2:
return G__34806__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34806.cljs$core$IFn$_invoke$arity$1 = G__34806__1;
G__34806.cljs$core$IFn$_invoke$arity$2 = G__34806__2;
return G__34806;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__34807 = null;
var G__34807__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34807__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34807 = function(n,coll){
switch(arguments.length){
case 1:
return G__34807__1.call(this,n);
case 2:
return G__34807__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34807.cljs$core$IFn$_invoke$arity$1 = G__34807__1;
G__34807.cljs$core$IFn$_invoke$arity$2 = G__34807__2;
return G__34807;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__34808 = null;
var G__34808__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__34808__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__34808 = function(n,coll){
switch(arguments.length){
case 1:
return G__34808__1.call(this,n);
case 2:
return G__34808__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34808.cljs$core$IFn$_invoke$arity$1 = G__34808__1;
G__34808.cljs$core$IFn$_invoke$arity$2 = G__34808__2;
return G__34808;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__34809 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34809,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34809,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34809,(2),null);
var agg_fn = (function (){var temp__5752__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5752__auto__)){
var agg_fn = temp__5752__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34812 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__34815 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__34815) : agg_fn.call(null,G__34815));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34812,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34812,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__34816 = agg;
var map__34816__$1 = (((((!((map__34816 == null))))?(((((map__34816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34816):map__34816);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34816__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34816__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34816__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__34819 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34819,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34819,(1),null);
var map__34822 = res__$1;
var map__34822__$1 = (((((!((map__34822 == null))))?(((((map__34822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34822.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34822):map__34822);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34822__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34822__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34818_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__34818_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34824_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34824_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34825_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34825_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34826_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34826_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34827_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34827_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__34830,row,b_tuple){
var vec__34831 = p__34830;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34831,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34831,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34828_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34828_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34829_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34829_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34834_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__34834_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34835_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34835_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34840 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34842 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__34841 = (function (p1__34836_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34836_SHARP_);
});
return fexpr__34841(G__34842);
})()),cljs.core.set(b_idxs));
var fexpr__34839 = (function (p1__34837_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34837_SHARP_);
});
return fexpr__34839(G__34840);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34838_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34838_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34843_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34843_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34844_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34844_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34849 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34851 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34850 = (function (p1__34845_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34845_SHARP_);
});
return fexpr__34850(G__34851);
})()),cljs.core.set(b_idxs));
var fexpr__34848 = (function (p1__34846_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34846_SHARP_);
});
return fexpr__34848(G__34849);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34847_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34847_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34852_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34852_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34853_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34853_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34862 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34864 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__34863 = (function (p1__34854_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34854_SHARP_);
});
return fexpr__34863(G__34864);
})()),cljs.core.set(b_idxs));
var fexpr__34861 = (function (p1__34855_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34855_SHARP_);
});
return fexpr__34861(G__34862);
})();
var vec__34858 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__34865,a_tuple){
var vec__34866 = p__34865;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34866,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34866,(1),null);
var vec__34869 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34869,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34869,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34858,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34858,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34856_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34856_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34857_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34857_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__34873 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34873,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34873,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34872_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__34872_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__34878 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34878,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34878,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34876_SHARP_){
return fluree.db.util.core.index_of(headers,p1__34876_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__34877_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__34877_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__34881,filters,optional_QMARK_){
var map__34882 = p__34881;
var map__34882__$1 = (((((!((map__34882 == null))))?(((((map__34882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34882):map__34882);
var tuple_map = map__34882__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34882__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34882__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34882__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__34884 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34884,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34884,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__34887 = res;
var map__34887__$1 = (((((!((map__34887 == null))))?(((((map__34887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34887.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34887):map__34887);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34887__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34887__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5752__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5752__auto__)){
var valid_var = temp__5752__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_34944){
var state_val_34945 = (state_34944[(1)]);
if((state_val_34945 === (7))){
var inst_34918 = (state_34944[(7)]);
var inst_34916 = (state_34944[(2)]);
var inst_34917 = fluree.db.util.async.throw_err(inst_34916);
var inst_34918__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34917,(0),null);
var inst_34919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34917,(1),null);
var inst_34920 = (inst_34918__$1 == null);
var state_34944__$1 = (function (){var statearr_34946 = state_34944;
(statearr_34946[(7)] = inst_34918__$1);

(statearr_34946[(8)] = inst_34919);

return statearr_34946;
})();
if(cljs.core.truth_(inst_34920)){
var statearr_34947_34976 = state_34944__$1;
(statearr_34947_34976[(1)] = (8));

} else {
var statearr_34948_34977 = state_34944__$1;
(statearr_34948_34977[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (1))){
var inst_34896 = optional_clauses;
var inst_34897 = cljs.core.seq(inst_34896);
var inst_34898 = cljs.core.first(inst_34897);
var inst_34899 = cljs.core.next(inst_34897);
var inst_34900 = where_tuples;
var inst_34901 = inst_34896;
var inst_34902 = inst_34900;
var state_34944__$1 = (function (){var statearr_34949 = state_34944;
(statearr_34949[(9)] = inst_34901);

(statearr_34949[(10)] = inst_34898);

(statearr_34949[(11)] = inst_34899);

(statearr_34949[(12)] = inst_34902);

return statearr_34949;
})();
var statearr_34950_34978 = state_34944__$1;
(statearr_34950_34978[(2)] = null);

(statearr_34950_34978[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (4))){
var inst_34909 = (state_34944[(13)]);
var inst_34908 = (state_34944[(14)]);
var inst_34902 = (state_34944[(12)]);
var inst_34914 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_34902,inst_34908,inst_34909,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_34902,inst_34908,inst_34909,true,fuel,max_fuel,opts));
var state_34944__$1 = state_34944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34944__$1,(7),inst_34914);
} else {
if((state_val_34945 === (15))){
var state_34944__$1 = state_34944;
var statearr_34951_34979 = state_34944__$1;
(statearr_34951_34979[(2)] = null);

(statearr_34951_34979[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (13))){
var inst_34935 = (state_34944[(2)]);
var state_34944__$1 = state_34944;
var statearr_34952_34980 = state_34944__$1;
(statearr_34952_34980[(2)] = inst_34935);

(statearr_34952_34980[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (6))){
var inst_34940 = (state_34944[(2)]);
var state_34944__$1 = state_34944;
var statearr_34953_34981 = state_34944__$1;
(statearr_34953_34981[(2)] = inst_34940);

(statearr_34953_34981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (3))){
var inst_34942 = (state_34944[(2)]);
var state_34944__$1 = state_34944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34944__$1,inst_34942);
} else {
if((state_val_34945 === (12))){
var state_34944__$1 = state_34944;
var statearr_34954_34982 = state_34944__$1;
(statearr_34954_34982[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (2))){
var inst_34901 = (state_34944[(9)]);
var inst_34908 = (state_34944[(14)]);
var inst_34907 = cljs.core.seq(inst_34901);
var inst_34908__$1 = cljs.core.first(inst_34907);
var inst_34909 = cljs.core.next(inst_34907);
var state_34944__$1 = (function (){var statearr_34956 = state_34944;
(statearr_34956[(13)] = inst_34909);

(statearr_34956[(14)] = inst_34908__$1);

return statearr_34956;
})();
if(cljs.core.truth_(inst_34908__$1)){
var statearr_34957_34983 = state_34944__$1;
(statearr_34957_34983[(1)] = (4));

} else {
var statearr_34958_34984 = state_34944__$1;
(statearr_34958_34984[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (11))){
var inst_34918 = (state_34944[(7)]);
var inst_34919 = (state_34944[(8)]);
var inst_34901 = inst_34919;
var inst_34902 = inst_34918;
var state_34944__$1 = (function (){var statearr_34959 = state_34944;
(statearr_34959[(9)] = inst_34901);

(statearr_34959[(12)] = inst_34902);

return statearr_34959;
})();
var statearr_34960_34985 = state_34944__$1;
(statearr_34960_34985[(2)] = null);

(statearr_34960_34985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (9))){
var inst_34908 = (state_34944[(14)]);
var inst_34924 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_34908);
var state_34944__$1 = state_34944;
if(cljs.core.truth_(inst_34924)){
var statearr_34961_34986 = state_34944__$1;
(statearr_34961_34986[(1)] = (11));

} else {
var statearr_34962_34987 = state_34944__$1;
(statearr_34962_34987[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (5))){
var inst_34902 = (state_34944[(12)]);
var state_34944__$1 = state_34944;
var statearr_34963_34988 = state_34944__$1;
(statearr_34963_34988[(2)] = inst_34902);

(statearr_34963_34988[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (14))){
var inst_34918 = (state_34944[(7)]);
var inst_34919 = (state_34944[(8)]);
var inst_34902 = (state_34944[(12)]);
var inst_34929 = fluree.db.query.analytical.left_outer_join(inst_34902,inst_34918);
var inst_34901 = inst_34919;
var inst_34902__$1 = inst_34929;
var state_34944__$1 = (function (){var statearr_34964 = state_34944;
(statearr_34964[(9)] = inst_34901);

(statearr_34964[(12)] = inst_34902__$1);

return statearr_34964;
})();
var statearr_34965_34989 = state_34944__$1;
(statearr_34965_34989[(2)] = null);

(statearr_34965_34989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (16))){
var inst_34933 = (state_34944[(2)]);
var state_34944__$1 = state_34944;
var statearr_34967_34990 = state_34944__$1;
(statearr_34967_34990[(2)] = inst_34933);

(statearr_34967_34990[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (10))){
var inst_34937 = (state_34944[(2)]);
var state_34944__$1 = state_34944;
var statearr_34968_34991 = state_34944__$1;
(statearr_34968_34991[(2)] = inst_34937);

(statearr_34968_34991[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34945 === (8))){
var inst_34919 = (state_34944[(8)]);
var inst_34902 = (state_34944[(12)]);
var tmp34966 = inst_34902;
var inst_34901 = inst_34919;
var inst_34902__$1 = tmp34966;
var state_34944__$1 = (function (){var statearr_34969 = state_34944;
(statearr_34969[(9)] = inst_34901);

(statearr_34969[(12)] = inst_34902__$1);

return statearr_34969;
})();
var statearr_34970_34992 = state_34944__$1;
(statearr_34970_34992[(2)] = null);

(statearr_34970_34992[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____0 = (function (){
var statearr_34971 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34971[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__);

(statearr_34971[(1)] = (1));

return statearr_34971;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____1 = (function (state_34944){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_34944);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e34972){var ex__17136__auto__ = e34972;
var statearr_34973_34993 = state_34944;
(statearr_34973_34993[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_34944[(4)]))){
var statearr_34974_34994 = state_34944;
(statearr_34974_34994[(1)] = cljs.core.first((state_34944[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__34995 = state_34944;
state_34944 = G__34995;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__ = function(state_34944){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____1.call(this,state_34944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_34975 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_34975[(6)] = c__17207__auto__);

return statearr_34975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34997){
var vec__34998 = p__34997;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34998,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34998,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34996_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34996_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__35002,p__35003,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__35004 = p__35002;
var map__35004__$1 = (((((!((map__35004 == null))))?(((((map__35004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35004.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35004):map__35004);
var q_map = map__35004__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35004__$1,cljs.core.cst$kw$prefixes);
var map__35005 = p__35003;
var map__35005__$1 = (((((!((map__35005 == null))))?(((((map__35005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35005.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35005):map__35005);
var res = map__35005__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35005__$1,cljs.core.cst$kw$vars);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35214){
var state_val_35215 = (state_35214[(1)]);
if((state_val_35215 === (7))){
var inst_35112 = cljs.core.count(clause);
var inst_35113 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35112);
var inst_35114 = cljs.core.second(clause);
var inst_35115 = clojure.string.starts_with_QMARK_(inst_35114,"fullText:");
var inst_35116 = ((inst_35113) && (inst_35115));
var state_35214__$1 = state_35214;
if(cljs.core.truth_(inst_35116)){
var statearr_35216_35311 = state_35214__$1;
(statearr_35216_35311[(1)] = (31));

} else {
var statearr_35217_35312 = state_35214__$1;
(statearr_35217_35312[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (59))){
var inst_35183 = (state_35214[(7)]);
var inst_35186 = (state_35214[(2)]);
var inst_35187 = fluree.db.util.async.throw_err(inst_35186);
var inst_35188 = [inst_35187,r];
var inst_35189 = (new cljs.core.PersistentVector(null,2,(5),inst_35183,inst_35188,null));
var state_35214__$1 = state_35214;
var statearr_35218_35313 = state_35214__$1;
(statearr_35218_35313[(2)] = inst_35189);

(statearr_35218_35313[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (20))){
var inst_35076 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35219_35314 = state_35214__$1;
(statearr_35219_35314[(2)] = inst_35076);

(statearr_35219_35314[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (58))){
var inst_35192 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35220_35315 = state_35214__$1;
(statearr_35220_35315[(2)] = inst_35192);

(statearr_35220_35315[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (27))){
var inst_35106 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35221_35316 = state_35214__$1;
(statearr_35221_35316[(2)] = inst_35106);

(statearr_35221_35316[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (1))){
var state_35214__$1 = state_35214;
var statearr_35222_35317 = state_35214__$1;
(statearr_35222_35317[(2)] = null);

(statearr_35222_35317[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (24))){
var inst_35070 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35223_35318 = state_35214__$1;
(statearr_35223_35318[(2)] = inst_35070);

(statearr_35223_35318[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (55))){
var inst_35194 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35224_35319 = state_35214__$1;
(statearr_35224_35319[(2)] = inst_35194);

(statearr_35224_35319[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (39))){
var inst_35148 = cljs.core.count(clause);
var inst_35149 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35148);
var state_35214__$1 = state_35214;
if(inst_35149){
var statearr_35225_35320 = state_35214__$1;
(statearr_35225_35320[(1)] = (42));

} else {
var statearr_35226_35321 = state_35214__$1;
(statearr_35226_35321[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (46))){
var state_35214__$1 = state_35214;
var statearr_35227_35322 = state_35214__$1;
(statearr_35227_35322[(2)] = null);

(statearr_35227_35322[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (4))){
var inst_35008 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35228_35323 = state_35214__$1;
(statearr_35228_35323[(2)] = inst_35008);

(statearr_35228_35323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (54))){
var state_35214__$1 = state_35214;
var statearr_35229_35324 = state_35214__$1;
(statearr_35229_35324[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (15))){
var inst_35108 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35231_35325 = state_35214__$1;
(statearr_35231_35325[(2)] = inst_35108);

(statearr_35231_35325[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (48))){
var inst_35165 = (state_35214[(8)]);
var inst_35163 = (state_35214[(2)]);
var inst_35164 = fluree.db.util.async.throw_err(inst_35163);
var inst_35165__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35164,(0),null);
var inst_35166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35164,(1),null);
var inst_35167 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_35165__$1);
var state_35214__$1 = (function (){var statearr_35232 = state_35214;
(statearr_35232[(9)] = inst_35166);

(statearr_35232[(8)] = inst_35165__$1);

return statearr_35232;
})();
if(inst_35167){
var statearr_35233_35326 = state_35214__$1;
(statearr_35233_35326[(1)] = (49));

} else {
var statearr_35234_35327 = state_35214__$1;
(statearr_35234_35327[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (50))){
var inst_35166 = (state_35214[(9)]);
var inst_35174 = cljs.core.second(inst_35166);
var inst_35175 = clojure.string.starts_with_QMARK_(inst_35174,"fullText:");
var state_35214__$1 = state_35214;
if(inst_35175){
var statearr_35235_35328 = state_35214__$1;
(statearr_35235_35328[(1)] = (53));

} else {
var statearr_35236_35329 = state_35214__$1;
(statearr_35236_35329[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (21))){
var inst_35047 = (state_35214[(10)]);
var inst_35054 = (state_35214[(11)]);
var inst_35044 = (state_35214[(12)]);
var inst_35042 = (state_35214[(13)]);
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35046 = (state_35214[(16)]);
var inst_35053 = (state_35214[(17)]);
var inst_35045 = (state_35214[(18)]);
var inst_35058 = (state_35214[(2)]);
var inst_35059 = fluree.db.util.async.throw_err(inst_35058);
var inst_35060 = (function (){var seq__35040 = inst_35045;
var new_res = inst_35059;
var rest = inst_35054;
var pred__35018 = inst_35021;
var G__35038 = inst_35046;
var tuples = inst_35047;
var expr__35019 = inst_35017;
var vec__35049 = inst_35046;
var seq__35050 = inst_35054;
var vec__35039 = inst_35042;
var first__35041 = inst_35044;
var segment_type = inst_35017;
var first__35051 = inst_35053;
var clause_group = inst_35053;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_35061 = cljs.core.keys(vars);
var inst_35062 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35060,inst_35059,inst_35061);
var inst_35063 = fluree.db.query.analytical.res_absorb_vars(inst_35062);
var state_35214__$1 = (function (){var statearr_35237 = state_35214;
(statearr_35237[(19)] = inst_35063);

return statearr_35237;
})();
if(cljs.core.truth_(inst_35047)){
var statearr_35238_35330 = state_35214__$1;
(statearr_35238_35330[(1)] = (22));

} else {
var statearr_35239_35331 = state_35214__$1;
(statearr_35239_35331[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (31))){
var inst_35118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35119 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_35120 = [inst_35119,r];
var inst_35121 = (new cljs.core.PersistentVector(null,2,(5),inst_35118,inst_35120,null));
var state_35214__$1 = state_35214;
var statearr_35240_35332 = state_35214__$1;
(statearr_35240_35332[(2)] = inst_35121);

(statearr_35240_35332[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (32))){
var inst_35123 = cljs.core.count(clause);
var inst_35124 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35123);
var inst_35125 = cljs.core.second(clause);
var inst_35126 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35125,"rdf:type");
var inst_35127 = ((inst_35124) && (inst_35126));
var state_35214__$1 = state_35214;
if(cljs.core.truth_(inst_35127)){
var statearr_35241_35333 = state_35214__$1;
(statearr_35241_35333[(1)] = (34));

} else {
var statearr_35242_35334 = state_35214__$1;
(statearr_35242_35334[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (40))){
var inst_35203 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35243_35335 = state_35214__$1;
(statearr_35243_35335[(2)] = inst_35203);

(statearr_35243_35335[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (56))){
var inst_35166 = (state_35214[(9)]);
var inst_35165 = (state_35214[(8)]);
var inst_35183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35184 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_35165,res,inst_35166,fuel,max_fuel);
var state_35214__$1 = (function (){var statearr_35244 = state_35214;
(statearr_35244[(7)] = inst_35183);

return statearr_35244;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(59),inst_35184);
} else {
if((state_val_35215 === (33))){
var inst_35207 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35245_35336 = state_35214__$1;
(statearr_35245_35336[(2)] = inst_35207);

(statearr_35245_35336[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (13))){
var inst_35042 = (state_35214[(13)]);
var inst_35042__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35043 = cljs.core.seq(inst_35042__$1);
var inst_35044 = cljs.core.first(inst_35043);
var inst_35045 = cljs.core.next(inst_35043);
var inst_35046 = inst_35042__$1;
var inst_35047 = null;
var state_35214__$1 = (function (){var statearr_35246 = state_35214;
(statearr_35246[(10)] = inst_35047);

(statearr_35246[(12)] = inst_35044);

(statearr_35246[(13)] = inst_35042__$1);

(statearr_35246[(16)] = inst_35046);

(statearr_35246[(18)] = inst_35045);

return statearr_35246;
})();
var statearr_35247_35337 = state_35214__$1;
(statearr_35247_35337[(2)] = null);

(statearr_35247_35337[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (22))){
var inst_35047 = (state_35214[(10)]);
var inst_35063 = (state_35214[(19)]);
var inst_35054 = (state_35214[(11)]);
var inst_35065 = fluree.db.query.analytical.outer_union(inst_35047,inst_35063);
var inst_35046 = inst_35054;
var inst_35047__$1 = inst_35065;
var state_35214__$1 = (function (){var statearr_35248 = state_35214;
(statearr_35248[(10)] = inst_35047__$1);

(statearr_35248[(16)] = inst_35046);

return statearr_35248;
})();
var statearr_35249_35338 = state_35214__$1;
(statearr_35249_35338[(2)] = null);

(statearr_35249_35338[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (36))){
var inst_35205 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35250_35339 = state_35214__$1;
(statearr_35250_35339[(2)] = inst_35205);

(statearr_35250_35339[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (41))){
var inst_35140 = (state_35214[(20)]);
var inst_35143 = (state_35214[(2)]);
var inst_35144 = fluree.db.util.async.throw_err(inst_35143);
var inst_35145 = [inst_35144,r];
var inst_35146 = (new cljs.core.PersistentVector(null,2,(5),inst_35140,inst_35145,null));
var state_35214__$1 = state_35214;
var statearr_35251_35340 = state_35214__$1;
(statearr_35251_35340[(2)] = inst_35146);

(statearr_35251_35340[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (43))){
var state_35214__$1 = state_35214;
var statearr_35252_35341 = state_35214__$1;
(statearr_35252_35341[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (29))){
var inst_35017 = (state_35214[(14)]);
var inst_35100 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35017)].join('');
var inst_35101 = (new Error(inst_35100));
var inst_35102 = (function(){throw inst_35101})();
var state_35214__$1 = state_35214;
var statearr_35254_35342 = state_35214__$1;
(statearr_35254_35342[(2)] = inst_35102);

(statearr_35254_35342[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (44))){
var inst_35201 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35255_35343 = state_35214__$1;
(statearr_35255_35343[(2)] = inst_35201);

(statearr_35255_35343[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (6))){
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35016 = cljs.core.keys(clause);
var inst_35017__$1 = cljs.core.first(inst_35016);
var inst_35021__$1 = cljs.core._EQ_;
var inst_35022 = (function (){var G__35256 = cljs.core.cst$kw$optional;
var G__35257 = inst_35017__$1;
return (inst_35021__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35021__$1.cljs$core$IFn$_invoke$arity$2(G__35256,G__35257) : inst_35021__$1.call(null,G__35256,G__35257));
})();
var state_35214__$1 = (function (){var statearr_35258 = state_35214;
(statearr_35258[(14)] = inst_35017__$1);

(statearr_35258[(15)] = inst_35021__$1);

return statearr_35258;
})();
if(cljs.core.truth_(inst_35022)){
var statearr_35259_35344 = state_35214__$1;
(statearr_35259_35344[(1)] = (9));

} else {
var statearr_35260_35345 = state_35214__$1;
(statearr_35260_35345[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (28))){
var inst_35094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35095 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35096 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_35095,optional_QMARK_);
var inst_35097 = [inst_35096,r];
var inst_35098 = (new cljs.core.PersistentVector(null,2,(5),inst_35094,inst_35097,null));
var state_35214__$1 = state_35214;
var statearr_35261_35346 = state_35214__$1;
(statearr_35261_35346[(2)] = inst_35098);

(statearr_35261_35346[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (51))){
var inst_35196 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35262_35347 = state_35214__$1;
(statearr_35262_35347[(2)] = inst_35196);

(statearr_35262_35347[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (25))){
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35082 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35083 = (function (){var segment_type = inst_35017;
var pred__35018 = inst_35021;
var expr__35019 = inst_35017;
var bindings = inst_35082;
return (function (p1__35001_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__35001_SHARP_);
});
})();
var inst_35084 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35083,inst_35082);
var inst_35085 = cljs.core.PersistentHashMap.EMPTY;
var inst_35086 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35085,inst_35084);
var inst_35087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35088 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35086);
var inst_35089 = [inst_35088,r];
var inst_35090 = (new cljs.core.PersistentVector(null,2,(5),inst_35087,inst_35089,null));
var state_35214__$1 = state_35214;
var statearr_35263_35348 = state_35214__$1;
(statearr_35263_35348[(2)] = inst_35090);

(statearr_35263_35348[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (34))){
var inst_35129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35130 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_35214__$1 = (function (){var statearr_35264 = state_35214;
(statearr_35264[(21)] = inst_35129);

return statearr_35264;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(37),inst_35130);
} else {
if((state_val_35215 === (17))){
var inst_35078 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35265_35349 = state_35214__$1;
(statearr_35265_35349[(2)] = inst_35078);

(statearr_35265_35349[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (3))){
var inst_35212 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35214__$1,inst_35212);
} else {
if((state_val_35215 === (12))){
var inst_35024 = (state_35214[(22)]);
var inst_35028 = (state_35214[(2)]);
var inst_35029 = fluree.db.util.async.throw_err(inst_35028);
var inst_35030 = [inst_35029,r];
var inst_35031 = (new cljs.core.PersistentVector(null,2,(5),inst_35024,inst_35030,null));
var state_35214__$1 = state_35214;
var statearr_35266_35350 = state_35214__$1;
(statearr_35266_35350[(2)] = inst_35031);

(statearr_35266_35350[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (2))){
var _ = (function (){var statearr_35267 = state_35214;
(statearr_35267[(4)] = cljs.core.cons((5),(state_35214[(4)])));

return statearr_35267;
})();
var inst_35014 = cljs.core.map_QMARK_(clause);
var state_35214__$1 = state_35214;
if(inst_35014){
var statearr_35268_35351 = state_35214__$1;
(statearr_35268_35351[(1)] = (6));

} else {
var statearr_35269_35352 = state_35214__$1;
(statearr_35269_35352[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (23))){
var inst_35063 = (state_35214[(19)]);
var inst_35054 = (state_35214[(11)]);
var inst_35046 = inst_35054;
var inst_35047 = inst_35063;
var state_35214__$1 = (function (){var statearr_35270 = state_35214;
(statearr_35270[(10)] = inst_35047);

(statearr_35270[(16)] = inst_35046);

return statearr_35270;
})();
var statearr_35271_35353 = state_35214__$1;
(statearr_35271_35353[(2)] = null);

(statearr_35271_35353[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (47))){
var inst_35199 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35272_35354 = state_35214__$1;
(statearr_35272_35354[(2)] = inst_35199);

(statearr_35272_35354[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (35))){
var inst_35137 = cljs.core.count(clause);
var inst_35138 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35137);
var state_35214__$1 = state_35214;
if(inst_35138){
var statearr_35273_35355 = state_35214__$1;
(statearr_35273_35355[(1)] = (38));

} else {
var statearr_35274_35356 = state_35214__$1;
(statearr_35274_35356[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (19))){
var inst_35047 = (state_35214[(10)]);
var inst_35072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35073 = [inst_35047,r];
var inst_35074 = (new cljs.core.PersistentVector(null,2,(5),inst_35072,inst_35073,null));
var state_35214__$1 = state_35214;
var statearr_35275_35357 = state_35214__$1;
(statearr_35275_35357[(2)] = inst_35074);

(statearr_35275_35357[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (57))){
var state_35214__$1 = state_35214;
var statearr_35276_35358 = state_35214__$1;
(statearr_35276_35358[(2)] = null);

(statearr_35276_35358[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (11))){
var inst_35110 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35278_35359 = state_35214__$1;
(statearr_35278_35359[(2)] = inst_35110);

(statearr_35278_35359[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (9))){
var inst_35024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35025 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35026 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35025,res,fuel,max_fuel,opts);
var state_35214__$1 = (function (){var statearr_35279 = state_35214;
(statearr_35279[(22)] = inst_35024);

return statearr_35279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(12),inst_35026);
} else {
if((state_val_35215 === (5))){
var _ = (function (){var statearr_35280 = state_35214;
(statearr_35280[(4)] = cljs.core.rest((state_35214[(4)])));

return statearr_35280;
})();
var state_35214__$1 = state_35214;
var ex35277 = (state_35214__$1[(2)]);
var statearr_35281_35360 = state_35214__$1;
(statearr_35281_35360[(5)] = ex35277);


if((ex35277 instanceof Error)){
var statearr_35282_35361 = state_35214__$1;
(statearr_35282_35361[(1)] = (4));

(statearr_35282_35361[(5)] = null);

} else {
throw ex35277;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (14))){
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35080 = (function (){var G__35283 = cljs.core.cst$kw$bind;
var G__35284 = inst_35017;
return (inst_35021.cljs$core$IFn$_invoke$arity$2 ? inst_35021.cljs$core$IFn$_invoke$arity$2(G__35283,G__35284) : inst_35021.call(null,G__35283,G__35284));
})();
var state_35214__$1 = state_35214;
if(cljs.core.truth_(inst_35080)){
var statearr_35285_35362 = state_35214__$1;
(statearr_35285_35362[(1)] = (25));

} else {
var statearr_35286_35363 = state_35214__$1;
(statearr_35286_35363[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (45))){
var inst_35161 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_35214__$1 = state_35214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(48),inst_35161);
} else {
if((state_val_35215 === (53))){
var inst_35166 = (state_35214[(9)]);
var inst_35165 = (state_35214[(8)]);
var inst_35177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35178 = fluree.db.query.analytical.full_text__GT_tuples(inst_35165,res,inst_35166);
var inst_35179 = [inst_35178,r];
var inst_35180 = (new cljs.core.PersistentVector(null,2,(5),inst_35177,inst_35179,null));
var state_35214__$1 = state_35214;
var statearr_35287_35364 = state_35214__$1;
(statearr_35287_35364[(2)] = inst_35180);

(statearr_35287_35364[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (26))){
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35092 = (function (){var G__35288 = cljs.core.cst$kw$filter;
var G__35289 = inst_35017;
return (inst_35021.cljs$core$IFn$_invoke$arity$2 ? inst_35021.cljs$core$IFn$_invoke$arity$2(G__35288,G__35289) : inst_35021.call(null,G__35288,G__35289));
})();
var state_35214__$1 = state_35214;
if(cljs.core.truth_(inst_35092)){
var statearr_35290_35365 = state_35214__$1;
(statearr_35290_35365[(1)] = (28));

} else {
var statearr_35291_35366 = state_35214__$1;
(statearr_35291_35366[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (16))){
var inst_35046 = (state_35214[(16)]);
var inst_35053 = (state_35214[(17)]);
var inst_35052 = cljs.core.seq(inst_35046);
var inst_35053__$1 = cljs.core.first(inst_35052);
var inst_35054 = cljs.core.next(inst_35052);
var state_35214__$1 = (function (){var statearr_35292 = state_35214;
(statearr_35292[(11)] = inst_35054);

(statearr_35292[(17)] = inst_35053__$1);

return statearr_35292;
})();
if(cljs.core.truth_(inst_35053__$1)){
var statearr_35293_35367 = state_35214__$1;
(statearr_35293_35367[(1)] = (18));

} else {
var statearr_35294_35368 = state_35214__$1;
(statearr_35294_35368[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (38))){
var inst_35140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35141 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_35214__$1 = (function (){var statearr_35295 = state_35214;
(statearr_35295[(20)] = inst_35140);

return statearr_35295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(41),inst_35141);
} else {
if((state_val_35215 === (30))){
var inst_35104 = (state_35214[(2)]);
var state_35214__$1 = state_35214;
var statearr_35296_35369 = state_35214__$1;
(statearr_35296_35369[(2)] = inst_35104);

(statearr_35296_35369[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (10))){
var inst_35017 = (state_35214[(14)]);
var inst_35021 = (state_35214[(15)]);
var inst_35033 = (function (){var G__35297 = cljs.core.cst$kw$union;
var G__35298 = inst_35017;
return (inst_35021.cljs$core$IFn$_invoke$arity$2 ? inst_35021.cljs$core$IFn$_invoke$arity$2(G__35297,G__35298) : inst_35021.call(null,G__35297,G__35298));
})();
var state_35214__$1 = state_35214;
if(cljs.core.truth_(inst_35033)){
var statearr_35299_35370 = state_35214__$1;
(statearr_35299_35370[(1)] = (13));

} else {
var statearr_35300_35371 = state_35214__$1;
(statearr_35300_35371[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (18))){
var inst_35053 = (state_35214[(17)]);
var inst_35056 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35053,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_35053,q_map,vars,fuel,max_fuel,opts));
var state_35214__$1 = state_35214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(21),inst_35056);
} else {
if((state_val_35215 === (52))){
var inst_35171 = (state_35214[(2)]);
var inst_35172 = fluree.db.util.async.throw_err(inst_35171);
var state_35214__$1 = state_35214;
var statearr_35301_35372 = state_35214__$1;
(statearr_35301_35372[(2)] = inst_35172);

(statearr_35301_35372[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (42))){
var inst_35151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35152 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_35153 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35152);
var inst_35154 = [inst_35153,r];
var inst_35155 = (new cljs.core.PersistentVector(null,2,(5),inst_35151,inst_35154,null));
var state_35214__$1 = state_35214;
var statearr_35302_35373 = state_35214__$1;
(statearr_35302_35373[(2)] = inst_35155);

(statearr_35302_35373[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (37))){
var inst_35129 = (state_35214[(21)]);
var inst_35132 = (state_35214[(2)]);
var inst_35133 = fluree.db.util.async.throw_err(inst_35132);
var inst_35134 = [inst_35133,r];
var inst_35135 = (new cljs.core.PersistentVector(null,2,(5),inst_35129,inst_35134,null));
var state_35214__$1 = state_35214;
var statearr_35303_35374 = state_35214__$1;
(statearr_35303_35374[(2)] = inst_35135);

(statearr_35303_35374[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (8))){
var inst_35209 = (state_35214[(2)]);
var _ = (function (){var statearr_35304 = state_35214;
(statearr_35304[(4)] = cljs.core.rest((state_35214[(4)])));

return statearr_35304;
})();
var state_35214__$1 = state_35214;
var statearr_35305_35375 = state_35214__$1;
(statearr_35305_35375[(2)] = inst_35209);

(statearr_35305_35375[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35215 === (49))){
var inst_35166 = (state_35214[(9)]);
var inst_35169 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_35166,r,res,optional_QMARK_,fuel,max_fuel);
var state_35214__$1 = state_35214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35214__$1,(52),inst_35169);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_35306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35306[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__);

(statearr_35306[(1)] = (1));

return statearr_35306;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____1 = (function (state_35214){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35214);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35307){var ex__17136__auto__ = e35307;
var statearr_35308_35376 = state_35214;
(statearr_35308_35376[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35214[(4)]))){
var statearr_35309_35377 = state_35214;
(statearr_35309_35377[(1)] = cljs.core.first((state_35214[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35378 = state_35214;
state_35214 = G__35378;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__ = function(state_35214){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____1.call(this,state_35214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35310 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35310[(6)] = c__17207__auto__);

return statearr_35310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__35380 = arguments.length;
switch (G__35380) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35460){
var state_val_35461 = (state_35460[(1)]);
if((state_val_35461 === (7))){
var inst_35455 = (state_35460[(2)]);
var _ = (function (){var statearr_35462 = state_35460;
(statearr_35462[(4)] = cljs.core.rest((state_35460[(4)])));

return statearr_35462;
})();
var state_35460__$1 = state_35460;
var statearr_35463_35511 = state_35460__$1;
(statearr_35463_35511[(2)] = inst_35455);

(statearr_35463_35511[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (20))){
var inst_35420 = (state_35460[(7)]);
var inst_35432 = (state_35460[(2)]);
var inst_35402 = inst_35420;
var inst_35403 = inst_35432;
var state_35460__$1 = (function (){var statearr_35464 = state_35460;
(statearr_35464[(8)] = inst_35403);

(statearr_35464[(9)] = inst_35402);

return statearr_35464;
})();
var statearr_35465_35512 = state_35460__$1;
(statearr_35465_35512[(2)] = null);

(statearr_35465_35512[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (1))){
var state_35460__$1 = state_35460;
var statearr_35466_35513 = state_35460__$1;
(statearr_35466_35513[(2)] = null);

(statearr_35466_35513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (24))){
var inst_35419 = (state_35460[(10)]);
var inst_35403 = (state_35460[(8)]);
var inst_35420 = (state_35460[(7)]);
var inst_35440 = fluree.db.query.analytical.inner_join(inst_35403,inst_35419);
var inst_35402 = inst_35420;
var inst_35403__$1 = inst_35440;
var state_35460__$1 = (function (){var statearr_35467 = state_35460;
(statearr_35467[(8)] = inst_35403__$1);

(statearr_35467[(9)] = inst_35402);

return statearr_35467;
})();
var statearr_35468_35514 = state_35460__$1;
(statearr_35468_35514[(2)] = null);

(statearr_35468_35514[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (4))){
var inst_35381 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35470_35515 = state_35460__$1;
(statearr_35470_35515[(2)] = inst_35381);

(statearr_35470_35515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (15))){
var inst_35419 = (state_35460[(10)]);
var state_35460__$1 = state_35460;
if(cljs.core.truth_(inst_35419)){
var statearr_35471_35516 = state_35460__$1;
(statearr_35471_35516[(1)] = (18));

} else {
var statearr_35472_35517 = state_35460__$1;
(statearr_35472_35517[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (21))){
var inst_35403 = (state_35460[(8)]);
var inst_35420 = (state_35460[(7)]);
var tmp35469 = inst_35403;
var inst_35402 = inst_35420;
var inst_35403__$1 = tmp35469;
var state_35460__$1 = (function (){var statearr_35473 = state_35460;
(statearr_35473[(8)] = inst_35403__$1);

(statearr_35473[(9)] = inst_35402);

return statearr_35473;
})();
var statearr_35474_35518 = state_35460__$1;
(statearr_35474_35518[(2)] = null);

(statearr_35474_35518[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (13))){
var inst_35403 = (state_35460[(8)]);
var inst_35426 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_35403,cljs.core.cst$kw$vars);
var inst_35427 = cljs.core.empty_QMARK_(inst_35426);
var state_35460__$1 = state_35460;
if(inst_35427){
var statearr_35475_35519 = state_35460__$1;
(statearr_35475_35519[(1)] = (15));

} else {
var statearr_35476_35520 = state_35460__$1;
(statearr_35476_35520[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (22))){
var state_35460__$1 = state_35460;
var statearr_35477_35521 = state_35460__$1;
(statearr_35477_35521[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (6))){
var inst_35402 = (state_35460[(9)]);
var inst_35409 = (state_35460[(11)]);
var inst_35408 = cljs.core.seq(inst_35402);
var inst_35409__$1 = cljs.core.first(inst_35408);
var inst_35410 = cljs.core.next(inst_35408);
var state_35460__$1 = (function (){var statearr_35479 = state_35460;
(statearr_35479[(11)] = inst_35409__$1);

(statearr_35479[(12)] = inst_35410);

return statearr_35479;
})();
if(cljs.core.truth_(inst_35409__$1)){
var statearr_35480_35522 = state_35460__$1;
(statearr_35480_35522[(1)] = (8));

} else {
var statearr_35481_35523 = state_35460__$1;
(statearr_35481_35523[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (25))){
var state_35460__$1 = state_35460;
var statearr_35482_35524 = state_35460__$1;
(statearr_35482_35524[(2)] = null);

(statearr_35482_35524[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (17))){
var inst_35448 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35483_35525 = state_35460__$1;
(statearr_35483_35525[(2)] = inst_35448);

(statearr_35483_35525[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (3))){
var inst_35458 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35460__$1,inst_35458);
} else {
if((state_val_35461 === (12))){
var inst_35419 = (state_35460[(10)]);
var inst_35420 = (state_35460[(7)]);
var inst_35402 = inst_35420;
var inst_35403 = inst_35419;
var state_35460__$1 = (function (){var statearr_35484 = state_35460;
(statearr_35484[(8)] = inst_35403);

(statearr_35484[(9)] = inst_35402);

return statearr_35484;
})();
var statearr_35485_35526 = state_35460__$1;
(statearr_35485_35526[(2)] = null);

(statearr_35485_35526[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (2))){
var _ = (function (){var statearr_35486 = state_35460;
(statearr_35486[(4)] = cljs.core.cons((5),(state_35460[(4)])));

return statearr_35486;
})();
var inst_35394 = where;
var inst_35395 = cljs.core.seq(inst_35394);
var inst_35396 = cljs.core.first(inst_35395);
var inst_35397 = cljs.core.next(inst_35395);
var inst_35398 = [cljs.core.cst$kw$vars];
var inst_35399 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_35400 = [inst_35399];
var inst_35401 = cljs.core.PersistentHashMap.fromArrays(inst_35398,inst_35400);
var inst_35402 = inst_35394;
var inst_35403 = inst_35401;
var state_35460__$1 = (function (){var statearr_35487 = state_35460;
(statearr_35487[(13)] = inst_35396);

(statearr_35487[(8)] = inst_35403);

(statearr_35487[(9)] = inst_35402);

(statearr_35487[(14)] = inst_35397);

return statearr_35487;
})();
var statearr_35488_35527 = state_35460__$1;
(statearr_35488_35527[(2)] = null);

(statearr_35488_35527[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (23))){
var inst_35446 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35489_35528 = state_35460__$1;
(statearr_35489_35528[(2)] = inst_35446);

(statearr_35489_35528[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (19))){
var inst_35403 = (state_35460[(8)]);
var state_35460__$1 = state_35460;
var statearr_35490_35529 = state_35460__$1;
(statearr_35490_35529[(2)] = inst_35403);

(statearr_35490_35529[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (11))){
var inst_35409 = (state_35460[(11)]);
var inst_35417 = (state_35460[(2)]);
var inst_35418 = fluree.db.util.async.throw_err(inst_35417);
var inst_35419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35418,(0),null);
var inst_35420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35418,(1),null);
var inst_35421 = cljs.core.count(inst_35409);
var inst_35422 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35421);
var state_35460__$1 = (function (){var statearr_35492 = state_35460;
(statearr_35492[(10)] = inst_35419);

(statearr_35492[(7)] = inst_35420);

return statearr_35492;
})();
if(inst_35422){
var statearr_35493_35530 = state_35460__$1;
(statearr_35493_35530[(1)] = (12));

} else {
var statearr_35494_35531 = state_35460__$1;
(statearr_35494_35531[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (9))){
var inst_35403 = (state_35460[(8)]);
var state_35460__$1 = state_35460;
var statearr_35495_35532 = state_35460__$1;
(statearr_35495_35532[(2)] = inst_35403);

(statearr_35495_35532[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (5))){
var _ = (function (){var statearr_35496 = state_35460;
(statearr_35496[(4)] = cljs.core.rest((state_35460[(4)])));

return statearr_35496;
})();
var state_35460__$1 = state_35460;
var ex35491 = (state_35460__$1[(2)]);
var statearr_35497_35533 = state_35460__$1;
(statearr_35497_35533[(5)] = ex35491);


if((ex35491 instanceof Error)){
var statearr_35498_35534 = state_35460__$1;
(statearr_35498_35534[(1)] = (4));

(statearr_35498_35534[(5)] = null);

} else {
throw ex35491;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (14))){
var inst_35450 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35499_35535 = state_35460__$1;
(statearr_35499_35535[(2)] = inst_35450);

(statearr_35499_35535[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (26))){
var inst_35444 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35500_35536 = state_35460__$1;
(statearr_35500_35536[(2)] = inst_35444);

(statearr_35500_35536[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (16))){
var inst_35419 = (state_35460[(10)]);
var inst_35435 = (inst_35419 == null);
var state_35460__$1 = state_35460;
if(cljs.core.truth_(inst_35435)){
var statearr_35501_35537 = state_35460__$1;
(statearr_35501_35537[(1)] = (21));

} else {
var statearr_35502_35538 = state_35460__$1;
(statearr_35502_35538[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (10))){
var inst_35453 = (state_35460[(2)]);
var state_35460__$1 = state_35460;
var statearr_35503_35539 = state_35460__$1;
(statearr_35503_35539[(2)] = inst_35453);

(statearr_35503_35539[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (18))){
var inst_35419 = (state_35460[(10)]);
var state_35460__$1 = state_35460;
var statearr_35504_35540 = state_35460__$1;
(statearr_35504_35540[(2)] = inst_35419);

(statearr_35504_35540[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35461 === (8))){
var inst_35403 = (state_35460[(8)]);
var inst_35409 = (state_35460[(11)]);
var inst_35410 = (state_35460[(12)]);
var inst_35415 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_35403,inst_35409,inst_35410,false,fuel,max_fuel,opts);
var state_35460__$1 = state_35460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35460__$1,(11),inst_35415);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__17133__auto__ = null;
var fluree$db$query$analytical$state_machine__17133__auto____0 = (function (){
var statearr_35505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35505[(0)] = fluree$db$query$analytical$state_machine__17133__auto__);

(statearr_35505[(1)] = (1));

return statearr_35505;
});
var fluree$db$query$analytical$state_machine__17133__auto____1 = (function (state_35460){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35460);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35506){var ex__17136__auto__ = e35506;
var statearr_35507_35541 = state_35460;
(statearr_35507_35541[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35460[(4)]))){
var statearr_35508_35542 = state_35460;
(statearr_35508_35542[(1)] = cljs.core.first((state_35460[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35543 = state_35460;
state_35460 = G__35543;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__17133__auto__ = function(state_35460){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__17133__auto____1.call(this,state_35460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__17133__auto____0;
fluree$db$query$analytical$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__17133__auto____1;
return fluree$db$query$analytical$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35509 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35509[(6)] = c__17207__auto__);

return statearr_35509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35598){
var state_val_35599 = (state_35598[(1)]);
if((state_val_35599 === (7))){
var state_35598__$1 = state_35598;
var statearr_35600_35638 = state_35598__$1;
(statearr_35600_35638[(2)] = false);

(statearr_35600_35638[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (20))){
var inst_35576 = (state_35598[(7)]);
var inst_35588 = (state_35598[(8)]);
var inst_35590 = fluree.db.query.analytical.tuples__GT_filtered(inst_35588,inst_35576,null);
var state_35598__$1 = state_35598;
var statearr_35601_35639 = state_35598__$1;
(statearr_35601_35639[(2)] = inst_35590);

(statearr_35601_35639[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (1))){
var state_35598__$1 = state_35598;
var statearr_35602_35640 = state_35598__$1;
(statearr_35602_35640[(2)] = null);

(statearr_35602_35640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (4))){
var inst_35544 = (state_35598[(2)]);
var state_35598__$1 = state_35598;
var statearr_35603_35641 = state_35598__$1;
(statearr_35603_35641[(2)] = inst_35544);

(statearr_35603_35641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (15))){
var inst_35575 = (state_35598[(9)]);
var inst_35579 = (state_35598[(2)]);
var inst_35580 = fluree.db.util.async.throw_err(inst_35579);
var state_35598__$1 = (function (){var statearr_35604 = state_35598;
(statearr_35604[(10)] = inst_35580);

return statearr_35604;
})();
if(cljs.core.truth_(inst_35575)){
var statearr_35605_35642 = state_35598__$1;
(statearr_35605_35642[(1)] = (16));

} else {
var statearr_35606_35643 = state_35598__$1;
(statearr_35606_35643[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (21))){
var inst_35588 = (state_35598[(8)]);
var state_35598__$1 = state_35598;
var statearr_35607_35644 = state_35598__$1;
(statearr_35607_35644[(2)] = inst_35588);

(statearr_35607_35644[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (13))){
var inst_35551 = (state_35598[(11)]);
var state_35598__$1 = state_35598;
var statearr_35608_35645 = state_35598__$1;
(statearr_35608_35645[(2)] = inst_35551);

(statearr_35608_35645[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (22))){
var inst_35593 = (state_35598[(2)]);
var _ = (function (){var statearr_35609 = state_35598;
(statearr_35609[(4)] = cljs.core.rest((state_35598[(4)])));

return statearr_35609;
})();
var state_35598__$1 = state_35598;
var statearr_35610_35646 = state_35598__$1;
(statearr_35610_35646[(2)] = inst_35593);

(statearr_35610_35646[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (6))){
var inst_35551 = (state_35598[(11)]);
var inst_35556 = inst_35551.cljs$lang$protocol_mask$partition0$;
var inst_35557 = (inst_35556 & (64));
var inst_35558 = inst_35551.cljs$core$ISeq$;
var inst_35559 = (cljs.core.PROTOCOL_SENTINEL === inst_35558);
var inst_35560 = ((inst_35557) || (inst_35559));
var state_35598__$1 = state_35598;
if(cljs.core.truth_(inst_35560)){
var statearr_35611_35647 = state_35598__$1;
(statearr_35611_35647[(1)] = (9));

} else {
var statearr_35612_35648 = state_35598__$1;
(statearr_35612_35648[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (17))){
var inst_35580 = (state_35598[(10)]);
var state_35598__$1 = state_35598;
var statearr_35613_35649 = state_35598__$1;
(statearr_35613_35649[(2)] = inst_35580);

(statearr_35613_35649[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (3))){
var inst_35596 = (state_35598[(2)]);
var state_35598__$1 = state_35598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35598__$1,inst_35596);
} else {
if((state_val_35599 === (12))){
var inst_35551 = (state_35598[(11)]);
var inst_35569 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35551);
var state_35598__$1 = state_35598;
var statearr_35614_35650 = state_35598__$1;
(statearr_35614_35650[(2)] = inst_35569);

(statearr_35614_35650[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (2))){
var inst_35551 = (state_35598[(11)]);
var _ = (function (){var statearr_35615 = state_35598;
(statearr_35615[(4)] = cljs.core.cons((5),(state_35598[(4)])));

return statearr_35615;
})();
var inst_35551__$1 = q_map;
var inst_35553 = (inst_35551__$1 == null);
var inst_35554 = cljs.core.not(inst_35553);
var state_35598__$1 = (function (){var statearr_35616 = state_35598;
(statearr_35616[(11)] = inst_35551__$1);

return statearr_35616;
})();
if(inst_35554){
var statearr_35617_35651 = state_35598__$1;
(statearr_35617_35651[(1)] = (6));

} else {
var statearr_35618_35652 = state_35598__$1;
(statearr_35618_35652[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (19))){
var inst_35584 = (state_35598[(2)]);
var inst_35585 = fluree.db.util.async.throw_err(inst_35584);
var state_35598__$1 = state_35598;
var statearr_35619_35653 = state_35598__$1;
(statearr_35619_35653[(2)] = inst_35585);

(statearr_35619_35653[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (11))){
var inst_35564 = (state_35598[(2)]);
var state_35598__$1 = state_35598;
var statearr_35621_35654 = state_35598__$1;
(statearr_35621_35654[(2)] = inst_35564);

(statearr_35621_35654[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (9))){
var state_35598__$1 = state_35598;
var statearr_35622_35655 = state_35598__$1;
(statearr_35622_35655[(2)] = true);

(statearr_35622_35655[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (5))){
var _ = (function (){var statearr_35623 = state_35598;
(statearr_35623[(4)] = cljs.core.rest((state_35598[(4)])));

return statearr_35623;
})();
var state_35598__$1 = state_35598;
var ex35620 = (state_35598__$1[(2)]);
var statearr_35624_35656 = state_35598__$1;
(statearr_35624_35656[(5)] = ex35620);


if((ex35620 instanceof Error)){
var statearr_35625_35657 = state_35598__$1;
(statearr_35625_35657[(1)] = (4));

(statearr_35625_35657[(5)] = null);

} else {
throw ex35620;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (14))){
var inst_35572 = (state_35598[(2)]);
var inst_35573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35572,cljs.core.cst$kw$vars);
var inst_35574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35572,cljs.core.cst$kw$where);
var inst_35575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35572,cljs.core.cst$kw$optional);
var inst_35576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35572,cljs.core.cst$kw$filter);
var inst_35577 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35574,q_map,inst_35573,fuel,max_fuel,opts);
var state_35598__$1 = (function (){var statearr_35626 = state_35598;
(statearr_35626[(9)] = inst_35575);

(statearr_35626[(7)] = inst_35576);

return statearr_35626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35598__$1,(15),inst_35577);
} else {
if((state_val_35599 === (16))){
var inst_35580 = (state_35598[(10)]);
var inst_35575 = (state_35598[(9)]);
var inst_35582 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35575,inst_35580,fuel,max_fuel,opts);
var state_35598__$1 = state_35598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35598__$1,(19),inst_35582);
} else {
if((state_val_35599 === (10))){
var state_35598__$1 = state_35598;
var statearr_35627_35658 = state_35598__$1;
(statearr_35627_35658[(2)] = false);

(statearr_35627_35658[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (18))){
var inst_35576 = (state_35598[(7)]);
var inst_35588 = (state_35598[(2)]);
var state_35598__$1 = (function (){var statearr_35628 = state_35598;
(statearr_35628[(8)] = inst_35588);

return statearr_35628;
})();
if(cljs.core.truth_(inst_35576)){
var statearr_35629_35659 = state_35598__$1;
(statearr_35629_35659[(1)] = (20));

} else {
var statearr_35630_35660 = state_35598__$1;
(statearr_35630_35660[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35599 === (8))){
var inst_35567 = (state_35598[(2)]);
var state_35598__$1 = state_35598;
if(cljs.core.truth_(inst_35567)){
var statearr_35631_35661 = state_35598__$1;
(statearr_35631_35661[(1)] = (12));

} else {
var statearr_35632_35662 = state_35598__$1;
(statearr_35632_35662[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__17133__auto____0 = (function (){
var statearr_35633 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35633[(0)] = fluree$db$query$analytical$q_$_state_machine__17133__auto__);

(statearr_35633[(1)] = (1));

return statearr_35633;
});
var fluree$db$query$analytical$q_$_state_machine__17133__auto____1 = (function (state_35598){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35598);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35634){var ex__17136__auto__ = e35634;
var statearr_35635_35663 = state_35598;
(statearr_35635_35663[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35598[(4)]))){
var statearr_35636_35664 = state_35598;
(statearr_35636_35664[(1)] = cljs.core.first((state_35598[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35665 = state_35598;
state_35598 = G__35665;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__17133__auto__ = function(state_35598){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__17133__auto____1.call(this,state_35598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__17133__auto____0;
fluree$db$query$analytical$q_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__17133__auto____1;
return fluree$db$query$analytical$q_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35637 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35637[(6)] = c__17207__auto__);

return statearr_35637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
