// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33598_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33598_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__33602 = coll;
var vec__33603 = G__33602;
var seq__33604 = cljs.core.seq(vec__33603);
var first__33605 = cljs.core.first(seq__33604);
var seq__33604__$1 = cljs.core.next(seq__33604);
var clause = first__33605;
var r = seq__33604__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33602__$1 = G__33602;
var res__$1 = res;
while(true){
var vec__33609 = G__33602__$1;
var seq__33610 = cljs.core.seq(vec__33609);
var first__33611 = cljs.core.first(seq__33610);
var seq__33610__$1 = cljs.core.next(seq__33610);
var clause__$1 = first__33611;
var r__$1 = seq__33610__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33612 = r__$1;
var G__33613 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33602__$1 = G__33612;
res__$1 = G__33613;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__33617 = coll;
var vec__33618 = G__33617;
var seq__33619 = cljs.core.seq(vec__33618);
var first__33620 = cljs.core.first(seq__33619);
var seq__33619__$1 = cljs.core.next(seq__33619);
var clause = first__33620;
var r = seq__33619__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33617__$1 = G__33617;
var res__$1 = res;
while(true){
var vec__33624 = G__33617__$1;
var seq__33625 = cljs.core.seq(vec__33624);
var first__33626 = cljs.core.first(seq__33625);
var seq__33625__$1 = cljs.core.next(seq__33625);
var clause__$1 = first__33626;
var r__$1 = seq__33625__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33627 = r__$1;
var G__33628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__33617__$1 = G__33627;
res__$1 = G__33628;
continue;
} else {
var G__33629 = r__$1;
var G__33630 = res__$2;
G__33617__$1 = G__33629;
res__$1 = G__33630;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__33634 = coll;
var vec__33635 = G__33634;
var seq__33636 = cljs.core.seq(vec__33635);
var first__33637 = cljs.core.first(seq__33636);
var seq__33636__$1 = cljs.core.next(seq__33636);
var clause = first__33637;
var r = seq__33636__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__33634__$1 = G__33634;
var res__$1 = res;
while(true){
var vec__33641 = G__33634__$1;
var seq__33642 = cljs.core.seq(vec__33641);
var first__33643 = cljs.core.first(seq__33642);
var seq__33642__$1 = cljs.core.next(seq__33642);
var clause__$1 = first__33643;
var r__$1 = seq__33642__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__33644 = r__$1;
var G__33645 = res__$2;
G__33634__$1 = G__33644;
res__$1 = G__33645;
continue;
} else {
var G__33646 = r__$1;
var G__33647 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__33634__$1 = G__33646;
res__$1 = G__33647;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__33651 = opts;
var map__33651__$1 = (((((!((map__33651 == null))))?(((((map__33651.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33651.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33651):map__33651);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33648_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33648_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33649_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33649_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33650_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__33650_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33666){
var state_val_33667 = (state_33666[(1)]);
if((state_val_33667 === (1))){
var inst_33653 = fluree.db.util.core.url_encode(query);
var inst_33654 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33653)].join('');
var inst_33655 = ["User-Agent","Accept"];
var inst_33656 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_33657 = cljs.core.PersistentHashMap.fromArrays(inst_33655,inst_33656);
var inst_33658 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_33659 = [inst_33657,(30000),cljs.core.cst$kw$wikidata];
var inst_33660 = cljs.core.PersistentHashMap.fromArrays(inst_33658,inst_33659);
var inst_33661 = fluree.db.util.xhttp.get(inst_33654,inst_33660);
var state_33666__$1 = state_33666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33666__$1,(2),inst_33661);
} else {
if((state_val_33667 === (2))){
var inst_33663 = (state_33666[(2)]);
var inst_33664 = fluree.db.util.async.throw_err(inst_33663);
var state_33666__$1 = state_33666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33666__$1,inst_33664);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____0 = (function (){
var statearr_33668 = [null,null,null,null,null,null,null];
(statearr_33668[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__);

(statearr_33668[(1)] = (1));

return statearr_33668;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____1 = (function (state_33666){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33666);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33669){var ex__17136__auto__ = e33669;
var statearr_33670_33673 = state_33666;
(statearr_33670_33673[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33666[(4)]))){
var statearr_33671_33674 = state_33666;
(statearr_33671_33674[(1)] = cljs.core.first((state_33666[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33675 = state_33666;
state_33666 = G__33675;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__ = function(state_33666){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____1.call(this,state_33666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33672 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33672[(6)] = c__17207__auto__);

return statearr_33672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33693){
var state_val_33694 = (state_33693[(1)]);
if((state_val_33694 === (1))){
var inst_33676 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_33693__$1 = state_33693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33693__$1,(2),inst_33676);
} else {
if((state_val_33694 === (2))){
var inst_33679 = (state_33693[(7)]);
var inst_33678 = (state_33693[(2)]);
var inst_33679__$1 = fluree.db.util.async.throw_err(inst_33678);
var inst_33680 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33679__$1);
var inst_33681 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_33680);
var state_33693__$1 = (function (){var statearr_33695 = state_33693;
(statearr_33695[(7)] = inst_33679__$1);

return statearr_33695;
})();
if(inst_33681){
var statearr_33696_33705 = state_33693__$1;
(statearr_33696_33705[(1)] = (3));

} else {
var statearr_33697_33706 = state_33693__$1;
(statearr_33697_33706[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33694 === (3))){
var inst_33679 = (state_33693[(7)]);
var state_33693__$1 = state_33693;
var statearr_33698_33707 = state_33693__$1;
(statearr_33698_33707[(2)] = inst_33679);

(statearr_33698_33707[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33694 === (4))){
var inst_33679 = (state_33693[(7)]);
var inst_33684 = (function (){var body = inst_33679;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_33685 = cljs.core.second(inst_33679);
var inst_33686 = cljs.core.second(inst_33685);
var inst_33687 = cljs.core.first(inst_33686);
var inst_33688 = cljs.core.second(inst_33687);
var inst_33689 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_33684,inst_33688);
var state_33693__$1 = state_33693;
var statearr_33699_33708 = state_33693__$1;
(statearr_33699_33708[(2)] = inst_33689);

(statearr_33699_33708[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33694 === (5))){
var inst_33691 = (state_33693[(2)]);
var state_33693__$1 = state_33693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33693__$1,inst_33691);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____0 = (function (){
var statearr_33700 = [null,null,null,null,null,null,null,null];
(statearr_33700[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__);

(statearr_33700[(1)] = (1));

return statearr_33700;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____1 = (function (state_33693){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33693);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33701){var ex__17136__auto__ = e33701;
var statearr_33702_33709 = state_33693;
(statearr_33702_33709[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33693[(4)]))){
var statearr_33703_33710 = state_33693;
(statearr_33703_33710[(1)] = cljs.core.first((state_33693[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33711 = state_33693;
state_33693 = G__33711;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__ = function(state_33693){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____1.call(this,state_33693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33704 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33704[(6)] = c__17207__auto__);

return statearr_33704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33712_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33712_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33713_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33713_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33714_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__33714_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33714_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__33714_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33780){
var state_val_33781 = (state_33780[(1)]);
if((state_val_33781 === (7))){
var inst_33725 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_33780__$1 = state_33780;
var statearr_33782_33823 = state_33780__$1;
(statearr_33782_33823[(2)] = inst_33725);

(statearr_33782_33823[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (20))){
var inst_33753 = (state_33780[(7)]);
var inst_33773 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_33753,all_vars);
var state_33780__$1 = state_33780;
var statearr_33783_33824 = state_33780__$1;
(statearr_33783_33824[(2)] = inst_33773);

(statearr_33783_33824[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (1))){
var state_33780__$1 = state_33780;
var statearr_33784_33825 = state_33780__$1;
(statearr_33784_33825[(2)] = null);

(statearr_33784_33825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (24))){
var inst_33754 = (state_33780[(8)]);
var inst_33759 = (state_33780[(9)]);
var inst_33753 = (state_33780[(7)]);
var inst_33764 = (state_33780[(2)]);
var inst_33765 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_33759,(0),inst_33764);
var inst_33766 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33767 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_33753);
var inst_33768 = [inst_33754,inst_33767];
var inst_33769 = cljs.core.PersistentHashMap.fromArrays(inst_33766,inst_33768);
var inst_33770 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33765,inst_33769);
var inst_33771 = (function(){throw inst_33770})();
var state_33780__$1 = state_33780;
var statearr_33785_33826 = state_33780__$1;
(statearr_33785_33826[(2)] = inst_33771);

(statearr_33785_33826[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (4))){
var inst_33715 = (state_33780[(2)]);
var state_33780__$1 = state_33780;
var statearr_33786_33827 = state_33780__$1;
(statearr_33786_33827[(2)] = inst_33715);

(statearr_33786_33827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (15))){
var inst_33745 = (state_33780[(2)]);
var state_33780__$1 = state_33780;
var statearr_33787_33828 = state_33780__$1;
(statearr_33787_33828[(2)] = inst_33745);

(statearr_33787_33828[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (21))){
var inst_33775 = (state_33780[(2)]);
var _ = (function (){var statearr_33788 = state_33780;
(statearr_33788[(4)] = cljs.core.rest((state_33780[(4)])));

return statearr_33788;
})();
var state_33780__$1 = state_33780;
var statearr_33789_33829 = state_33780__$1;
(statearr_33789_33829[(2)] = inst_33775);

(statearr_33789_33829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (13))){
var state_33780__$1 = state_33780;
var statearr_33790_33830 = state_33780__$1;
(statearr_33790_33830[(2)] = true);

(statearr_33790_33830[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (22))){
var inst_33758 = (state_33780[(10)]);
var state_33780__$1 = state_33780;
var statearr_33791_33831 = state_33780__$1;
(statearr_33791_33831[(2)] = inst_33758);

(statearr_33791_33831[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (6))){
var state_33780__$1 = state_33780;
var statearr_33792_33832 = state_33780__$1;
(statearr_33792_33832[(2)] = null);

(statearr_33792_33832[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (17))){
var inst_33732 = (state_33780[(11)]);
var state_33780__$1 = state_33780;
var statearr_33793_33833 = state_33780__$1;
(statearr_33793_33833[(2)] = inst_33732);

(statearr_33793_33833[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (3))){
var inst_33778 = (state_33780[(2)]);
var state_33780__$1 = state_33780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33780__$1,inst_33778);
} else {
if((state_val_33781 === (12))){
var inst_33748 = (state_33780[(2)]);
var state_33780__$1 = state_33780;
if(cljs.core.truth_(inst_33748)){
var statearr_33794_33834 = state_33780__$1;
(statearr_33794_33834[(1)] = (16));

} else {
var statearr_33795_33835 = state_33780__$1;
(statearr_33795_33835[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (2))){
var _ = (function (){var statearr_33796 = state_33780;
(statearr_33796[(4)] = cljs.core.cons((5),(state_33780[(4)])));

return statearr_33796;
})();
var inst_33722 = cljs.core.empty_QMARK_(matching_vars);
var state_33780__$1 = state_33780;
if(inst_33722){
var statearr_33797_33836 = state_33780__$1;
(statearr_33797_33836[(1)] = (6));

} else {
var statearr_33798_33837 = state_33780__$1;
(statearr_33798_33837[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (23))){
var state_33780__$1 = state_33780;
var statearr_33799_33838 = state_33780__$1;
(statearr_33799_33838[(2)] = (1000));

(statearr_33799_33838[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (19))){
var inst_33758 = (state_33780[(10)]);
var inst_33753 = (state_33780[(7)]);
var inst_33755 = (state_33780[(12)]);
var inst_33758__$1 = cljs.core.count(inst_33755);
var inst_33759 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_33753);
var inst_33760 = (inst_33758__$1 < (1000));
var state_33780__$1 = (function (){var statearr_33800 = state_33780;
(statearr_33800[(10)] = inst_33758__$1);

(statearr_33800[(9)] = inst_33759);

return statearr_33800;
})();
if(cljs.core.truth_(inst_33760)){
var statearr_33801_33839 = state_33780__$1;
(statearr_33801_33839[(1)] = (22));

} else {
var statearr_33802_33840 = state_33780__$1;
(statearr_33802_33840[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (11))){
var state_33780__$1 = state_33780;
var statearr_33804_33841 = state_33780__$1;
(statearr_33804_33841[(2)] = false);

(statearr_33804_33841[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (9))){
var inst_33732 = (state_33780[(11)]);
var inst_33731 = (state_33780[(2)]);
var inst_33732__$1 = fluree.db.util.async.throw_err(inst_33731);
var inst_33734 = (inst_33732__$1 == null);
var inst_33735 = cljs.core.not(inst_33734);
var state_33780__$1 = (function (){var statearr_33805 = state_33780;
(statearr_33805[(11)] = inst_33732__$1);

return statearr_33805;
})();
if(inst_33735){
var statearr_33806_33842 = state_33780__$1;
(statearr_33806_33842[(1)] = (10));

} else {
var statearr_33807_33843 = state_33780__$1;
(statearr_33807_33843[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (5))){
var _ = (function (){var statearr_33808 = state_33780;
(statearr_33808[(4)] = cljs.core.rest((state_33780[(4)])));

return statearr_33808;
})();
var state_33780__$1 = state_33780;
var ex33803 = (state_33780__$1[(2)]);
var statearr_33809_33844 = state_33780__$1;
(statearr_33809_33844[(5)] = ex33803);


if((ex33803 instanceof Error)){
var statearr_33810_33845 = state_33780__$1;
(statearr_33810_33845[(1)] = (4));

(statearr_33810_33845[(5)] = null);

} else {
throw ex33803;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (14))){
var state_33780__$1 = state_33780;
var statearr_33811_33846 = state_33780__$1;
(statearr_33811_33846[(2)] = false);

(statearr_33811_33846[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (16))){
var inst_33732 = (state_33780[(11)]);
var inst_33750 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33732);
var state_33780__$1 = state_33780;
var statearr_33812_33847 = state_33780__$1;
(statearr_33812_33847[(2)] = inst_33750);

(statearr_33812_33847[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (10))){
var inst_33732 = (state_33780[(11)]);
var inst_33737 = inst_33732.cljs$lang$protocol_mask$partition0$;
var inst_33738 = (inst_33737 & (64));
var inst_33739 = inst_33732.cljs$core$ISeq$;
var inst_33740 = (cljs.core.PROTOCOL_SENTINEL === inst_33739);
var inst_33741 = ((inst_33738) || (inst_33740));
var state_33780__$1 = state_33780;
if(cljs.core.truth_(inst_33741)){
var statearr_33813_33848 = state_33780__$1;
(statearr_33813_33848[(1)] = (13));

} else {
var statearr_33814_33849 = state_33780__$1;
(statearr_33814_33849[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (18))){
var inst_33754 = (state_33780[(8)]);
var inst_33753 = (state_33780[(7)]);
var inst_33753__$1 = (state_33780[(2)]);
var inst_33754__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33753__$1,cljs.core.cst$kw$status);
var inst_33755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33753__$1,cljs.core.cst$kw$message);
var inst_33756 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_33754__$1);
var state_33780__$1 = (function (){var statearr_33815 = state_33780;
(statearr_33815[(8)] = inst_33754__$1);

(statearr_33815[(7)] = inst_33753__$1);

(statearr_33815[(12)] = inst_33755);

return statearr_33815;
})();
if(inst_33756){
var statearr_33816_33850 = state_33780__$1;
(statearr_33816_33850[(1)] = (19));

} else {
var statearr_33817_33851 = state_33780__$1;
(statearr_33817_33851[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33781 === (8))){
var inst_33727 = (state_33780[(2)]);
var inst_33728 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_33727,optional_clauses);
var inst_33729 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_33728);
var state_33780__$1 = state_33780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33780__$1,(9),inst_33729);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_33818 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33818[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__);

(statearr_33818[(1)] = (1));

return statearr_33818;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____1 = (function (state_33780){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33780);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33819){var ex__17136__auto__ = e33819;
var statearr_33820_33852 = state_33780;
(statearr_33820_33852[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33780[(4)]))){
var statearr_33821_33853 = state_33780;
(statearr_33821_33853[(1)] = cljs.core.first((state_33780[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33854 = state_33780;
state_33780 = G__33854;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__ = function(state_33780){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____1.call(this,state_33780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33822 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33822[(6)] = c__17207__auto__);

return statearr_33822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
