// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__36976 = null;
var G__36976__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36976__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36976__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__36976 = function(result,flake){
switch(arguments.length){
case 0:
return G__36976__0.call(this);
case 1:
return G__36976__1.call(this,result);
case 2:
return G__36976__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36976.cljs$core$IFn$_invoke$arity$0 = G__36976__0;
G__36976.cljs$core$IFn$_invoke$arity$1 = G__36976__1;
G__36976.cljs$core$IFn$_invoke$arity$2 = G__36976__2;
return G__36976;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__36977 = null;
var G__36977__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36977__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36977__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__36977 = function(result,flakes){
switch(arguments.length){
case 0:
return G__36977__0.call(this);
case 1:
return G__36977__1.call(this,result);
case 2:
return G__36977__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36977.cljs$core$IFn$_invoke$arity$0 = G__36977__0;
G__36977.cljs$core$IFn$_invoke$arity$1 = G__36977__1;
G__36977.cljs$core$IFn$_invoke$arity$2 = G__36977__2;
return G__36977;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__36979 = res;
var G__36979__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__36978_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__36978_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__36979):G__36979);
var G__36979__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__36979__$1):G__36979__$1);
var G__36979__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__36979__$2):G__36979__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__36979__$3);
} else {
return G__36979__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__36981 = arguments.length;
switch (G__36981) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_37284){
var state_val_37285 = (state_37284[(1)]);
if((state_val_37285 === (65))){
var inst_37011 = (state_37284[(7)]);
var inst_37142 = (state_37284[(8)]);
var inst_37135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37136 = cljs.core.deref(cache);
var inst_37137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37138 = flake.o;
var inst_37139 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37011);
var inst_37140 = [inst_37138,inst_37139];
var inst_37141 = (new cljs.core.PersistentVector(null,2,(5),inst_37137,inst_37140,null));
var inst_37142__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37136,inst_37141);
var state_37284__$1 = (function (){var statearr_37286 = state_37284;
(statearr_37286[(9)] = inst_37135);

(statearr_37286[(8)] = inst_37142__$1);

return statearr_37286;
})();
if(cljs.core.truth_(inst_37142__$1)){
var statearr_37287_37453 = state_37284__$1;
(statearr_37287_37453[(1)] = (68));

} else {
var statearr_37288_37454 = state_37284__$1;
(statearr_37288_37454[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (70))){
var inst_37135 = (state_37284[(9)]);
var inst_37160 = (state_37284[(2)]);
var inst_37161 = [inst_37160,offset_map];
var inst_37162 = (new cljs.core.PersistentVector(null,2,(5),inst_37135,inst_37161,null));
var state_37284__$1 = state_37284;
var statearr_37289_37455 = state_37284__$1;
(statearr_37289_37455[(2)] = inst_37162);

(statearr_37289_37455[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (62))){
var inst_37011 = (state_37284[(7)]);
var inst_37049 = (state_37284[(10)]);
var inst_37120 = (state_37284[(11)]);
var inst_37044 = (state_37284[(12)]);
var inst_37104 = (state_37284[(13)]);
var inst_37046 = (state_37284[(14)]);
var inst_37043 = (state_37284[(15)]);
var inst_37047 = (state_37284[(16)]);
var inst_37022 = (state_37284[(17)]);
var inst_37045 = (state_37284[(18)]);
var inst_37005 = (state_37284[(19)]);
var inst_37048 = (state_37284[(20)]);
var inst_37122 = (function (){var map__36988 = inst_37043;
var p = inst_37049;
var pred_spec__$1 = inst_37005;
var orderBy = inst_37047;
var nested_select_spec = inst_37104;
var multi_QMARK_ = inst_37044;
var limit = inst_37046;
var G__37106 = inst_37120;
var offset = inst_37048;
var k = inst_37022;
var pred_spec_SINGLEQUOTE_ = inst_37011;
var ref_QMARK_ = inst_37045;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_37123 = (inst_37122.cljs$core$IFn$_invoke$arity$1 ? inst_37122.cljs$core$IFn$_invoke$arity$1(inst_37120) : inst_37122.call(null,inst_37120));
var state_37284__$1 = state_37284;
var statearr_37290_37456 = state_37284__$1;
(statearr_37290_37456[(2)] = inst_37123);

(statearr_37290_37456[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (74))){
var inst_37169 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37169)){
var statearr_37291_37457 = state_37284__$1;
(statearr_37291_37457[(1)] = (75));

} else {
var statearr_37292_37458 = state_37284__$1;
(statearr_37292_37458[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (7))){
var inst_36992 = (state_37284[(21)]);
var state_37284__$1 = state_37284;
var statearr_37293_37459 = state_37284__$1;
(statearr_37293_37459[(2)] = inst_36992);

(statearr_37293_37459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (59))){
var inst_37114 = (state_37284[(22)]);
var inst_37116 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37117 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37116,inst_37114);
var state_37284__$1 = state_37284;
var statearr_37294_37460 = state_37284__$1;
(statearr_37294_37460[(2)] = inst_37117);

(statearr_37294_37460[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (86))){
var inst_37011 = (state_37284[(7)]);
var inst_37049 = (state_37284[(10)]);
var inst_37044 = (state_37284[(12)]);
var inst_37046 = (state_37284[(14)]);
var inst_37043 = (state_37284[(15)]);
var inst_37047 = (state_37284[(16)]);
var inst_37022 = (state_37284[(17)]);
var inst_37045 = (state_37284[(18)]);
var inst_37182 = (state_37284[(23)]);
var inst_37005 = (state_37284[(19)]);
var inst_37048 = (state_37284[(20)]);
var inst_37200 = (state_37284[(24)]);
var inst_37202 = (function (){var map__36988 = inst_37043;
var G__37194 = inst_37200;
var p = inst_37049;
var pred_spec__$1 = inst_37005;
var orderBy = inst_37047;
var children = inst_37182;
var multi_QMARK_ = inst_37044;
var limit = inst_37046;
var offset = inst_37048;
var k = inst_37022;
var pred_spec_SINGLEQUOTE_ = inst_37011;
var ref_QMARK_ = inst_37045;
return (function (n){
var G__37295 = db;
var G__37296 = cache;
var G__37297 = fuel;
var G__37298 = max_fuel;
var G__37299 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__37300 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__37295,G__37296,G__37297,G__37298,G__37299,G__37300) : fluree.db.query.fql.flakes__GT_res.call(null,G__37295,G__37296,G__37297,G__37298,G__37299,G__37300));
});
})();
var inst_37203 = (inst_37202.cljs$core$IFn$_invoke$arity$1 ? inst_37202.cljs$core$IFn$_invoke$arity$1(inst_37200) : inst_37202.call(null,inst_37200));
var state_37284__$1 = state_37284;
var statearr_37301_37461 = state_37284__$1;
(statearr_37301_37461[(2)] = inst_37203);

(statearr_37301_37461[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (20))){
var inst_37020 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37302_37462 = state_37284__$1;
(statearr_37302_37462[(2)] = inst_37020);

(statearr_37302_37462[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (72))){
var inst_37011 = (state_37284[(7)]);
var inst_37166 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = state_37284;
var statearr_37303_37463 = state_37284__$1;
(statearr_37303_37463[(2)] = inst_37166);

(statearr_37303_37463[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (58))){
var inst_37113 = (state_37284[(2)]);
var inst_37114 = fluree.db.util.async.throw_err(inst_37113);
var state_37284__$1 = (function (){var statearr_37304 = state_37284;
(statearr_37304[(22)] = inst_37114);

return statearr_37304;
})();
if(cljs.core.truth_(fuel)){
var statearr_37305_37464 = state_37284__$1;
(statearr_37305_37464[(1)] = (59));

} else {
var statearr_37306_37465 = state_37284__$1;
(statearr_37306_37465[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (60))){
var inst_37114 = (state_37284[(22)]);
var state_37284__$1 = state_37284;
var statearr_37307_37466 = state_37284__$1;
(statearr_37307_37466[(2)] = inst_37114);

(statearr_37307_37466[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (27))){
var inst_37011 = (state_37284[(7)]);
var inst_37040 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37011);
var state_37284__$1 = state_37284;
var statearr_37308_37467 = state_37284__$1;
(statearr_37308_37467[(2)] = inst_37040);

(statearr_37308_37467[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (1))){
var state_37284__$1 = state_37284;
var statearr_37309_37468 = state_37284__$1;
(statearr_37309_37468[(2)] = null);

(statearr_37309_37468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (69))){
var inst_37011 = (state_37284[(7)]);
var inst_37145 = flake.o;
var inst_37146 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37011);
var inst_37147 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_37145,inst_37146);
var state_37284__$1 = state_37284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37284__$1,(71),inst_37147);
} else {
if((state_val_37285 === (101))){
var inst_37244 = (state_37284[(25)]);
var inst_37245 = (state_37284[(26)]);
var inst_37022 = (state_37284[(17)]);
var inst_37264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37022,inst_37244);
var inst_37266 = [inst_37265,inst_37245];
var inst_37267 = (new cljs.core.PersistentVector(null,2,(5),inst_37264,inst_37266,null));
var state_37284__$1 = state_37284;
var statearr_37310_37469 = state_37284__$1;
(statearr_37310_37469[(2)] = inst_37267);

(statearr_37310_37469[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (24))){
var state_37284__$1 = state_37284;
var statearr_37311_37470 = state_37284__$1;
(statearr_37311_37470[(2)] = true);

(statearr_37311_37470[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (102))){
var state_37284__$1 = state_37284;
var statearr_37312_37471 = state_37284__$1;
(statearr_37312_37471[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (55))){
var inst_37011 = (state_37284[(7)]);
var inst_37133 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37133)){
var statearr_37314_37472 = state_37284__$1;
(statearr_37314_37472[(1)] = (65));

} else {
var statearr_37315_37473 = state_37284__$1;
(statearr_37315_37473[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (85))){
var inst_37200 = (state_37284[(2)]);
var state_37284__$1 = (function (){var statearr_37316 = state_37284;
(statearr_37316[(24)] = inst_37200);

return statearr_37316;
})();
var statearr_37317_37474 = state_37284__$1;
(statearr_37317_37474[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (39))){
var inst_37049 = (state_37284[(10)]);
var inst_37066 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37049,cljs.core.dec);
var state_37284__$1 = state_37284;
var statearr_37319_37475 = state_37284__$1;
(statearr_37319_37475[(2)] = inst_37066);

(statearr_37319_37475[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (88))){
var inst_37206 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37284__$1,(82),inst_37206);
} else {
if((state_val_37285 === (46))){
var inst_37089 = cljs.core.not(recur_QMARK_);
var state_37284__$1 = state_37284;
if(inst_37089){
var statearr_37320_37476 = state_37284__$1;
(statearr_37320_37476[(1)] = (48));

} else {
var statearr_37321_37477 = state_37284__$1;
(statearr_37321_37477[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (4))){
var inst_36982 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37322_37478 = state_37284__$1;
(statearr_37322_37478[(2)] = inst_36982);

(statearr_37322_37478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (77))){
var inst_37235 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37323_37479 = state_37284__$1;
(statearr_37323_37479[(2)] = inst_37235);

(statearr_37323_37479[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (106))){
var inst_37275 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37324_37480 = state_37284__$1;
(statearr_37324_37480[(2)] = inst_37275);

(statearr_37324_37480[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (95))){
var inst_37044 = (state_37284[(12)]);
var state_37284__$1 = state_37284;
var statearr_37325_37481 = state_37284__$1;
(statearr_37325_37481[(2)] = inst_37044);

(statearr_37325_37481[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (54))){
var inst_37011 = (state_37284[(7)]);
var inst_37101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37102 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_37103 = (new cljs.core.PersistentVector(null,3,(5),inst_37101,inst_37102,null));
var inst_37104 = cljs.core.select_keys(inst_37011,inst_37103);
var inst_37105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37108 = flake.o;
var inst_37109 = [inst_37108];
var inst_37110 = (new cljs.core.PersistentVector(null,1,(5),inst_37107,inst_37109,null));
var inst_37111 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37110);
var state_37284__$1 = (function (){var statearr_37326 = state_37284;
(statearr_37326[(13)] = inst_37104);

(statearr_37326[(27)] = inst_37105);

return statearr_37326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37284__$1,(58),inst_37111);
} else {
if((state_val_37285 === (92))){
var inst_37225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37226 = flake.o;
var inst_37227 = [inst_37226,offset_map];
var inst_37228 = (new cljs.core.PersistentVector(null,2,(5),inst_37225,inst_37227,null));
var state_37284__$1 = state_37284;
var statearr_37327_37482 = state_37284__$1;
(statearr_37327_37482[(2)] = inst_37228);

(statearr_37327_37482[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (104))){
var inst_37245 = (state_37284[(26)]);
var inst_37270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37271 = [acc,inst_37245];
var inst_37272 = (new cljs.core.PersistentVector(null,2,(5),inst_37270,inst_37271,null));
var state_37284__$1 = state_37284;
var statearr_37328_37483 = state_37284__$1;
(statearr_37328_37483[(2)] = inst_37272);

(statearr_37328_37483[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (15))){
var inst_37012 = (state_37284[(28)]);
var state_37284__$1 = state_37284;
var statearr_37329_37484 = state_37284__$1;
(statearr_37329_37484[(2)] = inst_37012);

(statearr_37329_37484[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (48))){
var inst_37011 = (state_37284[(7)]);
var inst_37091 = (state_37284[(29)]);
var inst_37091__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = (function (){var statearr_37330 = state_37284;
(statearr_37330[(29)] = inst_37091__$1);

return statearr_37330;
})();
if(cljs.core.truth_(inst_37091__$1)){
var statearr_37331_37485 = state_37284__$1;
(statearr_37331_37485[(1)] = (51));

} else {
var statearr_37332_37486 = state_37284__$1;
(statearr_37332_37486[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (50))){
var inst_37099 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37099)){
var statearr_37333_37487 = state_37284__$1;
(statearr_37333_37487[(1)] = (54));

} else {
var statearr_37334_37488 = state_37284__$1;
(statearr_37334_37488[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (75))){
var inst_37011 = (state_37284[(7)]);
var inst_37171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37172 = flake.o;
var inst_37173 = [inst_37172];
var inst_37174 = (new cljs.core.PersistentVector(null,1,(5),inst_37171,inst_37173,null));
var inst_37175 = [cljs.core.cst$kw$limit];
var inst_37176 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37011);
var inst_37177 = [inst_37176];
var inst_37178 = cljs.core.PersistentHashMap.fromArrays(inst_37175,inst_37177);
var inst_37179 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37174,inst_37178);
var state_37284__$1 = state_37284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37284__$1,(78),inst_37179);
} else {
if((state_val_37285 === (99))){
var inst_37244 = (state_37284[(25)]);
var inst_37261 = (inst_37244 == null);
var inst_37262 = cljs.core.not(inst_37261);
var state_37284__$1 = state_37284;
if(inst_37262){
var statearr_37335_37489 = state_37284__$1;
(statearr_37335_37489[(1)] = (101));

} else {
var statearr_37336_37490 = state_37284__$1;
(statearr_37336_37490[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (21))){
var inst_37011 = (state_37284[(7)]);
var inst_37027 = inst_37011.cljs$lang$protocol_mask$partition0$;
var inst_37028 = (inst_37027 & (64));
var inst_37029 = inst_37011.cljs$core$ISeq$;
var inst_37030 = (cljs.core.PROTOCOL_SENTINEL === inst_37029);
var inst_37031 = ((inst_37028) || (inst_37030));
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37031)){
var statearr_37337_37491 = state_37284__$1;
(statearr_37337_37491[(1)] = (24));

} else {
var statearr_37338_37492 = state_37284__$1;
(statearr_37338_37492[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (31))){
var inst_37044 = (state_37284[(12)]);
var state_37284__$1 = state_37284;
var statearr_37339_37493 = state_37284__$1;
(statearr_37339_37493[(2)] = inst_37044);

(statearr_37339_37493[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (32))){
var inst_37061 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37061)){
var statearr_37340_37494 = state_37284__$1;
(statearr_37340_37494[(1)] = (36));

} else {
var statearr_37341_37495 = state_37284__$1;
(statearr_37341_37495[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (40))){
var inst_37049 = (state_37284[(10)]);
var inst_37048 = (state_37284[(20)]);
var inst_37068 = (inst_37048 - (1));
var inst_37069 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37049,inst_37068);
var state_37284__$1 = state_37284;
var statearr_37342_37496 = state_37284__$1;
(statearr_37342_37496[(2)] = inst_37069);

(statearr_37342_37496[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (91))){
var inst_37233 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37343_37497 = state_37284__$1;
(statearr_37343_37497[(2)] = inst_37233);

(statearr_37343_37497[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (56))){
var inst_37239 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37344_37498 = state_37284__$1;
(statearr_37344_37498[(2)] = inst_37239);

(statearr_37344_37498[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (33))){
var inst_37049 = (state_37284[(10)]);
var inst_37048 = (state_37284[(20)]);
var inst_37052 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37048);
var inst_37053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37049);
var inst_37054 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37053);
var inst_37055 = ((inst_37052) && (inst_37054));
var state_37284__$1 = state_37284;
var statearr_37345_37499 = state_37284__$1;
(statearr_37345_37499[(2)] = inst_37055);

(statearr_37345_37499[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (13))){
var inst_37005 = (state_37284[(19)]);
var inst_37009 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37005,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_37284__$1 = state_37284;
var statearr_37346_37500 = state_37284__$1;
(statearr_37346_37500[(2)] = inst_37009);

(statearr_37346_37500[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (22))){
var state_37284__$1 = state_37284;
var statearr_37347_37501 = state_37284__$1;
(statearr_37347_37501[(2)] = false);

(statearr_37347_37501[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (90))){
var state_37284__$1 = state_37284;
var statearr_37348_37502 = state_37284__$1;
(statearr_37348_37502[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (36))){
var inst_37049 = (state_37284[(10)]);
var inst_37063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37064 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37049);
var state_37284__$1 = (function (){var statearr_37350 = state_37284;
(statearr_37350[(30)] = inst_37063);

return statearr_37350;
})();
if(cljs.core.truth_(inst_37064)){
var statearr_37351_37503 = state_37284__$1;
(statearr_37351_37503[(1)] = (39));

} else {
var statearr_37352_37504 = state_37284__$1;
(statearr_37352_37504[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (41))){
var inst_37063 = (state_37284[(30)]);
var inst_37071 = (state_37284[(2)]);
var inst_37072 = [null,inst_37071];
var inst_37073 = (new cljs.core.PersistentVector(null,2,(5),inst_37063,inst_37072,null));
var state_37284__$1 = state_37284;
var statearr_37353_37505 = state_37284__$1;
(statearr_37353_37505[(2)] = inst_37073);

(statearr_37353_37505[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (89))){
var inst_37216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37217 = ["_id"];
var inst_37218 = flake.o;
var inst_37219 = [inst_37218];
var inst_37220 = cljs.core.PersistentHashMap.fromArrays(inst_37217,inst_37219);
var inst_37221 = [inst_37220,offset_map];
var inst_37222 = (new cljs.core.PersistentVector(null,2,(5),inst_37216,inst_37221,null));
var state_37284__$1 = state_37284;
var statearr_37354_37506 = state_37284__$1;
(statearr_37354_37506[(2)] = inst_37222);

(statearr_37354_37506[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (100))){
var inst_37279 = (state_37284[(2)]);
var _ = (function (){var statearr_37355 = state_37284;
(statearr_37355[(4)] = cljs.core.rest((state_37284[(4)])));

return statearr_37355;
})();
var state_37284__$1 = state_37284;
var statearr_37356_37507 = state_37284__$1;
(statearr_37356_37507[(2)] = inst_37279);

(statearr_37356_37507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (43))){
var inst_37044 = (state_37284[(12)]);
var state_37284__$1 = state_37284;
var statearr_37357_37508 = state_37284__$1;
(statearr_37357_37508[(2)] = inst_37044);

(statearr_37357_37508[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (61))){
var inst_37120 = (state_37284[(2)]);
var state_37284__$1 = (function (){var statearr_37358 = state_37284;
(statearr_37358[(11)] = inst_37120);

return statearr_37358;
})();
var statearr_37359_37509 = state_37284__$1;
(statearr_37359_37509[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (29))){
var inst_37044 = (state_37284[(12)]);
var inst_37043 = (state_37284[(15)]);
var inst_37043__$1 = (state_37284[(2)]);
var inst_37044__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$limit);
var inst_37047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$orderBy);
var inst_37048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$offset);
var inst_37049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37043__$1,cljs.core.cst$kw$p);
var state_37284__$1 = (function (){var statearr_37361 = state_37284;
(statearr_37361[(10)] = inst_37049);

(statearr_37361[(12)] = inst_37044__$1);

(statearr_37361[(14)] = inst_37046);

(statearr_37361[(15)] = inst_37043__$1);

(statearr_37361[(16)] = inst_37047);

(statearr_37361[(18)] = inst_37045);

(statearr_37361[(20)] = inst_37048);

return statearr_37361;
})();
if(cljs.core.truth_(inst_37044__$1)){
var statearr_37362_37510 = state_37284__$1;
(statearr_37362_37510[(1)] = (30));

} else {
var statearr_37363_37511 = state_37284__$1;
(statearr_37363_37511[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (44))){
var inst_37083 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37083)){
var statearr_37364_37512 = state_37284__$1;
(statearr_37364_37512[(1)] = (45));

} else {
var statearr_37365_37513 = state_37284__$1;
(statearr_37365_37513[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (93))){
var state_37284__$1 = state_37284;
var statearr_37366_37514 = state_37284__$1;
(statearr_37366_37514[(2)] = null);

(statearr_37366_37514[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (6))){
var inst_36994 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36995 = (inst_36994 == null);
var state_37284__$1 = state_37284;
var statearr_37367_37515 = state_37284__$1;
(statearr_37367_37515[(2)] = inst_36995);

(statearr_37367_37515[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (28))){
var inst_37011 = (state_37284[(7)]);
var state_37284__$1 = state_37284;
var statearr_37368_37516 = state_37284__$1;
(statearr_37368_37516[(2)] = inst_37011);

(statearr_37368_37516[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (64))){
var inst_37126 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37284__$1,(57),inst_37126);
} else {
if((state_val_37285 === (103))){
var inst_37277 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37369_37517 = state_37284__$1;
(statearr_37369_37517[(2)] = inst_37277);

(statearr_37369_37517[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (51))){
var inst_37091 = (state_37284[(29)]);
var state_37284__$1 = state_37284;
var statearr_37370_37518 = state_37284__$1;
(statearr_37370_37518[(2)] = inst_37091);

(statearr_37370_37518[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (25))){
var state_37284__$1 = state_37284;
var statearr_37371_37519 = state_37284__$1;
(statearr_37371_37519[(2)] = false);

(statearr_37371_37519[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (34))){
var inst_37048 = (state_37284[(20)]);
var state_37284__$1 = state_37284;
var statearr_37372_37520 = state_37284__$1;
(statearr_37372_37520[(2)] = inst_37048);

(statearr_37372_37520[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (17))){
var inst_37011 = (state_37284[(7)]);
var inst_37022 = (state_37284[(2)]);
var inst_37024 = (inst_37011 == null);
var inst_37025 = cljs.core.not(inst_37024);
var state_37284__$1 = (function (){var statearr_37373 = state_37284;
(statearr_37373[(17)] = inst_37022);

return statearr_37373;
})();
if(inst_37025){
var statearr_37374_37521 = state_37284__$1;
(statearr_37374_37521[(1)] = (21));

} else {
var statearr_37375_37522 = state_37284__$1;
(statearr_37375_37522[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (3))){
var inst_37282 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37284__$1,inst_37282);
} else {
if((state_val_37285 === (12))){
var inst_37005 = (state_37284[(19)]);
var state_37284__$1 = state_37284;
var statearr_37376_37523 = state_37284__$1;
(statearr_37376_37523[(2)] = inst_37005);

(statearr_37376_37523[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (2))){
var inst_36992 = (state_37284[(21)]);
var _ = (function (){var statearr_37377 = state_37284;
(statearr_37377[(4)] = cljs.core.cons((5),(state_37284[(4)])));

return statearr_37377;
})();
var inst_36992__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_37284__$1 = (function (){var statearr_37378 = state_37284;
(statearr_37378[(21)] = inst_36992__$1);

return statearr_37378;
})();
if(cljs.core.truth_(inst_36992__$1)){
var statearr_37379_37524 = state_37284__$1;
(statearr_37379_37524[(1)] = (6));

} else {
var statearr_37380_37525 = state_37284__$1;
(statearr_37380_37525[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (66))){
var inst_37164 = (state_37284[(31)]);
var inst_37164__$1 = componentFollow_QMARK_;
var state_37284__$1 = (function (){var statearr_37381 = state_37284;
(statearr_37381[(31)] = inst_37164__$1);

return statearr_37381;
})();
if(cljs.core.truth_(inst_37164__$1)){
var statearr_37382_37526 = state_37284__$1;
(statearr_37382_37526[(1)] = (72));

} else {
var statearr_37383_37527 = state_37284__$1;
(statearr_37383_37527[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (23))){
var inst_37038 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37038)){
var statearr_37384_37528 = state_37284__$1;
(statearr_37384_37528[(1)] = (27));

} else {
var statearr_37385_37529 = state_37284__$1;
(statearr_37385_37529[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (47))){
var inst_37241 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37386_37530 = state_37284__$1;
(statearr_37386_37530[(2)] = inst_37241);

(statearr_37386_37530[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (35))){
var inst_37058 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37387_37531 = state_37284__$1;
(statearr_37387_37531[(2)] = inst_37058);

(statearr_37387_37531[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (82))){
var inst_37193 = (state_37284[(32)]);
var inst_37208 = (state_37284[(2)]);
var inst_37209 = fluree.db.util.async.throw_err(inst_37208);
var inst_37210 = [inst_37209,offset_map];
var inst_37211 = (new cljs.core.PersistentVector(null,2,(5),inst_37193,inst_37210,null));
var state_37284__$1 = state_37284;
var statearr_37388_37532 = state_37284__$1;
(statearr_37388_37532[(2)] = inst_37211);

(statearr_37388_37532[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (76))){
var inst_37045 = (state_37284[(18)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37045)){
var statearr_37389_37533 = state_37284__$1;
(statearr_37389_37533[(1)] = (89));

} else {
var statearr_37390_37534 = state_37284__$1;
(statearr_37390_37534[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (97))){
var inst_37251 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37251)){
var statearr_37391_37535 = state_37284__$1;
(statearr_37391_37535[(1)] = (98));

} else {
var statearr_37392_37536 = state_37284__$1;
(statearr_37392_37536[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (19))){
var inst_37011 = (state_37284[(7)]);
var inst_37018 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = state_37284;
var statearr_37393_37537 = state_37284__$1;
(statearr_37393_37537[(2)] = inst_37018);

(statearr_37393_37537[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (57))){
var inst_37105 = (state_37284[(27)]);
var inst_37128 = (state_37284[(2)]);
var inst_37129 = fluree.db.util.async.throw_err(inst_37128);
var inst_37130 = [inst_37129,offset_map];
var inst_37131 = (new cljs.core.PersistentVector(null,2,(5),inst_37105,inst_37130,null));
var state_37284__$1 = state_37284;
var statearr_37394_37538 = state_37284__$1;
(statearr_37394_37538[(2)] = inst_37131);

(statearr_37394_37538[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (68))){
var inst_37142 = (state_37284[(8)]);
var state_37284__$1 = state_37284;
var statearr_37395_37539 = state_37284__$1;
(statearr_37395_37539[(2)] = inst_37142);

(statearr_37395_37539[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (11))){
var inst_37005 = (state_37284[(19)]);
var inst_37005__$1 = (state_37284[(2)]);
var inst_37006 = cljs.core.contains_QMARK_(inst_37005__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_37284__$1 = (function (){var statearr_37397 = state_37284;
(statearr_37397[(19)] = inst_37005__$1);

return statearr_37397;
})();
if(inst_37006){
var statearr_37398_37540 = state_37284__$1;
(statearr_37398_37540[(1)] = (12));

} else {
var statearr_37399_37541 = state_37284__$1;
(statearr_37399_37541[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (9))){
var inst_37000 = flake.p;
var inst_37001 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37002 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37000,inst_37001);
var state_37284__$1 = state_37284;
var statearr_37400_37542 = state_37284__$1;
(statearr_37400_37542[(2)] = inst_37002);

(statearr_37400_37542[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (5))){
var _ = (function (){var statearr_37401 = state_37284;
(statearr_37401[(4)] = cljs.core.rest((state_37284[(4)])));

return statearr_37401;
})();
var state_37284__$1 = state_37284;
var ex37396 = (state_37284__$1[(2)]);
var statearr_37402_37543 = state_37284__$1;
(statearr_37402_37543[(5)] = ex37396);


if((ex37396 instanceof Error)){
var statearr_37403_37544 = state_37284__$1;
(statearr_37403_37544[(1)] = (4));

(statearr_37403_37544[(5)] = null);

} else {
throw ex37396;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (83))){
var inst_37182 = (state_37284[(23)]);
var inst_37196 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37197 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37196,inst_37182);
var state_37284__$1 = state_37284;
var statearr_37404_37545 = state_37284__$1;
(statearr_37404_37545[(2)] = inst_37197);

(statearr_37404_37545[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (14))){
var inst_37011 = (state_37284[(7)]);
var inst_37012 = (state_37284[(28)]);
var inst_37011__$1 = (state_37284[(2)]);
var inst_37012__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37011__$1);
var state_37284__$1 = (function (){var statearr_37405 = state_37284;
(statearr_37405[(7)] = inst_37011__$1);

(statearr_37405[(28)] = inst_37012__$1);

return statearr_37405;
})();
if(cljs.core.truth_(inst_37012__$1)){
var statearr_37406_37546 = state_37284__$1;
(statearr_37406_37546[(1)] = (15));

} else {
var statearr_37407_37547 = state_37284__$1;
(statearr_37407_37547[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (45))){
var inst_37085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37086 = [null,offset_map];
var inst_37087 = (new cljs.core.PersistentVector(null,2,(5),inst_37085,inst_37086,null));
var state_37284__$1 = state_37284;
var statearr_37408_37548 = state_37284__$1;
(statearr_37408_37548[(2)] = inst_37087);

(statearr_37408_37548[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (53))){
var inst_37096 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37409_37549 = state_37284__$1;
(statearr_37409_37549[(2)] = inst_37096);

(statearr_37409_37549[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (78))){
var inst_37182 = (state_37284[(23)]);
var inst_37181 = (state_37284[(2)]);
var inst_37182__$1 = fluree.db.util.async.throw_err(inst_37181);
var inst_37183 = cljs.core.empty_QMARK_(inst_37182__$1);
var state_37284__$1 = (function (){var statearr_37410 = state_37284;
(statearr_37410[(23)] = inst_37182__$1);

return statearr_37410;
})();
if(inst_37183){
var statearr_37411_37550 = state_37284__$1;
(statearr_37411_37550[(1)] = (79));

} else {
var statearr_37412_37551 = state_37284__$1;
(statearr_37412_37551[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (26))){
var inst_37035 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37413_37552 = state_37284__$1;
(statearr_37413_37552[(2)] = inst_37035);

(statearr_37413_37552[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (16))){
var inst_37011 = (state_37284[(7)]);
var inst_37015 = (state_37284[(33)]);
var inst_37015__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = (function (){var statearr_37414 = state_37284;
(statearr_37414[(33)] = inst_37015__$1);

return statearr_37414;
})();
if(cljs.core.truth_(inst_37015__$1)){
var statearr_37415_37553 = state_37284__$1;
(statearr_37415_37553[(1)] = (18));

} else {
var statearr_37416_37554 = state_37284__$1;
(statearr_37416_37554[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (81))){
var inst_37213 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37417_37555 = state_37284__$1;
(statearr_37417_37555[(2)] = inst_37213);

(statearr_37417_37555[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (79))){
var inst_37185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37186 = ["_id"];
var inst_37187 = flake.o;
var inst_37188 = [inst_37187];
var inst_37189 = cljs.core.PersistentHashMap.fromArrays(inst_37186,inst_37188);
var inst_37190 = [inst_37189,offset_map];
var inst_37191 = (new cljs.core.PersistentVector(null,2,(5),inst_37185,inst_37190,null));
var state_37284__$1 = state_37284;
var statearr_37418_37556 = state_37284__$1;
(statearr_37418_37556[(2)] = inst_37191);

(statearr_37418_37556[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (38))){
var inst_37244 = (state_37284[(25)]);
var inst_37243 = (state_37284[(2)]);
var inst_37244__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37243,(0),null);
var inst_37245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37243,(1),null);
var inst_37246 = (inst_37244__$1 == null);
var inst_37247 = cljs.core.not(inst_37246);
var state_37284__$1 = (function (){var statearr_37419 = state_37284;
(statearr_37419[(25)] = inst_37244__$1);

(statearr_37419[(26)] = inst_37245);

return statearr_37419;
})();
if(inst_37247){
var statearr_37420_37557 = state_37284__$1;
(statearr_37420_37557[(1)] = (95));

} else {
var statearr_37421_37558 = state_37284__$1;
(statearr_37421_37558[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (98))){
var inst_37244 = (state_37284[(25)]);
var inst_37245 = (state_37284[(26)]);
var inst_37022 = (state_37284[(17)]);
var inst_37253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37254 = cljs.core.PersistentVector.EMPTY;
var inst_37255 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_37022,inst_37254);
var inst_37256 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37255,inst_37244);
var inst_37257 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37022,inst_37256);
var inst_37258 = [inst_37257,inst_37245];
var inst_37259 = (new cljs.core.PersistentVector(null,2,(5),inst_37253,inst_37258,null));
var state_37284__$1 = state_37284;
var statearr_37422_37559 = state_37284__$1;
(statearr_37422_37559[(2)] = inst_37259);

(statearr_37422_37559[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (87))){
var inst_37200 = (state_37284[(24)]);
var state_37284__$1 = state_37284;
var statearr_37423_37560 = state_37284__$1;
(statearr_37423_37560[(2)] = inst_37200);

(statearr_37423_37560[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (30))){
var inst_37048 = (state_37284[(20)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37048)){
var statearr_37424_37561 = state_37284__$1;
(statearr_37424_37561[(1)] = (33));

} else {
var statearr_37425_37562 = state_37284__$1;
(statearr_37425_37562[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (73))){
var inst_37164 = (state_37284[(31)]);
var state_37284__$1 = state_37284;
var statearr_37426_37563 = state_37284__$1;
(statearr_37426_37563[(2)] = inst_37164);

(statearr_37426_37563[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (96))){
var state_37284__$1 = state_37284;
var statearr_37427_37564 = state_37284__$1;
(statearr_37427_37564[(2)] = false);

(statearr_37427_37564[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (10))){
var state_37284__$1 = state_37284;
var statearr_37428_37565 = state_37284__$1;
(statearr_37428_37565[(2)] = pred_spec);

(statearr_37428_37565[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (18))){
var inst_37015 = (state_37284[(33)]);
var state_37284__$1 = state_37284;
var statearr_37429_37566 = state_37284__$1;
(statearr_37429_37566[(2)] = inst_37015);

(statearr_37429_37566[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (105))){
var state_37284__$1 = state_37284;
var statearr_37430_37567 = state_37284__$1;
(statearr_37430_37567[(2)] = null);

(statearr_37430_37567[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (52))){
var inst_37011 = (state_37284[(7)]);
var inst_37094 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37011);
var state_37284__$1 = state_37284;
var statearr_37431_37568 = state_37284__$1;
(statearr_37431_37568[(2)] = inst_37094);

(statearr_37431_37568[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (67))){
var inst_37237 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37432_37569 = state_37284__$1;
(statearr_37432_37569[(2)] = inst_37237);

(statearr_37432_37569[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (71))){
var inst_37011 = (state_37284[(7)]);
var inst_37149 = (state_37284[(2)]);
var inst_37150 = fluree.db.util.async.throw_err(inst_37149);
var inst_37151 = cljs.core._deref(cache);
var inst_37152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37153 = flake.o;
var inst_37154 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37011);
var inst_37155 = [inst_37153,inst_37154];
var inst_37156 = (new cljs.core.PersistentVector(null,2,(5),inst_37152,inst_37155,null));
var inst_37157 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37151,inst_37156,inst_37150);
var inst_37158 = cljs.core._vreset_BANG_(cache,inst_37157);
var state_37284__$1 = (function (){var statearr_37433 = state_37284;
(statearr_37433[(34)] = inst_37158);

return statearr_37433;
})();
var statearr_37434_37570 = state_37284__$1;
(statearr_37434_37570[(2)] = inst_37150);

(statearr_37434_37570[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (42))){
var inst_37046 = (state_37284[(14)]);
var inst_37047 = (state_37284[(16)]);
var inst_37022 = (state_37284[(17)]);
var inst_37076 = cljs.core.not(inst_37047);
var inst_37077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37022);
var inst_37078 = cljs.core.count(inst_37077);
var inst_37079 = (inst_37078 >= inst_37046);
var inst_37080 = ((inst_37076) && (inst_37079));
var state_37284__$1 = state_37284;
var statearr_37435_37571 = state_37284__$1;
(statearr_37435_37571[(2)] = inst_37080);

(statearr_37435_37571[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (80))){
var inst_37193 = cljs.core.PersistentVector.EMPTY_NODE;
var state_37284__$1 = (function (){var statearr_37436 = state_37284;
(statearr_37436[(32)] = inst_37193);

return statearr_37436;
})();
if(cljs.core.truth_(fuel)){
var statearr_37437_37572 = state_37284__$1;
(statearr_37437_37572[(1)] = (83));

} else {
var statearr_37438_37573 = state_37284__$1;
(statearr_37438_37573[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (37))){
var inst_37044 = (state_37284[(12)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_37044)){
var statearr_37439_37574 = state_37284__$1;
(statearr_37439_37574[(1)] = (42));

} else {
var statearr_37440_37575 = state_37284__$1;
(statearr_37440_37575[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (63))){
var inst_37120 = (state_37284[(11)]);
var state_37284__$1 = state_37284;
var statearr_37441_37576 = state_37284__$1;
(statearr_37441_37576[(2)] = inst_37120);

(statearr_37441_37576[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (94))){
var inst_37231 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
var statearr_37442_37577 = state_37284__$1;
(statearr_37442_37577[(2)] = inst_37231);

(statearr_37442_37577[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (8))){
var inst_36998 = (state_37284[(2)]);
var state_37284__$1 = state_37284;
if(cljs.core.truth_(inst_36998)){
var statearr_37443_37578 = state_37284__$1;
(statearr_37443_37578[(1)] = (9));

} else {
var statearr_37444_37579 = state_37284__$1;
(statearr_37444_37579[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (49))){
var state_37284__$1 = state_37284;
var statearr_37445_37580 = state_37284__$1;
(statearr_37445_37580[(2)] = false);

(statearr_37445_37580[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37285 === (84))){
var inst_37182 = (state_37284[(23)]);
var state_37284__$1 = state_37284;
var statearr_37446_37581 = state_37284__$1;
(statearr_37446_37581[(2)] = inst_37182);

(statearr_37446_37581[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17133__auto__ = null;
var fluree$db$query$fql$state_machine__17133__auto____0 = (function (){
var statearr_37447 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37447[(0)] = fluree$db$query$fql$state_machine__17133__auto__);

(statearr_37447[(1)] = (1));

return statearr_37447;
});
var fluree$db$query$fql$state_machine__17133__auto____1 = (function (state_37284){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_37284);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e37448){var ex__17136__auto__ = e37448;
var statearr_37449_37582 = state_37284;
(statearr_37449_37582[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_37284[(4)]))){
var statearr_37450_37583 = state_37284;
(statearr_37450_37583[(1)] = cljs.core.first((state_37284[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__37584 = state_37284;
state_37284 = G__37584;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17133__auto__ = function(state_37284){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17133__auto____1.call(this,state_37284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17133__auto____0;
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17133__auto____1;
return fluree$db$query$fql$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_37451 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_37451[(6)] = c__17207__auto__);

return statearr_37451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_37764){
var state_val_37765 = (state_37764[(1)]);
if((state_val_37765 === (7))){
var inst_37759 = (state_37764[(2)]);
var _ = (function (){var statearr_37766 = state_37764;
(statearr_37766[(4)] = cljs.core.rest((state_37764[(4)])));

return statearr_37766;
})();
var state_37764__$1 = state_37764;
var statearr_37767_37862 = state_37764__$1;
(statearr_37767_37862[(2)] = inst_37759);

(statearr_37767_37862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (59))){
var inst_37645 = (state_37764[(7)]);
var state_37764__$1 = state_37764;
var statearr_37768_37863 = state_37764__$1;
(statearr_37768_37863[(2)] = inst_37645);

(statearr_37768_37863[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (20))){
var inst_37654 = (state_37764[(8)]);
var inst_37651 = (state_37764[(2)]);
var inst_37652 = fluree.db.util.async.throw_err(inst_37651);
var inst_37653 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_37652);
var inst_37654__$1 = cljs.core.not_empty(inst_37653);
var state_37764__$1 = (function (){var statearr_37769 = state_37764;
(statearr_37769[(8)] = inst_37654__$1);

return statearr_37769;
})();
if(cljs.core.truth_(inst_37654__$1)){
var statearr_37770_37864 = state_37764__$1;
(statearr_37770_37864[(1)] = (21));

} else {
var statearr_37771_37865 = state_37764__$1;
(statearr_37771_37865[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (58))){
var inst_37644 = (state_37764[(9)]);
var state_37764__$1 = state_37764;
var statearr_37772_37866 = state_37764__$1;
(statearr_37772_37866[(2)] = inst_37644);

(statearr_37772_37866[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (60))){
var inst_37751 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37773_37867 = state_37764__$1;
(statearr_37773_37867[(2)] = inst_37751);

(statearr_37773_37867[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (27))){
var inst_37684 = (state_37764[(10)]);
var inst_37676 = (state_37764[(11)]);
var inst_37686 = (state_37764[(12)]);
var inst_37683 = cljs.core.seq(inst_37676);
var inst_37684__$1 = cljs.core.first(inst_37683);
var inst_37685 = cljs.core.next(inst_37683);
var inst_37686__$1 = cljs.core.not(inst_37684__$1);
var state_37764__$1 = (function (){var statearr_37774 = state_37764;
(statearr_37774[(10)] = inst_37684__$1);

(statearr_37774[(13)] = inst_37685);

(statearr_37774[(12)] = inst_37686__$1);

return statearr_37774;
})();
if(inst_37686__$1){
var statearr_37775_37868 = state_37764__$1;
(statearr_37775_37868[(1)] = (29));

} else {
var statearr_37776_37869 = state_37764__$1;
(statearr_37776_37869[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (1))){
var state_37764__$1 = state_37764;
var statearr_37777_37870 = state_37764__$1;
(statearr_37777_37870[(2)] = null);

(statearr_37777_37870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (24))){
var inst_37654 = (state_37764[(8)]);
var inst_37660 = cljs.core.count(inst_37654);
var inst_37661 = fluree.db.query.fql.add_fuel(fuel,inst_37660,max_fuel);
var state_37764__$1 = state_37764;
var statearr_37778_37871 = state_37764__$1;
(statearr_37778_37871[(2)] = inst_37661);

(statearr_37778_37871[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (55))){
var inst_37643 = (state_37764[(14)]);
var state_37764__$1 = state_37764;
var statearr_37779_37872 = state_37764__$1;
(statearr_37779_37872[(2)] = inst_37643);

(statearr_37779_37872[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (39))){
var inst_37641 = (state_37764[(15)]);
var state_37764__$1 = state_37764;
var statearr_37780_37873 = state_37764__$1;
(statearr_37780_37873[(2)] = inst_37641);

(statearr_37780_37873[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (46))){
var inst_37739 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37781_37874 = state_37764__$1;
(statearr_37781_37874[(2)] = inst_37739);

(statearr_37781_37874[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (4))){
var inst_37585 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37782_37875 = state_37764__$1;
(statearr_37782_37875[(2)] = inst_37585);

(statearr_37782_37875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (54))){
var inst_37678 = (state_37764[(16)]);
var inst_37730 = (state_37764[(2)]);
var inst_37731 = fluree.db.util.async.throw_err(inst_37730);
var inst_37732 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37678,inst_37731);
var state_37764__$1 = state_37764;
var statearr_37783_37876 = state_37764__$1;
(statearr_37783_37876[(2)] = inst_37732);

(statearr_37783_37876[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (15))){
var state_37764__$1 = state_37764;
var statearr_37784_37877 = state_37764__$1;
(statearr_37784_37877[(2)] = false);

(statearr_37784_37877[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (48))){
var inst_37678 = (state_37764[(16)]);
var state_37764__$1 = state_37764;
var statearr_37785_37878 = state_37764__$1;
(statearr_37785_37878[(2)] = inst_37678);

(statearr_37785_37878[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (50))){
var inst_37685 = (state_37764[(13)]);
var inst_37677 = (state_37764[(17)]);
var inst_37734 = (state_37764[(2)]);
var inst_37735 = (inst_37677 + (1));
var inst_37676 = inst_37685;
var inst_37677__$1 = inst_37735;
var inst_37678 = inst_37734;
var state_37764__$1 = (function (){var statearr_37786 = state_37764;
(statearr_37786[(16)] = inst_37678);

(statearr_37786[(11)] = inst_37676);

(statearr_37786[(17)] = inst_37677__$1);

return statearr_37786;
})();
var statearr_37787_37879 = state_37764__$1;
(statearr_37787_37879[(2)] = null);

(statearr_37787_37879[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (21))){
var state_37764__$1 = state_37764;
var statearr_37788_37880 = state_37764__$1;
(statearr_37788_37880[(2)] = fuel);

(statearr_37788_37880[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (31))){
var inst_37695 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37695)){
var statearr_37789_37881 = state_37764__$1;
(statearr_37789_37881[(1)] = (35));

} else {
var statearr_37790_37882 = state_37764__$1;
(statearr_37790_37882[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (32))){
var inst_37642 = (state_37764[(18)]);
var inst_37677 = (state_37764[(17)]);
var inst_37690 = (inst_37677 >= inst_37642);
var state_37764__$1 = state_37764;
var statearr_37791_37883 = state_37764__$1;
(statearr_37791_37883[(2)] = inst_37690);

(statearr_37791_37883[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (40))){
var inst_37702 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37702)){
var statearr_37792_37884 = state_37764__$1;
(statearr_37792_37884[(1)] = (41));

} else {
var statearr_37793_37885 = state_37764__$1;
(statearr_37793_37885[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (56))){
var inst_37644 = (state_37764[(9)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37644)){
var statearr_37794_37886 = state_37764__$1;
(statearr_37794_37886[(1)] = (58));

} else {
var statearr_37795_37887 = state_37764__$1;
(statearr_37795_37887[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (33))){
var inst_37642 = (state_37764[(18)]);
var state_37764__$1 = state_37764;
var statearr_37796_37888 = state_37764__$1;
(statearr_37796_37888[(2)] = inst_37642);

(statearr_37796_37888[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (13))){
var inst_37635 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37635)){
var statearr_37797_37889 = state_37764__$1;
(statearr_37797_37889[(1)] = (17));

} else {
var statearr_37798_37890 = state_37764__$1;
(statearr_37798_37890[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (22))){
var inst_37654 = (state_37764[(8)]);
var state_37764__$1 = state_37764;
var statearr_37800_37891 = state_37764__$1;
(statearr_37800_37891[(2)] = inst_37654);

(statearr_37800_37891[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (36))){
var inst_37641 = (state_37764[(15)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37641)){
var statearr_37801_37892 = state_37764__$1;
(statearr_37801_37892[(1)] = (38));

} else {
var statearr_37802_37893 = state_37764__$1;
(statearr_37802_37893[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (41))){
var inst_37685 = (state_37764[(13)]);
var inst_37678 = (state_37764[(16)]);
var inst_37677 = (state_37764[(17)]);
var inst_37704 = (inst_37677 + (1));
var tmp37799 = inst_37678;
var inst_37676 = inst_37685;
var inst_37677__$1 = inst_37704;
var inst_37678__$1 = tmp37799;
var state_37764__$1 = (function (){var statearr_37803 = state_37764;
(statearr_37803[(16)] = inst_37678__$1);

(statearr_37803[(11)] = inst_37676);

(statearr_37803[(17)] = inst_37677__$1);

return statearr_37803;
})();
var statearr_37804_37894 = state_37764__$1;
(statearr_37804_37894[(2)] = null);

(statearr_37804_37894[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (43))){
var inst_37741 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37805_37895 = state_37764__$1;
(statearr_37805_37895[(2)] = inst_37741);

(statearr_37805_37895[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (29))){
var inst_37686 = (state_37764[(12)]);
var state_37764__$1 = state_37764;
var statearr_37806_37896 = state_37764__$1;
(statearr_37806_37896[(2)] = inst_37686);

(statearr_37806_37896[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (44))){
var inst_37684 = (state_37764[(10)]);
var inst_37708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37709 = [inst_37684];
var inst_37710 = (new cljs.core.PersistentVector(null,1,(5),inst_37708,inst_37709,null));
var inst_37711 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37710);
var state_37764__$1 = state_37764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37764__$1,(47),inst_37711);
} else {
if((state_val_37765 === (6))){
var inst_37602 = (state_37764[(19)]);
var inst_37609 = (state_37764[(20)]);
var inst_37608 = cljs.core.seq(inst_37602);
var inst_37609__$1 = cljs.core.first(inst_37608);
var inst_37610 = cljs.core.next(inst_37608);
var inst_37611 = cljs.core.not(inst_37609__$1);
var state_37764__$1 = (function (){var statearr_37807 = state_37764;
(statearr_37807[(21)] = inst_37610);

(statearr_37807[(20)] = inst_37609__$1);

return statearr_37807;
})();
if(inst_37611){
var statearr_37808_37897 = state_37764__$1;
(statearr_37808_37897[(1)] = (8));

} else {
var statearr_37809_37898 = state_37764__$1;
(statearr_37809_37898[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (28))){
var inst_37643 = (state_37764[(14)]);
var inst_37745 = (state_37764[(2)]);
var state_37764__$1 = (function (){var statearr_37810 = state_37764;
(statearr_37810[(22)] = inst_37745);

return statearr_37810;
})();
if(cljs.core.truth_(inst_37643)){
var statearr_37811_37899 = state_37764__$1;
(statearr_37811_37899[(1)] = (55));

} else {
var statearr_37812_37900 = state_37764__$1;
(statearr_37812_37900[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (51))){
var inst_37714 = (state_37764[(23)]);
var inst_37723 = cljs.core.count(inst_37714);
var inst_37724 = fluree.db.query.fql.add_fuel(fuel,inst_37723,max_fuel);
var state_37764__$1 = state_37764;
var statearr_37813_37901 = state_37764__$1;
(statearr_37813_37901[(2)] = inst_37724);

(statearr_37813_37901[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (25))){
var state_37764__$1 = state_37764;
var statearr_37814_37902 = state_37764__$1;
(statearr_37814_37902[(2)] = null);

(statearr_37814_37902[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (34))){
var inst_37693 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37815_37903 = state_37764__$1;
(statearr_37815_37903[(2)] = inst_37693);

(statearr_37815_37903[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (17))){
var inst_37619 = (state_37764[(24)]);
var inst_37637 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37619);
var state_37764__$1 = state_37764;
var statearr_37816_37904 = state_37764__$1;
(statearr_37816_37904[(2)] = inst_37637);

(statearr_37816_37904[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (3))){
var inst_37762 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37764__$1,inst_37762);
} else {
if((state_val_37765 === (12))){
var state_37764__$1 = state_37764;
var statearr_37817_37905 = state_37764__$1;
(statearr_37817_37905[(2)] = false);

(statearr_37817_37905[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (2))){
var _ = (function (){var statearr_37818 = state_37764;
(statearr_37818[(4)] = cljs.core.cons((5),(state_37764[(4)])));

return statearr_37818;
})();
var inst_37598 = reverse_refs_specs;
var inst_37599 = cljs.core.seq(inst_37598);
var inst_37600 = cljs.core.first(inst_37599);
var inst_37601 = cljs.core.next(inst_37599);
var inst_37602 = inst_37598;
var inst_37603 = null;
var state_37764__$1 = (function (){var statearr_37819 = state_37764;
(statearr_37819[(25)] = inst_37603);

(statearr_37819[(19)] = inst_37602);

(statearr_37819[(26)] = inst_37601);

(statearr_37819[(27)] = inst_37600);

return statearr_37819;
})();
var statearr_37820_37906 = state_37764__$1;
(statearr_37820_37906[(2)] = null);

(statearr_37820_37906[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (23))){
var inst_37658 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37658)){
var statearr_37821_37907 = state_37764__$1;
(statearr_37821_37907[(1)] = (24));

} else {
var statearr_37822_37908 = state_37764__$1;
(statearr_37822_37908[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (47))){
var inst_37714 = (state_37764[(23)]);
var inst_37619 = (state_37764[(24)]);
var inst_37713 = (state_37764[(2)]);
var inst_37714__$1 = fluree.db.util.async.throw_err(inst_37713);
var inst_37715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37716 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_37717 = (new cljs.core.PersistentVector(null,4,(5),inst_37715,inst_37716,null));
var inst_37718 = cljs.core.select_keys(inst_37619,inst_37717);
var inst_37719 = cljs.core.empty_QMARK_(inst_37714__$1);
var state_37764__$1 = (function (){var statearr_37823 = state_37764;
(statearr_37823[(23)] = inst_37714__$1);

(statearr_37823[(28)] = inst_37718);

return statearr_37823;
})();
if(inst_37719){
var statearr_37824_37909 = state_37764__$1;
(statearr_37824_37909[(1)] = (48));

} else {
var statearr_37825_37910 = state_37764__$1;
(statearr_37825_37910[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (35))){
var inst_37678 = (state_37764[(16)]);
var state_37764__$1 = state_37764;
var statearr_37826_37911 = state_37764__$1;
(statearr_37826_37911[(2)] = inst_37678);

(statearr_37826_37911[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (19))){
var inst_37618 = (state_37764[(29)]);
var inst_37640 = (state_37764[(2)]);
var inst_37641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37640,cljs.core.cst$kw$offset);
var inst_37642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37640,cljs.core.cst$kw$limit);
var inst_37643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37640,cljs.core.cst$kw$as);
var inst_37644 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37640,cljs.core.cst$kw$name);
var inst_37645 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37640,cljs.core.cst$kw$p);
var inst_37646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37647 = [subject_id,inst_37618];
var inst_37648 = (new cljs.core.PersistentVector(null,2,(5),inst_37646,inst_37647,null));
var inst_37649 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_37648);
var state_37764__$1 = (function (){var statearr_37827 = state_37764;
(statearr_37827[(18)] = inst_37642);

(statearr_37827[(14)] = inst_37643);

(statearr_37827[(7)] = inst_37645);

(statearr_37827[(15)] = inst_37641);

(statearr_37827[(9)] = inst_37644);

return statearr_37827;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37764__$1,(20),inst_37649);
} else {
if((state_val_37765 === (57))){
var inst_37610 = (state_37764[(21)]);
var inst_37603 = (state_37764[(25)]);
var inst_37745 = (state_37764[(22)]);
var inst_37753 = (state_37764[(2)]);
var inst_37754 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37603,inst_37753,inst_37745);
var inst_37602 = inst_37610;
var inst_37603__$1 = inst_37754;
var state_37764__$1 = (function (){var statearr_37828 = state_37764;
(statearr_37828[(25)] = inst_37603__$1);

(statearr_37828[(19)] = inst_37602);

return statearr_37828;
})();
var statearr_37829_37912 = state_37764__$1;
(statearr_37829_37912[(2)] = null);

(statearr_37829_37912[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (11))){
var inst_37619 = (state_37764[(24)]);
var inst_37624 = inst_37619.cljs$lang$protocol_mask$partition0$;
var inst_37625 = (inst_37624 & (64));
var inst_37626 = inst_37619.cljs$core$ISeq$;
var inst_37627 = (cljs.core.PROTOCOL_SENTINEL === inst_37626);
var inst_37628 = ((inst_37625) || (inst_37627));
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37628)){
var statearr_37831_37913 = state_37764__$1;
(statearr_37831_37913[(1)] = (14));

} else {
var statearr_37832_37914 = state_37764__$1;
(statearr_37832_37914[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (9))){
var inst_37619 = (state_37764[(24)]);
var inst_37609 = (state_37764[(20)]);
var inst_37618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37609,(0),null);
var inst_37619__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37609,(1),null);
var inst_37621 = (inst_37619__$1 == null);
var inst_37622 = cljs.core.not(inst_37621);
var state_37764__$1 = (function (){var statearr_37833 = state_37764;
(statearr_37833[(29)] = inst_37618);

(statearr_37833[(24)] = inst_37619__$1);

return statearr_37833;
})();
if(inst_37622){
var statearr_37834_37915 = state_37764__$1;
(statearr_37834_37915[(1)] = (11));

} else {
var statearr_37835_37916 = state_37764__$1;
(statearr_37835_37916[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (5))){
var _ = (function (){var statearr_37836 = state_37764;
(statearr_37836[(4)] = cljs.core.rest((state_37764[(4)])));

return statearr_37836;
})();
var state_37764__$1 = state_37764;
var ex37830 = (state_37764__$1[(2)]);
var statearr_37837_37917 = state_37764__$1;
(statearr_37837_37917[(5)] = ex37830);


if((ex37830 instanceof Error)){
var statearr_37838_37918 = state_37764__$1;
(statearr_37838_37918[(1)] = (4));

(statearr_37838_37918[(5)] = null);

} else {
throw ex37830;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (14))){
var state_37764__$1 = state_37764;
var statearr_37839_37919 = state_37764__$1;
(statearr_37839_37919[(2)] = true);

(statearr_37839_37919[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (45))){
var state_37764__$1 = state_37764;
var statearr_37840_37920 = state_37764__$1;
(statearr_37840_37920[(2)] = null);

(statearr_37840_37920[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (53))){
var inst_37714 = (state_37764[(23)]);
var inst_37718 = (state_37764[(28)]);
var inst_37727 = (state_37764[(2)]);
var inst_37728 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37718,inst_37714) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37718,inst_37714));
var state_37764__$1 = (function (){var statearr_37841 = state_37764;
(statearr_37841[(30)] = inst_37727);

return statearr_37841;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37764__$1,(54),inst_37728);
} else {
if((state_val_37765 === (26))){
var inst_37654 = (state_37764[(8)]);
var inst_37664 = (state_37764[(2)]);
var inst_37672 = cljs.core.seq(inst_37654);
var inst_37673 = cljs.core.first(inst_37672);
var inst_37674 = cljs.core.next(inst_37672);
var inst_37675 = cljs.core.PersistentVector.EMPTY;
var inst_37676 = inst_37654;
var inst_37677 = (0);
var inst_37678 = inst_37675;
var state_37764__$1 = (function (){var statearr_37842 = state_37764;
(statearr_37842[(31)] = inst_37664);

(statearr_37842[(16)] = inst_37678);

(statearr_37842[(11)] = inst_37676);

(statearr_37842[(32)] = inst_37673);

(statearr_37842[(17)] = inst_37677);

(statearr_37842[(33)] = inst_37674);

return statearr_37842;
})();
var statearr_37843_37921 = state_37764__$1;
(statearr_37843_37921[(2)] = null);

(statearr_37843_37921[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (16))){
var inst_37632 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37844_37922 = state_37764__$1;
(statearr_37844_37922[(2)] = inst_37632);

(statearr_37844_37922[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (38))){
var inst_37641 = (state_37764[(15)]);
var inst_37677 = (state_37764[(17)]);
var inst_37699 = (inst_37677 < inst_37641);
var state_37764__$1 = state_37764;
var statearr_37845_37923 = state_37764__$1;
(statearr_37845_37923[(2)] = inst_37699);

(statearr_37845_37923[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (30))){
var inst_37642 = (state_37764[(18)]);
var state_37764__$1 = state_37764;
if(cljs.core.truth_(inst_37642)){
var statearr_37846_37924 = state_37764__$1;
(statearr_37846_37924[(1)] = (32));

} else {
var statearr_37847_37925 = state_37764__$1;
(statearr_37847_37925[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (10))){
var inst_37757 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37848_37926 = state_37764__$1;
(statearr_37848_37926[(2)] = inst_37757);

(statearr_37848_37926[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (18))){
var inst_37619 = (state_37764[(24)]);
var state_37764__$1 = state_37764;
var statearr_37849_37927 = state_37764__$1;
(statearr_37849_37927[(2)] = inst_37619);

(statearr_37849_37927[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (52))){
var state_37764__$1 = state_37764;
var statearr_37850_37928 = state_37764__$1;
(statearr_37850_37928[(2)] = null);

(statearr_37850_37928[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (42))){
var state_37764__$1 = state_37764;
var statearr_37851_37929 = state_37764__$1;
(statearr_37851_37929[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (37))){
var inst_37743 = (state_37764[(2)]);
var state_37764__$1 = state_37764;
var statearr_37853_37930 = state_37764__$1;
(statearr_37853_37930[(2)] = inst_37743);

(statearr_37853_37930[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (8))){
var inst_37603 = (state_37764[(25)]);
var state_37764__$1 = state_37764;
var statearr_37854_37931 = state_37764__$1;
(statearr_37854_37931[(2)] = inst_37603);

(statearr_37854_37931[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37765 === (49))){
var state_37764__$1 = state_37764;
if(cljs.core.truth_(fuel)){
var statearr_37855_37932 = state_37764__$1;
(statearr_37855_37932[(1)] = (51));

} else {
var statearr_37856_37933 = state_37764__$1;
(statearr_37856_37933[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____0 = (function (){
var statearr_37857 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37857[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__);

(statearr_37857[(1)] = (1));

return statearr_37857;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____1 = (function (state_37764){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_37764);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e37858){var ex__17136__auto__ = e37858;
var statearr_37859_37934 = state_37764;
(statearr_37859_37934[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_37764[(4)]))){
var statearr_37860_37935 = state_37764;
(statearr_37860_37935[(1)] = cljs.core.first((state_37764[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__37936 = state_37764;
state_37764 = G__37936;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__ = function(state_37764){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____1.call(this,state_37764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_37861 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_37861[(6)] = c__17207__auto__);

return statearr_37861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__37937 = select_spec;
var map__37937__$1 = (((((!((map__37937 == null))))?(((((map__37937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37937):map__37937);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37937__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37937__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_38020){
var state_val_38021 = (state_38020[(1)]);
if((state_val_38021 === (7))){
var state_38020__$1 = state_38020;
var statearr_38022_38074 = state_38020__$1;
(statearr_38022_38074[(2)] = false);

(statearr_38022_38074[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (20))){
var inst_37976 = (state_38020[(7)]);
var state_38020__$1 = state_38020;
if(cljs.core.truth_(inst_37976)){
var statearr_38023_38075 = state_38020__$1;
(statearr_38023_38075[(1)] = (22));

} else {
var statearr_38024_38076 = state_38020__$1;
(statearr_38024_38076[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (27))){
var inst_37999 = (state_38020[(8)]);
var inst_38005 = (state_38020[(2)]);
var state_38020__$1 = (function (){var statearr_38025 = state_38020;
(statearr_38025[(9)] = inst_38005);

return statearr_38025;
})();
if(cljs.core.truth_(inst_37999)){
var statearr_38026_38077 = state_38020__$1;
(statearr_38026_38077[(1)] = (28));

} else {
var statearr_38027_38078 = state_38020__$1;
(statearr_38027_38078[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (1))){
var state_38020__$1 = state_38020;
var statearr_38028_38079 = state_38020__$1;
(statearr_38028_38079[(2)] = null);

(statearr_38028_38079[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (24))){
var inst_37997 = (state_38020[(2)]);
var state_38020__$1 = state_38020;
var statearr_38029_38080 = state_38020__$1;
(statearr_38029_38080[(2)] = inst_37997);

(statearr_38029_38080[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (4))){
var inst_37939 = (state_38020[(2)]);
var state_38020__$1 = state_38020;
var statearr_38030_38081 = state_38020__$1;
(statearr_38030_38081[(2)] = inst_37939);

(statearr_38030_38081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (15))){
var inst_37983 = (state_38020[(2)]);
var inst_37984 = fluree.db.util.async.throw_err(inst_37983);
var state_38020__$1 = (function (){var statearr_38031 = state_38020;
(statearr_38031[(10)] = inst_37984);

return statearr_38031;
})();
if(cljs.core.truth_(fuel)){
var statearr_38032_38082 = state_38020__$1;
(statearr_38032_38082[(1)] = (16));

} else {
var statearr_38033_38083 = state_38020__$1;
(statearr_38033_38083[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (21))){
var inst_37969 = (state_38020[(11)]);
var inst_37999 = (state_38020[(2)]);
var state_38020__$1 = (function (){var statearr_38034 = state_38020;
(statearr_38034[(8)] = inst_37999);

return statearr_38034;
})();
if(cljs.core.truth_(inst_37969)){
var statearr_38035_38084 = state_38020__$1;
(statearr_38035_38084[(1)] = (25));

} else {
var statearr_38036_38085 = state_38020__$1;
(statearr_38036_38085[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (31))){
var inst_37970 = (state_38020[(12)]);
var inst_38005 = (state_38020[(9)]);
var inst_38011 = (state_38020[(2)]);
var inst_38012 = fluree.db.util.async.throw_err(inst_38011);
var inst_38013 = (inst_38005.cljs$core$IFn$_invoke$arity$3 ? inst_38005.cljs$core$IFn$_invoke$arity$3(acc,inst_37970,inst_38012) : inst_38005.call(null,acc,inst_37970,inst_38012));
var state_38020__$1 = state_38020;
var statearr_38037_38086 = state_38020__$1;
(statearr_38037_38086[(2)] = inst_38013);

(statearr_38037_38086[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (13))){
var inst_37947 = (state_38020[(13)]);
var state_38020__$1 = state_38020;
var statearr_38038_38087 = state_38020__$1;
(statearr_38038_38087[(2)] = inst_37947);

(statearr_38038_38087[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (22))){
var inst_37976 = (state_38020[(7)]);
var state_38020__$1 = state_38020;
var statearr_38039_38088 = state_38020__$1;
(statearr_38039_38088[(2)] = inst_37976);

(statearr_38039_38088[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (29))){
var inst_37990 = (state_38020[(14)]);
var inst_38008 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_38009 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38008,inst_37990) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38008,inst_37990));
var state_38020__$1 = state_38020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38020__$1,(31),inst_38009);
} else {
if((state_val_38021 === (6))){
var inst_37947 = (state_38020[(13)]);
var inst_37952 = inst_37947.cljs$lang$protocol_mask$partition0$;
var inst_37953 = (inst_37952 & (64));
var inst_37954 = inst_37947.cljs$core$ISeq$;
var inst_37955 = (cljs.core.PROTOCOL_SENTINEL === inst_37954);
var inst_37956 = ((inst_37953) || (inst_37955));
var state_38020__$1 = state_38020;
if(cljs.core.truth_(inst_37956)){
var statearr_38040_38089 = state_38020__$1;
(statearr_38040_38089[(1)] = (9));

} else {
var statearr_38041_38090 = state_38020__$1;
(statearr_38041_38090[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (28))){
var state_38020__$1 = state_38020;
var statearr_38042_38091 = state_38020__$1;
(statearr_38042_38091[(2)] = acc);

(statearr_38042_38091[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (25))){
var inst_37975 = (state_38020[(15)]);
var inst_37970 = (state_38020[(12)]);
var inst_37968 = (state_38020[(16)]);
var inst_37971 = (state_38020[(17)]);
var inst_37999 = (state_38020[(8)]);
var inst_37974 = (state_38020[(18)]);
var inst_37976 = (state_38020[(7)]);
var inst_37973 = (state_38020[(19)]);
var inst_37969 = (state_38020[(11)]);
var inst_37972 = (state_38020[(20)]);
var inst_37946 = (state_38020[(21)]);
var inst_37990 = (state_38020[(14)]);
var inst_38001 = (function (){var recur_seen = inst_37972;
var recur_subject = inst_37946;
var sub_flakes = inst_37990;
var seen_QMARK_ = inst_37975;
var multi_QMARK_ = inst_37969;
var limit = inst_37974;
var recur_depth = inst_37973;
var as = inst_37970;
var max_depth_QMARK_ = inst_37976;
var recur = inst_37971;
var map__37945 = inst_37968;
var stop_QMARK_ = inst_37999;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_38020__$1 = state_38020;
var statearr_38043_38092 = state_38020__$1;
(statearr_38043_38092[(2)] = inst_38001);

(statearr_38043_38092[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (17))){
var inst_37984 = (state_38020[(10)]);
var state_38020__$1 = state_38020;
var statearr_38044_38093 = state_38020__$1;
(statearr_38044_38093[(2)] = inst_37984);

(statearr_38044_38093[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (3))){
var inst_38018 = (state_38020[(2)]);
var state_38020__$1 = state_38020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38020__$1,inst_38018);
} else {
if((state_val_38021 === (12))){
var inst_37947 = (state_38020[(13)]);
var inst_37965 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37947);
var state_38020__$1 = state_38020;
var statearr_38045_38094 = state_38020__$1;
(statearr_38045_38094[(2)] = inst_37965);

(statearr_38045_38094[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (2))){
var inst_37947 = (state_38020[(13)]);
var _ = (function (){var statearr_38046 = state_38020;
(statearr_38046[(4)] = cljs.core.cons((5),(state_38020[(4)])));

return statearr_38046;
})();
var inst_37946 = flake.o;
var inst_37947__$1 = select_spec;
var inst_37949 = (inst_37947__$1 == null);
var inst_37950 = cljs.core.not(inst_37949);
var state_38020__$1 = (function (){var statearr_38047 = state_38020;
(statearr_38047[(13)] = inst_37947__$1);

(statearr_38047[(21)] = inst_37946);

return statearr_38047;
})();
if(inst_37950){
var statearr_38048_38095 = state_38020__$1;
(statearr_38048_38095[(1)] = (6));

} else {
var statearr_38049_38096 = state_38020__$1;
(statearr_38049_38096[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (23))){
var inst_37990 = (state_38020[(14)]);
var inst_37995 = cljs.core.empty_QMARK_(inst_37990);
var state_38020__$1 = state_38020;
var statearr_38050_38097 = state_38020__$1;
(statearr_38050_38097[(2)] = inst_37995);

(statearr_38050_38097[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (19))){
var inst_37975 = (state_38020[(15)]);
var state_38020__$1 = state_38020;
var statearr_38051_38098 = state_38020__$1;
(statearr_38051_38098[(2)] = inst_37975);

(statearr_38051_38098[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (11))){
var inst_37960 = (state_38020[(2)]);
var state_38020__$1 = state_38020;
var statearr_38053_38099 = state_38020__$1;
(statearr_38053_38099[(2)] = inst_37960);

(statearr_38053_38099[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (9))){
var state_38020__$1 = state_38020;
var statearr_38054_38100 = state_38020__$1;
(statearr_38054_38100[(2)] = true);

(statearr_38054_38100[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (5))){
var _ = (function (){var statearr_38055 = state_38020;
(statearr_38055[(4)] = cljs.core.rest((state_38020[(4)])));

return statearr_38055;
})();
var state_38020__$1 = state_38020;
var ex38052 = (state_38020__$1[(2)]);
var statearr_38056_38101 = state_38020__$1;
(statearr_38056_38101[(5)] = ex38052);


if((ex38052 instanceof Error)){
var statearr_38057_38102 = state_38020__$1;
(statearr_38057_38102[(1)] = (4));

(statearr_38057_38102[(5)] = null);

} else {
throw ex38052;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (14))){
var inst_37968 = (state_38020[(16)]);
var inst_37971 = (state_38020[(17)]);
var inst_37973 = (state_38020[(19)]);
var inst_37972 = (state_38020[(20)]);
var inst_37946 = (state_38020[(21)]);
var inst_37968__$1 = (state_38020[(2)]);
var inst_37969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$as);
var inst_37971__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$recur);
var inst_37972__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_37973__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_37974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37968__$1,cljs.core.cst$kw$limit);
var inst_37975 = cljs.core.contains_QMARK_(inst_37972__$1,inst_37946);
var inst_37976 = (inst_37973__$1 > inst_37971__$1);
var inst_37978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37979 = [inst_37946];
var inst_37980 = (new cljs.core.PersistentVector(null,1,(5),inst_37978,inst_37979,null));
var inst_37981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37980);
var state_38020__$1 = (function (){var statearr_38058 = state_38020;
(statearr_38058[(15)] = inst_37975);

(statearr_38058[(12)] = inst_37970);

(statearr_38058[(16)] = inst_37968__$1);

(statearr_38058[(17)] = inst_37971__$1);

(statearr_38058[(18)] = inst_37974);

(statearr_38058[(7)] = inst_37976);

(statearr_38058[(19)] = inst_37973__$1);

(statearr_38058[(11)] = inst_37969);

(statearr_38058[(20)] = inst_37972__$1);

return statearr_38058;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38020__$1,(15),inst_37981);
} else {
if((state_val_38021 === (26))){
var inst_37975 = (state_38020[(15)]);
var inst_37970 = (state_38020[(12)]);
var inst_37968 = (state_38020[(16)]);
var inst_37971 = (state_38020[(17)]);
var inst_37999 = (state_38020[(8)]);
var inst_37974 = (state_38020[(18)]);
var inst_37976 = (state_38020[(7)]);
var inst_37973 = (state_38020[(19)]);
var inst_37969 = (state_38020[(11)]);
var inst_37972 = (state_38020[(20)]);
var inst_37946 = (state_38020[(21)]);
var inst_37990 = (state_38020[(14)]);
var inst_38003 = (function (){var recur_seen = inst_37972;
var recur_subject = inst_37946;
var sub_flakes = inst_37990;
var seen_QMARK_ = inst_37975;
var multi_QMARK_ = inst_37969;
var limit = inst_37974;
var recur_depth = inst_37973;
var as = inst_37970;
var max_depth_QMARK_ = inst_37976;
var recur = inst_37971;
var map__37945 = inst_37968;
var stop_QMARK_ = inst_37999;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_38020__$1 = state_38020;
var statearr_38059_38103 = state_38020__$1;
(statearr_38059_38103[(2)] = inst_38003);

(statearr_38059_38103[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (16))){
var inst_37984 = (state_38020[(10)]);
var inst_37986 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37987 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37986,inst_37984);
var state_38020__$1 = state_38020;
var statearr_38060_38104 = state_38020__$1;
(statearr_38060_38104[(2)] = inst_37987);

(statearr_38060_38104[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (30))){
var inst_38015 = (state_38020[(2)]);
var _ = (function (){var statearr_38061 = state_38020;
(statearr_38061[(4)] = cljs.core.rest((state_38020[(4)])));

return statearr_38061;
})();
var state_38020__$1 = state_38020;
var statearr_38062_38105 = state_38020__$1;
(statearr_38062_38105[(2)] = inst_38015);

(statearr_38062_38105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (10))){
var state_38020__$1 = state_38020;
var statearr_38063_38106 = state_38020__$1;
(statearr_38063_38106[(2)] = false);

(statearr_38063_38106[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (18))){
var inst_37975 = (state_38020[(15)]);
var inst_37990 = (state_38020[(2)]);
var state_38020__$1 = (function (){var statearr_38064 = state_38020;
(statearr_38064[(14)] = inst_37990);

return statearr_38064;
})();
if(cljs.core.truth_(inst_37975)){
var statearr_38065_38107 = state_38020__$1;
(statearr_38065_38107[(1)] = (19));

} else {
var statearr_38066_38108 = state_38020__$1;
(statearr_38066_38108[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38021 === (8))){
var inst_37963 = (state_38020[(2)]);
var state_38020__$1 = state_38020;
if(cljs.core.truth_(inst_37963)){
var statearr_38067_38109 = state_38020__$1;
(statearr_38067_38109[(1)] = (12));

} else {
var statearr_38068_38110 = state_38020__$1;
(statearr_38068_38110[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____0 = (function (){
var statearr_38069 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38069[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__);

(statearr_38069[(1)] = (1));

return statearr_38069;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____1 = (function (state_38020){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_38020);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e38070){var ex__17136__auto__ = e38070;
var statearr_38071_38111 = state_38020;
(statearr_38071_38111[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_38020[(4)]))){
var statearr_38072_38112 = state_38020;
(statearr_38072_38112[(1)] = cljs.core.first((state_38020[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__38113 = state_38020;
state_38020 = G__38113;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__ = function(state_38020){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____1.call(this,state_38020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_38073 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_38073[(6)] = c__17207__auto__);

return statearr_38073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_38291){
var state_val_38292 = (state_38291[(1)]);
if((state_val_38292 === (7))){
var state_38291__$1 = state_38291;
var statearr_38293_38378 = state_38291__$1;
(statearr_38293_38378[(2)] = null);

(statearr_38293_38378[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (20))){
var inst_38152 = cljs.core.PersistentHashMap.EMPTY;
var state_38291__$1 = state_38291;
var statearr_38294_38379 = state_38291__$1;
(statearr_38294_38379[(2)] = inst_38152);

(statearr_38294_38379[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (27))){
var inst_38134 = (state_38291[(7)]);
var inst_38154 = (state_38291[(8)]);
var inst_38140 = (state_38291[(9)]);
var inst_38170 = (state_38291[(10)]);
var inst_38270 = (state_38291[(2)]);
var inst_38271 = (function (){var top_level_subject = inst_38134;
var select_spec = inst_38140;
var base_acc = inst_38154;
var acc_PLUS_refs = inst_38170;
var result = inst_38270;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_38272 = cljs.core.PersistentVector.EMPTY;
var inst_38273 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38140);
var inst_38274 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_38273);
var inst_38275 = cljs.core.vals(inst_38274);
var inst_38276 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38140);
var inst_38277 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_38276);
var inst_38278 = cljs.core.vals(inst_38277);
var inst_38279 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38275,inst_38278);
var inst_38280 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38271,inst_38272,inst_38279);
var inst_38282 = (function (){var top_level_subject = inst_38134;
var select_spec = inst_38140;
var base_acc = inst_38154;
var acc_PLUS_refs = inst_38170;
var result = inst_38270;
var sort_preds = inst_38280;
return (function (acc,p__38281){
var vec__38295 = p__38281;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38295,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38295,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38295,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38295,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_38283 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38282,inst_38270,inst_38280);
var state_38291__$1 = state_38291;
var statearr_38298_38380 = state_38291__$1;
(statearr_38298_38380[(2)] = inst_38283);

(statearr_38298_38380[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (1))){
var state_38291__$1 = state_38291;
var statearr_38299_38381 = state_38291__$1;
(statearr_38299_38381[(2)] = null);

(statearr_38299_38381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (24))){
var inst_38170 = (state_38291[(10)]);
var inst_38170__$1 = (state_38291[(2)]);
var inst_38171 = flakes;
var inst_38172 = cljs.core.PersistentHashMap.EMPTY;
var inst_38173 = inst_38171;
var inst_38174 = inst_38170__$1;
var inst_38175 = inst_38172;
var state_38291__$1 = (function (){var statearr_38300 = state_38291;
(statearr_38300[(11)] = inst_38174);

(statearr_38300[(12)] = inst_38173);

(statearr_38300[(13)] = inst_38175);

(statearr_38300[(10)] = inst_38170__$1);

return statearr_38300;
})();
var statearr_38301_38382 = state_38291__$1;
(statearr_38301_38382[(2)] = null);

(statearr_38301_38382[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (39))){
var inst_38174 = (state_38291[(11)]);
var inst_38189 = (state_38291[(14)]);
var inst_38140 = (state_38291[(9)]);
var inst_38183 = (state_38291[(15)]);
var inst_38218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38219 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38174,inst_38140,inst_38183,inst_38189,false);
var state_38291__$1 = (function (){var statearr_38302 = state_38291;
(statearr_38302[(16)] = inst_38218);

return statearr_38302;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38291__$1,(42),inst_38219);
} else {
if((state_val_38292 === (46))){
var inst_38173 = (state_38291[(12)]);
var inst_38175 = (state_38291[(13)]);
var inst_38183 = (state_38291[(15)]);
var inst_38236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38237 = ["_id"];
var inst_38238 = inst_38183.s;
var inst_38239 = [inst_38238];
var inst_38240 = cljs.core.PersistentHashMap.fromArrays(inst_38237,inst_38239);
var inst_38241 = cljs.core.rest(inst_38173);
var inst_38242 = [inst_38240,inst_38241,inst_38175];
var inst_38243 = (new cljs.core.PersistentVector(null,3,(5),inst_38236,inst_38242,null));
var state_38291__$1 = state_38291;
var statearr_38303_38383 = state_38291__$1;
(statearr_38303_38383[(2)] = inst_38243);

(statearr_38303_38383[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (4))){
var inst_38114 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38304_38384 = state_38291__$1;
(statearr_38304_38384[(2)] = inst_38114);

(statearr_38304_38384[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (15))){
var inst_38141 = (state_38291[(17)]);
var inst_38140 = (state_38291[(9)]);
var inst_38140__$1 = (state_38291[(2)]);
var inst_38141__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38140__$1);
var state_38291__$1 = (function (){var statearr_38305 = state_38291;
(statearr_38305[(17)] = inst_38141__$1);

(statearr_38305[(9)] = inst_38140__$1);

return statearr_38305;
})();
if(cljs.core.truth_(inst_38141__$1)){
var statearr_38306_38385 = state_38291__$1;
(statearr_38306_38385[(1)] = (16));

} else {
var statearr_38307_38386 = state_38291__$1;
(statearr_38307_38386[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (48))){
var inst_38254 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38308_38387 = state_38291__$1;
(statearr_38308_38387[(2)] = inst_38254);

(statearr_38308_38387[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (50))){
var state_38291__$1 = state_38291;
var statearr_38309_38388 = state_38291__$1;
(statearr_38309_38388[(2)] = null);

(statearr_38309_38388[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (21))){
var inst_38140 = (state_38291[(9)]);
var inst_38154 = (state_38291[(2)]);
var inst_38155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38156 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_38157 = (new cljs.core.PersistentVector(null,2,(5),inst_38155,inst_38156,null));
var inst_38158 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38140,inst_38157);
var state_38291__$1 = (function (){var statearr_38310 = state_38291;
(statearr_38310[(8)] = inst_38154);

return statearr_38310;
})();
if(cljs.core.truth_(inst_38158)){
var statearr_38311_38389 = state_38291__$1;
(statearr_38311_38389[(1)] = (22));

} else {
var statearr_38312_38390 = state_38291__$1;
(statearr_38312_38390[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (31))){
var inst_38174 = (state_38291[(11)]);
var inst_38188 = (state_38291[(18)]);
var inst_38183 = (state_38291[(15)]);
var inst_38192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38193 = fluree.db.query.fql.flake__GT_recur(db,inst_38183,inst_38188,inst_38174,fuel,max_fuel,cache);
var state_38291__$1 = (function (){var statearr_38313 = state_38291;
(statearr_38313[(19)] = inst_38192);

return statearr_38313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38291__$1,(34),inst_38193);
} else {
if((state_val_38292 === (32))){
var inst_38188 = (state_38291[(18)]);
var state_38291__$1 = state_38291;
if(cljs.core.truth_(inst_38188)){
var statearr_38314_38391 = state_38291__$1;
(statearr_38314_38391[(1)] = (35));

} else {
var statearr_38315_38392 = state_38291__$1;
(statearr_38315_38392[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (40))){
var inst_38140 = (state_38291[(9)]);
var inst_38228 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38140);
var inst_38229 = cljs.core.empty_QMARK_(inst_38228);
var state_38291__$1 = state_38291;
if(inst_38229){
var statearr_38316_38393 = state_38291__$1;
(statearr_38316_38393[(1)] = (43));

} else {
var statearr_38317_38394 = state_38291__$1;
(statearr_38317_38394[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (33))){
var inst_38183 = (state_38291[(15)]);
var inst_38260 = (state_38291[(2)]);
var inst_38261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38260,(0),null);
var inst_38262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38260,(1),null);
var inst_38263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38260,(2),null);
var inst_38264 = inst_38183.s;
var inst_38265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38261,cljs.core.cst$kw$_id,inst_38264);
var inst_38173 = inst_38262;
var inst_38174 = inst_38265;
var inst_38175 = inst_38263;
var state_38291__$1 = (function (){var statearr_38318 = state_38291;
(statearr_38318[(11)] = inst_38174);

(statearr_38318[(12)] = inst_38173);

(statearr_38318[(13)] = inst_38175);

return statearr_38318;
})();
var statearr_38319_38395 = state_38291__$1;
(statearr_38319_38395[(2)] = null);

(statearr_38319_38395[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (13))){
var inst_38134 = (state_38291[(7)]);
var inst_38137 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_38134);
var state_38291__$1 = state_38291;
var statearr_38320_38396 = state_38291__$1;
(statearr_38320_38396[(2)] = inst_38137);

(statearr_38320_38396[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (22))){
var inst_38140 = (state_38291[(9)]);
var inst_38160 = cljs.core.first(flakes);
var inst_38161 = fluree.db.query.fql.s(inst_38160);
var inst_38162 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_38140);
var inst_38163 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_38161,inst_38162);
var state_38291__$1 = state_38291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38291__$1,(25),inst_38163);
} else {
if((state_val_38292 === (36))){
var inst_38140 = (state_38291[(9)]);
var inst_38216 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38140);
var state_38291__$1 = state_38291;
if(cljs.core.truth_(inst_38216)){
var statearr_38321_38397 = state_38291__$1;
(statearr_38321_38397[(1)] = (39));

} else {
var statearr_38322_38398 = state_38291__$1;
(statearr_38322_38398[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (41))){
var inst_38256 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38323_38399 = state_38291__$1;
(statearr_38323_38399[(2)] = inst_38256);

(statearr_38323_38399[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (43))){
var inst_38140 = (state_38291[(9)]);
var inst_38231 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38140);
var state_38291__$1 = state_38291;
var statearr_38324_38400 = state_38291__$1;
(statearr_38324_38400[(2)] = inst_38231);

(statearr_38324_38400[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (29))){
var inst_38188 = (state_38291[(18)]);
var inst_38173 = (state_38291[(12)]);
var inst_38140 = (state_38291[(9)]);
var inst_38183 = (state_38291[(15)]);
var inst_38183__$1 = cljs.core.first(inst_38173);
var inst_38184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38185 = inst_38183__$1.p;
var inst_38186 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_38185];
var inst_38187 = (new cljs.core.PersistentVector(null,3,(5),inst_38184,inst_38186,null));
var inst_38188__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38140,inst_38187);
var inst_38189 = fluree.db.query.fql.component_follow_QMARK_(inst_38188__$1,inst_38140);
var inst_38190 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_38188__$1);
var state_38291__$1 = (function (){var statearr_38325 = state_38291;
(statearr_38325[(18)] = inst_38188__$1);

(statearr_38325[(14)] = inst_38189);

(statearr_38325[(15)] = inst_38183__$1);

return statearr_38325;
})();
if(cljs.core.truth_(inst_38190)){
var statearr_38326_38401 = state_38291__$1;
(statearr_38326_38401[(1)] = (31));

} else {
var statearr_38327_38402 = state_38291__$1;
(statearr_38327_38402[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (44))){
var state_38291__$1 = state_38291;
var statearr_38328_38403 = state_38291__$1;
(statearr_38328_38403[(2)] = false);

(statearr_38328_38403[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (6))){
var state_38291__$1 = state_38291;
var statearr_38329_38404 = state_38291__$1;
(statearr_38329_38404[(2)] = null);

(statearr_38329_38404[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (28))){
var inst_38174 = (state_38291[(11)]);
var state_38291__$1 = state_38291;
var statearr_38330_38405 = state_38291__$1;
(statearr_38330_38405[(2)] = inst_38174);

(statearr_38330_38405[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (51))){
var inst_38252 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38331_38406 = state_38291__$1;
(statearr_38331_38406[(2)] = inst_38252);

(statearr_38331_38406[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (25))){
var inst_38154 = (state_38291[(8)]);
var inst_38165 = (state_38291[(2)]);
var inst_38166 = fluree.db.util.async.throw_err(inst_38165);
var inst_38167 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38154,inst_38166], 0));
var state_38291__$1 = state_38291;
var statearr_38332_38407 = state_38291__$1;
(statearr_38332_38407[(2)] = inst_38167);

(statearr_38332_38407[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (34))){
var inst_38173 = (state_38291[(12)]);
var inst_38192 = (state_38291[(19)]);
var inst_38175 = (state_38291[(13)]);
var inst_38195 = (state_38291[(2)]);
var inst_38196 = fluree.db.util.async.throw_err(inst_38195);
var inst_38197 = cljs.core.rest(inst_38173);
var inst_38198 = [inst_38196,inst_38197,inst_38175];
var inst_38199 = (new cljs.core.PersistentVector(null,3,(5),inst_38192,inst_38198,null));
var state_38291__$1 = state_38291;
var statearr_38333_38408 = state_38291__$1;
(statearr_38333_38408[(2)] = inst_38199);

(statearr_38333_38408[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (17))){
var inst_38140 = (state_38291[(9)]);
var inst_38144 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38140);
var state_38291__$1 = state_38291;
var statearr_38335_38409 = state_38291__$1;
(statearr_38335_38409[(2)] = inst_38144);

(statearr_38335_38409[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (3))){
var inst_38289 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38291__$1,inst_38289);
} else {
if((state_val_38292 === (12))){
var _ = (function (){var statearr_38336 = state_38291;
(statearr_38336[(4)] = cljs.core.rest((state_38291[(4)])));

return statearr_38336;
})();
var state_38291__$1 = state_38291;
var ex38334 = (state_38291__$1[(2)]);
var statearr_38337_38410 = state_38291__$1;
(statearr_38337_38410[(5)] = ex38334);


var statearr_38338_38411 = state_38291__$1;
(statearr_38338_38411[(1)] = (11));

(statearr_38338_38411[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (2))){
var _ = (function (){var statearr_38339 = state_38291;
(statearr_38339[(4)] = cljs.core.cons((5),(state_38291[(4)])));

return statearr_38339;
})();
var inst_38120 = cljs.core.not_empty(flakes);
var state_38291__$1 = state_38291;
if(cljs.core.truth_(inst_38120)){
var statearr_38340_38412 = state_38291__$1;
(statearr_38340_38412[(1)] = (6));

} else {
var statearr_38341_38413 = state_38291__$1;
(statearr_38341_38413[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (23))){
var inst_38154 = (state_38291[(8)]);
var state_38291__$1 = state_38291;
var statearr_38342_38414 = state_38291__$1;
(statearr_38342_38414[(2)] = inst_38154);

(statearr_38342_38414[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (47))){
var state_38291__$1 = state_38291;
var statearr_38343_38415 = state_38291__$1;
(statearr_38343_38415[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (35))){
var inst_38174 = (state_38291[(11)]);
var inst_38188 = (state_38291[(18)]);
var inst_38189 = (state_38291[(14)]);
var inst_38175 = (state_38291[(13)]);
var inst_38183 = (state_38291[(15)]);
var inst_38205 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_38174,inst_38188,inst_38183,inst_38189,false,inst_38175);
var state_38291__$1 = state_38291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38291__$1,(38),inst_38205);
} else {
if((state_val_38292 === (19))){
var inst_38134 = (state_38291[(7)]);
var inst_38148 = ["_id"];
var inst_38149 = [inst_38134];
var inst_38150 = cljs.core.PersistentHashMap.fromArrays(inst_38148,inst_38149);
var state_38291__$1 = state_38291;
var statearr_38345_38416 = state_38291__$1;
(statearr_38345_38416[(2)] = inst_38150);

(statearr_38345_38416[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (11))){
var inst_38122 = (state_38291[(2)]);
var inst_38123 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38122], 0));
var inst_38124 = (function(){throw inst_38122})();
var state_38291__$1 = (function (){var statearr_38347 = state_38291;
(statearr_38347[(20)] = inst_38123);

return statearr_38347;
})();
var statearr_38348_38417 = state_38291__$1;
(statearr_38348_38417[(2)] = inst_38124);

(statearr_38348_38417[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (9))){
var _ = (function (){var statearr_38349 = state_38291;
(statearr_38349[(4)] = cljs.core.cons((12),(state_38291[(4)])));

return statearr_38349;
})();
var inst_38130 = cljs.core.first(flakes);
var inst_38131 = fluree.db.query.fql.s(inst_38130);
var ___$1 = (function (){var statearr_38350 = state_38291;
(statearr_38350[(4)] = cljs.core.rest((state_38291[(4)])));

return statearr_38350;
})();
var state_38291__$1 = state_38291;
var statearr_38351_38418 = state_38291__$1;
(statearr_38351_38418[(2)] = inst_38131);

(statearr_38351_38418[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (5))){
var _ = (function (){var statearr_38352 = state_38291;
(statearr_38352[(4)] = cljs.core.rest((state_38291[(4)])));

return statearr_38352;
})();
var state_38291__$1 = state_38291;
var ex38346 = (state_38291__$1[(2)]);
var statearr_38353_38419 = state_38291__$1;
(statearr_38353_38419[(5)] = ex38346);


if((ex38346 instanceof Error)){
var statearr_38354_38420 = state_38291__$1;
(statearr_38354_38420[(1)] = (4));

(statearr_38354_38420[(5)] = null);

} else {
throw ex38346;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (14))){
var state_38291__$1 = state_38291;
var statearr_38355_38421 = state_38291__$1;
(statearr_38355_38421[(2)] = base_select_spec);

(statearr_38355_38421[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (45))){
var inst_38234 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
if(cljs.core.truth_(inst_38234)){
var statearr_38356_38422 = state_38291__$1;
(statearr_38356_38422[(1)] = (46));

} else {
var statearr_38357_38423 = state_38291__$1;
(statearr_38357_38423[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (26))){
var inst_38173 = (state_38291[(12)]);
var inst_38177 = cljs.core.empty_QMARK_(inst_38173);
var state_38291__$1 = state_38291;
if(inst_38177){
var statearr_38358_38424 = state_38291__$1;
(statearr_38358_38424[(1)] = (28));

} else {
var statearr_38359_38425 = state_38291__$1;
(statearr_38359_38425[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (16))){
var inst_38141 = (state_38291[(17)]);
var state_38291__$1 = state_38291;
var statearr_38360_38426 = state_38291__$1;
(statearr_38360_38426[(2)] = inst_38141);

(statearr_38360_38426[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (38))){
var inst_38173 = (state_38291[(12)]);
var inst_38207 = (state_38291[(2)]);
var inst_38208 = fluree.db.util.async.throw_err(inst_38207);
var inst_38209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38208,(0),null);
var inst_38210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38208,(1),null);
var inst_38211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38212 = cljs.core.rest(inst_38173);
var inst_38213 = [inst_38209,inst_38212,inst_38210];
var inst_38214 = (new cljs.core.PersistentVector(null,3,(5),inst_38211,inst_38213,null));
var state_38291__$1 = state_38291;
var statearr_38361_38427 = state_38291__$1;
(statearr_38361_38427[(2)] = inst_38214);

(statearr_38361_38427[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (30))){
var inst_38268 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38362_38428 = state_38291__$1;
(statearr_38362_38428[(2)] = inst_38268);

(statearr_38362_38428[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (10))){
var inst_38134 = (state_38291[(2)]);
var inst_38135 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_38291__$1 = (function (){var statearr_38363 = state_38291;
(statearr_38363[(7)] = inst_38134);

return statearr_38363;
})();
if(cljs.core.truth_(inst_38135)){
var statearr_38364_38429 = state_38291__$1;
(statearr_38364_38429[(1)] = (13));

} else {
var statearr_38365_38430 = state_38291__$1;
(statearr_38365_38430[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (18))){
var inst_38146 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
if(cljs.core.truth_(inst_38146)){
var statearr_38366_38431 = state_38291__$1;
(statearr_38366_38431[(1)] = (19));

} else {
var statearr_38367_38432 = state_38291__$1;
(statearr_38367_38432[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (42))){
var inst_38173 = (state_38291[(12)]);
var inst_38218 = (state_38291[(16)]);
var inst_38175 = (state_38291[(13)]);
var inst_38221 = (state_38291[(2)]);
var inst_38222 = fluree.db.util.async.throw_err(inst_38221);
var inst_38223 = cljs.core.first(inst_38222);
var inst_38224 = cljs.core.rest(inst_38173);
var inst_38225 = [inst_38223,inst_38224,inst_38175];
var inst_38226 = (new cljs.core.PersistentVector(null,3,(5),inst_38218,inst_38225,null));
var state_38291__$1 = state_38291;
var statearr_38368_38433 = state_38291__$1;
(statearr_38368_38433[(2)] = inst_38226);

(statearr_38368_38433[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (37))){
var inst_38258 = (state_38291[(2)]);
var state_38291__$1 = state_38291;
var statearr_38369_38434 = state_38291__$1;
(statearr_38369_38434[(2)] = inst_38258);

(statearr_38369_38434[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (8))){
var inst_38286 = (state_38291[(2)]);
var _ = (function (){var statearr_38370 = state_38291;
(statearr_38370[(4)] = cljs.core.rest((state_38291[(4)])));

return statearr_38370;
})();
var state_38291__$1 = state_38291;
var statearr_38371_38435 = state_38291__$1;
(statearr_38371_38435[(2)] = inst_38286);

(statearr_38371_38435[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38292 === (49))){
var inst_38174 = (state_38291[(11)]);
var inst_38173 = (state_38291[(12)]);
var inst_38175 = (state_38291[(13)]);
var inst_38246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38247 = cljs.core.rest(inst_38173);
var inst_38248 = [inst_38174,inst_38247,inst_38175];
var inst_38249 = (new cljs.core.PersistentVector(null,3,(5),inst_38246,inst_38248,null));
var state_38291__$1 = state_38291;
var statearr_38372_38436 = state_38291__$1;
(statearr_38372_38436[(2)] = inst_38249);

(statearr_38372_38436[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____0 = (function (){
var statearr_38373 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38373[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__);

(statearr_38373[(1)] = (1));

return statearr_38373;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____1 = (function (state_38291){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_38291);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e38374){var ex__17136__auto__ = e38374;
var statearr_38375_38437 = state_38291;
(statearr_38375_38437[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_38291[(4)]))){
var statearr_38376_38438 = state_38291;
(statearr_38376_38438[(1)] = cljs.core.first((state_38291[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__38439 = state_38291;
state_38291 = G__38439;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__ = function(state_38291){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____1.call(this,state_38291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_38377 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_38377[(6)] = c__17207__auto__);

return statearr_38377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__38442 = arguments.length;
switch (G__38442) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_38484){
var state_val_38485 = (state_38484[(1)]);
if((state_val_38485 === (7))){
var inst_38450 = (state_38484[(7)]);
var state_38484__$1 = state_38484;
var statearr_38486_38516 = state_38484__$1;
(statearr_38486_38516[(2)] = inst_38450);

(statearr_38486_38516[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (1))){
var state_38484__$1 = state_38484;
var statearr_38487_38517 = state_38484__$1;
(statearr_38487_38517[(2)] = null);

(statearr_38487_38517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (4))){
var inst_38443 = (state_38484[(2)]);
var state_38484__$1 = state_38484;
var statearr_38488_38518 = state_38484__$1;
(statearr_38488_38518[(2)] = inst_38443);

(statearr_38488_38518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (15))){
var inst_38478 = (state_38484[(2)]);
var inst_38479 = fluree.db.util.async.throw_err(inst_38478);
var _ = (function (){var statearr_38489 = state_38484;
(statearr_38489[(4)] = cljs.core.rest((state_38484[(4)])));

return statearr_38489;
})();
var state_38484__$1 = state_38484;
var statearr_38490_38519 = state_38484__$1;
(statearr_38490_38519[(2)] = inst_38479);

(statearr_38490_38519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (13))){
var inst_38462 = (state_38484[(8)]);
var state_38484__$1 = state_38484;
var statearr_38491_38520 = state_38484__$1;
(statearr_38491_38520[(2)] = inst_38462);

(statearr_38491_38520[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (6))){
var inst_38450 = (state_38484[(7)]);
var inst_38452 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_38453 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38450,inst_38452);
var state_38484__$1 = state_38484;
var statearr_38492_38521 = state_38484__$1;
(statearr_38492_38521[(2)] = inst_38453);

(statearr_38492_38521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (3))){
var inst_38482 = (state_38484[(2)]);
var state_38484__$1 = state_38484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38484__$1,inst_38482);
} else {
if((state_val_38485 === (12))){
var inst_38462 = (state_38484[(8)]);
var inst_38464 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_38465 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38462,inst_38464);
var state_38484__$1 = state_38484;
var statearr_38493_38522 = state_38484__$1;
(statearr_38493_38522[(2)] = inst_38465);

(statearr_38493_38522[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (2))){
var _ = (function (){var statearr_38494 = state_38484;
(statearr_38494[(4)] = cljs.core.cons((5),(state_38484[(4)])));

return statearr_38494;
})();
var inst_38450 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38484__$1 = (function (){var statearr_38495 = state_38484;
(statearr_38495[(7)] = inst_38450);

return statearr_38495;
})();
if(cljs.core.truth_(fuel)){
var statearr_38496_38523 = state_38484__$1;
(statearr_38496_38523[(1)] = (6));

} else {
var statearr_38497_38524 = state_38484__$1;
(statearr_38497_38524[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (11))){
var inst_38462 = (state_38484[(2)]);
var state_38484__$1 = (function (){var statearr_38499 = state_38484;
(statearr_38499[(8)] = inst_38462);

return statearr_38499;
})();
if(cljs.core.truth_(limit)){
var statearr_38500_38525 = state_38484__$1;
(statearr_38500_38525[(1)] = (12));

} else {
var statearr_38501_38526 = state_38484__$1;
(statearr_38501_38526[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (9))){
var inst_38456 = (state_38484[(9)]);
var inst_38458 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_38459 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38456,inst_38458);
var state_38484__$1 = state_38484;
var statearr_38502_38527 = state_38484__$1;
(statearr_38502_38527[(2)] = inst_38459);

(statearr_38502_38527[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (5))){
var _ = (function (){var statearr_38503 = state_38484;
(statearr_38503[(4)] = cljs.core.rest((state_38484[(4)])));

return statearr_38503;
})();
var state_38484__$1 = state_38484;
var ex38498 = (state_38484__$1[(2)]);
var statearr_38504_38528 = state_38484__$1;
(statearr_38504_38528[(5)] = ex38498);


if((ex38498 instanceof Error)){
var statearr_38505_38529 = state_38484__$1;
(statearr_38505_38529[(1)] = (4));

(statearr_38505_38529[(5)] = null);

} else {
throw ex38498;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (14))){
var inst_38468 = (state_38484[(2)]);
var inst_38469 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_38470 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_38469);
var inst_38471 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38468,inst_38470);
var inst_38472 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38471,flakes);
var inst_38473 = cljs.core.PersistentVector.EMPTY;
var inst_38474 = (function (){var xf = inst_38471;
var flakes_by_sub = inst_38472;
return (function (p1__38440_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__38440_SHARP_);
});
})();
var inst_38475 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38474,inst_38472);
var inst_38476 = fluree.db.util.async.merge_into_QMARK_(inst_38473,inst_38475);
var state_38484__$1 = state_38484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38484__$1,(15),inst_38476);
} else {
if((state_val_38485 === (10))){
var inst_38456 = (state_38484[(9)]);
var state_38484__$1 = state_38484;
var statearr_38506_38530 = state_38484__$1;
(statearr_38506_38530[(2)] = inst_38456);

(statearr_38506_38530[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38485 === (8))){
var inst_38456 = (state_38484[(2)]);
var state_38484__$1 = (function (){var statearr_38507 = state_38484;
(statearr_38507[(9)] = inst_38456);

return statearr_38507;
})();
if(cljs.core.truth_(offset)){
var statearr_38508_38531 = state_38484__$1;
(statearr_38508_38531[(1)] = (9));

} else {
var statearr_38509_38532 = state_38484__$1;
(statearr_38509_38532[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17133__auto__ = null;
var fluree$db$query$fql$state_machine__17133__auto____0 = (function (){
var statearr_38510 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38510[(0)] = fluree$db$query$fql$state_machine__17133__auto__);

(statearr_38510[(1)] = (1));

return statearr_38510;
});
var fluree$db$query$fql$state_machine__17133__auto____1 = (function (state_38484){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_38484);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e38511){var ex__17136__auto__ = e38511;
var statearr_38512_38533 = state_38484;
(statearr_38512_38533[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_38484[(4)]))){
var statearr_38513_38534 = state_38484;
(statearr_38513_38534[(1)] = cljs.core.first((state_38484[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__38535 = state_38484;
state_38484 = G__38535;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17133__auto__ = function(state_38484){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17133__auto____1.call(this,state_38484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17133__auto____0;
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17133__auto____1;
return fluree$db$query$fql$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_38514 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_38514[(6)] = c__17207__auto__);

return statearr_38514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__38537 = arguments.length;
switch (G__38537) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_38621){
var state_val_38622 = (state_38621[(1)]);
if((state_val_38622 === (7))){
var inst_38616 = (state_38621[(2)]);
var _ = (function (){var statearr_38624 = state_38621;
(statearr_38624[(4)] = cljs.core.rest((state_38621[(4)])));

return statearr_38624;
})();
var state_38621__$1 = state_38621;
var statearr_38625_38672 = state_38621__$1;
(statearr_38625_38672[(2)] = inst_38616);

(statearr_38625_38672[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (20))){
var inst_38557 = (state_38621[(7)]);
var inst_38558 = (state_38621[(8)]);
var inst_38565 = (state_38621[(9)]);
var inst_38586 = (inst_38557 + (1));
var tmp38623 = inst_38558;
var inst_38556 = inst_38565;
var inst_38557__$1 = inst_38586;
var inst_38558__$1 = tmp38623;
var state_38621__$1 = (function (){var statearr_38626 = state_38621;
(statearr_38626[(10)] = inst_38556);

(statearr_38626[(7)] = inst_38557__$1);

(statearr_38626[(8)] = inst_38558__$1);

return statearr_38626;
})();
var statearr_38627_38673 = state_38621__$1;
(statearr_38627_38673[(2)] = null);

(statearr_38627_38673[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (27))){
var inst_38591 = (state_38621[(11)]);
var inst_38600 = (state_38621[(2)]);
var inst_38601 = fluree.db.util.async.throw_err(inst_38600);
var inst_38602 = (inst_38591.cljs$core$IFn$_invoke$arity$1 ? inst_38591.cljs$core$IFn$_invoke$arity$1(inst_38601) : inst_38591.call(null,inst_38601));
var state_38621__$1 = state_38621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38621__$1,(26),inst_38602);
} else {
if((state_val_38622 === (1))){
var state_38621__$1 = state_38621;
var statearr_38628_38674 = state_38621__$1;
(statearr_38628_38674[(2)] = null);

(statearr_38628_38674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (24))){
var state_38621__$1 = state_38621;
var statearr_38629_38675 = state_38621__$1;
(statearr_38629_38675[(2)] = null);

(statearr_38629_38675[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (4))){
var inst_38538 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
var statearr_38630_38676 = state_38621__$1;
(statearr_38630_38676[(2)] = inst_38538);

(statearr_38630_38676[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (15))){
var inst_38579 = (state_38621[(12)]);
var inst_38579__$1 = offset;
var state_38621__$1 = (function (){var statearr_38631 = state_38621;
(statearr_38631[(12)] = inst_38579__$1);

return statearr_38631;
})();
if(cljs.core.truth_(inst_38579__$1)){
var statearr_38632_38677 = state_38621__$1;
(statearr_38632_38677[(1)] = (17));

} else {
var statearr_38633_38678 = state_38621__$1;
(statearr_38633_38678[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (21))){
var state_38621__$1 = state_38621;
var statearr_38634_38679 = state_38621__$1;
(statearr_38634_38679[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (13))){
var inst_38574 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
var statearr_38636_38680 = state_38621__$1;
(statearr_38636_38680[(2)] = inst_38574);

(statearr_38636_38680[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (22))){
var inst_38612 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
var statearr_38637_38681 = state_38621__$1;
(statearr_38637_38681[(2)] = inst_38612);

(statearr_38637_38681[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (6))){
var inst_38564 = (state_38621[(13)]);
var inst_38556 = (state_38621[(10)]);
var inst_38566 = (state_38621[(14)]);
var inst_38563 = cljs.core.seq(inst_38556);
var inst_38564__$1 = cljs.core.first(inst_38563);
var inst_38565 = cljs.core.next(inst_38563);
var inst_38566__$1 = (inst_38564__$1 == null);
var state_38621__$1 = (function (){var statearr_38638 = state_38621;
(statearr_38638[(13)] = inst_38564__$1);

(statearr_38638[(9)] = inst_38565);

(statearr_38638[(14)] = inst_38566__$1);

return statearr_38638;
})();
if(cljs.core.truth_(inst_38566__$1)){
var statearr_38639_38682 = state_38621__$1;
(statearr_38639_38682[(1)] = (8));

} else {
var statearr_38640_38683 = state_38621__$1;
(statearr_38640_38683[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (25))){
var inst_38610 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
var statearr_38641_38684 = state_38621__$1;
(statearr_38641_38684[(2)] = inst_38610);

(statearr_38641_38684[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (17))){
var inst_38557 = (state_38621[(7)]);
var inst_38581 = (inst_38557 < offset);
var state_38621__$1 = state_38621;
var statearr_38642_38685 = state_38621__$1;
(statearr_38642_38685[(2)] = inst_38581);

(statearr_38642_38685[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (3))){
var inst_38619 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38621__$1,inst_38619);
} else {
if((state_val_38622 === (12))){
var inst_38569 = (state_38621[(15)]);
var state_38621__$1 = state_38621;
var statearr_38643_38686 = state_38621__$1;
(statearr_38643_38686[(2)] = inst_38569);

(statearr_38643_38686[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (2))){
var inst_38551 = (state_38621[(16)]);
var _ = (function (){var statearr_38644 = state_38621;
(statearr_38644[(4)] = cljs.core.cons((5),(state_38621[(4)])));

return statearr_38644;
})();
var inst_38551__$1 = subjects;
var inst_38552 = cljs.core.seq(inst_38551__$1);
var inst_38553 = cljs.core.first(inst_38552);
var inst_38554 = cljs.core.next(inst_38552);
var inst_38555 = cljs.core.PersistentVector.EMPTY;
var inst_38556 = inst_38551__$1;
var inst_38557 = (0);
var inst_38558 = inst_38555;
var state_38621__$1 = (function (){var statearr_38645 = state_38621;
(statearr_38645[(17)] = inst_38553);

(statearr_38645[(10)] = inst_38556);

(statearr_38645[(7)] = inst_38557);

(statearr_38645[(8)] = inst_38558);

(statearr_38645[(16)] = inst_38551__$1);

(statearr_38645[(18)] = inst_38554);

return statearr_38645;
})();
var statearr_38646_38687 = state_38621__$1;
(statearr_38646_38687[(2)] = null);

(statearr_38646_38687[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (23))){
var inst_38553 = (state_38621[(17)]);
var inst_38564 = (state_38621[(13)]);
var inst_38556 = (state_38621[(10)]);
var inst_38557 = (state_38621[(7)]);
var inst_38558 = (state_38621[(8)]);
var inst_38551 = (state_38621[(16)]);
var inst_38565 = (state_38621[(9)]);
var inst_38554 = (state_38621[(18)]);
var inst_38590 = (inst_38557 + (1));
var inst_38591 = (function (){var vec__38560 = inst_38556;
var seq__38549 = inst_38554;
var r = inst_38565;
var first__38562 = inst_38564;
var acc = inst_38558;
var n = inst_38557;
var seq__38561 = inst_38565;
var s = inst_38564;
var first__38550 = inst_38553;
var G__38547 = inst_38556;
var vec__38548 = inst_38551;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_38592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38593 = [inst_38564];
var inst_38594 = (new cljs.core.PersistentVector(null,1,(5),inst_38592,inst_38593,null));
var inst_38595 = [cljs.core.cst$kw$limit];
var inst_38596 = [limit];
var inst_38597 = cljs.core.PersistentHashMap.fromArrays(inst_38595,inst_38596);
var inst_38598 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38594,inst_38597);
var state_38621__$1 = (function (){var statearr_38647 = state_38621;
(statearr_38647[(11)] = inst_38591);

(statearr_38647[(19)] = inst_38590);

return statearr_38647;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38621__$1,(27),inst_38598);
} else {
if((state_val_38622 === (19))){
var inst_38584 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
if(cljs.core.truth_(inst_38584)){
var statearr_38648_38688 = state_38621__$1;
(statearr_38648_38688[(1)] = (20));

} else {
var statearr_38649_38689 = state_38621__$1;
(statearr_38649_38689[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (11))){
var inst_38557 = (state_38621[(7)]);
var inst_38571 = (inst_38557 > limit);
var state_38621__$1 = state_38621;
var statearr_38651_38690 = state_38621__$1;
(statearr_38651_38690[(2)] = inst_38571);

(statearr_38651_38690[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (9))){
var inst_38569 = (state_38621[(15)]);
var inst_38569__$1 = limit;
var state_38621__$1 = (function (){var statearr_38652 = state_38621;
(statearr_38652[(15)] = inst_38569__$1);

return statearr_38652;
})();
if(cljs.core.truth_(inst_38569__$1)){
var statearr_38653_38691 = state_38621__$1;
(statearr_38653_38691[(1)] = (11));

} else {
var statearr_38654_38692 = state_38621__$1;
(statearr_38654_38692[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (5))){
var _ = (function (){var statearr_38655 = state_38621;
(statearr_38655[(4)] = cljs.core.rest((state_38621[(4)])));

return statearr_38655;
})();
var state_38621__$1 = state_38621;
var ex38650 = (state_38621__$1[(2)]);
var statearr_38656_38693 = state_38621__$1;
(statearr_38656_38693[(5)] = ex38650);


if((ex38650 instanceof Error)){
var statearr_38657_38694 = state_38621__$1;
(statearr_38657_38694[(1)] = (4));

(statearr_38657_38694[(5)] = null);

} else {
throw ex38650;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (14))){
var inst_38558 = (state_38621[(8)]);
var state_38621__$1 = state_38621;
var statearr_38658_38695 = state_38621__$1;
(statearr_38658_38695[(2)] = inst_38558);

(statearr_38658_38695[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (26))){
var inst_38558 = (state_38621[(8)]);
var inst_38565 = (state_38621[(9)]);
var inst_38590 = (state_38621[(19)]);
var inst_38604 = (state_38621[(2)]);
var inst_38605 = fluree.db.util.async.throw_err(inst_38604);
var inst_38606 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38558,inst_38605);
var inst_38556 = inst_38565;
var inst_38557 = inst_38590;
var inst_38558__$1 = inst_38606;
var state_38621__$1 = (function (){var statearr_38659 = state_38621;
(statearr_38659[(10)] = inst_38556);

(statearr_38659[(7)] = inst_38557);

(statearr_38659[(8)] = inst_38558__$1);

return statearr_38659;
})();
var statearr_38660_38696 = state_38621__$1;
(statearr_38660_38696[(2)] = null);

(statearr_38660_38696[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (16))){
var inst_38614 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
var statearr_38661_38697 = state_38621__$1;
(statearr_38661_38697[(2)] = inst_38614);

(statearr_38661_38697[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (10))){
var inst_38576 = (state_38621[(2)]);
var state_38621__$1 = state_38621;
if(cljs.core.truth_(inst_38576)){
var statearr_38662_38698 = state_38621__$1;
(statearr_38662_38698[(1)] = (14));

} else {
var statearr_38663_38699 = state_38621__$1;
(statearr_38663_38699[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (18))){
var inst_38579 = (state_38621[(12)]);
var state_38621__$1 = state_38621;
var statearr_38664_38700 = state_38621__$1;
(statearr_38664_38700[(2)] = inst_38579);

(statearr_38664_38700[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38622 === (8))){
var inst_38566 = (state_38621[(14)]);
var state_38621__$1 = state_38621;
var statearr_38665_38701 = state_38621__$1;
(statearr_38665_38701[(2)] = inst_38566);

(statearr_38665_38701[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17133__auto__ = null;
var fluree$db$query$fql$state_machine__17133__auto____0 = (function (){
var statearr_38666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38666[(0)] = fluree$db$query$fql$state_machine__17133__auto__);

(statearr_38666[(1)] = (1));

return statearr_38666;
});
var fluree$db$query$fql$state_machine__17133__auto____1 = (function (state_38621){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_38621);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e38667){var ex__17136__auto__ = e38667;
var statearr_38668_38702 = state_38621;
(statearr_38668_38702[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_38621[(4)]))){
var statearr_38669_38703 = state_38621;
(statearr_38669_38703[(1)] = cljs.core.first((state_38621[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__38704 = state_38621;
state_38621 = G__38704;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17133__auto__ = function(state_38621){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17133__auto____1.call(this,state_38621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17133__auto____0;
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17133__auto____1;
return fluree$db$query$fql$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_38670 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_38670[(6)] = c__17207__auto__);

return statearr_38670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__38706 = arguments.length;
switch (G__38706) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_38894){
var state_val_38895 = (state_38894[(1)]);
if((state_val_38895 === (7))){
var state_38894__$1 = state_38894;
var statearr_38896_38967 = state_38894__$1;
(statearr_38896_38967[(2)] = null);

(statearr_38896_38967[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (20))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38777 = (state_38894[(2)]);
var inst_38778 = fluree.db.util.async.throw_err(inst_38777);
var inst_38779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38780 = [inst_38747];
var inst_38781 = (new cljs.core.PersistentVector(null,1,(5),inst_38779,inst_38780,null));
var inst_38782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38783 = [inst_38747,inst_38749];
var inst_38784 = (new cljs.core.PersistentVector(null,2,(5),inst_38782,inst_38783,null));
var inst_38785 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38781,cljs.core._LT_,inst_38784);
var state_38894__$1 = (function (){var statearr_38897 = state_38894;
(statearr_38897[(9)] = inst_38778);

return statearr_38897;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(21),inst_38785);
} else {
if((state_val_38895 === (27))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38814 = (inst_38766.cljs$core$IFn$_invoke$arity$2 ? inst_38766.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_38748) : inst_38766.call(null,cljs.core._GT__EQ_,inst_38748));
var state_38894__$1 = state_38894;
if(cljs.core.truth_(inst_38814)){
var statearr_38898_38968 = state_38894__$1;
(statearr_38898_38968[(1)] = (30));

} else {
var statearr_38899_38969 = state_38894__$1;
(statearr_38899_38969[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (1))){
var state_38894__$1 = state_38894;
var statearr_38900_38970 = state_38894__$1;
(statearr_38900_38970[(2)] = null);

(statearr_38900_38970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (24))){
var inst_38863 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38901_38971 = state_38894__$1;
(statearr_38901_38971[(2)] = inst_38863);

(statearr_38901_38971[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (39))){
var inst_38853 = null;
var state_38894__$1 = state_38894;
var statearr_38902_38972 = state_38894__$1;
(statearr_38902_38972[(2)] = inst_38853);

(statearr_38902_38972[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (46))){
var inst_38874 = (state_38894[(12)]);
var inst_38740 = (state_38894[(13)]);
var inst_38732 = inst_38740;
var inst_38733 = inst_38874;
var state_38894__$1 = (function (){var statearr_38903 = state_38894;
(statearr_38903[(14)] = inst_38732);

(statearr_38903[(15)] = inst_38733);

return statearr_38903;
})();
var statearr_38904_38973 = state_38894__$1;
(statearr_38904_38973[(2)] = null);

(statearr_38904_38973[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (4))){
var inst_38707 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38905_38974 = state_38894__$1;
(statearr_38905_38974[(2)] = inst_38707);

(statearr_38905_38974[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (15))){
var state_38894__$1 = state_38894;
var statearr_38906_38975 = state_38894__$1;
(statearr_38906_38975[(2)] = null);

(statearr_38906_38975[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (21))){
var inst_38778 = (state_38894[(9)]);
var inst_38787 = (state_38894[(2)]);
var inst_38788 = fluree.db.util.async.throw_err(inst_38787);
var inst_38789 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38778,inst_38788);
var state_38894__$1 = state_38894;
var statearr_38907_38976 = state_38894__$1;
(statearr_38907_38976[(2)] = inst_38789);

(statearr_38907_38976[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (31))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38827 = (inst_38766.cljs$core$IFn$_invoke$arity$2 ? inst_38766.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_38748) : inst_38766.call(null,cljs.core._LT_,inst_38748));
var state_38894__$1 = state_38894;
if(cljs.core.truth_(inst_38827)){
var statearr_38908_38977 = state_38894__$1;
(statearr_38908_38977[(1)] = (34));

} else {
var statearr_38909_38978 = state_38894__$1;
(statearr_38909_38978[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (32))){
var inst_38859 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38910_38979 = state_38894__$1;
(statearr_38910_38979[(2)] = inst_38859);

(statearr_38910_38979[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (40))){
var inst_38855 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38911_38980 = state_38894__$1;
(statearr_38911_38980[(2)] = inst_38855);

(statearr_38911_38980[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (33))){
var inst_38824 = (state_38894[(2)]);
var inst_38825 = fluree.db.util.async.throw_err(inst_38824);
var state_38894__$1 = state_38894;
var statearr_38912_38981 = state_38894__$1;
(statearr_38912_38981[(2)] = inst_38825);

(statearr_38912_38981[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (13))){
var inst_38884 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38913_38982 = state_38894__$1;
(statearr_38913_38982[(2)] = inst_38884);

(statearr_38913_38982[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (22))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38794 = [inst_38747,inst_38749];
var inst_38795 = (new cljs.core.PersistentVector(null,2,(5),inst_38793,inst_38794,null));
var inst_38796 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38795);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(25),inst_38796);
} else {
if((state_val_38895 === (36))){
var inst_38857 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38914_38983 = state_38894__$1;
(statearr_38914_38983[(2)] = inst_38857);

(statearr_38914_38983[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (41))){
var inst_38850 = (state_38894[(2)]);
var inst_38851 = fluree.db.util.async.throw_err(inst_38850);
var state_38894__$1 = state_38894;
var statearr_38915_38984 = state_38894__$1;
(statearr_38915_38984[(2)] = inst_38851);

(statearr_38915_38984[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (43))){
var inst_38866 = (state_38894[(16)]);
var inst_38733 = (state_38894[(15)]);
var inst_38867 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38733,inst_38866);
var state_38894__$1 = state_38894;
var statearr_38916_38985 = state_38894__$1;
(statearr_38916_38985[(2)] = inst_38867);

(statearr_38916_38985[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (29))){
var inst_38811 = (state_38894[(2)]);
var inst_38812 = fluree.db.util.async.throw_err(inst_38811);
var state_38894__$1 = state_38894;
var statearr_38917_38986 = state_38894__$1;
(statearr_38917_38986[(2)] = inst_38812);

(statearr_38917_38986[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (44))){
var inst_38866 = (state_38894[(16)]);
var inst_38733 = (state_38894[(15)]);
var inst_38869 = cljs.core.PersistentHashSet.EMPTY;
var inst_38870 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38869,inst_38866);
var inst_38871 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_38733,inst_38870);
var state_38894__$1 = state_38894;
var statearr_38918_38987 = state_38894__$1;
(statearr_38918_38987[(2)] = inst_38871);

(statearr_38918_38987[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (6))){
var inst_38718 = (state_38894[(17)]);
var inst_38728 = cljs.core.seq(inst_38718);
var inst_38729 = cljs.core.first(inst_38728);
var inst_38730 = cljs.core.next(inst_38728);
var inst_38731 = cljs.core.PersistentHashSet.EMPTY;
var inst_38732 = inst_38718;
var inst_38733 = inst_38731;
var state_38894__$1 = (function (){var statearr_38919 = state_38894;
(statearr_38919[(18)] = inst_38729);

(statearr_38919[(14)] = inst_38732);

(statearr_38919[(15)] = inst_38733);

(statearr_38919[(19)] = inst_38730);

return statearr_38919;
})();
var statearr_38920_38988 = state_38894__$1;
(statearr_38920_38988[(2)] = null);

(statearr_38920_38988[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (28))){
var inst_38861 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38921_38989 = state_38894__$1;
(statearr_38921_38989[(2)] = inst_38861);

(statearr_38921_38989[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (25))){
var inst_38798 = (state_38894[(2)]);
var inst_38799 = fluree.db.util.async.throw_err(inst_38798);
var state_38894__$1 = state_38894;
var statearr_38922_38990 = state_38894__$1;
(statearr_38922_38990[(2)] = inst_38799);

(statearr_38922_38990[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (34))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38830 = [inst_38747];
var inst_38831 = (new cljs.core.PersistentVector(null,1,(5),inst_38829,inst_38830,null));
var inst_38832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38833 = [inst_38747,inst_38749];
var inst_38834 = (new cljs.core.PersistentVector(null,2,(5),inst_38832,inst_38833,null));
var inst_38835 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38831,cljs.core._LT_,inst_38834);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(37),inst_38835);
} else {
if((state_val_38895 === (17))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38770 = [inst_38747,inst_38749];
var inst_38771 = (new cljs.core.PersistentVector(null,2,(5),inst_38769,inst_38770,null));
var inst_38772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38773 = [inst_38747];
var inst_38774 = (new cljs.core.PersistentVector(null,1,(5),inst_38772,inst_38773,null));
var inst_38775 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38771,cljs.core._LT__EQ_,inst_38774);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(20),inst_38775);
} else {
if((state_val_38895 === (3))){
var inst_38892 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38894__$1,inst_38892);
} else {
if((state_val_38895 === (12))){
var inst_38739 = (state_38894[(20)]);
var inst_38747 = (state_38894[(8)]);
var inst_38747__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38739,(0),null);
var inst_38748 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38739,(1),null);
var inst_38749 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38739,(2),null);
var inst_38750 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_38747__$1);
var inst_38751 = cljs.core.not(inst_38750);
var state_38894__$1 = (function (){var statearr_38923 = state_38894;
(statearr_38923[(7)] = inst_38749);

(statearr_38923[(8)] = inst_38747__$1);

(statearr_38923[(11)] = inst_38748);

return statearr_38923;
})();
if(inst_38751){
var statearr_38924_38991 = state_38894__$1;
(statearr_38924_38991[(1)] = (14));

} else {
var statearr_38925_38992 = state_38894__$1;
(statearr_38925_38992[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (2))){
var inst_38718 = (state_38894[(17)]);
var _ = (function (){var statearr_38926 = state_38894;
(statearr_38926[(4)] = cljs.core.cons((5),(state_38894[(4)])));

return statearr_38926;
})();
var inst_38716 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_38717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38716,(0),null);
var inst_38718__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38716,(1),null);
var inst_38719 = cljs.core.not_empty(inst_38718__$1);
var state_38894__$1 = (function (){var statearr_38927 = state_38894;
(statearr_38927[(17)] = inst_38718__$1);

(statearr_38927[(21)] = inst_38717);

return statearr_38927;
})();
if(cljs.core.truth_(inst_38719)){
var statearr_38928_38993 = state_38894__$1;
(statearr_38928_38993[(1)] = (6));

} else {
var statearr_38929_38994 = state_38894__$1;
(statearr_38929_38994[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (23))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38801 = (inst_38766.cljs$core$IFn$_invoke$arity$2 ? inst_38766.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_38748) : inst_38766.call(null,cljs.core._GT_,inst_38748));
var state_38894__$1 = state_38894;
if(cljs.core.truth_(inst_38801)){
var statearr_38930_38995 = state_38894__$1;
(statearr_38930_38995[(1)] = (26));

} else {
var statearr_38931_38996 = state_38894__$1;
(statearr_38931_38996[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (47))){
var inst_38882 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38932_38997 = state_38894__$1;
(statearr_38932_38997[(2)] = inst_38882);

(statearr_38932_38997[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (35))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38840 = (inst_38766.cljs$core$IFn$_invoke$arity$2 ? inst_38766.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_38748) : inst_38766.call(null,cljs.core._LT__EQ_,inst_38748));
var state_38894__$1 = state_38894;
if(cljs.core.truth_(inst_38840)){
var statearr_38933_38998 = state_38894__$1;
(statearr_38933_38998[(1)] = (38));

} else {
var statearr_38934_38999 = state_38894__$1;
(statearr_38934_38999[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (19))){
var inst_38717 = (state_38894[(21)]);
var inst_38865 = (state_38894[(2)]);
var inst_38866 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38865);
var state_38894__$1 = (function (){var statearr_38935 = state_38894;
(statearr_38935[(16)] = inst_38866);

return statearr_38935;
})();
var G__38936_39000 = inst_38717;
var G__38936_39001__$1 = (((G__38936_39000 instanceof cljs.core.Keyword))?G__38936_39000.fqn:null);
switch (G__38936_39001__$1) {
case "or":
var statearr_38937_39003 = state_38894__$1;
(statearr_38937_39003[(1)] = (43));


break;
case "and":
var statearr_38938_39004 = state_38894__$1;
(statearr_38938_39004[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38936_39001__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (11))){
var inst_38733 = (state_38894[(15)]);
var state_38894__$1 = state_38894;
var statearr_38940_39005 = state_38894__$1;
(statearr_38940_39005[(2)] = inst_38733);

(statearr_38940_39005[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (9))){
var inst_38739 = (state_38894[(20)]);
var inst_38732 = (state_38894[(14)]);
var inst_38738 = cljs.core.seq(inst_38732);
var inst_38739__$1 = cljs.core.first(inst_38738);
var inst_38740 = cljs.core.next(inst_38738);
var inst_38741 = cljs.core.not(inst_38739__$1);
var state_38894__$1 = (function (){var statearr_38941 = state_38894;
(statearr_38941[(20)] = inst_38739__$1);

(statearr_38941[(13)] = inst_38740);

return statearr_38941;
})();
if(inst_38741){
var statearr_38942_39006 = state_38894__$1;
(statearr_38942_39006[(1)] = (11));

} else {
var statearr_38943_39007 = state_38894__$1;
(statearr_38943_39007[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (5))){
var _ = (function (){var statearr_38944 = state_38894;
(statearr_38944[(4)] = cljs.core.rest((state_38894[(4)])));

return statearr_38944;
})();
var state_38894__$1 = state_38894;
var ex38939 = (state_38894__$1[(2)]);
var statearr_38945_39008 = state_38894__$1;
(statearr_38945_39008[(5)] = ex38939);


if((ex38939 instanceof Error)){
var statearr_38946_39009 = state_38894__$1;
(statearr_38946_39009[(1)] = (4));

(statearr_38946_39009[(5)] = null);

} else {
throw ex38939;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (14))){
var inst_38747 = (state_38894[(8)]);
var inst_38753 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_38747);
var inst_38754 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38753)].join('');
var inst_38755 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38756 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38757 = cljs.core.PersistentHashMap.fromArrays(inst_38755,inst_38756);
var inst_38758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38754,inst_38757);
var inst_38759 = (function(){throw inst_38758})();
var state_38894__$1 = state_38894;
var statearr_38947_39010 = state_38894__$1;
(statearr_38947_39010[(2)] = inst_38759);

(statearr_38947_39010[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (45))){
var inst_38874 = (state_38894[(12)]);
var state_38894__$1 = state_38894;
var statearr_38948_39011 = state_38894__$1;
(statearr_38948_39011[(2)] = inst_38874);

(statearr_38948_39011[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (26))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38804 = [inst_38747,inst_38749];
var inst_38805 = (new cljs.core.PersistentVector(null,2,(5),inst_38803,inst_38804,null));
var inst_38806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38807 = [inst_38747];
var inst_38808 = (new cljs.core.PersistentVector(null,1,(5),inst_38806,inst_38807,null));
var inst_38809 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38805,cljs.core._LT__EQ_,inst_38808);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(29),inst_38809);
} else {
if((state_val_38895 === (16))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38762 = (state_38894[(2)]);
var inst_38766__$1 = cljs.core.identical_QMARK_;
var inst_38767 = (inst_38766__$1.cljs$core$IFn$_invoke$arity$2 ? inst_38766__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_38748) : inst_38766__$1.call(null,cljs.core.not_EQ_,inst_38748));
var state_38894__$1 = (function (){var statearr_38949 = state_38894;
(statearr_38949[(10)] = inst_38766__$1);

(statearr_38949[(22)] = inst_38762);

return statearr_38949;
})();
if(cljs.core.truth_(inst_38767)){
var statearr_38950_39012 = state_38894__$1;
(statearr_38950_39012[(1)] = (17));

} else {
var statearr_38951_39013 = state_38894__$1;
(statearr_38951_39013[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (38))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38843 = [inst_38747];
var inst_38844 = (new cljs.core.PersistentVector(null,1,(5),inst_38842,inst_38843,null));
var inst_38845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38846 = [inst_38747,inst_38749];
var inst_38847 = (new cljs.core.PersistentVector(null,2,(5),inst_38845,inst_38846,null));
var inst_38848 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38844,cljs.core._LT__EQ_,inst_38847);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(41),inst_38848);
} else {
if((state_val_38895 === (30))){
var inst_38749 = (state_38894[(7)]);
var inst_38747 = (state_38894[(8)]);
var inst_38816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38817 = [inst_38747,inst_38749];
var inst_38818 = (new cljs.core.PersistentVector(null,2,(5),inst_38816,inst_38817,null));
var inst_38819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38820 = [inst_38747];
var inst_38821 = (new cljs.core.PersistentVector(null,1,(5),inst_38819,inst_38820,null));
var inst_38822 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38818,cljs.core._LT__EQ_,inst_38821);
var state_38894__$1 = state_38894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38894__$1,(33),inst_38822);
} else {
if((state_val_38895 === (10))){
var inst_38886 = (state_38894[(2)]);
var state_38894__$1 = state_38894;
var statearr_38952_39014 = state_38894__$1;
(statearr_38952_39014[(2)] = inst_38886);

(statearr_38952_39014[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (18))){
var inst_38766 = (state_38894[(10)]);
var inst_38748 = (state_38894[(11)]);
var inst_38791 = (inst_38766.cljs$core$IFn$_invoke$arity$2 ? inst_38766.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_38748) : inst_38766.call(null,cljs.core._EQ_,inst_38748));
var state_38894__$1 = state_38894;
if(cljs.core.truth_(inst_38791)){
var statearr_38953_39015 = state_38894__$1;
(statearr_38953_39015[(1)] = (22));

} else {
var statearr_38954_39016 = state_38894__$1;
(statearr_38954_39016[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (42))){
var inst_38874 = (state_38894[(12)]);
var inst_38717 = (state_38894[(21)]);
var inst_38874__$1 = (state_38894[(2)]);
var inst_38875 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38717);
var inst_38876 = cljs.core.empty_QMARK_(inst_38874__$1);
var inst_38877 = ((inst_38875) && (inst_38876));
var state_38894__$1 = (function (){var statearr_38955 = state_38894;
(statearr_38955[(12)] = inst_38874__$1);

return statearr_38955;
})();
if(cljs.core.truth_(inst_38877)){
var statearr_38956_39017 = state_38894__$1;
(statearr_38956_39017[(1)] = (45));

} else {
var statearr_38957_39018 = state_38894__$1;
(statearr_38957_39018[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (37))){
var inst_38837 = (state_38894[(2)]);
var inst_38838 = fluree.db.util.async.throw_err(inst_38837);
var state_38894__$1 = state_38894;
var statearr_38958_39019 = state_38894__$1;
(statearr_38958_39019[(2)] = inst_38838);

(statearr_38958_39019[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38895 === (8))){
var inst_38889 = (state_38894[(2)]);
var _ = (function (){var statearr_38959 = state_38894;
(statearr_38959[(4)] = cljs.core.rest((state_38894[(4)])));

return statearr_38959;
})();
var state_38894__$1 = state_38894;
var statearr_38960_39020 = state_38894__$1;
(statearr_38960_39020[(2)] = inst_38889);

(statearr_38960_39020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17133__auto__ = null;
var fluree$db$query$fql$state_machine__17133__auto____0 = (function (){
var statearr_38961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38961[(0)] = fluree$db$query$fql$state_machine__17133__auto__);

(statearr_38961[(1)] = (1));

return statearr_38961;
});
var fluree$db$query$fql$state_machine__17133__auto____1 = (function (state_38894){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_38894);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e38962){var ex__17136__auto__ = e38962;
var statearr_38963_39021 = state_38894;
(statearr_38963_39021[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_38894[(4)]))){
var statearr_38964_39022 = state_38894;
(statearr_38964_39022[(1)] = cljs.core.first((state_38894[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39023 = state_38894;
state_38894 = G__39023;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17133__auto__ = function(state_38894){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17133__auto____1.call(this,state_38894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17133__auto____0;
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17133__auto____1;
return fluree$db$query$fql$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_38965 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_38965[(6)] = c__17207__auto__);

return statearr_38965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__39025,offset,limit){
var map__39026 = p__39025;
var map__39026__$1 = (((((!((map__39026 == null))))?(((((map__39026.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39026.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39026):map__39026);
var res = map__39026__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39026__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39026__$1,cljs.core.cst$kw$tuples);
var vec__39028 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39028,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39028,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__39031 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__39024_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39024_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__39031__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__39031):G__39031);
var G__39031__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__39031__$1):G__39031__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__39031__$2);
} else {
return G__39031__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__39032_SHARP_){
return ((typeof p1__39032_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__39032_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__39033_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__39033_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__39037 = vars;
var vec__39038 = G__39037;
var seq__39039 = cljs.core.seq(vec__39038);
var first__39040 = cljs.core.first(seq__39039);
var seq__39039__$1 = cljs.core.next(seq__39039);
var var$ = first__39040;
var r = seq__39039__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__39037__$1 = G__39037;
var all_vars__$1 = all_vars;
while(true){
var vec__39045 = G__39037__$1;
var seq__39046 = cljs.core.seq(vec__39045);
var first__39047 = cljs.core.first(seq__39046);
var seq__39046__$1 = cljs.core.next(seq__39046);
var var$__$1 = first__39047;
var r__$1 = seq__39046__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__39048 = cljs.core.set(all_vars__$2);
return (fexpr__39048.cljs$core$IFn$_invoke$arity$1 ? fexpr__39048.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__39048.call(null,var$__$1));
})())){
var G__39049 = r__$1;
var G__39050 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__39037__$1 = G__39049;
all_vars__$1 = G__39050;
continue;
} else {
var G__39051 = r__$1;
var G__39052 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__39037__$1 = G__39051;
all_vars__$1 = G__39052;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39087){
var state_val_39088 = (state_39087[(1)]);
if((state_val_39088 === (1))){
var inst_39060 = functionArray;
var inst_39061 = cljs.core.seq(inst_39060);
var inst_39062 = cljs.core.first(inst_39061);
var inst_39063 = cljs.core.next(inst_39061);
var inst_39064 = cljs.core.PersistentVector.EMPTY;
var inst_39065 = inst_39060;
var inst_39066 = inst_39064;
var state_39087__$1 = (function (){var statearr_39089 = state_39087;
(statearr_39089[(7)] = inst_39066);

(statearr_39089[(8)] = inst_39063);

(statearr_39089[(9)] = inst_39062);

(statearr_39089[(10)] = inst_39065);

return statearr_39089;
})();
var statearr_39090_39103 = state_39087__$1;
(statearr_39090_39103[(2)] = null);

(statearr_39090_39103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39088 === (2))){
var inst_39065 = (state_39087[(10)]);
var inst_39072 = (state_39087[(11)]);
var inst_39071 = cljs.core.seq(inst_39065);
var inst_39072__$1 = cljs.core.first(inst_39071);
var inst_39073 = cljs.core.next(inst_39071);
var state_39087__$1 = (function (){var statearr_39091 = state_39087;
(statearr_39091[(11)] = inst_39072__$1);

(statearr_39091[(12)] = inst_39073);

return statearr_39091;
})();
if(cljs.core.truth_(inst_39072__$1)){
var statearr_39092_39104 = state_39087__$1;
(statearr_39092_39104[(1)] = (4));

} else {
var statearr_39093_39105 = state_39087__$1;
(statearr_39093_39105[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39088 === (3))){
var inst_39085 = (state_39087[(2)]);
var state_39087__$1 = state_39087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39087__$1,inst_39085);
} else {
if((state_val_39088 === (4))){
var inst_39072 = (state_39087[(11)]);
var inst_39075 = (inst_39072.cljs$core$IFn$_invoke$arity$1 ? inst_39072.cljs$core$IFn$_invoke$arity$1(tuple) : inst_39072.call(null,tuple));
var state_39087__$1 = state_39087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39087__$1,(7),inst_39075);
} else {
if((state_val_39088 === (5))){
var inst_39066 = (state_39087[(7)]);
var state_39087__$1 = state_39087;
var statearr_39094_39106 = state_39087__$1;
(statearr_39094_39106[(2)] = inst_39066);

(statearr_39094_39106[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39088 === (6))){
var inst_39083 = (state_39087[(2)]);
var state_39087__$1 = state_39087;
var statearr_39095_39107 = state_39087__$1;
(statearr_39095_39107[(2)] = inst_39083);

(statearr_39095_39107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39088 === (7))){
var inst_39066 = (state_39087[(7)]);
var inst_39073 = (state_39087[(12)]);
var inst_39077 = (state_39087[(2)]);
var inst_39078 = fluree.db.util.async.throw_err(inst_39077);
var inst_39079 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39066,inst_39078);
var inst_39065 = inst_39073;
var inst_39066__$1 = inst_39079;
var state_39087__$1 = (function (){var statearr_39096 = state_39087;
(statearr_39096[(7)] = inst_39066__$1);

(statearr_39096[(10)] = inst_39065);

return statearr_39096;
})();
var statearr_39097_39108 = state_39087__$1;
(statearr_39097_39108[(2)] = null);

(statearr_39097_39108[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____0 = (function (){
var statearr_39098 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39098[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__);

(statearr_39098[(1)] = (1));

return statearr_39098;
});
var fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____1 = (function (state_39087){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39087);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39099){var ex__17136__auto__ = e39099;
var statearr_39100_39109 = state_39087;
(statearr_39100_39109[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39087[(4)]))){
var statearr_39101_39110 = state_39087;
(statearr_39101_39110[(1)] = cljs.core.first((state_39087[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39111 = state_39087;
state_39087 = G__39111;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__ = function(state_39087){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____1.call(this,state_39087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__17133__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39102 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39102[(6)] = c__17207__auto__);

return statearr_39102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__39113,headers,vars,opts){
var map__39114 = p__39113;
var map__39114__$1 = (((((!((map__39114 == null))))?(((((map__39114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39114.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39114):map__39114);
var select_spec = map__39114__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39114__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39114__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39114__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39114__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39201){
var state_val_39202 = (state_39201[(1)]);
if((state_val_39202 === (7))){
var state_39201__$1 = state_39201;
var statearr_39203_39345 = state_39201__$1;
(statearr_39203_39345[(2)] = null);

(statearr_39203_39345[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (1))){
var state_39201__$1 = state_39201;
var statearr_39204_39346 = state_39201__$1;
(statearr_39204_39346[(2)] = null);

(statearr_39204_39346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (4))){
var inst_39116 = (state_39201[(2)]);
var state_39201__$1 = state_39201;
var statearr_39205_39347 = state_39201__$1;
(statearr_39205_39347[(2)] = inst_39116);

(statearr_39205_39347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (15))){
var inst_39190 = (state_39201[(2)]);
var inst_39191 = fluree.db.util.async.throw_err(inst_39190);
var state_39201__$1 = state_39201;
var statearr_39206_39348 = state_39201__$1;
(statearr_39206_39348[(2)] = inst_39191);

(statearr_39206_39348[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (13))){
var inst_39126 = (state_39201[(7)]);
var inst_39134 = (state_39201[(8)]);
var inst_39193 = (function (){var pp = inst_39126;
var functionArray = inst_39134;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39112_SHARP_){
return (p1__39112_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39112_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__39112_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_39194 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39193,tuples);
var state_39201__$1 = state_39201;
var statearr_39207_39349 = state_39201__$1;
(statearr_39207_39349[(2)] = inst_39194);

(statearr_39207_39349[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (6))){
var inst_39123 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_39201__$1 = state_39201;
var statearr_39208_39350 = state_39201__$1;
(statearr_39208_39350[(2)] = inst_39123);

(statearr_39208_39350[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (3))){
var inst_39199 = (state_39201[(2)]);
var state_39201__$1 = state_39201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39201__$1,inst_39199);
} else {
if((state_val_39202 === (12))){
var inst_39126 = (state_39201[(7)]);
var inst_39134 = (state_39201[(8)]);
var inst_39186 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_39187 = (function (){var pp = inst_39126;
var functionArray = inst_39134;
var c__17207__auto____$1 = inst_39186;
return (function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39184){
var state_val_39185 = (state_39184[(1)]);
if((state_val_39185 === (7))){
var inst_39160 = (state_39184[(2)]);
var inst_39161 = fluree.db.util.async.throw_err(inst_39160);
var state_39184__$1 = (function (){var statearr_39209 = state_39184;
(statearr_39209[(7)] = inst_39161);

return statearr_39209;
})();
if(cljs.core.truth_(pp)){
var statearr_39210_39351 = state_39184__$1;
(statearr_39210_39351[(1)] = (8));

} else {
var statearr_39211_39352 = state_39184__$1;
(statearr_39211_39352[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (1))){
var inst_39143 = tuples;
var inst_39144 = cljs.core.seq(inst_39143);
var inst_39145 = cljs.core.first(inst_39144);
var inst_39146 = cljs.core.next(inst_39144);
var inst_39147 = cljs.core.PersistentVector.EMPTY;
var inst_39148 = inst_39143;
var inst_39149 = inst_39147;
var state_39184__$1 = (function (){var statearr_39212 = state_39184;
(statearr_39212[(8)] = inst_39148);

(statearr_39212[(9)] = inst_39146);

(statearr_39212[(10)] = inst_39145);

(statearr_39212[(11)] = inst_39149);

return statearr_39212;
})();
var statearr_39213_39353 = state_39184__$1;
(statearr_39213_39353[(2)] = null);

(statearr_39213_39353[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (4))){
var inst_39155 = (state_39184[(12)]);
var inst_39158 = fluree.db.query.fql.format_tuple(functionArray,inst_39155);
var state_39184__$1 = state_39184;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39184__$1,(7),inst_39158);
} else {
if((state_val_39185 === (15))){
var state_39184__$1 = state_39184;
var statearr_39214_39354 = state_39184__$1;
(statearr_39214_39354[(2)] = null);

(statearr_39214_39354[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (13))){
var inst_39173 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
var statearr_39215_39355 = state_39184__$1;
(statearr_39215_39355[(2)] = inst_39173);

(statearr_39215_39355[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (6))){
var inst_39180 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
var statearr_39216_39356 = state_39184__$1;
(statearr_39216_39356[(2)] = inst_39180);

(statearr_39216_39356[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (3))){
var inst_39182 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39184__$1,inst_39182);
} else {
if((state_val_39185 === (12))){
var state_39184__$1 = state_39184;
var statearr_39217_39357 = state_39184__$1;
(statearr_39217_39357[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (2))){
var inst_39148 = (state_39184[(8)]);
var inst_39155 = (state_39184[(12)]);
var inst_39154 = cljs.core.seq(inst_39148);
var inst_39155__$1 = cljs.core.first(inst_39154);
var inst_39156 = cljs.core.next(inst_39154);
var state_39184__$1 = (function (){var statearr_39219 = state_39184;
(statearr_39219[(13)] = inst_39156);

(statearr_39219[(12)] = inst_39155__$1);

return statearr_39219;
})();
if(cljs.core.truth_(inst_39155__$1)){
var statearr_39220_39358 = state_39184__$1;
(statearr_39220_39358[(1)] = (4));

} else {
var statearr_39221_39359 = state_39184__$1;
(statearr_39221_39359[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (11))){
var inst_39161 = (state_39184[(7)]);
var state_39184__$1 = state_39184;
var statearr_39222_39360 = state_39184__$1;
(statearr_39222_39360[(2)] = inst_39161);

(statearr_39222_39360[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (9))){
var state_39184__$1 = state_39184;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39223_39361 = state_39184__$1;
(statearr_39223_39361[(1)] = (11));

} else {
var statearr_39224_39362 = state_39184__$1;
(statearr_39224_39362[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (5))){
var inst_39149 = (state_39184[(11)]);
var state_39184__$1 = state_39184;
var statearr_39225_39363 = state_39184__$1;
(statearr_39225_39363[(2)] = inst_39149);

(statearr_39225_39363[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (14))){
var inst_39161 = (state_39184[(7)]);
var inst_39168 = cljs.core.first(inst_39161);
var state_39184__$1 = state_39184;
var statearr_39226_39364 = state_39184__$1;
(statearr_39226_39364[(2)] = inst_39168);

(statearr_39226_39364[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (16))){
var inst_39171 = (state_39184[(2)]);
var state_39184__$1 = state_39184;
var statearr_39227_39365 = state_39184__$1;
(statearr_39227_39365[(2)] = inst_39171);

(statearr_39227_39365[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (10))){
var inst_39156 = (state_39184[(13)]);
var inst_39149 = (state_39184[(11)]);
var inst_39175 = (state_39184[(2)]);
var inst_39176 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39149,inst_39175);
var inst_39148 = inst_39156;
var inst_39149__$1 = inst_39176;
var state_39184__$1 = (function (){var statearr_39228 = state_39184;
(statearr_39228[(8)] = inst_39148);

(statearr_39228[(11)] = inst_39149__$1);

return statearr_39228;
})();
var statearr_39229_39366 = state_39184__$1;
(statearr_39229_39366[(2)] = null);

(statearr_39229_39366[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39185 === (8))){
var inst_39161 = (state_39184[(7)]);
var inst_39163 = cljs.core.zipmap(pp,inst_39161);
var state_39184__$1 = state_39184;
var statearr_39230_39367 = state_39184__$1;
(statearr_39230_39367[(2)] = inst_39163);

(statearr_39230_39367[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_39231 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39231[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__);

(statearr_39231[(1)] = (1));

return statearr_39231;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1 = (function (state_39184){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39184);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39232){var ex__17136__auto__ = e39232;
var statearr_39233_39368 = state_39184;
(statearr_39233_39368[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39184[(4)]))){
var statearr_39234_39369 = state_39184;
(statearr_39234_39369[(1)] = cljs.core.first((state_39184[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39370 = state_39184;
state_39184 = G__39370;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = function(state_39184){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1.call(this,state_39184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39235 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39235[(6)] = c__17207__auto____$1);

return statearr_39235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
});
})();
var inst_39188 = cljs.core.async.impl.dispatch.run(inst_39187);
var state_39201__$1 = (function (){var statearr_39236 = state_39201;
(statearr_39236[(9)] = inst_39188);

return statearr_39236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39201__$1,(15),inst_39186);
} else {
if((state_val_39202 === (2))){
var _ = (function (){var statearr_39237 = state_39201;
(statearr_39237[(4)] = cljs.core.cons((5),(state_39201[(4)])));

return statearr_39237;
})();
var state_39201__$1 = state_39201;
if(cljs.core.truth_(prettyPrint)){
var statearr_39238_39371 = state_39201__$1;
(statearr_39238_39371[(1)] = (6));

} else {
var statearr_39239_39372 = state_39201__$1;
(statearr_39239_39372[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (11))){
var inst_39134 = (state_39201[(2)]);
var state_39201__$1 = (function (){var statearr_39241 = state_39201;
(statearr_39241[(8)] = inst_39134);

return statearr_39241;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39242_39373 = state_39201__$1;
(statearr_39242_39373[(1)] = (12));

} else {
var statearr_39243_39374 = state_39201__$1;
(statearr_39243_39374[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (9))){
var inst_39126 = (state_39201[(7)]);
var inst_39128 = (function (){var pp = inst_39126;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__17207__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39278){
var state_val_39279 = (state_39278[(1)]);
if((state_val_39279 === (7))){
var state_39278__$1 = state_39278;
var statearr_39280_39375 = state_39278__$1;
(statearr_39280_39375[(2)] = null);

(statearr_39280_39375[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (1))){
var state_39278__$1 = state_39278;
var statearr_39281_39376 = state_39278__$1;
(statearr_39281_39376[(2)] = null);

(statearr_39281_39376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (4))){
var inst_39244 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
var statearr_39282_39377 = state_39278__$1;
(statearr_39282_39377[(2)] = inst_39244);

(statearr_39282_39377[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (6))){
var inst_39254 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39255 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_39256 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39257 = [inst_39255,inst_39256,opts];
var inst_39258 = cljs.core.PersistentHashMap.fromArrays(inst_39254,inst_39257);
var inst_39259 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_39258) : fluree.db.query.fql.query.call(null,db,inst_39258));
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39278__$1,(9),inst_39259);
} else {
if((state_val_39279 === (3))){
var inst_39276 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39278__$1,inst_39276);
} else {
if((state_val_39279 === (12))){
var inst_39270 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
var statearr_39283_39378 = state_39278__$1;
(statearr_39283_39378[(2)] = inst_39270);

(statearr_39283_39378[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (2))){
var _ = (function (){var statearr_39284 = state_39278;
(statearr_39284[(4)] = cljs.core.cons((5),(state_39278[(4)])));

return statearr_39284;
})();
var inst_39250 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_39278__$1 = state_39278;
if(cljs.core.truth_(inst_39250)){
var statearr_39285_39379 = state_39278__$1;
(statearr_39285_39379[(1)] = (6));

} else {
var statearr_39286_39380 = state_39278__$1;
(statearr_39286_39380[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (11))){
var inst_39265 = [cljs.core.cst$kw$_id];
var inst_39266 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39267 = [inst_39266];
var inst_39268 = cljs.core.PersistentHashMap.fromArrays(inst_39265,inst_39267);
var state_39278__$1 = state_39278;
var statearr_39288_39381 = state_39278__$1;
(statearr_39288_39381[(2)] = inst_39268);

(statearr_39288_39381[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (9))){
var inst_39262 = (state_39278[(7)]);
var inst_39261 = (state_39278[(2)]);
var inst_39262__$1 = fluree.db.util.async.throw_err(inst_39261);
var state_39278__$1 = (function (){var statearr_39289 = state_39278;
(statearr_39289[(7)] = inst_39262__$1);

return statearr_39289;
})();
if(cljs.core.truth_(inst_39262__$1)){
var statearr_39290_39382 = state_39278__$1;
(statearr_39290_39382[(1)] = (10));

} else {
var statearr_39291_39383 = state_39278__$1;
(statearr_39291_39383[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (5))){
var _ = (function (){var statearr_39292 = state_39278;
(statearr_39292[(4)] = cljs.core.rest((state_39278[(4)])));

return statearr_39292;
})();
var state_39278__$1 = state_39278;
var ex39287 = (state_39278__$1[(2)]);
var statearr_39293_39384 = state_39278__$1;
(statearr_39293_39384[(5)] = ex39287);


if((ex39287 instanceof Error)){
var statearr_39294_39385 = state_39278__$1;
(statearr_39294_39385[(1)] = (4));

(statearr_39294_39385[(5)] = null);

} else {
throw ex39287;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (10))){
var inst_39262 = (state_39278[(7)]);
var state_39278__$1 = state_39278;
var statearr_39295_39386 = state_39278__$1;
(statearr_39295_39386[(2)] = inst_39262);

(statearr_39295_39386[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39279 === (8))){
var inst_39273 = (state_39278[(2)]);
var _ = (function (){var statearr_39296 = state_39278;
(statearr_39296[(4)] = cljs.core.rest((state_39278[(4)])));

return statearr_39296;
})();
var state_39278__$1 = state_39278;
var statearr_39297_39387 = state_39278__$1;
(statearr_39297_39387[(2)] = inst_39273);

(statearr_39297_39387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_39298 = [null,null,null,null,null,null,null,null];
(statearr_39298[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__);

(statearr_39298[(1)] = (1));

return statearr_39298;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1 = (function (state_39278){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39278);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39299){var ex__17136__auto__ = e39299;
var statearr_39300_39388 = state_39278;
(statearr_39300_39388[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39278[(4)]))){
var statearr_39301_39389 = state_39278;
(statearr_39301_39389[(1)] = cljs.core.first((state_39278[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39390 = state_39278;
state_39278 = G__39390;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = function(state_39278){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1.call(this,state_39278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39302 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39302[(6)] = c__17207__auto____$1);

return statearr_39302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto____$1;
});
} else {
return (function (tuple){
var c__17207__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39314){
var state_val_39315 = (state_39314[(1)]);
if((state_val_39315 === (1))){
var state_39314__$1 = state_39314;
var statearr_39316_39391 = state_39314__$1;
(statearr_39316_39391[(2)] = null);

(statearr_39316_39391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39315 === (2))){
var _ = (function (){var statearr_39317 = state_39314;
(statearr_39317[(4)] = cljs.core.cons((5),(state_39314[(4)])));

return statearr_39317;
})();
var inst_39309 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_39318 = state_39314;
(statearr_39318[(4)] = cljs.core.rest((state_39314[(4)])));

return statearr_39318;
})();
var state_39314__$1 = state_39314;
var statearr_39319_39392 = state_39314__$1;
(statearr_39319_39392[(2)] = inst_39309);

(statearr_39319_39392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39315 === (3))){
var inst_39312 = (state_39314[(2)]);
var state_39314__$1 = state_39314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39314__$1,inst_39312);
} else {
if((state_val_39315 === (4))){
var inst_39303 = (state_39314[(2)]);
var state_39314__$1 = state_39314;
var statearr_39321_39393 = state_39314__$1;
(statearr_39321_39393[(2)] = inst_39303);

(statearr_39321_39393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39315 === (5))){
var _ = (function (){var statearr_39322 = state_39314;
(statearr_39322[(4)] = cljs.core.rest((state_39314[(4)])));

return statearr_39322;
})();
var state_39314__$1 = state_39314;
var ex39320 = (state_39314__$1[(2)]);
var statearr_39323_39394 = state_39314__$1;
(statearr_39323_39394[(5)] = ex39320);


if((ex39320 instanceof Error)){
var statearr_39324_39395 = state_39314__$1;
(statearr_39324_39395[(1)] = (4));

(statearr_39324_39395[(5)] = null);

} else {
throw ex39320;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_39325 = [null,null,null,null,null,null,null];
(statearr_39325[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__);

(statearr_39325[(1)] = (1));

return statearr_39325;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1 = (function (state_39314){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39314);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39326){var ex__17136__auto__ = e39326;
var statearr_39327_39396 = state_39314;
(statearr_39327_39396[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39314[(4)]))){
var statearr_39328_39397 = state_39314;
(statearr_39328_39397[(1)] = cljs.core.first((state_39314[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39398 = state_39314;
state_39314 = G__39398;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = function(state_39314){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1.call(this,state_39314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39329 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39329[(6)] = c__17207__auto____$1);

return statearr_39329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto____$1;
});
}
});
})();
var inst_39129 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39128,select);
var state_39201__$1 = state_39201;
var statearr_39330_39399 = state_39201__$1;
(statearr_39330_39399[(2)] = inst_39129);

(statearr_39330_39399[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (5))){
var _ = (function (){var statearr_39331 = state_39201;
(statearr_39331[(4)] = cljs.core.rest((state_39201[(4)])));

return statearr_39331;
})();
var state_39201__$1 = state_39201;
var ex39240 = (state_39201__$1[(2)]);
var statearr_39332_39400 = state_39201__$1;
(statearr_39332_39400[(5)] = ex39240);


if((ex39240 instanceof Error)){
var statearr_39333_39401 = state_39201__$1;
(statearr_39333_39401[(1)] = (4));

(statearr_39333_39401[(5)] = null);

} else {
throw ex39240;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (14))){
var inst_39196 = (state_39201[(2)]);
var _ = (function (){var statearr_39334 = state_39201;
(statearr_39334[(4)] = cljs.core.rest((state_39201[(4)])));

return statearr_39334;
})();
var state_39201__$1 = state_39201;
var statearr_39335_39402 = state_39201__$1;
(statearr_39335_39402[(2)] = inst_39196);

(statearr_39335_39402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (10))){
var inst_39126 = (state_39201[(7)]);
var inst_39131 = (function (){var pp = inst_39126;
return (function (select__$1){
var temp__5752__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5752__auto__)){
var val = temp__5752__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_39132 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39131,select);
var state_39201__$1 = state_39201;
var statearr_39336_39403 = state_39201__$1;
(statearr_39336_39403[(2)] = inst_39132);

(statearr_39336_39403[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39202 === (8))){
var inst_39126 = (state_39201[(2)]);
var state_39201__$1 = (function (){var statearr_39337 = state_39201;
(statearr_39337[(7)] = inst_39126);

return statearr_39337;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39338_39404 = state_39201__$1;
(statearr_39338_39404[(1)] = (9));

} else {
var statearr_39339_39405 = state_39201__$1;
(statearr_39339_39405[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0 = (function (){
var statearr_39340 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39340[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__);

(statearr_39340[(1)] = (1));

return statearr_39340;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1 = (function (state_39201){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39201);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39341){var ex__17136__auto__ = e39341;
var statearr_39342_39406 = state_39201;
(statearr_39342_39406[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39201[(4)]))){
var statearr_39343_39407 = state_39201;
(statearr_39343_39407[(1)] = cljs.core.first((state_39201[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39408 = state_39201;
state_39201 = G__39408;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__ = function(state_39201){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1.call(this,state_39201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39344 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39344[(6)] = c__17207__auto__);

return statearr_39344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__39410 = arguments.length;
switch (G__39410) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__39411,p__39412,group_limit,opts){
var map__39413 = p__39411;
var map__39413__$1 = (((((!((map__39413 == null))))?(((((map__39413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39413):map__39413);
var res = map__39413__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39413__$1,cljs.core.cst$kw$vars);
var map__39414 = p__39412;
var map__39414__$1 = (((((!((map__39414 == null))))?(((((map__39414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39414):map__39414);
var select_spec = map__39414__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39414__$1,cljs.core.cst$kw$groupBy);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39510){
var state_val_39511 = (state_39510[(1)]);
if((state_val_39511 === (7))){
var inst_39423 = (state_39510[(7)]);
var state_39510__$1 = state_39510;
var statearr_39512_39578 = state_39510__$1;
(statearr_39512_39578[(2)] = inst_39423);

(statearr_39512_39578[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (20))){
var inst_39458 = (state_39510[(2)]);
var state_39510__$1 = (function (){var statearr_39513 = state_39510;
(statearr_39513[(8)] = inst_39458);

return statearr_39513;
})();
if(cljs.core.truth_(groupBy)){
var statearr_39514_39579 = state_39510__$1;
(statearr_39514_39579[(1)] = (21));

} else {
var statearr_39515_39580 = state_39510__$1;
(statearr_39515_39580[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (27))){
var inst_39467 = (state_39510[(9)]);
var inst_39472 = inst_39467.cljs$lang$protocol_mask$partition0$;
var inst_39473 = (inst_39472 & (64));
var inst_39474 = inst_39467.cljs$core$ISeq$;
var inst_39475 = (cljs.core.PROTOCOL_SENTINEL === inst_39474);
var inst_39476 = ((inst_39473) || (inst_39475));
var state_39510__$1 = state_39510;
if(cljs.core.truth_(inst_39476)){
var statearr_39516_39581 = state_39510__$1;
(statearr_39516_39581[(1)] = (30));

} else {
var statearr_39517_39582 = state_39510__$1;
(statearr_39517_39582[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (1))){
var state_39510__$1 = state_39510;
var statearr_39518_39583 = state_39510__$1;
(statearr_39518_39583[(2)] = null);

(statearr_39518_39583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (24))){
var inst_39458 = (state_39510[(8)]);
var inst_39462 = (state_39510[(10)]);
var inst_39464 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_39458,inst_39462,group_limit);
var state_39510__$1 = state_39510;
var statearr_39519_39584 = state_39510__$1;
(statearr_39519_39584[(2)] = inst_39464);

(statearr_39519_39584[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (39))){
var inst_39503 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
var statearr_39520_39585 = state_39510__$1;
(statearr_39520_39585[(2)] = inst_39503);

(statearr_39520_39585[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (4))){
var inst_39417 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
var statearr_39521_39586 = state_39510__$1;
(statearr_39521_39586[(2)] = inst_39417);

(statearr_39521_39586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (15))){
var inst_39444 = (state_39510[(11)]);
var inst_39446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39447 = [inst_39444];
var inst_39448 = (new cljs.core.PersistentVector(null,1,(5),inst_39446,inst_39447,null));
var state_39510__$1 = state_39510;
var statearr_39522_39587 = state_39510__$1;
(statearr_39522_39587[(2)] = inst_39448);

(statearr_39522_39587[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (21))){
var state_39510__$1 = state_39510;
var statearr_39523_39588 = state_39510__$1;
(statearr_39523_39588[(2)] = (0));

(statearr_39523_39588[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (31))){
var state_39510__$1 = state_39510;
var statearr_39524_39589 = state_39510__$1;
(statearr_39524_39589[(2)] = false);

(statearr_39524_39589[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (32))){
var inst_39480 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
var statearr_39525_39590 = state_39510__$1;
(statearr_39525_39590[(2)] = inst_39480);

(statearr_39525_39590[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (33))){
var inst_39467 = (state_39510[(9)]);
var inst_39485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39467);
var state_39510__$1 = state_39510;
var statearr_39526_39591 = state_39510__$1;
(statearr_39526_39591[(2)] = inst_39485);

(statearr_39526_39591[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (13))){
var inst_39433 = (state_39510[(12)]);
var state_39510__$1 = state_39510;
var statearr_39527_39592 = state_39510__$1;
(statearr_39527_39592[(2)] = inst_39433);

(statearr_39527_39592[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (22))){
var state_39510__$1 = state_39510;
var statearr_39528_39593 = state_39510__$1;
(statearr_39528_39593[(2)] = offset);

(statearr_39528_39593[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (36))){
var inst_39494 = (state_39510[(2)]);
var inst_39495 = fluree.db.util.async.throw_err(inst_39494);
var state_39510__$1 = (function (){var statearr_39529 = state_39510;
(statearr_39529[(13)] = inst_39495);

return statearr_39529;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39530_39594 = state_39510__$1;
(statearr_39530_39594[(1)] = (37));

} else {
var statearr_39531_39595 = state_39510__$1;
(statearr_39531_39595[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (29))){
var inst_39483 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
if(cljs.core.truth_(inst_39483)){
var statearr_39532_39596 = state_39510__$1;
(statearr_39532_39596[(1)] = (33));

} else {
var statearr_39533_39597 = state_39510__$1;
(statearr_39533_39597[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (6))){
var inst_39425 = cljs.core.count(select);
var inst_39426 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_39425);
var state_39510__$1 = state_39510;
var statearr_39534_39598 = state_39510__$1;
(statearr_39534_39598[(2)] = inst_39426);

(statearr_39534_39598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (28))){
var state_39510__$1 = state_39510;
var statearr_39535_39599 = state_39510__$1;
(statearr_39535_39599[(2)] = false);

(statearr_39535_39599[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (25))){
var inst_39458 = (state_39510[(8)]);
var state_39510__$1 = state_39510;
var statearr_39536_39600 = state_39510__$1;
(statearr_39536_39600[(2)] = inst_39458);

(statearr_39536_39600[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (34))){
var inst_39467 = (state_39510[(9)]);
var state_39510__$1 = state_39510;
var statearr_39537_39601 = state_39510__$1;
(statearr_39537_39601[(2)] = inst_39467);

(statearr_39537_39601[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (17))){
var inst_39451 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
var statearr_39538_39602 = state_39510__$1;
(statearr_39538_39602[(2)] = inst_39451);

(statearr_39538_39602[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (3))){
var inst_39508 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39510__$1,inst_39508);
} else {
if((state_val_39511 === (12))){
var inst_39433 = (state_39510[(12)]);
var inst_39435 = cljs.core.first(select);
var inst_39436 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_39435);
var inst_39437 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39436);
var inst_39438 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_39437,(1));
var inst_39439 = [inst_39438];
var inst_39440 = [inst_39433];
var inst_39441 = cljs.core.PersistentHashMap.fromArrays(inst_39439,inst_39440);
var state_39510__$1 = state_39510;
var statearr_39539_39603 = state_39510__$1;
(statearr_39539_39603[(2)] = inst_39441);

(statearr_39539_39603[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (2))){
var inst_39423 = (state_39510[(7)]);
var _ = (function (){var statearr_39540 = state_39510;
(statearr_39540[(4)] = cljs.core.cons((5),(state_39510[(4)])));

return statearr_39540;
})();
var inst_39423__$1 = aggregates;
var state_39510__$1 = (function (){var statearr_39541 = state_39510;
(statearr_39541[(7)] = inst_39423__$1);

return statearr_39541;
})();
if(cljs.core.truth_(inst_39423__$1)){
var statearr_39542_39604 = state_39510__$1;
(statearr_39542_39604[(1)] = (6));

} else {
var statearr_39543_39605 = state_39510__$1;
(statearr_39543_39605[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (23))){
var inst_39462 = (state_39510[(2)]);
var state_39510__$1 = (function (){var statearr_39544 = state_39510;
(statearr_39544[(10)] = inst_39462);

return statearr_39544;
})();
if(cljs.core.truth_(orderBy)){
var statearr_39545_39606 = state_39510__$1;
(statearr_39545_39606[(1)] = (24));

} else {
var statearr_39546_39607 = state_39510__$1;
(statearr_39546_39607[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (35))){
var inst_39488 = (state_39510[(2)]);
var inst_39489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39488,cljs.core.cst$kw$headers);
var inst_39490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39488,cljs.core.cst$kw$tuples);
var inst_39491 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_39492 = fluree.db.query.fql.format_filter_tuples(db,inst_39490,select_spec,inst_39489,vars,inst_39491);
var state_39510__$1 = state_39510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39510__$1,(36),inst_39492);
} else {
if((state_val_39511 === (19))){
var state_39510__$1 = state_39510;
var statearr_39547_39608 = state_39510__$1;
(statearr_39547_39608[(2)] = res);

(statearr_39547_39608[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (11))){
var inst_39505 = (state_39510[(2)]);
var _ = (function (){var statearr_39549 = state_39510;
(statearr_39549[(4)] = cljs.core.rest((state_39510[(4)])));

return statearr_39549;
})();
var state_39510__$1 = state_39510;
var statearr_39550_39609 = state_39510__$1;
(statearr_39550_39609[(2)] = inst_39505);

(statearr_39550_39609[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (9))){
var inst_39431 = cljs.core.first(aggregates);
var inst_39432 = fluree.db.query.analytical.calculate_aggregate(res,inst_39431);
var inst_39433 = cljs.core.second(inst_39432);
var state_39510__$1 = (function (){var statearr_39551 = state_39510;
(statearr_39551[(12)] = inst_39433);

return statearr_39551;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39552_39610 = state_39510__$1;
(statearr_39552_39610[(1)] = (12));

} else {
var statearr_39553_39611 = state_39510__$1;
(statearr_39553_39611[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (5))){
var _ = (function (){var statearr_39554 = state_39510;
(statearr_39554[(4)] = cljs.core.rest((state_39510[(4)])));

return statearr_39554;
})();
var state_39510__$1 = state_39510;
var ex39548 = (state_39510__$1[(2)]);
var statearr_39555_39612 = state_39510__$1;
(statearr_39555_39612[(5)] = ex39548);


if((ex39548 instanceof Error)){
var statearr_39556_39613 = state_39510__$1;
(statearr_39556_39613[(1)] = (4));

(statearr_39556_39613[(5)] = null);

} else {
throw ex39548;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (14))){
var inst_39444 = (state_39510[(2)]);
var state_39510__$1 = (function (){var statearr_39557 = state_39510;
(statearr_39557[(11)] = inst_39444);

return statearr_39557;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39558_39614 = state_39510__$1;
(statearr_39558_39614[(1)] = (15));

} else {
var statearr_39559_39615 = state_39510__$1;
(statearr_39559_39615[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (26))){
var inst_39467 = (state_39510[(9)]);
var inst_39467__$1 = (state_39510[(2)]);
var inst_39469 = (inst_39467__$1 == null);
var inst_39470 = cljs.core.not(inst_39469);
var state_39510__$1 = (function (){var statearr_39560 = state_39510;
(statearr_39560[(9)] = inst_39467__$1);

return statearr_39560;
})();
if(inst_39470){
var statearr_39561_39616 = state_39510__$1;
(statearr_39561_39616[(1)] = (27));

} else {
var statearr_39562_39617 = state_39510__$1;
(statearr_39562_39617[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (16))){
var inst_39444 = (state_39510[(11)]);
var state_39510__$1 = state_39510;
var statearr_39563_39618 = state_39510__$1;
(statearr_39563_39618[(2)] = inst_39444);

(statearr_39563_39618[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (38))){
var inst_39495 = (state_39510[(13)]);
var state_39510__$1 = state_39510;
var statearr_39564_39619 = state_39510__$1;
(statearr_39564_39619[(2)] = inst_39495);

(statearr_39564_39619[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (30))){
var state_39510__$1 = state_39510;
var statearr_39565_39620 = state_39510__$1;
(statearr_39565_39620[(2)] = true);

(statearr_39565_39620[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (10))){
var state_39510__$1 = state_39510;
if(cljs.core.truth_(aggregates)){
var statearr_39566_39621 = state_39510__$1;
(statearr_39566_39621[(1)] = (18));

} else {
var statearr_39567_39622 = state_39510__$1;
(statearr_39567_39622[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (18))){
var inst_39455 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_39510__$1 = state_39510;
var statearr_39568_39623 = state_39510__$1;
(statearr_39568_39623[(2)] = inst_39455);

(statearr_39568_39623[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (37))){
var inst_39495 = (state_39510[(13)]);
var inst_39497 = cljs.core.PersistentVector.EMPTY;
var inst_39498 = cljs.core.PersistentHashSet.EMPTY;
var inst_39499 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39498,inst_39495);
var inst_39500 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39497,inst_39499);
var state_39510__$1 = state_39510;
var statearr_39569_39624 = state_39510__$1;
(statearr_39569_39624[(2)] = inst_39500);

(statearr_39569_39624[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39511 === (8))){
var inst_39429 = (state_39510[(2)]);
var state_39510__$1 = state_39510;
if(cljs.core.truth_(inst_39429)){
var statearr_39570_39625 = state_39510__$1;
(statearr_39570_39625[(1)] = (9));

} else {
var statearr_39571_39626 = state_39510__$1;
(statearr_39571_39626[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__17133__auto__ = null;
var fluree$db$query$fql$state_machine__17133__auto____0 = (function (){
var statearr_39572 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39572[(0)] = fluree$db$query$fql$state_machine__17133__auto__);

(statearr_39572[(1)] = (1));

return statearr_39572;
});
var fluree$db$query$fql$state_machine__17133__auto____1 = (function (state_39510){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39510);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39573){var ex__17136__auto__ = e39573;
var statearr_39574_39627 = state_39510;
(statearr_39574_39627[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39510[(4)]))){
var statearr_39575_39628 = state_39510;
(statearr_39575_39628[(1)] = cljs.core.first((state_39510[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__39629 = state_39510;
state_39510 = G__39629;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__17133__auto__ = function(state_39510){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__17133__auto____1.call(this,state_39510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__17133__auto____0;
fluree$db$query$fql$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__17133__auto____1;
return fluree$db$query$fql$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_39576 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_39576[(6)] = c__17207__auto__);

return statearr_39576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__39632,groupBy){
var map__39633 = p__39632;
var map__39633__$1 = (((((!((map__39633 == null))))?(((((map__39633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39633.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39633):map__39633);
var res = map__39633__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39633__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39633__$1,cljs.core.cst$kw$tuples);
var vec__39635 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39635,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39635,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39630_SHARP_){
return fluree.db.util.core.index_of(headers,p1__39630_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39631_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__39631_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__39638 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39638,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39638,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__39641,p__39642,opts){
var map__39643 = p__39641;
var map__39643__$1 = (((((!((map__39643 == null))))?(((((map__39643.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39643.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39643):map__39643);
var res = map__39643__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39643__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39643__$1,cljs.core.cst$kw$vars);
var map__39644 = p__39642;
var map__39644__$1 = (((((!((map__39644 == null))))?(((((map__39644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39644):map__39644);
var select_spec = map__39644__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39644__$1,cljs.core.cst$kw$offset);
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_39866){
var state_val_39867 = (state_39866[(1)]);
if((state_val_39867 === (65))){
var inst_39725 = (state_39866[(7)]);
var inst_39716 = (state_39866[(8)]);
var inst_39777 = (state_39866[(9)]);
var inst_39807 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39716,inst_39725,inst_39777);
var state_39866__$1 = state_39866;
var statearr_39868_40001 = state_39866__$1;
(statearr_39868_40001[(2)] = inst_39807);

(statearr_39868_40001[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (70))){
var inst_39832 = (state_39866[(10)]);
var inst_39831 = (state_39866[(2)]);
var inst_39832__$1 = fluree.db.util.async.throw_err(inst_39831);
var inst_39833 = cljs.core.coll_QMARK_(inst_39832__$1);
var inst_39834 = (!(inst_39833));
var state_39866__$1 = (function (){var statearr_39869 = state_39866;
(statearr_39869[(10)] = inst_39832__$1);

return statearr_39869;
})();
if(inst_39834){
var statearr_39870_40002 = state_39866__$1;
(statearr_39870_40002[(1)] = (71));

} else {
var statearr_39871_40003 = state_39866__$1;
(statearr_39871_40003[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (62))){
var state_39866__$1 = state_39866;
var statearr_39872_40004 = state_39866__$1;
(statearr_39872_40004[(2)] = null);

(statearr_39872_40004[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (74))){
var inst_39832 = (state_39866[(10)]);
var inst_39837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39838 = [inst_39832];
var inst_39839 = (new cljs.core.PersistentVector(null,1,(5),inst_39837,inst_39838,null));
var state_39866__$1 = state_39866;
var statearr_39873_40005 = state_39866__$1;
(statearr_39873_40005[(2)] = inst_39839);

(statearr_39873_40005[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (7))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39874_40006 = state_39866__$1;
(statearr_39874_40006[(1)] = (67));

} else {
var statearr_39875_40007 = state_39866__$1;
(statearr_39875_40007[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (59))){
var state_39866__$1 = state_39866;
var statearr_39876_40008 = state_39866__$1;
(statearr_39876_40008[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (20))){
var state_39866__$1 = state_39866;
var statearr_39878_40009 = state_39866__$1;
(statearr_39878_40009[(2)] = (0));

(statearr_39878_40009[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (72))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39879_40010 = state_39866__$1;
(statearr_39879_40010[(1)] = (77));

} else {
var statearr_39880_40011 = state_39866__$1;
(statearr_39880_40011[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (58))){
var inst_39715 = (state_39866[(11)]);
var inst_39789 = (inst_39715 - (1));
var state_39866__$1 = state_39866;
var statearr_39881_40012 = state_39866__$1;
(statearr_39881_40012[(2)] = inst_39789);

(statearr_39881_40012[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (60))){
var inst_39799 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39882_40013 = state_39866__$1;
(statearr_39882_40013[(2)] = inst_39799);

(statearr_39882_40013[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (27))){
var inst_39714 = (state_39866[(12)]);
var inst_39738 = (inst_39714 < (1));
var state_39866__$1 = state_39866;
var statearr_39883_40014 = state_39866__$1;
(statearr_39883_40014[(2)] = inst_39738);

(statearr_39883_40014[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (1))){
var state_39866__$1 = state_39866;
var statearr_39884_40015 = state_39866__$1;
(statearr_39884_40015[(2)] = null);

(statearr_39884_40015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (69))){
var inst_39828 = (state_39866[(2)]);
var inst_39829 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_39828,opts);
var state_39866__$1 = state_39866;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39866__$1,(70),inst_39829);
} else {
if((state_val_39867 === (24))){
var inst_39716 = (state_39866[(8)]);
var state_39866__$1 = state_39866;
var statearr_39885_40016 = state_39866__$1;
(statearr_39885_40016[(2)] = inst_39716);

(statearr_39885_40016[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (55))){
var state_39866__$1 = state_39866;
var statearr_39886_40017 = state_39866__$1;
(statearr_39886_40017[(2)] = (0));

(statearr_39886_40017[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (85))){
var inst_39853 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39887_40018 = state_39866__$1;
(statearr_39887_40018[(2)] = inst_39853);

(statearr_39887_40018[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (39))){
var inst_39733 = (state_39866[(13)]);
var inst_39756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,(0)], 0));
var inst_39757 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,(0)], 0));
var inst_39758 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_39733,inst_39756,inst_39757);
var state_39866__$1 = state_39866;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39866__$1,(42),inst_39758);
} else {
if((state_val_39867 === (46))){
var inst_39714 = (state_39866[(12)]);
var inst_39769 = ((0) < inst_39714);
var state_39866__$1 = state_39866;
var statearr_39888_40019 = state_39866__$1;
(statearr_39888_40019[(2)] = inst_39769);

(statearr_39888_40019[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (4))){
var inst_39647 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39889_40020 = state_39866__$1;
(statearr_39889_40020[(2)] = inst_39647);

(statearr_39889_40020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (77))){
var inst_39832 = (state_39866[(10)]);
var inst_39845 = cljs.core.first(inst_39832);
var state_39866__$1 = state_39866;
var statearr_39890_40021 = state_39866__$1;
(statearr_39890_40021[(2)] = inst_39845);

(statearr_39890_40021[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (54))){
var inst_39715 = (state_39866[(11)]);
var inst_39784 = (state_39866[(2)]);
var inst_39785 = (inst_39715 <= (0));
var state_39866__$1 = (function (){var statearr_39891 = state_39866;
(statearr_39891[(14)] = inst_39784);

return statearr_39891;
})();
if(cljs.core.truth_(inst_39785)){
var statearr_39892_40022 = state_39866__$1;
(statearr_39892_40022[(1)] = (55));

} else {
var statearr_39893_40023 = state_39866__$1;
(statearr_39893_40023[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (15))){
var inst_39665 = (state_39866[(15)]);
var inst_39673 = (state_39866[(2)]);
var inst_39674 = fluree.db.util.async.throw_err(inst_39673);
var inst_39675 = [inst_39665];
var inst_39676 = [inst_39674];
var inst_39677 = cljs.core.PersistentHashMap.fromArrays(inst_39675,inst_39676);
var state_39866__$1 = state_39866;
var statearr_39894_40024 = state_39866__$1;
(statearr_39894_40024[(2)] = inst_39677);

(statearr_39894_40024[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (48))){
var inst_39772 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
if(cljs.core.truth_(inst_39772)){
var statearr_39895_40025 = state_39866__$1;
(statearr_39895_40025[(1)] = (49));

} else {
var statearr_39896_40026 = state_39866__$1;
(statearr_39896_40026[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (50))){
var inst_39767 = (state_39866[(16)]);
var state_39866__$1 = state_39866;
var statearr_39897_40027 = state_39866__$1;
(statearr_39897_40027[(2)] = inst_39767);

(statearr_39897_40027[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (75))){
var inst_39832 = (state_39866[(10)]);
var state_39866__$1 = state_39866;
var statearr_39898_40028 = state_39866__$1;
(statearr_39898_40028[(2)] = inst_39832);

(statearr_39898_40028[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (21))){
var inst_39697 = (state_39866[(17)]);
var inst_39693 = (state_39866[(18)]);
var inst_39705 = (state_39866[(19)]);
var inst_39710 = (state_39866[(2)]);
var inst_39711 = cljs.core.PersistentHashMap.EMPTY;
var inst_39712 = inst_39693;
var inst_39713 = inst_39697;
var inst_39714 = inst_39705;
var inst_39715 = inst_39710;
var inst_39716 = inst_39711;
var state_39866__$1 = (function (){var statearr_39899 = state_39866;
(statearr_39899[(12)] = inst_39714);

(statearr_39899[(20)] = inst_39713);

(statearr_39899[(21)] = inst_39712);

(statearr_39899[(8)] = inst_39716);

(statearr_39899[(11)] = inst_39715);

return statearr_39899;
})();
var statearr_39900_40029 = state_39866__$1;
(statearr_39900_40029[(2)] = null);

(statearr_39900_40029[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (31))){
var inst_39730 = (state_39866[(22)]);
var inst_39715 = (state_39866[(11)]);
var inst_39744 = (inst_39715 >= inst_39730);
var state_39866__$1 = state_39866;
if(cljs.core.truth_(inst_39744)){
var statearr_39901_40030 = state_39866__$1;
(statearr_39901_40030[(1)] = (33));

} else {
var statearr_39902_40031 = state_39866__$1;
(statearr_39902_40031[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (32))){
var inst_39817 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39903_40032 = state_39866__$1;
(statearr_39903_40032[(2)] = inst_39817);

(statearr_39903_40032[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (40))){
var state_39866__$1 = state_39866;
var statearr_39904_40033 = state_39866__$1;
(statearr_39904_40033[(2)] = null);

(statearr_39904_40033[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (56))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39905_40034 = state_39866__$1;
(statearr_39905_40034[(1)] = (58));

} else {
var statearr_39906_40035 = state_39866__$1;
(statearr_39906_40035[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (33))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39907_40036 = state_39866__$1;
(statearr_39907_40036[(1)] = (36));

} else {
var statearr_39908_40037 = state_39866__$1;
(statearr_39908_40037[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (13))){
var inst_39662 = (state_39866[(23)]);
var inst_39697 = (state_39866[(17)]);
var inst_39693 = (state_39866[(18)]);
var inst_39693__$1 = cljs.core.keys(inst_39662);
var inst_39694 = cljs.core.seq(inst_39693__$1);
var inst_39695 = cljs.core.first(inst_39694);
var inst_39696 = cljs.core.next(inst_39694);
var inst_39697__$1 = cljs.core.vals(inst_39662);
var inst_39698 = cljs.core.seq(inst_39697__$1);
var inst_39699 = cljs.core.first(inst_39698);
var inst_39700 = cljs.core.next(inst_39698);
var inst_39701 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_39866__$1 = (function (){var statearr_39909 = state_39866;
(statearr_39909[(24)] = inst_39700);

(statearr_39909[(25)] = inst_39695);

(statearr_39909[(17)] = inst_39697__$1);

(statearr_39909[(18)] = inst_39693__$1);

(statearr_39909[(26)] = inst_39696);

(statearr_39909[(27)] = inst_39699);

return statearr_39909;
})();
if(inst_39701){
var statearr_39910_40038 = state_39866__$1;
(statearr_39910_40038[(1)] = (16));

} else {
var statearr_39911_40039 = state_39866__$1;
(statearr_39911_40039[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (22))){
var inst_39713 = (state_39866[(20)]);
var inst_39712 = (state_39866[(21)]);
var inst_39724 = cljs.core.seq(inst_39712);
var inst_39725 = cljs.core.first(inst_39724);
var inst_39726 = cljs.core.next(inst_39724);
var inst_39727 = cljs.core.seq(inst_39713);
var inst_39728 = cljs.core.first(inst_39727);
var inst_39729 = cljs.core.next(inst_39727);
var inst_39730 = cljs.core.count(inst_39728);
var inst_39731 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39732 = [headers,vars,inst_39728];
var inst_39733 = cljs.core.PersistentHashMap.fromArrays(inst_39731,inst_39732);
var inst_39734 = (inst_39728 == null);
var state_39866__$1 = (function (){var statearr_39912 = state_39866;
(statearr_39912[(22)] = inst_39730);

(statearr_39912[(7)] = inst_39725);

(statearr_39912[(13)] = inst_39733);

(statearr_39912[(28)] = inst_39729);

(statearr_39912[(29)] = inst_39726);

return statearr_39912;
})();
if(cljs.core.truth_(inst_39734)){
var statearr_39913_40040 = state_39866__$1;
(statearr_39913_40040[(1)] = (24));

} else {
var statearr_39914_40041 = state_39866__$1;
(statearr_39914_40041[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (36))){
var inst_39715 = (state_39866[(11)]);
var inst_39747 = (inst_39715 - (1));
var state_39866__$1 = state_39866;
var statearr_39915_40042 = state_39866__$1;
(statearr_39915_40042[(2)] = inst_39747);

(statearr_39915_40042[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (41))){
var inst_39813 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39916_40043 = state_39866__$1;
(statearr_39916_40043[(2)] = inst_39813);

(statearr_39916_40043[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (43))){
var inst_39761 = (state_39866[(30)]);
var inst_39715 = (state_39866[(11)]);
var inst_39764 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_39715,inst_39761);
var state_39866__$1 = state_39866;
var statearr_39917_40044 = state_39866__$1;
(statearr_39917_40044[(2)] = inst_39764);

(statearr_39917_40044[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (61))){
var inst_39730 = (state_39866[(22)]);
var inst_39715 = (state_39866[(11)]);
var inst_39777 = (state_39866[(9)]);
var inst_39792 = cljs.core.count(inst_39777);
var inst_39793 = (inst_39730 - inst_39792);
var inst_39794 = (inst_39715 - inst_39793);
var state_39866__$1 = state_39866;
var statearr_39918_40045 = state_39866__$1;
(statearr_39918_40045[(2)] = inst_39794);

(statearr_39918_40045[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (29))){
var inst_39741 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
if(cljs.core.truth_(inst_39741)){
var statearr_39919_40046 = state_39866__$1;
(statearr_39919_40046[(1)] = (30));

} else {
var statearr_39920_40047 = state_39866__$1;
(statearr_39920_40047[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (44))){
var inst_39761 = (state_39866[(30)]);
var state_39866__$1 = state_39866;
var statearr_39921_40048 = state_39866__$1;
(statearr_39921_40048[(2)] = inst_39761);

(statearr_39921_40048[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (6))){
var inst_39654 = (state_39866[(31)]);
var inst_39654__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_39656 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_39866__$1 = (function (){var statearr_39922 = state_39866;
(statearr_39922[(32)] = inst_39656);

(statearr_39922[(31)] = inst_39654__$1);

return statearr_39922;
})();
if(cljs.core.truth_(inst_39654__$1)){
var statearr_39923_40049 = state_39866__$1;
(statearr_39923_40049[(1)] = (9));

} else {
var statearr_39924_40050 = state_39866__$1;
(statearr_39924_40050[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (28))){
var inst_39714 = (state_39866[(12)]);
var state_39866__$1 = state_39866;
var statearr_39925_40051 = state_39866__$1;
(statearr_39925_40051[(2)] = inst_39714);

(statearr_39925_40051[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (64))){
var inst_39716 = (state_39866[(8)]);
var state_39866__$1 = state_39866;
var statearr_39926_40052 = state_39866__$1;
(statearr_39926_40052[(2)] = inst_39716);

(statearr_39926_40052[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (51))){
var inst_39714 = (state_39866[(12)]);
var inst_39777 = (state_39866[(2)]);
var inst_39778 = (inst_39714 == null);
var state_39866__$1 = (function (){var statearr_39927 = state_39866;
(statearr_39927[(9)] = inst_39777);

return statearr_39927;
})();
if(cljs.core.truth_(inst_39778)){
var statearr_39928_40053 = state_39866__$1;
(statearr_39928_40053[(1)] = (52));

} else {
var statearr_39929_40054 = state_39866__$1;
(statearr_39929_40054[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (25))){
var inst_39714 = (state_39866[(12)]);
var state_39866__$1 = state_39866;
if(cljs.core.truth_(inst_39714)){
var statearr_39930_40055 = state_39866__$1;
(statearr_39930_40055[(1)] = (27));

} else {
var statearr_39931_40056 = state_39866__$1;
(statearr_39931_40056[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (34))){
var state_39866__$1 = state_39866;
var statearr_39932_40057 = state_39866__$1;
(statearr_39932_40057[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (17))){
var state_39866__$1 = state_39866;
var statearr_39934_40058 = state_39866__$1;
(statearr_39934_40058[(2)] = limit);

(statearr_39934_40058[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (3))){
var inst_39864 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39866__$1,inst_39864);
} else {
if((state_val_39867 === (12))){
var inst_39662 = (state_39866[(23)]);
var inst_39664 = cljs.core.keys(inst_39662);
var inst_39665 = cljs.core.first(inst_39664);
var inst_39666 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39667 = cljs.core.vals(inst_39662);
var inst_39668 = cljs.core.first(inst_39667);
var inst_39669 = [headers,vars,inst_39668];
var inst_39670 = cljs.core.PersistentHashMap.fromArrays(inst_39666,inst_39669);
var inst_39671 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_39670,select_spec,limit,opts);
var state_39866__$1 = (function (){var statearr_39935 = state_39866;
(statearr_39935[(15)] = inst_39665);

return statearr_39935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39866__$1,(15),inst_39671);
} else {
if((state_val_39867 === (2))){
var _ = (function (){var statearr_39936 = state_39866;
(statearr_39936[(4)] = cljs.core.cons((5),(state_39866[(4)])));

return statearr_39936;
})();
var state_39866__$1 = state_39866;
if(cljs.core.truth_(groupBy)){
var statearr_39937_40059 = state_39866__$1;
(statearr_39937_40059[(1)] = (6));

} else {
var statearr_39938_40060 = state_39866__$1;
(statearr_39938_40060[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (66))){
var inst_39784 = (state_39866[(14)]);
var inst_39729 = (state_39866[(28)]);
var inst_39801 = (state_39866[(33)]);
var inst_39726 = (state_39866[(29)]);
var inst_39809 = (state_39866[(2)]);
var inst_39712 = inst_39726;
var inst_39713 = inst_39729;
var inst_39714 = inst_39784;
var inst_39715 = inst_39801;
var inst_39716 = inst_39809;
var state_39866__$1 = (function (){var statearr_39939 = state_39866;
(statearr_39939[(12)] = inst_39714);

(statearr_39939[(20)] = inst_39713);

(statearr_39939[(21)] = inst_39712);

(statearr_39939[(8)] = inst_39716);

(statearr_39939[(11)] = inst_39715);

return statearr_39939;
})();
var statearr_39940_40061 = state_39866__$1;
(statearr_39940_40061[(2)] = null);

(statearr_39940_40061[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (23))){
var inst_39821 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39941_40062 = state_39866__$1;
(statearr_39941_40062[(2)] = inst_39821);

(statearr_39941_40062[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (47))){
var inst_39714 = (state_39866[(12)]);
var state_39866__$1 = state_39866;
var statearr_39942_40063 = state_39866__$1;
(statearr_39942_40063[(2)] = inst_39714);

(statearr_39942_40063[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (35))){
var inst_39815 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39943_40064 = state_39866__$1;
(statearr_39943_40064[(2)] = inst_39815);

(statearr_39943_40064[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (82))){
var inst_39855 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39944_40065 = state_39866__$1;
(statearr_39944_40065[(2)] = inst_39855);

(statearr_39944_40065[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (76))){
var inst_39842 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39945_40066 = state_39866__$1;
(statearr_39945_40066[(2)] = inst_39842);

(statearr_39945_40066[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (19))){
var inst_39706 = (state_39866[(34)]);
var state_39866__$1 = state_39866;
var statearr_39946_40067 = state_39866__$1;
(statearr_39946_40067[(2)] = inst_39706);

(statearr_39946_40067[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (57))){
var inst_39777 = (state_39866[(9)]);
var inst_39801 = (state_39866[(2)]);
var inst_39802 = (inst_39777 == null);
var inst_39803 = cljs.core.empty_QMARK_(inst_39777);
var inst_39804 = ((inst_39802) || (inst_39803));
var state_39866__$1 = (function (){var statearr_39947 = state_39866;
(statearr_39947[(33)] = inst_39801);

return statearr_39947;
})();
if(cljs.core.truth_(inst_39804)){
var statearr_39948_40068 = state_39866__$1;
(statearr_39948_40068[(1)] = (64));

} else {
var statearr_39949_40069 = state_39866__$1;
(statearr_39949_40069[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (68))){
var state_39866__$1 = state_39866;
var statearr_39950_40070 = state_39866__$1;
(statearr_39950_40070[(2)] = limit);

(statearr_39950_40070[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (11))){
var inst_39662 = (state_39866[(2)]);
var state_39866__$1 = (function (){var statearr_39952 = state_39866;
(statearr_39952[(23)] = inst_39662);

return statearr_39952;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39953_40071 = state_39866__$1;
(statearr_39953_40071[(1)] = (12));

} else {
var statearr_39954_40072 = state_39866__$1;
(statearr_39954_40072[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (9))){
var inst_39656 = (state_39866[(32)]);
var inst_39654 = (state_39866[(31)]);
var inst_39658 = cljs.core.sorted_map_by(inst_39654);
var inst_39659 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39658,inst_39656);
var state_39866__$1 = state_39866;
var statearr_39955_40073 = state_39866__$1;
(statearr_39955_40073[(2)] = inst_39659);

(statearr_39955_40073[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (5))){
var _ = (function (){var statearr_39956 = state_39866;
(statearr_39956[(4)] = cljs.core.rest((state_39866[(4)])));

return statearr_39956;
})();
var state_39866__$1 = state_39866;
var ex39951 = (state_39866__$1[(2)]);
var statearr_39957_40074 = state_39866__$1;
(statearr_39957_40074[(5)] = ex39951);


if((ex39951 instanceof Error)){
var statearr_39958_40075 = state_39866__$1;
(statearr_39958_40075[(1)] = (4));

(statearr_39958_40075[(5)] = null);

} else {
throw ex39951;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (83))){
var inst_39832 = (state_39866[(10)]);
var state_39866__$1 = state_39866;
var statearr_39959_40076 = state_39866__$1;
(statearr_39959_40076[(2)] = inst_39832);

(statearr_39959_40076[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (14))){
var inst_39823 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39960_40077 = state_39866__$1;
(statearr_39960_40077[(2)] = inst_39823);

(statearr_39960_40077[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (45))){
var inst_39714 = (state_39866[(12)]);
var inst_39767 = (state_39866[(2)]);
var state_39866__$1 = (function (){var statearr_39961 = state_39866;
(statearr_39961[(16)] = inst_39767);

return statearr_39961;
})();
if(cljs.core.truth_(inst_39714)){
var statearr_39962_40078 = state_39866__$1;
(statearr_39962_40078[(1)] = (46));

} else {
var statearr_39963_40079 = state_39866__$1;
(statearr_39963_40079[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (53))){
var inst_39714 = (state_39866[(12)]);
var inst_39777 = (state_39866[(9)]);
var inst_39781 = cljs.core.count(inst_39777);
var inst_39782 = (inst_39714 - inst_39781);
var state_39866__$1 = state_39866;
var statearr_39964_40080 = state_39866__$1;
(statearr_39964_40080[(2)] = inst_39782);

(statearr_39964_40080[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (78))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39965_40081 = state_39866__$1;
(statearr_39965_40081[(1)] = (80));

} else {
var statearr_39966_40082 = state_39866__$1;
(statearr_39966_40082[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (26))){
var inst_39819 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39967_40083 = state_39866__$1;
(statearr_39967_40083[(2)] = inst_39819);

(statearr_39967_40083[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (16))){
var state_39866__$1 = state_39866;
var statearr_39968_40084 = state_39866__$1;
(statearr_39968_40084[(2)] = null);

(statearr_39968_40084[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (81))){
var state_39866__$1 = state_39866;
var statearr_39971_40085 = state_39866__$1;
(statearr_39971_40085[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (79))){
var inst_39857 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39973_40086 = state_39866__$1;
(statearr_39973_40086[(2)] = inst_39857);

(statearr_39973_40086[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (38))){
var inst_39714 = (state_39866[(12)]);
var inst_39716 = (state_39866[(8)]);
var inst_39729 = (state_39866[(28)]);
var inst_39726 = (state_39866[(29)]);
var inst_39751 = (state_39866[(2)]);
var tmp39969 = inst_39714;
var tmp39970 = inst_39716;
var inst_39712 = inst_39726;
var inst_39713 = inst_39729;
var inst_39714__$1 = tmp39969;
var inst_39715 = inst_39751;
var inst_39716__$1 = tmp39970;
var state_39866__$1 = (function (){var statearr_39974 = state_39866;
(statearr_39974[(12)] = inst_39714__$1);

(statearr_39974[(20)] = inst_39713);

(statearr_39974[(21)] = inst_39712);

(statearr_39974[(8)] = inst_39716__$1);

(statearr_39974[(11)] = inst_39715);

return statearr_39974;
})();
var statearr_39975_40087 = state_39866__$1;
(statearr_39975_40087[(2)] = null);

(statearr_39975_40087[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (30))){
var inst_39716 = (state_39866[(8)]);
var state_39866__$1 = state_39866;
var statearr_39976_40088 = state_39866__$1;
(statearr_39976_40088[(2)] = inst_39716);

(statearr_39976_40088[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (73))){
var inst_39859 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39977_40089 = state_39866__$1;
(statearr_39977_40089[(2)] = inst_39859);

(statearr_39977_40089[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (10))){
var inst_39656 = (state_39866[(32)]);
var state_39866__$1 = state_39866;
var statearr_39978_40090 = state_39866__$1;
(statearr_39978_40090[(2)] = inst_39656);

(statearr_39978_40090[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (18))){
var inst_39706 = (state_39866[(34)]);
var inst_39705 = (state_39866[(2)]);
var inst_39706__$1 = offset;
var state_39866__$1 = (function (){var statearr_39979 = state_39866;
(statearr_39979[(19)] = inst_39705);

(statearr_39979[(34)] = inst_39706__$1);

return statearr_39979;
})();
if(cljs.core.truth_(inst_39706__$1)){
var statearr_39980_40091 = state_39866__$1;
(statearr_39980_40091[(1)] = (19));

} else {
var statearr_39981_40092 = state_39866__$1;
(statearr_39981_40092[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (52))){
var state_39866__$1 = state_39866;
var statearr_39982_40093 = state_39866__$1;
(statearr_39982_40093[(2)] = null);

(statearr_39982_40093[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (67))){
var state_39866__$1 = state_39866;
var statearr_39983_40094 = state_39866__$1;
(statearr_39983_40094[(2)] = (1));

(statearr_39983_40094[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (71))){
var state_39866__$1 = state_39866;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39984_40095 = state_39866__$1;
(statearr_39984_40095[(1)] = (74));

} else {
var statearr_39985_40096 = state_39866__$1;
(statearr_39985_40096[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (42))){
var inst_39715 = (state_39866[(11)]);
var inst_39760 = (state_39866[(2)]);
var inst_39761 = fluree.db.util.async.throw_err(inst_39760);
var inst_39762 = ((0) < inst_39715);
var state_39866__$1 = (function (){var statearr_39986 = state_39866;
(statearr_39986[(30)] = inst_39761);

return statearr_39986;
})();
if(cljs.core.truth_(inst_39762)){
var statearr_39987_40097 = state_39866__$1;
(statearr_39987_40097[(1)] = (43));

} else {
var statearr_39988_40098 = state_39866__$1;
(statearr_39988_40098[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (80))){
var inst_39832 = (state_39866[(10)]);
var inst_39848 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_39832);
var state_39866__$1 = state_39866;
var statearr_39989_40099 = state_39866__$1;
(statearr_39989_40099[(2)] = inst_39848);

(statearr_39989_40099[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (37))){
var inst_39730 = (state_39866[(22)]);
var inst_39715 = (state_39866[(11)]);
var inst_39749 = (inst_39715 - inst_39730);
var state_39866__$1 = state_39866;
var statearr_39990_40100 = state_39866__$1;
(statearr_39990_40100[(2)] = inst_39749);

(statearr_39990_40100[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (63))){
var inst_39797 = (state_39866[(2)]);
var state_39866__$1 = state_39866;
var statearr_39991_40101 = state_39866__$1;
(statearr_39991_40101[(2)] = inst_39797);

(statearr_39991_40101[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (8))){
var inst_39861 = (state_39866[(2)]);
var _ = (function (){var statearr_39992 = state_39866;
(statearr_39992[(4)] = cljs.core.rest((state_39866[(4)])));

return statearr_39992;
})();
var state_39866__$1 = state_39866;
var statearr_39993_40102 = state_39866__$1;
(statearr_39993_40102[(2)] = inst_39861);

(statearr_39993_40102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (49))){
var inst_39714 = (state_39866[(12)]);
var inst_39767 = (state_39866[(16)]);
var inst_39774 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_39714,inst_39767);
var state_39866__$1 = state_39866;
var statearr_39994_40103 = state_39866__$1;
(statearr_39994_40103[(2)] = inst_39774);

(statearr_39994_40103[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39867 === (84))){
var state_39866__$1 = state_39866;
var statearr_39995_40104 = state_39866__$1;
(statearr_39995_40104[(2)] = null);

(statearr_39995_40104[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____0 = (function (){
var statearr_39996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39996[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__);

(statearr_39996[(1)] = (1));

return statearr_39996;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____1 = (function (state_39866){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_39866);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e39997){var ex__17136__auto__ = e39997;
var statearr_39998_40105 = state_39866;
(statearr_39998_40105[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_39866[(4)]))){
var statearr_39999_40106 = state_39866;
(statearr_39999_40106[(1)] = cljs.core.first((state_39866[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__40107 = state_39866;
state_39866 = G__40107;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__ = function(state_39866){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____1.call(this,state_39866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_40000 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_40000[(6)] = c__17207__auto__);

return statearr_40000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__40110,opts){
var map__40111 = p__40110;
var map__40111__$1 = (((((!((map__40111 == null))))?(((((map__40111.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40111.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40111):map__40111);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40111__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40111__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40111__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40111__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40108_SHARP_){
return cljs.core.contains_QMARK_(p1__40108_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__40109_SHARP_){
return cljs.core.contains_QMARK_(p1__40109_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5754__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5754__auto__)){
var orderBy = temp__5754__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__40120 = cljs.core.first(orderBy);
var fexpr__40119 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__40119.cljs$core$IFn$_invoke$arity$1 ? fexpr__40119.cljs$core$IFn$_invoke$arity$1(G__40120) : fexpr__40119.call(null,G__40120));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__40121,p__40122){
var map__40123 = p__40121;
var map__40123__$1 = (((((!((map__40123 == null))))?(((((map__40123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40123.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40123):map__40123);
var query_map = map__40123__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40123__$1,cljs.core.cst$kw$construct);
var map__40124 = p__40122;
var map__40124__$1 = (((((!((map__40124 == null))))?(((((map__40124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40124.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40124):map__40124);
var where_result = map__40124__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40124__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40124__$1,cljs.core.cst$kw$tuples);
var vec__40127 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5752__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5752__auto__)){
var index_of = temp__5752__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40127,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40127,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40127,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_40160){
var state_val_40161 = (state_40160[(1)]);
if((state_val_40161 === (7))){
var inst_40139 = (state_40160[(7)]);
var state_40160__$1 = state_40160;
var statearr_40162_40185 = state_40160__$1;
(statearr_40162_40185[(2)] = inst_40139);

(statearr_40162_40185[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (1))){
var state_40160__$1 = state_40160;
var statearr_40163_40186 = state_40160__$1;
(statearr_40163_40186[(2)] = null);

(statearr_40163_40186[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (4))){
var inst_40130 = (state_40160[(2)]);
var state_40160__$1 = state_40160;
var statearr_40164_40187 = state_40160__$1;
(statearr_40164_40187[(2)] = inst_40130);

(statearr_40164_40187[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (13))){
var inst_40149 = (state_40160[(2)]);
var inst_40150 = fluree.db.util.async.throw_err(inst_40149);
var state_40160__$1 = state_40160;
var statearr_40165_40188 = state_40160__$1;
(statearr_40165_40188[(2)] = inst_40150);

(statearr_40165_40188[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (6))){
var inst_40139 = (state_40160[(7)]);
var inst_40138 = (state_40160[(2)]);
var inst_40139__$1 = fluree.db.util.async.throw_err(inst_40138);
var inst_40140 = fluree.db.util.core.exception_QMARK_(inst_40139__$1);
var state_40160__$1 = (function (){var statearr_40166 = state_40160;
(statearr_40166[(7)] = inst_40139__$1);

return statearr_40166;
})();
if(inst_40140){
var statearr_40167_40189 = state_40160__$1;
(statearr_40167_40189[(1)] = (7));

} else {
var statearr_40168_40190 = state_40160__$1;
(statearr_40168_40190[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (3))){
var inst_40158 = (state_40160[(2)]);
var state_40160__$1 = state_40160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40160__$1,inst_40158);
} else {
if((state_val_40161 === (12))){
var inst_40153 = (state_40160[(2)]);
var state_40160__$1 = state_40160;
var statearr_40169_40191 = state_40160__$1;
(statearr_40169_40191[(2)] = inst_40153);

(statearr_40169_40191[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (2))){
var _ = (function (){var statearr_40170 = state_40160;
(statearr_40170[(4)] = cljs.core.cons((5),(state_40160[(4)])));

return statearr_40170;
})();
var inst_40136 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_40160__$1 = state_40160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40160__$1,(6),inst_40136);
} else {
if((state_val_40161 === (11))){
var state_40160__$1 = state_40160;
var statearr_40172_40192 = state_40160__$1;
(statearr_40172_40192[(2)] = null);

(statearr_40172_40192[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (9))){
var inst_40155 = (state_40160[(2)]);
var _ = (function (){var statearr_40173 = state_40160;
(statearr_40173[(4)] = cljs.core.rest((state_40160[(4)])));

return statearr_40173;
})();
var state_40160__$1 = state_40160;
var statearr_40174_40193 = state_40160__$1;
(statearr_40174_40193[(2)] = inst_40155);

(statearr_40174_40193[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (5))){
var _ = (function (){var statearr_40175 = state_40160;
(statearr_40175[(4)] = cljs.core.rest((state_40160[(4)])));

return statearr_40175;
})();
var state_40160__$1 = state_40160;
var ex40171 = (state_40160__$1[(2)]);
var statearr_40176_40194 = state_40160__$1;
(statearr_40176_40194[(5)] = ex40171);


if((ex40171 instanceof Error)){
var statearr_40177_40195 = state_40160__$1;
(statearr_40177_40195[(1)] = (4));

(statearr_40177_40195[(5)] = null);

} else {
throw ex40171;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40161 === (10))){
var inst_40139 = (state_40160[(7)]);
var inst_40144 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_40139);
var inst_40145 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_40139);
var inst_40146 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_40144,inst_40145,query_map,opts);
var inst_40147 = fluree.db.query.fql.process_ad_hoc_res(db,inst_40139,inst_40146,opts);
var state_40160__$1 = state_40160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40160__$1,(13),inst_40147);
} else {
if((state_val_40161 === (8))){
var state_40160__$1 = state_40160;
var statearr_40178_40196 = state_40160__$1;
(statearr_40178_40196[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____0 = (function (){
var statearr_40180 = [null,null,null,null,null,null,null,null];
(statearr_40180[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__);

(statearr_40180[(1)] = (1));

return statearr_40180;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____1 = (function (state_40160){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_40160);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e40181){var ex__17136__auto__ = e40181;
var statearr_40182_40197 = state_40160;
(statearr_40182_40197[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_40160[(4)]))){
var statearr_40183_40198 = state_40160;
(statearr_40183_40198[(1)] = cljs.core.first((state_40160[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__40199 = state_40160;
state_40160 = G__40199;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__ = function(state_40160){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____1.call(this,state_40160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_40184 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_40184[(6)] = c__17207__auto__);

return statearr_40184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__40200 = query_map;
var map__40200__$1 = (((((!((map__40200 == null))))?(((((map__40200.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40200.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40200):map__40200);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40200__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__40202 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40202,cljs.core.cst$kw$limit,(1));
} else {
return G__40202;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_40573){
var state_val_40574 = (state_40573[(1)]);
if((state_val_40574 === (121))){
var inst_40514 = (state_40573[(7)]);
var inst_40286 = (state_40573[(8)]);
var inst_40284 = (state_40573[(9)]);
var inst_40518 = (state_40573[(10)]);
var inst_40522 = (state_40573[(2)]);
var inst_40523 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40286,fuel,max_fuel,inst_40284,inst_40514,inst_40518,inst_40522);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(115),inst_40523);
} else {
if((state_val_40574 === (65))){
var inst_40286 = (state_40573[(8)]);
var inst_40284 = (state_40573[(9)]);
var inst_40274 = (state_40573[(11)]);
var inst_40363 = (state_40573[(12)]);
var inst_40377 = (state_40573[(2)]);
var inst_40378 = fluree.db.util.async.throw_err(inst_40377);
var inst_40379 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_40363,inst_40378);
var inst_40380 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_40286,fuel,max_fuel,inst_40284,inst_40379,inst_40274);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(66),inst_40380);
} else {
if((state_val_40574 === (70))){
var inst_40273 = (state_40573[(13)]);
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40273)){
var statearr_40575_40767 = state_40573__$1;
(statearr_40575_40767[(1)] = (73));

} else {
var statearr_40576_40768 = state_40573__$1;
(statearr_40576_40768[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (62))){
var inst_40365 = cljs.core.PersistentHashMap.EMPTY;
var state_40573__$1 = state_40573;
var statearr_40577_40769 = state_40573__$1;
(statearr_40577_40769[(2)] = inst_40365);

(statearr_40577_40769[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (74))){
var inst_40274 = (state_40573[(11)]);
var inst_40276 = (state_40573[(14)]);
var inst_40399 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40400 = [inst_40274,inst_40276];
var inst_40401 = cljs.core.PersistentHashMap.fromArrays(inst_40399,inst_40400);
var state_40573__$1 = state_40573;
var statearr_40578_40770 = state_40573__$1;
(statearr_40578_40770[(2)] = inst_40401);

(statearr_40578_40770[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (110))){
var inst_40482 = (state_40573[(15)]);
var inst_40496 = (state_40573[(2)]);
var inst_40497 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_40482,false);
var state_40573__$1 = (function (){var statearr_40579 = state_40573;
(statearr_40579[(16)] = inst_40496);

return statearr_40579;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(111),inst_40497);
} else {
if((state_val_40574 === (130))){
var inst_40563 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40563)){
var statearr_40580_40771 = state_40573__$1;
(statearr_40580_40771[(1)] = (131));

} else {
var statearr_40581_40772 = state_40573__$1;
(statearr_40581_40772[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (128))){
var inst_40554 = (state_40573[(17)]);
var inst_40557 = cljs.core.coll_QMARK_(inst_40554);
var inst_40558 = fluree.db.util.core.exception_QMARK_(inst_40554);
var inst_40559 = (!(inst_40558));
var inst_40560 = ((inst_40557) && (inst_40559));
var state_40573__$1 = state_40573;
var statearr_40582_40773 = state_40573__$1;
(statearr_40582_40773[(2)] = inst_40560);

(statearr_40582_40773[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (7))){
var inst_40234 = (state_40573[(18)]);
var inst_40234__$1 = selectOne;
var state_40573__$1 = (function (){var statearr_40583 = state_40573;
(statearr_40583[(18)] = inst_40234__$1);

return statearr_40583;
})();
if(cljs.core.truth_(inst_40234__$1)){
var statearr_40584_40774 = state_40573__$1;
(statearr_40584_40774[(1)] = (9));

} else {
var statearr_40585_40775 = state_40573__$1;
(statearr_40585_40775[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (59))){
var inst_40357 = (state_40573[(19)]);
var inst_40359 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40360 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40357,inst_40359);
var state_40573__$1 = state_40573;
var statearr_40586_40776 = state_40573__$1;
(statearr_40586_40776[(2)] = inst_40360);

(statearr_40586_40776[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (86))){
var inst_40435 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(89),inst_40435);
} else {
if((state_val_40574 === (20))){
var inst_40264 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40587_40777 = state_40573__$1;
(statearr_40587_40777[(2)] = inst_40264);

(statearr_40587_40777[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (72))){
var inst_40545 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40588_40778 = state_40573__$1;
(statearr_40588_40778[(2)] = inst_40545);

(statearr_40588_40778[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (58))){
var inst_40357 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40589 = state_40573;
(statearr_40589[(19)] = inst_40357);

return statearr_40589;
})();
var statearr_40590_40779 = state_40573__$1;
(statearr_40590_40779[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (60))){
var inst_40357 = (state_40573[(19)]);
var state_40573__$1 = state_40573;
var statearr_40592_40780 = state_40573__$1;
(statearr_40592_40780[(2)] = inst_40357);

(statearr_40592_40780[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (27))){
var inst_40273 = (state_40573[(13)]);
var inst_40288 = cljs.core.vector_QMARK_(inst_40273);
var state_40573__$1 = state_40573;
if(inst_40288){
var statearr_40593_40781 = state_40573__$1;
(statearr_40593_40781[(1)] = (30));

} else {
var statearr_40594_40782 = state_40573__$1;
(statearr_40594_40782[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (1))){
var state_40573__$1 = state_40573;
var statearr_40595_40783 = state_40573__$1;
(statearr_40595_40783[(2)] = null);

(statearr_40595_40783[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (69))){
var inst_40394 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40394)){
var statearr_40596_40784 = state_40573__$1;
(statearr_40596_40784[(1)] = (70));

} else {
var statearr_40597_40785 = state_40573__$1;
(statearr_40597_40785[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (101))){
var inst_40273 = (state_40573[(13)]);
var inst_40512 = (state_40573[(2)]);
var inst_40513 = cljs.core.PersistentVector.EMPTY;
var inst_40514 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40513,inst_40512);
var state_40573__$1 = (function (){var statearr_40598 = state_40573;
(statearr_40598[(7)] = inst_40514);

return statearr_40598;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40599_40786 = state_40573__$1;
(statearr_40599_40786[(1)] = (116));

} else {
var statearr_40600_40787 = state_40573__$1;
(statearr_40600_40787[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (24))){
var inst_40275 = (state_40573[(20)]);
var inst_40277 = (state_40573[(21)]);
var inst_40281 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40277,cljs.core.cst$kw$componentFollow_QMARK_,inst_40275);
var state_40573__$1 = state_40573;
var statearr_40601_40788 = state_40573__$1;
(statearr_40601_40788[(2)] = inst_40281);

(statearr_40601_40788[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (102))){
var inst_40476 = (state_40573[(22)]);
var state_40573__$1 = state_40573;
var statearr_40602_40789 = state_40573__$1;
(statearr_40602_40789[(2)] = inst_40476);

(statearr_40602_40789[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (55))){
var inst_40547 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40603_40790 = state_40573__$1;
(statearr_40603_40790[(2)] = inst_40547);

(statearr_40603_40790[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (85))){
var inst_40429 = (state_40573[(2)]);
var inst_40430 = fluree.db.util.async.throw_err(inst_40429);
var state_40573__$1 = state_40573;
var statearr_40604_40791 = state_40573__$1;
(statearr_40604_40791[(2)] = inst_40430);

(statearr_40604_40791[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (39))){
var inst_40323 = typeof from === 'string';
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40323)){
var statearr_40605_40792 = state_40573__$1;
(statearr_40605_40792[(1)] = (42));

} else {
var statearr_40606_40793 = state_40573__$1;
(statearr_40606_40793[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (88))){
var inst_40541 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40607_40794 = state_40573__$1;
(statearr_40607_40794[(2)] = inst_40541);

(statearr_40607_40794[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (46))){
var inst_40342 = (state_40573[(2)]);
var inst_40343 = fluree.db.util.async.throw_err(inst_40342);
var state_40573__$1 = state_40573;
var statearr_40608_40795 = state_40573__$1;
(statearr_40608_40795[(2)] = inst_40343);

(statearr_40608_40795[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (4))){
var inst_40221 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40609_40796 = state_40573__$1;
(statearr_40609_40796[(2)] = inst_40221);

(statearr_40609_40796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (77))){
var inst_40410 = (state_40573[(2)]);
var inst_40411 = fluree.db.util.async.throw_err(inst_40410);
var state_40573__$1 = state_40573;
var statearr_40610_40797 = state_40573__$1;
(statearr_40610_40797[(2)] = inst_40411);

(statearr_40610_40797[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (106))){
var state_40573__$1 = state_40573;
if(cljs.core.truth_(fuel)){
var statearr_40611_40798 = state_40573__$1;
(statearr_40611_40798[(1)] = (108));

} else {
var statearr_40612_40799 = state_40573__$1;
(statearr_40612_40799[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (119))){
var state_40573__$1 = state_40573;
var statearr_40613_40800 = state_40573__$1;
(statearr_40613_40800[(2)] = null);

(statearr_40613_40800[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (95))){
var state_40573__$1 = state_40573;
var statearr_40614_40801 = state_40573__$1;
(statearr_40614_40801[(2)] = null);

(statearr_40614_40801[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (54))){
var inst_40386 = typeof from === 'string';
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40386)){
var statearr_40615_40802 = state_40573__$1;
(statearr_40615_40802[(1)] = (67));

} else {
var statearr_40616_40803 = state_40573__$1;
(statearr_40616_40803[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (92))){
var inst_40286 = (state_40573[(8)]);
var inst_40284 = (state_40573[(9)]);
var inst_40274 = (state_40573[(11)]);
var inst_40276 = (state_40573[(14)]);
var inst_40446 = (state_40573[(2)]);
var inst_40447 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40286,fuel,max_fuel,inst_40284,inst_40446,inst_40274,inst_40276);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(93),inst_40447);
} else {
if((state_val_40574 === (104))){
var inst_40510 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40617_40804 = state_40573__$1;
(statearr_40617_40804[(2)] = inst_40510);

(statearr_40617_40804[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (15))){
var inst_40251 = (state_40573[(23)]);
var inst_40256 = inst_40251.cljs$lang$protocol_mask$partition0$;
var inst_40257 = (inst_40256 & (64));
var inst_40258 = inst_40251.cljs$core$ISeq$;
var inst_40259 = (cljs.core.PROTOCOL_SENTINEL === inst_40258);
var inst_40260 = ((inst_40257) || (inst_40259));
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40260)){
var statearr_40618_40805 = state_40573__$1;
(statearr_40618_40805[(1)] = (18));

} else {
var statearr_40619_40806 = state_40573__$1;
(statearr_40619_40806[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (48))){
var inst_40274 = (state_40573[(11)]);
var state_40573__$1 = state_40573;
var statearr_40620_40807 = state_40573__$1;
(statearr_40620_40807[(2)] = inst_40274);

(statearr_40620_40807[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (50))){
var state_40573__$1 = state_40573;
var statearr_40621_40808 = state_40573__$1;
(statearr_40621_40808[(2)] = null);

(statearr_40621_40808[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (116))){
var state_40573__$1 = state_40573;
var statearr_40622_40809 = state_40573__$1;
(statearr_40622_40809[(2)] = null);

(statearr_40622_40809[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (75))){
var inst_40403 = (state_40573[(2)]);
var inst_40404 = fluree.db.query.range._block_or_tx_collection(db,inst_40403);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(76),inst_40404);
} else {
if((state_val_40574 === (99))){
var inst_40539 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40623_40810 = state_40573__$1;
(statearr_40623_40810[(2)] = inst_40539);

(statearr_40623_40810[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (21))){
var inst_40251 = (state_40573[(23)]);
var inst_40269 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40251);
var state_40573__$1 = state_40573;
var statearr_40624_40811 = state_40573__$1;
(statearr_40624_40811[(2)] = inst_40269);

(statearr_40624_40811[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (31))){
var inst_40273 = (state_40573[(13)]);
var inst_40296 = typeof inst_40273 === 'string';
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40296)){
var statearr_40625_40812 = state_40573__$1;
(statearr_40625_40812[(1)] = (33));

} else {
var statearr_40626_40813 = state_40573__$1;
(statearr_40626_40813[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (113))){
var inst_40476 = (state_40573[(22)]);
var state_40573__$1 = state_40573;
var statearr_40627_40814 = state_40573__$1;
(statearr_40627_40814[(2)] = inst_40476);

(statearr_40627_40814[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (32))){
var inst_40312 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40628_40815 = state_40573__$1;
(statearr_40628_40815[(2)] = inst_40312);

(statearr_40628_40815[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (40))){
var inst_40345 = typeof from === 'string';
var inst_40346 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_40347 = clojure.string.includes_QMARK_(inst_40346,"/");
var inst_40348 = ((inst_40345) && (inst_40347));
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40348)){
var statearr_40629_40816 = state_40573__$1;
(statearr_40629_40816[(1)] = (53));

} else {
var statearr_40630_40817 = state_40573__$1;
(statearr_40630_40817[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (129))){
var inst_40555 = (state_40573[(24)]);
var state_40573__$1 = state_40573;
var statearr_40631_40818 = state_40573__$1;
(statearr_40631_40818[(2)] = inst_40555);

(statearr_40631_40818[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (91))){
var inst_40438 = (state_40573[(25)]);
var inst_40442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40443 = [inst_40438];
var inst_40444 = (new cljs.core.PersistentVector(null,1,(5),inst_40442,inst_40443,null));
var state_40573__$1 = state_40573;
var statearr_40632_40819 = state_40573__$1;
(statearr_40632_40819[(2)] = inst_40444);

(statearr_40632_40819[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (117))){
var inst_40274 = (state_40573[(11)]);
var state_40573__$1 = state_40573;
var statearr_40633_40820 = state_40573__$1;
(statearr_40633_40820[(2)] = inst_40274);

(statearr_40633_40820[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (108))){
var inst_40491 = cljs.core._deref(fuel);
var inst_40492 = (inst_40491 + (1));
var inst_40493 = cljs.core._vreset_BANG_(fuel,inst_40492);
var state_40573__$1 = state_40573;
var statearr_40634_40821 = state_40573__$1;
(statearr_40634_40821[(2)] = inst_40493);

(statearr_40634_40821[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (56))){
var inst_40351 = (state_40573[(26)]);
var inst_40353 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_40354 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40351,inst_40353);
var state_40573__$1 = state_40573;
var statearr_40635_40822 = state_40573__$1;
(statearr_40635_40822[(2)] = inst_40354);

(statearr_40635_40822[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (33))){
var inst_40273 = (state_40573[(13)]);
var inst_40298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40299 = [inst_40273,"ASC"];
var inst_40300 = (new cljs.core.PersistentVector(null,2,(5),inst_40298,inst_40299,null));
var state_40573__$1 = state_40573;
var statearr_40636_40823 = state_40573__$1;
(statearr_40636_40823[(2)] = inst_40300);

(statearr_40636_40823[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (13))){
var inst_40240 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40241 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40242 = cljs.core.PersistentHashMap.fromArrays(inst_40240,inst_40241);
var inst_40243 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_40242);
var inst_40244 = (function(){throw inst_40243})();
var state_40573__$1 = state_40573;
var statearr_40637_40824 = state_40573__$1;
(statearr_40637_40824[(2)] = inst_40244);

(statearr_40637_40824[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (22))){
var inst_40251 = (state_40573[(23)]);
var state_40573__$1 = state_40573;
var statearr_40638_40825 = state_40573__$1;
(statearr_40638_40825[(2)] = inst_40251);

(statearr_40638_40825[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (90))){
var state_40573__$1 = state_40573;
var statearr_40639_40826 = state_40573__$1;
(statearr_40639_40826[(2)] = null);

(statearr_40639_40826[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (109))){
var state_40573__$1 = state_40573;
var statearr_40640_40827 = state_40573__$1;
(statearr_40640_40827[(2)] = null);

(statearr_40640_40827[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (36))){
var inst_40303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40304 = [null,null];
var inst_40305 = (new cljs.core.PersistentVector(null,2,(5),inst_40303,inst_40304,null));
var state_40573__$1 = state_40573;
var statearr_40641_40828 = state_40573__$1;
(statearr_40641_40828[(2)] = inst_40305);

(statearr_40641_40828[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (41))){
var inst_40319 = (state_40573[(27)]);
var inst_40549 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40642 = state_40573;
(statearr_40642[(28)] = inst_40549);

return statearr_40642;
})();
if(cljs.core.truth_(inst_40319)){
var statearr_40643_40829 = state_40573__$1;
(statearr_40643_40829[(1)] = (125));

} else {
var statearr_40644_40830 = state_40573__$1;
(statearr_40644_40830[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (118))){
var inst_40273 = (state_40573[(13)]);
var inst_40518 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40645 = state_40573;
(statearr_40645[(10)] = inst_40518);

return statearr_40645;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40646_40831 = state_40573__$1;
(statearr_40646_40831[(1)] = (119));

} else {
var statearr_40647_40832 = state_40573__$1;
(statearr_40647_40832[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (89))){
var inst_40438 = (state_40573[(25)]);
var inst_40437 = (state_40573[(2)]);
var inst_40438__$1 = fluree.db.util.async.throw_err(inst_40437);
var inst_40439 = (inst_40438__$1 == null);
var state_40573__$1 = (function (){var statearr_40648 = state_40573;
(statearr_40648[(25)] = inst_40438__$1);

return statearr_40648;
})();
if(cljs.core.truth_(inst_40439)){
var statearr_40649_40833 = state_40573__$1;
(statearr_40649_40833[(1)] = (90));

} else {
var statearr_40650_40834 = state_40573__$1;
(statearr_40650_40834[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (100))){
var inst_40475 = (state_40573[(29)]);
var inst_40482 = (state_40573[(15)]);
var inst_40481 = cljs.core.seq(inst_40475);
var inst_40482__$1 = cljs.core.first(inst_40481);
var inst_40483 = cljs.core.next(inst_40481);
var inst_40484 = cljs.core.not(inst_40482__$1);
var state_40573__$1 = (function (){var statearr_40651 = state_40573;
(statearr_40651[(30)] = inst_40483);

(statearr_40651[(15)] = inst_40482__$1);

return statearr_40651;
})();
if(inst_40484){
var statearr_40652_40835 = state_40573__$1;
(statearr_40652_40835[(1)] = (102));

} else {
var statearr_40653_40836 = state_40573__$1;
(statearr_40653_40836[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (131))){
var inst_40554 = (state_40573[(17)]);
var inst_40565 = cljs.core.first(inst_40554);
var state_40573__$1 = state_40573;
var statearr_40654_40837 = state_40573__$1;
(statearr_40654_40837[(2)] = inst_40565);

(statearr_40654_40837[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (122))){
var inst_40529 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_40530 = ["Invalid 'from' in query:",inst_40529].join('');
var inst_40531 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40532 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40533 = cljs.core.PersistentHashMap.fromArrays(inst_40531,inst_40532);
var inst_40534 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40530,inst_40533);
var state_40573__$1 = state_40573;
var statearr_40655_40838 = state_40573__$1;
(statearr_40655_40838[(2)] = inst_40534);

(statearr_40655_40838[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (43))){
var state_40573__$1 = state_40573;
var statearr_40656_40839 = state_40573__$1;
(statearr_40656_40839[(2)] = null);

(statearr_40656_40839[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (61))){
var inst_40273 = (state_40573[(13)]);
var inst_40363 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40657 = state_40573;
(statearr_40657[(12)] = inst_40363);

return statearr_40657;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40658_40840 = state_40573__$1;
(statearr_40658_40840[(1)] = (62));

} else {
var statearr_40659_40841 = state_40573__$1;
(statearr_40659_40841[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (29))){
var inst_40318 = (state_40573[(2)]);
var inst_40319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40318,(0),null);
var inst_40320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40318,(1),null);
var inst_40321 = typeof where === 'string';
var state_40573__$1 = (function (){var statearr_40660 = state_40573;
(statearr_40660[(31)] = inst_40320);

(statearr_40660[(27)] = inst_40319);

return statearr_40660;
})();
if(cljs.core.truth_(inst_40321)){
var statearr_40661_40842 = state_40573__$1;
(statearr_40661_40842[(1)] = (39));

} else {
var statearr_40662_40843 = state_40573__$1;
(statearr_40662_40843[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (44))){
var inst_40327 = (state_40573[(2)]);
var inst_40328 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_40327);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(45),inst_40328);
} else {
if((state_val_40574 === (93))){
var inst_40449 = (state_40573[(2)]);
var inst_40450 = fluree.db.util.async.throw_err(inst_40449);
var state_40573__$1 = (function (){var statearr_40663 = state_40573;
(statearr_40663[(32)] = inst_40450);

return statearr_40663;
})();
if(cljs.core.truth_(fuel)){
var statearr_40664_40844 = state_40573__$1;
(statearr_40664_40844[(1)] = (94));

} else {
var statearr_40665_40845 = state_40573__$1;
(statearr_40665_40845[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (6))){
var inst_40231 = (state_40573[(33)]);
var state_40573__$1 = state_40573;
var statearr_40666_40846 = state_40573__$1;
(statearr_40666_40846[(2)] = inst_40231);

(statearr_40666_40846[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (111))){
var inst_40499 = (state_40573[(2)]);
var inst_40500 = fluree.db.util.async.throw_err(inst_40499);
var state_40573__$1 = state_40573;
var statearr_40667_40847 = state_40573__$1;
(statearr_40667_40847[(2)] = inst_40500);

(statearr_40667_40847[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (28))){
var inst_40314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40315 = [null,null];
var inst_40316 = (new cljs.core.PersistentVector(null,2,(5),inst_40314,inst_40315,null));
var state_40573__$1 = state_40573;
var statearr_40668_40848 = state_40573__$1;
(statearr_40668_40848[(2)] = inst_40316);

(statearr_40668_40848[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (64))){
var inst_40371 = (state_40573[(2)]);
var inst_40372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40373 = [from];
var inst_40374 = (new cljs.core.PersistentVector(null,1,(5),inst_40372,inst_40373,null));
var inst_40375 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_40374,inst_40371);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(65),inst_40375);
} else {
if((state_val_40574 === (103))){
var inst_40482 = (state_40573[(15)]);
var inst_40487 = cljs.core.int_QMARK_(inst_40482);
var state_40573__$1 = state_40573;
if(inst_40487){
var statearr_40669_40849 = state_40573__$1;
(statearr_40669_40849[(1)] = (105));

} else {
var statearr_40670_40850 = state_40573__$1;
(statearr_40670_40850[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (51))){
var inst_40276 = (state_40573[(14)]);
var state_40573__$1 = state_40573;
var statearr_40671_40851 = state_40573__$1;
(statearr_40671_40851[(2)] = inst_40276);

(statearr_40671_40851[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (25))){
var inst_40277 = (state_40573[(21)]);
var state_40573__$1 = state_40573;
var statearr_40672_40852 = state_40573__$1;
(statearr_40672_40852[(2)] = inst_40277);

(statearr_40672_40852[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (34))){
var state_40573__$1 = state_40573;
var statearr_40673_40853 = state_40573__$1;
(statearr_40673_40853[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (125))){
var inst_40320 = (state_40573[(31)]);
var inst_40274 = (state_40573[(11)]);
var inst_40549 = (state_40573[(28)]);
var inst_40319 = (state_40573[(27)]);
var inst_40276 = (state_40573[(14)]);
var inst_40551 = fluree.db.query.fql.sort_offset_and_limit_res(inst_40319,inst_40320,inst_40276,inst_40274,inst_40549);
var state_40573__$1 = state_40573;
var statearr_40675_40854 = state_40573__$1;
(statearr_40675_40854[(2)] = inst_40551);

(statearr_40675_40854[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (17))){
var inst_40267 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40267)){
var statearr_40676_40855 = state_40573__$1;
(statearr_40676_40855[(1)] = (21));

} else {
var statearr_40677_40856 = state_40573__$1;
(statearr_40677_40856[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (3))){
var inst_40571 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40573__$1,inst_40571);
} else {
if((state_val_40574 === (12))){
var inst_40237 = (state_40573[(34)]);
var state_40573__$1 = state_40573;
var statearr_40678_40857 = state_40573__$1;
(statearr_40678_40857[(2)] = inst_40237);

(statearr_40678_40857[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (2))){
var inst_40231 = (state_40573[(33)]);
var _ = (function (){var statearr_40679 = state_40573;
(statearr_40679[(4)] = cljs.core.cons((5),(state_40573[(4)])));

return statearr_40679;
})();
var inst_40231__$1 = select;
var state_40573__$1 = (function (){var statearr_40680 = state_40573;
(statearr_40680[(33)] = inst_40231__$1);

return statearr_40680;
})();
if(cljs.core.truth_(inst_40231__$1)){
var statearr_40681_40858 = state_40573__$1;
(statearr_40681_40858[(1)] = (6));

} else {
var statearr_40682_40859 = state_40573__$1;
(statearr_40682_40859[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (66))){
var inst_40382 = (state_40573[(2)]);
var inst_40383 = fluree.db.util.async.throw_err(inst_40382);
var state_40573__$1 = state_40573;
var statearr_40683_40860 = state_40573__$1;
(statearr_40683_40860[(2)] = inst_40383);

(statearr_40683_40860[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (107))){
var inst_40502 = (state_40573[(35)]);
var inst_40502__$1 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40684 = state_40573;
(statearr_40684[(35)] = inst_40502__$1);

return statearr_40684;
})();
if(cljs.core.truth_(inst_40502__$1)){
var statearr_40685_40861 = state_40573__$1;
(statearr_40685_40861[(1)] = (112));

} else {
var statearr_40686_40862 = state_40573__$1;
(statearr_40686_40862[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (23))){
var inst_40250 = (state_40573[(36)]);
var inst_40275 = (state_40573[(20)]);
var inst_40272 = (state_40573[(2)]);
var inst_40273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40272,cljs.core.cst$kw$orderBy);
var inst_40274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40272,cljs.core.cst$kw$limit);
var inst_40275__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40272,cljs.core.cst$kw$component);
var inst_40276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40272,cljs.core.cst$kw$offset);
var inst_40277 = fluree.db.query.fql_parser.parse_db(db,inst_40250,opts_SINGLEQUOTE_);
var inst_40278 = (inst_40275__$1 == null);
var inst_40279 = cljs.core.not(inst_40278);
var state_40573__$1 = (function (){var statearr_40687 = state_40573;
(statearr_40687[(20)] = inst_40275__$1);

(statearr_40687[(13)] = inst_40273);

(statearr_40687[(11)] = inst_40274);

(statearr_40687[(14)] = inst_40276);

(statearr_40687[(21)] = inst_40277);

return statearr_40687;
})();
if(inst_40279){
var statearr_40688_40863 = state_40573__$1;
(statearr_40688_40863[(1)] = (24));

} else {
var statearr_40689_40864 = state_40573__$1;
(statearr_40689_40864[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (47))){
var state_40573__$1 = state_40573;
var statearr_40690_40865 = state_40573__$1;
(statearr_40690_40865[(2)] = null);

(statearr_40690_40865[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (35))){
var inst_40310 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40691_40866 = state_40573__$1;
(statearr_40691_40866[(2)] = inst_40310);

(statearr_40691_40866[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (127))){
var inst_40555 = (state_40573[(24)]);
var inst_40554 = (state_40573[(2)]);
var inst_40555__$1 = selectOne;
var state_40573__$1 = (function (){var statearr_40692 = state_40573;
(statearr_40692[(17)] = inst_40554);

(statearr_40692[(24)] = inst_40555__$1);

return statearr_40692;
})();
if(cljs.core.truth_(inst_40555__$1)){
var statearr_40693_40867 = state_40573__$1;
(statearr_40693_40867[(1)] = (128));

} else {
var statearr_40694_40868 = state_40573__$1;
(statearr_40694_40868[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (82))){
var inst_40274 = (state_40573[(11)]);
var inst_40276 = (state_40573[(14)]);
var inst_40418 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40419 = [inst_40274,inst_40276];
var inst_40420 = cljs.core.PersistentHashMap.fromArrays(inst_40418,inst_40419);
var state_40573__$1 = state_40573;
var statearr_40695_40869 = state_40573__$1;
(statearr_40695_40869[(2)] = inst_40420);

(statearr_40695_40869[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (76))){
var inst_40286 = (state_40573[(8)]);
var inst_40284 = (state_40573[(9)]);
var inst_40406 = (state_40573[(2)]);
var inst_40407 = fluree.db.util.async.throw_err(inst_40406);
var inst_40408 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40286,fuel,max_fuel,inst_40284,inst_40407);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(77),inst_40408);
} else {
if((state_val_40574 === (97))){
var inst_40470 = from;
var inst_40471 = cljs.core.seq(inst_40470);
var inst_40472 = cljs.core.first(inst_40471);
var inst_40473 = cljs.core.next(inst_40471);
var inst_40474 = cljs.core.PersistentVector.EMPTY;
var inst_40475 = inst_40470;
var inst_40476 = inst_40474;
var state_40573__$1 = (function (){var statearr_40696 = state_40573;
(statearr_40696[(37)] = inst_40473);

(statearr_40696[(22)] = inst_40476);

(statearr_40696[(29)] = inst_40475);

(statearr_40696[(38)] = inst_40472);

return statearr_40696;
})();
var statearr_40697_40870 = state_40573__$1;
(statearr_40697_40870[(2)] = null);

(statearr_40697_40870[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (19))){
var state_40573__$1 = state_40573;
var statearr_40698_40871 = state_40573__$1;
(statearr_40698_40871[(2)] = false);

(statearr_40698_40871[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (57))){
var inst_40351 = (state_40573[(26)]);
var state_40573__$1 = state_40573;
var statearr_40699_40872 = state_40573__$1;
(statearr_40699_40872[(2)] = inst_40351);

(statearr_40699_40872[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (68))){
var state_40573__$1 = state_40573;
var statearr_40700_40873 = state_40573__$1;
(statearr_40700_40873[(2)] = false);

(statearr_40700_40873[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (11))){
var inst_40248 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40701_40874 = state_40573__$1;
(statearr_40701_40874[(2)] = inst_40248);

(statearr_40701_40874[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (115))){
var inst_40525 = (state_40573[(2)]);
var inst_40526 = fluree.db.util.async.throw_err(inst_40525);
var state_40573__$1 = state_40573;
var statearr_40703_40875 = state_40573__$1;
(statearr_40703_40875[(2)] = inst_40526);

(statearr_40703_40875[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (9))){
var inst_40234 = (state_40573[(18)]);
var state_40573__$1 = state_40573;
var statearr_40704_40876 = state_40573__$1;
(statearr_40704_40876[(2)] = inst_40234);

(statearr_40704_40876[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (5))){
var _ = (function (){var statearr_40705 = state_40573;
(statearr_40705[(4)] = cljs.core.rest((state_40573[(4)])));

return statearr_40705;
})();
var state_40573__$1 = state_40573;
var ex40702 = (state_40573__$1[(2)]);
var statearr_40706_40877 = state_40573__$1;
(statearr_40706_40877[(5)] = ex40702);


if((ex40702 instanceof Error)){
var statearr_40707_40878 = state_40573__$1;
(statearr_40707_40878[(1)] = (4));

(statearr_40707_40878[(5)] = null);

} else {
throw ex40702;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (112))){
var inst_40476 = (state_40573[(22)]);
var inst_40502 = (state_40573[(35)]);
var inst_40504 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40476,inst_40502);
var state_40573__$1 = state_40573;
var statearr_40708_40879 = state_40573__$1;
(statearr_40708_40879[(2)] = inst_40504);

(statearr_40708_40879[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (83))){
var inst_40422 = (state_40573[(2)]);
var inst_40423 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_40422);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(84),inst_40423);
} else {
if((state_val_40574 === (14))){
var inst_40246 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40709_40880 = state_40573__$1;
(statearr_40709_40880[(2)] = inst_40246);

(statearr_40709_40880[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (45))){
var inst_40273 = (state_40573[(13)]);
var inst_40330 = (state_40573[(2)]);
var inst_40331 = fluree.db.util.async.throw_err(inst_40330);
var state_40573__$1 = (function (){var statearr_40710 = state_40573;
(statearr_40710[(39)] = inst_40331);

return statearr_40710;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40711_40881 = state_40573__$1;
(statearr_40711_40881[(1)] = (47));

} else {
var statearr_40712_40882 = state_40573__$1;
(statearr_40712_40882[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (53))){
var inst_40351 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_40573__$1 = (function (){var statearr_40713 = state_40573;
(statearr_40713[(26)] = inst_40351);

return statearr_40713;
})();
if(cljs.core.truth_(fuel)){
var statearr_40714_40883 = state_40573__$1;
(statearr_40714_40883[(1)] = (56));

} else {
var statearr_40715_40884 = state_40573__$1;
(statearr_40715_40884[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (78))){
var inst_40273 = (state_40573[(13)]);
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40273)){
var statearr_40716_40885 = state_40573__$1;
(statearr_40716_40885[(1)] = (81));

} else {
var statearr_40717_40886 = state_40573__$1;
(statearr_40717_40886[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (132))){
var inst_40554 = (state_40573[(17)]);
var state_40573__$1 = state_40573;
var statearr_40718_40887 = state_40573__$1;
(statearr_40718_40887[(2)] = inst_40554);

(statearr_40718_40887[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (26))){
var inst_40273 = (state_40573[(13)]);
var inst_40284 = (state_40573[(2)]);
var inst_40285 = cljs.core.PersistentHashMap.EMPTY;
var inst_40286 = cljs.core.volatile_BANG_(inst_40285);
var state_40573__$1 = (function (){var statearr_40719 = state_40573;
(statearr_40719[(8)] = inst_40286);

(statearr_40719[(9)] = inst_40284);

return statearr_40719;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40720_40888 = state_40573__$1;
(statearr_40720_40888[(1)] = (27));

} else {
var statearr_40721_40889 = state_40573__$1;
(statearr_40721_40889[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (123))){
var state_40573__$1 = state_40573;
var statearr_40722_40890 = state_40573__$1;
(statearr_40722_40890[(2)] = null);

(statearr_40722_40890[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (16))){
var state_40573__$1 = state_40573;
var statearr_40723_40891 = state_40573__$1;
(statearr_40723_40891[(2)] = false);

(statearr_40723_40891[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (133))){
var inst_40568 = (state_40573[(2)]);
var _ = (function (){var statearr_40724 = state_40573;
(statearr_40724[(4)] = cljs.core.rest((state_40573[(4)])));

return statearr_40724;
})();
var state_40573__$1 = state_40573;
var statearr_40725_40892 = state_40573__$1;
(statearr_40725_40892[(2)] = inst_40568);

(statearr_40725_40892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (81))){
var inst_40416 = cljs.core.PersistentHashMap.EMPTY;
var state_40573__$1 = state_40573;
var statearr_40726_40893 = state_40573__$1;
(statearr_40726_40893[(2)] = inst_40416);

(statearr_40726_40893[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (120))){
var inst_40276 = (state_40573[(14)]);
var state_40573__$1 = state_40573;
var statearr_40727_40894 = state_40573__$1;
(statearr_40727_40894[(2)] = inst_40276);

(statearr_40727_40894[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (79))){
var inst_40432 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_40573__$1 = state_40573;
if(inst_40432){
var statearr_40728_40895 = state_40573__$1;
(statearr_40728_40895[(1)] = (86));

} else {
var statearr_40729_40896 = state_40573__$1;
(statearr_40729_40896[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (38))){
var inst_40308 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40730_40897 = state_40573__$1;
(statearr_40730_40897[(2)] = inst_40308);

(statearr_40730_40897[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (126))){
var inst_40549 = (state_40573[(28)]);
var state_40573__$1 = state_40573;
var statearr_40731_40898 = state_40573__$1;
(statearr_40731_40898[(2)] = inst_40549);

(statearr_40731_40898[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (98))){
var state_40573__$1 = state_40573;
var statearr_40732_40899 = state_40573__$1;
(statearr_40732_40899[(1)] = (122));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (124))){
var inst_40537 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40734_40900 = state_40573__$1;
(statearr_40734_40900[(2)] = inst_40537);

(statearr_40734_40900[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (87))){
var inst_40459 = cljs.core.sequential_QMARK_(from);
var inst_40460 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_40461 = ((inst_40459) && (inst_40460));
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40461)){
var statearr_40735_40901 = state_40573__$1;
(statearr_40735_40901[(1)] = (97));

} else {
var statearr_40736_40902 = state_40573__$1;
(statearr_40736_40902[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (30))){
var inst_40273 = (state_40573[(13)]);
var inst_40290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40291 = cljs.core.second(inst_40273);
var inst_40292 = cljs.core.first(inst_40273);
var inst_40293 = [inst_40291,inst_40292];
var inst_40294 = (new cljs.core.PersistentVector(null,2,(5),inst_40290,inst_40293,null));
var state_40573__$1 = state_40573;
var statearr_40737_40903 = state_40573__$1;
(statearr_40737_40903[(2)] = inst_40294);

(statearr_40737_40903[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (73))){
var inst_40397 = cljs.core.PersistentHashMap.EMPTY;
var state_40573__$1 = state_40573;
var statearr_40738_40904 = state_40573__$1;
(statearr_40738_40904[(2)] = inst_40397);

(statearr_40738_40904[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (96))){
var inst_40450 = (state_40573[(32)]);
var inst_40457 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40739 = state_40573;
(statearr_40739[(40)] = inst_40457);

return statearr_40739;
})();
var statearr_40740_40905 = state_40573__$1;
(statearr_40740_40905[(2)] = inst_40450);

(statearr_40740_40905[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (10))){
var inst_40237 = (state_40573[(34)]);
var inst_40237__$1 = selectDistinct;
var state_40573__$1 = (function (){var statearr_40741 = state_40573;
(statearr_40741[(34)] = inst_40237__$1);

return statearr_40741;
})();
if(cljs.core.truth_(inst_40237__$1)){
var statearr_40742_40906 = state_40573__$1;
(statearr_40742_40906[(1)] = (12));

} else {
var statearr_40743_40907 = state_40573__$1;
(statearr_40743_40907[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (18))){
var state_40573__$1 = state_40573;
var statearr_40744_40908 = state_40573__$1;
(statearr_40744_40908[(2)] = true);

(statearr_40744_40908[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (105))){
var inst_40482 = (state_40573[(15)]);
var state_40573__$1 = state_40573;
var statearr_40745_40909 = state_40573__$1;
(statearr_40745_40909[(2)] = inst_40482);

(statearr_40745_40909[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (52))){
var inst_40331 = (state_40573[(39)]);
var inst_40286 = (state_40573[(8)]);
var inst_40335 = (state_40573[(41)]);
var inst_40284 = (state_40573[(9)]);
var inst_40339 = (state_40573[(2)]);
var inst_40340 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40286,fuel,max_fuel,inst_40284,inst_40331,inst_40335,inst_40339);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(46),inst_40340);
} else {
if((state_val_40574 === (114))){
var inst_40483 = (state_40573[(30)]);
var inst_40507 = (state_40573[(2)]);
var inst_40475 = inst_40483;
var inst_40476 = inst_40507;
var state_40573__$1 = (function (){var statearr_40746 = state_40573;
(statearr_40746[(22)] = inst_40476);

(statearr_40746[(29)] = inst_40475);

return statearr_40746;
})();
var statearr_40747_40910 = state_40573__$1;
(statearr_40747_40910[(2)] = null);

(statearr_40747_40910[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (67))){
var inst_40388 = ["_tx",null,"_block",null];
var inst_40389 = (new cljs.core.PersistentArrayMap(null,2,inst_40388,null));
var inst_40390 = (new cljs.core.PersistentHashSet(null,inst_40389,null));
var inst_40391 = (inst_40390.cljs$core$IFn$_invoke$arity$1 ? inst_40390.cljs$core$IFn$_invoke$arity$1(from) : inst_40390.call(null,from));
var state_40573__$1 = state_40573;
var statearr_40748_40911 = state_40573__$1;
(statearr_40748_40911[(2)] = inst_40391);

(statearr_40748_40911[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (71))){
var inst_40413 = typeof from === 'string';
var state_40573__$1 = state_40573;
if(cljs.core.truth_(inst_40413)){
var statearr_40749_40912 = state_40573__$1;
(statearr_40749_40912[(1)] = (78));

} else {
var statearr_40750_40913 = state_40573__$1;
(statearr_40750_40913[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (42))){
var state_40573__$1 = state_40573;
var statearr_40751_40914 = state_40573__$1;
(statearr_40751_40914[(2)] = from);

(statearr_40751_40914[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (80))){
var inst_40543 = (state_40573[(2)]);
var state_40573__$1 = state_40573;
var statearr_40752_40915 = state_40573__$1;
(statearr_40752_40915[(2)] = inst_40543);

(statearr_40752_40915[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (37))){
var state_40573__$1 = state_40573;
var statearr_40753_40916 = state_40573__$1;
(statearr_40753_40916[(2)] = null);

(statearr_40753_40916[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (63))){
var inst_40274 = (state_40573[(11)]);
var inst_40276 = (state_40573[(14)]);
var inst_40367 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40368 = [inst_40274,inst_40276];
var inst_40369 = cljs.core.PersistentHashMap.fromArrays(inst_40367,inst_40368);
var state_40573__$1 = state_40573;
var statearr_40754_40917 = state_40573__$1;
(statearr_40754_40917[(2)] = inst_40369);

(statearr_40754_40917[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (94))){
var inst_40452 = cljs.core._deref(fuel);
var inst_40453 = (inst_40452 + (1));
var inst_40454 = cljs.core._vreset_BANG_(fuel,inst_40453);
var state_40573__$1 = state_40573;
var statearr_40755_40918 = state_40573__$1;
(statearr_40755_40918[(2)] = inst_40454);

(statearr_40755_40918[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (8))){
var inst_40251 = (state_40573[(23)]);
var inst_40250 = (state_40573[(2)]);
var inst_40251__$1 = opts_SINGLEQUOTE_;
var inst_40253 = (inst_40251__$1 == null);
var inst_40254 = cljs.core.not(inst_40253);
var state_40573__$1 = (function (){var statearr_40756 = state_40573;
(statearr_40756[(36)] = inst_40250);

(statearr_40756[(23)] = inst_40251__$1);

return statearr_40756;
})();
if(inst_40254){
var statearr_40757_40919 = state_40573__$1;
(statearr_40757_40919[(1)] = (15));

} else {
var statearr_40758_40920 = state_40573__$1;
(statearr_40758_40920[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (49))){
var inst_40273 = (state_40573[(13)]);
var inst_40335 = (state_40573[(2)]);
var state_40573__$1 = (function (){var statearr_40759 = state_40573;
(statearr_40759[(41)] = inst_40335);

return statearr_40759;
})();
if(cljs.core.truth_(inst_40273)){
var statearr_40760_40921 = state_40573__$1;
(statearr_40760_40921[(1)] = (50));

} else {
var statearr_40761_40922 = state_40573__$1;
(statearr_40761_40922[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40574 === (84))){
var inst_40286 = (state_40573[(8)]);
var inst_40284 = (state_40573[(9)]);
var inst_40425 = (state_40573[(2)]);
var inst_40426 = fluree.db.util.async.throw_err(inst_40425);
var inst_40427 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40286,fuel,max_fuel,inst_40284,inst_40426);
var state_40573__$1 = state_40573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40573__$1,(85),inst_40427);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__17133__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__17133__auto____0 = (function (){
var statearr_40762 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40762[(0)] = fluree$db$query$fql$query_$_state_machine__17133__auto__);

(statearr_40762[(1)] = (1));

return statearr_40762;
});
var fluree$db$query$fql$query_$_state_machine__17133__auto____1 = (function (state_40573){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_40573);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e40763){var ex__17136__auto__ = e40763;
var statearr_40764_40923 = state_40573;
(statearr_40764_40923[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_40573[(4)]))){
var statearr_40765_40924 = state_40573;
(statearr_40765_40924[(1)] = cljs.core.first((state_40573[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__40925 = state_40573;
state_40573 = G__40925;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__17133__auto__ = function(state_40573){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__17133__auto____1.call(this,state_40573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__17133__auto____0;
fluree$db$query$fql$query_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__17133__auto____1;
return fluree$db$query$fql$query_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_40766 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_40766[(6)] = c__17207__auto__);

return statearr_40766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}

});
