// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__31725 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31725,(5),null);
var G__31728 = idx;
var G__31728__$1 = (((G__31728 instanceof cljs.core.Keyword))?G__31728.fqn:null);
switch (G__31728__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31728__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__31730 = idx;
var G__31730__$1 = (((G__31730 instanceof cljs.core.Keyword))?G__31730.fqn:null);
switch (G__31730__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31730__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__31732 = idx;
var G__31732__$1 = (((G__31732 instanceof cljs.core.Keyword))?G__31732.fqn:null);
switch (G__31732__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31732__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_31772){
var state_val_31773 = (state_31772[(1)]);
if((state_val_31773 === (7))){
var inst_31749 = (state_31772[(7)]);
var inst_31756 = (state_31772[(2)]);
var inst_31757 = fluree.db.util.async.throw_err(inst_31756);
var state_31772__$1 = (function (){var statearr_31774 = state_31772;
(statearr_31774[(8)] = inst_31757);

return statearr_31774;
})();
if(cljs.core.truth_(inst_31749)){
var statearr_31775_31799 = state_31772__$1;
(statearr_31775_31799[(1)] = (8));

} else {
var statearr_31776_31800 = state_31772__$1;
(statearr_31776_31800[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (1))){
var state_31772__$1 = state_31772;
var statearr_31777_31801 = state_31772__$1;
(statearr_31777_31801[(2)] = null);

(statearr_31777_31801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (4))){
var inst_31734 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31778_31802 = state_31772__$1;
(statearr_31778_31802[(2)] = inst_31734);

(statearr_31778_31802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (13))){
var inst_31764 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31779_31803 = state_31772__$1;
(statearr_31779_31803[(2)] = inst_31764);

(statearr_31779_31803[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (6))){
var inst_31746 = (state_31772[(9)]);
var inst_31752 = (state_31772[(2)]);
var inst_31753 = fluree.db.util.async.throw_err(inst_31752);
var inst_31754 = fluree.db.query.range.resolve_subid(db,inst_31746);
var state_31772__$1 = (function (){var statearr_31780 = state_31772;
(statearr_31780[(10)] = inst_31753);

return statearr_31780;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31772__$1,(7),inst_31754);
} else {
if((state_val_31773 === (3))){
var inst_31770 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31772__$1,inst_31770);
} else {
if((state_val_31773 === (12))){
var state_31772__$1 = state_31772;
var statearr_31781_31804 = state_31772__$1;
(statearr_31781_31804[(2)] = (2147483647));

(statearr_31781_31804[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (2))){
var _ = (function (){var statearr_31782 = state_31772;
(statearr_31782[(4)] = cljs.core.cons((5),(state_31772[(4)])));

return statearr_31782;
})();
var inst_31743 = parts;
var inst_31744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(0),null);
var inst_31745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(1),null);
var inst_31746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(2),null);
var inst_31747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(3),null);
var inst_31748 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(4),null);
var inst_31749 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(5),null);
var inst_31750 = fluree.db.query.range.resolve_subid(db,inst_31744);
var state_31772__$1 = (function (){var statearr_31783 = state_31772;
(statearr_31783[(7)] = inst_31749);

(statearr_31783[(11)] = inst_31745);

(statearr_31783[(12)] = inst_31748);

(statearr_31783[(9)] = inst_31746);

(statearr_31783[(13)] = inst_31747);

return statearr_31783;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31772__$1,(6),inst_31750);
} else {
if((state_val_31773 === (11))){
var state_31772__$1 = state_31772;
var statearr_31785_31805 = state_31772__$1;
(statearr_31785_31805[(2)] = fluree.db.util.core.min_integer);

(statearr_31785_31805[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (9))){
var inst_31760 = (cljs.core._GT__EQ_ === test);
var state_31772__$1 = state_31772;
if(cljs.core.truth_(inst_31760)){
var statearr_31786_31806 = state_31772__$1;
(statearr_31786_31806[(1)] = (11));

} else {
var statearr_31787_31807 = state_31772__$1;
(statearr_31787_31807[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (5))){
var _ = (function (){var statearr_31788 = state_31772;
(statearr_31788[(4)] = cljs.core.rest((state_31772[(4)])));

return statearr_31788;
})();
var state_31772__$1 = state_31772;
var ex31784 = (state_31772__$1[(2)]);
var statearr_31789_31808 = state_31772__$1;
(statearr_31789_31808[(5)] = ex31784);


if((ex31784 instanceof Error)){
var statearr_31790_31809 = state_31772__$1;
(statearr_31790_31809[(1)] = (4));

(statearr_31790_31809[(5)] = null);

} else {
throw ex31784;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (10))){
var inst_31745 = (state_31772[(11)]);
var inst_31748 = (state_31772[(12)]);
var inst_31757 = (state_31772[(8)]);
var inst_31753 = (state_31772[(10)]);
var inst_31747 = (state_31772[(13)]);
var inst_31766 = (state_31772[(2)]);
var inst_31767 = fluree.db.flake.__GT_Flake(inst_31753,inst_31745,inst_31757,inst_31747,inst_31748,inst_31766);
var _ = (function (){var statearr_31791 = state_31772;
(statearr_31791[(4)] = cljs.core.rest((state_31772[(4)])));

return statearr_31791;
})();
var state_31772__$1 = state_31772;
var statearr_31792_31810 = state_31772__$1;
(statearr_31792_31810[(2)] = inst_31767);

(statearr_31792_31810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (8))){
var inst_31749 = (state_31772[(7)]);
var state_31772__$1 = state_31772;
var statearr_31793_31811 = state_31772__$1;
(statearr_31793_31811[(2)] = inst_31749);

(statearr_31793_31811[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____0 = (function (){
var statearr_31794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31794[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__);

(statearr_31794[(1)] = (1));

return statearr_31794;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____1 = (function (state_31772){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_31772);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e31795){var ex__17136__auto__ = e31795;
var statearr_31796_31812 = state_31772;
(statearr_31796_31812[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_31772[(4)]))){
var statearr_31797_31813 = state_31772;
(statearr_31797_31813[(1)] = cljs.core.first((state_31772[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__31814 = state_31772;
state_31772 = G__31814;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__ = function(state_31772){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____1.call(this,state_31772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_31798 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_31798[(6)] = c__17207__auto__);

return statearr_31798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Returns a channel that will eventually contain a stream of index nodes from
 *   index `idx` within the database `db` between `start-flake` and `end-flake`,
 *   inclusive and one-by-one
 */
fluree.db.query.range.index_node_stream = (function fluree$db$query$range$index_node_stream(db,idx,start_flake,end_flake){
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__17207__auto___31875 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_31851){
var state_val_31852 = (state_31851[(1)]);
if((state_val_31852 === (7))){
var inst_31829 = (state_31851[(2)]);
var inst_31830 = cljs.core.not(inst_31829);
var state_31851__$1 = state_31851;
if(inst_31830){
var statearr_31853_31876 = state_31851__$1;
(statearr_31853_31876[(1)] = (8));

} else {
var statearr_31854_31877 = state_31851__$1;
(statearr_31854_31877[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (1))){
var inst_31815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31816 = fluree.db.dbproto._resolve(inst_31815);
var state_31851__$1 = state_31851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31851__$1,(2),inst_31816);
} else {
if((state_val_31852 === (4))){
var inst_31849 = (state_31851[(2)]);
var state_31851__$1 = state_31851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31851__$1,inst_31849);
} else {
if((state_val_31852 === (15))){
var inst_31845 = (state_31851[(2)]);
var state_31851__$1 = state_31851;
var statearr_31855_31878 = state_31851__$1;
(statearr_31855_31878[(2)] = inst_31845);

(statearr_31855_31878[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (13))){
var inst_31837 = (state_31851[(7)]);
var inst_31841 = fluree.db.dbproto._rhs(inst_31837);
var inst_31821 = inst_31841;
var state_31851__$1 = (function (){var statearr_31856 = state_31851;
(statearr_31856[(8)] = inst_31821);

return statearr_31856;
})();
var statearr_31857_31879 = state_31851__$1;
(statearr_31857_31879[(2)] = null);

(statearr_31857_31879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (6))){
var inst_31821 = (state_31851[(8)]);
var state_31851__$1 = state_31851;
var statearr_31858_31880 = state_31851__$1;
(statearr_31858_31880[(2)] = inst_31821);

(statearr_31858_31880[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (3))){
var inst_31821 = (state_31851[(8)]);
var state_31851__$1 = state_31851;
if(cljs.core.truth_(inst_31821)){
var statearr_31859_31881 = state_31851__$1;
(statearr_31859_31881[(1)] = (5));

} else {
var statearr_31860_31882 = state_31851__$1;
(statearr_31860_31882[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (12))){
var inst_31839 = (state_31851[(2)]);
var state_31851__$1 = state_31851;
if(cljs.core.truth_(inst_31839)){
var statearr_31861_31883 = state_31851__$1;
(statearr_31861_31883[(1)] = (13));

} else {
var statearr_31862_31884 = state_31851__$1;
(statearr_31862_31884[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (2))){
var inst_31818 = (state_31851[(2)]);
var inst_31819 = fluree.db.util.async.throw_err(inst_31818);
var inst_31820 = start_flake;
var inst_31821 = inst_31820;
var state_31851__$1 = (function (){var statearr_31863 = state_31851;
(statearr_31863[(9)] = inst_31819);

(statearr_31863[(8)] = inst_31821);

return statearr_31863;
})();
var statearr_31864_31885 = state_31851__$1;
(statearr_31864_31885[(2)] = null);

(statearr_31864_31885[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (11))){
var inst_31837 = (state_31851[(7)]);
var inst_31836 = (state_31851[(2)]);
var inst_31837__$1 = fluree.db.util.async.throw_err(inst_31836);
var state_31851__$1 = (function (){var statearr_31865 = state_31851;
(statearr_31865[(7)] = inst_31837__$1);

return statearr_31865;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31851__$1,(12),out,inst_31837__$1);
} else {
if((state_val_31852 === (9))){
var inst_31819 = (state_31851[(9)]);
var inst_31821 = (state_31851[(8)]);
var inst_31834 = fluree.db.dbproto._lookup_leaf(inst_31819,inst_31821);
var state_31851__$1 = state_31851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31851__$1,(11),inst_31834);
} else {
if((state_val_31852 === (5))){
var inst_31821 = (state_31851[(8)]);
var inst_31824 = (idx_compare.cljs$core$IFn$_invoke$arity$2 ? idx_compare.cljs$core$IFn$_invoke$arity$2(inst_31821,end_flake) : idx_compare.call(null,inst_31821,end_flake));
var inst_31825 = (inst_31824 > (0));
var inst_31826 = cljs.core.not(inst_31825);
var state_31851__$1 = state_31851;
var statearr_31866_31886 = state_31851__$1;
(statearr_31866_31886[(2)] = inst_31826);

(statearr_31866_31886[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (14))){
var state_31851__$1 = state_31851;
var statearr_31867_31887 = state_31851__$1;
(statearr_31867_31887[(2)] = null);

(statearr_31867_31887[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (10))){
var inst_31847 = (state_31851[(2)]);
var state_31851__$1 = state_31851;
var statearr_31868_31888 = state_31851__$1;
(statearr_31868_31888[(2)] = inst_31847);

(statearr_31868_31888[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31852 === (8))){
var inst_31832 = cljs.core.async.close_BANG_(out);
var state_31851__$1 = state_31851;
var statearr_31869_31889 = state_31851__$1;
(statearr_31869_31889[(2)] = inst_31832);

(statearr_31869_31889[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__ = null;
var fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____0 = (function (){
var statearr_31870 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31870[(0)] = fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__);

(statearr_31870[(1)] = (1));

return statearr_31870;
});
var fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____1 = (function (state_31851){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_31851);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e31871){var ex__17136__auto__ = e31871;
var statearr_31872_31890 = state_31851;
(statearr_31872_31890[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_31851[(4)]))){
var statearr_31873_31891 = state_31851;
(statearr_31873_31891[(1)] = cljs.core.first((state_31851[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__31892 = state_31851;
state_31851 = G__31892;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__ = function(state_31851){
switch(arguments.length){
case 0:
return fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____1.call(this,state_31851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____0;
fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$index_node_stream_$_state_machine__17133__auto____1;
return fluree$db$query$range$index_node_stream_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_31874 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_31874[(6)] = c__17207__auto___31875);

return statearr_31874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
});
fluree.db.query.range.flake_subrange_xf = (function fluree$db$query$range$flake_subrange_xf(start_test,start_flake,end_test,end_flake){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (flake_range){
return fluree.db.flake.subrange(flake_range,start_test,start_flake,end_test,end_flake);
}));
});
/**
 * Returns a channel that will eventually contain a stream of flakes between
 *   `start-flake` and `end-flake`, according to `start-test` and `end-test`,
 *   respectively, and also contained within the history range between `from-t` and
 *   `to-t` for some index data node in the `node-stream` channel.
 */
fluree.db.query.range.expand_history_range = (function fluree$db$query$range$expand_history_range(node_stream,from_t,to_t,novelty,start_test,start_flake,end_test,end_flake){
var subrange_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),fluree.db.query.range.flake_subrange_xf(start_test,start_flake,end_test,end_flake));
var c__17207__auto___31936 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_31916){
var state_val_31917 = (state_31916[(1)]);
if((state_val_31917 === (7))){
var inst_31912 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31918_31937 = state_31916__$1;
(statearr_31918_31937[(2)] = inst_31912);

(statearr_31918_31937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (1))){
var state_31916__$1 = state_31916;
var statearr_31919_31938 = state_31916__$1;
(statearr_31919_31938[(2)] = null);

(statearr_31919_31938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (4))){
var inst_31895 = (state_31916[(7)]);
var inst_31895__$1 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_31920 = state_31916;
(statearr_31920[(7)] = inst_31895__$1);

return statearr_31920;
})();
if(cljs.core.truth_(inst_31895__$1)){
var statearr_31921_31939 = state_31916__$1;
(statearr_31921_31939[(1)] = (5));

} else {
var statearr_31922_31940 = state_31916__$1;
(statearr_31922_31940[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (6))){
var inst_31910 = cljs.core.async.close_BANG_(subrange_ch);
var state_31916__$1 = state_31916;
var statearr_31923_31941 = state_31916__$1;
(statearr_31923_31941[(2)] = inst_31910);

(statearr_31923_31941[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (3))){
var inst_31914 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31916__$1,inst_31914);
} else {
if((state_val_31917 === (12))){
var inst_31904 = (state_31916[(2)]);
var state_31916__$1 = state_31916;
var statearr_31924_31942 = state_31916__$1;
(statearr_31924_31942[(2)] = inst_31904);

(statearr_31924_31942[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (2))){
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(4),node_stream);
} else {
if((state_val_31917 === (11))){
var inst_31907 = (state_31916[(2)]);
var state_31916__$1 = (function (){var statearr_31925 = state_31916;
(statearr_31925[(8)] = inst_31907);

return statearr_31925;
})();
var statearr_31926_31943 = state_31916__$1;
(statearr_31926_31943[(2)] = null);

(statearr_31926_31943[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (9))){
var inst_31900 = (state_31916[(9)]);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31916__$1,(12),subrange_ch,inst_31900);
} else {
if((state_val_31917 === (5))){
var inst_31895 = (state_31916[(7)]);
var inst_31897 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_31895,from_t,to_t,novelty);
var state_31916__$1 = state_31916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31916__$1,(8),inst_31897);
} else {
if((state_val_31917 === (10))){
var state_31916__$1 = state_31916;
var statearr_31927_31944 = state_31916__$1;
(statearr_31927_31944[(2)] = null);

(statearr_31927_31944[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31917 === (8))){
var inst_31900 = (state_31916[(9)]);
var inst_31899 = (state_31916[(2)]);
var inst_31900__$1 = fluree.db.util.async.throw_err(inst_31899);
var inst_31901 = cljs.core.seq(inst_31900__$1);
var state_31916__$1 = (function (){var statearr_31928 = state_31916;
(statearr_31928[(9)] = inst_31900__$1);

return statearr_31928;
})();
if(inst_31901){
var statearr_31929_31945 = state_31916__$1;
(statearr_31929_31945[(1)] = (9));

} else {
var statearr_31930_31946 = state_31916__$1;
(statearr_31930_31946[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__ = null;
var fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____0 = (function (){
var statearr_31931 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31931[(0)] = fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__);

(statearr_31931[(1)] = (1));

return statearr_31931;
});
var fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____1 = (function (state_31916){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_31916);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e31932){var ex__17136__auto__ = e31932;
var statearr_31933_31947 = state_31916;
(statearr_31933_31947[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_31916[(4)]))){
var statearr_31934_31948 = state_31916;
(statearr_31934_31948[(1)] = cljs.core.first((state_31916[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__31949 = state_31916;
state_31916 = G__31949;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__ = function(state_31916){
switch(arguments.length){
case 0:
return fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____1.call(this,state_31916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____0;
fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$expand_history_range_$_state_machine__17133__auto____1;
return fluree$db$query$range$expand_history_range_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_31935 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_31935[(6)] = c__17207__auto___31936);

return statearr_31935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return subrange_ch;
});
/**
 * Returns a channel that will eventually contain only the schema flakes and the
 *   flakes validated by fluree.db.permissions-validate/allow-flake? function for
 *   the database `db` from the `flake-stream` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(flake_stream,p__31950,start,end){
var map__31951 = p__31950;
var map__31951__$1 = (((((!((map__31951 == null))))?(((((map__31951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31951.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31951):map__31951);
var db = map__31951__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$permissions);
return flake_stream;
});
fluree.db.query.range.take_only = (function fluree$db$query$range$take_only(flake_chan,limit){
if(cljs.core.truth_(limit)){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2(limit,flake_chan);
} else {
return flake_chan;
}
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__31953 = cljs.core.identical_QMARK_;
var expr__31954 = test;
if(cljs.core.truth_((pred__31953.cljs$core$IFn$_invoke$arity$2 ? pred__31953.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__31954) : pred__31953.call(null,cljs.core._EQ_,expr__31954)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31953.cljs$core$IFn$_invoke$arity$2 ? pred__31953.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__31954) : pred__31953.call(null,cljs.core._LT_,expr__31954)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__31953.cljs$core$IFn$_invoke$arity$2 ? pred__31953.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__31954) : pred__31953.call(null,cljs.core._LT__EQ_,expr__31954)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31953.cljs$core$IFn$_invoke$arity$2 ? pred__31953.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__31954) : pred__31953.call(null,cljs.core._GT_,expr__31954)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__31953.cljs$core$IFn$_invoke$arity$2 ? pred__31953.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__31954) : pred__31953.call(null,cljs.core._GT__EQ_,expr__31954)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31954)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__31957 = arguments.length;
switch (G__31957) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31958 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31958,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31958,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31958,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31958,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__31961,idx,start_test,start_match,end_test,end_match,opts){
var map__31962 = p__31961;
var map__31962__$1 = (((((!((map__31962 == null))))?(((((map__31962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31962):map__31962);
var db = map__31962__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31962__$1,cljs.core.cst$kw$t);
var map__31964 = opts;
var map__31964__$1 = (((((!((map__31964 == null))))?(((((map__31964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31964):map__31964);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31964__$1,cljs.core.cst$kw$limit);
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31964__$1,cljs.core.cst$kw$from_DASH_t,t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31964__$1,cljs.core.cst$kw$to_DASH_t);
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$novelty,idx], null));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var out_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,idx_compare,flakes);
})));
var c__17207__auto___31991 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_31982){
var state_val_31983 = (state_31982[(1)]);
if((state_val_31983 === (1))){
var inst_31966 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_31982__$1 = state_31982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31982__$1,(2),inst_31966);
} else {
if((state_val_31983 === (2))){
var inst_31968 = (state_31982[(2)]);
var inst_31969 = fluree.db.util.async.throw_err(inst_31968);
var inst_31970 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_31982__$1 = (function (){var statearr_31984 = state_31982;
(statearr_31984[(7)] = inst_31969);

return statearr_31984;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31982__$1,(3),inst_31970);
} else {
if((state_val_31983 === (3))){
var inst_31969 = (state_31982[(7)]);
var inst_31972 = (state_31982[(2)]);
var inst_31973 = fluree.db.util.async.throw_err(inst_31972);
var inst_31974 = cljs.core.PersistentVector.EMPTY;
var inst_31975 = fluree.db.query.range.index_node_stream(db,idx,inst_31969,inst_31973);
var inst_31976 = fluree.db.query.range.expand_history_range(inst_31975,from_t,to_t,novelty,start_test,inst_31969,end_test,inst_31973);
var inst_31977 = fluree.db.query.range.filter_authorized(inst_31976,db,inst_31969,inst_31973);
var inst_31978 = fluree.db.query.range.take_only(inst_31977,limit);
var inst_31979 = cljs.core.async.into(inst_31974,inst_31978);
var inst_31980 = cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(inst_31979,out_chan);
var state_31982__$1 = state_31982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31982__$1,inst_31980);
} else {
return null;
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17133__auto__ = null;
var fluree$db$query$range$state_machine__17133__auto____0 = (function (){
var statearr_31985 = [null,null,null,null,null,null,null,null];
(statearr_31985[(0)] = fluree$db$query$range$state_machine__17133__auto__);

(statearr_31985[(1)] = (1));

return statearr_31985;
});
var fluree$db$query$range$state_machine__17133__auto____1 = (function (state_31982){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_31982);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e31986){var ex__17136__auto__ = e31986;
var statearr_31987_31992 = state_31982;
(statearr_31987_31992[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_31982[(4)]))){
var statearr_31988_31993 = state_31982;
(statearr_31988_31993[(1)] = cljs.core.first((state_31982[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__31994 = state_31982;
state_31982 = G__31994;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17133__auto__ = function(state_31982){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17133__auto____1.call(this,state_31982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17133__auto____0;
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17133__auto____1;
return fluree$db$query$range$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_31989 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_31989[(6)] = c__17207__auto___31991);

return statearr_31989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out_chan;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Returns a channel that will eventually contain a stream of index nodes where
 *   each node in the output stream is the result of resolving a node in the input
 *   `node-stream` at specified transaction `t` and index novelty `novelty`
 */
fluree.db.query.range.resolve_nodes_to_t = (function fluree$db$query$range$resolve_nodes_to_t(nodes,novelty,fast_forward_db_QMARK_,t){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__17207__auto___32063 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_32030){
var state_val_32031 = (state_32030[(1)]);
if((state_val_32031 === (7))){
var inst_32026 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32032_32064 = state_32030__$1;
(statearr_32032_32064[(2)] = inst_32026);

(statearr_32032_32064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (1))){
var state_32030__$1 = state_32030;
var statearr_32033_32065 = state_32030__$1;
(statearr_32033_32065[(2)] = null);

(statearr_32033_32065[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (4))){
var inst_31997 = (state_32030[(7)]);
var inst_31997__$1 = (state_32030[(2)]);
var state_32030__$1 = (function (){var statearr_32034 = state_32030;
(statearr_32034[(7)] = inst_31997__$1);

return statearr_32034;
})();
if(cljs.core.truth_(inst_31997__$1)){
var statearr_32035_32066 = state_32030__$1;
(statearr_32035_32066[(1)] = (5));

} else {
var statearr_32036_32067 = state_32030__$1;
(statearr_32036_32067[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (15))){
var inst_32022 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32037_32068 = state_32030__$1;
(statearr_32037_32068[(2)] = inst_32022);

(statearr_32037_32068[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (13))){
var inst_32011 = (state_32030[(8)]);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32030__$1,(16),out,inst_32011);
} else {
if((state_val_32031 === (6))){
var inst_32024 = cljs.core.async.close_BANG_(out);
var state_32030__$1 = state_32030;
var statearr_32038_32069 = state_32030__$1;
(statearr_32038_32069[(2)] = inst_32024);

(statearr_32038_32069[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (17))){
var state_32030__$1 = state_32030;
var statearr_32039_32070 = state_32030__$1;
(statearr_32039_32070[(2)] = null);

(statearr_32039_32070[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (3))){
var inst_32028 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32030__$1,inst_32028);
} else {
if((state_val_32031 === (12))){
var inst_32007 = (state_32030[(2)]);
var inst_32008 = fluree.db.util.async.throw_err(inst_32007);
var _ = (function (){var statearr_32040 = state_32030;
(statearr_32040[(4)] = cljs.core.rest((state_32030[(4)])));

return statearr_32040;
})();
var state_32030__$1 = state_32030;
var statearr_32041_32071 = state_32030__$1;
(statearr_32041_32071[(2)] = inst_32008);

(statearr_32041_32071[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (2))){
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32030__$1,(4),nodes);
} else {
if((state_val_32031 === (19))){
var inst_32019 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
var statearr_32043_32072 = state_32030__$1;
(statearr_32043_32072[(2)] = inst_32019);

(statearr_32043_32072[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (11))){
var _ = (function (){var statearr_32044 = state_32030;
(statearr_32044[(4)] = cljs.core.rest((state_32030[(4)])));

return statearr_32044;
})();
var state_32030__$1 = state_32030;
var ex32042 = (state_32030__$1[(2)]);
var statearr_32045_32073 = state_32030__$1;
(statearr_32045_32073[(5)] = ex32042);


var statearr_32046_32074 = state_32030__$1;
(statearr_32046_32074[(1)] = (10));

(statearr_32046_32074[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (9))){
var inst_32011 = (state_32030[(8)]);
var inst_32011__$1 = (state_32030[(2)]);
var state_32030__$1 = (function (){var statearr_32047 = state_32030;
(statearr_32047[(8)] = inst_32011__$1);

return statearr_32047;
})();
if(cljs.core.truth_(inst_32011__$1)){
var statearr_32048_32075 = state_32030__$1;
(statearr_32048_32075[(1)] = (13));

} else {
var statearr_32049_32076 = state_32030__$1;
(statearr_32049_32076[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (5))){
var state_32030__$1 = state_32030;
var statearr_32050_32077 = state_32030__$1;
(statearr_32050_32077[(2)] = null);

(statearr_32050_32077[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (14))){
var state_32030__$1 = state_32030;
var statearr_32051_32078 = state_32030__$1;
(statearr_32051_32078[(2)] = null);

(statearr_32051_32078[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (16))){
var inst_32014 = (state_32030[(2)]);
var state_32030__$1 = state_32030;
if(cljs.core.truth_(inst_32014)){
var statearr_32052_32079 = state_32030__$1;
(statearr_32052_32079[(1)] = (17));

} else {
var statearr_32053_32080 = state_32030__$1;
(statearr_32053_32080[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (10))){
var inst_31999 = (state_32030[(2)]);
var state_32030__$1 = (function (){var statearr_32054 = state_32030;
(statearr_32054[(9)] = inst_31999);

return statearr_32054;
})();
var statearr_32055_32081 = state_32030__$1;
(statearr_32055_32081[(2)] = null);

(statearr_32055_32081[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (18))){
var state_32030__$1 = state_32030;
var statearr_32056_32082 = state_32030__$1;
(statearr_32056_32082[(2)] = null);

(statearr_32056_32082[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32031 === (8))){
var inst_31997 = (state_32030[(7)]);
var _ = (function (){var statearr_32057 = state_32030;
(statearr_32057[(4)] = cljs.core.cons((11),(state_32030[(4)])));

return statearr_32057;
})();
var inst_32005 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_31997,t,novelty,fast_forward_db_QMARK_);
var state_32030__$1 = state_32030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32030__$1,(12),inst_32005);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__ = null;
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____0 = (function (){
var statearr_32058 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32058[(0)] = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__);

(statearr_32058[(1)] = (1));

return statearr_32058;
});
var fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____1 = (function (state_32030){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_32030);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e32059){var ex__17136__auto__ = e32059;
var statearr_32060_32083 = state_32030;
(statearr_32060_32083[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_32030[(4)]))){
var statearr_32061_32084 = state_32030;
(statearr_32061_32084[(1)] = cljs.core.first((state_32030[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__32085 = state_32030;
state_32030 = G__32085;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__ = function(state_32030){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____1.call(this,state_32030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____0;
fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto____1;
return fluree$db$query$range$resolve_nodes_to_t_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_32062 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_32062[(6)] = c__17207__auto___32063);

return statearr_32062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out;
});
/**
 * Returns a transducer that first extracts a flake set under the `:flakes` keys
 *   from it's input stream of index nodes, filters those flakes down to those
 *   between the `start-flake` and `end-flake` options according to the
 *   `start-test` and `end-test` options, respectively, and further filters the
 *   flake stream according to the `subject-fn`, `predicate-fn`, and `object-fn`
 *   options if they are present.
 */
fluree.db.query.range.indexed_flakes_xf = (function fluree$db$query$range$indexed_flakes_xf(p__32086){
var map__32087 = p__32086;
var map__32087__$1 = (((((!((map__32087 == null))))?(((((map__32087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32087.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32087):map__32087);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$start_DASH_test);
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$start_DASH_flake);
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$end_DASH_test);
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$end_DASH_flake);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$subject_DASH_fn);
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$predicate_DASH_fn);
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32087__$1,cljs.core.cst$kw$object_DASH_fn);
var flakes_xf = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$flakes);
var subrange_xf = fluree.db.query.range.flake_subrange_xf(start_test,start_flake,end_test,end_flake);
var xforms = (function (){var G__32089 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flakes_xf,subrange_xf], null);
var G__32089__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__32089,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__32090 = f.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__32090) : subject_fn.call(null,G__32090));
}))):G__32089);
var G__32089__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__32089__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__32091 = f.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__32091) : predicate_fn.call(null,G__32091));
}))):G__32089__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__32089__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__32092 = f.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__32092) : object_fn.call(null,G__32092));
})));
} else {
return G__32089__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,xforms);
});
fluree.db.query.range.extract_index_flakes = (function fluree$db$query$range$extract_index_flakes(node_stream,opts){
var index_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),fluree.db.query.range.indexed_flakes_xf(opts));
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(node_stream,index_chan);
});
/**
 * Returns a channel that contains the flakes from `flake-stream`, skipping the
 *   flakes from the first `offset` subjects encountered, including a maximum of
 *   `flake-limit` flakes from a maximum of `subject-limit` subjects.
 */
fluree.db.query.range.select_subject_window = (function fluree$db$query$range$select_subject_window(flake_stream,p__32093){
var map__32094 = p__32093;
var map__32094__$1 = (((((!((map__32094 == null))))?(((((map__32094.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32094.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32094):map__32094);
var subject_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$subject_DASH_limit);
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$flake_DASH_limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$offset);
var offset_subject_xf = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((function (f){
return f.s;
})),cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset));
var subject_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),offset_subject_xf);
var flake_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.cat);
return fluree.db.query.range.take_only(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.query.range.take_only(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(flake_stream,subject_ch),subject_limit),flake_ch),flake_limit);
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__32097 = arguments.length;
switch (G__32097) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__32098 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32098,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32098,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32098,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32098,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__32101,idx,start_test,start_match,end_test,end_match,opts){
var map__32102 = p__32101;
var map__32102__$1 = (((((!((map__32102 == null))))?(((((map__32102.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32102.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32102):map__32102);
var db = map__32102__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32102__$1,cljs.core.cst$kw$permissions);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32102__$1,cljs.core.cst$kw$t);
var map__32104 = opts;
var map__32104__$1 = (((((!((map__32104 == null))))?(((((map__32104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32104):map__32104);
var subject_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32104__$1,cljs.core.cst$kw$limit);
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32104__$1,cljs.core.cst$kw$flake_DASH_limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32104__$1,cljs.core.cst$kw$offset,(0));
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32104__$1,cljs.core.cst$kw$subject_DASH_fn);
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32104__$1,cljs.core.cst$kw$predicate_DASH_fn);
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32104__$1,cljs.core.cst$kw$object_DASH_fn);
var fast_forward_db_QMARK_ = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$novelty,idx], null));
var vec__32105 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32105,(5),null);
var vec__32108 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(5),null);
var vec__32111 = (function (){var temp__5756__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5756__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5756__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__32114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32111,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32114,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32114,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32111,(1),null);
var out_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,idx_compare,flakes);
})));
var c__17207__auto___32156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_32147){
var state_val_32148 = (state_32147[(1)]);
if((state_val_32148 === (1))){
var inst_32118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32119 = [s1,p1,o1__$1,t1,op1,m1];
var inst_32120 = (new cljs.core.PersistentVector(null,6,(5),inst_32118,inst_32119,null));
var inst_32121 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_32120);
var state_32147__$1 = state_32147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32147__$1,(2),inst_32121);
} else {
if((state_val_32148 === (2))){
var inst_32123 = (state_32147[(2)]);
var inst_32124 = fluree.db.util.async.throw_err(inst_32123);
var inst_32125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32126 = [s2,p2,o2__$1,t2,op2,m2];
var inst_32127 = (new cljs.core.PersistentVector(null,6,(5),inst_32125,inst_32126,null));
var inst_32128 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_32127);
var state_32147__$1 = (function (){var statearr_32149 = state_32147;
(statearr_32149[(7)] = inst_32124);

return statearr_32149;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32147__$1,(3),inst_32128);
} else {
if((state_val_32148 === (3))){
var inst_32124 = (state_32147[(7)]);
var inst_32130 = (state_32147[(2)]);
var inst_32131 = fluree.db.util.async.throw_err(inst_32130);
var inst_32132 = cljs.core.PersistentVector.EMPTY;
var inst_32133 = fluree.db.query.range.index_node_stream(db,idx,inst_32124,inst_32131);
var inst_32134 = fluree.db.query.range.resolve_nodes_to_t(inst_32133,novelty,fast_forward_db_QMARK_,t);
var inst_32135 = [cljs.core.cst$kw$subject_DASH_fn,cljs.core.cst$kw$predicate_DASH_fn,cljs.core.cst$kw$object_DASH_fn,cljs.core.cst$kw$start_DASH_test,cljs.core.cst$kw$start_DASH_flake,cljs.core.cst$kw$end_DASH_test,cljs.core.cst$kw$end_DASH_flake];
var inst_32136 = [subject_fn,predicate_fn,object_fn__$1,start_test,inst_32124,end_test,inst_32131];
var inst_32137 = cljs.core.PersistentHashMap.fromArrays(inst_32135,inst_32136);
var inst_32138 = fluree.db.query.range.extract_index_flakes(inst_32134,inst_32137);
var inst_32139 = fluree.db.query.range.filter_authorized(inst_32138,db,inst_32124,inst_32131);
var inst_32140 = [cljs.core.cst$kw$subject_DASH_limit,cljs.core.cst$kw$flake_DASH_limit,cljs.core.cst$kw$offset];
var inst_32141 = [subject_limit,flake_limit,offset];
var inst_32142 = cljs.core.PersistentHashMap.fromArrays(inst_32140,inst_32141);
var inst_32143 = fluree.db.query.range.select_subject_window(inst_32139,inst_32142);
var inst_32144 = cljs.core.async.into(inst_32132,inst_32143);
var inst_32145 = cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(inst_32144,out_chan);
var state_32147__$1 = state_32147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32147__$1,inst_32145);
} else {
return null;
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17133__auto__ = null;
var fluree$db$query$range$state_machine__17133__auto____0 = (function (){
var statearr_32150 = [null,null,null,null,null,null,null,null];
(statearr_32150[(0)] = fluree$db$query$range$state_machine__17133__auto__);

(statearr_32150[(1)] = (1));

return statearr_32150;
});
var fluree$db$query$range$state_machine__17133__auto____1 = (function (state_32147){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_32147);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e32151){var ex__17136__auto__ = e32151;
var statearr_32152_32157 = state_32147;
(statearr_32152_32157[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_32147[(4)]))){
var statearr_32153_32158 = state_32147;
(statearr_32153_32158[(1)] = cljs.core.first((state_32147[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__32159 = state_32147;
state_32147 = G__32159;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17133__auto__ = function(state_32147){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17133__auto____1.call(this,state_32147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17133__auto____0;
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17133__auto____1;
return fluree$db$query$range$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_32154 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_32154[(6)] = c__17207__auto___32156);

return statearr_32154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return out_chan;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_32215){
var state_val_32216 = (state_32215[(1)]);
if((state_val_32216 === (7))){
var inst_32179 = (state_32215[(7)]);
var inst_32189 = (state_32215[(8)]);
var inst_32187 = fluree.db.flake.Flake__GT_parts(inst_32179);
var inst_32188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(0),null);
var inst_32189__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(1),null);
var inst_32190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(2),null);
var inst_32191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(3),null);
var inst_32192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(4),null);
var inst_32193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(5),null);
var inst_32194 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_32190,inst_32189__$1);
var state_32215__$1 = (function (){var statearr_32217 = state_32215;
(statearr_32217[(9)] = inst_32191);

(statearr_32217[(10)] = inst_32192);

(statearr_32217[(11)] = inst_32193);

(statearr_32217[(12)] = inst_32188);

(statearr_32217[(8)] = inst_32189__$1);

return statearr_32217;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32215__$1,(10),inst_32194);
} else {
if((state_val_32216 === (1))){
var inst_32167 = flakes;
var inst_32168 = cljs.core.seq(inst_32167);
var inst_32169 = cljs.core.first(inst_32168);
var inst_32170 = cljs.core.next(inst_32168);
var inst_32171 = cljs.core.PersistentVector.EMPTY;
var inst_32172 = inst_32167;
var inst_32173 = inst_32171;
var state_32215__$1 = (function (){var statearr_32218 = state_32215;
(statearr_32218[(13)] = inst_32173);

(statearr_32218[(14)] = inst_32170);

(statearr_32218[(15)] = inst_32169);

(statearr_32218[(16)] = inst_32172);

return statearr_32218;
})();
var statearr_32219_32237 = state_32215__$1;
(statearr_32219_32237[(2)] = null);

(statearr_32219_32237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (4))){
var inst_32179 = (state_32215[(7)]);
var inst_32182 = fluree.db.query.range.is_tag_flake_QMARK_(inst_32179);
var state_32215__$1 = state_32215;
if(inst_32182){
var statearr_32220_32238 = state_32215__$1;
(statearr_32220_32238[(1)] = (7));

} else {
var statearr_32221_32239 = state_32215__$1;
(statearr_32221_32239[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (6))){
var inst_32211 = (state_32215[(2)]);
var state_32215__$1 = state_32215;
var statearr_32222_32240 = state_32215__$1;
(statearr_32222_32240[(2)] = inst_32211);

(statearr_32222_32240[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (3))){
var inst_32213 = (state_32215[(2)]);
var state_32215__$1 = state_32215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32215__$1,inst_32213);
} else {
if((state_val_32216 === (2))){
var inst_32179 = (state_32215[(7)]);
var inst_32172 = (state_32215[(16)]);
var inst_32178 = cljs.core.seq(inst_32172);
var inst_32179__$1 = cljs.core.first(inst_32178);
var inst_32180 = cljs.core.next(inst_32178);
var state_32215__$1 = (function (){var statearr_32223 = state_32215;
(statearr_32223[(7)] = inst_32179__$1);

(statearr_32223[(17)] = inst_32180);

return statearr_32223;
})();
if(cljs.core.truth_(inst_32179__$1)){
var statearr_32224_32241 = state_32215__$1;
(statearr_32224_32241[(1)] = (4));

} else {
var statearr_32225_32242 = state_32215__$1;
(statearr_32225_32242[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (9))){
var inst_32208 = (state_32215[(2)]);
var state_32215__$1 = state_32215;
var statearr_32226_32243 = state_32215__$1;
(statearr_32226_32243[(2)] = inst_32208);

(statearr_32226_32243[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (5))){
var inst_32173 = (state_32215[(13)]);
var state_32215__$1 = state_32215;
var statearr_32227_32244 = state_32215__$1;
(statearr_32227_32244[(2)] = inst_32173);

(statearr_32227_32244[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (10))){
var inst_32191 = (state_32215[(9)]);
var inst_32173 = (state_32215[(13)]);
var inst_32192 = (state_32215[(10)]);
var inst_32193 = (state_32215[(11)]);
var inst_32188 = (state_32215[(12)]);
var inst_32189 = (state_32215[(8)]);
var inst_32180 = (state_32215[(17)]);
var inst_32196 = (state_32215[(2)]);
var inst_32197 = fluree.db.util.async.throw_err(inst_32196);
var inst_32198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32199 = [inst_32188,inst_32189,inst_32197,inst_32191,inst_32192,inst_32193];
var inst_32200 = (new cljs.core.PersistentVector(null,6,(5),inst_32198,inst_32199,null));
var inst_32201 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_32200);
var inst_32202 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32173,inst_32201);
var inst_32172 = inst_32180;
var inst_32173__$1 = inst_32202;
var state_32215__$1 = (function (){var statearr_32228 = state_32215;
(statearr_32228[(13)] = inst_32173__$1);

(statearr_32228[(16)] = inst_32172);

return statearr_32228;
})();
var statearr_32229_32245 = state_32215__$1;
(statearr_32229_32245[(2)] = null);

(statearr_32229_32245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32216 === (8))){
var inst_32173 = (state_32215[(13)]);
var inst_32179 = (state_32215[(7)]);
var inst_32180 = (state_32215[(17)]);
var inst_32205 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32173,inst_32179);
var inst_32172 = inst_32180;
var inst_32173__$1 = inst_32205;
var state_32215__$1 = (function (){var statearr_32230 = state_32215;
(statearr_32230[(13)] = inst_32173__$1);

(statearr_32230[(16)] = inst_32172);

return statearr_32230;
})();
var statearr_32231_32246 = state_32215__$1;
(statearr_32231_32246[(2)] = null);

(statearr_32231_32246[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____0 = (function (){
var statearr_32232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32232[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__);

(statearr_32232[(1)] = (1));

return statearr_32232;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____1 = (function (state_32215){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_32215);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e32233){var ex__17136__auto__ = e32233;
var statearr_32234_32247 = state_32215;
(statearr_32234_32247[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_32215[(4)]))){
var statearr_32235_32248 = state_32215;
(statearr_32235_32248[(1)] = cljs.core.first((state_32215[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__32249 = state_32215;
state_32215 = G__32249;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__ = function(state_32215){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____1.call(this,state_32215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_32236 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_32236[(6)] = c__17207__auto__);

return statearr_32236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__32251 = arguments.length;
switch (G__32251) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_32402){
var state_val_32403 = (state_32402[(1)]);
if((state_val_32403 === (62))){
var inst_32389 = (state_32402[(7)]);
var state_32402__$1 = state_32402;
var statearr_32404_32493 = state_32402__$1;
(statearr_32404_32493[(2)] = inst_32389);

(statearr_32404_32493[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (7))){
var state_32402__$1 = state_32402;
var statearr_32405_32494 = state_32402__$1;
(statearr_32405_32494[(2)] = false);

(statearr_32405_32494[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (59))){
var inst_32381 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32406_32495 = state_32402__$1;
(statearr_32406_32495[(2)] = inst_32381);

(statearr_32406_32495[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (20))){
var state_32402__$1 = state_32402;
var statearr_32407_32496 = state_32402__$1;
(statearr_32407_32496[(2)] = null);

(statearr_32407_32496[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (58))){
var state_32402__$1 = state_32402;
var statearr_32408_32497 = state_32402__$1;
(statearr_32408_32497[(2)] = null);

(statearr_32408_32497[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (60))){
var inst_32377 = (state_32402[(2)]);
var inst_32378 = fluree.db.util.async.throw_err(inst_32377);
var state_32402__$1 = state_32402;
var statearr_32409_32498 = state_32402__$1;
(statearr_32409_32498[(2)] = inst_32378);

(statearr_32409_32498[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (27))){
var inst_32302 = (state_32402[(8)]);
var inst_32313 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_32302);
var state_32402__$1 = state_32402;
if(inst_32313){
var statearr_32410_32499 = state_32402__$1;
(statearr_32410_32499[(1)] = (30));

} else {
var statearr_32411_32500 = state_32402__$1;
(statearr_32411_32500[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (1))){
var state_32402__$1 = state_32402;
var statearr_32412_32501 = state_32402__$1;
(statearr_32412_32501[(2)] = null);

(statearr_32412_32501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (24))){
var inst_32263 = (state_32402[(9)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32263)){
var statearr_32413_32502 = state_32402__$1;
(statearr_32413_32502[(1)] = (27));

} else {
var statearr_32414_32503 = state_32402__$1;
(statearr_32414_32503[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (55))){
var inst_32383 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32415_32504 = state_32402__$1;
(statearr_32415_32504[(2)] = inst_32383);

(statearr_32415_32504[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (39))){
var inst_32333 = (state_32402[(2)]);
var inst_32334 = fluree.db.util.async.throw_err(inst_32333);
var state_32402__$1 = state_32402;
var statearr_32416_32505 = state_32402__$1;
(statearr_32416_32505[(2)] = inst_32334);

(statearr_32416_32505[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (46))){
var inst_32346 = (state_32402[(10)]);
var inst_32346__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_32402__$1 = (function (){var statearr_32417 = state_32402;
(statearr_32417[(10)] = inst_32346__$1);

return statearr_32417;
})();
if(cljs.core.truth_(inst_32346__$1)){
var statearr_32418_32506 = state_32402__$1;
(statearr_32418_32506[(1)] = (49));

} else {
var statearr_32419_32507 = state_32402__$1;
(statearr_32419_32507[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (4))){
var inst_32252 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32420_32508 = state_32402__$1;
(statearr_32420_32508[(2)] = inst_32252);

(statearr_32420_32508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (54))){
var inst_32302 = (state_32402[(8)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32302)){
var statearr_32421_32509 = state_32402__$1;
(statearr_32421_32509[(1)] = (57));

} else {
var statearr_32422_32510 = state_32402__$1;
(statearr_32422_32510[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (15))){
var inst_32264 = (state_32402[(11)]);
var inst_32283 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32264);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(18),inst_32283);
} else {
if((state_val_32403 === (48))){
var inst_32385 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32423_32511 = state_32402__$1;
(statearr_32423_32511[(2)] = inst_32385);

(statearr_32423_32511[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (50))){
var inst_32277 = (state_32402[(12)]);
var inst_32262 = (state_32402[(13)]);
var inst_32266 = (state_32402[(14)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32272 = (state_32402[(16)]);
var inst_32346 = (state_32402[(10)]);
var inst_32261 = (state_32402[(17)]);
var inst_32350 = (function (){var t = inst_32265;
var temp__5752__auto__ = inst_32346;
var p = inst_32263;
var idx_predicate_QMARK_ = inst_32266;
var o = inst_32302;
var vec__32258 = inst_32261;
var tag_predicate_QMARK_ = inst_32272;
var s = inst_32262;
var o_coerce_QMARK_ = inst_32277;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_32402__$1 = state_32402;
var statearr_32424_32512 = state_32402__$1;
(statearr_32424_32512[(2)] = inst_32350);

(statearr_32424_32512[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (21))){
var inst_32298 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32425_32513 = state_32402__$1;
(statearr_32425_32513[(2)] = inst_32298);

(statearr_32425_32513[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (31))){
var state_32402__$1 = state_32402;
var statearr_32426_32514 = state_32402__$1;
(statearr_32426_32514[(2)] = false);

(statearr_32426_32514[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (32))){
var inst_32323 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32427_32515 = state_32402__$1;
(statearr_32427_32515[(2)] = inst_32323);

(statearr_32427_32515[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (40))){
var inst_32266 = (state_32402[(14)]);
var inst_32337 = cljs.core.not(inst_32266);
var state_32402__$1 = state_32402;
if(inst_32337){
var statearr_32428_32516 = state_32402__$1;
(statearr_32428_32516[(1)] = (43));

} else {
var statearr_32429_32517 = state_32402__$1;
(statearr_32429_32517[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (56))){
var inst_32368 = (state_32402[(2)]);
var inst_32369 = fluree.db.util.async.throw_err(inst_32368);
var state_32402__$1 = state_32402;
var statearr_32430_32518 = state_32402__$1;
(statearr_32430_32518[(2)] = inst_32369);

(statearr_32430_32518[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (33))){
var inst_32302 = (state_32402[(8)]);
var inst_32316 = cljs.core.fn_QMARK_(inst_32302);
var inst_32317 = (!(inst_32316));
var state_32402__$1 = state_32402;
var statearr_32431_32519 = state_32402__$1;
(statearr_32431_32519[(2)] = inst_32317);

(statearr_32431_32519[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (13))){
var inst_32264 = (state_32402[(11)]);
var inst_32281 = fluree.db.query.range.tag_string_QMARK_(inst_32264);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32281)){
var statearr_32432_32520 = state_32402__$1;
(statearr_32432_32520[(1)] = (15));

} else {
var statearr_32433_32521 = state_32402__$1;
(statearr_32433_32521[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (22))){
var inst_32294 = (state_32402[(2)]);
var inst_32295 = fluree.db.util.async.throw_err(inst_32294);
var state_32402__$1 = state_32402;
var statearr_32434_32522 = state_32402__$1;
(statearr_32434_32522[(2)] = inst_32295);

(statearr_32434_32522[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (36))){
var inst_32262 = (state_32402[(13)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32329 = [inst_32263,inst_32302,inst_32262,inst_32265];
var inst_32330 = (new cljs.core.PersistentVector(null,4,(5),inst_32328,inst_32329,null));
var inst_32331 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_32330,opts);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(39),inst_32331);
} else {
if((state_val_32403 === (41))){
var inst_32263 = (state_32402[(9)]);
var state_32402__$1 = state_32402;
var statearr_32435_32523 = state_32402__$1;
(statearr_32435_32523[(2)] = inst_32263);

(statearr_32435_32523[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (43))){
var inst_32302 = (state_32402[(8)]);
var state_32402__$1 = state_32402;
var statearr_32436_32524 = state_32402__$1;
(statearr_32436_32524[(2)] = inst_32302);

(statearr_32436_32524[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (61))){
var inst_32389 = (state_32402[(7)]);
var inst_32391 = fluree.db.query.range.coerce_tag_flakes(db,inst_32389);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(64),inst_32391);
} else {
if((state_val_32403 === (29))){
var inst_32326 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32326)){
var statearr_32437_32525 = state_32402__$1;
(statearr_32437_32525[(1)] = (36));

} else {
var statearr_32438_32526 = state_32402__$1;
(statearr_32438_32526[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (44))){
var state_32402__$1 = state_32402;
var statearr_32439_32527 = state_32402__$1;
(statearr_32439_32527[(2)] = false);

(statearr_32439_32527[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (6))){
var inst_32263 = (state_32402[(9)]);
var inst_32268 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_32263);
var inst_32269 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_32268);
var state_32402__$1 = state_32402;
var statearr_32440_32528 = state_32402__$1;
(statearr_32440_32528[(2)] = inst_32269);

(statearr_32440_32528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (28))){
var inst_32263 = (state_32402[(9)]);
var state_32402__$1 = state_32402;
var statearr_32441_32529 = state_32402__$1;
(statearr_32441_32529[(2)] = inst_32263);

(statearr_32441_32529[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (64))){
var inst_32393 = (state_32402[(2)]);
var inst_32394 = fluree.db.util.async.throw_err(inst_32393);
var state_32402__$1 = state_32402;
var statearr_32442_32530 = state_32402__$1;
(statearr_32442_32530[(2)] = inst_32394);

(statearr_32442_32530[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (51))){
var inst_32262 = (state_32402[(13)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32352 = (state_32402[(2)]);
var inst_32353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32354 = [inst_32263,inst_32262,null,inst_32265];
var inst_32355 = (new cljs.core.PersistentVector(null,4,(5),inst_32353,inst_32354,null));
var inst_32356 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_32352);
var inst_32357 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32355,inst_32356);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(52),inst_32357);
} else {
if((state_val_32403 === (25))){
var inst_32272 = (state_32402[(16)]);
var inst_32389 = (state_32402[(2)]);
var state_32402__$1 = (function (){var statearr_32443 = state_32402;
(statearr_32443[(7)] = inst_32389);

return statearr_32443;
})();
if(cljs.core.truth_(inst_32272)){
var statearr_32444_32531 = state_32402__$1;
(statearr_32444_32531[(1)] = (61));

} else {
var statearr_32445_32532 = state_32402__$1;
(statearr_32445_32532[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (34))){
var inst_32266 = (state_32402[(14)]);
var state_32402__$1 = state_32402;
var statearr_32446_32533 = state_32402__$1;
(statearr_32446_32533[(2)] = inst_32266);

(statearr_32446_32533[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (17))){
var inst_32300 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32447_32534 = state_32402__$1;
(statearr_32447_32534[(2)] = inst_32300);

(statearr_32447_32534[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (3))){
var inst_32400 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32402__$1,inst_32400);
} else {
if((state_val_32403 === (12))){
var inst_32264 = (state_32402[(11)]);
var state_32402__$1 = state_32402;
var statearr_32448_32535 = state_32402__$1;
(statearr_32448_32535[(2)] = inst_32264);

(statearr_32448_32535[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (2))){
var inst_32263 = (state_32402[(9)]);
var inst_32261 = (state_32402[(17)]);
var _ = (function (){var statearr_32449 = state_32402;
(statearr_32449[(4)] = cljs.core.cons((5),(state_32402[(4)])));

return statearr_32449;
})();
var inst_32261__$1 = fparts;
var inst_32262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261__$1,(0),null);
var inst_32263__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261__$1,(1),null);
var inst_32264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261__$1,(2),null);
var inst_32265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32261__$1,(3),null);
var inst_32266 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_32263__$1);
var state_32402__$1 = (function (){var statearr_32450 = state_32402;
(statearr_32450[(13)] = inst_32262);

(statearr_32450[(14)] = inst_32266);

(statearr_32450[(15)] = inst_32265);

(statearr_32450[(9)] = inst_32263__$1);

(statearr_32450[(17)] = inst_32261__$1);

(statearr_32450[(11)] = inst_32264);

return statearr_32450;
})();
if(cljs.core.truth_(inst_32263__$1)){
var statearr_32451_32536 = state_32402__$1;
(statearr_32451_32536[(1)] = (6));

} else {
var statearr_32452_32537 = state_32402__$1;
(statearr_32452_32537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (23))){
var inst_32262 = (state_32402[(13)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32305 = [inst_32262,inst_32263,inst_32302,inst_32265];
var inst_32306 = (new cljs.core.PersistentVector(null,4,(5),inst_32304,inst_32305,null));
var inst_32307 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32306,opts);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(26),inst_32307);
} else {
if((state_val_32403 === (47))){
var inst_32263 = (state_32402[(9)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32263)){
var statearr_32453_32538 = state_32402__$1;
(statearr_32453_32538[(1)] = (53));

} else {
var statearr_32454_32539 = state_32402__$1;
(statearr_32454_32539[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (35))){
var inst_32320 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32455_32540 = state_32402__$1;
(statearr_32455_32540[(2)] = inst_32320);

(statearr_32455_32540[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (19))){
var inst_32263 = (state_32402[(9)]);
var inst_32264 = (state_32402[(11)]);
var inst_32290 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_32263);
var inst_32291 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32290),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32264)].join('');
var inst_32292 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_32291);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(22),inst_32292);
} else {
if((state_val_32403 === (57))){
var inst_32262 = (state_32402[(13)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32373 = [inst_32302,inst_32263,inst_32262,inst_32265];
var inst_32374 = (new cljs.core.PersistentVector(null,4,(5),inst_32372,inst_32373,null));
var inst_32375 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_32374,opts);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(60),inst_32375);
} else {
if((state_val_32403 === (11))){
var inst_32277 = (state_32402[(12)]);
var inst_32277__$1 = (state_32402[(2)]);
var inst_32278 = cljs.core.not(inst_32277__$1);
var state_32402__$1 = (function (){var statearr_32457 = state_32402;
(statearr_32457[(12)] = inst_32277__$1);

return statearr_32457;
})();
if(inst_32278){
var statearr_32458_32541 = state_32402__$1;
(statearr_32458_32541[(1)] = (12));

} else {
var statearr_32459_32542 = state_32402__$1;
(statearr_32459_32542[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (9))){
var inst_32264 = (state_32402[(11)]);
var inst_32274 = typeof inst_32264 === 'string';
var state_32402__$1 = state_32402;
var statearr_32460_32543 = state_32402__$1;
(statearr_32460_32543[(2)] = inst_32274);

(statearr_32460_32543[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (5))){
var _ = (function (){var statearr_32461 = state_32402;
(statearr_32461[(4)] = cljs.core.rest((state_32402[(4)])));

return statearr_32461;
})();
var state_32402__$1 = state_32402;
var ex32456 = (state_32402__$1[(2)]);
var statearr_32462_32544 = state_32402__$1;
(statearr_32462_32544[(5)] = ex32456);


if((ex32456 instanceof Error)){
var statearr_32463_32545 = state_32402__$1;
(statearr_32463_32545[(1)] = (4));

(statearr_32463_32545[(5)] = null);

} else {
throw ex32456;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (14))){
var inst_32262 = (state_32402[(13)]);
var inst_32302 = (state_32402[(2)]);
var state_32402__$1 = (function (){var statearr_32464 = state_32402;
(statearr_32464[(8)] = inst_32302);

return statearr_32464;
})();
if(cljs.core.truth_(inst_32262)){
var statearr_32465_32546 = state_32402__$1;
(statearr_32465_32546[(1)] = (23));

} else {
var statearr_32466_32547 = state_32402__$1;
(statearr_32466_32547[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (45))){
var inst_32341 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32467_32548 = state_32402__$1;
(statearr_32467_32548[(2)] = inst_32341);

(statearr_32467_32548[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (53))){
var inst_32262 = (state_32402[(13)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32364 = [inst_32263,inst_32262,inst_32302,inst_32265];
var inst_32365 = (new cljs.core.PersistentVector(null,4,(5),inst_32363,inst_32364,null));
var inst_32366 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32365,opts);
var state_32402__$1 = state_32402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32402__$1,(56),inst_32366);
} else {
if((state_val_32403 === (26))){
var inst_32309 = (state_32402[(2)]);
var inst_32310 = fluree.db.util.async.throw_err(inst_32309);
var state_32402__$1 = state_32402;
var statearr_32468_32549 = state_32402__$1;
(statearr_32468_32549[(2)] = inst_32310);

(statearr_32468_32549[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (16))){
var inst_32264 = (state_32402[(11)]);
var inst_32288 = typeof inst_32264 === 'string';
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32288)){
var statearr_32469_32550 = state_32402__$1;
(statearr_32469_32550[(1)] = (19));

} else {
var statearr_32470_32551 = state_32402__$1;
(statearr_32470_32551[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (38))){
var inst_32387 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
var statearr_32471_32552 = state_32402__$1;
(statearr_32471_32552[(2)] = inst_32387);

(statearr_32471_32552[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (30))){
var inst_32266 = (state_32402[(14)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32266)){
var statearr_32472_32553 = state_32402__$1;
(statearr_32472_32553[(1)] = (33));

} else {
var statearr_32473_32554 = state_32402__$1;
(statearr_32473_32554[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (10))){
var inst_32272 = (state_32402[(16)]);
var state_32402__$1 = state_32402;
var statearr_32474_32555 = state_32402__$1;
(statearr_32474_32555[(2)] = inst_32272);

(statearr_32474_32555[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (18))){
var inst_32285 = (state_32402[(2)]);
var inst_32286 = fluree.db.util.async.throw_err(inst_32285);
var state_32402__$1 = state_32402;
var statearr_32475_32556 = state_32402__$1;
(statearr_32475_32556[(2)] = inst_32286);

(statearr_32475_32556[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (52))){
var inst_32359 = (state_32402[(2)]);
var inst_32360 = fluree.db.util.async.throw_err(inst_32359);
var state_32402__$1 = state_32402;
var statearr_32476_32557 = state_32402__$1;
(statearr_32476_32557[(2)] = inst_32360);

(statearr_32476_32557[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (42))){
var inst_32344 = (state_32402[(2)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32344)){
var statearr_32477_32558 = state_32402__$1;
(statearr_32477_32558[(1)] = (46));

} else {
var statearr_32478_32559 = state_32402__$1;
(statearr_32478_32559[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (37))){
var inst_32263 = (state_32402[(9)]);
var state_32402__$1 = state_32402;
if(cljs.core.truth_(inst_32263)){
var statearr_32479_32560 = state_32402__$1;
(statearr_32479_32560[(1)] = (40));

} else {
var statearr_32480_32561 = state_32402__$1;
(statearr_32480_32561[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (63))){
var inst_32397 = (state_32402[(2)]);
var _ = (function (){var statearr_32481 = state_32402;
(statearr_32481[(4)] = cljs.core.rest((state_32402[(4)])));

return statearr_32481;
})();
var state_32402__$1 = state_32402;
var statearr_32482_32562 = state_32402__$1;
(statearr_32482_32562[(2)] = inst_32397);

(statearr_32482_32562[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (8))){
var inst_32272 = (state_32402[(16)]);
var inst_32272__$1 = (state_32402[(2)]);
var state_32402__$1 = (function (){var statearr_32483 = state_32402;
(statearr_32483[(16)] = inst_32272__$1);

return statearr_32483;
})();
if(cljs.core.truth_(inst_32272__$1)){
var statearr_32484_32563 = state_32402__$1;
(statearr_32484_32563[(1)] = (9));

} else {
var statearr_32485_32564 = state_32402__$1;
(statearr_32485_32564[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32403 === (49))){
var inst_32277 = (state_32402[(12)]);
var inst_32262 = (state_32402[(13)]);
var inst_32266 = (state_32402[(14)]);
var inst_32265 = (state_32402[(15)]);
var inst_32263 = (state_32402[(9)]);
var inst_32302 = (state_32402[(8)]);
var inst_32272 = (state_32402[(16)]);
var inst_32346 = (state_32402[(10)]);
var inst_32261 = (state_32402[(17)]);
var inst_32348 = (function (){var obj_fn = inst_32346;
var t = inst_32265;
var temp__5752__auto__ = inst_32346;
var p = inst_32263;
var idx_predicate_QMARK_ = inst_32266;
var o = inst_32302;
var vec__32258 = inst_32261;
var tag_predicate_QMARK_ = inst_32272;
var s = inst_32262;
var o_coerce_QMARK_ = inst_32277;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_32402__$1 = state_32402;
var statearr_32486_32565 = state_32402__$1;
(statearr_32486_32565[(2)] = inst_32348);

(statearr_32486_32565[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17133__auto__ = null;
var fluree$db$query$range$state_machine__17133__auto____0 = (function (){
var statearr_32487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32487[(0)] = fluree$db$query$range$state_machine__17133__auto__);

(statearr_32487[(1)] = (1));

return statearr_32487;
});
var fluree$db$query$range$state_machine__17133__auto____1 = (function (state_32402){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_32402);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e32488){var ex__17136__auto__ = e32488;
var statearr_32489_32566 = state_32402;
(statearr_32489_32566[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_32402[(4)]))){
var statearr_32490_32567 = state_32402;
(statearr_32490_32567[(1)] = cljs.core.first((state_32402[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__32568 = state_32402;
state_32402 = G__32568;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17133__auto__ = function(state_32402){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17133__auto____1.call(this,state_32402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17133__auto____0;
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17133__auto____1;
return fluree$db$query$range$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_32491 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_32491[(6)] = c__17207__auto__);

return statearr_32491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__32570 = arguments.length;
switch (G__32570) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_32605){
var state_val_32606 = (state_32605[(1)]);
if((state_val_32606 === (7))){
var inst_32592 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_32593 = ["Invalid collection name: ",inst_32592].join('');
var inst_32594 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32595 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_32596 = cljs.core.PersistentHashMap.fromArrays(inst_32594,inst_32595);
var inst_32597 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32593,inst_32596);
var inst_32598 = (function(){throw inst_32597})();
var state_32605__$1 = state_32605;
var statearr_32607_32627 = state_32605__$1;
(statearr_32607_32627[(2)] = inst_32598);

(statearr_32607_32627[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (1))){
var state_32605__$1 = state_32605;
var statearr_32608_32628 = state_32605__$1;
(statearr_32608_32628[(2)] = null);

(statearr_32608_32628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (4))){
var inst_32571 = (state_32605[(2)]);
var state_32605__$1 = state_32605;
var statearr_32609_32629 = state_32605__$1;
(statearr_32609_32629[(2)] = inst_32571);

(statearr_32609_32629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (6))){
var inst_32577 = (state_32605[(7)]);
var inst_32579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32580 = fluree.db.flake.max_subject_id(inst_32577);
var inst_32581 = [inst_32580];
var inst_32582 = (new cljs.core.PersistentVector(null,1,(5),inst_32579,inst_32581,null));
var inst_32583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32584 = fluree.db.flake.min_subject_id(inst_32577);
var inst_32585 = [inst_32584];
var inst_32586 = (new cljs.core.PersistentVector(null,1,(5),inst_32583,inst_32585,null));
var inst_32587 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32582,cljs.core._LT__EQ_,inst_32586,opts);
var state_32605__$1 = state_32605;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32605__$1,(9),inst_32587);
} else {
if((state_val_32606 === (3))){
var inst_32603 = (state_32605[(2)]);
var state_32605__$1 = state_32605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32605__$1,inst_32603);
} else {
if((state_val_32606 === (2))){
var inst_32577 = (state_32605[(7)]);
var _ = (function (){var statearr_32611 = state_32605;
(statearr_32611[(4)] = cljs.core.cons((5),(state_32605[(4)])));

return statearr_32611;
})();
var inst_32577__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_32605__$1 = (function (){var statearr_32612 = state_32605;
(statearr_32612[(7)] = inst_32577__$1);

return statearr_32612;
})();
if(cljs.core.truth_(inst_32577__$1)){
var statearr_32613_32630 = state_32605__$1;
(statearr_32613_32630[(1)] = (6));

} else {
var statearr_32614_32631 = state_32605__$1;
(statearr_32614_32631[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (9))){
var inst_32589 = (state_32605[(2)]);
var inst_32590 = fluree.db.util.async.throw_err(inst_32589);
var state_32605__$1 = state_32605;
var statearr_32615_32632 = state_32605__$1;
(statearr_32615_32632[(2)] = inst_32590);

(statearr_32615_32632[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (5))){
var _ = (function (){var statearr_32616 = state_32605;
(statearr_32616[(4)] = cljs.core.rest((state_32605[(4)])));

return statearr_32616;
})();
var state_32605__$1 = state_32605;
var ex32610 = (state_32605__$1[(2)]);
var statearr_32617_32633 = state_32605__$1;
(statearr_32617_32633[(5)] = ex32610);


var statearr_32618_32634 = state_32605__$1;
(statearr_32618_32634[(1)] = (4));

(statearr_32618_32634[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32606 === (8))){
var inst_32600 = (state_32605[(2)]);
var _ = (function (){var statearr_32619 = state_32605;
(statearr_32619[(4)] = cljs.core.rest((state_32605[(4)])));

return statearr_32619;
})();
var state_32605__$1 = state_32605;
var statearr_32620_32635 = state_32605__$1;
(statearr_32620_32635[(2)] = inst_32600);

(statearr_32620_32635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__17133__auto__ = null;
var fluree$db$query$range$state_machine__17133__auto____0 = (function (){
var statearr_32621 = [null,null,null,null,null,null,null,null];
(statearr_32621[(0)] = fluree$db$query$range$state_machine__17133__auto__);

(statearr_32621[(1)] = (1));

return statearr_32621;
});
var fluree$db$query$range$state_machine__17133__auto____1 = (function (state_32605){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_32605);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e32622){var ex__17136__auto__ = e32622;
var statearr_32623_32636 = state_32605;
(statearr_32623_32636[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_32605[(4)]))){
var statearr_32624_32637 = state_32605;
(statearr_32624_32637[(1)] = cljs.core.first((state_32605[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__32638 = state_32605;
state_32605 = G__32638;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__17133__auto__ = function(state_32605){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__17133__auto____1.call(this,state_32605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__17133__auto____0;
fluree$db$query$range$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__17133__auto____1;
return fluree$db$query$range$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_32625 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_32625[(6)] = c__17207__auto__);

return statearr_32625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__32642 = flakes;
var vec__32643 = G__32642;
var seq__32644 = cljs.core.seq(vec__32643);
var first__32645 = cljs.core.first(seq__32644);
var seq__32644__$1 = cljs.core.next(seq__32644);
var flake_SINGLEQUOTE_ = first__32645;
var r = seq__32644__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32642__$1 = G__32642;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32652 = G__32642__$1;
var seq__32653 = cljs.core.seq(vec__32652);
var first__32654 = cljs.core.first(seq__32653);
var seq__32653__$1 = cljs.core.next(seq__32653);
var flake_SINGLEQUOTE___$1 = first__32654;
var r__$1 = seq__32653__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e32656){var e = e32656;
return null;
}})();
var map__32655 = cmd_map;
var map__32655__$1 = (((((!((map__32655 == null))))?(((((map__32655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32655.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32655):map__32655);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32655__$1,cljs.core.cst$kw$expire);
var G__32658 = r__$1;
var G__32659 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__32642__$1 = G__32658;
result_STAR___$1 = G__32659;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__32668 = blocks;
var vec__32669 = G__32668;
var seq__32670 = cljs.core.seq(vec__32669);
var first__32671 = cljs.core.first(seq__32670);
var seq__32670__$1 = cljs.core.next(seq__32670);
var block_SINGLEQUOTE_ = first__32671;
var r = seq__32670__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__32668__$1 = G__32668;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__32677 = G__32668__$1;
var seq__32678 = cljs.core.seq(vec__32677);
var first__32679 = cljs.core.first(seq__32678);
var seq__32678__$1 = cljs.core.next(seq__32678);
var block_SINGLEQUOTE___$1 = first__32679;
var r__$1 = seq__32678__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__32680 = block_SINGLEQUOTE___$1;
var map__32680__$1 = (((((!((map__32680 == null))))?(((((map__32680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32680):map__32680);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32680__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32680__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32680__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32660_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32660_SHARP_.p,(2))){
return p1__32660_SHARP_.o;
} else {
return null;
}
});})(G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32661_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32661_SHARP_.p,(1))){
return p1__32661_SHARP_.o;
} else {
return null;
}
});})(G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32662_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32662_SHARP_.p,(5))){
return p1__32662_SHARP_.o;
} else {
return null;
}
});})(G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,instant,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32663_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32663_SHARP_.p,(7))){
return p1__32663_SHARP_.o;
} else {
return null;
}
});})(G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,instant,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__32664_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32664_SHARP_.p,(106));
});})(G__32668__$1,result_STAR___$1,map__32680,map__32680__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__32677,seq__32678,first__32679,seq__32678__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__32668,vec__32669,seq__32670,first__32671,seq__32670__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__32682 = r__$1;
var G__32683 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__32668__$1 = G__32682;
result_STAR___$1 = G__32683;
continue;
}
break;
}
});
