// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35701){
var state_val_35702 = (state_35701[(1)]);
if((state_val_35702 === (1))){
var state_35701__$1 = state_35701;
var statearr_35703_35717 = state_35701__$1;
(statearr_35703_35717[(2)] = null);

(statearr_35703_35717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35702 === (2))){
var _ = (function (){var statearr_35704 = state_35701;
(statearr_35704[(4)] = cljs.core.cons((5),(state_35701[(4)])));

return statearr_35704;
})();
var inst_35692 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_35701__$1 = state_35701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35701__$1,(6),inst_35692);
} else {
if((state_val_35702 === (3))){
var inst_35699 = (state_35701[(2)]);
var state_35701__$1 = state_35701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35701__$1,inst_35699);
} else {
if((state_val_35702 === (4))){
var inst_35686 = (state_35701[(2)]);
var state_35701__$1 = state_35701;
var statearr_35706_35718 = state_35701__$1;
(statearr_35706_35718[(2)] = inst_35686);

(statearr_35706_35718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35702 === (5))){
var _ = (function (){var statearr_35707 = state_35701;
(statearr_35707[(4)] = cljs.core.rest((state_35701[(4)])));

return statearr_35707;
})();
var state_35701__$1 = state_35701;
var ex35705 = (state_35701__$1[(2)]);
var statearr_35708_35719 = state_35701__$1;
(statearr_35708_35719[(5)] = ex35705);


if((ex35705 instanceof Error)){
var statearr_35709_35720 = state_35701__$1;
(statearr_35709_35720[(1)] = (4));

(statearr_35709_35720[(5)] = null);

} else {
throw ex35705;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35702 === (6))){
var inst_35694 = (state_35701[(2)]);
var inst_35695 = fluree.db.util.async.throw_err(inst_35694);
var inst_35696 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_35695);
var _ = (function (){var statearr_35710 = state_35701;
(statearr_35710[(4)] = cljs.core.rest((state_35701[(4)])));

return statearr_35710;
})();
var state_35701__$1 = state_35701;
var statearr_35711_35721 = state_35701__$1;
(statearr_35711_35721[(2)] = inst_35696);

(statearr_35711_35721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____0 = (function (){
var statearr_35712 = [null,null,null,null,null,null,null];
(statearr_35712[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__);

(statearr_35712[(1)] = (1));

return statearr_35712;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____1 = (function (state_35701){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35701);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35713){var ex__17136__auto__ = e35713;
var statearr_35714_35722 = state_35701;
(statearr_35714_35722[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35701[(4)]))){
var statearr_35715_35723 = state_35701;
(statearr_35715_35723[(1)] = cljs.core.first((state_35701[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35724 = state_35701;
state_35701 = G__35724;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__ = function(state_35701){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____1.call(this,state_35701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35716 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35716[(6)] = c__17207__auto__);

return statearr_35716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35756){
var state_val_35757 = (state_35756[(1)]);
if((state_val_35757 === (7))){
var inst_35740 = (state_35756[(7)]);
var inst_35742 = cljs.core.empty_QMARK_(inst_35740);
var inst_35743 = (!(inst_35742));
var state_35756__$1 = state_35756;
var statearr_35758_35782 = state_35756__$1;
(statearr_35758_35782[(2)] = inst_35743);

(statearr_35758_35782[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (1))){
var state_35756__$1 = state_35756;
var statearr_35759_35783 = state_35756__$1;
(statearr_35759_35783[(2)] = null);

(statearr_35759_35783[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (4))){
var inst_35726 = (state_35756[(2)]);
var state_35756__$1 = state_35756;
var statearr_35760_35784 = state_35756__$1;
(statearr_35760_35784[(2)] = inst_35726);

(statearr_35760_35784[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (6))){
var inst_35732 = (state_35756[(8)]);
var inst_35740 = (state_35756[(7)]);
var inst_35738 = (state_35756[(2)]);
var inst_35739 = fluree.db.util.async.throw_err(inst_35738);
var inst_35740__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35732,inst_35739);
var state_35756__$1 = (function (){var statearr_35761 = state_35756;
(statearr_35761[(7)] = inst_35740__$1);

return statearr_35761;
})();
if(cljs.core.truth_(inst_35740__$1)){
var statearr_35762_35785 = state_35756__$1;
(statearr_35762_35785[(1)] = (7));

} else {
var statearr_35763_35786 = state_35756__$1;
(statearr_35763_35786[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (3))){
var inst_35754 = (state_35756[(2)]);
var state_35756__$1 = state_35756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35756__$1,inst_35754);
} else {
if((state_val_35757 === (12))){
var inst_35751 = (state_35756[(2)]);
var _ = (function (){var statearr_35764 = state_35756;
(statearr_35764[(4)] = cljs.core.rest((state_35756[(4)])));

return statearr_35764;
})();
var state_35756__$1 = state_35756;
var statearr_35765_35787 = state_35756__$1;
(statearr_35765_35787[(2)] = inst_35751);

(statearr_35765_35787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (2))){
var _ = (function (){var statearr_35766 = state_35756;
(statearr_35766[(4)] = cljs.core.cons((5),(state_35756[(4)])));

return statearr_35766;
})();
var inst_35732 = (function (){return (function (p1__35725_SHARP_){
return p1__35725_SHARP_.o;
});
})();
var inst_35733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35734 = [pred_id];
var inst_35735 = (new cljs.core.PersistentVector(null,1,(5),inst_35733,inst_35734,null));
var inst_35736 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_35735);
var state_35756__$1 = (function (){var statearr_35767 = state_35756;
(statearr_35767[(8)] = inst_35732);

return statearr_35767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35756__$1,(6),inst_35736);
} else {
if((state_val_35757 === (11))){
var state_35756__$1 = state_35756;
var statearr_35769_35788 = state_35756__$1;
(statearr_35769_35788[(2)] = true);

(statearr_35769_35788[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (9))){
var inst_35746 = (state_35756[(2)]);
var state_35756__$1 = state_35756;
if(cljs.core.truth_(inst_35746)){
var statearr_35770_35789 = state_35756__$1;
(statearr_35770_35789[(1)] = (10));

} else {
var statearr_35771_35790 = state_35756__$1;
(statearr_35771_35790[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (5))){
var _ = (function (){var statearr_35772 = state_35756;
(statearr_35772[(4)] = cljs.core.rest((state_35756[(4)])));

return statearr_35772;
})();
var state_35756__$1 = state_35756;
var ex35768 = (state_35756__$1[(2)]);
var statearr_35773_35791 = state_35756__$1;
(statearr_35773_35791[(5)] = ex35768);


if((ex35768 instanceof Error)){
var statearr_35774_35792 = state_35756__$1;
(statearr_35774_35792[(1)] = (4));

(statearr_35774_35792[(5)] = null);

} else {
throw ex35768;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (10))){
var inst_35740 = (state_35756[(7)]);
var inst_35748 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_35740);
var state_35756__$1 = state_35756;
var statearr_35775_35793 = state_35756__$1;
(statearr_35775_35793[(2)] = inst_35748);

(statearr_35775_35793[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35757 === (8))){
var inst_35740 = (state_35756[(7)]);
var state_35756__$1 = state_35756;
var statearr_35776_35794 = state_35756__$1;
(statearr_35776_35794[(2)] = inst_35740);

(statearr_35776_35794[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____0 = (function (){
var statearr_35777 = [null,null,null,null,null,null,null,null,null];
(statearr_35777[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__);

(statearr_35777[(1)] = (1));

return statearr_35777;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____1 = (function (state_35756){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35756);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35778){var ex__17136__auto__ = e35778;
var statearr_35779_35795 = state_35756;
(statearr_35779_35795[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35756[(4)]))){
var statearr_35780_35796 = state_35756;
(statearr_35780_35796[(1)] = cljs.core.first((state_35756[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35797 = state_35756;
state_35756 = G__35797;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__ = function(state_35756){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____1.call(this,state_35756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35781 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35781[(6)] = c__17207__auto__);

return statearr_35781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_35874){
var state_val_35875 = (state_35874[(1)]);
if((state_val_35875 === (7))){
var inst_35869 = (state_35874[(2)]);
var _ = (function (){var statearr_35876 = state_35874;
(statearr_35876[(4)] = cljs.core.rest((state_35874[(4)])));

return statearr_35876;
})();
var state_35874__$1 = state_35874;
var statearr_35877_35910 = state_35874__$1;
(statearr_35877_35910[(2)] = inst_35869);

(statearr_35877_35910[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (1))){
var state_35874__$1 = state_35874;
var statearr_35878_35911 = state_35874__$1;
(statearr_35878_35911[(2)] = null);

(statearr_35878_35911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (4))){
var inst_35800 = (state_35874[(2)]);
var state_35874__$1 = state_35874;
var statearr_35879_35912 = state_35874__$1;
(statearr_35879_35912[(2)] = inst_35800);

(statearr_35879_35912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (15))){
var inst_35837 = (state_35874[(7)]);
var inst_35830 = (state_35874[(8)]);
var inst_35824 = (state_35874[(9)]);
var inst_35850 = (state_35874[(10)]);
var inst_35852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35853 = inst_35830.s;
var inst_35854 = [inst_35853,inst_35837,cljs.core.cst$kw$old];
var inst_35855 = (new cljs.core.PersistentVector(null,3,(5),inst_35852,inst_35854,null));
var inst_35856 = cljs.core.assoc_in(inst_35824,inst_35855,inst_35850);
var state_35874__$1 = state_35874;
var statearr_35880_35913 = state_35874__$1;
(statearr_35880_35913[(2)] = inst_35856);

(statearr_35880_35913[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (13))){
var inst_35839 = (state_35874[(11)]);
var inst_35850 = (state_35874[(2)]);
var state_35874__$1 = (function (){var statearr_35881 = state_35874;
(statearr_35881[(10)] = inst_35850);

return statearr_35881;
})();
if(cljs.core.truth_(inst_35839)){
var statearr_35882_35914 = state_35874__$1;
(statearr_35882_35914[(1)] = (15));

} else {
var statearr_35883_35915 = state_35874__$1;
(statearr_35883_35915[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (6))){
var inst_35823 = (state_35874[(12)]);
var inst_35830 = (state_35874[(8)]);
var inst_35829 = cljs.core.seq(inst_35823);
var inst_35830__$1 = cljs.core.first(inst_35829);
var inst_35831 = cljs.core.next(inst_35829);
var inst_35832 = cljs.core.not(inst_35830__$1);
var state_35874__$1 = (function (){var statearr_35884 = state_35874;
(statearr_35884[(13)] = inst_35831);

(statearr_35884[(8)] = inst_35830__$1);

return statearr_35884;
})();
if(inst_35832){
var statearr_35885_35916 = state_35874__$1;
(statearr_35885_35916[(1)] = (8));

} else {
var statearr_35886_35917 = state_35874__$1;
(statearr_35886_35917[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (17))){
var inst_35831 = (state_35874[(13)]);
var inst_35864 = (state_35874[(2)]);
var inst_35823 = inst_35831;
var inst_35824 = inst_35864;
var state_35874__$1 = (function (){var statearr_35887 = state_35874;
(statearr_35887[(12)] = inst_35823);

(statearr_35887[(9)] = inst_35824);

return statearr_35887;
})();
var statearr_35888_35918 = state_35874__$1;
(statearr_35888_35918[(2)] = null);

(statearr_35888_35918[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (3))){
var inst_35872 = (state_35874[(2)]);
var state_35874__$1 = state_35874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35874__$1,inst_35872);
} else {
if((state_val_35875 === (12))){
var inst_35830 = (state_35874[(8)]);
var inst_35848 = inst_35830.o;
var state_35874__$1 = state_35874;
var statearr_35889_35919 = state_35874__$1;
(statearr_35889_35919[(2)] = inst_35848);

(statearr_35889_35919[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (2))){
var _ = (function (){var statearr_35890 = state_35874;
(statearr_35890[(4)] = cljs.core.cons((5),(state_35874[(4)])));

return statearr_35890;
})();
var inst_35806 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_35807 = cljs.core.PersistentHashSet.EMPTY;
var inst_35808 = cljs.core.vals(tempids);
var inst_35809 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35807,inst_35808);
var inst_35810 = (function (){var pred_flakes = inst_35806;
var is_new_QMARK_ = inst_35809;
return (function (p1__35798_SHARP_,p2__35799_SHARP_){
return cljs.core.assoc_in(p1__35798_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__35799_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__35891 = p2__35799_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__35891) : is_new_QMARK_.call(null,G__35891));
})()));
});
})();
var inst_35811 = cljs.core.PersistentHashMap.EMPTY;
var inst_35812 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35810,inst_35811,inst_35806);
var inst_35820 = cljs.core.seq(inst_35806);
var inst_35821 = cljs.core.first(inst_35820);
var inst_35822 = cljs.core.next(inst_35820);
var inst_35823 = inst_35806;
var inst_35824 = inst_35812;
var state_35874__$1 = (function (){var statearr_35892 = state_35874;
(statearr_35892[(14)] = inst_35822);

(statearr_35892[(15)] = inst_35821);

(statearr_35892[(12)] = inst_35823);

(statearr_35892[(9)] = inst_35824);

return statearr_35892;
})();
var statearr_35893_35920 = state_35874__$1;
(statearr_35893_35920[(2)] = null);

(statearr_35893_35920[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (11))){
var inst_35830 = (state_35874[(8)]);
var inst_35842 = inst_35830.o;
var inst_35843 = fluree.db.query.schema.convert_type_to_kw(inst_35842,db);
var state_35874__$1 = state_35874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35874__$1,(14),inst_35843);
} else {
if((state_val_35875 === (9))){
var inst_35837 = (state_35874[(7)]);
var inst_35830 = (state_35874[(8)]);
var inst_35835 = inst_35830.p;
var inst_35836 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_35835);
var inst_35837__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_35836);
var inst_35838 = inst_35830.op;
var inst_35839 = inst_35838 === false;
var inst_35840 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_35837__$1);
var state_35874__$1 = (function (){var statearr_35895 = state_35874;
(statearr_35895[(7)] = inst_35837__$1);

(statearr_35895[(11)] = inst_35839);

return statearr_35895;
})();
if(inst_35840){
var statearr_35896_35921 = state_35874__$1;
(statearr_35896_35921[(1)] = (11));

} else {
var statearr_35897_35922 = state_35874__$1;
(statearr_35897_35922[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (5))){
var _ = (function (){var statearr_35898 = state_35874;
(statearr_35898[(4)] = cljs.core.rest((state_35874[(4)])));

return statearr_35898;
})();
var state_35874__$1 = state_35874;
var ex35894 = (state_35874__$1[(2)]);
var statearr_35899_35923 = state_35874__$1;
(statearr_35899_35923[(5)] = ex35894);


if((ex35894 instanceof Error)){
var statearr_35900_35924 = state_35874__$1;
(statearr_35900_35924[(1)] = (4));

(statearr_35900_35924[(5)] = null);

} else {
throw ex35894;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (14))){
var inst_35845 = (state_35874[(2)]);
var inst_35846 = fluree.db.util.async.throw_err(inst_35845);
var state_35874__$1 = state_35874;
var statearr_35901_35925 = state_35874__$1;
(statearr_35901_35925[(2)] = inst_35846);

(statearr_35901_35925[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (16))){
var inst_35837 = (state_35874[(7)]);
var inst_35830 = (state_35874[(8)]);
var inst_35824 = (state_35874[(9)]);
var inst_35850 = (state_35874[(10)]);
var inst_35858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35859 = inst_35830.s;
var inst_35860 = [inst_35859,inst_35837,cljs.core.cst$kw$new];
var inst_35861 = (new cljs.core.PersistentVector(null,3,(5),inst_35858,inst_35860,null));
var inst_35862 = cljs.core.assoc_in(inst_35824,inst_35861,inst_35850);
var state_35874__$1 = state_35874;
var statearr_35902_35926 = state_35874__$1;
(statearr_35902_35926[(2)] = inst_35862);

(statearr_35902_35926[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (10))){
var inst_35867 = (state_35874[(2)]);
var state_35874__$1 = state_35874;
var statearr_35903_35927 = state_35874__$1;
(statearr_35903_35927[(2)] = inst_35867);

(statearr_35903_35927[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35875 === (8))){
var inst_35824 = (state_35874[(9)]);
var state_35874__$1 = state_35874;
var statearr_35904_35928 = state_35874__$1;
(statearr_35904_35928[(2)] = inst_35824);

(statearr_35904_35928[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____0 = (function (){
var statearr_35905 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35905[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__);

(statearr_35905[(1)] = (1));

return statearr_35905;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____1 = (function (state_35874){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_35874);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e35906){var ex__17136__auto__ = e35906;
var statearr_35907_35929 = state_35874;
(statearr_35907_35929[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_35874[(4)]))){
var statearr_35908_35930 = state_35874;
(statearr_35908_35930[(1)] = cljs.core.first((state_35874[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__35931 = state_35874;
state_35874 = G__35931;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__ = function(state_35874){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____1.call(this,state_35874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_35909 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_35909[(6)] = c__17207__auto__);

return statearr_35909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__35933 = arguments.length;
switch (G__35933) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__35936 = arguments.length;
switch (G__35936) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_36245){
var state_val_36246 = (state_36245[(1)]);
if((state_val_36246 === (65))){
var inst_36198 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36247_36419 = state_36245__$1;
(statearr_36247_36419[(2)] = inst_36198);

(statearr_36247_36419[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (70))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36120 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36121 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36120,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,2,inst_36120,null));
var inst_36122 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36121,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36121,null));
var inst_36123 = (inst_36122.cljs$core$IFn$_invoke$arity$1 ? inst_36122.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36122.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36123)){
var statearr_36248_36420 = state_36245__$1;
(statearr_36248_36420[(1)] = (71));

} else {
var statearr_36249_36421 = state_36245__$1;
(statearr_36249_36421[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (62))){
var inst_36200 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36250_36422 = state_36245__$1;
(statearr_36250_36422[(2)] = inst_36200);

(statearr_36250_36422[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (74))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36130 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_36131 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36130,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,3,inst_36130,null));
var inst_36132 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36131,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36131,null));
var inst_36133 = (inst_36132.cljs$core$IFn$_invoke$arity$1 ? inst_36132.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36132.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36133)){
var statearr_36251_36423 = state_36245__$1;
(statearr_36251_36423[(1)] = (75));

} else {
var statearr_36252_36424 = state_36245__$1;
(statearr_36252_36424[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (110))){
var inst_36232 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36253_36425 = state_36245__$1;
(statearr_36253_36425[(2)] = inst_36232);

(statearr_36253_36425[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (7))){
var inst_36240 = (state_36245[(2)]);
var _ = (function (){var statearr_36254 = state_36245;
(statearr_36254[(4)] = cljs.core.rest((state_36245[(4)])));

return statearr_36254;
})();
var state_36245__$1 = state_36245;
var statearr_36255_36426 = state_36245__$1;
(statearr_36255_36426[(2)] = inst_36240);

(statearr_36255_36426[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (59))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36106 = (state_36245[(2)]);
var inst_36107__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36106,cljs.core.cst$kw$old);
var inst_36108__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36106,cljs.core.cst$kw$new);
var inst_36109 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36108__$1,inst_36107__$1);
var state_36245__$1 = (function (){var statearr_36256 = state_36245;
(statearr_36256[(7)] = inst_36107__$1);

(statearr_36256[(8)] = inst_36108__$1);

return statearr_36256;
})();
if(inst_36109){
var statearr_36257_36427 = state_36245__$1;
(statearr_36257_36427[(1)] = (60));

} else {
var statearr_36258_36428 = state_36245__$1;
(statearr_36258_36428[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (86))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36160 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_36161 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36160,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,5,inst_36160,null));
var inst_36162 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36161,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36161,null));
var inst_36163 = (inst_36162.cljs$core$IFn$_invoke$arity$1 ? inst_36162.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36162.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36163)){
var statearr_36259_36429 = state_36245__$1;
(statearr_36259_36429[(1)] = (87));

} else {
var statearr_36260_36430 = state_36245__$1;
(statearr_36260_36430[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (20))){
var inst_35976 = (state_36245[(9)]);
var inst_36001 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36002 = inst_36001 === true;
var inst_36003 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36004 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36003);
var inst_36005 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_36004);
var inst_36006 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36007 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36006);
var inst_36008 = inst_36007 === true;
var inst_36009 = ((inst_36002) && (inst_36005) && (inst_36008));
var state_36245__$1 = state_36245;
var statearr_36261_36431 = state_36245__$1;
(statearr_36261_36431[(2)] = inst_36009);

(statearr_36261_36431[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (72))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36126 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36262_36432 = state_36245__$1;
(statearr_36262_36432[(2)] = inst_36126);

(statearr_36262_36432[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (58))){
var inst_36085 = (state_36245[(10)]);
var state_36245__$1 = state_36245;
var statearr_36263_36433 = state_36245__$1;
(statearr_36263_36433[(2)] = inst_36085);

(statearr_36263_36433[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (60))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36264_36434 = state_36245__$1;
(statearr_36264_36434[(2)] = inst_36075);

(statearr_36264_36434[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (27))){
var inst_35996 = (state_36245[(12)]);
var state_36245__$1 = state_36245;
var statearr_36265_36435 = state_36245__$1;
(statearr_36265_36435[(2)] = inst_35996);

(statearr_36265_36435[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (1))){
var state_36245__$1 = state_36245;
var statearr_36266_36436 = state_36245__$1;
(statearr_36266_36436[(2)] = null);

(statearr_36266_36436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (69))){
var inst_36193 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36267_36437 = state_36245__$1;
(statearr_36267_36437[(2)] = inst_36193);

(statearr_36267_36437[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (101))){
var inst_36222 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36222)){
var statearr_36268_36438 = state_36245__$1;
(statearr_36268_36438[(1)] = (105));

} else {
var statearr_36269_36439 = state_36245__$1;
(statearr_36269_36439[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (24))){
var inst_35996 = (state_36245[(12)]);
var state_36245__$1 = state_36245;
var statearr_36270_36440 = state_36245__$1;
(statearr_36270_36440[(2)] = inst_35996);

(statearr_36270_36440[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (102))){
var inst_35976 = (state_36245[(9)]);
var inst_36209 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36210 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36209);
var inst_36211 = inst_36210 === true;
var inst_36212 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36213 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36212);
var inst_36214 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_36213);
var inst_36215 = (!(inst_36214));
var inst_36216 = ((inst_36211) && (inst_36215));
var state_36245__$1 = state_36245;
var statearr_36271_36441 = state_36245__$1;
(statearr_36271_36441[(2)] = inst_36216);

(statearr_36271_36441[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (55))){
var state_36245__$1 = state_36245;
var statearr_36272_36442 = state_36245__$1;
(statearr_36272_36442[(2)] = false);

(statearr_36272_36442[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (85))){
var inst_36158 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36273_36443 = state_36245__$1;
(statearr_36273_36443[(2)] = inst_36158);

(statearr_36273_36443[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (39))){
var state_36245__$1 = state_36245;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36274_36444 = state_36245__$1;
(statearr_36274_36444[(1)] = (42));

} else {
var statearr_36275_36445 = state_36245__$1;
(statearr_36275_36445[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (88))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36166 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36276_36446 = state_36245__$1;
(statearr_36276_36446[(2)] = inst_36166);

(statearr_36276_36446[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (46))){
var inst_36076 = (state_36245[(13)]);
var state_36245__$1 = state_36245;
var statearr_36277_36447 = state_36245__$1;
(statearr_36277_36447[(2)] = inst_36076);

(statearr_36277_36447[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (4))){
var inst_35937 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36278_36448 = state_36245__$1;
(statearr_36278_36448[(2)] = inst_35937);

(statearr_36278_36448[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (77))){
var inst_36138 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36279_36449 = state_36245__$1;
(statearr_36279_36449[(2)] = inst_36138);

(statearr_36279_36449[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (106))){
var inst_36203 = (state_36245[(14)]);
var state_36245__$1 = state_36245;
var statearr_36280_36450 = state_36245__$1;
(statearr_36280_36450[(2)] = inst_36203);

(statearr_36280_36450[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (95))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36281_36451 = state_36245__$1;
(statearr_36281_36451[(2)] = inst_36075);

(statearr_36281_36451[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (54))){
var state_36245__$1 = state_36245;
var statearr_36282_36452 = state_36245__$1;
(statearr_36282_36452[(2)] = true);

(statearr_36282_36452[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (92))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36176 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36283_36453 = state_36245__$1;
(statearr_36283_36453[(2)] = inst_36176);

(statearr_36283_36453[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (104))){
var inst_36219 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36284_36454 = state_36245__$1;
(statearr_36284_36454[(2)] = inst_36219);

(statearr_36284_36454[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (15))){
var inst_35964 = (state_36245[(15)]);
var state_36245__$1 = state_36245;
var statearr_36285_36455 = state_36245__$1;
(statearr_36285_36455[(2)] = inst_35964);

(statearr_36285_36455[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (48))){
var inst_35976 = (state_36245[(9)]);
var inst_36085 = (state_36245[(10)]);
var inst_36085__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36087 = (inst_36085__$1 == null);
var inst_36088 = cljs.core.not(inst_36087);
var state_36245__$1 = (function (){var statearr_36286 = state_36245;
(statearr_36286[(10)] = inst_36085__$1);

return statearr_36286;
})();
if(inst_36088){
var statearr_36287_36456 = state_36245__$1;
(statearr_36287_36456[(1)] = (51));

} else {
var statearr_36288_36457 = state_36245__$1;
(statearr_36288_36457[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (50))){
var inst_35976 = (state_36245[(9)]);
var inst_36203 = (state_36245[(2)]);
var inst_36204 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36205 = inst_36204 === true;
var state_36245__$1 = (function (){var statearr_36289 = state_36245;
(statearr_36289[(14)] = inst_36203);

return statearr_36289;
})();
if(cljs.core.truth_(inst_36205)){
var statearr_36290_36458 = state_36245__$1;
(statearr_36290_36458[(1)] = (99));

} else {
var statearr_36291_36459 = state_36245__$1;
(statearr_36291_36459[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (75))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36292_36460 = state_36245__$1;
(statearr_36292_36460[(2)] = inst_36075);

(statearr_36292_36460[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (99))){
var inst_35976 = (state_36245[(9)]);
var inst_36207 = (state_36245[(16)]);
var inst_36207__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36293 = state_36245;
(statearr_36293[(16)] = inst_36207__$1);

return statearr_36293;
})();
if(cljs.core.truth_(inst_36207__$1)){
var statearr_36294_36461 = state_36245__$1;
(statearr_36294_36461[(1)] = (102));

} else {
var statearr_36295_36462 = state_36245__$1;
(statearr_36295_36462[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (21))){
var inst_35999 = (state_36245[(17)]);
var state_36245__$1 = state_36245;
var statearr_36296_36463 = state_36245__$1;
(statearr_36296_36463[(2)] = inst_35999);

(statearr_36296_36463[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (31))){
var inst_36039 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36039)){
var statearr_36297_36464 = state_36245__$1;
(statearr_36297_36464[(1)] = (32));

} else {
var statearr_36298_36465 = state_36245__$1;
(statearr_36298_36465[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (32))){
var inst_36028 = (state_36245[(18)]);
var inst_36041 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_36028,"a component","a non-component",throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36299_36466 = state_36245__$1;
(statearr_36299_36466[(2)] = inst_36041);

(statearr_36299_36466[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (40))){
var inst_36044 = (state_36245[(19)]);
var state_36245__$1 = state_36245;
var statearr_36300_36467 = state_36245__$1;
(statearr_36300_36467[(2)] = inst_36044);

(statearr_36300_36467[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (91))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36301_36468 = state_36245__$1;
(statearr_36301_36468[(2)] = inst_36075);

(statearr_36301_36468[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (108))){
var inst_36225 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36226 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36227 = cljs.core.PersistentHashMap.fromArrays(inst_36225,inst_36226);
var inst_36228 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_36227);
var inst_36229 = (function(){throw inst_36228})();
var state_36245__$1 = state_36245;
var statearr_36302_36469 = state_36245__$1;
(statearr_36302_36469[(2)] = inst_36229);

(statearr_36302_36469[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (56))){
var inst_36098 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36303_36470 = state_36245__$1;
(statearr_36303_36470[(2)] = inst_36098);

(statearr_36303_36470[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (33))){
var inst_36028 = (state_36245[(18)]);
var state_36245__$1 = state_36245;
var statearr_36304_36471 = state_36245__$1;
(statearr_36304_36471[(2)] = inst_36028);

(statearr_36304_36471[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (13))){
var inst_35991 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_35991)){
var statearr_36305_36472 = state_36245__$1;
(statearr_36305_36472[(1)] = (14));

} else {
var statearr_36306_36473 = state_36245__$1;
(statearr_36306_36473[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (22))){
var inst_36012 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36307_36474 = state_36245__$1;
(statearr_36307_36474[(2)] = inst_36012);

(statearr_36307_36474[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (90))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36170 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_36171 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_36170,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,5,inst_36170,null));
var inst_36172 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36171,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36171,null));
var inst_36173 = (inst_36172.cljs$core$IFn$_invoke$arity$1 ? inst_36172.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36172.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36173)){
var statearr_36308_36475 = state_36245__$1;
(statearr_36308_36475[(1)] = (91));

} else {
var statearr_36309_36476 = state_36245__$1;
(statearr_36309_36476[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (109))){
var inst_36203 = (state_36245[(14)]);
var state_36245__$1 = state_36245;
var statearr_36310_36477 = state_36245__$1;
(statearr_36310_36477[(2)] = inst_36203);

(statearr_36310_36477[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (36))){
var inst_36045 = (state_36245[(20)]);
var state_36245__$1 = state_36245;
var statearr_36311_36478 = state_36245__$1;
(statearr_36311_36478[(2)] = inst_36045);

(statearr_36311_36478[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (41))){
var inst_35976 = (state_36245[(9)]);
var inst_36076 = (state_36245[(13)]);
var inst_36075 = (state_36245[(2)]);
var inst_36076__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36312 = state_36245;
(statearr_36312[(11)] = inst_36075);

(statearr_36312[(13)] = inst_36076__$1);

return statearr_36312;
})();
if(cljs.core.truth_(inst_36076__$1)){
var statearr_36313_36479 = state_36245__$1;
(statearr_36313_36479[(1)] = (45));

} else {
var statearr_36314_36480 = state_36245__$1;
(statearr_36314_36480[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (89))){
var inst_36168 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36315_36481 = state_36245__$1;
(statearr_36315_36481[(2)] = inst_36168);

(statearr_36315_36481[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (100))){
var state_36245__$1 = state_36245;
var statearr_36316_36482 = state_36245__$1;
(statearr_36316_36482[(2)] = false);

(statearr_36316_36482[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (43))){
var inst_36044 = (state_36245[(19)]);
var state_36245__$1 = state_36245;
var statearr_36317_36483 = state_36245__$1;
(statearr_36317_36483[(2)] = inst_36044);

(statearr_36317_36483[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (61))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36112 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_36113 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36112,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,3,inst_36112,null));
var inst_36114 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36113,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36113,null));
var inst_36115 = (inst_36114.cljs$core$IFn$_invoke$arity$1 ? inst_36114.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36114.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36115)){
var statearr_36318_36484 = state_36245__$1;
(statearr_36318_36484[(1)] = (63));

} else {
var statearr_36319_36485 = state_36245__$1;
(statearr_36319_36485[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (29))){
var inst_35976 = (state_36245[(9)]);
var inst_36031 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36032 = cljs.core.not(inst_36031);
var inst_36033 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36034 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36033);
var inst_36035 = inst_36034 === true;
var inst_36036 = ((inst_36032) && (inst_36035));
var state_36245__$1 = state_36245;
var statearr_36320_36486 = state_36245__$1;
(statearr_36320_36486[(2)] = inst_36036);

(statearr_36320_36486[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (44))){
var inst_36072 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36321_36487 = state_36245__$1;
(statearr_36321_36487[(2)] = inst_36072);

(statearr_36321_36487[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (93))){
var inst_36178 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36322_36488 = state_36245__$1;
(statearr_36322_36488[(2)] = inst_36178);

(statearr_36322_36488[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (6))){
var inst_35975 = (state_36245[(21)]);
var inst_35963 = (state_36245[(22)]);
var inst_35972 = cljs.core.seq(inst_35963);
var inst_35973 = cljs.core.first(inst_35972);
var inst_35974 = cljs.core.next(inst_35972);
var inst_35975__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35973,(0),null);
var inst_35976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35973,(1),null);
var inst_35977 = cljs.core.not(inst_35975__$1);
var state_36245__$1 = (function (){var statearr_36323 = state_36245;
(statearr_36323[(21)] = inst_35975__$1);

(statearr_36323[(9)] = inst_35976);

(statearr_36323[(23)] = inst_35974);

return statearr_36323;
})();
if(inst_35977){
var statearr_36324_36489 = state_36245__$1;
(statearr_36324_36489[(1)] = (8));

} else {
var statearr_36325_36490 = state_36245__$1;
(statearr_36325_36490[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (28))){
var inst_36025 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36326_36491 = state_36245__$1;
(statearr_36326_36491[(2)] = inst_36025);

(statearr_36326_36491[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (64))){
var state_36245__$1 = state_36245;
var statearr_36327_36492 = state_36245__$1;
(statearr_36327_36492[(1)] = (66));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (103))){
var inst_36207 = (state_36245[(16)]);
var state_36245__$1 = state_36245;
var statearr_36329_36493 = state_36245__$1;
(statearr_36329_36493[(2)] = inst_36207);

(statearr_36329_36493[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (51))){
var inst_36085 = (state_36245[(10)]);
var inst_36090 = inst_36085.cljs$lang$protocol_mask$partition0$;
var inst_36091 = (inst_36090 & (64));
var inst_36092 = inst_36085.cljs$core$ISeq$;
var inst_36093 = (cljs.core.PROTOCOL_SENTINEL === inst_36092);
var inst_36094 = ((inst_36091) || (inst_36093));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36094)){
var statearr_36330_36494 = state_36245__$1;
(statearr_36330_36494[(1)] = (54));

} else {
var statearr_36331_36495 = state_36245__$1;
(statearr_36331_36495[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (25))){
var inst_36029 = (state_36245[(24)]);
var inst_35976 = (state_36245[(9)]);
var inst_36028 = (state_36245[(2)]);
var inst_36029__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36332 = state_36245;
(statearr_36332[(18)] = inst_36028);

(statearr_36332[(24)] = inst_36029__$1);

return statearr_36332;
})();
if(cljs.core.truth_(inst_36029__$1)){
var statearr_36333_36496 = state_36245__$1;
(statearr_36333_36496[(1)] = (29));

} else {
var statearr_36334_36497 = state_36245__$1;
(statearr_36334_36497[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (34))){
var inst_35976 = (state_36245[(9)]);
var inst_36045 = (state_36245[(20)]);
var inst_36044 = (state_36245[(2)]);
var inst_36045__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36335 = state_36245;
(statearr_36335[(19)] = inst_36044);

(statearr_36335[(20)] = inst_36045__$1);

return statearr_36335;
})();
if(cljs.core.truth_(inst_36045__$1)){
var statearr_36336_36498 = state_36245__$1;
(statearr_36336_36498[(1)] = (35));

} else {
var statearr_36337_36499 = state_36245__$1;
(statearr_36337_36499[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (17))){
var inst_35976 = (state_36245[(9)]);
var inst_35999 = (state_36245[(17)]);
var inst_35999__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36338 = state_36245;
(statearr_36338[(17)] = inst_35999__$1);

return statearr_36338;
})();
if(cljs.core.truth_(inst_35999__$1)){
var statearr_36339_36500 = state_36245__$1;
(statearr_36339_36500[(1)] = (20));

} else {
var statearr_36340_36501 = state_36245__$1;
(statearr_36340_36501[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (3))){
var inst_36243 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36245__$1,inst_36243);
} else {
if((state_val_36246 === (12))){
var inst_35980 = (state_36245[(25)]);
var state_36245__$1 = state_36245;
var statearr_36341_36502 = state_36245__$1;
(statearr_36341_36502[(2)] = inst_35980);

(statearr_36341_36502[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (2))){
var _ = (function (){var statearr_36342 = state_36245;
(statearr_36342[(4)] = cljs.core.cons((5),(state_36245[(4)])));

return statearr_36342;
})();
var inst_35956 = pred_changes;
var inst_35957 = cljs.core.seq(inst_35956);
var inst_35958 = cljs.core.first(inst_35957);
var inst_35959 = cljs.core.next(inst_35957);
var inst_35960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35958,(0),null);
var inst_35961 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35958,(1),null);
var inst_35962 = db;
var inst_35963 = inst_35956;
var inst_35964 = inst_35962;
var state_36245__$1 = (function (){var statearr_36343 = state_36245;
(statearr_36343[(26)] = inst_35961);

(statearr_36343[(15)] = inst_35964);

(statearr_36343[(22)] = inst_35963);

(statearr_36343[(27)] = inst_35960);

(statearr_36343[(28)] = inst_35959);

return statearr_36343;
})();
var statearr_36344_36503 = state_36245__$1;
(statearr_36344_36503[(2)] = null);

(statearr_36344_36503[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (66))){
var inst_36108 = (state_36245[(8)]);
var state_36245__$1 = state_36245;
var G__36345_36504 = inst_36108;
var G__36345_36505__$1 = (((G__36345_36504 instanceof cljs.core.Keyword))?G__36345_36504.fqn:null);
switch (G__36345_36505__$1) {
case "long":
var statearr_36346_36507 = state_36245__$1;
(statearr_36346_36507[(1)] = (70));


break;
case "bigint":
var statearr_36347_36508 = state_36245__$1;
(statearr_36347_36508[(1)] = (74));


break;
case "double":
var statearr_36348_36509 = state_36245__$1;
(statearr_36348_36509[(1)] = (78));


break;
case "float":
var statearr_36349_36510 = state_36245__$1;
(statearr_36349_36510[(1)] = (82));


break;
case "bigdec":
var statearr_36350_36511 = state_36245__$1;
(statearr_36350_36511[(1)] = (86));


break;
case "string":
var statearr_36351_36512 = state_36245__$1;
(statearr_36351_36512[(1)] = (90));


break;
case "instant":
var statearr_36352_36513 = state_36245__$1;
(statearr_36352_36513[(1)] = (94));


break;
default:
var statearr_36353_36514 = state_36245__$1;
(statearr_36353_36514[(1)] = (98));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (107))){
var inst_35974 = (state_36245[(23)]);
var inst_36235 = (state_36245[(2)]);
var inst_35963 = inst_35974;
var inst_35964 = inst_36235;
var state_36245__$1 = (function (){var statearr_36354 = state_36245;
(statearr_36354[(15)] = inst_35964);

(statearr_36354[(22)] = inst_35963);

return statearr_36354;
})();
var statearr_36355_36515 = state_36245__$1;
(statearr_36355_36515[(2)] = null);

(statearr_36355_36515[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (23))){
var state_36245__$1 = state_36245;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36356_36516 = state_36245__$1;
(statearr_36356_36516[(1)] = (26));

} else {
var statearr_36357_36517 = state_36245__$1;
(statearr_36357_36517[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (47))){
var inst_36082 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36082)){
var statearr_36358_36518 = state_36245__$1;
(statearr_36358_36518[(1)] = (48));

} else {
var statearr_36359_36519 = state_36245__$1;
(statearr_36359_36519[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (35))){
var inst_35975 = (state_36245[(21)]);
var inst_35964 = (state_36245[(15)]);
var inst_35976 = (state_36245[(9)]);
var inst_36047 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36048 = cljs.core.not(inst_36047);
var inst_36049 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36050 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_36049);
var inst_36051 = inst_36050 === true;
var inst_36052 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_35964,inst_35975);
var state_36245__$1 = (function (){var statearr_36360 = state_36245;
(statearr_36360[(29)] = inst_36051);

(statearr_36360[(30)] = inst_36048);

return statearr_36360;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36245__$1,(38),inst_36052);
} else {
if((state_val_36246 === (82))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36150 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36151 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36150,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,3,inst_36150,null));
var inst_36152 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36151,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36151,null));
var inst_36153 = (inst_36152.cljs$core$IFn$_invoke$arity$1 ? inst_36152.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36152.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36153)){
var statearr_36361_36520 = state_36245__$1;
(statearr_36361_36520[(1)] = (83));

} else {
var statearr_36362_36521 = state_36245__$1;
(statearr_36362_36521[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (76))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36136 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36363_36522 = state_36245__$1;
(statearr_36363_36522[(2)] = inst_36136);

(statearr_36363_36522[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (97))){
var inst_36188 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36364_36523 = state_36245__$1;
(statearr_36364_36523[(2)] = inst_36188);

(statearr_36364_36523[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (19))){
var inst_36015 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36015)){
var statearr_36365_36524 = state_36245__$1;
(statearr_36365_36524[(1)] = (23));

} else {
var statearr_36366_36525 = state_36245__$1;
(statearr_36366_36525[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (57))){
var inst_36085 = (state_36245[(10)]);
var inst_36103 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36085);
var state_36245__$1 = state_36245;
var statearr_36367_36526 = state_36245__$1;
(statearr_36367_36526[(2)] = inst_36103);

(statearr_36367_36526[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (68))){
var inst_36196 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36368_36527 = state_36245__$1;
(statearr_36368_36527[(2)] = inst_36196);

(statearr_36368_36527[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (11))){
var inst_35976 = (state_36245[(9)]);
var inst_35982 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_35983 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35982);
var inst_35984 = inst_35983 === false;
var inst_35985 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_35986 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_35985);
var inst_35987 = inst_35986 === true;
var inst_35988 = ((inst_35984) && (inst_35987));
var state_36245__$1 = state_36245;
var statearr_36370_36528 = state_36245__$1;
(statearr_36370_36528[(2)] = inst_35988);

(statearr_36370_36528[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (9))){
var inst_35976 = (state_36245[(9)]);
var inst_35980 = (state_36245[(25)]);
var inst_35980__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36371 = state_36245;
(statearr_36371[(25)] = inst_35980__$1);

return statearr_36371;
})();
if(cljs.core.truth_(inst_35980__$1)){
var statearr_36372_36529 = state_36245__$1;
(statearr_36372_36529[(1)] = (11));

} else {
var statearr_36373_36530 = state_36245__$1;
(statearr_36373_36530[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (5))){
var _ = (function (){var statearr_36374 = state_36245;
(statearr_36374[(4)] = cljs.core.rest((state_36245[(4)])));

return statearr_36374;
})();
var state_36245__$1 = state_36245;
var ex36369 = (state_36245__$1[(2)]);
var statearr_36375_36531 = state_36245__$1;
(statearr_36375_36531[(5)] = ex36369);


if((ex36369 instanceof Error)){
var statearr_36376_36532 = state_36245__$1;
(statearr_36376_36532[(1)] = (4));

(statearr_36376_36532[(5)] = null);

} else {
throw ex36369;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (83))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36377_36533 = state_36245__$1;
(statearr_36377_36533[(2)] = inst_36075);

(statearr_36377_36533[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (14))){
var inst_35964 = (state_36245[(15)]);
var inst_35993 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_35964,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36378_36534 = state_36245__$1;
(statearr_36378_36534[(2)] = inst_35993);

(statearr_36378_36534[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (45))){
var inst_35976 = (state_36245[(9)]);
var inst_36078 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35976);
var inst_36079 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_36078);
var state_36245__$1 = state_36245;
var statearr_36379_36535 = state_36245__$1;
(statearr_36379_36535[(2)] = inst_36079);

(statearr_36379_36535[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (53))){
var inst_36101 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36101)){
var statearr_36380_36536 = state_36245__$1;
(statearr_36380_36536[(1)] = (57));

} else {
var statearr_36381_36537 = state_36245__$1;
(statearr_36381_36537[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (78))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36140 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_36141 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_36140,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,3,inst_36140,null));
var inst_36142 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36141,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36141,null));
var inst_36143 = (inst_36142.cljs$core$IFn$_invoke$arity$1 ? inst_36142.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36142.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36143)){
var statearr_36382_36538 = state_36245__$1;
(statearr_36382_36538[(1)] = (79));

} else {
var statearr_36383_36539 = state_36245__$1;
(statearr_36383_36539[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (26))){
var inst_36018 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36019 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36020 = cljs.core.PersistentHashMap.fromArrays(inst_36018,inst_36019);
var inst_36021 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_36020);
var inst_36022 = (function(){throw inst_36021})();
var state_36245__$1 = state_36245;
var statearr_36384_36540 = state_36245__$1;
(statearr_36384_36540[(2)] = inst_36022);

(statearr_36384_36540[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (16))){
var inst_35976 = (state_36245[(9)]);
var inst_35997 = (state_36245[(31)]);
var inst_35996 = (state_36245[(2)]);
var inst_35997__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35976);
var state_36245__$1 = (function (){var statearr_36385 = state_36245;
(statearr_36385[(31)] = inst_35997__$1);

(statearr_36385[(12)] = inst_35996);

return statearr_36385;
})();
if(cljs.core.truth_(inst_35997__$1)){
var statearr_36386_36541 = state_36245__$1;
(statearr_36386_36541[(1)] = (17));

} else {
var statearr_36387_36542 = state_36245__$1;
(statearr_36387_36542[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (81))){
var inst_36148 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36388_36543 = state_36245__$1;
(statearr_36388_36543[(2)] = inst_36148);

(statearr_36388_36543[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (79))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36389_36544 = state_36245__$1;
(statearr_36389_36544[(2)] = inst_36075);

(statearr_36389_36544[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (38))){
var inst_36051 = (state_36245[(29)]);
var inst_36048 = (state_36245[(30)]);
var inst_36054 = (state_36245[(2)]);
var inst_36055 = fluree.db.util.async.throw_err(inst_36054);
var inst_36056 = cljs.core.not(inst_36055);
var inst_36057 = ((inst_36048) && (inst_36051) && (inst_36056));
var state_36245__$1 = state_36245;
var statearr_36390_36545 = state_36245__$1;
(statearr_36390_36545[(2)] = inst_36057);

(statearr_36390_36545[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (98))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36190 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36391_36546 = state_36245__$1;
(statearr_36391_36546[(2)] = inst_36190);

(statearr_36391_36546[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (87))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36392_36547 = state_36245__$1;
(statearr_36392_36547[(2)] = inst_36075);

(statearr_36392_36547[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (30))){
var inst_36029 = (state_36245[(24)]);
var state_36245__$1 = state_36245;
var statearr_36393_36548 = state_36245__$1;
(statearr_36393_36548[(2)] = inst_36029);

(statearr_36393_36548[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (73))){
var inst_36128 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36394_36549 = state_36245__$1;
(statearr_36394_36549[(2)] = inst_36128);

(statearr_36394_36549[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (96))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36186 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36395_36550 = state_36245__$1;
(statearr_36395_36550[(2)] = inst_36186);

(statearr_36395_36550[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (10))){
var inst_36238 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
var statearr_36396_36551 = state_36245__$1;
(statearr_36396_36551[(2)] = inst_36238);

(statearr_36396_36551[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (18))){
var inst_35997 = (state_36245[(31)]);
var state_36245__$1 = state_36245;
var statearr_36397_36552 = state_36245__$1;
(statearr_36397_36552[(2)] = inst_35997);

(statearr_36397_36552[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (105))){
var state_36245__$1 = state_36245;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_36398_36553 = state_36245__$1;
(statearr_36398_36553[(1)] = (108));

} else {
var statearr_36399_36554 = state_36245__$1;
(statearr_36399_36554[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (52))){
var state_36245__$1 = state_36245;
var statearr_36400_36555 = state_36245__$1;
(statearr_36400_36555[(2)] = false);

(statearr_36400_36555[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (67))){
var state_36245__$1 = state_36245;
var statearr_36401_36556 = state_36245__$1;
(statearr_36401_36556[(2)] = null);

(statearr_36401_36556[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (71))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36402_36557 = state_36245__$1;
(statearr_36402_36557[(2)] = inst_36075);

(statearr_36402_36557[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (42))){
var inst_35975 = (state_36245[(21)]);
var inst_35964 = (state_36245[(15)]);
var inst_36063 = fluree.db.dbproto._p_prop(inst_35964,cljs.core.cst$kw$name,inst_35975);
var inst_36064 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36063)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_36065 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36066 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_36067 = cljs.core.PersistentHashMap.fromArrays(inst_36065,inst_36066);
var inst_36068 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36064,inst_36067);
var inst_36069 = (function(){throw inst_36068})();
var state_36245__$1 = state_36245;
var statearr_36403_36558 = state_36245__$1;
(statearr_36403_36558[(2)] = inst_36069);

(statearr_36403_36558[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (80))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36146 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36404_36559 = state_36245__$1;
(statearr_36404_36559[(2)] = inst_36146);

(statearr_36404_36559[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (37))){
var inst_36060 = (state_36245[(2)]);
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36060)){
var statearr_36405_36560 = state_36245__$1;
(statearr_36405_36560[(1)] = (39));

} else {
var statearr_36406_36561 = state_36245__$1;
(statearr_36406_36561[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (63))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36117 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36407_36562 = state_36245__$1;
(statearr_36407_36562[(2)] = inst_36117);

(statearr_36407_36562[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (94))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36180 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_36181 = (inst_36108.cljs$core$IFn$_invoke$arity$5 ? inst_36108.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_36180,null) : inst_36108.call(null,cljs.core.PersistentArrayMap,null,2,inst_36180,null));
var inst_36182 = (inst_36108.cljs$core$IFn$_invoke$arity$4 ? inst_36108.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_36181,null) : inst_36108.call(null,cljs.core.PersistentHashSet,null,inst_36181,null));
var inst_36183 = (inst_36182.cljs$core$IFn$_invoke$arity$1 ? inst_36182.cljs$core$IFn$_invoke$arity$1(inst_36107) : inst_36182.call(null,inst_36107));
var state_36245__$1 = state_36245;
if(cljs.core.truth_(inst_36183)){
var statearr_36408_36563 = state_36245__$1;
(statearr_36408_36563[(1)] = (95));

} else {
var statearr_36409_36564 = state_36245__$1;
(statearr_36409_36564[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (8))){
var inst_35964 = (state_36245[(15)]);
var state_36245__$1 = state_36245;
var statearr_36410_36565 = state_36245__$1;
(statearr_36410_36565[(2)] = inst_35964);

(statearr_36410_36565[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (49))){
var inst_36075 = (state_36245[(11)]);
var state_36245__$1 = state_36245;
var statearr_36411_36566 = state_36245__$1;
(statearr_36411_36566[(2)] = inst_36075);

(statearr_36411_36566[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36246 === (84))){
var inst_36107 = (state_36245[(7)]);
var inst_36108 = (state_36245[(8)]);
var inst_36156 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36108,throw_QMARK_);
var state_36245__$1 = state_36245;
var statearr_36412_36567 = state_36245__$1;
(statearr_36412_36567[(2)] = inst_36156);

(statearr_36412_36567[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__17133__auto__ = null;
var fluree$db$query$schema$state_machine__17133__auto____0 = (function (){
var statearr_36413 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36413[(0)] = fluree$db$query$schema$state_machine__17133__auto__);

(statearr_36413[(1)] = (1));

return statearr_36413;
});
var fluree$db$query$schema$state_machine__17133__auto____1 = (function (state_36245){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_36245);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e36414){var ex__17136__auto__ = e36414;
var statearr_36415_36568 = state_36245;
(statearr_36415_36568[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_36245[(4)]))){
var statearr_36416_36569 = state_36245;
(statearr_36416_36569[(1)] = cljs.core.first((state_36245[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__36570 = state_36245;
state_36245 = G__36570;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__17133__auto__ = function(state_36245){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__17133__auto____1.call(this,state_36245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__17133__auto____0;
fluree$db$query$schema$state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__17133__auto____1;
return fluree$db$query$schema$state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_36417 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_36417[(6)] = c__17207__auto__);

return statearr_36417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_36594){
var state_val_36595 = (state_36594[(1)]);
if((state_val_36595 === (7))){
var state_36594__$1 = state_36594;
var statearr_36596_36615 = state_36594__$1;
(statearr_36596_36615[(2)] = db);

(statearr_36596_36615[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (1))){
var state_36594__$1 = state_36594;
var statearr_36597_36616 = state_36594__$1;
(statearr_36597_36616[(2)] = null);

(statearr_36597_36616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (4))){
var inst_36571 = (state_36594[(2)]);
var state_36594__$1 = state_36594;
var statearr_36598_36617 = state_36594__$1;
(statearr_36598_36617[(2)] = inst_36571);

(statearr_36598_36617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (6))){
var inst_36580 = (state_36594[(7)]);
var inst_36579 = (state_36594[(2)]);
var inst_36580__$1 = fluree.db.util.async.throw_err(inst_36579);
var inst_36581 = cljs.core.empty_QMARK_(inst_36580__$1);
var state_36594__$1 = (function (){var statearr_36599 = state_36594;
(statearr_36599[(7)] = inst_36580__$1);

return statearr_36599;
})();
if(inst_36581){
var statearr_36600_36618 = state_36594__$1;
(statearr_36600_36618[(1)] = (7));

} else {
var statearr_36601_36619 = state_36594__$1;
(statearr_36601_36619[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (3))){
var inst_36592 = (state_36594[(2)]);
var state_36594__$1 = state_36594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36594__$1,inst_36592);
} else {
if((state_val_36595 === (2))){
var _ = (function (){var statearr_36603 = state_36594;
(statearr_36603[(4)] = cljs.core.cons((5),(state_36594[(4)])));

return statearr_36603;
})();
var inst_36577 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_36594__$1 = state_36594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36594__$1,(6),inst_36577);
} else {
if((state_val_36595 === (9))){
var inst_36589 = (state_36594[(2)]);
var _ = (function (){var statearr_36604 = state_36594;
(statearr_36604[(4)] = cljs.core.rest((state_36594[(4)])));

return statearr_36604;
})();
var state_36594__$1 = state_36594;
var statearr_36605_36620 = state_36594__$1;
(statearr_36605_36620[(2)] = inst_36589);

(statearr_36605_36620[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (5))){
var _ = (function (){var statearr_36606 = state_36594;
(statearr_36606[(4)] = cljs.core.rest((state_36594[(4)])));

return statearr_36606;
})();
var state_36594__$1 = state_36594;
var ex36602 = (state_36594__$1[(2)]);
var statearr_36607_36621 = state_36594__$1;
(statearr_36607_36621[(5)] = ex36602);


if((ex36602 instanceof Error)){
var statearr_36608_36622 = state_36594__$1;
(statearr_36608_36622[(1)] = (4));

(statearr_36608_36622[(5)] = null);

} else {
throw ex36602;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (10))){
var inst_36586 = (state_36594[(2)]);
var inst_36587 = fluree.db.util.async.throw_err(inst_36586);
var state_36594__$1 = state_36594;
var statearr_36609_36623 = state_36594__$1;
(statearr_36609_36623[(2)] = inst_36587);

(statearr_36609_36623[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36595 === (8))){
var inst_36580 = (state_36594[(7)]);
var inst_36584 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_36580,db,true);
var state_36594__$1 = state_36594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36594__$1,(10),inst_36584);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____0 = (function (){
var statearr_36610 = [null,null,null,null,null,null,null,null];
(statearr_36610[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__);

(statearr_36610[(1)] = (1));

return statearr_36610;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____1 = (function (state_36594){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_36594);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e36611){var ex__17136__auto__ = e36611;
var statearr_36612_36624 = state_36594;
(statearr_36612_36624[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_36594[(4)]))){
var statearr_36613_36625 = state_36594;
(statearr_36613_36625[(1)] = cljs.core.first((state_36594[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__36626 = state_36594;
state_36594 = G__36626;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__ = function(state_36594){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____1.call(this,state_36594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_36614 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_36614[(6)] = c__17207__auto__);

return statearr_36614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__36628 = arguments.length;
switch (G__36628) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__36630 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36630,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36630,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36630,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__36633_SHARP_,p2__36634_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36633_SHARP_,p2__36634_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_36700){
var state_val_36701 = (state_36700[(1)]);
if((state_val_36701 === (1))){
var state_36700__$1 = state_36700;
var statearr_36702_36720 = state_36700__$1;
(statearr_36702_36720[(2)] = null);

(statearr_36702_36720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36701 === (2))){
var _ = (function (){var statearr_36703 = state_36700;
(statearr_36703[(4)] = cljs.core.cons((5),(state_36700[(4)])));

return statearr_36703;
})();
var inst_36652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36653 = fluree.db.flake.max_subject_id((1));
var inst_36654 = [inst_36653];
var inst_36655 = (new cljs.core.PersistentVector(null,1,(5),inst_36652,inst_36654,null));
var inst_36656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36657 = [(0)];
var inst_36658 = (new cljs.core.PersistentVector(null,1,(5),inst_36656,inst_36657,null));
var inst_36659 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_36655,cljs.core._LT__EQ_,inst_36658);
var state_36700__$1 = state_36700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36700__$1,(6),inst_36659);
} else {
if((state_val_36701 === (3))){
var inst_36698 = (state_36700[(2)]);
var state_36700__$1 = state_36700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36700__$1,inst_36698);
} else {
if((state_val_36701 === (4))){
var inst_36640 = (state_36700[(2)]);
var state_36700__$1 = state_36700;
var statearr_36705_36721 = state_36700__$1;
(statearr_36705_36721[(2)] = inst_36640);

(statearr_36705_36721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36701 === (5))){
var _ = (function (){var statearr_36706 = state_36700;
(statearr_36706[(4)] = cljs.core.rest((state_36700[(4)])));

return statearr_36706;
})();
var state_36700__$1 = state_36700;
var ex36704 = (state_36700__$1[(2)]);
var statearr_36707_36722 = state_36700__$1;
(statearr_36707_36722[(5)] = ex36704);


if((ex36704 instanceof Error)){
var statearr_36708_36723 = state_36700__$1;
(statearr_36708_36723[(1)] = (4));

(statearr_36708_36723[(5)] = null);

} else {
throw ex36704;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36701 === (6))){
var inst_36661 = (state_36700[(2)]);
var inst_36662 = fluree.db.util.async.throw_err(inst_36661);
var inst_36663 = (function (){var schema_flakes = inst_36662;
return (function (p1__36635_SHARP_){
return (p1__36635_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_36664 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36663,inst_36662);
var inst_36665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36664,(0),null);
var inst_36666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36664,(1),null);
var inst_36667 = (function (){var schema_flakes = inst_36662;
var vec__36646 = inst_36664;
var collection_flakes = inst_36665;
var predicate_flakes = inst_36666;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36637_SHARP_,p2__36638_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__36637_SHARP_,p2__36638_SHARP_.p,p2__36638_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_36668 = [(-1),"_tx"];
var inst_36669 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36670 = ["_tx",(-1),(-1)];
var inst_36671 = cljs.core.PersistentHashMap.fromArrays(inst_36669,inst_36670);
var inst_36672 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_36673 = ["_tx",(-1),(-1)];
var inst_36674 = cljs.core.PersistentHashMap.fromArrays(inst_36672,inst_36673);
var inst_36675 = [inst_36671,inst_36674];
var inst_36676 = cljs.core.PersistentHashMap.fromArrays(inst_36668,inst_36675);
var inst_36677 = (function (){var schema_flakes = inst_36662;
var vec__36646 = inst_36664;
var collection_flakes = inst_36665;
var predicate_flakes = inst_36666;
return (function (p1__36636_SHARP_){
return p1__36636_SHARP_.s;
});
})();
var inst_36678 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36677,inst_36665);
var inst_36679 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36667,inst_36676,inst_36678);
var inst_36681 = (function (){var schema_flakes = inst_36662;
var vec__36646 = inst_36664;
var collection_flakes = inst_36665;
var predicate_flakes = inst_36666;
var coll = inst_36679;
return (function (p__36680,pred_flakes){
var vec__36709 = p__36680;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36709,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36709,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__36712 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__36712.cljs$core$IFn$_invoke$arity$1 ? fexpr__36712.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__36712.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_36682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36683 = cljs.core.PersistentHashMap.EMPTY;
var inst_36684 = cljs.core.PersistentHashSet.EMPTY;
var inst_36685 = [inst_36683,inst_36684];
var inst_36686 = (new cljs.core.PersistentVector(null,2,(5),inst_36682,inst_36685,null));
var inst_36687 = (function (){var schema_flakes = inst_36662;
var vec__36646 = inst_36664;
var collection_flakes = inst_36665;
var predicate_flakes = inst_36666;
var coll = inst_36679;
return (function (p1__36639_SHARP_){
return p1__36639_SHARP_.s;
});
})();
var inst_36688 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_36687,inst_36666);
var inst_36689 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36681,inst_36686,inst_36688);
var inst_36690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36689,(0),null);
var inst_36691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36689,(1),null);
var inst_36692 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_36693 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36694 = [inst_36693,inst_36679,inst_36690,inst_36691];
var inst_36695 = cljs.core.PersistentHashMap.fromArrays(inst_36692,inst_36694);
var _ = (function (){var statearr_36713 = state_36700;
(statearr_36713[(4)] = cljs.core.rest((state_36700[(4)])));

return statearr_36713;
})();
var state_36700__$1 = state_36700;
var statearr_36714_36724 = state_36700__$1;
(statearr_36714_36724[(2)] = inst_36695);

(statearr_36714_36724[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__17133__auto____0 = (function (){
var statearr_36715 = [null,null,null,null,null,null,null];
(statearr_36715[(0)] = fluree$db$query$schema$schema_map_$_state_machine__17133__auto__);

(statearr_36715[(1)] = (1));

return statearr_36715;
});
var fluree$db$query$schema$schema_map_$_state_machine__17133__auto____1 = (function (state_36700){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_36700);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e36716){var ex__17136__auto__ = e36716;
var statearr_36717_36725 = state_36700;
(statearr_36717_36725[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_36700[(4)]))){
var statearr_36718_36726 = state_36700;
(statearr_36718_36726[(1)] = cljs.core.first((state_36700[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__36727 = state_36700;
state_36700 = G__36727;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__17133__auto__ = function(state_36700){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__17133__auto____1.call(this,state_36700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__17133__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__17133__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_36719 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_36719[(6)] = c__17207__auto__);

return statearr_36719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_36769){
var state_val_36770 = (state_36769[(1)]);
if((state_val_36770 === (7))){
var inst_36752 = (state_36769[(2)]);
var inst_36753 = fluree.db.query.schema.flake__GT_pred_map(inst_36752);
var inst_36754 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_36755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(114));
var inst_36756 = cljs.core.boolean$(inst_36755);
var inst_36757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(110));
var inst_36758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(117));
var inst_36759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_36758);
var inst_36760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(111));
var inst_36761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(115));
var inst_36762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36753,(112));
var inst_36763 = [inst_36756,inst_36757,inst_36759,inst_36760,inst_36761,inst_36762];
var inst_36764 = cljs.core.PersistentHashMap.fromArrays(inst_36754,inst_36763);
var _ = (function (){var statearr_36771 = state_36769;
(statearr_36771[(4)] = cljs.core.rest((state_36769[(4)])));

return statearr_36771;
})();
var state_36769__$1 = state_36769;
var statearr_36772_36795 = state_36769__$1;
(statearr_36772_36795[(2)] = inst_36764);

(statearr_36772_36795[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (1))){
var state_36769__$1 = state_36769;
var statearr_36773_36796 = state_36769__$1;
(statearr_36773_36796[(2)] = null);

(statearr_36773_36796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (4))){
var inst_36728 = (state_36769[(2)]);
var state_36769__$1 = state_36769;
var statearr_36774_36797 = state_36769__$1;
(statearr_36774_36797[(2)] = inst_36728);

(statearr_36774_36797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (6))){
var _ = (function (){var statearr_36775 = state_36769;
(statearr_36775[(4)] = cljs.core.cons((9),(state_36769[(4)])));

return statearr_36775;
})();
var inst_36740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36742 = ["_setting/id","root"];
var inst_36743 = (new cljs.core.PersistentVector(null,2,(5),inst_36741,inst_36742,null));
var inst_36744 = [inst_36743];
var inst_36745 = (new cljs.core.PersistentVector(null,1,(5),inst_36740,inst_36744,null));
var inst_36746 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36745);
var state_36769__$1 = state_36769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36769__$1,(10),inst_36746);
} else {
if((state_val_36770 === (3))){
var inst_36767 = (state_36769[(2)]);
var state_36769__$1 = state_36769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36769__$1,inst_36767);
} else {
if((state_val_36770 === (2))){
var _ = (function (){var statearr_36778 = state_36769;
(statearr_36778[(4)] = cljs.core.cons((5),(state_36769[(4)])));

return statearr_36778;
})();
var state_36769__$1 = state_36769;
var statearr_36779_36798 = state_36769__$1;
(statearr_36779_36798[(2)] = null);

(statearr_36779_36798[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (9))){
var _ = (function (){var statearr_36780 = state_36769;
(statearr_36780[(4)] = cljs.core.rest((state_36769[(4)])));

return statearr_36780;
})();
var state_36769__$1 = state_36769;
var ex36776 = (state_36769__$1[(2)]);
var statearr_36781_36799 = state_36769__$1;
(statearr_36781_36799[(5)] = ex36776);


var statearr_36782_36800 = state_36769__$1;
(statearr_36782_36800[(1)] = (8));

(statearr_36782_36800[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (5))){
var _ = (function (){var statearr_36783 = state_36769;
(statearr_36783[(4)] = cljs.core.rest((state_36769[(4)])));

return statearr_36783;
})();
var state_36769__$1 = state_36769;
var ex36777 = (state_36769__$1[(2)]);
var statearr_36784_36801 = state_36769__$1;
(statearr_36784_36801[(5)] = ex36777);


if((ex36777 instanceof Error)){
var statearr_36785_36802 = state_36769__$1;
(statearr_36785_36802[(1)] = (4));

(statearr_36785_36802[(5)] = null);

} else {
throw ex36777;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (10))){
var inst_36748 = (state_36769[(2)]);
var inst_36749 = fluree.db.util.async.throw_err(inst_36748);
var _ = (function (){var statearr_36786 = state_36769;
(statearr_36786[(4)] = cljs.core.rest((state_36769[(4)])));

return statearr_36786;
})();
var state_36769__$1 = state_36769;
var statearr_36787_36803 = state_36769__$1;
(statearr_36787_36803[(2)] = inst_36749);

(statearr_36787_36803[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36770 === (8))){
var inst_36734 = (state_36769[(2)]);
var state_36769__$1 = (function (){var statearr_36788 = state_36769;
(statearr_36788[(7)] = inst_36734);

return statearr_36788;
})();
var statearr_36789_36804 = state_36769__$1;
(statearr_36789_36804[(2)] = null);

(statearr_36789_36804[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__17133__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__17133__auto____0 = (function (){
var statearr_36790 = [null,null,null,null,null,null,null,null];
(statearr_36790[(0)] = fluree$db$query$schema$setting_map_$_state_machine__17133__auto__);

(statearr_36790[(1)] = (1));

return statearr_36790;
});
var fluree$db$query$schema$setting_map_$_state_machine__17133__auto____1 = (function (state_36769){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_36769);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e36791){var ex__17136__auto__ = e36791;
var statearr_36792_36805 = state_36769;
(statearr_36792_36805[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_36769[(4)]))){
var statearr_36793_36806 = state_36769;
(statearr_36793_36806[(1)] = cljs.core.first((state_36769[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__36807 = state_36769;
state_36769 = G__36807;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__17133__auto__ = function(state_36769){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__17133__auto____1.call(this,state_36769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__17133__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__17133__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_36794 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_36794[(6)] = c__17207__auto__);

return statearr_36794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
