// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_27924){
var state_val_27925 = (state_27924[(1)]);
if((state_val_27925 === (7))){
var inst_27919 = (state_27924[(2)]);
var _ = (function (){var statearr_27926 = state_27924;
(statearr_27926[(4)] = cljs.core.rest((state_27924[(4)])));

return statearr_27926;
})();
var state_27924__$1 = state_27924;
var statearr_27927_27949 = state_27924__$1;
(statearr_27927_27949[(2)] = inst_27919);

(statearr_27927_27949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (1))){
var state_27924__$1 = state_27924;
var statearr_27928_27950 = state_27924__$1;
(statearr_27928_27950[(2)] = null);

(statearr_27928_27950[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (4))){
var inst_27881 = (state_27924[(2)]);
var state_27924__$1 = state_27924;
var statearr_27929_27951 = state_27924__$1;
(statearr_27929_27951[(2)] = inst_27881);

(statearr_27929_27951[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (6))){
var inst_27899 = (state_27924[(7)]);
var inst_27906 = (state_27924[(8)]);
var inst_27905 = cljs.core.seq(inst_27899);
var inst_27906__$1 = cljs.core.first(inst_27905);
var inst_27907 = cljs.core.next(inst_27905);
var inst_27908 = cljs.core.not(inst_27906__$1);
var state_27924__$1 = (function (){var statearr_27930 = state_27924;
(statearr_27930[(9)] = inst_27907);

(statearr_27930[(8)] = inst_27906__$1);

return statearr_27930;
})();
if(inst_27908){
var statearr_27931_27952 = state_27924__$1;
(statearr_27931_27952[(1)] = (8));

} else {
var statearr_27932_27953 = state_27924__$1;
(statearr_27932_27953[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (3))){
var inst_27922 = (state_27924[(2)]);
var state_27924__$1 = state_27924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27924__$1,inst_27922);
} else {
if((state_val_27925 === (2))){
var _ = (function (){var statearr_27933 = state_27924;
(statearr_27933[(4)] = cljs.core.cons((5),(state_27924[(4)])));

return statearr_27933;
})();
var inst_27894 = chs;
var inst_27895 = cljs.core.seq(inst_27894);
var inst_27896 = cljs.core.first(inst_27895);
var inst_27897 = cljs.core.next(inst_27895);
var inst_27898 = coll;
var inst_27899 = inst_27894;
var inst_27900 = inst_27898;
var state_27924__$1 = (function (){var statearr_27934 = state_27924;
(statearr_27934[(10)] = inst_27896);

(statearr_27934[(11)] = inst_27900);

(statearr_27934[(7)] = inst_27899);

(statearr_27934[(12)] = inst_27897);

return statearr_27934;
})();
var statearr_27935_27954 = state_27924__$1;
(statearr_27935_27954[(2)] = null);

(statearr_27935_27954[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (11))){
var inst_27907 = (state_27924[(9)]);
var inst_27900 = (state_27924[(11)]);
var inst_27912 = (state_27924[(2)]);
var inst_27913 = fluree.db.util.async.throw_err(inst_27912);
var inst_27914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27900,inst_27913);
var inst_27899 = inst_27907;
var inst_27900__$1 = inst_27914;
var state_27924__$1 = (function (){var statearr_27937 = state_27924;
(statearr_27937[(11)] = inst_27900__$1);

(statearr_27937[(7)] = inst_27899);

return statearr_27937;
})();
var statearr_27938_27955 = state_27924__$1;
(statearr_27938_27955[(2)] = null);

(statearr_27938_27955[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (9))){
var inst_27906 = (state_27924[(8)]);
var state_27924__$1 = state_27924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27924__$1,(11),inst_27906);
} else {
if((state_val_27925 === (5))){
var _ = (function (){var statearr_27939 = state_27924;
(statearr_27939[(4)] = cljs.core.rest((state_27924[(4)])));

return statearr_27939;
})();
var state_27924__$1 = state_27924;
var ex27936 = (state_27924__$1[(2)]);
var statearr_27940_27956 = state_27924__$1;
(statearr_27940_27956[(5)] = ex27936);


var statearr_27941_27957 = state_27924__$1;
(statearr_27941_27957[(1)] = (4));

(statearr_27941_27957[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (10))){
var inst_27917 = (state_27924[(2)]);
var state_27924__$1 = state_27924;
var statearr_27942_27958 = state_27924__$1;
(statearr_27942_27958[(2)] = inst_27917);

(statearr_27942_27958[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27925 === (8))){
var inst_27900 = (state_27924[(11)]);
var state_27924__$1 = state_27924;
var statearr_27943_27959 = state_27924__$1;
(statearr_27943_27959[(2)] = inst_27900);

(statearr_27943_27959[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____0 = (function (){
var statearr_27944 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27944[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__);

(statearr_27944[(1)] = (1));

return statearr_27944;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____1 = (function (state_27924){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_27924);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e27945){var ex__17136__auto__ = e27945;
var statearr_27946_27960 = state_27924;
(statearr_27946_27960[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_27924[(4)]))){
var statearr_27947_27961 = state_27924;
(statearr_27947_27961[(1)] = cljs.core.first((state_27924[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__27962 = state_27924;
state_27924 = G__27962;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__ = function(state_27924){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____1.call(this,state_27924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_27948 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_27948[(6)] = c__17207__auto__);

return statearr_27948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_27988){
var state_val_27989 = (state_27988[(1)]);
if((state_val_27989 === (7))){
var inst_27983 = (state_27988[(2)]);
var _ = (function (){var statearr_27990 = state_27988;
(statearr_27990[(4)] = cljs.core.rest((state_27988[(4)])));

return statearr_27990;
})();
var state_27988__$1 = state_27988;
var statearr_27991_28013 = state_27988__$1;
(statearr_27991_28013[(2)] = inst_27983);

(statearr_27991_28013[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (1))){
var state_27988__$1 = state_27988;
var statearr_27992_28014 = state_27988__$1;
(statearr_27992_28014[(2)] = null);

(statearr_27992_28014[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (4))){
var inst_27963 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_27993_28015 = state_27988__$1;
(statearr_27993_28015[(2)] = inst_27963);

(statearr_27993_28015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (6))){
var state_27988__$1 = state_27988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27988__$1,(8),chan);
} else {
if((state_val_27989 === (3))){
var inst_27986 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27988__$1,inst_27986);
} else {
if((state_val_27989 === (2))){
var _ = (function (){var statearr_27994 = state_27988;
(statearr_27994[(4)] = cljs.core.cons((5),(state_27988[(4)])));

return statearr_27994;
})();
var inst_27969 = coll;
var inst_27970 = inst_27969;
var state_27988__$1 = (function (){var statearr_27995 = state_27988;
(statearr_27995[(7)] = inst_27970);

return statearr_27995;
})();
var statearr_27996_28016 = state_27988__$1;
(statearr_27996_28016[(2)] = null);

(statearr_27996_28016[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (11))){
var inst_27981 = (state_27988[(2)]);
var state_27988__$1 = state_27988;
var statearr_27998_28017 = state_27988__$1;
(statearr_27998_28017[(2)] = inst_27981);

(statearr_27998_28017[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (9))){
var inst_27970 = (state_27988[(7)]);
var state_27988__$1 = state_27988;
var statearr_27999_28018 = state_27988__$1;
(statearr_27999_28018[(2)] = inst_27970);

(statearr_27999_28018[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (5))){
var _ = (function (){var statearr_28000 = state_27988;
(statearr_28000[(4)] = cljs.core.rest((state_27988[(4)])));

return statearr_28000;
})();
var state_27988__$1 = state_27988;
var ex27997 = (state_27988__$1[(2)]);
var statearr_28001_28019 = state_27988__$1;
(statearr_28001_28019[(5)] = ex27997);


var statearr_28002_28020 = state_27988__$1;
(statearr_28002_28020[(1)] = (4));

(statearr_28002_28020[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (10))){
var inst_27974 = (state_27988[(8)]);
var inst_27970 = (state_27988[(7)]);
var inst_27978 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27970,inst_27974);
var inst_27970__$1 = inst_27978;
var state_27988__$1 = (function (){var statearr_28003 = state_27988;
(statearr_28003[(7)] = inst_27970__$1);

return statearr_28003;
})();
var statearr_28004_28021 = state_27988__$1;
(statearr_28004_28021[(2)] = null);

(statearr_28004_28021[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27989 === (8))){
var inst_27974 = (state_27988[(8)]);
var inst_27973 = (state_27988[(2)]);
var inst_27974__$1 = fluree.db.util.async.throw_err(inst_27973);
var inst_27975 = (inst_27974__$1 == null);
var state_27988__$1 = (function (){var statearr_28005 = state_27988;
(statearr_28005[(8)] = inst_27974__$1);

return statearr_28005;
})();
if(cljs.core.truth_(inst_27975)){
var statearr_28006_28022 = state_27988__$1;
(statearr_28006_28022[(1)] = (9));

} else {
var statearr_28007_28023 = state_27988__$1;
(statearr_28007_28023[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____0 = (function (){
var statearr_28008 = [null,null,null,null,null,null,null,null,null];
(statearr_28008[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__);

(statearr_28008[(1)] = (1));

return statearr_28008;
});
var fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____1 = (function (state_27988){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_27988);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e28009){var ex__17136__auto__ = e28009;
var statearr_28010_28024 = state_27988;
(statearr_28010_28024[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_27988[(4)]))){
var statearr_28011_28025 = state_27988;
(statearr_28011_28025[(1)] = cljs.core.first((state_27988[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__28026 = state_27988;
state_27988 = G__28026;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__ = function(state_27988){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____1.call(this,state_27988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__17133__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_28012 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_28012[(6)] = c__17207__auto__);

return statearr_28012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
