// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5754__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5754__auto__)){
var st = temp__5754__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__33436 = cljs.core._EQ_;
var expr__33437 = e.getLastErrorCode();
if(cljs.core.truth_((pred__33436.cljs$core$IFn$_invoke$arity$2 ? pred__33436.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__33437) : pred__33436.call(null,goog.net.ErrorCode.NO_ERROR,expr__33437)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__33436.cljs$core$IFn$_invoke$arity$2 ? pred__33436.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__33437) : pred__33436.call(null,goog.net.ErrorCode.EXCEPTION,expr__33437)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__33436.cljs$core$IFn$_invoke$arity$2 ? pred__33436.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__33437) : pred__33436.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__33437)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__33436.cljs$core$IFn$_invoke$arity$2 ? pred__33436.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__33437) : pred__33436.call(null,goog.net.ErrorCode.ABORT,expr__33437)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__33436.cljs$core$IFn$_invoke$arity$2 ? pred__33436.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__33437) : pred__33436.call(null,goog.net.ErrorCode.TIMEOUT,expr__33437)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__33439 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33439,cljs.core.cst$kw$status,status);
} else {
return G__33439;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__33440 = opts;
var map__33440__$1 = (((((!((map__33440 == null))))?(((((map__33440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33440):map__33440);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33440__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33440__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33440__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33442 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__33442__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33442,headers], 0)):G__33442);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33442__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33442__$1;
}
})();
try{var G__33444_33450 = url;
var G__33445_33451 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33446_33452 = "POST";
var G__33447_33453 = fluree.db.util.json.stringify(message);
var G__33448_33454 = cljs.core.clj__GT_js(headers__$1);
var G__33449_33455 = request_timeout;
goog.net.XhrIo.send(G__33444_33450,G__33445_33451,G__33446_33452,G__33447_33453,G__33448_33454,G__33449_33455);
}catch (e33443){var e_33456 = e33443;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33456);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__33457 = opts;
var map__33457__$1 = (((((!((map__33457 == null))))?(((((map__33457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33457):map__33457);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33457__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33457__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33457__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33457__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33457__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33459 = cljs.core.PersistentArrayMap.EMPTY;
var G__33459__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33459,headers], 0)):G__33459);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33459__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33459__$1;
}
})();
try{var G__33461_33468 = url;
var G__33462_33469 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__33467 = output_format;
var G__33467__$1 = (((G__33467 instanceof cljs.core.Keyword))?G__33467.fqn:null);
switch (G__33467__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33463_33470 = "GET";
var G__33464_33471 = body;
var G__33465_33472 = cljs.core.clj__GT_js(headers__$1);
var G__33466_33473 = request_timeout;
goog.net.XhrIo.send(G__33461_33468,G__33462_33469,G__33463_33470,G__33464_33471,G__33465_33472,G__33466_33473);
}catch (e33460){var e_33475 = e33460;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33475);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__33476 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33476,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__33476;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__17207__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33509){
var state_val_33510 = (state_33509[(1)]);
if((state_val_33510 === (7))){
var inst_33505 = (state_33509[(2)]);
var state_33509__$1 = state_33509;
var statearr_33511_33536 = state_33509__$1;
(statearr_33511_33536[(2)] = inst_33505);

(statearr_33511_33536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (1))){
var state_33509__$1 = state_33509;
var statearr_33512_33537 = state_33509__$1;
(statearr_33512_33537[(2)] = null);

(statearr_33512_33537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (4))){
var inst_33480 = (state_33509[(7)]);
var inst_33480__$1 = (state_33509[(2)]);
var inst_33481 = (inst_33480__$1 == null);
var state_33509__$1 = (function (){var statearr_33513 = state_33509;
(statearr_33513[(7)] = inst_33480__$1);

return statearr_33513;
})();
if(cljs.core.truth_(inst_33481)){
var statearr_33514_33538 = state_33509__$1;
(statearr_33514_33538[(1)] = (5));

} else {
var statearr_33515_33539 = state_33509__$1;
(statearr_33515_33539[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (6))){
var inst_33480 = (state_33509[(7)]);
var inst_33488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33480,(0),null);
var inst_33489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33480,(1),null);
var state_33509__$1 = (function (){var statearr_33516 = state_33509;
(statearr_33516[(8)] = inst_33488);

(statearr_33516[(9)] = inst_33489);

return statearr_33516;
})();
var statearr_33517_33540 = state_33509__$1;
(statearr_33517_33540[(2)] = null);

(statearr_33517_33540[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (3))){
var inst_33507 = (state_33509[(2)]);
var state_33509__$1 = state_33509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33509__$1,inst_33507);
} else {
if((state_val_33510 === (2))){
var state_33509__$1 = state_33509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33509__$1,(4),pub_chan);
} else {
if((state_val_33510 === (11))){
var _ = (function (){var statearr_33519 = state_33509;
(statearr_33519[(4)] = cljs.core.rest((state_33509[(4)])));

return statearr_33519;
})();
var state_33509__$1 = state_33509;
var ex33518 = (state_33509__$1[(2)]);
var statearr_33520_33541 = state_33509__$1;
(statearr_33520_33541[(5)] = ex33518);


if((ex33518 instanceof Error)){
var statearr_33521_33542 = state_33509__$1;
(statearr_33521_33542[(1)] = (10));

(statearr_33521_33542[(5)] = null);

} else {
throw ex33518;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (9))){
var inst_33502 = (state_33509[(2)]);
var state_33509__$1 = (function (){var statearr_33522 = state_33509;
(statearr_33522[(10)] = inst_33502);

return statearr_33522;
})();
var statearr_33523_33543 = state_33509__$1;
(statearr_33523_33543[(2)] = null);

(statearr_33523_33543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (5))){
var inst_33483 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_33509__$1 = state_33509;
var statearr_33524_33544 = state_33509__$1;
(statearr_33524_33544[(2)] = inst_33483);

(statearr_33524_33544[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (10))){
var inst_33489 = (state_33509[(9)]);
var inst_33490 = (state_33509[(2)]);
var inst_33491 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33490,"Websocket send message error:",inst_33490], 0));
var inst_33492 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33489,false);
var state_33509__$1 = (function (){var statearr_33525 = state_33509;
(statearr_33525[(11)] = inst_33491);

return statearr_33525;
})();
var statearr_33526_33545 = state_33509__$1;
(statearr_33526_33545[(2)] = inst_33492);

(statearr_33526_33545[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33510 === (8))){
var inst_33488 = (state_33509[(8)]);
var inst_33489 = (state_33509[(9)]);
var _ = (function (){var statearr_33527 = state_33509;
(statearr_33527[(4)] = cljs.core.cons((11),(state_33509[(4)])));

return statearr_33527;
})();
var inst_33498 = ws.send(inst_33488);
var inst_33499 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33489,true);
var ___$1 = (function (){var statearr_33528 = state_33509;
(statearr_33528[(4)] = cljs.core.rest((state_33509[(4)])));

return statearr_33528;
})();
var state_33509__$1 = (function (){var statearr_33529 = state_33509;
(statearr_33529[(12)] = inst_33498);

return statearr_33529;
})();
var statearr_33530_33546 = state_33509__$1;
(statearr_33530_33546[(2)] = inst_33499);

(statearr_33530_33546[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____0 = (function (){
var statearr_33531 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33531[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__);

(statearr_33531[(1)] = (1));

return statearr_33531;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____1 = (function (state_33509){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33509);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33532){var ex__17136__auto__ = e33532;
var statearr_33533_33547 = state_33509;
(statearr_33533_33547[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33509[(4)]))){
var statearr_33534_33548 = state_33509;
(statearr_33534_33548[(1)] = cljs.core.first((state_33509[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33549 = state_33509;
state_33509 = G__33549;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__ = function(state_33509){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____1.call(this,state_33509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33535 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33535[(6)] = c__17207__auto__);

return statearr_33535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));

return c__17207__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__17207__auto___33588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17208__auto__ = (function (){var switch__17132__auto__ = (function (state_33575){
var state_val_33576 = (state_33575[(1)]);
if((state_val_33576 === (1))){
var inst_33554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33555 = [open_QMARK_,timeout_chan];
var inst_33556 = (new cljs.core.PersistentVector(null,2,(5),inst_33554,inst_33555,null));
var state_33575__$1 = state_33575;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_33575__$1,(2),inst_33556,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_33576 === (2))){
var inst_33558 = (state_33575[(2)]);
var inst_33559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33558,(0),null);
var inst_33560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33558,(1),null);
var inst_33561 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33560,timeout_chan);
var state_33575__$1 = (function (){var statearr_33577 = state_33575;
(statearr_33577[(7)] = inst_33559);

return statearr_33577;
})();
if(inst_33561){
var statearr_33578_33589 = state_33575__$1;
(statearr_33578_33589[(1)] = (3));

} else {
var statearr_33579_33590 = state_33575__$1;
(statearr_33579_33590[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33576 === (3))){
var inst_33563 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_33564 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33565 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_33566 = cljs.core.PersistentHashMap.fromArrays(inst_33564,inst_33565);
var inst_33567 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33563,inst_33566);
var inst_33568 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_33567);
var inst_33569 = fluree.db.util.xhttp.close_websocket(ws);
var state_33575__$1 = (function (){var statearr_33580 = state_33575;
(statearr_33580[(8)] = inst_33568);

return statearr_33580;
})();
var statearr_33581_33591 = state_33575__$1;
(statearr_33581_33591[(2)] = inst_33569);

(statearr_33581_33591[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33576 === (4))){
var inst_33571 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_33575__$1 = state_33575;
var statearr_33582_33592 = state_33575__$1;
(statearr_33582_33592[(2)] = inst_33571);

(statearr_33582_33592[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33576 === (5))){
var inst_33573 = (state_33575[(2)]);
var state_33575__$1 = state_33575;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33575__$1,inst_33573);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____0 = (function (){
var statearr_33583 = [null,null,null,null,null,null,null,null,null];
(statearr_33583[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__);

(statearr_33583[(1)] = (1));

return statearr_33583;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____1 = (function (state_33575){
while(true){
var ret_value__17134__auto__ = (function (){try{while(true){
var result__17135__auto__ = switch__17132__auto__(state_33575);
if(cljs.core.keyword_identical_QMARK_(result__17135__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17135__auto__;
}
break;
}
}catch (e33584){var ex__17136__auto__ = e33584;
var statearr_33585_33593 = state_33575;
(statearr_33585_33593[(2)] = ex__17136__auto__);


if(cljs.core.seq((state_33575[(4)]))){
var statearr_33586_33594 = state_33575;
(statearr_33586_33594[(1)] = cljs.core.first((state_33575[(4)])));

} else {
throw ex__17136__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17134__auto__,cljs.core.cst$kw$recur)){
var G__33595 = state_33575;
state_33575 = G__33595;
continue;
} else {
return ret_value__17134__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__ = function(state_33575){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____1.call(this,state_33575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__17133__auto__;
})()
})();
var state__17209__auto__ = (function (){var statearr_33587 = (f__17208__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17208__auto__.cljs$core$IFn$_invoke$arity$0() : f__17208__auto__.call(null));
(statearr_33587[(6)] = c__17207__auto___33588);

return statearr_33587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17209__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
