// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__42241 = (line + (1));
var G__42242 = (1);
var G__42243 = (counter + (1));
line = G__42241;
col = G__42242;
counter = G__42243;
continue;
} else {
var G__42244 = line;
var G__42245 = (col + (1));
var G__42246 = (counter + (1));
line = G__42244;
col = G__42245;
counter = G__42246;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__42247 = cljs.core.next(chars);
var G__42248 = (n__$1 - (1));
chars = G__42247;
n__$1 = G__42248;
continue;
} else {
var G__42249 = cljs.core.next(chars);
var G__42250 = n__$1;
chars = G__42249;
n__$1 = G__42250;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__42251){
var map__42252 = p__42251;
var map__42252__$1 = (((((!((map__42252 == null))))?(((((map__42252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42252):map__42252);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42252__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42252__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42252__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42252__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__42254_42262 = cljs.core.seq(full_reasons);
var chunk__42255_42263 = null;
var count__42256_42264 = (0);
var i__42257_42265 = (0);
while(true){
if((i__42257_42265 < count__42256_42264)){
var r_42266 = chunk__42255_42263.cljs$core$IIndexed$_nth$arity$2(null,i__42257_42265);
instaparse.failure.print_reason(r_42266);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42267 = seq__42254_42262;
var G__42268 = chunk__42255_42263;
var G__42269 = count__42256_42264;
var G__42270 = (i__42257_42265 + (1));
seq__42254_42262 = G__42267;
chunk__42255_42263 = G__42268;
count__42256_42264 = G__42269;
i__42257_42265 = G__42270;
continue;
} else {
var temp__5754__auto___42271 = cljs.core.seq(seq__42254_42262);
if(temp__5754__auto___42271){
var seq__42254_42272__$1 = temp__5754__auto___42271;
if(cljs.core.chunked_seq_QMARK_(seq__42254_42272__$1)){
var c__4556__auto___42273 = cljs.core.chunk_first(seq__42254_42272__$1);
var G__42274 = cljs.core.chunk_rest(seq__42254_42272__$1);
var G__42275 = c__4556__auto___42273;
var G__42276 = cljs.core.count(c__4556__auto___42273);
var G__42277 = (0);
seq__42254_42262 = G__42274;
chunk__42255_42263 = G__42275;
count__42256_42264 = G__42276;
i__42257_42265 = G__42277;
continue;
} else {
var r_42278 = cljs.core.first(seq__42254_42272__$1);
instaparse.failure.print_reason(r_42278);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42279 = cljs.core.next(seq__42254_42272__$1);
var G__42280 = null;
var G__42281 = (0);
var G__42282 = (0);
seq__42254_42262 = G__42279;
chunk__42255_42263 = G__42280;
count__42256_42264 = G__42281;
i__42257_42265 = G__42282;
continue;
}
} else {
}
}
break;
}

var seq__42258 = cljs.core.seq(partial_reasons);
var chunk__42259 = null;
var count__42260 = (0);
var i__42261 = (0);
while(true){
if((i__42261 < count__42260)){
var r = chunk__42259.cljs$core$IIndexed$_nth$arity$2(null,i__42261);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42283 = seq__42258;
var G__42284 = chunk__42259;
var G__42285 = count__42260;
var G__42286 = (i__42261 + (1));
seq__42258 = G__42283;
chunk__42259 = G__42284;
count__42260 = G__42285;
i__42261 = G__42286;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__42258);
if(temp__5754__auto__){
var seq__42258__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42258__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__42258__$1);
var G__42287 = cljs.core.chunk_rest(seq__42258__$1);
var G__42288 = c__4556__auto__;
var G__42289 = cljs.core.count(c__4556__auto__);
var G__42290 = (0);
seq__42258 = G__42287;
chunk__42259 = G__42288;
count__42260 = G__42289;
i__42261 = G__42290;
continue;
} else {
var r = cljs.core.first(seq__42258__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42291 = cljs.core.next(seq__42258__$1);
var G__42292 = null;
var G__42293 = (0);
var G__42294 = (0);
seq__42258 = G__42291;
chunk__42259 = G__42292;
count__42260 = G__42293;
i__42261 = G__42294;
continue;
}
} else {
return null;
}
}
break;
}
});
