// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_27089){
var state_val_27090 = (state_27089[(1)]);
if((state_val_27090 === (7))){
var inst_27084 = (state_27089[(2)]);
var _ = (function (){var statearr_27091 = state_27089;
(statearr_27091[(4)] = cljs.core.rest((state_27089[(4)])));

return statearr_27091;
})();
var state_27089__$1 = state_27089;
var statearr_27092_27114 = state_27089__$1;
(statearr_27092_27114[(2)] = inst_27084);

(statearr_27092_27114[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (1))){
var state_27089__$1 = state_27089;
var statearr_27093_27115 = state_27089__$1;
(statearr_27093_27115[(2)] = null);

(statearr_27093_27115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (4))){
var inst_27046 = (state_27089[(2)]);
var state_27089__$1 = state_27089;
var statearr_27094_27116 = state_27089__$1;
(statearr_27094_27116[(2)] = inst_27046);

(statearr_27094_27116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (6))){
var inst_27071 = (state_27089[(7)]);
var inst_27064 = (state_27089[(8)]);
var inst_27070 = cljs.core.seq(inst_27064);
var inst_27071__$1 = cljs.core.first(inst_27070);
var inst_27072 = cljs.core.next(inst_27070);
var inst_27073 = cljs.core.not(inst_27071__$1);
var state_27089__$1 = (function (){var statearr_27095 = state_27089;
(statearr_27095[(7)] = inst_27071__$1);

(statearr_27095[(9)] = inst_27072);

return statearr_27095;
})();
if(inst_27073){
var statearr_27096_27117 = state_27089__$1;
(statearr_27096_27117[(1)] = (8));

} else {
var statearr_27097_27118 = state_27089__$1;
(statearr_27097_27118[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (3))){
var inst_27087 = (state_27089[(2)]);
var state_27089__$1 = state_27089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27089__$1,inst_27087);
} else {
if((state_val_27090 === (2))){
var _ = (function (){var statearr_27098 = state_27089;
(statearr_27098[(4)] = cljs.core.cons((5),(state_27089[(4)])));

return statearr_27098;
})();
var inst_27059 = chs;
var inst_27060 = cljs.core.seq(inst_27059);
var inst_27061 = cljs.core.first(inst_27060);
var inst_27062 = cljs.core.next(inst_27060);
var inst_27063 = coll;
var inst_27064 = inst_27059;
var inst_27065 = inst_27063;
var state_27089__$1 = (function (){var statearr_27099 = state_27089;
(statearr_27099[(10)] = inst_27062);

(statearr_27099[(11)] = inst_27061);

(statearr_27099[(12)] = inst_27065);

(statearr_27099[(8)] = inst_27064);

return statearr_27099;
})();
var statearr_27100_27119 = state_27089__$1;
(statearr_27100_27119[(2)] = null);

(statearr_27100_27119[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (11))){
var inst_27065 = (state_27089[(12)]);
var inst_27072 = (state_27089[(9)]);
var inst_27077 = (state_27089[(2)]);
var inst_27078 = fluree.db.util.async.throw_err(inst_27077);
var inst_27079 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27065,inst_27078);
var inst_27064 = inst_27072;
var inst_27065__$1 = inst_27079;
var state_27089__$1 = (function (){var statearr_27102 = state_27089;
(statearr_27102[(12)] = inst_27065__$1);

(statearr_27102[(8)] = inst_27064);

return statearr_27102;
})();
var statearr_27103_27120 = state_27089__$1;
(statearr_27103_27120[(2)] = null);

(statearr_27103_27120[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (9))){
var inst_27071 = (state_27089[(7)]);
var state_27089__$1 = state_27089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27089__$1,(11),inst_27071);
} else {
if((state_val_27090 === (5))){
var _ = (function (){var statearr_27104 = state_27089;
(statearr_27104[(4)] = cljs.core.rest((state_27089[(4)])));

return statearr_27104;
})();
var state_27089__$1 = state_27089;
var ex27101 = (state_27089__$1[(2)]);
var statearr_27105_27121 = state_27089__$1;
(statearr_27105_27121[(5)] = ex27101);


var statearr_27106_27122 = state_27089__$1;
(statearr_27106_27122[(1)] = (4));

(statearr_27106_27122[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (10))){
var inst_27082 = (state_27089[(2)]);
var state_27089__$1 = state_27089;
var statearr_27107_27123 = state_27089__$1;
(statearr_27107_27123[(2)] = inst_27082);

(statearr_27107_27123[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27090 === (8))){
var inst_27065 = (state_27089[(12)]);
var state_27089__$1 = state_27089;
var statearr_27108_27124 = state_27089__$1;
(statearr_27108_27124[(2)] = inst_27065);

(statearr_27108_27124[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_27109 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27109[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__);

(statearr_27109[(1)] = (1));

return statearr_27109;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____1 = (function (state_27089){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_27089);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e27110){var ex__16304__auto__ = e27110;
var statearr_27111_27125 = state_27089;
(statearr_27111_27125[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_27089[(4)]))){
var statearr_27112_27126 = state_27089;
(statearr_27112_27126[(1)] = cljs.core.first((state_27089[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__27127 = state_27089;
state_27089 = G__27127;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__ = function(state_27089){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____1.call(this,state_27089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_27113 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_27113[(6)] = c__16375__auto__);

return statearr_27113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_27153){
var state_val_27154 = (state_27153[(1)]);
if((state_val_27154 === (7))){
var inst_27148 = (state_27153[(2)]);
var _ = (function (){var statearr_27155 = state_27153;
(statearr_27155[(4)] = cljs.core.rest((state_27153[(4)])));

return statearr_27155;
})();
var state_27153__$1 = state_27153;
var statearr_27156_27178 = state_27153__$1;
(statearr_27156_27178[(2)] = inst_27148);

(statearr_27156_27178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (1))){
var state_27153__$1 = state_27153;
var statearr_27157_27179 = state_27153__$1;
(statearr_27157_27179[(2)] = null);

(statearr_27157_27179[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (4))){
var inst_27128 = (state_27153[(2)]);
var state_27153__$1 = state_27153;
var statearr_27158_27180 = state_27153__$1;
(statearr_27158_27180[(2)] = inst_27128);

(statearr_27158_27180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (6))){
var state_27153__$1 = state_27153;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27153__$1,(8),chan);
} else {
if((state_val_27154 === (3))){
var inst_27151 = (state_27153[(2)]);
var state_27153__$1 = state_27153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27153__$1,inst_27151);
} else {
if((state_val_27154 === (2))){
var _ = (function (){var statearr_27159 = state_27153;
(statearr_27159[(4)] = cljs.core.cons((5),(state_27153[(4)])));

return statearr_27159;
})();
var inst_27134 = coll;
var inst_27135 = inst_27134;
var state_27153__$1 = (function (){var statearr_27160 = state_27153;
(statearr_27160[(7)] = inst_27135);

return statearr_27160;
})();
var statearr_27161_27181 = state_27153__$1;
(statearr_27161_27181[(2)] = null);

(statearr_27161_27181[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (11))){
var inst_27146 = (state_27153[(2)]);
var state_27153__$1 = state_27153;
var statearr_27163_27182 = state_27153__$1;
(statearr_27163_27182[(2)] = inst_27146);

(statearr_27163_27182[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (9))){
var inst_27135 = (state_27153[(7)]);
var state_27153__$1 = state_27153;
var statearr_27164_27183 = state_27153__$1;
(statearr_27164_27183[(2)] = inst_27135);

(statearr_27164_27183[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (5))){
var _ = (function (){var statearr_27165 = state_27153;
(statearr_27165[(4)] = cljs.core.rest((state_27153[(4)])));

return statearr_27165;
})();
var state_27153__$1 = state_27153;
var ex27162 = (state_27153__$1[(2)]);
var statearr_27166_27184 = state_27153__$1;
(statearr_27166_27184[(5)] = ex27162);


var statearr_27167_27185 = state_27153__$1;
(statearr_27167_27185[(1)] = (4));

(statearr_27167_27185[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (10))){
var inst_27139 = (state_27153[(8)]);
var inst_27135 = (state_27153[(7)]);
var inst_27143 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27135,inst_27139);
var inst_27135__$1 = inst_27143;
var state_27153__$1 = (function (){var statearr_27168 = state_27153;
(statearr_27168[(7)] = inst_27135__$1);

return statearr_27168;
})();
var statearr_27169_27186 = state_27153__$1;
(statearr_27169_27186[(2)] = null);

(statearr_27169_27186[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27154 === (8))){
var inst_27139 = (state_27153[(8)]);
var inst_27138 = (state_27153[(2)]);
var inst_27139__$1 = fluree.db.util.async.throw_err(inst_27138);
var inst_27140 = (inst_27139__$1 == null);
var state_27153__$1 = (function (){var statearr_27170 = state_27153;
(statearr_27170[(8)] = inst_27139__$1);

return statearr_27170;
})();
if(cljs.core.truth_(inst_27140)){
var statearr_27171_27187 = state_27153__$1;
(statearr_27171_27187[(1)] = (9));

} else {
var statearr_27172_27188 = state_27153__$1;
(statearr_27172_27188[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_27173 = [null,null,null,null,null,null,null,null,null];
(statearr_27173[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__);

(statearr_27173[(1)] = (1));

return statearr_27173;
});
var fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____1 = (function (state_27153){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_27153);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e27174){var ex__16304__auto__ = e27174;
var statearr_27175_27189 = state_27153;
(statearr_27175_27189[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_27153[(4)]))){
var statearr_27176_27190 = state_27153;
(statearr_27176_27190[(1)] = cljs.core.first((state_27153[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__27191 = state_27153;
state_27153 = G__27191;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__ = function(state_27153){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____1.call(this,state_27153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__16301__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_27177 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_27177[(6)] = c__16375__auto__);

return statearr_27177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
