// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__30722 = arguments.length;
switch (G__30722) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__30723 = options;
var map__30723__$1 = (((((!((map__30723 == null))))?(((((map__30723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30723.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30723):map__30723);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30723__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__30751_30772 = cljs.core.seq(x__$1);
var chunk__30752_30773 = null;
var count__30753_30774 = (0);
var i__30754_30775 = (0);
while(true){
if((i__30754_30775 < count__30753_30774)){
var vec__30761_30776 = chunk__30752_30773.cljs$core$IIndexed$_nth$arity$2(null,i__30754_30775);
var k_30777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30761_30776,(0),null);
var v_30778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30761_30776,(1),null);
goog.object.set(m,keyfn(k_30777),fluree$db$util$json$thisfn(v_30778));


var G__30779 = seq__30751_30772;
var G__30780 = chunk__30752_30773;
var G__30781 = count__30753_30774;
var G__30782 = (i__30754_30775 + (1));
seq__30751_30772 = G__30779;
chunk__30752_30773 = G__30780;
count__30753_30774 = G__30781;
i__30754_30775 = G__30782;
continue;
} else {
var temp__5735__auto___30783 = cljs.core.seq(seq__30751_30772);
if(temp__5735__auto___30783){
var seq__30751_30784__$1 = temp__5735__auto___30783;
if(cljs.core.chunked_seq_QMARK_(seq__30751_30784__$1)){
var c__4556__auto___30785 = cljs.core.chunk_first(seq__30751_30784__$1);
var G__30786 = cljs.core.chunk_rest(seq__30751_30784__$1);
var G__30787 = c__4556__auto___30785;
var G__30788 = cljs.core.count(c__4556__auto___30785);
var G__30789 = (0);
seq__30751_30772 = G__30786;
chunk__30752_30773 = G__30787;
count__30753_30774 = G__30788;
i__30754_30775 = G__30789;
continue;
} else {
var vec__30764_30790 = cljs.core.first(seq__30751_30784__$1);
var k_30791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30764_30790,(0),null);
var v_30792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30764_30790,(1),null);
goog.object.set(m,keyfn(k_30791),fluree$db$util$json$thisfn(v_30792));


var G__30793 = cljs.core.next(seq__30751_30784__$1);
var G__30794 = null;
var G__30795 = (0);
var G__30796 = (0);
seq__30751_30772 = G__30793;
chunk__30752_30773 = G__30794;
count__30753_30774 = G__30795;
i__30754_30775 = G__30796;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__30767_30797 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__30768_30798 = null;
var count__30769_30799 = (0);
var i__30770_30800 = (0);
while(true){
if((i__30770_30800 < count__30769_30799)){
var x_30801__$2 = chunk__30768_30798.cljs$core$IIndexed$_nth$arity$2(null,i__30770_30800);
arr.push(x_30801__$2);


var G__30802 = seq__30767_30797;
var G__30803 = chunk__30768_30798;
var G__30804 = count__30769_30799;
var G__30805 = (i__30770_30800 + (1));
seq__30767_30797 = G__30802;
chunk__30768_30798 = G__30803;
count__30769_30799 = G__30804;
i__30770_30800 = G__30805;
continue;
} else {
var temp__5735__auto___30806 = cljs.core.seq(seq__30767_30797);
if(temp__5735__auto___30806){
var seq__30767_30807__$1 = temp__5735__auto___30806;
if(cljs.core.chunked_seq_QMARK_(seq__30767_30807__$1)){
var c__4556__auto___30808 = cljs.core.chunk_first(seq__30767_30807__$1);
var G__30809 = cljs.core.chunk_rest(seq__30767_30807__$1);
var G__30810 = c__4556__auto___30808;
var G__30811 = cljs.core.count(c__4556__auto___30808);
var G__30812 = (0);
seq__30767_30797 = G__30809;
chunk__30768_30798 = G__30810;
count__30769_30799 = G__30811;
i__30770_30800 = G__30812;
continue;
} else {
var x_30813__$2 = cljs.core.first(seq__30767_30807__$1);
arr.push(x_30813__$2);


var G__30814 = cljs.core.next(seq__30767_30807__$1);
var G__30815 = null;
var G__30816 = (0);
var G__30817 = (0);
seq__30767_30797 = G__30814;
chunk__30768_30798 = G__30815;
count__30769_30799 = G__30816;
i__30770_30800 = G__30817;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30818_SHARP_){
var G__30821 = (depth - (1));
var G__30822 = p1__30818_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__30821,G__30822) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__30821,G__30822));
}),coordinates))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__30823 = cljs.core.get_global_hierarchy;
return (fexpr__30823.cljs$core$IFn$_invoke$arity$0 ? fexpr__30823.cljs$core$IFn$_invoke$arity$0() : fexpr__30823.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4115__auto__ = (function (){var or__4126__auto__ = (function (){var G__30829 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__30829) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__30829));
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4115__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__30830_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__30830_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
