// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__2666){
var vec__2667 = p__2666;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2667,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2667,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__2670 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2670,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2670,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2670,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2670,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2670,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__2673 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2673,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2673,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2673,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2673,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2673,(4),null);
var vec__2676 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2676,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2676,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2676,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2676,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2676,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__2679 = segmap;
var map__2679__$1 = (((((!((map__2679 == null))))?(((((map__2679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__2679):map__2679);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2679__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2679__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2679__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2679__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2679__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__2682 = arguments.length;
switch (G__2682) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__2686 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__2690 = cljs.core.next(segs__$1);
var G__2691 = nrelseg;
var G__2692 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__2690;
relseg__$1 = G__2691;
result__$1 = G__2692;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2686,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2686,(1),null);
var G__2693 = (gline + (1));
var G__2694 = cljs.core.next(lines__$1);
var G__2695 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__2696 = result__$1;
gline = G__2693;
lines__$1 = G__2694;
relseg = G__2695;
result = G__2696;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__2698 = segmap;
var map__2698__$1 = (((((!((map__2698 == null))))?(((((map__2698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__2698):map__2698);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2698__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2698__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2698__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2698__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__2698__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__2697_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__2697_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__2701 = arguments.length;
switch (G__2701) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__2705 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__2709 = cljs.core.next(segs__$1);
var G__2710 = nrelseg;
var G__2711 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__2709;
relseg__$1 = G__2710;
result__$1 = G__2711;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2705,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2705,(1),null);
var G__2712 = (gline + (1));
var G__2713 = cljs.core.next(lines__$1);
var G__2714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__2715 = result__$1;
gline = G__2712;
lines__$1 = G__2713;
relseg = G__2714;
result = G__2715;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__2716){
var vec__2717 = p__2716;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2717,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2717,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2717,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2717,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2717,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__2720){
var vec__2721 = p__2720;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2721,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2721,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2721,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2721,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2721,(4),null);
var seg = vec__2721;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__2724){
var vec__2725 = p__2724;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2725,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2725,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2725,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2725,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2725,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__2731 = cljs.core.seq(infos);
var chunk__2732 = null;
var count__2733 = (0);
var i__2734 = (0);
while(true){
if((i__2734 < count__2733)){
var info = chunk__2732.cljs$core$IIndexed$_nth$arity$2(null,i__2734);
var segv_3085 = info__GT_segv(info,source_idx,line,col);
var gline_3086 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_3087 = cljs.core.count(cljs.core.deref(lines));
if((gline_3086 > (lc_3087 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__2731,chunk__2732,count__2733,i__2734,segv_3085,gline_3086,lc_3087,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_3086 - (lc_3087 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_3085], null));
});})(seq__2731,chunk__2732,count__2733,i__2734,segv_3085,gline_3086,lc_3087,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__2731,chunk__2732,count__2733,i__2734,segv_3085,gline_3086,lc_3087,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3086], null),cljs.core.conj,segv_3085);
});})(seq__2731,chunk__2732,count__2733,i__2734,segv_3085,gline_3086,lc_3087,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__3088 = seq__2731;
var G__3089 = chunk__2732;
var G__3090 = count__2733;
var G__3091 = (i__2734 + (1));
seq__2731 = G__3088;
chunk__2732 = G__3089;
count__2733 = G__3090;
i__2734 = G__3091;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__2731);
if(temp__5735__auto__){
var seq__2731__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__2731__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__2731__$1);
var G__3092 = cljs.core.chunk_rest(seq__2731__$1);
var G__3093 = c__4556__auto__;
var G__3094 = cljs.core.count(c__4556__auto__);
var G__3095 = (0);
seq__2731 = G__3092;
chunk__2732 = G__3093;
count__2733 = G__3094;
i__2734 = G__3095;
continue;
} else {
var info = cljs.core.first(seq__2731__$1);
var segv_3096 = info__GT_segv(info,source_idx,line,col);
var gline_3097 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_3098 = cljs.core.count(cljs.core.deref(lines));
if((gline_3097 > (lc_3098 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__2731,chunk__2732,count__2733,i__2734,segv_3096,gline_3097,lc_3098,info,seq__2731__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_3097 - (lc_3098 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_3096], null));
});})(seq__2731,chunk__2732,count__2733,i__2734,segv_3096,gline_3097,lc_3098,info,seq__2731__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__2731,chunk__2732,count__2733,i__2734,segv_3096,gline_3097,lc_3098,info,seq__2731__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3097], null),cljs.core.conj,segv_3096);
});})(seq__2731,chunk__2732,count__2733,i__2734,segv_3096,gline_3097,lc_3098,info,seq__2731__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__3099 = cljs.core.next(seq__2731__$1);
var G__3100 = null;
var G__3101 = (0);
var G__3102 = (0);
seq__2731 = G__3099;
chunk__2732 = G__3100;
count__2733 = G__3101;
i__2734 = G__3102;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__2735_3103 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__2736_3104 = null;
var count__2737_3105 = (0);
var i__2738_3106 = (0);
while(true){
if((i__2738_3106 < count__2737_3105)){
var vec__2911_3107 = chunk__2736_3104.cljs$core$IIndexed$_nth$arity$2(null,i__2738_3106);
var source_idx_3108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2911_3107,(0),null);
var vec__2914_3109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2911_3107,(1),null);
var __3110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2914_3109,(0),null);
var lines_3111__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2914_3109,(1),null);
var seq__2917_3112 = cljs.core.seq(lines_3111__$1);
var chunk__2918_3113 = null;
var count__2919_3114 = (0);
var i__2920_3115 = (0);
while(true){
if((i__2920_3115 < count__2919_3114)){
var vec__2959_3116 = chunk__2918_3113.cljs$core$IIndexed$_nth$arity$2(null,i__2920_3115);
var line_3117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2959_3116,(0),null);
var cols_3118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2959_3116,(1),null);
var seq__2962_3119 = cljs.core.seq(cols_3118);
var chunk__2963_3120 = null;
var count__2964_3121 = (0);
var i__2965_3122 = (0);
while(true){
if((i__2965_3122 < count__2964_3121)){
var vec__2972_3123 = chunk__2963_3120.cljs$core$IIndexed$_nth$arity$2(null,i__2965_3122);
var col_3124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2972_3123,(0),null);
var infos_3125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2972_3123,(1),null);
encode_cols(infos_3125,source_idx_3108,line_3117,col_3124);


var G__3126 = seq__2962_3119;
var G__3127 = chunk__2963_3120;
var G__3128 = count__2964_3121;
var G__3129 = (i__2965_3122 + (1));
seq__2962_3119 = G__3126;
chunk__2963_3120 = G__3127;
count__2964_3121 = G__3128;
i__2965_3122 = G__3129;
continue;
} else {
var temp__5735__auto___3130 = cljs.core.seq(seq__2962_3119);
if(temp__5735__auto___3130){
var seq__2962_3131__$1 = temp__5735__auto___3130;
if(cljs.core.chunked_seq_QMARK_(seq__2962_3131__$1)){
var c__4556__auto___3132 = cljs.core.chunk_first(seq__2962_3131__$1);
var G__3133 = cljs.core.chunk_rest(seq__2962_3131__$1);
var G__3134 = c__4556__auto___3132;
var G__3135 = cljs.core.count(c__4556__auto___3132);
var G__3136 = (0);
seq__2962_3119 = G__3133;
chunk__2963_3120 = G__3134;
count__2964_3121 = G__3135;
i__2965_3122 = G__3136;
continue;
} else {
var vec__2975_3137 = cljs.core.first(seq__2962_3131__$1);
var col_3138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2975_3137,(0),null);
var infos_3139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2975_3137,(1),null);
encode_cols(infos_3139,source_idx_3108,line_3117,col_3138);


var G__3140 = cljs.core.next(seq__2962_3131__$1);
var G__3141 = null;
var G__3142 = (0);
var G__3143 = (0);
seq__2962_3119 = G__3140;
chunk__2963_3120 = G__3141;
count__2964_3121 = G__3142;
i__2965_3122 = G__3143;
continue;
}
} else {
}
}
break;
}


var G__3144 = seq__2917_3112;
var G__3145 = chunk__2918_3113;
var G__3146 = count__2919_3114;
var G__3147 = (i__2920_3115 + (1));
seq__2917_3112 = G__3144;
chunk__2918_3113 = G__3145;
count__2919_3114 = G__3146;
i__2920_3115 = G__3147;
continue;
} else {
var temp__5735__auto___3148 = cljs.core.seq(seq__2917_3112);
if(temp__5735__auto___3148){
var seq__2917_3149__$1 = temp__5735__auto___3148;
if(cljs.core.chunked_seq_QMARK_(seq__2917_3149__$1)){
var c__4556__auto___3150 = cljs.core.chunk_first(seq__2917_3149__$1);
var G__3151 = cljs.core.chunk_rest(seq__2917_3149__$1);
var G__3152 = c__4556__auto___3150;
var G__3153 = cljs.core.count(c__4556__auto___3150);
var G__3154 = (0);
seq__2917_3112 = G__3151;
chunk__2918_3113 = G__3152;
count__2919_3114 = G__3153;
i__2920_3115 = G__3154;
continue;
} else {
var vec__2978_3155 = cljs.core.first(seq__2917_3149__$1);
var line_3156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2978_3155,(0),null);
var cols_3157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2978_3155,(1),null);
var seq__2981_3158 = cljs.core.seq(cols_3157);
var chunk__2982_3159 = null;
var count__2983_3160 = (0);
var i__2984_3161 = (0);
while(true){
if((i__2984_3161 < count__2983_3160)){
var vec__2991_3162 = chunk__2982_3159.cljs$core$IIndexed$_nth$arity$2(null,i__2984_3161);
var col_3163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2991_3162,(0),null);
var infos_3164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2991_3162,(1),null);
encode_cols(infos_3164,source_idx_3108,line_3156,col_3163);


var G__3165 = seq__2981_3158;
var G__3166 = chunk__2982_3159;
var G__3167 = count__2983_3160;
var G__3168 = (i__2984_3161 + (1));
seq__2981_3158 = G__3165;
chunk__2982_3159 = G__3166;
count__2983_3160 = G__3167;
i__2984_3161 = G__3168;
continue;
} else {
var temp__5735__auto___3169__$1 = cljs.core.seq(seq__2981_3158);
if(temp__5735__auto___3169__$1){
var seq__2981_3170__$1 = temp__5735__auto___3169__$1;
if(cljs.core.chunked_seq_QMARK_(seq__2981_3170__$1)){
var c__4556__auto___3171 = cljs.core.chunk_first(seq__2981_3170__$1);
var G__3172 = cljs.core.chunk_rest(seq__2981_3170__$1);
var G__3173 = c__4556__auto___3171;
var G__3174 = cljs.core.count(c__4556__auto___3171);
var G__3175 = (0);
seq__2981_3158 = G__3172;
chunk__2982_3159 = G__3173;
count__2983_3160 = G__3174;
i__2984_3161 = G__3175;
continue;
} else {
var vec__2994_3176 = cljs.core.first(seq__2981_3170__$1);
var col_3177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2994_3176,(0),null);
var infos_3178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2994_3176,(1),null);
encode_cols(infos_3178,source_idx_3108,line_3156,col_3177);


var G__3179 = cljs.core.next(seq__2981_3170__$1);
var G__3180 = null;
var G__3181 = (0);
var G__3182 = (0);
seq__2981_3158 = G__3179;
chunk__2982_3159 = G__3180;
count__2983_3160 = G__3181;
i__2984_3161 = G__3182;
continue;
}
} else {
}
}
break;
}


var G__3183 = cljs.core.next(seq__2917_3149__$1);
var G__3184 = null;
var G__3185 = (0);
var G__3186 = (0);
seq__2917_3112 = G__3183;
chunk__2918_3113 = G__3184;
count__2919_3114 = G__3185;
i__2920_3115 = G__3186;
continue;
}
} else {
}
}
break;
}


var G__3187 = seq__2735_3103;
var G__3188 = chunk__2736_3104;
var G__3189 = count__2737_3105;
var G__3190 = (i__2738_3106 + (1));
seq__2735_3103 = G__3187;
chunk__2736_3104 = G__3188;
count__2737_3105 = G__3189;
i__2738_3106 = G__3190;
continue;
} else {
var temp__5735__auto___3191 = cljs.core.seq(seq__2735_3103);
if(temp__5735__auto___3191){
var seq__2735_3192__$1 = temp__5735__auto___3191;
if(cljs.core.chunked_seq_QMARK_(seq__2735_3192__$1)){
var c__4556__auto___3193 = cljs.core.chunk_first(seq__2735_3192__$1);
var G__3194 = cljs.core.chunk_rest(seq__2735_3192__$1);
var G__3195 = c__4556__auto___3193;
var G__3196 = cljs.core.count(c__4556__auto___3193);
var G__3197 = (0);
seq__2735_3103 = G__3194;
chunk__2736_3104 = G__3195;
count__2737_3105 = G__3196;
i__2738_3106 = G__3197;
continue;
} else {
var vec__2997_3198 = cljs.core.first(seq__2735_3192__$1);
var source_idx_3199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2997_3198,(0),null);
var vec__3000_3200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2997_3198,(1),null);
var __3201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3000_3200,(0),null);
var lines_3202__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3000_3200,(1),null);
var seq__3003_3203 = cljs.core.seq(lines_3202__$1);
var chunk__3004_3204 = null;
var count__3005_3205 = (0);
var i__3006_3206 = (0);
while(true){
if((i__3006_3206 < count__3005_3205)){
var vec__3045_3207 = chunk__3004_3204.cljs$core$IIndexed$_nth$arity$2(null,i__3006_3206);
var line_3208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3045_3207,(0),null);
var cols_3209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3045_3207,(1),null);
var seq__3048_3210 = cljs.core.seq(cols_3209);
var chunk__3049_3211 = null;
var count__3050_3212 = (0);
var i__3051_3213 = (0);
while(true){
if((i__3051_3213 < count__3050_3212)){
var vec__3058_3214 = chunk__3049_3211.cljs$core$IIndexed$_nth$arity$2(null,i__3051_3213);
var col_3215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3058_3214,(0),null);
var infos_3216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3058_3214,(1),null);
encode_cols(infos_3216,source_idx_3199,line_3208,col_3215);


var G__3217 = seq__3048_3210;
var G__3218 = chunk__3049_3211;
var G__3219 = count__3050_3212;
var G__3220 = (i__3051_3213 + (1));
seq__3048_3210 = G__3217;
chunk__3049_3211 = G__3218;
count__3050_3212 = G__3219;
i__3051_3213 = G__3220;
continue;
} else {
var temp__5735__auto___3221__$1 = cljs.core.seq(seq__3048_3210);
if(temp__5735__auto___3221__$1){
var seq__3048_3222__$1 = temp__5735__auto___3221__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3048_3222__$1)){
var c__4556__auto___3223 = cljs.core.chunk_first(seq__3048_3222__$1);
var G__3224 = cljs.core.chunk_rest(seq__3048_3222__$1);
var G__3225 = c__4556__auto___3223;
var G__3226 = cljs.core.count(c__4556__auto___3223);
var G__3227 = (0);
seq__3048_3210 = G__3224;
chunk__3049_3211 = G__3225;
count__3050_3212 = G__3226;
i__3051_3213 = G__3227;
continue;
} else {
var vec__3061_3228 = cljs.core.first(seq__3048_3222__$1);
var col_3229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3061_3228,(0),null);
var infos_3230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3061_3228,(1),null);
encode_cols(infos_3230,source_idx_3199,line_3208,col_3229);


var G__3231 = cljs.core.next(seq__3048_3222__$1);
var G__3232 = null;
var G__3233 = (0);
var G__3234 = (0);
seq__3048_3210 = G__3231;
chunk__3049_3211 = G__3232;
count__3050_3212 = G__3233;
i__3051_3213 = G__3234;
continue;
}
} else {
}
}
break;
}


var G__3235 = seq__3003_3203;
var G__3236 = chunk__3004_3204;
var G__3237 = count__3005_3205;
var G__3238 = (i__3006_3206 + (1));
seq__3003_3203 = G__3235;
chunk__3004_3204 = G__3236;
count__3005_3205 = G__3237;
i__3006_3206 = G__3238;
continue;
} else {
var temp__5735__auto___3239__$1 = cljs.core.seq(seq__3003_3203);
if(temp__5735__auto___3239__$1){
var seq__3003_3240__$1 = temp__5735__auto___3239__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3003_3240__$1)){
var c__4556__auto___3241 = cljs.core.chunk_first(seq__3003_3240__$1);
var G__3242 = cljs.core.chunk_rest(seq__3003_3240__$1);
var G__3243 = c__4556__auto___3241;
var G__3244 = cljs.core.count(c__4556__auto___3241);
var G__3245 = (0);
seq__3003_3203 = G__3242;
chunk__3004_3204 = G__3243;
count__3005_3205 = G__3244;
i__3006_3206 = G__3245;
continue;
} else {
var vec__3064_3246 = cljs.core.first(seq__3003_3240__$1);
var line_3247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3064_3246,(0),null);
var cols_3248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3064_3246,(1),null);
var seq__3067_3249 = cljs.core.seq(cols_3248);
var chunk__3068_3250 = null;
var count__3069_3251 = (0);
var i__3070_3252 = (0);
while(true){
if((i__3070_3252 < count__3069_3251)){
var vec__3077_3253 = chunk__3068_3250.cljs$core$IIndexed$_nth$arity$2(null,i__3070_3252);
var col_3254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3077_3253,(0),null);
var infos_3255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3077_3253,(1),null);
encode_cols(infos_3255,source_idx_3199,line_3247,col_3254);


var G__3256 = seq__3067_3249;
var G__3257 = chunk__3068_3250;
var G__3258 = count__3069_3251;
var G__3259 = (i__3070_3252 + (1));
seq__3067_3249 = G__3256;
chunk__3068_3250 = G__3257;
count__3069_3251 = G__3258;
i__3070_3252 = G__3259;
continue;
} else {
var temp__5735__auto___3260__$2 = cljs.core.seq(seq__3067_3249);
if(temp__5735__auto___3260__$2){
var seq__3067_3261__$1 = temp__5735__auto___3260__$2;
if(cljs.core.chunked_seq_QMARK_(seq__3067_3261__$1)){
var c__4556__auto___3262 = cljs.core.chunk_first(seq__3067_3261__$1);
var G__3263 = cljs.core.chunk_rest(seq__3067_3261__$1);
var G__3264 = c__4556__auto___3262;
var G__3265 = cljs.core.count(c__4556__auto___3262);
var G__3266 = (0);
seq__3067_3249 = G__3263;
chunk__3068_3250 = G__3264;
count__3069_3251 = G__3265;
i__3070_3252 = G__3266;
continue;
} else {
var vec__3080_3267 = cljs.core.first(seq__3067_3261__$1);
var col_3268 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3080_3267,(0),null);
var infos_3269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3080_3267,(1),null);
encode_cols(infos_3269,source_idx_3199,line_3247,col_3268);


var G__3270 = cljs.core.next(seq__3067_3261__$1);
var G__3271 = null;
var G__3272 = (0);
var G__3273 = (0);
seq__3067_3249 = G__3270;
chunk__3068_3250 = G__3271;
count__3069_3251 = G__3272;
i__3070_3252 = G__3273;
continue;
}
} else {
}
}
break;
}


var G__3274 = cljs.core.next(seq__3003_3240__$1);
var G__3275 = null;
var G__3276 = (0);
var G__3277 = (0);
seq__3003_3203 = G__3274;
chunk__3004_3204 = G__3275;
count__3005_3205 = G__3276;
i__3006_3206 = G__3277;
continue;
}
} else {
}
}
break;
}


var G__3278 = cljs.core.next(seq__2735_3192__$1);
var G__3279 = null;
var G__3280 = (0);
var G__3281 = (0);
seq__2735_3103 = G__3278;
chunk__2736_3104 = G__3279;
count__2737_3105 = G__3280;
i__2738_3106 = G__3281;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__3083 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__2728_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__2728_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__2729_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__2729_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__2730_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__2730_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__3084 = G__3083;
goog.object.set(G__3084,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__3084;
} else {
return G__3083;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__3282 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3282,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3282,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__3285 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3285,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3285,(1),null);
var G__3291 = cljs.core.next(col_map_seq);
var G__3292 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__3285,col,infos,vec__3282,line,col_map){
return (function (v,p__3288){
var map__3289 = p__3288;
var map__3289__$1 = (((((!((map__3289 == null))))?(((((map__3289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3289):map__3289);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3289__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3289__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__3285,col,infos,vec__3282,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__3291;
new_cols = G__3292;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__3293 = cljs.core.next(line_map_seq);
var G__3294 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__3293;
new_lines = G__3294;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__3295_3567 = cljs.core.seq(reverse_map);
var chunk__3296_3568 = null;
var count__3297_3569 = (0);
var i__3298_3570 = (0);
while(true){
if((i__3298_3570 < count__3297_3569)){
var vec__3433_3571 = chunk__3296_3568.cljs$core$IIndexed$_nth$arity$2(null,i__3298_3570);
var line_3572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3433_3571,(0),null);
var columns_3573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3433_3571,(1),null);
var seq__3436_3574 = cljs.core.seq(columns_3573);
var chunk__3437_3575 = null;
var count__3438_3576 = (0);
var i__3439_3577 = (0);
while(true){
if((i__3439_3577 < count__3438_3576)){
var vec__3470_3578 = chunk__3437_3575.cljs$core$IIndexed$_nth$arity$2(null,i__3439_3577);
var column_3579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3470_3578,(0),null);
var column_info_3580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3470_3578,(1),null);
var seq__3473_3581 = cljs.core.seq(column_info_3580);
var chunk__3474_3582 = null;
var count__3475_3583 = (0);
var i__3476_3584 = (0);
while(true){
if((i__3476_3584 < count__3475_3583)){
var map__3481_3585 = chunk__3474_3582.cljs$core$IIndexed$_nth$arity$2(null,i__3476_3584);
var map__3481_3586__$1 = (((((!((map__3481_3585 == null))))?(((((map__3481_3585.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3481_3585.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3481_3585):map__3481_3585);
var gline_3587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3481_3586__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3481_3586__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3481_3586__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3587], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3473_3581,chunk__3474_3582,count__3475_3583,i__3476_3584,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3481_3585,map__3481_3586__$1,gline_3587,gcol_3588,name_3589,vec__3470_3578,column_3579,column_info_3580,vec__3433_3571,line_3572,columns_3573,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3588], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3572,new cljs.core.Keyword(null,"col","col",-1959363084),column_3579,new cljs.core.Keyword(null,"name","name",1843675177),name_3589], null));
});})(seq__3473_3581,chunk__3474_3582,count__3475_3583,i__3476_3584,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3481_3585,map__3481_3586__$1,gline_3587,gcol_3588,name_3589,vec__3470_3578,column_3579,column_info_3580,vec__3433_3571,line_3572,columns_3573,inverted))
,cljs.core.sorted_map()));


var G__3590 = seq__3473_3581;
var G__3591 = chunk__3474_3582;
var G__3592 = count__3475_3583;
var G__3593 = (i__3476_3584 + (1));
seq__3473_3581 = G__3590;
chunk__3474_3582 = G__3591;
count__3475_3583 = G__3592;
i__3476_3584 = G__3593;
continue;
} else {
var temp__5735__auto___3594 = cljs.core.seq(seq__3473_3581);
if(temp__5735__auto___3594){
var seq__3473_3595__$1 = temp__5735__auto___3594;
if(cljs.core.chunked_seq_QMARK_(seq__3473_3595__$1)){
var c__4556__auto___3596 = cljs.core.chunk_first(seq__3473_3595__$1);
var G__3597 = cljs.core.chunk_rest(seq__3473_3595__$1);
var G__3598 = c__4556__auto___3596;
var G__3599 = cljs.core.count(c__4556__auto___3596);
var G__3600 = (0);
seq__3473_3581 = G__3597;
chunk__3474_3582 = G__3598;
count__3475_3583 = G__3599;
i__3476_3584 = G__3600;
continue;
} else {
var map__3483_3601 = cljs.core.first(seq__3473_3595__$1);
var map__3483_3602__$1 = (((((!((map__3483_3601 == null))))?(((((map__3483_3601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3483_3601.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3483_3601):map__3483_3601);
var gline_3603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3483_3602__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3483_3602__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3605 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3483_3602__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3603], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3473_3581,chunk__3474_3582,count__3475_3583,i__3476_3584,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3483_3601,map__3483_3602__$1,gline_3603,gcol_3604,name_3605,seq__3473_3595__$1,temp__5735__auto___3594,vec__3470_3578,column_3579,column_info_3580,vec__3433_3571,line_3572,columns_3573,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3604], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3572,new cljs.core.Keyword(null,"col","col",-1959363084),column_3579,new cljs.core.Keyword(null,"name","name",1843675177),name_3605], null));
});})(seq__3473_3581,chunk__3474_3582,count__3475_3583,i__3476_3584,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3483_3601,map__3483_3602__$1,gline_3603,gcol_3604,name_3605,seq__3473_3595__$1,temp__5735__auto___3594,vec__3470_3578,column_3579,column_info_3580,vec__3433_3571,line_3572,columns_3573,inverted))
,cljs.core.sorted_map()));


var G__3606 = cljs.core.next(seq__3473_3595__$1);
var G__3607 = null;
var G__3608 = (0);
var G__3609 = (0);
seq__3473_3581 = G__3606;
chunk__3474_3582 = G__3607;
count__3475_3583 = G__3608;
i__3476_3584 = G__3609;
continue;
}
} else {
}
}
break;
}


var G__3610 = seq__3436_3574;
var G__3611 = chunk__3437_3575;
var G__3612 = count__3438_3576;
var G__3613 = (i__3439_3577 + (1));
seq__3436_3574 = G__3610;
chunk__3437_3575 = G__3611;
count__3438_3576 = G__3612;
i__3439_3577 = G__3613;
continue;
} else {
var temp__5735__auto___3614 = cljs.core.seq(seq__3436_3574);
if(temp__5735__auto___3614){
var seq__3436_3615__$1 = temp__5735__auto___3614;
if(cljs.core.chunked_seq_QMARK_(seq__3436_3615__$1)){
var c__4556__auto___3616 = cljs.core.chunk_first(seq__3436_3615__$1);
var G__3617 = cljs.core.chunk_rest(seq__3436_3615__$1);
var G__3618 = c__4556__auto___3616;
var G__3619 = cljs.core.count(c__4556__auto___3616);
var G__3620 = (0);
seq__3436_3574 = G__3617;
chunk__3437_3575 = G__3618;
count__3438_3576 = G__3619;
i__3439_3577 = G__3620;
continue;
} else {
var vec__3485_3621 = cljs.core.first(seq__3436_3615__$1);
var column_3622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3485_3621,(0),null);
var column_info_3623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3485_3621,(1),null);
var seq__3488_3624 = cljs.core.seq(column_info_3623);
var chunk__3489_3625 = null;
var count__3490_3626 = (0);
var i__3491_3627 = (0);
while(true){
if((i__3491_3627 < count__3490_3626)){
var map__3496_3628 = chunk__3489_3625.cljs$core$IIndexed$_nth$arity$2(null,i__3491_3627);
var map__3496_3629__$1 = (((((!((map__3496_3628 == null))))?(((((map__3496_3628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3496_3628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3496_3628):map__3496_3628);
var gline_3630 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3496_3629__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3496_3629__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3496_3629__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3630], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3488_3624,chunk__3489_3625,count__3490_3626,i__3491_3627,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3496_3628,map__3496_3629__$1,gline_3630,gcol_3631,name_3632,vec__3485_3621,column_3622,column_info_3623,seq__3436_3615__$1,temp__5735__auto___3614,vec__3433_3571,line_3572,columns_3573,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3631], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3572,new cljs.core.Keyword(null,"col","col",-1959363084),column_3622,new cljs.core.Keyword(null,"name","name",1843675177),name_3632], null));
});})(seq__3488_3624,chunk__3489_3625,count__3490_3626,i__3491_3627,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3496_3628,map__3496_3629__$1,gline_3630,gcol_3631,name_3632,vec__3485_3621,column_3622,column_info_3623,seq__3436_3615__$1,temp__5735__auto___3614,vec__3433_3571,line_3572,columns_3573,inverted))
,cljs.core.sorted_map()));


var G__3633 = seq__3488_3624;
var G__3634 = chunk__3489_3625;
var G__3635 = count__3490_3626;
var G__3636 = (i__3491_3627 + (1));
seq__3488_3624 = G__3633;
chunk__3489_3625 = G__3634;
count__3490_3626 = G__3635;
i__3491_3627 = G__3636;
continue;
} else {
var temp__5735__auto___3637__$1 = cljs.core.seq(seq__3488_3624);
if(temp__5735__auto___3637__$1){
var seq__3488_3638__$1 = temp__5735__auto___3637__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3488_3638__$1)){
var c__4556__auto___3639 = cljs.core.chunk_first(seq__3488_3638__$1);
var G__3640 = cljs.core.chunk_rest(seq__3488_3638__$1);
var G__3641 = c__4556__auto___3639;
var G__3642 = cljs.core.count(c__4556__auto___3639);
var G__3643 = (0);
seq__3488_3624 = G__3640;
chunk__3489_3625 = G__3641;
count__3490_3626 = G__3642;
i__3491_3627 = G__3643;
continue;
} else {
var map__3498_3644 = cljs.core.first(seq__3488_3638__$1);
var map__3498_3645__$1 = (((((!((map__3498_3644 == null))))?(((((map__3498_3644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3498_3644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3498_3644):map__3498_3644);
var gline_3646 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3498_3645__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3498_3645__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3498_3645__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3646], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3488_3624,chunk__3489_3625,count__3490_3626,i__3491_3627,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3498_3644,map__3498_3645__$1,gline_3646,gcol_3647,name_3648,seq__3488_3638__$1,temp__5735__auto___3637__$1,vec__3485_3621,column_3622,column_info_3623,seq__3436_3615__$1,temp__5735__auto___3614,vec__3433_3571,line_3572,columns_3573,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3647], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3572,new cljs.core.Keyword(null,"col","col",-1959363084),column_3622,new cljs.core.Keyword(null,"name","name",1843675177),name_3648], null));
});})(seq__3488_3624,chunk__3489_3625,count__3490_3626,i__3491_3627,seq__3436_3574,chunk__3437_3575,count__3438_3576,i__3439_3577,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3498_3644,map__3498_3645__$1,gline_3646,gcol_3647,name_3648,seq__3488_3638__$1,temp__5735__auto___3637__$1,vec__3485_3621,column_3622,column_info_3623,seq__3436_3615__$1,temp__5735__auto___3614,vec__3433_3571,line_3572,columns_3573,inverted))
,cljs.core.sorted_map()));


var G__3649 = cljs.core.next(seq__3488_3638__$1);
var G__3650 = null;
var G__3651 = (0);
var G__3652 = (0);
seq__3488_3624 = G__3649;
chunk__3489_3625 = G__3650;
count__3490_3626 = G__3651;
i__3491_3627 = G__3652;
continue;
}
} else {
}
}
break;
}


var G__3653 = cljs.core.next(seq__3436_3615__$1);
var G__3654 = null;
var G__3655 = (0);
var G__3656 = (0);
seq__3436_3574 = G__3653;
chunk__3437_3575 = G__3654;
count__3438_3576 = G__3655;
i__3439_3577 = G__3656;
continue;
}
} else {
}
}
break;
}


var G__3657 = seq__3295_3567;
var G__3658 = chunk__3296_3568;
var G__3659 = count__3297_3569;
var G__3660 = (i__3298_3570 + (1));
seq__3295_3567 = G__3657;
chunk__3296_3568 = G__3658;
count__3297_3569 = G__3659;
i__3298_3570 = G__3660;
continue;
} else {
var temp__5735__auto___3661 = cljs.core.seq(seq__3295_3567);
if(temp__5735__auto___3661){
var seq__3295_3662__$1 = temp__5735__auto___3661;
if(cljs.core.chunked_seq_QMARK_(seq__3295_3662__$1)){
var c__4556__auto___3663 = cljs.core.chunk_first(seq__3295_3662__$1);
var G__3664 = cljs.core.chunk_rest(seq__3295_3662__$1);
var G__3665 = c__4556__auto___3663;
var G__3666 = cljs.core.count(c__4556__auto___3663);
var G__3667 = (0);
seq__3295_3567 = G__3664;
chunk__3296_3568 = G__3665;
count__3297_3569 = G__3666;
i__3298_3570 = G__3667;
continue;
} else {
var vec__3500_3668 = cljs.core.first(seq__3295_3662__$1);
var line_3669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3500_3668,(0),null);
var columns_3670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3500_3668,(1),null);
var seq__3503_3671 = cljs.core.seq(columns_3670);
var chunk__3504_3672 = null;
var count__3505_3673 = (0);
var i__3506_3674 = (0);
while(true){
if((i__3506_3674 < count__3505_3673)){
var vec__3537_3675 = chunk__3504_3672.cljs$core$IIndexed$_nth$arity$2(null,i__3506_3674);
var column_3676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3537_3675,(0),null);
var column_info_3677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3537_3675,(1),null);
var seq__3540_3678 = cljs.core.seq(column_info_3677);
var chunk__3541_3679 = null;
var count__3542_3680 = (0);
var i__3543_3681 = (0);
while(true){
if((i__3543_3681 < count__3542_3680)){
var map__3548_3682 = chunk__3541_3679.cljs$core$IIndexed$_nth$arity$2(null,i__3543_3681);
var map__3548_3683__$1 = (((((!((map__3548_3682 == null))))?(((((map__3548_3682.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3548_3682.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3548_3682):map__3548_3682);
var gline_3684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3548_3683__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3548_3683__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3548_3683__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3684], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3540_3678,chunk__3541_3679,count__3542_3680,i__3543_3681,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3548_3682,map__3548_3683__$1,gline_3684,gcol_3685,name_3686,vec__3537_3675,column_3676,column_info_3677,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3685], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3669,new cljs.core.Keyword(null,"col","col",-1959363084),column_3676,new cljs.core.Keyword(null,"name","name",1843675177),name_3686], null));
});})(seq__3540_3678,chunk__3541_3679,count__3542_3680,i__3543_3681,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3548_3682,map__3548_3683__$1,gline_3684,gcol_3685,name_3686,vec__3537_3675,column_3676,column_info_3677,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted))
,cljs.core.sorted_map()));


var G__3687 = seq__3540_3678;
var G__3688 = chunk__3541_3679;
var G__3689 = count__3542_3680;
var G__3690 = (i__3543_3681 + (1));
seq__3540_3678 = G__3687;
chunk__3541_3679 = G__3688;
count__3542_3680 = G__3689;
i__3543_3681 = G__3690;
continue;
} else {
var temp__5735__auto___3691__$1 = cljs.core.seq(seq__3540_3678);
if(temp__5735__auto___3691__$1){
var seq__3540_3692__$1 = temp__5735__auto___3691__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3540_3692__$1)){
var c__4556__auto___3693 = cljs.core.chunk_first(seq__3540_3692__$1);
var G__3694 = cljs.core.chunk_rest(seq__3540_3692__$1);
var G__3695 = c__4556__auto___3693;
var G__3696 = cljs.core.count(c__4556__auto___3693);
var G__3697 = (0);
seq__3540_3678 = G__3694;
chunk__3541_3679 = G__3695;
count__3542_3680 = G__3696;
i__3543_3681 = G__3697;
continue;
} else {
var map__3550_3698 = cljs.core.first(seq__3540_3692__$1);
var map__3550_3699__$1 = (((((!((map__3550_3698 == null))))?(((((map__3550_3698.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3550_3698.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3550_3698):map__3550_3698);
var gline_3700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3550_3699__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3550_3699__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3550_3699__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3700], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3540_3678,chunk__3541_3679,count__3542_3680,i__3543_3681,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3550_3698,map__3550_3699__$1,gline_3700,gcol_3701,name_3702,seq__3540_3692__$1,temp__5735__auto___3691__$1,vec__3537_3675,column_3676,column_info_3677,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3701], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3669,new cljs.core.Keyword(null,"col","col",-1959363084),column_3676,new cljs.core.Keyword(null,"name","name",1843675177),name_3702], null));
});})(seq__3540_3678,chunk__3541_3679,count__3542_3680,i__3543_3681,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3550_3698,map__3550_3699__$1,gline_3700,gcol_3701,name_3702,seq__3540_3692__$1,temp__5735__auto___3691__$1,vec__3537_3675,column_3676,column_info_3677,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted))
,cljs.core.sorted_map()));


var G__3703 = cljs.core.next(seq__3540_3692__$1);
var G__3704 = null;
var G__3705 = (0);
var G__3706 = (0);
seq__3540_3678 = G__3703;
chunk__3541_3679 = G__3704;
count__3542_3680 = G__3705;
i__3543_3681 = G__3706;
continue;
}
} else {
}
}
break;
}


var G__3707 = seq__3503_3671;
var G__3708 = chunk__3504_3672;
var G__3709 = count__3505_3673;
var G__3710 = (i__3506_3674 + (1));
seq__3503_3671 = G__3707;
chunk__3504_3672 = G__3708;
count__3505_3673 = G__3709;
i__3506_3674 = G__3710;
continue;
} else {
var temp__5735__auto___3711__$1 = cljs.core.seq(seq__3503_3671);
if(temp__5735__auto___3711__$1){
var seq__3503_3712__$1 = temp__5735__auto___3711__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3503_3712__$1)){
var c__4556__auto___3713 = cljs.core.chunk_first(seq__3503_3712__$1);
var G__3714 = cljs.core.chunk_rest(seq__3503_3712__$1);
var G__3715 = c__4556__auto___3713;
var G__3716 = cljs.core.count(c__4556__auto___3713);
var G__3717 = (0);
seq__3503_3671 = G__3714;
chunk__3504_3672 = G__3715;
count__3505_3673 = G__3716;
i__3506_3674 = G__3717;
continue;
} else {
var vec__3552_3718 = cljs.core.first(seq__3503_3712__$1);
var column_3719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3552_3718,(0),null);
var column_info_3720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3552_3718,(1),null);
var seq__3555_3721 = cljs.core.seq(column_info_3720);
var chunk__3556_3722 = null;
var count__3557_3723 = (0);
var i__3558_3724 = (0);
while(true){
if((i__3558_3724 < count__3557_3723)){
var map__3563_3725 = chunk__3556_3722.cljs$core$IIndexed$_nth$arity$2(null,i__3558_3724);
var map__3563_3726__$1 = (((((!((map__3563_3725 == null))))?(((((map__3563_3725.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3563_3725.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3563_3725):map__3563_3725);
var gline_3727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3563_3726__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3728 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3563_3726__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3563_3726__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3727], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3555_3721,chunk__3556_3722,count__3557_3723,i__3558_3724,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3563_3725,map__3563_3726__$1,gline_3727,gcol_3728,name_3729,vec__3552_3718,column_3719,column_info_3720,seq__3503_3712__$1,temp__5735__auto___3711__$1,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3728], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3669,new cljs.core.Keyword(null,"col","col",-1959363084),column_3719,new cljs.core.Keyword(null,"name","name",1843675177),name_3729], null));
});})(seq__3555_3721,chunk__3556_3722,count__3557_3723,i__3558_3724,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3563_3725,map__3563_3726__$1,gline_3727,gcol_3728,name_3729,vec__3552_3718,column_3719,column_info_3720,seq__3503_3712__$1,temp__5735__auto___3711__$1,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted))
,cljs.core.sorted_map()));


var G__3730 = seq__3555_3721;
var G__3731 = chunk__3556_3722;
var G__3732 = count__3557_3723;
var G__3733 = (i__3558_3724 + (1));
seq__3555_3721 = G__3730;
chunk__3556_3722 = G__3731;
count__3557_3723 = G__3732;
i__3558_3724 = G__3733;
continue;
} else {
var temp__5735__auto___3734__$2 = cljs.core.seq(seq__3555_3721);
if(temp__5735__auto___3734__$2){
var seq__3555_3735__$1 = temp__5735__auto___3734__$2;
if(cljs.core.chunked_seq_QMARK_(seq__3555_3735__$1)){
var c__4556__auto___3736 = cljs.core.chunk_first(seq__3555_3735__$1);
var G__3737 = cljs.core.chunk_rest(seq__3555_3735__$1);
var G__3738 = c__4556__auto___3736;
var G__3739 = cljs.core.count(c__4556__auto___3736);
var G__3740 = (0);
seq__3555_3721 = G__3737;
chunk__3556_3722 = G__3738;
count__3557_3723 = G__3739;
i__3558_3724 = G__3740;
continue;
} else {
var map__3565_3741 = cljs.core.first(seq__3555_3735__$1);
var map__3565_3742__$1 = (((((!((map__3565_3741 == null))))?(((((map__3565_3741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3565_3741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3565_3741):map__3565_3741);
var gline_3743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3565_3742__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_3744 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3565_3742__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_3745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3565_3742__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_3743], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__3555_3721,chunk__3556_3722,count__3557_3723,i__3558_3724,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3565_3741,map__3565_3742__$1,gline_3743,gcol_3744,name_3745,seq__3555_3735__$1,temp__5735__auto___3734__$2,vec__3552_3718,column_3719,column_info_3720,seq__3503_3712__$1,temp__5735__auto___3711__$1,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_3744], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_3669,new cljs.core.Keyword(null,"col","col",-1959363084),column_3719,new cljs.core.Keyword(null,"name","name",1843675177),name_3745], null));
});})(seq__3555_3721,chunk__3556_3722,count__3557_3723,i__3558_3724,seq__3503_3671,chunk__3504_3672,count__3505_3673,i__3506_3674,seq__3295_3567,chunk__3296_3568,count__3297_3569,i__3298_3570,map__3565_3741,map__3565_3742__$1,gline_3743,gcol_3744,name_3745,seq__3555_3735__$1,temp__5735__auto___3734__$2,vec__3552_3718,column_3719,column_info_3720,seq__3503_3712__$1,temp__5735__auto___3711__$1,vec__3500_3668,line_3669,columns_3670,seq__3295_3662__$1,temp__5735__auto___3661,inverted))
,cljs.core.sorted_map()));


var G__3746 = cljs.core.next(seq__3555_3735__$1);
var G__3747 = null;
var G__3748 = (0);
var G__3749 = (0);
seq__3555_3721 = G__3746;
chunk__3556_3722 = G__3747;
count__3557_3723 = G__3748;
i__3558_3724 = G__3749;
continue;
}
} else {
}
}
break;
}


var G__3750 = cljs.core.next(seq__3503_3712__$1);
var G__3751 = null;
var G__3752 = (0);
var G__3753 = (0);
seq__3503_3671 = G__3750;
chunk__3504_3672 = G__3751;
count__3505_3673 = G__3752;
i__3506_3674 = G__3753;
continue;
}
} else {
}
}
break;
}


var G__3754 = cljs.core.next(seq__3295_3662__$1);
var G__3755 = null;
var G__3756 = (0);
var G__3757 = (0);
seq__3295_3567 = G__3754;
chunk__3296_3568 = G__3755;
count__3297_3569 = G__3756;
i__3298_3570 = G__3757;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
