// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62948 = arguments.length;
switch (G__62948) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_62990){
var state_val_62991 = (state_62990[(1)]);
if((state_val_62991 === (7))){
var inst_62960 = typeof user === 'string';
var state_62990__$1 = state_62990;
if(cljs.core.truth_(inst_62960)){
var statearr_62992_63021 = state_62990__$1;
(statearr_62992_63021[(1)] = (9));

} else {
var statearr_62993_63022 = state_62990__$1;
(statearr_62993_63022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (1))){
var state_62990__$1 = state_62990;
var statearr_62994_63023 = state_62990__$1;
(statearr_62994_63023[(2)] = null);

(statearr_62994_63023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (4))){
var inst_62949 = (state_62990[(2)]);
var inst_62950 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62949], 0));
var inst_62951 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62949) : reject.call(null,inst_62949));
var state_62990__$1 = (function (){var statearr_62995 = state_62990;
(statearr_62995[(7)] = inst_62950);

return statearr_62995;
})();
var statearr_62996_63024 = state_62990__$1;
(statearr_62996_63024[(2)] = inst_62951);

(statearr_62996_63024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (15))){
var inst_62979 = (state_62990[(2)]);
var inst_62980 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62979);
var inst_62981 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62982 = cljs.core.constantly(inst_62980);
var inst_62983 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62981,inst_62982);
var inst_62984 = fluree.db.connection.add_token(conn,inst_62980);
var inst_62985 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62979) : resolve.call(null,inst_62979));
var _ = (function (){var statearr_62997 = state_62990;
(statearr_62997[(4)] = cljs.core.rest((state_62990[(4)])));

return statearr_62997;
})();
var state_62990__$1 = (function (){var statearr_62998 = state_62990;
(statearr_62998[(8)] = inst_62983);

(statearr_62998[(9)] = inst_62984);

return statearr_62998;
})();
var statearr_62999_63025 = state_62990__$1;
(statearr_62999_63025[(2)] = inst_62985);

(statearr_62999_63025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (13))){
var state_62990__$1 = state_62990;
var statearr_63000_63026 = state_62990__$1;
(statearr_63000_63026[(2)] = null);

(statearr_63000_63026[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (6))){
var state_62990__$1 = state_62990;
var statearr_63001_63027 = state_62990__$1;
(statearr_63001_63027[(2)] = user);

(statearr_63001_63027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (3))){
var inst_62988 = (state_62990[(2)]);
var state_62990__$1 = state_62990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62990__$1,inst_62988);
} else {
if((state_val_62991 === (12))){
var state_62990__$1 = state_62990;
var statearr_63002_63028 = state_62990__$1;
(statearr_63002_63028[(2)] = user);

(statearr_63002_63028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (2))){
var _ = (function (){var statearr_63003 = state_62990;
(statearr_63003[(4)] = cljs.core.cons((5),(state_62990[(4)])));

return statearr_63003;
})();
var inst_62957 = typeof user === 'number';
var state_62990__$1 = state_62990;
if(cljs.core.truth_(inst_62957)){
var statearr_63004_63029 = state_62990__$1;
(statearr_63004_63029[(1)] = (6));

} else {
var statearr_63005_63030 = state_62990__$1;
(statearr_63005_63030[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (11))){
var inst_62971 = (state_62990[(2)]);
var state_62990__$1 = state_62990;
var statearr_63007_63031 = state_62990__$1;
(statearr_63007_63031[(2)] = inst_62971);

(statearr_63007_63031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (9))){
var inst_62962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62963 = ["_user/username",user];
var inst_62964 = (new cljs.core.PersistentVector(null,2,(5),inst_62962,inst_62963,null));
var state_62990__$1 = state_62990;
var statearr_63008_63032 = state_62990__$1;
(statearr_63008_63032[(2)] = inst_62964);

(statearr_63008_63032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (5))){
var _ = (function (){var statearr_63009 = state_62990;
(statearr_63009[(4)] = cljs.core.rest((state_62990[(4)])));

return statearr_63009;
})();
var state_62990__$1 = state_62990;
var ex63006 = (state_62990__$1[(2)]);
var statearr_63010_63033 = state_62990__$1;
(statearr_63010_63033[(5)] = ex63006);


var statearr_63011_63034 = state_62990__$1;
(statearr_63011_63034[(1)] = (4));

(statearr_63011_63034[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (14))){
var inst_62969 = (state_62990[(2)]);
var state_62990__$1 = state_62990;
var statearr_63012_63035 = state_62990__$1;
(statearr_63012_63035[(2)] = inst_62969);

(statearr_63012_63035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (10))){
var state_62990__$1 = state_62990;
var statearr_63013_63036 = state_62990__$1;
(statearr_63013_63036[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62991 === (8))){
var inst_62973 = (state_62990[(2)]);
var inst_62974 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62975 = [account,inst_62973,password,expireSeconds,syncTo];
var inst_62976 = cljs.core.PersistentHashMap.fromArrays(inst_62974,inst_62975);
var inst_62977 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62976);
var state_62990__$1 = state_62990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62990__$1,(15),inst_62977);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63015 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63015[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63015[(1)] = (1));

return statearr_63015;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_62990){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_62990);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63016){var ex__2417__auto__ = e63016;
var statearr_63017_63037 = state_62990;
(statearr_63017_63037[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_62990[(4)]))){
var statearr_63018_63038 = state_62990;
(statearr_63018_63038[(1)] = cljs.core.first((state_62990[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63039 = state_62990;
state_62990 = G__63039;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_62990){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_62990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63019 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63019[(6)] = c__2436__auto__);

return statearr_63019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63041 = arguments.length;
switch (G__63041) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63050){
var state_val_63051 = (state_63050[(1)]);
if((state_val_63051 === (1))){
var inst_63042 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63044 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63045 = (new cljs.core.PersistentVector(null,4,(5),inst_63043,inst_63044,null));
var inst_63046 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63042,inst_63045);
var inst_63047 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63052 = cljs.core.seq(cljs.core.keys(x));
var chunk__63053 = null;
var count__63054 = (0);
var i__63055 = (0);
while(true){
if((i__63055 < count__63054)){
var k = chunk__63053.cljs$core$IIndexed$_nth$arity$2(null,i__63055);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63063 = seq__63052;
var G__63064 = chunk__63053;
var G__63065 = count__63054;
var G__63066 = (i__63055 + (1));
seq__63052 = G__63063;
chunk__63053 = G__63064;
count__63054 = G__63065;
i__63055 = G__63066;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__63052);
if(temp__5735__auto__){
var seq__63052__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63052__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__63052__$1);
var G__63067 = cljs.core.chunk_rest(seq__63052__$1);
var G__63068 = c__4556__auto__;
var G__63069 = cljs.core.count(c__4556__auto__);
var G__63070 = (0);
seq__63052 = G__63067;
chunk__63053 = G__63068;
count__63054 = G__63069;
i__63055 = G__63070;
continue;
} else {
var k = cljs.core.first(seq__63052__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__63071 = cljs.core.next(seq__63052__$1);
var G__63072 = null;
var G__63073 = (0);
var G__63074 = (0);
seq__63052 = G__63071;
chunk__63053 = G__63072;
count__63054 = G__63073;
i__63055 = G__63074;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63048 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63047);
var state_63050__$1 = (function (){var statearr_63056 = state_63050;
(statearr_63056[(7)] = inst_63046);

return statearr_63056;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63050__$1,inst_63048);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63057 = [null,null,null,null,null,null,null,null];
(statearr_63057[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63057[(1)] = (1));

return statearr_63057;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63050){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63050);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63058){var ex__2417__auto__ = e63058;
var statearr_63059_63075 = state_63050;
(statearr_63059_63075[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63050[(4)]))){
var statearr_63060_63076 = state_63050;
(statearr_63060_63076[(1)] = cljs.core.first((state_63050[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63077 = state_63050;
state_63050 = G__63077;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63050){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63061 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63061[(6)] = c__2436__auto__);

return statearr_63061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63079 = arguments.length;
switch (G__63079) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63113){
var state_val_63114 = (state_63113[(1)]);
if((state_val_63114 === (1))){
var state_63113__$1 = state_63113;
var statearr_63115_63136 = state_63113__$1;
(statearr_63115_63136[(2)] = null);

(statearr_63115_63136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63114 === (2))){
var _ = (function (){var statearr_63116 = state_63113;
(statearr_63116[(4)] = cljs.core.cons((5),(state_63113[(4)])));

return statearr_63116;
})();
var inst_63088 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_63089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63090 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63091 = (new cljs.core.PersistentVector(null,1,(5),inst_63089,inst_63090,null));
var inst_63092 = cljs.core.PersistentHashMap.EMPTY;
var inst_63093 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63092);
var inst_63094 = cljs.core.assoc_in(inst_63088,inst_63091,inst_63093);
var inst_63095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63096 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63097 = (new cljs.core.PersistentVector(null,1,(5),inst_63095,inst_63096,null));
var inst_63098 = cljs.core.PersistentHashMap.EMPTY;
var inst_63099 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_63098);
var inst_63100 = cljs.core.assoc_in(inst_63094,inst_63097,inst_63099);
var inst_63101 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63102 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63100);
var inst_63103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63104 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63101,null];
var inst_63105 = (new cljs.core.PersistentVector(null,4,(5),inst_63103,inst_63104,null));
var inst_63106 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63102,inst_63105);
var inst_63107 = (function (){var conn = inst_63100;
var pc = inst_63101;
return (function (x){
if((x == null)){
} else {
var seq__63117_63137 = cljs.core.seq(cljs.core.keys(x));
var chunk__63118_63138 = null;
var count__63119_63139 = (0);
var i__63120_63140 = (0);
while(true){
if((i__63120_63140 < count__63119_63139)){
var k_63141 = chunk__63118_63138.cljs$core$IIndexed$_nth$arity$2(null,i__63120_63140);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63141], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63141,null));


var G__63142 = seq__63117_63137;
var G__63143 = chunk__63118_63138;
var G__63144 = count__63119_63139;
var G__63145 = (i__63120_63140 + (1));
seq__63117_63137 = G__63142;
chunk__63118_63138 = G__63143;
count__63119_63139 = G__63144;
i__63120_63140 = G__63145;
continue;
} else {
var temp__5735__auto___63146 = cljs.core.seq(seq__63117_63137);
if(temp__5735__auto___63146){
var seq__63117_63147__$1 = temp__5735__auto___63146;
if(cljs.core.chunked_seq_QMARK_(seq__63117_63147__$1)){
var c__4556__auto___63148 = cljs.core.chunk_first(seq__63117_63147__$1);
var G__63149 = cljs.core.chunk_rest(seq__63117_63147__$1);
var G__63150 = c__4556__auto___63148;
var G__63151 = cljs.core.count(c__4556__auto___63148);
var G__63152 = (0);
seq__63117_63137 = G__63149;
chunk__63118_63138 = G__63150;
count__63119_63139 = G__63151;
i__63120_63140 = G__63152;
continue;
} else {
var k_63153 = cljs.core.first(seq__63117_63147__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63153], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_63153,null));


var G__63154 = cljs.core.next(seq__63117_63147__$1);
var G__63155 = null;
var G__63156 = (0);
var G__63157 = (0);
seq__63117_63137 = G__63154;
chunk__63118_63138 = G__63155;
count__63119_63139 = G__63156;
i__63120_63140 = G__63157;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_63108 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63101,inst_63107);
var ___$1 = (function (){var statearr_63121 = state_63113;
(statearr_63121[(4)] = cljs.core.rest((state_63113[(4)])));

return statearr_63121;
})();
var state_63113__$1 = (function (){var statearr_63122 = state_63113;
(statearr_63122[(7)] = inst_63106);

return statearr_63122;
})();
var statearr_63123_63158 = state_63113__$1;
(statearr_63123_63158[(2)] = inst_63108);

(statearr_63123_63158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63114 === (3))){
var inst_63111 = (state_63113[(2)]);
var state_63113__$1 = state_63113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63113__$1,inst_63111);
} else {
if((state_val_63114 === (4))){
var inst_63080 = (state_63113[(2)]);
var inst_63081 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63080], 0));
var inst_63082 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63080) : reject.call(null,inst_63080));
var state_63113__$1 = (function (){var statearr_63125 = state_63113;
(statearr_63125[(8)] = inst_63081);

return statearr_63125;
})();
var statearr_63126_63159 = state_63113__$1;
(statearr_63126_63159[(2)] = inst_63082);

(statearr_63126_63159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63114 === (5))){
var _ = (function (){var statearr_63127 = state_63113;
(statearr_63127[(4)] = cljs.core.rest((state_63113[(4)])));

return statearr_63127;
})();
var state_63113__$1 = state_63113;
var ex63124 = (state_63113__$1[(2)]);
var statearr_63128_63160 = state_63113__$1;
(statearr_63128_63160[(5)] = ex63124);


var statearr_63129_63161 = state_63113__$1;
(statearr_63129_63161[(1)] = (4));

(statearr_63129_63161[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63130 = [null,null,null,null,null,null,null,null,null];
(statearr_63130[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63130[(1)] = (1));

return statearr_63130;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63113){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63113);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63131){var ex__2417__auto__ = e63131;
var statearr_63132_63162 = state_63113;
(statearr_63132_63162[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63113[(4)]))){
var statearr_63133_63163 = state_63113;
(statearr_63133_63163[(1)] = cljs.core.first((state_63113[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63164 = state_63113;
state_63113 = G__63164;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63113){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63134 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63134[(6)] = c__2436__auto__);

return statearr_63134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63166 = arguments.length;
switch (G__63166) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63168 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63168,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63168,(1),null);
var cb_STAR_ = (function (header,data){
var G__63171 = cljs.core.clj__GT_js(header);
var G__63172 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__63171,G__63172) : callback.call(null,G__63171,G__63172));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63173 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63173,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63173,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63226){
var state_val_63227 = (state_63226[(1)]);
if((state_val_63227 === (7))){
var inst_63187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63188 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63189 = cljs.core.PersistentHashMap.fromArrays(inst_63187,inst_63188);
var inst_63190 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63189);
var inst_63191 = (function(){throw inst_63190})();
var state_63226__$1 = state_63226;
var statearr_63228_63260 = state_63226__$1;
(statearr_63228_63260[(2)] = inst_63191);

(statearr_63228_63260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (1))){
var state_63226__$1 = state_63226;
var statearr_63229_63261 = state_63226__$1;
(statearr_63229_63261[(2)] = null);

(statearr_63229_63261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (4))){
var inst_63176 = (state_63226[(2)]);
var inst_63177 = cljs.core.clj__GT_js(inst_63176);
var inst_63178 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63177) : reject.call(null,inst_63177));
var state_63226__$1 = state_63226;
var statearr_63230_63262 = state_63226__$1;
(statearr_63230_63262[(2)] = inst_63178);

(statearr_63230_63262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (13))){
var inst_63205 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63206 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63207 = cljs.core.PersistentHashMap.fromArrays(inst_63205,inst_63206);
var inst_63208 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_63207);
var inst_63209 = (function(){throw inst_63208})();
var state_63226__$1 = state_63226;
var statearr_63231_63263 = state_63226__$1;
(statearr_63231_63263[(2)] = inst_63209);

(statearr_63231_63263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (6))){
var state_63226__$1 = state_63226;
var statearr_63232_63264 = state_63226__$1;
(statearr_63232_63264[(2)] = null);

(statearr_63232_63264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (3))){
var inst_63224 = (state_63226[(2)]);
var state_63226__$1 = state_63226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63226__$1,inst_63224);
} else {
if((state_val_63227 === (12))){
var state_63226__$1 = state_63226;
var statearr_63233_63265 = state_63226__$1;
(statearr_63233_63265[(2)] = null);

(statearr_63233_63265[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (2))){
var _ = (function (){var statearr_63234 = state_63226;
(statearr_63234[(4)] = cljs.core.cons((5),(state_63226[(4)])));

return statearr_63234;
})();
var inst_63184 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63226__$1 = state_63226;
if(cljs.core.truth_(inst_63184)){
var statearr_63235_63266 = state_63226__$1;
(statearr_63235_63266[(1)] = (6));

} else {
var statearr_63236_63267 = state_63226__$1;
(statearr_63236_63267[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (11))){
var inst_63202 = (state_63226[(2)]);
var state_63226__$1 = (function (){var statearr_63238 = state_63226;
(statearr_63238[(7)] = inst_63202);

return statearr_63238;
})();
if(cljs.core.truth_(password)){
var statearr_63239_63268 = state_63226__$1;
(statearr_63239_63268[(1)] = (12));

} else {
var statearr_63240_63269 = state_63226__$1;
(statearr_63240_63269[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (9))){
var state_63226__$1 = state_63226;
var statearr_63241_63270 = state_63226__$1;
(statearr_63241_63270[(2)] = null);

(statearr_63241_63270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (5))){
var _ = (function (){var statearr_63242 = state_63226;
(statearr_63242[(4)] = cljs.core.rest((state_63226[(4)])));

return statearr_63242;
})();
var state_63226__$1 = state_63226;
var ex63237 = (state_63226__$1[(2)]);
var statearr_63243_63271 = state_63226__$1;
(statearr_63243_63271[(5)] = ex63237);


var statearr_63244_63272 = state_63226__$1;
(statearr_63244_63272[(1)] = (4));

(statearr_63244_63272[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (14))){
var inst_63211 = (state_63226[(2)]);
var inst_63212 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_63213 = fluree.db.util.core.without_nils(inst_63212);
var inst_63214 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63215 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63217 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63213,inst_63214,null];
var inst_63218 = (new cljs.core.PersistentVector(null,4,(5),inst_63216,inst_63217,null));
var inst_63219 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63215,inst_63218);
var inst_63220 = (function (){var _ = inst_63211;
var data = inst_63213;
var pc = inst_63214;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63245 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63245) : reject.call(null,G__63245));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63246 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63246) : reject.call(null,G__63246));
} else {
var G__63247 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63247) : resolve.call(null,G__63247));

}
}
});
})();
var inst_63221 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63214,inst_63220);
var _ = (function (){var statearr_63248 = state_63226;
(statearr_63248[(4)] = cljs.core.rest((state_63226[(4)])));

return statearr_63248;
})();
var state_63226__$1 = (function (){var statearr_63249 = state_63226;
(statearr_63249[(8)] = inst_63219);

return statearr_63249;
})();
var statearr_63250_63273 = state_63226__$1;
(statearr_63250_63273[(2)] = inst_63221);

(statearr_63250_63273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (10))){
var inst_63196 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63197 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63198 = cljs.core.PersistentHashMap.fromArrays(inst_63196,inst_63197);
var inst_63199 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_63198);
var inst_63200 = (function(){throw inst_63199})();
var state_63226__$1 = state_63226;
var statearr_63251_63274 = state_63226__$1;
(statearr_63251_63274[(2)] = inst_63200);

(statearr_63251_63274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63227 === (8))){
var inst_63193 = (state_63226[(2)]);
var state_63226__$1 = (function (){var statearr_63252 = state_63226;
(statearr_63252[(9)] = inst_63193);

return statearr_63252;
})();
if(cljs.core.truth_(ledger)){
var statearr_63253_63275 = state_63226__$1;
(statearr_63253_63275[(1)] = (9));

} else {
var statearr_63254_63276 = state_63226__$1;
(statearr_63254_63276[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0 = (function (){
var statearr_63255 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63255[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2414__auto__);

(statearr_63255[(1)] = (1));

return statearr_63255;
});
var fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1 = (function (state_63226){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63226);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63256){var ex__2417__auto__ = e63256;
var statearr_63257_63277 = state_63226;
(statearr_63257_63277[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63226[(4)]))){
var statearr_63258_63278 = state_63226;
(statearr_63258_63278[(1)] = cljs.core.first((state_63226[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63279 = state_63226;
state_63226 = G__63279;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__ = function(state_63226){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1.call(this,state_63226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2414__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2414__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63259 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63259[(6)] = c__2436__auto__);

return statearr_63259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63281 = arguments.length;
switch (G__63281) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63348){
var state_val_63349 = (state_63348[(1)]);
if((state_val_63349 === (7))){
var inst_63293 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63294 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63295 = cljs.core.PersistentHashMap.fromArrays(inst_63293,inst_63294);
var inst_63296 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63295);
var inst_63297 = (function(){throw inst_63296})();
var state_63348__$1 = state_63348;
var statearr_63350_63392 = state_63348__$1;
(statearr_63350_63392[(2)] = inst_63297);

(statearr_63350_63392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (20))){
var inst_63331 = (state_63348[(2)]);
var inst_63332 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63333 = [ledger,password,user,auth,expire];
var inst_63334 = cljs.core.PersistentHashMap.fromArrays(inst_63332,inst_63333);
var inst_63335 = fluree.db.util.core.without_nils(inst_63334);
var inst_63336 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63337 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63339 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63335,inst_63336,null];
var inst_63340 = (new cljs.core.PersistentVector(null,4,(5),inst_63338,inst_63339,null));
var inst_63341 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63337,inst_63340);
var inst_63342 = (function (){var _ = inst_63331;
var data = inst_63335;
var pc = inst_63336;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63351 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63351) : reject.call(null,G__63351));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__63352 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63352) : reject.call(null,G__63352));
} else {
fluree.db.connection.add_token(conn,result);

var G__63353 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63353) : resolve.call(null,G__63353));

}
}
});
})();
var inst_63343 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63336,inst_63342);
var _ = (function (){var statearr_63354 = state_63348;
(statearr_63354[(4)] = cljs.core.rest((state_63348[(4)])));

return statearr_63354;
})();
var state_63348__$1 = (function (){var statearr_63355 = state_63348;
(statearr_63355[(7)] = inst_63341);

return statearr_63355;
})();
var statearr_63356_63393 = state_63348__$1;
(statearr_63356_63393[(2)] = inst_63343);

(statearr_63356_63393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (1))){
var state_63348__$1 = state_63348;
var statearr_63357_63394 = state_63348__$1;
(statearr_63357_63394[(2)] = null);

(statearr_63357_63394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (4))){
var inst_63282 = (state_63348[(2)]);
var inst_63283 = cljs.core.clj__GT_js(inst_63282);
var inst_63284 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63283) : reject.call(null,inst_63283));
var state_63348__$1 = state_63348;
var statearr_63358_63395 = state_63348__$1;
(statearr_63358_63395[(2)] = inst_63284);

(statearr_63358_63395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (15))){
var inst_63318 = (state_63348[(8)]);
var state_63348__$1 = state_63348;
var statearr_63359_63396 = state_63348__$1;
(statearr_63359_63396[(2)] = inst_63318);

(statearr_63359_63396[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (13))){
var inst_63311 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63312 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63313 = cljs.core.PersistentHashMap.fromArrays(inst_63311,inst_63312);
var inst_63314 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_63313);
var inst_63315 = (function(){throw inst_63314})();
var state_63348__$1 = state_63348;
var statearr_63360_63397 = state_63348__$1;
(statearr_63360_63397[(2)] = inst_63315);

(statearr_63360_63397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (6))){
var state_63348__$1 = state_63348;
var statearr_63361_63398 = state_63348__$1;
(statearr_63361_63398[(2)] = null);

(statearr_63361_63398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (17))){
var inst_63322 = (state_63348[(2)]);
var state_63348__$1 = state_63348;
if(cljs.core.truth_(inst_63322)){
var statearr_63362_63399 = state_63348__$1;
(statearr_63362_63399[(1)] = (18));

} else {
var statearr_63363_63400 = state_63348__$1;
(statearr_63363_63400[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (3))){
var inst_63346 = (state_63348[(2)]);
var state_63348__$1 = state_63348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63348__$1,inst_63346);
} else {
if((state_val_63349 === (12))){
var state_63348__$1 = state_63348;
var statearr_63364_63401 = state_63348__$1;
(statearr_63364_63401[(2)] = null);

(statearr_63364_63401[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (2))){
var _ = (function (){var statearr_63365 = state_63348;
(statearr_63365[(4)] = cljs.core.cons((5),(state_63348[(4)])));

return statearr_63365;
})();
var inst_63290 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63348__$1 = state_63348;
if(cljs.core.truth_(inst_63290)){
var statearr_63366_63402 = state_63348__$1;
(statearr_63366_63402[(1)] = (6));

} else {
var statearr_63367_63403 = state_63348__$1;
(statearr_63367_63403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (19))){
var inst_63325 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63326 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63327 = cljs.core.PersistentHashMap.fromArrays(inst_63325,inst_63326);
var inst_63328 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_63327);
var inst_63329 = (function(){throw inst_63328})();
var state_63348__$1 = state_63348;
var statearr_63368_63404 = state_63348__$1;
(statearr_63368_63404[(2)] = inst_63329);

(statearr_63368_63404[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (11))){
var inst_63308 = (state_63348[(2)]);
var state_63348__$1 = (function (){var statearr_63370 = state_63348;
(statearr_63370[(9)] = inst_63308);

return statearr_63370;
})();
if(cljs.core.truth_(password)){
var statearr_63371_63405 = state_63348__$1;
(statearr_63371_63405[(1)] = (12));

} else {
var statearr_63372_63406 = state_63348__$1;
(statearr_63372_63406[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (9))){
var state_63348__$1 = state_63348;
var statearr_63373_63407 = state_63348__$1;
(statearr_63373_63407[(2)] = null);

(statearr_63373_63407[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (5))){
var _ = (function (){var statearr_63374 = state_63348;
(statearr_63374[(4)] = cljs.core.rest((state_63348[(4)])));

return statearr_63374;
})();
var state_63348__$1 = state_63348;
var ex63369 = (state_63348__$1[(2)]);
var statearr_63375_63408 = state_63348__$1;
(statearr_63375_63408[(5)] = ex63369);


var statearr_63376_63409 = state_63348__$1;
(statearr_63376_63409[(1)] = (4));

(statearr_63376_63409[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (14))){
var inst_63318 = (state_63348[(8)]);
var inst_63317 = (state_63348[(2)]);
var inst_63318__$1 = user;
var state_63348__$1 = (function (){var statearr_63377 = state_63348;
(statearr_63377[(10)] = inst_63317);

(statearr_63377[(8)] = inst_63318__$1);

return statearr_63377;
})();
if(cljs.core.truth_(inst_63318__$1)){
var statearr_63378_63410 = state_63348__$1;
(statearr_63378_63410[(1)] = (15));

} else {
var statearr_63379_63411 = state_63348__$1;
(statearr_63379_63411[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (16))){
var state_63348__$1 = state_63348;
var statearr_63380_63412 = state_63348__$1;
(statearr_63380_63412[(2)] = auth);

(statearr_63380_63412[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (10))){
var inst_63302 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63303 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63304 = cljs.core.PersistentHashMap.fromArrays(inst_63302,inst_63303);
var inst_63305 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_63304);
var inst_63306 = (function(){throw inst_63305})();
var state_63348__$1 = state_63348;
var statearr_63381_63413 = state_63348__$1;
(statearr_63381_63413[(2)] = inst_63306);

(statearr_63381_63413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (18))){
var state_63348__$1 = state_63348;
var statearr_63382_63414 = state_63348__$1;
(statearr_63382_63414[(2)] = null);

(statearr_63382_63414[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63349 === (8))){
var inst_63299 = (state_63348[(2)]);
var state_63348__$1 = (function (){var statearr_63383 = state_63348;
(statearr_63383[(11)] = inst_63299);

return statearr_63383;
})();
if(cljs.core.truth_(ledger)){
var statearr_63384_63415 = state_63348__$1;
(statearr_63384_63415[(1)] = (9));

} else {
var statearr_63385_63416 = state_63348__$1;
(statearr_63385_63416[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63386 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63386[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63386[(1)] = (1));

return statearr_63386;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63348){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63348);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63387){var ex__2417__auto__ = e63387;
var statearr_63388_63417 = state_63348;
(statearr_63388_63417[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63348[(4)]))){
var statearr_63389_63418 = state_63348;
(statearr_63389_63418[(1)] = cljs.core.first((state_63348[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63419 = state_63348;
state_63348 = G__63419;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63348){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63390 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63390[(6)] = c__2436__auto__);

return statearr_63390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63421 = arguments.length;
switch (G__63421) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_63456){
var state_val_63457 = (state_63456[(1)]);
if((state_val_63457 === (1))){
var state_63456__$1 = state_63456;
var statearr_63458_63480 = state_63456__$1;
(statearr_63458_63480[(2)] = null);

(statearr_63458_63480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (2))){
var _ = (function (){var statearr_63459 = state_63456;
(statearr_63459[(4)] = cljs.core.cons((5),(state_63456[(4)])));

return statearr_63459;
})();
var inst_63430 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_63456__$1 = state_63456;
if(cljs.core.truth_(inst_63430)){
var statearr_63460_63481 = state_63456__$1;
(statearr_63460_63481[(1)] = (6));

} else {
var statearr_63461_63482 = state_63456__$1;
(statearr_63461_63482[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (3))){
var inst_63454 = (state_63456[(2)]);
var state_63456__$1 = state_63456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63456__$1,inst_63454);
} else {
if((state_val_63457 === (4))){
var inst_63422 = (state_63456[(2)]);
var inst_63423 = cljs.core.clj__GT_js(inst_63422);
var inst_63424 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_63423) : reject.call(null,inst_63423));
var state_63456__$1 = state_63456;
var statearr_63463_63483 = state_63456__$1;
(statearr_63463_63483[(2)] = inst_63424);

(statearr_63463_63483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (5))){
var _ = (function (){var statearr_63464 = state_63456;
(statearr_63464[(4)] = cljs.core.rest((state_63456[(4)])));

return statearr_63464;
})();
var state_63456__$1 = state_63456;
var ex63462 = (state_63456__$1[(2)]);
var statearr_63465_63484 = state_63456__$1;
(statearr_63465_63484[(5)] = ex63462);


var statearr_63466_63485 = state_63456__$1;
(statearr_63466_63485[(1)] = (4));

(statearr_63466_63485[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (6))){
var state_63456__$1 = state_63456;
var statearr_63467_63486 = state_63456__$1;
(statearr_63467_63486[(2)] = null);

(statearr_63467_63486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (7))){
var inst_63433 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63434 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63435 = cljs.core.PersistentHashMap.fromArrays(inst_63433,inst_63434);
var inst_63436 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_63435);
var inst_63437 = (function(){throw inst_63436})();
var state_63456__$1 = state_63456;
var statearr_63468_63487 = state_63456__$1;
(statearr_63468_63487[(2)] = inst_63437);

(statearr_63468_63487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63457 === (8))){
var inst_63439 = (state_63456[(2)]);
var inst_63440 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63441 = [jwt,expire];
var inst_63442 = cljs.core.PersistentHashMap.fromArrays(inst_63440,inst_63441);
var inst_63443 = fluree.db.util.core.without_nils(inst_63442);
var inst_63444 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_63445 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63447 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63443,inst_63444,null];
var inst_63448 = (new cljs.core.PersistentVector(null,4,(5),inst_63446,inst_63447,null));
var inst_63449 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63445,inst_63448);
var inst_63450 = (function (){var _ = inst_63439;
var data = inst_63443;
var pc = inst_63444;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__63469 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__63469) : reject.call(null,G__63469));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__63470 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__63470) : resolve.call(null,G__63470));

}
});
})();
var inst_63451 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_63444,inst_63450);
var _ = (function (){var statearr_63471 = state_63456;
(statearr_63471[(4)] = cljs.core.rest((state_63456[(4)])));

return statearr_63471;
})();
var state_63456__$1 = (function (){var statearr_63472 = state_63456;
(statearr_63472[(7)] = inst_63449);

return statearr_63472;
})();
var statearr_63473_63488 = state_63456__$1;
(statearr_63473_63488[(2)] = inst_63451);

(statearr_63473_63488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2414__auto__ = null;
var fluree$db$connection_js$state_machine__2414__auto____0 = (function (){
var statearr_63474 = [null,null,null,null,null,null,null,null];
(statearr_63474[(0)] = fluree$db$connection_js$state_machine__2414__auto__);

(statearr_63474[(1)] = (1));

return statearr_63474;
});
var fluree$db$connection_js$state_machine__2414__auto____1 = (function (state_63456){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_63456);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e63475){var ex__2417__auto__ = e63475;
var statearr_63476_63489 = state_63456;
(statearr_63476_63489[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_63456[(4)]))){
var statearr_63477_63490 = state_63456;
(statearr_63477_63490[(1)] = cljs.core.first((state_63456[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63491 = state_63456;
state_63456 = G__63491;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2414__auto__ = function(state_63456){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2414__auto____1.call(this,state_63456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2414__auto____0;
fluree$db$connection_js$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2414__auto____1;
return fluree$db$connection_js$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_63478 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_63478[(6)] = c__2436__auto__);

return statearr_63478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

