// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___53444 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53495){
var state_val_53496 = (state_53495[(1)]);
if((state_val_53496 === (7))){
var inst_53490 = (state_53495[(2)]);
var _ = (function (){var statearr_53497 = state_53495;
(statearr_53497[(4)] = cljs.core.rest((state_53495[(4)])));

return statearr_53497;
})();
var state_53495__$1 = state_53495;
var statearr_53498_53525 = state_53495__$1;
(statearr_53498_53525[(2)] = inst_53490);

(statearr_53498_53525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (1))){
var state_53495__$1 = state_53495;
var statearr_53499_53526 = state_53495__$1;
(statearr_53499_53526[(2)] = null);

(statearr_53499_53526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (4))){
var inst_53445 = (state_53495[(2)]);
var state_53495__$1 = state_53495;
var statearr_53500_53527 = state_53495__$1;
(statearr_53500_53527[(2)] = inst_53445);

(statearr_53500_53527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (13))){
var inst_53486 = (state_53495[(2)]);
var state_53495__$1 = state_53495;
var statearr_53501_53528 = state_53495__$1;
(statearr_53501_53528[(2)] = inst_53486);

(statearr_53501_53528[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (6))){
var inst_53470 = (state_53495[(7)]);
var inst_53463 = (state_53495[(8)]);
var inst_53469 = cljs.core.seq(inst_53463);
var inst_53470__$1 = cljs.core.first(inst_53469);
var inst_53471 = cljs.core.next(inst_53469);
var inst_53472 = cljs.core.not(inst_53470__$1);
var state_53495__$1 = (function (){var statearr_53502 = state_53495;
(statearr_53502[(7)] = inst_53470__$1);

(statearr_53502[(9)] = inst_53471);

return statearr_53502;
})();
if(inst_53472){
var statearr_53503_53529 = state_53495__$1;
(statearr_53503_53529[(1)] = (8));

} else {
var statearr_53504_53530 = state_53495__$1;
(statearr_53504_53530[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (3))){
var inst_53493 = (state_53495[(2)]);
var state_53495__$1 = state_53495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53495__$1,inst_53493);
} else {
if((state_val_53496 === (12))){
var inst_53470 = (state_53495[(7)]);
var inst_53464 = (state_53495[(10)]);
var inst_53471 = (state_53495[(9)]);
var inst_53483 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53464,inst_53470);
var inst_53463 = inst_53471;
var inst_53464__$1 = inst_53483;
var state_53495__$1 = (function (){var statearr_53505 = state_53495;
(statearr_53505[(10)] = inst_53464__$1);

(statearr_53505[(8)] = inst_53463);

return statearr_53505;
})();
var statearr_53506_53531 = state_53495__$1;
(statearr_53506_53531[(2)] = null);

(statearr_53506_53531[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (2))){
var _ = (function (){var statearr_53507 = state_53495;
(statearr_53507[(4)] = cljs.core.cons((5),(state_53495[(4)])));

return statearr_53507;
})();
var inst_53458 = args;
var inst_53459 = cljs.core.seq(inst_53458);
var inst_53460 = cljs.core.first(inst_53459);
var inst_53461 = cljs.core.next(inst_53459);
var inst_53462 = cljs.core.PersistentVector.EMPTY;
var inst_53463 = inst_53458;
var inst_53464 = inst_53462;
var state_53495__$1 = (function (){var statearr_53508 = state_53495;
(statearr_53508[(11)] = inst_53461);

(statearr_53508[(10)] = inst_53464);

(statearr_53508[(12)] = inst_53460);

(statearr_53508[(8)] = inst_53463);

return statearr_53508;
})();
var statearr_53509_53532 = state_53495__$1;
(statearr_53509_53532[(2)] = null);

(statearr_53509_53532[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (11))){
var inst_53470 = (state_53495[(7)]);
var state_53495__$1 = state_53495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53495__$1,(14),inst_53470);
} else {
if((state_val_53496 === (9))){
var inst_53470 = (state_53495[(7)]);
var inst_53475 = fluree.db.util.async.channel_QMARK_(inst_53470);
var state_53495__$1 = state_53495;
if(inst_53475){
var statearr_53511_53533 = state_53495__$1;
(statearr_53511_53533[(1)] = (11));

} else {
var statearr_53512_53534 = state_53495__$1;
(statearr_53512_53534[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (5))){
var _ = (function (){var statearr_53513 = state_53495;
(statearr_53513[(4)] = cljs.core.rest((state_53495[(4)])));

return statearr_53513;
})();
var state_53495__$1 = state_53495;
var ex53510 = (state_53495__$1[(2)]);
var statearr_53514_53535 = state_53495__$1;
(statearr_53514_53535[(5)] = ex53510);


if((ex53510 instanceof Error)){
var statearr_53515_53536 = state_53495__$1;
(statearr_53515_53536[(1)] = (4));

(statearr_53515_53536[(5)] = null);

} else {
throw ex53510;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (14))){
var inst_53464 = (state_53495[(10)]);
var inst_53471 = (state_53495[(9)]);
var inst_53478 = (state_53495[(2)]);
var inst_53479 = fluree.db.util.async.throw_err(inst_53478);
var inst_53480 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53464,inst_53479);
var inst_53463 = inst_53471;
var inst_53464__$1 = inst_53480;
var state_53495__$1 = (function (){var statearr_53516 = state_53495;
(statearr_53516[(10)] = inst_53464__$1);

(statearr_53516[(8)] = inst_53463);

return statearr_53516;
})();
var statearr_53517_53537 = state_53495__$1;
(statearr_53517_53537[(2)] = null);

(statearr_53517_53537[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (10))){
var inst_53488 = (state_53495[(2)]);
var state_53495__$1 = state_53495;
var statearr_53518_53538 = state_53495__$1;
(statearr_53518_53538[(2)] = inst_53488);

(statearr_53518_53538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53496 === (8))){
var inst_53464 = (state_53495[(10)]);
var state_53495__$1 = state_53495;
var statearr_53519_53539 = state_53495__$1;
(statearr_53519_53539[(2)] = inst_53464);

(statearr_53519_53539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0 = (function (){
var statearr_53520 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53520[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__);

(statearr_53520[(1)] = (1));

return statearr_53520;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1 = (function (state_53495){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53495);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53521){var ex__2417__auto__ = e53521;
var statearr_53522_53540 = state_53495;
(statearr_53522_53540[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53495[(4)]))){
var statearr_53523_53541 = state_53495;
(statearr_53523_53541[(1)] = cljs.core.first((state_53495[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53542 = state_53495;
state_53495 = G__53542;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__ = function(state_53495){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1.call(this,state_53495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53524 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53524[(6)] = c__2436__auto__);

return statearr_53524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53543 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53543,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53543,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53591){
var state_val_53592 = (state_53591[(1)]);
if((state_val_53592 === (7))){
var state_53591__$1 = state_53591;
var statearr_53593_53622 = state_53591__$1;
(statearr_53593_53622[(2)] = coll);

(statearr_53593_53622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (1))){
var state_53591__$1 = state_53591;
var statearr_53594_53623 = state_53591__$1;
(statearr_53594_53623[(2)] = null);

(statearr_53594_53623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (4))){
var inst_53546 = (state_53591[(2)]);
var state_53591__$1 = state_53591;
var statearr_53595_53624 = state_53591__$1;
(statearr_53595_53624[(2)] = inst_53546);

(statearr_53595_53624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (15))){
var inst_53565 = (state_53591[(7)]);
var inst_53573 = (state_53591[(2)]);
var inst_53574 = fluree.db.dbfunctions.internal.nth(inst_53565,inst_53573);
var inst_53575 = cljs.core.count(inst_53565);
var inst_53576 = ((9) + inst_53575);
var inst_53577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53578 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53580 = [inst_53565,inst_53573];
var inst_53581 = (new cljs.core.PersistentVector(null,2,(5),inst_53579,inst_53580,null));
var inst_53582 = ["nth",inst_53581,inst_53574];
var inst_53583 = cljs.core.PersistentHashMap.fromArrays(inst_53578,inst_53582);
var inst_53584 = [inst_53583,inst_53576];
var inst_53585 = (new cljs.core.PersistentVector(null,2,(5),inst_53577,inst_53584,null));
var inst_53586 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53585);
var _ = (function (){var statearr_53596 = state_53591;
(statearr_53596[(4)] = cljs.core.rest((state_53591[(4)])));

return statearr_53596;
})();
var state_53591__$1 = (function (){var statearr_53597 = state_53591;
(statearr_53597[(8)] = inst_53586);

return statearr_53597;
})();
var statearr_53598_53625 = state_53591__$1;
(statearr_53598_53625[(2)] = inst_53574);

(statearr_53598_53625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (13))){
var state_53591__$1 = state_53591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53591__$1,(16),key);
} else {
if((state_val_53592 === (6))){
var state_53591__$1 = state_53591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53591__$1,(9),coll);
} else {
if((state_val_53592 === (3))){
var inst_53589 = (state_53591[(2)]);
var state_53591__$1 = state_53591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53591__$1,inst_53589);
} else {
if((state_val_53592 === (12))){
var inst_53565 = (state_53591[(2)]);
var inst_53566 = fluree.db.util.async.channel_QMARK_(key);
var state_53591__$1 = (function (){var statearr_53599 = state_53591;
(statearr_53599[(7)] = inst_53565);

return statearr_53599;
})();
if(inst_53566){
var statearr_53600_53626 = state_53591__$1;
(statearr_53600_53626[(1)] = (13));

} else {
var statearr_53601_53627 = state_53591__$1;
(statearr_53601_53627[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (2))){
var _ = (function (){var statearr_53602 = state_53591;
(statearr_53602[(4)] = cljs.core.cons((5),(state_53591[(4)])));

return statearr_53602;
})();
var inst_53552 = fluree.db.util.async.channel_QMARK_(coll);
var state_53591__$1 = state_53591;
if(inst_53552){
var statearr_53603_53628 = state_53591__$1;
(statearr_53603_53628[(1)] = (6));

} else {
var statearr_53604_53629 = state_53591__$1;
(statearr_53604_53629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (11))){
var inst_53559 = (state_53591[(9)]);
var state_53591__$1 = state_53591;
var statearr_53606_53630 = state_53591__$1;
(statearr_53606_53630[(2)] = inst_53559);

(statearr_53606_53630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (9))){
var inst_53555 = (state_53591[(2)]);
var inst_53556 = fluree.db.util.async.throw_err(inst_53555);
var state_53591__$1 = state_53591;
var statearr_53607_53631 = state_53591__$1;
(statearr_53607_53631[(2)] = inst_53556);

(statearr_53607_53631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (5))){
var _ = (function (){var statearr_53608 = state_53591;
(statearr_53608[(4)] = cljs.core.rest((state_53591[(4)])));

return statearr_53608;
})();
var state_53591__$1 = state_53591;
var ex53605 = (state_53591__$1[(2)]);
var statearr_53609_53632 = state_53591__$1;
(statearr_53609_53632[(5)] = ex53605);


if((ex53605 instanceof Error)){
var statearr_53610_53633 = state_53591__$1;
(statearr_53610_53633[(1)] = (4));

(statearr_53610_53633[(5)] = null);

} else {
throw ex53605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (14))){
var state_53591__$1 = state_53591;
var statearr_53611_53634 = state_53591__$1;
(statearr_53611_53634[(2)] = key);

(statearr_53611_53634[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (16))){
var inst_53569 = (state_53591[(2)]);
var inst_53570 = fluree.db.util.async.throw_err(inst_53569);
var state_53591__$1 = state_53591;
var statearr_53612_53635 = state_53591__$1;
(statearr_53612_53635[(2)] = inst_53570);

(statearr_53612_53635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (10))){
var inst_53559 = (state_53591[(9)]);
var inst_53562 = cljs.core.vec(inst_53559);
var state_53591__$1 = state_53591;
var statearr_53613_53636 = state_53591__$1;
(statearr_53613_53636[(2)] = inst_53562);

(statearr_53613_53636[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53592 === (8))){
var inst_53559 = (state_53591[(9)]);
var inst_53559__$1 = (state_53591[(2)]);
var inst_53560 = cljs.core.set_QMARK_(inst_53559__$1);
var state_53591__$1 = (function (){var statearr_53614 = state_53591;
(statearr_53614[(9)] = inst_53559__$1);

return statearr_53614;
})();
if(inst_53560){
var statearr_53615_53637 = state_53591__$1;
(statearr_53615_53637[(1)] = (10));

} else {
var statearr_53616_53638 = state_53591__$1;
(statearr_53616_53638[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0 = (function (){
var statearr_53617 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53617[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__);

(statearr_53617[(1)] = (1));

return statearr_53617;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1 = (function (state_53591){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53591);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53618){var ex__2417__auto__ = e53618;
var statearr_53619_53639 = state_53591;
(statearr_53619_53639[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53591[(4)]))){
var statearr_53620_53640 = state_53591;
(statearr_53620_53640[(1)] = cljs.core.first((state_53591[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53641 = state_53591;
state_53591 = G__53641;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__ = function(state_53591){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1.call(this,state_53591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53621 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53621[(6)] = c__2436__auto__);

return statearr_53621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53702){
var state_val_53703 = (state_53702[(1)]);
if((state_val_53703 === (7))){
var state_53702__$1 = state_53702;
var statearr_53704_53738 = state_53702__$1;
(statearr_53704_53738[(2)] = test);

(statearr_53704_53738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (20))){
var inst_53676 = (state_53702[(2)]);
var inst_53677 = fluree.db.util.async.throw_err(inst_53676);
var state_53702__$1 = state_53702;
var statearr_53705_53739 = state_53702__$1;
(statearr_53705_53739[(2)] = inst_53677);

(statearr_53705_53739[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (1))){
var state_53702__$1 = state_53702;
var statearr_53706_53740 = state_53702__$1;
(statearr_53706_53740[(2)] = null);

(statearr_53706_53740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (4))){
var inst_53642 = (state_53702[(2)]);
var state_53702__$1 = state_53702;
var statearr_53707_53741 = state_53702__$1;
(statearr_53707_53741[(2)] = inst_53642);

(statearr_53707_53741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (15))){
var inst_53660 = (state_53702[(7)]);
var inst_53668 = (state_53702[(2)]);
var inst_53669 = [inst_53668,f];
var inst_53670 = (new cljs.core.PersistentVector(null,2,(5),inst_53660,inst_53669,null));
var state_53702__$1 = state_53702;
var statearr_53708_53742 = state_53702__$1;
(statearr_53708_53742[(2)] = inst_53670);

(statearr_53708_53742[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (13))){
var state_53702__$1 = state_53702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53702__$1,(16),t);
} else {
if((state_val_53703 === (6))){
var state_53702__$1 = state_53702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53702__$1,(9),test);
} else {
if((state_val_53703 === (17))){
var state_53702__$1 = state_53702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53702__$1,(20),f);
} else {
if((state_val_53703 === (3))){
var inst_53700 = (state_53702[(2)]);
var state_53702__$1 = state_53702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53702__$1,inst_53700);
} else {
if((state_val_53703 === (12))){
var inst_53658 = (state_53702[(8)]);
var inst_53684 = (state_53702[(2)]);
var inst_53685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53684,(0),null);
var inst_53686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53684,(1),null);
var inst_53687 = fluree.db.dbfunctions.internal.if_else(inst_53658,inst_53685,inst_53686);
var inst_53688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53689 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53691 = [inst_53658,inst_53685,inst_53686];
var inst_53692 = (new cljs.core.PersistentVector(null,3,(5),inst_53690,inst_53691,null));
var inst_53693 = ["if-else",inst_53692,inst_53687];
var inst_53694 = cljs.core.PersistentHashMap.fromArrays(inst_53689,inst_53693);
var inst_53695 = [inst_53694,(10)];
var inst_53696 = (new cljs.core.PersistentVector(null,2,(5),inst_53688,inst_53695,null));
var inst_53697 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53696);
var _ = (function (){var statearr_53709 = state_53702;
(statearr_53709[(4)] = cljs.core.rest((state_53702[(4)])));

return statearr_53709;
})();
var state_53702__$1 = (function (){var statearr_53710 = state_53702;
(statearr_53710[(9)] = inst_53697);

return statearr_53710;
})();
var statearr_53711_53743 = state_53702__$1;
(statearr_53711_53743[(2)] = inst_53687);

(statearr_53711_53743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (2))){
var _ = (function (){var statearr_53712 = state_53702;
(statearr_53712[(4)] = cljs.core.cons((5),(state_53702[(4)])));

return statearr_53712;
})();
var inst_53651 = fluree.db.util.async.channel_QMARK_(test);
var state_53702__$1 = state_53702;
if(inst_53651){
var statearr_53713_53744 = state_53702__$1;
(statearr_53713_53744[(1)] = (6));

} else {
var statearr_53714_53745 = state_53702__$1;
(statearr_53714_53745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (19))){
var inst_53672 = (state_53702[(10)]);
var inst_53680 = (state_53702[(2)]);
var inst_53681 = [f,inst_53680];
var inst_53682 = (new cljs.core.PersistentVector(null,2,(5),inst_53672,inst_53681,null));
var state_53702__$1 = state_53702;
var statearr_53715_53746 = state_53702__$1;
(statearr_53715_53746[(2)] = inst_53682);

(statearr_53715_53746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (11))){
var inst_53672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53673 = fluree.db.util.async.channel_QMARK_(f);
var state_53702__$1 = (function (){var statearr_53717 = state_53702;
(statearr_53717[(10)] = inst_53672);

return statearr_53717;
})();
if(inst_53673){
var statearr_53718_53747 = state_53702__$1;
(statearr_53718_53747[(1)] = (17));

} else {
var statearr_53719_53748 = state_53702__$1;
(statearr_53719_53748[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (9))){
var inst_53654 = (state_53702[(2)]);
var inst_53655 = fluree.db.util.async.throw_err(inst_53654);
var state_53702__$1 = state_53702;
var statearr_53720_53749 = state_53702__$1;
(statearr_53720_53749[(2)] = inst_53655);

(statearr_53720_53749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (5))){
var _ = (function (){var statearr_53721 = state_53702;
(statearr_53721[(4)] = cljs.core.rest((state_53702[(4)])));

return statearr_53721;
})();
var state_53702__$1 = state_53702;
var ex53716 = (state_53702__$1[(2)]);
var statearr_53722_53750 = state_53702__$1;
(statearr_53722_53750[(5)] = ex53716);


if((ex53716 instanceof Error)){
var statearr_53723_53751 = state_53702__$1;
(statearr_53723_53751[(1)] = (4));

(statearr_53723_53751[(5)] = null);

} else {
throw ex53716;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (14))){
var state_53702__$1 = state_53702;
var statearr_53724_53752 = state_53702__$1;
(statearr_53724_53752[(2)] = t);

(statearr_53724_53752[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (16))){
var inst_53664 = (state_53702[(2)]);
var inst_53665 = fluree.db.util.async.throw_err(inst_53664);
var state_53702__$1 = state_53702;
var statearr_53725_53753 = state_53702__$1;
(statearr_53725_53753[(2)] = inst_53665);

(statearr_53725_53753[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (10))){
var inst_53660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53661 = fluree.db.util.async.channel_QMARK_(t);
var state_53702__$1 = (function (){var statearr_53726 = state_53702;
(statearr_53726[(7)] = inst_53660);

return statearr_53726;
})();
if(inst_53661){
var statearr_53727_53754 = state_53702__$1;
(statearr_53727_53754[(1)] = (13));

} else {
var statearr_53728_53755 = state_53702__$1;
(statearr_53728_53755[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (18))){
var state_53702__$1 = state_53702;
var statearr_53729_53756 = state_53702__$1;
(statearr_53729_53756[(2)] = f);

(statearr_53729_53756[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53703 === (8))){
var inst_53658 = (state_53702[(8)]);
var inst_53658__$1 = (state_53702[(2)]);
var state_53702__$1 = (function (){var statearr_53730 = state_53702;
(statearr_53730[(8)] = inst_53658__$1);

return statearr_53730;
})();
if(cljs.core.truth_(inst_53658__$1)){
var statearr_53731_53757 = state_53702__$1;
(statearr_53731_53757[(1)] = (10));

} else {
var statearr_53732_53758 = state_53702__$1;
(statearr_53732_53758[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0 = (function (){
var statearr_53733 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53733[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__);

(statearr_53733[(1)] = (1));

return statearr_53733;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1 = (function (state_53702){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53702);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53734){var ex__2417__auto__ = e53734;
var statearr_53735_53759 = state_53702;
(statearr_53735_53759[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53702[(4)]))){
var statearr_53736_53760 = state_53702;
(statearr_53736_53760[(1)] = cljs.core.first((state_53702[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53761 = state_53702;
state_53702 = G__53761;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__ = function(state_53702){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1.call(this,state_53702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53737 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53737[(6)] = c__2436__auto__);

return statearr_53737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53791){
var state_val_53792 = (state_53791[(1)]);
if((state_val_53792 === (7))){
var state_53791__$1 = state_53791;
var statearr_53793_53812 = state_53791__$1;
(statearr_53793_53812[(2)] = arg);

(statearr_53793_53812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (1))){
var state_53791__$1 = state_53791;
var statearr_53794_53813 = state_53791__$1;
(statearr_53794_53813[(2)] = null);

(statearr_53794_53813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (4))){
var inst_53762 = (state_53791[(2)]);
var state_53791__$1 = state_53791;
var statearr_53795_53814 = state_53791__$1;
(statearr_53795_53814[(2)] = inst_53762);

(statearr_53795_53814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (6))){
var state_53791__$1 = state_53791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53791__$1,(9),arg);
} else {
if((state_val_53792 === (3))){
var inst_53789 = (state_53791[(2)]);
var state_53791__$1 = state_53791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53791__$1,inst_53789);
} else {
if((state_val_53792 === (2))){
var _ = (function (){var statearr_53797 = state_53791;
(statearr_53797[(4)] = cljs.core.cons((5),(state_53791[(4)])));

return statearr_53797;
})();
var inst_53768 = fluree.db.util.async.channel_QMARK_(arg);
var state_53791__$1 = state_53791;
if(inst_53768){
var statearr_53798_53815 = state_53791__$1;
(statearr_53798_53815[(1)] = (6));

} else {
var statearr_53799_53816 = state_53791__$1;
(statearr_53799_53816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (9))){
var inst_53771 = (state_53791[(2)]);
var inst_53772 = fluree.db.util.async.throw_err(inst_53771);
var state_53791__$1 = state_53791;
var statearr_53800_53817 = state_53791__$1;
(statearr_53800_53817[(2)] = inst_53772);

(statearr_53800_53817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (5))){
var _ = (function (){var statearr_53801 = state_53791;
(statearr_53801[(4)] = cljs.core.rest((state_53791[(4)])));

return statearr_53801;
})();
var state_53791__$1 = state_53791;
var ex53796 = (state_53791__$1[(2)]);
var statearr_53802_53818 = state_53791__$1;
(statearr_53802_53818[(5)] = ex53796);


if((ex53796 instanceof Error)){
var statearr_53803_53819 = state_53791__$1;
(statearr_53803_53819[(1)] = (4));

(statearr_53803_53819[(5)] = null);

} else {
throw ex53796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53792 === (8))){
var inst_53775 = (state_53791[(2)]);
var inst_53776 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_53775);
var inst_53777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53778 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53780 = [inst_53775];
var inst_53781 = (new cljs.core.PersistentVector(null,1,(5),inst_53779,inst_53780,null));
var inst_53782 = ["nil?",inst_53781,inst_53776];
var inst_53783 = cljs.core.PersistentHashMap.fromArrays(inst_53778,inst_53782);
var inst_53784 = [inst_53783,(10)];
var inst_53785 = (new cljs.core.PersistentVector(null,2,(5),inst_53777,inst_53784,null));
var inst_53786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53785);
var _ = (function (){var statearr_53804 = state_53791;
(statearr_53804[(4)] = cljs.core.rest((state_53791[(4)])));

return statearr_53804;
})();
var state_53791__$1 = (function (){var statearr_53805 = state_53791;
(statearr_53805[(7)] = inst_53786);

return statearr_53805;
})();
var statearr_53806_53820 = state_53791__$1;
(statearr_53806_53820[(2)] = inst_53776);

(statearr_53806_53820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_53807 = [null,null,null,null,null,null,null,null];
(statearr_53807[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__);

(statearr_53807[(1)] = (1));

return statearr_53807;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1 = (function (state_53791){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53791);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53808){var ex__2417__auto__ = e53808;
var statearr_53809_53821 = state_53791;
(statearr_53809_53821[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53791[(4)]))){
var statearr_53810_53822 = state_53791;
(statearr_53810_53822[(1)] = cljs.core.first((state_53791[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53823 = state_53791;
state_53791 = G__53823;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__ = function(state_53791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1.call(this,state_53791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53811 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53811[(6)] = c__2436__auto__);

return statearr_53811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53853){
var state_val_53854 = (state_53853[(1)]);
if((state_val_53854 === (7))){
var state_53853__$1 = state_53853;
var statearr_53855_53874 = state_53853__$1;
(statearr_53855_53874[(2)] = arg);

(statearr_53855_53874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (1))){
var state_53853__$1 = state_53853;
var statearr_53856_53875 = state_53853__$1;
(statearr_53856_53875[(2)] = null);

(statearr_53856_53875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (4))){
var inst_53824 = (state_53853[(2)]);
var state_53853__$1 = state_53853;
var statearr_53857_53876 = state_53853__$1;
(statearr_53857_53876[(2)] = inst_53824);

(statearr_53857_53876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (6))){
var state_53853__$1 = state_53853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53853__$1,(9),arg);
} else {
if((state_val_53854 === (3))){
var inst_53851 = (state_53853[(2)]);
var state_53853__$1 = state_53853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53853__$1,inst_53851);
} else {
if((state_val_53854 === (2))){
var _ = (function (){var statearr_53859 = state_53853;
(statearr_53859[(4)] = cljs.core.cons((5),(state_53853[(4)])));

return statearr_53859;
})();
var inst_53830 = fluree.db.util.async.channel_QMARK_(arg);
var state_53853__$1 = state_53853;
if(inst_53830){
var statearr_53860_53877 = state_53853__$1;
(statearr_53860_53877[(1)] = (6));

} else {
var statearr_53861_53878 = state_53853__$1;
(statearr_53861_53878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (9))){
var inst_53833 = (state_53853[(2)]);
var inst_53834 = fluree.db.util.async.throw_err(inst_53833);
var state_53853__$1 = state_53853;
var statearr_53862_53879 = state_53853__$1;
(statearr_53862_53879[(2)] = inst_53834);

(statearr_53862_53879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (5))){
var _ = (function (){var statearr_53863 = state_53853;
(statearr_53863[(4)] = cljs.core.rest((state_53853[(4)])));

return statearr_53863;
})();
var state_53853__$1 = state_53853;
var ex53858 = (state_53853__$1[(2)]);
var statearr_53864_53880 = state_53853__$1;
(statearr_53864_53880[(5)] = ex53858);


if((ex53858 instanceof Error)){
var statearr_53865_53881 = state_53853__$1;
(statearr_53865_53881[(1)] = (4));

(statearr_53865_53881[(5)] = null);

} else {
throw ex53858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53854 === (8))){
var inst_53837 = (state_53853[(2)]);
var inst_53838 = fluree.db.dbfunctions.internal.not(inst_53837);
var inst_53839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53840 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53842 = [inst_53837];
var inst_53843 = (new cljs.core.PersistentVector(null,1,(5),inst_53841,inst_53842,null));
var inst_53844 = ["not?",inst_53843,inst_53838];
var inst_53845 = cljs.core.PersistentHashMap.fromArrays(inst_53840,inst_53844);
var inst_53846 = [inst_53845,(10)];
var inst_53847 = (new cljs.core.PersistentVector(null,2,(5),inst_53839,inst_53846,null));
var inst_53848 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53847);
var _ = (function (){var statearr_53866 = state_53853;
(statearr_53866[(4)] = cljs.core.rest((state_53853[(4)])));

return statearr_53866;
})();
var state_53853__$1 = (function (){var statearr_53867 = state_53853;
(statearr_53867[(7)] = inst_53848);

return statearr_53867;
})();
var statearr_53868_53882 = state_53853__$1;
(statearr_53868_53882[(2)] = inst_53838);

(statearr_53868_53882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0 = (function (){
var statearr_53869 = [null,null,null,null,null,null,null,null];
(statearr_53869[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__);

(statearr_53869[(1)] = (1));

return statearr_53869;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1 = (function (state_53853){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53853);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53870){var ex__2417__auto__ = e53870;
var statearr_53871_53883 = state_53853;
(statearr_53871_53883[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53853[(4)]))){
var statearr_53872_53884 = state_53853;
(statearr_53872_53884[(1)] = cljs.core.first((state_53853[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53885 = state_53853;
state_53853 = G__53885;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__ = function(state_53853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1.call(this,state_53853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53873 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53873[(6)] = c__2436__auto__);

return statearr_53873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53915){
var state_val_53916 = (state_53915[(1)]);
if((state_val_53916 === (7))){
var state_53915__$1 = state_53915;
var statearr_53917_53936 = state_53915__$1;
(statearr_53917_53936[(2)] = arg);

(statearr_53917_53936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (1))){
var state_53915__$1 = state_53915;
var statearr_53918_53937 = state_53915__$1;
(statearr_53918_53937[(2)] = null);

(statearr_53918_53937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (4))){
var inst_53886 = (state_53915[(2)]);
var state_53915__$1 = state_53915;
var statearr_53919_53938 = state_53915__$1;
(statearr_53919_53938[(2)] = inst_53886);

(statearr_53919_53938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (6))){
var state_53915__$1 = state_53915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53915__$1,(9),arg);
} else {
if((state_val_53916 === (3))){
var inst_53913 = (state_53915[(2)]);
var state_53915__$1 = state_53915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53915__$1,inst_53913);
} else {
if((state_val_53916 === (2))){
var _ = (function (){var statearr_53921 = state_53915;
(statearr_53921[(4)] = cljs.core.cons((5),(state_53915[(4)])));

return statearr_53921;
})();
var inst_53892 = fluree.db.util.async.channel_QMARK_(arg);
var state_53915__$1 = state_53915;
if(inst_53892){
var statearr_53922_53939 = state_53915__$1;
(statearr_53922_53939[(1)] = (6));

} else {
var statearr_53923_53940 = state_53915__$1;
(statearr_53923_53940[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (9))){
var inst_53895 = (state_53915[(2)]);
var inst_53896 = fluree.db.util.async.throw_err(inst_53895);
var state_53915__$1 = state_53915;
var statearr_53924_53941 = state_53915__$1;
(statearr_53924_53941[(2)] = inst_53896);

(statearr_53924_53941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (5))){
var _ = (function (){var statearr_53925 = state_53915;
(statearr_53925[(4)] = cljs.core.rest((state_53915[(4)])));

return statearr_53925;
})();
var state_53915__$1 = state_53915;
var ex53920 = (state_53915__$1[(2)]);
var statearr_53926_53942 = state_53915__$1;
(statearr_53926_53942[(5)] = ex53920);


if((ex53920 instanceof Error)){
var statearr_53927_53943 = state_53915__$1;
(statearr_53927_53943[(1)] = (4));

(statearr_53927_53943[(5)] = null);

} else {
throw ex53920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53916 === (8))){
var inst_53899 = (state_53915[(2)]);
var inst_53900 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53899);
var inst_53901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53902 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53904 = [inst_53899];
var inst_53905 = (new cljs.core.PersistentVector(null,1,(5),inst_53903,inst_53904,null));
var inst_53906 = ["empty?",inst_53905,inst_53900];
var inst_53907 = cljs.core.PersistentHashMap.fromArrays(inst_53902,inst_53906);
var inst_53908 = [inst_53907,(10)];
var inst_53909 = (new cljs.core.PersistentVector(null,2,(5),inst_53901,inst_53908,null));
var inst_53910 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53909);
var _ = (function (){var statearr_53928 = state_53915;
(statearr_53928[(4)] = cljs.core.rest((state_53915[(4)])));

return statearr_53928;
})();
var state_53915__$1 = (function (){var statearr_53929 = state_53915;
(statearr_53929[(7)] = inst_53910);

return statearr_53929;
})();
var statearr_53930_53944 = state_53915__$1;
(statearr_53930_53944[(2)] = inst_53900);

(statearr_53930_53944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_53931 = [null,null,null,null,null,null,null,null];
(statearr_53931[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__);

(statearr_53931[(1)] = (1));

return statearr_53931;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1 = (function (state_53915){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53915);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53932){var ex__2417__auto__ = e53932;
var statearr_53933_53945 = state_53915;
(statearr_53933_53945[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53915[(4)]))){
var statearr_53934_53946 = state_53915;
(statearr_53934_53946[(1)] = cljs.core.first((state_53915[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53947 = state_53915;
state_53915 = G__53947;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__ = function(state_53915){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1.call(this,state_53915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53935 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53935[(6)] = c__2436__auto__);

return statearr_53935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53992 = arguments.length;
var i__4737__auto___53993 = (0);
while(true){
if((i__4737__auto___53993 < len__4736__auto___53992)){
args__4742__auto__.push((arguments[i__4737__auto___53993]));

var G__53994 = (i__4737__auto___53993 + (1));
i__4737__auto___53993 = G__53994;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_53975){
var state_val_53976 = (state_53975[(1)]);
if((state_val_53976 === (1))){
var state_53975__$1 = state_53975;
var statearr_53977_53995 = state_53975__$1;
(statearr_53977_53995[(2)] = null);

(statearr_53977_53995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53976 === (2))){
var _ = (function (){var statearr_53978 = state_53975;
(statearr_53978[(4)] = cljs.core.cons((5),(state_53975[(4)])));

return statearr_53978;
})();
var inst_53956 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53975__$1 = state_53975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53975__$1,(6),inst_53956);
} else {
if((state_val_53976 === (3))){
var inst_53973 = (state_53975[(2)]);
var state_53975__$1 = state_53975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53975__$1,inst_53973);
} else {
if((state_val_53976 === (4))){
var inst_53950 = (state_53975[(2)]);
var state_53975__$1 = state_53975;
var statearr_53980_53996 = state_53975__$1;
(statearr_53980_53996[(2)] = inst_53950);

(statearr_53980_53996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53976 === (5))){
var _ = (function (){var statearr_53981 = state_53975;
(statearr_53981[(4)] = cljs.core.rest((state_53975[(4)])));

return statearr_53981;
})();
var state_53975__$1 = state_53975;
var ex53979 = (state_53975__$1[(2)]);
var statearr_53982_53997 = state_53975__$1;
(statearr_53982_53997[(5)] = ex53979);


if((ex53979 instanceof Error)){
var statearr_53983_53998 = state_53975__$1;
(statearr_53983_53998[(1)] = (4));

(statearr_53983_53998[(5)] = null);

} else {
throw ex53979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53976 === (6))){
var inst_53958 = (state_53975[(2)]);
var inst_53959 = fluree.db.util.async.throw_err(inst_53958);
var inst_53960 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53959);
var inst_53961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53962 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53964 = [inst_53959];
var inst_53965 = (new cljs.core.PersistentVector(null,1,(5),inst_53963,inst_53964,null));
var inst_53966 = ["str",inst_53965,inst_53960];
var inst_53967 = cljs.core.PersistentHashMap.fromArrays(inst_53962,inst_53966);
var inst_53968 = [inst_53967,(10)];
var inst_53969 = (new cljs.core.PersistentVector(null,2,(5),inst_53961,inst_53968,null));
var inst_53970 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53969);
var _ = (function (){var statearr_53984 = state_53975;
(statearr_53984[(4)] = cljs.core.rest((state_53975[(4)])));

return statearr_53984;
})();
var state_53975__$1 = (function (){var statearr_53985 = state_53975;
(statearr_53985[(7)] = inst_53970);

return statearr_53985;
})();
var statearr_53986_53999 = state_53975__$1;
(statearr_53986_53999[(2)] = inst_53960);

(statearr_53986_53999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_53987 = [null,null,null,null,null,null,null,null];
(statearr_53987[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_53987[(1)] = (1));

return statearr_53987;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_53975){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_53975);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e53988){var ex__2417__auto__ = e53988;
var statearr_53989_54000 = state_53975;
(statearr_53989_54000[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_53975[(4)]))){
var statearr_53990_54001 = state_53975;
(statearr_53990_54001[(1)] = cljs.core.first((state_53975[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54002 = state_53975;
state_53975 = G__54002;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_53975){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_53975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_53991 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_53991[(6)] = c__2436__auto__);

return statearr_53991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53948){
var G__53949 = cljs.core.first(seq53948);
var seq53948__$1 = cljs.core.next(seq53948);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53949,seq53948__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54028){
var state_val_54029 = (state_54028[(1)]);
if((state_val_54029 === (1))){
var state_54028__$1 = state_54028;
var statearr_54030_54045 = state_54028__$1;
(statearr_54030_54045[(2)] = null);

(statearr_54030_54045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54029 === (2))){
var _ = (function (){var statearr_54031 = state_54028;
(statearr_54031[(4)] = cljs.core.cons((5),(state_54028[(4)])));

return statearr_54031;
})();
var inst_54009 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54028__$1 = state_54028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54028__$1,(6),inst_54009);
} else {
if((state_val_54029 === (3))){
var inst_54026 = (state_54028[(2)]);
var state_54028__$1 = state_54028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54028__$1,inst_54026);
} else {
if((state_val_54029 === (4))){
var inst_54003 = (state_54028[(2)]);
var state_54028__$1 = state_54028;
var statearr_54033_54046 = state_54028__$1;
(statearr_54033_54046[(2)] = inst_54003);

(statearr_54033_54046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54029 === (5))){
var _ = (function (){var statearr_54034 = state_54028;
(statearr_54034[(4)] = cljs.core.rest((state_54028[(4)])));

return statearr_54034;
})();
var state_54028__$1 = state_54028;
var ex54032 = (state_54028__$1[(2)]);
var statearr_54035_54047 = state_54028__$1;
(statearr_54035_54047[(5)] = ex54032);


if((ex54032 instanceof Error)){
var statearr_54036_54048 = state_54028__$1;
(statearr_54036_54048[(1)] = (4));

(statearr_54036_54048[(5)] = null);

} else {
throw ex54032;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54029 === (6))){
var inst_54011 = (state_54028[(2)]);
var inst_54012 = fluree.db.util.async.throw_err(inst_54011);
var inst_54013 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54012);
var inst_54014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54015 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54017 = [inst_54012];
var inst_54018 = (new cljs.core.PersistentVector(null,1,(5),inst_54016,inst_54017,null));
var inst_54019 = ["subs",inst_54018,inst_54013];
var inst_54020 = cljs.core.PersistentHashMap.fromArrays(inst_54015,inst_54019);
var inst_54021 = [inst_54020,(30)];
var inst_54022 = (new cljs.core.PersistentVector(null,2,(5),inst_54014,inst_54021,null));
var inst_54023 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54022);
var _ = (function (){var statearr_54037 = state_54028;
(statearr_54037[(4)] = cljs.core.rest((state_54028[(4)])));

return statearr_54037;
})();
var state_54028__$1 = (function (){var statearr_54038 = state_54028;
(statearr_54038[(7)] = inst_54023);

return statearr_54038;
})();
var statearr_54039_54049 = state_54028__$1;
(statearr_54039_54049[(2)] = inst_54013);

(statearr_54039_54049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____0 = (function (){
var statearr_54040 = [null,null,null,null,null,null,null,null];
(statearr_54040[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__);

(statearr_54040[(1)] = (1));

return statearr_54040;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____1 = (function (state_54028){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54028);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54041){var ex__2417__auto__ = e54041;
var statearr_54042_54050 = state_54028;
(statearr_54042_54050[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54028[(4)]))){
var statearr_54043_54051 = state_54028;
(statearr_54043_54051[(1)] = cljs.core.first((state_54028[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54052 = state_54028;
state_54028 = G__54052;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__ = function(state_54028){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____1.call(this,state_54028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54044 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54044[(6)] = c__2436__auto__);

return statearr_54044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54082){
var state_val_54083 = (state_54082[(1)]);
if((state_val_54083 === (7))){
var state_54082__$1 = state_54082;
var statearr_54084_54103 = state_54082__$1;
(statearr_54084_54103[(2)] = str);

(statearr_54084_54103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (1))){
var state_54082__$1 = state_54082;
var statearr_54085_54104 = state_54082__$1;
(statearr_54085_54104[(2)] = null);

(statearr_54085_54104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (4))){
var inst_54053 = (state_54082[(2)]);
var state_54082__$1 = state_54082;
var statearr_54086_54105 = state_54082__$1;
(statearr_54086_54105[(2)] = inst_54053);

(statearr_54086_54105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (6))){
var state_54082__$1 = state_54082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54082__$1,(9),str);
} else {
if((state_val_54083 === (3))){
var inst_54080 = (state_54082[(2)]);
var state_54082__$1 = state_54082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54082__$1,inst_54080);
} else {
if((state_val_54083 === (2))){
var _ = (function (){var statearr_54088 = state_54082;
(statearr_54088[(4)] = cljs.core.cons((5),(state_54082[(4)])));

return statearr_54088;
})();
var inst_54059 = fluree.db.util.async.channel_QMARK_(str);
var state_54082__$1 = state_54082;
if(inst_54059){
var statearr_54089_54106 = state_54082__$1;
(statearr_54089_54106[(1)] = (6));

} else {
var statearr_54090_54107 = state_54082__$1;
(statearr_54090_54107[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (9))){
var inst_54062 = (state_54082[(2)]);
var inst_54063 = fluree.db.util.async.throw_err(inst_54062);
var state_54082__$1 = state_54082;
var statearr_54091_54108 = state_54082__$1;
(statearr_54091_54108[(2)] = inst_54063);

(statearr_54091_54108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (5))){
var _ = (function (){var statearr_54092 = state_54082;
(statearr_54092[(4)] = cljs.core.rest((state_54082[(4)])));

return statearr_54092;
})();
var state_54082__$1 = state_54082;
var ex54087 = (state_54082__$1[(2)]);
var statearr_54093_54109 = state_54082__$1;
(statearr_54093_54109[(5)] = ex54087);


if((ex54087 instanceof Error)){
var statearr_54094_54110 = state_54082__$1;
(statearr_54094_54110[(1)] = (4));

(statearr_54094_54110[(5)] = null);

} else {
throw ex54087;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54083 === (8))){
var inst_54066 = (state_54082[(2)]);
var inst_54067 = fluree.db.dbfunctions.internal.lower_case(inst_54066);
var inst_54068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54069 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54071 = [inst_54066];
var inst_54072 = (new cljs.core.PersistentVector(null,1,(5),inst_54070,inst_54071,null));
var inst_54073 = ["lower-case",inst_54072,inst_54067];
var inst_54074 = cljs.core.PersistentHashMap.fromArrays(inst_54069,inst_54073);
var inst_54075 = [inst_54074,(10)];
var inst_54076 = (new cljs.core.PersistentVector(null,2,(5),inst_54068,inst_54075,null));
var inst_54077 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54076);
var _ = (function (){var statearr_54095 = state_54082;
(statearr_54095[(4)] = cljs.core.rest((state_54082[(4)])));

return statearr_54095;
})();
var state_54082__$1 = (function (){var statearr_54096 = state_54082;
(statearr_54096[(7)] = inst_54077);

return statearr_54096;
})();
var statearr_54097_54111 = state_54082__$1;
(statearr_54097_54111[(2)] = inst_54067);

(statearr_54097_54111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0 = (function (){
var statearr_54098 = [null,null,null,null,null,null,null,null];
(statearr_54098[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__);

(statearr_54098[(1)] = (1));

return statearr_54098;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1 = (function (state_54082){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54082);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54099){var ex__2417__auto__ = e54099;
var statearr_54100_54112 = state_54082;
(statearr_54100_54112[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54082[(4)]))){
var statearr_54101_54113 = state_54082;
(statearr_54101_54113[(1)] = cljs.core.first((state_54082[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54114 = state_54082;
state_54082 = G__54114;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__ = function(state_54082){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1.call(this,state_54082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54102 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54102[(6)] = c__2436__auto__);

return statearr_54102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54144){
var state_val_54145 = (state_54144[(1)]);
if((state_val_54145 === (7))){
var state_54144__$1 = state_54144;
var statearr_54146_54165 = state_54144__$1;
(statearr_54146_54165[(2)] = str);

(statearr_54146_54165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (1))){
var state_54144__$1 = state_54144;
var statearr_54147_54166 = state_54144__$1;
(statearr_54147_54166[(2)] = null);

(statearr_54147_54166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (4))){
var inst_54115 = (state_54144[(2)]);
var state_54144__$1 = state_54144;
var statearr_54148_54167 = state_54144__$1;
(statearr_54148_54167[(2)] = inst_54115);

(statearr_54148_54167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (6))){
var state_54144__$1 = state_54144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54144__$1,(9),str);
} else {
if((state_val_54145 === (3))){
var inst_54142 = (state_54144[(2)]);
var state_54144__$1 = state_54144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54144__$1,inst_54142);
} else {
if((state_val_54145 === (2))){
var _ = (function (){var statearr_54150 = state_54144;
(statearr_54150[(4)] = cljs.core.cons((5),(state_54144[(4)])));

return statearr_54150;
})();
var inst_54121 = fluree.db.util.async.channel_QMARK_(str);
var state_54144__$1 = state_54144;
if(inst_54121){
var statearr_54151_54168 = state_54144__$1;
(statearr_54151_54168[(1)] = (6));

} else {
var statearr_54152_54169 = state_54144__$1;
(statearr_54152_54169[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (9))){
var inst_54124 = (state_54144[(2)]);
var inst_54125 = fluree.db.util.async.throw_err(inst_54124);
var state_54144__$1 = state_54144;
var statearr_54153_54170 = state_54144__$1;
(statearr_54153_54170[(2)] = inst_54125);

(statearr_54153_54170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (5))){
var _ = (function (){var statearr_54154 = state_54144;
(statearr_54154[(4)] = cljs.core.rest((state_54144[(4)])));

return statearr_54154;
})();
var state_54144__$1 = state_54144;
var ex54149 = (state_54144__$1[(2)]);
var statearr_54155_54171 = state_54144__$1;
(statearr_54155_54171[(5)] = ex54149);


if((ex54149 instanceof Error)){
var statearr_54156_54172 = state_54144__$1;
(statearr_54156_54172[(1)] = (4));

(statearr_54156_54172[(5)] = null);

} else {
throw ex54149;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54145 === (8))){
var inst_54128 = (state_54144[(2)]);
var inst_54129 = fluree.db.dbfunctions.internal.upper_case(inst_54128);
var inst_54130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54133 = [inst_54128];
var inst_54134 = (new cljs.core.PersistentVector(null,1,(5),inst_54132,inst_54133,null));
var inst_54135 = ["upper-case",inst_54134,inst_54129];
var inst_54136 = cljs.core.PersistentHashMap.fromArrays(inst_54131,inst_54135);
var inst_54137 = [inst_54136,(10)];
var inst_54138 = (new cljs.core.PersistentVector(null,2,(5),inst_54130,inst_54137,null));
var inst_54139 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54138);
var _ = (function (){var statearr_54157 = state_54144;
(statearr_54157[(4)] = cljs.core.rest((state_54144[(4)])));

return statearr_54157;
})();
var state_54144__$1 = (function (){var statearr_54158 = state_54144;
(statearr_54158[(7)] = inst_54139);

return statearr_54158;
})();
var statearr_54159_54173 = state_54144__$1;
(statearr_54159_54173[(2)] = inst_54129);

(statearr_54159_54173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0 = (function (){
var statearr_54160 = [null,null,null,null,null,null,null,null];
(statearr_54160[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__);

(statearr_54160[(1)] = (1));

return statearr_54160;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1 = (function (state_54144){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54144);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54161){var ex__2417__auto__ = e54161;
var statearr_54162_54174 = state_54144;
(statearr_54162_54174[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54144[(4)]))){
var statearr_54163_54175 = state_54144;
(statearr_54163_54175[(1)] = cljs.core.first((state_54144[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54176 = state_54144;
state_54144 = G__54176;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__ = function(state_54144){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1.call(this,state_54144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54164 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54164[(6)] = c__2436__auto__);

return statearr_54164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54178 = arguments.length;
switch (G__54178) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54206){
var state_val_54207 = (state_54206[(1)]);
if((state_val_54207 === (1))){
var state_54206__$1 = state_54206;
var statearr_54208_54224 = state_54206__$1;
(statearr_54208_54224[(2)] = null);

(statearr_54208_54224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (2))){
var _ = (function (){var statearr_54209 = state_54206;
(statearr_54209[(4)] = cljs.core.cons((5),(state_54206[(4)])));

return statearr_54209;
})();
var inst_54188 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54206__$1,(6),inst_54188);
} else {
if((state_val_54207 === (3))){
var inst_54204 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54206__$1,inst_54204);
} else {
if((state_val_54207 === (4))){
var inst_54179 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
var statearr_54211_54225 = state_54206__$1;
(statearr_54211_54225[(2)] = inst_54179);

(statearr_54211_54225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (5))){
var _ = (function (){var statearr_54212 = state_54206;
(statearr_54212[(4)] = cljs.core.rest((state_54206[(4)])));

return statearr_54212;
})();
var state_54206__$1 = state_54206;
var ex54210 = (state_54206__$1[(2)]);
var statearr_54213_54226 = state_54206__$1;
(statearr_54213_54226[(5)] = ex54210);


if((ex54210 instanceof Error)){
var statearr_54214_54227 = state_54206__$1;
(statearr_54214_54227[(1)] = (4));

(statearr_54214_54227[(5)] = null);

} else {
throw ex54210;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (6))){
var inst_54190 = (state_54206[(2)]);
var inst_54191 = fluree.db.util.async.throw_err(inst_54190);
var inst_54192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54191,(0),null);
var inst_54193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54191,(1),null);
var inst_54194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54195 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54196 = ["?s","?ctx",inst_54192];
var inst_54197 = cljs.core.PersistentHashMap.fromArrays(inst_54195,inst_54196);
var inst_54198 = ((10) + inst_54193);
var inst_54199 = [inst_54197,inst_54198];
var inst_54200 = (new cljs.core.PersistentVector(null,2,(5),inst_54194,inst_54199,null));
var inst_54201 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54200);
var _ = (function (){var statearr_54215 = state_54206;
(statearr_54215[(4)] = cljs.core.rest((state_54206[(4)])));

return statearr_54215;
})();
var state_54206__$1 = (function (){var statearr_54216 = state_54206;
(statearr_54216[(7)] = inst_54201);

return statearr_54216;
})();
var statearr_54217_54228 = state_54206__$1;
(statearr_54217_54228[(2)] = inst_54192);

(statearr_54217_54228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54218 = [null,null,null,null,null,null,null,null];
(statearr_54218[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54218[(1)] = (1));

return statearr_54218;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54206){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54206);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54219){var ex__2417__auto__ = e54219;
var statearr_54220_54229 = state_54206;
(statearr_54220_54229[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54206[(4)]))){
var statearr_54221_54230 = state_54206;
(statearr_54221_54230[(1)] = cljs.core.first((state_54206[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54231 = state_54206;
state_54206 = G__54231;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54222 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54222[(6)] = c__2436__auto__);

return statearr_54222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54233 = arguments.length;
switch (G__54233) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54271){
var state_val_54272 = (state_54271[(1)]);
if((state_val_54272 === (7))){
var inst_54264 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54271__$1 = state_54271;
var statearr_54273_54293 = state_54271__$1;
(statearr_54273_54293[(2)] = inst_54264);

(statearr_54273_54293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (1))){
var state_54271__$1 = state_54271;
var statearr_54274_54294 = state_54271__$1;
(statearr_54274_54294[(2)] = null);

(statearr_54274_54294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (4))){
var inst_54234 = (state_54271[(2)]);
var state_54271__$1 = state_54271;
var statearr_54275_54295 = state_54271__$1;
(statearr_54275_54295[(2)] = inst_54234);

(statearr_54275_54295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (6))){
var inst_54245 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54271__$1 = state_54271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54271__$1,(10),inst_54245);
} else {
if((state_val_54272 === (3))){
var inst_54269 = (state_54271[(2)]);
var state_54271__$1 = state_54271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54271__$1,inst_54269);
} else {
if((state_val_54272 === (2))){
var _ = (function (){var statearr_54277 = state_54271;
(statearr_54277[(4)] = cljs.core.cons((5),(state_54271[(4)])));

return statearr_54277;
})();
var inst_54240 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54271__$1 = state_54271;
if(cljs.core.truth_(inst_54240)){
var statearr_54278_54296 = state_54271__$1;
(statearr_54278_54296[(1)] = (6));

} else {
var statearr_54279_54297 = state_54271__$1;
(statearr_54279_54297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (9))){
var inst_54251 = (state_54271[(2)]);
var inst_54252 = fluree.db.util.async.throw_err(inst_54251);
var inst_54253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54252,(0),null);
var inst_54254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54252,(1),null);
var inst_54255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54256 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54257 = ["?p","?ctx",inst_54253];
var inst_54258 = cljs.core.PersistentHashMap.fromArrays(inst_54256,inst_54257);
var inst_54259 = ((10) + inst_54254);
var inst_54260 = [inst_54258,inst_54259];
var inst_54261 = (new cljs.core.PersistentVector(null,2,(5),inst_54255,inst_54260,null));
var inst_54262 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54261);
var state_54271__$1 = (function (){var statearr_54280 = state_54271;
(statearr_54280[(7)] = inst_54262);

return statearr_54280;
})();
var statearr_54281_54298 = state_54271__$1;
(statearr_54281_54298[(2)] = inst_54253);

(statearr_54281_54298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (5))){
var _ = (function (){var statearr_54282 = state_54271;
(statearr_54282[(4)] = cljs.core.rest((state_54271[(4)])));

return statearr_54282;
})();
var state_54271__$1 = state_54271;
var ex54276 = (state_54271__$1[(2)]);
var statearr_54283_54299 = state_54271__$1;
(statearr_54283_54299[(5)] = ex54276);


if((ex54276 instanceof Error)){
var statearr_54284_54300 = state_54271__$1;
(statearr_54284_54300[(1)] = (4));

(statearr_54284_54300[(5)] = null);

} else {
throw ex54276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54272 === (10))){
var inst_54247 = (state_54271[(2)]);
var inst_54248 = fluree.db.util.async.throw_err(inst_54247);
var inst_54249 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54248);
var state_54271__$1 = state_54271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54271__$1,(9),inst_54249);
} else {
if((state_val_54272 === (8))){
var inst_54266 = (state_54271[(2)]);
var _ = (function (){var statearr_54285 = state_54271;
(statearr_54285[(4)] = cljs.core.rest((state_54271[(4)])));

return statearr_54285;
})();
var state_54271__$1 = state_54271;
var statearr_54286_54301 = state_54271__$1;
(statearr_54286_54301[(2)] = inst_54266);

(statearr_54286_54301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54287 = [null,null,null,null,null,null,null,null];
(statearr_54287[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54287[(1)] = (1));

return statearr_54287;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54271){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54271);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54288){var ex__2417__auto__ = e54288;
var statearr_54289_54302 = state_54271;
(statearr_54289_54302[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54271[(4)]))){
var statearr_54290_54303 = state_54271;
(statearr_54290_54303[(1)] = cljs.core.first((state_54271[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54304 = state_54271;
state_54271 = G__54304;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54271){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54291 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54291[(6)] = c__2436__auto__);

return statearr_54291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54353 = arguments.length;
var i__4737__auto___54354 = (0);
while(true){
if((i__4737__auto___54354 < len__4736__auto___54353)){
args__4742__auto__.push((arguments[i__4737__auto___54354]));

var G__54355 = (i__4737__auto___54354 + (1));
i__4737__auto___54354 = G__54355;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54336){
var state_val_54337 = (state_54336[(1)]);
if((state_val_54337 === (1))){
var state_54336__$1 = state_54336;
var statearr_54338_54356 = state_54336__$1;
(statearr_54338_54356[(2)] = null);

(statearr_54338_54356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54337 === (2))){
var _ = (function (){var statearr_54339 = state_54336;
(statearr_54339[(4)] = cljs.core.cons((5),(state_54336[(4)])));

return statearr_54339;
})();
var inst_54313 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54336__$1 = state_54336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54336__$1,(6),inst_54313);
} else {
if((state_val_54337 === (3))){
var inst_54334 = (state_54336[(2)]);
var state_54336__$1 = state_54336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54336__$1,inst_54334);
} else {
if((state_val_54337 === (4))){
var inst_54307 = (state_54336[(2)]);
var state_54336__$1 = state_54336;
var statearr_54341_54357 = state_54336__$1;
(statearr_54341_54357[(2)] = inst_54307);

(statearr_54341_54357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54337 === (5))){
var _ = (function (){var statearr_54342 = state_54336;
(statearr_54342[(4)] = cljs.core.rest((state_54336[(4)])));

return statearr_54342;
})();
var state_54336__$1 = state_54336;
var ex54340 = (state_54336__$1[(2)]);
var statearr_54343_54358 = state_54336__$1;
(statearr_54343_54358[(5)] = ex54340);


if((ex54340 instanceof Error)){
var statearr_54344_54359 = state_54336__$1;
(statearr_54344_54359[(1)] = (4));

(statearr_54344_54359[(5)] = null);

} else {
throw ex54340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54337 === (6))){
var inst_54315 = (state_54336[(2)]);
var inst_54316 = fluree.db.util.async.throw_err(inst_54315);
var inst_54317 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54316);
var inst_54318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54319 = [inst_54316];
var inst_54320 = (new cljs.core.PersistentVector(null,1,(5),inst_54318,inst_54319,null));
var inst_54321 = cljs.core.count(inst_54320);
var inst_54322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54323 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54325 = [inst_54316];
var inst_54326 = (new cljs.core.PersistentVector(null,1,(5),inst_54324,inst_54325,null));
var inst_54327 = ["and",inst_54326,inst_54317];
var inst_54328 = cljs.core.PersistentHashMap.fromArrays(inst_54323,inst_54327);
var inst_54329 = [inst_54328,inst_54321];
var inst_54330 = (new cljs.core.PersistentVector(null,2,(5),inst_54322,inst_54329,null));
var inst_54331 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54330);
var _ = (function (){var statearr_54345 = state_54336;
(statearr_54345[(4)] = cljs.core.rest((state_54336[(4)])));

return statearr_54345;
})();
var state_54336__$1 = (function (){var statearr_54346 = state_54336;
(statearr_54346[(7)] = inst_54331);

return statearr_54346;
})();
var statearr_54347_54360 = state_54336__$1;
(statearr_54347_54360[(2)] = inst_54317);

(statearr_54347_54360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54348 = [null,null,null,null,null,null,null,null];
(statearr_54348[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54348[(1)] = (1));

return statearr_54348;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54336){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54336);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54349){var ex__2417__auto__ = e54349;
var statearr_54350_54361 = state_54336;
(statearr_54350_54361[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54336[(4)]))){
var statearr_54351_54362 = state_54336;
(statearr_54351_54362[(1)] = cljs.core.first((state_54336[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54363 = state_54336;
state_54336 = G__54363;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54336){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54352 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54352[(6)] = c__2436__auto__);

return statearr_54352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54305){
var G__54306 = cljs.core.first(seq54305);
var seq54305__$1 = cljs.core.next(seq54305);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54306,seq54305__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54412 = arguments.length;
var i__4737__auto___54413 = (0);
while(true){
if((i__4737__auto___54413 < len__4736__auto___54412)){
args__4742__auto__.push((arguments[i__4737__auto___54413]));

var G__54414 = (i__4737__auto___54413 + (1));
i__4737__auto___54413 = G__54414;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54395){
var state_val_54396 = (state_54395[(1)]);
if((state_val_54396 === (1))){
var state_54395__$1 = state_54395;
var statearr_54397_54415 = state_54395__$1;
(statearr_54397_54415[(2)] = null);

(statearr_54397_54415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (2))){
var _ = (function (){var statearr_54398 = state_54395;
(statearr_54398[(4)] = cljs.core.cons((5),(state_54395[(4)])));

return statearr_54398;
})();
var inst_54372 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54395__$1,(6),inst_54372);
} else {
if((state_val_54396 === (3))){
var inst_54393 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54395__$1,inst_54393);
} else {
if((state_val_54396 === (4))){
var inst_54366 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
var statearr_54400_54416 = state_54395__$1;
(statearr_54400_54416[(2)] = inst_54366);

(statearr_54400_54416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (5))){
var _ = (function (){var statearr_54401 = state_54395;
(statearr_54401[(4)] = cljs.core.rest((state_54395[(4)])));

return statearr_54401;
})();
var state_54395__$1 = state_54395;
var ex54399 = (state_54395__$1[(2)]);
var statearr_54402_54417 = state_54395__$1;
(statearr_54402_54417[(5)] = ex54399);


if((ex54399 instanceof Error)){
var statearr_54403_54418 = state_54395__$1;
(statearr_54403_54418[(1)] = (4));

(statearr_54403_54418[(5)] = null);

} else {
throw ex54399;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (6))){
var inst_54374 = (state_54395[(2)]);
var inst_54375 = fluree.db.util.async.throw_err(inst_54374);
var inst_54376 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54375);
var inst_54377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54378 = [inst_54375];
var inst_54379 = (new cljs.core.PersistentVector(null,1,(5),inst_54377,inst_54378,null));
var inst_54380 = cljs.core.count(inst_54379);
var inst_54381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54384 = [inst_54375];
var inst_54385 = (new cljs.core.PersistentVector(null,1,(5),inst_54383,inst_54384,null));
var inst_54386 = ["or",inst_54385,inst_54376];
var inst_54387 = cljs.core.PersistentHashMap.fromArrays(inst_54382,inst_54386);
var inst_54388 = [inst_54387,inst_54380];
var inst_54389 = (new cljs.core.PersistentVector(null,2,(5),inst_54381,inst_54388,null));
var inst_54390 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54389);
var _ = (function (){var statearr_54404 = state_54395;
(statearr_54404[(4)] = cljs.core.rest((state_54395[(4)])));

return statearr_54404;
})();
var state_54395__$1 = (function (){var statearr_54405 = state_54395;
(statearr_54405[(7)] = inst_54390);

return statearr_54405;
})();
var statearr_54406_54419 = state_54395__$1;
(statearr_54406_54419[(2)] = inst_54376);

(statearr_54406_54419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_54407 = [null,null,null,null,null,null,null,null];
(statearr_54407[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_54407[(1)] = (1));

return statearr_54407;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_54395){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54395);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54408){var ex__2417__auto__ = e54408;
var statearr_54409_54420 = state_54395;
(statearr_54409_54420[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54395[(4)]))){
var statearr_54410_54421 = state_54395;
(statearr_54410_54421[(1)] = cljs.core.first((state_54395[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54422 = state_54395;
state_54395 = G__54422;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_54395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_54395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54411 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54411[(6)] = c__2436__auto__);

return statearr_54411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54364){
var G__54365 = cljs.core.first(seq54364);
var seq54364__$1 = cljs.core.next(seq54364);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54365,seq54364__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54460){
var state_val_54461 = (state_54460[(1)]);
if((state_val_54461 === (7))){
var inst_54436 = fluree.db.util.async.channel_QMARK_(coll);
var state_54460__$1 = state_54460;
if(inst_54436){
var statearr_54462_54485 = state_54460__$1;
(statearr_54462_54485[(1)] = (10));

} else {
var statearr_54463_54486 = state_54460__$1;
(statearr_54463_54486[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (1))){
var state_54460__$1 = state_54460;
var statearr_54464_54487 = state_54460__$1;
(statearr_54464_54487[(2)] = null);

(statearr_54464_54487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (4))){
var inst_54423 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
var statearr_54465_54488 = state_54460__$1;
(statearr_54465_54488[(2)] = inst_54423);

(statearr_54465_54488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (13))){
var inst_54439 = (state_54460[(2)]);
var inst_54440 = fluree.db.util.async.throw_err(inst_54439);
var state_54460__$1 = state_54460;
var statearr_54466_54489 = state_54460__$1;
(statearr_54466_54489[(2)] = inst_54440);

(statearr_54466_54489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (6))){
var inst_54431 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54460__$1,(9),inst_54431);
} else {
if((state_val_54461 === (3))){
var inst_54458 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54460__$1,inst_54458);
} else {
if((state_val_54461 === (12))){
var inst_54443 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
var statearr_54467_54490 = state_54460__$1;
(statearr_54467_54490[(2)] = inst_54443);

(statearr_54467_54490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (2))){
var _ = (function (){var statearr_54468 = state_54460;
(statearr_54468[(4)] = cljs.core.cons((5),(state_54460[(4)])));

return statearr_54468;
})();
var inst_54429 = cljs.core.vector_QMARK_(coll);
var state_54460__$1 = state_54460;
if(inst_54429){
var statearr_54469_54491 = state_54460__$1;
(statearr_54469_54491[(1)] = (6));

} else {
var statearr_54470_54492 = state_54460__$1;
(statearr_54470_54492[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (11))){
var state_54460__$1 = state_54460;
var statearr_54472_54493 = state_54460__$1;
(statearr_54472_54493[(2)] = coll);

(statearr_54472_54493[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (9))){
var inst_54433 = (state_54460[(2)]);
var inst_54434 = fluree.db.util.async.throw_err(inst_54433);
var state_54460__$1 = state_54460;
var statearr_54473_54494 = state_54460__$1;
(statearr_54473_54494[(2)] = inst_54434);

(statearr_54473_54494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (5))){
var _ = (function (){var statearr_54474 = state_54460;
(statearr_54474[(4)] = cljs.core.rest((state_54460[(4)])));

return statearr_54474;
})();
var state_54460__$1 = state_54460;
var ex54471 = (state_54460__$1[(2)]);
var statearr_54475_54495 = state_54460__$1;
(statearr_54475_54495[(5)] = ex54471);


if((ex54471 instanceof Error)){
var statearr_54476_54496 = state_54460__$1;
(statearr_54476_54496[(1)] = (4));

(statearr_54476_54496[(5)] = null);

} else {
throw ex54471;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (10))){
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54460__$1,(13),coll);
} else {
if((state_val_54461 === (8))){
var inst_54445 = (state_54460[(2)]);
var inst_54446 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54445);
var inst_54447 = cljs.core.count(inst_54446);
var inst_54448 = ((9) + inst_54447);
var inst_54449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54450 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54451 = ["count",inst_54445,inst_54447];
var inst_54452 = cljs.core.PersistentHashMap.fromArrays(inst_54450,inst_54451);
var inst_54453 = [inst_54452,inst_54448];
var inst_54454 = (new cljs.core.PersistentVector(null,2,(5),inst_54449,inst_54453,null));
var inst_54455 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54454);
var _ = (function (){var statearr_54477 = state_54460;
(statearr_54477[(4)] = cljs.core.rest((state_54460[(4)])));

return statearr_54477;
})();
var state_54460__$1 = (function (){var statearr_54478 = state_54460;
(statearr_54478[(7)] = inst_54455);

return statearr_54478;
})();
var statearr_54479_54497 = state_54460__$1;
(statearr_54479_54497[(2)] = inst_54447);

(statearr_54479_54497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0 = (function (){
var statearr_54480 = [null,null,null,null,null,null,null,null];
(statearr_54480[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__);

(statearr_54480[(1)] = (1));

return statearr_54480;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1 = (function (state_54460){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54460);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54481){var ex__2417__auto__ = e54481;
var statearr_54482_54498 = state_54460;
(statearr_54482_54498[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54460[(4)]))){
var statearr_54483_54499 = state_54460;
(statearr_54483_54499[(1)] = cljs.core.first((state_54460[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54500 = state_54460;
state_54460 = G__54500;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__ = function(state_54460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1.call(this,state_54460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54484 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54484[(6)] = c__2436__auto__);

return statearr_54484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54550){
var state_val_54551 = (state_54550[(1)]);
if((state_val_54551 === (7))){
var state_54550__$1 = state_54550;
var statearr_54552_54585 = state_54550__$1;
(statearr_54552_54585[(2)] = subject);

(statearr_54552_54585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (1))){
var state_54550__$1 = state_54550;
var statearr_54553_54586 = state_54550__$1;
(statearr_54553_54586[(2)] = null);

(statearr_54553_54586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (4))){
var inst_54501 = (state_54550[(2)]);
var state_54550__$1 = state_54550;
var statearr_54554_54587 = state_54550__$1;
(statearr_54554_54587[(2)] = inst_54501);

(statearr_54554_54587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (15))){
var inst_54514 = (state_54550[(7)]);
var state_54550__$1 = state_54550;
var statearr_54555_54588 = state_54550__$1;
(statearr_54555_54588[(2)] = inst_54514);

(statearr_54555_54588[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (13))){
var inst_54518 = (state_54550[(2)]);
var inst_54519 = fluree.db.util.async.throw_err(inst_54518);
var state_54550__$1 = state_54550;
var statearr_54556_54589 = state_54550__$1;
(statearr_54556_54589[(2)] = inst_54519);

(statearr_54556_54589[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (6))){
var state_54550__$1 = state_54550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54550__$1,(9),subject);
} else {
if((state_val_54551 === (17))){
var inst_54514 = (state_54550[(7)]);
var inst_54528 = cljs.core.first(inst_54514);
var state_54550__$1 = state_54550;
var statearr_54557_54590 = state_54550__$1;
(statearr_54557_54590[(2)] = inst_54528);

(statearr_54557_54590[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (3))){
var inst_54548 = (state_54550[(2)]);
var state_54550__$1 = state_54550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54550__$1,inst_54548);
} else {
if((state_val_54551 === (12))){
var inst_54514 = (state_54550[(7)]);
var inst_54522 = (state_54550[(2)]);
var inst_54523 = cljs.core.vector_QMARK_(inst_54514);
var state_54550__$1 = (function (){var statearr_54558 = state_54550;
(statearr_54558[(8)] = inst_54522);

return statearr_54558;
})();
if(inst_54523){
var statearr_54559_54591 = state_54550__$1;
(statearr_54559_54591[(1)] = (14));

} else {
var statearr_54560_54592 = state_54550__$1;
(statearr_54560_54592[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (2))){
var _ = (function (){var statearr_54561 = state_54550;
(statearr_54561[(4)] = cljs.core.cons((5),(state_54550[(4)])));

return statearr_54561;
})();
var inst_54507 = fluree.db.util.async.channel_QMARK_(subject);
var state_54550__$1 = state_54550;
if(inst_54507){
var statearr_54562_54593 = state_54550__$1;
(statearr_54562_54593[(1)] = (6));

} else {
var statearr_54563_54594 = state_54550__$1;
(statearr_54563_54594[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (19))){
var inst_54531 = (state_54550[(2)]);
var state_54550__$1 = state_54550;
var statearr_54564_54595 = state_54550__$1;
(statearr_54564_54595[(2)] = inst_54531);

(statearr_54564_54595[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (11))){
var state_54550__$1 = state_54550;
var statearr_54566_54596 = state_54550__$1;
(statearr_54566_54596[(2)] = pred);

(statearr_54566_54596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (9))){
var inst_54510 = (state_54550[(2)]);
var inst_54511 = fluree.db.util.async.throw_err(inst_54510);
var state_54550__$1 = state_54550;
var statearr_54567_54597 = state_54550__$1;
(statearr_54567_54597[(2)] = inst_54511);

(statearr_54567_54597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (5))){
var _ = (function (){var statearr_54568 = state_54550;
(statearr_54568[(4)] = cljs.core.rest((state_54550[(4)])));

return statearr_54568;
})();
var state_54550__$1 = state_54550;
var ex54565 = (state_54550__$1[(2)]);
var statearr_54569_54598 = state_54550__$1;
(statearr_54569_54598[(5)] = ex54565);


if((ex54565 instanceof Error)){
var statearr_54570_54599 = state_54550__$1;
(statearr_54570_54599[(1)] = (4));

(statearr_54570_54599[(5)] = null);

} else {
throw ex54565;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (14))){
var inst_54514 = (state_54550[(7)]);
var inst_54525 = cljs.core.count(inst_54514);
var inst_54526 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54525);
var state_54550__$1 = state_54550;
if(inst_54526){
var statearr_54571_54600 = state_54550__$1;
(statearr_54571_54600[(1)] = (17));

} else {
var statearr_54572_54601 = state_54550__$1;
(statearr_54572_54601[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (16))){
var inst_54514 = (state_54550[(7)]);
var inst_54522 = (state_54550[(8)]);
var inst_54534 = (state_54550[(2)]);
var inst_54535 = fluree.db.dbfunctions.internal.get(inst_54534,inst_54522);
var inst_54536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54537 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54539 = [inst_54514,inst_54522];
var inst_54540 = (new cljs.core.PersistentVector(null,2,(5),inst_54538,inst_54539,null));
var inst_54541 = ["get",inst_54540,inst_54535];
var inst_54542 = cljs.core.PersistentHashMap.fromArrays(inst_54537,inst_54541);
var inst_54543 = [inst_54542,(10)];
var inst_54544 = (new cljs.core.PersistentVector(null,2,(5),inst_54536,inst_54543,null));
var inst_54545 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54544);
var _ = (function (){var statearr_54573 = state_54550;
(statearr_54573[(4)] = cljs.core.rest((state_54550[(4)])));

return statearr_54573;
})();
var state_54550__$1 = (function (){var statearr_54574 = state_54550;
(statearr_54574[(9)] = inst_54545);

return statearr_54574;
})();
var statearr_54575_54602 = state_54550__$1;
(statearr_54575_54602[(2)] = inst_54535);

(statearr_54575_54602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (10))){
var state_54550__$1 = state_54550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54550__$1,(13),pred);
} else {
if((state_val_54551 === (18))){
var inst_54514 = (state_54550[(7)]);
var state_54550__$1 = state_54550;
var statearr_54576_54603 = state_54550__$1;
(statearr_54576_54603[(2)] = inst_54514);

(statearr_54576_54603[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54551 === (8))){
var inst_54514 = (state_54550[(2)]);
var inst_54515 = fluree.db.util.async.channel_QMARK_(pred);
var state_54550__$1 = (function (){var statearr_54577 = state_54550;
(statearr_54577[(7)] = inst_54514);

return statearr_54577;
})();
if(inst_54515){
var statearr_54578_54604 = state_54550__$1;
(statearr_54578_54604[(1)] = (10));

} else {
var statearr_54579_54605 = state_54550__$1;
(statearr_54579_54605[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0 = (function (){
var statearr_54580 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54580[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__);

(statearr_54580[(1)] = (1));

return statearr_54580;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1 = (function (state_54550){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54550);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54581){var ex__2417__auto__ = e54581;
var statearr_54582_54606 = state_54550;
(statearr_54582_54606[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54550[(4)]))){
var statearr_54583_54607 = state_54550;
(statearr_54583_54607[(1)] = cljs.core.first((state_54550[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54608 = state_54550;
state_54550 = G__54608;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__ = function(state_54550){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1.call(this,state_54550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54584 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54584[(6)] = c__2436__auto__);

return statearr_54584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54647){
var state_val_54648 = (state_54647[(1)]);
if((state_val_54648 === (7))){
var inst_54615 = (state_54647[(7)]);
var state_54647__$1 = state_54647;
var statearr_54649_54673 = state_54647__$1;
(statearr_54649_54673[(2)] = inst_54615);

(statearr_54649_54673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (1))){
var state_54647__$1 = state_54647;
var statearr_54650_54674 = state_54647__$1;
(statearr_54650_54674[(2)] = null);

(statearr_54650_54674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (4))){
var inst_54609 = (state_54647[(2)]);
var state_54647__$1 = state_54647;
var statearr_54651_54675 = state_54647__$1;
(statearr_54651_54675[(2)] = inst_54609);

(statearr_54651_54675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (6))){
var inst_54617 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54647__$1 = state_54647;
var statearr_54652_54676 = state_54647__$1;
(statearr_54652_54676[(2)] = inst_54617);

(statearr_54652_54676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (3))){
var inst_54645 = (state_54647[(2)]);
var state_54647__$1 = state_54647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54647__$1,inst_54645);
} else {
if((state_val_54648 === (12))){
var inst_54627 = (state_54647[(2)]);
var inst_54628 = fluree.db.util.async.throw_err(inst_54627);
var inst_54629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54628,(0),null);
var inst_54630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54628,(1),null);
var inst_54631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54632 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54633 = ["?pO","?ctx",inst_54629];
var inst_54634 = cljs.core.PersistentHashMap.fromArrays(inst_54632,inst_54633);
var inst_54635 = ((10) + inst_54630);
var inst_54636 = [inst_54634,inst_54635];
var inst_54637 = (new cljs.core.PersistentVector(null,2,(5),inst_54631,inst_54636,null));
var inst_54638 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54637);
var state_54647__$1 = (function (){var statearr_54653 = state_54647;
(statearr_54653[(8)] = inst_54638);

return statearr_54653;
})();
var statearr_54654_54677 = state_54647__$1;
(statearr_54654_54677[(2)] = inst_54629);

(statearr_54654_54677[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (2))){
var inst_54615 = (state_54647[(7)]);
var _ = (function (){var statearr_54655 = state_54647;
(statearr_54655[(4)] = cljs.core.cons((5),(state_54647[(4)])));

return statearr_54655;
})();
var inst_54615__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54647__$1 = (function (){var statearr_54656 = state_54647;
(statearr_54656[(7)] = inst_54615__$1);

return statearr_54656;
})();
if(cljs.core.truth_(inst_54615__$1)){
var statearr_54657_54678 = state_54647__$1;
(statearr_54657_54678[(1)] = (6));

} else {
var statearr_54658_54679 = state_54647__$1;
(statearr_54658_54679[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (11))){
var inst_54642 = (state_54647[(2)]);
var _ = (function (){var statearr_54660 = state_54647;
(statearr_54660[(4)] = cljs.core.rest((state_54647[(4)])));

return statearr_54660;
})();
var state_54647__$1 = state_54647;
var statearr_54661_54680 = state_54647__$1;
(statearr_54661_54680[(2)] = inst_54642);

(statearr_54661_54680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (9))){
var inst_54625 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54647__$1 = state_54647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54647__$1,(12),inst_54625);
} else {
if((state_val_54648 === (5))){
var _ = (function (){var statearr_54662 = state_54647;
(statearr_54662[(4)] = cljs.core.rest((state_54647[(4)])));

return statearr_54662;
})();
var state_54647__$1 = state_54647;
var ex54659 = (state_54647__$1[(2)]);
var statearr_54663_54681 = state_54647__$1;
(statearr_54663_54681[(5)] = ex54659);


if((ex54659 instanceof Error)){
var statearr_54664_54682 = state_54647__$1;
(statearr_54664_54682[(1)] = (4));

(statearr_54664_54682[(5)] = null);

} else {
throw ex54659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (10))){
var inst_54640 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54647__$1 = state_54647;
var statearr_54665_54683 = state_54647__$1;
(statearr_54665_54683[(2)] = inst_54640);

(statearr_54665_54683[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54648 === (8))){
var inst_54620 = (state_54647[(2)]);
var state_54647__$1 = state_54647;
if(cljs.core.truth_(inst_54620)){
var statearr_54666_54684 = state_54647__$1;
(statearr_54666_54684[(1)] = (9));

} else {
var statearr_54667_54685 = state_54647__$1;
(statearr_54667_54685[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0 = (function (){
var statearr_54668 = [null,null,null,null,null,null,null,null,null];
(statearr_54668[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__);

(statearr_54668[(1)] = (1));

return statearr_54668;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1 = (function (state_54647){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54647);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54669){var ex__2417__auto__ = e54669;
var statearr_54670_54686 = state_54647;
(statearr_54670_54686[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54647[(4)]))){
var statearr_54671_54687 = state_54647;
(statearr_54671_54687[(1)] = cljs.core.first((state_54647[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54688 = state_54647;
state_54647 = G__54688;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__ = function(state_54647){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1.call(this,state_54647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54672 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54672[(6)] = c__2436__auto__);

return statearr_54672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54740){
var state_val_54741 = (state_54740[(1)]);
if((state_val_54741 === (7))){
var state_54740__$1 = state_54740;
var statearr_54742_54775 = state_54740__$1;
(statearr_54742_54775[(2)] = subject);

(statearr_54742_54775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (1))){
var state_54740__$1 = state_54740;
var statearr_54743_54776 = state_54740__$1;
(statearr_54743_54776[(2)] = null);

(statearr_54743_54776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (4))){
var inst_54689 = (state_54740[(2)]);
var state_54740__$1 = state_54740;
var statearr_54744_54777 = state_54740__$1;
(statearr_54744_54777[(2)] = inst_54689);

(statearr_54744_54777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (15))){
var inst_54702 = (state_54740[(7)]);
var state_54740__$1 = state_54740;
var statearr_54745_54778 = state_54740__$1;
(statearr_54745_54778[(2)] = inst_54702);

(statearr_54745_54778[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (13))){
var inst_54706 = (state_54740[(2)]);
var inst_54707 = fluree.db.util.async.throw_err(inst_54706);
var state_54740__$1 = state_54740;
var statearr_54746_54779 = state_54740__$1;
(statearr_54746_54779[(2)] = inst_54707);

(statearr_54746_54779[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (6))){
var state_54740__$1 = state_54740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54740__$1,(9),subject);
} else {
if((state_val_54741 === (17))){
var inst_54702 = (state_54740[(7)]);
var inst_54716 = cljs.core.first(inst_54702);
var state_54740__$1 = state_54740;
var statearr_54747_54780 = state_54740__$1;
(statearr_54747_54780[(2)] = inst_54716);

(statearr_54747_54780[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (3))){
var inst_54738 = (state_54740[(2)]);
var state_54740__$1 = state_54740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54740__$1,inst_54738);
} else {
if((state_val_54741 === (12))){
var inst_54702 = (state_54740[(7)]);
var inst_54710 = (state_54740[(2)]);
var inst_54711 = cljs.core.vector_QMARK_(inst_54702);
var state_54740__$1 = (function (){var statearr_54748 = state_54740;
(statearr_54748[(8)] = inst_54710);

return statearr_54748;
})();
if(inst_54711){
var statearr_54749_54781 = state_54740__$1;
(statearr_54749_54781[(1)] = (14));

} else {
var statearr_54750_54782 = state_54740__$1;
(statearr_54750_54782[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (2))){
var _ = (function (){var statearr_54751 = state_54740;
(statearr_54751[(4)] = cljs.core.cons((5),(state_54740[(4)])));

return statearr_54751;
})();
var inst_54695 = fluree.db.util.async.channel_QMARK_(subject);
var state_54740__$1 = state_54740;
if(inst_54695){
var statearr_54752_54783 = state_54740__$1;
(statearr_54752_54783[(1)] = (6));

} else {
var statearr_54753_54784 = state_54740__$1;
(statearr_54753_54784[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (19))){
var inst_54719 = (state_54740[(2)]);
var state_54740__$1 = state_54740;
var statearr_54754_54785 = state_54740__$1;
(statearr_54754_54785[(2)] = inst_54719);

(statearr_54754_54785[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (11))){
var state_54740__$1 = state_54740;
var statearr_54756_54786 = state_54740__$1;
(statearr_54756_54786[(2)] = path);

(statearr_54756_54786[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (9))){
var inst_54698 = (state_54740[(2)]);
var inst_54699 = fluree.db.util.async.throw_err(inst_54698);
var state_54740__$1 = state_54740;
var statearr_54757_54787 = state_54740__$1;
(statearr_54757_54787[(2)] = inst_54699);

(statearr_54757_54787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (5))){
var _ = (function (){var statearr_54758 = state_54740;
(statearr_54758[(4)] = cljs.core.rest((state_54740[(4)])));

return statearr_54758;
})();
var state_54740__$1 = state_54740;
var ex54755 = (state_54740__$1[(2)]);
var statearr_54759_54788 = state_54740__$1;
(statearr_54759_54788[(5)] = ex54755);


if((ex54755 instanceof Error)){
var statearr_54760_54789 = state_54740__$1;
(statearr_54760_54789[(1)] = (4));

(statearr_54760_54789[(5)] = null);

} else {
throw ex54755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (14))){
var inst_54702 = (state_54740[(7)]);
var inst_54713 = cljs.core.count(inst_54702);
var inst_54714 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54713);
var state_54740__$1 = state_54740;
if(inst_54714){
var statearr_54761_54790 = state_54740__$1;
(statearr_54761_54790[(1)] = (17));

} else {
var statearr_54762_54791 = state_54740__$1;
(statearr_54762_54791[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (16))){
var inst_54702 = (state_54740[(7)]);
var inst_54710 = (state_54740[(8)]);
var inst_54722 = (state_54740[(2)]);
var inst_54723 = fluree.db.dbfunctions.internal.get_all(inst_54722,inst_54710);
var inst_54724 = cljs.core.count(inst_54710);
var inst_54725 = ((9) + inst_54724);
var inst_54726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54727 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54729 = [inst_54702,inst_54710];
var inst_54730 = (new cljs.core.PersistentVector(null,2,(5),inst_54728,inst_54729,null));
var inst_54731 = ["get-all",inst_54730,inst_54723];
var inst_54732 = cljs.core.PersistentHashMap.fromArrays(inst_54727,inst_54731);
var inst_54733 = [inst_54732,inst_54725];
var inst_54734 = (new cljs.core.PersistentVector(null,2,(5),inst_54726,inst_54733,null));
var inst_54735 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54734);
var _ = (function (){var statearr_54763 = state_54740;
(statearr_54763[(4)] = cljs.core.rest((state_54740[(4)])));

return statearr_54763;
})();
var state_54740__$1 = (function (){var statearr_54764 = state_54740;
(statearr_54764[(9)] = inst_54735);

return statearr_54764;
})();
var statearr_54765_54792 = state_54740__$1;
(statearr_54765_54792[(2)] = inst_54723);

(statearr_54765_54792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (10))){
var state_54740__$1 = state_54740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54740__$1,(13),path);
} else {
if((state_val_54741 === (18))){
var inst_54702 = (state_54740[(7)]);
var state_54740__$1 = state_54740;
var statearr_54766_54793 = state_54740__$1;
(statearr_54766_54793[(2)] = inst_54702);

(statearr_54766_54793[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54741 === (8))){
var inst_54702 = (state_54740[(2)]);
var inst_54703 = fluree.db.util.async.channel_QMARK_(path);
var state_54740__$1 = (function (){var statearr_54767 = state_54740;
(statearr_54767[(7)] = inst_54702);

return statearr_54767;
})();
if(inst_54703){
var statearr_54768_54794 = state_54740__$1;
(statearr_54768_54794[(1)] = (10));

} else {
var statearr_54769_54795 = state_54740__$1;
(statearr_54769_54795[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0 = (function (){
var statearr_54770 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54770[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__);

(statearr_54770[(1)] = (1));

return statearr_54770;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1 = (function (state_54740){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54740);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54771){var ex__2417__auto__ = e54771;
var statearr_54772_54796 = state_54740;
(statearr_54772_54796[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54740[(4)]))){
var statearr_54773_54797 = state_54740;
(statearr_54773_54797[(1)] = cljs.core.first((state_54740[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54798 = state_54740;
state_54740 = G__54798;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__ = function(state_54740){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1.call(this,state_54740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54774 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54774[(6)] = c__2436__auto__);

return statearr_54774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54837){
var state_val_54838 = (state_54837[(1)]);
if((state_val_54838 === (7))){
var state_54837__$1 = state_54837;
var statearr_54839_54863 = state_54837__$1;
(statearr_54839_54863[(2)] = subject);

(statearr_54839_54863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (1))){
var state_54837__$1 = state_54837;
var statearr_54840_54864 = state_54837__$1;
(statearr_54840_54864[(2)] = null);

(statearr_54840_54864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (4))){
var inst_54799 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
var statearr_54841_54865 = state_54837__$1;
(statearr_54841_54865[(2)] = inst_54799);

(statearr_54841_54865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (13))){
var inst_54816 = (state_54837[(2)]);
var inst_54817 = fluree.db.util.async.throw_err(inst_54816);
var state_54837__$1 = state_54837;
var statearr_54842_54866 = state_54837__$1;
(statearr_54842_54866[(2)] = inst_54817);

(statearr_54842_54866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (6))){
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54837__$1,(9),subject);
} else {
if((state_val_54838 === (3))){
var inst_54835 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54837__$1,inst_54835);
} else {
if((state_val_54838 === (12))){
var inst_54812 = (state_54837[(7)]);
var inst_54820 = (state_54837[(2)]);
var inst_54821 = fluree.db.dbfunctions.internal.get_in(inst_54812,inst_54820);
var inst_54822 = cljs.core.count(inst_54820);
var inst_54823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54824 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54826 = [inst_54812,inst_54820];
var inst_54827 = (new cljs.core.PersistentVector(null,2,(5),inst_54825,inst_54826,null));
var inst_54828 = ["get-in",inst_54827,inst_54821];
var inst_54829 = cljs.core.PersistentHashMap.fromArrays(inst_54824,inst_54828);
var inst_54830 = [inst_54829,inst_54822];
var inst_54831 = (new cljs.core.PersistentVector(null,2,(5),inst_54823,inst_54830,null));
var inst_54832 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54831);
var _ = (function (){var statearr_54843 = state_54837;
(statearr_54843[(4)] = cljs.core.rest((state_54837[(4)])));

return statearr_54843;
})();
var state_54837__$1 = (function (){var statearr_54844 = state_54837;
(statearr_54844[(8)] = inst_54832);

return statearr_54844;
})();
var statearr_54845_54867 = state_54837__$1;
(statearr_54845_54867[(2)] = inst_54821);

(statearr_54845_54867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (2))){
var _ = (function (){var statearr_54846 = state_54837;
(statearr_54846[(4)] = cljs.core.cons((5),(state_54837[(4)])));

return statearr_54846;
})();
var inst_54805 = fluree.db.util.async.channel_QMARK_(subject);
var state_54837__$1 = state_54837;
if(inst_54805){
var statearr_54847_54868 = state_54837__$1;
(statearr_54847_54868[(1)] = (6));

} else {
var statearr_54848_54869 = state_54837__$1;
(statearr_54848_54869[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (11))){
var state_54837__$1 = state_54837;
var statearr_54850_54870 = state_54837__$1;
(statearr_54850_54870[(2)] = path);

(statearr_54850_54870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (9))){
var inst_54808 = (state_54837[(2)]);
var inst_54809 = fluree.db.util.async.throw_err(inst_54808);
var state_54837__$1 = state_54837;
var statearr_54851_54871 = state_54837__$1;
(statearr_54851_54871[(2)] = inst_54809);

(statearr_54851_54871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (5))){
var _ = (function (){var statearr_54852 = state_54837;
(statearr_54852[(4)] = cljs.core.rest((state_54837[(4)])));

return statearr_54852;
})();
var state_54837__$1 = state_54837;
var ex54849 = (state_54837__$1[(2)]);
var statearr_54853_54872 = state_54837__$1;
(statearr_54853_54872[(5)] = ex54849);


if((ex54849 instanceof Error)){
var statearr_54854_54873 = state_54837__$1;
(statearr_54854_54873[(1)] = (4));

(statearr_54854_54873[(5)] = null);

} else {
throw ex54849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (10))){
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54837__$1,(13),path);
} else {
if((state_val_54838 === (8))){
var inst_54812 = (state_54837[(2)]);
var inst_54813 = fluree.db.util.async.channel_QMARK_(path);
var state_54837__$1 = (function (){var statearr_54855 = state_54837;
(statearr_54855[(7)] = inst_54812);

return statearr_54855;
})();
if(inst_54813){
var statearr_54856_54874 = state_54837__$1;
(statearr_54856_54874[(1)] = (10));

} else {
var statearr_54857_54875 = state_54837__$1;
(statearr_54857_54875[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0 = (function (){
var statearr_54858 = [null,null,null,null,null,null,null,null,null];
(statearr_54858[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__);

(statearr_54858[(1)] = (1));

return statearr_54858;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1 = (function (state_54837){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54837);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54859){var ex__2417__auto__ = e54859;
var statearr_54860_54876 = state_54837;
(statearr_54860_54876[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54837[(4)]))){
var statearr_54861_54877 = state_54837;
(statearr_54861_54877[(1)] = cljs.core.first((state_54837[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54878 = state_54837;
state_54837 = G__54878;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__ = function(state_54837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1.call(this,state_54837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54862 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54862[(6)] = c__2436__auto__);

return statearr_54862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_54923){
var state_val_54924 = (state_54923[(1)]);
if((state_val_54924 === (7))){
var state_54923__$1 = state_54923;
var statearr_54925_54954 = state_54923__$1;
(statearr_54925_54954[(2)] = coll);

(statearr_54925_54954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (1))){
var state_54923__$1 = state_54923;
var statearr_54926_54955 = state_54923__$1;
(statearr_54926_54955[(2)] = null);

(statearr_54926_54955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (4))){
var inst_54879 = (state_54923[(2)]);
var state_54923__$1 = state_54923;
var statearr_54927_54956 = state_54923__$1;
(statearr_54927_54956[(2)] = inst_54879);

(statearr_54927_54956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (15))){
var inst_54899 = (state_54923[(7)]);
var inst_54907 = (state_54923[(2)]);
var inst_54908 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54899,inst_54907);
var inst_54909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54910 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54912 = [inst_54899,inst_54907];
var inst_54913 = (new cljs.core.PersistentVector(null,2,(5),inst_54911,inst_54912,null));
var inst_54914 = ["contains?",inst_54913,inst_54908];
var inst_54915 = cljs.core.PersistentHashMap.fromArrays(inst_54910,inst_54914);
var inst_54916 = [inst_54915,(10)];
var inst_54917 = (new cljs.core.PersistentVector(null,2,(5),inst_54909,inst_54916,null));
var inst_54918 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54917);
var _ = (function (){var statearr_54928 = state_54923;
(statearr_54928[(4)] = cljs.core.rest((state_54923[(4)])));

return statearr_54928;
})();
var state_54923__$1 = (function (){var statearr_54929 = state_54923;
(statearr_54929[(8)] = inst_54918);

return statearr_54929;
})();
var statearr_54930_54957 = state_54923__$1;
(statearr_54930_54957[(2)] = inst_54908);

(statearr_54930_54957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (13))){
var state_54923__$1 = state_54923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54923__$1,(16),key);
} else {
if((state_val_54924 === (6))){
var state_54923__$1 = state_54923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54923__$1,(9),coll);
} else {
if((state_val_54924 === (3))){
var inst_54921 = (state_54923[(2)]);
var state_54923__$1 = state_54923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54923__$1,inst_54921);
} else {
if((state_val_54924 === (12))){
var inst_54899 = (state_54923[(2)]);
var inst_54900 = fluree.db.util.async.channel_QMARK_(key);
var state_54923__$1 = (function (){var statearr_54931 = state_54923;
(statearr_54931[(7)] = inst_54899);

return statearr_54931;
})();
if(inst_54900){
var statearr_54932_54958 = state_54923__$1;
(statearr_54932_54958[(1)] = (13));

} else {
var statearr_54933_54959 = state_54923__$1;
(statearr_54933_54959[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (2))){
var _ = (function (){var statearr_54934 = state_54923;
(statearr_54934[(4)] = cljs.core.cons((5),(state_54923[(4)])));

return statearr_54934;
})();
var inst_54885 = fluree.db.util.async.channel_QMARK_(coll);
var state_54923__$1 = state_54923;
if(inst_54885){
var statearr_54935_54960 = state_54923__$1;
(statearr_54935_54960[(1)] = (6));

} else {
var statearr_54936_54961 = state_54923__$1;
(statearr_54936_54961[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (11))){
var inst_54892 = (state_54923[(9)]);
var inst_54896 = cljs.core.flatten(inst_54892);
var inst_54897 = cljs.core.set(inst_54896);
var state_54923__$1 = state_54923;
var statearr_54938_54962 = state_54923__$1;
(statearr_54938_54962[(2)] = inst_54897);

(statearr_54938_54962[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (9))){
var inst_54888 = (state_54923[(2)]);
var inst_54889 = fluree.db.util.async.throw_err(inst_54888);
var state_54923__$1 = state_54923;
var statearr_54939_54963 = state_54923__$1;
(statearr_54939_54963[(2)] = inst_54889);

(statearr_54939_54963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (5))){
var _ = (function (){var statearr_54940 = state_54923;
(statearr_54940[(4)] = cljs.core.rest((state_54923[(4)])));

return statearr_54940;
})();
var state_54923__$1 = state_54923;
var ex54937 = (state_54923__$1[(2)]);
var statearr_54941_54964 = state_54923__$1;
(statearr_54941_54964[(5)] = ex54937);


if((ex54937 instanceof Error)){
var statearr_54942_54965 = state_54923__$1;
(statearr_54942_54965[(1)] = (4));

(statearr_54942_54965[(5)] = null);

} else {
throw ex54937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (14))){
var state_54923__$1 = state_54923;
var statearr_54943_54966 = state_54923__$1;
(statearr_54943_54966[(2)] = key);

(statearr_54943_54966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (16))){
var inst_54903 = (state_54923[(2)]);
var inst_54904 = fluree.db.util.async.throw_err(inst_54903);
var state_54923__$1 = state_54923;
var statearr_54944_54967 = state_54923__$1;
(statearr_54944_54967[(2)] = inst_54904);

(statearr_54944_54967[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (10))){
var inst_54892 = (state_54923[(9)]);
var state_54923__$1 = state_54923;
var statearr_54945_54968 = state_54923__$1;
(statearr_54945_54968[(2)] = inst_54892);

(statearr_54945_54968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54924 === (8))){
var inst_54892 = (state_54923[(9)]);
var inst_54892__$1 = (state_54923[(2)]);
var inst_54893 = cljs.core.set_QMARK_(inst_54892__$1);
var state_54923__$1 = (function (){var statearr_54946 = state_54923;
(statearr_54946[(9)] = inst_54892__$1);

return statearr_54946;
})();
if(inst_54893){
var statearr_54947_54969 = state_54923__$1;
(statearr_54947_54969[(1)] = (10));

} else {
var statearr_54948_54970 = state_54923__$1;
(statearr_54948_54970[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_54949 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54949[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__);

(statearr_54949[(1)] = (1));

return statearr_54949;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1 = (function (state_54923){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_54923);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e54950){var ex__2417__auto__ = e54950;
var statearr_54951_54971 = state_54923;
(statearr_54951_54971[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_54923[(4)]))){
var statearr_54952_54972 = state_54923;
(statearr_54952_54972[(1)] = cljs.core.first((state_54923[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54973 = state_54923;
state_54923 = G__54973;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__ = function(state_54923){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1.call(this,state_54923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_54953 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_54953[(6)] = c__2436__auto__);

return statearr_54953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55038 = arguments.length;
var i__4737__auto___55039 = (0);
while(true){
if((i__4737__auto___55039 < len__4736__auto___55038)){
args__4742__auto__.push((arguments[i__4737__auto___55039]));

var G__55040 = (i__4737__auto___55039 + (1));
i__4737__auto___55039 = G__55040;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55016){
var state_val_55017 = (state_55016[(1)]);
if((state_val_55017 === (7))){
var inst_54985 = (state_55016[(7)]);
var inst_54992 = cljs.core.first(inst_54985);
var state_55016__$1 = state_55016;
var statearr_55018_55041 = state_55016__$1;
(statearr_55018_55041[(2)] = inst_54992);

(statearr_55018_55041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (1))){
var state_55016__$1 = state_55016;
var statearr_55019_55042 = state_55016__$1;
(statearr_55019_55042[(2)] = null);

(statearr_55019_55042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (4))){
var inst_54976 = (state_55016[(2)]);
var state_55016__$1 = state_55016;
var statearr_55020_55043 = state_55016__$1;
(statearr_55020_55043[(2)] = inst_54976);

(statearr_55020_55043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (6))){
var inst_54985 = (state_55016[(7)]);
var inst_54984 = (state_55016[(2)]);
var inst_54985__$1 = fluree.db.util.async.throw_err(inst_54984);
var inst_54986 = cljs.core.count(inst_54985__$1);
var inst_54987 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54986);
var inst_54988 = cljs.core.first(inst_54985__$1);
var inst_54989 = cljs.core.coll_QMARK_(inst_54988);
var inst_54990 = ((inst_54987) && (inst_54989));
var state_55016__$1 = (function (){var statearr_55021 = state_55016;
(statearr_55021[(7)] = inst_54985__$1);

return statearr_55021;
})();
if(cljs.core.truth_(inst_54990)){
var statearr_55022_55044 = state_55016__$1;
(statearr_55022_55044[(1)] = (7));

} else {
var statearr_55023_55045 = state_55016__$1;
(statearr_55023_55045[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (3))){
var inst_55014 = (state_55016[(2)]);
var state_55016__$1 = state_55016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55016__$1,inst_55014);
} else {
if((state_val_55017 === (2))){
var _ = (function (){var statearr_55025 = state_55016;
(statearr_55025[(4)] = cljs.core.cons((5),(state_55016[(4)])));

return statearr_55025;
})();
var inst_54982 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55016__$1 = state_55016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55016__$1,(6),inst_54982);
} else {
if((state_val_55017 === (9))){
var inst_54995 = (state_55016[(2)]);
var inst_54996 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54995);
var inst_54997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54998 = [inst_54995];
var inst_54999 = (new cljs.core.PersistentVector(null,1,(5),inst_54997,inst_54998,null));
var inst_55000 = cljs.core.count(inst_54999);
var inst_55001 = ((9) + inst_55000);
var inst_55002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55003 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55005 = [inst_54995];
var inst_55006 = (new cljs.core.PersistentVector(null,1,(5),inst_55004,inst_55005,null));
var inst_55007 = ["hash-set",inst_55006,inst_54996];
var inst_55008 = cljs.core.PersistentHashMap.fromArrays(inst_55003,inst_55007);
var inst_55009 = [inst_55008,inst_55001];
var inst_55010 = (new cljs.core.PersistentVector(null,2,(5),inst_55002,inst_55009,null));
var inst_55011 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55010);
var _ = (function (){var statearr_55026 = state_55016;
(statearr_55026[(4)] = cljs.core.rest((state_55016[(4)])));

return statearr_55026;
})();
var state_55016__$1 = (function (){var statearr_55027 = state_55016;
(statearr_55027[(8)] = inst_55011);

return statearr_55027;
})();
var statearr_55028_55046 = state_55016__$1;
(statearr_55028_55046[(2)] = inst_54996);

(statearr_55028_55046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (5))){
var _ = (function (){var statearr_55029 = state_55016;
(statearr_55029[(4)] = cljs.core.rest((state_55016[(4)])));

return statearr_55029;
})();
var state_55016__$1 = state_55016;
var ex55024 = (state_55016__$1[(2)]);
var statearr_55030_55047 = state_55016__$1;
(statearr_55030_55047[(5)] = ex55024);


if((ex55024 instanceof Error)){
var statearr_55031_55048 = state_55016__$1;
(statearr_55031_55048[(1)] = (4));

(statearr_55031_55048[(5)] = null);

} else {
throw ex55024;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55017 === (8))){
var inst_54985 = (state_55016[(7)]);
var state_55016__$1 = state_55016;
var statearr_55032_55049 = state_55016__$1;
(statearr_55032_55049[(2)] = inst_54985);

(statearr_55032_55049[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55033 = [null,null,null,null,null,null,null,null,null];
(statearr_55033[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55033[(1)] = (1));

return statearr_55033;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55016){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55016);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55034){var ex__2417__auto__ = e55034;
var statearr_55035_55050 = state_55016;
(statearr_55035_55050[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55016[(4)]))){
var statearr_55036_55051 = state_55016;
(statearr_55036_55051[(1)] = cljs.core.first((state_55016[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55052 = state_55016;
state_55016 = G__55052;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55016){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55037 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55037[(6)] = c__2436__auto__);

return statearr_55037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54974){
var G__54975 = cljs.core.first(seq54974);
var seq54974__$1 = cljs.core.next(seq54974);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54975,seq54974__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55102 = arguments.length;
var i__4737__auto___55103 = (0);
while(true){
if((i__4737__auto___55103 < len__4736__auto___55102)){
args__4742__auto__.push((arguments[i__4737__auto___55103]));

var G__55104 = (i__4737__auto___55103 + (1));
i__4737__auto___55103 = G__55104;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55085){
var state_val_55086 = (state_55085[(1)]);
if((state_val_55086 === (1))){
var state_55085__$1 = state_55085;
var statearr_55087_55105 = state_55085__$1;
(statearr_55087_55105[(2)] = null);

(statearr_55087_55105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (2))){
var _ = (function (){var statearr_55088 = state_55085;
(statearr_55088[(4)] = cljs.core.cons((5),(state_55085[(4)])));

return statearr_55088;
})();
var inst_55061 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55085__$1,(6),inst_55061);
} else {
if((state_val_55086 === (3))){
var inst_55083 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55085__$1,inst_55083);
} else {
if((state_val_55086 === (4))){
var inst_55055 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
var statearr_55090_55106 = state_55085__$1;
(statearr_55090_55106[(2)] = inst_55055);

(statearr_55090_55106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (5))){
var _ = (function (){var statearr_55091 = state_55085;
(statearr_55091[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55091;
})();
var state_55085__$1 = state_55085;
var ex55089 = (state_55085__$1[(2)]);
var statearr_55092_55107 = state_55085__$1;
(statearr_55092_55107[(5)] = ex55089);


if((ex55089 instanceof Error)){
var statearr_55093_55108 = state_55085__$1;
(statearr_55093_55108[(1)] = (4));

(statearr_55093_55108[(5)] = null);

} else {
throw ex55089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (6))){
var inst_55063 = (state_55085[(2)]);
var inst_55064 = fluree.db.util.async.throw_err(inst_55063);
var inst_55065 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55064);
var inst_55066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55067 = [inst_55064];
var inst_55068 = (new cljs.core.PersistentVector(null,1,(5),inst_55066,inst_55067,null));
var inst_55069 = cljs.core.count(inst_55068);
var inst_55070 = ((9) + inst_55069);
var inst_55071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55072 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55074 = [inst_55064];
var inst_55075 = (new cljs.core.PersistentVector(null,1,(5),inst_55073,inst_55074,null));
var inst_55076 = ["==",inst_55075,inst_55065];
var inst_55077 = cljs.core.PersistentHashMap.fromArrays(inst_55072,inst_55076);
var inst_55078 = [inst_55077,inst_55070];
var inst_55079 = (new cljs.core.PersistentVector(null,2,(5),inst_55071,inst_55078,null));
var inst_55080 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55079);
var _ = (function (){var statearr_55094 = state_55085;
(statearr_55094[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55094;
})();
var state_55085__$1 = (function (){var statearr_55095 = state_55085;
(statearr_55095[(7)] = inst_55080);

return statearr_55095;
})();
var statearr_55096_55109 = state_55085__$1;
(statearr_55096_55109[(2)] = inst_55065);

(statearr_55096_55109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55097 = [null,null,null,null,null,null,null,null];
(statearr_55097[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55097[(1)] = (1));

return statearr_55097;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55085){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55085);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55098){var ex__2417__auto__ = e55098;
var statearr_55099_55110 = state_55085;
(statearr_55099_55110[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55085[(4)]))){
var statearr_55100_55111 = state_55085;
(statearr_55100_55111[(1)] = cljs.core.first((state_55085[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55112 = state_55085;
state_55085 = G__55112;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55085){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55101 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55101[(6)] = c__2436__auto__);

return statearr_55101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55053){
var G__55054 = cljs.core.first(seq55053);
var seq55053__$1 = cljs.core.next(seq55053);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55054,seq55053__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55162 = arguments.length;
var i__4737__auto___55163 = (0);
while(true){
if((i__4737__auto___55163 < len__4736__auto___55162)){
args__4742__auto__.push((arguments[i__4737__auto___55163]));

var G__55164 = (i__4737__auto___55163 + (1));
i__4737__auto___55163 = G__55164;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55145){
var state_val_55146 = (state_55145[(1)]);
if((state_val_55146 === (1))){
var state_55145__$1 = state_55145;
var statearr_55147_55165 = state_55145__$1;
(statearr_55147_55165[(2)] = null);

(statearr_55147_55165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (2))){
var _ = (function (){var statearr_55148 = state_55145;
(statearr_55148[(4)] = cljs.core.cons((5),(state_55145[(4)])));

return statearr_55148;
})();
var inst_55121 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55145__$1 = state_55145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55145__$1,(6),inst_55121);
} else {
if((state_val_55146 === (3))){
var inst_55143 = (state_55145[(2)]);
var state_55145__$1 = state_55145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55145__$1,inst_55143);
} else {
if((state_val_55146 === (4))){
var inst_55115 = (state_55145[(2)]);
var state_55145__$1 = state_55145;
var statearr_55150_55166 = state_55145__$1;
(statearr_55150_55166[(2)] = inst_55115);

(statearr_55150_55166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (5))){
var _ = (function (){var statearr_55151 = state_55145;
(statearr_55151[(4)] = cljs.core.rest((state_55145[(4)])));

return statearr_55151;
})();
var state_55145__$1 = state_55145;
var ex55149 = (state_55145__$1[(2)]);
var statearr_55152_55167 = state_55145__$1;
(statearr_55152_55167[(5)] = ex55149);


if((ex55149 instanceof Error)){
var statearr_55153_55168 = state_55145__$1;
(statearr_55153_55168[(1)] = (4));

(statearr_55153_55168[(5)] = null);

} else {
throw ex55149;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (6))){
var inst_55123 = (state_55145[(2)]);
var inst_55124 = fluree.db.util.async.throw_err(inst_55123);
var inst_55125 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55124);
var inst_55126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55127 = [inst_55124];
var inst_55128 = (new cljs.core.PersistentVector(null,1,(5),inst_55126,inst_55127,null));
var inst_55129 = cljs.core.count(inst_55128);
var inst_55130 = ((9) + inst_55129);
var inst_55131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55132 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55134 = [inst_55124];
var inst_55135 = (new cljs.core.PersistentVector(null,1,(5),inst_55133,inst_55134,null));
var inst_55136 = [">",inst_55135,inst_55125];
var inst_55137 = cljs.core.PersistentHashMap.fromArrays(inst_55132,inst_55136);
var inst_55138 = [inst_55137,inst_55130];
var inst_55139 = (new cljs.core.PersistentVector(null,2,(5),inst_55131,inst_55138,null));
var inst_55140 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55139);
var _ = (function (){var statearr_55154 = state_55145;
(statearr_55154[(4)] = cljs.core.rest((state_55145[(4)])));

return statearr_55154;
})();
var state_55145__$1 = (function (){var statearr_55155 = state_55145;
(statearr_55155[(7)] = inst_55140);

return statearr_55155;
})();
var statearr_55156_55169 = state_55145__$1;
(statearr_55156_55169[(2)] = inst_55125);

(statearr_55156_55169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55157 = [null,null,null,null,null,null,null,null];
(statearr_55157[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55157[(1)] = (1));

return statearr_55157;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55145){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55145);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55158){var ex__2417__auto__ = e55158;
var statearr_55159_55170 = state_55145;
(statearr_55159_55170[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55145[(4)]))){
var statearr_55160_55171 = state_55145;
(statearr_55160_55171[(1)] = cljs.core.first((state_55145[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55172 = state_55145;
state_55145 = G__55172;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55145){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55161 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55161[(6)] = c__2436__auto__);

return statearr_55161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55113){
var G__55114 = cljs.core.first(seq55113);
var seq55113__$1 = cljs.core.next(seq55113);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55114,seq55113__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55222 = arguments.length;
var i__4737__auto___55223 = (0);
while(true){
if((i__4737__auto___55223 < len__4736__auto___55222)){
args__4742__auto__.push((arguments[i__4737__auto___55223]));

var G__55224 = (i__4737__auto___55223 + (1));
i__4737__auto___55223 = G__55224;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55205){
var state_val_55206 = (state_55205[(1)]);
if((state_val_55206 === (1))){
var state_55205__$1 = state_55205;
var statearr_55207_55225 = state_55205__$1;
(statearr_55207_55225[(2)] = null);

(statearr_55207_55225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55206 === (2))){
var _ = (function (){var statearr_55208 = state_55205;
(statearr_55208[(4)] = cljs.core.cons((5),(state_55205[(4)])));

return statearr_55208;
})();
var inst_55181 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55205__$1 = state_55205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55205__$1,(6),inst_55181);
} else {
if((state_val_55206 === (3))){
var inst_55203 = (state_55205[(2)]);
var state_55205__$1 = state_55205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55205__$1,inst_55203);
} else {
if((state_val_55206 === (4))){
var inst_55175 = (state_55205[(2)]);
var state_55205__$1 = state_55205;
var statearr_55210_55226 = state_55205__$1;
(statearr_55210_55226[(2)] = inst_55175);

(statearr_55210_55226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55206 === (5))){
var _ = (function (){var statearr_55211 = state_55205;
(statearr_55211[(4)] = cljs.core.rest((state_55205[(4)])));

return statearr_55211;
})();
var state_55205__$1 = state_55205;
var ex55209 = (state_55205__$1[(2)]);
var statearr_55212_55227 = state_55205__$1;
(statearr_55212_55227[(5)] = ex55209);


if((ex55209 instanceof Error)){
var statearr_55213_55228 = state_55205__$1;
(statearr_55213_55228[(1)] = (4));

(statearr_55213_55228[(5)] = null);

} else {
throw ex55209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55206 === (6))){
var inst_55183 = (state_55205[(2)]);
var inst_55184 = fluree.db.util.async.throw_err(inst_55183);
var inst_55185 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55184);
var inst_55186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55187 = [inst_55184];
var inst_55188 = (new cljs.core.PersistentVector(null,1,(5),inst_55186,inst_55187,null));
var inst_55189 = cljs.core.count(inst_55188);
var inst_55190 = ((9) + inst_55189);
var inst_55191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55192 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55194 = [inst_55184];
var inst_55195 = (new cljs.core.PersistentVector(null,1,(5),inst_55193,inst_55194,null));
var inst_55196 = ["<",inst_55195,inst_55185];
var inst_55197 = cljs.core.PersistentHashMap.fromArrays(inst_55192,inst_55196);
var inst_55198 = [inst_55197,inst_55190];
var inst_55199 = (new cljs.core.PersistentVector(null,2,(5),inst_55191,inst_55198,null));
var inst_55200 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55199);
var _ = (function (){var statearr_55214 = state_55205;
(statearr_55214[(4)] = cljs.core.rest((state_55205[(4)])));

return statearr_55214;
})();
var state_55205__$1 = (function (){var statearr_55215 = state_55205;
(statearr_55215[(7)] = inst_55200);

return statearr_55215;
})();
var statearr_55216_55229 = state_55205__$1;
(statearr_55216_55229[(2)] = inst_55185);

(statearr_55216_55229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55217 = [null,null,null,null,null,null,null,null];
(statearr_55217[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55217[(1)] = (1));

return statearr_55217;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55205){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55205);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55218){var ex__2417__auto__ = e55218;
var statearr_55219_55230 = state_55205;
(statearr_55219_55230[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55205[(4)]))){
var statearr_55220_55231 = state_55205;
(statearr_55220_55231[(1)] = cljs.core.first((state_55205[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55232 = state_55205;
state_55205 = G__55232;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55205){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55221 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55221[(6)] = c__2436__auto__);

return statearr_55221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55173){
var G__55174 = cljs.core.first(seq55173);
var seq55173__$1 = cljs.core.next(seq55173);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55174,seq55173__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55282 = arguments.length;
var i__4737__auto___55283 = (0);
while(true){
if((i__4737__auto___55283 < len__4736__auto___55282)){
args__4742__auto__.push((arguments[i__4737__auto___55283]));

var G__55284 = (i__4737__auto___55283 + (1));
i__4737__auto___55283 = G__55284;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55265){
var state_val_55266 = (state_55265[(1)]);
if((state_val_55266 === (1))){
var state_55265__$1 = state_55265;
var statearr_55267_55285 = state_55265__$1;
(statearr_55267_55285[(2)] = null);

(statearr_55267_55285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55266 === (2))){
var _ = (function (){var statearr_55268 = state_55265;
(statearr_55268[(4)] = cljs.core.cons((5),(state_55265[(4)])));

return statearr_55268;
})();
var inst_55241 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55265__$1 = state_55265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55265__$1,(6),inst_55241);
} else {
if((state_val_55266 === (3))){
var inst_55263 = (state_55265[(2)]);
var state_55265__$1 = state_55265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55265__$1,inst_55263);
} else {
if((state_val_55266 === (4))){
var inst_55235 = (state_55265[(2)]);
var state_55265__$1 = state_55265;
var statearr_55270_55286 = state_55265__$1;
(statearr_55270_55286[(2)] = inst_55235);

(statearr_55270_55286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55266 === (5))){
var _ = (function (){var statearr_55271 = state_55265;
(statearr_55271[(4)] = cljs.core.rest((state_55265[(4)])));

return statearr_55271;
})();
var state_55265__$1 = state_55265;
var ex55269 = (state_55265__$1[(2)]);
var statearr_55272_55287 = state_55265__$1;
(statearr_55272_55287[(5)] = ex55269);


if((ex55269 instanceof Error)){
var statearr_55273_55288 = state_55265__$1;
(statearr_55273_55288[(1)] = (4));

(statearr_55273_55288[(5)] = null);

} else {
throw ex55269;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55266 === (6))){
var inst_55243 = (state_55265[(2)]);
var inst_55244 = fluree.db.util.async.throw_err(inst_55243);
var inst_55245 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55244);
var inst_55246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55247 = [inst_55244];
var inst_55248 = (new cljs.core.PersistentVector(null,1,(5),inst_55246,inst_55247,null));
var inst_55249 = cljs.core.count(inst_55248);
var inst_55250 = ((9) + inst_55249);
var inst_55251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55252 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55254 = [inst_55244];
var inst_55255 = (new cljs.core.PersistentVector(null,1,(5),inst_55253,inst_55254,null));
var inst_55256 = ["<=",inst_55255,inst_55245];
var inst_55257 = cljs.core.PersistentHashMap.fromArrays(inst_55252,inst_55256);
var inst_55258 = [inst_55257,inst_55250];
var inst_55259 = (new cljs.core.PersistentVector(null,2,(5),inst_55251,inst_55258,null));
var inst_55260 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55259);
var _ = (function (){var statearr_55274 = state_55265;
(statearr_55274[(4)] = cljs.core.rest((state_55265[(4)])));

return statearr_55274;
})();
var state_55265__$1 = (function (){var statearr_55275 = state_55265;
(statearr_55275[(7)] = inst_55260);

return statearr_55275;
})();
var statearr_55276_55289 = state_55265__$1;
(statearr_55276_55289[(2)] = inst_55245);

(statearr_55276_55289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55277 = [null,null,null,null,null,null,null,null];
(statearr_55277[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55277[(1)] = (1));

return statearr_55277;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55265){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55265);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55278){var ex__2417__auto__ = e55278;
var statearr_55279_55290 = state_55265;
(statearr_55279_55290[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55265[(4)]))){
var statearr_55280_55291 = state_55265;
(statearr_55280_55291[(1)] = cljs.core.first((state_55265[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55292 = state_55265;
state_55265 = G__55292;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55265){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55281 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55281[(6)] = c__2436__auto__);

return statearr_55281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55233){
var G__55234 = cljs.core.first(seq55233);
var seq55233__$1 = cljs.core.next(seq55233);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55234,seq55233__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55342 = arguments.length;
var i__4737__auto___55343 = (0);
while(true){
if((i__4737__auto___55343 < len__4736__auto___55342)){
args__4742__auto__.push((arguments[i__4737__auto___55343]));

var G__55344 = (i__4737__auto___55343 + (1));
i__4737__auto___55343 = G__55344;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55325){
var state_val_55326 = (state_55325[(1)]);
if((state_val_55326 === (1))){
var state_55325__$1 = state_55325;
var statearr_55327_55345 = state_55325__$1;
(statearr_55327_55345[(2)] = null);

(statearr_55327_55345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55326 === (2))){
var _ = (function (){var statearr_55328 = state_55325;
(statearr_55328[(4)] = cljs.core.cons((5),(state_55325[(4)])));

return statearr_55328;
})();
var inst_55301 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55325__$1 = state_55325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55325__$1,(6),inst_55301);
} else {
if((state_val_55326 === (3))){
var inst_55323 = (state_55325[(2)]);
var state_55325__$1 = state_55325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55325__$1,inst_55323);
} else {
if((state_val_55326 === (4))){
var inst_55295 = (state_55325[(2)]);
var state_55325__$1 = state_55325;
var statearr_55330_55346 = state_55325__$1;
(statearr_55330_55346[(2)] = inst_55295);

(statearr_55330_55346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55326 === (5))){
var _ = (function (){var statearr_55331 = state_55325;
(statearr_55331[(4)] = cljs.core.rest((state_55325[(4)])));

return statearr_55331;
})();
var state_55325__$1 = state_55325;
var ex55329 = (state_55325__$1[(2)]);
var statearr_55332_55347 = state_55325__$1;
(statearr_55332_55347[(5)] = ex55329);


if((ex55329 instanceof Error)){
var statearr_55333_55348 = state_55325__$1;
(statearr_55333_55348[(1)] = (4));

(statearr_55333_55348[(5)] = null);

} else {
throw ex55329;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55326 === (6))){
var inst_55303 = (state_55325[(2)]);
var inst_55304 = fluree.db.util.async.throw_err(inst_55303);
var inst_55305 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55304);
var inst_55306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55307 = [inst_55304];
var inst_55308 = (new cljs.core.PersistentVector(null,1,(5),inst_55306,inst_55307,null));
var inst_55309 = cljs.core.count(inst_55308);
var inst_55310 = ((9) + inst_55309);
var inst_55311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55312 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55314 = [inst_55304];
var inst_55315 = (new cljs.core.PersistentVector(null,1,(5),inst_55313,inst_55314,null));
var inst_55316 = [">=",inst_55315,inst_55305];
var inst_55317 = cljs.core.PersistentHashMap.fromArrays(inst_55312,inst_55316);
var inst_55318 = [inst_55317,inst_55310];
var inst_55319 = (new cljs.core.PersistentVector(null,2,(5),inst_55311,inst_55318,null));
var inst_55320 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55319);
var _ = (function (){var statearr_55334 = state_55325;
(statearr_55334[(4)] = cljs.core.rest((state_55325[(4)])));

return statearr_55334;
})();
var state_55325__$1 = (function (){var statearr_55335 = state_55325;
(statearr_55335[(7)] = inst_55320);

return statearr_55335;
})();
var statearr_55336_55349 = state_55325__$1;
(statearr_55336_55349[(2)] = inst_55305);

(statearr_55336_55349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55337 = [null,null,null,null,null,null,null,null];
(statearr_55337[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55337[(1)] = (1));

return statearr_55337;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55325){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55325);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55338){var ex__2417__auto__ = e55338;
var statearr_55339_55350 = state_55325;
(statearr_55339_55350[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55325[(4)]))){
var statearr_55340_55351 = state_55325;
(statearr_55340_55351[(1)] = cljs.core.first((state_55325[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55352 = state_55325;
state_55325 = G__55352;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55325){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55341 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55341[(6)] = c__2436__auto__);

return statearr_55341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55293){
var G__55294 = cljs.core.first(seq55293);
var seq55293__$1 = cljs.core.next(seq55293);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55294,seq55293__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55402 = arguments.length;
var i__4737__auto___55403 = (0);
while(true){
if((i__4737__auto___55403 < len__4736__auto___55402)){
args__4742__auto__.push((arguments[i__4737__auto___55403]));

var G__55404 = (i__4737__auto___55403 + (1));
i__4737__auto___55403 = G__55404;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55385){
var state_val_55386 = (state_55385[(1)]);
if((state_val_55386 === (1))){
var state_55385__$1 = state_55385;
var statearr_55387_55405 = state_55385__$1;
(statearr_55387_55405[(2)] = null);

(statearr_55387_55405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55386 === (2))){
var _ = (function (){var statearr_55388 = state_55385;
(statearr_55388[(4)] = cljs.core.cons((5),(state_55385[(4)])));

return statearr_55388;
})();
var inst_55361 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55385__$1 = state_55385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55385__$1,(6),inst_55361);
} else {
if((state_val_55386 === (3))){
var inst_55383 = (state_55385[(2)]);
var state_55385__$1 = state_55385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55385__$1,inst_55383);
} else {
if((state_val_55386 === (4))){
var inst_55355 = (state_55385[(2)]);
var state_55385__$1 = state_55385;
var statearr_55390_55406 = state_55385__$1;
(statearr_55390_55406[(2)] = inst_55355);

(statearr_55390_55406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55386 === (5))){
var _ = (function (){var statearr_55391 = state_55385;
(statearr_55391[(4)] = cljs.core.rest((state_55385[(4)])));

return statearr_55391;
})();
var state_55385__$1 = state_55385;
var ex55389 = (state_55385__$1[(2)]);
var statearr_55392_55407 = state_55385__$1;
(statearr_55392_55407[(5)] = ex55389);


if((ex55389 instanceof Error)){
var statearr_55393_55408 = state_55385__$1;
(statearr_55393_55408[(1)] = (4));

(statearr_55393_55408[(5)] = null);

} else {
throw ex55389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55386 === (6))){
var inst_55363 = (state_55385[(2)]);
var inst_55364 = fluree.db.util.async.throw_err(inst_55363);
var inst_55365 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55364);
var inst_55366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55367 = [inst_55364];
var inst_55368 = (new cljs.core.PersistentVector(null,1,(5),inst_55366,inst_55367,null));
var inst_55369 = cljs.core.count(inst_55368);
var inst_55370 = ((9) + inst_55369);
var inst_55371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55372 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55374 = [inst_55364];
var inst_55375 = (new cljs.core.PersistentVector(null,1,(5),inst_55373,inst_55374,null));
var inst_55376 = ["not=",inst_55375,inst_55365];
var inst_55377 = cljs.core.PersistentHashMap.fromArrays(inst_55372,inst_55376);
var inst_55378 = [inst_55377,inst_55370];
var inst_55379 = (new cljs.core.PersistentVector(null,2,(5),inst_55371,inst_55378,null));
var inst_55380 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55379);
var _ = (function (){var statearr_55394 = state_55385;
(statearr_55394[(4)] = cljs.core.rest((state_55385[(4)])));

return statearr_55394;
})();
var state_55385__$1 = (function (){var statearr_55395 = state_55385;
(statearr_55395[(7)] = inst_55380);

return statearr_55395;
})();
var statearr_55396_55409 = state_55385__$1;
(statearr_55396_55409[(2)] = inst_55365);

(statearr_55396_55409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55397 = [null,null,null,null,null,null,null,null];
(statearr_55397[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55397[(1)] = (1));

return statearr_55397;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55385){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55385);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55398){var ex__2417__auto__ = e55398;
var statearr_55399_55410 = state_55385;
(statearr_55399_55410[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55385[(4)]))){
var statearr_55400_55411 = state_55385;
(statearr_55400_55411[(1)] = cljs.core.first((state_55385[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55412 = state_55385;
state_55385 = G__55412;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55385){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55401 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55401[(6)] = c__2436__auto__);

return statearr_55401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55353){
var G__55354 = cljs.core.first(seq55353);
var seq55353__$1 = cljs.core.next(seq55353);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55354,seq55353__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55462 = arguments.length;
var i__4737__auto___55463 = (0);
while(true){
if((i__4737__auto___55463 < len__4736__auto___55462)){
args__4742__auto__.push((arguments[i__4737__auto___55463]));

var G__55464 = (i__4737__auto___55463 + (1));
i__4737__auto___55463 = G__55464;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55445){
var state_val_55446 = (state_55445[(1)]);
if((state_val_55446 === (1))){
var state_55445__$1 = state_55445;
var statearr_55447_55465 = state_55445__$1;
(statearr_55447_55465[(2)] = null);

(statearr_55447_55465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55446 === (2))){
var _ = (function (){var statearr_55448 = state_55445;
(statearr_55448[(4)] = cljs.core.cons((5),(state_55445[(4)])));

return statearr_55448;
})();
var inst_55421 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55445__$1 = state_55445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55445__$1,(6),inst_55421);
} else {
if((state_val_55446 === (3))){
var inst_55443 = (state_55445[(2)]);
var state_55445__$1 = state_55445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55445__$1,inst_55443);
} else {
if((state_val_55446 === (4))){
var inst_55415 = (state_55445[(2)]);
var state_55445__$1 = state_55445;
var statearr_55450_55466 = state_55445__$1;
(statearr_55450_55466[(2)] = inst_55415);

(statearr_55450_55466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55446 === (5))){
var _ = (function (){var statearr_55451 = state_55445;
(statearr_55451[(4)] = cljs.core.rest((state_55445[(4)])));

return statearr_55451;
})();
var state_55445__$1 = state_55445;
var ex55449 = (state_55445__$1[(2)]);
var statearr_55452_55467 = state_55445__$1;
(statearr_55452_55467[(5)] = ex55449);


if((ex55449 instanceof Error)){
var statearr_55453_55468 = state_55445__$1;
(statearr_55453_55468[(1)] = (4));

(statearr_55453_55468[(5)] = null);

} else {
throw ex55449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55446 === (6))){
var inst_55423 = (state_55445[(2)]);
var inst_55424 = fluree.db.util.async.throw_err(inst_55423);
var inst_55425 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55424);
var inst_55426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55427 = [inst_55424];
var inst_55428 = (new cljs.core.PersistentVector(null,1,(5),inst_55426,inst_55427,null));
var inst_55429 = cljs.core.count(inst_55428);
var inst_55430 = ((9) + inst_55429);
var inst_55431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55432 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55434 = [inst_55424];
var inst_55435 = (new cljs.core.PersistentVector(null,1,(5),inst_55433,inst_55434,null));
var inst_55436 = ["max",inst_55435,inst_55425];
var inst_55437 = cljs.core.PersistentHashMap.fromArrays(inst_55432,inst_55436);
var inst_55438 = [inst_55437,inst_55430];
var inst_55439 = (new cljs.core.PersistentVector(null,2,(5),inst_55431,inst_55438,null));
var inst_55440 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55439);
var _ = (function (){var statearr_55454 = state_55445;
(statearr_55454[(4)] = cljs.core.rest((state_55445[(4)])));

return statearr_55454;
})();
var state_55445__$1 = (function (){var statearr_55455 = state_55445;
(statearr_55455[(7)] = inst_55440);

return statearr_55455;
})();
var statearr_55456_55469 = state_55445__$1;
(statearr_55456_55469[(2)] = inst_55425);

(statearr_55456_55469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55457 = [null,null,null,null,null,null,null,null];
(statearr_55457[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55457[(1)] = (1));

return statearr_55457;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55445){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55445);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55458){var ex__2417__auto__ = e55458;
var statearr_55459_55470 = state_55445;
(statearr_55459_55470[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55445[(4)]))){
var statearr_55460_55471 = state_55445;
(statearr_55460_55471[(1)] = cljs.core.first((state_55445[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55472 = state_55445;
state_55445 = G__55472;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55445){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55461 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55461[(6)] = c__2436__auto__);

return statearr_55461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55413){
var G__55414 = cljs.core.first(seq55413);
var seq55413__$1 = cljs.core.next(seq55413);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55414,seq55413__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55522 = arguments.length;
var i__4737__auto___55523 = (0);
while(true){
if((i__4737__auto___55523 < len__4736__auto___55522)){
args__4742__auto__.push((arguments[i__4737__auto___55523]));

var G__55524 = (i__4737__auto___55523 + (1));
i__4737__auto___55523 = G__55524;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55505){
var state_val_55506 = (state_55505[(1)]);
if((state_val_55506 === (1))){
var state_55505__$1 = state_55505;
var statearr_55507_55525 = state_55505__$1;
(statearr_55507_55525[(2)] = null);

(statearr_55507_55525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55506 === (2))){
var _ = (function (){var statearr_55508 = state_55505;
(statearr_55508[(4)] = cljs.core.cons((5),(state_55505[(4)])));

return statearr_55508;
})();
var inst_55481 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55505__$1 = state_55505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55505__$1,(6),inst_55481);
} else {
if((state_val_55506 === (3))){
var inst_55503 = (state_55505[(2)]);
var state_55505__$1 = state_55505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55505__$1,inst_55503);
} else {
if((state_val_55506 === (4))){
var inst_55475 = (state_55505[(2)]);
var state_55505__$1 = state_55505;
var statearr_55510_55526 = state_55505__$1;
(statearr_55510_55526[(2)] = inst_55475);

(statearr_55510_55526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55506 === (5))){
var _ = (function (){var statearr_55511 = state_55505;
(statearr_55511[(4)] = cljs.core.rest((state_55505[(4)])));

return statearr_55511;
})();
var state_55505__$1 = state_55505;
var ex55509 = (state_55505__$1[(2)]);
var statearr_55512_55527 = state_55505__$1;
(statearr_55512_55527[(5)] = ex55509);


if((ex55509 instanceof Error)){
var statearr_55513_55528 = state_55505__$1;
(statearr_55513_55528[(1)] = (4));

(statearr_55513_55528[(5)] = null);

} else {
throw ex55509;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55506 === (6))){
var inst_55483 = (state_55505[(2)]);
var inst_55484 = fluree.db.util.async.throw_err(inst_55483);
var inst_55485 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55484);
var inst_55486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55487 = [inst_55484];
var inst_55488 = (new cljs.core.PersistentVector(null,1,(5),inst_55486,inst_55487,null));
var inst_55489 = cljs.core.count(inst_55488);
var inst_55490 = ((9) + inst_55489);
var inst_55491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55492 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55494 = [inst_55484];
var inst_55495 = (new cljs.core.PersistentVector(null,1,(5),inst_55493,inst_55494,null));
var inst_55496 = ["min",inst_55495,inst_55485];
var inst_55497 = cljs.core.PersistentHashMap.fromArrays(inst_55492,inst_55496);
var inst_55498 = [inst_55497,inst_55490];
var inst_55499 = (new cljs.core.PersistentVector(null,2,(5),inst_55491,inst_55498,null));
var inst_55500 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55499);
var _ = (function (){var statearr_55514 = state_55505;
(statearr_55514[(4)] = cljs.core.rest((state_55505[(4)])));

return statearr_55514;
})();
var state_55505__$1 = (function (){var statearr_55515 = state_55505;
(statearr_55515[(7)] = inst_55500);

return statearr_55515;
})();
var statearr_55516_55529 = state_55505__$1;
(statearr_55516_55529[(2)] = inst_55485);

(statearr_55516_55529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55517 = [null,null,null,null,null,null,null,null];
(statearr_55517[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55517[(1)] = (1));

return statearr_55517;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55505){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55505);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55518){var ex__2417__auto__ = e55518;
var statearr_55519_55530 = state_55505;
(statearr_55519_55530[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55505[(4)]))){
var statearr_55520_55531 = state_55505;
(statearr_55520_55531[(1)] = cljs.core.first((state_55505[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55532 = state_55505;
state_55505 = G__55532;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55505){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55521 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55521[(6)] = c__2436__auto__);

return statearr_55521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55473){
var G__55474 = cljs.core.first(seq55473);
var seq55473__$1 = cljs.core.next(seq55473);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55474,seq55473__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55534 = arguments.length;
switch (G__55534) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55579){
var state_val_55580 = (state_55579[(1)]);
if((state_val_55580 === (7))){
var state_55579__$1 = state_55579;
var statearr_55581_55718 = state_55579__$1;
(statearr_55581_55718[(2)] = query_map);

(statearr_55581_55718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (1))){
var state_55579__$1 = state_55579;
var statearr_55582_55719 = state_55579__$1;
(statearr_55582_55719[(2)] = null);

(statearr_55582_55719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (4))){
var inst_55535 = (state_55579[(2)]);
var state_55579__$1 = state_55579;
var statearr_55583_55720 = state_55579__$1;
(statearr_55583_55720[(2)] = inst_55535);

(statearr_55583_55720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (13))){
var inst_55557 = (state_55579[(7)]);
var inst_55561 = (state_55579[(2)]);
var inst_55562 = fluree.db.util.async.throw_err(inst_55561);
var inst_55563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55562,(0),null);
var inst_55564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55562,(1),null);
var inst_55565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55566 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55568 = [inst_55557];
var inst_55569 = (new cljs.core.PersistentVector(null,1,(5),inst_55567,inst_55568,null));
var inst_55570 = ["query",inst_55569,inst_55563];
var inst_55571 = cljs.core.PersistentHashMap.fromArrays(inst_55566,inst_55570);
var inst_55572 = [inst_55571,inst_55564];
var inst_55573 = (new cljs.core.PersistentVector(null,2,(5),inst_55565,inst_55572,null));
var inst_55574 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55573);
var _ = (function (){var statearr_55584 = state_55579;
(statearr_55584[(4)] = cljs.core.rest((state_55579[(4)])));

return statearr_55584;
})();
var state_55579__$1 = (function (){var statearr_55585 = state_55579;
(statearr_55585[(8)] = inst_55574);

return statearr_55585;
})();
var statearr_55586_55721 = state_55579__$1;
(statearr_55586_55721[(2)] = inst_55563);

(statearr_55586_55721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (6))){
var state_55579__$1 = state_55579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55579__$1,(9),query_map);
} else {
if((state_val_55580 === (3))){
var inst_55577 = (state_55579[(2)]);
var state_55579__$1 = state_55579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55579__$1,inst_55577);
} else {
if((state_val_55580 === (12))){
var inst_55557 = (state_55579[(7)]);
var inst_55557__$1 = (state_55579[(2)]);
var inst_55558 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55559 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55558,inst_55557__$1);
var state_55579__$1 = (function (){var statearr_55587 = state_55579;
(statearr_55587[(7)] = inst_55557__$1);

return statearr_55587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55579__$1,(13),inst_55559);
} else {
if((state_val_55580 === (2))){
var _ = (function (){var statearr_55588 = state_55579;
(statearr_55588[(4)] = cljs.core.cons((5),(state_55579[(4)])));

return statearr_55588;
})();
var inst_55544 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55579__$1 = state_55579;
if(inst_55544){
var statearr_55589_55722 = state_55579__$1;
(statearr_55589_55722[(1)] = (6));

} else {
var statearr_55590_55723 = state_55579__$1;
(statearr_55590_55723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (11))){
var inst_55551 = (state_55579[(9)]);
var state_55579__$1 = state_55579;
var statearr_55592_55724 = state_55579__$1;
(statearr_55592_55724[(2)] = inst_55551);

(statearr_55592_55724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (9))){
var inst_55547 = (state_55579[(2)]);
var inst_55548 = fluree.db.util.async.throw_err(inst_55547);
var state_55579__$1 = state_55579;
var statearr_55593_55725 = state_55579__$1;
(statearr_55593_55725[(2)] = inst_55548);

(statearr_55593_55725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (5))){
var _ = (function (){var statearr_55594 = state_55579;
(statearr_55594[(4)] = cljs.core.rest((state_55579[(4)])));

return statearr_55594;
})();
var state_55579__$1 = state_55579;
var ex55591 = (state_55579__$1[(2)]);
var statearr_55595_55726 = state_55579__$1;
(statearr_55595_55726[(5)] = ex55591);


if((ex55591 instanceof Error)){
var statearr_55596_55727 = state_55579__$1;
(statearr_55596_55727[(1)] = (4));

(statearr_55596_55727[(5)] = null);

} else {
throw ex55591;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (10))){
var inst_55551 = (state_55579[(9)]);
var inst_55554 = fluree.db.util.json.parse(inst_55551);
var state_55579__$1 = state_55579;
var statearr_55597_55728 = state_55579__$1;
(statearr_55597_55728[(2)] = inst_55554);

(statearr_55597_55728[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55580 === (8))){
var inst_55551 = (state_55579[(9)]);
var inst_55551__$1 = (state_55579[(2)]);
var inst_55552 = typeof inst_55551__$1 === 'string';
var state_55579__$1 = (function (){var statearr_55598 = state_55579;
(statearr_55598[(9)] = inst_55551__$1);

return statearr_55598;
})();
if(cljs.core.truth_(inst_55552)){
var statearr_55599_55729 = state_55579__$1;
(statearr_55599_55729[(1)] = (10));

} else {
var statearr_55600_55730 = state_55579__$1;
(statearr_55600_55730[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55601 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55601[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55601[(1)] = (1));

return statearr_55601;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55579){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55579);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55602){var ex__2417__auto__ = e55602;
var statearr_55603_55731 = state_55579;
(statearr_55603_55731[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55579[(4)]))){
var statearr_55604_55732 = state_55579;
(statearr_55604_55732[(1)] = cljs.core.first((state_55579[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55733 = state_55579;
state_55579 = G__55733;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55605 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55605[(6)] = c__2436__auto__);

return statearr_55605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55676){
var state_val_55677 = (state_55676[(1)]);
if((state_val_55677 === (7))){
var state_55676__$1 = state_55676;
var statearr_55678_55734 = state_55676__$1;
(statearr_55678_55734[(2)] = select);

(statearr_55678_55734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (20))){
var inst_55646 = (state_55676[(2)]);
var inst_55647 = fluree.db.util.async.channel_QMARK_(limit);
var state_55676__$1 = (function (){var statearr_55679 = state_55676;
(statearr_55679[(7)] = inst_55646);

return statearr_55679;
})();
if(inst_55647){
var statearr_55680_55735 = state_55676__$1;
(statearr_55680_55735[(1)] = (22));

} else {
var statearr_55681_55736 = state_55676__$1;
(statearr_55681_55736[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (1))){
var state_55676__$1 = state_55676;
var statearr_55682_55737 = state_55676__$1;
(statearr_55682_55737[(2)] = null);

(statearr_55682_55737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (24))){
var inst_55622 = (state_55676[(8)]);
var inst_55630 = (state_55676[(9)]);
var inst_55638 = (state_55676[(10)]);
var inst_55646 = (state_55676[(7)]);
var inst_55654 = (state_55676[(2)]);
var inst_55655 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55656 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_55655,inst_55622,inst_55630,inst_55638,inst_55646,inst_55654);
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(26),inst_55656);
} else {
if((state_val_55677 === (4))){
var inst_55606 = (state_55676[(2)]);
var state_55676__$1 = state_55676;
var statearr_55683_55738 = state_55676__$1;
(statearr_55683_55738[(2)] = inst_55606);

(statearr_55683_55738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (15))){
var state_55676__$1 = state_55676;
var statearr_55684_55739 = state_55676__$1;
(statearr_55684_55739[(2)] = where);

(statearr_55684_55739[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (21))){
var inst_55642 = (state_55676[(2)]);
var inst_55643 = fluree.db.util.async.throw_err(inst_55642);
var state_55676__$1 = state_55676;
var statearr_55685_55740 = state_55676__$1;
(statearr_55685_55740[(2)] = inst_55643);

(statearr_55685_55740[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (13))){
var inst_55626 = (state_55676[(2)]);
var inst_55627 = fluree.db.util.async.throw_err(inst_55626);
var state_55676__$1 = state_55676;
var statearr_55686_55741 = state_55676__$1;
(statearr_55686_55741[(2)] = inst_55627);

(statearr_55686_55741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (22))){
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(25),limit);
} else {
if((state_val_55677 === (6))){
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(9),select);
} else {
if((state_val_55677 === (25))){
var inst_55650 = (state_55676[(2)]);
var inst_55651 = fluree.db.util.async.throw_err(inst_55650);
var state_55676__$1 = state_55676;
var statearr_55687_55742 = state_55676__$1;
(statearr_55687_55742[(2)] = inst_55651);

(statearr_55687_55742[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (17))){
var inst_55634 = (state_55676[(2)]);
var inst_55635 = fluree.db.util.async.throw_err(inst_55634);
var state_55676__$1 = state_55676;
var statearr_55688_55743 = state_55676__$1;
(statearr_55688_55743[(2)] = inst_55635);

(statearr_55688_55743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (3))){
var inst_55674 = (state_55676[(2)]);
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55676__$1,inst_55674);
} else {
if((state_val_55677 === (12))){
var inst_55630 = (state_55676[(2)]);
var inst_55631 = fluree.db.util.async.channel_QMARK_(where);
var state_55676__$1 = (function (){var statearr_55689 = state_55676;
(statearr_55689[(9)] = inst_55630);

return statearr_55689;
})();
if(inst_55631){
var statearr_55690_55744 = state_55676__$1;
(statearr_55690_55744[(1)] = (14));

} else {
var statearr_55691_55745 = state_55676__$1;
(statearr_55691_55745[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (2))){
var _ = (function (){var statearr_55692 = state_55676;
(statearr_55692[(4)] = cljs.core.cons((5),(state_55676[(4)])));

return statearr_55692;
})();
var inst_55615 = fluree.db.util.async.channel_QMARK_(select);
var state_55676__$1 = state_55676;
if(inst_55615){
var statearr_55693_55746 = state_55676__$1;
(statearr_55693_55746[(1)] = (6));

} else {
var statearr_55694_55747 = state_55676__$1;
(statearr_55694_55747[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (23))){
var state_55676__$1 = state_55676;
var statearr_55695_55748 = state_55676__$1;
(statearr_55695_55748[(2)] = limit);

(statearr_55695_55748[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (19))){
var state_55676__$1 = state_55676;
var statearr_55696_55749 = state_55676__$1;
(statearr_55696_55749[(2)] = block);

(statearr_55696_55749[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (11))){
var state_55676__$1 = state_55676;
var statearr_55698_55750 = state_55676__$1;
(statearr_55698_55750[(2)] = from);

(statearr_55698_55750[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (9))){
var inst_55618 = (state_55676[(2)]);
var inst_55619 = fluree.db.util.async.throw_err(inst_55618);
var state_55676__$1 = state_55676;
var statearr_55699_55751 = state_55676__$1;
(statearr_55699_55751[(2)] = inst_55619);

(statearr_55699_55751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (5))){
var _ = (function (){var statearr_55700 = state_55676;
(statearr_55700[(4)] = cljs.core.rest((state_55676[(4)])));

return statearr_55700;
})();
var state_55676__$1 = state_55676;
var ex55697 = (state_55676__$1[(2)]);
var statearr_55701_55752 = state_55676__$1;
(statearr_55701_55752[(5)] = ex55697);


if((ex55697 instanceof Error)){
var statearr_55702_55753 = state_55676__$1;
(statearr_55702_55753[(1)] = (4));

(statearr_55702_55753[(5)] = null);

} else {
throw ex55697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (14))){
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(17),where);
} else {
if((state_val_55677 === (26))){
var inst_55622 = (state_55676[(8)]);
var inst_55630 = (state_55676[(9)]);
var inst_55638 = (state_55676[(10)]);
var inst_55646 = (state_55676[(7)]);
var inst_55658 = (state_55676[(2)]);
var inst_55659 = fluree.db.util.async.throw_err(inst_55658);
var inst_55660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55659,(0),null);
var inst_55661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55659,(1),null);
var inst_55662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55663 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55665 = [inst_55622,inst_55630,inst_55638,inst_55646];
var inst_55666 = (new cljs.core.PersistentVector(null,4,(5),inst_55664,inst_55665,null));
var inst_55667 = ["query",inst_55666,inst_55660];
var inst_55668 = cljs.core.PersistentHashMap.fromArrays(inst_55663,inst_55667);
var inst_55669 = [inst_55668,inst_55661];
var inst_55670 = (new cljs.core.PersistentVector(null,2,(5),inst_55662,inst_55669,null));
var inst_55671 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55670);
var _ = (function (){var statearr_55703 = state_55676;
(statearr_55703[(4)] = cljs.core.rest((state_55676[(4)])));

return statearr_55703;
})();
var state_55676__$1 = (function (){var statearr_55704 = state_55676;
(statearr_55704[(11)] = inst_55671);

return statearr_55704;
})();
var statearr_55705_55754 = state_55676__$1;
(statearr_55705_55754[(2)] = inst_55660);

(statearr_55705_55754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (16))){
var inst_55638 = (state_55676[(2)]);
var inst_55639 = fluree.db.util.async.channel_QMARK_(block);
var state_55676__$1 = (function (){var statearr_55706 = state_55676;
(statearr_55706[(10)] = inst_55638);

return statearr_55706;
})();
if(inst_55639){
var statearr_55707_55755 = state_55676__$1;
(statearr_55707_55755[(1)] = (18));

} else {
var statearr_55708_55756 = state_55676__$1;
(statearr_55708_55756[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55677 === (10))){
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(13),from);
} else {
if((state_val_55677 === (18))){
var state_55676__$1 = state_55676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55676__$1,(21),block);
} else {
if((state_val_55677 === (8))){
var inst_55622 = (state_55676[(2)]);
var inst_55623 = fluree.db.util.async.channel_QMARK_(from);
var state_55676__$1 = (function (){var statearr_55709 = state_55676;
(statearr_55709[(8)] = inst_55622);

return statearr_55709;
})();
if(inst_55623){
var statearr_55710_55757 = state_55676__$1;
(statearr_55710_55757[(1)] = (10));

} else {
var statearr_55711_55758 = state_55676__$1;
(statearr_55711_55758[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_55712 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55712[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_55712[(1)] = (1));

return statearr_55712;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_55676){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55676);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55713){var ex__2417__auto__ = e55713;
var statearr_55714_55759 = state_55676;
(statearr_55714_55759[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55676[(4)]))){
var statearr_55715_55760 = state_55676;
(statearr_55715_55760[(1)] = cljs.core.first((state_55676[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55761 = state_55676;
state_55676 = G__55761;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_55676){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_55676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55716 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55716[(6)] = c__2436__auto__);

return statearr_55716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55817){
var state_val_55818 = (state_55817[(1)]);
if((state_val_55818 === (7))){
var state_55817__$1 = state_55817;
var statearr_55819_55850 = state_55817__$1;
(statearr_55819_55850[(2)] = startSubject);

(statearr_55819_55850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (1))){
var state_55817__$1 = state_55817;
var statearr_55820_55851 = state_55817__$1;
(statearr_55820_55851[(2)] = null);

(statearr_55820_55851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (4))){
var inst_55762 = (state_55817[(2)]);
var state_55817__$1 = state_55817;
var statearr_55821_55852 = state_55817__$1;
(statearr_55821_55852[(2)] = inst_55762);

(statearr_55821_55852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (15))){
var inst_55794 = (state_55817[(2)]);
var inst_55795 = fluree.db.util.async.throw_err(inst_55794);
var inst_55796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55795,(0),null);
var inst_55797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55795,(1),null);
var inst_55798 = cljs.core.empty_QMARK_(inst_55796);
var state_55817__$1 = (function (){var statearr_55822 = state_55817;
(statearr_55822[(7)] = inst_55797);

return statearr_55822;
})();
if(inst_55798){
var statearr_55823_55853 = state_55817__$1;
(statearr_55823_55853[(1)] = (16));

} else {
var statearr_55824_55854 = state_55817__$1;
(statearr_55824_55854[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (13))){
var inst_55778 = (state_55817[(8)]);
var inst_55790 = (state_55817[(9)]);
var inst_55782 = (state_55817[(10)]);
var inst_55790__$1 = (state_55817[(2)]);
var inst_55791 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55792 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_55791,inst_55778,inst_55782,inst_55790__$1);
var state_55817__$1 = (function (){var statearr_55825 = state_55817;
(statearr_55825[(9)] = inst_55790__$1);

return statearr_55825;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55817__$1,(15),inst_55792);
} else {
if((state_val_55818 === (6))){
var state_55817__$1 = state_55817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55817__$1,(9),startSubject);
} else {
if((state_val_55818 === (17))){
var state_55817__$1 = state_55817;
var statearr_55826_55855 = state_55817__$1;
(statearr_55826_55855[(2)] = true);

(statearr_55826_55855[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (3))){
var inst_55815 = (state_55817[(2)]);
var state_55817__$1 = state_55817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55817__$1,inst_55815);
} else {
if((state_val_55818 === (12))){
var state_55817__$1 = state_55817;
var statearr_55827_55856 = state_55817__$1;
(statearr_55827_55856[(2)] = endSubject);

(statearr_55827_55856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (2))){
var _ = (function (){var statearr_55828 = state_55817;
(statearr_55828[(4)] = cljs.core.cons((5),(state_55817[(4)])));

return statearr_55828;
})();
var inst_55771 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55817__$1 = state_55817;
if(inst_55771){
var statearr_55829_55857 = state_55817__$1;
(statearr_55829_55857[(1)] = (6));

} else {
var statearr_55830_55858 = state_55817__$1;
(statearr_55830_55858[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (11))){
var state_55817__$1 = state_55817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55817__$1,(14),endSubject);
} else {
if((state_val_55818 === (9))){
var inst_55774 = (state_55817[(2)]);
var inst_55775 = fluree.db.util.async.throw_err(inst_55774);
var state_55817__$1 = state_55817;
var statearr_55832_55859 = state_55817__$1;
(statearr_55832_55859[(2)] = inst_55775);

(statearr_55832_55859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (5))){
var _ = (function (){var statearr_55833 = state_55817;
(statearr_55833[(4)] = cljs.core.rest((state_55817[(4)])));

return statearr_55833;
})();
var state_55817__$1 = state_55817;
var ex55831 = (state_55817__$1[(2)]);
var statearr_55834_55860 = state_55817__$1;
(statearr_55834_55860[(5)] = ex55831);


if((ex55831 instanceof Error)){
var statearr_55835_55861 = state_55817__$1;
(statearr_55835_55861[(1)] = (4));

(statearr_55835_55861[(5)] = null);

} else {
throw ex55831;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (14))){
var inst_55786 = (state_55817[(2)]);
var inst_55787 = fluree.db.util.async.throw_err(inst_55786);
var state_55817__$1 = state_55817;
var statearr_55836_55862 = state_55817__$1;
(statearr_55836_55862[(2)] = inst_55787);

(statearr_55836_55862[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (16))){
var state_55817__$1 = state_55817;
var statearr_55837_55863 = state_55817__$1;
(statearr_55837_55863[(2)] = false);

(statearr_55837_55863[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (10))){
var inst_55781 = (state_55817[(2)]);
var inst_55782 = fluree.db.util.async.throw_err(inst_55781);
var inst_55783 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55817__$1 = (function (){var statearr_55838 = state_55817;
(statearr_55838[(10)] = inst_55782);

return statearr_55838;
})();
if(inst_55783){
var statearr_55839_55864 = state_55817__$1;
(statearr_55839_55864[(1)] = (11));

} else {
var statearr_55840_55865 = state_55817__$1;
(statearr_55840_55865[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (18))){
var inst_55797 = (state_55817[(7)]);
var inst_55778 = (state_55817[(8)]);
var inst_55790 = (state_55817[(9)]);
var inst_55782 = (state_55817[(10)]);
var inst_55802 = (state_55817[(2)]);
var inst_55803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55804 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55806 = [inst_55778,inst_55782,inst_55790];
var inst_55807 = (new cljs.core.PersistentVector(null,3,(5),inst_55805,inst_55806,null));
var inst_55808 = ["relationship?",inst_55807,inst_55802];
var inst_55809 = cljs.core.PersistentHashMap.fromArrays(inst_55804,inst_55808);
var inst_55810 = [inst_55809,inst_55797];
var inst_55811 = (new cljs.core.PersistentVector(null,2,(5),inst_55803,inst_55810,null));
var inst_55812 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55811);
var _ = (function (){var statearr_55841 = state_55817;
(statearr_55841[(4)] = cljs.core.rest((state_55817[(4)])));

return statearr_55841;
})();
var state_55817__$1 = (function (){var statearr_55842 = state_55817;
(statearr_55842[(11)] = inst_55812);

return statearr_55842;
})();
var statearr_55843_55866 = state_55817__$1;
(statearr_55843_55866[(2)] = inst_55802);

(statearr_55843_55866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55818 === (8))){
var inst_55778 = (state_55817[(2)]);
var inst_55779 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55817__$1 = (function (){var statearr_55844 = state_55817;
(statearr_55844[(8)] = inst_55778);

return statearr_55844;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55817__$1,(10),inst_55779);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_55845 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55845[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__);

(statearr_55845[(1)] = (1));

return statearr_55845;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1 = (function (state_55817){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55817);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55846){var ex__2417__auto__ = e55846;
var statearr_55847_55867 = state_55817;
(statearr_55847_55867[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55817[(4)]))){
var statearr_55848_55868 = state_55817;
(statearr_55848_55868[(1)] = cljs.core.first((state_55817[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55869 = state_55817;
state_55817 = G__55869;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__ = function(state_55817){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1.call(this,state_55817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55849 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55849[(6)] = c__2436__auto__);

return statearr_55849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55906){
var state_val_55907 = (state_55906[(1)]);
if((state_val_55907 === (7))){
var state_55906__$1 = state_55906;
var statearr_55908_55928 = state_55906__$1;
(statearr_55908_55928[(2)] = pred_name);

(statearr_55908_55928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (1))){
var state_55906__$1 = state_55906;
var statearr_55909_55929 = state_55906__$1;
(statearr_55909_55929[(2)] = null);

(statearr_55909_55929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (4))){
var inst_55870 = (state_55906[(2)]);
var state_55906__$1 = state_55906;
var statearr_55910_55930 = state_55906__$1;
(statearr_55910_55930[(2)] = inst_55870);

(statearr_55910_55930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (6))){
var state_55906__$1 = state_55906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55906__$1,(9),pred_name);
} else {
if((state_val_55907 === (3))){
var inst_55904 = (state_55906[(2)]);
var state_55906__$1 = state_55906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55906__$1,inst_55904);
} else {
if((state_val_55907 === (2))){
var _ = (function (){var statearr_55912 = state_55906;
(statearr_55912[(4)] = cljs.core.cons((5),(state_55906[(4)])));

return statearr_55912;
})();
var inst_55879 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55906__$1 = state_55906;
if(inst_55879){
var statearr_55913_55931 = state_55906__$1;
(statearr_55913_55931[(1)] = (6));

} else {
var statearr_55914_55932 = state_55906__$1;
(statearr_55914_55932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (9))){
var inst_55882 = (state_55906[(2)]);
var inst_55883 = fluree.db.util.async.throw_err(inst_55882);
var state_55906__$1 = state_55906;
var statearr_55915_55933 = state_55906__$1;
(statearr_55915_55933[(2)] = inst_55883);

(statearr_55915_55933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (5))){
var _ = (function (){var statearr_55916 = state_55906;
(statearr_55916[(4)] = cljs.core.rest((state_55906[(4)])));

return statearr_55916;
})();
var state_55906__$1 = state_55906;
var ex55911 = (state_55906__$1[(2)]);
var statearr_55917_55934 = state_55906__$1;
(statearr_55917_55934[(5)] = ex55911);


if((ex55911 instanceof Error)){
var statearr_55918_55935 = state_55906__$1;
(statearr_55918_55935[(1)] = (4));

(statearr_55918_55935[(5)] = null);

} else {
throw ex55911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (10))){
var inst_55886 = (state_55906[(7)]);
var inst_55890 = (state_55906[(2)]);
var inst_55891 = fluree.db.util.async.throw_err(inst_55890);
var inst_55892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55891,(0),null);
var inst_55893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55891,(1),null);
var inst_55894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55895 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55896 = ["max-pred-val",inst_55886,inst_55892];
var inst_55897 = cljs.core.PersistentHashMap.fromArrays(inst_55895,inst_55896);
var inst_55898 = (inst_55893 + (10));
var inst_55899 = [inst_55897,inst_55898];
var inst_55900 = (new cljs.core.PersistentVector(null,2,(5),inst_55894,inst_55899,null));
var inst_55901 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55900);
var _ = (function (){var statearr_55919 = state_55906;
(statearr_55919[(4)] = cljs.core.rest((state_55906[(4)])));

return statearr_55919;
})();
var state_55906__$1 = (function (){var statearr_55920 = state_55906;
(statearr_55920[(8)] = inst_55901);

return statearr_55920;
})();
var statearr_55921_55936 = state_55906__$1;
(statearr_55921_55936[(2)] = inst_55892);

(statearr_55921_55936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55907 === (8))){
var inst_55886 = (state_55906[(7)]);
var inst_55886__$1 = (state_55906[(2)]);
var inst_55887 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55888 = fluree.db.dbfunctions.internal.max_pred_val(inst_55887,inst_55886__$1,null);
var state_55906__$1 = (function (){var statearr_55922 = state_55906;
(statearr_55922[(7)] = inst_55886__$1);

return statearr_55922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55906__$1,(10),inst_55888);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0 = (function (){
var statearr_55923 = [null,null,null,null,null,null,null,null,null];
(statearr_55923[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__);

(statearr_55923[(1)] = (1));

return statearr_55923;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1 = (function (state_55906){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55906);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55924){var ex__2417__auto__ = e55924;
var statearr_55925_55937 = state_55906;
(statearr_55925_55937[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55906[(4)]))){
var statearr_55926_55938 = state_55906;
(statearr_55926_55938[(1)] = cljs.core.first((state_55906[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55939 = state_55906;
state_55906 = G__55939;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__ = function(state_55906){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1.call(this,state_55906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55927 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55927[(6)] = c__2436__auto__);

return statearr_55927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_55966){
var state_val_55967 = (state_55966[(1)]);
if((state_val_55967 === (7))){
var state_55966__$1 = state_55966;
var statearr_55968_55987 = state_55966__$1;
(statearr_55968_55987[(2)] = n);

(statearr_55968_55987[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (1))){
var state_55966__$1 = state_55966;
var statearr_55969_55988 = state_55966__$1;
(statearr_55969_55988[(2)] = null);

(statearr_55969_55988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (4))){
var inst_55940 = (state_55966[(2)]);
var state_55966__$1 = state_55966;
var statearr_55970_55989 = state_55966__$1;
(statearr_55970_55989[(2)] = inst_55940);

(statearr_55970_55989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (6))){
var state_55966__$1 = state_55966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55966__$1,(9),n);
} else {
if((state_val_55967 === (3))){
var inst_55964 = (state_55966[(2)]);
var state_55966__$1 = state_55966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55966__$1,inst_55964);
} else {
if((state_val_55967 === (2))){
var _ = (function (){var statearr_55972 = state_55966;
(statearr_55972[(4)] = cljs.core.cons((5),(state_55966[(4)])));

return statearr_55972;
})();
var inst_55946 = fluree.db.util.async.channel_QMARK_(n);
var state_55966__$1 = state_55966;
if(inst_55946){
var statearr_55973_55990 = state_55966__$1;
(statearr_55973_55990[(1)] = (6));

} else {
var statearr_55974_55991 = state_55966__$1;
(statearr_55974_55991[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (9))){
var inst_55949 = (state_55966[(2)]);
var inst_55950 = fluree.db.util.async.throw_err(inst_55949);
var state_55966__$1 = state_55966;
var statearr_55975_55992 = state_55966__$1;
(statearr_55975_55992[(2)] = inst_55950);

(statearr_55975_55992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (5))){
var _ = (function (){var statearr_55976 = state_55966;
(statearr_55976[(4)] = cljs.core.rest((state_55966[(4)])));

return statearr_55976;
})();
var state_55966__$1 = state_55966;
var ex55971 = (state_55966__$1[(2)]);
var statearr_55977_55993 = state_55966__$1;
(statearr_55977_55993[(5)] = ex55971);


if((ex55971 instanceof Error)){
var statearr_55978_55994 = state_55966__$1;
(statearr_55978_55994[(1)] = (4));

(statearr_55978_55994[(5)] = null);

} else {
throw ex55971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55967 === (8))){
var inst_55953 = (state_55966[(2)]);
var inst_55954 = fluree.db.dbfunctions.internal.inc(inst_55953);
var inst_55955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55956 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55957 = ["inc",inst_55953,inst_55954];
var inst_55958 = cljs.core.PersistentHashMap.fromArrays(inst_55956,inst_55957);
var inst_55959 = [inst_55958,(10)];
var inst_55960 = (new cljs.core.PersistentVector(null,2,(5),inst_55955,inst_55959,null));
var inst_55961 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55960);
var _ = (function (){var statearr_55979 = state_55966;
(statearr_55979[(4)] = cljs.core.rest((state_55966[(4)])));

return statearr_55979;
})();
var state_55966__$1 = (function (){var statearr_55980 = state_55966;
(statearr_55980[(7)] = inst_55961);

return statearr_55980;
})();
var statearr_55981_55995 = state_55966__$1;
(statearr_55981_55995[(2)] = inst_55954);

(statearr_55981_55995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0 = (function (){
var statearr_55982 = [null,null,null,null,null,null,null,null];
(statearr_55982[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__);

(statearr_55982[(1)] = (1));

return statearr_55982;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1 = (function (state_55966){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_55966);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e55983){var ex__2417__auto__ = e55983;
var statearr_55984_55996 = state_55966;
(statearr_55984_55996[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_55966[(4)]))){
var statearr_55985_55997 = state_55966;
(statearr_55985_55997[(1)] = cljs.core.first((state_55966[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55998 = state_55966;
state_55966 = G__55998;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__ = function(state_55966){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1.call(this,state_55966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_55986 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_55986[(6)] = c__2436__auto__);

return statearr_55986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56025){
var state_val_56026 = (state_56025[(1)]);
if((state_val_56026 === (7))){
var state_56025__$1 = state_56025;
var statearr_56027_56046 = state_56025__$1;
(statearr_56027_56046[(2)] = n);

(statearr_56027_56046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (1))){
var state_56025__$1 = state_56025;
var statearr_56028_56047 = state_56025__$1;
(statearr_56028_56047[(2)] = null);

(statearr_56028_56047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (4))){
var inst_55999 = (state_56025[(2)]);
var state_56025__$1 = state_56025;
var statearr_56029_56048 = state_56025__$1;
(statearr_56029_56048[(2)] = inst_55999);

(statearr_56029_56048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (6))){
var state_56025__$1 = state_56025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56025__$1,(9),n);
} else {
if((state_val_56026 === (3))){
var inst_56023 = (state_56025[(2)]);
var state_56025__$1 = state_56025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56025__$1,inst_56023);
} else {
if((state_val_56026 === (2))){
var _ = (function (){var statearr_56031 = state_56025;
(statearr_56031[(4)] = cljs.core.cons((5),(state_56025[(4)])));

return statearr_56031;
})();
var inst_56005 = fluree.db.util.async.channel_QMARK_(n);
var state_56025__$1 = state_56025;
if(inst_56005){
var statearr_56032_56049 = state_56025__$1;
(statearr_56032_56049[(1)] = (6));

} else {
var statearr_56033_56050 = state_56025__$1;
(statearr_56033_56050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (9))){
var inst_56008 = (state_56025[(2)]);
var inst_56009 = fluree.db.util.async.throw_err(inst_56008);
var state_56025__$1 = state_56025;
var statearr_56034_56051 = state_56025__$1;
(statearr_56034_56051[(2)] = inst_56009);

(statearr_56034_56051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (5))){
var _ = (function (){var statearr_56035 = state_56025;
(statearr_56035[(4)] = cljs.core.rest((state_56025[(4)])));

return statearr_56035;
})();
var state_56025__$1 = state_56025;
var ex56030 = (state_56025__$1[(2)]);
var statearr_56036_56052 = state_56025__$1;
(statearr_56036_56052[(5)] = ex56030);


if((ex56030 instanceof Error)){
var statearr_56037_56053 = state_56025__$1;
(statearr_56037_56053[(1)] = (4));

(statearr_56037_56053[(5)] = null);

} else {
throw ex56030;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56026 === (8))){
var inst_56012 = (state_56025[(2)]);
var inst_56013 = fluree.db.dbfunctions.internal.dec(inst_56012);
var inst_56014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56015 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56016 = ["dec",inst_56012,inst_56013];
var inst_56017 = cljs.core.PersistentHashMap.fromArrays(inst_56015,inst_56016);
var inst_56018 = [inst_56017,(10)];
var inst_56019 = (new cljs.core.PersistentVector(null,2,(5),inst_56014,inst_56018,null));
var inst_56020 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56019);
var _ = (function (){var statearr_56038 = state_56025;
(statearr_56038[(4)] = cljs.core.rest((state_56025[(4)])));

return statearr_56038;
})();
var state_56025__$1 = (function (){var statearr_56039 = state_56025;
(statearr_56039[(7)] = inst_56020);

return statearr_56039;
})();
var statearr_56040_56054 = state_56025__$1;
(statearr_56040_56054[(2)] = inst_56013);

(statearr_56040_56054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0 = (function (){
var statearr_56041 = [null,null,null,null,null,null,null,null];
(statearr_56041[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__);

(statearr_56041[(1)] = (1));

return statearr_56041;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1 = (function (state_56025){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56025);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56042){var ex__2417__auto__ = e56042;
var statearr_56043_56055 = state_56025;
(statearr_56043_56055[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56025[(4)]))){
var statearr_56044_56056 = state_56025;
(statearr_56044_56056[(1)] = cljs.core.first((state_56025[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56057 = state_56025;
state_56025 = G__56057;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__ = function(state_56025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1.call(this,state_56025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56045 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56045[(6)] = c__2436__auto__);

return statearr_56045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56107 = arguments.length;
var i__4737__auto___56108 = (0);
while(true){
if((i__4737__auto___56108 < len__4736__auto___56107)){
args__4742__auto__.push((arguments[i__4737__auto___56108]));

var G__56109 = (i__4737__auto___56108 + (1));
i__4737__auto___56108 = G__56109;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56090){
var state_val_56091 = (state_56090[(1)]);
if((state_val_56091 === (1))){
var state_56090__$1 = state_56090;
var statearr_56092_56110 = state_56090__$1;
(statearr_56092_56110[(2)] = null);

(statearr_56092_56110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56091 === (2))){
var _ = (function (){var statearr_56093 = state_56090;
(statearr_56093[(4)] = cljs.core.cons((5),(state_56090[(4)])));

return statearr_56093;
})();
var inst_56066 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56090__$1 = state_56090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56090__$1,(6),inst_56066);
} else {
if((state_val_56091 === (3))){
var inst_56088 = (state_56090[(2)]);
var state_56090__$1 = state_56090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56090__$1,inst_56088);
} else {
if((state_val_56091 === (4))){
var inst_56060 = (state_56090[(2)]);
var state_56090__$1 = state_56090;
var statearr_56095_56111 = state_56090__$1;
(statearr_56095_56111[(2)] = inst_56060);

(statearr_56095_56111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56091 === (5))){
var _ = (function (){var statearr_56096 = state_56090;
(statearr_56096[(4)] = cljs.core.rest((state_56090[(4)])));

return statearr_56096;
})();
var state_56090__$1 = state_56090;
var ex56094 = (state_56090__$1[(2)]);
var statearr_56097_56112 = state_56090__$1;
(statearr_56097_56112[(5)] = ex56094);


if((ex56094 instanceof Error)){
var statearr_56098_56113 = state_56090__$1;
(statearr_56098_56113[(1)] = (4));

(statearr_56098_56113[(5)] = null);

} else {
throw ex56094;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56091 === (6))){
var inst_56068 = (state_56090[(2)]);
var inst_56069 = fluree.db.util.async.throw_err(inst_56068);
var inst_56070 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56069);
var inst_56071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56072 = [inst_56069];
var inst_56073 = (new cljs.core.PersistentVector(null,1,(5),inst_56071,inst_56072,null));
var inst_56074 = cljs.core.count(inst_56073);
var inst_56075 = ((9) + inst_56074);
var inst_56076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56077 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56079 = [inst_56069];
var inst_56080 = (new cljs.core.PersistentVector(null,1,(5),inst_56078,inst_56079,null));
var inst_56081 = ["+",inst_56080,inst_56070];
var inst_56082 = cljs.core.PersistentHashMap.fromArrays(inst_56077,inst_56081);
var inst_56083 = [inst_56082,inst_56075];
var inst_56084 = (new cljs.core.PersistentVector(null,2,(5),inst_56076,inst_56083,null));
var inst_56085 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56084);
var _ = (function (){var statearr_56099 = state_56090;
(statearr_56099[(4)] = cljs.core.rest((state_56090[(4)])));

return statearr_56099;
})();
var state_56090__$1 = (function (){var statearr_56100 = state_56090;
(statearr_56100[(7)] = inst_56085);

return statearr_56100;
})();
var statearr_56101_56114 = state_56090__$1;
(statearr_56101_56114[(2)] = inst_56070);

(statearr_56101_56114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56102 = [null,null,null,null,null,null,null,null];
(statearr_56102[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56102[(1)] = (1));

return statearr_56102;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56090){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56090);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56103){var ex__2417__auto__ = e56103;
var statearr_56104_56115 = state_56090;
(statearr_56104_56115[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56090[(4)]))){
var statearr_56105_56116 = state_56090;
(statearr_56105_56116[(1)] = cljs.core.first((state_56090[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56117 = state_56090;
state_56090 = G__56117;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56106 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56106[(6)] = c__2436__auto__);

return statearr_56106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56058){
var G__56059 = cljs.core.first(seq56058);
var seq56058__$1 = cljs.core.next(seq56058);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56059,seq56058__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56167 = arguments.length;
var i__4737__auto___56168 = (0);
while(true){
if((i__4737__auto___56168 < len__4736__auto___56167)){
args__4742__auto__.push((arguments[i__4737__auto___56168]));

var G__56169 = (i__4737__auto___56168 + (1));
i__4737__auto___56168 = G__56169;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56150){
var state_val_56151 = (state_56150[(1)]);
if((state_val_56151 === (1))){
var state_56150__$1 = state_56150;
var statearr_56152_56170 = state_56150__$1;
(statearr_56152_56170[(2)] = null);

(statearr_56152_56170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (2))){
var _ = (function (){var statearr_56153 = state_56150;
(statearr_56153[(4)] = cljs.core.cons((5),(state_56150[(4)])));

return statearr_56153;
})();
var inst_56126 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56150__$1,(6),inst_56126);
} else {
if((state_val_56151 === (3))){
var inst_56148 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56150__$1,inst_56148);
} else {
if((state_val_56151 === (4))){
var inst_56120 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
var statearr_56155_56171 = state_56150__$1;
(statearr_56155_56171[(2)] = inst_56120);

(statearr_56155_56171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (5))){
var _ = (function (){var statearr_56156 = state_56150;
(statearr_56156[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56156;
})();
var state_56150__$1 = state_56150;
var ex56154 = (state_56150__$1[(2)]);
var statearr_56157_56172 = state_56150__$1;
(statearr_56157_56172[(5)] = ex56154);


if((ex56154 instanceof Error)){
var statearr_56158_56173 = state_56150__$1;
(statearr_56158_56173[(1)] = (4));

(statearr_56158_56173[(5)] = null);

} else {
throw ex56154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (6))){
var inst_56128 = (state_56150[(2)]);
var inst_56129 = fluree.db.util.async.throw_err(inst_56128);
var inst_56130 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56129);
var inst_56131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56132 = [inst_56129];
var inst_56133 = (new cljs.core.PersistentVector(null,1,(5),inst_56131,inst_56132,null));
var inst_56134 = cljs.core.count(inst_56133);
var inst_56135 = ((9) + inst_56134);
var inst_56136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56137 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56139 = [inst_56129];
var inst_56140 = (new cljs.core.PersistentVector(null,1,(5),inst_56138,inst_56139,null));
var inst_56141 = ["-",inst_56140,inst_56130];
var inst_56142 = cljs.core.PersistentHashMap.fromArrays(inst_56137,inst_56141);
var inst_56143 = [inst_56142,inst_56135];
var inst_56144 = (new cljs.core.PersistentVector(null,2,(5),inst_56136,inst_56143,null));
var inst_56145 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56144);
var _ = (function (){var statearr_56159 = state_56150;
(statearr_56159[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56159;
})();
var state_56150__$1 = (function (){var statearr_56160 = state_56150;
(statearr_56160[(7)] = inst_56145);

return statearr_56160;
})();
var statearr_56161_56174 = state_56150__$1;
(statearr_56161_56174[(2)] = inst_56130);

(statearr_56161_56174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56162 = [null,null,null,null,null,null,null,null];
(statearr_56162[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56162[(1)] = (1));

return statearr_56162;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56150){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56150);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56163){var ex__2417__auto__ = e56163;
var statearr_56164_56175 = state_56150;
(statearr_56164_56175[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56150[(4)]))){
var statearr_56165_56176 = state_56150;
(statearr_56165_56176[(1)] = cljs.core.first((state_56150[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56177 = state_56150;
state_56150 = G__56177;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56150){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56166 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56166[(6)] = c__2436__auto__);

return statearr_56166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56118){
var G__56119 = cljs.core.first(seq56118);
var seq56118__$1 = cljs.core.next(seq56118);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56119,seq56118__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56227 = arguments.length;
var i__4737__auto___56228 = (0);
while(true){
if((i__4737__auto___56228 < len__4736__auto___56227)){
args__4742__auto__.push((arguments[i__4737__auto___56228]));

var G__56229 = (i__4737__auto___56228 + (1));
i__4737__auto___56228 = G__56229;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56210){
var state_val_56211 = (state_56210[(1)]);
if((state_val_56211 === (1))){
var state_56210__$1 = state_56210;
var statearr_56212_56230 = state_56210__$1;
(statearr_56212_56230[(2)] = null);

(statearr_56212_56230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (2))){
var _ = (function (){var statearr_56213 = state_56210;
(statearr_56213[(4)] = cljs.core.cons((5),(state_56210[(4)])));

return statearr_56213;
})();
var inst_56186 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56210__$1 = state_56210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56210__$1,(6),inst_56186);
} else {
if((state_val_56211 === (3))){
var inst_56208 = (state_56210[(2)]);
var state_56210__$1 = state_56210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56210__$1,inst_56208);
} else {
if((state_val_56211 === (4))){
var inst_56180 = (state_56210[(2)]);
var state_56210__$1 = state_56210;
var statearr_56215_56231 = state_56210__$1;
(statearr_56215_56231[(2)] = inst_56180);

(statearr_56215_56231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (5))){
var _ = (function (){var statearr_56216 = state_56210;
(statearr_56216[(4)] = cljs.core.rest((state_56210[(4)])));

return statearr_56216;
})();
var state_56210__$1 = state_56210;
var ex56214 = (state_56210__$1[(2)]);
var statearr_56217_56232 = state_56210__$1;
(statearr_56217_56232[(5)] = ex56214);


if((ex56214 instanceof Error)){
var statearr_56218_56233 = state_56210__$1;
(statearr_56218_56233[(1)] = (4));

(statearr_56218_56233[(5)] = null);

} else {
throw ex56214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (6))){
var inst_56188 = (state_56210[(2)]);
var inst_56189 = fluree.db.util.async.throw_err(inst_56188);
var inst_56190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56189);
var inst_56191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56192 = [inst_56189];
var inst_56193 = (new cljs.core.PersistentVector(null,1,(5),inst_56191,inst_56192,null));
var inst_56194 = cljs.core.count(inst_56193);
var inst_56195 = ((9) + inst_56194);
var inst_56196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56197 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56199 = [inst_56189];
var inst_56200 = (new cljs.core.PersistentVector(null,1,(5),inst_56198,inst_56199,null));
var inst_56201 = ["*",inst_56200,inst_56190];
var inst_56202 = cljs.core.PersistentHashMap.fromArrays(inst_56197,inst_56201);
var inst_56203 = [inst_56202,inst_56195];
var inst_56204 = (new cljs.core.PersistentVector(null,2,(5),inst_56196,inst_56203,null));
var inst_56205 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56204);
var _ = (function (){var statearr_56219 = state_56210;
(statearr_56219[(4)] = cljs.core.rest((state_56210[(4)])));

return statearr_56219;
})();
var state_56210__$1 = (function (){var statearr_56220 = state_56210;
(statearr_56220[(7)] = inst_56205);

return statearr_56220;
})();
var statearr_56221_56234 = state_56210__$1;
(statearr_56221_56234[(2)] = inst_56190);

(statearr_56221_56234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56222 = [null,null,null,null,null,null,null,null];
(statearr_56222[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56222[(1)] = (1));

return statearr_56222;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56210){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56210);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56223){var ex__2417__auto__ = e56223;
var statearr_56224_56235 = state_56210;
(statearr_56224_56235[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56210[(4)]))){
var statearr_56225_56236 = state_56210;
(statearr_56225_56236[(1)] = cljs.core.first((state_56210[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56237 = state_56210;
state_56210 = G__56237;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56226 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56226[(6)] = c__2436__auto__);

return statearr_56226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56178){
var G__56179 = cljs.core.first(seq56178);
var seq56178__$1 = cljs.core.next(seq56178);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56179,seq56178__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56287 = arguments.length;
var i__4737__auto___56288 = (0);
while(true){
if((i__4737__auto___56288 < len__4736__auto___56287)){
args__4742__auto__.push((arguments[i__4737__auto___56288]));

var G__56289 = (i__4737__auto___56288 + (1));
i__4737__auto___56288 = G__56289;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56270){
var state_val_56271 = (state_56270[(1)]);
if((state_val_56271 === (1))){
var state_56270__$1 = state_56270;
var statearr_56272_56290 = state_56270__$1;
(statearr_56272_56290[(2)] = null);

(statearr_56272_56290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (2))){
var _ = (function (){var statearr_56273 = state_56270;
(statearr_56273[(4)] = cljs.core.cons((5),(state_56270[(4)])));

return statearr_56273;
})();
var inst_56246 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56270__$1 = state_56270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56270__$1,(6),inst_56246);
} else {
if((state_val_56271 === (3))){
var inst_56268 = (state_56270[(2)]);
var state_56270__$1 = state_56270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56270__$1,inst_56268);
} else {
if((state_val_56271 === (4))){
var inst_56240 = (state_56270[(2)]);
var state_56270__$1 = state_56270;
var statearr_56275_56291 = state_56270__$1;
(statearr_56275_56291[(2)] = inst_56240);

(statearr_56275_56291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (5))){
var _ = (function (){var statearr_56276 = state_56270;
(statearr_56276[(4)] = cljs.core.rest((state_56270[(4)])));

return statearr_56276;
})();
var state_56270__$1 = state_56270;
var ex56274 = (state_56270__$1[(2)]);
var statearr_56277_56292 = state_56270__$1;
(statearr_56277_56292[(5)] = ex56274);


if((ex56274 instanceof Error)){
var statearr_56278_56293 = state_56270__$1;
(statearr_56278_56293[(1)] = (4));

(statearr_56278_56293[(5)] = null);

} else {
throw ex56274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (6))){
var inst_56248 = (state_56270[(2)]);
var inst_56249 = fluree.db.util.async.throw_err(inst_56248);
var inst_56250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56249);
var inst_56251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56252 = [inst_56249];
var inst_56253 = (new cljs.core.PersistentVector(null,1,(5),inst_56251,inst_56252,null));
var inst_56254 = cljs.core.count(inst_56253);
var inst_56255 = ((9) + inst_56254);
var inst_56256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56257 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56259 = [inst_56249];
var inst_56260 = (new cljs.core.PersistentVector(null,1,(5),inst_56258,inst_56259,null));
var inst_56261 = ["/",inst_56260,inst_56250];
var inst_56262 = cljs.core.PersistentHashMap.fromArrays(inst_56257,inst_56261);
var inst_56263 = [inst_56262,inst_56255];
var inst_56264 = (new cljs.core.PersistentVector(null,2,(5),inst_56256,inst_56263,null));
var inst_56265 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56264);
var _ = (function (){var statearr_56279 = state_56270;
(statearr_56279[(4)] = cljs.core.rest((state_56270[(4)])));

return statearr_56279;
})();
var state_56270__$1 = (function (){var statearr_56280 = state_56270;
(statearr_56280[(7)] = inst_56265);

return statearr_56280;
})();
var statearr_56281_56294 = state_56270__$1;
(statearr_56281_56294[(2)] = inst_56250);

(statearr_56281_56294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56282 = [null,null,null,null,null,null,null,null];
(statearr_56282[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56282[(1)] = (1));

return statearr_56282;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56270){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56270);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56283){var ex__2417__auto__ = e56283;
var statearr_56284_56295 = state_56270;
(statearr_56284_56295[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56270[(4)]))){
var statearr_56285_56296 = state_56270;
(statearr_56285_56296[(1)] = cljs.core.first((state_56270[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56297 = state_56270;
state_56270 = G__56297;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56270){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56286 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56286[(6)] = c__2436__auto__);

return statearr_56286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56238){
var G__56239 = cljs.core.first(seq56238);
var seq56238__$1 = cljs.core.next(seq56238);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56239,seq56238__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56335){
var state_val_56336 = (state_56335[(1)]);
if((state_val_56336 === (7))){
var state_56335__$1 = state_56335;
var statearr_56337_56361 = state_56335__$1;
(statearr_56337_56361[(2)] = n);

(statearr_56337_56361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (1))){
var state_56335__$1 = state_56335;
var statearr_56338_56362 = state_56335__$1;
(statearr_56338_56362[(2)] = null);

(statearr_56338_56362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (4))){
var inst_56298 = (state_56335[(2)]);
var state_56335__$1 = state_56335;
var statearr_56339_56363 = state_56335__$1;
(statearr_56339_56363[(2)] = inst_56298);

(statearr_56339_56363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (13))){
var inst_56315 = (state_56335[(2)]);
var inst_56316 = fluree.db.util.async.throw_err(inst_56315);
var state_56335__$1 = state_56335;
var statearr_56340_56364 = state_56335__$1;
(statearr_56340_56364[(2)] = inst_56316);

(statearr_56340_56364[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (6))){
var state_56335__$1 = state_56335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56335__$1,(9),n);
} else {
if((state_val_56336 === (3))){
var inst_56333 = (state_56335[(2)]);
var state_56335__$1 = state_56335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56335__$1,inst_56333);
} else {
if((state_val_56336 === (12))){
var inst_56311 = (state_56335[(7)]);
var inst_56319 = (state_56335[(2)]);
var inst_56320 = fluree.db.dbfunctions.internal.quot(inst_56311,inst_56319);
var inst_56321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56322 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56324 = [inst_56311,inst_56319];
var inst_56325 = (new cljs.core.PersistentVector(null,2,(5),inst_56323,inst_56324,null));
var inst_56326 = ["quot",inst_56325,inst_56320];
var inst_56327 = cljs.core.PersistentHashMap.fromArrays(inst_56322,inst_56326);
var inst_56328 = [inst_56327,(2)];
var inst_56329 = (new cljs.core.PersistentVector(null,2,(5),inst_56321,inst_56328,null));
var inst_56330 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56329);
var _ = (function (){var statearr_56341 = state_56335;
(statearr_56341[(4)] = cljs.core.rest((state_56335[(4)])));

return statearr_56341;
})();
var state_56335__$1 = (function (){var statearr_56342 = state_56335;
(statearr_56342[(8)] = inst_56330);

return statearr_56342;
})();
var statearr_56343_56365 = state_56335__$1;
(statearr_56343_56365[(2)] = inst_56320);

(statearr_56343_56365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (2))){
var _ = (function (){var statearr_56344 = state_56335;
(statearr_56344[(4)] = cljs.core.cons((5),(state_56335[(4)])));

return statearr_56344;
})();
var inst_56304 = fluree.db.util.async.channel_QMARK_(n);
var state_56335__$1 = state_56335;
if(inst_56304){
var statearr_56345_56366 = state_56335__$1;
(statearr_56345_56366[(1)] = (6));

} else {
var statearr_56346_56367 = state_56335__$1;
(statearr_56346_56367[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (11))){
var state_56335__$1 = state_56335;
var statearr_56348_56368 = state_56335__$1;
(statearr_56348_56368[(2)] = d);

(statearr_56348_56368[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (9))){
var inst_56307 = (state_56335[(2)]);
var inst_56308 = fluree.db.util.async.throw_err(inst_56307);
var state_56335__$1 = state_56335;
var statearr_56349_56369 = state_56335__$1;
(statearr_56349_56369[(2)] = inst_56308);

(statearr_56349_56369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (5))){
var _ = (function (){var statearr_56350 = state_56335;
(statearr_56350[(4)] = cljs.core.rest((state_56335[(4)])));

return statearr_56350;
})();
var state_56335__$1 = state_56335;
var ex56347 = (state_56335__$1[(2)]);
var statearr_56351_56370 = state_56335__$1;
(statearr_56351_56370[(5)] = ex56347);


if((ex56347 instanceof Error)){
var statearr_56352_56371 = state_56335__$1;
(statearr_56352_56371[(1)] = (4));

(statearr_56352_56371[(5)] = null);

} else {
throw ex56347;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56336 === (10))){
var state_56335__$1 = state_56335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56335__$1,(13),d);
} else {
if((state_val_56336 === (8))){
var inst_56311 = (state_56335[(2)]);
var inst_56312 = fluree.db.util.async.channel_QMARK_(d);
var state_56335__$1 = (function (){var statearr_56353 = state_56335;
(statearr_56353[(7)] = inst_56311);

return statearr_56353;
})();
if(inst_56312){
var statearr_56354_56372 = state_56335__$1;
(statearr_56354_56372[(1)] = (10));

} else {
var statearr_56355_56373 = state_56335__$1;
(statearr_56355_56373[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0 = (function (){
var statearr_56356 = [null,null,null,null,null,null,null,null,null];
(statearr_56356[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__);

(statearr_56356[(1)] = (1));

return statearr_56356;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1 = (function (state_56335){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56335);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56357){var ex__2417__auto__ = e56357;
var statearr_56358_56374 = state_56335;
(statearr_56358_56374[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56335[(4)]))){
var statearr_56359_56375 = state_56335;
(statearr_56359_56375[(1)] = cljs.core.first((state_56335[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56376 = state_56335;
state_56335 = G__56376;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__ = function(state_56335){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1.call(this,state_56335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56360 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56360[(6)] = c__2436__auto__);

return statearr_56360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56414){
var state_val_56415 = (state_56414[(1)]);
if((state_val_56415 === (7))){
var state_56414__$1 = state_56414;
var statearr_56416_56440 = state_56414__$1;
(statearr_56416_56440[(2)] = n);

(statearr_56416_56440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (1))){
var state_56414__$1 = state_56414;
var statearr_56417_56441 = state_56414__$1;
(statearr_56417_56441[(2)] = null);

(statearr_56417_56441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (4))){
var inst_56377 = (state_56414[(2)]);
var state_56414__$1 = state_56414;
var statearr_56418_56442 = state_56414__$1;
(statearr_56418_56442[(2)] = inst_56377);

(statearr_56418_56442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (13))){
var inst_56394 = (state_56414[(2)]);
var inst_56395 = fluree.db.util.async.throw_err(inst_56394);
var state_56414__$1 = state_56414;
var statearr_56419_56443 = state_56414__$1;
(statearr_56419_56443[(2)] = inst_56395);

(statearr_56419_56443[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (6))){
var state_56414__$1 = state_56414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56414__$1,(9),n);
} else {
if((state_val_56415 === (3))){
var inst_56412 = (state_56414[(2)]);
var state_56414__$1 = state_56414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56414__$1,inst_56412);
} else {
if((state_val_56415 === (12))){
var inst_56390 = (state_56414[(7)]);
var inst_56398 = (state_56414[(2)]);
var inst_56399 = fluree.db.dbfunctions.internal.mod(inst_56390,inst_56398);
var inst_56400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56401 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56403 = [inst_56390,inst_56398];
var inst_56404 = (new cljs.core.PersistentVector(null,2,(5),inst_56402,inst_56403,null));
var inst_56405 = ["mod",inst_56404,inst_56399];
var inst_56406 = cljs.core.PersistentHashMap.fromArrays(inst_56401,inst_56405);
var inst_56407 = [inst_56406,(2)];
var inst_56408 = (new cljs.core.PersistentVector(null,2,(5),inst_56400,inst_56407,null));
var inst_56409 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56408);
var _ = (function (){var statearr_56420 = state_56414;
(statearr_56420[(4)] = cljs.core.rest((state_56414[(4)])));

return statearr_56420;
})();
var state_56414__$1 = (function (){var statearr_56421 = state_56414;
(statearr_56421[(8)] = inst_56409);

return statearr_56421;
})();
var statearr_56422_56444 = state_56414__$1;
(statearr_56422_56444[(2)] = inst_56399);

(statearr_56422_56444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (2))){
var _ = (function (){var statearr_56423 = state_56414;
(statearr_56423[(4)] = cljs.core.cons((5),(state_56414[(4)])));

return statearr_56423;
})();
var inst_56383 = fluree.db.util.async.channel_QMARK_(n);
var state_56414__$1 = state_56414;
if(inst_56383){
var statearr_56424_56445 = state_56414__$1;
(statearr_56424_56445[(1)] = (6));

} else {
var statearr_56425_56446 = state_56414__$1;
(statearr_56425_56446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (11))){
var state_56414__$1 = state_56414;
var statearr_56427_56447 = state_56414__$1;
(statearr_56427_56447[(2)] = d);

(statearr_56427_56447[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (9))){
var inst_56386 = (state_56414[(2)]);
var inst_56387 = fluree.db.util.async.throw_err(inst_56386);
var state_56414__$1 = state_56414;
var statearr_56428_56448 = state_56414__$1;
(statearr_56428_56448[(2)] = inst_56387);

(statearr_56428_56448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (5))){
var _ = (function (){var statearr_56429 = state_56414;
(statearr_56429[(4)] = cljs.core.rest((state_56414[(4)])));

return statearr_56429;
})();
var state_56414__$1 = state_56414;
var ex56426 = (state_56414__$1[(2)]);
var statearr_56430_56449 = state_56414__$1;
(statearr_56430_56449[(5)] = ex56426);


if((ex56426 instanceof Error)){
var statearr_56431_56450 = state_56414__$1;
(statearr_56431_56450[(1)] = (4));

(statearr_56431_56450[(5)] = null);

} else {
throw ex56426;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56415 === (10))){
var state_56414__$1 = state_56414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56414__$1,(13),d);
} else {
if((state_val_56415 === (8))){
var inst_56390 = (state_56414[(2)]);
var inst_56391 = fluree.db.util.async.channel_QMARK_(d);
var state_56414__$1 = (function (){var statearr_56432 = state_56414;
(statearr_56432[(7)] = inst_56390);

return statearr_56432;
})();
if(inst_56391){
var statearr_56433_56451 = state_56414__$1;
(statearr_56433_56451[(1)] = (10));

} else {
var statearr_56434_56452 = state_56414__$1;
(statearr_56434_56452[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0 = (function (){
var statearr_56435 = [null,null,null,null,null,null,null,null,null];
(statearr_56435[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__);

(statearr_56435[(1)] = (1));

return statearr_56435;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1 = (function (state_56414){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56414);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56436){var ex__2417__auto__ = e56436;
var statearr_56437_56453 = state_56414;
(statearr_56437_56453[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56414[(4)]))){
var statearr_56438_56454 = state_56414;
(statearr_56438_56454[(1)] = cljs.core.first((state_56414[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56455 = state_56414;
state_56414 = G__56455;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__ = function(state_56414){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1.call(this,state_56414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56439 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56439[(6)] = c__2436__auto__);

return statearr_56439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56493){
var state_val_56494 = (state_56493[(1)]);
if((state_val_56494 === (7))){
var state_56493__$1 = state_56493;
var statearr_56495_56519 = state_56493__$1;
(statearr_56495_56519[(2)] = n);

(statearr_56495_56519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (1))){
var state_56493__$1 = state_56493;
var statearr_56496_56520 = state_56493__$1;
(statearr_56496_56520[(2)] = null);

(statearr_56496_56520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (4))){
var inst_56456 = (state_56493[(2)]);
var state_56493__$1 = state_56493;
var statearr_56497_56521 = state_56493__$1;
(statearr_56497_56521[(2)] = inst_56456);

(statearr_56497_56521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (13))){
var inst_56473 = (state_56493[(2)]);
var inst_56474 = fluree.db.util.async.throw_err(inst_56473);
var state_56493__$1 = state_56493;
var statearr_56498_56522 = state_56493__$1;
(statearr_56498_56522[(2)] = inst_56474);

(statearr_56498_56522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (6))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56493__$1,(9),n);
} else {
if((state_val_56494 === (3))){
var inst_56491 = (state_56493[(2)]);
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56493__$1,inst_56491);
} else {
if((state_val_56494 === (12))){
var inst_56469 = (state_56493[(7)]);
var inst_56477 = (state_56493[(2)]);
var inst_56478 = fluree.db.dbfunctions.internal.rem(inst_56469,inst_56477);
var inst_56479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56480 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56482 = [inst_56469,inst_56477];
var inst_56483 = (new cljs.core.PersistentVector(null,2,(5),inst_56481,inst_56482,null));
var inst_56484 = ["rem",inst_56483,inst_56478];
var inst_56485 = cljs.core.PersistentHashMap.fromArrays(inst_56480,inst_56484);
var inst_56486 = [inst_56485,(2)];
var inst_56487 = (new cljs.core.PersistentVector(null,2,(5),inst_56479,inst_56486,null));
var inst_56488 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56487);
var _ = (function (){var statearr_56499 = state_56493;
(statearr_56499[(4)] = cljs.core.rest((state_56493[(4)])));

return statearr_56499;
})();
var state_56493__$1 = (function (){var statearr_56500 = state_56493;
(statearr_56500[(8)] = inst_56488);

return statearr_56500;
})();
var statearr_56501_56523 = state_56493__$1;
(statearr_56501_56523[(2)] = inst_56478);

(statearr_56501_56523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (2))){
var _ = (function (){var statearr_56502 = state_56493;
(statearr_56502[(4)] = cljs.core.cons((5),(state_56493[(4)])));

return statearr_56502;
})();
var inst_56462 = fluree.db.util.async.channel_QMARK_(n);
var state_56493__$1 = state_56493;
if(inst_56462){
var statearr_56503_56524 = state_56493__$1;
(statearr_56503_56524[(1)] = (6));

} else {
var statearr_56504_56525 = state_56493__$1;
(statearr_56504_56525[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (11))){
var state_56493__$1 = state_56493;
var statearr_56506_56526 = state_56493__$1;
(statearr_56506_56526[(2)] = d);

(statearr_56506_56526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (9))){
var inst_56465 = (state_56493[(2)]);
var inst_56466 = fluree.db.util.async.throw_err(inst_56465);
var state_56493__$1 = state_56493;
var statearr_56507_56527 = state_56493__$1;
(statearr_56507_56527[(2)] = inst_56466);

(statearr_56507_56527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (5))){
var _ = (function (){var statearr_56508 = state_56493;
(statearr_56508[(4)] = cljs.core.rest((state_56493[(4)])));

return statearr_56508;
})();
var state_56493__$1 = state_56493;
var ex56505 = (state_56493__$1[(2)]);
var statearr_56509_56528 = state_56493__$1;
(statearr_56509_56528[(5)] = ex56505);


if((ex56505 instanceof Error)){
var statearr_56510_56529 = state_56493__$1;
(statearr_56510_56529[(1)] = (4));

(statearr_56510_56529[(5)] = null);

} else {
throw ex56505;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (10))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56493__$1,(13),d);
} else {
if((state_val_56494 === (8))){
var inst_56469 = (state_56493[(2)]);
var inst_56470 = fluree.db.util.async.channel_QMARK_(d);
var state_56493__$1 = (function (){var statearr_56511 = state_56493;
(statearr_56511[(7)] = inst_56469);

return statearr_56511;
})();
if(inst_56470){
var statearr_56512_56530 = state_56493__$1;
(statearr_56512_56530[(1)] = (10));

} else {
var statearr_56513_56531 = state_56493__$1;
(statearr_56513_56531[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0 = (function (){
var statearr_56514 = [null,null,null,null,null,null,null,null,null];
(statearr_56514[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__);

(statearr_56514[(1)] = (1));

return statearr_56514;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1 = (function (state_56493){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56493);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56515){var ex__2417__auto__ = e56515;
var statearr_56516_56532 = state_56493;
(statearr_56516_56532[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56493[(4)]))){
var statearr_56517_56533 = state_56493;
(statearr_56517_56533[(1)] = cljs.core.first((state_56493[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56534 = state_56493;
state_56493 = G__56534;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__ = function(state_56493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1.call(this,state_56493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56518 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56518[(6)] = c__2436__auto__);

return statearr_56518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56561){
var state_val_56562 = (state_56561[(1)]);
if((state_val_56562 === (7))){
var state_56561__$1 = state_56561;
var statearr_56563_56582 = state_56561__$1;
(statearr_56563_56582[(2)] = x);

(statearr_56563_56582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (1))){
var state_56561__$1 = state_56561;
var statearr_56564_56583 = state_56561__$1;
(statearr_56564_56583[(2)] = null);

(statearr_56564_56583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (4))){
var inst_56535 = (state_56561[(2)]);
var state_56561__$1 = state_56561;
var statearr_56565_56584 = state_56561__$1;
(statearr_56565_56584[(2)] = inst_56535);

(statearr_56565_56584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (6))){
var state_56561__$1 = state_56561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56561__$1,(9),x);
} else {
if((state_val_56562 === (3))){
var inst_56559 = (state_56561[(2)]);
var state_56561__$1 = state_56561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56561__$1,inst_56559);
} else {
if((state_val_56562 === (2))){
var _ = (function (){var statearr_56567 = state_56561;
(statearr_56567[(4)] = cljs.core.cons((5),(state_56561[(4)])));

return statearr_56567;
})();
var inst_56541 = fluree.db.util.async.channel_QMARK_(x);
var state_56561__$1 = state_56561;
if(inst_56541){
var statearr_56568_56585 = state_56561__$1;
(statearr_56568_56585[(1)] = (6));

} else {
var statearr_56569_56586 = state_56561__$1;
(statearr_56569_56586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (9))){
var inst_56544 = (state_56561[(2)]);
var inst_56545 = fluree.db.util.async.throw_err(inst_56544);
var state_56561__$1 = state_56561;
var statearr_56570_56587 = state_56561__$1;
(statearr_56570_56587[(2)] = inst_56545);

(statearr_56570_56587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (5))){
var _ = (function (){var statearr_56571 = state_56561;
(statearr_56571[(4)] = cljs.core.rest((state_56561[(4)])));

return statearr_56571;
})();
var state_56561__$1 = state_56561;
var ex56566 = (state_56561__$1[(2)]);
var statearr_56572_56588 = state_56561__$1;
(statearr_56572_56588[(5)] = ex56566);


if((ex56566 instanceof Error)){
var statearr_56573_56589 = state_56561__$1;
(statearr_56573_56589[(1)] = (4));

(statearr_56573_56589[(5)] = null);

} else {
throw ex56566;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56562 === (8))){
var inst_56548 = (state_56561[(2)]);
var inst_56549 = fluree.db.dbfunctions.internal.boolean$(inst_56548);
var inst_56550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56551 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56552 = ["boolean",inst_56548,inst_56549];
var inst_56553 = cljs.core.PersistentHashMap.fromArrays(inst_56551,inst_56552);
var inst_56554 = [inst_56553,(10)];
var inst_56555 = (new cljs.core.PersistentVector(null,2,(5),inst_56550,inst_56554,null));
var inst_56556 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56555);
var _ = (function (){var statearr_56574 = state_56561;
(statearr_56574[(4)] = cljs.core.rest((state_56561[(4)])));

return statearr_56574;
})();
var state_56561__$1 = (function (){var statearr_56575 = state_56561;
(statearr_56575[(7)] = inst_56556);

return statearr_56575;
})();
var statearr_56576_56590 = state_56561__$1;
(statearr_56576_56590[(2)] = inst_56549);

(statearr_56576_56590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0 = (function (){
var statearr_56577 = [null,null,null,null,null,null,null,null];
(statearr_56577[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__);

(statearr_56577[(1)] = (1));

return statearr_56577;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1 = (function (state_56561){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56561);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56578){var ex__2417__auto__ = e56578;
var statearr_56579_56591 = state_56561;
(statearr_56579_56591[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56561[(4)]))){
var statearr_56580_56592 = state_56561;
(statearr_56580_56592[(1)] = cljs.core.first((state_56561[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56593 = state_56561;
state_56561 = G__56593;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__ = function(state_56561){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1.call(this,state_56561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56581 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56581[(6)] = c__2436__auto__);

return statearr_56581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56631){
var state_val_56632 = (state_56631[(1)]);
if((state_val_56632 === (7))){
var state_56631__$1 = state_56631;
var statearr_56633_56657 = state_56631__$1;
(statearr_56633_56657[(2)] = pattern);

(statearr_56633_56657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (1))){
var state_56631__$1 = state_56631;
var statearr_56634_56658 = state_56631__$1;
(statearr_56634_56658[(2)] = null);

(statearr_56634_56658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (4))){
var inst_56594 = (state_56631[(2)]);
var state_56631__$1 = state_56631;
var statearr_56635_56659 = state_56631__$1;
(statearr_56635_56659[(2)] = inst_56594);

(statearr_56635_56659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (13))){
var inst_56611 = (state_56631[(2)]);
var inst_56612 = fluree.db.util.async.throw_err(inst_56611);
var state_56631__$1 = state_56631;
var statearr_56636_56660 = state_56631__$1;
(statearr_56636_56660[(2)] = inst_56612);

(statearr_56636_56660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (6))){
var state_56631__$1 = state_56631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56631__$1,(9),pattern);
} else {
if((state_val_56632 === (3))){
var inst_56629 = (state_56631[(2)]);
var state_56631__$1 = state_56631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56631__$1,inst_56629);
} else {
if((state_val_56632 === (12))){
var inst_56607 = (state_56631[(7)]);
var inst_56615 = (state_56631[(2)]);
var inst_56616 = fluree.db.dbfunctions.internal.re_find(inst_56607,inst_56615);
var inst_56617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56618 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56620 = [inst_56607,inst_56615];
var inst_56621 = (new cljs.core.PersistentVector(null,2,(5),inst_56619,inst_56620,null));
var inst_56622 = ["re-find",inst_56621,inst_56616];
var inst_56623 = cljs.core.PersistentHashMap.fromArrays(inst_56618,inst_56622);
var inst_56624 = [inst_56623,(10)];
var inst_56625 = (new cljs.core.PersistentVector(null,2,(5),inst_56617,inst_56624,null));
var inst_56626 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56625);
var _ = (function (){var statearr_56637 = state_56631;
(statearr_56637[(4)] = cljs.core.rest((state_56631[(4)])));

return statearr_56637;
})();
var state_56631__$1 = (function (){var statearr_56638 = state_56631;
(statearr_56638[(8)] = inst_56626);

return statearr_56638;
})();
var statearr_56639_56661 = state_56631__$1;
(statearr_56639_56661[(2)] = inst_56616);

(statearr_56639_56661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (2))){
var _ = (function (){var statearr_56640 = state_56631;
(statearr_56640[(4)] = cljs.core.cons((5),(state_56631[(4)])));

return statearr_56640;
})();
var inst_56600 = fluree.db.util.async.channel_QMARK_(pattern);
var state_56631__$1 = state_56631;
if(inst_56600){
var statearr_56641_56662 = state_56631__$1;
(statearr_56641_56662[(1)] = (6));

} else {
var statearr_56642_56663 = state_56631__$1;
(statearr_56642_56663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (11))){
var state_56631__$1 = state_56631;
var statearr_56644_56664 = state_56631__$1;
(statearr_56644_56664[(2)] = string);

(statearr_56644_56664[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (9))){
var inst_56603 = (state_56631[(2)]);
var inst_56604 = fluree.db.util.async.throw_err(inst_56603);
var state_56631__$1 = state_56631;
var statearr_56645_56665 = state_56631__$1;
(statearr_56645_56665[(2)] = inst_56604);

(statearr_56645_56665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (5))){
var _ = (function (){var statearr_56646 = state_56631;
(statearr_56646[(4)] = cljs.core.rest((state_56631[(4)])));

return statearr_56646;
})();
var state_56631__$1 = state_56631;
var ex56643 = (state_56631__$1[(2)]);
var statearr_56647_56666 = state_56631__$1;
(statearr_56647_56666[(5)] = ex56643);


if((ex56643 instanceof Error)){
var statearr_56648_56667 = state_56631__$1;
(statearr_56648_56667[(1)] = (4));

(statearr_56648_56667[(5)] = null);

} else {
throw ex56643;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56632 === (10))){
var state_56631__$1 = state_56631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56631__$1,(13),string);
} else {
if((state_val_56632 === (8))){
var inst_56607 = (state_56631[(2)]);
var inst_56608 = fluree.db.util.async.channel_QMARK_(string);
var state_56631__$1 = (function (){var statearr_56649 = state_56631;
(statearr_56649[(7)] = inst_56607);

return statearr_56649;
})();
if(inst_56608){
var statearr_56650_56668 = state_56631__$1;
(statearr_56650_56668[(1)] = (10));

} else {
var statearr_56651_56669 = state_56631__$1;
(statearr_56651_56669[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0 = (function (){
var statearr_56652 = [null,null,null,null,null,null,null,null,null];
(statearr_56652[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__);

(statearr_56652[(1)] = (1));

return statearr_56652;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1 = (function (state_56631){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56631);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56653){var ex__2417__auto__ = e56653;
var statearr_56654_56670 = state_56631;
(statearr_56654_56670[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56631[(4)]))){
var statearr_56655_56671 = state_56631;
(statearr_56655_56671[(1)] = cljs.core.first((state_56631[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56672 = state_56631;
state_56631 = G__56672;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__ = function(state_56631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1.call(this,state_56631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56656 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56656[(6)] = c__2436__auto__);

return statearr_56656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56699){
var state_val_56700 = (state_56699[(1)]);
if((state_val_56700 === (7))){
var state_56699__$1 = state_56699;
var statearr_56701_56720 = state_56699__$1;
(statearr_56701_56720[(2)] = email);

(statearr_56701_56720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (1))){
var state_56699__$1 = state_56699;
var statearr_56702_56721 = state_56699__$1;
(statearr_56702_56721[(2)] = null);

(statearr_56702_56721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (4))){
var inst_56673 = (state_56699[(2)]);
var state_56699__$1 = state_56699;
var statearr_56703_56722 = state_56699__$1;
(statearr_56703_56722[(2)] = inst_56673);

(statearr_56703_56722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (6))){
var state_56699__$1 = state_56699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56699__$1,(9),email);
} else {
if((state_val_56700 === (3))){
var inst_56697 = (state_56699[(2)]);
var state_56699__$1 = state_56699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56699__$1,inst_56697);
} else {
if((state_val_56700 === (2))){
var _ = (function (){var statearr_56705 = state_56699;
(statearr_56705[(4)] = cljs.core.cons((5),(state_56699[(4)])));

return statearr_56705;
})();
var inst_56679 = fluree.db.util.async.channel_QMARK_(email);
var state_56699__$1 = state_56699;
if(inst_56679){
var statearr_56706_56723 = state_56699__$1;
(statearr_56706_56723[(1)] = (6));

} else {
var statearr_56707_56724 = state_56699__$1;
(statearr_56707_56724[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (9))){
var inst_56682 = (state_56699[(2)]);
var inst_56683 = fluree.db.util.async.throw_err(inst_56682);
var state_56699__$1 = state_56699;
var statearr_56708_56725 = state_56699__$1;
(statearr_56708_56725[(2)] = inst_56683);

(statearr_56708_56725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (5))){
var _ = (function (){var statearr_56709 = state_56699;
(statearr_56709[(4)] = cljs.core.rest((state_56699[(4)])));

return statearr_56709;
})();
var state_56699__$1 = state_56699;
var ex56704 = (state_56699__$1[(2)]);
var statearr_56710_56726 = state_56699__$1;
(statearr_56710_56726[(5)] = ex56704);


if((ex56704 instanceof Error)){
var statearr_56711_56727 = state_56699__$1;
(statearr_56711_56727[(1)] = (4));

(statearr_56711_56727[(5)] = null);

} else {
throw ex56704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (8))){
var inst_56686 = (state_56699[(2)]);
var inst_56687 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_56686);
var inst_56688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56689 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56690 = ["re-find",inst_56686,inst_56687];
var inst_56691 = cljs.core.PersistentHashMap.fromArrays(inst_56689,inst_56690);
var inst_56692 = [inst_56691,(10)];
var inst_56693 = (new cljs.core.PersistentVector(null,2,(5),inst_56688,inst_56692,null));
var inst_56694 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56693);
var _ = (function (){var statearr_56712 = state_56699;
(statearr_56712[(4)] = cljs.core.rest((state_56699[(4)])));

return statearr_56712;
})();
var state_56699__$1 = (function (){var statearr_56713 = state_56699;
(statearr_56713[(7)] = inst_56694);

return statearr_56713;
})();
var statearr_56714_56728 = state_56699__$1;
(statearr_56714_56728[(2)] = inst_56687);

(statearr_56714_56728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_56715 = [null,null,null,null,null,null,null,null];
(statearr_56715[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__);

(statearr_56715[(1)] = (1));

return statearr_56715;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1 = (function (state_56699){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56699);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56716){var ex__2417__auto__ = e56716;
var statearr_56717_56729 = state_56699;
(statearr_56717_56729[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56699[(4)]))){
var statearr_56718_56730 = state_56699;
(statearr_56718_56730[(1)] = cljs.core.first((state_56699[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56731 = state_56699;
state_56699 = G__56731;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__ = function(state_56699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1.call(this,state_56699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56719 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56719[(6)] = c__2436__auto__);

return statearr_56719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56778){
var state_val_56779 = (state_56778[(1)]);
if((state_val_56779 === (7))){
var inst_56748 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56778__$1 = state_56778;
if(cljs.core.truth_(inst_56748)){
var statearr_56780_56807 = state_56778__$1;
(statearr_56780_56807[(1)] = (9));

} else {
var statearr_56781_56808 = state_56778__$1;
(statearr_56781_56808[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (1))){
var state_56778__$1 = state_56778;
var statearr_56782_56809 = state_56778__$1;
(statearr_56782_56809[(2)] = null);

(statearr_56782_56809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (4))){
var inst_56732 = (state_56778[(2)]);
var state_56778__$1 = state_56778;
var statearr_56783_56810 = state_56778__$1;
(statearr_56783_56810[(2)] = inst_56732);

(statearr_56783_56810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (15))){
var inst_56759 = (state_56778[(2)]);
var state_56778__$1 = state_56778;
var statearr_56784_56811 = state_56778__$1;
(statearr_56784_56811[(2)] = inst_56759);

(statearr_56784_56811[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (13))){
var inst_56756 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56778__$1 = state_56778;
var statearr_56785_56812 = state_56778__$1;
(statearr_56785_56812[(2)] = inst_56756);

(statearr_56785_56812[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (6))){
var inst_56743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56744 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56745 = [inst_56744,(0)];
var inst_56746 = (new cljs.core.PersistentVector(null,2,(5),inst_56743,inst_56745,null));
var state_56778__$1 = state_56778;
var statearr_56786_56813 = state_56778__$1;
(statearr_56786_56813[(2)] = inst_56746);

(statearr_56786_56813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (3))){
var inst_56776 = (state_56778[(2)]);
var state_56778__$1 = state_56778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56778__$1,inst_56776);
} else {
if((state_val_56779 === (12))){
var inst_56752 = (state_56778[(2)]);
var inst_56753 = fluree.db.util.async.throw_err(inst_56752);
var state_56778__$1 = state_56778;
var statearr_56787_56814 = state_56778__$1;
(statearr_56787_56814[(2)] = inst_56753);

(statearr_56787_56814[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (2))){
var _ = (function (){var statearr_56788 = state_56778;
(statearr_56788[(4)] = cljs.core.cons((5),(state_56778[(4)])));

return statearr_56788;
})();
var inst_56741 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56778__$1 = state_56778;
if(cljs.core.truth_(inst_56741)){
var statearr_56789_56815 = state_56778__$1;
(statearr_56789_56815[(1)] = (6));

} else {
var statearr_56790_56816 = state_56778__$1;
(statearr_56790_56816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (11))){
var inst_56761 = (state_56778[(2)]);
var state_56778__$1 = state_56778;
var statearr_56792_56817 = state_56778__$1;
(statearr_56792_56817[(2)] = inst_56761);

(statearr_56792_56817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (9))){
var inst_56750 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_56778__$1 = state_56778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56778__$1,(12),inst_56750);
} else {
if((state_val_56779 === (5))){
var _ = (function (){var statearr_56793 = state_56778;
(statearr_56793[(4)] = cljs.core.rest((state_56778[(4)])));

return statearr_56793;
})();
var state_56778__$1 = state_56778;
var ex56791 = (state_56778__$1[(2)]);
var statearr_56794_56818 = state_56778__$1;
(statearr_56794_56818[(5)] = ex56791);


if((ex56791 instanceof Error)){
var statearr_56795_56819 = state_56778__$1;
(statearr_56795_56819[(1)] = (4));

(statearr_56795_56819[(5)] = null);

} else {
throw ex56791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (14))){
var state_56778__$1 = state_56778;
var statearr_56796_56820 = state_56778__$1;
(statearr_56796_56820[(2)] = null);

(statearr_56796_56820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (10))){
var state_56778__$1 = state_56778;
var statearr_56797_56821 = state_56778__$1;
(statearr_56797_56821[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56779 === (8))){
var inst_56763 = (state_56778[(2)]);
var inst_56764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56763,(0),null);
var inst_56765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56763,(1),null);
var inst_56766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56767 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56768 = ["?user_id","?ctx",inst_56764];
var inst_56769 = cljs.core.PersistentHashMap.fromArrays(inst_56767,inst_56768);
var inst_56770 = ((10) + inst_56765);
var inst_56771 = [inst_56769,inst_56770];
var inst_56772 = (new cljs.core.PersistentVector(null,2,(5),inst_56766,inst_56771,null));
var inst_56773 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56772);
var _ = (function (){var statearr_56799 = state_56778;
(statearr_56799[(4)] = cljs.core.rest((state_56778[(4)])));

return statearr_56799;
})();
var state_56778__$1 = (function (){var statearr_56800 = state_56778;
(statearr_56800[(7)] = inst_56773);

return statearr_56800;
})();
var statearr_56801_56822 = state_56778__$1;
(statearr_56801_56822[(2)] = inst_56764);

(statearr_56801_56822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0 = (function (){
var statearr_56802 = [null,null,null,null,null,null,null,null];
(statearr_56802[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__);

(statearr_56802[(1)] = (1));

return statearr_56802;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1 = (function (state_56778){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56778);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56803){var ex__2417__auto__ = e56803;
var statearr_56804_56823 = state_56778;
(statearr_56804_56823[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56778[(4)]))){
var statearr_56805_56824 = state_56778;
(statearr_56805_56824[(1)] = cljs.core.first((state_56778[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56825 = state_56778;
state_56778 = G__56825;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__ = function(state_56778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1.call(this,state_56778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56806 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56806[(6)] = c__2436__auto__);

return statearr_56806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56853){
var state_val_56854 = (state_56853[(1)]);
if((state_val_56854 === (7))){
var inst_56846 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56853__$1 = state_56853;
var statearr_56855_56874 = state_56853__$1;
(statearr_56855_56874[(2)] = inst_56846);

(statearr_56855_56874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (1))){
var state_56853__$1 = state_56853;
var statearr_56856_56875 = state_56853__$1;
(statearr_56856_56875[(2)] = null);

(statearr_56856_56875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (4))){
var inst_56826 = (state_56853[(2)]);
var state_56853__$1 = state_56853;
var statearr_56857_56876 = state_56853__$1;
(statearr_56857_56876[(2)] = inst_56826);

(statearr_56857_56876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (6))){
var inst_56834 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56853__$1 = state_56853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56853__$1,(9),inst_56834);
} else {
if((state_val_56854 === (3))){
var inst_56851 = (state_56853[(2)]);
var state_56853__$1 = state_56853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56853__$1,inst_56851);
} else {
if((state_val_56854 === (2))){
var _ = (function (){var statearr_56859 = state_56853;
(statearr_56859[(4)] = cljs.core.cons((5),(state_56853[(4)])));

return statearr_56859;
})();
var inst_56832 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56853__$1 = state_56853;
if(cljs.core.truth_(inst_56832)){
var statearr_56860_56877 = state_56853__$1;
(statearr_56860_56877[(1)] = (6));

} else {
var statearr_56861_56878 = state_56853__$1;
(statearr_56861_56878[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (9))){
var inst_56836 = (state_56853[(2)]);
var inst_56837 = fluree.db.util.async.throw_err(inst_56836);
var inst_56838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56839 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56840 = ["?auth_id","?ctx",inst_56837];
var inst_56841 = cljs.core.PersistentHashMap.fromArrays(inst_56839,inst_56840);
var inst_56842 = [inst_56841,(10)];
var inst_56843 = (new cljs.core.PersistentVector(null,2,(5),inst_56838,inst_56842,null));
var inst_56844 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56843);
var state_56853__$1 = (function (){var statearr_56862 = state_56853;
(statearr_56862[(7)] = inst_56844);

return statearr_56862;
})();
var statearr_56863_56879 = state_56853__$1;
(statearr_56863_56879[(2)] = inst_56837);

(statearr_56863_56879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (5))){
var _ = (function (){var statearr_56864 = state_56853;
(statearr_56864[(4)] = cljs.core.rest((state_56853[(4)])));

return statearr_56864;
})();
var state_56853__$1 = state_56853;
var ex56858 = (state_56853__$1[(2)]);
var statearr_56865_56880 = state_56853__$1;
(statearr_56865_56880[(5)] = ex56858);


if((ex56858 instanceof Error)){
var statearr_56866_56881 = state_56853__$1;
(statearr_56866_56881[(1)] = (4));

(statearr_56866_56881[(5)] = null);

} else {
throw ex56858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56854 === (8))){
var inst_56848 = (state_56853[(2)]);
var _ = (function (){var statearr_56867 = state_56853;
(statearr_56867[(4)] = cljs.core.rest((state_56853[(4)])));

return statearr_56867;
})();
var state_56853__$1 = state_56853;
var statearr_56868_56882 = state_56853__$1;
(statearr_56868_56882[(2)] = inst_56848);

(statearr_56868_56882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0 = (function (){
var statearr_56869 = [null,null,null,null,null,null,null,null];
(statearr_56869[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__);

(statearr_56869[(1)] = (1));

return statearr_56869;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1 = (function (state_56853){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56853);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56870){var ex__2417__auto__ = e56870;
var statearr_56871_56883 = state_56853;
(statearr_56871_56883[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56853[(4)]))){
var statearr_56872_56884 = state_56853;
(statearr_56872_56884[(1)] = cljs.core.first((state_56853[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56885 = state_56853;
state_56853 = G__56885;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__ = function(state_56853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1.call(this,state_56853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56873 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56873[(6)] = c__2436__auto__);

return statearr_56873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56887 = arguments.length;
switch (G__56887) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_56929){
var state_val_56930 = (state_56929[(1)]);
if((state_val_56930 === (7))){
var state_56929__$1 = state_56929;
var statearr_56931_56961 = state_56929__$1;
(statearr_56931_56961[(2)] = seed);

(statearr_56931_56961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (1))){
var state_56929__$1 = state_56929;
var statearr_56932_56962 = state_56929__$1;
(statearr_56932_56962[(2)] = null);

(statearr_56932_56962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (4))){
var inst_56888 = (state_56929[(2)]);
var state_56929__$1 = state_56929;
var statearr_56933_56963 = state_56929__$1;
(statearr_56933_56963[(2)] = inst_56888);

(statearr_56933_56963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (15))){
var state_56929__$1 = state_56929;
var statearr_56934_56964 = state_56929__$1;
(statearr_56934_56964[(2)] = (10));

(statearr_56934_56964[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (13))){
var inst_56905 = (state_56929[(2)]);
var inst_56906 = fluree.db.util.async.throw_err(inst_56905);
var state_56929__$1 = state_56929;
var statearr_56935_56965 = state_56929__$1;
(statearr_56935_56965[(2)] = inst_56906);

(statearr_56935_56965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (6))){
var state_56929__$1 = state_56929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56929__$1,(9),seed);
} else {
if((state_val_56930 === (3))){
var inst_56927 = (state_56929[(2)]);
var state_56929__$1 = state_56929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56929__$1,inst_56927);
} else {
if((state_val_56930 === (12))){
var inst_56909 = (state_56929[(7)]);
var inst_56909__$1 = (state_56929[(2)]);
var state_56929__$1 = (function (){var statearr_56936 = state_56929;
(statearr_56936[(7)] = inst_56909__$1);

return statearr_56936;
})();
if(cljs.core.truth_(inst_56909__$1)){
var statearr_56937_56966 = state_56929__$1;
(statearr_56937_56966[(1)] = (14));

} else {
var statearr_56938_56967 = state_56929__$1;
(statearr_56938_56967[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (2))){
var _ = (function (){var statearr_56939 = state_56929;
(statearr_56939[(4)] = cljs.core.cons((5),(state_56929[(4)])));

return statearr_56939;
})();
var inst_56894 = fluree.db.util.async.channel_QMARK_(seed);
var state_56929__$1 = state_56929;
if(inst_56894){
var statearr_56940_56968 = state_56929__$1;
(statearr_56940_56968[(1)] = (6));

} else {
var statearr_56941_56969 = state_56929__$1;
(statearr_56941_56969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (11))){
var state_56929__$1 = state_56929;
var statearr_56943_56970 = state_56929__$1;
(statearr_56943_56970[(2)] = max);

(statearr_56943_56970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (9))){
var inst_56897 = (state_56929[(2)]);
var inst_56898 = fluree.db.util.async.throw_err(inst_56897);
var state_56929__$1 = state_56929;
var statearr_56944_56971 = state_56929__$1;
(statearr_56944_56971[(2)] = inst_56898);

(statearr_56944_56971[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (5))){
var _ = (function (){var statearr_56945 = state_56929;
(statearr_56945[(4)] = cljs.core.rest((state_56929[(4)])));

return statearr_56945;
})();
var state_56929__$1 = state_56929;
var ex56942 = (state_56929__$1[(2)]);
var statearr_56946_56972 = state_56929__$1;
(statearr_56946_56972[(5)] = ex56942);


if((ex56942 instanceof Error)){
var statearr_56947_56973 = state_56929__$1;
(statearr_56947_56973[(1)] = (4));

(statearr_56947_56973[(5)] = null);

} else {
throw ex56942;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (14))){
var inst_56909 = (state_56929[(7)]);
var state_56929__$1 = state_56929;
var statearr_56948_56974 = state_56929__$1;
(statearr_56948_56974[(2)] = inst_56909);

(statearr_56948_56974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (16))){
var inst_56901 = (state_56929[(8)]);
var inst_56913 = (state_56929[(2)]);
var inst_56914 = fluree.db.dbfunctions.internal.rand(inst_56901,inst_56913);
var inst_56915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56916 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56918 = [max,seed];
var inst_56919 = (new cljs.core.PersistentVector(null,2,(5),inst_56917,inst_56918,null));
var inst_56920 = ["rand",inst_56919,inst_56914];
var inst_56921 = cljs.core.PersistentHashMap.fromArrays(inst_56916,inst_56920);
var inst_56922 = [inst_56921,(10)];
var inst_56923 = (new cljs.core.PersistentVector(null,2,(5),inst_56915,inst_56922,null));
var inst_56924 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56923);
var _ = (function (){var statearr_56949 = state_56929;
(statearr_56949[(4)] = cljs.core.rest((state_56929[(4)])));

return statearr_56949;
})();
var state_56929__$1 = (function (){var statearr_56950 = state_56929;
(statearr_56950[(9)] = inst_56924);

return statearr_56950;
})();
var statearr_56951_56975 = state_56929__$1;
(statearr_56951_56975[(2)] = inst_56914);

(statearr_56951_56975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56930 === (10))){
var state_56929__$1 = state_56929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56929__$1,(13),max);
} else {
if((state_val_56930 === (8))){
var inst_56901 = (state_56929[(2)]);
var inst_56902 = fluree.db.util.async.channel_QMARK_(max);
var state_56929__$1 = (function (){var statearr_56952 = state_56929;
(statearr_56952[(8)] = inst_56901);

return statearr_56952;
})();
if(inst_56902){
var statearr_56953_56976 = state_56929__$1;
(statearr_56953_56976[(1)] = (10));

} else {
var statearr_56954_56977 = state_56929__$1;
(statearr_56954_56977[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2414__auto____0 = (function (){
var statearr_56955 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56955[(0)] = fluree$db$dbfunctions$fns$state_machine__2414__auto__);

(statearr_56955[(1)] = (1));

return statearr_56955;
});
var fluree$db$dbfunctions$fns$state_machine__2414__auto____1 = (function (state_56929){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_56929);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e56956){var ex__2417__auto__ = e56956;
var statearr_56957_56978 = state_56929;
(statearr_56957_56978[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_56929[(4)]))){
var statearr_56958_56979 = state_56929;
(statearr_56958_56979[(1)] = cljs.core.first((state_56929[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56980 = state_56929;
state_56929 = G__56980;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2414__auto__ = function(state_56929){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2414__auto____1.call(this,state_56929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_56959 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_56959[(6)] = c__2436__auto__);

return statearr_56959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57001){
var state_val_57002 = (state_57001[(1)]);
if((state_val_57002 === (1))){
var state_57001__$1 = state_57001;
var statearr_57003_57018 = state_57001__$1;
(statearr_57003_57018[(2)] = null);

(statearr_57003_57018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57002 === (2))){
var _ = (function (){var statearr_57004 = state_57001;
(statearr_57004[(4)] = cljs.core.cons((5),(state_57001[(4)])));

return statearr_57004;
})();
var inst_56987 = fluree.db.util.core.random_uuid();
var inst_56988 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56987);
var inst_56989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56990 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56991 = cljs.core.PersistentVector.EMPTY;
var inst_56992 = ["uuid",inst_56991,inst_56988];
var inst_56993 = cljs.core.PersistentHashMap.fromArrays(inst_56990,inst_56992);
var inst_56994 = [inst_56993,(10)];
var inst_56995 = (new cljs.core.PersistentVector(null,2,(5),inst_56989,inst_56994,null));
var inst_56996 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56995);
var ___$1 = (function (){var statearr_57005 = state_57001;
(statearr_57005[(4)] = cljs.core.rest((state_57001[(4)])));

return statearr_57005;
})();
var state_57001__$1 = (function (){var statearr_57006 = state_57001;
(statearr_57006[(7)] = inst_56996);

return statearr_57006;
})();
var statearr_57007_57019 = state_57001__$1;
(statearr_57007_57019[(2)] = inst_56988);

(statearr_57007_57019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57002 === (3))){
var inst_56999 = (state_57001[(2)]);
var state_57001__$1 = state_57001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57001__$1,inst_56999);
} else {
if((state_val_57002 === (4))){
var inst_56981 = (state_57001[(2)]);
var state_57001__$1 = state_57001;
var statearr_57009_57020 = state_57001__$1;
(statearr_57009_57020[(2)] = inst_56981);

(statearr_57009_57020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57002 === (5))){
var _ = (function (){var statearr_57010 = state_57001;
(statearr_57010[(4)] = cljs.core.rest((state_57001[(4)])));

return statearr_57010;
})();
var state_57001__$1 = state_57001;
var ex57008 = (state_57001__$1[(2)]);
var statearr_57011_57021 = state_57001__$1;
(statearr_57011_57021[(5)] = ex57008);


if((ex57008 instanceof Error)){
var statearr_57012_57022 = state_57001__$1;
(statearr_57012_57022[(1)] = (4));

(statearr_57012_57022[(5)] = null);

} else {
throw ex57008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0 = (function (){
var statearr_57013 = [null,null,null,null,null,null,null,null];
(statearr_57013[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__);

(statearr_57013[(1)] = (1));

return statearr_57013;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1 = (function (state_57001){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57001);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57014){var ex__2417__auto__ = e57014;
var statearr_57015_57023 = state_57001;
(statearr_57015_57023[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57001[(4)]))){
var statearr_57016_57024 = state_57001;
(statearr_57016_57024[(1)] = cljs.core.first((state_57001[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57025 = state_57001;
state_57001 = G__57025;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__ = function(state_57001){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1.call(this,state_57001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57017 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57017[(6)] = c__2436__auto__);

return statearr_57017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57055){
var state_val_57056 = (state_57055[(1)]);
if((state_val_57056 === (7))){
var state_57055__$1 = state_57055;
var statearr_57057_57076 = state_57055__$1;
(statearr_57057_57076[(2)] = num);

(statearr_57057_57076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (1))){
var state_57055__$1 = state_57055;
var statearr_57058_57077 = state_57055__$1;
(statearr_57058_57077[(2)] = null);

(statearr_57058_57077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (4))){
var inst_57026 = (state_57055[(2)]);
var state_57055__$1 = state_57055;
var statearr_57059_57078 = state_57055__$1;
(statearr_57059_57078[(2)] = inst_57026);

(statearr_57059_57078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (6))){
var state_57055__$1 = state_57055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57055__$1,(9),num);
} else {
if((state_val_57056 === (3))){
var inst_57053 = (state_57055[(2)]);
var state_57055__$1 = state_57055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57055__$1,inst_57053);
} else {
if((state_val_57056 === (2))){
var _ = (function (){var statearr_57061 = state_57055;
(statearr_57061[(4)] = cljs.core.cons((5),(state_57055[(4)])));

return statearr_57061;
})();
var inst_57032 = fluree.db.util.async.channel_QMARK_(num);
var state_57055__$1 = state_57055;
if(inst_57032){
var statearr_57062_57079 = state_57055__$1;
(statearr_57062_57079[(1)] = (6));

} else {
var statearr_57063_57080 = state_57055__$1;
(statearr_57063_57080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (9))){
var inst_57035 = (state_57055[(2)]);
var inst_57036 = fluree.db.util.async.throw_err(inst_57035);
var state_57055__$1 = state_57055;
var statearr_57064_57081 = state_57055__$1;
(statearr_57064_57081[(2)] = inst_57036);

(statearr_57064_57081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (5))){
var _ = (function (){var statearr_57065 = state_57055;
(statearr_57065[(4)] = cljs.core.rest((state_57055[(4)])));

return statearr_57065;
})();
var state_57055__$1 = state_57055;
var ex57060 = (state_57055__$1[(2)]);
var statearr_57066_57082 = state_57055__$1;
(statearr_57066_57082[(5)] = ex57060);


if((ex57060 instanceof Error)){
var statearr_57067_57083 = state_57055__$1;
(statearr_57067_57083[(1)] = (4));

(statearr_57067_57083[(5)] = null);

} else {
throw ex57060;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57056 === (8))){
var inst_57039 = (state_57055[(2)]);
var inst_57040 = fluree.db.dbfunctions.internal.ceil(inst_57039);
var inst_57041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57042 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57044 = [fluree.db.dbfunctions.fns.ceil];
var inst_57045 = (new cljs.core.PersistentVector(null,1,(5),inst_57043,inst_57044,null));
var inst_57046 = ["",inst_57045,inst_57040];
var inst_57047 = cljs.core.PersistentHashMap.fromArrays(inst_57042,inst_57046);
var inst_57048 = [inst_57047,(10)];
var inst_57049 = (new cljs.core.PersistentVector(null,2,(5),inst_57041,inst_57048,null));
var inst_57050 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57049);
var _ = (function (){var statearr_57068 = state_57055;
(statearr_57068[(4)] = cljs.core.rest((state_57055[(4)])));

return statearr_57068;
})();
var state_57055__$1 = (function (){var statearr_57069 = state_57055;
(statearr_57069[(7)] = inst_57050);

return statearr_57069;
})();
var statearr_57070_57084 = state_57055__$1;
(statearr_57070_57084[(2)] = inst_57040);

(statearr_57070_57084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0 = (function (){
var statearr_57071 = [null,null,null,null,null,null,null,null];
(statearr_57071[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__);

(statearr_57071[(1)] = (1));

return statearr_57071;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1 = (function (state_57055){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57055);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57072){var ex__2417__auto__ = e57072;
var statearr_57073_57085 = state_57055;
(statearr_57073_57085[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57055[(4)]))){
var statearr_57074_57086 = state_57055;
(statearr_57074_57086[(1)] = cljs.core.first((state_57055[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57087 = state_57055;
state_57055 = G__57087;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__ = function(state_57055){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1.call(this,state_57055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57075 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57075[(6)] = c__2436__auto__);

return statearr_57075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57117){
var state_val_57118 = (state_57117[(1)]);
if((state_val_57118 === (7))){
var state_57117__$1 = state_57117;
var statearr_57119_57138 = state_57117__$1;
(statearr_57119_57138[(2)] = num);

(statearr_57119_57138[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (1))){
var state_57117__$1 = state_57117;
var statearr_57120_57139 = state_57117__$1;
(statearr_57120_57139[(2)] = null);

(statearr_57120_57139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (4))){
var inst_57088 = (state_57117[(2)]);
var state_57117__$1 = state_57117;
var statearr_57121_57140 = state_57117__$1;
(statearr_57121_57140[(2)] = inst_57088);

(statearr_57121_57140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (6))){
var state_57117__$1 = state_57117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57117__$1,(9),num);
} else {
if((state_val_57118 === (3))){
var inst_57115 = (state_57117[(2)]);
var state_57117__$1 = state_57117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57117__$1,inst_57115);
} else {
if((state_val_57118 === (2))){
var _ = (function (){var statearr_57123 = state_57117;
(statearr_57123[(4)] = cljs.core.cons((5),(state_57117[(4)])));

return statearr_57123;
})();
var inst_57094 = fluree.db.util.async.channel_QMARK_(num);
var state_57117__$1 = state_57117;
if(inst_57094){
var statearr_57124_57141 = state_57117__$1;
(statearr_57124_57141[(1)] = (6));

} else {
var statearr_57125_57142 = state_57117__$1;
(statearr_57125_57142[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (9))){
var inst_57097 = (state_57117[(2)]);
var inst_57098 = fluree.db.util.async.throw_err(inst_57097);
var state_57117__$1 = state_57117;
var statearr_57126_57143 = state_57117__$1;
(statearr_57126_57143[(2)] = inst_57098);

(statearr_57126_57143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (5))){
var _ = (function (){var statearr_57127 = state_57117;
(statearr_57127[(4)] = cljs.core.rest((state_57117[(4)])));

return statearr_57127;
})();
var state_57117__$1 = state_57117;
var ex57122 = (state_57117__$1[(2)]);
var statearr_57128_57144 = state_57117__$1;
(statearr_57128_57144[(5)] = ex57122);


if((ex57122 instanceof Error)){
var statearr_57129_57145 = state_57117__$1;
(statearr_57129_57145[(1)] = (4));

(statearr_57129_57145[(5)] = null);

} else {
throw ex57122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57118 === (8))){
var inst_57101 = (state_57117[(2)]);
var inst_57102 = fluree.db.dbfunctions.internal.floor(inst_57101);
var inst_57103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57104 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57106 = [fluree.db.dbfunctions.fns.floor];
var inst_57107 = (new cljs.core.PersistentVector(null,1,(5),inst_57105,inst_57106,null));
var inst_57108 = ["",inst_57107,inst_57102];
var inst_57109 = cljs.core.PersistentHashMap.fromArrays(inst_57104,inst_57108);
var inst_57110 = [inst_57109,(10)];
var inst_57111 = (new cljs.core.PersistentVector(null,2,(5),inst_57103,inst_57110,null));
var inst_57112 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57111);
var _ = (function (){var statearr_57130 = state_57117;
(statearr_57130[(4)] = cljs.core.rest((state_57117[(4)])));

return statearr_57130;
})();
var state_57117__$1 = (function (){var statearr_57131 = state_57117;
(statearr_57131[(7)] = inst_57112);

return statearr_57131;
})();
var statearr_57132_57146 = state_57117__$1;
(statearr_57132_57146[(2)] = inst_57102);

(statearr_57132_57146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0 = (function (){
var statearr_57133 = [null,null,null,null,null,null,null,null];
(statearr_57133[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__);

(statearr_57133[(1)] = (1));

return statearr_57133;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1 = (function (state_57117){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57117);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57134){var ex__2417__auto__ = e57134;
var statearr_57135_57147 = state_57117;
(statearr_57135_57147[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57117[(4)]))){
var statearr_57136_57148 = state_57117;
(statearr_57136_57148[(1)] = cljs.core.first((state_57117[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57149 = state_57117;
state_57117 = G__57149;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__ = function(state_57117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1.call(this,state_57117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57137 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57137[(6)] = c__2436__auto__);

return statearr_57137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_57174){
var state_val_57175 = (state_57174[(1)]);
if((state_val_57175 === (1))){
var state_57174__$1 = state_57174;
var statearr_57176_57191 = state_57174__$1;
(statearr_57176_57191[(2)] = null);

(statearr_57176_57191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57175 === (2))){
var _ = (function (){var statearr_57177 = state_57174;
(statearr_57177[(4)] = cljs.core.cons((5),(state_57174[(4)])));

return statearr_57177;
})();
var inst_57156 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57174__$1 = state_57174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57174__$1,(6),inst_57156);
} else {
if((state_val_57175 === (3))){
var inst_57172 = (state_57174[(2)]);
var state_57174__$1 = state_57174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57174__$1,inst_57172);
} else {
if((state_val_57175 === (4))){
var inst_57150 = (state_57174[(2)]);
var state_57174__$1 = state_57174;
var statearr_57179_57192 = state_57174__$1;
(statearr_57179_57192[(2)] = inst_57150);

(statearr_57179_57192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57175 === (5))){
var _ = (function (){var statearr_57180 = state_57174;
(statearr_57180[(4)] = cljs.core.rest((state_57174[(4)])));

return statearr_57180;
})();
var state_57174__$1 = state_57174;
var ex57178 = (state_57174__$1[(2)]);
var statearr_57181_57193 = state_57174__$1;
(statearr_57181_57193[(5)] = ex57178);


if((ex57178 instanceof Error)){
var statearr_57182_57194 = state_57174__$1;
(statearr_57182_57194[(1)] = (4));

(statearr_57182_57194[(5)] = null);

} else {
throw ex57178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57175 === (6))){
var inst_57158 = (state_57174[(2)]);
var inst_57159 = fluree.db.util.async.throw_err(inst_57158);
var inst_57160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57161 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57163 = [compare_val,new_val];
var inst_57164 = (new cljs.core.PersistentVector(null,2,(5),inst_57162,inst_57163,null));
var inst_57165 = ["",inst_57164,inst_57159];
var inst_57166 = cljs.core.PersistentHashMap.fromArrays(inst_57161,inst_57165);
var inst_57167 = [inst_57166,(10)];
var inst_57168 = (new cljs.core.PersistentVector(null,2,(5),inst_57160,inst_57167,null));
var inst_57169 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57168);
var _ = (function (){var statearr_57183 = state_57174;
(statearr_57183[(4)] = cljs.core.rest((state_57174[(4)])));

return statearr_57183;
})();
var state_57174__$1 = (function (){var statearr_57184 = state_57174;
(statearr_57184[(7)] = inst_57169);

return statearr_57184;
})();
var statearr_57185_57195 = state_57174__$1;
(statearr_57185_57195[(2)] = inst_57159);

(statearr_57185_57195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____0 = (function (){
var statearr_57186 = [null,null,null,null,null,null,null,null];
(statearr_57186[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__);

(statearr_57186[(1)] = (1));

return statearr_57186;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____1 = (function (state_57174){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_57174);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e57187){var ex__2417__auto__ = e57187;
var statearr_57188_57196 = state_57174;
(statearr_57188_57196[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_57174[(4)]))){
var statearr_57189_57197 = state_57174;
(statearr_57189_57197[(1)] = cljs.core.first((state_57174[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57198 = state_57174;
state_57174 = G__57198;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__ = function(state_57174){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____1.call(this,state_57174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_57190 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_57190[(6)] = c__2436__auto__);

return statearr_57190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
