// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27928 = arguments.length;
var i__4737__auto___27929 = (0);
while(true){
if((i__4737__auto___27929 < len__4736__auto___27928)){
args__4742__auto__.push((arguments[i__4737__auto___27929]));

var G__27930 = (i__4737__auto___27929 + (1));
i__4737__auto___27929 = G__27930;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq27925){
var G__27926 = cljs.core.first(seq27925);
var seq27925__$1 = cljs.core.next(seq27925);
var G__27927 = cljs.core.first(seq27925__$1);
var seq27925__$2 = cljs.core.next(seq27925__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27926,G__27927,seq27925__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e27931){var e = e27931;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e27932){var e = e27932;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e27933){var e = e27933;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e27934){var e = e27934;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e27935){var e = e27935;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27938 = arguments.length;
var i__4737__auto___27939 = (0);
while(true){
if((i__4737__auto___27939 < len__4736__auto___27938)){
args__4742__auto__.push((arguments[i__4737__auto___27939]));

var G__27940 = (i__4737__auto___27939 + (1));
i__4737__auto___27939 = G__27940;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27937){var e = e27937;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq27936){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27936));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27943 = arguments.length;
var i__4737__auto___27944 = (0);
while(true){
if((i__4737__auto___27944 < len__4736__auto___27943)){
args__4742__auto__.push((arguments[i__4737__auto___27944]));

var G__27945 = (i__4737__auto___27944 + (1));
i__4737__auto___27944 = G__27945;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27942){var e = e27942;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq27941){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27941));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e27946){var e = e27946;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27949 = arguments.length;
var i__4737__auto___27950 = (0);
while(true){
if((i__4737__auto___27950 < len__4736__auto___27949)){
args__4742__auto__.push((arguments[i__4737__auto___27950]));

var G__27951 = (i__4737__auto___27950 + (1));
i__4737__auto___27950 = G__27951;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e27948){var e = e27948;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq27947){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27947));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27954 = arguments.length;
var i__4737__auto___27955 = (0);
while(true){
if((i__4737__auto___27955 < len__4736__auto___27954)){
args__4742__auto__.push((arguments[i__4737__auto___27955]));

var G__27956 = (i__4737__auto___27955 + (1));
i__4737__auto___27955 = G__27956;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e27953){var e = e27953;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq27952){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27952));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e27957){var e = e27957;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e27958){var e = e27958;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27961 = arguments.length;
var i__4737__auto___27962 = (0);
while(true){
if((i__4737__auto___27962 < len__4736__auto___27961)){
args__4742__auto__.push((arguments[i__4737__auto___27962]));

var G__27963 = (i__4737__auto___27962 + (1));
i__4737__auto___27962 = G__27963;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27960){var e = e27960;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq27959){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27959));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27966 = arguments.length;
var i__4737__auto___27967 = (0);
while(true){
if((i__4737__auto___27967 < len__4736__auto___27966)){
args__4742__auto__.push((arguments[i__4737__auto___27967]));

var G__27968 = (i__4737__auto___27967 + (1));
i__4737__auto___27967 = G__27968;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27965){var e = e27965;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq27964){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27964));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27971 = arguments.length;
var i__4737__auto___27972 = (0);
while(true){
if((i__4737__auto___27972 < len__4736__auto___27971)){
args__4742__auto__.push((arguments[i__4737__auto___27972]));

var G__27973 = (i__4737__auto___27972 + (1));
i__4737__auto___27972 = G__27973;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e27970){var e = e27970;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq27969){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27969));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27976 = arguments.length;
var i__4737__auto___27977 = (0);
while(true){
if((i__4737__auto___27977 < len__4736__auto___27976)){
args__4742__auto__.push((arguments[i__4737__auto___27977]));

var G__27978 = (i__4737__auto___27977 + (1));
i__4737__auto___27977 = G__27978;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e27975){var e = e27975;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq27974){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27974));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27981 = arguments.length;
var i__4737__auto___27982 = (0);
while(true){
if((i__4737__auto___27982 < len__4736__auto___27981)){
args__4742__auto__.push((arguments[i__4737__auto___27982]));

var G__27983 = (i__4737__auto___27982 + (1));
i__4737__auto___27982 = G__27983;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e27980){var e = e27980;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq27979){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27979));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27986 = arguments.length;
var i__4737__auto___27987 = (0);
while(true){
if((i__4737__auto___27987 < len__4736__auto___27986)){
args__4742__auto__.push((arguments[i__4737__auto___27987]));

var G__27988 = (i__4737__auto___27987 + (1));
i__4737__auto___27987 = G__27988;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e27985){var e = e27985;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq27984){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27984));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___27991 = arguments.length;
var i__4737__auto___27992 = (0);
while(true){
if((i__4737__auto___27992 < len__4736__auto___27991)){
args__4742__auto__.push((arguments[i__4737__auto___27992]));

var G__27993 = (i__4737__auto___27992 + (1));
i__4737__auto___27992 = G__27993;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e27990){var e = e27990;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq27989){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27989));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__27995 = arguments.length;
switch (G__27995) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28023){
var state_val_28024 = (state_28023[(1)]);
if((state_val_28024 === (7))){
var inst_28008 = (state_28023[(7)]);
var inst_28011 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28008,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28023__$1 = state_28023;
var statearr_28025_28111 = state_28023__$1;
(statearr_28025_28111[(2)] = inst_28011);

(statearr_28025_28111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (1))){
var state_28023__$1 = state_28023;
var statearr_28026_28112 = state_28023__$1;
(statearr_28026_28112[(2)] = null);

(statearr_28026_28112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (4))){
var inst_27996 = (state_28023[(2)]);
var state_28023__$1 = state_28023;
var statearr_28027_28113 = state_28023__$1;
(statearr_28027_28113[(2)] = inst_27996);

(statearr_28027_28113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (6))){
var inst_28008 = (state_28023[(7)]);
var inst_28008__$1 = (state_28023[(2)]);
var inst_28009 = fluree.db.util.core.exception_QMARK_(inst_28008__$1);
var state_28023__$1 = (function (){var statearr_28028 = state_28023;
(statearr_28028[(7)] = inst_28008__$1);

return statearr_28028;
})();
if(inst_28009){
var statearr_28029_28114 = state_28023__$1;
(statearr_28029_28114[(1)] = (7));

} else {
var statearr_28030_28115 = state_28023__$1;
(statearr_28030_28115[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (3))){
var inst_28021 = (state_28023[(2)]);
var state_28023__$1 = state_28023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28023__$1,inst_28021);
} else {
if((state_val_28024 === (2))){
var inst_28002 = (state_28023[(8)]);
var _ = (function (){var statearr_28032 = state_28023;
(statearr_28032[(4)] = cljs.core.cons((5),(state_28023[(4)])));

return statearr_28032;
})();
var inst_28002__$1 = cljs.core.volatile_BANG_((0));
var inst_28003 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28004 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28003,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28002__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28005 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28004);
var inst_28006 = fluree.db.query.fql.query(db,inst_28005);
var state_28023__$1 = (function (){var statearr_28033 = state_28023;
(statearr_28033[(8)] = inst_28002__$1);

return statearr_28033;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28023__$1,(6),inst_28006);
} else {
if((state_val_28024 === (9))){
var inst_28018 = (state_28023[(2)]);
var _ = (function (){var statearr_28034 = state_28023;
(statearr_28034[(4)] = cljs.core.rest((state_28023[(4)])));

return statearr_28034;
})();
var state_28023__$1 = state_28023;
var statearr_28035_28116 = state_28023__$1;
(statearr_28035_28116[(2)] = inst_28018);

(statearr_28035_28116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (5))){
var _ = (function (){var statearr_28036 = state_28023;
(statearr_28036[(4)] = cljs.core.rest((state_28023[(4)])));

return statearr_28036;
})();
var state_28023__$1 = state_28023;
var ex28031 = (state_28023__$1[(2)]);
var statearr_28037_28117 = state_28023__$1;
(statearr_28037_28117[(5)] = ex28031);


if((ex28031 instanceof Error)){
var statearr_28038_28118 = state_28023__$1;
(statearr_28038_28118[(1)] = (4));

(statearr_28038_28118[(5)] = null);

} else {
throw ex28031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28024 === (8))){
var inst_28002 = (state_28023[(8)]);
var inst_28008 = (state_28023[(7)]);
var inst_28013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28014 = cljs.core.deref(inst_28002);
var inst_28015 = [inst_28008,inst_28014];
var inst_28016 = (new cljs.core.PersistentVector(null,2,(5),inst_28013,inst_28015,null));
var state_28023__$1 = state_28023;
var statearr_28039_28119 = state_28023__$1;
(statearr_28039_28119[(2)] = inst_28016);

(statearr_28039_28119[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28040 = [null,null,null,null,null,null,null,null,null];
(statearr_28040[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28040[(1)] = (1));

return statearr_28040;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28023){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28023);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28041){var ex__2417__auto__ = e28041;
var statearr_28042_28120 = state_28023;
(statearr_28042_28120[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28023[(4)]))){
var statearr_28043_28121 = state_28023;
(statearr_28043_28121[(1)] = cljs.core.first((state_28023[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28122 = state_28023;
state_28023 = G__28122;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28023){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28044 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28044[(6)] = c__2436__auto__);

return statearr_28044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28089){
var state_val_28090 = (state_28089[(1)]);
if((state_val_28090 === (7))){
var inst_28075 = (state_28089[(2)]);
var inst_28076 = fluree.db.query.fql.query(db,inst_28075);
var state_28089__$1 = state_28089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28089__$1,(8),inst_28076);
} else {
if((state_val_28090 === (1))){
var inst_28045 = typeof select === 'string';
var state_28089__$1 = state_28089;
if(cljs.core.truth_(inst_28045)){
var statearr_28091_28123 = state_28089__$1;
(statearr_28091_28123[(1)] = (2));

} else {
var statearr_28092_28124 = state_28089__$1;
(statearr_28092_28124[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (4))){
var inst_28051 = (state_28089[(7)]);
var inst_28058 = (state_28089[(8)]);
var inst_28050 = (state_28089[(2)]);
var inst_28051__$1 = cljs.core.volatile_BANG_((0));
var inst_28052 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28053 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28054 = [inst_28051__$1,(100000)];
var inst_28055 = cljs.core.PersistentHashMap.fromArrays(inst_28053,inst_28054);
var inst_28056 = [inst_28050,from,where,block,limit,inst_28055];
var inst_28057 = cljs.core.PersistentHashMap.fromArrays(inst_28052,inst_28056);
var inst_28058__$1 = fluree.db.util.core.without_nils(inst_28057);
var inst_28059 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28058__$1);
var inst_28060 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28058__$1);
var inst_28061 = cljs.core.first(inst_28060);
var inst_28062 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28061], 0));
var inst_28063 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28062);
var inst_28064 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28058__$1);
var inst_28065 = cljs.core.last(inst_28064);
var inst_28066 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28065], 0));
var inst_28067 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28066);
var inst_28068 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28059,inst_28063,inst_28067], 0));
var state_28089__$1 = (function (){var statearr_28093 = state_28089;
(statearr_28093[(7)] = inst_28051__$1);

(statearr_28093[(8)] = inst_28058__$1);

return statearr_28093;
})();
if(cljs.core.truth_(inst_28068)){
var statearr_28094_28125 = state_28089__$1;
(statearr_28094_28125[(1)] = (5));

} else {
var statearr_28095_28126 = state_28089__$1;
(statearr_28095_28126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (6))){
var inst_28058 = (state_28089[(8)]);
var state_28089__$1 = state_28089;
var statearr_28096_28127 = state_28089__$1;
(statearr_28096_28127[(2)] = inst_28058);

(statearr_28096_28127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (3))){
var state_28089__$1 = state_28089;
var statearr_28097_28128 = state_28089__$1;
(statearr_28097_28128[(2)] = select);

(statearr_28097_28128[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (2))){
var inst_28047 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28089__$1 = state_28089;
var statearr_28098_28129 = state_28089__$1;
(statearr_28098_28129[(2)] = inst_28047);

(statearr_28098_28129[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (11))){
var inst_28087 = (state_28089[(2)]);
var state_28089__$1 = state_28089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28089__$1,inst_28087);
} else {
if((state_val_28090 === (9))){
var inst_28078 = (state_28089[(9)]);
var state_28089__$1 = state_28089;
var statearr_28099_28130 = state_28089__$1;
(statearr_28099_28130[(2)] = inst_28078);

(statearr_28099_28130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (5))){
var inst_28058 = (state_28089[(8)]);
var inst_28070 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28058);
var inst_28071 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28070);
var inst_28072 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28058,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28071);
var state_28089__$1 = state_28089;
var statearr_28100_28131 = state_28089__$1;
(statearr_28100_28131[(2)] = inst_28072);

(statearr_28100_28131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (10))){
var inst_28051 = (state_28089[(7)]);
var inst_28078 = (state_28089[(9)]);
var inst_28082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28083 = cljs.core.deref(inst_28051);
var inst_28084 = [inst_28078,inst_28083];
var inst_28085 = (new cljs.core.PersistentVector(null,2,(5),inst_28082,inst_28084,null));
var state_28089__$1 = state_28089;
var statearr_28101_28132 = state_28089__$1;
(statearr_28101_28132[(2)] = inst_28085);

(statearr_28101_28132[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28090 === (8))){
var inst_28078 = (state_28089[(9)]);
var inst_28078__$1 = (state_28089[(2)]);
var inst_28079 = fluree.db.util.core.exception_QMARK_(inst_28078__$1);
var state_28089__$1 = (function (){var statearr_28102 = state_28089;
(statearr_28102[(9)] = inst_28078__$1);

return statearr_28102;
})();
if(inst_28079){
var statearr_28103_28133 = state_28089__$1;
(statearr_28103_28133[(1)] = (9));

} else {
var statearr_28104_28134 = state_28089__$1;
(statearr_28104_28134[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28105 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28105[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28105[(1)] = (1));

return statearr_28105;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28089){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28089);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28106){var ex__2417__auto__ = e28106;
var statearr_28107_28135 = state_28089;
(statearr_28107_28135[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28089[(4)]))){
var statearr_28108_28136 = state_28089;
(statearr_28108_28136[(1)] = cljs.core.first((state_28089[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28137 = state_28089;
state_28089 = G__28137;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28089){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28109 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28109[(6)] = c__2436__auto__);

return statearr_28109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28141 = path;
var vec__28142 = G__28141;
var seq__28143 = cljs.core.seq(vec__28142);
var first__28144 = cljs.core.first(seq__28143);
var seq__28143__$1 = cljs.core.next(seq__28143);
var var$ = first__28144;
var r = seq__28143__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28141__$1 = G__28141;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28148 = G__28141__$1;
var seq__28149 = cljs.core.seq(vec__28148);
var first__28150 = cljs.core.first(seq__28149);
var seq__28149__$1 = cljs.core.next(seq__28149);
var var$__$1 = first__28150;
var r__$1 = seq__28149__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28151 = r__$1;
var G__28152 = n__$2;
var G__28153 = next_clauses;
G__28141__$1 = G__28151;
n__$1 = G__28152;
where_clauses__$1 = G__28153;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28154 = r__$1;
var G__28155 = next_n;
var G__28156 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28141__$1 = G__28154;
n__$1 = G__28155;
where_clauses__$1 = G__28156;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28193){
var state_val_28194 = (state_28193[(1)]);
if((state_val_28194 === (7))){
var inst_28166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28167 = [path];
var inst_28168 = (new cljs.core.PersistentVector(null,1,(5),inst_28166,inst_28167,null));
var state_28193__$1 = state_28193;
var statearr_28195_28223 = state_28193__$1;
(statearr_28195_28223[(2)] = inst_28168);

(statearr_28195_28223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (1))){
var state_28193__$1 = state_28193;
var statearr_28196_28224 = state_28193__$1;
(statearr_28196_28224[(2)] = null);

(statearr_28196_28224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (4))){
var inst_28157 = (state_28193[(2)]);
var state_28193__$1 = state_28193;
var statearr_28197_28225 = state_28193__$1;
(statearr_28197_28225[(2)] = inst_28157);

(statearr_28197_28225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (13))){
var inst_28184 = (state_28193[(2)]);
var inst_28185 = fluree.db.util.async.throw_err(inst_28184);
var _ = (function (){var statearr_28198 = state_28193;
(statearr_28198[(4)] = cljs.core.rest((state_28193[(4)])));

return statearr_28198;
})();
var state_28193__$1 = state_28193;
var statearr_28199_28226 = state_28193__$1;
(statearr_28199_28226[(2)] = inst_28185);

(statearr_28199_28226[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (6))){
var state_28193__$1 = state_28193;
var statearr_28201_28227 = state_28193__$1;
(statearr_28201_28227[(2)] = path);

(statearr_28201_28227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (3))){
var inst_28191 = (state_28193[(2)]);
var state_28193__$1 = state_28193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28193__$1,inst_28191);
} else {
if((state_val_28194 === (12))){
var _ = (function (){var statearr_28202 = state_28193;
(statearr_28202[(4)] = cljs.core.rest((state_28193[(4)])));

return statearr_28202;
})();
var state_28193__$1 = state_28193;
var ex28200 = (state_28193__$1[(2)]);
var statearr_28203_28228 = state_28193__$1;
(statearr_28203_28228[(5)] = ex28200);


var statearr_28204_28229 = state_28193__$1;
(statearr_28204_28229[(1)] = (11));

(statearr_28204_28229[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (2))){
var _ = (function (){var statearr_28205 = state_28193;
(statearr_28205[(4)] = cljs.core.cons((5),(state_28193[(4)])));

return statearr_28205;
})();
var inst_28163 = cljs.core.vector_QMARK_(path);
var state_28193__$1 = state_28193;
if(inst_28163){
var statearr_28206_28230 = state_28193__$1;
(statearr_28206_28230[(1)] = (6));

} else {
var statearr_28207_28231 = state_28193__$1;
(statearr_28207_28231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (11))){
var inst_28170 = (state_28193[(7)]);
var inst_28175 = (state_28193[(2)]);
var inst_28176 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28175,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28170,endSubject], 0));
var state_28193__$1 = state_28193;
var statearr_28209_28232 = state_28193__$1;
(statearr_28209_28232[(2)] = inst_28176);

(statearr_28209_28232[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (9))){
var inst_28174 = (state_28193[(8)]);
var _ = (function (){var statearr_28210 = state_28193;
(statearr_28210[(4)] = cljs.core.cons((12),(state_28193[(4)])));

return statearr_28210;
})();
var inst_28182 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28174);
var state_28193__$1 = state_28193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28193__$1,(13),inst_28182);
} else {
if((state_val_28194 === (5))){
var _ = (function (){var statearr_28211 = state_28193;
(statearr_28211[(4)] = cljs.core.rest((state_28193[(4)])));

return statearr_28211;
})();
var state_28193__$1 = state_28193;
var ex28208 = (state_28193__$1[(2)]);
var statearr_28212_28233 = state_28193__$1;
(statearr_28212_28233[(5)] = ex28208);


if((ex28208 instanceof Error)){
var statearr_28213_28234 = state_28193__$1;
(statearr_28213_28234[(1)] = (4));

(statearr_28213_28234[(5)] = null);

} else {
throw ex28208;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (10))){
var inst_28188 = (state_28193[(2)]);
var _ = (function (){var statearr_28214 = state_28193;
(statearr_28214[(4)] = cljs.core.rest((state_28193[(4)])));

return statearr_28214;
})();
var state_28193__$1 = state_28193;
var statearr_28215_28235 = state_28193__$1;
(statearr_28215_28235[(2)] = inst_28188);

(statearr_28215_28235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28194 === (8))){
var inst_28170 = (state_28193[(7)]);
var inst_28170__$1 = (state_28193[(2)]);
var inst_28171 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28170__$1,endSubject);
var inst_28172 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28173 = ["?var1",inst_28171];
var inst_28174 = cljs.core.PersistentHashMap.fromArrays(inst_28172,inst_28173);
var state_28193__$1 = (function (){var statearr_28216 = state_28193;
(statearr_28216[(7)] = inst_28170__$1);

(statearr_28216[(8)] = inst_28174);

return statearr_28216;
})();
var statearr_28217_28236 = state_28193__$1;
(statearr_28217_28236[(2)] = null);

(statearr_28217_28236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_28218 = [null,null,null,null,null,null,null,null,null];
(statearr_28218[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__);

(statearr_28218[(1)] = (1));

return statearr_28218;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1 = (function (state_28193){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28193);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28219){var ex__2417__auto__ = e28219;
var statearr_28220_28237 = state_28193;
(statearr_28220_28237[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28193[(4)]))){
var statearr_28221_28238 = state_28193;
(statearr_28221_28238[(1)] = cljs.core.first((state_28193[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28239 = state_28193;
state_28193 = G__28239;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__ = function(state_28193){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1.call(this,state_28193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28222 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28222[(6)] = c__2436__auto__);

return statearr_28222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28240){var e = e28240;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28241){var e = e28241;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28242){var e = e28242;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28243){var e = e28243;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28246 = arguments.length;
var i__4737__auto___28247 = (0);
while(true){
if((i__4737__auto___28247 < len__4736__auto___28246)){
args__4742__auto__.push((arguments[i__4737__auto___28247]));

var G__28248 = (i__4737__auto___28247 + (1));
i__4737__auto___28247 = G__28248;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28245){var e = e28245;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28244){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28244));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28251 = arguments.length;
var i__4737__auto___28252 = (0);
while(true){
if((i__4737__auto___28252 < len__4736__auto___28251)){
args__4742__auto__.push((arguments[i__4737__auto___28252]));

var G__28253 = (i__4737__auto___28252 + (1));
i__4737__auto___28252 = G__28253;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28250){var e = e28250;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28249){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28249));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28256 = arguments.length;
var i__4737__auto___28257 = (0);
while(true){
if((i__4737__auto___28257 < len__4736__auto___28256)){
args__4742__auto__.push((arguments[i__4737__auto___28257]));

var G__28258 = (i__4737__auto___28257 + (1));
i__4737__auto___28257 = G__28258;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28255){var e = e28255;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28254){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28254));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28261 = arguments.length;
var i__4737__auto___28262 = (0);
while(true){
if((i__4737__auto___28262 < len__4736__auto___28261)){
args__4742__auto__.push((arguments[i__4737__auto___28262]));

var G__28263 = (i__4737__auto___28262 + (1));
i__4737__auto___28262 = G__28263;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28260){var e = e28260;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28259){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28259));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28264){var e = e28264;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28265){var e = e28265;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28266){var e = e28266;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28267){var e = e28267;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28268){var e = e28268;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28274 = path;
var vec__28275 = G__28274;
var seq__28276 = cljs.core.seq(vec__28275);
var first__28277 = cljs.core.first(seq__28276);
var seq__28276__$1 = cljs.core.next(seq__28276);
var pred = first__28277;
var r = seq__28276__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28274__$1 = G__28274;
var subjects__$1 = subjects;
while(true){
var vec__28281 = G__28274__$1;
var seq__28282 = cljs.core.seq(vec__28281);
var first__28283 = cljs.core.first(seq__28282);
var seq__28282__$1 = cljs.core.next(seq__28282);
var pred__$1 = first__28283;
var r__$1 = seq__28282__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28274__$1,subjects__$1,vec__28281,seq__28282,first__28283,seq__28282__$1,pred__$1,r__$1,subjects__$2,G__28274,vec__28275,seq__28276,first__28277,seq__28276__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28274__$1,subjects__$1,vec__28281,seq__28282,first__28283,seq__28282__$1,pred__$1,r__$1,subjects__$2,G__28274,vec__28275,seq__28276,first__28277,seq__28276__$1,pred,r,subjects){
return (function (p1__28269_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28269_SHARP_,pred__$1);
});})(G__28274__$1,subjects__$1,vec__28281,seq__28282,first__28283,seq__28282__$1,pred__$1,r__$1,subjects__$2,G__28274,vec__28275,seq__28276,first__28277,seq__28276__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28274__$1,subjects__$1,vec__28281,seq__28282,first__28283,seq__28282__$1,pred__$1,r__$1,subjects__$2,G__28274,vec__28275,seq__28276,first__28277,seq__28276__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__28284 = r__$1;
var G__28285 = next_subjects;
G__28274__$1 = G__28284;
subjects__$1 = G__28285;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28270){var e = e28270;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28286){var e = e28286;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e28287){var e = e28287;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28290 = arguments.length;
var i__4737__auto___28291 = (0);
while(true){
if((i__4737__auto___28291 < len__4736__auto___28290)){
args__4742__auto__.push((arguments[i__4737__auto___28291]));

var G__28292 = (i__4737__auto___28291 + (1));
i__4737__auto___28291 = G__28292;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28289){var e = e28289;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28288){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28288));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28293){var e = e28293;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28296 = arguments.length;
var i__4737__auto___28297 = (0);
while(true){
if((i__4737__auto___28297 < len__4736__auto___28296)){
args__4742__auto__.push((arguments[i__4737__auto___28297]));

var G__28298 = (i__4737__auto___28297 + (1));
i__4737__auto___28297 = G__28298;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28295){var e = e28295;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28294){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28294));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28299){var e = e28299;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28354){
var state_val_28355 = (state_28354[(1)]);
if((state_val_28355 === (7))){
var inst_28301 = (state_28354[(2)]);
var state_28354__$1 = state_28354;
var statearr_28356_28389 = state_28354__$1;
(statearr_28356_28389[(2)] = inst_28301);

(statearr_28356_28389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (1))){
var state_28354__$1 = state_28354;
var statearr_28357_28390 = state_28354__$1;
(statearr_28357_28390[(2)] = null);

(statearr_28357_28390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (4))){
var inst_28300 = (state_28354[(2)]);
var state_28354__$1 = (function (){var statearr_28358 = state_28354;
(statearr_28358[(7)] = inst_28300);

return statearr_28358;
})();
var statearr_28359_28391 = state_28354__$1;
(statearr_28359_28391[(2)] = null);

(statearr_28359_28391[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (15))){
var inst_28338 = (state_28354[(8)]);
var inst_28342 = inst_28338.o;
var state_28354__$1 = state_28354;
var statearr_28360_28392 = state_28354__$1;
(statearr_28360_28392[(2)] = inst_28342);

(statearr_28360_28392[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (13))){
var inst_28338 = (state_28354[(8)]);
var inst_28334 = (state_28354[(2)]);
var inst_28335 = fluree.db.util.async.throw_err(inst_28334);
var inst_28336 = fluree.db.dbfunctions.internal.count(inst_28335);
var inst_28338__$1 = cljs.core.first(inst_28335);
var inst_28339 = (inst_28338__$1 == null);
var state_28354__$1 = (function (){var statearr_28361 = state_28354;
(statearr_28361[(9)] = inst_28336);

(statearr_28361[(8)] = inst_28338__$1);

return statearr_28361;
})();
if(cljs.core.truth_(inst_28339)){
var statearr_28362_28393 = state_28354__$1;
(statearr_28362_28393[(1)] = (14));

} else {
var statearr_28363_28394 = state_28354__$1;
(statearr_28363_28394[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (6))){
var inst_28310 = (state_28354[(2)]);
var state_28354__$1 = state_28354;
var statearr_28364_28395 = state_28354__$1;
(statearr_28364_28395[(2)] = inst_28310);

(statearr_28364_28395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (3))){
var inst_28352 = (state_28354[(2)]);
var state_28354__$1 = state_28354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28354__$1,inst_28352);
} else {
if((state_val_28355 === (12))){
var inst_28349 = (state_28354[(2)]);
var _ = (function (){var statearr_28365 = state_28354;
(statearr_28365[(4)] = cljs.core.rest((state_28354[(4)])));

return statearr_28365;
})();
var state_28354__$1 = state_28354;
var statearr_28366_28396 = state_28354__$1;
(statearr_28366_28396[(2)] = inst_28349);

(statearr_28366_28396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (2))){
var _ = (function (){var statearr_28368 = state_28354;
(statearr_28368[(4)] = cljs.core.cons((9),(state_28354[(4)])));

return statearr_28368;
})();
var inst_28316 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28317 = typeof inst_28316 === 'string';
var state_28354__$1 = state_28354;
if(cljs.core.truth_(inst_28317)){
var statearr_28369_28397 = state_28354__$1;
(statearr_28369_28397[(1)] = (10));

} else {
var statearr_28370_28398 = state_28354__$1;
(statearr_28370_28398[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (11))){
var inst_28323 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28324 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28323);
var inst_28325 = fluree.db.dbfunctions.internal.inc(inst_28324);
var inst_28326 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28323,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28325);
var inst_28327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28328 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28329 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28330 = [inst_28328,inst_28329];
var inst_28331 = (new cljs.core.PersistentVector(null,2,(5),inst_28327,inst_28330,null));
var inst_28332 = fluree.db.dbproto._search(inst_28326,inst_28331);
var state_28354__$1 = state_28354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28354__$1,(13),inst_28332);
} else {
if((state_val_28355 === (9))){
var _ = (function (){var statearr_28371 = state_28354;
(statearr_28371[(4)] = cljs.core.rest((state_28354[(4)])));

return statearr_28371;
})();
var state_28354__$1 = state_28354;
var ex28367 = (state_28354__$1[(2)]);
var statearr_28372_28399 = state_28354__$1;
(statearr_28372_28399[(5)] = ex28367);


var statearr_28373_28400 = state_28354__$1;
(statearr_28373_28400[(1)] = (4));

(statearr_28373_28400[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (5))){
var inst_28300 = (state_28354[(7)]);
var _ = (function (){var statearr_28374 = state_28354;
(statearr_28374[(4)] = cljs.core.cons((8),(state_28354[(4)])));

return statearr_28374;
})();
var inst_28307 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28300,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28375 = state_28354;
(statearr_28375[(4)] = cljs.core.rest((state_28354[(4)])));

return statearr_28375;
})();
var state_28354__$1 = state_28354;
var statearr_28376_28401 = state_28354__$1;
(statearr_28376_28401[(2)] = inst_28307);

(statearr_28376_28401[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (14))){
var state_28354__$1 = state_28354;
var statearr_28377_28402 = state_28354__$1;
(statearr_28377_28402[(2)] = null);

(statearr_28377_28402[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (16))){
var inst_28336 = (state_28354[(9)]);
var inst_28344 = (state_28354[(2)]);
var inst_28345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28346 = [inst_28344,inst_28336];
var inst_28347 = (new cljs.core.PersistentVector(null,2,(5),inst_28345,inst_28346,null));
var state_28354__$1 = state_28354;
var statearr_28379_28403 = state_28354__$1;
(statearr_28379_28403[(2)] = inst_28347);

(statearr_28379_28403[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (10))){
var inst_28319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28320 = [null,(0)];
var inst_28321 = (new cljs.core.PersistentVector(null,2,(5),inst_28319,inst_28320,null));
var state_28354__$1 = state_28354;
var statearr_28380_28404 = state_28354__$1;
(statearr_28380_28404[(2)] = inst_28321);

(statearr_28380_28404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28355 === (8))){
var _ = (function (){var statearr_28381 = state_28354;
(statearr_28381[(4)] = cljs.core.rest((state_28354[(4)])));

return statearr_28381;
})();
var state_28354__$1 = state_28354;
var ex28378 = (state_28354__$1[(2)]);
var statearr_28382_28405 = state_28354__$1;
(statearr_28382_28405[(5)] = ex28378);


var statearr_28383_28406 = state_28354__$1;
(statearr_28383_28406[(1)] = (7));

(statearr_28383_28406[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0 = (function (){
var statearr_28384 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28384[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__);

(statearr_28384[(1)] = (1));

return statearr_28384;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1 = (function (state_28354){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28354);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28385){var ex__2417__auto__ = e28385;
var statearr_28386_28407 = state_28354;
(statearr_28386_28407[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28354[(4)]))){
var statearr_28387_28408 = state_28354;
(statearr_28387_28408[(1)] = cljs.core.first((state_28354[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28409 = state_28354;
state_28354 = G__28409;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__ = function(state_28354){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1.call(this,state_28354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28388 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28388[(6)] = c__2436__auto__);

return statearr_28388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28461){
var state_val_28462 = (state_28461[(1)]);
if((state_val_28462 === (7))){
var inst_28411 = (state_28461[(2)]);
var state_28461__$1 = state_28461;
var statearr_28463_28492 = state_28461__$1;
(statearr_28463_28492[(2)] = inst_28411);

(statearr_28463_28492[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (1))){
var state_28461__$1 = state_28461;
var statearr_28464_28493 = state_28461__$1;
(statearr_28464_28493[(2)] = null);

(statearr_28464_28493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (4))){
var inst_28410 = (state_28461[(2)]);
var state_28461__$1 = (function (){var statearr_28465 = state_28461;
(statearr_28465[(7)] = inst_28410);

return statearr_28465;
})();
var statearr_28466_28494 = state_28461__$1;
(statearr_28466_28494[(2)] = null);

(statearr_28466_28494[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (13))){
var inst_28456 = (state_28461[(2)]);
var _ = (function (){var statearr_28467 = state_28461;
(statearr_28467[(4)] = cljs.core.rest((state_28461[(4)])));

return statearr_28467;
})();
var state_28461__$1 = state_28461;
var statearr_28468_28495 = state_28461__$1;
(statearr_28468_28495[(2)] = inst_28456);

(statearr_28468_28495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (6))){
var inst_28420 = (state_28461[(2)]);
var state_28461__$1 = state_28461;
var statearr_28469_28496 = state_28461__$1;
(statearr_28469_28496[(2)] = inst_28420);

(statearr_28469_28496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (3))){
var inst_28459 = (state_28461[(2)]);
var state_28461__$1 = state_28461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28461__$1,inst_28459);
} else {
if((state_val_28462 === (12))){
var inst_28443 = (state_28461[(8)]);
var inst_28452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28453 = [null,inst_28443];
var inst_28454 = (new cljs.core.PersistentVector(null,2,(5),inst_28452,inst_28453,null));
var state_28461__$1 = state_28461;
var statearr_28470_28497 = state_28461__$1;
(statearr_28470_28497[(2)] = inst_28454);

(statearr_28470_28497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (2))){
var _ = (function (){var statearr_28472 = state_28461;
(statearr_28472[(4)] = cljs.core.cons((9),(state_28461[(4)])));

return statearr_28472;
})();
var inst_28429 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28432 = [null,pred_name,"?o"];
var inst_28433 = (new cljs.core.PersistentVector(null,3,(5),inst_28431,inst_28432,null));
var inst_28434 = [inst_28433];
var inst_28435 = (new cljs.core.PersistentVector(null,1,(5),inst_28430,inst_28434,null));
var inst_28436 = ["?o",inst_28435,opts];
var inst_28437 = cljs.core.PersistentHashMap.fromArrays(inst_28429,inst_28436);
var inst_28438 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28437);
var state_28461__$1 = state_28461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28461__$1,(10),inst_28438);
} else {
if((state_val_28462 === (11))){
var inst_28443 = (state_28461[(8)]);
var inst_28442 = (state_28461[(9)]);
var inst_28447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28448 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28442);
var inst_28449 = [inst_28448,inst_28443];
var inst_28450 = (new cljs.core.PersistentVector(null,2,(5),inst_28447,inst_28449,null));
var state_28461__$1 = state_28461;
var statearr_28473_28498 = state_28461__$1;
(statearr_28473_28498[(2)] = inst_28450);

(statearr_28473_28498[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (9))){
var _ = (function (){var statearr_28474 = state_28461;
(statearr_28474[(4)] = cljs.core.rest((state_28461[(4)])));

return statearr_28474;
})();
var state_28461__$1 = state_28461;
var ex28471 = (state_28461__$1[(2)]);
var statearr_28475_28499 = state_28461__$1;
(statearr_28475_28499[(5)] = ex28471);


var statearr_28476_28500 = state_28461__$1;
(statearr_28476_28500[(1)] = (4));

(statearr_28476_28500[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (5))){
var inst_28410 = (state_28461[(7)]);
var _ = (function (){var statearr_28478 = state_28461;
(statearr_28478[(4)] = cljs.core.cons((8),(state_28461[(4)])));

return statearr_28478;
})();
var inst_28417 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28410,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28479 = state_28461;
(statearr_28479[(4)] = cljs.core.rest((state_28461[(4)])));

return statearr_28479;
})();
var state_28461__$1 = state_28461;
var statearr_28480_28501 = state_28461__$1;
(statearr_28480_28501[(2)] = inst_28417);

(statearr_28480_28501[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (10))){
var inst_28442 = (state_28461[(9)]);
var inst_28440 = (state_28461[(2)]);
var inst_28441 = fluree.db.util.async.throw_err(inst_28440);
var inst_28442__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28441,(0),null);
var inst_28443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28441,(1),null);
var inst_28444 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28442__$1);
var inst_28445 = cljs.core.not(inst_28444);
var state_28461__$1 = (function (){var statearr_28481 = state_28461;
(statearr_28481[(8)] = inst_28443);

(statearr_28481[(9)] = inst_28442__$1);

return statearr_28481;
})();
if(inst_28445){
var statearr_28482_28502 = state_28461__$1;
(statearr_28482_28502[(1)] = (11));

} else {
var statearr_28483_28503 = state_28461__$1;
(statearr_28483_28503[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28462 === (8))){
var _ = (function (){var statearr_28484 = state_28461;
(statearr_28484[(4)] = cljs.core.rest((state_28461[(4)])));

return statearr_28484;
})();
var state_28461__$1 = state_28461;
var ex28477 = (state_28461__$1[(2)]);
var statearr_28485_28504 = state_28461__$1;
(statearr_28485_28504[(5)] = ex28477);


var statearr_28486_28505 = state_28461__$1;
(statearr_28486_28505[(1)] = (7));

(statearr_28486_28505[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0 = (function (){
var statearr_28487 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28487[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__);

(statearr_28487[(1)] = (1));

return statearr_28487;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1 = (function (state_28461){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28461);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28488){var ex__2417__auto__ = e28488;
var statearr_28489_28506 = state_28461;
(statearr_28489_28506[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28461[(4)]))){
var statearr_28490_28507 = state_28461;
(statearr_28490_28507[(1)] = cljs.core.first((state_28461[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28508 = state_28461;
state_28461 = G__28508;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__ = function(state_28461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1.call(this,state_28461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28491 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28491[(6)] = c__2436__auto__);

return statearr_28491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e28509){var e = e28509;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28511 = arguments.length;
switch (G__28511) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28581){
var state_val_28582 = (state_28581[(1)]);
if((state_val_28582 === (7))){
var inst_28513 = (state_28581[(2)]);
var state_28581__$1 = state_28581;
var statearr_28583_28627 = state_28581__$1;
(statearr_28583_28627[(2)] = inst_28513);

(statearr_28583_28627[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (20))){
var inst_28557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28558 = ["*"];
var inst_28559 = (new cljs.core.PersistentVector(null,1,(5),inst_28557,inst_28558,null));
var state_28581__$1 = state_28581;
var statearr_28584_28628 = state_28581__$1;
(statearr_28584_28628[(2)] = inst_28559);

(statearr_28584_28628[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (1))){
var state_28581__$1 = state_28581;
var statearr_28585_28629 = state_28581__$1;
(statearr_28585_28629[(2)] = null);

(statearr_28585_28629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (4))){
var inst_28512 = (state_28581[(2)]);
var state_28581__$1 = (function (){var statearr_28586 = state_28581;
(statearr_28586[(7)] = inst_28512);

return statearr_28586;
})();
var statearr_28587_28630 = state_28581__$1;
(statearr_28587_28630[(2)] = null);

(statearr_28587_28630[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (15))){
var inst_28576 = (state_28581[(2)]);
var _ = (function (){var statearr_28588 = state_28581;
(statearr_28588[(4)] = cljs.core.rest((state_28581[(4)])));

return statearr_28588;
})();
var state_28581__$1 = state_28581;
var statearr_28589_28631 = state_28581__$1;
(statearr_28589_28631[(2)] = inst_28576);

(statearr_28589_28631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (21))){
var inst_28547 = (state_28581[(8)]);
var inst_28540 = (state_28581[(9)]);
var inst_28561 = (state_28581[(2)]);
var inst_28562 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28563 = cljs.core.PersistentHashMap.EMPTY;
var inst_28564 = [inst_28561,inst_28547,inst_28563];
var inst_28565 = cljs.core.PersistentHashMap.fromArrays(inst_28562,inst_28564);
var inst_28566 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28540,inst_28565);
var state_28581__$1 = state_28581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28581__$1,(22),inst_28566);
} else {
if((state_val_28582 === (13))){
var inst_28535 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28581__$1 = state_28581;
var statearr_28590_28632 = state_28581__$1;
(statearr_28590_28632[(2)] = inst_28535);

(statearr_28590_28632[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (22))){
var inst_28568 = (state_28581[(2)]);
var inst_28569 = fluree.db.util.async.throw_err(inst_28568);
var inst_28570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28569,(0),null);
var inst_28571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28569,(1),null);
var inst_28572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28573 = [inst_28570,inst_28571];
var inst_28574 = (new cljs.core.PersistentVector(null,2,(5),inst_28572,inst_28573,null));
var state_28581__$1 = state_28581;
var statearr_28591_28633 = state_28581__$1;
(statearr_28591_28633[(2)] = inst_28574);

(statearr_28591_28633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (6))){
var inst_28522 = (state_28581[(2)]);
var state_28581__$1 = state_28581;
var statearr_28592_28634 = state_28581__$1;
(statearr_28592_28634[(2)] = inst_28522);

(statearr_28592_28634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (17))){
var inst_28544 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28545 = fluree.db.dbfunctions.internal.get(inst_28544,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28581__$1 = state_28581;
var statearr_28593_28635 = state_28581__$1;
(statearr_28593_28635[(2)] = inst_28545);

(statearr_28593_28635[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (3))){
var inst_28579 = (state_28581[(2)]);
var state_28581__$1 = state_28581;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28581__$1,inst_28579);
} else {
if((state_val_28582 === (12))){
var inst_28533 = (state_28581[(2)]);
var state_28581__$1 = state_28581;
if(cljs.core.truth_(inst_28533)){
var statearr_28594_28636 = state_28581__$1;
(statearr_28594_28636[(1)] = (13));

} else {
var statearr_28595_28637 = state_28581__$1;
(statearr_28595_28637[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (2))){
var inst_28528 = (state_28581[(10)]);
var _ = (function (){var statearr_28596 = state_28581;
(statearr_28596[(4)] = cljs.core.cons((9),(state_28581[(4)])));

return statearr_28596;
})();
var inst_28528__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28581__$1 = (function (){var statearr_28597 = state_28581;
(statearr_28597[(10)] = inst_28528__$1);

return statearr_28597;
})();
if(cljs.core.truth_(inst_28528__$1)){
var statearr_28598_28638 = state_28581__$1;
(statearr_28598_28638[(1)] = (10));

} else {
var statearr_28599_28639 = state_28581__$1;
(statearr_28599_28639[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (19))){
var inst_28549 = cljs.core.PersistentVector.EMPTY;
var inst_28550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28551 = ["*"];
var inst_28552 = (new cljs.core.PersistentVector(null,1,(5),inst_28550,inst_28551,null));
var inst_28553 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28554 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28552,inst_28553);
var inst_28555 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28549,inst_28554);
var state_28581__$1 = state_28581;
var statearr_28601_28640 = state_28581__$1;
(statearr_28601_28640[(2)] = inst_28555);

(statearr_28601_28640[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (11))){
var inst_28528 = (state_28581[(10)]);
var state_28581__$1 = state_28581;
var statearr_28602_28641 = state_28581__$1;
(statearr_28602_28641[(2)] = inst_28528);

(statearr_28602_28641[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (9))){
var _ = (function (){var statearr_28603 = state_28581;
(statearr_28603[(4)] = cljs.core.rest((state_28581[(4)])));

return statearr_28603;
})();
var state_28581__$1 = state_28581;
var ex28600 = (state_28581__$1[(2)]);
var statearr_28604_28642 = state_28581__$1;
(statearr_28604_28642[(5)] = ex28600);


var statearr_28605_28643 = state_28581__$1;
(statearr_28605_28643[(1)] = (4));

(statearr_28605_28643[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (5))){
var inst_28512 = (state_28581[(7)]);
var _ = (function (){var statearr_28606 = state_28581;
(statearr_28606[(4)] = cljs.core.cons((8),(state_28581[(4)])));

return statearr_28606;
})();
var inst_28519 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28512,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_28607 = state_28581;
(statearr_28607[(4)] = cljs.core.rest((state_28581[(4)])));

return statearr_28607;
})();
var state_28581__$1 = state_28581;
var statearr_28608_28644 = state_28581__$1;
(statearr_28608_28644[(2)] = inst_28519);

(statearr_28608_28644[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (14))){
var inst_28541 = (state_28581[(11)]);
var inst_28540 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28541__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28581__$1 = (function (){var statearr_28609 = state_28581;
(statearr_28609[(9)] = inst_28540);

(statearr_28609[(11)] = inst_28541__$1);

return statearr_28609;
})();
if(cljs.core.truth_(inst_28541__$1)){
var statearr_28610_28645 = state_28581__$1;
(statearr_28610_28645[(1)] = (16));

} else {
var statearr_28611_28646 = state_28581__$1;
(statearr_28611_28646[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (16))){
var inst_28541 = (state_28581[(11)]);
var state_28581__$1 = state_28581;
var statearr_28612_28647 = state_28581__$1;
(statearr_28612_28647[(2)] = inst_28541);

(statearr_28612_28647[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (10))){
var inst_28530 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_28581__$1 = state_28581;
var statearr_28614_28648 = state_28581__$1;
(statearr_28614_28648[(2)] = inst_28530);

(statearr_28614_28648[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (18))){
var inst_28547 = (state_28581[(2)]);
var state_28581__$1 = (function (){var statearr_28615 = state_28581;
(statearr_28615[(8)] = inst_28547);

return statearr_28615;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28616_28649 = state_28581__$1;
(statearr_28616_28649[(1)] = (19));

} else {
var statearr_28617_28650 = state_28581__$1;
(statearr_28617_28650[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28582 === (8))){
var _ = (function (){var statearr_28618 = state_28581;
(statearr_28618[(4)] = cljs.core.rest((state_28581[(4)])));

return statearr_28618;
})();
var state_28581__$1 = state_28581;
var ex28613 = (state_28581__$1[(2)]);
var statearr_28619_28651 = state_28581__$1;
(statearr_28619_28651[(5)] = ex28613);


var statearr_28620_28652 = state_28581__$1;
(statearr_28620_28652[(1)] = (7));

(statearr_28620_28652[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28621 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28621[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28621[(1)] = (1));

return statearr_28621;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28581){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28581);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28622){var ex__2417__auto__ = e28622;
var statearr_28623_28653 = state_28581;
(statearr_28623_28653[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28581[(4)]))){
var statearr_28624_28654 = state_28581;
(statearr_28624_28654[(1)] = cljs.core.first((state_28581[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28655 = state_28581;
state_28581 = G__28655;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28581){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28625 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28625[(6)] = c__2436__auto__);

return statearr_28625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28657 = arguments.length;
switch (G__28657) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28701){
var state_val_28702 = (state_28701[(1)]);
if((state_val_28702 === (7))){
var inst_28679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28680 = ["*"];
var inst_28681 = (new cljs.core.PersistentVector(null,1,(5),inst_28679,inst_28680,null));
var state_28701__$1 = state_28701;
var statearr_28703_28723 = state_28701__$1;
(statearr_28703_28723[(2)] = inst_28681);

(statearr_28703_28723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (1))){
var state_28701__$1 = state_28701;
var statearr_28704_28724 = state_28701__$1;
(statearr_28704_28724[(2)] = null);

(statearr_28704_28724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (4))){
var inst_28658 = (state_28701[(2)]);
var inst_28659 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28658,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_28701__$1 = state_28701;
var statearr_28705_28725 = state_28701__$1;
(statearr_28705_28725[(2)] = inst_28659);

(statearr_28705_28725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (6))){
var inst_28671 = cljs.core.PersistentVector.EMPTY;
var inst_28672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28673 = ["*"];
var inst_28674 = (new cljs.core.PersistentVector(null,1,(5),inst_28672,inst_28673,null));
var inst_28675 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28676 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28674,inst_28675);
var inst_28677 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28671,inst_28676);
var state_28701__$1 = state_28701;
var statearr_28706_28726 = state_28701__$1;
(statearr_28706_28726[(2)] = inst_28677);

(statearr_28706_28726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (3))){
var inst_28699 = (state_28701[(2)]);
var state_28701__$1 = state_28701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28701__$1,inst_28699);
} else {
if((state_val_28702 === (2))){
var _ = (function (){var statearr_28708 = state_28701;
(statearr_28708[(4)] = cljs.core.cons((5),(state_28701[(4)])));

return statearr_28708;
})();
var inst_28668 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28669 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28701__$1 = (function (){var statearr_28709 = state_28701;
(statearr_28709[(7)] = inst_28668);

(statearr_28709[(8)] = inst_28669);

return statearr_28709;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28710_28727 = state_28701__$1;
(statearr_28710_28727[(1)] = (6));

} else {
var statearr_28711_28728 = state_28701__$1;
(statearr_28711_28728[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (9))){
var inst_28690 = (state_28701[(2)]);
var inst_28691 = fluree.db.util.async.throw_err(inst_28690);
var inst_28692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28691,(0),null);
var inst_28693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28691,(1),null);
var inst_28694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28695 = [inst_28692,inst_28693];
var inst_28696 = (new cljs.core.PersistentVector(null,2,(5),inst_28694,inst_28695,null));
var _ = (function (){var statearr_28712 = state_28701;
(statearr_28712[(4)] = cljs.core.rest((state_28701[(4)])));

return statearr_28712;
})();
var state_28701__$1 = state_28701;
var statearr_28713_28729 = state_28701__$1;
(statearr_28713_28729[(2)] = inst_28696);

(statearr_28713_28729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (5))){
var _ = (function (){var statearr_28714 = state_28701;
(statearr_28714[(4)] = cljs.core.rest((state_28701[(4)])));

return statearr_28714;
})();
var state_28701__$1 = state_28701;
var ex28707 = (state_28701__$1[(2)]);
var statearr_28715_28730 = state_28701__$1;
(statearr_28715_28730[(5)] = ex28707);


var statearr_28716_28731 = state_28701__$1;
(statearr_28716_28731[(1)] = (4));

(statearr_28716_28731[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28702 === (8))){
var inst_28668 = (state_28701[(7)]);
var inst_28669 = (state_28701[(8)]);
var inst_28683 = (state_28701[(2)]);
var inst_28684 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28685 = cljs.core.PersistentHashMap.EMPTY;
var inst_28686 = [inst_28683,inst_28669,inst_28685];
var inst_28687 = cljs.core.PersistentHashMap.fromArrays(inst_28684,inst_28686);
var inst_28688 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28668,inst_28687);
var state_28701__$1 = state_28701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28701__$1,(9),inst_28688);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2414__auto____0 = (function (){
var statearr_28717 = [null,null,null,null,null,null,null,null,null];
(statearr_28717[(0)] = fluree$db$dbfunctions$internal$state_machine__2414__auto__);

(statearr_28717[(1)] = (1));

return statearr_28717;
});
var fluree$db$dbfunctions$internal$state_machine__2414__auto____1 = (function (state_28701){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28701);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28718){var ex__2417__auto__ = e28718;
var statearr_28719_28732 = state_28701;
(statearr_28719_28732[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28701[(4)]))){
var statearr_28720_28733 = state_28701;
(statearr_28720_28733[(1)] = cljs.core.first((state_28701[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28734 = state_28701;
state_28701 = G__28734;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2414__auto__ = function(state_28701){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2414__auto____1.call(this,state_28701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28721 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28721[(6)] = c__2436__auto__);

return statearr_28721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28778){
var state_val_28779 = (state_28778[(1)]);
if((state_val_28779 === (1))){
var state_28778__$1 = state_28778;
var statearr_28780_28794 = state_28778__$1;
(statearr_28780_28794[(2)] = null);

(statearr_28780_28794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28779 === (2))){
var _ = (function (){var statearr_28781 = state_28778;
(statearr_28781[(4)] = cljs.core.cons((5),(state_28778[(4)])));

return statearr_28781;
})();
var inst_28745 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28747 = ["_user/_auth"];
var inst_28748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28749 = ["*"];
var inst_28750 = (new cljs.core.PersistentVector(null,1,(5),inst_28748,inst_28749,null));
var inst_28751 = [inst_28750];
var inst_28752 = cljs.core.PersistentHashMap.fromArrays(inst_28747,inst_28751);
var inst_28753 = [inst_28752];
var inst_28754 = (new cljs.core.PersistentVector(null,1,(5),inst_28746,inst_28753,null));
var inst_28755 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28756 = cljs.core.PersistentHashMap.EMPTY;
var inst_28757 = [inst_28754,inst_28755,inst_28756];
var inst_28758 = cljs.core.PersistentHashMap.fromArrays(inst_28745,inst_28757);
var inst_28759 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28760 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28759,inst_28758);
var state_28778__$1 = state_28778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28778__$1,(6),inst_28760);
} else {
if((state_val_28779 === (3))){
var inst_28776 = (state_28778[(2)]);
var state_28778__$1 = state_28778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28778__$1,inst_28776);
} else {
if((state_val_28779 === (4))){
var inst_28735 = (state_28778[(2)]);
var inst_28736 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28735,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_28778__$1 = state_28778;
var statearr_28783_28795 = state_28778__$1;
(statearr_28783_28795[(2)] = inst_28736);

(statearr_28783_28795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28779 === (5))){
var _ = (function (){var statearr_28784 = state_28778;
(statearr_28784[(4)] = cljs.core.rest((state_28778[(4)])));

return statearr_28784;
})();
var state_28778__$1 = state_28778;
var ex28782 = (state_28778__$1[(2)]);
var statearr_28785_28796 = state_28778__$1;
(statearr_28785_28796[(5)] = ex28782);


var statearr_28786_28797 = state_28778__$1;
(statearr_28786_28797[(1)] = (4));

(statearr_28786_28797[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28779 === (6))){
var inst_28762 = (state_28778[(2)]);
var inst_28763 = fluree.db.util.async.throw_err(inst_28762);
var inst_28764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28763,(0),null);
var inst_28765 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28763,(1),null);
var inst_28766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28767 = ["_user/_auth","_id"];
var inst_28768 = (new cljs.core.PersistentVector(null,2,(5),inst_28766,inst_28767,null));
var inst_28769 = fluree.db.dbfunctions.internal.get_in(inst_28764,inst_28768);
var inst_28770 = cljs.core.first(inst_28769);
var inst_28771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28772 = [inst_28770,inst_28765];
var inst_28773 = (new cljs.core.PersistentVector(null,2,(5),inst_28771,inst_28772,null));
var _ = (function (){var statearr_28787 = state_28778;
(statearr_28787[(4)] = cljs.core.rest((state_28778[(4)])));

return statearr_28787;
})();
var state_28778__$1 = state_28778;
var statearr_28788_28798 = state_28778__$1;
(statearr_28788_28798[(2)] = inst_28773);

(statearr_28788_28798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0 = (function (){
var statearr_28789 = [null,null,null,null,null,null,null];
(statearr_28789[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__);

(statearr_28789[(1)] = (1));

return statearr_28789;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1 = (function (state_28778){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28778);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28790){var ex__2417__auto__ = e28790;
var statearr_28791_28799 = state_28778;
(statearr_28791_28799[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28778[(4)]))){
var statearr_28792_28800 = state_28778;
(statearr_28792_28800[(1)] = cljs.core.first((state_28778[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28801 = state_28778;
state_28778 = G__28801;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__ = function(state_28778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1.call(this,state_28778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28793 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28793[(6)] = c__2436__auto__);

return statearr_28793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28818){
var state_val_28819 = (state_28818[(1)]);
if((state_val_28819 === (1))){
var state_28818__$1 = state_28818;
var statearr_28820_28834 = state_28818__$1;
(statearr_28820_28834[(2)] = null);

(statearr_28820_28834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (2))){
var _ = (function (){var statearr_28821 = state_28818;
(statearr_28821[(4)] = cljs.core.cons((5),(state_28818[(4)])));

return statearr_28821;
})();
var inst_28808 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28809 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28810 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_28809,inst_28808);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28818__$1,(6),inst_28810);
} else {
if((state_val_28819 === (3))){
var inst_28816 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28818__$1,inst_28816);
} else {
if((state_val_28819 === (4))){
var inst_28802 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
var statearr_28823_28835 = state_28818__$1;
(statearr_28823_28835[(2)] = inst_28802);

(statearr_28823_28835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (5))){
var _ = (function (){var statearr_28824 = state_28818;
(statearr_28824[(4)] = cljs.core.rest((state_28818[(4)])));

return statearr_28824;
})();
var state_28818__$1 = state_28818;
var ex28822 = (state_28818__$1[(2)]);
var statearr_28825_28836 = state_28818__$1;
(statearr_28825_28836[(5)] = ex28822);


if((ex28822 instanceof Error)){
var statearr_28826_28837 = state_28818__$1;
(statearr_28826_28837[(1)] = (4));

(statearr_28826_28837[(5)] = null);

} else {
throw ex28822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (6))){
var inst_28812 = (state_28818[(2)]);
var inst_28813 = fluree.db.util.async.throw_err(inst_28812);
var _ = (function (){var statearr_28827 = state_28818;
(statearr_28827[(4)] = cljs.core.rest((state_28818[(4)])));

return statearr_28827;
})();
var state_28818__$1 = state_28818;
var statearr_28828_28838 = state_28818__$1;
(statearr_28828_28838[(2)] = inst_28813);

(statearr_28828_28838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0 = (function (){
var statearr_28829 = [null,null,null,null,null,null,null];
(statearr_28829[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__);

(statearr_28829[(1)] = (1));

return statearr_28829;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1 = (function (state_28818){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28818);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28830){var ex__2417__auto__ = e28830;
var statearr_28831_28839 = state_28818;
(statearr_28831_28839[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28818[(4)]))){
var statearr_28832_28840 = state_28818;
(statearr_28832_28840[(1)] = cljs.core.first((state_28818[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28841 = state_28818;
state_28818 = G__28841;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__ = function(state_28818){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1.call(this,state_28818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28833 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28833[(6)] = c__2436__auto__);

return statearr_28833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__28842_SHARP_){
return p1__28842_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28843_SHARP_){
return p1__28843_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e28844){var e = e28844;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__28845_SHARP_){
return p1__28845_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28846_SHARP_){
return p1__28846_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e28847){var e = e28847;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__28849 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__28849);
})() | (0));
return num;
}catch (e28848){var e = e28848;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_28949){
var state_val_28950 = (state_28949[(1)]);
if((state_val_28950 === (7))){
var state_28949__$1 = state_28949;
var statearr_28951_28999 = state_28949__$1;
(statearr_28951_28999[(2)] = false);

(statearr_28951_28999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (20))){
var inst_28883 = (state_28949[(7)]);
var inst_28884 = (state_28949[(8)]);
var inst_28905 = (state_28949[(2)]);
var inst_28906 = fluree.db.dbproto._p_prop(inst_28884,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28883);
var state_28949__$1 = (function (){var statearr_28952 = state_28949;
(statearr_28952[(9)] = inst_28905);

return statearr_28952;
})();
if(cljs.core.truth_(inst_28906)){
var statearr_28953_29000 = state_28949__$1;
(statearr_28953_29000[(1)] = (21));

} else {
var statearr_28954_29001 = state_28949__$1;
(statearr_28954_29001[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (27))){
var inst_28944 = (state_28949[(2)]);
var _ = (function (){var statearr_28955 = state_28949;
(statearr_28955[(4)] = cljs.core.rest((state_28949[(4)])));

return statearr_28955;
})();
var state_28949__$1 = state_28949;
var statearr_28956_29002 = state_28949__$1;
(statearr_28956_29002[(2)] = inst_28944);

(statearr_28956_29002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (1))){
var state_28949__$1 = state_28949;
var statearr_28957_29003 = state_28949__$1;
(statearr_28957_29003[(2)] = null);

(statearr_28957_29003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (24))){
var inst_28933 = (state_28949[(10)]);
var inst_28929 = (state_28949[(2)]);
var inst_28930 = fluree.db.util.async.throw_err(inst_28929);
var inst_28931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28930,(0),null);
var inst_28932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28930,(1),null);
var inst_28933__$1 = cljs.core.first(inst_28931);
var inst_28934 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28933__$1,compare_val);
var state_28949__$1 = (function (){var statearr_28958 = state_28949;
(statearr_28958[(11)] = inst_28932);

(statearr_28958[(10)] = inst_28933__$1);

return statearr_28958;
})();
if(inst_28934){
var statearr_28959_29004 = state_28949__$1;
(statearr_28959_29004[(1)] = (25));

} else {
var statearr_28960_29005 = state_28949__$1;
(statearr_28960_29005[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (4))){
var inst_28850 = (state_28949[(2)]);
var state_28949__$1 = state_28949;
var statearr_28961_29006 = state_28949__$1;
(statearr_28961_29006[(2)] = inst_28850);

(statearr_28961_29006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (15))){
var state_28949__$1 = state_28949;
var statearr_28962_29007 = state_28949__$1;
(statearr_28962_29007[(2)] = null);

(statearr_28962_29007[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (21))){
var inst_28885 = (state_28949[(12)]);
var inst_28908 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_28885], 0));
var inst_28909 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28910 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28911 = cljs.core.PersistentHashMap.fromArrays(inst_28909,inst_28910);
var inst_28912 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28908,inst_28911);
var inst_28913 = (function(){throw inst_28912})();
var state_28949__$1 = state_28949;
var statearr_28963_29008 = state_28949__$1;
(statearr_28963_29008[(2)] = inst_28913);

(statearr_28963_29008[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (13))){
var inst_28860 = (state_28949[(13)]);
var state_28949__$1 = state_28949;
var statearr_28964_29009 = state_28949__$1;
(statearr_28964_29009[(2)] = inst_28860);

(statearr_28964_29009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (22))){
var state_28949__$1 = state_28949;
var statearr_28965_29010 = state_28949__$1;
(statearr_28965_29010[(2)] = null);

(statearr_28965_29010[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (6))){
var inst_28860 = (state_28949[(13)]);
var inst_28865 = inst_28860.cljs$lang$protocol_mask$partition0$;
var inst_28866 = (inst_28865 & (64));
var inst_28867 = inst_28860.cljs$core$ISeq$;
var inst_28868 = (cljs.core.PROTOCOL_SENTINEL === inst_28867);
var inst_28869 = ((inst_28866) || (inst_28868));
var state_28949__$1 = state_28949;
if(cljs.core.truth_(inst_28869)){
var statearr_28966_29011 = state_28949__$1;
(statearr_28966_29011[(1)] = (9));

} else {
var statearr_28967_29012 = state_28949__$1;
(statearr_28967_29012[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (25))){
var state_28949__$1 = state_28949;
var statearr_28968_29013 = state_28949__$1;
(statearr_28968_29013[(2)] = new_val);

(statearr_28968_29013[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (17))){
var inst_28885 = (state_28949[(12)]);
var inst_28895 = (state_28949[(2)]);
var state_28949__$1 = (function (){var statearr_28969 = state_28949;
(statearr_28969[(14)] = inst_28895);

return statearr_28969;
})();
if(cljs.core.truth_(inst_28885)){
var statearr_28970_29014 = state_28949__$1;
(statearr_28970_29014[(1)] = (18));

} else {
var statearr_28971_29015 = state_28949__$1;
(statearr_28971_29015[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (3))){
var inst_28947 = (state_28949[(2)]);
var state_28949__$1 = state_28949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28949__$1,inst_28947);
} else {
if((state_val_28950 === (12))){
var inst_28860 = (state_28949[(13)]);
var inst_28878 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28860);
var state_28949__$1 = state_28949;
var statearr_28972_29016 = state_28949__$1;
(statearr_28972_29016[(2)] = inst_28878);

(statearr_28972_29016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (2))){
var inst_28860 = (state_28949[(13)]);
var _ = (function (){var statearr_28973 = state_28949;
(statearr_28973[(4)] = cljs.core.cons((5),(state_28949[(4)])));

return statearr_28973;
})();
var inst_28860__$1 = _QMARK_ctx;
var inst_28862 = (inst_28860__$1 == null);
var inst_28863 = cljs.core.not(inst_28862);
var state_28949__$1 = (function (){var statearr_28974 = state_28949;
(statearr_28974[(13)] = inst_28860__$1);

return statearr_28974;
})();
if(inst_28863){
var statearr_28975_29017 = state_28949__$1;
(statearr_28975_29017[(1)] = (6));

} else {
var statearr_28976_29018 = state_28949__$1;
(statearr_28976_29018[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (23))){
var inst_28885 = (state_28949[(12)]);
var inst_28884 = (state_28949[(8)]);
var inst_28882 = (state_28949[(15)]);
var inst_28916 = (state_28949[(2)]);
var inst_28917 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28920 = [inst_28882,inst_28885,"?current-val"];
var inst_28921 = (new cljs.core.PersistentVector(null,3,(5),inst_28919,inst_28920,null));
var inst_28922 = [inst_28921];
var inst_28923 = (new cljs.core.PersistentVector(null,1,(5),inst_28918,inst_28922,null));
var inst_28924 = cljs.core.PersistentHashMap.EMPTY;
var inst_28925 = ["?current-val",inst_28923,inst_28924];
var inst_28926 = cljs.core.PersistentHashMap.fromArrays(inst_28917,inst_28925);
var inst_28927 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28884,inst_28926);
var state_28949__$1 = (function (){var statearr_28977 = state_28949;
(statearr_28977[(16)] = inst_28916);

return statearr_28977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28949__$1,(24),inst_28927);
} else {
if((state_val_28950 === (19))){
var inst_28898 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_28899 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28900 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28901 = cljs.core.PersistentHashMap.fromArrays(inst_28899,inst_28900);
var inst_28902 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28898,inst_28901);
var inst_28903 = (function(){throw inst_28902})();
var state_28949__$1 = state_28949;
var statearr_28978_29019 = state_28949__$1;
(statearr_28978_29019[(2)] = inst_28903);

(statearr_28978_29019[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (11))){
var inst_28873 = (state_28949[(2)]);
var state_28949__$1 = state_28949;
var statearr_28980_29020 = state_28949__$1;
(statearr_28980_29020[(2)] = inst_28873);

(statearr_28980_29020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (9))){
var state_28949__$1 = state_28949;
var statearr_28981_29021 = state_28949__$1;
(statearr_28981_29021[(2)] = true);

(statearr_28981_29021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (5))){
var _ = (function (){var statearr_28982 = state_28949;
(statearr_28982[(4)] = cljs.core.rest((state_28949[(4)])));

return statearr_28982;
})();
var state_28949__$1 = state_28949;
var ex28979 = (state_28949__$1[(2)]);
var statearr_28983_29022 = state_28949__$1;
(statearr_28983_29022[(5)] = ex28979);


if((ex28979 instanceof Error)){
var statearr_28984_29023 = state_28949__$1;
(statearr_28984_29023[(1)] = (4));

(statearr_28984_29023[(5)] = null);

} else {
throw ex28979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (14))){
var inst_28883 = (state_28949[(7)]);
var inst_28884 = (state_28949[(8)]);
var inst_28882 = (state_28949[(15)]);
var inst_28881 = (state_28949[(2)]);
var inst_28882__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28881,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_28883__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28881,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_28884__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28881,new cljs.core.Keyword(null,"db","db",993250759));
var inst_28885 = fluree.db.dbproto._p_prop(inst_28884__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_28883__$1);
var state_28949__$1 = (function (){var statearr_28985 = state_28949;
(statearr_28985[(12)] = inst_28885);

(statearr_28985[(7)] = inst_28883__$1);

(statearr_28985[(8)] = inst_28884__$1);

(statearr_28985[(15)] = inst_28882__$1);

return statearr_28985;
})();
if(cljs.core.truth_(inst_28882__$1)){
var statearr_28986_29024 = state_28949__$1;
(statearr_28986_29024[(1)] = (15));

} else {
var statearr_28987_29025 = state_28949__$1;
(statearr_28987_29025[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (26))){
var inst_28933 = (state_28949[(10)]);
var inst_28937 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28933)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_28938 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28939 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28940 = cljs.core.PersistentHashMap.fromArrays(inst_28938,inst_28939);
var inst_28941 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28937,inst_28940);
var inst_28942 = (function(){throw inst_28941})();
var state_28949__$1 = state_28949;
var statearr_28988_29026 = state_28949__$1;
(statearr_28988_29026[(2)] = inst_28942);

(statearr_28988_29026[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (16))){
var inst_28888 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_28889 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28890 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28891 = cljs.core.PersistentHashMap.fromArrays(inst_28889,inst_28890);
var inst_28892 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28888,inst_28891);
var inst_28893 = (function(){throw inst_28892})();
var state_28949__$1 = state_28949;
var statearr_28989_29027 = state_28949__$1;
(statearr_28989_29027[(2)] = inst_28893);

(statearr_28989_29027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (10))){
var state_28949__$1 = state_28949;
var statearr_28990_29028 = state_28949__$1;
(statearr_28990_29028[(2)] = false);

(statearr_28990_29028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (18))){
var state_28949__$1 = state_28949;
var statearr_28991_29029 = state_28949__$1;
(statearr_28991_29029[(2)] = null);

(statearr_28991_29029[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28950 === (8))){
var inst_28876 = (state_28949[(2)]);
var state_28949__$1 = state_28949;
if(cljs.core.truth_(inst_28876)){
var statearr_28992_29030 = state_28949__$1;
(statearr_28992_29030[(1)] = (12));

} else {
var statearr_28993_29031 = state_28949__$1;
(statearr_28993_29031[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____0 = (function (){
var statearr_28994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28994[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__);

(statearr_28994[(1)] = (1));

return statearr_28994;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____1 = (function (state_28949){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_28949);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e28995){var ex__2417__auto__ = e28995;
var statearr_28996_29032 = state_28949;
(statearr_28996_29032[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_28949[(4)]))){
var statearr_28997_29033 = state_28949;
(statearr_28997_29033[(1)] = cljs.core.first((state_28949[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29034 = state_28949;
state_28949 = G__29034;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__ = function(state_28949){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____1.call(this,state_28949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_28998 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_28998[(6)] = c__2436__auto__);

return statearr_28998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
