// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__21313 = arguments.length;
switch (G__21313) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__21316 = arguments.length;
switch (G__21316) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2436__auto___21369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21347){
var state_val_21348 = (state_21347[(1)]);
if((state_val_21348 === (1))){
var state_21347__$1 = state_21347;
var statearr_21349_21370 = state_21347__$1;
(statearr_21349_21370[(2)] = null);

(statearr_21349_21370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (2))){
var _ = (function (){var statearr_21350 = state_21347;
(statearr_21350[(4)] = cljs.core.cons((5),(state_21347[(4)])));

return statearr_21350;
})();
var inst_21324 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_21347__$1 = state_21347;
if(cljs.core.truth_(inst_21324)){
var statearr_21351_21371 = state_21347__$1;
(statearr_21351_21371[(1)] = (6));

} else {
var statearr_21352_21372 = state_21347__$1;
(statearr_21352_21372[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (3))){
var inst_21345 = (state_21347[(2)]);
var state_21347__$1 = state_21347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21347__$1,inst_21345);
} else {
if((state_val_21348 === (4))){
var inst_21317 = (state_21347[(2)]);
var inst_21318 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_21317);
var state_21347__$1 = state_21347;
var statearr_21354_21373 = state_21347__$1;
(statearr_21354_21373[(2)] = inst_21318);

(statearr_21354_21373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (5))){
var _ = (function (){var statearr_21355 = state_21347;
(statearr_21355[(4)] = cljs.core.rest((state_21347[(4)])));

return statearr_21355;
})();
var state_21347__$1 = state_21347;
var ex21353 = (state_21347__$1[(2)]);
var statearr_21356_21374 = state_21347__$1;
(statearr_21356_21374[(5)] = ex21353);


var statearr_21357_21375 = state_21347__$1;
(statearr_21357_21375[(1)] = (4));

(statearr_21357_21375[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (6))){
var inst_21326 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21327 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_21328 = cljs.core.PersistentHashMap.fromArrays(inst_21326,inst_21327);
var inst_21329 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_21328);
var inst_21330 = (function(){throw inst_21329})();
var state_21347__$1 = state_21347;
var statearr_21358_21376 = state_21347__$1;
(statearr_21358_21376[(2)] = inst_21330);

(statearr_21358_21376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (7))){
var inst_21332 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21334 = [operation,data,pc,opts];
var inst_21335 = (new cljs.core.PersistentVector(null,4,(5),inst_21333,inst_21334,null));
var inst_21336 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_21332,inst_21335);
var inst_21337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21338 = [operation,data,pc,opts];
var inst_21339 = (new cljs.core.PersistentVector(null,4,(5),inst_21337,inst_21338,null));
var inst_21340 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_21339], 0));
var state_21347__$1 = (function (){var statearr_21359 = state_21347;
(statearr_21359[(7)] = inst_21336);

return statearr_21359;
})();
var statearr_21360_21377 = state_21347__$1;
(statearr_21360_21377[(2)] = inst_21340);

(statearr_21360_21377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21348 === (8))){
var inst_21342 = (state_21347[(2)]);
var _ = (function (){var statearr_21361 = state_21347;
(statearr_21361[(4)] = cljs.core.rest((state_21347[(4)])));

return statearr_21361;
})();
var state_21347__$1 = state_21347;
var statearr_21362_21378 = state_21347__$1;
(statearr_21362_21378[(2)] = inst_21342);

(statearr_21362_21378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2414__auto__ = null;
var fluree$db$operations$state_machine__2414__auto____0 = (function (){
var statearr_21363 = [null,null,null,null,null,null,null,null];
(statearr_21363[(0)] = fluree$db$operations$state_machine__2414__auto__);

(statearr_21363[(1)] = (1));

return statearr_21363;
});
var fluree$db$operations$state_machine__2414__auto____1 = (function (state_21347){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21347);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21364){var ex__2417__auto__ = e21364;
var statearr_21365_21379 = state_21347;
(statearr_21365_21379[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21347[(4)]))){
var statearr_21366_21380 = state_21347;
(statearr_21366_21380[(1)] = cljs.core.first((state_21347[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21381 = state_21347;
state_21347 = G__21381;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2414__auto__ = function(state_21347){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2414__auto____1.call(this,state_21347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2414__auto____0;
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2414__auto____1;
return fluree$db$operations$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21367 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21367[(6)] = c__2436__auto___21369);

return statearr_21367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__21383 = arguments.length;
switch (G__21383) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__21384){
var map__21385 = p__21384;
var map__21385__$1 = (((((!((map__21385 == null))))?(((((map__21385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21385):map__21385);
var opts = map__21385__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21385__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__21387 = session;
var map__21387__$1 = (((((!((map__21387 == null))))?(((((map__21387.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21387.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21387):map__21387);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21387__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21387__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21387__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___21449 = arguments.length;
var i__4737__auto___21450 = (0);
while(true){
if((i__4737__auto___21450 < len__4736__auto___21449)){
args__4742__auto__.push((arguments[i__4737__auto___21450]));

var G__21451 = (i__4737__auto___21450 + (1));
i__4737__auto___21450 = G__21451;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__21392){
var vec__21393 = p__21392;
var map__21396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21393,(0),null);
var map__21396__$1 = (((((!((map__21396 == null))))?(((((map__21396.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21396.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21396):map__21396);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21396__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21396__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__21393;
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21429){
var state_val_21430 = (state_21429[(1)]);
if((state_val_21430 === (7))){
var inst_21412 = (state_21429[(2)]);
var state_21429__$1 = state_21429;
var statearr_21431_21452 = state_21429__$1;
(statearr_21431_21452[(2)] = inst_21412);

(statearr_21431_21452[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (1))){
var inst_21399 = (state_21429[(7)]);
var inst_21399__$1 = session;
var inst_21401 = (inst_21399__$1 == null);
var inst_21402 = cljs.core.not(inst_21401);
var state_21429__$1 = (function (){var statearr_21432 = state_21429;
(statearr_21432[(7)] = inst_21399__$1);

return statearr_21432;
})();
if(inst_21402){
var statearr_21433_21453 = state_21429__$1;
(statearr_21433_21453[(1)] = (2));

} else {
var statearr_21434_21454 = state_21429__$1;
(statearr_21434_21454[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (4))){
var inst_21415 = (state_21429[(2)]);
var state_21429__$1 = state_21429;
if(cljs.core.truth_(inst_21415)){
var statearr_21435_21455 = state_21429__$1;
(statearr_21435_21455[(1)] = (8));

} else {
var statearr_21436_21456 = state_21429__$1;
(statearr_21436_21456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (6))){
var state_21429__$1 = state_21429;
var statearr_21437_21457 = state_21429__$1;
(statearr_21437_21457[(2)] = false);

(statearr_21437_21457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (3))){
var state_21429__$1 = state_21429;
var statearr_21438_21458 = state_21429__$1;
(statearr_21438_21458[(2)] = false);

(statearr_21438_21458[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (2))){
var inst_21399 = (state_21429[(7)]);
var inst_21404 = inst_21399.cljs$lang$protocol_mask$partition0$;
var inst_21405 = (inst_21404 & (64));
var inst_21406 = inst_21399.cljs$core$ISeq$;
var inst_21407 = (cljs.core.PROTOCOL_SENTINEL === inst_21406);
var inst_21408 = ((inst_21405) || (inst_21407));
var state_21429__$1 = state_21429;
if(cljs.core.truth_(inst_21408)){
var statearr_21439_21459 = state_21429__$1;
(statearr_21439_21459[(1)] = (5));

} else {
var statearr_21440_21460 = state_21429__$1;
(statearr_21440_21460[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (9))){
var inst_21399 = (state_21429[(7)]);
var state_21429__$1 = state_21429;
var statearr_21441_21461 = state_21429__$1;
(statearr_21441_21461[(2)] = inst_21399);

(statearr_21441_21461[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (5))){
var state_21429__$1 = state_21429;
var statearr_21442_21462 = state_21429__$1;
(statearr_21442_21462[(2)] = true);

(statearr_21442_21462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21430 === (10))){
var inst_21420 = (state_21429[(2)]);
var inst_21421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21420,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_21422 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21420,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_21423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21420,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_21424 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_21425 = [inst_21421,inst_21422,toBlock,toTime];
var inst_21426 = cljs.core.PersistentHashMap.fromArrays(inst_21424,inst_21425);
var inst_21427 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_21423,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_21426);
var state_21429__$1 = state_21429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21429__$1,inst_21427);
} else {
if((state_val_21430 === (8))){
var inst_21399 = (state_21429[(7)]);
var inst_21417 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21399);
var state_21429__$1 = state_21429;
var statearr_21443_21463 = state_21429__$1;
(statearr_21443_21463[(2)] = inst_21417);

(statearr_21443_21463[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2414__auto__ = null;
var fluree$db$operations$state_machine__2414__auto____0 = (function (){
var statearr_21444 = [null,null,null,null,null,null,null,null];
(statearr_21444[(0)] = fluree$db$operations$state_machine__2414__auto__);

(statearr_21444[(1)] = (1));

return statearr_21444;
});
var fluree$db$operations$state_machine__2414__auto____1 = (function (state_21429){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21429);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e21445){var ex__2417__auto__ = e21445;
var statearr_21446_21464 = state_21429;
(statearr_21446_21464[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21429[(4)]))){
var statearr_21447_21465 = state_21429;
(statearr_21447_21465[(1)] = cljs.core.first((state_21429[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21466 = state_21429;
state_21429 = G__21466;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2414__auto__ = function(state_21429){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2414__auto____1.call(this,state_21429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2414__auto____0;
fluree$db$operations$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2414__auto____1;
return fluree$db$operations$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_21448 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_21448[(6)] = c__2436__auto__);

return statearr_21448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq21390){
var G__21391 = cljs.core.first(seq21390);
var seq21390__$1 = cljs.core.next(seq21390);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21391,seq21390__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__21467 = session;
var map__21467__$1 = (((((!((map__21467 == null))))?(((((map__21467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21467):map__21467);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21467__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21467__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21467__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__21470 = arguments.length;
switch (G__21470) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__21471 = opts;
var map__21471__$1 = (((((!((map__21471 == null))))?(((((map__21471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21471):map__21471);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21471__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21471__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
