// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18164){
var state_val_18165 = (state_18164[(1)]);
if((state_val_18165 === (1))){
var state_18164__$1 = state_18164;
var statearr_18166_18180 = state_18164__$1;
(statearr_18166_18180[(2)] = null);

(statearr_18166_18180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18165 === (2))){
var _ = (function (){var statearr_18167 = state_18164;
(statearr_18167[(4)] = cljs.core.cons((5),(state_18164[(4)])));

return statearr_18167;
})();
var inst_18155 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_18164__$1 = state_18164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18164__$1,(6),inst_18155);
} else {
if((state_val_18165 === (3))){
var inst_18162 = (state_18164[(2)]);
var state_18164__$1 = state_18164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18164__$1,inst_18162);
} else {
if((state_val_18165 === (4))){
var inst_18149 = (state_18164[(2)]);
var state_18164__$1 = state_18164;
var statearr_18169_18181 = state_18164__$1;
(statearr_18169_18181[(2)] = inst_18149);

(statearr_18169_18181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18165 === (5))){
var _ = (function (){var statearr_18170 = state_18164;
(statearr_18170[(4)] = cljs.core.rest((state_18164[(4)])));

return statearr_18170;
})();
var state_18164__$1 = state_18164;
var ex18168 = (state_18164__$1[(2)]);
var statearr_18171_18182 = state_18164__$1;
(statearr_18171_18182[(5)] = ex18168);


if((ex18168 instanceof Error)){
var statearr_18172_18183 = state_18164__$1;
(statearr_18172_18183[(1)] = (4));

(statearr_18172_18183[(5)] = null);

} else {
throw ex18168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18165 === (6))){
var inst_18157 = (state_18164[(2)]);
var inst_18158 = fluree.db.util.async.throw_err(inst_18157);
var inst_18159 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_18158);
var _ = (function (){var statearr_18173 = state_18164;
(statearr_18173[(4)] = cljs.core.rest((state_18164[(4)])));

return statearr_18173;
})();
var state_18164__$1 = state_18164;
var statearr_18174_18184 = state_18164__$1;
(statearr_18174_18184[(2)] = inst_18159);

(statearr_18174_18184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0 = (function (){
var statearr_18175 = [null,null,null,null,null,null,null];
(statearr_18175[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__);

(statearr_18175[(1)] = (1));

return statearr_18175;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1 = (function (state_18164){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18164);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18176){var ex__2417__auto__ = e18176;
var statearr_18177_18185 = state_18164;
(statearr_18177_18185[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18164[(4)]))){
var statearr_18178_18186 = state_18164;
(statearr_18178_18186[(1)] = cljs.core.first((state_18164[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18187 = state_18164;
state_18164 = G__18187;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__ = function(state_18164){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1.call(this,state_18164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18179 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18179[(6)] = c__2436__auto__);

return statearr_18179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18219){
var state_val_18220 = (state_18219[(1)]);
if((state_val_18220 === (7))){
var inst_18203 = (state_18219[(7)]);
var inst_18205 = cljs.core.empty_QMARK_(inst_18203);
var inst_18206 = (!(inst_18205));
var state_18219__$1 = state_18219;
var statearr_18221_18245 = state_18219__$1;
(statearr_18221_18245[(2)] = inst_18206);

(statearr_18221_18245[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (1))){
var state_18219__$1 = state_18219;
var statearr_18222_18246 = state_18219__$1;
(statearr_18222_18246[(2)] = null);

(statearr_18222_18246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (4))){
var inst_18189 = (state_18219[(2)]);
var state_18219__$1 = state_18219;
var statearr_18223_18247 = state_18219__$1;
(statearr_18223_18247[(2)] = inst_18189);

(statearr_18223_18247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (6))){
var inst_18203 = (state_18219[(7)]);
var inst_18195 = (state_18219[(8)]);
var inst_18201 = (state_18219[(2)]);
var inst_18202 = fluree.db.util.async.throw_err(inst_18201);
var inst_18203__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18195,inst_18202);
var state_18219__$1 = (function (){var statearr_18224 = state_18219;
(statearr_18224[(7)] = inst_18203__$1);

return statearr_18224;
})();
if(cljs.core.truth_(inst_18203__$1)){
var statearr_18225_18248 = state_18219__$1;
(statearr_18225_18248[(1)] = (7));

} else {
var statearr_18226_18249 = state_18219__$1;
(statearr_18226_18249[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (3))){
var inst_18217 = (state_18219[(2)]);
var state_18219__$1 = state_18219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18219__$1,inst_18217);
} else {
if((state_val_18220 === (12))){
var inst_18214 = (state_18219[(2)]);
var _ = (function (){var statearr_18227 = state_18219;
(statearr_18227[(4)] = cljs.core.rest((state_18219[(4)])));

return statearr_18227;
})();
var state_18219__$1 = state_18219;
var statearr_18228_18250 = state_18219__$1;
(statearr_18228_18250[(2)] = inst_18214);

(statearr_18228_18250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (2))){
var _ = (function (){var statearr_18229 = state_18219;
(statearr_18229[(4)] = cljs.core.cons((5),(state_18219[(4)])));

return statearr_18229;
})();
var inst_18195 = (function (){return (function (p1__18188_SHARP_){
return p1__18188_SHARP_.o;
});
})();
var inst_18196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18197 = [pred_id];
var inst_18198 = (new cljs.core.PersistentVector(null,1,(5),inst_18196,inst_18197,null));
var inst_18199 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_18198);
var state_18219__$1 = (function (){var statearr_18230 = state_18219;
(statearr_18230[(8)] = inst_18195);

return statearr_18230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18219__$1,(6),inst_18199);
} else {
if((state_val_18220 === (11))){
var state_18219__$1 = state_18219;
var statearr_18232_18251 = state_18219__$1;
(statearr_18232_18251[(2)] = true);

(statearr_18232_18251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (9))){
var inst_18209 = (state_18219[(2)]);
var state_18219__$1 = state_18219;
if(cljs.core.truth_(inst_18209)){
var statearr_18233_18252 = state_18219__$1;
(statearr_18233_18252[(1)] = (10));

} else {
var statearr_18234_18253 = state_18219__$1;
(statearr_18234_18253[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (5))){
var _ = (function (){var statearr_18235 = state_18219;
(statearr_18235[(4)] = cljs.core.rest((state_18219[(4)])));

return statearr_18235;
})();
var state_18219__$1 = state_18219;
var ex18231 = (state_18219__$1[(2)]);
var statearr_18236_18254 = state_18219__$1;
(statearr_18236_18254[(5)] = ex18231);


if((ex18231 instanceof Error)){
var statearr_18237_18255 = state_18219__$1;
(statearr_18237_18255[(1)] = (4));

(statearr_18237_18255[(5)] = null);

} else {
throw ex18231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (10))){
var inst_18203 = (state_18219[(7)]);
var inst_18211 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_18203);
var state_18219__$1 = state_18219;
var statearr_18238_18256 = state_18219__$1;
(statearr_18238_18256[(2)] = inst_18211);

(statearr_18238_18256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18220 === (8))){
var inst_18203 = (state_18219[(7)]);
var state_18219__$1 = state_18219;
var statearr_18239_18257 = state_18219__$1;
(statearr_18239_18257[(2)] = inst_18203);

(statearr_18239_18257[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_18240 = [null,null,null,null,null,null,null,null,null];
(statearr_18240[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__);

(statearr_18240[(1)] = (1));

return statearr_18240;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1 = (function (state_18219){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18219);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18241){var ex__2417__auto__ = e18241;
var statearr_18242_18258 = state_18219;
(statearr_18242_18258[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18219[(4)]))){
var statearr_18243_18259 = state_18219;
(statearr_18243_18259[(1)] = cljs.core.first((state_18219[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18260 = state_18219;
state_18219 = G__18260;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__ = function(state_18219){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1.call(this,state_18219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18244 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18244[(6)] = c__2436__auto__);

return statearr_18244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18337){
var state_val_18338 = (state_18337[(1)]);
if((state_val_18338 === (7))){
var inst_18332 = (state_18337[(2)]);
var _ = (function (){var statearr_18339 = state_18337;
(statearr_18339[(4)] = cljs.core.rest((state_18337[(4)])));

return statearr_18339;
})();
var state_18337__$1 = state_18337;
var statearr_18340_18373 = state_18337__$1;
(statearr_18340_18373[(2)] = inst_18332);

(statearr_18340_18373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (1))){
var state_18337__$1 = state_18337;
var statearr_18341_18374 = state_18337__$1;
(statearr_18341_18374[(2)] = null);

(statearr_18341_18374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (4))){
var inst_18263 = (state_18337[(2)]);
var state_18337__$1 = state_18337;
var statearr_18342_18375 = state_18337__$1;
(statearr_18342_18375[(2)] = inst_18263);

(statearr_18342_18375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (15))){
var inst_18287 = (state_18337[(7)]);
var inst_18293 = (state_18337[(8)]);
var inst_18313 = (state_18337[(9)]);
var inst_18300 = (state_18337[(10)]);
var inst_18315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18316 = inst_18293.s;
var inst_18317 = [inst_18316,inst_18300,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_18318 = (new cljs.core.PersistentVector(null,3,(5),inst_18315,inst_18317,null));
var inst_18319 = cljs.core.assoc_in(inst_18287,inst_18318,inst_18313);
var state_18337__$1 = state_18337;
var statearr_18343_18376 = state_18337__$1;
(statearr_18343_18376[(2)] = inst_18319);

(statearr_18343_18376[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (13))){
var inst_18302 = (state_18337[(11)]);
var inst_18313 = (state_18337[(2)]);
var state_18337__$1 = (function (){var statearr_18344 = state_18337;
(statearr_18344[(9)] = inst_18313);

return statearr_18344;
})();
if(cljs.core.truth_(inst_18302)){
var statearr_18345_18377 = state_18337__$1;
(statearr_18345_18377[(1)] = (15));

} else {
var statearr_18346_18378 = state_18337__$1;
(statearr_18346_18378[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (6))){
var inst_18286 = (state_18337[(12)]);
var inst_18293 = (state_18337[(8)]);
var inst_18292 = cljs.core.seq(inst_18286);
var inst_18293__$1 = cljs.core.first(inst_18292);
var inst_18294 = cljs.core.next(inst_18292);
var inst_18295 = cljs.core.not(inst_18293__$1);
var state_18337__$1 = (function (){var statearr_18347 = state_18337;
(statearr_18347[(13)] = inst_18294);

(statearr_18347[(8)] = inst_18293__$1);

return statearr_18347;
})();
if(inst_18295){
var statearr_18348_18379 = state_18337__$1;
(statearr_18348_18379[(1)] = (8));

} else {
var statearr_18349_18380 = state_18337__$1;
(statearr_18349_18380[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (17))){
var inst_18294 = (state_18337[(13)]);
var inst_18327 = (state_18337[(2)]);
var inst_18286 = inst_18294;
var inst_18287 = inst_18327;
var state_18337__$1 = (function (){var statearr_18350 = state_18337;
(statearr_18350[(12)] = inst_18286);

(statearr_18350[(7)] = inst_18287);

return statearr_18350;
})();
var statearr_18351_18381 = state_18337__$1;
(statearr_18351_18381[(2)] = null);

(statearr_18351_18381[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (3))){
var inst_18335 = (state_18337[(2)]);
var state_18337__$1 = state_18337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18337__$1,inst_18335);
} else {
if((state_val_18338 === (12))){
var inst_18293 = (state_18337[(8)]);
var inst_18311 = inst_18293.o;
var state_18337__$1 = state_18337;
var statearr_18352_18382 = state_18337__$1;
(statearr_18352_18382[(2)] = inst_18311);

(statearr_18352_18382[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (2))){
var _ = (function (){var statearr_18353 = state_18337;
(statearr_18353[(4)] = cljs.core.cons((5),(state_18337[(4)])));

return statearr_18353;
})();
var inst_18269 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_18270 = cljs.core.PersistentHashSet.EMPTY;
var inst_18271 = cljs.core.vals(tempids);
var inst_18272 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18270,inst_18271);
var inst_18273 = (function (){var pred_flakes = inst_18269;
var is_new_QMARK_ = inst_18272;
return (function (p1__18261_SHARP_,p2__18262_SHARP_){
return cljs.core.assoc_in(p1__18261_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__18262_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__18354 = p2__18262_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__18354) : is_new_QMARK_.call(null,G__18354));
})()));
});
})();
var inst_18274 = cljs.core.PersistentHashMap.EMPTY;
var inst_18275 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18273,inst_18274,inst_18269);
var inst_18283 = cljs.core.seq(inst_18269);
var inst_18284 = cljs.core.first(inst_18283);
var inst_18285 = cljs.core.next(inst_18283);
var inst_18286 = inst_18269;
var inst_18287 = inst_18275;
var state_18337__$1 = (function (){var statearr_18355 = state_18337;
(statearr_18355[(12)] = inst_18286);

(statearr_18355[(7)] = inst_18287);

(statearr_18355[(14)] = inst_18285);

(statearr_18355[(15)] = inst_18284);

return statearr_18355;
})();
var statearr_18356_18383 = state_18337__$1;
(statearr_18356_18383[(2)] = null);

(statearr_18356_18383[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (11))){
var inst_18293 = (state_18337[(8)]);
var inst_18305 = inst_18293.o;
var inst_18306 = fluree.db.query.schema.convert_type_to_kw(inst_18305,db);
var state_18337__$1 = state_18337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18337__$1,(14),inst_18306);
} else {
if((state_val_18338 === (9))){
var inst_18293 = (state_18337[(8)]);
var inst_18300 = (state_18337[(10)]);
var inst_18298 = inst_18293.p;
var inst_18299 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18298);
var inst_18300__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_18299);
var inst_18301 = inst_18293.op;
var inst_18302 = inst_18301 === false;
var inst_18303 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_18300__$1);
var state_18337__$1 = (function (){var statearr_18358 = state_18337;
(statearr_18358[(11)] = inst_18302);

(statearr_18358[(10)] = inst_18300__$1);

return statearr_18358;
})();
if(inst_18303){
var statearr_18359_18384 = state_18337__$1;
(statearr_18359_18384[(1)] = (11));

} else {
var statearr_18360_18385 = state_18337__$1;
(statearr_18360_18385[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (5))){
var _ = (function (){var statearr_18361 = state_18337;
(statearr_18361[(4)] = cljs.core.rest((state_18337[(4)])));

return statearr_18361;
})();
var state_18337__$1 = state_18337;
var ex18357 = (state_18337__$1[(2)]);
var statearr_18362_18386 = state_18337__$1;
(statearr_18362_18386[(5)] = ex18357);


if((ex18357 instanceof Error)){
var statearr_18363_18387 = state_18337__$1;
(statearr_18363_18387[(1)] = (4));

(statearr_18363_18387[(5)] = null);

} else {
throw ex18357;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (14))){
var inst_18308 = (state_18337[(2)]);
var inst_18309 = fluree.db.util.async.throw_err(inst_18308);
var state_18337__$1 = state_18337;
var statearr_18364_18388 = state_18337__$1;
(statearr_18364_18388[(2)] = inst_18309);

(statearr_18364_18388[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (16))){
var inst_18287 = (state_18337[(7)]);
var inst_18293 = (state_18337[(8)]);
var inst_18313 = (state_18337[(9)]);
var inst_18300 = (state_18337[(10)]);
var inst_18321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18322 = inst_18293.s;
var inst_18323 = [inst_18322,inst_18300,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_18324 = (new cljs.core.PersistentVector(null,3,(5),inst_18321,inst_18323,null));
var inst_18325 = cljs.core.assoc_in(inst_18287,inst_18324,inst_18313);
var state_18337__$1 = state_18337;
var statearr_18365_18389 = state_18337__$1;
(statearr_18365_18389[(2)] = inst_18325);

(statearr_18365_18389[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (10))){
var inst_18330 = (state_18337[(2)]);
var state_18337__$1 = state_18337;
var statearr_18366_18390 = state_18337__$1;
(statearr_18366_18390[(2)] = inst_18330);

(statearr_18366_18390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18338 === (8))){
var inst_18287 = (state_18337[(7)]);
var state_18337__$1 = state_18337;
var statearr_18367_18391 = state_18337__$1;
(statearr_18367_18391[(2)] = inst_18287);

(statearr_18367_18391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0 = (function (){
var statearr_18368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18368[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__);

(statearr_18368[(1)] = (1));

return statearr_18368;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1 = (function (state_18337){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18337);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18369){var ex__2417__auto__ = e18369;
var statearr_18370_18392 = state_18337;
(statearr_18370_18392[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18337[(4)]))){
var statearr_18371_18393 = state_18337;
(statearr_18371_18393[(1)] = cljs.core.first((state_18337[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18394 = state_18337;
state_18337 = G__18394;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__ = function(state_18337){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1.call(this,state_18337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18372 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18372[(6)] = c__2436__auto__);

return statearr_18372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__18396 = arguments.length;
switch (G__18396) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__18399 = arguments.length;
switch (G__18399) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_18708){
var state_val_18709 = (state_18708[(1)]);
if((state_val_18709 === (65))){
var inst_18661 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18710_18882 = state_18708__$1;
(statearr_18710_18882[(2)] = inst_18661);

(statearr_18710_18882[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (70))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18583 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18584 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_18583,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,2,inst_18583,null));
var inst_18585 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18584,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18584,null));
var inst_18586 = (inst_18585.cljs$core$IFn$_invoke$arity$1 ? inst_18585.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18585.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18586)){
var statearr_18711_18883 = state_18708__$1;
(statearr_18711_18883[(1)] = (71));

} else {
var statearr_18712_18884 = state_18708__$1;
(statearr_18712_18884[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (62))){
var inst_18663 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18713_18885 = state_18708__$1;
(statearr_18713_18885[(2)] = inst_18663);

(statearr_18713_18885[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (74))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18593 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18594 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_18593,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,3,inst_18593,null));
var inst_18595 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18594,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18594,null));
var inst_18596 = (inst_18595.cljs$core$IFn$_invoke$arity$1 ? inst_18595.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18595.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18596)){
var statearr_18714_18886 = state_18708__$1;
(statearr_18714_18886[(1)] = (75));

} else {
var statearr_18715_18887 = state_18708__$1;
(statearr_18715_18887[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (110))){
var inst_18695 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18716_18888 = state_18708__$1;
(statearr_18716_18888[(2)] = inst_18695);

(statearr_18716_18888[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (7))){
var inst_18703 = (state_18708[(2)]);
var _ = (function (){var statearr_18717 = state_18708;
(statearr_18717[(4)] = cljs.core.rest((state_18708[(4)])));

return statearr_18717;
})();
var state_18708__$1 = state_18708;
var statearr_18718_18889 = state_18708__$1;
(statearr_18718_18889[(2)] = inst_18703);

(statearr_18718_18889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (59))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18569 = (state_18708[(2)]);
var inst_18570__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18569,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_18571__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18569,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_18572 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18571__$1,inst_18570__$1);
var state_18708__$1 = (function (){var statearr_18719 = state_18708;
(statearr_18719[(7)] = inst_18571__$1);

(statearr_18719[(8)] = inst_18570__$1);

return statearr_18719;
})();
if(inst_18572){
var statearr_18720_18890 = state_18708__$1;
(statearr_18720_18890[(1)] = (60));

} else {
var statearr_18721_18891 = state_18708__$1;
(statearr_18721_18891[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (86))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18623 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18624 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_18623,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,5,inst_18623,null));
var inst_18625 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18624,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18624,null));
var inst_18626 = (inst_18625.cljs$core$IFn$_invoke$arity$1 ? inst_18625.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18625.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18626)){
var statearr_18722_18892 = state_18708__$1;
(statearr_18722_18892[(1)] = (87));

} else {
var statearr_18723_18893 = state_18708__$1;
(statearr_18723_18893[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (20))){
var inst_18439 = (state_18708[(9)]);
var inst_18464 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18465 = inst_18464 === true;
var inst_18466 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18467 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18466);
var inst_18468 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_18467);
var inst_18469 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18470 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18469);
var inst_18471 = inst_18470 === true;
var inst_18472 = ((inst_18465) && (inst_18468) && (inst_18471));
var state_18708__$1 = state_18708;
var statearr_18724_18894 = state_18708__$1;
(statearr_18724_18894[(2)] = inst_18472);

(statearr_18724_18894[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (72))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18589 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18725_18895 = state_18708__$1;
(statearr_18725_18895[(2)] = inst_18589);

(statearr_18725_18895[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (58))){
var inst_18548 = (state_18708[(10)]);
var state_18708__$1 = state_18708;
var statearr_18726_18896 = state_18708__$1;
(statearr_18726_18896[(2)] = inst_18548);

(statearr_18726_18896[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (60))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18727_18897 = state_18708__$1;
(statearr_18727_18897[(2)] = inst_18538);

(statearr_18727_18897[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (27))){
var inst_18459 = (state_18708[(12)]);
var state_18708__$1 = state_18708;
var statearr_18728_18898 = state_18708__$1;
(statearr_18728_18898[(2)] = inst_18459);

(statearr_18728_18898[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (1))){
var state_18708__$1 = state_18708;
var statearr_18729_18899 = state_18708__$1;
(statearr_18729_18899[(2)] = null);

(statearr_18729_18899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (69))){
var inst_18656 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18730_18900 = state_18708__$1;
(statearr_18730_18900[(2)] = inst_18656);

(statearr_18730_18900[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (101))){
var inst_18685 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18685)){
var statearr_18731_18901 = state_18708__$1;
(statearr_18731_18901[(1)] = (105));

} else {
var statearr_18732_18902 = state_18708__$1;
(statearr_18732_18902[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (24))){
var inst_18459 = (state_18708[(12)]);
var state_18708__$1 = state_18708;
var statearr_18733_18903 = state_18708__$1;
(statearr_18733_18903[(2)] = inst_18459);

(statearr_18733_18903[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (102))){
var inst_18439 = (state_18708[(9)]);
var inst_18672 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18673 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18672);
var inst_18674 = inst_18673 === true;
var inst_18675 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18676 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18675);
var inst_18677 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_18676);
var inst_18678 = (!(inst_18677));
var inst_18679 = ((inst_18674) && (inst_18678));
var state_18708__$1 = state_18708;
var statearr_18734_18904 = state_18708__$1;
(statearr_18734_18904[(2)] = inst_18679);

(statearr_18734_18904[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (55))){
var state_18708__$1 = state_18708;
var statearr_18735_18905 = state_18708__$1;
(statearr_18735_18905[(2)] = false);

(statearr_18735_18905[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (85))){
var inst_18621 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18736_18906 = state_18708__$1;
(statearr_18736_18906[(2)] = inst_18621);

(statearr_18736_18906[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (39))){
var state_18708__$1 = state_18708;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18737_18907 = state_18708__$1;
(statearr_18737_18907[(1)] = (42));

} else {
var statearr_18738_18908 = state_18708__$1;
(statearr_18738_18908[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (88))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18629 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18739_18909 = state_18708__$1;
(statearr_18739_18909[(2)] = inst_18629);

(statearr_18739_18909[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (46))){
var inst_18539 = (state_18708[(13)]);
var state_18708__$1 = state_18708;
var statearr_18740_18910 = state_18708__$1;
(statearr_18740_18910[(2)] = inst_18539);

(statearr_18740_18910[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (4))){
var inst_18400 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18741_18911 = state_18708__$1;
(statearr_18741_18911[(2)] = inst_18400);

(statearr_18741_18911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (77))){
var inst_18601 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18742_18912 = state_18708__$1;
(statearr_18742_18912[(2)] = inst_18601);

(statearr_18742_18912[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (106))){
var inst_18666 = (state_18708[(14)]);
var state_18708__$1 = state_18708;
var statearr_18743_18913 = state_18708__$1;
(statearr_18743_18913[(2)] = inst_18666);

(statearr_18743_18913[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (95))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18744_18914 = state_18708__$1;
(statearr_18744_18914[(2)] = inst_18538);

(statearr_18744_18914[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (54))){
var state_18708__$1 = state_18708;
var statearr_18745_18915 = state_18708__$1;
(statearr_18745_18915[(2)] = true);

(statearr_18745_18915[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (92))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18639 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18746_18916 = state_18708__$1;
(statearr_18746_18916[(2)] = inst_18639);

(statearr_18746_18916[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (104))){
var inst_18682 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18747_18917 = state_18708__$1;
(statearr_18747_18917[(2)] = inst_18682);

(statearr_18747_18917[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (15))){
var inst_18427 = (state_18708[(15)]);
var state_18708__$1 = state_18708;
var statearr_18748_18918 = state_18708__$1;
(statearr_18748_18918[(2)] = inst_18427);

(statearr_18748_18918[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (48))){
var inst_18439 = (state_18708[(9)]);
var inst_18548 = (state_18708[(10)]);
var inst_18548__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18550 = (inst_18548__$1 == null);
var inst_18551 = cljs.core.not(inst_18550);
var state_18708__$1 = (function (){var statearr_18749 = state_18708;
(statearr_18749[(10)] = inst_18548__$1);

return statearr_18749;
})();
if(inst_18551){
var statearr_18750_18919 = state_18708__$1;
(statearr_18750_18919[(1)] = (51));

} else {
var statearr_18751_18920 = state_18708__$1;
(statearr_18751_18920[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (50))){
var inst_18439 = (state_18708[(9)]);
var inst_18666 = (state_18708[(2)]);
var inst_18667 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18668 = inst_18667 === true;
var state_18708__$1 = (function (){var statearr_18752 = state_18708;
(statearr_18752[(14)] = inst_18666);

return statearr_18752;
})();
if(cljs.core.truth_(inst_18668)){
var statearr_18753_18921 = state_18708__$1;
(statearr_18753_18921[(1)] = (99));

} else {
var statearr_18754_18922 = state_18708__$1;
(statearr_18754_18922[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (75))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18755_18923 = state_18708__$1;
(statearr_18755_18923[(2)] = inst_18538);

(statearr_18755_18923[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (99))){
var inst_18439 = (state_18708[(9)]);
var inst_18670 = (state_18708[(16)]);
var inst_18670__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18756 = state_18708;
(statearr_18756[(16)] = inst_18670__$1);

return statearr_18756;
})();
if(cljs.core.truth_(inst_18670__$1)){
var statearr_18757_18924 = state_18708__$1;
(statearr_18757_18924[(1)] = (102));

} else {
var statearr_18758_18925 = state_18708__$1;
(statearr_18758_18925[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (21))){
var inst_18462 = (state_18708[(17)]);
var state_18708__$1 = state_18708;
var statearr_18759_18926 = state_18708__$1;
(statearr_18759_18926[(2)] = inst_18462);

(statearr_18759_18926[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (31))){
var inst_18502 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18502)){
var statearr_18760_18927 = state_18708__$1;
(statearr_18760_18927[(1)] = (32));

} else {
var statearr_18761_18928 = state_18708__$1;
(statearr_18761_18928[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (32))){
var inst_18491 = (state_18708[(18)]);
var inst_18504 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_18491,"a component","a non-component",throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18762_18929 = state_18708__$1;
(statearr_18762_18929[(2)] = inst_18504);

(statearr_18762_18929[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (40))){
var inst_18507 = (state_18708[(19)]);
var state_18708__$1 = state_18708;
var statearr_18763_18930 = state_18708__$1;
(statearr_18763_18930[(2)] = inst_18507);

(statearr_18763_18930[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (91))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18764_18931 = state_18708__$1;
(statearr_18764_18931[(2)] = inst_18538);

(statearr_18764_18931[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (108))){
var inst_18688 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18689 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18690 = cljs.core.PersistentHashMap.fromArrays(inst_18688,inst_18689);
var inst_18691 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_18690);
var inst_18692 = (function(){throw inst_18691})();
var state_18708__$1 = state_18708;
var statearr_18765_18932 = state_18708__$1;
(statearr_18765_18932[(2)] = inst_18692);

(statearr_18765_18932[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (56))){
var inst_18561 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18766_18933 = state_18708__$1;
(statearr_18766_18933[(2)] = inst_18561);

(statearr_18766_18933[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (33))){
var inst_18491 = (state_18708[(18)]);
var state_18708__$1 = state_18708;
var statearr_18767_18934 = state_18708__$1;
(statearr_18767_18934[(2)] = inst_18491);

(statearr_18767_18934[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (13))){
var inst_18454 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18454)){
var statearr_18768_18935 = state_18708__$1;
(statearr_18768_18935[(1)] = (14));

} else {
var statearr_18769_18936 = state_18708__$1;
(statearr_18769_18936[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (22))){
var inst_18475 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18770_18937 = state_18708__$1;
(statearr_18770_18937[(2)] = inst_18475);

(statearr_18770_18937[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (90))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18633 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_18634 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_18633,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,5,inst_18633,null));
var inst_18635 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18634,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18634,null));
var inst_18636 = (inst_18635.cljs$core$IFn$_invoke$arity$1 ? inst_18635.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18635.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18636)){
var statearr_18771_18938 = state_18708__$1;
(statearr_18771_18938[(1)] = (91));

} else {
var statearr_18772_18939 = state_18708__$1;
(statearr_18772_18939[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (109))){
var inst_18666 = (state_18708[(14)]);
var state_18708__$1 = state_18708;
var statearr_18773_18940 = state_18708__$1;
(statearr_18773_18940[(2)] = inst_18666);

(statearr_18773_18940[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (36))){
var inst_18508 = (state_18708[(20)]);
var state_18708__$1 = state_18708;
var statearr_18774_18941 = state_18708__$1;
(statearr_18774_18941[(2)] = inst_18508);

(statearr_18774_18941[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (41))){
var inst_18439 = (state_18708[(9)]);
var inst_18539 = (state_18708[(13)]);
var inst_18538 = (state_18708[(2)]);
var inst_18539__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18775 = state_18708;
(statearr_18775[(11)] = inst_18538);

(statearr_18775[(13)] = inst_18539__$1);

return statearr_18775;
})();
if(cljs.core.truth_(inst_18539__$1)){
var statearr_18776_18942 = state_18708__$1;
(statearr_18776_18942[(1)] = (45));

} else {
var statearr_18777_18943 = state_18708__$1;
(statearr_18777_18943[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (89))){
var inst_18631 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18778_18944 = state_18708__$1;
(statearr_18778_18944[(2)] = inst_18631);

(statearr_18778_18944[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (100))){
var state_18708__$1 = state_18708;
var statearr_18779_18945 = state_18708__$1;
(statearr_18779_18945[(2)] = false);

(statearr_18779_18945[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (43))){
var inst_18507 = (state_18708[(19)]);
var state_18708__$1 = state_18708;
var statearr_18780_18946 = state_18708__$1;
(statearr_18780_18946[(2)] = inst_18507);

(statearr_18780_18946[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (61))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18575 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_18576 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_18575,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,3,inst_18575,null));
var inst_18577 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18576,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18576,null));
var inst_18578 = (inst_18577.cljs$core$IFn$_invoke$arity$1 ? inst_18577.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18577.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18578)){
var statearr_18781_18947 = state_18708__$1;
(statearr_18781_18947[(1)] = (63));

} else {
var statearr_18782_18948 = state_18708__$1;
(statearr_18782_18948[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (29))){
var inst_18439 = (state_18708[(9)]);
var inst_18494 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18495 = cljs.core.not(inst_18494);
var inst_18496 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18497 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18496);
var inst_18498 = inst_18497 === true;
var inst_18499 = ((inst_18495) && (inst_18498));
var state_18708__$1 = state_18708;
var statearr_18783_18949 = state_18708__$1;
(statearr_18783_18949[(2)] = inst_18499);

(statearr_18783_18949[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (44))){
var inst_18535 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18784_18950 = state_18708__$1;
(statearr_18784_18950[(2)] = inst_18535);

(statearr_18784_18950[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (93))){
var inst_18641 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18785_18951 = state_18708__$1;
(statearr_18785_18951[(2)] = inst_18641);

(statearr_18785_18951[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (6))){
var inst_18438 = (state_18708[(21)]);
var inst_18426 = (state_18708[(22)]);
var inst_18435 = cljs.core.seq(inst_18426);
var inst_18436 = cljs.core.first(inst_18435);
var inst_18437 = cljs.core.next(inst_18435);
var inst_18438__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18436,(0),null);
var inst_18439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18436,(1),null);
var inst_18440 = cljs.core.not(inst_18438__$1);
var state_18708__$1 = (function (){var statearr_18786 = state_18708;
(statearr_18786[(9)] = inst_18439);

(statearr_18786[(21)] = inst_18438__$1);

(statearr_18786[(23)] = inst_18437);

return statearr_18786;
})();
if(inst_18440){
var statearr_18787_18952 = state_18708__$1;
(statearr_18787_18952[(1)] = (8));

} else {
var statearr_18788_18953 = state_18708__$1;
(statearr_18788_18953[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (28))){
var inst_18488 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18789_18954 = state_18708__$1;
(statearr_18789_18954[(2)] = inst_18488);

(statearr_18789_18954[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (64))){
var state_18708__$1 = state_18708;
var statearr_18790_18955 = state_18708__$1;
(statearr_18790_18955[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (103))){
var inst_18670 = (state_18708[(16)]);
var state_18708__$1 = state_18708;
var statearr_18792_18956 = state_18708__$1;
(statearr_18792_18956[(2)] = inst_18670);

(statearr_18792_18956[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (51))){
var inst_18548 = (state_18708[(10)]);
var inst_18553 = inst_18548.cljs$lang$protocol_mask$partition0$;
var inst_18554 = (inst_18553 & (64));
var inst_18555 = inst_18548.cljs$core$ISeq$;
var inst_18556 = (cljs.core.PROTOCOL_SENTINEL === inst_18555);
var inst_18557 = ((inst_18554) || (inst_18556));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18557)){
var statearr_18793_18957 = state_18708__$1;
(statearr_18793_18957[(1)] = (54));

} else {
var statearr_18794_18958 = state_18708__$1;
(statearr_18794_18958[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (25))){
var inst_18439 = (state_18708[(9)]);
var inst_18492 = (state_18708[(24)]);
var inst_18491 = (state_18708[(2)]);
var inst_18492__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18795 = state_18708;
(statearr_18795[(18)] = inst_18491);

(statearr_18795[(24)] = inst_18492__$1);

return statearr_18795;
})();
if(cljs.core.truth_(inst_18492__$1)){
var statearr_18796_18959 = state_18708__$1;
(statearr_18796_18959[(1)] = (29));

} else {
var statearr_18797_18960 = state_18708__$1;
(statearr_18797_18960[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (34))){
var inst_18439 = (state_18708[(9)]);
var inst_18508 = (state_18708[(20)]);
var inst_18507 = (state_18708[(2)]);
var inst_18508__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18798 = state_18708;
(statearr_18798[(19)] = inst_18507);

(statearr_18798[(20)] = inst_18508__$1);

return statearr_18798;
})();
if(cljs.core.truth_(inst_18508__$1)){
var statearr_18799_18961 = state_18708__$1;
(statearr_18799_18961[(1)] = (35));

} else {
var statearr_18800_18962 = state_18708__$1;
(statearr_18800_18962[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (17))){
var inst_18439 = (state_18708[(9)]);
var inst_18462 = (state_18708[(17)]);
var inst_18462__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18801 = state_18708;
(statearr_18801[(17)] = inst_18462__$1);

return statearr_18801;
})();
if(cljs.core.truth_(inst_18462__$1)){
var statearr_18802_18963 = state_18708__$1;
(statearr_18802_18963[(1)] = (20));

} else {
var statearr_18803_18964 = state_18708__$1;
(statearr_18803_18964[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (3))){
var inst_18706 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18708__$1,inst_18706);
} else {
if((state_val_18709 === (12))){
var inst_18443 = (state_18708[(25)]);
var state_18708__$1 = state_18708;
var statearr_18804_18965 = state_18708__$1;
(statearr_18804_18965[(2)] = inst_18443);

(statearr_18804_18965[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (2))){
var _ = (function (){var statearr_18805 = state_18708;
(statearr_18805[(4)] = cljs.core.cons((5),(state_18708[(4)])));

return statearr_18805;
})();
var inst_18419 = pred_changes;
var inst_18420 = cljs.core.seq(inst_18419);
var inst_18421 = cljs.core.first(inst_18420);
var inst_18422 = cljs.core.next(inst_18420);
var inst_18423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18421,(0),null);
var inst_18424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18421,(1),null);
var inst_18425 = db;
var inst_18426 = inst_18419;
var inst_18427 = inst_18425;
var state_18708__$1 = (function (){var statearr_18806 = state_18708;
(statearr_18806[(22)] = inst_18426);

(statearr_18806[(26)] = inst_18424);

(statearr_18806[(15)] = inst_18427);

(statearr_18806[(27)] = inst_18422);

(statearr_18806[(28)] = inst_18423);

return statearr_18806;
})();
var statearr_18807_18966 = state_18708__$1;
(statearr_18807_18966[(2)] = null);

(statearr_18807_18966[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (66))){
var inst_18571 = (state_18708[(7)]);
var state_18708__$1 = state_18708;
var G__18808_18967 = inst_18571;
var G__18808_18968__$1 = (((G__18808_18967 instanceof cljs.core.Keyword))?G__18808_18967.fqn:null);
switch (G__18808_18968__$1) {
case "long":
var statearr_18809_18970 = state_18708__$1;
(statearr_18809_18970[(1)] = (70));


break;
case "bigint":
var statearr_18810_18971 = state_18708__$1;
(statearr_18810_18971[(1)] = (74));


break;
case "double":
var statearr_18811_18972 = state_18708__$1;
(statearr_18811_18972[(1)] = (78));


break;
case "float":
var statearr_18812_18973 = state_18708__$1;
(statearr_18812_18973[(1)] = (82));


break;
case "bigdec":
var statearr_18813_18974 = state_18708__$1;
(statearr_18813_18974[(1)] = (86));


break;
case "string":
var statearr_18814_18975 = state_18708__$1;
(statearr_18814_18975[(1)] = (90));


break;
case "instant":
var statearr_18815_18976 = state_18708__$1;
(statearr_18815_18976[(1)] = (94));


break;
default:
var statearr_18816_18977 = state_18708__$1;
(statearr_18816_18977[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (107))){
var inst_18437 = (state_18708[(23)]);
var inst_18698 = (state_18708[(2)]);
var inst_18426 = inst_18437;
var inst_18427 = inst_18698;
var state_18708__$1 = (function (){var statearr_18817 = state_18708;
(statearr_18817[(22)] = inst_18426);

(statearr_18817[(15)] = inst_18427);

return statearr_18817;
})();
var statearr_18818_18978 = state_18708__$1;
(statearr_18818_18978[(2)] = null);

(statearr_18818_18978[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (23))){
var state_18708__$1 = state_18708;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18819_18979 = state_18708__$1;
(statearr_18819_18979[(1)] = (26));

} else {
var statearr_18820_18980 = state_18708__$1;
(statearr_18820_18980[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (47))){
var inst_18545 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18545)){
var statearr_18821_18981 = state_18708__$1;
(statearr_18821_18981[(1)] = (48));

} else {
var statearr_18822_18982 = state_18708__$1;
(statearr_18822_18982[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (35))){
var inst_18439 = (state_18708[(9)]);
var inst_18438 = (state_18708[(21)]);
var inst_18427 = (state_18708[(15)]);
var inst_18510 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18511 = cljs.core.not(inst_18510);
var inst_18512 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18513 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18512);
var inst_18514 = inst_18513 === true;
var inst_18515 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_18427,inst_18438);
var state_18708__$1 = (function (){var statearr_18823 = state_18708;
(statearr_18823[(29)] = inst_18514);

(statearr_18823[(30)] = inst_18511);

return statearr_18823;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18708__$1,(38),inst_18515);
} else {
if((state_val_18709 === (82))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18613 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18614 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_18613,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,3,inst_18613,null));
var inst_18615 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18614,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18614,null));
var inst_18616 = (inst_18615.cljs$core$IFn$_invoke$arity$1 ? inst_18615.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18615.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18616)){
var statearr_18824_18983 = state_18708__$1;
(statearr_18824_18983[(1)] = (83));

} else {
var statearr_18825_18984 = state_18708__$1;
(statearr_18825_18984[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (76))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18599 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18826_18985 = state_18708__$1;
(statearr_18826_18985[(2)] = inst_18599);

(statearr_18826_18985[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (97))){
var inst_18651 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18827_18986 = state_18708__$1;
(statearr_18827_18986[(2)] = inst_18651);

(statearr_18827_18986[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (19))){
var inst_18478 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18478)){
var statearr_18828_18987 = state_18708__$1;
(statearr_18828_18987[(1)] = (23));

} else {
var statearr_18829_18988 = state_18708__$1;
(statearr_18829_18988[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (57))){
var inst_18548 = (state_18708[(10)]);
var inst_18566 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18548);
var state_18708__$1 = state_18708;
var statearr_18830_18989 = state_18708__$1;
(statearr_18830_18989[(2)] = inst_18566);

(statearr_18830_18989[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (68))){
var inst_18659 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18831_18990 = state_18708__$1;
(statearr_18831_18990[(2)] = inst_18659);

(statearr_18831_18990[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (11))){
var inst_18439 = (state_18708[(9)]);
var inst_18445 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18446 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18445);
var inst_18447 = inst_18446 === false;
var inst_18448 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18449 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18448);
var inst_18450 = inst_18449 === true;
var inst_18451 = ((inst_18447) && (inst_18450));
var state_18708__$1 = state_18708;
var statearr_18833_18991 = state_18708__$1;
(statearr_18833_18991[(2)] = inst_18451);

(statearr_18833_18991[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (9))){
var inst_18439 = (state_18708[(9)]);
var inst_18443 = (state_18708[(25)]);
var inst_18443__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18834 = state_18708;
(statearr_18834[(25)] = inst_18443__$1);

return statearr_18834;
})();
if(cljs.core.truth_(inst_18443__$1)){
var statearr_18835_18992 = state_18708__$1;
(statearr_18835_18992[(1)] = (11));

} else {
var statearr_18836_18993 = state_18708__$1;
(statearr_18836_18993[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (5))){
var _ = (function (){var statearr_18837 = state_18708;
(statearr_18837[(4)] = cljs.core.rest((state_18708[(4)])));

return statearr_18837;
})();
var state_18708__$1 = state_18708;
var ex18832 = (state_18708__$1[(2)]);
var statearr_18838_18994 = state_18708__$1;
(statearr_18838_18994[(5)] = ex18832);


if((ex18832 instanceof Error)){
var statearr_18839_18995 = state_18708__$1;
(statearr_18839_18995[(1)] = (4));

(statearr_18839_18995[(5)] = null);

} else {
throw ex18832;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (83))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18840_18996 = state_18708__$1;
(statearr_18840_18996[(2)] = inst_18538);

(statearr_18840_18996[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (14))){
var inst_18427 = (state_18708[(15)]);
var inst_18456 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_18427,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18841_18997 = state_18708__$1;
(statearr_18841_18997[(2)] = inst_18456);

(statearr_18841_18997[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (45))){
var inst_18439 = (state_18708[(9)]);
var inst_18541 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18439);
var inst_18542 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18541);
var state_18708__$1 = state_18708;
var statearr_18842_18998 = state_18708__$1;
(statearr_18842_18998[(2)] = inst_18542);

(statearr_18842_18998[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (53))){
var inst_18564 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18564)){
var statearr_18843_18999 = state_18708__$1;
(statearr_18843_18999[(1)] = (57));

} else {
var statearr_18844_19000 = state_18708__$1;
(statearr_18844_19000[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (78))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18603 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18604 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_18603,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,3,inst_18603,null));
var inst_18605 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18604,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18604,null));
var inst_18606 = (inst_18605.cljs$core$IFn$_invoke$arity$1 ? inst_18605.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18605.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18606)){
var statearr_18845_19001 = state_18708__$1;
(statearr_18845_19001[(1)] = (79));

} else {
var statearr_18846_19002 = state_18708__$1;
(statearr_18846_19002[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (26))){
var inst_18481 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18482 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18483 = cljs.core.PersistentHashMap.fromArrays(inst_18481,inst_18482);
var inst_18484 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_18483);
var inst_18485 = (function(){throw inst_18484})();
var state_18708__$1 = state_18708;
var statearr_18847_19003 = state_18708__$1;
(statearr_18847_19003[(2)] = inst_18485);

(statearr_18847_19003[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (16))){
var inst_18439 = (state_18708[(9)]);
var inst_18460 = (state_18708[(31)]);
var inst_18459 = (state_18708[(2)]);
var inst_18460__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18439);
var state_18708__$1 = (function (){var statearr_18848 = state_18708;
(statearr_18848[(12)] = inst_18459);

(statearr_18848[(31)] = inst_18460__$1);

return statearr_18848;
})();
if(cljs.core.truth_(inst_18460__$1)){
var statearr_18849_19004 = state_18708__$1;
(statearr_18849_19004[(1)] = (17));

} else {
var statearr_18850_19005 = state_18708__$1;
(statearr_18850_19005[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (81))){
var inst_18611 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18851_19006 = state_18708__$1;
(statearr_18851_19006[(2)] = inst_18611);

(statearr_18851_19006[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (79))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18852_19007 = state_18708__$1;
(statearr_18852_19007[(2)] = inst_18538);

(statearr_18852_19007[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (38))){
var inst_18514 = (state_18708[(29)]);
var inst_18511 = (state_18708[(30)]);
var inst_18517 = (state_18708[(2)]);
var inst_18518 = fluree.db.util.async.throw_err(inst_18517);
var inst_18519 = cljs.core.not(inst_18518);
var inst_18520 = ((inst_18511) && (inst_18514) && (inst_18519));
var state_18708__$1 = state_18708;
var statearr_18853_19008 = state_18708__$1;
(statearr_18853_19008[(2)] = inst_18520);

(statearr_18853_19008[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (98))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18653 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18854_19009 = state_18708__$1;
(statearr_18854_19009[(2)] = inst_18653);

(statearr_18854_19009[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (87))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18855_19010 = state_18708__$1;
(statearr_18855_19010[(2)] = inst_18538);

(statearr_18855_19010[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (30))){
var inst_18492 = (state_18708[(24)]);
var state_18708__$1 = state_18708;
var statearr_18856_19011 = state_18708__$1;
(statearr_18856_19011[(2)] = inst_18492);

(statearr_18856_19011[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (73))){
var inst_18591 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18857_19012 = state_18708__$1;
(statearr_18857_19012[(2)] = inst_18591);

(statearr_18857_19012[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (96))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18649 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18858_19013 = state_18708__$1;
(statearr_18858_19013[(2)] = inst_18649);

(statearr_18858_19013[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (10))){
var inst_18701 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
var statearr_18859_19014 = state_18708__$1;
(statearr_18859_19014[(2)] = inst_18701);

(statearr_18859_19014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (18))){
var inst_18460 = (state_18708[(31)]);
var state_18708__$1 = state_18708;
var statearr_18860_19015 = state_18708__$1;
(statearr_18860_19015[(2)] = inst_18460);

(statearr_18860_19015[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (105))){
var state_18708__$1 = state_18708;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18861_19016 = state_18708__$1;
(statearr_18861_19016[(1)] = (108));

} else {
var statearr_18862_19017 = state_18708__$1;
(statearr_18862_19017[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (52))){
var state_18708__$1 = state_18708;
var statearr_18863_19018 = state_18708__$1;
(statearr_18863_19018[(2)] = false);

(statearr_18863_19018[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (67))){
var state_18708__$1 = state_18708;
var statearr_18864_19019 = state_18708__$1;
(statearr_18864_19019[(2)] = null);

(statearr_18864_19019[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (71))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18865_19020 = state_18708__$1;
(statearr_18865_19020[(2)] = inst_18538);

(statearr_18865_19020[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (42))){
var inst_18438 = (state_18708[(21)]);
var inst_18427 = (state_18708[(15)]);
var inst_18526 = fluree.db.dbproto._p_prop(inst_18427,new cljs.core.Keyword(null,"name","name",1843675177),inst_18438);
var inst_18527 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18526)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_18528 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18529 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18530 = cljs.core.PersistentHashMap.fromArrays(inst_18528,inst_18529);
var inst_18531 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18527,inst_18530);
var inst_18532 = (function(){throw inst_18531})();
var state_18708__$1 = state_18708;
var statearr_18866_19021 = state_18708__$1;
(statearr_18866_19021[(2)] = inst_18532);

(statearr_18866_19021[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (80))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18609 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18867_19022 = state_18708__$1;
(statearr_18867_19022[(2)] = inst_18609);

(statearr_18867_19022[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (37))){
var inst_18523 = (state_18708[(2)]);
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18523)){
var statearr_18868_19023 = state_18708__$1;
(statearr_18868_19023[(1)] = (39));

} else {
var statearr_18869_19024 = state_18708__$1;
(statearr_18869_19024[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (63))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18580 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18870_19025 = state_18708__$1;
(statearr_18870_19025[(2)] = inst_18580);

(statearr_18870_19025[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (94))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18643 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18644 = (inst_18571.cljs$core$IFn$_invoke$arity$5 ? inst_18571.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_18643,null) : inst_18571.call(null,cljs.core.PersistentArrayMap,null,2,inst_18643,null));
var inst_18645 = (inst_18571.cljs$core$IFn$_invoke$arity$4 ? inst_18571.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_18644,null) : inst_18571.call(null,cljs.core.PersistentHashSet,null,inst_18644,null));
var inst_18646 = (inst_18645.cljs$core$IFn$_invoke$arity$1 ? inst_18645.cljs$core$IFn$_invoke$arity$1(inst_18570) : inst_18645.call(null,inst_18570));
var state_18708__$1 = state_18708;
if(cljs.core.truth_(inst_18646)){
var statearr_18871_19026 = state_18708__$1;
(statearr_18871_19026[(1)] = (95));

} else {
var statearr_18872_19027 = state_18708__$1;
(statearr_18872_19027[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (8))){
var inst_18427 = (state_18708[(15)]);
var state_18708__$1 = state_18708;
var statearr_18873_19028 = state_18708__$1;
(statearr_18873_19028[(2)] = inst_18427);

(statearr_18873_19028[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (49))){
var inst_18538 = (state_18708[(11)]);
var state_18708__$1 = state_18708;
var statearr_18874_19029 = state_18708__$1;
(statearr_18874_19029[(2)] = inst_18538);

(statearr_18874_19029[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18709 === (84))){
var inst_18571 = (state_18708[(7)]);
var inst_18570 = (state_18708[(8)]);
var inst_18619 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_18570,inst_18571,throw_QMARK_);
var state_18708__$1 = state_18708;
var statearr_18875_19030 = state_18708__$1;
(statearr_18875_19030[(2)] = inst_18619);

(statearr_18875_19030[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2414__auto__ = null;
var fluree$db$query$schema$state_machine__2414__auto____0 = (function (){
var statearr_18876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18876[(0)] = fluree$db$query$schema$state_machine__2414__auto__);

(statearr_18876[(1)] = (1));

return statearr_18876;
});
var fluree$db$query$schema$state_machine__2414__auto____1 = (function (state_18708){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_18708);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e18877){var ex__2417__auto__ = e18877;
var statearr_18878_19031 = state_18708;
(statearr_18878_19031[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_18708[(4)]))){
var statearr_18879_19032 = state_18708;
(statearr_18879_19032[(1)] = cljs.core.first((state_18708[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19033 = state_18708;
state_18708 = G__19033;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2414__auto__ = function(state_18708){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2414__auto____1.call(this,state_18708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2414__auto____0;
fluree$db$query$schema$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2414__auto____1;
return fluree$db$query$schema$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_18880 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_18880[(6)] = c__2436__auto__);

return statearr_18880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19057){
var state_val_19058 = (state_19057[(1)]);
if((state_val_19058 === (7))){
var state_19057__$1 = state_19057;
var statearr_19059_19078 = state_19057__$1;
(statearr_19059_19078[(2)] = db);

(statearr_19059_19078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (1))){
var state_19057__$1 = state_19057;
var statearr_19060_19079 = state_19057__$1;
(statearr_19060_19079[(2)] = null);

(statearr_19060_19079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (4))){
var inst_19034 = (state_19057[(2)]);
var state_19057__$1 = state_19057;
var statearr_19061_19080 = state_19057__$1;
(statearr_19061_19080[(2)] = inst_19034);

(statearr_19061_19080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (6))){
var inst_19043 = (state_19057[(7)]);
var inst_19042 = (state_19057[(2)]);
var inst_19043__$1 = fluree.db.util.async.throw_err(inst_19042);
var inst_19044 = cljs.core.empty_QMARK_(inst_19043__$1);
var state_19057__$1 = (function (){var statearr_19062 = state_19057;
(statearr_19062[(7)] = inst_19043__$1);

return statearr_19062;
})();
if(inst_19044){
var statearr_19063_19081 = state_19057__$1;
(statearr_19063_19081[(1)] = (7));

} else {
var statearr_19064_19082 = state_19057__$1;
(statearr_19064_19082[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (3))){
var inst_19055 = (state_19057[(2)]);
var state_19057__$1 = state_19057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19057__$1,inst_19055);
} else {
if((state_val_19058 === (2))){
var _ = (function (){var statearr_19066 = state_19057;
(statearr_19066[(4)] = cljs.core.cons((5),(state_19057[(4)])));

return statearr_19066;
})();
var inst_19040 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_19057__$1 = state_19057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19057__$1,(6),inst_19040);
} else {
if((state_val_19058 === (9))){
var inst_19052 = (state_19057[(2)]);
var _ = (function (){var statearr_19067 = state_19057;
(statearr_19067[(4)] = cljs.core.rest((state_19057[(4)])));

return statearr_19067;
})();
var state_19057__$1 = state_19057;
var statearr_19068_19083 = state_19057__$1;
(statearr_19068_19083[(2)] = inst_19052);

(statearr_19068_19083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (5))){
var _ = (function (){var statearr_19069 = state_19057;
(statearr_19069[(4)] = cljs.core.rest((state_19057[(4)])));

return statearr_19069;
})();
var state_19057__$1 = state_19057;
var ex19065 = (state_19057__$1[(2)]);
var statearr_19070_19084 = state_19057__$1;
(statearr_19070_19084[(5)] = ex19065);


if((ex19065 instanceof Error)){
var statearr_19071_19085 = state_19057__$1;
(statearr_19071_19085[(1)] = (4));

(statearr_19071_19085[(5)] = null);

} else {
throw ex19065;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (10))){
var inst_19049 = (state_19057[(2)]);
var inst_19050 = fluree.db.util.async.throw_err(inst_19049);
var state_19057__$1 = state_19057;
var statearr_19072_19086 = state_19057__$1;
(statearr_19072_19086[(2)] = inst_19050);

(statearr_19072_19086[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19058 === (8))){
var inst_19043 = (state_19057[(7)]);
var inst_19047 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_19043,db,true);
var state_19057__$1 = state_19057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19057__$1,(10),inst_19047);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0 = (function (){
var statearr_19073 = [null,null,null,null,null,null,null,null];
(statearr_19073[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__);

(statearr_19073[(1)] = (1));

return statearr_19073;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1 = (function (state_19057){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19057);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19074){var ex__2417__auto__ = e19074;
var statearr_19075_19087 = state_19057;
(statearr_19075_19087[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19057[(4)]))){
var statearr_19076_19088 = state_19057;
(statearr_19076_19088[(1)] = cljs.core.first((state_19057[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19089 = state_19057;
state_19057 = G__19089;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__ = function(state_19057){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1.call(this,state_19057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19077 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19077[(6)] = c__2436__auto__);

return statearr_19077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__19091 = arguments.length;
switch (G__19091) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__19093 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19093,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19093,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19093,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__19096_SHARP_,p2__19097_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19096_SHARP_,p2__19097_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19163){
var state_val_19164 = (state_19163[(1)]);
if((state_val_19164 === (1))){
var state_19163__$1 = state_19163;
var statearr_19165_19183 = state_19163__$1;
(statearr_19165_19183[(2)] = null);

(statearr_19165_19183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19164 === (2))){
var _ = (function (){var statearr_19166 = state_19163;
(statearr_19166[(4)] = cljs.core.cons((5),(state_19163[(4)])));

return statearr_19166;
})();
var inst_19115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19116 = fluree.db.flake.max_subject_id((1));
var inst_19117 = [inst_19116];
var inst_19118 = (new cljs.core.PersistentVector(null,1,(5),inst_19115,inst_19117,null));
var inst_19119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19120 = [(0)];
var inst_19121 = (new cljs.core.PersistentVector(null,1,(5),inst_19119,inst_19120,null));
var inst_19122 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_19118,cljs.core._LT__EQ_,inst_19121);
var state_19163__$1 = state_19163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19163__$1,(6),inst_19122);
} else {
if((state_val_19164 === (3))){
var inst_19161 = (state_19163[(2)]);
var state_19163__$1 = state_19163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19163__$1,inst_19161);
} else {
if((state_val_19164 === (4))){
var inst_19103 = (state_19163[(2)]);
var state_19163__$1 = state_19163;
var statearr_19168_19184 = state_19163__$1;
(statearr_19168_19184[(2)] = inst_19103);

(statearr_19168_19184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19164 === (5))){
var _ = (function (){var statearr_19169 = state_19163;
(statearr_19169[(4)] = cljs.core.rest((state_19163[(4)])));

return statearr_19169;
})();
var state_19163__$1 = state_19163;
var ex19167 = (state_19163__$1[(2)]);
var statearr_19170_19185 = state_19163__$1;
(statearr_19170_19185[(5)] = ex19167);


if((ex19167 instanceof Error)){
var statearr_19171_19186 = state_19163__$1;
(statearr_19171_19186[(1)] = (4));

(statearr_19171_19186[(5)] = null);

} else {
throw ex19167;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19164 === (6))){
var inst_19124 = (state_19163[(2)]);
var inst_19125 = fluree.db.util.async.throw_err(inst_19124);
var inst_19126 = (function (){var schema_flakes = inst_19125;
return (function (p1__19098_SHARP_){
return (p1__19098_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_19127 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19126,inst_19125);
var inst_19128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19127,(0),null);
var inst_19129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19127,(1),null);
var inst_19130 = (function (){var schema_flakes = inst_19125;
var vec__19109 = inst_19127;
var collection_flakes = inst_19128;
var predicate_flakes = inst_19129;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__19100_SHARP_,p2__19101_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19100_SHARP_,p2__19101_SHARP_.p,p2__19101_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_19131 = [(-1),"_tx"];
var inst_19132 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19133 = ["_tx",(-1),(-1)];
var inst_19134 = cljs.core.PersistentHashMap.fromArrays(inst_19132,inst_19133);
var inst_19135 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19136 = ["_tx",(-1),(-1)];
var inst_19137 = cljs.core.PersistentHashMap.fromArrays(inst_19135,inst_19136);
var inst_19138 = [inst_19134,inst_19137];
var inst_19139 = cljs.core.PersistentHashMap.fromArrays(inst_19131,inst_19138);
var inst_19140 = (function (){var schema_flakes = inst_19125;
var vec__19109 = inst_19127;
var collection_flakes = inst_19128;
var predicate_flakes = inst_19129;
return (function (p1__19099_SHARP_){
return p1__19099_SHARP_.s;
});
})();
var inst_19141 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19140,inst_19128);
var inst_19142 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19130,inst_19139,inst_19141);
var inst_19144 = (function (){var schema_flakes = inst_19125;
var vec__19109 = inst_19127;
var collection_flakes = inst_19128;
var predicate_flakes = inst_19129;
var coll = inst_19142;
return (function (p__19143,pred_flakes){
var vec__19172 = p__19143;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19172,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19172,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__19175 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__19175.cljs$core$IFn$_invoke$arity$1 ? fexpr__19175.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__19175.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_19145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19146 = cljs.core.PersistentHashMap.EMPTY;
var inst_19147 = cljs.core.PersistentHashSet.EMPTY;
var inst_19148 = [inst_19146,inst_19147];
var inst_19149 = (new cljs.core.PersistentVector(null,2,(5),inst_19145,inst_19148,null));
var inst_19150 = (function (){var schema_flakes = inst_19125;
var vec__19109 = inst_19127;
var collection_flakes = inst_19128;
var predicate_flakes = inst_19129;
var coll = inst_19142;
return (function (p1__19102_SHARP_){
return p1__19102_SHARP_.s;
});
})();
var inst_19151 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_19150,inst_19129);
var inst_19152 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_19144,inst_19149,inst_19151);
var inst_19153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19152,(0),null);
var inst_19154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19152,(1),null);
var inst_19155 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_19156 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_19157 = [inst_19156,inst_19142,inst_19153,inst_19154];
var inst_19158 = cljs.core.PersistentHashMap.fromArrays(inst_19155,inst_19157);
var _ = (function (){var statearr_19176 = state_19163;
(statearr_19176[(4)] = cljs.core.rest((state_19163[(4)])));

return statearr_19176;
})();
var state_19163__$1 = state_19163;
var statearr_19177_19187 = state_19163__$1;
(statearr_19177_19187[(2)] = inst_19158);

(statearr_19177_19187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0 = (function (){
var statearr_19178 = [null,null,null,null,null,null,null];
(statearr_19178[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2414__auto__);

(statearr_19178[(1)] = (1));

return statearr_19178;
});
var fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1 = (function (state_19163){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19163);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19179){var ex__2417__auto__ = e19179;
var statearr_19180_19188 = state_19163;
(statearr_19180_19188[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19163[(4)]))){
var statearr_19181_19189 = state_19163;
(statearr_19181_19189[(1)] = cljs.core.first((state_19163[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19190 = state_19163;
state_19163 = G__19190;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__ = function(state_19163){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1.call(this,state_19163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2414__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2414__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19182 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19182[(6)] = c__2436__auto__);

return statearr_19182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_19232){
var state_val_19233 = (state_19232[(1)]);
if((state_val_19233 === (7))){
var inst_19215 = (state_19232[(2)]);
var inst_19216 = fluree.db.query.schema.flake__GT_pred_map(inst_19215);
var inst_19217 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_19218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(114));
var inst_19219 = cljs.core.boolean$(inst_19218);
var inst_19220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(110));
var inst_19221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(117));
var inst_19222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_19221);
var inst_19223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(111));
var inst_19224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(115));
var inst_19225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19216,(112));
var inst_19226 = [inst_19219,inst_19220,inst_19222,inst_19223,inst_19224,inst_19225];
var inst_19227 = cljs.core.PersistentHashMap.fromArrays(inst_19217,inst_19226);
var _ = (function (){var statearr_19234 = state_19232;
(statearr_19234[(4)] = cljs.core.rest((state_19232[(4)])));

return statearr_19234;
})();
var state_19232__$1 = state_19232;
var statearr_19235_19258 = state_19232__$1;
(statearr_19235_19258[(2)] = inst_19227);

(statearr_19235_19258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (1))){
var state_19232__$1 = state_19232;
var statearr_19236_19259 = state_19232__$1;
(statearr_19236_19259[(2)] = null);

(statearr_19236_19259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (4))){
var inst_19191 = (state_19232[(2)]);
var state_19232__$1 = state_19232;
var statearr_19237_19260 = state_19232__$1;
(statearr_19237_19260[(2)] = inst_19191);

(statearr_19237_19260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (6))){
var _ = (function (){var statearr_19238 = state_19232;
(statearr_19238[(4)] = cljs.core.cons((9),(state_19232[(4)])));

return statearr_19238;
})();
var inst_19203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19205 = ["_setting/id","root"];
var inst_19206 = (new cljs.core.PersistentVector(null,2,(5),inst_19204,inst_19205,null));
var inst_19207 = [inst_19206];
var inst_19208 = (new cljs.core.PersistentVector(null,1,(5),inst_19203,inst_19207,null));
var inst_19209 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19208);
var state_19232__$1 = state_19232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19232__$1,(10),inst_19209);
} else {
if((state_val_19233 === (3))){
var inst_19230 = (state_19232[(2)]);
var state_19232__$1 = state_19232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19232__$1,inst_19230);
} else {
if((state_val_19233 === (2))){
var _ = (function (){var statearr_19241 = state_19232;
(statearr_19241[(4)] = cljs.core.cons((5),(state_19232[(4)])));

return statearr_19241;
})();
var state_19232__$1 = state_19232;
var statearr_19242_19261 = state_19232__$1;
(statearr_19242_19261[(2)] = null);

(statearr_19242_19261[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (9))){
var _ = (function (){var statearr_19243 = state_19232;
(statearr_19243[(4)] = cljs.core.rest((state_19232[(4)])));

return statearr_19243;
})();
var state_19232__$1 = state_19232;
var ex19239 = (state_19232__$1[(2)]);
var statearr_19244_19262 = state_19232__$1;
(statearr_19244_19262[(5)] = ex19239);


var statearr_19245_19263 = state_19232__$1;
(statearr_19245_19263[(1)] = (8));

(statearr_19245_19263[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (5))){
var _ = (function (){var statearr_19246 = state_19232;
(statearr_19246[(4)] = cljs.core.rest((state_19232[(4)])));

return statearr_19246;
})();
var state_19232__$1 = state_19232;
var ex19240 = (state_19232__$1[(2)]);
var statearr_19247_19264 = state_19232__$1;
(statearr_19247_19264[(5)] = ex19240);


if((ex19240 instanceof Error)){
var statearr_19248_19265 = state_19232__$1;
(statearr_19248_19265[(1)] = (4));

(statearr_19248_19265[(5)] = null);

} else {
throw ex19240;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (10))){
var inst_19211 = (state_19232[(2)]);
var inst_19212 = fluree.db.util.async.throw_err(inst_19211);
var _ = (function (){var statearr_19249 = state_19232;
(statearr_19249[(4)] = cljs.core.rest((state_19232[(4)])));

return statearr_19249;
})();
var state_19232__$1 = state_19232;
var statearr_19250_19266 = state_19232__$1;
(statearr_19250_19266[(2)] = inst_19212);

(statearr_19250_19266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19233 === (8))){
var inst_19197 = (state_19232[(2)]);
var state_19232__$1 = (function (){var statearr_19251 = state_19232;
(statearr_19251[(7)] = inst_19197);

return statearr_19251;
})();
var statearr_19252_19267 = state_19232__$1;
(statearr_19252_19267[(2)] = null);

(statearr_19252_19267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0 = (function (){
var statearr_19253 = [null,null,null,null,null,null,null,null];
(statearr_19253[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2414__auto__);

(statearr_19253[(1)] = (1));

return statearr_19253;
});
var fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1 = (function (state_19232){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_19232);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e19254){var ex__2417__auto__ = e19254;
var statearr_19255_19268 = state_19232;
(statearr_19255_19268[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_19232[(4)]))){
var statearr_19256_19269 = state_19232;
(statearr_19256_19269[(1)] = cljs.core.first((state_19232[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19270 = state_19232;
state_19232 = G__19270;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__ = function(state_19232){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1.call(this,state_19232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2414__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2414__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_19257 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_19257[(6)] = c__2436__auto__);

return statearr_19257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
