// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__15864 = cljs.core._EQ_;
var expr__15865 = e.getLastErrorCode();
if(cljs.core.truth_((pred__15864.cljs$core$IFn$_invoke$arity$2 ? pred__15864.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__15865) : pred__15864.call(null,goog.net.ErrorCode.NO_ERROR,expr__15865)))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_((pred__15864.cljs$core$IFn$_invoke$arity$2 ? pred__15864.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__15865) : pred__15864.call(null,goog.net.ErrorCode.EXCEPTION,expr__15865)))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_((pred__15864.cljs$core$IFn$_invoke$arity$2 ? pred__15864.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__15865) : pred__15864.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__15865)))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_((pred__15864.cljs$core$IFn$_invoke$arity$2 ? pred__15864.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__15865) : pred__15864.call(null,goog.net.ErrorCode.ABORT,expr__15865)))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_((pred__15864.cljs$core$IFn$_invoke$arity$2 ? pred__15864.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__15865) : pred__15864.call(null,goog.net.ErrorCode.TIMEOUT,expr__15865)))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__15867 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15867,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__15867;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__15868 = opts;
var map__15868__$1 = (((((!((map__15868 == null))))?(((((map__15868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15868):map__15868);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15868__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15868__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15868__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__15870 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__15870__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__15870,headers], 0)):G__15870);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15870__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__15870__$1;
}
})();
try{var G__15872_15878 = url;
var G__15873_15879 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__15874_15880 = "POST";
var G__15875_15881 = fluree.db.util.json.stringify(message);
var G__15876_15882 = cljs.core.clj__GT_js(headers__$1);
var G__15877_15883 = request_timeout;
goog.net.XhrIo.send(G__15872_15878,G__15873_15879,G__15874_15880,G__15875_15881,G__15876_15882,G__15877_15883);
}catch (e15871){var e_15884 = e15871;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_15884);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__15885 = opts;
var map__15885__$1 = (((((!((map__15885 == null))))?(((((map__15885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15885.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15885):map__15885);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15885__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15885__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15885__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15885__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15885__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__15887 = cljs.core.PersistentArrayMap.EMPTY;
var G__15887__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__15887,headers], 0)):G__15887);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15887__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__15887__$1;
}
})();
try{var G__15889_15896 = url;
var G__15890_15897 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__15895 = output_format;
var G__15895__$1 = (((G__15895 instanceof cljs.core.Keyword))?G__15895.fqn:null);
switch (G__15895__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__15891_15898 = "GET";
var G__15892_15899 = body;
var G__15893_15900 = cljs.core.clj__GT_js(headers__$1);
var G__15894_15901 = request_timeout;
goog.net.XhrIo.send(G__15889_15896,G__15890_15897,G__15891_15898,G__15892_15899,G__15893_15900,G__15894_15901);
}catch (e15888){var e_15903 = e15888;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_15903);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__15904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__15904,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__15904;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15937){
var state_val_15938 = (state_15937[(1)]);
if((state_val_15938 === (7))){
var inst_15933 = (state_15937[(2)]);
var state_15937__$1 = state_15937;
var statearr_15939_15964 = state_15937__$1;
(statearr_15939_15964[(2)] = inst_15933);

(statearr_15939_15964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (1))){
var state_15937__$1 = state_15937;
var statearr_15940_15965 = state_15937__$1;
(statearr_15940_15965[(2)] = null);

(statearr_15940_15965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (4))){
var inst_15908 = (state_15937[(7)]);
var inst_15908__$1 = (state_15937[(2)]);
var inst_15909 = (inst_15908__$1 == null);
var state_15937__$1 = (function (){var statearr_15941 = state_15937;
(statearr_15941[(7)] = inst_15908__$1);

return statearr_15941;
})();
if(cljs.core.truth_(inst_15909)){
var statearr_15942_15966 = state_15937__$1;
(statearr_15942_15966[(1)] = (5));

} else {
var statearr_15943_15967 = state_15937__$1;
(statearr_15943_15967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (6))){
var inst_15908 = (state_15937[(7)]);
var inst_15916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15908,(0),null);
var inst_15917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15908,(1),null);
var state_15937__$1 = (function (){var statearr_15944 = state_15937;
(statearr_15944[(8)] = inst_15916);

(statearr_15944[(9)] = inst_15917);

return statearr_15944;
})();
var statearr_15945_15968 = state_15937__$1;
(statearr_15945_15968[(2)] = null);

(statearr_15945_15968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (3))){
var inst_15935 = (state_15937[(2)]);
var state_15937__$1 = state_15937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15937__$1,inst_15935);
} else {
if((state_val_15938 === (2))){
var state_15937__$1 = state_15937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15937__$1,(4),pub_chan);
} else {
if((state_val_15938 === (11))){
var _ = (function (){var statearr_15947 = state_15937;
(statearr_15947[(4)] = cljs.core.rest((state_15937[(4)])));

return statearr_15947;
})();
var state_15937__$1 = state_15937;
var ex15946 = (state_15937__$1[(2)]);
var statearr_15948_15969 = state_15937__$1;
(statearr_15948_15969[(5)] = ex15946);


if((ex15946 instanceof Error)){
var statearr_15949_15970 = state_15937__$1;
(statearr_15949_15970[(1)] = (10));

(statearr_15949_15970[(5)] = null);

} else {
throw ex15946;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (9))){
var inst_15930 = (state_15937[(2)]);
var state_15937__$1 = (function (){var statearr_15950 = state_15937;
(statearr_15950[(10)] = inst_15930);

return statearr_15950;
})();
var statearr_15951_15971 = state_15937__$1;
(statearr_15951_15971[(2)] = null);

(statearr_15951_15971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (5))){
var inst_15911 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_15937__$1 = state_15937;
var statearr_15952_15972 = state_15937__$1;
(statearr_15952_15972[(2)] = inst_15911);

(statearr_15952_15972[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (10))){
var inst_15917 = (state_15937[(9)]);
var inst_15918 = (state_15937[(2)]);
var inst_15919 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_15918,"Websocket send message error:",inst_15918], 0));
var inst_15920 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_15917,false);
var state_15937__$1 = (function (){var statearr_15953 = state_15937;
(statearr_15953[(11)] = inst_15919);

return statearr_15953;
})();
var statearr_15954_15973 = state_15937__$1;
(statearr_15954_15973[(2)] = inst_15920);

(statearr_15954_15973[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15938 === (8))){
var inst_15916 = (state_15937[(8)]);
var inst_15917 = (state_15937[(9)]);
var _ = (function (){var statearr_15955 = state_15937;
(statearr_15955[(4)] = cljs.core.cons((11),(state_15937[(4)])));

return statearr_15955;
})();
var inst_15926 = ws.send(inst_15916);
var inst_15927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_15917,true);
var ___$1 = (function (){var statearr_15956 = state_15937;
(statearr_15956[(4)] = cljs.core.rest((state_15937[(4)])));

return statearr_15956;
})();
var state_15937__$1 = (function (){var statearr_15957 = state_15937;
(statearr_15957[(12)] = inst_15926);

return statearr_15957;
})();
var statearr_15958_15974 = state_15937__$1;
(statearr_15958_15974[(2)] = inst_15927);

(statearr_15958_15974[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0 = (function (){
var statearr_15959 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15959[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__);

(statearr_15959[(1)] = (1));

return statearr_15959;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1 = (function (state_15937){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15937);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15960){var ex__2417__auto__ = e15960;
var statearr_15961_15975 = state_15937;
(statearr_15961_15975[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15937[(4)]))){
var statearr_15962_15976 = state_15937;
(statearr_15962_15976[(1)] = cljs.core.first((state_15937[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15977 = state_15937;
state_15937 = G__15977;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__ = function(state_15937){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1.call(this,state_15937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15963 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15963[(6)] = c__2436__auto__);

return statearr_15963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2436__auto___16016 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_16003){
var state_val_16004 = (state_16003[(1)]);
if((state_val_16004 === (1))){
var inst_15982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15983 = [open_QMARK_,timeout_chan];
var inst_15984 = (new cljs.core.PersistentVector(null,2,(5),inst_15982,inst_15983,null));
var state_16003__$1 = state_16003;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_16003__$1,(2),inst_15984,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_16004 === (2))){
var inst_15986 = (state_16003[(2)]);
var inst_15987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15986,(0),null);
var inst_15988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15986,(1),null);
var inst_15989 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15988,timeout_chan);
var state_16003__$1 = (function (){var statearr_16005 = state_16003;
(statearr_16005[(7)] = inst_15987);

return statearr_16005;
})();
if(inst_15989){
var statearr_16006_16017 = state_16003__$1;
(statearr_16006_16017[(1)] = (3));

} else {
var statearr_16007_16018 = state_16003__$1;
(statearr_16007_16018[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16004 === (3))){
var inst_15991 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_15992 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15993 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_15994 = cljs.core.PersistentHashMap.fromArrays(inst_15992,inst_15993);
var inst_15995 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15991,inst_15994);
var inst_15996 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_15995);
var inst_15997 = fluree.db.util.xhttp.close_websocket(ws);
var state_16003__$1 = (function (){var statearr_16008 = state_16003;
(statearr_16008[(8)] = inst_15996);

return statearr_16008;
})();
var statearr_16009_16019 = state_16003__$1;
(statearr_16009_16019[(2)] = inst_15997);

(statearr_16009_16019[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16004 === (4))){
var inst_15999 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_16003__$1 = state_16003;
var statearr_16010_16020 = state_16003__$1;
(statearr_16010_16020[(2)] = inst_15999);

(statearr_16010_16020[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16004 === (5))){
var inst_16001 = (state_16003[(2)]);
var state_16003__$1 = state_16003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16003__$1,inst_16001);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0 = (function (){
var statearr_16011 = [null,null,null,null,null,null,null,null,null];
(statearr_16011[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__);

(statearr_16011[(1)] = (1));

return statearr_16011;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1 = (function (state_16003){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_16003);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e16012){var ex__2417__auto__ = e16012;
var statearr_16013_16021 = state_16003;
(statearr_16013_16021[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_16003[(4)]))){
var statearr_16014_16022 = state_16003;
(statearr_16014_16022[(1)] = cljs.core.first((state_16003[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16023 = state_16003;
state_16003 = G__16023;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__ = function(state_16003){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1.call(this,state_16003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_16015 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_16015[(6)] = c__2436__auto___16016);

return statearr_16015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
