// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__16435 = arguments.length;
switch (G__16435) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16436 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16436 = (function (f,blockable,meta16437){
this.f = f;
this.blockable = blockable;
this.meta16437 = meta16437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16438,meta16437__$1){
var self__ = this;
var _16438__$1 = this;
return (new cljs.core.async.t_cljs$core$async16436(self__.f,self__.blockable,meta16437__$1));
}));

(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16438){
var self__ = this;
var _16438__$1 = this;
return self__.meta16437;
}));

(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async16436.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async16436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta16437], null);
}));

(cljs.core.async.t_cljs$core$async16436.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16436.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16436");

(cljs.core.async.t_cljs$core$async16436.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async16436");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16436.
 */
cljs.core.async.__GT_t_cljs$core$async16436 = (function cljs$core$async$__GT_t_cljs$core$async16436(f__$1,blockable__$1,meta16437){
return (new cljs.core.async.t_cljs$core$async16436(f__$1,blockable__$1,meta16437));
});

}

return (new cljs.core.async.t_cljs$core$async16436(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__16442 = arguments.length;
switch (G__16442) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__16445 = arguments.length;
switch (G__16445) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__16448 = arguments.length;
switch (G__16448) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_16450 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16450) : fn1.call(null,val_16450));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_16450) : fn1.call(null,val_16450));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__16452 = arguments.length;
switch (G__16452) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___16454 = n;
var x_16455 = (0);
while(true){
if((x_16455 < n__4613__auto___16454)){
(a[x_16455] = x_16455);

var G__16456 = (x_16455 + (1));
x_16455 = G__16456;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16457 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16457 = (function (flag,meta16458){
this.flag = flag;
this.meta16458 = meta16458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16459,meta16458__$1){
var self__ = this;
var _16459__$1 = this;
return (new cljs.core.async.t_cljs$core$async16457(self__.flag,meta16458__$1));
}));

(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16459){
var self__ = this;
var _16459__$1 = this;
return self__.meta16458;
}));

(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16457.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async16457.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta16458], null);
}));

(cljs.core.async.t_cljs$core$async16457.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16457.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16457");

(cljs.core.async.t_cljs$core$async16457.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async16457");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16457.
 */
cljs.core.async.__GT_t_cljs$core$async16457 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16457(flag__$1,meta16458){
return (new cljs.core.async.t_cljs$core$async16457(flag__$1,meta16458));
});

}

return (new cljs.core.async.t_cljs$core$async16457(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16460 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16460 = (function (flag,cb,meta16461){
this.flag = flag;
this.cb = cb;
this.meta16461 = meta16461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16462,meta16461__$1){
var self__ = this;
var _16462__$1 = this;
return (new cljs.core.async.t_cljs$core$async16460(self__.flag,self__.cb,meta16461__$1));
}));

(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16462){
var self__ = this;
var _16462__$1 = this;
return self__.meta16461;
}));

(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16460.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async16460.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta16461], null);
}));

(cljs.core.async.t_cljs$core$async16460.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16460");

(cljs.core.async.t_cljs$core$async16460.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async16460");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16460.
 */
cljs.core.async.__GT_t_cljs$core$async16460 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16460(flag__$1,cb__$1,meta16461){
return (new cljs.core.async.t_cljs$core$async16460(flag__$1,cb__$1,meta16461));
});

}

return (new cljs.core.async.t_cljs$core$async16460(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16463_SHARP_){
var G__16465 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16463_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16465) : fret.call(null,G__16465));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16464_SHARP_){
var G__16466 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16464_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__16466) : fret.call(null,G__16466));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16467 = (i + (1));
i = G__16467;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___16473 = arguments.length;
var i__4737__auto___16474 = (0);
while(true){
if((i__4737__auto___16474 < len__4736__auto___16473)){
args__4742__auto__.push((arguments[i__4737__auto___16474]));

var G__16475 = (i__4737__auto___16474 + (1));
i__4737__auto___16474 = G__16475;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16470){
var map__16471 = p__16470;
var map__16471__$1 = (((((!((map__16471 == null))))?(((((map__16471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16471):map__16471);
var opts = map__16471__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16468){
var G__16469 = cljs.core.first(seq16468);
var seq16468__$1 = cljs.core.next(seq16468);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16469,seq16468__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__16477 = arguments.length;
switch (G__16477) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16375__auto___16524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16501){
var state_val_16502 = (state_16501[(1)]);
if((state_val_16502 === (7))){
var inst_16497 = (state_16501[(2)]);
var state_16501__$1 = state_16501;
var statearr_16503_16525 = state_16501__$1;
(statearr_16503_16525[(2)] = inst_16497);

(statearr_16503_16525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (1))){
var state_16501__$1 = state_16501;
var statearr_16504_16526 = state_16501__$1;
(statearr_16504_16526[(2)] = null);

(statearr_16504_16526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (4))){
var inst_16480 = (state_16501[(7)]);
var inst_16480__$1 = (state_16501[(2)]);
var inst_16481 = (inst_16480__$1 == null);
var state_16501__$1 = (function (){var statearr_16505 = state_16501;
(statearr_16505[(7)] = inst_16480__$1);

return statearr_16505;
})();
if(cljs.core.truth_(inst_16481)){
var statearr_16506_16527 = state_16501__$1;
(statearr_16506_16527[(1)] = (5));

} else {
var statearr_16507_16528 = state_16501__$1;
(statearr_16507_16528[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (13))){
var state_16501__$1 = state_16501;
var statearr_16508_16529 = state_16501__$1;
(statearr_16508_16529[(2)] = null);

(statearr_16508_16529[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (6))){
var inst_16480 = (state_16501[(7)]);
var state_16501__$1 = state_16501;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16501__$1,(11),to,inst_16480);
} else {
if((state_val_16502 === (3))){
var inst_16499 = (state_16501[(2)]);
var state_16501__$1 = state_16501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16501__$1,inst_16499);
} else {
if((state_val_16502 === (12))){
var state_16501__$1 = state_16501;
var statearr_16509_16530 = state_16501__$1;
(statearr_16509_16530[(2)] = null);

(statearr_16509_16530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (2))){
var state_16501__$1 = state_16501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16501__$1,(4),from);
} else {
if((state_val_16502 === (11))){
var inst_16490 = (state_16501[(2)]);
var state_16501__$1 = state_16501;
if(cljs.core.truth_(inst_16490)){
var statearr_16510_16531 = state_16501__$1;
(statearr_16510_16531[(1)] = (12));

} else {
var statearr_16511_16532 = state_16501__$1;
(statearr_16511_16532[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (9))){
var state_16501__$1 = state_16501;
var statearr_16512_16533 = state_16501__$1;
(statearr_16512_16533[(2)] = null);

(statearr_16512_16533[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (5))){
var state_16501__$1 = state_16501;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16513_16534 = state_16501__$1;
(statearr_16513_16534[(1)] = (8));

} else {
var statearr_16514_16535 = state_16501__$1;
(statearr_16514_16535[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (14))){
var inst_16495 = (state_16501[(2)]);
var state_16501__$1 = state_16501;
var statearr_16515_16536 = state_16501__$1;
(statearr_16515_16536[(2)] = inst_16495);

(statearr_16515_16536[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (10))){
var inst_16487 = (state_16501[(2)]);
var state_16501__$1 = state_16501;
var statearr_16516_16537 = state_16501__$1;
(statearr_16516_16537[(2)] = inst_16487);

(statearr_16516_16537[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16502 === (8))){
var inst_16484 = cljs.core.async.close_BANG_(to);
var state_16501__$1 = state_16501;
var statearr_16517_16538 = state_16501__$1;
(statearr_16517_16538[(2)] = inst_16484);

(statearr_16517_16538[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_16518 = [null,null,null,null,null,null,null,null];
(statearr_16518[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_16518[(1)] = (1));

return statearr_16518;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_16501){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16501);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16519){var ex__16304__auto__ = e16519;
var statearr_16520_16539 = state_16501;
(statearr_16520_16539[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16501[(4)]))){
var statearr_16521_16540 = state_16501;
(statearr_16521_16540[(1)] = cljs.core.first((state_16501[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16541 = state_16501;
state_16501 = G__16541;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_16501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_16501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16522 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16522[(6)] = c__16375__auto___16524);

return statearr_16522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__16542){
var vec__16543 = p__16542;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16543,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16543,(1),null);
var job = vec__16543;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16375__auto___16719 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16550){
var state_val_16551 = (state_16550[(1)]);
if((state_val_16551 === (1))){
var state_16550__$1 = state_16550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16550__$1,(2),res,v);
} else {
if((state_val_16551 === (2))){
var inst_16547 = (state_16550[(2)]);
var inst_16548 = cljs.core.async.close_BANG_(res);
var state_16550__$1 = (function (){var statearr_16552 = state_16550;
(statearr_16552[(7)] = inst_16547);

return statearr_16552;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16550__$1,inst_16548);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_16553 = [null,null,null,null,null,null,null,null];
(statearr_16553[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__);

(statearr_16553[(1)] = (1));

return statearr_16553;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1 = (function (state_16550){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16550);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16554){var ex__16304__auto__ = e16554;
var statearr_16555_16720 = state_16550;
(statearr_16555_16720[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16550[(4)]))){
var statearr_16556_16721 = state_16550;
(statearr_16556_16721[(1)] = cljs.core.first((state_16550[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16722 = state_16550;
state_16550 = G__16722;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = function(state_16550){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1.call(this,state_16550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16557 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16557[(6)] = c__16375__auto___16719);

return statearr_16557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__16558){
var vec__16559 = p__16558;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16559,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16559,(1),null);
var job = vec__16559;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___16723 = n;
var __16724 = (0);
while(true){
if((__16724 < n__4613__auto___16723)){
var G__16562_16725 = type;
var G__16562_16726__$1 = (((G__16562_16725 instanceof cljs.core.Keyword))?G__16562_16725.fqn:null);
switch (G__16562_16726__$1) {
case "compute":
var c__16375__auto___16728 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16724,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = ((function (__16724,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function (state_16575){
var state_val_16576 = (state_16575[(1)]);
if((state_val_16576 === (1))){
var state_16575__$1 = state_16575;
var statearr_16577_16729 = state_16575__$1;
(statearr_16577_16729[(2)] = null);

(statearr_16577_16729[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16576 === (2))){
var state_16575__$1 = state_16575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16575__$1,(4),jobs);
} else {
if((state_val_16576 === (3))){
var inst_16573 = (state_16575[(2)]);
var state_16575__$1 = state_16575;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16575__$1,inst_16573);
} else {
if((state_val_16576 === (4))){
var inst_16565 = (state_16575[(2)]);
var inst_16566 = process(inst_16565);
var state_16575__$1 = state_16575;
if(cljs.core.truth_(inst_16566)){
var statearr_16578_16730 = state_16575__$1;
(statearr_16578_16730[(1)] = (5));

} else {
var statearr_16579_16731 = state_16575__$1;
(statearr_16579_16731[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16576 === (5))){
var state_16575__$1 = state_16575;
var statearr_16580_16732 = state_16575__$1;
(statearr_16580_16732[(2)] = null);

(statearr_16580_16732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16576 === (6))){
var state_16575__$1 = state_16575;
var statearr_16581_16733 = state_16575__$1;
(statearr_16581_16733[(2)] = null);

(statearr_16581_16733[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16576 === (7))){
var inst_16571 = (state_16575[(2)]);
var state_16575__$1 = state_16575;
var statearr_16582_16734 = state_16575__$1;
(statearr_16582_16734[(2)] = inst_16571);

(statearr_16582_16734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16724,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
;
return ((function (__16724,switch__16300__auto__,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_16583 = [null,null,null,null,null,null,null];
(statearr_16583[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__);

(statearr_16583[(1)] = (1));

return statearr_16583;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1 = (function (state_16575){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16575);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16584){var ex__16304__auto__ = e16584;
var statearr_16585_16735 = state_16575;
(statearr_16585_16735[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16575[(4)]))){
var statearr_16586_16736 = state_16575;
(statearr_16586_16736[(1)] = cljs.core.first((state_16575[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16737 = state_16575;
state_16575 = G__16737;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = function(state_16575){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1.call(this,state_16575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__;
})()
;})(__16724,switch__16300__auto__,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
})();
var state__16377__auto__ = (function (){var statearr_16587 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16587[(6)] = c__16375__auto___16728);

return statearr_16587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
});})(__16724,c__16375__auto___16728,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
);


break;
case "async":
var c__16375__auto___16738 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__16724,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = ((function (__16724,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function (state_16600){
var state_val_16601 = (state_16600[(1)]);
if((state_val_16601 === (1))){
var state_16600__$1 = state_16600;
var statearr_16602_16739 = state_16600__$1;
(statearr_16602_16739[(2)] = null);

(statearr_16602_16739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16601 === (2))){
var state_16600__$1 = state_16600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16600__$1,(4),jobs);
} else {
if((state_val_16601 === (3))){
var inst_16598 = (state_16600[(2)]);
var state_16600__$1 = state_16600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16600__$1,inst_16598);
} else {
if((state_val_16601 === (4))){
var inst_16590 = (state_16600[(2)]);
var inst_16591 = async(inst_16590);
var state_16600__$1 = state_16600;
if(cljs.core.truth_(inst_16591)){
var statearr_16603_16740 = state_16600__$1;
(statearr_16603_16740[(1)] = (5));

} else {
var statearr_16604_16741 = state_16600__$1;
(statearr_16604_16741[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16601 === (5))){
var state_16600__$1 = state_16600;
var statearr_16605_16742 = state_16600__$1;
(statearr_16605_16742[(2)] = null);

(statearr_16605_16742[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16601 === (6))){
var state_16600__$1 = state_16600;
var statearr_16606_16743 = state_16600__$1;
(statearr_16606_16743[(2)] = null);

(statearr_16606_16743[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16601 === (7))){
var inst_16596 = (state_16600[(2)]);
var state_16600__$1 = state_16600;
var statearr_16607_16744 = state_16600__$1;
(statearr_16607_16744[(2)] = inst_16596);

(statearr_16607_16744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__16724,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
;
return ((function (__16724,switch__16300__auto__,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_16608 = [null,null,null,null,null,null,null];
(statearr_16608[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__);

(statearr_16608[(1)] = (1));

return statearr_16608;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1 = (function (state_16600){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16600);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16609){var ex__16304__auto__ = e16609;
var statearr_16610_16745 = state_16600;
(statearr_16610_16745[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16600[(4)]))){
var statearr_16611_16746 = state_16600;
(statearr_16611_16746[(1)] = cljs.core.first((state_16600[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16747 = state_16600;
state_16600 = G__16747;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = function(state_16600){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1.call(this,state_16600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__;
})()
;})(__16724,switch__16300__auto__,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
})();
var state__16377__auto__ = (function (){var statearr_16612 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16612[(6)] = c__16375__auto___16738);

return statearr_16612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
});})(__16724,c__16375__auto___16738,G__16562_16725,G__16562_16726__$1,n__4613__auto___16723,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__16562_16726__$1)].join('')));

}

var G__16748 = (__16724 + (1));
__16724 = G__16748;
continue;
} else {
}
break;
}

var c__16375__auto___16749 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16634){
var state_val_16635 = (state_16634[(1)]);
if((state_val_16635 === (7))){
var inst_16630 = (state_16634[(2)]);
var state_16634__$1 = state_16634;
var statearr_16636_16750 = state_16634__$1;
(statearr_16636_16750[(2)] = inst_16630);

(statearr_16636_16750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16635 === (1))){
var state_16634__$1 = state_16634;
var statearr_16637_16751 = state_16634__$1;
(statearr_16637_16751[(2)] = null);

(statearr_16637_16751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16635 === (4))){
var inst_16615 = (state_16634[(7)]);
var inst_16615__$1 = (state_16634[(2)]);
var inst_16616 = (inst_16615__$1 == null);
var state_16634__$1 = (function (){var statearr_16638 = state_16634;
(statearr_16638[(7)] = inst_16615__$1);

return statearr_16638;
})();
if(cljs.core.truth_(inst_16616)){
var statearr_16639_16752 = state_16634__$1;
(statearr_16639_16752[(1)] = (5));

} else {
var statearr_16640_16753 = state_16634__$1;
(statearr_16640_16753[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16635 === (6))){
var inst_16620 = (state_16634[(8)]);
var inst_16615 = (state_16634[(7)]);
var inst_16620__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_16621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16622 = [inst_16615,inst_16620__$1];
var inst_16623 = (new cljs.core.PersistentVector(null,2,(5),inst_16621,inst_16622,null));
var state_16634__$1 = (function (){var statearr_16641 = state_16634;
(statearr_16641[(8)] = inst_16620__$1);

return statearr_16641;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16634__$1,(8),jobs,inst_16623);
} else {
if((state_val_16635 === (3))){
var inst_16632 = (state_16634[(2)]);
var state_16634__$1 = state_16634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16634__$1,inst_16632);
} else {
if((state_val_16635 === (2))){
var state_16634__$1 = state_16634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16634__$1,(4),from);
} else {
if((state_val_16635 === (9))){
var inst_16627 = (state_16634[(2)]);
var state_16634__$1 = (function (){var statearr_16642 = state_16634;
(statearr_16642[(9)] = inst_16627);

return statearr_16642;
})();
var statearr_16643_16754 = state_16634__$1;
(statearr_16643_16754[(2)] = null);

(statearr_16643_16754[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16635 === (5))){
var inst_16618 = cljs.core.async.close_BANG_(jobs);
var state_16634__$1 = state_16634;
var statearr_16644_16755 = state_16634__$1;
(statearr_16644_16755[(2)] = inst_16618);

(statearr_16644_16755[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16635 === (8))){
var inst_16620 = (state_16634[(8)]);
var inst_16625 = (state_16634[(2)]);
var state_16634__$1 = (function (){var statearr_16645 = state_16634;
(statearr_16645[(10)] = inst_16625);

return statearr_16645;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16634__$1,(9),results,inst_16620);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_16646 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16646[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__);

(statearr_16646[(1)] = (1));

return statearr_16646;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1 = (function (state_16634){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16634);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16647){var ex__16304__auto__ = e16647;
var statearr_16648_16756 = state_16634;
(statearr_16648_16756[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16634[(4)]))){
var statearr_16649_16757 = state_16634;
(statearr_16649_16757[(1)] = cljs.core.first((state_16634[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16758 = state_16634;
state_16634 = G__16758;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = function(state_16634){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1.call(this,state_16634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16650 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16650[(6)] = c__16375__auto___16749);

return statearr_16650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16688){
var state_val_16689 = (state_16688[(1)]);
if((state_val_16689 === (7))){
var inst_16684 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16690_16759 = state_16688__$1;
(statearr_16690_16759[(2)] = inst_16684);

(statearr_16690_16759[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (20))){
var state_16688__$1 = state_16688;
var statearr_16691_16760 = state_16688__$1;
(statearr_16691_16760[(2)] = null);

(statearr_16691_16760[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (1))){
var state_16688__$1 = state_16688;
var statearr_16692_16761 = state_16688__$1;
(statearr_16692_16761[(2)] = null);

(statearr_16692_16761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (4))){
var inst_16653 = (state_16688[(7)]);
var inst_16653__$1 = (state_16688[(2)]);
var inst_16654 = (inst_16653__$1 == null);
var state_16688__$1 = (function (){var statearr_16693 = state_16688;
(statearr_16693[(7)] = inst_16653__$1);

return statearr_16693;
})();
if(cljs.core.truth_(inst_16654)){
var statearr_16694_16762 = state_16688__$1;
(statearr_16694_16762[(1)] = (5));

} else {
var statearr_16695_16763 = state_16688__$1;
(statearr_16695_16763[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (15))){
var inst_16666 = (state_16688[(8)]);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16688__$1,(18),to,inst_16666);
} else {
if((state_val_16689 === (21))){
var inst_16679 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16696_16764 = state_16688__$1;
(statearr_16696_16764[(2)] = inst_16679);

(statearr_16696_16764[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (13))){
var inst_16681 = (state_16688[(2)]);
var state_16688__$1 = (function (){var statearr_16697 = state_16688;
(statearr_16697[(9)] = inst_16681);

return statearr_16697;
})();
var statearr_16698_16765 = state_16688__$1;
(statearr_16698_16765[(2)] = null);

(statearr_16698_16765[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (6))){
var inst_16653 = (state_16688[(7)]);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16688__$1,(11),inst_16653);
} else {
if((state_val_16689 === (17))){
var inst_16674 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
if(cljs.core.truth_(inst_16674)){
var statearr_16699_16766 = state_16688__$1;
(statearr_16699_16766[(1)] = (19));

} else {
var statearr_16700_16767 = state_16688__$1;
(statearr_16700_16767[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (3))){
var inst_16686 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16688__$1,inst_16686);
} else {
if((state_val_16689 === (12))){
var inst_16663 = (state_16688[(10)]);
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16688__$1,(14),inst_16663);
} else {
if((state_val_16689 === (2))){
var state_16688__$1 = state_16688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16688__$1,(4),results);
} else {
if((state_val_16689 === (19))){
var state_16688__$1 = state_16688;
var statearr_16701_16768 = state_16688__$1;
(statearr_16701_16768[(2)] = null);

(statearr_16701_16768[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (11))){
var inst_16663 = (state_16688[(2)]);
var state_16688__$1 = (function (){var statearr_16702 = state_16688;
(statearr_16702[(10)] = inst_16663);

return statearr_16702;
})();
var statearr_16703_16769 = state_16688__$1;
(statearr_16703_16769[(2)] = null);

(statearr_16703_16769[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (9))){
var state_16688__$1 = state_16688;
var statearr_16704_16770 = state_16688__$1;
(statearr_16704_16770[(2)] = null);

(statearr_16704_16770[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (5))){
var state_16688__$1 = state_16688;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16705_16771 = state_16688__$1;
(statearr_16705_16771[(1)] = (8));

} else {
var statearr_16706_16772 = state_16688__$1;
(statearr_16706_16772[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (14))){
var inst_16666 = (state_16688[(8)]);
var inst_16666__$1 = (state_16688[(2)]);
var inst_16667 = (inst_16666__$1 == null);
var inst_16668 = cljs.core.not(inst_16667);
var state_16688__$1 = (function (){var statearr_16707 = state_16688;
(statearr_16707[(8)] = inst_16666__$1);

return statearr_16707;
})();
if(inst_16668){
var statearr_16708_16773 = state_16688__$1;
(statearr_16708_16773[(1)] = (15));

} else {
var statearr_16709_16774 = state_16688__$1;
(statearr_16709_16774[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (16))){
var state_16688__$1 = state_16688;
var statearr_16710_16775 = state_16688__$1;
(statearr_16710_16775[(2)] = false);

(statearr_16710_16775[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (10))){
var inst_16660 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16711_16776 = state_16688__$1;
(statearr_16711_16776[(2)] = inst_16660);

(statearr_16711_16776[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (18))){
var inst_16671 = (state_16688[(2)]);
var state_16688__$1 = state_16688;
var statearr_16712_16777 = state_16688__$1;
(statearr_16712_16777[(2)] = inst_16671);

(statearr_16712_16777[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16689 === (8))){
var inst_16657 = cljs.core.async.close_BANG_(to);
var state_16688__$1 = state_16688;
var statearr_16713_16778 = state_16688__$1;
(statearr_16713_16778[(2)] = inst_16657);

(statearr_16713_16778[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_16714 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16714[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__);

(statearr_16714[(1)] = (1));

return statearr_16714;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1 = (function (state_16688){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16688);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16715){var ex__16304__auto__ = e16715;
var statearr_16716_16779 = state_16688;
(statearr_16716_16779[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16688[(4)]))){
var statearr_16717_16780 = state_16688;
(statearr_16717_16780[(1)] = cljs.core.first((state_16688[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16781 = state_16688;
state_16688 = G__16781;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__ = function(state_16688){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1.call(this,state_16688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16718 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16718[(6)] = c__16375__auto__);

return statearr_16718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__16783 = arguments.length;
switch (G__16783) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__16786 = arguments.length;
switch (G__16786) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__16789 = arguments.length;
switch (G__16789) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16375__auto___16839 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16815){
var state_val_16816 = (state_16815[(1)]);
if((state_val_16816 === (7))){
var inst_16811 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16817_16840 = state_16815__$1;
(statearr_16817_16840[(2)] = inst_16811);

(statearr_16817_16840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (1))){
var state_16815__$1 = state_16815;
var statearr_16818_16841 = state_16815__$1;
(statearr_16818_16841[(2)] = null);

(statearr_16818_16841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (4))){
var inst_16792 = (state_16815[(7)]);
var inst_16792__$1 = (state_16815[(2)]);
var inst_16793 = (inst_16792__$1 == null);
var state_16815__$1 = (function (){var statearr_16819 = state_16815;
(statearr_16819[(7)] = inst_16792__$1);

return statearr_16819;
})();
if(cljs.core.truth_(inst_16793)){
var statearr_16820_16842 = state_16815__$1;
(statearr_16820_16842[(1)] = (5));

} else {
var statearr_16821_16843 = state_16815__$1;
(statearr_16821_16843[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (13))){
var state_16815__$1 = state_16815;
var statearr_16822_16844 = state_16815__$1;
(statearr_16822_16844[(2)] = null);

(statearr_16822_16844[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (6))){
var inst_16792 = (state_16815[(7)]);
var inst_16798 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16792) : p.call(null,inst_16792));
var state_16815__$1 = state_16815;
if(cljs.core.truth_(inst_16798)){
var statearr_16823_16845 = state_16815__$1;
(statearr_16823_16845[(1)] = (9));

} else {
var statearr_16824_16846 = state_16815__$1;
(statearr_16824_16846[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (3))){
var inst_16813 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16815__$1,inst_16813);
} else {
if((state_val_16816 === (12))){
var state_16815__$1 = state_16815;
var statearr_16825_16847 = state_16815__$1;
(statearr_16825_16847[(2)] = null);

(statearr_16825_16847[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (2))){
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16815__$1,(4),ch);
} else {
if((state_val_16816 === (11))){
var inst_16792 = (state_16815[(7)]);
var inst_16802 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16815__$1,(8),inst_16802,inst_16792);
} else {
if((state_val_16816 === (9))){
var state_16815__$1 = state_16815;
var statearr_16826_16848 = state_16815__$1;
(statearr_16826_16848[(2)] = tc);

(statearr_16826_16848[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (5))){
var inst_16795 = cljs.core.async.close_BANG_(tc);
var inst_16796 = cljs.core.async.close_BANG_(fc);
var state_16815__$1 = (function (){var statearr_16827 = state_16815;
(statearr_16827[(8)] = inst_16795);

return statearr_16827;
})();
var statearr_16828_16849 = state_16815__$1;
(statearr_16828_16849[(2)] = inst_16796);

(statearr_16828_16849[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (14))){
var inst_16809 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
var statearr_16829_16850 = state_16815__$1;
(statearr_16829_16850[(2)] = inst_16809);

(statearr_16829_16850[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (10))){
var state_16815__$1 = state_16815;
var statearr_16830_16851 = state_16815__$1;
(statearr_16830_16851[(2)] = fc);

(statearr_16830_16851[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16816 === (8))){
var inst_16804 = (state_16815[(2)]);
var state_16815__$1 = state_16815;
if(cljs.core.truth_(inst_16804)){
var statearr_16831_16852 = state_16815__$1;
(statearr_16831_16852[(1)] = (12));

} else {
var statearr_16832_16853 = state_16815__$1;
(statearr_16832_16853[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_16833 = [null,null,null,null,null,null,null,null,null];
(statearr_16833[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_16833[(1)] = (1));

return statearr_16833;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_16815){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16815);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16834){var ex__16304__auto__ = e16834;
var statearr_16835_16854 = state_16815;
(statearr_16835_16854[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16815[(4)]))){
var statearr_16836_16855 = state_16815;
(statearr_16836_16855[(1)] = cljs.core.first((state_16815[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16856 = state_16815;
state_16815 = G__16856;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_16815){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_16815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16837 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16837[(6)] = c__16375__auto___16839);

return statearr_16837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16878){
var state_val_16879 = (state_16878[(1)]);
if((state_val_16879 === (7))){
var inst_16874 = (state_16878[(2)]);
var state_16878__$1 = state_16878;
var statearr_16880_16899 = state_16878__$1;
(statearr_16880_16899[(2)] = inst_16874);

(statearr_16880_16899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (1))){
var inst_16857 = init;
var inst_16858 = inst_16857;
var state_16878__$1 = (function (){var statearr_16881 = state_16878;
(statearr_16881[(7)] = inst_16858);

return statearr_16881;
})();
var statearr_16882_16900 = state_16878__$1;
(statearr_16882_16900[(2)] = null);

(statearr_16882_16900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (4))){
var inst_16861 = (state_16878[(8)]);
var inst_16861__$1 = (state_16878[(2)]);
var inst_16862 = (inst_16861__$1 == null);
var state_16878__$1 = (function (){var statearr_16883 = state_16878;
(statearr_16883[(8)] = inst_16861__$1);

return statearr_16883;
})();
if(cljs.core.truth_(inst_16862)){
var statearr_16884_16901 = state_16878__$1;
(statearr_16884_16901[(1)] = (5));

} else {
var statearr_16885_16902 = state_16878__$1;
(statearr_16885_16902[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (6))){
var inst_16865 = (state_16878[(9)]);
var inst_16858 = (state_16878[(7)]);
var inst_16861 = (state_16878[(8)]);
var inst_16865__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_16858,inst_16861) : f.call(null,inst_16858,inst_16861));
var inst_16866 = cljs.core.reduced_QMARK_(inst_16865__$1);
var state_16878__$1 = (function (){var statearr_16886 = state_16878;
(statearr_16886[(9)] = inst_16865__$1);

return statearr_16886;
})();
if(inst_16866){
var statearr_16887_16903 = state_16878__$1;
(statearr_16887_16903[(1)] = (8));

} else {
var statearr_16888_16904 = state_16878__$1;
(statearr_16888_16904[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (3))){
var inst_16876 = (state_16878[(2)]);
var state_16878__$1 = state_16878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16878__$1,inst_16876);
} else {
if((state_val_16879 === (2))){
var state_16878__$1 = state_16878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16878__$1,(4),ch);
} else {
if((state_val_16879 === (9))){
var inst_16865 = (state_16878[(9)]);
var inst_16858 = inst_16865;
var state_16878__$1 = (function (){var statearr_16889 = state_16878;
(statearr_16889[(7)] = inst_16858);

return statearr_16889;
})();
var statearr_16890_16905 = state_16878__$1;
(statearr_16890_16905[(2)] = null);

(statearr_16890_16905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (5))){
var inst_16858 = (state_16878[(7)]);
var state_16878__$1 = state_16878;
var statearr_16891_16906 = state_16878__$1;
(statearr_16891_16906[(2)] = inst_16858);

(statearr_16891_16906[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (10))){
var inst_16872 = (state_16878[(2)]);
var state_16878__$1 = state_16878;
var statearr_16892_16907 = state_16878__$1;
(statearr_16892_16907[(2)] = inst_16872);

(statearr_16892_16907[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16879 === (8))){
var inst_16865 = (state_16878[(9)]);
var inst_16868 = cljs.core.deref(inst_16865);
var state_16878__$1 = state_16878;
var statearr_16893_16908 = state_16878__$1;
(statearr_16893_16908[(2)] = inst_16868);

(statearr_16893_16908[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__16301__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16301__auto____0 = (function (){
var statearr_16894 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16894[(0)] = cljs$core$async$reduce_$_state_machine__16301__auto__);

(statearr_16894[(1)] = (1));

return statearr_16894;
});
var cljs$core$async$reduce_$_state_machine__16301__auto____1 = (function (state_16878){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16878);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16895){var ex__16304__auto__ = e16895;
var statearr_16896_16909 = state_16878;
(statearr_16896_16909[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16878[(4)]))){
var statearr_16897_16910 = state_16878;
(statearr_16897_16910[(1)] = cljs.core.first((state_16878[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16911 = state_16878;
state_16878 = G__16911;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16301__auto__ = function(state_16878){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16301__auto____1.call(this,state_16878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16301__auto____0;
cljs$core$async$reduce_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16301__auto____1;
return cljs$core$async$reduce_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16898 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16898[(6)] = c__16375__auto__);

return statearr_16898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16917){
var state_val_16918 = (state_16917[(1)]);
if((state_val_16918 === (1))){
var inst_16912 = cljs.core.async.reduce(f__$1,init,ch);
var state_16917__$1 = state_16917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16917__$1,(2),inst_16912);
} else {
if((state_val_16918 === (2))){
var inst_16914 = (state_16917[(2)]);
var inst_16915 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_16914) : f__$1.call(null,inst_16914));
var state_16917__$1 = state_16917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16917__$1,inst_16915);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__16301__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16301__auto____0 = (function (){
var statearr_16919 = [null,null,null,null,null,null,null];
(statearr_16919[(0)] = cljs$core$async$transduce_$_state_machine__16301__auto__);

(statearr_16919[(1)] = (1));

return statearr_16919;
});
var cljs$core$async$transduce_$_state_machine__16301__auto____1 = (function (state_16917){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16917);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16920){var ex__16304__auto__ = e16920;
var statearr_16921_16924 = state_16917;
(statearr_16921_16924[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16917[(4)]))){
var statearr_16922_16925 = state_16917;
(statearr_16922_16925[(1)] = cljs.core.first((state_16917[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16926 = state_16917;
state_16917 = G__16926;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16301__auto__ = function(state_16917){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16301__auto____1.call(this,state_16917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16301__auto____0;
cljs$core$async$transduce_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16301__auto____1;
return cljs$core$async$transduce_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16923 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16923[(6)] = c__16375__auto__);

return statearr_16923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__16928 = arguments.length;
switch (G__16928) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_16953){
var state_val_16954 = (state_16953[(1)]);
if((state_val_16954 === (7))){
var inst_16935 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
var statearr_16955_16977 = state_16953__$1;
(statearr_16955_16977[(2)] = inst_16935);

(statearr_16955_16977[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (1))){
var inst_16929 = cljs.core.seq(coll);
var inst_16930 = inst_16929;
var state_16953__$1 = (function (){var statearr_16956 = state_16953;
(statearr_16956[(7)] = inst_16930);

return statearr_16956;
})();
var statearr_16957_16978 = state_16953__$1;
(statearr_16957_16978[(2)] = null);

(statearr_16957_16978[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (4))){
var inst_16930 = (state_16953[(7)]);
var inst_16933 = cljs.core.first(inst_16930);
var state_16953__$1 = state_16953;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16953__$1,(7),ch,inst_16933);
} else {
if((state_val_16954 === (13))){
var inst_16947 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
var statearr_16958_16979 = state_16953__$1;
(statearr_16958_16979[(2)] = inst_16947);

(statearr_16958_16979[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (6))){
var inst_16938 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
if(cljs.core.truth_(inst_16938)){
var statearr_16959_16980 = state_16953__$1;
(statearr_16959_16980[(1)] = (8));

} else {
var statearr_16960_16981 = state_16953__$1;
(statearr_16960_16981[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (3))){
var inst_16951 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16953__$1,inst_16951);
} else {
if((state_val_16954 === (12))){
var state_16953__$1 = state_16953;
var statearr_16961_16982 = state_16953__$1;
(statearr_16961_16982[(2)] = null);

(statearr_16961_16982[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (2))){
var inst_16930 = (state_16953[(7)]);
var state_16953__$1 = state_16953;
if(cljs.core.truth_(inst_16930)){
var statearr_16962_16983 = state_16953__$1;
(statearr_16962_16983[(1)] = (4));

} else {
var statearr_16963_16984 = state_16953__$1;
(statearr_16963_16984[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (11))){
var inst_16944 = cljs.core.async.close_BANG_(ch);
var state_16953__$1 = state_16953;
var statearr_16964_16985 = state_16953__$1;
(statearr_16964_16985[(2)] = inst_16944);

(statearr_16964_16985[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (9))){
var state_16953__$1 = state_16953;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16965_16986 = state_16953__$1;
(statearr_16965_16986[(1)] = (11));

} else {
var statearr_16966_16987 = state_16953__$1;
(statearr_16966_16987[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (5))){
var inst_16930 = (state_16953[(7)]);
var state_16953__$1 = state_16953;
var statearr_16967_16988 = state_16953__$1;
(statearr_16967_16988[(2)] = inst_16930);

(statearr_16967_16988[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (10))){
var inst_16949 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
var statearr_16968_16989 = state_16953__$1;
(statearr_16968_16989[(2)] = inst_16949);

(statearr_16968_16989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16954 === (8))){
var inst_16930 = (state_16953[(7)]);
var inst_16940 = cljs.core.next(inst_16930);
var inst_16930__$1 = inst_16940;
var state_16953__$1 = (function (){var statearr_16969 = state_16953;
(statearr_16969[(7)] = inst_16930__$1);

return statearr_16969;
})();
var statearr_16970_16990 = state_16953__$1;
(statearr_16970_16990[(2)] = null);

(statearr_16970_16990[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_16971 = [null,null,null,null,null,null,null,null];
(statearr_16971[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_16971[(1)] = (1));

return statearr_16971;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_16953){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_16953);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e16972){var ex__16304__auto__ = e16972;
var statearr_16973_16991 = state_16953;
(statearr_16973_16991[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_16953[(4)]))){
var statearr_16974_16992 = state_16953;
(statearr_16974_16992[(1)] = cljs.core.first((state_16953[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__16993 = state_16953;
state_16953 = G__16993;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_16953){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_16953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_16975 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_16975[(6)] = c__16375__auto__);

return statearr_16975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__16995 = arguments.length;
switch (G__16995) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_16997 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_16997(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_16998 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_16998(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_16999 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_16999(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17000 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17000(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17001 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17001 = (function (ch,cs,meta17002){
this.ch = ch;
this.cs = cs;
this.meta17002 = meta17002;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17003,meta17002__$1){
var self__ = this;
var _17003__$1 = this;
return (new cljs.core.async.t_cljs$core$async17001(self__.ch,self__.cs,meta17002__$1));
}));

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17003){
var self__ = this;
var _17003__$1 = this;
return self__.meta17002;
}));

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async17001.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async17001.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17002], null);
}));

(cljs.core.async.t_cljs$core$async17001.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17001.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17001");

(cljs.core.async.t_cljs$core$async17001.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17001");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17001.
 */
cljs.core.async.__GT_t_cljs$core$async17001 = (function cljs$core$async$mult_$___GT_t_cljs$core$async17001(ch__$1,cs__$1,meta17002){
return (new cljs.core.async.t_cljs$core$async17001(ch__$1,cs__$1,meta17002));
});

}

return (new cljs.core.async.t_cljs$core$async17001(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__16375__auto___17220 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17136){
var state_val_17137 = (state_17136[(1)]);
if((state_val_17137 === (7))){
var inst_17132 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17138_17221 = state_17136__$1;
(statearr_17138_17221[(2)] = inst_17132);

(statearr_17138_17221[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (20))){
var inst_17037 = (state_17136[(7)]);
var inst_17049 = cljs.core.first(inst_17037);
var inst_17050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17049,(0),null);
var inst_17051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17049,(1),null);
var state_17136__$1 = (function (){var statearr_17139 = state_17136;
(statearr_17139[(8)] = inst_17050);

return statearr_17139;
})();
if(cljs.core.truth_(inst_17051)){
var statearr_17140_17222 = state_17136__$1;
(statearr_17140_17222[(1)] = (22));

} else {
var statearr_17141_17223 = state_17136__$1;
(statearr_17141_17223[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (27))){
var inst_17006 = (state_17136[(9)]);
var inst_17081 = (state_17136[(10)]);
var inst_17079 = (state_17136[(11)]);
var inst_17086 = (state_17136[(12)]);
var inst_17086__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17079,inst_17081);
var inst_17087 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17086__$1,inst_17006,done);
var state_17136__$1 = (function (){var statearr_17142 = state_17136;
(statearr_17142[(12)] = inst_17086__$1);

return statearr_17142;
})();
if(cljs.core.truth_(inst_17087)){
var statearr_17143_17224 = state_17136__$1;
(statearr_17143_17224[(1)] = (30));

} else {
var statearr_17144_17225 = state_17136__$1;
(statearr_17144_17225[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (1))){
var state_17136__$1 = state_17136;
var statearr_17145_17226 = state_17136__$1;
(statearr_17145_17226[(2)] = null);

(statearr_17145_17226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (24))){
var inst_17037 = (state_17136[(7)]);
var inst_17056 = (state_17136[(2)]);
var inst_17057 = cljs.core.next(inst_17037);
var inst_17015 = inst_17057;
var inst_17016 = null;
var inst_17017 = (0);
var inst_17018 = (0);
var state_17136__$1 = (function (){var statearr_17146 = state_17136;
(statearr_17146[(13)] = inst_17015);

(statearr_17146[(14)] = inst_17017);

(statearr_17146[(15)] = inst_17016);

(statearr_17146[(16)] = inst_17056);

(statearr_17146[(17)] = inst_17018);

return statearr_17146;
})();
var statearr_17147_17227 = state_17136__$1;
(statearr_17147_17227[(2)] = null);

(statearr_17147_17227[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (39))){
var state_17136__$1 = state_17136;
var statearr_17151_17228 = state_17136__$1;
(statearr_17151_17228[(2)] = null);

(statearr_17151_17228[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (4))){
var inst_17006 = (state_17136[(9)]);
var inst_17006__$1 = (state_17136[(2)]);
var inst_17007 = (inst_17006__$1 == null);
var state_17136__$1 = (function (){var statearr_17152 = state_17136;
(statearr_17152[(9)] = inst_17006__$1);

return statearr_17152;
})();
if(cljs.core.truth_(inst_17007)){
var statearr_17153_17229 = state_17136__$1;
(statearr_17153_17229[(1)] = (5));

} else {
var statearr_17154_17230 = state_17136__$1;
(statearr_17154_17230[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (15))){
var inst_17015 = (state_17136[(13)]);
var inst_17017 = (state_17136[(14)]);
var inst_17016 = (state_17136[(15)]);
var inst_17018 = (state_17136[(17)]);
var inst_17033 = (state_17136[(2)]);
var inst_17034 = (inst_17018 + (1));
var tmp17148 = inst_17015;
var tmp17149 = inst_17017;
var tmp17150 = inst_17016;
var inst_17015__$1 = tmp17148;
var inst_17016__$1 = tmp17150;
var inst_17017__$1 = tmp17149;
var inst_17018__$1 = inst_17034;
var state_17136__$1 = (function (){var statearr_17155 = state_17136;
(statearr_17155[(13)] = inst_17015__$1);

(statearr_17155[(14)] = inst_17017__$1);

(statearr_17155[(15)] = inst_17016__$1);

(statearr_17155[(17)] = inst_17018__$1);

(statearr_17155[(18)] = inst_17033);

return statearr_17155;
})();
var statearr_17156_17231 = state_17136__$1;
(statearr_17156_17231[(2)] = null);

(statearr_17156_17231[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (21))){
var inst_17060 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17160_17232 = state_17136__$1;
(statearr_17160_17232[(2)] = inst_17060);

(statearr_17160_17232[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (31))){
var inst_17086 = (state_17136[(12)]);
var inst_17090 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17086);
var state_17136__$1 = state_17136;
var statearr_17161_17233 = state_17136__$1;
(statearr_17161_17233[(2)] = inst_17090);

(statearr_17161_17233[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (32))){
var inst_17080 = (state_17136[(19)]);
var inst_17078 = (state_17136[(20)]);
var inst_17081 = (state_17136[(10)]);
var inst_17079 = (state_17136[(11)]);
var inst_17092 = (state_17136[(2)]);
var inst_17093 = (inst_17081 + (1));
var tmp17157 = inst_17080;
var tmp17158 = inst_17078;
var tmp17159 = inst_17079;
var inst_17078__$1 = tmp17158;
var inst_17079__$1 = tmp17159;
var inst_17080__$1 = tmp17157;
var inst_17081__$1 = inst_17093;
var state_17136__$1 = (function (){var statearr_17162 = state_17136;
(statearr_17162[(19)] = inst_17080__$1);

(statearr_17162[(20)] = inst_17078__$1);

(statearr_17162[(10)] = inst_17081__$1);

(statearr_17162[(11)] = inst_17079__$1);

(statearr_17162[(21)] = inst_17092);

return statearr_17162;
})();
var statearr_17163_17234 = state_17136__$1;
(statearr_17163_17234[(2)] = null);

(statearr_17163_17234[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (40))){
var inst_17105 = (state_17136[(22)]);
var inst_17109 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17105);
var state_17136__$1 = state_17136;
var statearr_17164_17235 = state_17136__$1;
(statearr_17164_17235[(2)] = inst_17109);

(statearr_17164_17235[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (33))){
var inst_17096 = (state_17136[(23)]);
var inst_17098 = cljs.core.chunked_seq_QMARK_(inst_17096);
var state_17136__$1 = state_17136;
if(inst_17098){
var statearr_17165_17236 = state_17136__$1;
(statearr_17165_17236[(1)] = (36));

} else {
var statearr_17166_17237 = state_17136__$1;
(statearr_17166_17237[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (13))){
var inst_17027 = (state_17136[(24)]);
var inst_17030 = cljs.core.async.close_BANG_(inst_17027);
var state_17136__$1 = state_17136;
var statearr_17167_17238 = state_17136__$1;
(statearr_17167_17238[(2)] = inst_17030);

(statearr_17167_17238[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (22))){
var inst_17050 = (state_17136[(8)]);
var inst_17053 = cljs.core.async.close_BANG_(inst_17050);
var state_17136__$1 = state_17136;
var statearr_17168_17239 = state_17136__$1;
(statearr_17168_17239[(2)] = inst_17053);

(statearr_17168_17239[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (36))){
var inst_17096 = (state_17136[(23)]);
var inst_17100 = cljs.core.chunk_first(inst_17096);
var inst_17101 = cljs.core.chunk_rest(inst_17096);
var inst_17102 = cljs.core.count(inst_17100);
var inst_17078 = inst_17101;
var inst_17079 = inst_17100;
var inst_17080 = inst_17102;
var inst_17081 = (0);
var state_17136__$1 = (function (){var statearr_17169 = state_17136;
(statearr_17169[(19)] = inst_17080);

(statearr_17169[(20)] = inst_17078);

(statearr_17169[(10)] = inst_17081);

(statearr_17169[(11)] = inst_17079);

return statearr_17169;
})();
var statearr_17170_17240 = state_17136__$1;
(statearr_17170_17240[(2)] = null);

(statearr_17170_17240[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (41))){
var inst_17096 = (state_17136[(23)]);
var inst_17111 = (state_17136[(2)]);
var inst_17112 = cljs.core.next(inst_17096);
var inst_17078 = inst_17112;
var inst_17079 = null;
var inst_17080 = (0);
var inst_17081 = (0);
var state_17136__$1 = (function (){var statearr_17171 = state_17136;
(statearr_17171[(19)] = inst_17080);

(statearr_17171[(25)] = inst_17111);

(statearr_17171[(20)] = inst_17078);

(statearr_17171[(10)] = inst_17081);

(statearr_17171[(11)] = inst_17079);

return statearr_17171;
})();
var statearr_17172_17241 = state_17136__$1;
(statearr_17172_17241[(2)] = null);

(statearr_17172_17241[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (43))){
var state_17136__$1 = state_17136;
var statearr_17173_17242 = state_17136__$1;
(statearr_17173_17242[(2)] = null);

(statearr_17173_17242[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (29))){
var inst_17120 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17174_17243 = state_17136__$1;
(statearr_17174_17243[(2)] = inst_17120);

(statearr_17174_17243[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (44))){
var inst_17129 = (state_17136[(2)]);
var state_17136__$1 = (function (){var statearr_17175 = state_17136;
(statearr_17175[(26)] = inst_17129);

return statearr_17175;
})();
var statearr_17176_17244 = state_17136__$1;
(statearr_17176_17244[(2)] = null);

(statearr_17176_17244[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (6))){
var inst_17070 = (state_17136[(27)]);
var inst_17069 = cljs.core.deref(cs);
var inst_17070__$1 = cljs.core.keys(inst_17069);
var inst_17071 = cljs.core.count(inst_17070__$1);
var inst_17072 = cljs.core.reset_BANG_(dctr,inst_17071);
var inst_17077 = cljs.core.seq(inst_17070__$1);
var inst_17078 = inst_17077;
var inst_17079 = null;
var inst_17080 = (0);
var inst_17081 = (0);
var state_17136__$1 = (function (){var statearr_17177 = state_17136;
(statearr_17177[(19)] = inst_17080);

(statearr_17177[(28)] = inst_17072);

(statearr_17177[(20)] = inst_17078);

(statearr_17177[(10)] = inst_17081);

(statearr_17177[(11)] = inst_17079);

(statearr_17177[(27)] = inst_17070__$1);

return statearr_17177;
})();
var statearr_17178_17245 = state_17136__$1;
(statearr_17178_17245[(2)] = null);

(statearr_17178_17245[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (28))){
var inst_17078 = (state_17136[(20)]);
var inst_17096 = (state_17136[(23)]);
var inst_17096__$1 = cljs.core.seq(inst_17078);
var state_17136__$1 = (function (){var statearr_17179 = state_17136;
(statearr_17179[(23)] = inst_17096__$1);

return statearr_17179;
})();
if(inst_17096__$1){
var statearr_17180_17246 = state_17136__$1;
(statearr_17180_17246[(1)] = (33));

} else {
var statearr_17181_17247 = state_17136__$1;
(statearr_17181_17247[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (25))){
var inst_17080 = (state_17136[(19)]);
var inst_17081 = (state_17136[(10)]);
var inst_17083 = (inst_17081 < inst_17080);
var inst_17084 = inst_17083;
var state_17136__$1 = state_17136;
if(cljs.core.truth_(inst_17084)){
var statearr_17182_17248 = state_17136__$1;
(statearr_17182_17248[(1)] = (27));

} else {
var statearr_17183_17249 = state_17136__$1;
(statearr_17183_17249[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (34))){
var state_17136__$1 = state_17136;
var statearr_17184_17250 = state_17136__$1;
(statearr_17184_17250[(2)] = null);

(statearr_17184_17250[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (17))){
var state_17136__$1 = state_17136;
var statearr_17185_17251 = state_17136__$1;
(statearr_17185_17251[(2)] = null);

(statearr_17185_17251[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (3))){
var inst_17134 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17136__$1,inst_17134);
} else {
if((state_val_17137 === (12))){
var inst_17065 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17186_17252 = state_17136__$1;
(statearr_17186_17252[(2)] = inst_17065);

(statearr_17186_17252[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (2))){
var state_17136__$1 = state_17136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17136__$1,(4),ch);
} else {
if((state_val_17137 === (23))){
var state_17136__$1 = state_17136;
var statearr_17187_17253 = state_17136__$1;
(statearr_17187_17253[(2)] = null);

(statearr_17187_17253[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (35))){
var inst_17118 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17188_17254 = state_17136__$1;
(statearr_17188_17254[(2)] = inst_17118);

(statearr_17188_17254[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (19))){
var inst_17037 = (state_17136[(7)]);
var inst_17041 = cljs.core.chunk_first(inst_17037);
var inst_17042 = cljs.core.chunk_rest(inst_17037);
var inst_17043 = cljs.core.count(inst_17041);
var inst_17015 = inst_17042;
var inst_17016 = inst_17041;
var inst_17017 = inst_17043;
var inst_17018 = (0);
var state_17136__$1 = (function (){var statearr_17189 = state_17136;
(statearr_17189[(13)] = inst_17015);

(statearr_17189[(14)] = inst_17017);

(statearr_17189[(15)] = inst_17016);

(statearr_17189[(17)] = inst_17018);

return statearr_17189;
})();
var statearr_17190_17255 = state_17136__$1;
(statearr_17190_17255[(2)] = null);

(statearr_17190_17255[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (11))){
var inst_17015 = (state_17136[(13)]);
var inst_17037 = (state_17136[(7)]);
var inst_17037__$1 = cljs.core.seq(inst_17015);
var state_17136__$1 = (function (){var statearr_17191 = state_17136;
(statearr_17191[(7)] = inst_17037__$1);

return statearr_17191;
})();
if(inst_17037__$1){
var statearr_17192_17256 = state_17136__$1;
(statearr_17192_17256[(1)] = (16));

} else {
var statearr_17193_17257 = state_17136__$1;
(statearr_17193_17257[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (9))){
var inst_17067 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17194_17258 = state_17136__$1;
(statearr_17194_17258[(2)] = inst_17067);

(statearr_17194_17258[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (5))){
var inst_17013 = cljs.core.deref(cs);
var inst_17014 = cljs.core.seq(inst_17013);
var inst_17015 = inst_17014;
var inst_17016 = null;
var inst_17017 = (0);
var inst_17018 = (0);
var state_17136__$1 = (function (){var statearr_17195 = state_17136;
(statearr_17195[(13)] = inst_17015);

(statearr_17195[(14)] = inst_17017);

(statearr_17195[(15)] = inst_17016);

(statearr_17195[(17)] = inst_17018);

return statearr_17195;
})();
var statearr_17196_17259 = state_17136__$1;
(statearr_17196_17259[(2)] = null);

(statearr_17196_17259[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (14))){
var state_17136__$1 = state_17136;
var statearr_17197_17260 = state_17136__$1;
(statearr_17197_17260[(2)] = null);

(statearr_17197_17260[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (45))){
var inst_17126 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17198_17261 = state_17136__$1;
(statearr_17198_17261[(2)] = inst_17126);

(statearr_17198_17261[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (26))){
var inst_17070 = (state_17136[(27)]);
var inst_17122 = (state_17136[(2)]);
var inst_17123 = cljs.core.seq(inst_17070);
var state_17136__$1 = (function (){var statearr_17199 = state_17136;
(statearr_17199[(29)] = inst_17122);

return statearr_17199;
})();
if(inst_17123){
var statearr_17200_17262 = state_17136__$1;
(statearr_17200_17262[(1)] = (42));

} else {
var statearr_17201_17263 = state_17136__$1;
(statearr_17201_17263[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (16))){
var inst_17037 = (state_17136[(7)]);
var inst_17039 = cljs.core.chunked_seq_QMARK_(inst_17037);
var state_17136__$1 = state_17136;
if(inst_17039){
var statearr_17202_17264 = state_17136__$1;
(statearr_17202_17264[(1)] = (19));

} else {
var statearr_17203_17265 = state_17136__$1;
(statearr_17203_17265[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (38))){
var inst_17115 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17204_17266 = state_17136__$1;
(statearr_17204_17266[(2)] = inst_17115);

(statearr_17204_17266[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (30))){
var state_17136__$1 = state_17136;
var statearr_17205_17267 = state_17136__$1;
(statearr_17205_17267[(2)] = null);

(statearr_17205_17267[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (10))){
var inst_17016 = (state_17136[(15)]);
var inst_17018 = (state_17136[(17)]);
var inst_17026 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17016,inst_17018);
var inst_17027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17026,(0),null);
var inst_17028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17026,(1),null);
var state_17136__$1 = (function (){var statearr_17206 = state_17136;
(statearr_17206[(24)] = inst_17027);

return statearr_17206;
})();
if(cljs.core.truth_(inst_17028)){
var statearr_17207_17268 = state_17136__$1;
(statearr_17207_17268[(1)] = (13));

} else {
var statearr_17208_17269 = state_17136__$1;
(statearr_17208_17269[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (18))){
var inst_17063 = (state_17136[(2)]);
var state_17136__$1 = state_17136;
var statearr_17209_17270 = state_17136__$1;
(statearr_17209_17270[(2)] = inst_17063);

(statearr_17209_17270[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (42))){
var state_17136__$1 = state_17136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17136__$1,(45),dchan);
} else {
if((state_val_17137 === (37))){
var inst_17105 = (state_17136[(22)]);
var inst_17006 = (state_17136[(9)]);
var inst_17096 = (state_17136[(23)]);
var inst_17105__$1 = cljs.core.first(inst_17096);
var inst_17106 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17105__$1,inst_17006,done);
var state_17136__$1 = (function (){var statearr_17210 = state_17136;
(statearr_17210[(22)] = inst_17105__$1);

return statearr_17210;
})();
if(cljs.core.truth_(inst_17106)){
var statearr_17211_17271 = state_17136__$1;
(statearr_17211_17271[(1)] = (39));

} else {
var statearr_17212_17272 = state_17136__$1;
(statearr_17212_17272[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17137 === (8))){
var inst_17017 = (state_17136[(14)]);
var inst_17018 = (state_17136[(17)]);
var inst_17020 = (inst_17018 < inst_17017);
var inst_17021 = inst_17020;
var state_17136__$1 = state_17136;
if(cljs.core.truth_(inst_17021)){
var statearr_17213_17273 = state_17136__$1;
(statearr_17213_17273[(1)] = (10));

} else {
var statearr_17214_17274 = state_17136__$1;
(statearr_17214_17274[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__16301__auto__ = null;
var cljs$core$async$mult_$_state_machine__16301__auto____0 = (function (){
var statearr_17215 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17215[(0)] = cljs$core$async$mult_$_state_machine__16301__auto__);

(statearr_17215[(1)] = (1));

return statearr_17215;
});
var cljs$core$async$mult_$_state_machine__16301__auto____1 = (function (state_17136){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17136);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17216){var ex__16304__auto__ = e17216;
var statearr_17217_17275 = state_17136;
(statearr_17217_17275[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17136[(4)]))){
var statearr_17218_17276 = state_17136;
(statearr_17218_17276[(1)] = cljs.core.first((state_17136[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17277 = state_17136;
state_17136 = G__17277;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16301__auto__ = function(state_17136){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16301__auto____1.call(this,state_17136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16301__auto____0;
cljs$core$async$mult_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16301__auto____1;
return cljs$core$async$mult_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17219 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17219[(6)] = c__16375__auto___17220);

return statearr_17219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__17279 = arguments.length;
switch (G__17279) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_17281 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_17281(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_17282 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_17282(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_17283 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_17283(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_17284 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_17284(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_17285 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_17285(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___17296 = arguments.length;
var i__4737__auto___17297 = (0);
while(true){
if((i__4737__auto___17297 < len__4736__auto___17296)){
args__4742__auto__.push((arguments[i__4737__auto___17297]));

var G__17298 = (i__4737__auto___17297 + (1));
i__4737__auto___17297 = G__17298;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17290){
var map__17291 = p__17290;
var map__17291__$1 = (((((!((map__17291 == null))))?(((((map__17291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17291):map__17291);
var opts = map__17291__$1;
var statearr_17293_17299 = state;
(statearr_17293_17299[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_17294_17300 = state;
(statearr_17294_17300[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_17295_17301 = state;
(statearr_17295_17301[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17286){
var G__17287 = cljs.core.first(seq17286);
var seq17286__$1 = cljs.core.next(seq17286);
var G__17288 = cljs.core.first(seq17286__$1);
var seq17286__$2 = cljs.core.next(seq17286__$1);
var G__17289 = cljs.core.first(seq17286__$2);
var seq17286__$3 = cljs.core.next(seq17286__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17287,G__17288,G__17289,seq17286__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17302 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17302 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta17303){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta17303 = meta17303;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17304,meta17303__$1){
var self__ = this;
var _17304__$1 = this;
return (new cljs.core.async.t_cljs$core$async17302(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta17303__$1));
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17304){
var self__ = this;
var _17304__$1 = this;
return self__.meta17303;
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17302.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async17302.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta17303], null);
}));

(cljs.core.async.t_cljs$core$async17302.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17302.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17302");

(cljs.core.async.t_cljs$core$async17302.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17302");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17302.
 */
cljs.core.async.__GT_t_cljs$core$async17302 = (function cljs$core$async$mix_$___GT_t_cljs$core$async17302(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17303){
return (new cljs.core.async.t_cljs$core$async17302(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta17303));
});

}

return (new cljs.core.async.t_cljs$core$async17302(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16375__auto___17467 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17406){
var state_val_17407 = (state_17406[(1)]);
if((state_val_17407 === (7))){
var inst_17321 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17408_17468 = state_17406__$1;
(statearr_17408_17468[(2)] = inst_17321);

(statearr_17408_17468[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (20))){
var inst_17333 = (state_17406[(7)]);
var state_17406__$1 = state_17406;
var statearr_17409_17469 = state_17406__$1;
(statearr_17409_17469[(2)] = inst_17333);

(statearr_17409_17469[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (27))){
var state_17406__$1 = state_17406;
var statearr_17410_17470 = state_17406__$1;
(statearr_17410_17470[(2)] = null);

(statearr_17410_17470[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (1))){
var inst_17308 = (state_17406[(8)]);
var inst_17308__$1 = calc_state();
var inst_17310 = (inst_17308__$1 == null);
var inst_17311 = cljs.core.not(inst_17310);
var state_17406__$1 = (function (){var statearr_17411 = state_17406;
(statearr_17411[(8)] = inst_17308__$1);

return statearr_17411;
})();
if(inst_17311){
var statearr_17412_17471 = state_17406__$1;
(statearr_17412_17471[(1)] = (2));

} else {
var statearr_17413_17472 = state_17406__$1;
(statearr_17413_17472[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (24))){
var inst_17357 = (state_17406[(9)]);
var inst_17366 = (state_17406[(10)]);
var inst_17380 = (state_17406[(11)]);
var inst_17380__$1 = (inst_17357.cljs$core$IFn$_invoke$arity$1 ? inst_17357.cljs$core$IFn$_invoke$arity$1(inst_17366) : inst_17357.call(null,inst_17366));
var state_17406__$1 = (function (){var statearr_17414 = state_17406;
(statearr_17414[(11)] = inst_17380__$1);

return statearr_17414;
})();
if(cljs.core.truth_(inst_17380__$1)){
var statearr_17415_17473 = state_17406__$1;
(statearr_17415_17473[(1)] = (29));

} else {
var statearr_17416_17474 = state_17406__$1;
(statearr_17416_17474[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (4))){
var inst_17324 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17324)){
var statearr_17417_17475 = state_17406__$1;
(statearr_17417_17475[(1)] = (8));

} else {
var statearr_17418_17476 = state_17406__$1;
(statearr_17418_17476[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (15))){
var inst_17351 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17351)){
var statearr_17419_17477 = state_17406__$1;
(statearr_17419_17477[(1)] = (19));

} else {
var statearr_17420_17478 = state_17406__$1;
(statearr_17420_17478[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (21))){
var inst_17356 = (state_17406[(12)]);
var inst_17356__$1 = (state_17406[(2)]);
var inst_17357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17356__$1,cljs.core.cst$kw$solos);
var inst_17358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17356__$1,cljs.core.cst$kw$mutes);
var inst_17359 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17356__$1,cljs.core.cst$kw$reads);
var state_17406__$1 = (function (){var statearr_17421 = state_17406;
(statearr_17421[(9)] = inst_17357);

(statearr_17421[(13)] = inst_17358);

(statearr_17421[(12)] = inst_17356__$1);

return statearr_17421;
})();
return cljs.core.async.ioc_alts_BANG_(state_17406__$1,(22),inst_17359);
} else {
if((state_val_17407 === (31))){
var inst_17388 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17388)){
var statearr_17422_17479 = state_17406__$1;
(statearr_17422_17479[(1)] = (32));

} else {
var statearr_17423_17480 = state_17406__$1;
(statearr_17423_17480[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (32))){
var inst_17365 = (state_17406[(14)]);
var state_17406__$1 = state_17406;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17406__$1,(35),out,inst_17365);
} else {
if((state_val_17407 === (33))){
var inst_17356 = (state_17406[(12)]);
var inst_17333 = inst_17356;
var state_17406__$1 = (function (){var statearr_17424 = state_17406;
(statearr_17424[(7)] = inst_17333);

return statearr_17424;
})();
var statearr_17425_17481 = state_17406__$1;
(statearr_17425_17481[(2)] = null);

(statearr_17425_17481[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (13))){
var inst_17333 = (state_17406[(7)]);
var inst_17340 = inst_17333.cljs$lang$protocol_mask$partition0$;
var inst_17341 = (inst_17340 & (64));
var inst_17342 = inst_17333.cljs$core$ISeq$;
var inst_17343 = (cljs.core.PROTOCOL_SENTINEL === inst_17342);
var inst_17344 = ((inst_17341) || (inst_17343));
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17344)){
var statearr_17426_17482 = state_17406__$1;
(statearr_17426_17482[(1)] = (16));

} else {
var statearr_17427_17483 = state_17406__$1;
(statearr_17427_17483[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (22))){
var inst_17366 = (state_17406[(10)]);
var inst_17365 = (state_17406[(14)]);
var inst_17364 = (state_17406[(2)]);
var inst_17365__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17364,(0),null);
var inst_17366__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17364,(1),null);
var inst_17367 = (inst_17365__$1 == null);
var inst_17368 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17366__$1,change);
var inst_17369 = ((inst_17367) || (inst_17368));
var state_17406__$1 = (function (){var statearr_17428 = state_17406;
(statearr_17428[(10)] = inst_17366__$1);

(statearr_17428[(14)] = inst_17365__$1);

return statearr_17428;
})();
if(cljs.core.truth_(inst_17369)){
var statearr_17429_17484 = state_17406__$1;
(statearr_17429_17484[(1)] = (23));

} else {
var statearr_17430_17485 = state_17406__$1;
(statearr_17430_17485[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (36))){
var inst_17356 = (state_17406[(12)]);
var inst_17333 = inst_17356;
var state_17406__$1 = (function (){var statearr_17431 = state_17406;
(statearr_17431[(7)] = inst_17333);

return statearr_17431;
})();
var statearr_17432_17486 = state_17406__$1;
(statearr_17432_17486[(2)] = null);

(statearr_17432_17486[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (29))){
var inst_17380 = (state_17406[(11)]);
var state_17406__$1 = state_17406;
var statearr_17433_17487 = state_17406__$1;
(statearr_17433_17487[(2)] = inst_17380);

(statearr_17433_17487[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (6))){
var state_17406__$1 = state_17406;
var statearr_17434_17488 = state_17406__$1;
(statearr_17434_17488[(2)] = false);

(statearr_17434_17488[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (28))){
var inst_17376 = (state_17406[(2)]);
var inst_17377 = calc_state();
var inst_17333 = inst_17377;
var state_17406__$1 = (function (){var statearr_17435 = state_17406;
(statearr_17435[(7)] = inst_17333);

(statearr_17435[(15)] = inst_17376);

return statearr_17435;
})();
var statearr_17436_17489 = state_17406__$1;
(statearr_17436_17489[(2)] = null);

(statearr_17436_17489[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (25))){
var inst_17402 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17437_17490 = state_17406__$1;
(statearr_17437_17490[(2)] = inst_17402);

(statearr_17437_17490[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (34))){
var inst_17400 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17438_17491 = state_17406__$1;
(statearr_17438_17491[(2)] = inst_17400);

(statearr_17438_17491[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (17))){
var state_17406__$1 = state_17406;
var statearr_17439_17492 = state_17406__$1;
(statearr_17439_17492[(2)] = false);

(statearr_17439_17492[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (3))){
var state_17406__$1 = state_17406;
var statearr_17440_17493 = state_17406__$1;
(statearr_17440_17493[(2)] = false);

(statearr_17440_17493[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (12))){
var inst_17404 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17406__$1,inst_17404);
} else {
if((state_val_17407 === (2))){
var inst_17308 = (state_17406[(8)]);
var inst_17313 = inst_17308.cljs$lang$protocol_mask$partition0$;
var inst_17314 = (inst_17313 & (64));
var inst_17315 = inst_17308.cljs$core$ISeq$;
var inst_17316 = (cljs.core.PROTOCOL_SENTINEL === inst_17315);
var inst_17317 = ((inst_17314) || (inst_17316));
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17317)){
var statearr_17441_17494 = state_17406__$1;
(statearr_17441_17494[(1)] = (5));

} else {
var statearr_17442_17495 = state_17406__$1;
(statearr_17442_17495[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (23))){
var inst_17365 = (state_17406[(14)]);
var inst_17371 = (inst_17365 == null);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17371)){
var statearr_17443_17496 = state_17406__$1;
(statearr_17443_17496[(1)] = (26));

} else {
var statearr_17444_17497 = state_17406__$1;
(statearr_17444_17497[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (35))){
var inst_17391 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
if(cljs.core.truth_(inst_17391)){
var statearr_17445_17498 = state_17406__$1;
(statearr_17445_17498[(1)] = (36));

} else {
var statearr_17446_17499 = state_17406__$1;
(statearr_17446_17499[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (19))){
var inst_17333 = (state_17406[(7)]);
var inst_17353 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17333);
var state_17406__$1 = state_17406;
var statearr_17447_17500 = state_17406__$1;
(statearr_17447_17500[(2)] = inst_17353);

(statearr_17447_17500[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (11))){
var inst_17333 = (state_17406[(7)]);
var inst_17337 = (inst_17333 == null);
var inst_17338 = cljs.core.not(inst_17337);
var state_17406__$1 = state_17406;
if(inst_17338){
var statearr_17448_17501 = state_17406__$1;
(statearr_17448_17501[(1)] = (13));

} else {
var statearr_17449_17502 = state_17406__$1;
(statearr_17449_17502[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (9))){
var inst_17308 = (state_17406[(8)]);
var state_17406__$1 = state_17406;
var statearr_17450_17503 = state_17406__$1;
(statearr_17450_17503[(2)] = inst_17308);

(statearr_17450_17503[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (5))){
var state_17406__$1 = state_17406;
var statearr_17451_17504 = state_17406__$1;
(statearr_17451_17504[(2)] = true);

(statearr_17451_17504[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (14))){
var state_17406__$1 = state_17406;
var statearr_17452_17505 = state_17406__$1;
(statearr_17452_17505[(2)] = false);

(statearr_17452_17505[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (26))){
var inst_17366 = (state_17406[(10)]);
var inst_17373 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_17366);
var state_17406__$1 = state_17406;
var statearr_17453_17506 = state_17406__$1;
(statearr_17453_17506[(2)] = inst_17373);

(statearr_17453_17506[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (16))){
var state_17406__$1 = state_17406;
var statearr_17454_17507 = state_17406__$1;
(statearr_17454_17507[(2)] = true);

(statearr_17454_17507[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (38))){
var inst_17396 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17455_17508 = state_17406__$1;
(statearr_17455_17508[(2)] = inst_17396);

(statearr_17455_17508[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (30))){
var inst_17357 = (state_17406[(9)]);
var inst_17366 = (state_17406[(10)]);
var inst_17358 = (state_17406[(13)]);
var inst_17383 = cljs.core.empty_QMARK_(inst_17357);
var inst_17384 = (inst_17358.cljs$core$IFn$_invoke$arity$1 ? inst_17358.cljs$core$IFn$_invoke$arity$1(inst_17366) : inst_17358.call(null,inst_17366));
var inst_17385 = cljs.core.not(inst_17384);
var inst_17386 = ((inst_17383) && (inst_17385));
var state_17406__$1 = state_17406;
var statearr_17456_17509 = state_17406__$1;
(statearr_17456_17509[(2)] = inst_17386);

(statearr_17456_17509[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (10))){
var inst_17308 = (state_17406[(8)]);
var inst_17329 = (state_17406[(2)]);
var inst_17330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17329,cljs.core.cst$kw$solos);
var inst_17331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17329,cljs.core.cst$kw$mutes);
var inst_17332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17329,cljs.core.cst$kw$reads);
var inst_17333 = inst_17308;
var state_17406__$1 = (function (){var statearr_17457 = state_17406;
(statearr_17457[(7)] = inst_17333);

(statearr_17457[(16)] = inst_17331);

(statearr_17457[(17)] = inst_17332);

(statearr_17457[(18)] = inst_17330);

return statearr_17457;
})();
var statearr_17458_17510 = state_17406__$1;
(statearr_17458_17510[(2)] = null);

(statearr_17458_17510[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (18))){
var inst_17348 = (state_17406[(2)]);
var state_17406__$1 = state_17406;
var statearr_17459_17511 = state_17406__$1;
(statearr_17459_17511[(2)] = inst_17348);

(statearr_17459_17511[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (37))){
var state_17406__$1 = state_17406;
var statearr_17460_17512 = state_17406__$1;
(statearr_17460_17512[(2)] = null);

(statearr_17460_17512[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17407 === (8))){
var inst_17308 = (state_17406[(8)]);
var inst_17326 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_17308);
var state_17406__$1 = state_17406;
var statearr_17461_17513 = state_17406__$1;
(statearr_17461_17513[(2)] = inst_17326);

(statearr_17461_17513[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__16301__auto__ = null;
var cljs$core$async$mix_$_state_machine__16301__auto____0 = (function (){
var statearr_17462 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17462[(0)] = cljs$core$async$mix_$_state_machine__16301__auto__);

(statearr_17462[(1)] = (1));

return statearr_17462;
});
var cljs$core$async$mix_$_state_machine__16301__auto____1 = (function (state_17406){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17406);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17463){var ex__16304__auto__ = e17463;
var statearr_17464_17514 = state_17406;
(statearr_17464_17514[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17406[(4)]))){
var statearr_17465_17515 = state_17406;
(statearr_17465_17515[(1)] = cljs.core.first((state_17406[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17516 = state_17406;
state_17406 = G__17516;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16301__auto__ = function(state_17406){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16301__auto____1.call(this,state_17406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16301__auto____0;
cljs$core$async$mix_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16301__auto____1;
return cljs$core$async$mix_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17466 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17466[(6)] = c__16375__auto___17467);

return statearr_17466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_17519 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_17519(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_17520 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_17520(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_17521 = (function() {
var G__17522 = null;
var G__17522__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__17522__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__17522 = function(p,v){
switch(arguments.length){
case 1:
return G__17522__1.call(this,p);
case 2:
return G__17522__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17522.cljs$core$IFn$_invoke$arity$1 = G__17522__1;
G__17522.cljs$core$IFn$_invoke$arity$2 = G__17522__2;
return G__17522;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__17518 = arguments.length;
switch (G__17518) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17521.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_17521.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__17526 = arguments.length;
switch (G__17526) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__17524_SHARP_){
if(cljs.core.truth_((p1__17524_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17524_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__17524_SHARP_.call(null,topic)))){
return p1__17524_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17524_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17527 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17527 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta17528){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta17528 = meta17528;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17529,meta17528__$1){
var self__ = this;
var _17529__$1 = this;
return (new cljs.core.async.t_cljs$core$async17527(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta17528__$1));
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17529){
var self__ = this;
var _17529__$1 = this;
return self__.meta17528;
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async17527.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async17527.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta17528], null);
}));

(cljs.core.async.t_cljs$core$async17527.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17527.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17527");

(cljs.core.async.t_cljs$core$async17527.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17527");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17527.
 */
cljs.core.async.__GT_t_cljs$core$async17527 = (function cljs$core$async$__GT_t_cljs$core$async17527(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17528){
return (new cljs.core.async.t_cljs$core$async17527(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta17528));
});

}

return (new cljs.core.async.t_cljs$core$async17527(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16375__auto___17648 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17601){
var state_val_17602 = (state_17601[(1)]);
if((state_val_17602 === (7))){
var inst_17597 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17603_17649 = state_17601__$1;
(statearr_17603_17649[(2)] = inst_17597);

(statearr_17603_17649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (20))){
var state_17601__$1 = state_17601;
var statearr_17604_17650 = state_17601__$1;
(statearr_17604_17650[(2)] = null);

(statearr_17604_17650[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (1))){
var state_17601__$1 = state_17601;
var statearr_17605_17651 = state_17601__$1;
(statearr_17605_17651[(2)] = null);

(statearr_17605_17651[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (24))){
var inst_17580 = (state_17601[(7)]);
var inst_17589 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_17580);
var state_17601__$1 = state_17601;
var statearr_17606_17652 = state_17601__$1;
(statearr_17606_17652[(2)] = inst_17589);

(statearr_17606_17652[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (4))){
var inst_17532 = (state_17601[(8)]);
var inst_17532__$1 = (state_17601[(2)]);
var inst_17533 = (inst_17532__$1 == null);
var state_17601__$1 = (function (){var statearr_17607 = state_17601;
(statearr_17607[(8)] = inst_17532__$1);

return statearr_17607;
})();
if(cljs.core.truth_(inst_17533)){
var statearr_17608_17653 = state_17601__$1;
(statearr_17608_17653[(1)] = (5));

} else {
var statearr_17609_17654 = state_17601__$1;
(statearr_17609_17654[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (15))){
var inst_17574 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17610_17655 = state_17601__$1;
(statearr_17610_17655[(2)] = inst_17574);

(statearr_17610_17655[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (21))){
var inst_17594 = (state_17601[(2)]);
var state_17601__$1 = (function (){var statearr_17611 = state_17601;
(statearr_17611[(9)] = inst_17594);

return statearr_17611;
})();
var statearr_17612_17656 = state_17601__$1;
(statearr_17612_17656[(2)] = null);

(statearr_17612_17656[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (13))){
var inst_17556 = (state_17601[(10)]);
var inst_17558 = cljs.core.chunked_seq_QMARK_(inst_17556);
var state_17601__$1 = state_17601;
if(inst_17558){
var statearr_17613_17657 = state_17601__$1;
(statearr_17613_17657[(1)] = (16));

} else {
var statearr_17614_17658 = state_17601__$1;
(statearr_17614_17658[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (22))){
var inst_17586 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
if(cljs.core.truth_(inst_17586)){
var statearr_17615_17659 = state_17601__$1;
(statearr_17615_17659[(1)] = (23));

} else {
var statearr_17616_17660 = state_17601__$1;
(statearr_17616_17660[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (6))){
var inst_17582 = (state_17601[(11)]);
var inst_17532 = (state_17601[(8)]);
var inst_17580 = (state_17601[(7)]);
var inst_17580__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_17532) : topic_fn.call(null,inst_17532));
var inst_17581 = cljs.core.deref(mults);
var inst_17582__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17581,inst_17580__$1);
var state_17601__$1 = (function (){var statearr_17617 = state_17601;
(statearr_17617[(11)] = inst_17582__$1);

(statearr_17617[(7)] = inst_17580__$1);

return statearr_17617;
})();
if(cljs.core.truth_(inst_17582__$1)){
var statearr_17618_17661 = state_17601__$1;
(statearr_17618_17661[(1)] = (19));

} else {
var statearr_17619_17662 = state_17601__$1;
(statearr_17619_17662[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (25))){
var inst_17591 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17620_17663 = state_17601__$1;
(statearr_17620_17663[(2)] = inst_17591);

(statearr_17620_17663[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (17))){
var inst_17556 = (state_17601[(10)]);
var inst_17565 = cljs.core.first(inst_17556);
var inst_17566 = cljs.core.async.muxch_STAR_(inst_17565);
var inst_17567 = cljs.core.async.close_BANG_(inst_17566);
var inst_17568 = cljs.core.next(inst_17556);
var inst_17542 = inst_17568;
var inst_17543 = null;
var inst_17544 = (0);
var inst_17545 = (0);
var state_17601__$1 = (function (){var statearr_17621 = state_17601;
(statearr_17621[(12)] = inst_17542);

(statearr_17621[(13)] = inst_17543);

(statearr_17621[(14)] = inst_17545);

(statearr_17621[(15)] = inst_17567);

(statearr_17621[(16)] = inst_17544);

return statearr_17621;
})();
var statearr_17622_17664 = state_17601__$1;
(statearr_17622_17664[(2)] = null);

(statearr_17622_17664[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (3))){
var inst_17599 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17601__$1,inst_17599);
} else {
if((state_val_17602 === (12))){
var inst_17576 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17623_17665 = state_17601__$1;
(statearr_17623_17665[(2)] = inst_17576);

(statearr_17623_17665[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (2))){
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17601__$1,(4),ch);
} else {
if((state_val_17602 === (23))){
var state_17601__$1 = state_17601;
var statearr_17624_17666 = state_17601__$1;
(statearr_17624_17666[(2)] = null);

(statearr_17624_17666[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (19))){
var inst_17582 = (state_17601[(11)]);
var inst_17532 = (state_17601[(8)]);
var inst_17584 = cljs.core.async.muxch_STAR_(inst_17582);
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17601__$1,(22),inst_17584,inst_17532);
} else {
if((state_val_17602 === (11))){
var inst_17542 = (state_17601[(12)]);
var inst_17556 = (state_17601[(10)]);
var inst_17556__$1 = cljs.core.seq(inst_17542);
var state_17601__$1 = (function (){var statearr_17625 = state_17601;
(statearr_17625[(10)] = inst_17556__$1);

return statearr_17625;
})();
if(inst_17556__$1){
var statearr_17626_17667 = state_17601__$1;
(statearr_17626_17667[(1)] = (13));

} else {
var statearr_17627_17668 = state_17601__$1;
(statearr_17627_17668[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (9))){
var inst_17578 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17628_17669 = state_17601__$1;
(statearr_17628_17669[(2)] = inst_17578);

(statearr_17628_17669[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (5))){
var inst_17539 = cljs.core.deref(mults);
var inst_17540 = cljs.core.vals(inst_17539);
var inst_17541 = cljs.core.seq(inst_17540);
var inst_17542 = inst_17541;
var inst_17543 = null;
var inst_17544 = (0);
var inst_17545 = (0);
var state_17601__$1 = (function (){var statearr_17629 = state_17601;
(statearr_17629[(12)] = inst_17542);

(statearr_17629[(13)] = inst_17543);

(statearr_17629[(14)] = inst_17545);

(statearr_17629[(16)] = inst_17544);

return statearr_17629;
})();
var statearr_17630_17670 = state_17601__$1;
(statearr_17630_17670[(2)] = null);

(statearr_17630_17670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (14))){
var state_17601__$1 = state_17601;
var statearr_17634_17671 = state_17601__$1;
(statearr_17634_17671[(2)] = null);

(statearr_17634_17671[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (16))){
var inst_17556 = (state_17601[(10)]);
var inst_17560 = cljs.core.chunk_first(inst_17556);
var inst_17561 = cljs.core.chunk_rest(inst_17556);
var inst_17562 = cljs.core.count(inst_17560);
var inst_17542 = inst_17561;
var inst_17543 = inst_17560;
var inst_17544 = inst_17562;
var inst_17545 = (0);
var state_17601__$1 = (function (){var statearr_17635 = state_17601;
(statearr_17635[(12)] = inst_17542);

(statearr_17635[(13)] = inst_17543);

(statearr_17635[(14)] = inst_17545);

(statearr_17635[(16)] = inst_17544);

return statearr_17635;
})();
var statearr_17636_17672 = state_17601__$1;
(statearr_17636_17672[(2)] = null);

(statearr_17636_17672[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (10))){
var inst_17542 = (state_17601[(12)]);
var inst_17543 = (state_17601[(13)]);
var inst_17545 = (state_17601[(14)]);
var inst_17544 = (state_17601[(16)]);
var inst_17550 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17543,inst_17545);
var inst_17551 = cljs.core.async.muxch_STAR_(inst_17550);
var inst_17552 = cljs.core.async.close_BANG_(inst_17551);
var inst_17553 = (inst_17545 + (1));
var tmp17631 = inst_17542;
var tmp17632 = inst_17543;
var tmp17633 = inst_17544;
var inst_17542__$1 = tmp17631;
var inst_17543__$1 = tmp17632;
var inst_17544__$1 = tmp17633;
var inst_17545__$1 = inst_17553;
var state_17601__$1 = (function (){var statearr_17637 = state_17601;
(statearr_17637[(12)] = inst_17542__$1);

(statearr_17637[(13)] = inst_17543__$1);

(statearr_17637[(17)] = inst_17552);

(statearr_17637[(14)] = inst_17545__$1);

(statearr_17637[(16)] = inst_17544__$1);

return statearr_17637;
})();
var statearr_17638_17673 = state_17601__$1;
(statearr_17638_17673[(2)] = null);

(statearr_17638_17673[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (18))){
var inst_17571 = (state_17601[(2)]);
var state_17601__$1 = state_17601;
var statearr_17639_17674 = state_17601__$1;
(statearr_17639_17674[(2)] = inst_17571);

(statearr_17639_17674[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17602 === (8))){
var inst_17545 = (state_17601[(14)]);
var inst_17544 = (state_17601[(16)]);
var inst_17547 = (inst_17545 < inst_17544);
var inst_17548 = inst_17547;
var state_17601__$1 = state_17601;
if(cljs.core.truth_(inst_17548)){
var statearr_17640_17675 = state_17601__$1;
(statearr_17640_17675[(1)] = (10));

} else {
var statearr_17641_17676 = state_17601__$1;
(statearr_17641_17676[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_17642 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17642[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_17642[(1)] = (1));

return statearr_17642;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_17601){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17601);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17643){var ex__16304__auto__ = e17643;
var statearr_17644_17677 = state_17601;
(statearr_17644_17677[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17601[(4)]))){
var statearr_17645_17678 = state_17601;
(statearr_17645_17678[(1)] = cljs.core.first((state_17601[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17679 = state_17601;
state_17601 = G__17679;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_17601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_17601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17646 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17646[(6)] = c__16375__auto___17648);

return statearr_17646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__17681 = arguments.length;
switch (G__17681) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__17684 = arguments.length;
switch (G__17684) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__17687 = arguments.length;
switch (G__17687) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16375__auto___17765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17730){
var state_val_17731 = (state_17730[(1)]);
if((state_val_17731 === (7))){
var state_17730__$1 = state_17730;
var statearr_17732_17766 = state_17730__$1;
(statearr_17732_17766[(2)] = null);

(statearr_17732_17766[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (1))){
var state_17730__$1 = state_17730;
var statearr_17733_17767 = state_17730__$1;
(statearr_17733_17767[(2)] = null);

(statearr_17733_17767[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (4))){
var inst_17690 = (state_17730[(7)]);
var inst_17691 = (state_17730[(8)]);
var inst_17693 = (inst_17691 < inst_17690);
var state_17730__$1 = state_17730;
if(cljs.core.truth_(inst_17693)){
var statearr_17734_17768 = state_17730__$1;
(statearr_17734_17768[(1)] = (6));

} else {
var statearr_17735_17769 = state_17730__$1;
(statearr_17735_17769[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (15))){
var inst_17716 = (state_17730[(9)]);
var inst_17721 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17716);
var state_17730__$1 = state_17730;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17730__$1,(17),out,inst_17721);
} else {
if((state_val_17731 === (13))){
var inst_17716 = (state_17730[(9)]);
var inst_17716__$1 = (state_17730[(2)]);
var inst_17717 = cljs.core.some(cljs.core.nil_QMARK_,inst_17716__$1);
var state_17730__$1 = (function (){var statearr_17736 = state_17730;
(statearr_17736[(9)] = inst_17716__$1);

return statearr_17736;
})();
if(cljs.core.truth_(inst_17717)){
var statearr_17737_17770 = state_17730__$1;
(statearr_17737_17770[(1)] = (14));

} else {
var statearr_17738_17771 = state_17730__$1;
(statearr_17738_17771[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (6))){
var state_17730__$1 = state_17730;
var statearr_17739_17772 = state_17730__$1;
(statearr_17739_17772[(2)] = null);

(statearr_17739_17772[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (17))){
var inst_17723 = (state_17730[(2)]);
var state_17730__$1 = (function (){var statearr_17741 = state_17730;
(statearr_17741[(10)] = inst_17723);

return statearr_17741;
})();
var statearr_17742_17773 = state_17730__$1;
(statearr_17742_17773[(2)] = null);

(statearr_17742_17773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (3))){
var inst_17728 = (state_17730[(2)]);
var state_17730__$1 = state_17730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17730__$1,inst_17728);
} else {
if((state_val_17731 === (12))){
var _ = (function (){var statearr_17743 = state_17730;
(statearr_17743[(4)] = cljs.core.rest((state_17730[(4)])));

return statearr_17743;
})();
var state_17730__$1 = state_17730;
var ex17740 = (state_17730__$1[(2)]);
var statearr_17744_17774 = state_17730__$1;
(statearr_17744_17774[(5)] = ex17740);


if((ex17740 instanceof Object)){
var statearr_17745_17775 = state_17730__$1;
(statearr_17745_17775[(1)] = (11));

(statearr_17745_17775[(5)] = null);

} else {
throw ex17740;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (2))){
var inst_17689 = cljs.core.reset_BANG_(dctr,cnt);
var inst_17690 = cnt;
var inst_17691 = (0);
var state_17730__$1 = (function (){var statearr_17746 = state_17730;
(statearr_17746[(7)] = inst_17690);

(statearr_17746[(11)] = inst_17689);

(statearr_17746[(8)] = inst_17691);

return statearr_17746;
})();
var statearr_17747_17776 = state_17730__$1;
(statearr_17747_17776[(2)] = null);

(statearr_17747_17776[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (11))){
var inst_17695 = (state_17730[(2)]);
var inst_17696 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17730__$1 = (function (){var statearr_17748 = state_17730;
(statearr_17748[(12)] = inst_17695);

return statearr_17748;
})();
var statearr_17749_17777 = state_17730__$1;
(statearr_17749_17777[(2)] = inst_17696);

(statearr_17749_17777[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (9))){
var inst_17691 = (state_17730[(8)]);
var _ = (function (){var statearr_17750 = state_17730;
(statearr_17750[(4)] = cljs.core.cons((12),(state_17730[(4)])));

return statearr_17750;
})();
var inst_17702 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17691) : chs__$1.call(null,inst_17691));
var inst_17703 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17691) : done.call(null,inst_17691));
var inst_17704 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17702,inst_17703);
var ___$1 = (function (){var statearr_17751 = state_17730;
(statearr_17751[(4)] = cljs.core.rest((state_17730[(4)])));

return statearr_17751;
})();
var state_17730__$1 = state_17730;
var statearr_17752_17778 = state_17730__$1;
(statearr_17752_17778[(2)] = inst_17704);

(statearr_17752_17778[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (5))){
var inst_17714 = (state_17730[(2)]);
var state_17730__$1 = (function (){var statearr_17753 = state_17730;
(statearr_17753[(13)] = inst_17714);

return statearr_17753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17730__$1,(13),dchan);
} else {
if((state_val_17731 === (14))){
var inst_17719 = cljs.core.async.close_BANG_(out);
var state_17730__$1 = state_17730;
var statearr_17754_17779 = state_17730__$1;
(statearr_17754_17779[(2)] = inst_17719);

(statearr_17754_17779[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (16))){
var inst_17726 = (state_17730[(2)]);
var state_17730__$1 = state_17730;
var statearr_17755_17780 = state_17730__$1;
(statearr_17755_17780[(2)] = inst_17726);

(statearr_17755_17780[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (10))){
var inst_17691 = (state_17730[(8)]);
var inst_17707 = (state_17730[(2)]);
var inst_17708 = (inst_17691 + (1));
var inst_17691__$1 = inst_17708;
var state_17730__$1 = (function (){var statearr_17756 = state_17730;
(statearr_17756[(14)] = inst_17707);

(statearr_17756[(8)] = inst_17691__$1);

return statearr_17756;
})();
var statearr_17757_17781 = state_17730__$1;
(statearr_17757_17781[(2)] = null);

(statearr_17757_17781[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17731 === (8))){
var inst_17712 = (state_17730[(2)]);
var state_17730__$1 = state_17730;
var statearr_17758_17782 = state_17730__$1;
(statearr_17758_17782[(2)] = inst_17712);

(statearr_17758_17782[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_17759 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17759[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_17759[(1)] = (1));

return statearr_17759;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_17730){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17730);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17760){var ex__16304__auto__ = e17760;
var statearr_17761_17783 = state_17730;
(statearr_17761_17783[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17730[(4)]))){
var statearr_17762_17784 = state_17730;
(statearr_17762_17784[(1)] = cljs.core.first((state_17730[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17785 = state_17730;
state_17730 = G__17785;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_17730){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_17730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17763 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17763[(6)] = c__16375__auto___17765);

return statearr_17763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__17788 = arguments.length;
switch (G__17788) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___17843 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17820){
var state_val_17821 = (state_17820[(1)]);
if((state_val_17821 === (7))){
var inst_17799 = (state_17820[(7)]);
var inst_17800 = (state_17820[(8)]);
var inst_17799__$1 = (state_17820[(2)]);
var inst_17800__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17799__$1,(0),null);
var inst_17801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17799__$1,(1),null);
var inst_17802 = (inst_17800__$1 == null);
var state_17820__$1 = (function (){var statearr_17822 = state_17820;
(statearr_17822[(7)] = inst_17799__$1);

(statearr_17822[(8)] = inst_17800__$1);

(statearr_17822[(9)] = inst_17801);

return statearr_17822;
})();
if(cljs.core.truth_(inst_17802)){
var statearr_17823_17844 = state_17820__$1;
(statearr_17823_17844[(1)] = (8));

} else {
var statearr_17824_17845 = state_17820__$1;
(statearr_17824_17845[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (1))){
var inst_17789 = cljs.core.vec(chs);
var inst_17790 = inst_17789;
var state_17820__$1 = (function (){var statearr_17825 = state_17820;
(statearr_17825[(10)] = inst_17790);

return statearr_17825;
})();
var statearr_17826_17846 = state_17820__$1;
(statearr_17826_17846[(2)] = null);

(statearr_17826_17846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (4))){
var inst_17790 = (state_17820[(10)]);
var state_17820__$1 = state_17820;
return cljs.core.async.ioc_alts_BANG_(state_17820__$1,(7),inst_17790);
} else {
if((state_val_17821 === (6))){
var inst_17816 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17827_17847 = state_17820__$1;
(statearr_17827_17847[(2)] = inst_17816);

(statearr_17827_17847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (3))){
var inst_17818 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17820__$1,inst_17818);
} else {
if((state_val_17821 === (2))){
var inst_17790 = (state_17820[(10)]);
var inst_17792 = cljs.core.count(inst_17790);
var inst_17793 = (inst_17792 > (0));
var state_17820__$1 = state_17820;
if(cljs.core.truth_(inst_17793)){
var statearr_17829_17848 = state_17820__$1;
(statearr_17829_17848[(1)] = (4));

} else {
var statearr_17830_17849 = state_17820__$1;
(statearr_17830_17849[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (11))){
var inst_17790 = (state_17820[(10)]);
var inst_17809 = (state_17820[(2)]);
var tmp17828 = inst_17790;
var inst_17790__$1 = tmp17828;
var state_17820__$1 = (function (){var statearr_17831 = state_17820;
(statearr_17831[(10)] = inst_17790__$1);

(statearr_17831[(11)] = inst_17809);

return statearr_17831;
})();
var statearr_17832_17850 = state_17820__$1;
(statearr_17832_17850[(2)] = null);

(statearr_17832_17850[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (9))){
var inst_17800 = (state_17820[(8)]);
var state_17820__$1 = state_17820;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17820__$1,(11),out,inst_17800);
} else {
if((state_val_17821 === (5))){
var inst_17814 = cljs.core.async.close_BANG_(out);
var state_17820__$1 = state_17820;
var statearr_17833_17851 = state_17820__$1;
(statearr_17833_17851[(2)] = inst_17814);

(statearr_17833_17851[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (10))){
var inst_17812 = (state_17820[(2)]);
var state_17820__$1 = state_17820;
var statearr_17834_17852 = state_17820__$1;
(statearr_17834_17852[(2)] = inst_17812);

(statearr_17834_17852[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17821 === (8))){
var inst_17799 = (state_17820[(7)]);
var inst_17800 = (state_17820[(8)]);
var inst_17790 = (state_17820[(10)]);
var inst_17801 = (state_17820[(9)]);
var inst_17804 = (function (){var cs = inst_17790;
var vec__17795 = inst_17799;
var v = inst_17800;
var c = inst_17801;
return (function (p1__17786_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17786_SHARP_);
});
})();
var inst_17805 = cljs.core.filterv(inst_17804,inst_17790);
var inst_17790__$1 = inst_17805;
var state_17820__$1 = (function (){var statearr_17835 = state_17820;
(statearr_17835[(10)] = inst_17790__$1);

return statearr_17835;
})();
var statearr_17836_17853 = state_17820__$1;
(statearr_17836_17853[(2)] = null);

(statearr_17836_17853[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_17837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17837[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_17837[(1)] = (1));

return statearr_17837;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_17820){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17820);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17838){var ex__16304__auto__ = e17838;
var statearr_17839_17854 = state_17820;
(statearr_17839_17854[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17820[(4)]))){
var statearr_17840_17855 = state_17820;
(statearr_17840_17855[(1)] = cljs.core.first((state_17820[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17856 = state_17820;
state_17820 = G__17856;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_17820){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_17820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17841 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17841[(6)] = c__16375__auto___17843);

return statearr_17841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__17858 = arguments.length;
switch (G__17858) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___17904 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17882){
var state_val_17883 = (state_17882[(1)]);
if((state_val_17883 === (7))){
var inst_17864 = (state_17882[(7)]);
var inst_17864__$1 = (state_17882[(2)]);
var inst_17865 = (inst_17864__$1 == null);
var inst_17866 = cljs.core.not(inst_17865);
var state_17882__$1 = (function (){var statearr_17884 = state_17882;
(statearr_17884[(7)] = inst_17864__$1);

return statearr_17884;
})();
if(inst_17866){
var statearr_17885_17905 = state_17882__$1;
(statearr_17885_17905[(1)] = (8));

} else {
var statearr_17886_17906 = state_17882__$1;
(statearr_17886_17906[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (1))){
var inst_17859 = (0);
var state_17882__$1 = (function (){var statearr_17887 = state_17882;
(statearr_17887[(8)] = inst_17859);

return statearr_17887;
})();
var statearr_17888_17907 = state_17882__$1;
(statearr_17888_17907[(2)] = null);

(statearr_17888_17907[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (4))){
var state_17882__$1 = state_17882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17882__$1,(7),ch);
} else {
if((state_val_17883 === (6))){
var inst_17877 = (state_17882[(2)]);
var state_17882__$1 = state_17882;
var statearr_17889_17908 = state_17882__$1;
(statearr_17889_17908[(2)] = inst_17877);

(statearr_17889_17908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (3))){
var inst_17879 = (state_17882[(2)]);
var inst_17880 = cljs.core.async.close_BANG_(out);
var state_17882__$1 = (function (){var statearr_17890 = state_17882;
(statearr_17890[(9)] = inst_17879);

return statearr_17890;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17882__$1,inst_17880);
} else {
if((state_val_17883 === (2))){
var inst_17859 = (state_17882[(8)]);
var inst_17861 = (inst_17859 < n);
var state_17882__$1 = state_17882;
if(cljs.core.truth_(inst_17861)){
var statearr_17891_17909 = state_17882__$1;
(statearr_17891_17909[(1)] = (4));

} else {
var statearr_17892_17910 = state_17882__$1;
(statearr_17892_17910[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (11))){
var inst_17859 = (state_17882[(8)]);
var inst_17869 = (state_17882[(2)]);
var inst_17870 = (inst_17859 + (1));
var inst_17859__$1 = inst_17870;
var state_17882__$1 = (function (){var statearr_17893 = state_17882;
(statearr_17893[(10)] = inst_17869);

(statearr_17893[(8)] = inst_17859__$1);

return statearr_17893;
})();
var statearr_17894_17911 = state_17882__$1;
(statearr_17894_17911[(2)] = null);

(statearr_17894_17911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (9))){
var state_17882__$1 = state_17882;
var statearr_17895_17912 = state_17882__$1;
(statearr_17895_17912[(2)] = null);

(statearr_17895_17912[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (5))){
var state_17882__$1 = state_17882;
var statearr_17896_17913 = state_17882__$1;
(statearr_17896_17913[(2)] = null);

(statearr_17896_17913[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (10))){
var inst_17874 = (state_17882[(2)]);
var state_17882__$1 = state_17882;
var statearr_17897_17914 = state_17882__$1;
(statearr_17897_17914[(2)] = inst_17874);

(statearr_17897_17914[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17883 === (8))){
var inst_17864 = (state_17882[(7)]);
var state_17882__$1 = state_17882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17882__$1,(11),out,inst_17864);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_17898 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17898[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_17898[(1)] = (1));

return statearr_17898;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_17882){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17882);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17899){var ex__16304__auto__ = e17899;
var statearr_17900_17915 = state_17882;
(statearr_17900_17915[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17882[(4)]))){
var statearr_17901_17916 = state_17882;
(statearr_17901_17916[(1)] = cljs.core.first((state_17882[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17917 = state_17882;
state_17882 = G__17917;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_17882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_17882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17902 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17902[(6)] = c__16375__auto___17904);

return statearr_17902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17919 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17919 = (function (f,ch,meta17920){
this.f = f;
this.ch = ch;
this.meta17920 = meta17920;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17921,meta17920__$1){
var self__ = this;
var _17921__$1 = this;
return (new cljs.core.async.t_cljs$core$async17919(self__.f,self__.ch,meta17920__$1));
}));

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17921){
var self__ = this;
var _17921__$1 = this;
return self__.meta17920;
}));

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17922 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17922 = (function (f,ch,meta17920,_,fn1,meta17923){
this.f = f;
this.ch = ch;
this.meta17920 = meta17920;
this._ = _;
this.fn1 = fn1;
this.meta17923 = meta17923;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17924,meta17923__$1){
var self__ = this;
var _17924__$1 = this;
return (new cljs.core.async.t_cljs$core$async17922(self__.f,self__.ch,self__.meta17920,self__._,self__.fn1,meta17923__$1));
}));

(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17924){
var self__ = this;
var _17924__$1 = this;
return self__.meta17923;
}));

(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17922.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__17918_SHARP_){
var G__17925 = (((p1__17918_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17918_SHARP_) : self__.f.call(null,p1__17918_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17925) : f1.call(null,G__17925));
});
}));

(cljs.core.async.t_cljs$core$async17922.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17920,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17919], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17923], null);
}));

(cljs.core.async.t_cljs$core$async17922.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17922.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17922");

(cljs.core.async.t_cljs$core$async17922.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17922");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17922.
 */
cljs.core.async.__GT_t_cljs$core$async17922 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17922(f__$1,ch__$1,meta17920__$1,___$2,fn1__$1,meta17923){
return (new cljs.core.async.t_cljs$core$async17922(f__$1,ch__$1,meta17920__$1,___$2,fn1__$1,meta17923));
});

}

return (new cljs.core.async.t_cljs$core$async17922(self__.f,self__.ch,self__.meta17920,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17926 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17926) : self__.f.call(null,G__17926));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17919.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async17919.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17920], null);
}));

(cljs.core.async.t_cljs$core$async17919.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17919.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17919");

(cljs.core.async.t_cljs$core$async17919.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17919");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17919.
 */
cljs.core.async.__GT_t_cljs$core$async17919 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17919(f__$1,ch__$1,meta17920){
return (new cljs.core.async.t_cljs$core$async17919(f__$1,ch__$1,meta17920));
});

}

return (new cljs.core.async.t_cljs$core$async17919(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17927 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17927 = (function (f,ch,meta17928){
this.f = f;
this.ch = ch;
this.meta17928 = meta17928;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17929,meta17928__$1){
var self__ = this;
var _17929__$1 = this;
return (new cljs.core.async.t_cljs$core$async17927(self__.f,self__.ch,meta17928__$1));
}));

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17929){
var self__ = this;
var _17929__$1 = this;
return self__.meta17928;
}));

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17927.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async17927.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17928], null);
}));

(cljs.core.async.t_cljs$core$async17927.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17927.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17927");

(cljs.core.async.t_cljs$core$async17927.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17927");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17927.
 */
cljs.core.async.__GT_t_cljs$core$async17927 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17927(f__$1,ch__$1,meta17928){
return (new cljs.core.async.t_cljs$core$async17927(f__$1,ch__$1,meta17928));
});

}

return (new cljs.core.async.t_cljs$core$async17927(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17930 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17930 = (function (p,ch,meta17931){
this.p = p;
this.ch = ch;
this.meta17931 = meta17931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17932,meta17931__$1){
var self__ = this;
var _17932__$1 = this;
return (new cljs.core.async.t_cljs$core$async17930(self__.p,self__.ch,meta17931__$1));
}));

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17932){
var self__ = this;
var _17932__$1 = this;
return self__.meta17931;
}));

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17930.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async17930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17931], null);
}));

(cljs.core.async.t_cljs$core$async17930.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17930");

(cljs.core.async.t_cljs$core$async17930.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async17930");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17930.
 */
cljs.core.async.__GT_t_cljs$core$async17930 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17930(p__$1,ch__$1,meta17931){
return (new cljs.core.async.t_cljs$core$async17930(p__$1,ch__$1,meta17931));
});

}

return (new cljs.core.async.t_cljs$core$async17930(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__17934 = arguments.length;
switch (G__17934) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___17975 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_17955){
var state_val_17956 = (state_17955[(1)]);
if((state_val_17956 === (7))){
var inst_17951 = (state_17955[(2)]);
var state_17955__$1 = state_17955;
var statearr_17957_17976 = state_17955__$1;
(statearr_17957_17976[(2)] = inst_17951);

(statearr_17957_17976[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (1))){
var state_17955__$1 = state_17955;
var statearr_17958_17977 = state_17955__$1;
(statearr_17958_17977[(2)] = null);

(statearr_17958_17977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (4))){
var inst_17937 = (state_17955[(7)]);
var inst_17937__$1 = (state_17955[(2)]);
var inst_17938 = (inst_17937__$1 == null);
var state_17955__$1 = (function (){var statearr_17959 = state_17955;
(statearr_17959[(7)] = inst_17937__$1);

return statearr_17959;
})();
if(cljs.core.truth_(inst_17938)){
var statearr_17960_17978 = state_17955__$1;
(statearr_17960_17978[(1)] = (5));

} else {
var statearr_17961_17979 = state_17955__$1;
(statearr_17961_17979[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (6))){
var inst_17937 = (state_17955[(7)]);
var inst_17942 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17937) : p.call(null,inst_17937));
var state_17955__$1 = state_17955;
if(cljs.core.truth_(inst_17942)){
var statearr_17962_17980 = state_17955__$1;
(statearr_17962_17980[(1)] = (8));

} else {
var statearr_17963_17981 = state_17955__$1;
(statearr_17963_17981[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (3))){
var inst_17953 = (state_17955[(2)]);
var state_17955__$1 = state_17955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17955__$1,inst_17953);
} else {
if((state_val_17956 === (2))){
var state_17955__$1 = state_17955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17955__$1,(4),ch);
} else {
if((state_val_17956 === (11))){
var inst_17945 = (state_17955[(2)]);
var state_17955__$1 = state_17955;
var statearr_17964_17982 = state_17955__$1;
(statearr_17964_17982[(2)] = inst_17945);

(statearr_17964_17982[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (9))){
var state_17955__$1 = state_17955;
var statearr_17965_17983 = state_17955__$1;
(statearr_17965_17983[(2)] = null);

(statearr_17965_17983[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (5))){
var inst_17940 = cljs.core.async.close_BANG_(out);
var state_17955__$1 = state_17955;
var statearr_17966_17984 = state_17955__$1;
(statearr_17966_17984[(2)] = inst_17940);

(statearr_17966_17984[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (10))){
var inst_17948 = (state_17955[(2)]);
var state_17955__$1 = (function (){var statearr_17967 = state_17955;
(statearr_17967[(8)] = inst_17948);

return statearr_17967;
})();
var statearr_17968_17985 = state_17955__$1;
(statearr_17968_17985[(2)] = null);

(statearr_17968_17985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17956 === (8))){
var inst_17937 = (state_17955[(7)]);
var state_17955__$1 = state_17955;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17955__$1,(11),out,inst_17937);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_17969 = [null,null,null,null,null,null,null,null,null];
(statearr_17969[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_17969[(1)] = (1));

return statearr_17969;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_17955){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_17955);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e17970){var ex__16304__auto__ = e17970;
var statearr_17971_17986 = state_17955;
(statearr_17971_17986[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_17955[(4)]))){
var statearr_17972_17987 = state_17955;
(statearr_17972_17987[(1)] = cljs.core.first((state_17955[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__17988 = state_17955;
state_17955 = G__17988;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_17955){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_17955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_17973 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_17973[(6)] = c__16375__auto___17975);

return statearr_17973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__17990 = arguments.length;
switch (G__17990) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_18053){
var state_val_18054 = (state_18053[(1)]);
if((state_val_18054 === (7))){
var inst_18049 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
var statearr_18055_18094 = state_18053__$1;
(statearr_18055_18094[(2)] = inst_18049);

(statearr_18055_18094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (20))){
var inst_18019 = (state_18053[(7)]);
var inst_18030 = (state_18053[(2)]);
var inst_18031 = cljs.core.next(inst_18019);
var inst_18005 = inst_18031;
var inst_18006 = null;
var inst_18007 = (0);
var inst_18008 = (0);
var state_18053__$1 = (function (){var statearr_18056 = state_18053;
(statearr_18056[(8)] = inst_18008);

(statearr_18056[(9)] = inst_18005);

(statearr_18056[(10)] = inst_18030);

(statearr_18056[(11)] = inst_18007);

(statearr_18056[(12)] = inst_18006);

return statearr_18056;
})();
var statearr_18057_18095 = state_18053__$1;
(statearr_18057_18095[(2)] = null);

(statearr_18057_18095[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (1))){
var state_18053__$1 = state_18053;
var statearr_18058_18096 = state_18053__$1;
(statearr_18058_18096[(2)] = null);

(statearr_18058_18096[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (4))){
var inst_17994 = (state_18053[(13)]);
var inst_17994__$1 = (state_18053[(2)]);
var inst_17995 = (inst_17994__$1 == null);
var state_18053__$1 = (function (){var statearr_18059 = state_18053;
(statearr_18059[(13)] = inst_17994__$1);

return statearr_18059;
})();
if(cljs.core.truth_(inst_17995)){
var statearr_18060_18097 = state_18053__$1;
(statearr_18060_18097[(1)] = (5));

} else {
var statearr_18061_18098 = state_18053__$1;
(statearr_18061_18098[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (15))){
var state_18053__$1 = state_18053;
var statearr_18065_18099 = state_18053__$1;
(statearr_18065_18099[(2)] = null);

(statearr_18065_18099[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (21))){
var state_18053__$1 = state_18053;
var statearr_18066_18100 = state_18053__$1;
(statearr_18066_18100[(2)] = null);

(statearr_18066_18100[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (13))){
var inst_18008 = (state_18053[(8)]);
var inst_18005 = (state_18053[(9)]);
var inst_18007 = (state_18053[(11)]);
var inst_18006 = (state_18053[(12)]);
var inst_18015 = (state_18053[(2)]);
var inst_18016 = (inst_18008 + (1));
var tmp18062 = inst_18005;
var tmp18063 = inst_18007;
var tmp18064 = inst_18006;
var inst_18005__$1 = tmp18062;
var inst_18006__$1 = tmp18064;
var inst_18007__$1 = tmp18063;
var inst_18008__$1 = inst_18016;
var state_18053__$1 = (function (){var statearr_18067 = state_18053;
(statearr_18067[(8)] = inst_18008__$1);

(statearr_18067[(9)] = inst_18005__$1);

(statearr_18067[(14)] = inst_18015);

(statearr_18067[(11)] = inst_18007__$1);

(statearr_18067[(12)] = inst_18006__$1);

return statearr_18067;
})();
var statearr_18068_18101 = state_18053__$1;
(statearr_18068_18101[(2)] = null);

(statearr_18068_18101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (22))){
var state_18053__$1 = state_18053;
var statearr_18069_18102 = state_18053__$1;
(statearr_18069_18102[(2)] = null);

(statearr_18069_18102[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (6))){
var inst_17994 = (state_18053[(13)]);
var inst_18003 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17994) : f.call(null,inst_17994));
var inst_18004 = cljs.core.seq(inst_18003);
var inst_18005 = inst_18004;
var inst_18006 = null;
var inst_18007 = (0);
var inst_18008 = (0);
var state_18053__$1 = (function (){var statearr_18070 = state_18053;
(statearr_18070[(8)] = inst_18008);

(statearr_18070[(9)] = inst_18005);

(statearr_18070[(11)] = inst_18007);

(statearr_18070[(12)] = inst_18006);

return statearr_18070;
})();
var statearr_18071_18103 = state_18053__$1;
(statearr_18071_18103[(2)] = null);

(statearr_18071_18103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (17))){
var inst_18019 = (state_18053[(7)]);
var inst_18023 = cljs.core.chunk_first(inst_18019);
var inst_18024 = cljs.core.chunk_rest(inst_18019);
var inst_18025 = cljs.core.count(inst_18023);
var inst_18005 = inst_18024;
var inst_18006 = inst_18023;
var inst_18007 = inst_18025;
var inst_18008 = (0);
var state_18053__$1 = (function (){var statearr_18072 = state_18053;
(statearr_18072[(8)] = inst_18008);

(statearr_18072[(9)] = inst_18005);

(statearr_18072[(11)] = inst_18007);

(statearr_18072[(12)] = inst_18006);

return statearr_18072;
})();
var statearr_18073_18104 = state_18053__$1;
(statearr_18073_18104[(2)] = null);

(statearr_18073_18104[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (3))){
var inst_18051 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18053__$1,inst_18051);
} else {
if((state_val_18054 === (12))){
var inst_18039 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
var statearr_18074_18105 = state_18053__$1;
(statearr_18074_18105[(2)] = inst_18039);

(statearr_18074_18105[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (2))){
var state_18053__$1 = state_18053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18053__$1,(4),in$);
} else {
if((state_val_18054 === (23))){
var inst_18047 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
var statearr_18075_18106 = state_18053__$1;
(statearr_18075_18106[(2)] = inst_18047);

(statearr_18075_18106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (19))){
var inst_18034 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
var statearr_18076_18107 = state_18053__$1;
(statearr_18076_18107[(2)] = inst_18034);

(statearr_18076_18107[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (11))){
var inst_18005 = (state_18053[(9)]);
var inst_18019 = (state_18053[(7)]);
var inst_18019__$1 = cljs.core.seq(inst_18005);
var state_18053__$1 = (function (){var statearr_18077 = state_18053;
(statearr_18077[(7)] = inst_18019__$1);

return statearr_18077;
})();
if(inst_18019__$1){
var statearr_18078_18108 = state_18053__$1;
(statearr_18078_18108[(1)] = (14));

} else {
var statearr_18079_18109 = state_18053__$1;
(statearr_18079_18109[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (9))){
var inst_18041 = (state_18053[(2)]);
var inst_18042 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18053__$1 = (function (){var statearr_18080 = state_18053;
(statearr_18080[(15)] = inst_18041);

return statearr_18080;
})();
if(cljs.core.truth_(inst_18042)){
var statearr_18081_18110 = state_18053__$1;
(statearr_18081_18110[(1)] = (21));

} else {
var statearr_18082_18111 = state_18053__$1;
(statearr_18082_18111[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (5))){
var inst_17997 = cljs.core.async.close_BANG_(out);
var state_18053__$1 = state_18053;
var statearr_18083_18112 = state_18053__$1;
(statearr_18083_18112[(2)] = inst_17997);

(statearr_18083_18112[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (14))){
var inst_18019 = (state_18053[(7)]);
var inst_18021 = cljs.core.chunked_seq_QMARK_(inst_18019);
var state_18053__$1 = state_18053;
if(inst_18021){
var statearr_18084_18113 = state_18053__$1;
(statearr_18084_18113[(1)] = (17));

} else {
var statearr_18085_18114 = state_18053__$1;
(statearr_18085_18114[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (16))){
var inst_18037 = (state_18053[(2)]);
var state_18053__$1 = state_18053;
var statearr_18086_18115 = state_18053__$1;
(statearr_18086_18115[(2)] = inst_18037);

(statearr_18086_18115[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18054 === (10))){
var inst_18008 = (state_18053[(8)]);
var inst_18006 = (state_18053[(12)]);
var inst_18013 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18006,inst_18008);
var state_18053__$1 = state_18053;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18053__$1,(13),out,inst_18013);
} else {
if((state_val_18054 === (18))){
var inst_18019 = (state_18053[(7)]);
var inst_18028 = cljs.core.first(inst_18019);
var state_18053__$1 = state_18053;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18053__$1,(20),out,inst_18028);
} else {
if((state_val_18054 === (8))){
var inst_18008 = (state_18053[(8)]);
var inst_18007 = (state_18053[(11)]);
var inst_18010 = (inst_18008 < inst_18007);
var inst_18011 = inst_18010;
var state_18053__$1 = state_18053;
if(cljs.core.truth_(inst_18011)){
var statearr_18087_18116 = state_18053__$1;
(statearr_18087_18116[(1)] = (10));

} else {
var statearr_18088_18117 = state_18053__$1;
(statearr_18088_18117[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____0 = (function (){
var statearr_18089 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18089[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__);

(statearr_18089[(1)] = (1));

return statearr_18089;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____1 = (function (state_18053){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_18053);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e18090){var ex__16304__auto__ = e18090;
var statearr_18091_18118 = state_18053;
(statearr_18091_18118[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_18053[(4)]))){
var statearr_18092_18119 = state_18053;
(statearr_18092_18119[(1)] = cljs.core.first((state_18053[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__18120 = state_18053;
state_18053 = G__18120;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__ = function(state_18053){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____1.call(this,state_18053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16301__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_18093 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_18093[(6)] = c__16375__auto__);

return statearr_18093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18122 = arguments.length;
switch (G__18122) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18125 = arguments.length;
switch (G__18125) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18128 = arguments.length;
switch (G__18128) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___18176 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_18152){
var state_val_18153 = (state_18152[(1)]);
if((state_val_18153 === (7))){
var inst_18147 = (state_18152[(2)]);
var state_18152__$1 = state_18152;
var statearr_18154_18177 = state_18152__$1;
(statearr_18154_18177[(2)] = inst_18147);

(statearr_18154_18177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (1))){
var inst_18129 = null;
var state_18152__$1 = (function (){var statearr_18155 = state_18152;
(statearr_18155[(7)] = inst_18129);

return statearr_18155;
})();
var statearr_18156_18178 = state_18152__$1;
(statearr_18156_18178[(2)] = null);

(statearr_18156_18178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (4))){
var inst_18132 = (state_18152[(8)]);
var inst_18132__$1 = (state_18152[(2)]);
var inst_18133 = (inst_18132__$1 == null);
var inst_18134 = cljs.core.not(inst_18133);
var state_18152__$1 = (function (){var statearr_18157 = state_18152;
(statearr_18157[(8)] = inst_18132__$1);

return statearr_18157;
})();
if(inst_18134){
var statearr_18158_18179 = state_18152__$1;
(statearr_18158_18179[(1)] = (5));

} else {
var statearr_18159_18180 = state_18152__$1;
(statearr_18159_18180[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (6))){
var state_18152__$1 = state_18152;
var statearr_18160_18181 = state_18152__$1;
(statearr_18160_18181[(2)] = null);

(statearr_18160_18181[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (3))){
var inst_18149 = (state_18152[(2)]);
var inst_18150 = cljs.core.async.close_BANG_(out);
var state_18152__$1 = (function (){var statearr_18161 = state_18152;
(statearr_18161[(9)] = inst_18149);

return statearr_18161;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18152__$1,inst_18150);
} else {
if((state_val_18153 === (2))){
var state_18152__$1 = state_18152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18152__$1,(4),ch);
} else {
if((state_val_18153 === (11))){
var inst_18132 = (state_18152[(8)]);
var inst_18141 = (state_18152[(2)]);
var inst_18129 = inst_18132;
var state_18152__$1 = (function (){var statearr_18162 = state_18152;
(statearr_18162[(10)] = inst_18141);

(statearr_18162[(7)] = inst_18129);

return statearr_18162;
})();
var statearr_18163_18182 = state_18152__$1;
(statearr_18163_18182[(2)] = null);

(statearr_18163_18182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (9))){
var inst_18132 = (state_18152[(8)]);
var state_18152__$1 = state_18152;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18152__$1,(11),out,inst_18132);
} else {
if((state_val_18153 === (5))){
var inst_18132 = (state_18152[(8)]);
var inst_18129 = (state_18152[(7)]);
var inst_18136 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18132,inst_18129);
var state_18152__$1 = state_18152;
if(inst_18136){
var statearr_18165_18183 = state_18152__$1;
(statearr_18165_18183[(1)] = (8));

} else {
var statearr_18166_18184 = state_18152__$1;
(statearr_18166_18184[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (10))){
var inst_18144 = (state_18152[(2)]);
var state_18152__$1 = state_18152;
var statearr_18167_18185 = state_18152__$1;
(statearr_18167_18185[(2)] = inst_18144);

(statearr_18167_18185[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18153 === (8))){
var inst_18129 = (state_18152[(7)]);
var tmp18164 = inst_18129;
var inst_18129__$1 = tmp18164;
var state_18152__$1 = (function (){var statearr_18168 = state_18152;
(statearr_18168[(7)] = inst_18129__$1);

return statearr_18168;
})();
var statearr_18169_18186 = state_18152__$1;
(statearr_18169_18186[(2)] = null);

(statearr_18169_18186[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_18170 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18170[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_18170[(1)] = (1));

return statearr_18170;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_18152){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_18152);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e18171){var ex__16304__auto__ = e18171;
var statearr_18172_18187 = state_18152;
(statearr_18172_18187[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_18152[(4)]))){
var statearr_18173_18188 = state_18152;
(statearr_18173_18188[(1)] = cljs.core.first((state_18152[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__18189 = state_18152;
state_18152 = G__18189;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_18152){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_18152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_18174 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_18174[(6)] = c__16375__auto___18176);

return statearr_18174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18191 = arguments.length;
switch (G__18191) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___18258 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_18229){
var state_val_18230 = (state_18229[(1)]);
if((state_val_18230 === (7))){
var inst_18225 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
var statearr_18231_18259 = state_18229__$1;
(statearr_18231_18259[(2)] = inst_18225);

(statearr_18231_18259[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (1))){
var inst_18192 = (new Array(n));
var inst_18193 = inst_18192;
var inst_18194 = (0);
var state_18229__$1 = (function (){var statearr_18232 = state_18229;
(statearr_18232[(7)] = inst_18194);

(statearr_18232[(8)] = inst_18193);

return statearr_18232;
})();
var statearr_18233_18260 = state_18229__$1;
(statearr_18233_18260[(2)] = null);

(statearr_18233_18260[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (4))){
var inst_18197 = (state_18229[(9)]);
var inst_18197__$1 = (state_18229[(2)]);
var inst_18198 = (inst_18197__$1 == null);
var inst_18199 = cljs.core.not(inst_18198);
var state_18229__$1 = (function (){var statearr_18234 = state_18229;
(statearr_18234[(9)] = inst_18197__$1);

return statearr_18234;
})();
if(inst_18199){
var statearr_18235_18261 = state_18229__$1;
(statearr_18235_18261[(1)] = (5));

} else {
var statearr_18236_18262 = state_18229__$1;
(statearr_18236_18262[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (15))){
var inst_18219 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
var statearr_18237_18263 = state_18229__$1;
(statearr_18237_18263[(2)] = inst_18219);

(statearr_18237_18263[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (13))){
var state_18229__$1 = state_18229;
var statearr_18238_18264 = state_18229__$1;
(statearr_18238_18264[(2)] = null);

(statearr_18238_18264[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (6))){
var inst_18194 = (state_18229[(7)]);
var inst_18215 = (inst_18194 > (0));
var state_18229__$1 = state_18229;
if(cljs.core.truth_(inst_18215)){
var statearr_18239_18265 = state_18229__$1;
(statearr_18239_18265[(1)] = (12));

} else {
var statearr_18240_18266 = state_18229__$1;
(statearr_18240_18266[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (3))){
var inst_18227 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18229__$1,inst_18227);
} else {
if((state_val_18230 === (12))){
var inst_18193 = (state_18229[(8)]);
var inst_18217 = cljs.core.vec(inst_18193);
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18229__$1,(15),out,inst_18217);
} else {
if((state_val_18230 === (2))){
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18229__$1,(4),ch);
} else {
if((state_val_18230 === (11))){
var inst_18209 = (state_18229[(2)]);
var inst_18210 = (new Array(n));
var inst_18193 = inst_18210;
var inst_18194 = (0);
var state_18229__$1 = (function (){var statearr_18241 = state_18229;
(statearr_18241[(7)] = inst_18194);

(statearr_18241[(10)] = inst_18209);

(statearr_18241[(8)] = inst_18193);

return statearr_18241;
})();
var statearr_18242_18267 = state_18229__$1;
(statearr_18242_18267[(2)] = null);

(statearr_18242_18267[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (9))){
var inst_18193 = (state_18229[(8)]);
var inst_18207 = cljs.core.vec(inst_18193);
var state_18229__$1 = state_18229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18229__$1,(11),out,inst_18207);
} else {
if((state_val_18230 === (5))){
var inst_18194 = (state_18229[(7)]);
var inst_18197 = (state_18229[(9)]);
var inst_18202 = (state_18229[(11)]);
var inst_18193 = (state_18229[(8)]);
var inst_18201 = (inst_18193[inst_18194] = inst_18197);
var inst_18202__$1 = (inst_18194 + (1));
var inst_18203 = (inst_18202__$1 < n);
var state_18229__$1 = (function (){var statearr_18243 = state_18229;
(statearr_18243[(12)] = inst_18201);

(statearr_18243[(11)] = inst_18202__$1);

return statearr_18243;
})();
if(cljs.core.truth_(inst_18203)){
var statearr_18244_18268 = state_18229__$1;
(statearr_18244_18268[(1)] = (8));

} else {
var statearr_18245_18269 = state_18229__$1;
(statearr_18245_18269[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (14))){
var inst_18222 = (state_18229[(2)]);
var inst_18223 = cljs.core.async.close_BANG_(out);
var state_18229__$1 = (function (){var statearr_18247 = state_18229;
(statearr_18247[(13)] = inst_18222);

return statearr_18247;
})();
var statearr_18248_18270 = state_18229__$1;
(statearr_18248_18270[(2)] = inst_18223);

(statearr_18248_18270[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (10))){
var inst_18213 = (state_18229[(2)]);
var state_18229__$1 = state_18229;
var statearr_18249_18271 = state_18229__$1;
(statearr_18249_18271[(2)] = inst_18213);

(statearr_18249_18271[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18230 === (8))){
var inst_18202 = (state_18229[(11)]);
var inst_18193 = (state_18229[(8)]);
var tmp18246 = inst_18193;
var inst_18193__$1 = tmp18246;
var inst_18194 = inst_18202;
var state_18229__$1 = (function (){var statearr_18250 = state_18229;
(statearr_18250[(7)] = inst_18194);

(statearr_18250[(8)] = inst_18193__$1);

return statearr_18250;
})();
var statearr_18251_18272 = state_18229__$1;
(statearr_18251_18272[(2)] = null);

(statearr_18251_18272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_18252 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18252[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_18252[(1)] = (1));

return statearr_18252;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_18229){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_18229);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e18253){var ex__16304__auto__ = e18253;
var statearr_18254_18273 = state_18229;
(statearr_18254_18273[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_18229[(4)]))){
var statearr_18255_18274 = state_18229;
(statearr_18255_18274[(1)] = cljs.core.first((state_18229[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__18275 = state_18229;
state_18229 = G__18275;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_18229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_18229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_18256 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_18256[(6)] = c__16375__auto___18258);

return statearr_18256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18277 = arguments.length;
switch (G__18277) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16375__auto___18348 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_18319){
var state_val_18320 = (state_18319[(1)]);
if((state_val_18320 === (7))){
var inst_18315 = (state_18319[(2)]);
var state_18319__$1 = state_18319;
var statearr_18321_18349 = state_18319__$1;
(statearr_18321_18349[(2)] = inst_18315);

(statearr_18321_18349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (1))){
var inst_18278 = [];
var inst_18279 = inst_18278;
var inst_18280 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_18319__$1 = (function (){var statearr_18322 = state_18319;
(statearr_18322[(7)] = inst_18279);

(statearr_18322[(8)] = inst_18280);

return statearr_18322;
})();
var statearr_18323_18350 = state_18319__$1;
(statearr_18323_18350[(2)] = null);

(statearr_18323_18350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (4))){
var inst_18283 = (state_18319[(9)]);
var inst_18283__$1 = (state_18319[(2)]);
var inst_18284 = (inst_18283__$1 == null);
var inst_18285 = cljs.core.not(inst_18284);
var state_18319__$1 = (function (){var statearr_18324 = state_18319;
(statearr_18324[(9)] = inst_18283__$1);

return statearr_18324;
})();
if(inst_18285){
var statearr_18325_18351 = state_18319__$1;
(statearr_18325_18351[(1)] = (5));

} else {
var statearr_18326_18352 = state_18319__$1;
(statearr_18326_18352[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (15))){
var inst_18309 = (state_18319[(2)]);
var state_18319__$1 = state_18319;
var statearr_18327_18353 = state_18319__$1;
(statearr_18327_18353[(2)] = inst_18309);

(statearr_18327_18353[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (13))){
var state_18319__$1 = state_18319;
var statearr_18328_18354 = state_18319__$1;
(statearr_18328_18354[(2)] = null);

(statearr_18328_18354[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (6))){
var inst_18279 = (state_18319[(7)]);
var inst_18304 = inst_18279.length;
var inst_18305 = (inst_18304 > (0));
var state_18319__$1 = state_18319;
if(cljs.core.truth_(inst_18305)){
var statearr_18329_18355 = state_18319__$1;
(statearr_18329_18355[(1)] = (12));

} else {
var statearr_18330_18356 = state_18319__$1;
(statearr_18330_18356[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (3))){
var inst_18317 = (state_18319[(2)]);
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18319__$1,inst_18317);
} else {
if((state_val_18320 === (12))){
var inst_18279 = (state_18319[(7)]);
var inst_18307 = cljs.core.vec(inst_18279);
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18319__$1,(15),out,inst_18307);
} else {
if((state_val_18320 === (2))){
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18319__$1,(4),ch);
} else {
if((state_val_18320 === (11))){
var inst_18287 = (state_18319[(10)]);
var inst_18283 = (state_18319[(9)]);
var inst_18297 = (state_18319[(2)]);
var inst_18298 = [];
var inst_18299 = inst_18298.push(inst_18283);
var inst_18279 = inst_18298;
var inst_18280 = inst_18287;
var state_18319__$1 = (function (){var statearr_18331 = state_18319;
(statearr_18331[(7)] = inst_18279);

(statearr_18331[(11)] = inst_18299);

(statearr_18331[(12)] = inst_18297);

(statearr_18331[(8)] = inst_18280);

return statearr_18331;
})();
var statearr_18332_18357 = state_18319__$1;
(statearr_18332_18357[(2)] = null);

(statearr_18332_18357[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (9))){
var inst_18279 = (state_18319[(7)]);
var inst_18295 = cljs.core.vec(inst_18279);
var state_18319__$1 = state_18319;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18319__$1,(11),out,inst_18295);
} else {
if((state_val_18320 === (5))){
var inst_18287 = (state_18319[(10)]);
var inst_18283 = (state_18319[(9)]);
var inst_18280 = (state_18319[(8)]);
var inst_18287__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18283) : f.call(null,inst_18283));
var inst_18288 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18287__$1,inst_18280);
var inst_18289 = cljs.core.keyword_identical_QMARK_(inst_18280,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_18290 = ((inst_18288) || (inst_18289));
var state_18319__$1 = (function (){var statearr_18333 = state_18319;
(statearr_18333[(10)] = inst_18287__$1);

return statearr_18333;
})();
if(cljs.core.truth_(inst_18290)){
var statearr_18334_18358 = state_18319__$1;
(statearr_18334_18358[(1)] = (8));

} else {
var statearr_18335_18359 = state_18319__$1;
(statearr_18335_18359[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (14))){
var inst_18312 = (state_18319[(2)]);
var inst_18313 = cljs.core.async.close_BANG_(out);
var state_18319__$1 = (function (){var statearr_18337 = state_18319;
(statearr_18337[(13)] = inst_18312);

return statearr_18337;
})();
var statearr_18338_18360 = state_18319__$1;
(statearr_18338_18360[(2)] = inst_18313);

(statearr_18338_18360[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (10))){
var inst_18302 = (state_18319[(2)]);
var state_18319__$1 = state_18319;
var statearr_18339_18361 = state_18319__$1;
(statearr_18339_18361[(2)] = inst_18302);

(statearr_18339_18361[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18320 === (8))){
var inst_18287 = (state_18319[(10)]);
var inst_18279 = (state_18319[(7)]);
var inst_18283 = (state_18319[(9)]);
var inst_18292 = inst_18279.push(inst_18283);
var tmp18336 = inst_18279;
var inst_18279__$1 = tmp18336;
var inst_18280 = inst_18287;
var state_18319__$1 = (function (){var statearr_18340 = state_18319;
(statearr_18340[(7)] = inst_18279__$1);

(statearr_18340[(14)] = inst_18292);

(statearr_18340[(8)] = inst_18280);

return statearr_18340;
})();
var statearr_18341_18362 = state_18319__$1;
(statearr_18341_18362[(2)] = null);

(statearr_18341_18362[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__16301__auto__ = null;
var cljs$core$async$state_machine__16301__auto____0 = (function (){
var statearr_18342 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18342[(0)] = cljs$core$async$state_machine__16301__auto__);

(statearr_18342[(1)] = (1));

return statearr_18342;
});
var cljs$core$async$state_machine__16301__auto____1 = (function (state_18319){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_18319);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e18343){var ex__16304__auto__ = e18343;
var statearr_18344_18363 = state_18319;
(statearr_18344_18363[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_18319[(4)]))){
var statearr_18345_18364 = state_18319;
(statearr_18345_18364[(1)] = cljs.core.first((state_18319[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__18365 = state_18319;
state_18319 = G__18365;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
cljs$core$async$state_machine__16301__auto__ = function(state_18319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16301__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16301__auto____1.call(this,state_18319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16301__auto____0;
cljs$core$async$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16301__auto____1;
return cljs$core$async$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_18346 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_18346[(6)] = c__16375__auto___18348);

return statearr_18346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

