// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40116 = arguments.length;
var i__4737__auto___40117 = (0);
while(true){
if((i__4737__auto___40117 < len__4736__auto___40116)){
args__4742__auto__.push((arguments[i__4737__auto___40117]));

var G__40118 = (i__4737__auto___40117 + (1));
i__4737__auto___40117 = G__40118;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq40113){
var G__40114 = cljs.core.first(seq40113);
var seq40113__$1 = cljs.core.next(seq40113);
var G__40115 = cljs.core.first(seq40113__$1);
var seq40113__$2 = cljs.core.next(seq40113__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40114,G__40115,seq40113__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e40119){var e = e40119;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e40120){var e = e40120;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e40121){var e = e40121;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e40122){var e = e40122;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e40123){var e = e40123;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40126 = arguments.length;
var i__4737__auto___40127 = (0);
while(true){
if((i__4737__auto___40127 < len__4736__auto___40126)){
args__4742__auto__.push((arguments[i__4737__auto___40127]));

var G__40128 = (i__4737__auto___40127 + (1));
i__4737__auto___40127 = G__40128;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40125){var e = e40125;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq40124){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40124));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40131 = arguments.length;
var i__4737__auto___40132 = (0);
while(true){
if((i__4737__auto___40132 < len__4736__auto___40131)){
args__4742__auto__.push((arguments[i__4737__auto___40132]));

var G__40133 = (i__4737__auto___40132 + (1));
i__4737__auto___40132 = G__40133;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40130){var e = e40130;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq40129){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40129));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e40134){var e = e40134;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40137 = arguments.length;
var i__4737__auto___40138 = (0);
while(true){
if((i__4737__auto___40138 < len__4736__auto___40137)){
args__4742__auto__.push((arguments[i__4737__auto___40138]));

var G__40139 = (i__4737__auto___40138 + (1));
i__4737__auto___40138 = G__40139;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e40136){var e = e40136;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq40135){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40135));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40142 = arguments.length;
var i__4737__auto___40143 = (0);
while(true){
if((i__4737__auto___40143 < len__4736__auto___40142)){
args__4742__auto__.push((arguments[i__4737__auto___40143]));

var G__40144 = (i__4737__auto___40143 + (1));
i__4737__auto___40143 = G__40144;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e40141){var e = e40141;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq40140){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40140));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e40145){var e = e40145;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e40146){var e = e40146;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40149 = arguments.length;
var i__4737__auto___40150 = (0);
while(true){
if((i__4737__auto___40150 < len__4736__auto___40149)){
args__4742__auto__.push((arguments[i__4737__auto___40150]));

var G__40151 = (i__4737__auto___40150 + (1));
i__4737__auto___40150 = G__40151;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40148){var e = e40148;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq40147){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40147));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40154 = arguments.length;
var i__4737__auto___40155 = (0);
while(true){
if((i__4737__auto___40155 < len__4736__auto___40154)){
args__4742__auto__.push((arguments[i__4737__auto___40155]));

var G__40156 = (i__4737__auto___40155 + (1));
i__4737__auto___40155 = G__40156;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40153){var e = e40153;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq40152){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40152));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40159 = arguments.length;
var i__4737__auto___40160 = (0);
while(true){
if((i__4737__auto___40160 < len__4736__auto___40159)){
args__4742__auto__.push((arguments[i__4737__auto___40160]));

var G__40161 = (i__4737__auto___40160 + (1));
i__4737__auto___40160 = G__40161;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e40158){var e = e40158;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq40157){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40157));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40164 = arguments.length;
var i__4737__auto___40165 = (0);
while(true){
if((i__4737__auto___40165 < len__4736__auto___40164)){
args__4742__auto__.push((arguments[i__4737__auto___40165]));

var G__40166 = (i__4737__auto___40165 + (1));
i__4737__auto___40165 = G__40166;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e40163){var e = e40163;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq40162){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40162));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40169 = arguments.length;
var i__4737__auto___40170 = (0);
while(true){
if((i__4737__auto___40170 < len__4736__auto___40169)){
args__4742__auto__.push((arguments[i__4737__auto___40170]));

var G__40171 = (i__4737__auto___40170 + (1));
i__4737__auto___40170 = G__40171;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e40168){var e = e40168;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq40167){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40167));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40174 = arguments.length;
var i__4737__auto___40175 = (0);
while(true){
if((i__4737__auto___40175 < len__4736__auto___40174)){
args__4742__auto__.push((arguments[i__4737__auto___40175]));

var G__40176 = (i__4737__auto___40175 + (1));
i__4737__auto___40175 = G__40176;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e40173){var e = e40173;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq40172){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40172));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40179 = arguments.length;
var i__4737__auto___40180 = (0);
while(true){
if((i__4737__auto___40180 < len__4736__auto___40179)){
args__4742__auto__.push((arguments[i__4737__auto___40180]));

var G__40181 = (i__4737__auto___40180 + (1));
i__4737__auto___40180 = G__40181;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e40178){var e = e40178;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq40177){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40177));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__40183 = arguments.length;
switch (G__40183) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40211){
var state_val_40212 = (state_40211[(1)]);
if((state_val_40212 === (7))){
var inst_40196 = (state_40211[(7)]);
var inst_40199 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40196,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_40211__$1 = state_40211;
var statearr_40213_40299 = state_40211__$1;
(statearr_40213_40299[(2)] = inst_40199);

(statearr_40213_40299[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (1))){
var state_40211__$1 = state_40211;
var statearr_40214_40300 = state_40211__$1;
(statearr_40214_40300[(2)] = null);

(statearr_40214_40300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (4))){
var inst_40184 = (state_40211[(2)]);
var state_40211__$1 = state_40211;
var statearr_40215_40301 = state_40211__$1;
(statearr_40215_40301[(2)] = inst_40184);

(statearr_40215_40301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (6))){
var inst_40196 = (state_40211[(7)]);
var inst_40196__$1 = (state_40211[(2)]);
var inst_40197 = fluree.db.util.core.exception_QMARK_(inst_40196__$1);
var state_40211__$1 = (function (){var statearr_40216 = state_40211;
(statearr_40216[(7)] = inst_40196__$1);

return statearr_40216;
})();
if(inst_40197){
var statearr_40217_40302 = state_40211__$1;
(statearr_40217_40302[(1)] = (7));

} else {
var statearr_40218_40303 = state_40211__$1;
(statearr_40218_40303[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (3))){
var inst_40209 = (state_40211[(2)]);
var state_40211__$1 = state_40211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40211__$1,inst_40209);
} else {
if((state_val_40212 === (2))){
var inst_40190 = (state_40211[(8)]);
var _ = (function (){var statearr_40220 = state_40211;
(statearr_40220[(4)] = cljs.core.cons((5),(state_40211[(4)])));

return statearr_40220;
})();
var inst_40190__$1 = cljs.core.volatile_BANG_((0));
var inst_40191 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_40192 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_40191,cljs.core.cst$kw$fuel,inst_40190__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_40193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_40192);
var inst_40194 = fluree.db.query.fql.query(db,inst_40193);
var state_40211__$1 = (function (){var statearr_40221 = state_40211;
(statearr_40221[(8)] = inst_40190__$1);

return statearr_40221;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40211__$1,(6),inst_40194);
} else {
if((state_val_40212 === (9))){
var inst_40206 = (state_40211[(2)]);
var _ = (function (){var statearr_40222 = state_40211;
(statearr_40222[(4)] = cljs.core.rest((state_40211[(4)])));

return statearr_40222;
})();
var state_40211__$1 = state_40211;
var statearr_40223_40304 = state_40211__$1;
(statearr_40223_40304[(2)] = inst_40206);

(statearr_40223_40304[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (5))){
var _ = (function (){var statearr_40224 = state_40211;
(statearr_40224[(4)] = cljs.core.rest((state_40211[(4)])));

return statearr_40224;
})();
var state_40211__$1 = state_40211;
var ex40219 = (state_40211__$1[(2)]);
var statearr_40225_40305 = state_40211__$1;
(statearr_40225_40305[(5)] = ex40219);


if((ex40219 instanceof Error)){
var statearr_40226_40306 = state_40211__$1;
(statearr_40226_40306[(1)] = (4));

(statearr_40226_40306[(5)] = null);

} else {
throw ex40219;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40212 === (8))){
var inst_40196 = (state_40211[(7)]);
var inst_40190 = (state_40211[(8)]);
var inst_40201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40202 = cljs.core.deref(inst_40190);
var inst_40203 = [inst_40196,inst_40202];
var inst_40204 = (new cljs.core.PersistentVector(null,2,(5),inst_40201,inst_40203,null));
var state_40211__$1 = state_40211;
var statearr_40227_40307 = state_40211__$1;
(statearr_40227_40307[(2)] = inst_40204);

(statearr_40227_40307[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_40228 = [null,null,null,null,null,null,null,null,null];
(statearr_40228[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_40228[(1)] = (1));

return statearr_40228;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_40211){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40211);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40229){var ex__16304__auto__ = e40229;
var statearr_40230_40308 = state_40211;
(statearr_40230_40308[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40211[(4)]))){
var statearr_40231_40309 = state_40211;
(statearr_40231_40309[(1)] = cljs.core.first((state_40211[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40310 = state_40211;
state_40211 = G__40310;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_40211){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_40211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40232 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40232[(6)] = c__16375__auto__);

return statearr_40232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40277){
var state_val_40278 = (state_40277[(1)]);
if((state_val_40278 === (7))){
var inst_40263 = (state_40277[(2)]);
var inst_40264 = fluree.db.query.fql.query(db,inst_40263);
var state_40277__$1 = state_40277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40277__$1,(8),inst_40264);
} else {
if((state_val_40278 === (1))){
var inst_40233 = typeof select === 'string';
var state_40277__$1 = state_40277;
if(cljs.core.truth_(inst_40233)){
var statearr_40279_40311 = state_40277__$1;
(statearr_40279_40311[(1)] = (2));

} else {
var statearr_40280_40312 = state_40277__$1;
(statearr_40280_40312[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (4))){
var inst_40239 = (state_40277[(7)]);
var inst_40246 = (state_40277[(8)]);
var inst_40238 = (state_40277[(2)]);
var inst_40239__$1 = cljs.core.volatile_BANG_((0));
var inst_40240 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_40241 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_40242 = [inst_40239__$1,(100000)];
var inst_40243 = cljs.core.PersistentHashMap.fromArrays(inst_40241,inst_40242);
var inst_40244 = [inst_40238,from,where,block,limit,inst_40243];
var inst_40245 = cljs.core.PersistentHashMap.fromArrays(inst_40240,inst_40244);
var inst_40246__$1 = fluree.db.util.core.without_nils(inst_40245);
var inst_40247 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40246__$1);
var inst_40248 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40246__$1);
var inst_40249 = cljs.core.first(inst_40248);
var inst_40250 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40249], 0));
var inst_40251 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_40250);
var inst_40252 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40246__$1);
var inst_40253 = cljs.core.last(inst_40252);
var inst_40254 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40253], 0));
var inst_40255 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_40254);
var inst_40256 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40247,inst_40251,inst_40255], 0));
var state_40277__$1 = (function (){var statearr_40281 = state_40277;
(statearr_40281[(7)] = inst_40239__$1);

(statearr_40281[(8)] = inst_40246__$1);

return statearr_40281;
})();
if(cljs.core.truth_(inst_40256)){
var statearr_40282_40313 = state_40277__$1;
(statearr_40282_40313[(1)] = (5));

} else {
var statearr_40283_40314 = state_40277__$1;
(statearr_40283_40314[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (6))){
var inst_40246 = (state_40277[(8)]);
var state_40277__$1 = state_40277;
var statearr_40284_40315 = state_40277__$1;
(statearr_40284_40315[(2)] = inst_40246);

(statearr_40284_40315[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (3))){
var state_40277__$1 = state_40277;
var statearr_40285_40316 = state_40277__$1;
(statearr_40285_40316[(2)] = select);

(statearr_40285_40316[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (2))){
var inst_40235 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_40277__$1 = state_40277;
var statearr_40286_40317 = state_40277__$1;
(statearr_40286_40317[(2)] = inst_40235);

(statearr_40286_40317[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (11))){
var inst_40275 = (state_40277[(2)]);
var state_40277__$1 = state_40277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40277__$1,inst_40275);
} else {
if((state_val_40278 === (9))){
var inst_40266 = (state_40277[(9)]);
var state_40277__$1 = state_40277;
var statearr_40287_40318 = state_40277__$1;
(statearr_40287_40318[(2)] = inst_40266);

(statearr_40287_40318[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (5))){
var inst_40246 = (state_40277[(8)]);
var inst_40258 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40246);
var inst_40259 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_40258);
var inst_40260 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40246,cljs.core.cst$kw$where,inst_40259);
var state_40277__$1 = state_40277;
var statearr_40288_40319 = state_40277__$1;
(statearr_40288_40319[(2)] = inst_40260);

(statearr_40288_40319[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (10))){
var inst_40266 = (state_40277[(9)]);
var inst_40239 = (state_40277[(7)]);
var inst_40270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40271 = cljs.core.deref(inst_40239);
var inst_40272 = [inst_40266,inst_40271];
var inst_40273 = (new cljs.core.PersistentVector(null,2,(5),inst_40270,inst_40272,null));
var state_40277__$1 = state_40277;
var statearr_40289_40320 = state_40277__$1;
(statearr_40289_40320[(2)] = inst_40273);

(statearr_40289_40320[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40278 === (8))){
var inst_40266 = (state_40277[(9)]);
var inst_40266__$1 = (state_40277[(2)]);
var inst_40267 = fluree.db.util.core.exception_QMARK_(inst_40266__$1);
var state_40277__$1 = (function (){var statearr_40290 = state_40277;
(statearr_40290[(9)] = inst_40266__$1);

return statearr_40290;
})();
if(inst_40267){
var statearr_40291_40321 = state_40277__$1;
(statearr_40291_40321[(1)] = (9));

} else {
var statearr_40292_40322 = state_40277__$1;
(statearr_40292_40322[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_40293 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40293[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_40293[(1)] = (1));

return statearr_40293;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_40277){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40277);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40294){var ex__16304__auto__ = e40294;
var statearr_40295_40323 = state_40277;
(statearr_40295_40323[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40277[(4)]))){
var statearr_40296_40324 = state_40277;
(statearr_40296_40324[(1)] = cljs.core.first((state_40277[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40325 = state_40277;
state_40277 = G__40325;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_40277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_40277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40297 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40297[(6)] = c__16375__auto__);

return statearr_40297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__40329 = path;
var vec__40330 = G__40329;
var seq__40331 = cljs.core.seq(vec__40330);
var first__40332 = cljs.core.first(seq__40331);
var seq__40331__$1 = cljs.core.next(seq__40331);
var var$ = first__40332;
var r = seq__40331__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__40329__$1 = G__40329;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__40336 = G__40329__$1;
var seq__40337 = cljs.core.seq(vec__40336);
var first__40338 = cljs.core.first(seq__40337);
var seq__40337__$1 = cljs.core.next(seq__40337);
var var$__$1 = first__40338;
var r__$1 = seq__40337__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__40339 = r__$1;
var G__40340 = n__$2;
var G__40341 = next_clauses;
G__40329__$1 = G__40339;
n__$1 = G__40340;
where_clauses__$1 = G__40341;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__40342 = r__$1;
var G__40343 = next_n;
var G__40344 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__40329__$1 = G__40342;
n__$1 = G__40343;
where_clauses__$1 = G__40344;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40381){
var state_val_40382 = (state_40381[(1)]);
if((state_val_40382 === (7))){
var inst_40354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40355 = [path];
var inst_40356 = (new cljs.core.PersistentVector(null,1,(5),inst_40354,inst_40355,null));
var state_40381__$1 = state_40381;
var statearr_40383_40411 = state_40381__$1;
(statearr_40383_40411[(2)] = inst_40356);

(statearr_40383_40411[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (1))){
var state_40381__$1 = state_40381;
var statearr_40384_40412 = state_40381__$1;
(statearr_40384_40412[(2)] = null);

(statearr_40384_40412[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (4))){
var inst_40345 = (state_40381[(2)]);
var state_40381__$1 = state_40381;
var statearr_40385_40413 = state_40381__$1;
(statearr_40385_40413[(2)] = inst_40345);

(statearr_40385_40413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (13))){
var inst_40372 = (state_40381[(2)]);
var inst_40373 = fluree.db.util.async.throw_err(inst_40372);
var _ = (function (){var statearr_40386 = state_40381;
(statearr_40386[(4)] = cljs.core.rest((state_40381[(4)])));

return statearr_40386;
})();
var state_40381__$1 = state_40381;
var statearr_40387_40414 = state_40381__$1;
(statearr_40387_40414[(2)] = inst_40373);

(statearr_40387_40414[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (6))){
var state_40381__$1 = state_40381;
var statearr_40389_40415 = state_40381__$1;
(statearr_40389_40415[(2)] = path);

(statearr_40389_40415[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (3))){
var inst_40379 = (state_40381[(2)]);
var state_40381__$1 = state_40381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40381__$1,inst_40379);
} else {
if((state_val_40382 === (12))){
var _ = (function (){var statearr_40390 = state_40381;
(statearr_40390[(4)] = cljs.core.rest((state_40381[(4)])));

return statearr_40390;
})();
var state_40381__$1 = state_40381;
var ex40388 = (state_40381__$1[(2)]);
var statearr_40391_40416 = state_40381__$1;
(statearr_40391_40416[(5)] = ex40388);


var statearr_40392_40417 = state_40381__$1;
(statearr_40392_40417[(1)] = (11));

(statearr_40392_40417[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (2))){
var _ = (function (){var statearr_40393 = state_40381;
(statearr_40393[(4)] = cljs.core.cons((5),(state_40381[(4)])));

return statearr_40393;
})();
var inst_40351 = cljs.core.vector_QMARK_(path);
var state_40381__$1 = state_40381;
if(inst_40351){
var statearr_40394_40418 = state_40381__$1;
(statearr_40394_40418[(1)] = (6));

} else {
var statearr_40395_40419 = state_40381__$1;
(statearr_40395_40419[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (11))){
var inst_40358 = (state_40381[(7)]);
var inst_40363 = (state_40381[(2)]);
var inst_40364 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40363,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_40358,endSubject], 0));
var state_40381__$1 = state_40381;
var statearr_40397_40420 = state_40381__$1;
(statearr_40397_40420[(2)] = inst_40364);

(statearr_40397_40420[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (9))){
var inst_40362 = (state_40381[(8)]);
var _ = (function (){var statearr_40398 = state_40381;
(statearr_40398[(4)] = cljs.core.cons((12),(state_40381[(4)])));

return statearr_40398;
})();
var inst_40370 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_40362);
var state_40381__$1 = state_40381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40381__$1,(13),inst_40370);
} else {
if((state_val_40382 === (5))){
var _ = (function (){var statearr_40399 = state_40381;
(statearr_40399[(4)] = cljs.core.rest((state_40381[(4)])));

return statearr_40399;
})();
var state_40381__$1 = state_40381;
var ex40396 = (state_40381__$1[(2)]);
var statearr_40400_40421 = state_40381__$1;
(statearr_40400_40421[(5)] = ex40396);


if((ex40396 instanceof Error)){
var statearr_40401_40422 = state_40381__$1;
(statearr_40401_40422[(1)] = (4));

(statearr_40401_40422[(5)] = null);

} else {
throw ex40396;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (10))){
var inst_40376 = (state_40381[(2)]);
var _ = (function (){var statearr_40402 = state_40381;
(statearr_40402[(4)] = cljs.core.rest((state_40381[(4)])));

return statearr_40402;
})();
var state_40381__$1 = state_40381;
var statearr_40403_40423 = state_40381__$1;
(statearr_40403_40423[(2)] = inst_40376);

(statearr_40403_40423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40382 === (8))){
var inst_40358 = (state_40381[(7)]);
var inst_40358__$1 = (state_40381[(2)]);
var inst_40359 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_40358__$1,endSubject);
var inst_40360 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_40361 = ["?var1",inst_40359];
var inst_40362 = cljs.core.PersistentHashMap.fromArrays(inst_40360,inst_40361);
var state_40381__$1 = (function (){var statearr_40404 = state_40381;
(statearr_40404[(7)] = inst_40358__$1);

(statearr_40404[(8)] = inst_40362);

return statearr_40404;
})();
var statearr_40405_40424 = state_40381__$1;
(statearr_40405_40424[(2)] = null);

(statearr_40405_40424[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_40406 = [null,null,null,null,null,null,null,null,null];
(statearr_40406[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__);

(statearr_40406[(1)] = (1));

return statearr_40406;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1 = (function (state_40381){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40381);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40407){var ex__16304__auto__ = e40407;
var statearr_40408_40425 = state_40381;
(statearr_40408_40425[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40381[(4)]))){
var statearr_40409_40426 = state_40381;
(statearr_40409_40426[(1)] = cljs.core.first((state_40381[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40427 = state_40381;
state_40381 = G__40427;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = function(state_40381){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1.call(this,state_40381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40410 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40410[(6)] = c__16375__auto__);

return statearr_40410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e40428){var e = e40428;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e40429){var e = e40429;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e40430){var e = e40430;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e40431){var e = e40431;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40434 = arguments.length;
var i__4737__auto___40435 = (0);
while(true){
if((i__4737__auto___40435 < len__4736__auto___40434)){
args__4742__auto__.push((arguments[i__4737__auto___40435]));

var G__40436 = (i__4737__auto___40435 + (1));
i__4737__auto___40435 = G__40436;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e40433){var e = e40433;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq40432){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40432));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40439 = arguments.length;
var i__4737__auto___40440 = (0);
while(true){
if((i__4737__auto___40440 < len__4736__auto___40439)){
args__4742__auto__.push((arguments[i__4737__auto___40440]));

var G__40441 = (i__4737__auto___40440 + (1));
i__4737__auto___40440 = G__40441;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e40438){var e = e40438;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq40437){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40437));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40444 = arguments.length;
var i__4737__auto___40445 = (0);
while(true){
if((i__4737__auto___40445 < len__4736__auto___40444)){
args__4742__auto__.push((arguments[i__4737__auto___40445]));

var G__40446 = (i__4737__auto___40445 + (1));
i__4737__auto___40445 = G__40446;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e40443){var e = e40443;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq40442){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40442));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40449 = arguments.length;
var i__4737__auto___40450 = (0);
while(true){
if((i__4737__auto___40450 < len__4736__auto___40449)){
args__4742__auto__.push((arguments[i__4737__auto___40450]));

var G__40451 = (i__4737__auto___40450 + (1));
i__4737__auto___40450 = G__40451;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e40448){var e = e40448;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq40447){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40447));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e40452){var e = e40452;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e40453){var e = e40453;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e40454){var e = e40454;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e40455){var e = e40455;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e40456){var e = e40456;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__40462 = path;
var vec__40463 = G__40462;
var seq__40464 = cljs.core.seq(vec__40463);
var first__40465 = cljs.core.first(seq__40464);
var seq__40464__$1 = cljs.core.next(seq__40464);
var pred = first__40465;
var r = seq__40464__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__40462__$1 = G__40462;
var subjects__$1 = subjects;
while(true){
var vec__40469 = G__40462__$1;
var seq__40470 = cljs.core.seq(vec__40469);
var first__40471 = cljs.core.first(seq__40470);
var seq__40470__$1 = cljs.core.next(seq__40470);
var pred__$1 = first__40471;
var r__$1 = seq__40470__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__40462__$1,subjects__$1,vec__40469,seq__40470,first__40471,seq__40470__$1,pred__$1,r__$1,subjects__$2,G__40462,vec__40463,seq__40464,first__40465,seq__40464__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__40462__$1,subjects__$1,vec__40469,seq__40470,first__40471,seq__40470__$1,pred__$1,r__$1,subjects__$2,G__40462,vec__40463,seq__40464,first__40465,seq__40464__$1,pred,r,subjects){
return (function (p1__40457_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__40457_SHARP_,pred__$1);
});})(G__40462__$1,subjects__$1,vec__40469,seq__40470,first__40471,seq__40470__$1,pred__$1,r__$1,subjects__$2,G__40462,vec__40463,seq__40464,first__40465,seq__40464__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__40462__$1,subjects__$1,vec__40469,seq__40470,first__40471,seq__40470__$1,pred__$1,r__$1,subjects__$2,G__40462,vec__40463,seq__40464,first__40465,seq__40464__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__40472 = r__$1;
var G__40473 = next_subjects;
G__40462__$1 = G__40472;
subjects__$1 = G__40473;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e40458){var e = e40458;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e40474){var e = e40474;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e40475){var e = e40475;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40478 = arguments.length;
var i__4737__auto___40479 = (0);
while(true){
if((i__4737__auto___40479 < len__4736__auto___40478)){
args__4742__auto__.push((arguments[i__4737__auto___40479]));

var G__40480 = (i__4737__auto___40479 + (1));
i__4737__auto___40479 = G__40480;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e40477){var e = e40477;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq40476){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40476));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e40481){var e = e40481;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___40484 = arguments.length;
var i__4737__auto___40485 = (0);
while(true){
if((i__4737__auto___40485 < len__4736__auto___40484)){
args__4742__auto__.push((arguments[i__4737__auto___40485]));

var G__40486 = (i__4737__auto___40485 + (1));
i__4737__auto___40485 = G__40486;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e40483){var e = e40483;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq40482){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40482));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e40487){var e = e40487;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40542){
var state_val_40543 = (state_40542[(1)]);
if((state_val_40543 === (7))){
var inst_40489 = (state_40542[(2)]);
var state_40542__$1 = state_40542;
var statearr_40544_40577 = state_40542__$1;
(statearr_40544_40577[(2)] = inst_40489);

(statearr_40544_40577[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (1))){
var state_40542__$1 = state_40542;
var statearr_40545_40578 = state_40542__$1;
(statearr_40545_40578[(2)] = null);

(statearr_40545_40578[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (4))){
var inst_40488 = (state_40542[(2)]);
var state_40542__$1 = (function (){var statearr_40546 = state_40542;
(statearr_40546[(7)] = inst_40488);

return statearr_40546;
})();
var statearr_40547_40579 = state_40542__$1;
(statearr_40547_40579[(2)] = null);

(statearr_40547_40579[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (15))){
var inst_40526 = (state_40542[(8)]);
var inst_40530 = inst_40526.o;
var state_40542__$1 = state_40542;
var statearr_40548_40580 = state_40542__$1;
(statearr_40548_40580[(2)] = inst_40530);

(statearr_40548_40580[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (13))){
var inst_40526 = (state_40542[(8)]);
var inst_40522 = (state_40542[(2)]);
var inst_40523 = fluree.db.util.async.throw_err(inst_40522);
var inst_40524 = fluree.db.dbfunctions.internal.count(inst_40523);
var inst_40526__$1 = cljs.core.first(inst_40523);
var inst_40527 = (inst_40526__$1 == null);
var state_40542__$1 = (function (){var statearr_40549 = state_40542;
(statearr_40549[(9)] = inst_40524);

(statearr_40549[(8)] = inst_40526__$1);

return statearr_40549;
})();
if(cljs.core.truth_(inst_40527)){
var statearr_40550_40581 = state_40542__$1;
(statearr_40550_40581[(1)] = (14));

} else {
var statearr_40551_40582 = state_40542__$1;
(statearr_40551_40582[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (6))){
var inst_40498 = (state_40542[(2)]);
var state_40542__$1 = state_40542;
var statearr_40552_40583 = state_40542__$1;
(statearr_40552_40583[(2)] = inst_40498);

(statearr_40552_40583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (3))){
var inst_40540 = (state_40542[(2)]);
var state_40542__$1 = state_40542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40542__$1,inst_40540);
} else {
if((state_val_40543 === (12))){
var inst_40537 = (state_40542[(2)]);
var _ = (function (){var statearr_40553 = state_40542;
(statearr_40553[(4)] = cljs.core.rest((state_40542[(4)])));

return statearr_40553;
})();
var state_40542__$1 = state_40542;
var statearr_40554_40584 = state_40542__$1;
(statearr_40554_40584[(2)] = inst_40537);

(statearr_40554_40584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (2))){
var _ = (function (){var statearr_40556 = state_40542;
(statearr_40556[(4)] = cljs.core.cons((9),(state_40542[(4)])));

return statearr_40556;
})();
var inst_40504 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40505 = typeof inst_40504 === 'string';
var state_40542__$1 = state_40542;
if(cljs.core.truth_(inst_40505)){
var statearr_40557_40585 = state_40542__$1;
(statearr_40557_40585[(1)] = (10));

} else {
var statearr_40558_40586 = state_40542__$1;
(statearr_40558_40586[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (11))){
var inst_40511 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40512 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_40511);
var inst_40513 = fluree.db.dbfunctions.internal.inc(inst_40512);
var inst_40514 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40511,cljs.core.cst$kw$t,inst_40513);
var inst_40515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40516 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40517 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40518 = [inst_40516,inst_40517];
var inst_40519 = (new cljs.core.PersistentVector(null,2,(5),inst_40515,inst_40518,null));
var inst_40520 = fluree.db.dbproto._search(inst_40514,inst_40519);
var state_40542__$1 = state_40542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40542__$1,(13),inst_40520);
} else {
if((state_val_40543 === (9))){
var _ = (function (){var statearr_40559 = state_40542;
(statearr_40559[(4)] = cljs.core.rest((state_40542[(4)])));

return statearr_40559;
})();
var state_40542__$1 = state_40542;
var ex40555 = (state_40542__$1[(2)]);
var statearr_40560_40587 = state_40542__$1;
(statearr_40560_40587[(5)] = ex40555);


var statearr_40561_40588 = state_40542__$1;
(statearr_40561_40588[(1)] = (4));

(statearr_40561_40588[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (5))){
var inst_40488 = (state_40542[(7)]);
var _ = (function (){var statearr_40562 = state_40542;
(statearr_40562[(4)] = cljs.core.cons((8),(state_40542[(4)])));

return statearr_40562;
})();
var inst_40495 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40488,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_40563 = state_40542;
(statearr_40563[(4)] = cljs.core.rest((state_40542[(4)])));

return statearr_40563;
})();
var state_40542__$1 = state_40542;
var statearr_40564_40589 = state_40542__$1;
(statearr_40564_40589[(2)] = inst_40495);

(statearr_40564_40589[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (14))){
var state_40542__$1 = state_40542;
var statearr_40565_40590 = state_40542__$1;
(statearr_40565_40590[(2)] = null);

(statearr_40565_40590[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (16))){
var inst_40524 = (state_40542[(9)]);
var inst_40532 = (state_40542[(2)]);
var inst_40533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40534 = [inst_40532,inst_40524];
var inst_40535 = (new cljs.core.PersistentVector(null,2,(5),inst_40533,inst_40534,null));
var state_40542__$1 = state_40542;
var statearr_40567_40591 = state_40542__$1;
(statearr_40567_40591[(2)] = inst_40535);

(statearr_40567_40591[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (10))){
var inst_40507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40508 = [null,(0)];
var inst_40509 = (new cljs.core.PersistentVector(null,2,(5),inst_40507,inst_40508,null));
var state_40542__$1 = state_40542;
var statearr_40568_40592 = state_40542__$1;
(statearr_40568_40592[(2)] = inst_40509);

(statearr_40568_40592[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40543 === (8))){
var _ = (function (){var statearr_40569 = state_40542;
(statearr_40569[(4)] = cljs.core.rest((state_40542[(4)])));

return statearr_40569;
})();
var state_40542__$1 = state_40542;
var ex40566 = (state_40542__$1[(2)]);
var statearr_40570_40593 = state_40542__$1;
(statearr_40570_40593[(5)] = ex40566);


var statearr_40571_40594 = state_40542__$1;
(statearr_40571_40594[(1)] = (7));

(statearr_40571_40594[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0 = (function (){
var statearr_40572 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40572[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__);

(statearr_40572[(1)] = (1));

return statearr_40572;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1 = (function (state_40542){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40542);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40573){var ex__16304__auto__ = e40573;
var statearr_40574_40595 = state_40542;
(statearr_40574_40595[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40542[(4)]))){
var statearr_40575_40596 = state_40542;
(statearr_40575_40596[(1)] = cljs.core.first((state_40542[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40597 = state_40542;
state_40542 = G__40597;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = function(state_40542){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1.call(this,state_40542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40576 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40576[(6)] = c__16375__auto__);

return statearr_40576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40649){
var state_val_40650 = (state_40649[(1)]);
if((state_val_40650 === (7))){
var inst_40599 = (state_40649[(2)]);
var state_40649__$1 = state_40649;
var statearr_40651_40680 = state_40649__$1;
(statearr_40651_40680[(2)] = inst_40599);

(statearr_40651_40680[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (1))){
var state_40649__$1 = state_40649;
var statearr_40652_40681 = state_40649__$1;
(statearr_40652_40681[(2)] = null);

(statearr_40652_40681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (4))){
var inst_40598 = (state_40649[(2)]);
var state_40649__$1 = (function (){var statearr_40653 = state_40649;
(statearr_40653[(7)] = inst_40598);

return statearr_40653;
})();
var statearr_40654_40682 = state_40649__$1;
(statearr_40654_40682[(2)] = null);

(statearr_40654_40682[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (13))){
var inst_40644 = (state_40649[(2)]);
var _ = (function (){var statearr_40655 = state_40649;
(statearr_40655[(4)] = cljs.core.rest((state_40649[(4)])));

return statearr_40655;
})();
var state_40649__$1 = state_40649;
var statearr_40656_40683 = state_40649__$1;
(statearr_40656_40683[(2)] = inst_40644);

(statearr_40656_40683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (6))){
var inst_40608 = (state_40649[(2)]);
var state_40649__$1 = state_40649;
var statearr_40657_40684 = state_40649__$1;
(statearr_40657_40684[(2)] = inst_40608);

(statearr_40657_40684[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (3))){
var inst_40647 = (state_40649[(2)]);
var state_40649__$1 = state_40649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40649__$1,inst_40647);
} else {
if((state_val_40650 === (12))){
var inst_40631 = (state_40649[(8)]);
var inst_40640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40641 = [null,inst_40631];
var inst_40642 = (new cljs.core.PersistentVector(null,2,(5),inst_40640,inst_40641,null));
var state_40649__$1 = state_40649;
var statearr_40658_40685 = state_40649__$1;
(statearr_40658_40685[(2)] = inst_40642);

(statearr_40658_40685[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (2))){
var _ = (function (){var statearr_40660 = state_40649;
(statearr_40660[(4)] = cljs.core.cons((9),(state_40649[(4)])));

return statearr_40660;
})();
var inst_40617 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_40618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40620 = [null,pred_name,"?o"];
var inst_40621 = (new cljs.core.PersistentVector(null,3,(5),inst_40619,inst_40620,null));
var inst_40622 = [inst_40621];
var inst_40623 = (new cljs.core.PersistentVector(null,1,(5),inst_40618,inst_40622,null));
var inst_40624 = ["?o",inst_40623,opts];
var inst_40625 = cljs.core.PersistentHashMap.fromArrays(inst_40617,inst_40624);
var inst_40626 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_40625);
var state_40649__$1 = state_40649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40649__$1,(10),inst_40626);
} else {
if((state_val_40650 === (11))){
var inst_40631 = (state_40649[(8)]);
var inst_40630 = (state_40649[(9)]);
var inst_40635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40636 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_40630);
var inst_40637 = [inst_40636,inst_40631];
var inst_40638 = (new cljs.core.PersistentVector(null,2,(5),inst_40635,inst_40637,null));
var state_40649__$1 = state_40649;
var statearr_40661_40686 = state_40649__$1;
(statearr_40661_40686[(2)] = inst_40638);

(statearr_40661_40686[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (9))){
var _ = (function (){var statearr_40662 = state_40649;
(statearr_40662[(4)] = cljs.core.rest((state_40649[(4)])));

return statearr_40662;
})();
var state_40649__$1 = state_40649;
var ex40659 = (state_40649__$1[(2)]);
var statearr_40663_40687 = state_40649__$1;
(statearr_40663_40687[(5)] = ex40659);


var statearr_40664_40688 = state_40649__$1;
(statearr_40664_40688[(1)] = (4));

(statearr_40664_40688[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (5))){
var inst_40598 = (state_40649[(7)]);
var _ = (function (){var statearr_40666 = state_40649;
(statearr_40666[(4)] = cljs.core.cons((8),(state_40649[(4)])));

return statearr_40666;
})();
var inst_40605 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40598,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_40667 = state_40649;
(statearr_40667[(4)] = cljs.core.rest((state_40649[(4)])));

return statearr_40667;
})();
var state_40649__$1 = state_40649;
var statearr_40668_40689 = state_40649__$1;
(statearr_40668_40689[(2)] = inst_40605);

(statearr_40668_40689[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (10))){
var inst_40630 = (state_40649[(9)]);
var inst_40628 = (state_40649[(2)]);
var inst_40629 = fluree.db.util.async.throw_err(inst_40628);
var inst_40630__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40629,(0),null);
var inst_40631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40629,(1),null);
var inst_40632 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_40630__$1);
var inst_40633 = cljs.core.not(inst_40632);
var state_40649__$1 = (function (){var statearr_40669 = state_40649;
(statearr_40669[(8)] = inst_40631);

(statearr_40669[(9)] = inst_40630__$1);

return statearr_40669;
})();
if(inst_40633){
var statearr_40670_40690 = state_40649__$1;
(statearr_40670_40690[(1)] = (11));

} else {
var statearr_40671_40691 = state_40649__$1;
(statearr_40671_40691[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (8))){
var _ = (function (){var statearr_40672 = state_40649;
(statearr_40672[(4)] = cljs.core.rest((state_40649[(4)])));

return statearr_40672;
})();
var state_40649__$1 = state_40649;
var ex40665 = (state_40649__$1[(2)]);
var statearr_40673_40692 = state_40649__$1;
(statearr_40673_40692[(5)] = ex40665);


var statearr_40674_40693 = state_40649__$1;
(statearr_40674_40693[(1)] = (7));

(statearr_40674_40693[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0 = (function (){
var statearr_40675 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40675[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__);

(statearr_40675[(1)] = (1));

return statearr_40675;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1 = (function (state_40649){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40649);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40676){var ex__16304__auto__ = e40676;
var statearr_40677_40694 = state_40649;
(statearr_40677_40694[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40649[(4)]))){
var statearr_40678_40695 = state_40649;
(statearr_40678_40695[(1)] = cljs.core.first((state_40649[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40696 = state_40649;
state_40649 = G__40696;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = function(state_40649){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1.call(this,state_40649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40679 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40679[(6)] = c__16375__auto__);

return statearr_40679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e40697){var e = e40697;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__40699 = arguments.length;
switch (G__40699) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40769){
var state_val_40770 = (state_40769[(1)]);
if((state_val_40770 === (7))){
var inst_40701 = (state_40769[(2)]);
var state_40769__$1 = state_40769;
var statearr_40771_40815 = state_40769__$1;
(statearr_40771_40815[(2)] = inst_40701);

(statearr_40771_40815[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (20))){
var inst_40745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40746 = ["*"];
var inst_40747 = (new cljs.core.PersistentVector(null,1,(5),inst_40745,inst_40746,null));
var state_40769__$1 = state_40769;
var statearr_40772_40816 = state_40769__$1;
(statearr_40772_40816[(2)] = inst_40747);

(statearr_40772_40816[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (1))){
var state_40769__$1 = state_40769;
var statearr_40773_40817 = state_40769__$1;
(statearr_40773_40817[(2)] = null);

(statearr_40773_40817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (4))){
var inst_40700 = (state_40769[(2)]);
var state_40769__$1 = (function (){var statearr_40774 = state_40769;
(statearr_40774[(7)] = inst_40700);

return statearr_40774;
})();
var statearr_40775_40818 = state_40769__$1;
(statearr_40775_40818[(2)] = null);

(statearr_40775_40818[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (15))){
var inst_40764 = (state_40769[(2)]);
var _ = (function (){var statearr_40776 = state_40769;
(statearr_40776[(4)] = cljs.core.rest((state_40769[(4)])));

return statearr_40776;
})();
var state_40769__$1 = state_40769;
var statearr_40777_40819 = state_40769__$1;
(statearr_40777_40819[(2)] = inst_40764);

(statearr_40777_40819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (21))){
var inst_40735 = (state_40769[(8)]);
var inst_40728 = (state_40769[(9)]);
var inst_40749 = (state_40769[(2)]);
var inst_40750 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40751 = cljs.core.PersistentHashMap.EMPTY;
var inst_40752 = [inst_40749,inst_40735,inst_40751];
var inst_40753 = cljs.core.PersistentHashMap.fromArrays(inst_40750,inst_40752);
var inst_40754 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40728,inst_40753);
var state_40769__$1 = state_40769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40769__$1,(22),inst_40754);
} else {
if((state_val_40770 === (13))){
var inst_40723 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40769__$1 = state_40769;
var statearr_40778_40820 = state_40769__$1;
(statearr_40778_40820[(2)] = inst_40723);

(statearr_40778_40820[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (22))){
var inst_40756 = (state_40769[(2)]);
var inst_40757 = fluree.db.util.async.throw_err(inst_40756);
var inst_40758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40757,(0),null);
var inst_40759 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40757,(1),null);
var inst_40760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40761 = [inst_40758,inst_40759];
var inst_40762 = (new cljs.core.PersistentVector(null,2,(5),inst_40760,inst_40761,null));
var state_40769__$1 = state_40769;
var statearr_40779_40821 = state_40769__$1;
(statearr_40779_40821[(2)] = inst_40762);

(statearr_40779_40821[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (6))){
var inst_40710 = (state_40769[(2)]);
var state_40769__$1 = state_40769;
var statearr_40780_40822 = state_40769__$1;
(statearr_40780_40822[(2)] = inst_40710);

(statearr_40780_40822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (17))){
var inst_40732 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40733 = fluree.db.dbfunctions.internal.get(inst_40732,cljs.core.cst$kw$_id);
var state_40769__$1 = state_40769;
var statearr_40781_40823 = state_40769__$1;
(statearr_40781_40823[(2)] = inst_40733);

(statearr_40781_40823[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (3))){
var inst_40767 = (state_40769[(2)]);
var state_40769__$1 = state_40769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40769__$1,inst_40767);
} else {
if((state_val_40770 === (12))){
var inst_40721 = (state_40769[(2)]);
var state_40769__$1 = state_40769;
if(cljs.core.truth_(inst_40721)){
var statearr_40782_40824 = state_40769__$1;
(statearr_40782_40824[(1)] = (13));

} else {
var statearr_40783_40825 = state_40769__$1;
(statearr_40783_40825[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (2))){
var inst_40716 = (state_40769[(10)]);
var _ = (function (){var statearr_40784 = state_40769;
(statearr_40784[(4)] = cljs.core.cons((9),(state_40769[(4)])));

return statearr_40784;
})();
var inst_40716__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40769__$1 = (function (){var statearr_40785 = state_40769;
(statearr_40785[(10)] = inst_40716__$1);

return statearr_40785;
})();
if(cljs.core.truth_(inst_40716__$1)){
var statearr_40786_40826 = state_40769__$1;
(statearr_40786_40826[(1)] = (10));

} else {
var statearr_40787_40827 = state_40769__$1;
(statearr_40787_40827[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (19))){
var inst_40737 = cljs.core.PersistentVector.EMPTY;
var inst_40738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40739 = ["*"];
var inst_40740 = (new cljs.core.PersistentVector(null,1,(5),inst_40738,inst_40739,null));
var inst_40741 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_40742 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_40740,inst_40741);
var inst_40743 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40737,inst_40742);
var state_40769__$1 = state_40769;
var statearr_40789_40828 = state_40769__$1;
(statearr_40789_40828[(2)] = inst_40743);

(statearr_40789_40828[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (11))){
var inst_40716 = (state_40769[(10)]);
var state_40769__$1 = state_40769;
var statearr_40790_40829 = state_40769__$1;
(statearr_40790_40829[(2)] = inst_40716);

(statearr_40790_40829[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (9))){
var _ = (function (){var statearr_40791 = state_40769;
(statearr_40791[(4)] = cljs.core.rest((state_40769[(4)])));

return statearr_40791;
})();
var state_40769__$1 = state_40769;
var ex40788 = (state_40769__$1[(2)]);
var statearr_40792_40830 = state_40769__$1;
(statearr_40792_40830[(5)] = ex40788);


var statearr_40793_40831 = state_40769__$1;
(statearr_40793_40831[(1)] = (4));

(statearr_40793_40831[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (5))){
var inst_40700 = (state_40769[(7)]);
var _ = (function (){var statearr_40794 = state_40769;
(statearr_40794[(4)] = cljs.core.cons((8),(state_40769[(4)])));

return statearr_40794;
})();
var inst_40707 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40700,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_40795 = state_40769;
(statearr_40795[(4)] = cljs.core.rest((state_40769[(4)])));

return statearr_40795;
})();
var state_40769__$1 = state_40769;
var statearr_40796_40832 = state_40769__$1;
(statearr_40796_40832[(2)] = inst_40707);

(statearr_40796_40832[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (14))){
var inst_40729 = (state_40769[(11)]);
var inst_40728 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40729__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40769__$1 = (function (){var statearr_40797 = state_40769;
(statearr_40797[(9)] = inst_40728);

(statearr_40797[(11)] = inst_40729__$1);

return statearr_40797;
})();
if(cljs.core.truth_(inst_40729__$1)){
var statearr_40798_40833 = state_40769__$1;
(statearr_40798_40833[(1)] = (16));

} else {
var statearr_40799_40834 = state_40769__$1;
(statearr_40799_40834[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (16))){
var inst_40729 = (state_40769[(11)]);
var state_40769__$1 = state_40769;
var statearr_40800_40835 = state_40769__$1;
(statearr_40800_40835[(2)] = inst_40729);

(statearr_40800_40835[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (10))){
var inst_40718 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_40769__$1 = state_40769;
var statearr_40802_40836 = state_40769__$1;
(statearr_40802_40836[(2)] = inst_40718);

(statearr_40802_40836[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (18))){
var inst_40735 = (state_40769[(2)]);
var state_40769__$1 = (function (){var statearr_40803 = state_40769;
(statearr_40803[(8)] = inst_40735);

return statearr_40803;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40804_40837 = state_40769__$1;
(statearr_40804_40837[(1)] = (19));

} else {
var statearr_40805_40838 = state_40769__$1;
(statearr_40805_40838[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40770 === (8))){
var _ = (function (){var statearr_40806 = state_40769;
(statearr_40806[(4)] = cljs.core.rest((state_40769[(4)])));

return statearr_40806;
})();
var state_40769__$1 = state_40769;
var ex40801 = (state_40769__$1[(2)]);
var statearr_40807_40839 = state_40769__$1;
(statearr_40807_40839[(5)] = ex40801);


var statearr_40808_40840 = state_40769__$1;
(statearr_40808_40840[(1)] = (7));

(statearr_40808_40840[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_40809 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40809[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_40809[(1)] = (1));

return statearr_40809;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_40769){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40769);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40810){var ex__16304__auto__ = e40810;
var statearr_40811_40841 = state_40769;
(statearr_40811_40841[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40769[(4)]))){
var statearr_40812_40842 = state_40769;
(statearr_40812_40842[(1)] = cljs.core.first((state_40769[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40843 = state_40769;
state_40769 = G__40843;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_40769){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_40769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40813 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40813[(6)] = c__16375__auto__);

return statearr_40813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__40845 = arguments.length;
switch (G__40845) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40889){
var state_val_40890 = (state_40889[(1)]);
if((state_val_40890 === (7))){
var inst_40867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40868 = ["*"];
var inst_40869 = (new cljs.core.PersistentVector(null,1,(5),inst_40867,inst_40868,null));
var state_40889__$1 = state_40889;
var statearr_40891_40911 = state_40889__$1;
(statearr_40891_40911[(2)] = inst_40869);

(statearr_40891_40911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (1))){
var state_40889__$1 = state_40889;
var statearr_40892_40912 = state_40889__$1;
(statearr_40892_40912[(2)] = null);

(statearr_40892_40912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (4))){
var inst_40846 = (state_40889[(2)]);
var inst_40847 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40846,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_40889__$1 = state_40889;
var statearr_40893_40913 = state_40889__$1;
(statearr_40893_40913[(2)] = inst_40847);

(statearr_40893_40913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (6))){
var inst_40859 = cljs.core.PersistentVector.EMPTY;
var inst_40860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40861 = ["*"];
var inst_40862 = (new cljs.core.PersistentVector(null,1,(5),inst_40860,inst_40861,null));
var inst_40863 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_40864 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_40862,inst_40863);
var inst_40865 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40859,inst_40864);
var state_40889__$1 = state_40889;
var statearr_40894_40914 = state_40889__$1;
(statearr_40894_40914[(2)] = inst_40865);

(statearr_40894_40914[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (3))){
var inst_40887 = (state_40889[(2)]);
var state_40889__$1 = state_40889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40889__$1,inst_40887);
} else {
if((state_val_40890 === (2))){
var _ = (function (){var statearr_40896 = state_40889;
(statearr_40896[(4)] = cljs.core.cons((5),(state_40889[(4)])));

return statearr_40896;
})();
var inst_40856 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40857 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40889__$1 = (function (){var statearr_40897 = state_40889;
(statearr_40897[(7)] = inst_40857);

(statearr_40897[(8)] = inst_40856);

return statearr_40897;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40898_40915 = state_40889__$1;
(statearr_40898_40915[(1)] = (6));

} else {
var statearr_40899_40916 = state_40889__$1;
(statearr_40899_40916[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (9))){
var inst_40878 = (state_40889[(2)]);
var inst_40879 = fluree.db.util.async.throw_err(inst_40878);
var inst_40880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40879,(0),null);
var inst_40881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40879,(1),null);
var inst_40882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40883 = [inst_40880,inst_40881];
var inst_40884 = (new cljs.core.PersistentVector(null,2,(5),inst_40882,inst_40883,null));
var _ = (function (){var statearr_40900 = state_40889;
(statearr_40900[(4)] = cljs.core.rest((state_40889[(4)])));

return statearr_40900;
})();
var state_40889__$1 = state_40889;
var statearr_40901_40917 = state_40889__$1;
(statearr_40901_40917[(2)] = inst_40884);

(statearr_40901_40917[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (5))){
var _ = (function (){var statearr_40902 = state_40889;
(statearr_40902[(4)] = cljs.core.rest((state_40889[(4)])));

return statearr_40902;
})();
var state_40889__$1 = state_40889;
var ex40895 = (state_40889__$1[(2)]);
var statearr_40903_40918 = state_40889__$1;
(statearr_40903_40918[(5)] = ex40895);


var statearr_40904_40919 = state_40889__$1;
(statearr_40904_40919[(1)] = (4));

(statearr_40904_40919[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40890 === (8))){
var inst_40857 = (state_40889[(7)]);
var inst_40856 = (state_40889[(8)]);
var inst_40871 = (state_40889[(2)]);
var inst_40872 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40873 = cljs.core.PersistentHashMap.EMPTY;
var inst_40874 = [inst_40871,inst_40857,inst_40873];
var inst_40875 = cljs.core.PersistentHashMap.fromArrays(inst_40872,inst_40874);
var inst_40876 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40856,inst_40875);
var state_40889__$1 = state_40889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40889__$1,(9),inst_40876);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_40905 = [null,null,null,null,null,null,null,null,null];
(statearr_40905[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_40905[(1)] = (1));

return statearr_40905;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_40889){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40889);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40906){var ex__16304__auto__ = e40906;
var statearr_40907_40920 = state_40889;
(statearr_40907_40920[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40889[(4)]))){
var statearr_40908_40921 = state_40889;
(statearr_40908_40921[(1)] = cljs.core.first((state_40889[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40922 = state_40889;
state_40889 = G__40922;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_40889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_40889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40909 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40909[(6)] = c__16375__auto__);

return statearr_40909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40966){
var state_val_40967 = (state_40966[(1)]);
if((state_val_40967 === (1))){
var state_40966__$1 = state_40966;
var statearr_40968_40982 = state_40966__$1;
(statearr_40968_40982[(2)] = null);

(statearr_40968_40982[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40967 === (2))){
var _ = (function (){var statearr_40969 = state_40966;
(statearr_40969[(4)] = cljs.core.cons((5),(state_40966[(4)])));

return statearr_40969;
})();
var inst_40933 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40935 = ["_user/_auth"];
var inst_40936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40937 = ["*"];
var inst_40938 = (new cljs.core.PersistentVector(null,1,(5),inst_40936,inst_40937,null));
var inst_40939 = [inst_40938];
var inst_40940 = cljs.core.PersistentHashMap.fromArrays(inst_40935,inst_40939);
var inst_40941 = [inst_40940];
var inst_40942 = (new cljs.core.PersistentVector(null,1,(5),inst_40934,inst_40941,null));
var inst_40943 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40944 = cljs.core.PersistentHashMap.EMPTY;
var inst_40945 = [inst_40942,inst_40943,inst_40944];
var inst_40946 = cljs.core.PersistentHashMap.fromArrays(inst_40933,inst_40945);
var inst_40947 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40948 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40947,inst_40946);
var state_40966__$1 = state_40966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40966__$1,(6),inst_40948);
} else {
if((state_val_40967 === (3))){
var inst_40964 = (state_40966[(2)]);
var state_40966__$1 = state_40966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40966__$1,inst_40964);
} else {
if((state_val_40967 === (4))){
var inst_40923 = (state_40966[(2)]);
var inst_40924 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40923,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_40966__$1 = state_40966;
var statearr_40971_40983 = state_40966__$1;
(statearr_40971_40983[(2)] = inst_40924);

(statearr_40971_40983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40967 === (5))){
var _ = (function (){var statearr_40972 = state_40966;
(statearr_40972[(4)] = cljs.core.rest((state_40966[(4)])));

return statearr_40972;
})();
var state_40966__$1 = state_40966;
var ex40970 = (state_40966__$1[(2)]);
var statearr_40973_40984 = state_40966__$1;
(statearr_40973_40984[(5)] = ex40970);


var statearr_40974_40985 = state_40966__$1;
(statearr_40974_40985[(1)] = (4));

(statearr_40974_40985[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40967 === (6))){
var inst_40950 = (state_40966[(2)]);
var inst_40951 = fluree.db.util.async.throw_err(inst_40950);
var inst_40952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40951,(0),null);
var inst_40953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40951,(1),null);
var inst_40954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40955 = ["_user/_auth","_id"];
var inst_40956 = (new cljs.core.PersistentVector(null,2,(5),inst_40954,inst_40955,null));
var inst_40957 = fluree.db.dbfunctions.internal.get_in(inst_40952,inst_40956);
var inst_40958 = cljs.core.first(inst_40957);
var inst_40959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40960 = [inst_40958,inst_40953];
var inst_40961 = (new cljs.core.PersistentVector(null,2,(5),inst_40959,inst_40960,null));
var _ = (function (){var statearr_40975 = state_40966;
(statearr_40975[(4)] = cljs.core.rest((state_40966[(4)])));

return statearr_40975;
})();
var state_40966__$1 = state_40966;
var statearr_40976_40986 = state_40966__$1;
(statearr_40976_40986[(2)] = inst_40961);

(statearr_40976_40986[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0 = (function (){
var statearr_40977 = [null,null,null,null,null,null,null];
(statearr_40977[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__);

(statearr_40977[(1)] = (1));

return statearr_40977;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1 = (function (state_40966){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40966);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40978){var ex__16304__auto__ = e40978;
var statearr_40979_40987 = state_40966;
(statearr_40979_40987[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40966[(4)]))){
var statearr_40980_40988 = state_40966;
(statearr_40980_40988[(1)] = cljs.core.first((state_40966[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40989 = state_40966;
state_40966 = G__40989;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = function(state_40966){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1.call(this,state_40966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40981 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40981[(6)] = c__16375__auto__);

return statearr_40981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41006){
var state_val_41007 = (state_41006[(1)]);
if((state_val_41007 === (1))){
var state_41006__$1 = state_41006;
var statearr_41008_41022 = state_41006__$1;
(statearr_41008_41022[(2)] = null);

(statearr_41008_41022[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41007 === (2))){
var _ = (function (){var statearr_41009 = state_41006;
(statearr_41009[(4)] = cljs.core.cons((5),(state_41006[(4)])));

return statearr_41009;
})();
var inst_40996 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40997 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40998 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_40997,inst_40996);
var state_41006__$1 = state_41006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41006__$1,(6),inst_40998);
} else {
if((state_val_41007 === (3))){
var inst_41004 = (state_41006[(2)]);
var state_41006__$1 = state_41006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41006__$1,inst_41004);
} else {
if((state_val_41007 === (4))){
var inst_40990 = (state_41006[(2)]);
var state_41006__$1 = state_41006;
var statearr_41011_41023 = state_41006__$1;
(statearr_41011_41023[(2)] = inst_40990);

(statearr_41011_41023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41007 === (5))){
var _ = (function (){var statearr_41012 = state_41006;
(statearr_41012[(4)] = cljs.core.rest((state_41006[(4)])));

return statearr_41012;
})();
var state_41006__$1 = state_41006;
var ex41010 = (state_41006__$1[(2)]);
var statearr_41013_41024 = state_41006__$1;
(statearr_41013_41024[(5)] = ex41010);


if((ex41010 instanceof Error)){
var statearr_41014_41025 = state_41006__$1;
(statearr_41014_41025[(1)] = (4));

(statearr_41014_41025[(5)] = null);

} else {
throw ex41010;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41007 === (6))){
var inst_41000 = (state_41006[(2)]);
var inst_41001 = fluree.db.util.async.throw_err(inst_41000);
var _ = (function (){var statearr_41015 = state_41006;
(statearr_41015[(4)] = cljs.core.rest((state_41006[(4)])));

return statearr_41015;
})();
var state_41006__$1 = state_41006;
var statearr_41016_41026 = state_41006__$1;
(statearr_41016_41026[(2)] = inst_41001);

(statearr_41016_41026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0 = (function (){
var statearr_41017 = [null,null,null,null,null,null,null];
(statearr_41017[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__);

(statearr_41017[(1)] = (1));

return statearr_41017;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1 = (function (state_41006){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41006);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41018){var ex__16304__auto__ = e41018;
var statearr_41019_41027 = state_41006;
(statearr_41019_41027[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41006[(4)]))){
var statearr_41020_41028 = state_41006;
(statearr_41020_41028[(1)] = cljs.core.first((state_41006[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41029 = state_41006;
state_41006 = G__41029;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = function(state_41006){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1.call(this,state_41006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41021 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41021[(6)] = c__16375__auto__);

return statearr_41021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__41030_SHARP_){
return p1__41030_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41031_SHARP_){
return p1__41031_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41032){var e = e41032;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__41033_SHARP_){
return p1__41033_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41034_SHARP_){
return p1__41034_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41035){var e = e41035;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__41037 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__41037);
})() | (0));
return num;
}catch (e41036){var e = e41036;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41137){
var state_val_41138 = (state_41137[(1)]);
if((state_val_41138 === (7))){
var state_41137__$1 = state_41137;
var statearr_41139_41187 = state_41137__$1;
(statearr_41139_41187[(2)] = false);

(statearr_41139_41187[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (20))){
var inst_41071 = (state_41137[(7)]);
var inst_41072 = (state_41137[(8)]);
var inst_41093 = (state_41137[(2)]);
var inst_41094 = fluree.db.dbproto._p_prop(inst_41072,cljs.core.cst$kw$multi,inst_41071);
var state_41137__$1 = (function (){var statearr_41140 = state_41137;
(statearr_41140[(9)] = inst_41093);

return statearr_41140;
})();
if(cljs.core.truth_(inst_41094)){
var statearr_41141_41188 = state_41137__$1;
(statearr_41141_41188[(1)] = (21));

} else {
var statearr_41142_41189 = state_41137__$1;
(statearr_41142_41189[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (27))){
var inst_41132 = (state_41137[(2)]);
var _ = (function (){var statearr_41143 = state_41137;
(statearr_41143[(4)] = cljs.core.rest((state_41137[(4)])));

return statearr_41143;
})();
var state_41137__$1 = state_41137;
var statearr_41144_41190 = state_41137__$1;
(statearr_41144_41190[(2)] = inst_41132);

(statearr_41144_41190[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (1))){
var state_41137__$1 = state_41137;
var statearr_41145_41191 = state_41137__$1;
(statearr_41145_41191[(2)] = null);

(statearr_41145_41191[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (24))){
var inst_41121 = (state_41137[(10)]);
var inst_41117 = (state_41137[(2)]);
var inst_41118 = fluree.db.util.async.throw_err(inst_41117);
var inst_41119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41118,(0),null);
var inst_41120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41118,(1),null);
var inst_41121__$1 = cljs.core.first(inst_41119);
var inst_41122 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41121__$1,compare_val);
var state_41137__$1 = (function (){var statearr_41146 = state_41137;
(statearr_41146[(11)] = inst_41120);

(statearr_41146[(10)] = inst_41121__$1);

return statearr_41146;
})();
if(inst_41122){
var statearr_41147_41192 = state_41137__$1;
(statearr_41147_41192[(1)] = (25));

} else {
var statearr_41148_41193 = state_41137__$1;
(statearr_41148_41193[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (4))){
var inst_41038 = (state_41137[(2)]);
var state_41137__$1 = state_41137;
var statearr_41149_41194 = state_41137__$1;
(statearr_41149_41194[(2)] = inst_41038);

(statearr_41149_41194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (15))){
var state_41137__$1 = state_41137;
var statearr_41150_41195 = state_41137__$1;
(statearr_41150_41195[(2)] = null);

(statearr_41150_41195[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (21))){
var inst_41073 = (state_41137[(12)]);
var inst_41096 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_41073], 0));
var inst_41097 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41098 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41099 = cljs.core.PersistentHashMap.fromArrays(inst_41097,inst_41098);
var inst_41100 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41096,inst_41099);
var inst_41101 = (function(){throw inst_41100})();
var state_41137__$1 = state_41137;
var statearr_41151_41196 = state_41137__$1;
(statearr_41151_41196[(2)] = inst_41101);

(statearr_41151_41196[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (13))){
var inst_41048 = (state_41137[(13)]);
var state_41137__$1 = state_41137;
var statearr_41152_41197 = state_41137__$1;
(statearr_41152_41197[(2)] = inst_41048);

(statearr_41152_41197[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (22))){
var state_41137__$1 = state_41137;
var statearr_41153_41198 = state_41137__$1;
(statearr_41153_41198[(2)] = null);

(statearr_41153_41198[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (6))){
var inst_41048 = (state_41137[(13)]);
var inst_41053 = inst_41048.cljs$lang$protocol_mask$partition0$;
var inst_41054 = (inst_41053 & (64));
var inst_41055 = inst_41048.cljs$core$ISeq$;
var inst_41056 = (cljs.core.PROTOCOL_SENTINEL === inst_41055);
var inst_41057 = ((inst_41054) || (inst_41056));
var state_41137__$1 = state_41137;
if(cljs.core.truth_(inst_41057)){
var statearr_41154_41199 = state_41137__$1;
(statearr_41154_41199[(1)] = (9));

} else {
var statearr_41155_41200 = state_41137__$1;
(statearr_41155_41200[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (25))){
var state_41137__$1 = state_41137;
var statearr_41156_41201 = state_41137__$1;
(statearr_41156_41201[(2)] = new_val);

(statearr_41156_41201[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (17))){
var inst_41073 = (state_41137[(12)]);
var inst_41083 = (state_41137[(2)]);
var state_41137__$1 = (function (){var statearr_41157 = state_41137;
(statearr_41157[(14)] = inst_41083);

return statearr_41157;
})();
if(cljs.core.truth_(inst_41073)){
var statearr_41158_41202 = state_41137__$1;
(statearr_41158_41202[(1)] = (18));

} else {
var statearr_41159_41203 = state_41137__$1;
(statearr_41159_41203[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (3))){
var inst_41135 = (state_41137[(2)]);
var state_41137__$1 = state_41137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41137__$1,inst_41135);
} else {
if((state_val_41138 === (12))){
var inst_41048 = (state_41137[(13)]);
var inst_41066 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_41048);
var state_41137__$1 = state_41137;
var statearr_41160_41204 = state_41137__$1;
(statearr_41160_41204[(2)] = inst_41066);

(statearr_41160_41204[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (2))){
var inst_41048 = (state_41137[(13)]);
var _ = (function (){var statearr_41161 = state_41137;
(statearr_41161[(4)] = cljs.core.cons((5),(state_41137[(4)])));

return statearr_41161;
})();
var inst_41048__$1 = _QMARK_ctx;
var inst_41050 = (inst_41048__$1 == null);
var inst_41051 = cljs.core.not(inst_41050);
var state_41137__$1 = (function (){var statearr_41162 = state_41137;
(statearr_41162[(13)] = inst_41048__$1);

return statearr_41162;
})();
if(inst_41051){
var statearr_41163_41205 = state_41137__$1;
(statearr_41163_41205[(1)] = (6));

} else {
var statearr_41164_41206 = state_41137__$1;
(statearr_41164_41206[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (23))){
var inst_41070 = (state_41137[(15)]);
var inst_41072 = (state_41137[(8)]);
var inst_41073 = (state_41137[(12)]);
var inst_41104 = (state_41137[(2)]);
var inst_41105 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41108 = [inst_41070,inst_41073,"?current-val"];
var inst_41109 = (new cljs.core.PersistentVector(null,3,(5),inst_41107,inst_41108,null));
var inst_41110 = [inst_41109];
var inst_41111 = (new cljs.core.PersistentVector(null,1,(5),inst_41106,inst_41110,null));
var inst_41112 = cljs.core.PersistentHashMap.EMPTY;
var inst_41113 = ["?current-val",inst_41111,inst_41112];
var inst_41114 = cljs.core.PersistentHashMap.fromArrays(inst_41105,inst_41113);
var inst_41115 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41072,inst_41114);
var state_41137__$1 = (function (){var statearr_41165 = state_41137;
(statearr_41165[(16)] = inst_41104);

return statearr_41165;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41137__$1,(24),inst_41115);
} else {
if((state_val_41138 === (19))){
var inst_41086 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41087 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41088 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41089 = cljs.core.PersistentHashMap.fromArrays(inst_41087,inst_41088);
var inst_41090 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41086,inst_41089);
var inst_41091 = (function(){throw inst_41090})();
var state_41137__$1 = state_41137;
var statearr_41166_41207 = state_41137__$1;
(statearr_41166_41207[(2)] = inst_41091);

(statearr_41166_41207[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (11))){
var inst_41061 = (state_41137[(2)]);
var state_41137__$1 = state_41137;
var statearr_41168_41208 = state_41137__$1;
(statearr_41168_41208[(2)] = inst_41061);

(statearr_41168_41208[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (9))){
var state_41137__$1 = state_41137;
var statearr_41169_41209 = state_41137__$1;
(statearr_41169_41209[(2)] = true);

(statearr_41169_41209[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (5))){
var _ = (function (){var statearr_41170 = state_41137;
(statearr_41170[(4)] = cljs.core.rest((state_41137[(4)])));

return statearr_41170;
})();
var state_41137__$1 = state_41137;
var ex41167 = (state_41137__$1[(2)]);
var statearr_41171_41210 = state_41137__$1;
(statearr_41171_41210[(5)] = ex41167);


if((ex41167 instanceof Error)){
var statearr_41172_41211 = state_41137__$1;
(statearr_41172_41211[(1)] = (4));

(statearr_41172_41211[(5)] = null);

} else {
throw ex41167;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (14))){
var inst_41071 = (state_41137[(7)]);
var inst_41070 = (state_41137[(15)]);
var inst_41072 = (state_41137[(8)]);
var inst_41069 = (state_41137[(2)]);
var inst_41070__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41069,cljs.core.cst$kw$sid);
var inst_41071__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41069,cljs.core.cst$kw$pid);
var inst_41072__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41069,cljs.core.cst$kw$db);
var inst_41073 = fluree.db.dbproto._p_prop(inst_41072__$1,cljs.core.cst$kw$name,inst_41071__$1);
var state_41137__$1 = (function (){var statearr_41173 = state_41137;
(statearr_41173[(7)] = inst_41071__$1);

(statearr_41173[(15)] = inst_41070__$1);

(statearr_41173[(8)] = inst_41072__$1);

(statearr_41173[(12)] = inst_41073);

return statearr_41173;
})();
if(cljs.core.truth_(inst_41070__$1)){
var statearr_41174_41212 = state_41137__$1;
(statearr_41174_41212[(1)] = (15));

} else {
var statearr_41175_41213 = state_41137__$1;
(statearr_41175_41213[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (26))){
var inst_41121 = (state_41137[(10)]);
var inst_41125 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41121)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_41126 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41127 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41128 = cljs.core.PersistentHashMap.fromArrays(inst_41126,inst_41127);
var inst_41129 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41125,inst_41128);
var inst_41130 = (function(){throw inst_41129})();
var state_41137__$1 = state_41137;
var statearr_41176_41214 = state_41137__$1;
(statearr_41176_41214[(2)] = inst_41130);

(statearr_41176_41214[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (16))){
var inst_41076 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41077 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41078 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41079 = cljs.core.PersistentHashMap.fromArrays(inst_41077,inst_41078);
var inst_41080 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41076,inst_41079);
var inst_41081 = (function(){throw inst_41080})();
var state_41137__$1 = state_41137;
var statearr_41177_41215 = state_41137__$1;
(statearr_41177_41215[(2)] = inst_41081);

(statearr_41177_41215[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (10))){
var state_41137__$1 = state_41137;
var statearr_41178_41216 = state_41137__$1;
(statearr_41178_41216[(2)] = false);

(statearr_41178_41216[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (18))){
var state_41137__$1 = state_41137;
var statearr_41179_41217 = state_41137__$1;
(statearr_41179_41217[(2)] = null);

(statearr_41179_41217[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41138 === (8))){
var inst_41064 = (state_41137[(2)]);
var state_41137__$1 = state_41137;
if(cljs.core.truth_(inst_41064)){
var statearr_41180_41218 = state_41137__$1;
(statearr_41180_41218[(1)] = (12));

} else {
var statearr_41181_41219 = state_41137__$1;
(statearr_41181_41219[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0 = (function (){
var statearr_41182 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41182[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__);

(statearr_41182[(1)] = (1));

return statearr_41182;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1 = (function (state_41137){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41137);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41183){var ex__16304__auto__ = e41183;
var statearr_41184_41220 = state_41137;
(statearr_41184_41220[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41137[(4)]))){
var statearr_41185_41221 = state_41137;
(statearr_41185_41221[(1)] = cljs.core.first((state_41137[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41222 = state_41137;
state_41137 = G__41222;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = function(state_41137){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1.call(this,state_41137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41186 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41186[(6)] = c__16375__auto__);

return statearr_41186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
