// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32783_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__32783_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__32787 = coll;
var vec__32788 = G__32787;
var seq__32789 = cljs.core.seq(vec__32788);
var first__32790 = cljs.core.first(seq__32789);
var seq__32789__$1 = cljs.core.next(seq__32789);
var clause = first__32790;
var r = seq__32789__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__32787__$1 = G__32787;
var res__$1 = res;
while(true){
var vec__32794 = G__32787__$1;
var seq__32795 = cljs.core.seq(vec__32794);
var first__32796 = cljs.core.first(seq__32795);
var seq__32795__$1 = cljs.core.next(seq__32795);
var clause__$1 = first__32796;
var r__$1 = seq__32795__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__32797 = r__$1;
var G__32798 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__32787__$1 = G__32797;
res__$1 = G__32798;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__32802 = coll;
var vec__32803 = G__32802;
var seq__32804 = cljs.core.seq(vec__32803);
var first__32805 = cljs.core.first(seq__32804);
var seq__32804__$1 = cljs.core.next(seq__32804);
var clause = first__32805;
var r = seq__32804__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__32802__$1 = G__32802;
var res__$1 = res;
while(true){
var vec__32809 = G__32802__$1;
var seq__32810 = cljs.core.seq(vec__32809);
var first__32811 = cljs.core.first(seq__32810);
var seq__32810__$1 = cljs.core.next(seq__32810);
var clause__$1 = first__32811;
var r__$1 = seq__32810__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__32812 = r__$1;
var G__32813 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__32802__$1 = G__32812;
res__$1 = G__32813;
continue;
} else {
var G__32814 = r__$1;
var G__32815 = res__$2;
G__32802__$1 = G__32814;
res__$1 = G__32815;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__32819 = coll;
var vec__32820 = G__32819;
var seq__32821 = cljs.core.seq(vec__32820);
var first__32822 = cljs.core.first(seq__32821);
var seq__32821__$1 = cljs.core.next(seq__32821);
var clause = first__32822;
var r = seq__32821__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__32819__$1 = G__32819;
var res__$1 = res;
while(true){
var vec__32826 = G__32819__$1;
var seq__32827 = cljs.core.seq(vec__32826);
var first__32828 = cljs.core.first(seq__32827);
var seq__32827__$1 = cljs.core.next(seq__32827);
var clause__$1 = first__32828;
var r__$1 = seq__32827__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__32829 = r__$1;
var G__32830 = res__$2;
G__32819__$1 = G__32829;
res__$1 = G__32830;
continue;
} else {
var G__32831 = r__$1;
var G__32832 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__32819__$1 = G__32831;
res__$1 = G__32832;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__32836 = opts;
var map__32836__$1 = (((((!((map__32836 == null))))?(((((map__32836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32836):map__32836);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32836__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32836__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32836__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32836__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32836__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32833_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__32833_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__32834_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__32834_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__32835_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__32835_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32851){
var state_val_32852 = (state_32851[(1)]);
if((state_val_32852 === (1))){
var inst_32838 = fluree.db.util.core.url_encode(query);
var inst_32839 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32838)].join('');
var inst_32840 = ["User-Agent","Accept"];
var inst_32841 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_32842 = cljs.core.PersistentHashMap.fromArrays(inst_32840,inst_32841);
var inst_32843 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_32844 = [inst_32842,(30000),cljs.core.cst$kw$wikidata];
var inst_32845 = cljs.core.PersistentHashMap.fromArrays(inst_32843,inst_32844);
var inst_32846 = fluree.db.util.xhttp.get(inst_32839,inst_32845);
var state_32851__$1 = state_32851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32851__$1,(2),inst_32846);
} else {
if((state_val_32852 === (2))){
var inst_32848 = (state_32851[(2)]);
var inst_32849 = fluree.db.util.async.throw_err(inst_32848);
var state_32851__$1 = state_32851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32851__$1,inst_32849);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_32853 = [null,null,null,null,null,null,null];
(statearr_32853[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__);

(statearr_32853[(1)] = (1));

return statearr_32853;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1 = (function (state_32851){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32851);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32854){var ex__16304__auto__ = e32854;
var statearr_32855_32858 = state_32851;
(statearr_32855_32858[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32851[(4)]))){
var statearr_32856_32859 = state_32851;
(statearr_32856_32859[(1)] = cljs.core.first((state_32851[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32860 = state_32851;
state_32851 = G__32860;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__ = function(state_32851){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1.call(this,state_32851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32857 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32857[(6)] = c__16375__auto__);

return statearr_32857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32878){
var state_val_32879 = (state_32878[(1)]);
if((state_val_32879 === (1))){
var inst_32861 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_32878__$1 = state_32878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32878__$1,(2),inst_32861);
} else {
if((state_val_32879 === (2))){
var inst_32864 = (state_32878[(7)]);
var inst_32863 = (state_32878[(2)]);
var inst_32864__$1 = fluree.db.util.async.throw_err(inst_32863);
var inst_32865 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32864__$1);
var inst_32866 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_32865);
var state_32878__$1 = (function (){var statearr_32880 = state_32878;
(statearr_32880[(7)] = inst_32864__$1);

return statearr_32880;
})();
if(inst_32866){
var statearr_32881_32890 = state_32878__$1;
(statearr_32881_32890[(1)] = (3));

} else {
var statearr_32882_32891 = state_32878__$1;
(statearr_32882_32891[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32879 === (3))){
var inst_32864 = (state_32878[(7)]);
var state_32878__$1 = state_32878;
var statearr_32883_32892 = state_32878__$1;
(statearr_32883_32892[(2)] = inst_32864);

(statearr_32883_32892[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32879 === (4))){
var inst_32864 = (state_32878[(7)]);
var inst_32869 = (function (){var body = inst_32864;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_32870 = cljs.core.second(inst_32864);
var inst_32871 = cljs.core.second(inst_32870);
var inst_32872 = cljs.core.first(inst_32871);
var inst_32873 = cljs.core.second(inst_32872);
var inst_32874 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_32869,inst_32873);
var state_32878__$1 = state_32878;
var statearr_32884_32893 = state_32878__$1;
(statearr_32884_32893[(2)] = inst_32874);

(statearr_32884_32893[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32879 === (5))){
var inst_32876 = (state_32878[(2)]);
var state_32878__$1 = state_32878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32878__$1,inst_32876);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0 = (function (){
var statearr_32885 = [null,null,null,null,null,null,null,null];
(statearr_32885[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__);

(statearr_32885[(1)] = (1));

return statearr_32885;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1 = (function (state_32878){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32878);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e32886){var ex__16304__auto__ = e32886;
var statearr_32887_32894 = state_32878;
(statearr_32887_32894[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32878[(4)]))){
var statearr_32888_32895 = state_32878;
(statearr_32888_32895[(1)] = cljs.core.first((state_32878[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__32896 = state_32878;
state_32878 = G__32896;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__ = function(state_32878){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1.call(this,state_32878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_32889 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_32889[(6)] = c__16375__auto__);

return statearr_32889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32897_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__32897_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32898_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__32898_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32899_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__32899_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32899_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__32899_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_32965){
var state_val_32966 = (state_32965[(1)]);
if((state_val_32966 === (7))){
var inst_32910 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_32965__$1 = state_32965;
var statearr_32967_33008 = state_32965__$1;
(statearr_32967_33008[(2)] = inst_32910);

(statearr_32967_33008[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (20))){
var inst_32938 = (state_32965[(7)]);
var inst_32958 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_32938,all_vars);
var state_32965__$1 = state_32965;
var statearr_32968_33009 = state_32965__$1;
(statearr_32968_33009[(2)] = inst_32958);

(statearr_32968_33009[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (1))){
var state_32965__$1 = state_32965;
var statearr_32969_33010 = state_32965__$1;
(statearr_32969_33010[(2)] = null);

(statearr_32969_33010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (24))){
var inst_32938 = (state_32965[(7)]);
var inst_32944 = (state_32965[(8)]);
var inst_32939 = (state_32965[(9)]);
var inst_32949 = (state_32965[(2)]);
var inst_32950 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_32944,(0),inst_32949);
var inst_32951 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32952 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_32938);
var inst_32953 = [inst_32939,inst_32952];
var inst_32954 = cljs.core.PersistentHashMap.fromArrays(inst_32951,inst_32953);
var inst_32955 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32950,inst_32954);
var inst_32956 = (function(){throw inst_32955})();
var state_32965__$1 = state_32965;
var statearr_32970_33011 = state_32965__$1;
(statearr_32970_33011[(2)] = inst_32956);

(statearr_32970_33011[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (4))){
var inst_32900 = (state_32965[(2)]);
var state_32965__$1 = state_32965;
var statearr_32971_33012 = state_32965__$1;
(statearr_32971_33012[(2)] = inst_32900);

(statearr_32971_33012[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (15))){
var inst_32930 = (state_32965[(2)]);
var state_32965__$1 = state_32965;
var statearr_32972_33013 = state_32965__$1;
(statearr_32972_33013[(2)] = inst_32930);

(statearr_32972_33013[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (21))){
var inst_32960 = (state_32965[(2)]);
var _ = (function (){var statearr_32973 = state_32965;
(statearr_32973[(4)] = cljs.core.rest((state_32965[(4)])));

return statearr_32973;
})();
var state_32965__$1 = state_32965;
var statearr_32974_33014 = state_32965__$1;
(statearr_32974_33014[(2)] = inst_32960);

(statearr_32974_33014[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (13))){
var state_32965__$1 = state_32965;
var statearr_32975_33015 = state_32965__$1;
(statearr_32975_33015[(2)] = true);

(statearr_32975_33015[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (22))){
var inst_32943 = (state_32965[(10)]);
var state_32965__$1 = state_32965;
var statearr_32976_33016 = state_32965__$1;
(statearr_32976_33016[(2)] = inst_32943);

(statearr_32976_33016[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (6))){
var state_32965__$1 = state_32965;
var statearr_32977_33017 = state_32965__$1;
(statearr_32977_33017[(2)] = null);

(statearr_32977_33017[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (17))){
var inst_32917 = (state_32965[(11)]);
var state_32965__$1 = state_32965;
var statearr_32978_33018 = state_32965__$1;
(statearr_32978_33018[(2)] = inst_32917);

(statearr_32978_33018[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (3))){
var inst_32963 = (state_32965[(2)]);
var state_32965__$1 = state_32965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32965__$1,inst_32963);
} else {
if((state_val_32966 === (12))){
var inst_32933 = (state_32965[(2)]);
var state_32965__$1 = state_32965;
if(cljs.core.truth_(inst_32933)){
var statearr_32979_33019 = state_32965__$1;
(statearr_32979_33019[(1)] = (16));

} else {
var statearr_32980_33020 = state_32965__$1;
(statearr_32980_33020[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (2))){
var _ = (function (){var statearr_32981 = state_32965;
(statearr_32981[(4)] = cljs.core.cons((5),(state_32965[(4)])));

return statearr_32981;
})();
var inst_32907 = cljs.core.empty_QMARK_(matching_vars);
var state_32965__$1 = state_32965;
if(inst_32907){
var statearr_32982_33021 = state_32965__$1;
(statearr_32982_33021[(1)] = (6));

} else {
var statearr_32983_33022 = state_32965__$1;
(statearr_32983_33022[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (23))){
var state_32965__$1 = state_32965;
var statearr_32984_33023 = state_32965__$1;
(statearr_32984_33023[(2)] = (1000));

(statearr_32984_33023[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (19))){
var inst_32938 = (state_32965[(7)]);
var inst_32943 = (state_32965[(10)]);
var inst_32940 = (state_32965[(12)]);
var inst_32943__$1 = cljs.core.count(inst_32940);
var inst_32944 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_32938);
var inst_32945 = (inst_32943__$1 < (1000));
var state_32965__$1 = (function (){var statearr_32985 = state_32965;
(statearr_32985[(10)] = inst_32943__$1);

(statearr_32985[(8)] = inst_32944);

return statearr_32985;
})();
if(cljs.core.truth_(inst_32945)){
var statearr_32986_33024 = state_32965__$1;
(statearr_32986_33024[(1)] = (22));

} else {
var statearr_32987_33025 = state_32965__$1;
(statearr_32987_33025[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (11))){
var state_32965__$1 = state_32965;
var statearr_32989_33026 = state_32965__$1;
(statearr_32989_33026[(2)] = false);

(statearr_32989_33026[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (9))){
var inst_32917 = (state_32965[(11)]);
var inst_32916 = (state_32965[(2)]);
var inst_32917__$1 = fluree.db.util.async.throw_err(inst_32916);
var inst_32919 = (inst_32917__$1 == null);
var inst_32920 = cljs.core.not(inst_32919);
var state_32965__$1 = (function (){var statearr_32990 = state_32965;
(statearr_32990[(11)] = inst_32917__$1);

return statearr_32990;
})();
if(inst_32920){
var statearr_32991_33027 = state_32965__$1;
(statearr_32991_33027[(1)] = (10));

} else {
var statearr_32992_33028 = state_32965__$1;
(statearr_32992_33028[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (5))){
var _ = (function (){var statearr_32993 = state_32965;
(statearr_32993[(4)] = cljs.core.rest((state_32965[(4)])));

return statearr_32993;
})();
var state_32965__$1 = state_32965;
var ex32988 = (state_32965__$1[(2)]);
var statearr_32994_33029 = state_32965__$1;
(statearr_32994_33029[(5)] = ex32988);


if((ex32988 instanceof Error)){
var statearr_32995_33030 = state_32965__$1;
(statearr_32995_33030[(1)] = (4));

(statearr_32995_33030[(5)] = null);

} else {
throw ex32988;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (14))){
var state_32965__$1 = state_32965;
var statearr_32996_33031 = state_32965__$1;
(statearr_32996_33031[(2)] = false);

(statearr_32996_33031[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (16))){
var inst_32917 = (state_32965[(11)]);
var inst_32935 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32917);
var state_32965__$1 = state_32965;
var statearr_32997_33032 = state_32965__$1;
(statearr_32997_33032[(2)] = inst_32935);

(statearr_32997_33032[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (10))){
var inst_32917 = (state_32965[(11)]);
var inst_32922 = inst_32917.cljs$lang$protocol_mask$partition0$;
var inst_32923 = (inst_32922 & (64));
var inst_32924 = inst_32917.cljs$core$ISeq$;
var inst_32925 = (cljs.core.PROTOCOL_SENTINEL === inst_32924);
var inst_32926 = ((inst_32923) || (inst_32925));
var state_32965__$1 = state_32965;
if(cljs.core.truth_(inst_32926)){
var statearr_32998_33033 = state_32965__$1;
(statearr_32998_33033[(1)] = (13));

} else {
var statearr_32999_33034 = state_32965__$1;
(statearr_32999_33034[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (18))){
var inst_32938 = (state_32965[(7)]);
var inst_32939 = (state_32965[(9)]);
var inst_32938__$1 = (state_32965[(2)]);
var inst_32939__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32938__$1,cljs.core.cst$kw$status);
var inst_32940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32938__$1,cljs.core.cst$kw$message);
var inst_32941 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_32939__$1);
var state_32965__$1 = (function (){var statearr_33000 = state_32965;
(statearr_33000[(7)] = inst_32938__$1);

(statearr_33000[(9)] = inst_32939__$1);

(statearr_33000[(12)] = inst_32940);

return statearr_33000;
})();
if(inst_32941){
var statearr_33001_33035 = state_32965__$1;
(statearr_33001_33035[(1)] = (19));

} else {
var statearr_33002_33036 = state_32965__$1;
(statearr_33002_33036[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32966 === (8))){
var inst_32912 = (state_32965[(2)]);
var inst_32913 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_32912,optional_clauses);
var inst_32914 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_32913);
var state_32965__$1 = state_32965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32965__$1,(9),inst_32914);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_33003 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33003[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__);

(statearr_33003[(1)] = (1));

return statearr_33003;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1 = (function (state_32965){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_32965);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33004){var ex__16304__auto__ = e33004;
var statearr_33005_33037 = state_32965;
(statearr_33005_33037[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_32965[(4)]))){
var statearr_33006_33038 = state_32965;
(statearr_33006_33038[(1)] = cljs.core.first((state_32965[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33039 = state_32965;
state_32965 = G__33039;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__ = function(state_32965){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1.call(this,state_32965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33007 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33007[(6)] = c__16375__auto__);

return statearr_33007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
