// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__36161 = null;
var G__36161__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36161__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36161__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__36161 = function(result,flake){
switch(arguments.length){
case 0:
return G__36161__0.call(this);
case 1:
return G__36161__1.call(this,result);
case 2:
return G__36161__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36161.cljs$core$IFn$_invoke$arity$0 = G__36161__0;
G__36161.cljs$core$IFn$_invoke$arity$1 = G__36161__1;
G__36161.cljs$core$IFn$_invoke$arity$2 = G__36161__2;
return G__36161;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__36162 = null;
var G__36162__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__36162__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__36162__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__36162 = function(result,flakes){
switch(arguments.length){
case 0:
return G__36162__0.call(this);
case 1:
return G__36162__1.call(this,result);
case 2:
return G__36162__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36162.cljs$core$IFn$_invoke$arity$0 = G__36162__0;
G__36162.cljs$core$IFn$_invoke$arity$1 = G__36162__1;
G__36162.cljs$core$IFn$_invoke$arity$2 = G__36162__2;
return G__36162;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__36164 = res;
var G__36164__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__36163_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__36163_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__36164):G__36164);
var G__36164__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__36164__$1):G__36164__$1);
var G__36164__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__36164__$2):G__36164__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__36164__$3);
} else {
return G__36164__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__36166 = arguments.length;
switch (G__36166) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36469){
var state_val_36470 = (state_36469[(1)]);
if((state_val_36470 === (65))){
var inst_36196 = (state_36469[(7)]);
var inst_36327 = (state_36469[(8)]);
var inst_36320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36321 = cljs.core.deref(cache);
var inst_36322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36323 = flake.o;
var inst_36324 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36196);
var inst_36325 = [inst_36323,inst_36324];
var inst_36326 = (new cljs.core.PersistentVector(null,2,(5),inst_36322,inst_36325,null));
var inst_36327__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36321,inst_36326);
var state_36469__$1 = (function (){var statearr_36471 = state_36469;
(statearr_36471[(9)] = inst_36320);

(statearr_36471[(8)] = inst_36327__$1);

return statearr_36471;
})();
if(cljs.core.truth_(inst_36327__$1)){
var statearr_36472_36638 = state_36469__$1;
(statearr_36472_36638[(1)] = (68));

} else {
var statearr_36473_36639 = state_36469__$1;
(statearr_36473_36639[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (70))){
var inst_36320 = (state_36469[(9)]);
var inst_36345 = (state_36469[(2)]);
var inst_36346 = [inst_36345,offset_map];
var inst_36347 = (new cljs.core.PersistentVector(null,2,(5),inst_36320,inst_36346,null));
var state_36469__$1 = state_36469;
var statearr_36474_36640 = state_36469__$1;
(statearr_36474_36640[(2)] = inst_36347);

(statearr_36474_36640[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (62))){
var inst_36305 = (state_36469[(10)]);
var inst_36196 = (state_36469[(7)]);
var inst_36229 = (state_36469[(11)]);
var inst_36233 = (state_36469[(12)]);
var inst_36190 = (state_36469[(13)]);
var inst_36234 = (state_36469[(14)]);
var inst_36207 = (state_36469[(15)]);
var inst_36289 = (state_36469[(16)]);
var inst_36231 = (state_36469[(17)]);
var inst_36228 = (state_36469[(18)]);
var inst_36232 = (state_36469[(19)]);
var inst_36230 = (state_36469[(20)]);
var inst_36307 = (function (){var map__36173 = inst_36228;
var p = inst_36234;
var pred_spec__$1 = inst_36190;
var orderBy = inst_36232;
var nested_select_spec = inst_36289;
var multi_QMARK_ = inst_36229;
var limit = inst_36231;
var offset = inst_36233;
var G__36291 = inst_36305;
var k = inst_36207;
var pred_spec_SINGLEQUOTE_ = inst_36196;
var ref_QMARK_ = inst_36230;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_36308 = (inst_36307.cljs$core$IFn$_invoke$arity$1 ? inst_36307.cljs$core$IFn$_invoke$arity$1(inst_36305) : inst_36307.call(null,inst_36305));
var state_36469__$1 = state_36469;
var statearr_36475_36641 = state_36469__$1;
(statearr_36475_36641[(2)] = inst_36308);

(statearr_36475_36641[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (74))){
var inst_36354 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36354)){
var statearr_36476_36642 = state_36469__$1;
(statearr_36476_36642[(1)] = (75));

} else {
var statearr_36477_36643 = state_36469__$1;
(statearr_36477_36643[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (7))){
var inst_36177 = (state_36469[(21)]);
var state_36469__$1 = state_36469;
var statearr_36478_36644 = state_36469__$1;
(statearr_36478_36644[(2)] = inst_36177);

(statearr_36478_36644[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (59))){
var inst_36299 = (state_36469[(22)]);
var inst_36301 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_36302 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36301,inst_36299);
var state_36469__$1 = state_36469;
var statearr_36479_36645 = state_36469__$1;
(statearr_36479_36645[(2)] = inst_36302);

(statearr_36479_36645[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (86))){
var inst_36196 = (state_36469[(7)]);
var inst_36229 = (state_36469[(11)]);
var inst_36233 = (state_36469[(12)]);
var inst_36190 = (state_36469[(13)]);
var inst_36234 = (state_36469[(14)]);
var inst_36207 = (state_36469[(15)]);
var inst_36231 = (state_36469[(17)]);
var inst_36228 = (state_36469[(18)]);
var inst_36232 = (state_36469[(19)]);
var inst_36385 = (state_36469[(23)]);
var inst_36367 = (state_36469[(24)]);
var inst_36230 = (state_36469[(20)]);
var inst_36387 = (function (){var map__36173 = inst_36228;
var p = inst_36234;
var pred_spec__$1 = inst_36190;
var orderBy = inst_36232;
var children = inst_36367;
var multi_QMARK_ = inst_36229;
var limit = inst_36231;
var offset = inst_36233;
var k = inst_36207;
var pred_spec_SINGLEQUOTE_ = inst_36196;
var G__36379 = inst_36385;
var ref_QMARK_ = inst_36230;
return (function (n){
var G__36480 = db;
var G__36481 = cache;
var G__36482 = fuel;
var G__36483 = max_fuel;
var G__36484 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__36485 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__36480,G__36481,G__36482,G__36483,G__36484,G__36485) : fluree.db.query.fql.flakes__GT_res.call(null,G__36480,G__36481,G__36482,G__36483,G__36484,G__36485));
});
})();
var inst_36388 = (inst_36387.cljs$core$IFn$_invoke$arity$1 ? inst_36387.cljs$core$IFn$_invoke$arity$1(inst_36385) : inst_36387.call(null,inst_36385));
var state_36469__$1 = state_36469;
var statearr_36486_36646 = state_36469__$1;
(statearr_36486_36646[(2)] = inst_36388);

(statearr_36486_36646[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (20))){
var inst_36205 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36487_36647 = state_36469__$1;
(statearr_36487_36647[(2)] = inst_36205);

(statearr_36487_36647[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (72))){
var inst_36196 = (state_36469[(7)]);
var inst_36351 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = state_36469;
var statearr_36488_36648 = state_36469__$1;
(statearr_36488_36648[(2)] = inst_36351);

(statearr_36488_36648[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (58))){
var inst_36298 = (state_36469[(2)]);
var inst_36299 = fluree.db.util.async.throw_err(inst_36298);
var state_36469__$1 = (function (){var statearr_36489 = state_36469;
(statearr_36489[(22)] = inst_36299);

return statearr_36489;
})();
if(cljs.core.truth_(fuel)){
var statearr_36490_36649 = state_36469__$1;
(statearr_36490_36649[(1)] = (59));

} else {
var statearr_36491_36650 = state_36469__$1;
(statearr_36491_36650[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (60))){
var inst_36299 = (state_36469[(22)]);
var state_36469__$1 = state_36469;
var statearr_36492_36651 = state_36469__$1;
(statearr_36492_36651[(2)] = inst_36299);

(statearr_36492_36651[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (27))){
var inst_36196 = (state_36469[(7)]);
var inst_36225 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36196);
var state_36469__$1 = state_36469;
var statearr_36493_36652 = state_36469__$1;
(statearr_36493_36652[(2)] = inst_36225);

(statearr_36493_36652[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (1))){
var state_36469__$1 = state_36469;
var statearr_36494_36653 = state_36469__$1;
(statearr_36494_36653[(2)] = null);

(statearr_36494_36653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (69))){
var inst_36196 = (state_36469[(7)]);
var inst_36330 = flake.o;
var inst_36331 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36196);
var inst_36332 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_36330,inst_36331);
var state_36469__$1 = state_36469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36469__$1,(71),inst_36332);
} else {
if((state_val_36470 === (101))){
var inst_36207 = (state_36469[(15)]);
var inst_36430 = (state_36469[(25)]);
var inst_36429 = (state_36469[(26)]);
var inst_36449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_36207,inst_36429);
var inst_36451 = [inst_36450,inst_36430];
var inst_36452 = (new cljs.core.PersistentVector(null,2,(5),inst_36449,inst_36451,null));
var state_36469__$1 = state_36469;
var statearr_36495_36654 = state_36469__$1;
(statearr_36495_36654[(2)] = inst_36452);

(statearr_36495_36654[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (24))){
var state_36469__$1 = state_36469;
var statearr_36496_36655 = state_36469__$1;
(statearr_36496_36655[(2)] = true);

(statearr_36496_36655[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (102))){
var state_36469__$1 = state_36469;
var statearr_36497_36656 = state_36469__$1;
(statearr_36497_36656[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (55))){
var inst_36196 = (state_36469[(7)]);
var inst_36318 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36318)){
var statearr_36499_36657 = state_36469__$1;
(statearr_36499_36657[(1)] = (65));

} else {
var statearr_36500_36658 = state_36469__$1;
(statearr_36500_36658[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (85))){
var inst_36385 = (state_36469[(2)]);
var state_36469__$1 = (function (){var statearr_36501 = state_36469;
(statearr_36501[(23)] = inst_36385);

return statearr_36501;
})();
var statearr_36502_36659 = state_36469__$1;
(statearr_36502_36659[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (39))){
var inst_36234 = (state_36469[(14)]);
var inst_36251 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_36234,cljs.core.dec);
var state_36469__$1 = state_36469;
var statearr_36504_36660 = state_36469__$1;
(statearr_36504_36660[(2)] = inst_36251);

(statearr_36504_36660[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (88))){
var inst_36391 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36469__$1,(82),inst_36391);
} else {
if((state_val_36470 === (46))){
var inst_36274 = cljs.core.not(recur_QMARK_);
var state_36469__$1 = state_36469;
if(inst_36274){
var statearr_36505_36661 = state_36469__$1;
(statearr_36505_36661[(1)] = (48));

} else {
var statearr_36506_36662 = state_36469__$1;
(statearr_36506_36662[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (4))){
var inst_36167 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36507_36663 = state_36469__$1;
(statearr_36507_36663[(2)] = inst_36167);

(statearr_36507_36663[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (77))){
var inst_36420 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36508_36664 = state_36469__$1;
(statearr_36508_36664[(2)] = inst_36420);

(statearr_36508_36664[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (106))){
var inst_36460 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36509_36665 = state_36469__$1;
(statearr_36509_36665[(2)] = inst_36460);

(statearr_36509_36665[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (95))){
var inst_36229 = (state_36469[(11)]);
var state_36469__$1 = state_36469;
var statearr_36510_36666 = state_36469__$1;
(statearr_36510_36666[(2)] = inst_36229);

(statearr_36510_36666[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (54))){
var inst_36196 = (state_36469[(7)]);
var inst_36286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36287 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_36288 = (new cljs.core.PersistentVector(null,3,(5),inst_36286,inst_36287,null));
var inst_36289 = cljs.core.select_keys(inst_36196,inst_36288);
var inst_36290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36293 = flake.o;
var inst_36294 = [inst_36293];
var inst_36295 = (new cljs.core.PersistentVector(null,1,(5),inst_36292,inst_36294,null));
var inst_36296 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36295);
var state_36469__$1 = (function (){var statearr_36511 = state_36469;
(statearr_36511[(27)] = inst_36290);

(statearr_36511[(16)] = inst_36289);

return statearr_36511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36469__$1,(58),inst_36296);
} else {
if((state_val_36470 === (92))){
var inst_36410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36411 = flake.o;
var inst_36412 = [inst_36411,offset_map];
var inst_36413 = (new cljs.core.PersistentVector(null,2,(5),inst_36410,inst_36412,null));
var state_36469__$1 = state_36469;
var statearr_36512_36667 = state_36469__$1;
(statearr_36512_36667[(2)] = inst_36413);

(statearr_36512_36667[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (104))){
var inst_36430 = (state_36469[(25)]);
var inst_36455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36456 = [acc,inst_36430];
var inst_36457 = (new cljs.core.PersistentVector(null,2,(5),inst_36455,inst_36456,null));
var state_36469__$1 = state_36469;
var statearr_36513_36668 = state_36469__$1;
(statearr_36513_36668[(2)] = inst_36457);

(statearr_36513_36668[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (15))){
var inst_36197 = (state_36469[(28)]);
var state_36469__$1 = state_36469;
var statearr_36514_36669 = state_36469__$1;
(statearr_36514_36669[(2)] = inst_36197);

(statearr_36514_36669[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (48))){
var inst_36196 = (state_36469[(7)]);
var inst_36276 = (state_36469[(29)]);
var inst_36276__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = (function (){var statearr_36515 = state_36469;
(statearr_36515[(29)] = inst_36276__$1);

return statearr_36515;
})();
if(cljs.core.truth_(inst_36276__$1)){
var statearr_36516_36670 = state_36469__$1;
(statearr_36516_36670[(1)] = (51));

} else {
var statearr_36517_36671 = state_36469__$1;
(statearr_36517_36671[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (50))){
var inst_36284 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36284)){
var statearr_36518_36672 = state_36469__$1;
(statearr_36518_36672[(1)] = (54));

} else {
var statearr_36519_36673 = state_36469__$1;
(statearr_36519_36673[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (75))){
var inst_36196 = (state_36469[(7)]);
var inst_36356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36357 = flake.o;
var inst_36358 = [inst_36357];
var inst_36359 = (new cljs.core.PersistentVector(null,1,(5),inst_36356,inst_36358,null));
var inst_36360 = [cljs.core.cst$kw$limit];
var inst_36361 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_36196);
var inst_36362 = [inst_36361];
var inst_36363 = cljs.core.PersistentHashMap.fromArrays(inst_36360,inst_36362);
var inst_36364 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36359,inst_36363);
var state_36469__$1 = state_36469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36469__$1,(78),inst_36364);
} else {
if((state_val_36470 === (99))){
var inst_36429 = (state_36469[(26)]);
var inst_36446 = (inst_36429 == null);
var inst_36447 = cljs.core.not(inst_36446);
var state_36469__$1 = state_36469;
if(inst_36447){
var statearr_36520_36674 = state_36469__$1;
(statearr_36520_36674[(1)] = (101));

} else {
var statearr_36521_36675 = state_36469__$1;
(statearr_36521_36675[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (21))){
var inst_36196 = (state_36469[(7)]);
var inst_36212 = inst_36196.cljs$lang$protocol_mask$partition0$;
var inst_36213 = (inst_36212 & (64));
var inst_36214 = inst_36196.cljs$core$ISeq$;
var inst_36215 = (cljs.core.PROTOCOL_SENTINEL === inst_36214);
var inst_36216 = ((inst_36213) || (inst_36215));
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36216)){
var statearr_36522_36676 = state_36469__$1;
(statearr_36522_36676[(1)] = (24));

} else {
var statearr_36523_36677 = state_36469__$1;
(statearr_36523_36677[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (31))){
var inst_36229 = (state_36469[(11)]);
var state_36469__$1 = state_36469;
var statearr_36524_36678 = state_36469__$1;
(statearr_36524_36678[(2)] = inst_36229);

(statearr_36524_36678[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (32))){
var inst_36246 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36246)){
var statearr_36525_36679 = state_36469__$1;
(statearr_36525_36679[(1)] = (36));

} else {
var statearr_36526_36680 = state_36469__$1;
(statearr_36526_36680[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (40))){
var inst_36233 = (state_36469[(12)]);
var inst_36234 = (state_36469[(14)]);
var inst_36253 = (inst_36233 - (1));
var inst_36254 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_36234,inst_36253);
var state_36469__$1 = state_36469;
var statearr_36527_36681 = state_36469__$1;
(statearr_36527_36681[(2)] = inst_36254);

(statearr_36527_36681[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (91))){
var inst_36418 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36528_36682 = state_36469__$1;
(statearr_36528_36682[(2)] = inst_36418);

(statearr_36528_36682[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (56))){
var inst_36424 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36529_36683 = state_36469__$1;
(statearr_36529_36683[(2)] = inst_36424);

(statearr_36529_36683[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (33))){
var inst_36233 = (state_36469[(12)]);
var inst_36234 = (state_36469[(14)]);
var inst_36237 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36233);
var inst_36238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_36234);
var inst_36239 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_36238);
var inst_36240 = ((inst_36237) && (inst_36239));
var state_36469__$1 = state_36469;
var statearr_36530_36684 = state_36469__$1;
(statearr_36530_36684[(2)] = inst_36240);

(statearr_36530_36684[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (13))){
var inst_36190 = (state_36469[(13)]);
var inst_36194 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36190,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_36469__$1 = state_36469;
var statearr_36531_36685 = state_36469__$1;
(statearr_36531_36685[(2)] = inst_36194);

(statearr_36531_36685[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (22))){
var state_36469__$1 = state_36469;
var statearr_36532_36686 = state_36469__$1;
(statearr_36532_36686[(2)] = false);

(statearr_36532_36686[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (90))){
var state_36469__$1 = state_36469;
var statearr_36533_36687 = state_36469__$1;
(statearr_36533_36687[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (36))){
var inst_36234 = (state_36469[(14)]);
var inst_36248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_36234);
var state_36469__$1 = (function (){var statearr_36535 = state_36469;
(statearr_36535[(30)] = inst_36248);

return statearr_36535;
})();
if(cljs.core.truth_(inst_36249)){
var statearr_36536_36688 = state_36469__$1;
(statearr_36536_36688[(1)] = (39));

} else {
var statearr_36537_36689 = state_36469__$1;
(statearr_36537_36689[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (41))){
var inst_36248 = (state_36469[(30)]);
var inst_36256 = (state_36469[(2)]);
var inst_36257 = [null,inst_36256];
var inst_36258 = (new cljs.core.PersistentVector(null,2,(5),inst_36248,inst_36257,null));
var state_36469__$1 = state_36469;
var statearr_36538_36690 = state_36469__$1;
(statearr_36538_36690[(2)] = inst_36258);

(statearr_36538_36690[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (89))){
var inst_36401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36402 = ["_id"];
var inst_36403 = flake.o;
var inst_36404 = [inst_36403];
var inst_36405 = cljs.core.PersistentHashMap.fromArrays(inst_36402,inst_36404);
var inst_36406 = [inst_36405,offset_map];
var inst_36407 = (new cljs.core.PersistentVector(null,2,(5),inst_36401,inst_36406,null));
var state_36469__$1 = state_36469;
var statearr_36539_36691 = state_36469__$1;
(statearr_36539_36691[(2)] = inst_36407);

(statearr_36539_36691[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (100))){
var inst_36464 = (state_36469[(2)]);
var _ = (function (){var statearr_36540 = state_36469;
(statearr_36540[(4)] = cljs.core.rest((state_36469[(4)])));

return statearr_36540;
})();
var state_36469__$1 = state_36469;
var statearr_36541_36692 = state_36469__$1;
(statearr_36541_36692[(2)] = inst_36464);

(statearr_36541_36692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (43))){
var inst_36229 = (state_36469[(11)]);
var state_36469__$1 = state_36469;
var statearr_36542_36693 = state_36469__$1;
(statearr_36542_36693[(2)] = inst_36229);

(statearr_36542_36693[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (61))){
var inst_36305 = (state_36469[(2)]);
var state_36469__$1 = (function (){var statearr_36543 = state_36469;
(statearr_36543[(10)] = inst_36305);

return statearr_36543;
})();
var statearr_36544_36694 = state_36469__$1;
(statearr_36544_36694[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (29))){
var inst_36229 = (state_36469[(11)]);
var inst_36228 = (state_36469[(18)]);
var inst_36228__$1 = (state_36469[(2)]);
var inst_36229__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_36230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_36231 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$limit);
var inst_36232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$orderBy);
var inst_36233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$offset);
var inst_36234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36228__$1,cljs.core.cst$kw$p);
var state_36469__$1 = (function (){var statearr_36546 = state_36469;
(statearr_36546[(11)] = inst_36229__$1);

(statearr_36546[(12)] = inst_36233);

(statearr_36546[(14)] = inst_36234);

(statearr_36546[(17)] = inst_36231);

(statearr_36546[(18)] = inst_36228__$1);

(statearr_36546[(19)] = inst_36232);

(statearr_36546[(20)] = inst_36230);

return statearr_36546;
})();
if(cljs.core.truth_(inst_36229__$1)){
var statearr_36547_36695 = state_36469__$1;
(statearr_36547_36695[(1)] = (30));

} else {
var statearr_36548_36696 = state_36469__$1;
(statearr_36548_36696[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (44))){
var inst_36268 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36268)){
var statearr_36549_36697 = state_36469__$1;
(statearr_36549_36697[(1)] = (45));

} else {
var statearr_36550_36698 = state_36469__$1;
(statearr_36550_36698[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (93))){
var state_36469__$1 = state_36469;
var statearr_36551_36699 = state_36469__$1;
(statearr_36551_36699[(2)] = null);

(statearr_36551_36699[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (6))){
var inst_36179 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36180 = (inst_36179 == null);
var state_36469__$1 = state_36469;
var statearr_36552_36700 = state_36469__$1;
(statearr_36552_36700[(2)] = inst_36180);

(statearr_36552_36700[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (28))){
var inst_36196 = (state_36469[(7)]);
var state_36469__$1 = state_36469;
var statearr_36553_36701 = state_36469__$1;
(statearr_36553_36701[(2)] = inst_36196);

(statearr_36553_36701[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (64))){
var inst_36311 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36469__$1,(57),inst_36311);
} else {
if((state_val_36470 === (103))){
var inst_36462 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36554_36702 = state_36469__$1;
(statearr_36554_36702[(2)] = inst_36462);

(statearr_36554_36702[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (51))){
var inst_36276 = (state_36469[(29)]);
var state_36469__$1 = state_36469;
var statearr_36555_36703 = state_36469__$1;
(statearr_36555_36703[(2)] = inst_36276);

(statearr_36555_36703[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (25))){
var state_36469__$1 = state_36469;
var statearr_36556_36704 = state_36469__$1;
(statearr_36556_36704[(2)] = false);

(statearr_36556_36704[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (34))){
var inst_36233 = (state_36469[(12)]);
var state_36469__$1 = state_36469;
var statearr_36557_36705 = state_36469__$1;
(statearr_36557_36705[(2)] = inst_36233);

(statearr_36557_36705[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (17))){
var inst_36196 = (state_36469[(7)]);
var inst_36207 = (state_36469[(2)]);
var inst_36209 = (inst_36196 == null);
var inst_36210 = cljs.core.not(inst_36209);
var state_36469__$1 = (function (){var statearr_36558 = state_36469;
(statearr_36558[(15)] = inst_36207);

return statearr_36558;
})();
if(inst_36210){
var statearr_36559_36706 = state_36469__$1;
(statearr_36559_36706[(1)] = (21));

} else {
var statearr_36560_36707 = state_36469__$1;
(statearr_36560_36707[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (3))){
var inst_36467 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36469__$1,inst_36467);
} else {
if((state_val_36470 === (12))){
var inst_36190 = (state_36469[(13)]);
var state_36469__$1 = state_36469;
var statearr_36561_36708 = state_36469__$1;
(statearr_36561_36708[(2)] = inst_36190);

(statearr_36561_36708[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (2))){
var inst_36177 = (state_36469[(21)]);
var _ = (function (){var statearr_36562 = state_36469;
(statearr_36562[(4)] = cljs.core.cons((5),(state_36469[(4)])));

return statearr_36562;
})();
var inst_36177__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_36469__$1 = (function (){var statearr_36563 = state_36469;
(statearr_36563[(21)] = inst_36177__$1);

return statearr_36563;
})();
if(cljs.core.truth_(inst_36177__$1)){
var statearr_36564_36709 = state_36469__$1;
(statearr_36564_36709[(1)] = (6));

} else {
var statearr_36565_36710 = state_36469__$1;
(statearr_36565_36710[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (66))){
var inst_36349 = (state_36469[(31)]);
var inst_36349__$1 = componentFollow_QMARK_;
var state_36469__$1 = (function (){var statearr_36566 = state_36469;
(statearr_36566[(31)] = inst_36349__$1);

return statearr_36566;
})();
if(cljs.core.truth_(inst_36349__$1)){
var statearr_36567_36711 = state_36469__$1;
(statearr_36567_36711[(1)] = (72));

} else {
var statearr_36568_36712 = state_36469__$1;
(statearr_36568_36712[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (23))){
var inst_36223 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36223)){
var statearr_36569_36713 = state_36469__$1;
(statearr_36569_36713[(1)] = (27));

} else {
var statearr_36570_36714 = state_36469__$1;
(statearr_36570_36714[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (47))){
var inst_36426 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36571_36715 = state_36469__$1;
(statearr_36571_36715[(2)] = inst_36426);

(statearr_36571_36715[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (35))){
var inst_36243 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36572_36716 = state_36469__$1;
(statearr_36572_36716[(2)] = inst_36243);

(statearr_36572_36716[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (82))){
var inst_36378 = (state_36469[(32)]);
var inst_36393 = (state_36469[(2)]);
var inst_36394 = fluree.db.util.async.throw_err(inst_36393);
var inst_36395 = [inst_36394,offset_map];
var inst_36396 = (new cljs.core.PersistentVector(null,2,(5),inst_36378,inst_36395,null));
var state_36469__$1 = state_36469;
var statearr_36573_36717 = state_36469__$1;
(statearr_36573_36717[(2)] = inst_36396);

(statearr_36573_36717[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (76))){
var inst_36230 = (state_36469[(20)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36230)){
var statearr_36574_36718 = state_36469__$1;
(statearr_36574_36718[(1)] = (89));

} else {
var statearr_36575_36719 = state_36469__$1;
(statearr_36575_36719[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (97))){
var inst_36436 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36436)){
var statearr_36576_36720 = state_36469__$1;
(statearr_36576_36720[(1)] = (98));

} else {
var statearr_36577_36721 = state_36469__$1;
(statearr_36577_36721[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (19))){
var inst_36196 = (state_36469[(7)]);
var inst_36203 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = state_36469;
var statearr_36578_36722 = state_36469__$1;
(statearr_36578_36722[(2)] = inst_36203);

(statearr_36578_36722[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (57))){
var inst_36290 = (state_36469[(27)]);
var inst_36313 = (state_36469[(2)]);
var inst_36314 = fluree.db.util.async.throw_err(inst_36313);
var inst_36315 = [inst_36314,offset_map];
var inst_36316 = (new cljs.core.PersistentVector(null,2,(5),inst_36290,inst_36315,null));
var state_36469__$1 = state_36469;
var statearr_36579_36723 = state_36469__$1;
(statearr_36579_36723[(2)] = inst_36316);

(statearr_36579_36723[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (68))){
var inst_36327 = (state_36469[(8)]);
var state_36469__$1 = state_36469;
var statearr_36580_36724 = state_36469__$1;
(statearr_36580_36724[(2)] = inst_36327);

(statearr_36580_36724[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (11))){
var inst_36190 = (state_36469[(13)]);
var inst_36190__$1 = (state_36469[(2)]);
var inst_36191 = cljs.core.contains_QMARK_(inst_36190__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_36469__$1 = (function (){var statearr_36582 = state_36469;
(statearr_36582[(13)] = inst_36190__$1);

return statearr_36582;
})();
if(inst_36191){
var statearr_36583_36725 = state_36469__$1;
(statearr_36583_36725[(1)] = (12));

} else {
var statearr_36584_36726 = state_36469__$1;
(statearr_36584_36726[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (9))){
var inst_36185 = flake.p;
var inst_36186 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_36187 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_36185,inst_36186);
var state_36469__$1 = state_36469;
var statearr_36585_36727 = state_36469__$1;
(statearr_36585_36727[(2)] = inst_36187);

(statearr_36585_36727[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (5))){
var _ = (function (){var statearr_36586 = state_36469;
(statearr_36586[(4)] = cljs.core.rest((state_36469[(4)])));

return statearr_36586;
})();
var state_36469__$1 = state_36469;
var ex36581 = (state_36469__$1[(2)]);
var statearr_36587_36728 = state_36469__$1;
(statearr_36587_36728[(5)] = ex36581);


if((ex36581 instanceof Error)){
var statearr_36588_36729 = state_36469__$1;
(statearr_36588_36729[(1)] = (4));

(statearr_36588_36729[(5)] = null);

} else {
throw ex36581;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (83))){
var inst_36367 = (state_36469[(24)]);
var inst_36381 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_36382 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36381,inst_36367);
var state_36469__$1 = state_36469;
var statearr_36589_36730 = state_36469__$1;
(statearr_36589_36730[(2)] = inst_36382);

(statearr_36589_36730[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (14))){
var inst_36196 = (state_36469[(7)]);
var inst_36197 = (state_36469[(28)]);
var inst_36196__$1 = (state_36469[(2)]);
var inst_36197__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_36196__$1);
var state_36469__$1 = (function (){var statearr_36590 = state_36469;
(statearr_36590[(7)] = inst_36196__$1);

(statearr_36590[(28)] = inst_36197__$1);

return statearr_36590;
})();
if(cljs.core.truth_(inst_36197__$1)){
var statearr_36591_36731 = state_36469__$1;
(statearr_36591_36731[(1)] = (15));

} else {
var statearr_36592_36732 = state_36469__$1;
(statearr_36592_36732[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (45))){
var inst_36270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36271 = [null,offset_map];
var inst_36272 = (new cljs.core.PersistentVector(null,2,(5),inst_36270,inst_36271,null));
var state_36469__$1 = state_36469;
var statearr_36593_36733 = state_36469__$1;
(statearr_36593_36733[(2)] = inst_36272);

(statearr_36593_36733[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (53))){
var inst_36281 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36594_36734 = state_36469__$1;
(statearr_36594_36734[(2)] = inst_36281);

(statearr_36594_36734[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (78))){
var inst_36367 = (state_36469[(24)]);
var inst_36366 = (state_36469[(2)]);
var inst_36367__$1 = fluree.db.util.async.throw_err(inst_36366);
var inst_36368 = cljs.core.empty_QMARK_(inst_36367__$1);
var state_36469__$1 = (function (){var statearr_36595 = state_36469;
(statearr_36595[(24)] = inst_36367__$1);

return statearr_36595;
})();
if(inst_36368){
var statearr_36596_36735 = state_36469__$1;
(statearr_36596_36735[(1)] = (79));

} else {
var statearr_36597_36736 = state_36469__$1;
(statearr_36597_36736[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (26))){
var inst_36220 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36598_36737 = state_36469__$1;
(statearr_36598_36737[(2)] = inst_36220);

(statearr_36598_36737[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (16))){
var inst_36196 = (state_36469[(7)]);
var inst_36200 = (state_36469[(33)]);
var inst_36200__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = (function (){var statearr_36599 = state_36469;
(statearr_36599[(33)] = inst_36200__$1);

return statearr_36599;
})();
if(cljs.core.truth_(inst_36200__$1)){
var statearr_36600_36738 = state_36469__$1;
(statearr_36600_36738[(1)] = (18));

} else {
var statearr_36601_36739 = state_36469__$1;
(statearr_36601_36739[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (81))){
var inst_36398 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36602_36740 = state_36469__$1;
(statearr_36602_36740[(2)] = inst_36398);

(statearr_36602_36740[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (79))){
var inst_36370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36371 = ["_id"];
var inst_36372 = flake.o;
var inst_36373 = [inst_36372];
var inst_36374 = cljs.core.PersistentHashMap.fromArrays(inst_36371,inst_36373);
var inst_36375 = [inst_36374,offset_map];
var inst_36376 = (new cljs.core.PersistentVector(null,2,(5),inst_36370,inst_36375,null));
var state_36469__$1 = state_36469;
var statearr_36603_36741 = state_36469__$1;
(statearr_36603_36741[(2)] = inst_36376);

(statearr_36603_36741[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (38))){
var inst_36429 = (state_36469[(26)]);
var inst_36428 = (state_36469[(2)]);
var inst_36429__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36428,(0),null);
var inst_36430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36428,(1),null);
var inst_36431 = (inst_36429__$1 == null);
var inst_36432 = cljs.core.not(inst_36431);
var state_36469__$1 = (function (){var statearr_36604 = state_36469;
(statearr_36604[(25)] = inst_36430);

(statearr_36604[(26)] = inst_36429__$1);

return statearr_36604;
})();
if(inst_36432){
var statearr_36605_36742 = state_36469__$1;
(statearr_36605_36742[(1)] = (95));

} else {
var statearr_36606_36743 = state_36469__$1;
(statearr_36606_36743[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (98))){
var inst_36207 = (state_36469[(15)]);
var inst_36430 = (state_36469[(25)]);
var inst_36429 = (state_36469[(26)]);
var inst_36438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36439 = cljs.core.PersistentVector.EMPTY;
var inst_36440 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_36207,inst_36439);
var inst_36441 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36440,inst_36429);
var inst_36442 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_36207,inst_36441);
var inst_36443 = [inst_36442,inst_36430];
var inst_36444 = (new cljs.core.PersistentVector(null,2,(5),inst_36438,inst_36443,null));
var state_36469__$1 = state_36469;
var statearr_36607_36744 = state_36469__$1;
(statearr_36607_36744[(2)] = inst_36444);

(statearr_36607_36744[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (87))){
var inst_36385 = (state_36469[(23)]);
var state_36469__$1 = state_36469;
var statearr_36608_36745 = state_36469__$1;
(statearr_36608_36745[(2)] = inst_36385);

(statearr_36608_36745[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (30))){
var inst_36233 = (state_36469[(12)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36233)){
var statearr_36609_36746 = state_36469__$1;
(statearr_36609_36746[(1)] = (33));

} else {
var statearr_36610_36747 = state_36469__$1;
(statearr_36610_36747[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (73))){
var inst_36349 = (state_36469[(31)]);
var state_36469__$1 = state_36469;
var statearr_36611_36748 = state_36469__$1;
(statearr_36611_36748[(2)] = inst_36349);

(statearr_36611_36748[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (96))){
var state_36469__$1 = state_36469;
var statearr_36612_36749 = state_36469__$1;
(statearr_36612_36749[(2)] = false);

(statearr_36612_36749[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (10))){
var state_36469__$1 = state_36469;
var statearr_36613_36750 = state_36469__$1;
(statearr_36613_36750[(2)] = pred_spec);

(statearr_36613_36750[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (18))){
var inst_36200 = (state_36469[(33)]);
var state_36469__$1 = state_36469;
var statearr_36614_36751 = state_36469__$1;
(statearr_36614_36751[(2)] = inst_36200);

(statearr_36614_36751[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (105))){
var state_36469__$1 = state_36469;
var statearr_36615_36752 = state_36469__$1;
(statearr_36615_36752[(2)] = null);

(statearr_36615_36752[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (52))){
var inst_36196 = (state_36469[(7)]);
var inst_36279 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_36196);
var state_36469__$1 = state_36469;
var statearr_36616_36753 = state_36469__$1;
(statearr_36616_36753[(2)] = inst_36279);

(statearr_36616_36753[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (67))){
var inst_36422 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36617_36754 = state_36469__$1;
(statearr_36617_36754[(2)] = inst_36422);

(statearr_36617_36754[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (71))){
var inst_36196 = (state_36469[(7)]);
var inst_36334 = (state_36469[(2)]);
var inst_36335 = fluree.db.util.async.throw_err(inst_36334);
var inst_36336 = cljs.core._deref(cache);
var inst_36337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36338 = flake.o;
var inst_36339 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_36196);
var inst_36340 = [inst_36338,inst_36339];
var inst_36341 = (new cljs.core.PersistentVector(null,2,(5),inst_36337,inst_36340,null));
var inst_36342 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36336,inst_36341,inst_36335);
var inst_36343 = cljs.core._vreset_BANG_(cache,inst_36342);
var state_36469__$1 = (function (){var statearr_36618 = state_36469;
(statearr_36618[(34)] = inst_36343);

return statearr_36618;
})();
var statearr_36619_36755 = state_36469__$1;
(statearr_36619_36755[(2)] = inst_36335);

(statearr_36619_36755[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (42))){
var inst_36207 = (state_36469[(15)]);
var inst_36231 = (state_36469[(17)]);
var inst_36232 = (state_36469[(19)]);
var inst_36261 = cljs.core.not(inst_36232);
var inst_36262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_36207);
var inst_36263 = cljs.core.count(inst_36262);
var inst_36264 = (inst_36263 >= inst_36231);
var inst_36265 = ((inst_36261) && (inst_36264));
var state_36469__$1 = state_36469;
var statearr_36620_36756 = state_36469__$1;
(statearr_36620_36756[(2)] = inst_36265);

(statearr_36620_36756[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (80))){
var inst_36378 = cljs.core.PersistentVector.EMPTY_NODE;
var state_36469__$1 = (function (){var statearr_36621 = state_36469;
(statearr_36621[(32)] = inst_36378);

return statearr_36621;
})();
if(cljs.core.truth_(fuel)){
var statearr_36622_36757 = state_36469__$1;
(statearr_36622_36757[(1)] = (83));

} else {
var statearr_36623_36758 = state_36469__$1;
(statearr_36623_36758[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (37))){
var inst_36229 = (state_36469[(11)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36229)){
var statearr_36624_36759 = state_36469__$1;
(statearr_36624_36759[(1)] = (42));

} else {
var statearr_36625_36760 = state_36469__$1;
(statearr_36625_36760[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (63))){
var inst_36305 = (state_36469[(10)]);
var state_36469__$1 = state_36469;
var statearr_36626_36761 = state_36469__$1;
(statearr_36626_36761[(2)] = inst_36305);

(statearr_36626_36761[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (94))){
var inst_36416 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
var statearr_36627_36762 = state_36469__$1;
(statearr_36627_36762[(2)] = inst_36416);

(statearr_36627_36762[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (8))){
var inst_36183 = (state_36469[(2)]);
var state_36469__$1 = state_36469;
if(cljs.core.truth_(inst_36183)){
var statearr_36628_36763 = state_36469__$1;
(statearr_36628_36763[(1)] = (9));

} else {
var statearr_36629_36764 = state_36469__$1;
(statearr_36629_36764[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (49))){
var state_36469__$1 = state_36469;
var statearr_36630_36765 = state_36469__$1;
(statearr_36630_36765[(2)] = false);

(statearr_36630_36765[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36470 === (84))){
var inst_36367 = (state_36469[(24)]);
var state_36469__$1 = state_36469;
var statearr_36631_36766 = state_36469__$1;
(statearr_36631_36766[(2)] = inst_36367);

(statearr_36631_36766[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_36632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36632[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_36632[(1)] = (1));

return statearr_36632;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_36469){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36469);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e36633){var ex__16304__auto__ = e36633;
var statearr_36634_36767 = state_36469;
(statearr_36634_36767[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36469[(4)]))){
var statearr_36635_36768 = state_36469;
(statearr_36635_36768[(1)] = cljs.core.first((state_36469[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__36769 = state_36469;
state_36469 = G__36769;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_36469){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_36469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_36636 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_36636[(6)] = c__16375__auto__);

return statearr_36636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_36949){
var state_val_36950 = (state_36949[(1)]);
if((state_val_36950 === (7))){
var inst_36944 = (state_36949[(2)]);
var _ = (function (){var statearr_36951 = state_36949;
(statearr_36951[(4)] = cljs.core.rest((state_36949[(4)])));

return statearr_36951;
})();
var state_36949__$1 = state_36949;
var statearr_36952_37047 = state_36949__$1;
(statearr_36952_37047[(2)] = inst_36944);

(statearr_36952_37047[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (59))){
var inst_36830 = (state_36949[(7)]);
var state_36949__$1 = state_36949;
var statearr_36953_37048 = state_36949__$1;
(statearr_36953_37048[(2)] = inst_36830);

(statearr_36953_37048[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (20))){
var inst_36839 = (state_36949[(8)]);
var inst_36836 = (state_36949[(2)]);
var inst_36837 = fluree.db.util.async.throw_err(inst_36836);
var inst_36838 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_36837);
var inst_36839__$1 = cljs.core.not_empty(inst_36838);
var state_36949__$1 = (function (){var statearr_36954 = state_36949;
(statearr_36954[(8)] = inst_36839__$1);

return statearr_36954;
})();
if(cljs.core.truth_(inst_36839__$1)){
var statearr_36955_37049 = state_36949__$1;
(statearr_36955_37049[(1)] = (21));

} else {
var statearr_36956_37050 = state_36949__$1;
(statearr_36956_37050[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (58))){
var inst_36829 = (state_36949[(9)]);
var state_36949__$1 = state_36949;
var statearr_36957_37051 = state_36949__$1;
(statearr_36957_37051[(2)] = inst_36829);

(statearr_36957_37051[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (60))){
var inst_36936 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_36958_37052 = state_36949__$1;
(statearr_36958_37052[(2)] = inst_36936);

(statearr_36958_37052[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (27))){
var inst_36869 = (state_36949[(10)]);
var inst_36861 = (state_36949[(11)]);
var inst_36871 = (state_36949[(12)]);
var inst_36868 = cljs.core.seq(inst_36861);
var inst_36869__$1 = cljs.core.first(inst_36868);
var inst_36870 = cljs.core.next(inst_36868);
var inst_36871__$1 = cljs.core.not(inst_36869__$1);
var state_36949__$1 = (function (){var statearr_36959 = state_36949;
(statearr_36959[(10)] = inst_36869__$1);

(statearr_36959[(12)] = inst_36871__$1);

(statearr_36959[(13)] = inst_36870);

return statearr_36959;
})();
if(inst_36871__$1){
var statearr_36960_37053 = state_36949__$1;
(statearr_36960_37053[(1)] = (29));

} else {
var statearr_36961_37054 = state_36949__$1;
(statearr_36961_37054[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (1))){
var state_36949__$1 = state_36949;
var statearr_36962_37055 = state_36949__$1;
(statearr_36962_37055[(2)] = null);

(statearr_36962_37055[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (24))){
var inst_36839 = (state_36949[(8)]);
var inst_36845 = cljs.core.count(inst_36839);
var inst_36846 = fluree.db.query.fql.add_fuel(fuel,inst_36845,max_fuel);
var state_36949__$1 = state_36949;
var statearr_36963_37056 = state_36949__$1;
(statearr_36963_37056[(2)] = inst_36846);

(statearr_36963_37056[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (55))){
var inst_36828 = (state_36949[(14)]);
var state_36949__$1 = state_36949;
var statearr_36964_37057 = state_36949__$1;
(statearr_36964_37057[(2)] = inst_36828);

(statearr_36964_37057[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (39))){
var inst_36826 = (state_36949[(15)]);
var state_36949__$1 = state_36949;
var statearr_36965_37058 = state_36949__$1;
(statearr_36965_37058[(2)] = inst_36826);

(statearr_36965_37058[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (46))){
var inst_36924 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_36966_37059 = state_36949__$1;
(statearr_36966_37059[(2)] = inst_36924);

(statearr_36966_37059[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (4))){
var inst_36770 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_36967_37060 = state_36949__$1;
(statearr_36967_37060[(2)] = inst_36770);

(statearr_36967_37060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (54))){
var inst_36863 = (state_36949[(16)]);
var inst_36915 = (state_36949[(2)]);
var inst_36916 = fluree.db.util.async.throw_err(inst_36915);
var inst_36917 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36863,inst_36916);
var state_36949__$1 = state_36949;
var statearr_36968_37061 = state_36949__$1;
(statearr_36968_37061[(2)] = inst_36917);

(statearr_36968_37061[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (15))){
var state_36949__$1 = state_36949;
var statearr_36969_37062 = state_36949__$1;
(statearr_36969_37062[(2)] = false);

(statearr_36969_37062[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (48))){
var inst_36863 = (state_36949[(16)]);
var state_36949__$1 = state_36949;
var statearr_36970_37063 = state_36949__$1;
(statearr_36970_37063[(2)] = inst_36863);

(statearr_36970_37063[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (50))){
var inst_36862 = (state_36949[(17)]);
var inst_36870 = (state_36949[(13)]);
var inst_36919 = (state_36949[(2)]);
var inst_36920 = (inst_36862 + (1));
var inst_36861 = inst_36870;
var inst_36862__$1 = inst_36920;
var inst_36863 = inst_36919;
var state_36949__$1 = (function (){var statearr_36971 = state_36949;
(statearr_36971[(11)] = inst_36861);

(statearr_36971[(16)] = inst_36863);

(statearr_36971[(17)] = inst_36862__$1);

return statearr_36971;
})();
var statearr_36972_37064 = state_36949__$1;
(statearr_36972_37064[(2)] = null);

(statearr_36972_37064[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (21))){
var state_36949__$1 = state_36949;
var statearr_36973_37065 = state_36949__$1;
(statearr_36973_37065[(2)] = fuel);

(statearr_36973_37065[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (31))){
var inst_36880 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36880)){
var statearr_36974_37066 = state_36949__$1;
(statearr_36974_37066[(1)] = (35));

} else {
var statearr_36975_37067 = state_36949__$1;
(statearr_36975_37067[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (32))){
var inst_36827 = (state_36949[(18)]);
var inst_36862 = (state_36949[(17)]);
var inst_36875 = (inst_36862 >= inst_36827);
var state_36949__$1 = state_36949;
var statearr_36976_37068 = state_36949__$1;
(statearr_36976_37068[(2)] = inst_36875);

(statearr_36976_37068[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (40))){
var inst_36887 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36887)){
var statearr_36977_37069 = state_36949__$1;
(statearr_36977_37069[(1)] = (41));

} else {
var statearr_36978_37070 = state_36949__$1;
(statearr_36978_37070[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (56))){
var inst_36829 = (state_36949[(9)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36829)){
var statearr_36979_37071 = state_36949__$1;
(statearr_36979_37071[(1)] = (58));

} else {
var statearr_36980_37072 = state_36949__$1;
(statearr_36980_37072[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (33))){
var inst_36827 = (state_36949[(18)]);
var state_36949__$1 = state_36949;
var statearr_36981_37073 = state_36949__$1;
(statearr_36981_37073[(2)] = inst_36827);

(statearr_36981_37073[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (13))){
var inst_36820 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36820)){
var statearr_36982_37074 = state_36949__$1;
(statearr_36982_37074[(1)] = (17));

} else {
var statearr_36983_37075 = state_36949__$1;
(statearr_36983_37075[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (22))){
var inst_36839 = (state_36949[(8)]);
var state_36949__$1 = state_36949;
var statearr_36985_37076 = state_36949__$1;
(statearr_36985_37076[(2)] = inst_36839);

(statearr_36985_37076[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (36))){
var inst_36826 = (state_36949[(15)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36826)){
var statearr_36986_37077 = state_36949__$1;
(statearr_36986_37077[(1)] = (38));

} else {
var statearr_36987_37078 = state_36949__$1;
(statearr_36987_37078[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (41))){
var inst_36863 = (state_36949[(16)]);
var inst_36862 = (state_36949[(17)]);
var inst_36870 = (state_36949[(13)]);
var inst_36889 = (inst_36862 + (1));
var tmp36984 = inst_36863;
var inst_36861 = inst_36870;
var inst_36862__$1 = inst_36889;
var inst_36863__$1 = tmp36984;
var state_36949__$1 = (function (){var statearr_36988 = state_36949;
(statearr_36988[(11)] = inst_36861);

(statearr_36988[(16)] = inst_36863__$1);

(statearr_36988[(17)] = inst_36862__$1);

return statearr_36988;
})();
var statearr_36989_37079 = state_36949__$1;
(statearr_36989_37079[(2)] = null);

(statearr_36989_37079[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (43))){
var inst_36926 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_36990_37080 = state_36949__$1;
(statearr_36990_37080[(2)] = inst_36926);

(statearr_36990_37080[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (29))){
var inst_36871 = (state_36949[(12)]);
var state_36949__$1 = state_36949;
var statearr_36991_37081 = state_36949__$1;
(statearr_36991_37081[(2)] = inst_36871);

(statearr_36991_37081[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (44))){
var inst_36869 = (state_36949[(10)]);
var inst_36893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36894 = [inst_36869];
var inst_36895 = (new cljs.core.PersistentVector(null,1,(5),inst_36893,inst_36894,null));
var inst_36896 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36895);
var state_36949__$1 = state_36949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36949__$1,(47),inst_36896);
} else {
if((state_val_36950 === (6))){
var inst_36794 = (state_36949[(19)]);
var inst_36787 = (state_36949[(20)]);
var inst_36793 = cljs.core.seq(inst_36787);
var inst_36794__$1 = cljs.core.first(inst_36793);
var inst_36795 = cljs.core.next(inst_36793);
var inst_36796 = cljs.core.not(inst_36794__$1);
var state_36949__$1 = (function (){var statearr_36992 = state_36949;
(statearr_36992[(19)] = inst_36794__$1);

(statearr_36992[(21)] = inst_36795);

return statearr_36992;
})();
if(inst_36796){
var statearr_36993_37082 = state_36949__$1;
(statearr_36993_37082[(1)] = (8));

} else {
var statearr_36994_37083 = state_36949__$1;
(statearr_36994_37083[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (28))){
var inst_36828 = (state_36949[(14)]);
var inst_36930 = (state_36949[(2)]);
var state_36949__$1 = (function (){var statearr_36995 = state_36949;
(statearr_36995[(22)] = inst_36930);

return statearr_36995;
})();
if(cljs.core.truth_(inst_36828)){
var statearr_36996_37084 = state_36949__$1;
(statearr_36996_37084[(1)] = (55));

} else {
var statearr_36997_37085 = state_36949__$1;
(statearr_36997_37085[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (51))){
var inst_36899 = (state_36949[(23)]);
var inst_36908 = cljs.core.count(inst_36899);
var inst_36909 = fluree.db.query.fql.add_fuel(fuel,inst_36908,max_fuel);
var state_36949__$1 = state_36949;
var statearr_36998_37086 = state_36949__$1;
(statearr_36998_37086[(2)] = inst_36909);

(statearr_36998_37086[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (25))){
var state_36949__$1 = state_36949;
var statearr_36999_37087 = state_36949__$1;
(statearr_36999_37087[(2)] = null);

(statearr_36999_37087[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (34))){
var inst_36878 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_37000_37088 = state_36949__$1;
(statearr_37000_37088[(2)] = inst_36878);

(statearr_37000_37088[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (17))){
var inst_36804 = (state_36949[(24)]);
var inst_36822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36804);
var state_36949__$1 = state_36949;
var statearr_37001_37089 = state_36949__$1;
(statearr_37001_37089[(2)] = inst_36822);

(statearr_37001_37089[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (3))){
var inst_36947 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36949__$1,inst_36947);
} else {
if((state_val_36950 === (12))){
var state_36949__$1 = state_36949;
var statearr_37002_37090 = state_36949__$1;
(statearr_37002_37090[(2)] = false);

(statearr_37002_37090[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (2))){
var _ = (function (){var statearr_37003 = state_36949;
(statearr_37003[(4)] = cljs.core.cons((5),(state_36949[(4)])));

return statearr_37003;
})();
var inst_36783 = reverse_refs_specs;
var inst_36784 = cljs.core.seq(inst_36783);
var inst_36785 = cljs.core.first(inst_36784);
var inst_36786 = cljs.core.next(inst_36784);
var inst_36787 = inst_36783;
var inst_36788 = null;
var state_36949__$1 = (function (){var statearr_37004 = state_36949;
(statearr_37004[(25)] = inst_36786);

(statearr_37004[(26)] = inst_36785);

(statearr_37004[(27)] = inst_36788);

(statearr_37004[(20)] = inst_36787);

return statearr_37004;
})();
var statearr_37005_37091 = state_36949__$1;
(statearr_37005_37091[(2)] = null);

(statearr_37005_37091[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (23))){
var inst_36843 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36843)){
var statearr_37006_37092 = state_36949__$1;
(statearr_37006_37092[(1)] = (24));

} else {
var statearr_37007_37093 = state_36949__$1;
(statearr_37007_37093[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (47))){
var inst_36804 = (state_36949[(24)]);
var inst_36899 = (state_36949[(23)]);
var inst_36898 = (state_36949[(2)]);
var inst_36899__$1 = fluree.db.util.async.throw_err(inst_36898);
var inst_36900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36901 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_36902 = (new cljs.core.PersistentVector(null,4,(5),inst_36900,inst_36901,null));
var inst_36903 = cljs.core.select_keys(inst_36804,inst_36902);
var inst_36904 = cljs.core.empty_QMARK_(inst_36899__$1);
var state_36949__$1 = (function (){var statearr_37008 = state_36949;
(statearr_37008[(23)] = inst_36899__$1);

(statearr_37008[(28)] = inst_36903);

return statearr_37008;
})();
if(inst_36904){
var statearr_37009_37094 = state_36949__$1;
(statearr_37009_37094[(1)] = (48));

} else {
var statearr_37010_37095 = state_36949__$1;
(statearr_37010_37095[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (35))){
var inst_36863 = (state_36949[(16)]);
var state_36949__$1 = state_36949;
var statearr_37011_37096 = state_36949__$1;
(statearr_37011_37096[(2)] = inst_36863);

(statearr_37011_37096[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (19))){
var inst_36803 = (state_36949[(29)]);
var inst_36825 = (state_36949[(2)]);
var inst_36826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36825,cljs.core.cst$kw$offset);
var inst_36827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36825,cljs.core.cst$kw$limit);
var inst_36828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36825,cljs.core.cst$kw$as);
var inst_36829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36825,cljs.core.cst$kw$name);
var inst_36830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36825,cljs.core.cst$kw$p);
var inst_36831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36832 = [subject_id,inst_36803];
var inst_36833 = (new cljs.core.PersistentVector(null,2,(5),inst_36831,inst_36832,null));
var inst_36834 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_36833);
var state_36949__$1 = (function (){var statearr_37012 = state_36949;
(statearr_37012[(9)] = inst_36829);

(statearr_37012[(18)] = inst_36827);

(statearr_37012[(15)] = inst_36826);

(statearr_37012[(7)] = inst_36830);

(statearr_37012[(14)] = inst_36828);

return statearr_37012;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36949__$1,(20),inst_36834);
} else {
if((state_val_36950 === (57))){
var inst_36930 = (state_36949[(22)]);
var inst_36795 = (state_36949[(21)]);
var inst_36788 = (state_36949[(27)]);
var inst_36938 = (state_36949[(2)]);
var inst_36939 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36788,inst_36938,inst_36930);
var inst_36787 = inst_36795;
var inst_36788__$1 = inst_36939;
var state_36949__$1 = (function (){var statearr_37013 = state_36949;
(statearr_37013[(27)] = inst_36788__$1);

(statearr_37013[(20)] = inst_36787);

return statearr_37013;
})();
var statearr_37014_37097 = state_36949__$1;
(statearr_37014_37097[(2)] = null);

(statearr_37014_37097[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (11))){
var inst_36804 = (state_36949[(24)]);
var inst_36809 = inst_36804.cljs$lang$protocol_mask$partition0$;
var inst_36810 = (inst_36809 & (64));
var inst_36811 = inst_36804.cljs$core$ISeq$;
var inst_36812 = (cljs.core.PROTOCOL_SENTINEL === inst_36811);
var inst_36813 = ((inst_36810) || (inst_36812));
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36813)){
var statearr_37016_37098 = state_36949__$1;
(statearr_37016_37098[(1)] = (14));

} else {
var statearr_37017_37099 = state_36949__$1;
(statearr_37017_37099[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (9))){
var inst_36794 = (state_36949[(19)]);
var inst_36804 = (state_36949[(24)]);
var inst_36803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36794,(0),null);
var inst_36804__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36794,(1),null);
var inst_36806 = (inst_36804__$1 == null);
var inst_36807 = cljs.core.not(inst_36806);
var state_36949__$1 = (function (){var statearr_37018 = state_36949;
(statearr_37018[(29)] = inst_36803);

(statearr_37018[(24)] = inst_36804__$1);

return statearr_37018;
})();
if(inst_36807){
var statearr_37019_37100 = state_36949__$1;
(statearr_37019_37100[(1)] = (11));

} else {
var statearr_37020_37101 = state_36949__$1;
(statearr_37020_37101[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (5))){
var _ = (function (){var statearr_37021 = state_36949;
(statearr_37021[(4)] = cljs.core.rest((state_36949[(4)])));

return statearr_37021;
})();
var state_36949__$1 = state_36949;
var ex37015 = (state_36949__$1[(2)]);
var statearr_37022_37102 = state_36949__$1;
(statearr_37022_37102[(5)] = ex37015);


if((ex37015 instanceof Error)){
var statearr_37023_37103 = state_36949__$1;
(statearr_37023_37103[(1)] = (4));

(statearr_37023_37103[(5)] = null);

} else {
throw ex37015;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (14))){
var state_36949__$1 = state_36949;
var statearr_37024_37104 = state_36949__$1;
(statearr_37024_37104[(2)] = true);

(statearr_37024_37104[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (45))){
var state_36949__$1 = state_36949;
var statearr_37025_37105 = state_36949__$1;
(statearr_37025_37105[(2)] = null);

(statearr_37025_37105[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (53))){
var inst_36899 = (state_36949[(23)]);
var inst_36903 = (state_36949[(28)]);
var inst_36912 = (state_36949[(2)]);
var inst_36913 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_36903,inst_36899) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_36903,inst_36899));
var state_36949__$1 = (function (){var statearr_37026 = state_36949;
(statearr_37026[(30)] = inst_36912);

return statearr_37026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36949__$1,(54),inst_36913);
} else {
if((state_val_36950 === (26))){
var inst_36839 = (state_36949[(8)]);
var inst_36849 = (state_36949[(2)]);
var inst_36857 = cljs.core.seq(inst_36839);
var inst_36858 = cljs.core.first(inst_36857);
var inst_36859 = cljs.core.next(inst_36857);
var inst_36860 = cljs.core.PersistentVector.EMPTY;
var inst_36861 = inst_36839;
var inst_36862 = (0);
var inst_36863 = inst_36860;
var state_36949__$1 = (function (){var statearr_37027 = state_36949;
(statearr_37027[(31)] = inst_36849);

(statearr_37027[(11)] = inst_36861);

(statearr_37027[(16)] = inst_36863);

(statearr_37027[(32)] = inst_36859);

(statearr_37027[(33)] = inst_36858);

(statearr_37027[(17)] = inst_36862);

return statearr_37027;
})();
var statearr_37028_37106 = state_36949__$1;
(statearr_37028_37106[(2)] = null);

(statearr_37028_37106[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (16))){
var inst_36817 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_37029_37107 = state_36949__$1;
(statearr_37029_37107[(2)] = inst_36817);

(statearr_37029_37107[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (38))){
var inst_36826 = (state_36949[(15)]);
var inst_36862 = (state_36949[(17)]);
var inst_36884 = (inst_36862 < inst_36826);
var state_36949__$1 = state_36949;
var statearr_37030_37108 = state_36949__$1;
(statearr_37030_37108[(2)] = inst_36884);

(statearr_37030_37108[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (30))){
var inst_36827 = (state_36949[(18)]);
var state_36949__$1 = state_36949;
if(cljs.core.truth_(inst_36827)){
var statearr_37031_37109 = state_36949__$1;
(statearr_37031_37109[(1)] = (32));

} else {
var statearr_37032_37110 = state_36949__$1;
(statearr_37032_37110[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (10))){
var inst_36942 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_37033_37111 = state_36949__$1;
(statearr_37033_37111[(2)] = inst_36942);

(statearr_37033_37111[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (18))){
var inst_36804 = (state_36949[(24)]);
var state_36949__$1 = state_36949;
var statearr_37034_37112 = state_36949__$1;
(statearr_37034_37112[(2)] = inst_36804);

(statearr_37034_37112[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (52))){
var state_36949__$1 = state_36949;
var statearr_37035_37113 = state_36949__$1;
(statearr_37035_37113[(2)] = null);

(statearr_37035_37113[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (42))){
var state_36949__$1 = state_36949;
var statearr_37036_37114 = state_36949__$1;
(statearr_37036_37114[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (37))){
var inst_36928 = (state_36949[(2)]);
var state_36949__$1 = state_36949;
var statearr_37038_37115 = state_36949__$1;
(statearr_37038_37115[(2)] = inst_36928);

(statearr_37038_37115[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (8))){
var inst_36788 = (state_36949[(27)]);
var state_36949__$1 = state_36949;
var statearr_37039_37116 = state_36949__$1;
(statearr_37039_37116[(2)] = inst_36788);

(statearr_37039_37116[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36950 === (49))){
var state_36949__$1 = state_36949;
if(cljs.core.truth_(fuel)){
var statearr_37040_37117 = state_36949__$1;
(statearr_37040_37117[(1)] = (51));

} else {
var statearr_37041_37118 = state_36949__$1;
(statearr_37041_37118[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0 = (function (){
var statearr_37042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37042[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__);

(statearr_37042[(1)] = (1));

return statearr_37042;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1 = (function (state_36949){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_36949);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37043){var ex__16304__auto__ = e37043;
var statearr_37044_37119 = state_36949;
(statearr_37044_37119[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_36949[(4)]))){
var statearr_37045_37120 = state_36949;
(statearr_37045_37120[(1)] = cljs.core.first((state_36949[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37121 = state_36949;
state_36949 = G__37121;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = function(state_36949){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1.call(this,state_36949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37046 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37046[(6)] = c__16375__auto__);

return statearr_37046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__37122 = select_spec;
var map__37122__$1 = (((((!((map__37122 == null))))?(((((map__37122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37122.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37122):map__37122);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37122__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37122__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37205){
var state_val_37206 = (state_37205[(1)]);
if((state_val_37206 === (7))){
var state_37205__$1 = state_37205;
var statearr_37207_37259 = state_37205__$1;
(statearr_37207_37259[(2)] = false);

(statearr_37207_37259[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (20))){
var inst_37161 = (state_37205[(7)]);
var state_37205__$1 = state_37205;
if(cljs.core.truth_(inst_37161)){
var statearr_37208_37260 = state_37205__$1;
(statearr_37208_37260[(1)] = (22));

} else {
var statearr_37209_37261 = state_37205__$1;
(statearr_37209_37261[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (27))){
var inst_37184 = (state_37205[(8)]);
var inst_37190 = (state_37205[(2)]);
var state_37205__$1 = (function (){var statearr_37210 = state_37205;
(statearr_37210[(9)] = inst_37190);

return statearr_37210;
})();
if(cljs.core.truth_(inst_37184)){
var statearr_37211_37262 = state_37205__$1;
(statearr_37211_37262[(1)] = (28));

} else {
var statearr_37212_37263 = state_37205__$1;
(statearr_37212_37263[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (1))){
var state_37205__$1 = state_37205;
var statearr_37213_37264 = state_37205__$1;
(statearr_37213_37264[(2)] = null);

(statearr_37213_37264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (24))){
var inst_37182 = (state_37205[(2)]);
var state_37205__$1 = state_37205;
var statearr_37214_37265 = state_37205__$1;
(statearr_37214_37265[(2)] = inst_37182);

(statearr_37214_37265[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (4))){
var inst_37124 = (state_37205[(2)]);
var state_37205__$1 = state_37205;
var statearr_37215_37266 = state_37205__$1;
(statearr_37215_37266[(2)] = inst_37124);

(statearr_37215_37266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (15))){
var inst_37168 = (state_37205[(2)]);
var inst_37169 = fluree.db.util.async.throw_err(inst_37168);
var state_37205__$1 = (function (){var statearr_37216 = state_37205;
(statearr_37216[(10)] = inst_37169);

return statearr_37216;
})();
if(cljs.core.truth_(fuel)){
var statearr_37217_37267 = state_37205__$1;
(statearr_37217_37267[(1)] = (16));

} else {
var statearr_37218_37268 = state_37205__$1;
(statearr_37218_37268[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (21))){
var inst_37154 = (state_37205[(11)]);
var inst_37184 = (state_37205[(2)]);
var state_37205__$1 = (function (){var statearr_37219 = state_37205;
(statearr_37219[(8)] = inst_37184);

return statearr_37219;
})();
if(cljs.core.truth_(inst_37154)){
var statearr_37220_37269 = state_37205__$1;
(statearr_37220_37269[(1)] = (25));

} else {
var statearr_37221_37270 = state_37205__$1;
(statearr_37221_37270[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (31))){
var inst_37190 = (state_37205[(9)]);
var inst_37155 = (state_37205[(12)]);
var inst_37196 = (state_37205[(2)]);
var inst_37197 = fluree.db.util.async.throw_err(inst_37196);
var inst_37198 = (inst_37190.cljs$core$IFn$_invoke$arity$3 ? inst_37190.cljs$core$IFn$_invoke$arity$3(acc,inst_37155,inst_37197) : inst_37190.call(null,acc,inst_37155,inst_37197));
var state_37205__$1 = state_37205;
var statearr_37222_37271 = state_37205__$1;
(statearr_37222_37271[(2)] = inst_37198);

(statearr_37222_37271[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (13))){
var inst_37132 = (state_37205[(13)]);
var state_37205__$1 = state_37205;
var statearr_37223_37272 = state_37205__$1;
(statearr_37223_37272[(2)] = inst_37132);

(statearr_37223_37272[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (22))){
var inst_37161 = (state_37205[(7)]);
var state_37205__$1 = state_37205;
var statearr_37224_37273 = state_37205__$1;
(statearr_37224_37273[(2)] = inst_37161);

(statearr_37224_37273[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (29))){
var inst_37175 = (state_37205[(14)]);
var inst_37193 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_37194 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37193,inst_37175) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37193,inst_37175));
var state_37205__$1 = state_37205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37205__$1,(31),inst_37194);
} else {
if((state_val_37206 === (6))){
var inst_37132 = (state_37205[(13)]);
var inst_37137 = inst_37132.cljs$lang$protocol_mask$partition0$;
var inst_37138 = (inst_37137 & (64));
var inst_37139 = inst_37132.cljs$core$ISeq$;
var inst_37140 = (cljs.core.PROTOCOL_SENTINEL === inst_37139);
var inst_37141 = ((inst_37138) || (inst_37140));
var state_37205__$1 = state_37205;
if(cljs.core.truth_(inst_37141)){
var statearr_37225_37274 = state_37205__$1;
(statearr_37225_37274[(1)] = (9));

} else {
var statearr_37226_37275 = state_37205__$1;
(statearr_37226_37275[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (28))){
var state_37205__$1 = state_37205;
var statearr_37227_37276 = state_37205__$1;
(statearr_37227_37276[(2)] = acc);

(statearr_37227_37276[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (25))){
var inst_37159 = (state_37205[(15)]);
var inst_37156 = (state_37205[(16)]);
var inst_37175 = (state_37205[(14)]);
var inst_37160 = (state_37205[(17)]);
var inst_37184 = (state_37205[(8)]);
var inst_37157 = (state_37205[(18)]);
var inst_37153 = (state_37205[(19)]);
var inst_37155 = (state_37205[(12)]);
var inst_37158 = (state_37205[(20)]);
var inst_37154 = (state_37205[(11)]);
var inst_37161 = (state_37205[(7)]);
var inst_37131 = (state_37205[(21)]);
var inst_37186 = (function (){var recur_seen = inst_37157;
var recur_subject = inst_37131;
var sub_flakes = inst_37175;
var seen_QMARK_ = inst_37160;
var multi_QMARK_ = inst_37154;
var limit = inst_37159;
var map__37130 = inst_37153;
var recur_depth = inst_37158;
var as = inst_37155;
var max_depth_QMARK_ = inst_37161;
var recur = inst_37156;
var stop_QMARK_ = inst_37184;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_37205__$1 = state_37205;
var statearr_37228_37277 = state_37205__$1;
(statearr_37228_37277[(2)] = inst_37186);

(statearr_37228_37277[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (17))){
var inst_37169 = (state_37205[(10)]);
var state_37205__$1 = state_37205;
var statearr_37229_37278 = state_37205__$1;
(statearr_37229_37278[(2)] = inst_37169);

(statearr_37229_37278[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (3))){
var inst_37203 = (state_37205[(2)]);
var state_37205__$1 = state_37205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37205__$1,inst_37203);
} else {
if((state_val_37206 === (12))){
var inst_37132 = (state_37205[(13)]);
var inst_37150 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37132);
var state_37205__$1 = state_37205;
var statearr_37230_37279 = state_37205__$1;
(statearr_37230_37279[(2)] = inst_37150);

(statearr_37230_37279[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (2))){
var inst_37132 = (state_37205[(13)]);
var _ = (function (){var statearr_37231 = state_37205;
(statearr_37231[(4)] = cljs.core.cons((5),(state_37205[(4)])));

return statearr_37231;
})();
var inst_37131 = flake.o;
var inst_37132__$1 = select_spec;
var inst_37134 = (inst_37132__$1 == null);
var inst_37135 = cljs.core.not(inst_37134);
var state_37205__$1 = (function (){var statearr_37232 = state_37205;
(statearr_37232[(13)] = inst_37132__$1);

(statearr_37232[(21)] = inst_37131);

return statearr_37232;
})();
if(inst_37135){
var statearr_37233_37280 = state_37205__$1;
(statearr_37233_37280[(1)] = (6));

} else {
var statearr_37234_37281 = state_37205__$1;
(statearr_37234_37281[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (23))){
var inst_37175 = (state_37205[(14)]);
var inst_37180 = cljs.core.empty_QMARK_(inst_37175);
var state_37205__$1 = state_37205;
var statearr_37235_37282 = state_37205__$1;
(statearr_37235_37282[(2)] = inst_37180);

(statearr_37235_37282[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (19))){
var inst_37160 = (state_37205[(17)]);
var state_37205__$1 = state_37205;
var statearr_37236_37283 = state_37205__$1;
(statearr_37236_37283[(2)] = inst_37160);

(statearr_37236_37283[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (11))){
var inst_37145 = (state_37205[(2)]);
var state_37205__$1 = state_37205;
var statearr_37238_37284 = state_37205__$1;
(statearr_37238_37284[(2)] = inst_37145);

(statearr_37238_37284[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (9))){
var state_37205__$1 = state_37205;
var statearr_37239_37285 = state_37205__$1;
(statearr_37239_37285[(2)] = true);

(statearr_37239_37285[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (5))){
var _ = (function (){var statearr_37240 = state_37205;
(statearr_37240[(4)] = cljs.core.rest((state_37205[(4)])));

return statearr_37240;
})();
var state_37205__$1 = state_37205;
var ex37237 = (state_37205__$1[(2)]);
var statearr_37241_37286 = state_37205__$1;
(statearr_37241_37286[(5)] = ex37237);


if((ex37237 instanceof Error)){
var statearr_37242_37287 = state_37205__$1;
(statearr_37242_37287[(1)] = (4));

(statearr_37242_37287[(5)] = null);

} else {
throw ex37237;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (14))){
var inst_37156 = (state_37205[(16)]);
var inst_37157 = (state_37205[(18)]);
var inst_37153 = (state_37205[(19)]);
var inst_37158 = (state_37205[(20)]);
var inst_37131 = (state_37205[(21)]);
var inst_37153__$1 = (state_37205[(2)]);
var inst_37154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$as);
var inst_37156__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$recur);
var inst_37157__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_37158__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_37159 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37153__$1,cljs.core.cst$kw$limit);
var inst_37160 = cljs.core.contains_QMARK_(inst_37157__$1,inst_37131);
var inst_37161 = (inst_37158__$1 > inst_37156__$1);
var inst_37163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37164 = [inst_37131];
var inst_37165 = (new cljs.core.PersistentVector(null,1,(5),inst_37163,inst_37164,null));
var inst_37166 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37165);
var state_37205__$1 = (function (){var statearr_37243 = state_37205;
(statearr_37243[(15)] = inst_37159);

(statearr_37243[(16)] = inst_37156__$1);

(statearr_37243[(17)] = inst_37160);

(statearr_37243[(18)] = inst_37157__$1);

(statearr_37243[(19)] = inst_37153__$1);

(statearr_37243[(12)] = inst_37155);

(statearr_37243[(20)] = inst_37158__$1);

(statearr_37243[(11)] = inst_37154);

(statearr_37243[(7)] = inst_37161);

return statearr_37243;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37205__$1,(15),inst_37166);
} else {
if((state_val_37206 === (26))){
var inst_37159 = (state_37205[(15)]);
var inst_37156 = (state_37205[(16)]);
var inst_37175 = (state_37205[(14)]);
var inst_37160 = (state_37205[(17)]);
var inst_37184 = (state_37205[(8)]);
var inst_37157 = (state_37205[(18)]);
var inst_37153 = (state_37205[(19)]);
var inst_37155 = (state_37205[(12)]);
var inst_37158 = (state_37205[(20)]);
var inst_37154 = (state_37205[(11)]);
var inst_37161 = (state_37205[(7)]);
var inst_37131 = (state_37205[(21)]);
var inst_37188 = (function (){var recur_seen = inst_37157;
var recur_subject = inst_37131;
var sub_flakes = inst_37175;
var seen_QMARK_ = inst_37160;
var multi_QMARK_ = inst_37154;
var limit = inst_37159;
var map__37130 = inst_37153;
var recur_depth = inst_37158;
var as = inst_37155;
var max_depth_QMARK_ = inst_37161;
var recur = inst_37156;
var stop_QMARK_ = inst_37184;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_37205__$1 = state_37205;
var statearr_37244_37288 = state_37205__$1;
(statearr_37244_37288[(2)] = inst_37188);

(statearr_37244_37288[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (16))){
var inst_37169 = (state_37205[(10)]);
var inst_37171 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37172 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37171,inst_37169);
var state_37205__$1 = state_37205;
var statearr_37245_37289 = state_37205__$1;
(statearr_37245_37289[(2)] = inst_37172);

(statearr_37245_37289[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (30))){
var inst_37200 = (state_37205[(2)]);
var _ = (function (){var statearr_37246 = state_37205;
(statearr_37246[(4)] = cljs.core.rest((state_37205[(4)])));

return statearr_37246;
})();
var state_37205__$1 = state_37205;
var statearr_37247_37290 = state_37205__$1;
(statearr_37247_37290[(2)] = inst_37200);

(statearr_37247_37290[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (10))){
var state_37205__$1 = state_37205;
var statearr_37248_37291 = state_37205__$1;
(statearr_37248_37291[(2)] = false);

(statearr_37248_37291[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (18))){
var inst_37160 = (state_37205[(17)]);
var inst_37175 = (state_37205[(2)]);
var state_37205__$1 = (function (){var statearr_37249 = state_37205;
(statearr_37249[(14)] = inst_37175);

return statearr_37249;
})();
if(cljs.core.truth_(inst_37160)){
var statearr_37250_37292 = state_37205__$1;
(statearr_37250_37292[(1)] = (19));

} else {
var statearr_37251_37293 = state_37205__$1;
(statearr_37251_37293[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37206 === (8))){
var inst_37148 = (state_37205[(2)]);
var state_37205__$1 = state_37205;
if(cljs.core.truth_(inst_37148)){
var statearr_37252_37294 = state_37205__$1;
(statearr_37252_37294[(1)] = (12));

} else {
var statearr_37253_37295 = state_37205__$1;
(statearr_37253_37295[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_37254 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37254[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__);

(statearr_37254[(1)] = (1));

return statearr_37254;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1 = (function (state_37205){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37205);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37255){var ex__16304__auto__ = e37255;
var statearr_37256_37296 = state_37205;
(statearr_37256_37296[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37205[(4)]))){
var statearr_37257_37297 = state_37205;
(statearr_37257_37297[(1)] = cljs.core.first((state_37205[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37298 = state_37205;
state_37205 = G__37298;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = function(state_37205){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1.call(this,state_37205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37258 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37258[(6)] = c__16375__auto__);

return statearr_37258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37476){
var state_val_37477 = (state_37476[(1)]);
if((state_val_37477 === (7))){
var state_37476__$1 = state_37476;
var statearr_37478_37563 = state_37476__$1;
(statearr_37478_37563[(2)] = null);

(statearr_37478_37563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (20))){
var inst_37337 = cljs.core.PersistentHashMap.EMPTY;
var state_37476__$1 = state_37476;
var statearr_37479_37564 = state_37476__$1;
(statearr_37479_37564[(2)] = inst_37337);

(statearr_37479_37564[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (27))){
var inst_37355 = (state_37476[(7)]);
var inst_37339 = (state_37476[(8)]);
var inst_37325 = (state_37476[(9)]);
var inst_37319 = (state_37476[(10)]);
var inst_37455 = (state_37476[(2)]);
var inst_37456 = (function (){var top_level_subject = inst_37319;
var select_spec = inst_37325;
var base_acc = inst_37339;
var acc_PLUS_refs = inst_37355;
var result = inst_37455;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_37457 = cljs.core.PersistentVector.EMPTY;
var inst_37458 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37325);
var inst_37459 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_37458);
var inst_37460 = cljs.core.vals(inst_37459);
var inst_37461 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37325);
var inst_37462 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_37461);
var inst_37463 = cljs.core.vals(inst_37462);
var inst_37464 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_37460,inst_37463);
var inst_37465 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37456,inst_37457,inst_37464);
var inst_37467 = (function (){var top_level_subject = inst_37319;
var select_spec = inst_37325;
var base_acc = inst_37339;
var acc_PLUS_refs = inst_37355;
var result = inst_37455;
var sort_preds = inst_37465;
return (function (acc,p__37466){
var vec__37480 = p__37466;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37480,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37480,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37480,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37480,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_37468 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37467,inst_37455,inst_37465);
var state_37476__$1 = state_37476;
var statearr_37483_37565 = state_37476__$1;
(statearr_37483_37565[(2)] = inst_37468);

(statearr_37483_37565[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (1))){
var state_37476__$1 = state_37476;
var statearr_37484_37566 = state_37476__$1;
(statearr_37484_37566[(2)] = null);

(statearr_37484_37566[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (24))){
var inst_37355 = (state_37476[(7)]);
var inst_37355__$1 = (state_37476[(2)]);
var inst_37356 = flakes;
var inst_37357 = cljs.core.PersistentHashMap.EMPTY;
var inst_37358 = inst_37356;
var inst_37359 = inst_37355__$1;
var inst_37360 = inst_37357;
var state_37476__$1 = (function (){var statearr_37485 = state_37476;
(statearr_37485[(7)] = inst_37355__$1);

(statearr_37485[(11)] = inst_37359);

(statearr_37485[(12)] = inst_37358);

(statearr_37485[(13)] = inst_37360);

return statearr_37485;
})();
var statearr_37486_37567 = state_37476__$1;
(statearr_37486_37567[(2)] = null);

(statearr_37486_37567[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (39))){
var inst_37359 = (state_37476[(11)]);
var inst_37374 = (state_37476[(14)]);
var inst_37325 = (state_37476[(9)]);
var inst_37368 = (state_37476[(15)]);
var inst_37403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37404 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_37359,inst_37325,inst_37368,inst_37374,false);
var state_37476__$1 = (function (){var statearr_37487 = state_37476;
(statearr_37487[(16)] = inst_37403);

return statearr_37487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37476__$1,(42),inst_37404);
} else {
if((state_val_37477 === (46))){
var inst_37368 = (state_37476[(15)]);
var inst_37358 = (state_37476[(12)]);
var inst_37360 = (state_37476[(13)]);
var inst_37421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37422 = ["_id"];
var inst_37423 = inst_37368.s;
var inst_37424 = [inst_37423];
var inst_37425 = cljs.core.PersistentHashMap.fromArrays(inst_37422,inst_37424);
var inst_37426 = cljs.core.rest(inst_37358);
var inst_37427 = [inst_37425,inst_37426,inst_37360];
var inst_37428 = (new cljs.core.PersistentVector(null,3,(5),inst_37421,inst_37427,null));
var state_37476__$1 = state_37476;
var statearr_37488_37568 = state_37476__$1;
(statearr_37488_37568[(2)] = inst_37428);

(statearr_37488_37568[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (4))){
var inst_37299 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37489_37569 = state_37476__$1;
(statearr_37489_37569[(2)] = inst_37299);

(statearr_37489_37569[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (15))){
var inst_37325 = (state_37476[(9)]);
var inst_37326 = (state_37476[(17)]);
var inst_37325__$1 = (state_37476[(2)]);
var inst_37326__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37325__$1);
var state_37476__$1 = (function (){var statearr_37490 = state_37476;
(statearr_37490[(9)] = inst_37325__$1);

(statearr_37490[(17)] = inst_37326__$1);

return statearr_37490;
})();
if(cljs.core.truth_(inst_37326__$1)){
var statearr_37491_37570 = state_37476__$1;
(statearr_37491_37570[(1)] = (16));

} else {
var statearr_37492_37571 = state_37476__$1;
(statearr_37492_37571[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (48))){
var inst_37439 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37493_37572 = state_37476__$1;
(statearr_37493_37572[(2)] = inst_37439);

(statearr_37493_37572[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (50))){
var state_37476__$1 = state_37476;
var statearr_37494_37573 = state_37476__$1;
(statearr_37494_37573[(2)] = null);

(statearr_37494_37573[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (21))){
var inst_37325 = (state_37476[(9)]);
var inst_37339 = (state_37476[(2)]);
var inst_37340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37341 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_37342 = (new cljs.core.PersistentVector(null,2,(5),inst_37340,inst_37341,null));
var inst_37343 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37325,inst_37342);
var state_37476__$1 = (function (){var statearr_37495 = state_37476;
(statearr_37495[(8)] = inst_37339);

return statearr_37495;
})();
if(cljs.core.truth_(inst_37343)){
var statearr_37496_37574 = state_37476__$1;
(statearr_37496_37574[(1)] = (22));

} else {
var statearr_37497_37575 = state_37476__$1;
(statearr_37497_37575[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (31))){
var inst_37359 = (state_37476[(11)]);
var inst_37368 = (state_37476[(15)]);
var inst_37373 = (state_37476[(18)]);
var inst_37377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37378 = fluree.db.query.fql.flake__GT_recur(db,inst_37368,inst_37373,inst_37359,fuel,max_fuel,cache);
var state_37476__$1 = (function (){var statearr_37498 = state_37476;
(statearr_37498[(19)] = inst_37377);

return statearr_37498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37476__$1,(34),inst_37378);
} else {
if((state_val_37477 === (32))){
var inst_37373 = (state_37476[(18)]);
var state_37476__$1 = state_37476;
if(cljs.core.truth_(inst_37373)){
var statearr_37499_37576 = state_37476__$1;
(statearr_37499_37576[(1)] = (35));

} else {
var statearr_37500_37577 = state_37476__$1;
(statearr_37500_37577[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (40))){
var inst_37325 = (state_37476[(9)]);
var inst_37413 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37325);
var inst_37414 = cljs.core.empty_QMARK_(inst_37413);
var state_37476__$1 = state_37476;
if(inst_37414){
var statearr_37501_37578 = state_37476__$1;
(statearr_37501_37578[(1)] = (43));

} else {
var statearr_37502_37579 = state_37476__$1;
(statearr_37502_37579[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (33))){
var inst_37368 = (state_37476[(15)]);
var inst_37445 = (state_37476[(2)]);
var inst_37446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37445,(0),null);
var inst_37447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37445,(1),null);
var inst_37448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37445,(2),null);
var inst_37449 = inst_37368.s;
var inst_37450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37446,cljs.core.cst$kw$_id,inst_37449);
var inst_37358 = inst_37447;
var inst_37359 = inst_37450;
var inst_37360 = inst_37448;
var state_37476__$1 = (function (){var statearr_37503 = state_37476;
(statearr_37503[(11)] = inst_37359);

(statearr_37503[(12)] = inst_37358);

(statearr_37503[(13)] = inst_37360);

return statearr_37503;
})();
var statearr_37504_37580 = state_37476__$1;
(statearr_37504_37580[(2)] = null);

(statearr_37504_37580[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (13))){
var inst_37319 = (state_37476[(10)]);
var inst_37322 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_37319);
var state_37476__$1 = state_37476;
var statearr_37505_37581 = state_37476__$1;
(statearr_37505_37581[(2)] = inst_37322);

(statearr_37505_37581[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (22))){
var inst_37325 = (state_37476[(9)]);
var inst_37345 = cljs.core.first(flakes);
var inst_37346 = fluree.db.query.fql.s(inst_37345);
var inst_37347 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_37325);
var inst_37348 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_37346,inst_37347);
var state_37476__$1 = state_37476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37476__$1,(25),inst_37348);
} else {
if((state_val_37477 === (36))){
var inst_37325 = (state_37476[(9)]);
var inst_37401 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37325);
var state_37476__$1 = state_37476;
if(cljs.core.truth_(inst_37401)){
var statearr_37506_37582 = state_37476__$1;
(statearr_37506_37582[(1)] = (39));

} else {
var statearr_37507_37583 = state_37476__$1;
(statearr_37507_37583[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (41))){
var inst_37441 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37508_37584 = state_37476__$1;
(statearr_37508_37584[(2)] = inst_37441);

(statearr_37508_37584[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (43))){
var inst_37325 = (state_37476[(9)]);
var inst_37416 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37325);
var state_37476__$1 = state_37476;
var statearr_37509_37585 = state_37476__$1;
(statearr_37509_37585[(2)] = inst_37416);

(statearr_37509_37585[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (29))){
var inst_37325 = (state_37476[(9)]);
var inst_37368 = (state_37476[(15)]);
var inst_37358 = (state_37476[(12)]);
var inst_37373 = (state_37476[(18)]);
var inst_37368__$1 = cljs.core.first(inst_37358);
var inst_37369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37370 = inst_37368__$1.p;
var inst_37371 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_37370];
var inst_37372 = (new cljs.core.PersistentVector(null,3,(5),inst_37369,inst_37371,null));
var inst_37373__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_37325,inst_37372);
var inst_37374 = fluree.db.query.fql.component_follow_QMARK_(inst_37373__$1,inst_37325);
var inst_37375 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_37373__$1);
var state_37476__$1 = (function (){var statearr_37510 = state_37476;
(statearr_37510[(14)] = inst_37374);

(statearr_37510[(15)] = inst_37368__$1);

(statearr_37510[(18)] = inst_37373__$1);

return statearr_37510;
})();
if(cljs.core.truth_(inst_37375)){
var statearr_37511_37586 = state_37476__$1;
(statearr_37511_37586[(1)] = (31));

} else {
var statearr_37512_37587 = state_37476__$1;
(statearr_37512_37587[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (44))){
var state_37476__$1 = state_37476;
var statearr_37513_37588 = state_37476__$1;
(statearr_37513_37588[(2)] = false);

(statearr_37513_37588[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (6))){
var state_37476__$1 = state_37476;
var statearr_37514_37589 = state_37476__$1;
(statearr_37514_37589[(2)] = null);

(statearr_37514_37589[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (28))){
var inst_37359 = (state_37476[(11)]);
var state_37476__$1 = state_37476;
var statearr_37515_37590 = state_37476__$1;
(statearr_37515_37590[(2)] = inst_37359);

(statearr_37515_37590[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (51))){
var inst_37437 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37516_37591 = state_37476__$1;
(statearr_37516_37591[(2)] = inst_37437);

(statearr_37516_37591[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (25))){
var inst_37339 = (state_37476[(8)]);
var inst_37350 = (state_37476[(2)]);
var inst_37351 = fluree.db.util.async.throw_err(inst_37350);
var inst_37352 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37339,inst_37351], 0));
var state_37476__$1 = state_37476;
var statearr_37517_37592 = state_37476__$1;
(statearr_37517_37592[(2)] = inst_37352);

(statearr_37517_37592[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (34))){
var inst_37377 = (state_37476[(19)]);
var inst_37358 = (state_37476[(12)]);
var inst_37360 = (state_37476[(13)]);
var inst_37380 = (state_37476[(2)]);
var inst_37381 = fluree.db.util.async.throw_err(inst_37380);
var inst_37382 = cljs.core.rest(inst_37358);
var inst_37383 = [inst_37381,inst_37382,inst_37360];
var inst_37384 = (new cljs.core.PersistentVector(null,3,(5),inst_37377,inst_37383,null));
var state_37476__$1 = state_37476;
var statearr_37518_37593 = state_37476__$1;
(statearr_37518_37593[(2)] = inst_37384);

(statearr_37518_37593[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (17))){
var inst_37325 = (state_37476[(9)]);
var inst_37329 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37325);
var state_37476__$1 = state_37476;
var statearr_37520_37594 = state_37476__$1;
(statearr_37520_37594[(2)] = inst_37329);

(statearr_37520_37594[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (3))){
var inst_37474 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37476__$1,inst_37474);
} else {
if((state_val_37477 === (12))){
var _ = (function (){var statearr_37521 = state_37476;
(statearr_37521[(4)] = cljs.core.rest((state_37476[(4)])));

return statearr_37521;
})();
var state_37476__$1 = state_37476;
var ex37519 = (state_37476__$1[(2)]);
var statearr_37522_37595 = state_37476__$1;
(statearr_37522_37595[(5)] = ex37519);


var statearr_37523_37596 = state_37476__$1;
(statearr_37523_37596[(1)] = (11));

(statearr_37523_37596[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (2))){
var _ = (function (){var statearr_37524 = state_37476;
(statearr_37524[(4)] = cljs.core.cons((5),(state_37476[(4)])));

return statearr_37524;
})();
var inst_37305 = cljs.core.not_empty(flakes);
var state_37476__$1 = state_37476;
if(cljs.core.truth_(inst_37305)){
var statearr_37525_37597 = state_37476__$1;
(statearr_37525_37597[(1)] = (6));

} else {
var statearr_37526_37598 = state_37476__$1;
(statearr_37526_37598[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (23))){
var inst_37339 = (state_37476[(8)]);
var state_37476__$1 = state_37476;
var statearr_37527_37599 = state_37476__$1;
(statearr_37527_37599[(2)] = inst_37339);

(statearr_37527_37599[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (47))){
var state_37476__$1 = state_37476;
var statearr_37528_37600 = state_37476__$1;
(statearr_37528_37600[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (35))){
var inst_37359 = (state_37476[(11)]);
var inst_37374 = (state_37476[(14)]);
var inst_37368 = (state_37476[(15)]);
var inst_37360 = (state_37476[(13)]);
var inst_37373 = (state_37476[(18)]);
var inst_37390 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_37359,inst_37373,inst_37368,inst_37374,false,inst_37360);
var state_37476__$1 = state_37476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37476__$1,(38),inst_37390);
} else {
if((state_val_37477 === (19))){
var inst_37319 = (state_37476[(10)]);
var inst_37333 = ["_id"];
var inst_37334 = [inst_37319];
var inst_37335 = cljs.core.PersistentHashMap.fromArrays(inst_37333,inst_37334);
var state_37476__$1 = state_37476;
var statearr_37530_37601 = state_37476__$1;
(statearr_37530_37601[(2)] = inst_37335);

(statearr_37530_37601[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (11))){
var inst_37307 = (state_37476[(2)]);
var inst_37308 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_37307], 0));
var inst_37309 = (function(){throw inst_37307})();
var state_37476__$1 = (function (){var statearr_37532 = state_37476;
(statearr_37532[(20)] = inst_37308);

return statearr_37532;
})();
var statearr_37533_37602 = state_37476__$1;
(statearr_37533_37602[(2)] = inst_37309);

(statearr_37533_37602[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (9))){
var _ = (function (){var statearr_37534 = state_37476;
(statearr_37534[(4)] = cljs.core.cons((12),(state_37476[(4)])));

return statearr_37534;
})();
var inst_37315 = cljs.core.first(flakes);
var inst_37316 = fluree.db.query.fql.s(inst_37315);
var ___$1 = (function (){var statearr_37535 = state_37476;
(statearr_37535[(4)] = cljs.core.rest((state_37476[(4)])));

return statearr_37535;
})();
var state_37476__$1 = state_37476;
var statearr_37536_37603 = state_37476__$1;
(statearr_37536_37603[(2)] = inst_37316);

(statearr_37536_37603[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (5))){
var _ = (function (){var statearr_37537 = state_37476;
(statearr_37537[(4)] = cljs.core.rest((state_37476[(4)])));

return statearr_37537;
})();
var state_37476__$1 = state_37476;
var ex37531 = (state_37476__$1[(2)]);
var statearr_37538_37604 = state_37476__$1;
(statearr_37538_37604[(5)] = ex37531);


if((ex37531 instanceof Error)){
var statearr_37539_37605 = state_37476__$1;
(statearr_37539_37605[(1)] = (4));

(statearr_37539_37605[(5)] = null);

} else {
throw ex37531;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (14))){
var state_37476__$1 = state_37476;
var statearr_37540_37606 = state_37476__$1;
(statearr_37540_37606[(2)] = base_select_spec);

(statearr_37540_37606[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (45))){
var inst_37419 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
if(cljs.core.truth_(inst_37419)){
var statearr_37541_37607 = state_37476__$1;
(statearr_37541_37607[(1)] = (46));

} else {
var statearr_37542_37608 = state_37476__$1;
(statearr_37542_37608[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (26))){
var inst_37358 = (state_37476[(12)]);
var inst_37362 = cljs.core.empty_QMARK_(inst_37358);
var state_37476__$1 = state_37476;
if(inst_37362){
var statearr_37543_37609 = state_37476__$1;
(statearr_37543_37609[(1)] = (28));

} else {
var statearr_37544_37610 = state_37476__$1;
(statearr_37544_37610[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (16))){
var inst_37326 = (state_37476[(17)]);
var state_37476__$1 = state_37476;
var statearr_37545_37611 = state_37476__$1;
(statearr_37545_37611[(2)] = inst_37326);

(statearr_37545_37611[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (38))){
var inst_37358 = (state_37476[(12)]);
var inst_37392 = (state_37476[(2)]);
var inst_37393 = fluree.db.util.async.throw_err(inst_37392);
var inst_37394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37393,(0),null);
var inst_37395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37393,(1),null);
var inst_37396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37397 = cljs.core.rest(inst_37358);
var inst_37398 = [inst_37394,inst_37397,inst_37395];
var inst_37399 = (new cljs.core.PersistentVector(null,3,(5),inst_37396,inst_37398,null));
var state_37476__$1 = state_37476;
var statearr_37546_37612 = state_37476__$1;
(statearr_37546_37612[(2)] = inst_37399);

(statearr_37546_37612[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (30))){
var inst_37453 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37547_37613 = state_37476__$1;
(statearr_37547_37613[(2)] = inst_37453);

(statearr_37547_37613[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (10))){
var inst_37319 = (state_37476[(2)]);
var inst_37320 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_37476__$1 = (function (){var statearr_37548 = state_37476;
(statearr_37548[(10)] = inst_37319);

return statearr_37548;
})();
if(cljs.core.truth_(inst_37320)){
var statearr_37549_37614 = state_37476__$1;
(statearr_37549_37614[(1)] = (13));

} else {
var statearr_37550_37615 = state_37476__$1;
(statearr_37550_37615[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (18))){
var inst_37331 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
if(cljs.core.truth_(inst_37331)){
var statearr_37551_37616 = state_37476__$1;
(statearr_37551_37616[(1)] = (19));

} else {
var statearr_37552_37617 = state_37476__$1;
(statearr_37552_37617[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (42))){
var inst_37358 = (state_37476[(12)]);
var inst_37360 = (state_37476[(13)]);
var inst_37403 = (state_37476[(16)]);
var inst_37406 = (state_37476[(2)]);
var inst_37407 = fluree.db.util.async.throw_err(inst_37406);
var inst_37408 = cljs.core.first(inst_37407);
var inst_37409 = cljs.core.rest(inst_37358);
var inst_37410 = [inst_37408,inst_37409,inst_37360];
var inst_37411 = (new cljs.core.PersistentVector(null,3,(5),inst_37403,inst_37410,null));
var state_37476__$1 = state_37476;
var statearr_37553_37618 = state_37476__$1;
(statearr_37553_37618[(2)] = inst_37411);

(statearr_37553_37618[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (37))){
var inst_37443 = (state_37476[(2)]);
var state_37476__$1 = state_37476;
var statearr_37554_37619 = state_37476__$1;
(statearr_37554_37619[(2)] = inst_37443);

(statearr_37554_37619[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (8))){
var inst_37471 = (state_37476[(2)]);
var _ = (function (){var statearr_37555 = state_37476;
(statearr_37555[(4)] = cljs.core.rest((state_37476[(4)])));

return statearr_37555;
})();
var state_37476__$1 = state_37476;
var statearr_37556_37620 = state_37476__$1;
(statearr_37556_37620[(2)] = inst_37471);

(statearr_37556_37620[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37477 === (49))){
var inst_37359 = (state_37476[(11)]);
var inst_37358 = (state_37476[(12)]);
var inst_37360 = (state_37476[(13)]);
var inst_37431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37432 = cljs.core.rest(inst_37358);
var inst_37433 = [inst_37359,inst_37432,inst_37360];
var inst_37434 = (new cljs.core.PersistentVector(null,3,(5),inst_37431,inst_37433,null));
var state_37476__$1 = state_37476;
var statearr_37557_37621 = state_37476__$1;
(statearr_37557_37621[(2)] = inst_37434);

(statearr_37557_37621[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0 = (function (){
var statearr_37558 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37558[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__);

(statearr_37558[(1)] = (1));

return statearr_37558;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1 = (function (state_37476){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37476);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37559){var ex__16304__auto__ = e37559;
var statearr_37560_37622 = state_37476;
(statearr_37560_37622[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37476[(4)]))){
var statearr_37561_37623 = state_37476;
(statearr_37561_37623[(1)] = cljs.core.first((state_37476[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37624 = state_37476;
state_37476 = G__37624;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = function(state_37476){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1.call(this,state_37476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37562 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37562[(6)] = c__16375__auto__);

return statearr_37562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__37627 = arguments.length;
switch (G__37627) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37669){
var state_val_37670 = (state_37669[(1)]);
if((state_val_37670 === (7))){
var inst_37635 = (state_37669[(7)]);
var state_37669__$1 = state_37669;
var statearr_37671_37701 = state_37669__$1;
(statearr_37671_37701[(2)] = inst_37635);

(statearr_37671_37701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (1))){
var state_37669__$1 = state_37669;
var statearr_37672_37702 = state_37669__$1;
(statearr_37672_37702[(2)] = null);

(statearr_37672_37702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (4))){
var inst_37628 = (state_37669[(2)]);
var state_37669__$1 = state_37669;
var statearr_37673_37703 = state_37669__$1;
(statearr_37673_37703[(2)] = inst_37628);

(statearr_37673_37703[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (15))){
var inst_37663 = (state_37669[(2)]);
var inst_37664 = fluree.db.util.async.throw_err(inst_37663);
var _ = (function (){var statearr_37674 = state_37669;
(statearr_37674[(4)] = cljs.core.rest((state_37669[(4)])));

return statearr_37674;
})();
var state_37669__$1 = state_37669;
var statearr_37675_37704 = state_37669__$1;
(statearr_37675_37704[(2)] = inst_37664);

(statearr_37675_37704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (13))){
var inst_37647 = (state_37669[(8)]);
var state_37669__$1 = state_37669;
var statearr_37676_37705 = state_37669__$1;
(statearr_37676_37705[(2)] = inst_37647);

(statearr_37676_37705[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (6))){
var inst_37635 = (state_37669[(7)]);
var inst_37637 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_37638 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37635,inst_37637);
var state_37669__$1 = state_37669;
var statearr_37677_37706 = state_37669__$1;
(statearr_37677_37706[(2)] = inst_37638);

(statearr_37677_37706[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (3))){
var inst_37667 = (state_37669[(2)]);
var state_37669__$1 = state_37669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37669__$1,inst_37667);
} else {
if((state_val_37670 === (12))){
var inst_37647 = (state_37669[(8)]);
var inst_37649 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_37650 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37647,inst_37649);
var state_37669__$1 = state_37669;
var statearr_37678_37707 = state_37669__$1;
(statearr_37678_37707[(2)] = inst_37650);

(statearr_37678_37707[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (2))){
var _ = (function (){var statearr_37679 = state_37669;
(statearr_37679[(4)] = cljs.core.cons((5),(state_37669[(4)])));

return statearr_37679;
})();
var inst_37635 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_37669__$1 = (function (){var statearr_37680 = state_37669;
(statearr_37680[(7)] = inst_37635);

return statearr_37680;
})();
if(cljs.core.truth_(fuel)){
var statearr_37681_37708 = state_37669__$1;
(statearr_37681_37708[(1)] = (6));

} else {
var statearr_37682_37709 = state_37669__$1;
(statearr_37682_37709[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (11))){
var inst_37647 = (state_37669[(2)]);
var state_37669__$1 = (function (){var statearr_37684 = state_37669;
(statearr_37684[(8)] = inst_37647);

return statearr_37684;
})();
if(cljs.core.truth_(limit)){
var statearr_37685_37710 = state_37669__$1;
(statearr_37685_37710[(1)] = (12));

} else {
var statearr_37686_37711 = state_37669__$1;
(statearr_37686_37711[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (9))){
var inst_37641 = (state_37669[(9)]);
var inst_37643 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_37644 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37641,inst_37643);
var state_37669__$1 = state_37669;
var statearr_37687_37712 = state_37669__$1;
(statearr_37687_37712[(2)] = inst_37644);

(statearr_37687_37712[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (5))){
var _ = (function (){var statearr_37688 = state_37669;
(statearr_37688[(4)] = cljs.core.rest((state_37669[(4)])));

return statearr_37688;
})();
var state_37669__$1 = state_37669;
var ex37683 = (state_37669__$1[(2)]);
var statearr_37689_37713 = state_37669__$1;
(statearr_37689_37713[(5)] = ex37683);


if((ex37683 instanceof Error)){
var statearr_37690_37714 = state_37669__$1;
(statearr_37690_37714[(1)] = (4));

(statearr_37690_37714[(5)] = null);

} else {
throw ex37683;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (14))){
var inst_37653 = (state_37669[(2)]);
var inst_37654 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_37655 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_37654);
var inst_37656 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37653,inst_37655);
var inst_37657 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37656,flakes);
var inst_37658 = cljs.core.PersistentVector.EMPTY;
var inst_37659 = (function (){var xf = inst_37656;
var flakes_by_sub = inst_37657;
return (function (p1__37625_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__37625_SHARP_);
});
})();
var inst_37660 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37659,inst_37657);
var inst_37661 = fluree.db.util.async.merge_into_QMARK_(inst_37658,inst_37660);
var state_37669__$1 = state_37669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37669__$1,(15),inst_37661);
} else {
if((state_val_37670 === (10))){
var inst_37641 = (state_37669[(9)]);
var state_37669__$1 = state_37669;
var statearr_37691_37715 = state_37669__$1;
(statearr_37691_37715[(2)] = inst_37641);

(statearr_37691_37715[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37670 === (8))){
var inst_37641 = (state_37669[(2)]);
var state_37669__$1 = (function (){var statearr_37692 = state_37669;
(statearr_37692[(9)] = inst_37641);

return statearr_37692;
})();
if(cljs.core.truth_(offset)){
var statearr_37693_37716 = state_37669__$1;
(statearr_37693_37716[(1)] = (9));

} else {
var statearr_37694_37717 = state_37669__$1;
(statearr_37694_37717[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_37695 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37695[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_37695[(1)] = (1));

return statearr_37695;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_37669){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37669);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37696){var ex__16304__auto__ = e37696;
var statearr_37697_37718 = state_37669;
(statearr_37697_37718[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37669[(4)]))){
var statearr_37698_37719 = state_37669;
(statearr_37698_37719[(1)] = cljs.core.first((state_37669[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37720 = state_37669;
state_37669 = G__37720;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_37669){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_37669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37699 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37699[(6)] = c__16375__auto__);

return statearr_37699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__37722 = arguments.length;
switch (G__37722) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37806){
var state_val_37807 = (state_37806[(1)]);
if((state_val_37807 === (7))){
var inst_37801 = (state_37806[(2)]);
var _ = (function (){var statearr_37809 = state_37806;
(statearr_37809[(4)] = cljs.core.rest((state_37806[(4)])));

return statearr_37809;
})();
var state_37806__$1 = state_37806;
var statearr_37810_37857 = state_37806__$1;
(statearr_37810_37857[(2)] = inst_37801);

(statearr_37810_37857[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (20))){
var inst_37742 = (state_37806[(7)]);
var inst_37750 = (state_37806[(8)]);
var inst_37743 = (state_37806[(9)]);
var inst_37771 = (inst_37742 + (1));
var tmp37808 = inst_37743;
var inst_37741 = inst_37750;
var inst_37742__$1 = inst_37771;
var inst_37743__$1 = tmp37808;
var state_37806__$1 = (function (){var statearr_37811 = state_37806;
(statearr_37811[(7)] = inst_37742__$1);

(statearr_37811[(9)] = inst_37743__$1);

(statearr_37811[(10)] = inst_37741);

return statearr_37811;
})();
var statearr_37812_37858 = state_37806__$1;
(statearr_37812_37858[(2)] = null);

(statearr_37812_37858[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (27))){
var inst_37776 = (state_37806[(11)]);
var inst_37785 = (state_37806[(2)]);
var inst_37786 = fluree.db.util.async.throw_err(inst_37785);
var inst_37787 = (inst_37776.cljs$core$IFn$_invoke$arity$1 ? inst_37776.cljs$core$IFn$_invoke$arity$1(inst_37786) : inst_37776.call(null,inst_37786));
var state_37806__$1 = state_37806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37806__$1,(26),inst_37787);
} else {
if((state_val_37807 === (1))){
var state_37806__$1 = state_37806;
var statearr_37813_37859 = state_37806__$1;
(statearr_37813_37859[(2)] = null);

(statearr_37813_37859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (24))){
var state_37806__$1 = state_37806;
var statearr_37814_37860 = state_37806__$1;
(statearr_37814_37860[(2)] = null);

(statearr_37814_37860[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (4))){
var inst_37723 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
var statearr_37815_37861 = state_37806__$1;
(statearr_37815_37861[(2)] = inst_37723);

(statearr_37815_37861[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (15))){
var inst_37764 = (state_37806[(12)]);
var inst_37764__$1 = offset;
var state_37806__$1 = (function (){var statearr_37816 = state_37806;
(statearr_37816[(12)] = inst_37764__$1);

return statearr_37816;
})();
if(cljs.core.truth_(inst_37764__$1)){
var statearr_37817_37862 = state_37806__$1;
(statearr_37817_37862[(1)] = (17));

} else {
var statearr_37818_37863 = state_37806__$1;
(statearr_37818_37863[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (21))){
var state_37806__$1 = state_37806;
var statearr_37819_37864 = state_37806__$1;
(statearr_37819_37864[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (13))){
var inst_37759 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
var statearr_37821_37865 = state_37806__$1;
(statearr_37821_37865[(2)] = inst_37759);

(statearr_37821_37865[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (22))){
var inst_37797 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
var statearr_37822_37866 = state_37806__$1;
(statearr_37822_37866[(2)] = inst_37797);

(statearr_37822_37866[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (6))){
var inst_37751 = (state_37806[(13)]);
var inst_37741 = (state_37806[(10)]);
var inst_37749 = (state_37806[(14)]);
var inst_37748 = cljs.core.seq(inst_37741);
var inst_37749__$1 = cljs.core.first(inst_37748);
var inst_37750 = cljs.core.next(inst_37748);
var inst_37751__$1 = (inst_37749__$1 == null);
var state_37806__$1 = (function (){var statearr_37823 = state_37806;
(statearr_37823[(8)] = inst_37750);

(statearr_37823[(13)] = inst_37751__$1);

(statearr_37823[(14)] = inst_37749__$1);

return statearr_37823;
})();
if(cljs.core.truth_(inst_37751__$1)){
var statearr_37824_37867 = state_37806__$1;
(statearr_37824_37867[(1)] = (8));

} else {
var statearr_37825_37868 = state_37806__$1;
(statearr_37825_37868[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (25))){
var inst_37795 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
var statearr_37826_37869 = state_37806__$1;
(statearr_37826_37869[(2)] = inst_37795);

(statearr_37826_37869[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (17))){
var inst_37742 = (state_37806[(7)]);
var inst_37766 = (inst_37742 < offset);
var state_37806__$1 = state_37806;
var statearr_37827_37870 = state_37806__$1;
(statearr_37827_37870[(2)] = inst_37766);

(statearr_37827_37870[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (3))){
var inst_37804 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37806__$1,inst_37804);
} else {
if((state_val_37807 === (12))){
var inst_37754 = (state_37806[(15)]);
var state_37806__$1 = state_37806;
var statearr_37828_37871 = state_37806__$1;
(statearr_37828_37871[(2)] = inst_37754);

(statearr_37828_37871[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (2))){
var inst_37736 = (state_37806[(16)]);
var _ = (function (){var statearr_37829 = state_37806;
(statearr_37829[(4)] = cljs.core.cons((5),(state_37806[(4)])));

return statearr_37829;
})();
var inst_37736__$1 = subjects;
var inst_37737 = cljs.core.seq(inst_37736__$1);
var inst_37738 = cljs.core.first(inst_37737);
var inst_37739 = cljs.core.next(inst_37737);
var inst_37740 = cljs.core.PersistentVector.EMPTY;
var inst_37741 = inst_37736__$1;
var inst_37742 = (0);
var inst_37743 = inst_37740;
var state_37806__$1 = (function (){var statearr_37830 = state_37806;
(statearr_37830[(16)] = inst_37736__$1);

(statearr_37830[(17)] = inst_37738);

(statearr_37830[(7)] = inst_37742);

(statearr_37830[(18)] = inst_37739);

(statearr_37830[(9)] = inst_37743);

(statearr_37830[(10)] = inst_37741);

return statearr_37830;
})();
var statearr_37831_37872 = state_37806__$1;
(statearr_37831_37872[(2)] = null);

(statearr_37831_37872[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (23))){
var inst_37736 = (state_37806[(16)]);
var inst_37738 = (state_37806[(17)]);
var inst_37742 = (state_37806[(7)]);
var inst_37750 = (state_37806[(8)]);
var inst_37739 = (state_37806[(18)]);
var inst_37743 = (state_37806[(9)]);
var inst_37741 = (state_37806[(10)]);
var inst_37749 = (state_37806[(14)]);
var inst_37775 = (inst_37742 + (1));
var inst_37776 = (function (){var first__37735 = inst_37738;
var r = inst_37750;
var seq__37734 = inst_37739;
var first__37747 = inst_37749;
var acc = inst_37743;
var n = inst_37742;
var s = inst_37749;
var seq__37746 = inst_37750;
var vec__37733 = inst_37736;
var vec__37745 = inst_37741;
var G__37732 = inst_37741;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_37777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37778 = [inst_37749];
var inst_37779 = (new cljs.core.PersistentVector(null,1,(5),inst_37777,inst_37778,null));
var inst_37780 = [cljs.core.cst$kw$limit];
var inst_37781 = [limit];
var inst_37782 = cljs.core.PersistentHashMap.fromArrays(inst_37780,inst_37781);
var inst_37783 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37779,inst_37782);
var state_37806__$1 = (function (){var statearr_37832 = state_37806;
(statearr_37832[(19)] = inst_37775);

(statearr_37832[(11)] = inst_37776);

return statearr_37832;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37806__$1,(27),inst_37783);
} else {
if((state_val_37807 === (19))){
var inst_37769 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
if(cljs.core.truth_(inst_37769)){
var statearr_37833_37873 = state_37806__$1;
(statearr_37833_37873[(1)] = (20));

} else {
var statearr_37834_37874 = state_37806__$1;
(statearr_37834_37874[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (11))){
var inst_37742 = (state_37806[(7)]);
var inst_37756 = (inst_37742 > limit);
var state_37806__$1 = state_37806;
var statearr_37836_37875 = state_37806__$1;
(statearr_37836_37875[(2)] = inst_37756);

(statearr_37836_37875[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (9))){
var inst_37754 = (state_37806[(15)]);
var inst_37754__$1 = limit;
var state_37806__$1 = (function (){var statearr_37837 = state_37806;
(statearr_37837[(15)] = inst_37754__$1);

return statearr_37837;
})();
if(cljs.core.truth_(inst_37754__$1)){
var statearr_37838_37876 = state_37806__$1;
(statearr_37838_37876[(1)] = (11));

} else {
var statearr_37839_37877 = state_37806__$1;
(statearr_37839_37877[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (5))){
var _ = (function (){var statearr_37840 = state_37806;
(statearr_37840[(4)] = cljs.core.rest((state_37806[(4)])));

return statearr_37840;
})();
var state_37806__$1 = state_37806;
var ex37835 = (state_37806__$1[(2)]);
var statearr_37841_37878 = state_37806__$1;
(statearr_37841_37878[(5)] = ex37835);


if((ex37835 instanceof Error)){
var statearr_37842_37879 = state_37806__$1;
(statearr_37842_37879[(1)] = (4));

(statearr_37842_37879[(5)] = null);

} else {
throw ex37835;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (14))){
var inst_37743 = (state_37806[(9)]);
var state_37806__$1 = state_37806;
var statearr_37843_37880 = state_37806__$1;
(statearr_37843_37880[(2)] = inst_37743);

(statearr_37843_37880[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (26))){
var inst_37750 = (state_37806[(8)]);
var inst_37743 = (state_37806[(9)]);
var inst_37775 = (state_37806[(19)]);
var inst_37789 = (state_37806[(2)]);
var inst_37790 = fluree.db.util.async.throw_err(inst_37789);
var inst_37791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37743,inst_37790);
var inst_37741 = inst_37750;
var inst_37742 = inst_37775;
var inst_37743__$1 = inst_37791;
var state_37806__$1 = (function (){var statearr_37844 = state_37806;
(statearr_37844[(7)] = inst_37742);

(statearr_37844[(9)] = inst_37743__$1);

(statearr_37844[(10)] = inst_37741);

return statearr_37844;
})();
var statearr_37845_37881 = state_37806__$1;
(statearr_37845_37881[(2)] = null);

(statearr_37845_37881[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (16))){
var inst_37799 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
var statearr_37846_37882 = state_37806__$1;
(statearr_37846_37882[(2)] = inst_37799);

(statearr_37846_37882[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (10))){
var inst_37761 = (state_37806[(2)]);
var state_37806__$1 = state_37806;
if(cljs.core.truth_(inst_37761)){
var statearr_37847_37883 = state_37806__$1;
(statearr_37847_37883[(1)] = (14));

} else {
var statearr_37848_37884 = state_37806__$1;
(statearr_37848_37884[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (18))){
var inst_37764 = (state_37806[(12)]);
var state_37806__$1 = state_37806;
var statearr_37849_37885 = state_37806__$1;
(statearr_37849_37885[(2)] = inst_37764);

(statearr_37849_37885[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37807 === (8))){
var inst_37751 = (state_37806[(13)]);
var state_37806__$1 = state_37806;
var statearr_37850_37886 = state_37806__$1;
(statearr_37850_37886[(2)] = inst_37751);

(statearr_37850_37886[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_37851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37851[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_37851[(1)] = (1));

return statearr_37851;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_37806){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37806);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37852){var ex__16304__auto__ = e37852;
var statearr_37853_37887 = state_37806;
(statearr_37853_37887[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37806[(4)]))){
var statearr_37854_37888 = state_37806;
(statearr_37854_37888[(1)] = cljs.core.first((state_37806[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37889 = state_37806;
state_37806 = G__37889;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_37806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_37806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37855 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37855[(6)] = c__16375__auto__);

return statearr_37855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__37891 = arguments.length;
switch (G__37891) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38079){
var state_val_38080 = (state_38079[(1)]);
if((state_val_38080 === (7))){
var state_38079__$1 = state_38079;
var statearr_38081_38152 = state_38079__$1;
(statearr_38081_38152[(2)] = null);

(statearr_38081_38152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (20))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_37962 = (state_38079[(2)]);
var inst_37963 = fluree.db.util.async.throw_err(inst_37962);
var inst_37964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37965 = [inst_37932];
var inst_37966 = (new cljs.core.PersistentVector(null,1,(5),inst_37964,inst_37965,null));
var inst_37967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37968 = [inst_37932,inst_37934];
var inst_37969 = (new cljs.core.PersistentVector(null,2,(5),inst_37967,inst_37968,null));
var inst_37970 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_37966,cljs.core._LT_,inst_37969);
var state_38079__$1 = (function (){var statearr_38082 = state_38079;
(statearr_38082[(9)] = inst_37963);

return statearr_38082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(21),inst_37970);
} else {
if((state_val_38080 === (27))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_37999 = (inst_37951.cljs$core$IFn$_invoke$arity$2 ? inst_37951.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_37933) : inst_37951.call(null,cljs.core._GT__EQ_,inst_37933));
var state_38079__$1 = state_38079;
if(cljs.core.truth_(inst_37999)){
var statearr_38083_38153 = state_38079__$1;
(statearr_38083_38153[(1)] = (30));

} else {
var statearr_38084_38154 = state_38079__$1;
(statearr_38084_38154[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (1))){
var state_38079__$1 = state_38079;
var statearr_38085_38155 = state_38079__$1;
(statearr_38085_38155[(2)] = null);

(statearr_38085_38155[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (24))){
var inst_38048 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38086_38156 = state_38079__$1;
(statearr_38086_38156[(2)] = inst_38048);

(statearr_38086_38156[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (39))){
var inst_38038 = null;
var state_38079__$1 = state_38079;
var statearr_38087_38157 = state_38079__$1;
(statearr_38087_38157[(2)] = inst_38038);

(statearr_38087_38157[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (46))){
var inst_38059 = (state_38079[(12)]);
var inst_37925 = (state_38079[(13)]);
var inst_37917 = inst_37925;
var inst_37918 = inst_38059;
var state_38079__$1 = (function (){var statearr_38088 = state_38079;
(statearr_38088[(14)] = inst_37918);

(statearr_38088[(15)] = inst_37917);

return statearr_38088;
})();
var statearr_38089_38158 = state_38079__$1;
(statearr_38089_38158[(2)] = null);

(statearr_38089_38158[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (4))){
var inst_37892 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38090_38159 = state_38079__$1;
(statearr_38090_38159[(2)] = inst_37892);

(statearr_38090_38159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (15))){
var state_38079__$1 = state_38079;
var statearr_38091_38160 = state_38079__$1;
(statearr_38091_38160[(2)] = null);

(statearr_38091_38160[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (21))){
var inst_37963 = (state_38079[(9)]);
var inst_37972 = (state_38079[(2)]);
var inst_37973 = fluree.db.util.async.throw_err(inst_37972);
var inst_37974 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_37963,inst_37973);
var state_38079__$1 = state_38079;
var statearr_38092_38161 = state_38079__$1;
(statearr_38092_38161[(2)] = inst_37974);

(statearr_38092_38161[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (31))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_38012 = (inst_37951.cljs$core$IFn$_invoke$arity$2 ? inst_37951.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_37933) : inst_37951.call(null,cljs.core._LT_,inst_37933));
var state_38079__$1 = state_38079;
if(cljs.core.truth_(inst_38012)){
var statearr_38093_38162 = state_38079__$1;
(statearr_38093_38162[(1)] = (34));

} else {
var statearr_38094_38163 = state_38079__$1;
(statearr_38094_38163[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (32))){
var inst_38044 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38095_38164 = state_38079__$1;
(statearr_38095_38164[(2)] = inst_38044);

(statearr_38095_38164[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (40))){
var inst_38040 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38096_38165 = state_38079__$1;
(statearr_38096_38165[(2)] = inst_38040);

(statearr_38096_38165[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (33))){
var inst_38009 = (state_38079[(2)]);
var inst_38010 = fluree.db.util.async.throw_err(inst_38009);
var state_38079__$1 = state_38079;
var statearr_38097_38166 = state_38079__$1;
(statearr_38097_38166[(2)] = inst_38010);

(statearr_38097_38166[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (13))){
var inst_38069 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38098_38167 = state_38079__$1;
(statearr_38098_38167[(2)] = inst_38069);

(statearr_38098_38167[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (22))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_37978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37979 = [inst_37932,inst_37934];
var inst_37980 = (new cljs.core.PersistentVector(null,2,(5),inst_37978,inst_37979,null));
var inst_37981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_37980);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(25),inst_37981);
} else {
if((state_val_38080 === (36))){
var inst_38042 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38099_38168 = state_38079__$1;
(statearr_38099_38168[(2)] = inst_38042);

(statearr_38099_38168[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (41))){
var inst_38035 = (state_38079[(2)]);
var inst_38036 = fluree.db.util.async.throw_err(inst_38035);
var state_38079__$1 = state_38079;
var statearr_38100_38169 = state_38079__$1;
(statearr_38100_38169[(2)] = inst_38036);

(statearr_38100_38169[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (43))){
var inst_38051 = (state_38079[(16)]);
var inst_37918 = (state_38079[(14)]);
var inst_38052 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37918,inst_38051);
var state_38079__$1 = state_38079;
var statearr_38101_38170 = state_38079__$1;
(statearr_38101_38170[(2)] = inst_38052);

(statearr_38101_38170[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (29))){
var inst_37996 = (state_38079[(2)]);
var inst_37997 = fluree.db.util.async.throw_err(inst_37996);
var state_38079__$1 = state_38079;
var statearr_38102_38171 = state_38079__$1;
(statearr_38102_38171[(2)] = inst_37997);

(statearr_38102_38171[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (44))){
var inst_38051 = (state_38079[(16)]);
var inst_37918 = (state_38079[(14)]);
var inst_38054 = cljs.core.PersistentHashSet.EMPTY;
var inst_38055 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38054,inst_38051);
var inst_38056 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_37918,inst_38055);
var state_38079__$1 = state_38079;
var statearr_38103_38172 = state_38079__$1;
(statearr_38103_38172[(2)] = inst_38056);

(statearr_38103_38172[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (6))){
var inst_37903 = (state_38079[(17)]);
var inst_37913 = cljs.core.seq(inst_37903);
var inst_37914 = cljs.core.first(inst_37913);
var inst_37915 = cljs.core.next(inst_37913);
var inst_37916 = cljs.core.PersistentHashSet.EMPTY;
var inst_37917 = inst_37903;
var inst_37918 = inst_37916;
var state_38079__$1 = (function (){var statearr_38104 = state_38079;
(statearr_38104[(18)] = inst_37915);

(statearr_38104[(19)] = inst_37914);

(statearr_38104[(14)] = inst_37918);

(statearr_38104[(15)] = inst_37917);

return statearr_38104;
})();
var statearr_38105_38173 = state_38079__$1;
(statearr_38105_38173[(2)] = null);

(statearr_38105_38173[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (28))){
var inst_38046 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38106_38174 = state_38079__$1;
(statearr_38106_38174[(2)] = inst_38046);

(statearr_38106_38174[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (25))){
var inst_37983 = (state_38079[(2)]);
var inst_37984 = fluree.db.util.async.throw_err(inst_37983);
var state_38079__$1 = state_38079;
var statearr_38107_38175 = state_38079__$1;
(statearr_38107_38175[(2)] = inst_37984);

(statearr_38107_38175[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (34))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_38014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38015 = [inst_37932];
var inst_38016 = (new cljs.core.PersistentVector(null,1,(5),inst_38014,inst_38015,null));
var inst_38017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38018 = [inst_37932,inst_37934];
var inst_38019 = (new cljs.core.PersistentVector(null,2,(5),inst_38017,inst_38018,null));
var inst_38020 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38016,cljs.core._LT_,inst_38019);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(37),inst_38020);
} else {
if((state_val_38080 === (17))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_37954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37955 = [inst_37932,inst_37934];
var inst_37956 = (new cljs.core.PersistentVector(null,2,(5),inst_37954,inst_37955,null));
var inst_37957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37958 = [inst_37932];
var inst_37959 = (new cljs.core.PersistentVector(null,1,(5),inst_37957,inst_37958,null));
var inst_37960 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_37956,cljs.core._LT__EQ_,inst_37959);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(20),inst_37960);
} else {
if((state_val_38080 === (3))){
var inst_38077 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38079__$1,inst_38077);
} else {
if((state_val_38080 === (12))){
var inst_37932 = (state_38079[(8)]);
var inst_37924 = (state_38079[(20)]);
var inst_37932__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37924,(0),null);
var inst_37933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37924,(1),null);
var inst_37934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37924,(2),null);
var inst_37935 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_37932__$1);
var inst_37936 = cljs.core.not(inst_37935);
var state_38079__$1 = (function (){var statearr_38108 = state_38079;
(statearr_38108[(10)] = inst_37933);

(statearr_38108[(7)] = inst_37934);

(statearr_38108[(8)] = inst_37932__$1);

return statearr_38108;
})();
if(inst_37936){
var statearr_38109_38176 = state_38079__$1;
(statearr_38109_38176[(1)] = (14));

} else {
var statearr_38110_38177 = state_38079__$1;
(statearr_38110_38177[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (2))){
var inst_37903 = (state_38079[(17)]);
var _ = (function (){var statearr_38111 = state_38079;
(statearr_38111[(4)] = cljs.core.cons((5),(state_38079[(4)])));

return statearr_38111;
})();
var inst_37901 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_37902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37901,(0),null);
var inst_37903__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37901,(1),null);
var inst_37904 = cljs.core.not_empty(inst_37903__$1);
var state_38079__$1 = (function (){var statearr_38112 = state_38079;
(statearr_38112[(21)] = inst_37902);

(statearr_38112[(17)] = inst_37903__$1);

return statearr_38112;
})();
if(cljs.core.truth_(inst_37904)){
var statearr_38113_38178 = state_38079__$1;
(statearr_38113_38178[(1)] = (6));

} else {
var statearr_38114_38179 = state_38079__$1;
(statearr_38114_38179[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (23))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_37986 = (inst_37951.cljs$core$IFn$_invoke$arity$2 ? inst_37951.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_37933) : inst_37951.call(null,cljs.core._GT_,inst_37933));
var state_38079__$1 = state_38079;
if(cljs.core.truth_(inst_37986)){
var statearr_38115_38180 = state_38079__$1;
(statearr_38115_38180[(1)] = (26));

} else {
var statearr_38116_38181 = state_38079__$1;
(statearr_38116_38181[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (47))){
var inst_38067 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38117_38182 = state_38079__$1;
(statearr_38117_38182[(2)] = inst_38067);

(statearr_38117_38182[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (35))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_38025 = (inst_37951.cljs$core$IFn$_invoke$arity$2 ? inst_37951.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_37933) : inst_37951.call(null,cljs.core._LT__EQ_,inst_37933));
var state_38079__$1 = state_38079;
if(cljs.core.truth_(inst_38025)){
var statearr_38118_38183 = state_38079__$1;
(statearr_38118_38183[(1)] = (38));

} else {
var statearr_38119_38184 = state_38079__$1;
(statearr_38119_38184[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (19))){
var inst_37902 = (state_38079[(21)]);
var inst_38050 = (state_38079[(2)]);
var inst_38051 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38050);
var state_38079__$1 = (function (){var statearr_38120 = state_38079;
(statearr_38120[(16)] = inst_38051);

return statearr_38120;
})();
var G__38121_38185 = inst_37902;
var G__38121_38186__$1 = (((G__38121_38185 instanceof cljs.core.Keyword))?G__38121_38185.fqn:null);
switch (G__38121_38186__$1) {
case "or":
var statearr_38122_38188 = state_38079__$1;
(statearr_38122_38188[(1)] = (43));


break;
case "and":
var statearr_38123_38189 = state_38079__$1;
(statearr_38123_38189[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38121_38186__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (11))){
var inst_37918 = (state_38079[(14)]);
var state_38079__$1 = state_38079;
var statearr_38125_38190 = state_38079__$1;
(statearr_38125_38190[(2)] = inst_37918);

(statearr_38125_38190[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (9))){
var inst_37917 = (state_38079[(15)]);
var inst_37924 = (state_38079[(20)]);
var inst_37923 = cljs.core.seq(inst_37917);
var inst_37924__$1 = cljs.core.first(inst_37923);
var inst_37925 = cljs.core.next(inst_37923);
var inst_37926 = cljs.core.not(inst_37924__$1);
var state_38079__$1 = (function (){var statearr_38126 = state_38079;
(statearr_38126[(13)] = inst_37925);

(statearr_38126[(20)] = inst_37924__$1);

return statearr_38126;
})();
if(inst_37926){
var statearr_38127_38191 = state_38079__$1;
(statearr_38127_38191[(1)] = (11));

} else {
var statearr_38128_38192 = state_38079__$1;
(statearr_38128_38192[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (5))){
var _ = (function (){var statearr_38129 = state_38079;
(statearr_38129[(4)] = cljs.core.rest((state_38079[(4)])));

return statearr_38129;
})();
var state_38079__$1 = state_38079;
var ex38124 = (state_38079__$1[(2)]);
var statearr_38130_38193 = state_38079__$1;
(statearr_38130_38193[(5)] = ex38124);


if((ex38124 instanceof Error)){
var statearr_38131_38194 = state_38079__$1;
(statearr_38131_38194[(1)] = (4));

(statearr_38131_38194[(5)] = null);

} else {
throw ex38124;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (14))){
var inst_37932 = (state_38079[(8)]);
var inst_37938 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_37932);
var inst_37939 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37938)].join('');
var inst_37940 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37941 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37942 = cljs.core.PersistentHashMap.fromArrays(inst_37940,inst_37941);
var inst_37943 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37939,inst_37942);
var inst_37944 = (function(){throw inst_37943})();
var state_38079__$1 = state_38079;
var statearr_38132_38195 = state_38079__$1;
(statearr_38132_38195[(2)] = inst_37944);

(statearr_38132_38195[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (45))){
var inst_38059 = (state_38079[(12)]);
var state_38079__$1 = state_38079;
var statearr_38133_38196 = state_38079__$1;
(statearr_38133_38196[(2)] = inst_38059);

(statearr_38133_38196[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (26))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_37988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37989 = [inst_37932,inst_37934];
var inst_37990 = (new cljs.core.PersistentVector(null,2,(5),inst_37988,inst_37989,null));
var inst_37991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37992 = [inst_37932];
var inst_37993 = (new cljs.core.PersistentVector(null,1,(5),inst_37991,inst_37992,null));
var inst_37994 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_37990,cljs.core._LT__EQ_,inst_37993);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(29),inst_37994);
} else {
if((state_val_38080 === (16))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_37947 = (state_38079[(2)]);
var inst_37951__$1 = cljs.core.identical_QMARK_;
var inst_37952 = (inst_37951__$1.cljs$core$IFn$_invoke$arity$2 ? inst_37951__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_37933) : inst_37951__$1.call(null,cljs.core.not_EQ_,inst_37933));
var state_38079__$1 = (function (){var statearr_38134 = state_38079;
(statearr_38134[(22)] = inst_37947);

(statearr_38134[(11)] = inst_37951__$1);

return statearr_38134;
})();
if(cljs.core.truth_(inst_37952)){
var statearr_38135_38197 = state_38079__$1;
(statearr_38135_38197[(1)] = (17));

} else {
var statearr_38136_38198 = state_38079__$1;
(statearr_38136_38198[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (38))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_38027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38028 = [inst_37932];
var inst_38029 = (new cljs.core.PersistentVector(null,1,(5),inst_38027,inst_38028,null));
var inst_38030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38031 = [inst_37932,inst_37934];
var inst_38032 = (new cljs.core.PersistentVector(null,2,(5),inst_38030,inst_38031,null));
var inst_38033 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38029,cljs.core._LT__EQ_,inst_38032);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(41),inst_38033);
} else {
if((state_val_38080 === (30))){
var inst_37934 = (state_38079[(7)]);
var inst_37932 = (state_38079[(8)]);
var inst_38001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38002 = [inst_37932,inst_37934];
var inst_38003 = (new cljs.core.PersistentVector(null,2,(5),inst_38001,inst_38002,null));
var inst_38004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38005 = [inst_37932];
var inst_38006 = (new cljs.core.PersistentVector(null,1,(5),inst_38004,inst_38005,null));
var inst_38007 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38003,cljs.core._LT__EQ_,inst_38006);
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38079__$1,(33),inst_38007);
} else {
if((state_val_38080 === (10))){
var inst_38071 = (state_38079[(2)]);
var state_38079__$1 = state_38079;
var statearr_38137_38199 = state_38079__$1;
(statearr_38137_38199[(2)] = inst_38071);

(statearr_38137_38199[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (18))){
var inst_37933 = (state_38079[(10)]);
var inst_37951 = (state_38079[(11)]);
var inst_37976 = (inst_37951.cljs$core$IFn$_invoke$arity$2 ? inst_37951.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_37933) : inst_37951.call(null,cljs.core._EQ_,inst_37933));
var state_38079__$1 = state_38079;
if(cljs.core.truth_(inst_37976)){
var statearr_38138_38200 = state_38079__$1;
(statearr_38138_38200[(1)] = (22));

} else {
var statearr_38139_38201 = state_38079__$1;
(statearr_38139_38201[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (42))){
var inst_37902 = (state_38079[(21)]);
var inst_38059 = (state_38079[(12)]);
var inst_38059__$1 = (state_38079[(2)]);
var inst_38060 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_37902);
var inst_38061 = cljs.core.empty_QMARK_(inst_38059__$1);
var inst_38062 = ((inst_38060) && (inst_38061));
var state_38079__$1 = (function (){var statearr_38140 = state_38079;
(statearr_38140[(12)] = inst_38059__$1);

return statearr_38140;
})();
if(cljs.core.truth_(inst_38062)){
var statearr_38141_38202 = state_38079__$1;
(statearr_38141_38202[(1)] = (45));

} else {
var statearr_38142_38203 = state_38079__$1;
(statearr_38142_38203[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (37))){
var inst_38022 = (state_38079[(2)]);
var inst_38023 = fluree.db.util.async.throw_err(inst_38022);
var state_38079__$1 = state_38079;
var statearr_38143_38204 = state_38079__$1;
(statearr_38143_38204[(2)] = inst_38023);

(statearr_38143_38204[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38080 === (8))){
var inst_38074 = (state_38079[(2)]);
var _ = (function (){var statearr_38144 = state_38079;
(statearr_38144[(4)] = cljs.core.rest((state_38079[(4)])));

return statearr_38144;
})();
var state_38079__$1 = state_38079;
var statearr_38145_38205 = state_38079__$1;
(statearr_38145_38205[(2)] = inst_38074);

(statearr_38145_38205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38146 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38146[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38146[(1)] = (1));

return statearr_38146;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38079){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38079);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38147){var ex__16304__auto__ = e38147;
var statearr_38148_38206 = state_38079;
(statearr_38148_38206[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38079[(4)]))){
var statearr_38149_38207 = state_38079;
(statearr_38149_38207[(1)] = cljs.core.first((state_38079[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38208 = state_38079;
state_38079 = G__38208;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38079){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38150 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38150[(6)] = c__16375__auto__);

return statearr_38150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__38210,offset,limit){
var map__38211 = p__38210;
var map__38211__$1 = (((((!((map__38211 == null))))?(((((map__38211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38211.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38211):map__38211);
var res = map__38211__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38211__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38211__$1,cljs.core.cst$kw$tuples);
var vec__38213 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38213,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38213,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__38216 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__38209_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__38209_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__38216__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__38216):G__38216);
var G__38216__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__38216__$1):G__38216__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__38216__$2);
} else {
return G__38216__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__38217_SHARP_){
return ((typeof p1__38217_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__38217_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__38218_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__38218_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__38222 = vars;
var vec__38223 = G__38222;
var seq__38224 = cljs.core.seq(vec__38223);
var first__38225 = cljs.core.first(seq__38224);
var seq__38224__$1 = cljs.core.next(seq__38224);
var var$ = first__38225;
var r = seq__38224__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__38222__$1 = G__38222;
var all_vars__$1 = all_vars;
while(true){
var vec__38230 = G__38222__$1;
var seq__38231 = cljs.core.seq(vec__38230);
var first__38232 = cljs.core.first(seq__38231);
var seq__38231__$1 = cljs.core.next(seq__38231);
var var$__$1 = first__38232;
var r__$1 = seq__38231__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__38233 = cljs.core.set(all_vars__$2);
return (fexpr__38233.cljs$core$IFn$_invoke$arity$1 ? fexpr__38233.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__38233.call(null,var$__$1));
})())){
var G__38234 = r__$1;
var G__38235 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__38222__$1 = G__38234;
all_vars__$1 = G__38235;
continue;
} else {
var G__38236 = r__$1;
var G__38237 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__38222__$1 = G__38236;
all_vars__$1 = G__38237;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38272){
var state_val_38273 = (state_38272[(1)]);
if((state_val_38273 === (1))){
var inst_38245 = functionArray;
var inst_38246 = cljs.core.seq(inst_38245);
var inst_38247 = cljs.core.first(inst_38246);
var inst_38248 = cljs.core.next(inst_38246);
var inst_38249 = cljs.core.PersistentVector.EMPTY;
var inst_38250 = inst_38245;
var inst_38251 = inst_38249;
var state_38272__$1 = (function (){var statearr_38274 = state_38272;
(statearr_38274[(7)] = inst_38247);

(statearr_38274[(8)] = inst_38251);

(statearr_38274[(9)] = inst_38248);

(statearr_38274[(10)] = inst_38250);

return statearr_38274;
})();
var statearr_38275_38288 = state_38272__$1;
(statearr_38275_38288[(2)] = null);

(statearr_38275_38288[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38273 === (2))){
var inst_38257 = (state_38272[(11)]);
var inst_38250 = (state_38272[(10)]);
var inst_38256 = cljs.core.seq(inst_38250);
var inst_38257__$1 = cljs.core.first(inst_38256);
var inst_38258 = cljs.core.next(inst_38256);
var state_38272__$1 = (function (){var statearr_38276 = state_38272;
(statearr_38276[(12)] = inst_38258);

(statearr_38276[(11)] = inst_38257__$1);

return statearr_38276;
})();
if(cljs.core.truth_(inst_38257__$1)){
var statearr_38277_38289 = state_38272__$1;
(statearr_38277_38289[(1)] = (4));

} else {
var statearr_38278_38290 = state_38272__$1;
(statearr_38278_38290[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38273 === (3))){
var inst_38270 = (state_38272[(2)]);
var state_38272__$1 = state_38272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38272__$1,inst_38270);
} else {
if((state_val_38273 === (4))){
var inst_38257 = (state_38272[(11)]);
var inst_38260 = (inst_38257.cljs$core$IFn$_invoke$arity$1 ? inst_38257.cljs$core$IFn$_invoke$arity$1(tuple) : inst_38257.call(null,tuple));
var state_38272__$1 = state_38272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38272__$1,(7),inst_38260);
} else {
if((state_val_38273 === (5))){
var inst_38251 = (state_38272[(8)]);
var state_38272__$1 = state_38272;
var statearr_38279_38291 = state_38272__$1;
(statearr_38279_38291[(2)] = inst_38251);

(statearr_38279_38291[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38273 === (6))){
var inst_38268 = (state_38272[(2)]);
var state_38272__$1 = state_38272;
var statearr_38280_38292 = state_38272__$1;
(statearr_38280_38292[(2)] = inst_38268);

(statearr_38280_38292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38273 === (7))){
var inst_38258 = (state_38272[(12)]);
var inst_38251 = (state_38272[(8)]);
var inst_38262 = (state_38272[(2)]);
var inst_38263 = fluree.db.util.async.throw_err(inst_38262);
var inst_38264 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38251,inst_38263);
var inst_38250 = inst_38258;
var inst_38251__$1 = inst_38264;
var state_38272__$1 = (function (){var statearr_38281 = state_38272;
(statearr_38281[(8)] = inst_38251__$1);

(statearr_38281[(10)] = inst_38250);

return statearr_38281;
})();
var statearr_38282_38293 = state_38272__$1;
(statearr_38282_38293[(2)] = null);

(statearr_38282_38293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0 = (function (){
var statearr_38283 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38283[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__);

(statearr_38283[(1)] = (1));

return statearr_38283;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1 = (function (state_38272){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38272);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38284){var ex__16304__auto__ = e38284;
var statearr_38285_38294 = state_38272;
(statearr_38285_38294[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38272[(4)]))){
var statearr_38286_38295 = state_38272;
(statearr_38286_38295[(1)] = cljs.core.first((state_38272[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38296 = state_38272;
state_38272 = G__38296;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = function(state_38272){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1.call(this,state_38272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38287 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38287[(6)] = c__16375__auto__);

return statearr_38287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__38298,headers,vars,opts){
var map__38299 = p__38298;
var map__38299__$1 = (((((!((map__38299 == null))))?(((((map__38299.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38299.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38299):map__38299);
var select_spec = map__38299__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38299__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38299__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38299__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38299__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38386){
var state_val_38387 = (state_38386[(1)]);
if((state_val_38387 === (7))){
var state_38386__$1 = state_38386;
var statearr_38388_38530 = state_38386__$1;
(statearr_38388_38530[(2)] = null);

(statearr_38388_38530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (1))){
var state_38386__$1 = state_38386;
var statearr_38389_38531 = state_38386__$1;
(statearr_38389_38531[(2)] = null);

(statearr_38389_38531[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (4))){
var inst_38301 = (state_38386[(2)]);
var state_38386__$1 = state_38386;
var statearr_38390_38532 = state_38386__$1;
(statearr_38390_38532[(2)] = inst_38301);

(statearr_38390_38532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (15))){
var inst_38375 = (state_38386[(2)]);
var inst_38376 = fluree.db.util.async.throw_err(inst_38375);
var state_38386__$1 = state_38386;
var statearr_38391_38533 = state_38386__$1;
(statearr_38391_38533[(2)] = inst_38376);

(statearr_38391_38533[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (13))){
var inst_38319 = (state_38386[(7)]);
var inst_38311 = (state_38386[(8)]);
var inst_38378 = (function (){var pp = inst_38311;
var functionArray = inst_38319;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38297_SHARP_){
return (p1__38297_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38297_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__38297_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_38379 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38378,tuples);
var state_38386__$1 = state_38386;
var statearr_38392_38534 = state_38386__$1;
(statearr_38392_38534[(2)] = inst_38379);

(statearr_38392_38534[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (6))){
var inst_38308 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_38386__$1 = state_38386;
var statearr_38393_38535 = state_38386__$1;
(statearr_38393_38535[(2)] = inst_38308);

(statearr_38393_38535[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (3))){
var inst_38384 = (state_38386[(2)]);
var state_38386__$1 = state_38386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38386__$1,inst_38384);
} else {
if((state_val_38387 === (12))){
var inst_38319 = (state_38386[(7)]);
var inst_38311 = (state_38386[(8)]);
var inst_38371 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38372 = (function (){var pp = inst_38311;
var functionArray = inst_38319;
var c__16375__auto____$1 = inst_38371;
return (function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38369){
var state_val_38370 = (state_38369[(1)]);
if((state_val_38370 === (7))){
var inst_38345 = (state_38369[(2)]);
var inst_38346 = fluree.db.util.async.throw_err(inst_38345);
var state_38369__$1 = (function (){var statearr_38394 = state_38369;
(statearr_38394[(7)] = inst_38346);

return statearr_38394;
})();
if(cljs.core.truth_(pp)){
var statearr_38395_38536 = state_38369__$1;
(statearr_38395_38536[(1)] = (8));

} else {
var statearr_38396_38537 = state_38369__$1;
(statearr_38396_38537[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (1))){
var inst_38328 = tuples;
var inst_38329 = cljs.core.seq(inst_38328);
var inst_38330 = cljs.core.first(inst_38329);
var inst_38331 = cljs.core.next(inst_38329);
var inst_38332 = cljs.core.PersistentVector.EMPTY;
var inst_38333 = inst_38328;
var inst_38334 = inst_38332;
var state_38369__$1 = (function (){var statearr_38397 = state_38369;
(statearr_38397[(8)] = inst_38334);

(statearr_38397[(9)] = inst_38333);

(statearr_38397[(10)] = inst_38331);

(statearr_38397[(11)] = inst_38330);

return statearr_38397;
})();
var statearr_38398_38538 = state_38369__$1;
(statearr_38398_38538[(2)] = null);

(statearr_38398_38538[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (4))){
var inst_38340 = (state_38369[(12)]);
var inst_38343 = fluree.db.query.fql.format_tuple(functionArray,inst_38340);
var state_38369__$1 = state_38369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38369__$1,(7),inst_38343);
} else {
if((state_val_38370 === (15))){
var state_38369__$1 = state_38369;
var statearr_38399_38539 = state_38369__$1;
(statearr_38399_38539[(2)] = null);

(statearr_38399_38539[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (13))){
var inst_38358 = (state_38369[(2)]);
var state_38369__$1 = state_38369;
var statearr_38400_38540 = state_38369__$1;
(statearr_38400_38540[(2)] = inst_38358);

(statearr_38400_38540[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (6))){
var inst_38365 = (state_38369[(2)]);
var state_38369__$1 = state_38369;
var statearr_38401_38541 = state_38369__$1;
(statearr_38401_38541[(2)] = inst_38365);

(statearr_38401_38541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (3))){
var inst_38367 = (state_38369[(2)]);
var state_38369__$1 = state_38369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38369__$1,inst_38367);
} else {
if((state_val_38370 === (12))){
var state_38369__$1 = state_38369;
var statearr_38402_38542 = state_38369__$1;
(statearr_38402_38542[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (2))){
var inst_38333 = (state_38369[(9)]);
var inst_38340 = (state_38369[(12)]);
var inst_38339 = cljs.core.seq(inst_38333);
var inst_38340__$1 = cljs.core.first(inst_38339);
var inst_38341 = cljs.core.next(inst_38339);
var state_38369__$1 = (function (){var statearr_38404 = state_38369;
(statearr_38404[(13)] = inst_38341);

(statearr_38404[(12)] = inst_38340__$1);

return statearr_38404;
})();
if(cljs.core.truth_(inst_38340__$1)){
var statearr_38405_38543 = state_38369__$1;
(statearr_38405_38543[(1)] = (4));

} else {
var statearr_38406_38544 = state_38369__$1;
(statearr_38406_38544[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (11))){
var inst_38346 = (state_38369[(7)]);
var state_38369__$1 = state_38369;
var statearr_38407_38545 = state_38369__$1;
(statearr_38407_38545[(2)] = inst_38346);

(statearr_38407_38545[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (9))){
var state_38369__$1 = state_38369;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_38408_38546 = state_38369__$1;
(statearr_38408_38546[(1)] = (11));

} else {
var statearr_38409_38547 = state_38369__$1;
(statearr_38409_38547[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (5))){
var inst_38334 = (state_38369[(8)]);
var state_38369__$1 = state_38369;
var statearr_38410_38548 = state_38369__$1;
(statearr_38410_38548[(2)] = inst_38334);

(statearr_38410_38548[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (14))){
var inst_38346 = (state_38369[(7)]);
var inst_38353 = cljs.core.first(inst_38346);
var state_38369__$1 = state_38369;
var statearr_38411_38549 = state_38369__$1;
(statearr_38411_38549[(2)] = inst_38353);

(statearr_38411_38549[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (16))){
var inst_38356 = (state_38369[(2)]);
var state_38369__$1 = state_38369;
var statearr_38412_38550 = state_38369__$1;
(statearr_38412_38550[(2)] = inst_38356);

(statearr_38412_38550[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (10))){
var inst_38341 = (state_38369[(13)]);
var inst_38334 = (state_38369[(8)]);
var inst_38360 = (state_38369[(2)]);
var inst_38361 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38334,inst_38360);
var inst_38333 = inst_38341;
var inst_38334__$1 = inst_38361;
var state_38369__$1 = (function (){var statearr_38413 = state_38369;
(statearr_38413[(8)] = inst_38334__$1);

(statearr_38413[(9)] = inst_38333);

return statearr_38413;
})();
var statearr_38414_38551 = state_38369__$1;
(statearr_38414_38551[(2)] = null);

(statearr_38414_38551[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38370 === (8))){
var inst_38346 = (state_38369[(7)]);
var inst_38348 = cljs.core.zipmap(pp,inst_38346);
var state_38369__$1 = state_38369;
var statearr_38415_38552 = state_38369__$1;
(statearr_38415_38552[(2)] = inst_38348);

(statearr_38415_38552[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_38416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38416[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_38416[(1)] = (1));

return statearr_38416;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_38369){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38369);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38417){var ex__16304__auto__ = e38417;
var statearr_38418_38553 = state_38369;
(statearr_38418_38553[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38369[(4)]))){
var statearr_38419_38554 = state_38369;
(statearr_38419_38554[(1)] = cljs.core.first((state_38369[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38555 = state_38369;
state_38369 = G__38555;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_38369){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_38369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38420 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38420[(6)] = c__16375__auto____$1);

return statearr_38420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
});
})();
var inst_38373 = cljs.core.async.impl.dispatch.run(inst_38372);
var state_38386__$1 = (function (){var statearr_38421 = state_38386;
(statearr_38421[(9)] = inst_38373);

return statearr_38421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38386__$1,(15),inst_38371);
} else {
if((state_val_38387 === (2))){
var _ = (function (){var statearr_38422 = state_38386;
(statearr_38422[(4)] = cljs.core.cons((5),(state_38386[(4)])));

return statearr_38422;
})();
var state_38386__$1 = state_38386;
if(cljs.core.truth_(prettyPrint)){
var statearr_38423_38556 = state_38386__$1;
(statearr_38423_38556[(1)] = (6));

} else {
var statearr_38424_38557 = state_38386__$1;
(statearr_38424_38557[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (11))){
var inst_38319 = (state_38386[(2)]);
var state_38386__$1 = (function (){var statearr_38426 = state_38386;
(statearr_38426[(7)] = inst_38319);

return statearr_38426;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_38427_38558 = state_38386__$1;
(statearr_38427_38558[(1)] = (12));

} else {
var statearr_38428_38559 = state_38386__$1;
(statearr_38428_38559[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (9))){
var inst_38311 = (state_38386[(8)]);
var inst_38313 = (function (){var pp = inst_38311;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38463){
var state_val_38464 = (state_38463[(1)]);
if((state_val_38464 === (7))){
var state_38463__$1 = state_38463;
var statearr_38465_38560 = state_38463__$1;
(statearr_38465_38560[(2)] = null);

(statearr_38465_38560[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (1))){
var state_38463__$1 = state_38463;
var statearr_38466_38561 = state_38463__$1;
(statearr_38466_38561[(2)] = null);

(statearr_38466_38561[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (4))){
var inst_38429 = (state_38463[(2)]);
var state_38463__$1 = state_38463;
var statearr_38467_38562 = state_38463__$1;
(statearr_38467_38562[(2)] = inst_38429);

(statearr_38467_38562[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (6))){
var inst_38439 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_38440 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_38441 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_38442 = [inst_38440,inst_38441,opts];
var inst_38443 = cljs.core.PersistentHashMap.fromArrays(inst_38439,inst_38442);
var inst_38444 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_38443) : fluree.db.query.fql.query.call(null,db,inst_38443));
var state_38463__$1 = state_38463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38463__$1,(9),inst_38444);
} else {
if((state_val_38464 === (3))){
var inst_38461 = (state_38463[(2)]);
var state_38463__$1 = state_38463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38463__$1,inst_38461);
} else {
if((state_val_38464 === (12))){
var inst_38455 = (state_38463[(2)]);
var state_38463__$1 = state_38463;
var statearr_38468_38563 = state_38463__$1;
(statearr_38468_38563[(2)] = inst_38455);

(statearr_38468_38563[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (2))){
var _ = (function (){var statearr_38469 = state_38463;
(statearr_38469[(4)] = cljs.core.cons((5),(state_38463[(4)])));

return statearr_38469;
})();
var inst_38435 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_38463__$1 = state_38463;
if(cljs.core.truth_(inst_38435)){
var statearr_38470_38564 = state_38463__$1;
(statearr_38470_38564[(1)] = (6));

} else {
var statearr_38471_38565 = state_38463__$1;
(statearr_38471_38565[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (11))){
var inst_38450 = [cljs.core.cst$kw$_id];
var inst_38451 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_38452 = [inst_38451];
var inst_38453 = cljs.core.PersistentHashMap.fromArrays(inst_38450,inst_38452);
var state_38463__$1 = state_38463;
var statearr_38473_38566 = state_38463__$1;
(statearr_38473_38566[(2)] = inst_38453);

(statearr_38473_38566[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (9))){
var inst_38447 = (state_38463[(7)]);
var inst_38446 = (state_38463[(2)]);
var inst_38447__$1 = fluree.db.util.async.throw_err(inst_38446);
var state_38463__$1 = (function (){var statearr_38474 = state_38463;
(statearr_38474[(7)] = inst_38447__$1);

return statearr_38474;
})();
if(cljs.core.truth_(inst_38447__$1)){
var statearr_38475_38567 = state_38463__$1;
(statearr_38475_38567[(1)] = (10));

} else {
var statearr_38476_38568 = state_38463__$1;
(statearr_38476_38568[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (5))){
var _ = (function (){var statearr_38477 = state_38463;
(statearr_38477[(4)] = cljs.core.rest((state_38463[(4)])));

return statearr_38477;
})();
var state_38463__$1 = state_38463;
var ex38472 = (state_38463__$1[(2)]);
var statearr_38478_38569 = state_38463__$1;
(statearr_38478_38569[(5)] = ex38472);


if((ex38472 instanceof Error)){
var statearr_38479_38570 = state_38463__$1;
(statearr_38479_38570[(1)] = (4));

(statearr_38479_38570[(5)] = null);

} else {
throw ex38472;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (10))){
var inst_38447 = (state_38463[(7)]);
var state_38463__$1 = state_38463;
var statearr_38480_38571 = state_38463__$1;
(statearr_38480_38571[(2)] = inst_38447);

(statearr_38480_38571[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38464 === (8))){
var inst_38458 = (state_38463[(2)]);
var _ = (function (){var statearr_38481 = state_38463;
(statearr_38481[(4)] = cljs.core.rest((state_38463[(4)])));

return statearr_38481;
})();
var state_38463__$1 = state_38463;
var statearr_38482_38572 = state_38463__$1;
(statearr_38482_38572[(2)] = inst_38458);

(statearr_38482_38572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_38483 = [null,null,null,null,null,null,null,null];
(statearr_38483[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_38483[(1)] = (1));

return statearr_38483;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_38463){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38463);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38484){var ex__16304__auto__ = e38484;
var statearr_38485_38573 = state_38463;
(statearr_38485_38573[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38463[(4)]))){
var statearr_38486_38574 = state_38463;
(statearr_38486_38574[(1)] = cljs.core.first((state_38463[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38575 = state_38463;
state_38463 = G__38575;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_38463){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_38463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38487 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38487[(6)] = c__16375__auto____$1);

return statearr_38487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
} else {
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38499){
var state_val_38500 = (state_38499[(1)]);
if((state_val_38500 === (1))){
var state_38499__$1 = state_38499;
var statearr_38501_38576 = state_38499__$1;
(statearr_38501_38576[(2)] = null);

(statearr_38501_38576[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38500 === (2))){
var _ = (function (){var statearr_38502 = state_38499;
(statearr_38502[(4)] = cljs.core.cons((5),(state_38499[(4)])));

return statearr_38502;
})();
var inst_38494 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_38503 = state_38499;
(statearr_38503[(4)] = cljs.core.rest((state_38499[(4)])));

return statearr_38503;
})();
var state_38499__$1 = state_38499;
var statearr_38504_38577 = state_38499__$1;
(statearr_38504_38577[(2)] = inst_38494);

(statearr_38504_38577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38500 === (3))){
var inst_38497 = (state_38499[(2)]);
var state_38499__$1 = state_38499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38499__$1,inst_38497);
} else {
if((state_val_38500 === (4))){
var inst_38488 = (state_38499[(2)]);
var state_38499__$1 = state_38499;
var statearr_38506_38578 = state_38499__$1;
(statearr_38506_38578[(2)] = inst_38488);

(statearr_38506_38578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38500 === (5))){
var _ = (function (){var statearr_38507 = state_38499;
(statearr_38507[(4)] = cljs.core.rest((state_38499[(4)])));

return statearr_38507;
})();
var state_38499__$1 = state_38499;
var ex38505 = (state_38499__$1[(2)]);
var statearr_38508_38579 = state_38499__$1;
(statearr_38508_38579[(5)] = ex38505);


if((ex38505 instanceof Error)){
var statearr_38509_38580 = state_38499__$1;
(statearr_38509_38580[(1)] = (4));

(statearr_38509_38580[(5)] = null);

} else {
throw ex38505;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_38510 = [null,null,null,null,null,null,null];
(statearr_38510[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_38510[(1)] = (1));

return statearr_38510;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_38499){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38499);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38511){var ex__16304__auto__ = e38511;
var statearr_38512_38581 = state_38499;
(statearr_38512_38581[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38499[(4)]))){
var statearr_38513_38582 = state_38499;
(statearr_38513_38582[(1)] = cljs.core.first((state_38499[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38583 = state_38499;
state_38499 = G__38583;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_38499){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_38499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38514 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38514[(6)] = c__16375__auto____$1);

return statearr_38514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
}
});
})();
var inst_38314 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38313,select);
var state_38386__$1 = state_38386;
var statearr_38515_38584 = state_38386__$1;
(statearr_38515_38584[(2)] = inst_38314);

(statearr_38515_38584[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (5))){
var _ = (function (){var statearr_38516 = state_38386;
(statearr_38516[(4)] = cljs.core.rest((state_38386[(4)])));

return statearr_38516;
})();
var state_38386__$1 = state_38386;
var ex38425 = (state_38386__$1[(2)]);
var statearr_38517_38585 = state_38386__$1;
(statearr_38517_38585[(5)] = ex38425);


if((ex38425 instanceof Error)){
var statearr_38518_38586 = state_38386__$1;
(statearr_38518_38586[(1)] = (4));

(statearr_38518_38586[(5)] = null);

} else {
throw ex38425;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (14))){
var inst_38381 = (state_38386[(2)]);
var _ = (function (){var statearr_38519 = state_38386;
(statearr_38519[(4)] = cljs.core.rest((state_38386[(4)])));

return statearr_38519;
})();
var state_38386__$1 = state_38386;
var statearr_38520_38587 = state_38386__$1;
(statearr_38520_38587[(2)] = inst_38381);

(statearr_38520_38587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (10))){
var inst_38311 = (state_38386[(8)]);
var inst_38316 = (function (){var pp = inst_38311;
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_38317 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38316,select);
var state_38386__$1 = state_38386;
var statearr_38521_38588 = state_38386__$1;
(statearr_38521_38588[(2)] = inst_38317);

(statearr_38521_38588[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38387 === (8))){
var inst_38311 = (state_38386[(2)]);
var state_38386__$1 = (function (){var statearr_38522 = state_38386;
(statearr_38522[(8)] = inst_38311);

return statearr_38522;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_38523_38589 = state_38386__$1;
(statearr_38523_38589[(1)] = (9));

} else {
var statearr_38524_38590 = state_38386__$1;
(statearr_38524_38590[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_38525 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38525[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_38525[(1)] = (1));

return statearr_38525;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_38386){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38386);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38526){var ex__16304__auto__ = e38526;
var statearr_38527_38591 = state_38386;
(statearr_38527_38591[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38386[(4)]))){
var statearr_38528_38592 = state_38386;
(statearr_38528_38592[(1)] = cljs.core.first((state_38386[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38593 = state_38386;
state_38386 = G__38593;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_38386){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_38386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38529 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38529[(6)] = c__16375__auto__);

return statearr_38529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__38595 = arguments.length;
switch (G__38595) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__38596,p__38597,group_limit,opts){
var map__38598 = p__38596;
var map__38598__$1 = (((((!((map__38598 == null))))?(((((map__38598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38598.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38598):map__38598);
var res = map__38598__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38598__$1,cljs.core.cst$kw$vars);
var map__38599 = p__38597;
var map__38599__$1 = (((((!((map__38599 == null))))?(((((map__38599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38599):map__38599);
var select_spec = map__38599__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38599__$1,cljs.core.cst$kw$groupBy);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38695){
var state_val_38696 = (state_38695[(1)]);
if((state_val_38696 === (7))){
var inst_38608 = (state_38695[(7)]);
var state_38695__$1 = state_38695;
var statearr_38697_38763 = state_38695__$1;
(statearr_38697_38763[(2)] = inst_38608);

(statearr_38697_38763[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (20))){
var inst_38643 = (state_38695[(2)]);
var state_38695__$1 = (function (){var statearr_38698 = state_38695;
(statearr_38698[(8)] = inst_38643);

return statearr_38698;
})();
if(cljs.core.truth_(groupBy)){
var statearr_38699_38764 = state_38695__$1;
(statearr_38699_38764[(1)] = (21));

} else {
var statearr_38700_38765 = state_38695__$1;
(statearr_38700_38765[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (27))){
var inst_38652 = (state_38695[(9)]);
var inst_38657 = inst_38652.cljs$lang$protocol_mask$partition0$;
var inst_38658 = (inst_38657 & (64));
var inst_38659 = inst_38652.cljs$core$ISeq$;
var inst_38660 = (cljs.core.PROTOCOL_SENTINEL === inst_38659);
var inst_38661 = ((inst_38658) || (inst_38660));
var state_38695__$1 = state_38695;
if(cljs.core.truth_(inst_38661)){
var statearr_38701_38766 = state_38695__$1;
(statearr_38701_38766[(1)] = (30));

} else {
var statearr_38702_38767 = state_38695__$1;
(statearr_38702_38767[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (1))){
var state_38695__$1 = state_38695;
var statearr_38703_38768 = state_38695__$1;
(statearr_38703_38768[(2)] = null);

(statearr_38703_38768[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (24))){
var inst_38647 = (state_38695[(10)]);
var inst_38643 = (state_38695[(8)]);
var inst_38649 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_38643,inst_38647,group_limit);
var state_38695__$1 = state_38695;
var statearr_38704_38769 = state_38695__$1;
(statearr_38704_38769[(2)] = inst_38649);

(statearr_38704_38769[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (39))){
var inst_38688 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
var statearr_38705_38770 = state_38695__$1;
(statearr_38705_38770[(2)] = inst_38688);

(statearr_38705_38770[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (4))){
var inst_38602 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
var statearr_38706_38771 = state_38695__$1;
(statearr_38706_38771[(2)] = inst_38602);

(statearr_38706_38771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (15))){
var inst_38629 = (state_38695[(11)]);
var inst_38631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38632 = [inst_38629];
var inst_38633 = (new cljs.core.PersistentVector(null,1,(5),inst_38631,inst_38632,null));
var state_38695__$1 = state_38695;
var statearr_38707_38772 = state_38695__$1;
(statearr_38707_38772[(2)] = inst_38633);

(statearr_38707_38772[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (21))){
var state_38695__$1 = state_38695;
var statearr_38708_38773 = state_38695__$1;
(statearr_38708_38773[(2)] = (0));

(statearr_38708_38773[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (31))){
var state_38695__$1 = state_38695;
var statearr_38709_38774 = state_38695__$1;
(statearr_38709_38774[(2)] = false);

(statearr_38709_38774[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (32))){
var inst_38665 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
var statearr_38710_38775 = state_38695__$1;
(statearr_38710_38775[(2)] = inst_38665);

(statearr_38710_38775[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (33))){
var inst_38652 = (state_38695[(9)]);
var inst_38670 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38652);
var state_38695__$1 = state_38695;
var statearr_38711_38776 = state_38695__$1;
(statearr_38711_38776[(2)] = inst_38670);

(statearr_38711_38776[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (13))){
var inst_38618 = (state_38695[(12)]);
var state_38695__$1 = state_38695;
var statearr_38712_38777 = state_38695__$1;
(statearr_38712_38777[(2)] = inst_38618);

(statearr_38712_38777[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (22))){
var state_38695__$1 = state_38695;
var statearr_38713_38778 = state_38695__$1;
(statearr_38713_38778[(2)] = offset);

(statearr_38713_38778[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (36))){
var inst_38679 = (state_38695[(2)]);
var inst_38680 = fluree.db.util.async.throw_err(inst_38679);
var state_38695__$1 = (function (){var statearr_38714 = state_38695;
(statearr_38714[(13)] = inst_38680);

return statearr_38714;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_38715_38779 = state_38695__$1;
(statearr_38715_38779[(1)] = (37));

} else {
var statearr_38716_38780 = state_38695__$1;
(statearr_38716_38780[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (29))){
var inst_38668 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
if(cljs.core.truth_(inst_38668)){
var statearr_38717_38781 = state_38695__$1;
(statearr_38717_38781[(1)] = (33));

} else {
var statearr_38718_38782 = state_38695__$1;
(statearr_38718_38782[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (6))){
var inst_38610 = cljs.core.count(select);
var inst_38611 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_38610);
var state_38695__$1 = state_38695;
var statearr_38719_38783 = state_38695__$1;
(statearr_38719_38783[(2)] = inst_38611);

(statearr_38719_38783[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (28))){
var state_38695__$1 = state_38695;
var statearr_38720_38784 = state_38695__$1;
(statearr_38720_38784[(2)] = false);

(statearr_38720_38784[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (25))){
var inst_38643 = (state_38695[(8)]);
var state_38695__$1 = state_38695;
var statearr_38721_38785 = state_38695__$1;
(statearr_38721_38785[(2)] = inst_38643);

(statearr_38721_38785[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (34))){
var inst_38652 = (state_38695[(9)]);
var state_38695__$1 = state_38695;
var statearr_38722_38786 = state_38695__$1;
(statearr_38722_38786[(2)] = inst_38652);

(statearr_38722_38786[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (17))){
var inst_38636 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
var statearr_38723_38787 = state_38695__$1;
(statearr_38723_38787[(2)] = inst_38636);

(statearr_38723_38787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (3))){
var inst_38693 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38695__$1,inst_38693);
} else {
if((state_val_38696 === (12))){
var inst_38618 = (state_38695[(12)]);
var inst_38620 = cljs.core.first(select);
var inst_38621 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_38620);
var inst_38622 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38621);
var inst_38623 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_38622,(1));
var inst_38624 = [inst_38623];
var inst_38625 = [inst_38618];
var inst_38626 = cljs.core.PersistentHashMap.fromArrays(inst_38624,inst_38625);
var state_38695__$1 = state_38695;
var statearr_38724_38788 = state_38695__$1;
(statearr_38724_38788[(2)] = inst_38626);

(statearr_38724_38788[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (2))){
var inst_38608 = (state_38695[(7)]);
var _ = (function (){var statearr_38725 = state_38695;
(statearr_38725[(4)] = cljs.core.cons((5),(state_38695[(4)])));

return statearr_38725;
})();
var inst_38608__$1 = aggregates;
var state_38695__$1 = (function (){var statearr_38726 = state_38695;
(statearr_38726[(7)] = inst_38608__$1);

return statearr_38726;
})();
if(cljs.core.truth_(inst_38608__$1)){
var statearr_38727_38789 = state_38695__$1;
(statearr_38727_38789[(1)] = (6));

} else {
var statearr_38728_38790 = state_38695__$1;
(statearr_38728_38790[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (23))){
var inst_38647 = (state_38695[(2)]);
var state_38695__$1 = (function (){var statearr_38729 = state_38695;
(statearr_38729[(10)] = inst_38647);

return statearr_38729;
})();
if(cljs.core.truth_(orderBy)){
var statearr_38730_38791 = state_38695__$1;
(statearr_38730_38791[(1)] = (24));

} else {
var statearr_38731_38792 = state_38695__$1;
(statearr_38731_38792[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (35))){
var inst_38673 = (state_38695[(2)]);
var inst_38674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38673,cljs.core.cst$kw$headers);
var inst_38675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38673,cljs.core.cst$kw$tuples);
var inst_38676 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_38677 = fluree.db.query.fql.format_filter_tuples(db,inst_38675,select_spec,inst_38674,vars,inst_38676);
var state_38695__$1 = state_38695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38695__$1,(36),inst_38677);
} else {
if((state_val_38696 === (19))){
var state_38695__$1 = state_38695;
var statearr_38732_38793 = state_38695__$1;
(statearr_38732_38793[(2)] = res);

(statearr_38732_38793[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (11))){
var inst_38690 = (state_38695[(2)]);
var _ = (function (){var statearr_38734 = state_38695;
(statearr_38734[(4)] = cljs.core.rest((state_38695[(4)])));

return statearr_38734;
})();
var state_38695__$1 = state_38695;
var statearr_38735_38794 = state_38695__$1;
(statearr_38735_38794[(2)] = inst_38690);

(statearr_38735_38794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (9))){
var inst_38616 = cljs.core.first(aggregates);
var inst_38617 = fluree.db.query.analytical.calculate_aggregate(res,inst_38616);
var inst_38618 = cljs.core.second(inst_38617);
var state_38695__$1 = (function (){var statearr_38736 = state_38695;
(statearr_38736[(12)] = inst_38618);

return statearr_38736;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_38737_38795 = state_38695__$1;
(statearr_38737_38795[(1)] = (12));

} else {
var statearr_38738_38796 = state_38695__$1;
(statearr_38738_38796[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (5))){
var _ = (function (){var statearr_38739 = state_38695;
(statearr_38739[(4)] = cljs.core.rest((state_38695[(4)])));

return statearr_38739;
})();
var state_38695__$1 = state_38695;
var ex38733 = (state_38695__$1[(2)]);
var statearr_38740_38797 = state_38695__$1;
(statearr_38740_38797[(5)] = ex38733);


if((ex38733 instanceof Error)){
var statearr_38741_38798 = state_38695__$1;
(statearr_38741_38798[(1)] = (4));

(statearr_38741_38798[(5)] = null);

} else {
throw ex38733;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (14))){
var inst_38629 = (state_38695[(2)]);
var state_38695__$1 = (function (){var statearr_38742 = state_38695;
(statearr_38742[(11)] = inst_38629);

return statearr_38742;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_38743_38799 = state_38695__$1;
(statearr_38743_38799[(1)] = (15));

} else {
var statearr_38744_38800 = state_38695__$1;
(statearr_38744_38800[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (26))){
var inst_38652 = (state_38695[(9)]);
var inst_38652__$1 = (state_38695[(2)]);
var inst_38654 = (inst_38652__$1 == null);
var inst_38655 = cljs.core.not(inst_38654);
var state_38695__$1 = (function (){var statearr_38745 = state_38695;
(statearr_38745[(9)] = inst_38652__$1);

return statearr_38745;
})();
if(inst_38655){
var statearr_38746_38801 = state_38695__$1;
(statearr_38746_38801[(1)] = (27));

} else {
var statearr_38747_38802 = state_38695__$1;
(statearr_38747_38802[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (16))){
var inst_38629 = (state_38695[(11)]);
var state_38695__$1 = state_38695;
var statearr_38748_38803 = state_38695__$1;
(statearr_38748_38803[(2)] = inst_38629);

(statearr_38748_38803[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (38))){
var inst_38680 = (state_38695[(13)]);
var state_38695__$1 = state_38695;
var statearr_38749_38804 = state_38695__$1;
(statearr_38749_38804[(2)] = inst_38680);

(statearr_38749_38804[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (30))){
var state_38695__$1 = state_38695;
var statearr_38750_38805 = state_38695__$1;
(statearr_38750_38805[(2)] = true);

(statearr_38750_38805[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (10))){
var state_38695__$1 = state_38695;
if(cljs.core.truth_(aggregates)){
var statearr_38751_38806 = state_38695__$1;
(statearr_38751_38806[(1)] = (18));

} else {
var statearr_38752_38807 = state_38695__$1;
(statearr_38752_38807[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (18))){
var inst_38640 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_38695__$1 = state_38695;
var statearr_38753_38808 = state_38695__$1;
(statearr_38753_38808[(2)] = inst_38640);

(statearr_38753_38808[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (37))){
var inst_38680 = (state_38695[(13)]);
var inst_38682 = cljs.core.PersistentVector.EMPTY;
var inst_38683 = cljs.core.PersistentHashSet.EMPTY;
var inst_38684 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38683,inst_38680);
var inst_38685 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38682,inst_38684);
var state_38695__$1 = state_38695;
var statearr_38754_38809 = state_38695__$1;
(statearr_38754_38809[(2)] = inst_38685);

(statearr_38754_38809[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38696 === (8))){
var inst_38614 = (state_38695[(2)]);
var state_38695__$1 = state_38695;
if(cljs.core.truth_(inst_38614)){
var statearr_38755_38810 = state_38695__$1;
(statearr_38755_38810[(1)] = (9));

} else {
var statearr_38756_38811 = state_38695__$1;
(statearr_38756_38811[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38757[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38757[(1)] = (1));

return statearr_38757;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38695){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38695);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38758){var ex__16304__auto__ = e38758;
var statearr_38759_38812 = state_38695;
(statearr_38759_38812[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38695[(4)]))){
var statearr_38760_38813 = state_38695;
(statearr_38760_38813[(1)] = cljs.core.first((state_38695[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38814 = state_38695;
state_38695 = G__38814;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38695){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38761 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38761[(6)] = c__16375__auto__);

return statearr_38761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__38817,groupBy){
var map__38818 = p__38817;
var map__38818__$1 = (((((!((map__38818 == null))))?(((((map__38818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38818.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38818):map__38818);
var res = map__38818__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38818__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38818__$1,cljs.core.cst$kw$tuples);
var vec__38820 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38820,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38820,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38815_SHARP_){
return fluree.db.util.core.index_of(headers,p1__38815_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38816_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__38816_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__38823 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38823,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38823,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__38826,p__38827,opts){
var map__38828 = p__38826;
var map__38828__$1 = (((((!((map__38828 == null))))?(((((map__38828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38828.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38828):map__38828);
var res = map__38828__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38828__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38828__$1,cljs.core.cst$kw$vars);
var map__38829 = p__38827;
var map__38829__$1 = (((((!((map__38829 == null))))?(((((map__38829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38829):map__38829);
var select_spec = map__38829__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38829__$1,cljs.core.cst$kw$offset);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39051){
var state_val_39052 = (state_39051[(1)]);
if((state_val_39052 === (65))){
var inst_38901 = (state_39051[(7)]);
var inst_38910 = (state_39051[(8)]);
var inst_38962 = (state_39051[(9)]);
var inst_38992 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38901,inst_38910,inst_38962);
var state_39051__$1 = state_39051;
var statearr_39053_39186 = state_39051__$1;
(statearr_39053_39186[(2)] = inst_38992);

(statearr_39053_39186[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (70))){
var inst_39017 = (state_39051[(10)]);
var inst_39016 = (state_39051[(2)]);
var inst_39017__$1 = fluree.db.util.async.throw_err(inst_39016);
var inst_39018 = cljs.core.coll_QMARK_(inst_39017__$1);
var inst_39019 = (!(inst_39018));
var state_39051__$1 = (function (){var statearr_39054 = state_39051;
(statearr_39054[(10)] = inst_39017__$1);

return statearr_39054;
})();
if(inst_39019){
var statearr_39055_39187 = state_39051__$1;
(statearr_39055_39187[(1)] = (71));

} else {
var statearr_39056_39188 = state_39051__$1;
(statearr_39056_39188[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (62))){
var state_39051__$1 = state_39051;
var statearr_39057_39189 = state_39051__$1;
(statearr_39057_39189[(2)] = null);

(statearr_39057_39189[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (74))){
var inst_39017 = (state_39051[(10)]);
var inst_39022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39023 = [inst_39017];
var inst_39024 = (new cljs.core.PersistentVector(null,1,(5),inst_39022,inst_39023,null));
var state_39051__$1 = state_39051;
var statearr_39058_39190 = state_39051__$1;
(statearr_39058_39190[(2)] = inst_39024);

(statearr_39058_39190[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (7))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39059_39191 = state_39051__$1;
(statearr_39059_39191[(1)] = (67));

} else {
var statearr_39060_39192 = state_39051__$1;
(statearr_39060_39192[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (59))){
var state_39051__$1 = state_39051;
var statearr_39061_39193 = state_39051__$1;
(statearr_39061_39193[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (20))){
var state_39051__$1 = state_39051;
var statearr_39063_39194 = state_39051__$1;
(statearr_39063_39194[(2)] = (0));

(statearr_39063_39194[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (72))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39064_39195 = state_39051__$1;
(statearr_39064_39195[(1)] = (77));

} else {
var statearr_39065_39196 = state_39051__$1;
(statearr_39065_39196[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (58))){
var inst_38900 = (state_39051[(11)]);
var inst_38974 = (inst_38900 - (1));
var state_39051__$1 = state_39051;
var statearr_39066_39197 = state_39051__$1;
(statearr_39066_39197[(2)] = inst_38974);

(statearr_39066_39197[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (60))){
var inst_38984 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39067_39198 = state_39051__$1;
(statearr_39067_39198[(2)] = inst_38984);

(statearr_39067_39198[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (27))){
var inst_38899 = (state_39051[(12)]);
var inst_38923 = (inst_38899 < (1));
var state_39051__$1 = state_39051;
var statearr_39068_39199 = state_39051__$1;
(statearr_39068_39199[(2)] = inst_38923);

(statearr_39068_39199[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (1))){
var state_39051__$1 = state_39051;
var statearr_39069_39200 = state_39051__$1;
(statearr_39069_39200[(2)] = null);

(statearr_39069_39200[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (69))){
var inst_39013 = (state_39051[(2)]);
var inst_39014 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_39013,opts);
var state_39051__$1 = state_39051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39051__$1,(70),inst_39014);
} else {
if((state_val_39052 === (24))){
var inst_38901 = (state_39051[(7)]);
var state_39051__$1 = state_39051;
var statearr_39070_39201 = state_39051__$1;
(statearr_39070_39201[(2)] = inst_38901);

(statearr_39070_39201[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (55))){
var state_39051__$1 = state_39051;
var statearr_39071_39202 = state_39051__$1;
(statearr_39071_39202[(2)] = (0));

(statearr_39071_39202[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (85))){
var inst_39038 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39072_39203 = state_39051__$1;
(statearr_39072_39203[(2)] = inst_39038);

(statearr_39072_39203[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (39))){
var inst_38918 = (state_39051[(13)]);
var inst_38941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,(0)], 0));
var inst_38942 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,(0)], 0));
var inst_38943 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_38918,inst_38941,inst_38942);
var state_39051__$1 = state_39051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39051__$1,(42),inst_38943);
} else {
if((state_val_39052 === (46))){
var inst_38899 = (state_39051[(12)]);
var inst_38954 = ((0) < inst_38899);
var state_39051__$1 = state_39051;
var statearr_39073_39204 = state_39051__$1;
(statearr_39073_39204[(2)] = inst_38954);

(statearr_39073_39204[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (4))){
var inst_38832 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39074_39205 = state_39051__$1;
(statearr_39074_39205[(2)] = inst_38832);

(statearr_39074_39205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (77))){
var inst_39017 = (state_39051[(10)]);
var inst_39030 = cljs.core.first(inst_39017);
var state_39051__$1 = state_39051;
var statearr_39075_39206 = state_39051__$1;
(statearr_39075_39206[(2)] = inst_39030);

(statearr_39075_39206[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (54))){
var inst_38900 = (state_39051[(11)]);
var inst_38969 = (state_39051[(2)]);
var inst_38970 = (inst_38900 <= (0));
var state_39051__$1 = (function (){var statearr_39076 = state_39051;
(statearr_39076[(14)] = inst_38969);

return statearr_39076;
})();
if(cljs.core.truth_(inst_38970)){
var statearr_39077_39207 = state_39051__$1;
(statearr_39077_39207[(1)] = (55));

} else {
var statearr_39078_39208 = state_39051__$1;
(statearr_39078_39208[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (15))){
var inst_38850 = (state_39051[(15)]);
var inst_38858 = (state_39051[(2)]);
var inst_38859 = fluree.db.util.async.throw_err(inst_38858);
var inst_38860 = [inst_38850];
var inst_38861 = [inst_38859];
var inst_38862 = cljs.core.PersistentHashMap.fromArrays(inst_38860,inst_38861);
var state_39051__$1 = state_39051;
var statearr_39079_39209 = state_39051__$1;
(statearr_39079_39209[(2)] = inst_38862);

(statearr_39079_39209[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (48))){
var inst_38957 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
if(cljs.core.truth_(inst_38957)){
var statearr_39080_39210 = state_39051__$1;
(statearr_39080_39210[(1)] = (49));

} else {
var statearr_39081_39211 = state_39051__$1;
(statearr_39081_39211[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (50))){
var inst_38952 = (state_39051[(16)]);
var state_39051__$1 = state_39051;
var statearr_39082_39212 = state_39051__$1;
(statearr_39082_39212[(2)] = inst_38952);

(statearr_39082_39212[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (75))){
var inst_39017 = (state_39051[(10)]);
var state_39051__$1 = state_39051;
var statearr_39083_39213 = state_39051__$1;
(statearr_39083_39213[(2)] = inst_39017);

(statearr_39083_39213[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (21))){
var inst_38878 = (state_39051[(17)]);
var inst_38882 = (state_39051[(18)]);
var inst_38890 = (state_39051[(19)]);
var inst_38895 = (state_39051[(2)]);
var inst_38896 = cljs.core.PersistentHashMap.EMPTY;
var inst_38897 = inst_38878;
var inst_38898 = inst_38882;
var inst_38899 = inst_38890;
var inst_38900 = inst_38895;
var inst_38901 = inst_38896;
var state_39051__$1 = (function (){var statearr_39084 = state_39051;
(statearr_39084[(11)] = inst_38900);

(statearr_39084[(7)] = inst_38901);

(statearr_39084[(20)] = inst_38897);

(statearr_39084[(21)] = inst_38898);

(statearr_39084[(12)] = inst_38899);

return statearr_39084;
})();
var statearr_39085_39214 = state_39051__$1;
(statearr_39085_39214[(2)] = null);

(statearr_39085_39214[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (31))){
var inst_38900 = (state_39051[(11)]);
var inst_38915 = (state_39051[(22)]);
var inst_38929 = (inst_38900 >= inst_38915);
var state_39051__$1 = state_39051;
if(cljs.core.truth_(inst_38929)){
var statearr_39086_39215 = state_39051__$1;
(statearr_39086_39215[(1)] = (33));

} else {
var statearr_39087_39216 = state_39051__$1;
(statearr_39087_39216[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (32))){
var inst_39002 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39088_39217 = state_39051__$1;
(statearr_39088_39217[(2)] = inst_39002);

(statearr_39088_39217[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (40))){
var state_39051__$1 = state_39051;
var statearr_39089_39218 = state_39051__$1;
(statearr_39089_39218[(2)] = null);

(statearr_39089_39218[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (56))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39090_39219 = state_39051__$1;
(statearr_39090_39219[(1)] = (58));

} else {
var statearr_39091_39220 = state_39051__$1;
(statearr_39091_39220[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (33))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39092_39221 = state_39051__$1;
(statearr_39092_39221[(1)] = (36));

} else {
var statearr_39093_39222 = state_39051__$1;
(statearr_39093_39222[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (13))){
var inst_38847 = (state_39051[(23)]);
var inst_38878 = (state_39051[(17)]);
var inst_38882 = (state_39051[(18)]);
var inst_38878__$1 = cljs.core.keys(inst_38847);
var inst_38879 = cljs.core.seq(inst_38878__$1);
var inst_38880 = cljs.core.first(inst_38879);
var inst_38881 = cljs.core.next(inst_38879);
var inst_38882__$1 = cljs.core.vals(inst_38847);
var inst_38883 = cljs.core.seq(inst_38882__$1);
var inst_38884 = cljs.core.first(inst_38883);
var inst_38885 = cljs.core.next(inst_38883);
var inst_38886 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_39051__$1 = (function (){var statearr_39094 = state_39051;
(statearr_39094[(24)] = inst_38881);

(statearr_39094[(17)] = inst_38878__$1);

(statearr_39094[(25)] = inst_38880);

(statearr_39094[(18)] = inst_38882__$1);

(statearr_39094[(26)] = inst_38885);

(statearr_39094[(27)] = inst_38884);

return statearr_39094;
})();
if(inst_38886){
var statearr_39095_39223 = state_39051__$1;
(statearr_39095_39223[(1)] = (16));

} else {
var statearr_39096_39224 = state_39051__$1;
(statearr_39096_39224[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (22))){
var inst_38897 = (state_39051[(20)]);
var inst_38898 = (state_39051[(21)]);
var inst_38909 = cljs.core.seq(inst_38897);
var inst_38910 = cljs.core.first(inst_38909);
var inst_38911 = cljs.core.next(inst_38909);
var inst_38912 = cljs.core.seq(inst_38898);
var inst_38913 = cljs.core.first(inst_38912);
var inst_38914 = cljs.core.next(inst_38912);
var inst_38915 = cljs.core.count(inst_38913);
var inst_38916 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_38917 = [headers,vars,inst_38913];
var inst_38918 = cljs.core.PersistentHashMap.fromArrays(inst_38916,inst_38917);
var inst_38919 = (inst_38913 == null);
var state_39051__$1 = (function (){var statearr_39097 = state_39051;
(statearr_39097[(13)] = inst_38918);

(statearr_39097[(22)] = inst_38915);

(statearr_39097[(28)] = inst_38911);

(statearr_39097[(8)] = inst_38910);

(statearr_39097[(29)] = inst_38914);

return statearr_39097;
})();
if(cljs.core.truth_(inst_38919)){
var statearr_39098_39225 = state_39051__$1;
(statearr_39098_39225[(1)] = (24));

} else {
var statearr_39099_39226 = state_39051__$1;
(statearr_39099_39226[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (36))){
var inst_38900 = (state_39051[(11)]);
var inst_38932 = (inst_38900 - (1));
var state_39051__$1 = state_39051;
var statearr_39100_39227 = state_39051__$1;
(statearr_39100_39227[(2)] = inst_38932);

(statearr_39100_39227[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (41))){
var inst_38998 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39101_39228 = state_39051__$1;
(statearr_39101_39228[(2)] = inst_38998);

(statearr_39101_39228[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (43))){
var inst_38900 = (state_39051[(11)]);
var inst_38946 = (state_39051[(30)]);
var inst_38949 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_38900,inst_38946);
var state_39051__$1 = state_39051;
var statearr_39102_39229 = state_39051__$1;
(statearr_39102_39229[(2)] = inst_38949);

(statearr_39102_39229[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (61))){
var inst_38900 = (state_39051[(11)]);
var inst_38915 = (state_39051[(22)]);
var inst_38962 = (state_39051[(9)]);
var inst_38977 = cljs.core.count(inst_38962);
var inst_38978 = (inst_38915 - inst_38977);
var inst_38979 = (inst_38900 - inst_38978);
var state_39051__$1 = state_39051;
var statearr_39103_39230 = state_39051__$1;
(statearr_39103_39230[(2)] = inst_38979);

(statearr_39103_39230[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (29))){
var inst_38926 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
if(cljs.core.truth_(inst_38926)){
var statearr_39104_39231 = state_39051__$1;
(statearr_39104_39231[(1)] = (30));

} else {
var statearr_39105_39232 = state_39051__$1;
(statearr_39105_39232[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (44))){
var inst_38946 = (state_39051[(30)]);
var state_39051__$1 = state_39051;
var statearr_39106_39233 = state_39051__$1;
(statearr_39106_39233[(2)] = inst_38946);

(statearr_39106_39233[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (6))){
var inst_38839 = (state_39051[(31)]);
var inst_38839__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_38841 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_39051__$1 = (function (){var statearr_39107 = state_39051;
(statearr_39107[(31)] = inst_38839__$1);

(statearr_39107[(32)] = inst_38841);

return statearr_39107;
})();
if(cljs.core.truth_(inst_38839__$1)){
var statearr_39108_39234 = state_39051__$1;
(statearr_39108_39234[(1)] = (9));

} else {
var statearr_39109_39235 = state_39051__$1;
(statearr_39109_39235[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (28))){
var inst_38899 = (state_39051[(12)]);
var state_39051__$1 = state_39051;
var statearr_39110_39236 = state_39051__$1;
(statearr_39110_39236[(2)] = inst_38899);

(statearr_39110_39236[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (64))){
var inst_38901 = (state_39051[(7)]);
var state_39051__$1 = state_39051;
var statearr_39111_39237 = state_39051__$1;
(statearr_39111_39237[(2)] = inst_38901);

(statearr_39111_39237[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (51))){
var inst_38899 = (state_39051[(12)]);
var inst_38962 = (state_39051[(2)]);
var inst_38963 = (inst_38899 == null);
var state_39051__$1 = (function (){var statearr_39112 = state_39051;
(statearr_39112[(9)] = inst_38962);

return statearr_39112;
})();
if(cljs.core.truth_(inst_38963)){
var statearr_39113_39238 = state_39051__$1;
(statearr_39113_39238[(1)] = (52));

} else {
var statearr_39114_39239 = state_39051__$1;
(statearr_39114_39239[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (25))){
var inst_38899 = (state_39051[(12)]);
var state_39051__$1 = state_39051;
if(cljs.core.truth_(inst_38899)){
var statearr_39115_39240 = state_39051__$1;
(statearr_39115_39240[(1)] = (27));

} else {
var statearr_39116_39241 = state_39051__$1;
(statearr_39116_39241[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (34))){
var state_39051__$1 = state_39051;
var statearr_39117_39242 = state_39051__$1;
(statearr_39117_39242[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (17))){
var state_39051__$1 = state_39051;
var statearr_39119_39243 = state_39051__$1;
(statearr_39119_39243[(2)] = limit);

(statearr_39119_39243[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (3))){
var inst_39049 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39051__$1,inst_39049);
} else {
if((state_val_39052 === (12))){
var inst_38847 = (state_39051[(23)]);
var inst_38849 = cljs.core.keys(inst_38847);
var inst_38850 = cljs.core.first(inst_38849);
var inst_38851 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_38852 = cljs.core.vals(inst_38847);
var inst_38853 = cljs.core.first(inst_38852);
var inst_38854 = [headers,vars,inst_38853];
var inst_38855 = cljs.core.PersistentHashMap.fromArrays(inst_38851,inst_38854);
var inst_38856 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_38855,select_spec,limit,opts);
var state_39051__$1 = (function (){var statearr_39120 = state_39051;
(statearr_39120[(15)] = inst_38850);

return statearr_39120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39051__$1,(15),inst_38856);
} else {
if((state_val_39052 === (2))){
var _ = (function (){var statearr_39121 = state_39051;
(statearr_39121[(4)] = cljs.core.cons((5),(state_39051[(4)])));

return statearr_39121;
})();
var state_39051__$1 = state_39051;
if(cljs.core.truth_(groupBy)){
var statearr_39122_39244 = state_39051__$1;
(statearr_39122_39244[(1)] = (6));

} else {
var statearr_39123_39245 = state_39051__$1;
(statearr_39123_39245[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (66))){
var inst_38911 = (state_39051[(28)]);
var inst_38969 = (state_39051[(14)]);
var inst_38986 = (state_39051[(33)]);
var inst_38914 = (state_39051[(29)]);
var inst_38994 = (state_39051[(2)]);
var inst_38897 = inst_38911;
var inst_38898 = inst_38914;
var inst_38899 = inst_38969;
var inst_38900 = inst_38986;
var inst_38901 = inst_38994;
var state_39051__$1 = (function (){var statearr_39124 = state_39051;
(statearr_39124[(11)] = inst_38900);

(statearr_39124[(7)] = inst_38901);

(statearr_39124[(20)] = inst_38897);

(statearr_39124[(21)] = inst_38898);

(statearr_39124[(12)] = inst_38899);

return statearr_39124;
})();
var statearr_39125_39246 = state_39051__$1;
(statearr_39125_39246[(2)] = null);

(statearr_39125_39246[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (23))){
var inst_39006 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39126_39247 = state_39051__$1;
(statearr_39126_39247[(2)] = inst_39006);

(statearr_39126_39247[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (47))){
var inst_38899 = (state_39051[(12)]);
var state_39051__$1 = state_39051;
var statearr_39127_39248 = state_39051__$1;
(statearr_39127_39248[(2)] = inst_38899);

(statearr_39127_39248[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (35))){
var inst_39000 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39128_39249 = state_39051__$1;
(statearr_39128_39249[(2)] = inst_39000);

(statearr_39128_39249[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (82))){
var inst_39040 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39129_39250 = state_39051__$1;
(statearr_39129_39250[(2)] = inst_39040);

(statearr_39129_39250[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (76))){
var inst_39027 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39130_39251 = state_39051__$1;
(statearr_39130_39251[(2)] = inst_39027);

(statearr_39130_39251[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (19))){
var inst_38891 = (state_39051[(34)]);
var state_39051__$1 = state_39051;
var statearr_39131_39252 = state_39051__$1;
(statearr_39131_39252[(2)] = inst_38891);

(statearr_39131_39252[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (57))){
var inst_38962 = (state_39051[(9)]);
var inst_38986 = (state_39051[(2)]);
var inst_38987 = (inst_38962 == null);
var inst_38988 = cljs.core.empty_QMARK_(inst_38962);
var inst_38989 = ((inst_38987) || (inst_38988));
var state_39051__$1 = (function (){var statearr_39132 = state_39051;
(statearr_39132[(33)] = inst_38986);

return statearr_39132;
})();
if(cljs.core.truth_(inst_38989)){
var statearr_39133_39253 = state_39051__$1;
(statearr_39133_39253[(1)] = (64));

} else {
var statearr_39134_39254 = state_39051__$1;
(statearr_39134_39254[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (68))){
var state_39051__$1 = state_39051;
var statearr_39135_39255 = state_39051__$1;
(statearr_39135_39255[(2)] = limit);

(statearr_39135_39255[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (11))){
var inst_38847 = (state_39051[(2)]);
var state_39051__$1 = (function (){var statearr_39137 = state_39051;
(statearr_39137[(23)] = inst_38847);

return statearr_39137;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_39138_39256 = state_39051__$1;
(statearr_39138_39256[(1)] = (12));

} else {
var statearr_39139_39257 = state_39051__$1;
(statearr_39139_39257[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (9))){
var inst_38839 = (state_39051[(31)]);
var inst_38841 = (state_39051[(32)]);
var inst_38843 = cljs.core.sorted_map_by(inst_38839);
var inst_38844 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38843,inst_38841);
var state_39051__$1 = state_39051;
var statearr_39140_39258 = state_39051__$1;
(statearr_39140_39258[(2)] = inst_38844);

(statearr_39140_39258[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (5))){
var _ = (function (){var statearr_39141 = state_39051;
(statearr_39141[(4)] = cljs.core.rest((state_39051[(4)])));

return statearr_39141;
})();
var state_39051__$1 = state_39051;
var ex39136 = (state_39051__$1[(2)]);
var statearr_39142_39259 = state_39051__$1;
(statearr_39142_39259[(5)] = ex39136);


if((ex39136 instanceof Error)){
var statearr_39143_39260 = state_39051__$1;
(statearr_39143_39260[(1)] = (4));

(statearr_39143_39260[(5)] = null);

} else {
throw ex39136;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (83))){
var inst_39017 = (state_39051[(10)]);
var state_39051__$1 = state_39051;
var statearr_39144_39261 = state_39051__$1;
(statearr_39144_39261[(2)] = inst_39017);

(statearr_39144_39261[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (14))){
var inst_39008 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39145_39262 = state_39051__$1;
(statearr_39145_39262[(2)] = inst_39008);

(statearr_39145_39262[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (45))){
var inst_38899 = (state_39051[(12)]);
var inst_38952 = (state_39051[(2)]);
var state_39051__$1 = (function (){var statearr_39146 = state_39051;
(statearr_39146[(16)] = inst_38952);

return statearr_39146;
})();
if(cljs.core.truth_(inst_38899)){
var statearr_39147_39263 = state_39051__$1;
(statearr_39147_39263[(1)] = (46));

} else {
var statearr_39148_39264 = state_39051__$1;
(statearr_39148_39264[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (53))){
var inst_38899 = (state_39051[(12)]);
var inst_38962 = (state_39051[(9)]);
var inst_38966 = cljs.core.count(inst_38962);
var inst_38967 = (inst_38899 - inst_38966);
var state_39051__$1 = state_39051;
var statearr_39149_39265 = state_39051__$1;
(statearr_39149_39265[(2)] = inst_38967);

(statearr_39149_39265[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (78))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39150_39266 = state_39051__$1;
(statearr_39150_39266[(1)] = (80));

} else {
var statearr_39151_39267 = state_39051__$1;
(statearr_39151_39267[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (26))){
var inst_39004 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39152_39268 = state_39051__$1;
(statearr_39152_39268[(2)] = inst_39004);

(statearr_39152_39268[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (16))){
var state_39051__$1 = state_39051;
var statearr_39153_39269 = state_39051__$1;
(statearr_39153_39269[(2)] = null);

(statearr_39153_39269[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (81))){
var state_39051__$1 = state_39051;
var statearr_39156_39270 = state_39051__$1;
(statearr_39156_39270[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (79))){
var inst_39042 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39158_39271 = state_39051__$1;
(statearr_39158_39271[(2)] = inst_39042);

(statearr_39158_39271[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (38))){
var inst_38901 = (state_39051[(7)]);
var inst_38911 = (state_39051[(28)]);
var inst_38899 = (state_39051[(12)]);
var inst_38914 = (state_39051[(29)]);
var inst_38936 = (state_39051[(2)]);
var tmp39154 = inst_38901;
var tmp39155 = inst_38899;
var inst_38897 = inst_38911;
var inst_38898 = inst_38914;
var inst_38899__$1 = tmp39155;
var inst_38900 = inst_38936;
var inst_38901__$1 = tmp39154;
var state_39051__$1 = (function (){var statearr_39159 = state_39051;
(statearr_39159[(11)] = inst_38900);

(statearr_39159[(7)] = inst_38901__$1);

(statearr_39159[(20)] = inst_38897);

(statearr_39159[(21)] = inst_38898);

(statearr_39159[(12)] = inst_38899__$1);

return statearr_39159;
})();
var statearr_39160_39272 = state_39051__$1;
(statearr_39160_39272[(2)] = null);

(statearr_39160_39272[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (30))){
var inst_38901 = (state_39051[(7)]);
var state_39051__$1 = state_39051;
var statearr_39161_39273 = state_39051__$1;
(statearr_39161_39273[(2)] = inst_38901);

(statearr_39161_39273[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (73))){
var inst_39044 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39162_39274 = state_39051__$1;
(statearr_39162_39274[(2)] = inst_39044);

(statearr_39162_39274[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (10))){
var inst_38841 = (state_39051[(32)]);
var state_39051__$1 = state_39051;
var statearr_39163_39275 = state_39051__$1;
(statearr_39163_39275[(2)] = inst_38841);

(statearr_39163_39275[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (18))){
var inst_38891 = (state_39051[(34)]);
var inst_38890 = (state_39051[(2)]);
var inst_38891__$1 = offset;
var state_39051__$1 = (function (){var statearr_39164 = state_39051;
(statearr_39164[(34)] = inst_38891__$1);

(statearr_39164[(19)] = inst_38890);

return statearr_39164;
})();
if(cljs.core.truth_(inst_38891__$1)){
var statearr_39165_39276 = state_39051__$1;
(statearr_39165_39276[(1)] = (19));

} else {
var statearr_39166_39277 = state_39051__$1;
(statearr_39166_39277[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (52))){
var state_39051__$1 = state_39051;
var statearr_39167_39278 = state_39051__$1;
(statearr_39167_39278[(2)] = null);

(statearr_39167_39278[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (67))){
var state_39051__$1 = state_39051;
var statearr_39168_39279 = state_39051__$1;
(statearr_39168_39279[(2)] = (1));

(statearr_39168_39279[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (71))){
var state_39051__$1 = state_39051;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39169_39280 = state_39051__$1;
(statearr_39169_39280[(1)] = (74));

} else {
var statearr_39170_39281 = state_39051__$1;
(statearr_39170_39281[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (42))){
var inst_38900 = (state_39051[(11)]);
var inst_38945 = (state_39051[(2)]);
var inst_38946 = fluree.db.util.async.throw_err(inst_38945);
var inst_38947 = ((0) < inst_38900);
var state_39051__$1 = (function (){var statearr_39171 = state_39051;
(statearr_39171[(30)] = inst_38946);

return statearr_39171;
})();
if(cljs.core.truth_(inst_38947)){
var statearr_39172_39282 = state_39051__$1;
(statearr_39172_39282[(1)] = (43));

} else {
var statearr_39173_39283 = state_39051__$1;
(statearr_39173_39283[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (80))){
var inst_39017 = (state_39051[(10)]);
var inst_39033 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_39017);
var state_39051__$1 = state_39051;
var statearr_39174_39284 = state_39051__$1;
(statearr_39174_39284[(2)] = inst_39033);

(statearr_39174_39284[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (37))){
var inst_38900 = (state_39051[(11)]);
var inst_38915 = (state_39051[(22)]);
var inst_38934 = (inst_38900 - inst_38915);
var state_39051__$1 = state_39051;
var statearr_39175_39285 = state_39051__$1;
(statearr_39175_39285[(2)] = inst_38934);

(statearr_39175_39285[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (63))){
var inst_38982 = (state_39051[(2)]);
var state_39051__$1 = state_39051;
var statearr_39176_39286 = state_39051__$1;
(statearr_39176_39286[(2)] = inst_38982);

(statearr_39176_39286[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (8))){
var inst_39046 = (state_39051[(2)]);
var _ = (function (){var statearr_39177 = state_39051;
(statearr_39177[(4)] = cljs.core.rest((state_39051[(4)])));

return statearr_39177;
})();
var state_39051__$1 = state_39051;
var statearr_39178_39287 = state_39051__$1;
(statearr_39178_39287[(2)] = inst_39046);

(statearr_39178_39287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (49))){
var inst_38952 = (state_39051[(16)]);
var inst_38899 = (state_39051[(12)]);
var inst_38959 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_38899,inst_38952);
var state_39051__$1 = state_39051;
var statearr_39179_39288 = state_39051__$1;
(statearr_39179_39288[(2)] = inst_38959);

(statearr_39179_39288[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39052 === (84))){
var state_39051__$1 = state_39051;
var statearr_39180_39289 = state_39051__$1;
(statearr_39180_39289[(2)] = null);

(statearr_39180_39289[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0 = (function (){
var statearr_39181 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39181[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__);

(statearr_39181[(1)] = (1));

return statearr_39181;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1 = (function (state_39051){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39051);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39182){var ex__16304__auto__ = e39182;
var statearr_39183_39290 = state_39051;
(statearr_39183_39290[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39051[(4)]))){
var statearr_39184_39291 = state_39051;
(statearr_39184_39291[(1)] = cljs.core.first((state_39051[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39292 = state_39051;
state_39051 = G__39292;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = function(state_39051){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1.call(this,state_39051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39185 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39185[(6)] = c__16375__auto__);

return statearr_39185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__39295,opts){
var map__39296 = p__39295;
var map__39296__$1 = (((((!((map__39296 == null))))?(((((map__39296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39296):map__39296);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39296__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39296__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39296__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39296__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__39293_SHARP_){
return cljs.core.contains_QMARK_(p1__39293_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__39294_SHARP_){
return cljs.core.contains_QMARK_(p1__39294_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__39305 = cljs.core.first(orderBy);
var fexpr__39304 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__39304.cljs$core$IFn$_invoke$arity$1 ? fexpr__39304.cljs$core$IFn$_invoke$arity$1(G__39305) : fexpr__39304.call(null,G__39305));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__39306,p__39307){
var map__39308 = p__39306;
var map__39308__$1 = (((((!((map__39308 == null))))?(((((map__39308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39308.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39308):map__39308);
var query_map = map__39308__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39308__$1,cljs.core.cst$kw$construct);
var map__39309 = p__39307;
var map__39309__$1 = (((((!((map__39309 == null))))?(((((map__39309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39309.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39309):map__39309);
var where_result = map__39309__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39309__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39309__$1,cljs.core.cst$kw$tuples);
var vec__39312 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39312,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39312,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39312,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39345){
var state_val_39346 = (state_39345[(1)]);
if((state_val_39346 === (7))){
var inst_39324 = (state_39345[(7)]);
var state_39345__$1 = state_39345;
var statearr_39347_39370 = state_39345__$1;
(statearr_39347_39370[(2)] = inst_39324);

(statearr_39347_39370[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (1))){
var state_39345__$1 = state_39345;
var statearr_39348_39371 = state_39345__$1;
(statearr_39348_39371[(2)] = null);

(statearr_39348_39371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (4))){
var inst_39315 = (state_39345[(2)]);
var state_39345__$1 = state_39345;
var statearr_39349_39372 = state_39345__$1;
(statearr_39349_39372[(2)] = inst_39315);

(statearr_39349_39372[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (13))){
var inst_39334 = (state_39345[(2)]);
var inst_39335 = fluree.db.util.async.throw_err(inst_39334);
var state_39345__$1 = state_39345;
var statearr_39350_39373 = state_39345__$1;
(statearr_39350_39373[(2)] = inst_39335);

(statearr_39350_39373[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (6))){
var inst_39324 = (state_39345[(7)]);
var inst_39323 = (state_39345[(2)]);
var inst_39324__$1 = fluree.db.util.async.throw_err(inst_39323);
var inst_39325 = fluree.db.util.core.exception_QMARK_(inst_39324__$1);
var state_39345__$1 = (function (){var statearr_39351 = state_39345;
(statearr_39351[(7)] = inst_39324__$1);

return statearr_39351;
})();
if(inst_39325){
var statearr_39352_39374 = state_39345__$1;
(statearr_39352_39374[(1)] = (7));

} else {
var statearr_39353_39375 = state_39345__$1;
(statearr_39353_39375[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (3))){
var inst_39343 = (state_39345[(2)]);
var state_39345__$1 = state_39345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39345__$1,inst_39343);
} else {
if((state_val_39346 === (12))){
var inst_39338 = (state_39345[(2)]);
var state_39345__$1 = state_39345;
var statearr_39354_39376 = state_39345__$1;
(statearr_39354_39376[(2)] = inst_39338);

(statearr_39354_39376[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (2))){
var _ = (function (){var statearr_39355 = state_39345;
(statearr_39355[(4)] = cljs.core.cons((5),(state_39345[(4)])));

return statearr_39355;
})();
var inst_39321 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_39345__$1 = state_39345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39345__$1,(6),inst_39321);
} else {
if((state_val_39346 === (11))){
var state_39345__$1 = state_39345;
var statearr_39357_39377 = state_39345__$1;
(statearr_39357_39377[(2)] = null);

(statearr_39357_39377[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (9))){
var inst_39340 = (state_39345[(2)]);
var _ = (function (){var statearr_39358 = state_39345;
(statearr_39358[(4)] = cljs.core.rest((state_39345[(4)])));

return statearr_39358;
})();
var state_39345__$1 = state_39345;
var statearr_39359_39378 = state_39345__$1;
(statearr_39359_39378[(2)] = inst_39340);

(statearr_39359_39378[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (5))){
var _ = (function (){var statearr_39360 = state_39345;
(statearr_39360[(4)] = cljs.core.rest((state_39345[(4)])));

return statearr_39360;
})();
var state_39345__$1 = state_39345;
var ex39356 = (state_39345__$1[(2)]);
var statearr_39361_39379 = state_39345__$1;
(statearr_39361_39379[(5)] = ex39356);


if((ex39356 instanceof Error)){
var statearr_39362_39380 = state_39345__$1;
(statearr_39362_39380[(1)] = (4));

(statearr_39362_39380[(5)] = null);

} else {
throw ex39356;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39346 === (10))){
var inst_39324 = (state_39345[(7)]);
var inst_39329 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_39324);
var inst_39330 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_39324);
var inst_39331 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_39329,inst_39330,query_map,opts);
var inst_39332 = fluree.db.query.fql.process_ad_hoc_res(db,inst_39324,inst_39331,opts);
var state_39345__$1 = state_39345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39345__$1,(13),inst_39332);
} else {
if((state_val_39346 === (8))){
var state_39345__$1 = state_39345;
var statearr_39363_39381 = state_39345__$1;
(statearr_39363_39381[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0 = (function (){
var statearr_39365 = [null,null,null,null,null,null,null,null];
(statearr_39365[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__);

(statearr_39365[(1)] = (1));

return statearr_39365;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1 = (function (state_39345){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39345);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39366){var ex__16304__auto__ = e39366;
var statearr_39367_39382 = state_39345;
(statearr_39367_39382[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39345[(4)]))){
var statearr_39368_39383 = state_39345;
(statearr_39368_39383[(1)] = cljs.core.first((state_39345[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39384 = state_39345;
state_39345 = G__39384;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = function(state_39345){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1.call(this,state_39345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39369 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39369[(6)] = c__16375__auto__);

return statearr_39369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__39385 = query_map;
var map__39385__$1 = (((((!((map__39385 == null))))?(((((map__39385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39385.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39385):map__39385);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39385__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__39387 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39387,cljs.core.cst$kw$limit,(1));
} else {
return G__39387;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39758){
var state_val_39759 = (state_39758[(1)]);
if((state_val_39759 === (121))){
var inst_39471 = (state_39758[(7)]);
var inst_39703 = (state_39758[(8)]);
var inst_39469 = (state_39758[(9)]);
var inst_39699 = (state_39758[(10)]);
var inst_39707 = (state_39758[(2)]);
var inst_39708 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_39471,fuel,max_fuel,inst_39469,inst_39699,inst_39703,inst_39707);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(115),inst_39708);
} else {
if((state_val_39759 === (65))){
var inst_39459 = (state_39758[(11)]);
var inst_39471 = (state_39758[(7)]);
var inst_39548 = (state_39758[(12)]);
var inst_39469 = (state_39758[(9)]);
var inst_39562 = (state_39758[(2)]);
var inst_39563 = fluree.db.util.async.throw_err(inst_39562);
var inst_39564 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39548,inst_39563);
var inst_39565 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_39471,fuel,max_fuel,inst_39469,inst_39564,inst_39459);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(66),inst_39565);
} else {
if((state_val_39759 === (70))){
var inst_39458 = (state_39758[(13)]);
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39458)){
var statearr_39760_39952 = state_39758__$1;
(statearr_39760_39952[(1)] = (73));

} else {
var statearr_39761_39953 = state_39758__$1;
(statearr_39761_39953[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (62))){
var inst_39550 = cljs.core.PersistentHashMap.EMPTY;
var state_39758__$1 = state_39758;
var statearr_39762_39954 = state_39758__$1;
(statearr_39762_39954[(2)] = inst_39550);

(statearr_39762_39954[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (74))){
var inst_39459 = (state_39758[(11)]);
var inst_39461 = (state_39758[(14)]);
var inst_39584 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_39585 = [inst_39459,inst_39461];
var inst_39586 = cljs.core.PersistentHashMap.fromArrays(inst_39584,inst_39585);
var state_39758__$1 = state_39758;
var statearr_39763_39955 = state_39758__$1;
(statearr_39763_39955[(2)] = inst_39586);

(statearr_39763_39955[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (110))){
var inst_39667 = (state_39758[(15)]);
var inst_39681 = (state_39758[(2)]);
var inst_39682 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_39667,false);
var state_39758__$1 = (function (){var statearr_39764 = state_39758;
(statearr_39764[(16)] = inst_39681);

return statearr_39764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(111),inst_39682);
} else {
if((state_val_39759 === (130))){
var inst_39748 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39748)){
var statearr_39765_39956 = state_39758__$1;
(statearr_39765_39956[(1)] = (131));

} else {
var statearr_39766_39957 = state_39758__$1;
(statearr_39766_39957[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (128))){
var inst_39739 = (state_39758[(17)]);
var inst_39742 = cljs.core.coll_QMARK_(inst_39739);
var inst_39743 = fluree.db.util.core.exception_QMARK_(inst_39739);
var inst_39744 = (!(inst_39743));
var inst_39745 = ((inst_39742) && (inst_39744));
var state_39758__$1 = state_39758;
var statearr_39767_39958 = state_39758__$1;
(statearr_39767_39958[(2)] = inst_39745);

(statearr_39767_39958[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (7))){
var inst_39419 = (state_39758[(18)]);
var inst_39419__$1 = selectOne;
var state_39758__$1 = (function (){var statearr_39768 = state_39758;
(statearr_39768[(18)] = inst_39419__$1);

return statearr_39768;
})();
if(cljs.core.truth_(inst_39419__$1)){
var statearr_39769_39959 = state_39758__$1;
(statearr_39769_39959[(1)] = (9));

} else {
var statearr_39770_39960 = state_39758__$1;
(statearr_39770_39960[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (59))){
var inst_39542 = (state_39758[(19)]);
var inst_39544 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_39545 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39542,inst_39544);
var state_39758__$1 = state_39758;
var statearr_39771_39961 = state_39758__$1;
(statearr_39771_39961[(2)] = inst_39545);

(statearr_39771_39961[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (86))){
var inst_39620 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(89),inst_39620);
} else {
if((state_val_39759 === (20))){
var inst_39449 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39772_39962 = state_39758__$1;
(statearr_39772_39962[(2)] = inst_39449);

(statearr_39772_39962[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (72))){
var inst_39730 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39773_39963 = state_39758__$1;
(statearr_39773_39963[(2)] = inst_39730);

(statearr_39773_39963[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (58))){
var inst_39542 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39774 = state_39758;
(statearr_39774[(19)] = inst_39542);

return statearr_39774;
})();
var statearr_39775_39964 = state_39758__$1;
(statearr_39775_39964[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (60))){
var inst_39542 = (state_39758[(19)]);
var state_39758__$1 = state_39758;
var statearr_39777_39965 = state_39758__$1;
(statearr_39777_39965[(2)] = inst_39542);

(statearr_39777_39965[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (27))){
var inst_39458 = (state_39758[(13)]);
var inst_39473 = cljs.core.vector_QMARK_(inst_39458);
var state_39758__$1 = state_39758;
if(inst_39473){
var statearr_39778_39966 = state_39758__$1;
(statearr_39778_39966[(1)] = (30));

} else {
var statearr_39779_39967 = state_39758__$1;
(statearr_39779_39967[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (1))){
var state_39758__$1 = state_39758;
var statearr_39780_39968 = state_39758__$1;
(statearr_39780_39968[(2)] = null);

(statearr_39780_39968[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (69))){
var inst_39579 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39579)){
var statearr_39781_39969 = state_39758__$1;
(statearr_39781_39969[(1)] = (70));

} else {
var statearr_39782_39970 = state_39758__$1;
(statearr_39782_39970[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (101))){
var inst_39458 = (state_39758[(13)]);
var inst_39697 = (state_39758[(2)]);
var inst_39698 = cljs.core.PersistentVector.EMPTY;
var inst_39699 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39698,inst_39697);
var state_39758__$1 = (function (){var statearr_39783 = state_39758;
(statearr_39783[(10)] = inst_39699);

return statearr_39783;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39784_39971 = state_39758__$1;
(statearr_39784_39971[(1)] = (116));

} else {
var statearr_39785_39972 = state_39758__$1;
(statearr_39785_39972[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (24))){
var inst_39460 = (state_39758[(20)]);
var inst_39462 = (state_39758[(21)]);
var inst_39466 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39462,cljs.core.cst$kw$componentFollow_QMARK_,inst_39460);
var state_39758__$1 = state_39758;
var statearr_39786_39973 = state_39758__$1;
(statearr_39786_39973[(2)] = inst_39466);

(statearr_39786_39973[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (102))){
var inst_39661 = (state_39758[(22)]);
var state_39758__$1 = state_39758;
var statearr_39787_39974 = state_39758__$1;
(statearr_39787_39974[(2)] = inst_39661);

(statearr_39787_39974[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (55))){
var inst_39732 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39788_39975 = state_39758__$1;
(statearr_39788_39975[(2)] = inst_39732);

(statearr_39788_39975[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (85))){
var inst_39614 = (state_39758[(2)]);
var inst_39615 = fluree.db.util.async.throw_err(inst_39614);
var state_39758__$1 = state_39758;
var statearr_39789_39976 = state_39758__$1;
(statearr_39789_39976[(2)] = inst_39615);

(statearr_39789_39976[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (39))){
var inst_39508 = typeof from === 'string';
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39508)){
var statearr_39790_39977 = state_39758__$1;
(statearr_39790_39977[(1)] = (42));

} else {
var statearr_39791_39978 = state_39758__$1;
(statearr_39791_39978[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (88))){
var inst_39726 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39792_39979 = state_39758__$1;
(statearr_39792_39979[(2)] = inst_39726);

(statearr_39792_39979[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (46))){
var inst_39527 = (state_39758[(2)]);
var inst_39528 = fluree.db.util.async.throw_err(inst_39527);
var state_39758__$1 = state_39758;
var statearr_39793_39980 = state_39758__$1;
(statearr_39793_39980[(2)] = inst_39528);

(statearr_39793_39980[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (4))){
var inst_39406 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39794_39981 = state_39758__$1;
(statearr_39794_39981[(2)] = inst_39406);

(statearr_39794_39981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (77))){
var inst_39595 = (state_39758[(2)]);
var inst_39596 = fluree.db.util.async.throw_err(inst_39595);
var state_39758__$1 = state_39758;
var statearr_39795_39982 = state_39758__$1;
(statearr_39795_39982[(2)] = inst_39596);

(statearr_39795_39982[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (106))){
var state_39758__$1 = state_39758;
if(cljs.core.truth_(fuel)){
var statearr_39796_39983 = state_39758__$1;
(statearr_39796_39983[(1)] = (108));

} else {
var statearr_39797_39984 = state_39758__$1;
(statearr_39797_39984[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (119))){
var state_39758__$1 = state_39758;
var statearr_39798_39985 = state_39758__$1;
(statearr_39798_39985[(2)] = null);

(statearr_39798_39985[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (95))){
var state_39758__$1 = state_39758;
var statearr_39799_39986 = state_39758__$1;
(statearr_39799_39986[(2)] = null);

(statearr_39799_39986[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (54))){
var inst_39571 = typeof from === 'string';
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39571)){
var statearr_39800_39987 = state_39758__$1;
(statearr_39800_39987[(1)] = (67));

} else {
var statearr_39801_39988 = state_39758__$1;
(statearr_39801_39988[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (92))){
var inst_39459 = (state_39758[(11)]);
var inst_39471 = (state_39758[(7)]);
var inst_39461 = (state_39758[(14)]);
var inst_39469 = (state_39758[(9)]);
var inst_39631 = (state_39758[(2)]);
var inst_39632 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_39471,fuel,max_fuel,inst_39469,inst_39631,inst_39459,inst_39461);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(93),inst_39632);
} else {
if((state_val_39759 === (104))){
var inst_39695 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39802_39989 = state_39758__$1;
(statearr_39802_39989[(2)] = inst_39695);

(statearr_39802_39989[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (15))){
var inst_39436 = (state_39758[(23)]);
var inst_39441 = inst_39436.cljs$lang$protocol_mask$partition0$;
var inst_39442 = (inst_39441 & (64));
var inst_39443 = inst_39436.cljs$core$ISeq$;
var inst_39444 = (cljs.core.PROTOCOL_SENTINEL === inst_39443);
var inst_39445 = ((inst_39442) || (inst_39444));
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39445)){
var statearr_39803_39990 = state_39758__$1;
(statearr_39803_39990[(1)] = (18));

} else {
var statearr_39804_39991 = state_39758__$1;
(statearr_39804_39991[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (48))){
var inst_39459 = (state_39758[(11)]);
var state_39758__$1 = state_39758;
var statearr_39805_39992 = state_39758__$1;
(statearr_39805_39992[(2)] = inst_39459);

(statearr_39805_39992[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (50))){
var state_39758__$1 = state_39758;
var statearr_39806_39993 = state_39758__$1;
(statearr_39806_39993[(2)] = null);

(statearr_39806_39993[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (116))){
var state_39758__$1 = state_39758;
var statearr_39807_39994 = state_39758__$1;
(statearr_39807_39994[(2)] = null);

(statearr_39807_39994[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (75))){
var inst_39588 = (state_39758[(2)]);
var inst_39589 = fluree.db.query.range._block_or_tx_collection(db,inst_39588);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(76),inst_39589);
} else {
if((state_val_39759 === (99))){
var inst_39724 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39808_39995 = state_39758__$1;
(statearr_39808_39995[(2)] = inst_39724);

(statearr_39808_39995[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (21))){
var inst_39436 = (state_39758[(23)]);
var inst_39454 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39436);
var state_39758__$1 = state_39758;
var statearr_39809_39996 = state_39758__$1;
(statearr_39809_39996[(2)] = inst_39454);

(statearr_39809_39996[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (31))){
var inst_39458 = (state_39758[(13)]);
var inst_39481 = typeof inst_39458 === 'string';
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39481)){
var statearr_39810_39997 = state_39758__$1;
(statearr_39810_39997[(1)] = (33));

} else {
var statearr_39811_39998 = state_39758__$1;
(statearr_39811_39998[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (113))){
var inst_39661 = (state_39758[(22)]);
var state_39758__$1 = state_39758;
var statearr_39812_39999 = state_39758__$1;
(statearr_39812_39999[(2)] = inst_39661);

(statearr_39812_39999[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (32))){
var inst_39497 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39813_40000 = state_39758__$1;
(statearr_39813_40000[(2)] = inst_39497);

(statearr_39813_40000[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (40))){
var inst_39530 = typeof from === 'string';
var inst_39531 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_39532 = clojure.string.includes_QMARK_(inst_39531,"/");
var inst_39533 = ((inst_39530) && (inst_39532));
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39533)){
var statearr_39814_40001 = state_39758__$1;
(statearr_39814_40001[(1)] = (53));

} else {
var statearr_39815_40002 = state_39758__$1;
(statearr_39815_40002[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (129))){
var inst_39740 = (state_39758[(24)]);
var state_39758__$1 = state_39758;
var statearr_39816_40003 = state_39758__$1;
(statearr_39816_40003[(2)] = inst_39740);

(statearr_39816_40003[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (91))){
var inst_39623 = (state_39758[(25)]);
var inst_39627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39628 = [inst_39623];
var inst_39629 = (new cljs.core.PersistentVector(null,1,(5),inst_39627,inst_39628,null));
var state_39758__$1 = state_39758;
var statearr_39817_40004 = state_39758__$1;
(statearr_39817_40004[(2)] = inst_39629);

(statearr_39817_40004[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (117))){
var inst_39459 = (state_39758[(11)]);
var state_39758__$1 = state_39758;
var statearr_39818_40005 = state_39758__$1;
(statearr_39818_40005[(2)] = inst_39459);

(statearr_39818_40005[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (108))){
var inst_39676 = cljs.core._deref(fuel);
var inst_39677 = (inst_39676 + (1));
var inst_39678 = cljs.core._vreset_BANG_(fuel,inst_39677);
var state_39758__$1 = state_39758;
var statearr_39819_40006 = state_39758__$1;
(statearr_39819_40006[(2)] = inst_39678);

(statearr_39819_40006[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (56))){
var inst_39536 = (state_39758[(26)]);
var inst_39538 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_39539 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39536,inst_39538);
var state_39758__$1 = state_39758;
var statearr_39820_40007 = state_39758__$1;
(statearr_39820_40007[(2)] = inst_39539);

(statearr_39820_40007[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (33))){
var inst_39458 = (state_39758[(13)]);
var inst_39483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39484 = [inst_39458,"ASC"];
var inst_39485 = (new cljs.core.PersistentVector(null,2,(5),inst_39483,inst_39484,null));
var state_39758__$1 = state_39758;
var statearr_39821_40008 = state_39758__$1;
(statearr_39821_40008[(2)] = inst_39485);

(statearr_39821_40008[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (13))){
var inst_39425 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39426 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39427 = cljs.core.PersistentHashMap.fromArrays(inst_39425,inst_39426);
var inst_39428 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_39427);
var inst_39429 = (function(){throw inst_39428})();
var state_39758__$1 = state_39758;
var statearr_39822_40009 = state_39758__$1;
(statearr_39822_40009[(2)] = inst_39429);

(statearr_39822_40009[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (22))){
var inst_39436 = (state_39758[(23)]);
var state_39758__$1 = state_39758;
var statearr_39823_40010 = state_39758__$1;
(statearr_39823_40010[(2)] = inst_39436);

(statearr_39823_40010[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (90))){
var state_39758__$1 = state_39758;
var statearr_39824_40011 = state_39758__$1;
(statearr_39824_40011[(2)] = null);

(statearr_39824_40011[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (109))){
var state_39758__$1 = state_39758;
var statearr_39825_40012 = state_39758__$1;
(statearr_39825_40012[(2)] = null);

(statearr_39825_40012[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (36))){
var inst_39488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39489 = [null,null];
var inst_39490 = (new cljs.core.PersistentVector(null,2,(5),inst_39488,inst_39489,null));
var state_39758__$1 = state_39758;
var statearr_39826_40013 = state_39758__$1;
(statearr_39826_40013[(2)] = inst_39490);

(statearr_39826_40013[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (41))){
var inst_39504 = (state_39758[(27)]);
var inst_39734 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39827 = state_39758;
(statearr_39827[(28)] = inst_39734);

return statearr_39827;
})();
if(cljs.core.truth_(inst_39504)){
var statearr_39828_40014 = state_39758__$1;
(statearr_39828_40014[(1)] = (125));

} else {
var statearr_39829_40015 = state_39758__$1;
(statearr_39829_40015[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (118))){
var inst_39458 = (state_39758[(13)]);
var inst_39703 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39830 = state_39758;
(statearr_39830[(8)] = inst_39703);

return statearr_39830;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39831_40016 = state_39758__$1;
(statearr_39831_40016[(1)] = (119));

} else {
var statearr_39832_40017 = state_39758__$1;
(statearr_39832_40017[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (89))){
var inst_39623 = (state_39758[(25)]);
var inst_39622 = (state_39758[(2)]);
var inst_39623__$1 = fluree.db.util.async.throw_err(inst_39622);
var inst_39624 = (inst_39623__$1 == null);
var state_39758__$1 = (function (){var statearr_39833 = state_39758;
(statearr_39833[(25)] = inst_39623__$1);

return statearr_39833;
})();
if(cljs.core.truth_(inst_39624)){
var statearr_39834_40018 = state_39758__$1;
(statearr_39834_40018[(1)] = (90));

} else {
var statearr_39835_40019 = state_39758__$1;
(statearr_39835_40019[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (100))){
var inst_39660 = (state_39758[(29)]);
var inst_39667 = (state_39758[(15)]);
var inst_39666 = cljs.core.seq(inst_39660);
var inst_39667__$1 = cljs.core.first(inst_39666);
var inst_39668 = cljs.core.next(inst_39666);
var inst_39669 = cljs.core.not(inst_39667__$1);
var state_39758__$1 = (function (){var statearr_39836 = state_39758;
(statearr_39836[(30)] = inst_39668);

(statearr_39836[(15)] = inst_39667__$1);

return statearr_39836;
})();
if(inst_39669){
var statearr_39837_40020 = state_39758__$1;
(statearr_39837_40020[(1)] = (102));

} else {
var statearr_39838_40021 = state_39758__$1;
(statearr_39838_40021[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (131))){
var inst_39739 = (state_39758[(17)]);
var inst_39750 = cljs.core.first(inst_39739);
var state_39758__$1 = state_39758;
var statearr_39839_40022 = state_39758__$1;
(statearr_39839_40022[(2)] = inst_39750);

(statearr_39839_40022[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (122))){
var inst_39714 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_39715 = ["Invalid 'from' in query:",inst_39714].join('');
var inst_39716 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39717 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39718 = cljs.core.PersistentHashMap.fromArrays(inst_39716,inst_39717);
var inst_39719 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39715,inst_39718);
var state_39758__$1 = state_39758;
var statearr_39840_40023 = state_39758__$1;
(statearr_39840_40023[(2)] = inst_39719);

(statearr_39840_40023[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (43))){
var state_39758__$1 = state_39758;
var statearr_39841_40024 = state_39758__$1;
(statearr_39841_40024[(2)] = null);

(statearr_39841_40024[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (61))){
var inst_39458 = (state_39758[(13)]);
var inst_39548 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39842 = state_39758;
(statearr_39842[(12)] = inst_39548);

return statearr_39842;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39843_40025 = state_39758__$1;
(statearr_39843_40025[(1)] = (62));

} else {
var statearr_39844_40026 = state_39758__$1;
(statearr_39844_40026[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (29))){
var inst_39503 = (state_39758[(2)]);
var inst_39504 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39503,(0),null);
var inst_39505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39503,(1),null);
var inst_39506 = typeof where === 'string';
var state_39758__$1 = (function (){var statearr_39845 = state_39758;
(statearr_39845[(31)] = inst_39505);

(statearr_39845[(27)] = inst_39504);

return statearr_39845;
})();
if(cljs.core.truth_(inst_39506)){
var statearr_39846_40027 = state_39758__$1;
(statearr_39846_40027[(1)] = (39));

} else {
var statearr_39847_40028 = state_39758__$1;
(statearr_39847_40028[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (44))){
var inst_39512 = (state_39758[(2)]);
var inst_39513 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_39512);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(45),inst_39513);
} else {
if((state_val_39759 === (93))){
var inst_39634 = (state_39758[(2)]);
var inst_39635 = fluree.db.util.async.throw_err(inst_39634);
var state_39758__$1 = (function (){var statearr_39848 = state_39758;
(statearr_39848[(32)] = inst_39635);

return statearr_39848;
})();
if(cljs.core.truth_(fuel)){
var statearr_39849_40029 = state_39758__$1;
(statearr_39849_40029[(1)] = (94));

} else {
var statearr_39850_40030 = state_39758__$1;
(statearr_39850_40030[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (6))){
var inst_39416 = (state_39758[(33)]);
var state_39758__$1 = state_39758;
var statearr_39851_40031 = state_39758__$1;
(statearr_39851_40031[(2)] = inst_39416);

(statearr_39851_40031[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (111))){
var inst_39684 = (state_39758[(2)]);
var inst_39685 = fluree.db.util.async.throw_err(inst_39684);
var state_39758__$1 = state_39758;
var statearr_39852_40032 = state_39758__$1;
(statearr_39852_40032[(2)] = inst_39685);

(statearr_39852_40032[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (28))){
var inst_39499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39500 = [null,null];
var inst_39501 = (new cljs.core.PersistentVector(null,2,(5),inst_39499,inst_39500,null));
var state_39758__$1 = state_39758;
var statearr_39853_40033 = state_39758__$1;
(statearr_39853_40033[(2)] = inst_39501);

(statearr_39853_40033[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (64))){
var inst_39556 = (state_39758[(2)]);
var inst_39557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39558 = [from];
var inst_39559 = (new cljs.core.PersistentVector(null,1,(5),inst_39557,inst_39558,null));
var inst_39560 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_39559,inst_39556);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(65),inst_39560);
} else {
if((state_val_39759 === (103))){
var inst_39667 = (state_39758[(15)]);
var inst_39672 = cljs.core.int_QMARK_(inst_39667);
var state_39758__$1 = state_39758;
if(inst_39672){
var statearr_39854_40034 = state_39758__$1;
(statearr_39854_40034[(1)] = (105));

} else {
var statearr_39855_40035 = state_39758__$1;
(statearr_39855_40035[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (51))){
var inst_39461 = (state_39758[(14)]);
var state_39758__$1 = state_39758;
var statearr_39856_40036 = state_39758__$1;
(statearr_39856_40036[(2)] = inst_39461);

(statearr_39856_40036[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (25))){
var inst_39462 = (state_39758[(21)]);
var state_39758__$1 = state_39758;
var statearr_39857_40037 = state_39758__$1;
(statearr_39857_40037[(2)] = inst_39462);

(statearr_39857_40037[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (34))){
var state_39758__$1 = state_39758;
var statearr_39858_40038 = state_39758__$1;
(statearr_39858_40038[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (125))){
var inst_39459 = (state_39758[(11)]);
var inst_39461 = (state_39758[(14)]);
var inst_39505 = (state_39758[(31)]);
var inst_39504 = (state_39758[(27)]);
var inst_39734 = (state_39758[(28)]);
var inst_39736 = fluree.db.query.fql.sort_offset_and_limit_res(inst_39504,inst_39505,inst_39461,inst_39459,inst_39734);
var state_39758__$1 = state_39758;
var statearr_39860_40039 = state_39758__$1;
(statearr_39860_40039[(2)] = inst_39736);

(statearr_39860_40039[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (17))){
var inst_39452 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39452)){
var statearr_39861_40040 = state_39758__$1;
(statearr_39861_40040[(1)] = (21));

} else {
var statearr_39862_40041 = state_39758__$1;
(statearr_39862_40041[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (3))){
var inst_39756 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39758__$1,inst_39756);
} else {
if((state_val_39759 === (12))){
var inst_39422 = (state_39758[(34)]);
var state_39758__$1 = state_39758;
var statearr_39863_40042 = state_39758__$1;
(statearr_39863_40042[(2)] = inst_39422);

(statearr_39863_40042[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (2))){
var inst_39416 = (state_39758[(33)]);
var _ = (function (){var statearr_39864 = state_39758;
(statearr_39864[(4)] = cljs.core.cons((5),(state_39758[(4)])));

return statearr_39864;
})();
var inst_39416__$1 = select;
var state_39758__$1 = (function (){var statearr_39865 = state_39758;
(statearr_39865[(33)] = inst_39416__$1);

return statearr_39865;
})();
if(cljs.core.truth_(inst_39416__$1)){
var statearr_39866_40043 = state_39758__$1;
(statearr_39866_40043[(1)] = (6));

} else {
var statearr_39867_40044 = state_39758__$1;
(statearr_39867_40044[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (66))){
var inst_39567 = (state_39758[(2)]);
var inst_39568 = fluree.db.util.async.throw_err(inst_39567);
var state_39758__$1 = state_39758;
var statearr_39868_40045 = state_39758__$1;
(statearr_39868_40045[(2)] = inst_39568);

(statearr_39868_40045[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (107))){
var inst_39687 = (state_39758[(35)]);
var inst_39687__$1 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39869 = state_39758;
(statearr_39869[(35)] = inst_39687__$1);

return statearr_39869;
})();
if(cljs.core.truth_(inst_39687__$1)){
var statearr_39870_40046 = state_39758__$1;
(statearr_39870_40046[(1)] = (112));

} else {
var statearr_39871_40047 = state_39758__$1;
(statearr_39871_40047[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (23))){
var inst_39435 = (state_39758[(36)]);
var inst_39460 = (state_39758[(20)]);
var inst_39457 = (state_39758[(2)]);
var inst_39458 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39457,cljs.core.cst$kw$orderBy);
var inst_39459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39457,cljs.core.cst$kw$limit);
var inst_39460__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39457,cljs.core.cst$kw$component);
var inst_39461 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39457,cljs.core.cst$kw$offset);
var inst_39462 = fluree.db.query.fql_parser.parse_db(db,inst_39435,opts_SINGLEQUOTE_);
var inst_39463 = (inst_39460__$1 == null);
var inst_39464 = cljs.core.not(inst_39463);
var state_39758__$1 = (function (){var statearr_39872 = state_39758;
(statearr_39872[(11)] = inst_39459);

(statearr_39872[(14)] = inst_39461);

(statearr_39872[(13)] = inst_39458);

(statearr_39872[(20)] = inst_39460__$1);

(statearr_39872[(21)] = inst_39462);

return statearr_39872;
})();
if(inst_39464){
var statearr_39873_40048 = state_39758__$1;
(statearr_39873_40048[(1)] = (24));

} else {
var statearr_39874_40049 = state_39758__$1;
(statearr_39874_40049[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (47))){
var state_39758__$1 = state_39758;
var statearr_39875_40050 = state_39758__$1;
(statearr_39875_40050[(2)] = null);

(statearr_39875_40050[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (35))){
var inst_39495 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39876_40051 = state_39758__$1;
(statearr_39876_40051[(2)] = inst_39495);

(statearr_39876_40051[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (127))){
var inst_39740 = (state_39758[(24)]);
var inst_39739 = (state_39758[(2)]);
var inst_39740__$1 = selectOne;
var state_39758__$1 = (function (){var statearr_39877 = state_39758;
(statearr_39877[(24)] = inst_39740__$1);

(statearr_39877[(17)] = inst_39739);

return statearr_39877;
})();
if(cljs.core.truth_(inst_39740__$1)){
var statearr_39878_40052 = state_39758__$1;
(statearr_39878_40052[(1)] = (128));

} else {
var statearr_39879_40053 = state_39758__$1;
(statearr_39879_40053[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (82))){
var inst_39459 = (state_39758[(11)]);
var inst_39461 = (state_39758[(14)]);
var inst_39603 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_39604 = [inst_39459,inst_39461];
var inst_39605 = cljs.core.PersistentHashMap.fromArrays(inst_39603,inst_39604);
var state_39758__$1 = state_39758;
var statearr_39880_40054 = state_39758__$1;
(statearr_39880_40054[(2)] = inst_39605);

(statearr_39880_40054[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (76))){
var inst_39471 = (state_39758[(7)]);
var inst_39469 = (state_39758[(9)]);
var inst_39591 = (state_39758[(2)]);
var inst_39592 = fluree.db.util.async.throw_err(inst_39591);
var inst_39593 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_39471,fuel,max_fuel,inst_39469,inst_39592);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(77),inst_39593);
} else {
if((state_val_39759 === (97))){
var inst_39655 = from;
var inst_39656 = cljs.core.seq(inst_39655);
var inst_39657 = cljs.core.first(inst_39656);
var inst_39658 = cljs.core.next(inst_39656);
var inst_39659 = cljs.core.PersistentVector.EMPTY;
var inst_39660 = inst_39655;
var inst_39661 = inst_39659;
var state_39758__$1 = (function (){var statearr_39881 = state_39758;
(statearr_39881[(37)] = inst_39657);

(statearr_39881[(22)] = inst_39661);

(statearr_39881[(38)] = inst_39658);

(statearr_39881[(29)] = inst_39660);

return statearr_39881;
})();
var statearr_39882_40055 = state_39758__$1;
(statearr_39882_40055[(2)] = null);

(statearr_39882_40055[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (19))){
var state_39758__$1 = state_39758;
var statearr_39883_40056 = state_39758__$1;
(statearr_39883_40056[(2)] = false);

(statearr_39883_40056[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (57))){
var inst_39536 = (state_39758[(26)]);
var state_39758__$1 = state_39758;
var statearr_39884_40057 = state_39758__$1;
(statearr_39884_40057[(2)] = inst_39536);

(statearr_39884_40057[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (68))){
var state_39758__$1 = state_39758;
var statearr_39885_40058 = state_39758__$1;
(statearr_39885_40058[(2)] = false);

(statearr_39885_40058[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (11))){
var inst_39433 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39886_40059 = state_39758__$1;
(statearr_39886_40059[(2)] = inst_39433);

(statearr_39886_40059[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (115))){
var inst_39710 = (state_39758[(2)]);
var inst_39711 = fluree.db.util.async.throw_err(inst_39710);
var state_39758__$1 = state_39758;
var statearr_39888_40060 = state_39758__$1;
(statearr_39888_40060[(2)] = inst_39711);

(statearr_39888_40060[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (9))){
var inst_39419 = (state_39758[(18)]);
var state_39758__$1 = state_39758;
var statearr_39889_40061 = state_39758__$1;
(statearr_39889_40061[(2)] = inst_39419);

(statearr_39889_40061[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (5))){
var _ = (function (){var statearr_39890 = state_39758;
(statearr_39890[(4)] = cljs.core.rest((state_39758[(4)])));

return statearr_39890;
})();
var state_39758__$1 = state_39758;
var ex39887 = (state_39758__$1[(2)]);
var statearr_39891_40062 = state_39758__$1;
(statearr_39891_40062[(5)] = ex39887);


if((ex39887 instanceof Error)){
var statearr_39892_40063 = state_39758__$1;
(statearr_39892_40063[(1)] = (4));

(statearr_39892_40063[(5)] = null);

} else {
throw ex39887;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (112))){
var inst_39661 = (state_39758[(22)]);
var inst_39687 = (state_39758[(35)]);
var inst_39689 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39661,inst_39687);
var state_39758__$1 = state_39758;
var statearr_39893_40064 = state_39758__$1;
(statearr_39893_40064[(2)] = inst_39689);

(statearr_39893_40064[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (83))){
var inst_39607 = (state_39758[(2)]);
var inst_39608 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_39607);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(84),inst_39608);
} else {
if((state_val_39759 === (14))){
var inst_39431 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39894_40065 = state_39758__$1;
(statearr_39894_40065[(2)] = inst_39431);

(statearr_39894_40065[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (45))){
var inst_39458 = (state_39758[(13)]);
var inst_39515 = (state_39758[(2)]);
var inst_39516 = fluree.db.util.async.throw_err(inst_39515);
var state_39758__$1 = (function (){var statearr_39895 = state_39758;
(statearr_39895[(39)] = inst_39516);

return statearr_39895;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39896_40066 = state_39758__$1;
(statearr_39896_40066[(1)] = (47));

} else {
var statearr_39897_40067 = state_39758__$1;
(statearr_39897_40067[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (53))){
var inst_39536 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_39758__$1 = (function (){var statearr_39898 = state_39758;
(statearr_39898[(26)] = inst_39536);

return statearr_39898;
})();
if(cljs.core.truth_(fuel)){
var statearr_39899_40068 = state_39758__$1;
(statearr_39899_40068[(1)] = (56));

} else {
var statearr_39900_40069 = state_39758__$1;
(statearr_39900_40069[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (78))){
var inst_39458 = (state_39758[(13)]);
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39458)){
var statearr_39901_40070 = state_39758__$1;
(statearr_39901_40070[(1)] = (81));

} else {
var statearr_39902_40071 = state_39758__$1;
(statearr_39902_40071[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (132))){
var inst_39739 = (state_39758[(17)]);
var state_39758__$1 = state_39758;
var statearr_39903_40072 = state_39758__$1;
(statearr_39903_40072[(2)] = inst_39739);

(statearr_39903_40072[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (26))){
var inst_39458 = (state_39758[(13)]);
var inst_39469 = (state_39758[(2)]);
var inst_39470 = cljs.core.PersistentHashMap.EMPTY;
var inst_39471 = cljs.core.volatile_BANG_(inst_39470);
var state_39758__$1 = (function (){var statearr_39904 = state_39758;
(statearr_39904[(7)] = inst_39471);

(statearr_39904[(9)] = inst_39469);

return statearr_39904;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39905_40073 = state_39758__$1;
(statearr_39905_40073[(1)] = (27));

} else {
var statearr_39906_40074 = state_39758__$1;
(statearr_39906_40074[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (123))){
var state_39758__$1 = state_39758;
var statearr_39907_40075 = state_39758__$1;
(statearr_39907_40075[(2)] = null);

(statearr_39907_40075[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (16))){
var state_39758__$1 = state_39758;
var statearr_39908_40076 = state_39758__$1;
(statearr_39908_40076[(2)] = false);

(statearr_39908_40076[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (133))){
var inst_39753 = (state_39758[(2)]);
var _ = (function (){var statearr_39909 = state_39758;
(statearr_39909[(4)] = cljs.core.rest((state_39758[(4)])));

return statearr_39909;
})();
var state_39758__$1 = state_39758;
var statearr_39910_40077 = state_39758__$1;
(statearr_39910_40077[(2)] = inst_39753);

(statearr_39910_40077[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (81))){
var inst_39601 = cljs.core.PersistentHashMap.EMPTY;
var state_39758__$1 = state_39758;
var statearr_39911_40078 = state_39758__$1;
(statearr_39911_40078[(2)] = inst_39601);

(statearr_39911_40078[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (120))){
var inst_39461 = (state_39758[(14)]);
var state_39758__$1 = state_39758;
var statearr_39912_40079 = state_39758__$1;
(statearr_39912_40079[(2)] = inst_39461);

(statearr_39912_40079[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (79))){
var inst_39617 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_39758__$1 = state_39758;
if(inst_39617){
var statearr_39913_40080 = state_39758__$1;
(statearr_39913_40080[(1)] = (86));

} else {
var statearr_39914_40081 = state_39758__$1;
(statearr_39914_40081[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (38))){
var inst_39493 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39915_40082 = state_39758__$1;
(statearr_39915_40082[(2)] = inst_39493);

(statearr_39915_40082[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (126))){
var inst_39734 = (state_39758[(28)]);
var state_39758__$1 = state_39758;
var statearr_39916_40083 = state_39758__$1;
(statearr_39916_40083[(2)] = inst_39734);

(statearr_39916_40083[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (98))){
var state_39758__$1 = state_39758;
var statearr_39917_40084 = state_39758__$1;
(statearr_39917_40084[(1)] = (122));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (124))){
var inst_39722 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39919_40085 = state_39758__$1;
(statearr_39919_40085[(2)] = inst_39722);

(statearr_39919_40085[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (87))){
var inst_39644 = cljs.core.sequential_QMARK_(from);
var inst_39645 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_39646 = ((inst_39644) && (inst_39645));
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39646)){
var statearr_39920_40086 = state_39758__$1;
(statearr_39920_40086[(1)] = (97));

} else {
var statearr_39921_40087 = state_39758__$1;
(statearr_39921_40087[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (30))){
var inst_39458 = (state_39758[(13)]);
var inst_39475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39476 = cljs.core.second(inst_39458);
var inst_39477 = cljs.core.first(inst_39458);
var inst_39478 = [inst_39476,inst_39477];
var inst_39479 = (new cljs.core.PersistentVector(null,2,(5),inst_39475,inst_39478,null));
var state_39758__$1 = state_39758;
var statearr_39922_40088 = state_39758__$1;
(statearr_39922_40088[(2)] = inst_39479);

(statearr_39922_40088[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (73))){
var inst_39582 = cljs.core.PersistentHashMap.EMPTY;
var state_39758__$1 = state_39758;
var statearr_39923_40089 = state_39758__$1;
(statearr_39923_40089[(2)] = inst_39582);

(statearr_39923_40089[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (96))){
var inst_39635 = (state_39758[(32)]);
var inst_39642 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39924 = state_39758;
(statearr_39924[(40)] = inst_39642);

return statearr_39924;
})();
var statearr_39925_40090 = state_39758__$1;
(statearr_39925_40090[(2)] = inst_39635);

(statearr_39925_40090[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (10))){
var inst_39422 = (state_39758[(34)]);
var inst_39422__$1 = selectDistinct;
var state_39758__$1 = (function (){var statearr_39926 = state_39758;
(statearr_39926[(34)] = inst_39422__$1);

return statearr_39926;
})();
if(cljs.core.truth_(inst_39422__$1)){
var statearr_39927_40091 = state_39758__$1;
(statearr_39927_40091[(1)] = (12));

} else {
var statearr_39928_40092 = state_39758__$1;
(statearr_39928_40092[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (18))){
var state_39758__$1 = state_39758;
var statearr_39929_40093 = state_39758__$1;
(statearr_39929_40093[(2)] = true);

(statearr_39929_40093[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (105))){
var inst_39667 = (state_39758[(15)]);
var state_39758__$1 = state_39758;
var statearr_39930_40094 = state_39758__$1;
(statearr_39930_40094[(2)] = inst_39667);

(statearr_39930_40094[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (52))){
var inst_39471 = (state_39758[(7)]);
var inst_39520 = (state_39758[(41)]);
var inst_39469 = (state_39758[(9)]);
var inst_39516 = (state_39758[(39)]);
var inst_39524 = (state_39758[(2)]);
var inst_39525 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_39471,fuel,max_fuel,inst_39469,inst_39516,inst_39520,inst_39524);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(46),inst_39525);
} else {
if((state_val_39759 === (114))){
var inst_39668 = (state_39758[(30)]);
var inst_39692 = (state_39758[(2)]);
var inst_39660 = inst_39668;
var inst_39661 = inst_39692;
var state_39758__$1 = (function (){var statearr_39931 = state_39758;
(statearr_39931[(22)] = inst_39661);

(statearr_39931[(29)] = inst_39660);

return statearr_39931;
})();
var statearr_39932_40095 = state_39758__$1;
(statearr_39932_40095[(2)] = null);

(statearr_39932_40095[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (67))){
var inst_39573 = ["_tx",null,"_block",null];
var inst_39574 = (new cljs.core.PersistentArrayMap(null,2,inst_39573,null));
var inst_39575 = (new cljs.core.PersistentHashSet(null,inst_39574,null));
var inst_39576 = (inst_39575.cljs$core$IFn$_invoke$arity$1 ? inst_39575.cljs$core$IFn$_invoke$arity$1(from) : inst_39575.call(null,from));
var state_39758__$1 = state_39758;
var statearr_39933_40096 = state_39758__$1;
(statearr_39933_40096[(2)] = inst_39576);

(statearr_39933_40096[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (71))){
var inst_39598 = typeof from === 'string';
var state_39758__$1 = state_39758;
if(cljs.core.truth_(inst_39598)){
var statearr_39934_40097 = state_39758__$1;
(statearr_39934_40097[(1)] = (78));

} else {
var statearr_39935_40098 = state_39758__$1;
(statearr_39935_40098[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (42))){
var state_39758__$1 = state_39758;
var statearr_39936_40099 = state_39758__$1;
(statearr_39936_40099[(2)] = from);

(statearr_39936_40099[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (80))){
var inst_39728 = (state_39758[(2)]);
var state_39758__$1 = state_39758;
var statearr_39937_40100 = state_39758__$1;
(statearr_39937_40100[(2)] = inst_39728);

(statearr_39937_40100[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (37))){
var state_39758__$1 = state_39758;
var statearr_39938_40101 = state_39758__$1;
(statearr_39938_40101[(2)] = null);

(statearr_39938_40101[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (63))){
var inst_39459 = (state_39758[(11)]);
var inst_39461 = (state_39758[(14)]);
var inst_39552 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_39553 = [inst_39459,inst_39461];
var inst_39554 = cljs.core.PersistentHashMap.fromArrays(inst_39552,inst_39553);
var state_39758__$1 = state_39758;
var statearr_39939_40102 = state_39758__$1;
(statearr_39939_40102[(2)] = inst_39554);

(statearr_39939_40102[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (94))){
var inst_39637 = cljs.core._deref(fuel);
var inst_39638 = (inst_39637 + (1));
var inst_39639 = cljs.core._vreset_BANG_(fuel,inst_39638);
var state_39758__$1 = state_39758;
var statearr_39940_40103 = state_39758__$1;
(statearr_39940_40103[(2)] = inst_39639);

(statearr_39940_40103[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (8))){
var inst_39436 = (state_39758[(23)]);
var inst_39435 = (state_39758[(2)]);
var inst_39436__$1 = opts_SINGLEQUOTE_;
var inst_39438 = (inst_39436__$1 == null);
var inst_39439 = cljs.core.not(inst_39438);
var state_39758__$1 = (function (){var statearr_39941 = state_39758;
(statearr_39941[(36)] = inst_39435);

(statearr_39941[(23)] = inst_39436__$1);

return statearr_39941;
})();
if(inst_39439){
var statearr_39942_40104 = state_39758__$1;
(statearr_39942_40104[(1)] = (15));

} else {
var statearr_39943_40105 = state_39758__$1;
(statearr_39943_40105[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (49))){
var inst_39458 = (state_39758[(13)]);
var inst_39520 = (state_39758[(2)]);
var state_39758__$1 = (function (){var statearr_39944 = state_39758;
(statearr_39944[(41)] = inst_39520);

return statearr_39944;
})();
if(cljs.core.truth_(inst_39458)){
var statearr_39945_40106 = state_39758__$1;
(statearr_39945_40106[(1)] = (50));

} else {
var statearr_39946_40107 = state_39758__$1;
(statearr_39946_40107[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39759 === (84))){
var inst_39471 = (state_39758[(7)]);
var inst_39469 = (state_39758[(9)]);
var inst_39610 = (state_39758[(2)]);
var inst_39611 = fluree.db.util.async.throw_err(inst_39610);
var inst_39612 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_39471,fuel,max_fuel,inst_39469,inst_39611);
var state_39758__$1 = state_39758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39758__$1,(85),inst_39612);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16301__auto____0 = (function (){
var statearr_39947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39947[(0)] = fluree$db$query$fql$query_$_state_machine__16301__auto__);

(statearr_39947[(1)] = (1));

return statearr_39947;
});
var fluree$db$query$fql$query_$_state_machine__16301__auto____1 = (function (state_39758){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39758);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39948){var ex__16304__auto__ = e39948;
var statearr_39949_40108 = state_39758;
(statearr_39949_40108[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39758[(4)]))){
var statearr_39950_40109 = state_39758;
(statearr_39950_40109[(1)] = cljs.core.first((state_39758[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40110 = state_39758;
state_39758 = G__40110;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16301__auto__ = function(state_39758){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16301__auto____1.call(this,state_39758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16301__auto____0;
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39951 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39951[(6)] = c__16375__auto__);

return statearr_39951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}

});
