// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34886){
var state_val_34887 = (state_34886[(1)]);
if((state_val_34887 === (1))){
var state_34886__$1 = state_34886;
var statearr_34888_34902 = state_34886__$1;
(statearr_34888_34902[(2)] = null);

(statearr_34888_34902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34887 === (2))){
var _ = (function (){var statearr_34889 = state_34886;
(statearr_34889[(4)] = cljs.core.cons((5),(state_34886[(4)])));

return statearr_34889;
})();
var inst_34877 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_34886__$1 = state_34886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34886__$1,(6),inst_34877);
} else {
if((state_val_34887 === (3))){
var inst_34884 = (state_34886[(2)]);
var state_34886__$1 = state_34886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34886__$1,inst_34884);
} else {
if((state_val_34887 === (4))){
var inst_34871 = (state_34886[(2)]);
var state_34886__$1 = state_34886;
var statearr_34891_34903 = state_34886__$1;
(statearr_34891_34903[(2)] = inst_34871);

(statearr_34891_34903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34887 === (5))){
var _ = (function (){var statearr_34892 = state_34886;
(statearr_34892[(4)] = cljs.core.rest((state_34886[(4)])));

return statearr_34892;
})();
var state_34886__$1 = state_34886;
var ex34890 = (state_34886__$1[(2)]);
var statearr_34893_34904 = state_34886__$1;
(statearr_34893_34904[(5)] = ex34890);


if((ex34890 instanceof Error)){
var statearr_34894_34905 = state_34886__$1;
(statearr_34894_34905[(1)] = (4));

(statearr_34894_34905[(5)] = null);

} else {
throw ex34890;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34887 === (6))){
var inst_34879 = (state_34886[(2)]);
var inst_34880 = fluree.db.util.async.throw_err(inst_34879);
var inst_34881 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34880);
var _ = (function (){var statearr_34895 = state_34886;
(statearr_34895[(4)] = cljs.core.rest((state_34886[(4)])));

return statearr_34895;
})();
var state_34886__$1 = state_34886;
var statearr_34896_34906 = state_34886__$1;
(statearr_34896_34906[(2)] = inst_34881);

(statearr_34896_34906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0 = (function (){
var statearr_34897 = [null,null,null,null,null,null,null];
(statearr_34897[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__);

(statearr_34897[(1)] = (1));

return statearr_34897;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1 = (function (state_34886){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34886);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34898){var ex__16304__auto__ = e34898;
var statearr_34899_34907 = state_34886;
(statearr_34899_34907[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34886[(4)]))){
var statearr_34900_34908 = state_34886;
(statearr_34900_34908[(1)] = cljs.core.first((state_34886[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34909 = state_34886;
state_34886 = G__34909;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__ = function(state_34886){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1.call(this,state_34886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34901 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34901[(6)] = c__16375__auto__);

return statearr_34901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34941){
var state_val_34942 = (state_34941[(1)]);
if((state_val_34942 === (7))){
var inst_34925 = (state_34941[(7)]);
var inst_34927 = cljs.core.empty_QMARK_(inst_34925);
var inst_34928 = (!(inst_34927));
var state_34941__$1 = state_34941;
var statearr_34943_34967 = state_34941__$1;
(statearr_34943_34967[(2)] = inst_34928);

(statearr_34943_34967[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (1))){
var state_34941__$1 = state_34941;
var statearr_34944_34968 = state_34941__$1;
(statearr_34944_34968[(2)] = null);

(statearr_34944_34968[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (4))){
var inst_34911 = (state_34941[(2)]);
var state_34941__$1 = state_34941;
var statearr_34945_34969 = state_34941__$1;
(statearr_34945_34969[(2)] = inst_34911);

(statearr_34945_34969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (6))){
var inst_34925 = (state_34941[(7)]);
var inst_34917 = (state_34941[(8)]);
var inst_34923 = (state_34941[(2)]);
var inst_34924 = fluree.db.util.async.throw_err(inst_34923);
var inst_34925__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34917,inst_34924);
var state_34941__$1 = (function (){var statearr_34946 = state_34941;
(statearr_34946[(7)] = inst_34925__$1);

return statearr_34946;
})();
if(cljs.core.truth_(inst_34925__$1)){
var statearr_34947_34970 = state_34941__$1;
(statearr_34947_34970[(1)] = (7));

} else {
var statearr_34948_34971 = state_34941__$1;
(statearr_34948_34971[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (3))){
var inst_34939 = (state_34941[(2)]);
var state_34941__$1 = state_34941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34941__$1,inst_34939);
} else {
if((state_val_34942 === (12))){
var inst_34936 = (state_34941[(2)]);
var _ = (function (){var statearr_34949 = state_34941;
(statearr_34949[(4)] = cljs.core.rest((state_34941[(4)])));

return statearr_34949;
})();
var state_34941__$1 = state_34941;
var statearr_34950_34972 = state_34941__$1;
(statearr_34950_34972[(2)] = inst_34936);

(statearr_34950_34972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (2))){
var _ = (function (){var statearr_34951 = state_34941;
(statearr_34951[(4)] = cljs.core.cons((5),(state_34941[(4)])));

return statearr_34951;
})();
var inst_34917 = (function (){return (function (p1__34910_SHARP_){
return p1__34910_SHARP_.o;
});
})();
var inst_34918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34919 = [pred_id];
var inst_34920 = (new cljs.core.PersistentVector(null,1,(5),inst_34918,inst_34919,null));
var inst_34921 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_34920);
var state_34941__$1 = (function (){var statearr_34952 = state_34941;
(statearr_34952[(8)] = inst_34917);

return statearr_34952;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34941__$1,(6),inst_34921);
} else {
if((state_val_34942 === (11))){
var state_34941__$1 = state_34941;
var statearr_34954_34973 = state_34941__$1;
(statearr_34954_34973[(2)] = true);

(statearr_34954_34973[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (9))){
var inst_34931 = (state_34941[(2)]);
var state_34941__$1 = state_34941;
if(cljs.core.truth_(inst_34931)){
var statearr_34955_34974 = state_34941__$1;
(statearr_34955_34974[(1)] = (10));

} else {
var statearr_34956_34975 = state_34941__$1;
(statearr_34956_34975[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (5))){
var _ = (function (){var statearr_34957 = state_34941;
(statearr_34957[(4)] = cljs.core.rest((state_34941[(4)])));

return statearr_34957;
})();
var state_34941__$1 = state_34941;
var ex34953 = (state_34941__$1[(2)]);
var statearr_34958_34976 = state_34941__$1;
(statearr_34958_34976[(5)] = ex34953);


if((ex34953 instanceof Error)){
var statearr_34959_34977 = state_34941__$1;
(statearr_34959_34977[(1)] = (4));

(statearr_34959_34977[(5)] = null);

} else {
throw ex34953;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (10))){
var inst_34925 = (state_34941[(7)]);
var inst_34933 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_34925);
var state_34941__$1 = state_34941;
var statearr_34960_34978 = state_34941__$1;
(statearr_34960_34978[(2)] = inst_34933);

(statearr_34960_34978[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34942 === (8))){
var inst_34925 = (state_34941[(7)]);
var state_34941__$1 = state_34941;
var statearr_34961_34979 = state_34941__$1;
(statearr_34961_34979[(2)] = inst_34925);

(statearr_34961_34979[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_34962 = [null,null,null,null,null,null,null,null,null];
(statearr_34962[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__);

(statearr_34962[(1)] = (1));

return statearr_34962;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1 = (function (state_34941){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34941);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34963){var ex__16304__auto__ = e34963;
var statearr_34964_34980 = state_34941;
(statearr_34964_34980[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34941[(4)]))){
var statearr_34965_34981 = state_34941;
(statearr_34965_34981[(1)] = cljs.core.first((state_34941[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34982 = state_34941;
state_34941 = G__34982;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__ = function(state_34941){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1.call(this,state_34941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34966 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34966[(6)] = c__16375__auto__);

return statearr_34966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35059){
var state_val_35060 = (state_35059[(1)]);
if((state_val_35060 === (7))){
var inst_35054 = (state_35059[(2)]);
var _ = (function (){var statearr_35061 = state_35059;
(statearr_35061[(4)] = cljs.core.rest((state_35059[(4)])));

return statearr_35061;
})();
var state_35059__$1 = state_35059;
var statearr_35062_35095 = state_35059__$1;
(statearr_35062_35095[(2)] = inst_35054);

(statearr_35062_35095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (1))){
var state_35059__$1 = state_35059;
var statearr_35063_35096 = state_35059__$1;
(statearr_35063_35096[(2)] = null);

(statearr_35063_35096[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (4))){
var inst_34985 = (state_35059[(2)]);
var state_35059__$1 = state_35059;
var statearr_35064_35097 = state_35059__$1;
(statearr_35064_35097[(2)] = inst_34985);

(statearr_35064_35097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (15))){
var inst_35015 = (state_35059[(7)]);
var inst_35035 = (state_35059[(8)]);
var inst_35009 = (state_35059[(9)]);
var inst_35022 = (state_35059[(10)]);
var inst_35037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35038 = inst_35015.s;
var inst_35039 = [inst_35038,inst_35022,cljs.core.cst$kw$old];
var inst_35040 = (new cljs.core.PersistentVector(null,3,(5),inst_35037,inst_35039,null));
var inst_35041 = cljs.core.assoc_in(inst_35009,inst_35040,inst_35035);
var state_35059__$1 = state_35059;
var statearr_35065_35098 = state_35059__$1;
(statearr_35065_35098[(2)] = inst_35041);

(statearr_35065_35098[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (13))){
var inst_35024 = (state_35059[(11)]);
var inst_35035 = (state_35059[(2)]);
var state_35059__$1 = (function (){var statearr_35066 = state_35059;
(statearr_35066[(8)] = inst_35035);

return statearr_35066;
})();
if(cljs.core.truth_(inst_35024)){
var statearr_35067_35099 = state_35059__$1;
(statearr_35067_35099[(1)] = (15));

} else {
var statearr_35068_35100 = state_35059__$1;
(statearr_35068_35100[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (6))){
var inst_35008 = (state_35059[(12)]);
var inst_35015 = (state_35059[(7)]);
var inst_35014 = cljs.core.seq(inst_35008);
var inst_35015__$1 = cljs.core.first(inst_35014);
var inst_35016 = cljs.core.next(inst_35014);
var inst_35017 = cljs.core.not(inst_35015__$1);
var state_35059__$1 = (function (){var statearr_35069 = state_35059;
(statearr_35069[(7)] = inst_35015__$1);

(statearr_35069[(13)] = inst_35016);

return statearr_35069;
})();
if(inst_35017){
var statearr_35070_35101 = state_35059__$1;
(statearr_35070_35101[(1)] = (8));

} else {
var statearr_35071_35102 = state_35059__$1;
(statearr_35071_35102[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (17))){
var inst_35016 = (state_35059[(13)]);
var inst_35049 = (state_35059[(2)]);
var inst_35008 = inst_35016;
var inst_35009 = inst_35049;
var state_35059__$1 = (function (){var statearr_35072 = state_35059;
(statearr_35072[(12)] = inst_35008);

(statearr_35072[(9)] = inst_35009);

return statearr_35072;
})();
var statearr_35073_35103 = state_35059__$1;
(statearr_35073_35103[(2)] = null);

(statearr_35073_35103[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (3))){
var inst_35057 = (state_35059[(2)]);
var state_35059__$1 = state_35059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35059__$1,inst_35057);
} else {
if((state_val_35060 === (12))){
var inst_35015 = (state_35059[(7)]);
var inst_35033 = inst_35015.o;
var state_35059__$1 = state_35059;
var statearr_35074_35104 = state_35059__$1;
(statearr_35074_35104[(2)] = inst_35033);

(statearr_35074_35104[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (2))){
var _ = (function (){var statearr_35075 = state_35059;
(statearr_35075[(4)] = cljs.core.cons((5),(state_35059[(4)])));

return statearr_35075;
})();
var inst_34991 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_34992 = cljs.core.PersistentHashSet.EMPTY;
var inst_34993 = cljs.core.vals(tempids);
var inst_34994 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34992,inst_34993);
var inst_34995 = (function (){var pred_flakes = inst_34991;
var is_new_QMARK_ = inst_34994;
return (function (p1__34983_SHARP_,p2__34984_SHARP_){
return cljs.core.assoc_in(p1__34983_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__34984_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__35076 = p2__34984_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__35076) : is_new_QMARK_.call(null,G__35076));
})()));
});
})();
var inst_34996 = cljs.core.PersistentHashMap.EMPTY;
var inst_34997 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34995,inst_34996,inst_34991);
var inst_35005 = cljs.core.seq(inst_34991);
var inst_35006 = cljs.core.first(inst_35005);
var inst_35007 = cljs.core.next(inst_35005);
var inst_35008 = inst_34991;
var inst_35009 = inst_34997;
var state_35059__$1 = (function (){var statearr_35077 = state_35059;
(statearr_35077[(12)] = inst_35008);

(statearr_35077[(14)] = inst_35006);

(statearr_35077[(9)] = inst_35009);

(statearr_35077[(15)] = inst_35007);

return statearr_35077;
})();
var statearr_35078_35105 = state_35059__$1;
(statearr_35078_35105[(2)] = null);

(statearr_35078_35105[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (11))){
var inst_35015 = (state_35059[(7)]);
var inst_35027 = inst_35015.o;
var inst_35028 = fluree.db.query.schema.convert_type_to_kw(inst_35027,db);
var state_35059__$1 = state_35059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35059__$1,(14),inst_35028);
} else {
if((state_val_35060 === (9))){
var inst_35015 = (state_35059[(7)]);
var inst_35022 = (state_35059[(10)]);
var inst_35020 = inst_35015.p;
var inst_35021 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_35020);
var inst_35022__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_35021);
var inst_35023 = inst_35015.op;
var inst_35024 = inst_35023 === false;
var inst_35025 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_35022__$1);
var state_35059__$1 = (function (){var statearr_35080 = state_35059;
(statearr_35080[(11)] = inst_35024);

(statearr_35080[(10)] = inst_35022__$1);

return statearr_35080;
})();
if(inst_35025){
var statearr_35081_35106 = state_35059__$1;
(statearr_35081_35106[(1)] = (11));

} else {
var statearr_35082_35107 = state_35059__$1;
(statearr_35082_35107[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (5))){
var _ = (function (){var statearr_35083 = state_35059;
(statearr_35083[(4)] = cljs.core.rest((state_35059[(4)])));

return statearr_35083;
})();
var state_35059__$1 = state_35059;
var ex35079 = (state_35059__$1[(2)]);
var statearr_35084_35108 = state_35059__$1;
(statearr_35084_35108[(5)] = ex35079);


if((ex35079 instanceof Error)){
var statearr_35085_35109 = state_35059__$1;
(statearr_35085_35109[(1)] = (4));

(statearr_35085_35109[(5)] = null);

} else {
throw ex35079;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (14))){
var inst_35030 = (state_35059[(2)]);
var inst_35031 = fluree.db.util.async.throw_err(inst_35030);
var state_35059__$1 = state_35059;
var statearr_35086_35110 = state_35059__$1;
(statearr_35086_35110[(2)] = inst_35031);

(statearr_35086_35110[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (16))){
var inst_35015 = (state_35059[(7)]);
var inst_35035 = (state_35059[(8)]);
var inst_35009 = (state_35059[(9)]);
var inst_35022 = (state_35059[(10)]);
var inst_35043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35044 = inst_35015.s;
var inst_35045 = [inst_35044,inst_35022,cljs.core.cst$kw$new];
var inst_35046 = (new cljs.core.PersistentVector(null,3,(5),inst_35043,inst_35045,null));
var inst_35047 = cljs.core.assoc_in(inst_35009,inst_35046,inst_35035);
var state_35059__$1 = state_35059;
var statearr_35087_35111 = state_35059__$1;
(statearr_35087_35111[(2)] = inst_35047);

(statearr_35087_35111[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (10))){
var inst_35052 = (state_35059[(2)]);
var state_35059__$1 = state_35059;
var statearr_35088_35112 = state_35059__$1;
(statearr_35088_35112[(2)] = inst_35052);

(statearr_35088_35112[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35060 === (8))){
var inst_35009 = (state_35059[(9)]);
var state_35059__$1 = state_35059;
var statearr_35089_35113 = state_35059__$1;
(statearr_35089_35113[(2)] = inst_35009);

(statearr_35089_35113[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0 = (function (){
var statearr_35090 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35090[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__);

(statearr_35090[(1)] = (1));

return statearr_35090;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1 = (function (state_35059){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35059);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35091){var ex__16304__auto__ = e35091;
var statearr_35092_35114 = state_35059;
(statearr_35092_35114[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35059[(4)]))){
var statearr_35093_35115 = state_35059;
(statearr_35093_35115[(1)] = cljs.core.first((state_35059[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35116 = state_35059;
state_35059 = G__35116;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__ = function(state_35059){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1.call(this,state_35059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35094 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35094[(6)] = c__16375__auto__);

return statearr_35094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__35118 = arguments.length;
switch (G__35118) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__35121 = arguments.length;
switch (G__35121) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35430){
var state_val_35431 = (state_35430[(1)]);
if((state_val_35431 === (65))){
var inst_35383 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35432_35604 = state_35430__$1;
(statearr_35432_35604[(2)] = inst_35383);

(statearr_35432_35604[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (70))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35305 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_35306 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_35305,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,2,inst_35305,null));
var inst_35307 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35306,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35306,null));
var inst_35308 = (inst_35307.cljs$core$IFn$_invoke$arity$1 ? inst_35307.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35307.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35308)){
var statearr_35433_35605 = state_35430__$1;
(statearr_35433_35605[(1)] = (71));

} else {
var statearr_35434_35606 = state_35430__$1;
(statearr_35434_35606[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (62))){
var inst_35385 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35435_35607 = state_35430__$1;
(statearr_35435_35607[(2)] = inst_35385);

(statearr_35435_35607[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (74))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35315 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_35316 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_35315,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,3,inst_35315,null));
var inst_35317 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35316,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35316,null));
var inst_35318 = (inst_35317.cljs$core$IFn$_invoke$arity$1 ? inst_35317.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35317.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35318)){
var statearr_35436_35608 = state_35430__$1;
(statearr_35436_35608[(1)] = (75));

} else {
var statearr_35437_35609 = state_35430__$1;
(statearr_35437_35609[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (110))){
var inst_35417 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35438_35610 = state_35430__$1;
(statearr_35438_35610[(2)] = inst_35417);

(statearr_35438_35610[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (7))){
var inst_35425 = (state_35430[(2)]);
var _ = (function (){var statearr_35439 = state_35430;
(statearr_35439[(4)] = cljs.core.rest((state_35430[(4)])));

return statearr_35439;
})();
var state_35430__$1 = state_35430;
var statearr_35440_35611 = state_35430__$1;
(statearr_35440_35611[(2)] = inst_35425);

(statearr_35440_35611[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (59))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35291 = (state_35430[(2)]);
var inst_35292__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35291,cljs.core.cst$kw$old);
var inst_35293__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35291,cljs.core.cst$kw$new);
var inst_35294 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35293__$1,inst_35292__$1);
var state_35430__$1 = (function (){var statearr_35441 = state_35430;
(statearr_35441[(7)] = inst_35293__$1);

(statearr_35441[(8)] = inst_35292__$1);

return statearr_35441;
})();
if(inst_35294){
var statearr_35442_35612 = state_35430__$1;
(statearr_35442_35612[(1)] = (60));

} else {
var statearr_35443_35613 = state_35430__$1;
(statearr_35443_35613[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (86))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35345 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_35346 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_35345,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,5,inst_35345,null));
var inst_35347 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35346,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35346,null));
var inst_35348 = (inst_35347.cljs$core$IFn$_invoke$arity$1 ? inst_35347.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35347.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35348)){
var statearr_35444_35614 = state_35430__$1;
(statearr_35444_35614[(1)] = (87));

} else {
var statearr_35445_35615 = state_35430__$1;
(statearr_35445_35615[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (20))){
var inst_35161 = (state_35430[(9)]);
var inst_35186 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35187 = inst_35186 === true;
var inst_35188 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35189 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35188);
var inst_35190 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_35189);
var inst_35191 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35192 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35191);
var inst_35193 = inst_35192 === true;
var inst_35194 = ((inst_35187) && (inst_35190) && (inst_35193));
var state_35430__$1 = state_35430;
var statearr_35446_35616 = state_35430__$1;
(statearr_35446_35616[(2)] = inst_35194);

(statearr_35446_35616[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (72))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35311 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35447_35617 = state_35430__$1;
(statearr_35447_35617[(2)] = inst_35311);

(statearr_35447_35617[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (58))){
var inst_35270 = (state_35430[(10)]);
var state_35430__$1 = state_35430;
var statearr_35448_35618 = state_35430__$1;
(statearr_35448_35618[(2)] = inst_35270);

(statearr_35448_35618[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (60))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35449_35619 = state_35430__$1;
(statearr_35449_35619[(2)] = inst_35260);

(statearr_35449_35619[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (27))){
var inst_35181 = (state_35430[(12)]);
var state_35430__$1 = state_35430;
var statearr_35450_35620 = state_35430__$1;
(statearr_35450_35620[(2)] = inst_35181);

(statearr_35450_35620[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (1))){
var state_35430__$1 = state_35430;
var statearr_35451_35621 = state_35430__$1;
(statearr_35451_35621[(2)] = null);

(statearr_35451_35621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (69))){
var inst_35378 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35452_35622 = state_35430__$1;
(statearr_35452_35622[(2)] = inst_35378);

(statearr_35452_35622[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (101))){
var inst_35407 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35407)){
var statearr_35453_35623 = state_35430__$1;
(statearr_35453_35623[(1)] = (105));

} else {
var statearr_35454_35624 = state_35430__$1;
(statearr_35454_35624[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (24))){
var inst_35181 = (state_35430[(12)]);
var state_35430__$1 = state_35430;
var statearr_35455_35625 = state_35430__$1;
(statearr_35455_35625[(2)] = inst_35181);

(statearr_35455_35625[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (102))){
var inst_35161 = (state_35430[(9)]);
var inst_35394 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35395 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35394);
var inst_35396 = inst_35395 === true;
var inst_35397 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35398 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35397);
var inst_35399 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_35398);
var inst_35400 = (!(inst_35399));
var inst_35401 = ((inst_35396) && (inst_35400));
var state_35430__$1 = state_35430;
var statearr_35456_35626 = state_35430__$1;
(statearr_35456_35626[(2)] = inst_35401);

(statearr_35456_35626[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (55))){
var state_35430__$1 = state_35430;
var statearr_35457_35627 = state_35430__$1;
(statearr_35457_35627[(2)] = false);

(statearr_35457_35627[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (85))){
var inst_35343 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35458_35628 = state_35430__$1;
(statearr_35458_35628[(2)] = inst_35343);

(statearr_35458_35628[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (39))){
var state_35430__$1 = state_35430;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35459_35629 = state_35430__$1;
(statearr_35459_35629[(1)] = (42));

} else {
var statearr_35460_35630 = state_35430__$1;
(statearr_35460_35630[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (88))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35351 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35461_35631 = state_35430__$1;
(statearr_35461_35631[(2)] = inst_35351);

(statearr_35461_35631[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (46))){
var inst_35261 = (state_35430[(13)]);
var state_35430__$1 = state_35430;
var statearr_35462_35632 = state_35430__$1;
(statearr_35462_35632[(2)] = inst_35261);

(statearr_35462_35632[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (4))){
var inst_35122 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35463_35633 = state_35430__$1;
(statearr_35463_35633[(2)] = inst_35122);

(statearr_35463_35633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (77))){
var inst_35323 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35464_35634 = state_35430__$1;
(statearr_35464_35634[(2)] = inst_35323);

(statearr_35464_35634[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (106))){
var inst_35388 = (state_35430[(14)]);
var state_35430__$1 = state_35430;
var statearr_35465_35635 = state_35430__$1;
(statearr_35465_35635[(2)] = inst_35388);

(statearr_35465_35635[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (95))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35466_35636 = state_35430__$1;
(statearr_35466_35636[(2)] = inst_35260);

(statearr_35466_35636[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (54))){
var state_35430__$1 = state_35430;
var statearr_35467_35637 = state_35430__$1;
(statearr_35467_35637[(2)] = true);

(statearr_35467_35637[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (92))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35361 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35468_35638 = state_35430__$1;
(statearr_35468_35638[(2)] = inst_35361);

(statearr_35468_35638[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (104))){
var inst_35404 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35469_35639 = state_35430__$1;
(statearr_35469_35639[(2)] = inst_35404);

(statearr_35469_35639[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (15))){
var inst_35149 = (state_35430[(15)]);
var state_35430__$1 = state_35430;
var statearr_35470_35640 = state_35430__$1;
(statearr_35470_35640[(2)] = inst_35149);

(statearr_35470_35640[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (48))){
var inst_35270 = (state_35430[(10)]);
var inst_35161 = (state_35430[(9)]);
var inst_35270__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35272 = (inst_35270__$1 == null);
var inst_35273 = cljs.core.not(inst_35272);
var state_35430__$1 = (function (){var statearr_35471 = state_35430;
(statearr_35471[(10)] = inst_35270__$1);

return statearr_35471;
})();
if(inst_35273){
var statearr_35472_35641 = state_35430__$1;
(statearr_35472_35641[(1)] = (51));

} else {
var statearr_35473_35642 = state_35430__$1;
(statearr_35473_35642[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (50))){
var inst_35161 = (state_35430[(9)]);
var inst_35388 = (state_35430[(2)]);
var inst_35389 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35390 = inst_35389 === true;
var state_35430__$1 = (function (){var statearr_35474 = state_35430;
(statearr_35474[(14)] = inst_35388);

return statearr_35474;
})();
if(cljs.core.truth_(inst_35390)){
var statearr_35475_35643 = state_35430__$1;
(statearr_35475_35643[(1)] = (99));

} else {
var statearr_35476_35644 = state_35430__$1;
(statearr_35476_35644[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (75))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35477_35645 = state_35430__$1;
(statearr_35477_35645[(2)] = inst_35260);

(statearr_35477_35645[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (99))){
var inst_35161 = (state_35430[(9)]);
var inst_35392 = (state_35430[(16)]);
var inst_35392__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35478 = state_35430;
(statearr_35478[(16)] = inst_35392__$1);

return statearr_35478;
})();
if(cljs.core.truth_(inst_35392__$1)){
var statearr_35479_35646 = state_35430__$1;
(statearr_35479_35646[(1)] = (102));

} else {
var statearr_35480_35647 = state_35430__$1;
(statearr_35480_35647[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (21))){
var inst_35184 = (state_35430[(17)]);
var state_35430__$1 = state_35430;
var statearr_35481_35648 = state_35430__$1;
(statearr_35481_35648[(2)] = inst_35184);

(statearr_35481_35648[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (31))){
var inst_35224 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35224)){
var statearr_35482_35649 = state_35430__$1;
(statearr_35482_35649[(1)] = (32));

} else {
var statearr_35483_35650 = state_35430__$1;
(statearr_35483_35650[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (32))){
var inst_35213 = (state_35430[(18)]);
var inst_35226 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_35213,"a component","a non-component",throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35484_35651 = state_35430__$1;
(statearr_35484_35651[(2)] = inst_35226);

(statearr_35484_35651[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (40))){
var inst_35229 = (state_35430[(19)]);
var state_35430__$1 = state_35430;
var statearr_35485_35652 = state_35430__$1;
(statearr_35485_35652[(2)] = inst_35229);

(statearr_35485_35652[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (91))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35486_35653 = state_35430__$1;
(statearr_35486_35653[(2)] = inst_35260);

(statearr_35486_35653[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (108))){
var inst_35410 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35411 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_35412 = cljs.core.PersistentHashMap.fromArrays(inst_35410,inst_35411);
var inst_35413 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_35412);
var inst_35414 = (function(){throw inst_35413})();
var state_35430__$1 = state_35430;
var statearr_35487_35654 = state_35430__$1;
(statearr_35487_35654[(2)] = inst_35414);

(statearr_35487_35654[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (56))){
var inst_35283 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35488_35655 = state_35430__$1;
(statearr_35488_35655[(2)] = inst_35283);

(statearr_35488_35655[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (33))){
var inst_35213 = (state_35430[(18)]);
var state_35430__$1 = state_35430;
var statearr_35489_35656 = state_35430__$1;
(statearr_35489_35656[(2)] = inst_35213);

(statearr_35489_35656[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (13))){
var inst_35176 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35176)){
var statearr_35490_35657 = state_35430__$1;
(statearr_35490_35657[(1)] = (14));

} else {
var statearr_35491_35658 = state_35430__$1;
(statearr_35491_35658[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (22))){
var inst_35197 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35492_35659 = state_35430__$1;
(statearr_35492_35659[(2)] = inst_35197);

(statearr_35492_35659[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (90))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35355 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_35356 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_35355,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,5,inst_35355,null));
var inst_35357 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35356,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35356,null));
var inst_35358 = (inst_35357.cljs$core$IFn$_invoke$arity$1 ? inst_35357.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35357.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35358)){
var statearr_35493_35660 = state_35430__$1;
(statearr_35493_35660[(1)] = (91));

} else {
var statearr_35494_35661 = state_35430__$1;
(statearr_35494_35661[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (109))){
var inst_35388 = (state_35430[(14)]);
var state_35430__$1 = state_35430;
var statearr_35495_35662 = state_35430__$1;
(statearr_35495_35662[(2)] = inst_35388);

(statearr_35495_35662[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (36))){
var inst_35230 = (state_35430[(20)]);
var state_35430__$1 = state_35430;
var statearr_35496_35663 = state_35430__$1;
(statearr_35496_35663[(2)] = inst_35230);

(statearr_35496_35663[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (41))){
var inst_35261 = (state_35430[(13)]);
var inst_35161 = (state_35430[(9)]);
var inst_35260 = (state_35430[(2)]);
var inst_35261__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35497 = state_35430;
(statearr_35497[(13)] = inst_35261__$1);

(statearr_35497[(11)] = inst_35260);

return statearr_35497;
})();
if(cljs.core.truth_(inst_35261__$1)){
var statearr_35498_35664 = state_35430__$1;
(statearr_35498_35664[(1)] = (45));

} else {
var statearr_35499_35665 = state_35430__$1;
(statearr_35499_35665[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (89))){
var inst_35353 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35500_35666 = state_35430__$1;
(statearr_35500_35666[(2)] = inst_35353);

(statearr_35500_35666[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (100))){
var state_35430__$1 = state_35430;
var statearr_35501_35667 = state_35430__$1;
(statearr_35501_35667[(2)] = false);

(statearr_35501_35667[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (43))){
var inst_35229 = (state_35430[(19)]);
var state_35430__$1 = state_35430;
var statearr_35502_35668 = state_35430__$1;
(statearr_35502_35668[(2)] = inst_35229);

(statearr_35502_35668[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (61))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35297 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_35298 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_35297,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,3,inst_35297,null));
var inst_35299 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35298,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35298,null));
var inst_35300 = (inst_35299.cljs$core$IFn$_invoke$arity$1 ? inst_35299.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35299.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35300)){
var statearr_35503_35669 = state_35430__$1;
(statearr_35503_35669[(1)] = (63));

} else {
var statearr_35504_35670 = state_35430__$1;
(statearr_35504_35670[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (29))){
var inst_35161 = (state_35430[(9)]);
var inst_35216 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35217 = cljs.core.not(inst_35216);
var inst_35218 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35219 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35218);
var inst_35220 = inst_35219 === true;
var inst_35221 = ((inst_35217) && (inst_35220));
var state_35430__$1 = state_35430;
var statearr_35505_35671 = state_35430__$1;
(statearr_35505_35671[(2)] = inst_35221);

(statearr_35505_35671[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (44))){
var inst_35257 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35506_35672 = state_35430__$1;
(statearr_35506_35672[(2)] = inst_35257);

(statearr_35506_35672[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (93))){
var inst_35363 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35507_35673 = state_35430__$1;
(statearr_35507_35673[(2)] = inst_35363);

(statearr_35507_35673[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (6))){
var inst_35148 = (state_35430[(21)]);
var inst_35160 = (state_35430[(22)]);
var inst_35157 = cljs.core.seq(inst_35148);
var inst_35158 = cljs.core.first(inst_35157);
var inst_35159 = cljs.core.next(inst_35157);
var inst_35160__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35158,(0),null);
var inst_35161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35158,(1),null);
var inst_35162 = cljs.core.not(inst_35160__$1);
var state_35430__$1 = (function (){var statearr_35508 = state_35430;
(statearr_35508[(23)] = inst_35159);

(statearr_35508[(9)] = inst_35161);

(statearr_35508[(22)] = inst_35160__$1);

return statearr_35508;
})();
if(inst_35162){
var statearr_35509_35674 = state_35430__$1;
(statearr_35509_35674[(1)] = (8));

} else {
var statearr_35510_35675 = state_35430__$1;
(statearr_35510_35675[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (28))){
var inst_35210 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35511_35676 = state_35430__$1;
(statearr_35511_35676[(2)] = inst_35210);

(statearr_35511_35676[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (64))){
var state_35430__$1 = state_35430;
var statearr_35512_35677 = state_35430__$1;
(statearr_35512_35677[(1)] = (66));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (103))){
var inst_35392 = (state_35430[(16)]);
var state_35430__$1 = state_35430;
var statearr_35514_35678 = state_35430__$1;
(statearr_35514_35678[(2)] = inst_35392);

(statearr_35514_35678[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (51))){
var inst_35270 = (state_35430[(10)]);
var inst_35275 = inst_35270.cljs$lang$protocol_mask$partition0$;
var inst_35276 = (inst_35275 & (64));
var inst_35277 = inst_35270.cljs$core$ISeq$;
var inst_35278 = (cljs.core.PROTOCOL_SENTINEL === inst_35277);
var inst_35279 = ((inst_35276) || (inst_35278));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35279)){
var statearr_35515_35679 = state_35430__$1;
(statearr_35515_35679[(1)] = (54));

} else {
var statearr_35516_35680 = state_35430__$1;
(statearr_35516_35680[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (25))){
var inst_35161 = (state_35430[(9)]);
var inst_35214 = (state_35430[(24)]);
var inst_35213 = (state_35430[(2)]);
var inst_35214__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35517 = state_35430;
(statearr_35517[(18)] = inst_35213);

(statearr_35517[(24)] = inst_35214__$1);

return statearr_35517;
})();
if(cljs.core.truth_(inst_35214__$1)){
var statearr_35518_35681 = state_35430__$1;
(statearr_35518_35681[(1)] = (29));

} else {
var statearr_35519_35682 = state_35430__$1;
(statearr_35519_35682[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (34))){
var inst_35161 = (state_35430[(9)]);
var inst_35230 = (state_35430[(20)]);
var inst_35229 = (state_35430[(2)]);
var inst_35230__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35520 = state_35430;
(statearr_35520[(20)] = inst_35230__$1);

(statearr_35520[(19)] = inst_35229);

return statearr_35520;
})();
if(cljs.core.truth_(inst_35230__$1)){
var statearr_35521_35683 = state_35430__$1;
(statearr_35521_35683[(1)] = (35));

} else {
var statearr_35522_35684 = state_35430__$1;
(statearr_35522_35684[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (17))){
var inst_35161 = (state_35430[(9)]);
var inst_35184 = (state_35430[(17)]);
var inst_35184__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35523 = state_35430;
(statearr_35523[(17)] = inst_35184__$1);

return statearr_35523;
})();
if(cljs.core.truth_(inst_35184__$1)){
var statearr_35524_35685 = state_35430__$1;
(statearr_35524_35685[(1)] = (20));

} else {
var statearr_35525_35686 = state_35430__$1;
(statearr_35525_35686[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (3))){
var inst_35428 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35430__$1,inst_35428);
} else {
if((state_val_35431 === (12))){
var inst_35165 = (state_35430[(25)]);
var state_35430__$1 = state_35430;
var statearr_35526_35687 = state_35430__$1;
(statearr_35526_35687[(2)] = inst_35165);

(statearr_35526_35687[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (2))){
var _ = (function (){var statearr_35527 = state_35430;
(statearr_35527[(4)] = cljs.core.cons((5),(state_35430[(4)])));

return statearr_35527;
})();
var inst_35141 = pred_changes;
var inst_35142 = cljs.core.seq(inst_35141);
var inst_35143 = cljs.core.first(inst_35142);
var inst_35144 = cljs.core.next(inst_35142);
var inst_35145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35143,(0),null);
var inst_35146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35143,(1),null);
var inst_35147 = db;
var inst_35148 = inst_35141;
var inst_35149 = inst_35147;
var state_35430__$1 = (function (){var statearr_35528 = state_35430;
(statearr_35528[(15)] = inst_35149);

(statearr_35528[(26)] = inst_35144);

(statearr_35528[(27)] = inst_35145);

(statearr_35528[(21)] = inst_35148);

(statearr_35528[(28)] = inst_35146);

return statearr_35528;
})();
var statearr_35529_35688 = state_35430__$1;
(statearr_35529_35688[(2)] = null);

(statearr_35529_35688[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (66))){
var inst_35293 = (state_35430[(7)]);
var state_35430__$1 = state_35430;
var G__35530_35689 = inst_35293;
var G__35530_35690__$1 = (((G__35530_35689 instanceof cljs.core.Keyword))?G__35530_35689.fqn:null);
switch (G__35530_35690__$1) {
case "long":
var statearr_35531_35692 = state_35430__$1;
(statearr_35531_35692[(1)] = (70));


break;
case "bigint":
var statearr_35532_35693 = state_35430__$1;
(statearr_35532_35693[(1)] = (74));


break;
case "double":
var statearr_35533_35694 = state_35430__$1;
(statearr_35533_35694[(1)] = (78));


break;
case "float":
var statearr_35534_35695 = state_35430__$1;
(statearr_35534_35695[(1)] = (82));


break;
case "bigdec":
var statearr_35535_35696 = state_35430__$1;
(statearr_35535_35696[(1)] = (86));


break;
case "string":
var statearr_35536_35697 = state_35430__$1;
(statearr_35536_35697[(1)] = (90));


break;
case "instant":
var statearr_35537_35698 = state_35430__$1;
(statearr_35537_35698[(1)] = (94));


break;
default:
var statearr_35538_35699 = state_35430__$1;
(statearr_35538_35699[(1)] = (98));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (107))){
var inst_35159 = (state_35430[(23)]);
var inst_35420 = (state_35430[(2)]);
var inst_35148 = inst_35159;
var inst_35149 = inst_35420;
var state_35430__$1 = (function (){var statearr_35539 = state_35430;
(statearr_35539[(15)] = inst_35149);

(statearr_35539[(21)] = inst_35148);

return statearr_35539;
})();
var statearr_35540_35700 = state_35430__$1;
(statearr_35540_35700[(2)] = null);

(statearr_35540_35700[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (23))){
var state_35430__$1 = state_35430;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35541_35701 = state_35430__$1;
(statearr_35541_35701[(1)] = (26));

} else {
var statearr_35542_35702 = state_35430__$1;
(statearr_35542_35702[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (47))){
var inst_35267 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35267)){
var statearr_35543_35703 = state_35430__$1;
(statearr_35543_35703[(1)] = (48));

} else {
var statearr_35544_35704 = state_35430__$1;
(statearr_35544_35704[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (35))){
var inst_35149 = (state_35430[(15)]);
var inst_35161 = (state_35430[(9)]);
var inst_35160 = (state_35430[(22)]);
var inst_35232 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35233 = cljs.core.not(inst_35232);
var inst_35234 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35235 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35234);
var inst_35236 = inst_35235 === true;
var inst_35237 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_35149,inst_35160);
var state_35430__$1 = (function (){var statearr_35545 = state_35430;
(statearr_35545[(29)] = inst_35233);

(statearr_35545[(30)] = inst_35236);

return statearr_35545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35430__$1,(38),inst_35237);
} else {
if((state_val_35431 === (82))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35335 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_35336 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_35335,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,3,inst_35335,null));
var inst_35337 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35336,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35336,null));
var inst_35338 = (inst_35337.cljs$core$IFn$_invoke$arity$1 ? inst_35337.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35337.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35338)){
var statearr_35546_35705 = state_35430__$1;
(statearr_35546_35705[(1)] = (83));

} else {
var statearr_35547_35706 = state_35430__$1;
(statearr_35547_35706[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (76))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35321 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35548_35707 = state_35430__$1;
(statearr_35548_35707[(2)] = inst_35321);

(statearr_35548_35707[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (97))){
var inst_35373 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35549_35708 = state_35430__$1;
(statearr_35549_35708[(2)] = inst_35373);

(statearr_35549_35708[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (19))){
var inst_35200 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35200)){
var statearr_35550_35709 = state_35430__$1;
(statearr_35550_35709[(1)] = (23));

} else {
var statearr_35551_35710 = state_35430__$1;
(statearr_35551_35710[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (57))){
var inst_35270 = (state_35430[(10)]);
var inst_35288 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35270);
var state_35430__$1 = state_35430;
var statearr_35552_35711 = state_35430__$1;
(statearr_35552_35711[(2)] = inst_35288);

(statearr_35552_35711[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (68))){
var inst_35381 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35553_35712 = state_35430__$1;
(statearr_35553_35712[(2)] = inst_35381);

(statearr_35553_35712[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (11))){
var inst_35161 = (state_35430[(9)]);
var inst_35167 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35168 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_35167);
var inst_35169 = inst_35168 === false;
var inst_35170 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35171 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_35170);
var inst_35172 = inst_35171 === true;
var inst_35173 = ((inst_35169) && (inst_35172));
var state_35430__$1 = state_35430;
var statearr_35555_35713 = state_35430__$1;
(statearr_35555_35713[(2)] = inst_35173);

(statearr_35555_35713[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (9))){
var inst_35161 = (state_35430[(9)]);
var inst_35165 = (state_35430[(25)]);
var inst_35165__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35556 = state_35430;
(statearr_35556[(25)] = inst_35165__$1);

return statearr_35556;
})();
if(cljs.core.truth_(inst_35165__$1)){
var statearr_35557_35714 = state_35430__$1;
(statearr_35557_35714[(1)] = (11));

} else {
var statearr_35558_35715 = state_35430__$1;
(statearr_35558_35715[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (5))){
var _ = (function (){var statearr_35559 = state_35430;
(statearr_35559[(4)] = cljs.core.rest((state_35430[(4)])));

return statearr_35559;
})();
var state_35430__$1 = state_35430;
var ex35554 = (state_35430__$1[(2)]);
var statearr_35560_35716 = state_35430__$1;
(statearr_35560_35716[(5)] = ex35554);


if((ex35554 instanceof Error)){
var statearr_35561_35717 = state_35430__$1;
(statearr_35561_35717[(1)] = (4));

(statearr_35561_35717[(5)] = null);

} else {
throw ex35554;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (83))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35562_35718 = state_35430__$1;
(statearr_35562_35718[(2)] = inst_35260);

(statearr_35562_35718[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (14))){
var inst_35149 = (state_35430[(15)]);
var inst_35178 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_35149,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35563_35719 = state_35430__$1;
(statearr_35563_35719[(2)] = inst_35178);

(statearr_35563_35719[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (45))){
var inst_35161 = (state_35430[(9)]);
var inst_35263 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35161);
var inst_35264 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_35263);
var state_35430__$1 = state_35430;
var statearr_35564_35720 = state_35430__$1;
(statearr_35564_35720[(2)] = inst_35264);

(statearr_35564_35720[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (53))){
var inst_35286 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35286)){
var statearr_35565_35721 = state_35430__$1;
(statearr_35565_35721[(1)] = (57));

} else {
var statearr_35566_35722 = state_35430__$1;
(statearr_35566_35722[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (78))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35325 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_35326 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_35325,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,3,inst_35325,null));
var inst_35327 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35326,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35326,null));
var inst_35328 = (inst_35327.cljs$core$IFn$_invoke$arity$1 ? inst_35327.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35327.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35328)){
var statearr_35567_35723 = state_35430__$1;
(statearr_35567_35723[(1)] = (79));

} else {
var statearr_35568_35724 = state_35430__$1;
(statearr_35568_35724[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (26))){
var inst_35203 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35204 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_35205 = cljs.core.PersistentHashMap.fromArrays(inst_35203,inst_35204);
var inst_35206 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_35205);
var inst_35207 = (function(){throw inst_35206})();
var state_35430__$1 = state_35430;
var statearr_35569_35725 = state_35430__$1;
(statearr_35569_35725[(2)] = inst_35207);

(statearr_35569_35725[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (16))){
var inst_35161 = (state_35430[(9)]);
var inst_35182 = (state_35430[(31)]);
var inst_35181 = (state_35430[(2)]);
var inst_35182__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_35161);
var state_35430__$1 = (function (){var statearr_35570 = state_35430;
(statearr_35570[(12)] = inst_35181);

(statearr_35570[(31)] = inst_35182__$1);

return statearr_35570;
})();
if(cljs.core.truth_(inst_35182__$1)){
var statearr_35571_35726 = state_35430__$1;
(statearr_35571_35726[(1)] = (17));

} else {
var statearr_35572_35727 = state_35430__$1;
(statearr_35572_35727[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (81))){
var inst_35333 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35573_35728 = state_35430__$1;
(statearr_35573_35728[(2)] = inst_35333);

(statearr_35573_35728[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (79))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35574_35729 = state_35430__$1;
(statearr_35574_35729[(2)] = inst_35260);

(statearr_35574_35729[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (38))){
var inst_35233 = (state_35430[(29)]);
var inst_35236 = (state_35430[(30)]);
var inst_35239 = (state_35430[(2)]);
var inst_35240 = fluree.db.util.async.throw_err(inst_35239);
var inst_35241 = cljs.core.not(inst_35240);
var inst_35242 = ((inst_35233) && (inst_35236) && (inst_35241));
var state_35430__$1 = state_35430;
var statearr_35575_35730 = state_35430__$1;
(statearr_35575_35730[(2)] = inst_35242);

(statearr_35575_35730[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (98))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35375 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35576_35731 = state_35430__$1;
(statearr_35576_35731[(2)] = inst_35375);

(statearr_35576_35731[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (87))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35577_35732 = state_35430__$1;
(statearr_35577_35732[(2)] = inst_35260);

(statearr_35577_35732[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (30))){
var inst_35214 = (state_35430[(24)]);
var state_35430__$1 = state_35430;
var statearr_35578_35733 = state_35430__$1;
(statearr_35578_35733[(2)] = inst_35214);

(statearr_35578_35733[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (73))){
var inst_35313 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35579_35734 = state_35430__$1;
(statearr_35579_35734[(2)] = inst_35313);

(statearr_35579_35734[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (96))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35371 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35580_35735 = state_35430__$1;
(statearr_35580_35735[(2)] = inst_35371);

(statearr_35580_35735[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (10))){
var inst_35423 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
var statearr_35581_35736 = state_35430__$1;
(statearr_35581_35736[(2)] = inst_35423);

(statearr_35581_35736[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (18))){
var inst_35182 = (state_35430[(31)]);
var state_35430__$1 = state_35430;
var statearr_35582_35737 = state_35430__$1;
(statearr_35582_35737[(2)] = inst_35182);

(statearr_35582_35737[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (105))){
var state_35430__$1 = state_35430;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_35583_35738 = state_35430__$1;
(statearr_35583_35738[(1)] = (108));

} else {
var statearr_35584_35739 = state_35430__$1;
(statearr_35584_35739[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (52))){
var state_35430__$1 = state_35430;
var statearr_35585_35740 = state_35430__$1;
(statearr_35585_35740[(2)] = false);

(statearr_35585_35740[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (67))){
var state_35430__$1 = state_35430;
var statearr_35586_35741 = state_35430__$1;
(statearr_35586_35741[(2)] = null);

(statearr_35586_35741[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (71))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35587_35742 = state_35430__$1;
(statearr_35587_35742[(2)] = inst_35260);

(statearr_35587_35742[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (42))){
var inst_35149 = (state_35430[(15)]);
var inst_35160 = (state_35430[(22)]);
var inst_35248 = fluree.db.dbproto._p_prop(inst_35149,cljs.core.cst$kw$name,inst_35160);
var inst_35249 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35248)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_35250 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35251 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_35252 = cljs.core.PersistentHashMap.fromArrays(inst_35250,inst_35251);
var inst_35253 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35249,inst_35252);
var inst_35254 = (function(){throw inst_35253})();
var state_35430__$1 = state_35430;
var statearr_35588_35743 = state_35430__$1;
(statearr_35588_35743[(2)] = inst_35254);

(statearr_35588_35743[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (80))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35331 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35589_35744 = state_35430__$1;
(statearr_35589_35744[(2)] = inst_35331);

(statearr_35589_35744[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (37))){
var inst_35245 = (state_35430[(2)]);
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35245)){
var statearr_35590_35745 = state_35430__$1;
(statearr_35590_35745[(1)] = (39));

} else {
var statearr_35591_35746 = state_35430__$1;
(statearr_35591_35746[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (63))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35302 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35592_35747 = state_35430__$1;
(statearr_35592_35747[(2)] = inst_35302);

(statearr_35592_35747[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (94))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35365 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_35366 = (inst_35293.cljs$core$IFn$_invoke$arity$5 ? inst_35293.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_35365,null) : inst_35293.call(null,cljs.core.PersistentArrayMap,null,2,inst_35365,null));
var inst_35367 = (inst_35293.cljs$core$IFn$_invoke$arity$4 ? inst_35293.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_35366,null) : inst_35293.call(null,cljs.core.PersistentHashSet,null,inst_35366,null));
var inst_35368 = (inst_35367.cljs$core$IFn$_invoke$arity$1 ? inst_35367.cljs$core$IFn$_invoke$arity$1(inst_35292) : inst_35367.call(null,inst_35292));
var state_35430__$1 = state_35430;
if(cljs.core.truth_(inst_35368)){
var statearr_35593_35748 = state_35430__$1;
(statearr_35593_35748[(1)] = (95));

} else {
var statearr_35594_35749 = state_35430__$1;
(statearr_35594_35749[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (8))){
var inst_35149 = (state_35430[(15)]);
var state_35430__$1 = state_35430;
var statearr_35595_35750 = state_35430__$1;
(statearr_35595_35750[(2)] = inst_35149);

(statearr_35595_35750[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (49))){
var inst_35260 = (state_35430[(11)]);
var state_35430__$1 = state_35430;
var statearr_35596_35751 = state_35430__$1;
(statearr_35596_35751[(2)] = inst_35260);

(statearr_35596_35751[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35431 === (84))){
var inst_35293 = (state_35430[(7)]);
var inst_35292 = (state_35430[(8)]);
var inst_35341 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_35292,inst_35293,throw_QMARK_);
var state_35430__$1 = state_35430;
var statearr_35597_35752 = state_35430__$1;
(statearr_35597_35752[(2)] = inst_35341);

(statearr_35597_35752[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16301__auto__ = null;
var fluree$db$query$schema$state_machine__16301__auto____0 = (function (){
var statearr_35598 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35598[(0)] = fluree$db$query$schema$state_machine__16301__auto__);

(statearr_35598[(1)] = (1));

return statearr_35598;
});
var fluree$db$query$schema$state_machine__16301__auto____1 = (function (state_35430){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35430);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35599){var ex__16304__auto__ = e35599;
var statearr_35600_35753 = state_35430;
(statearr_35600_35753[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35430[(4)]))){
var statearr_35601_35754 = state_35430;
(statearr_35601_35754[(1)] = cljs.core.first((state_35430[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35755 = state_35430;
state_35430 = G__35755;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16301__auto__ = function(state_35430){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16301__auto____1.call(this,state_35430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16301__auto____0;
fluree$db$query$schema$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16301__auto____1;
return fluree$db$query$schema$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35602 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35602[(6)] = c__16375__auto__);

return statearr_35602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35779){
var state_val_35780 = (state_35779[(1)]);
if((state_val_35780 === (7))){
var state_35779__$1 = state_35779;
var statearr_35781_35800 = state_35779__$1;
(statearr_35781_35800[(2)] = db);

(statearr_35781_35800[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (1))){
var state_35779__$1 = state_35779;
var statearr_35782_35801 = state_35779__$1;
(statearr_35782_35801[(2)] = null);

(statearr_35782_35801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (4))){
var inst_35756 = (state_35779[(2)]);
var state_35779__$1 = state_35779;
var statearr_35783_35802 = state_35779__$1;
(statearr_35783_35802[(2)] = inst_35756);

(statearr_35783_35802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (6))){
var inst_35765 = (state_35779[(7)]);
var inst_35764 = (state_35779[(2)]);
var inst_35765__$1 = fluree.db.util.async.throw_err(inst_35764);
var inst_35766 = cljs.core.empty_QMARK_(inst_35765__$1);
var state_35779__$1 = (function (){var statearr_35784 = state_35779;
(statearr_35784[(7)] = inst_35765__$1);

return statearr_35784;
})();
if(inst_35766){
var statearr_35785_35803 = state_35779__$1;
(statearr_35785_35803[(1)] = (7));

} else {
var statearr_35786_35804 = state_35779__$1;
(statearr_35786_35804[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (3))){
var inst_35777 = (state_35779[(2)]);
var state_35779__$1 = state_35779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35779__$1,inst_35777);
} else {
if((state_val_35780 === (2))){
var _ = (function (){var statearr_35788 = state_35779;
(statearr_35788[(4)] = cljs.core.cons((5),(state_35779[(4)])));

return statearr_35788;
})();
var inst_35762 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes);
var state_35779__$1 = state_35779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35779__$1,(6),inst_35762);
} else {
if((state_val_35780 === (9))){
var inst_35774 = (state_35779[(2)]);
var _ = (function (){var statearr_35789 = state_35779;
(statearr_35789[(4)] = cljs.core.rest((state_35779[(4)])));

return statearr_35789;
})();
var state_35779__$1 = state_35779;
var statearr_35790_35805 = state_35779__$1;
(statearr_35790_35805[(2)] = inst_35774);

(statearr_35790_35805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (5))){
var _ = (function (){var statearr_35791 = state_35779;
(statearr_35791[(4)] = cljs.core.rest((state_35779[(4)])));

return statearr_35791;
})();
var state_35779__$1 = state_35779;
var ex35787 = (state_35779__$1[(2)]);
var statearr_35792_35806 = state_35779__$1;
(statearr_35792_35806[(5)] = ex35787);


if((ex35787 instanceof Error)){
var statearr_35793_35807 = state_35779__$1;
(statearr_35793_35807[(1)] = (4));

(statearr_35793_35807[(5)] = null);

} else {
throw ex35787;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (10))){
var inst_35771 = (state_35779[(2)]);
var inst_35772 = fluree.db.util.async.throw_err(inst_35771);
var state_35779__$1 = state_35779;
var statearr_35794_35808 = state_35779__$1;
(statearr_35794_35808[(2)] = inst_35772);

(statearr_35794_35808[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35780 === (8))){
var inst_35765 = (state_35779[(7)]);
var inst_35769 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_35765,db,true);
var state_35779__$1 = state_35779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35779__$1,(10),inst_35769);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0 = (function (){
var statearr_35795 = [null,null,null,null,null,null,null,null];
(statearr_35795[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__);

(statearr_35795[(1)] = (1));

return statearr_35795;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1 = (function (state_35779){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35779);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35796){var ex__16304__auto__ = e35796;
var statearr_35797_35809 = state_35779;
(statearr_35797_35809[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35779[(4)]))){
var statearr_35798_35810 = state_35779;
(statearr_35798_35810[(1)] = cljs.core.first((state_35779[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35811 = state_35779;
state_35779 = G__35811;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__ = function(state_35779){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1.call(this,state_35779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35799 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35799[(6)] = c__16375__auto__);

return statearr_35799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__35813 = arguments.length;
switch (G__35813) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__35815 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35815,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35815,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35815,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__35818_SHARP_,p2__35819_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35818_SHARP_,p2__35819_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35885){
var state_val_35886 = (state_35885[(1)]);
if((state_val_35886 === (1))){
var state_35885__$1 = state_35885;
var statearr_35887_35905 = state_35885__$1;
(statearr_35887_35905[(2)] = null);

(statearr_35887_35905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (2))){
var _ = (function (){var statearr_35888 = state_35885;
(statearr_35888[(4)] = cljs.core.cons((5),(state_35885[(4)])));

return statearr_35888;
})();
var inst_35837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35838 = fluree.db.flake.max_subject_id((1));
var inst_35839 = [inst_35838];
var inst_35840 = (new cljs.core.PersistentVector(null,1,(5),inst_35837,inst_35839,null));
var inst_35841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35842 = [(0)];
var inst_35843 = (new cljs.core.PersistentVector(null,1,(5),inst_35841,inst_35842,null));
var inst_35844 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_35840,cljs.core._LT__EQ_,inst_35843);
var state_35885__$1 = state_35885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35885__$1,(6),inst_35844);
} else {
if((state_val_35886 === (3))){
var inst_35883 = (state_35885[(2)]);
var state_35885__$1 = state_35885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35885__$1,inst_35883);
} else {
if((state_val_35886 === (4))){
var inst_35825 = (state_35885[(2)]);
var state_35885__$1 = state_35885;
var statearr_35890_35906 = state_35885__$1;
(statearr_35890_35906[(2)] = inst_35825);

(statearr_35890_35906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (5))){
var _ = (function (){var statearr_35891 = state_35885;
(statearr_35891[(4)] = cljs.core.rest((state_35885[(4)])));

return statearr_35891;
})();
var state_35885__$1 = state_35885;
var ex35889 = (state_35885__$1[(2)]);
var statearr_35892_35907 = state_35885__$1;
(statearr_35892_35907[(5)] = ex35889);


if((ex35889 instanceof Error)){
var statearr_35893_35908 = state_35885__$1;
(statearr_35893_35908[(1)] = (4));

(statearr_35893_35908[(5)] = null);

} else {
throw ex35889;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35886 === (6))){
var inst_35846 = (state_35885[(2)]);
var inst_35847 = fluree.db.util.async.throw_err(inst_35846);
var inst_35848 = (function (){var schema_flakes = inst_35847;
return (function (p1__35820_SHARP_){
return (p1__35820_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_35849 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35848,inst_35847);
var inst_35850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35849,(0),null);
var inst_35851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35849,(1),null);
var inst_35852 = (function (){var schema_flakes = inst_35847;
var vec__35831 = inst_35849;
var collection_flakes = inst_35850;
var predicate_flakes = inst_35851;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var id = fluree.db.flake.sid__GT_i(sid);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35822_SHARP_,p2__35823_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__35822_SHARP_,p2__35823_SHARP_.p,p2__35823_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43));
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,id], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,id,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_35853 = [(-1),"_tx"];
var inst_35854 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_35855 = ["_tx",(-1),(-1)];
var inst_35856 = cljs.core.PersistentHashMap.fromArrays(inst_35854,inst_35855);
var inst_35857 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_35858 = ["_tx",(-1),(-1)];
var inst_35859 = cljs.core.PersistentHashMap.fromArrays(inst_35857,inst_35858);
var inst_35860 = [inst_35856,inst_35859];
var inst_35861 = cljs.core.PersistentHashMap.fromArrays(inst_35853,inst_35860);
var inst_35862 = (function (){var schema_flakes = inst_35847;
var vec__35831 = inst_35849;
var collection_flakes = inst_35850;
var predicate_flakes = inst_35851;
return (function (p1__35821_SHARP_){
return p1__35821_SHARP_.s;
});
})();
var inst_35863 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35862,inst_35850);
var inst_35864 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35852,inst_35861,inst_35863);
var inst_35866 = (function (){var schema_flakes = inst_35847;
var vec__35831 = inst_35849;
var collection_flakes = inst_35850;
var predicate_flakes = inst_35851;
var coll = inst_35864;
return (function (p__35865,pred_flakes){
var vec__35894 = p__35865;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35894,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35894,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__35897 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__35897.cljs$core$IFn$_invoke$arity$1 ? fexpr__35897.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__35897.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_35867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35868 = cljs.core.PersistentHashMap.EMPTY;
var inst_35869 = cljs.core.PersistentHashSet.EMPTY;
var inst_35870 = [inst_35868,inst_35869];
var inst_35871 = (new cljs.core.PersistentVector(null,2,(5),inst_35867,inst_35870,null));
var inst_35872 = (function (){var schema_flakes = inst_35847;
var vec__35831 = inst_35849;
var collection_flakes = inst_35850;
var predicate_flakes = inst_35851;
var coll = inst_35864;
return (function (p1__35824_SHARP_){
return p1__35824_SHARP_.s;
});
})();
var inst_35873 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_35872,inst_35851);
var inst_35874 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35866,inst_35871,inst_35873);
var inst_35875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35874,(0),null);
var inst_35876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35874,(1),null);
var inst_35877 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_35878 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_35879 = [inst_35878,inst_35864,inst_35875,inst_35876];
var inst_35880 = cljs.core.PersistentHashMap.fromArrays(inst_35877,inst_35879);
var _ = (function (){var statearr_35898 = state_35885;
(statearr_35898[(4)] = cljs.core.rest((state_35885[(4)])));

return statearr_35898;
})();
var state_35885__$1 = state_35885;
var statearr_35899_35909 = state_35885__$1;
(statearr_35899_35909[(2)] = inst_35880);

(statearr_35899_35909[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0 = (function (){
var statearr_35900 = [null,null,null,null,null,null,null];
(statearr_35900[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16301__auto__);

(statearr_35900[(1)] = (1));

return statearr_35900;
});
var fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1 = (function (state_35885){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35885);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35901){var ex__16304__auto__ = e35901;
var statearr_35902_35910 = state_35885;
(statearr_35902_35910[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35885[(4)]))){
var statearr_35903_35911 = state_35885;
(statearr_35903_35911[(1)] = cljs.core.first((state_35885[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35912 = state_35885;
state_35885 = G__35912;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__ = function(state_35885){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1.call(this,state_35885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35904 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35904[(6)] = c__16375__auto__);

return statearr_35904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35954){
var state_val_35955 = (state_35954[(1)]);
if((state_val_35955 === (7))){
var inst_35937 = (state_35954[(2)]);
var inst_35938 = fluree.db.query.schema.flake__GT_pred_map(inst_35937);
var inst_35939 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_35940 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(114));
var inst_35941 = cljs.core.boolean$(inst_35940);
var inst_35942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(110));
var inst_35943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(117));
var inst_35944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_35943);
var inst_35945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(111));
var inst_35946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(115));
var inst_35947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35938,(112));
var inst_35948 = [inst_35941,inst_35942,inst_35944,inst_35945,inst_35946,inst_35947];
var inst_35949 = cljs.core.PersistentHashMap.fromArrays(inst_35939,inst_35948);
var _ = (function (){var statearr_35956 = state_35954;
(statearr_35956[(4)] = cljs.core.rest((state_35954[(4)])));

return statearr_35956;
})();
var state_35954__$1 = state_35954;
var statearr_35957_35980 = state_35954__$1;
(statearr_35957_35980[(2)] = inst_35949);

(statearr_35957_35980[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (1))){
var state_35954__$1 = state_35954;
var statearr_35958_35981 = state_35954__$1;
(statearr_35958_35981[(2)] = null);

(statearr_35958_35981[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (4))){
var inst_35913 = (state_35954[(2)]);
var state_35954__$1 = state_35954;
var statearr_35959_35982 = state_35954__$1;
(statearr_35959_35982[(2)] = inst_35913);

(statearr_35959_35982[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (6))){
var _ = (function (){var statearr_35960 = state_35954;
(statearr_35960[(4)] = cljs.core.cons((9),(state_35954[(4)])));

return statearr_35960;
})();
var inst_35925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35927 = ["_setting/id","root"];
var inst_35928 = (new cljs.core.PersistentVector(null,2,(5),inst_35926,inst_35927,null));
var inst_35929 = [inst_35928];
var inst_35930 = (new cljs.core.PersistentVector(null,1,(5),inst_35925,inst_35929,null));
var inst_35931 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35930);
var state_35954__$1 = state_35954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35954__$1,(10),inst_35931);
} else {
if((state_val_35955 === (3))){
var inst_35952 = (state_35954[(2)]);
var state_35954__$1 = state_35954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35954__$1,inst_35952);
} else {
if((state_val_35955 === (2))){
var _ = (function (){var statearr_35963 = state_35954;
(statearr_35963[(4)] = cljs.core.cons((5),(state_35954[(4)])));

return statearr_35963;
})();
var state_35954__$1 = state_35954;
var statearr_35964_35983 = state_35954__$1;
(statearr_35964_35983[(2)] = null);

(statearr_35964_35983[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (9))){
var _ = (function (){var statearr_35965 = state_35954;
(statearr_35965[(4)] = cljs.core.rest((state_35954[(4)])));

return statearr_35965;
})();
var state_35954__$1 = state_35954;
var ex35961 = (state_35954__$1[(2)]);
var statearr_35966_35984 = state_35954__$1;
(statearr_35966_35984[(5)] = ex35961);


var statearr_35967_35985 = state_35954__$1;
(statearr_35967_35985[(1)] = (8));

(statearr_35967_35985[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (5))){
var _ = (function (){var statearr_35968 = state_35954;
(statearr_35968[(4)] = cljs.core.rest((state_35954[(4)])));

return statearr_35968;
})();
var state_35954__$1 = state_35954;
var ex35962 = (state_35954__$1[(2)]);
var statearr_35969_35986 = state_35954__$1;
(statearr_35969_35986[(5)] = ex35962);


if((ex35962 instanceof Error)){
var statearr_35970_35987 = state_35954__$1;
(statearr_35970_35987[(1)] = (4));

(statearr_35970_35987[(5)] = null);

} else {
throw ex35962;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (10))){
var inst_35933 = (state_35954[(2)]);
var inst_35934 = fluree.db.util.async.throw_err(inst_35933);
var _ = (function (){var statearr_35971 = state_35954;
(statearr_35971[(4)] = cljs.core.rest((state_35954[(4)])));

return statearr_35971;
})();
var state_35954__$1 = state_35954;
var statearr_35972_35988 = state_35954__$1;
(statearr_35972_35988[(2)] = inst_35934);

(statearr_35972_35988[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35955 === (8))){
var inst_35919 = (state_35954[(2)]);
var state_35954__$1 = (function (){var statearr_35973 = state_35954;
(statearr_35973[(7)] = inst_35919);

return statearr_35973;
})();
var statearr_35974_35989 = state_35954__$1;
(statearr_35974_35989[(2)] = null);

(statearr_35974_35989[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0 = (function (){
var statearr_35975 = [null,null,null,null,null,null,null,null];
(statearr_35975[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16301__auto__);

(statearr_35975[(1)] = (1));

return statearr_35975;
});
var fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1 = (function (state_35954){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35954);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35976){var ex__16304__auto__ = e35976;
var statearr_35977_35990 = state_35954;
(statearr_35977_35990[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35954[(4)]))){
var statearr_35978_35991 = state_35954;
(statearr_35978_35991[(1)] = cljs.core.first((state_35954[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35992 = state_35954;
state_35954 = G__35992;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__ = function(state_35954){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1.call(this,state_35954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16301__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35979 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35979[(6)] = c__16375__auto__);

return statearr_35979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
