// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__41426 = (line + (1));
var G__41427 = (1);
var G__41428 = (counter + (1));
line = G__41426;
col = G__41427;
counter = G__41428;
continue;
} else {
var G__41429 = line;
var G__41430 = (col + (1));
var G__41431 = (counter + (1));
line = G__41429;
col = G__41430;
counter = G__41431;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__41432 = cljs.core.next(chars);
var G__41433 = (n__$1 - (1));
chars = G__41432;
n__$1 = G__41433;
continue;
} else {
var G__41434 = cljs.core.next(chars);
var G__41435 = n__$1;
chars = G__41434;
n__$1 = G__41435;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__41436){
var map__41437 = p__41436;
var map__41437__$1 = (((((!((map__41437 == null))))?(((((map__41437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41437):map__41437);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41437__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41437__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41437__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41437__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__41439_41447 = cljs.core.seq(full_reasons);
var chunk__41440_41448 = null;
var count__41441_41449 = (0);
var i__41442_41450 = (0);
while(true){
if((i__41442_41450 < count__41441_41449)){
var r_41451 = chunk__41440_41448.cljs$core$IIndexed$_nth$arity$2(null,i__41442_41450);
instaparse.failure.print_reason(r_41451);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__41452 = seq__41439_41447;
var G__41453 = chunk__41440_41448;
var G__41454 = count__41441_41449;
var G__41455 = (i__41442_41450 + (1));
seq__41439_41447 = G__41452;
chunk__41440_41448 = G__41453;
count__41441_41449 = G__41454;
i__41442_41450 = G__41455;
continue;
} else {
var temp__5735__auto___41456 = cljs.core.seq(seq__41439_41447);
if(temp__5735__auto___41456){
var seq__41439_41457__$1 = temp__5735__auto___41456;
if(cljs.core.chunked_seq_QMARK_(seq__41439_41457__$1)){
var c__4556__auto___41458 = cljs.core.chunk_first(seq__41439_41457__$1);
var G__41459 = cljs.core.chunk_rest(seq__41439_41457__$1);
var G__41460 = c__4556__auto___41458;
var G__41461 = cljs.core.count(c__4556__auto___41458);
var G__41462 = (0);
seq__41439_41447 = G__41459;
chunk__41440_41448 = G__41460;
count__41441_41449 = G__41461;
i__41442_41450 = G__41462;
continue;
} else {
var r_41463 = cljs.core.first(seq__41439_41457__$1);
instaparse.failure.print_reason(r_41463);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__41464 = cljs.core.next(seq__41439_41457__$1);
var G__41465 = null;
var G__41466 = (0);
var G__41467 = (0);
seq__41439_41447 = G__41464;
chunk__41440_41448 = G__41465;
count__41441_41449 = G__41466;
i__41442_41450 = G__41467;
continue;
}
} else {
}
}
break;
}

var seq__41443 = cljs.core.seq(partial_reasons);
var chunk__41444 = null;
var count__41445 = (0);
var i__41446 = (0);
while(true){
if((i__41446 < count__41445)){
var r = chunk__41444.cljs$core$IIndexed$_nth$arity$2(null,i__41446);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__41468 = seq__41443;
var G__41469 = chunk__41444;
var G__41470 = count__41445;
var G__41471 = (i__41446 + (1));
seq__41443 = G__41468;
chunk__41444 = G__41469;
count__41445 = G__41470;
i__41446 = G__41471;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__41443);
if(temp__5735__auto__){
var seq__41443__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41443__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__41443__$1);
var G__41472 = cljs.core.chunk_rest(seq__41443__$1);
var G__41473 = c__4556__auto__;
var G__41474 = cljs.core.count(c__4556__auto__);
var G__41475 = (0);
seq__41443 = G__41472;
chunk__41444 = G__41473;
count__41445 = G__41474;
i__41446 = G__41475;
continue;
} else {
var r = cljs.core.first(seq__41443__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__41476 = cljs.core.next(seq__41443__$1);
var G__41477 = null;
var G__41478 = (0);
var G__41479 = (0);
seq__41443 = G__41476;
chunk__41444 = G__41477;
count__41445 = G__41478;
i__41446 = G__41479;
continue;
}
} else {
return null;
}
}
break;
}
});
