// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21660 = null;
var G__21660__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__21660__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__21660__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__21660 = function(result,flake){
switch(arguments.length){
case 0:
return G__21660__0.call(this);
case 1:
return G__21660__1.call(this,result);
case 2:
return G__21660__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21660.cljs$core$IFn$_invoke$arity$0 = G__21660__0;
G__21660.cljs$core$IFn$_invoke$arity$1 = G__21660__1;
G__21660.cljs$core$IFn$_invoke$arity$2 = G__21660__2;
return G__21660;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21661 = null;
var G__21661__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__21661__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__21661__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__21661 = function(result,flakes){
switch(arguments.length){
case 0:
return G__21661__0.call(this);
case 1:
return G__21661__1.call(this,result);
case 2:
return G__21661__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21661.cljs$core$IFn$_invoke$arity$0 = G__21661__0;
G__21661.cljs$core$IFn$_invoke$arity$1 = G__21661__1;
G__21661.cljs$core$IFn$_invoke$arity$2 = G__21661__2;
return G__21661;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__21663 = res;
var G__21663__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__21662_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__21662_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__21663):G__21663);
var G__21663__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__21663__$1):G__21663__$1);
var G__21663__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__21663__$2):G__21663__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__21663__$3);
} else {
return G__21663__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__21665 = arguments.length;
switch (G__21665) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_21968){
var state_val_21969 = (state_21968[(1)]);
if((state_val_21969 === (65))){
var inst_21695 = (state_21968[(7)]);
var inst_21826 = (state_21968[(8)]);
var inst_21819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21820 = cljs.core.deref(cache);
var inst_21821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21822 = flake.o;
var inst_21823 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21695);
var inst_21824 = [inst_21822,inst_21823];
var inst_21825 = (new cljs.core.PersistentVector(null,2,(5),inst_21821,inst_21824,null));
var inst_21826__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21820,inst_21825);
var state_21968__$1 = (function (){var statearr_21970 = state_21968;
(statearr_21970[(9)] = inst_21819);

(statearr_21970[(8)] = inst_21826__$1);

return statearr_21970;
})();
if(cljs.core.truth_(inst_21826__$1)){
var statearr_21971_22137 = state_21968__$1;
(statearr_21971_22137[(1)] = (68));

} else {
var statearr_21972_22138 = state_21968__$1;
(statearr_21972_22138[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (70))){
var inst_21819 = (state_21968[(9)]);
var inst_21844 = (state_21968[(2)]);
var inst_21845 = [inst_21844,offset_map];
var inst_21846 = (new cljs.core.PersistentVector(null,2,(5),inst_21819,inst_21845,null));
var state_21968__$1 = state_21968;
var statearr_21973_22139 = state_21968__$1;
(statearr_21973_22139[(2)] = inst_21846);

(statearr_21973_22139[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (62))){
var inst_21695 = (state_21968[(7)]);
var inst_21730 = (state_21968[(10)]);
var inst_21706 = (state_21968[(11)]);
var inst_21788 = (state_21968[(12)]);
var inst_21689 = (state_21968[(13)]);
var inst_21731 = (state_21968[(14)]);
var inst_21733 = (state_21968[(15)]);
var inst_21729 = (state_21968[(16)]);
var inst_21728 = (state_21968[(17)]);
var inst_21732 = (state_21968[(18)]);
var inst_21727 = (state_21968[(19)]);
var inst_21804 = (state_21968[(20)]);
var inst_21806 = (function (){var p = inst_21733;
var pred_spec__$1 = inst_21689;
var orderBy = inst_21731;
var nested_select_spec = inst_21788;
var multi_QMARK_ = inst_21728;
var limit = inst_21730;
var offset = inst_21732;
var map__21672 = inst_21727;
var k = inst_21706;
var G__21790 = inst_21804;
var pred_spec_SINGLEQUOTE_ = inst_21695;
var ref_QMARK_ = inst_21729;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_21807 = (inst_21806.cljs$core$IFn$_invoke$arity$1 ? inst_21806.cljs$core$IFn$_invoke$arity$1(inst_21804) : inst_21806.call(null,inst_21804));
var state_21968__$1 = state_21968;
var statearr_21974_22140 = state_21968__$1;
(statearr_21974_22140[(2)] = inst_21807);

(statearr_21974_22140[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (74))){
var inst_21853 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21853)){
var statearr_21975_22141 = state_21968__$1;
(statearr_21975_22141[(1)] = (75));

} else {
var statearr_21976_22142 = state_21968__$1;
(statearr_21976_22142[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (7))){
var inst_21676 = (state_21968[(21)]);
var state_21968__$1 = state_21968;
var statearr_21977_22143 = state_21968__$1;
(statearr_21977_22143[(2)] = inst_21676);

(statearr_21977_22143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (59))){
var inst_21798 = (state_21968[(22)]);
var inst_21800 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_21801 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21800,inst_21798);
var state_21968__$1 = state_21968;
var statearr_21978_22144 = state_21968__$1;
(statearr_21978_22144[(2)] = inst_21801);

(statearr_21978_22144[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (86))){
var inst_21695 = (state_21968[(7)]);
var inst_21730 = (state_21968[(10)]);
var inst_21866 = (state_21968[(23)]);
var inst_21706 = (state_21968[(11)]);
var inst_21689 = (state_21968[(13)]);
var inst_21731 = (state_21968[(14)]);
var inst_21733 = (state_21968[(15)]);
var inst_21729 = (state_21968[(16)]);
var inst_21728 = (state_21968[(17)]);
var inst_21732 = (state_21968[(18)]);
var inst_21727 = (state_21968[(19)]);
var inst_21884 = (state_21968[(24)]);
var inst_21886 = (function (){var p = inst_21733;
var pred_spec__$1 = inst_21689;
var orderBy = inst_21731;
var children = inst_21866;
var multi_QMARK_ = inst_21728;
var limit = inst_21730;
var offset = inst_21732;
var map__21672 = inst_21727;
var G__21878 = inst_21884;
var k = inst_21706;
var pred_spec_SINGLEQUOTE_ = inst_21695;
var ref_QMARK_ = inst_21729;
return (function (n){
var G__21979 = db;
var G__21980 = cache;
var G__21981 = fuel;
var G__21982 = max_fuel;
var G__21983 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null);
var G__21984 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__21979,G__21980,G__21981,G__21982,G__21983,G__21984) : fluree.db.query.fql.flakes__GT_res.call(null,G__21979,G__21980,G__21981,G__21982,G__21983,G__21984));
});
})();
var inst_21887 = (inst_21886.cljs$core$IFn$_invoke$arity$1 ? inst_21886.cljs$core$IFn$_invoke$arity$1(inst_21884) : inst_21886.call(null,inst_21884));
var state_21968__$1 = state_21968;
var statearr_21985_22145 = state_21968__$1;
(statearr_21985_22145[(2)] = inst_21887);

(statearr_21985_22145[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (20))){
var inst_21704 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_21986_22146 = state_21968__$1;
(statearr_21986_22146[(2)] = inst_21704);

(statearr_21986_22146[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (72))){
var inst_21695 = (state_21968[(7)]);
var inst_21850 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = state_21968;
var statearr_21987_22147 = state_21968__$1;
(statearr_21987_22147[(2)] = inst_21850);

(statearr_21987_22147[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (58))){
var inst_21797 = (state_21968[(2)]);
var inst_21798 = fluree.db.util.async.throw_err(inst_21797);
var state_21968__$1 = (function (){var statearr_21988 = state_21968;
(statearr_21988[(22)] = inst_21798);

return statearr_21988;
})();
if(cljs.core.truth_(fuel)){
var statearr_21989_22148 = state_21968__$1;
(statearr_21989_22148[(1)] = (59));

} else {
var statearr_21990_22149 = state_21968__$1;
(statearr_21990_22149[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (60))){
var inst_21798 = (state_21968[(22)]);
var state_21968__$1 = state_21968;
var statearr_21991_22150 = state_21968__$1;
(statearr_21991_22150[(2)] = inst_21798);

(statearr_21991_22150[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (27))){
var inst_21695 = (state_21968[(7)]);
var inst_21724 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21695);
var state_21968__$1 = state_21968;
var statearr_21992_22151 = state_21968__$1;
(statearr_21992_22151[(2)] = inst_21724);

(statearr_21992_22151[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (1))){
var state_21968__$1 = state_21968;
var statearr_21993_22152 = state_21968__$1;
(statearr_21993_22152[(2)] = null);

(statearr_21993_22152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (69))){
var inst_21695 = (state_21968[(7)]);
var inst_21829 = flake.o;
var inst_21830 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21695);
var inst_21831 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_21829,inst_21830);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21968__$1,(71),inst_21831);
} else {
if((state_val_21969 === (101))){
var inst_21929 = (state_21968[(25)]);
var inst_21706 = (state_21968[(11)]);
var inst_21928 = (state_21968[(26)]);
var inst_21948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21706,inst_21928);
var inst_21950 = [inst_21949,inst_21929];
var inst_21951 = (new cljs.core.PersistentVector(null,2,(5),inst_21948,inst_21950,null));
var state_21968__$1 = state_21968;
var statearr_21994_22153 = state_21968__$1;
(statearr_21994_22153[(2)] = inst_21951);

(statearr_21994_22153[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (24))){
var state_21968__$1 = state_21968;
var statearr_21995_22154 = state_21968__$1;
(statearr_21995_22154[(2)] = true);

(statearr_21995_22154[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (102))){
var state_21968__$1 = state_21968;
var statearr_21996_22155 = state_21968__$1;
(statearr_21996_22155[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (55))){
var inst_21695 = (state_21968[(7)]);
var inst_21817 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21817)){
var statearr_21998_22156 = state_21968__$1;
(statearr_21998_22156[(1)] = (65));

} else {
var statearr_21999_22157 = state_21968__$1;
(statearr_21999_22157[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (85))){
var inst_21884 = (state_21968[(2)]);
var state_21968__$1 = (function (){var statearr_22000 = state_21968;
(statearr_22000[(24)] = inst_21884);

return statearr_22000;
})();
var statearr_22001_22158 = state_21968__$1;
(statearr_22001_22158[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (39))){
var inst_21733 = (state_21968[(15)]);
var inst_21750 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21733,cljs.core.dec);
var state_21968__$1 = state_21968;
var statearr_22003_22159 = state_21968__$1;
(statearr_22003_22159[(2)] = inst_21750);

(statearr_22003_22159[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (88))){
var inst_21890 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21968__$1,(82),inst_21890);
} else {
if((state_val_21969 === (46))){
var inst_21773 = cljs.core.not(recur_QMARK_);
var state_21968__$1 = state_21968;
if(inst_21773){
var statearr_22004_22160 = state_21968__$1;
(statearr_22004_22160[(1)] = (48));

} else {
var statearr_22005_22161 = state_21968__$1;
(statearr_22005_22161[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (4))){
var inst_21666 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22006_22162 = state_21968__$1;
(statearr_22006_22162[(2)] = inst_21666);

(statearr_22006_22162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (77))){
var inst_21919 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22007_22163 = state_21968__$1;
(statearr_22007_22163[(2)] = inst_21919);

(statearr_22007_22163[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (106))){
var inst_21959 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22008_22164 = state_21968__$1;
(statearr_22008_22164[(2)] = inst_21959);

(statearr_22008_22164[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (95))){
var inst_21728 = (state_21968[(17)]);
var state_21968__$1 = state_21968;
var statearr_22009_22165 = state_21968__$1;
(statearr_22009_22165[(2)] = inst_21728);

(statearr_22009_22165[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (54))){
var inst_21695 = (state_21968[(7)]);
var inst_21785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21786 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21787 = (new cljs.core.PersistentVector(null,3,(5),inst_21785,inst_21786,null));
var inst_21788 = cljs.core.select_keys(inst_21695,inst_21787);
var inst_21789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21792 = flake.o;
var inst_21793 = [inst_21792];
var inst_21794 = (new cljs.core.PersistentVector(null,1,(5),inst_21791,inst_21793,null));
var inst_21795 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21794);
var state_21968__$1 = (function (){var statearr_22010 = state_21968;
(statearr_22010[(12)] = inst_21788);

(statearr_22010[(27)] = inst_21789);

return statearr_22010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21968__$1,(58),inst_21795);
} else {
if((state_val_21969 === (92))){
var inst_21909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21910 = flake.o;
var inst_21911 = [inst_21910,offset_map];
var inst_21912 = (new cljs.core.PersistentVector(null,2,(5),inst_21909,inst_21911,null));
var state_21968__$1 = state_21968;
var statearr_22011_22166 = state_21968__$1;
(statearr_22011_22166[(2)] = inst_21912);

(statearr_22011_22166[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (104))){
var inst_21929 = (state_21968[(25)]);
var inst_21954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21955 = [acc,inst_21929];
var inst_21956 = (new cljs.core.PersistentVector(null,2,(5),inst_21954,inst_21955,null));
var state_21968__$1 = state_21968;
var statearr_22012_22167 = state_21968__$1;
(statearr_22012_22167[(2)] = inst_21956);

(statearr_22012_22167[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (15))){
var inst_21696 = (state_21968[(28)]);
var state_21968__$1 = state_21968;
var statearr_22013_22168 = state_21968__$1;
(statearr_22013_22168[(2)] = inst_21696);

(statearr_22013_22168[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (48))){
var inst_21695 = (state_21968[(7)]);
var inst_21775 = (state_21968[(29)]);
var inst_21775__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = (function (){var statearr_22014 = state_21968;
(statearr_22014[(29)] = inst_21775__$1);

return statearr_22014;
})();
if(cljs.core.truth_(inst_21775__$1)){
var statearr_22015_22169 = state_21968__$1;
(statearr_22015_22169[(1)] = (51));

} else {
var statearr_22016_22170 = state_21968__$1;
(statearr_22016_22170[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (50))){
var inst_21783 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21783)){
var statearr_22017_22171 = state_21968__$1;
(statearr_22017_22171[(1)] = (54));

} else {
var statearr_22018_22172 = state_21968__$1;
(statearr_22018_22172[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (75))){
var inst_21695 = (state_21968[(7)]);
var inst_21855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21856 = flake.o;
var inst_21857 = [inst_21856];
var inst_21858 = (new cljs.core.PersistentVector(null,1,(5),inst_21855,inst_21857,null));
var inst_21859 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21860 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21695);
var inst_21861 = [inst_21860];
var inst_21862 = cljs.core.PersistentHashMap.fromArrays(inst_21859,inst_21861);
var inst_21863 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21858,inst_21862);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21968__$1,(78),inst_21863);
} else {
if((state_val_21969 === (99))){
var inst_21928 = (state_21968[(26)]);
var inst_21945 = (inst_21928 == null);
var inst_21946 = cljs.core.not(inst_21945);
var state_21968__$1 = state_21968;
if(inst_21946){
var statearr_22019_22173 = state_21968__$1;
(statearr_22019_22173[(1)] = (101));

} else {
var statearr_22020_22174 = state_21968__$1;
(statearr_22020_22174[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (21))){
var inst_21695 = (state_21968[(7)]);
var inst_21711 = inst_21695.cljs$lang$protocol_mask$partition0$;
var inst_21712 = (inst_21711 & (64));
var inst_21713 = inst_21695.cljs$core$ISeq$;
var inst_21714 = (cljs.core.PROTOCOL_SENTINEL === inst_21713);
var inst_21715 = ((inst_21712) || (inst_21714));
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21715)){
var statearr_22021_22175 = state_21968__$1;
(statearr_22021_22175[(1)] = (24));

} else {
var statearr_22022_22176 = state_21968__$1;
(statearr_22022_22176[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (31))){
var inst_21728 = (state_21968[(17)]);
var state_21968__$1 = state_21968;
var statearr_22023_22177 = state_21968__$1;
(statearr_22023_22177[(2)] = inst_21728);

(statearr_22023_22177[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (32))){
var inst_21745 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21745)){
var statearr_22024_22178 = state_21968__$1;
(statearr_22024_22178[(1)] = (36));

} else {
var statearr_22025_22179 = state_21968__$1;
(statearr_22025_22179[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (40))){
var inst_21733 = (state_21968[(15)]);
var inst_21732 = (state_21968[(18)]);
var inst_21752 = (inst_21732 - (1));
var inst_21753 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21733,inst_21752);
var state_21968__$1 = state_21968;
var statearr_22026_22180 = state_21968__$1;
(statearr_22026_22180[(2)] = inst_21753);

(statearr_22026_22180[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (91))){
var inst_21917 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22027_22181 = state_21968__$1;
(statearr_22027_22181[(2)] = inst_21917);

(statearr_22027_22181[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (56))){
var inst_21923 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22028_22182 = state_21968__$1;
(statearr_22028_22182[(2)] = inst_21923);

(statearr_22028_22182[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (33))){
var inst_21733 = (state_21968[(15)]);
var inst_21732 = (state_21968[(18)]);
var inst_21736 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21732);
var inst_21737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21733);
var inst_21738 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21737);
var inst_21739 = ((inst_21736) && (inst_21738));
var state_21968__$1 = state_21968;
var statearr_22029_22183 = state_21968__$1;
(statearr_22029_22183[(2)] = inst_21739);

(statearr_22029_22183[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (13))){
var inst_21689 = (state_21968[(13)]);
var inst_21693 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21689,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_21968__$1 = state_21968;
var statearr_22030_22184 = state_21968__$1;
(statearr_22030_22184[(2)] = inst_21693);

(statearr_22030_22184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (22))){
var state_21968__$1 = state_21968;
var statearr_22031_22185 = state_21968__$1;
(statearr_22031_22185[(2)] = false);

(statearr_22031_22185[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (90))){
var state_21968__$1 = state_21968;
var statearr_22032_22186 = state_21968__$1;
(statearr_22032_22186[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (36))){
var inst_21733 = (state_21968[(15)]);
var inst_21747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21733);
var state_21968__$1 = (function (){var statearr_22034 = state_21968;
(statearr_22034[(30)] = inst_21747);

return statearr_22034;
})();
if(cljs.core.truth_(inst_21748)){
var statearr_22035_22187 = state_21968__$1;
(statearr_22035_22187[(1)] = (39));

} else {
var statearr_22036_22188 = state_21968__$1;
(statearr_22036_22188[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (41))){
var inst_21747 = (state_21968[(30)]);
var inst_21755 = (state_21968[(2)]);
var inst_21756 = [null,inst_21755];
var inst_21757 = (new cljs.core.PersistentVector(null,2,(5),inst_21747,inst_21756,null));
var state_21968__$1 = state_21968;
var statearr_22037_22189 = state_21968__$1;
(statearr_22037_22189[(2)] = inst_21757);

(statearr_22037_22189[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (89))){
var inst_21900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21901 = ["_id"];
var inst_21902 = flake.o;
var inst_21903 = [inst_21902];
var inst_21904 = cljs.core.PersistentHashMap.fromArrays(inst_21901,inst_21903);
var inst_21905 = [inst_21904,offset_map];
var inst_21906 = (new cljs.core.PersistentVector(null,2,(5),inst_21900,inst_21905,null));
var state_21968__$1 = state_21968;
var statearr_22038_22190 = state_21968__$1;
(statearr_22038_22190[(2)] = inst_21906);

(statearr_22038_22190[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (100))){
var inst_21963 = (state_21968[(2)]);
var _ = (function (){var statearr_22039 = state_21968;
(statearr_22039[(4)] = cljs.core.rest((state_21968[(4)])));

return statearr_22039;
})();
var state_21968__$1 = state_21968;
var statearr_22040_22191 = state_21968__$1;
(statearr_22040_22191[(2)] = inst_21963);

(statearr_22040_22191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (43))){
var inst_21728 = (state_21968[(17)]);
var state_21968__$1 = state_21968;
var statearr_22041_22192 = state_21968__$1;
(statearr_22041_22192[(2)] = inst_21728);

(statearr_22041_22192[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (61))){
var inst_21804 = (state_21968[(2)]);
var state_21968__$1 = (function (){var statearr_22042 = state_21968;
(statearr_22042[(20)] = inst_21804);

return statearr_22042;
})();
var statearr_22043_22193 = state_21968__$1;
(statearr_22043_22193[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (29))){
var inst_21728 = (state_21968[(17)]);
var inst_21727 = (state_21968[(19)]);
var inst_21727__$1 = (state_21968[(2)]);
var inst_21728__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21727__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_21968__$1 = (function (){var statearr_22045 = state_21968;
(statearr_22045[(10)] = inst_21730);

(statearr_22045[(14)] = inst_21731);

(statearr_22045[(15)] = inst_21733);

(statearr_22045[(16)] = inst_21729);

(statearr_22045[(17)] = inst_21728__$1);

(statearr_22045[(18)] = inst_21732);

(statearr_22045[(19)] = inst_21727__$1);

return statearr_22045;
})();
if(cljs.core.truth_(inst_21728__$1)){
var statearr_22046_22194 = state_21968__$1;
(statearr_22046_22194[(1)] = (30));

} else {
var statearr_22047_22195 = state_21968__$1;
(statearr_22047_22195[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (44))){
var inst_21767 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21767)){
var statearr_22048_22196 = state_21968__$1;
(statearr_22048_22196[(1)] = (45));

} else {
var statearr_22049_22197 = state_21968__$1;
(statearr_22049_22197[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (93))){
var state_21968__$1 = state_21968;
var statearr_22050_22198 = state_21968__$1;
(statearr_22050_22198[(2)] = null);

(statearr_22050_22198[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (6))){
var inst_21678 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21679 = (inst_21678 == null);
var state_21968__$1 = state_21968;
var statearr_22051_22199 = state_21968__$1;
(statearr_22051_22199[(2)] = inst_21679);

(statearr_22051_22199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (28))){
var inst_21695 = (state_21968[(7)]);
var state_21968__$1 = state_21968;
var statearr_22052_22200 = state_21968__$1;
(statearr_22052_22200[(2)] = inst_21695);

(statearr_22052_22200[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (64))){
var inst_21810 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21968__$1,(57),inst_21810);
} else {
if((state_val_21969 === (103))){
var inst_21961 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22053_22201 = state_21968__$1;
(statearr_22053_22201[(2)] = inst_21961);

(statearr_22053_22201[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (51))){
var inst_21775 = (state_21968[(29)]);
var state_21968__$1 = state_21968;
var statearr_22054_22202 = state_21968__$1;
(statearr_22054_22202[(2)] = inst_21775);

(statearr_22054_22202[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (25))){
var state_21968__$1 = state_21968;
var statearr_22055_22203 = state_21968__$1;
(statearr_22055_22203[(2)] = false);

(statearr_22055_22203[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (34))){
var inst_21732 = (state_21968[(18)]);
var state_21968__$1 = state_21968;
var statearr_22056_22204 = state_21968__$1;
(statearr_22056_22204[(2)] = inst_21732);

(statearr_22056_22204[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (17))){
var inst_21695 = (state_21968[(7)]);
var inst_21706 = (state_21968[(2)]);
var inst_21708 = (inst_21695 == null);
var inst_21709 = cljs.core.not(inst_21708);
var state_21968__$1 = (function (){var statearr_22057 = state_21968;
(statearr_22057[(11)] = inst_21706);

return statearr_22057;
})();
if(inst_21709){
var statearr_22058_22205 = state_21968__$1;
(statearr_22058_22205[(1)] = (21));

} else {
var statearr_22059_22206 = state_21968__$1;
(statearr_22059_22206[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (3))){
var inst_21966 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21968__$1,inst_21966);
} else {
if((state_val_21969 === (12))){
var inst_21689 = (state_21968[(13)]);
var state_21968__$1 = state_21968;
var statearr_22060_22207 = state_21968__$1;
(statearr_22060_22207[(2)] = inst_21689);

(statearr_22060_22207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (2))){
var inst_21676 = (state_21968[(21)]);
var _ = (function (){var statearr_22061 = state_21968;
(statearr_22061[(4)] = cljs.core.cons((5),(state_21968[(4)])));

return statearr_22061;
})();
var inst_21676__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_21968__$1 = (function (){var statearr_22062 = state_21968;
(statearr_22062[(21)] = inst_21676__$1);

return statearr_22062;
})();
if(cljs.core.truth_(inst_21676__$1)){
var statearr_22063_22208 = state_21968__$1;
(statearr_22063_22208[(1)] = (6));

} else {
var statearr_22064_22209 = state_21968__$1;
(statearr_22064_22209[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (66))){
var inst_21848 = (state_21968[(31)]);
var inst_21848__$1 = componentFollow_QMARK_;
var state_21968__$1 = (function (){var statearr_22065 = state_21968;
(statearr_22065[(31)] = inst_21848__$1);

return statearr_22065;
})();
if(cljs.core.truth_(inst_21848__$1)){
var statearr_22066_22210 = state_21968__$1;
(statearr_22066_22210[(1)] = (72));

} else {
var statearr_22067_22211 = state_21968__$1;
(statearr_22067_22211[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (23))){
var inst_21722 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21722)){
var statearr_22068_22212 = state_21968__$1;
(statearr_22068_22212[(1)] = (27));

} else {
var statearr_22069_22213 = state_21968__$1;
(statearr_22069_22213[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (47))){
var inst_21925 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22070_22214 = state_21968__$1;
(statearr_22070_22214[(2)] = inst_21925);

(statearr_22070_22214[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (35))){
var inst_21742 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22071_22215 = state_21968__$1;
(statearr_22071_22215[(2)] = inst_21742);

(statearr_22071_22215[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (82))){
var inst_21877 = (state_21968[(32)]);
var inst_21892 = (state_21968[(2)]);
var inst_21893 = fluree.db.util.async.throw_err(inst_21892);
var inst_21894 = [inst_21893,offset_map];
var inst_21895 = (new cljs.core.PersistentVector(null,2,(5),inst_21877,inst_21894,null));
var state_21968__$1 = state_21968;
var statearr_22072_22216 = state_21968__$1;
(statearr_22072_22216[(2)] = inst_21895);

(statearr_22072_22216[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (76))){
var inst_21729 = (state_21968[(16)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21729)){
var statearr_22073_22217 = state_21968__$1;
(statearr_22073_22217[(1)] = (89));

} else {
var statearr_22074_22218 = state_21968__$1;
(statearr_22074_22218[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (97))){
var inst_21935 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21935)){
var statearr_22075_22219 = state_21968__$1;
(statearr_22075_22219[(1)] = (98));

} else {
var statearr_22076_22220 = state_21968__$1;
(statearr_22076_22220[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (19))){
var inst_21695 = (state_21968[(7)]);
var inst_21702 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = state_21968;
var statearr_22077_22221 = state_21968__$1;
(statearr_22077_22221[(2)] = inst_21702);

(statearr_22077_22221[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (57))){
var inst_21789 = (state_21968[(27)]);
var inst_21812 = (state_21968[(2)]);
var inst_21813 = fluree.db.util.async.throw_err(inst_21812);
var inst_21814 = [inst_21813,offset_map];
var inst_21815 = (new cljs.core.PersistentVector(null,2,(5),inst_21789,inst_21814,null));
var state_21968__$1 = state_21968;
var statearr_22078_22222 = state_21968__$1;
(statearr_22078_22222[(2)] = inst_21815);

(statearr_22078_22222[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (68))){
var inst_21826 = (state_21968[(8)]);
var state_21968__$1 = state_21968;
var statearr_22079_22223 = state_21968__$1;
(statearr_22079_22223[(2)] = inst_21826);

(statearr_22079_22223[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (11))){
var inst_21689 = (state_21968[(13)]);
var inst_21689__$1 = (state_21968[(2)]);
var inst_21690 = cljs.core.contains_QMARK_(inst_21689__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_21968__$1 = (function (){var statearr_22081 = state_21968;
(statearr_22081[(13)] = inst_21689__$1);

return statearr_22081;
})();
if(inst_21690){
var statearr_22082_22224 = state_21968__$1;
(statearr_22082_22224[(1)] = (12));

} else {
var statearr_22083_22225 = state_21968__$1;
(statearr_22083_22225[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (9))){
var inst_21684 = flake.p;
var inst_21685 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21686 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_21684,inst_21685);
var state_21968__$1 = state_21968;
var statearr_22084_22226 = state_21968__$1;
(statearr_22084_22226[(2)] = inst_21686);

(statearr_22084_22226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (5))){
var _ = (function (){var statearr_22085 = state_21968;
(statearr_22085[(4)] = cljs.core.rest((state_21968[(4)])));

return statearr_22085;
})();
var state_21968__$1 = state_21968;
var ex22080 = (state_21968__$1[(2)]);
var statearr_22086_22227 = state_21968__$1;
(statearr_22086_22227[(5)] = ex22080);


if((ex22080 instanceof Error)){
var statearr_22087_22228 = state_21968__$1;
(statearr_22087_22228[(1)] = (4));

(statearr_22087_22228[(5)] = null);

} else {
throw ex22080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (83))){
var inst_21866 = (state_21968[(23)]);
var inst_21880 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_21881 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21880,inst_21866);
var state_21968__$1 = state_21968;
var statearr_22088_22229 = state_21968__$1;
(statearr_22088_22229[(2)] = inst_21881);

(statearr_22088_22229[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (14))){
var inst_21695 = (state_21968[(7)]);
var inst_21696 = (state_21968[(28)]);
var inst_21695__$1 = (state_21968[(2)]);
var inst_21696__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21695__$1);
var state_21968__$1 = (function (){var statearr_22089 = state_21968;
(statearr_22089[(7)] = inst_21695__$1);

(statearr_22089[(28)] = inst_21696__$1);

return statearr_22089;
})();
if(cljs.core.truth_(inst_21696__$1)){
var statearr_22090_22230 = state_21968__$1;
(statearr_22090_22230[(1)] = (15));

} else {
var statearr_22091_22231 = state_21968__$1;
(statearr_22091_22231[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (45))){
var inst_21769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21770 = [null,offset_map];
var inst_21771 = (new cljs.core.PersistentVector(null,2,(5),inst_21769,inst_21770,null));
var state_21968__$1 = state_21968;
var statearr_22092_22232 = state_21968__$1;
(statearr_22092_22232[(2)] = inst_21771);

(statearr_22092_22232[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (53))){
var inst_21780 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22093_22233 = state_21968__$1;
(statearr_22093_22233[(2)] = inst_21780);

(statearr_22093_22233[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (78))){
var inst_21866 = (state_21968[(23)]);
var inst_21865 = (state_21968[(2)]);
var inst_21866__$1 = fluree.db.util.async.throw_err(inst_21865);
var inst_21867 = cljs.core.empty_QMARK_(inst_21866__$1);
var state_21968__$1 = (function (){var statearr_22094 = state_21968;
(statearr_22094[(23)] = inst_21866__$1);

return statearr_22094;
})();
if(inst_21867){
var statearr_22095_22234 = state_21968__$1;
(statearr_22095_22234[(1)] = (79));

} else {
var statearr_22096_22235 = state_21968__$1;
(statearr_22096_22235[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (26))){
var inst_21719 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22097_22236 = state_21968__$1;
(statearr_22097_22236[(2)] = inst_21719);

(statearr_22097_22236[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (16))){
var inst_21695 = (state_21968[(7)]);
var inst_21699 = (state_21968[(33)]);
var inst_21699__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = (function (){var statearr_22098 = state_21968;
(statearr_22098[(33)] = inst_21699__$1);

return statearr_22098;
})();
if(cljs.core.truth_(inst_21699__$1)){
var statearr_22099_22237 = state_21968__$1;
(statearr_22099_22237[(1)] = (18));

} else {
var statearr_22100_22238 = state_21968__$1;
(statearr_22100_22238[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (81))){
var inst_21897 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22101_22239 = state_21968__$1;
(statearr_22101_22239[(2)] = inst_21897);

(statearr_22101_22239[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (79))){
var inst_21869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21870 = ["_id"];
var inst_21871 = flake.o;
var inst_21872 = [inst_21871];
var inst_21873 = cljs.core.PersistentHashMap.fromArrays(inst_21870,inst_21872);
var inst_21874 = [inst_21873,offset_map];
var inst_21875 = (new cljs.core.PersistentVector(null,2,(5),inst_21869,inst_21874,null));
var state_21968__$1 = state_21968;
var statearr_22102_22240 = state_21968__$1;
(statearr_22102_22240[(2)] = inst_21875);

(statearr_22102_22240[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (38))){
var inst_21928 = (state_21968[(26)]);
var inst_21927 = (state_21968[(2)]);
var inst_21928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21927,(0),null);
var inst_21929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21927,(1),null);
var inst_21930 = (inst_21928__$1 == null);
var inst_21931 = cljs.core.not(inst_21930);
var state_21968__$1 = (function (){var statearr_22103 = state_21968;
(statearr_22103[(25)] = inst_21929);

(statearr_22103[(26)] = inst_21928__$1);

return statearr_22103;
})();
if(inst_21931){
var statearr_22104_22241 = state_21968__$1;
(statearr_22104_22241[(1)] = (95));

} else {
var statearr_22105_22242 = state_21968__$1;
(statearr_22105_22242[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (98))){
var inst_21929 = (state_21968[(25)]);
var inst_21706 = (state_21968[(11)]);
var inst_21928 = (state_21968[(26)]);
var inst_21937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21938 = cljs.core.PersistentVector.EMPTY;
var inst_21939 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_21706,inst_21938);
var inst_21940 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21939,inst_21928);
var inst_21941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21706,inst_21940);
var inst_21942 = [inst_21941,inst_21929];
var inst_21943 = (new cljs.core.PersistentVector(null,2,(5),inst_21937,inst_21942,null));
var state_21968__$1 = state_21968;
var statearr_22106_22243 = state_21968__$1;
(statearr_22106_22243[(2)] = inst_21943);

(statearr_22106_22243[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (87))){
var inst_21884 = (state_21968[(24)]);
var state_21968__$1 = state_21968;
var statearr_22107_22244 = state_21968__$1;
(statearr_22107_22244[(2)] = inst_21884);

(statearr_22107_22244[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (30))){
var inst_21732 = (state_21968[(18)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21732)){
var statearr_22108_22245 = state_21968__$1;
(statearr_22108_22245[(1)] = (33));

} else {
var statearr_22109_22246 = state_21968__$1;
(statearr_22109_22246[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (73))){
var inst_21848 = (state_21968[(31)]);
var state_21968__$1 = state_21968;
var statearr_22110_22247 = state_21968__$1;
(statearr_22110_22247[(2)] = inst_21848);

(statearr_22110_22247[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (96))){
var state_21968__$1 = state_21968;
var statearr_22111_22248 = state_21968__$1;
(statearr_22111_22248[(2)] = false);

(statearr_22111_22248[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (10))){
var state_21968__$1 = state_21968;
var statearr_22112_22249 = state_21968__$1;
(statearr_22112_22249[(2)] = pred_spec);

(statearr_22112_22249[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (18))){
var inst_21699 = (state_21968[(33)]);
var state_21968__$1 = state_21968;
var statearr_22113_22250 = state_21968__$1;
(statearr_22113_22250[(2)] = inst_21699);

(statearr_22113_22250[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (105))){
var state_21968__$1 = state_21968;
var statearr_22114_22251 = state_21968__$1;
(statearr_22114_22251[(2)] = null);

(statearr_22114_22251[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (52))){
var inst_21695 = (state_21968[(7)]);
var inst_21778 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21695);
var state_21968__$1 = state_21968;
var statearr_22115_22252 = state_21968__$1;
(statearr_22115_22252[(2)] = inst_21778);

(statearr_22115_22252[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (67))){
var inst_21921 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22116_22253 = state_21968__$1;
(statearr_22116_22253[(2)] = inst_21921);

(statearr_22116_22253[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (71))){
var inst_21695 = (state_21968[(7)]);
var inst_21833 = (state_21968[(2)]);
var inst_21834 = fluree.db.util.async.throw_err(inst_21833);
var inst_21835 = cljs.core._deref(cache);
var inst_21836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21837 = flake.o;
var inst_21838 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21695);
var inst_21839 = [inst_21837,inst_21838];
var inst_21840 = (new cljs.core.PersistentVector(null,2,(5),inst_21836,inst_21839,null));
var inst_21841 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21835,inst_21840,inst_21834);
var inst_21842 = cljs.core._vreset_BANG_(cache,inst_21841);
var state_21968__$1 = (function (){var statearr_22117 = state_21968;
(statearr_22117[(34)] = inst_21842);

return statearr_22117;
})();
var statearr_22118_22254 = state_21968__$1;
(statearr_22118_22254[(2)] = inst_21834);

(statearr_22118_22254[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (42))){
var inst_21730 = (state_21968[(10)]);
var inst_21706 = (state_21968[(11)]);
var inst_21731 = (state_21968[(14)]);
var inst_21760 = cljs.core.not(inst_21731);
var inst_21761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_21706);
var inst_21762 = cljs.core.count(inst_21761);
var inst_21763 = (inst_21762 >= inst_21730);
var inst_21764 = ((inst_21760) && (inst_21763));
var state_21968__$1 = state_21968;
var statearr_22119_22255 = state_21968__$1;
(statearr_22119_22255[(2)] = inst_21764);

(statearr_22119_22255[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (80))){
var inst_21877 = cljs.core.PersistentVector.EMPTY_NODE;
var state_21968__$1 = (function (){var statearr_22120 = state_21968;
(statearr_22120[(32)] = inst_21877);

return statearr_22120;
})();
if(cljs.core.truth_(fuel)){
var statearr_22121_22256 = state_21968__$1;
(statearr_22121_22256[(1)] = (83));

} else {
var statearr_22122_22257 = state_21968__$1;
(statearr_22122_22257[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (37))){
var inst_21728 = (state_21968[(17)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21728)){
var statearr_22123_22258 = state_21968__$1;
(statearr_22123_22258[(1)] = (42));

} else {
var statearr_22124_22259 = state_21968__$1;
(statearr_22124_22259[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (63))){
var inst_21804 = (state_21968[(20)]);
var state_21968__$1 = state_21968;
var statearr_22125_22260 = state_21968__$1;
(statearr_22125_22260[(2)] = inst_21804);

(statearr_22125_22260[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (94))){
var inst_21915 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
var statearr_22126_22261 = state_21968__$1;
(statearr_22126_22261[(2)] = inst_21915);

(statearr_22126_22261[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (8))){
var inst_21682 = (state_21968[(2)]);
var state_21968__$1 = state_21968;
if(cljs.core.truth_(inst_21682)){
var statearr_22127_22262 = state_21968__$1;
(statearr_22127_22262[(1)] = (9));

} else {
var statearr_22128_22263 = state_21968__$1;
(statearr_22128_22263[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (49))){
var state_21968__$1 = state_21968;
var statearr_22129_22264 = state_21968__$1;
(statearr_22129_22264[(2)] = false);

(statearr_22129_22264[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21969 === (84))){
var inst_21866 = (state_21968[(23)]);
var state_21968__$1 = state_21968;
var statearr_22130_22265 = state_21968__$1;
(statearr_22130_22265[(2)] = inst_21866);

(statearr_22130_22265[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_22131 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22131[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_22131[(1)] = (1));

return statearr_22131;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_21968){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_21968);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22132){var ex__2417__auto__ = e22132;
var statearr_22133_22266 = state_21968;
(statearr_22133_22266[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_21968[(4)]))){
var statearr_22134_22267 = state_21968;
(statearr_22134_22267[(1)] = cljs.core.first((state_21968[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22268 = state_21968;
state_21968 = G__22268;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_21968){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_21968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22135 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22135[(6)] = c__2436__auto__);

return statearr_22135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22448){
var state_val_22449 = (state_22448[(1)]);
if((state_val_22449 === (7))){
var inst_22443 = (state_22448[(2)]);
var _ = (function (){var statearr_22450 = state_22448;
(statearr_22450[(4)] = cljs.core.rest((state_22448[(4)])));

return statearr_22450;
})();
var state_22448__$1 = state_22448;
var statearr_22451_22546 = state_22448__$1;
(statearr_22451_22546[(2)] = inst_22443);

(statearr_22451_22546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (59))){
var inst_22329 = (state_22448[(7)]);
var state_22448__$1 = state_22448;
var statearr_22452_22547 = state_22448__$1;
(statearr_22452_22547[(2)] = inst_22329);

(statearr_22452_22547[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (20))){
var inst_22338 = (state_22448[(8)]);
var inst_22335 = (state_22448[(2)]);
var inst_22336 = fluree.db.util.async.throw_err(inst_22335);
var inst_22337 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_22336);
var inst_22338__$1 = cljs.core.not_empty(inst_22337);
var state_22448__$1 = (function (){var statearr_22453 = state_22448;
(statearr_22453[(8)] = inst_22338__$1);

return statearr_22453;
})();
if(cljs.core.truth_(inst_22338__$1)){
var statearr_22454_22548 = state_22448__$1;
(statearr_22454_22548[(1)] = (21));

} else {
var statearr_22455_22549 = state_22448__$1;
(statearr_22455_22549[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (58))){
var inst_22328 = (state_22448[(9)]);
var state_22448__$1 = state_22448;
var statearr_22456_22550 = state_22448__$1;
(statearr_22456_22550[(2)] = inst_22328);

(statearr_22456_22550[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (60))){
var inst_22435 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22457_22551 = state_22448__$1;
(statearr_22457_22551[(2)] = inst_22435);

(statearr_22457_22551[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (27))){
var inst_22368 = (state_22448[(10)]);
var inst_22360 = (state_22448[(11)]);
var inst_22370 = (state_22448[(12)]);
var inst_22367 = cljs.core.seq(inst_22360);
var inst_22368__$1 = cljs.core.first(inst_22367);
var inst_22369 = cljs.core.next(inst_22367);
var inst_22370__$1 = cljs.core.not(inst_22368__$1);
var state_22448__$1 = (function (){var statearr_22458 = state_22448;
(statearr_22458[(10)] = inst_22368__$1);

(statearr_22458[(13)] = inst_22369);

(statearr_22458[(12)] = inst_22370__$1);

return statearr_22458;
})();
if(inst_22370__$1){
var statearr_22459_22552 = state_22448__$1;
(statearr_22459_22552[(1)] = (29));

} else {
var statearr_22460_22553 = state_22448__$1;
(statearr_22460_22553[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (1))){
var state_22448__$1 = state_22448;
var statearr_22461_22554 = state_22448__$1;
(statearr_22461_22554[(2)] = null);

(statearr_22461_22554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (24))){
var inst_22338 = (state_22448[(8)]);
var inst_22344 = cljs.core.count(inst_22338);
var inst_22345 = fluree.db.query.fql.add_fuel(fuel,inst_22344,max_fuel);
var state_22448__$1 = state_22448;
var statearr_22462_22555 = state_22448__$1;
(statearr_22462_22555[(2)] = inst_22345);

(statearr_22462_22555[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (55))){
var inst_22327 = (state_22448[(14)]);
var state_22448__$1 = state_22448;
var statearr_22463_22556 = state_22448__$1;
(statearr_22463_22556[(2)] = inst_22327);

(statearr_22463_22556[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (39))){
var inst_22325 = (state_22448[(15)]);
var state_22448__$1 = state_22448;
var statearr_22464_22557 = state_22448__$1;
(statearr_22464_22557[(2)] = inst_22325);

(statearr_22464_22557[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (46))){
var inst_22423 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22465_22558 = state_22448__$1;
(statearr_22465_22558[(2)] = inst_22423);

(statearr_22465_22558[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (4))){
var inst_22269 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22466_22559 = state_22448__$1;
(statearr_22466_22559[(2)] = inst_22269);

(statearr_22466_22559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (54))){
var inst_22362 = (state_22448[(16)]);
var inst_22414 = (state_22448[(2)]);
var inst_22415 = fluree.db.util.async.throw_err(inst_22414);
var inst_22416 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22362,inst_22415);
var state_22448__$1 = state_22448;
var statearr_22467_22560 = state_22448__$1;
(statearr_22467_22560[(2)] = inst_22416);

(statearr_22467_22560[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (15))){
var state_22448__$1 = state_22448;
var statearr_22468_22561 = state_22448__$1;
(statearr_22468_22561[(2)] = false);

(statearr_22468_22561[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (48))){
var inst_22362 = (state_22448[(16)]);
var state_22448__$1 = state_22448;
var statearr_22469_22562 = state_22448__$1;
(statearr_22469_22562[(2)] = inst_22362);

(statearr_22469_22562[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (50))){
var inst_22361 = (state_22448[(17)]);
var inst_22369 = (state_22448[(13)]);
var inst_22418 = (state_22448[(2)]);
var inst_22419 = (inst_22361 + (1));
var inst_22360 = inst_22369;
var inst_22361__$1 = inst_22419;
var inst_22362 = inst_22418;
var state_22448__$1 = (function (){var statearr_22470 = state_22448;
(statearr_22470[(17)] = inst_22361__$1);

(statearr_22470[(16)] = inst_22362);

(statearr_22470[(11)] = inst_22360);

return statearr_22470;
})();
var statearr_22471_22563 = state_22448__$1;
(statearr_22471_22563[(2)] = null);

(statearr_22471_22563[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (21))){
var state_22448__$1 = state_22448;
var statearr_22472_22564 = state_22448__$1;
(statearr_22472_22564[(2)] = fuel);

(statearr_22472_22564[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (31))){
var inst_22379 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22379)){
var statearr_22473_22565 = state_22448__$1;
(statearr_22473_22565[(1)] = (35));

} else {
var statearr_22474_22566 = state_22448__$1;
(statearr_22474_22566[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (32))){
var inst_22361 = (state_22448[(17)]);
var inst_22326 = (state_22448[(18)]);
var inst_22374 = (inst_22361 >= inst_22326);
var state_22448__$1 = state_22448;
var statearr_22475_22567 = state_22448__$1;
(statearr_22475_22567[(2)] = inst_22374);

(statearr_22475_22567[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (40))){
var inst_22386 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22386)){
var statearr_22476_22568 = state_22448__$1;
(statearr_22476_22568[(1)] = (41));

} else {
var statearr_22477_22569 = state_22448__$1;
(statearr_22477_22569[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (56))){
var inst_22328 = (state_22448[(9)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22328)){
var statearr_22478_22570 = state_22448__$1;
(statearr_22478_22570[(1)] = (58));

} else {
var statearr_22479_22571 = state_22448__$1;
(statearr_22479_22571[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (33))){
var inst_22326 = (state_22448[(18)]);
var state_22448__$1 = state_22448;
var statearr_22480_22572 = state_22448__$1;
(statearr_22480_22572[(2)] = inst_22326);

(statearr_22480_22572[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (13))){
var inst_22319 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22319)){
var statearr_22481_22573 = state_22448__$1;
(statearr_22481_22573[(1)] = (17));

} else {
var statearr_22482_22574 = state_22448__$1;
(statearr_22482_22574[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (22))){
var inst_22338 = (state_22448[(8)]);
var state_22448__$1 = state_22448;
var statearr_22484_22575 = state_22448__$1;
(statearr_22484_22575[(2)] = inst_22338);

(statearr_22484_22575[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (36))){
var inst_22325 = (state_22448[(15)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22325)){
var statearr_22485_22576 = state_22448__$1;
(statearr_22485_22576[(1)] = (38));

} else {
var statearr_22486_22577 = state_22448__$1;
(statearr_22486_22577[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (41))){
var inst_22361 = (state_22448[(17)]);
var inst_22362 = (state_22448[(16)]);
var inst_22369 = (state_22448[(13)]);
var inst_22388 = (inst_22361 + (1));
var tmp22483 = inst_22362;
var inst_22360 = inst_22369;
var inst_22361__$1 = inst_22388;
var inst_22362__$1 = tmp22483;
var state_22448__$1 = (function (){var statearr_22487 = state_22448;
(statearr_22487[(17)] = inst_22361__$1);

(statearr_22487[(16)] = inst_22362__$1);

(statearr_22487[(11)] = inst_22360);

return statearr_22487;
})();
var statearr_22488_22578 = state_22448__$1;
(statearr_22488_22578[(2)] = null);

(statearr_22488_22578[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (43))){
var inst_22425 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22489_22579 = state_22448__$1;
(statearr_22489_22579[(2)] = inst_22425);

(statearr_22489_22579[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (29))){
var inst_22370 = (state_22448[(12)]);
var state_22448__$1 = state_22448;
var statearr_22490_22580 = state_22448__$1;
(statearr_22490_22580[(2)] = inst_22370);

(statearr_22490_22580[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (44))){
var inst_22368 = (state_22448[(10)]);
var inst_22392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22393 = [inst_22368];
var inst_22394 = (new cljs.core.PersistentVector(null,1,(5),inst_22392,inst_22393,null));
var inst_22395 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22394);
var state_22448__$1 = state_22448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22448__$1,(47),inst_22395);
} else {
if((state_val_22449 === (6))){
var inst_22286 = (state_22448[(19)]);
var inst_22293 = (state_22448[(20)]);
var inst_22292 = cljs.core.seq(inst_22286);
var inst_22293__$1 = cljs.core.first(inst_22292);
var inst_22294 = cljs.core.next(inst_22292);
var inst_22295 = cljs.core.not(inst_22293__$1);
var state_22448__$1 = (function (){var statearr_22491 = state_22448;
(statearr_22491[(20)] = inst_22293__$1);

(statearr_22491[(21)] = inst_22294);

return statearr_22491;
})();
if(inst_22295){
var statearr_22492_22581 = state_22448__$1;
(statearr_22492_22581[(1)] = (8));

} else {
var statearr_22493_22582 = state_22448__$1;
(statearr_22493_22582[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (28))){
var inst_22327 = (state_22448[(14)]);
var inst_22429 = (state_22448[(2)]);
var state_22448__$1 = (function (){var statearr_22494 = state_22448;
(statearr_22494[(22)] = inst_22429);

return statearr_22494;
})();
if(cljs.core.truth_(inst_22327)){
var statearr_22495_22583 = state_22448__$1;
(statearr_22495_22583[(1)] = (55));

} else {
var statearr_22496_22584 = state_22448__$1;
(statearr_22496_22584[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (51))){
var inst_22398 = (state_22448[(23)]);
var inst_22407 = cljs.core.count(inst_22398);
var inst_22408 = fluree.db.query.fql.add_fuel(fuel,inst_22407,max_fuel);
var state_22448__$1 = state_22448;
var statearr_22497_22585 = state_22448__$1;
(statearr_22497_22585[(2)] = inst_22408);

(statearr_22497_22585[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (25))){
var state_22448__$1 = state_22448;
var statearr_22498_22586 = state_22448__$1;
(statearr_22498_22586[(2)] = null);

(statearr_22498_22586[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (34))){
var inst_22377 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22499_22587 = state_22448__$1;
(statearr_22499_22587[(2)] = inst_22377);

(statearr_22499_22587[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (17))){
var inst_22303 = (state_22448[(24)]);
var inst_22321 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22303);
var state_22448__$1 = state_22448;
var statearr_22500_22588 = state_22448__$1;
(statearr_22500_22588[(2)] = inst_22321);

(statearr_22500_22588[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (3))){
var inst_22446 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22448__$1,inst_22446);
} else {
if((state_val_22449 === (12))){
var state_22448__$1 = state_22448;
var statearr_22501_22589 = state_22448__$1;
(statearr_22501_22589[(2)] = false);

(statearr_22501_22589[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (2))){
var _ = (function (){var statearr_22502 = state_22448;
(statearr_22502[(4)] = cljs.core.cons((5),(state_22448[(4)])));

return statearr_22502;
})();
var inst_22282 = reverse_refs_specs;
var inst_22283 = cljs.core.seq(inst_22282);
var inst_22284 = cljs.core.first(inst_22283);
var inst_22285 = cljs.core.next(inst_22283);
var inst_22286 = inst_22282;
var inst_22287 = null;
var state_22448__$1 = (function (){var statearr_22503 = state_22448;
(statearr_22503[(19)] = inst_22286);

(statearr_22503[(25)] = inst_22285);

(statearr_22503[(26)] = inst_22287);

(statearr_22503[(27)] = inst_22284);

return statearr_22503;
})();
var statearr_22504_22590 = state_22448__$1;
(statearr_22504_22590[(2)] = null);

(statearr_22504_22590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (23))){
var inst_22342 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22342)){
var statearr_22505_22591 = state_22448__$1;
(statearr_22505_22591[(1)] = (24));

} else {
var statearr_22506_22592 = state_22448__$1;
(statearr_22506_22592[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (47))){
var inst_22303 = (state_22448[(24)]);
var inst_22398 = (state_22448[(23)]);
var inst_22397 = (state_22448[(2)]);
var inst_22398__$1 = fluree.db.util.async.throw_err(inst_22397);
var inst_22399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22400 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22401 = (new cljs.core.PersistentVector(null,4,(5),inst_22399,inst_22400,null));
var inst_22402 = cljs.core.select_keys(inst_22303,inst_22401);
var inst_22403 = cljs.core.empty_QMARK_(inst_22398__$1);
var state_22448__$1 = (function (){var statearr_22507 = state_22448;
(statearr_22507[(23)] = inst_22398__$1);

(statearr_22507[(28)] = inst_22402);

return statearr_22507;
})();
if(inst_22403){
var statearr_22508_22593 = state_22448__$1;
(statearr_22508_22593[(1)] = (48));

} else {
var statearr_22509_22594 = state_22448__$1;
(statearr_22509_22594[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (35))){
var inst_22362 = (state_22448[(16)]);
var state_22448__$1 = state_22448;
var statearr_22510_22595 = state_22448__$1;
(statearr_22510_22595[(2)] = inst_22362);

(statearr_22510_22595[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (19))){
var inst_22302 = (state_22448[(29)]);
var inst_22324 = (state_22448[(2)]);
var inst_22325 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22324,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22324,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22324,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22324,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22324,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22331 = [subject_id,inst_22302];
var inst_22332 = (new cljs.core.PersistentVector(null,2,(5),inst_22330,inst_22331,null));
var inst_22333 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22332);
var state_22448__$1 = (function (){var statearr_22511 = state_22448;
(statearr_22511[(14)] = inst_22327);

(statearr_22511[(18)] = inst_22326);

(statearr_22511[(7)] = inst_22329);

(statearr_22511[(15)] = inst_22325);

(statearr_22511[(9)] = inst_22328);

return statearr_22511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22448__$1,(20),inst_22333);
} else {
if((state_val_22449 === (57))){
var inst_22287 = (state_22448[(26)]);
var inst_22429 = (state_22448[(22)]);
var inst_22294 = (state_22448[(21)]);
var inst_22437 = (state_22448[(2)]);
var inst_22438 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22287,inst_22437,inst_22429);
var inst_22286 = inst_22294;
var inst_22287__$1 = inst_22438;
var state_22448__$1 = (function (){var statearr_22512 = state_22448;
(statearr_22512[(19)] = inst_22286);

(statearr_22512[(26)] = inst_22287__$1);

return statearr_22512;
})();
var statearr_22513_22596 = state_22448__$1;
(statearr_22513_22596[(2)] = null);

(statearr_22513_22596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (11))){
var inst_22303 = (state_22448[(24)]);
var inst_22308 = inst_22303.cljs$lang$protocol_mask$partition0$;
var inst_22309 = (inst_22308 & (64));
var inst_22310 = inst_22303.cljs$core$ISeq$;
var inst_22311 = (cljs.core.PROTOCOL_SENTINEL === inst_22310);
var inst_22312 = ((inst_22309) || (inst_22311));
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22312)){
var statearr_22515_22597 = state_22448__$1;
(statearr_22515_22597[(1)] = (14));

} else {
var statearr_22516_22598 = state_22448__$1;
(statearr_22516_22598[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (9))){
var inst_22303 = (state_22448[(24)]);
var inst_22293 = (state_22448[(20)]);
var inst_22302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22293,(0),null);
var inst_22303__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22293,(1),null);
var inst_22305 = (inst_22303__$1 == null);
var inst_22306 = cljs.core.not(inst_22305);
var state_22448__$1 = (function (){var statearr_22517 = state_22448;
(statearr_22517[(29)] = inst_22302);

(statearr_22517[(24)] = inst_22303__$1);

return statearr_22517;
})();
if(inst_22306){
var statearr_22518_22599 = state_22448__$1;
(statearr_22518_22599[(1)] = (11));

} else {
var statearr_22519_22600 = state_22448__$1;
(statearr_22519_22600[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (5))){
var _ = (function (){var statearr_22520 = state_22448;
(statearr_22520[(4)] = cljs.core.rest((state_22448[(4)])));

return statearr_22520;
})();
var state_22448__$1 = state_22448;
var ex22514 = (state_22448__$1[(2)]);
var statearr_22521_22601 = state_22448__$1;
(statearr_22521_22601[(5)] = ex22514);


if((ex22514 instanceof Error)){
var statearr_22522_22602 = state_22448__$1;
(statearr_22522_22602[(1)] = (4));

(statearr_22522_22602[(5)] = null);

} else {
throw ex22514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (14))){
var state_22448__$1 = state_22448;
var statearr_22523_22603 = state_22448__$1;
(statearr_22523_22603[(2)] = true);

(statearr_22523_22603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (45))){
var state_22448__$1 = state_22448;
var statearr_22524_22604 = state_22448__$1;
(statearr_22524_22604[(2)] = null);

(statearr_22524_22604[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (53))){
var inst_22398 = (state_22448[(23)]);
var inst_22402 = (state_22448[(28)]);
var inst_22411 = (state_22448[(2)]);
var inst_22412 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22402,inst_22398) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22402,inst_22398));
var state_22448__$1 = (function (){var statearr_22525 = state_22448;
(statearr_22525[(30)] = inst_22411);

return statearr_22525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22448__$1,(54),inst_22412);
} else {
if((state_val_22449 === (26))){
var inst_22338 = (state_22448[(8)]);
var inst_22348 = (state_22448[(2)]);
var inst_22356 = cljs.core.seq(inst_22338);
var inst_22357 = cljs.core.first(inst_22356);
var inst_22358 = cljs.core.next(inst_22356);
var inst_22359 = cljs.core.PersistentVector.EMPTY;
var inst_22360 = inst_22338;
var inst_22361 = (0);
var inst_22362 = inst_22359;
var state_22448__$1 = (function (){var statearr_22526 = state_22448;
(statearr_22526[(17)] = inst_22361);

(statearr_22526[(31)] = inst_22348);

(statearr_22526[(32)] = inst_22357);

(statearr_22526[(16)] = inst_22362);

(statearr_22526[(33)] = inst_22358);

(statearr_22526[(11)] = inst_22360);

return statearr_22526;
})();
var statearr_22527_22605 = state_22448__$1;
(statearr_22527_22605[(2)] = null);

(statearr_22527_22605[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (16))){
var inst_22316 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22528_22606 = state_22448__$1;
(statearr_22528_22606[(2)] = inst_22316);

(statearr_22528_22606[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (38))){
var inst_22361 = (state_22448[(17)]);
var inst_22325 = (state_22448[(15)]);
var inst_22383 = (inst_22361 < inst_22325);
var state_22448__$1 = state_22448;
var statearr_22529_22607 = state_22448__$1;
(statearr_22529_22607[(2)] = inst_22383);

(statearr_22529_22607[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (30))){
var inst_22326 = (state_22448[(18)]);
var state_22448__$1 = state_22448;
if(cljs.core.truth_(inst_22326)){
var statearr_22530_22608 = state_22448__$1;
(statearr_22530_22608[(1)] = (32));

} else {
var statearr_22531_22609 = state_22448__$1;
(statearr_22531_22609[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (10))){
var inst_22441 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22532_22610 = state_22448__$1;
(statearr_22532_22610[(2)] = inst_22441);

(statearr_22532_22610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (18))){
var inst_22303 = (state_22448[(24)]);
var state_22448__$1 = state_22448;
var statearr_22533_22611 = state_22448__$1;
(statearr_22533_22611[(2)] = inst_22303);

(statearr_22533_22611[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (52))){
var state_22448__$1 = state_22448;
var statearr_22534_22612 = state_22448__$1;
(statearr_22534_22612[(2)] = null);

(statearr_22534_22612[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (42))){
var state_22448__$1 = state_22448;
var statearr_22535_22613 = state_22448__$1;
(statearr_22535_22613[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (37))){
var inst_22427 = (state_22448[(2)]);
var state_22448__$1 = state_22448;
var statearr_22537_22614 = state_22448__$1;
(statearr_22537_22614[(2)] = inst_22427);

(statearr_22537_22614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (8))){
var inst_22287 = (state_22448[(26)]);
var state_22448__$1 = state_22448;
var statearr_22538_22615 = state_22448__$1;
(statearr_22538_22615[(2)] = inst_22287);

(statearr_22538_22615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22449 === (49))){
var state_22448__$1 = state_22448;
if(cljs.core.truth_(fuel)){
var statearr_22539_22616 = state_22448__$1;
(statearr_22539_22616[(1)] = (51));

} else {
var statearr_22540_22617 = state_22448__$1;
(statearr_22540_22617[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0 = (function (){
var statearr_22541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22541[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__);

(statearr_22541[(1)] = (1));

return statearr_22541;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1 = (function (state_22448){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22448);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22542){var ex__2417__auto__ = e22542;
var statearr_22543_22618 = state_22448;
(statearr_22543_22618[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22448[(4)]))){
var statearr_22544_22619 = state_22448;
(statearr_22544_22619[(1)] = cljs.core.first((state_22448[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22620 = state_22448;
state_22448 = G__22620;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__ = function(state_22448){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1.call(this,state_22448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22545 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22545[(6)] = c__2436__auto__);

return statearr_22545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__22621 = select_spec;
var map__22621__$1 = (((((!((map__22621 == null))))?(((((map__22621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22621):map__22621);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22621__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22621__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22704){
var state_val_22705 = (state_22704[(1)]);
if((state_val_22705 === (7))){
var state_22704__$1 = state_22704;
var statearr_22706_22758 = state_22704__$1;
(statearr_22706_22758[(2)] = false);

(statearr_22706_22758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (20))){
var inst_22660 = (state_22704[(7)]);
var state_22704__$1 = state_22704;
if(cljs.core.truth_(inst_22660)){
var statearr_22707_22759 = state_22704__$1;
(statearr_22707_22759[(1)] = (22));

} else {
var statearr_22708_22760 = state_22704__$1;
(statearr_22708_22760[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (27))){
var inst_22683 = (state_22704[(8)]);
var inst_22689 = (state_22704[(2)]);
var state_22704__$1 = (function (){var statearr_22709 = state_22704;
(statearr_22709[(9)] = inst_22689);

return statearr_22709;
})();
if(cljs.core.truth_(inst_22683)){
var statearr_22710_22761 = state_22704__$1;
(statearr_22710_22761[(1)] = (28));

} else {
var statearr_22711_22762 = state_22704__$1;
(statearr_22711_22762[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (1))){
var state_22704__$1 = state_22704;
var statearr_22712_22763 = state_22704__$1;
(statearr_22712_22763[(2)] = null);

(statearr_22712_22763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (24))){
var inst_22681 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
var statearr_22713_22764 = state_22704__$1;
(statearr_22713_22764[(2)] = inst_22681);

(statearr_22713_22764[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (4))){
var inst_22623 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
var statearr_22714_22765 = state_22704__$1;
(statearr_22714_22765[(2)] = inst_22623);

(statearr_22714_22765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (15))){
var inst_22667 = (state_22704[(2)]);
var inst_22668 = fluree.db.util.async.throw_err(inst_22667);
var state_22704__$1 = (function (){var statearr_22715 = state_22704;
(statearr_22715[(10)] = inst_22668);

return statearr_22715;
})();
if(cljs.core.truth_(fuel)){
var statearr_22716_22766 = state_22704__$1;
(statearr_22716_22766[(1)] = (16));

} else {
var statearr_22717_22767 = state_22704__$1;
(statearr_22717_22767[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (21))){
var inst_22653 = (state_22704[(11)]);
var inst_22683 = (state_22704[(2)]);
var state_22704__$1 = (function (){var statearr_22718 = state_22704;
(statearr_22718[(8)] = inst_22683);

return statearr_22718;
})();
if(cljs.core.truth_(inst_22653)){
var statearr_22719_22768 = state_22704__$1;
(statearr_22719_22768[(1)] = (25));

} else {
var statearr_22720_22769 = state_22704__$1;
(statearr_22720_22769[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (31))){
var inst_22689 = (state_22704[(9)]);
var inst_22654 = (state_22704[(12)]);
var inst_22695 = (state_22704[(2)]);
var inst_22696 = fluree.db.util.async.throw_err(inst_22695);
var inst_22697 = (inst_22689.cljs$core$IFn$_invoke$arity$3 ? inst_22689.cljs$core$IFn$_invoke$arity$3(acc,inst_22654,inst_22696) : inst_22689.call(null,acc,inst_22654,inst_22696));
var state_22704__$1 = state_22704;
var statearr_22721_22770 = state_22704__$1;
(statearr_22721_22770[(2)] = inst_22697);

(statearr_22721_22770[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (13))){
var inst_22631 = (state_22704[(13)]);
var state_22704__$1 = state_22704;
var statearr_22722_22771 = state_22704__$1;
(statearr_22722_22771[(2)] = inst_22631);

(statearr_22722_22771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (22))){
var inst_22660 = (state_22704[(7)]);
var state_22704__$1 = state_22704;
var statearr_22723_22772 = state_22704__$1;
(statearr_22723_22772[(2)] = inst_22660);

(statearr_22723_22772[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (29))){
var inst_22674 = (state_22704[(14)]);
var inst_22692 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_22693 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22692,inst_22674) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22692,inst_22674));
var state_22704__$1 = state_22704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22704__$1,(31),inst_22693);
} else {
if((state_val_22705 === (6))){
var inst_22631 = (state_22704[(13)]);
var inst_22636 = inst_22631.cljs$lang$protocol_mask$partition0$;
var inst_22637 = (inst_22636 & (64));
var inst_22638 = inst_22631.cljs$core$ISeq$;
var inst_22639 = (cljs.core.PROTOCOL_SENTINEL === inst_22638);
var inst_22640 = ((inst_22637) || (inst_22639));
var state_22704__$1 = state_22704;
if(cljs.core.truth_(inst_22640)){
var statearr_22724_22773 = state_22704__$1;
(statearr_22724_22773[(1)] = (9));

} else {
var statearr_22725_22774 = state_22704__$1;
(statearr_22725_22774[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (28))){
var state_22704__$1 = state_22704;
var statearr_22726_22775 = state_22704__$1;
(statearr_22726_22775[(2)] = acc);

(statearr_22726_22775[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (25))){
var inst_22655 = (state_22704[(15)]);
var inst_22659 = (state_22704[(16)]);
var inst_22674 = (state_22704[(14)]);
var inst_22656 = (state_22704[(17)]);
var inst_22652 = (state_22704[(18)]);
var inst_22683 = (state_22704[(8)]);
var inst_22653 = (state_22704[(11)]);
var inst_22654 = (state_22704[(12)]);
var inst_22657 = (state_22704[(19)]);
var inst_22660 = (state_22704[(7)]);
var inst_22658 = (state_22704[(20)]);
var inst_22630 = (state_22704[(21)]);
var inst_22685 = (function (){var recur_seen = inst_22656;
var recur_subject = inst_22630;
var sub_flakes = inst_22674;
var seen_QMARK_ = inst_22659;
var multi_QMARK_ = inst_22653;
var limit = inst_22658;
var map__22629 = inst_22652;
var recur_depth = inst_22657;
var as = inst_22654;
var max_depth_QMARK_ = inst_22660;
var recur = inst_22655;
var stop_QMARK_ = inst_22683;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_22704__$1 = state_22704;
var statearr_22727_22776 = state_22704__$1;
(statearr_22727_22776[(2)] = inst_22685);

(statearr_22727_22776[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (17))){
var inst_22668 = (state_22704[(10)]);
var state_22704__$1 = state_22704;
var statearr_22728_22777 = state_22704__$1;
(statearr_22728_22777[(2)] = inst_22668);

(statearr_22728_22777[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (3))){
var inst_22702 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22704__$1,inst_22702);
} else {
if((state_val_22705 === (12))){
var inst_22631 = (state_22704[(13)]);
var inst_22649 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22631);
var state_22704__$1 = state_22704;
var statearr_22729_22778 = state_22704__$1;
(statearr_22729_22778[(2)] = inst_22649);

(statearr_22729_22778[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (2))){
var inst_22631 = (state_22704[(13)]);
var _ = (function (){var statearr_22730 = state_22704;
(statearr_22730[(4)] = cljs.core.cons((5),(state_22704[(4)])));

return statearr_22730;
})();
var inst_22630 = flake.o;
var inst_22631__$1 = select_spec;
var inst_22633 = (inst_22631__$1 == null);
var inst_22634 = cljs.core.not(inst_22633);
var state_22704__$1 = (function (){var statearr_22731 = state_22704;
(statearr_22731[(13)] = inst_22631__$1);

(statearr_22731[(21)] = inst_22630);

return statearr_22731;
})();
if(inst_22634){
var statearr_22732_22779 = state_22704__$1;
(statearr_22732_22779[(1)] = (6));

} else {
var statearr_22733_22780 = state_22704__$1;
(statearr_22733_22780[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (23))){
var inst_22674 = (state_22704[(14)]);
var inst_22679 = cljs.core.empty_QMARK_(inst_22674);
var state_22704__$1 = state_22704;
var statearr_22734_22781 = state_22704__$1;
(statearr_22734_22781[(2)] = inst_22679);

(statearr_22734_22781[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (19))){
var inst_22659 = (state_22704[(16)]);
var state_22704__$1 = state_22704;
var statearr_22735_22782 = state_22704__$1;
(statearr_22735_22782[(2)] = inst_22659);

(statearr_22735_22782[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (11))){
var inst_22644 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
var statearr_22737_22783 = state_22704__$1;
(statearr_22737_22783[(2)] = inst_22644);

(statearr_22737_22783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (9))){
var state_22704__$1 = state_22704;
var statearr_22738_22784 = state_22704__$1;
(statearr_22738_22784[(2)] = true);

(statearr_22738_22784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (5))){
var _ = (function (){var statearr_22739 = state_22704;
(statearr_22739[(4)] = cljs.core.rest((state_22704[(4)])));

return statearr_22739;
})();
var state_22704__$1 = state_22704;
var ex22736 = (state_22704__$1[(2)]);
var statearr_22740_22785 = state_22704__$1;
(statearr_22740_22785[(5)] = ex22736);


if((ex22736 instanceof Error)){
var statearr_22741_22786 = state_22704__$1;
(statearr_22741_22786[(1)] = (4));

(statearr_22741_22786[(5)] = null);

} else {
throw ex22736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (14))){
var inst_22655 = (state_22704[(15)]);
var inst_22656 = (state_22704[(17)]);
var inst_22652 = (state_22704[(18)]);
var inst_22657 = (state_22704[(19)]);
var inst_22630 = (state_22704[(21)]);
var inst_22652__$1 = (state_22704[(2)]);
var inst_22653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22654 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22655__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_22656__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22657__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22652__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22659 = cljs.core.contains_QMARK_(inst_22656__$1,inst_22630);
var inst_22660 = (inst_22657__$1 > inst_22655__$1);
var inst_22662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22663 = [inst_22630];
var inst_22664 = (new cljs.core.PersistentVector(null,1,(5),inst_22662,inst_22663,null));
var inst_22665 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22664);
var state_22704__$1 = (function (){var statearr_22742 = state_22704;
(statearr_22742[(15)] = inst_22655__$1);

(statearr_22742[(16)] = inst_22659);

(statearr_22742[(17)] = inst_22656__$1);

(statearr_22742[(18)] = inst_22652__$1);

(statearr_22742[(11)] = inst_22653);

(statearr_22742[(12)] = inst_22654);

(statearr_22742[(19)] = inst_22657__$1);

(statearr_22742[(7)] = inst_22660);

(statearr_22742[(20)] = inst_22658);

return statearr_22742;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22704__$1,(15),inst_22665);
} else {
if((state_val_22705 === (26))){
var inst_22655 = (state_22704[(15)]);
var inst_22659 = (state_22704[(16)]);
var inst_22674 = (state_22704[(14)]);
var inst_22656 = (state_22704[(17)]);
var inst_22652 = (state_22704[(18)]);
var inst_22683 = (state_22704[(8)]);
var inst_22653 = (state_22704[(11)]);
var inst_22654 = (state_22704[(12)]);
var inst_22657 = (state_22704[(19)]);
var inst_22660 = (state_22704[(7)]);
var inst_22658 = (state_22704[(20)]);
var inst_22630 = (state_22704[(21)]);
var inst_22687 = (function (){var recur_seen = inst_22656;
var recur_subject = inst_22630;
var sub_flakes = inst_22674;
var seen_QMARK_ = inst_22659;
var multi_QMARK_ = inst_22653;
var limit = inst_22658;
var map__22629 = inst_22652;
var recur_depth = inst_22657;
var as = inst_22654;
var max_depth_QMARK_ = inst_22660;
var recur = inst_22655;
var stop_QMARK_ = inst_22683;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_22704__$1 = state_22704;
var statearr_22743_22787 = state_22704__$1;
(statearr_22743_22787[(2)] = inst_22687);

(statearr_22743_22787[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (16))){
var inst_22668 = (state_22704[(10)]);
var inst_22670 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_22671 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22670,inst_22668);
var state_22704__$1 = state_22704;
var statearr_22744_22788 = state_22704__$1;
(statearr_22744_22788[(2)] = inst_22671);

(statearr_22744_22788[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (30))){
var inst_22699 = (state_22704[(2)]);
var _ = (function (){var statearr_22745 = state_22704;
(statearr_22745[(4)] = cljs.core.rest((state_22704[(4)])));

return statearr_22745;
})();
var state_22704__$1 = state_22704;
var statearr_22746_22789 = state_22704__$1;
(statearr_22746_22789[(2)] = inst_22699);

(statearr_22746_22789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (10))){
var state_22704__$1 = state_22704;
var statearr_22747_22790 = state_22704__$1;
(statearr_22747_22790[(2)] = false);

(statearr_22747_22790[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (18))){
var inst_22659 = (state_22704[(16)]);
var inst_22674 = (state_22704[(2)]);
var state_22704__$1 = (function (){var statearr_22748 = state_22704;
(statearr_22748[(14)] = inst_22674);

return statearr_22748;
})();
if(cljs.core.truth_(inst_22659)){
var statearr_22749_22791 = state_22704__$1;
(statearr_22749_22791[(1)] = (19));

} else {
var statearr_22750_22792 = state_22704__$1;
(statearr_22750_22792[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22705 === (8))){
var inst_22647 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
if(cljs.core.truth_(inst_22647)){
var statearr_22751_22793 = state_22704__$1;
(statearr_22751_22793[(1)] = (12));

} else {
var statearr_22752_22794 = state_22704__$1;
(statearr_22752_22794[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0 = (function (){
var statearr_22753 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22753[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__);

(statearr_22753[(1)] = (1));

return statearr_22753;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1 = (function (state_22704){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22704);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e22754){var ex__2417__auto__ = e22754;
var statearr_22755_22795 = state_22704;
(statearr_22755_22795[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22704[(4)]))){
var statearr_22756_22796 = state_22704;
(statearr_22756_22796[(1)] = cljs.core.first((state_22704[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22797 = state_22704;
state_22704 = G__22797;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__ = function(state_22704){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1.call(this,state_22704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_22757 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_22757[(6)] = c__2436__auto__);

return statearr_22757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_22975){
var state_val_22976 = (state_22975[(1)]);
if((state_val_22976 === (7))){
var state_22975__$1 = state_22975;
var statearr_22977_23062 = state_22975__$1;
(statearr_22977_23062[(2)] = null);

(statearr_22977_23062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (20))){
var inst_22836 = cljs.core.PersistentHashMap.EMPTY;
var state_22975__$1 = state_22975;
var statearr_22978_23063 = state_22975__$1;
(statearr_22978_23063[(2)] = inst_22836);

(statearr_22978_23063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (27))){
var inst_22838 = (state_22975[(7)]);
var inst_22824 = (state_22975[(8)]);
var inst_22818 = (state_22975[(9)]);
var inst_22854 = (state_22975[(10)]);
var inst_22954 = (state_22975[(2)]);
var inst_22955 = (function (){var top_level_subject = inst_22818;
var select_spec = inst_22824;
var base_acc = inst_22838;
var acc_PLUS_refs = inst_22854;
var result = inst_22954;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_22956 = cljs.core.PersistentVector.EMPTY;
var inst_22957 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22824);
var inst_22958 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_22957);
var inst_22959 = cljs.core.vals(inst_22958);
var inst_22960 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22824);
var inst_22961 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_22960);
var inst_22962 = cljs.core.vals(inst_22961);
var inst_22963 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_22959,inst_22962);
var inst_22964 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22955,inst_22956,inst_22963);
var inst_22966 = (function (){var top_level_subject = inst_22818;
var select_spec = inst_22824;
var base_acc = inst_22838;
var acc_PLUS_refs = inst_22854;
var result = inst_22954;
var sort_preds = inst_22964;
return (function (acc,p__22965){
var vec__22979 = p__22965;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22979,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22979,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22979,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22979,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_22967 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22966,inst_22954,inst_22964);
var state_22975__$1 = state_22975;
var statearr_22982_23064 = state_22975__$1;
(statearr_22982_23064[(2)] = inst_22967);

(statearr_22982_23064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (1))){
var state_22975__$1 = state_22975;
var statearr_22983_23065 = state_22975__$1;
(statearr_22983_23065[(2)] = null);

(statearr_22983_23065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (24))){
var inst_22854 = (state_22975[(10)]);
var inst_22854__$1 = (state_22975[(2)]);
var inst_22855 = flakes;
var inst_22856 = cljs.core.PersistentHashMap.EMPTY;
var inst_22857 = inst_22855;
var inst_22858 = inst_22854__$1;
var inst_22859 = inst_22856;
var state_22975__$1 = (function (){var statearr_22984 = state_22975;
(statearr_22984[(11)] = inst_22859);

(statearr_22984[(12)] = inst_22858);

(statearr_22984[(13)] = inst_22857);

(statearr_22984[(10)] = inst_22854__$1);

return statearr_22984;
})();
var statearr_22985_23066 = state_22975__$1;
(statearr_22985_23066[(2)] = null);

(statearr_22985_23066[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (39))){
var inst_22824 = (state_22975[(8)]);
var inst_22873 = (state_22975[(14)]);
var inst_22867 = (state_22975[(15)]);
var inst_22858 = (state_22975[(12)]);
var inst_22902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22903 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_22858,inst_22824,inst_22867,inst_22873,false);
var state_22975__$1 = (function (){var statearr_22986 = state_22975;
(statearr_22986[(16)] = inst_22902);

return statearr_22986;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22975__$1,(42),inst_22903);
} else {
if((state_val_22976 === (46))){
var inst_22859 = (state_22975[(11)]);
var inst_22867 = (state_22975[(15)]);
var inst_22857 = (state_22975[(13)]);
var inst_22920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22921 = ["_id"];
var inst_22922 = inst_22867.s;
var inst_22923 = [inst_22922];
var inst_22924 = cljs.core.PersistentHashMap.fromArrays(inst_22921,inst_22923);
var inst_22925 = cljs.core.rest(inst_22857);
var inst_22926 = [inst_22924,inst_22925,inst_22859];
var inst_22927 = (new cljs.core.PersistentVector(null,3,(5),inst_22920,inst_22926,null));
var state_22975__$1 = state_22975;
var statearr_22987_23067 = state_22975__$1;
(statearr_22987_23067[(2)] = inst_22927);

(statearr_22987_23067[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (4))){
var inst_22798 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_22988_23068 = state_22975__$1;
(statearr_22988_23068[(2)] = inst_22798);

(statearr_22988_23068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (15))){
var inst_22824 = (state_22975[(8)]);
var inst_22825 = (state_22975[(17)]);
var inst_22824__$1 = (state_22975[(2)]);
var inst_22825__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22824__$1);
var state_22975__$1 = (function (){var statearr_22989 = state_22975;
(statearr_22989[(8)] = inst_22824__$1);

(statearr_22989[(17)] = inst_22825__$1);

return statearr_22989;
})();
if(cljs.core.truth_(inst_22825__$1)){
var statearr_22990_23069 = state_22975__$1;
(statearr_22990_23069[(1)] = (16));

} else {
var statearr_22991_23070 = state_22975__$1;
(statearr_22991_23070[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (48))){
var inst_22938 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_22992_23071 = state_22975__$1;
(statearr_22992_23071[(2)] = inst_22938);

(statearr_22992_23071[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (50))){
var state_22975__$1 = state_22975;
var statearr_22993_23072 = state_22975__$1;
(statearr_22993_23072[(2)] = null);

(statearr_22993_23072[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (21))){
var inst_22824 = (state_22975[(8)]);
var inst_22838 = (state_22975[(2)]);
var inst_22839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22840 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_22841 = (new cljs.core.PersistentVector(null,2,(5),inst_22839,inst_22840,null));
var inst_22842 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22824,inst_22841);
var state_22975__$1 = (function (){var statearr_22994 = state_22975;
(statearr_22994[(7)] = inst_22838);

return statearr_22994;
})();
if(cljs.core.truth_(inst_22842)){
var statearr_22995_23073 = state_22975__$1;
(statearr_22995_23073[(1)] = (22));

} else {
var statearr_22996_23074 = state_22975__$1;
(statearr_22996_23074[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (31))){
var inst_22867 = (state_22975[(15)]);
var inst_22858 = (state_22975[(12)]);
var inst_22872 = (state_22975[(18)]);
var inst_22876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22877 = fluree.db.query.fql.flake__GT_recur(db,inst_22867,inst_22872,inst_22858,fuel,max_fuel,cache);
var state_22975__$1 = (function (){var statearr_22997 = state_22975;
(statearr_22997[(19)] = inst_22876);

return statearr_22997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22975__$1,(34),inst_22877);
} else {
if((state_val_22976 === (32))){
var inst_22872 = (state_22975[(18)]);
var state_22975__$1 = state_22975;
if(cljs.core.truth_(inst_22872)){
var statearr_22998_23075 = state_22975__$1;
(statearr_22998_23075[(1)] = (35));

} else {
var statearr_22999_23076 = state_22975__$1;
(statearr_22999_23076[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (40))){
var inst_22824 = (state_22975[(8)]);
var inst_22912 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22824);
var inst_22913 = cljs.core.empty_QMARK_(inst_22912);
var state_22975__$1 = state_22975;
if(inst_22913){
var statearr_23000_23077 = state_22975__$1;
(statearr_23000_23077[(1)] = (43));

} else {
var statearr_23001_23078 = state_22975__$1;
(statearr_23001_23078[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (33))){
var inst_22867 = (state_22975[(15)]);
var inst_22944 = (state_22975[(2)]);
var inst_22945 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22944,(0),null);
var inst_22946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22944,(1),null);
var inst_22947 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22944,(2),null);
var inst_22948 = inst_22867.s;
var inst_22949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22945,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22948);
var inst_22857 = inst_22946;
var inst_22858 = inst_22949;
var inst_22859 = inst_22947;
var state_22975__$1 = (function (){var statearr_23002 = state_22975;
(statearr_23002[(11)] = inst_22859);

(statearr_23002[(12)] = inst_22858);

(statearr_23002[(13)] = inst_22857);

return statearr_23002;
})();
var statearr_23003_23079 = state_22975__$1;
(statearr_23003_23079[(2)] = null);

(statearr_23003_23079[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (13))){
var inst_22818 = (state_22975[(9)]);
var inst_22821 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_22818);
var state_22975__$1 = state_22975;
var statearr_23004_23080 = state_22975__$1;
(statearr_23004_23080[(2)] = inst_22821);

(statearr_23004_23080[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (22))){
var inst_22824 = (state_22975[(8)]);
var inst_22844 = cljs.core.first(flakes);
var inst_22845 = fluree.db.query.fql.s(inst_22844);
var inst_22846 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_22824);
var inst_22847 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_22845,inst_22846);
var state_22975__$1 = state_22975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22975__$1,(25),inst_22847);
} else {
if((state_val_22976 === (36))){
var inst_22824 = (state_22975[(8)]);
var inst_22900 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22824);
var state_22975__$1 = state_22975;
if(cljs.core.truth_(inst_22900)){
var statearr_23005_23081 = state_22975__$1;
(statearr_23005_23081[(1)] = (39));

} else {
var statearr_23006_23082 = state_22975__$1;
(statearr_23006_23082[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (41))){
var inst_22940 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_23007_23083 = state_22975__$1;
(statearr_23007_23083[(2)] = inst_22940);

(statearr_23007_23083[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (43))){
var inst_22824 = (state_22975[(8)]);
var inst_22915 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22824);
var state_22975__$1 = state_22975;
var statearr_23008_23084 = state_22975__$1;
(statearr_23008_23084[(2)] = inst_22915);

(statearr_23008_23084[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (29))){
var inst_22824 = (state_22975[(8)]);
var inst_22867 = (state_22975[(15)]);
var inst_22857 = (state_22975[(13)]);
var inst_22872 = (state_22975[(18)]);
var inst_22867__$1 = cljs.core.first(inst_22857);
var inst_22868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22869 = inst_22867__$1.p;
var inst_22870 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_22869];
var inst_22871 = (new cljs.core.PersistentVector(null,3,(5),inst_22868,inst_22870,null));
var inst_22872__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22824,inst_22871);
var inst_22873 = fluree.db.query.fql.component_follow_QMARK_(inst_22872__$1,inst_22824);
var inst_22874 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_22872__$1);
var state_22975__$1 = (function (){var statearr_23009 = state_22975;
(statearr_23009[(14)] = inst_22873);

(statearr_23009[(15)] = inst_22867__$1);

(statearr_23009[(18)] = inst_22872__$1);

return statearr_23009;
})();
if(cljs.core.truth_(inst_22874)){
var statearr_23010_23085 = state_22975__$1;
(statearr_23010_23085[(1)] = (31));

} else {
var statearr_23011_23086 = state_22975__$1;
(statearr_23011_23086[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (44))){
var state_22975__$1 = state_22975;
var statearr_23012_23087 = state_22975__$1;
(statearr_23012_23087[(2)] = false);

(statearr_23012_23087[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (6))){
var state_22975__$1 = state_22975;
var statearr_23013_23088 = state_22975__$1;
(statearr_23013_23088[(2)] = null);

(statearr_23013_23088[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (28))){
var inst_22858 = (state_22975[(12)]);
var state_22975__$1 = state_22975;
var statearr_23014_23089 = state_22975__$1;
(statearr_23014_23089[(2)] = inst_22858);

(statearr_23014_23089[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (51))){
var inst_22936 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_23015_23090 = state_22975__$1;
(statearr_23015_23090[(2)] = inst_22936);

(statearr_23015_23090[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (25))){
var inst_22838 = (state_22975[(7)]);
var inst_22849 = (state_22975[(2)]);
var inst_22850 = fluree.db.util.async.throw_err(inst_22849);
var inst_22851 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_22838,inst_22850], 0));
var state_22975__$1 = state_22975;
var statearr_23016_23091 = state_22975__$1;
(statearr_23016_23091[(2)] = inst_22851);

(statearr_23016_23091[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (34))){
var inst_22859 = (state_22975[(11)]);
var inst_22876 = (state_22975[(19)]);
var inst_22857 = (state_22975[(13)]);
var inst_22879 = (state_22975[(2)]);
var inst_22880 = fluree.db.util.async.throw_err(inst_22879);
var inst_22881 = cljs.core.rest(inst_22857);
var inst_22882 = [inst_22880,inst_22881,inst_22859];
var inst_22883 = (new cljs.core.PersistentVector(null,3,(5),inst_22876,inst_22882,null));
var state_22975__$1 = state_22975;
var statearr_23017_23092 = state_22975__$1;
(statearr_23017_23092[(2)] = inst_22883);

(statearr_23017_23092[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (17))){
var inst_22824 = (state_22975[(8)]);
var inst_22828 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22824);
var state_22975__$1 = state_22975;
var statearr_23019_23093 = state_22975__$1;
(statearr_23019_23093[(2)] = inst_22828);

(statearr_23019_23093[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (3))){
var inst_22973 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22975__$1,inst_22973);
} else {
if((state_val_22976 === (12))){
var _ = (function (){var statearr_23020 = state_22975;
(statearr_23020[(4)] = cljs.core.rest((state_22975[(4)])));

return statearr_23020;
})();
var state_22975__$1 = state_22975;
var ex23018 = (state_22975__$1[(2)]);
var statearr_23021_23094 = state_22975__$1;
(statearr_23021_23094[(5)] = ex23018);


var statearr_23022_23095 = state_22975__$1;
(statearr_23022_23095[(1)] = (11));

(statearr_23022_23095[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (2))){
var _ = (function (){var statearr_23023 = state_22975;
(statearr_23023[(4)] = cljs.core.cons((5),(state_22975[(4)])));

return statearr_23023;
})();
var inst_22804 = cljs.core.not_empty(flakes);
var state_22975__$1 = state_22975;
if(cljs.core.truth_(inst_22804)){
var statearr_23024_23096 = state_22975__$1;
(statearr_23024_23096[(1)] = (6));

} else {
var statearr_23025_23097 = state_22975__$1;
(statearr_23025_23097[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (23))){
var inst_22838 = (state_22975[(7)]);
var state_22975__$1 = state_22975;
var statearr_23026_23098 = state_22975__$1;
(statearr_23026_23098[(2)] = inst_22838);

(statearr_23026_23098[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (47))){
var state_22975__$1 = state_22975;
var statearr_23027_23099 = state_22975__$1;
(statearr_23027_23099[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (35))){
var inst_22859 = (state_22975[(11)]);
var inst_22873 = (state_22975[(14)]);
var inst_22867 = (state_22975[(15)]);
var inst_22858 = (state_22975[(12)]);
var inst_22872 = (state_22975[(18)]);
var inst_22889 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_22858,inst_22872,inst_22867,inst_22873,false,inst_22859);
var state_22975__$1 = state_22975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22975__$1,(38),inst_22889);
} else {
if((state_val_22976 === (19))){
var inst_22818 = (state_22975[(9)]);
var inst_22832 = ["_id"];
var inst_22833 = [inst_22818];
var inst_22834 = cljs.core.PersistentHashMap.fromArrays(inst_22832,inst_22833);
var state_22975__$1 = state_22975;
var statearr_23029_23100 = state_22975__$1;
(statearr_23029_23100[(2)] = inst_22834);

(statearr_23029_23100[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (11))){
var inst_22806 = (state_22975[(2)]);
var inst_22807 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_22806], 0));
var inst_22808 = (function(){throw inst_22806})();
var state_22975__$1 = (function (){var statearr_23031 = state_22975;
(statearr_23031[(20)] = inst_22807);

return statearr_23031;
})();
var statearr_23032_23101 = state_22975__$1;
(statearr_23032_23101[(2)] = inst_22808);

(statearr_23032_23101[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (9))){
var _ = (function (){var statearr_23033 = state_22975;
(statearr_23033[(4)] = cljs.core.cons((12),(state_22975[(4)])));

return statearr_23033;
})();
var inst_22814 = cljs.core.first(flakes);
var inst_22815 = fluree.db.query.fql.s(inst_22814);
var ___$1 = (function (){var statearr_23034 = state_22975;
(statearr_23034[(4)] = cljs.core.rest((state_22975[(4)])));

return statearr_23034;
})();
var state_22975__$1 = state_22975;
var statearr_23035_23102 = state_22975__$1;
(statearr_23035_23102[(2)] = inst_22815);

(statearr_23035_23102[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (5))){
var _ = (function (){var statearr_23036 = state_22975;
(statearr_23036[(4)] = cljs.core.rest((state_22975[(4)])));

return statearr_23036;
})();
var state_22975__$1 = state_22975;
var ex23030 = (state_22975__$1[(2)]);
var statearr_23037_23103 = state_22975__$1;
(statearr_23037_23103[(5)] = ex23030);


if((ex23030 instanceof Error)){
var statearr_23038_23104 = state_22975__$1;
(statearr_23038_23104[(1)] = (4));

(statearr_23038_23104[(5)] = null);

} else {
throw ex23030;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (14))){
var state_22975__$1 = state_22975;
var statearr_23039_23105 = state_22975__$1;
(statearr_23039_23105[(2)] = base_select_spec);

(statearr_23039_23105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (45))){
var inst_22918 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
if(cljs.core.truth_(inst_22918)){
var statearr_23040_23106 = state_22975__$1;
(statearr_23040_23106[(1)] = (46));

} else {
var statearr_23041_23107 = state_22975__$1;
(statearr_23041_23107[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (26))){
var inst_22857 = (state_22975[(13)]);
var inst_22861 = cljs.core.empty_QMARK_(inst_22857);
var state_22975__$1 = state_22975;
if(inst_22861){
var statearr_23042_23108 = state_22975__$1;
(statearr_23042_23108[(1)] = (28));

} else {
var statearr_23043_23109 = state_22975__$1;
(statearr_23043_23109[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (16))){
var inst_22825 = (state_22975[(17)]);
var state_22975__$1 = state_22975;
var statearr_23044_23110 = state_22975__$1;
(statearr_23044_23110[(2)] = inst_22825);

(statearr_23044_23110[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (38))){
var inst_22857 = (state_22975[(13)]);
var inst_22891 = (state_22975[(2)]);
var inst_22892 = fluree.db.util.async.throw_err(inst_22891);
var inst_22893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22892,(0),null);
var inst_22894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22892,(1),null);
var inst_22895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22896 = cljs.core.rest(inst_22857);
var inst_22897 = [inst_22893,inst_22896,inst_22894];
var inst_22898 = (new cljs.core.PersistentVector(null,3,(5),inst_22895,inst_22897,null));
var state_22975__$1 = state_22975;
var statearr_23045_23111 = state_22975__$1;
(statearr_23045_23111[(2)] = inst_22898);

(statearr_23045_23111[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (30))){
var inst_22952 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_23046_23112 = state_22975__$1;
(statearr_23046_23112[(2)] = inst_22952);

(statearr_23046_23112[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (10))){
var inst_22818 = (state_22975[(2)]);
var inst_22819 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_22975__$1 = (function (){var statearr_23047 = state_22975;
(statearr_23047[(9)] = inst_22818);

return statearr_23047;
})();
if(cljs.core.truth_(inst_22819)){
var statearr_23048_23113 = state_22975__$1;
(statearr_23048_23113[(1)] = (13));

} else {
var statearr_23049_23114 = state_22975__$1;
(statearr_23049_23114[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (18))){
var inst_22830 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
if(cljs.core.truth_(inst_22830)){
var statearr_23050_23115 = state_22975__$1;
(statearr_23050_23115[(1)] = (19));

} else {
var statearr_23051_23116 = state_22975__$1;
(statearr_23051_23116[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (42))){
var inst_22859 = (state_22975[(11)]);
var inst_22902 = (state_22975[(16)]);
var inst_22857 = (state_22975[(13)]);
var inst_22905 = (state_22975[(2)]);
var inst_22906 = fluree.db.util.async.throw_err(inst_22905);
var inst_22907 = cljs.core.first(inst_22906);
var inst_22908 = cljs.core.rest(inst_22857);
var inst_22909 = [inst_22907,inst_22908,inst_22859];
var inst_22910 = (new cljs.core.PersistentVector(null,3,(5),inst_22902,inst_22909,null));
var state_22975__$1 = state_22975;
var statearr_23052_23117 = state_22975__$1;
(statearr_23052_23117[(2)] = inst_22910);

(statearr_23052_23117[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (37))){
var inst_22942 = (state_22975[(2)]);
var state_22975__$1 = state_22975;
var statearr_23053_23118 = state_22975__$1;
(statearr_23053_23118[(2)] = inst_22942);

(statearr_23053_23118[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (8))){
var inst_22970 = (state_22975[(2)]);
var _ = (function (){var statearr_23054 = state_22975;
(statearr_23054[(4)] = cljs.core.rest((state_22975[(4)])));

return statearr_23054;
})();
var state_22975__$1 = state_22975;
var statearr_23055_23119 = state_22975__$1;
(statearr_23055_23119[(2)] = inst_22970);

(statearr_23055_23119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22976 === (49))){
var inst_22859 = (state_22975[(11)]);
var inst_22858 = (state_22975[(12)]);
var inst_22857 = (state_22975[(13)]);
var inst_22930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22931 = cljs.core.rest(inst_22857);
var inst_22932 = [inst_22858,inst_22931,inst_22859];
var inst_22933 = (new cljs.core.PersistentVector(null,3,(5),inst_22930,inst_22932,null));
var state_22975__$1 = state_22975;
var statearr_23056_23120 = state_22975__$1;
(statearr_23056_23120[(2)] = inst_22933);

(statearr_23056_23120[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0 = (function (){
var statearr_23057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23057[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__);

(statearr_23057[(1)] = (1));

return statearr_23057;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1 = (function (state_22975){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_22975);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23058){var ex__2417__auto__ = e23058;
var statearr_23059_23121 = state_22975;
(statearr_23059_23121[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_22975[(4)]))){
var statearr_23060_23122 = state_22975;
(statearr_23060_23122[(1)] = cljs.core.first((state_22975[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23123 = state_22975;
state_22975 = G__23123;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__ = function(state_22975){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1.call(this,state_22975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23061 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23061[(6)] = c__2436__auto__);

return statearr_23061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23126 = arguments.length;
switch (G__23126) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23168){
var state_val_23169 = (state_23168[(1)]);
if((state_val_23169 === (7))){
var inst_23134 = (state_23168[(7)]);
var state_23168__$1 = state_23168;
var statearr_23170_23200 = state_23168__$1;
(statearr_23170_23200[(2)] = inst_23134);

(statearr_23170_23200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (1))){
var state_23168__$1 = state_23168;
var statearr_23171_23201 = state_23168__$1;
(statearr_23171_23201[(2)] = null);

(statearr_23171_23201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (4))){
var inst_23127 = (state_23168[(2)]);
var state_23168__$1 = state_23168;
var statearr_23172_23202 = state_23168__$1;
(statearr_23172_23202[(2)] = inst_23127);

(statearr_23172_23202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (15))){
var inst_23162 = (state_23168[(2)]);
var inst_23163 = fluree.db.util.async.throw_err(inst_23162);
var _ = (function (){var statearr_23173 = state_23168;
(statearr_23173[(4)] = cljs.core.rest((state_23168[(4)])));

return statearr_23173;
})();
var state_23168__$1 = state_23168;
var statearr_23174_23203 = state_23168__$1;
(statearr_23174_23203[(2)] = inst_23163);

(statearr_23174_23203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (13))){
var inst_23146 = (state_23168[(8)]);
var state_23168__$1 = state_23168;
var statearr_23175_23204 = state_23168__$1;
(statearr_23175_23204[(2)] = inst_23146);

(statearr_23175_23204[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (6))){
var inst_23134 = (state_23168[(7)]);
var inst_23136 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23137 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23134,inst_23136);
var state_23168__$1 = state_23168;
var statearr_23176_23205 = state_23168__$1;
(statearr_23176_23205[(2)] = inst_23137);

(statearr_23176_23205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (3))){
var inst_23166 = (state_23168[(2)]);
var state_23168__$1 = state_23168;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23168__$1,inst_23166);
} else {
if((state_val_23169 === (12))){
var inst_23146 = (state_23168[(8)]);
var inst_23148 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23149 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23146,inst_23148);
var state_23168__$1 = state_23168;
var statearr_23177_23206 = state_23168__$1;
(statearr_23177_23206[(2)] = inst_23149);

(statearr_23177_23206[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (2))){
var _ = (function (){var statearr_23178 = state_23168;
(statearr_23178[(4)] = cljs.core.cons((5),(state_23168[(4)])));

return statearr_23178;
})();
var inst_23134 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23168__$1 = (function (){var statearr_23179 = state_23168;
(statearr_23179[(7)] = inst_23134);

return statearr_23179;
})();
if(cljs.core.truth_(fuel)){
var statearr_23180_23207 = state_23168__$1;
(statearr_23180_23207[(1)] = (6));

} else {
var statearr_23181_23208 = state_23168__$1;
(statearr_23181_23208[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (11))){
var inst_23146 = (state_23168[(2)]);
var state_23168__$1 = (function (){var statearr_23183 = state_23168;
(statearr_23183[(8)] = inst_23146);

return statearr_23183;
})();
if(cljs.core.truth_(limit)){
var statearr_23184_23209 = state_23168__$1;
(statearr_23184_23209[(1)] = (12));

} else {
var statearr_23185_23210 = state_23168__$1;
(statearr_23185_23210[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (9))){
var inst_23140 = (state_23168[(9)]);
var inst_23142 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23143 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23140,inst_23142);
var state_23168__$1 = state_23168;
var statearr_23186_23211 = state_23168__$1;
(statearr_23186_23211[(2)] = inst_23143);

(statearr_23186_23211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (5))){
var _ = (function (){var statearr_23187 = state_23168;
(statearr_23187[(4)] = cljs.core.rest((state_23168[(4)])));

return statearr_23187;
})();
var state_23168__$1 = state_23168;
var ex23182 = (state_23168__$1[(2)]);
var statearr_23188_23212 = state_23168__$1;
(statearr_23188_23212[(5)] = ex23182);


if((ex23182 instanceof Error)){
var statearr_23189_23213 = state_23168__$1;
(statearr_23189_23213[(1)] = (4));

(statearr_23189_23213[(5)] = null);

} else {
throw ex23182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (14))){
var inst_23152 = (state_23168[(2)]);
var inst_23153 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23154 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23153);
var inst_23155 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23152,inst_23154);
var inst_23156 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23155,flakes);
var inst_23157 = cljs.core.PersistentVector.EMPTY;
var inst_23158 = (function (){var xf = inst_23155;
var flakes_by_sub = inst_23156;
return (function (p1__23124_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23124_SHARP_);
});
})();
var inst_23159 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23158,inst_23156);
var inst_23160 = fluree.db.util.async.merge_into_QMARK_(inst_23157,inst_23159);
var state_23168__$1 = state_23168;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23168__$1,(15),inst_23160);
} else {
if((state_val_23169 === (10))){
var inst_23140 = (state_23168[(9)]);
var state_23168__$1 = state_23168;
var statearr_23190_23214 = state_23168__$1;
(statearr_23190_23214[(2)] = inst_23140);

(statearr_23190_23214[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23169 === (8))){
var inst_23140 = (state_23168[(2)]);
var state_23168__$1 = (function (){var statearr_23191 = state_23168;
(statearr_23191[(9)] = inst_23140);

return statearr_23191;
})();
if(cljs.core.truth_(offset)){
var statearr_23192_23215 = state_23168__$1;
(statearr_23192_23215[(1)] = (9));

} else {
var statearr_23193_23216 = state_23168__$1;
(statearr_23193_23216[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_23194 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23194[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_23194[(1)] = (1));

return statearr_23194;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_23168){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23168);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23195){var ex__2417__auto__ = e23195;
var statearr_23196_23217 = state_23168;
(statearr_23196_23217[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23168[(4)]))){
var statearr_23197_23218 = state_23168;
(statearr_23197_23218[(1)] = cljs.core.first((state_23168[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23219 = state_23168;
state_23168 = G__23219;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_23168){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_23168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23198 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23198[(6)] = c__2436__auto__);

return statearr_23198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23221 = arguments.length;
switch (G__23221) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23305){
var state_val_23306 = (state_23305[(1)]);
if((state_val_23306 === (7))){
var inst_23300 = (state_23305[(2)]);
var _ = (function (){var statearr_23308 = state_23305;
(statearr_23308[(4)] = cljs.core.rest((state_23305[(4)])));

return statearr_23308;
})();
var state_23305__$1 = state_23305;
var statearr_23309_23356 = state_23305__$1;
(statearr_23309_23356[(2)] = inst_23300);

(statearr_23309_23356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (20))){
var inst_23241 = (state_23305[(7)]);
var inst_23249 = (state_23305[(8)]);
var inst_23242 = (state_23305[(9)]);
var inst_23270 = (inst_23241 + (1));
var tmp23307 = inst_23242;
var inst_23240 = inst_23249;
var inst_23241__$1 = inst_23270;
var inst_23242__$1 = tmp23307;
var state_23305__$1 = (function (){var statearr_23310 = state_23305;
(statearr_23310[(10)] = inst_23240);

(statearr_23310[(7)] = inst_23241__$1);

(statearr_23310[(9)] = inst_23242__$1);

return statearr_23310;
})();
var statearr_23311_23357 = state_23305__$1;
(statearr_23311_23357[(2)] = null);

(statearr_23311_23357[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (27))){
var inst_23275 = (state_23305[(11)]);
var inst_23284 = (state_23305[(2)]);
var inst_23285 = fluree.db.util.async.throw_err(inst_23284);
var inst_23286 = (inst_23275.cljs$core$IFn$_invoke$arity$1 ? inst_23275.cljs$core$IFn$_invoke$arity$1(inst_23285) : inst_23275.call(null,inst_23285));
var state_23305__$1 = state_23305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23305__$1,(26),inst_23286);
} else {
if((state_val_23306 === (1))){
var state_23305__$1 = state_23305;
var statearr_23312_23358 = state_23305__$1;
(statearr_23312_23358[(2)] = null);

(statearr_23312_23358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (24))){
var state_23305__$1 = state_23305;
var statearr_23313_23359 = state_23305__$1;
(statearr_23313_23359[(2)] = null);

(statearr_23313_23359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (4))){
var inst_23222 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
var statearr_23314_23360 = state_23305__$1;
(statearr_23314_23360[(2)] = inst_23222);

(statearr_23314_23360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (15))){
var inst_23263 = (state_23305[(12)]);
var inst_23263__$1 = offset;
var state_23305__$1 = (function (){var statearr_23315 = state_23305;
(statearr_23315[(12)] = inst_23263__$1);

return statearr_23315;
})();
if(cljs.core.truth_(inst_23263__$1)){
var statearr_23316_23361 = state_23305__$1;
(statearr_23316_23361[(1)] = (17));

} else {
var statearr_23317_23362 = state_23305__$1;
(statearr_23317_23362[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (21))){
var state_23305__$1 = state_23305;
var statearr_23318_23363 = state_23305__$1;
(statearr_23318_23363[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (13))){
var inst_23258 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
var statearr_23320_23364 = state_23305__$1;
(statearr_23320_23364[(2)] = inst_23258);

(statearr_23320_23364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (22))){
var inst_23296 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
var statearr_23321_23365 = state_23305__$1;
(statearr_23321_23365[(2)] = inst_23296);

(statearr_23321_23365[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (6))){
var inst_23250 = (state_23305[(13)]);
var inst_23240 = (state_23305[(10)]);
var inst_23248 = (state_23305[(14)]);
var inst_23247 = cljs.core.seq(inst_23240);
var inst_23248__$1 = cljs.core.first(inst_23247);
var inst_23249 = cljs.core.next(inst_23247);
var inst_23250__$1 = (inst_23248__$1 == null);
var state_23305__$1 = (function (){var statearr_23322 = state_23305;
(statearr_23322[(13)] = inst_23250__$1);

(statearr_23322[(14)] = inst_23248__$1);

(statearr_23322[(8)] = inst_23249);

return statearr_23322;
})();
if(cljs.core.truth_(inst_23250__$1)){
var statearr_23323_23366 = state_23305__$1;
(statearr_23323_23366[(1)] = (8));

} else {
var statearr_23324_23367 = state_23305__$1;
(statearr_23324_23367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (25))){
var inst_23294 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
var statearr_23325_23368 = state_23305__$1;
(statearr_23325_23368[(2)] = inst_23294);

(statearr_23325_23368[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (17))){
var inst_23241 = (state_23305[(7)]);
var inst_23265 = (inst_23241 < offset);
var state_23305__$1 = state_23305;
var statearr_23326_23369 = state_23305__$1;
(statearr_23326_23369[(2)] = inst_23265);

(statearr_23326_23369[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (3))){
var inst_23303 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23305__$1,inst_23303);
} else {
if((state_val_23306 === (12))){
var inst_23253 = (state_23305[(15)]);
var state_23305__$1 = state_23305;
var statearr_23327_23370 = state_23305__$1;
(statearr_23327_23370[(2)] = inst_23253);

(statearr_23327_23370[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (2))){
var inst_23235 = (state_23305[(16)]);
var _ = (function (){var statearr_23328 = state_23305;
(statearr_23328[(4)] = cljs.core.cons((5),(state_23305[(4)])));

return statearr_23328;
})();
var inst_23235__$1 = subjects;
var inst_23236 = cljs.core.seq(inst_23235__$1);
var inst_23237 = cljs.core.first(inst_23236);
var inst_23238 = cljs.core.next(inst_23236);
var inst_23239 = cljs.core.PersistentVector.EMPTY;
var inst_23240 = inst_23235__$1;
var inst_23241 = (0);
var inst_23242 = inst_23239;
var state_23305__$1 = (function (){var statearr_23329 = state_23305;
(statearr_23329[(16)] = inst_23235__$1);

(statearr_23329[(17)] = inst_23238);

(statearr_23329[(10)] = inst_23240);

(statearr_23329[(7)] = inst_23241);

(statearr_23329[(18)] = inst_23237);

(statearr_23329[(9)] = inst_23242);

return statearr_23329;
})();
var statearr_23330_23371 = state_23305__$1;
(statearr_23330_23371[(2)] = null);

(statearr_23330_23371[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (23))){
var inst_23235 = (state_23305[(16)]);
var inst_23238 = (state_23305[(17)]);
var inst_23240 = (state_23305[(10)]);
var inst_23241 = (state_23305[(7)]);
var inst_23248 = (state_23305[(14)]);
var inst_23237 = (state_23305[(18)]);
var inst_23249 = (state_23305[(8)]);
var inst_23242 = (state_23305[(9)]);
var inst_23274 = (inst_23241 + (1));
var inst_23275 = (function (){var first__23246 = inst_23248;
var seq__23245 = inst_23249;
var vec__23232 = inst_23235;
var r = inst_23249;
var first__23234 = inst_23237;
var vec__23244 = inst_23240;
var acc = inst_23242;
var n = inst_23241;
var s = inst_23248;
var seq__23233 = inst_23238;
var G__23231 = inst_23240;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23277 = [inst_23248];
var inst_23278 = (new cljs.core.PersistentVector(null,1,(5),inst_23276,inst_23277,null));
var inst_23279 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23280 = [limit];
var inst_23281 = cljs.core.PersistentHashMap.fromArrays(inst_23279,inst_23280);
var inst_23282 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23278,inst_23281);
var state_23305__$1 = (function (){var statearr_23331 = state_23305;
(statearr_23331[(19)] = inst_23274);

(statearr_23331[(11)] = inst_23275);

return statearr_23331;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23305__$1,(27),inst_23282);
} else {
if((state_val_23306 === (19))){
var inst_23268 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
if(cljs.core.truth_(inst_23268)){
var statearr_23332_23372 = state_23305__$1;
(statearr_23332_23372[(1)] = (20));

} else {
var statearr_23333_23373 = state_23305__$1;
(statearr_23333_23373[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (11))){
var inst_23241 = (state_23305[(7)]);
var inst_23255 = (inst_23241 > limit);
var state_23305__$1 = state_23305;
var statearr_23335_23374 = state_23305__$1;
(statearr_23335_23374[(2)] = inst_23255);

(statearr_23335_23374[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (9))){
var inst_23253 = (state_23305[(15)]);
var inst_23253__$1 = limit;
var state_23305__$1 = (function (){var statearr_23336 = state_23305;
(statearr_23336[(15)] = inst_23253__$1);

return statearr_23336;
})();
if(cljs.core.truth_(inst_23253__$1)){
var statearr_23337_23375 = state_23305__$1;
(statearr_23337_23375[(1)] = (11));

} else {
var statearr_23338_23376 = state_23305__$1;
(statearr_23338_23376[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (5))){
var _ = (function (){var statearr_23339 = state_23305;
(statearr_23339[(4)] = cljs.core.rest((state_23305[(4)])));

return statearr_23339;
})();
var state_23305__$1 = state_23305;
var ex23334 = (state_23305__$1[(2)]);
var statearr_23340_23377 = state_23305__$1;
(statearr_23340_23377[(5)] = ex23334);


if((ex23334 instanceof Error)){
var statearr_23341_23378 = state_23305__$1;
(statearr_23341_23378[(1)] = (4));

(statearr_23341_23378[(5)] = null);

} else {
throw ex23334;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (14))){
var inst_23242 = (state_23305[(9)]);
var state_23305__$1 = state_23305;
var statearr_23342_23379 = state_23305__$1;
(statearr_23342_23379[(2)] = inst_23242);

(statearr_23342_23379[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (26))){
var inst_23274 = (state_23305[(19)]);
var inst_23249 = (state_23305[(8)]);
var inst_23242 = (state_23305[(9)]);
var inst_23288 = (state_23305[(2)]);
var inst_23289 = fluree.db.util.async.throw_err(inst_23288);
var inst_23290 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23242,inst_23289);
var inst_23240 = inst_23249;
var inst_23241 = inst_23274;
var inst_23242__$1 = inst_23290;
var state_23305__$1 = (function (){var statearr_23343 = state_23305;
(statearr_23343[(10)] = inst_23240);

(statearr_23343[(7)] = inst_23241);

(statearr_23343[(9)] = inst_23242__$1);

return statearr_23343;
})();
var statearr_23344_23380 = state_23305__$1;
(statearr_23344_23380[(2)] = null);

(statearr_23344_23380[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (16))){
var inst_23298 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
var statearr_23345_23381 = state_23305__$1;
(statearr_23345_23381[(2)] = inst_23298);

(statearr_23345_23381[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (10))){
var inst_23260 = (state_23305[(2)]);
var state_23305__$1 = state_23305;
if(cljs.core.truth_(inst_23260)){
var statearr_23346_23382 = state_23305__$1;
(statearr_23346_23382[(1)] = (14));

} else {
var statearr_23347_23383 = state_23305__$1;
(statearr_23347_23383[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (18))){
var inst_23263 = (state_23305[(12)]);
var state_23305__$1 = state_23305;
var statearr_23348_23384 = state_23305__$1;
(statearr_23348_23384[(2)] = inst_23263);

(statearr_23348_23384[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23306 === (8))){
var inst_23250 = (state_23305[(13)]);
var state_23305__$1 = state_23305;
var statearr_23349_23385 = state_23305__$1;
(statearr_23349_23385[(2)] = inst_23250);

(statearr_23349_23385[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_23350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23350[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_23350[(1)] = (1));

return statearr_23350;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_23305){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23305);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23351){var ex__2417__auto__ = e23351;
var statearr_23352_23386 = state_23305;
(statearr_23352_23386[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23305[(4)]))){
var statearr_23353_23387 = state_23305;
(statearr_23353_23387[(1)] = cljs.core.first((state_23305[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23388 = state_23305;
state_23305 = G__23388;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_23305){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_23305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23354 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23354[(6)] = c__2436__auto__);

return statearr_23354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23390 = arguments.length;
switch (G__23390) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23578){
var state_val_23579 = (state_23578[(1)]);
if((state_val_23579 === (7))){
var state_23578__$1 = state_23578;
var statearr_23580_23651 = state_23578__$1;
(statearr_23580_23651[(2)] = null);

(statearr_23580_23651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (20))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23461 = (state_23578[(2)]);
var inst_23462 = fluree.db.util.async.throw_err(inst_23461);
var inst_23463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23464 = [inst_23431];
var inst_23465 = (new cljs.core.PersistentVector(null,1,(5),inst_23463,inst_23464,null));
var inst_23466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23467 = [inst_23431,inst_23433];
var inst_23468 = (new cljs.core.PersistentVector(null,2,(5),inst_23466,inst_23467,null));
var inst_23469 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23465,cljs.core._LT_,inst_23468);
var state_23578__$1 = (function (){var statearr_23581 = state_23578;
(statearr_23581[(9)] = inst_23462);

return statearr_23581;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(21),inst_23469);
} else {
if((state_val_23579 === (27))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23498 = (inst_23450.cljs$core$IFn$_invoke$arity$2 ? inst_23450.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_23432) : inst_23450.call(null,cljs.core._GT__EQ_,inst_23432));
var state_23578__$1 = state_23578;
if(cljs.core.truth_(inst_23498)){
var statearr_23582_23652 = state_23578__$1;
(statearr_23582_23652[(1)] = (30));

} else {
var statearr_23583_23653 = state_23578__$1;
(statearr_23583_23653[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (1))){
var state_23578__$1 = state_23578;
var statearr_23584_23654 = state_23578__$1;
(statearr_23584_23654[(2)] = null);

(statearr_23584_23654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (24))){
var inst_23547 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23585_23655 = state_23578__$1;
(statearr_23585_23655[(2)] = inst_23547);

(statearr_23585_23655[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (39))){
var inst_23537 = null;
var state_23578__$1 = state_23578;
var statearr_23586_23656 = state_23578__$1;
(statearr_23586_23656[(2)] = inst_23537);

(statearr_23586_23656[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (46))){
var inst_23558 = (state_23578[(12)]);
var inst_23424 = (state_23578[(13)]);
var inst_23416 = inst_23424;
var inst_23417 = inst_23558;
var state_23578__$1 = (function (){var statearr_23587 = state_23578;
(statearr_23587[(14)] = inst_23417);

(statearr_23587[(15)] = inst_23416);

return statearr_23587;
})();
var statearr_23588_23657 = state_23578__$1;
(statearr_23588_23657[(2)] = null);

(statearr_23588_23657[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (4))){
var inst_23391 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23589_23658 = state_23578__$1;
(statearr_23589_23658[(2)] = inst_23391);

(statearr_23589_23658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (15))){
var state_23578__$1 = state_23578;
var statearr_23590_23659 = state_23578__$1;
(statearr_23590_23659[(2)] = null);

(statearr_23590_23659[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (21))){
var inst_23462 = (state_23578[(9)]);
var inst_23471 = (state_23578[(2)]);
var inst_23472 = fluree.db.util.async.throw_err(inst_23471);
var inst_23473 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23462,inst_23472);
var state_23578__$1 = state_23578;
var statearr_23591_23660 = state_23578__$1;
(statearr_23591_23660[(2)] = inst_23473);

(statearr_23591_23660[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (31))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23511 = (inst_23450.cljs$core$IFn$_invoke$arity$2 ? inst_23450.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_23432) : inst_23450.call(null,cljs.core._LT_,inst_23432));
var state_23578__$1 = state_23578;
if(cljs.core.truth_(inst_23511)){
var statearr_23592_23661 = state_23578__$1;
(statearr_23592_23661[(1)] = (34));

} else {
var statearr_23593_23662 = state_23578__$1;
(statearr_23593_23662[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (32))){
var inst_23543 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23594_23663 = state_23578__$1;
(statearr_23594_23663[(2)] = inst_23543);

(statearr_23594_23663[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (40))){
var inst_23539 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23595_23664 = state_23578__$1;
(statearr_23595_23664[(2)] = inst_23539);

(statearr_23595_23664[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (33))){
var inst_23508 = (state_23578[(2)]);
var inst_23509 = fluree.db.util.async.throw_err(inst_23508);
var state_23578__$1 = state_23578;
var statearr_23596_23665 = state_23578__$1;
(statearr_23596_23665[(2)] = inst_23509);

(statearr_23596_23665[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (13))){
var inst_23568 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23597_23666 = state_23578__$1;
(statearr_23597_23666[(2)] = inst_23568);

(statearr_23597_23666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (22))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23478 = [inst_23431,inst_23433];
var inst_23479 = (new cljs.core.PersistentVector(null,2,(5),inst_23477,inst_23478,null));
var inst_23480 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23479);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(25),inst_23480);
} else {
if((state_val_23579 === (36))){
var inst_23541 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23598_23667 = state_23578__$1;
(statearr_23598_23667[(2)] = inst_23541);

(statearr_23598_23667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (41))){
var inst_23534 = (state_23578[(2)]);
var inst_23535 = fluree.db.util.async.throw_err(inst_23534);
var state_23578__$1 = state_23578;
var statearr_23599_23668 = state_23578__$1;
(statearr_23599_23668[(2)] = inst_23535);

(statearr_23599_23668[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (43))){
var inst_23417 = (state_23578[(14)]);
var inst_23550 = (state_23578[(16)]);
var inst_23551 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23417,inst_23550);
var state_23578__$1 = state_23578;
var statearr_23600_23669 = state_23578__$1;
(statearr_23600_23669[(2)] = inst_23551);

(statearr_23600_23669[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (29))){
var inst_23495 = (state_23578[(2)]);
var inst_23496 = fluree.db.util.async.throw_err(inst_23495);
var state_23578__$1 = state_23578;
var statearr_23601_23670 = state_23578__$1;
(statearr_23601_23670[(2)] = inst_23496);

(statearr_23601_23670[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (44))){
var inst_23417 = (state_23578[(14)]);
var inst_23550 = (state_23578[(16)]);
var inst_23553 = cljs.core.PersistentHashSet.EMPTY;
var inst_23554 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23553,inst_23550);
var inst_23555 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_23417,inst_23554);
var state_23578__$1 = state_23578;
var statearr_23602_23671 = state_23578__$1;
(statearr_23602_23671[(2)] = inst_23555);

(statearr_23602_23671[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (6))){
var inst_23402 = (state_23578[(17)]);
var inst_23412 = cljs.core.seq(inst_23402);
var inst_23413 = cljs.core.first(inst_23412);
var inst_23414 = cljs.core.next(inst_23412);
var inst_23415 = cljs.core.PersistentHashSet.EMPTY;
var inst_23416 = inst_23402;
var inst_23417 = inst_23415;
var state_23578__$1 = (function (){var statearr_23603 = state_23578;
(statearr_23603[(18)] = inst_23413);

(statearr_23603[(14)] = inst_23417);

(statearr_23603[(19)] = inst_23414);

(statearr_23603[(15)] = inst_23416);

return statearr_23603;
})();
var statearr_23604_23672 = state_23578__$1;
(statearr_23604_23672[(2)] = null);

(statearr_23604_23672[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (28))){
var inst_23545 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23605_23673 = state_23578__$1;
(statearr_23605_23673[(2)] = inst_23545);

(statearr_23605_23673[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (25))){
var inst_23482 = (state_23578[(2)]);
var inst_23483 = fluree.db.util.async.throw_err(inst_23482);
var state_23578__$1 = state_23578;
var statearr_23606_23674 = state_23578__$1;
(statearr_23606_23674[(2)] = inst_23483);

(statearr_23606_23674[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (34))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23514 = [inst_23431];
var inst_23515 = (new cljs.core.PersistentVector(null,1,(5),inst_23513,inst_23514,null));
var inst_23516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23517 = [inst_23431,inst_23433];
var inst_23518 = (new cljs.core.PersistentVector(null,2,(5),inst_23516,inst_23517,null));
var inst_23519 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23515,cljs.core._LT_,inst_23518);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(37),inst_23519);
} else {
if((state_val_23579 === (17))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23454 = [inst_23431,inst_23433];
var inst_23455 = (new cljs.core.PersistentVector(null,2,(5),inst_23453,inst_23454,null));
var inst_23456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23457 = [inst_23431];
var inst_23458 = (new cljs.core.PersistentVector(null,1,(5),inst_23456,inst_23457,null));
var inst_23459 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23455,cljs.core._LT__EQ_,inst_23458);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(20),inst_23459);
} else {
if((state_val_23579 === (3))){
var inst_23576 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23578__$1,inst_23576);
} else {
if((state_val_23579 === (12))){
var inst_23431 = (state_23578[(7)]);
var inst_23423 = (state_23578[(20)]);
var inst_23431__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23423,(0),null);
var inst_23432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23423,(1),null);
var inst_23433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23423,(2),null);
var inst_23434 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_23431__$1);
var inst_23435 = cljs.core.not(inst_23434);
var state_23578__$1 = (function (){var statearr_23607 = state_23578;
(statearr_23607[(7)] = inst_23431__$1);

(statearr_23607[(10)] = inst_23432);

(statearr_23607[(8)] = inst_23433);

return statearr_23607;
})();
if(inst_23435){
var statearr_23608_23675 = state_23578__$1;
(statearr_23608_23675[(1)] = (14));

} else {
var statearr_23609_23676 = state_23578__$1;
(statearr_23609_23676[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (2))){
var inst_23402 = (state_23578[(17)]);
var _ = (function (){var statearr_23610 = state_23578;
(statearr_23610[(4)] = cljs.core.cons((5),(state_23578[(4)])));

return statearr_23610;
})();
var inst_23400 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_23401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23400,(0),null);
var inst_23402__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23400,(1),null);
var inst_23403 = cljs.core.not_empty(inst_23402__$1);
var state_23578__$1 = (function (){var statearr_23611 = state_23578;
(statearr_23611[(21)] = inst_23401);

(statearr_23611[(17)] = inst_23402__$1);

return statearr_23611;
})();
if(cljs.core.truth_(inst_23403)){
var statearr_23612_23677 = state_23578__$1;
(statearr_23612_23677[(1)] = (6));

} else {
var statearr_23613_23678 = state_23578__$1;
(statearr_23613_23678[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (23))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23485 = (inst_23450.cljs$core$IFn$_invoke$arity$2 ? inst_23450.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_23432) : inst_23450.call(null,cljs.core._GT_,inst_23432));
var state_23578__$1 = state_23578;
if(cljs.core.truth_(inst_23485)){
var statearr_23614_23679 = state_23578__$1;
(statearr_23614_23679[(1)] = (26));

} else {
var statearr_23615_23680 = state_23578__$1;
(statearr_23615_23680[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (47))){
var inst_23566 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23616_23681 = state_23578__$1;
(statearr_23616_23681[(2)] = inst_23566);

(statearr_23616_23681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (35))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23524 = (inst_23450.cljs$core$IFn$_invoke$arity$2 ? inst_23450.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_23432) : inst_23450.call(null,cljs.core._LT__EQ_,inst_23432));
var state_23578__$1 = state_23578;
if(cljs.core.truth_(inst_23524)){
var statearr_23617_23682 = state_23578__$1;
(statearr_23617_23682[(1)] = (38));

} else {
var statearr_23618_23683 = state_23578__$1;
(statearr_23618_23683[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (19))){
var inst_23401 = (state_23578[(21)]);
var inst_23549 = (state_23578[(2)]);
var inst_23550 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23549);
var state_23578__$1 = (function (){var statearr_23619 = state_23578;
(statearr_23619[(16)] = inst_23550);

return statearr_23619;
})();
var G__23620_23684 = inst_23401;
var G__23620_23685__$1 = (((G__23620_23684 instanceof cljs.core.Keyword))?G__23620_23684.fqn:null);
switch (G__23620_23685__$1) {
case "or":
var statearr_23621_23687 = state_23578__$1;
(statearr_23621_23687[(1)] = (43));


break;
case "and":
var statearr_23622_23688 = state_23578__$1;
(statearr_23622_23688[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23620_23685__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (11))){
var inst_23417 = (state_23578[(14)]);
var state_23578__$1 = state_23578;
var statearr_23624_23689 = state_23578__$1;
(statearr_23624_23689[(2)] = inst_23417);

(statearr_23624_23689[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (9))){
var inst_23423 = (state_23578[(20)]);
var inst_23416 = (state_23578[(15)]);
var inst_23422 = cljs.core.seq(inst_23416);
var inst_23423__$1 = cljs.core.first(inst_23422);
var inst_23424 = cljs.core.next(inst_23422);
var inst_23425 = cljs.core.not(inst_23423__$1);
var state_23578__$1 = (function (){var statearr_23625 = state_23578;
(statearr_23625[(20)] = inst_23423__$1);

(statearr_23625[(13)] = inst_23424);

return statearr_23625;
})();
if(inst_23425){
var statearr_23626_23690 = state_23578__$1;
(statearr_23626_23690[(1)] = (11));

} else {
var statearr_23627_23691 = state_23578__$1;
(statearr_23627_23691[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (5))){
var _ = (function (){var statearr_23628 = state_23578;
(statearr_23628[(4)] = cljs.core.rest((state_23578[(4)])));

return statearr_23628;
})();
var state_23578__$1 = state_23578;
var ex23623 = (state_23578__$1[(2)]);
var statearr_23629_23692 = state_23578__$1;
(statearr_23629_23692[(5)] = ex23623);


if((ex23623 instanceof Error)){
var statearr_23630_23693 = state_23578__$1;
(statearr_23630_23693[(1)] = (4));

(statearr_23630_23693[(5)] = null);

} else {
throw ex23623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (14))){
var inst_23431 = (state_23578[(7)]);
var inst_23437 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23431);
var inst_23438 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23437)].join('');
var inst_23439 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23440 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23441 = cljs.core.PersistentHashMap.fromArrays(inst_23439,inst_23440);
var inst_23442 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23438,inst_23441);
var inst_23443 = (function(){throw inst_23442})();
var state_23578__$1 = state_23578;
var statearr_23631_23694 = state_23578__$1;
(statearr_23631_23694[(2)] = inst_23443);

(statearr_23631_23694[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (45))){
var inst_23558 = (state_23578[(12)]);
var state_23578__$1 = state_23578;
var statearr_23632_23695 = state_23578__$1;
(statearr_23632_23695[(2)] = inst_23558);

(statearr_23632_23695[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (26))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23488 = [inst_23431,inst_23433];
var inst_23489 = (new cljs.core.PersistentVector(null,2,(5),inst_23487,inst_23488,null));
var inst_23490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23491 = [inst_23431];
var inst_23492 = (new cljs.core.PersistentVector(null,1,(5),inst_23490,inst_23491,null));
var inst_23493 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23489,cljs.core._LT__EQ_,inst_23492);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(29),inst_23493);
} else {
if((state_val_23579 === (16))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23446 = (state_23578[(2)]);
var inst_23450__$1 = cljs.core.identical_QMARK_;
var inst_23451 = (inst_23450__$1.cljs$core$IFn$_invoke$arity$2 ? inst_23450__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_23432) : inst_23450__$1.call(null,cljs.core.not_EQ_,inst_23432));
var state_23578__$1 = (function (){var statearr_23633 = state_23578;
(statearr_23633[(11)] = inst_23450__$1);

(statearr_23633[(22)] = inst_23446);

return statearr_23633;
})();
if(cljs.core.truth_(inst_23451)){
var statearr_23634_23696 = state_23578__$1;
(statearr_23634_23696[(1)] = (17));

} else {
var statearr_23635_23697 = state_23578__$1;
(statearr_23635_23697[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (38))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23527 = [inst_23431];
var inst_23528 = (new cljs.core.PersistentVector(null,1,(5),inst_23526,inst_23527,null));
var inst_23529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23530 = [inst_23431,inst_23433];
var inst_23531 = (new cljs.core.PersistentVector(null,2,(5),inst_23529,inst_23530,null));
var inst_23532 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23528,cljs.core._LT__EQ_,inst_23531);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(41),inst_23532);
} else {
if((state_val_23579 === (30))){
var inst_23431 = (state_23578[(7)]);
var inst_23433 = (state_23578[(8)]);
var inst_23500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23501 = [inst_23431,inst_23433];
var inst_23502 = (new cljs.core.PersistentVector(null,2,(5),inst_23500,inst_23501,null));
var inst_23503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23504 = [inst_23431];
var inst_23505 = (new cljs.core.PersistentVector(null,1,(5),inst_23503,inst_23504,null));
var inst_23506 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23502,cljs.core._LT__EQ_,inst_23505);
var state_23578__$1 = state_23578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23578__$1,(33),inst_23506);
} else {
if((state_val_23579 === (10))){
var inst_23570 = (state_23578[(2)]);
var state_23578__$1 = state_23578;
var statearr_23636_23698 = state_23578__$1;
(statearr_23636_23698[(2)] = inst_23570);

(statearr_23636_23698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (18))){
var inst_23432 = (state_23578[(10)]);
var inst_23450 = (state_23578[(11)]);
var inst_23475 = (inst_23450.cljs$core$IFn$_invoke$arity$2 ? inst_23450.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_23432) : inst_23450.call(null,cljs.core._EQ_,inst_23432));
var state_23578__$1 = state_23578;
if(cljs.core.truth_(inst_23475)){
var statearr_23637_23699 = state_23578__$1;
(statearr_23637_23699[(1)] = (22));

} else {
var statearr_23638_23700 = state_23578__$1;
(statearr_23638_23700[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (42))){
var inst_23401 = (state_23578[(21)]);
var inst_23558 = (state_23578[(12)]);
var inst_23558__$1 = (state_23578[(2)]);
var inst_23559 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_23401);
var inst_23560 = cljs.core.empty_QMARK_(inst_23558__$1);
var inst_23561 = ((inst_23559) && (inst_23560));
var state_23578__$1 = (function (){var statearr_23639 = state_23578;
(statearr_23639[(12)] = inst_23558__$1);

return statearr_23639;
})();
if(cljs.core.truth_(inst_23561)){
var statearr_23640_23701 = state_23578__$1;
(statearr_23640_23701[(1)] = (45));

} else {
var statearr_23641_23702 = state_23578__$1;
(statearr_23641_23702[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (37))){
var inst_23521 = (state_23578[(2)]);
var inst_23522 = fluree.db.util.async.throw_err(inst_23521);
var state_23578__$1 = state_23578;
var statearr_23642_23703 = state_23578__$1;
(statearr_23642_23703[(2)] = inst_23522);

(statearr_23642_23703[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23579 === (8))){
var inst_23573 = (state_23578[(2)]);
var _ = (function (){var statearr_23643 = state_23578;
(statearr_23643[(4)] = cljs.core.rest((state_23578[(4)])));

return statearr_23643;
})();
var state_23578__$1 = state_23578;
var statearr_23644_23704 = state_23578__$1;
(statearr_23644_23704[(2)] = inst_23573);

(statearr_23644_23704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_23645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23645[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_23645[(1)] = (1));

return statearr_23645;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_23578){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23578);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23646){var ex__2417__auto__ = e23646;
var statearr_23647_23705 = state_23578;
(statearr_23647_23705[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23578[(4)]))){
var statearr_23648_23706 = state_23578;
(statearr_23648_23706[(1)] = cljs.core.first((state_23578[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23707 = state_23578;
state_23578 = G__23707;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_23578){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_23578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23649 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23649[(6)] = c__2436__auto__);

return statearr_23649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__23709,offset,limit){
var map__23710 = p__23709;
var map__23710__$1 = (((((!((map__23710 == null))))?(((((map__23710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23710):map__23710);
var res = map__23710__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23710__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23710__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__23712 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23712,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23712,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__23715 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__23708_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__23708_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__23715__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__23715):G__23715);
var G__23715__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__23715__$1):G__23715__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__23715__$2);
} else {
return G__23715__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__23716_SHARP_){
return ((typeof p1__23716_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__23716_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__23717_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__23717_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__23721 = vars;
var vec__23722 = G__23721;
var seq__23723 = cljs.core.seq(vec__23722);
var first__23724 = cljs.core.first(seq__23723);
var seq__23723__$1 = cljs.core.next(seq__23723);
var var$ = first__23724;
var r = seq__23723__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__23721__$1 = G__23721;
var all_vars__$1 = all_vars;
while(true){
var vec__23729 = G__23721__$1;
var seq__23730 = cljs.core.seq(vec__23729);
var first__23731 = cljs.core.first(seq__23730);
var seq__23730__$1 = cljs.core.next(seq__23730);
var var$__$1 = first__23731;
var r__$1 = seq__23730__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__23732 = cljs.core.set(all_vars__$2);
return (fexpr__23732.cljs$core$IFn$_invoke$arity$1 ? fexpr__23732.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__23732.call(null,var$__$1));
})())){
var G__23733 = r__$1;
var G__23734 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__23721__$1 = G__23733;
all_vars__$1 = G__23734;
continue;
} else {
var G__23735 = r__$1;
var G__23736 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__23721__$1 = G__23735;
all_vars__$1 = G__23736;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23771){
var state_val_23772 = (state_23771[(1)]);
if((state_val_23772 === (1))){
var inst_23744 = functionArray;
var inst_23745 = cljs.core.seq(inst_23744);
var inst_23746 = cljs.core.first(inst_23745);
var inst_23747 = cljs.core.next(inst_23745);
var inst_23748 = cljs.core.PersistentVector.EMPTY;
var inst_23749 = inst_23744;
var inst_23750 = inst_23748;
var state_23771__$1 = (function (){var statearr_23773 = state_23771;
(statearr_23773[(7)] = inst_23749);

(statearr_23773[(8)] = inst_23750);

(statearr_23773[(9)] = inst_23747);

(statearr_23773[(10)] = inst_23746);

return statearr_23773;
})();
var statearr_23774_23787 = state_23771__$1;
(statearr_23774_23787[(2)] = null);

(statearr_23774_23787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23772 === (2))){
var inst_23756 = (state_23771[(11)]);
var inst_23749 = (state_23771[(7)]);
var inst_23755 = cljs.core.seq(inst_23749);
var inst_23756__$1 = cljs.core.first(inst_23755);
var inst_23757 = cljs.core.next(inst_23755);
var state_23771__$1 = (function (){var statearr_23775 = state_23771;
(statearr_23775[(11)] = inst_23756__$1);

(statearr_23775[(12)] = inst_23757);

return statearr_23775;
})();
if(cljs.core.truth_(inst_23756__$1)){
var statearr_23776_23788 = state_23771__$1;
(statearr_23776_23788[(1)] = (4));

} else {
var statearr_23777_23789 = state_23771__$1;
(statearr_23777_23789[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23772 === (3))){
var inst_23769 = (state_23771[(2)]);
var state_23771__$1 = state_23771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23771__$1,inst_23769);
} else {
if((state_val_23772 === (4))){
var inst_23756 = (state_23771[(11)]);
var inst_23759 = (inst_23756.cljs$core$IFn$_invoke$arity$1 ? inst_23756.cljs$core$IFn$_invoke$arity$1(tuple) : inst_23756.call(null,tuple));
var state_23771__$1 = state_23771;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23771__$1,(7),inst_23759);
} else {
if((state_val_23772 === (5))){
var inst_23750 = (state_23771[(8)]);
var state_23771__$1 = state_23771;
var statearr_23778_23790 = state_23771__$1;
(statearr_23778_23790[(2)] = inst_23750);

(statearr_23778_23790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23772 === (6))){
var inst_23767 = (state_23771[(2)]);
var state_23771__$1 = state_23771;
var statearr_23779_23791 = state_23771__$1;
(statearr_23779_23791[(2)] = inst_23767);

(statearr_23779_23791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23772 === (7))){
var inst_23750 = (state_23771[(8)]);
var inst_23757 = (state_23771[(12)]);
var inst_23761 = (state_23771[(2)]);
var inst_23762 = fluree.db.util.async.throw_err(inst_23761);
var inst_23763 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23750,inst_23762);
var inst_23749 = inst_23757;
var inst_23750__$1 = inst_23763;
var state_23771__$1 = (function (){var statearr_23780 = state_23771;
(statearr_23780[(7)] = inst_23749);

(statearr_23780[(8)] = inst_23750__$1);

return statearr_23780;
})();
var statearr_23781_23792 = state_23771__$1;
(statearr_23781_23792[(2)] = null);

(statearr_23781_23792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0 = (function (){
var statearr_23782 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23782[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__);

(statearr_23782[(1)] = (1));

return statearr_23782;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1 = (function (state_23771){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23771);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23783){var ex__2417__auto__ = e23783;
var statearr_23784_23793 = state_23771;
(statearr_23784_23793[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23771[(4)]))){
var statearr_23785_23794 = state_23771;
(statearr_23785_23794[(1)] = cljs.core.first((state_23771[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23795 = state_23771;
state_23771 = G__23795;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__ = function(state_23771){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1.call(this,state_23771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23786 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23786[(6)] = c__2436__auto__);

return statearr_23786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__23797,headers,vars,opts){
var map__23798 = p__23797;
var map__23798__$1 = (((((!((map__23798 == null))))?(((((map__23798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23798.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23798):map__23798);
var select_spec = map__23798__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23798__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23798__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23798__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23798__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23885){
var state_val_23886 = (state_23885[(1)]);
if((state_val_23886 === (7))){
var state_23885__$1 = state_23885;
var statearr_23887_24029 = state_23885__$1;
(statearr_23887_24029[(2)] = null);

(statearr_23887_24029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (1))){
var state_23885__$1 = state_23885;
var statearr_23888_24030 = state_23885__$1;
(statearr_23888_24030[(2)] = null);

(statearr_23888_24030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (4))){
var inst_23800 = (state_23885[(2)]);
var state_23885__$1 = state_23885;
var statearr_23889_24031 = state_23885__$1;
(statearr_23889_24031[(2)] = inst_23800);

(statearr_23889_24031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (15))){
var inst_23874 = (state_23885[(2)]);
var inst_23875 = fluree.db.util.async.throw_err(inst_23874);
var state_23885__$1 = state_23885;
var statearr_23890_24032 = state_23885__$1;
(statearr_23890_24032[(2)] = inst_23875);

(statearr_23890_24032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (13))){
var inst_23810 = (state_23885[(7)]);
var inst_23818 = (state_23885[(8)]);
var inst_23877 = (function (){var pp = inst_23810;
var functionArray = inst_23818;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__23796_SHARP_){
return (p1__23796_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23796_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__23796_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_23878 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23877,tuples);
var state_23885__$1 = state_23885;
var statearr_23891_24033 = state_23885__$1;
(statearr_23891_24033[(2)] = inst_23878);

(statearr_23891_24033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (6))){
var inst_23807 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_23885__$1 = state_23885;
var statearr_23892_24034 = state_23885__$1;
(statearr_23892_24034[(2)] = inst_23807);

(statearr_23892_24034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (3))){
var inst_23883 = (state_23885[(2)]);
var state_23885__$1 = state_23885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23885__$1,inst_23883);
} else {
if((state_val_23886 === (12))){
var inst_23810 = (state_23885[(7)]);
var inst_23818 = (state_23885[(8)]);
var inst_23870 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_23871 = (function (){var pp = inst_23810;
var functionArray = inst_23818;
var c__2436__auto____$1 = inst_23870;
return (function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23868){
var state_val_23869 = (state_23868[(1)]);
if((state_val_23869 === (7))){
var inst_23844 = (state_23868[(2)]);
var inst_23845 = fluree.db.util.async.throw_err(inst_23844);
var state_23868__$1 = (function (){var statearr_23893 = state_23868;
(statearr_23893[(7)] = inst_23845);

return statearr_23893;
})();
if(cljs.core.truth_(pp)){
var statearr_23894_24035 = state_23868__$1;
(statearr_23894_24035[(1)] = (8));

} else {
var statearr_23895_24036 = state_23868__$1;
(statearr_23895_24036[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (1))){
var inst_23827 = tuples;
var inst_23828 = cljs.core.seq(inst_23827);
var inst_23829 = cljs.core.first(inst_23828);
var inst_23830 = cljs.core.next(inst_23828);
var inst_23831 = cljs.core.PersistentVector.EMPTY;
var inst_23832 = inst_23827;
var inst_23833 = inst_23831;
var state_23868__$1 = (function (){var statearr_23896 = state_23868;
(statearr_23896[(8)] = inst_23832);

(statearr_23896[(9)] = inst_23833);

(statearr_23896[(10)] = inst_23829);

(statearr_23896[(11)] = inst_23830);

return statearr_23896;
})();
var statearr_23897_24037 = state_23868__$1;
(statearr_23897_24037[(2)] = null);

(statearr_23897_24037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (4))){
var inst_23839 = (state_23868[(12)]);
var inst_23842 = fluree.db.query.fql.format_tuple(functionArray,inst_23839);
var state_23868__$1 = state_23868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23868__$1,(7),inst_23842);
} else {
if((state_val_23869 === (15))){
var state_23868__$1 = state_23868;
var statearr_23898_24038 = state_23868__$1;
(statearr_23898_24038[(2)] = null);

(statearr_23898_24038[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (13))){
var inst_23857 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23899_24039 = state_23868__$1;
(statearr_23899_24039[(2)] = inst_23857);

(statearr_23899_24039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (6))){
var inst_23864 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23900_24040 = state_23868__$1;
(statearr_23900_24040[(2)] = inst_23864);

(statearr_23900_24040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (3))){
var inst_23866 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23868__$1,inst_23866);
} else {
if((state_val_23869 === (12))){
var state_23868__$1 = state_23868;
var statearr_23901_24041 = state_23868__$1;
(statearr_23901_24041[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (2))){
var inst_23839 = (state_23868[(12)]);
var inst_23832 = (state_23868[(8)]);
var inst_23838 = cljs.core.seq(inst_23832);
var inst_23839__$1 = cljs.core.first(inst_23838);
var inst_23840 = cljs.core.next(inst_23838);
var state_23868__$1 = (function (){var statearr_23903 = state_23868;
(statearr_23903[(12)] = inst_23839__$1);

(statearr_23903[(13)] = inst_23840);

return statearr_23903;
})();
if(cljs.core.truth_(inst_23839__$1)){
var statearr_23904_24042 = state_23868__$1;
(statearr_23904_24042[(1)] = (4));

} else {
var statearr_23905_24043 = state_23868__$1;
(statearr_23905_24043[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (11))){
var inst_23845 = (state_23868[(7)]);
var state_23868__$1 = state_23868;
var statearr_23906_24044 = state_23868__$1;
(statearr_23906_24044[(2)] = inst_23845);

(statearr_23906_24044[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (9))){
var state_23868__$1 = state_23868;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_23907_24045 = state_23868__$1;
(statearr_23907_24045[(1)] = (11));

} else {
var statearr_23908_24046 = state_23868__$1;
(statearr_23908_24046[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (5))){
var inst_23833 = (state_23868[(9)]);
var state_23868__$1 = state_23868;
var statearr_23909_24047 = state_23868__$1;
(statearr_23909_24047[(2)] = inst_23833);

(statearr_23909_24047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (14))){
var inst_23845 = (state_23868[(7)]);
var inst_23852 = cljs.core.first(inst_23845);
var state_23868__$1 = state_23868;
var statearr_23910_24048 = state_23868__$1;
(statearr_23910_24048[(2)] = inst_23852);

(statearr_23910_24048[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (16))){
var inst_23855 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23911_24049 = state_23868__$1;
(statearr_23911_24049[(2)] = inst_23855);

(statearr_23911_24049[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (10))){
var inst_23840 = (state_23868[(13)]);
var inst_23833 = (state_23868[(9)]);
var inst_23859 = (state_23868[(2)]);
var inst_23860 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23833,inst_23859);
var inst_23832 = inst_23840;
var inst_23833__$1 = inst_23860;
var state_23868__$1 = (function (){var statearr_23912 = state_23868;
(statearr_23912[(8)] = inst_23832);

(statearr_23912[(9)] = inst_23833__$1);

return statearr_23912;
})();
var statearr_23913_24050 = state_23868__$1;
(statearr_23913_24050[(2)] = null);

(statearr_23913_24050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (8))){
var inst_23845 = (state_23868[(7)]);
var inst_23847 = cljs.core.zipmap(pp,inst_23845);
var state_23868__$1 = state_23868;
var statearr_23914_24051 = state_23868__$1;
(statearr_23914_24051[(2)] = inst_23847);

(statearr_23914_24051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_23915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23915[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_23915[(1)] = (1));

return statearr_23915;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_23868){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23868);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23916){var ex__2417__auto__ = e23916;
var statearr_23917_24052 = state_23868;
(statearr_23917_24052[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23868[(4)]))){
var statearr_23918_24053 = state_23868;
(statearr_23918_24053[(1)] = cljs.core.first((state_23868[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24054 = state_23868;
state_23868 = G__24054;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_23868){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_23868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23919 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23919[(6)] = c__2436__auto____$1);

return statearr_23919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
});
})();
var inst_23872 = cljs.core.async.impl.dispatch.run(inst_23871);
var state_23885__$1 = (function (){var statearr_23920 = state_23885;
(statearr_23920[(9)] = inst_23872);

return statearr_23920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23885__$1,(15),inst_23870);
} else {
if((state_val_23886 === (2))){
var _ = (function (){var statearr_23921 = state_23885;
(statearr_23921[(4)] = cljs.core.cons((5),(state_23885[(4)])));

return statearr_23921;
})();
var state_23885__$1 = state_23885;
if(cljs.core.truth_(prettyPrint)){
var statearr_23922_24055 = state_23885__$1;
(statearr_23922_24055[(1)] = (6));

} else {
var statearr_23923_24056 = state_23885__$1;
(statearr_23923_24056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (11))){
var inst_23818 = (state_23885[(2)]);
var state_23885__$1 = (function (){var statearr_23925 = state_23885;
(statearr_23925[(8)] = inst_23818);

return statearr_23925;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_23926_24057 = state_23885__$1;
(statearr_23926_24057[(1)] = (12));

} else {
var statearr_23927_24058 = state_23885__$1;
(statearr_23927_24058[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (9))){
var inst_23810 = (state_23885[(7)]);
var inst_23812 = (function (){var pp = inst_23810;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2436__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23962){
var state_val_23963 = (state_23962[(1)]);
if((state_val_23963 === (7))){
var state_23962__$1 = state_23962;
var statearr_23964_24059 = state_23962__$1;
(statearr_23964_24059[(2)] = null);

(statearr_23964_24059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (1))){
var state_23962__$1 = state_23962;
var statearr_23965_24060 = state_23962__$1;
(statearr_23965_24060[(2)] = null);

(statearr_23965_24060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (4))){
var inst_23928 = (state_23962[(2)]);
var state_23962__$1 = state_23962;
var statearr_23966_24061 = state_23962__$1;
(statearr_23966_24061[(2)] = inst_23928);

(statearr_23966_24061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (6))){
var inst_23938 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_23939 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_23940 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_23941 = [inst_23939,inst_23940,opts];
var inst_23942 = cljs.core.PersistentHashMap.fromArrays(inst_23938,inst_23941);
var inst_23943 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_23942) : fluree.db.query.fql.query.call(null,db,inst_23942));
var state_23962__$1 = state_23962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23962__$1,(9),inst_23943);
} else {
if((state_val_23963 === (3))){
var inst_23960 = (state_23962[(2)]);
var state_23962__$1 = state_23962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23962__$1,inst_23960);
} else {
if((state_val_23963 === (12))){
var inst_23954 = (state_23962[(2)]);
var state_23962__$1 = state_23962;
var statearr_23967_24062 = state_23962__$1;
(statearr_23967_24062[(2)] = inst_23954);

(statearr_23967_24062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (2))){
var _ = (function (){var statearr_23968 = state_23962;
(statearr_23968[(4)] = cljs.core.cons((5),(state_23962[(4)])));

return statearr_23968;
})();
var inst_23934 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_23962__$1 = state_23962;
if(cljs.core.truth_(inst_23934)){
var statearr_23969_24063 = state_23962__$1;
(statearr_23969_24063[(1)] = (6));

} else {
var statearr_23970_24064 = state_23962__$1;
(statearr_23970_24064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (11))){
var inst_23949 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23950 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_23951 = [inst_23950];
var inst_23952 = cljs.core.PersistentHashMap.fromArrays(inst_23949,inst_23951);
var state_23962__$1 = state_23962;
var statearr_23972_24065 = state_23962__$1;
(statearr_23972_24065[(2)] = inst_23952);

(statearr_23972_24065[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (9))){
var inst_23946 = (state_23962[(7)]);
var inst_23945 = (state_23962[(2)]);
var inst_23946__$1 = fluree.db.util.async.throw_err(inst_23945);
var state_23962__$1 = (function (){var statearr_23973 = state_23962;
(statearr_23973[(7)] = inst_23946__$1);

return statearr_23973;
})();
if(cljs.core.truth_(inst_23946__$1)){
var statearr_23974_24066 = state_23962__$1;
(statearr_23974_24066[(1)] = (10));

} else {
var statearr_23975_24067 = state_23962__$1;
(statearr_23975_24067[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (5))){
var _ = (function (){var statearr_23976 = state_23962;
(statearr_23976[(4)] = cljs.core.rest((state_23962[(4)])));

return statearr_23976;
})();
var state_23962__$1 = state_23962;
var ex23971 = (state_23962__$1[(2)]);
var statearr_23977_24068 = state_23962__$1;
(statearr_23977_24068[(5)] = ex23971);


if((ex23971 instanceof Error)){
var statearr_23978_24069 = state_23962__$1;
(statearr_23978_24069[(1)] = (4));

(statearr_23978_24069[(5)] = null);

} else {
throw ex23971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (10))){
var inst_23946 = (state_23962[(7)]);
var state_23962__$1 = state_23962;
var statearr_23979_24070 = state_23962__$1;
(statearr_23979_24070[(2)] = inst_23946);

(statearr_23979_24070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23963 === (8))){
var inst_23957 = (state_23962[(2)]);
var _ = (function (){var statearr_23980 = state_23962;
(statearr_23980[(4)] = cljs.core.rest((state_23962[(4)])));

return statearr_23980;
})();
var state_23962__$1 = state_23962;
var statearr_23981_24071 = state_23962__$1;
(statearr_23981_24071[(2)] = inst_23957);

(statearr_23981_24071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_23982 = [null,null,null,null,null,null,null,null];
(statearr_23982[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_23982[(1)] = (1));

return statearr_23982;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_23962){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23962);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e23983){var ex__2417__auto__ = e23983;
var statearr_23984_24072 = state_23962;
(statearr_23984_24072[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23962[(4)]))){
var statearr_23985_24073 = state_23962;
(statearr_23985_24073[(1)] = cljs.core.first((state_23962[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24074 = state_23962;
state_23962 = G__24074;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_23962){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_23962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_23986 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_23986[(6)] = c__2436__auto____$1);

return statearr_23986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto____$1;
});
} else {
return (function (tuple){
var c__2436__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_23998){
var state_val_23999 = (state_23998[(1)]);
if((state_val_23999 === (1))){
var state_23998__$1 = state_23998;
var statearr_24000_24075 = state_23998__$1;
(statearr_24000_24075[(2)] = null);

(statearr_24000_24075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23999 === (2))){
var _ = (function (){var statearr_24001 = state_23998;
(statearr_24001[(4)] = cljs.core.cons((5),(state_23998[(4)])));

return statearr_24001;
})();
var inst_23993 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_24002 = state_23998;
(statearr_24002[(4)] = cljs.core.rest((state_23998[(4)])));

return statearr_24002;
})();
var state_23998__$1 = state_23998;
var statearr_24003_24076 = state_23998__$1;
(statearr_24003_24076[(2)] = inst_23993);

(statearr_24003_24076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23999 === (3))){
var inst_23996 = (state_23998[(2)]);
var state_23998__$1 = state_23998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23998__$1,inst_23996);
} else {
if((state_val_23999 === (4))){
var inst_23987 = (state_23998[(2)]);
var state_23998__$1 = state_23998;
var statearr_24005_24077 = state_23998__$1;
(statearr_24005_24077[(2)] = inst_23987);

(statearr_24005_24077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23999 === (5))){
var _ = (function (){var statearr_24006 = state_23998;
(statearr_24006[(4)] = cljs.core.rest((state_23998[(4)])));

return statearr_24006;
})();
var state_23998__$1 = state_23998;
var ex24004 = (state_23998__$1[(2)]);
var statearr_24007_24078 = state_23998__$1;
(statearr_24007_24078[(5)] = ex24004);


if((ex24004 instanceof Error)){
var statearr_24008_24079 = state_23998__$1;
(statearr_24008_24079[(1)] = (4));

(statearr_24008_24079[(5)] = null);

} else {
throw ex24004;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24009 = [null,null,null,null,null,null,null];
(statearr_24009[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24009[(1)] = (1));

return statearr_24009;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_23998){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23998);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24010){var ex__2417__auto__ = e24010;
var statearr_24011_24080 = state_23998;
(statearr_24011_24080[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23998[(4)]))){
var statearr_24012_24081 = state_23998;
(statearr_24012_24081[(1)] = cljs.core.first((state_23998[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24082 = state_23998;
state_23998 = G__24082;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_23998){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_23998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24013 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24013[(6)] = c__2436__auto____$1);

return statearr_24013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto____$1;
});
}
});
})();
var inst_23813 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23812,select);
var state_23885__$1 = state_23885;
var statearr_24014_24083 = state_23885__$1;
(statearr_24014_24083[(2)] = inst_23813);

(statearr_24014_24083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (5))){
var _ = (function (){var statearr_24015 = state_23885;
(statearr_24015[(4)] = cljs.core.rest((state_23885[(4)])));

return statearr_24015;
})();
var state_23885__$1 = state_23885;
var ex23924 = (state_23885__$1[(2)]);
var statearr_24016_24084 = state_23885__$1;
(statearr_24016_24084[(5)] = ex23924);


if((ex23924 instanceof Error)){
var statearr_24017_24085 = state_23885__$1;
(statearr_24017_24085[(1)] = (4));

(statearr_24017_24085[(5)] = null);

} else {
throw ex23924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (14))){
var inst_23880 = (state_23885[(2)]);
var _ = (function (){var statearr_24018 = state_23885;
(statearr_24018[(4)] = cljs.core.rest((state_23885[(4)])));

return statearr_24018;
})();
var state_23885__$1 = state_23885;
var statearr_24019_24086 = state_23885__$1;
(statearr_24019_24086[(2)] = inst_23880);

(statearr_24019_24086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (10))){
var inst_23810 = (state_23885[(7)]);
var inst_23815 = (function (){var pp = inst_23810;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_23816 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23815,select);
var state_23885__$1 = state_23885;
var statearr_24020_24087 = state_23885__$1;
(statearr_24020_24087[(2)] = inst_23816);

(statearr_24020_24087[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (8))){
var inst_23810 = (state_23885[(2)]);
var state_23885__$1 = (function (){var statearr_24021 = state_23885;
(statearr_24021[(7)] = inst_23810);

return statearr_24021;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24022_24088 = state_23885__$1;
(statearr_24022_24088[(1)] = (9));

} else {
var statearr_24023_24089 = state_23885__$1;
(statearr_24023_24089[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0 = (function (){
var statearr_24024 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24024[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__);

(statearr_24024[(1)] = (1));

return statearr_24024;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1 = (function (state_23885){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_23885);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24025){var ex__2417__auto__ = e24025;
var statearr_24026_24090 = state_23885;
(statearr_24026_24090[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_23885[(4)]))){
var statearr_24027_24091 = state_23885;
(statearr_24027_24091[(1)] = cljs.core.first((state_23885[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24092 = state_23885;
state_23885 = G__24092;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__ = function(state_23885){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1.call(this,state_23885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24028 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24028[(6)] = c__2436__auto__);

return statearr_24028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24094 = arguments.length;
switch (G__24094) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24095,p__24096,group_limit,opts){
var map__24097 = p__24095;
var map__24097__$1 = (((((!((map__24097 == null))))?(((((map__24097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24097):map__24097);
var res = map__24097__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24097__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24098 = p__24096;
var map__24098__$1 = (((((!((map__24098 == null))))?(((((map__24098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24098):map__24098);
var select_spec = map__24098__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24098__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24210){
var state_val_24211 = (state_24210[(1)]);
if((state_val_24211 === (7))){
var inst_24107 = (state_24210[(7)]);
var state_24210__$1 = state_24210;
var statearr_24212_24292 = state_24210__$1;
(statearr_24212_24292[(2)] = inst_24107);

(statearr_24212_24292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (20))){
var inst_24142 = (state_24210[(2)]);
var state_24210__$1 = (function (){var statearr_24213 = state_24210;
(statearr_24213[(8)] = inst_24142);

return statearr_24213;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24214_24293 = state_24210__$1;
(statearr_24214_24293[(1)] = (21));

} else {
var statearr_24215_24294 = state_24210__$1;
(statearr_24215_24294[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (27))){
var inst_24151 = (state_24210[(9)]);
var inst_24156 = inst_24151.cljs$lang$protocol_mask$partition0$;
var inst_24157 = (inst_24156 & (64));
var inst_24158 = inst_24151.cljs$core$ISeq$;
var inst_24159 = (cljs.core.PROTOCOL_SENTINEL === inst_24158);
var inst_24160 = ((inst_24157) || (inst_24159));
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24160)){
var statearr_24216_24295 = state_24210__$1;
(statearr_24216_24295[(1)] = (30));

} else {
var statearr_24217_24296 = state_24210__$1;
(statearr_24217_24296[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (1))){
var state_24210__$1 = state_24210;
var statearr_24218_24297 = state_24210__$1;
(statearr_24218_24297[(2)] = null);

(statearr_24218_24297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (24))){
var inst_24142 = (state_24210[(8)]);
var inst_24146 = (state_24210[(10)]);
var inst_24148 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_24142,inst_24146,group_limit);
var state_24210__$1 = state_24210;
var statearr_24219_24298 = state_24210__$1;
(statearr_24219_24298[(2)] = inst_24148);

(statearr_24219_24298[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (39))){
var inst_24177 = (state_24210[(11)]);
var state_24210__$1 = state_24210;
var statearr_24220_24299 = state_24210__$1;
(statearr_24220_24299[(2)] = inst_24177);

(statearr_24220_24299[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (46))){
var inst_24195 = (state_24210[(12)]);
var inst_24197 = cljs.core.PersistentVector.EMPTY;
var inst_24198 = cljs.core.PersistentHashSet.EMPTY;
var inst_24199 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24198,inst_24195);
var inst_24200 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24197,inst_24199);
var state_24210__$1 = state_24210;
var statearr_24221_24300 = state_24210__$1;
(statearr_24221_24300[(2)] = inst_24200);

(statearr_24221_24300[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (4))){
var inst_24101 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24222_24301 = state_24210__$1;
(statearr_24222_24301[(2)] = inst_24101);

(statearr_24222_24301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (15))){
var inst_24128 = (state_24210[(13)]);
var inst_24130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24131 = [inst_24128];
var inst_24132 = (new cljs.core.PersistentVector(null,1,(5),inst_24130,inst_24131,null));
var state_24210__$1 = state_24210;
var statearr_24223_24302 = state_24210__$1;
(statearr_24223_24302[(2)] = inst_24132);

(statearr_24223_24302[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (48))){
var inst_24203 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24224_24303 = state_24210__$1;
(statearr_24224_24303[(2)] = inst_24203);

(statearr_24224_24303[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (21))){
var state_24210__$1 = state_24210;
var statearr_24225_24304 = state_24210__$1;
(statearr_24225_24304[(2)] = (0));

(statearr_24225_24304[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (31))){
var state_24210__$1 = state_24210;
var statearr_24226_24305 = state_24210__$1;
(statearr_24226_24305[(2)] = false);

(statearr_24226_24305[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (32))){
var inst_24164 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24227_24306 = state_24210__$1;
(statearr_24227_24306[(2)] = inst_24164);

(statearr_24227_24306[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (40))){
var inst_24146 = (state_24210[(10)]);
var state_24210__$1 = state_24210;
var statearr_24228_24307 = state_24210__$1;
(statearr_24228_24307[(2)] = inst_24146);

(statearr_24228_24307[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (33))){
var inst_24151 = (state_24210[(9)]);
var inst_24169 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_24151);
var state_24210__$1 = state_24210;
var statearr_24229_24308 = state_24210__$1;
(statearr_24229_24308[(2)] = inst_24169);

(statearr_24229_24308[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (13))){
var inst_24117 = (state_24210[(14)]);
var state_24210__$1 = state_24210;
var statearr_24230_24309 = state_24210__$1;
(statearr_24230_24309[(2)] = inst_24117);

(statearr_24230_24309[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (22))){
var state_24210__$1 = state_24210;
var statearr_24231_24310 = state_24210__$1;
(statearr_24231_24310[(2)] = offset);

(statearr_24231_24310[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (36))){
var inst_24177 = (state_24210[(11)]);
var inst_24177__$1 = limit;
var state_24210__$1 = (function (){var statearr_24232 = state_24210;
(statearr_24232[(11)] = inst_24177__$1);

return statearr_24232;
})();
if(cljs.core.truth_(inst_24177__$1)){
var statearr_24233_24311 = state_24210__$1;
(statearr_24233_24311[(1)] = (39));

} else {
var statearr_24234_24312 = state_24210__$1;
(statearr_24234_24312[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (41))){
var inst_24181 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24235_24313 = state_24210__$1;
(statearr_24235_24313[(2)] = inst_24181);

(statearr_24235_24313[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (43))){
var inst_24174 = (state_24210[(15)]);
var state_24210__$1 = state_24210;
var statearr_24236_24314 = state_24210__$1;
(statearr_24236_24314[(2)] = inst_24174);

(statearr_24236_24314[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (29))){
var inst_24167 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24167)){
var statearr_24237_24315 = state_24210__$1;
(statearr_24237_24315[(1)] = (33));

} else {
var statearr_24238_24316 = state_24210__$1;
(statearr_24238_24316[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (44))){
var inst_24173 = (state_24210[(16)]);
var inst_24190 = (state_24210[(2)]);
var inst_24191 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24192 = fluree.db.query.fql.format_filter_tuples(db,inst_24190,select_spec,inst_24173,vars,inst_24191);
var state_24210__$1 = state_24210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24210__$1,(45),inst_24192);
} else {
if((state_val_24211 === (6))){
var inst_24109 = cljs.core.count(select);
var inst_24110 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24109);
var state_24210__$1 = state_24210;
var statearr_24239_24317 = state_24210__$1;
(statearr_24239_24317[(2)] = inst_24110);

(statearr_24239_24317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (28))){
var state_24210__$1 = state_24210;
var statearr_24240_24318 = state_24210__$1;
(statearr_24240_24318[(2)] = false);

(statearr_24240_24318[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (25))){
var inst_24142 = (state_24210[(8)]);
var state_24210__$1 = state_24210;
var statearr_24241_24319 = state_24210__$1;
(statearr_24241_24319[(2)] = inst_24142);

(statearr_24241_24319[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (34))){
var inst_24151 = (state_24210[(9)]);
var state_24210__$1 = state_24210;
var statearr_24242_24320 = state_24210__$1;
(statearr_24242_24320[(2)] = inst_24151);

(statearr_24242_24320[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (17))){
var inst_24135 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24243_24321 = state_24210__$1;
(statearr_24243_24321[(2)] = inst_24135);

(statearr_24243_24321[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (3))){
var inst_24208 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24210__$1,inst_24208);
} else {
if((state_val_24211 === (12))){
var inst_24117 = (state_24210[(14)]);
var inst_24119 = cljs.core.first(select);
var inst_24120 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24119);
var inst_24121 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24120);
var inst_24122 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24121,(1));
var inst_24123 = [inst_24122];
var inst_24124 = [inst_24117];
var inst_24125 = cljs.core.PersistentHashMap.fromArrays(inst_24123,inst_24124);
var state_24210__$1 = state_24210;
var statearr_24244_24322 = state_24210__$1;
(statearr_24244_24322[(2)] = inst_24125);

(statearr_24244_24322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (2))){
var inst_24107 = (state_24210[(7)]);
var _ = (function (){var statearr_24245 = state_24210;
(statearr_24245[(4)] = cljs.core.cons((5),(state_24210[(4)])));

return statearr_24245;
})();
var inst_24107__$1 = aggregates;
var state_24210__$1 = (function (){var statearr_24246 = state_24210;
(statearr_24246[(7)] = inst_24107__$1);

return statearr_24246;
})();
if(cljs.core.truth_(inst_24107__$1)){
var statearr_24247_24323 = state_24210__$1;
(statearr_24247_24323[(1)] = (6));

} else {
var statearr_24248_24324 = state_24210__$1;
(statearr_24248_24324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (23))){
var inst_24146 = (state_24210[(2)]);
var state_24210__$1 = (function (){var statearr_24249 = state_24210;
(statearr_24249[(10)] = inst_24146);

return statearr_24249;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24250_24325 = state_24210__$1;
(statearr_24250_24325[(1)] = (24));

} else {
var statearr_24251_24326 = state_24210__$1;
(statearr_24251_24326[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (47))){
var inst_24195 = (state_24210[(12)]);
var state_24210__$1 = state_24210;
var statearr_24252_24327 = state_24210__$1;
(statearr_24252_24327[(2)] = inst_24195);

(statearr_24252_24327[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (35))){
var inst_24172 = (state_24210[(2)]);
var inst_24173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24172,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24172,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24175 = cljs.core.not(orderBy);
var state_24210__$1 = (function (){var statearr_24253 = state_24210;
(statearr_24253[(15)] = inst_24174);

(statearr_24253[(16)] = inst_24173);

return statearr_24253;
})();
if(inst_24175){
var statearr_24254_24328 = state_24210__$1;
(statearr_24254_24328[(1)] = (36));

} else {
var statearr_24255_24329 = state_24210__$1;
(statearr_24255_24329[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (19))){
var state_24210__$1 = state_24210;
var statearr_24256_24330 = state_24210__$1;
(statearr_24256_24330[(2)] = res);

(statearr_24256_24330[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (11))){
var inst_24205 = (state_24210[(2)]);
var _ = (function (){var statearr_24258 = state_24210;
(statearr_24258[(4)] = cljs.core.rest((state_24210[(4)])));

return statearr_24258;
})();
var state_24210__$1 = state_24210;
var statearr_24259_24331 = state_24210__$1;
(statearr_24259_24331[(2)] = inst_24205);

(statearr_24259_24331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (9))){
var inst_24115 = cljs.core.first(aggregates);
var inst_24116 = fluree.db.query.analytical.calculate_aggregate(res,inst_24115);
var inst_24117 = cljs.core.second(inst_24116);
var state_24210__$1 = (function (){var statearr_24260 = state_24210;
(statearr_24260[(14)] = inst_24117);

return statearr_24260;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24261_24332 = state_24210__$1;
(statearr_24261_24332[(1)] = (12));

} else {
var statearr_24262_24333 = state_24210__$1;
(statearr_24262_24333[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (5))){
var _ = (function (){var statearr_24263 = state_24210;
(statearr_24263[(4)] = cljs.core.rest((state_24210[(4)])));

return statearr_24263;
})();
var state_24210__$1 = state_24210;
var ex24257 = (state_24210__$1[(2)]);
var statearr_24264_24334 = state_24210__$1;
(statearr_24264_24334[(5)] = ex24257);


if((ex24257 instanceof Error)){
var statearr_24265_24335 = state_24210__$1;
(statearr_24265_24335[(1)] = (4));

(statearr_24265_24335[(5)] = null);

} else {
throw ex24257;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (14))){
var inst_24128 = (state_24210[(2)]);
var state_24210__$1 = (function (){var statearr_24266 = state_24210;
(statearr_24266[(13)] = inst_24128);

return statearr_24266;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24267_24336 = state_24210__$1;
(statearr_24267_24336[(1)] = (15));

} else {
var statearr_24268_24337 = state_24210__$1;
(statearr_24268_24337[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (45))){
var inst_24194 = (state_24210[(2)]);
var inst_24195 = fluree.db.util.async.throw_err(inst_24194);
var state_24210__$1 = (function (){var statearr_24269 = state_24210;
(statearr_24269[(12)] = inst_24195);

return statearr_24269;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24270_24338 = state_24210__$1;
(statearr_24270_24338[(1)] = (46));

} else {
var statearr_24271_24339 = state_24210__$1;
(statearr_24271_24339[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (26))){
var inst_24151 = (state_24210[(9)]);
var inst_24151__$1 = (state_24210[(2)]);
var inst_24153 = (inst_24151__$1 == null);
var inst_24154 = cljs.core.not(inst_24153);
var state_24210__$1 = (function (){var statearr_24272 = state_24210;
(statearr_24272[(9)] = inst_24151__$1);

return statearr_24272;
})();
if(inst_24154){
var statearr_24273_24340 = state_24210__$1;
(statearr_24273_24340[(1)] = (27));

} else {
var statearr_24274_24341 = state_24210__$1;
(statearr_24274_24341[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (16))){
var inst_24128 = (state_24210[(13)]);
var state_24210__$1 = state_24210;
var statearr_24275_24342 = state_24210__$1;
(statearr_24275_24342[(2)] = inst_24128);

(statearr_24275_24342[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (38))){
var inst_24184 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24184)){
var statearr_24276_24343 = state_24210__$1;
(statearr_24276_24343[(1)] = (42));

} else {
var statearr_24277_24344 = state_24210__$1;
(statearr_24277_24344[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (30))){
var state_24210__$1 = state_24210;
var statearr_24278_24345 = state_24210__$1;
(statearr_24278_24345[(2)] = true);

(statearr_24278_24345[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (10))){
var state_24210__$1 = state_24210;
if(cljs.core.truth_(aggregates)){
var statearr_24279_24346 = state_24210__$1;
(statearr_24279_24346[(1)] = (18));

} else {
var statearr_24280_24347 = state_24210__$1;
(statearr_24280_24347[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (18))){
var inst_24139 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24210__$1 = state_24210;
var statearr_24281_24348 = state_24210__$1;
(statearr_24281_24348[(2)] = inst_24139);

(statearr_24281_24348[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (42))){
var inst_24174 = (state_24210[(15)]);
var inst_24146 = (state_24210[(10)]);
var inst_24186 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_24146,inst_24174);
var inst_24187 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24186);
var state_24210__$1 = state_24210;
var statearr_24282_24349 = state_24210__$1;
(statearr_24282_24349[(2)] = inst_24187);

(statearr_24282_24349[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (37))){
var state_24210__$1 = state_24210;
var statearr_24283_24350 = state_24210__$1;
(statearr_24283_24350[(2)] = false);

(statearr_24283_24350[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (8))){
var inst_24113 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inst_24113)){
var statearr_24284_24351 = state_24210__$1;
(statearr_24284_24351[(1)] = (9));

} else {
var statearr_24285_24352 = state_24210__$1;
(statearr_24285_24352[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2414__auto__ = null;
var fluree$db$query$fql$state_machine__2414__auto____0 = (function (){
var statearr_24286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24286[(0)] = fluree$db$query$fql$state_machine__2414__auto__);

(statearr_24286[(1)] = (1));

return statearr_24286;
});
var fluree$db$query$fql$state_machine__2414__auto____1 = (function (state_24210){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24210);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24287){var ex__2417__auto__ = e24287;
var statearr_24288_24353 = state_24210;
(statearr_24288_24353[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24210[(4)]))){
var statearr_24289_24354 = state_24210;
(statearr_24289_24354[(1)] = cljs.core.first((state_24210[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24355 = state_24210;
state_24210 = G__24355;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2414__auto__ = function(state_24210){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2414__auto____1.call(this,state_24210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2414__auto____0;
fluree$db$query$fql$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2414__auto____1;
return fluree$db$query$fql$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24290 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24290[(6)] = c__2436__auto__);

return statearr_24290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24358,groupBy){
var map__24359 = p__24358;
var map__24359__$1 = (((((!((map__24359 == null))))?(((((map__24359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24359.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24359):map__24359);
var res = map__24359__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24359__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24359__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24361 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24361,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24361,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24356_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24356_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24357_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24357_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__24364,p__24365,opts){
var map__24366 = p__24364;
var map__24366__$1 = (((((!((map__24366 == null))))?(((((map__24366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24366):map__24366);
var res = map__24366__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24366__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24366__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24367 = p__24365;
var map__24367__$1 = (((((!((map__24367 == null))))?(((((map__24367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24367.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24367):map__24367);
var select_spec = map__24367__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24367__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24592){
var state_val_24593 = (state_24592[(1)]);
if((state_val_24593 === (65))){
var inst_24554 = (state_24592[(2)]);
var inst_24555 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_24554,opts);
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24592__$1,(66),inst_24555);
} else {
if((state_val_24593 === (70))){
var inst_24558 = (state_24592[(7)]);
var inst_24563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24564 = [inst_24558];
var inst_24565 = (new cljs.core.PersistentVector(null,1,(5),inst_24563,inst_24564,null));
var state_24592__$1 = state_24592;
var statearr_24594_24717 = state_24592__$1;
(statearr_24594_24717[(2)] = inst_24565);

(statearr_24594_24717[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (62))){
var inst_24547 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24595_24718 = state_24592__$1;
(statearr_24595_24718[(2)] = inst_24547);

(statearr_24595_24718[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (74))){
var state_24592__$1 = state_24592;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24596_24719 = state_24592__$1;
(statearr_24596_24719[(1)] = (76));

} else {
var statearr_24597_24720 = state_24592__$1;
(statearr_24597_24720[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (7))){
var state_24592__$1 = state_24592;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24598_24721 = state_24592__$1;
(statearr_24598_24721[(1)] = (63));

} else {
var statearr_24599_24722 = state_24592__$1;
(statearr_24599_24722[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (59))){
var inst_24480 = (state_24592[(8)]);
var inst_24471 = (state_24592[(9)]);
var inst_24523 = (state_24592[(2)]);
var inst_24524 = fluree.db.util.async.throw_err(inst_24523);
var inst_24525 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24471,inst_24480,inst_24524);
var state_24592__$1 = state_24592;
var statearr_24600_24723 = state_24592__$1;
(statearr_24600_24723[(2)] = inst_24525);

(statearr_24600_24723[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (20))){
var inst_24424 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24601_24724 = state_24592__$1;
(statearr_24601_24724[(2)] = inst_24424);

(statearr_24601_24724[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (72))){
var inst_24568 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24602_24725 = state_24592__$1;
(statearr_24602_24725[(2)] = inst_24568);

(statearr_24602_24725[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (58))){
var inst_24528 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24603_24726 = state_24592__$1;
(statearr_24603_24726[(2)] = inst_24528);

(statearr_24603_24726[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (60))){
var inst_24541 = (state_24592[(10)]);
var inst_24426 = (state_24592[(11)]);
var inst_24543 = cljs.core.sorted_map_by(inst_24426);
var inst_24544 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24543,inst_24541);
var state_24592__$1 = state_24592;
var statearr_24604_24727 = state_24592__$1;
(statearr_24604_24727[(2)] = inst_24544);

(statearr_24604_24727[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (27))){
var inst_24407 = (state_24592[(12)]);
var inst_24377 = (state_24592[(13)]);
var inst_24408 = (state_24592[(14)]);
var inst_24411 = (function (){var group_map = inst_24377;
var orderByIdx = inst_24407;
var orderDirection = inst_24408;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
})();
var state_24592__$1 = state_24592;
var statearr_24605_24728 = state_24592__$1;
(statearr_24605_24728[(2)] = inst_24411);

(statearr_24605_24728[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (1))){
var state_24592__$1 = state_24592;
var statearr_24606_24729 = state_24592__$1;
(statearr_24606_24729[(2)] = null);

(statearr_24606_24729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (69))){
var inst_24585 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24607_24730 = state_24592__$1;
(statearr_24607_24730[(2)] = inst_24585);

(statearr_24607_24730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (24))){
var inst_24408 = (state_24592[(14)]);
var inst_24406 = cljs.core.second(orderBy);
var inst_24407 = fluree.db.util.core.index_of(groupBy,inst_24406);
var inst_24408__$1 = cljs.core.first(orderBy);
var inst_24409 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_24408__$1);
var state_24592__$1 = (function (){var statearr_24608 = state_24592;
(statearr_24608[(12)] = inst_24407);

(statearr_24608[(14)] = inst_24408__$1);

return statearr_24608;
})();
if(inst_24409){
var statearr_24609_24731 = state_24592__$1;
(statearr_24609_24731[(1)] = (27));

} else {
var statearr_24610_24732 = state_24592__$1;
(statearr_24610_24732[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (55))){
var inst_24480 = (state_24592[(8)]);
var inst_24471 = (state_24592[(9)]);
var inst_24512 = (state_24592[(2)]);
var inst_24513 = fluree.db.util.async.throw_err(inst_24512);
var inst_24514 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24471,inst_24480,inst_24513);
var state_24592__$1 = state_24592;
var statearr_24611_24733 = state_24592__$1;
(statearr_24611_24733[(2)] = inst_24514);

(statearr_24611_24733[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (39))){
var inst_24471 = (state_24592[(9)]);
var state_24592__$1 = state_24592;
var statearr_24612_24734 = state_24592__$1;
(statearr_24612_24734[(2)] = inst_24471);

(statearr_24612_24734[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (46))){
var state_24592__$1 = state_24592;
var statearr_24613_24735 = state_24592__$1;
(statearr_24613_24735[(2)] = null);

(statearr_24613_24735[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (4))){
var inst_24370 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24614_24736 = state_24592__$1;
(statearr_24614_24736[(2)] = inst_24370);

(statearr_24614_24736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (77))){
var state_24592__$1 = state_24592;
var statearr_24615_24737 = state_24592__$1;
(statearr_24615_24737[(1)] = (79));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (54))){
var inst_24530 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24617_24738 = state_24592__$1;
(statearr_24617_24738[(2)] = inst_24530);

(statearr_24617_24738[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (15))){
var inst_24377 = (state_24592[(13)]);
var inst_24389 = (function (){var group_map = inst_24377;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
})();
var state_24592__$1 = state_24592;
var statearr_24618_24739 = state_24592__$1;
(statearr_24618_24739[(2)] = inst_24389);

(statearr_24618_24739[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (48))){
var inst_24498 = (state_24592[(15)]);
var inst_24501 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_24498,select_spec,opts);
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24592__$1,(51),inst_24501);
} else {
if((state_val_24593 === (50))){
var inst_24532 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24619_24740 = state_24592__$1;
(statearr_24619_24740[(2)] = inst_24532);

(statearr_24619_24740[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (75))){
var inst_24583 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24620_24741 = state_24592__$1;
(statearr_24620_24741[(2)] = inst_24583);

(statearr_24620_24741[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (21))){
var inst_24399 = cljs.core.set(groupBy);
var inst_24400 = cljs.core.second(orderBy);
var inst_24401 = (inst_24399.cljs$core$IFn$_invoke$arity$1 ? inst_24399.cljs$core$IFn$_invoke$arity$1(inst_24400) : inst_24399.call(null,inst_24400));
var state_24592__$1 = state_24592;
var statearr_24621_24742 = state_24592__$1;
(statearr_24621_24742[(2)] = inst_24401);

(statearr_24621_24742[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (31))){
var state_24592__$1 = state_24592;
var statearr_24622_24743 = state_24592__$1;
(statearr_24622_24743[(2)] = null);

(statearr_24622_24743[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (32))){
var inst_24420 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24623_24744 = state_24592__$1;
(statearr_24623_24744[(2)] = inst_24420);

(statearr_24623_24744[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (40))){
var inst_24470 = (state_24592[(16)]);
var inst_24488 = (inst_24470 > (0));
var state_24592__$1 = state_24592;
if(cljs.core.truth_(inst_24488)){
var statearr_24624_24745 = state_24592__$1;
(statearr_24624_24745[(1)] = (42));

} else {
var statearr_24625_24746 = state_24592__$1;
(statearr_24625_24746[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (56))){
var inst_24498 = (state_24592[(15)]);
var inst_24483 = (state_24592[(17)]);
var inst_24495 = (state_24592[(18)]);
var inst_24518 = cljs.core.count(inst_24483);
var inst_24519 = (inst_24495 - limit);
var inst_24520 = (inst_24518 - inst_24519);
var inst_24521 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_24498,select_spec,inst_24520,opts);
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24592__$1,(59),inst_24521);
} else {
if((state_val_24593 === (33))){
var inst_24377 = (state_24592[(13)]);
var inst_24428 = cljs.core.keys(inst_24377);
var inst_24429 = cljs.core.first(inst_24428);
var inst_24430 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24431 = cljs.core.vals(inst_24377);
var inst_24432 = cljs.core.first(inst_24431);
var inst_24433 = [headers,vars,inst_24432];
var inst_24434 = cljs.core.PersistentHashMap.fromArrays(inst_24430,inst_24433);
var inst_24435 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_24434,select_spec,limit,opts);
var state_24592__$1 = (function (){var statearr_24626 = state_24592;
(statearr_24626[(19)] = inst_24429);

return statearr_24626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24592__$1,(36),inst_24435);
} else {
if((state_val_24593 === (13))){
var inst_24394 = cljs.core.not(orderBy);
var state_24592__$1 = state_24592;
if(inst_24394){
var statearr_24627_24747 = state_24592__$1;
(statearr_24627_24747[(1)] = (18));

} else {
var statearr_24628_24748 = state_24592__$1;
(statearr_24628_24748[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (22))){
var inst_24397 = (state_24592[(20)]);
var state_24592__$1 = state_24592;
var statearr_24629_24749 = state_24592__$1;
(statearr_24629_24749[(2)] = inst_24397);

(statearr_24629_24749[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (36))){
var inst_24429 = (state_24592[(19)]);
var inst_24437 = (state_24592[(2)]);
var inst_24438 = fluree.db.util.async.throw_err(inst_24437);
var inst_24439 = [inst_24429];
var inst_24440 = [inst_24438];
var inst_24441 = cljs.core.PersistentHashMap.fromArrays(inst_24439,inst_24440);
var state_24592__$1 = state_24592;
var statearr_24630_24750 = state_24592__$1;
(statearr_24630_24750[(2)] = inst_24441);

(statearr_24630_24750[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (41))){
var inst_24539 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24631_24751 = state_24592__$1;
(statearr_24631_24751[(2)] = inst_24539);

(statearr_24631_24751[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (43))){
var state_24592__$1 = state_24592;
var statearr_24632_24752 = state_24592__$1;
(statearr_24632_24752[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (61))){
var inst_24541 = (state_24592[(10)]);
var state_24592__$1 = state_24592;
var statearr_24634_24753 = state_24592__$1;
(statearr_24634_24753[(2)] = inst_24541);

(statearr_24634_24753[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (29))){
var inst_24415 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24635_24754 = state_24592__$1;
(statearr_24635_24754[(2)] = inst_24415);

(statearr_24635_24754[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (44))){
var inst_24537 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24636_24755 = state_24592__$1;
(statearr_24636_24755[(2)] = inst_24537);

(statearr_24636_24755[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (6))){
var inst_24378 = (state_24592[(21)]);
var inst_24377 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var inst_24378__$1 = orderBy;
var state_24592__$1 = (function (){var statearr_24637 = state_24592;
(statearr_24637[(13)] = inst_24377);

(statearr_24637[(21)] = inst_24378__$1);

return statearr_24637;
})();
if(cljs.core.truth_(inst_24378__$1)){
var statearr_24638_24756 = state_24592__$1;
(statearr_24638_24756[(1)] = (9));

} else {
var statearr_24639_24757 = state_24592__$1;
(statearr_24639_24757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (28))){
var inst_24407 = (state_24592[(12)]);
var inst_24377 = (state_24592[(13)]);
var inst_24408 = (state_24592[(14)]);
var inst_24413 = (function (){var group_map = inst_24377;
var orderByIdx = inst_24407;
var orderDirection = inst_24408;
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
})();
var state_24592__$1 = state_24592;
var statearr_24641_24758 = state_24592__$1;
(statearr_24641_24758[(2)] = inst_24413);

(statearr_24641_24758[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (64))){
var state_24592__$1 = state_24592;
var statearr_24642_24759 = state_24592__$1;
(statearr_24642_24759[(2)] = limit);

(statearr_24642_24759[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (51))){
var inst_24484 = (state_24592[(22)]);
var inst_24470 = (state_24592[(16)]);
var inst_24481 = (state_24592[(23)]);
var inst_24480 = (state_24592[(8)]);
var inst_24495 = (state_24592[(18)]);
var inst_24471 = (state_24592[(9)]);
var inst_24503 = (state_24592[(2)]);
var inst_24504 = fluree.db.util.async.throw_err(inst_24503);
var inst_24505 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24471,inst_24480,inst_24504);
var tmp24640 = inst_24470;
var inst_24467 = inst_24481;
var inst_24468 = inst_24484;
var inst_24469 = inst_24495;
var inst_24470__$1 = tmp24640;
var inst_24471__$1 = inst_24505;
var state_24592__$1 = (function (){var statearr_24643 = state_24592;
(statearr_24643[(16)] = inst_24470__$1);

(statearr_24643[(24)] = inst_24469);

(statearr_24643[(25)] = inst_24468);

(statearr_24643[(9)] = inst_24471__$1);

(statearr_24643[(26)] = inst_24467);

return statearr_24643;
})();
var statearr_24644_24760 = state_24592__$1;
(statearr_24644_24760[(2)] = null);

(statearr_24644_24760[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (25))){
var state_24592__$1 = state_24592;
var statearr_24645_24761 = state_24592__$1;
(statearr_24645_24761[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (34))){
var inst_24377 = (state_24592[(13)]);
var inst_24457 = cljs.core.keys(inst_24377);
var inst_24458 = cljs.core.seq(inst_24457);
var inst_24459 = cljs.core.first(inst_24458);
var inst_24460 = cljs.core.next(inst_24458);
var inst_24461 = cljs.core.vals(inst_24377);
var inst_24462 = cljs.core.seq(inst_24461);
var inst_24463 = cljs.core.first(inst_24462);
var inst_24464 = cljs.core.next(inst_24462);
var inst_24465 = offset;
var inst_24466 = cljs.core.PersistentHashMap.EMPTY;
var inst_24467 = inst_24457;
var inst_24468 = inst_24461;
var inst_24469 = (0);
var inst_24470 = inst_24465;
var inst_24471 = inst_24466;
var state_24592__$1 = (function (){var statearr_24647 = state_24592;
(statearr_24647[(16)] = inst_24470);

(statearr_24647[(24)] = inst_24469);

(statearr_24647[(27)] = inst_24463);

(statearr_24647[(28)] = inst_24459);

(statearr_24647[(25)] = inst_24468);

(statearr_24647[(9)] = inst_24471);

(statearr_24647[(26)] = inst_24467);

(statearr_24647[(29)] = inst_24464);

(statearr_24647[(30)] = inst_24460);

return statearr_24647;
})();
var statearr_24648_24762 = state_24592__$1;
(statearr_24648_24762[(2)] = null);

(statearr_24648_24762[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (17))){
var inst_24392 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24649_24763 = state_24592__$1;
(statearr_24649_24763[(2)] = inst_24392);

(statearr_24649_24763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (3))){
var inst_24590 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24592__$1,inst_24590);
} else {
if((state_val_24593 === (12))){
var inst_24386 = cljs.core.first(orderBy);
var inst_24387 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24386,"DESC");
var state_24592__$1 = state_24592;
if(inst_24387){
var statearr_24650_24764 = state_24592__$1;
(statearr_24650_24764[(1)] = (15));

} else {
var statearr_24651_24765 = state_24592__$1;
(statearr_24651_24765[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (2))){
var _ = (function (){var statearr_24652 = state_24592;
(statearr_24652[(4)] = cljs.core.cons((5),(state_24592[(4)])));

return statearr_24652;
})();
var state_24592__$1 = state_24592;
if(cljs.core.truth_(groupBy)){
var statearr_24653_24766 = state_24592__$1;
(statearr_24653_24766[(1)] = (6));

} else {
var statearr_24654_24767 = state_24592__$1;
(statearr_24654_24767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (66))){
var inst_24558 = (state_24592[(7)]);
var inst_24557 = (state_24592[(2)]);
var inst_24558__$1 = fluree.db.util.async.throw_err(inst_24557);
var inst_24559 = cljs.core.coll_QMARK_(inst_24558__$1);
var inst_24560 = (!(inst_24559));
var state_24592__$1 = (function (){var statearr_24655 = state_24592;
(statearr_24655[(7)] = inst_24558__$1);

return statearr_24655;
})();
if(inst_24560){
var statearr_24656_24768 = state_24592__$1;
(statearr_24656_24768[(1)] = (67));

} else {
var statearr_24657_24769 = state_24592__$1;
(statearr_24657_24769[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (23))){
var inst_24404 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
if(cljs.core.truth_(inst_24404)){
var statearr_24658_24770 = state_24592__$1;
(statearr_24658_24770[(1)] = (24));

} else {
var statearr_24659_24771 = state_24592__$1;
(statearr_24659_24771[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (47))){
var inst_24535 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24660_24772 = state_24592__$1;
(statearr_24660_24772[(2)] = inst_24535);

(statearr_24660_24772[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (35))){
var inst_24549 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24661_24773 = state_24592__$1;
(statearr_24661_24773[(2)] = inst_24549);

(statearr_24661_24773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (76))){
var inst_24558 = (state_24592[(7)]);
var inst_24574 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_24558);
var state_24592__$1 = state_24592;
var statearr_24662_24774 = state_24592__$1;
(statearr_24662_24774[(2)] = inst_24574);

(statearr_24662_24774[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (19))){
var inst_24397 = (state_24592[(20)]);
var inst_24397__$1 = orderBy;
var state_24592__$1 = (function (){var statearr_24663 = state_24592;
(statearr_24663[(20)] = inst_24397__$1);

return statearr_24663;
})();
if(cljs.core.truth_(inst_24397__$1)){
var statearr_24664_24775 = state_24592__$1;
(statearr_24664_24775[(1)] = (21));

} else {
var statearr_24665_24776 = state_24592__$1;
(statearr_24665_24776[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (57))){
var state_24592__$1 = state_24592;
var statearr_24666_24777 = state_24592__$1;
(statearr_24666_24777[(2)] = null);

(statearr_24666_24777[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (68))){
var state_24592__$1 = state_24592;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24667_24778 = state_24592__$1;
(statearr_24667_24778[(1)] = (73));

} else {
var statearr_24668_24779 = state_24592__$1;
(statearr_24668_24779[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (11))){
var inst_24384 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
if(cljs.core.truth_(inst_24384)){
var statearr_24670_24780 = state_24592__$1;
(statearr_24670_24780[(1)] = (12));

} else {
var statearr_24671_24781 = state_24592__$1;
(statearr_24671_24781[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (9))){
var inst_24380 = cljs.core.second(orderBy);
var inst_24381 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24380,groupBy);
var state_24592__$1 = state_24592;
var statearr_24672_24782 = state_24592__$1;
(statearr_24672_24782[(2)] = inst_24381);

(statearr_24672_24782[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (5))){
var _ = (function (){var statearr_24673 = state_24592;
(statearr_24673[(4)] = cljs.core.rest((state_24592[(4)])));

return statearr_24673;
})();
var state_24592__$1 = state_24592;
var ex24669 = (state_24592__$1[(2)]);
var statearr_24674_24783 = state_24592__$1;
(statearr_24674_24783[(5)] = ex24669);


if((ex24669 instanceof Error)){
var statearr_24675_24784 = state_24592__$1;
(statearr_24675_24784[(1)] = (4));

(statearr_24675_24784[(5)] = null);

} else {
throw ex24669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (14))){
var inst_24426 = (state_24592[(2)]);
var state_24592__$1 = (function (){var statearr_24676 = state_24592;
(statearr_24676[(11)] = inst_24426);

return statearr_24676;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24677_24785 = state_24592__$1;
(statearr_24677_24785[(1)] = (33));

} else {
var statearr_24678_24786 = state_24592__$1;
(statearr_24678_24786[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (45))){
var inst_24469 = (state_24592[(24)]);
var inst_24483 = (state_24592[(17)]);
var inst_24495 = (state_24592[(18)]);
var inst_24494 = cljs.core.count(inst_24483);
var inst_24495__$1 = (inst_24469 + inst_24494);
var inst_24496 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24497 = [headers,vars,inst_24483];
var inst_24498 = cljs.core.PersistentHashMap.fromArrays(inst_24496,inst_24497);
var inst_24499 = (limit > inst_24495__$1);
var state_24592__$1 = (function (){var statearr_24679 = state_24592;
(statearr_24679[(15)] = inst_24498);

(statearr_24679[(18)] = inst_24495__$1);

return statearr_24679;
})();
if(cljs.core.truth_(inst_24499)){
var statearr_24680_24787 = state_24592__$1;
(statearr_24680_24787[(1)] = (48));

} else {
var statearr_24681_24788 = state_24592__$1;
(statearr_24681_24788[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (53))){
var inst_24495 = (state_24592[(18)]);
var inst_24516 = (limit < inst_24495);
var state_24592__$1 = state_24592;
if(cljs.core.truth_(inst_24516)){
var statearr_24682_24789 = state_24592__$1;
(statearr_24682_24789[(1)] = (56));

} else {
var statearr_24683_24790 = state_24592__$1;
(statearr_24683_24790[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (78))){
var inst_24581 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24684_24791 = state_24592__$1;
(statearr_24684_24791[(2)] = inst_24581);

(statearr_24684_24791[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (26))){
var inst_24422 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24685_24792 = state_24592__$1;
(statearr_24685_24792[(2)] = inst_24422);

(statearr_24685_24792[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (16))){
var state_24592__$1 = state_24592;
var statearr_24686_24793 = state_24592__$1;
(statearr_24686_24793[(2)] = fluree.db.query.fql.compare_fn);

(statearr_24686_24793[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (81))){
var inst_24579 = (state_24592[(2)]);
var state_24592__$1 = state_24592;
var statearr_24687_24794 = state_24592__$1;
(statearr_24687_24794[(2)] = inst_24579);

(statearr_24687_24794[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (79))){
var inst_24558 = (state_24592[(7)]);
var state_24592__$1 = state_24592;
var statearr_24688_24795 = state_24592__$1;
(statearr_24688_24795[(2)] = inst_24558);

(statearr_24688_24795[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (38))){
var inst_24426 = (state_24592[(11)]);
var inst_24541 = (state_24592[(2)]);
var state_24592__$1 = (function (){var statearr_24689 = state_24592;
(statearr_24689[(10)] = inst_24541);

return statearr_24689;
})();
if(cljs.core.truth_(inst_24426)){
var statearr_24690_24796 = state_24592__$1;
(statearr_24690_24796[(1)] = (60));

} else {
var statearr_24691_24797 = state_24592__$1;
(statearr_24691_24797[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (30))){
var state_24592__$1 = state_24592;
var statearr_24692_24798 = state_24592__$1;
(statearr_24692_24798[(2)] = null);

(statearr_24692_24798[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (73))){
var inst_24558 = (state_24592[(7)]);
var inst_24571 = cljs.core.first(inst_24558);
var state_24592__$1 = state_24592;
var statearr_24693_24799 = state_24592__$1;
(statearr_24693_24799[(2)] = inst_24571);

(statearr_24693_24799[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (10))){
var inst_24378 = (state_24592[(21)]);
var state_24592__$1 = state_24592;
var statearr_24694_24800 = state_24592__$1;
(statearr_24694_24800[(2)] = inst_24378);

(statearr_24694_24800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (18))){
var state_24592__$1 = state_24592;
var statearr_24695_24801 = state_24592__$1;
(statearr_24695_24801[(2)] = null);

(statearr_24695_24801[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (52))){
var inst_24498 = (state_24592[(15)]);
var inst_24510 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_24498,select_spec,opts);
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24592__$1,(55),inst_24510);
} else {
if((state_val_24593 === (67))){
var state_24592__$1 = state_24592;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24698_24802 = state_24592__$1;
(statearr_24698_24802[(1)] = (70));

} else {
var statearr_24699_24803 = state_24592__$1;
(statearr_24699_24803[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (71))){
var inst_24558 = (state_24592[(7)]);
var state_24592__$1 = state_24592;
var statearr_24700_24804 = state_24592__$1;
(statearr_24700_24804[(2)] = inst_24558);

(statearr_24700_24804[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (42))){
var inst_24484 = (state_24592[(22)]);
var inst_24470 = (state_24592[(16)]);
var inst_24469 = (state_24592[(24)]);
var inst_24481 = (state_24592[(23)]);
var inst_24471 = (state_24592[(9)]);
var inst_24490 = (inst_24470 - (1));
var tmp24696 = inst_24469;
var tmp24697 = inst_24471;
var inst_24467 = inst_24481;
var inst_24468 = inst_24484;
var inst_24469__$1 = tmp24696;
var inst_24470__$1 = inst_24490;
var inst_24471__$1 = tmp24697;
var state_24592__$1 = (function (){var statearr_24701 = state_24592;
(statearr_24701[(16)] = inst_24470__$1);

(statearr_24701[(24)] = inst_24469__$1);

(statearr_24701[(25)] = inst_24468);

(statearr_24701[(9)] = inst_24471__$1);

(statearr_24701[(26)] = inst_24467);

return statearr_24701;
})();
var statearr_24702_24805 = state_24592__$1;
(statearr_24702_24805[(2)] = null);

(statearr_24702_24805[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (80))){
var state_24592__$1 = state_24592;
var statearr_24703_24806 = state_24592__$1;
(statearr_24703_24806[(2)] = null);

(statearr_24703_24806[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (37))){
var inst_24483 = (state_24592[(17)]);
var inst_24468 = (state_24592[(25)]);
var inst_24467 = (state_24592[(26)]);
var inst_24479 = cljs.core.seq(inst_24467);
var inst_24480 = cljs.core.first(inst_24479);
var inst_24481 = cljs.core.next(inst_24479);
var inst_24482 = cljs.core.seq(inst_24468);
var inst_24483__$1 = cljs.core.first(inst_24482);
var inst_24484 = cljs.core.next(inst_24482);
var inst_24485 = (inst_24483__$1 == null);
var state_24592__$1 = (function (){var statearr_24704 = state_24592;
(statearr_24704[(22)] = inst_24484);

(statearr_24704[(23)] = inst_24481);

(statearr_24704[(17)] = inst_24483__$1);

(statearr_24704[(8)] = inst_24480);

return statearr_24704;
})();
if(cljs.core.truth_(inst_24485)){
var statearr_24705_24807 = state_24592__$1;
(statearr_24705_24807[(1)] = (39));

} else {
var statearr_24706_24808 = state_24592__$1;
(statearr_24706_24808[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (63))){
var state_24592__$1 = state_24592;
var statearr_24707_24809 = state_24592__$1;
(statearr_24707_24809[(2)] = (1));

(statearr_24707_24809[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (8))){
var inst_24587 = (state_24592[(2)]);
var _ = (function (){var statearr_24708 = state_24592;
(statearr_24708[(4)] = cljs.core.rest((state_24592[(4)])));

return statearr_24708;
})();
var state_24592__$1 = state_24592;
var statearr_24709_24810 = state_24592__$1;
(statearr_24709_24810[(2)] = inst_24587);

(statearr_24709_24810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24593 === (49))){
var inst_24495 = (state_24592[(18)]);
var inst_24508 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_24495);
var state_24592__$1 = state_24592;
if(inst_24508){
var statearr_24710_24811 = state_24592__$1;
(statearr_24710_24811[(1)] = (52));

} else {
var statearr_24711_24812 = state_24592__$1;
(statearr_24711_24812[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0 = (function (){
var statearr_24712 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24712[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__);

(statearr_24712[(1)] = (1));

return statearr_24712;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1 = (function (state_24592){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24592);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24713){var ex__2417__auto__ = e24713;
var statearr_24714_24813 = state_24592;
(statearr_24714_24813[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24592[(4)]))){
var statearr_24715_24814 = state_24592;
(statearr_24715_24814[(1)] = cljs.core.first((state_24592[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24815 = state_24592;
state_24592 = G__24815;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__ = function(state_24592){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1.call(this,state_24592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24716 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24716[(6)] = c__2436__auto__);

return statearr_24716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__24818,opts){
var map__24819 = p__24818;
var map__24819__$1 = (((((!((map__24819 == null))))?(((((map__24819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24819):map__24819);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24819__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__24816_SHARP_){
return cljs.core.contains_QMARK_(p1__24816_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__24817_SHARP_){
return cljs.core.contains_QMARK_(p1__24817_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__24828 = cljs.core.first(orderBy);
var fexpr__24827 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__24827.cljs$core$IFn$_invoke$arity$1 ? fexpr__24827.cljs$core$IFn$_invoke$arity$1(G__24828) : fexpr__24827.call(null,G__24828));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__24829,p__24830){
var map__24831 = p__24829;
var map__24831__$1 = (((((!((map__24831 == null))))?(((((map__24831.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24831.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24831):map__24831);
var query_map = map__24831__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24831__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__24832 = p__24830;
var map__24832__$1 = (((((!((map__24832 == null))))?(((((map__24832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24832.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24832):map__24832);
var where_result = map__24832__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24832__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24832__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24835 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24835,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24835,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24835,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_24868){
var state_val_24869 = (state_24868[(1)]);
if((state_val_24869 === (7))){
var inst_24847 = (state_24868[(7)]);
var state_24868__$1 = state_24868;
var statearr_24870_24893 = state_24868__$1;
(statearr_24870_24893[(2)] = inst_24847);

(statearr_24870_24893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (1))){
var state_24868__$1 = state_24868;
var statearr_24871_24894 = state_24868__$1;
(statearr_24871_24894[(2)] = null);

(statearr_24871_24894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (4))){
var inst_24838 = (state_24868[(2)]);
var state_24868__$1 = state_24868;
var statearr_24872_24895 = state_24868__$1;
(statearr_24872_24895[(2)] = inst_24838);

(statearr_24872_24895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (13))){
var inst_24857 = (state_24868[(2)]);
var inst_24858 = fluree.db.util.async.throw_err(inst_24857);
var state_24868__$1 = state_24868;
var statearr_24873_24896 = state_24868__$1;
(statearr_24873_24896[(2)] = inst_24858);

(statearr_24873_24896[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (6))){
var inst_24847 = (state_24868[(7)]);
var inst_24846 = (state_24868[(2)]);
var inst_24847__$1 = fluree.db.util.async.throw_err(inst_24846);
var inst_24848 = fluree.db.util.core.exception_QMARK_(inst_24847__$1);
var state_24868__$1 = (function (){var statearr_24874 = state_24868;
(statearr_24874[(7)] = inst_24847__$1);

return statearr_24874;
})();
if(inst_24848){
var statearr_24875_24897 = state_24868__$1;
(statearr_24875_24897[(1)] = (7));

} else {
var statearr_24876_24898 = state_24868__$1;
(statearr_24876_24898[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (3))){
var inst_24866 = (state_24868[(2)]);
var state_24868__$1 = state_24868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24868__$1,inst_24866);
} else {
if((state_val_24869 === (12))){
var inst_24861 = (state_24868[(2)]);
var state_24868__$1 = state_24868;
var statearr_24877_24899 = state_24868__$1;
(statearr_24877_24899[(2)] = inst_24861);

(statearr_24877_24899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (2))){
var _ = (function (){var statearr_24878 = state_24868;
(statearr_24878[(4)] = cljs.core.cons((5),(state_24868[(4)])));

return statearr_24878;
})();
var inst_24844 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_24868__$1 = state_24868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24868__$1,(6),inst_24844);
} else {
if((state_val_24869 === (11))){
var state_24868__$1 = state_24868;
var statearr_24880_24900 = state_24868__$1;
(statearr_24880_24900[(2)] = null);

(statearr_24880_24900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (9))){
var inst_24863 = (state_24868[(2)]);
var _ = (function (){var statearr_24881 = state_24868;
(statearr_24881[(4)] = cljs.core.rest((state_24868[(4)])));

return statearr_24881;
})();
var state_24868__$1 = state_24868;
var statearr_24882_24901 = state_24868__$1;
(statearr_24882_24901[(2)] = inst_24863);

(statearr_24882_24901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (5))){
var _ = (function (){var statearr_24883 = state_24868;
(statearr_24883[(4)] = cljs.core.rest((state_24868[(4)])));

return statearr_24883;
})();
var state_24868__$1 = state_24868;
var ex24879 = (state_24868__$1[(2)]);
var statearr_24884_24902 = state_24868__$1;
(statearr_24884_24902[(5)] = ex24879);


if((ex24879 instanceof Error)){
var statearr_24885_24903 = state_24868__$1;
(statearr_24885_24903[(1)] = (4));

(statearr_24885_24903[(5)] = null);

} else {
throw ex24879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24869 === (10))){
var inst_24847 = (state_24868[(7)]);
var inst_24852 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_24847);
var inst_24853 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_24847);
var inst_24854 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_24852,inst_24853,query_map,opts);
var inst_24855 = fluree.db.query.fql.process_ad_hoc_res(db,inst_24847,inst_24854,opts);
var state_24868__$1 = state_24868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24868__$1,(13),inst_24855);
} else {
if((state_val_24869 === (8))){
var state_24868__$1 = state_24868;
var statearr_24886_24904 = state_24868__$1;
(statearr_24886_24904[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0 = (function (){
var statearr_24888 = [null,null,null,null,null,null,null,null];
(statearr_24888[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__);

(statearr_24888[(1)] = (1));

return statearr_24888;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1 = (function (state_24868){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_24868);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e24889){var ex__2417__auto__ = e24889;
var statearr_24890_24905 = state_24868;
(statearr_24890_24905[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_24868[(4)]))){
var statearr_24891_24906 = state_24868;
(statearr_24891_24906[(1)] = cljs.core.first((state_24868[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24907 = state_24868;
state_24868 = G__24907;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__ = function(state_24868){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1.call(this,state_24868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_24892 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_24892[(6)] = c__2436__auto__);

return statearr_24892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__24908 = query_map;
var map__24908__$1 = (((((!((map__24908 == null))))?(((((map__24908.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24908.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24908):map__24908);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24908__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__24910 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__24910,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__24910;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_25281){
var state_val_25282 = (state_25281[(1)]);
if((state_val_25282 === (121))){
var inst_24992 = (state_25281[(7)]);
var inst_25226 = (state_25281[(8)]);
var inst_24994 = (state_25281[(9)]);
var inst_25222 = (state_25281[(10)]);
var inst_25230 = (state_25281[(2)]);
var inst_25231 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_24994,fuel,max_fuel,inst_24992,inst_25222,inst_25226,inst_25230);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(115),inst_25231);
} else {
if((state_val_25282 === (65))){
var inst_25071 = (state_25281[(11)]);
var inst_24982 = (state_25281[(12)]);
var inst_24992 = (state_25281[(7)]);
var inst_24994 = (state_25281[(9)]);
var inst_25085 = (state_25281[(2)]);
var inst_25086 = fluree.db.util.async.throw_err(inst_25085);
var inst_25087 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_25071,inst_25086);
var inst_25088 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_24994,fuel,max_fuel,inst_24992,inst_25087,inst_24982);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(66),inst_25088);
} else {
if((state_val_25282 === (70))){
var inst_24981 = (state_25281[(13)]);
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_24981)){
var statearr_25283_25475 = state_25281__$1;
(statearr_25283_25475[(1)] = (73));

} else {
var statearr_25284_25476 = state_25281__$1;
(statearr_25284_25476[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (62))){
var inst_25073 = cljs.core.PersistentHashMap.EMPTY;
var state_25281__$1 = state_25281;
var statearr_25285_25477 = state_25281__$1;
(statearr_25285_25477[(2)] = inst_25073);

(statearr_25285_25477[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (74))){
var inst_24982 = (state_25281[(12)]);
var inst_24984 = (state_25281[(14)]);
var inst_25107 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25108 = [inst_24982,inst_24984];
var inst_25109 = cljs.core.PersistentHashMap.fromArrays(inst_25107,inst_25108);
var state_25281__$1 = state_25281;
var statearr_25286_25478 = state_25281__$1;
(statearr_25286_25478[(2)] = inst_25109);

(statearr_25286_25478[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (110))){
var inst_25190 = (state_25281[(15)]);
var inst_25204 = (state_25281[(2)]);
var inst_25205 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_25190,false);
var state_25281__$1 = (function (){var statearr_25287 = state_25281;
(statearr_25287[(16)] = inst_25204);

return statearr_25287;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(111),inst_25205);
} else {
if((state_val_25282 === (130))){
var inst_25271 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25271)){
var statearr_25288_25479 = state_25281__$1;
(statearr_25288_25479[(1)] = (131));

} else {
var statearr_25289_25480 = state_25281__$1;
(statearr_25289_25480[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (128))){
var inst_25262 = (state_25281[(17)]);
var inst_25265 = cljs.core.coll_QMARK_(inst_25262);
var inst_25266 = fluree.db.util.core.exception_QMARK_(inst_25262);
var inst_25267 = (!(inst_25266));
var inst_25268 = ((inst_25265) && (inst_25267));
var state_25281__$1 = state_25281;
var statearr_25290_25481 = state_25281__$1;
(statearr_25290_25481[(2)] = inst_25268);

(statearr_25290_25481[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (7))){
var inst_24942 = (state_25281[(18)]);
var inst_24942__$1 = selectOne;
var state_25281__$1 = (function (){var statearr_25291 = state_25281;
(statearr_25291[(18)] = inst_24942__$1);

return statearr_25291;
})();
if(cljs.core.truth_(inst_24942__$1)){
var statearr_25292_25482 = state_25281__$1;
(statearr_25292_25482[(1)] = (9));

} else {
var statearr_25293_25483 = state_25281__$1;
(statearr_25293_25483[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (59))){
var inst_25065 = (state_25281[(19)]);
var inst_25067 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25068 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25065,inst_25067);
var state_25281__$1 = state_25281;
var statearr_25294_25484 = state_25281__$1;
(statearr_25294_25484[(2)] = inst_25068);

(statearr_25294_25484[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (86))){
var inst_25143 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(89),inst_25143);
} else {
if((state_val_25282 === (20))){
var inst_24972 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25295_25485 = state_25281__$1;
(statearr_25295_25485[(2)] = inst_24972);

(statearr_25295_25485[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (72))){
var inst_25253 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25296_25486 = state_25281__$1;
(statearr_25296_25486[(2)] = inst_25253);

(statearr_25296_25486[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (58))){
var inst_25065 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25297 = state_25281;
(statearr_25297[(19)] = inst_25065);

return statearr_25297;
})();
var statearr_25298_25487 = state_25281__$1;
(statearr_25298_25487[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (60))){
var inst_25065 = (state_25281[(19)]);
var state_25281__$1 = state_25281;
var statearr_25300_25488 = state_25281__$1;
(statearr_25300_25488[(2)] = inst_25065);

(statearr_25300_25488[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (27))){
var inst_24981 = (state_25281[(13)]);
var inst_24996 = cljs.core.vector_QMARK_(inst_24981);
var state_25281__$1 = state_25281;
if(inst_24996){
var statearr_25301_25489 = state_25281__$1;
(statearr_25301_25489[(1)] = (30));

} else {
var statearr_25302_25490 = state_25281__$1;
(statearr_25302_25490[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (1))){
var state_25281__$1 = state_25281;
var statearr_25303_25491 = state_25281__$1;
(statearr_25303_25491[(2)] = null);

(statearr_25303_25491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (69))){
var inst_25102 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25102)){
var statearr_25304_25492 = state_25281__$1;
(statearr_25304_25492[(1)] = (70));

} else {
var statearr_25305_25493 = state_25281__$1;
(statearr_25305_25493[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (101))){
var inst_24981 = (state_25281[(13)]);
var inst_25220 = (state_25281[(2)]);
var inst_25221 = cljs.core.PersistentVector.EMPTY;
var inst_25222 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25221,inst_25220);
var state_25281__$1 = (function (){var statearr_25306 = state_25281;
(statearr_25306[(10)] = inst_25222);

return statearr_25306;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25307_25494 = state_25281__$1;
(statearr_25307_25494[(1)] = (116));

} else {
var statearr_25308_25495 = state_25281__$1;
(statearr_25308_25495[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (24))){
var inst_24983 = (state_25281[(20)]);
var inst_24985 = (state_25281[(21)]);
var inst_24989 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24985,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_24983);
var state_25281__$1 = state_25281;
var statearr_25309_25496 = state_25281__$1;
(statearr_25309_25496[(2)] = inst_24989);

(statearr_25309_25496[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (102))){
var inst_25184 = (state_25281[(22)]);
var state_25281__$1 = state_25281;
var statearr_25310_25497 = state_25281__$1;
(statearr_25310_25497[(2)] = inst_25184);

(statearr_25310_25497[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (55))){
var inst_25255 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25311_25498 = state_25281__$1;
(statearr_25311_25498[(2)] = inst_25255);

(statearr_25311_25498[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (85))){
var inst_25137 = (state_25281[(2)]);
var inst_25138 = fluree.db.util.async.throw_err(inst_25137);
var state_25281__$1 = state_25281;
var statearr_25312_25499 = state_25281__$1;
(statearr_25312_25499[(2)] = inst_25138);

(statearr_25312_25499[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (39))){
var inst_25031 = typeof from === 'string';
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25031)){
var statearr_25313_25500 = state_25281__$1;
(statearr_25313_25500[(1)] = (42));

} else {
var statearr_25314_25501 = state_25281__$1;
(statearr_25314_25501[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (88))){
var inst_25249 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25315_25502 = state_25281__$1;
(statearr_25315_25502[(2)] = inst_25249);

(statearr_25315_25502[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (46))){
var inst_25050 = (state_25281[(2)]);
var inst_25051 = fluree.db.util.async.throw_err(inst_25050);
var state_25281__$1 = state_25281;
var statearr_25316_25503 = state_25281__$1;
(statearr_25316_25503[(2)] = inst_25051);

(statearr_25316_25503[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (4))){
var inst_24929 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25317_25504 = state_25281__$1;
(statearr_25317_25504[(2)] = inst_24929);

(statearr_25317_25504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (77))){
var inst_25118 = (state_25281[(2)]);
var inst_25119 = fluree.db.util.async.throw_err(inst_25118);
var state_25281__$1 = state_25281;
var statearr_25318_25505 = state_25281__$1;
(statearr_25318_25505[(2)] = inst_25119);

(statearr_25318_25505[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (106))){
var state_25281__$1 = state_25281;
if(cljs.core.truth_(fuel)){
var statearr_25319_25506 = state_25281__$1;
(statearr_25319_25506[(1)] = (108));

} else {
var statearr_25320_25507 = state_25281__$1;
(statearr_25320_25507[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (119))){
var state_25281__$1 = state_25281;
var statearr_25321_25508 = state_25281__$1;
(statearr_25321_25508[(2)] = null);

(statearr_25321_25508[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (95))){
var state_25281__$1 = state_25281;
var statearr_25322_25509 = state_25281__$1;
(statearr_25322_25509[(2)] = null);

(statearr_25322_25509[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (54))){
var inst_25094 = typeof from === 'string';
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25094)){
var statearr_25323_25510 = state_25281__$1;
(statearr_25323_25510[(1)] = (67));

} else {
var statearr_25324_25511 = state_25281__$1;
(statearr_25324_25511[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (92))){
var inst_24982 = (state_25281[(12)]);
var inst_24992 = (state_25281[(7)]);
var inst_24984 = (state_25281[(14)]);
var inst_24994 = (state_25281[(9)]);
var inst_25154 = (state_25281[(2)]);
var inst_25155 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_24994,fuel,max_fuel,inst_24992,inst_25154,inst_24982,inst_24984);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(93),inst_25155);
} else {
if((state_val_25282 === (104))){
var inst_25218 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25325_25512 = state_25281__$1;
(statearr_25325_25512[(2)] = inst_25218);

(statearr_25325_25512[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (15))){
var inst_24959 = (state_25281[(23)]);
var inst_24964 = inst_24959.cljs$lang$protocol_mask$partition0$;
var inst_24965 = (inst_24964 & (64));
var inst_24966 = inst_24959.cljs$core$ISeq$;
var inst_24967 = (cljs.core.PROTOCOL_SENTINEL === inst_24966);
var inst_24968 = ((inst_24965) || (inst_24967));
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_24968)){
var statearr_25326_25513 = state_25281__$1;
(statearr_25326_25513[(1)] = (18));

} else {
var statearr_25327_25514 = state_25281__$1;
(statearr_25327_25514[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (48))){
var inst_24982 = (state_25281[(12)]);
var state_25281__$1 = state_25281;
var statearr_25328_25515 = state_25281__$1;
(statearr_25328_25515[(2)] = inst_24982);

(statearr_25328_25515[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (50))){
var state_25281__$1 = state_25281;
var statearr_25329_25516 = state_25281__$1;
(statearr_25329_25516[(2)] = null);

(statearr_25329_25516[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (116))){
var state_25281__$1 = state_25281;
var statearr_25330_25517 = state_25281__$1;
(statearr_25330_25517[(2)] = null);

(statearr_25330_25517[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (75))){
var inst_25111 = (state_25281[(2)]);
var inst_25112 = fluree.db.query.range._block_or_tx_collection(db,inst_25111);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(76),inst_25112);
} else {
if((state_val_25282 === (99))){
var inst_25247 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25331_25518 = state_25281__$1;
(statearr_25331_25518[(2)] = inst_25247);

(statearr_25331_25518[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (21))){
var inst_24959 = (state_25281[(23)]);
var inst_24977 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_24959);
var state_25281__$1 = state_25281;
var statearr_25332_25519 = state_25281__$1;
(statearr_25332_25519[(2)] = inst_24977);

(statearr_25332_25519[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (31))){
var inst_24981 = (state_25281[(13)]);
var inst_25004 = typeof inst_24981 === 'string';
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25004)){
var statearr_25333_25520 = state_25281__$1;
(statearr_25333_25520[(1)] = (33));

} else {
var statearr_25334_25521 = state_25281__$1;
(statearr_25334_25521[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (113))){
var inst_25184 = (state_25281[(22)]);
var state_25281__$1 = state_25281;
var statearr_25335_25522 = state_25281__$1;
(statearr_25335_25522[(2)] = inst_25184);

(statearr_25335_25522[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (32))){
var inst_25020 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25336_25523 = state_25281__$1;
(statearr_25336_25523[(2)] = inst_25020);

(statearr_25336_25523[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (40))){
var inst_25053 = typeof from === 'string';
var inst_25054 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25055 = clojure.string.includes_QMARK_(inst_25054,"/");
var inst_25056 = ((inst_25053) && (inst_25055));
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25056)){
var statearr_25337_25524 = state_25281__$1;
(statearr_25337_25524[(1)] = (53));

} else {
var statearr_25338_25525 = state_25281__$1;
(statearr_25338_25525[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (129))){
var inst_25263 = (state_25281[(24)]);
var state_25281__$1 = state_25281;
var statearr_25339_25526 = state_25281__$1;
(statearr_25339_25526[(2)] = inst_25263);

(statearr_25339_25526[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (91))){
var inst_25146 = (state_25281[(25)]);
var inst_25150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25151 = [inst_25146];
var inst_25152 = (new cljs.core.PersistentVector(null,1,(5),inst_25150,inst_25151,null));
var state_25281__$1 = state_25281;
var statearr_25340_25527 = state_25281__$1;
(statearr_25340_25527[(2)] = inst_25152);

(statearr_25340_25527[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (117))){
var inst_24982 = (state_25281[(12)]);
var state_25281__$1 = state_25281;
var statearr_25341_25528 = state_25281__$1;
(statearr_25341_25528[(2)] = inst_24982);

(statearr_25341_25528[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (108))){
var inst_25199 = cljs.core._deref(fuel);
var inst_25200 = (inst_25199 + (1));
var inst_25201 = cljs.core._vreset_BANG_(fuel,inst_25200);
var state_25281__$1 = state_25281;
var statearr_25342_25529 = state_25281__$1;
(statearr_25342_25529[(2)] = inst_25201);

(statearr_25342_25529[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (56))){
var inst_25059 = (state_25281[(26)]);
var inst_25061 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_25062 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25059,inst_25061);
var state_25281__$1 = state_25281;
var statearr_25343_25530 = state_25281__$1;
(statearr_25343_25530[(2)] = inst_25062);

(statearr_25343_25530[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (33))){
var inst_24981 = (state_25281[(13)]);
var inst_25006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25007 = [inst_24981,"ASC"];
var inst_25008 = (new cljs.core.PersistentVector(null,2,(5),inst_25006,inst_25007,null));
var state_25281__$1 = state_25281;
var statearr_25344_25531 = state_25281__$1;
(statearr_25344_25531[(2)] = inst_25008);

(statearr_25344_25531[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (13))){
var inst_24948 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24949 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24950 = cljs.core.PersistentHashMap.fromArrays(inst_24948,inst_24949);
var inst_24951 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_24950);
var inst_24952 = (function(){throw inst_24951})();
var state_25281__$1 = state_25281;
var statearr_25345_25532 = state_25281__$1;
(statearr_25345_25532[(2)] = inst_24952);

(statearr_25345_25532[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (22))){
var inst_24959 = (state_25281[(23)]);
var state_25281__$1 = state_25281;
var statearr_25346_25533 = state_25281__$1;
(statearr_25346_25533[(2)] = inst_24959);

(statearr_25346_25533[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (90))){
var state_25281__$1 = state_25281;
var statearr_25347_25534 = state_25281__$1;
(statearr_25347_25534[(2)] = null);

(statearr_25347_25534[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (109))){
var state_25281__$1 = state_25281;
var statearr_25348_25535 = state_25281__$1;
(statearr_25348_25535[(2)] = null);

(statearr_25348_25535[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (36))){
var inst_25011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25012 = [null,null];
var inst_25013 = (new cljs.core.PersistentVector(null,2,(5),inst_25011,inst_25012,null));
var state_25281__$1 = state_25281;
var statearr_25349_25536 = state_25281__$1;
(statearr_25349_25536[(2)] = inst_25013);

(statearr_25349_25536[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (41))){
var inst_25027 = (state_25281[(27)]);
var inst_25257 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25350 = state_25281;
(statearr_25350[(28)] = inst_25257);

return statearr_25350;
})();
if(cljs.core.truth_(inst_25027)){
var statearr_25351_25537 = state_25281__$1;
(statearr_25351_25537[(1)] = (125));

} else {
var statearr_25352_25538 = state_25281__$1;
(statearr_25352_25538[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (118))){
var inst_24981 = (state_25281[(13)]);
var inst_25226 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25353 = state_25281;
(statearr_25353[(8)] = inst_25226);

return statearr_25353;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25354_25539 = state_25281__$1;
(statearr_25354_25539[(1)] = (119));

} else {
var statearr_25355_25540 = state_25281__$1;
(statearr_25355_25540[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (89))){
var inst_25146 = (state_25281[(25)]);
var inst_25145 = (state_25281[(2)]);
var inst_25146__$1 = fluree.db.util.async.throw_err(inst_25145);
var inst_25147 = (inst_25146__$1 == null);
var state_25281__$1 = (function (){var statearr_25356 = state_25281;
(statearr_25356[(25)] = inst_25146__$1);

return statearr_25356;
})();
if(cljs.core.truth_(inst_25147)){
var statearr_25357_25541 = state_25281__$1;
(statearr_25357_25541[(1)] = (90));

} else {
var statearr_25358_25542 = state_25281__$1;
(statearr_25358_25542[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (100))){
var inst_25190 = (state_25281[(15)]);
var inst_25183 = (state_25281[(29)]);
var inst_25189 = cljs.core.seq(inst_25183);
var inst_25190__$1 = cljs.core.first(inst_25189);
var inst_25191 = cljs.core.next(inst_25189);
var inst_25192 = cljs.core.not(inst_25190__$1);
var state_25281__$1 = (function (){var statearr_25359 = state_25281;
(statearr_25359[(15)] = inst_25190__$1);

(statearr_25359[(30)] = inst_25191);

return statearr_25359;
})();
if(inst_25192){
var statearr_25360_25543 = state_25281__$1;
(statearr_25360_25543[(1)] = (102));

} else {
var statearr_25361_25544 = state_25281__$1;
(statearr_25361_25544[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (131))){
var inst_25262 = (state_25281[(17)]);
var inst_25273 = cljs.core.first(inst_25262);
var state_25281__$1 = state_25281;
var statearr_25362_25545 = state_25281__$1;
(statearr_25362_25545[(2)] = inst_25273);

(statearr_25362_25545[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (122))){
var inst_25237 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_25238 = ["Invalid 'from' in query:",inst_25237].join('');
var inst_25239 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25240 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25241 = cljs.core.PersistentHashMap.fromArrays(inst_25239,inst_25240);
var inst_25242 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25238,inst_25241);
var state_25281__$1 = state_25281;
var statearr_25363_25546 = state_25281__$1;
(statearr_25363_25546[(2)] = inst_25242);

(statearr_25363_25546[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (43))){
var state_25281__$1 = state_25281;
var statearr_25364_25547 = state_25281__$1;
(statearr_25364_25547[(2)] = null);

(statearr_25364_25547[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (61))){
var inst_24981 = (state_25281[(13)]);
var inst_25071 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25365 = state_25281;
(statearr_25365[(11)] = inst_25071);

return statearr_25365;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25366_25548 = state_25281__$1;
(statearr_25366_25548[(1)] = (62));

} else {
var statearr_25367_25549 = state_25281__$1;
(statearr_25367_25549[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (29))){
var inst_25026 = (state_25281[(2)]);
var inst_25027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25026,(0),null);
var inst_25028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25026,(1),null);
var inst_25029 = typeof where === 'string';
var state_25281__$1 = (function (){var statearr_25368 = state_25281;
(statearr_25368[(31)] = inst_25028);

(statearr_25368[(27)] = inst_25027);

return statearr_25368;
})();
if(cljs.core.truth_(inst_25029)){
var statearr_25369_25550 = state_25281__$1;
(statearr_25369_25550[(1)] = (39));

} else {
var statearr_25370_25551 = state_25281__$1;
(statearr_25370_25551[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (44))){
var inst_25035 = (state_25281[(2)]);
var inst_25036 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_25035);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(45),inst_25036);
} else {
if((state_val_25282 === (93))){
var inst_25157 = (state_25281[(2)]);
var inst_25158 = fluree.db.util.async.throw_err(inst_25157);
var state_25281__$1 = (function (){var statearr_25371 = state_25281;
(statearr_25371[(32)] = inst_25158);

return statearr_25371;
})();
if(cljs.core.truth_(fuel)){
var statearr_25372_25552 = state_25281__$1;
(statearr_25372_25552[(1)] = (94));

} else {
var statearr_25373_25553 = state_25281__$1;
(statearr_25373_25553[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (6))){
var inst_24939 = (state_25281[(33)]);
var state_25281__$1 = state_25281;
var statearr_25374_25554 = state_25281__$1;
(statearr_25374_25554[(2)] = inst_24939);

(statearr_25374_25554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (111))){
var inst_25207 = (state_25281[(2)]);
var inst_25208 = fluree.db.util.async.throw_err(inst_25207);
var state_25281__$1 = state_25281;
var statearr_25375_25555 = state_25281__$1;
(statearr_25375_25555[(2)] = inst_25208);

(statearr_25375_25555[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (28))){
var inst_25022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25023 = [null,null];
var inst_25024 = (new cljs.core.PersistentVector(null,2,(5),inst_25022,inst_25023,null));
var state_25281__$1 = state_25281;
var statearr_25376_25556 = state_25281__$1;
(statearr_25376_25556[(2)] = inst_25024);

(statearr_25376_25556[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (64))){
var inst_25079 = (state_25281[(2)]);
var inst_25080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25081 = [from];
var inst_25082 = (new cljs.core.PersistentVector(null,1,(5),inst_25080,inst_25081,null));
var inst_25083 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25082,inst_25079);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(65),inst_25083);
} else {
if((state_val_25282 === (103))){
var inst_25190 = (state_25281[(15)]);
var inst_25195 = cljs.core.int_QMARK_(inst_25190);
var state_25281__$1 = state_25281;
if(inst_25195){
var statearr_25377_25557 = state_25281__$1;
(statearr_25377_25557[(1)] = (105));

} else {
var statearr_25378_25558 = state_25281__$1;
(statearr_25378_25558[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (51))){
var inst_24984 = (state_25281[(14)]);
var state_25281__$1 = state_25281;
var statearr_25379_25559 = state_25281__$1;
(statearr_25379_25559[(2)] = inst_24984);

(statearr_25379_25559[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (25))){
var inst_24985 = (state_25281[(21)]);
var state_25281__$1 = state_25281;
var statearr_25380_25560 = state_25281__$1;
(statearr_25380_25560[(2)] = inst_24985);

(statearr_25380_25560[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (34))){
var state_25281__$1 = state_25281;
var statearr_25381_25561 = state_25281__$1;
(statearr_25381_25561[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (125))){
var inst_25257 = (state_25281[(28)]);
var inst_24982 = (state_25281[(12)]);
var inst_25028 = (state_25281[(31)]);
var inst_24984 = (state_25281[(14)]);
var inst_25027 = (state_25281[(27)]);
var inst_25259 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25027,inst_25028,inst_24984,inst_24982,inst_25257);
var state_25281__$1 = state_25281;
var statearr_25383_25562 = state_25281__$1;
(statearr_25383_25562[(2)] = inst_25259);

(statearr_25383_25562[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (17))){
var inst_24975 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_24975)){
var statearr_25384_25563 = state_25281__$1;
(statearr_25384_25563[(1)] = (21));

} else {
var statearr_25385_25564 = state_25281__$1;
(statearr_25385_25564[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (3))){
var inst_25279 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25281__$1,inst_25279);
} else {
if((state_val_25282 === (12))){
var inst_24945 = (state_25281[(34)]);
var state_25281__$1 = state_25281;
var statearr_25386_25565 = state_25281__$1;
(statearr_25386_25565[(2)] = inst_24945);

(statearr_25386_25565[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (2))){
var inst_24939 = (state_25281[(33)]);
var _ = (function (){var statearr_25387 = state_25281;
(statearr_25387[(4)] = cljs.core.cons((5),(state_25281[(4)])));

return statearr_25387;
})();
var inst_24939__$1 = select;
var state_25281__$1 = (function (){var statearr_25388 = state_25281;
(statearr_25388[(33)] = inst_24939__$1);

return statearr_25388;
})();
if(cljs.core.truth_(inst_24939__$1)){
var statearr_25389_25566 = state_25281__$1;
(statearr_25389_25566[(1)] = (6));

} else {
var statearr_25390_25567 = state_25281__$1;
(statearr_25390_25567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (66))){
var inst_25090 = (state_25281[(2)]);
var inst_25091 = fluree.db.util.async.throw_err(inst_25090);
var state_25281__$1 = state_25281;
var statearr_25391_25568 = state_25281__$1;
(statearr_25391_25568[(2)] = inst_25091);

(statearr_25391_25568[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (107))){
var inst_25210 = (state_25281[(35)]);
var inst_25210__$1 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25392 = state_25281;
(statearr_25392[(35)] = inst_25210__$1);

return statearr_25392;
})();
if(cljs.core.truth_(inst_25210__$1)){
var statearr_25393_25569 = state_25281__$1;
(statearr_25393_25569[(1)] = (112));

} else {
var statearr_25394_25570 = state_25281__$1;
(statearr_25394_25570[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (23))){
var inst_24958 = (state_25281[(36)]);
var inst_24983 = (state_25281[(20)]);
var inst_24980 = (state_25281[(2)]);
var inst_24981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24980,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_24982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24980,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24983__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24980,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_24984 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24980,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_24985 = fluree.db.query.fql_parser.parse_db(db,inst_24958,opts_SINGLEQUOTE_);
var inst_24986 = (inst_24983__$1 == null);
var inst_24987 = cljs.core.not(inst_24986);
var state_25281__$1 = (function (){var statearr_25395 = state_25281;
(statearr_25395[(13)] = inst_24981);

(statearr_25395[(12)] = inst_24982);

(statearr_25395[(14)] = inst_24984);

(statearr_25395[(20)] = inst_24983__$1);

(statearr_25395[(21)] = inst_24985);

return statearr_25395;
})();
if(inst_24987){
var statearr_25396_25571 = state_25281__$1;
(statearr_25396_25571[(1)] = (24));

} else {
var statearr_25397_25572 = state_25281__$1;
(statearr_25397_25572[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (47))){
var state_25281__$1 = state_25281;
var statearr_25398_25573 = state_25281__$1;
(statearr_25398_25573[(2)] = null);

(statearr_25398_25573[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (35))){
var inst_25018 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25399_25574 = state_25281__$1;
(statearr_25399_25574[(2)] = inst_25018);

(statearr_25399_25574[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (127))){
var inst_25263 = (state_25281[(24)]);
var inst_25262 = (state_25281[(2)]);
var inst_25263__$1 = selectOne;
var state_25281__$1 = (function (){var statearr_25400 = state_25281;
(statearr_25400[(24)] = inst_25263__$1);

(statearr_25400[(17)] = inst_25262);

return statearr_25400;
})();
if(cljs.core.truth_(inst_25263__$1)){
var statearr_25401_25575 = state_25281__$1;
(statearr_25401_25575[(1)] = (128));

} else {
var statearr_25402_25576 = state_25281__$1;
(statearr_25402_25576[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (82))){
var inst_24982 = (state_25281[(12)]);
var inst_24984 = (state_25281[(14)]);
var inst_25126 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25127 = [inst_24982,inst_24984];
var inst_25128 = cljs.core.PersistentHashMap.fromArrays(inst_25126,inst_25127);
var state_25281__$1 = state_25281;
var statearr_25403_25577 = state_25281__$1;
(statearr_25403_25577[(2)] = inst_25128);

(statearr_25403_25577[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (76))){
var inst_24992 = (state_25281[(7)]);
var inst_24994 = (state_25281[(9)]);
var inst_25114 = (state_25281[(2)]);
var inst_25115 = fluree.db.util.async.throw_err(inst_25114);
var inst_25116 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_24994,fuel,max_fuel,inst_24992,inst_25115);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(77),inst_25116);
} else {
if((state_val_25282 === (97))){
var inst_25178 = from;
var inst_25179 = cljs.core.seq(inst_25178);
var inst_25180 = cljs.core.first(inst_25179);
var inst_25181 = cljs.core.next(inst_25179);
var inst_25182 = cljs.core.PersistentVector.EMPTY;
var inst_25183 = inst_25178;
var inst_25184 = inst_25182;
var state_25281__$1 = (function (){var statearr_25404 = state_25281;
(statearr_25404[(37)] = inst_25181);

(statearr_25404[(22)] = inst_25184);

(statearr_25404[(29)] = inst_25183);

(statearr_25404[(38)] = inst_25180);

return statearr_25404;
})();
var statearr_25405_25578 = state_25281__$1;
(statearr_25405_25578[(2)] = null);

(statearr_25405_25578[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (19))){
var state_25281__$1 = state_25281;
var statearr_25406_25579 = state_25281__$1;
(statearr_25406_25579[(2)] = false);

(statearr_25406_25579[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (57))){
var inst_25059 = (state_25281[(26)]);
var state_25281__$1 = state_25281;
var statearr_25407_25580 = state_25281__$1;
(statearr_25407_25580[(2)] = inst_25059);

(statearr_25407_25580[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (68))){
var state_25281__$1 = state_25281;
var statearr_25408_25581 = state_25281__$1;
(statearr_25408_25581[(2)] = false);

(statearr_25408_25581[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (11))){
var inst_24956 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25409_25582 = state_25281__$1;
(statearr_25409_25582[(2)] = inst_24956);

(statearr_25409_25582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (115))){
var inst_25233 = (state_25281[(2)]);
var inst_25234 = fluree.db.util.async.throw_err(inst_25233);
var state_25281__$1 = state_25281;
var statearr_25411_25583 = state_25281__$1;
(statearr_25411_25583[(2)] = inst_25234);

(statearr_25411_25583[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (9))){
var inst_24942 = (state_25281[(18)]);
var state_25281__$1 = state_25281;
var statearr_25412_25584 = state_25281__$1;
(statearr_25412_25584[(2)] = inst_24942);

(statearr_25412_25584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (5))){
var _ = (function (){var statearr_25413 = state_25281;
(statearr_25413[(4)] = cljs.core.rest((state_25281[(4)])));

return statearr_25413;
})();
var state_25281__$1 = state_25281;
var ex25410 = (state_25281__$1[(2)]);
var statearr_25414_25585 = state_25281__$1;
(statearr_25414_25585[(5)] = ex25410);


if((ex25410 instanceof Error)){
var statearr_25415_25586 = state_25281__$1;
(statearr_25415_25586[(1)] = (4));

(statearr_25415_25586[(5)] = null);

} else {
throw ex25410;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (112))){
var inst_25210 = (state_25281[(35)]);
var inst_25184 = (state_25281[(22)]);
var inst_25212 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25184,inst_25210);
var state_25281__$1 = state_25281;
var statearr_25416_25587 = state_25281__$1;
(statearr_25416_25587[(2)] = inst_25212);

(statearr_25416_25587[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (83))){
var inst_25130 = (state_25281[(2)]);
var inst_25131 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_25130);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(84),inst_25131);
} else {
if((state_val_25282 === (14))){
var inst_24954 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25417_25588 = state_25281__$1;
(statearr_25417_25588[(2)] = inst_24954);

(statearr_25417_25588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (45))){
var inst_24981 = (state_25281[(13)]);
var inst_25038 = (state_25281[(2)]);
var inst_25039 = fluree.db.util.async.throw_err(inst_25038);
var state_25281__$1 = (function (){var statearr_25418 = state_25281;
(statearr_25418[(39)] = inst_25039);

return statearr_25418;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25419_25589 = state_25281__$1;
(statearr_25419_25589[(1)] = (47));

} else {
var statearr_25420_25590 = state_25281__$1;
(statearr_25420_25590[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (53))){
var inst_25059 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_25281__$1 = (function (){var statearr_25421 = state_25281;
(statearr_25421[(26)] = inst_25059);

return statearr_25421;
})();
if(cljs.core.truth_(fuel)){
var statearr_25422_25591 = state_25281__$1;
(statearr_25422_25591[(1)] = (56));

} else {
var statearr_25423_25592 = state_25281__$1;
(statearr_25423_25592[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (78))){
var inst_24981 = (state_25281[(13)]);
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_24981)){
var statearr_25424_25593 = state_25281__$1;
(statearr_25424_25593[(1)] = (81));

} else {
var statearr_25425_25594 = state_25281__$1;
(statearr_25425_25594[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (132))){
var inst_25262 = (state_25281[(17)]);
var state_25281__$1 = state_25281;
var statearr_25426_25595 = state_25281__$1;
(statearr_25426_25595[(2)] = inst_25262);

(statearr_25426_25595[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (26))){
var inst_24981 = (state_25281[(13)]);
var inst_24992 = (state_25281[(2)]);
var inst_24993 = cljs.core.PersistentHashMap.EMPTY;
var inst_24994 = cljs.core.volatile_BANG_(inst_24993);
var state_25281__$1 = (function (){var statearr_25427 = state_25281;
(statearr_25427[(7)] = inst_24992);

(statearr_25427[(9)] = inst_24994);

return statearr_25427;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25428_25596 = state_25281__$1;
(statearr_25428_25596[(1)] = (27));

} else {
var statearr_25429_25597 = state_25281__$1;
(statearr_25429_25597[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (123))){
var state_25281__$1 = state_25281;
var statearr_25430_25598 = state_25281__$1;
(statearr_25430_25598[(2)] = null);

(statearr_25430_25598[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (16))){
var state_25281__$1 = state_25281;
var statearr_25431_25599 = state_25281__$1;
(statearr_25431_25599[(2)] = false);

(statearr_25431_25599[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (133))){
var inst_25276 = (state_25281[(2)]);
var _ = (function (){var statearr_25432 = state_25281;
(statearr_25432[(4)] = cljs.core.rest((state_25281[(4)])));

return statearr_25432;
})();
var state_25281__$1 = state_25281;
var statearr_25433_25600 = state_25281__$1;
(statearr_25433_25600[(2)] = inst_25276);

(statearr_25433_25600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (81))){
var inst_25124 = cljs.core.PersistentHashMap.EMPTY;
var state_25281__$1 = state_25281;
var statearr_25434_25601 = state_25281__$1;
(statearr_25434_25601[(2)] = inst_25124);

(statearr_25434_25601[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (120))){
var inst_24984 = (state_25281[(14)]);
var state_25281__$1 = state_25281;
var statearr_25435_25602 = state_25281__$1;
(statearr_25435_25602[(2)] = inst_24984);

(statearr_25435_25602[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (79))){
var inst_25140 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_25281__$1 = state_25281;
if(inst_25140){
var statearr_25436_25603 = state_25281__$1;
(statearr_25436_25603[(1)] = (86));

} else {
var statearr_25437_25604 = state_25281__$1;
(statearr_25437_25604[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (38))){
var inst_25016 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25438_25605 = state_25281__$1;
(statearr_25438_25605[(2)] = inst_25016);

(statearr_25438_25605[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (126))){
var inst_25257 = (state_25281[(28)]);
var state_25281__$1 = state_25281;
var statearr_25439_25606 = state_25281__$1;
(statearr_25439_25606[(2)] = inst_25257);

(statearr_25439_25606[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (98))){
var state_25281__$1 = state_25281;
var statearr_25440_25607 = state_25281__$1;
(statearr_25440_25607[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (124))){
var inst_25245 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25442_25608 = state_25281__$1;
(statearr_25442_25608[(2)] = inst_25245);

(statearr_25442_25608[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (87))){
var inst_25167 = cljs.core.sequential_QMARK_(from);
var inst_25168 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25169 = ((inst_25167) && (inst_25168));
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25169)){
var statearr_25443_25609 = state_25281__$1;
(statearr_25443_25609[(1)] = (97));

} else {
var statearr_25444_25610 = state_25281__$1;
(statearr_25444_25610[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (30))){
var inst_24981 = (state_25281[(13)]);
var inst_24998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24999 = cljs.core.second(inst_24981);
var inst_25000 = cljs.core.first(inst_24981);
var inst_25001 = [inst_24999,inst_25000];
var inst_25002 = (new cljs.core.PersistentVector(null,2,(5),inst_24998,inst_25001,null));
var state_25281__$1 = state_25281;
var statearr_25445_25611 = state_25281__$1;
(statearr_25445_25611[(2)] = inst_25002);

(statearr_25445_25611[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (73))){
var inst_25105 = cljs.core.PersistentHashMap.EMPTY;
var state_25281__$1 = state_25281;
var statearr_25446_25612 = state_25281__$1;
(statearr_25446_25612[(2)] = inst_25105);

(statearr_25446_25612[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (96))){
var inst_25158 = (state_25281[(32)]);
var inst_25165 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25447 = state_25281;
(statearr_25447[(40)] = inst_25165);

return statearr_25447;
})();
var statearr_25448_25613 = state_25281__$1;
(statearr_25448_25613[(2)] = inst_25158);

(statearr_25448_25613[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (10))){
var inst_24945 = (state_25281[(34)]);
var inst_24945__$1 = selectDistinct;
var state_25281__$1 = (function (){var statearr_25449 = state_25281;
(statearr_25449[(34)] = inst_24945__$1);

return statearr_25449;
})();
if(cljs.core.truth_(inst_24945__$1)){
var statearr_25450_25614 = state_25281__$1;
(statearr_25450_25614[(1)] = (12));

} else {
var statearr_25451_25615 = state_25281__$1;
(statearr_25451_25615[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (18))){
var state_25281__$1 = state_25281;
var statearr_25452_25616 = state_25281__$1;
(statearr_25452_25616[(2)] = true);

(statearr_25452_25616[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (105))){
var inst_25190 = (state_25281[(15)]);
var state_25281__$1 = state_25281;
var statearr_25453_25617 = state_25281__$1;
(statearr_25453_25617[(2)] = inst_25190);

(statearr_25453_25617[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (52))){
var inst_24992 = (state_25281[(7)]);
var inst_25043 = (state_25281[(41)]);
var inst_24994 = (state_25281[(9)]);
var inst_25039 = (state_25281[(39)]);
var inst_25047 = (state_25281[(2)]);
var inst_25048 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_24994,fuel,max_fuel,inst_24992,inst_25039,inst_25043,inst_25047);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(46),inst_25048);
} else {
if((state_val_25282 === (114))){
var inst_25191 = (state_25281[(30)]);
var inst_25215 = (state_25281[(2)]);
var inst_25183 = inst_25191;
var inst_25184 = inst_25215;
var state_25281__$1 = (function (){var statearr_25454 = state_25281;
(statearr_25454[(22)] = inst_25184);

(statearr_25454[(29)] = inst_25183);

return statearr_25454;
})();
var statearr_25455_25618 = state_25281__$1;
(statearr_25455_25618[(2)] = null);

(statearr_25455_25618[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (67))){
var inst_25096 = ["_tx",null,"_block",null];
var inst_25097 = (new cljs.core.PersistentArrayMap(null,2,inst_25096,null));
var inst_25098 = (new cljs.core.PersistentHashSet(null,inst_25097,null));
var inst_25099 = (inst_25098.cljs$core$IFn$_invoke$arity$1 ? inst_25098.cljs$core$IFn$_invoke$arity$1(from) : inst_25098.call(null,from));
var state_25281__$1 = state_25281;
var statearr_25456_25619 = state_25281__$1;
(statearr_25456_25619[(2)] = inst_25099);

(statearr_25456_25619[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (71))){
var inst_25121 = typeof from === 'string';
var state_25281__$1 = state_25281;
if(cljs.core.truth_(inst_25121)){
var statearr_25457_25620 = state_25281__$1;
(statearr_25457_25620[(1)] = (78));

} else {
var statearr_25458_25621 = state_25281__$1;
(statearr_25458_25621[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (42))){
var state_25281__$1 = state_25281;
var statearr_25459_25622 = state_25281__$1;
(statearr_25459_25622[(2)] = from);

(statearr_25459_25622[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (80))){
var inst_25251 = (state_25281[(2)]);
var state_25281__$1 = state_25281;
var statearr_25460_25623 = state_25281__$1;
(statearr_25460_25623[(2)] = inst_25251);

(statearr_25460_25623[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (37))){
var state_25281__$1 = state_25281;
var statearr_25461_25624 = state_25281__$1;
(statearr_25461_25624[(2)] = null);

(statearr_25461_25624[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (63))){
var inst_24982 = (state_25281[(12)]);
var inst_24984 = (state_25281[(14)]);
var inst_25075 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25076 = [inst_24982,inst_24984];
var inst_25077 = cljs.core.PersistentHashMap.fromArrays(inst_25075,inst_25076);
var state_25281__$1 = state_25281;
var statearr_25462_25625 = state_25281__$1;
(statearr_25462_25625[(2)] = inst_25077);

(statearr_25462_25625[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (94))){
var inst_25160 = cljs.core._deref(fuel);
var inst_25161 = (inst_25160 + (1));
var inst_25162 = cljs.core._vreset_BANG_(fuel,inst_25161);
var state_25281__$1 = state_25281;
var statearr_25463_25626 = state_25281__$1;
(statearr_25463_25626[(2)] = inst_25162);

(statearr_25463_25626[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (8))){
var inst_24959 = (state_25281[(23)]);
var inst_24958 = (state_25281[(2)]);
var inst_24959__$1 = opts_SINGLEQUOTE_;
var inst_24961 = (inst_24959__$1 == null);
var inst_24962 = cljs.core.not(inst_24961);
var state_25281__$1 = (function (){var statearr_25464 = state_25281;
(statearr_25464[(36)] = inst_24958);

(statearr_25464[(23)] = inst_24959__$1);

return statearr_25464;
})();
if(inst_24962){
var statearr_25465_25627 = state_25281__$1;
(statearr_25465_25627[(1)] = (15));

} else {
var statearr_25466_25628 = state_25281__$1;
(statearr_25466_25628[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (49))){
var inst_24981 = (state_25281[(13)]);
var inst_25043 = (state_25281[(2)]);
var state_25281__$1 = (function (){var statearr_25467 = state_25281;
(statearr_25467[(41)] = inst_25043);

return statearr_25467;
})();
if(cljs.core.truth_(inst_24981)){
var statearr_25468_25629 = state_25281__$1;
(statearr_25468_25629[(1)] = (50));

} else {
var statearr_25469_25630 = state_25281__$1;
(statearr_25469_25630[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25282 === (84))){
var inst_24992 = (state_25281[(7)]);
var inst_24994 = (state_25281[(9)]);
var inst_25133 = (state_25281[(2)]);
var inst_25134 = fluree.db.util.async.throw_err(inst_25133);
var inst_25135 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_24994,fuel,max_fuel,inst_24992,inst_25134);
var state_25281__$1 = state_25281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25281__$1,(85),inst_25135);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2414__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2414__auto____0 = (function (){
var statearr_25470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25470[(0)] = fluree$db$query$fql$query_$_state_machine__2414__auto__);

(statearr_25470[(1)] = (1));

return statearr_25470;
});
var fluree$db$query$fql$query_$_state_machine__2414__auto____1 = (function (state_25281){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_25281);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e25471){var ex__2417__auto__ = e25471;
var statearr_25472_25631 = state_25281;
(statearr_25472_25631[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_25281[(4)]))){
var statearr_25473_25632 = state_25281;
(statearr_25473_25632[(1)] = cljs.core.first((state_25281[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25633 = state_25281;
state_25281 = G__25633;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2414__auto__ = function(state_25281){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2414__auto____1.call(this,state_25281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2414__auto____0;
fluree$db$query$fql$query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2414__auto____1;
return fluree$db$query$fql$query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_25474 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_25474[(6)] = c__2436__auto__);

return statearr_25474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}

});
