// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13183 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13183,(5),null);
var G__13186 = idx;
var G__13186__$1 = (((G__13186 instanceof cljs.core.Keyword))?G__13186.fqn:null);
switch (G__13186__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13186__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13188 = idx;
var G__13188__$1 = (((G__13188 instanceof cljs.core.Keyword))?G__13188.fqn:null);
switch (G__13188__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13188__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13190 = idx;
var G__13190__$1 = (((G__13190 instanceof cljs.core.Keyword))?G__13190.fqn:null);
switch (G__13190__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13190__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13193 = arguments.length;
switch (G__13193) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13194 = (function (){var pred__13197 = cljs.core.identical_QMARK_;
var expr__13198 = test;
if(cljs.core.truth_((pred__13197.cljs$core$IFn$_invoke$arity$2 ? pred__13197.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13198) : pred__13197.call(null,cljs.core._EQ_,expr__13198)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13197.cljs$core$IFn$_invoke$arity$2 ? pred__13197.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13198) : pred__13197.call(null,cljs.core._LT_,expr__13198)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13197.cljs$core$IFn$_invoke$arity$2 ? pred__13197.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13198) : pred__13197.call(null,cljs.core._LT__EQ_,expr__13198)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13197.cljs$core$IFn$_invoke$arity$2 ? pred__13197.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13198) : pred__13197.call(null,cljs.core._GT_,expr__13198)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13197.cljs$core$IFn$_invoke$arity$2 ? pred__13197.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13198) : pred__13197.call(null,cljs.core._GT__EQ_,expr__13198)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13198)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13194,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13194,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13194,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13194,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13411){
var state_val_13412 = (state_13411[(1)]);
if((state_val_13412 === (65))){
var inst_13332 = (state_13411[(7)]);
var inst_13364 = (state_13411[(8)]);
var inst_13376 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13364,inst_13332);
var state_13411__$1 = state_13411;
var statearr_13413_13529 = state_13411__$1;
(statearr_13413_13529[(2)] = inst_13376);

(statearr_13413_13529[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (70))){
var inst_13394 = (state_13411[(2)]);
var inst_13395 = cljs.core.not(inst_13394);
var state_13411__$1 = state_13411;
if(inst_13395){
var statearr_13414_13530 = state_13411__$1;
(statearr_13414_13530[(1)] = (71));

} else {
var statearr_13415_13531 = state_13411__$1;
(statearr_13415_13531[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (62))){
var inst_13385 = (state_13411[(9)]);
var inst_13346 = (state_13411[(10)]);
var inst_13385__$1 = (state_13411[(2)]);
var inst_13386 = cljs.core.count(inst_13385__$1);
var state_13411__$1 = (function (){var statearr_13416 = state_13411;
(statearr_13416[(9)] = inst_13385__$1);

(statearr_13416[(11)] = inst_13386);

return statearr_13416;
})();
if(cljs.core.truth_(inst_13346)){
var statearr_13417_13532 = state_13411__$1;
(statearr_13417_13532[(1)] = (68));

} else {
var statearr_13418_13533 = state_13411__$1;
(statearr_13418_13533[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (74))){
var inst_13385 = (state_13411[(9)]);
var inst_13386 = (state_13411[(11)]);
var inst_13400 = (state_13411[(2)]);
var inst_13401 = fluree.db.util.async.throw_err(inst_13400);
var inst_13330 = inst_13401;
var inst_13331 = inst_13386;
var inst_13332 = inst_13385;
var state_13411__$1 = (function (){var statearr_13419 = state_13411;
(statearr_13419[(7)] = inst_13332);

(statearr_13419[(12)] = inst_13331);

(statearr_13419[(13)] = inst_13330);

return statearr_13419;
})();
var statearr_13420_13534 = state_13411__$1;
(statearr_13420_13534[(2)] = null);

(statearr_13420_13534[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (7))){
var inst_13213 = (state_13411[(14)]);
var state_13411__$1 = state_13411;
var statearr_13421_13535 = state_13411__$1;
(statearr_13421_13535[(2)] = inst_13213);

(statearr_13421_13535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (59))){
var inst_13330 = (state_13411[(13)]);
var inst_13345 = (state_13411[(2)]);
var inst_13346 = fluree.db.dbproto._rhs(inst_13330);
var state_13411__$1 = (function (){var statearr_13422 = state_13411;
(statearr_13422[(10)] = inst_13346);

(statearr_13422[(15)] = inst_13345);

return statearr_13422;
})();
var statearr_13423_13536 = state_13411__$1;
(statearr_13423_13536[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (20))){
var inst_13214 = (state_13411[(16)]);
var inst_13261 = (state_13411[(2)]);
var inst_13262 = (inst_13214 == null);
var state_13411__$1 = (function (){var statearr_13425 = state_13411;
(statearr_13425[(17)] = inst_13261);

return statearr_13425;
})();
if(cljs.core.truth_(inst_13262)){
var statearr_13426_13537 = state_13411__$1;
(statearr_13426_13537[(1)] = (22));

} else {
var statearr_13427_13538 = state_13411__$1;
(statearr_13427_13538[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (72))){
var inst_13325 = (state_13411[(18)]);
var inst_13346 = (state_13411[(10)]);
var inst_13398 = fluree.db.dbproto._lookup_leaf(inst_13325,inst_13346);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(74),inst_13398);
} else {
if((state_val_13412 === (58))){
var inst_13338 = (state_13411[(19)]);
var state_13411__$1 = state_13411;
var statearr_13428_13539 = state_13411__$1;
(statearr_13428_13539[(2)] = inst_13338);

(statearr_13428_13539[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (60))){
var inst_13332 = (state_13411[(7)]);
var inst_13331 = (state_13411[(12)]);
var inst_13345 = (state_13411[(15)]);
var inst_13304 = (state_13411[(20)]);
var inst_13348 = (inst_13304 - inst_13331);
var inst_13349 = fluree.db.flake.take(inst_13348,inst_13345);
var inst_13350 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13349,inst_13332);
var state_13411__$1 = state_13411;
var statearr_13429_13540 = state_13411__$1;
(statearr_13429_13540[(2)] = inst_13350);

(statearr_13429_13540[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (27))){
var inst_13221 = (state_13411[(21)]);
var inst_13270 = (state_13411[(2)]);
var inst_13271 = (inst_13221 == null);
var state_13411__$1 = (function (){var statearr_13430 = state_13411;
(statearr_13430[(22)] = inst_13270);

return statearr_13430;
})();
if(cljs.core.truth_(inst_13271)){
var statearr_13431_13541 = state_13411__$1;
(statearr_13431_13541[(1)] = (28));

} else {
var statearr_13432_13542 = state_13411__$1;
(statearr_13432_13542[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (1))){
var state_13411__$1 = state_13411;
var statearr_13433_13543 = state_13411__$1;
(statearr_13433_13543[(2)] = null);

(statearr_13433_13543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (69))){
var inst_13346 = (state_13411[(10)]);
var state_13411__$1 = state_13411;
var statearr_13434_13544 = state_13411__$1;
(statearr_13434_13544[(2)] = inst_13346);

(statearr_13434_13544[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (24))){
var inst_13266 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
if(cljs.core.truth_(inst_13266)){
var statearr_13435_13545 = state_13411__$1;
(statearr_13435_13545[(1)] = (25));

} else {
var statearr_13436_13546 = state_13411__$1;
(statearr_13436_13546[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (55))){
var inst_13406 = (state_13411[(2)]);
var _ = (function (){var statearr_13437 = state_13411;
(statearr_13437[(4)] = cljs.core.rest((state_13411[(4)])));

return statearr_13437;
})();
var state_13411__$1 = state_13411;
var statearr_13438_13547 = state_13411__$1;
(statearr_13438_13547[(2)] = inst_13406);

(statearr_13438_13547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (39))){
var inst_13286 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13439_13548 = state_13411__$1;
(statearr_13439_13548[(2)] = inst_13286);

(statearr_13439_13548[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (46))){
var inst_13300 = (state_13411[(23)]);
var state_13411__$1 = state_13411;
var statearr_13440_13549 = state_13411__$1;
(statearr_13440_13549[(2)] = inst_13300);

(statearr_13440_13549[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (4))){
var inst_13200 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13441_13550 = state_13411__$1;
(statearr_13441_13550[(2)] = inst_13200);

(statearr_13441_13550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (54))){
var inst_13315 = (state_13411[(24)]);
var inst_13320 = (state_13411[(25)]);
var inst_13330 = (state_13411[(13)]);
var inst_13316 = (state_13411[(26)]);
var inst_13334 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13330,inst_13315,inst_13316,inst_13320);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(56),inst_13334);
} else {
if((state_val_13412 === (15))){
var inst_13215 = (state_13411[(27)]);
var state_13411__$1 = state_13411;
var statearr_13442_13551 = state_13411__$1;
(statearr_13442_13551[(2)] = inst_13215);

(statearr_13442_13551[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (48))){
var inst_13310 = (state_13411[(28)]);
var inst_13304 = (state_13411[(2)]);
var inst_13305 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13307 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13308 = (new cljs.core.PersistentVector(null,3,(5),inst_13306,inst_13307,null));
var inst_13309 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13308);
var inst_13310__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13411__$1 = (function (){var statearr_13443 = state_13411;
(statearr_13443[(29)] = inst_13305);

(statearr_13443[(28)] = inst_13310__$1);

(statearr_13443[(20)] = inst_13304);

(statearr_13443[(30)] = inst_13309);

return statearr_13443;
})();
if(cljs.core.truth_(inst_13310__$1)){
var statearr_13444_13552 = state_13411__$1;
(statearr_13444_13552[(1)] = (49));

} else {
var statearr_13445_13553 = state_13411__$1;
(statearr_13445_13553[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (50))){
var inst_13313 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13411__$1 = state_13411;
var statearr_13446_13554 = state_13411__$1;
(statearr_13446_13554[(2)] = inst_13313);

(statearr_13446_13554[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (21))){
var inst_13257 = (state_13411[(2)]);
var inst_13258 = fluree.db.util.async.throw_err(inst_13257);
var state_13411__$1 = state_13411;
var statearr_13447_13555 = state_13411__$1;
(statearr_13447_13555[(2)] = inst_13258);

(statearr_13447_13555[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (31))){
var state_13411__$1 = state_13411;
var statearr_13448_13556 = state_13411__$1;
(statearr_13448_13556[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13448_13556[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (32))){
var inst_13221 = (state_13411[(21)]);
var state_13411__$1 = state_13411;
var statearr_13449_13557 = state_13411__$1;
(statearr_13449_13557[(2)] = inst_13221);

(statearr_13449_13557[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (40))){
var inst_13225 = (state_13411[(31)]);
var state_13411__$1 = state_13411;
var statearr_13450_13558 = state_13411__$1;
(statearr_13450_13558[(2)] = inst_13225);

(statearr_13450_13558[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (56))){
var inst_13337 = (state_13411[(32)]);
var inst_13298 = (state_13411[(33)]);
var inst_13299 = (state_13411[(34)]);
var inst_13336 = (state_13411[(2)]);
var inst_13337__$1 = fluree.db.util.async.throw_err(inst_13336);
var inst_13338 = fluree.db.flake.subrange(inst_13337__$1,start_test,inst_13298,end_test,inst_13299);
var inst_13339 = fluree.db.query.range.value_with_nil_pred(idx,inst_13298,inst_13299);
var state_13411__$1 = (function (){var statearr_13451 = state_13411;
(statearr_13451[(32)] = inst_13337__$1);

(statearr_13451[(19)] = inst_13338);

return statearr_13451;
})();
if(inst_13339){
var statearr_13452_13559 = state_13411__$1;
(statearr_13452_13559[(1)] = (57));

} else {
var statearr_13453_13560 = state_13411__$1;
(statearr_13453_13560[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (33))){
var inst_13218 = (state_13411[(35)]);
var inst_13279 = (state_13411[(2)]);
var state_13411__$1 = (function (){var statearr_13454 = state_13411;
(statearr_13454[(36)] = inst_13279);

return statearr_13454;
})();
if(cljs.core.truth_(inst_13218)){
var statearr_13455_13561 = state_13411__$1;
(statearr_13455_13561[(1)] = (34));

} else {
var statearr_13456_13562 = state_13411__$1;
(statearr_13456_13562[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (13))){
var inst_13239 = (state_13411[(2)]);
var inst_13240 = fluree.db.util.async.throw_err(inst_13239);
var state_13411__$1 = state_13411;
var statearr_13457_13563 = state_13411__$1;
(statearr_13457_13563[(2)] = inst_13240);

(statearr_13457_13563[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (22))){
var inst_13252 = (state_13411[(37)]);
var state_13411__$1 = state_13411;
var statearr_13458_13564 = state_13411__$1;
(statearr_13458_13564[(2)] = inst_13252);

(statearr_13458_13564[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (36))){
var inst_13225 = (state_13411[(31)]);
var inst_13288 = (state_13411[(2)]);
var state_13411__$1 = (function (){var statearr_13459 = state_13411;
(statearr_13459[(38)] = inst_13288);

return statearr_13459;
})();
if(cljs.core.truth_(inst_13225)){
var statearr_13460_13565 = state_13411__$1;
(statearr_13460_13565[(1)] = (40));

} else {
var statearr_13461_13566 = state_13411__$1;
(statearr_13461_13566[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (41))){
var inst_13291 = (cljs.core._LT__EQ_ === end_test);
var state_13411__$1 = state_13411;
if(cljs.core.truth_(inst_13291)){
var statearr_13462_13567 = state_13411__$1;
(statearr_13462_13567[(1)] = (43));

} else {
var statearr_13463_13568 = state_13411__$1;
(statearr_13463_13568[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (43))){
var state_13411__$1 = state_13411;
var statearr_13464_13569 = state_13411__$1;
(statearr_13464_13569[(2)] = (2147483647));

(statearr_13464_13569[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (61))){
var inst_13331 = (state_13411[(12)]);
var inst_13345 = (state_13411[(15)]);
var inst_13359 = cljs.core.seq(inst_13345);
var inst_13360 = cljs.core.first(inst_13359);
var inst_13361 = cljs.core.next(inst_13359);
var inst_13362 = inst_13345;
var inst_13363 = inst_13331;
var inst_13364 = inst_13345;
var state_13411__$1 = (function (){var statearr_13465 = state_13411;
(statearr_13465[(39)] = inst_13361);

(statearr_13465[(40)] = inst_13363);

(statearr_13465[(41)] = inst_13362);

(statearr_13465[(8)] = inst_13364);

(statearr_13465[(42)] = inst_13360);

return statearr_13465;
})();
var statearr_13466_13570 = state_13411__$1;
(statearr_13466_13570[(2)] = null);

(statearr_13466_13570[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (29))){
var state_13411__$1 = state_13411;
var statearr_13467_13571 = state_13411__$1;
(statearr_13467_13571[(2)] = false);

(statearr_13467_13571[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (44))){
var state_13411__$1 = state_13411;
var statearr_13468_13572 = state_13411__$1;
(statearr_13468_13572[(2)] = fluree.db.util.core.min_integer);

(statearr_13468_13572[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (6))){
var inst_13213 = (state_13411[(14)]);
var inst_13228 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13213);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(9),inst_13228);
} else {
if((state_val_13412 === (28))){
var inst_13261 = (state_13411[(17)]);
var state_13411__$1 = state_13411;
var statearr_13469_13573 = state_13411__$1;
(statearr_13469_13573[(2)] = inst_13261);

(statearr_13469_13573[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (64))){
var inst_13383 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13470_13574 = state_13411__$1;
(statearr_13470_13574[(2)] = inst_13383);

(statearr_13470_13574[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (51))){
var inst_13315 = (state_13411[(2)]);
var inst_13316 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13318 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13319 = (new cljs.core.PersistentVector(null,2,(5),inst_13317,inst_13318,null));
var inst_13320 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13319);
var inst_13321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13322 = fluree.db.dbproto._resolve(inst_13321);
var state_13411__$1 = (function (){var statearr_13471 = state_13411;
(statearr_13471[(24)] = inst_13315);

(statearr_13471[(25)] = inst_13320);

(statearr_13471[(26)] = inst_13316);

return statearr_13471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(52),inst_13322);
} else {
if((state_val_13412 === (25))){
var state_13411__$1 = state_13411;
var statearr_13472_13575 = state_13411__$1;
(statearr_13472_13575[(2)] = (-1));

(statearr_13472_13575[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (34))){
var inst_13218 = (state_13411[(35)]);
var state_13411__$1 = state_13411;
var statearr_13473_13576 = state_13411__$1;
(statearr_13473_13576[(2)] = inst_13218);

(statearr_13473_13576[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (17))){
var inst_13248 = (state_13411[(2)]);
var inst_13249 = fluree.db.util.async.throw_err(inst_13248);
var state_13411__$1 = state_13411;
var statearr_13474_13577 = state_13411__$1;
(statearr_13474_13577[(2)] = inst_13249);

(statearr_13474_13577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (3))){
var inst_13409 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13411__$1,inst_13409);
} else {
if((state_val_13412 === (12))){
var inst_13215 = (state_13411[(27)]);
var inst_13243 = (state_13411[(2)]);
var inst_13244 = fluree.db.util.core.pred_ident_QMARK_(inst_13215);
var state_13411__$1 = (function (){var statearr_13476 = state_13411;
(statearr_13476[(43)] = inst_13243);

return statearr_13476;
})();
if(inst_13244){
var statearr_13477_13578 = state_13411__$1;
(statearr_13477_13578[(1)] = (14));

} else {
var statearr_13478_13579 = state_13411__$1;
(statearr_13478_13579[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (2))){
var inst_13212 = (state_13411[(44)]);
var inst_13219 = (state_13411[(45)]);
var inst_13213 = (state_13411[(14)]);
var _ = (function (){var statearr_13479 = state_13411;
(statearr_13479[(4)] = cljs.core.cons((5),(state_13411[(4)])));

return statearr_13479;
})();
var inst_13212__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13213__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(0),null);
var inst_13214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(1),null);
var inst_13215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(2),null);
var inst_13216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(3),null);
var inst_13217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(4),null);
var inst_13218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13212__$1,(5),null);
var inst_13219__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(0),null);
var inst_13221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(1),null);
var inst_13222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(2),null);
var inst_13223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(3),null);
var inst_13224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(4),null);
var inst_13225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13219__$1,(5),null);
var inst_13226 = fluree.db.util.core.pred_ident_QMARK_(inst_13213__$1);
var state_13411__$1 = (function (){var statearr_13480 = state_13411;
(statearr_13480[(46)] = inst_13216);

(statearr_13480[(44)] = inst_13212__$1);

(statearr_13480[(45)] = inst_13219__$1);

(statearr_13480[(31)] = inst_13225);

(statearr_13480[(47)] = inst_13223);

(statearr_13480[(21)] = inst_13221);

(statearr_13480[(14)] = inst_13213__$1);

(statearr_13480[(35)] = inst_13218);

(statearr_13480[(48)] = inst_13220);

(statearr_13480[(49)] = inst_13222);

(statearr_13480[(27)] = inst_13215);

(statearr_13480[(50)] = inst_13217);

(statearr_13480[(51)] = inst_13224);

(statearr_13480[(16)] = inst_13214);

return statearr_13480;
})();
if(inst_13226){
var statearr_13481_13580 = state_13411__$1;
(statearr_13481_13580[(1)] = (6));

} else {
var statearr_13482_13581 = state_13411__$1;
(statearr_13482_13581[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (66))){
var inst_13363 = (state_13411[(40)]);
var inst_13364 = (state_13411[(8)]);
var inst_13371 = (state_13411[(52)]);
var inst_13378 = (inst_13363 + (1));
var tmp13475 = inst_13364;
var inst_13362 = inst_13371;
var inst_13363__$1 = inst_13378;
var inst_13364__$1 = tmp13475;
var state_13411__$1 = (function (){var statearr_13483 = state_13411;
(statearr_13483[(40)] = inst_13363__$1);

(statearr_13483[(41)] = inst_13362);

(statearr_13483[(8)] = inst_13364__$1);

return statearr_13483;
})();
var statearr_13484_13582 = state_13411__$1;
(statearr_13484_13582[(2)] = null);

(statearr_13484_13582[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (23))){
var state_13411__$1 = state_13411;
var statearr_13485_13583 = state_13411__$1;
(statearr_13485_13583[(2)] = false);

(statearr_13485_13583[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (47))){
var state_13411__$1 = state_13411;
var statearr_13486_13584 = state_13411__$1;
(statearr_13486_13584[(2)] = fluree.db.util.core.max_long);

(statearr_13486_13584[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (35))){
var inst_13282 = (cljs.core._GT__EQ_ === start_test);
var state_13411__$1 = state_13411;
if(cljs.core.truth_(inst_13282)){
var statearr_13487_13585 = state_13411__$1;
(statearr_13487_13585[(1)] = (37));

} else {
var statearr_13488_13586 = state_13411__$1;
(statearr_13488_13586[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (19))){
var inst_13222 = (state_13411[(49)]);
var state_13411__$1 = state_13411;
var statearr_13489_13587 = state_13411__$1;
(statearr_13489_13587[(2)] = inst_13222);

(statearr_13489_13587[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (57))){
var inst_13337 = (state_13411[(32)]);
var inst_13305 = (state_13411[(29)]);
var inst_13270 = (state_13411[(22)]);
var inst_13338 = (state_13411[(19)]);
var inst_13216 = (state_13411[(46)]);
var inst_13261 = (state_13411[(17)]);
var inst_13212 = (state_13411[(44)]);
var inst_13219 = (state_13411[(45)]);
var inst_13315 = (state_13411[(24)]);
var inst_13252 = (state_13411[(37)]);
var inst_13223 = (state_13411[(47)]);
var inst_13234 = (state_13411[(53)]);
var inst_13320 = (state_13411[(25)]);
var inst_13325 = (state_13411[(18)]);
var inst_13279 = (state_13411[(36)]);
var inst_13332 = (state_13411[(7)]);
var inst_13331 = (state_13411[(12)]);
var inst_13288 = (state_13411[(38)]);
var inst_13304 = (state_13411[(20)]);
var inst_13217 = (state_13411[(50)]);
var inst_13224 = (state_13411[(51)]);
var inst_13309 = (state_13411[(30)]);
var inst_13297 = (state_13411[(54)]);
var inst_13298 = (state_13411[(33)]);
var inst_13330 = (state_13411[(13)]);
var inst_13299 = (state_13411[(34)]);
var inst_13316 = (state_13411[(26)]);
var inst_13243 = (state_13411[(43)]);
var inst_13341 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13330;
var flakes = inst_13337;
var s1 = inst_13234;
var o2 = inst_13261;
var t1 = inst_13216;
var i = inst_13331;
var m1 = inst_13288;
var root_node = inst_13325;
var to_t = inst_13316;
var s2 = inst_13243;
var p2 = inst_13279;
var permissions = inst_13305;
var limit = inst_13304;
var start_flake = inst_13298;
var acc = inst_13332;
var t2 = inst_13223;
var op1 = inst_13217;
var o1 = inst_13252;
var end_flake = inst_13299;
var vec__13209 = inst_13219;
var base_result = inst_13338;
var vec__13206 = inst_13212;
var p1 = inst_13270;
var idx_compare = inst_13309;
var op2 = inst_13224;
var from_t = inst_13315;
var m2 = inst_13297;
var novelty = inst_13320;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13342 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13341,inst_13338,inst_13338);
var state_13411__$1 = state_13411;
var statearr_13490_13588 = state_13411__$1;
(statearr_13490_13588[(2)] = inst_13342);

(statearr_13490_13588[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (68))){
var inst_13346 = (state_13411[(10)]);
var inst_13386 = (state_13411[(11)]);
var inst_13304 = (state_13411[(20)]);
var inst_13309 = (state_13411[(30)]);
var inst_13299 = (state_13411[(34)]);
var inst_13388 = (inst_13309.cljs$core$IFn$_invoke$arity$2 ? inst_13309.cljs$core$IFn$_invoke$arity$2(inst_13346,inst_13299) : inst_13309.call(null,inst_13346,inst_13299));
var inst_13389 = (inst_13388 < (0));
var inst_13390 = (inst_13386 < inst_13304);
var inst_13391 = ((inst_13389) && (inst_13390));
var state_13411__$1 = state_13411;
var statearr_13491_13589 = state_13411__$1;
(statearr_13491_13589[(2)] = inst_13391);

(statearr_13491_13589[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (11))){
var inst_13220 = (state_13411[(48)]);
var state_13411__$1 = state_13411;
var statearr_13493_13590 = state_13411__$1;
(statearr_13493_13590[(2)] = inst_13220);

(statearr_13493_13590[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (9))){
var inst_13230 = (state_13411[(2)]);
var inst_13231 = fluree.db.util.async.throw_err(inst_13230);
var state_13411__$1 = state_13411;
var statearr_13494_13591 = state_13411__$1;
(statearr_13494_13591[(2)] = inst_13231);

(statearr_13494_13591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (5))){
var _ = (function (){var statearr_13495 = state_13411;
(statearr_13495[(4)] = cljs.core.rest((state_13411[(4)])));

return statearr_13495;
})();
var state_13411__$1 = state_13411;
var ex13492 = (state_13411__$1[(2)]);
var statearr_13496_13592 = state_13411__$1;
(statearr_13496_13592[(5)] = ex13492);


if((ex13492 instanceof Error)){
var statearr_13497_13593 = state_13411__$1;
(statearr_13497_13593[(1)] = (4));

(statearr_13497_13593[(5)] = null);

} else {
throw ex13492;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (14))){
var inst_13215 = (state_13411[(27)]);
var inst_13246 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13215);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(17),inst_13246);
} else {
if((state_val_13412 === (45))){
var inst_13295 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13498_13594 = state_13411__$1;
(statearr_13498_13594[(2)] = inst_13295);

(statearr_13498_13594[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (53))){
var inst_13328 = (state_13411[(2)]);
var inst_13329 = fluree.db.util.async.throw_err(inst_13328);
var inst_13330 = inst_13329;
var inst_13331 = (0);
var inst_13332 = null;
var state_13411__$1 = (function (){var statearr_13499 = state_13411;
(statearr_13499[(7)] = inst_13332);

(statearr_13499[(12)] = inst_13331);

(statearr_13499[(13)] = inst_13330);

return statearr_13499;
})();
var statearr_13500_13595 = state_13411__$1;
(statearr_13500_13595[(2)] = null);

(statearr_13500_13595[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (26))){
var inst_13214 = (state_13411[(16)]);
var state_13411__$1 = state_13411;
var statearr_13501_13596 = state_13411__$1;
(statearr_13501_13596[(2)] = inst_13214);

(statearr_13501_13596[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (16))){
var inst_13222 = (state_13411[(49)]);
var inst_13252 = (state_13411[(2)]);
var inst_13253 = fluree.db.util.core.pred_ident_QMARK_(inst_13222);
var state_13411__$1 = (function (){var statearr_13502 = state_13411;
(statearr_13502[(37)] = inst_13252);

return statearr_13502;
})();
if(inst_13253){
var statearr_13503_13597 = state_13411__$1;
(statearr_13503_13597[(1)] = (18));

} else {
var statearr_13504_13598 = state_13411__$1;
(statearr_13504_13598[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (38))){
var state_13411__$1 = state_13411;
var statearr_13505_13599 = state_13411__$1;
(statearr_13505_13599[(2)] = (2147483647));

(statearr_13505_13599[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (30))){
var inst_13275 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
if(cljs.core.truth_(inst_13275)){
var statearr_13506_13600 = state_13411__$1;
(statearr_13506_13600[(1)] = (31));

} else {
var statearr_13507_13601 = state_13411__$1;
(statearr_13507_13601[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (73))){
var inst_13404 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13508_13602 = state_13411__$1;
(statearr_13508_13602[(2)] = inst_13404);

(statearr_13508_13602[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (10))){
var inst_13220 = (state_13411[(48)]);
var inst_13237 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13220);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(13),inst_13237);
} else {
if((state_val_13412 === (18))){
var inst_13222 = (state_13411[(49)]);
var inst_13255 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13222);
var state_13411__$1 = state_13411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(21),inst_13255);
} else {
if((state_val_13412 === (52))){
var inst_13325 = (state_13411[(18)]);
var inst_13298 = (state_13411[(33)]);
var inst_13324 = (state_13411[(2)]);
var inst_13325__$1 = fluree.db.util.async.throw_err(inst_13324);
var inst_13326 = fluree.db.dbproto._lookup_leaf(inst_13325__$1,inst_13298);
var state_13411__$1 = (function (){var statearr_13509 = state_13411;
(statearr_13509[(18)] = inst_13325__$1);

return statearr_13509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13411__$1,(53),inst_13326);
} else {
if((state_val_13412 === (67))){
var inst_13381 = (state_13411[(2)]);
var state_13411__$1 = state_13411;
var statearr_13510_13603 = state_13411__$1;
(statearr_13510_13603[(2)] = inst_13381);

(statearr_13510_13603[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (71))){
var inst_13385 = (state_13411[(9)]);
var state_13411__$1 = state_13411;
var statearr_13511_13604 = state_13411__$1;
(statearr_13511_13604[(2)] = inst_13385);

(statearr_13511_13604[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (42))){
var inst_13270 = (state_13411[(22)]);
var inst_13216 = (state_13411[(46)]);
var inst_13261 = (state_13411[(17)]);
var inst_13300 = (state_13411[(23)]);
var inst_13252 = (state_13411[(37)]);
var inst_13223 = (state_13411[(47)]);
var inst_13234 = (state_13411[(53)]);
var inst_13279 = (state_13411[(36)]);
var inst_13288 = (state_13411[(38)]);
var inst_13217 = (state_13411[(50)]);
var inst_13224 = (state_13411[(51)]);
var inst_13297 = (state_13411[(54)]);
var inst_13243 = (state_13411[(43)]);
var inst_13297__$1 = (state_13411[(2)]);
var inst_13298 = fluree.db.flake.__GT_Flake(inst_13234,inst_13270,inst_13252,inst_13216,inst_13217,inst_13288);
var inst_13299 = fluree.db.flake.__GT_Flake(inst_13243,inst_13279,inst_13261,inst_13223,inst_13224,inst_13297__$1);
var inst_13300__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13411__$1 = (function (){var statearr_13512 = state_13411;
(statearr_13512[(23)] = inst_13300__$1);

(statearr_13512[(54)] = inst_13297__$1);

(statearr_13512[(33)] = inst_13298);

(statearr_13512[(34)] = inst_13299);

return statearr_13512;
})();
if(cljs.core.truth_(inst_13300__$1)){
var statearr_13513_13605 = state_13411__$1;
(statearr_13513_13605[(1)] = (46));

} else {
var statearr_13514_13606 = state_13411__$1;
(statearr_13514_13606[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (37))){
var state_13411__$1 = state_13411;
var statearr_13515_13607 = state_13411__$1;
(statearr_13515_13607[(2)] = fluree.db.util.core.min_integer);

(statearr_13515_13607[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (63))){
var inst_13363 = (state_13411[(40)]);
var inst_13362 = (state_13411[(41)]);
var inst_13304 = (state_13411[(20)]);
var inst_13369 = cljs.core.seq(inst_13362);
var inst_13370 = cljs.core.first(inst_13369);
var inst_13371 = cljs.core.next(inst_13369);
var inst_13372 = (inst_13370 == null);
var inst_13373 = (inst_13363 > inst_13304);
var inst_13374 = ((inst_13372) || (inst_13373));
var state_13411__$1 = (function (){var statearr_13516 = state_13411;
(statearr_13516[(52)] = inst_13371);

return statearr_13516;
})();
if(cljs.core.truth_(inst_13374)){
var statearr_13517_13608 = state_13411__$1;
(statearr_13517_13608[(1)] = (65));

} else {
var statearr_13518_13609 = state_13411__$1;
(statearr_13518_13609[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (8))){
var inst_13220 = (state_13411[(48)]);
var inst_13234 = (state_13411[(2)]);
var inst_13235 = fluree.db.util.core.pred_ident_QMARK_(inst_13220);
var state_13411__$1 = (function (){var statearr_13519 = state_13411;
(statearr_13519[(53)] = inst_13234);

return statearr_13519;
})();
if(inst_13235){
var statearr_13520_13610 = state_13411__$1;
(statearr_13520_13610[(1)] = (10));

} else {
var statearr_13521_13611 = state_13411__$1;
(statearr_13521_13611[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13412 === (49))){
var inst_13310 = (state_13411[(28)]);
var state_13411__$1 = state_13411;
var statearr_13522_13612 = state_13411__$1;
(statearr_13522_13612[(2)] = inst_13310);

(statearr_13522_13612[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_13523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13523[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_13523[(1)] = (1));

return statearr_13523;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_13411){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13411);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13524){var ex__2417__auto__ = e13524;
var statearr_13525_13613 = state_13411;
(statearr_13525_13613[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13411[(4)]))){
var statearr_13526_13614 = state_13411;
(statearr_13526_13614[(1)] = cljs.core.first((state_13411[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13615 = state_13411;
state_13411 = G__13615;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_13411){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_13411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13527 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13527[(6)] = c__2436__auto__);

return statearr_13527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13665){
var state_val_13666 = (state_13665[(1)]);
if((state_val_13666 === (7))){
var state_13665__$1 = state_13665;
var statearr_13667_13686 = state_13665__$1;
(statearr_13667_13686[(2)] = (0));

(statearr_13667_13686[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (1))){
var inst_13623 = subject_groups;
var inst_13624 = cljs.core.seq(inst_13623);
var inst_13625 = cljs.core.first(inst_13624);
var inst_13626 = cljs.core.next(inst_13624);
var inst_13627 = flake_start;
var inst_13628 = subject_start;
var inst_13629 = cljs.core.PersistentVector.EMPTY;
var inst_13630 = inst_13623;
var inst_13631 = inst_13627;
var inst_13632 = inst_13628;
var inst_13633 = inst_13629;
var state_13665__$1 = (function (){var statearr_13668 = state_13665;
(statearr_13668[(7)] = inst_13630);

(statearr_13668[(8)] = inst_13625);

(statearr_13668[(9)] = inst_13626);

(statearr_13668[(10)] = inst_13632);

(statearr_13668[(11)] = inst_13633);

(statearr_13668[(12)] = inst_13631);

return statearr_13668;
})();
var statearr_13669_13687 = state_13665__$1;
(statearr_13669_13687[(2)] = null);

(statearr_13669_13687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (4))){
var inst_13632 = (state_13665[(10)]);
var inst_13633 = (state_13665[(11)]);
var inst_13631 = (state_13665[(12)]);
var inst_13646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13647 = [inst_13631,inst_13632,inst_13633];
var inst_13648 = (new cljs.core.PersistentVector(null,3,(5),inst_13646,inst_13647,null));
var state_13665__$1 = state_13665;
var statearr_13670_13688 = state_13665__$1;
(statearr_13670_13688[(2)] = inst_13648);

(statearr_13670_13688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (6))){
var inst_13661 = (state_13665[(2)]);
var state_13665__$1 = state_13665;
var statearr_13671_13689 = state_13665__$1;
(statearr_13671_13689[(2)] = inst_13661);

(statearr_13671_13689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (3))){
var inst_13663 = (state_13665[(2)]);
var state_13665__$1 = state_13665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13665__$1,inst_13663);
} else {
if((state_val_13666 === (2))){
var inst_13630 = (state_13665[(7)]);
var inst_13632 = (state_13665[(10)]);
var inst_13631 = (state_13665[(12)]);
var inst_13639 = (state_13665[(13)]);
var inst_13638 = cljs.core.seq(inst_13630);
var inst_13639__$1 = cljs.core.first(inst_13638);
var inst_13640 = cljs.core.next(inst_13638);
var inst_13641 = (inst_13639__$1 == null);
var inst_13642 = (inst_13631 >= flake_limit);
var inst_13643 = (inst_13632 >= subject_limit);
var inst_13644 = ((inst_13641) || (inst_13642) || (inst_13643));
var state_13665__$1 = (function (){var statearr_13672 = state_13665;
(statearr_13672[(14)] = inst_13640);

(statearr_13672[(13)] = inst_13639__$1);

return statearr_13672;
})();
if(cljs.core.truth_(inst_13644)){
var statearr_13673_13690 = state_13665__$1;
(statearr_13673_13690[(1)] = (4));

} else {
var statearr_13674_13691 = state_13665__$1;
(statearr_13674_13691[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (9))){
var inst_13632 = (state_13665[(10)]);
var inst_13633 = (state_13665[(11)]);
var inst_13640 = (state_13665[(14)]);
var inst_13631 = (state_13665[(12)]);
var inst_13650 = (state_13665[(15)]);
var inst_13639 = (state_13665[(13)]);
var inst_13655 = (state_13665[(2)]);
var inst_13656 = (inst_13631 + inst_13650);
var inst_13657 = (inst_13632 + inst_13655);
var inst_13658 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13633,inst_13639);
var inst_13630 = inst_13640;
var inst_13631__$1 = inst_13656;
var inst_13632__$1 = inst_13657;
var inst_13633__$1 = inst_13658;
var state_13665__$1 = (function (){var statearr_13675 = state_13665;
(statearr_13675[(7)] = inst_13630);

(statearr_13675[(10)] = inst_13632__$1);

(statearr_13675[(11)] = inst_13633__$1);

(statearr_13675[(12)] = inst_13631__$1);

return statearr_13675;
})();
var statearr_13676_13692 = state_13665__$1;
(statearr_13676_13692[(2)] = null);

(statearr_13676_13692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (5))){
var inst_13650 = (state_13665[(15)]);
var inst_13639 = (state_13665[(13)]);
var inst_13650__$1 = cljs.core.count(inst_13639);
var inst_13651 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_13650__$1);
var state_13665__$1 = (function (){var statearr_13677 = state_13665;
(statearr_13677[(15)] = inst_13650__$1);

return statearr_13677;
})();
if(inst_13651){
var statearr_13678_13693 = state_13665__$1;
(statearr_13678_13693[(1)] = (7));

} else {
var statearr_13679_13694 = state_13665__$1;
(statearr_13679_13694[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13666 === (8))){
var state_13665__$1 = state_13665;
var statearr_13680_13695 = state_13665__$1;
(statearr_13680_13695[(2)] = (1));

(statearr_13680_13695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0 = (function (){
var statearr_13681 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13681[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__);

(statearr_13681[(1)] = (1));

return statearr_13681;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1 = (function (state_13665){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13665);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13682){var ex__2417__auto__ = e13682;
var statearr_13683_13696 = state_13665;
(statearr_13683_13696[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13665[(4)]))){
var statearr_13684_13697 = state_13665;
(statearr_13684_13697[(1)] = cljs.core.first((state_13665[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13698 = state_13665;
state_13665 = G__13698;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__ = function(state_13665){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1.call(this,state_13665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13685 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13685[(6)] = c__2436__auto__);

return statearr_13685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_13744){
var state_val_13745 = (state_13744[(1)]);
if((state_val_13745 === (7))){
var state_13744__$1 = state_13744;
var statearr_13746_13784 = state_13744__$1;
(statearr_13746_13784[(2)] = null);

(statearr_13746_13784[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (20))){
var inst_13730 = (state_13744[(2)]);
var inst_13731 = fluree.db.util.async.throw_err(inst_13730);
var inst_13709 = inst_13731;
var state_13744__$1 = (function (){var statearr_13747 = state_13744;
(statearr_13747[(7)] = inst_13709);

return statearr_13747;
})();
var statearr_13748_13785 = state_13744__$1;
(statearr_13748_13785[(2)] = null);

(statearr_13748_13785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (1))){
var state_13744__$1 = state_13744;
var statearr_13749_13786 = state_13744__$1;
(statearr_13749_13786[(2)] = null);

(statearr_13749_13786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (4))){
var inst_13699 = (state_13744[(2)]);
var state_13744__$1 = state_13744;
var statearr_13750_13787 = state_13744__$1;
(statearr_13750_13787[(2)] = inst_13699);

(statearr_13750_13787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (15))){
var inst_13709 = (state_13744[(7)]);
var inst_13726 = (state_13744[(8)]);
var inst_13726__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_13709);
var state_13744__$1 = (function (){var statearr_13751 = state_13744;
(statearr_13751[(8)] = inst_13726__$1);

return statearr_13751;
})();
if(cljs.core.truth_(inst_13726__$1)){
var statearr_13752_13788 = state_13744__$1;
(statearr_13752_13788[(1)] = (17));

} else {
var statearr_13753_13789 = state_13744__$1;
(statearr_13753_13789[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (13))){
var inst_13719 = (state_13744[(2)]);
var inst_13720 = fluree.db.util.async.throw_err(inst_13719);
var _ = (function (){var statearr_13754 = state_13744;
(statearr_13754[(4)] = cljs.core.rest((state_13744[(4)])));

return statearr_13754;
})();
var state_13744__$1 = state_13744;
var statearr_13755_13790 = state_13744__$1;
(statearr_13755_13790[(2)] = inst_13720);

(statearr_13755_13790[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (6))){
var inst_13707 = (state_13744[(2)]);
var inst_13708 = fluree.db.util.async.throw_err(inst_13707);
var inst_13709 = inst_13708;
var state_13744__$1 = (function (){var statearr_13756 = state_13744;
(statearr_13756[(7)] = inst_13709);

return statearr_13756;
})();
var statearr_13757_13791 = state_13744__$1;
(statearr_13757_13791[(2)] = null);

(statearr_13757_13791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (17))){
var inst_13726 = (state_13744[(8)]);
var inst_13728 = fluree.db.dbproto._lookup_leaf(root_node,inst_13726);
var state_13744__$1 = state_13744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13744__$1,(20),inst_13728);
} else {
if((state_val_13745 === (3))){
var inst_13742 = (state_13744[(2)]);
var state_13744__$1 = state_13744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13744__$1,inst_13742);
} else {
if((state_val_13745 === (12))){
var _ = (function (){var statearr_13759 = state_13744;
(statearr_13759[(4)] = cljs.core.rest((state_13744[(4)])));

return statearr_13759;
})();
var state_13744__$1 = state_13744;
var ex13758 = (state_13744__$1[(2)]);
var statearr_13760_13792 = state_13744__$1;
(statearr_13760_13792[(5)] = ex13758);


var statearr_13761_13793 = state_13744__$1;
(statearr_13761_13793[(1)] = (11));

(statearr_13761_13793[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (2))){
var _ = (function (){var statearr_13762 = state_13744;
(statearr_13762[(4)] = cljs.core.cons((5),(state_13744[(4)])));

return statearr_13762;
})();
var inst_13705 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_13744__$1 = state_13744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13744__$1,(6),inst_13705);
} else {
if((state_val_13745 === (19))){
var inst_13735 = (state_13744[(2)]);
var state_13744__$1 = state_13744;
var statearr_13763_13794 = state_13744__$1;
(statearr_13763_13794[(2)] = inst_13735);

(statearr_13763_13794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (11))){
var inst_13711 = (state_13744[(2)]);
var state_13744__$1 = (function (){var statearr_13765 = state_13744;
(statearr_13765[(9)] = inst_13711);

return statearr_13765;
})();
var statearr_13766_13795 = state_13744__$1;
(statearr_13766_13795[(2)] = null);

(statearr_13766_13795[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (9))){
var inst_13709 = (state_13744[(7)]);
var _ = (function (){var statearr_13767 = state_13744;
(statearr_13767[(4)] = cljs.core.cons((12),(state_13744[(4)])));

return statearr_13767;
})();
var inst_13717 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_13709,t,novelty,fast_forward_db_QMARK_);
var state_13744__$1 = state_13744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13744__$1,(13),inst_13717);
} else {
if((state_val_13745 === (5))){
var _ = (function (){var statearr_13768 = state_13744;
(statearr_13768[(4)] = cljs.core.rest((state_13744[(4)])));

return statearr_13768;
})();
var state_13744__$1 = state_13744;
var ex13764 = (state_13744__$1[(2)]);
var statearr_13769_13796 = state_13744__$1;
(statearr_13769_13796[(5)] = ex13764);


if((ex13764 instanceof Error)){
var statearr_13770_13797 = state_13744__$1;
(statearr_13770_13797[(1)] = (4));

(statearr_13770_13797[(5)] = null);

} else {
throw ex13764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (14))){
var inst_13723 = (state_13744[(10)]);
var state_13744__$1 = state_13744;
var statearr_13771_13798 = state_13744__$1;
(statearr_13771_13798[(2)] = inst_13723);

(statearr_13771_13798[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (16))){
var inst_13737 = (state_13744[(2)]);
var state_13744__$1 = state_13744;
var statearr_13772_13799 = state_13744__$1;
(statearr_13772_13799[(2)] = inst_13737);

(statearr_13772_13799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (10))){
var inst_13723 = (state_13744[(10)]);
var inst_13723__$1 = (state_13744[(2)]);
var state_13744__$1 = (function (){var statearr_13773 = state_13744;
(statearr_13773[(10)] = inst_13723__$1);

return statearr_13773;
})();
if(cljs.core.truth_(inst_13723__$1)){
var statearr_13774_13800 = state_13744__$1;
(statearr_13774_13800[(1)] = (14));

} else {
var statearr_13775_13801 = state_13744__$1;
(statearr_13775_13801[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (18))){
var state_13744__$1 = state_13744;
var statearr_13776_13802 = state_13744__$1;
(statearr_13776_13802[(2)] = null);

(statearr_13776_13802[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13745 === (8))){
var inst_13739 = (state_13744[(2)]);
var _ = (function (){var statearr_13777 = state_13744;
(statearr_13777[(4)] = cljs.core.rest((state_13744[(4)])));

return statearr_13777;
})();
var state_13744__$1 = state_13744;
var statearr_13778_13803 = state_13744__$1;
(statearr_13778_13803[(2)] = inst_13739);

(statearr_13778_13803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0 = (function (){
var statearr_13779 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13779[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__);

(statearr_13779[(1)] = (1));

return statearr_13779;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1 = (function (state_13744){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_13744);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e13780){var ex__2417__auto__ = e13780;
var statearr_13781_13804 = state_13744;
(statearr_13781_13804[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_13744[(4)]))){
var statearr_13782_13805 = state_13744;
(statearr_13782_13805[(1)] = cljs.core.first((state_13744[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13806 = state_13744;
state_13744 = G__13806;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__ = function(state_13744){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1.call(this,state_13744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_13783 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_13783[(6)] = c__2436__auto__);

return statearr_13783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__13813 = arguments.length;
switch (G__13813) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13814 = (function (){var pred__13817 = cljs.core.identical_QMARK_;
var expr__13818 = test;
if(cljs.core.truth_((pred__13817.cljs$core$IFn$_invoke$arity$2 ? pred__13817.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13818) : pred__13817.call(null,cljs.core._EQ_,expr__13818)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13817.cljs$core$IFn$_invoke$arity$2 ? pred__13817.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13818) : pred__13817.call(null,cljs.core._LT_,expr__13818)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13817.cljs$core$IFn$_invoke$arity$2 ? pred__13817.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13818) : pred__13817.call(null,cljs.core._LT__EQ_,expr__13818)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13817.cljs$core$IFn$_invoke$arity$2 ? pred__13817.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13818) : pred__13817.call(null,cljs.core._GT_,expr__13818)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13817.cljs$core$IFn$_invoke$arity$2 ? pred__13817.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13818) : pred__13817.call(null,cljs.core._GT__EQ_,expr__13818)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13818)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13814,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13814,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13814,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13814,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14216){
var state_val_14217 = (state_14216[(1)]);
if((state_val_14217 === (121))){
var inst_14077 = (state_14216[(7)]);
var state_14216__$1 = state_14216;
var statearr_14218_14424 = state_14216__$1;
(statearr_14218_14424[(2)] = inst_14077);

(statearr_14218_14424[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (65))){
var state_14216__$1 = state_14216;
var statearr_14219_14425 = state_14216__$1;
(statearr_14219_14425[(2)] = fluree.db.util.core.min_integer);

(statearr_14219_14425[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (70))){
var state_14216__$1 = state_14216;
var statearr_14220_14426 = state_14216__$1;
(statearr_14220_14426[(2)] = true);

(statearr_14220_14426[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (62))){
var inst_13979 = (cljs.core._LT__EQ_ === end_test);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13979)){
var statearr_14221_14427 = state_14216__$1;
(statearr_14221_14427[(1)] = (64));

} else {
var statearr_14222_14428 = state_14216__$1;
(statearr_14222_14428[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (74))){
var inst_13988 = (state_14216[(8)]);
var state_14216__$1 = state_14216;
var statearr_14223_14429 = state_14216__$1;
(statearr_14223_14429[(2)] = inst_13988);

(statearr_14223_14429[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (110))){
var inst_14043 = (state_14216[(9)]);
var inst_14119 = (state_14216[(10)]);
var inst_14110 = (state_14216[(11)]);
var inst_14120 = (state_14216[(12)]);
var inst_14016 = (state_14216[(13)]);
var inst_14118 = (state_14216[(14)]);
var inst_14118__$1 = cljs.core.count(inst_14110);
var inst_14119__$1 = (inst_14043 + inst_14118__$1);
var inst_14120__$1 = (inst_14119__$1 - inst_14016);
var inst_14121 = cljs.core.pos_int_QMARK_(inst_14120__$1);
var state_14216__$1 = (function (){var statearr_14224 = state_14216;
(statearr_14224[(10)] = inst_14119__$1);

(statearr_14224[(12)] = inst_14120__$1);

(statearr_14224[(14)] = inst_14118__$1);

return statearr_14224;
})();
if(inst_14121){
var statearr_14225_14430 = state_14216__$1;
(statearr_14225_14430[(1)] = (113));

} else {
var statearr_14226_14431 = state_14216__$1;
(statearr_14226_14431[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (130))){
var inst_14179 = (state_14216[(15)]);
var state_14216__$1 = state_14216;
var statearr_14227_14432 = state_14216__$1;
(statearr_14227_14432[(2)] = inst_14179);

(statearr_14227_14432[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (128))){
var inst_14188 = (state_14216[(16)]);
var state_14216__$1 = state_14216;
var statearr_14228_14433 = state_14216__$1;
(statearr_14228_14433[(2)] = inst_14188);

(statearr_14228_14433[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (7))){
var state_14216__$1 = state_14216;
var statearr_14229_14434 = state_14216__$1;
(statearr_14229_14434[(2)] = false);

(statearr_14229_14434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (59))){
var state_14216__$1 = state_14216;
var statearr_14230_14435 = state_14216__$1;
(statearr_14230_14435[(2)] = (2147483647));

(statearr_14230_14435[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (86))){
var inst_14027 = (state_14216[(17)]);
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14050 = (state_14216[(19)]);
var inst_14022 = (state_14216[(20)]);
var inst_13986 = (state_14216[(21)]);
var inst_13931 = (state_14216[(22)]);
var inst_14041 = (state_14216[(23)]);
var inst_13987 = (state_14216[(24)]);
var inst_13967 = (state_14216[(25)]);
var inst_14009 = (state_14216[(26)]);
var inst_14023 = (state_14216[(27)]);
var inst_13940 = (state_14216[(28)]);
var inst_14018 = (state_14216[(29)]);
var inst_13887 = (state_14216[(30)]);
var inst_14028 = (state_14216[(31)]);
var inst_14010 = (state_14216[(32)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_13958 = (state_14216[(36)]);
var inst_14040 = (state_14216[(37)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13928 = (state_14216[(43)]);
var inst_14016 = (state_14216[(13)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13840 = (state_14216[(47)]);
var inst_14042 = (state_14216[(48)]);
var inst_13985 = (state_14216[(49)]);
var inst_14037 = (state_14216[(50)]);
var inst_14017 = (state_14216[(51)]);
var inst_14033 = (state_14216[(52)]);
var inst_13927 = (state_14216[(53)]);
var inst_14054 = (function (){var no_filter_QMARK_ = true;
var t = inst_14023;
var max_limit_QMARK_ = inst_14017;
var next_node = inst_14040;
var fast_forward_db_QMARK_ = inst_14028;
var s1 = inst_13887;
var o2 = inst_13949;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var i = inst_14042;
var m1 = inst_13976;
var root_node = inst_14033;
var s2 = inst_13896;
var vec__13833 = inst_13927;
var p2 = inst_13967;
var permissions = inst_14018;
var vec__13836 = inst_13928;
var limit = inst_14016;
var start_flake = inst_13986;
var map__13832 = inst_13875;
var flake_limit = inst_14010;
var offset = inst_14041;
var acc = inst_14044;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13940;
var end_flake = inst_13987;
var base_result = inst_14050;
var G__14051 = inst_14050;
var s = inst_14043;
var node_start = inst_14037;
var p1 = inst_13958;
var subject_fn = inst_13876;
var map__13839 = inst_14009;
var object_fn = inst_13931;
var idx_compare = inst_14022;
var op2 = inst_13852;
var m2 = inst_13985;
var novelty = inst_14027;
return (function (p1__13807_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__13807_SHARP_.o,start_flake.o);
});
})();
var inst_14055 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14054,inst_14050);
var state_14216__$1 = state_14216;
var statearr_14231_14436 = state_14216__$1;
(statearr_14231_14436[(2)] = inst_14055);

(statearr_14231_14436[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (20))){
var inst_13848 = (state_14216[(54)]);
var state_14216__$1 = state_14216;
var statearr_14232_14437 = state_14216__$1;
(statearr_14232_14437[(2)] = inst_13848);

(statearr_14232_14437[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (72))){
var inst_14001 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14233_14438 = state_14216__$1;
(statearr_14233_14438[(2)] = inst_14001);

(statearr_14233_14438[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (58))){
var state_14216__$1 = state_14216;
var statearr_14234_14439 = state_14216__$1;
(statearr_14234_14439[(2)] = fluree.db.util.core.min_integer);

(statearr_14234_14439[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (60))){
var inst_13974 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14235_14440 = state_14216__$1;
(statearr_14235_14440[(2)] = inst_13974);

(statearr_14235_14440[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (27))){
var state_14216__$1 = state_14216;
var statearr_14236_14441 = state_14216__$1;
(statearr_14236_14441[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (1))){
var state_14216__$1 = state_14216;
var statearr_14238_14442 = state_14216__$1;
(statearr_14238_14442[(2)] = null);

(statearr_14238_14442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (69))){
var inst_14004 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_14004)){
var statearr_14239_14443 = state_14216__$1;
(statearr_14239_14443[(1)] = (73));

} else {
var statearr_14240_14444 = state_14216__$1;
(statearr_14240_14444[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (101))){
var state_14216__$1 = state_14216;
var statearr_14241_14445 = state_14216__$1;
(statearr_14241_14445[(2)] = true);

(statearr_14241_14445[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (24))){
var inst_13850 = (state_14216[(55)]);
var inst_13900 = cljs.core.boolean_QMARK_(inst_13850);
var state_14216__$1 = state_14216;
if(inst_13900){
var statearr_14242_14446 = state_14216__$1;
(statearr_14242_14446[(1)] = (26));

} else {
var statearr_14243_14447 = state_14216__$1;
(statearr_14243_14447[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (102))){
var state_14216__$1 = state_14216;
var statearr_14244_14448 = state_14216__$1;
(statearr_14244_14448[(2)] = false);

(statearr_14244_14448[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (55))){
var inst_13846 = (state_14216[(56)]);
var state_14216__$1 = state_14216;
var statearr_14245_14449 = state_14216__$1;
(statearr_14245_14449[(2)] = inst_13846);

(statearr_14245_14449[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (85))){
var inst_14208 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14246_14450 = state_14216__$1;
(statearr_14246_14450[(2)] = inst_14208);

(statearr_14246_14450[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (39))){
var inst_13930 = (state_14216[(57)]);
var inst_13943 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13930);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(42),inst_13943);
} else {
if((state_val_14217 === (88))){
var inst_13876 = (state_14216[(46)]);
var inst_14058 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14247 = state_14216;
(statearr_14247[(58)] = inst_14058);

return statearr_14247;
})();
if(cljs.core.truth_(inst_13876)){
var statearr_14248_14451 = state_14216__$1;
(statearr_14248_14451[(1)] = (89));

} else {
var statearr_14249_14452 = state_14216__$1;
(statearr_14249_14452[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (46))){
var state_14216__$1 = state_14216;
var statearr_14250_14453 = state_14216__$1;
(statearr_14250_14453[(2)] = (-1));

(statearr_14250_14453[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (4))){
var inst_13820 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14251_14454 = state_14216__$1;
(statearr_14251_14454[(2)] = inst_13820);

(statearr_14251_14454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (77))){
var state_14216__$1 = state_14216;
var statearr_14252_14455 = state_14216__$1;
(statearr_14252_14455[(2)] = fluree.db.util.core.max_long);

(statearr_14252_14455[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (106))){
var inst_14077 = (state_14216[(7)]);
var inst_14175 = (state_14216[(2)]);
var inst_14176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14175,(0),null);
var inst_14177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14175,(1),null);
var inst_14178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14175,(2),null);
var inst_14179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14175,(3),null);
var state_14216__$1 = (function (){var statearr_14253 = state_14216;
(statearr_14253[(59)] = inst_14176);

(statearr_14253[(60)] = inst_14178);

(statearr_14253[(61)] = inst_14177);

(statearr_14253[(15)] = inst_14179);

return statearr_14253;
})();
if(cljs.core.truth_(inst_14077)){
var statearr_14254_14456 = state_14216__$1;
(statearr_14254_14456[(1)] = (120));

} else {
var statearr_14255_14457 = state_14216__$1;
(statearr_14255_14457[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (119))){
var inst_14161 = (state_14216[(2)]);
var inst_14162 = fluree.db.util.async.throw_err(inst_14161);
var state_14216__$1 = state_14216;
var statearr_14256_14458 = state_14216__$1;
(statearr_14256_14458[(2)] = inst_14162);

(statearr_14256_14458[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (95))){
var inst_14027 = (state_14216[(17)]);
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14050 = (state_14216[(19)]);
var inst_14022 = (state_14216[(20)]);
var inst_13986 = (state_14216[(21)]);
var inst_13931 = (state_14216[(22)]);
var inst_14041 = (state_14216[(23)]);
var inst_13987 = (state_14216[(24)]);
var inst_13967 = (state_14216[(25)]);
var inst_14009 = (state_14216[(26)]);
var inst_14023 = (state_14216[(27)]);
var inst_13940 = (state_14216[(28)]);
var inst_14018 = (state_14216[(29)]);
var inst_13887 = (state_14216[(30)]);
var inst_14028 = (state_14216[(31)]);
var inst_14010 = (state_14216[(32)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_13958 = (state_14216[(36)]);
var inst_14040 = (state_14216[(37)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13928 = (state_14216[(43)]);
var inst_14016 = (state_14216[(13)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13840 = (state_14216[(47)]);
var inst_14070 = (state_14216[(62)]);
var inst_14042 = (state_14216[(48)]);
var inst_13985 = (state_14216[(49)]);
var inst_14037 = (state_14216[(50)]);
var inst_14017 = (state_14216[(51)]);
var inst_14033 = (state_14216[(52)]);
var inst_13927 = (state_14216[(53)]);
var inst_14072 = (function (){var no_filter_QMARK_ = true;
var t = inst_14023;
var max_limit_QMARK_ = inst_14017;
var next_node = inst_14040;
var fast_forward_db_QMARK_ = inst_14028;
var s1 = inst_13887;
var o2 = inst_13949;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var i = inst_14042;
var m1 = inst_13976;
var root_node = inst_14033;
var s2 = inst_13896;
var vec__13833 = inst_13927;
var p2 = inst_13967;
var permissions = inst_14018;
var vec__13836 = inst_13928;
var limit = inst_14016;
var start_flake = inst_13986;
var map__13832 = inst_13875;
var flake_limit = inst_14010;
var offset = inst_14041;
var acc = inst_14044;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13940;
var end_flake = inst_13987;
var base_result = inst_14050;
var G__14051 = inst_14070;
var s = inst_14043;
var node_start = inst_14037;
var p1 = inst_13958;
var subject_fn = inst_13876;
var map__13839 = inst_14009;
var object_fn = inst_13931;
var idx_compare = inst_14022;
var op2 = inst_13852;
var m2 = inst_13985;
var novelty = inst_14027;
return (function (p1__13810_SHARP_){
var G__14257 = p1__13810_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__14257) : object_fn.call(null,G__14257));
});
})();
var inst_14073 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14072,inst_14070);
var state_14216__$1 = state_14216;
var statearr_14258_14459 = state_14216__$1;
(statearr_14258_14459[(2)] = inst_14073);

(statearr_14258_14459[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (54))){
var inst_13846 = (state_14216[(56)]);
var inst_13967 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14259 = state_14216;
(statearr_14259[(25)] = inst_13967);

return statearr_14259;
})();
if(cljs.core.truth_(inst_13846)){
var statearr_14260_14460 = state_14216__$1;
(statearr_14260_14460[(1)] = (55));

} else {
var statearr_14261_14461 = state_14216__$1;
(statearr_14261_14461[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (92))){
var inst_14027 = (state_14216[(17)]);
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14050 = (state_14216[(19)]);
var inst_14022 = (state_14216[(20)]);
var inst_13986 = (state_14216[(21)]);
var inst_13931 = (state_14216[(22)]);
var inst_14041 = (state_14216[(23)]);
var inst_13987 = (state_14216[(24)]);
var inst_13967 = (state_14216[(25)]);
var inst_14009 = (state_14216[(26)]);
var inst_14023 = (state_14216[(27)]);
var inst_13940 = (state_14216[(28)]);
var inst_14018 = (state_14216[(29)]);
var inst_13887 = (state_14216[(30)]);
var inst_14028 = (state_14216[(31)]);
var inst_14010 = (state_14216[(32)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_13958 = (state_14216[(36)]);
var inst_14040 = (state_14216[(37)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13928 = (state_14216[(43)]);
var inst_14016 = (state_14216[(13)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13840 = (state_14216[(47)]);
var inst_14042 = (state_14216[(48)]);
var inst_13985 = (state_14216[(49)]);
var inst_14064 = (state_14216[(63)]);
var inst_14037 = (state_14216[(50)]);
var inst_14017 = (state_14216[(51)]);
var inst_14033 = (state_14216[(52)]);
var inst_13927 = (state_14216[(53)]);
var inst_14066 = (function (){var no_filter_QMARK_ = true;
var t = inst_14023;
var max_limit_QMARK_ = inst_14017;
var next_node = inst_14040;
var fast_forward_db_QMARK_ = inst_14028;
var s1 = inst_13887;
var o2 = inst_13949;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var i = inst_14042;
var m1 = inst_13976;
var root_node = inst_14033;
var s2 = inst_13896;
var vec__13833 = inst_13927;
var p2 = inst_13967;
var permissions = inst_14018;
var vec__13836 = inst_13928;
var limit = inst_14016;
var start_flake = inst_13986;
var map__13832 = inst_13875;
var flake_limit = inst_14010;
var offset = inst_14041;
var acc = inst_14044;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13940;
var end_flake = inst_13987;
var base_result = inst_14050;
var G__14051 = inst_14064;
var s = inst_14043;
var node_start = inst_14037;
var p1 = inst_13958;
var subject_fn = inst_13876;
var map__13839 = inst_14009;
var object_fn = inst_13931;
var idx_compare = inst_14022;
var op2 = inst_13852;
var m2 = inst_13985;
var novelty = inst_14027;
return (function (p1__13809_SHARP_){
var G__14262 = p1__13809_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14262) : predicate_fn.call(null,G__14262));
});
})();
var inst_14067 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14066,inst_14064);
var state_14216__$1 = state_14216;
var statearr_14263_14462 = state_14216__$1;
(statearr_14263_14462[(2)] = inst_14067);

(statearr_14263_14462[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (104))){
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14010 = (state_14216[(32)]);
var inst_14076 = (state_14216[(64)]);
var inst_14042 = (state_14216[(48)]);
var inst_14088 = cljs.core.count(inst_14076);
var inst_14089 = (inst_14010 - inst_14042);
var inst_14090 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14089,inst_14076);
var inst_14091 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14044,inst_14090);
var inst_14092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14093 = (inst_14042 + inst_14088);
var inst_14094 = [(0),inst_14093,inst_14043,inst_14091];
var inst_14095 = (new cljs.core.PersistentVector(null,4,(5),inst_14092,inst_14094,null));
var state_14216__$1 = state_14216;
var statearr_14264_14463 = state_14216__$1;
(statearr_14264_14463[(2)] = inst_14095);

(statearr_14264_14463[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (15))){
var inst_13841 = (state_14216[(65)]);
var inst_13881 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13841);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(18),inst_13881);
} else {
if((state_val_14217 === (48))){
var inst_13849 = (state_14216[(66)]);
var inst_13958 = (state_14216[(2)]);
var inst_13959 = (inst_13849 == null);
var state_14216__$1 = (function (){var statearr_14265 = state_14216;
(statearr_14265[(36)] = inst_13958);

return statearr_14265;
})();
if(cljs.core.truth_(inst_13959)){
var statearr_14266_14464 = state_14216__$1;
(statearr_14266_14464[(1)] = (49));

} else {
var statearr_14267_14465 = state_14216__$1;
(statearr_14267_14465[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (50))){
var state_14216__$1 = state_14216;
var statearr_14268_14466 = state_14216__$1;
(statearr_14268_14466[(2)] = false);

(statearr_14268_14466[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (116))){
var inst_14137 = (state_14216[(67)]);
var inst_14010 = (state_14216[(32)]);
var inst_14138 = (state_14216[(68)]);
var inst_14136 = (state_14216[(69)]);
var inst_14141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14142 = (inst_14138 - inst_14010);
var inst_14143 = (inst_14137 - inst_14142);
var inst_14144 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14143,inst_14136);
var inst_14145 = [inst_14010,inst_14144];
var inst_14146 = (new cljs.core.PersistentVector(null,2,(5),inst_14141,inst_14145,null));
var state_14216__$1 = state_14216;
var statearr_14269_14467 = state_14216__$1;
(statearr_14269_14467[(2)] = inst_14146);

(statearr_14269_14467[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (75))){
var inst_14009 = (state_14216[(26)]);
var inst_14011 = (state_14216[(70)]);
var inst_14009__$1 = (state_14216[(2)]);
var inst_14010 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14009__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14011__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14009__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14012 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14009__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14216__$1 = (function (){var statearr_14270 = state_14216;
(statearr_14270[(26)] = inst_14009__$1);

(statearr_14270[(32)] = inst_14010);

(statearr_14270[(71)] = inst_14012);

(statearr_14270[(70)] = inst_14011__$1);

return statearr_14270;
})();
if(cljs.core.truth_(inst_14011__$1)){
var statearr_14271_14468 = state_14216__$1;
(statearr_14271_14468[(1)] = (76));

} else {
var statearr_14272_14469 = state_14216__$1;
(statearr_14272_14469[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (99))){
var inst_14017 = (state_14216[(51)]);
var state_14216__$1 = state_14216;
var statearr_14273_14470 = state_14216__$1;
(statearr_14273_14470[(2)] = inst_14017);

(statearr_14273_14470[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (21))){
var inst_13843 = (state_14216[(72)]);
var inst_13896 = (state_14216[(2)]);
var inst_13897 = cljs.core.boolean_QMARK_(inst_13843);
var state_14216__$1 = (function (){var statearr_14274 = state_14216;
(statearr_14274[(40)] = inst_13896);

return statearr_14274;
})();
if(inst_13897){
var statearr_14275_14471 = state_14216__$1;
(statearr_14275_14471[(1)] = (23));

} else {
var statearr_14276_14472 = state_14216__$1;
(statearr_14276_14472[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (31))){
var inst_13906 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14277_14473 = state_14216__$1;
(statearr_14277_14473[(2)] = inst_13906);

(statearr_14277_14473[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (113))){
var inst_14120 = (state_14216[(12)]);
var inst_14016 = (state_14216[(13)]);
var inst_14118 = (state_14216[(14)]);
var inst_14123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14124 = (inst_14118 - inst_14120);
var inst_14125 = [inst_14016,inst_14124];
var inst_14126 = (new cljs.core.PersistentVector(null,2,(5),inst_14123,inst_14125,null));
var state_14216__$1 = state_14216;
var statearr_14278_14474 = state_14216__$1;
(statearr_14278_14474[(2)] = inst_14126);

(statearr_14278_14474[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (32))){
var inst_13853 = (state_14216[(73)]);
var inst_13850 = (state_14216[(55)]);
var inst_13887 = (state_14216[(30)]);
var inst_13844 = (state_14216[(33)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13910 = (state_14216[(74)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13878 = (state_14216[(75)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13846 = (state_14216[(56)]);
var inst_13840 = (state_14216[(47)]);
var inst_13849 = (state_14216[(66)]);
var inst_13843 = (state_14216[(72)]);
var inst_13842 = (state_14216[(76)]);
var inst_13912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13914 = [null,null];
var inst_13915 = (new cljs.core.PersistentVector(null,2,(5),inst_13913,inst_13914,null));
var inst_13916 = (function (){var bool = inst_13910;
var temp__5733__auto__ = inst_13910;
var s1 = inst_13887;
var o2 = inst_13850;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var m1 = inst_13846;
var s2 = inst_13896;
var p2 = inst_13849;
var map__13832 = inst_13875;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13843;
var p1 = inst_13842;
var subject_fn = inst_13876;
var object_fn = inst_13878;
var op2 = inst_13852;
var m2 = inst_13853;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_13917 = [inst_13915,inst_13916];
var inst_13918 = (new cljs.core.PersistentVector(null,2,(5),inst_13912,inst_13917,null));
var state_14216__$1 = state_14216;
var statearr_14279_14475 = state_14216__$1;
(statearr_14279_14475[(2)] = inst_13918);

(statearr_14279_14475[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (40))){
var inst_13930 = (state_14216[(57)]);
var state_14216__$1 = state_14216;
var statearr_14280_14476 = state_14216__$1;
(statearr_14280_14476[(2)] = inst_13930);

(statearr_14280_14476[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (129))){
var inst_14200 = (state_14216[(2)]);
var inst_14201 = cljs.core.not(inst_14200);
var state_14216__$1 = state_14216;
if(inst_14201){
var statearr_14281_14477 = state_14216__$1;
(statearr_14281_14477[(1)] = (130));

} else {
var statearr_14282_14478 = state_14216__$1;
(statearr_14282_14478[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (91))){
var inst_13877 = (state_14216[(42)]);
var inst_14064 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14283 = state_14216;
(statearr_14283[(63)] = inst_14064);

return statearr_14283;
})();
if(cljs.core.truth_(inst_13877)){
var statearr_14284_14479 = state_14216__$1;
(statearr_14284_14479[(1)] = (92));

} else {
var statearr_14285_14480 = state_14216__$1;
(statearr_14285_14480[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (117))){
var inst_14138 = (state_14216[(68)]);
var inst_14136 = (state_14216[(69)]);
var inst_14148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14149 = [inst_14138,inst_14136];
var inst_14150 = (new cljs.core.PersistentVector(null,2,(5),inst_14148,inst_14149,null));
var state_14216__$1 = state_14216;
var statearr_14286_14481 = state_14216__$1;
(statearr_14286_14481[(2)] = inst_14150);

(statearr_14286_14481[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (108))){
var inst_14098 = (state_14216[(77)]);
var inst_14041 = (state_14216[(23)]);
var inst_14110 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14041,inst_14098);
var state_14216__$1 = (function (){var statearr_14287 = state_14216;
(statearr_14287[(11)] = inst_14110);

return statearr_14287;
})();
var statearr_14288_14482 = state_14216__$1;
(statearr_14288_14482[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (56))){
var inst_13970 = (cljs.core._GT__EQ_ === start_test);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13970)){
var statearr_14290_14483 = state_14216__$1;
(statearr_14290_14483[(1)] = (58));

} else {
var statearr_14291_14484 = state_14216__$1;
(statearr_14291_14484[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (33))){
var inst_13850 = (state_14216[(55)]);
var inst_13878 = (state_14216[(75)]);
var inst_13843 = (state_14216[(72)]);
var inst_13920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13922 = [inst_13843,inst_13850];
var inst_13923 = (new cljs.core.PersistentVector(null,2,(5),inst_13921,inst_13922,null));
var inst_13924 = [inst_13923,inst_13878];
var inst_13925 = (new cljs.core.PersistentVector(null,2,(5),inst_13920,inst_13924,null));
var state_14216__$1 = state_14216;
var statearr_14292_14485 = state_14216__$1;
(statearr_14292_14485[(2)] = inst_13925);

(statearr_14292_14485[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (13))){
var inst_13854 = (state_14216[(78)]);
var state_14216__$1 = state_14216;
var statearr_14293_14486 = state_14216__$1;
(statearr_14293_14486[(2)] = inst_13854);

(statearr_14293_14486[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (22))){
var inst_13892 = (state_14216[(2)]);
var inst_13893 = fluree.db.util.async.throw_err(inst_13892);
var state_14216__$1 = state_14216;
var statearr_14294_14487 = state_14216__$1;
(statearr_14294_14487[(2)] = inst_13893);

(statearr_14294_14487[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (90))){
var inst_14058 = (state_14216[(58)]);
var state_14216__$1 = state_14216;
var statearr_14295_14488 = state_14216__$1;
(statearr_14295_14488[(2)] = inst_14058);

(statearr_14295_14488[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (109))){
var inst_14173 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14296_14489 = state_14216__$1;
(statearr_14296_14489[(2)] = inst_14173);

(statearr_14296_14489[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (36))){
var inst_13929 = (state_14216[(79)]);
var state_14216__$1 = state_14216;
var statearr_14297_14490 = state_14216__$1;
(statearr_14297_14490[(2)] = inst_13929);

(statearr_14297_14490[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (41))){
var inst_13842 = (state_14216[(76)]);
var inst_13949 = (state_14216[(2)]);
var inst_13950 = (inst_13842 == null);
var state_14216__$1 = (function (){var statearr_14298 = state_14216;
(statearr_14298[(35)] = inst_13949);

return statearr_14298;
})();
if(cljs.core.truth_(inst_13950)){
var statearr_14299_14491 = state_14216__$1;
(statearr_14299_14491[(1)] = (43));

} else {
var statearr_14300_14492 = state_14216__$1;
(statearr_14300_14492[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (118))){
var inst_14133 = (state_14216[(80)]);
var inst_14152 = (state_14216[(2)]);
var inst_14153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14152,(0),null);
var inst_14154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14152,(1),null);
var inst_14155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14156 = [inst_14153,inst_14133,inst_14154];
var inst_14157 = (new cljs.core.PersistentVector(null,3,(5),inst_14155,inst_14156,null));
var state_14216__$1 = state_14216;
var statearr_14301_14493 = state_14216__$1;
(statearr_14301_14493[(2)] = inst_14157);

(statearr_14301_14493[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (89))){
var inst_14027 = (state_14216[(17)]);
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14050 = (state_14216[(19)]);
var inst_14022 = (state_14216[(20)]);
var inst_13986 = (state_14216[(21)]);
var inst_13931 = (state_14216[(22)]);
var inst_14041 = (state_14216[(23)]);
var inst_13987 = (state_14216[(24)]);
var inst_13967 = (state_14216[(25)]);
var inst_14009 = (state_14216[(26)]);
var inst_14023 = (state_14216[(27)]);
var inst_13940 = (state_14216[(28)]);
var inst_14018 = (state_14216[(29)]);
var inst_13887 = (state_14216[(30)]);
var inst_14028 = (state_14216[(31)]);
var inst_14010 = (state_14216[(32)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_14058 = (state_14216[(58)]);
var inst_13958 = (state_14216[(36)]);
var inst_14040 = (state_14216[(37)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13928 = (state_14216[(43)]);
var inst_14016 = (state_14216[(13)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13840 = (state_14216[(47)]);
var inst_14042 = (state_14216[(48)]);
var inst_13985 = (state_14216[(49)]);
var inst_14037 = (state_14216[(50)]);
var inst_14017 = (state_14216[(51)]);
var inst_14033 = (state_14216[(52)]);
var inst_13927 = (state_14216[(53)]);
var inst_14060 = (function (){var no_filter_QMARK_ = true;
var t = inst_14023;
var max_limit_QMARK_ = inst_14017;
var next_node = inst_14040;
var fast_forward_db_QMARK_ = inst_14028;
var s1 = inst_13887;
var o2 = inst_13949;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var i = inst_14042;
var m1 = inst_13976;
var root_node = inst_14033;
var s2 = inst_13896;
var vec__13833 = inst_13927;
var p2 = inst_13967;
var permissions = inst_14018;
var vec__13836 = inst_13928;
var limit = inst_14016;
var start_flake = inst_13986;
var map__13832 = inst_13875;
var flake_limit = inst_14010;
var offset = inst_14041;
var acc = inst_14044;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13940;
var end_flake = inst_13987;
var base_result = inst_14050;
var G__14051 = inst_14058;
var s = inst_14043;
var node_start = inst_14037;
var p1 = inst_13958;
var subject_fn = inst_13876;
var map__13839 = inst_14009;
var object_fn = inst_13931;
var idx_compare = inst_14022;
var op2 = inst_13852;
var m2 = inst_13985;
var novelty = inst_14027;
return (function (p1__13808_SHARP_){
var G__14302 = p1__13808_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14302) : subject_fn.call(null,G__14302));
});
})();
var inst_14061 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14060,inst_14058);
var state_14216__$1 = state_14216;
var statearr_14303_14494 = state_14216__$1;
(statearr_14303_14494[(2)] = inst_14061);

(statearr_14303_14494[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (100))){
var inst_14086 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_14086)){
var statearr_14304_14495 = state_14216__$1;
(statearr_14304_14495[(1)] = (104));

} else {
var statearr_14305_14496 = state_14216__$1;
(statearr_14305_14496[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (131))){
var inst_14196 = (state_14216[(81)]);
var inst_14176 = (state_14216[(59)]);
var inst_14178 = (state_14216[(60)]);
var inst_14177 = (state_14216[(61)]);
var inst_14179 = (state_14216[(15)]);
var inst_14040 = inst_14196;
var inst_14041 = inst_14176;
var inst_14042 = inst_14177;
var inst_14043 = inst_14178;
var inst_14044 = inst_14179;
var state_14216__$1 = (function (){var statearr_14306 = state_14216;
(statearr_14306[(18)] = inst_14044);

(statearr_14306[(9)] = inst_14043);

(statearr_14306[(23)] = inst_14041);

(statearr_14306[(37)] = inst_14040);

(statearr_14306[(48)] = inst_14042);

return statearr_14306;
})();
var statearr_14307_14497 = state_14216__$1;
(statearr_14307_14497[(2)] = null);

(statearr_14307_14497[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (122))){
var inst_14188 = (state_14216[(16)]);
var inst_14188__$1 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14308 = state_14216;
(statearr_14308[(16)] = inst_14188__$1);

return statearr_14308;
})();
if(cljs.core.truth_(inst_14188__$1)){
var statearr_14309_14498 = state_14216__$1;
(statearr_14309_14498[(1)] = (123));

} else {
var statearr_14310_14499 = state_14216__$1;
(statearr_14310_14499[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (43))){
var inst_13940 = (state_14216[(28)]);
var state_14216__$1 = state_14216;
var statearr_14311_14500 = state_14216__$1;
(statearr_14311_14500[(2)] = inst_13940);

(statearr_14311_14500[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (61))){
var inst_13853 = (state_14216[(73)]);
var state_14216__$1 = state_14216;
var statearr_14312_14501 = state_14216__$1;
(statearr_14312_14501[(2)] = inst_13853);

(statearr_14312_14501[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (29))){
var state_14216__$1 = state_14216;
var statearr_14313_14502 = state_14216__$1;
(statearr_14313_14502[(2)] = null);

(statearr_14313_14502[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (44))){
var state_14216__$1 = state_14216;
var statearr_14314_14503 = state_14216__$1;
(statearr_14314_14503[(2)] = false);

(statearr_14314_14503[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (93))){
var inst_14064 = (state_14216[(63)]);
var state_14216__$1 = state_14216;
var statearr_14315_14504 = state_14216__$1;
(statearr_14315_14504[(2)] = inst_14064);

(statearr_14315_14504[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (6))){
var inst_13854 = (state_14216[(78)]);
var inst_13859 = inst_13854.cljs$lang$protocol_mask$partition0$;
var inst_13860 = (inst_13859 & (64));
var inst_13861 = inst_13854.cljs$core$ISeq$;
var inst_13862 = (cljs.core.PROTOCOL_SENTINEL === inst_13861);
var inst_13863 = ((inst_13860) || (inst_13862));
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13863)){
var statearr_14316_14505 = state_14216__$1;
(statearr_14316_14505[(1)] = (9));

} else {
var statearr_14317_14506 = state_14216__$1;
(statearr_14317_14506[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (111))){
var inst_14043 = (state_14216[(9)]);
var inst_14010 = (state_14216[(32)]);
var inst_14110 = (state_14216[(11)]);
var inst_14016 = (state_14216[(13)]);
var inst_14042 = (state_14216[(48)]);
var inst_14159 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14110,inst_14042,inst_14043,inst_14010,inst_14016);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(119),inst_14159);
} else {
if((state_val_14217 === (28))){
var inst_13908 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14318_14507 = state_14216__$1;
(statearr_14318_14507[(2)] = inst_13908);

(statearr_14318_14507[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (64))){
var state_14216__$1 = state_14216;
var statearr_14319_14508 = state_14216__$1;
(statearr_14319_14508[(2)] = (2147483647));

(statearr_14319_14508[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (103))){
var inst_14083 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14320_14509 = state_14216__$1;
(statearr_14320_14509[(2)] = inst_14083);

(statearr_14320_14509[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (51))){
var inst_13963 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13963)){
var statearr_14321_14510 = state_14216__$1;
(statearr_14321_14510[(1)] = (52));

} else {
var statearr_14322_14511 = state_14216__$1;
(statearr_14322_14511[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (25))){
var inst_13910 = (state_14216[(74)]);
var inst_13910__$1 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14323 = state_14216;
(statearr_14323[(74)] = inst_13910__$1);

return statearr_14323;
})();
if(cljs.core.truth_(inst_13910__$1)){
var statearr_14324_14512 = state_14216__$1;
(statearr_14324_14512[(1)] = (32));

} else {
var statearr_14325_14513 = state_14216__$1;
(statearr_14325_14513[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (34))){
var inst_13929 = (state_14216[(79)]);
var inst_13928 = (state_14216[(43)]);
var inst_13927 = (state_14216[(53)]);
var inst_13927__$1 = (state_14216[(2)]);
var inst_13928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13927__$1,(0),null);
var inst_13929__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13928__$1,(0),null);
var inst_13930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13928__$1,(1),null);
var inst_13931 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13927__$1,(1),null);
var inst_13932 = fluree.db.util.core.pred_ident_QMARK_(inst_13929__$1);
var state_14216__$1 = (function (){var statearr_14326 = state_14216;
(statearr_14326[(22)] = inst_13931);

(statearr_14326[(57)] = inst_13930);

(statearr_14326[(79)] = inst_13929__$1);

(statearr_14326[(43)] = inst_13928__$1);

(statearr_14326[(53)] = inst_13927__$1);

return statearr_14326;
})();
if(inst_13932){
var statearr_14327_14514 = state_14216__$1;
(statearr_14327_14514[(1)] = (35));

} else {
var statearr_14328_14515 = state_14216__$1;
(statearr_14328_14515[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (125))){
var inst_14188 = (state_14216[(16)]);
var inst_14196 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14329 = state_14216;
(statearr_14329[(81)] = inst_14196);

return statearr_14329;
})();
if(cljs.core.truth_(inst_14188)){
var statearr_14330_14516 = state_14216__$1;
(statearr_14330_14516[(1)] = (127));

} else {
var statearr_14331_14517 = state_14216__$1;
(statearr_14331_14517[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (17))){
var inst_13848 = (state_14216[(54)]);
var inst_13887 = (state_14216[(2)]);
var inst_13888 = fluree.db.util.core.pred_ident_QMARK_(inst_13848);
var state_14216__$1 = (function (){var statearr_14332 = state_14216;
(statearr_14332[(30)] = inst_13887);

return statearr_14332;
})();
if(inst_13888){
var statearr_14333_14518 = state_14216__$1;
(statearr_14333_14518[(1)] = (19));

} else {
var statearr_14334_14519 = state_14216__$1;
(statearr_14334_14519[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (3))){
var inst_14214 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14216__$1,inst_14214);
} else {
if((state_val_14217 === (12))){
var inst_13854 = (state_14216[(78)]);
var inst_13872 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_13854);
var state_14216__$1 = state_14216;
var statearr_14335_14520 = state_14216__$1;
(statearr_14335_14520[(2)] = inst_13872);

(statearr_14335_14520[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (2))){
var inst_13847 = (state_14216[(45)]);
var inst_13840 = (state_14216[(47)]);
var inst_13854 = (state_14216[(78)]);
var _ = (function (){var statearr_14336 = state_14216;
(statearr_14336[(4)] = cljs.core.cons((5),(state_14216[(4)])));

return statearr_14336;
})();
var inst_13840__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(0),null);
var inst_13842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(1),null);
var inst_13843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(2),null);
var inst_13844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(3),null);
var inst_13845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(4),null);
var inst_13846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13840__$1,(5),null);
var inst_13847__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(0),null);
var inst_13849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(1),null);
var inst_13850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(2),null);
var inst_13851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(3),null);
var inst_13852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(4),null);
var inst_13853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13847__$1,(5),null);
var inst_13854__$1 = opts;
var inst_13856 = (inst_13854__$1 == null);
var inst_13857 = cljs.core.not(inst_13856);
var state_14216__$1 = (function (){var statearr_14337 = state_14216;
(statearr_14337[(73)] = inst_13853);

(statearr_14337[(55)] = inst_13850);

(statearr_14337[(54)] = inst_13848);

(statearr_14337[(33)] = inst_13844);

(statearr_14337[(65)] = inst_13841);

(statearr_14337[(38)] = inst_13851);

(statearr_14337[(39)] = inst_13852);

(statearr_14337[(41)] = inst_13845);

(statearr_14337[(45)] = inst_13847__$1);

(statearr_14337[(56)] = inst_13846);

(statearr_14337[(47)] = inst_13840__$1);

(statearr_14337[(66)] = inst_13849);

(statearr_14337[(72)] = inst_13843);

(statearr_14337[(78)] = inst_13854__$1);

(statearr_14337[(76)] = inst_13842);

return statearr_14337;
})();
if(inst_13857){
var statearr_14338_14521 = state_14216__$1;
(statearr_14338_14521[(1)] = (6));

} else {
var statearr_14339_14522 = state_14216__$1;
(statearr_14339_14522[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (66))){
var inst_13983 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14340_14523 = state_14216__$1;
(statearr_14340_14523[(2)] = inst_13983);

(statearr_14340_14523[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (107))){
var inst_14044 = (state_14216[(18)]);
var inst_14043 = (state_14216[(9)]);
var inst_14099 = (state_14216[(82)]);
var inst_14041 = (state_14216[(23)]);
var inst_14042 = (state_14216[(48)]);
var inst_14102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14103 = (inst_14041 - inst_14099);
var inst_14104 = [inst_14103,inst_14042,inst_14043,inst_14044];
var inst_14105 = (new cljs.core.PersistentVector(null,4,(5),inst_14102,inst_14104,null));
var state_14216__$1 = state_14216;
var statearr_14341_14524 = state_14216__$1;
(statearr_14341_14524[(2)] = inst_14105);

(statearr_14341_14524[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (23))){
var inst_13843 = (state_14216[(72)]);
var state_14216__$1 = state_14216;
var statearr_14342_14525 = state_14216__$1;
(statearr_14342_14525[(2)] = inst_13843);

(statearr_14342_14525[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (47))){
var inst_13842 = (state_14216[(76)]);
var state_14216__$1 = state_14216;
var statearr_14343_14526 = state_14216__$1;
(statearr_14343_14526[(2)] = inst_13842);

(statearr_14343_14526[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (35))){
var inst_13929 = (state_14216[(79)]);
var inst_13934 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13929);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(38),inst_13934);
} else {
if((state_val_14217 === (127))){
var inst_14196 = (state_14216[(81)]);
var state_14216__$1 = state_14216;
var statearr_14344_14527 = state_14216__$1;
(statearr_14344_14527[(2)] = inst_14196);

(statearr_14344_14527[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (82))){
var state_14216__$1 = state_14216;
var statearr_14345_14528 = state_14216__$1;
(statearr_14345_14528[(2)] = null);

(statearr_14345_14528[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (76))){
var inst_14011 = (state_14216[(70)]);
var state_14216__$1 = state_14216;
var statearr_14346_14529 = state_14216__$1;
(statearr_14346_14529[(2)] = inst_14011);

(statearr_14346_14529[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (97))){
var inst_14040 = (state_14216[(37)]);
var inst_14017 = (state_14216[(51)]);
var inst_14076 = (state_14216[(2)]);
var inst_14077 = fluree.db.dbproto._rhs(inst_14040);
var state_14216__$1 = (function (){var statearr_14347 = state_14216;
(statearr_14347[(64)] = inst_14076);

(statearr_14347[(7)] = inst_14077);

return statearr_14347;
})();
if(cljs.core.truth_(inst_14017)){
var statearr_14348_14530 = state_14216__$1;
(statearr_14348_14530[(1)] = (98));

} else {
var statearr_14349_14531 = state_14216__$1;
(statearr_14349_14531[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (19))){
var inst_13848 = (state_14216[(54)]);
var inst_13890 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13848);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(22),inst_13890);
} else {
if((state_val_14217 === (57))){
var inst_13853 = (state_14216[(73)]);
var inst_13976 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14350 = state_14216;
(statearr_14350[(34)] = inst_13976);

return statearr_14350;
})();
if(cljs.core.truth_(inst_13853)){
var statearr_14351_14532 = state_14216__$1;
(statearr_14351_14532[(1)] = (61));

} else {
var statearr_14352_14533 = state_14216__$1;
(statearr_14352_14533[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (68))){
var state_14216__$1 = state_14216;
var statearr_14353_14534 = state_14216__$1;
(statearr_14353_14534[(2)] = false);

(statearr_14353_14534[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (11))){
var inst_13867 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14354_14535 = state_14216__$1;
(statearr_14354_14535[(2)] = inst_13867);

(statearr_14354_14535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (115))){
var inst_14137 = (state_14216[(67)]);
var inst_14010 = (state_14216[(32)]);
var inst_14110 = (state_14216[(11)]);
var inst_14138 = (state_14216[(68)]);
var inst_14042 = (state_14216[(48)]);
var inst_14136 = (state_14216[(69)]);
var inst_14132 = (state_14216[(2)]);
var inst_14133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14132,(0),null);
var inst_14134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14132,(1),null);
var inst_14135 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14134,inst_14110);
var inst_14136__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14135);
var inst_14137__$1 = cljs.core.count(inst_14136__$1);
var inst_14138__$1 = (inst_14042 + inst_14137__$1);
var inst_14139 = (inst_14138__$1 > inst_14010);
var state_14216__$1 = (function (){var statearr_14356 = state_14216;
(statearr_14356[(67)] = inst_14137__$1);

(statearr_14356[(80)] = inst_14133);

(statearr_14356[(68)] = inst_14138__$1);

(statearr_14356[(69)] = inst_14136__$1);

return statearr_14356;
})();
if(cljs.core.truth_(inst_14139)){
var statearr_14357_14536 = state_14216__$1;
(statearr_14357_14536[(1)] = (116));

} else {
var statearr_14358_14537 = state_14216__$1;
(statearr_14358_14537[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (9))){
var state_14216__$1 = state_14216;
var statearr_14359_14538 = state_14216__$1;
(statearr_14359_14538[(2)] = true);

(statearr_14359_14538[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (5))){
var _ = (function (){var statearr_14360 = state_14216;
(statearr_14360[(4)] = cljs.core.rest((state_14216[(4)])));

return statearr_14360;
})();
var state_14216__$1 = state_14216;
var ex14355 = (state_14216__$1[(2)]);
var statearr_14361_14539 = state_14216__$1;
(statearr_14361_14539[(5)] = ex14355);


if((ex14355 instanceof Error)){
var statearr_14362_14540 = state_14216__$1;
(statearr_14362_14540[(1)] = (4));

(statearr_14362_14540[(5)] = null);

} else {
throw ex14355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (112))){
var inst_14044 = (state_14216[(18)]);
var inst_14164 = (state_14216[(2)]);
var inst_14165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14164,(0),null);
var inst_14166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14164,(1),null);
var inst_14167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14164,(2),null);
var inst_14168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14169 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14044,inst_14167);
var inst_14170 = [(0),inst_14165,inst_14166,inst_14169];
var inst_14171 = (new cljs.core.PersistentVector(null,4,(5),inst_14168,inst_14170,null));
var state_14216__$1 = state_14216;
var statearr_14363_14541 = state_14216__$1;
(statearr_14363_14541[(2)] = inst_14171);

(statearr_14363_14541[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (83))){
var inst_14211 = (state_14216[(2)]);
var _ = (function (){var statearr_14364 = state_14216;
(statearr_14364[(4)] = cljs.core.rest((state_14216[(4)])));

return statearr_14364;
})();
var state_14216__$1 = state_14216;
var statearr_14365_14542 = state_14216__$1;
(statearr_14365_14542[(2)] = inst_14211);

(statearr_14365_14542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (14))){
var inst_13841 = (state_14216[(65)]);
var inst_13875 = (state_14216[(44)]);
var inst_13875__$1 = (state_14216[(2)]);
var inst_13876 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13875__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_13877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13875__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_13878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13875__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_13879 = fluree.db.util.core.pred_ident_QMARK_(inst_13841);
var state_14216__$1 = (function (){var statearr_14366 = state_14216;
(statearr_14366[(42)] = inst_13877);

(statearr_14366[(75)] = inst_13878);

(statearr_14366[(44)] = inst_13875__$1);

(statearr_14366[(46)] = inst_13876);

return statearr_14366;
})();
if(inst_13879){
var statearr_14367_14543 = state_14216__$1;
(statearr_14367_14543[(1)] = (15));

} else {
var statearr_14368_14544 = state_14216__$1;
(statearr_14368_14544[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (45))){
var inst_13954 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13954)){
var statearr_14369_14545 = state_14216__$1;
(statearr_14369_14545[(1)] = (46));

} else {
var statearr_14370_14546 = state_14216__$1;
(statearr_14370_14546[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (53))){
var inst_13849 = (state_14216[(66)]);
var state_14216__$1 = state_14216;
var statearr_14371_14547 = state_14216__$1;
(statearr_14371_14547[(2)] = inst_13849);

(statearr_14371_14547[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (78))){
var inst_14016 = (state_14216[(13)]);
var inst_14016__$1 = (state_14216[(2)]);
var inst_14017 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14016__$1,fluree.db.util.core.max_long);
var inst_14018 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14020 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14021 = (new cljs.core.PersistentVector(null,3,(5),inst_14019,inst_14020,null));
var inst_14022 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14021);
var inst_14023 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14025 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14026 = (new cljs.core.PersistentVector(null,2,(5),inst_14024,inst_14025,null));
var inst_14027 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14026);
var inst_14028 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14030 = fluree.db.dbproto._resolve(inst_14029);
var state_14216__$1 = (function (){var statearr_14372 = state_14216;
(statearr_14372[(17)] = inst_14027);

(statearr_14372[(20)] = inst_14022);

(statearr_14372[(27)] = inst_14023);

(statearr_14372[(29)] = inst_14018);

(statearr_14372[(31)] = inst_14028);

(statearr_14372[(13)] = inst_14016__$1);

(statearr_14372[(51)] = inst_14017);

return statearr_14372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(79),inst_14030);
} else {
if((state_val_14217 === (132))){
var inst_14206 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
var statearr_14373_14548 = state_14216__$1;
(statearr_14373_14548[(2)] = inst_14206);

(statearr_14373_14548[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (26))){
var inst_13850 = (state_14216[(55)]);
var state_14216__$1 = state_14216;
var statearr_14374_14549 = state_14216__$1;
(statearr_14374_14549[(2)] = inst_13850);

(statearr_14374_14549[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (123))){
var inst_14027 = (state_14216[(17)]);
var inst_14023 = (state_14216[(27)]);
var inst_14028 = (state_14216[(31)]);
var inst_14077 = (state_14216[(7)]);
var inst_14033 = (state_14216[(52)]);
var inst_14190 = fluree.db.query.range.find_next_valid_node(inst_14033,inst_14077,inst_14023,inst_14027,inst_14028);
var state_14216__$1 = state_14216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(126),inst_14190);
} else {
if((state_val_14217 === (16))){
var inst_13841 = (state_14216[(65)]);
var state_14216__$1 = state_14216;
var statearr_14375_14550 = state_14216__$1;
(statearr_14375_14550[(2)] = inst_13841);

(statearr_14375_14550[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (81))){
var inst_14012 = (state_14216[(71)]);
var inst_14037 = (state_14216[(50)]);
var inst_14039 = cljs.core.PersistentVector.EMPTY;
var inst_14040 = inst_14037;
var inst_14041 = inst_14012;
var inst_14042 = (0);
var inst_14043 = (0);
var inst_14044 = inst_14039;
var state_14216__$1 = (function (){var statearr_14376 = state_14216;
(statearr_14376[(18)] = inst_14044);

(statearr_14376[(9)] = inst_14043);

(statearr_14376[(23)] = inst_14041);

(statearr_14376[(37)] = inst_14040);

(statearr_14376[(48)] = inst_14042);

return statearr_14376;
})();
var statearr_14377_14551 = state_14216__$1;
(statearr_14377_14551[(2)] = null);

(statearr_14377_14551[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (120))){
var inst_14022 = (state_14216[(20)]);
var inst_13987 = (state_14216[(24)]);
var inst_14010 = (state_14216[(32)]);
var inst_14178 = (state_14216[(60)]);
var inst_14177 = (state_14216[(61)]);
var inst_14077 = (state_14216[(7)]);
var inst_14016 = (state_14216[(13)]);
var inst_14181 = (inst_14022.cljs$core$IFn$_invoke$arity$2 ? inst_14022.cljs$core$IFn$_invoke$arity$2(inst_14077,inst_13987) : inst_14022.call(null,inst_14077,inst_13987));
var inst_14182 = (inst_14181 < (0));
var inst_14183 = (inst_14177 < inst_14010);
var inst_14184 = (inst_14178 < inst_14016);
var inst_14185 = ((inst_14182) && (inst_14183) && (inst_14184));
var state_14216__$1 = state_14216;
var statearr_14378_14552 = state_14216__$1;
(statearr_14378_14552[(2)] = inst_14185);

(statearr_14378_14552[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (79))){
var inst_14027 = (state_14216[(17)]);
var inst_13986 = (state_14216[(21)]);
var inst_14023 = (state_14216[(27)]);
var inst_14028 = (state_14216[(31)]);
var inst_14033 = (state_14216[(52)]);
var inst_14032 = (state_14216[(2)]);
var inst_14033__$1 = fluree.db.util.async.throw_err(inst_14032);
var inst_14034 = fluree.db.query.range.find_next_valid_node(inst_14033__$1,inst_13986,inst_14023,inst_14027,inst_14028);
var state_14216__$1 = (function (){var statearr_14379 = state_14216;
(statearr_14379[(52)] = inst_14033__$1);

return statearr_14379;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14216__$1,(80),inst_14034);
} else {
if((state_val_14217 === (38))){
var inst_13936 = (state_14216[(2)]);
var inst_13937 = fluree.db.util.async.throw_err(inst_13936);
var state_14216__$1 = state_14216;
var statearr_14380_14553 = state_14216__$1;
(statearr_14380_14553[(2)] = inst_13937);

(statearr_14380_14553[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (126))){
var inst_14192 = (state_14216[(2)]);
var inst_14193 = fluree.db.util.async.throw_err(inst_14192);
var state_14216__$1 = state_14216;
var statearr_14381_14554 = state_14216__$1;
(statearr_14381_14554[(2)] = inst_14193);

(statearr_14381_14554[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (98))){
var inst_14041 = (state_14216[(23)]);
var inst_14079 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14041);
var state_14216__$1 = state_14216;
if(inst_14079){
var statearr_14382_14555 = state_14216__$1;
(statearr_14382_14555[(1)] = (101));

} else {
var statearr_14383_14556 = state_14216__$1;
(statearr_14383_14556[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (124))){
var state_14216__$1 = state_14216;
var statearr_14384_14557 = state_14216__$1;
(statearr_14384_14557[(2)] = null);

(statearr_14384_14557[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (87))){
var inst_14050 = (state_14216[(19)]);
var state_14216__$1 = state_14216;
var statearr_14385_14558 = state_14216__$1;
(statearr_14385_14558[(2)] = inst_14050);

(statearr_14385_14558[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (30))){
var state_14216__$1 = state_14216;
var statearr_14386_14559 = state_14216__$1;
(statearr_14386_14559[(2)] = null);

(statearr_14386_14559[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (73))){
var inst_13988 = (state_14216[(8)]);
var inst_14006 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_13988);
var state_14216__$1 = state_14216;
var statearr_14387_14560 = state_14216__$1;
(statearr_14387_14560[(2)] = inst_14006);

(statearr_14387_14560[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (96))){
var inst_14070 = (state_14216[(62)]);
var state_14216__$1 = state_14216;
var statearr_14388_14561 = state_14216__$1;
(statearr_14388_14561[(2)] = inst_14070);

(statearr_14388_14561[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (10))){
var state_14216__$1 = state_14216;
var statearr_14389_14562 = state_14216__$1;
(statearr_14389_14562[(2)] = false);

(statearr_14389_14562[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (18))){
var inst_13883 = (state_14216[(2)]);
var inst_13884 = fluree.db.util.async.throw_err(inst_13883);
var state_14216__$1 = state_14216;
var statearr_14390_14563 = state_14216__$1;
(statearr_14390_14563[(2)] = inst_13884);

(statearr_14390_14563[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (105))){
var inst_14027 = (state_14216[(17)]);
var inst_14044 = (state_14216[(18)]);
var inst_14098 = (state_14216[(77)]);
var inst_14043 = (state_14216[(9)]);
var inst_14050 = (state_14216[(19)]);
var inst_14022 = (state_14216[(20)]);
var inst_13986 = (state_14216[(21)]);
var inst_13931 = (state_14216[(22)]);
var inst_14099 = (state_14216[(82)]);
var inst_14041 = (state_14216[(23)]);
var inst_13987 = (state_14216[(24)]);
var inst_13967 = (state_14216[(25)]);
var inst_14009 = (state_14216[(26)]);
var inst_14023 = (state_14216[(27)]);
var inst_13940 = (state_14216[(28)]);
var inst_14018 = (state_14216[(29)]);
var inst_13887 = (state_14216[(30)]);
var inst_14028 = (state_14216[(31)]);
var inst_14010 = (state_14216[(32)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_13958 = (state_14216[(36)]);
var inst_14040 = (state_14216[(37)]);
var inst_14076 = (state_14216[(64)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13877 = (state_14216[(42)]);
var inst_13928 = (state_14216[(43)]);
var inst_14077 = (state_14216[(7)]);
var inst_14016 = (state_14216[(13)]);
var inst_13875 = (state_14216[(44)]);
var inst_13847 = (state_14216[(45)]);
var inst_13876 = (state_14216[(46)]);
var inst_13840 = (state_14216[(47)]);
var inst_14042 = (state_14216[(48)]);
var inst_13985 = (state_14216[(49)]);
var inst_14037 = (state_14216[(50)]);
var inst_14017 = (state_14216[(51)]);
var inst_14033 = (state_14216[(52)]);
var inst_13927 = (state_14216[(53)]);
var inst_14097 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_14076;
var t = inst_14023;
var max_limit_QMARK_ = inst_14017;
var next_node = inst_14040;
var fast_forward_db_QMARK_ = inst_14028;
var s1 = inst_13887;
var o2 = inst_13949;
var t1 = inst_13844;
var predicate_fn = inst_13877;
var i = inst_14042;
var rhs = inst_14077;
var m1 = inst_13976;
var root_node = inst_14033;
var s2 = inst_13896;
var vec__13833 = inst_13927;
var p2 = inst_13967;
var permissions = inst_14018;
var vec__13836 = inst_13928;
var limit = inst_14016;
var start_flake = inst_13986;
var map__13832 = inst_13875;
var flake_limit = inst_14010;
var offset = inst_14041;
var acc = inst_14044;
var vec__13826 = inst_13840;
var t2 = inst_13851;
var vec__13829 = inst_13847;
var op1 = inst_13845;
var o1 = inst_13940;
var end_flake = inst_13987;
var base_result = inst_14050;
var s = inst_14043;
var node_start = inst_14037;
var p1 = inst_13958;
var subject_fn = inst_13876;
var map__13839 = inst_14009;
var object_fn = inst_13931;
var idx_compare = inst_14022;
var op2 = inst_13852;
var m2 = inst_13985;
var novelty = inst_14027;
return (function (p1__13811_SHARP_){
return p1__13811_SHARP_.s;
});
})();
var inst_14098__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14097,inst_14076);
var inst_14099__$1 = cljs.core.count(inst_14098__$1);
var inst_14100 = (inst_14041 > inst_14099__$1);
var state_14216__$1 = (function (){var statearr_14391 = state_14216;
(statearr_14391[(77)] = inst_14098__$1);

(statearr_14391[(82)] = inst_14099__$1);

return statearr_14391;
})();
if(cljs.core.truth_(inst_14100)){
var statearr_14392_14564 = state_14216__$1;
(statearr_14392_14564[(1)] = (107));

} else {
var statearr_14393_14565 = state_14216__$1;
(statearr_14393_14565[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (52))){
var state_14216__$1 = state_14216;
var statearr_14394_14566 = state_14216__$1;
(statearr_14394_14566[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14394_14566[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (114))){
var inst_14119 = (state_14216[(10)]);
var inst_14128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14129 = [inst_14119,inst_14119];
var inst_14130 = (new cljs.core.PersistentVector(null,2,(5),inst_14128,inst_14129,null));
var state_14216__$1 = state_14216;
var statearr_14395_14567 = state_14216__$1;
(statearr_14395_14567[(2)] = inst_14130);

(statearr_14395_14567[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (67))){
var inst_13988 = (state_14216[(8)]);
var inst_13993 = inst_13988.cljs$lang$protocol_mask$partition0$;
var inst_13994 = (inst_13993 & (64));
var inst_13995 = inst_13988.cljs$core$ISeq$;
var inst_13996 = (cljs.core.PROTOCOL_SENTINEL === inst_13995);
var inst_13997 = ((inst_13994) || (inst_13996));
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13997)){
var statearr_14396_14568 = state_14216__$1;
(statearr_14396_14568[(1)] = (70));

} else {
var statearr_14397_14569 = state_14216__$1;
(statearr_14397_14569[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (71))){
var state_14216__$1 = state_14216;
var statearr_14398_14570 = state_14216__$1;
(statearr_14398_14570[(2)] = false);

(statearr_14398_14570[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (42))){
var inst_13945 = (state_14216[(2)]);
var inst_13946 = fluree.db.util.async.throw_err(inst_13945);
var state_14216__$1 = state_14216;
var statearr_14399_14571 = state_14216__$1;
(statearr_14399_14571[(2)] = inst_13946);

(statearr_14399_14571[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (80))){
var inst_14037 = (state_14216[(50)]);
var inst_14036 = (state_14216[(2)]);
var inst_14037__$1 = fluree.db.util.async.throw_err(inst_14036);
var state_14216__$1 = (function (){var statearr_14400 = state_14216;
(statearr_14400[(50)] = inst_14037__$1);

return statearr_14400;
})();
if(cljs.core.truth_(inst_14037__$1)){
var statearr_14401_14572 = state_14216__$1;
(statearr_14401_14572[(1)] = (81));

} else {
var statearr_14402_14573 = state_14216__$1;
(statearr_14402_14573[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (37))){
var inst_13930 = (state_14216[(57)]);
var inst_13940 = (state_14216[(2)]);
var inst_13941 = fluree.db.util.core.pred_ident_QMARK_(inst_13930);
var state_14216__$1 = (function (){var statearr_14403 = state_14216;
(statearr_14403[(28)] = inst_13940);

return statearr_14403;
})();
if(inst_13941){
var statearr_14404_14574 = state_14216__$1;
(statearr_14404_14574[(1)] = (39));

} else {
var statearr_14405_14575 = state_14216__$1;
(statearr_14405_14575[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (63))){
var inst_13967 = (state_14216[(25)]);
var inst_13940 = (state_14216[(28)]);
var inst_13887 = (state_14216[(30)]);
var inst_13844 = (state_14216[(33)]);
var inst_13976 = (state_14216[(34)]);
var inst_13949 = (state_14216[(35)]);
var inst_13958 = (state_14216[(36)]);
var inst_13851 = (state_14216[(38)]);
var inst_13852 = (state_14216[(39)]);
var inst_13896 = (state_14216[(40)]);
var inst_13845 = (state_14216[(41)]);
var inst_13988 = (state_14216[(8)]);
var inst_13985 = (state_14216[(49)]);
var inst_13985__$1 = (state_14216[(2)]);
var inst_13986 = fluree.db.flake.__GT_Flake(inst_13887,inst_13958,inst_13940,inst_13844,inst_13845,inst_13976);
var inst_13987 = fluree.db.flake.__GT_Flake(inst_13896,inst_13967,inst_13949,inst_13851,inst_13852,inst_13985__$1);
var inst_13988__$1 = opts;
var inst_13990 = (inst_13988__$1 == null);
var inst_13991 = cljs.core.not(inst_13990);
var state_14216__$1 = (function (){var statearr_14406 = state_14216;
(statearr_14406[(21)] = inst_13986);

(statearr_14406[(24)] = inst_13987);

(statearr_14406[(8)] = inst_13988__$1);

(statearr_14406[(49)] = inst_13985__$1);

return statearr_14406;
})();
if(inst_13991){
var statearr_14407_14576 = state_14216__$1;
(statearr_14407_14576[(1)] = (67));

} else {
var statearr_14408_14577 = state_14216__$1;
(statearr_14408_14577[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (94))){
var inst_13931 = (state_14216[(22)]);
var inst_14070 = (state_14216[(2)]);
var state_14216__$1 = (function (){var statearr_14409 = state_14216;
(statearr_14409[(62)] = inst_14070);

return statearr_14409;
})();
if(cljs.core.truth_(inst_13931)){
var statearr_14410_14578 = state_14216__$1;
(statearr_14410_14578[(1)] = (95));

} else {
var statearr_14411_14579 = state_14216__$1;
(statearr_14411_14579[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (8))){
var inst_13870 = (state_14216[(2)]);
var state_14216__$1 = state_14216;
if(cljs.core.truth_(inst_13870)){
var statearr_14412_14580 = state_14216__$1;
(statearr_14412_14580[(1)] = (12));

} else {
var statearr_14413_14581 = state_14216__$1;
(statearr_14413_14581[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (49))){
var inst_13949 = (state_14216[(35)]);
var state_14216__$1 = state_14216;
var statearr_14414_14582 = state_14216__$1;
(statearr_14414_14582[(2)] = inst_13949);

(statearr_14414_14582[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14217 === (84))){
var inst_13986 = (state_14216[(21)]);
var inst_13987 = (state_14216[(24)]);
var inst_14040 = (state_14216[(37)]);
var inst_14049 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14040);
var inst_14050 = fluree.db.flake.subrange(inst_14049,start_test,inst_13986,end_test,inst_13987);
var inst_14052 = fluree.db.query.range.value_with_nil_pred(idx,inst_13986,inst_13987);
var state_14216__$1 = (function (){var statearr_14415 = state_14216;
(statearr_14415[(19)] = inst_14050);

return statearr_14415;
})();
if(inst_14052){
var statearr_14416_14583 = state_14216__$1;
(statearr_14416_14583[(1)] = (86));

} else {
var statearr_14417_14584 = state_14216__$1;
(statearr_14417_14584[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_14418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14418[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_14418[(1)] = (1));

return statearr_14418;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_14216){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14216);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14419){var ex__2417__auto__ = e14419;
var statearr_14420_14585 = state_14216;
(statearr_14420_14585[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14216[(4)]))){
var statearr_14421_14586 = state_14216;
(statearr_14421_14586[(1)] = cljs.core.first((state_14216[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14587 = state_14216;
state_14216 = G__14587;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_14216){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_14216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14422 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14422[(6)] = c__2436__auto__);

return statearr_14422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14643){
var state_val_14644 = (state_14643[(1)]);
if((state_val_14644 === (7))){
var inst_14607 = (state_14643[(7)]);
var inst_14617 = (state_14643[(8)]);
var inst_14615 = fluree.db.flake.Flake__GT_parts(inst_14607);
var inst_14616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(0),null);
var inst_14617__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(1),null);
var inst_14618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(2),null);
var inst_14619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(3),null);
var inst_14620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(4),null);
var inst_14621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14615,(5),null);
var inst_14622 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_14618,inst_14617__$1);
var state_14643__$1 = (function (){var statearr_14645 = state_14643;
(statearr_14645[(8)] = inst_14617__$1);

(statearr_14645[(9)] = inst_14619);

(statearr_14645[(10)] = inst_14621);

(statearr_14645[(11)] = inst_14616);

(statearr_14645[(12)] = inst_14620);

return statearr_14645;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14643__$1,(10),inst_14622);
} else {
if((state_val_14644 === (1))){
var inst_14595 = flakes;
var inst_14596 = cljs.core.seq(inst_14595);
var inst_14597 = cljs.core.first(inst_14596);
var inst_14598 = cljs.core.next(inst_14596);
var inst_14599 = cljs.core.PersistentVector.EMPTY;
var inst_14600 = inst_14595;
var inst_14601 = inst_14599;
var state_14643__$1 = (function (){var statearr_14646 = state_14643;
(statearr_14646[(13)] = inst_14601);

(statearr_14646[(14)] = inst_14597);

(statearr_14646[(15)] = inst_14600);

(statearr_14646[(16)] = inst_14598);

return statearr_14646;
})();
var statearr_14647_14665 = state_14643__$1;
(statearr_14647_14665[(2)] = null);

(statearr_14647_14665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (4))){
var inst_14607 = (state_14643[(7)]);
var inst_14610 = fluree.db.query.range.is_tag_flake_QMARK_(inst_14607);
var state_14643__$1 = state_14643;
if(inst_14610){
var statearr_14648_14666 = state_14643__$1;
(statearr_14648_14666[(1)] = (7));

} else {
var statearr_14649_14667 = state_14643__$1;
(statearr_14649_14667[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (6))){
var inst_14639 = (state_14643[(2)]);
var state_14643__$1 = state_14643;
var statearr_14650_14668 = state_14643__$1;
(statearr_14650_14668[(2)] = inst_14639);

(statearr_14650_14668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (3))){
var inst_14641 = (state_14643[(2)]);
var state_14643__$1 = state_14643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14643__$1,inst_14641);
} else {
if((state_val_14644 === (2))){
var inst_14607 = (state_14643[(7)]);
var inst_14600 = (state_14643[(15)]);
var inst_14606 = cljs.core.seq(inst_14600);
var inst_14607__$1 = cljs.core.first(inst_14606);
var inst_14608 = cljs.core.next(inst_14606);
var state_14643__$1 = (function (){var statearr_14651 = state_14643;
(statearr_14651[(7)] = inst_14607__$1);

(statearr_14651[(17)] = inst_14608);

return statearr_14651;
})();
if(cljs.core.truth_(inst_14607__$1)){
var statearr_14652_14669 = state_14643__$1;
(statearr_14652_14669[(1)] = (4));

} else {
var statearr_14653_14670 = state_14643__$1;
(statearr_14653_14670[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (9))){
var inst_14636 = (state_14643[(2)]);
var state_14643__$1 = state_14643;
var statearr_14654_14671 = state_14643__$1;
(statearr_14654_14671[(2)] = inst_14636);

(statearr_14654_14671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (5))){
var inst_14601 = (state_14643[(13)]);
var state_14643__$1 = state_14643;
var statearr_14655_14672 = state_14643__$1;
(statearr_14655_14672[(2)] = inst_14601);

(statearr_14655_14672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (10))){
var inst_14601 = (state_14643[(13)]);
var inst_14617 = (state_14643[(8)]);
var inst_14619 = (state_14643[(9)]);
var inst_14608 = (state_14643[(17)]);
var inst_14621 = (state_14643[(10)]);
var inst_14616 = (state_14643[(11)]);
var inst_14620 = (state_14643[(12)]);
var inst_14624 = (state_14643[(2)]);
var inst_14625 = fluree.db.util.async.throw_err(inst_14624);
var inst_14626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14627 = [inst_14616,inst_14617,inst_14625,inst_14619,inst_14620,inst_14621];
var inst_14628 = (new cljs.core.PersistentVector(null,6,(5),inst_14626,inst_14627,null));
var inst_14629 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_14628);
var inst_14630 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14601,inst_14629);
var inst_14600 = inst_14608;
var inst_14601__$1 = inst_14630;
var state_14643__$1 = (function (){var statearr_14656 = state_14643;
(statearr_14656[(13)] = inst_14601__$1);

(statearr_14656[(15)] = inst_14600);

return statearr_14656;
})();
var statearr_14657_14673 = state_14643__$1;
(statearr_14657_14673[(2)] = null);

(statearr_14657_14673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14644 === (8))){
var inst_14607 = (state_14643[(7)]);
var inst_14601 = (state_14643[(13)]);
var inst_14608 = (state_14643[(17)]);
var inst_14633 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14601,inst_14607);
var inst_14600 = inst_14608;
var inst_14601__$1 = inst_14633;
var state_14643__$1 = (function (){var statearr_14658 = state_14643;
(statearr_14658[(13)] = inst_14601__$1);

(statearr_14658[(15)] = inst_14600);

return statearr_14658;
})();
var statearr_14659_14674 = state_14643__$1;
(statearr_14659_14674[(2)] = null);

(statearr_14659_14674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0 = (function (){
var statearr_14660 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14660[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__);

(statearr_14660[(1)] = (1));

return statearr_14660;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1 = (function (state_14643){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14643);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14661){var ex__2417__auto__ = e14661;
var statearr_14662_14675 = state_14643;
(statearr_14662_14675[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14643[(4)]))){
var statearr_14663_14676 = state_14643;
(statearr_14663_14676[(1)] = cljs.core.first((state_14643[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14677 = state_14643;
state_14643 = G__14677;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__ = function(state_14643){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1.call(this,state_14643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14664 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14664[(6)] = c__2436__auto__);

return statearr_14664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14679 = arguments.length;
switch (G__14679) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_14830){
var state_val_14831 = (state_14830[(1)]);
if((state_val_14831 === (62))){
var inst_14817 = (state_14830[(7)]);
var state_14830__$1 = state_14830;
var statearr_14832_14921 = state_14830__$1;
(statearr_14832_14921[(2)] = inst_14817);

(statearr_14832_14921[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (7))){
var state_14830__$1 = state_14830;
var statearr_14833_14922 = state_14830__$1;
(statearr_14833_14922[(2)] = false);

(statearr_14833_14922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (59))){
var inst_14809 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14834_14923 = state_14830__$1;
(statearr_14834_14923[(2)] = inst_14809);

(statearr_14834_14923[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (20))){
var state_14830__$1 = state_14830;
var statearr_14835_14924 = state_14830__$1;
(statearr_14835_14924[(2)] = null);

(statearr_14835_14924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (58))){
var state_14830__$1 = state_14830;
var statearr_14836_14925 = state_14830__$1;
(statearr_14836_14925[(2)] = null);

(statearr_14836_14925[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (60))){
var inst_14805 = (state_14830[(2)]);
var inst_14806 = fluree.db.util.async.throw_err(inst_14805);
var state_14830__$1 = state_14830;
var statearr_14837_14926 = state_14830__$1;
(statearr_14837_14926[(2)] = inst_14806);

(statearr_14837_14926[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (27))){
var inst_14730 = (state_14830[(8)]);
var inst_14741 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_14730);
var state_14830__$1 = state_14830;
if(inst_14741){
var statearr_14838_14927 = state_14830__$1;
(statearr_14838_14927[(1)] = (30));

} else {
var statearr_14839_14928 = state_14830__$1;
(statearr_14839_14928[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (1))){
var state_14830__$1 = state_14830;
var statearr_14840_14929 = state_14830__$1;
(statearr_14840_14929[(2)] = null);

(statearr_14840_14929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (24))){
var inst_14691 = (state_14830[(9)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14691)){
var statearr_14841_14930 = state_14830__$1;
(statearr_14841_14930[(1)] = (27));

} else {
var statearr_14842_14931 = state_14830__$1;
(statearr_14842_14931[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (55))){
var inst_14811 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14843_14932 = state_14830__$1;
(statearr_14843_14932[(2)] = inst_14811);

(statearr_14843_14932[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (39))){
var inst_14761 = (state_14830[(2)]);
var inst_14762 = fluree.db.util.async.throw_err(inst_14761);
var state_14830__$1 = state_14830;
var statearr_14844_14933 = state_14830__$1;
(statearr_14844_14933[(2)] = inst_14762);

(statearr_14844_14933[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (46))){
var inst_14774 = (state_14830[(10)]);
var inst_14774__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14830__$1 = (function (){var statearr_14845 = state_14830;
(statearr_14845[(10)] = inst_14774__$1);

return statearr_14845;
})();
if(cljs.core.truth_(inst_14774__$1)){
var statearr_14846_14934 = state_14830__$1;
(statearr_14846_14934[(1)] = (49));

} else {
var statearr_14847_14935 = state_14830__$1;
(statearr_14847_14935[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (4))){
var inst_14680 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14848_14936 = state_14830__$1;
(statearr_14848_14936[(2)] = inst_14680);

(statearr_14848_14936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (54))){
var inst_14730 = (state_14830[(8)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14730)){
var statearr_14849_14937 = state_14830__$1;
(statearr_14849_14937[(1)] = (57));

} else {
var statearr_14850_14938 = state_14830__$1;
(statearr_14850_14938[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (15))){
var inst_14692 = (state_14830[(11)]);
var inst_14711 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14692);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(18),inst_14711);
} else {
if((state_val_14831 === (48))){
var inst_14813 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14851_14939 = state_14830__$1;
(statearr_14851_14939[(2)] = inst_14813);

(statearr_14851_14939[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (50))){
var inst_14730 = (state_14830[(8)]);
var inst_14774 = (state_14830[(10)]);
var inst_14700 = (state_14830[(12)]);
var inst_14705 = (state_14830[(13)]);
var inst_14693 = (state_14830[(14)]);
var inst_14689 = (state_14830[(15)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14694 = (state_14830[(17)]);
var inst_14778 = (function (){var t = inst_14693;
var temp__5733__auto__ = inst_14774;
var p = inst_14691;
var idx_predicate_QMARK_ = inst_14694;
var o = inst_14730;
var tag_predicate_QMARK_ = inst_14700;
var s = inst_14690;
var o_coerce_QMARK_ = inst_14705;
var vec__14686 = inst_14689;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_14830__$1 = state_14830;
var statearr_14852_14940 = state_14830__$1;
(statearr_14852_14940[(2)] = inst_14778);

(statearr_14852_14940[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (21))){
var inst_14726 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14853_14941 = state_14830__$1;
(statearr_14853_14941[(2)] = inst_14726);

(statearr_14853_14941[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (31))){
var state_14830__$1 = state_14830;
var statearr_14854_14942 = state_14830__$1;
(statearr_14854_14942[(2)] = false);

(statearr_14854_14942[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (32))){
var inst_14751 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14855_14943 = state_14830__$1;
(statearr_14855_14943[(2)] = inst_14751);

(statearr_14855_14943[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (40))){
var inst_14694 = (state_14830[(17)]);
var inst_14765 = cljs.core.not(inst_14694);
var state_14830__$1 = state_14830;
if(inst_14765){
var statearr_14856_14944 = state_14830__$1;
(statearr_14856_14944[(1)] = (43));

} else {
var statearr_14857_14945 = state_14830__$1;
(statearr_14857_14945[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (56))){
var inst_14796 = (state_14830[(2)]);
var inst_14797 = fluree.db.util.async.throw_err(inst_14796);
var state_14830__$1 = state_14830;
var statearr_14858_14946 = state_14830__$1;
(statearr_14858_14946[(2)] = inst_14797);

(statearr_14858_14946[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (33))){
var inst_14730 = (state_14830[(8)]);
var inst_14744 = cljs.core.fn_QMARK_(inst_14730);
var inst_14745 = (!(inst_14744));
var state_14830__$1 = state_14830;
var statearr_14859_14947 = state_14830__$1;
(statearr_14859_14947[(2)] = inst_14745);

(statearr_14859_14947[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (13))){
var inst_14692 = (state_14830[(11)]);
var inst_14709 = fluree.db.query.range.tag_string_QMARK_(inst_14692);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14709)){
var statearr_14860_14948 = state_14830__$1;
(statearr_14860_14948[(1)] = (15));

} else {
var statearr_14861_14949 = state_14830__$1;
(statearr_14861_14949[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (22))){
var inst_14722 = (state_14830[(2)]);
var inst_14723 = fluree.db.util.async.throw_err(inst_14722);
var state_14830__$1 = state_14830;
var statearr_14862_14950 = state_14830__$1;
(statearr_14862_14950[(2)] = inst_14723);

(statearr_14862_14950[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (36))){
var inst_14730 = (state_14830[(8)]);
var inst_14693 = (state_14830[(14)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14757 = [inst_14691,inst_14730,inst_14690,inst_14693];
var inst_14758 = (new cljs.core.PersistentVector(null,4,(5),inst_14756,inst_14757,null));
var inst_14759 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14758,opts);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(39),inst_14759);
} else {
if((state_val_14831 === (41))){
var inst_14691 = (state_14830[(9)]);
var state_14830__$1 = state_14830;
var statearr_14863_14951 = state_14830__$1;
(statearr_14863_14951[(2)] = inst_14691);

(statearr_14863_14951[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (43))){
var inst_14730 = (state_14830[(8)]);
var state_14830__$1 = state_14830;
var statearr_14864_14952 = state_14830__$1;
(statearr_14864_14952[(2)] = inst_14730);

(statearr_14864_14952[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (61))){
var inst_14817 = (state_14830[(7)]);
var inst_14819 = fluree.db.query.range.coerce_tag_flakes(db,inst_14817);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(64),inst_14819);
} else {
if((state_val_14831 === (29))){
var inst_14754 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14754)){
var statearr_14865_14953 = state_14830__$1;
(statearr_14865_14953[(1)] = (36));

} else {
var statearr_14866_14954 = state_14830__$1;
(statearr_14866_14954[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (44))){
var state_14830__$1 = state_14830;
var statearr_14867_14955 = state_14830__$1;
(statearr_14867_14955[(2)] = false);

(statearr_14867_14955[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (6))){
var inst_14691 = (state_14830[(9)]);
var inst_14696 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14691);
var inst_14697 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14696);
var state_14830__$1 = state_14830;
var statearr_14868_14956 = state_14830__$1;
(statearr_14868_14956[(2)] = inst_14697);

(statearr_14868_14956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (28))){
var inst_14691 = (state_14830[(9)]);
var state_14830__$1 = state_14830;
var statearr_14869_14957 = state_14830__$1;
(statearr_14869_14957[(2)] = inst_14691);

(statearr_14869_14957[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (64))){
var inst_14821 = (state_14830[(2)]);
var inst_14822 = fluree.db.util.async.throw_err(inst_14821);
var state_14830__$1 = state_14830;
var statearr_14870_14958 = state_14830__$1;
(statearr_14870_14958[(2)] = inst_14822);

(statearr_14870_14958[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (51))){
var inst_14693 = (state_14830[(14)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14780 = (state_14830[(2)]);
var inst_14781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14782 = [inst_14691,inst_14690,null,inst_14693];
var inst_14783 = (new cljs.core.PersistentVector(null,4,(5),inst_14781,inst_14782,null));
var inst_14784 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14780);
var inst_14785 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14783,inst_14784);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(52),inst_14785);
} else {
if((state_val_14831 === (25))){
var inst_14700 = (state_14830[(12)]);
var inst_14817 = (state_14830[(2)]);
var state_14830__$1 = (function (){var statearr_14871 = state_14830;
(statearr_14871[(7)] = inst_14817);

return statearr_14871;
})();
if(cljs.core.truth_(inst_14700)){
var statearr_14872_14959 = state_14830__$1;
(statearr_14872_14959[(1)] = (61));

} else {
var statearr_14873_14960 = state_14830__$1;
(statearr_14873_14960[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (34))){
var inst_14694 = (state_14830[(17)]);
var state_14830__$1 = state_14830;
var statearr_14874_14961 = state_14830__$1;
(statearr_14874_14961[(2)] = inst_14694);

(statearr_14874_14961[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (17))){
var inst_14728 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14875_14962 = state_14830__$1;
(statearr_14875_14962[(2)] = inst_14728);

(statearr_14875_14962[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (3))){
var inst_14828 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14830__$1,inst_14828);
} else {
if((state_val_14831 === (12))){
var inst_14692 = (state_14830[(11)]);
var state_14830__$1 = state_14830;
var statearr_14876_14963 = state_14830__$1;
(statearr_14876_14963[(2)] = inst_14692);

(statearr_14876_14963[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (2))){
var inst_14689 = (state_14830[(15)]);
var inst_14691 = (state_14830[(9)]);
var _ = (function (){var statearr_14877 = state_14830;
(statearr_14877[(4)] = cljs.core.cons((5),(state_14830[(4)])));

return statearr_14877;
})();
var inst_14689__$1 = fparts;
var inst_14690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14689__$1,(0),null);
var inst_14691__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14689__$1,(1),null);
var inst_14692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14689__$1,(2),null);
var inst_14693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14689__$1,(3),null);
var inst_14694 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14691__$1);
var state_14830__$1 = (function (){var statearr_14878 = state_14830;
(statearr_14878[(14)] = inst_14693);

(statearr_14878[(11)] = inst_14692);

(statearr_14878[(15)] = inst_14689__$1);

(statearr_14878[(16)] = inst_14690);

(statearr_14878[(9)] = inst_14691__$1);

(statearr_14878[(17)] = inst_14694);

return statearr_14878;
})();
if(cljs.core.truth_(inst_14691__$1)){
var statearr_14879_14964 = state_14830__$1;
(statearr_14879_14964[(1)] = (6));

} else {
var statearr_14880_14965 = state_14830__$1;
(statearr_14880_14965[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (23))){
var inst_14730 = (state_14830[(8)]);
var inst_14693 = (state_14830[(14)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14733 = [inst_14690,inst_14691,inst_14730,inst_14693];
var inst_14734 = (new cljs.core.PersistentVector(null,4,(5),inst_14732,inst_14733,null));
var inst_14735 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14734,opts);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(26),inst_14735);
} else {
if((state_val_14831 === (47))){
var inst_14691 = (state_14830[(9)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14691)){
var statearr_14881_14966 = state_14830__$1;
(statearr_14881_14966[(1)] = (53));

} else {
var statearr_14882_14967 = state_14830__$1;
(statearr_14882_14967[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (35))){
var inst_14748 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14883_14968 = state_14830__$1;
(statearr_14883_14968[(2)] = inst_14748);

(statearr_14883_14968[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (19))){
var inst_14692 = (state_14830[(11)]);
var inst_14691 = (state_14830[(9)]);
var inst_14718 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14691);
var inst_14719 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14718),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14692)].join('');
var inst_14720 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14719);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(22),inst_14720);
} else {
if((state_val_14831 === (57))){
var inst_14730 = (state_14830[(8)]);
var inst_14693 = (state_14830[(14)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14801 = [inst_14730,inst_14691,inst_14690,inst_14693];
var inst_14802 = (new cljs.core.PersistentVector(null,4,(5),inst_14800,inst_14801,null));
var inst_14803 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14802,opts);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(60),inst_14803);
} else {
if((state_val_14831 === (11))){
var inst_14705 = (state_14830[(13)]);
var inst_14705__$1 = (state_14830[(2)]);
var inst_14706 = cljs.core.not(inst_14705__$1);
var state_14830__$1 = (function (){var statearr_14885 = state_14830;
(statearr_14885[(13)] = inst_14705__$1);

return statearr_14885;
})();
if(inst_14706){
var statearr_14886_14969 = state_14830__$1;
(statearr_14886_14969[(1)] = (12));

} else {
var statearr_14887_14970 = state_14830__$1;
(statearr_14887_14970[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (9))){
var inst_14692 = (state_14830[(11)]);
var inst_14702 = typeof inst_14692 === 'string';
var state_14830__$1 = state_14830;
var statearr_14888_14971 = state_14830__$1;
(statearr_14888_14971[(2)] = inst_14702);

(statearr_14888_14971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (5))){
var _ = (function (){var statearr_14889 = state_14830;
(statearr_14889[(4)] = cljs.core.rest((state_14830[(4)])));

return statearr_14889;
})();
var state_14830__$1 = state_14830;
var ex14884 = (state_14830__$1[(2)]);
var statearr_14890_14972 = state_14830__$1;
(statearr_14890_14972[(5)] = ex14884);


if((ex14884 instanceof Error)){
var statearr_14891_14973 = state_14830__$1;
(statearr_14891_14973[(1)] = (4));

(statearr_14891_14973[(5)] = null);

} else {
throw ex14884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (14))){
var inst_14690 = (state_14830[(16)]);
var inst_14730 = (state_14830[(2)]);
var state_14830__$1 = (function (){var statearr_14892 = state_14830;
(statearr_14892[(8)] = inst_14730);

return statearr_14892;
})();
if(cljs.core.truth_(inst_14690)){
var statearr_14893_14974 = state_14830__$1;
(statearr_14893_14974[(1)] = (23));

} else {
var statearr_14894_14975 = state_14830__$1;
(statearr_14894_14975[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (45))){
var inst_14769 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14895_14976 = state_14830__$1;
(statearr_14895_14976[(2)] = inst_14769);

(statearr_14895_14976[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (53))){
var inst_14730 = (state_14830[(8)]);
var inst_14693 = (state_14830[(14)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14792 = [inst_14691,inst_14690,inst_14730,inst_14693];
var inst_14793 = (new cljs.core.PersistentVector(null,4,(5),inst_14791,inst_14792,null));
var inst_14794 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14793,opts);
var state_14830__$1 = state_14830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14830__$1,(56),inst_14794);
} else {
if((state_val_14831 === (26))){
var inst_14737 = (state_14830[(2)]);
var inst_14738 = fluree.db.util.async.throw_err(inst_14737);
var state_14830__$1 = state_14830;
var statearr_14896_14977 = state_14830__$1;
(statearr_14896_14977[(2)] = inst_14738);

(statearr_14896_14977[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (16))){
var inst_14692 = (state_14830[(11)]);
var inst_14716 = typeof inst_14692 === 'string';
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14716)){
var statearr_14897_14978 = state_14830__$1;
(statearr_14897_14978[(1)] = (19));

} else {
var statearr_14898_14979 = state_14830__$1;
(statearr_14898_14979[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (38))){
var inst_14815 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
var statearr_14899_14980 = state_14830__$1;
(statearr_14899_14980[(2)] = inst_14815);

(statearr_14899_14980[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (30))){
var inst_14694 = (state_14830[(17)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14694)){
var statearr_14900_14981 = state_14830__$1;
(statearr_14900_14981[(1)] = (33));

} else {
var statearr_14901_14982 = state_14830__$1;
(statearr_14901_14982[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (10))){
var inst_14700 = (state_14830[(12)]);
var state_14830__$1 = state_14830;
var statearr_14902_14983 = state_14830__$1;
(statearr_14902_14983[(2)] = inst_14700);

(statearr_14902_14983[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (18))){
var inst_14713 = (state_14830[(2)]);
var inst_14714 = fluree.db.util.async.throw_err(inst_14713);
var state_14830__$1 = state_14830;
var statearr_14903_14984 = state_14830__$1;
(statearr_14903_14984[(2)] = inst_14714);

(statearr_14903_14984[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (52))){
var inst_14787 = (state_14830[(2)]);
var inst_14788 = fluree.db.util.async.throw_err(inst_14787);
var state_14830__$1 = state_14830;
var statearr_14904_14985 = state_14830__$1;
(statearr_14904_14985[(2)] = inst_14788);

(statearr_14904_14985[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (42))){
var inst_14772 = (state_14830[(2)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14772)){
var statearr_14905_14986 = state_14830__$1;
(statearr_14905_14986[(1)] = (46));

} else {
var statearr_14906_14987 = state_14830__$1;
(statearr_14906_14987[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (37))){
var inst_14691 = (state_14830[(9)]);
var state_14830__$1 = state_14830;
if(cljs.core.truth_(inst_14691)){
var statearr_14907_14988 = state_14830__$1;
(statearr_14907_14988[(1)] = (40));

} else {
var statearr_14908_14989 = state_14830__$1;
(statearr_14908_14989[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (63))){
var inst_14825 = (state_14830[(2)]);
var _ = (function (){var statearr_14909 = state_14830;
(statearr_14909[(4)] = cljs.core.rest((state_14830[(4)])));

return statearr_14909;
})();
var state_14830__$1 = state_14830;
var statearr_14910_14990 = state_14830__$1;
(statearr_14910_14990[(2)] = inst_14825);

(statearr_14910_14990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (8))){
var inst_14700 = (state_14830[(12)]);
var inst_14700__$1 = (state_14830[(2)]);
var state_14830__$1 = (function (){var statearr_14911 = state_14830;
(statearr_14911[(12)] = inst_14700__$1);

return statearr_14911;
})();
if(cljs.core.truth_(inst_14700__$1)){
var statearr_14912_14991 = state_14830__$1;
(statearr_14912_14991[(1)] = (9));

} else {
var statearr_14913_14992 = state_14830__$1;
(statearr_14913_14992[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14831 === (49))){
var inst_14730 = (state_14830[(8)]);
var inst_14774 = (state_14830[(10)]);
var inst_14700 = (state_14830[(12)]);
var inst_14705 = (state_14830[(13)]);
var inst_14693 = (state_14830[(14)]);
var inst_14689 = (state_14830[(15)]);
var inst_14690 = (state_14830[(16)]);
var inst_14691 = (state_14830[(9)]);
var inst_14694 = (state_14830[(17)]);
var inst_14776 = (function (){var obj_fn = inst_14774;
var t = inst_14693;
var temp__5733__auto__ = inst_14774;
var p = inst_14691;
var idx_predicate_QMARK_ = inst_14694;
var o = inst_14730;
var tag_predicate_QMARK_ = inst_14700;
var s = inst_14690;
var o_coerce_QMARK_ = inst_14705;
var vec__14686 = inst_14689;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_14830__$1 = state_14830;
var statearr_14914_14993 = state_14830__$1;
(statearr_14914_14993[(2)] = inst_14776);

(statearr_14914_14993[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_14915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14915[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_14915[(1)] = (1));

return statearr_14915;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_14830){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_14830);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e14916){var ex__2417__auto__ = e14916;
var statearr_14917_14994 = state_14830;
(statearr_14917_14994[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_14830[(4)]))){
var statearr_14918_14995 = state_14830;
(statearr_14918_14995[(1)] = cljs.core.first((state_14830[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14996 = state_14830;
state_14830 = G__14996;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_14830){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_14830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_14919 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_14919[(6)] = c__2436__auto__);

return statearr_14919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__14998 = arguments.length;
switch (G__14998) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_15033){
var state_val_15034 = (state_15033[(1)]);
if((state_val_15034 === (7))){
var inst_15020 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15021 = ["Invalid collection name: ",inst_15020].join('');
var inst_15022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15023 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15024 = cljs.core.PersistentHashMap.fromArrays(inst_15022,inst_15023);
var inst_15025 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15021,inst_15024);
var inst_15026 = (function(){throw inst_15025})();
var state_15033__$1 = state_15033;
var statearr_15035_15055 = state_15033__$1;
(statearr_15035_15055[(2)] = inst_15026);

(statearr_15035_15055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (1))){
var state_15033__$1 = state_15033;
var statearr_15036_15056 = state_15033__$1;
(statearr_15036_15056[(2)] = null);

(statearr_15036_15056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (4))){
var inst_14999 = (state_15033[(2)]);
var state_15033__$1 = state_15033;
var statearr_15037_15057 = state_15033__$1;
(statearr_15037_15057[(2)] = inst_14999);

(statearr_15037_15057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (6))){
var inst_15005 = (state_15033[(7)]);
var inst_15007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15008 = fluree.db.flake.max_subject_id(inst_15005);
var inst_15009 = [inst_15008];
var inst_15010 = (new cljs.core.PersistentVector(null,1,(5),inst_15007,inst_15009,null));
var inst_15011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15012 = fluree.db.flake.min_subject_id(inst_15005);
var inst_15013 = [inst_15012];
var inst_15014 = (new cljs.core.PersistentVector(null,1,(5),inst_15011,inst_15013,null));
var inst_15015 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15010,cljs.core._LT__EQ_,inst_15014,opts);
var state_15033__$1 = state_15033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15033__$1,(9),inst_15015);
} else {
if((state_val_15034 === (3))){
var inst_15031 = (state_15033[(2)]);
var state_15033__$1 = state_15033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15033__$1,inst_15031);
} else {
if((state_val_15034 === (2))){
var inst_15005 = (state_15033[(7)]);
var _ = (function (){var statearr_15039 = state_15033;
(statearr_15039[(4)] = cljs.core.cons((5),(state_15033[(4)])));

return statearr_15039;
})();
var inst_15005__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15033__$1 = (function (){var statearr_15040 = state_15033;
(statearr_15040[(7)] = inst_15005__$1);

return statearr_15040;
})();
if(cljs.core.truth_(inst_15005__$1)){
var statearr_15041_15058 = state_15033__$1;
(statearr_15041_15058[(1)] = (6));

} else {
var statearr_15042_15059 = state_15033__$1;
(statearr_15042_15059[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (9))){
var inst_15017 = (state_15033[(2)]);
var inst_15018 = fluree.db.util.async.throw_err(inst_15017);
var state_15033__$1 = state_15033;
var statearr_15043_15060 = state_15033__$1;
(statearr_15043_15060[(2)] = inst_15018);

(statearr_15043_15060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (5))){
var _ = (function (){var statearr_15044 = state_15033;
(statearr_15044[(4)] = cljs.core.rest((state_15033[(4)])));

return statearr_15044;
})();
var state_15033__$1 = state_15033;
var ex15038 = (state_15033__$1[(2)]);
var statearr_15045_15061 = state_15033__$1;
(statearr_15045_15061[(5)] = ex15038);


var statearr_15046_15062 = state_15033__$1;
(statearr_15046_15062[(1)] = (4));

(statearr_15046_15062[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15034 === (8))){
var inst_15028 = (state_15033[(2)]);
var _ = (function (){var statearr_15047 = state_15033;
(statearr_15047[(4)] = cljs.core.rest((state_15033[(4)])));

return statearr_15047;
})();
var state_15033__$1 = state_15033;
var statearr_15048_15063 = state_15033__$1;
(statearr_15048_15063[(2)] = inst_15028);

(statearr_15048_15063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2414__auto__ = null;
var fluree$db$query$range$state_machine__2414__auto____0 = (function (){
var statearr_15049 = [null,null,null,null,null,null,null,null];
(statearr_15049[(0)] = fluree$db$query$range$state_machine__2414__auto__);

(statearr_15049[(1)] = (1));

return statearr_15049;
});
var fluree$db$query$range$state_machine__2414__auto____1 = (function (state_15033){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_15033);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e15050){var ex__2417__auto__ = e15050;
var statearr_15051_15064 = state_15033;
(statearr_15051_15064[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_15033[(4)]))){
var statearr_15052_15065 = state_15033;
(statearr_15052_15065[(1)] = cljs.core.first((state_15033[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15066 = state_15033;
state_15033 = G__15066;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2414__auto__ = function(state_15033){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2414__auto____1.call(this,state_15033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2414__auto____0;
fluree$db$query$range$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2414__auto____1;
return fluree$db$query$range$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_15053 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_15053[(6)] = c__2436__auto__);

return statearr_15053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15070 = flakes;
var vec__15071 = G__15070;
var seq__15072 = cljs.core.seq(vec__15071);
var first__15073 = cljs.core.first(seq__15072);
var seq__15072__$1 = cljs.core.next(seq__15072);
var flake_SINGLEQUOTE_ = first__15073;
var r = seq__15072__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15070__$1 = G__15070;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15080 = G__15070__$1;
var seq__15081 = cljs.core.seq(vec__15080);
var first__15082 = cljs.core.first(seq__15081);
var seq__15081__$1 = cljs.core.next(seq__15081);
var flake_SINGLEQUOTE___$1 = first__15082;
var r__$1 = seq__15081__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15084){var e = e15084;
return null;
}})();
var map__15083 = cmd_map;
var map__15083__$1 = (((((!((map__15083 == null))))?(((((map__15083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15083.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15083):map__15083);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15083__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15086 = r__$1;
var G__15087 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15070__$1 = G__15086;
result_STAR___$1 = G__15087;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15096 = blocks;
var vec__15097 = G__15096;
var seq__15098 = cljs.core.seq(vec__15097);
var first__15099 = cljs.core.first(seq__15098);
var seq__15098__$1 = cljs.core.next(seq__15098);
var block_SINGLEQUOTE_ = first__15099;
var r = seq__15098__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15096__$1 = G__15096;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15105 = G__15096__$1;
var seq__15106 = cljs.core.seq(vec__15105);
var first__15107 = cljs.core.first(seq__15106);
var seq__15106__$1 = cljs.core.next(seq__15106);
var block_SINGLEQUOTE___$1 = first__15107;
var r__$1 = seq__15106__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15108 = block_SINGLEQUOTE___$1;
var map__15108__$1 = (((((!((map__15108 == null))))?(((((map__15108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15108.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15108):map__15108);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15108__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15088_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15088_SHARP_.p,(2))){
return p1__15088_SHARP_.o;
} else {
return null;
}
});})(G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15089_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15089_SHARP_.p,(1))){
return p1__15089_SHARP_.o;
} else {
return null;
}
});})(G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15090_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15090_SHARP_.p,(5))){
return p1__15090_SHARP_.o;
} else {
return null;
}
});})(G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,instant,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15091_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15091_SHARP_.p,(7))){
return p1__15091_SHARP_.o;
} else {
return null;
}
});})(G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,instant,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15092_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15092_SHARP_.p,(106));
});})(G__15096__$1,result_STAR___$1,map__15108,map__15108__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15105,seq__15106,first__15107,seq__15106__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15096,vec__15097,seq__15098,first__15099,seq__15098__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15110 = r__$1;
var G__15111 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15096__$1 = G__15110;
result_STAR___$1 = G__15111;
continue;
}
break;
}
});
