// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_11162){
var state_val_11163 = (state_11162[(1)]);
if((state_val_11163 === (7))){
var inst_11157 = (state_11162[(2)]);
var _ = (function (){var statearr_11164 = state_11162;
(statearr_11164[(4)] = cljs.core.rest((state_11162[(4)])));

return statearr_11164;
})();
var state_11162__$1 = state_11162;
var statearr_11165_11187 = state_11162__$1;
(statearr_11165_11187[(2)] = inst_11157);

(statearr_11165_11187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (1))){
var state_11162__$1 = state_11162;
var statearr_11166_11188 = state_11162__$1;
(statearr_11166_11188[(2)] = null);

(statearr_11166_11188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (4))){
var inst_11119 = (state_11162[(2)]);
var state_11162__$1 = state_11162;
var statearr_11167_11189 = state_11162__$1;
(statearr_11167_11189[(2)] = inst_11119);

(statearr_11167_11189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (6))){
var inst_11137 = (state_11162[(7)]);
var inst_11144 = (state_11162[(8)]);
var inst_11143 = cljs.core.seq(inst_11137);
var inst_11144__$1 = cljs.core.first(inst_11143);
var inst_11145 = cljs.core.next(inst_11143);
var inst_11146 = cljs.core.not(inst_11144__$1);
var state_11162__$1 = (function (){var statearr_11168 = state_11162;
(statearr_11168[(8)] = inst_11144__$1);

(statearr_11168[(9)] = inst_11145);

return statearr_11168;
})();
if(inst_11146){
var statearr_11169_11190 = state_11162__$1;
(statearr_11169_11190[(1)] = (8));

} else {
var statearr_11170_11191 = state_11162__$1;
(statearr_11170_11191[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (3))){
var inst_11160 = (state_11162[(2)]);
var state_11162__$1 = state_11162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11162__$1,inst_11160);
} else {
if((state_val_11163 === (2))){
var _ = (function (){var statearr_11171 = state_11162;
(statearr_11171[(4)] = cljs.core.cons((5),(state_11162[(4)])));

return statearr_11171;
})();
var inst_11132 = chs;
var inst_11133 = cljs.core.seq(inst_11132);
var inst_11134 = cljs.core.first(inst_11133);
var inst_11135 = cljs.core.next(inst_11133);
var inst_11136 = coll;
var inst_11137 = inst_11132;
var inst_11138 = inst_11136;
var state_11162__$1 = (function (){var statearr_11172 = state_11162;
(statearr_11172[(7)] = inst_11137);

(statearr_11172[(10)] = inst_11134);

(statearr_11172[(11)] = inst_11135);

(statearr_11172[(12)] = inst_11138);

return statearr_11172;
})();
var statearr_11173_11192 = state_11162__$1;
(statearr_11173_11192[(2)] = null);

(statearr_11173_11192[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (11))){
var inst_11138 = (state_11162[(12)]);
var inst_11145 = (state_11162[(9)]);
var inst_11150 = (state_11162[(2)]);
var inst_11151 = fluree.db.util.async.throw_err(inst_11150);
var inst_11152 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11138,inst_11151);
var inst_11137 = inst_11145;
var inst_11138__$1 = inst_11152;
var state_11162__$1 = (function (){var statearr_11175 = state_11162;
(statearr_11175[(7)] = inst_11137);

(statearr_11175[(12)] = inst_11138__$1);

return statearr_11175;
})();
var statearr_11176_11193 = state_11162__$1;
(statearr_11176_11193[(2)] = null);

(statearr_11176_11193[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (9))){
var inst_11144 = (state_11162[(8)]);
var state_11162__$1 = state_11162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11162__$1,(11),inst_11144);
} else {
if((state_val_11163 === (5))){
var _ = (function (){var statearr_11177 = state_11162;
(statearr_11177[(4)] = cljs.core.rest((state_11162[(4)])));

return statearr_11177;
})();
var state_11162__$1 = state_11162;
var ex11174 = (state_11162__$1[(2)]);
var statearr_11178_11194 = state_11162__$1;
(statearr_11178_11194[(5)] = ex11174);


var statearr_11179_11195 = state_11162__$1;
(statearr_11179_11195[(1)] = (4));

(statearr_11179_11195[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (10))){
var inst_11155 = (state_11162[(2)]);
var state_11162__$1 = state_11162;
var statearr_11180_11196 = state_11162__$1;
(statearr_11180_11196[(2)] = inst_11155);

(statearr_11180_11196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11163 === (8))){
var inst_11138 = (state_11162[(12)]);
var state_11162__$1 = state_11162;
var statearr_11181_11197 = state_11162__$1;
(statearr_11181_11197[(2)] = inst_11138);

(statearr_11181_11197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_11182 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11182[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__);

(statearr_11182[(1)] = (1));

return statearr_11182;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____1 = (function (state_11162){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_11162);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e11183){var ex__2417__auto__ = e11183;
var statearr_11184_11198 = state_11162;
(statearr_11184_11198[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_11162[(4)]))){
var statearr_11185_11199 = state_11162;
(statearr_11185_11199[(1)] = cljs.core.first((state_11162[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11200 = state_11162;
state_11162 = G__11200;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__ = function(state_11162){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____1.call(this,state_11162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_11186 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_11186[(6)] = c__2436__auto__);

return statearr_11186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_11226){
var state_val_11227 = (state_11226[(1)]);
if((state_val_11227 === (7))){
var inst_11221 = (state_11226[(2)]);
var _ = (function (){var statearr_11228 = state_11226;
(statearr_11228[(4)] = cljs.core.rest((state_11226[(4)])));

return statearr_11228;
})();
var state_11226__$1 = state_11226;
var statearr_11229_11251 = state_11226__$1;
(statearr_11229_11251[(2)] = inst_11221);

(statearr_11229_11251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (1))){
var state_11226__$1 = state_11226;
var statearr_11230_11252 = state_11226__$1;
(statearr_11230_11252[(2)] = null);

(statearr_11230_11252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (4))){
var inst_11201 = (state_11226[(2)]);
var state_11226__$1 = state_11226;
var statearr_11231_11253 = state_11226__$1;
(statearr_11231_11253[(2)] = inst_11201);

(statearr_11231_11253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (6))){
var state_11226__$1 = state_11226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11226__$1,(8),chan);
} else {
if((state_val_11227 === (3))){
var inst_11224 = (state_11226[(2)]);
var state_11226__$1 = state_11226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11226__$1,inst_11224);
} else {
if((state_val_11227 === (2))){
var _ = (function (){var statearr_11232 = state_11226;
(statearr_11232[(4)] = cljs.core.cons((5),(state_11226[(4)])));

return statearr_11232;
})();
var inst_11207 = coll;
var inst_11208 = inst_11207;
var state_11226__$1 = (function (){var statearr_11233 = state_11226;
(statearr_11233[(7)] = inst_11208);

return statearr_11233;
})();
var statearr_11234_11254 = state_11226__$1;
(statearr_11234_11254[(2)] = null);

(statearr_11234_11254[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (11))){
var inst_11219 = (state_11226[(2)]);
var state_11226__$1 = state_11226;
var statearr_11236_11255 = state_11226__$1;
(statearr_11236_11255[(2)] = inst_11219);

(statearr_11236_11255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (9))){
var inst_11208 = (state_11226[(7)]);
var state_11226__$1 = state_11226;
var statearr_11237_11256 = state_11226__$1;
(statearr_11237_11256[(2)] = inst_11208);

(statearr_11237_11256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (5))){
var _ = (function (){var statearr_11238 = state_11226;
(statearr_11238[(4)] = cljs.core.rest((state_11226[(4)])));

return statearr_11238;
})();
var state_11226__$1 = state_11226;
var ex11235 = (state_11226__$1[(2)]);
var statearr_11239_11257 = state_11226__$1;
(statearr_11239_11257[(5)] = ex11235);


var statearr_11240_11258 = state_11226__$1;
(statearr_11240_11258[(1)] = (4));

(statearr_11240_11258[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (10))){
var inst_11208 = (state_11226[(7)]);
var inst_11212 = (state_11226[(8)]);
var inst_11216 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11208,inst_11212);
var inst_11208__$1 = inst_11216;
var state_11226__$1 = (function (){var statearr_11241 = state_11226;
(statearr_11241[(7)] = inst_11208__$1);

return statearr_11241;
})();
var statearr_11242_11259 = state_11226__$1;
(statearr_11242_11259[(2)] = null);

(statearr_11242_11259[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11227 === (8))){
var inst_11212 = (state_11226[(8)]);
var inst_11211 = (state_11226[(2)]);
var inst_11212__$1 = fluree.db.util.async.throw_err(inst_11211);
var inst_11213 = (inst_11212__$1 == null);
var state_11226__$1 = (function (){var statearr_11243 = state_11226;
(statearr_11243[(8)] = inst_11212__$1);

return statearr_11243;
})();
if(cljs.core.truth_(inst_11213)){
var statearr_11244_11260 = state_11226__$1;
(statearr_11244_11260[(1)] = (9));

} else {
var statearr_11245_11261 = state_11226__$1;
(statearr_11245_11261[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____0 = (function (){
var statearr_11246 = [null,null,null,null,null,null,null,null,null];
(statearr_11246[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__);

(statearr_11246[(1)] = (1));

return statearr_11246;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____1 = (function (state_11226){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_11226);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e11247){var ex__2417__auto__ = e11247;
var statearr_11248_11262 = state_11226;
(statearr_11248_11262[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_11226[(4)]))){
var statearr_11249_11263 = state_11226;
(statearr_11249_11263[(1)] = cljs.core.first((state_11226[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11264 = state_11226;
state_11226 = G__11264;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__ = function(state_11226){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____1.call(this,state_11226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2414__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_11250 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_11250[(6)] = c__2436__auto__);

return statearr_11250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
