// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.object');
goog.require('fluree.db.connection_js');
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__64058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64058__$1 = (((((!((map__64058 == null))))?(((((map__64058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64058.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64058):map__64058);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64058__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64058__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = goog.object.get(obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__64060 = cljs.core.get_global_hierarchy;
return (fexpr__64060.cljs$core$IFn$_invoke$arity$0 ? fexpr__64060.cljs$core$IFn$_invoke$arity$0() : fexpr__64060.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__64061__delegate = function (conn_id,event,_){
return event;
};
var G__64061 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__64062__i = 0, G__64062__a = new Array(arguments.length -  2);
while (G__64062__i < G__64062__a.length) {G__64062__a[G__64062__i] = arguments[G__64062__i + 2]; ++G__64062__i;}
  _ = new cljs.core.IndexedSeq(G__64062__a,0,null);
} 
return G__64061__delegate.call(this,conn_id,event,_);};
G__64061.cljs$lang$maxFixedArity = 2;
G__64061.cljs$lang$applyTo = (function (arglist__64063){
var conn_id = cljs.core.first(arglist__64063);
arglist__64063 = cljs.core.next(arglist__64063);
var event = cljs.core.first(arglist__64063);
var _ = cljs.core.rest(arglist__64063);
return G__64061__delegate(conn_id,event,_);
});
G__64061.cljs$core$IFn$_invoke$arity$variadic = G__64061__delegate;
return G__64061;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4126__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64081){
var state_val_64082 = (state_64081[(1)]);
if((state_val_64082 === (1))){
var inst_64064 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_64065 = flureeworker.conn_id__GT_db(conn_id,inst_64064);
var inst_64066 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_64067 = fluree.db.api.query.query(inst_64065,inst_64066);
var state_64081__$1 = state_64081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64081__$1,(2),inst_64067);
} else {
if((state_val_64082 === (2))){
var inst_64069 = (state_64081[(7)]);
var inst_64069__$1 = (state_64081[(2)]);
var inst_64070 = fluree.db.util.core.exception_QMARK_(inst_64069__$1);
var state_64081__$1 = (function (){var statearr_64083 = state_64081;
(statearr_64083[(7)] = inst_64069__$1);

return statearr_64083;
})();
if(inst_64070){
var statearr_64084_64097 = state_64081__$1;
(statearr_64084_64097[(1)] = (3));

} else {
var statearr_64085_64098 = state_64081__$1;
(statearr_64085_64098[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64082 === (3))){
var inst_64069 = (state_64081[(7)]);
var inst_64072 = flureeworker.error_return_map(inst_64069);
var state_64081__$1 = state_64081;
var statearr_64086_64099 = state_64081__$1;
(statearr_64086_64099[(2)] = inst_64072);

(statearr_64086_64099[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64082 === (4))){
var inst_64069 = (state_64081[(7)]);
var inst_64074 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64075 = [inst_64069,"loaded"];
var inst_64076 = cljs.core.PersistentHashMap.fromArrays(inst_64074,inst_64075);
var state_64081__$1 = state_64081;
var statearr_64087_64100 = state_64081__$1;
(statearr_64087_64100[(2)] = inst_64076);

(statearr_64087_64100[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64082 === (5))){
var inst_64078 = (state_64081[(2)]);
var inst_64079 = (function (){var G__64088 = conn_id;
var G__64089 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__64090 = id;
var G__64091 = inst_64078;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64088,G__64089,G__64090,G__64091) : flureeworker.worker_action.call(null,G__64088,G__64089,G__64090,G__64091));
})();
var state_64081__$1 = state_64081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64081__$1,inst_64079);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2414__auto__ = null;
var flureeworker$process_query_$_state_machine__2414__auto____0 = (function (){
var statearr_64092 = [null,null,null,null,null,null,null,null];
(statearr_64092[(0)] = flureeworker$process_query_$_state_machine__2414__auto__);

(statearr_64092[(1)] = (1));

return statearr_64092;
});
var flureeworker$process_query_$_state_machine__2414__auto____1 = (function (state_64081){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64081);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64093){var ex__2417__auto__ = e64093;
var statearr_64094_64101 = state_64081;
(statearr_64094_64101[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64081[(4)]))){
var statearr_64095_64102 = state_64081;
(statearr_64095_64102[(1)] = cljs.core.first((state_64081[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64103 = state_64081;
state_64081 = G__64103;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2414__auto__ = function(state_64081){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2414__auto____1.call(this,state_64081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2414__auto____0;
flureeworker$process_query_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2414__auto____1;
return flureeworker$process_query_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64096 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64096[(6)] = c__2436__auto__);

return statearr_64096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__64104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64104__$1 = (((((!((map__64104 == null))))?(((((map__64104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64104):map__64104);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64104__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64104__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__64106 = cljs.core.seq(query_ids);
var chunk__64107 = null;
var count__64108 = (0);
var i__64109 = (0);
while(true){
if((i__64109 < count__64108)){
var id = chunk__64107.cljs$core$IIndexed$_nth$arity$2(null,i__64109);
flureeworker.process_query(conn_id,id,opts);


var G__64110 = seq__64106;
var G__64111 = chunk__64107;
var G__64112 = count__64108;
var G__64113 = (i__64109 + (1));
seq__64106 = G__64110;
chunk__64107 = G__64111;
count__64108 = G__64112;
i__64109 = G__64113;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__64106);
if(temp__5735__auto__){
var seq__64106__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64106__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__64106__$1);
var G__64114 = cljs.core.chunk_rest(seq__64106__$1);
var G__64115 = c__4556__auto__;
var G__64116 = cljs.core.count(c__4556__auto__);
var G__64117 = (0);
seq__64106 = G__64114;
chunk__64107 = G__64115;
count__64108 = G__64116;
i__64109 = G__64117;
continue;
} else {
var id = cljs.core.first(seq__64106__$1);
flureeworker.process_query(conn_id,id,opts);


var G__64118 = cljs.core.next(seq__64106__$1);
var G__64119 = null;
var G__64120 = (0);
var G__64121 = (0);
seq__64106 = G__64118;
chunk__64107 = G__64119;
count__64108 = G__64120;
i__64109 = G__64121;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__64122 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64122,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64122,(1),null);
var cb = (function (header,data){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64130){
var state_val_64131 = (state_64130[(1)]);
if((state_val_64131 === (1))){
var inst_64125 = cljs.core.async.timeout((100));
var state_64130__$1 = state_64130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64130__$1,(2),inst_64125);
} else {
if((state_val_64131 === (2))){
var inst_64127 = (state_64130[(2)]);
var inst_64128 = flureeworker.process_all_queries(conn_id);
var state_64130__$1 = (function (){var statearr_64132 = state_64130;
(statearr_64132[(7)] = inst_64127);

return statearr_64132;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64130__$1,inst_64128);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2414__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2414__auto____0 = (function (){
var statearr_64133 = [null,null,null,null,null,null,null,null];
(statearr_64133[(0)] = flureeworker$ledger_listener_$_state_machine__2414__auto__);

(statearr_64133[(1)] = (1));

return statearr_64133;
});
var flureeworker$ledger_listener_$_state_machine__2414__auto____1 = (function (state_64130){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64130);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64134){var ex__2417__auto__ = e64134;
var statearr_64135_64138 = state_64130;
(statearr_64135_64138[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64130[(4)]))){
var statearr_64136_64139 = state_64130;
(statearr_64136_64139[(1)] = cljs.core.first((state_64130[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64140 = state_64130;
state_64130 = G__64140;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2414__auto__ = function(state_64130){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2414__auto____1.call(this,state_64130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2414__auto____0;
flureeworker$ledger_listener_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2414__auto____1;
return flureeworker$ledger_listener_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64137 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64137[(6)] = c__2436__auto__);

return statearr_64137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__64141 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64141,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64141,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__64144 = config;
var map__64144__$1 = (((((!((map__64144 == null))))?(((((map__64144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64144.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64144):map__64144);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64144__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4126__auto__ = queries;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64146 = conn_data;
var map__64146__$1 = (((((!((map__64146 == null))))?(((((map__64146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64146.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64146):map__64146);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64146__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64146__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64146__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__64147 = config;
var map__64147__$1 = (((((!((map__64147 == null))))?(((((map__64147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64147):map__64147);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64147__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64147__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64147__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64147__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64155){
var state_val_64156 = (state_64155[(1)]);
if((state_val_64156 === (1))){
var inst_64150 = cljs.core.async.timeout((100));
var state_64155__$1 = state_64155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64155__$1,(2),inst_64150);
} else {
if((state_val_64156 === (2))){
var inst_64152 = (state_64155[(2)]);
var inst_64153 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_64155__$1 = (function (){var statearr_64157 = state_64155;
(statearr_64157[(7)] = inst_64152);

return statearr_64157;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64155__$1,inst_64153);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2414__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2414__auto____0 = (function (){
var statearr_64158 = [null,null,null,null,null,null,null,null];
(statearr_64158[(0)] = flureeworker$connect_STAR__$_state_machine__2414__auto__);

(statearr_64158[(1)] = (1));

return statearr_64158;
});
var flureeworker$connect_STAR__$_state_machine__2414__auto____1 = (function (state_64155){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64155);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64159){var ex__2417__auto__ = e64159;
var statearr_64160_64171 = state_64155;
(statearr_64160_64171[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64155[(4)]))){
var statearr_64161_64172 = state_64155;
(statearr_64161_64172[(1)] = cljs.core.first((state_64155[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64173 = state_64155;
state_64155 = G__64173;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2414__auto__ = function(state_64155){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2414__auto____1.call(this,state_64155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2414__auto____0;
flureeworker$connect_STAR__$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2414__auto____1;
return flureeworker$connect_STAR__$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64162 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64162[(6)] = c__2436__auto__);

return statearr_64162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__64163_64174 = conn_id;
var G__64164_64175 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64165_64176 = ref;
var G__64166_64177 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64163_64174,G__64164_64175,G__64165_64176,G__64166_64177) : flureeworker.worker_action.call(null,G__64163_64174,G__64164_64175,G__64165_64176,G__64166_64177));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__64167 = conn_id;
var G__64168 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64169 = ref;
var G__64170 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64167,G__64168,G__64169,G__64170) : flureeworker.worker_action.call(null,G__64167,G__64168,G__64169,G__64170));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__64179 = arguments.length;
switch (G__64179) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64180 = conn_data;
var map__64180__$1 = (((((!((map__64180 == null))))?(((((map__64180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64180):map__64180);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64180__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64180__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64180__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64180__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__64188 = conn_id;
var G__64189 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64190 = ref;
var G__64191 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64188,G__64189,G__64190,G__64191) : flureeworker.worker_action.call(null,G__64188,G__64189,G__64190,G__64191));
}catch (e64183){var e = e64183;
var msg = (function (){var or__4126__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4126__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64184 = conn_id;
var G__64185 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64186 = ref;
var G__64187 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64184,G__64185,G__64186,G__64187) : flureeworker.worker_action.call(null,G__64184,G__64185,G__64186,G__64187));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e64192){var e = e64192;
var msg = (function (){var or__4126__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4126__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64193 = conn_id;
var G__64194 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64195 = ref;
var G__64196 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64193,G__64194,G__64195,G__64196) : flureeworker.worker_action.call(null,G__64193,G__64194,G__64195,G__64196));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__64197 = config_STAR_;
var map__64197__$1 = (((((!((map__64197 == null))))?(((((map__64197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64197):map__64197);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64197__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64197__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64197__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64197__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2436__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64204){
var state_val_64205 = (state_64204[(1)]);
if((state_val_64205 === (1))){
var inst_64199 = cljs.core.async.timeout((100));
var state_64204__$1 = state_64204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64204__$1,(2),inst_64199);
} else {
if((state_val_64205 === (2))){
var inst_64201 = (state_64204[(2)]);
var inst_64202 = flureeworker.connect_STAR_(id,ref);
var state_64204__$1 = (function (){var statearr_64206 = state_64204;
(statearr_64206[(7)] = inst_64201);

return statearr_64206;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64204__$1,inst_64202);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2414__auto__ = null;
var flureeworker$connect_p_$_state_machine__2414__auto____0 = (function (){
var statearr_64207 = [null,null,null,null,null,null,null,null];
(statearr_64207[(0)] = flureeworker$connect_p_$_state_machine__2414__auto__);

(statearr_64207[(1)] = (1));

return statearr_64207;
});
var flureeworker$connect_p_$_state_machine__2414__auto____1 = (function (state_64204){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64204);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64208){var ex__2417__auto__ = e64208;
var statearr_64209_64220 = state_64204;
(statearr_64209_64220[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64204[(4)]))){
var statearr_64210_64221 = state_64204;
(statearr_64210_64221[(1)] = cljs.core.first((state_64204[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64222 = state_64204;
state_64204 = G__64222;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2414__auto__ = function(state_64204){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2414__auto____1.call(this,state_64204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2414__auto____0;
flureeworker$connect_p_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2414__auto____1;
return flureeworker$connect_p_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64211 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64211[(6)] = c__2436__auto__);

return statearr_64211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));

return c__2436__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__64212 = id;
var G__64213 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64214 = ref;
var G__64215 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64212,G__64213,G__64214,G__64215) : flureeworker.worker_action.call(null,G__64212,G__64213,G__64214,G__64215));
})).catch((function (error){
var G__64216 = id;
var G__64217 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64218 = ref;
var G__64219 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64216,G__64217,G__64218,G__64219) : flureeworker.worker_action.call(null,G__64216,G__64217,G__64218,G__64219));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64291 = arguments.length;
var i__4737__auto___64292 = (0);
while(true){
if((i__4737__auto___64292 < len__4736__auto___64291)){
args__4742__auto__.push((arguments[i__4737__auto___64292]));

var G__64293 = (i__4737__auto___64292 + (1));
i__4737__auto___64292 = G__64293;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((4) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4743__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__64228){
var vec__64229 = p__64228;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64229,(0),null);
var map__64232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64232__$1 = (((((!((map__64232 == null))))?(((((map__64232.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64232.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64232):map__64232);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64232__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64232__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64232__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64234 = conn_id;
var G__64235 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64236 = ref;
var G__64237 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64234,G__64235,G__64236,G__64237) : flureeworker.worker_action.call(null,G__64234,G__64235,G__64236,G__64237));
})());
var auth = null;
var c__2436__auto___64294 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64258){
var state_val_64259 = (state_64258[(1)]);
if((state_val_64259 === (1))){
var state_64258__$1 = state_64258;
var statearr_64260_64295 = state_64258__$1;
(statearr_64260_64295[(2)] = null);

(statearr_64260_64295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64259 === (2))){
var ___$1 = (function (){var statearr_64261 = state_64258;
(statearr_64261[(4)] = cljs.core.cons((5),(state_64258[(4)])));

return statearr_64261;
})();
var inst_64249 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_64250 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64262 = conn_id;
var G__64263 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64264 = ref;
var G__64265 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64262,G__64263,G__64264,G__64265) : flureeworker.worker_action.call(null,G__64262,G__64263,G__64264,G__64265));
});
})();
var inst_64251 = inst_64249.then(inst_64250);
var inst_64252 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64266){var ___$2 = e64266;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64267 = conn_id;
var G__64268 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64269 = ref;
var G__64270 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64267,G__64268,G__64269,G__64270) : flureeworker.worker_action.call(null,G__64267,G__64268,G__64269,G__64270));
} else {
var G__64271 = conn_id;
var G__64272 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64273 = ref;
var G__64274 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64271,G__64272,G__64273,G__64274) : flureeworker.worker_action.call(null,G__64271,G__64272,G__64273,G__64274));

}
});
})();
var inst_64253 = inst_64251.catch(inst_64252);
var ___$2 = (function (){var statearr_64275 = state_64258;
(statearr_64275[(4)] = cljs.core.rest((state_64258[(4)])));

return statearr_64275;
})();
var state_64258__$1 = state_64258;
var statearr_64276_64296 = state_64258__$1;
(statearr_64276_64296[(2)] = inst_64253);

(statearr_64276_64296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64259 === (3))){
var inst_64256 = (state_64258[(2)]);
var state_64258__$1 = state_64258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64258__$1,inst_64256);
} else {
if((state_val_64259 === (4))){
var inst_64238 = (state_64258[(2)]);
var inst_64239 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64240 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64238);
var inst_64241 = [(400),inst_64240];
var inst_64242 = cljs.core.PersistentHashMap.fromArrays(inst_64239,inst_64241);
var inst_64243 = (function (){var G__64278 = conn_id;
var G__64279 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64280 = ref;
var G__64281 = inst_64242;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64278,G__64279,G__64280,G__64281) : flureeworker.worker_action.call(null,G__64278,G__64279,G__64280,G__64281));
})();
var state_64258__$1 = state_64258;
var statearr_64282_64297 = state_64258__$1;
(statearr_64282_64297[(2)] = inst_64243);

(statearr_64282_64297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64259 === (5))){
var ___$1 = (function (){var statearr_64283 = state_64258;
(statearr_64283[(4)] = cljs.core.rest((state_64258[(4)])));

return statearr_64283;
})();
var state_64258__$1 = state_64258;
var ex64277 = (state_64258__$1[(2)]);
var statearr_64284_64298 = state_64258__$1;
(statearr_64284_64298[(5)] = ex64277);


var statearr_64285_64299 = state_64258__$1;
(statearr_64285_64299[(1)] = (4));

(statearr_64285_64299[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2414__auto__ = null;
var flureeworker$state_machine__2414__auto____0 = (function (){
var statearr_64286 = [null,null,null,null,null,null,null];
(statearr_64286[(0)] = flureeworker$state_machine__2414__auto__);

(statearr_64286[(1)] = (1));

return statearr_64286;
});
var flureeworker$state_machine__2414__auto____1 = (function (state_64258){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64258);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64287){var ex__2417__auto__ = e64287;
var statearr_64288_64300 = state_64258;
(statearr_64288_64300[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64258[(4)]))){
var statearr_64289_64301 = state_64258;
(statearr_64289_64301[(1)] = cljs.core.first((state_64258[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64302 = state_64258;
state_64258 = G__64302;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$state_machine__2414__auto__ = function(state_64258){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$state_machine__2414__auto____1.call(this,state_64258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2414__auto____0;
flureeworker$state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2414__auto____1;
return flureeworker$state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64290 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64290[(6)] = c__2436__auto___64294);

return statearr_64290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq64223){
var G__64224 = cljs.core.first(seq64223);
var seq64223__$1 = cljs.core.next(seq64223);
var G__64225 = cljs.core.first(seq64223__$1);
var seq64223__$2 = cljs.core.next(seq64223__$1);
var G__64226 = cljs.core.first(seq64223__$2);
var seq64223__$3 = cljs.core.next(seq64223__$2);
var G__64227 = cljs.core.first(seq64223__$3);
var seq64223__$4 = cljs.core.next(seq64223__$3);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64224,G__64225,G__64226,G__64227,seq64223__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__64303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64303__$1 = (((((!((map__64303 == null))))?(((((map__64303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64303):map__64303);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64303__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64303__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64306 = conn_id;
var G__64307 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64308 = ref;
var G__64309 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64306,G__64307,G__64308,G__64309) : flureeworker.worker_action.call(null,G__64306,G__64307,G__64308,G__64309));
})());
var map__64304 = map_data;
var map__64304__$1 = (((((!((map__64304 == null))))?(((((map__64304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64304.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64304):map__64304);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64304__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64304__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64304__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2436__auto___64364 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2437__auto__ = (function (){var switch__2413__auto__ = (function (state_64331){
var state_val_64332 = (state_64331[(1)]);
if((state_val_64332 === (1))){
var state_64331__$1 = state_64331;
var statearr_64333_64365 = state_64331__$1;
(statearr_64333_64365[(2)] = null);

(statearr_64333_64365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64332 === (2))){
var ___$1 = (function (){var statearr_64334 = state_64331;
(statearr_64334[(4)] = cljs.core.cons((5),(state_64331[(4)])));

return statearr_64334;
})();
var inst_64322 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_64323 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64335 = conn_id;
var G__64336 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64337 = ref;
var G__64338 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64335,G__64336,G__64337,G__64338) : flureeworker.worker_action.call(null,G__64335,G__64336,G__64337,G__64338));
});
})();
var inst_64324 = inst_64322.then(inst_64323);
var inst_64325 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64339){var ___$2 = e64339;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64340 = conn_id;
var G__64341 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64342 = ref;
var G__64343 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64340,G__64341,G__64342,G__64343) : flureeworker.worker_action.call(null,G__64340,G__64341,G__64342,G__64343));
} else {
var G__64344 = conn_id;
var G__64345 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64346 = ref;
var G__64347 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64344,G__64345,G__64346,G__64347) : flureeworker.worker_action.call(null,G__64344,G__64345,G__64346,G__64347));

}
});
})();
var inst_64326 = inst_64324.catch(inst_64325);
var ___$2 = (function (){var statearr_64348 = state_64331;
(statearr_64348[(4)] = cljs.core.rest((state_64331[(4)])));

return statearr_64348;
})();
var state_64331__$1 = state_64331;
var statearr_64349_64366 = state_64331__$1;
(statearr_64349_64366[(2)] = inst_64326);

(statearr_64349_64366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64332 === (3))){
var inst_64329 = (state_64331[(2)]);
var state_64331__$1 = state_64331;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64331__$1,inst_64329);
} else {
if((state_val_64332 === (4))){
var inst_64311 = (state_64331[(2)]);
var inst_64312 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64313 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64311);
var inst_64314 = [(400),inst_64313];
var inst_64315 = cljs.core.PersistentHashMap.fromArrays(inst_64312,inst_64314);
var inst_64316 = (function (){var G__64351 = conn_id;
var G__64352 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64353 = ref;
var G__64354 = inst_64315;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64351,G__64352,G__64353,G__64354) : flureeworker.worker_action.call(null,G__64351,G__64352,G__64353,G__64354));
})();
var state_64331__$1 = state_64331;
var statearr_64355_64367 = state_64331__$1;
(statearr_64355_64367[(2)] = inst_64316);

(statearr_64355_64367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64332 === (5))){
var ___$1 = (function (){var statearr_64356 = state_64331;
(statearr_64356[(4)] = cljs.core.rest((state_64331[(4)])));

return statearr_64356;
})();
var state_64331__$1 = state_64331;
var ex64350 = (state_64331__$1[(2)]);
var statearr_64357_64368 = state_64331__$1;
(statearr_64357_64368[(5)] = ex64350);


var statearr_64358_64369 = state_64331__$1;
(statearr_64358_64369[(1)] = (4));

(statearr_64358_64369[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2414__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2414__auto____0 = (function (){
var statearr_64359 = [null,null,null,null,null,null,null];
(statearr_64359[(0)] = flureeworker$pw_generate_$_state_machine__2414__auto__);

(statearr_64359[(1)] = (1));

return statearr_64359;
});
var flureeworker$pw_generate_$_state_machine__2414__auto____1 = (function (state_64331){
while(true){
var ret_value__2415__auto__ = (function (){try{while(true){
var result__2416__auto__ = switch__2413__auto__(state_64331);
if(cljs.core.keyword_identical_QMARK_(result__2416__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2416__auto__;
}
break;
}
}catch (e64360){var ex__2417__auto__ = e64360;
var statearr_64361_64370 = state_64331;
(statearr_64361_64370[(2)] = ex__2417__auto__);


if(cljs.core.seq((state_64331[(4)]))){
var statearr_64362_64371 = state_64331;
(statearr_64362_64371[(1)] = cljs.core.first((state_64331[(4)])));

} else {
throw ex__2417__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2415__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64372 = state_64331;
state_64331 = G__64372;
continue;
} else {
return ret_value__2415__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2414__auto__ = function(state_64331){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2414__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2414__auto____1.call(this,state_64331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2414__auto____0;
flureeworker$pw_generate_$_state_machine__2414__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2414__auto____1;
return flureeworker$pw_generate_$_state_machine__2414__auto__;
})()
})();
var state__2438__auto__ = (function (){var statearr_64363 = (f__2437__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2437__auto__.cljs$core$IFn$_invoke$arity$0() : f__2437__auto__.call(null));
(statearr_64363[(6)] = c__2436__auto___64364);

return statearr_64363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2438__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64373_SHARP_){
return (js_array[p1__64373_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e64374){var e = e64374;
var data = (event["data"]);
var error_data = (function (){var temp__5733__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5733__auto__)){
var ex_data = temp__5733__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5735__auto___64375 = cljs.core.not(self.document);
if(temp__5735__auto___64375){
var worker_QMARK__64376 = temp__5735__auto___64375;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__64377_64379 = null;
var G__64378_64380 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__64377_64379,G__64378_64380) : flureeworker.worker_action.call(null,G__64377_64379,G__64378_64380));
